# Dark Souls III Locations

[Game Page] | [Items] | Locations

[Game Page]: /games/Dark%20Souls%20III/info/en
[Items]: /tutorial/Dark%20Souls%20III/items/en

## Table of Contents

* [Location Groups](#location-groups)
* [Understanding Location Names](#understanding-location-names)
  * [HWL: High Wall of Lothric](#high-wall-of-lothric)
  * [US: Undead Settlement](#undead-settlement)
  * [RS: Road of Sacrifices](#road-of-sacrifices)
  * [CD: Cathedral of the Deep](#cathedral-of-the-deep)
  * [FK: Farron Keep](#farron-keep)
  * [CC: Catacombs of Carthus](#catacombs-of-carthus)
  * [SL: Smouldering Lake](#smouldering-lake)
  * [IBV: Irithyll of the Boreal Valley](#irithyll-of-the-boreal-valley)
  * [ID: Irithyll Dungeon](#irithyll-dungeon)
  * [PC: Profaned Capital](#profaned-capital)
  * [AL: Anor Londo](#anor-londo)
  * [LC: Lothric Castle](#lothric-castle)
  * [CKG: Consumed King's Garden](#consumed-kings-garden)
  * [GA: Grand Archives](#grand-archives)
  * [UG: Untended Graves](#untended-graves)
  * [AP: Archdragon Peak](#archdragon-peak)
  * [PW1: Painted World of Ariandel (Before Contraption)](#painted-world-of-ariandel-before-contraption)
  * [PW2: Painted World of Ariandel (After Contraption)](#painted-world-of-ariandel-after-contraption)
  * [DH: Dreg Heap](#dreg-heap)
  * [RC: Ringed City](#ringed-city)
* [Detailed Location Descriptions](#detailed-location-descriptions)

## Location Groups

The Dark Souls III randomizer supports a number of location group names, which
can be used in YAML options like `exclude_locations` to refer to many locations
at once:

* **Prominent:** A small number of locations that are in very obvious locations.
  Mostly boss drops. Ideal for setting as priority locations.

* **Progression:** Locations that contain items in vanilla which unlock other
  locations.

* **Boss Rewards:** Boss drops. Does not include soul transfusions or shop
  items.

* **Miniboss Rewards:** Miniboss drops. Minibosses are large enemies that don't
  respawn after being killed and usually drop some sort of treasure, such as
  Boreal Outrider Knights and Ravenous Crystal Lizards. Only includes enemies
  considered minibosses by the enemy randomizer.

* **Mimic Rewards:** Drops from enemies that are mimics in vanilla.

* **Hostile NPC Rewards:** Drops from NPCs that are hostile to you. This
  includes scripted invaders and initially-friendly NPCs that must be fought as
  part of their quest.

* **Friendly NPC Rewards:** Items given by friendly NPCs as part of their quests
  or from non-violent interaction.

* **Small Crystal Lizards:** Drops from small crystal lizards.

* **Upgrade:** Locations that contain upgrade items in vanilla, including
  titanite, gems, and Shriving Stones.

* **Small Souls:** Locations that contain soul items in vanilla, not including
  boss souls.

* **Boss Souls:** Locations that contain boss souls in vanilla, as well as Soul
  of Rosaria.

* **Unique:** Locations that contain items in vanilla that are unique per NG
  cycle, such as scrolls, keys, ashes, and so on. Doesn't cover equipment,
  spells, or souls.

* **Healing:** Locations that contain Undead Bone Shards and Estus Shards in
  vanilla.

* **Miscellaneous:** Locations that contain generic stackable items in vanilla,
  such as arrows, firebombs, buffs, and so on.

* **Hidden:** Locations that are particularly difficult to find, such as behind
  illusory walls, down hidden drops, and so on. Does not include large locations
  like Untended Graves or Archdragon Peak.

* **Weapons:** Locations that contain weapons in vanilla.

* **Shields:** Locations that contain shields in vanilla.

* **Armor:** Locations that contain armor in vanilla.

* **Rings:** Locations that contain rings in vanilla.

* **Spells:** Locations that contain spells in vanilla.

## Understanding Location Names

All locations begin with an abbreviation indicating their general region. Most
locations have a set of landmarks that are used in location names to keep them
short.

* **FS:** Firelink Shrine
* **FSBT:** Firelink Shrine belltower
* **HWL:** [High Wall of Lothric](#high-wall-of-lothric)
* **US:** [Undead Settlement](#undead-settlement)
* **RS:** [Road of Sacrifices](#road-of-sacrifices)
* **CD:** [Cathedral of the Deep](#cathedral-of-the-deep)
* **FK:** [Farron Keep](#farron-keep)
* **CC:** [Catacombs of Carthus](#catacombs-of-carthus)
* **SL:** [Smouldering Lake](#smouldering-lake)
* **IBV:** [Irithyll of the Boreal Valley](#irithyll-of-the-boreal-valley)
* **ID:** [Irithyll Dungeon](#irithyll-dungeon)
* **PC:** [Profaned Capital](#profaned-capital)
* **AL:** [Anor Londo](#anor-londo)
* **LC:** [Lothric Castle](#lothric-castle)
* **CKG:** [Consumed King's Garden](#consumed-kings-garden)
* **GA:** [Grand Archives](#grand-archives)
* **UG:** [Untended Graves](#untended-graves)
* **AP:** [Archdragon Peak](#archdragon-peak)
* **PW1:** [Painted World of Ariandel (Before Contraption)](#painted-world-of-ariandel-before-contraption)
* **PW2:** [Painted World of Ariandel (After Contraption)](#painted-world-of-ariandel-after-contraption)
* **DH:** [Dreg Heap](#dreg-heap)
* **RC:** [Ringed City](#ringed-city)

General notes:

* "Lizard" always refers to a small crystal lizard.

* "Miniboss" are large enemies that don't respawn after being killed and usually
  drop some sort of treasure, such as Boreal Outrider Knights and Ravenous
  Crystal Lizards.

* NPC quest items are always in the first location you can get them _without_
  killing the NPC or ending the quest early.

### High Wall of Lothric

* **Back tower:** The tower _behind_ the High Wall of Lothric bonfire, past the
  path to the shortcut elevator.

* **Corpse tower:** The first tower after the High Wall of Lothric bonfire, with
  a dead Wyvern on top of it.

* **Fire tower:** The second tower after the High Wall of Lothric bonfire, where
  a living Wyvern lands and breathes fire at you.

* **Flame plaza:** The open area with many items where the Wyvern breathes fire.

* **Wall tower:** The third tower after the High Wall of Lothric bonfire, with
  the Tower on the Wall bonfire.

* **Fort:** The large building after the Tower on the Wall bonfire, with the
  transforming hollow on top.

  * "Entry": The first room you enter after descending the ladder from the roof.

  * "Walkway": The top floor of the tall room, with a path around the edge
    hidden by a large wheel.

  * "Mezzanine": The middle floor of the tall room, with a chest.

  * "Ground": The bottom floor of the tall room, with an anvil and many mobs.

* **Fountain:** The large fountain with many dead knights around it, where the
  Winged Knight patrols in vanilla.

* **Shortcut:** The unlockable path between the promenade and the High Wall of
  Lothric bonfire, including both the elevator and the area at its base.

* **Promenade:** The long, wide path between the two boss arenas.

### Undead Settlement

* **Foot:** The area where you first appear, around the Foot of the High Wall
  bonfire.

* **Burning tree:** The tree near the beginning of the region, with the
  Cathedral Evangelist in front of it in vanilla.

* **Hanging corpse room:** The dark room to the left of the burning tree with
  many hanging corpses inside, on the way to the Dilapidated Bridge bonfire.

* **Back alley:** The path between buildings leading to the Dilapidated Bridge
  bonfire.

* **Stable:** The building complex across the bridge to the right of the burning
  tree.

* **White tree:** The birch tree by the Dilapidated Bridge bonfire, where the
  giant shoots arrows.

* **Sewer:** The underground passage between the chasm and the Dilapidated
  Bridge bonfire.

* **Chasm:** The chasm underneath the bridge on the way to the tower. It's
  possible to get into the chasm without a key by dropping down next to Eygon of
  Carim with a full health bar.

* **Tower:** The tower at the end of the region with the giant archer at the
  top.

* **Tower village:** The village reachable from the tower, where the Fire Demon
  patrols in vanilla.

### Road of Sacrifices

The area after the Crystal Sage is considered part of the Cathedral of the Deep
region.

* **Road:** The path from the Road of Sacrifices bonfire to the Halfway Fortress
  bonfire.

* **Woods:** The wooded area on land, after the Halfway Fortress bonfire and
  surrounding the Crucifixion Woods bonfire.

* **Water:** The watery area, covered in crabs in vanilla.

* **Deep water:** The area in the water near the ladder to Farron Keep, where
  your walking is slowed.

* **Stronghold:** The stone building complex on the way to Crystal Sage.

  * "Left room" is the room whose entrance is near the Crucifixion Woods
    bonfire.
  
  * "Right room" is the room up the stairs closer to Farron Keep.

* **Keep perimeter:** The building with the Black Knight and the locked door to
  the Farron Keep Perimeter bonfire.

### Cathedral of the Deep

* **Path:** The path from Road of Sacrifices to the cathedral proper.

* **Moat:** The circular path around the base of the front of the
  cathedral, with the Ravenous Crystal Lizard and Corpse-Grubs in vanilla.

* **Graveyard:** The area with respawning enemies up the hill from the Cleansing
  Chapel bonfire.

* **White tree:** The birch tree below the front doors of the chapel and across
  the moat from the graveyard, where the giant shoots arrows if he's still
  alive.

* **Lower roofs:** The roofs, flying buttresses, and associated areas to the
  right of the front door, which must be traversed before entering the
  cathedral.

* **Upper roofs:** The roofs, flying buttresses, and rafters leading to the
  Rosaria's Bedchamber bonfire.

* **Main hall:** The central and largest room in the cathedral, with the muck
  that slows your movement. Divided into the south (with the sleeping giant in
  vanilla) and east (with many items) wings, with north pointing towards the
  door to the boss.

* **Side chapel:** The room with rows of pews and the patrolling Cathedral
  Knight in vanilla, to the side of the main hall.

### Farron Keep

* **Left island:** The large island with the ritual flame, to the left as you
  leave the Farron Keep bonfire.

* **Right island:** The large island with the ritual flame, to the right as you
  leave the Farron Keep bonfire.

* **Hidden cave:** A small cave in the far corner of the map, closest to the
  right island. Near a bunch of basilisks in vanilla.

* **Keep ruins:** The following two islands:

  * "Bonfire island": The island with the Keep Ruins bonfire.
  * "Ritual island": The island with one of the three ritual fires.

* **White tree**: The birch tree by the ramp down from the keep ruins bonfire
  island, where the giant shoots arrows if he's still alive.

* **Keep proper:** The building with the Old Wolf of Farron bonfire.

* **Upper keep:** The area on top of the keep proper, reachable from the
  elevator from the Old Wolf of Farron bonfire.

* **Perimeter:** The area from near the Farron Keep Perimeter bonfire, including
  the stone building and the path to the boss.

### Catacombs of Carthus

All the area up to the Small Doll wall into Irithyll is considered part of the
Catacombs of Carthus region.

* **Atrium:** The large open area you first enter and the rooms attached to it.

  * "Upper" is the floor you begin on.
  * "Lower" is the floor down the short stairs but at the top of the long
    stairway that the skeleton ball rolls down.

* **Crypt:** The enclosed area at the bottom of the long stairway that the
  skeleton ball rolls down.

  * "Upper" is the floor the long stairway leads to that also contains the
    Catacombs of Carthus bonfire.
  * "Lower" is the floor with rats and bonewheels in vanilla.
  * "Across" is the area reached by going up the set of stairs across from
    the entrance downstairs.

* **Cavern:** The even larger open area past the crypt with the rope bridge to
  the boss arena.

* **Tomb:** The area on the way to Smouldering Lake, reachable by cutting down
  the rope bridge and climbing down it.

* **Irithyll Bridge:** The outdoor bridge leading to Irithyll of the Boreal
  Valley.

### Smouldering Lake

* **Lake:** The watery area you enter initially, where you get shot at by the
  ballista.

* **Side lake:** The small lake accessible via a passage from the larger one, in
  which you face Horace the Hushed as part of his quest.

* **Ruins main:** The area you first enter after the Demon Ruins bonfire.

  * "Upper" is the floor you begin on.
  * "Lower" is the floor down the stairs.

* **Antechamber:** The area up the flight of stairs near the 
Old King's Antechamber bonfire.

* **Ruins basement:** The area further down from ruins main lower, with many
  basilisks and Knight Slayer Tsorig in vanilla.

### Irithyll of the Boreal Valley

This region starts _after_ the Small Doll wall and ends with Pontiff Sulyvahn.
Everything after that, including the contents of Sulyvahn's cathedral is
considered part of Anor Londo.

* **Central:** The beginning of the region, from the Central Irithyll bonfire up
  to the plaza.
  
* **Dorhys:** The sobbing mob (a Cathedral Evangelist in vanilla) behind the
  locked door opening onto central. Accessed through an illusory railing by the
  crystal lizard just before the plaza.

* **Plaza:** The area in front of and below the cathedral, with a locked door up
  to the cathedral and a locked elevator to the Ascent.

* **Descent:** The path from the Church of Yorshka bonfire down to the lake.

* **Lake:** The open watery area outside the room with the Distant Manor
  bonfire.

* **Sewer:** The room between the lake and the beginning of the ascent, filled
  with Sewer Centipedes in vanilla.

* **Ascent:** The path up from the lake to the cathedral, through several
  buildings and some open stairs.

* **Great hall:** The building along the ascent with a large picture of
  Gwynevere and several Silver Knights in vanilla.

### Irithyll Dungeon

In Irithyll Dungeon locations, "left" and "right" are always oriented as though
"near" is where you stand and "far" is where you're facing. (For example, you
enter the dungeon from the bonfire on the near left.)

* **B1:** The floor on which the player enters the dungeon, with the Irithyll
  Dungeon bonfire.
  
  * "Near" is the side of the dungeon with the bonfire.
  * "Far" is the opposite side.

* **B2:** The floor directly below B1, which can be reached by going down the
  stairs or dropping.
  
  * "Near" is the same side of the dungeon as the bonfire.
  * "Far" is the opposite side.

* **Pit:** The large room with the Giant Slave and many Rats in vanilla.

* **Pit lift:** The elevator from the pit up to B1 near, right to the Irithyll
  Dungeon bonfire.

* **B3:** The lowest floor, with Karla's cell, a lift back to B2, and the exit
  onwards to the Profaned Capital.
  
  * "Near" is the side with Karla's cell and the path from the pit.
  * "Far" is the opposite side with the mimic.

* **B3 lift:** The elevator from B3 (near where you can use Path of the Dragon
  to go to Archdragon Peak) up to B2.

### Profaned Capital

* **Tower:** The tower that contains the Profaned Capital bonfire.

* **Swamp:** The pool of toxic liquid accessible by falling down out of the
  lower floor of the tower, going into the corridor to the left, and falling
  down a hole.

* **Chapel:** The building in the swamp containing Monstrosities of Sin in
  vanilla.

* **Bridge:** The long bridge from the tower into the palace.

* **Palace:** The large building carved into the wall of the cavern, full of
  chalices and broken pillars.

### Anor Londo

This region includes everything after Sulyvahn's cathedral, including its upper
story.

* **Light cathedral:** The cathedral in which you fight Pontiff Sulyvahn in
  vanilla.

* **Plaza:** The wide open area filled with Giant Slaves in vanilla.

* **Walkway:** The path above the plaza leading to the second floor of the light
  cathedral, with Deacons in vanilla.

* **Buttresses:** The flying buttresses that you have to climb to get to the
  spiral staircase. "Near" and "far" are relative to the light cathedral, so the
  nearest buttress is the one that leads back to the walkway.

* **Tomb:** The area past the illusory wall just before the spiral staircase, in
  which you marry Anri during Yoel and Yuria's quest.

* **Dark cathedral:** The darkened cathedral just before the Aldrich fight in
  vanilla.

### Lothric Castle

This region covers everything up the ladder from the Dancer of the Boreal Valley
bonfire up to the door into Grand Archives, except the area to the left of the
ladder which is part of Consumed King's Garden.

* **Lift:** The elevator from the room straight after the Dancer of the Boreal
  Valley bonfire up to just before the boss fight.

* **Ascent:** The set of stairways and turrets leading from the Lothric Castle
  bonfire to the Dragon Barracks bonfire.

* **Barracks:** The large building with two fire-breathing wyverns across from
  the Dragon Barracks bonfire.

* **Moat:** The ditch beneath the bridge leading to the barracks.

  * The "right path" leads to the right as you face the barracks, around and
    above the stairs up to the Dragon Barracks bonfire.

* **Plaza:** The open area in the center of the barracks, where the two wyverns
  breathe fire.
  
  * "Left" is the enclosed area on the left as you're coming from the Dragon
    Barracks bonfire, with the stairs down to the basement.

* **Basement:** The room beneath plaza left, with the Boreal Outrider in
  vanilla.

* **Dark room:** The large darkened room on the right of the barracks as you're
  coming from the Dragon Barracks bonfire, with firebomb-throwing Hollows in
  vanilla.
  
  * "Lower" is the bottom floor that you enter onto from the plaza.
  * "Upper" is the top floor with the door to the main hall.
  * "Mid" is the middle floor accessible by climbing a ladder from lower or
    going down stairs from upper.

* **Main hall:** The central room of the barracks, behind the gate.

* **Chapel:** The building to the right just before the stairs to the boss, with
  a locked elevator to Grand Archives.

* **Wyvern room:** The room where you can fight the Pus of Man infecting the
  left wyvern, accessible by dropping down to the left of the stairs to the
  boss.

* **Altar:** The building containing the Altar of Sunlight, accessible by
  climbing up a ladder onto a roof around the corner from the stairs to the
  boss.

### Consumed King's Garden

This region covers everything to the left of the ladder up from the Dancer of
the Boreal Valley bonfire up to the illusory wall into Untended Graves.

* **Balcony:** The walkway accessible by getting off the first elevator halfway
  down.

* **Rotunda:** The building in the center of the toxic pool, with a Cathedral
  Knight on it in vanilla.

* **Lone stairway:** A set of stairs leading nowhere in the far left of the main
  area as you enter from the first elevator.

* **Shortcut:** The path from the locked door into Lothric Castle, through the
  room filled with thralls in vanilla, and down a lift.

* **Tomb:** The area after the boss room.

### Grand Archives

* **1F:** The first floor of the Grand Archives, including the first wax pool.

* **Dark room:** The unlit room on 1F to the right of the wax pool.

* **2F:** The second floor of the grand archives. It's split into two sections
  that are separated by retractable bookshelves.

  * "Early" is the first part you reach and has an outdoor balcony with a ladder
    to 3F and a wax pool up a short set of stairs.
  * "Late" is the part you can only reach by climbing down from F3, where you
    encounter the teleporting miniboss for the final time.

* **3F:** The third floor of the grand archives, where you encounter the
  teleporting miniboss for the second time. Includes the area with a hidden room
  with another miniboss.

* **4F:** The topmost and most well-lit section of bookshelves, overlooking the
  rest of the archives.

* **Rooftops:** The outer rooftop area between 4F and 5F, with Gargoyles in
  vanilla.

  * "Lower" is the balcony you can reach by dropping off the rooftops, as well
    as the further rooftops leading down to the 2F early balcony.

* **5F:** The topmost floor of the archives interior, accessible from the
  rooftops, with a ladder down to 4F.

* **Dome:** The domed roof of the Grand Archives, with Ascended Winged Knights
  in vanilla.

* **Rafters:** The narrow walkways above the Grand Archives, accessible by
  dropping down from the dome.

### Untended Graves

* **Swamp:** The watery area immediately after the Untended graves bonfire, up
  to the cemetery.

* **Cemetery:** The area past where the Cemetery of Ash bonfire would be, up to
  the boss arena.

* **Environs:** The area after the boss and outside the abandoned Firelink
  Shrine.

* **Shrine:** The area inside the abandoned Firelink Shrine.

### Archdragon Peak

"Gesture" always means the Path of the Dragon gesture.

* **Intro:** The first section, from where you warp in from Irithyll Dungeon up
  to the first boss fight.

  * "Archway": The large stone archway in front of the boss door.

* **Fort:** The arena where you fight Ancient Wyvern in vanilla.

  * "Overlook": The area down the stairs from where the Ancient Wyvern first
    lands in vanilla, overlooking the fog.

  * "Rotunda": The top of the spiral staircase building, to the left before the
    bridge with the chain-axe Man-Serpent in vanilla.

* **Mausoleum:** The building with the Dragon-Kin Mausoleum bonfire, where
  you're warped after the first boss fight.

* **Walkway:** The path from the mausoleum to the belfry, looking out over
  clouds.
  
  * "Building": The building along the walkway, just before the wyvern in
    vanilla.

* **Belfry:** The building with the Great Belfry bonfire, including the room
  with the summoner.

* **Plaza:** The arena that appears after you defeat Nameless King in vanilla.

* **Summit:** The path up from the belfry to the final altar at the top of the
  mountain.

### Painted World of Ariandel (Before Contraption)

This region covers the Ashes of Ariandel DLC up to the point where you must use
the Contraption Key to ascend to the second level of the building and first meet
the painter.

* **Snowfield:** The area around the Snowfield bonfire,

  * "Upper": The area immediately after the Snowfield bonfire, before the
    collapsing overhang, with the Followers in vanilla.

  * "Lower": The snowy tree-filled area after the collapsing overhang, with the
    Wolves in vanilla.

  * "Village": The area with broken-down buildings and Millwood Knights in
    vanilla.

  * "Tower": The tower by the village, with Millwood Knights in Vanilla.

* **Bridge:** The rope bridge to the chapel.

  * "Near": The side of the bridge by the Rope Bridge Cave bonfire.

  * "Far": The side of the bridge by the Ariandel Chapel bonfire.

* **Chapel:** The building with the Ariandel Chapel bonfire and Lady Friede.

* **Depths:** The area reachable by cutting down the bridge and descending on
  the far side, with the Depths of the Painting bonfire.

* **Settlement:** The area reachable by cutting down the bridge and descending
  on the near side, with the Corvian Settlement bonfire. Everything after the
  slide down the hill is considered part of the settlement.

  * "Courtyard": The area in front of the settlement, immediately after the
    slide.

  * "Main": The main road of the settlement leading up to the locked gate to the
    library. Also includes the buildings that are immediately accessible from
    this road.

  * "Loop": A side path that loops left from the main road and goes up and
    behind the building with the bonfire.

  * "Back": The back alley of the settlement, accessible by dropping down to the
    right of the locked gate to the library. Also includes the buildings that
    are immediately accessible from this alley.

  * "Roofs": The village rooftops, first accessible by climbing a ladder from
    the back alley. Also includes the buildings and items that are first
    accessible from the roofs.

  * "Hall": The largest building in the settlement, with two Corvian Knights in
    vanilla.

* **Library:** The building where you use the contraption key, where Vilhelm
  appears in vanilla.

### Painted World of Ariandel (After Contraption)

This region covers the Ashes of Ariandel DLC past the point where you must use
the Contraption Key to ascend to the second level of the building and first meet
the painter, including the basement beneath the chapel.

* **Pass:** The mountainous area past the Snowy Mountain Pass bonfire.

* **Pit:** The area with a large tree and numerous Millwood Knights in vanilla,
  reached by a collapsing overhang in the pass.

* **B1:** The floor immediately below the chapel, first accessible from the
  pass. Filled with Giant Flies in vanilla.

* **B2:** The floor below B1, with lots of fly eggs. Filled with even more Giant
  Flies than B1 in vanilla.

* **B3:** The floor below B2, accessible through an illusory wall.

* **Rotunda:** The round arena out in the open, accessible by platforming down
  tree roots from B3.

### Dreg Heap

* **Shop:** Items sold by the Stone-Humped Hag by The Dreg Heap bonfire.

* **Castle:** The building with The Dreg Heap bonfire, up to the large fall into
  the library.

* **Library:** The building with the stained-glass window that you fall into
  from the castle.

* **Church:** The building below and to the right of the library, which the
  pillar falls into to make a bridge.

* **Pantry:** The set of rooms entered through a door near the fountain just
  past the church, with boxes and barrels.
  
  * "Upstairs": The room with an open side, accessible through an illusory wall
    in the furthest pantry room.

* **Parapets:** The area with balconies and Overgrown Lothric Knights in
  vanilla, accessible by taking the pillar bridge from the church, following
  that path to the end, and dropping down to the right.

* **Ruins:** The area around the Earthen Peak Ruins bonfire, up to the swamp.

* **Swamp:** The area in and above the poisonous water, up to the point the
  branches deposit you back on the ruins.

  * "Left": Left as you enter from the ruins, towards the cliff edge.

  * "Right": Right as you enter from the ruins, towards higher ground.

  * "Upper": The path up and over the swamp towards the Within Earthen Peak
    Ruins bonfire.

### Ringed City

The "mid boss", "end boss", and "hidden boss" are the bosses who take the place
of Halflight, Gael, and Midir, respectively.

* **Wall:** The large wall in which you spawn when you first enter the area,
  with the Mausoleum Lookout bonfire.

  * "Top": The open-air top of the wall, where you first spawn in.

  * "Upper": The upper area of the wall, with the Ringed Inner Wall bonfire.

  * "Tower": The tiered tower leading down from the upper area to the stairs.

  * "Lower": The lower rooms of the wall, accessible from the lower cliff, with
    an elevator back to upper.

  * "Hidden": The hidden floor accessible from the elevator from lower to upper,
    from which you can reach Midir in vanilla.

* **Streets:** The streets and skyways of the city proper. "Left" and "right"
  are relative to the main staircase as you head down towards the swamp, "near"
  and "far" are relative to Shira's chamber at the top of the stairs.

  * "Garden": The flower-filled back alley accessible from the left side of the
    nearest bridge over the stairs.

  * "High": The higher areas in the far left where you can find the Locust
    Preacher, accessible from a long ladder in the swamp.

  * "Monument": The area around the purging monument, which can only be accessed
    by solving the "Show Your Humanity" puzzle.

* **Swamp:** The wet area past the city streets. "Left" and "right" are relative
  to heading out from the Ringed City Streets bonfire, and "near" and "far" are
  relative to that bonfire as well.

* **Lower cliff:** The cliffside path leading from the swamp into the shared
  grave, where Midir breathes fire.

* **Grave:** The cylindrical chamber with spiral stairs around the edges,
  connecting the two cliffs, containing the Shared Grave bonfire.

* **Upper cliff:** The cliffside path leading out of the grave to the lower
  wall.

* **Church path:** The sunlit path from the lower cliff up to the Church of
  Filianore where you fight Halflight in vanilla.

* **Ashes:** The final area, where you fight Gael in vanilla.

## Detailed Location Descriptions

These location descriptions were originally written by [Matt Gruen] for [the
static _Dark Souls III_ randomizer].

[Matt Gruen]: https://thefifthmatt.com/
[the static _Dark Souls III_ randomizer]: https://www.nexusmods.com/darksouls3/mods/361

<!-- This table is automatically generated by the detailed_location_descriptions.py script. -->

<!-- begin location table -->
<table><tr><th>Location name</th><th>Detailed description</th>
<tr><td>AL: Aldrich Faithful - water reserves, talk to McDonnel</td><td>Given by Archdeacon McDonnel in Water Reserves.</td></tr>
<tr><td>AL: Aldrich&#x27;s Ruby - dark cathedral, miniboss</td><td>Dropped by the Deep Accursed who drops down when you open the Anor Londo Cathedral shortcut</td></tr>
<tr><td>AL: Anri&#x27;s Straight Sword - Anri quest</td><td>Dropped by Anri of Astora upon death or completing quest. In the Darkmoon Tomb with Lord of Hollows route, or given by Ludleth if summoned to defeat Aldrich.</td></tr>
<tr><td>AL: Blade of the Darkmoon - Yorshka with Darkmoon Loyalty</td><td>Given by Yorshka after learning the Darkmoon Loyalty gesture from Sirris, or by killing her</td></tr>
<tr><td>AL: Brass Armor - tomb</td><td>Behind the illusory statue in the hallway leading to the Darkmoon Tomb</td></tr>
<tr><td>AL: Brass Gauntlets - tomb</td><td>Behind the illusory statue in the hallway leading to the Darkmoon Tomb</td></tr>
<tr><td>AL: Brass Helm - tomb</td><td>Behind the illusory statue in the hallway leading to the Darkmoon Tomb</td></tr>
<tr><td>AL: Brass Leggings - tomb</td><td>Behind the illusory statue in the hallway leading to the Darkmoon Tomb</td></tr>
<tr><td>AL: Chameleon - tomb after marrying Anri</td><td>Dropped by the Stone-humped Hag assassin after Anri reaches the Church of Yorshka, either in the church or after marrying Anri</td></tr>
<tr><td>AL: Cinders of a Lord - Aldrich</td><td>Dropped by Aldrich</td></tr>
<tr><td>AL: Crescent Moon Sword - Leonhard drop</td><td>Drop by Ringfinger Leonhard upon death. Includes Soul of Rosaria if invaded in Anor Londo.</td></tr>
<tr><td>AL: Dark Stoneplate Ring - by dark stairs up from plaza</td><td>After the Pontiff fight, in the dark hallways to the left of the area with the Giant Slaves</td></tr>
<tr><td>AL: Deep Gem - water reserves</td><td>In the open in the Water Reserves</td></tr>
<tr><td>AL: Dragonslayer Greatarrow - drop from nearest buttress</td><td>Dropping down from about halfway down the flying buttress closest to the entrance to the Darkmoon Tomb</td></tr>
<tr><td>AL: Dragonslayer Greatbow - drop from nearest buttress</td><td>Dropping down from about halfway down the flying buttress closest to the entrance to the Darkmoon Tomb</td></tr>
<tr><td>AL: Drang Twinspears - plaza, NPC drop</td><td>Dropped by Drang Twinspears-wielding knight on the stairs leading up to the Anor Londo Silver Knights</td></tr>
<tr><td>AL: Easterner&#x27;s Ashes - below top of furthest buttress</td><td>Dropping down from the rightmost flying buttress, or the rightmost set of stairs</td></tr>
<tr><td>AL: Ember - plaza, further</td><td>After the Pontiff fight, in the middle of the area with the Giant Slaves</td></tr>
<tr><td>AL: Ember - plaza, right side</td><td>After the Pontiff fight, next to one of the Giant Slaves on the right side</td></tr>
<tr><td>AL: Ember - spiral staircase, bottom</td><td>Next to the lever that summons the rotating Anor Londo stairs at the bottom</td></tr>
<tr><td>AL: Estus Shard - dark cathedral, by left stairs</td><td>In a chest on the floor of the Anor Londo cathedral</td></tr>
<tr><td>AL: Giant&#x27;s Coal - by giant near dark cathedral</td><td>On the Giant Blacksmith&#x27;s corpse in Anor Londo</td></tr>
<tr><td>AL: Golden Ritual Spear - light cathedral, mimic upstairs</td><td>Drop from a mimic in the higher levels of Pontiff&#x27;s cathedral, accessible from the Deacons after the Pontiff fight</td></tr>
<tr><td>AL: Havel&#x27;s Ring+2 - prison tower, rafters</td><td>On the rafters dropping down from Yorshka&#x27;s Prison Tower to the Church of Yorshka</td></tr>
<tr><td>AL: Human Dregs - water reserves</td><td>In the open in the Water Reserves</td></tr>
<tr><td>AL: Large Soul of a Weary Warrior - left of dark cathedral entrance</td><td>In front of the Anor Londo cathedral, slightly to the left</td></tr>
<tr><td>AL: Large Titanite Shard - balcony by dead giants</td><td>After the Pontiff fight, on the balcony to the right of the area with the Giant Slaves</td></tr>
<tr><td>AL: Large Titanite Shard - bottom of the furthest buttress</td><td>At the base of the rightmost flying buttress leading up to Anor Londo</td></tr>
<tr><td>AL: Large Titanite Shard - bottom of the nearest buttress</td><td>On the tower leading back from Anor Londo to the shortcut to Irithyll, down the flying buttress closest to the Darkmoon Tomb entrance.</td></tr>
<tr><td>AL: Large Titanite Shard - right after light cathedral</td><td>After Pontiff&#x27;s cathedral, hugging the wall to the right</td></tr>
<tr><td>AL: Large Titanite Shard - walkway, side path by cathedral</td><td>After the Pontiff fight, going back from the Deacons area to the original cathedral, before a dropdown</td></tr>
<tr><td>AL: Moonlight Arrow - dark cathedral, up right stairs</td><td>In the Anor Londo cathedral, up the stairs on the right side</td></tr>
<tr><td>AL: Painting Guardian Gloves - prison tower, rafters</td><td>On the rafters dropping down from Yorshka&#x27;s Prison Tower to the Church of Yorshka</td></tr>
<tr><td>AL: Painting Guardian Gown - prison tower, rafters</td><td>On the rafters dropping down from Yorshka&#x27;s Prison Tower to the Church of Yorshka</td></tr>
<tr><td>AL: Painting Guardian Hood - prison tower, rafters</td><td>On the rafters dropping down from Yorshka&#x27;s Prison Tower to the Church of Yorshka</td></tr>
<tr><td>AL: Painting Guardian Waistcloth - prison tower, rafters</td><td>On the rafters dropping down from Yorshka&#x27;s Prison Tower to the Church of Yorshka</td></tr>
<tr><td>AL: Painting Guardian&#x27;s Curved Sword - prison tower rafters</td><td>On the rafters dropping down from Yorshka&#x27;s Prison Tower to the Church of Yorshka</td></tr>
<tr><td>AL: Proof of a Concord Kept - dark cathedral, up left stairs</td><td>In the Anor Londo cathedral, halfway down the stairs on the left side next to some Deacons</td></tr>
<tr><td>AL: Reversal Ring - tomb, chest in corner</td><td>In a chest in Darkmoon Tomb</td></tr>
<tr><td>AL: Ring of Favor - water reserves, both minibosses</td><td>Dropped after killing both of Sulyvahn&#x27;s Beasts in the Water Reserves</td></tr>
<tr><td>AL: Ring of Favor+1 - light cathedral, upstairs</td><td>In the higher levels of Pontiff&#x27;s cathedral, accessible from the Deacons after the Pontiff fight</td></tr>
<tr><td>AL: Silver Mask - Leonhard drop</td><td>Drop by Ringfinger Leonhard upon death. Includes Soul of Rosaria if invaded in Anor Londo.</td></tr>
<tr><td>AL: Simple Gem - light cathedral, lizard upstairs</td><td>Dropped by a Crystal Lizard in the higher levels of Pontiff&#x27;s cathedral, accessible from the Deacons after the Pontiff fight</td></tr>
<tr><td>AL: Soul of Aldrich</td><td>Dropped by Aldrich</td></tr>
<tr><td>AL: Soul of Rosaria - Leonhard drop</td><td>Drop by Ringfinger Leonhard upon death. Includes Soul of Rosaria if invaded in Anor Londo.</td></tr>
<tr><td>AL: Soul of a Crestfallen Knight - right of dark cathedral entrance</td><td>To the right of the Anor Londo cathedral entrance, past the red-eyed Silver Knight</td></tr>
<tr><td>AL: Soul of a Weary Warrior - plaza, nearer</td><td>After the Pontiff fight, in the middle of the area with the Giant Slaves</td></tr>
<tr><td>AL: Sun Princess Ring - dark cathedral, after boss</td><td>In the Anor Londo cathedral after defeating Aldrich, up the elevators in Gwynevere&#x27;s Chamber</td></tr>
<tr><td>AL: Titanite Scale - top of ladder up to buttresses</td><td>On the platform after the stairs leading up to Anor Londo from the Water Reserves building</td></tr>
<tr><td>AL: Twinkling Titanite - lizard after light cathedral #1</td><td>Dropped a Crystal Lizard straight after the Pontiff fight</td></tr>
<tr><td>AL: Twinkling Titanite - lizard after light cathedral #2</td><td>Dropped a Crystal Lizard straight after the Pontiff fight</td></tr>
<tr><td>AL: Yorshka&#x27;s Chime - kill Yorshka</td><td>Dropped by Yorshka upon death.</td></tr>
<tr><td>AP: Ancient Dragon Greatshield - intro, on archway</td><td>After the Archdragon Peak bonfire, on top of the arch in front of the Ancient Wyvern fight</td></tr>
<tr><td>AP: Calamity Ring - mausoleum, gesture at altar</td><td>Received using Path of the Dragon at the Altar by the Mausoleum bonfire</td></tr>
<tr><td>AP: Covetous Gold Serpent Ring+2 - plaza</td><td>In the Nameless King boss arena after he is defeated</td></tr>
<tr><td>AP: Dragon Chaser&#x27;s Ashes - summit, side path</td><td>In the run-up to the Dragon Altar after the Belfry bonfire, in a side path to the left side</td></tr>
<tr><td>AP: Dragon Head Stone - fort, boss drop</td><td>Dropped by Ancient Wyvern</td></tr>
<tr><td>AP: Dragon Tooth - belfry roof, NPC drop</td><td>Dropped from any of the Havel Knights</td></tr>
<tr><td>AP: Dragonslayer Armor - plaza</td><td>In the Nameless King boss arena after he is defeated</td></tr>
<tr><td>AP: Dragonslayer Gauntlets - plaza</td><td>In the Nameless King boss arena after he is defeated</td></tr>
<tr><td>AP: Dragonslayer Helm - plaza</td><td>In the Nameless King boss arena after he is defeated</td></tr>
<tr><td>AP: Dragonslayer Leggings - plaza</td><td>In the Nameless King boss arena after he is defeated</td></tr>
<tr><td>AP: Dragonslayer Spear - gate after mausoleum</td><td>In the gate connecting the Dragon-Kin Mausoleum area to the bridge where the Nameless King fight takes place</td></tr>
<tr><td>AP: Drakeblood Greatsword - mausoleum, NPC drop</td><td>Dropped by the Drakeblood Knight summoned by the Serpent-Man Summoner</td></tr>
<tr><td>AP: Dung Pie - fort, landing after second room</td><td>On a landing going up the stairs from the Ancient Wyvern to the chainaxe Man-Serpent area</td></tr>
<tr><td>AP: Ember - belfry, below bell</td><td>In the area below the bell lever, either dropping down near the lever or going down the stairs from the open fountain area after the Belfry bonfire</td></tr>
<tr><td>AP: Ember - fort overlook #1</td><td>From the right of where Ancient Wyvern first lands</td></tr>
<tr><td>AP: Ember - fort overlook #2</td><td>From the right of where Ancient Wyvern first lands</td></tr>
<tr><td>AP: Ember - intro, by bonfire</td><td>Next to the Archdragon Peak bonfire</td></tr>
<tr><td>AP: Great Magic Barrier - drop off belfry roof</td><td>Dropping down to the left from the area with the Havel Knight and the dead Wyvern</td></tr>
<tr><td>AP: Havel&#x27;s Greatshield - belfry roof, NPC drop</td><td>Dropped from any of the Havel Knights</td></tr>
<tr><td>AP: Havel&#x27;s Ring+1 - summit, after building</td><td>Just past the building with all of the Man-Serpents on the way to the Dragon Altar, on the left side</td></tr>
<tr><td>AP: Homeward Bone - intro, path to bonfire</td><td>From the start of the area, along the left path leading to the first bonfire</td></tr>
<tr><td>AP: Large Soul of a Crestfallen Knight - summit, by fountain</td><td>In the middle of the open fountain area after the Belfry bonfire</td></tr>
<tr><td>AP: Large Soul of a Nameless Soldier - fort, by stairs to first room</td><td>to the left of where the Ancient Wyvern lands</td></tr>
<tr><td>AP: Large Soul of a Weary Warrior - fort, center</td><td>Where the Ancient Wyvern lands</td></tr>
<tr><td>AP: Lightning Bolt - rotunda</td><td>On top of the ruined dome found going up spiral stairs to the left before the bridge with the chainaxe Man-Serpent</td></tr>
<tr><td>AP: Lightning Clutch Ring - intro, left of boss door</td><td>To the left of gate leading to Ancient Wyvern, past the Rock Lizard</td></tr>
<tr><td>AP: Lightning Gem - intro, side rise</td><td>From the start of the area, up a ledge in between two forked paths toward the first bonfire</td></tr>
<tr><td>AP: Lightning Urn - fort, left of first room entrance</td><td>On the path to the left of where the Ancient Wyvern lands, left of the building entrance</td></tr>
<tr><td>AP: Ricard&#x27;s Rapier - belfry, NPC drop</td><td>Dropped by the Richard Champion summoned by the Serpent-Man Summoner</td></tr>
<tr><td>AP: Ring of Steel Protection - fort overlook, beside stairs</td><td>To the right of the area where the Ancient Wyvern lands, dropping down onto the ledge</td></tr>
<tr><td>AP: Soul of a Crestfallen Knight - mausoleum, upstairs</td><td>From the Mausoleum bonfire, up the second set of stairs to the right</td></tr>
<tr><td>AP: Soul of a Nameless Soldier - intro, right before archway</td><td>From the Archdragon Peak bonfire, going right before the arch before Ancient Wyvern</td></tr>
<tr><td>AP: Soul of a Weary Warrior - intro, first cliff edge</td><td>At the very start of the area on the left cliff edge</td></tr>
<tr><td>AP: Soul of a Weary Warrior - walkway, building window</td><td>On the way to the Belfry bonfire after the sagging wooden bridge, on a ledge visible in a room with a Crystal Lizard, accessible by a tricky jump or just going around the other side</td></tr>
<tr><td>AP: Soul of the Nameless King</td><td>Dropped by Nameless King</td></tr>
<tr><td>AP: Stalk Dung Pie - fort overlook</td><td>From the right of where Ancient Wyvern first lands</td></tr>
<tr><td>AP: Thunder Stoneplate Ring - walkway, up ladder</td><td>After the long hallway after the Mausoleum bonfire, before the rope bridge, up the long ladder</td></tr>
<tr><td>AP: Titanite Chunk - fort, second room balcony</td><td>After going left of where Ancient Wyvern lands and left again, rather than going up the stairs to the right, go to the open area to the left</td></tr>
<tr><td>AP: Titanite Chunk - intro, archway corner</td><td>From the Archdragon Peak bonfire, under the arch, immediately to the right</td></tr>
<tr><td>AP: Titanite Chunk - intro, behind rock</td><td>Almost at the Archdragon Peak bonfire, behind a rock in the area with many Man-Serpents</td></tr>
<tr><td>AP: Titanite Chunk - intro, left before archway</td><td>After the Archdragon Peak bonfire, going left before the arch before Ancient Wyvern</td></tr>
<tr><td>AP: Titanite Chunk - rotunda</td><td>On top of the ruined dome found going up spiral stairs to the left before the bridge with the chainaxe Man-Serpent</td></tr>
<tr><td>AP: Titanite Chunk - walkway, miniboss drop</td><td>Dropped by the second Ancient Wyvern patrolling the path up to the Belfry</td></tr>
<tr><td>AP: Titanite Scale - mausoleum, downstairs balcony #1</td><td>From the Mausoleum bonfire, up the stairs to the left, past the Rock Lizard</td></tr>
<tr><td>AP: Titanite Scale - mausoleum, downstairs balcony #2</td><td>From the Mausoleum bonfire, up the stairs to the left, past the Rock Lizard</td></tr>
<tr><td>AP: Titanite Scale - mausoleum, upstairs balcony</td><td>From the Mausoleum bonfire, up the first stairs to the right, going around toward the Man-Serpent Summoner, on the balcony on the side</td></tr>
<tr><td>AP: Titanite Scale - walkway building</td><td>In a chest after the sagging wooden bridge on the way to the Belfry, in the building with the Crystal Lizard</td></tr>
<tr><td>AP: Titanite Scale - walkway, miniboss drop</td><td>Dropped by the second Ancient Wyvern patrolling the path up to the Belfry</td></tr>
<tr><td>AP: Titanite Slab - belfry roof</td><td>Next to the Havel Knight by the dead Wyvern</td></tr>
<tr><td>AP: Titanite Slab - plaza</td><td>In the Nameless King boss arena after he is defeated</td></tr>
<tr><td>AP: Twinkling Dragon Torso Stone - summit, gesture at altar</td><td>Received using Path of the Dragon at the Altar after the Belfry bonfire. Hawkwood also uses the gesture there when summoned.</td></tr>
<tr><td>AP: Twinkling Titanite - belfry, by ladder to roof</td><td>In the chest before the ladder climbing up to the Havel Knight</td></tr>
<tr><td>AP: Twinkling Titanite - fort, down second room balcony ladder</td><td>After going left of where Ancient Wyvern lands and left again, rather than going up the stairs to the right, go to the open area to the left and then down the ladder</td></tr>
<tr><td>AP: Twinkling Titanite - fort, end of rafters</td><td>Dropping down to the left of the Mausoleum bonfire, all the way down the wooden rafters</td></tr>
<tr><td>AP: Twinkling Titanite - walkway building, lizard</td><td>Dropped by Crystal Lizard in the building after the sagging wooden bridge toward the Belfry</td></tr>
<tr><td>AP: Twinkling Titanite - walkway, miniboss drop</td><td>Dropped by the second Ancient Wyvern patrolling the path up to the Belfry</td></tr>
<tr><td>CA: Coiled Sword - boss drop</td><td>Dropped by Iudex Gundyr</td></tr>
<tr><td>CA: Firebomb - down the cliff edge</td><td>Along the cliff edge before the Iudex Gundyr fight, to the right</td></tr>
<tr><td>CA: Soul of a Deserted Corpse - right of spawn</td><td>At the very start of the game</td></tr>
<tr><td>CA: Soul of an Unknown Traveler - by miniboss</td><td>In the area with the Ravenous Crystal Lizard</td></tr>
<tr><td>CA: Speckled Stoneplate Ring+1 - by miniboss</td><td>In the area with the Ravenous Crystal Lizard, along the right wall</td></tr>
<tr><td>CA: Titanite Scale - miniboss drop</td><td>Dropped by Ravenous Crystal Lizard</td></tr>
<tr><td>CA: Titanite Shard - jump to coffin</td><td>Making a jump to a coffin after the Cemetery of Ash bonfire</td></tr>
<tr><td>CC: Black Blade - tomb, mimic</td><td>Dropped by the mimic before Smouldering Lake</td></tr>
<tr><td>CC: Black Bug Pellet - cavern, before bridge</td><td>In the area where many many skeletons are before the bridge you can cut</td></tr>
<tr><td>CC: Bloodred Moss Clump - atrium lower, down more stairs</td><td>To the left before going down the main stairwell in the Catacombs, past the skeleton ambush and where Anri is standing, near the Crystal Lizard</td></tr>
<tr><td>CC: Carthus Bloodring - crypt lower, end of side hall</td><td>At the very end of the Bonewheel Skeleton area</td></tr>
<tr><td>CC: Carthus Milkring - crypt upper, among pots</td><td>After the first Skeleton Ball, in the hallway alcove with the many dark-exploding pots</td></tr>
<tr><td>CC: Carthus Pyromancy Tome - atrium lower, jump from bridge</td><td>Down the hallway to the right before going down the main stairwell in the Catacombs and through an illusory wall on the left, or making a difficult dropdown from the top-level platform</td></tr>
<tr><td>CC: Carthus Rouge - atrium upper, left after entrance</td><td>To the right after first entering the Catacombs</td></tr>
<tr><td>CC: Carthus Rouge - crypt across, corner</td><td>Making a difficult jump between the hallway after the first Skeleton Ball and the area at the same level on the opposite side, or going up the stairs from the main hall</td></tr>
<tr><td>CC: Dark Gem - crypt lower, skeleton ball drop</td><td>Dropped by second Skeleton Ball after killing its sorcerer skeleton</td></tr>
<tr><td>CC: Ember - atrium, on long stairway</td><td>On the main stairwell in Catacombs</td></tr>
<tr><td>CC: Ember - crypt lower, shortcut to cavern</td><td>In the short hallway with the level shortcut where Knight Slayer Tsorig invades</td></tr>
<tr><td>CC: Ember - crypt upper, end of hall past hole</td><td>Going right from the Catacombs bonfire, down the hall to the left, then to the right. After a hole that drops down into the Bonewheel Skeleton area.</td></tr>
<tr><td>CC: Fire Gem - cavern, lizard</td><td>Dropped by a Crystal Lizard found between the Catacombs main halls and the ledge overlooking the bridge you can cut down</td></tr>
<tr><td>CC: Grave Warden Pyromancy Tome - boss arena</td><td>In Wolnir&#x27;s arena, or in the back left of the room containing his bonfire if not picked up in the arena</td></tr>
<tr><td>CC: Grave Warden&#x27;s Ashes - crypt across, corner</td><td>From the Catacombs bonfire, down the stairs into the main hall and up the stairs to the other side, on the far left side. Stairwell past the illusory wall is most direct.</td></tr>
<tr><td>CC: Homeward Bone - Irithyll bridge</td><td>Found right before the wall blocking access to Irithyll</td></tr>
<tr><td>CC: Large Soul of a Nameless Soldier - cavern, before bridge</td><td>In the area where many many skeletons are before the bridge you can cut</td></tr>
<tr><td>CC: Large Soul of a Nameless Soldier - tomb lower</td><td>Down the ramp from the Fire Demon, where all the skeletons are</td></tr>
<tr><td>CC: Large Soul of an Unknown Traveler - crypt upper, hall middle</td><td>Going right from the Catacombs bonfire, then down the long hallway after the hallway to the left</td></tr>
<tr><td>CC: Large Titanite Shard - crypt across, middle hall</td><td>From the Catacombs bonfire, down the stairs into the main hall and up the stairs to the other side, in a middle hallway</td></tr>
<tr><td>CC: Large Titanite Shard - crypt upper, skeleton ball hall</td><td>Going right from the Catacombs bonfire, to the end of the hallway where second Skeleton Ball rolls</td></tr>
<tr><td>CC: Large Titanite Shard - tomb lower</td><td>Down the ramp from the Fire Demon, where all the skeletons are</td></tr>
<tr><td>CC: Old Sage&#x27;s Blindfold - tomb, hall before bonfire</td><td>Down the ramp from the Fire Demon, straight down the hallway past the room with the Abandoned Tomb bonfire</td></tr>
<tr><td>CC: Pontiff&#x27;s Right Eye - Irithyll bridge, miniboss drop</td><td>Dropped by killing Sulyvahn&#x27;s Beast on the bridge to Irithyll or in the lake below</td></tr>
<tr><td>CC: Ring of Steel Protection+2 - atrium upper, drop onto pillar</td><td>From the first bridge in Catacombs where the first skeletons are encountered, parallel to the long stairwell, walk off onto a pillar on the left side.</td></tr>
<tr><td>CC: Sharp Gem - atrium lower, right before exit</td><td>Down the hallway to the right before going down the main stairwell in the Catacombs</td></tr>
<tr><td>CC: Soul of High Lord Wolnir</td><td>Dropped by High Lord Wolnir</td></tr>
<tr><td>CC: Soul of a Demon - tomb, miniboss drop</td><td>Dropped by the Fire Demon before Smouldering Lake</td></tr>
<tr><td>CC: Soul of a Nameless Soldier - atrium lower, down hall</td><td>All the way down the hallway to the right before going down the main stairwell in the Catacombs</td></tr>
<tr><td>CC: Soul of a Nameless Soldier - atrium upper, up more stairs</td><td>From the room before the Catacombs main stairwell, up the two ramps and to the end of the long hallway crossing the room</td></tr>
<tr><td>CC: Thunder Stoneplate Ring+1 - crypt upper, among pots</td><td>After the first Skeleton Ball, in the hallway alcove with the many dark-exploding pots, behind one of the pillars</td></tr>
<tr><td>CC: Titanite Shard - atrium lower, corner by stairs</td><td>To the left before going down the main stairwell in the Catacombs, behind the pensive Carthus Cursed Sword Skeleton</td></tr>
<tr><td>CC: Titanite Shard - crypt lower, left of entrance</td><td>In the main hall after the Catacombs bonfire, down the stairs and to the left</td></tr>
<tr><td>CC: Titanite Shard - crypt lower, start of side hall</td><td>In the Bonewheel Skeleton area, on the left side under a Writhing Flesh</td></tr>
<tr><td>CC: Twinkling Titanite - atrium lower, lizard down more stairs</td><td>Dropped by a Crystal Lizard found to the left before going down the main stairwell in the Catacombs, past the skeleton ambush and past where Anri is standing</td></tr>
<tr><td>CC: Undead Bone Shard - crypt upper, skeleton ball drop</td><td>Dropped by first Skeleton Ball after killing its sorcerer skeleton</td></tr>
<tr><td>CC: Witch&#x27;s Ring - tomb, hall before bonfire</td><td>Down the ramp from the Fire Demon, straight down the hallway past the room with the Abandoned Tomb bonfire</td></tr>
<tr><td>CC: Yellow Bug Pellet - cavern, on overlook</td><td>To the right of the Carthus Curved Sword Skeleton overlooking the pit Horace falls into</td></tr>
<tr><td>CD: Aldrich&#x27;s Sapphire - side chapel, miniboss drop</td><td>Dropped by the Deep Accursed</td></tr>
<tr><td>CD: Arbalest - upper roofs, end of furthest buttress</td><td>Before the rafters on the way to Rosaria, up a flying buttress, past a halberd-wielding Large Hollow Soldier to the right, and down another flying buttress to the right</td></tr>
<tr><td>CD: Archdeacon Holy Garb - boss room after killing boss</td><td>Near the Deacons of the Deep bonfire, found after resting at it</td></tr>
<tr><td>CD: Archdeacon Skirt - boss room after killing boss</td><td>Near the Deacons of the Deep bonfire, found after resting at it</td></tr>
<tr><td>CD: Archdeacon White Crown - boss room after killing boss</td><td>Near the Deacons of the Deep bonfire, found after resting at it</td></tr>
<tr><td>CD: Armor of Thorns - Rosaria&#x27;s Bed Chamber after killing Kirk</td><td>Found in Rosaria&#x27;s Bed Chamber after killing Longfinger Kirk</td></tr>
<tr><td>CD: Astora Greatsword - graveyard, left of entrance</td><td>Down one of the side paths to the left in the Reanimated Corpse area</td></tr>
<tr><td>CD: Barbed Straight Sword - Kirk drop</td><td>Dropped by Longfinger Kirk when he invades in the cathedral central room</td></tr>
<tr><td>CD: Black Eye Orb - Rosaria from Leonhard&#x27;s quest</td><td>On Rosaria&#x27;s corpse after joining Rosaria&#x27;s Fingers, exhausting Leonhard&#x27;s dialogue there and reaching the Profaned Capital bonfire.</td></tr>
<tr><td>CD: Blessed Gem - upper roofs, rafters</td><td>In the rafters leading to Rosaria, guarded by a Cathedral Knight to the right</td></tr>
<tr><td>CD: Crest Shield - path, drop down by Cathedral of the Deep bonfire</td><td>On a grave near the Cathedral of the Deep bonfire, accessed by dropping down to the right</td></tr>
<tr><td>CD: Curse Ward Greatshield - by ladder from white tree to moat</td><td>Taking a right after the Infested Corpse graveyard, before the shortcut ladder down to the Ravenous Crystal Lizard area</td></tr>
<tr><td>CD: Deep Braille Divine Tome - mimic by side chapel</td><td>Dropped by the Mimic before the room with the patrolling Cathedral Knight and Deep Accursed</td></tr>
<tr><td>CD: Deep Gem - down stairs by first elevator</td><td>Coming from the room where you first see deacons, go down instead of continuing to the main cathedral room. Guarded by a pensive Cathedral Evangelist.</td></tr>
<tr><td>CD: Deep Ring - upper roofs, passive mob drop in first tower</td><td>Dropped by the passive Deacon on the way to Rosaria</td></tr>
<tr><td>CD: Drang Armor - main hall, east</td><td>In the Giant Slave muck pit leading up to Deacons</td></tr>
<tr><td>CD: Drang Gauntlets - main hall east</td><td>In the Giant Slave muck pit leading up to Deacons</td></tr>
<tr><td>CD: Drang Hammers - main hall east</td><td>In the Giant Slave muck pit leading up to Deacons, underneath the stairwell</td></tr>
<tr><td>CD: Drang Shoes - main hall east</td><td>In the Giant Slave muck pit leading up to Deacons</td></tr>
<tr><td>CD: Duel Charm - by first elevator</td><td>After opening the cathedral&#x27;s backdoor, where the Deacon enemies are first seen, under a fountain that spouts poison</td></tr>
<tr><td>CD: Duel Charm - next to Patches in onion armor</td><td>To the right of the bridge leading to Rosaria, from the Deacons side. Patches will lower the bridge if you try to cross from this side.</td></tr>
<tr><td>CD: Ember - Patches</td><td>Sold by Patches in Firelink Shrine</td></tr>
<tr><td>CD: Ember - by back door</td><td>Past the pair of Grave Wardens and the Cathedral backdoor against a wall, guarded by a greataxe-wielding Large Hollow Soldier</td></tr>
<tr><td>CD: Ember - edge of platform before boss</td><td>On the edge of the chapel before Deacons overlooking the Giant Slaves</td></tr>
<tr><td>CD: Ember - side chapel upstairs, up ladder</td><td>Up a ladder and past the Cathedral Evangelist from the top level of the room with the patrolling Cathedral Knight and Deep Accursed</td></tr>
<tr><td>CD: Ember - side chapel, miniboss room</td><td>In the room with the Deep Accursed</td></tr>
<tr><td>CD: Estus Shard - monument outside Cleansing Chapel</td><td>Right outside of the Cleansing Chapel. Requires killing praying hollows.</td></tr>
<tr><td>CD: Executioner&#x27;s Greatsword - graveyard, far end</td><td>In an open area down one of the side paths to the left in the Reanimated Corpse area</td></tr>
<tr><td>CD: Exploding Bolt - ledge above main hall south</td><td>On the ledge where the Giant Slave slams his arms down</td></tr>
<tr><td>CD: Fading Soul - graveyard, far end</td><td>In an open area down one of the side paths to the left in the Reanimated Corpse area, next to the Executioner&#x27;s Greatsword</td></tr>
<tr><td>CD: Gauntlets of Thorns - Rosaria&#x27;s Bed Chamber after killing Kirk</td><td>Found in Rosaria&#x27;s Bed Chamber after killing Longfinger Kirk</td></tr>
<tr><td>CD: Helm of Thorns - Rosaria&#x27;s Bed Chamber after killing Kirk</td><td>Found in Rosaria&#x27;s Bed Chamber after killing Longfinger Kirk</td></tr>
<tr><td>CD: Herald Armor - path, by fire</td><td>Guarded by the Cathedral Evangelist after the Crystal Sage fight</td></tr>
<tr><td>CD: Herald Gloves - path, by fire</td><td>Guarded by the Cathedral Evangelist after the Crystal Sage fight</td></tr>
<tr><td>CD: Herald Helm - path, by fire</td><td>Guarded by the Cathedral Evangelist after the Crystal Sage fight</td></tr>
<tr><td>CD: Herald Trousers - path, by fire</td><td>Guarded by the Cathedral Evangelist after the Crystal Sage fight</td></tr>
<tr><td>CD: Heysel Pick - Heysel Corpse-Grub in Rosaria&#x27;s Bed Chamber</td><td>Dropped by the Heysel Corpse-grub in Rosaria&#x27;s Bed Chamber</td></tr>
<tr><td>CD: Homeward Bone - outside main hall south door</td><td>Past the cathedral doors guarded by the Giant Slave opposite to the Deacons fight</td></tr>
<tr><td>CD: Horsehoof Ring - Patches</td><td>Sold or dropped by Patches after he mentions Greirat</td></tr>
<tr><td>CD: Large Soul of an Unknown Traveler - by white tree #1</td><td>In the graveyard with the White Birch and Infested Corpses</td></tr>
<tr><td>CD: Large Soul of an Unknown Traveler - by white tree #2</td><td>In the graveyard with the White Birch and Infested Corpses</td></tr>
<tr><td>CD: Large Soul of an Unknown Traveler - lower roofs, semicircle balcony</td><td>On the cathedral roof after climbing up the flying buttresses, on the edge of the semicircle platform balcony</td></tr>
<tr><td>CD: Large Soul of an Unknown Traveler - main hall east</td><td>In the Giant Slave muck pit leading up to Deacons</td></tr>
<tr><td>CD: Large Soul of an Unknown Traveler - main hall south, side path</td><td>Down a side path with poison-spouting fountains in the main cathedral room, accessible from the Cleansing Chapel shortcut, patrolled by a Cathedral Knight</td></tr>
<tr><td>CD: Large Soul of an Unknown Traveler - path, against outer wall</td><td>From the Cathedral of the Deep bonfire after the Brigand, against the wall in the area with the dogs and crossbowmen</td></tr>
<tr><td>CD: Leggings of Thorns - Rosaria&#x27;s Bed Chamber after killing Kirk</td><td>Found in Rosaria&#x27;s Bed Chamber after killing Longfinger Kirk</td></tr>
<tr><td>CD: Lloyd&#x27;s Sword Ring - ledge above main hall south</td><td>On the ledge where the Giant Slave slams his arms down</td></tr>
<tr><td>CD: Maiden Gloves - main hall south</td><td>In the muck pit with the Giant Slave that can attack with his arms</td></tr>
<tr><td>CD: Maiden Hood - main hall south</td><td>In the muck pit with the Giant Slave that can attack with his arms</td></tr>
<tr><td>CD: Maiden Robe - main hall south</td><td>In the muck pit with the Giant Slave that can attack with his arms</td></tr>
<tr><td>CD: Maiden Skirt - main hall south</td><td>In the muck pit with the Giant Slave that can attack with his arms</td></tr>
<tr><td>CD: Notched Whip - Cleansing Chapel</td><td>In a corner of the Cleansing Chapel</td></tr>
<tr><td>CD: Paladin&#x27;s Ashes - path, guarded by lower NPC</td><td>At the very start of the area, guarded by the Fallen Knight</td></tr>
<tr><td>CD: Pale Tongue - main hall east</td><td>In the Giant Slave muck pit leading up to Deacons</td></tr>
<tr><td>CD: Pale Tongue - upper roofs, outdoors far end</td><td>Before the rafters on the way to Rosaria, up a flying buttress and straight right, passing a halberd-wielding Large Hollow Soldier</td></tr>
<tr><td>CD: Poisonbite Ring - moat, hall past miniboss</td><td>In the pit with the Infested Corpse, accessible from the Ravenous Crystal Lizard area or from dropping down near the second Cleansing Chapel shortcut</td></tr>
<tr><td>CD: Red Bug Pellet - lower roofs, up stairs between buttresses</td><td>In the area after the cathedral roof against the wall of the cathedral, down the path from the Cathedral Evangelist.</td></tr>
<tr><td>CD: Red Bug Pellet - right of cathedral front doors</td><td>Up the stairs past the Infested Corpse graveyard and the left, toward the roof path to the right of the cathedral doors</td></tr>
<tr><td>CD: Red Sign Soapstone - passive mob drop by Rosaria&#x27;s Bed Chamber</td><td>Dropped by passive Corpse-grub against the wall near the entrance to Rosaria&#x27;s Bed Chamber</td></tr>
<tr><td>CD: Repair Powder - by white tree</td><td>In the graveyard with the White Birch and Infested Corpses</td></tr>
<tr><td>CD: Ring of Favor+2 - upper roofs, on buttress</td><td>Before the rafters on the way to Rosaria, up a flying buttress, behind a greataxe-wielding Large Hollow Soldier to the left</td></tr>
<tr><td>CD: Ring of the Evil Eye+1 - by stairs to boss</td><td>Before the stairs leading down into the Deacons fight</td></tr>
<tr><td>CD: Rosaria&#x27;s Fingers - Rosaria</td><td>Given by Rosaria.</td></tr>
<tr><td>CD: Rusted Coin - don&#x27;t forgive Patches</td><td>Given by Patches after not forgiving him after he lowers the bridge in Cathedral of the Deep.</td></tr>
<tr><td>CD: Rusted Coin - left of cathedral front doors, behind crates</td><td>Up the stairs past the Infested Corpse graveyard and to the left, hidden behind some crates to the left of the cathedral door</td></tr>
<tr><td>CD: Saint Bident - outside main hall south door</td><td>Past the cathedral doors guarded by the Giant Slave opposite to the Deacons fight</td></tr>
<tr><td>CD: Saint-tree Bellvine - moat, by water</td><td>In the Infested Corpse moat beneath the Cathedral</td></tr>
<tr><td>CD: Seek Guidance - side chapel upstairs</td><td>Above the room with the patrolling Cathedral Knight and Deep Accursed, below a writhing flesh on the ceiling.</td></tr>
<tr><td>CD: Shotel - Patches</td><td>Sold by Patches</td></tr>
<tr><td>CD: Small Doll - boss drop</td><td>Dropped by Deacons of the Deep</td></tr>
<tr><td>CD: Soul of a Nameless Soldier - ledge above main hall south</td><td>On the ledge where the Giant Slave slams his arms down</td></tr>
<tr><td>CD: Soul of a Nameless Soldier - lower roofs, side room</td><td>Coming from the cathedral roof, past the three crossbowmen to the path patrolled by the halberd-wielding Large Hollow Soldier, in a room to the left with many thralls.</td></tr>
<tr><td>CD: Soul of a Nameless Soldier - main hall south</td><td>In the muck pit with the Giant Slave that can attack with his arms</td></tr>
<tr><td>CD: Soul of the Deacons of the Deep</td><td>Dropped by Deacons of the Deep</td></tr>
<tr><td>CD: Spider Shield - NPC drop on path</td><td>Dropped by the brigand at the start of Cathedral of the Deep</td></tr>
<tr><td>CD: Spiked Shield - Kirk drop</td><td>Dropped by Longfinger Kirk when he invades in the cathedral central room</td></tr>
<tr><td>CD: Titanite Scale - moat, miniboss drop</td><td>Dropped by the Ravenous Crystal Lizard outside of the Cathedral</td></tr>
<tr><td>CD: Titanite Shard - Cleansing Chapel windowsill, by miniboss</td><td>On the ledge dropping back down into Cleansing Chapel from the area with the Ravenous Crystal Lizard</td></tr>
<tr><td>CD: Titanite Shard - moat, far end</td><td>Behind the cathedral near the Infested Corpse moat, going from the Ravenous Crystal Lizard</td></tr>
<tr><td>CD: Titanite Shard - moat, up a slope</td><td>Up one of the slopes in the Ravenous Crystal Lizard area</td></tr>
<tr><td>CD: Titanite Shard - outside building by white tree</td><td>Past the Infested Corpse graveyard to the left, hidden along the left wall of the building with the shortcut ladder and Curse Ward Greatshield</td></tr>
<tr><td>CD: Titanite Shard - path, side path by Cathedral of the Deep bonfire</td><td>Up a path to the left after the Cathedral of the Deep bonfire, after the Fallen Knight and before the Brigand</td></tr>
<tr><td>CD: Twinkling Titanite - moat, lizard #1</td><td>Dropped by the Crystal Lizard behind the cathedral near the Infested Corpse moat, going from the Ravenous Crystal Lizard</td></tr>
<tr><td>CD: Twinkling Titanite - moat, lizard #2</td><td>Dropped by the Crystal Lizard under the cathedral near the Infested Corpse moat, going from the Ravenous Crystal Lizard</td></tr>
<tr><td>CD: Twinkling Titanite - path, lizard #1</td><td>Dropped by the first Crystal Lizard after the Crystal Sage fight</td></tr>
<tr><td>CD: Twinkling Titanite - path, lizard #2</td><td>Dropped by the second Crystal Lizard after the Crystal Sage fight</td></tr>
<tr><td>CD: Undead Bone Shard - gravestone by white tree</td><td>In the graveyard with the Infested Corpses, on a coffin partly hanging off of the ledge</td></tr>
<tr><td>CD: Undead Hunter Charm - lower roofs, up stairs between buttresses</td><td>In the area after the cathedral roof guarded by a Cathedral Evangelist. Can be jumped to from a flying buttress or by going around and back</td></tr>
<tr><td>CD: Winged Spear - kill Patches</td><td>Dropped by Patches when killed in his own armor.</td></tr>
<tr><td>CD: Xanthous Crown - Heysel Corpse-Grub in Rosaria&#x27;s Bed Chamber</td><td>Dropped by the Heysel Corpse-grub in Rosaria&#x27;s Bed Chamber</td></tr>
<tr><td>CD: Young White Branch - by white tree #1</td><td>By the White Birch tree in the Infested Corpse graveyard</td></tr>
<tr><td>CD: Young White Branch - by white tree #2</td><td>By the White Birch tree in the Infested Corpse graveyard</td></tr>
<tr><td>CKG: Black Firebomb - under rotunda</td><td>Under the platform in the middle of the garden, in the toxic pool</td></tr>
<tr><td>CKG: Claw - under rotunda</td><td>Under the platform in the middle of the garden, in the toxic pool</td></tr>
<tr><td>CKG: Dark Gem - under lone stairway</td><td>Following the left wall, behind the standalone set of stairs</td></tr>
<tr><td>CKG: Dragonscale Ring - shortcut, leave halfway down lift</td><td>From the middle level of the second elevator, toward the Oceiros boss fight</td></tr>
<tr><td>CKG: Drakeblood Armor - tomb, after killing AP mausoleum NPC</td><td>On the Drakeblood Knight after Oceiros fight, after defeating the Drakeblood Knight from the Serpent-Man Summoner</td></tr>
<tr><td>CKG: Drakeblood Gauntlets - tomb, after killing AP mausoleum NPC</td><td>On the Drakeblood Knight after Oceiros fight, after defeating the Drakeblood Knight from the Serpent-Man Summoner</td></tr>
<tr><td>CKG: Drakeblood Helm - tomb, after killing AP mausoleum NPC</td><td>On the Drakeblood Knight after Oceiros fight, after defeating the Drakeblood Knight from the Serpent-Man Summoner</td></tr>
<tr><td>CKG: Drakeblood Leggings - tomb, after killing AP mausoleum NPC</td><td>On the Drakeblood Knight after Oceiros fight, after defeating the Drakeblood Knight from the Serpent-Man Summoner</td></tr>
<tr><td>CKG: Estus Shard - balcony</td><td>From the middle level of the first Consumed King&#x27;s Gardens elevator, out the balcony and to the right</td></tr>
<tr><td>CKG: Human Pine Resin - pool by lift</td><td>On the right side of the garden, following the wall past the entrance to the shortcut elevator building, in a toxic pool</td></tr>
<tr><td>CKG: Human Pine Resin - toxic pool, past rotunda</td><td>In between two platforms near the middle of the garden, by a tree in a toxic pool</td></tr>
<tr><td>CKG: Magic Stoneplate Ring - mob drop before boss</td><td>Dropped by the Cathedral Knight closest to the Oceiros fog gate</td></tr>
<tr><td>CKG: Ring of Sacrifice - under balcony</td><td>Along the right wall of the garden, next to the first elevator building</td></tr>
<tr><td>CKG: Sage Ring+2 - balcony, drop onto rubble, jump back</td><td>From the middle platform of the first elevator in the target, going out and dropping off to the left, and then running off onto the ruined arch behind.</td></tr>
<tr><td>CKG: Shadow Garb - under rotunda</td><td>Under the platform in the middle of the garden, in the toxic pool</td></tr>
<tr><td>CKG: Shadow Gauntlets - under rotunda</td><td>Under the platform in the middle of the garden, in the toxic pool</td></tr>
<tr><td>CKG: Shadow Leggings - under rotunda</td><td>Under the platform in the middle of the garden, in the toxic pool</td></tr>
<tr><td>CKG: Shadow Mask - under center platform</td><td>Under the platform in the middle of the garden, in the toxic pool</td></tr>
<tr><td>CKG: Soul of Consumed Oceiros</td><td>Dropped by Consumed King Oceiros</td></tr>
<tr><td>CKG: Soul of a Weary Warrior - before first lift</td><td>On the path leading to the first elevator from Lothric Castle</td></tr>
<tr><td>CKG: Titanite Chunk - balcony, drop onto rubble</td><td>From the middle platform of the first elevator, dropping down to the left</td></tr>
<tr><td>CKG: Titanite Chunk - right of shortcut lift bottom</td><td>On the right side of the garden, following the wall past the entrance to the shortcut elevator building, all the way to the end</td></tr>
<tr><td>CKG: Titanite Chunk - shortcut</td><td>Right inside of the shortcut door leading to Oceiros from Lothric/Dancer bonfire</td></tr>
<tr><td>CKG: Titanite Chunk - up lone stairway</td><td>Following the left wall of the garden, in and up the standalone set of stairs</td></tr>
<tr><td>CKG: Titanite Scale - shortcut</td><td>In the room leading to the Oceiros shortcut elevator from Lothric/Dancer, in the first floor alcove.</td></tr>
<tr><td>CKG: Titanite Scale - tomb, chest #1</td><td>Chest after Oceiros fight</td></tr>
<tr><td>CKG: Titanite Scale - tomb, chest #2</td><td>Chest after Oceiros fight</td></tr>
<tr><td>CKG: Wood Grain Ring+1 - by first elevator bottom</td><td>Behind the first elevator going down into the garden, in the toxic pool</td></tr>
<tr><td>DH: Aquamarine Dagger - castle, up stairs</td><td>Up the second flight of stairs to the left of the starting area with the murkmen, before the long drop</td></tr>
<tr><td>DH: Black Firebomb - ruins, up windmill from bonfire</td><td>To the left of the Earthen Peak Ruins bonfire, past the ruined windmill, next to many Poisonhorn bugs.</td></tr>
<tr><td>DH: Covetous Silver Serpent Ring+3 - pantry upstairs, drop down</td><td>After exiting the building with the Lothric Knights where the front crumbles, to the last room of the building to the right, up stairs past an illusory wall to the left, then dropping down after exiting the building from the last room.</td></tr>
<tr><td>DH: Desert Pyromancer Garb - ruins, by shack near cliff</td><td>Behind a shack near the edge of the cliff of the area targeted by the second angel.</td></tr>
<tr><td>DH: Desert Pyromancer Gloves - swamp, far right</td><td>After dropping down in the poison swamp area, against the wall straight to the right.</td></tr>
<tr><td>DH: Desert Pyromancer Hood - swamp upper, tunnel end</td><td>At the end of the tunnel with Desert Pyromancy Zoey, to the right of the final branches.</td></tr>
<tr><td>DH: Desert Pyromancer Skirt - swamp right, by roots</td><td>In the poison swamp, against a tree guarded by a few Poisonhorn bugs in the front right.</td></tr>
<tr><td>DH: Divine Blessing - library, after drop</td><td>After the dropdown where an angel first targets you, behind you</td></tr>
<tr><td>DH: Divine Blessing - shop</td><td>Sold by Stone-humped Hag, or in her ashes</td></tr>
<tr><td>DH: Divine Blessing - swamp upper, building roof</td><td>On a rooftop of one of the buildings bordering the poison swamp. Can be reached by dropping down from the final tree branch and accessing the roof to the right.</td></tr>
<tr><td>DH: Ember - castle, behind spire</td><td>At the start of the area, behind a spire to the right of first drop down</td></tr>
<tr><td>DH: Ember - pantry, behind crates just before upstairs</td><td>After exiting the building with the Lothric Knights where the front crumbles, to the last room end of the building to the right, up stairs past an illusory wall to the left, in the second-to-last room of the sequence, behind some crates to the left.</td></tr>
<tr><td>DH: Ember - ruins, alcove before swamp</td><td>In an alcove providing cover from the second angel&#x27;s projectiles, before dropping down in the poison swamp area.</td></tr>
<tr><td>DH: Ember - ruins, alcove on cliff</td><td>In the area with the pilgrim responsible for the second angel, below the Within Earthen Peak Ruins bonfire. Can be accessed by dropping down from a cliff edge, dropping down to the right of the bonfire.</td></tr>
<tr><td>DH: Ember - shop</td><td>Sold by Stone-humped Hag, or in her ashes</td></tr>
<tr><td>DH: Flame Fan - swamp upper, NPC drop</td><td>Dropped by Desert Pyromancer Zoey</td></tr>
<tr><td>DH: Giant Door Shield - ruins, path below far shack</td><td>Descending down a path from the edge of the cliff of the area targeted by the second angel, to the very end of the cliff.</td></tr>
<tr><td>DH: Great Soul Dregs - pantry upstairs</td><td>After exiting the building with the Lothric Knights where the front crumbles, to the last room of the building to the right, up stairs past an illusory wall to the left, then all the way to the end of the last room.</td></tr>
<tr><td>DH: Harald Curved Greatsword - swamp left, under root</td><td>In the back leftmost area of the poison swamp, underneath the tree branch leading up and out, guarded by a stationary Harald Legion Knight.</td></tr>
<tr><td>DH: Hidden Blessing - shop</td><td>Sold by Stone-humped Hag, or in her ashes</td></tr>
<tr><td>DH: Homeward Bone - end of path from church</td><td>Immediately before dropping into the area with the Earthen Peak Ruins bonfire, next to Gael&#x27;s flag.</td></tr>
<tr><td>DH: Homeward Bone - swamp left, on root</td><td>All the way to the end of a short path in the back leftmost area of the poison swamp, where you can plunge attack the stationary Harald Legion Knight.</td></tr>
<tr><td>DH: Large Soul of a Weary Warrior - parapets, hall</td><td>After crossing the spire bridge that crashes into the building with the Lothric Knights, past Lapp&#x27;s initial location, dropping down behind the murkman and dropping down again, in a corner to the left.</td></tr>
<tr><td>DH: Large Soul of a Weary Warrior - swamp center</td><td>In the middle of the poison swamp.</td></tr>
<tr><td>DH: Large Soul of a Weary Warrior - swamp, under overhang</td><td>In the cavern adjacent to the poison swamp, surrounded by a few Poisonhorn bugs.</td></tr>
<tr><td>DH: Lightning Urn - wall outside church</td><td>After the dropdown where an angel first targets you, against the wall on the left.</td></tr>
<tr><td>DH: Loincloth - swamp, left edge</td><td>In the leftmost edge of the poison swamp after dropping down, guarded by 6 Poisonhorn bugs.</td></tr>
<tr><td>DH: Lothric War Banner - parapets, end of hall</td><td>After crossing the spire bridge that crashes into the building with the Lothric Knights, past Lapp&#x27;s initial location, dropping down behind the murkman and dropping down again, at the end of the hallway to the right.</td></tr>
<tr><td>DH: Murky Hand Scythe - library, behind bookshelves</td><td>After the first long drop into the building which looks like Grand Archives, to the left up the bookshelf stairs and behind the bookshelves</td></tr>
<tr><td>DH: Murky Longstaff - pantry, last room</td><td>After exiting the building with the Lothric Knights where the front crumbles, in the third-furthest room in the building to the right.</td></tr>
<tr><td>DH: Prism Stone - swamp upper, tunnel start</td><td>Near the start of the tunnel with Desert Pyromancer Zoey.</td></tr>
<tr><td>DH: Projected Heal - parapets balcony</td><td>After crossing the spire bridge that crashes into the building with the Lothric Knights, past Lapp&#x27;s initial location, dropping down behind the murkman, against a wall in the area with the Lothric War Banner Knight and many murkmen.</td></tr>
<tr><td>DH: Purple Moss Clump - swamp shack</td><td>In the ruined shack with Poisonhorn bugs straight ahead of the dropdown into the poison swamp area.</td></tr>
<tr><td>DH: Ring of Favor+3 - swamp right, up root</td><td>Up the long branch close to the dropdown into the poison swamp area, in front of the cavern.</td></tr>
<tr><td>DH: Ring of Steel Protection+3 - ledge before church</td><td>After the dropdown where an angel first targets you, on an exposed edge to the left. Difficult to get without killing the angel.</td></tr>
<tr><td>DH: Rusted Coin - behind fountain after church</td><td>After exiting the building with the Lothric Knights where the front crumbles, behind the fountain on the right side.</td></tr>
<tr><td>DH: Rusted Gold Coin - shop</td><td>Sold by Stone-humped Hag, or in her ashes</td></tr>
<tr><td>DH: Siegbräu - Lapp</td><td>Given by Lapp after collecting the Titanite Slab in Earthen Peak Ruins, or left after Demon Princes fight, or dropped upon death if not given.</td></tr>
<tr><td>DH: Small Envoy Banner - boss drop</td><td>Found in the small room after beating Demon Prince.</td></tr>
<tr><td>DH: Soul of a Crestfallen Knight - church, altar</td><td>In the building where the front crumbles, guarded by the two Lothric Knights at the front of the chapel.</td></tr>
<tr><td>DH: Soul of a Weary Warrior - castle overhang</td><td>The bait item at the start of the area which falls down with you into the ruined building below.</td></tr>
<tr><td>DH: Soul of the Demon Prince</td><td>Dropped by Demon Prince</td></tr>
<tr><td>DH: Splitleaf Greatsword - shop</td><td>Sold by Stone-humped Hag, or in her ashes</td></tr>
<tr><td>DH: Titanite Chunk - castle, up stairs</td><td>Up first flight of stairs to the left of the starting area with the murkmen, before the long drop</td></tr>
<tr><td>DH: Titanite Chunk - pantry, first room</td><td>After exiting the building with the Lothric Knights where the front crumbles, on a ledge in the first room of the building to the right.</td></tr>
<tr><td>DH: Titanite Chunk - path from church, by pillar</td><td>Before dropping into the area with the Earthen Peak Ruins bonfire, behind a pillar in front of a murkman pool.</td></tr>
<tr><td>DH: Titanite Chunk - ruins, by far shack</td><td>In front of a shack at the far edge of the cliff of the area targeted by the second angel. There is a shortcut dropdown to the left of the building.</td></tr>
<tr><td>DH: Titanite Chunk - ruins, path from bonfire</td><td>At the Earthen Peak Ruins bonfire, straight a bit then all the way left, near the edge of the cliff in the area targeted by the second angel.</td></tr>
<tr><td>DH: Titanite Chunk - swamp right, drop partway up root</td><td>Partway up the long branch close to the dropdown into the poison swamp area, in front of the cavern, dropping down to a branch to the left.</td></tr>
<tr><td>DH: Titanite Chunk - swamp, along buildings</td><td>After dropping down into the poison swamp, along the buildings on the left side.</td></tr>
<tr><td>DH: Titanite Chunk - swamp, path to upper</td><td>Partway up the branch that leads out of the poison swamp, on a very exposed branch jutting out to the left.</td></tr>
<tr><td>DH: Titanite Scale - library, back of room</td><td>After the first long drop into the building which looks like Grand Archives, behind you at the back of the room</td></tr>
<tr><td>DH: Titanite Scale - swamp upper, drop and jump into tower</td><td>At the very end of the last tree branch before dropping down toward the Within Earthen Peak Ruins bonfire, drop down to the left instead. Make a jump into the interior of the overturned tower to the left.</td></tr>
<tr><td>DH: Titanite Slab - swamp, path under overhang</td><td>Deep within the cavern adjacent to the poison swamp, to the back and then left. Alternatively, given by Lapp after exhausting dialogue near the bonfire and dying, or left after he moves on, or dropped upon death if not given.</td></tr>
<tr><td>DH: Twinkling Titanite - library, chandelier</td><td>After the first long drop into the building which looks like Grand Archives, straight ahead hanging from a chandelier on the ground</td></tr>
<tr><td>DH: Twinkling Titanite - path after church, mob drop</td><td>Dropped the pilgrim responsible for the first angel encountered, below the spire bridge that forms by crashing into the building.</td></tr>
<tr><td>DH: Twinkling Titanite - ruins, alcove on cliff, mob drop</td><td>Dropped by the pilgrim responsible for the second angel, below the Within Earthen Peak Ruins bonfire. Can be accessed by dropping down from a cliff edge, or dropping down to the right of the bonfire.</td></tr>
<tr><td>DH: Twinkling Titanite - ruins, root near bonfire</td><td>Treasure visible straight ahead of the Earthen Peak Ruins bonfire on a branch. Can be accessed by following the right wall from the bonfire until a point of access onto the branch is found.</td></tr>
<tr><td>DH: Twinkling Titanite - swamp upper, drop onto root</td><td>On the final tree branches before dropping down toward the Within Earthen Peak Ruins bonfire, drop down on a smaller branch to the right. This loops back to the original branch.</td></tr>
<tr><td>DH: Twinkling Titanite - swamp upper, mob drop on roof</td><td>Dropped by the pilgrim responsible for the third angel in the swamp. Rather than heading left into the tunnel with Desert Pyromancy Zoey, go right onto a shack roof. Drop down onto a tree branch at the end, then drop down to another roof.</td></tr>
<tr><td>FK: Antiquated Dress - hidden cave</td><td>In a chest in the cave found along the keep wall in the basilisk area, with the Elizabeth corpse</td></tr>
<tr><td>FK: Antiquated Gloves - hidden cave</td><td>In a chest in the cave found along the keep wall in the basilisk area, with the Elizabeth corpse</td></tr>
<tr><td>FK: Antiquated Skirt - hidden cave</td><td>In a chest in the cave found along the keep wall in the basilisk area, with the Elizabeth corpse</td></tr>
<tr><td>FK: Atonement - perimeter, drop down into swamp</td><td>Dropping down from the Farron Keep Perimeter building, to the right past the bonfire, before the stairs going up</td></tr>
<tr><td>FK: Black Bow of Pharis - miniboss drop, by keep ruins near wall</td><td>Dropped the Elder Ghru on the left side of the group of three to the left of the Keep Ruins bonfire, as approached from the ritual fire.</td></tr>
<tr><td>FK: Black Bug Pellet - perimeter, hill by boss door</td><td>On the small hill to the right of the Abyss Watchers entrance, guarded by a spear-wielding Ghru Grunt</td></tr>
<tr><td>FK: Cinders of a Lord - Abyss Watcher</td><td>Dropped by Abyss Watchers</td></tr>
<tr><td>FK: Crown of Dusk - by white tree</td><td>Near the swamp birch tree patrolled by the greater crab, where the Giant shoots arrows</td></tr>
<tr><td>FK: Dark Stoneplate Ring+2 - keep ruins ritual island, behind wall</td><td>Hidden behind the right wall of the ritual fire before Keep Ruins</td></tr>
<tr><td>FK: Dragon Crest Shield - upper keep, far side of the wall</td><td>Up the elevator from Old Wolf of Farron bonfire, and dropping down to Crystal Lizard area, in the open.</td></tr>
<tr><td>FK: Dreamchaser&#x27;s Ashes - keep proper, illusory wall</td><td>Near the Old Wolf of Farron bonfire, behind an illusory wall near the Crystal Lizard</td></tr>
<tr><td>FK: Ember - by white tree</td><td>Near the swamp birch tree patrolled by the greater crab, where the Giant shoots arrows</td></tr>
<tr><td>FK: Ember - perimeter, path to boss</td><td>Guarded by a spear-wielding Ghru Grunt to the right of the main path leading up to Abyss Watchers</td></tr>
<tr><td>FK: Ember - upper keep, by miniboss #1</td><td>Guarded by Stray Demon, up from the Old Wolf of Farron bonfire</td></tr>
<tr><td>FK: Ember - upper keep, by miniboss #2</td><td>Guarded by Stray Demon, up from the Old Wolf of Farron bonfire</td></tr>
<tr><td>FK: Estus Shard - between Farron Keep bonfire and left island</td><td>Straight ahead from the Farron Keep bonfire to the ritual fire stairs, guarded by a slug</td></tr>
<tr><td>FK: Gold Pine Bundle - by white tree</td><td>Near the swamp birch tree patrolled by the greater crab, where the Giant shoots arrows</td></tr>
<tr><td>FK: Golden Scroll - hidden cave</td><td>In a cave found along the keep wall in the basilisk area, with the Elizabeth corpse</td></tr>
<tr><td>FK: Great Magic Weapon - perimeter, by door to Road of Sacrifices</td><td>Next to the shortcut leading from Farron Keep Perimeter back into Crucifixion Woods, past the Ravenous Crystal Lizard</td></tr>
<tr><td>FK: Greataxe - upper keep, by miniboss</td><td>Guarded by Stray Demon, up from the Old Wolf of Farron bonfire</td></tr>
<tr><td>FK: Greatsword - ramp by keep ruins ritual island</td><td>In the middle of the swamp, on the pair of long ramps furthest from the Farron Keep bonfire, going out forward and slightly right from the bonfire.</td></tr>
<tr><td>FK: Havel&#x27;s Armor - upper keep, after killing AP belfry roof NPC</td><td>Appears by Stray Demon, up from the Old Wolf of Farron bonfire, after the Havel Knight guarding the Titanite Slab in Archdragon Peak has been killed</td></tr>
<tr><td>FK: Havel&#x27;s Gauntlets - upper keep, after killing AP belfry roof NPC</td><td>Appears by Stray Demon, up from the Old Wolf of Farron bonfire, after the Havel Knight guarding the Titanite Slab in Archdragon Peak has been killed</td></tr>
<tr><td>FK: Havel&#x27;s Helm - upper keep, after killing AP belfry roof NPC</td><td>Appears by Stray Demon, up from the Old Wolf of Farron bonfire, after the Havel Knight guarding the Titanite Slab in Archdragon Peak has been killed</td></tr>
<tr><td>FK: Havel&#x27;s Leggings - upper keep, after killing AP belfry roof NPC</td><td>Appears by Stray Demon, up from the Old Wolf of Farron bonfire, after the Havel Knight guarding the Titanite Slab in Archdragon Peak has been killed</td></tr>
<tr><td>FK: Heavy Gem - upper keep, lizard on stairs</td><td>Dropped by the Crystal Lizard that scurries up the stairs in the area dropping down from near Stray Demon, up from Old Wolf of Farron bonfire</td></tr>
<tr><td>FK: Hollow Gem - perimeter, drop down into swamp</td><td>Dropping down from the Farron Keep Perimeter building, to the right past the bonfire, before the stairs going up</td></tr>
<tr><td>FK: Homeward Bone - right island, behind fire</td><td>Behind the ritual fire with stairs guarded by Elder Ghrus/basilisks</td></tr>
<tr><td>FK: Iron Flesh - Farron Keep bonfire, right after exit</td><td>In the open in the swamp, heading straight right from Farron Keep bonfire</td></tr>
<tr><td>FK: Large Soul of a Nameless Soldier - corner of keep and right island</td><td>Hidden in a corner to the right of the stairs leading up to the ritual fire from the basilisk area</td></tr>
<tr><td>FK: Large Soul of a Nameless Soldier - near wall by right island</td><td>To the left of the stairs leading up to the ritual fire from the Basilisk area, by the keep wall</td></tr>
<tr><td>FK: Large Soul of an Unknown Traveler - by white tree</td><td>On a tree close to the swamp birch tree patrolled by the greater crab, where the Giant shoots arrows</td></tr>
<tr><td>FK: Large Titanite Shard - upper keep, lizard by wyvern</td><td>Dropped by the farther Crystal Lizard in the area dropping down from near Stray Demon, up from Old Wolf of Farron bonfire</td></tr>
<tr><td>FK: Large Titanite Shard - upper keep, lizard in open</td><td>Dropped by the closer Crystal Lizard in the area dropping down from near Stray Demon, up from Old Wolf of Farron bonfire</td></tr>
<tr><td>FK: Lightning Spear - upper keep, far side of the wall</td><td>Up the elevator from Old Wolf of Farron bonfire, and dropping down to Crystal Lizard area, in the open.</td></tr>
<tr><td>FK: Lingering Dragoncrest Ring - by white tree, miniboss drop</td><td>Dropped by the Greater Crab patrolling the birch tree where the Giant shoots arrows</td></tr>
<tr><td>FK: Magic Stoneplate Ring+1 - between right island and wall</td><td>Behind a tree in the basilisk area, heading directly right from Farron Keep bonfire</td></tr>
<tr><td>FK: Manikin Claws - Londor Pale Shade drop</td><td>Dropped by Londor Pale Shade when he invades near the basilisks, if Yoel or Yuria have been betrayed</td></tr>
<tr><td>FK: Nameless Knight Armor - corner of keep and right island</td><td>From the Keep Ruins bonfire to the ritual fire stairs patrolled by Elder Ghrus, along the edge of the ritual fire hill</td></tr>
<tr><td>FK: Nameless Knight Gauntlets - corner of keep and right island</td><td>From the Keep Ruins bonfire to the ritual fire stairs patrolled by Elder Ghrus, along the edge of the ritual fire hill</td></tr>
<tr><td>FK: Nameless Knight Helm - corner of keep and right island</td><td>From the Keep Ruins bonfire to the ritual fire stairs patrolled by Elder Ghrus, along the edge of the ritual fire hill</td></tr>
<tr><td>FK: Nameless Knight Leggings - corner of keep and right island</td><td>From the Keep Ruins bonfire to the ritual fire stairs patrolled by Elder Ghrus, along the edge of the ritual fire hill</td></tr>
<tr><td>FK: Pharis&#x27;s Hat - miniboss drop, by keep ruins near wall</td><td>Dropped the Elder Ghru in the back of the group of three to the left of the Keep Ruins bonfire, as approached from the ritual fire.</td></tr>
<tr><td>FK: Poison Gem - near wall by keep ruins bridge</td><td>From the left of the bridge leading from the ritual fire to the Keep Ruins bonfire, guarded by the three Elder Ghru</td></tr>
<tr><td>FK: Prism Stone - by left island stairs</td><td>On an island to the left of the stairs leading up to the ritual fire straight ahead of the Farron Keep bonfire</td></tr>
<tr><td>FK: Purple Moss Clump - Farron Keep bonfire, around right corner</td><td>Along the inner wall of the keep, making an immediate right from Farron Keep bonfire</td></tr>
<tr><td>FK: Purple Moss Clump - keep ruins, ritual island</td><td>Close to the ritual fire before the Keep Ruins bonfire</td></tr>
<tr><td>FK: Purple Moss Clump - ramp directly in front of Farron Keep bonfire</td><td>In the middle of the swamp, on the pair of long ramps closest to the Farron Keep bonfire, going out forward and slightly right from the bonfire.</td></tr>
<tr><td>FK: Ragged Mask - Farron Keep bonfire, around left corner</td><td>Along the inner wall of the keep, making an immediate left from Farron Keep bonfire, guarded by slugs</td></tr>
<tr><td>FK: Repair Powder - outside hidden cave</td><td>Along the keep wall in the basilisk area, outside of the cave with the Elizabeth corpse and Golden Scroll</td></tr>
<tr><td>FK: Rotten Pine Resin - left island, behind fire</td><td>In the area behind the ritual fire which is straight ahead of the Farron Keep bonfire</td></tr>
<tr><td>FK: Rotten Pine Resin - outside pavilion by left island</td><td>From the Farron Keep bonfire straight ahead to the pavilion guarded by the Darkwraith, just to the left of the ritual fire stairs</td></tr>
<tr><td>FK: Rusted Gold Coin - right island, behind wall</td><td>Hidden behind the right wall of the ritual fire with stairs guarded by Elder Ghrus/basilisks</td></tr>
<tr><td>FK: Sage&#x27;s Coal - pavilion by left island</td><td>In the pavilion guarded by a Darkwraith, straight ahead from the Farron Keep bonfire to the left of the ritual fire stairs</td></tr>
<tr><td>FK: Sage&#x27;s Scroll - near wall by keep ruins bonfire island</td><td>Along the keep inner wall, heading left from the stone doors past the crab area, surrounded by many Ghru enemies</td></tr>
<tr><td>FK: Shriving Stone - perimeter, just past stone doors</td><td>Past the stone doors, on the path leading up to Abyss Watchers by the Corvians</td></tr>
<tr><td>FK: Soul of a Nameless Soldier - by white tree</td><td>Near the swamp birch tree patrolled by the greater crab, where the Giant shoots arrows</td></tr>
<tr><td>FK: Soul of a Stray Demon - upper keep, miniboss drop</td><td>Dropped by Stray Demon on the bridge above Farron Keep</td></tr>
<tr><td>FK: Soul of the Blood of the Wolf</td><td>Dropped by Abyss Watchers</td></tr>
<tr><td>FK: Stone Parma - near wall by left island</td><td>Along the inner wall of the keep, making a left from Farron Keep bonfire but before the area with the Darkwraith, guarded by a slug</td></tr>
<tr><td>FK: Sunlight Talisman - estus soup island, by ladder to keep proper</td><td>By the pot of estus soup to the left of the stairs leading up to Old Wolf of Farron</td></tr>
<tr><td>FK: Titanite Scale - perimeter, miniboss drop</td><td>Dropped by Ravenous Crystal Lizard near the shortcut from Farron Keep back to Road of Sacrifices</td></tr>
<tr><td>FK: Titanite Shard - Farron Keep bonfire, left after exit</td><td>Along the inner wall of the keep, making a left from Farron Keep bonfire, by the second group of four slugs</td></tr>
<tr><td>FK: Titanite Shard - between left island and keep ruins</td><td>In the swamp area with the Ghru Leaper between the Keep Ruins ritual fire and ritual fire straight ahead of Farron Keep bonfire, opposite from the keep wall</td></tr>
<tr><td>FK: Titanite Shard - by keep ruins ritual island stairs</td><td>By the stairs leading up to the Keep Ruins ritual fire from the middle of the swamp</td></tr>
<tr><td>FK: Titanite Shard - by ladder to keep proper</td><td>In the swamp area close to the foot of the ladder leading to Old Wolf of Farron bonfire</td></tr>
<tr><td>FK: Titanite Shard - by left island stairs</td><td>In front of the stairs leading up to the ritual fire straight ahead of the Farron Keep bonfire</td></tr>
<tr><td>FK: Titanite Shard - keep ruins bonfire island, under ramp</td><td>Under the ramp leading down from the Keep Ruins bonfire</td></tr>
<tr><td>FK: Titanite Shard - swamp by right island</td><td>Behind a tree patrolled by an Elder Ghru close to the ritual fire stairs</td></tr>
<tr><td>FK: Twinkling Dragon Head Stone - Hawkwood drop</td><td>Dropped by Hawkwood after killing him in the Abyss Watchers arena, after running up to the altar in Archdragon Peak. Twinkling Dragon Torso Stone needs to be acquired first.</td></tr>
<tr><td>FK: Twinkling Titanite - keep proper, lizard</td><td>Dropped by the Crystal Lizard on the balcony behind the Old Wolf of Farron bonfire</td></tr>
<tr><td>FK: Undead Bone Shard - pavilion by keep ruins bonfire island</td><td>In a standalone pavilion down the ramp from Keep Ruins bonfire and to the right</td></tr>
<tr><td>FK: Watchdogs of Farron - Old Wolf</td><td>Given by Old Wolf of Farron.</td></tr>
<tr><td>FK: Wolf Ring+1 - keep ruins bonfire island, outside building</td><td>To the right of the building with the Keep Ruins bonfire, when approached from the ritual fire</td></tr>
<tr><td>FK: Wolf&#x27;s Blood Swordgrass - by ladder to keep proper</td><td>To the left of the ladder leading up to the Old Wolf of Farron bonfire</td></tr>
<tr><td>FK: Young White Branch - by white tree #1</td><td>Near the swamp birch tree patrolled by the greater crab, where the Giant shoots arrows</td></tr>
<tr><td>FK: Young White Branch - by white tree #2</td><td>Near the swamp birch tree patrolled by the greater crab, where the Giant shoots arrows</td></tr>
<tr><td>FS: Acid Surge - Cornyx for Carthus Tome</td><td>Sold by Cornyx after giving him the Carthus Pyromancy Tome</td></tr>
<tr><td>FS: Affinity - Karla</td><td>Sold by Karla after recruiting her, or in her ashes</td></tr>
<tr><td>FS: Alluring Skull - Mortician&#x27;s Ashes</td><td>Sold by Handmaid after giving Mortician&#x27;s Ashes</td></tr>
<tr><td>FS: Arstor&#x27;s Spear - Ludleth for Greatwood</td><td>Boss weapon for Curse-Rotted Greatwood</td></tr>
<tr><td>FS: Aural Decoy - Orbeck</td><td>Sold by Orbeck</td></tr>
<tr><td>FS: Billed Mask - shop after killing Yuria</td><td>Dropped by Yuria upon death or quest completion.</td></tr>
<tr><td>FS: Black Dress - shop after killing Yuria</td><td>Dropped by Yuria upon death or quest completion.</td></tr>
<tr><td>FS: Black Fire Orb - Karla for Grave Warden Tome</td><td>Sold by Karla after giving her the Grave Warden Pyromancy Tome</td></tr>
<tr><td>FS: Black Flame - Karla for Grave Warden Tome</td><td>Sold by Karla after giving her the Grave Warden Pyromancy Tome</td></tr>
<tr><td>FS: Black Gauntlets - shop after killing Yuria</td><td>Dropped by Yuria upon death or quest completion.</td></tr>
<tr><td>FS: Black Hand Armor - shop after killing GA NPC</td><td>Sold by Handmaid after killing Black Hand Kumai</td></tr>
<tr><td>FS: Black Hand Hat - shop after killing GA NPC</td><td>Sold by Handmaid after killing Black Hand Kumai</td></tr>
<tr><td>FS: Black Iron Armor - shop after killing Tsorig</td><td>Sold by Handmaid after killing Knight Slayer Tsorig in Smouldering Lake</td></tr>
<tr><td>FS: Black Iron Gauntlets - shop after killing Tsorig</td><td>Sold by Handmaid after killing Knight Slayer Tsorig in Smouldering Lake</td></tr>
<tr><td>FS: Black Iron Helm - shop after killing Tsorig</td><td>Sold by Handmaid after killing Knight Slayer Tsorig in Smouldering Lake</td></tr>
<tr><td>FS: Black Iron Leggings - shop after killing Tsorig</td><td>Sold by Handmaid after killing Knight Slayer Tsorig in Smouldering Lake</td></tr>
<tr><td>FS: Black Leggings - shop after killing Yuria</td><td>Dropped by Yuria upon death or quest completion.</td></tr>
<tr><td>FS: Black Serpent - Ludleth for Wolnir</td><td>Boss weapon for High Lord Wolnir</td></tr>
<tr><td>FS: Blessed Weapon - Irina for Tome of Lothric</td><td>Sold by Irina after giving her the Braille Divine Tome of Lothric</td></tr>
<tr><td>FS: Blue Tearstone Ring - Greirat</td><td>Given by Greirat upon rescuing him from the High Wall cell</td></tr>
<tr><td>FS: Boulder Heave - Ludleth for Stray Demon</td><td>Boss weapon for Stray Demon</td></tr>
<tr><td>FS: Bountiful Light - Irina for Tome of Lothric</td><td>Sold by Irina after giving her the Braille Divine Tome of Lothric</td></tr>
<tr><td>FS: Bountiful Sunlight - Ludleth for Rosaria</td><td>Boss weapon for Rosaria, available after Leonhard is killed</td></tr>
<tr><td>FS: Broken Straight Sword - gravestone after boss</td><td>Near the grave after Iudex Gundyr fight</td></tr>
<tr><td>FS: Budding Green Blossom - shop after killing Creighton and AL boss</td><td>Sold by Handmaid after receiving Silvercat Ring item lot from Sirris and defeating Aldrich</td></tr>
<tr><td>FS: Bursting Fireball - Cornyx for Great Swamp Tome</td><td>Sold by Cornyx after giving him the Great Swamp Pyromancy Tome</td></tr>
<tr><td>FS: Caressing Tears - Irina</td><td>Sold by Irina after recruiting her, or in her ashes</td></tr>
<tr><td>FS: Carthus Beacon - Cornyx for Carthus Tome</td><td>Sold by Cornyx after giving him the Carthus Pyromancy Tome</td></tr>
<tr><td>FS: Carthus Flame Arc - Cornyx for Carthus Tome</td><td>Sold by Cornyx after giving him the Carthus Pyromancy Tome</td></tr>
<tr><td>FS: Cast Light - Orbeck for Golden Scroll</td><td>Sold by Orbeck after giving him the Golden Scroll</td></tr>
<tr><td>FS: Chaos Bed Vestiges - Ludleth for Old Demon King</td><td>Boss weapon for Old Demon King</td></tr>
<tr><td>FS: Chaos Storm - Cornyx for Izalith Tome</td><td>Sold by Cornyx after giving him Izalith Pyromancy Tome</td></tr>
<tr><td>FS: Clandestine Coat - shop with Orbeck&#x27;s Ashes</td><td>Sold by Handmaid after giving Orbeck&#x27;s Ashes and reloading</td></tr>
<tr><td>FS: Cleric&#x27;s Candlestick - Ludleth for Deacons</td><td>Boss weapon for Deacons of the Deep</td></tr>
<tr><td>FS: Cracked Red Eye Orb - Leonhard</td><td>Given by Ringfinger Leonhard in Firelink Shrine after reaching Tower on the Wall bonfire</td></tr>
<tr><td>FS: Crystal Hail - Ludleth for Sage</td><td>Boss weapon for Crystal Sage</td></tr>
<tr><td>FS: Crystal Magic Weapon - Orbeck for Crystal Scroll</td><td>Sold by Orbeck after giving him the Crystal Scroll</td></tr>
<tr><td>FS: Crystal Sage&#x27;s Rapier - Ludleth for Sage</td><td>Boss weapon for Crystal Sage</td></tr>
<tr><td>FS: Crystal Soul Spear - Orbeck for Crystal Scroll</td><td>Sold by Orbeck after giving him the Crystal Scroll</td></tr>
<tr><td>FS: Dancer&#x27;s Armor - shop after killing LC entry boss</td><td>Sold by Handmaid after defeating Dancer of the Boreal Valley</td></tr>
<tr><td>FS: Dancer&#x27;s Crown - shop after killing LC entry boss</td><td>Sold by Handmaid after defeating Dancer of the Boreal Valley</td></tr>
<tr><td>FS: Dancer&#x27;s Enchanted Swords - Ludleth for Dancer</td><td>Boss weapon for Dancer of the Boreal Valley</td></tr>
<tr><td>FS: Dancer&#x27;s Gauntlets - shop after killing LC entry boss</td><td>Sold by Handmaid after defeating Dancer of the Boreal Valley</td></tr>
<tr><td>FS: Dancer&#x27;s Leggings - shop after killing LC entry boss</td><td>Sold by Handmaid after defeating Dancer of the Boreal Valley</td></tr>
<tr><td>FS: Dark Blade - Karla for Londor Tome</td><td>Sold by Irina or Karla after giving one the Londor Braille Divine Tome</td></tr>
<tr><td>FS: Dark Edge - Karla</td><td>Sold by Karla after recruiting her, or in her ashes</td></tr>
<tr><td>FS: Dark Hand - Yuria shop</td><td>Sold by Yuria</td></tr>
<tr><td>FS: Darkdrift - kill Yuria</td><td>Dropped by Yuria upon death or quest completion.</td></tr>
<tr><td>FS: Darkmoon Longbow - Ludleth for Aldrich</td><td>Boss weapon for Aldrich</td></tr>
<tr><td>FS: Dead Again - Karla for Londor Tome</td><td>Sold by Irina or Karla after giving one the Londor Braille Divine Tome</td></tr>
<tr><td>FS: Deep Protection - Karla for Deep Braille Tome</td><td>Sold by Irina or Karla after giving one the Deep Braille Divine Tome</td></tr>
<tr><td>FS: Deep Soul - Ludleth for Deacons</td><td>Boss weapon for Deacons of the Deep</td></tr>
<tr><td>FS: Demon&#x27;s Fist - Ludleth for Fire Demon</td><td>Boss weapon for Fire Demon</td></tr>
<tr><td>FS: Demon&#x27;s Greataxe - Ludleth for Fire Demon</td><td>Boss weapon for Fire Demon</td></tr>
<tr><td>FS: Demon&#x27;s Scar - Ludleth for Demon Prince</td><td>Boss weapon for Demon Prince</td></tr>
<tr><td>FS: Divine Blessing - Greirat from IBV</td><td>Sold by Greirat after pillaging Irithyll</td></tr>
<tr><td>FS: Divine Blessing - Greirat from US</td><td>Sold by Greirat after pillaging Undead Settlement</td></tr>
<tr><td>FS: Dragonscale Armor - shop after killing AP boss</td><td>Sold by Handmaid after defeating Nameless King</td></tr>
<tr><td>FS: Dragonscale Waistcloth - shop after killing AP boss</td><td>Sold by Handmaid after defeating Nameless King</td></tr>
<tr><td>FS: Dragonslayer Greataxe - Ludleth for Dragonslayer</td><td>Boss weapon for Dragonslayer Armour</td></tr>
<tr><td>FS: Dragonslayer Greatshield - Ludleth for Dragonslayer</td><td>Boss weapon for Dragonslayer Armour</td></tr>
<tr><td>FS: Dragonslayer Swordspear - Ludleth for Nameless</td><td>Boss weapon for Nameless King</td></tr>
<tr><td>FS: Dried Finger - shop</td><td>Sold by both Shrine Handmaid and Untended Graves Handmaid</td></tr>
<tr><td>FS: East-West Shield - tree by shrine entrance</td><td>In a tree to the left of the Firelink Shrine entrance</td></tr>
<tr><td>FS: Eastern Armor - Easterner&#x27;s Ashes</td><td>Sold by Handmaid after giving Easterner&#x27;s Ashes</td></tr>
<tr><td>FS: Eastern Gauntlets - Easterner&#x27;s Ashes</td><td>Sold by Handmaid after giving Easterner&#x27;s Ashes</td></tr>
<tr><td>FS: Eastern Helm - Easterner&#x27;s Ashes</td><td>Sold by Handmaid after giving Easterner&#x27;s Ashes</td></tr>
<tr><td>FS: Eastern Leggings - Easterner&#x27;s Ashes</td><td>Sold by Handmaid after giving Easterner&#x27;s Ashes</td></tr>
<tr><td>FS: Elite Knight Armor - shop after Anri quest</td><td>Sold by Handmaid after completing Anri&#x27;s questline or killing Anri</td></tr>
<tr><td>FS: Elite Knight Gauntlets - shop after Anri quest</td><td>Sold by Handmaid after completing Anri&#x27;s questline or killing Anri</td></tr>
<tr><td>FS: Elite Knight Helm - shop after Anri quest</td><td>Sold by Handmaid after completing Anri&#x27;s questline or killing Anri</td></tr>
<tr><td>FS: Elite Knight Leggings - shop after Anri quest</td><td>Sold by Handmaid after completing Anri&#x27;s questline or killing Anri</td></tr>
<tr><td>FS: Ember - Dragon Chaser&#x27;s Ashes</td><td>Sold by Handmaid after giving Dragon Chaser&#x27;s Ashes</td></tr>
<tr><td>FS: Ember - Grave Warden&#x27;s Ashes</td><td>Sold by Handmaid after giving Grave Warden&#x27;s Ashes</td></tr>
<tr><td>FS: Ember - Greirat</td><td>Sold by Greirat after recruiting him, or in his ashes</td></tr>
<tr><td>FS: Ember - Greirat from US</td><td>Sold by Greirat after pillaging Undead Settlement</td></tr>
<tr><td>FS: Ember - Mortician&#x27;s Ashes</td><td>Sold by Handmaid after giving Mortician&#x27;s Ashes</td></tr>
<tr><td>FS: Ember - above shrine entrance</td><td>Above the Firelink Shrine entrance, up the stairs/slope from either left or right of the entrance</td></tr>
<tr><td>FS: Ember - path right of Firelink entrance</td><td>On a cliffside to the right of the main path leading up to Firelink Shrine, guarded by a dog</td></tr>
<tr><td>FS: Ember - shop</td><td>Sold by Handmaid</td></tr>
<tr><td>FS: Ember - shop for Greirat&#x27;s Ashes</td><td>Sold by Handmaid after Greirat pillages Lothric Castle and handing in ashes</td></tr>
<tr><td>FS: Embraced Armor of Favor - shop after killing water reserve minibosses</td><td>Sold by Handmaid after killing Sulyvahn&#x27;s Beasts in Water Reserve</td></tr>
<tr><td>FS: Executioner Armor - shop after killing Horace</td><td>Sold by Handmaid after killing Horace the Hushed</td></tr>
<tr><td>FS: Executioner Gauntlets - shop after killing Horace</td><td>Sold by Handmaid after killing Horace the Hushed</td></tr>
<tr><td>FS: Executioner Helm - shop after killing Horace</td><td>Sold by Handmaid after killing Horace the Hushed</td></tr>
<tr><td>FS: Executioner Leggings - shop after killing Horace</td><td>Sold by Handmaid after killing Horace the Hushed</td></tr>
<tr><td>FS: Exile Armor - shop after killing NPCs in RS</td><td>Sold by Handmaid after killing the exiles just before Farron Keep</td></tr>
<tr><td>FS: Exile Gauntlets - shop after killing NPCs in RS</td><td>Sold by Handmaid after killing the exiles just before Farron Keep</td></tr>
<tr><td>FS: Exile Leggings - shop after killing NPCs in RS</td><td>Sold by Handmaid after killing the exiles just before Farron Keep</td></tr>
<tr><td>FS: Exile Mask - shop after killing NPCs in RS</td><td>Sold by Handmaid after killing the exiles just before Farron Keep</td></tr>
<tr><td>FS: Faraam Armor - shop after killing GA NPC</td><td>Sold by Handmaid after killing Lion Knight Albert</td></tr>
<tr><td>FS: Faraam Boots - shop after killing GA NPC</td><td>Sold by Handmaid after killing Lion Knight Albert</td></tr>
<tr><td>FS: Faraam Gauntlets - shop after killing GA NPC</td><td>Sold by Handmaid after killing Lion Knight Albert</td></tr>
<tr><td>FS: Faraam Helm - shop after killing GA NPC</td><td>Sold by Handmaid after killing Lion Knight Albert</td></tr>
<tr><td>FS: Farron Dart - Orbeck</td><td>Sold by Orbeck</td></tr>
<tr><td>FS: Farron Dart - shop</td><td>Sold by Handmaid</td></tr>
<tr><td>FS: Farron Flashsword - Orbeck</td><td>Sold by Orbeck</td></tr>
<tr><td>FS: Farron Greatsword - Ludleth for Abyss Watchers</td><td>Boss weapon for Abyss Watchers</td></tr>
<tr><td>FS: Farron Hail - Orbeck for Sage&#x27;s Scroll</td><td>Sold by Orbeck after giving him the Sage&#x27;s Scroll</td></tr>
<tr><td>FS: Farron Ring - Hawkwood</td><td>Given by Hawkwood, or dropped upon death, after defeating Abyss Watchers.</td></tr>
<tr><td>FS: Fire Orb - Cornyx for Great Swamp Tome</td><td>Sold by Cornyx after giving him the Great Swamp Pyromancy Tome</td></tr>
<tr><td>FS: Fire Surge - Cornyx</td><td>Sold by Cornyx after recruiting him, or in his ashes</td></tr>
<tr><td>FS: Fire Whip - Karla for Quelana Tome</td><td>Sold by Karla after giving her the Quelana Pyromancy Tome</td></tr>
<tr><td>FS: Fireball - Cornyx</td><td>Sold by Cornyx after recruiting him, or in his ashes</td></tr>
<tr><td>FS: Firelink Armor - shop after placing all Cinders</td><td>Sold by Handmaid after defeating Soul of Cinder</td></tr>
<tr><td>FS: Firelink Gauntlets - shop after placing all Cinders</td><td>Sold by Handmaid after defeating Soul of Cinder</td></tr>
<tr><td>FS: Firelink Greatsword - Ludleth for Cinder</td><td>Boss weapon for Soul of Cinder</td></tr>
<tr><td>FS: Firelink Helm - shop after placing all Cinders</td><td>Sold by Handmaid after defeating Soul of Cinder</td></tr>
<tr><td>FS: Firelink Leggings - shop after placing all Cinders</td><td>Sold by Handmaid after defeating Soul of Cinder</td></tr>
<tr><td>FS: Firestorm - Karla for Quelana Tome</td><td>Sold by Karla after giving her the Quelana Pyromancy Tome</td></tr>
<tr><td>FS: Flash Sweat - Cornyx</td><td>Sold by Cornyx after recruiting him, or in his ashes</td></tr>
<tr><td>FS: Force - Irina for Tome of Carim</td><td>Sold by Irina after giving her the Braille Divine Tome of Carim</td></tr>
<tr><td>FS: Frayed Blade - Ludleth for Midir</td><td>Boss weapon for Darkeater Midir</td></tr>
<tr><td>FS: Friede&#x27;s Great Scythe - Ludleth for Friede</td><td>Boss weapon for Sister Friede</td></tr>
<tr><td>FS: Gael&#x27;s Greatsword - Ludleth for Gael</td><td>Boss weapon for Slave Knight Gael</td></tr>
<tr><td>FS: Gauntlets of Favor - shop after killing water reserve minibosses</td><td>Sold by Handmaid after killing Sulyvahn&#x27;s Beasts in Water Reserve</td></tr>
<tr><td>FS: Gnaw - Karla for Deep Braille Tome</td><td>Sold by Irina or Karla after giving one the Deep Braille Divine Tome</td></tr>
<tr><td>FS: Golden Bracelets - shop after killing AP boss</td><td>Sold by Handmaid after defeating Nameless King</td></tr>
<tr><td>FS: Golden Crown - shop after killing AP boss</td><td>Sold by Handmaid after defeating Nameless King</td></tr>
<tr><td>FS: Grave Key - Mortician&#x27;s Ashes</td><td>Sold by Handmaid after giving Mortician&#x27;s Ashes</td></tr>
<tr><td>FS: Great Chaos Fire Orb - Cornyx for Izalith Tome</td><td>Sold by Cornyx after giving him Izalith Pyromancy Tome</td></tr>
<tr><td>FS: Great Combustion - Cornyx</td><td>Sold by Cornyx after recruiting him, or in his ashes</td></tr>
<tr><td>FS: Great Farron Dart - Orbeck for Sage&#x27;s Scroll</td><td>Sold by Orbeck after giving him the Sage&#x27;s Scroll</td></tr>
<tr><td>FS: Great Heavy Soul Arrow - Orbeck</td><td>Sold by Orbeck</td></tr>
<tr><td>FS: Great Soul Arrow - Orbeck</td><td>Sold by Orbeck</td></tr>
<tr><td>FS: Greatsword of Judgment - Ludleth for Pontiff</td><td>Boss weapon for Pontiff Sulyvahn</td></tr>
<tr><td>FS: Gundyr&#x27;s Armor - shop after killing UG boss</td><td>Sold by Handmaid after defeating Champion Gundyr</td></tr>
<tr><td>FS: Gundyr&#x27;s Gauntlets - shop after killing UG boss</td><td>Sold by Handmaid after defeating Champion Gundyr</td></tr>
<tr><td>FS: Gundyr&#x27;s Halberd - Ludleth for Champion</td><td>Boss weapon for Champion Gundyr</td></tr>
<tr><td>FS: Gundyr&#x27;s Helm - shop after killing UG boss</td><td>Sold by Handmaid after defeating Champion Gundyr</td></tr>
<tr><td>FS: Gundyr&#x27;s Leggings - shop after killing UG boss</td><td>Sold by Handmaid after defeating Champion Gundyr</td></tr>
<tr><td>FS: Havel&#x27;s Ring - Ludleth for Stray Demon</td><td>Boss weapon for Stray Demon</td></tr>
<tr><td>FS: Hawkwood&#x27;s Shield - gravestone after Hawkwood leaves</td><td>Left by Hawkwood after defeating Abyss Watchers, Curse-Rotted Greatwood, Deacons of the Deep, and Crystal Sage</td></tr>
<tr><td>FS: Hawkwood&#x27;s Swordgrass - Andre after gesture in AP summit</td><td>Given by Andre after praying at the Dragon Altar in Archdragon Peak, after acquiring Twinkling Dragon Torso Stone.</td></tr>
<tr><td>FS: Heal - Irina</td><td>Sold by Irina after recruiting her, or in her ashes</td></tr>
<tr><td>FS: Heal Aid - shop</td><td>Sold by Handmaid</td></tr>
<tr><td>FS: Heavy Soul Arrow - Orbeck</td><td>Sold by Orbeck</td></tr>
<tr><td>FS: Heavy Soul Arrow - Yoel/Yuria shop</td><td>Sold by Yoel/Yuria</td></tr>
<tr><td>FS: Helm of Favor - shop after killing water reserve minibosses</td><td>Sold by Handmaid after killing Sulyvahn&#x27;s Beasts in Water Reserve</td></tr>
<tr><td>FS: Hidden Blessing - Dreamchaser&#x27;s Ashes</td><td>Sold by Greirat after pillaging Irithyll</td></tr>
<tr><td>FS: Hidden Blessing - Greirat from IBV</td><td>Sold by Greirat after pillaging Irithyll</td></tr>
<tr><td>FS: Hidden Blessing - Patches after searching GA</td><td>Sold by Handmaid after giving Dreamchaser&#x27;s Ashes, saying where they were found</td></tr>
<tr><td>FS: Hidden Body - Orbeck for Golden Scroll</td><td>Sold by Orbeck after giving him the Golden Scroll</td></tr>
<tr><td>FS: Hidden Weapon - Orbeck for Golden Scroll</td><td>Sold by Orbeck after giving him the Golden Scroll</td></tr>
<tr><td>FS: Hollowslayer Greatsword - Ludleth for Greatwood</td><td>Boss weapon for Curse-Rotted Greatwood</td></tr>
<tr><td>FS: Homeward - Irina</td><td>Sold by Irina after recruiting her, or in her ashes</td></tr>
<tr><td>FS: Homeward Bone - cliff edge after boss</td><td>Along the cliff edge straight ahead of the Iudex Gundyr fight</td></tr>
<tr><td>FS: Homeward Bone - path above shrine entrance</td><td>To the right of the Firelink Shrine entrance, up a slope and before the ledge on top of a coffin</td></tr>
<tr><td>FS: Homing Crystal Soulmass - Orbeck for Crystal Scroll</td><td>Sold by Orbeck after giving him the Crystal Scroll</td></tr>
<tr><td>FS: Homing Soulmass - Orbeck for Logan&#x27;s Scroll</td><td>Sold by Orbeck after giving him Logan&#x27;s Scroll</td></tr>
<tr><td>FS: Karla&#x27;s Coat - Prisoner Chief&#x27;s Ashes</td><td>Sold by Handmaid after giving Prisoner Chief&#x27;s Ashes</td></tr>
<tr><td>FS: Karla&#x27;s Coat - kill Karla</td><td>Dropped from Karla upon death</td></tr>
<tr><td>FS: Karla&#x27;s Gloves - Prisoner Chief&#x27;s Ashes</td><td>Sold by Handmaid after giving Prisoner Chief&#x27;s Ashes</td></tr>
<tr><td>FS: Karla&#x27;s Gloves - kill Karla</td><td>Dropped from Karla upon death</td></tr>
<tr><td>FS: Karla&#x27;s Pointed Hat - Prisoner Chief&#x27;s Ashes</td><td>Sold by Handmaid after giving Prisoner Chief&#x27;s Ashes</td></tr>
<tr><td>FS: Karla&#x27;s Pointed Hat - kill Karla</td><td>Dropped from Karla upon death</td></tr>
<tr><td>FS: Karla&#x27;s Trousers - Prisoner Chief&#x27;s Ashes</td><td>Sold by Handmaid after giving Prisoner Chief&#x27;s Ashes</td></tr>
<tr><td>FS: Karla&#x27;s Trousers - kill Karla</td><td>Dropped from Karla upon death</td></tr>
<tr><td>FS: Leggings of Favor - shop after killing water reserve minibosses</td><td>Sold by Handmaid after killing Sulyvahn&#x27;s Beasts in Water Reserve</td></tr>
<tr><td>FS: Leonhard&#x27;s Garb - shop after killing Leonhard</td><td>Sold by Handmaid after killing Leonhard</td></tr>
<tr><td>FS: Leonhard&#x27;s Gauntlets - shop after killing Leonhard</td><td>Sold by Handmaid after killing Leonhard</td></tr>
<tr><td>FS: Leonhard&#x27;s Trousers - shop after killing Leonhard</td><td>Sold by Handmaid after killing Leonhard</td></tr>
<tr><td>FS: Life Ring - Dreamchaser&#x27;s Ashes</td><td>Sold by Handmaid after giving Dreamchaser&#x27;s Ashes</td></tr>
<tr><td>FS: Lifehunt Scythe - Ludleth for Aldrich</td><td>Boss weapon for Aldrich</td></tr>
<tr><td>FS: Lift Chamber Key - Leonhard</td><td>Given by Ringfinger Leonhard after acquiring a Pale Tongue.</td></tr>
<tr><td>FS: Lightning Storm - Ludleth for Nameless</td><td>Boss weapon for Nameless King</td></tr>
<tr><td>FS: Lloyd&#x27;s Shield Ring - Paladin&#x27;s Ashes</td><td>Sold by Handmaid after giving Paladin&#x27;s Ashes</td></tr>
<tr><td>FS: Londor Braille Divine Tome - Yuria shop</td><td>Sold by Yuria</td></tr>
<tr><td>FS: Lorian&#x27;s Armor - shop after killing GA boss</td><td>Sold by Handmaid after defeating Lothric, Younger Prince</td></tr>
<tr><td>FS: Lorian&#x27;s Gauntlets - shop after killing GA boss</td><td>Sold by Handmaid after defeating Lothric, Younger Prince</td></tr>
<tr><td>FS: Lorian&#x27;s Greatsword - Ludleth for Princes</td><td>Boss weapon for Twin Princes</td></tr>
<tr><td>FS: Lorian&#x27;s Helm - shop after killing GA boss</td><td>Sold by Handmaid after defeating Lothric, Younger Prince</td></tr>
<tr><td>FS: Lorian&#x27;s Leggings - shop after killing GA boss</td><td>Sold by Handmaid after defeating Lothric, Younger Prince</td></tr>
<tr><td>FS: Lothric&#x27;s Holy Sword - Ludleth for Princes</td><td>Boss weapon for Twin Princes</td></tr>
<tr><td>FS: Magic Barrier - Irina for Tome of Lothric</td><td>Sold by Irina after giving her the Braille Divine Tome of Lothric</td></tr>
<tr><td>FS: Magic Shield - Orbeck</td><td>Sold by Orbeck</td></tr>
<tr><td>FS: Magic Shield - Yoel/Yuria shop</td><td>Sold by Yoel/Yuria</td></tr>
<tr><td>FS: Magic Weapon - Orbeck</td><td>Sold by Orbeck</td></tr>
<tr><td>FS: Magic Weapon - Yoel/Yuria shop</td><td>Sold by Yoel/Yuria</td></tr>
<tr><td>FS: Mail Breaker - Sirris for killing Creighton</td><td>Given by Sirris talking to her in Firelink Shrine after invading and vanquishing Creighton.</td></tr>
<tr><td>FS: Master&#x27;s Attire - NPC drop</td><td>Dropped by Sword Master</td></tr>
<tr><td>FS: Master&#x27;s Gloves - NPC drop</td><td>Dropped by Sword Master</td></tr>
<tr><td>FS: Med Heal - Irina for Tome of Carim</td><td>Sold by Irina after giving her the Braille Divine Tome of Carim</td></tr>
<tr><td>FS: Millwood Knight Armor - Captain&#x27;s Ashes</td><td>Sold by Handmaid after giving Captain&#x27;s Ashes</td></tr>
<tr><td>FS: Millwood Knight Gauntlets - Captain&#x27;s Ashes</td><td>Sold by Handmaid after giving Captain&#x27;s Ashes</td></tr>
<tr><td>FS: Millwood Knight Helm - Captain&#x27;s Ashes</td><td>Sold by Handmaid after giving Captain&#x27;s Ashes</td></tr>
<tr><td>FS: Millwood Knight Leggings - Captain&#x27;s Ashes</td><td>Sold by Handmaid after giving Captain&#x27;s Ashes</td></tr>
<tr><td>FS: Moaning Shield - Eygon</td><td>Dropped by Eygon of Carim</td></tr>
<tr><td>FS: Moonlight Greatsword - Ludleth for Oceiros</td><td>Boss weapon for Oceiros, the Consumed King</td></tr>
<tr><td>FS: Morion Blade - Yuria for Orbeck&#x27;s Ashes</td><td>Given by Yuria after giving Orbeck&#x27;s Ashes after she asks you to assassinate him, after he moves to Firelink Shrine. Can be done without killing Orbeck, by completing his questline.</td></tr>
<tr><td>FS: Morne&#x27;s Armor - shop after killing Eygon or LC boss</td><td>Sold by Handmaid after killing Eygon of Carim or defeating Dragonslayer Armour</td></tr>
<tr><td>FS: Morne&#x27;s Gauntlets - shop after killing Eygon or LC boss</td><td>Sold by Handmaid after killing Eygon of Carim or defeating Dragonslayer Armour</td></tr>
<tr><td>FS: Morne&#x27;s Great Hammer - Eygon</td><td>Dropped by Eygon of Carim</td></tr>
<tr><td>FS: Morne&#x27;s Helm - shop after killing Eygon or LC boss</td><td>Sold by Handmaid after killing Eygon of Carim or defeating Dragonslayer Armour</td></tr>
<tr><td>FS: Morne&#x27;s Leggings - shop after killing Eygon or LC boss</td><td>Sold by Handmaid after killing Eygon of Carim or defeating Dragonslayer Armour</td></tr>
<tr><td>FS: Old King&#x27;s Great Hammer - Ludleth for Old Demon King</td><td>Boss weapon for Old Demon King</td></tr>
<tr><td>FS: Old Moonlight - Ludleth for Midir</td><td>Boss weapon for Darkeater Midir</td></tr>
<tr><td>FS: Ordained Dress - shop after killing PW2 boss</td><td>Sold by Handmaid after defeating Sister Friede</td></tr>
<tr><td>FS: Ordained Hood - shop after killing PW2 boss</td><td>Sold by Handmaid after defeating Sister Friede</td></tr>
<tr><td>FS: Ordained Trousers - shop after killing PW2 boss</td><td>Sold by Handmaid after defeating Sister Friede</td></tr>
<tr><td>FS: Pale Shade Gloves - Yoel&#x27;s room, kill Londor Pale Shade twice</td><td>In Yoel/Yuria&#x27;s area after defeating both Londor Pale Shade invasions</td></tr>
<tr><td>FS: Pale Shade Robe - Yoel&#x27;s room, kill Londor Pale Shade twice</td><td>In Yoel/Yuria&#x27;s area after defeating both Londor Pale Shade invasions</td></tr>
<tr><td>FS: Pale Shade Trousers - Yoel&#x27;s room, kill Londor Pale Shade twice</td><td>In Yoel/Yuria&#x27;s area after defeating both Londor Pale Shade invasions</td></tr>
<tr><td>FS: Pestilent Mist - Orbeck for any scroll</td><td>Sold by Orbeck after giving him any scroll</td></tr>
<tr><td>FS: Poison Mist - Cornyx for Great Swamp Tome</td><td>Sold by Cornyx after giving him the Great Swamp Pyromancy Tome</td></tr>
<tr><td>FS: Pontiff&#x27;s Left Eye - Ludleth for Vordt</td><td>Boss weapon for Vordt of the Boreal Valley</td></tr>
<tr><td>FS: Prisoner&#x27;s Chain - Ludleth for Champion</td><td>Boss weapon for Champion Gundyr</td></tr>
<tr><td>FS: Profaned Greatsword - Ludleth for Pontiff</td><td>Boss weapon for Pontiff Sulyvahn</td></tr>
<tr><td>FS: Profuse Sweat - Cornyx for Great Swamp Tome</td><td>Sold by Cornyx after giving him the Great Swamp Pyromancy Tome</td></tr>
<tr><td>FS: Rapport - Karla for Quelana Tome</td><td>Sold by Karla after giving her the Quelana Pyromancy Tome</td></tr>
<tr><td>FS: Refined Gem - Captain&#x27;s Ashes</td><td>Sold by Handmaid after giving Captain&#x27;s Ashes</td></tr>
<tr><td>FS: Repair - Orbeck for Golden Scroll</td><td>Sold by Orbeck after giving him the Golden Scroll</td></tr>
<tr><td>FS: Repeating Crossbow - Ludleth for Gael</td><td>Boss weapon for Slave Knight Gael</td></tr>
<tr><td>FS: Replenishment - Irina</td><td>Sold by Irina after recruiting her, or in her ashes</td></tr>
<tr><td>FS: Ring of Sacrifice - Yuria shop</td><td>Sold by Yuria, or by Handmaid after giving Hollow&#x27;s Ashes</td></tr>
<tr><td>FS: Rose of Ariandel - Ludleth for Friede</td><td>Boss weapon for Sister Friede</td></tr>
<tr><td>FS: Rusted Gold Coin - don&#x27;t forgive Patches</td><td>Given by Patches after not forgiving him after he locks you in the Bell Tower.</td></tr>
<tr><td>FS: Sage&#x27;s Big Hat - shop after killing RS boss</td><td>Sold by Handmaid after defeating Crystal Sage</td></tr>
<tr><td>FS: Saint&#x27;s Ring - Irina</td><td>Sold by Irina after recruiting her, or in her ashes</td></tr>
<tr><td>FS: Seething Chaos - Ludleth for Demon Prince</td><td>Boss weapon for Demon Prince</td></tr>
<tr><td>FS: Silvercat Ring - Sirris for killing Creighton</td><td>Given by Sirris talking to her in Firelink Shrine after invading and vanquishing Creighton.</td></tr>
<tr><td>FS: Skull Ring - kill Ludleth</td><td>Dropped by Ludleth upon death, including after placing all cinders. Note that if killed before giving Transposing Kiln, transposition is not possible.</td></tr>
<tr><td>FS: Slumbering Dragoncrest Ring - Orbeck for buying four specific spells</td><td>Given by Orbeck after purchasing the shop items corresponding to Aural Decoy, Farron Flashsword, Spook (starting items), and Pestilent Mist (after giving one scroll).</td></tr>
<tr><td>FS: Smough&#x27;s Armor - shop after killing AL boss</td><td>Sold by Handmaid after defeating Alrich, Devourer of Gods</td></tr>
<tr><td>FS: Smough&#x27;s Gauntlets - shop after killing AL boss</td><td>Sold by Handmaid after defeating Alrich, Devourer of Gods</td></tr>
<tr><td>FS: Smough&#x27;s Helm - shop after killing AL boss</td><td>Sold by Handmaid after defeating Alrich, Devourer of Gods</td></tr>
<tr><td>FS: Smough&#x27;s Leggings - shop after killing AL boss</td><td>Sold by Handmaid after defeating Alrich, Devourer of Gods</td></tr>
<tr><td>FS: Sneering Mask - Yoel&#x27;s room, kill Londor Pale Shade twice</td><td>In Yoel/Yuria&#x27;s area after defeating both Londor Pale Shade invasions</td></tr>
<tr><td>FS: Soothing Sunlight - Ludleth for Dancer</td><td>Boss weapon for Dancer of the Boreal Valley</td></tr>
<tr><td>FS: Soul Arrow - Orbeck</td><td>Sold by Orbeck</td></tr>
<tr><td>FS: Soul Arrow - Yoel/Yuria shop</td><td>Sold by Yoel/Yuria</td></tr>
<tr><td>FS: Soul Arrow - shop</td><td>Sold by Handmaid</td></tr>
<tr><td>FS: Soul Greatsword - Orbeck</td><td>Sold by Orbeck</td></tr>
<tr><td>FS: Soul Greatsword - Yoel/Yuria shop</td><td>Sold by Yoel/Yuria after using Draw Out True Strength</td></tr>
<tr><td>FS: Soul Spear - Orbeck for Logan&#x27;s Scroll</td><td>Sold by Orbeck after giving him Logan&#x27;s Scroll</td></tr>
<tr><td>FS: Soul of a Deserted Corpse - bell tower door</td><td>Next to the door requiring the Tower Key</td></tr>
<tr><td>FS: Spook - Orbeck</td><td>Sold by Orbeck</td></tr>
<tr><td>FS: Storm Curved Sword - Ludleth for Nameless</td><td>Boss weapon for Nameless King</td></tr>
<tr><td>FS: Sunless Armor - shop, Sirris quest, kill GA boss</td><td>Sold by Handmaid after completing Sirris&#x27; questline</td></tr>
<tr><td>FS: Sunless Gauntlets - shop, Sirris quest, kill GA boss</td><td>Sold by Handmaid after completing Sirris&#x27; questline</td></tr>
<tr><td>FS: Sunless Leggings - shop, Sirris quest, kill GA boss</td><td>Sold by Handmaid after completing Sirris&#x27; questline</td></tr>
<tr><td>FS: Sunless Talisman - Sirris, kill GA boss</td><td>Dropped by Sirris on death or quest completion.</td></tr>
<tr><td>FS: Sunless Veil - shop, Sirris quest, kill GA boss</td><td>Sold by Handmaid after completing Sirris&#x27; questline</td></tr>
<tr><td>FS: Sunlight Spear - Ludleth for Cinder</td><td>Boss weapon for Soul of Cinder</td></tr>
<tr><td>FS: Sunset Shield - by grave after killing Hodrick w/Sirris</td><td>Left by Sirris upon quest completion.</td></tr>
<tr><td>FS: Tears of Denial - Irina for Tome of Carim</td><td>Sold by Irina after giving her the Braille Divine Tome of Carim</td></tr>
<tr><td>FS: Titanite Scale - Greirat from IBV</td><td>Sold by Greirat after pillaging Irithyll</td></tr>
<tr><td>FS: Titanite Slab - shop after placing all Cinders</td><td>Sold by Handmaid after placing all Cinders of a Lord on their thrones</td></tr>
<tr><td>FS: Tower Key - shop</td><td>Sold by both Shrine Handmaid and Untended Graves Handmaid</td></tr>
<tr><td>FS: Twinkling Titanite - Greirat from IBV</td><td>Sold by Greirat after pillaging Irithyll</td></tr>
<tr><td>FS: Twisted Wall of Light - Orbeck for Golden Scroll</td><td>Sold by Orbeck after giving him the Golden Scroll</td></tr>
<tr><td>FS: Uchigatana - NPC drop</td><td>Dropped by Sword Master</td></tr>
<tr><td>FS: Undead Legion Armor - shop after killing FK boss</td><td>Sold by Handmaid after defeating Abyss Watchers</td></tr>
<tr><td>FS: Undead Legion Gauntlet - shop after killing FK boss</td><td>Sold by Handmaid after defeating Abyss Watchers</td></tr>
<tr><td>FS: Undead Legion Helm - shop after killing FK boss</td><td>Sold by Handmaid after defeating Abyss Watchers</td></tr>
<tr><td>FS: Undead Legion Leggings - shop after killing FK boss</td><td>Sold by Handmaid after defeating Abyss Watchers</td></tr>
<tr><td>FS: Untrue Dark Ring - Yuria shop</td><td>Sold by Yuria</td></tr>
<tr><td>FS: Untrue White Ring - Yuria shop</td><td>Sold by Yuria</td></tr>
<tr><td>FS: Vordt&#x27;s Great Hammer - Ludleth for Vordt</td><td>Boss weapon for Vordt of the Boreal Valley</td></tr>
<tr><td>FS: Vow of Silence - Karla for Londor Tome</td><td>Sold by Irina or Karla after giving one the Londor Braille Divine Tome</td></tr>
<tr><td>FS: Washing Pole - Easterner&#x27;s Ashes</td><td>Sold by Handmaid after giving Easterner&#x27;s Ashes</td></tr>
<tr><td>FS: White Dragon Breath - Ludleth for Oceiros</td><td>Boss weapon for Oceiros, the Consumed King</td></tr>
<tr><td>FS: White Sign Soapstone - shop</td><td>Sold by both Shrine Handmaid and Untended Graves Handmaid</td></tr>
<tr><td>FS: Wolf Knight&#x27;s Greatsword - Ludleth for Abyss Watchers</td><td>Boss weapon for Abyss Watchers</td></tr>
<tr><td>FS: Wolf Ring+2 - left of boss room exit</td><td>After Iudex Gundyr on the left</td></tr>
<tr><td>FS: Wolnir&#x27;s Crown - shop after killing CC boss</td><td>Sold by Handmaid after defeating High Lord Wolnir</td></tr>
<tr><td>FS: Wolnir&#x27;s Holy Sword - Ludleth for Wolnir</td><td>Boss weapon for High Lord Wolnir</td></tr>
<tr><td>FS: Wood Grain Ring - Easterner&#x27;s Ashes</td><td>Sold by Handmaid after giving Easterner&#x27;s Ashes</td></tr>
<tr><td>FS: Xanthous Gloves - Xanthous Ashes</td><td>Sold by Handmaid after giving Xanthous Ashes</td></tr>
<tr><td>FS: Xanthous Overcoat - Xanthous Ashes</td><td>Sold by Handmaid after giving Xanthous Ashes</td></tr>
<tr><td>FS: Xanthous Trousers - Xanthous Ashes</td><td>Sold by Handmaid after giving Xanthous Ashes</td></tr>
<tr><td>FS: Yhorm&#x27;s Great Machete - Ludleth for Yhorm</td><td>Boss weapon for Yhorm the Giant</td></tr>
<tr><td>FS: Yhorm&#x27;s Greatshield - Ludleth for Yhorm</td><td>Boss weapon for Yhorm the Giant</td></tr>
<tr><td>FS: Young Dragon Ring - Orbeck for one scroll and buying three spells</td><td>Given by Orbeck after purchasing four sorceries from him, and giving him one scroll, as a non-sorcerer.</td></tr>
<tr><td>FSBT: Armor of the Sun - crow for Siegbräu</td><td>Trade Siegbräu with crow</td></tr>
<tr><td>FSBT: Blessed Gem - crow for Moaning Shield</td><td>Trade Moaning Shield with crow</td></tr>
<tr><td>FSBT: Covetous Silver Serpent Ring - illusory wall past rafters</td><td>From the Firelink Shrine roof, past the rafters and an illusory wall</td></tr>
<tr><td>FSBT: Estus Ring - tower base</td><td>Dropping down from the Bell Tower to where Irina eventually resides</td></tr>
<tr><td>FSBT: Estus Shard - rafters</td><td>In the Firelink Shrine rafters, accessible from the roof</td></tr>
<tr><td>FSBT: Fire Keeper Gloves - partway down tower</td><td>Dropping down to the left after entering the Bell Tower. Align with the center of the closest floor tile row and run off the edge at full speed, aiming slightly left.</td></tr>
<tr><td>FSBT: Fire Keeper Robe - partway down tower</td><td>Dropping down to the left after entering the Bell Tower. Align with the center of the closest floor tile row and run off the edge at full speed, aiming slightly left.</td></tr>
<tr><td>FSBT: Fire Keeper Skirt - partway down tower</td><td>Dropping down to the left after entering the Bell Tower. Align with the center of the closest floor tile row and run off the edge at full speed, aiming slightly left.</td></tr>
<tr><td>FSBT: Fire Keeper Soul - tower top</td><td>At the top of the Bell Tower</td></tr>
<tr><td>FSBT: Hello Carving - crow for Alluring Skull</td><td>Trade Alluring Skull with crow</td></tr>
<tr><td>FSBT: Help me! Carving - crow for any sacred chime</td><td>Trade any Sacred Chime with crow</td></tr>
<tr><td>FSBT: Hollow Gem - crow for Eleonora</td><td>Trade Eleonora with crow</td></tr>
<tr><td>FSBT: Homeward Bone - roof</td><td>On Firelink Shrine roof</td></tr>
<tr><td>FSBT: I&#x27;m sorry Carving - crow for Shriving Stone</td><td>Trade Shriving Stone with crow</td></tr>
<tr><td>FSBT: Iron Bracelets - crow for Homeward Bone</td><td>Trade Homeward Bone with crow</td></tr>
<tr><td>FSBT: Iron Helm - crow for Lightning Urn</td><td>Trade Lightning Urn with crow</td></tr>
<tr><td>FSBT: Iron Leggings - crow for Seed of a Giant Tree</td><td>Trade Seed of a Giant Tree with crow</td></tr>
<tr><td>FSBT: Large Titanite Shard - crow for Firebomb</td><td>Trade Firebomb or Rope Firebomb with crow</td></tr>
<tr><td>FSBT: Lightning Gem - crow for Xanthous Crown</td><td>Trade Xanthous Crown with crow</td></tr>
<tr><td>FSBT: Lucatiel&#x27;s Mask - crow for Vertebra Shackle</td><td>Trade Vertebra Shackle with crow</td></tr>
<tr><td>FSBT: Porcine Shield - crow for Undead Bone Shard</td><td>Trade Undead Bone Shard with crow</td></tr>
<tr><td>FSBT: Ring of Sacrifice - crow for Loretta&#x27;s Bone</td><td>Trade Loretta&#x27;s Bone with crow</td></tr>
<tr><td>FSBT: Sunlight Shield - crow for Mendicant&#x27;s Staff</td><td>Trade Mendicant&#x27;s Staff with crow</td></tr>
<tr><td>FSBT: Thank you Carving - crow for Hidden Blessing</td><td>Trade Hidden Blessing with crow</td></tr>
<tr><td>FSBT: Titanite Chunk - crow for Black Firebomb</td><td>Trade Black Firebomb or Rope Black Firebomb with crow</td></tr>
<tr><td>FSBT: Titanite Scale - crow for Blacksmith Hammer</td><td>Trade Blacksmith Hammer with crow</td></tr>
<tr><td>FSBT: Titanite Slab - crow for Coiled Sword Fragment</td><td>Trade Coiled Sword Fragment with crow</td></tr>
<tr><td>FSBT: Twinkling Titanite - crow for Large Leather Shield</td><td>Trade Large Leather Shield with crow</td></tr>
<tr><td>FSBT: Twinkling Titanite - crow for Prism Stone</td><td>Trade Prism Stone with crow</td></tr>
<tr><td>FSBT: Twinkling Titanite - lizard behind Firelink</td><td>Dropped by the Crystal Lizard behind Firelink Shrine. Can be accessed with tree jump by going all the way around the roof, left of the entrance to the rafters, or alternatively dropping down from the Bell Tower.</td></tr>
<tr><td>FSBT: Very good! Carving - crow for Divine Blessing</td><td>Trade Divine Blessing with crow</td></tr>
<tr><td>GA: Avelyn - 1F, drop from 3F onto bookshelves</td><td>On top of a bookshelf on the Archive first floor, accessible by going halfway up the stairs to the third floor, dropping down past the Grand Archives Scholar, and then dropping down again</td></tr>
<tr><td>GA: Blessed Gem - rafters</td><td>On the rafters high above the Archives, can be accessed by dropping down from the Winged Knight roof area</td></tr>
<tr><td>GA: Chaos Gem - dark room, lizard</td><td>Dropped by a Crystal Lizard on the Archives first floor in the dark room past the large wax pool</td></tr>
<tr><td>GA: Cinders of a Lord - Lothric Prince</td><td>Dropped by Twin Princes</td></tr>
<tr><td>GA: Crystal Chime - 1F, path from wax pool</td><td>On the Archives first floor, in the room with the Lothric Knight, to the right</td></tr>
<tr><td>GA: Crystal Gem - 1F, lizard by drop</td><td>Dropped by the Crystal Lizard on the Archives first floor along the left wall</td></tr>
<tr><td>GA: Crystal Scroll - 2F late, miniboss drop</td><td>Dropped by the Grand Archives Crystal Sage</td></tr>
<tr><td>GA: Divine Blessing - rafters, down lower level ladder</td><td>In a chest reachable after dropping down from the Archives rafters and down a ladder near the Corpse-grub</td></tr>
<tr><td>GA: Divine Pillars of Light - cage above rafters</td><td>In a cage above the rafters high above the Archives, can be accessed by dropping down from the Winged Knight roof area</td></tr>
<tr><td>GA: Ember - 5F, by entrance</td><td>On a balcony high in the Archives overlooking the area with the Grand Archives Scholars with a shortcut ladder, on the opposite side from the wax pool</td></tr>
<tr><td>GA: Estus Shard - dome, far balcony</td><td>On the Archives roof near the three Winged Knights, in a side area overlooking the ocean.</td></tr>
<tr><td>GA: Fleshbite Ring - up stairs from 4F</td><td>From the first shortcut elevator with the movable bookshelf, past the Scholars right before going outside onto the roof, in an alcove to the right with many Clawed Curse bookshelves</td></tr>
<tr><td>GA: Golden Wing Crest Shield - outside 5F, NPC drop</td><td>Dropped by Lion Knight Albert before the stairs leading up to Twin Princes</td></tr>
<tr><td>GA: Heavy Gem - rooftops, lizard</td><td>Dropped by one of the pair of Crystal Lizards, on the right side, found going up a slope past the gargoyle on the Archives roof</td></tr>
<tr><td>GA: Hollow Gem - rooftops lower, in hall</td><td>Going onto the roof and down the first ladder, dropping down on either side from the ledge facing the ocean, in a tunnel underneath the ledge</td></tr>
<tr><td>GA: Homeward Bone - 2F early balcony</td><td>On the Archives second floor, on the balcony with the ladder going up to the Crystal Sage</td></tr>
<tr><td>GA: Hunter&#x27;s Ring - dome, very top</td><td>At the top of the ladder in roof the area with the Winged Knights</td></tr>
<tr><td>GA: Large Soul of a Crestfallen Knight - 4F, back</td><td>In the back of a Clawed Curse-heavy corridor of bookshelves, in the area with the Grand Archives Scholars and dropdown ladder, after the first shortcut elevator with the movable bookshelf</td></tr>
<tr><td>GA: Large Soul of a Crestfallen Knight - outside 5F</td><td>In the middle of the area with the three human NPCs attacking you, before the Grand Archives bonfire shortcut elevator</td></tr>
<tr><td>GA: Lingering Dragoncrest Ring+2 - dome, room behind spire</td><td>Near the tower with the Winged Knights, up the stairs on the opposite side from the ladder leading up to the Hunter&#x27;s Ring</td></tr>
<tr><td>GA: Onikiri and Ubadachi - outside 5F, NPC drop</td><td>Dropped by Black Hand Kamui before the stairs leading up to Twin Princes</td></tr>
<tr><td>GA: Outrider Knight Armor - 3F, behind illusory wall, miniboss drop</td><td>Dropped by an Outrider Knight past the Crystal Sage&#x27;s third floor location and an illusory wall</td></tr>
<tr><td>GA: Outrider Knight Gauntlets - 3F, behind illusory wall, miniboss drop</td><td>Dropped by an Outrider Knight past the Crystal Sage&#x27;s third floor location and an illusory wall</td></tr>
<tr><td>GA: Outrider Knight Helm - 3F, behind illusory wall, miniboss drop</td><td>Dropped by an Outrider Knight past the Crystal Sage&#x27;s third floor location and an illusory wall</td></tr>
<tr><td>GA: Outrider Knight Leggings - 3F, behind illusory wall, miniboss drop</td><td>Dropped by an Outrider Knight past the Crystal Sage&#x27;s third floor location and an illusory wall</td></tr>
<tr><td>GA: Power Within - dark room, behind retractable bookshelf</td><td>Behind a bookshelf in the dark room with the Crystal Lizards, moved by a lever in the same room</td></tr>
<tr><td>GA: Refined Gem - up stairs from 4F, lizard</td><td>Dropped by a Crystal Lizard found heading from the first elevator shortcut with the movable bookshelf, on the right side up the stairs before exiting to the roof</td></tr>
<tr><td>GA: Sage Ring+1 - rafters, second level down</td><td>On the rafters high above the Grand Archives, dropping down from the cage to the high rafters to the rafters below with the Corpse-grub</td></tr>
<tr><td>GA: Sage&#x27;s Crystal Staff - outside 5F, NPC drop</td><td>Dropped by Daughter of Crystal Kriemhild before the stairs leading up to Twin Princes</td></tr>
<tr><td>GA: Scholar Ring - 2F, between late and early</td><td>On the corpse of a sitting Archives Scholar between two bookshelves, accessible by activating a lever before crossing the bridge that is the Crystal Sage&#x27;s final location</td></tr>
<tr><td>GA: Sharp Gem - rooftops, lizard</td><td>Dropped by one of the pair of Crystal Lizards, on the left side, found going up a slope past the gargoyle on the Archives roof</td></tr>
<tr><td>GA: Shriving Stone - 2F late, by ladder from 3F</td><td>Going from the Crystal Sage&#x27;s location on the third floor to its location on the bridge, after descending the ladder</td></tr>
<tr><td>GA: Soul Stream - 3F, behind illusory wall</td><td>Past the Crystal Sage&#x27;s third floor location, an illusory wall, and an Outrider Knight, on the corpse of a sitting Archives Scholar</td></tr>
<tr><td>GA: Soul of a Crestfallen Knight - 1F, loop left after drop</td><td>On the Archives first floor, hugging the left wall, on a ledge that loops back around to the left wall</td></tr>
<tr><td>GA: Soul of a Crestfallen Knight - path to dome</td><td>On balcony of the building with the second shortcut elevator down to the bonfire, accessible by going up the spiral stairs to the left</td></tr>
<tr><td>GA: Soul of a Nameless Soldier - dark room</td><td>On the Archives first floor, after the wax pool, against a Clawed Curse bookshelf</td></tr>
<tr><td>GA: Soul of a Weary Warrior - rooftops, by lizards</td><td>On the Archives roof, going up the first rooftop slope where a Gargoyle always attacks you</td></tr>
<tr><td>GA: Soul of the Twin Princes</td><td>Dropped by Twin Princes</td></tr>
<tr><td>GA: Titanite Chunk - 1F, balcony</td><td>On the Archives first floor, on balcony overlooking the entrance opposite from the Grand Archives Scholars wax pool</td></tr>
<tr><td>GA: Titanite Chunk - 1F, path from wax pool</td><td>On the Archives first floor, toward the Lothric Knight, turning right to a ledge leading back to the entrance area</td></tr>
<tr><td>GA: Titanite Chunk - 1F, up right stairs</td><td>Going right after entering the Archives entrance and up the short flight of stairs</td></tr>
<tr><td>GA: Titanite Chunk - 2F, by wax pool</td><td>Up the stairs from the Archives second floor on the right side from the entrance, in a corner near the small wax pool</td></tr>
<tr><td>GA: Titanite Chunk - 2F, right after dark room</td><td>Exiting from the dark room with the Crystal Lizards on the first floor onto the second floor main room, then taking an immediate right</td></tr>
<tr><td>GA: Titanite Chunk - 5F, far balcony</td><td>On a balcony outside where Lothric Knight stands on the top floor of the Archives, accessing by going right from the final wax pool or by dropping down from the gargoyle area</td></tr>
<tr><td>GA: Titanite Chunk - rooftops lower, ledge by buttress</td><td>Going onto the roof and down the first ladder, dropping down on either side from the ledge facing the ocean, on a roof ledge to the right</td></tr>
<tr><td>GA: Titanite Chunk - rooftops, balcony</td><td>Going onto the roof and down the first ladder, all the way down the ledge facing the ocean to the right</td></tr>
<tr><td>GA: Titanite Chunk - rooftops, just before 5F</td><td>On the Archives roof, after a short dropdown, in the small area where the two Gargoyles attack you</td></tr>
<tr><td>GA: Titanite Scale - 1F, drop from 2F late onto bookshelves, lizard</td><td>Dropped by a Crystal Lizard on first floor bookshelves. Can be accessed by dropping down to the left at the end of the bridge which is the Crystal Sage&#x27;s final location</td></tr>
<tr><td>GA: Titanite Scale - 1F, up stairs on bookshelf</td><td>On the Archives first floor, up a movable set of stairs near the large wax pool, on top of a bookshelf</td></tr>
<tr><td>GA: Titanite Scale - 2F, titanite scale atop bookshelf</td><td>On top of a bookshelf on the Archive second floor, accessible by going halfway up the stairs to the third floor and dropping down near a Grand Archives Scholar</td></tr>
<tr><td>GA: Titanite Scale - 3F, by ladder to 2F late</td><td>Going from the Crystal Sage&#x27;s location on the third floor to its location on the bridge, on the left side of the ladder you descend, behind a table</td></tr>
<tr><td>GA: Titanite Scale - 3F, corner up stairs</td><td>From the Grand Archives third floor up past the thralls, in a corner with bookshelves to the left</td></tr>
<tr><td>GA: Titanite Scale - 4F, chest by exit</td><td>In a chest after the first elevator shortcut with the movable bookshelf, in the area with the Grand Archives Scholars, to the left of the stairwell leading up to the roof</td></tr>
<tr><td>GA: Titanite Scale - dark room, upstairs</td><td>Right after going up the stairs to the Archives second floor, on the left guarded by a Grand Archives Scholar and a sequence of Clawed Curse bookshelves</td></tr>
<tr><td>GA: Titanite Scale - rooftops lower, path to 2F</td><td>Going onto the roof and down the first ladder, dropping down on either side from the ledge facing the ocean, then going past the corvians all the way to the left and making a jump</td></tr>
<tr><td>GA: Titanite Slab - 1F, after pulling 2F switch</td><td>In a chest on the Archives first floor, behind a bookshelf moved by pulling a lever in the middle of the second floor between two cursed bookshelves</td></tr>
<tr><td>GA: Titanite Slab - dome, kill all mobs</td><td>Dropped by killing all three Winged Knights on top of the Archives</td></tr>
<tr><td>GA: Titanite Slab - final elevator secret</td><td>At the bottom of the shortcut elevator right outside the Twin Princes fight. Requires sending the elevator up to the top from the middle, and then riding the lower elevator down.</td></tr>
<tr><td>GA: Twinkling Titanite - 1F, lizard by drop</td><td>Dropped by the Crystal Lizard on the Archives first floor along the left wall</td></tr>
<tr><td>GA: Twinkling Titanite - 2F, lizard by entrance</td><td>Dropped by the Crystal Lizard on the Archives second floor, going toward the stairs/balcony</td></tr>
<tr><td>GA: Twinkling Titanite - dark room, lizard #1</td><td>Dropped by a Crystal Lizard on the Archives first floor in the dark room past the large wax pool</td></tr>
<tr><td>GA: Twinkling Titanite - dark room, lizard #2</td><td>Dropped by a Crystal Lizard on the Archives first floor in the dark room past the large wax pool</td></tr>
<tr><td>GA: Twinkling Titanite - rafters, down lower level ladder</td><td>In a chest reachable after dropping down from the Archives rafters and down a ladder near the Corpse-grub</td></tr>
<tr><td>GA: Twinkling Titanite - rooftops, lizard #1</td><td>Dropped by one of the pair of Crystal Lizards, on the right side, found going up a slope past the gargoyle on the Archives roof</td></tr>
<tr><td>GA: Twinkling Titanite - rooftops, lizard #2</td><td>Dropped by one of the pair of Crystal Lizards, on the left side, found going up a slope past the gargoyle on the Archives roof</td></tr>
<tr><td>GA: Twinkling Titanite - up stairs from 4F, lizard</td><td>Dropped by a Crystal Lizard found heading from the first elevator shortcut with the movable bookshelf, on the right side up the stairs before exiting to the roof</td></tr>
<tr><td>GA: Undead Bone Shard - 5F, by entrance</td><td>On the corpse of a sitting Archives Scholar on a balcony high in the Archives overlooking the area with the Grand Archives Scholars with a shortcut ladder, near the final wax pool</td></tr>
<tr><td>GA: Witch&#x27;s Locks - dark room, behind retractable bookshelf</td><td>Behind a bookshelf in the dark room with the Crystal Lizards, moved by a lever in the same room</td></tr>
<tr><td>HWL: Astora Straight Sword - fort walkway, drop down</td><td>In the building with the Pus of Man on the roof, past the Lothric Knight down a hallway obscured by a wooden wheel, dropping down past the edge</td></tr>
<tr><td>HWL: Basin of Vows - Emma</td><td>Dropped by Emma upon killing her. This is possible to do at any time</td></tr>
<tr><td>HWL: Battle Axe - flame tower, mimic</td><td>Dropped by mimic in the building guarded by the fire-breathing wyvern</td></tr>
<tr><td>HWL: Binoculars - corpse tower, upper platform</td><td>In the area with the dead wyvern, at the top of a set of stairs past a Hollow Soldier</td></tr>
<tr><td>HWL: Black Firebomb - small roof over fountain</td><td>After roof with Pus of Man, on the edge of another rooftop to the left where you can drop down into Winged Knight area</td></tr>
<tr><td>HWL: Broadsword - fort, room off walkway</td><td>In the building with the Pus of Man on the roof, past the Lothric Knight in an alcove to the left</td></tr>
<tr><td>HWL: Cell Key - fort ground, down stairs</td><td>In the basement of the building with Pus of Man on the roof, down the stairs guarded by a dog</td></tr>
<tr><td>HWL: Claymore - flame plaza</td><td>In the area where the wyvern breathes fire, farthest away from the door</td></tr>
<tr><td>HWL: Club - flame plaza</td><td>In the area where the wyvern breathes fire, in the open</td></tr>
<tr><td>HWL: Ember - back tower, transforming hollow</td><td>Dropped by the Pus of Man on the tower to the right of the High Wall bonfire after transformation</td></tr>
<tr><td>HWL: Ember - flame plaza</td><td>In the area where the wyvern breathes fire, in the open</td></tr>
<tr><td>HWL: Ember - fort roof, transforming hollow</td><td>Dropped by the Pus of Man on the roof after the Tower on the Wall bonfire after transformation</td></tr>
<tr><td>HWL: Ember - fountain #1</td><td>In the area with the Winged Knight</td></tr>
<tr><td>HWL: Ember - fountain #2</td><td>In the area with the Winged Knight</td></tr>
<tr><td>HWL: Estus Shard - fort ground, on anvil</td><td>In the basement of the building with the Pus of Man on the roof, on the blacksmith anvil</td></tr>
<tr><td>HWL: Firebomb - corpse tower, under table</td><td>In the building near the dead wyvern, behind a table near the ladder you descend</td></tr>
<tr><td>HWL: Firebomb - fort roof</td><td>Next to the Pus of Man on the roof</td></tr>
<tr><td>HWL: Firebomb - top of ladder to fountain</td><td>By the long ladder leading down to the area with the Winged Knight</td></tr>
<tr><td>HWL: Firebomb - wall tower, beam</td><td>In the building with the Tower on the Wall bonfire, on a wooden beam overhanging the lower levels</td></tr>
<tr><td>HWL: Fleshbite Ring+1 - fort roof, jump to other roof</td><td>Jumping from the roof with the Pus of Man to a nearby building with a fenced roof</td></tr>
<tr><td>HWL: Gold Pine Resin - corpse tower, drop</td><td>Dropping past the dead wyvern, down the left path from the High Wall bonfire</td></tr>
<tr><td>HWL: Green Blossom - fort walkway, hall behind wheel</td><td>In the building with the Pus of Man on the roof, past the Lothric Knight down a hallway obscured by a wooden wheel</td></tr>
<tr><td>HWL: Green Blossom - shortcut, lower courtyard</td><td>In the courtyard at the bottom of the shortcut elevator</td></tr>
<tr><td>HWL: Large Soul of a Deserted Corpse - flame plaza</td><td>In the area where the wyvern breathes fire, behind one of the praying statues</td></tr>
<tr><td>HWL: Large Soul of a Deserted Corpse - fort roof</td><td>On the edge of the roof with the Pus of Man</td></tr>
<tr><td>HWL: Large Soul of a Deserted Corpse - platform by fountain</td><td>Coming from the elevator shortcut, on a side path to the left (toward Winged Knight area)</td></tr>
<tr><td>HWL: Longbow - back tower</td><td>Down the path from the right of the High Wall bonfire, where the Pus of Man and crossbowman are</td></tr>
<tr><td>HWL: Lucerne - promenade, side path</td><td>On one of the side paths from the main path connecting Dancer and Vordt fights, patrolled by a Lothric Knight</td></tr>
<tr><td>HWL: Mail Breaker - wall tower, path to Greirat</td><td>In the basement of the building with the Tower on the Wall bonfire on the roof, before Greirat&#x27;s cell</td></tr>
<tr><td>HWL: Rapier - fountain, corner</td><td>In a corner in the area with the Winged Knight</td></tr>
<tr><td>HWL: Raw Gem - fort roof, lizard</td><td>Dropped by the Crystal Lizard on the rooftop after the Tower on the Wall bonfire</td></tr>
<tr><td>HWL: Red Eye Orb - wall tower, miniboss</td><td>Dropped by the Darkwraith past the Lift Chamber Key</td></tr>
<tr><td>HWL: Refined Gem - promenade miniboss</td><td>Dropped by the red-eyed Lothric Knight to the left of the Dancer&#x27;s room entrance</td></tr>
<tr><td>HWL: Ring of Sacrifice - awning by fountain</td><td>Coming from the elevator shortcut, on a side path to the left (toward Winged Knight area), jumping onto a wooden support</td></tr>
<tr><td>HWL: Ring of the Evil Eye+2 - fort ground, far wall</td><td>In the basement of the building with the Pus of Man on the roof, on the far wall past the stairwell, behind some barrels</td></tr>
<tr><td>HWL: Silver Eagle Kite Shield - fort mezzanine</td><td>In the chest on the balcony overlooking the basement of the building with the Pus of Man on the roof</td></tr>
<tr><td>HWL: Small Lothric Banner - Emma</td><td>Given by Emma, or dropped upon death</td></tr>
<tr><td>HWL: Soul of Boreal Valley Vordt</td><td>Dropped by Vordt of the Boreal Valley</td></tr>
<tr><td>HWL: Soul of a Deserted Corpse - by wall tower door</td><td>Right before the entrance to the building with the Tower on the Wall bonfire</td></tr>
<tr><td>HWL: Soul of a Deserted Corpse - corpse tower, bottom floor</td><td>Down the ladder of the building near the dead wyvern, on the way to the living wyvern</td></tr>
<tr><td>HWL: Soul of a Deserted Corpse - fort entry, corner</td><td>In the corner of the room with a Lothric Knight, with the Pus of Man on the roof</td></tr>
<tr><td>HWL: Soul of a Deserted Corpse - fountain, path to promenade</td><td>In between the Winged Knight area and the Dancer/Vordt corridor</td></tr>
<tr><td>HWL: Soul of a Deserted Corpse - path to back tower, by lift door</td><td>Where the Greataxe Hollow Soldier patrols outside of the elevator shortcut entrance</td></tr>
<tr><td>HWL: Soul of a Deserted Corpse - path to corpse tower</td><td>At the very start, heading left from the High Wall bonfire</td></tr>
<tr><td>HWL: Soul of a Deserted Corpse - wall tower, right of exit</td><td>Exiting the building with the Tower on the Wall bonfire on the roof, immediately to the right</td></tr>
<tr><td>HWL: Soul of the Dancer</td><td>Dropped by Dancer of the Boreal Valley</td></tr>
<tr><td>HWL: Standard Arrow - back tower</td><td>Down the path from the right of the High Wall bonfire, where the Pus of Man and crossbowman are</td></tr>
<tr><td>HWL: Throwing Knife - shortcut, lift top</td><td>At the top of the elevator shortcut, opposite from the one-way door</td></tr>
<tr><td>HWL: Throwing Knife - wall tower, path to Greirat</td><td>In the basement of the building with the Tower on the Wall bonfire, in the room with the explosive barrels</td></tr>
<tr><td>HWL: Titanite Shard - back tower, transforming hollow</td><td>Dropped by the Pus of Man on the tower to the right of the High Wall bonfire after transformation</td></tr>
<tr><td>HWL: Titanite Shard - fort ground behind crates</td><td>Behind some wooden crates in the basement of the building with the Pus of Man on the roof</td></tr>
<tr><td>HWL: Titanite Shard - fort roof, transforming hollow</td><td>Dropped by the Pus of Man on the roof after the Tower on the Wall bonfire after transformation</td></tr>
<tr><td>HWL: Titanite Shard - fort, room off entry</td><td>In the building with the Pus of Man on the roof, in a room to the left and up the short stairs</td></tr>
<tr><td>HWL: Titanite Shard - wall tower, corner by bonfire</td><td>On the balcony with the Tower on the Wall bonfire</td></tr>
<tr><td>HWL: Undead Hunter Charm - fort, room off entry, in pot</td><td>In the building with the Pus of Man on the roof, in a room to the left, in a pot you have to break</td></tr>
<tr><td>HWL: Way of Blue - Emma</td><td>Given by Emma or dropped upon death.</td></tr>
<tr><td>IBV: Blood Gem - descent, platform before lake</td><td>In front of the tree in the courtyard before going down the stairs to the lake leading to the Distant Manor bonfire</td></tr>
<tr><td>IBV: Blue Bug Pellet - ascent, in last building</td><td>In the final building before Pontiff&#x27;s cathedral, coming from the sewer, on the first floor</td></tr>
<tr><td>IBV: Blue Bug Pellet - descent, dark room</td><td>In the dark area with the Irithyllian slaves, to the left of the staircase</td></tr>
<tr><td>IBV: Budding Green Blossom - central, by second fountain</td><td>Next to the fountain up the stairs from the Central Irithyll bonfire</td></tr>
<tr><td>IBV: Chloranthy Ring+1 - plaza, behind altar</td><td>In the area before and below Pontiff&#x27;s cathedral, behind the central structure</td></tr>
<tr><td>IBV: Covetous Gold Serpent Ring+1 - descent, drop after dark room</td><td>After the dark area with the Irithyllian slaves, drop down to the right</td></tr>
<tr><td>IBV: Creighton&#x27;s Steel Mask - bridge after killing Creighton</td><td>Following Sirris&#x27; questline, found on the bridge to Irithyll after being invaded by Creighton the Wanderer in the graveyard after the Church of Yorshka.</td></tr>
<tr><td>IBV: Divine Blessing - great hall, chest</td><td>In a chest up the stairs in the room with the Silver Knight staring at the painting</td></tr>
<tr><td>IBV: Divine Blessing - great hall, mob drop</td><td>One-time drop from the Silver Knight staring at the painting in Irithyll</td></tr>
<tr><td>IBV: Dorhys&#x27; Gnawing - Dorhys drop</td><td>Dropped by Cathedral Evangelist Dorhys, past an illusory railing past the Central Irithyll Fire Witches and to the left</td></tr>
<tr><td>IBV: Dragonslayer&#x27;s Axe - Creighton drop</td><td>Following Sirris&#x27; questline, dropped by Creighton the Wanderer when he invades in the graveyard after the Church of Yorshka.</td></tr>
<tr><td>IBV: Dung Pie - sewer #1</td><td>In the area with the sewer centipedes</td></tr>
<tr><td>IBV: Dung Pie - sewer #2</td><td>In the area with the sewer centipedes</td></tr>
<tr><td>IBV: Ember - shortcut from church to cathedral</td><td>After the gate shortcut from Church of Yorshka to Pontiff&#x27;s cathedral</td></tr>
<tr><td>IBV: Emit Force - Siegward</td><td>Given by Siegward meeting him in the Irithyll kitchen after the Sewer Centipedes.</td></tr>
<tr><td>IBV: Excrement-covered Ashes - sewer, by stairs</td><td>In the area with the sewer centipedes, before going up the stairs to the kitchen</td></tr>
<tr><td>IBV: Fading Soul - descent, cliff edge #1</td><td>In the graveyard down the stairs from the Church of Yorshka, at the cliff edge</td></tr>
<tr><td>IBV: Fading Soul - descent, cliff edge #2</td><td>In the graveyard down the stairs from the Church of Yorshka, at the cliff edge</td></tr>
<tr><td>IBV: Great Heal - lake, dead Corpse-Grub</td><td>On the Corpse-grub at the edge of the lake leading to the Distant Manor bonfire</td></tr>
<tr><td>IBV: Green Blossom - lake wall</td><td>On the wall of the lake leading to the Distant Manor bonfire</td></tr>
<tr><td>IBV: Green Blossom - lake, by Distant Manor</td><td>In the lake close to the Distant Manor bonfire</td></tr>
<tr><td>IBV: Green Blossom - lake, by stairs from descent</td><td>Going down the stairs into the lake leading to the Distant Manor bonfire</td></tr>
<tr><td>IBV: Homeward Bone - descent, before gravestone</td><td>In the graveyard down the stairs from the Church of Yorshka, in front of the grave with the Corvian</td></tr>
<tr><td>IBV: Kukri - descent, side path</td><td>Down the stairs from the graveyard after Church of Yorshka, before the group of dogs in the left path</td></tr>
<tr><td>IBV: Large Soul of a Nameless Soldier - ascent, after great hall</td><td>By the tree near the stairs from the sewer leading up to Pontiff&#x27;s cathedral, where the first dogs attack you</td></tr>
<tr><td>IBV: Large Soul of a Nameless Soldier - central, by bonfire</td><td>By the Central Irithyll bonfire</td></tr>
<tr><td>IBV: Large Soul of a Nameless Soldier - central, by second fountain</td><td>Next to the fountain up the stairs from the Central Irithyll bonfire</td></tr>
<tr><td>IBV: Large Soul of a Nameless Soldier - lake island</td><td>On an island in the lake leading to the Distant Manor bonfire</td></tr>
<tr><td>IBV: Large Soul of a Nameless Soldier - path to plaza</td><td>On the path from Central Irithyll bonfire, before making the left toward Church of Yorshka</td></tr>
<tr><td>IBV: Large Titanite Shard - Distant Manor, under overhang</td><td>Under overhang next to second set of stairs leading from Distant Manor bonfire</td></tr>
<tr><td>IBV: Large Titanite Shard - ascent, by elevator door</td><td>On the path from the sewer leading up to Pontiff&#x27;s cathedral, to the right of the statue surrounded by dogs</td></tr>
<tr><td>IBV: Large Titanite Shard - ascent, down ladder in last building</td><td>Outside the final building before Pontiff&#x27;s cathedral, coming from the sewer, dropping down to the left before the entrance</td></tr>
<tr><td>IBV: Large Titanite Shard - central, balcony just before plaza</td><td>From the Central Irithyll bonfire, on the balcony with the second Fire Witch.</td></tr>
<tr><td>IBV: Large Titanite Shard - central, side path after first fountain</td><td>Up the stairs from the Central Irithyll bonfire, on a railing to the right</td></tr>
<tr><td>IBV: Large Titanite Shard - great hall, main floor mob drop</td><td>One-time drop from the Silver Knight staring at the painting in Irithyll</td></tr>
<tr><td>IBV: Large Titanite Shard - great hall, upstairs mob drop #1</td><td>One-time drop from the Silver Knight on the balcony of the room with the painting</td></tr>
<tr><td>IBV: Large Titanite Shard - great hall, upstairs mob drop #2</td><td>One-time drop from the Silver Knight on the balcony of the room with the painting</td></tr>
<tr><td>IBV: Large Titanite Shard - path to Dorhys</td><td>Before the area with Cathedral Evangelist Dorhys, past an illusory railing past the Central Irithyll Fire Witches</td></tr>
<tr><td>IBV: Large Titanite Shard - plaza, balcony overlooking ascent</td><td>On the path from Central Irithyll bonfire, instead of going left toward the Church of Yorshka, going right, on the balcony</td></tr>
<tr><td>IBV: Large Titanite Shard - plaza, by stairs to church</td><td>To the left of the stairs leading up to the Church of Yorshka from Central Irithyll</td></tr>
<tr><td>IBV: Leo Ring - great hall, chest</td><td>In a chest up the stairs in the room with the Silver Knight staring at the painting</td></tr>
<tr><td>IBV: Lightning Gem - plaza center</td><td>In the area before and below Pontiff&#x27;s cathedral, in the center guarded by the enemies</td></tr>
<tr><td>IBV: Magic Clutch Ring - plaza, illusory wall</td><td>In the area before and below Pontiff&#x27;s cathedral, behind an illusory wall to the right</td></tr>
<tr><td>IBV: Mirrah Chain Gloves - bridge after killing Creighton</td><td>Following Sirris&#x27; questline, found on the bridge to Irithyll after being invaded by Creighton the Wanderer in the graveyard after the Church of Yorshka.</td></tr>
<tr><td>IBV: Mirrah Chain Leggings - bridge after killing Creighton</td><td>Following Sirris&#x27; questline, found on the bridge to Irithyll after being invaded by Creighton the Wanderer in the graveyard after the Church of Yorshka.</td></tr>
<tr><td>IBV: Mirrah Chain Mail - bridge after killing Creighton</td><td>Following Sirris&#x27; questline, found on the bridge to Irithyll after being invaded by Creighton the Wanderer in the graveyard after the Church of Yorshka.</td></tr>
<tr><td>IBV: Proof of a Concord Kept - Church of Yorshka altar</td><td>At the altar in the Church of Yorshka</td></tr>
<tr><td>IBV: Rime-blue Moss Clump - central, by bonfire</td><td>By the Central Irithyll bonfire</td></tr>
<tr><td>IBV: Rime-blue Moss Clump - central, past second fountain</td><td>From the Central Irithyll bonfire, to the left before the first Fire Witch.</td></tr>
<tr><td>IBV: Ring of Sacrifice - lake, right of stairs from descent</td><td>Near the sewer centipede at the start of the lake leading to the Distant Manor bonfire</td></tr>
<tr><td>IBV: Ring of the Evil Eye - Anri</td><td>Given by Anri of Astora in the Church of Yorshka, or if told of Horace&#x27;s whereabouts in the Catacombs</td></tr>
<tr><td>IBV: Ring of the Sun&#x27;s First Born - fall from in front of cathedral</td><td>Dropping down from in front of Pontiff Sulyvahn&#x27;s church toward the Church of Yorshka</td></tr>
<tr><td>IBV: Roster of Knights - descent, first landing</td><td>On the landing going down the stairs from Church of Yorshka to the graveyard</td></tr>
<tr><td>IBV: Rusted Gold Coin - Distant Manor, drop after stairs</td><td>Dropping down after the first set of stairs leading from Distant Manor bonfire</td></tr>
<tr><td>IBV: Rusted Gold Coin - descent, side path</td><td>Down the stairs from the graveyard after Church of Yorshka, guarded by the group of dogs in the left path</td></tr>
<tr><td>IBV: Shriving Stone - descent, dark room rafters</td><td>On the rafters in the dark area with the Irithyllian slaves</td></tr>
<tr><td>IBV: Siegbräu - Siegward</td><td>Given by Siegward meeting him in the Irithyll kitchen after the Sewer Centipedes.</td></tr>
<tr><td>IBV: Smough&#x27;s Great Hammer - great hall, chest</td><td>In a chest up the stairs in the room with the Silver Knight staring at the painting</td></tr>
<tr><td>IBV: Soul of Pontiff Sulyvahn</td><td>Dropped by Pontiff Sulyvahn</td></tr>
<tr><td>IBV: Soul of a Weary Warrior - ascent, by final staircase</td><td>Toward the end of the path from the sewer leading up to Pontiff&#x27;s cathedral, to the left of the final staircase</td></tr>
<tr><td>IBV: Soul of a Weary Warrior - central, by first fountain</td><td>By the Central Irithyll bonfire</td></tr>
<tr><td>IBV: Soul of a Weary Warrior - central, railing by first fountain</td><td>On the railing overlooking the Central Irithyll bonfire, at the very start</td></tr>
<tr><td>IBV: Soul of a Weary Warrior - plaza, side room lower</td><td>Dropping down from the path from Church of Yorshka to Pontiff, guarded by the pensive Fire Witch</td></tr>
<tr><td>IBV: Soul of a Weary Warrior - plaza, side room upper</td><td>In the path from Church of Yorshka to Pontiff&#x27;s cathedral, at the broken ledge you can drop down onto the Fire Witch</td></tr>
<tr><td>IBV: Twinkling Titanite - central, lizard before plaza</td><td>Dropped by a Crystal Lizard past the Central Irithyll Fire Witches and to the left</td></tr>
<tr><td>IBV: Twinkling Titanite - descent, lizard behind illusory wall</td><td>Dropped by a Crystal Lizard behind an illusory wall before going down the stairs to the lake leading to the Distant Manor bonfire</td></tr>
<tr><td>IBV: Undead Bone Shard - descent, behind gravestone</td><td>In the graveyard down the stairs from the Church of Yorshka, behind the grave with the Corvian</td></tr>
<tr><td>IBV: Witchtree Branch - by Dorhys</td><td>In the area with Cathedral Evangelist Dorhys, past an illusory railing past the Central Irithyll Fire Witches</td></tr>
<tr><td>IBV: Wood Grain Ring+2 - ascent, right after great hall</td><td>Leaving the building with the Silver Knight staring at the painting, instead of going left up the stairs, go right</td></tr>
<tr><td>IBV: Yorshka&#x27;s Spear - descent, dark room rafters chest</td><td>In a chest in the rafters of the dark area with the Irithyllian slaves</td></tr>
<tr><td>ID: Alva Armor - B3 near, by Karla&#x27;s cell, after killing Alva</td><td>In the main Jailer cell block on the floor close to Karla&#x27;s cell, if the invading Alva is killed</td></tr>
<tr><td>ID: Alva Gauntlets - B3 near, by Karla&#x27;s cell, after killing Alva</td><td>In the main Jailer cell block on the floor close to Karla&#x27;s cell, if the invading Alva is killed</td></tr>
<tr><td>ID: Alva Helm - B3 near, by Karla&#x27;s cell, after killing Alva</td><td>In the main Jailer cell block on the floor close to Karla&#x27;s cell, if the invading Alva is killed</td></tr>
<tr><td>ID: Alva Leggings - B3 near, by Karla&#x27;s cell, after killing Alva</td><td>In the main Jailer cell block on the floor close to Karla&#x27;s cell, if the invading Alva is killed</td></tr>
<tr><td>ID: Bellowing Dragoncrest Ring - drop from B1 towards pit</td><td>Dropping down from the Jailbreaker&#x27;s Key shortcut at the end of the top corridor on the bonfire side in Irithyll Dungeon</td></tr>
<tr><td>ID: Covetous Gold Serpent Ring - Siegward&#x27;s cell</td><td>In the Old Cell where Siegward is rescued</td></tr>
<tr><td>ID: Covetous Silver Serpent Ring+1 - pit lift, middle platform</td><td>On one of the platforms in elevator shaft of the shortcut elevator from the Giant Slave area to the Irithyll Dungeon bonfire</td></tr>
<tr><td>ID: Dark Clutch Ring - stairs between pit and B3, mimic</td><td>Dropped by the mimic found going past the Giant Slave to the sewer with the rats and the basilisks, up the first flight of stairs, on the left side</td></tr>
<tr><td>ID: Dragon Torso Stone - B3, outside lift</td><td>On the balcony corpse in the Path of the Dragon pose</td></tr>
<tr><td>ID: Dragonslayer Lightning Arrow - pit, mimic in hall</td><td>Dropped by the mimic in the side corridor from where the Giant Slave is standing, before the long ladder</td></tr>
<tr><td>ID: Dung Pie - B3, by path from pit</td><td>In the room with the Giant Hound Rats</td></tr>
<tr><td>ID: Dung Pie - pit, miniboss drop</td><td>Drop from the Giant Slave</td></tr>
<tr><td>ID: Dusk Crown Ring - B3 far, right cell</td><td>In the cell in the main Jailer cell block to the left of the Profaned Capital exit</td></tr>
<tr><td>ID: Ember - B3 center</td><td>At the center pillar in the main Jailer cell block</td></tr>
<tr><td>ID: Ember - B3 far right</td><td>In the main Jailer cell block, on the left side coming from the Profaned Capital</td></tr>
<tr><td>ID: Estus Shard - mimic on path from B2 to pit</td><td>Dropped by the mimic in the room after the outside area of Irithyll Dungeon overlooking Profaned Capital</td></tr>
<tr><td>ID: Fading Soul - B1 near, main hall</td><td>On the top corridor on the bonfire side in Irithyll Dungeon, close to the first Jailer</td></tr>
<tr><td>ID: Great Magic Shield - B2 near, mob drop in far left cell</td><td>One-time drop from the Infested Corpse in the bottom corridor on the bonfire side of Irithyll Dungeon, in the closest cell</td></tr>
<tr><td>ID: Homeward Bone - path from B2 to pit</td><td>In the part of Irithyll Dungeon overlooking the Profaned Capital, after exiting the last jail cell corridor</td></tr>
<tr><td>ID: Jailbreaker&#x27;s Key - B1 far, cell after gate</td><td>In the cell of the top corridor opposite to the bonfire in Irithyll Dungeon</td></tr>
<tr><td>ID: Large Soul of a Nameless Soldier - B2 far, by lift</td><td>Taking the elevator up from the area you can use Path of the Dragon, before the one-way door</td></tr>
<tr><td>ID: Large Soul of a Nameless Soldier - B2, hall by stairs</td><td>At the end of the bottom corridor on the bonfire side in Irithyll Dungeon</td></tr>
<tr><td>ID: Large Soul of a Weary Warrior - just before Profaned Capital</td><td>In the open area before the bridge leading into Profaned Capital from Irithyll Dungeon</td></tr>
<tr><td>ID: Large Titanite Shard - B1 far, rightmost cell</td><td>In a cell on the far end of the top corridor opposite to the bonfire in Irithyll Dungeon, nearby the Jailer</td></tr>
<tr><td>ID: Large Titanite Shard - B1 near, by door</td><td>At the end of the top corridor on the bonfire side in Irithyll Dungeon, before the Jailbreaker&#x27;s Key door</td></tr>
<tr><td>ID: Large Titanite Shard - B3 near, right corner</td><td>In the main Jailer cell block, to the left of the hallway leading to the Path of the Dragon area</td></tr>
<tr><td>ID: Large Titanite Shard - after bonfire, second cell on left</td><td>In the second cell on the right after Irithyll Dungeon bonfire</td></tr>
<tr><td>ID: Large Titanite Shard - pit #1</td><td>On the floor where the Giant Slave is standing</td></tr>
<tr><td>ID: Large Titanite Shard - pit #2</td><td>On the floor where the Giant Slave is standing</td></tr>
<tr><td>ID: Lightning Blade - B3 lift, middle platform</td><td>On the middle platform riding the elevator up from the Path of the Dragon area</td></tr>
<tr><td>ID: Lightning Bolt - awning over pit</td><td>On the wooden overhangs above the Giant Slave. Can be reached by dropping down after climbing the long ladder around the area where the Giant stands.</td></tr>
<tr><td>ID: Murakumo - Alva drop</td><td>Dropped by Alva, Seeker of the Spurned when he invades in the cliffside path to Irithyll Dungeon</td></tr>
<tr><td>ID: Old Cell Key - stairs between pit and B3</td><td>In a chest found going past the Giant Slave to the sewer with the rats and the basilisks, up the stairs to the end, on the right side</td></tr>
<tr><td>ID: Old Sorcerer Boots - B2 near, middle cell</td><td>In one of the cells on the bottom corridor on the bonfire side in Irithyll Dungeon, close to the bonfire, with many Infested Corpses</td></tr>
<tr><td>ID: Old Sorcerer Coat - B2 near, middle cell</td><td>In one of the cells on the bottom corridor on the bonfire side in Irithyll Dungeon, close to the bonfire, with many Infested Corpses</td></tr>
<tr><td>ID: Old Sorcerer Gauntlets - B2 near, middle cell</td><td>In one of the cells on the bottom corridor on the bonfire side in Irithyll Dungeon, close to the bonfire, with many Infested Corpses</td></tr>
<tr><td>ID: Old Sorcerer Hat - B2 near, middle cell</td><td>In one of the cells on the bottom corridor on the bonfire side in Irithyll Dungeon, close to the bonfire, with many Infested Corpses</td></tr>
<tr><td>ID: Pale Pine Resin - B1 far, cell with broken wall</td><td>In the jail cell with the broken wall in the top corridor opposite to the bonfire in Irithyll Dungeon, near the passive Wretch on the wall</td></tr>
<tr><td>ID: Pickaxe - path from pit to B3</td><td>Passing by the Giant Slave, before the tunnel with the rats and basilisks</td></tr>
<tr><td>ID: Prisoner Chief&#x27;s Ashes - B2 near, locked cell by stairs</td><td>In the cell at the far end of the bottom corridor on the bonfire side in Irithyll Dungeon</td></tr>
<tr><td>ID: Profaned Coal - B3 far, left cell</td><td>In the room with the Wretches next to the main Jailer cell block, guarded by a Wretch</td></tr>
<tr><td>ID: Profaned Flame - pit</td><td>On the floor where the Giant Slave is standing</td></tr>
<tr><td>ID: Rusted Coin - after bonfire, first cell on left</td><td>In the first cell on the left from the Irithyll dungeon bonfire</td></tr>
<tr><td>ID: Rusted Gold Coin - after bonfire, last cell on right</td><td>In the third cell on the right from the Irithyll Dungeon bonfire</td></tr>
<tr><td>ID: Simple Gem - B2 far, cell by stairs</td><td>In the cell near the bottom corridor opposite to the bonfire in Irithyll Dungeon, adjacent to the room with three Jailers and Cage Spiders</td></tr>
<tr><td>ID: Soul of a Crestfallen Knight - balcony above pit</td><td>Under whether the Giant Slave is resting his head</td></tr>
<tr><td>ID: Soul of a Weary Warrior - by drop to pit</td><td>At the end of the room with many peasant hollows after the Estus Shard mimic</td></tr>
<tr><td>ID: Soul of a Weary Warrior - stairs between pit and B3</td><td>Going past the Giant Slave to the sewer with the rats and the basilisks, up the first flight of stairs</td></tr>
<tr><td>ID: Titanite Chunk - balcony above pit, lizard</td><td>Dropped by the Crystal Lizard where the Giant Slave is resting his head</td></tr>
<tr><td>ID: Titanite Chunk - pit, miniboss drop</td><td>Drop from the Giant Slave</td></tr>
<tr><td>ID: Titanite Scale - B2 far, lizard</td><td>Dropped by the Crystal Lizard on the bottom corridor opposite from the bonfire in Irithyll Dungeon where a Wretch attacks you</td></tr>
<tr><td>ID: Titanite Scale - B3 far, mimic in hall</td><td>Dropped by the mimic in the main Jailer cell block</td></tr>
<tr><td>ID: Titanite Slab - Siegward</td><td>Given by Siegward after unlocking Old Cell or on quest completion</td></tr>
<tr><td>ID: Xanthous Ashes - B3 far, right cell</td><td>In the cell in the main Jailer cell block to the left of the Profaned Capital exit</td></tr>
<tr><td>KFF: Soul of the Lords</td><td>Dropped by Soul of Cinder</td></tr>
<tr><td>LC: Black Firebomb - dark room lower</td><td>In the room with the firebomb-throwing hollows, against the wall on the lowest level</td></tr>
<tr><td>LC: Braille Divine Tome of Lothric - wyvern room</td><td>In the room next to the second Pus of Man wyvern</td></tr>
<tr><td>LC: Caitha&#x27;s Chime - chapel, drop onto roof</td><td>Dropping down from the chapel balcony where the Red Tearstone Ring is found, and then dropping down again towards the Lothric knights</td></tr>
<tr><td>LC: Dark Stoneplate Ring+1 - wyvern room, balcony</td><td>Through the room next to the second Pus of Man wyvern, on the balcony outside</td></tr>
<tr><td>LC: Ember - by Dragon Barracks bonfire</td><td>Near the Dragon Barracks bonfire</td></tr>
<tr><td>LC: Ember - dark room mid, pus of man mob drop</td><td>Dropped by the first Pus of Man wyvern</td></tr>
<tr><td>LC: Ember - main hall, left of stairs</td><td>To the left of the stairs past the Dragon Barracks grate</td></tr>
<tr><td>LC: Ember - plaza center</td><td>In the area where the Pus of Man wyverns breathe fire</td></tr>
<tr><td>LC: Ember - plaza, by gate</td><td>On the railing near the area where the Pus of Man wyverns breathe fire, before the gate</td></tr>
<tr><td>LC: Ember - wyvern room, wyvern foot mob drop</td><td>Dropped by the second Pus of Man wyvern</td></tr>
<tr><td>LC: Gotthard Twinswords - by Grand Archives door, after PC and AL bosses</td><td>Before the door to the Grand Archives after Aldrich and Yhorm are killed</td></tr>
<tr><td>LC: Grand Archives Key - by Grand Archives door, after PC and AL bosses</td><td>Before the door to the Grand Archives after Aldrich and Yhorm are killed</td></tr>
<tr><td>LC: Greatlance - overlooking Dragon Barracks bonfire</td><td>Guarded by a pensive Lothric Knight after the Dragon Barracks bonfire and continuing up the stairs</td></tr>
<tr><td>LC: Hood of Prayer</td><td>In a chest right after the Lothric Castle bonfire</td></tr>
<tr><td>LC: Irithyll Rapier - basement, miniboss drop</td><td>Dropped by the Boreal Outrider Knight in the basement</td></tr>
<tr><td>LC: Knight&#x27;s Ring - altar</td><td>Climbing the ladder to the rooftop outside the Dragonslayer Armour fight, past the Large Hollow Soldier, down into the room with the tables</td></tr>
<tr><td>LC: Large Soul of a Nameless Soldier - dark room mid</td><td>In the room with the firebomb-throwing hollows, up the ladder</td></tr>
<tr><td>LC: Large Soul of a Nameless Soldier - moat, right path</td><td>Found on the ledge after dropping into the area with the Pus of Man transforming hollows and making the entire loop</td></tr>
<tr><td>LC: Large Soul of a Nameless Soldier - plaza left, by pillar</td><td>In the building to the left of the area where the Pus of Man wyverns breathe fire, against a pillar</td></tr>
<tr><td>LC: Large Soul of a Weary Warrior - ascent, last turret</td><td>Rather than going up the stairs to the Dragon Barracks bonfire, continue straight down the stairs and forwards</td></tr>
<tr><td>LC: Large Soul of a Weary Warrior - main hall, by lever</td><td>On a ledge to the right of the lever opening the grate</td></tr>
<tr><td>LC: Life Ring+2 - dark room mid, out door opposite wyvern, drop down</td><td>Past the room with the firebomb-throwing hollows and Pus of Man wyvern, around to the front, dropping down past where the Titanite Chunk is</td></tr>
<tr><td>LC: Lightning Urn - moat, right path, first room</td><td>Starting the loop from where the Pus of Man hollows transform, behind some crates in the first room</td></tr>
<tr><td>LC: Lightning Urn - plaza</td><td>In the area where the Pus of Man wyverns breathe fire</td></tr>
<tr><td>LC: Pale Pine Resin - dark room upper, by mimic</td><td>In the room with the firebomb-throwing hollows, next to the mimic in the far back left</td></tr>
<tr><td>LC: Raw Gem - plaza left</td><td>On a balcony to the left of the area where the Pus of Man wyverns breathe fire, where the Hollow Soldier throws Undead Hunter Charms</td></tr>
<tr><td>LC: Red Tearstone Ring - chapel, drop onto roof</td><td>From the chapel to the right of the Dragonslayer Armour fight, on the balcony to the left</td></tr>
<tr><td>LC: Refined Gem - plaza</td><td>In the area where the Pus of Man wyverns breathe fire</td></tr>
<tr><td>LC: Robe of Prayer - ascent, chest at beginning</td><td>In a chest right after the Lothric Castle bonfire</td></tr>
<tr><td>LC: Rusted Coin - chapel</td><td>In the chapel to the right of the Dragonslayer Armour fight</td></tr>
<tr><td>LC: Sacred Bloom Shield - ascent, behind illusory wall</td><td>Up the ladder where the Winged Knight is waiting, past an illusory wall</td></tr>
<tr><td>LC: Skirt of Prayer - ascent, chest at beginning</td><td>In a chest right after the Lothric Castle bonfire</td></tr>
<tr><td>LC: Sniper Bolt - moat, right path end</td><td>Hanging from the arch passed under on the way to the Dragon Barracks bonfire. Can be accessed by dropping into the area with the Pus of Man transforming hollows and making the entire loop, but going left at the end</td></tr>
<tr><td>LC: Sniper Crossbow - moat, right path end</td><td>Hanging from the arch passed under on the way to the Dragon Barracks bonfire. Can be accessed by dropping into the area with the Pus of Man transforming hollows and making the entire loop, but going left at the end</td></tr>
<tr><td>LC: Soul of Dragonslayer Armour</td><td>Dropped by Dragonslayer Armour</td></tr>
<tr><td>LC: Soul of a Crestfallen Knight - by lift bottom</td><td>Guarded by a buffed Lothric Knight straight from the Dancer bonfire</td></tr>
<tr><td>LC: Soul of a Crestfallen Knight - wyvern room, balcony</td><td>On a ledge accessible after the second Pus of Man wyvern is defeated</td></tr>
<tr><td>LC: Spirit Tree Crest Shield - basement, chest</td><td>In a chest in the basement with the Outrider Knight</td></tr>
<tr><td>LC: Sunlight Medal - by lift top</td><td>Next to the shortcut elevator outside of the Dragonslayer Armour fight that goes down to the start of the area</td></tr>
<tr><td>LC: Sunlight Straight Sword - wyvern room, mimic</td><td>Dropped by the mimic in the room next to the second Pus of Man wyvern</td></tr>
<tr><td>LC: Thunder Stoneplate Ring+2 - chapel, drop onto roof</td><td>Dropping down from the chapel balcony where the Red Tearstone Ring is found, out on the edge</td></tr>
<tr><td>LC: Titanite Chunk - altar roof</td><td>Climbing the ladder to the rooftop outside the Dragonslayer Armour fight, overlooking the tree</td></tr>
<tr><td>LC: Titanite Chunk - ascent, final turret</td><td>Rather than going up the stairs to the Dragon Barracks bonfire, continue straight down the stairs, then right</td></tr>
<tr><td>LC: Titanite Chunk - ascent, first balcony</td><td>Right after the Lothric Castle bonfire, out on the balcony</td></tr>
<tr><td>LC: Titanite Chunk - ascent, turret before barricades</td><td>From the Lothric Castle bonfire, up the stairs, straight, and then down the stairs behind the barricade</td></tr>
<tr><td>LC: Titanite Chunk - dark room mid, out door opposite wyvern</td><td>From the room with the firebomb-throwing hollows, past the Pus of Man Wyvern and back around the front, before the Crystal Lizard</td></tr>
<tr><td>LC: Titanite Chunk - dark room mid, pus of man mob drop</td><td>Dropped by the first Pus of Man wyvern</td></tr>
<tr><td>LC: Titanite Chunk - down stairs after boss</td><td>Down the stairs to the right after Dragonslayer Armour</td></tr>
<tr><td>LC: Titanite Chunk - moat #1</td><td>In the center of the area where the Pus of Man hollows transform</td></tr>
<tr><td>LC: Titanite Chunk - moat #2</td><td>In the center of the area where the Pus of Man hollows transform</td></tr>
<tr><td>LC: Titanite Chunk - moat, near ledge</td><td>Dropping down from the bridge where the Pus of Man wyverns breathe fire on the near side to the bonfire</td></tr>
<tr><td>LC: Titanite Chunk - wyvern room, wyvern foot mob drop</td><td>Dropped by the second Pus of Man wyvern</td></tr>
<tr><td>LC: Titanite Scale - altar</td><td>In a chest climbing the ladder to the rooftop outside the Dragonslayer Armour fight, continuing the loop past the Red-Eyed Lothric Knight</td></tr>
<tr><td>LC: Titanite Scale - basement, chest</td><td>In a chest in the basement with the Outrider Knight</td></tr>
<tr><td>LC: Titanite Scale - chapel, chest</td><td>In a chest in the chapel to the right of the Dragonslayer Armour fight</td></tr>
<tr><td>LC: Titanite Scale - dark room mid, out door opposite wyvern</td><td>Passing through the room with the firebomb-throwing hollows and the Pus of Man wyvern around to the front, overlooking the area where the wyverns breathe fire</td></tr>
<tr><td>LC: Titanite Scale - dark room, upper balcony</td><td>In the room with the firebomb-throwing hollows, at the very top on a balcony to the right</td></tr>
<tr><td>LC: Titanite Scale - dark room, upper, mimic</td><td>Dropped by the crawling mimic at the top of the room with the firebomb-throwing hollows</td></tr>
<tr><td>LC: Twinkling Titanite - ascent, side room</td><td>In the room where the Winged Knight drops down</td></tr>
<tr><td>LC: Twinkling Titanite - basement, chest #1</td><td>In a chest in the basement with the Outrider Knight</td></tr>
<tr><td>LC: Twinkling Titanite - basement, chest #2</td><td>In a chest in the basement with the Outrider Knight</td></tr>
<tr><td>LC: Twinkling Titanite - dark room mid, out door opposite wyvern, lizard</td><td>Dropped by the Crystal Lizard after the room with the firebomb-throwing hollows around the front</td></tr>
<tr><td>LC: Twinkling Titanite - moat, left side</td><td>Behind one of the Pus of Man transforming hollows, to the left of the bridge to the wyvern fire-breathing area</td></tr>
<tr><td>LC: Twinkling Titanite - moat, right path, lizard</td><td>Dropped by the Crystal Lizard near the thieves after dropping down to the area with the Pus of Man transforming hollows</td></tr>
<tr><td>LC: Undead Bone Shard - moat, far ledge</td><td>Dropping down from the bridge where the Pus of Man wyverns breathe fire on the far side from the bonfire</td></tr>
<tr><td>LC: Winged Knight Armor - ascent, behind illusory wall</td><td>In the area where the Winged Knight drops down, up the ladder and past the illusory wall</td></tr>
<tr><td>LC: Winged Knight Gauntlets - ascent, behind illusory wall</td><td>In the area where the Winged Knight drops down, up the ladder and past the illusory wall</td></tr>
<tr><td>LC: Winged Knight Helm - ascent, behind illusory wall</td><td>In the area where the Winged Knight drops down, up the ladder and past the illusory wall</td></tr>
<tr><td>LC: Winged Knight Leggings - ascent, behind illusory wall</td><td>In the area where the Winged Knight drops down, up the ladder and past the illusory wall</td></tr>
<tr><td>PC: Blooming Purple Moss Clump - walkway above swamp</td><td>At the right end of the plank before dropping down into the Profaned Capital toxic pool</td></tr>
<tr><td>PC: Cinders of a Lord - Yhorm the Giant</td><td>Dropped by Yhorm the Giant</td></tr>
<tr><td>PC: Court Sorcerer Gloves - chapel, second floor</td><td>On the second floor of the Monstrosity of Sin building in front of the Monstrosity of Sin</td></tr>
<tr><td>PC: Court Sorcerer Hood - chapel, second floor</td><td>On the second floor of the Monstrosity of Sin building in front of the Monstrosity of Sin</td></tr>
<tr><td>PC: Court Sorcerer Robe - chapel, second floor</td><td>On the second floor of the Monstrosity of Sin building in front of the Monstrosity of Sin</td></tr>
<tr><td>PC: Court Sorcerer Trousers - chapel, second floor</td><td>On the second floor of the Monstrosity of Sin building in front of the Monstrosity of Sin</td></tr>
<tr><td>PC: Court Sorcerer&#x27;s Staff - chapel, mimic on second floor</td><td>Dropped by the mimic on the second floor of the Monstrosity of Sin building</td></tr>
<tr><td>PC: Cursebite Ring - swamp, below halls</td><td>In the inner cave of the Profaned Capital toxic pool</td></tr>
<tr><td>PC: Eleonora - chapel ground floor, kill mob</td><td>Dropped by the Monstrosity of Sin on the first floor, furthest away from the door</td></tr>
<tr><td>PC: Ember - palace, far room</td><td>To the right of the Profaned Flame, in the room with the many Jailers looking at the mimics</td></tr>
<tr><td>PC: Flame Stoneplate Ring+1 - chapel, drop from roof towards entrance</td><td>Dropping down from the roof connected to the second floor of the Monstrosity of Sin building, above the main entrance to the building</td></tr>
<tr><td>PC: Greatshield of Glory - palace, mimic in far room</td><td>Dropped by the left mimic surrounded by the Jailers to the right of the Profaned Flame</td></tr>
<tr><td>PC: Jailer&#x27;s Key Ring - hall past chapel</td><td>Past the Profaned Capital Court Sorcerer, in the corridor overlooking the Irithyll Dungeon Giant Slave area</td></tr>
<tr><td>PC: Large Soul of a Weary Warrior - bridge, far end</td><td>On the way from the Profaned Capital bonfire toward the Profaned Flame, crossing the bridge without dropping down</td></tr>
<tr><td>PC: Logan&#x27;s Scroll - chapel roof, NPC drop</td><td>Dropped by the court sorcerer above the toxic pool</td></tr>
<tr><td>PC: Magic Stoneplate Ring+2 - tower base</td><td>At the base of the Profaned Capital structure, going all the way around the outside wall clockwise</td></tr>
<tr><td>PC: Onislayer Greatarrow - bridge</td><td>Item on the bridge descending from the Profaned Capital bonfire into the Profaned Flame building</td></tr>
<tr><td>PC: Onislayer Greatbow - drop from bridge</td><td>From the bridge leading from the Profaned Capital bonfire to Yhorm, onto the ruined pillars shortcut to the right, behind you after the first dropdown.</td></tr>
<tr><td>PC: Pierce Shield - Siegward</td><td>Dropped by Siegward upon death or quest completion, and sold by Patches while Siegward is in the well.</td></tr>
<tr><td>PC: Poison Arrow - chapel roof</td><td>At the far end of the roof with the Court Sorcerer</td></tr>
<tr><td>PC: Poison Gem - swamp, below halls</td><td>In the inner cave of the Profaned Capital toxic pool</td></tr>
<tr><td>PC: Purging Stone - chapel ground floor</td><td>At the back of the room with the three Monstrosities of Sin on the first floor</td></tr>
<tr><td>PC: Purging Stone - swamp, by chapel ladder</td><td>In the middle of the Profaned Capital toxic pool, near the ladder to the Court Sorcerer</td></tr>
<tr><td>PC: Rubbish - chapel, down stairs from second floor</td><td>Hanging corpse visible from Profaned Capital accessible from the second floor of the building with the Monstrosities of Sin, in the back right</td></tr>
<tr><td>PC: Rusted Coin - below bridge #1</td><td>Among the rubble before the steps leading up to the Profaned Flame</td></tr>
<tr><td>PC: Rusted Coin - below bridge #2</td><td>Among the rubble before the steps leading up to the Profaned Flame</td></tr>
<tr><td>PC: Rusted Coin - tower exterior</td><td>Treasure visible on a ledge in the Profaned Capital bonfire. Can be accessed by climbing a ladder outside the main structure.</td></tr>
<tr><td>PC: Rusted Gold Coin - halls above swamp</td><td>In the corridors leading to the Profaned Capital toxic pool</td></tr>
<tr><td>PC: Rusted Gold Coin - palace, mimic in far room</td><td>Dropped by the right mimic surrounded by the Jailers to the right of the Profaned Flame</td></tr>
<tr><td>PC: Shriving Stone - swamp, by chapel door</td><td>At the far end of the Profaned Capital toxic pool, to the left of the door leading to the Monstrosities of Sin</td></tr>
<tr><td>PC: Siegbräu - Siegward after killing boss</td><td>Given by Siegward after helping him defeat Yhorm the Giant. You must talk to him before Emma teleports you.</td></tr>
<tr><td>PC: Soul of Yhorm the Giant</td><td>Dropped by Yhorm the Giant</td></tr>
<tr><td>PC: Storm Ruler - Siegward</td><td>Dropped by Siegward upon death or quest completion.</td></tr>
<tr><td>PC: Storm Ruler - boss room</td><td>To the right of Yhorm&#x27;s throne</td></tr>
<tr><td>PC: Twinkling Titanite - halls above swamp, lizard #1</td><td>Dropped by the second Crystal Lizard in the corridors before the Profaned Capital toxic pool</td></tr>
<tr><td>PC: Twinkling Titanite - halls above swamp, lizard #2</td><td>Dropped by the first Crystal Lizard in the corridors before the Profaned Capital toxic pool</td></tr>
<tr><td>PC: Undead Bone Shard - by bonfire</td><td>On the corpse of Laddersmith Gilligan next to the Profaned Capital bonfire</td></tr>
<tr><td>PC: Wrath of the Gods - chapel, drop from roof</td><td>Dropping down from the roof of the Monstrosity of Sin building where the Court Sorcerer is</td></tr>
<tr><td>PW1: Black Firebomb - snowfield lower, path to bonfire</td><td>Dropping down after the first snow overhang and following the wall on the left, past the rotting bed descending toward the second bonfire</td></tr>
<tr><td>PW1: Blessed Gem - snowfield, behind tower</td><td>Behind the Millwood Knight tower in the first area, approach from the right side</td></tr>
<tr><td>PW1: Budding Green Blossom - settlement courtyard, ledge</td><td>After sliding down the slope on the way to Corvian Settlement, dropping down hugging the left wall</td></tr>
<tr><td>PW1: Captain&#x27;s Ashes - snowfield tower, 6F</td><td>At the very top of the Millwood Knight tower after climbing up the second ladder</td></tr>
<tr><td>PW1: Chillbite Ring - Friede</td><td>Given by Sister Friede while she is sitting in the Ariandel Chapel, or on the stool after she moves.</td></tr>
<tr><td>PW1: Contraption Key - library, NPC drop</td><td>Dropped by Sir Vilhelm</td></tr>
<tr><td>PW1: Crow Quills - settlement loop, jump into courtyard</td><td>Crossing the bridge after Corvian Settlement bonfire, follow the left edge past another bridge until a dropdown point looping back to the bonfire. Go right and jump past some barrels onto the central platform.</td></tr>
<tr><td>PW1: Crow Talons - settlement roofs, near bonfire</td><td>After climbing the ladder onto Corvian Settlement rooftops, dropping down on a bridge to the left, into the building, then looping around onto its roof.</td></tr>
<tr><td>PW1: Dark Gem - settlement back, egg building</td><td>Dropping down to the right of the gate guarded by a Corvian Knight in Corvian Settlement, inside of the last building on the right</td></tr>
<tr><td>PW1: Ember - roots above depths</td><td>In the tree branch area after climbing down the rope bridge, hugging a right wall past a Follower Javelin wielder</td></tr>
<tr><td>PW1: Ember - settlement main, left building after bridge</td><td>Crossing the bridge after Corvian Settlement bonfire, in the building to the left.</td></tr>
<tr><td>PW1: Ember - settlement, building near bonfire</td><td>In the first building in Corvian Settlement next to the bonfire building</td></tr>
<tr><td>PW1: Ethereal Oak Shield - snowfield tower, 3F</td><td>In the Millwood Knight tower on a Millwood Knight corpse, after climbing the first ladder, then going down the staircase</td></tr>
<tr><td>PW1: Follower Javelin - snowfield lower, path back up</td><td>Dropping down after the first snow overhang, follow the right wall around and up a slope, past the Followers</td></tr>
<tr><td>PW1: Follower Sabre - roots above depths</td><td>On a tree branch after climbing down the rope bridge. Rather than hugging a right wall toward a Follower Javelin wielder, drop off to the left.</td></tr>
<tr><td>PW1: Frozen Weapon - snowfield lower, egg zone</td><td>Dropping down after the first snow overhang, in the rotting bed along the left side</td></tr>
<tr><td>PW1: Heavy Gem - snowfield village</td><td>Before the Millwood Knight tower, on the far side of one of the ruined walls targeted by the archer</td></tr>
<tr><td>PW1: Hollow Gem - beside chapel</td><td>To the right of the entrance to the Ariandel</td></tr>
<tr><td>PW1: Homeward Bone - depths, up hill</td><td>In the Depths of the Painting, up a hill next to the giant crabs.</td></tr>
<tr><td>PW1: Homeward Bone - snowfield village, outcropping</td><td>Dropping down after the first snow overhang and following the cliff on the right, making a sharp right after a ruined wall segment before approaching the Millwood Knight tower</td></tr>
<tr><td>PW1: Large Soul of a Weary Warrior - settlement hall roof</td><td>On top of the chapel with the Corvian Knight to the left of Vilhelm&#x27;s building</td></tr>
<tr><td>PW1: Large Soul of a Weary Warrior - snowfield tower, 6F</td><td>At the very top of the Millwood Knight tower after climbing up the second ladder, on a Millwood Knight corpse</td></tr>
<tr><td>PW1: Large Soul of an Unknown Traveler - below snowfield village overhang</td><td>Up the slope to the left of the Millwood Knight tower, dropping down after a snow overhang, then several more ledges.</td></tr>
<tr><td>PW1: Large Soul of an Unknown Traveler - settlement back</td><td>In Corvian Settlement, on the ground before the ladder climbing onto the rooftops</td></tr>
<tr><td>PW1: Large Soul of an Unknown Traveler - settlement courtyard, cliff</td><td>After sliding down the slope on the way to Corvian Settlement, on a cliff to the right and behind</td></tr>
<tr><td>PW1: Large Soul of an Unknown Traveler - settlement loop, by bonfire</td><td>Crossing the bridge after Corvian Settlement bonfire, follow the left edge past another bridge until a dropdown point looping back to the bonfire. On the corpse in a hole in the wall leading back to the bonfire.</td></tr>
<tr><td>PW1: Large Soul of an Unknown Traveler - settlement roofs, balcony</td><td>After climbing the ladder onto Corvian Settlement rooftops, dropping down on a bridge to the left, on the other side of the bridge.</td></tr>
<tr><td>PW1: Large Soul of an Unknown Traveler - settlement, by ladder to bonfire</td><td>To the right of the ladder leading up to Corvian Settlement bonfire.</td></tr>
<tr><td>PW1: Large Soul of an Unknown Traveler - snowfield lower, by cliff</td><td>Dropping down after the first snow overhang, between the forest and the cliff edge, before where the large wolf drops down</td></tr>
<tr><td>PW1: Large Soul of an Unknown Traveler - snowfield lower, path back up</td><td>Dropping down after the first snow overhang, follow the right wall around and up a slope, past the Followers</td></tr>
<tr><td>PW1: Large Soul of an Unknown Traveler - snowfield lower, path to village</td><td>Dropping down after the first snow overhang and following the cliff on the right, on a tree past where the large wolf jumps down</td></tr>
<tr><td>PW1: Large Soul of an Unknown Traveler - snowfield upper</td><td>Going straight after the first bonfire, to the left of the caving snow overhand</td></tr>
<tr><td>PW1: Large Titanite Shard - lizard under bridge near</td><td>Dropped by a Crystal Lizard after the Rope Bridge Cave on the way to Corvian Settlement</td></tr>
<tr><td>PW1: Large Titanite Shard - settlement loop, lizard</td><td>Crossing the bridge after Corvian Settlement bonfire, follow the left edge past another bridge until a dropdown point looping back to the bonfire. Hug the bonfire building&#x27;s outer wall along the right side.</td></tr>
<tr><td>PW1: Large Titanite Shard - snowfield lower, left from fall</td><td>Dropping down after the first snow overhang, guarded by a Tree Woman overlooking the rotting bed along the left wall</td></tr>
<tr><td>PW1: Millwood Battle Axe - snowfield tower, 5F</td><td>In the Milkwood Knight tower, either dropping down from rafters after climbing the second ladder or making a risky jump</td></tr>
<tr><td>PW1: Millwood Greatarrow - snowfield village, loop back to lower</td><td>Dropping down after the first snow overhang and following the cliff on the right, making the full loop around, up the slope leading towards where the large wolf drops down</td></tr>
<tr><td>PW1: Millwood Greatbow - snowfield village, loop back to lower</td><td>Dropping down after the first snow overhang and following the cliff on the right, making the full loop around, up the slope leading towards where the large wolf drops down</td></tr>
<tr><td>PW1: Onyx Blade - library, NPC drop</td><td>Dropped by Sir Vilhelm</td></tr>
<tr><td>PW1: Poison Gem - snowfield upper, forward from bonfire</td><td>Following the left wall from the start, guarded by a Giant Fly</td></tr>
<tr><td>PW1: Rime-blue Moss Clump - below bridge far</td><td>In a small alcove to the right after climbing down the rope bridge</td></tr>
<tr><td>PW1: Rime-blue Moss Clump - snowfield upper, overhang</td><td>On the first snow overhang at the start. It drops down at the same time you do.</td></tr>
<tr><td>PW1: Rime-blue Moss Clump - snowfield upper, starting cave</td><td>In the starting cave</td></tr>
<tr><td>PW1: Rusted Coin - right of library</td><td>To the right of Vilhelm&#x27;s building</td></tr>
<tr><td>PW1: Rusted Coin - snowfield lower, straight from fall</td><td>Dropping down after the first snow overhang, shortly straight ahead</td></tr>
<tr><td>PW1: Rusted Gold Coin - settlement roofs, roof near second ladder</td><td>After climbing the second ladder on the Corvian Settlement rooftops, immediately dropping off the bridge to the right, on a rooftop</td></tr>
<tr><td>PW1: Shriving Stone - below bridge near</td><td>After the Rope Bridge Cave bonfire, dropping down before the bridge, following the ledge all the way to the right</td></tr>
<tr><td>PW1: Simple Gem - settlement, lowest level, behind gate</td><td>Crossing the bridge after Corvian Settlement bonfire, follow the left edge until a bridge, then drop down on the right side. Guarded by a Sewer Centipede.</td></tr>
<tr><td>PW1: Slave Knight Armor - settlement roofs, drop by ladder</td><td>In Corvian Settlement, rather than climbing up a ladder leading to a bridge to the roof of the chapel with the Corvian Knight, dropping down a hole to the left of the ladder into the building below.</td></tr>
<tr><td>PW1: Slave Knight Gauntlets - settlement roofs, drop by ladder</td><td>In Corvian Settlement, rather than climbing up a ladder leading to a bridge to the roof of the chapel with the Corvian Knight, dropping down a hole to the left of the ladder into the building below.</td></tr>
<tr><td>PW1: Slave Knight Hood - settlement roofs, drop by ladder</td><td>In Corvian Settlement, rather than climbing up a ladder leading to a bridge to the roof of the chapel with the Corvian Knight, dropping down a hole to the left of the ladder into the building below.</td></tr>
<tr><td>PW1: Slave Knight Leggings - settlement roofs, drop by ladder</td><td>In Corvian Settlement, rather than climbing up a ladder leading to a bridge to the roof of the chapel with the Corvian Knight, dropping down a hole to the left of the ladder into the building below.</td></tr>
<tr><td>PW1: Snap Freeze - depths, far end, mob drop</td><td>In the Depths of the Painting, past the giant crabs, guarded by a special Tree Woman. Killing her drops down a very long nearby ladder.</td></tr>
<tr><td>PW1: Soul of a Crestfallen Knight - settlement hall, rafters</td><td>In the rafters of the chapel with the Corvian Knight to the left of Vilhelm&#x27;s building. Can drop down from the windows exposed to the roof.</td></tr>
<tr><td>PW1: Soul of a Weary Warrior - snowfield tower, 1F</td><td>At the bottom of the Millwood Knight tower on a Millwood Knight corpse</td></tr>
<tr><td>PW1: Titanite Slab - Corvian</td><td>Given by the Corvian NPC in the building next to Corvian Settlement bonfire.</td></tr>
<tr><td>PW1: Titanite Slab - depths, up secret ladder</td><td>In the Depths of the Painting, past the giant crabs, killing a special Tree Woman drops down a very long nearby ladder. Climb the ladder and also the ladder after that one.</td></tr>
<tr><td>PW1: Twinkling Titanite - roots, lizard</td><td>Dropped by a Crystal Lizard in the tree branch area after climbing down the rope bridge, before the ledge with the Follower Javelin wielder</td></tr>
<tr><td>PW1: Twinkling Titanite - settlement roofs, lizard before hall</td><td>Dropped by a Crystal Lizard on a bridge in Corvian Settlement before the rooftop of the chapel with the Corvian Knight inside.</td></tr>
<tr><td>PW1: Twinkling Titanite - snowfield tower, 3F lizard</td><td>Dropped by a Crystal Lizard in the Millwood Knight tower, climbing up the first ladder and descending the stairs down</td></tr>
<tr><td>PW1: Valorheart - boss drop</td><td>Dropped by Champion&#x27;s Gravetender</td></tr>
<tr><td>PW1: Way of White Corona - settlement hall, by altar</td><td>In the chapel with the Corvian Knight to the left of Vilhelm&#x27;s building, in front of the altar.</td></tr>
<tr><td>PW1: Young White Branch - right of library</td><td>To the right of Vilhelm&#x27;s building</td></tr>
<tr><td>PW2: Blood Gem - B2, center</td><td>On the lower level of the Ariandel Chapel basement, in the middle</td></tr>
<tr><td>PW2: Dung Pie - B1</td><td>On the higher level of the Ariandel Chapel basement, on a wooden beam overlooking the lower level</td></tr>
<tr><td>PW2: Earth Seeker - pit cave</td><td>In the area after Snowy Mountain Pass with the giant tree and Earth Seeker Millwood Knight, in the cave</td></tr>
<tr><td>PW2: Ember - pass, central alcove</td><td>After the Snowy Mountain Pass bonfire, going left of the bell stuck in the ground, in a small alcove along the left wall</td></tr>
<tr><td>PW2: Floating Chaos - NPC drop</td><td>Dropped by Livid Pyromancer Dunnel when he invades while embered, whether boss is defeated or not. On the second level of Priscilla&#x27;s building above the Gravetender fight, accessed from the lowest level of the Ariandel Chapel basement, past an illusory wall nearly straight left of the mechanism that moves the statue, then carefully dropping down tree branches.</td></tr>
<tr><td>PW2: Follower Shield - pass, far cliffside</td><td>After the Snowy Mountain Pass bonfire, going left of the bell stuck in the ground, on the cliff ledge past the open area, to the left</td></tr>
<tr><td>PW2: Follower Torch - pass, far side path</td><td>On the way to the Ariandel Chapel basement, where the first wolf enemies reappear, going all the way down the slope on the edge of the map. Guarded by a Follower</td></tr>
<tr><td>PW2: Homeward Bone - rotunda</td><td>On the second level of Priscilla&#x27;s building above the Gravetender fight. Can be accessed from the lowest level of the Ariandel Chapel basement, past an illusory wall nearly straight left of the mechanism that moves the statue, then carefully dropping down tree branches.</td></tr>
<tr><td>PW2: Large Soul of a Crestfallen Knight - pit, by tree</td><td>In the area after Snowy Mountain Pass with the giant tree and Earth Seeker Millwood Knight, by the tree</td></tr>
<tr><td>PW2: Large Titanite Shard - pass, far side path</td><td>On the way to the Ariandel Chapel basement, where the first wolf enemies reappear, going partway down the slope on the edge of the map</td></tr>
<tr><td>PW2: Large Titanite Shard - pass, just before B1</td><td>On the way to Ariandel Chapel basement, past the Millwood Knights and before the first rotten tree that can be knocked down</td></tr>
<tr><td>PW2: Prism Stone - pass, tree by beginning</td><td>Up the slope and to the left after the Snowy Mountain Pass, straight ahead by a tree</td></tr>
<tr><td>PW2: Pyromancer&#x27;s Parting Flame - rotunda</td><td>On the second level of Priscilla&#x27;s building above the Gravetender fight. Can be accessed from the lowest level of the Ariandel Chapel basement, past an illusory wall nearly straight left of the mechanism that moves the statue, then carefully dropping down tree branches.</td></tr>
<tr><td>PW2: Quakestone Hammer - pass, side path near B1</td><td>On the way to Ariandel Chapel basement, rather than going right past the two Millwood Knights, go left, guarded by a very strong Millwood Knight</td></tr>
<tr><td>PW2: Soul of Sister Friede</td><td>Dropped by Sister Friede</td></tr>
<tr><td>PW2: Soul of a Crestfallen Knight - pit edge #1</td><td>In the area after Snowy Mountain Pass with the giant tree and Earth Seeker Millwood Knight, along the edge</td></tr>
<tr><td>PW2: Soul of a Crestfallen Knight - pit edge #2</td><td>In the area after Snowy Mountain Pass with the giant tree and Earth Seeker Millwood Knight, along the edge</td></tr>
<tr><td>PW2: Titanite Chunk - pass, by kickable tree</td><td>After the Snowy Mountain Pass bonfire, on a ledge to the right of the slope with the bell stuck in the ground, behind a tree</td></tr>
<tr><td>PW2: Titanite Chunk - pass, cliff overlooking bonfire</td><td>On a cliff overlooking the Snowy Mountain Pass bonfire. Requires following the left wall</td></tr>
<tr><td>PW2: Titanite Slab - boss drop</td><td>One-time drop after killing Father Ariandel and Friede (phase 2) for the first time.</td></tr>
<tr><td>PW2: Twinkling Titanite - B3, lizard #1</td><td>Dropped by a Crystal Lizard past an illusory wall nearly straight left of the mechanism that moves the statue in the lowest level of the Ariandel Chapel basement</td></tr>
<tr><td>PW2: Twinkling Titanite - B3, lizard #2</td><td>Dropped by a Crystal Lizard past an illusory wall nearly straight left of the mechanism that moves the statue in the lowest level of the Ariandel Chapel basement</td></tr>
<tr><td>PW2: Vilhelm&#x27;s Armor - B2, along wall</td><td>On the lower level of the Ariandel Chapel basement, along a wall to the left of the contraption that turns the statue</td></tr>
<tr><td>PW2: Vilhelm&#x27;s Gauntlets - B2, along wall</td><td>On the lower level of the Ariandel Chapel basement, along a wall to the left of the contraption that turns the statue</td></tr>
<tr><td>PW2: Vilhelm&#x27;s Helm</td><td>On the lower level of the Ariandel Chapel basement, along a wall to the left of the contraption that turns the statue</td></tr>
<tr><td>PW2: Vilhelm&#x27;s Leggings - B2, along wall</td><td>On the lower level of the Ariandel Chapel basement, along a wall to the left of the contraption that turns the statue</td></tr>
<tr><td>RC: Antiquated Plain Garb - wall hidden, before boss</td><td>In the chapel before the Midir fight in the Ringed Inner Wall building.</td></tr>
<tr><td>RC: Black Witch Garb - streets garden</td><td>Guarded by Alva (invades whether embered or not), partway down the stairs from Shira, across the bridge, and past the Ringed Knight.</td></tr>
<tr><td>RC: Black Witch Hat - streets garden</td><td>Guarded by Alva (invades whether embered or not), partway down the stairs from Shira, across the bridge, and past the Ringed Knight.</td></tr>
<tr><td>RC: Black Witch Trousers - streets garden</td><td>Guarded by Alva (invades whether embered or not), partway down the stairs from Shira, across the bridge, and past the Ringed Knight.</td></tr>
<tr><td>RC: Black Witch Veil - swamp near right, by sunken church</td><td>To the left of the submerged building with 4 Ringed Knights, near a spear-wielding knight.</td></tr>
<tr><td>RC: Black Witch Wrappings - streets garden</td><td>Guarded by Alva (invades whether embered or not), partway down the stairs from Shira, across the bridge, and past the Ringed Knight.</td></tr>
<tr><td>RC: Blessed Gem - grave, down lowest stairs</td><td>In Shared Grave, after dropping down near Gael&#x27;s flag and dropping down again, behind you. Or from the bonfire, go back through the side tunnel with the skeletons and down the stairs after that.</td></tr>
<tr><td>RC: Blindfold Mask - grave, NPC drop</td><td>Dropped by Moaning Knight (invades whether embered or not, or boss defeated or not) in Shared Grave.</td></tr>
<tr><td>RC: Blood of the Dark Soul - end boss drop</td><td>Dropped by Slave Knight Gael</td></tr>
<tr><td>RC: Budding Green Blossom - church path</td><td>On the way to the Halflight building.</td></tr>
<tr><td>RC: Budding Green Blossom - wall top, flowers by stairs</td><td>In a patch of flowers to the right of the stairs leading up to the first Judicator along the left wall of the courtyard are Mausoleum Lookout.</td></tr>
<tr><td>RC: Budding Green Blossom - wall top, in flower cluster</td><td>Along the left wall of the courtyard after Mausoleum Lookout, in a patch of flowers.</td></tr>
<tr><td>RC: Chloranthy Ring+3 - wall hidden, drop onto statue</td><td>From the mid level of the Ringed Inner Wall elevator that leads to the Midir fight, dropping back down toward the way to Filianore, onto a platform with a Gwyn statue. Try to land on the platform rather than the statue.</td></tr>
<tr><td>RC: Church Guardian Shiv - swamp far left, in building</td><td>Inside of the building at the remote end of the muck pit surrounded by praying Hollow Clerics.</td></tr>
<tr><td>RC: Covetous Gold Serpent Ring+3 - streets, by Lapp</td><td>Going up the very long ladder from the muck pit, then up some stairs, to the left, and across the bridge, in a building past the Ringed Knights. Also where Lapp can be found to tell him of the Purging Monument.</td></tr>
<tr><td>RC: Crucifix of the Mad King - ashes, NPC drop</td><td>Dropped by Shira, who invades you (ember not required) in the far-future version of her room</td></tr>
<tr><td>RC: Dark Gem - swamp near, by stairs</td><td>In the middle of the muck pit, close to the long stairs.</td></tr>
<tr><td>RC: Divine Blessing - streets monument, mob drop</td><td>Dropped by the Judicator near the Purging Monument area. Requires solving &quot;Show Your Humanity&quot; puzzle.</td></tr>
<tr><td>RC: Divine Blessing - wall top, mob drop</td><td>Dropped by the Judicator after the Mausoleum Lookup bonfire.</td></tr>
<tr><td>RC: Dragonhead Greatshield - lower cliff, under bridge</td><td>Down a slope to the right of the bridge where Midir first assaults you, past a sword-wielding Ringed Knight, under the bridge.</td></tr>
<tr><td>RC: Dragonhead Shield - streets monument, across bridge</td><td>Found in Purging Monument area, across the bridge from the monument. Requires solving &quot;Show Your Humanity&quot; puzzle.</td></tr>
<tr><td>RC: Ember - wall hidden, statue room</td><td>From the mid level of the Ringed Inner Wall elevator that leads to the Midir fight, in the room with the illusory statue.</td></tr>
<tr><td>RC: Ember - wall top, by statue</td><td>Along the left wall of the courtyard after Mausoleum Lookout, in front of a tall monument.</td></tr>
<tr><td>RC: Ember - wall upper, balcony</td><td>On the balcony attached to the room with the Ringed Inner Wall bonfire.</td></tr>
<tr><td>RC: Filianore&#x27;s Spear Ornament - mid boss drop</td><td>Dropped by Halflight, Spear of the Church</td></tr>
<tr><td>RC: Filianore&#x27;s Spear Ornament - wall hidden, by ladder</td><td>Next the ladder leading down to the chapel before the Midir fight in the Ringed Inner Wall building.</td></tr>
<tr><td>RC: Havel&#x27;s Ring+3 - streets high, drop from building opposite</td><td>Dropping down from the building where Silver Knight Ledo invades. The building is up the very long ladder from the muck pit, down the path all the way to the right.</td></tr>
<tr><td>RC: Hidden Blessing - swamp center, mob drop</td><td>Dropped by Judicator patrolling the muck pit.</td></tr>
<tr><td>RC: Hidden Blessing - wall top, tomb under platform</td><td>In a tomb underneath the platform with the first Judicator, accessed by approaching from Mausoleum Lookout bonfire.</td></tr>
<tr><td>RC: Hollow Gem - wall upper, path to tower</td><td>Heading down the cursed stairs after Ringed Inner Wall bonfire and another short flight of stairs, hanging on a balcony.</td></tr>
<tr><td>RC: Iron Dragonslayer Armor - swamp far, miniboss drop</td><td>Dropped by Dragonslayer Armour at the far end of the muck pit.</td></tr>
<tr><td>RC: Iron Dragonslayer Gauntlets - swamp far, miniboss drop</td><td>Dropped by Dragonslayer Armour at the far end of the muck pit.</td></tr>
<tr><td>RC: Iron Dragonslayer Helm - swamp far, miniboss drop</td><td>Dropped by Dragonslayer Armour at the far end of the muck pit.</td></tr>
<tr><td>RC: Iron Dragonslayer Leggings - swamp far, miniboss drop</td><td>Dropped by Dragonslayer Armour at the far end of the muck pit.</td></tr>
<tr><td>RC: Lapp&#x27;s Armor - Lapp</td><td>Left at Lapp&#x27;s final location in Shared Grave after his quest is complete, or sold by Shrine Handmaid upon killing Lapp.</td></tr>
<tr><td>RC: Lapp&#x27;s Gauntlets - Lapp</td><td>Left at Lapp&#x27;s final location in Shared Grave after his quest is complete, or sold by Shrine Handmaid upon killing Lapp.</td></tr>
<tr><td>RC: Lapp&#x27;s Helm - Lapp</td><td>Left at Lapp&#x27;s final location in Shared Grave after his quest is complete, or sold by Shrine Handmaid upon killing Lapp.</td></tr>
<tr><td>RC: Lapp&#x27;s Leggings - Lapp</td><td>Left at Lapp&#x27;s final location in Shared Grave after his quest is complete, or sold by Shrine Handmaid upon killing Lapp.</td></tr>
<tr><td>RC: Large Soul of a Crestfallen Knight - streets monument, across bridge</td><td>Found in Purging Monument area, on the other side of the bridge leading to the monument. Requires solving &quot;Show Your Humanity&quot; puzzle.</td></tr>
<tr><td>RC: Large Soul of a Crestfallen Knight - streets, far stairs</td><td>Toward the bottom of the stairs leading down to the muck pit.</td></tr>
<tr><td>RC: Large Soul of a Weary Warrior - lower cliff, end</td><td>Toward the end of the upper path attacked Midir&#x27;s fire-breathing.</td></tr>
<tr><td>RC: Large Soul of a Weary Warrior - swamp center, by peninsula</td><td>In the muck pit approaching where the Judicator patrols from the stairs.</td></tr>
<tr><td>RC: Large Soul of a Weary Warrior - wall lower, past two illusory walls</td><td>In the Ringed Inner Wall building coming from Shared Grave, past two illusory walls on the right side of the ascending stairs.</td></tr>
<tr><td>RC: Large Soul of a Weary Warrior - wall top, right of small tomb</td><td>In the open toward the end of the courtyard after the Mausoleum Lookout bonfire, on the right side of the small tomb.</td></tr>
<tr><td>RC: Ledo&#x27;s Great Hammer - streets high, opposite building, NPC drop</td><td>Dropped by Silver Knight Ledo (invades whether embered or not, or boss defeated or not) in the building down the path to the right after climbing the very long ladder from the muck area.</td></tr>
<tr><td>RC: Lightning Arrow - wall lower, past three illusory walls</td><td>In the Ringed Inner Wall building coming from Shared Grave, past three illusory walls on the right side of the ascending stairs.</td></tr>
<tr><td>RC: Lightning Gem - grave, room after first drop</td><td>In Shared Grave, in the first room encountered after falling down from the crumbling stairs and continuing upward.</td></tr>
<tr><td>RC: Mossfruit - streets near left, path to garden</td><td>Partway down the stairs from Shira, across the bridge.</td></tr>
<tr><td>RC: Mossfruit - streets, far left alcove</td><td>Near the bottom of the stairs before the muck pit, in an alcove to the left.</td></tr>
<tr><td>RC: Preacher&#x27;s Right Arm - swamp near right, by tower</td><td>In the muck pit behind a crystal-covered structure, close to the Ringed City Streets shortcut entrance.</td></tr>
<tr><td>RC: Prism Stone - swamp near, railing by bonfire</td><td>On the balcony of the path leading up to Ringed City Streets bonfire from the muck pit.</td></tr>
<tr><td>RC: Purging Stone - wall top, by door to upper</td><td>At the end of the path from Mausoleum Lookup to Ringed Inner Wall, just outside the door.</td></tr>
<tr><td>RC: Ring of the Evil Eye+3 - grave, mimic</td><td>Dropped by mimic in Shared Grave. In one of the rooms after dropping down near Gael&#x27;s flag and then dropping down again.</td></tr>
<tr><td>RC: Ringed Knight Paired Greatswords - church path, mob drop</td><td>Dropped by Ringed Knight with paired greatswords before Filianore building.</td></tr>
<tr><td>RC: Ringed Knight Spear - streets, down far right hall</td><td>In a courtyard guarded by a spear-wielding Ringed Knight. Can be accessed from a hallway filled with cursed clerics on the right side going down the long stairs, or by climbing up the long ladder from the muck pit and dropping down past the Locust Preacher.</td></tr>
<tr><td>RC: Ringed Knight Straight Sword - swamp near, tower on peninsula</td><td>On a monument next to the Ringed City Streets building. Can be easily accessed after unlocking the shortcut by following the left wall inside and then outside the building.</td></tr>
<tr><td>RC: Ritual Spear Fragment - church path</td><td>To the right of the Paired Greatswords Ringed Knight on the way to Halflight.</td></tr>
<tr><td>RC: Rubbish - lower cliff, middle</td><td>In the middle of the upper path attacked Midir&#x27;s fire-breathing, after the first alcove.</td></tr>
<tr><td>RC: Rubbish - swamp far, by crystal</td><td>In the remote end of the muck pit, next to a massive crystal structure between a giant tree and the building with praying Hollow Clerics, guarded by several Locust Preachers.</td></tr>
<tr><td>RC: Ruin Armor - wall top, under stairs to bonfire</td><td>Underneath the stairs leading down from Mausoleum Lookout.</td></tr>
<tr><td>RC: Ruin Gauntlets - wall top, under stairs to bonfire</td><td>Underneath the stairs leading down from Mausoleum Lookout.</td></tr>
<tr><td>RC: Ruin Helm - wall top, under stairs to bonfire</td><td>Underneath the stairs leading down from Mausoleum Lookout.</td></tr>
<tr><td>RC: Ruin Leggings - wall top, under stairs to bonfire</td><td>Underneath the stairs leading down from Mausoleum Lookout.</td></tr>
<tr><td>RC: Sacred Chime of Filianore - ashes, NPC drop</td><td>Given by Shira after accepting her request to kill Midir, or dropped by her in post-Filianore Ringed City.</td></tr>
<tr><td>RC: Shira&#x27;s Armor - Shira&#x27;s room after killing ashes NPC</td><td>Found in Shira&#x27;s room in Ringed City after killing her in post-Filianore Ringed City.</td></tr>
<tr><td>RC: Shira&#x27;s Crown - Shira&#x27;s room after killing ashes NPC</td><td>Found in Shira&#x27;s room in Ringed City after killing her in post-Filianore Ringed City.</td></tr>
<tr><td>RC: Shira&#x27;s Gloves - Shira&#x27;s room after killing ashes NPC</td><td>Found in Shira&#x27;s room in Ringed City after killing her in post-Filianore Ringed City.</td></tr>
<tr><td>RC: Shira&#x27;s Trousers - Shira&#x27;s room after killing ashes NPC</td><td>Found in Shira&#x27;s room in Ringed City after killing her in post-Filianore Ringed City.</td></tr>
<tr><td>RC: Shriving Stone - wall tower, bottom floor center</td><td>In the cylindrical building before the long stairs with many Harald Legion Knights, in the center structure on the first floor.</td></tr>
<tr><td>RC: Siegbräu - Lapp</td><td>Given by Lapp within the Ringed Inner Wall.</td></tr>
<tr><td>RC: Simple Gem - grave, up stairs after first drop</td><td>In Shared Grave, following the path after falling down from the crumbling stairs and continuing upward.</td></tr>
<tr><td>RC: Soul of Darkeater Midir</td><td>Dropped by Darkeater Midir</td></tr>
<tr><td>RC: Soul of Slave Knight Gael</td><td>Dropped by Slave Knight Gael</td></tr>
<tr><td>RC: Soul of a Crestfallen Knight - swamp far, behind crystal</td><td>Behind a crystal structure at the far end of the muck pit, close to the building with the praying Hollow Clerics before Dragonslayer Armour.</td></tr>
<tr><td>RC: Soul of a Crestfallen Knight - swamp near left, nook</td><td>In the muck pit behind all of the Hollow Clerics near the very long ladder.</td></tr>
<tr><td>RC: Soul of a Crestfallen Knight - wall top, under drop</td><td>After dropping down onto the side path on the right side of the Mausoleum Lookout courtyard to where the Crystal Lizard is, behind you.</td></tr>
<tr><td>RC: Soul of a Weary Warrior - lower cliff, by first alcove</td><td>In front of the first alcove providing shelter from Midir&#x27;s fire-breathing on the way to Shared Grave.</td></tr>
<tr><td>RC: Soul of a Weary Warrior - swamp center</td><td>In the middle of the muck pit where the Judicator is patrolling.</td></tr>
<tr><td>RC: Soul of a Weary Warrior - swamp right, by sunken church</td><td>In between where the Judicator patrols in the muck pit and the submerged building with the 4 Ringed Knights. Provides some shelter from his arrows.</td></tr>
<tr><td>RC: Spears of the Church - hidden boss drop</td><td>Dropped by Darkeater Midir</td></tr>
<tr><td>RC: Titanite Chunk - streets high, building opposite</td><td>Down a path past the room where Silver Knight Ledo invades. The building is up the very long ladder from the muck pit, down the path all the way to the right.</td></tr>
<tr><td>RC: Titanite Chunk - streets, near left drop</td><td>Near the top of the stairs by Shira, dropping down in an alcove to the left.</td></tr>
<tr><td>RC: Titanite Chunk - swamp center, peninsula edge</td><td>Along the edge of the muck pit close to where the Judicator patrols.</td></tr>
<tr><td>RC: Titanite Chunk - swamp far left, up hill</td><td>Up a hill at the edge of the muck pit with the Hollow Clerics.</td></tr>
<tr><td>RC: Titanite Chunk - swamp near left, by spire top</td><td>At the edge of the muck pit, on the opposite side of the wall from the very long ladder.</td></tr>
<tr><td>RC: Titanite Chunk - swamp near right, behind rock</td><td>At the very edge of the muck pit, to the left of the submerged building with 4 Ringed Knights.</td></tr>
<tr><td>RC: Titanite Chunk - wall top, among graves</td><td>Along the right edge of the courtyard after Mausoleum Lookout in a cluster of graves.</td></tr>
<tr><td>RC: Titanite Chunk - wall upper, courtyard alcove</td><td>In the courtyard where the first Ringed Knight is seen, along the right wall into an alcove.</td></tr>
<tr><td>RC: Titanite Scale - grave, lizard past first drop</td><td>Dropped by the Crystal Lizard right after the crumbling stairs in Shared Grave.</td></tr>
<tr><td>RC: Titanite Scale - lower cliff, first alcove</td><td>In the first alcove providing shelter from Midir&#x27;s fire-breathing on the way to Shared Grave.</td></tr>
<tr><td>RC: Titanite Scale - lower cliff, lower path</td><td>After dropping down from the upper path attacked by Midir&#x27;s fire-breathing to the lower path.</td></tr>
<tr><td>RC: Titanite Scale - lower cliff, path under bridge</td><td>Partway down a slope to the right of the bridge where Midir first assaults you.</td></tr>
<tr><td>RC: Titanite Scale - swamp far, by miniboss</td><td>In the area at the far end of the muck pit with the Dragonslayer Armour.</td></tr>
<tr><td>RC: Titanite Scale - swamp far, lagoon entrance</td><td>In the area at the far end of the muck pit with the Dragonslayer Armour.</td></tr>
<tr><td>RC: Titanite Scale - upper cliff, bridge</td><td>On the final bridge where Midir attacks before you knock him off.</td></tr>
<tr><td>RC: Titanite Scale - wall lower, lizard</td><td>Dropped by the Crystal Lizard on the stairs going up from Shared Grave to Ringed Inner Wall elevator.</td></tr>
<tr><td>RC: Titanite Scale - wall top, behind spawn</td><td>Behind you at the very start of the level.</td></tr>
<tr><td>RC: Titanite Slab - ashes, NPC drop</td><td>Given by Shira after defeating Midir, or dropped by her in post-Filianore Ringed City.</td></tr>
<tr><td>RC: Titanite Slab - ashes, mob drop</td><td>Dropped by the Ringed Knight wandering around near Gael&#x27;s arena</td></tr>
<tr><td>RC: Titanite Slab - mid boss drop</td><td>Dropped by Halflight, Spear of the Church</td></tr>
<tr><td>RC: Twinkling Titanite - church path, left of boss door</td><td>Dropping down to the left of the door leading to Halflight.</td></tr>
<tr><td>RC: Twinkling Titanite - grave, lizard past first drop</td><td>Dropped by the Crystal Lizard right after the crumbling stairs in Shared Grave.</td></tr>
<tr><td>RC: Twinkling Titanite - streets high, lizard</td><td>Dropped by the Crystal Lizard which runs across the bridge after climbing the very long ladder up from the muck pit.</td></tr>
<tr><td>RC: Twinkling Titanite - swamp near left</td><td>At the left edge of the muck pit coming from the stairs, guarded by a Preacher Locust.</td></tr>
<tr><td>RC: Twinkling Titanite - swamp near right, on sunken church</td><td>Following the sloped roof of the submerged building with the 4 Ringed Knights, along the back wall</td></tr>
<tr><td>RC: Twinkling Titanite - wall top, lizard on side path</td><td>Dropped by the first Crystal Lizard on the side path on the right side of the Mausoleum Lookout courtyard</td></tr>
<tr><td>RC: Twinkling Titanite - wall tower, jump from chandelier</td><td>In the cylindrical building before the long stairs with many Harald Legion Knights. Carefully drop down to the chandelier in the center, then jump to the second floor. The item is on a ledge.</td></tr>
<tr><td>RC: Violet Wrappings - wall hidden, before boss</td><td>In the chapel before the Midir fight in the Ringed Inner Wall building.</td></tr>
<tr><td>RC: White Birch Bow - swamp far left, up hill</td><td>Up a hill at the edge of the muck pit with the Hollow Clerics.</td></tr>
<tr><td>RC: White Preacher Head - swamp near, nook right of stairs</td><td>Past the balcony to the right of the Ringed City Streets bonfire room entrance. Can be accessed by dropping down straight after from the bonfire, then around to the left.</td></tr>
<tr><td>RC: Wolf Ring+3 - street gardens, NPC drop</td><td>Dropped by Alva (invades whether embered or not, or boss defeated or not), partway down the stairs from Shira, across the bridge, and past the Ringed Knight.</td></tr>
<tr><td>RC: Young White Branch - swamp far left, by white tree #1</td><td>Next to a small birch tree at the edge of the muck pit, between the hill with the aggressive Hollow Clerics and the building with the praying Hollow Clerics outside.</td></tr>
<tr><td>RC: Young White Branch - swamp far left, by white tree #2</td><td>Next to a small birch tree at the edge of the muck pit, between the hill with the aggressive Hollow Clerics and the building with the praying Hollow Clerics outside.</td></tr>
<tr><td>RC: Young White Branch - swamp far left, by white tree #3</td><td>Next to a small birch tree at the edge of the muck pit, between the hill with the aggressive Hollow Clerics and the building with the praying Hollow Clerics outside.</td></tr>
<tr><td>RS: Blue Bug Pellet - broken stairs by Orbeck</td><td>On the broken stairs leading down from Orbeck&#x27;s area, on the opposite side from Orbeck</td></tr>
<tr><td>RS: Blue Sentinels - Horace</td><td>Given by Horace the Hushed by first &quot;talking&quot; to him, or upon death.</td></tr>
<tr><td>RS: Braille Divine Tome of Carim - drop from bridge to Halfway Fortress</td><td>Dropping down before the bridge leading up to Halfway Fortress from Road of Sacrifices, guarded by the maggot belly dog</td></tr>
<tr><td>RS: Brigand Armor - beneath road</td><td>In the middle of the path where the Madwoman waits in Road of Sacrifices</td></tr>
<tr><td>RS: Brigand Axe - beneath road</td><td>At the start of the path leading down to the Madwoman in Road of Sacrifices</td></tr>
<tr><td>RS: Brigand Gauntlets - beneath road</td><td>In the middle of the path where the Madwoman waits in Road of Sacrifices</td></tr>
<tr><td>RS: Brigand Hood - beneath road</td><td>In the middle of the path where the Madwoman waits in Road of Sacrifices</td></tr>
<tr><td>RS: Brigand Trousers - beneath road</td><td>In the middle of the path where the Madwoman waits in Road of Sacrifices</td></tr>
<tr><td>RS: Brigand Twindaggers - beneath road</td><td>At the end of the path guarded by the Madwoman in Road of Sacrifices</td></tr>
<tr><td>RS: Butcher Knife - NPC drop beneath road</td><td>Dropped by the Butcher Knife-wielding madwoman near the start of Road of Sacrifices</td></tr>
<tr><td>RS: Chloranthy Ring+2 - road, drop across from carriage</td><td>Found dropping down from the first Storyteller Corvian on the left side rather than the right side. You can then further drop down to where the madwoman is, after healing.</td></tr>
<tr><td>RS: Conjurator Boots - deep water</td><td>In the deep water part of the Crucifixion Woods crab area, between a large tree and the keep wall</td></tr>
<tr><td>RS: Conjurator Hood - deep water</td><td>In the deep water part of the Crucifixion Woods crab area, between a large tree and the keep wall</td></tr>
<tr><td>RS: Conjurator Manchettes - deep water</td><td>In the deep water part of the Crucifixion Woods crab area, between a large tree and the keep wall</td></tr>
<tr><td>RS: Conjurator Robe - deep water</td><td>In the deep water part of the Crucifixion Woods crab area, between a large tree and the keep wall</td></tr>
<tr><td>RS: Crystal Gem - stronghold, lizard</td><td>Dropped by the Crystal Lizard in the building before Crystal Sage</td></tr>
<tr><td>RS: Ember - right of Halfway Fortress entrance</td><td>On the ledge with the Corvian with the Storyteller Staff, to the right of the Halfway Fortress entrance</td></tr>
<tr><td>RS: Ember - right of fire behind stronghold left room</td><td>Behind the building before Crystal Sage, approached from Crucifixion Woods bonfire. Can drop down on left side or go under bridge on right side</td></tr>
<tr><td>RS: Estus Shard - left of fire behind stronghold left room</td><td>Behind the building leading to Crystal Sage, approached from Crucifixion Woods bonfire. Can drop down on left side of go under bridge on right side</td></tr>
<tr><td>RS: Exile Greatsword - NPC drop by Farron Keep</td><td>Dropped by the greatsword-wielding Exile Knight before the ladder down to Farron Keep</td></tr>
<tr><td>RS: Fading Soul - woods by Crucifixion Woods bonfire</td><td>Dropping down from the Crucifixion Woods bonfire toward the Halfway Fortress, guarded by dogs</td></tr>
<tr><td>RS: Fallen Knight Armor - water&#x27;s edge by Farron Keep</td><td>On the edge of the water surrounding the building where you descend into Farron Keep</td></tr>
<tr><td>RS: Fallen Knight Gauntlets - water&#x27;s edge by Farron Keep</td><td>On the edge of the water surrounding the building where you descend into Farron Keep</td></tr>
<tr><td>RS: Fallen Knight Helm - water&#x27;s edge by Farron Keep</td><td>On the edge of the water surrounding the building where you descend into Farron Keep</td></tr>
<tr><td>RS: Fallen Knight Trousers - water&#x27;s edge by Farron Keep</td><td>On the edge of the water surrounding the building where you descend into Farron Keep</td></tr>
<tr><td>RS: Farron Coal - keep perimeter</td><td>At the end of the Farron Keep Perimeter building on Crucifixion Woods side, behind the Black Knight</td></tr>
<tr><td>RS: Golden Falcon Shield - path from stronghold right room to Farron Keep</td><td>Halfway up the stairs to the sorcerer in the building before Crystal Sage, entering from the stairs leading up from the crab area, go straight and follow the path down</td></tr>
<tr><td>RS: Grass Crest Shield - water by Crucifixion Woods bonfire</td><td>Dropping down into the crab area from Crucifixion Woods, on the other side of a tree from the greater crab</td></tr>
<tr><td>RS: Great Club - NPC drop by Farron Keep</td><td>Dropped by the club-wielding Exile Knight before the ladder down to Farron Keep</td></tr>
<tr><td>RS: Great Swamp Pyromancy Tome - deep water</td><td>In the deep water part of the Crucifixion Woods crab area, between a large tree and the keep wall</td></tr>
<tr><td>RS: Great Swamp Ring - miniboss drop, by Farron Keep</td><td>Dropped by Greater Crab in Crucifixion Woods close to the Farron Keep outer wall</td></tr>
<tr><td>RS: Green Blossom - by deep water</td><td>In the Crucifixion Woods crab area out in the open, close to the edge of the deep water area</td></tr>
<tr><td>RS: Green Blossom - water beneath stronghold</td><td>In the Crucifixion Woods crab area close to the Crucifixion Woods bonfire, along the left wall of the water area, to the right of the entrance to the building before Crystal Sage</td></tr>
<tr><td>RS: Heretic&#x27;s Staff - stronghold left room</td><td>In the building before Crystal Sage, entering from near Crucifixion Woods, in a corner under the first stairwell and balcony</td></tr>
<tr><td>RS: Heysel Pick - Heysel drop</td><td>Dropped by Heysel when she invades in Road of Sacrifices</td></tr>
<tr><td>RS: Homeward Bone - balcony by Farron Keep</td><td>At the far end of the building where you descend into Farron Keep, by the balcony</td></tr>
<tr><td>RS: Large Soul of an Unknown Traveler - left of stairs to Farron Keep</td><td>In the area before you descend into Farron Keep, before the stairs to the far left</td></tr>
<tr><td>RS: Lingering Dragoncrest Ring+1 - water</td><td>On a tree by the greater crab near the Crucifixion Woods bonfire, after the Grass Crest Shield tree</td></tr>
<tr><td>RS: Morne&#x27;s Ring - drop from bridge to Halfway Fortress</td><td>Dropping down before the bridge leading up to Halfway Fortress from Road of Sacrifices, guarded by the maggot belly dog</td></tr>
<tr><td>RS: Ring of Sacrifice - stronghold, drop from right room balcony</td><td>Drop down from the platform behind the sorcerer in the building before Crystal Sage, entering from the stairs leading up from the crab area</td></tr>
<tr><td>RS: Sage Ring - water beneath stronghold</td><td>In an alcove under the building before Crystal Sage, guarded by a Lycanthrope, accessible from the swamp or from dropping down</td></tr>
<tr><td>RS: Sellsword Armor - keep perimeter balcony</td><td>In the Farron Keep Perimeter building on Crucifixion Woods side, on the balcony on the right side overlooking the Black Knight</td></tr>
<tr><td>RS: Sellsword Gauntlet - keep perimeter balcony</td><td>In the Farron Keep Perimeter building on Crucifixion Woods side, on the balcony on the right side overlooking the Black Knight</td></tr>
<tr><td>RS: Sellsword Helm - keep perimeter balcony</td><td>In the Farron Keep Perimeter building on Crucifixion Woods side, on the balcony on the right side overlooking the Black Knight</td></tr>
<tr><td>RS: Sellsword Trousers - keep perimeter balcony</td><td>In the Farron Keep Perimeter building on Crucifixion Woods side, on the balcony on the right side overlooking the Black Knight</td></tr>
<tr><td>RS: Sellsword Twinblades - keep perimeter</td><td>In the Farron Keep Perimeter building on Crucifixion Woods side, behind and to the right of the Black Knight</td></tr>
<tr><td>RS: Shriving Stone - road, by start</td><td>Dropping down to the left of the first Corvian enemy in Road of Sacrifices</td></tr>
<tr><td>RS: Sorcerer Gloves - water beneath stronghold</td><td>In an alcove under the building before Crystal Sage, guarded by a Lycanthrope, accessible from the swamp or from dropping down</td></tr>
<tr><td>RS: Sorcerer Hood - water beneath stronghold</td><td>In an alcove under the building before Crystal Sage, guarded by a Lycanthrope, accessible from the swamp or from dropping down</td></tr>
<tr><td>RS: Sorcerer Robe - water beneath stronghold</td><td>In an alcove under the building before Crystal Sage, guarded by a Lycanthrope, accessible from the swamp or from dropping down</td></tr>
<tr><td>RS: Sorcerer Trousers - water beneath stronghold</td><td>In an alcove under the building before Crystal Sage, guarded by a Lycanthrope, accessible from the swamp or from dropping down</td></tr>
<tr><td>RS: Soul of a Crystal Sage</td><td>Dropped by Crystal Sage</td></tr>
<tr><td>RS: Soul of an Unknown Traveler - drop along wall from Halfway Fortress</td><td>From Halfway Fortress, hug the right wall and drop down twice on the way to the crab area</td></tr>
<tr><td>RS: Soul of an Unknown Traveler - right of door to stronghold left</td><td>Out in the open to the right of the building before Crystal Sage, as entered from Crucifixion Woods bonfire</td></tr>
<tr><td>RS: Soul of an Unknown Traveler - road, by wagon</td><td>To the right of the overturned wagon descending from the Road of Sacrifices bonfire</td></tr>
<tr><td>RS: Titanite Shard - road, on bridge after you go under</td><td>Crossing the bridge you go under after the first Road of Sacrifices bonfire, after a sleeping Corvian and another Corvian guarding the pickup</td></tr>
<tr><td>RS: Titanite Shard - water by Halfway Fortress</td><td>Dropping down into the Crucifixion Woods crab area right after Halfway Fortress, on the left wall heading toward the Black Knight building, guarded by dog</td></tr>
<tr><td>RS: Titanite Shard - woods, left of path from Halfway Fortress</td><td>Hugging the left wall from Halfway Fortress to Crystal Sage, behind you after the first dropdown</td></tr>
<tr><td>RS: Titanite Shard - woods, surrounded by enemies</td><td>Hugging the left wall from Halfway Fortress to the Crystal Sage bonfire, after a dropdown surrounded by seven Poisonhorn bugs</td></tr>
<tr><td>RS: Twin Dragon Greatshield - woods by Crucifixion Woods bonfire</td><td>In the middle of the area with the Poisonhorn bugs and Lycanthrope Hunters, following the wall where the bugs guard a Titanite Shard</td></tr>
<tr><td>RS: Xanthous Crown - Heysel drop</td><td>Dropped by Heysel when she invades in Road of Sacrifices</td></tr>
<tr><td>SL: Black Iron Greatshield - ruins basement, NPC drop</td><td>Dropped by Knight Slayer Tsorig in Smouldering Lake</td></tr>
<tr><td>SL: Black Knight Sword - ruins main lower, illusory wall in far hall</td><td>On the far exit of the Demon Ruins main hall, past an illusory wall, guarded by a Black Knight</td></tr>
<tr><td>SL: Bloodbite Ring+1 - behind ballista</td><td>Behind the ballista, overlooking Smouldering Lake</td></tr>
<tr><td>SL: Chaos Gem - antechamber, lizard at end of long hall</td><td>Dropped by the Crystal Lizard found from the Antechamber bonfire, toward the Demon Cleric and to the right, then all the way down</td></tr>
<tr><td>SL: Chaos Gem - lake, far end by mob</td><td>In Smouldering Lake along the wall underneath the ballista, all the way to the left past two crabs</td></tr>
<tr><td>SL: Dragonrider Bow - by ladder from ruins basement to ballista</td><td>After climbing up the ladder after the Black Knight in Demon Ruins, falling back down to a ledge</td></tr>
<tr><td>SL: Ember - ruins basement, in lava</td><td>In the lava pit under the Black Knight, by Knight Slayer Tsorig</td></tr>
<tr><td>SL: Ember - ruins main lower, path to antechamber</td><td>Going down the stairs from the Antechamber bonfire, to the right, at the end of the short hallway to the next right</td></tr>
<tr><td>SL: Ember - ruins main upper, hall end by hole</td><td>In the Demon Ruins, hugging the right wall from the Demon Ruins bonfire, or making a jump from the illusory hall corridor from Antechamber bonfire</td></tr>
<tr><td>SL: Ember - ruins main upper, just after entrance</td><td>Behind the first Demon Cleric from the Demon Ruins bonfire</td></tr>
<tr><td>SL: Estus Shard - antechamber, illusory wall</td><td>Behind an illusory wall and Smouldering Writhing Flesh-filled corridor from Antechamber bonfire</td></tr>
<tr><td>SL: Flame Stoneplate Ring+2 - ruins main lower, illusory wall in far hall</td><td>On the far exit of the Demon Ruins main hall, past an illusory wall, past the Black Knight, hidden in a corner</td></tr>
<tr><td>SL: Fume Ultra Greatsword - ruins basement, NPC drop</td><td>Dropped by Knight Slayer Tsorig in Smouldering Lake</td></tr>
<tr><td>SL: Homeward Bone - path to ballista</td><td>In the area targeted by the ballista after the long ladder guarded by the Black Knight, before the Bonewheel Skeletons</td></tr>
<tr><td>SL: Izalith Pyromancy Tome - antechamber, room near bonfire</td><td>In the room straight down from the Antechamber bonfire, past a Demon Cleric, surrounded by many Ghrus.</td></tr>
<tr><td>SL: Izalith Staff - ruins basement, second illusory wall behind chest</td><td>Past an illusory wall to the left of the Large Hound Rat in Demon Ruins, and then past another illusory wall, before the basilisk area</td></tr>
<tr><td>SL: Knight Slayer&#x27;s Ring - ruins basement, NPC drop</td><td>Dropped by Knight Slayer Tsorig after invading in the Catacombs</td></tr>
<tr><td>SL: Large Titanite Shard - lake, by entrance</td><td>In the middle of Smouldering Lake, close to the Abandoned Tomb</td></tr>
<tr><td>SL: Large Titanite Shard - lake, by miniboss</td><td>In the middle of Smouldering Lake, under the Carthus Sandworm</td></tr>
<tr><td>SL: Large Titanite Shard - lake, by tree #1</td><td>In the middle of Smouldering Lake, by a tree before the hallway to the pit</td></tr>
<tr><td>SL: Large Titanite Shard - lake, by tree #2</td><td>In the middle of Smouldering Lake, by a tree before the hallway to the pit</td></tr>
<tr><td>SL: Large Titanite Shard - lake, straight from entrance</td><td>In the middle of Smouldering Lake, in between Abandoned Tomb and Demon Ruins</td></tr>
<tr><td>SL: Large Titanite Shard - ledge by Demon Ruins bonfire</td><td>On a corpse hanging off the ledge outside the Demon Ruins bonfire</td></tr>
<tr><td>SL: Large Titanite Shard - ruins basement, illusory wall in upper hall</td><td>In a chest past an illusory wall to the left of the Large Hound Rat in Demon Ruins, before the basilisk area</td></tr>
<tr><td>SL: Large Titanite Shard - side lake #1</td><td>In the Smouldering Lake pit where Horace can be found, following the right wall from Abandoned Tomb</td></tr>
<tr><td>SL: Large Titanite Shard - side lake #2</td><td>In the Smouldering Lake pit where Horace can be found, following the right wall from Abandoned Tomb</td></tr>
<tr><td>SL: Lightning Stake - lake, miniboss drop</td><td>Dropped by the giant Carthus Sandworm</td></tr>
<tr><td>SL: Llewellyn Shield - Horace drop</td><td>Dropped by Horace the Hushed upon death or quest completion.</td></tr>
<tr><td>SL: Quelana Pyromancy Tome - ruins main lower, illusory wall in grey room</td><td>At the far end of the Demon Ruins main hall to the right, where the rats are, then another right and past the illusory wall</td></tr>
<tr><td>SL: Sacred Flame - ruins basement, in lava</td><td>In the lava pit under the Black Knight, by Knight Slayer Tsorig</td></tr>
<tr><td>SL: Shield of Want - lake, by miniboss</td><td>In the middle of Smouldering Lake, under the Carthus Sandworm</td></tr>
<tr><td>SL: Soul of a Crestfallen Knight - ruins basement, above lava</td><td>Next to the Black Knight in Demon Ruins</td></tr>
<tr><td>SL: Soul of the Old Demon King</td><td>Dropped by Old Demon King in Smouldering Lake</td></tr>
<tr><td>SL: Speckled Stoneplate Ring - lake, ballista breaks bricks</td><td>Behind a destructible wall in Smouldering Lake which the ballista has to destroy</td></tr>
<tr><td>SL: Titanite Chunk - path to side lake, lizard</td><td>Dropped by the second Crystal Lizard in the cave leading to the pit where Horace can be found in Smouldering Lake</td></tr>
<tr><td>SL: Titanite Scale - ruins basement, path to lava</td><td>In the area with Basilisks on the way to the ballista</td></tr>
<tr><td>SL: Toxic Mist - ruins main lower, in lava</td><td>At the far end of the Demon Ruins main hall to the right, where the rats are, then another right and past the illusory wall, in the middle of the lava pit.</td></tr>
<tr><td>SL: Twinkling Titanite - path to side lake, lizard</td><td>Dropped by the first Crystal Lizard in the cave leading to the pit where Horace can be found in Smouldering Lake</td></tr>
<tr><td>SL: Undead Bone Shard - lake, miniboss drop</td><td>Dropped by the giant Carthus Sandworm</td></tr>
<tr><td>SL: Undead Bone Shard - ruins main lower, left after stairs</td><td>In the close end of the Demon Ruins main hall, right below a Smouldering Writhing Flesh</td></tr>
<tr><td>SL: White Hair Talisman - ruins main lower, in lava</td><td>At the far end of the Demon Ruins main hall to the right, where the rats are, then another right and past the illusory wall, at the far end of the lava pit.</td></tr>
<tr><td>SL: Yellow Bug Pellet - side lake</td><td>In the Smouldering Lake pit where Horace can be found, following the right wall from Abandoned Tomb</td></tr>
<tr><td>UG: Ashen Estus Ring - swamp, path opposite bonfire</td><td>In the coffin similar to your initial spawn location, guarded by Corvians</td></tr>
<tr><td>UG: Black Knight Glaive - boss arena</td><td>In the Champion Gundyr boss area</td></tr>
<tr><td>UG: Blacksmith Hammer - shrine, Andre&#x27;s room</td><td>Where Andre sits in Firelink Shrine</td></tr>
<tr><td>UG: Chaos Blade - environs, left of shrine</td><td>Where Sword Master is in Firelink Shrine</td></tr>
<tr><td>UG: Coiled Sword Fragment - shrine, dead bonfire</td><td>In the dead Firelink Shrine bonfire</td></tr>
<tr><td>UG: Ember - shop</td><td>Sold by Untended Graves Handmaid</td></tr>
<tr><td>UG: Eyes of a Fire Keeper - shrine, Irina&#x27;s room</td><td>Behind an illusory wall, in the same location Irina sits in Firelink Shrine</td></tr>
<tr><td>UG: Hidden Blessing - cemetery, behind coffin</td><td>Behind the coffin that had a Titanite Shard in Cemetery of Ash</td></tr>
<tr><td>UG: Hornet Ring - environs, right of main path after killing FK boss</td><td>On a cliffside to the right of the main path leading up to dark Firelink Shrine, after Abyss Watchers is defeated.</td></tr>
<tr><td>UG: Life Ring+3 - shrine, behind big throne</td><td>Behind Prince Lothric&#x27;s throne</td></tr>
<tr><td>UG: Priestess Ring - shop</td><td>Sold or dropped by Untended Graves Handmaid. Killing her is not recommended</td></tr>
<tr><td>UG: Ring of Steel Protection+1 - environs, behind bell tower</td><td>Behind Bell Tower to the right</td></tr>
<tr><td>UG: Shriving Stone - swamp, by bonfire</td><td>At the very start of the area</td></tr>
<tr><td>UG: Soul of Champion Gundyr</td><td>Dropped by Champion Gundyr</td></tr>
<tr><td>UG: Soul of a Crestfallen Knight - environs, above shrine entrance</td><td>Above the Firelink Shrine entrance, up the stairs/slope from either left or right of the entrance</td></tr>
<tr><td>UG: Soul of a Crestfallen Knight - swamp, center</td><td>Close to where Ashen Estus Flask was in Cemetery of Ash</td></tr>
<tr><td>UG: Titanite Chunk - swamp, left path by fountain</td><td>In a path to the left of where Ashen Estus Flask was in Cemetery of Ash</td></tr>
<tr><td>UG: Titanite Chunk - swamp, right path by fountain</td><td>In a path to the right of where Ashen Estus Flask was in Cemetery of Ash</td></tr>
<tr><td>UG: Wolf Knight Armor - shop after killing FK boss</td><td>Sold by Untended Graves Handmaid after defeating Abyss Watchers</td></tr>
<tr><td>UG: Wolf Knight Gauntlets - shop after killing FK boss</td><td>Sold by Untended Graves Handmaid after defeating Abyss Watchers</td></tr>
<tr><td>UG: Wolf Knight Helm - shop after killing FK boss</td><td>Sold by Untended Graves Handmaid after defeating Abyss Watchers</td></tr>
<tr><td>UG: Wolf Knight Leggings - shop after killing FK boss</td><td>Sold by Untended Graves Handmaid after defeating Abyss Watchers</td></tr>
<tr><td>US: Alluring Skull - foot, behind carriage</td><td>Guarded by two dogs after the Foot of the High Wall bonfire</td></tr>
<tr><td>US: Alluring Skull - on the way to tower, behind building</td><td>After the ravine bridge leading to Eygon and the Giant&#x27;s tower, wrapping around the building to the right.</td></tr>
<tr><td>US: Alluring Skull - tower village building, upstairs</td><td>Up the stairs of the building with Cage Spiders after the Fire Demon, before the dogs</td></tr>
<tr><td>US: Bloodbite Ring - miniboss in sewer</td><td>Dropped by the large rat in the sewers with grave access</td></tr>
<tr><td>US: Blue Wooden Shield - graveyard by white tree</td><td>After Dilapidated Bridge bonfire, in the back of the Giant&#x27;s arrow area. Guarded by a flamberge-wielding thrall.</td></tr>
<tr><td>US: Caduceus Round Shield - right after stable exit</td><td>After exiting the building across the bridge to the right of the first Undead Settlement building, to the left</td></tr>
<tr><td>US: Caestus - sewer</td><td>In the tunnel with the Giant Hound Rat and Grave Key door, from the ravine bridge toward Dilapidated Bridge bonfire</td></tr>
<tr><td>US: Charcoal Pine Bundle - first building, bottom floor</td><td>Down the stairs in the first building</td></tr>
<tr><td>US: Charcoal Pine Bundle - first building, middle floor</td><td>On the bottom floor of the first building</td></tr>
<tr><td>US: Charcoal Pine Resin - hanging corpse room</td><td>In the building after the burning tree and Cathedral Evangelist, in the room with the many hanging corpses</td></tr>
<tr><td>US: Chloranthy Ring - tower village, jump from roof</td><td>At the end of the Fire Demon loop, in the tower where you have to drop down after the roof</td></tr>
<tr><td>US: Cleric Blue Robe - graveyard by white tree</td><td>After Dilapidated Bridge bonfire, in the back of the Giant&#x27;s arrow area. Guarded by a flamberge-wielding thrall.</td></tr>
<tr><td>US: Cleric Gloves - graveyard by white tree</td><td>After Dilapidated Bridge bonfire, in the back of the Giant&#x27;s arrow area. Guarded by a flamberge-wielding thrall.</td></tr>
<tr><td>US: Cleric Hat - graveyard by white tree</td><td>After Dilapidated Bridge bonfire, in the back of the Giant&#x27;s arrow area. Guarded by a flamberge-wielding thrall.</td></tr>
<tr><td>US: Cleric Trousers - graveyard by white tree</td><td>After Dilapidated Bridge bonfire, in the back of the Giant&#x27;s arrow area. Guarded by a flamberge-wielding thrall.</td></tr>
<tr><td>US: Cornyx&#x27;s Garb - by Cornyx&#x27;s cage after Cuculus quest</td><td>Appears next to Cornyx&#x27;s cage after defeating Old Demon King with Cuculus surviving</td></tr>
<tr><td>US: Cornyx&#x27;s Garb - kill Cornyx</td><td>Dropped by Cornyx</td></tr>
<tr><td>US: Cornyx&#x27;s Skirt - by Cornyx&#x27;s cage after Cuculus quest</td><td>Appears next to Cornyx&#x27;s cage after defeating Old Demon King with Cuculus surviving</td></tr>
<tr><td>US: Cornyx&#x27;s Skirt - kill Cornyx</td><td>Dropped by Cornyx</td></tr>
<tr><td>US: Cornyx&#x27;s Wrap - by Cornyx&#x27;s cage after Cuculus quest</td><td>Appears next to Cornyx&#x27;s cage after defeating Old Demon King with Cuculus surviving</td></tr>
<tr><td>US: Cornyx&#x27;s Wrap - kill Cornyx</td><td>Dropped by Cornyx</td></tr>
<tr><td>US: Covetous Silver Serpent Ring+2 - tower village, drop down from roof</td><td>At the back of a roof near the end of the Fire Demon loop, dropping down past where Flynn&#x27;s Ring is</td></tr>
<tr><td>US: Ember - behind burning tree</td><td>Behind the burning tree with the Cathedral Evangelist</td></tr>
<tr><td>US: Ember - bridge on the way to tower</td><td>On the ravine bridge leading toward Eygon and the Giant&#x27;s tower</td></tr>
<tr><td>US: Ember - by stairs to boss</td><td>Next to the stairs leading up to Curse-Rotted Greatwood fight, near a tree guarded by a dog</td></tr>
<tr><td>US: Ember - by white tree</td><td>Near the Birch Tree where giant shoots arrows</td></tr>
<tr><td>US: Ember - tower basement, miniboss</td><td>In the room with the Outrider Knight</td></tr>
<tr><td>US: Estus Shard - under burning tree</td><td>In front of the burning tree guarded by the Cathedral Evangelist</td></tr>
<tr><td>US: Fading Soul - by white tree</td><td>Near the Birch Tree where giant shoots arrows</td></tr>
<tr><td>US: Fading Soul - outside stable</td><td>In the thrall area to the right of the bridge to the right of the burning tree with the Cathedral Evangelist</td></tr>
<tr><td>US: Fire Clutch Ring - wooden walkway past stable</td><td>From the area bombarded by firebombs above the Cliff Underside bonfire</td></tr>
<tr><td>US: Fire Gem - tower village, miniboss drop</td><td>Dropped by the Fire Demon you fight with Siegward</td></tr>
<tr><td>US: Firebomb - stable roof</td><td>In the thrall area across the bridge from the first Undead Settlement building, on a rooftop overlooking the Cliff Underside area.</td></tr>
<tr><td>US: Flame Stoneplate Ring - hanging corpse by Mound-Maker transport</td><td>On a hanging corpse in the area with the Pit of Hollows cage manservant, after the thrall area, overlooking the entrance to the Giant&#x27;s tower.</td></tr>
<tr><td>US: Flynn&#x27;s Ring - tower village, rooftop</td><td>On the roof toward the end of the Fire Demon loop, past the Cathedral Evangelists</td></tr>
<tr><td>US: Great Scythe - building by white tree, balcony</td><td>On the balcony of the building before Curse-Rotted Greatwood, coming from Dilapidated Bridge bonfire</td></tr>
<tr><td>US: Hand Axe - by Cornyx</td><td>Next to Cornyx&#x27;s cell</td></tr>
<tr><td>US: Hawk Ring - Giant Archer</td><td>Dropped by Giant, either by killing him or collecting all of the birch tree items locations in the base game.</td></tr>
<tr><td>US: Heavy Gem - Hawkwood</td><td>Given or dropped by Hawkwood after defeating Curse-Rotted Greatwood or Crystal Sage</td></tr>
<tr><td>US: Heavy Gem - chasm, lizard</td><td>Drop by Crystal Lizard in ravine accessible by Grave Key or dropping down near Eygon.</td></tr>
<tr><td>US: Homeward Bone - foot, drop overlook</td><td>Under Foot of the High Wall bonfire, around where Yoel can be first met</td></tr>
<tr><td>US: Homeward Bone - stable roof</td><td>In the thrall area across the bridge from the first Undead Settlement building, on a roof overlooking the ravine bridge.</td></tr>
<tr><td>US: Homeward Bone - tower village, jump from roof</td><td>At the end of the loop from the Siegward Demon fight, after dropping down from the roof onto the tower with Chloranthy Ring, to the right of the tower entrance</td></tr>
<tr><td>US: Homeward Bone - tower village, right at start</td><td>Under Foot of the High Wall bonfire, around where Yoel can be first met</td></tr>
<tr><td>US: Human Pine Resin - tower village building, chest upstairs</td><td>In a chest after Fire Demon. Cage Spiders activate open opening it.</td></tr>
<tr><td>US: Irithyll Straight Sword - miniboss drop, by Road of Sacrifices</td><td>Dropped by the Boreal Outright Knight before Road of Sacrifices</td></tr>
<tr><td>US: Kukri - hanging corpse above burning tree</td><td>Hanging corpse high above the burning tree with the Cathedral Evangelist. Must be shot down with an arrow or projective.</td></tr>
<tr><td>US: Large Club - tower village, by miniboss</td><td>In the Fire Demon area</td></tr>
<tr><td>US: Large Soul of a Deserted Corpse - across from Foot of the High Wall</td><td>On the opposite tower from the Foot of the High Wall bonfire</td></tr>
<tr><td>US: Large Soul of a Deserted Corpse - around corner by Cliff Underside</td><td>After going up the stairs from Curse-Rotted Greatwood to Cliff Underside area, on a cliff edge to the right</td></tr>
<tr><td>US: Large Soul of a Deserted Corpse - by white tree</td><td>Near the Birch Tree where giant shoots arrows</td></tr>
<tr><td>US: Large Soul of a Deserted Corpse - hanging corpse room, over stairs</td><td>On a hanging corpse in the building after the burning tree. Can be knocked down by dropping onto the stairs through the broken railing.</td></tr>
<tr><td>US: Large Soul of a Deserted Corpse - on the way to tower, by well</td><td>After the ravine bridge leading toward Eygon and the Giant&#x27;s tower, next to the well to the right</td></tr>
<tr><td>US: Large Soul of a Deserted Corpse - stable</td><td>In the building with stables across the bridge and to the right from the first Undead Settlement building</td></tr>
<tr><td>US: Life Ring+1 - tower on the way to village</td><td>On the wooden rafters near where Siegward is waiting for Fire Demon</td></tr>
<tr><td>US: Loincloth - by Velka statue</td><td>Next to the Velka statue. Requires Grave Key or dropping down near Eygon and backtracking through the skeleton area.</td></tr>
<tr><td>US: Loretta&#x27;s Bone - first building, hanging corpse on balcony</td><td>On a hanging corpse after the first building, can be knocked down by rolling into it</td></tr>
<tr><td>US: Mirrah Gloves - tower village, jump from roof</td><td>At the end of the Fire Demon loop, in the tower where you have to drop down after the roof</td></tr>
<tr><td>US: Mirrah Trousers - tower village, jump from roof</td><td>At the end of the Fire Demon loop, in the tower where you have to drop down after the roof</td></tr>
<tr><td>US: Mirrah Vest - tower village, jump from roof</td><td>At the end of the Fire Demon loop, in the tower where you have to drop down after the roof</td></tr>
<tr><td>US: Mortician&#x27;s Ashes - graveyard by white tree</td><td>In the area past the Dilapidated Bridge bonfire, where the Giant is shooting arrows, at the close end of the graveyard</td></tr>
<tr><td>US: Mound-makers - Hodrick</td><td>Given by Hodrick if accessing the Pit of Hollows before fighting Curse-Rotted Greatwood, or dropped after invading him with Sirris.</td></tr>
<tr><td>US: Northern Armor - tower village, hanging corpse</td><td>Hanging corpse in the Fire Demon fight area, can be knocked down by rolling into it</td></tr>
<tr><td>US: Northern Gloves - tower village, hanging corpse</td><td>Hanging corpse in the Fire Demon fight area, can be knocked down by rolling into it</td></tr>
<tr><td>US: Northern Helm - tower village, hanging corpse</td><td>Hanging corpse in the Fire Demon fight area, can be knocked down by rolling into it</td></tr>
<tr><td>US: Northern Trousers - tower village, hanging corpse</td><td>Hanging corpse in the Fire Demon fight area, can be knocked down by rolling into it</td></tr>
<tr><td>US: Old Sage&#x27;s Blindfold - kill Cornyx</td><td>Dropped by Cornyx</td></tr>
<tr><td>US: Pale Tongue - tower village, hanging corpse</td><td>Hanging corpse in the Fire Demon fight area, can be knocked down by rolling into it</td></tr>
<tr><td>US: Partizan - hanging corpse above Cliff Underside</td><td>On a hanging corpse on the path from Cliff Underside to Cornyx&#x27;s cage. Must be shot down with an arrow or projective.</td></tr>
<tr><td>US: Plank Shield - outside stable, by NPC</td><td>In the thrall area across the bridge from the first Undead Settlement building, on a cliff edge overlooking the ravine bridge.</td></tr>
<tr><td>US: Poisonbite Ring+1 - graveyard by white tree, near well</td><td>Behind the well in the back of area where the Giant shoots arrows, nearby where the flamberge-wielding thrall drops down.</td></tr>
<tr><td>US: Pyromancy Flame - Cornyx</td><td>Given by Cornyx in Firelink Shrine or dropped.</td></tr>
<tr><td>US: Red Bug Pellet - tower village building, basement</td><td>On the floor of the building after the Fire Demon encounter</td></tr>
<tr><td>US: Red Hilted Halberd - chasm crypt</td><td>In the skeleton area accessible from Grave Key or dropping down from near Eygon</td></tr>
<tr><td>US: Red and White Round Shield - chasm, hanging corpse</td><td>On a hanging corpse in the ravine accessible with the Grave Key or dropping down near Eygon, to the entrance of Irina&#x27;s prison. Must be shot down with an arrow or projective.</td></tr>
<tr><td>US: Reinforced Club - by white tree</td><td>Near the Birch Tree where giant shoots arrows</td></tr>
<tr><td>US: Repair Powder - first building, balcony</td><td>On the balcony of the first Undead Settlement building</td></tr>
<tr><td>US: Rusted Coin - awning above Dilapidated Bridge</td><td>On a wooden ledge near the Dilapidated Bridge bonfire. Must be jumped to from near Cathedral Evangelist enemy</td></tr>
<tr><td>US: Saint&#x27;s Talisman - chasm, by ladder</td><td>From the ravine accessible via Grave Key or dropping near Eygon, before ladder leading up to Irina of Carim</td></tr>
<tr><td>US: Sharp Gem - lizard by Dilapidated Bridge</td><td>Drop by Crystal Lizard near Dilapidated Bridge bonfire.</td></tr>
<tr><td>US: Siegbräu - Siegward</td><td>Given by Siegward after helping him defeat the Fire Demon.</td></tr>
<tr><td>US: Small Leather Shield - first building, hanging corpse by entrance</td><td>Hanging corpse in the first building, to the right of the entrance</td></tr>
<tr><td>US: Soul of a Nameless Soldier - top of tower</td><td>At the top of the tower where Giant shoots arrows</td></tr>
<tr><td>US: Soul of an Unknown Traveler - back alley, past crates</td><td>After exiting the building after the burning tree on the way to the Dilapidated Bridge bonfire. Hidden behind some crates between two buildings on the right.</td></tr>
<tr><td>US: Soul of an Unknown Traveler - chasm crypt</td><td>In the skeleton area accessible Grave Key or dropping down from near Eygon</td></tr>
<tr><td>US: Soul of an Unknown Traveler - pillory past stable</td><td>In the area bombarded by firebombs above the Cliff Underside bonfire</td></tr>
<tr><td>US: Soul of an Unknown Traveler - portcullis by burning tree</td><td>Behind a grate to the left of the burning tree and Cathedral Evangelist</td></tr>
<tr><td>US: Soul of the Rotted Greatwood</td><td>Dropped by Curse Rotted Greatwood</td></tr>
<tr><td>US: Spotted Whip - by Cornyx&#x27;s cage after Cuculus quest</td><td>Appears next to Cornyx&#x27;s cage after defeating Old Demon King with Cuculus surviving</td></tr>
<tr><td>US: Sunset Armor - pit of hollows after killing Hodrick w/Sirris</td><td>Found in Pit of Hollows after completing Sirris&#x27; questline.</td></tr>
<tr><td>US: Sunset Gauntlets - pit of hollows after killing Hodrick w/Sirris</td><td>Found in Pit of Hollows after completing Sirris&#x27; questline.</td></tr>
<tr><td>US: Sunset Helm - Pit of Hollows after killing Hodrick w/Sirris</td><td>Found in Pit of Hollows after completing Sirris&#x27; questline.</td></tr>
<tr><td>US: Sunset Leggings - pit of hollows after killing Hodrick w/Sirris</td><td>Found in Pit of Hollows after completing Sirris&#x27; questline.</td></tr>
<tr><td>US: Titanite Shard - back alley, side path</td><td>On a side path to the right of the Cathedral Evangelist before the Dilapidated Bridge bonfire</td></tr>
<tr><td>US: Titanite Shard - back alley, up ladder</td><td>Next to the Cathedral Evangelist close to the Dilapidated Bridge bonfire</td></tr>
<tr><td>US: Titanite Shard - chasm #1</td><td>In the ravine accessible from Grave Key or dropping down from near Eygon</td></tr>
<tr><td>US: Titanite Shard - chasm #2</td><td>In the ravine accessible from Grave Key or dropping down from near Eygon</td></tr>
<tr><td>US: Titanite Shard - lower path to Cliff Underside</td><td>At the end of the cliffside path next to Cliff Underside bonfire, guarded by a Hollow Peasant wielding a four-pronged plow.</td></tr>
<tr><td>US: Titanite Shard - porch after burning tree</td><td>In front of the building after the burning tree and Cathedral Evangelist</td></tr>
<tr><td>US: Tower Key - kill Irina</td><td>Dropped by Irina of Carim</td></tr>
<tr><td>US: Transposing Kiln - boss drop</td><td>Dropped by Curse Rotted Greatwood</td></tr>
<tr><td>US: Undead Bone Shard - by white tree</td><td>In the area past the Dilapidated Bridge bonfire, where the Giant is shooting arrows, jumping to the floating platform on the right</td></tr>
<tr><td>US: Wargod Wooden Shield - Pit of Hollows</td><td>In the Pit of Hollows</td></tr>
<tr><td>US: Warrior of Sunlight - hanging corpse room, drop through hole</td><td>Dropping through a hole in the floor in the first building after the burning tree.</td></tr>
<tr><td>US: Whip - back alley, behind wooden wall</td><td>In one of the houses between building after the burning tree and the Dilapidated Bridge bonfire</td></tr>
<tr><td>US: Young White Branch - by white tree #1</td><td>Near the Birch Tree where giant shoots arrows</td></tr>
<tr><td>US: Young White Branch - by white tree #2</td><td>Near the Birch Tree where giant shoots arrows</td></tr>
</table>
<!-- end location table -->
