ITEM_ID_OFFSET:int = 264000
LOCATION_ID_OFFSET:int = 264000
LOCATION_DAY_OFFSET = 266000
LOCATION_BOSS_RANGE = {"start": 264251, "end": 264300}
LOCATION_RESEARCH_RANGE = {"start": 264501, "end": 264900}

class REGION:
    NONE = "None"
    MENU = "Menu"
    FOREST = "Forest"
    CAVE = "Cave"
    ARCHIVE = "Archive"
    RUINS = "Ruins"
    OCEAN = "Ocean"
    MOONQUAY = "Moon Quay"
    MOONSTORM = "Moonstorm"
    DUALREGION = "Dual Region"
    BOTHREGIONS = "Both Regions"

    tag_lookup = {
        "cave":        CAVE,
        "ruins":       RUINS,
        "archive":     ARCHIVE,
        "ocean":       OCEAN,
        "moonquay":    MOONQUAY,
        "moonstorm":   MOONSTORM,
        "dualregion":  DUALREGION,
        "bothregions": BOTHREGIONS,
    }

class PHASE:
    DAY = "Day"
    DUSK = "Dusk"
    NIGHT = "Night"
    DAY_OR_DUSK = "Day or Dusk"
    DUSK_OR_NIGHT = "Dusk or Night"

    tag_lookup = {
        "day":   DAY,
        "dusk":  DUSK,
        "night": NIGHT,
    }

class SEASON:
    AUTUMN = "Autumn"
    WINTER = "Winter"
    SPRING = "Spring"
    SUMMER = "Summer"
    NONWINTER = "Nonwinter"
    NONSPRING = "Nonspring"
    NONSUMMER = "Nonsummer"

    tag_lookup = {
        "autumn": AUTUMN,
        "winter": WINTER,
        "spring": SPRING,
        "summer": SUMMER,
    }

class SEASONS_PASSED:
    SEASONS_HALF = "Seasons Passed Half"
    SEASONS_1 = "Seasons Passed 1"
    SEASONS_2 = "Seasons Passed 2"
    SEASONS_3 = "Seasons Passed 3"
    SEASONS_4 = "Seasons Passed 4"
    SEASONS_5 = "Seasons Passed 5"

    tag_lookup = {
        "seasons_passed_half": SEASONS_HALF,
        "seasons_passed_1":    SEASONS_1,
        "seasons_passed_2":    SEASONS_2,
        "seasons_passed_3":    SEASONS_3,
        "seasons_passed_4":    SEASONS_4,
        "seasons_passed_5":    SEASONS_5,
    }

class SPECIAL_TAGS:
    RUINS_GEMS = "Ruins Gems"
    MOOSEGOOSE = "Moose/Goose"
    BUTTER_MUFFIN = "Butter Muffin"
    LOBSTER_DINNER = "Lobster Dinner"
    LEAFY_MEAT = "Leafy Meat"
    FRUITS = "Fruits"
    BANANA = "Banana"
    CORN = "Corn"
    HERMIT_8 = "Hermit Friendship 8"
    HERMIT_10 = "Hermit Friendship 10"

    tag_lookup = {
        "special_ruinsgems":     RUINS_GEMS,
        "special_moosegoose":    MOOSEGOOSE,
        "special_buttermuffin":  BUTTER_MUFFIN,
        "special_lobsterdinner": LOBSTER_DINNER,
        "special_leafymeat":     LEAFY_MEAT,
        "special_fruits":        FRUITS,
        "special_banana":        BANANA,
        "special_corn":          CORN,
        "special_hermit_8":      HERMIT_8,
        "special_hermit_10":     HERMIT_10,
    }


BOSS_PREREQUISITES = {
    "Ancient Fuelweaver": {"Ancient Guardian", "Shadow Bishop", "Shadow Knight", "Shadow Rook"},
    "Celestial Champion": {"Crab King"},
    "Scrappy Werepig":    {"Nightmare Werepig"},
}

# About "deprecated" items and locations:
# If an item is no longer to be included in generation it gets marked as "deprecated".
# Items marked as "deprecated" directly below "bundle" are likely moved into that bundle, and are no longer placed individually

# Most progression items are decided by rules, only exception are basic recipes

DSTAP_ITEMS = [
    # Crafting Recipes (1-400)
    [1,   "Tackle Receptacle",           "tacklestation",                         [ "useful", "ocean" ] ],
    # [2,   "UNUSED",                      "",                                      [ "filler" ] ],
    [3,   "Potter's Wheel",              "sculptingtable",                        [ "useful" ] ],
    [4,   "Terra Firma Tamper",          "turfcraftingstation",                   [ "useful", "archive", "ocean" ] ],
    [5,   "Sawhorse",                    "carpentry_station",                     [ "useful", "ocean" ] ],
    [6,   "Luxury Axe",                  "goldenaxe",                             [ "useful" ] ],
    [7,   "Opulent Pickaxe",             "goldenpickaxe",                         [ "useful" ] ],
    [8,   "Shovel",                      "shovel",                                [ "useful" ] ],
    [9,   "Regal Shovel",                "goldenshovel",                          [ "useful" ] ],
    [10,  "Bug Net",                     "bugnet",                                [ "useful" ] ],
    [11,  "Pitchfork",                   "pitchfork",                             [ "useful" ] ],
    [12,  "Snazzy Pitchfork",            "goldenpitchfork",                       [ "useful" ] ],
    [13,  "Razor",                       "razor",                                 [ "useful" ] ],
    [14,  "Ocuvigil",                    "sentryward",                            [ "filler" ] ],
    [15,  "Feather Pencil",              "featherpencil",                         [ "useful" ] ],
    [16,  "Clean Sweeper",               "reskin_tool",                           [ "filler" ] ],
    [17,  "Astral Detector",             "archive_resonator_item",                [ "useful", "ocean" ] ],
    [18,  "Healing Salve",               "healingsalve",                          [ "useful" ] ],
    [19,  "Tillweed Salve",              "tillweedsalve",                         [ "useful" ] ],
    [20,  "Honey Poultice",              "bandage",                               [ "useful" ] ],
    [21,  "Booster Shot",                "lifeinjector",                          [ "useful" ] ],
    [22,  "Straw Roll",                  "bedroll_straw",                         [ "useful" ] ],
    [23,  "Fur Roll",                    "bedroll_furry",                         [ "useful" ] ],
    [24,  "Endothermic Fire",            "coldfire",                              [ "useful" ] ],
    [25,  "Endothermic Fire Pit",        "coldfirepit",                           [ "useful" ] ],
    [26,  "Pumpkin Lantern",             "pumpkin_lantern",                       [ "filler" ] ],
    [27,  "Miner Hat",                   "minerhat",                              [ "useful" ] ],
    [28,  "Moggles",                     "molehat",                               [ "useful", "cave" ] ],
    [29,  "Lantern",                     "lantern",                               [ "useful", "cave", "ocean" ] ],
    [30,  "Night Light",                 "nightlight",                            [ "filler" ] ],
    [31,  "Scaled Furnace",              "dragonflyfurnace",                      [ "useful" ] ],
    [32,  "Mushlight and Glowcap",       "mushroom_light",                        [ "filler", "bundle", "cave" ] ],
    [33,  "Glowcap",                     "mushroom_light2",                       [ "filler", "deprecated", "cave" ] ],
    [34,  "Garden Hoe",                  "farm_hoe",                              [ "useful" ] ],
    [35,  "Splendid Garden Hoe",         "golden_farm_hoe",                       [ "useful" ] ],
    [36,  "Garden Digamajig",            "farm_plow_item",                        [ "useful" ] ],
    [37,  "Empty Watering Can",          "wateringcan",                           [ "useful" ] ],
    [38,  "Empty Waterfowl Can",         "premiumwateringcan",                    [ "filler", "ocean" ] ],
    [39,  "Bucket-o-poop",               "fertilizer",                            [ "useful" ] ],
    [40,  "Growth Formula Starter",      "soil_amender",                          [ "useful", "ocean" ] ],
    [41,  "Tree Jam",                    "treegrowthsolution",                    [ "useful", "ocean" ] ],
    [42,  "Composting Bin",              "compostingbin",                         [ "useful" ] ],
    [43,  "Gardeneer Hat",               "plantregistryhat",                      [ "useful" ] ],
    [44,  "Mushroom Planter",            "mushroom_farm",                         [ "useful" ] ],
    [45,  "Bee Box",                     "beebox",                                [ "useful", "nonwinter" ] ],
    [46,  "Bird Trap",                   "birdtrap",                              [ "useful" ] ],
    [47,  "Birdcage",                    "birdcage",                              [ "useful" ] ],
    [48,  "Thermal Stone",               "heatrock",                              [ "useful" ] ],
    [49,  "Rope",                        "rope",                                  [ "useful" ] ],
    [50,  "Boards",                      "boards",                                [ "useful" ] ],
    [51,  "Cut Stone",                   "cutstone",                              [ "useful" ] ],
    [52,  "Papyrus",                     "papyrus",                               [ "useful" ] ],
    [53,  "Electrical Doodad",           "transistor",                            [ "useful" ] ],
    [54,  "Wax Paper",                   "waxpaper",                              [ "useful" ] ],
    [55,  "Beeswax",                     "beeswax",                               [ "useful" ] ],
    [56,  "Marble Bean",                 "marblebean",                            [ "useful" ] ],
    [57,  "Nightmare Fuel",              "nightmarefuel",                         [ "filler" ] ],
    [58,  "Purple Gem",                  "purplegem",                             [ "useful" ] ],
    [59,  "Cratered Moonrock",           "moonrockcrater",                        [ "useful" ] ],
    [60,  "Thick Fur",                   "bearger_fur",                           [ "filler", "giveitem" ] ],
    [61,  "Feathery Canvas",             "malbatross_feathered_weave",            [ "useful", "ocean" ] ],
    [62,  "Collected Dust",              "refined_dust",                          [ "useful", "ocean" ] ],
    [63,  "Gramophone",                  "phonograph",                            [ "useful", "bundle", "cave" ] ],
    [64,  "Crock Pot",                   "cookpot",                               [ "useful" ] ],
    [65,  "Drying Rack",                 "meatrack",                              [ "useful" ] ],
    [66,  "Spear",                       "spear",                                 [ "useful" ] ],
    [67,  "Tail o' Three Cats",          "whip",                                  [ "filler" ] ],
    [68,  "Ham Bat",                     "hambat",                                [ "useful" ] ],
    [69,  "Bat Bat",                     "batbat",                                [ "useful", "cave" ] ],
    [70,  "Morning Star",                "nightstick",                            [ "useful" ] ],
    [71,  "Dark Sword",                  "nightsword",                            [ "useful" ] ],
    [72,  "Napsack",                     "sleepbomb",                             [ "filler", "cave" ] ],
    [73,  "Blow Dart",                   "blowdart_pipe",                         [ "useful", "winter" ] ],
    [74,  "Fire Dart",                   "blowdart_fire",                         [ "useful", "nonwinter" ] ],
    [75,  "Electric Dart",               "blowdart_yellow",                       [ "useful" ] ],
    [76,  "Sleep Dart",                  "blowdart_sleep",                        [ "useful" ] ],
    [77,  "Boomerang",                   "boomerang",                             [ "useful" ] ],
    [78,  "Weather Pain",                "staff_tornado",                         [ "useful" ] ],
    [79,  "Strident Trident",            "trident",                               [ "useful", "ocean" ] ],
    [80,  "Fire Staff",                  "firestaff",                             [ "useful" ] ],
    [81,  "Ice Staff",                   "icestaff",                              [ "useful" ] ],
    [82,  "Log Suit",                    "armorwood",                             [ "useful" ] ],
    [83,  "Scalemail",                   "armordragonfly",                        [ "useful" ] ],
    [84,  "Night Armor",                 "armor_sanity",                          [ "useful" ] ],
    [85,  "Marble Suit",                 "armormarble",                           [ "useful" ] ],
    [86,  "Football Helmet",             "footballhat",                           [ "useful" ] ],
    [87,  "Cookie Cutter Cap",           "cookiecutterhat",                       [ "useful", "ocean" ] ],
    [88,  "Gunpowder",                   "gunpowder",                             [ "useful" ] ],
    [89,  "Pan Flute",                   "panflute",                              [ "useful" ] ],
    [90,  "Bee Mine",                    "beemine",                               [ "useful", "nonwinter" ] ],
    [91,  "Tooth Trap",                  "trap_teeth",                            [ "useful" ] ],
    [92,  "Waterballoon",                "waterballoon",                          [ "useful" ] ],
    [93,  "Bundling Wrap",               "bundlewrap",                            [ "useful" ] ],
    [94,  "Backpack",                    "backpack",                              [ "useful" ] ],
    [95,  "Seed Pack-It",                "seedpouch",                             [ "filler", "cave", "ocean" ] ],
    [96,  "Piggyback",                   "piggyback",                             [ "useful" ] ],
    [97,  "Insulated Pack",              "icepack",                               [ "useful" ] ],
    [98,  "One-man Band",                "onemanband",                            [ "useful" ] ],
    [99,  "Belt of Hunger",              "armorslurper",                          [ "useful" ] ],
    [100, "Umbrella",                    "umbrella",                              [ "useful" ] ],
    [101, "Luxury Fan",                  "featherfan",                            [ "useful" ] ],
    [102, "Sewing Kit",                  "sewing_kit",                            [ "useful" ] ],
    [103, "Top Hat",                     "tophat",                                [ "useful" ] ],
    [104, "Rain Hat",                    "rainhat",                               [ "useful" ] ],
    [105, "Beefalo Hat",                 "beefalohat",                            [ "useful" ] ],
    [106, "Winter Hat",                  "winterhat",                             [ "useful", "winter" ] ],
    [107, "Cat Cap",                     "catcoonhat",                            [ "useful", "winter" ] ],
    [108, "Fashion Goggles",             "goggleshat",                            [ "useful" ] ],
    [109, "Desert Goggles",              "deserthat",                             [ "useful", "summer" ] ],
    [110, "Astroggles",                  "moonstorm_goggleshat",                  [ "useful", "moonstorm" ] ],
    [111, "Fashion Melon",               "watermelonhat",                         [ "useful", "summer" ] ],
    [112, "Ice Cube",                    "icehat",                                [ "useful", "summer" ] ],
    [113, "Beekeeper Hat",               "beehat",                                [ "useful" ] ],
    [114, "Feather Hat",                 "featherhat",                            [ "filler", "nonwinter" ] ],
    [115, "Bush Hat",                    "bushhat",                               [ "filler" ] ],
    [116, "Rain Coat",                   "raincoat",                              [ "useful" ] ],
    [117, "Dapper Vest",                 "sweatervest",                           [ "useful" ] ],
    [118, "Breezy Vest",                 "trunkvest_summer",                      [ "useful" ] ],
    [119, "Puffy Vest",                  "trunkvest_winter",                      [ "useful" ] ],
    [120, "Summer Frest",                "reflectivevest",                        [ "useful", "summer" ] ],
    [121, "Floral Shirt",                "hawaiianshirt",                         [ "useful", "summer" ] ],
    [122, "Walking Cane",                "cane",                                  [ "useful", "winter" ] ],
    [123, "Hibearnation Vest",           "beargervest",                           [ "useful" ] ],
    [124, "Eyebrella",                   "eyebrellahat",                          [ "useful" ] ],
    [125, "Funcaps",                     "red_mushroomhat",                       [ "filler", "bundle" ] ],
    [126, "Green Funcap",                "green_mushroomhat",                     [ "filler", "deprecated" ] ],
    [127, "Blue Funcap",                 "blue_mushroomhat",                      [ "filler", "deprecated" ] ],
    [128, "Polly Roger's Hat",           "polly_rogershat",                       [ "useful", "ocean" ] ],
    [129, "Chest",                       "treasurechest",                         [ "useful" ] ],
    [130, "Scaled Chest",                "dragonflychest",                        [ "useful" ] ],
    [131, "Ice Box",                     "icebox",                                [ "useful" ] ],
    [132, "Salt Box",                    "saltbox",                               [ "useful", "ocean" ] ],
    [133, "Thermal Measurer",            "winterometer",                          [ "filler" ] ],
    [134, "Rainometer",                  "rainometer",                            [ "filler" ] ],
    [135, "Lightning Rod",               "lightning_rod",                         [ "useful" ] ],
    [136, "Ice Flingomatic",             "firesuppressor",                        [ "useful" ] ],
    [137, "Moon Dial",                   "moondial",                              [ "filler" ] ],
    [138, "Punching Bag",                "punchingbag",                           [ "useful", "bundle" ] ],
    [139, "Bright Boxer",                "punchingbag_lunar",                     [ "filler", "deprecated" ] ],
    [140, "Shadow Boxer",                "punchingbag_shadow",                    [ "filler", "deprecated" ] ],
    [141, "Pillar Scaffold",             "support_pillar_scaffold",               [ "filler", "cave" ] ],
    [142, "Dreadstone Pillar Scaffold",  "support_pillar_dreadstone_scaffold",    [ "filler", "ruins" ] ],
    [143, "Tent",                        "tent",                                  [ "useful" ] ],
    [144, "Siesta Lean-to",              "siestahut",                             [ "useful" ] ],
    [145, "Meat Effigy",                 "resurrectionstatue",                    [ "useful" ] ],
    [146, "Pig House",                   "pighouse",                              [ "useful" ] ],
    [147, "Rabbit Hutch",                "rabbithouse",                           [ "useful", "cave" ] ],
    [148, "Salt Lick",                   "saltlick",                              [ "useful", "bundle" ] ],
    [149, "The Lazy Deserter",           "townportal",                            [ "useful" ] ],
    [150, "Turf-Raiser Helm",            "antlionhat",                            [ "useful" ] ],
    [151, "Friendly Scarecrow",          "scarecrow",                             [ "useful" ] ],
    [152, "Mannequin",                   "sewing_mannequin",                      [ "filler" ] ],
    [153, "End Table",                   "endtable",                              [ "filler" ] ],
    [154, "Incomplete Experiment",       "moon_device_construction1",             [ "useful", "moonstorm" ] ],
    [155, "Wood Gate and Fence",         "fence_gate_item",                       [ "useful", "bundle" ] ],
    [156, "Wood Fence",                  "fence_item",                            [ "filler", "deprecated" ] ],
    [157, "Hay Wall",                    "wall_hay_item",                         [ "useful" ] ],
    [158, "Wood Wall",                   "wall_wood_item",                        [ "useful" ] ],
    [159, "Stone Wall",                  "wall_stone_item",                       [ "useful" ] ],
    [160, "Moon Rock Wall",              "wall_moonrock_item",                    [ "filler" ] ],
    [161, "Dreadstone Wall",             "wall_dreadstone_item",                  [ "filler", "cave" ] ],
    [162, "Fencing Sword",               "fence_rotator",                         [ "filler" ] ],
    [163, "Pinchin' Winch",              "winch",                                 [ "useful", "ocean" ] ],
    [164, "Cannon Kit",                  "boat_cannon_kit",                       [ "useful", "bundle", "ocean" ] ],
    [165, "Cannonball",                  "cannonball_rock_item",                  [ "useful", "deprecated", "ocean" ] ],
    [166, "Dock Kit",                    "dock_kit",                              [ "useful", "bundle", "ocean" ] ],
    [167, "Dock Piling",                 "dock_woodposts_item",                   [ "filler", "deprecated", "ocean" ] ],
    [168, "Moon Quay Pirate Banner",     "pirate_flag_pole",                      [ "filler", "ocean" ] ],
    [169, "Freshwater Fishing Rod",      "fishingrod",                            [ "useful" ] ],
    [170, "Sea Fishing Rod",             "oceanfishingrod",                       [ "useful" ] ],
    [171, "Pocket Scale",                "pocket_scale",                          [ "filler" ] ],
    [172, "Crabby Hermit's Lures",       "oceanfishinglure_hermit_rain",          [ "filler", "bundle", "ocean" ] ],
    [173, "Snow Day Lure",               "oceanfishinglure_hermit_snow",          [ "filler", "deprecated" ] ],
    [174, "Stupefying Lure",             "oceanfishinglure_hermit_drowsy",        [ "filler", "deprecated" ] ],
    [175, "Heavy Weighted Lure",         "oceanfishinglure_hermit_heavy",         [ "filler", "deprecated" ] ],
    [176, "Sign",                        "homesign",                              [ "useful", "bundle" ] ],
    [177, "Directional Sign",            "arrowsign_post",                        [ "filler", "deprecated" ] ],
    [178, "Mini Sign",                   "minisign_item",                         [ "filler", "deprecated" ] ],
    [179, "Life Giving Amulet",          "amulet",                                [ "useful" ] ],
    [180, "Chilled Amulet",              "blueamulet",                            [ "useful" ] ],
    [181, "Nightmare Amulet",            "purpleamulet",                          [ "useful" ] ],
    [182, "Telelocator Staff",           "telestaff",                             [ "useful", "bundle" ] ],
    [183, "Telelocator Focus",           "telebase",                              [ "useful", "deprecated" ] ],
    [184, "Beefalo Bell",                "beef_bell",                             [ "useful" ] ],
    [185, "Saddlehorn",                  "saddlehorn",                            [ "useful" ] ],
    [186, "Saddle",                      "saddle_basic",                          [ "useful" ] ],
    [187, "War Saddle",                  "saddle_war",                            [ "useful" ] ],
    [188, "Glossamer Saddle",            "saddle_race",                           [ "useful" ] ],
    [189, "Brush",                       "brush",                                 [ "filler" ] ],
    [190, "Scrap Wall",                  "wall_scrap_item",                       [ "filler" ] ],
    [191, "Auto-Mat-O-Chanic",           "wagpunkbits_kit",                       [ "useful" ] ],
    [192, "Dreadstone Armor Set",        "armordreadstone",                       [ "useful", "bundle", "cave" ] ],
    [193, "Dreadstone Helm",             "dreadstonehat",                         [ "useful", "deprecated", "cave" ] ],
    # [194, "UNUSED",                      "",                                      [ "filler" ] ],
    # [195, "UNUSED",                      "",                                      [ "filler" ] ],
    # [196, "UNUSED",                      "",                                      [ "filler" ] ],
    # [197, "UNUSED",                      "",                                      [ "filler" ] ],
    [198, "Boat Kit",                    "boat_item",                             [ "useful", "ocean" ] ],
    [199, "Anchor Kit",                  "anchor_item",                           [ "useful", "ocean" ] ],
    [200, "Steering Wheel Kit",          "steeringwheel_item",                    [ "useful", "ocean" ] ],
    [201, "Mast Kit",                    "mast_item",                             [ "useful", "ocean" ] ],
    [202, "Winged Sail Kit",             "mast_malbatross_item",                  [ "useful", "ocean" ] ],
    [203, "Tin Fishin' Bin",             "fish_box",                              [ "useful", "ocean" ] ],
    [204, "Deck Illuminator",            "mastupgrade_lamp_item",                 [ "filler", "ocean" ] ],
    [205, "Lightning Conductor",         "mastupgrade_lightningrod_item",         [ "useful", "ocean" ] ],
    [206, "Fire Pump",                   "waterpump",                             [ "filler", "ocean" ] ],
    [207, "Rudder Kit",                  "boat_rotator_kit",                      [ "useful", "ocean" ] ],
    [208, "Shell Bumper Kit",            "boat_bumper_shell_kit",                 [ "useful", "ocean" ] ],
    [209, "Ocean Trawler Kit",           "ocean_trawler_kit",                     [ "useful", "ocean" ] ],
    [210, "Nautopilot Kit",              "boat_magnet_kit",                       [ "useful", "bundle", "ocean" ] ],
    [211, "Nautopilot Beacon",           "boat_magnet_beacon",                    [ "useful", "deprecated", "ocean" ] ],
    [212, "Slimy Salve",                 "healingsalve_acid",                     [ "useful", "cave" ] ],
    [213, "Floorings",                   "floorings",                             [ "useful", "bundle" ] ],
    [214, "Replica Relics",              "replicarelics",                         [ "filler", "bundle", "ruins" ] ],

    # Not shuffled
    # [000, "Cartographer's Desk",         "cartographydesk",                       [ "useful" ] ],
    # [000, "Cookbook",                    "cookbook",                              [ "filler" ] ],
    # [000, "Wardrobe",                    "wardrobe",                              [ "filler" ] ],
    # [000, "Beefalo Grooming Station",    "beefalo_groomer",                       [ "filler" ] ],
    # [000, "Fish Scale-O-Matic",          "trophyscale_fish",                      [ "filler" ] ],
    # [000, "Produce Scale",               "trophyscale_oversizedveggies",          [ "filler" ] ],
    # [000, "Potted Fern",                 "pottedfern",                            [ "filler" ] ],
    # [000, "Potted Succulent",            "succulent_potted",                      [ "filler" ] ],

    # No-Unlock Recipes (401-450)
    [401, "Moon Rock Idol",              "moonrockidol",                              [ "nounlock", "useful" ],                    [ "MAGIC" ] ],
    [402, "Portal Paraphernalia",        "multiplayer_portal_moonrock_constr_plans",  [ "nounlock", "useful" ],                    [ "STRUCTURES" ] ],
    [403, "Lunar Funcap",                "moon_mushroomhat",                          [ "nounlock", "filler", "cave" ],            [ "CLOTHING", "SUMMER" ] ],
    [404, "Moon Glass Axe",              "moonglassaxe",                              [ "nounlock", "useful", "cave", "ocean" ],   [ "TOOLS" ] ],
    [405, "Glass Cutter",                "glasscutter",                               [ "nounlock", "useful", "cave", "ocean" ],   [ "WEAPONS" ] ],
    [406, "Bath Bomb",                   "bathbomb",                                  [ "nounlock", "useful", "ocean" ],           [ "REFINE" ] ],
    [407, "Thulecite",                   "thulecite",                                 [ "nounlock", "useful", "cave", "ocean" ],   [ "REFINE" ] ],
    [408, "Thulecite Wall",              "wall_ruins_item",                           [ "nounlock", "useful", "cave", "ocean" ],   [ "STRUCTURES", "DECOR" ] ],
    [409, "Thulecite Medallion",         "nightmare_timepiece",                       [ "nounlock", "useful", "ruins" ],           [ "MAGIC" ] ],
    [410, "The Lazy Forager",            "orangeamulet",                              [ "nounlock", "useful", "cave", "ocean" ],   [ "MAGIC" ] ],
    [411, "Magiluminescence",            "yellowamulet",                              [ "nounlock", "useful", "cave", "ocean" ],   [ "MAGIC", "LIGHT" ] ],
    [412, "Construction Amulet",         "greenamulet",                               [ "nounlock", "useful", "cave", "ocean" ],   [ "MAGIC" ] ],
    [413, "The Lazy Explorer",           "orangestaff",                               [ "nounlock", "useful" ],                    [ "MAGIC", "CLOTHING" ] ],
    [414, "Star Caller's Staff",         "yellowstaff",                               [ "nounlock", "useful" ],                    [ "MAGIC", "LIGHT" ] ],
    [415, "Deconstruction Staff",        "greenstaff",                                [ "nounlock", "useful" ],                    [ "MAGIC" ] ],
    [416, "Pick/Axe",                    "multitool_axe_pickaxe",                     [ "nounlock", "useful", "cave", "ocean" ],   [ "TOOLS" ] ],
    [417, "Premier Gardeneer Hat",       "nutrientsgoggleshat",                       [ "nounlock", "filler", "cave", "ocean" ],   [ "GARDENING", "SUMMER" ] ],
    [418, "Thulecite Crown",             "ruinshat",                                  [ "nounlock", "useful", "cave", "ocean" ],   [ "MAGIC", "ARMOUR" ] ],
    [419, "Thulecite Suit",              "armorruins",                                [ "nounlock", "useful", "cave", "ocean" ],   [ "MAGIC", "ARMOUR" ] ],
    [420, "Thulecite Club",              "ruins_bat",                                 [ "nounlock", "useful", "cave", "ocean" ],   [ "MAGIC", "WEAPONS" ] ],
    [421, "Houndius Shootius",           "eyeturret_item",                            [ "nounlock", "useful", "ruins" ],           [ "MAGIC", "WEAPONS" ] ],

    # Starting Recipes (451-500)
    [451, "Axe",                         "axe",                                   [ "basic", "progression" ] ],
    [452, "Pickaxe",                     "pickaxe",                               [ "basic", "progression" ] ],
    [453, "Hammer",                      "hammer",                                [ "basic", "progression" ] ],
    [454, "Flare",                       "miniflare",                             [ "basic", "progression" ] ],
    [455, "Hostile Flare",               "megaflare",                             [ "basic", "progression" ] ],
    [456, "Compass",                     "compass",                               [ "basic", "useful" ] ],
    [457, "Telltale Heart",              "reviver",                               [ "basic", "progression" ] ],
    [458, "Torch",                       "torch",                                 [ "basic", "progression" ] ],
    [459, "Campfire",                    "campfire",                              [ "basic", "progression" ] ],
    [460, "Fire Pit",                    "firepit",                               [ "basic", "progression" ] ],
    [461, "Trap",                        "trap",                                  [ "basic", "progression" ] ],
    [462, "Grass Suit",                  "armorgrass",                            [ "basic", "progression" ] ],
    [463, "Whirly Fan",                  "minifan",                               [ "basic", "progression" ] ],
    [464, "Pretty Parasol",              "grass_umbrella",                        [ "basic", "progression" ] ],
    [465, "Garland",                     "flowerhat",                             [ "basic", "useful" ] ],
    [466, "Straw Hat",                   "strawhat",                              [ "basic", "progression" ] ],
    [467, "Rabbit Earmuffs",             "earmuffshat",                           [ "basic", "progression" ] ],
    [468, "Seawreath",                   "kelphat",                               [ "basic", "useful", "ocean" ] ],
    [469, "Grass Raft Kit",              "boat_grass_item",                       [ "basic", "progression", "ocean" ] ],
    [470, "Boat Patch",                  "boatpatch",                             [ "basic", "progression", "ocean" ] ],
    [471, "Oar",                         "oar",                                   [ "basic", "progression", "ocean" ] ],
    [472, "Driftwood Oar",               "oar_driftwood",                         [ "basic", "progression", "ocean" ] ],
    [473, "Kelp Bumper Kit",             "boat_bumper_kelp_kit",                  [ "basic", "useful", "ocean" ] ],
    [474, "Kelp Patch",                  "boatpatch_kelp",                        [ "basic", "useful", "ocean" ] ],

    # Physical Items (501 - 600)
    [501, "Deerclops Eyeball",           "deerclops_eyeball",                     [ "physical", "filler" ] ],
    [502, "Thick Fur (Item)",            "bearger_fur",                           [ "physical", "filler", "deprecated" ] ],
    [503, "Scales",                      "dragon_scales",                         [ "physical", "filler" ] ],
    [504, "Shroom Skin",                 "shroom_skin",                           [ "physical", "filler", "cave" ] ],
    [505, "Bee Queen Crown",             "hivehat",                               [ "physical", "filler" ] ],
    [506, "Malbatross Feather",          "malbatross_feather",                    [ "physical", "filler", "ocean" ], 12],
    [507, "Down Feather",                "goose_feather",                         [ "physical", "filler" ], 5],
    [508, "Eye Mask",                    "eyemaskhat",                            [ "physical", "filler" ] ],
    [509, "Shield of Terror",            "shieldofterror",                        [ "physical", "filler" ] ],
    [510, "Iridescent Gem",              "opalpreciousgem",                       [ "physical", "useful", "archive" ] ],
    [511, "Krampus Sack",                "krampus_sack",                          [ "physical", "useful" ] ],
    [512, "Bishop Figure Sketch",        "chesspiece_bishop_sketch",              [ "physical", "chesspiecesketch", "useful", "abstract" ] ],
    [513, "Rook Figure Sketch",          "chesspiece_rook_sketch",                [ "physical", "chesspiecesketch", "useful", "abstract" ] ],
    [514, "Knight Figure Sketch",        "chesspiece_knight_sketch",              [ "physical", "chesspiecesketch", "useful", "abstract" ] ],

    # Junk (601 - 650)
    [601, "20 Health",                   "",                                      [ "junk", "filler" ] ],
    [602, "15 Sanity",                   "",                                      [ "junk", "filler" ] ],
    [603, "25 Food",                     "",                                      [ "junk", "filler" ] ],
    [604, "60 Health",                   "",                                      [ "junk", "filler" ] ],
    [605, "50 Sanity",                   "",                                      [ "junk", "filler" ] ],
    [606, "75 Food",                     "",                                      [ "junk", "filler" ] ],

    # Traps (651 - 700)
    [651, "Ice Trap",                    "",                                      [ "trap" ] ],
    [652, "Drop Item",                   "",                                      [ "trap", "deprecated" ] ],
    [653, "Slurper Trap",                "",                                      [ "trap" ] ],
    [654, "Spore Trap",                  "",                                      [ "trap" ] ],
    [655, "Boomerang Trap",              "",                                      [ "trap" ] ],
    [656, "Bee Trap",                    "",                                      [ "trap" ] ],
    [657, "Autumn Trap",                 "",                                      [ "trap", "seasontrap", "autumn" ] ],
    [658, "Winter Trap",                 "",                                      [ "trap", "seasontrap", "winter" ] ],
    [659, "Spring Trap",                 "",                                      [ "trap", "seasontrap", "spring" ] ],
    [660, "Summer Trap",                 "",                                      [ "trap", "seasontrap", "summer" ] ],

    # Other (701 - 750)
    [701, "Autumn",                      "dstap_seasonchange_autumn",             [ "seasonhelper", "useful", "autumn" ] ],
    [702, "Winter",                      "dstap_seasonchange_winter",             [ "seasonhelper", "useful", "winter" ] ],
    [703, "Spring",                      "dstap_seasonchange_spring",             [ "seasonhelper", "useful", "spring" ] ],
    [704, "Summer",                      "dstap_seasonchange_summer",             [ "seasonhelper", "useful", "summer" ] ],
    [705, "Full Moon Phase Change",      "dstap_moonphasechange_full",            [ "seasonhelper", "useful", "night" ] ],
    [706, "New Moon Phase Change",       "dstap_moonphasechange_new",             [ "seasonhelper", "useful", "night" ] ],
    [707, "Extra Damage Against Bosses", "extrabossdamage",                       [ "abstract", "useful", "progressive" ] ],
    [708, "Boss Defeat",                 "bossdefeat",                            [ "dummy", "nonshuffled" ] ],
    [709, "Damage Bonus",                "damagebonus",                           [ "abstract", "useful", "progressive" ] ],

    # Seeds (751-800)
    [751,   "Asparagus Seeds",           "dstap_asparagus_seeds",             [ "seeds", "useful" ] ],
    [752,   "Garlic Seeds",              "dstap_garlic_seeds",                [ "seeds", "useful" ] ],
    [753,   "Pumpkin Seeds",             "dstap_pumpkin_seeds",               [ "seeds", "useful" ] ],
    [754,   "Corn Seeds",                "dstap_corn_seeds",                  [ "seeds", "useful" ] ],
    [755,   "Onion Seeds",               "dstap_onion_seeds",                 [ "seeds", "useful" ] ],
    [756,   "Potato Seeds",              "dstap_potato_seeds",                [ "seeds", "useful" ] ],
    [757,   "Dragon Fruit Seeds",        "dstap_dragonfruit_seeds",           [ "seeds", "useful" ] ],
    [758,   "Pomegranate Seeds",         "dstap_pomegranate_seeds",           [ "seeds", "useful" ] ],
    [759,   "Eggplant Seeds",            "dstap_eggplant_seeds",              [ "seeds", "useful" ] ],
    [760,   "Toma Root Seeds",           "dstap_tomato_seeds",                [ "seeds", "useful" ] ],
    [761,   "Watermelon Seeds",          "dstap_watermelon_seeds",            [ "seeds", "useful" ] ],
    [762,   "Pepper Seeds",              "dstap_pepper_seeds",                [ "seeds", "useful" ] ],
    [763,   "Durian Seeds",              "dstap_durian_seeds",                [ "seeds", "useful" ] ],
    [764,   "Carrot Seeds",              "dstap_carrot_seeds",                [ "seeds", "useful" ] ],
]

DSTAP_LOCATIONS = [
    # Misc (1-100)
    [1,     "Distilled Knowledge (Yellow)",     "",                     [ "task", "archive" ] ],
    [2,     "Distilled Knowledge (Blue)",       "",                     [ "task", "archive", "priority_celestial_boss" ] ],
    [3,     "Distilled Knowledge (Red)",        "",                     [ "task", "archive" ] ],
    [4,     "Wagstaff during Moonstorm",        "",                     [ "task", "moonstorm", "priority_celestial_boss", "peaceful" ] ],
    [5,     "Queen of Moon Quay",               "",                     [ "task", "moonquay", "peaceful" ] ],
    [6,     "Pig King",                         "",                     [ "task", "priority", "day", "dusk" ] ],
    [7,     "Chester",                          "chester_eyebone",      [ "item", "priority", "peaceful"  ] ],
    [8,     "Hutch",                            "hutch_fishbowl",       [ "item", "cave", "priority", "peaceful" ] ],
    [9,     "Stagehand",                        "",                     [ "task", "advanced", "peaceful" ] ],
    [10,    "Pirate Stash",                     "",                     [ "task", "advanced", "moonquay" ] ],
    [11,    "Moon Stone Event",                 "opalstaff",            [ "item", "ruins", "nounlock", "night", "seasons_passed_half", "priority_celestial_boss", "special_ruinsgems" ] ],
    [12,    "Oasis",                            "wetpouch",             [ "item", "seasonal", "summer", "priority_antlion_boss", "peaceful" ] ],
    [13,    "Poison Birchnut Tree",             "",                     [ "task", "creature", "seasonal", "autumn", "rng", "seasons_passed_4" ] ],
    [14,    "W.O.B.O.T.",                       "",                     [ "task", "peaceful" ] ],
    [15,    "Friendly Fruit Fly",               "fruitflyfruit",        [ "item", "rng", "peaceful", "seasons_passed_2", "boss" ] ],

    # Normal dishes (101-200)
    [101,   "Butter Muffin",            "butterflymuffin",          [ "cooking", "veggie", "special_buttermuffin" ] ],
    [102,   "Froggle Bunwich",          "frogglebunwich",           [ "cooking", "meat", "nonwinter", "day" ] ],
    [103,   "Taffy",                    "taffy",                    [ "cooking", "goodies" ] ],
    [104,   "Pumpkin Cookies",          "pumpkincookie",            [ "cooking", "veggie", "autumn", "winter", "seasons_passed_1" ] ],
    [105,   "Stuffed Eggplant",         "stuffedeggplant",          [ "cooking", "veggie", "spring", "autumn", "seasons_passed_1" ] ],
    [106,   "Fishsticks",               "fishsticks",               [ "cooking", "meat" ] ],
    [107,   "Honey Nuggets",            "honeynuggets",             [ "cooking", "meat" ] ],
    [108,   "Honey Ham",                "honeyham",                 [ "cooking", "meat" ] ],
    [109,   "Dragonpie",                "dragonpie",                [ "cooking", "veggie", "spring", "summer", "seasons_passed_1" ] ],
    [110,   "Kabobs",                   "kabobs",                   [ "cooking", "meat" ] ],
    [111,   "Mandrake Soup",            "mandrakesoup",             [ "cooking", "veggie" ] ],
    [112,   "Bacon and Eggs",           "baconeggs",                [ "cooking", "meat" ] ],
    [113,   "Meatballs",                "meatballs",                [ "cooking", "meat" ] ],
    [114,   "Meaty Stew",               "bonestew",                 [ "cooking", "meat" ] ],
    [115,   "Pierogi",                  "perogies",                 [ "cooking", "meat" ] ],
    [116,   "Turkey Dinner",            "turkeydinner",             [ "cooking", "meat" ] ],
    [117,   "Ratatouille",              "ratatouille",              [ "cooking", "veggie" ] ],
    [118,   "Fist Full of Jam",         "jammypreserves",           [ "cooking", "veggie" ] ],
    [119,   "Fruit Medley",             "fruitmedley",              [ "cooking", "veggie", "special_fruits" ] ],
    [120,   "Fish Tacos",               "fishtacos",                [ "cooking", "meat", "special_corn" ] ],
    [121,   "Waffles",                  "waffles",                  [ "cooking", "veggie", "rng", "day", "nonwinter" ] ],
    [122,   "Monster Lasagna",          "monsterlasagna",           [ "cooking", "meat" ] ],
    [123,   "Powdercake",               "powcake",                  [ "cooking", "veggie", "special_corn" ] ],
    [124,   "Unagi",                    "unagi",                    [ "cooking", "meat", "ruins" ] ],
    [125,   "Wet Goop",                 "wetgoop",                  [ "cooking", "other" ] ],
    [126,   "Flower Salad",             "flowersalad",              [ "cooking", "veggie", "seasonal", "summer" ] ],
    [127,   "Ice Cream",                "icecream",                 [ "cooking", "goodies", "nonsummer" ] ],
    [128,   "Melonsicle",               "watermelonicle",           [ "cooking", "veggie", "spring", "seasons_passed_1" ] ],
    [129,   "Trail Mix",                "trailmix",                 [ "cooking", "veggie", "nonwinter" ] ],
    [130,   "Spicy Chili",              "hotchili",                 [ "cooking", "meat" ] ],
    [131,   "Guacamole",                "guacamole",                [ "cooking", "meat" ] ],
    [132,   "Jellybeans",               "jellybean",                [ "cooking", "goodies", "raidboss"] ],
    [133,   "Fancy Spiralled Tubers",   "potatotornado",            [ "cooking", "veggie", "nonsummer", "seasons_passed_1" ] ],
    [134,   "Creamy Potato Purée",      "mashedpotatoes",           [ "cooking", "veggie", "nonsummer", "seasons_passed_1" ] ],
    [135,   "Asparagus Soup",           "asparagussoup",            [ "cooking", "veggie", "winter", "spring", "seasons_passed_1" ] ],
    [136,   "Vegetable Stinger",        "vegstinger",               [ "cooking", "veggie", "nonsummer", "seasons_passed_1" ] ],
    [137,   "Banana Pop",               "bananapop",                [ "cooking", "veggie", "dualregion", "nonsummer", "special_banana" ] ],
    [138,   "Frozen Banana Daiquiri",   "frozenbananadaiquiri",     [ "cooking", "goodies", "dualregion", "nonsummer", "special_banana" ] ],
    [139,   "Banana Shake",             "bananajuice",              [ "cooking", "veggie", "dualregion", "special_banana" ] ],
    [140,   "Ceviche",                  "ceviche",                  [ "cooking", "meat", "dualregion", "nonsummer" ] ],
    [141,   "Salsa Fresca",             "salsa",                    [ "cooking", "veggie", "nonwinter", "seasons_passed_1" ] ],
    [142,   "Stuffed Pepper Poppers",   "pepperpopper",             [ "cooking", "meat", "autumn", "summer", "seasons_passed_1" ] ],
    [143,   "California Roll",          "californiaroll",           [ "cooking", "meat", "ocean" ] ],
    [144,   "Seafood Gumbo",            "seafoodgumbo",             [ "cooking", "meat", "cave" ] ],
    [145,   "Surf 'n' Turf",            "surfnturf",                [ "cooking", "meat" ] ],
    [146,   "Lobster Bisque",           "lobsterbisque",            [ "cooking", "meat", "ocean", "dusk", "night", "nonsummer" ] ],
    [147,   "Lobster Dinner",           "lobsterdinner",            [ "cooking", "meat", "ocean", "rng", "nonwinter", "special_lobsterdinner" ] ],
    [148,   "Barnacle Pita",            "barnaclepita",             [ "cooking", "meat", "ocean" ] ],
    [149,   "Barnacle Nigiri",          "barnaclesushi",            [ "cooking", "meat", "ocean" ] ],
    [150,   "Barnacle Linguine",        "barnaclinguine",           [ "cooking", "meat", "ocean" ] ],
    [151,   "Stuffed Fish Heads",       "barnaclestuffedfishhead",  [ "cooking", "meat", "ocean" ] ],
    [152,   "Leafy Meatloaf",           "leafloaf",                 [ "cooking", "meat", "special_leafymeat" ] ],
    [153,   "Veggie Burger",            "leafymeatburger",          [ "cooking", "meat", "nonwinter", "special_leafymeat", "seasons_passed_1" ] ],
    [154,   "Jelly Salad",              "leafymeatsouffle",         [ "cooking", "meat", "special_leafymeat" ] ],
    [155,   "Beefy Greens",             "meatysalad",               [ "cooking", "meat", "special_leafymeat" ] ],
    [156,   "Mushy Cake",               "shroomcake",               [ "cooking", "cave" ] ],
    [157,   "Soothing Tea",             "sweettea",                 [ "cooking", "veggie", "nonsummer" ] ],
    [158,   "Fig-Stuffed Trunk",        "koalefig_trunk",           [ "cooking", "meat", "ocean" ] ],
    [159,   "Figatoni",                 "figatoni",                 [ "cooking", "veggie", "ocean" ] ],
    [160,   "Figkabab",                 "figkabab",                 [ "cooking", "meat", "ocean" ] ],
    [161,   "Figgy Frogwich",           "frognewton",               [ "cooking", "meat", "ocean", "nonwinter", "day" ] ],
    [162,   "Bunny Stew",               "bunnystew",                [ "cooking", "meat", "nonsummer" ] ],
    [163,   "Plain Omelette",           "justeggs",                 [ "cooking", "meat" ] ],
    [164,   "Breakfast Skillet",        "veggieomlet",              [ "cooking", "meat", "day", "dusk" ] ],
    [165,   "Tall Scotch Eggs",         "talleggs",                 [ "cooking", "meat" ] ],
    [166,   "Steamed Twigs",            "beefalofeed",              [ "cooking", "other" ] ],
    [167,   "Beefalo Treats",           "beefalotreat",             [ "cooking", "other", "nonwinter" ] ],
    [168,   "Milkmade Hat",             "batnosehat",               [ "cooking", "goodies", "bothregions" ] ],
    [169,   "Amberosia",                "dustmeringue",             [ "cooking", "other", "ocean" ] ],
    [170,   "Stuffed Night Cap",        "shroombait",               [ "cooking", "meat", "cave" ] ],

    # Warly-exclusive dishes (201-250)
    [201,   "Grim Galette",             "nightmarepie",             [ "cooking", "warly", "autumn", "spring", "seasons_passed_1" ] ],
    [202,   "Volt Goat Chaud-Froid",    "voltgoatjelly",            [ "cooking", "warly", "rng" ] ],
    [203,   "Glow Berry Mousse",        "glowberrymousse",          [ "cooking", "warly", "cave" ] ],
    [204,   "Fish Cordon Bleu",         "frogfishbowl",             [ "cooking", "warly", "nonwinter" ] ],
    [205,   "Hot Dragon Chili Salad",   "dragonchilisalad",         [ "cooking", "warly", "summer", "seasons_passed_1" ] ],
    [206,   "Asparagazpacho",           "gazpacho",                 [ "cooking", "warly", "winter", "spring", "seasons_passed_1" ] ],
    [207,   "Puffed Potato Soufflé",    "potatosouffle",            [ "cooking", "warly", "nonsummer", "seasons_passed_1" ] ],
    [208,   "Monster Tartare",          "monstertartare",           [ "cooking", "warly" ] ],
    [209,   "Fresh Fruit Crepes",       "freshfruitcrepes",         [ "cooking", "warly", "rng", "special_fruits" ] ],
    [210,   "Bone Bouillon",            "bonesoup",                 [ "cooking", "warly", "nonwinter", "seasons_passed_1" ] ],
    [211,   "Moqueca",                  "moqueca",                  [ "cooking", "warly", "nonwinter", "seasons_passed_1" ] ],

    # Bosses (251-300)
    [251,   "Antlion",                  "antlion",                  [ "boss", "seasonal", "summer", "peaceful" ] ],
    [252,   "Bearger",                  "bearger",                  [ "boss", "seasonal", "autumn", "seasons_passed_2" ] ],
    [253,   "Deerclops",                "deerclops",                [ "boss", "seasonal", "winter", "seasons_passed_1" ] ],
    [254,   "Lord of the Fruit Flies",  "lordfruitfly",             [ "boss", "rng", "seasons_passed_2" ] ],
    [255,   "Treeguard",                "leif",                     [ "boss", "rng" ] ],
    [256,   "Malbatross",               "malbatross",               [ "boss", "ocean" ] ],
    [257,   "Spider Queen",             "spiderqueen",              [ "boss", "seasons_passed_2" ] ],
    [258,   "Varg",                     "warg",                     [ "boss", "rng", "seasons_passed_4" ] ],
    [259,   "Eye Of Terror",            "eyeofterror",              [ "boss", "night" ] ],
    [260,   "Moose/Goose",              "moose",                    [ "boss", "seasonal", "spring", "seasons_passed_2", "special_moosegoose" ] ],
    [261,   "Shadow Bishop",            "shadow_bishop",            [ "boss", "raidboss", "priority_fuelweaver_boss", "night", "seasons_passed_1" ] ],
    [262,   "Shadow Knight",            "shadow_knight",            [ "boss", "raidboss", "priority_fuelweaver_boss", "night", "seasons_passed_1" ] ],
    [263,   "Shadow Rook",              "shadow_rook",              [ "boss", "raidboss", "priority_fuelweaver_boss", "night", "seasons_passed_1" ] ],
    [264,   "Celestial Champion",       "alterguardian_phase3",     [ "boss", "raidboss", "moonstorm" ] ],
    [265,   "Bee Queen",                "beequeen",                 [ "boss", "raidboss" ] ],
    [266,   "Nightmare Werepig",        "daywalker",                [ "boss", "ruins", "priority_scrappywerepig_boss" ] ],
    [267,   "Scrappy Werepig",          "daywalker2",               [ "boss", "ruins" ] ],
    [268,   "Dragonfly",                "dragonfly",                [ "boss", "raidboss" ] ],
    [269,   "Klaus",                    "klaus",                    [ "boss", "raidboss", "seasonal", "winter", "seasons_passed_1" ] ],
    [270,   "Frostjaw",                 "sharkboi",                 [ "boss", "ocean" ] ],
    [271,   "Ancient Fuelweaver",       "stalker_atrium",           [ "boss", "raidboss", "ruins", "night" ] ],
    [272,   "Retinazor",                "twinofterror1",            [ "boss", "raidboss", "night" ] ],
    [273,   "Spazmatism",               "twinofterror2",            [ "boss", "raidboss", "night" ] ],
    [274,   "Toadstool",                "toadstool",                [ "boss", "raidboss", "cave"] ],
    [275,   "Ancient Guardian",         "minotaur",                 [ "boss", "ruins", "priority_fuelweaver_boss" ] ],
    [276,   "Crab King",                "crabking",                 [ "boss", "raidboss", "ocean", "priority_celestial_boss", "special_hermit_10" ] ],

    # Creatures (301-450)
    [301,   "Batilisk",                 "bat",                  [ "creature", "cave" ] ],
    [302,   "Bee",                      "bee",                  [ "creature", "nonwinter", "peaceful", "day" ] ],
    [303,   "Beefalo",                  "beefalo",              [ "creature", "peaceful" ] ],
    [304,   "Clockwork Bishop",         "bishop",               [ "creature", "ruins", "priority" ] ],
    [305,   "Bunnyman",                 "bunnyman",             [ "creature", "cave", "peaceful", "dusk", "night" ] ],
    [306,   "Butterfly",                "butterfly",            [ "creature", "nonwinter", "peaceful", "day" ] ],
    [307,   "Buzzard",                  "buzzard",              [ "creature", "nonwinter", "day", "dusk" ] ],
    [308,   "Canary",                   "canary",               [ "creature", "peaceful", "autumn", "winter", "day", "dusk", "seasons_passed_1" ] ],
    [309,   "Carrat",                   "carrat",               [ "creature", "dualregion", "peaceful" ] ],
    [310,   "Catcoon",                  "catcoon",              [ "creature", "peaceful" ] ],
    [311,   "Cookie Cutter",            "cookiecutter",         [ "creature", "ocean" ] ],
    [312,   "Crawling Horror",          "crawlinghorror",       [ "creature" ] ],
    [313,   "Crow",                     "crow",                 [ "creature", "peaceful", "day", "dusk" ] ],
    [314,   "Red Hound",                "firehound",            [ "creature", "seasonal", "summer", "autumn", "seasons_passed_2" ] ],
    [315,   "Frog",                     "frog",                 [ "creature", "nonwinter", "day" ] ],
    [316,   "Saladmander",              "fruitdragon",          [ "creature", "ocean" ] ],
    [317,   "Ghost",                    "ghost",                [ "creature", "rng" ] ],
    [318,   "Gnarwail",                 "gnarwail",             [ "creature", "ocean", "rng" ] ],
    [319,   "Grass Gator",              "grassgator",           [ "creature", "ocean" ] ],
    [320,   "Grass Gekko",              "grassgekko",           [ "creature", "rng", "nonwinter", "seasons_passed_2" ] ],
    [321,   "Briar Wolf",               "hedgehound",           [ "creature" ] ],
    [322,   "Hound",                    "hound",                [ "creature" ] ],
    [323,   "Blue Hound",               "icehound",             [ "creature", "seasonal", "winter", "spring" ] ],
    [324,   "Killer Bee",               "killerbee",            [ "creature", "peaceful" ] ],
    [325,   "Clockwork Knight",         "knight",               [ "creature", "ruins", "priority" ] ],
    [326,   "Koalefant",                "koalefant_summer",     [ "creature" ] ],
    [327,   "Krampus",                  "krampus",              [ "creature", "seasons_passed_half" ] ],
    [328,   "Crustashine",              "lightcrab",            [ "creature", "ocean", "peaceful" ] ],
    [329,   "Bulbous Lightbug",         "lightflier",           [ "creature", "cave", "peaceful" ] ],
    [330,   "Volt Goat",                "lightninggoat",        [ "creature" ] ],
    [331,   "Merm",                     "merm",                 [ "creature", "rng" ] ],
    [332,   "Moleworm",                 "mole",                 [ "creature", "peaceful" ] ],
    [333,   "Naked Mole Bat",           "molebat",              [ "creature", "cave" ] ],
    [334,   "Splumonkey",               "monkey",               [ "creature", "ruins" ] ],
    [335,   "Moon Moth",                "moonbutterfly",        [ "creature", "ocean", "peaceful" ] ],
    [336,   "Mosquito",                 "mosquito",             [ "creature", "nonwinter", "peaceful", "dusk", "night" ] ],
    [337,   "Mosling",                  "mossling",             [ "creature", "seasonal", "spring", "seasons_passed_2", "special_moosegoose" ] ],
    [338,   "Mush Gnome",               "mushgnome",            [ "creature", "cave" ] ],
    [339,   "Terrorclaw",               "oceanhorror",          [ "creature", "ocean", "deprecated" ] ],
    [340,   "Pengull",                  "penguin",              [ "creature", "seasonal", "winter" ] ],
    [341,   "Gobbler",                  "perd",                 [ "creature", "day" ] ],
    [342,   "Pig Man",                  "pigman",               [ "creature", "peaceful" ] ],
    [343,   "Powder Monkey",            "powder_monkey",        [ "creature", "moonquay" ] ],
    [344,   "Prime Mate",               "prime_mate",           [ "creature", "moonquay" ] ],
    [345,   "Puffin",                   "puffin",               [ "creature", "ocean", "peaceful", "day", "dusk" ] ],
    [346,   "Rabbit",                   "rabbit",               [ "creature", "peaceful" ] ],
    [347,   "Redbird",                  "robin",                [ "creature", "nonwinter", "peaceful", "day", "dusk" ] ],
    [348,   "Snowbird",                 "robin_winter",         [ "creature", "seasonal", "winter" , "peaceful", "day", "dusk" ] ],
    [349,   "Rock Lobster",             "rocky",                [ "creature", "cave", "peaceful" ] ],
    [350,   "Clockwork Rook",           "rook",                 [ "creature", "ruins", "priority" ] ],
    [351,   "Rockjaw",                  "shark",                [ "creature", "ocean", "rng" ] ],
    [352,   "Slurper",                  "slurper",              [ "creature", "ruins" ] ],
    [353,   "Slurtle",                  "slurtle",              [ "creature", "cave" ] ],
    [354,   "Snurtle",                  "snurtle",              [ "creature", "cave", "rng" ] ],
    [355,   "Ewecus",                   "spat",                 [ "creature", "rng", "seasons_passed_4" ] ],
    [356,   "Spider",                   "spider",               [ "creature", "priority", "peaceful" ] ],
    [357,   "Dangling Depth Dweller",   "spider_dropper",       [ "creature", "cave", "peaceful" ] ],
    [358,   "Cave Spider",              "spider_hider",         [ "creature", "cave", "peaceful" ] ],
    [359,   "Nurse Spider",             "spider_healer",        [ "creature", "peaceful", "seasons_passed_2" ] ],
    [360,   "Shattered Spider",         "spider_moon",          [ "creature", "ocean", "peaceful" ] ],
    [361,   "Spitter",                  "spider_spitter",       [ "creature", "cave", "peaceful" ] ],
    [362,   "Spider Warrior",           "spider_warrior",       [ "creature", "priority", "peaceful" ] ],
    [363,   "Sea Strider",              "spider_water",         [ "creature", "ocean", "peaceful" ] ],
    [364,   "Tallbird",                 "tallbird",             [ "creature", "peaceful" ] ],
    [365,   "Tentacle",                 "tentacle",             [ "creature" ] ],
    [366,   "Big Tentacle",             "tentacle_pillar",      [ "creature", "cave" ] ],
    [367,   "Terrorbeak",               "terrorbeak",           [ "creature" ] ],
    [368,   "MacTusk",                  "walrus",               [ "creature", "seasonal", "winter" ] ],
    [369,   "Varglet",                  "warglet",              [ "creature", "rng", "seasons_passed_2" ] ],
    [370,   "Depths Worm",              "worm",                 [ "creature", "ruins", "priority" ] ],
    [371,   "Ancient Sentrypede",       "archive_centipede",    [ "creature", "archive" ] ],
    [372,   "Skittersquid",             "squid",                [ "creature", "ocean", "rng" ] ],
    [373,   "Lure Plant",               "lureplant",            [ "creature", "spring", "rng" ] ],
    [374,   "Glommer",                  "glommer",              [ "creature", "peaceful", "night", "seasonal", "seasons_passed_half" ] ],
    [375,   "Dust Moth",                "dustmoth",             [ "creature", "archive", "peaceful" ] ],
    [376,   "No-Eyed Deer",             "deer",                 [ "creature", "seasonal", "winter", "peaceful", "seasons_passed_1" ] ],
    [377,   "Moonblind Crow",           "bird_mutant",          [ "creature", "moonstorm", "peaceful" ] ],
    [378,   "Misshapen Bird",           "bird_mutant_spitter",  [ "creature", "moonstorm", "peaceful" ] ],
    [379,   "Moonrock Pengull",         "mutated_penguin",      [ "creature", "moonstorm", "seasonal", "winter", "rng" ] ],
    [380,   "Horror Hound",             "mutatedhound",         [ "creature", "moonstorm", "rng" ] ],
    [381,   "Resting Horror",           "ruins_shadeling",      [ "creature", "ruins" ] ],
    [382,   "Birchnutter",              "birchnutdrake",        [ "creature", "seasonal", "autumn", "seasons_passed_4" ] ],
    [383,   "Mandrake",                 "mandrake",             [ "creature", "peaceful" ] ],
    [384,   "Fruit Fly",                "fruitfly",             [ "creature", "seasons_passed_2" ] ],
    [385,   "Sea Weed",                 "waterplant",           [ "creature", "ocean", "peaceful" ] ],
    [386,   "Marotter",                 "otter",                [ "creature", "nonwinter", "day", "dusk" ] ],

    # Farming (451-500); These also decide farm plant seasons rules
    [451,   "Grow Giant Asparagus",         "asparagus_oversized",      [ "farming", "winter", "spring" ] ],
    [452,   "Grow Giant Garlic",            "garlic_oversized",         [ "farming" ] ],
    [453,   "Grow Giant Pumpkin",           "pumpkin_oversized",        [ "farming", "autumn", "winter" ] ],
    [454,   "Grow Giant Corn",              "corn_oversized",           [ "farming", "nonwinter" ] ],
    [455,   "Grow Giant Onion",             "onion_oversized",          [ "farming", "nonwinter" ] ],
    [456,   "Grow Giant Potato",            "potato_oversized",         [ "farming", "nonsummer" ] ],
    [457,   "Grow Giant Dragon Fruit",      "dragonfruit_oversized",    [ "farming", "spring", "summer" ] ],
    [458,   "Grow Giant Pomegranate",       "pomegranate_oversized",    [ "farming", "spring", "summer" ] ],
    [459,   "Grow Giant Eggplant",          "eggplant_oversized",       [ "farming", "autumn", "spring" ] ],
    [460,   "Grow Giant Toma Root",         "tomato_oversized",         [ "farming", "nonwinter" ] ],
    [461,   "Grow Giant Watermelon",        "watermelon_oversized",     [ "farming", "spring", "summer" ] ],
    [462,   "Grow Giant Pepper",            "pepper_oversized",         [ "farming", "autumn", "summer" ] ],
    [463,   "Grow Giant Durian",            "durian_oversized",         [ "farming", "spring" ] ],
    [464,   "Grow Giant Carrot",            "carrot_oversized",         [ "farming", "nonsummer" ] ],

    # Science (501-600)
    [501,   "Science (Nitre)",                  "nitre",                    [ "research", "science", "tier_1" ] ],
    [502,   "Science (Salt Crystals)",          "saltrock",                 [ "research", "science", "tier_2", "ocean" ] ],
    [503,   "Science (Ice)",                    "ice",                      [ "research", "science", "tier_1", "nonsummer" ] ],
    [504,   "Science (Slurtle Slime)",          "slurtleslime",             [ "research", "science", "tier_2", "cave" ] ],
    [505,   "Science (Gears)",                  "gears",                    [ "research", "science", "tier_2" ] ],
    [506,   "Science (Scrap)",                  "wagpunk_bits",             [ "research", "science", "tier_2" ] ],
    [507,   "Science (Azure Feather)",          "feather_robin_winter",     [ "research", "science", "tier_2", "seasonal", "winter", "day", "dusk" ] ],
    [508,   "Science (Crimson Feather)",        "feather_robin",            [ "research", "science", "tier_2", "nonwinter", "day", "dusk" ] ],
    [509,   "Science (Jet Feather)",            "feather_crow",             [ "research", "science", "tier_2", "day", "dusk" ] ],
    [510,   "Science (Saffron Feather)",        "feather_canary",           [ "research", "science", "tier_2", "autumn", "winter", "day", "dusk", "seasons_passed_1" ] ],
    [511,   "Science (Kelp Fronds)",            "kelp",                     [ "research", "science", "tier_1", "veggie_research", "ocean" ] ],
    [512,   "Science (Steel Wool)",             "steelwool",                [ "research", "science", "tier_2", "rng", "seasons_passed_4" ] ],
    [513,   "Science (Electrical Doodad)",      "transistor",               [ "research", "science", "tier_2" ] ],
    [514,   "Science (Ashes)",                  "ash",                      [ "research", "science", "tier_2" ] ],
    [515,   "Science (Cut Grass)",              "cutgrass",                 [ "research", "science", "tier_1" ] ],
    [516,   "Science (Beefalo Horn)",           "horn",                     [ "research", "science", "tier_2", "rng" ] ],
    [517,   "Science (Beefalo Wool)",           "beefalowool",              [ "research", "science", "tier_2" ] ],
    [518,   "Science (Cactus Flower)",          "cactus_flower",            [ "research", "science", "tier_2", "seasonal", "summer" ] ],
    [519,   "Science (Honeycomb)",              "honeycomb",                [ "research", "science", "tier_2" ] ],
    [520,   "Science (Petals)",                 "petals",                   [ "research", "science", "tier_2" ] ],
    [521,   "Science (Succulent)",              "succulent_picked",         [ "research", "science", "tier_2", "seasonal", "summer" ] ],
    [522,   "Science (Foliage)",                "foliage",                  [ "research", "science", "tier_2" ] ],
    [523,   "Science (Tillweeds)",              "tillweed",                 [ "research", "science", "tier_2" ] ],
    [524,   "Science (Lichen)",                 "cutlichen",                [ "research", "science", "tier_1", "veggie_research", "ruins" ] ],
    [525,   "Science (Banana)",                 "cave_banana",              [ "research", "science", "tier_1", "veggie_research", "dualregion", "special_banana" ] ],
    [526,   "Science (Fig)",                    "fig",                      [ "research", "science", "tier_1", "veggie_research", "ocean" ] ],
    [527,   "Science (Tallbird Egg)",           "tallbirdegg",              [ "research", "science", "tier_1" ] ],
    [528,   "Science (Hound's Tooth)",          "houndstooth",              [ "research", "science", "tier_2" ] ],
    [529,   "Science (Bone Shards)",            "boneshard",                [ "research", "science", "tier_2" ] ],
    [530,   "Science (Walrus Tusk)",            "walrus_tusk",              [ "research", "science", "tier_2", "seasonal", "winter", "rng" ] ],
    [531,   "Science (Silk)",                   "silk",                     [ "research", "science", "tier_1" ] ],
    [532,   "Science (Cut Stone)",              "cutstone",                 [ "research", "science", "tier_1" ] ],
    [533,   "Science (Palmcone Sprout)",        "palmcone_seed",            [ "research", "science", "tier_1", "ocean" ] ],
    [534,   "Science (Pine Cone)",              "pinecone",                 [ "research", "science", "tier_1" ] ],
    [535,   "Science (Birchnut)",               "acorn",                    [ "research", "science", "tier_1", "nonwinter" ] ],
    [536,   "Science (Driftwood Piece)",        "driftwood_log",            [ "research", "science", "tier_1", "ocean" ] ],
    [537,   "Science (Cookie Cutter Shell)",    "cookiecuttershell",        [ "research", "science", "tier_2", "ocean" ] ],
    [538,   "Science (Palmcone Scale)",         "palmcone_scale",           [ "research", "science", "tier_2", "ocean" ] ],
    [539,   "Science (Gnarwail Horn)",          "gnarwail_horn",            [ "research", "science", "tier_2", "ocean", "rng" ] ],
    [540,   "Science (Barnacles)",              "barnacle",                 [ "research", "science", "tier_2", "ocean" ] ],
    [541,   "Science (Frazzled Wires)",         "trinket_6",                [ "research", "science", "tier_2" ] ],
    [542,   "Science (Charcoal)",               "charcoal",                 [ "research", "science", "tier_2" ] ],
    [543,   "Science (Butter)",                 "butter",                   [ "research", "science", "tier_2", "rng", "nonwinter", "day" ] ],
    [544,   "Science (Asparagus)",              "asparagus",                [ "research", "science", "tier_1", "veggie_research", "seasons_passed_1", "winter", "spring" ] ],
    [545,   "Science (Garlic)",                 "garlic",                   [ "research", "science", "tier_1", "veggie_research", "seasons_passed_1" ] ],
    [546,   "Science (Pumpkin)",                "pumpkin",                  [ "research", "science", "tier_1", "veggie_research", "seasons_passed_1", "winter", "autumn" ] ],
    [547,   "Science (Corn)",                   "corn",                     [ "research", "science", "tier_1", "veggie_research", "special_corn" ] ],
    [548,   "Science (Onion)",                  "onion",                    [ "research", "science", "tier_1", "veggie_research", "seasons_passed_1", "nonwinter" ] ],
    [549,   "Science (Potato)",                 "potato",                   [ "research", "science", "tier_1", "veggie_research", "seasons_passed_1", "nonsummer" ] ],
    [550,   "Science (Dragon Fruit)",           "dragonfruit",              [ "research", "science", "tier_1", "veggie_research", "seasons_passed_1", "spring", "summer" ] ],
    [551,   "Science (Pomegranate)",            "pomegranate",              [ "research", "science", "tier_1", "veggie_research", "seasons_passed_1", "spring", "summer" ] ],
    [552,   "Science (Eggplant)",               "eggplant",                 [ "research", "science", "tier_1", "veggie_research", "seasons_passed_1", "spring", "autumn" ] ],
    [553,   "Science (Toma Root)",              "tomato",                   [ "research", "science", "tier_1", "veggie_research", "seasons_passed_1", "nonwinter" ] ],
    [554,   "Science (Watermelon)",             "watermelon",               [ "research", "science", "tier_1", "veggie_research", "seasons_passed_1", "spring", "summer" ] ],
    [555,   "Science (Pepper)",                 "pepper",                   [ "research", "science", "tier_1", "veggie_research", "seasons_passed_1", "summer", "autumn" ] ],
    [556,   "Science (Durian)",                 "durian",                   [ "research", "science", "tier_1", "veggie_research", "seasons_passed_1", "spring" ] ],
    [557,   "Science (Carrot)",                 "carrot",                   [ "research", "science", "tier_1", "veggie_research" ] ],
    [558,   "Science (Stone Fruit)",            "rock_avocado_fruit",       [ "research", "science", "tier_1", "veggie_research", "dualregion" ] ],
    [559,   "Science (Marble)",                 "marble",                   [ "research", "science", "tier_1" ] ],
    [560,   "Science (Gold Nugget)",            "goldnugget",               [ "research", "science", "tier_1" ] ],
    [561,   "Science (Flint)",                  "flint",                    [ "research", "science", "tier_1" ] ],
    [562,   "Science (Honey)",                  "honey",                    [ "research", "science", "tier_1" ] ],
    [563,   "Science (Twigs)",                  "twigs",                    [ "research", "science", "tier_1" ] ],
    [564,   "Science (Log)",                    "log",                      [ "research", "science", "tier_1" ] ],
    [565,   "Science (Rocks)",                  "rocks",                    [ "research", "science", "tier_1" ] ],
    [566,   "Science (Light Bulb)",             "lightbulb",                [ "research", "science", "tier_2", "dualregion", "rng" ] ],

    # Magic (601-700)
    [601,   "Magic (Blue Gem)",                 "bluegem",                  [ "research", "magic", "tier_1" ] ],
    [602,   "Magic (Living Log)",               "livinglog",                [ "research", "magic", "tier_2" ] ],
    [603,   "Magic (Glommer's Goop)",           "glommerfuel",              [ "research", "magic", "tier_1", "seasonal", "seasons_passed_half", "night" ] ],
    [604,   "Magic (Dark Petals)",              "petals_evil",              [ "research", "magic", "tier_2" ] ],
    [605,   "Magic (Red Gem)",                  "redgem",                   [ "research", "magic", "tier_2" ] ],
    [606,   "Magic (Slurper Pelt)",             "slurper_pelt",             [ "research", "magic", "tier_2", "ruins" ] ],
    [607,   "Magic (Blue Spore)",               "spore_tall",               [ "research", "magic", "tier_2", "cave", "seasonal", "winter" ] ],
    [608,   "Magic (Red Spore)",                "spore_medium",             [ "research", "magic", "tier_2", "cave", "seasonal", "summer" ] ],
    [609,   "Magic (Green Spore)",              "spore_small",              [ "research", "magic", "tier_2", "cave", "seasonal", "spring" ] ],
    [610,   "Magic (Broken Shell)",             "slurtle_shellpieces",      [ "research", "magic", "tier_2", "cave" ] ],
    [611,   "Magic (Leafy Meat)",               "plantmeat",                [ "research", "magic", "tier_1", "special_leafymeat" ] ],
    [612,   "Magic (Canary (Volatile))",        "canary_poisoned",          [ "research", "magic", "tier_2", "cave", "autumn", "winter", "day", "dusk", "seasons_passed_1" ] ],
    [613,   "Magic (Life Giving Amulet)",       "amulet",                   [ "research", "magic", "tier_2" ] ],
    [614,   "Magic (Nightmare Fuel)",           "nightmarefuel",            [ "research", "magic", "tier_2" ] ],
    [615,   "Magic (Cut Reeds)",                "cutreeds",                 [ "research", "magic", "tier_1" ] ],
    [616,   "Magic (Volt Goat Horn)",           "lightninggoathorn",        [ "research", "magic", "tier_2", "rng" ] ],
    [617,   "Magic (Beard Hair)",               "beardhair",                [ "research", "magic", "tier_2" ] ],
    [618,   "Magic (Glow Berry)",               "wormlight",                [ "research", "magic", "tier_2", "ruins" ] ],
    [619,   "Magic (Tentacle Spots)",           "tentaclespots",            [ "research", "magic", "tier_2", "rng" ] ],
    [620,   "Magic (Health)",                   "health",                   [ "research", "magic", "tier_2" ] ],
    [621,   "Magic (Sanity)",                   "sanity",                   [ "research", "magic", "tier_2" ] ],
    [622,   "Magic (Telltale Heart)",           "reviver",                  [ "research", "magic", "tier_2" ] ],
    [623,   "Magic (Forget-Me-Lots)",           "forgetmelots",             [ "research", "magic", "tier_2" ] ],
    [624,   "Magic (Cat Tail)",                 "coontail",                 [ "research", "magic", "tier_1" ] ],
    [625,   "Magic (Bunny Puff)",               "manrabbit_tail",           [ "research", "magic", "tier_1", "cave" ] ],
    [626,   "Magic (Mosquito Sack)",            "mosquitosack",             [ "research", "magic", "tier_1", "nonwinter", "dusk", "night" ] ],
    [627,   "Magic (Spider Gland)",             "spidergland",              [ "research", "magic", "tier_1" ] ],
    [628,   "Magic (Monster Jerky)",            "monstermeat_dried",        [ "research", "magic", "tier_2" ] ],
    [629,   "Magic (Pig Skin)",                 "pigskin",                  [ "research", "magic", "tier_2" ] ],
    [630,   "Magic (Batilisk Wing)",            "batwing",                  [ "research", "magic", "tier_2", "cave" ] ],
    [631,   "Magic (Stinger)",                  "stinger",                  [ "research", "magic", "tier_1" ] ],
    [632,   "Magic (Papyrus)",                  "papyrus",                  [ "research", "magic", "tier_1" ] ],
    [633,   "Magic (Green Cap)",                "green_cap",                [ "research", "magic", "tier_1" ] ],
    [634,   "Magic (Blue Cap)",                 "blue_cap",                 [ "research", "magic", "tier_1" ] ],
    [635,   "Magic (Red Cap)",                  "red_cap",                  [ "research", "magic", "tier_1" ] ],
    [636,   "Magic (Iridescent Gem)",           "opalpreciousgem",          [ "research", "magic", "tier_1", "ruins", "nounlock", "advanced", "seasons_passed_half", "night" ] ],
    [637,   "Magic (Desert Stone)",             "townportaltalisman",       [ "research", "magic", "tier_2", "seasonal", "summer" ] ],
    [638,   "Magic (Naked Nostrils)",           "batnose",                  [ "research", "magic", "tier_2", "cave" ] ],
    [639,   "Magic (Frog Legs)",                "froglegs",                 [ "research", "magic", "tier_2", "day", "nonwinter" ] ],
    [640,   "Magic (Spoiled Fish)",             "spoiled_fish",             [ "research", "magic", "tier_2", "dualregion" ] ],
    [641,   "Magic (Spoiled Fish Morsel)",      "spoiled_fish_small",       [ "research", "magic", "tier_2" ] ],
    [642,   "Magic (Rot)",                      "spoiled_food",             [ "research", "magic", "tier_2", "seasons_passed_1" ] ],
    [643,   "Magic (Rotten Egg)",               "rottenegg",                [ "research", "magic", "tier_2", "seasons_passed_2", "day", "dusk" ] ],
    [644,   "Magic (Carrat)",                   "carrat",                   [ "research", "magic", "tier_1", "critter_research", "dualregion" ] ],
    [645,   "Magic (Moleworm)",                 "mole",                     [ "research", "magic", "tier_1", "critter_research" ] ],
    [646,   "Magic (Fireflies)",                "fireflies",                [ "research", "magic", "tier_1", "critter_research", "night" ] ],
    [647,   "Magic (Bulbous Lightbug)",         "lightflier",               [ "research", "magic", "tier_1", "critter_research", "cave" ] ],
    [648,   "Magic (Rabbit)",                   "rabbit",                   [ "research", "magic", "tier_1", "critter_research" ] ],
    [649,   "Magic (Butterfly)",                "butterfly",                [ "research", "magic", "tier_1", "critter_research", "nonwinter", "day" ] ],
    [650,   "Magic (Mosquito)",                 "mosquito",                 [ "research", "magic", "tier_1", "critter_research", "nonwinter", "dusk", "night" ] ],
    [651,   "Magic (Bee)",                      "bee",                      [ "research", "magic", "tier_1", "critter_research", "nonwinter", "day" ] ],
    [652,   "Magic (Killer Bee)",               "killerbee",                [ "research", "magic", "tier_1", "critter_research" ] ],
    [653,   "Magic (Crustashine)",              "lightcrab",                [ "research", "magic", "tier_1", "critter_research", "ocean" ] ],
    [654,   "Magic (Crow)",                     "crow",                     [ "research", "magic", "tier_1", "critter_research", "day", "dusk" ] ],
    [655,   "Magic (Redbird)",                  "robin",                    [ "research", "magic", "tier_1", "critter_research", "nonwinter", "day", "dusk" ] ],
    [656,   "Magic (Snowbird)",                 "robin_winter",             [ "research", "magic", "tier_1", "critter_research", "seasonal", "winter", "day", "dusk" ] ],
    [657,   "Magic (Canary)",                   "canary",                   [ "research", "magic", "tier_1", "critter_research", "autumn", "winter", "day", "dusk", "seasons_passed_1" ] ],
    [658,   "Magic (Puffin)",                   "puffin",                   [ "research", "magic", "tier_1", "critter_research", "ocean", "day", "dusk" ] ],
    [659,   "Magic (Fossil Fragments)",         "fossil_piece",             [ "research", "magic", "tier_2", "cave" ] ],

    # Seafaring (701-750)
    [701,   "Think Tank (Freshwater Fish)",     "pondfish",                 [ "research", "seafaring" ] ],
    [702,   "Think Tank (Live Eel)",            "pondeel",                  [ "research", "seafaring", "bothregions" ] ],
    [703,   "Think Tank (Runty Guppy)",         "oceanfish_small_1_inv",    [ "research", "seafaring" ] ],
    [704,   "Think Tank (Needlenosed Squirt)",  "oceanfish_small_2_inv",    [ "research", "seafaring" ] ],
    [705,   "Think Tank (Bitty Baitfish)",      "oceanfish_small_3_inv",    [ "research", "seafaring" ] ],
    [706,   "Think Tank (Smolt Fry)",           "oceanfish_small_4_inv",    [ "research", "seafaring" ] ],
    [707,   "Think Tank (Popperfish)",          "oceanfish_small_5_inv",    [ "research", "seafaring" ] ],
    [708,   "Think Tank (Fallounder)",          "oceanfish_small_6_inv",    [ "research", "seafaring", "ocean", "seasonal", "autumn" ] ],
    [709,   "Think Tank (Bloomfin Tuna)",       "oceanfish_small_7_inv",    [ "research", "seafaring", "seasonal", "spring" ] ],
    [710,   "Think Tank (Scorching Sunfish)",   "oceanfish_small_8_inv",    [ "research", "seafaring", "ocean", "seasonal", "summer" ] ],
    [711,   "Think Tank (Spittlefish)",         "oceanfish_small_9_inv",    [ "research", "seafaring", "ocean" ] ],
    [712,   "Think Tank (Mudfish)",             "oceanfish_medium_1_inv",   [ "research", "seafaring" ] ],
    [713,   "Think Tank (Deep Bass)",           "oceanfish_medium_2_inv",   [ "research", "seafaring", "ocean" ] ],
    [714,   "Think Tank (Dandy Lionfish)",      "oceanfish_medium_3_inv",   [ "research", "seafaring", "ocean" ] ],
    [715,   "Think Tank (Black Catfish)",       "oceanfish_medium_4_inv",   [ "research", "seafaring", "ocean" ] ],
    [716,   "Think Tank (Corn Cod)",            "oceanfish_medium_5_inv",   [ "research", "seafaring", "ocean" ] ],
    [717,   "Think Tank (Ice Bream)",           "oceanfish_medium_8_inv",   [ "research", "seafaring", "seasonal", "winter" ] ],
    [718,   "Think Tank (Sweetish Fish)",       "oceanfish_medium_9_inv",   [ "research", "seafaring" ] ],
    [719,   "Think Tank (Wobster)",             "wobster_sheller_land",     [ "research", "seafaring", "dusk", "night" ] ],
    [720,   "Think Tank (Lunar Wobster)",       "wobster_moonglass_land",   [ "research", "seafaring", "ocean", "dusk", "night" ] ],

    # Ancient (751-800)
    [751,   "Pseudoscience (Purple Gem)",       "purplegem",                [ "research", "ancient", "tier_1", "ruins" ] ],
    [752,   "Pseudoscience (Yellow Gem)",       "yellowgem",                [ "research", "ancient", "tier_1", "ruins", "priority_celestial_boss" ] ],
    [753,   "Pseudoscience (Thulecite)",        "thulecite",                [ "research", "ancient", "tier_1", "ruins", "priority_ruins_boss" ] ],
    [754,   "Pseudoscience (Orange Gem)",       "orangegem",                [ "research", "ancient", "tier_2", "ruins" ] ],
    [755,   "Pseudoscience (Green Gem)",        "greengem",                 [ "research", "ancient", "tier_2", "ruins", "priority_celestial_boss" ] ],

    # Celestial (801-850)
    [801,   "Celestial (Moon Rock)",            "moonrocknugget",           [ "research", "celestial", "tier_1", "rng" ] ],
    [802,   "Celestial (Moon Shard)",           "moonglass",                [ "research", "celestial", "tier_1", "rng", "dualregion" ] ],
    [803,   "Celestial (Moon Shroom)",          "moon_cap",                 [ "research", "celestial", "tier_1", "rng", "cave" ] ],
    [804,   "Celestial (Moon Moth)",            "moonbutterfly",            [ "research", "celestial", "tier_2", "ocean" ] ],
    [805,   "Celestial (Lune Tree Blossom)",    "moon_tree_blossom",        [ "research", "celestial", "tier_2", "ocean" ] ],

    # Hermit Crab (851-900)
    [851,   "Bottle Exchange (1)",              "messagebottleempty",       [ "research", "hermitcrab", "tier_1", "ocean", "priority_crabking_boss" ] ],
    [852,   "Bottle Exchange (2)",              "messagebottleempty",       [ "research", "hermitcrab", "tier_1", "ocean" ] ],
    [853,   "Bottle Exchange (3)",              "messagebottleempty",       [ "research", "hermitcrab", "tier_2", "ocean" ] ],
    [854,   "Bottle Exchange (4)",              "messagebottleempty",       [ "research", "hermitcrab", "tier_2", "ocean" ] ],
    [855,   "Bottle Exchange (5)",              "messagebottleempty",       [ "research", "hermitcrab", "tier_2", "ocean" ] ],
    [856,   "Bottle Exchange (6)",              "messagebottleempty",       [ "research", "hermitcrab", "tier_3", "ocean" ] ],
    [857,   "Bottle Exchange (7)",              "messagebottleempty",       [ "research", "hermitcrab", "tier_3", "ocean" ] ],
    [858,   "Bottle Exchange (8)",              "messagebottleempty",       [ "research", "hermitcrab", "tier_4", "ocean", "special_hermit_8" ] ],
    [859,   "Bottle Exchange (9)",              "messagebottleempty",       [ "research", "hermitcrab", "tier_4", "ocean", "special_hermit_8" ] ],
    [860,   "Bottle Exchange (10)",             "messagebottleempty",       [ "research", "hermitcrab", "tier_4", "ocean", "special_hermit_8", "priority_crabking_boss" ] ],
]