MNEMONICS = {
    "nop": {
        "": 0x00
    },
    "ld": {
        "a": {
            "a": 0x7f,
            "b": 0x78,
            "c": 0x79,
            "d": 0x7a,
            "e": 0x7b,
            "h": 0x7c,
            "l": 0x7d,
            "(bc)": 0x0a,
            "(de)": 0x1a,
            "(hl)": 0x7e,
            "$8": 0x3e,
            "($16)": 0xfa,
            "(ff00+c)": 0xf2,
        },
        "b": {
            "a": 0x47,
            "b": 0x40,
            "c": 0x41,
            "d": 0x42,
            "e": 0x43,
            "h": 0x44,
            "l": 0x45,
            "(hl)": 0x46,
            "$8": 0x06,
        },
        "c": {
            "a": 0x4f,
            "b": 0x48,
            "c": 0x49,
            "d": 0x4a,
            "e": 0x4b,
            "h": 0x4c,
            "l": 0x4d,
            "(hl)": 0x4e,
            "$8": 0x0e,
        },
        "d": {
            "a": 0x57,
            "b": 0x50,
            "c": 0x51,
            "d": 0x52,
            "e": 0x53,
            "h": 0x54,
            "l": 0x55,
            "(hl)": 0x56,
            "$8": 0x16,
        },
        "e": {
            "a": 0x5f,
            "b": 0x58,
            "c": 0x59,
            "d": 0x5a,
            "e": 0x5b,
            "h": 0x5c,
            "l": 0x5d,
            "(hl)": 0x5e,
            "$8": 0x1e,
        },
        "h": {
            "a": 0x67,
            "b": 0x60,
            "c": 0x61,
            "d": 0x62,
            "e": 0x63,
            "h": 0x64,
            "l": 0x65,
            "(hl)": 0x66,
            "$8": 0x26,
        },
        "l": {
            "a": 0x6f,
            "b": 0x68,
            "c": 0x69,
            "d": 0x6a,
            "e": 0x6b,
            "h": 0x6c,
            "l": 0x6d,
            "(hl)": 0x6e,
            "$8": 0x2e,
        },
        "bc": {
            "$16": 0x01,
        },
        "de": {
            "$16": 0x11
        },
        "hl": {
            "$16": 0x21,
            "sp+$8": 0xf8
        },
        "(bc)": {
            "a": 0x02,
        },
        "(de)": {
            "a": 0x12
        },
        "(hl)": {
            "a": 0x77,
            "b": 0x70,
            "c": 0x71,
            "d": 0x72,
            "e": 0x73,
            "h": 0x74,
            "l": 0x75,
            "$8": 0x36
        },
        "($16)": {
            "a": 0xea,
            "sp": 0x08,
        },
        "sp": {
            "$16": 0x31,
            "hl": 0xf9,
        },
        "(ff00+c)": {"a": 0xe2},
    },
    "ldi": {
        "(hl)": {"a": 0x22},
        "a": {"(hl)": 0x2a},
    },
    "ldd": {
        "(hl)": {
            "a": 0x32
        },
        "a": {
            "(hl)": 0x3a
        }
    },
    "ldh": {
        "($8)": {"a": 0xe0},
        "a": {"($8)": 0xf0},
    },
    "inc": {
        "a": 0x3c,
        "b": 0x04,
        "c": 0x0c,
        "d": 0x14,
        "e": 0x1c,
        "h": 0x24,
        "l": 0x2c,
        "bc": 0x03,
        "de": 0x13,
        "hl": 0x23,
        "(hl)": 0x34,
        "sp": 0x33,
    },
    "dec": {
        "a": 0x3d,
        "b": 0x05,
        "c": 0x0d,
        "d": 0x15,
        "e": 0x1d,
        "h": 0x25,
        "l": 0x2d,
        "bc": 0x0b,
        "de": 0x1b,
        "hl": 0x2b,
        "(hl)": 0x35,
        "sp": 0x3b
    },
    "add": {
        "a": {
            "a": 0x87,
            "b": 0x80,
            "c": 0x81,
            "d": 0x82,
            "e": 0x83,
            "h": 0x84,
            "l": 0x85,
            "(hl)": 0x86,
            "$8": 0xc6,
        },
        "hl": {
            "bc": 0x09,
            "de": 0x19,
            "hl": 0x29,
            "sp": 0x39
        },
        "sp": {"$8": 0xe8}
    },
    "adc": {
        "a": {
            "a": 0x8f,
            "b": 0x88,
            "c": 0x89,
            "d": 0x8a,
            "e": 0x8b,
            "h": 0x8c,
            "l": 0x8d,
            "(hl)": 0x8e,
            "$8": 0xce,
        }
    },
    "sub": {
        "a": 0x97,
        "b": 0x90,
        "c": 0x91,
        "d": 0x92,
        "e": 0x93,
        "h": 0x94,
        "l": 0x95,
        "(hl)": 0x96,
        "$8": 0xd6,
    },
    "sbc": {
        "a": {
            "a": 0x9f,
            "b": 0x98,
            "c": 0x99,
            "d": 0x9a,
            "e": 0x9b,
            "h": 0x9c,
            "l": 0x9d,
            "(hl)": 0x9e,
            "$8": 0xde,
        }
    },
    "and": {
        "a": 0xa7,
        "b": 0xa0,
        "c": 0xa1,
        "d": 0xa2,
        "e": 0xa3,
        "h": 0xa4,
        "l": 0xa5,
        "(hl)": 0xa6,
        "$8": 0xe6,
    },
    "xor": {
        "a": 0xaf,
        "b": 0xa8,
        "c": 0xa9,
        "d": 0xaa,
        "e": 0xab,
        "h": 0xac,
        "l": 0xad,
        "(hl)": 0xae,
        "$8": 0xee
    },
    "or": {
        "a": 0xb7,
        "b": 0xb0,
        "c": 0xb1,
        "d": 0xb2,
        "e": 0xb3,
        "h": 0xb4,
        "l": 0xb5,
        "(hl)": 0xb6,
        "$8": 0xf6,
    },
    "cp": {
        "a": 0xbf,
        "b": 0xb8,
        "c": 0xb9,
        "d": 0xba,
        "e": 0xbb,
        "h": 0xbc,
        "l": 0xbd,
        "(hl)": 0xbe,
        "$8": 0xfe,
    },
    "jr": {
        "$8": 0x18,
        "nz": {"$8": 0x20},
        "z": {"$8": 0x28},
        "nc": {"$8": 0x30},
        "c": {"$8": 0x38},
    },
    "jp": {
        "$16": 0xc3,
        "nz": {"$16": 0xc2},
        "z": {"$16": 0xca},
        "nc": {"$16": 0xd2},
        "c": {"$16": 0xda},
        "(hl)": 0xe9,
    },
    "call": {
        "$16": 0xcd,
        "nz": {"$16": 0xc4},
        "z": {"$16": 0xcc},
        "nc": {"$16": 0xd4},
        "c": {"$16": 0xdc}
    },
    "ret": {
        "": 0xc9,
        "z": 0xc8,
        "nz": 0xc0,
        "c": 0xd8,
        "nc": 0xd0,
    },
    "push": {
        "af": 0xf5,
        "bc": 0xc5,
        "de": 0xd5,
        "hl": 0xe5,
    },
    "pop": {
        "af": 0xf1,
        "bc": 0xc1,
        "de": 0xd1,
        "hl": 0xe1,
    },
    "rst": {
        "00": 0xc7,
        "08": 0xcf,
        "10": 0xd7,
        "18": 0xdf,
        "20": 0xe7,
        "28": 0xef,
        "30": 0xf7,
        "38": 0xff,
    },
    "rlca": {
        "": 0x07
    },
    "rrca": {
        "": 0x0f
    },
    "rla": {
        "": 0x17
    },
    "rra": {
        "": 0x1f
    },
    "daa": {
        "": 0x27
    },
    "cpl": {
        "": 0x2f
    },
    "scf": {
        "": 0x37
    },
    "ccf": {
        "": 0x3f
    },
    "reti": {
        "": 0xd9
    },
    "di": {
        "": 0xf3
    },
    "ei": {
        "": 0xfb
    },
    "stop": {"0": 0x10},
    "halt": {
        "": 0x76
    },

    # CB-prefixed mnemonics
    "rlc": {
        "a": [0xcb, 0x07],
        "b": [0xcb, 0x00],
        "c": [0xcb, 0x01],
        "d": [0xcb, 0x02],
        "e": [0xcb, 0x03],
        "h": [0xcb, 0x04],
        "l": [0xcb, 0x05],
        "(hl)": [0xcb, 0x06],
    },
    "rrc": {
        "a": [0xcb, 0x0f],
        "b": [0xcb, 0x08],
        "c": [0xcb, 0x09],
        "d": [0xcb, 0x0a],
        "e": [0xcb, 0x0b],
        "h": [0xcb, 0x0c],
        "l": [0xcb, 0x0d],
        "(hl)": [0xcb, 0x0e],
    },
    "rl": {
        "a": [0xcb, 0x17],
        "b": [0xcb, 0x10],
        "c": [0xcb, 0x11],
        "d": [0xcb, 0x12],
        "e": [0xcb, 0x13],
        "h": [0xcb, 0x14],
        "l": [0xcb, 0x15],
        "(hl)": [0xcb, 0x16],
    },
    "rr": {
        "a": [0xcb, 0x1f],
        "b": [0xcb, 0x18],
        "c": [0xcb, 0x19],
        "d": [0xcb, 0x1a],
        "e": [0xcb, 0x1b],
        "h": [0xcb, 0x1c],
        "l": [0xcb, 0x1d],
        "(hl)": [0xcb, 0x1e],
    },
    "sla": {
        "a": [0xcb, 0x27],
        "b": [0xcb, 0x20],
        "c": [0xcb, 0x21],
        "d": [0xcb, 0x22],
        "e": [0xcb, 0x23],
        "h": [0xcb, 0x24],
        "l": [0xcb, 0x25],
        "(hl)": [0xcb, 0x26],
    },
    "sra": {
        "a": [0xcb, 0x2f],
        "b": [0xcb, 0x28],
        "c": [0xcb, 0x29],
        "d": [0xcb, 0x2a],
        "e": [0xcb, 0x2b],
        "h": [0xcb, 0x2c],
        "l": [0xcb, 0x2d],
        "(hl)": [0xcb, 0x2e],
    },
    "swap": {
        "a": [0xcb, 0x37],
        "b": [0xcb, 0x30],
        "c": [0xcb, 0x31],
        "d": [0xcb, 0x32],
        "e": [0xcb, 0x33],
        "h": [0xcb, 0x34],
        "l": [0xcb, 0x35],
        "(hl)": [0xcb, 0x36],
    },
    "srl": {
        "a": [0xcb, 0x3f],
        "b": [0xcb, 0x38],
        "c": [0xcb, 0x39],
        "d": [0xcb, 0x3a],
        "e": [0xcb, 0x3b],
        "h": [0xcb, 0x3c],
        "l": [0xcb, 0x3d],
        "(hl)": [0xcb, 0x3e],
    },
    "bit": {
        "0": {
            "a": [0xcb, 0x47],
            "b": [0xcb, 0x40],
            "c": [0xcb, 0x41],
            "d": [0xcb, 0x42],
            "e": [0xcb, 0x43],
            "h": [0xcb, 0x44],
            "l": [0xcb, 0x45],
            "(hl)": [0xcb, 0x46],
        },
        "1": {
            "a": [0xcb, 0x4f],
            "b": [0xcb, 0x48],
            "c": [0xcb, 0x49],
            "d": [0xcb, 0x4a],
            "e": [0xcb, 0x4b],
            "h": [0xcb, 0x4c],
            "l": [0xcb, 0x4d],
            "(hl)": [0xcb, 0x4e],
        },
        "2": {
            "a": [0xcb, 0x57],
            "b": [0xcb, 0x50],
            "c": [0xcb, 0x51],
            "d": [0xcb, 0x52],
            "e": [0xcb, 0x53],
            "h": [0xcb, 0x54],
            "l": [0xcb, 0x55],
            "(hl)": [0xcb, 0x56],
        },
        "3": {
            "a": [0xcb, 0x5f],
            "b": [0xcb, 0x58],
            "c": [0xcb, 0x59],
            "d": [0xcb, 0x5a],
            "e": [0xcb, 0x5b],
            "h": [0xcb, 0x5c],
            "l": [0xcb, 0x5d],
            "(hl)": [0xcb, 0x5e],
        },
        "4": {
            "a": [0xcb, 0x67],
            "b": [0xcb, 0x60],
            "c": [0xcb, 0x61],
            "d": [0xcb, 0x62],
            "e": [0xcb, 0x63],
            "h": [0xcb, 0x64],
            "l": [0xcb, 0x65],
            "(hl)": [0xcb, 0x66],
        },
        "5": {
            "a": [0xcb, 0x6f],
            "b": [0xcb, 0x68],
            "c": [0xcb, 0x69],
            "d": [0xcb, 0x6a],
            "e": [0xcb, 0x6b],
            "h": [0xcb, 0x6c],
            "l": [0xcb, 0x6d],
            "(hl)": [0xcb, 0x6e],
        },
        "6": {
            "a": [0xcb, 0x77],
            "b": [0xcb, 0x70],
            "c": [0xcb, 0x71],
            "d": [0xcb, 0x72],
            "e": [0xcb, 0x73],
            "h": [0xcb, 0x74],
            "l": [0xcb, 0x75],
            "(hl)": [0xcb, 0x76],
        },
        "7": {
            "a": [0xcb, 0x7f],
            "b": [0xcb, 0x78],
            "c": [0xcb, 0x79],
            "d": [0xcb, 0x7a],
            "e": [0xcb, 0x7b],
            "h": [0xcb, 0x7c],
            "l": [0xcb, 0x7d],
            "(hl)": [0xcb, 0x7e],
        },
    },
    "res": {
        "0": {
            "a": [0xcb, 0x87],
            "b": [0xcb, 0x80],
            "c": [0xcb, 0x81],
            "d": [0xcb, 0x82],
            "e": [0xcb, 0x83],
            "h": [0xcb, 0x84],
            "l": [0xcb, 0x85],
            "(hl)": [0xcb, 0x86],
        },
        "1": {
            "a": [0xcb, 0x8f],
            "b": [0xcb, 0x88],
            "c": [0xcb, 0x89],
            "d": [0xcb, 0x8a],
            "e": [0xcb, 0x8b],
            "h": [0xcb, 0x8c],
            "l": [0xcb, 0x8d],
            "(hl)": [0xcb, 0x8e],
        },
        "2": {
            "a": [0xcb, 0x97],
            "b": [0xcb, 0x90],
            "c": [0xcb, 0x91],
            "d": [0xcb, 0x92],
            "e": [0xcb, 0x93],
            "h": [0xcb, 0x94],
            "l": [0xcb, 0x95],
            "(hl)": [0xcb, 0x96],
        },
        "3": {
            "a": [0xcb, 0x9f],
            "b": [0xcb, 0x98],
            "c": [0xcb, 0x99],
            "d": [0xcb, 0x9a],
            "e": [0xcb, 0x9b],
            "h": [0xcb, 0x9c],
            "l": [0xcb, 0x9d],
            "(hl)": [0xcb, 0x9e],
        },
        "4": {
            "a": [0xcb, 0xa7],
            "b": [0xcb, 0xa0],
            "c": [0xcb, 0xa1],
            "d": [0xcb, 0xa2],
            "e": [0xcb, 0xa3],
            "h": [0xcb, 0xa4],
            "l": [0xcb, 0xa5],
            "(hl)": [0xcb, 0xa6],
        },
        "5": {
            "a": [0xcb, 0xaf],
            "b": [0xcb, 0xa8],
            "c": [0xcb, 0xa9],
            "d": [0xcb, 0xaa],
            "e": [0xcb, 0xab],
            "h": [0xcb, 0xac],
            "l": [0xcb, 0xad],
            "(hl)": [0xcb, 0xae],
        },
        "6": {
            "a": [0xcb, 0xb7],
            "b": [0xcb, 0xb0],
            "c": [0xcb, 0xb1],
            "d": [0xcb, 0xb2],
            "e": [0xcb, 0xb3],
            "h": [0xcb, 0xb4],
            "l": [0xcb, 0xb5],
            "(hl)": [0xcb, 0xb6],
        },
        "7": {
            "a": [0xcb, 0xbf],
            "b": [0xcb, 0xb8],
            "c": [0xcb, 0xb9],
            "d": [0xcb, 0xba],
            "e": [0xcb, 0xbb],
            "h": [0xcb, 0xbc],
            "l": [0xcb, 0xbd],
            "(hl)": [0xcb, 0xbe],
        },
    },
    "set": {
        "0": {
            "a": [0xcb, 0xc7],
            "b": [0xcb, 0xc0],
            "c": [0xcb, 0xc1],
            "d": [0xcb, 0xc2],
            "e": [0xcb, 0xc3],
            "h": [0xcb, 0xc4],
            "l": [0xcb, 0xc5],
            "(hl)": [0xcb, 0xc6],
        },
        "1": {
            "a": [0xcb, 0xcf],
            "b": [0xcb, 0xc8],
            "c": [0xcb, 0xc9],
            "d": [0xcb, 0xca],
            "e": [0xcb, 0xcb],
            "h": [0xcb, 0xcc],
            "l": [0xcb, 0xcd],
            "(hl)": [0xcb, 0xce],
        },
        "2": {
            "a": [0xcb, 0xd7],
            "b": [0xcb, 0xd0],
            "c": [0xcb, 0xd1],
            "d": [0xcb, 0xd2],
            "e": [0xcb, 0xd3],
            "h": [0xcb, 0xd4],
            "l": [0xcb, 0xd5],
            "(hl)": [0xcb, 0xd6],
        },
        "3": {
            "a": [0xcb, 0xdf],
            "b": [0xcb, 0xd8],
            "c": [0xcb, 0xd9],
            "d": [0xcb, 0xda],
            "e": [0xcb, 0xdb],
            "h": [0xcb, 0xdc],
            "l": [0xcb, 0xdd],
            "(hl)": [0xcb, 0xde],
        },
        "4": {
            "a": [0xcb, 0xe7],
            "b": [0xcb, 0xe0],
            "c": [0xcb, 0xe1],
            "d": [0xcb, 0xe2],
            "e": [0xcb, 0xe3],
            "h": [0xcb, 0xe4],
            "l": [0xcb, 0xe5],
            "(hl)": [0xcb, 0xe6],
        },
        "5": {
            "a": [0xcb, 0xef],
            "b": [0xcb, 0xe8],
            "c": [0xcb, 0xe9],
            "d": [0xcb, 0xea],
            "e": [0xcb, 0xeb],
            "h": [0xcb, 0xec],
            "l": [0xcb, 0xed],
            "(hl)": [0xcb, 0xee],
        },
        "6": {
            "a": [0xcb, 0xf7],
            "b": [0xcb, 0xf0],
            "c": [0xcb, 0xf1],
            "d": [0xcb, 0xf2],
            "e": [0xcb, 0xf3],
            "h": [0xcb, 0xf4],
            "l": [0xcb, 0xf5],
            "(hl)": [0xcb, 0xf6],
        },
        "7": {
            "a": [0xcb, 0xff],
            "b": [0xcb, 0xf8],
            "c": [0xcb, 0xf9],
            "d": [0xcb, 0xfa],
            "e": [0xcb, 0xfb],
            "h": [0xcb, 0xfc],
            "l": [0xcb, 0xfd],
            "(hl)": [0xcb, 0xfe],
        },
    },
}
