from .Constants import *

LOCATIONS_DATA = {
    "North Horon: Chest Across Bridge": {
        "region_id": "eyeglass lake, across bridge",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xc7b8,
        "room": 0x00b8,
        "collect": COLLECT_CHEST,
    },
    "Horon Village: Maku Tree Gift": {
        "region_id": "maku tree",
        "vanilla_item": "Gnarled Key",
        # Maku Tree has several rooms depending on the amount of essences owned
        "flag_byte": 0xc80b,
        "room": [0x020b, 0x020c, 0x022b, 0x022c, 0x022d, 0x025b, 0x025c, 0x025d, 0x025e, 0x027b],
        "collect": COLLECT_MAKU_TREE,
        "map_tile": 0xc9,
        "symbolic_name": "makuTree",
    },
    "Horon Village: Chest Behind Mushrooms": {
        "region_id": "horon village SW chest",
        "vanilla_item": "Rupees (20)",
        "flag_byte": 0xc7f5,
        "room": 0x00f5,
        "collect": COLLECT_CHEST,
    },
    "Horon Village: Chest in Dr. Left's Backyard": {
        "region_id": "horon village SE chest",
        "vanilla_item": "Rupees (20)",
        "flag_byte": 0xc7f9,
        "room": 0x00f9,
        "collect": COLLECT_CHEST,
    },
    "Woods of Winter: Holly's Gift": {
        "region_id": "holly's house",
        "vanilla_item": "Shovel",
        "flag_byte": 0xc8a3,
        "room": 0x03a3,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x7f,
        "symbolic_name": "hollyGift",
    },
    "Woods of Winter: Chest on D2 Roof": {
        "region_id": "d2 roof",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xc78e,
        "room": 0x008e,
        "collect": COLLECT_CHEST,
    },
    "Holodrum Plain: Blaino's Gym Prize": {
        "region_id": "blaino prize",
        "vanilla_item": "Progressive Sword",  # Ricky's gloves are useless in current logic
        "flag_byte": 0xc8b4,
        "room": 0x03b4,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x78,
        "symbolic_name": "blainoPrize",
    },
    "Holodrum Plain: Underwater Item Below Natzu Bridge": {
        "region_id": "underwater item below natzu bridge",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xc766,
        "room": 0x0066,
        "collect": COLLECT_DIVE,
        "symbolic_name": "underwaterItemBelowNatzuBridge"
    },
    "Spool Swamp: Digging Spot Near Vasu's Sign": {
        "region_id": "spool swamp digging spot",
        "vanilla_item": "Armor Ring L-1",  # Random ring in vanilla, but rings are randomized anyway
        "flag_byte": 0xc782,
        "room": 0x0082,
        "collect": COLLECT_DIG,
        "symbolic_name": "spoolSwampDiggingSpot",
    },
    "Spool Swamp: Item in Floodgate Keeper's House": {
        "region_id": "floodgate keeper's house",
        "vanilla_item": "Floodgate Key",
        "flag_byte": 0xc8b5,
        "room": 0x03b5,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x62,
        "symbolic_name": "floodgateKeeperHouse"
    },
    "Spool Swamp: Chest in Winter Cave": {
        "region_id": "spool swamp cave",
        "vanilla_item": "Square Jewel",
        "flag_byte": 0xc9fa,
        "room": 0x04fa,
        "collect": COLLECT_CHEST,
        "map_tile": 0xc2,
    },
    "Natzu Region: Chest after Moblin Keep": {
        "region_id": "moblin keep chest",
        "vanilla_item": "Piece of Heart",
        "flag_byte": 0xc75b,
        "room": 0x005b,
        "collect": COLLECT_CHEST,
    },
    "Sunken City: Master Diver's Challenge Chest": {
        "region_id": "master diver's challenge",
        "vanilla_item": "Master's Plaque",
        "flag_byte": 0xcabc,
        "room": 0x05bc,
        "collect": COLLECT_CHEST,
        "map_tile": 0x2e,
    },
    "Sunken City: Master's Plaque Trade": {
        "region_id": "master diver's reward",
        "vanilla_item": "Flippers",
        "flag_byte": 0xcabd,
        "bit_mask": 0x80,
        "room": 0x05bd,
        "collect": COLLECT_DIVER_ROOM,
        "map_tile": 0x2e,
        "symbolic_name": "masterPlaqueTrade",
    },
    "Sunken City: Chest in Master Diver's Cave": {
        "region_id": "chest in master diver's cave",
        "vanilla_item": "Rupees (50)",
        "flag_byte": 0xcabd,
        "room": 0x05bd,
        "collect": COLLECT_DIVER_ROOM,
        "is_chest": True,
        "map_tile": 0x2e,
    },
    "Mt. Cucco: Spring Banana Tree": {
        "region_id": "spring banana tree",
        "vanilla_item": "Spring Banana",
        "flag_byte": 0xc70f,
        "room": 0x000f,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "springBananaTree",
    },
    "Goron Mountain: Item Across Pits": {
        "region_id": "goron mountain, across pits",
        "vanilla_item": "Dragon Key",
        "flag_byte": 0xc71a,
        "room": 0x001a,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "goronMountainPits",
    },
    "Mt. Cucco: Moving Platform Cave": {
        "region_id": "mt. cucco, platform cave",
        "vanilla_item": "Green Joy Ring",
        "flag_byte": 0xcabb,
        "room": 0x05bb,
        "collect": COLLECT_DROP,
        "map_tile": 0x1f,
        "symbolic_name": "mtCuccoPlatformCave",
    },
    "Mt. Cucco: Diving Spot Outside D4": {
        "region_id": "diving spot outside D4",
        "vanilla_item": "Pyramid Jewel",
        "flag_byte": 0xcae5,
        "room": 0x07e5,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x1d,
        "symbolic_name": "divingSpotOutsideD4",
    },
    "Western Coast: Black Beast's Chest": {
        "region_id": "black beast's chest",
        "vanilla_item": "X-Shaped Jewel",
        "flag_byte": 0xc7f4,
        "room": 0x00f4,
        "collect": COLLECT_CHEST,
    },
    "Holodrum Plain: Old Man in Treehouse": {
        "region_id": "old man in treehouse",
        "vanilla_item": "Round Jewel",
        "flag_byte": 0xc894,
        "room": 0x0394,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xb5,
        "symbolic_name": "oldManInTreehouse",
    },
    "Lost Woods: Pedestal Item": {
        "region_id": "lost woods",
        "vanilla_item": "Progressive Sword",
        "flag_byte": 0xc7c9,
        "room": 0x00c9,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x40,
        "symbolic_name": "lostWoodsPedestal",
    },
    "Samasa Desert: Item in Quicksand Pit": {
        "region_id": "samasa desert pit",
        "vanilla_item": "Rusty Bell",
        "flag_byte": 0xcad2,
        "room": 0x05d2,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xbf,
        "symbolic_name": "samasaDesertPit",
    },
    "Samasa Desert: Chest on Cliff": {
        "region_id": "samasa desert chest",
        "vanilla_item": "Rang Ring L-1",
        "flag_byte": 0xc7ff,
        "room": 0x00ff,
        "collect": COLLECT_CHEST
    },
    "Western Coast: Chest on Beach": {
        "region_id": "western coast after ship",
        "vanilla_item": "Blast Ring",
        "flag_byte": 0xc7e3,
        "room": 0x00e3,
        "collect": COLLECT_CHEST,
    },
    "Western Coast: Chest in House": {
        "region_id": "western coast after ship",
        "vanilla_item": "Bombs (10)",
        "flag_byte": 0xc888,
        "room": 0x0388,
        "collect": COLLECT_CHEST,
        "map_tile": 0xd2,
    },
    "Holodrum Plain: Chest in Flooded Cave South of Mrs. Ruul": {
        "region_id": "cave south of mrs. ruul",
        "vanilla_item": "Octo Ring",
        "flag_byte": 0xc9e0,
        "room": 0x04e0,
        "collect": COLLECT_CHEST,
        "map_tile": 0xb3,
    },
    "Holodrum Plain: Chest in Flooded Cave Behind Mushrooms": {
        "region_id": "cave north of D1",
        "vanilla_item": "Quicksand Ring",
        "flag_byte": 0xc9e1,
        "room": 0x04e1,
        "collect": COLLECT_CHEST,
        "map_tile": 0x87,
    },
    "Woods of Winter: Chest in Autumn Cave Near D2": {
        "region_id": "cave outside D2",
        "vanilla_item": "Moblin Ring",
        "flag_byte": 0xcab3,
        "room": 0x05b3,
        "collect": COLLECT_CHEST,
        "map_tile": 0x8e,
    },
    "Woods of Winter: Chest in Cave Behind Rockslide": {
        "region_id": "woods of winter, 1st cave",
        "vanilla_item": "Rupees (30)",
        "flag_byte": 0xcab4,
        "room": 0x05b4,
        "collect": COLLECT_CHEST,
        "map_tile": 0x7d,
    },
    "Sunken City: Chest in Summer Cave": {
        "region_id": "sunken city, summer cave",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xcab5,
        "room": 0x05b5,
        "collect": COLLECT_CHEST,
        "map_tile": 0x4f,
    },
    "Sunken City: Syrup Shop #1": {
        "region_id": "syrup shop",
        "vanilla_item": "Flute",  # Potion should be there, but it was moved to Horon Shop for practical reasons
        "flag_byte": 0xc63f,      # when enabling "Enforce Potion in Horon Shop".
        "bit_mask": 0x80,
        "scouting_byte": 0xc89c,
        "scouting_mask": 0x40,
        "room": 0x039c,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x5e,
        "symbolic_name": "syrupShop1",
    },
    "Sunken City: Syrup Shop #2": {
        "region_id": "syrup shop",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xc63f,
        "bit_mask": 0x20,
        "scouting_byte": 0xc89c,
        "scouting_mask": 0x40,
        "room": 0x039c,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x5e,
        "symbolic_name": "syrupShop2",
    },
    "Sunken City: Syrup Shop #3": {
        "region_id": "syrup shop",
        "vanilla_item": "Bombchus (10)",
        "flag_byte": 0xc63f,
        "bit_mask": 0x40,
        "scouting_byte": 0xc89c,
        "scouting_mask": 0x40,
        "room": 0x039c,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x5e,
        "symbolic_name": "syrupShop3",
    },

    "Eyeglass Lake: Chest in Dried Lake East Cave": {
        "region_id": "dry eyeglass lake, east cave",
        "vanilla_item": "Piece of Heart",
        "flag_byte": 0xcac0,
        "room": 0x05c0,
        "collect": COLLECT_CHEST,
        "map_tile": 0xaa,
    },
    "Goron Mountain: Chest Across Lava": {
        "region_id": "chest in goron mountain",
        "vanilla_item": "Armor Ring L-2",
        "flag_byte": 0xcac8,
        "room": 0x05c8,
        "collect": COLLECT_CHEST,
        "map_tile": 0x18,
    },
    "Natzu Region: Chest in Northern Cave": {
        "region_id": "natzu region, across water",
        "vanilla_item": "Rupees (50)",
        "flag_byte": 0xca0e,
        "room": 0x050e,
        "collect": COLLECT_CHEST,
        "map_tile": 0x49,
    },
    "Mt. Cucco: Chest Behind Talon": {
        "region_id": "talon trade",
        "vanilla_item": "Subrosian Ring",
        "flag_byte": 0xcab6,
        "bit_mask": 0x60,  # 0x60 is needed here to ensure we're not sending Talon's wakeup item as a false positive
        "room": 0x05b6,
        "collect": COLLECT_CHEST,
        "map_tile": 0x1b,
    },
    "Tarm Ruins: Chest in Rabbit Hole Under Tree": {
        "region_id": "tarm ruins, under tree",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xc89b,
        "room": 0x039b,
        "collect": COLLECT_CHEST,
        "map_tile": 0x10,
    },
    "Eastern Suburbs: Chest in Spring Cave": {
        "region_id": "eastern suburbs spring cave",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xc9f7,
        "room": 0x04f7,
        "collect": COLLECT_CHEST,
        "map_tile": 0xcc,
    },
    "Eyeglass Lake: Chest in Dried Lake West Cave": {
        "region_id": "dry eyeglass lake, west cave",
        "vanilla_item": "Rupees (100)",
        "flag_byte": 0xc9fb,
        "room": 0x04fb,
        "collect": COLLECT_CHEST,
        "map_tile": 0xa7,
    },
    "Woods of Winter: Chest in Waterfall Cave": {
        "region_id": "woods of winter, 2nd cave",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xca12,
        "room": 0x0512,
        "collect": COLLECT_CHEST,
        "map_tile": 0x7e,
    },
    "Horon Village: Shop #1": {
        "region_id": "horon shop",
        "vanilla_item": "Bombs (10)",
        "flag_byte": 0xc640,
        "bit_mask": 0x20,
        "scouting_byte": 0xc8a6,
        "room": 0x03a6,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xe6,
        "symbolic_name": "horonShop1",
    },
    "Horon Village: Shop #2": {
        "region_id": "horon shop",
        "vanilla_item": "Progressive Shield",
        "flag_byte": 0xc640,
        "bit_mask": 0x40,
        "scouting_byte": 0xc8a6,
        "room": 0x03a6,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xe6,
        "symbolic_name": "horonShop2",
    },
    "Horon Village: Shop #3": {
        "region_id": "horon shop",
        "vanilla_item": "Potion",  # Flute should be there, but it was moved to Syrup Shop for practical reasons
        "flag_byte": 0xc640,       # when enabling "Enforce Potion in Horon Shop".
        "bit_mask": 0x80,
        "conditional": True,
        "scouting_byte": 0xc8a6,
        "room": 0x03a6,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xe6,
        "symbolic_name": "horonShop3",
    },
    "Horon Village: Member's Shop #1": {
        "region_id": "member's shop",
        "vanilla_item": "Seed Satchel",
        "flag_byte": 0xc63f,
        "bit_mask": 0x01,
        "scouting_byte": 0xc8b0,
        "room": 0x03b0,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xe6,
        "symbolic_name": "memberShop1",
    },
    "Horon Village: Member's Shop #2": {
        "region_id": "member's shop",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xc63f,
        "bit_mask": 0x02,
        "scouting_byte": 0xc8b0,
        "room": 0x03b0,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xe6,
        "symbolic_name": "memberShop2",
    },
    "Horon Village: Member's Shop #3": {
        "region_id": "member's shop",
        "vanilla_item": "Seed Satchel",
        # Add a 3rd satchel that is usually obtained in linked games (99 seeds) while removing the treasure map which is not implemented yet
        "flag_byte": 0xc63f,
        "bit_mask": 0x08,
        "scouting_byte": 0xc8b0,
        "room": 0x03b0,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xe6,
        "symbolic_name": "memberShop3",
    },
    "Horon Village: Advance Shop #1": {
        "region_id": "advance shop",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xc640,
        "bit_mask": 0x01,
        "conditional": True,
        "scouting_byte": 0xc8af,
        "room": 0x03af,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xc5,
        "symbolic_name": "advanceShop1",
    },
    "Horon Village: Advance Shop #2": {
        "region_id": "advance shop",
        "vanilla_item": "Random Ring",
        "flag_byte": 0xc640,
        "bit_mask": 0x02,
        "conditional": True,
        "scouting_byte": 0xc8af,
        "room": 0x03af,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xc5,
        "symbolic_name": "advanceShop2",
    },
    "Horon Village: Advance Shop #3": {
        "region_id": "advance shop",
        "vanilla_item": "Random Ring",
        "flag_byte": 0xc640,
        "bit_mask": 0x04,
        "conditional": True,
        "scouting_byte": 0xc8af,
        "room": 0x03af,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xc5,
        "symbolic_name": "advanceShop3",
    },
    "Subrosia: Tower of Winter": {
        "region_id": "tower of winter",
        "vanilla_item": "Rod of Seasons (Winter)",
        "flag_byte": 0xcaf2,
        "room": 0x05f2,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xb0,
        "symbolic_name": "towerOfWinter",
    },
    "Subrosia: Tower of Summer": {
        "region_id": "tower of summer",
        "vanilla_item": "Rod of Seasons (Summer)",
        "flag_byte": 0xcaf8,
        "room": 0x05f8,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xb0,
        "symbolic_name": "towerOfSummer",
    },
    "Subrosia: Tower of Spring": {
        "region_id": "tower of spring",
        "vanilla_item": "Rod of Seasons (Spring)",
        "flag_byte": 0xcaf5,
        "room": 0x05f5,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x1e,
        "symbolic_name": "towerOfSpring",
    },
    "Subrosia: Tower of Autumn": {
        "region_id": "tower of autumn",
        "vanilla_item": "Rod of Seasons (Autumn)",
        "flag_byte": 0xcafb,
        "room": 0x05fb,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xb0,
        "symbolic_name": "towerOfAutumn",
    },
    "Subrosia: Dance Hall Reward": {
        "region_id": "subrosian dance hall",
        "vanilla_item": "Progressive Boomerang",
        "flag_byte": 0xc895,
        "room": 0x0395,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x9a,
        "symbolic_name": "subrosianDanceHall",
    },
    "Subrosia: Temple of Seasons": {
        "region_id": "temple of seasons",
        "vanilla_item": "Fool's Ore",  # Originally Rod of Seasons which is not used in the rando
        "flag_byte": 0xc8ac,
        "room": 0x03ac,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xb0,
        "symbolic_name": "templeOfSeasons",
    },
    "Subrosia: Seaside Digging Spot": {
        "region_id": "subrosia seaside",
        "vanilla_item": "Star Ore",
        "flag_byte": 0xc866,
        "room": [0x0165, 0x0166, 0x0175, 0x0176],
        "collect": COLLECT_DIG,
        "map_tile": 0xb0,
        "symbolic_name": "subrosiaSeaside",
    },
    "Subrosia: Wilds Chest": {
        "region_id": "subrosian wilds chest",
        "vanilla_item": "Blue Ore",
        "flag_byte": 0xc841,
        "room": 0x0141,
        "collect": COLLECT_CHEST,
        "map_tile": 0x1e,
    },
    "Subrosia: Wilds Digging Spot": {
        "region_id": "subrosian wilds digging spot",
        "vanilla_item": "Power Ring L-2",  # Random ring in vanilla, but this doesn't exist in rando
        "flag_byte": 0xc840,
        "room": 0x0140,
        "collect": COLLECT_DIG,
        "map_tile": 0x1e,
        "symbolic_name": "subrosianWildsDiggingSpot",
    },
    "Subrosia: Chest Above Magnet Cave": {
        "region_id": "subrosia village chest",
        "vanilla_item": "Red Ore",
        "flag_byte": 0xc858,
        "room": 0x0158,
        "collect": COLLECT_CHEST,
        "map_tile": 0xb0,
    },
    "Subrosia: Northwest Open Cave": {
        "region_id": "subrosia, open cave",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xc9f1,
        "room": 0x04f1,
        "collect": COLLECT_CHEST,
        "map_tile": 0x25,
    },
    "Subrosia: Northwest Locked Cave": {
        "region_id": "subrosia, locked cave",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xcac6,
        "room": 0x05c6,
        "collect": COLLECT_CHEST,
        "map_tile": 0x25,
    },
    "Subrosia: Market #1": {
        "region_id": "subrosia market star ore",
        "vanilla_item": "Ribbon",
        "flag_byte": 0xc642,
        "bit_mask": 0x01,
        "scouting_byte": 0xc8a0,
        "room": 0x03a0,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xb0,
        "symbolic_name": "subrosianMarket1",
    },
    "Subrosia: Market #2": {
        "region_id": "subrosia market ore chunks",
        "vanilla_item": "Rare Peach Stone",
        "flag_byte": 0xc642,
        "bit_mask": 0x02,
        "scouting_byte": 0xc8a0,
        "room": 0x03a0,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xb0,
        "symbolic_name": "subrosianMarket2",
    },
    "Subrosia: Market #3": {
        "region_id": "subrosia market ore chunks",
        "vanilla_item": "Progressive Shield",
        "flag_byte": 0xc642,
        "bit_mask": 0x04,
        "scouting_byte": 0xc8a0,
        "room": 0x03a0,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xb0,
        "symbolic_name": "subrosianMarket3",
    },
    "Subrosia: Market #4": {
        "region_id": "subrosia market ore chunks",
        "vanilla_item": "Bombs (10)",
        "flag_byte": 0xc642,
        "bit_mask": 0x08,
        "scouting_byte": 0xc8a0,
        "room": 0x03a0,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xb0,
        "symbolic_name": "subrosianMarket4",
    },
    "Subrosia: Market #5": {
        "region_id": "subrosia market ore chunks",
        "vanilla_item": "Member's Card",
        "flag_byte": 0xc642,
        "bit_mask": 0x10,
        "scouting_byte": 0xc8a0,
        "room": 0x03a0,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xb0,
        "symbolic_name": "subrosianMarket5",
    },
    "Subrosia: Item Smelted in Great Furnace": {
        "region_id": "great furnace",
        "vanilla_item": "Hard Ore",
        "flag_byte": 0xc88e,
        "room": 0x038e,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xb9,
        "symbolic_name": "greatFurnace",
    },
    "Subrosia: Smithy Hard Ore Reforge": {
        "region_id": "subrosian smithy ore",
        "vanilla_item": "Progressive Shield",
        "flag_byte": 0xc897,
        "bit_mask": 0x40,
        "room": 0x0397,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x1e,
        "symbolic_name": "subrosianSmithyOre",
    },
    "Subrosia: Smithy Rusty Bell Reforge": {
        "region_id": "subrosian smithy bell",
        "vanilla_item": "Pirate's Bell",
        "flag_byte": 0xc897,
        "bit_mask": 0x80,
        "room": 0x0397,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x1e,
        "symbolic_name": "subrosianSmithyBell",
    },

    "Hero's Cave: Topmost Chest": {
        "region_id": "d0 key chest",
        "vanilla_item": "Small Key (Hero's Cave)",
        "dungeon": 0,
        "flag_byte": 0xc903,
        "room": 0x0403,
        "collect": COLLECT_CHEST,
        "map_tile": 0xd4,
    },
    "Hero's Cave: Final Chest": {
        "region_id": "d0 sword chest",
        "vanilla_item": "Progressive Sword",
        "dungeon": 0,
        "flag_byte": 0xc906,
        "room": 0x0406,
        # Not a real chest, so we don't apply the usual COLLECT_CHEST
        "map_tile": 0xd4,
        "symbolic_name": "d0SwordChest",
    },
    "Hero's Cave: Item in Basement Under Keese Room": {
        "region_id": "d0 hidden 2d section",
        "vanilla_item": "Gasha Seed",
        "dungeon": 0,
        "flag_byte": 0xc901,
        "room": 0x0601,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xd4,
        "symbolic_name": "d0HiddenBasement"
    },
    "Hero's Cave: Alternative Entrance Chest": {
        "region_id": "d0 rupee chest",
        "vanilla_item": "Rupees (30)",
        "dungeon": 0,
        "flag_byte": 0xc905,
        "room": 0x0405,
        "collect": COLLECT_CHEST,
        "map_tile": 0xd4,
    },

    "Gnarled Root Dungeon: Drop in Right Stalfos Room": {
        "region_id": "d1 stalfos drop",
        "vanilla_item": "Small Key (Gnarled Root Dungeon)",
        "dungeon": 1,
        "flag_byte": 0xc91b,
        "room": 0x041b,
        "collect": COLLECT_DROP,
        "map_tile": 0x96,
        "symbolic_name": "d1StalfosDrop",
    },
    "Gnarled Root Dungeon: Item in Basement": {
        "region_id": "d1 basement",
        "vanilla_item": "Seed Satchel",
        "dungeon": 1,
        "flag_byte": 0xc909,
        "room": 0x0609,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x96,
        "symbolic_name": "d1Basement",
    },
    "Gnarled Root Dungeon: Chest in Block-pushing Room": {
        "region_id": "d1 block-pushing room",
        "vanilla_item": "Gasha Seed",
        "dungeon": 1,
        "flag_byte": 0xc90d,
        "room": 0x040d,
        "collect": COLLECT_CHEST,
        "map_tile": 0x96,
    },
    "Gnarled Root Dungeon: Chest Near Railway": {
        "region_id": "d1 railway chest",
        "vanilla_item": "Bombs (10)",
        "dungeon": 1,
        "flag_byte": 0xc910,
        "room": 0x0410,
        "collect": COLLECT_CHEST,
        "map_tile": 0x96,
    },
    "Gnarled Root Dungeon: Chest in Floormaster Room": {
        "region_id": "d1 floormaster room",
        "vanilla_item": "Discovery Ring",
        "dungeon": 1,
        "flag_byte": 0xc917,
        "room": 0x0417,
        "collect": COLLECT_CHEST,
        "map_tile": 0x96,
    },
    "Gnarled Root Dungeon: Chest Near Railway Lever": {
        "region_id": "d1 lever room",
        "vanilla_item": "Compass (Gnarled Root Dungeon)",
        "dungeon": 1,
        "flag_byte": 0xc90f,
        "room": 0x040f,
        "collect": COLLECT_CHEST,
        "map_tile": 0x96,
    },
    "Gnarled Root Dungeon: Chest in Left Stalfos Room": {
        "region_id": "d1 stalfos chest",
        "vanilla_item": "Dungeon Map (Gnarled Root Dungeon)",
        "dungeon": 1,
        "flag_byte": 0xc919,
        "room": 0x0419,
        "collect": COLLECT_CHEST,
        "map_tile": 0x96,
    },
    "Gnarled Root Dungeon: Hidden Chest Revealed by Button": {
        "region_id": "d1 button chest",
        "vanilla_item": "Small Key (Gnarled Root Dungeon)",
        "dungeon": 1,
        "flag_byte": 0xc911,
        "room": 0x0411,
        "collect": COLLECT_CHEST,
        "map_tile": 0x96,
    },
    "Gnarled Root Dungeon: Chest in Goriya Room": {
        "region_id": "d1 goriya chest",
        "vanilla_item": "Boss Key (Gnarled Root Dungeon)",
        "dungeon": 1,
        "flag_byte": 0xc914,
        "room": 0x0414,
        "collect": COLLECT_CHEST,
        "map_tile": 0x96,
    },
    "Gnarled Root Dungeon: Boss Reward": {
        "region_id": "d1 boss",
        "vanilla_item": "Heart Container",
        "dungeon": 1,
        "flag_byte": 0xc912,
        "room": 0x0412,
        "collect": COLLECT_POOF,
        "map_tile": 0x96,
        "symbolic_name": "d1Boss"
    },

    "Snake's Remains: Drop in Left Rope Room": {
        "region_id": "d2 rope drop",
        "vanilla_item": "Small Key (Snake's Remains)",
        "dungeon": 2,
        "flag_byte": 0xc934,
        "room": 0x0434,
        "collect": COLLECT_DROP,
        "map_tile": 0x8d,
        "symbolic_name": "d2RopeDrop",
    },
    "Snake's Remains: Chest in Distant Moblins Room": {
        "region_id": "d2 moblin chest",
        "vanilla_item": "Power Bracelet",
        "dungeon": 2,
        "flag_byte": 0xc92a,
        "room": 0x042a,
        "collect": COLLECT_CHEST,
        "map_tile": 0x8d,
    },
    "Snake's Remains: Chest in Rollers Section": {
        "region_id": "d2 roller chest",
        "vanilla_item": "Rupees (10)",
        "dungeon": 2,
        "flag_byte": 0xc91f,
        "room": 0x041f,
        "collect": COLLECT_CHEST,
        "map_tile": 0x8d,
    },
    "Snake's Remains: Chest Left from Entrance": {
        "region_id": "d2 left from entrance",
        "vanilla_item": "Rupees (5)",
        "dungeon": 2,
        "flag_byte": 0xc938,
        "room": 0x0438,
        "collect": COLLECT_CHEST,
        "map_tile": 0x8d,
    },
    "Snake's Remains: Chest Behind Pots in Hardhat Room": {
        "region_id": "d2 pot chest",
        "vanilla_item": "Dungeon Map (Snake's Remains)",
        "dungeon": 2,
        "flag_byte": 0xc92b,
        "room": 0x042b,
        "collect": COLLECT_CHEST,
        "map_tile": 0x8d,
    },
    "Snake's Remains: Chest in Right Rope Room": {
        "region_id": "d2 rope chest",
        "vanilla_item": "Compass (Snake's Remains)",
        "dungeon": 2,
        "flag_byte": 0xc936,
        "room": 0x0436,
        "collect": COLLECT_CHEST,
        "map_tile": 0x8d,
    },
    "Snake's Remains: Chest in Moving Blades Room": {
        "region_id": "d2 blade chest",
        "vanilla_item": "Small Key (Snake's Remains)",
        "dungeon": 2,
        "flag_byte": 0xc931,
        "room": 0x0431,
        "collect": COLLECT_CHEST,
        "map_tile": 0x8d,
    },
    "Snake's Remains: Chest in Bomb Spiral Maze Room": {
        "region_id": "d2 spiral chest",
        "vanilla_item": "Small Key (Snake's Remains)",
        "dungeon": 2,
        "flag_byte": 0xc92d,
        "room": 0x042d,
        "collect": COLLECT_CHEST,
        "map_tile": 0x8d,
    },
    "Snake's Remains: Chest on Terrace": {
        "region_id": "d2 terrace chest",
        "vanilla_item": "Boss Key (Snake's Remains)",
        "dungeon": 2,
        "flag_byte": 0xc924,
        "room": 0x0424,
        "collect": COLLECT_CHEST,
        "map_tile": 0x8d,
    },
    "Snake's Remains: Boss Reward": {
        "region_id": "d2 boss",
        "vanilla_item": "Heart Container",
        "dungeon": 2,
        "flag_byte": 0xc929,
        "room": 0x0429,
        "collect": COLLECT_POOF,
        "map_tile": 0x8d,
        "symbolic_name": "d2Boss"
    },

    "Poison Moth's Lair (B1F): Chest in Roller Room": {
        "region_id": "d3 roller chest",
        "vanilla_item": "Small Key (Poison Moth's Lair)",
        "dungeon": 3,
        "flag_byte": 0xc94c,
        "room": 0x044c,
        "collect": COLLECT_CHEST,
        "map_tile": 0x60,
    },
    "Poison Moth's Lair (1F): Chest in Mimics Room": {
        "region_id": "d3 mimic chest",
        "vanilla_item": "Progressive Feather",
        "dungeon": 3,
        "flag_byte": 0xc950,
        "room": 0x0450,
        "collect": COLLECT_CHEST,
        "map_tile": 0x60,
    },
    "Poison Moth's Lair (1F): Chest Above East Trampoline": {
        "region_id": "d3 zol chest",
        "vanilla_item": "Small Key (Poison Moth's Lair)",
        "dungeon": 3,
        "flag_byte": 0xc94f,
        "room": 0x044f,
        "collect": COLLECT_CHEST,
        "map_tile": 0x60,
    },
    "Poison Moth's Lair (B1F): Chest in Watery Room": {
        "region_id": "d3 water room",
        "vanilla_item": "Rupees (30)",
        "dungeon": 3,
        "flag_byte": 0xc941,
        "room": 0x0441,
        "collect": COLLECT_CHEST,
        "map_tile": 0x60,
    },
    "Poison Moth's Lair (B1F): Chest on Quicksand Terrace": {
        "region_id": "d3 quicksand terrace",
        "vanilla_item": "Gasha Seed",
        "dungeon": 3,
        "flag_byte": 0xc944,
        "room": 0x0444,
        "collect": COLLECT_CHEST,
        "map_tile": 0x60,
    },
    "Poison Moth's Lair (1F): Chest in Moldorm Room": {
        "region_id": "d3 moldorm chest",
        "vanilla_item": "Bombs (10)",
        "dungeon": 3,
        "flag_byte": 0xc954,
        "room": 0x0454,
        "collect": COLLECT_CHEST,
        "map_tile": 0x60,
    },
    "Poison Moth's Lair (1F): Chest Above West Trampoline & Owl": {
        "region_id": "d3 trampoline chest",
        "vanilla_item": "Compass (Poison Moth's Lair)",
        "dungeon": 3,
        "flag_byte": 0xc94d,
        "room": 0x044d,
        "collect": COLLECT_CHEST,
        "map_tile": 0x60,
    },
    "Poison Moth's Lair (1F): Chest in Room Behind Hidden Cracked Wall": {
        "region_id": "d3 bombed wall chest",
        "vanilla_item": "Dungeon Map (Poison Moth's Lair)",
        "dungeon": 3,
        "flag_byte": 0xc951,
        "room": 0x0451,
        "collect": COLLECT_CHEST,
        "map_tile": 0x60,
    },
    "Poison Moth's Lair (B1F): Chest in Moving Blade Room": {
        "region_id": "d3 giant blade room",
        "vanilla_item": "Boss Key (Poison Moth's Lair)",
        "dungeon": 3,
        "flag_byte": 0xc946,
        "room": 0x0446,
        "collect": COLLECT_CHEST,
        "map_tile": 0x60,
    },
    "Poison Moth's Lair (1F): Boss Reward": {
        "region_id": "d3 boss",
        "vanilla_item": "Heart Container",
        "dungeon": 3,
        "flag_byte": 0xc953,
        "room": 0x0453,
        "collect": COLLECT_POOF,
        "map_tile": 0x60,
        "symbolic_name": "d3Boss"
    },

    "Dancing Dragon Dungeon (2F): Pots on Buttons Puzzle Drop": {
        "region_id": "d4 pot puzzle",
        "vanilla_item": "Small Key (Dancing Dragon Dungeon)",
        "dungeon": 4,
        "flag_byte": 0xc97b,
        "room": 0x047b,
        "collect": COLLECT_DROP,
        "map_tile": 0x1d,
        "symbolic_name": "d4PotPuzzle",
    },
    "Dancing Dragon Dungeon (2F): Chest North of Entrance": {
        "region_id": "d4 north of entrance",
        "vanilla_item": "Bombs (10)",
        "dungeon": 4,
        "flag_byte": 0xc97f,
        "room": 0x047f,
        "collect": COLLECT_CHEST,
        "map_tile": 0x1d,
    },
    "Dancing Dragon Dungeon (1F): Chest in Southwest Quadrant of Beamos Room": {
        "region_id": "d4 maze chest",
        "vanilla_item": "Dungeon Map (Dancing Dragon Dungeon)",
        "dungeon": 4,
        "flag_byte": 0xc969,
        "room": 0x0469,
        "collect": COLLECT_CHEST,
        "map_tile": 0x1d,
    },
    "Dancing Dragon Dungeon (1F): Dark Room Chest": {
        "region_id": "d4 dark room",
        "vanilla_item": "Small Key (Dancing Dragon Dungeon)",
        "dungeon": 4,
        "flag_byte": 0xc96d,
        "room": 0x046d,
        "collect": COLLECT_CHEST,
        "map_tile": 0x1d,
    },
    "Dancing Dragon Dungeon (2F): Chest in Water Donut Room": {
        "region_id": "d4 water ring room",
        "vanilla_item": "Compass (Dancing Dragon Dungeon)",
        "dungeon": 4,
        "flag_byte": 0xc983,
        "room": 0x0483,
        "collect": COLLECT_CHEST,
        "map_tile": 0x1d,
    },
    "Dancing Dragon Dungeon (2F): Pool Drop": {
        "region_id": "d4 pool",
        "vanilla_item": "Small Key (Dancing Dragon Dungeon)",
        "dungeon": 4,
        "flag_byte": 0xc975,
        "room": 0x0475,
        "collect": COLLECT_DROP,
        "map_tile": 0x1d,
        "symbolic_name": "d4Pool",
    },
    "Dancing Dragon Dungeon (1F): Chest on Small Terrace": {
        "region_id": "d4 terrace",
        "vanilla_item": "Small Key (Dancing Dragon Dungeon)",
        "dungeon": 4,
        "flag_byte": 0xc963,
        "room": 0x0463,
        "collect": COLLECT_D4_SCRUB_ROOM,
        "is_chest": True,
        "map_tile": 0x1d,
    },
    "Dancing Dragon Dungeon (1F): Chest Revealed by Minecart Torches": {
        "region_id": "d4 torch chest",
        "vanilla_item": "Small Key (Dancing Dragon Dungeon)",
        "dungeon": 4,
        "flag_byte": 0xc964,
        "room": 0x0464,
        "collect": COLLECT_CHEST,
        "map_tile": 0x1d,
    },
    "Dancing Dragon Dungeon (1F): Crumbling Room Chest": {
        "region_id": "d4 cracked floor room",
        "vanilla_item": "Progressive Slingshot",
        "dungeon": 4,
        "flag_byte": 0xc973,
        "room": 0x0473,
        "collect": COLLECT_CHEST,
        "map_tile": 0x1d,
    },
    "Dancing Dragon Dungeon (1F): Eye Diving Spot Item": {
        "region_id": "d4 dive spot",
        "vanilla_item": "Boss Key (Dancing Dragon Dungeon)",
        "dungeon": 4,
        "flag_byte": 0xc96c,
        "room": 0x046c,
        "collect": COLLECT_DIVE,
        "map_tile": 0x1d,
        "symbolic_name": "d4DiveSpot",
    },
    "Dancing Dragon Dungeon (B1F): Boss Reward": {
        "region_id": "d4 boss",
        "vanilla_item": "Heart Container",
        "dungeon": 4,
        "flag_byte": 0xc95f,
        "room": 0x045f,
        "collect": COLLECT_POOF,
        "map_tile": 0x1d,
        "symbolic_name": "d4Boss"
    },

    "Unicorn's Cave: Right Cart Chest": {
        "region_id": "d5 cart chest",
        "vanilla_item": "Small Key (Unicorn's Cave)",
        "dungeon": 5,
        "flag_byte": 0xc999,
        "room": 0x0499,
        "collect": COLLECT_CHEST,
        "map_tile": 0x8a,
    },
    "Unicorn's Cave: Chest Left from Entrance": {
        "region_id": "d5 left chest",
        "vanilla_item": "Small Key (Unicorn's Cave)",
        "dungeon": 5,
        "flag_byte": 0xc9a3,
        "room": 0x04a3,
        "collect": COLLECT_CHEST,
        "map_tile": 0x8a,
    },
    "Unicorn's Cave: Magnet Gloves Chest": {
        "region_id": "d5 magnet ball chest",
        "vanilla_item": "Magnetic Gloves",
        "dungeon": 5,
        "flag_byte": 0xc989,
        "room": 0x0489,
        "collect": COLLECT_CHEST,
        "map_tile": 0x8a,
    },
    "Unicorn's Cave: Terrace Chest": {
        "region_id": "d5 terrace chest",
        "vanilla_item": "Rupees (100)",
        "dungeon": 5,
        "flag_byte": 0xc997,
        "room": 0x0497,
        "collect": COLLECT_CHEST,
        "map_tile": 0x8a,
    },
    "Unicorn's Cave: Armos Puzzle Room Chest": {
        "region_id": "d5 armos chest",
        "vanilla_item": "Small Key (Unicorn's Cave)",
        "dungeon": 5,
        "flag_byte": 0xc991,
        "room": 0x0491,
        "collect": COLLECT_D5_ARMOS_PUZZLE,
        "map_tile": 0x8a,
        "symbolic_name": "d5ArmosChest",
    },
    "Unicorn's Cave: Gibdo Room Chest": {
        "region_id": "d5 gibdo/zol chest",
        "vanilla_item": "Dungeon Map (Unicorn's Cave)",
        "dungeon": 5,
        "flag_byte": 0xc98f,
        "room": 0x048f,
        "collect": COLLECT_CHEST,
        "map_tile": 0x8a,
    },
    "Unicorn's Cave: Quicksand Spiral Chest": {
        "region_id": "d5 spiral chest",
        "vanilla_item": "Compass (Unicorn's Cave)",
        "dungeon": 5,
        "flag_byte": 0xc99d,
        "room": 0x049d,
        "collect": COLLECT_CHEST,
        "map_tile": 0x8a,
    },
    "Unicorn's Cave: Magnet Spinner Chest": {
        "region_id": "d5 spinner chest",
        "vanilla_item": "Small Key (Unicorn's Cave)",
        "dungeon": 5,
        "flag_byte": 0xc99f,
        "room": 0x049f,
        "collect": COLLECT_CHEST,
        "map_tile": 0x8a,
    },
    "Unicorn's Cave: Chest in Right Half of Minecart Bay Room": {
        "region_id": "d5 stalfos room",
        "vanilla_item": "Small Key (Unicorn's Cave)",
        "dungeon": 5,
        "flag_byte": 0xc9a5,
        "room": 0x04a5,
        "collect": COLLECT_CHEST,
        "map_tile": 0x8a,
    },
    "Unicorn's Cave: Treadmills Basement Item": {
        "region_id": "d5 basement",
        "vanilla_item": "Boss Key (Unicorn's Cave)",
        "dungeon": 5,
        "flag_byte": 0xc98b,
        "room": 0x068b,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x8a,
        "symbolic_name": "d5Basement",
    },
    "Unicorn's Cave: Boss Reward": {
        "region_id": "d5 boss",
        "vanilla_item": "Heart Container",
        "dungeon": 5,
        "flag_byte": 0xc98c,
        "room": 0x048c,
        "collect": COLLECT_POOF,
        "map_tile": 0x8a,
        "symbolic_name": "d5Boss"
    },

    "Ancient Ruins (1F): Magnet Ball Puzzle Drop": {
        "region_id": "d6 magnet ball drop",
        "vanilla_item": "Small Key (Ancient Ruins)",
        "dungeon": 6,
        "flag_byte": 0xc9ab,
        "room": 0x04ab,
        "collect": COLLECT_DROP,
        "map_tile": 0x00,
        "symbolic_name": "d6MagnetBallDrop",
    },
    "Ancient Ruins (2F): Chest North of Main Spinner": {
        "region_id": "d6 spinner north",
        "vanilla_item": "Small Key (Ancient Ruins)",
        "dungeon": 6,
        "flag_byte": 0xc9c2,
        "room": 0x04c2,
        "collect": COLLECT_CHEST,
        "map_tile": 0x00,
    },
    "Ancient Ruins (3F): Armos Hall Chest": {
        "region_id": "d6 armos hall",
        "vanilla_item": "Progressive Boomerang",
        "dungeon": 6,
        "flag_byte": 0xc9d0,
        "room": 0x04d0,
        "collect": COLLECT_CHEST,
        "map_tile": 0x00,
    },
    "Ancient Ruins (1F): Crystal Maze Room Chest": {
        "region_id": "d6 crystal trap room",
        "vanilla_item": "Rupees (10)",
        "dungeon": 6,
        "flag_byte": 0xc9af,
        "room": 0x04af,
        "collect": COLLECT_CHEST,
        "map_tile": 0x00,
    },
    "Ancient Ruins (1F): Crumbling Ground Room Chest": {
        "region_id": "d6 1F east",
        "vanilla_item": "Rupees (5)",
        "dungeon": 6,
        "flag_byte": 0xc9b3,
        "room": 0x04b3,
        "collect": COLLECT_CHEST,
        "map_tile": 0x00,
    },
    "Ancient Ruins (2F): Chest in Gibdo Room": {
        "region_id": "d6 2F gibdo chest",
        "vanilla_item": "Bombs (10)",
        "dungeon": 6,
        "flag_byte": 0xc9bf,
        "room": 0x04bf,
        "collect": COLLECT_CHEST,
        "map_tile": 0x00,
    },
    "Ancient Ruins (2F): Chest Between 4 Armos": {
        "region_id": "d6 2F armos chest",
        "vanilla_item": "Rupees (5)",
        "dungeon": 6,
        "flag_byte": 0xc9c3,
        "room": 0x04c3,
        "collect": COLLECT_CHEST,
        "map_tile": 0x00,
    },
    "Ancient Ruins (1F): Chest in Beamos Room": {
        "region_id": "d6 beamos room",
        "vanilla_item": "Compass (Ancient Ruins)",
        "dungeon": 6,
        "flag_byte": 0xc9ad,
        "room": 0x04ad,
        "collect": COLLECT_CHEST,
        "map_tile": 0x00,
    },
    "Ancient Ruins (1F): Chest on Terrace Left of Entrance": {
        "region_id": "d6 1F terrace",
        "vanilla_item": "Dungeon Map (Ancient Ruins)",
        "dungeon": 6,
        "flag_byte": 0xc9b0,
        "room": 0x04b0,
        "collect": COLLECT_CHEST,
        "map_tile": 0x00,
    },
    "Ancient Ruins (2F): Chest After Time Trial": {
        "region_id": "d6 escape room",
        "vanilla_item": "Boss Key (Ancient Ruins)",
        "dungeon": 6,
        "flag_byte": 0xc9c4,
        "room": 0x04c4,
        "collect": COLLECT_CHEST,
        "map_tile": 0x00,
    },
    "Ancient Ruins (2F): Chest on Red Terrace Before Vire": {
        "region_id": "d6 vire chest",
        "vanilla_item": "Small Key (Ancient Ruins)",
        "dungeon": 6,
        "flag_byte": 0xc9c1,
        "room": 0x04c1,
        "collect": COLLECT_CHEST,
        "map_tile": 0x00,
    },
    "Ancient Ruins (5F): Boss Reward": {
        "region_id": "d6 boss",
        "vanilla_item": "Heart Container",
        "dungeon": 6,
        "flag_byte": 0xc9d5,
        "room": 0x04d5,
        "collect": COLLECT_POOF,
        "map_tile": 0x00,
        "symbolic_name": "d6Boss"
    },

    "Explorer's Crypt (1F): Chest in Wizzrobe Room": {
        "region_id": "d7 wizzrobe chest",
        "vanilla_item": "Small Key (Explorer's Crypt)",
        "dungeon": 7,
        "flag_byte": 0xca54,
        "room": 0x0554,
        "collect": COLLECT_CHEST,
        "map_tile": 0xd0,
    },
    "Explorer's Crypt (B1F): Chest in Fast Moving Platform Room": {
        "region_id": "d7 spike chest",
        "vanilla_item": "Progressive Feather",
        "dungeon": 7,
        "flag_byte": 0xca44,
        "room": 0x0544,
        "collect": COLLECT_CHEST,
        "map_tile": 0xd0,
    },
    "Explorer's Crypt (B2F): Stair Maze Chest": {
        "region_id": "d7 maze chest",
        "vanilla_item": "Rupees (1)",
        "dungeon": 7,
        "flag_byte": 0xca43,
        "room": 0x0543,
        "collect": COLLECT_CHEST,
        "map_tile": 0xd0,
    },
    "Explorer's Crypt (1F): Chest Right of Entrance": {
        "region_id": "d7 right of entrance",
        "vanilla_item": "Power Ring L-1",
        "dungeon": 7,
        "flag_byte": 0xca5a,
        "room": 0x055a,
        "collect": COLLECT_CHEST,
        "map_tile": 0xd0,
    },
    "Explorer's Crypt (1F): Chest Behind Cracked Wall": {
        "region_id": "d7 bombed wall chest",
        "vanilla_item": "Compass (Explorer's Crypt)",
        "dungeon": 7,
        "flag_byte": 0xca52,
        "room": 0x0552,
        "collect": COLLECT_POE_SKIP_ROOM,
        "is_chest": True,
        "map_tile": 0xd0,
    },
    "Explorer's Crypt (B1F): Zol Button Drop": {
        "region_id": "d7 zol button",
        "vanilla_item": "Small Key (Explorer's Crypt)",
        "dungeon": 7,
        "flag_byte": 0xca45,
        "room": 0x0545,
        "collect": COLLECT_DROP,
        "map_tile": 0xd0,
        "symbolic_name": "d7ZolButton",
    },
    "Explorer's Crypt (B2F): Armos Puzzle Drop": {
        "region_id": "d7 armos puzzle",
        "vanilla_item": "Small Key (Explorer's Crypt)",
        "dungeon": 7,
        "flag_byte": 0xca35,
        "room": 0x0535,
        "collect": COLLECT_DROP,
        "map_tile": 0xd0,
        "symbolic_name": "d7ArmosPuzzle",
    },
    "Explorer's Crypt (B1F): Chest Connected to Magnet Ball Button": {
        "region_id": "d7 magunesu chest",
        "vanilla_item": "Small Key (Explorer's Crypt)",
        "dungeon": 7,
        "flag_byte": 0xca47,
        "room": 0x0547,
        "collect": COLLECT_CHEST,
        "map_tile": 0xd0,
    },
    "Explorer's Crypt (1F): Chest Above Trampoline Near 2nd Poe": {
        "region_id": "d7 quicksand chest",
        "vanilla_item": "Dungeon Map (Explorer's Crypt)",
        "dungeon": 7,
        "flag_byte": 0xca58,
        "room": 0x0558,
        "collect": COLLECT_CHEST,
        "map_tile": 0xd0,
    },
    "Explorer's Crypt (B2F): Drop in Room North of Stair Maze": {
        "region_id": "d7 B2F drop",
        "vanilla_item": "Small Key (Explorer's Crypt)",
        "dungeon": 7,
        "flag_byte": 0xca3d,
        "room": 0x053d,
        "collect": COLLECT_DROP,
        "map_tile": 0xd0,
        "symbolic_name": "d7DropNorthOfStairMaze",
    },
    "Explorer's Crypt (B1F): Chest in Jumping Stalfos Room": {
        "region_id": "d7 stalfos chest",
        "vanilla_item": "Boss Key (Explorer's Crypt)",
        "dungeon": 7,
        "flag_byte": 0xca48,
        "room": 0x0548,
        "collect": COLLECT_CHEST,
        "map_tile": 0xd0,
    },
    "Explorer's Crypt (B1F): Boss Reward": {
        "region_id": "d7 boss",
        "vanilla_item": "Heart Container",
        "dungeon": 7,
        "flag_byte": 0xca50,
        "room": 0x0550,
        "collect": COLLECT_POOF,
        "map_tile": 0xd0,
        "symbolic_name": "d7Boss"
    },

    "Sword & Shield Dungeon (1F): Eye Drop Near Entrance": {
        "region_id": "d8 eye drop",
        "vanilla_item": "Small Key (Sword & Shield Dungeon)",
        "dungeon": 8,
        "flag_byte": 0xca82,
        "room": 0x0582,
        "collect": COLLECT_DROP,
        "map_tile": 0x04,
        "symbolic_name": "d8EyeDrop",
    },
    "Sword & Shield Dungeon (1F): Three Eyes Chest": {
        "region_id": "d8 three eyes chest",
        "vanilla_item": "Steadfast Ring",
        "dungeon": 8,
        "flag_byte": 0xca7d,
        "room": 0x057d,
        "collect": COLLECT_CHEST,
        "map_tile": 0x04,
    },
    "Sword & Shield Dungeon (1F): Drop in Hardhat & Magnet Ball Room": {
        "region_id": "d8 hardhat drop",
        "vanilla_item": "Small Key (Sword & Shield Dungeon)",
        "dungeon": 8,
        "flag_byte": 0xca75,
        "room": 0x0575,
        "collect": COLLECT_DROP,
        "map_tile": 0x04,
        "symbolic_name": "d8HardhatDrop",
    },
    "Sword & Shield Dungeon (1F): U-Shaped Spiky Freezer Chest": {
        "region_id": "d8 spike room",
        "vanilla_item": "Compass (Sword & Shield Dungeon)",
        "dungeon": 8,
        "flag_byte": 0xca8b,
        "room": 0x058b,
        "collect": COLLECT_CHEST,
        "map_tile": 0x04,
    },
    "Sword & Shield Dungeon (B1F): Chest Right of Spinner": {
        "region_id": "d8 spinner chest",
        "vanilla_item": "Small Key (Sword & Shield Dungeon)",
        "dungeon": 8,
        "flag_byte": 0xca70,
        "room": 0x0570,
        "collect": COLLECT_CHEST,
        "map_tile": 0x04,
    },
    "Sword & Shield Dungeon (1F): Top Chest in Lava Bridge Room": {
        "region_id": "d8 armos chest",
        "vanilla_item": "Progressive Slingshot",
        "dungeon": 8,
        "flag_byte": 0xca8d,
        "room": 0x058d,
        "collect": COLLECT_CHEST,
        "map_tile": 0x04,
    },
    "Sword & Shield Dungeon (1F): Bottom Chest in Lava Bridge Room": {
        "region_id": "d8 magnet ball room",
        "vanilla_item": "Dungeon Map (Sword & Shield Dungeon)",
        "dungeon": 8,
        "flag_byte": 0xca8e,
        "room": 0x058e,
        "collect": COLLECT_CHEST,
        "map_tile": 0x04,
    },
    "Sword & Shield Dungeon (1F): Chest in Bombable Blocks Room": {
        "region_id": "d8 darknut chest",
        "vanilla_item": "Small Key (Sword & Shield Dungeon)",
        "dungeon": 8,
        "flag_byte": 0xca8c,
        "room": 0x058c,
        "collect": COLLECT_CHEST,
        "map_tile": 0x04,
    },
    "Sword & Shield Dungeon (1F): Chest on Terrace After Pols Voice Room": {
        "region_id": "d8 pols voice chest",
        "vanilla_item": "Boss Key (Sword & Shield Dungeon)",
        "dungeon": 8,
        "flag_byte": 0xca80,
        "room": 0x0580,
        "collect": COLLECT_CHEST,
        "map_tile": 0x04,
    },
    "Sword & Shield Dungeon (1F): Ghost Armos Puzzle Drop": {
        "region_id": "d8 ghost armos drop",
        "vanilla_item": "Small Key (Sword & Shield Dungeon)",
        "dungeon": 8,
        "flag_byte": 0xca7f,
        "room": 0x057f,
        "collect": COLLECT_DROP,
        "map_tile": 0x04,
        "symbolic_name": "d8GhostArmosDrop",
    },
    "Sword & Shield Dungeon (B1F): Southeast Lava Chest": {
        "region_id": "d8 SE lava chest",
        "vanilla_item": "Small Key (Sword & Shield Dungeon)",
        "dungeon": 8,
        "flag_byte": 0xca6b,
        "room": 0x056b,
        "collect": COLLECT_CHEST,
        "map_tile": 0x04,
    },
    "Sword & Shield Dungeon (B1F): Southwest Lava Chest": {
        "region_id": "d8 SW lava chest",
        "vanilla_item": "Bombs (10)",
        "dungeon": 8,
        "flag_byte": 0xca6a,
        "room": 0x056a,
        "collect": COLLECT_CHEST,
        "map_tile": 0x04,
    },
    "Sword & Shield Dungeon (1F): Chest in Sparks & Pots Room": {
        "region_id": "d8 spark chest",
        "vanilla_item": "Small Key (Sword & Shield Dungeon)",
        "dungeon": 8,
        "flag_byte": 0xca8a,
        "room": 0x058a,
        "collect": COLLECT_CHEST,
        "map_tile": 0x04,
    },
    "Sword & Shield Dungeon (B1F): Boss Reward": {
        "region_id": "d8 boss",
        "vanilla_item": "Heart Container",
        "dungeon": 8,
        "flag_byte": 0xca64,
        "room": 0x0564,
        "collect": COLLECT_POOF,
        "map_tile": 0x04,
        "symbolic_name": "d8Boss"
    },

    "Horon Village: Item Behind Small Tree": {
        "region_id": "horon heart piece",
        "vanilla_item": "Piece of Heart",
        "flag_byte": 0xc7d8,
        "room": 0x00d8,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "horonHeartPiece",
    },
    "Woods of Winter: Item Below Lake": {
        "region_id": "woods of winter heart piece",
        "vanilla_item": "Piece of Heart",
        "flag_byte": 0xc7af,
        "room": 0x00af,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "woodsOfWinterHeartPiece",
    },
    "Mt. Cucco: Item on Ledge": {
        "region_id": "mt. cucco heart piece",
        "vanilla_item": "Piece of Heart",
        "flag_byte": 0xc72d,
        "room": 0x002d,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "mtCuccoHeartPiece",
    },
    "Eastern Suburbs: Item in Windmill Cave": {
        "region_id": "windmill heart piece",
        "vanilla_item": "Piece of Heart",
        "flag_byte": 0xcab2,
        "room": 0x05b2,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xea,
        "symbolic_name": "windmillHeartPiece",
    },
    "Western Coast: Item in Graveyard": {
        "region_id": "graveyard heart piece",
        "vanilla_item": "Piece of Heart",
        "flag_byte": 0xc7d1,
        "room": 0x00d1,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "graveyardHeartPiece",
    },
    "Spool Swamp: Item Amidst Currents in Spring": {
        "region_id": "spool swamp heart piece",
        "vanilla_item": "Piece of Heart",
        "flag_byte": 0xc7b1,
        "room": 0x00b1,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "spoolSwampHeartPiece",
    },
    "Temple Remains: Item in Cave Behind Rockslide": {
        "region_id": "temple remains heart piece",
        "vanilla_item": "Piece of Heart",
        "flag_byte": 0xcac7,
        "room": 0x05c7,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x15,
        "symbolic_name": "templeRemainsHeartPiece",
    },
    "Horon Village: Item Behind Cracked Wall in Mayor's House": {
        "region_id": "mayor's house secret room",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xc887,
        "room": 0x0387,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xc8,
        "symbolic_name": "mayorsHouseSecretRoom",
    },
    "Subrosia: Item in House Above Strange Brothers Portal": {
        "region_id": "subrosian house",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xc8a1,
        "room": 0x03a1,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x1e,
        "symbolic_name": "subrosianHouse",
    },
    "Subrosia: Item in Basement to Tower of Spring": {
        "region_id": "subrosian 2d cave",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xcae3,
        "room": 0x07e3,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x1e,
        "symbolic_name": "subrosian2dCave",
    },

    "Horon Village: Mayor's Gift": {
        "region_id": "mayor's gift",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xc886,
        "room": 0x0386,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xc8,
        "symbolic_name": "mayorGift",
    },
    "Horon Village: Vasu's Gift": {
        "region_id": "vasu's gift",
        "vanilla_item": "Friendship Ring",
        "flag_byte": 0xc891,
        "room": 0x0391,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xe8,
        "symbolic_name": "vasuGift"
    },
    "Goron Mountain: Lonely Goron's Gift": {
        "region_id": "goron's gift",
        "vanilla_item": "Biggoron's Sword",  # Ring Box doesn't really exist anymore
        "flag_byte": 0xcac5,
        "room": 0x05c5,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x19,
        "symbolic_name": "goronGift",
    },

    "Horon Village: Dr. Left Reward": {
        "region_id": "dr. left reward",
        "vanilla_item": "Cuccodex",
        "flag_byte": 0xc8a4,
        "room": 0x03a4,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xf9,
        "symbolic_name": "drLeftReward",
    },
    "North Horon: Malon Trade": {
        "region_id": "malon trade",
        "vanilla_item": "Lon Lon Egg",
        "flag_byte": 0xc880,
        "room": 0x0380,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x88,
        "symbolic_name": "malonTrade",
    },
    "Maple Trade": {
        "region_id": "maple trade",
        "vanilla_item": "Ghastly Doll",
        "flag_byte": 0xc640,
        "bit_mask": 0x08,
        "room": [],
        "symbolic_name": "mapleTrade",
    },
    "Holodrum Plain: Mrs. Ruul Trade": {
        "region_id": "mrs. ruul trade",
        "vanilla_item": "Iron Pot",
        "flag_byte": 0xc8b3,
        "room": 0x03b3,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xa3,
        "symbolic_name": "mrsRuulTrade",
    },
    "Subrosia: Subrosian Chef Trade": {
        "region_id": "subrosian chef trade",
        "vanilla_item": "Lava Soup",
        "flag_byte": 0xc88f,
        "room": 0x038f,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x9a,
        "symbolic_name": "subrosianChefTrade",
    },
    "Goron Mountain: Biggoron Trade": {
        "region_id": "biggoron trade",
        "vanilla_item": "Goron Vase",
        "flag_byte": 0xc708,
        "bit_mask": 0x40,
        "room": 0x0008,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "biggoronTrade",
    },
    "Sunken City: Ingo Trade": {
        "region_id": "ingo trade",
        "vanilla_item": "Fish",
        "flag_byte": 0xc899,
        "room": 0x0399,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x4d,
        "symbolic_name": "ingoTrade",
    },
    "North Horon: Yelling Old Man Trade": {
        "region_id": "old man trade",
        "vanilla_item": "Megaphone",
        "flag_byte": 0xc7b7,
        "room": 0x00b7,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "yellingOldManTrade",
    },
    "Mt. Cucco: Talon Trade": {
        "region_id": "talon trade",
        "vanilla_item": "Mushroom",
        "flag_byte": 0xcab6,
        "bit_mask": 0x40,
        "room": 0x05b6,
        "map_tile": 0x1b,
        "symbolic_name": "talonTrade",
    },
    "Sunken City: Syrup Trade": {
        "region_id": "syrup trade",
        "vanilla_item": "Wooden Bird",
        "flag_byte": 0xc89c,
        "room": 0x039c,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x5e,
        "symbolic_name": "syrupTrade",
    },
    "Horon Village: Tick Tock Trade": {
        "region_id": "tick tock trade",
        "vanilla_item": "Engine Grease",
        "flag_byte": 0xc883,
        "room": 0x0383,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xd7,
        "symbolic_name": "tickTockTrade",
    },
    "Eastern Suburbs: Guru-Guru Trade": {
        "region_id": "guru-guru trade",
        "vanilla_item": "Phonograph",
        "flag_byte": 0xc7da,
        "room": 0x00da,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "guruguruTrade",
    },

    "Subrosia: Buried Bomb Flower": {
        "region_id": "subrosian buried bomb flower",
        "vanilla_item": "Bomb Flower",
        "flag_byte": 0xc869,
        "room": 0x0169,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xb9,
        "symbolic_name": "bombFlower",
    },
    "Subrosia: Sign-Loving Guy Reward": {
        "region_id": "subrosian sign guy",
        "vanilla_item": "Sign Ring",
        "flag_byte": 0xc8a9,
        "room": 0x03a9,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xb9,
        "symbolic_name": "subrosianSignLovingGuy",
    },
    # Maku seed is 0xC85D

    "Horon Village: Old Man": {
        "region_id": "old man in horon",
        "flag_byte": 0xca05,
        "bit_mask": 0x40,
        "vanilla_item": "Filler Item",
        "conditional": True,
        "room": 0x0505,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xf9,
        "symbolic_name": "oldManHoronVillage",
    },
    "North Horon: Old Man Near D1": {
        "region_id": "old man near d1",
        "flag_byte": 0xca03,
        "bit_mask": 0x40,
        "vanilla_item": "Filler Item",
        "conditional": True,
        "room": 0x0503,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x97,
        "symbolic_name": "oldManNearD1",
    },
    "Holodrum Plain: Old Man Near Blaino's Gym": {
        "region_id": "old man near blaino",
        "flag_byte": 0xca02,
        "bit_mask": 0x40,
        "vanilla_item": "Filler Item",
        "conditional": True,
        "room": 0x0502,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x76,
        "symbolic_name": "oldManNearBlaino",
    },
    "Goron Mountain: Old Man": {
        "region_id": "old man in goron mountain",
        "flag_byte": 0xca01,
        "bit_mask": 0x40,
        "vanilla_item": "Filler Item",
        "conditional": True,
        "room": 0x0501,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x28,
        "symbolic_name": "oldManGoronMountain",
    },
    "Western Coast: Old Man": {
        "region_id": "old man near western coast house",
        "flag_byte": 0xca04,
        "bit_mask": 0x40,
        "vanilla_item": "Filler Item",
        "conditional": True,
        "room": 0x0504,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xd2,
        "symbolic_name": "oldManWesternCoast",
    },
    "Woods of Winter: Old Man": {
        "region_id": "old man near holly's house",
        "flag_byte": 0xca07,
        "bit_mask": 0x40,
        "vanilla_item": "Filler Item",
        "conditional": True,
        "room": 0x0507,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x8f,
        "symbolic_name": "oldManWoodsOfWinter",
    },
    "Holodrum Plain: Old Man Near Mrs. Ruul's House": {
        "region_id": "old man near mrs. ruul",
        "flag_byte": 0xca08,
        "bit_mask": 0x40,
        "vanilla_item": "Filler Item",
        "conditional": True,
        "room": 0x0508,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xa4,
        "symbolic_name": "oldManGhastlyStump",
    },
    "Tarm Ruins: Old Man Near D6": {
        "region_id": "old man near d6",
        "flag_byte": 0xca06,
        "bit_mask": 0x40,
        "vanilla_item": "Filler Item",
        "conditional": True,
        "room": 0x0506,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x02,
        "symbolic_name": "oldManTarmRuins",
    },

    "North Horon: Golden Beasts Old Man": {
        "region_id": "golden beasts old man",
        "vanilla_item": "Red Ring",
        "flag_byte": 0xca11,
        "room": 0x0511,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xa6,
        "symbolic_name": "goldenBeastsOldMan",
    },

    "Horon Village: Seed Tree": {
        "region_id": "horon village tree",
        "local": True,
        "flag_byte": 0xc7f8,
        "room": 0x00f8,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "horonVillageSeedTree",
    },
    "Woods of Winter: Seed Tree": {
        "region_id": "woods of winter tree",
        "local": True,
        "flag_byte": 0xc79e,
        "room": 0x009e,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "woodsOfWinterSeedTree",
    },
    "Holodrum Plain: Seed Tree": {
        "region_id": "north horon tree",
        "local": True,
        "flag_byte": 0xc767,
        "room": 0x0067,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "northHoronSeedTree",
    },
    "Spool Swamp: Seed Tree": {
        "region_id": "spool swamp tree",
        "local": True,
        "flag_byte": 0xc772,
        "room": 0x0072,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "spoolSwampSeedTree",
    },
    "Sunken City: Seed Tree": {
        "region_id": "sunken city tree",
        "local": True,
        "flag_byte": 0xc75f,
        "room": 0x005f,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "sunkenCitySeedTree",
    },
    "Tarm Ruins: Seed Tree": {
        "region_id": "tarm ruins tree",
        "local": True,
        "flag_byte": 0xc710,
        "room": 0x0010,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "tarmRuinsSeedTree",
    },

    "Gnarled Root Dungeon: Essence": {
        "region_id": "d1 boss",
        "dungeon": 1,
        "flag_byte": 0xc913,
        "room": 0x0413,
        "vanilla_item": "Fertile Soil",
        "essence": True,
        "symbolic_name": "essenceD1",
    },
    "Snake's Remains: Essence": {
        "region_id": "d2 boss",
        "dungeon": 2,
        "flag_byte": 0xc92c,
        "room": 0x042c,
        "vanilla_item": "Gift of Time",
        "essence": True,
        "symbolic_name": "essenceD2",
    },
    "Poison Moth's Lair: Essence": {
        "region_id": "d3 boss",
        "dungeon": 3,
        "flag_byte": 0xc940,
        "room": 0x0440,
        "vanilla_item": "Bright Sun",
        "essence": True,
        "symbolic_name": "essenceD3",
    },
    "Dancing Dragon Dungeon: Essence": {
        "region_id": "d4 boss",
        "dungeon": 4,
        "flag_byte": 0xc960,
        "room": 0x0460,
        "vanilla_item": "Soothing Rain",
        "essence": True,
        "symbolic_name": "essenceD4",
    },
    "Unicorn's Cave: Essence": {
        "region_id": "d5 boss",
        "dungeon": 5,
        "flag_byte": 0xc988,
        "room": 0x0488,
        "vanilla_item": "Nurturing Warmth",
        "essence": True,
        "symbolic_name": "essenceD5",
    },
    "Ancient Ruins: Essence": {
        "region_id": "d6 boss",
        "dungeon": 6,
        "flag_byte": 0xc898,
        "room": 0x0398,
        "vanilla_item": "Blowing Wind",
        "essence": True,
        "symbolic_name": "essenceD6",
    },
    "Explorer's Crypt: Essence": {
        "region_id": "d7 boss",
        "dungeon": 7,
        "flag_byte": 0xca4f,
        "room": 0x054f,
        "vanilla_item": "Seed of Life",
        "essence": True,
        "symbolic_name": "essenceD7",
    },
    "Sword & Shield Dungeon: Essence": {
        "region_id": "d8 boss",
        "dungeon": 8,
        "flag_byte": 0xca5f,
        "room": 0x055f,
        "vanilla_item": "Changing Seasons",
        "essence": True,
        "symbolic_name": "essenceD8",
    },
    "Horon Village: Item Inside Maku Tree (3+ Essences)": {
        "region_id": "maku tree, 3 essences",
        "conditional": True,
        "flag_byte": 0xc9e9,
        "vanilla_item": "Gasha Seed",
        "room": 0x04e9,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xc9,
        "symbolic_name": "makuTree3Essences",
    },
    "Horon Village: Item Inside Maku Tree (5+ Essences)": {
        "region_id": "maku tree, 5 essences",
        "conditional": True,
        "flag_byte": 0xc9ea,
        "vanilla_item": "Gasha Seed",
        "room": 0x04ea,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xc9,
        "symbolic_name": "makuTree5Essences",
    },
    "Horon Village: Item Inside Maku Tree (7+ Essences)": {
        "region_id": "maku tree, 7 essences",
        "conditional": True,
        "flag_byte": 0xc9ee,
        "vanilla_item": "Gasha Seed",
        "room": 0x04ee,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xc9,
        "symbolic_name": "makuTree7Essences",
    },

    "Subrosia: Strange Brothers' Backyard Treasure": {
        "region_id": "subrosia hide and seek",
        "vanilla_item": "Ore Chunks (50)",
        "flag_byte": 0xc860,
        "room": 0x0160,
        "collect": COLLECT_DIG,
        "map_tile": 0x1e,
        "symbolic_name": "subrosiaHideAndSeek",
    },
    "Subrosia: Hot Bath Digging Spot": {
        "region_id": "subrosia bath digging spot",
        "vanilla_item": "Ore Chunks (50)",
        "conditional": True,
        "flag_byte": 0xc806,
        "room": 0x0106,
        "collect": COLLECT_DIG,
        "map_tile": 0x1e,
        "symbolic_name": "subrosiaBathOreDiggingSpot",
    },
    "Subrosia: Market Portal Digging Spot": {
        "region_id": "subrosia market digging spot",
        "vanilla_item": "Ore Chunks (50)",
        "conditional": True,
        "flag_byte": 0xc857,
        "room": 0x0157,
        "collect": COLLECT_DIG,
        "map_tile": 0xb0,
        "symbolic_name": "subrosiaMarketPortalOreDiggingSpot",
    },
    "Subrosia: Hard-Working Subrosian Digging Spot": {
        "region_id": "subrosia market digging spot",
        "vanilla_item": "Ore Chunks (50)",
        "conditional": True,
        "flag_byte": 0xc847,
        "room": 0x0147,
        "collect": COLLECT_DIG,
        "map_tile": 0xb0,
        "symbolic_name": "subrosiaWorkerOreDiggingSpot",
    },
    "Subrosia: Temple of Seasons Digging Spot": {
        "region_id": "subrosia temple digging spot",
        "vanilla_item": "Ore Chunks (50)",
        "conditional": True,
        "flag_byte": 0xc83a,
        "room": 0x013a,
        "collect": COLLECT_DIG,
        "map_tile": 0x1e,
        "symbolic_name": "subrosiaTempleOreDiggingSpot",
    },
    "Subrosia: Northern Volcanoes Digging Spot": {
        "region_id": "subrosia temple digging spot",
        "vanilla_item": "Ore Chunks (50)",
        "conditional": True,
        "flag_byte": 0xc807,
        "room": 0x0107,
        "collect": COLLECT_DIG,
        "map_tile": 0x1e,
        "symbolic_name": "subrosiaNorthernVolcanoesOreDiggingSpot",
    },
    "Subrosia: D8 Portal Digging Spot": {
        "region_id": "subrosia bridge digging spot",
        "vanilla_item": "Ore Chunks (50)",
        "conditional": True,
        "flag_byte": 0xc820,
        "room": 0x0120,
        "collect": COLLECT_DIG,
        "map_tile": 0x1e,
        "symbolic_name": "subrosiaD8PortalOreDiggingSpot",
    },
    "Subrosia: Western Volcanoes Digging Spot": {
        "region_id": "subrosia bridge digging spot",
        "vanilla_item": "Ore Chunks (50)",
        "conditional": True,
        "flag_byte": 0xc842,
        "room": 0x0142,
        "collect": COLLECT_DIG,
        "map_tile": 0x1e,
        "symbolic_name": "subrosiaWesternVolcanoesOreDiggingSpot",
    },
    "Gasha Nut #1": {
        "region_id": "gasha tree 1",
        "vanilla_item": "Piece of Heart",
        "conditional": True,
        "id": 0xC64900,
        "room": [],
    },
    "Gasha Nut #2": {
        "region_id": "gasha tree 2",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "id": 0xC64901,
        "room": [],
    },
    "Gasha Nut #3": {
        "region_id": "gasha tree 3",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "id": 0xC64902,
        "room": [],
    },
    "Gasha Nut #4": {
        "region_id": "gasha tree 4",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "id": 0xC64903,
        "room": [],
    },
    "Gasha Nut #5": {
        "region_id": "gasha tree 5",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "id": 0xC64904,
        "room": [],
    },
    "Gasha Nut #6": {
        "region_id": "gasha tree 6",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "id": 0xC64905,
        "room": [],
    },
    "Gasha Nut #7": {
        "region_id": "gasha tree 7",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "id": 0xC64906,
        "room": [],
    },
    "Gasha Nut #8": {
        "region_id": "gasha tree 8",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "id": 0xC64907,
        "room": [],
    },
    "Gasha Nut #9": {
        "region_id": "gasha tree 9",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "id": 0xC64908,
        "room": [],
    },
    "Gasha Nut #10": {
        "region_id": "gasha tree 10",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "id": 0xC64909,
        "room": [],
    },
    "Gasha Nut #11": {
        "region_id": "gasha tree 11",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "id": 0xC6490A,
        "room": [],
    },
    "Gasha Nut #12": {
        "region_id": "gasha tree 12",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "id": 0xC6490B,
        "room": [],
    },
    "Gasha Nut #13": {
        "region_id": "gasha tree 13",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "id": 0xC6490C,
        "room": [],
    },
    "Gasha Nut #14": {
        "region_id": "gasha tree 14",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "id": 0xC6490D,
        "room": [],
    },
    "Gasha Nut #15": {
        "region_id": "gasha tree 15",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "id": 0xC6490E,
        "room": [],
    },
    "Gasha Nut #16": {
        "region_id": "gasha tree 16",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "id": 0xC6490F,
        "room": [],
    },
    "Spool Swamp: Business Scrub": {
        "region_id": "spool swamp scrub",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "flag_byte": 0xc63f,
        "bit_mask": 0x04,
        "scouting_byte": 0xc780,
        "room": 0x0080,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x80,
        "symbolic_name": "spoolSwampScrub",
    },
    "Samasa Desert: Business Scrub": {
        "region_id": "samasa desert scrub",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "flag_byte": 0xc63f,
        "bit_mask": 0x10,
        "scouting_byte": 0xcad1,
        "room": 0x05d1,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xbf,
        "symbolic_name": "samasaCaveScrub",
    },
    "Snake's Remains: Business Scrub": {
        "region_id": "d2 scrub",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "dungeon": 2,
        "flag_byte": 0xc642,
        "bit_mask": 0x20,
        "scouting_byte": 0xc933,
        "room": 0x0433,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x8d,
        "symbolic_name": "d2Scrub",
    },
    "Dancing Dragon Dungeon (1F): Business Scrub": {
        "region_id": "d4 scrub",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "dungeon": 4,
        "flag_byte": 0xc642,
        "bit_mask": 0x40,
        "scouting_byte": 0xc963,
        "room": 0x0463,
        "collect": COLLECT_D4_SCRUB_ROOM,
        "map_tile": 0x1d,
        "symbolic_name": "d4Scrub",
    },

    # Linked locations
    "Horon Village: Clock Shop Secret": {
        "region_id": "clock shop secret",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "flag_byte": 0xc6d5,
        "bit_mask": 0x04,
        "room": 0x050f,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xd7,
        "symbolic_name": "clockSecret",
    },
    "Western Coast: Graveyard Secret": {
        "region_id": "graveyard secret",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "flag_byte": 0xc6d5,
        "bit_mask": 0x08,
        "room": 0x03ba,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xe0,
        "symbolic_name": "graveyardSecret",
    },
    "Subrosia: Subrosian Secret": {
        "region_id": "subrosian secret",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "flag_byte": 0xc6d5,
        "bit_mask": 0x10,
        "room": 0x04f0,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x9a,
        "symbolic_name": "subrosianSecret",
    },
    "Sunken City: Diver Secret": {
        "region_id": "diver secret",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "flag_byte": 0xc6d5,
        "bit_mask": 0x20,
        "room": 0x03b6,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x5d,
        "symbolic_name": "diverSecret",
    },
    "Subrosia: Smith Secret": {
        "region_id": "smith secret",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "flag_byte": 0xc6d5,
        "bit_mask": 0x40,
        "room": 0x0397,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x1e,
        "symbolic_name": "smithSecret",
    },
    "Subrosia: Piratian Secret": {
        "region_id": "pirates after bell",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "flag_byte": 0xc6d5,
        "bit_mask": 0x80,
        "room": 0x038b,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xf7,
        "symbolic_name": "pirateSecret",
    },
    "Subrosia: Temple Secret": {
        "region_id": "temple of seasons",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "flag_byte": 0xc6d6,
        "bit_mask": 0x01,
        "room": 0x03ad,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xb0,
        "symbolic_name": "templeSecret",
    },
    "Natzu Region: Deku Secret": {
        "region_id": "deku secret",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "flag_byte": 0xc6d6,
        "bit_mask": 0x02,
        "room": [0x050b, 0x050c, 0x050d],
        "collect": COLLECT_TOUCH,
        # "map_tile": ???,
        "symbolic_name": "dekuSecret",
    },
    "Goron Mountain: Biggoron Secret": {
        "region_id": "biggoron trade",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "flag_byte": 0xc6d6,
        "bit_mask": 0x04,
        "room": 0x0008,
        "collect": COLLECT_TOUCH,
        "map_tile": 0x08,
        "symbolic_name": "biggoronSecret",
    },
    "Horon Village: Mayor Secret": {
        "region_id": "mayor's gift",
        "vanilla_item": "Filler Item",
        "conditional": True,
        "flag_byte": 0xc6d6,
        "bit_mask": 0x08,
        "room": 0x0385,
        "collect": COLLECT_TOUCH,
        "map_tile": 0xc8,
        "symbolic_name": "mayorSecret",
    },

    # Placeholder locations for the owls
    "Dodongo Owl": {
        "region_id": None,
        "conditional": True,
        "owl_id": 0,
        "scouting_byte": 0xc928,
        "scouting_mask": 0x40,
        "room": 0x0428
    },
    "Gohma Owl": {
        "region_id": None,
        "conditional": True,
        "owl_id": 1,
        "scouting_byte": 0xc961,
        "scouting_mask": 0x40,
        "room": 0x0461
    },
    "Armos Owl": {
        "region_id": None,
        "conditional": True,
        "owl_id": 2,
        "scouting_byte": 0xc992,
        "scouting_mask": 0x40,
        "room": 0x0492
    },
    "Silent Watch Owl": {
        "region_id": None,
        "conditional": True,
        "owl_id": 3,
        "scouting_byte": 0xca73,
        "scouting_mask": 0x40,
        "room": 0x0573
    },
    "Magical Ice Owl": {
        "region_id": None,
        "conditional": True,
        "owl_id": 4,
        "scouting_byte": 0xca71,
        "scouting_mask": 0x40,
        "room": 0x0571
    },
    "Mystery Owl": {
        "region_id": None,
        "conditional": True,
        "owl_id": 5,
        "scouting_byte": 0xc79e,
        "scouting_mask": 0x40,
        "room": 0x009e
    },
    "Omuai Owl": {
        "region_id": None,
        "conditional": True,
        "owl_id": 6,
        "scouting_byte": 0xc949,
        "scouting_mask": 0x40,
        "room": 0x0449
    },
    "Poe Curse Owl": {
        "region_id": None,
        "conditional": True,
        "owl_id": 7,
        "scouting_byte": 0xca59,
        "scouting_mask": 0x40,
        "room": 0x0559
    },
    "Spiked Beetles Owl": {
        "region_id": None,
        "conditional": True,
        "owl_id": 8,
        "scouting_byte": 0xc946,
        "scouting_mask": 0x40,
        "room": 0x0446
    },
    "Trampoline Owl": {
        "region_id": None,
        "conditional": True,
        "owl_id": 9,
        "scouting_byte": 0xc93e,
        "scouting_mask": 0x40,
        "room": 0x043e
    },
    "Greater Distance Owl": {
        "region_id": None,
        "conditional": True,
        "owl_id": 10,
        "scouting_byte": 0xc978,
        "scouting_mask": 0x40,
        "room": 0x0478
    },
    "Frypolar Owl": {
        "region_id": None,
        "conditional": True,
        "owl_id": 11,
        "scouting_byte": 0xca71,
        "scouting_mask": 0x40,
        "room": 0x0571
    },
    "Shining Blue Owl": {
        "region_id": None,
        "conditional": True,
        "owl_id": 12,
        "scouting_byte": 0xca57,
        "scouting_mask": 0x40,
        "room": 0x0557
    },
    "Floodgate Owl": {
        "region_id": None,
        "conditional": True,
        "owl_id": 13,
        "scouting_byte": 0xc9e7,
        "scouting_mask": 0x40,
        "room": 0x04e7
    },
}
