from typing import Any

tww_options_presets: dict[str, dict[str, Any]] = {
    "Tournament S8": {
        "progression_dungeon_secrets": True,
        "progression_combat_secret_caves": True,
        "progression_short_sidequests": True,
        "progression_long_sidequests": True,
        "progression_spoils_trading": True,
        "progression_big_octos_gunboats": True,
        "progression_mail": True,
        "progression_platforms_rafts": True,
        "progression_submarines": True,
        "progression_big_octos_gunboats": True,
        "progression_expensive_purchases": True,
        "progression_island_puzzles": True,
        "progression_misc": True,
        "randomize_mapcompass": "startwith",
        "randomize_bigkeys": "startwith",
        "required_bosses": True,
        "num_required_bosses": 4,
        "included_dungeons": ["Forsaken Fortress"],
        "chest_type_matches_contents": True,
        "logic_obscurity": "hard",
        "randomize_dungeon_entrances": True,
        "randomize_starting_island": True,
        "add_shortcut_warps_between_dungeons": True,
        "start_inventory_from_pool": {
            "Telescope": 1,
            "Wind Waker": 1,
            "Wind's Requiem": 1,
            "Ballad of Gales": 1,
            "Command Melody": 1,
            "Earth God's Lyric": 1,
            "Wind God's Aria": 1,
            "Song of Passing": 1,
            "Triforce Shard 1": 1,
            "Triforce Shard 2": 1,
            "Triforce Shard 3": 1,
            "Skull Necklace": 20,
            "Golden Feather": 20,
            "Knight's Crest": 10,
            "Green Chu Jelly": 15,
            "Nayru's Pearl": 1,
            "Din's Pearl": 1,
        },
        "start_location_hints": [
            "Windfall Island - Chu Jelly Juice Shop - Give 15 Blue Chu Jelly",
            "Ganon's Tower - Maze Chest",
        ],
        "exclude_locations": [
            "Outset Island - Great Fairy",
            "Windfall Island - Mrs. Marie - Give 1 Joy Pendant",
            "Windfall Island - Mrs. Marie - Give 21 Joy Pendants",
            "Windfall Island - Mrs. Marie - Give 40 Joy Pendants",
            "Windfall Island - Lenzo's House - Become Lenzo's Assistant",
            "Windfall Island - Lenzo's House - Bring Forest Firefly",
            "Windfall Island - Sam - Decorate the Town",
            "Windfall Island - Kamo - Full Moon Photo",
            "Windfall Island - Linda and Anton",
            "Dragon Roost Island - Secret Cave",
            "Greatfish Isle - Hidden Chest",
            "Mother and Child Isles - Inside Mother Isle",
            "Fire Mountain - Cave - Chest",
            "Fire Mountain - Lookout Platform Chest",
            "Fire Mountain - Lookout Platform - Destroy the Cannons",
            "Fire Mountain - Big Octo",
            "Headstone Island - Top of the Island",
            "Headstone Island - Submarine",
            "Earth Temple - Behind Curtain Next to Hammer Button",
            "The Great Sea - Goron Trading Reward",
            "The Great Sea - Withered Trees",
            "Private Oasis - Big Octo",
            "Boating Course - Raft",
            "Boating Course - Cave",
            "Stone Watcher Island - Cave",
            "Stone Watcher Island - Lookout Platform Chest",
            "Stone Watcher Island - Lookout Platform - Destroy the Cannons",
            "Overlook Island - Cave",
            "Bird's Peak Rock - Cave",
            "Pawprint Isle - Wizzrobe Cave",
            "Thorned Fairy Island - Great Fairy",
            "Thorned Fairy Island - Northeastern Lookout Platform - Destroy the Cannons",
            "Thorned Fairy Island - Southwestern Lookout Platform - Defeat the Enemies",
            "Eastern Fairy Island - Great Fairy",
            "Eastern Fairy Island - Lookout Platform - Defeat the Cannons and Enemies",
            "Western Fairy Island - Great Fairy",
            "Western Fairy Island - Lookout Platform",
            "Tingle Island - Ankle - Reward for All Tingle Statues",
            "Tingle Island - Big Octo",
            "Diamond Steppe Island - Big Octo",
            "Rock Spire Isle - Cave",
            "Rock Spire Isle - Beedle's Special Shop Ship - 500 Rupee Item",
            "Rock Spire Isle - Beedle's Special Shop Ship - 950 Rupee Item",
            "Rock Spire Isle - Beedle's Special Shop Ship - 900 Rupee Item",
            "Rock Spire Isle - Western Lookout Platform - Destroy the Cannons",
            "Rock Spire Isle - Eastern Lookout Platform - Destroy the Cannons",
            "Rock Spire Isle - Center Lookout Platform",
            "Rock Spire Isle - Southeast Gunboat",
            "Shark Island - Cave",
            "Horseshoe Island - Northwestern Lookout Platform",
            "Horseshoe Island - Southeastern Lookout Platform",
            "Flight Control Platform - Submarine",
            "Star Island - Cave",
            "Star Island - Lookout Platform",
            "Star Belt Archipelago - Lookout Platform",
            "Five-Star Isles - Lookout Platform - Destroy the Cannons",
            "Five-Star Isles - Raft",
            "Five-Star Isles - Submarine",
            "Seven-Star Isles - Center Lookout Platform",
            "Seven-Star Isles - Northern Lookout Platform",
            "Seven-Star Isles - Southern Lookout Platform",
            "Seven-Star Isles - Big Octo",
            "Cyclops Reef - Lookout Platform - Defeat the Enemies",
            "Two-Eye Reef - Lookout Platform",
            "Two-Eye Reef - Big Octo Great Fairy",
            "Five-Eye Reef - Lookout Platform",
            "Six-Eye Reef - Lookout Platform - Destroy the Cannons",
            "Six-Eye Reef - Submarine",
        ],
    },
    "Miniblins 2025": {
        "progression_great_fairies": False,
        "progression_short_sidequests": True,
        "progression_mail": True,
        "progression_expensive_purchases": False,
        "progression_island_puzzles": True,
        "progression_misc": True,
        "randomize_mapcompass": "startwith",
        "required_bosses": True,
        "num_required_bosses": 2,
        "chest_type_matches_contents": True,
        "randomize_starting_island": True,
        "add_shortcut_warps_between_dungeons": True,
        "start_inventory_from_pool": {
            "Telescope": 1,
            "Wind Waker": 1,
            "Wind's Requiem": 1,
            "Ballad of Gales": 1,
            "Command Melody": 1,
            "Earth God's Lyric": 1,
            "Wind God's Aria": 1,
            "Song of Passing": 1,
            "Nayru's Pearl": 1,
            "Din's Pearl": 1,
            "Progressive Shield": 1,
            "Progressive Magic Meter": 2,
            "Quiver Capacity Upgrade": 1,
            "Bomb Bag Capacity Upgrade": 1,
            "Piece of Heart": 12,
        },
        "start_location_hints": ["Ganon's Tower - Maze Chest"],
        "exclude_locations": [
            "Outset Island - Jabun's Cave",
            "Windfall Island - Jail - Tingle - First Gift",
            "Windfall Island - Jail - Tingle - Second Gift",
            "Windfall Island - Jail - Maze Chest",
            "Windfall Island - Maggie - Delivery Reward",
            "Windfall Island - Cafe Bar - Postman",
            "Windfall Island - Zunari - Stock Exotic Flower in Zunari's Shop",
            "Tingle Island - Ankle - Reward for All Tingle Statues",
            "Horseshoe Island - Play Golf",
        ],
    },
    "Mixed Pools": {
        "progression_tingle_chests": True,
        "progression_dungeon_secrets": True,
        "progression_combat_secret_caves": True,
        "progression_short_sidequests": True,
        "progression_mail": True,
        "progression_submarines": True,
        "progression_expensive_purchases": False,
        "progression_island_puzzles": True,
        "progression_misc": True,
        "randomize_mapcompass": "startwith",
        "required_bosses": True,
        "num_required_bosses": 6,
        "chest_type_matches_contents": True,
        "randomize_dungeon_entrances": True,
        "randomize_secret_cave_entrances": True,
        "randomize_miniboss_entrances": True,
        "randomize_boss_entrances": True,
        "randomize_secret_cave_inner_entrances": True,
        "randomize_fairy_fountain_entrances": True,
        "mix_entrances": "mix_pools",
        "randomize_starting_island": True,
        "add_shortcut_warps_between_dungeons": True,
        "start_inventory_from_pool": {
            "Telescope": 1,
            "Wind Waker": 1,
            "Wind's Requiem": 1,
            "Ballad of Gales": 1,
            "Earth God's Lyric": 1,
            "Wind God's Aria": 1,
            "Song of Passing": 1,
        },
        "start_location_hints": ["Ganon's Tower - Maze Chest", "Shark Island - Cave"],
    },
}
