from collections import Counter

from BaseClasses import ItemClassification
from .Locations import level_locations, all_level_locations, standard_level_locations, shop_locations
from .Options import TriforceLocations, StartingPosition, StartingWeapon, is_open_cave_shuffled, EntranceShuffle
import time

# Swords are in starting_weapons
overworld_items = {
    "Letter": 1,
    "Power Bracelet": 1,
    "Heart Container": 1,
    "Sword": 1
}

shop_items = {
    "Magical Shield": 3,
    "Food": 2,
    "Small Key": 2,
    "Candle": 1,
    "Recovery Heart": 1,
    "Blue Ring": 1,
    "Water of Life (Blue)": 1,
    "Water of Life (Red)": 1,
    "Bomb": 1,
    "Arrow": 1
}

# Magical Rod and Red Candle are in starting_weapons, Triforce Fragments are added in its section of get_pool_core
major_dungeon_items = {
    "Heart Container": 8,
    "Bow": 1,
    "Boomerang": 1,
    "Magical Boomerang": 1,
    "Raft": 1,
    "Stepladder": 1,
    "Recorder": 1,
    "Magical Key": 1,
    "Book of Magic": 1,
    "Silver Arrow": 1,
    "Red Ring": 1
}

minor_dungeon_items = {
    "Bomb": 23,
    "Small Key": 44,
    "Five Rupees": 17
}

take_any_items = {
    "Heart Container": 4
}

# Map/Compasses: 18
# Reasoning: Adding some variety to the vanilla game.

map_compass_replacements = {
    "Fairy": 6,
    "Clock": 3,
    "Water of Life (Red)": 1,
    "Water of Life (Blue)": 2,
    "Bomb": 2,
    "Small Key": 2,
    "Five Rupees": 2
}
basic_pool = Counter()
basic_pool.update(overworld_items)
basic_pool.update(shop_items)
basic_pool.update(major_dungeon_items)
basic_pool.update(map_compass_replacements)

starting_weapons = ["Sword", "White Sword", "Magical Sword", "Magical Rod", "Red Candle"]
starting_weapon_locations = ["Starting Sword Cave", "Letter Cave", "Armos Knights"]
dangerous_weapon_locations = [
    "Level 1 Compass", "Level 2 Bomb Drop (Keese)", "Level 3 Key Drop (Zols Entrance)", "Level 3 Compass"]

def generate_itempool(tlozworld):
    (pool, placed_items) = get_pool_core(tlozworld)
    tlozworld.multiworld.itempool.extend([tlozworld.multiworld.create_item(item, tlozworld.player) for item in pool])
    for (location_name, item) in placed_items.items():
        location = tlozworld.multiworld.get_location(location_name, tlozworld.player)
        location.place_locked_item(tlozworld.multiworld.create_item(item, tlozworld.player))
        if item == "Bomb":
            location.item.classification = ItemClassification.progression

def get_pool_core(world):
    print("Pool Core start")
    random = world.random

    pool = []
    placed_items = {}
    minor_items = dict(minor_dungeon_items)

    # Guaranteed Shop Items
    guaranteed_shop_items = world.options.ShopItems.value
    open_slots = [location for location in shop_locations if location != "Blue Ring Shop Item Middle"]
    if len(guaranteed_shop_items) > len(open_slots):
        guaranteed_shop_items = random.sample(sorted(guaranteed_shop_items), len(open_slots))

    reserved_store_slots = random.sample(open_slots, len(guaranteed_shop_items))
    for location, item in zip(reserved_store_slots, guaranteed_shop_items):
        placed_items[location] = item
    placed_items["Blue Ring Shop Item Middle"] = "Small Key"

    # Starting Weapon
    start_weapon_locations = starting_weapon_locations.copy()
    final_starting_weapons = [weapon for weapon in starting_weapons
                              if weapon not in world.options.non_local_items and weapon not in guaranteed_shop_items]
    if not final_starting_weapons:
        final_starting_weapons = ["Sword"]
    if world.options.StartingWeapon == StartingWeapon.option_bluecandle:
        starting_weapon = "Candle"
    elif world.options.StartingWeapon == StartingWeapon.option_sword:
        starting_weapon = "Sword"
    else:
        starting_weapon = random.choice(final_starting_weapons)
    if (world.options.StartingPosition == StartingPosition.option_safe
            or is_open_cave_shuffled(world.options.EntranceShuffle.value)): # Major, Major Open, and All
        placed_items[start_weapon_locations[0]] = starting_weapon
    elif world.options.StartingPosition in \
            [StartingPosition.option_unsafe, StartingPosition.option_dangerous]:
        if world.options.StartingPosition == StartingPosition.option_dangerous:
            for location in dangerous_weapon_locations:
                if world.options.ExpandedPool or "Drop" not in location:
                    start_weapon_locations.append(location)
        placed_items[random.choice(start_weapon_locations)] = starting_weapon
    else:
        pool.append(starting_weapon)
    for other_weapons in final_starting_weapons:
        if other_weapons != starting_weapon:
            pool.append(other_weapons)

    # Triforce Fragments
    fragment = "Triforce Fragment"
    if world.options.ExpandedPool:
        possible_level_locations = [location for location in all_level_locations
                                    if location not in level_locations[8]]
    else:
        possible_level_locations = [location for location in standard_level_locations
                                    if location not in level_locations[8]]
    for location in placed_items.keys():
        if location in possible_level_locations:
            possible_level_locations.remove(location)
    for level in range(1, 9):
        if world.options.TriforceLocations == TriforceLocations.option_vanilla:
            placed_items[f"Level {level} Triforce"] = fragment
        elif world.options.TriforceLocations == TriforceLocations.option_dungeons:
            placed_items[possible_level_locations.pop(random.randint(0, len(possible_level_locations) - 1))] = fragment
        else:
            pool.append(fragment)

    # Finish Pool
    final_pool = basic_pool
    if world.options.ExpandedPool:
        final_pool = Counter()
        final_pool.update(basic_pool)
        final_pool.update(minor_items)
        final_pool.update(take_any_items)
        final_pool["Five Rupees"] -= 1
    # Starting weapon possibilities have already been bounced out of the pool if they're in a shop.
    guaranteed_shop_items_dict = {item: 1 for item in guaranteed_shop_items if item not in starting_weapons}
    final_pool.subtract(guaranteed_shop_items_dict)
    for item in final_pool.elements():
        pool.append(item)

    return pool, placed_items
