from BaseClasses import Region

from ..base_classes import Q1Level


class roguestart(Q1Level):
    name = "Introduction"
    mapfile = "start_rogue"
    keys = []
    location_defs = [
        {
            "id": 1,
            "name": "Megahealth (1)",
            "classname": "item_health",
            "uuid": 9401621028484310549,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Random (2)",
            "classname": "item_random_powerup",
            "uuid": 14978879043223562766,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Plasma (3)",
            "classname": "item_plasma",
            "uuid": 6361993121517729770,
            "mp": 1,
        },
        {
            "id": 4,
            "name": "Large Medkit (4)",
            "classname": "item_health",
            "uuid": 11353806948283894970,
            "mp": 1,
        },
        {
            "id": 5,
            "name": "Yellow Armor (5)",
            "classname": "item_armor2",
            "uuid": 9500028287004994306,
            "mp": 1,
        },
        {
            "id": 6,
            "name": "Sphere (6)",
            "classname": "item_sphere",
            "uuid": 6800992735523420215,
            "mp": 1,
        },
        {
            "id": 7,
            "name": "Red Armor (7)",
            "classname": "item_armorInv",
            "uuid": 4261376048230992950,
            "mp": 1,
        },
        {
            "id": 8,
            "name": "Invisibility (8)",
            "classname": "item_artifact_invisibility",
            "uuid": 568959575467444370,
            "mp": 1,
        },
        {
            "id": 9,
            "name": "Spikes (9)",
            "classname": "item_spikes",
            "uuid": 1734624585831013371,
            "mp": 1,
        },
        {
            "id": 10,
            "name": "Large Medkit (10)",
            "classname": "item_health",
            "uuid": 16936841204972826137,
            "mp": 1,
        },
        {
            "id": 11,
            "name": "Powerup (11)",
            "classname": "item_powerup_shield",
            "uuid": 4068344683688430773,
            "mp": 1,
        },
        {
            "id": 12,
            "name": "Lava (12)",
            "classname": "item_lava_spikes",
            "uuid": 15230400899662834225,
            "mp": 1,
        },
        {
            "id": 13,
            "name": "Large Medkit (13)",
            "classname": "item_health",
            "uuid": 17874649085336664025,
            "mp": 1,
        },
        {
            "id": 14,
            "name": "Quad Damage (14)",
            "classname": "item_artifact_super_damage",
            "uuid": 2763727981562131667,
            "mp": 1,
        },
        {
            "id": 15,
            "name": "Shells (15)",
            "classname": "item_shells",
            "uuid": 16260025229907881179,
            "mp": 1,
        },
        {
            "id": 16,
            "name": "Spikes (16)",
            "classname": "item_spikes",
            "uuid": 16887007180852352825,
            "mp": 1,
        },
        {
            "id": 17,
            "name": "Spikes (17)",
            "classname": "item_spikes",
            "uuid": 16412438987670976895,
            "mp": 1,
        },
        {
            "id": 18,
            "name": "Cells (18)",
            "classname": "item_cells",
            "uuid": 4099414351277646615,
            "mp": 1,
        },
        {
            "id": 19,
            "name": "Plasma (19)",
            "classname": "item_plasma",
            "uuid": 13827348913356430990,
            "mp": 1,
        },
        {
            "id": 20,
            "name": "Multi (20)",
            "classname": "item_multi_rockets",
            "uuid": 823049969837061468,
            "mp": 1,
        },
        {
            "id": 21,
            "name": "Large Medkit (21)",
            "classname": "item_health",
            "uuid": 4127676827271592215,
            "mp": 1,
        },
        {
            "id": 22,
            "name": "Large Medkit (22)",
            "classname": "item_health",
            "uuid": 2633674177834664221,
            "mp": 1,
        },
        {
            "id": 23,
            "name": "Large Medkit (23)",
            "classname": "item_health",
            "uuid": 2650426287525958665,
            "mp": 1,
        },
        {
            "id": 24,
            "name": "Large Medkit (24)",
            "classname": "item_health",
            "uuid": 11951358481900989003,
            "mp": 1,
        },
        {
            "id": 25,
            "name": "Large Medkit (25)",
            "classname": "item_health",
            "uuid": 16783549288432828829,
            "mp": 1,
        },
        {
            "id": 26,
            "name": "Large Medkit (26)",
            "classname": "item_health",
            "uuid": 8667319278778294770,
            "mp": 1,
        },
        {
            "id": 27,
            "name": "Large Medkit (27)",
            "classname": "item_health",
            "uuid": 7778571215979337111,
            "mp": 1,
        },
        {
            "id": 28,
            "name": "Nailgun (28)",
            "classname": "weapon_nailgun",
            "uuid": 9662259698426084274,
            "mp": 1,
        },
        {
            "id": 29,
            "name": "Supernailgun (29)",
            "classname": "weapon_supernailgun",
            "uuid": 9688568897735782442,
            "mp": 1,
        },
        {
            "id": 30,
            "name": "Supershotgun (30)",
            "classname": "weapon_supershotgun",
            "uuid": 4779857997411899177,
            "mp": 1,
        },
        {
            "id": 31,
            "name": "Lava (31)",
            "classname": "item_lava_spikes",
            "uuid": 656993200449255764,
            "mp": 1,
        },
        {
            "id": 32,
            "name": "Plasma (32)",
            "classname": "item_plasma",
            "uuid": 18197446437710719773,
            "mp": 1,
        },
        {
            "id": 33,
            "name": "Shells (33)",
            "classname": "item_shells",
            "uuid": 2247379093719781761,
            "mp": 1,
        },
        {
            "id": 34,
            "name": "Large Medkit (34)",
            "classname": "item_health",
            "uuid": 4254449788425078815,
            "mp": 1,
        },
        {
            "id": 35,
            "name": "Grenadelauncher (35)",
            "classname": "weapon_grenadelauncher",
            "uuid": 9506392122356376656,
            "mp": 1,
        },
        {
            "id": 36,
            "name": "Large Medkit (36)",
            "classname": "item_health",
            "uuid": 8279333460258566346,
            "mp": 1,
        },
        {
            "id": 37,
            "name": "Large Medkit (37)",
            "classname": "item_health",
            "uuid": 10788833436019787943,
            "mp": 1,
        },
        {
            "id": 38,
            "name": "Rockets (38)",
            "classname": "item_rockets",
            "uuid": 17919326817004759723,
            "mp": 1,
        },
        {
            "id": 39,
            "name": "Rocketlauncher (39)",
            "classname": "weapon_rocketlauncher",
            "uuid": 4112846047609531317,
            "mp": 1,
        },
        {
            "id": 40,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 6424492973035767000,
            "mp": 0,
        },
        # {
        #     "id": 41,
        #     "name": "Exit",
        #     "classname": "trigger_changelevel",
        #     "uuid": 6627228980930986941,
        #     "mp": 0,
        # },
        {
            "id": 42,
            "name": "Lightning (42)",
            "classname": "weapon_lightning",
            "uuid": 17563133884749048337,
            "mp": 1,
        },
        {
            "id": 43,
            "name": "Shells (43)",
            "classname": "item_shells",
            "uuid": 17315173702772861119,
            "mp": 1,
        },
        {
            "id": 44,
            "name": "Supershotgun (44)",
            "classname": "weapon_supershotgun",
            "uuid": 17452652305159797877,
            "mp": 1,
        },
        {
            "id": 45,
            "name": "Cells (45)",
            "classname": "item_cells",
            "uuid": 11065058894449534543,
            "mp": 1,
        },
        {
            "id": 46,
            "name": "Lava (46)",
            "classname": "item_lava_spikes",
            "uuid": 13171557698003699689,
            "mp": 1,
        },
        {
            "id": 47,
            "name": "Rockets (47)",
            "classname": "item_rockets",
            "uuid": 11838975321553825394,
            "mp": 1,
        },
        {
            "id": 48,
            "name": "Powerup (48)",
            "classname": "item_powerup_belt",
            "uuid": 13529102108429222825,
            "mp": 1,
        },
        {
            "id": 49,
            "name": "Large Medkit (49)",
            "classname": "item_health",
            "uuid": 12419706444705562338,
            "mp": 1,
        },
        {
            "id": 50,
            "name": "Large Medkit (50)",
            "classname": "item_health",
            "uuid": 5294854151433013183,
            "mp": 1,
        },
        {
            "id": 51,
            "name": "Grenadelauncher (51)",
            "classname": "weapon_grenadelauncher",
            "uuid": 9760062036713682765,
            "mp": 1,
        },
        {
            "id": 52,
            "name": "All Kills (52)",
            "classname": "all_kills",
            "uuid": 11891092947304516721,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Supernailgun (29)",
                "Yellow Armor (5)",
                "Lava (12)",
                "Supershotgun (30)",
                "Plasma (3)",
                "Large Medkit (4)",
                "Large Medkit (21)",
                "Large Medkit (24)",
                "Large Medkit (50)",
                "Spikes (16)",
                "Shells (15)",
                "Rocketlauncher (39)",
                "Rockets (38)",
                "Large Medkit (36)",
                "Large Medkit (37)",
                "Plasma (32)",
                "Lava (31)",
                "Grenadelauncher (35)",
                "Shells (33)",
                "Large Medkit (34)",
                "Large Medkit (22)",
                "Large Medkit (27)",
                "Large Medkit (23)",
                "Megahealth (1)",
                "Exit",
                "All Kills (52)",
            ],
        )
        self.restrict("Megahealth (1)", r.bigjump)

        shootswitch_area = self.region(
            "Shootswitch Area",
            [
                "Lightning (42)",
                "Sphere (6)",
                "Spikes (9)",
                "Large Medkit (10)",
                "Large Medkit (13)",
                "Quad Damage (14)",
                "Invisibility (8)",
                "Red Armor (7)",
            ],
        )
        self.connect(ret, shootswitch_area, r.can_shootswitch)
        self.restrict("Invisibility (8)", r.can_gj_extr | r.can_rj_hard | r.bigjump)
        self.restrict("Red Armor (7)", r.can_gj_extr | r.can_rj_hard | r.bigjump)

        bigjump_area = self.region(
            "Bigjump Area",
            [
                "Cells (18)",
                "Spikes (17)",
                "Grenadelauncher (51)",
                "Plasma (19)",
                "Multi (20)",
                "Random (2)",
                "Large Medkit (26)",
                "Large Medkit (25)",
                "Nailgun (28)",
            ],
        )
        self.connect(ret, bigjump_area, r.bigjump)

        return ret
