from BaseClasses import Region

from ..base_classes import Q1Level


class r2m5(Q1Level):
    name = "Wizard's Keep"
    mapfile = "r2m5"
    keys = ["Silver", "Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Random (1)",
            "classname": "item_random_powerup",
            "uuid": 17507481185824499676,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 1737862616119859167,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Random (3)",
            "classname": "item_random_powerup",
            "uuid": 15052606062810017586,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Rockets (4)",
            "classname": "item_rockets",
            "uuid": 13651718992030500762,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Sphere (5)",
            "classname": "item_sphere",
            "uuid": 13764074622405372262,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Multi (6)",
            "classname": "item_multi_rockets",
            "uuid": 7819270132215109452,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Large Medkit (7)",
            "classname": "item_health",
            "uuid": 2843261800450715189,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Secret (8)",
            "classname": "trigger_secret",
            "uuid": 12296707499242337773,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Multi (9)",
            "classname": "item_multi_rockets",
            "uuid": 9668682418076685474,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Secret (10)",
            "classname": "trigger_secret",
            "uuid": 8178778801612236524,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Supernailgun (11)",
            "classname": "weapon_supernailgun",
            "uuid": 17980476414421841729,
            "mp": 1,
        },
        {
            "id": 12,
            "name": "Rockets (12)",
            "classname": "item_rockets",
            "uuid": 10810716394543673908,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Large Medkit (13)",
            "classname": "item_health",
            "uuid": 2166705297187551927,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Spikes (14)",
            "classname": "item_spikes",
            "uuid": 6483862014177885338,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Powerup (15)",
            "classname": "item_powerup_belt",
            "uuid": 3206292609452595082,
            "mp": 1,
        },
        {
            "id": 16,
            "name": "Small Medkit (16)",
            "classname": "item_health",
            "uuid": 9443493249697243231,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Small Medkit (17)",
            "classname": "item_health",
            "uuid": 2635726300145961010,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Supershotgun (18)",
            "classname": "weapon_supershotgun",
            "uuid": 14848887795995131659,
            "mp": 1,
        },
        {
            "id": 19,
            "name": "Shells (19)",
            "classname": "item_shells",
            "uuid": 18437224611637817997,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Large Medkit (20)",
            "classname": "item_health",
            "uuid": 7325954001785895688,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Plasma (21)",
            "classname": "item_plasma",
            "uuid": 11186151230748159157,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Large Medkit (22)",
            "classname": "item_health",
            "uuid": 12643188973607495862,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Rockets (23)",
            "classname": "item_rockets",
            "uuid": 3421362345222077051,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Large Medkit (24)",
            "classname": "item_health",
            "uuid": 12059793751172555637,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Lava (25)",
            "classname": "item_lava_spikes",
            "uuid": 13166203148018546083,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Small Medkit (26)",
            "classname": "item_health",
            "uuid": 10258142949198076238,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Spikes (27)",
            "classname": "item_spikes",
            "uuid": 4325621201658384388,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Rockets (28)",
            "classname": "item_rockets",
            "uuid": 7217387613137462460,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Large Medkit (29)",
            "classname": "item_health",
            "uuid": 5728289942476080752,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Large Medkit (30)",
            "classname": "item_health",
            "uuid": 12131474913634837959,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Shells (31)",
            "classname": "item_shells",
            "uuid": 7154335720181128912,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Invulnerability (32)",
            "classname": "item_artifact_invulnerability",
            "uuid": 1448637680314908501,
            "mp": 1,
        },
        {
            "id": 33,
            "name": "Grenadelauncher (33)",
            "classname": "weapon_grenadelauncher",
            "uuid": 17812573040038992381,
            "mp": 1,
        },
        {
            "id": 34,
            "name": "Shells (34)",
            "classname": "item_shells",
            "uuid": 1688347639453969062,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Rocketlauncher (35)",
            "classname": "weapon_rocketlauncher",
            "uuid": 13146917150799516385,
            "mp": 1,
        },
        {
            "id": 36,
            "name": "Spikes (36)",
            "classname": "item_spikes",
            "uuid": 5614648764664018634,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Shells (37)",
            "classname": "item_shells",
            "uuid": 11143304493476373036,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Multi (38)",
            "classname": "item_multi_rockets",
            "uuid": 9896926011696485128,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Grenadelauncher (39)",
            "classname": "weapon_grenadelauncher",
            "uuid": 7697423469752270132,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Large Medkit (40)",
            "classname": "item_health",
            "uuid": 4082143495579109144,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Large Medkit (41)",
            "classname": "item_health",
            "uuid": 3915776694478354372,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Rockets (42)",
            "classname": "item_rockets",
            "uuid": 3631855624883542333,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Lava (43)",
            "classname": "item_lava_spikes",
            "uuid": 2432570022465515275,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Plasma (44)",
            "classname": "item_plasma",
            "uuid": 718788544214389449,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Small Medkit (45)",
            "classname": "item_health",
            "uuid": 1435188671539838466,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Small Medkit (46)",
            "classname": "item_health",
            "uuid": 9211901059970693772,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Spikes (47)",
            "classname": "item_spikes",
            "uuid": 12986763796839435744,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Shells (48)",
            "classname": "item_shells",
            "uuid": 3574273697800454655,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Supernailgun (49)",
            "classname": "weapon_supernailgun",
            "uuid": 13134962773833985824,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Large Medkit (50)",
            "classname": "item_health",
            "uuid": 8613388744003481850,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Large Medkit (51)",
            "classname": "item_health",
            "uuid": 1864762358780915533,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Large Medkit (52)",
            "classname": "item_health",
            "uuid": 14262139783172792368,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Multi (53)",
            "classname": "item_multi_rockets",
            "uuid": 17867924140436686430,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Lightning (54)",
            "classname": "weapon_lightning",
            "uuid": 12303175420310229347,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Rocketlauncher (55)",
            "classname": "weapon_rocketlauncher",
            "uuid": 17832484330091969555,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Large Medkit (56)",
            "classname": "item_health",
            "uuid": 4403677685734937317,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Spikes (57)",
            "classname": "item_spikes",
            "uuid": 4106826686904980004,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Shells (58)",
            "classname": "item_shells",
            "uuid": 10945714923911437905,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Large Medkit (59)",
            "classname": "item_health",
            "uuid": 4645095206869640449,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Plasma (60)",
            "classname": "item_plasma",
            "uuid": 5845712827972663398,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Yellow Armor (61)",
            "classname": "item_armor2",
            "uuid": 12101251887239410851,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Rockets (62)",
            "classname": "item_rockets",
            "uuid": 5375472397153602899,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Rockets (63)",
            "classname": "item_rockets",
            "uuid": 16667199883302564323,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Large Medkit (64)",
            "classname": "item_health",
            "uuid": 10220760900854218594,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Large Medkit (65)",
            "classname": "item_health",
            "uuid": 5932094270888256552,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Shells (66)",
            "classname": "item_shells",
            "uuid": 9424208405219824994,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Spikes (67)",
            "classname": "item_spikes",
            "uuid": 8681558109173449709,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Plasma (68)",
            "classname": "item_plasma",
            "uuid": 8075606697493606283,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Cells (69)",
            "classname": "item_cells",
            "uuid": 12707734934068442593,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Large Medkit (70)",
            "classname": "item_health",
            "uuid": 15139397481159042047,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Lava (71)",
            "classname": "item_lava_spikes",
            "uuid": 13607740480019718242,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Small Medkit (72)",
            "classname": "item_health",
            "uuid": 15178866190694913018,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Small Medkit (73)",
            "classname": "item_health",
            "uuid": 18026343991151293690,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Rockets (74)",
            "classname": "item_rockets",
            "uuid": 17932322239480183055,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Small Medkit (75)",
            "classname": "item_health",
            "uuid": 7711928791347631314,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Small Medkit (76)",
            "classname": "item_health",
            "uuid": 3474131769097581718,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Large Medkit (77)",
            "classname": "item_health",
            "uuid": 13092355187705286377,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Lava (78)",
            "classname": "item_lava_spikes",
            "uuid": 9597386910136472442,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Large Medkit (79)",
            "classname": "item_health",
            "uuid": 13887122329045610508,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Plasma (80)",
            "classname": "item_plasma",
            "uuid": 17525135505744700624,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Nailgun (81)",
            "classname": "weapon_nailgun",
            "uuid": 14180163416349823685,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Large Medkit (82)",
            "classname": "item_health",
            "uuid": 16337073676281462187,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Spikes (83)",
            "classname": "item_spikes",
            "uuid": 10289649988866000986,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Large Medkit (84)",
            "classname": "item_health",
            "uuid": 13105682168393908554,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Shells (85)",
            "classname": "item_shells",
            "uuid": 4471335081646128712,
            "mp": 0,
        },
        {
            "id": 86,
            "name": "Small Medkit (86)",
            "classname": "item_health",
            "uuid": 18159715477287660689,
            "mp": 0,
        },
        {
            "id": 87,
            "name": "Small Medkit (87)",
            "classname": "item_health",
            "uuid": 14863836120771164493,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Multi (88)",
            "classname": "item_multi_rockets",
            "uuid": 7930186306868742251,
            "mp": 0,
        },
        {
            "id": 89,
            "name": "Invisibility (89)",
            "classname": "item_artifact_invisibility",
            "uuid": 3916945816779136402,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "Lava (90)",
            "classname": "item_lava_spikes",
            "uuid": 13427867632748389017,
            "mp": 0,
        },
        {
            "id": 91,
            "name": "Green Armor (91)",
            "classname": "item_armor1",
            "uuid": 4931722950981004920,
            "mp": 0,
        },
        {
            "id": 92,
            "name": "Plasma (92)",
            "classname": "item_plasma",
            "uuid": 8683761755224440185,
            "mp": 0,
        },
        {
            "id": 93,
            "name": "Multi (93)",
            "classname": "item_multi_rockets",
            "uuid": 17808912577786823798,
            "mp": 0,
        },
        {
            "id": 94,
            "name": "Large Medkit (94)",
            "classname": "item_health",
            "uuid": 13594061135804608269,
            "mp": 0,
        },
        {
            "id": 95,
            "name": "Cells (95)",
            "classname": "item_cells",
            "uuid": 14771413482354234091,
            "mp": 0,
        },
        {
            "id": 96,
            "name": "Secret (96)",
            "classname": "trigger_secret",
            "uuid": 2349236326991540937,
            "mp": 0,
        },
        {
            "id": 97,
            "name": "Large Medkit (97)",
            "classname": "item_health",
            "uuid": 12267160027201119874,
            "mp": 0,
        },
        {
            "id": 98,
            "name": "Shells (98)",
            "classname": "item_shells",
            "uuid": 11474709437983825829,
            "mp": 0,
        },
        {
            "id": 99,
            "name": "Lava (99)",
            "classname": "item_lava_spikes",
            "uuid": 11139456909393673992,
            "mp": 0,
        },
        {
            "id": 100,
            "name": "Large Medkit (100)",
            "classname": "item_health",
            "uuid": 12318855696055722866,
            "mp": 0,
        },
        {
            "id": 101,
            "name": "Large Medkit (101)",
            "classname": "item_health",
            "uuid": 2591118100449508584,
            "mp": 0,
        },
        {
            "id": 102,
            "name": "Cells (102)",
            "classname": "item_cells",
            "uuid": 3545814501385475525,
            "mp": 0,
        },
        {
            "id": 103,
            "name": "Spikes (103)",
            "classname": "item_spikes",
            "uuid": 3446008617868632704,
            "mp": 0,
        },
        {
            "id": 104,
            "name": "Large Medkit (104)",
            "classname": "item_health",
            "uuid": 3237233121535562100,
            "mp": 0,
        },
        {
            "id": 105,
            "name": "Large Medkit (105)",
            "classname": "item_health",
            "uuid": 9868796984668216547,
            "mp": 0,
        },
        {
            "id": 106,
            "name": "Powerup (106)",
            "classname": "item_powerup_shield",
            "uuid": 15582703172614300495,
            "mp": 0,
        },
        {
            "id": 107,
            "name": "Silver Key (107)",
            "classname": "item_key1",
            "uuid": 15197290969828665219,
            "mp": 0,
        },
        {
            "id": 108,
            "name": "Gold Key (108)",
            "classname": "item_key2",
            "uuid": 4722832603556083249,
            "mp": 0,
        },
        {
            "id": 109,
            "name": "Large Medkit (109)",
            "classname": "item_health",
            "uuid": 8844731345223829912,
            "mp": 0,
        },
        {
            "id": 110,
            "name": "Large Medkit (110)",
            "classname": "item_health",
            "uuid": 886537822091262154,
            "mp": 0,
        },
        {
            "id": 111,
            "name": "Lava (111)",
            "classname": "item_lava_spikes",
            "uuid": 7971145727919355038,
            "mp": 0,
        },
        {
            "id": 112,
            "name": "Shells (112)",
            "classname": "item_shells",
            "uuid": 17238111621202287226,
            "mp": 0,
        },
        {
            "id": 113,
            "name": "Supershotgun (113)",
            "classname": "weapon_supershotgun",
            "uuid": 2316120425104230116,
            "mp": 0,
        },
        {
            "id": 114,
            "name": "Large Medkit (114)",
            "classname": "item_health",
            "uuid": 17809332442752542653,
            "mp": 0,
        },
        {
            "id": 115,
            "name": "Large Medkit (115)",
            "classname": "item_health",
            "uuid": 12754220441074944905,
            "mp": 0,
        },
        {
            "id": 116,
            "name": "Plasma (116)",
            "classname": "item_plasma",
            "uuid": 15533451648565486635,
            "mp": 0,
        },
        {
            "id": 117,
            "name": "Rockets (117)",
            "classname": "item_rockets",
            "uuid": 17986502560715516936,
            "mp": 0,
        },
        {
            "id": 118,
            "name": "Small Medkit (118)",
            "classname": "item_health",
            "uuid": 11202522286979802337,
            "mp": 0,
        },
        {
            "id": 119,
            "name": "Small Medkit (119)",
            "classname": "item_health",
            "uuid": 14157865804799567768,
            "mp": 0,
        },
        {
            "id": 120,
            "name": "Lava (120)",
            "classname": "item_lava_spikes",
            "uuid": 16776728500782994716,
            "mp": 0,
        },
        {
            "id": 121,
            "name": "Shells (121)",
            "classname": "item_shells",
            "uuid": 2659757552764067962,
            "mp": 0,
        },
        {
            "id": 122,
            "name": "Megahealth (122)",
            "classname": "item_health",
            "uuid": 8617208866439826492,
            "mp": 0,
        },
        {
            "id": 123,
            "name": "Sphere (123)",
            "classname": "item_sphere",
            "uuid": 8280588284081867407,
            "mp": 0,
        },
        {
            "id": 124,
            "name": "Invulnerability (124)",
            "classname": "item_artifact_invulnerability",
            "uuid": 1492372180112217077,
            "mp": 0,
        },
        {
            "id": 125,
            "name": "Flag (125)",
            "classname": "item_flag_team1",
            "uuid": 9708462052070542915,
            "mp": 0,
        },
        {
            "id": 126,
            "name": "Flag (126)",
            "classname": "item_flag_team2",
            "uuid": 7876309340144779678,
            "mp": 0,
        },
        {
            "id": 127,
            "name": "Flag (127)",
            "classname": "item_flag",
            "uuid": 15704106291279400119,
            "mp": 0,
        },
        {
            "id": 128,
            "name": "Quad Damage (128)",
            "classname": "item_artifact_super_damage",
            "uuid": 4065272586670314475,
            "mp": 1,
        },
        {
            "id": 129,
            "name": "Large Medkit (129)",
            "classname": "item_health",
            "uuid": 4476094759947625802,
            "mp": 0,
        },
        {
            "id": 130,
            "name": "Lava (130)",
            "classname": "item_lava_spikes",
            "uuid": 10105581138937983720,
            "mp": 0,
        },
        {
            "id": 131,
            "name": "Secret (131)",
            "classname": "trigger_secret",
            "uuid": 390061603799131680,
            "mp": 0,
        },
        {
            "id": 132,
            "name": "All Kills (132)",
            "classname": "all_kills",
            "uuid": 4805053917634995607,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Large Medkit (109)",
                "Large Medkit (110)",
                "Shells (112)",
                "Supershotgun (113)",
                "Spikes (36)",
                "Large Medkit (114)",
                "Large Medkit (115)",
                "Flag (125)",
                "Rocketlauncher (35)",
                "Rockets (117)",
                "Secret (96)",
                "Powerup (106)",
            ],
        )
        self.restrict("Secret (96)", r.jump & r.can_button)
        self.restrict("Powerup (106)", r.jump & r.can_button)

        past_door_area = self.region(
            "Past Door Area",
            [
                "Cells (102)",
                "Large Medkit (105)",
                "Spikes (103)",
                "Large Medkit (104)",
                "Multi (9)",
                "Lava (99)",
                "Large Medkit (101)",
                "Large Medkit (100)",
                "Shells (98)",
                "Grenadelauncher (33)",
                "Cells (95)",
                "Shells (34)",
                "Large Medkit (97)",
                "Large Medkit (94)",
                "Nailgun (81)",
                "Shells (31)",
                "Large Medkit (30)",
                "Invulnerability (32)",
                "Silver Key (107)",
                "Small Medkit (87)",
                "Small Medkit (86)",
                "Secret (8)",
                "Megahealth (122)",
                "Secret (10)",
                "Invisibility (89)",
            ],
        )
        self.connect(ret, past_door_area, r.can_door)
        self.restrict("Secret (8)", r.can_shootswitch & r.jump)
        self.restrict("Megahealth (122)", r.can_shootswitch & r.jump)

        past_silver_door_area = self.region(
            "Past Silver Door",
            [
                "Large Medkit (84)",
                "Shells (85)",
                "Large Medkit (29)",
                "Rockets (28)",
                "Plasma (80)",
                "Spikes (27)",
                "Small Medkit (26)",
                "Large Medkit (79)",
                "Large Medkit (24)",
                "Spikes (83)",
                "Large Medkit (82)",
                "Sphere (123)",
            ],
        )
        self.connect(past_door_area, past_silver_door_area, self.silver_key)

        past_silver_button_area = self.region(
            "Past Silver Button Area",
            [
                "Large Medkit (77)",
                "Lava (78)",
                "Rockets (74)",
                "Lava (130)",
                "Small Medkit (76)",
                "Small Medkit (75)",
                "Rockets (23)",
                "Small Medkit (72)",
                "Small Medkit (73)",
                "Lava (71)",
                "Supershotgun (18)",
                "Large Medkit (22)",
                "Large Medkit (70)",
                "Shells (19)",
                "Large Medkit (20)",
                "Cells (69)",
                "Green Armor (91)",
                "Sphere (5)",
                "Small Medkit (16)",
                "Small Medkit (17)",
                "Spikes (67)",
                "Shells (66)",
                "Lightning (54)",
                "Flag (126)",
                "Large Medkit (65)",
                "Large Medkit (64)",
                "Random (1)",
                "Gold Key (108)",
                "Rockets (63)",
                "Large Medkit (59)",
                "Plasma (60)",
                "Spikes (57)",
                "Large Medkit (56)",
                "Large Medkit (52)",
                "Multi (53)",
                "Large Medkit (13)",
                "Spikes (14)",
                "Rockets (4)",
                "Rockets (12)",
                "Shells (48)",
                "Spikes (47)",
                "Supernailgun (49)",
                "Large Medkit (51)",
                "Large Medkit (50)",
                "Supernailgun (11)",
                "Small Medkit (46)",
                "Small Medkit (45)",
                "Random (3)",
                "Grenadelauncher (39)",
                "Rockets (42)",
                "Lava (43)",
                "Large Medkit (40)",
                "Large Medkit (41)",
                "Shells (37)",
                "Rockets (62)",
                "Flag (127)",
                "Rocketlauncher (55)",
                "Shells (58)",
                "Yellow Armor (61)",
                "Powerup (15)",
                "Large Medkit (7)",
                "Invulnerability (124)",
                "Secret (131)",
                "Quad Damage (128)",
                "Large Medkit (129)",
                "All Kills (132)",
            ],
        )
        self.connect(past_silver_door_area, past_silver_button_area, r.can_button)
        self.restrict("Green Armor (91)", r.jump)
        self.restrict("Sphere (5)", r.jump)
        self.restrict("Large Medkit (7)", r.jump)
        self.restrict("Invulnerability (124)", r.jump)
        self.restrict("Secret (131)", r.bigjump_hard | r.can_shootswitch)
        self.restrict("Quad Damage (128)", r.bigjump_hard | r.can_shootswitch)
        self.restrict("Large Medkit (129)", r.bigjump_hard | r.can_shootswitch)

        self.restrict("All Kills (132)", self.gold_key & r.difficult_combat)

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Small Medkit (118)",
                "Small Medkit (119)",
                "Shells (121)",
                "Exit",
            ],
        )
        self.connect(past_door_area, past_gold_door_area, self.gold_key)

        return ret
