from BaseClasses import Region

from ..base_classes import Q1Level


class r2m3(Q1Level):
    name = "Elemental Fury II"
    mapfile = "r2m3"
    keys = []
    location_defs = [
        {
            "id": 1,
            "name": "Megahealth (1)",
            "classname": "item_health",
            "uuid": 15497644118188615554,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Large Medkit (2)",
            "classname": "item_health",
            "uuid": 3383770061742679679,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 14949394335457172769,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Large Medkit (4)",
            "classname": "item_health",
            "uuid": 7123522058770531025,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Cells (5)",
            "classname": "item_cells",
            "uuid": 7831738573465158850,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Lava (6)",
            "classname": "item_lava_spikes",
            "uuid": 15324353126243017807,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Rockets (7)",
            "classname": "item_rockets",
            "uuid": 2849526698011211663,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Shells (8)",
            "classname": "item_shells",
            "uuid": 13545908499449001602,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Large Medkit (9)",
            "classname": "item_health",
            "uuid": 17710299543837370126,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Large Medkit (10)",
            "classname": "item_health",
            "uuid": 4294496829039301318,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Spikes (11)",
            "classname": "item_spikes",
            "uuid": 7924866539991548714,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Plasma (12)",
            "classname": "item_plasma",
            "uuid": 14459332787352808595,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Lava (13)",
            "classname": "item_lava_spikes",
            "uuid": 9649552143824818251,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Biosuit (14)",
            "classname": "item_artifact_envirosuit",
            "uuid": 16754355453926845609,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Red Armor (15)",
            "classname": "item_armorInv",
            "uuid": 13278483835966209913,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Cells (16)",
            "classname": "item_cells",
            "uuid": 17210343653305073248,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Large Medkit (17)",
            "classname": "item_health",
            "uuid": 890202733661032506,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Green Armor (18)",
            "classname": "item_armor1",
            "uuid": 10081678858307578260,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Large Medkit (19)",
            "classname": "item_health",
            "uuid": 5186559016982342860,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Shells (20)",
            "classname": "item_shells",
            "uuid": 2289298266755849480,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Small Medkit (21)",
            "classname": "item_health",
            "uuid": 18316552185488454843,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Small Medkit (22)",
            "classname": "item_health",
            "uuid": 17335700971894701956,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Multi (23)",
            "classname": "item_multi_rockets",
            "uuid": 1824810034443757893,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Rockets (24)",
            "classname": "item_rockets",
            "uuid": 7470270776121784639,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Large Medkit (25)",
            "classname": "item_health",
            "uuid": 9418626155003091083,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Large Medkit (26)",
            "classname": "item_health",
            "uuid": 9067762670960852633,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Spikes (27)",
            "classname": "item_spikes",
            "uuid": 5525847623324148184,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Large Medkit (28)",
            "classname": "item_health",
            "uuid": 8214131581151137062,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Small Medkit (29)",
            "classname": "item_health",
            "uuid": 7142936386235295141,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Small Medkit (30)",
            "classname": "item_health",
            "uuid": 17929373325923880907,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Lava (31)",
            "classname": "item_lava_spikes",
            "uuid": 1808168018388077901,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Yellow Armor (32)",
            "classname": "item_armor2",
            "uuid": 3995557466045888242,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Plasma (33)",
            "classname": "item_plasma",
            "uuid": 4448254969023030623,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Multi (34)",
            "classname": "item_multi_rockets",
            "uuid": 7392636933443323523,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Large Medkit (35)",
            "classname": "item_health",
            "uuid": 13254416459356379896,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Large Medkit (36)",
            "classname": "item_health",
            "uuid": 17267311275025286425,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Multi (37)",
            "classname": "item_multi_rockets",
            "uuid": 5707246467217289836,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Shells (38)",
            "classname": "item_shells",
            "uuid": 12542743840160875689,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Small Medkit (39)",
            "classname": "item_health",
            "uuid": 13514479660434065168,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Supershotgun (40)",
            "classname": "weapon_supershotgun",
            "uuid": 10792043588848069377,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Large Medkit (41)",
            "classname": "item_health",
            "uuid": 16349496580270246638,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Shells (42)",
            "classname": "item_shells",
            "uuid": 5318258904066199093,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Large Medkit (43)",
            "classname": "item_health",
            "uuid": 1638001556862275958,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Rockets (44)",
            "classname": "item_rockets",
            "uuid": 2049926240404124033,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Large Medkit (45)",
            "classname": "item_health",
            "uuid": 8830887396025396593,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Cells (46)",
            "classname": "item_cells",
            "uuid": 1372700777927089533,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Large Medkit (47)",
            "classname": "item_health",
            "uuid": 640417579524593,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Lava (48)",
            "classname": "item_lava_spikes",
            "uuid": 16851458120594604069,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Large Medkit (49)",
            "classname": "item_health",
            "uuid": 11679778839361705275,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Green Armor (50)",
            "classname": "item_armor1",
            "uuid": 15246133543609399521,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Plasma (51)",
            "classname": "item_plasma",
            "uuid": 720584510948727907,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Shells (52)",
            "classname": "item_shells",
            "uuid": 17446076816933956163,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Large Medkit (53)",
            "classname": "item_health",
            "uuid": 3365620978121760337,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Large Medkit (54)",
            "classname": "item_health",
            "uuid": 9346536435467956444,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Multi (55)",
            "classname": "item_multi_rockets",
            "uuid": 8352753821207426892,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Large Medkit (56)",
            "classname": "item_health",
            "uuid": 8267379049544055634,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Cells (57)",
            "classname": "item_cells",
            "uuid": 1695916756577485502,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Cells (58)",
            "classname": "item_cells",
            "uuid": 13235104850448081935,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Small Medkit (59)",
            "classname": "item_health",
            "uuid": 524665284328691172,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Spikes (60)",
            "classname": "item_spikes",
            "uuid": 4732632852649194779,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Nailgun (61)",
            "classname": "weapon_nailgun",
            "uuid": 7442826168092376931,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Powerup (62)",
            "classname": "item_powerup_shield",
            "uuid": 9846693538671460554,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Large Medkit (63)",
            "classname": "item_health",
            "uuid": 13671051623896821141,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Large Medkit (64)",
            "classname": "item_health",
            "uuid": 7643525813502441982,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Spikes (65)",
            "classname": "item_spikes",
            "uuid": 16740896071399233831,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Plasma (66)",
            "classname": "item_plasma",
            "uuid": 14309651388268914418,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Yellow Armor (67)",
            "classname": "item_armor2",
            "uuid": 11013595611546652117,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Small Medkit (68)",
            "classname": "item_health",
            "uuid": 2063828357068163131,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Small Medkit (69)",
            "classname": "item_health",
            "uuid": 9087945527580093768,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Spikes (70)",
            "classname": "item_spikes",
            "uuid": 1202277443204121958,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Large Medkit (71)",
            "classname": "item_health",
            "uuid": 17748441109994663830,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Large Medkit (72)",
            "classname": "item_health",
            "uuid": 15937946365936301899,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Large Medkit (73)",
            "classname": "item_health",
            "uuid": 14376188451767986881,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Cells (74)",
            "classname": "item_cells",
            "uuid": 11878471276675970059,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Large Medkit (75)",
            "classname": "item_health",
            "uuid": 13317255110644411693,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Shells (76)",
            "classname": "item_shells",
            "uuid": 1849565350199153812,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Lava (77)",
            "classname": "item_lava_spikes",
            "uuid": 6496873153127155639,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Small Medkit (78)",
            "classname": "item_health",
            "uuid": 9984603425722301109,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Small Medkit (79)",
            "classname": "item_health",
            "uuid": 3850421388140761063,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Biosuit (80)",
            "classname": "item_artifact_envirosuit",
            "uuid": 9108090623387546457,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Supernailgun (81)",
            "classname": "weapon_supernailgun",
            "uuid": 17209014216948648083,
            "mp": 1,
        },
        {
            "id": 82,
            "name": "Lava (82)",
            "classname": "item_lava_spikes",
            "uuid": 2003609625358611401,
            "mp": 1,
        },
        {
            "id": 83,
            "name": "Shells (83)",
            "classname": "item_shells",
            "uuid": 3340807185417527561,
            "mp": 1,
        },
        {
            "id": 84,
            "name": "Supershotgun (84)",
            "classname": "weapon_supershotgun",
            "uuid": 10342887836949357681,
            "mp": 1,
        },
        {
            "id": 85,
            "name": "Grenadelauncher (85)",
            "classname": "weapon_grenadelauncher",
            "uuid": 17355754817135873381,
            "mp": 0,
        },
        {
            "id": 86,
            "name": "Lightning (86)",
            "classname": "weapon_lightning",
            "uuid": 11147794208237085580,
            "mp": 1,
        },
        {
            "id": 87,
            "name": "Sphere (87)",
            "classname": "item_sphere",
            "uuid": 2397826646658872474,
            "mp": 1,
        },
        {
            "id": 88,
            "name": "Sphere (88)",
            "classname": "item_sphere",
            "uuid": 11360670408093039643,
            "mp": 1,
        },
        {
            "id": 89,
            "name": "Large Medkit (89)",
            "classname": "item_health",
            "uuid": 10596988889728270762,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "Secret (90)",
            "classname": "trigger_secret",
            "uuid": 14584608681353579105,
            "mp": 0,
        },
        {
            "id": 91,
            "name": "Lightning (91)",
            "classname": "weapon_lightning",
            "uuid": 6169632756217998189,
            "mp": 0,
        },
        {
            "id": 92,
            "name": "Red Armor (92)",
            "classname": "item_armorInv",
            "uuid": 9045701927438319866,
            "mp": 1,
        },
        {
            "id": 93,
            "name": "Flag (93)",
            "classname": "item_flag_team1",
            "uuid": 418540486768412602,
            "mp": 0,
        },
        {
            "id": 94,
            "name": "Flag (94)",
            "classname": "item_flag_team2",
            "uuid": 12063230237083764670,
            "mp": 0,
        },
        {
            "id": 95,
            "name": "Flag (95)",
            "classname": "item_flag",
            "uuid": 6692616080644750362,
            "mp": 0,
        },
        {
            "id": 96,
            "name": "Small Medkit (96)",
            "classname": "item_health",
            "uuid": 16134027461325510610,
            "mp": 0,
        },
        {
            "id": 97,
            "name": "Large Medkit (97)",
            "classname": "item_health",
            "uuid": 14869341240356278530,
            "mp": 0,
        },
        {
            "id": 98,
            "name": "Biosuit (98)",
            "classname": "item_artifact_envirosuit",
            "uuid": 6295462529356328747,
            "mp": 0,
        },
        {
            "id": 99,
            "name": "Spikes (99)",
            "classname": "item_spikes",
            "uuid": 10902455396665453710,
            "mp": 0,
        },
        {
            "id": 100,
            "name": "Lava (100)",
            "classname": "item_lava_spikes",
            "uuid": 593906512927475186,
            "mp": 0,
        },
        {
            "id": 101,
            "name": "Lava (101)",
            "classname": "item_lava_spikes",
            "uuid": 6529647614636981110,
            "mp": 0,
        },
        {
            "id": 102,
            "name": "Rocketlauncher (102)",
            "classname": "weapon_rocketlauncher",
            "uuid": 12704380121618007434,
            "mp": 0,
        },
        {
            "id": 103,
            "name": "All Kills (103)",
            "classname": "all_kills",
            "uuid": 11474240035775783878,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Small Medkit (96)",
                "Large Medkit (97)",
                "Biosuit (98)",
                "Large Medkit (4)",
            ],
        )

        dive_area = self.region(
            "Dive Area",
            [
                "Large Medkit (4)",
                "Lava (13)",
                "Plasma (12)",
                "Red Armor (92)",
                "Biosuit (80)",
                "Spikes (11)",
                "Large Medkit (10)",
                "Large Medkit (9)",
                "Rockets (7)",
                "Shells (8)",
                "Lava (6)",
                "Cells (5)",
                "Spikes (99)",
                "Shells (20)",
                "Large Medkit (19)",
                "Biosuit (14)",
                "Large Medkit (17)",
                "Supernailgun (81)",
                "Green Armor (18)",
                "Rocketlauncher (102)",
                "Small Medkit (29)",
                "Small Medkit (30)",
                "Yellow Armor (32)",
                "Lava (31)",
                "Small Medkit (39)",
                "Shells (38)",
                "Flag (95)",
                "Multi (37)",
                "Lava (82)",
                "Large Medkit (26)",
                "Large Medkit (28)",
                "Supershotgun (84)",
                "Shells (83)",
                "Flag (94)",
                "Spikes (27)",
            ],
        )
        self.connect(ret, dive_area, r.can_dive)

        past_button_area = self.region(
            "Past Button Area",
            [
                "Cells (16)",
                "Multi (23)",
                "Small Medkit (22)",
                "Sphere (88)",
                "Small Medkit (21)",
                "Large Medkit (25)",
                "Rockets (24)",
                "Lightning (91)",
                "Red Armor (15)",
                "Large Medkit (35)",
                "Large Medkit (36)",
                "Rockets (44)",
                "Large Medkit (43)",
                "Lava (100)",
                "Large Medkit (45)",
                "Cells (46)",
                "Large Medkit (47)",
                "Sphere (87)",
                "Plasma (51)",
                "Large Medkit (89)",
                "Shells (52)",
                "Large Medkit (54)",
                "Large Medkit (53)",
                "Multi (55)",
                "Large Medkit (56)",
                "Cells (58)",
                "Cells (57)",
                "Small Medkit (59)",
                "Spikes (60)",
                "Nailgun (61)",
                "Large Medkit (2)",
                "Large Medkit (63)",
                "Large Medkit (64)",
                "Spikes (65)",
                "Plasma (66)",
                "Lightning (86)",
                "Small Medkit (68)",
                "Small Medkit (69)",
                "Yellow Armor (67)",
                "Spikes (70)",
                "Large Medkit (71)",
                "Flag (93)",
                "Large Medkit (72)",
                "Large Medkit (73)",
                "Shells (76)",
                "Large Medkit (75)",
                "Megahealth (1)",
                "Secret (90)",
            ],
        )
        self.connect(dive_area, past_button_area, r.can_button)
        self.restrict("Lightning (91)", r.jump)
        self.restrict("Red Armor (15)", r.jump)
        self.restrict("Megahealth (1)", r.bigjump)
        self.restrict("Secret (90)", r.bigjump)

        past_door_area = self.region(
            "Past Door Area",
            [
                "Large Medkit (41)",
                "Shells (42)",
                "Supershotgun (40)",
                "Large Medkit (49)",
                "Lava (48)",
                "Grenadelauncher (85)",
                "Green Armor (50)",
                "Large Medkit (43)",
                "Powerup (62)",
                "Lava (77)",
                "Small Medkit (79)",
                "Small Medkit (78)",
            ],
        )
        self.connect(past_button_area, past_door_area, r.can_door)

        past_lava_fight_area = self.region(
            "Past Lava Fight",
            [
                "Cells (74)",
                "Exit",
                "All Kills (103)",
            ],
        )
        self.connect(
            past_button_area,
            past_lava_fight_area,
            r.difficult_combat & r.jump,
        )
        self.restrict("All Kills (103)", r.difficult_combat)

        return ret
