from BaseClasses import Region

from ..base_classes import Q1Level


class r1m5(Q1Level):
    name = "Towers of Wrath"
    mapfile = "r1m5"
    keys = ["Silver", "Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Sphere (1)",
            "classname": "item_sphere",
            "uuid": 4346271784085337955,
            "mp": 1,
        },
        {
            "id": 2,
            "name": "Sphere (2)",
            "classname": "item_sphere",
            "uuid": 2974961885350222663,
            "mp": 1,
        },
        {
            "id": 3,
            "name": "Powerup (3)",
            "classname": "item_powerup_belt",
            "uuid": 8608740899315227921,
            "mp": 1,
        },
        {
            "id": 4,
            "name": "Secret (4)",
            "classname": "trigger_secret",
            "uuid": 1465069902004621614,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Powerup (5)",
            "classname": "item_powerup_shield",
            "uuid": 5423450246833142230,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Secret (6)",
            "classname": "trigger_secret",
            "uuid": 8145674178142072485,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Secret (7)",
            "classname": "trigger_secret",
            "uuid": 11219155773607736284,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Secret (8)",
            "classname": "trigger_secret",
            "uuid": 13054913689581801649,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Quad Damage (9)",
            "classname": "item_artifact_super_damage",
            "uuid": 1033688522052377145,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Rockets (10)",
            "classname": "item_rockets",
            "uuid": 10643545044010380293,
            "mp": 1,
        },
        {
            "id": 11,
            "name": "Rocketlauncher (11)",
            "classname": "weapon_rocketlauncher",
            "uuid": 2864912609421195268,
            "mp": 1,
        },
        {
            "id": 12,
            "name": "Large Medkit (12)",
            "classname": "item_health",
            "uuid": 4893127177151687441,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Spikes (13)",
            "classname": "item_spikes",
            "uuid": 1936732972729071493,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Cells (14)",
            "classname": "item_cells",
            "uuid": 1395770013379795532,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Spikes (15)",
            "classname": "item_spikes",
            "uuid": 719478480695683131,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Invulnerability (16)",
            "classname": "item_artifact_invulnerability",
            "uuid": 188492057586751086,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Secret (17)",
            "classname": "trigger_secret",
            "uuid": 13998227043960978866,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Small Medkit (18)",
            "classname": "item_health",
            "uuid": 12337648411711037002,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Small Medkit (19)",
            "classname": "item_health",
            "uuid": 4879383242445355224,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Spikes (20)",
            "classname": "item_spikes",
            "uuid": 18163152599979545011,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Lava (21)",
            "classname": "item_lava_spikes",
            "uuid": 12571156479674505515,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 2528294883080480958,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Plasma (23)",
            "classname": "item_plasma",
            "uuid": 8617908067503516466,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Large Medkit (24)",
            "classname": "item_health",
            "uuid": 12431380041819903440,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Spikes (25)",
            "classname": "item_spikes",
            "uuid": 1799104264408209771,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Spikes (26)",
            "classname": "item_spikes",
            "uuid": 7877764092626657109,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Shells (27)",
            "classname": "item_shells",
            "uuid": 10914917850755740283,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Shells (28)",
            "classname": "item_shells",
            "uuid": 17486684989993641142,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Large Medkit (29)",
            "classname": "item_health",
            "uuid": 9041687786003156857,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Shells (30)",
            "classname": "item_shells",
            "uuid": 16520099596929797417,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Yellow Armor (31)",
            "classname": "item_armor2",
            "uuid": 17605973697151504226,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Grenadelauncher (32)",
            "classname": "weapon_grenadelauncher",
            "uuid": 3819882555255325394,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Large Medkit (33)",
            "classname": "item_health",
            "uuid": 5865834083210560262,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Large Medkit (34)",
            "classname": "item_health",
            "uuid": 10639718154547294262,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Rockets (35)",
            "classname": "item_rockets",
            "uuid": 15697099315381372583,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Spikes (36)",
            "classname": "item_spikes",
            "uuid": 8300426630609732088,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Lava (37)",
            "classname": "item_lava_spikes",
            "uuid": 5615473193054318769,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Large Medkit (38)",
            "classname": "item_health",
            "uuid": 9438567820921029233,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Multi (39)",
            "classname": "item_multi_rockets",
            "uuid": 11168717083365511347,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Large Medkit (40)",
            "classname": "item_health",
            "uuid": 17607433515986988643,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Large Medkit (41)",
            "classname": "item_health",
            "uuid": 14301703966120154576,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Multi (42)",
            "classname": "item_multi_rockets",
            "uuid": 3311547837853332941,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Small Medkit (43)",
            "classname": "item_health",
            "uuid": 12648276020998644657,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Small Medkit (44)",
            "classname": "item_health",
            "uuid": 11128369890178651138,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Shells (45)",
            "classname": "item_shells",
            "uuid": 3603040309411422749,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Supershotgun (46)",
            "classname": "weapon_supershotgun",
            "uuid": 10152267045454658598,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Lava (47)",
            "classname": "item_lava_spikes",
            "uuid": 7825314173078637668,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Large Medkit (48)",
            "classname": "item_health",
            "uuid": 8390764982053369530,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Rockets (49)",
            "classname": "item_rockets",
            "uuid": 5427416418495738743,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Green Armor (50)",
            "classname": "item_armor1",
            "uuid": 6622502498727133015,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Large Medkit (51)",
            "classname": "item_health",
            "uuid": 11977653517239115746,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Spikes (52)",
            "classname": "item_spikes",
            "uuid": 13950438580048512205,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Large Medkit (53)",
            "classname": "item_health",
            "uuid": 1277988795815333391,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Cells (54)",
            "classname": "item_cells",
            "uuid": 12723118986078765230,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Cells (55)",
            "classname": "item_cells",
            "uuid": 9088354025423378263,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Shells (56)",
            "classname": "item_shells",
            "uuid": 2377645261735263923,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Rocketlauncher (57)",
            "classname": "weapon_rocketlauncher",
            "uuid": 14731333281942806027,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Multi (58)",
            "classname": "item_multi_rockets",
            "uuid": 8064691970094296161,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Small Medkit (59)",
            "classname": "item_health",
            "uuid": 16448140859480835071,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Small Medkit (60)",
            "classname": "item_health",
            "uuid": 1150624506272087315,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Lava (61)",
            "classname": "item_lava_spikes",
            "uuid": 727778285679767679,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Large Medkit (62)",
            "classname": "item_health",
            "uuid": 8801735684225818349,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Yellow Armor (63)",
            "classname": "item_armor2",
            "uuid": 2417330961039182271,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Megahealth (64)",
            "classname": "item_health",
            "uuid": 10641622899450412470,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Plasma (65)",
            "classname": "item_plasma",
            "uuid": 4055350689425395077,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Multi (66)",
            "classname": "item_multi_rockets",
            "uuid": 11687679353208986512,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Small Medkit (67)",
            "classname": "item_health",
            "uuid": 7167784924120597158,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Small Medkit (68)",
            "classname": "item_health",
            "uuid": 5982491218483669347,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Shells (69)",
            "classname": "item_shells",
            "uuid": 10048975420673096782,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Nailgun (70)",
            "classname": "weapon_nailgun",
            "uuid": 15976825925463327226,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Spikes (71)",
            "classname": "item_spikes",
            "uuid": 16473032349650204380,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Lava (72)",
            "classname": "item_lava_spikes",
            "uuid": 8300456435026754513,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Large Medkit (73)",
            "classname": "item_health",
            "uuid": 16547397311171309939,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Large Medkit (74)",
            "classname": "item_health",
            "uuid": 16174898619723255813,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Secret (75)",
            "classname": "trigger_secret",
            "uuid": 4589172545936663520,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Gold Key (76)",
            "classname": "item_key2",
            "uuid": 14077453010181391197,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Silver Key (77)",
            "classname": "item_key1",
            "uuid": 8567724459073732653,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Large Medkit (78)",
            "classname": "item_health",
            "uuid": 10474297482382230307,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Lava (79)",
            "classname": "item_lava_spikes",
            "uuid": 229054135380939445,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Rockets (80)",
            "classname": "item_rockets",
            "uuid": 13964326860895096210,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Spikes (81)",
            "classname": "item_spikes",
            "uuid": 18148661039383736817,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Shells (82)",
            "classname": "item_shells",
            "uuid": 16793187232025666106,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Large Medkit (83)",
            "classname": "item_health",
            "uuid": 18307171676462742734,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Multi (84)",
            "classname": "item_multi_rockets",
            "uuid": 871010020859956638,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Shells (85)",
            "classname": "item_shells",
            "uuid": 3189916240231615236,
            "mp": 0,
        },
        {
            "id": 86,
            "name": "Large Medkit (86)",
            "classname": "item_health",
            "uuid": 4493422751299050649,
            "mp": 0,
        },
        {
            "id": 87,
            "name": "Spikes (87)",
            "classname": "item_spikes",
            "uuid": 15383741286748930925,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Cells (88)",
            "classname": "item_cells",
            "uuid": 1218441647144136401,
            "mp": 0,
        },
        {
            "id": 89,
            "name": "Lava (89)",
            "classname": "item_lava_spikes",
            "uuid": 3202628424653195912,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "Large Medkit (90)",
            "classname": "item_health",
            "uuid": 18260256126616447139,
            "mp": 0,
        },
        {
            "id": 91,
            "name": "Large Medkit (91)",
            "classname": "item_health",
            "uuid": 3652253730987183464,
            "mp": 0,
        },
        {
            "id": 92,
            "name": "Lava (92)",
            "classname": "item_lava_spikes",
            "uuid": 18028892670502670523,
            "mp": 0,
        },
        {
            "id": 93,
            "name": "Cells (93)",
            "classname": "item_cells",
            "uuid": 17215112709924648211,
            "mp": 0,
        },
        {
            "id": 94,
            "name": "Quad Damage (94)",
            "classname": "item_artifact_super_damage",
            "uuid": 13254826919106439433,
            "mp": 0,
        },
        {
            "id": 95,
            "name": "Shells (95)",
            "classname": "item_shells",
            "uuid": 12409675080953213643,
            "mp": 0,
        },
        {
            "id": 96,
            "name": "Rockets (96)",
            "classname": "item_rockets",
            "uuid": 246220913287396588,
            "mp": 0,
        },
        {
            "id": 97,
            "name": "Large Medkit (97)",
            "classname": "item_health",
            "uuid": 12133845997087731836,
            "mp": 0,
        },
        {
            "id": 98,
            "name": "Shells (98)",
            "classname": "item_shells",
            "uuid": 17144768911828871278,
            "mp": 0,
        },
        {
            "id": 99,
            "name": "Biosuit (99)",
            "classname": "item_artifact_envirosuit",
            "uuid": 9639385083597590426,
            "mp": 0,
        },
        {
            "id": 100,
            "name": "Cells (100)",
            "classname": "item_cells",
            "uuid": 5861482502733847617,
            "mp": 0,
        },
        {
            "id": 101,
            "name": "Large Medkit (101)",
            "classname": "item_health",
            "uuid": 15136369726076664068,
            "mp": 0,
        },
        {
            "id": 102,
            "name": "Cells (102)",
            "classname": "item_cells",
            "uuid": 818640218869821769,
            "mp": 0,
        },
        {
            "id": 103,
            "name": "Large Medkit (103)",
            "classname": "item_health",
            "uuid": 12547864472209974347,
            "mp": 0,
        },
        {
            "id": 104,
            "name": "Yellow Armor (104)",
            "classname": "item_armor2",
            "uuid": 1028973322990240661,
            "mp": 0,
        },
        {
            "id": 105,
            "name": "Megahealth (105)",
            "classname": "item_health",
            "uuid": 6137632682965707266,
            "mp": 0,
        },
        {
            "id": 106,
            "name": "Multi (106)",
            "classname": "item_multi_rockets",
            "uuid": 18441433855822304402,
            "mp": 0,
        },
        {
            "id": 107,
            "name": "Large Medkit (107)",
            "classname": "item_health",
            "uuid": 15542546498322221328,
            "mp": 0,
        },
        {
            "id": 108,
            "name": "Large Medkit (108)",
            "classname": "item_health",
            "uuid": 1187384538662442077,
            "mp": 0,
        },
        {
            "id": 109,
            "name": "Shells (109)",
            "classname": "item_shells",
            "uuid": 16326084212960711003,
            "mp": 0,
        },
        {
            "id": 110,
            "name": "Spikes (110)",
            "classname": "item_spikes",
            "uuid": 6664136471523657786,
            "mp": 0,
        },
        {
            "id": 111,
            "name": "Lava (111)",
            "classname": "item_lava_spikes",
            "uuid": 14146006204994077345,
            "mp": 0,
        },
        {
            "id": 112,
            "name": "Large Medkit (112)",
            "classname": "item_health",
            "uuid": 6001810767002698864,
            "mp": 0,
        },
        {
            "id": 113,
            "name": "Red Armor (113)",
            "classname": "item_armorInv",
            "uuid": 17590547971701914870,
            "mp": 0,
        },
        {
            "id": 114,
            "name": "Cells (114)",
            "classname": "item_cells",
            "uuid": 14237595057885055489,
            "mp": 0,
        },
        {
            "id": 115,
            "name": "Large Medkit (115)",
            "classname": "item_health",
            "uuid": 14682644318296102966,
            "mp": 0,
        },
        {
            "id": 116,
            "name": "Rockets (116)",
            "classname": "item_rockets",
            "uuid": 2471728346381399425,
            "mp": 0,
        },
        {
            "id": 117,
            "name": "Large Medkit (117)",
            "classname": "item_health",
            "uuid": 1811241303634705985,
            "mp": 0,
        },
        {
            "id": 118,
            "name": "Cells (118)",
            "classname": "item_cells",
            "uuid": 5865405324929729501,
            "mp": 0,
        },
        {
            "id": 119,
            "name": "Shells (119)",
            "classname": "item_shells",
            "uuid": 14178090892138740624,
            "mp": 0,
        },
        {
            "id": 120,
            "name": "Spikes (120)",
            "classname": "item_spikes",
            "uuid": 13399682372852770604,
            "mp": 0,
        },
        {
            "id": 121,
            "name": "Large Medkit (121)",
            "classname": "item_health",
            "uuid": 3474780101849252987,
            "mp": 0,
        },
        {
            "id": 122,
            "name": "Large Medkit (122)",
            "classname": "item_health",
            "uuid": 4689449257953683997,
            "mp": 0,
        },
        {
            "id": 123,
            "name": "Multi (123)",
            "classname": "item_multi_rockets",
            "uuid": 5373892845870610908,
            "mp": 0,
        },
        {
            "id": 124,
            "name": "Large Medkit (124)",
            "classname": "item_health",
            "uuid": 6172188307890853980,
            "mp": 0,
        },
        {
            "id": 125,
            "name": "Large Medkit (125)",
            "classname": "item_health",
            "uuid": 5247954192864568271,
            "mp": 0,
        },
        {
            "id": 126,
            "name": "Lava (126)",
            "classname": "item_lava_spikes",
            "uuid": 17590188120102769911,
            "mp": 0,
        },
        {
            "id": 127,
            "name": "Shells (127)",
            "classname": "item_shells",
            "uuid": 17432832412468903567,
            "mp": 0,
        },
        {
            "id": 128,
            "name": "Grenadelauncher (128)",
            "classname": "weapon_grenadelauncher",
            "uuid": 13926072385867396202,
            "mp": 0,
        },
        {
            "id": 129,
            "name": "Nailgun (129)",
            "classname": "weapon_nailgun",
            "uuid": 4288820016022368430,
            "mp": 0,
        },
        {
            "id": 130,
            "name": "Rocketlauncher (130)",
            "classname": "weapon_rocketlauncher",
            "uuid": 16421883187556801390,
            "mp": 0,
        },
        {
            "id": 131,
            "name": "Supershotgun (131)",
            "classname": "weapon_supershotgun",
            "uuid": 11754268439698788622,
            "mp": 0,
        },
        {
            "id": 132,
            "name": "Lightning (132)",
            "classname": "weapon_lightning",
            "uuid": 2784938881925303574,
            "mp": 0,
        },
        {
            "id": 133,
            "name": "Supernailgun (133)",
            "classname": "weapon_supernailgun",
            "uuid": 10782428755002961291,
            "mp": 0,
        },
        {
            "id": 134,
            "name": "Flag (134)",
            "classname": "item_flag_team2",
            "uuid": 1206068207906344051,
            "mp": 0,
        },
        {
            "id": 135,
            "name": "Flag (135)",
            "classname": "item_flag_team1",
            "uuid": 5284948543456802380,
            "mp": 0,
        },
        {
            "id": 136,
            "name": "Flag (136)",
            "classname": "item_flag",
            "uuid": 5097171202474412562,
            "mp": 0,
        },
        {
            "id": 137,
            "name": "Secret (137)",
            "classname": "trigger_secret",
            "uuid": 18223433798680859780,
            "mp": 0,
        },
        {
            "id": 138,
            "name": "All Kills (138)",
            "classname": "all_kills",
            "uuid": 4483208197206673477,
            "mp": 0,
        },
    ]
    events = ["Button Pressed"]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Large Medkit (74)",
                "Large Medkit (73)",
                "Flag (134)",
                "Spikes (71)",
                "Nailgun (70)",
                "Lava (72)",
                "Shells (69)",
                "Shells (27)",
                "Large Medkit (29)",
            ],
        )

        past_door_area = self.region(
            "Past Door Area",
            [
                "Multi (66)",
                "Small Medkit (67)",
                "Small Medkit (68)",
                "Shells (28)",
                "Yellow Armor (63)",
                "Plasma (65)",
                "Multi (58)",
                "Large Medkit (78)",
                "Lava (79)",
                "Small Medkit (60)",
                "Small Medkit (59)",
                "Grenadelauncher (128)",
                "Rockets (80)",
                "Spikes (81)",
                "Large Medkit (62)",
                "Shells (82)",
                "Large Medkit (83)",
                "Shells (56)",
                "Spikes (26)",
                "Large Medkit (53)",
                "Shells (85)",
                "Sphere (1)",
                "Spikes (52)",
                "Flag (136)",
                "Rocketlauncher (57)",
                "Secret (4)",
                "Powerup (5)",
                "Green Armor (50)",
                "Cells (55)",
                "Cells (54)",
                "Large Medkit (51)",
                "Button Pressed",
                "Secret (75)",
                "Megahealth (64)",
            ],
        )
        self.connect(ret, past_door_area, r.can_door)
        self.restrict("Large Medkit (51)", r.jump)
        self.restrict("Button Pressed", r.can_button)
        self.restrict(
            "Secret (75)",
            r.can_shootswitch
            | (r.can_gj_extr | r.can_rj_extr | (r.can_jump & r.difficulty("extreme"))),
        )
        self.restrict(
            "Megahealth (64)",
            r.can_shootswitch
            | (r.can_gj_extr | r.can_rj_extr | (r.can_jump & r.difficulty("extreme"))),
        )

        past_door_upper_area = self.region(
            "Past Door Upper Area",
            [
                "Rockets (49)",
                "Small Medkit (43)",
                "Small Medkit (44)",
                "Large Medkit (86)",
                "Multi (42)",
                "Shells (45)",
                "Supershotgun (46)",
            ],
        )

        self.connect(
            past_door_area,
            past_door_upper_area,
            self.event("Button Pressed") | r.bigjump_hard,
        )

        upper_pipe_area = self.region(
            "Upper Pipe",
            [
                "Spikes (36)",
                "Large Medkit (40)",
                "Large Medkit (41)",
                "Rockets (35)",
                "Lava (89)",
                "Cells (88)",
                "Large Medkit (38)",
                "Grenadelauncher (32)",
                "Large Medkit (33)",
                "Yellow Armor (31)",
                "Multi (39)",
                "Large Medkit (34)",
                "Rockets (10)",
                "Rocketlauncher (11)",
                "Shells (30)",
                "Large Medkit (91)",
                "Large Medkit (90)",
                "Cells (93)",
                "Large Medkit (24)",
                "Secret (137)",
                "Quad Damage (94)",
                "Rockets (96)",
                "Shells (95)",
                "Spikes (25)",
                "Flag (135)",
                "Nailgun (129)",
                "Powerup (3)",
                "Silver Key (77)",
                "Shells (98)",
                "Large Medkit (97)",
                "Secret (17)",
                "Biosuit (99)",
                "Large Medkit (101)",
                "Cells (100)",
            ],
        )
        self.connect(
            past_door_upper_area, upper_pipe_area, r.can_button & r.can_shootswitch
        )
        self.restrict("Rockets (10)", r.invuln(1))
        self.restrict("Rocketlauncher (11)", r.invuln(1))
        self.restrict("Shells (30)", r.invuln(1))
        self.restrict("Large Medkit (101)", r.can_dive)
        self.restrict("Cells (100)", r.can_dive)

        dive_area = self.region(
            "Dive Area",
            [
                "Large Medkit (48)",
                "Spikes (87)",
                "Secret (6)",
                "Invulnerability (16)",
                "Cells (14)",
                "Spikes (15)",
            ],
        )
        self.connect(past_door_upper_area, dive_area, r.can_dive)
        self.restrict("Secret (6)", r.can_shootswitch)
        self.restrict("Invulnerability (16)", r.can_shootswitch)
        self.restrict("Cells (14)", r.can_shootswitch)
        self.restrict("Spikes (15)", r.can_shootswitch)

        past_silver_door_area = self.region(
            "Past Silver Door",
            [
                "Spikes (13)",
                "Cells (102)",
                "Large Medkit (103)",
                "Yellow Armor (104)",
                "Rocketlauncher (130)",
                "Large Medkit (12)",
                "Multi (106)",
                "Gold Key (76)",
                "Lava (21)",
                "Megahealth (105)",
                "Secret (8)",
            ],
        )
        self.connect(ret, past_silver_door_area, r.bigjump_hard)
        self.connect(
            past_door_upper_area, past_silver_door_area, self.silver_key & r.jump
        )
        self.restrict("Gold Key (76)", r.can_button & r.difficult_combat)
        self.restrict("Lava (21)", r.can_button & r.jump)
        self.restrict(
            "Megahealth (105)", r.jump | ((r.can_gj | r.can_rj) & r.heal(200))
        )
        self.restrict("Secret (8)", r.can_jump | ((r.can_gj | r.can_rj) & r.heal(200)))

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Supernailgun (133)",
                "Large Medkit (107)",
                "Large Medkit (108)",
                "Spikes (110)",
                "Shells (109)",
                "Large Medkit (112)",
                "Lava (111)",
                "Supershotgun (131)",
                "Red Armor (113)",
                "Large Medkit (115)",
                "Cells (114)",
            ],
        )
        self.connect(ret, past_gold_door_area, self.gold_key)

        past_gold_button_area = self.region(
            "Past Gold Button",
            [
                "Rockets (116)",
                "Large Medkit (117)",
                "Cells (118)",
                "Lightning (132)",
                "Small Medkit (18)",
                "Small Medkit (19)",
                "Shells (119)",
                "Quad Damage (9)",
                "Secret (7)",
                "Plasma (23)",
                "Spikes (20)",
                "Large Medkit (121)",
                "Large Medkit (122)",
                "Multi (123)",
                "Spikes (120)",
                "Large Medkit (125)",
                "Large Medkit (124)",
                "Lava (126)",
                "Shells (127)",
                "Exit",
                "All Kills (138)",
            ],
        )
        self.connect(past_gold_door_area, past_gold_button_area, r.can_button)
        self.restrict("Quad Damage (9)", r.jump)
        self.restrict("Secret (7)", r.jump)
        self.restrict("All Kills (138)", r.difficult_combat)

        return ret
