from BaseClasses import Region

from ..base_classes import Q1Level


class mge3m2(Q1Level):
    name = "Hell or Dark Water"
    mapfile = "mge3m2"
    keys = ["Silver", "Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Secret (1)",
            "classname": "trigger_secret",
            "uuid": 17722016248709891962,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Secret (2)",
            "classname": "trigger_secret",
            "uuid": 9494284834927665313,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Secret (3)",
            "classname": "trigger_secret",
            "uuid": 8188207407472288199,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Secret (4)",
            "classname": "trigger_secret",
            "uuid": 16039221279805220455,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Large Medkit (5)",
            "classname": "item_health",
            "uuid": 8850731861291378424,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Supernailgun (6)",
            "classname": "weapon_supernailgun",
            "uuid": 8324904836817707037,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Spikes (7)",
            "classname": "item_spikes",
            "uuid": 14492115124696601359,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Spikes (8)",
            "classname": "item_spikes",
            "uuid": 15999406652600018141,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Silver Key (9)",
            "classname": "item_key1",
            "uuid": 268640172302666722,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Shells (10)",
            "classname": "item_shells",
            "uuid": 2123779148298799474,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Rockets (11)",
            "classname": "item_rockets",
            "uuid": 16996626894460473252,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Rockets (12)",
            "classname": "item_rockets",
            "uuid": 8614307311957887280,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Cells (13)",
            "classname": "item_cells",
            "uuid": 16060361300950434011,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Cells (14)",
            "classname": "item_cells",
            "uuid": 847721569985687668,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Megahealth (15)",
            "classname": "item_health",
            "uuid": 14867472031808215173,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Yellow Armor (16)",
            "classname": "item_armor2",
            "uuid": 4222329582855038554,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Shells (17)",
            "classname": "item_shells",
            "uuid": 4401263703238435158,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Shells (18)",
            "classname": "item_shells",
            "uuid": 18204503478810662293,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Shells (19)",
            "classname": "item_shells",
            "uuid": 6100792728089845417,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Spikes (20)",
            "classname": "item_spikes",
            "uuid": 875438917759661045,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Large Medkit (21)",
            "classname": "item_health",
            "uuid": 15515147777564749726,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Green Armor (22)",
            "classname": "item_armor1",
            "uuid": 9090054435689032757,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Spikes (23)",
            "classname": "item_spikes",
            "uuid": 1895531811816906595,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Shells (24)",
            "classname": "item_shells",
            "uuid": 9890280166448579180,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Shells (25)",
            "classname": "item_shells",
            "uuid": 1275252715859998023,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Shells (26)",
            "classname": "item_shells",
            "uuid": 824529904892149778,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Shells (27)",
            "classname": "item_shells",
            "uuid": 7271238252722514915,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Large Medkit (28)",
            "classname": "item_health",
            "uuid": 7791185607223959403,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Small Medkit (29)",
            "classname": "item_health",
            "uuid": 17922813930766477311,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Rockets (30)",
            "classname": "item_rockets",
            "uuid": 2051798768586013615,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Quad Damage (31)",
            "classname": "item_artifact_super_damage",
            "uuid": 10037987538238583252,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Spikes (32)",
            "classname": "item_spikes",
            "uuid": 16355921342987684655,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Spikes (33)",
            "classname": "item_spikes",
            "uuid": 15171793536964314788,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Large Medkit (34)",
            "classname": "item_health",
            "uuid": 4937461540394954096,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Spikes (35)",
            "classname": "item_spikes",
            "uuid": 12574267697045146346,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Spikes (36)",
            "classname": "item_spikes",
            "uuid": 5498945077720215350,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Lightning (37)",
            "classname": "weapon_lightning",
            "uuid": 17306313635778644834,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Green Armor (38)",
            "classname": "item_armor1",
            "uuid": 16869189788581570035,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Cells (39)",
            "classname": "item_cells",
            "uuid": 12220858699285762535,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Rockets (40)",
            "classname": "item_rockets",
            "uuid": 6987877630362866299,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Rocketlauncher (41)",
            "classname": "weapon_rocketlauncher",
            "uuid": 5387986464217416601,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Shells (42)",
            "classname": "item_shells",
            "uuid": 14266252816072978837,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Shells (43)",
            "classname": "item_shells",
            "uuid": 12264067572487647025,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Spikes (44)",
            "classname": "item_spikes",
            "uuid": 2901110087406773894,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Shells (45)",
            "classname": "item_shells",
            "uuid": 12308397206778547467,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Shells (46)",
            "classname": "item_shells",
            "uuid": 11934005184788376564,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Large Medkit (47)",
            "classname": "item_health",
            "uuid": 3576527696425227058,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Cells (48)",
            "classname": "item_cells",
            "uuid": 12062944469669134225,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Spikes (49)",
            "classname": "item_spikes",
            "uuid": 7577074997886213125,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Large Medkit (50)",
            "classname": "item_health",
            "uuid": 17089025283758459954,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Large Medkit (51)",
            "classname": "item_health",
            "uuid": 10164495880729944493,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Spikes (52)",
            "classname": "item_spikes",
            "uuid": 17007127738885370793,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Spikes (53)",
            "classname": "item_spikes",
            "uuid": 14328195202918732683,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Sigil (54)",
            "classname": "item_sigil",
            "uuid": 13409248635204264272,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Gold Key (55)",
            "classname": "item_key2",
            "uuid": 9546785603075308878,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Yellow Armor (56)",
            "classname": "item_armor2",
            "uuid": 17439407545808908043,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Spikes (57)",
            "classname": "item_spikes",
            "uuid": 13517695505556679547,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Large Medkit (58)",
            "classname": "item_health",
            "uuid": 1464252569976214492,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Megahealth (59)",
            "classname": "item_health",
            "uuid": 12184451561546483808,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Shells (60)",
            "classname": "item_shells",
            "uuid": 7500695646837804359,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Shells (61)",
            "classname": "item_shells",
            "uuid": 14785177534587884579,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Large Medkit (62)",
            "classname": "item_health",
            "uuid": 15769090808027602126,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Large Medkit (63)",
            "classname": "item_health",
            "uuid": 3368465113602275205,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Small Medkit (64)",
            "classname": "item_health",
            "uuid": 15849465696686244096,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Large Medkit (65)",
            "classname": "item_health",
            "uuid": 6882850702759802137,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Large Medkit (66)",
            "classname": "item_health",
            "uuid": 582608611990716417,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Spikes (67)",
            "classname": "item_spikes",
            "uuid": 3026736758508741966,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Spikes (68)",
            "classname": "item_spikes",
            "uuid": 1405449820851358498,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Rockets (69)",
            "classname": "item_rockets",
            "uuid": 9834501507820593242,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Quad Damage (70)",
            "classname": "item_artifact_super_damage",
            "uuid": 9410077718287972497,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Secret (71)",
            "classname": "trigger_secret",
            "uuid": 667745672487936113,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Large Medkit (72)",
            "classname": "item_health",
            "uuid": 1575640153576348003,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Secret (73)",
            "classname": "trigger_secret",
            "uuid": 9524460775219396840,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Large Medkit (74)",
            "classname": "item_health",
            "uuid": 4892283815797604350,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Rockets (75)",
            "classname": "item_rockets",
            "uuid": 11497095580575277078,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 6112507130804696590,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Spikes (77)",
            "classname": "item_spikes",
            "uuid": 7625458658414285030,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Spikes (78)",
            "classname": "item_spikes",
            "uuid": 8801985853372660658,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Rockets (79)",
            "classname": "item_rockets",
            "uuid": 1598025358811861996,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Shells (80)",
            "classname": "item_shells",
            "uuid": 17637994362946813724,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Shells (81)",
            "classname": "item_shells",
            "uuid": 4732632122684801304,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Large Medkit (82)",
            "classname": "item_health",
            "uuid": 14392622967990275319,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Green Armor (83)",
            "classname": "item_armor1",
            "uuid": 16639871506269392804,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Spikes (84)",
            "classname": "item_spikes",
            "uuid": 9725059539625468916,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Shells (85)",
            "classname": "item_shells",
            "uuid": 6729456027790584376,
            "mp": 0,
        },
        {
            "id": 86,
            "name": "Shells (86)",
            "classname": "item_shells",
            "uuid": 683090436289137409,
            "mp": 0,
        },
        {
            "id": 87,
            "name": "Shells (87)",
            "classname": "item_shells",
            "uuid": 16372304099462655336,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Large Medkit (88)",
            "classname": "item_health",
            "uuid": 8838853289879549779,
            "mp": 0,
        },
        {
            "id": 89,
            "name": "Yellow Armor (89)",
            "classname": "item_armor2",
            "uuid": 12692028731119168013,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "Yellow Armor (90)",
            "classname": "item_armor2",
            "uuid": 4605922719869108828,
            "mp": 0,
        },
        {
            "id": 91,
            "name": "Large Medkit (91)",
            "classname": "item_health",
            "uuid": 11759225117278240254,
            "mp": 0,
        },
        {
            "id": 92,
            "name": "Large Medkit (92)",
            "classname": "item_health",
            "uuid": 12052922278018573583,
            "mp": 0,
        },
        {
            "id": 93,
            "name": "Shells (93)",
            "classname": "item_shells",
            "uuid": 16997539781349242816,
            "mp": 0,
        },
        {
            "id": 94,
            "name": "Shells (94)",
            "classname": "item_shells",
            "uuid": 7220775535336243350,
            "mp": 0,
        },
        {
            "id": 95,
            "name": "Spikes (95)",
            "classname": "item_spikes",
            "uuid": 3623261804214123937,
            "mp": 0,
        },
        {
            "id": 96,
            "name": "Spikes (96)",
            "classname": "item_spikes",
            "uuid": 7661960675638109305,
            "mp": 0,
        },
        {
            "id": 97,
            "name": "Spikes (97)",
            "classname": "item_spikes",
            "uuid": 4544777658997885414,
            "mp": 0,
        },
        {
            "id": 98,
            "name": "Spikes (98)",
            "classname": "item_spikes",
            "uuid": 5054143576887455629,
            "mp": 0,
        },
        {
            "id": 99,
            "name": "Rockets (99)",
            "classname": "item_rockets",
            "uuid": 7161720215527261721,
            "mp": 0,
        },
        {
            "id": 100,
            "name": "Cells (100)",
            "classname": "item_cells",
            "uuid": 5876791051493395452,
            "mp": 0,
        },
        {
            "id": 101,
            "name": "Large Medkit (101)",
            "classname": "item_health",
            "uuid": 5202622664488340913,
            "mp": 0,
        },
        {
            "id": 102,
            "name": "Shells (102)",
            "classname": "item_shells",
            "uuid": 17173222415422308074,
            "mp": 0,
        },
        {
            "id": 103,
            "name": "Spikes (103)",
            "classname": "item_spikes",
            "uuid": 540122686677178484,
            "mp": 0,
        },
        {
            "id": 104,
            "name": "Small Medkit (104)",
            "classname": "item_health",
            "uuid": 12647086064744411440,
            "mp": 0,
        },
        {
            "id": 105,
            "name": "Large Medkit (105)",
            "classname": "item_health",
            "uuid": 15292341864798941535,
            "mp": 0,
        },
        {
            "id": 106,
            "name": "Rockets (106)",
            "classname": "item_rockets",
            "uuid": 6302732855021874237,
            "mp": 0,
        },
        {
            "id": 107,
            "name": "Large Medkit (107)",
            "classname": "item_health",
            "uuid": 15517584222409837733,
            "mp": 0,
        },
        {
            "id": 108,
            "name": "Shells (108)",
            "classname": "item_shells",
            "uuid": 17076953737804227129,
            "mp": 0,
        },
        {
            "id": 109,
            "name": "Large Medkit (109)",
            "classname": "item_health",
            "uuid": 7675561326149162266,
            "mp": 0,
        },
        {
            "id": 110,
            "name": "Rockets (110)",
            "classname": "item_rockets",
            "uuid": 15698839266513269462,
            "mp": 0,
        },
        {
            "id": 111,
            "name": "Shells (111)",
            "classname": "item_shells",
            "uuid": 8385751544717989265,
            "mp": 0,
        },
        {
            "id": 112,
            "name": "Shells (112)",
            "classname": "item_shells",
            "uuid": 12938532878073894674,
            "mp": 0,
        },
        {
            "id": 113,
            "name": "Large Medkit (113)",
            "classname": "item_health",
            "uuid": 15181672079177186504,
            "mp": 0,
        },
        {
            "id": 114,
            "name": "Spikes (114)",
            "classname": "item_spikes",
            "uuid": 10802762219421551160,
            "mp": 0,
        },
        {
            "id": 115,
            "name": "Spikes (115)",
            "classname": "item_spikes",
            "uuid": 1056084327577369093,
            "mp": 0,
        },
        {
            "id": 116,
            "name": "Small Medkit (116)",
            "classname": "item_health",
            "uuid": 14665808050176966986,
            "mp": 0,
        },
        {
            "id": 117,
            "name": "Grenadelauncher (117)",
            "classname": "weapon_grenadelauncher",
            "uuid": 7907839563892012484,
            "mp": 0,
        },
        {
            "id": 118,
            "name": "Supershotgun (118)",
            "classname": "weapon_supershotgun",
            "uuid": 3304985980248133856,
            "mp": 0,
        },
        {
            "id": 119,
            "name": "Invisibility (119)",
            "classname": "item_artifact_invisibility",
            "uuid": 14675650204537980859,
            "mp": 0,
        },
        {
            "id": 120,
            "name": "Spikes (120)",
            "classname": "item_spikes",
            "uuid": 7947259511490534314,
            "mp": 0,
        },
        {
            "id": 121,
            "name": "Spikes (121)",
            "classname": "item_spikes",
            "uuid": 2914147953833327694,
            "mp": 0,
        },
        {
            "id": 122,
            "name": "Megahealth (122)",
            "classname": "item_health",
            "uuid": 12741357616825796633,
            "mp": 0,
        },
        {
            "id": 123,
            "name": "Spikes (123)",
            "classname": "item_spikes",
            "uuid": 4159593645921792577,
            "mp": 0,
        },
        {
            "id": 124,
            "name": "Rockets (124)",
            "classname": "item_rockets",
            "uuid": 15391428147482068986,
            "mp": 0,
        },
        {
            "id": 125,
            "name": "Spikes (125)",
            "classname": "item_spikes",
            "uuid": 5663234659528505930,
            "mp": 0,
        },
        {
            "id": 126,
            "name": "Spikes (126)",
            "classname": "item_spikes",
            "uuid": 15740575408295324552,
            "mp": 0,
        },
        {
            "id": 127,
            "name": "Shells (127)",
            "classname": "item_shells",
            "uuid": 13478396588381707767,
            "mp": 0,
        },
        {
            "id": 128,
            "name": "Spikes (128)",
            "classname": "item_spikes",
            "uuid": 1804324170052526806,
            "mp": 0,
        },
        {
            "id": 129,
            "name": "Large Medkit (129)",
            "classname": "item_health",
            "uuid": 6710055464723921340,
            "mp": 0,
        },
        {
            "id": 130,
            "name": "Rockets (130)",
            "classname": "item_rockets",
            "uuid": 75610727296166152,
            "mp": 0,
        },
        {
            "id": 131,
            "name": "Small Medkit (131)",
            "classname": "item_health",
            "uuid": 18202296570773261971,
            "mp": 0,
        },
        {
            "id": 132,
            "name": "Large Medkit (132)",
            "classname": "item_health",
            "uuid": 12786701078015242201,
            "mp": 0,
        },
        {
            "id": 133,
            "name": "Shells (133)",
            "classname": "item_shells",
            "uuid": 6345146488573982364,
            "mp": 0,
        },
        {
            "id": 134,
            "name": "Shells (134)",
            "classname": "item_shells",
            "uuid": 7947169426799610058,
            "mp": 0,
        },
        {
            "id": 135,
            "name": "Shells (135)",
            "classname": "item_shells",
            "uuid": 13096374769921459424,
            "mp": 0,
        },
        {
            "id": 136,
            "name": "Rockets (136)",
            "classname": "item_rockets",
            "uuid": 2676366676596319028,
            "mp": 0,
        },
        {
            "id": 137,
            "name": "Cells (137)",
            "classname": "item_cells",
            "uuid": 17799967509765081535,
            "mp": 0,
        },
        {
            "id": 138,
            "name": "Spikes (138)",
            "classname": "item_spikes",
            "uuid": 18164883700040530554,
            "mp": 0,
        },
        {
            "id": 139,
            "name": "Shells (139)",
            "classname": "item_shells",
            "uuid": 14882065364962783954,
            "mp": 0,
        },
        {
            "id": 140,
            "name": "Shells (140)",
            "classname": "item_shells",
            "uuid": 2452241472223668909,
            "mp": 0,
        },
        {
            "id": 141,
            "name": "Rockets (141)",
            "classname": "item_rockets",
            "uuid": 9301057070494452568,
            "mp": 0,
        },
        {
            "id": 142,
            "name": "Rockets (142)",
            "classname": "item_rockets",
            "uuid": 11066040478556019118,
            "mp": 0,
        },
        {
            "id": 143,
            "name": "Shells (143)",
            "classname": "item_shells",
            "uuid": 11070255273257431994,
            "mp": 0,
        },
        {
            "id": 144,
            "name": "Shells (144)",
            "classname": "item_shells",
            "uuid": 14703324943182836200,
            "mp": 0,
        },
        {
            "id": 145,
            "name": "Small Medkit (145)",
            "classname": "item_health",
            "uuid": 3532755884498528970,
            "mp": 0,
        },
        {
            "id": 146,
            "name": "Shells (146)",
            "classname": "item_shells",
            "uuid": 13655474062918743990,
            "mp": 0,
        },
        {
            "id": 147,
            "name": "Spikes (147)",
            "classname": "item_spikes",
            "uuid": 6394016909417725865,
            "mp": 0,
        },
        {
            "id": 148,
            "name": "Spikes (148)",
            "classname": "item_spikes",
            "uuid": 6811383578751139493,
            "mp": 0,
        },
        {
            "id": 149,
            "name": "Cells (149)",
            "classname": "item_cells",
            "uuid": 7148895411753386485,
            "mp": 0,
        },
        {
            "id": 150,
            "name": "Shells (150)",
            "classname": "item_shells",
            "uuid": 14521133629676814135,
            "mp": 0,
        },
        {
            "id": 151,
            "name": "Shells (151)",
            "classname": "item_shells",
            "uuid": 76065089689325821,
            "mp": 0,
        },
        {
            "id": 152,
            "name": "Large Medkit (152)",
            "classname": "item_health",
            "uuid": 10361724274864401259,
            "mp": 0,
        },
        {
            "id": 153,
            "name": "Shells (153)",
            "classname": "item_shells",
            "uuid": 13630090720010407366,
            "mp": 0,
        },
        {
            "id": 154,
            "name": "Cells (154)",
            "classname": "item_cells",
            "uuid": 8895715280783683936,
            "mp": 0,
        },
        {
            "id": 155,
            "name": "Small Medkit (155)",
            "classname": "item_health",
            "uuid": 624203582047811457,
            "mp": 0,
        },
        {
            "id": 156,
            "name": "Large Medkit (156)",
            "classname": "item_health",
            "uuid": 12830577601743413326,
            "mp": 0,
        },
        {
            "id": 157,
            "name": "Green Armor (157)",
            "classname": "item_armor1",
            "uuid": 10451041611285206789,
            "mp": 0,
        },
        {
            "id": 158,
            "name": "Large Medkit (158)",
            "classname": "item_health",
            "uuid": 2329048154685355641,
            "mp": 0,
        },
        {
            "id": 159,
            "name": "Secret (159)",
            "classname": "trigger_secret",
            "uuid": 9031404189484686321,
            "mp": 0,
        },
        {
            "id": 160,
            "name": "Supershotgun (160)",
            "classname": "weapon_supershotgun",
            "uuid": 12514588163365535437,
            "mp": 0,
        },
        {
            "id": 161,
            "name": "Cells (161)",
            "classname": "item_cells",
            "uuid": 16523862096616827052,
            "mp": 0,
        },
        {
            "id": 162,
            "name": "Green Armor (162)",
            "classname": "item_armor1",
            "uuid": 3936420066346061340,
            "mp": 0,
        },
        {
            "id": 163,
            "name": "Spikes (163)",
            "classname": "item_spikes",
            "uuid": 2671635125920287614,
            "mp": 0,
        },
        {
            "id": 164,
            "name": "Large Medkit (164)",
            "classname": "item_health",
            "uuid": 2908942650683479102,
            "mp": 0,
        },
        {
            "id": 165,
            "name": "Large Medkit (165)",
            "classname": "item_health",
            "uuid": 9942097400818779443,
            "mp": 0,
        },
        {
            "id": 166,
            "name": "Large Medkit (166)",
            "classname": "item_health",
            "uuid": 9894459099897216010,
            "mp": 0,
        },
        {
            "id": 167,
            "name": "Shells (167)",
            "classname": "item_shells",
            "uuid": 7234386421918286950,
            "mp": 0,
        },
        {
            "id": 168,
            "name": "Spikes (168)",
            "classname": "item_spikes",
            "uuid": 15987727114902129137,
            "mp": 0,
        },
        {
            "id": 169,
            "name": "Spikes (169)",
            "classname": "item_spikes",
            "uuid": 17734695186024078339,
            "mp": 0,
        },
        {
            "id": 170,
            "name": "Spikes (170)",
            "classname": "item_spikes",
            "uuid": 12726990524592957401,
            "mp": 0,
        },
        {
            "id": 171,
            "name": "Large Medkit (171)",
            "classname": "item_health",
            "uuid": 7021915883696921426,
            "mp": 0,
        },
        {
            "id": 172,
            "name": "Red Armor (172)",
            "classname": "item_armorInv",
            "uuid": 15832393580719355605,
            "mp": 0,
        },
        {
            "id": 173,
            "name": "Rockets (173)",
            "classname": "item_rockets",
            "uuid": 13834220116944609189,
            "mp": 0,
        },
        {
            "id": 174,
            "name": "Secret (174)",
            "classname": "trigger_secret",
            "uuid": 17461361294149687217,
            "mp": 0,
        },
        {
            "id": 175,
            "name": "Megahealth (175)",
            "classname": "item_health",
            "uuid": 4579298996977386727,
            "mp": 0,
        },
        {
            "id": 176,
            "name": "All Kills (176)",
            "classname": "all_kills",
            "uuid": 179573745964452605,
            "mp": 0,
        },
    ]
    events = ["Button 1 Pushed", "Button 2 Pushed"]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [],
        )

        past_door_area = self.region(
            "Past Door Area",
            [
                "Supershotgun (160)",
                "Shells (19)",
                "Shells (18)",
                "Supernailgun (6)",
                "Rockets (124)",
                "Grenadelauncher (117)",
                "Spikes (7)",
                "Spikes (8)",
                "Green Armor (22)",
                "Small Medkit (64)",
                "Shells (85)",
                "Large Medkit (21)",
                "Large Medkit (63)",
                "Supershotgun (118)",
                "Shells (61)",
                "Shells (60)",
                "Shells (17)",
                "Large Medkit (5)",
                "Spikes (168)",
                "Spikes (169)",
                "Green Armor (83)",
                "Spikes (84)",
                "Secret (1)",
                "Shells (24)",
                "Rockets (79)",
                "Spikes (23)",
            ],
        )
        self.connect(ret, past_door_area, r.can_door)
        self.restrict("Green Armor (22)", r.jump)
        self.restrict("Small Medkit (64)", r.jump)
        self.restrict("Large Medkit (5)", r.jump)
        self.restrict("Spikes (168)", r.jump)
        self.restrict("Spikes (169)", r.jump)
        self.restrict("Green Armor (83)", r.jump)

        self.restrict("Secret (1)", r.can_shootswitch)
        self.restrict("Shells (24)", r.can_shootswitch)
        self.restrict("Rockets (79)", r.can_shootswitch)
        self.restrict("Spikes (23)", r.can_shootswitch)

        start_upper_right_area = self.region(
            "Start Upper Right",
            [
                "Small Medkit (104)",
                "Large Medkit (105)",
                "Button 1 Pushed",
            ],
        )
        self.connect(
            past_door_area,
            start_upper_right_area,
            (r.can_jump & r.can_button) | r.can_gj_extr | r.can_rj_hard | r.bigjump,
        )
        self.restrict("Button 1 Pushed", r.can_button)

        start_upper_left_area = self.region(
            "Start Upper Left",
            [
                "Spikes (20)",
                "Spikes (123)",
                "Button 2 Pushed",
            ],
        )
        self.connect(
            past_door_area,
            start_upper_left_area,
            (r.can_button & r.jump) | r.bigjump_hard,
        )
        self.restrict("Button 2 Pushed", r.can_button)

        past_button_area = self.region(
            "Past Button Area",
            [
                "Spikes (77)",
                "Spikes (78)",
                "Large Medkit (62)",
                "Shells (87)",
                "Shells (86)",
                "Spikes (115)",
                "Small Medkit (116)",
                "Yellow Armor (90)",
                "Large Medkit (158)",
            ],
        )
        self.connect(
            ret,
            past_button_area,
            self.event("Button 1 Pushed") & self.event("Button 2 Pushed"),
        )
        self.restrict("Spikes (77)", r.jump)
        self.restrict("Spikes (78)", r.jump)
        self.restrict("Large Medkit (62)", r.jump)

        dive_area = self.region(
            "Dive Area",
            [
                "Large Medkit (91)",
                "Shells (134)",
                "Shells (133)",
                "Green Armor (38)",
                "Rockets (69)",
                "Rockets (130)",
                "Large Medkit (82)",
                "Rocketlauncher (41)",
                "Shells (81)",
                "Shells (80)",
                "Large Medkit (66)",
                "Small Medkit (131)",
                "Spikes (68)",
                "Spikes (67)",
                "Secret (174)",
                "Rockets (173)",
                "Red Armor (172)",
                "Shells (43)",
                "Shells (42)",
                "Large Medkit (129)",
                "Secret (2)",
                "Quad Damage (31)",
                "Invisibility (119)",
                "Spikes (33)",
                "Spikes (32)",
                "Large Medkit (34)",
                "Large Medkit (132)",
                "Secret (3)",
                "Cells (39)",
                "Rockets (40)",
                "Shells (25)",
                "Shells (26)",
            ],
        )
        self.connect(past_button_area, dive_area, r.can_dive)

        self.restrict("Secret (174)", r.can_shootswitch)
        self.restrict("Rockets (173)", r.can_shootswitch)
        self.restrict("Red Armor (172)", r.can_shootswitch)

        jump_area = self.region(
            "Jump Area",
            [
                "Spikes (35)",
                "Spikes (125)",
                "Rockets (30)",
                "Large Medkit (28)",
                "Small Medkit (29)",
                "Spikes (126)",
                "Shells (45)",
                "Shells (46)",
                "Large Medkit (47)",
                "Large Medkit (65)",
                "Lightning (37)",
                "Cells (137)",
                "Large Medkit (156)",
                "Spikes (163)",
                "Spikes (138)",
                "Rockets (106)",
                "Secret (4)",
                "Large Medkit (107)",
                "Spikes (49)",
                "Cells (48)",
                "Shells (108)",
                "Green Armor (157)",
                "Large Medkit (171)",
                "Shells (140)",
                "Shells (139)",
                "Rockets (141)",
                "Spikes (121)",
                "Spikes (120)",
                "Shells (93)",
                "Shells (94)",
                "Rockets (142)",
                "Large Medkit (92)",
                "Cells (161)",
                "Spikes (95)",
                "Spikes (96)",
                "Shells (144)",
                "Shells (143)",
                "Megahealth (122)",
                "Green Armor (162)",
                "Spikes (170)",
                "Small Medkit (145)",
                "Large Medkit (109)",
                "Rockets (110)",
                "Large Medkit (88)",
                "Shells (167)",
                "Shells (153)",
                "Secret (73)",
                "Yellow Armor (56)",
                "Shells (146)",
                "Large Medkit (58)",
                "Spikes (57)",
                "Megahealth (175)",
                "Secret (159)",
                "Spikes (97)",
                "Spikes (98)",
                "Large Medkit (164)",
                "Large Medkit (74)",
                "Rockets (99)",
                "Shells (151)",
                "Shells (150)",
                "Cells (100)",
                "Cells (149)",
                "Shells (102)",
                "Spikes (103)",
                "Large Medkit (101)",
                "Spikes (148)",
                "Spikes (147)",
                "Yellow Armor (89)",
                "Shells (111)",
                "Shells (112)",
                "Large Medkit (152)",
                "Gold Key (55)",
            ],
        )
        self.connect(past_button_area, jump_area, r.jump)

        self.restrict("Secret (4)", r.can_shootswitch)
        self.restrict("Large Medkit (107)", r.can_shootswitch)
        self.restrict("Spikes (49)", r.can_shootswitch)
        self.restrict("Cells (48)", r.can_shootswitch)
        self.restrict("Shells (108)", r.can_shootswitch)
        self.restrict("Secret (73)", r.can_shootswitch)
        self.restrict("Yellow Armor (56)", r.can_shootswitch)
        self.restrict("Megahealth (175)", r.can_shootswitch)
        self.restrict("Secret (159)", r.can_shootswitch)
        self.restrict(
            "Gold Key (55)",
            r.can_button
            | (r.quad_dmg(1) & r.invuln(1) & r.bigjump & r.difficulty("extreme")),
        )

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Rockets (75)",
                "Large Medkit (113)",
                "Cells (154)",
                "Spikes (114)",
                "Megahealth (59)",
                "Sigil (54)",
                "Small Medkit (155)",
                "Exit",
                "All Kills (176)",
            ],
        )
        self.connect(jump_area, past_gold_door_area, self.gold_key)
        self.restrict("Megahealth (59)", r.can_jump | r.can_gj_extr | r.can_rj_hard)
        self.restrict("Sigil (54)", r.can_jump | r.can_gj_extr | r.can_rj_hard)
        self.restrict("Small Medkit (155)", r.can_jump | r.can_gj_extr | r.can_rj_hard)
        self.restrict("Exit", r.can_jump | r.can_gj_extr | r.can_rj_hard)
        self.restrict("All Kills (176)", r.difficult_combat)

        post_dive_area = self.region(
            "Post Dive",
            [
                "Large Medkit (166)",
                "Shells (127)",
                "Shells (27)",
                "Yellow Armor (16)",
                "Cells (13)",
                "Cells (14)",
                "Spikes (36)",
                "Silver Key (9)",
                "Spikes (128)",
                "Shells (10)",
                "Large Medkit (165)",
                "Megahealth (15)",
                "Rockets (11)",
                "Rockets (12)",
                "Spikes (44)",
            ],
        )
        self.connect(jump_area, post_dive_area)
        self.connect(dive_area, post_dive_area)

        self.restrict("Spikes (44)", r.jump)

        shootswitch_area = self.region(
            "Shootswitch Area",
            [
                "Large Medkit (50)",
                "Large Medkit (51)",
                "Shells (135)",
                "Rockets (136)",
                "Spikes (52)",
                "Spikes (53)",
                "Secret (71)",
                "Quad Damage (70)",
                "Large Medkit (72)",
            ],
        )
        self.connect(past_button_area, shootswitch_area, r.can_shootswitch)

        return ret
