from BaseClasses import Region

from ..base_classes import Q1Level


class hip3m1(Q1Level):
    name = "Tur Torment"
    mapfile = "hip3m1"
    keys = ["Silver", "Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Silver Key (1)",
            "classname": "item_key1",
            "uuid": 10346192896876066851,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Nailgun (2)",
            "classname": "weapon_nailgun",
            "uuid": 1319231290935259209,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Large Medkit (3)",
            "classname": "item_health",
            "uuid": 7773616154840615408,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Shells (4)",
            "classname": "item_shells",
            "uuid": 2539541582400188162,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Spikes (5)",
            "classname": "item_spikes",
            "uuid": 3146691762135791135,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Yellow Armor (6)",
            "classname": "item_armor2",
            "uuid": 4016534940037860516,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Rocketlauncher (7)",
            "classname": "weapon_rocketlauncher",
            "uuid": 12311421275620382687,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Large Medkit (8)",
            "classname": "item_health",
            "uuid": 10117289644783045482,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Large Medkit (9)",
            "classname": "item_health",
            "uuid": 4047785504103343990,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Shells (10)",
            "classname": "item_shells",
            "uuid": 8005385098773337788,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Spikes (11)",
            "classname": "item_spikes",
            "uuid": 8680706570963311122,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Rockets (12)",
            "classname": "item_rockets",
            "uuid": 4316609715734410038,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Rockets (13)",
            "classname": "item_rockets",
            "uuid": 14492354303413218498,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Rockets (14)",
            "classname": "item_rockets",
            "uuid": 1513114560099916138,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Laser (15)",
            "classname": "weapon_laser_gun",
            "uuid": 13304786822359275150,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Spikes (16)",
            "classname": "item_spikes",
            "uuid": 8128038651429832033,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Hornofconjuring (17)",
            "classname": "item_hornofconjuring",
            "uuid": 18274316579048443759,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Rockets (18)",
            "classname": "item_rockets",
            "uuid": 18170496607035364281,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Rockets (19)",
            "classname": "item_rockets",
            "uuid": 5107828835531996743,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Yellow Armor (20)",
            "classname": "item_armor2",
            "uuid": 4865443840426873314,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Large Medkit (21)",
            "classname": "item_health",
            "uuid": 2671809333414943661,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Shells (22)",
            "classname": "item_shells",
            "uuid": 4894145944298740792,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Spikes (23)",
            "classname": "item_spikes",
            "uuid": 12841609801940046999,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Megahealth (24)",
            "classname": "item_health",
            "uuid": 4202154594516499071,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Gold Key (25)",
            "classname": "item_key2",
            "uuid": 17619870483879513020,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Invulnerability (26)",
            "classname": "item_artifact_invulnerability",
            "uuid": 4906672580746844807,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Biosuit (27)",
            "classname": "item_artifact_envirosuit",
            "uuid": 8285065351982586649,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Shells (28)",
            "classname": "item_shells",
            "uuid": 16169750762297779031,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Biosuit (29)",
            "classname": "item_artifact_envirosuit",
            "uuid": 10885790237025347980,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Red Armor (30)",
            "classname": "item_armorInv",
            "uuid": 12925911416829655396,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Large Medkit (31)",
            "classname": "item_health",
            "uuid": 13256212105202650346,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Rockets (32)",
            "classname": "item_rockets",
            "uuid": 15617068583045534473,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Shells (33)",
            "classname": "item_shells",
            "uuid": 15801692897417313416,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Spikes (34)",
            "classname": "item_spikes",
            "uuid": 51226188034566734,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Large Medkit (35)",
            "classname": "item_health",
            "uuid": 1105708492844439816,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Large Medkit (36)",
            "classname": "item_health",
            "uuid": 2764078185743176350,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Rockets (37)",
            "classname": "item_rockets",
            "uuid": 2109815422396255453,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Rockets (38)",
            "classname": "item_rockets",
            "uuid": 11303710647000406717,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Biosuit (39)",
            "classname": "item_artifact_envirosuit",
            "uuid": 479487426397523896,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 8494427121642518531,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Secret (41)",
            "classname": "trigger_secret",
            "uuid": 17661442444572789137,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Proximity (42)",
            "classname": "weapon_proximity_gun",
            "uuid": 5430047110279163470,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Grenadelauncher (43)",
            "classname": "weapon_grenadelauncher",
            "uuid": 3750760850210092259,
            "mp": 1,
        },
        {
            "id": 44,
            "name": "Rocketlauncher (44)",
            "classname": "weapon_rocketlauncher",
            "uuid": 4268988552725269247,
            "mp": 1,
        },
        {
            "id": 45,
            "name": "Cells (45)",
            "classname": "item_cells",
            "uuid": 453537447269381045,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Spikes (46)",
            "classname": "item_spikes",
            "uuid": 16230417758622110675,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Large Medkit (47)",
            "classname": "item_health",
            "uuid": 994566969016628662,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Invisibility (48)",
            "classname": "item_artifact_invisibility",
            "uuid": 3053160723592112277,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Large Medkit (49)",
            "classname": "item_health",
            "uuid": 17045705251809006778,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Large Medkit (50)",
            "classname": "item_health",
            "uuid": 13504846632032544211,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Yellow Armor (51)",
            "classname": "item_armor2",
            "uuid": 5594621923241480164,
            "mp": 1,
        },
        {
            "id": 52,
            "name": "Large Medkit (52)",
            "classname": "item_health",
            "uuid": 17322175807603387940,
            "mp": 1,
        },
        {
            "id": 53,
            "name": "Mjolnir (53)",
            "classname": "weapon_mjolnir",
            "uuid": 1358152295255470950,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Proximity (54)",
            "classname": "weapon_proximity_gun",
            "uuid": 15525344977167789905,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Cells (55)",
            "classname": "item_cells",
            "uuid": 17948350558937489752,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Cells (56)",
            "classname": "item_cells",
            "uuid": 16493826110917747645,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Cells (57)",
            "classname": "item_cells",
            "uuid": 16874693670269419079,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Empathy (58)",
            "classname": "item_artifact_empathy_shields",
            "uuid": 7715105043995693646,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Secret (59)",
            "classname": "trigger_secret",
            "uuid": 10078341405979867984,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Secret (60)",
            "classname": "trigger_secret",
            "uuid": 787703620148614239,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Secret (61)",
            "classname": "trigger_secret",
            "uuid": 1749576599527608287,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Rockets (62)",
            "classname": "item_rockets",
            "uuid": 6448061293878522375,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Secret (63)",
            "classname": "trigger_secret",
            "uuid": 10380403545931205312,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Secret (64)",
            "classname": "trigger_secret",
            "uuid": 860237353902943221,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Rockets (65)",
            "classname": "item_rockets",
            "uuid": 624732232177598498,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Spikes (66)",
            "classname": "item_spikes",
            "uuid": 14957899897885131569,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Cells (67)",
            "classname": "item_cells",
            "uuid": 5696189160392252140,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Large Medkit (68)",
            "classname": "item_health",
            "uuid": 16021098304836652765,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Large Medkit (69)",
            "classname": "item_health",
            "uuid": 10097063069141362598,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Lightning (70)",
            "classname": "weapon_lightning",
            "uuid": 8328583343011224386,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Supernailgun (71)",
            "classname": "weapon_supernailgun",
            "uuid": 6541240284123724032,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Quad Damage (72)",
            "classname": "item_artifact_super_damage",
            "uuid": 13007191179832604861,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Supershotgun (73)",
            "classname": "weapon_supershotgun",
            "uuid": 10732253445919078950,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "All Kills (74)",
            "classname": "all_kills",
            "uuid": 18203952588679227396,
            "mp": 0,
        },
    ]

    must_bio = True
    must_invuln = True

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Supershotgun (73)",
                "Biosuit (27)",
                "Shells (4)",
                "Large Medkit (3)",
                "Secret (61)",
                "Rockets (62)",
                "Spikes (5)",
                "Nailgun (2)",
                "Large Medkit (8)",
                "Large Medkit (9)",
                "Shells (10)",
                "Spikes (11)",
                "Rocketlauncher (7)",
                "Rockets (12)",
                "Biosuit (39)",
                "Yellow Armor (6)",
                "Rockets (38)",
                "Grenadelauncher (43)",
            ],
        )

        self.restrict("Rockets (62)", r.can_door)
        self.restrict("Rockets (38)", r.can_dive & (r.biosuit(1) | r.invuln(1)))
        self.restrict("Grenadelauncher (43)", r.can_dive & (r.biosuit(1) | r.invuln(1)))

        start_top_area = self.region(
            "Start Top",
            [
                "Spikes (66)",
                "Rockets (65)",
                "Megahealth (24)",
                "Secret (63)",
                "Rockets (37)",
                "Secret (64)",
                "Rockets (14)",
                "Rockets (13)",
                "Laser (15)",
                "Lightning (70)",
                "Large Medkit (69)",
                "Large Medkit (68)",
                "Cells (57)",
                "Cells (56)",
                "Cells (67)",
                "Cells (55)",
                "Rockets (32)",
                "Shells (33)",
                "Spikes (34)",
                "Large Medkit (31)",
                "Biosuit (29)",
                "Large Medkit (35)",
                "Large Medkit (36)",
                "Spikes (16)",
                "Shells (28)",
                "Supernailgun (71)",
                "Silver Key (1)",
                "Cells (45)",
                "Spikes (46)",
                "Mjolnir (53)",
                "Large Medkit (47)",
                "Empathy (58)",
                "Invisibility (48)",
                "Large Medkit (49)",
                "Large Medkit (50)",
                "Secret (41)",
                "Secret (60)",
                "Quad Damage (72)",
                "Red Armor (30)",
            ],
        )
        self.connect(
            ret,
            start_top_area,
            self.silver_key | (r.can_button & r.jump) | r.bigjump_hard,
        )
        self.restrict("Empathy (58)", r.jump)
        self.restrict("Invisibility (48)", r.can_shootswitch)
        self.restrict("Large Medkit (49)", r.can_shootswitch)
        self.restrict("Large Medkit (50)", r.can_shootswitch)
        self.restrict("Secret (41)", r.can_shootswitch)
        self.restrict("Secret (60)", r.can_door | r.bigjump_hard)
        self.restrict("Quad Damage (72)", r.can_door | r.bigjump_hard)

        self.restrict("Red Armor (30)", r.can_dive & (r.biosuit(1) | r.invuln(1)))

        past_silver_door_area = self.region(
            "Past Silver Door",
            [
                "Proximity (42)",
                "Large Medkit (21)",
                "Shells (22)",
                "Spikes (23)",
                "Secret (59)",
                "Rockets (18)",
                "Yellow Armor (20)",
                "Large Medkit (52)",
                "Rockets (19)",
                "Hornofconjuring (17)",
                "Gold Key (25)",
                "Yellow Armor (51)",
            ],
        )
        self.connect(start_top_area, past_silver_door_area, self.silver_key)

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Invulnerability (26)",
                "Proximity (54)",
                "Exit",
                "All Kills (74)",
            ],
        )
        self.connect(past_silver_door_area, past_gold_door_area, self.gold_key)
        self.restrict("Invulnerability (26)", r.bigjump)

        self.restrict("All Kills (74)", r.can_button & r.difficult_combat)

        return ret
