from BaseClasses import Region

from ..base_classes import Q1Level


class hip2m2(Q1Level):
    name = "The Black Cathedral"
    mapfile = "hip2m2"
    keys = ["Silver", "Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 3380104057780444312,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Gold Key (2)",
            "classname": "item_key2",
            "uuid": 10991860942554118598,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Silver Key (3)",
            "classname": "item_key1",
            "uuid": 3999651645819522461,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Secret (4)",
            "classname": "trigger_secret",
            "uuid": 14080797271003749873,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Invulnerability (5)",
            "classname": "item_artifact_invulnerability",
            "uuid": 17534671053436500953,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Secret (6)",
            "classname": "trigger_secret",
            "uuid": 10631320121305379574,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Secret (7)",
            "classname": "trigger_secret",
            "uuid": 3756818772600071125,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Megahealth (8)",
            "classname": "item_health",
            "uuid": 15788160548468393869,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Secret (9)",
            "classname": "trigger_secret",
            "uuid": 10893323054016461988,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Secret (10)",
            "classname": "trigger_secret",
            "uuid": 330748747796877818,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Large Medkit (11)",
            "classname": "item_health",
            "uuid": 10146644040200681529,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Large Medkit (12)",
            "classname": "item_health",
            "uuid": 2295544923020264252,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Supershotgun (13)",
            "classname": "weapon_supershotgun",
            "uuid": 9988941044854784582,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Nailgun (14)",
            "classname": "weapon_nailgun",
            "uuid": 3329599961636059347,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Shells (15)",
            "classname": "item_shells",
            "uuid": 845706788244675568,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Spikes (16)",
            "classname": "item_spikes",
            "uuid": 4362694171991862358,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Small Medkit (17)",
            "classname": "item_health",
            "uuid": 4645120654556830309,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Shells (18)",
            "classname": "item_shells",
            "uuid": 8583862115973045078,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Small Medkit (19)",
            "classname": "item_health",
            "uuid": 14766072137268084799,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Spikes (20)",
            "classname": "item_spikes",
            "uuid": 14236380072327373438,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Grenadelauncher (21)",
            "classname": "weapon_grenadelauncher",
            "uuid": 1595958490241732591,
            "mp": 1,
        },
        {
            "id": 22,
            "name": "Small Medkit (22)",
            "classname": "item_health",
            "uuid": 15537316713249893903,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Small Medkit (23)",
            "classname": "item_health",
            "uuid": 8967598096637937496,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Small Medkit (24)",
            "classname": "item_health",
            "uuid": 17548852807986586951,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Spikes (25)",
            "classname": "item_spikes",
            "uuid": 14725639212132940860,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Shells (26)",
            "classname": "item_shells",
            "uuid": 2554369445018272303,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Spikes (27)",
            "classname": "item_spikes",
            "uuid": 15163165276904173290,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Rockets (28)",
            "classname": "item_rockets",
            "uuid": 11152309816878006102,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Small Medkit (29)",
            "classname": "item_health",
            "uuid": 114558262433891216,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Small Medkit (30)",
            "classname": "item_health",
            "uuid": 1376331583239030066,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Shells (31)",
            "classname": "item_shells",
            "uuid": 17540352636368400216,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Cells (32)",
            "classname": "item_cells",
            "uuid": 17830977705814310655,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Small Medkit (33)",
            "classname": "item_health",
            "uuid": 16136013462887304343,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Small Medkit (34)",
            "classname": "item_health",
            "uuid": 12647839214576818172,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Megahealth (35)",
            "classname": "item_health",
            "uuid": 13123070179753150906,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Rocketlauncher (36)",
            "classname": "weapon_rocketlauncher",
            "uuid": 12627362808261768863,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Spikes (37)",
            "classname": "item_spikes",
            "uuid": 7985496488983365535,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Spikes (38)",
            "classname": "item_spikes",
            "uuid": 8394809435173286565,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Small Medkit (39)",
            "classname": "item_health",
            "uuid": 418860028931429713,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Small Medkit (40)",
            "classname": "item_health",
            "uuid": 16421909164495034212,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Spikes (41)",
            "classname": "item_spikes",
            "uuid": 7324917416841019420,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Shells (42)",
            "classname": "item_shells",
            "uuid": 1368862968080175864,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Spikes (43)",
            "classname": "item_spikes",
            "uuid": 3834494068133717805,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Spikes (44)",
            "classname": "item_spikes",
            "uuid": 10631428949833799577,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Cells (45)",
            "classname": "item_cells",
            "uuid": 1440974912483984935,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Large Medkit (46)",
            "classname": "item_health",
            "uuid": 4979201882019064477,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Rockets (47)",
            "classname": "item_rockets",
            "uuid": 13719723532700436766,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Large Medkit (48)",
            "classname": "item_health",
            "uuid": 9870970770579249706,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Large Medkit (49)",
            "classname": "item_health",
            "uuid": 6122529764923473797,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Spikes (50)",
            "classname": "item_spikes",
            "uuid": 18013982077054530470,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Shells (51)",
            "classname": "item_shells",
            "uuid": 13435518505581483689,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Spikes (52)",
            "classname": "item_spikes",
            "uuid": 8692738119379303816,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Large Medkit (53)",
            "classname": "item_health",
            "uuid": 10359595495724890982,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Large Medkit (54)",
            "classname": "item_health",
            "uuid": 9440108711136921656,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Shells (55)",
            "classname": "item_shells",
            "uuid": 1899993135899530149,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Spikes (56)",
            "classname": "item_spikes",
            "uuid": 17918457771848834898,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Cells (57)",
            "classname": "item_cells",
            "uuid": 14379807720981527027,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Cells (58)",
            "classname": "item_cells",
            "uuid": 9635484151518436290,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Small Medkit (59)",
            "classname": "item_health",
            "uuid": 3708496891295509255,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Small Medkit (60)",
            "classname": "item_health",
            "uuid": 15940411377018746588,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Invisibility (61)",
            "classname": "item_artifact_invisibility",
            "uuid": 5030720957999193176,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Spikes (62)",
            "classname": "item_spikes",
            "uuid": 5128184849839921776,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Large Medkit (63)",
            "classname": "item_health",
            "uuid": 3353517588267962239,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Large Medkit (64)",
            "classname": "item_health",
            "uuid": 12869829659045448358,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Shells (65)",
            "classname": "item_shells",
            "uuid": 15182458371184537680,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Cells (66)",
            "classname": "item_cells",
            "uuid": 8826319561328419399,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Cells (67)",
            "classname": "item_cells",
            "uuid": 17523755029977286309,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Large Medkit (68)",
            "classname": "item_health",
            "uuid": 2091610060132539528,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Large Medkit (69)",
            "classname": "item_health",
            "uuid": 1789651753568557703,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Shells (70)",
            "classname": "item_shells",
            "uuid": 5905593167850559684,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Spikes (71)",
            "classname": "item_spikes",
            "uuid": 2593119161410725304,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Large Medkit (72)",
            "classname": "item_health",
            "uuid": 8648384369565089352,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Large Medkit (73)",
            "classname": "item_health",
            "uuid": 18177031946922870273,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Yellow Armor (74)",
            "classname": "item_armor2",
            "uuid": 11081975011543847501,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Quad Damage (75)",
            "classname": "item_artifact_super_damage",
            "uuid": 6247610316188716499,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Spikes (76)",
            "classname": "item_spikes",
            "uuid": 11813891167412676767,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Spikes (77)",
            "classname": "item_spikes",
            "uuid": 7414198306769416901,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Rockets (78)",
            "classname": "item_rockets",
            "uuid": 11200596560657034240,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Lightning (79)",
            "classname": "weapon_lightning",
            "uuid": 9880877661968082896,
            "mp": 1,
        },
        {
            "id": 80,
            "name": "Cells (80)",
            "classname": "item_cells",
            "uuid": 1974249626646830844,
            "mp": 1,
        },
        {
            "id": 81,
            "name": "Cells (81)",
            "classname": "item_cells",
            "uuid": 9901220507131677118,
            "mp": 1,
        },
        {
            "id": 82,
            "name": "Supernailgun (82)",
            "classname": "weapon_supernailgun",
            "uuid": 5558959608903146812,
            "mp": 1,
        },
        {
            "id": 83,
            "name": "Large Medkit (83)",
            "classname": "item_health",
            "uuid": 13226957895736923272,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Large Medkit (84)",
            "classname": "item_health",
            "uuid": 15132066796377441431,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Large Medkit (85)",
            "classname": "item_health",
            "uuid": 8146823857415808735,
            "mp": 0,
        },
        {
            "id": 86,
            "name": "Large Medkit (86)",
            "classname": "item_health",
            "uuid": 1279514969387456745,
            "mp": 0,
        },
        {
            "id": 87,
            "name": "Mjolnir (87)",
            "classname": "weapon_mjolnir",
            "uuid": 10920802442484162658,
            "mp": 1,
        },
        {
            "id": 88,
            "name": "Spikes (88)",
            "classname": "item_spikes",
            "uuid": 2112379624583789132,
            "mp": 0,
        },
        {
            "id": 89,
            "name": "Rockets (89)",
            "classname": "item_rockets",
            "uuid": 8645671318423213321,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "Supershotgun (90)",
            "classname": "weapon_supershotgun",
            "uuid": 13523839740768914230,
            "mp": 1,
        },
        {
            "id": 91,
            "name": "Megahealth (91)",
            "classname": "item_health",
            "uuid": 6067624605736806092,
            "mp": 0,
        },
        {
            "id": 92,
            "name": "Nailgun (92)",
            "classname": "weapon_nailgun",
            "uuid": 6290386302158777751,
            "mp": 1,
        },
        {
            "id": 93,
            "name": "Laser (93)",
            "classname": "weapon_laser_gun",
            "uuid": 15672995484231646183,
            "mp": 1,
        },
        {
            "id": 94,
            "name": "Proximity (94)",
            "classname": "weapon_proximity_gun",
            "uuid": 16238618617932285735,
            "mp": 1,
        },
        {
            "id": 95,
            "name": "Empathy (95)",
            "classname": "item_artifact_empathy_shields",
            "uuid": 10907622972463261303,
            "mp": 1,
        },
        {
            "id": 96,
            "name": "Red Armor (96)",
            "classname": "item_armorInv",
            "uuid": 10028401771134495659,
            "mp": 0,
        },
        {
            "id": 97,
            "name": "Shells (97)",
            "classname": "item_shells",
            "uuid": 2743153799159427141,
            "mp": 0,
        },
        {
            "id": 98,
            "name": "Spikes (98)",
            "classname": "item_spikes",
            "uuid": 15403291364342959881,
            "mp": 0,
        },
        {
            "id": 99,
            "name": "Rockets (99)",
            "classname": "item_rockets",
            "uuid": 17235294461568397030,
            "mp": 0,
        },
        {
            "id": 100,
            "name": "Spikes (100)",
            "classname": "item_spikes",
            "uuid": 11236838652739028643,
            "mp": 0,
        },
        {
            "id": 101,
            "name": "Spikes (101)",
            "classname": "item_spikes",
            "uuid": 13184862968030869266,
            "mp": 0,
        },
        {
            "id": 102,
            "name": "Shells (102)",
            "classname": "item_shells",
            "uuid": 4658793059602471019,
            "mp": 0,
        },
        {
            "id": 103,
            "name": "Spikes (103)",
            "classname": "item_spikes",
            "uuid": 318303515612480238,
            "mp": 0,
        },
        {
            "id": 104,
            "name": "Rockets (104)",
            "classname": "item_rockets",
            "uuid": 12837194479192764674,
            "mp": 0,
        },
        {
            "id": 105,
            "name": "Spikes (105)",
            "classname": "item_spikes",
            "uuid": 14476952504893009493,
            "mp": 0,
        },
        {
            "id": 106,
            "name": "Rockets (106)",
            "classname": "item_rockets",
            "uuid": 7535735957221391200,
            "mp": 0,
        },
        {
            "id": 107,
            "name": "All Kills (107)",
            "classname": "all_kills",
            "uuid": 18304061567422109772,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Spikes (16)",
                "Nailgun (14)",
                "Large Medkit (12)",
                "Yellow Armor (74)",
                "Large Medkit (11)",
                "Supershotgun (13)",
                "Shells (15)",
                "Supershotgun (90)",
                "Small Medkit (19)",
                "Spikes (101)",
                "Spikes (20)",
                "Small Medkit (17)",
                "Shells (102)",
                "Shells (18)",
                "Spikes (25)",
                "Shells (26)",
                "Small Medkit (29)",
                "Small Medkit (30)",
                "Spikes (27)",
                "Rockets (28)",
                "Cells (32)",
                "Shells (31)",
                "Megahealth (35)",
            ],
        )

        past_door_area = self.region(
            "Past Door Area",
            [
                "Small Medkit (23)",
                "Small Medkit (33)",
                "Spikes (37)",
                "Spikes (38)",
                "Small Medkit (34)",
                "Small Medkit (24)",
                "Rocketlauncher (36)",
            ],
        )
        self.connect(ret, past_door_area, r.can_door)

        past_button_area = self.region(
            "Past Button Area",
            [
                "Small Medkit (39)",
                "Spikes (41)",
                "Small Medkit (40)",
                "Spikes (44)",
                "Cells (45)",
                "Large Medkit (46)",
                "Spikes (52)",
                "Laser (93)",
                "Shells (42)",
                "Spikes (43)",
                "Large Medkit (53)",
                "Spikes (103)",
                "Spikes (88)",
                "Rockets (89)",
                "Rockets (104)",
                "Grenadelauncher (21)",
                "Large Medkit (54)",
                "Nailgun (92)",
                "Mjolnir (87)",
                "Red Armor (96)",
                "Large Medkit (48)",
                "Large Medkit (49)",
                "Rockets (47)",
                "Shells (51)",
                "Proximity (94)",
                "Spikes (50)",
                "Rockets (99)",
                "Rockets (78)",
                "Supernailgun (82)",
                "Shells (55)",
                "Small Medkit (59)",
                "Spikes (56)",
                "Spikes (100)",
                "Large Medkit (84)",
                "Large Medkit (83)",
                "Cells (58)",
                "Cells (57)",
                "Small Medkit (60)",
                "Spikes (105)",
                "Secret (4)",
                "Invisibility (61)",
                "Empathy (95)",
                "Small Medkit (22)",
                "Rockets (106)",
                "Secret (10)",
                "Quad Damage (75)",
                "Secret (6)",
                "Invulnerability (5)",
            ],
        )
        self.connect(past_door_area, past_button_area, r.can_button)

        self.restrict("Secret (4)", r.can_shootswitch)
        self.restrict("Invisibility (61)", r.can_shootswitch)
        self.restrict("Secret (10)", r.can_button)
        self.restrict("Quad Damage (75)", r.can_button)
        self.restrict("Secret (6)", r.can_button)
        self.restrict("Invulnerability (5)", r.can_button)

        past_silver_door_area = self.region(
            "Past Silver Door",
            [
                "Gold Key (2)",
            ],
        )
        self.connect(ret, past_silver_door_area, self.silver_key)

        self.connect(past_silver_door_area, past_button_area, r.jump)

        self.connect(past_button_area, past_silver_door_area, r.bigjump_hard)

        cathedral_secret_area = self.region(
            "Cathedral Secret",
            [
                "Secret (7)",
                "Megahealth (8)",
            ],
        )
        self.connect(past_door_area, cathedral_secret_area, r.can_shootswitch)
        self.connect(ret, cathedral_secret_area, r.bigjump_hard)

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Spikes (98)",
                "Shells (97)",
                "Large Medkit (73)",
                "Large Medkit (72)",
                "Spikes (71)",
                "Shells (70)",
                "Lightning (79)",
                "Cells (80)",
                "Cells (81)",
                "Secret (9)",
                "Megahealth (91)",
                "Exit",
                "All Kills (107)",
            ],
        )
        self.connect(past_button_area, past_gold_door_area, self.gold_key)
        self.restrict("Secret (9)", r.can_shootswitch)
        self.restrict("Megahealth (91)", r.can_shootswitch)
        self.restrict("Exit", r.can_button)
        self.restrict(
            "All Kills (107)",
            r.difficult_combat & (r.can_button & (self.silver_key | r.bigjump_hard)),
        )

        tower_area = self.region(
            "Tower Area",
            [
                "Spikes (62)",
                "Large Medkit (63)",
                "Large Medkit (64)",
                "Large Medkit (86)",
                "Large Medkit (85)",
                "Shells (65)",
                "Cells (66)",
                "Large Medkit (69)",
                "Large Medkit (68)",
                "Cells (67)",
                "Silver Key (3)",
                "Spikes (76)",
                "Spikes (77)",
            ],
        )
        self.connect(past_button_area, tower_area, r.can_button)

        return ret
