from BaseClasses import Region

from ..base_classes import Q1Level


class e2m3(Q1Level):
    name = "The Crypt Of Decay"
    mapfile = "e2m3"
    keys = ["Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Large Medkit (1)",
            "classname": "item_health",
            "uuid": 5911236173412116537,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Gold Key (2)",
            "classname": "item_key2",
            "uuid": 7931451070164385808,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Shells (3)",
            "classname": "item_shells",
            "uuid": 6267764163917675493,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Nailgun (4)",
            "classname": "weapon_nailgun",
            "uuid": 7131746598830874617,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Megahealth (5)",
            "classname": "item_health",
            "uuid": 17892134499342102292,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Green Armor (6)",
            "classname": "item_armor1",
            "uuid": 6989813567172644861,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Shells (7)",
            "classname": "item_shells",
            "uuid": 8629862684095950847,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Nailgun (8)",
            "classname": "weapon_nailgun",
            "uuid": 5785290351702252566,
            "mp": 1,
        },
        {
            "id": 9,
            "name": "Rocketlauncher (9)",
            "classname": "weapon_rocketlauncher",
            "uuid": 12623382620585893961,
            "mp": 1,
        },
        {
            "id": 10,
            "name": "Grenadelauncher (10)",
            "classname": "weapon_grenadelauncher",
            "uuid": 9312214024796691772,
            "mp": 1,
        },
        {
            "id": 11,
            "name": "Spikes (11)",
            "classname": "item_spikes",
            "uuid": 10145968705134592210,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Rockets (12)",
            "classname": "item_rockets",
            "uuid": 18265987794544067890,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Spikes (13)",
            "classname": "item_spikes",
            "uuid": 11142170152148549631,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Large Medkit (14)",
            "classname": "item_health",
            "uuid": 3381951564936514251,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Large Medkit (15)",
            "classname": "item_health",
            "uuid": 12722675033181568144,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Shells (16)",
            "classname": "item_shells",
            "uuid": 17632332068136293689,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Small Medkit (17)",
            "classname": "item_health",
            "uuid": 14042082239299142880,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Large Medkit (18)",
            "classname": "item_health",
            "uuid": 357600099601309042,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Spikes (19)",
            "classname": "item_spikes",
            "uuid": 12215659972825660974,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Rockets (20)",
            "classname": "item_rockets",
            "uuid": 11603287086674078425,
            "mp": 1,
        },
        {
            "id": 21,
            "name": "Megahealth (21)",
            "classname": "item_health",
            "uuid": 11079391361456415561,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Rockets (22)",
            "classname": "item_rockets",
            "uuid": 8986791847135781504,
            "mp": 1,
        },
        {
            "id": 23,
            "name": "Grenadelauncher (23)",
            "classname": "weapon_grenadelauncher",
            "uuid": 18410550064757845612,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Rockets (24)",
            "classname": "item_rockets",
            "uuid": 294300189250709793,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Large Medkit (25)",
            "classname": "item_health",
            "uuid": 5680690627800391111,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Large Medkit (26)",
            "classname": "item_health",
            "uuid": 10331478062259651736,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Small Medkit (27)",
            "classname": "item_health",
            "uuid": 6600923541625903340,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Small Medkit (28)",
            "classname": "item_health",
            "uuid": 18376463911611425068,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Large Medkit (29)",
            "classname": "item_health",
            "uuid": 13162114022429208528,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Large Medkit (30)",
            "classname": "item_health",
            "uuid": 8222784840565284382,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Shells (31)",
            "classname": "item_shells",
            "uuid": 6056914730080841936,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Rockets (32)",
            "classname": "item_rockets",
            "uuid": 10575490820858546595,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Large Medkit (33)",
            "classname": "item_health",
            "uuid": 8027440473261433351,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Large Medkit (34)",
            "classname": "item_health",
            "uuid": 11369023945274062363,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Large Medkit (35)",
            "classname": "item_health",
            "uuid": 11960507011013602508,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Shells (36)",
            "classname": "item_shells",
            "uuid": 11821786479476126884,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Large Medkit (37)",
            "classname": "item_health",
            "uuid": 8968381302586175130,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Large Medkit (38)",
            "classname": "item_health",
            "uuid": 9572762448829629582,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Large Medkit (39)",
            "classname": "item_health",
            "uuid": 1169845290805313763,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Spikes (40)",
            "classname": "item_spikes",
            "uuid": 3743890434107353394,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Rockets (41)",
            "classname": "item_rockets",
            "uuid": 15617816656920750896,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Supernailgun (42)",
            "classname": "weapon_supernailgun",
            "uuid": 14476495501296469476,
            "mp": 1,
        },
        {
            "id": 43,
            "name": "Yellow Armor (43)",
            "classname": "item_armor2",
            "uuid": 5076883672857022847,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Spikes (44)",
            "classname": "item_spikes",
            "uuid": 16777480235346573217,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Spikes (45)",
            "classname": "item_spikes",
            "uuid": 13692391488085754583,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Large Medkit (46)",
            "classname": "item_health",
            "uuid": 2968169719798754003,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Large Medkit (47)",
            "classname": "item_health",
            "uuid": 13580822875731285244,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Large Medkit (48)",
            "classname": "item_health",
            "uuid": 18086462625783830190,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Rockets (49)",
            "classname": "item_rockets",
            "uuid": 12032843391752658858,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Red Armor (50)",
            "classname": "item_armorInv",
            "uuid": 13896108125412303626,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 13181525766375228047,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Secret (52)",
            "classname": "trigger_secret",
            "uuid": 18257941908998272465,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Secret (53)",
            "classname": "trigger_secret",
            "uuid": 6577108659028706915,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Secret Exit",
            "classname": "trigger_changelevel",
            "uuid": 3398952533708778163,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Spikes (55)",
            "classname": "item_spikes",
            "uuid": 7905417649023544770,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Supernailgun (56)",
            "classname": "weapon_supernailgun",
            "uuid": 11842580421292836,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Quad Damage (57)",
            "classname": "item_artifact_super_damage",
            "uuid": 4212818289658318334,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Yellow Armor (58)",
            "classname": "item_armor2",
            "uuid": 11033464970439141352,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Secret (59)",
            "classname": "trigger_secret",
            "uuid": 16401570662458260679,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Quad Damage (60)",
            "classname": "item_artifact_super_damage",
            "uuid": 4262992238236922475,
            "mp": 1,
        },
        {
            "id": 61,
            "name": "Lightning (61)",
            "classname": "weapon_lightning",
            "uuid": 11951901569730081780,
            "mp": 1,
        },
        {
            "id": 62,
            "name": "Cells (62)",
            "classname": "item_cells",
            "uuid": 7679226119367256345,
            "mp": 1,
        },
        {
            "id": 63,
            "name": "Cells (63)",
            "classname": "item_cells",
            "uuid": 6611392486184746704,
            "mp": 1,
        },
        {
            "id": 64,
            "name": "Biosuit (64)",
            "classname": "item_artifact_envirosuit",
            "uuid": 11333960164569379711,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Invulnerability (65)",
            "classname": "item_artifact_invulnerability",
            "uuid": 9851516928174666902,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Large Medkit (66)",
            "classname": "item_health",
            "uuid": 13633269570846369827,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Large Medkit (67)",
            "classname": "item_health",
            "uuid": 10192191090186503236,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Large Medkit (68)",
            "classname": "item_health",
            "uuid": 8096682305804216143,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Secret (69)",
            "classname": "trigger_secret",
            "uuid": 12990311084282081336,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Spikes (70)",
            "classname": "item_spikes",
            "uuid": 15031650970405639277,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Large Medkit (71)",
            "classname": "item_health",
            "uuid": 12548359808716674137,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Large Medkit (72)",
            "classname": "item_health",
            "uuid": 12880004402423243584,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Large Medkit (73)",
            "classname": "item_health",
            "uuid": 7913373504000905749,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Large Medkit (74)",
            "classname": "item_health",
            "uuid": 12690135696663026437,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Rockets (75)",
            "classname": "item_rockets",
            "uuid": 8215709723826686261,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Shells (76)",
            "classname": "item_shells",
            "uuid": 13932087608506579039,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "All Kills (77)",
            "classname": "all_kills",
            "uuid": 10608560903356240015,
            "mp": 0,
        },
    ]

    events = ["Open Big Door", "Lower Water Barrier"]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Large Medkit (72)",
                "Nailgun (4)",
                "Large Medkit (71)",
                "Large Medkit (18)",
                "Spikes (19)",
                "Small Medkit (17)",
                "Shells (16)",
                "Green Armor (6)",
                "Large Medkit (1)",
                "Shells (31)",
                "Spikes (44)",
                "Spikes (45)",
            ],
        )
        self.restrict("Spikes (44)", r.can_door)
        self.restrict("Spikes (45)", r.can_door)

        dive_area = self.region(
            "Dive Area",
            [
                "Secret (59)",
                "Grenadelauncher (10)",
                "Red Armor (50)",
                "Large Medkit (48)",
                "Supernailgun (42)",
            ],
        )
        self.connect(ret, dive_area, r.can_dive)

        past_button_area = self.region(
            "Past Button",
            [
                "Yellow Armor (43)",
            ],
        )
        self.connect(ret, past_button_area, r.can_button & r.can_door)

        past_bridge_area = self.region(
            "Past Bridge",
            [
                "Shells (7)",
                "Spikes (55)",
                "Open Big Door",
                "Rockets (41)",
            ],
        )
        self.connect(
            ret,
            past_bridge_area,
            r.can_button
            | r.can_rj_hard
            | r.can_gj_extr
            | (r.bigjump & r.difficulty("medium")),
        )
        self.connect(past_button_area, past_bridge_area)
        # drop into water from above to grab
        self.restrict("Rockets (41)", r.can_dive | r.difficulty("hard"))
        self.restrict("Open Big Door", r.can_button)

        bridge_upper_area = self.region(
            "Bridge Upper",
            [
                "Large Medkit (25)",
                "Rockets (75)",
                "Large Medkit (26)",
                "Shells (76)",
                "Large Medkit (29)",
                "Large Medkit (30)",
                "Spikes (40)",
                "Rockets (12)",
                "Large Medkit (39)",
                "Exit",
                "All Kills (77)",
            ],
        )
        self.connect(past_bridge_area, bridge_upper_area, r.bigjump_hard)
        self.restrict("Exit", r.can_door)
        self.restrict("All Kills (77)", r.difficult_combat)

        shoot_secret_area = self.region(
            "Shoot Secret Area",
            [
                "Secret (53)",
                "Spikes (11)",
                "Megahealth (5)",
                "Lower Water Barrier",
            ],
        )
        self.connect(bridge_upper_area, shoot_secret_area, r.can_shootswitch & r.jump)
        self.restrict("Secret (53)", r.can_door)
        self.restrict("Lower Water Barrier", r.can_button)

        third_bridge_area = self.region(
            "Third Bridge",
            [
                "Shells (36)",
                "Large Medkit (37)",
                "Large Medkit (73)",
                "Large Medkit (74)",
                "Grenadelauncher (23)",
                "Gold Key (2)",
                "Rockets (24)",
                "Nailgun (8)",
                "Shells (3)",
            ],
        )
        # hop around the corner and rj/gj over the gap or take the top route
        self.connect(
            past_bridge_area, third_bridge_area, r.difficulty("hard") & r.bigjump
        )

        third_bridge_door_area = self.region(
            "Third Bridge Door",
            [
                "Secret (52)",
                "Rockets (22)",
                "Megahealth (21)",
                "Yellow Armor (58)",
            ],
        )
        self.connect(
            third_bridge_area, third_bridge_door_area, r.can_door & r.can_shootswitch
        )
        self.restrict("Yellow Armor (58)", r.can_dive)

        secret_exit_area = self.region(
            "Secret Exit Area",
            [
                "Cells (63)",
                "Quad Damage (60)",
                "Cells (62)",
                "Lightning (61)",
                "Secret Exit",
            ],
        )
        self.connect(
            third_bridge_door_area,
            secret_exit_area,
            r.can_dive & self.event("Lower Water Barrier"),
        )

        past_button_door_area = self.region(
            "Past Button Door",
            [
                "Large Medkit (38)",
                "Spikes (13)",
                "Large Medkit (14)",
                "Large Medkit (15)",
                "Secret (69)",
                "Rockets (49)",
                "Large Medkit (46)",
                "Large Medkit (47)",
            ],
        )
        # bigjump route from outside
        self.connect(
            past_bridge_area,
            past_button_door_area,
            self.event("Open Big Door") | r.bigjump_hard,
        )
        self.connect(
            past_button_door_area, dive_area, r.can_dive | r.difficulty("hard")
        )

        self.restrict("Large Medkit (46)", r.difficulty("hard") | r.can_dive)
        self.restrict("Large Medkit (47)", r.difficulty("hard") | r.can_dive)
        # obscure knowledge for gibbing with quad dmg
        self.restrict(
            "Rockets (49)",
            r.can_door
            & (
                r.rocketlauncher
                | r.grenadelauncher
                | (r.quad_dmg(1) & r.difficulty("hard"))
            ),
        )
        self.restrict(
            "Secret (69)",
            r.can_door
            & (
                r.rocketlauncher
                | r.grenadelauncher
                | (r.quad_dmg(1) & r.difficulty("hard"))
            ),
        )

        self.connect(past_button_door_area, third_bridge_area, r.can_button)

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Spikes (70)",
                "Supernailgun (56)",
                "Large Medkit (33)",
                "Large Medkit (34)",
                "Large Medkit (35)",
                "Small Medkit (28)",
                "Small Medkit (27)",
            ],
        )
        self.connect(past_button_door_area, past_gold_door_area, self.gold_key)
        self.connect(
            bridge_upper_area,
            past_gold_door_area,
            r.bigjump & r.difficulty("medium") | (r.can_rj_hard | r.can_gj_extr),
        )

        self.connect(past_gold_door_area, bridge_upper_area, r.can_button)

        outside_ledges_area = self.region(
            "Outside Ledges",
            [
                "Rocketlauncher (9)",
                "Rockets (32)",
                "Rockets (20)",
                "Quad Damage (57)",
                "Large Medkit (68)",
                "Large Medkit (67)",
                "Large Medkit (66)",
                "Invulnerability (65)",
                "Biosuit (64)",
            ],
        )
        self.connect(
            past_gold_door_area,
            outside_ledges_area,
            r.can_jump | (r.can_rj_hard | r.can_gj_extr),
        )
        self.connect(
            bridge_upper_area, outside_ledges_area, r.bigjump & r.difficulty("medium")
        )
        self.restrict("Invulnerability (65)", r.can_dive)
        self.restrict("Biosuit (64)", r.can_dive)
        self.connect(
            outside_ledges_area, third_bridge_door_area, r.can_door & r.can_dive
        )

        return ret
