from BaseClasses import Region

from ..base_classes import Q1Level


class e1m3(Q1Level):
    name = "The Necropolis"
    mapfile = "e1m3"
    keys = ["Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Gold Key (1)",
            "classname": "item_key2",
            "uuid": 12930271335624989367,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Nailgun (2)",
            "classname": "weapon_nailgun",
            "uuid": 9264857131555672768,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Shells (3)",
            "classname": "item_shells",
            "uuid": 9135340498813792736,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Large Medkit (4)",
            "classname": "item_health",
            "uuid": 6645099076516023605,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Small Medkit (5)",
            "classname": "item_health",
            "uuid": 10675299708596667321,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Supershotgun (6)",
            "classname": "weapon_supershotgun",
            "uuid": 1629300677443474330,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Shells (7)",
            "classname": "item_shells",
            "uuid": 2044910691487391730,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Rockets (8)",
            "classname": "item_rockets",
            "uuid": 10609356497556262056,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Spikes (9)",
            "classname": "item_spikes",
            "uuid": 15404218094835463131,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Green Armor (10)",
            "classname": "item_armor1",
            "uuid": 7882104199312491182,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Large Medkit (11)",
            "classname": "item_health",
            "uuid": 8157434336518118948,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Spikes (12)",
            "classname": "item_spikes",
            "uuid": 1056854318402209424,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Small Medkit (13)",
            "classname": "item_health",
            "uuid": 8801329385628763371,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Small Medkit (14)",
            "classname": "item_health",
            "uuid": 16314286719176428041,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Rockets (15)",
            "classname": "item_rockets",
            "uuid": 9513199306628012899,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Large Medkit (16)",
            "classname": "item_health",
            "uuid": 8268864178563874536,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Large Medkit (17)",
            "classname": "item_health",
            "uuid": 17541451259657697461,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Spikes (18)",
            "classname": "item_spikes",
            "uuid": 3749377310377727303,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Shells (19)",
            "classname": "item_shells",
            "uuid": 15451756339705155257,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Rockets (20)",
            "classname": "item_rockets",
            "uuid": 2426256269687771079,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Large Medkit (21)",
            "classname": "item_health",
            "uuid": 5804351137809961247,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Small Medkit (22)",
            "classname": "item_health",
            "uuid": 267715578511643491,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Small Medkit (23)",
            "classname": "item_health",
            "uuid": 1413486780523380903,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Shells (24)",
            "classname": "item_shells",
            "uuid": 3913053160331067129,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Spikes (25)",
            "classname": "item_spikes",
            "uuid": 15257942494637540929,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Spikes (26)",
            "classname": "item_spikes",
            "uuid": 8360006573007748305,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Shells (27)",
            "classname": "item_shells",
            "uuid": 12506211072889875125,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Spikes (28)",
            "classname": "item_spikes",
            "uuid": 9499277493765629376,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Small Medkit (29)",
            "classname": "item_health",
            "uuid": 15476746052424092857,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Small Medkit (30)",
            "classname": "item_health",
            "uuid": 5242624954668411450,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Large Medkit (31)",
            "classname": "item_health",
            "uuid": 2228946973423712136,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Rockets (32)",
            "classname": "item_rockets",
            "uuid": 9079242641426968131,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Shells (33)",
            "classname": "item_shells",
            "uuid": 8654330156537091502,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Shells (34)",
            "classname": "item_shells",
            "uuid": 11790187323859260218,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Spikes (35)",
            "classname": "item_spikes",
            "uuid": 2391786287798148121,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Rockets (36)",
            "classname": "item_rockets",
            "uuid": 15495261332039765513,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Small Medkit (37)",
            "classname": "item_health",
            "uuid": 4983651078264009515,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Large Medkit (38)",
            "classname": "item_health",
            "uuid": 9803955424435660597,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Small Medkit (39)",
            "classname": "item_health",
            "uuid": 8863537527991134345,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Shells (40)",
            "classname": "item_shells",
            "uuid": 10551599814320797689,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Large Medkit (41)",
            "classname": "item_health",
            "uuid": 8037754636777968867,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Large Medkit (42)",
            "classname": "item_health",
            "uuid": 13668466668431942130,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Large Medkit (43)",
            "classname": "item_health",
            "uuid": 11830861069293540576,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 7748504386390108018,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Large Medkit (45)",
            "classname": "item_health",
            "uuid": 6804494881005439699,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Small Medkit (46)",
            "classname": "item_health",
            "uuid": 566788278553082254,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Small Medkit (47)",
            "classname": "item_health",
            "uuid": 9588475826597844604,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Shells (48)",
            "classname": "item_shells",
            "uuid": 9349705014252174262,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Secret (49)",
            "classname": "trigger_secret",
            "uuid": 15662667066766969726,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Rockets (50)",
            "classname": "item_rockets",
            "uuid": 5755285926499141820,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Yellow Armor (51)",
            "classname": "item_armor2",
            "uuid": 6446509405129875318,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Grenadelauncher (52)",
            "classname": "weapon_grenadelauncher",
            "uuid": 10308088106520838254,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Large Medkit (53)",
            "classname": "item_health",
            "uuid": 17627096016485371387,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Rockets (54)",
            "classname": "item_rockets",
            "uuid": 10256289761323676107,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Shells (55)",
            "classname": "item_shells",
            "uuid": 4710663586972208177,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Rockets (56)",
            "classname": "item_rockets",
            "uuid": 262731718958016173,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Shells (57)",
            "classname": "item_shells",
            "uuid": 7306318009253324852,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Shells (58)",
            "classname": "item_shells",
            "uuid": 7653490255635721889,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Rocketlauncher (59)",
            "classname": "weapon_rocketlauncher",
            "uuid": 18175734207110344966,
            "mp": 1,
        },
        {
            "id": 60,
            "name": "Supershotgun (60)",
            "classname": "weapon_supershotgun",
            "uuid": 1520905559609442286,
            "mp": 1,
        },
        {
            "id": 61,
            "name": "Megahealth (61)",
            "classname": "item_health",
            "uuid": 16521961138828443987,
            "mp": 1,
        },
        {
            "id": 62,
            "name": "Supernailgun (62)",
            "classname": "weapon_supernailgun",
            "uuid": 13130568620334392320,
            "mp": 1,
        },
        {
            "id": 63,
            "name": "Spikes (63)",
            "classname": "item_spikes",
            "uuid": 15040333204306964561,
            "mp": 1,
        },
        {
            "id": 64,
            "name": "Nailgun (64)",
            "classname": "weapon_nailgun",
            "uuid": 1398733667266241030,
            "mp": 1,
        },
        {
            "id": 65,
            "name": "Large Medkit (65)",
            "classname": "item_health",
            "uuid": 2740147343901906468,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Large Medkit (66)",
            "classname": "item_health",
            "uuid": 7821967114196873124,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Secret (67)",
            "classname": "trigger_secret",
            "uuid": 4407196132091057580,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Invisibility (68)",
            "classname": "item_artifact_invisibility",
            "uuid": 17332820587296116818,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Secret (69)",
            "classname": "trigger_secret",
            "uuid": 5461083817208659763,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Large Medkit (70)",
            "classname": "item_health",
            "uuid": 8259574908066731652,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Rockets (71)",
            "classname": "item_rockets",
            "uuid": 6684468117204543605,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Shells (72)",
            "classname": "item_shells",
            "uuid": 88767713609709921,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Shells (73)",
            "classname": "item_shells",
            "uuid": 9918791888931872917,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Large Medkit (74)",
            "classname": "item_health",
            "uuid": 15277506365520976249,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "All Kills (75)",
            "classname": "all_kills",
            "uuid": 6006854588914090942,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Shells (7)",
                "Shells (58)",
                "Small Medkit (5)",
                "Large Medkit (4)",
                "Grenadelauncher (52)",
                "Large Medkit (11)",
                "Supershotgun (6)",
                "Shells (24)",
                "Shells (55)",
                "Spikes (12)",
                "Small Medkit (37)",
                "Rockets (8)",
                "Small Medkit (13)",
                "Small Medkit (14)",
                "Shells (27)",
                "Rockets (56)",
                "Rockets (15)",
                "Large Medkit (16)",
                "Large Medkit (17)",
                "Rocketlauncher (59)",
                "Green Armor (10)",
                "Secret (69)",
                "Large Medkit (70)",
                "Rockets (71)",
                "Large Medkit (74)",
                "Gold Key (1)",
            ],
        )
        self.restrict("Secret (69)", r.can_shootswitch)
        self.restrict("Large Medkit (70)", r.can_shootswitch)
        self.restrict("Rockets (71)", r.can_shootswitch)
        self.restrict("Large Medkit (74)", r.can_door)

        underwater_secret = self.region(
            "Underwater Secret",
            [
                "Secret (67)",
                "Invisibility (68)",
            ],
        )
        self.connect(ret, underwater_secret, r.can_dive)

        dd_area = self.region(
            "Past Double Door",
            [
                "Spikes (9)",
                "Spikes (35)",
                "Rockets (54)",
                "Large Medkit (42)",
                "Small Medkit (46)",
                "Large Medkit (41)",
                "Small Medkit (47)",
                "Rockets (36)",
                "Shells (57)",
                "Spikes (26)",
                "Spikes (25)",
                "Large Medkit (43)",
                "Shells (33)",
            ],
        )

        self.restrict("Rockets (54)", r.can_door)

        dd_ele_area = self.region(
            "Double Door Elevator",
            # This one always requires access through the double door from the top
            [
                "Nailgun (2)",
            ],
        )
        self.connect(ret, dd_ele_area, r.can_door)

        # rj/gj upwards from the golden key "island"
        self.connect(
            ret,
            dd_area,
            (r.can_door & r.can_shootswitch)
            | (r.can_rj_hard & r.can_jump)
            | (r.can_gj_extr & r.can_jump),
        )

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Large Medkit (45)",
                "Large Medkit (53)",
                "Spikes (28)",
                "Shells (48)",
                "Nailgun (64)",
                "Small Medkit (30)",
                "Small Medkit (29)",
                "Shells (34)",
                "Large Medkit (31)",
                "Rockets (32)",
                "Small Medkit (23)",
                "Small Medkit (22)",
                "Rockets (20)",
                "Supershotgun (60)",
                "Large Medkit (38)",
                "Small Medkit (39)",
                "Shells (3)",
                "Yellow Armor (51)",
                "Secret (49)",
                "Rockets (50)",
                "Supernailgun (62)",
                "Spikes (63)",
            ],
        )
        self.connect(dd_area, past_gold_door_area, self.gold_key)
        # very difficult in-place grenade jumps to get on top
        self.restrict("Rockets (20)", r.can_jump | r.can_rj_hard | r.can_gj_extr)

        # TODO: Maybe can jump out of water with just dive?
        self.restrict("Supershotgun (60)", r.can_jump | r.can_rj_hard | r.can_gj_extr)

        self.restrict(
            "Secret (49)",
            (r.can_shootswitch & r.jump)
            | (r.can_jump & (r.can_rj_hard | r.can_gj_extr)),
        )
        self.restrict(
            "Rockets (50)",
            (r.can_shootswitch & r.jump)
            | (r.can_jump & (r.can_rj_hard | r.can_gj_extr)),
        )

        past_sewer_button_area = self.region(
            "Past Sewer Button",
            [
                "Spikes (18)",
                "Shells (19)",
                "Large Medkit (21)",
            ],
        )
        self.connect(
            past_gold_door_area,
            past_sewer_button_area,
            # very difficult in-place grenade jumps to get on top
            r.can_button & (r.can_jump | r.can_rj_hard | r.can_gj_extr),
        )

        past_elevator_area = self.region(
            "Past Elevator",
            [
                "Large Medkit (66)",
                "Large Medkit (65)",
                "Shells (72)",
                "Shells (73)",
                "Megahealth (61)",
                "Shells (40)",
                "Exit",
                "All Kills (75)",
            ],
        )

        self.connect(
            past_gold_door_area,
            past_elevator_area,
            r.can_button,
        )
        self.restrict("All Kills (75)", r.can_gib & r.backpack(5))

        return ret
