from enum import Enum
from typing import Dict, Tuple
from BaseClasses import Item, ItemClassification

class AgainstTheStormItem(Item):
    game: str = "Against the Storm"

class ATSItemClassification(Enum):
    good = 1
    blueprint = 2
    filler = 3
    guardian_part = 4
    dlc_blueprint = 5

item_dict: Dict[str, Tuple[ItemClassification, ATSItemClassification]] = {
    "Guardian Heart": (ItemClassification.progression, ATSItemClassification.guardian_part),
    "Guardian Blood": (ItemClassification.progression, ATSItemClassification.guardian_part),
    "Guardian Feathers": (ItemClassification.progression, ATSItemClassification.guardian_part),
    "Guardian Essence": (ItemClassification.progression, ATSItemClassification.guardian_part),

    "Berries": (ItemClassification.progression, ATSItemClassification.good),
    "Eggs": (ItemClassification.progression, ATSItemClassification.good),
    "Insects": (ItemClassification.progression, ATSItemClassification.good),
    "Meat": (ItemClassification.progression, ATSItemClassification.good),
    "Mushrooms": (ItemClassification.progression, ATSItemClassification.good),
    "Roots": (ItemClassification.progression, ATSItemClassification.good),
    "Vegetables": (ItemClassification.progression, ATSItemClassification.good),
    "Fish": (ItemClassification.progression, ATSItemClassification.good),
    "Biscuits": (ItemClassification.progression, ATSItemClassification.good),
    "Jerky": (ItemClassification.progression, ATSItemClassification.good),
    "Pickled Goods": (ItemClassification.progression, ATSItemClassification.good),
    "Pie": (ItemClassification.progression, ATSItemClassification.good),
    "Porridge": (ItemClassification.progression, ATSItemClassification.good),
    "Skewers": (ItemClassification.progression, ATSItemClassification.good),
    "Paste": (ItemClassification.progression, ATSItemClassification.good),
    "Coats": (ItemClassification.progression, ATSItemClassification.good),
    "Boots": (ItemClassification.progression, ATSItemClassification.good),
    "Bricks": (ItemClassification.progression, ATSItemClassification.good),
    "Fabric": (ItemClassification.progression, ATSItemClassification.good),
    "Planks": (ItemClassification.progression, ATSItemClassification.good),
    "Pipes": (ItemClassification.progression, ATSItemClassification.good),
    "Parts": (ItemClassification.progression, ATSItemClassification.good),
    "Wildfire Essence": (ItemClassification.useful, ATSItemClassification.good),
    "Ale": (ItemClassification.progression, ATSItemClassification.good),
    "Incense": (ItemClassification.progression, ATSItemClassification.good),
    "Scrolls": (ItemClassification.progression, ATSItemClassification.good),
    "Tea": (ItemClassification.progression, ATSItemClassification.good),
    "Training Gear": (ItemClassification.progression, ATSItemClassification.good),
    "Wine": (ItemClassification.progression, ATSItemClassification.good),
    "Clay": (ItemClassification.progression, ATSItemClassification.good),
    "Copper Ore": (ItemClassification.progression, ATSItemClassification.good),
    "Scales": (ItemClassification.progression, ATSItemClassification.good),
    "Crystallized Dew": (ItemClassification.progression, ATSItemClassification.good),
    "Grain": (ItemClassification.progression, ATSItemClassification.good),
    "Herbs": (ItemClassification.progression, ATSItemClassification.good),
    "Leather": (ItemClassification.progression, ATSItemClassification.good),
    "Plant Fiber": (ItemClassification.progression, ATSItemClassification.good),
    "Algae": (ItemClassification.progression, ATSItemClassification.good),
    "Reeds": (ItemClassification.progression, ATSItemClassification.good),
    "Resin": (ItemClassification.progression, ATSItemClassification.good),
    "Stone": (ItemClassification.progression, ATSItemClassification.good),
    "Salt": (ItemClassification.progression, ATSItemClassification.good),
    "Barrels": (ItemClassification.progression, ATSItemClassification.good),
    "Copper Bars": (ItemClassification.progression, ATSItemClassification.good),
    "Flour": (ItemClassification.progression, ATSItemClassification.good),
    "Dye": (ItemClassification.progression, ATSItemClassification.good),
    "Pottery": (ItemClassification.progression, ATSItemClassification.good),
    "Waterskins": (ItemClassification.progression, ATSItemClassification.good),
    "Amber": (ItemClassification.progression, ATSItemClassification.good),
    "Pack of Building Materials": (ItemClassification.progression, ATSItemClassification.good),
    "Pack of Crops": (ItemClassification.progression, ATSItemClassification.good),
    "Pack of Luxury Goods": (ItemClassification.progression, ATSItemClassification.good),
    "Pack of Provisions": (ItemClassification.progression, ATSItemClassification.good),
    "Pack of Trade Goods": (ItemClassification.progression, ATSItemClassification.good),
    "Ancient Tablet": (ItemClassification.progression, ATSItemClassification.good),
    "Coal": (ItemClassification.progression, ATSItemClassification.good),
    "Oil": (ItemClassification.progression, ATSItemClassification.good),
    "Purging Fire": (ItemClassification.progression, ATSItemClassification.good),
    "Sea Marrow": (ItemClassification.progression, ATSItemClassification.good),
    "Tools": (ItemClassification.progression, ATSItemClassification.good),

    "2 Starting Villagers": (ItemClassification.filler, ATSItemClassification.filler),
    "15 Starting Crystallized Dew": (ItemClassification.filler, ATSItemClassification.filler),
    "20 Starting Amber": (ItemClassification.filler, ATSItemClassification.filler),
    "6 Starting Parts": (ItemClassification.filler, ATSItemClassification.filler),
    "3 Starting Wildfire Essence": (ItemClassification.filler, ATSItemClassification.filler),
    "20 Starting Pipes": (ItemClassification.filler, ATSItemClassification.filler),
    "30 Starting Sea Marrow": (ItemClassification.filler, ATSItemClassification.filler),
    "30 Starting Oil": (ItemClassification.filler, ATSItemClassification.filler),
    "30 Starting Grain": (ItemClassification.filler, ATSItemClassification.filler),
    "15 Starting Pack of Provisions": (ItemClassification.filler, ATSItemClassification.filler),
    "25 Starting Mushrooms": (ItemClassification.filler, ATSItemClassification.filler),
    "40 Starting Insects": (ItemClassification.filler, ATSItemClassification.filler),
    "20 Starting Vegetables": (ItemClassification.filler, ATSItemClassification.filler),
    "20 Starting Stone": (ItemClassification.filler, ATSItemClassification.filler),
    "25 Starting Clay": (ItemClassification.filler, ATSItemClassification.filler),
    "30 Starting Salt": (ItemClassification.filler, ATSItemClassification.filler),
    "10 Starting Planks": (ItemClassification.filler, ATSItemClassification.filler),
    "10 Starting Tools": (ItemClassification.filler, ATSItemClassification.filler),
    "Survivor Bonding": (ItemClassification.filler, ATSItemClassification.filler),
 
    "Forager's Camp": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Herbalist's Camp": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Trapper's Camp": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Fishing Hut": (ItemClassification.useful, ATSItemClassification.blueprint),
    "Clay Pit": (ItemClassification.useful, ATSItemClassification.blueprint),
    "Forester's Hut": (ItemClassification.useful, ATSItemClassification.blueprint),
    "Greenhouse": (ItemClassification.useful, ATSItemClassification.blueprint),
    "Herb Garden": (ItemClassification.useful, ATSItemClassification.blueprint),
    "Plantation": (ItemClassification.useful, ATSItemClassification.blueprint),
    "Small Farm": (ItemClassification.useful, ATSItemClassification.blueprint),
    "Advanced Rain Collector": (ItemClassification.useful, ATSItemClassification.blueprint),
    "Bakery": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Beanery": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Brick Oven": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Butcher": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Cellar": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Cookhouse": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Granary": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Grill": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Ranch": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Smokehouse": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Alchemist's Hut": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Apothecary": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Artisan": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Brewery": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Brickyard": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Carpenter": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Clothier": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Cooperage": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Distillery": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Druid's Hut": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Furnace": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Kiln": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Leatherworker": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Lumber Mill": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Manufactory": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Press": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Provisioner": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Rain Mill": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Scribe": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Smelter": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Smithy": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Stamping Mill": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Supplier": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Teahouse": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Tinctury": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Tinkerer": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Toolshop": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Weaver": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Workshop": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Cobbler": (ItemClassification.progression, ATSItemClassification.blueprint),
    
    "Pantry": (ItemClassification.progression, ATSItemClassification.dlc_blueprint),
    "Cannery": (ItemClassification.progression, ATSItemClassification.dlc_blueprint),
    
    "Bath House": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Clan Hall": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Explorers Lodge": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Guild House": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Market": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Monastery": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Tavern": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Tea Doctor": (ItemClassification.progression, ATSItemClassification.blueprint),
    "Temple": (ItemClassification.progression, ATSItemClassification.blueprint),
    
    "Forum": (ItemClassification.progression, ATSItemClassification.dlc_blueprint),
}
