
from BaseClasses import Location
from .rom_addresses import rom_addresses
from . import poke_data
loc_id_start = 172000000


def trainersanity(world, player):
    include = world.trainersanity_table.pop(0)
    world.trainersanity_table.append(include)
    return include


def dexsanity(world, player):
    include = world.dexsanity_table.pop(0)
    world.dexsanity_table.append(include)
    return include


def hidden_items(world, player):
    return world.options.randomize_hidden_items


def hidden_moon_stones(world, player):
    return world.options.randomize_hidden_items or world.options.stonesanity


def tea(world, player):
    return world.options.tea


def extra_key_items(world, player):
    return world.options.extra_key_items


def always_on(world, player):
    return True


def prizesanity(world, player):
    return world.options.prizesanity


def split_card_key(world, player):
    return world.options.split_card_key.value > 0


def not_stonesanity(world, player):
    return not world.options.stonesanity


class LocationData:
    def __init__(self, region, name, original_item, rom_address=None, ram_address=None, event=False, type="Item",
                 inclusion=always_on, level=None, level_address=None):
        self.region = region
        self.name = region if name == "" else region.split("-")[0] + " - " + name if name != "Trainer Parties" else region + " - Trainer Parties"
        self.original_item = original_item
        self.rom_address = rom_address
        self.ram_address = ram_address
        self.event = event
        self.type = type
        self.inclusion = inclusion
        self.level = level
        self.address = None
        if level_address:
            self.level_address = level_address
        elif level:
            self.level_address = rom_address - 1
        else:
            self.level_address = None


class EventFlag:
    def __init__(self, flag):
        self.byte = int(flag / 8)
        self.bit = flag % 8
        self.flag = flag


class Missable:
    def __init__(self, flag):
        self.byte = int(flag / 8)
        self.bit = flag % 8
        self.flag = flag


class Hidden:
    def __init__(self, flag):
        self.byte = int(flag / 8)
        self.bit = flag % 8
        self.flag = flag


class Rod:
    def __init__(self, flag):
        self.byte = 0
        self.bit = flag
        self.flag = flag


class DexSanityFlag:
    def __init__(self, flag):
        self.byte = int(flag / 8)
        self.bit = flag % 8
        self.flag = flag


location_data = [

    LocationData("Vermilion Old Rod House", "Fishing Guru", "Old Rod", rom_addresses["Rod_Vermilion_City_Fishing_Guru"], Rod(3)),
    LocationData("Fuchsia Good Rod House", "Fishing Guru's Brother", "Good Rod", rom_addresses["Rod_Fuchsia_City_Fishing_Brother"], Rod(4)),
    LocationData("Route 12 Super Rod House", "Fishing Guru's Brother", "Super Rod", rom_addresses["Rod_Route12_Fishing_Brother"], Rod(5)),

    LocationData("Player's House 2F", "Player's PC", "Potion", rom_addresses['PC_Item'], EventFlag(1),),
    LocationData("Celadon Mansion 1F", "Mansion Lady", "Tea", rom_addresses["Event_Mansion_Lady"], EventFlag(2), inclusion=tea),
    LocationData("Rival's House", "Rival's Sister", "Town Map", rom_addresses["Event_Rivals_Sister"], EventFlag(24)),
    LocationData("Oak's Lab", "Oak's Post-Route-22-Rival Gift", "Poke Ball", rom_addresses["Event_Oaks_Gift"], EventFlag(36)),
    LocationData("Route 1", "Free Sample Man", "Potion", rom_addresses["Event_Free_Sample"], EventFlag(960)),
    LocationData("Viridian City", "Sleepy Guy", "TM42 Dream Eater", rom_addresses["Event_Sleepy_Guy"],
                 EventFlag(41)),
    LocationData("Viridian Pokemart", "Item for Oak", "Oak's Parcel", rom_addresses["Event_Pokemart_Quest"],
                 EventFlag(57)),
    LocationData("Viridian Gym", "Giovanni TM", "TM27 Fissure", rom_addresses["Event_Viridian_Gym"], EventFlag(80)),
    LocationData("Route 2 Gate", "Oak's Aide", "HM05 Flash", rom_addresses["Event_Route_2_Oaks_Aide"],
                 EventFlag(984)),
    LocationData("Pewter Museum 1F-E", "Scientist", "Old Amber", rom_addresses["Event_Museum"], EventFlag(105)),
    LocationData("Pewter Gym", "Brock TM", "TM34 Bide", rom_addresses["Event_Pewter_Gym"], EventFlag(118)),
    LocationData("Cerulean Bicycle Shop", "", "Bicycle", [rom_addresses["Event_Bicycle_Shop"], rom_addresses["Bike_Shop_Item_Display"]], EventFlag(192)),
    LocationData("Cerulean Gym", "Misty TM", "TM11 Bubble Beam", rom_addresses["Event_Cerulean_Gym"],
                 EventFlag(190)),
    LocationData("Route 24", "Nugget Bridge", "Nugget", rom_addresses["Event_Nugget_Bridge"], EventFlag(1344)),
    LocationData("Bill's House", "Bill", "S.S. Ticket", rom_addresses["Event_Bill"], EventFlag(1372)),
    LocationData("Lavender Mr. Fuji's House", "Mr. Fuji", "Poke Flute", rom_addresses["Event_Fuji"], EventFlag(296)),
    LocationData("Route 12 Gate 2F", "Mourning Girl", "TM39 Swift", rom_addresses["Event_Mourning_Girl"],
                 EventFlag(1152)),
    LocationData("Vermilion Pokemon Fan Club", "Fan Club President", "Bike Voucher", rom_addresses["Event_Pokemon_Fan_Club"],
                 EventFlag(337)),
    LocationData("Vermilion Gym", "Lt. Surge TM", "TM24 Thunderbolt", rom_addresses["Event_Vermillion_Gym"],
                 EventFlag(358)),
    LocationData("S.S. Anne Captain's Room", "Captain", "HM01 Cut", rom_addresses["Event_SS_Anne_Captain"], EventFlag(1504)),
    LocationData("Route 11 Gate 2F", "Oak's Aide", "Item Finder", rom_addresses["Event_Rt11_Oaks_Aide"],
                 EventFlag(1151)),
    LocationData("Celadon City", "Stranded Man", "TM41 Soft-Boiled", rom_addresses["Event_Stranded_Man"],
                 EventFlag(384)),
    LocationData("Celadon Department Store Roof", "Thirsty Girl Gets Water", "TM13 Ice Beam",
                 rom_addresses["Event_Thirsty_Girl_Water"], EventFlag(396)),
    LocationData("Celadon Department Store Roof", "Thirsty Girl Gets Soda Pop", "TM48 Rock Slide",
                 rom_addresses["Event_Thirsty_Girl_Soda"], EventFlag(397)),
    LocationData("Celadon Department Store Roof", "Thirsty Girl Gets Lemonade", "TM49 Tri Attack",
                 rom_addresses["Event_Thirsty_Girl_Lemonade"], EventFlag(398)),
    LocationData("Celadon Department Store 3F", "Counter Man", "TM18 Counter", rom_addresses["Event_Counter"], EventFlag(399)),
    LocationData("Celadon Diner", "Gambling Addict", "Coin Case", rom_addresses["Event_Gambling_Addict"],
                 EventFlag(480)),
    LocationData("Celadon Gym-C", "Erika TM", "TM21 Mega Drain", rom_addresses["Event_Celadon_Gym"], EventFlag(424)),
    LocationData("Silph Co 11F-C", "Silph Co President", "Master Ball", rom_addresses["Event_Silph_Co_President"],
                 EventFlag(1933)),
    LocationData("Silph Co 2F-NW", "Woman", "TM36 Self-Destruct", rom_addresses["Event_Scared_Woman"],
                 EventFlag(1791)),
    LocationData("Route 16 Fly House", "Woman", "HM02 Fly", rom_addresses["Event_Rt16_House_Woman"], EventFlag(1230)),
    LocationData("Route 15 Gate 2F", "Oak's Aide", "Exp. All", rom_addresses["Event_Rt_15_Oaks_Aide"], EventFlag(1200)),
    LocationData("Fuchsia Warden's House", "Safari Zone Warden", "HM04 Strength", rom_addresses["Event_Warden"], EventFlag(568)),
    LocationData("Fuchsia Gym", "Koga TM", "TM06 Toxic", rom_addresses["Event_Fuschia_Gym"], EventFlag(600)),
    LocationData("Safari Zone Secret House", "", "HM03 Surf", rom_addresses["Event_Safari_Zone_Secret_House"], EventFlag(2176)),
    LocationData("Cinnabar Lab R&D Room", "Lab Scientist", "TM35 Metronome", rom_addresses["Event_Lab_Scientist"], EventFlag(727)),
    LocationData("Cinnabar Gym", "Blaine TM", "TM38 Fire Blast", rom_addresses["Event_Cinnabar_Gym"],
                 EventFlag(664)),
    LocationData("Saffron Copycat's House 2F", "Copycat", "TM31 Mimic", rom_addresses["Event_Copycat"], EventFlag(832)),
    LocationData("Saffron Mr. Psychic's House", "Mr. Psychic", "TM29 Psychic", rom_addresses["Event_Mr_Psychic"], EventFlag(944)),
    LocationData("Saffron Gym-C", "Sabrina TM", "TM46 Psywave", rom_addresses["Event_Saffron_Gym"], EventFlag(864)),
    LocationData("Fossil", "Choice A", "Dome Fossil", [rom_addresses["Event_Dome_Fossil"], rom_addresses["Event_Dome_Fossil_B"],
                  rom_addresses["Dome_Fossil_Text"]], EventFlag(0x57E)),
    LocationData("Fossil", "Choice B", "Helix Fossil", [rom_addresses["Event_Helix_Fossil"], rom_addresses["Event_Helix_Fossil_B"],
                  rom_addresses["Helix_Fossil_Text"]], EventFlag(0x57F)),

    LocationData("Cerulean City-Outskirts", "Rocket Thief", "TM28 Dig", rom_addresses["Event_Rocket_Thief"],
                 Missable(6)),
    LocationData("Route 2-SE", "South Item", "Moon Stone", rom_addresses["Missable_Route_2_Item_1"],
                 Missable(25)),
    LocationData("Route 2-SE", "North Item", "HP Up", rom_addresses["Missable_Route_2_Item_2"], Missable(26)),
    LocationData("Route 4-C", "Item", "TM04 Whirlwind", rom_addresses["Missable_Route_4_Item"], Missable(27)),
    LocationData("Route 9", "Item", "TM30 Teleport", rom_addresses["Missable_Route_9_Item"], Missable(28)),
    LocationData("Route 12-N", "Island Item", "TM16 Pay Day", rom_addresses["Missable_Route_12_Item_1"], Missable(30)),
    LocationData("Route 12-Grass", "Item Behind Cuttable Tree", "Iron", rom_addresses["Missable_Route_12_Item_2"], Missable(31)),
    LocationData("Route 15-N", "Item", "TM20 Rage", rom_addresses["Missable_Route_15_Item"], Missable(32)),
    LocationData("Route 24", "Item", "TM45 Thunder Wave", rom_addresses["Missable_Route_24_Item"], Missable(37)),
    LocationData("Route 25", "Item", "TM19 Seismic Toss", rom_addresses["Missable_Route_25_Item"], Missable(38)),
    LocationData("Viridian Gym", "Item", "Revive", rom_addresses["Missable_Viridian_Gym_Item"], Missable(51)),
    LocationData("Cerulean Cave 1F-Water", "Southwest Item", "Full Restore", rom_addresses["Missable_Cerulean_Cave_1F_Item_1"],
                 Missable(53)),
    LocationData("Cerulean Cave 1F-Water", "Northeast Item", "Max Elixir", rom_addresses["Missable_Cerulean_Cave_1F_Item_2"],
                 Missable(54)),
    LocationData("Cerulean Cave 1F-N", "Northwest Item", "Nugget", rom_addresses["Missable_Cerulean_Cave_1F_Item_3"],
                 Missable(55)),
    LocationData("Pokemon Tower 3F", "North Item", "Escape Rope", rom_addresses["Missable_Pokemon_Tower_3F_Item"],
                 Missable(57)),
    LocationData("Pokemon Tower 4F", "East Item", "Elixir", rom_addresses["Missable_Pokemon_Tower_4F_Item_1"],
                 Missable(58)),
    LocationData("Pokemon Tower 4F", "West Item", "Awakening", rom_addresses["Missable_Pokemon_Tower_4F_Item_2"],
                 Missable(59)),
    LocationData("Pokemon Tower 4F", "South Item", "HP Up", rom_addresses["Missable_Pokemon_Tower_4F_Item_3"],
                 Missable(60)),
    LocationData("Pokemon Tower 5F", "Southwest Item", "Nugget", rom_addresses["Missable_Pokemon_Tower_5F_Item"],
                 Missable(61)),
    LocationData("Pokemon Tower 6F", "West Item", "Rare Candy", rom_addresses["Missable_Pokemon_Tower_6F_Item_1"],
                 Missable(62)),
    LocationData("Pokemon Tower 6F", "Southeast Item", "X Accuracy", rom_addresses["Missable_Pokemon_Tower_6F_Item_2"],
                 Missable(63)),
    LocationData("Fuchsia Warden's House", "Behind Boulder Item", "Rare Candy", rom_addresses["Missable_Wardens_House_Item"],
                 Missable(71)),
    LocationData("Pokemon Mansion 1F", "North Item", "Escape Rope",
                 rom_addresses["Missable_Pokemon_Mansion_1F_Item_1"], Missable(72)),
    LocationData("Pokemon Mansion 1F-SE", "South Item", "Carbos", rom_addresses["Missable_Pokemon_Mansion_1F_Item_2"],
                 Missable(73)),
    LocationData("Power Plant", "Southwest Item", "Carbos", rom_addresses["Missable_Power_Plant_Item_1"], Missable(86)),
    LocationData("Power Plant", "North Item", "HP Up", rom_addresses["Missable_Power_Plant_Item_2"], Missable(87)),
    LocationData("Power Plant", "Northeast Item", "Rare Candy", rom_addresses["Missable_Power_Plant_Item_3"],
                 Missable(88)),
    LocationData("Power Plant", "Southeast Item", "TM25 Thunder", rom_addresses["Missable_Power_Plant_Item_4"],
                 Missable(89)),
    LocationData("Power Plant", "South Item", "TM33 Reflect", rom_addresses["Missable_Power_Plant_Item_5"],
                 Missable(90)),
    LocationData("Victory Road 2F-C", "Northeast Item", "TM17 Submission", rom_addresses["Missable_Victory_Road_2F_Item_1"],
                 Missable(92)),
    LocationData("Victory Road 2F-C", "East Item", "Full Heal", rom_addresses["Missable_Victory_Road_2F_Item_2"],
                 Missable(93)),
    LocationData("Victory Road 2F-C", "West Item", "TM05 Mega Kick", rom_addresses["Missable_Victory_Road_2F_Item_3"],
                 Missable(94)),
    LocationData("Victory Road 2F-NW", "North Item Near Moltres", "Guard Spec", rom_addresses["Missable_Victory_Road_2F_Item_4"],
                 Missable(95)),
    LocationData("Viridian Forest", "East Item", "Antidote", rom_addresses["Missable_Viridian_Forest_Item_1"],
                 Missable(100)),
    LocationData("Viridian Forest", "Northwest Item", "Potion", rom_addresses["Missable_Viridian_Forest_Item_2"],
                 Missable(101)),
    LocationData("Viridian Forest", "Southwest Item", "Poke Ball",
                 rom_addresses["Missable_Viridian_Forest_Item_3"], Missable(102)),
    LocationData("Mt Moon 1F", "West Item", "Potion", rom_addresses["Missable_Mt_Moon_1F_Item_1"], Missable(103)),
    LocationData("Mt Moon 1F", "Northwest Item", "Moon Stone", rom_addresses["Missable_Mt_Moon_1F_Item_2"], Missable(104)),
    LocationData("Mt Moon 1F", "Southeast Item", "Rare Candy", rom_addresses["Missable_Mt_Moon_1F_Item_3"], Missable(105)),
    LocationData("Mt Moon 1F", "East Item", "Escape Rope", rom_addresses["Missable_Mt_Moon_1F_Item_4"],
                 Missable(106)),
    LocationData("Mt Moon 1F", "South Item", "Potion", rom_addresses["Missable_Mt_Moon_1F_Item_5"], Missable(107)),
    LocationData("Mt Moon 1F", "Southwest Item", "TM12 Water Gun", rom_addresses["Missable_Mt_Moon_1F_Item_6"],
                 Missable(108)),
    LocationData("Mt Moon B2F-C", "South Item", "HP Up", rom_addresses["Missable_Mt_Moon_B2F_Item_1"], Missable(111)),
    LocationData("Mt Moon B2F-NE", "North Item", "TM01 Mega Punch", rom_addresses["Missable_Mt_Moon_B2F_Item_2"],
                 Missable(112)),
    LocationData("S.S. Anne 1F Rooms-Youngster and Lass Room", "Item", "TM08 Body Slam", rom_addresses["Missable_SS_Anne_1F_Item"],
                 Missable(114)),
    LocationData("S.S. Anne 2F Rooms-Fisherman and Gentleman Room", "Fisherman and Gentleman Room Item", "Max Ether", rom_addresses["Missable_SS_Anne_2F_Item_1"],
                 Missable(115)),
    LocationData("S.S. Anne 2F Rooms-Gentleman and Lass Room", "Gentleman and Lass Room Item", "Rare Candy", rom_addresses["Missable_SS_Anne_2F_Item_2"],
                 Missable(116)),
    LocationData("S.S. Anne B1F Rooms-East Single Sailor Room", "East Single Sailor Room Item", "Ether", rom_addresses["Missable_SS_Anne_B1F_Item_1"], Missable(117)),
    LocationData("S.S. Anne B1F Rooms-West Single Sailor Room", "West Single Sailor Room Item", "TM44 Rest", rom_addresses["Missable_SS_Anne_B1F_Item_2"],
                 Missable(118)),
    LocationData("S.S. Anne B1F Rooms-Machoke Room", "Machoke Room Item", "Max Potion", rom_addresses["Missable_SS_Anne_B1F_Item_3"],
                 Missable(119)),
    LocationData("Victory Road 3F", "Northeast Item", "Max Revive", rom_addresses["Missable_Victory_Road_3F_Item_1"],
                 Missable(120)),
    LocationData("Victory Road 3F", "Northwest Item", "TM47 Explosion", rom_addresses["Missable_Victory_Road_3F_Item_2"],
                 Missable(121)),
    LocationData("Rocket Hideout B1F", "West Item", "Escape Rope",
                 rom_addresses["Missable_Rocket_Hideout_B1F_Item_1"], Missable(123)),
    LocationData("Rocket Hideout B1F-S", "Southwest Item", "Hyper Potion",
                 rom_addresses["Missable_Rocket_Hideout_B1F_Item_2"], Missable(124)),
    LocationData("Rocket Hideout B2F", "Northwest Left Item", "Moon Stone", rom_addresses["Missable_Rocket_Hideout_B2F_Item_1"],
                 Missable(125)),
    LocationData("Rocket Hideout B2F", "Northeast Item", "Nugget", rom_addresses["Missable_Rocket_Hideout_B2F_Item_2"],
                 Missable(126)),
    LocationData("Rocket Hideout B2F", "Northwest Right Item", "TM07 Horn Drill",
                 rom_addresses["Missable_Rocket_Hideout_B2F_Item_3"], Missable(127)),
    LocationData("Rocket Hideout B2F", "Southwest Item", "Super Potion",
                 rom_addresses["Missable_Rocket_Hideout_B2F_Item_4"], Missable(128)),
    LocationData("Rocket Hideout B3F", "East Item", "TM10 Double Edge",
                 rom_addresses["Missable_Rocket_Hideout_B3F_Item_1"], Missable(129)),
    LocationData("Rocket Hideout B3F", "Center Item", "Rare Candy", rom_addresses["Missable_Rocket_Hideout_B3F_Item_2"],
                 Missable(130)),
    LocationData("Rocket Hideout B4F-NW", "West Item", "HP Up", rom_addresses["Missable_Rocket_Hideout_B4F_Item_1"],
                 Missable(132)),
    LocationData("Rocket Hideout B4F-NW", "Northwest Item", "TM02 Razor Wind",
                 rom_addresses["Missable_Rocket_Hideout_B4F_Item_2"], Missable(133)),
    LocationData("Rocket Hideout B4F", "Southwest Item", "Iron", rom_addresses["Missable_Rocket_Hideout_B4F_Item_3"],
                 Missable(134)),
    LocationData("Rocket Hideout B4F", "Giovanni Item", "Silph Scope",
                 rom_addresses["Missable_Rocket_Hideout_B4F_Item_4"], [EventFlag(0x6A7), Missable(135)]),
    LocationData("Rocket Hideout B4F-NW", "Rocket Grunt Item", "Lift Key", rom_addresses["Missable_Rocket_Hideout_B4F_Item_5"],
                 [EventFlag(0x6A6), Missable(136)]),
    LocationData("Silph Co 3F-W", "Item", "Hyper Potion", rom_addresses["Missable_Silph_Co_3F_Item"], Missable(144)),
    LocationData("Silph Co 4F-W", "Left Item", "Full Heal", rom_addresses["Missable_Silph_Co_4F_Item_1"],
                 Missable(148)),
    LocationData("Silph Co 4F-W", "Middle Item", "Max Revive", rom_addresses["Missable_Silph_Co_4F_Item_2"],
                 Missable(149)),
    LocationData("Silph Co 4F-W", "Right Item", "Escape Rope", rom_addresses["Missable_Silph_Co_4F_Item_3"],
                 Missable(150)),
    LocationData("Silph Co 5F-SW", "Southwest Item", "TM09 Take Down", rom_addresses["Missable_Silph_Co_5F_Item_1"],
                 Missable(155)),
    LocationData("Silph Co 5F-NW", "Northwest Item", "Protein", rom_addresses["Missable_Silph_Co_5F_Item_2"], Missable(156)),
    LocationData("Silph Co 5F", "Southeast Item", "Card Key", rom_addresses["Missable_Silph_Co_5F_Item_3"], Missable(157)),
    LocationData("Silph Co 6F-SW", "Southwest Top Item", "HP Up", rom_addresses["Missable_Silph_Co_6F_Item_1"], Missable(161)),
    LocationData("Silph Co 6F-SW", "Southwest Bottom Item", "X Accuracy", rom_addresses["Missable_Silph_Co_6F_Item_2"],
                 Missable(162)),
    LocationData("Silph Co 7F", "West Item", "Calcium", rom_addresses["Missable_Silph_Co_7F_Item_1"], Missable(168)),
    LocationData("Silph Co 7F-E", "East Item", "TM03 Swords Dance", rom_addresses["Missable_Silph_Co_7F_Item_2"],
                 Missable(169)),
    LocationData("Silph Co 10F", "Left Item", "TM26 Earthquake", rom_addresses["Missable_Silph_Co_10F_Item_1"],
                 Missable(180)),
    LocationData("Silph Co 10F", "Bottom Item", "Rare Candy", rom_addresses["Missable_Silph_Co_10F_Item_2"],
                 Missable(181)),
    LocationData("Silph Co 10F", "Right Item", "Carbos", rom_addresses["Missable_Silph_Co_10F_Item_3"], Missable(182)),
    LocationData("Pokemon Mansion 2F", "Northeast Item", "Calcium", rom_addresses["Missable_Pokemon_Mansion_2F_Item"],
                 Missable(187)),
    LocationData("Pokemon Mansion 3F-SW", "Southwest Item", "Max Potion", rom_addresses["Missable_Pokemon_Mansion_3F_Item_1"],
                 Missable(188)),
    LocationData("Pokemon Mansion 3F", "Northeast Item", "Iron", rom_addresses["Missable_Pokemon_Mansion_3F_Item_2"],
                 Missable(189)),
    LocationData("Pokemon Mansion B1F", "North Item", "Rare Candy",
                 rom_addresses["Missable_Pokemon_Mansion_B1F_Item_1"], Missable(190)),
    LocationData("Pokemon Mansion B1F", "Southwest Item", "Full Restore",
                 rom_addresses["Missable_Pokemon_Mansion_B1F_Item_2"], Missable(191)),
    LocationData("Pokemon Mansion B1F", "South Item", "TM14 Blizzard",
                 rom_addresses["Missable_Pokemon_Mansion_B1F_Item_3"], Missable(192)),
    LocationData("Pokemon Mansion B1F", "Northwest Item", "TM22 Solar Beam",
                 rom_addresses["Missable_Pokemon_Mansion_B1F_Item_4"], Missable(193)),
    LocationData("Pokemon Mansion B1F", "West Item", "Secret Key",
                 rom_addresses["Missable_Pokemon_Mansion_B1F_Item_5"], Missable(194)),
    LocationData("Safari Zone East", "Northeast Item", "Full Restore", rom_addresses["Missable_Safari_Zone_East_Item_1"],
                 Missable(195)),
    LocationData("Safari Zone East", "West Item", "Max Potion", rom_addresses["Missable_Safari_Zone_East_Item_2"],
                 Missable(196)),
    LocationData("Safari Zone East", "East Item", "Carbos", rom_addresses["Missable_Safari_Zone_East_Item_3"],
                 Missable(197)),
    LocationData("Safari Zone East", "Center Item", "TM37 Egg Bomb", rom_addresses["Missable_Safari_Zone_East_Item_4"],
                 Missable(198)),
    LocationData("Safari Zone North", "Northeast Item", "Protein", rom_addresses["Missable_Safari_Zone_North_Item_1"],
                 Missable(199)),
    LocationData("Safari Zone North", "North Item", "TM40 Skull Bash",
                 rom_addresses["Missable_Safari_Zone_North_Item_2"], Missable(200)),
    LocationData("Safari Zone West", "Southwest Item", "Max Potion", rom_addresses["Missable_Safari_Zone_West_Item_1"],
                 Missable(201)),
    LocationData("Safari Zone West-NW", "Northwest Item", "TM32 Double Team",
                 rom_addresses["Missable_Safari_Zone_West_Item_2"], Missable(202)),
    LocationData("Safari Zone West", "Southeast Item", "Max Revive", rom_addresses["Missable_Safari_Zone_West_Item_3"],
                 Missable(203)),
    LocationData("Safari Zone West-NW", "Northeast Item", "Gold Teeth", rom_addresses["Missable_Safari_Zone_West_Item_4"],
                 Missable(204)),
    LocationData("Safari Zone Center-C", "Island Item", "Nugget", rom_addresses["Missable_Safari_Zone_Center_Item"],
                 Missable(205)),
    LocationData("Cerulean Cave 2F-E", "East Item", "PP Up", rom_addresses["Missable_Cerulean_Cave_2F_Item_1"],
                 Missable(206)),
    LocationData("Cerulean Cave 2F-W", "Southwest Item", "Ultra Ball", rom_addresses["Missable_Cerulean_Cave_2F_Item_2"],
                 Missable(207)),
    LocationData("Cerulean Cave 2F-N", "North Item", "Full Restore", rom_addresses["Missable_Cerulean_Cave_2F_Item_3"],
                 Missable(208)),
    LocationData("Cerulean Cave B1F", "Center Item", "Ultra Ball", rom_addresses["Missable_Cerulean_Cave_B1F_Item_1"],
                 Missable(210)),
    LocationData("Cerulean Cave B1F", "North Item", "Max Revive", rom_addresses["Missable_Cerulean_Cave_B1F_Item_2"],
                 Missable(211)),
    LocationData("Victory Road 1F", "Top Item", "TM43 Sky Attack", rom_addresses["Missable_Victory_Road_1F_Item_1"],
                 Missable(212)),
    LocationData("Victory Road 1F", "Left Item", "Rare Candy", rom_addresses["Missable_Victory_Road_1F_Item_2"],
                 Missable(213)),
    LocationData("Rock Tunnel B1F-E", "Southwest Item", "Hideout Key", rom_addresses["Missable_Rock_Tunnel_B1F_Item_1"],
                 Missable(231), inclusion=extra_key_items),
    LocationData("Rock Tunnel B1F-W", "West Item", "Mansion Key", rom_addresses["Missable_Rock_Tunnel_B1F_Item_2"],
                 Missable(232), inclusion=extra_key_items),
    LocationData("Rock Tunnel B1F-W", "Northwest Item", "Plant Key", rom_addresses["Missable_Rock_Tunnel_B1F_Item_3"],
                 Missable(233), inclusion=extra_key_items),
    LocationData("Rock Tunnel B1F-W", "North Item", "Safari Pass", rom_addresses["Missable_Rock_Tunnel_B1F_Item_4"],
                 Missable(234), inclusion=extra_key_items),

    LocationData("Pewter Gym", "Brock Prize", "Boulder Badge", rom_addresses['Badge_Pewter_Gym'], EventFlag(0x8A0)),
    LocationData("Cerulean Gym", "Misty Prize", "Cascade Badge", rom_addresses['Badge_Cerulean_Gym'], EventFlag(0x8A1)),
    LocationData("Vermilion Gym", "Lt. Surge Prize", "Thunder Badge", rom_addresses['Badge_Vermilion_Gym'], EventFlag(0x8A2)),
    LocationData("Celadon Gym-C", "Erika Prize", "Rainbow Badge", rom_addresses['Badge_Celadon_Gym'], EventFlag(0x8A3)),
    LocationData("Fuchsia Gym", "Koga Prize", "Soul Badge", rom_addresses['Badge_Fuchsia_Gym'], EventFlag(0x8A4)),
    LocationData("Saffron Gym-C", "Sabrina Prize", "Marsh Badge", rom_addresses['Badge_Saffron_Gym'], EventFlag(0x8A5)),
    LocationData("Cinnabar Gym", "Blaine Prize", "Volcano Badge", rom_addresses['Badge_Cinnabar_Gym'], EventFlag(0x8A6)),
    LocationData("Viridian Gym", "Giovanni Prize", "Earth Badge", rom_addresses['Badge_Viridian_Gym'], EventFlag(0x8A7)),

    LocationData("Viridian Forest", "Hidden Item Northwest by Trainer", "Potion", rom_addresses['Hidden_Item_Viridian_Forest_1'], Hidden(0), inclusion=hidden_items),
    LocationData("Viridian Forest", "Hidden Item Entrance Tree", "Antidote", rom_addresses['Hidden_Item_Viridian_Forest_2'], Hidden(1), inclusion=hidden_items),
    LocationData("Mt Moon B2F", "Hidden Item Dead End Before Fossils", "Moon Stone", rom_addresses['Hidden_Item_MtMoonB2F_1'], Hidden(2), inclusion=hidden_moon_stones),
    LocationData("Route 25", "Hidden Item Fence Outside Bill's House", "Ether", rom_addresses['Hidden_Item_Route_25_1'], Hidden(3), inclusion=hidden_items),
    LocationData("Route 9", "Hidden Item Bush By Grass", "Ether", rom_addresses['Hidden_Item_Route_9'], Hidden(4), inclusion=hidden_items),
    LocationData("S.S. Anne Kitchen", "Hidden Item Kitchen Trash", "Great Ball", rom_addresses['Hidden_Item_SS_Anne_Kitchen'], Hidden(5), inclusion=hidden_items),
    LocationData("S.S. Anne B1F Rooms-Fisherman Room", "Hidden Item Under Pillow", "Hyper Potion", rom_addresses['Hidden_Item_SS_Anne_B1F'], Hidden(6), inclusion=hidden_items),
    LocationData("Route 10-N", "Hidden Item Behind Rock Tunnel Entrance Cuttable Tree", "Super Potion", rom_addresses['Hidden_Item_Route_10_1'], Hidden(7), inclusion=hidden_items),
    LocationData("Route 10-S", "Hidden Item Bush", "Max Ether", rom_addresses['Hidden_Item_Route_10_2'], Hidden(8), inclusion=hidden_items),
    LocationData("Rocket Hideout B1F", "Hidden Item Pot Plant", "PP Up", rom_addresses['Hidden_Item_Rocket_Hideout_B1F'], Hidden(9), inclusion=hidden_items),
    LocationData("Rocket Hideout B3F", "Hidden Item Near East Item", "Nugget", rom_addresses['Hidden_Item_Rocket_Hideout_B3F'], Hidden(10), inclusion=hidden_items),
    LocationData("Rocket Hideout B4F", "Hidden Item Behind Giovanni", "Super Potion", rom_addresses['Hidden_Item_Rocket_Hideout_B4F'], Hidden(11), inclusion=hidden_items),
    LocationData("Pokemon Tower 5F", "Hidden Item Near West Staircase", "Elixir", rom_addresses['Hidden_Item_Pokemon_Tower_5F'], Hidden(12), inclusion=hidden_items),
    LocationData("Route 13", "Hidden Item Dead End Bush", "PP Up", rom_addresses['Hidden_Item_Route_13_1'], Hidden(13), inclusion=hidden_items),
    LocationData("Route 13", "Hidden Item Dead End By Water Corner", "Calcium", rom_addresses['Hidden_Item_Route_13_2'], Hidden(14), inclusion=hidden_items),
    LocationData("Pokemon Mansion B1F", "Hidden Item Secret Key Room Corner", "Rare Candy", rom_addresses['Hidden_Item_Pokemon_Mansion_B1F'], Hidden(15), inclusion=hidden_items),
    LocationData("Safari Zone West-NW", "Hidden Item Secret House Statue", "Revive", rom_addresses['Hidden_Item_Safari_Zone_West'], Hidden(17), inclusion=hidden_items),
    LocationData("Silph Co 5F", "Hidden Item Pot Plant", "Elixir", rom_addresses['Hidden_Item_Silph_Co_5F'], Hidden(18), inclusion=hidden_items),
    LocationData("Silph Co 9F-SW", "Hidden Item Nurse Bed", "Max Potion", rom_addresses['Hidden_Item_Silph_Co_9F'], Hidden(19), inclusion=hidden_items),
    LocationData("Saffron Copycat's House 2F", "Hidden Item Desk", "Nugget", rom_addresses['Hidden_Item_Copycats_House'], Hidden(20), inclusion=hidden_items),
    LocationData("Cerulean Cave 1F-SW", "Hidden Item Center Rocks", "Rare Candy", rom_addresses['Hidden_Item_Cerulean_Cave_1F'], Hidden(21), inclusion=hidden_items),
    LocationData("Cerulean Cave B1F-E", "Hidden Item Northeast Rocks", "Ultra Ball", rom_addresses['Hidden_Item_Cerulean_Cave_B1F'], Hidden(22), inclusion=hidden_items),
    LocationData("Power Plant", "Hidden Item Central Dead End", "Max Elixir", rom_addresses['Hidden_Item_Power_Plant_1'], Hidden(23), inclusion=hidden_items),
    LocationData("Power Plant", "Hidden Item Before Zapdos", "PP Up", rom_addresses['Hidden_Item_Power_Plant_2'], Hidden(24), inclusion=hidden_items),
    LocationData("Seafoam Islands B2F-SW", "Hidden Item Rock", "Nugget", rom_addresses['Hidden_Item_Seafoam_Islands_B2F'], Hidden(25), inclusion=hidden_items),
    LocationData("Seafoam Islands B4F-W", "Hidden Item Corner Island", "Ultra Ball", rom_addresses['Hidden_Item_Seafoam_Islands_B4F'], Hidden(26), inclusion=hidden_items),
    LocationData("Pokemon Mansion 1F", "Hidden Item Block Near Entrance Carpet", "Moon Stone", rom_addresses['Hidden_Item_Pokemon_Mansion_1F'], Hidden(27), inclusion=hidden_moon_stones),
    LocationData("Pokemon Mansion 3F-SW", "Hidden Item Behind Burglar", "Max Revive", rom_addresses['Hidden_Item_Pokemon_Mansion_3F'], Hidden(28), inclusion=hidden_items),
    LocationData("Route 23-Grass", "Hidden Item Rocks Before Victory Road", "Full Restore", rom_addresses['Hidden_Item_Route_23_1'], Hidden(29), inclusion=hidden_items),
    LocationData("Route 23-Grass", "Hidden Item East Bush After Water", "Ultra Ball", rom_addresses['Hidden_Item_Route_23_2'], Hidden(30), inclusion=hidden_items),
    LocationData("Route 23-S", "Hidden Item On Island", "Max Ether", rom_addresses['Hidden_Item_Route_23_3'], Hidden(31), inclusion=hidden_items),
    LocationData("Victory Road 2F-NW", "Hidden Item Rock Before Moltres", "Ultra Ball", rom_addresses['Hidden_Item_Victory_Road_2F_1'], Hidden(32), inclusion=hidden_items),
    LocationData("Victory Road 2F-E", "Hidden Item Rock In Final Room", "Full Restore", rom_addresses['Hidden_Item_Victory_Road_2F_2'], Hidden(33), inclusion=hidden_items),

    LocationData("Viridian City", "Hidden Item Cuttable Tree", "Potion", rom_addresses['Hidden_Item_Viridian_City'], Hidden(35), inclusion=hidden_items),
    LocationData("Route 11", "Hidden Item Isolated Bush Near Gate", "Potion", rom_addresses['Hidden_Item_Route_11'], Hidden(36), inclusion=hidden_items),
    LocationData("Route 12-W", "Hidden Item Bush Near Gate", "Hyper Potion", rom_addresses['Hidden_Item_Route_12'], Hidden(37), inclusion=hidden_items),
    LocationData("Route 17", "Hidden Item In Grass", "Rare Candy", rom_addresses['Hidden_Item_Route_17_1'], Hidden(38), inclusion=hidden_items),
    LocationData("Route 17", "Hidden Item Near Northernmost Sign", "Full Restore", rom_addresses['Hidden_Item_Route_17_2'], Hidden(39), inclusion=hidden_items),
    LocationData("Route 17", "Hidden Item East Center", "PP Up", rom_addresses['Hidden_Item_Route_17_3'], Hidden(40), inclusion=hidden_items),
    LocationData("Route 17", "Hidden Item West Center", "Max Revive", rom_addresses['Hidden_Item_Route_17_4'], Hidden(41), inclusion=hidden_items),
    LocationData("Route 17", "Hidden Item Before Final Bridge", "Max Elixir", rom_addresses['Hidden_Item_Route_17_5'], Hidden(42), inclusion=hidden_items),
    LocationData("Underground Path North South", "Hidden Item Near Northern Stairs", "Full Restore", rom_addresses['Hidden_Item_Underground_Path_NS_1'], Hidden(43), inclusion=hidden_items),
    LocationData("Underground Path North South", "Hidden Item Near Southern Stairs", "X Special", rom_addresses['Hidden_Item_Underground_Path_NS_2'], Hidden(44), inclusion=hidden_items),
    LocationData("Underground Path West East", "Hidden Item West", "Nugget", rom_addresses['Hidden_Item_Underground_Path_WE_1'], Hidden(45), inclusion=hidden_items),
    LocationData("Underground Path West East", "Hidden Item East", "Elixir", rom_addresses['Hidden_Item_Underground_Path_WE_2'], Hidden(46), inclusion=hidden_items),
    LocationData("Celadon City", "Hidden Item Dead End Near Cuttable Tree", "PP Up", rom_addresses['Hidden_Item_Celadon_City'], Hidden(47), inclusion=hidden_items),
    LocationData("Route 25", "Hidden Item Northeast Of Grass", "Elixir", rom_addresses['Hidden_Item_Route_25_2'], Hidden(48), inclusion=hidden_items),
    LocationData("Mt Moon B2F-NE", "Hidden Item Lone Rock", "Ether", rom_addresses['Hidden_Item_MtMoonB2F_2'], Hidden(49), inclusion=hidden_items),
    LocationData("Seafoam Islands B3F", "Hidden Item Rock", "Max Elixir", rom_addresses['Hidden_Item_Seafoam_Islands_B3F'], Hidden(50), inclusion=hidden_items),
    LocationData("Vermilion City", "Hidden Item In Water Near Fan Club", "Max Ether", rom_addresses['Hidden_Item_Vermilion_City'], Hidden(51), inclusion=hidden_items),
    LocationData("Cerulean City-Badge House Backyard", "Hidden Item Gym Badge Guy's Backyard", "Rare Candy", rom_addresses['Hidden_Item_Cerulean_City'], Hidden(52), inclusion=hidden_items),
    LocationData("Route 4-C", "Hidden Item Plateau East Of Mt Moon", "Great Ball", rom_addresses['Hidden_Item_Route_4'], Hidden(53), inclusion=hidden_items),


    LocationData("Oak's Lab", "Oak's Parcel Reward", "Pokedex", rom_addresses["Event_Pokedex"], EventFlag(0x38)),

    LocationData("Pokemon Mansion 1F-SE", "Scientist", None, rom_addresses["Trainersanity_EVENT_BEAT_MANSION_1_TRAINER_0_ITEM"], EventFlag(376), inclusion=trainersanity),
    LocationData("Pokemon Mansion 2F", "Burglar", None, rom_addresses["Trainersanity_EVENT_BEAT_MANSION_2_TRAINER_0_ITEM"], EventFlag(43), inclusion=trainersanity),
    LocationData("Pokemon Mansion 3F-SE", "Scientist", None, rom_addresses["Trainersanity_EVENT_BEAT_MANSION_3_TRAINER_1_ITEM"], EventFlag(31), inclusion=trainersanity),
    LocationData("Pokemon Mansion 3F-SW", "Burglar", None, rom_addresses["Trainersanity_EVENT_BEAT_MANSION_3_TRAINER_0_ITEM"], EventFlag(42), inclusion=trainersanity),
    LocationData("Pokemon Mansion B1F", "Scientist", None, rom_addresses["Trainersanity_EVENT_BEAT_MANSION_4_TRAINER_1_ITEM"], EventFlag(29), inclusion=trainersanity),
    LocationData("Pokemon Mansion B1F", "Burglar", None, rom_addresses["Trainersanity_EVENT_BEAT_MANSION_4_TRAINER_0_ITEM"], EventFlag(30), inclusion=trainersanity),
    LocationData("Silph Co 11F", "Rocket 1", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_11F_TRAINER_1_ITEM"], EventFlag(45), inclusion=trainersanity),
    LocationData("Silph Co 11F-W", "Rocket 2", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_11F_TRAINER_0_ITEM"], EventFlag(46), inclusion=trainersanity),
    LocationData("Silph Co 10F", "Scientist", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_10F_TRAINER_1_ITEM"], EventFlag(47), inclusion=trainersanity),
    LocationData("Silph Co 10F", "Rocket", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_10F_TRAINER_0_ITEM"], EventFlag(48), inclusion=trainersanity),
    LocationData("Silph Co 9F", "Rocket 1", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_9F_TRAINER_2_ITEM"], EventFlag(49), inclusion=trainersanity),
    LocationData("Silph Co 9F", "Scientist", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_9F_TRAINER_1_ITEM"], EventFlag(50), inclusion=trainersanity),
    LocationData("Silph Co 9F-NW", "Rocket 2", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_9F_TRAINER_0_ITEM"], EventFlag(51), inclusion=trainersanity),
    LocationData("Silph Co 8F", "Rocket 1", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_8F_TRAINER_0_ITEM"], EventFlag(54), inclusion=trainersanity),
    LocationData("Silph Co 8F", "Rocket 2", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_8F_TRAINER_2_ITEM"], EventFlag(52), inclusion=trainersanity),
    LocationData("Silph Co 8F", "Scientist", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_8F_TRAINER_1_ITEM"], EventFlag(53), inclusion=trainersanity),
    LocationData("Silph Co 7F", "Rocket 1", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_7F_TRAINER_2_ITEM"], EventFlag(58), inclusion=trainersanity),
    LocationData("Silph Co 7F", "Rocket 2", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_7F_TRAINER_0_ITEM"], EventFlag(60), inclusion=trainersanity),
    LocationData("Silph Co 7F", "Scientist", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_7F_TRAINER_1_ITEM"], EventFlag(59), inclusion=trainersanity),
    LocationData("Silph Co 7F-SE", "Rocket 3", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_7F_TRAINER_3_ITEM"], EventFlag(55), inclusion=trainersanity),
    LocationData("Silph Co 6F", "Rocket 1", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_6F_TRAINER_0_ITEM"], EventFlag(64), inclusion=trainersanity),
    LocationData("Silph Co 6F", "Scientist", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_6F_TRAINER_1_ITEM"], EventFlag(63), inclusion=trainersanity),
    LocationData("Silph Co 6F", "Rocket 2", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_6F_TRAINER_2_ITEM"], EventFlag(62), inclusion=trainersanity),
    LocationData("Silph Co 5F", "Rocket 1", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_5F_TRAINER_3_ITEM"], EventFlag(65), inclusion=trainersanity),
    LocationData("Silph Co 5F", "Juggler", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_5F_TRAINER_2_ITEM"], EventFlag(66), inclusion=trainersanity),
    LocationData("Silph Co 5F", "Scientist", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_5F_TRAINER_1_ITEM"], EventFlag(67), inclusion=trainersanity),
    LocationData("Silph Co 5F", "Rocket 2", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_5F_TRAINER_0_ITEM"], EventFlag(68), inclusion=trainersanity),
    LocationData("Silph Co 4F", "Rocket 1", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_4F_TRAINER_2_ITEM"], EventFlag(69), inclusion=trainersanity),
    LocationData("Silph Co 4F", "Rocket 2", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_4F_TRAINER_0_ITEM"], EventFlag(71), inclusion=trainersanity),
    LocationData("Silph Co 4F-N", "Scientist", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_4F_TRAINER_1_ITEM"], EventFlag(70), inclusion=trainersanity),
    LocationData("Silph Co 3F-W", "Scientist", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_3F_TRAINER_1_ITEM"], EventFlag(72), inclusion=trainersanity),
    LocationData("Silph Co 3F", "Rocket", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_3F_TRAINER_0_ITEM"], EventFlag(73), inclusion=trainersanity),
    LocationData("Silph Co 2F", "Rocket 1", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_2F_TRAINER_3_ITEM"], EventFlag(74), inclusion=trainersanity),
    LocationData("Silph Co 2F", "Rocket 2", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_2F_TRAINER_2_ITEM"], EventFlag(75), inclusion=trainersanity),
    LocationData("Silph Co 2F", "Scientist 1", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_2F_TRAINER_1_ITEM"], EventFlag(76), inclusion=trainersanity), ##
    LocationData("Silph Co 2F-SW", "Scientist 2", None, rom_addresses["Trainersanity_EVENT_BEAT_SILPH_CO_2F_TRAINER_0_ITEM"], EventFlag(77), inclusion=trainersanity), ##
    LocationData("Rocket Hideout B1F", "Rocket 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCKET_HIDEOUT_1_TRAINER_0_ITEM"], EventFlag(99), inclusion=trainersanity),
    LocationData("Rocket Hideout B1F", "Rocket 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCKET_HIDEOUT_1_TRAINER_1_ITEM"], EventFlag(98), inclusion=trainersanity),
    LocationData("Rocket Hideout B1F-S", "Rocket 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCKET_HIDEOUT_1_TRAINER_3_ITEM"], EventFlag(96), inclusion=trainersanity),
    LocationData("Rocket Hideout B1F-S", "Rocket 4", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCKET_HIDEOUT_1_TRAINER_2_ITEM"], EventFlag(97), inclusion=trainersanity),
    LocationData("Rocket Hideout B1F-SE", "Rocket 5", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCKET_HIDEOUT_1_TRAINER_4_ITEM"], EventFlag(95), inclusion=trainersanity),
    LocationData("Rocket Hideout B2F", "Rocket", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCKET_HIDEOUT_2_TRAINER_0_ITEM"], EventFlag(94), inclusion=trainersanity),
    LocationData("Rocket Hideout B3F", "Rocket 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCKET_HIDEOUT_3_TRAINER_1_ITEM"], EventFlag(92), inclusion=trainersanity),
    LocationData("Rocket Hideout B3F", "Rocket 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCKET_HIDEOUT_3_TRAINER_0_ITEM"], EventFlag(93), inclusion=trainersanity),
    LocationData("Rocket Hideout B4F-NW", "Rocket 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCKET_HIDEOUT_4_TRAINER_2_ITEM"], EventFlag(79), inclusion=trainersanity),
    LocationData("Rocket Hideout B4F", "Rocket 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCKET_HIDEOUT_4_TRAINER_0_ITEM"], EventFlag(91), inclusion=trainersanity),
    LocationData("Rocket Hideout B4F", "Rocket 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCKET_HIDEOUT_4_TRAINER_1_ITEM"], EventFlag(90), inclusion=trainersanity),
    LocationData("S.S. Anne 1F Rooms-West Gentleman Room", "Gentleman 1", None, rom_addresses["Trainersanity_EVENT_BEAT_SS_ANNE_8_TRAINER_1_ITEM"], EventFlag(121), inclusion=trainersanity),
    LocationData("S.S. Anne 1F Rooms-East Gentleman Room", "Gentleman 2", None, rom_addresses["Trainersanity_EVENT_BEAT_SS_ANNE_8_TRAINER_0_ITEM"], EventFlag(122), inclusion=trainersanity),
    LocationData("S.S. Anne 1F Rooms-Youngster and Lass Room", "Lass", None, rom_addresses["Trainersanity_EVENT_BEAT_SS_ANNE_8_TRAINER_3_ITEM"], EventFlag(117), inclusion=trainersanity),
    LocationData("S.S. Anne 1F Rooms-Youngster and Lass Room", "Youngster", None, rom_addresses["Trainersanity_EVENT_BEAT_SS_ANNE_8_TRAINER_2_ITEM"], EventFlag(120), inclusion=trainersanity),
    LocationData("S.S. Anne 2F Rooms-Fisherman and Gentleman Room", "Fisherman", None, rom_addresses["Trainersanity_EVENT_BEAT_SS_ANNE_9_TRAINER_1_ITEM"], EventFlag(115), inclusion=trainersanity),
    LocationData("S.S. Anne 2F Rooms-Fisherman and Gentleman Room", "Gentleman 1", None, rom_addresses["Trainersanity_EVENT_BEAT_SS_ANNE_9_TRAINER_0_ITEM"], EventFlag(116), inclusion=trainersanity),
    LocationData("S.S. Anne 2F Rooms-Gentleman and Lass Room", "Gentleman 2", None, rom_addresses["Trainersanity_EVENT_BEAT_SS_ANNE_9_TRAINER_2_ITEM"], EventFlag(113), inclusion=trainersanity),
    LocationData("S.S. Anne 2F Rooms-Gentleman and Lass Room", "Lass", None, rom_addresses["Trainersanity_EVENT_BEAT_SS_ANNE_9_TRAINER_3_ITEM"], EventFlag(112), inclusion=trainersanity),
    LocationData("S.S. Anne Bow", "Sailor 1", None, rom_addresses["Trainersanity_EVENT_BEAT_SS_ANNE_5_TRAINER_1_ITEM"], EventFlag(123), inclusion=trainersanity),
    LocationData("S.S. Anne Bow", "Sailor 2", None, rom_addresses["Trainersanity_EVENT_BEAT_SS_ANNE_5_TRAINER_0_ITEM"], EventFlag(124), inclusion=trainersanity),
    LocationData("S.S. Anne B1F Rooms-Two Sailors Room", "Sailor 1", None, rom_addresses["Trainersanity_EVENT_BEAT_SS_ANNE_10_TRAINER_1_ITEM"], EventFlag(110), inclusion=trainersanity),
    LocationData("S.S. Anne B1F Rooms-Two Sailors Room", "Sailor 2", None, rom_addresses["Trainersanity_EVENT_BEAT_SS_ANNE_10_TRAINER_0_ITEM"], EventFlag(111), inclusion=trainersanity),
    LocationData("S.S. Anne B1F Rooms-East Single Sailor Room", "Sailor 3", None, rom_addresses["Trainersanity_EVENT_BEAT_SS_ANNE_10_TRAINER_3_ITEM"], EventFlag(108), inclusion=trainersanity),
    LocationData("S.S. Anne B1F Rooms-West Single Sailor Room", "Sailor 4", None, rom_addresses["Trainersanity_EVENT_BEAT_SS_ANNE_10_TRAINER_2_ITEM"], EventFlag(109), inclusion=trainersanity),
    LocationData("S.S. Anne B1F Rooms-Fisherman Room", "Fisherman", None, rom_addresses["Trainersanity_EVENT_BEAT_SS_ANNE_10_TRAINER_5_ITEM"], EventFlag(106), inclusion=trainersanity),
    LocationData("S.S. Anne B1F Rooms-Fisherman Room", "Sailor 5", None, rom_addresses["Trainersanity_EVENT_BEAT_SS_ANNE_10_TRAINER_4_ITEM"], EventFlag(107), inclusion=trainersanity),
    LocationData("Mt Moon 1F", "Bug Catcher 1", None, rom_addresses["Trainersanity_EVENT_BEAT_MT_MOON_1_TRAINER_5_ITEM"], EventFlag(131), inclusion=trainersanity),
    LocationData("Mt Moon 1F", "Lass 1", None, rom_addresses["Trainersanity_EVENT_BEAT_MT_MOON_1_TRAINER_4_ITEM"], EventFlag(132), inclusion=trainersanity),
    LocationData("Mt Moon 1F", "Super Nerd", None, rom_addresses["Trainersanity_EVENT_BEAT_MT_MOON_1_TRAINER_3_ITEM"], EventFlag(133), inclusion=trainersanity),
    LocationData("Mt Moon 1F", "Bug Catcher 2", None, rom_addresses["Trainersanity_EVENT_BEAT_MT_MOON_1_TRAINER_6_ITEM"], EventFlag(130), inclusion=trainersanity),
    LocationData("Mt Moon 1F", "Lass 2", None, rom_addresses["Trainersanity_EVENT_BEAT_MT_MOON_1_TRAINER_2_ITEM"], EventFlag(134), inclusion=trainersanity),
    LocationData("Mt Moon 1F", "Youngster", None, rom_addresses["Trainersanity_EVENT_BEAT_MT_MOON_1_TRAINER_1_ITEM"], EventFlag(135), inclusion=trainersanity),
    LocationData("Mt Moon 1F", "Hiker", None, rom_addresses["Trainersanity_EVENT_BEAT_MT_MOON_1_TRAINER_0_ITEM"], EventFlag(136), inclusion=trainersanity),
    LocationData("Mt Moon B2F-C", "Rocket 1", None, rom_addresses["Trainersanity_EVENT_BEAT_MT_MOON_3_TRAINER_1_ITEM"], EventFlag(127), inclusion=trainersanity),
    LocationData("Mt Moon B2F-NE", "Rocket 2", None, rom_addresses["Trainersanity_EVENT_BEAT_MT_MOON_3_TRAINER_2_ITEM"], EventFlag(126), inclusion=trainersanity),
    LocationData("Mt Moon B2F", "Rocket 3", None, rom_addresses["Trainersanity_EVENT_BEAT_MT_MOON_3_TRAINER_3_ITEM"], EventFlag(125), inclusion=trainersanity),
    LocationData("Mt Moon B2F", "Rocket 4", None, rom_addresses["Trainersanity_EVENT_BEAT_MT_MOON_3_TRAINER_0_ITEM"], EventFlag(128), inclusion=trainersanity),
    LocationData("Viridian Forest", "Bug Catcher 1", None, rom_addresses["Trainersanity_EVENT_BEAT_VIRIDIAN_FOREST_TRAINER_0_ITEM"], EventFlag(139), inclusion=trainersanity),
    LocationData("Viridian Forest", "Bug Catcher 2", None, rom_addresses["Trainersanity_EVENT_BEAT_VIRIDIAN_FOREST_TRAINER_1_ITEM"], EventFlag(138), inclusion=trainersanity),
    LocationData("Viridian Forest", "Bug Catcher 3", None, rom_addresses["Trainersanity_EVENT_BEAT_VIRIDIAN_FOREST_TRAINER_2_ITEM"], EventFlag(137), inclusion=trainersanity),
    LocationData("Route 25", "Hiker 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_25_TRAINER_6_ITEM"], EventFlag(142), inclusion=trainersanity),
    LocationData("Route 25", "Youngster 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_25_TRAINER_0_ITEM"], EventFlag(148), inclusion=trainersanity),
    LocationData("Route 25", "Hiker 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_25_TRAINER_8_ITEM"], EventFlag(140), inclusion=trainersanity),
    LocationData("Route 25", "Youngster 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_25_TRAINER_1_ITEM"], EventFlag(147), inclusion=trainersanity),
    LocationData("Route 25", "Lass 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_25_TRAINER_3_ITEM"], EventFlag(145), inclusion=trainersanity),
    LocationData("Route 25", "Hiker 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_25_TRAINER_7_ITEM"], EventFlag(141), inclusion=trainersanity),
    LocationData("Route 25", "Jr. Trainer M", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_25_TRAINER_2_ITEM"], EventFlag(146), inclusion=trainersanity),
    LocationData("Route 25", "Youngster 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_25_TRAINER_4_ITEM"], EventFlag(144), inclusion=trainersanity),
    LocationData("Route 25", "Lass 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_25_TRAINER_5_ITEM"], EventFlag(143), inclusion=trainersanity),
    LocationData("Route 24", "Bug Catcher", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_24_TRAINER_5_ITEM"], EventFlag(149), inclusion=trainersanity),
    LocationData("Route 24", "Lass 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_24_TRAINER_4_ITEM"], EventFlag(150), inclusion=trainersanity),
    LocationData("Route 24", "Youngster", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_24_TRAINER_3_ITEM"], EventFlag(151), inclusion=trainersanity),
    LocationData("Route 24", "Lass 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_24_TRAINER_2_ITEM"], EventFlag(153), inclusion=trainersanity),
    LocationData("Route 24", "Jr. Trainer M 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_24_TRAINER_1_ITEM"], EventFlag(154), inclusion=trainersanity),
    LocationData("Route 24", "Jr. Trainer M 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_24_TRAINER_0_ITEM"], EventFlag(155), inclusion=trainersanity),
    LocationData("Route 21", "Fisherman 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_21_TRAINER_0_ITEM"], EventFlag(174), inclusion=trainersanity),
    LocationData("Route 21", "Fisherman 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_21_TRAINER_1_ITEM"], EventFlag(173), inclusion=trainersanity),
    LocationData("Route 21", "Cue Ball", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_21_TRAINER_3_ITEM"], EventFlag(171), inclusion=trainersanity),
    LocationData("Route 21", "Swimmer 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_21_TRAINER_2_ITEM"], EventFlag(172), inclusion=trainersanity),
    LocationData("Route 21", "Fisherman 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_21_TRAINER_7_ITEM"], EventFlag(166), inclusion=trainersanity),
    LocationData("Route 21", "Fisherman 4", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_21_TRAINER_8_ITEM"], EventFlag(165), inclusion=trainersanity),
    LocationData("Route 21", "Swimmer 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_21_TRAINER_4_ITEM"], EventFlag(170), inclusion=trainersanity),
    LocationData("Route 21", "Swimmer 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_21_TRAINER_6_ITEM"], EventFlag(168), inclusion=trainersanity),
    LocationData("Route 21", "Swimmer 4", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_21_TRAINER_5_ITEM"], EventFlag(169), inclusion=trainersanity),
    LocationData("Route 20-W", "Beauty 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_20_TRAINER_9_ITEM"], EventFlag(175), inclusion=trainersanity),
    LocationData("Route 20-W", "Jr. Trainer F 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_20_TRAINER_8_ITEM"], EventFlag(176), inclusion=trainersanity),
    LocationData("Route 20-W", "Beauty 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_20_TRAINER_7_ITEM"], EventFlag(177), inclusion=trainersanity),
    LocationData("Route 20-W", "Bird Keeper", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_20_TRAINER_6_ITEM"], EventFlag(178), inclusion=trainersanity),
    LocationData("Route 20-W", "Swimmer 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_20_TRAINER_4_ITEM"], EventFlag(180), inclusion=trainersanity),
    LocationData("Route 20-W", "Jr. Trainer F 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_20_TRAINER_3_ITEM"], EventFlag(181), inclusion=trainersanity),
    LocationData("Route 20-E", "Beauty 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_20_TRAINER_2_ITEM"], EventFlag(182), inclusion=trainersanity),
    LocationData("Route 20-E", "Beauty 4", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_20_TRAINER_1_ITEM"], EventFlag(183), inclusion=trainersanity),
    LocationData("Route 20-E", "Swimmer 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_20_TRAINER_5_ITEM"], EventFlag(179), inclusion=trainersanity),
    LocationData("Route 20-E", "Swimmer 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_20_TRAINER_0_ITEM"], EventFlag(184), inclusion=trainersanity),
    LocationData("Route 19-N", "Swimmer 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_19_TRAINER_0_ITEM"], EventFlag(199), inclusion=trainersanity),
    LocationData("Route 19-N", "Swimmer 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_19_TRAINER_1_ITEM"], EventFlag(198), inclusion=trainersanity),
    LocationData("Route 19-S", "Swimmer 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_19_TRAINER_5_ITEM"], EventFlag(194), inclusion=trainersanity),
    LocationData("Route 19-S", "Swimmer 4", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_19_TRAINER_2_ITEM"], EventFlag(197), inclusion=trainersanity),
    LocationData("Route 19-S", "Swimmer 5", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_19_TRAINER_3_ITEM"], EventFlag(196), inclusion=trainersanity),
    LocationData("Route 19-S", "Swimmer 6", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_19_TRAINER_4_ITEM"], EventFlag(195), inclusion=trainersanity),
    LocationData("Route 19-S", "Swimmer 7", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_19_TRAINER_8_ITEM"], EventFlag(188), inclusion=trainersanity),
    LocationData("Route 19-S", "Beauty 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_19_TRAINER_7_ITEM"], EventFlag(189), inclusion=trainersanity),
    LocationData("Route 19-S", "Beauty 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_19_TRAINER_6_ITEM"], EventFlag(193), inclusion=trainersanity),
    LocationData("Route 19-S", "Beauty 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_19_TRAINER_9_ITEM"], EventFlag(185), inclusion=trainersanity),
    LocationData("Route 18-E", "Bird Keeper 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_18_TRAINER_2_ITEM"], EventFlag(200), inclusion=trainersanity),
    LocationData("Route 18-E", "Bird Keeper 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_18_TRAINER_1_ITEM"], EventFlag(201), inclusion=trainersanity),
    LocationData("Route 18-E", "Bird Keeper 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_18_TRAINER_0_ITEM"], EventFlag(202), inclusion=trainersanity),
    LocationData("Route 17", "Cue Ball 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_17_TRAINER_1_ITEM"], EventFlag(211), inclusion=trainersanity),
    LocationData("Route 17", "Biker 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_17_TRAINER_2_ITEM"], EventFlag(210), inclusion=trainersanity),
    LocationData("Route 17", "Cue Ball 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_17_TRAINER_0_ITEM"], EventFlag(212), inclusion=trainersanity),
    LocationData("Route 17", "Biker 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_17_TRAINER_3_ITEM"], EventFlag(209), inclusion=trainersanity),
    LocationData("Route 17", "Biker 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_17_TRAINER_4_ITEM"], EventFlag(208), inclusion=trainersanity),
    LocationData("Route 17", "Cue Ball 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_17_TRAINER_5_ITEM"], EventFlag(207), inclusion=trainersanity),
    LocationData("Route 17", "Cue Ball 4", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_17_TRAINER_6_ITEM"], EventFlag(206), inclusion=trainersanity),
    LocationData("Route 17", "Biker 4", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_17_TRAINER_8_ITEM"], EventFlag(204), inclusion=trainersanity),
    LocationData("Route 17", "Cue Ball 5", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_17_TRAINER_7_ITEM"], EventFlag(205), inclusion=trainersanity),
    LocationData("Route 17", "Biker 5", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_17_TRAINER_9_ITEM"], EventFlag(203), inclusion=trainersanity),
    LocationData("Route 16-SW", "Biker", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_16_TRAINER_0_ITEM"], EventFlag(219), inclusion=trainersanity),
    LocationData("Route 16-SW", "Cue Ball 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_16_TRAINER_1_ITEM"], EventFlag(218), inclusion=trainersanity),
    LocationData("Route 16-SW", "Cue Ball 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_16_TRAINER_2_ITEM"], EventFlag(217), inclusion=trainersanity),
    LocationData("Route 16-SW", "Biker 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_16_TRAINER_3_ITEM"], EventFlag(216), inclusion=trainersanity),
    LocationData("Route 16-SW", "Cue Ball 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_16_TRAINER_4_ITEM"], EventFlag(215), inclusion=trainersanity),
    LocationData("Route 16-SW", "Biker 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_16_TRAINER_5_ITEM"], EventFlag(214), inclusion=trainersanity),
    LocationData("Route 15-N", "Jr. Trainer F 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_15_TRAINER_8_ITEM"], EventFlag(221), inclusion=trainersanity),
    LocationData("Route 15", "Beauty 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_15_TRAINER_4_ITEM"], EventFlag(225), inclusion=trainersanity),
    LocationData("Route 15", "Jr. Trainer F 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_15_TRAINER_1_ITEM"], EventFlag(228), inclusion=trainersanity),
    LocationData("Route 15", "Biker 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_15_TRAINER_6_ITEM"], EventFlag(223), inclusion=trainersanity),
    LocationData("Route 15", "Biker 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_15_TRAINER_7_ITEM"], EventFlag(222), inclusion=trainersanity),
    LocationData("Route 15", "Jr. Trainer F 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_15_TRAINER_0_ITEM"], EventFlag(229), inclusion=trainersanity),
    LocationData("Route 15", "Beauty 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_15_TRAINER_5_ITEM"], EventFlag(224), inclusion=trainersanity),
    LocationData("Route 15", "Bird Keeper 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_15_TRAINER_3_ITEM"], EventFlag(226), inclusion=trainersanity),
    LocationData("Route 15", "Bird Keeper 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_15_TRAINER_2_ITEM"], EventFlag(227), inclusion=trainersanity),
    LocationData("Route 15", "Jr. Trainer F 4", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_15_TRAINER_9_ITEM"], EventFlag(220), inclusion=trainersanity),
    LocationData("Route 14", "Bird Keeper 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_14_TRAINER_0_ITEM"], EventFlag(244), inclusion=trainersanity),
    LocationData("Route 14", "Bird Keeper 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_14_TRAINER_1_ITEM"], EventFlag(240), inclusion=trainersanity),
    LocationData("Route 14", "Bird Keeper 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_14_TRAINER_2_ITEM"], EventFlag(237), inclusion=trainersanity),
    LocationData("Route 14", "Bird Keeper 4", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_14_TRAINER_3_ITEM"], EventFlag(236), inclusion=trainersanity),
    LocationData("Route 14", "Biker 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_14_TRAINER_8_ITEM"], EventFlag(231), inclusion=trainersanity),
    LocationData("Route 14", "Bird Keeper 5", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_14_TRAINER_4_ITEM"], EventFlag(235), inclusion=trainersanity),
    LocationData("Route 14", "Biker 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_14_TRAINER_9_ITEM"], EventFlag(230), inclusion=trainersanity),
    LocationData("Route 14", "Biker 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_14_TRAINER_7_ITEM"], EventFlag(232), inclusion=trainersanity),
    LocationData("Route 14", "Biker 4", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_14_TRAINER_6_ITEM"], EventFlag(233), inclusion=trainersanity),
    LocationData("Route 14", "Bird Keeper 6", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_14_TRAINER_5_ITEM"], EventFlag(234), inclusion=trainersanity),
    LocationData("Route 13-E", "Jr. Trainer F 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_13_TRAINER_4_ITEM"], EventFlag(253), inclusion=trainersanity),
    LocationData("Route 13-E", "Bird Keeper 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_13_TRAINER_0_ITEM"], EventFlag(257), inclusion=trainersanity),
    LocationData("Route 13-E", "Jr. Trainer F 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_13_TRAINER_1_ITEM"], EventFlag(256), inclusion=trainersanity),
    LocationData("Route 13", "Beauty 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_13_TRAINER_6_ITEM"], EventFlag(248), inclusion=trainersanity),
    LocationData("Route 13", "Beauty 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_13_TRAINER_7_ITEM"], EventFlag(247), inclusion=trainersanity),
    LocationData("Route 13", "Jr. Trainer F 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_13_TRAINER_2_ITEM"], EventFlag(255), inclusion=trainersanity),
    LocationData("Route 13", "Jr. Trainer F 4", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_13_TRAINER_3_ITEM"], EventFlag(254), inclusion=trainersanity),
    LocationData("Route 13", "Bird Keeper 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_13_TRAINER_9_ITEM"], EventFlag(245), inclusion=trainersanity),
    LocationData("Route 13", "Bird Keeper 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_13_TRAINER_5_ITEM"], EventFlag(252), inclusion=trainersanity),
    LocationData("Route 13", "Biker", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_13_TRAINER_8_ITEM"], EventFlag(246), inclusion=trainersanity),
    LocationData("Route 12-N", "Fisherman 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_12_TRAINER_0_ITEM"], EventFlag(277), inclusion=trainersanity),
    LocationData("Route 12-N", "Fisherman 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_12_TRAINER_1_ITEM"], EventFlag(276), inclusion=trainersanity),
    LocationData("Route 12-N", "Fisherman 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_12_TRAINER_4_ITEM"], EventFlag(269), inclusion=trainersanity),
    LocationData("Route 12-N", "Fisherman 4", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_12_TRAINER_5_ITEM"], EventFlag(268), inclusion=trainersanity),
    LocationData("Route 12-S", "Rocker", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_12_TRAINER_3_ITEM"], EventFlag(270), inclusion=trainersanity),
    LocationData("Route 12-S", "Jr. Trainer M", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_12_TRAINER_2_ITEM"], EventFlag(272), inclusion=trainersanity),
    LocationData("Route 12-Grass", "Fisherman 5", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_12_TRAINER_6_ITEM"], EventFlag(264), inclusion=trainersanity),
    LocationData("Route 11", "Youngster 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_11_TRAINER_2_ITEM"], EventFlag(286), inclusion=trainersanity),
    LocationData("Route 11", "Gambler 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_11_TRAINER_0_ITEM"], EventFlag(288), inclusion=trainersanity),
    LocationData("Route 11", "Youngster 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_11_TRAINER_9_ITEM"], EventFlag(278), inclusion=trainersanity),
    LocationData("Route 11", "Youngster 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_11_TRAINER_4_ITEM"], EventFlag(284), inclusion=trainersanity),
    LocationData("Route 11", "Gambler 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_11_TRAINER_1_ITEM"], EventFlag(287), inclusion=trainersanity),
    LocationData("Route 11", "Gambler 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_11_TRAINER_6_ITEM"], EventFlag(282), inclusion=trainersanity),
    LocationData("Route 11", "Engineer 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_11_TRAINER_3_ITEM"], EventFlag(285), inclusion=trainersanity),
    LocationData("Route 11", "Engineer 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_11_TRAINER_8_ITEM"], EventFlag(280), inclusion=trainersanity),
    LocationData("Route 11", "Youngster 4", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_11_TRAINER_7_ITEM"], EventFlag(281), inclusion=trainersanity),
    LocationData("Route 11", "Gambler 4", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_11_TRAINER_5_ITEM"], EventFlag(283), inclusion=trainersanity),
    LocationData("Rock Tunnel 1F-NE", "PokeManiac", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCK_TUNNEL_1_TRAINER_3_ITEM"], EventFlag(302), inclusion=trainersanity),
    LocationData("Rock Tunnel 1F-NW", "Hiker 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCK_TUNNEL_1_TRAINER_0_ITEM"], EventFlag(305), inclusion=trainersanity),
    LocationData("Rock Tunnel 1F-NW", "Hiker 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCK_TUNNEL_1_TRAINER_1_ITEM"], EventFlag(304), inclusion=trainersanity),
    LocationData("Rock Tunnel 1F-NW", "Hiker 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCK_TUNNEL_1_TRAINER_2_ITEM"], EventFlag(303), inclusion=trainersanity),
    LocationData("Rock Tunnel 1F-S", "Jr. Trainer F 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCK_TUNNEL_1_TRAINER_4_ITEM"], EventFlag(301), inclusion=trainersanity),
    LocationData("Rock Tunnel 1F-S", "Jr. Trainer F 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCK_TUNNEL_1_TRAINER_6_ITEM"], EventFlag(299), inclusion=trainersanity),
    LocationData("Rock Tunnel 1F-S", "Jr. Trainer F 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCK_TUNNEL_1_TRAINER_5_ITEM"], EventFlag(300), inclusion=trainersanity),
    LocationData("Rock Tunnel B1F-E", "PokeManiac 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCK_TUNNEL_2_TRAINER_7_ITEM"], EventFlag(5), inclusion=trainersanity),
    LocationData("Rock Tunnel B1F-E", "Jr. Trainer F 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCK_TUNNEL_2_TRAINER_5_ITEM"], EventFlag(8), inclusion=trainersanity),
    LocationData("Rock Tunnel B1F-E", "PokeManiac 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCK_TUNNEL_2_TRAINER_3_ITEM"], EventFlag(10), inclusion=trainersanity),
    LocationData("Rock Tunnel B1F-E", "Hiker 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCK_TUNNEL_2_TRAINER_6_ITEM"], EventFlag(7), inclusion=trainersanity),
    LocationData("Rock Tunnel B1F-E", "Hiker 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCK_TUNNEL_2_TRAINER_4_ITEM"], EventFlag(9), inclusion=trainersanity),
    LocationData("Rock Tunnel B1F-W", "Jr. Trainer F 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCK_TUNNEL_2_TRAINER_0_ITEM"], EventFlag(13), inclusion=trainersanity),
    LocationData("Rock Tunnel B1F-W", "Hiker 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCK_TUNNEL_2_TRAINER_1_ITEM"], EventFlag(12), inclusion=trainersanity),
    LocationData("Rock Tunnel B1F-W", "PokeManiac 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROCK_TUNNEL_2_TRAINER_2_ITEM"], EventFlag(11), inclusion=trainersanity),
    LocationData("Route 10-N", "Jr. Trainer F 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_10_TRAINER_3_ITEM"], EventFlag(308), inclusion=trainersanity),
    LocationData("Route 10-C", "PokeManiac 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_10_TRAINER_0_ITEM"], EventFlag(311), inclusion=trainersanity),
    LocationData("Route 10-S", "Jr. Trainer F 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_10_TRAINER_5_ITEM"], EventFlag(306), inclusion=trainersanity),
    LocationData("Route 10-S", "Hiker 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_10_TRAINER_1_ITEM"], EventFlag(310), inclusion=trainersanity),
    LocationData("Route 10-S", "Hiker 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_10_TRAINER_4_ITEM"], EventFlag(307), inclusion=trainersanity),
    LocationData("Route 10-S", "PokeManiac 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_10_TRAINER_2_ITEM"], EventFlag(309), inclusion=trainersanity),
    LocationData("Route 9", "Jr. Trainer F 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_9_TRAINER_0_ITEM"], EventFlag(320), inclusion=trainersanity),
    LocationData("Route 9", "Hiker 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_9_TRAINER_4_ITEM"], EventFlag(316), inclusion=trainersanity),
    LocationData("Route 9", "Jr. Trainer M 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_9_TRAINER_1_ITEM"], EventFlag(319), inclusion=trainersanity),
    LocationData("Route 9", "Bug Catcher 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_9_TRAINER_6_ITEM"], EventFlag(314), inclusion=trainersanity),
    LocationData("Route 9", "Hiker 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_9_TRAINER_7_ITEM"], EventFlag(313), inclusion=trainersanity),
    LocationData("Route 9", "Bug Catcher 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_9_TRAINER_8_ITEM"], EventFlag(312), inclusion=trainersanity),
    LocationData("Route 9", "Jr. Trainer M 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_9_TRAINER_2_ITEM"], EventFlag(318), inclusion=trainersanity),
    LocationData("Route 9", "Hiker 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_9_TRAINER_5_ITEM"], EventFlag(315), inclusion=trainersanity),
    LocationData("Route 9", "Jr. Trainer F 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_9_TRAINER_3_ITEM"], EventFlag(317), inclusion=trainersanity),
    LocationData("Route 8", "Lass 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_8_TRAINER_8_ITEM"], EventFlag(321), inclusion=trainersanity),
    LocationData("Route 8", "Gambler 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_8_TRAINER_7_ITEM"], EventFlag(322), inclusion=trainersanity),
    LocationData("Route 8", "Super Nerd 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_8_TRAINER_2_ITEM"], EventFlag(327), inclusion=trainersanity),
    LocationData("Route 8", "Lass 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_8_TRAINER_3_ITEM"], EventFlag(326), inclusion=trainersanity),
    LocationData("Route 8", "Super Nerd 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_8_TRAINER_4_ITEM"], EventFlag(325), inclusion=trainersanity),
    LocationData("Route 8", "Lass 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_8_TRAINER_5_ITEM"], EventFlag(324), inclusion=trainersanity),
    LocationData("Route 8", "Lass 4", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_8_TRAINER_6_ITEM"], EventFlag(323), inclusion=trainersanity),
    LocationData("Route 8", "Gambler 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_8_TRAINER_1_ITEM"], EventFlag(328), inclusion=trainersanity),
    LocationData("Route 8", "Super Nerd 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_8_TRAINER_0_ITEM"], EventFlag(329), inclusion=trainersanity),
    LocationData("Route 6", "Bug Catcher 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_6_TRAINER_2_ITEM"], EventFlag(333), inclusion=trainersanity),
    LocationData("Route 6", "Jr. Trainer F 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_6_TRAINER_1_ITEM"], EventFlag(334), inclusion=trainersanity),
    LocationData("Route 6", "Jr. Trainer M 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_6_TRAINER_0_ITEM"], EventFlag(335), inclusion=trainersanity),
    LocationData("Route 6", "Bug Catcher 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_6_TRAINER_5_ITEM"], EventFlag(330), inclusion=trainersanity),
    LocationData("Route 6", "Jr. Trainer F 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_6_TRAINER_4_ITEM"], EventFlag(331), inclusion=trainersanity),
    LocationData("Route 6", "Jr. Trainer M 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_6_TRAINER_3_ITEM"], EventFlag(332), inclusion=trainersanity),
    LocationData("Route 4-Lass", "Lass", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_4_TRAINER_0_ITEM"], EventFlag(336), inclusion=trainersanity),
    LocationData("Route 3", "Lass 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_3_TRAINER_2_ITEM"], EventFlag(345), inclusion=trainersanity),
    LocationData("Route 3", "Bug Catcher 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_3_TRAINER_0_ITEM"], EventFlag(347), inclusion=trainersanity),
    LocationData("Route 3", "Youngster 1", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_3_TRAINER_1_ITEM"], EventFlag(346), inclusion=trainersanity),
    LocationData("Route 3", "Bug Catcher 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_3_TRAINER_3_ITEM"], EventFlag(344), inclusion=trainersanity),
    LocationData("Route 3", "Lass 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_3_TRAINER_4_ITEM"], EventFlag(341), inclusion=trainersanity),
    LocationData("Route 3", "Youngster 2", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_3_TRAINER_5_ITEM"], EventFlag(340), inclusion=trainersanity),
    LocationData("Route 3", "Bug Catcher 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_3_TRAINER_6_ITEM"], EventFlag(339), inclusion=trainersanity),
    LocationData("Route 3", "Lass 3", None, rom_addresses["Trainersanity_EVENT_BEAT_ROUTE_3_TRAINER_7_ITEM"], EventFlag(338), inclusion=trainersanity),
    LocationData("Saffron Gym-NE", "Psychic 1", None, rom_addresses["Trainersanity_EVENT_BEAT_SAFFRON_GYM_TRAINER_5_ITEM"], EventFlag(349), inclusion=trainersanity),
    LocationData("Saffron Gym-E", "Psychic 2", None, rom_addresses["Trainersanity_EVENT_BEAT_SAFFRON_GYM_TRAINER_3_ITEM"], EventFlag(351), inclusion=trainersanity),
    LocationData("Saffron Gym-SE", "Psychic 3", None, rom_addresses["Trainersanity_EVENT_BEAT_SAFFRON_GYM_TRAINER_1_ITEM"], EventFlag(360), inclusion=trainersanity),
    LocationData("Saffron Gym-N", "Channeler 1", None, rom_addresses["Trainersanity_EVENT_BEAT_SAFFRON_GYM_TRAINER_0_ITEM"], EventFlag(361), inclusion=trainersanity),
    LocationData("Saffron Gym-NW", "Psychic 4", None, rom_addresses["Trainersanity_EVENT_BEAT_SAFFRON_GYM_TRAINER_6_ITEM"], EventFlag(348), inclusion=trainersanity),
    LocationData("Saffron Gym-W", "Channeler 2", None, rom_addresses["Trainersanity_EVENT_BEAT_SAFFRON_GYM_TRAINER_2_ITEM"], EventFlag(357), inclusion=trainersanity),
    LocationData("Saffron Gym-SW", "Channeler 3", None, rom_addresses["Trainersanity_EVENT_BEAT_SAFFRON_GYM_TRAINER_4_ITEM"], EventFlag(350), inclusion=trainersanity),
    LocationData("Saffron Fighting Dojo", "Blackbelt 1", None, rom_addresses["Trainersanity_EVENT_BEAT_FIGHTING_DOJO_TRAINER_3_ITEM"], EventFlag(363), inclusion=trainersanity),
    LocationData("Saffron Fighting Dojo", "Blackbelt 2", None, rom_addresses["Trainersanity_EVENT_BEAT_FIGHTING_DOJO_TRAINER_1_ITEM"], EventFlag(365), inclusion=trainersanity),
    LocationData("Saffron Fighting Dojo", "Blackbelt 3", None, rom_addresses["Trainersanity_EVENT_BEAT_FIGHTING_DOJO_TRAINER_2_ITEM"], EventFlag(364), inclusion=trainersanity),
    LocationData("Saffron Fighting Dojo", "Blackbelt 4", None, rom_addresses["Trainersanity_EVENT_BEAT_FIGHTING_DOJO_TRAINER_0_ITEM"], EventFlag(366), inclusion=trainersanity),
    LocationData("Fuchsia Gym", "Juggler 1", None, rom_addresses["Trainersanity_EVENT_BEAT_FUCHSIA_GYM_TRAINER_2_ITEM"], EventFlag(380), inclusion=trainersanity),
    LocationData("Fuchsia Gym", "Juggler 2", None, rom_addresses["Trainersanity_EVENT_BEAT_FUCHSIA_GYM_TRAINER_0_ITEM"], EventFlag(382), inclusion=trainersanity),
    LocationData("Fuchsia Gym", "Juggler 3", None, rom_addresses["Trainersanity_EVENT_BEAT_FUCHSIA_GYM_TRAINER_1_ITEM"], EventFlag(381), inclusion=trainersanity),
    LocationData("Fuchsia Gym", "Tamer 1", None, rom_addresses["Trainersanity_EVENT_BEAT_FUCHSIA_GYM_TRAINER_4_ITEM"], EventFlag(378), inclusion=trainersanity),
    LocationData("Fuchsia Gym", "Tamer 2", None, rom_addresses["Trainersanity_EVENT_BEAT_FUCHSIA_GYM_TRAINER_3_ITEM"], EventFlag(379), inclusion=trainersanity),
    LocationData("Fuchsia Gym", "Juggler 4", None, rom_addresses["Trainersanity_EVENT_BEAT_FUCHSIA_GYM_TRAINER_5_ITEM"], EventFlag(377), inclusion=trainersanity),
    LocationData("Celadon Gym", "Lass 1", None, rom_addresses["Trainersanity_EVENT_BEAT_CELADON_GYM_TRAINER_0_ITEM"], EventFlag(391), inclusion=trainersanity),
    LocationData("Celadon Gym", "Beauty 1", None, rom_addresses["Trainersanity_EVENT_BEAT_CELADON_GYM_TRAINER_1_ITEM"], EventFlag(390), inclusion=trainersanity),
    LocationData("Celadon Gym", "Beauty 2", None, rom_addresses["Trainersanity_EVENT_BEAT_CELADON_GYM_TRAINER_3_ITEM"], EventFlag(388), inclusion=trainersanity),
    LocationData("Celadon Gym", "Jr. Trainer F", None, rom_addresses["Trainersanity_EVENT_BEAT_CELADON_GYM_TRAINER_2_ITEM"], EventFlag(389), inclusion=trainersanity),
    LocationData("Celadon Gym-C", "Lass 2", None, rom_addresses["Trainersanity_EVENT_BEAT_CELADON_GYM_TRAINER_4_ITEM"], EventFlag(387), inclusion=trainersanity),
    LocationData("Celadon Gym-C", "Cool Trainer F", None, rom_addresses["Trainersanity_EVENT_BEAT_CELADON_GYM_TRAINER_6_ITEM"], EventFlag(385), inclusion=trainersanity),
    LocationData("Celadon Gym-C", "Beauty 3", None, rom_addresses["Trainersanity_EVENT_BEAT_CELADON_GYM_TRAINER_5_ITEM"], EventFlag(386), inclusion=trainersanity),
    LocationData("Vermilion Gym", "Sailor", None, rom_addresses["Trainersanity_EVENT_BEAT_VERMILION_GYM_TRAINER_2_ITEM"], EventFlag(394), inclusion=trainersanity),
    LocationData("Vermilion Gym", "Rocker", None, rom_addresses["Trainersanity_EVENT_BEAT_VERMILION_GYM_TRAINER_1_ITEM"], EventFlag(395), inclusion=trainersanity),
    LocationData("Vermilion Gym", "Gentleman", None, rom_addresses["Trainersanity_EVENT_BEAT_VERMILION_GYM_TRAINER_0_ITEM"], EventFlag(400), inclusion=trainersanity),
    LocationData("Pokemon Tower 3F", "Channeler 1", None, rom_addresses["Trainersanity_EVENT_BEAT_POKEMONTOWER_3_TRAINER_0_ITEM"], EventFlag(417), inclusion=trainersanity),
    LocationData("Pokemon Tower 3F", "Channeler 2", None, rom_addresses["Trainersanity_EVENT_BEAT_POKEMONTOWER_3_TRAINER_1_ITEM"], EventFlag(416), inclusion=trainersanity),
    LocationData("Pokemon Tower 3F", "Channeler 3", None, rom_addresses["Trainersanity_EVENT_BEAT_POKEMONTOWER_3_TRAINER_2_ITEM"], EventFlag(415), inclusion=trainersanity),
    LocationData("Pokemon Tower 4F", "Channeler 1", None, rom_addresses["Trainersanity_EVENT_BEAT_POKEMONTOWER_4_TRAINER_1_ITEM"], EventFlag(413), inclusion=trainersanity),
    LocationData("Pokemon Tower 4F", "Channeler 2", None, rom_addresses["Trainersanity_EVENT_BEAT_POKEMONTOWER_4_TRAINER_2_ITEM"], EventFlag(412), inclusion=trainersanity),
    LocationData("Pokemon Tower 4F", "Channeler 3", None, rom_addresses["Trainersanity_EVENT_BEAT_POKEMONTOWER_4_TRAINER_0_ITEM"], EventFlag(414), inclusion=trainersanity),
    LocationData("Pokemon Tower 5F", "Channeler 1", None, rom_addresses["Trainersanity_EVENT_BEAT_POKEMONTOWER_5_TRAINER_1_ITEM"], EventFlag(410), inclusion=trainersanity),
    LocationData("Pokemon Tower 5F", "Channeler 2", None, rom_addresses["Trainersanity_EVENT_BEAT_POKEMONTOWER_5_TRAINER_0_ITEM"], EventFlag(411), inclusion=trainersanity),
    LocationData("Pokemon Tower 5F", "Channeler 3", None, rom_addresses["Trainersanity_EVENT_BEAT_POKEMONTOWER_5_TRAINER_2_ITEM"], EventFlag(409), inclusion=trainersanity),
    LocationData("Pokemon Tower 5F", "Channeler 4", None, rom_addresses["Trainersanity_EVENT_BEAT_POKEMONTOWER_5_TRAINER_3_ITEM"], EventFlag(408), inclusion=trainersanity),
    LocationData("Pokemon Tower 6F", "Channeler 1", None, rom_addresses["Trainersanity_EVENT_BEAT_POKEMONTOWER_6_TRAINER_0_ITEM"], EventFlag(407), inclusion=trainersanity),
    LocationData("Pokemon Tower 6F", "Channeler 2", None, rom_addresses["Trainersanity_EVENT_BEAT_POKEMONTOWER_6_TRAINER_2_ITEM"], EventFlag(405), inclusion=trainersanity),
    LocationData("Pokemon Tower 6F", "Channeler 3", None, rom_addresses["Trainersanity_EVENT_BEAT_POKEMONTOWER_6_TRAINER_1_ITEM"], EventFlag(406), inclusion=trainersanity),
    LocationData("Pokemon Tower 7F", "Rocket 1", None, rom_addresses["Trainersanity_EVENT_BEAT_POKEMONTOWER_7_TRAINER_0_ITEM"], EventFlag(403), inclusion=trainersanity),
    LocationData("Pokemon Tower 7F", "Rocket 2", None, rom_addresses["Trainersanity_EVENT_BEAT_POKEMONTOWER_7_TRAINER_1_ITEM"], EventFlag(402), inclusion=trainersanity),
    LocationData("Pokemon Tower 7F", "Rocket 3", None, rom_addresses["Trainersanity_EVENT_BEAT_POKEMONTOWER_7_TRAINER_2_ITEM"], EventFlag(401), inclusion=trainersanity),
    LocationData("Cerulean Gym", "Swimmer", None, rom_addresses["Trainersanity_EVENT_BEAT_CERULEAN_GYM_TRAINER_1_ITEM"], EventFlag(420), inclusion=trainersanity),
    LocationData("Cerulean Gym", "Jr. Trainer F", None, rom_addresses["Trainersanity_EVENT_BEAT_CERULEAN_GYM_TRAINER_0_ITEM"], EventFlag(421), inclusion=trainersanity),
    LocationData("Pewter Gym", "Jr. Trainer M", None, rom_addresses["Trainersanity_EVENT_BEAT_PEWTER_GYM_TRAINER_0_ITEM"], EventFlag(434), inclusion=trainersanity),
    LocationData("Viridian Gym", "Tamer 1", None, rom_addresses["Trainersanity_EVENT_BEAT_VIRIDIAN_GYM_TRAINER_6_ITEM"], EventFlag(436), inclusion=trainersanity),
    LocationData("Viridian Gym", "Blackbelt 1", None, rom_addresses["Trainersanity_EVENT_BEAT_VIRIDIAN_GYM_TRAINER_3_ITEM"], EventFlag(439), inclusion=trainersanity),
    LocationData("Viridian Gym", "Cooltrainer M 1", None, rom_addresses["Trainersanity_EVENT_BEAT_VIRIDIAN_GYM_TRAINER_7_ITEM"], EventFlag(435), inclusion=trainersanity),
    LocationData("Viridian Gym", "Cooltrainer M 2", None, rom_addresses["Trainersanity_EVENT_BEAT_VIRIDIAN_GYM_TRAINER_0_ITEM"], EventFlag(446), inclusion=trainersanity),
    LocationData("Viridian Gym", "Blackbelt 2", None, rom_addresses["Trainersanity_EVENT_BEAT_VIRIDIAN_GYM_TRAINER_1_ITEM"], EventFlag(445), inclusion=trainersanity),
    LocationData("Viridian Gym", "Tamer 2", None, rom_addresses["Trainersanity_EVENT_BEAT_VIRIDIAN_GYM_TRAINER_2_ITEM"], EventFlag(440), inclusion=trainersanity),
    LocationData("Viridian Gym", "Blackbelt 3", None, rom_addresses["Trainersanity_EVENT_BEAT_VIRIDIAN_GYM_TRAINER_5_ITEM"], EventFlag(437), inclusion=trainersanity),
    LocationData("Viridian Gym", "Cooltrainer M 3", None, rom_addresses["Trainersanity_EVENT_BEAT_VIRIDIAN_GYM_TRAINER_4_ITEM"], EventFlag(438), inclusion=trainersanity),
    LocationData("Victory Road 1F", "Cooltrainer F", None, rom_addresses["Trainersanity_EVENT_BEAT_VICTORY_ROAD_1_TRAINER_0_ITEM"], EventFlag(15), inclusion=trainersanity),
    LocationData("Victory Road 1F", "Cooltrainer M", None, rom_addresses["Trainersanity_EVENT_BEAT_VICTORY_ROAD_1_TRAINER_1_ITEM"], EventFlag(14), inclusion=trainersanity),
    LocationData("Victory Road 2F-C", "Blackbelt", None, rom_addresses["Trainersanity_EVENT_BEAT_VICTORY_ROAD_2_TRAINER_0_ITEM"], EventFlag(162), inclusion=trainersanity),
    LocationData("Victory Road 2F-C", "Juggler 1", None, rom_addresses["Trainersanity_EVENT_BEAT_VICTORY_ROAD_2_TRAINER_1_ITEM"], EventFlag(161), inclusion=trainersanity),
    LocationData("Victory Road 2F-C", "Tamer", None, rom_addresses["Trainersanity_EVENT_BEAT_VICTORY_ROAD_2_TRAINER_2_ITEM"], EventFlag(160), inclusion=trainersanity),
    LocationData("Victory Road 2F-C", "Juggler 2", None, rom_addresses["Trainersanity_EVENT_BEAT_VICTORY_ROAD_2_TRAINER_4_ITEM"], EventFlag(158), inclusion=trainersanity),
    LocationData("Victory Road 2F-NW", "PokeManiac", None, rom_addresses["Trainersanity_EVENT_BEAT_VICTORY_ROAD_2_TRAINER_3_ITEM"], EventFlag(159), inclusion=trainersanity),
    LocationData("Victory Road 3F", "Cooltrainer M 1", None, rom_addresses["Trainersanity_EVENT_BEAT_VICTORY_ROAD_3_TRAINER_0_ITEM"], EventFlag(103), inclusion=trainersanity),
    LocationData("Victory Road 3F-S", "Cooltrainer F 1", None, rom_addresses["Trainersanity_EVENT_BEAT_VICTORY_ROAD_3_TRAINER_3_ITEM"], EventFlag(100), inclusion=trainersanity),
    LocationData("Victory Road 3F-S", "Cooltrainer M 2", None, rom_addresses["Trainersanity_EVENT_BEAT_VICTORY_ROAD_3_TRAINER_2_ITEM"], EventFlag(101), inclusion=trainersanity),
    LocationData("Victory Road 3F", "Cooltrainer F 2", None, rom_addresses["Trainersanity_EVENT_BEAT_VICTORY_ROAD_3_TRAINER_1_ITEM"], EventFlag(102), inclusion=trainersanity),
    LocationData("Indigo Plateau Lorelei's Room", "Lorelei", None, rom_addresses["Trainersanity_EVENT_BEAT_LORELEIS_ROOM_TRAINER_0_ITEM"], EventFlag(21), inclusion=trainersanity),
    LocationData("Indigo Plateau Bruno's Room", "Bruno", None, rom_addresses["Trainersanity_EVENT_BEAT_BRUNOS_ROOM_TRAINER_0_ITEM"], EventFlag(20), inclusion=trainersanity),
    LocationData("Indigo Plateau Agatha's Room", "Agatha", None, rom_addresses["Trainersanity_EVENT_BEAT_AGATHAS_ROOM_TRAINER_0_ITEM"], EventFlag(19), inclusion=trainersanity),
    LocationData("Indigo Plateau Lance's Room", "Lance", None, rom_addresses["Trainersanity_EVENT_BEAT_LANCES_ROOM_TRAINER_0_ITEM"], EventFlag(18), inclusion=trainersanity),
    LocationData("Cinnabar Gym", "Burglar 1", None, rom_addresses["Trainersanity_EVENT_BEAT_CINNABAR_GYM_TRAINER_A_ITEM"], EventFlag(374), inclusion=trainersanity),
    LocationData("Cinnabar Gym", "Super Nerd 1", None, rom_addresses["Trainersanity_EVENT_BEAT_CINNABAR_GYM_TRAINER_B_ITEM"], EventFlag(373), inclusion=trainersanity),
    LocationData("Cinnabar Gym", "Super Nerd 2", None, rom_addresses["Trainersanity_EVENT_BEAT_CINNABAR_GYM_TRAINER_2_ITEM"], EventFlag(372), inclusion=trainersanity),
    LocationData("Cinnabar Gym", "Burglar 2", None, rom_addresses["Trainersanity_EVENT_BEAT_CINNABAR_GYM_TRAINER_3_ITEM"], EventFlag(371), inclusion=trainersanity),
    LocationData("Cinnabar Gym", "Super Nerd 3", None, rom_addresses["Trainersanity_EVENT_BEAT_CINNABAR_GYM_TRAINER_4_ITEM"], EventFlag(370), inclusion=trainersanity),
    LocationData("Cinnabar Gym", "Burglar 3", None, rom_addresses["Trainersanity_EVENT_BEAT_CINNABAR_GYM_TRAINER_5_ITEM"], EventFlag(369), inclusion=trainersanity),
    LocationData("Cinnabar Gym", "Super Nerd 4", None, rom_addresses["Trainersanity_EVENT_BEAT_CINNABAR_GYM_TRAINER_6_ITEM"], EventFlag(368), inclusion=trainersanity),

    LocationData("Celadon Prize Corner", "Item Prize 1", "TM23 Dragon Rage", rom_addresses["Prize_Item_A"], EventFlag(0x69a), inclusion=prizesanity),
    LocationData("Celadon Prize Corner", "Item Prize 2", "TM15 Hyper Beam", rom_addresses["Prize_Item_B"], EventFlag(0x69B), inclusion=prizesanity),
    LocationData("Celadon Prize Corner", "Item Prize 3", "TM50 Substitute", rom_addresses["Prize_Item_C"], EventFlag(0x69C), inclusion=prizesanity),

    LocationData("Celadon Game Corner", "West Gambler's Gift", "10 Coins", rom_addresses["Event_Game_Corner_Gift_A"], EventFlag(0x1ba)),
    LocationData("Celadon Game Corner", "Center Gambler's Gift", "20 Coins", rom_addresses["Event_Game_Corner_Gift_C"], EventFlag(0x1bc)),
    LocationData("Celadon Game Corner", "East Gambler's Gift", "20 Coins", rom_addresses["Event_Game_Corner_Gift_B"], EventFlag(0x1bb)),

    LocationData("Celadon Game Corner", "Hidden Item Northwest By Counter", "10 Coins", rom_addresses["Hidden_Item_Game_Corner_1"], Hidden(54), inclusion=hidden_items),
    LocationData("Celadon Game Corner", "Hidden Item Southwest Corner", "10 Coins", rom_addresses["Hidden_Item_Game_Corner_2"], Hidden(55), inclusion=hidden_items),
    LocationData("Celadon Game Corner", "Hidden Item Near Rumor Man", "20 Coins", rom_addresses["Hidden_Item_Game_Corner_3"], Hidden(56), inclusion=hidden_items),
    LocationData("Celadon Game Corner", "Hidden Item Near Speculating Woman", "10 Coins", rom_addresses["Hidden_Item_Game_Corner_4"], Hidden(57), inclusion=hidden_items),
    LocationData("Celadon Game Corner", "Hidden Item Near West Gifting Gambler", "10 Coins", rom_addresses["Hidden_Item_Game_Corner_5"], Hidden(58), inclusion=hidden_items),
    LocationData("Celadon Game Corner", "Hidden Item Near Wonderful Time Woman", "20 Coins", rom_addresses["Hidden_Item_Game_Corner_6"], Hidden(59), inclusion=hidden_items),
    LocationData("Celadon Game Corner", "Hidden Item Near Failing Gym Information Guy", "10 Coins", rom_addresses["Hidden_Item_Game_Corner_7"], Hidden(60), inclusion=hidden_items),
    LocationData("Celadon Game Corner", "Hidden Item Near East Gifting Gambler", "10 Coins", rom_addresses["Hidden_Item_Game_Corner_8"], Hidden(61), inclusion=hidden_items),
    LocationData("Celadon Game Corner", "Hidden Item Near Hooked Guy", "10 Coins", rom_addresses["Hidden_Item_Game_Corner_9"], Hidden(62), inclusion=hidden_items),
    LocationData("Celadon Game Corner", "Hidden Item at End of Horizontal Machine Row", "20 Coins", rom_addresses["Hidden_Item_Game_Corner_10"], Hidden(63), inclusion=hidden_items),
    LocationData("Celadon Game Corner", "Hidden Item in Front of Horizontal Machine Row", "100 Coins", rom_addresses["Hidden_Item_Game_Corner_11"], Hidden(64), inclusion=hidden_items),

    *[LocationData("Pokedex", mon, ball, rom_addresses["Dexsanity_Items"] + i, DexSanityFlag(i), type="Item",
                   inclusion=dexsanity) for (mon, i, ball) in zip(poke_data.pokemon_data.keys(), range(0, 152),
                                                                  ["Poke Ball", "Great Ball", "Ultra Ball"] * 51)],

    LocationData("Silph Co 1F", "Receptionist", "Card Key 2F", rom_addresses["Event_SKC1F"], EventFlag(0x1c0), inclusion=split_card_key),
    LocationData("Silph Co 4F-W", "Hostage", "Card Key 4F", rom_addresses["Event_SKC4F"], EventFlag(0x1c1), inclusion=split_card_key),
    LocationData("Silph Co 5F", "Hostage", "Card Key 5F", rom_addresses["Event_SKC5F"], EventFlag(0x1c2), inclusion=split_card_key),
    LocationData("Silph Co 6F", "Hostage", "Card Key 6F", rom_addresses["Event_SKC6F"], EventFlag(0x1c3), inclusion=split_card_key),
    LocationData("Silph Co 7F", "Hostage", "Card Key 7F", rom_addresses["Event_SKC7F"], EventFlag(0x1c4), inclusion=split_card_key),
    LocationData("Silph Co 8F-W", "Hostage", "Card Key 8F", rom_addresses["Event_SKC8F"], EventFlag(0x1c5), inclusion=split_card_key),
    LocationData("Silph Co 9F-SW", "Nurse", "Card Key 9F", rom_addresses["Event_SKC9F"], EventFlag(0x1c6), inclusion=split_card_key),
    LocationData("Silph Co 10F-SE", "Hostage", "Card Key 10F", rom_addresses["Event_SKC10F"], EventFlag(0x1c7), inclusion=split_card_key),
    LocationData("Silph Co 11F-C", "Secretary", "Card Key 11F", rom_addresses["Event_SKC11F"], EventFlag(0x1c8), inclusion=split_card_key),

    LocationData("Celadon Game Corner", "", "Game Corner", event=True),
    LocationData("Cinnabar Island", "", "Cinnabar Island", event=True),
    LocationData("Cinnabar Lab", "", "Cinnabar Lab", event=True),
    LocationData("Mt Moon B2F", "Mt Moon Fossils", "Mt Moon Fossils", event=True),
    LocationData("Celadon Department Store 4F", "Buy Poke Doll", "Buy Poke Doll", event=True),
    LocationData("Celadon Department Store 4F", "Buy Fire Stone", "Fire Stone", event=True, inclusion=not_stonesanity),
    LocationData("Celadon Department Store 4F", "Buy Water Stone", "Water Stone", event=True, inclusion=not_stonesanity),
    LocationData("Celadon Department Store 4F", "Buy Thunder Stone", "Thunder Stone", event=True, inclusion=not_stonesanity),
    LocationData("Celadon Department Store 4F", "Buy Leaf Stone", "Leaf Stone", event=True, inclusion=not_stonesanity),
    LocationData("Celadon Department Store Roof", "Vending Machines", "Vending Machine Drinks", event=True),
    LocationData("Pewter Gym", "Defeat Brock", "Defeat Brock", event=True),
    LocationData("Cerulean Gym", "Defeat Misty", "Defeat Misty", event=True),
    LocationData("Vermilion Gym", "Defeat Lt. Surge", "Defeat Lt. Surge", event=True),
    LocationData("Celadon Gym-C", "Defeat Erika", "Defeat Erika", event=True),
    LocationData("Fuchsia Gym", "Defeat Koga", "Defeat Koga", event=True),
    LocationData("Cinnabar Gym", "Defeat Blaine", "Defeat Blaine", event=True),
    LocationData("Saffron Gym-C", "Defeat Sabrina", "Defeat Sabrina", event=True),
    LocationData("Viridian Gym", "Defeat Viridian Gym Giovanni", "Defeat Viridian Gym Giovanni", event=True),
    LocationData("Bill's House", "Help Bill", "Help Bill", event=True),
    LocationData("Victory Road 3F-S", "Victory Road Boulder", "Victory Road Boulder", event=True),
    LocationData("Indigo Plateau Champion's Room", "Become Champion", "Become Champion", event=True),
    LocationData("Pokemon Tower 7F", "Fuji Saved", "Fuji Saved", event=True),
    LocationData("Silph Co 11F-C", "Silph Co Liberated", "Silph Co Liberated", event=True),
    LocationData("Seafoam Islands 1F", "Seafoam Exit Boulder 1", "Seafoam Exit Boulder", event=True),
    LocationData("Seafoam Islands 1F", "Seafoam Exit Boulder 2", "Seafoam Exit Boulder", event=True),
    LocationData("Seafoam Islands B1F", "Seafoam Exit Boulder 1", "Seafoam Exit Boulder", event=True),
    LocationData("Seafoam Islands B1F-NE", "Seafoam Exit Boulder 2", "Seafoam Exit Boulder", event=True),
    LocationData("Seafoam Islands B2F-NW", "Seafoam Exit Boulder 1", "Seafoam Exit Boulder", event=True),
    LocationData("Seafoam Islands B2F-NE", "Seafoam Exit Boulder 2", "Seafoam Exit Boulder", event=True),
    LocationData("Seafoam Islands B3F", "Seafoam Boss Boulders", "Seafoam Boss Boulders", event=True),

    LocationData("Pallet/Viridian Fishing", "Super Rod Pokemon - 1", "Tentacool", rom_addresses["Wild_Super_Rod_A"] + 1, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Pallet/Viridian Fishing", "Super Rod Pokemon - 2", "Poliwag", rom_addresses["Wild_Super_Rod_A"] + 3, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Route 22 Fishing", "Super Rod Pokemon - 1", "Goldeen", rom_addresses["Wild_Super_Rod_B"] + 1, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Route 22 Fishing", "Super Rod Pokemon - 2", "Poliwag", rom_addresses["Wild_Super_Rod_B"] + 3, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Route 24/25/Cerulean/Cerulean Gym Fishing", "Super Rod Pokemon - 1", "Psyduck", rom_addresses["Wild_Super_Rod_C"] + 1, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Route 24/25/Cerulean/Cerulean Gym Fishing", "Super Rod Pokemon - 2", "Goldeen", rom_addresses["Wild_Super_Rod_C"] + 3, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Route 24/25/Cerulean/Cerulean Gym Fishing", "Super Rod Pokemon - 3", "Krabby", rom_addresses["Wild_Super_Rod_C"] + 5, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Route 6/11/Vermilion/Dock Fishing", "Super Rod Pokemon - 1", "Krabby", rom_addresses["Wild_Super_Rod_D"] + 1, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Route 6/11/Vermilion/Dock Fishing", "Super Rod Pokemon - 2", "Shellder", rom_addresses["Wild_Super_Rod_D"] + 3, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Route 10/Celadon Fishing", "Super Rod Pokemon - 1", "Poliwhirl", rom_addresses["Wild_Super_Rod_E"] + 1, None,
                 event=True, type="Wild Encounter"),
    LocationData("Route 10/Celadon Fishing", "Super Rod Pokemon - 2", "Slowpoke", rom_addresses["Wild_Super_Rod_E"] + 3, None,
                 event=True, type="Wild Encounter"),
    LocationData("Safari Zone Fishing", "Super Rod Pokemon - 1", "Dratini", rom_addresses["Wild_Super_Rod_F"] + 1,
                 None, event=True, type="Wild Encounter"),
    LocationData("Safari Zone Fishing", "Super Rod Pokemon - 2", "Krabby", rom_addresses["Wild_Super_Rod_F"] + 3,
                 None, event=True, type="Wild Encounter"),
    LocationData("Safari Zone Fishing", "Super Rod Pokemon - 3", "Psyduck", rom_addresses["Wild_Super_Rod_F"] + 5,
                 None, event=True, type="Wild Encounter"),
    LocationData("Safari Zone Fishing", "Super Rod Pokemon - 4", "Slowpoke", rom_addresses["Wild_Super_Rod_F"] + 7,
                 None, event=True, type="Wild Encounter"),
    LocationData("Route 12/13/17/18 Fishing", "Super Rod Pokemon - 1", "Tentacool", rom_addresses["Wild_Super_Rod_G"] + 1,
                 None, event=True, type="Wild Encounter"),
    LocationData("Route 12/13/17/18 Fishing", "Super Rod Pokemon - 2", "Krabby", rom_addresses["Wild_Super_Rod_G"] + 3,
                 None, event=True, type="Wild Encounter"),
    LocationData("Route 12/13/17/18 Fishing", "Super Rod Pokemon - 3", "Goldeen", rom_addresses["Wild_Super_Rod_G"] + 5,
                 None, event=True, type="Wild Encounter"),
    LocationData("Route 12/13/17/18 Fishing", "Super Rod Pokemon - 4", "Magikarp", rom_addresses["Wild_Super_Rod_G"] + 7,
                 None, event=True, type="Wild Encounter"),
    LocationData("Sea Routes/Cinnabar/Seafoam Fishing", "Super Rod Pokemon - 1", "Staryu", rom_addresses["Wild_Super_Rod_H"] + 1,
                 None, event=True, type="Wild Encounter"),
    LocationData("Sea Routes/Cinnabar/Seafoam Fishing", "Super Rod Pokemon - 2", "Horsea", rom_addresses["Wild_Super_Rod_H"] + 3,
                 None, event=True, type="Wild Encounter"),
    LocationData("Sea Routes/Cinnabar/Seafoam Fishing", "Super Rod Pokemon - 3", "Shellder", rom_addresses["Wild_Super_Rod_H"] + 5,
                 None, event=True, type="Wild Encounter"),
    LocationData("Sea Routes/Cinnabar/Seafoam Fishing", "Super Rod Pokemon - 4", "Goldeen", rom_addresses["Wild_Super_Rod_H"] + 7,
                 None, event=True, type="Wild Encounter"),
    LocationData("Route 23/Cerulean Cave Fishing", "Super Rod Pokemon - 1", "Slowbro", rom_addresses["Wild_Super_Rod_I"] + 1,
                 None, event=True, type="Wild Encounter"),
    LocationData("Route 23/Cerulean Cave Fishing", "Super Rod Pokemon - 2", "Seaking", rom_addresses["Wild_Super_Rod_I"] + 3,
                 None, event=True, type="Wild Encounter"),
    LocationData("Route 23/Cerulean Cave Fishing", "Super Rod Pokemon - 3", "Kingler", rom_addresses["Wild_Super_Rod_I"] + 5,
                 None, event=True, type="Wild Encounter"),
    LocationData("Route 23/Cerulean Cave Fishing", "Super Rod Pokemon - 4", "Seadra", rom_addresses["Wild_Super_Rod_I"] + 7,
                 None, event=True, type="Wild Encounter"),
    LocationData("Fuchsia Fishing", "Super Rod Pokemon - 1", "Seaking", rom_addresses["Wild_Super_Rod_J"] + 1,
                 None, event=True, type="Wild Encounter"),
    LocationData("Fuchsia Fishing", "Super Rod Pokemon - 2", "Krabby", rom_addresses["Wild_Super_Rod_J"] + 3,
                 None, event=True, type="Wild Encounter"),
    LocationData("Fuchsia Fishing", "Super Rod Pokemon - 3", "Goldeen", rom_addresses["Wild_Super_Rod_J"] + 5,
                 None, event=True, type="Wild Encounter"),
    LocationData("Fuchsia Fishing", "Super Rod Pokemon - 4", "Magikarp", rom_addresses["Wild_Super_Rod_J"] + 7,
                 None, event=True, type="Wild Encounter"),
    LocationData("Route 1", "Wild Pokemon - 1", "Pidgey", rom_addresses["Wild_Route1"] + 1, None, event=True,
                 type="Wild Encounter", level=3),
    LocationData("Route 1", "Wild Pokemon - 2", "Rattata", rom_addresses["Wild_Route1"] + 3, None, event=True,
                 type="Wild Encounter", level=3),
    LocationData("Route 1", "Wild Pokemon - 3", "Rattata", rom_addresses["Wild_Route1"] + 5, None, event=True,
                 type="Wild Encounter", level=3),
    LocationData("Route 1", "Wild Pokemon - 4", "Rattata", rom_addresses["Wild_Route1"] + 7, None, event=True,
                 type="Wild Encounter", level=2),
    LocationData("Route 1", "Wild Pokemon - 5", "Pidgey", rom_addresses["Wild_Route1"] + 9, None, event=True,
                 type="Wild Encounter", level=2),
    LocationData("Route 1", "Wild Pokemon - 6", "Pidgey", rom_addresses["Wild_Route1"] + 11, None, event=True,
                 type="Wild Encounter", level=3),
    LocationData("Route 1", "Wild Pokemon - 7", "Pidgey", rom_addresses["Wild_Route1"] + 13, None, event=True,
                 type="Wild Encounter", level=3),
    LocationData("Route 1", "Wild Pokemon - 8", "Rattata", rom_addresses["Wild_Route1"] + 15, None, event=True,
                 type="Wild Encounter", level=4),
    LocationData("Route 1", "Wild Pokemon - 9", "Pidgey", rom_addresses["Wild_Route1"] + 17, None, event=True,
                 type="Wild Encounter", level=4),
    LocationData("Route 1", "Wild Pokemon - 10", "Pidgey", rom_addresses["Wild_Route1"] + 19, None, event=True,
                 type="Wild Encounter", level=5),
    LocationData("Route 2-Grass", "Wild Pokemon - 1", "Rattata", rom_addresses["Wild_Route2"] + 1, None, event=True,
                 type="Wild Encounter", level=3),
    LocationData("Route 2-Grass", "Wild Pokemon - 2", "Pidgey", rom_addresses["Wild_Route2"] + 3, None, event=True,
                 type="Wild Encounter", level=3),
    LocationData("Route 2-Grass", "Wild Pokemon - 3", "Pidgey", rom_addresses["Wild_Route2"] + 5, None, event=True,
                 type="Wild Encounter", level=4),
    LocationData("Route 2-Grass", "Wild Pokemon - 4", "Rattata", rom_addresses["Wild_Route2"] + 7, None, event=True,
                 type="Wild Encounter", level=4),
    LocationData("Route 2-Grass", "Wild Pokemon - 5", "Pidgey", rom_addresses["Wild_Route2"] + 9, None, event=True,
                 type="Wild Encounter", level=5),
    LocationData("Route 2-Grass", "Wild Pokemon - 6", ["Weedle", "Caterpie"], rom_addresses["Wild_Route2"] + 11, None,
                 event=True, type="Wild Encounter", level=3),
    LocationData("Route 2-Grass", "Wild Pokemon - 7", "Rattata", rom_addresses["Wild_Route2"] + 13, None, event=True,
                 type="Wild Encounter", level=2),
    LocationData("Route 2-Grass", "Wild Pokemon - 8", "Rattata", rom_addresses["Wild_Route2"] + 15, None, event=True,
                 type="Wild Encounter", level=5),
    LocationData("Route 2-Grass", "Wild Pokemon - 9", ["Weedle", "Caterpie"], rom_addresses["Wild_Route2"] + 17, None,
                 event=True, type="Wild Encounter", level=4),
    LocationData("Route 2-Grass", "Wild Pokemon - 10", ["Weedle", "Caterpie"], rom_addresses["Wild_Route2"] + 19, None,
                 event=True, type="Wild Encounter", level=5),
    LocationData("Route 22", "Wild Pokemon - 1", "Rattata", rom_addresses["Wild_Route22"] + 1, None, event=True,
                 type="Wild Encounter", level=3),
    LocationData("Route 22", "Wild Pokemon - 2", ["Nidoran M", "Nidoran F"], rom_addresses["Wild_Route22"] + 3,
                 None, event=True, type="Wild Encounter", level=3),
    LocationData("Route 22", "Wild Pokemon - 3", "Rattata", rom_addresses["Wild_Route22"] + 5, None, event=True,
                 type="Wild Encounter", level=4),
    LocationData("Route 22", "Wild Pokemon - 4", ["Nidoran M", "Nidoran F"], rom_addresses["Wild_Route22"] + 7,
                 None, event=True, type="Wild Encounter", level=4),
    LocationData("Route 22", "Wild Pokemon - 5", "Rattata", rom_addresses["Wild_Route22"] + 9, None, event=True,
                 type="Wild Encounter", level=2),
    LocationData("Route 22", "Wild Pokemon - 6", ["Nidoran M", "Nidoran F"], rom_addresses["Wild_Route22"] + 11,
                 None, event=True, type="Wild Encounter", level=2),
    LocationData("Route 22", "Wild Pokemon - 7", "Spearow", rom_addresses["Wild_Route22"] + 13, None, event=True,
                 type="Wild Encounter", level=3),
    LocationData("Route 22", "Wild Pokemon - 8", "Spearow", rom_addresses["Wild_Route22"] + 15, None, event=True,
                 type="Wild Encounter", level=5),
    LocationData("Route 22", "Wild Pokemon - 9", ["Nidoran F", "Nidoran M"], rom_addresses["Wild_Route22"] + 17,
                 None, event=True, type="Wild Encounter", level=3),
    LocationData("Route 22", "Wild Pokemon - 10", ["Nidoran F", "Nidoran M"], rom_addresses["Wild_Route22"] + 19,
                 None, event=True, type="Wild Encounter", level=4),
    LocationData("Viridian Forest", "Wild Pokemon - 1", ["Weedle", "Caterpie"],
                 rom_addresses["Wild_ViridianForest"] + 1, None, event=True, type="Wild Encounter", level=4),
    LocationData("Viridian Forest", "Wild Pokemon - 2", ["Kakuna", "Metapod"],
                 rom_addresses["Wild_ViridianForest"] + 3, None, event=True, type="Wild Encounter", level=5),
    LocationData("Viridian Forest", "Wild Pokemon - 3", ["Weedle", "Caterpie"],
                 rom_addresses["Wild_ViridianForest"] + 5, None, event=True, type="Wild Encounter", level=3),
    LocationData("Viridian Forest", "Wild Pokemon - 4", ["Weedle", "Caterpie"],
                 rom_addresses["Wild_ViridianForest"] + 7, None, event=True, type="Wild Encounter", level=5),
    LocationData("Viridian Forest", "Wild Pokemon - 5", ["Kakuna", "Metapod"],
                 rom_addresses["Wild_ViridianForest"] + 9, None, event=True, type="Wild Encounter", level=4),
    LocationData("Viridian Forest", "Wild Pokemon - 6", ["Kakuna", "Metapod"],
                 rom_addresses["Wild_ViridianForest"] + 11, None, event=True, type="Wild Encounter", level=6),
    LocationData("Viridian Forest", "Wild Pokemon - 7", ["Metapod", "Kakuna"],
                 rom_addresses["Wild_ViridianForest"] + 13, None, event=True, type="Wild Encounter", level=4),
    LocationData("Viridian Forest", "Wild Pokemon - 8", ["Caterpie", "Weedle"],
                 rom_addresses["Wild_ViridianForest"] + 15,
                 None, event=True, type="Wild Encounter", level=3),
    LocationData("Viridian Forest", "Wild Pokemon - 9", "Pikachu", rom_addresses["Wild_ViridianForest"] + 17, None,
                 event=True, type="Wild Encounter", level=3),
    LocationData("Viridian Forest", "Wild Pokemon - 10", "Pikachu", rom_addresses["Wild_ViridianForest"] + 19,
                 None, event=True, type="Wild Encounter", level=5),
    LocationData("Route 3", "Wild Pokemon - 1", "Pidgey", rom_addresses["Wild_Route3"] + 1, None, event=True,
                 type="Wild Encounter", level=6),
    LocationData("Route 3", "Wild Pokemon - 2", "Spearow", rom_addresses["Wild_Route3"] + 3, None, event=True,
                 type="Wild Encounter", level=5),
    LocationData("Route 3", "Wild Pokemon - 3", "Pidgey", rom_addresses["Wild_Route3"] + 5, None, event=True,
                 type="Wild Encounter", level=7),
    LocationData("Route 3", "Wild Pokemon - 4", "Spearow", rom_addresses["Wild_Route3"] + 7, None, event=True,
                 type="Wild Encounter", level=6),
    LocationData("Route 3", "Wild Pokemon - 5", "Spearow", rom_addresses["Wild_Route3"] + 9, None, event=True,
                 type="Wild Encounter", level=7),
    LocationData("Route 3", "Wild Pokemon - 6", "Pidgey", rom_addresses["Wild_Route3"] + 11, None, event=True,
                 type="Wild Encounter", level=8),
    LocationData("Route 3", "Wild Pokemon - 7", "Spearow", rom_addresses["Wild_Route3"] + 13, None, event=True,
                 type="Wild Encounter", level=8),
    LocationData("Route 3", "Wild Pokemon - 8", "Jigglypuff", rom_addresses["Wild_Route3"] + 15, None, event=True,
                 type="Wild Encounter", level=3),
    LocationData("Route 3", "Wild Pokemon - 9", "Jigglypuff", rom_addresses["Wild_Route3"] + 17, None, event=True,
                 type="Wild Encounter", level=5),
    LocationData("Route 3", "Wild Pokemon - 10", "Jigglypuff", rom_addresses["Wild_Route3"] + 19, None, event=True,
                 type="Wild Encounter", level=7),
    LocationData("Mt Moon 1F", "Wild Pokemon - 1", "Zubat", rom_addresses["Wild_MtMoon1F"] + 1, None, event=True,
                 type="Wild Encounter", level=8),
    LocationData("Mt Moon 1F", "Wild Pokemon - 2", "Zubat", rom_addresses["Wild_MtMoon1F"] + 3, None, event=True,
                 type="Wild Encounter", level=7),
    LocationData("Mt Moon 1F", "Wild Pokemon - 3", "Zubat", rom_addresses["Wild_MtMoon1F"] + 5, None, event=True,
                 type="Wild Encounter", level=9),
    LocationData("Mt Moon 1F", "Wild Pokemon - 4", "Geodude", rom_addresses["Wild_MtMoon1F"] + 7, None, event=True,
                 type="Wild Encounter", level=8),
    LocationData("Mt Moon 1F", "Wild Pokemon - 5", "Zubat", rom_addresses["Wild_MtMoon1F"] + 9, None, event=True,
                 type="Wild Encounter", level=6),
    LocationData("Mt Moon 1F", "Wild Pokemon - 6", "Zubat", rom_addresses["Wild_MtMoon1F"] + 11, None, event=True,
                 type="Wild Encounter", level=10),
    LocationData("Mt Moon 1F", "Wild Pokemon - 7", "Geodude", rom_addresses["Wild_MtMoon1F"] + 13, None, event=True,
                 type="Wild Encounter", level=10),
    LocationData("Mt Moon 1F", "Wild Pokemon - 8", "Paras", rom_addresses["Wild_MtMoon1F"] + 15, None, event=True,
                 type="Wild Encounter", level=8),
    LocationData("Mt Moon 1F", "Wild Pokemon - 9", "Zubat", rom_addresses["Wild_MtMoon1F"] + 17, None, event=True,
                 type="Wild Encounter", level=11),
    LocationData("Mt Moon 1F", "Wild Pokemon - 10", "Clefairy", rom_addresses["Wild_MtMoon1F"] + 19, None,
                 event=True, type="Wild Encounter", level=8),
    LocationData("Mt Moon B1F-Wild", "Wild Pokemon - 1", "Zubat", rom_addresses["Wild_MtMoonB1F"] + 1, None, event=True,
                 type="Wild Encounter", level=8),
    LocationData("Mt Moon B1F-Wild", "Wild Pokemon - 2", "Zubat", rom_addresses["Wild_MtMoonB1F"] + 3, None, event=True,
                 type="Wild Encounter", level=7),
    LocationData("Mt Moon B1F-Wild", "Wild Pokemon - 3", "Geodude", rom_addresses["Wild_MtMoonB1F"] + 5, None,
                 event=True, type="Wild Encounter", level=7),
    LocationData("Mt Moon B1F-Wild", "Wild Pokemon - 4", "Geodude", rom_addresses["Wild_MtMoonB1F"] + 7, None,
                 event=True, type="Wild Encounter", level=8),
    LocationData("Mt Moon B1F-Wild", "Wild Pokemon - 5", "Zubat", rom_addresses["Wild_MtMoonB1F"] + 9, None, event=True,
                 type="Wild Encounter", level=9),
    LocationData("Mt Moon B1F-Wild", "Wild Pokemon - 6", "Paras", rom_addresses["Wild_MtMoonB1F"] + 11, None, event=True,
                 type="Wild Encounter", level=10),
    LocationData("Mt Moon B1F-Wild", "Wild Pokemon - 7", "Zubat", rom_addresses["Wild_MtMoonB1F"] + 13, None, event=True,
                 type="Wild Encounter", level=10),
    LocationData("Mt Moon B1F-Wild", "Wild Pokemon - 8", "Zubat", rom_addresses["Wild_MtMoonB1F"] + 15, None, event=True,
                 type="Wild Encounter", level=11),
    LocationData("Mt Moon B1F-Wild", "Wild Pokemon - 9", "Clefairy", rom_addresses["Wild_MtMoonB1F"] + 17, None,
                 event=True, type="Wild Encounter", level=9),
    LocationData("Mt Moon B1F-Wild", "Wild Pokemon - 10", "Geodude", rom_addresses["Wild_MtMoonB1F"] + 19, None,
                 event=True, type="Wild Encounter", level=9),
    LocationData("Mt Moon B2F-Wild", "Wild Pokemon - 1", "Zubat", rom_addresses["Wild_MtMoonB2F"] + 1, None, event=True,
                 type="Wild Encounter", level=9),
    LocationData("Mt Moon B2F-Wild", "Wild Pokemon - 2", "Geodude", rom_addresses["Wild_MtMoonB2F"] + 3, None,
                 event=True, type="Wild Encounter", level=9),
    LocationData("Mt Moon B2F-Wild", "Wild Pokemon - 3", "Zubat", rom_addresses["Wild_MtMoonB2F"] + 5, None, event=True,
                 type="Wild Encounter", level=10),
    LocationData("Mt Moon B2F-Wild", "Wild Pokemon - 4", "Geodude", rom_addresses["Wild_MtMoonB2F"] + 7, None,
                 event=True, type="Wild Encounter", level=10),
    LocationData("Mt Moon B2F-Wild", "Wild Pokemon - 5", "Zubat", rom_addresses["Wild_MtMoonB2F"] + 9, None, event=True,
                 type="Wild Encounter", level=11),
    LocationData("Mt Moon B2F-Wild", "Wild Pokemon - 6", "Paras", rom_addresses["Wild_MtMoonB2F"] + 11, None, event=True,
                 type="Wild Encounter", level=10),
    LocationData("Mt Moon B2F-Wild", "Wild Pokemon - 7", "Paras", rom_addresses["Wild_MtMoonB2F"] + 13, None, event=True,
                 type="Wild Encounter", level=12),
    LocationData("Mt Moon B2F-Wild", "Wild Pokemon - 8", "Clefairy", rom_addresses["Wild_MtMoonB2F"] + 15, None,
                 event=True, type="Wild Encounter", level=10),
    LocationData("Mt Moon B2F-Wild", "Wild Pokemon - 9", "Zubat", rom_addresses["Wild_MtMoonB2F"] + 17, None, event=True,
                 type="Wild Encounter", level=12),
    LocationData("Mt Moon B2F-Wild", "Wild Pokemon - 10", "Clefairy", rom_addresses["Wild_MtMoonB2F"] + 19, None,
                 event=True, type="Wild Encounter", level=12),
    LocationData("Route 4-E", "Wild Pokemon - 1", "Rattata", rom_addresses["Wild_Route4"] + 1, None, event=True,
                 type="Wild Encounter", level=10),
    LocationData("Route 4-E", "Wild Pokemon - 2", "Spearow", rom_addresses["Wild_Route4"] + 3, None, event=True,
                 type="Wild Encounter", level=10),
    LocationData("Route 4-E", "Wild Pokemon - 3", "Rattata", rom_addresses["Wild_Route4"] + 5, None, event=True,
                 type="Wild Encounter", level=8),
    LocationData("Route 4-E", "Wild Pokemon - 4", ["Ekans", "Sandshrew"], rom_addresses["Wild_Route4"] + 7, None,
                 event=True, type="Wild Encounter", level=6),
    LocationData("Route 4-E", "Wild Pokemon - 5", "Spearow", rom_addresses["Wild_Route4"] + 9, None, event=True,
                 type="Wild Encounter", level=8),
    LocationData("Route 4-E", "Wild Pokemon - 6", ["Ekans", "Sandshrew"], rom_addresses["Wild_Route4"] + 11, None,
                 event=True, type="Wild Encounter", level=10),
    LocationData("Route 4-E", "Wild Pokemon - 7", "Rattata", rom_addresses["Wild_Route4"] + 13, None, event=True,
                 type="Wild Encounter", level=12),
    LocationData("Route 4-E", "Wild Pokemon - 8", "Spearow", rom_addresses["Wild_Route4"] + 15, None, event=True,
                 type="Wild Encounter", level=12),
    LocationData("Route 4-E", "Wild Pokemon - 9", ["Ekans", "Sandshrew"], rom_addresses["Wild_Route4"] + 17, None,
                 event=True, type="Wild Encounter", level=8),
    LocationData("Route 4-E", "Wild Pokemon - 10", ["Ekans", "Sandshrew"], rom_addresses["Wild_Route4"] + 19, None,
                 event=True, type="Wild Encounter", level=12),
    LocationData("Route 24", "Wild Pokemon - 1", ["Weedle", "Caterpie"], rom_addresses["Wild_Route24"] + 1, None,
                 event=True, type="Wild Encounter", level=7),
    LocationData("Route 24", "Wild Pokemon - 2", ["Kakuna", "Metapod"], rom_addresses["Wild_Route24"] + 3, None,
                 event=True, type="Wild Encounter", level=8),
    LocationData("Route 24", "Wild Pokemon - 3", "Pidgey", rom_addresses["Wild_Route24"] + 5, None, event=True,
                 type="Wild Encounter", level=12),
    LocationData("Route 24", "Wild Pokemon - 4", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route24"] + 7, None,
                 event=True, type="Wild Encounter", level=12),
    LocationData("Route 24", "Wild Pokemon - 5", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route24"] + 9, None,
                 event=True, type="Wild Encounter", level=13),
    LocationData("Route 24", "Wild Pokemon - 6", "Abra", rom_addresses["Wild_Route24"] + 11, None, event=True,
                 type="Wild Encounter", level=10),
    LocationData("Route 24", "Wild Pokemon - 7", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route24"] + 13, None,
                 event=True, type="Wild Encounter", level=14),
    LocationData("Route 24", "Wild Pokemon - 8", "Pidgey", rom_addresses["Wild_Route24"] + 15, None, event=True,
                 type="Wild Encounter", level=13),
    LocationData("Route 24", "Wild Pokemon - 9", "Abra", rom_addresses["Wild_Route24"] + 17, None, event=True,
                 type="Wild Encounter", level=8),
    LocationData("Route 24", "Wild Pokemon - 10", "Abra", rom_addresses["Wild_Route24"] + 19, None, event=True,
                 type="Wild Encounter", level=12),
    LocationData("Route 25", "Wild Pokemon - 1", ["Weedle", "Caterpie"], rom_addresses["Wild_Route25"] + 1, None,
                 event=True, type="Wild Encounter", level=8),
    LocationData("Route 25", "Wild Pokemon - 2", ["Kakuna", "Metapod"], rom_addresses["Wild_Route25"] + 3, None,
                 event=True, type="Wild Encounter", level=9),
    LocationData("Route 25", "Wild Pokemon - 3", "Pidgey", rom_addresses["Wild_Route25"] + 5, None, event=True,
                 type="Wild Encounter", level=13),
    LocationData("Route 25", "Wild Pokemon - 4", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route25"] + 7, None,
                 event=True, type="Wild Encounter", level=12),
    LocationData("Route 25", "Wild Pokemon - 5", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route25"] + 9, None,
                 event=True, type="Wild Encounter", level=13),
    LocationData("Route 25", "Wild Pokemon - 6", "Abra", rom_addresses["Wild_Route25"] + 11, None, event=True,
                 type="Wild Encounter", level=12),
    LocationData("Route 25", "Wild Pokemon - 7", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route25"] + 13, None,
                 event=True, type="Wild Encounter", level=14),
    LocationData("Route 25", "Wild Pokemon - 8", "Abra", rom_addresses["Wild_Route25"] + 15, None, event=True,
                 type="Wild Encounter", level=10),
    LocationData("Route 25", "Wild Pokemon - 9", ["Metapod", "Kakuna"], rom_addresses["Wild_Route25"] + 17, None,
                 event=True, type="Wild Encounter", level=7),
    LocationData("Route 25", "Wild Pokemon - 10", ["Caterpie", "Weedle"], rom_addresses["Wild_Route25"] + 19, None,
                 event=True, type="Wild Encounter", level=8),
    LocationData("Route 9", "Wild Pokemon - 1", "Rattata", rom_addresses["Wild_Route9"] + 1, None, event=True,
                 type="Wild Encounter", level=16),
    LocationData("Route 9", "Wild Pokemon - 2", "Spearow", rom_addresses["Wild_Route9"] + 3, None, event=True,
                 type="Wild Encounter", level=16),
    LocationData("Route 9", "Wild Pokemon - 3", "Rattata", rom_addresses["Wild_Route9"] + 5, None, event=True,
                 type="Wild Encounter", level=14),
    LocationData("Route 9", "Wild Pokemon - 4", ["Ekans", "Sandshrew"], rom_addresses["Wild_Route9"] + 7, None,
                 event=True, type="Wild Encounter", level=11),
    LocationData("Route 9", "Wild Pokemon - 5", "Spearow", rom_addresses["Wild_Route9"] + 9, None, event=True,
                 type="Wild Encounter", level=13),
    LocationData("Route 9", "Wild Pokemon - 6", ["Ekans", "Sandshrew"], rom_addresses["Wild_Route9"] + 11, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Route 9", "Wild Pokemon - 7", "Rattata", rom_addresses["Wild_Route9"] + 13, None, event=True,
                 type="Wild Encounter", level=17),
    LocationData("Route 9", "Wild Pokemon - 8", "Spearow", rom_addresses["Wild_Route9"] + 15, None, event=True,
                 type="Wild Encounter", level=17),
    LocationData("Route 9", "Wild Pokemon - 9", ["Ekans", "Sandshrew"], rom_addresses["Wild_Route9"] + 17, None,
                 event=True, type="Wild Encounter", level=13),
    LocationData("Route 9", "Wild Pokemon - 10", ["Ekans", "Sandshrew"], rom_addresses["Wild_Route9"] + 19, None,
                 event=True, type="Wild Encounter", level=17),
    LocationData("Route 5", "Wild Pokemon - 1", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route5"] + 1, None,
                 event=True, type="Wild Encounter", level=13),
    LocationData("Route 5", "Wild Pokemon - 2", "Pidgey", rom_addresses["Wild_Route5"] + 3, None, event=True,
                 type="Wild Encounter", level=13),
    LocationData("Route 5", "Wild Pokemon - 3", "Pidgey", rom_addresses["Wild_Route5"] + 5, None, event=True,
                 type="Wild Encounter", level=13),
    LocationData("Route 5", "Wild Pokemon - 4", ["Mankey", "Meowth"], rom_addresses["Wild_Route5"] + 7, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Route 5", "Wild Pokemon - 5", ["Mankey", "Meowth"], rom_addresses["Wild_Route5"] + 9, None,
                 event=True, type="Wild Encounter", level=10),
    LocationData("Route 5", "Wild Pokemon - 6", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route5"] + 11, None,
                 event=True, type="Wild Encounter", level=12),
    LocationData("Route 5", "Wild Pokemon - 7", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route5"] + 13, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Route 5", "Wild Pokemon - 8", "Pidgey", rom_addresses["Wild_Route5"] + 15, None, event=True,
                 type="Wild Encounter", level=16),
    LocationData("Route 5", "Wild Pokemon - 9", ["Mankey", "Meowth"], rom_addresses["Wild_Route5"] + 17, None,
                 event=True, type="Wild Encounter", level=14),
    LocationData("Route 5", "Wild Pokemon - 10", ["Mankey", "Meowth"], rom_addresses["Wild_Route5"] + 19, None,
                 event=True, type="Wild Encounter", level=16),
    LocationData("Route 6", "Wild Pokemon - 1", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route6"] + 1, None,
                 event=True, type="Wild Encounter", level=13),
    LocationData("Route 6", "Wild Pokemon - 2", "Pidgey", rom_addresses["Wild_Route6"] + 3, None, event=True,
                 type="Wild Encounter", level=13),
    LocationData("Route 6", "Wild Pokemon - 3", "Pidgey", rom_addresses["Wild_Route6"] + 5, None, event=True,
                 type="Wild Encounter", level=15),
    LocationData("Route 6", "Wild Pokemon - 4", ["Mankey", "Meowth"], rom_addresses["Wild_Route6"] + 7, None,
                 event=True, type="Wild Encounter", level=10),
    LocationData("Route 6", "Wild Pokemon - 5", ["Mankey", "Meowth"], rom_addresses["Wild_Route6"] + 9, None,
                 event=True, type="Wild Encounter", level=12),
    LocationData("Route 6", "Wild Pokemon - 6", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route6"] + 11, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Route 6", "Wild Pokemon - 7", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route6"] + 13, None,
                 event=True, type="Wild Encounter", level=16),
    LocationData("Route 6", "Wild Pokemon - 8", "Pidgey", rom_addresses["Wild_Route6"] + 15, None, event=True,
                 type="Wild Encounter", level=16),
    LocationData("Route 6", "Wild Pokemon - 9", ["Mankey", "Meowth"], rom_addresses["Wild_Route6"] + 17, None,
                 event=True, type="Wild Encounter", level=14),
    LocationData("Route 6", "Wild Pokemon - 10", ["Mankey", "Meowth"], rom_addresses["Wild_Route6"] + 19, None,
                 event=True, type="Wild Encounter", level=16),
    LocationData("Route 11", "Wild Pokemon - 1", ["Ekans", "Sandshrew"], rom_addresses["Wild_Route11"] + 1, None,
                 event=True, type="Wild Encounter", level=14),
    LocationData("Route 11", "Wild Pokemon - 2", "Spearow", rom_addresses["Wild_Route11"] + 3, None, event=True,
                 type="Wild Encounter", level=15),
    LocationData("Route 11", "Wild Pokemon - 3", ["Ekans", "Sandshrew"], rom_addresses["Wild_Route11"] + 5, None,
                 event=True, type="Wild Encounter", level=12),
    LocationData("Route 11", "Wild Pokemon - 4", "Drowzee", rom_addresses["Wild_Route11"] + 7, None, event=True,
                 type="Wild Encounter", level=9),
    LocationData("Route 11", "Wild Pokemon - 5", "Spearow", rom_addresses["Wild_Route11"] + 9, None, event=True,
                 type="Wild Encounter", level=13),
    LocationData("Route 11", "Wild Pokemon - 6", "Drowzee", rom_addresses["Wild_Route11"] + 11, None, event=True,
                 type="Wild Encounter", level=13),
    LocationData("Route 11", "Wild Pokemon - 7", ["Ekans", "Sandshrew"], rom_addresses["Wild_Route11"] + 13, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Route 11", "Wild Pokemon - 8", "Spearow", rom_addresses["Wild_Route11"] + 15, None, event=True,
                 type="Wild Encounter", level=17),
    LocationData("Route 11", "Wild Pokemon - 9", "Drowzee", rom_addresses["Wild_Route11"] + 17, None, event=True,
                 type="Wild Encounter", level=11),
    LocationData("Route 11", "Wild Pokemon - 10", "Drowzee", rom_addresses["Wild_Route11"] + 19, None, event=True,
                 type="Wild Encounter", level=15),
    LocationData("Rock Tunnel 1F-Wild", "Wild Pokemon - 1", "Zubat", rom_addresses["Wild_RockTunnel1F"] + 1, None,
                 event=True, type="Wild Encounter", level=16),
    LocationData("Rock Tunnel 1F-Wild", "Wild Pokemon - 2", "Zubat", rom_addresses["Wild_RockTunnel1F"] + 3, None,
                 event=True, type="Wild Encounter", level=17),
    LocationData("Rock Tunnel 1F-Wild", "Wild Pokemon - 3", "Geodude", rom_addresses["Wild_RockTunnel1F"] + 5, None,
                 event=True, type="Wild Encounter", level=17),
    LocationData("Rock Tunnel 1F-Wild", "Wild Pokemon - 4", "Machop", rom_addresses["Wild_RockTunnel1F"] + 7, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Rock Tunnel 1F-Wild", "Wild Pokemon - 5", "Geodude", rom_addresses["Wild_RockTunnel1F"] + 9, None,
                 event=True, type="Wild Encounter", level=16),
    LocationData("Rock Tunnel 1F-Wild", "Wild Pokemon - 6", "Zubat", rom_addresses["Wild_RockTunnel1F"] + 11, None,
                 event=True, type="Wild Encounter", level=18),
    LocationData("Rock Tunnel 1F-Wild", "Wild Pokemon - 7", "Zubat", rom_addresses["Wild_RockTunnel1F"] + 13, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Rock Tunnel 1F-Wild", "Wild Pokemon - 8", "Machop", rom_addresses["Wild_RockTunnel1F"] + 15, None,
                 event=True, type="Wild Encounter", level=17),
    LocationData("Rock Tunnel 1F-Wild", "Wild Pokemon - 9", "Onix", rom_addresses["Wild_RockTunnel1F"] + 17, None,
                 event=True, type="Wild Encounter", level=13),
    LocationData("Rock Tunnel 1F-Wild", "Wild Pokemon - 10", "Onix", rom_addresses["Wild_RockTunnel1F"] + 19, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Rock Tunnel B1F-Wild", "Wild Pokemon - 1", "Zubat", rom_addresses["Wild_RockTunnelB1F"] + 1, None,
                 event=True, type="Wild Encounter", level=16),
    LocationData("Rock Tunnel B1F-Wild", "Wild Pokemon - 2", "Zubat", rom_addresses["Wild_RockTunnelB1F"] + 3, None,
                 event=True, type="Wild Encounter", level=17),
    LocationData("Rock Tunnel B1F-Wild", "Wild Pokemon - 3", "Geodude", rom_addresses["Wild_RockTunnelB1F"] + 5, None,
                 event=True, type="Wild Encounter", level=17),
    LocationData("Rock Tunnel B1F-Wild", "Wild Pokemon - 4", "Machop", rom_addresses["Wild_RockTunnelB1F"] + 7, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Rock Tunnel B1F-Wild", "Wild Pokemon - 5", "Geodude", rom_addresses["Wild_RockTunnelB1F"] + 9, None,
                 event=True, type="Wild Encounter", level=16),
    LocationData("Rock Tunnel B1F-Wild", "Wild Pokemon - 6", "Zubat", rom_addresses["Wild_RockTunnelB1F"] + 11, None,
                 event=True, type="Wild Encounter", level=18),
    LocationData("Rock Tunnel B1F-Wild", "Wild Pokemon - 7", "Machop", rom_addresses["Wild_RockTunnelB1F"] + 13, None,
                 event=True, type="Wild Encounter", level=17),
    LocationData("Rock Tunnel B1F-Wild", "Wild Pokemon - 8", "Onix", rom_addresses["Wild_RockTunnelB1F"] + 15, None,
                 event=True, type="Wild Encounter", level=17),
    LocationData("Rock Tunnel B1F-Wild", "Wild Pokemon - 9", "Onix", rom_addresses["Wild_RockTunnelB1F"] + 17, None,
                 event=True, type="Wild Encounter", level=13),
    LocationData("Rock Tunnel B1F-Wild", "Wild Pokemon - 10", "Geodude", rom_addresses["Wild_RockTunnelB1F"] + 19, None,
                 event=True, type="Wild Encounter", level=18),
    LocationData("Route 10-N", "Wild Pokemon - 1", "Voltorb", rom_addresses["Wild_Route10"] + 1, None,
                 event=True, type="Wild Encounter", level=16),
    LocationData("Route 10-N", "Wild Pokemon - 2", "Spearow", rom_addresses["Wild_Route10"] + 3, None,
                 event=True, type="Wild Encounter", level=16),
    LocationData("Route 10-N", "Wild Pokemon - 3", "Voltorb", rom_addresses["Wild_Route10"] + 5, None,
                 event=True, type="Wild Encounter", level=14),
    LocationData("Route 10-N", "Wild Pokemon - 4", ["Ekans", "Sandshrew"], rom_addresses["Wild_Route10"] + 7,
                 None, event=True, type="Wild Encounter", level=11),
    LocationData("Route 10-N", "Wild Pokemon - 5", "Spearow", rom_addresses["Wild_Route10"] + 9, None,
                 event=True, type="Wild Encounter", level=13),
    LocationData("Route 10-N", "Wild Pokemon - 6", ["Ekans", "Sandshrew"], rom_addresses["Wild_Route10"] + 11,
                 None, event=True, type="Wild Encounter", level=15),
    LocationData("Route 10-N", "Wild Pokemon - 7", "Voltorb", rom_addresses["Wild_Route10"] + 13, None,
                 event=True, type="Wild Encounter", level=17),
    LocationData("Route 10-N", "Wild Pokemon - 8", "Spearow", rom_addresses["Wild_Route10"] + 15, None,
                 event=True, type="Wild Encounter", level=17),
    LocationData("Route 10-N", "Wild Pokemon - 9", ["Ekans", "Sandshrew"], rom_addresses["Wild_Route10"] + 17,
                 None, event=True, type="Wild Encounter", level=13),
    LocationData("Route 10-N", "Wild Pokemon - 10", ["Ekans", "Sandshrew"], rom_addresses["Wild_Route10"] + 19,
                 None, event=True, type="Wild Encounter", level=17),
    LocationData("Route 12-Grass", "Wild Pokemon - 1", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route12"] + 1,
                 None, event=True, type="Wild Encounter", level=24),
    LocationData("Route 12-Grass", "Wild Pokemon - 2", "Pidgey", rom_addresses["Wild_Route12"] + 3, None,
                 event=True, type="Wild Encounter", level=25),
    LocationData("Route 12-Grass", "Wild Pokemon - 3", "Pidgey", rom_addresses["Wild_Route12"] + 5, None,
                 event=True, type="Wild Encounter", level=23),
    LocationData("Route 12-Grass", "Wild Pokemon - 4", "Venonat", rom_addresses["Wild_Route12"] + 7, None,
                 event=True, type="Wild Encounter", level=24),
    LocationData("Route 12-Grass", "Wild Pokemon - 5", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route12"] + 9,
                 None, event=True, type="Wild Encounter", level=22),
    LocationData("Route 12-Grass", "Wild Pokemon - 6", "Venonat", rom_addresses["Wild_Route12"] + 11, None,
                 event=True, type="Wild Encounter", level=26),
    LocationData("Route 12-Grass", "Wild Pokemon - 7", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route12"] + 13,
                 None, event=True, type="Wild Encounter", level=26),
    LocationData("Route 12-Grass", "Wild Pokemon - 8", "Pidgey", rom_addresses["Wild_Route12"] + 15, None,
                 event=True, type="Wild Encounter", level=27),
    LocationData("Route 12-Grass", "Wild Pokemon - 9", ["Gloom", "Weepinbell"], rom_addresses["Wild_Route12"] + 17,
                 None, event=True, type="Wild Encounter", level=28),
    LocationData("Route 12-Grass", "Wild Pokemon - 10", ["Gloom", "Weepinbell"], rom_addresses["Wild_Route12"] + 19,
                 None, event=True, type="Wild Encounter", level=30),
    LocationData("Route 8-Grass", "Wild Pokemon - 1", "Pidgey", rom_addresses["Wild_Route8"] + 1, None, event=True,
                 type="Wild Encounter", level=18),
    LocationData("Route 8-Grass", "Wild Pokemon - 2", ["Mankey", "Meowth"], rom_addresses["Wild_Route8"] + 3, None,
                 event=True, type="Wild Encounter", level=18),
    LocationData("Route 8-Grass", "Wild Pokemon - 3", ["Ekans", "Sandshrew"], rom_addresses["Wild_Route8"] + 5, None,
                 event=True, type="Wild Encounter", level=17),
    LocationData("Route 8-Grass", "Wild Pokemon - 4", ["Growlithe", "Vulpix"], rom_addresses["Wild_Route8"] + 7, None,
                 event=True, type="Wild Encounter", level=16),
    LocationData("Route 8-Grass", "Wild Pokemon - 5", "Pidgey", rom_addresses["Wild_Route8"] + 9, None, event=True,
                 type="Wild Encounter", level=20),
    LocationData("Route 8-Grass", "Wild Pokemon - 6", ["Mankey", "Meowth"], rom_addresses["Wild_Route8"] + 11, None,
                 event=True, type="Wild Encounter", level=20),
    LocationData("Route 8-Grass", "Wild Pokemon - 7", ["Ekans", "Sandshrew"], rom_addresses["Wild_Route8"] + 13, None,
                 event=True, type="Wild Encounter", level=19),
    LocationData("Route 8-Grass", "Wild Pokemon - 8", ["Growlithe", "Vulpix"], rom_addresses["Wild_Route8"] + 15, None,
                 event=True, type="Wild Encounter", level=17),
    LocationData("Route 8-Grass", "Wild Pokemon - 9", ["Growlithe", "Vulpix"], rom_addresses["Wild_Route8"] + 17, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Route 8-Grass", "Wild Pokemon - 10", ["Growlithe", "Vulpix"], rom_addresses["Wild_Route8"] + 19, None,
                 event=True, type="Wild Encounter", level=18),
    LocationData("Route 7", "Wild Pokemon - 1", "Pidgey", rom_addresses["Wild_Route7"] + 1, None, event=True,
                 type="Wild Encounter", level=19),
    LocationData("Route 7", "Wild Pokemon - 2", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route7"] + 3, None,
                 event=True, type="Wild Encounter", level=19),
    LocationData("Route 7", "Wild Pokemon - 3", ["Mankey", "Meowth"], rom_addresses["Wild_Route7"] + 5, None,
                 event=True, type="Wild Encounter", level=17),
    LocationData("Route 7", "Wild Pokemon - 4", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route7"] + 7, None,
                 event=True, type="Wild Encounter", level=22),
    LocationData("Route 7", "Wild Pokemon - 5", "Pidgey", rom_addresses["Wild_Route7"] + 9, None, event=True,
                 type="Wild Encounter", level=22),
    LocationData("Route 7", "Wild Pokemon - 6", ["Mankey", "Meowth"], rom_addresses["Wild_Route7"] + 11, None,
                 event=True, type="Wild Encounter", level=18),
    LocationData("Route 7", "Wild Pokemon - 7", ["Growlithe", "Vulpix"], rom_addresses["Wild_Route7"] + 13, None,
                 event=True, type="Wild Encounter", level=18),
    LocationData("Route 7", "Wild Pokemon - 8", ["Growlithe", "Vulpix"], rom_addresses["Wild_Route7"] + 15, None,
                 event=True, type="Wild Encounter", level=20),
    LocationData("Route 7", "Wild Pokemon - 9", ["Mankey", "Meowth"], rom_addresses["Wild_Route7"] + 17, None,
                 event=True, type="Wild Encounter", level=19),
    LocationData("Route 7", "Wild Pokemon - 10", ["Mankey", "Meowth"], rom_addresses["Wild_Route7"] + 19, None,
                 event=True, type="Wild Encounter", level=20),
    LocationData("Pokemon Tower 3F", "Wild Pokemon - 1", "Gastly", rom_addresses["Wild_PokemonTower3F"] + 1, None,
                 event=True, type="Wild Encounter", level=20),
    LocationData("Pokemon Tower 3F", "Wild Pokemon - 2", "Gastly", rom_addresses["Wild_PokemonTower3F"] + 3, None,
                 event=True, type="Wild Encounter", level=21),
    LocationData("Pokemon Tower 3F", "Wild Pokemon - 3", "Gastly", rom_addresses["Wild_PokemonTower3F"] + 5, None,
                 event=True, type="Wild Encounter", level=22),
    LocationData("Pokemon Tower 3F", "Wild Pokemon - 4", "Gastly", rom_addresses["Wild_PokemonTower3F"] + 7, None,
                 event=True, type="Wild Encounter", level=23),
    LocationData("Pokemon Tower 3F", "Wild Pokemon - 5", "Gastly", rom_addresses["Wild_PokemonTower3F"] + 9, None,
                 event=True, type="Wild Encounter", level=19),
    LocationData("Pokemon Tower 3F", "Wild Pokemon - 6", "Gastly", rom_addresses["Wild_PokemonTower3F"] + 11, None,
                 event=True, type="Wild Encounter", level=18),
    LocationData("Pokemon Tower 3F", "Wild Pokemon - 7", "Gastly", rom_addresses["Wild_PokemonTower3F"] + 13, None,
                 event=True, type="Wild Encounter", level=24),
    LocationData("Pokemon Tower 3F", "Wild Pokemon - 8", "Cubone", rom_addresses["Wild_PokemonTower3F"] + 15, None,
                 event=True, type="Wild Encounter", level=20),
    LocationData("Pokemon Tower 3F", "Wild Pokemon - 9", "Cubone", rom_addresses["Wild_PokemonTower3F"] + 17, None,
                 event=True, type="Wild Encounter", level=22),
    LocationData("Pokemon Tower 3F", "Wild Pokemon - 10", "Haunter", rom_addresses["Wild_PokemonTower3F"] + 19,
                 None, event=True, type="Wild Encounter", level=25),
    LocationData("Pokemon Tower 4F", "Wild Pokemon - 1", "Gastly", rom_addresses["Wild_PokemonTower4F"] + 1, None,
                 event=True, type="Wild Encounter", level=20),
    LocationData("Pokemon Tower 4F", "Wild Pokemon - 2", "Gastly", rom_addresses["Wild_PokemonTower4F"] + 3, None,
                 event=True, type="Wild Encounter", level=21),
    LocationData("Pokemon Tower 4F", "Wild Pokemon - 3", "Gastly", rom_addresses["Wild_PokemonTower4F"] + 5, None,
                 event=True, type="Wild Encounter", level=22),
    LocationData("Pokemon Tower 4F", "Wild Pokemon - 4", "Gastly", rom_addresses["Wild_PokemonTower4F"] + 7, None,
                 event=True, type="Wild Encounter", level=23),
    LocationData("Pokemon Tower 4F", "Wild Pokemon - 5", "Gastly", rom_addresses["Wild_PokemonTower4F"] + 9, None,
                 event=True, type="Wild Encounter", level=19),
    LocationData("Pokemon Tower 4F", "Wild Pokemon - 6", "Gastly", rom_addresses["Wild_PokemonTower4F"] + 11, None,
                 event=True, type="Wild Encounter", level=18),
    LocationData("Pokemon Tower 4F", "Wild Pokemon - 7", "Haunter", rom_addresses["Wild_PokemonTower4F"] + 13,
                 None, event=True, type="Wild Encounter", level=25),
    LocationData("Pokemon Tower 4F", "Wild Pokemon - 8", "Cubone", rom_addresses["Wild_PokemonTower4F"] + 15, None,
                 event=True, type="Wild Encounter", level=20),
    LocationData("Pokemon Tower 4F", "Wild Pokemon - 9", "Cubone", rom_addresses["Wild_PokemonTower4F"] + 17, None,
                 event=True, type="Wild Encounter", level=22),
    LocationData("Pokemon Tower 4F", "Wild Pokemon - 10", "Gastly", rom_addresses["Wild_PokemonTower4F"] + 19,
                 None, event=True, type="Wild Encounter", level=24),
    LocationData("Pokemon Tower 5F", "Wild Pokemon - 1", "Gastly", rom_addresses["Wild_PokemonTower5F"] + 1, None,
                 event=True, type="Wild Encounter", level=20),
    LocationData("Pokemon Tower 5F", "Wild Pokemon - 2", "Gastly", rom_addresses["Wild_PokemonTower5F"] + 3, None,
                 event=True, type="Wild Encounter", level=21),
    LocationData("Pokemon Tower 5F", "Wild Pokemon - 3", "Gastly", rom_addresses["Wild_PokemonTower5F"] + 5, None,
                 event=True, type="Wild Encounter", level=22),
    LocationData("Pokemon Tower 5F", "Wild Pokemon - 4", "Gastly", rom_addresses["Wild_PokemonTower5F"] + 7, None,
                 event=True, type="Wild Encounter", level=23),
    LocationData("Pokemon Tower 5F", "Wild Pokemon - 5", "Gastly", rom_addresses["Wild_PokemonTower5F"] + 9, None,
                 event=True, type="Wild Encounter", level=19),
    LocationData("Pokemon Tower 5F", "Wild Pokemon - 6", "Gastly", rom_addresses["Wild_PokemonTower5F"] + 11, None,
                 event=True, type="Wild Encounter", level=18),
    LocationData("Pokemon Tower 5F", "Wild Pokemon - 7", "Haunter", rom_addresses["Wild_PokemonTower5F"] + 13,
                 None, event=True, type="Wild Encounter", level=25),
    LocationData("Pokemon Tower 5F", "Wild Pokemon - 8", "Cubone", rom_addresses["Wild_PokemonTower5F"] + 15, None,
                 event=True, type="Wild Encounter", level=20),
    LocationData("Pokemon Tower 5F", "Wild Pokemon - 9", "Cubone", rom_addresses["Wild_PokemonTower5F"] + 17, None,
                 event=True, type="Wild Encounter", level=22),
    LocationData("Pokemon Tower 5F", "Wild Pokemon - 10", "Gastly", rom_addresses["Wild_PokemonTower5F"] + 19,
                 None, event=True, type="Wild Encounter", level=24),
    LocationData("Pokemon Tower 6F", "Wild Pokemon - 1", "Gastly", rom_addresses["Wild_PokemonTower6F"] + 1, None,
                 event=True, type="Wild Encounter", level=21),
    LocationData("Pokemon Tower 6F", "Wild Pokemon - 2", "Gastly", rom_addresses["Wild_PokemonTower6F"] + 3, None,
                 event=True, type="Wild Encounter", level=22),
    LocationData("Pokemon Tower 6F", "Wild Pokemon - 3", "Gastly", rom_addresses["Wild_PokemonTower6F"] + 5, None,
                 event=True, type="Wild Encounter", level=23),
    LocationData("Pokemon Tower 6F", "Wild Pokemon - 4", "Gastly", rom_addresses["Wild_PokemonTower6F"] + 7, None,
                 event=True, type="Wild Encounter", level=24),
    LocationData("Pokemon Tower 6F", "Wild Pokemon - 5", "Gastly", rom_addresses["Wild_PokemonTower6F"] + 9, None,
                 event=True, type="Wild Encounter", level=20),
    LocationData("Pokemon Tower 6F", "Wild Pokemon - 6", "Gastly", rom_addresses["Wild_PokemonTower6F"] + 11, None,
                 event=True, type="Wild Encounter", level=19),
    LocationData("Pokemon Tower 6F", "Wild Pokemon - 7", "Haunter", rom_addresses["Wild_PokemonTower6F"] + 13,
                 None, event=True, type="Wild Encounter", level=26),
    LocationData("Pokemon Tower 6F", "Wild Pokemon - 8", "Cubone", rom_addresses["Wild_PokemonTower6F"] + 15, None,
                 event=True, type="Wild Encounter", level=22),
    LocationData("Pokemon Tower 6F", "Wild Pokemon - 9", "Cubone", rom_addresses["Wild_PokemonTower6F"] + 17, None,
                 event=True, type="Wild Encounter", level=24),
    LocationData("Pokemon Tower 6F", "Wild Pokemon - 10", "Haunter", rom_addresses["Wild_PokemonTower6F"] + 19,
                 None, event=True, type="Wild Encounter", level=28),
    LocationData("Pokemon Tower 7F", "Wild Pokemon - 1", "Gastly", rom_addresses["Wild_PokemonTower7F"] + 1, None,
                 event=True, type="Wild Encounter", level=21),
    LocationData("Pokemon Tower 7F", "Wild Pokemon - 2", "Gastly", rom_addresses["Wild_PokemonTower7F"] + 3, None,
                 event=True, type="Wild Encounter", level=22),
    LocationData("Pokemon Tower 7F", "Wild Pokemon - 3", "Gastly", rom_addresses["Wild_PokemonTower7F"] + 5, None,
                 event=True, type="Wild Encounter", level=23),
    LocationData("Pokemon Tower 7F", "Wild Pokemon - 4", "Gastly", rom_addresses["Wild_PokemonTower7F"] + 7, None,
                 event=True, type="Wild Encounter", level=24),
    LocationData("Pokemon Tower 7F", "Wild Pokemon - 5", "Gastly", rom_addresses["Wild_PokemonTower7F"] + 9, None,
                 event=True, type="Wild Encounter", level=20),
    LocationData("Pokemon Tower 7F", "Wild Pokemon - 6", "Haunter", rom_addresses["Wild_PokemonTower7F"] + 11,
                 None, event=True, type="Wild Encounter", level=28),
    LocationData("Pokemon Tower 7F", "Wild Pokemon - 7", "Cubone", rom_addresses["Wild_PokemonTower7F"] + 13, None,
                 event=True, type="Wild Encounter", level=22),
    LocationData("Pokemon Tower 7F", "Wild Pokemon - 8", "Cubone", rom_addresses["Wild_PokemonTower7F"] + 15, None,
                 event=True, type="Wild Encounter", level=24),
    LocationData("Pokemon Tower 7F", "Wild Pokemon - 9", "Haunter", rom_addresses["Wild_PokemonTower7F"] + 17,
                 None, event=True, type="Wild Encounter", level=28),
    LocationData("Pokemon Tower 7F", "Wild Pokemon - 10", "Haunter", rom_addresses["Wild_PokemonTower7F"] + 19,
                 None, event=True, type="Wild Encounter", level=30),
    LocationData("Route 13-Grass", "Wild Pokemon - 1", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route13"] + 1, None,
                 event=True, type="Wild Encounter", level=24),
    LocationData("Route 13-Grass", "Wild Pokemon - 2", "Pidgey", rom_addresses["Wild_Route13"] + 3, None, event=True,
                 type="Wild Encounter", level=25),
    LocationData("Route 13-Grass", "Wild Pokemon - 3", "Pidgey", rom_addresses["Wild_Route13"] + 5, None, event=True,
                 type="Wild Encounter", level=27),
    LocationData("Route 13-Grass", "Wild Pokemon - 4", "Venonat", rom_addresses["Wild_Route13"] + 7, None, event=True,
                 type="Wild Encounter", level=24),
    LocationData("Route 13-Grass", "Wild Pokemon - 5", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route13"] + 9, None,
                 event=True, type="Wild Encounter", level=22),
    LocationData("Route 13-Grass", "Wild Pokemon - 6", "Venonat", rom_addresses["Wild_Route13"] + 11, None, event=True,
                 type="Wild Encounter", level=26),
    LocationData("Route 13-Grass", "Wild Pokemon - 7", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route13"] + 13, None,
                 event=True, type="Wild Encounter", level=26),
    LocationData("Route 13-Grass", "Wild Pokemon - 8", "Ditto", rom_addresses["Wild_Route13"] + 15, None, event=True,
                 type="Wild Encounter", level=25),
    LocationData("Route 13-Grass", "Wild Pokemon - 9", ["Gloom", "Weepinbell"], rom_addresses["Wild_Route13"] + 17, None,
                 event=True, type="Wild Encounter", level=28),
    LocationData("Route 13-Grass", "Wild Pokemon - 10", ["Gloom", "Weepinbell"], rom_addresses["Wild_Route13"] + 19, None,
                 event=True, type="Wild Encounter", level=30),
    LocationData("Route 14-Grass", "Wild Pokemon - 1", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route14"] + 1, None,
                 event=True, type="Wild Encounter", level=24),
    LocationData("Route 14-Grass", "Wild Pokemon - 2", "Pidgey", rom_addresses["Wild_Route14"] + 3, None, event=True,
                 type="Wild Encounter", level=26),
    LocationData("Route 14-Grass", "Wild Pokemon - 3", "Ditto", rom_addresses["Wild_Route14"] + 5, None, event=True,
                 type="Wild Encounter", level=23),
    LocationData("Route 14-Grass", "Wild Pokemon - 4", "Venonat", rom_addresses["Wild_Route14"] + 7, None, event=True,
                 type="Wild Encounter", level=24),
    LocationData("Route 14-Grass", "Wild Pokemon - 5", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route14"] + 9, None,
                 event=True, type="Wild Encounter", level=22),
    LocationData("Route 14-Grass", "Wild Pokemon - 6", "Venonat", rom_addresses["Wild_Route14"] + 11, None, event=True,
                 type="Wild Encounter", level=26),
    LocationData("Route 14-Grass", "Wild Pokemon - 7", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route14"] + 13, None,
                 event=True, type="Wild Encounter", level=26),
    LocationData("Route 14-Grass", "Wild Pokemon - 8", ["Gloom", "Weepinbell"], rom_addresses["Wild_Route14"] + 15, None,
                 event=True, type="Wild Encounter", level=30),
    LocationData("Route 14-Grass", "Wild Pokemon - 9", "Pidgeotto", rom_addresses["Wild_Route14"] + 17, None, event=True,
                 type="Wild Encounter", level=28),
    LocationData("Route 14-Grass", "Wild Pokemon - 10", "Pidgeotto", rom_addresses["Wild_Route14"] + 19, None, event=True,
                 type="Wild Encounter", level=30),
    LocationData("Route 15", "Wild Pokemon - 1", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route15"] + 1, None,
                 event=True, type="Wild Encounter", level=24),
    LocationData("Route 15", "Wild Pokemon - 2", "Ditto", rom_addresses["Wild_Route15"] + 3, None, event=True,
                 type="Wild Encounter", level=26),
    LocationData("Route 15", "Wild Pokemon - 3", "Pidgey", rom_addresses["Wild_Route15"] + 5, None, event=True,
                 type="Wild Encounter", level=23),
    LocationData("Route 15", "Wild Pokemon - 4", "Venonat", rom_addresses["Wild_Route15"] + 7, None, event=True,
                 type="Wild Encounter", level=26),
    LocationData("Route 15", "Wild Pokemon - 5", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route15"] + 9, None,
                 event=True, type="Wild Encounter", level=22),
    LocationData("Route 15", "Wild Pokemon - 6", "Venonat", rom_addresses["Wild_Route15"] + 11, None, event=True,
                 type="Wild Encounter", level=28),
    LocationData("Route 15", "Wild Pokemon - 7", ["Oddish", "Bellsprout"], rom_addresses["Wild_Route15"] + 13, None,
                 event=True, type="Wild Encounter", level=26),
    LocationData("Route 15", "Wild Pokemon - 8", ["Gloom", "Weepinbell"], rom_addresses["Wild_Route15"] + 15, None,
                 event=True, type="Wild Encounter", level=30),
    LocationData("Route 15", "Wild Pokemon - 9", "Pidgeotto", rom_addresses["Wild_Route15"] + 17, None, event=True,
                 type="Wild Encounter", level=28),
    LocationData("Route 15", "Wild Pokemon - 10", "Pidgeotto", rom_addresses["Wild_Route15"] + 19, None, event=True,
                 type="Wild Encounter", level=30),
    LocationData("Route 16-NE", "Wild Pokemon - 1", "Spearow", rom_addresses["Wild_Route16"] + 1, None, event=True,
                 type="Wild Encounter", level=20),
    LocationData("Route 16-NE", "Wild Pokemon - 2", "Spearow", rom_addresses["Wild_Route16"] + 3, None, event=True,
                 type="Wild Encounter", level=22),
    LocationData("Route 16-NE", "Wild Pokemon - 3", "Rattata", rom_addresses["Wild_Route16"] + 5, None, event=True,
                 type="Wild Encounter", level=18),
    LocationData("Route 16-NE", "Wild Pokemon - 4", "Doduo", rom_addresses["Wild_Route16"] + 7, None, event=True,
                 type="Wild Encounter", level=20),
    LocationData("Route 16-NE", "Wild Pokemon - 5", "Rattata", rom_addresses["Wild_Route16"] + 9, None, event=True,
                 type="Wild Encounter", level=20),
    LocationData("Route 16-NE", "Wild Pokemon - 6", "Doduo", rom_addresses["Wild_Route16"] + 11, None, event=True,
                 type="Wild Encounter", level=18),
    LocationData("Route 16-NE", "Wild Pokemon - 7", "Doduo", rom_addresses["Wild_Route16"] + 13, None, event=True,
                 type="Wild Encounter", level=22),
    LocationData("Route 16-NE", "Wild Pokemon - 8", "Rattata", rom_addresses["Wild_Route16"] + 15, None, event=True,
                 type="Wild Encounter", level=22),
    LocationData("Route 16-NE", "Wild Pokemon - 9", "Raticate", rom_addresses["Wild_Route16"] + 17, None, event=True,
                 type="Wild Encounter", level=23),
    LocationData("Route 16-NE", "Wild Pokemon - 10", "Raticate", rom_addresses["Wild_Route16"] + 19, None,
                 event=True,
                 type="Wild Encounter", level=25),
    LocationData("Route 17", "Wild Pokemon - 1", "Spearow", rom_addresses["Wild_Route17"] + 1, None, event=True,
                 type="Wild Encounter", level=20),
    LocationData("Route 17", "Wild Pokemon - 2", "Spearow", rom_addresses["Wild_Route17"] + 3, None, event=True,
                 type="Wild Encounter", level=22),
    LocationData("Route 17", "Wild Pokemon - 3", "Raticate", rom_addresses["Wild_Route17"] + 5, None, event=True,
                 type="Wild Encounter", level=25),
    LocationData("Route 17", "Wild Pokemon - 4", "Doduo", rom_addresses["Wild_Route17"] + 7, None, event=True,
                 type="Wild Encounter", level=24),
    LocationData("Route 17", "Wild Pokemon - 5", "Raticate", rom_addresses["Wild_Route17"] + 9, None, event=True,
                 type="Wild Encounter", level=27),
    LocationData("Route 17", "Wild Pokemon - 6", "Doduo", rom_addresses["Wild_Route17"] + 11, None, event=True,
                 type="Wild Encounter", level=26),
    LocationData("Route 17", "Wild Pokemon - 7", "Doduo", rom_addresses["Wild_Route17"] + 13, None, event=True,
                 type="Wild Encounter", level=28),
    LocationData("Route 17", "Wild Pokemon - 8", "Raticate", rom_addresses["Wild_Route17"] + 15, None, event=True,
                 type="Wild Encounter", level=29),
    LocationData("Route 17", "Wild Pokemon - 9", "Fearow", rom_addresses["Wild_Route17"] + 17, None, event=True,
                 type="Wild Encounter", level=25),
    LocationData("Route 17", "Wild Pokemon - 10", "Fearow", rom_addresses["Wild_Route17"] + 19, None, event=True,
                 type="Wild Encounter", level=27),
    LocationData("Route 18-E", "Wild Pokemon - 1", "Spearow", rom_addresses["Wild_Route18"] + 1, None, event=True,
                 type="Wild Encounter", level=20),
    LocationData("Route 18-E", "Wild Pokemon - 2", "Spearow", rom_addresses["Wild_Route18"] + 3, None, event=True,
                 type="Wild Encounter", level=22),
    LocationData("Route 18-E", "Wild Pokemon - 3", "Raticate", rom_addresses["Wild_Route18"] + 5, None, event=True,
                 type="Wild Encounter", level=25),
    LocationData("Route 18-E", "Wild Pokemon - 4", "Doduo", rom_addresses["Wild_Route18"] + 7, None, event=True,
                 type="Wild Encounter", level=24),
    LocationData("Route 18-E", "Wild Pokemon - 5", "Fearow", rom_addresses["Wild_Route18"] + 9, None, event=True,
                 type="Wild Encounter", level=25),
    LocationData("Route 18-E", "Wild Pokemon - 6", "Doduo", rom_addresses["Wild_Route18"] + 11, None, event=True,
                 type="Wild Encounter", level=26),
    LocationData("Route 18-E", "Wild Pokemon - 7", "Doduo", rom_addresses["Wild_Route18"] + 13, None, event=True,
                 type="Wild Encounter", level=28),
    LocationData("Route 18-E", "Wild Pokemon - 8", "Raticate", rom_addresses["Wild_Route18"] + 15, None, event=True,
                 type="Wild Encounter", level=29),
    LocationData("Route 18-E", "Wild Pokemon - 9", "Fearow", rom_addresses["Wild_Route18"] + 17, None, event=True,
                 type="Wild Encounter", level=27),
    LocationData("Route 18-E", "Wild Pokemon - 10", "Fearow", rom_addresses["Wild_Route18"] + 19, None, event=True,
                 type="Wild Encounter", level=29),
    LocationData("Safari Zone Center-Wild", "Wild Pokemon - 1", ["Nidoran M", "Nidoran F"],
                 rom_addresses["Wild_SafariZoneCenter"] + 1, None, event=True, type="Wild Encounter", level=22),
    LocationData("Safari Zone Center-Wild", "Wild Pokemon - 2", "Rhyhorn", rom_addresses["Wild_SafariZoneCenter"] + 3,
                 None, event=True, type="Wild Encounter", level=25),
    LocationData("Safari Zone Center-Wild", "Wild Pokemon - 3", "Venonat", rom_addresses["Wild_SafariZoneCenter"] + 5,
                 None, event=True, type="Wild Encounter", level=22),
    LocationData("Safari Zone Center-Wild", "Wild Pokemon - 4", "Exeggcute", rom_addresses["Wild_SafariZoneCenter"] + 7,
                 None, event=True, type="Wild Encounter", level=24),
    LocationData("Safari Zone Center-Wild", "Wild Pokemon - 5", ["Nidorino", "Nidorina"],
                 rom_addresses["Wild_SafariZoneCenter"] + 9, None, event=True, type="Wild Encounter", level=31),
    LocationData("Safari Zone Center-Wild", "Wild Pokemon - 6", "Exeggcute", rom_addresses["Wild_SafariZoneCenter"] + 11,
                 None, event=True, type="Wild Encounter", level=25),
    LocationData("Safari Zone Center-Wild", "Wild Pokemon - 7", ["Nidorina", "Nidorino"],
                 rom_addresses["Wild_SafariZoneCenter"] + 13, None, event=True, type="Wild Encounter", level=31),
    LocationData("Safari Zone Center-Wild", "Wild Pokemon - 8", "Parasect", rom_addresses["Wild_SafariZoneCenter"] + 15,
                 None, event=True, type="Wild Encounter", level=30),
    LocationData("Safari Zone Center-Wild", "Wild Pokemon - 9", ["Scyther", "Pinsir"],
                 rom_addresses["Wild_SafariZoneCenter"] + 17, None, event=True, type="Wild Encounter", level=23),
    LocationData("Safari Zone Center-Wild", "Wild Pokemon - 10", "Chansey", rom_addresses["Wild_SafariZoneCenter"] + 19,
                 None, event=True, type="Wild Encounter", level=23),
    LocationData("Safari Zone East", "Wild Pokemon - 1", ["Nidoran M", "Nidoran F"],
                 rom_addresses["Wild_SafariZoneEast"] + 1, None, event=True, type="Wild Encounter", level=24),
    LocationData("Safari Zone East", "Wild Pokemon - 2", "Doduo", rom_addresses["Wild_SafariZoneEast"] + 3, None,
                 event=True, type="Wild Encounter", level=26),
    LocationData("Safari Zone East", "Wild Pokemon - 3", "Paras", rom_addresses["Wild_SafariZoneEast"] + 5, None,
                 event=True, type="Wild Encounter", level=22),
    LocationData("Safari Zone East", "Wild Pokemon - 4", "Exeggcute", rom_addresses["Wild_SafariZoneEast"] + 7,
                 None, event=True, type="Wild Encounter", level=25),
    LocationData("Safari Zone East", "Wild Pokemon - 5", ["Nidorino", "Nidorina"],
                 rom_addresses["Wild_SafariZoneEast"] + 9, None, event=True, type="Wild Encounter", level=33),
    LocationData("Safari Zone East", "Wild Pokemon - 6", "Exeggcute", rom_addresses["Wild_SafariZoneEast"] + 11,
                 None, event=True, type="Wild Encounter", level=23),
    LocationData("Safari Zone East", "Wild Pokemon - 7", ["Nidoran F", "Nidoran M"],
                 rom_addresses["Wild_SafariZoneEast"] + 13, None, event=True, type="Wild Encounter", level=24),
    LocationData("Safari Zone East", "Wild Pokemon - 8", "Parasect", rom_addresses["Wild_SafariZoneEast"] + 15,
                 None, event=True, type="Wild Encounter", level=25),
    LocationData("Safari Zone East", "Wild Pokemon - 9", "Kangaskhan", rom_addresses["Wild_SafariZoneEast"] + 17,
                 None, event=True, type="Wild Encounter", level=25),
    LocationData("Safari Zone East", "Wild Pokemon - 10", ["Scyther", "Pinsir"],
                 rom_addresses["Wild_SafariZoneEast"] + 19, None, event=True, type="Wild Encounter", level=28),
    LocationData("Safari Zone North", "Wild Pokemon - 1", ["Nidoran M", "Nidoran F"],
                 rom_addresses["Wild_SafariZoneNorth"] + 1, None, event=True, type="Wild Encounter", level=22),
    LocationData("Safari Zone North", "Wild Pokemon - 2", "Rhyhorn", rom_addresses["Wild_SafariZoneNorth"] + 3,
                 None, event=True, type="Wild Encounter", level=26),
    LocationData("Safari Zone North", "Wild Pokemon - 3", "Paras", rom_addresses["Wild_SafariZoneNorth"] + 5, None,
                 event=True, type="Wild Encounter", level=23),
    LocationData("Safari Zone North", "Wild Pokemon - 4", "Exeggcute", rom_addresses["Wild_SafariZoneNorth"] + 7,
                 None, event=True, type="Wild Encounter", level=25),
    LocationData("Safari Zone North", "Wild Pokemon - 5", ["Nidorino", "Nidorina"],
                 rom_addresses["Wild_SafariZoneNorth"] + 9, None, event=True, type="Wild Encounter", level=30),
    LocationData("Safari Zone North", "Wild Pokemon - 6", "Exeggcute", rom_addresses["Wild_SafariZoneNorth"] + 11,
                 None, event=True, type="Wild Encounter", level=27),
    LocationData("Safari Zone North", "Wild Pokemon - 7", ["Nidorina", "Nidorino"],
                 rom_addresses["Wild_SafariZoneNorth"] + 13, None, event=True, type="Wild Encounter", level=30),
    LocationData("Safari Zone North", "Wild Pokemon - 8", "Venomoth", rom_addresses["Wild_SafariZoneNorth"] + 15,
                 None, event=True, type="Wild Encounter", level=32),
    LocationData("Safari Zone North", "Wild Pokemon - 9", "Chansey", rom_addresses["Wild_SafariZoneNorth"] + 17,
                 None, event=True, type="Wild Encounter", level=26),
    LocationData("Safari Zone North", "Wild Pokemon - 10", "Tauros", rom_addresses["Wild_SafariZoneNorth"] + 19,
                 None, event=True, type="Wild Encounter", level=28),
    LocationData("Safari Zone West-Wild", "Wild Pokemon - 1", ["Nidoran M", "Nidoran F"],
                 rom_addresses["Wild_SafariZoneWest"] + 1, None, event=True, type="Wild Encounter", level=25),
    LocationData("Safari Zone West-Wild", "Wild Pokemon - 2", "Doduo", rom_addresses["Wild_SafariZoneWest"] + 3, None,
                 event=True, type="Wild Encounter", level=26),
    LocationData("Safari Zone West-Wild", "Wild Pokemon - 3", "Venonat", rom_addresses["Wild_SafariZoneWest"] + 5, None,
                 event=True, type="Wild Encounter", level=23),
    LocationData("Safari Zone West-Wild", "Wild Pokemon - 4", "Exeggcute", rom_addresses["Wild_SafariZoneWest"] + 7,
                 None, event=True, type="Wild Encounter", level=24),
    LocationData("Safari Zone West-Wild", "Wild Pokemon - 5", ["Nidorino", "Nidorina"],
                 rom_addresses["Wild_SafariZoneWest"] + 9, None, event=True, type="Wild Encounter", level=33),
    LocationData("Safari Zone West-Wild", "Wild Pokemon - 6", "Exeggcute", rom_addresses["Wild_SafariZoneWest"] + 11,
                 None, event=True, type="Wild Encounter", level=26),
    LocationData("Safari Zone West-Wild", "Wild Pokemon - 7", ["Nidoran F", "Nidoran M"],
                 rom_addresses["Wild_SafariZoneWest"] + 13, None, event=True, type="Wild Encounter", level=25),
    LocationData("Safari Zone West-Wild", "Wild Pokemon - 8", "Venomoth", rom_addresses["Wild_SafariZoneWest"] + 15,
                 None, event=True, type="Wild Encounter", level=31),
    LocationData("Safari Zone West-Wild", "Wild Pokemon - 9", "Tauros", rom_addresses["Wild_SafariZoneWest"] + 17, None,
                 event=True, type="Wild Encounter", level=26),
    LocationData("Safari Zone West-Wild", "Wild Pokemon - 10", "Kangaskhan", rom_addresses["Wild_SafariZoneWest"] + 19,
                 None, event=True, type="Wild Encounter", level=28),
    LocationData("Route 19/20-Water", "Surf Pokemon - 1", "Tentacool", rom_addresses["Wild_SeaRoutes"] + 1, None,
                 event=True, type="Wild Encounter", level=5),
    LocationData("Route 19/20-Water", "Surf Pokemon - 2", "Tentacool", rom_addresses["Wild_SeaRoutes"] + 3, None,
                 event=True, type="Wild Encounter", level=10),
    LocationData("Route 19/20-Water", "Surf Pokemon - 3", "Tentacool", rom_addresses["Wild_SeaRoutes"] + 5, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Route 19/20-Water", "Surf Pokemon - 4", "Tentacool", rom_addresses["Wild_SeaRoutes"] + 7, None,
                 event=True, type="Wild Encounter", level=5),
    LocationData("Route 19/20-Water", "Surf Pokemon - 5", "Tentacool", rom_addresses["Wild_SeaRoutes"] + 9, None,
                 event=True, type="Wild Encounter", level=10),
    LocationData("Route 19/20-Water", "Surf Pokemon - 6", "Tentacool", rom_addresses["Wild_SeaRoutes"] + 11, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Route 19/20-Water", "Surf Pokemon - 7", "Tentacool", rom_addresses["Wild_SeaRoutes"] + 13, None,
                 event=True, type="Wild Encounter", level=20),
    LocationData("Route 19/20-Water", "Surf Pokemon - 8", "Tentacool", rom_addresses["Wild_SeaRoutes"] + 15, None,
                 event=True, type="Wild Encounter", level=30),
    LocationData("Route 19/20-Water", "Surf Pokemon - 9", "Tentacool", rom_addresses["Wild_SeaRoutes"] + 17, None,
                 event=True, type="Wild Encounter", level=35),
    LocationData("Route 19/20-Water", "Surf Pokemon - 10", "Tentacool", rom_addresses["Wild_SeaRoutes"] + 19, None,
                 event=True, type="Wild Encounter", level=40),
    LocationData("Route 21", "Surf Pokemon - 1", "Tentacool", rom_addresses["Wild_Surf_Route21"] + 1, None,
                 event=True, type="Wild Encounter", level=5),
    LocationData("Route 21", "Surf Pokemon - 2", "Tentacool", rom_addresses["Wild_Surf_Route21"] + 3, None,
                 event=True, type="Wild Encounter", level=10),
    LocationData("Route 21", "Surf Pokemon - 3", "Tentacool", rom_addresses["Wild_Surf_Route21"] + 5, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Route 21", "Surf Pokemon - 4", "Tentacool", rom_addresses["Wild_Surf_Route21"] + 7, None,
                 event=True, type="Wild Encounter", level=5),
    LocationData("Route 21", "Surf Pokemon - 5", "Tentacool", rom_addresses["Wild_Surf_Route21"] + 9, None,
                 event=True, type="Wild Encounter", level=10),
    LocationData("Route 21", "Surf Pokemon - 6", "Tentacool", rom_addresses["Wild_Surf_Route21"] + 11, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Route 21", "Surf Pokemon - 7", "Tentacool", rom_addresses["Wild_Surf_Route21"] + 13, None,
                 event=True, type="Wild Encounter", level=20),
    LocationData("Route 21", "Surf Pokemon - 8", "Tentacool", rom_addresses["Wild_Surf_Route21"] + 15, None,
                 event=True, type="Wild Encounter", level=30),
    LocationData("Route 21", "Surf Pokemon - 9", "Tentacool", rom_addresses["Wild_Surf_Route21"] + 17, None,
                 event=True, type="Wild Encounter", level=35),
    LocationData("Route 21", "Surf Pokemon - 10", "Tentacool", rom_addresses["Wild_Surf_Route21"] + 19, None,
                 event=True, type="Wild Encounter", level=40),
    LocationData("Seafoam Islands 1F-Wild", "Wild Pokemon - 1", "Seel", rom_addresses["Wild_SeafoamIslands1F"] + 1, None,
                 event=True, type="Wild Encounter", level=30),
    LocationData("Seafoam Islands 1F-Wild", "Wild Pokemon - 2", ["Slowpoke", "Psyduck"],
                 rom_addresses["Wild_SeafoamIslands1F"] + 3, None, event=True, type="Wild Encounter", level=30),
    LocationData("Seafoam Islands 1F-Wild", "Wild Pokemon - 3", ["Shellder", "Staryu"],
                 rom_addresses["Wild_SeafoamIslands1F"] + 5, None, event=True, type="Wild Encounter", level=30),
    LocationData("Seafoam Islands 1F-Wild", "Wild Pokemon - 4", ["Horsea", "Krabby"],
                 rom_addresses["Wild_SeafoamIslands1F"] + 7, None, event=True, type="Wild Encounter", level=30),
    LocationData("Seafoam Islands 1F-Wild", "Wild Pokemon - 5", ["Horsea", "Krabby"],
                 rom_addresses["Wild_SeafoamIslands1F"] + 9, None, event=True, type="Wild Encounter", level=28),
    LocationData("Seafoam Islands 1F-Wild", "Wild Pokemon - 6", "Zubat", rom_addresses["Wild_SeafoamIslands1F"] + 11,
                 None, event=True, type="Wild Encounter", level=21),
    LocationData("Seafoam Islands 1F-Wild", "Wild Pokemon - 7", "Golbat", rom_addresses["Wild_SeafoamIslands1F"] + 13,
                 None, event=True, type="Wild Encounter", level=29),
    LocationData("Seafoam Islands 1F-Wild", "Wild Pokemon - 8", ["Psyduck", "Slowpoke"],
                 rom_addresses["Wild_SeafoamIslands1F"] + 15, None, event=True, type="Wild Encounter", level=28),
    LocationData("Seafoam Islands 1F-Wild", "Wild Pokemon - 9", ["Shellder", "Staryu"],
                 rom_addresses["Wild_SeafoamIslands1F"] + 17, None, event=True, type="Wild Encounter", level=28),
    LocationData("Seafoam Islands 1F-Wild", "Wild Pokemon - 10", ["Golduck", "Slowbro"],
                 rom_addresses["Wild_SeafoamIslands1F"] + 19, None, event=True, type="Wild Encounter", level=38),
    LocationData("Seafoam Islands B1F-Wild", "Wild Pokemon - 1", ["Staryu", "Shellder"],
                 rom_addresses["Wild_SeafoamIslandsB1F"] + 1, None, event=True, type="Wild Encounter", level=30),
    LocationData("Seafoam Islands B1F-Wild", "Wild Pokemon - 2", ["Horsea", "Krabby"],
                 rom_addresses["Wild_SeafoamIslandsB1F"] + 3, None, event=True, type="Wild Encounter", level=30),
    LocationData("Seafoam Islands B1F-Wild", "Wild Pokemon - 3", ["Shellder", "Staryu"],
                 rom_addresses["Wild_SeafoamIslandsB1F"] + 5, None, event=True, type="Wild Encounter", level=32),
    LocationData("Seafoam Islands B1F-Wild", "Wild Pokemon - 4", ["Horsea", "Krabby"],
                 rom_addresses["Wild_SeafoamIslandsB1F"] + 7, None, event=True, type="Wild Encounter", level=32),
    LocationData("Seafoam Islands B1F-Wild", "Wild Pokemon - 5", ["Slowpoke", "Psyduck"],
                 rom_addresses["Wild_SeafoamIslandsB1F"] + 9, None, event=True, type="Wild Encounter", level=28),
    LocationData("Seafoam Islands B1F-Wild", "Wild Pokemon - 6", "Seel", rom_addresses["Wild_SeafoamIslandsB1F"] + 11,
                 None, event=True, type="Wild Encounter", level=30),
    LocationData("Seafoam Islands B1F-Wild", "Wild Pokemon - 7", ["Slowpoke", "Psyduck"],
                 rom_addresses["Wild_SeafoamIslandsB1F"] + 13, None, event=True, type="Wild Encounter", level=30),
    LocationData("Seafoam Islands B1F-Wild", "Wild Pokemon - 8", "Seel", rom_addresses["Wild_SeafoamIslandsB1F"] + 15,
                 None, event=True, type="Wild Encounter", level=28),
    LocationData("Seafoam Islands B1F-Wild", "Wild Pokemon - 9", "Dewgong", rom_addresses["Wild_SeafoamIslandsB1F"] + 17,
                 None, event=True, type="Wild Encounter", level=38),
    LocationData("Seafoam Islands B1F-Wild", "Wild Pokemon - 10", ["Seadra", "Kingler"],
                 rom_addresses["Wild_SeafoamIslandsB1F"] + 19, None, event=True, type="Wild Encounter", level=37),
    LocationData("Seafoam Islands B2F-Wild", "Wild Pokemon - 1", "Seel", rom_addresses["Wild_SeafoamIslandsB2F"] + 1,
                 None, event=True, type="Wild Encounter", level=30),
    LocationData("Seafoam Islands B2F-Wild", "Wild Pokemon - 2", ["Slowpoke", "Psyduck"],
                 rom_addresses["Wild_SeafoamIslandsB2F"] + 3, None, event=True, type="Wild Encounter", level=30),
    LocationData("Seafoam Islands B2F-Wild", "Wild Pokemon - 3", "Seel", rom_addresses["Wild_SeafoamIslandsB2F"] + 5,
                 None, event=True, type="Wild Encounter", level=32),
    LocationData("Seafoam Islands B2F-Wild", "Wild Pokemon - 4", ["Slowpoke", "Psyduck"],
                 rom_addresses["Wild_SeafoamIslandsB2F"] + 7, None, event=True, type="Wild Encounter", level=32),
    LocationData("Seafoam Islands B2F-Wild", "Wild Pokemon - 5", ["Horsea", "Krabby"],
                 rom_addresses["Wild_SeafoamIslandsB2F"] + 9, None, event=True, type="Wild Encounter", level=28),
    LocationData("Seafoam Islands B2F-Wild", "Wild Pokemon - 6", ["Staryu", "Shellder"],
                 rom_addresses["Wild_SeafoamIslandsB2F"] + 11, None, event=True, type="Wild Encounter", level=30),
    LocationData("Seafoam Islands B2F-Wild", "Wild Pokemon - 7", ["Horsea", "Krabby"],
                 rom_addresses["Wild_SeafoamIslandsB2F"] + 13, None, event=True, type="Wild Encounter", level=30),
    LocationData("Seafoam Islands B2F-Wild", "Wild Pokemon - 8", ["Shellder", "Staryu"],
                 rom_addresses["Wild_SeafoamIslandsB2F"] + 15, None, event=True, type="Wild Encounter", level=28),
    LocationData("Seafoam Islands B2F-Wild", "Wild Pokemon - 9", "Golbat", rom_addresses["Wild_SeafoamIslandsB2F"] + 17,
                 None, event=True, type="Wild Encounter", level=30),
    LocationData("Seafoam Islands B2F-Wild", "Wild Pokemon - 10", ["Slowbro", "Golduck"],
                 rom_addresses["Wild_SeafoamIslandsB2F"] + 19, None, event=True, type="Wild Encounter", level=37),
    LocationData("Seafoam Islands B3F-Wild", "Wild Pokemon - 1", ["Slowpoke", "Psyduck"],
                 rom_addresses["Wild_SeafoamIslandsB3F"] + 1, None, event=True, type="Wild Encounter", level=31),
    LocationData("Seafoam Islands B3F-Wild", "Wild Pokemon - 2", "Seel", rom_addresses["Wild_SeafoamIslandsB3F"] + 3,
                 None, event=True, type="Wild Encounter", level=31),
    LocationData("Seafoam Islands B3F-Wild", "Wild Pokemon - 3", ["Slowpoke", "Psyduck"],
                 rom_addresses["Wild_SeafoamIslandsB3F"] + 5, None, event=True, type="Wild Encounter", level=33),
    LocationData("Seafoam Islands B3F-Wild", "Wild Pokemon - 4", "Seel", rom_addresses["Wild_SeafoamIslandsB3F"] + 7,
                 None, event=True, type="Wild Encounter", level=33),
    LocationData("Seafoam Islands B3F-Wild", "Wild Pokemon - 5", ["Horsea", "Krabby"],
                 rom_addresses["Wild_SeafoamIslandsB3F"] + 9, None, event=True, type="Wild Encounter", level=29),
    LocationData("Seafoam Islands B3F-Wild", "Wild Pokemon - 6", ["Shellder", "Staryu"],
                 rom_addresses["Wild_SeafoamIslandsB3F"] + 11, None, event=True, type="Wild Encounter", level=31),
    LocationData("Seafoam Islands B3F-Wild", "Wild Pokemon - 7", ["Horsea", "Krabby"],
                 rom_addresses["Wild_SeafoamIslandsB3F"] + 13, None, event=True, type="Wild Encounter", level=31),
    LocationData("Seafoam Islands B3F-Wild", "Wild Pokemon - 8", ["Shellder", "Staryu"],
                 rom_addresses["Wild_SeafoamIslandsB3F"] + 15, None, event=True, type="Wild Encounter", level=29),
    LocationData("Seafoam Islands B3F-Wild", "Wild Pokemon - 9", ["Seadra", "Kingler"],
                 rom_addresses["Wild_SeafoamIslandsB3F"] + 17, None, event=True, type="Wild Encounter", level=39),
    LocationData("Seafoam Islands B3F-Wild", "Wild Pokemon - 10", "Dewgong",
                 rom_addresses["Wild_SeafoamIslandsB3F"] + 19, None, event=True, type="Wild Encounter", level=37),
    LocationData("Seafoam Islands B4F", "Wild Pokemon - 1", ["Horsea", "Krabby"],
                 rom_addresses["Wild_SeafoamIslandsB4F"] + 1, None, event=True, type="Wild Encounter", level=31),
    LocationData("Seafoam Islands B4F", "Wild Pokemon - 2", ["Shellder", "Staryu"],
                 rom_addresses["Wild_SeafoamIslandsB4F"] + 3, None, event=True, type="Wild Encounter", level=31),
    LocationData("Seafoam Islands B4F", "Wild Pokemon - 3", ["Horsea", "Krabby"],
                 rom_addresses["Wild_SeafoamIslandsB4F"] + 5, None, event=True, type="Wild Encounter", level=33),
    LocationData("Seafoam Islands B4F", "Wild Pokemon - 4", "Shellder", rom_addresses["Wild_SeafoamIslandsB4F"] + 7,
                 None, event=True, type="Wild Encounter", level=33),
    LocationData("Seafoam Islands B4F", "Wild Pokemon - 5", ["Slowpoke", "Psyduck"],
                 rom_addresses["Wild_SeafoamIslandsB4F"] + 9, None, event=True, type="Wild Encounter", level=29),
    LocationData("Seafoam Islands B4F", "Wild Pokemon - 6", "Seel", rom_addresses["Wild_SeafoamIslandsB4F"] + 11,
                 None, event=True, type="Wild Encounter", level=31),
    LocationData("Seafoam Islands B4F", "Wild Pokemon - 7", ["Slowpoke", "Psyduck"],
                 rom_addresses["Wild_SeafoamIslandsB4F"] + 13, None, event=True, type="Wild Encounter", level=31),
    LocationData("Seafoam Islands B4F", "Wild Pokemon - 8", "Seel", rom_addresses["Wild_SeafoamIslandsB4F"] + 15,
                 None, event=True, type="Wild Encounter", level=29),
    LocationData("Seafoam Islands B4F", "Wild Pokemon - 9", ["Slowbro", "Golduck"],
                 rom_addresses["Wild_SeafoamIslandsB4F"] + 17, None, event=True, type="Wild Encounter", level=39),
    LocationData("Seafoam Islands B4F", "Wild Pokemon - 10", "Golbat", rom_addresses["Wild_SeafoamIslandsB4F"] + 19,
                 None, event=True, type="Wild Encounter", level=32),
    LocationData("Pokemon Mansion 1F-Wild", "Wild Pokemon - 1", ["Koffing", "Grimer"],
                 rom_addresses["Wild_PokemonMansion1F"] + 1, None, event=True, type="Wild Encounter", level=32),
    LocationData("Pokemon Mansion 1F-Wild", "Wild Pokemon - 2", ["Koffing", "Grimer"],
                 rom_addresses["Wild_PokemonMansion1F"] + 3, None, event=True, type="Wild Encounter", level=30),
    LocationData("Pokemon Mansion 1F-Wild", "Wild Pokemon - 3", "Ponyta", rom_addresses["Wild_PokemonMansion1F"] + 5,
                 None, event=True, type="Wild Encounter", level=34),
    LocationData("Pokemon Mansion 1F-Wild", "Wild Pokemon - 4", "Ponyta", rom_addresses["Wild_PokemonMansion1F"] + 7,
                 None, event=True, type="Wild Encounter", level=30),
    LocationData("Pokemon Mansion 1F-Wild", "Wild Pokemon - 5", ["Growlithe", "Vulpix"],
                 rom_addresses["Wild_PokemonMansion1F"] + 9, None, event=True, type="Wild Encounter", level=34),
    LocationData("Pokemon Mansion 1F-Wild", "Wild Pokemon - 6", "Ponyta", rom_addresses["Wild_PokemonMansion1F"] + 11,
                 None, event=True, type="Wild Encounter", level=32),
    LocationData("Pokemon Mansion 1F-Wild", "Wild Pokemon - 7", ["Grimer", "Koffing"],
                 rom_addresses["Wild_PokemonMansion1F"] + 13, None, event=True, type="Wild Encounter", level=30),
    LocationData("Pokemon Mansion 1F-Wild", "Wild Pokemon - 8", "Ponyta", rom_addresses["Wild_PokemonMansion1F"] + 15,
                 None, event=True, type="Wild Encounter", level=28),
    LocationData("Pokemon Mansion 1F-Wild", "Wild Pokemon - 9", ["Weezing", "Muk"],
                 rom_addresses["Wild_PokemonMansion1F"] + 17, None, event=True, type="Wild Encounter", level=37),
    LocationData("Pokemon Mansion 1F-Wild", "Wild Pokemon - 10", ["Muk", "Weezing"],
                 rom_addresses["Wild_PokemonMansion1F"] + 19, None, event=True, type="Wild Encounter", level=39),
    LocationData("Pokemon Mansion 2F-Wild", "Wild Pokemon - 1", ["Growlithe", "Vulpix"],
                 rom_addresses["Wild_PokemonMansion2F"] + 1, None, event=True, type="Wild Encounter", level=32),
    LocationData("Pokemon Mansion 2F-Wild", "Wild Pokemon - 2", ["Koffing", "Grimer"],
                 rom_addresses["Wild_PokemonMansion2F"] + 3, None, event=True, type="Wild Encounter", level=34),
    LocationData("Pokemon Mansion 2F-Wild", "Wild Pokemon - 3", ["Koffing", "Grimer"],
                 rom_addresses["Wild_PokemonMansion2F"] + 5, None, event=True, type="Wild Encounter", level=34),
    LocationData("Pokemon Mansion 2F-Wild", "Wild Pokemon - 4", "Ponyta", rom_addresses["Wild_PokemonMansion2F"] + 7,
                 None, event=True, type="Wild Encounter", level=30),
    LocationData("Pokemon Mansion 2F-Wild", "Wild Pokemon - 5", ["Koffing", "Grimer"],
                 rom_addresses["Wild_PokemonMansion2F"] + 9, None, event=True, type="Wild Encounter", level=30),
    LocationData("Pokemon Mansion 2F-Wild", "Wild Pokemon - 6", "Ponyta", rom_addresses["Wild_PokemonMansion2F"] + 11,
                 None, event=True, type="Wild Encounter", level=32),
    LocationData("Pokemon Mansion 2F-Wild", "Wild Pokemon - 7", ["Grimer", "Koffing"],
                 rom_addresses["Wild_PokemonMansion2F"] + 13, None, event=True, type="Wild Encounter", level=30),
    LocationData("Pokemon Mansion 2F-Wild", "Wild Pokemon - 8", "Ponyta", rom_addresses["Wild_PokemonMansion2F"] + 15,
                 None, event=True, type="Wild Encounter", level=28),
    LocationData("Pokemon Mansion 2F-Wild", "Wild Pokemon - 9", ["Weezing", "Muk"],
                 rom_addresses["Wild_PokemonMansion2F"] + 17, None, event=True, type="Wild Encounter", level=39),
    LocationData("Pokemon Mansion 2F-Wild", "Wild Pokemon - 10", ["Muk", "Weezing"],
                 rom_addresses["Wild_PokemonMansion2F"] + 19, None, event=True, type="Wild Encounter", level=37),
    LocationData("Pokemon Mansion 3F-Wild", "Wild Pokemon - 1", ["Koffing", "Grimer"],
                 rom_addresses["Wild_PokemonMansion3F"] + 1, None, event=True, type="Wild Encounter", level=31),
    LocationData("Pokemon Mansion 3F-Wild", "Wild Pokemon - 2", ["Growlithe", "Vulpix"],
                 rom_addresses["Wild_PokemonMansion3F"] + 3, None, event=True, type="Wild Encounter", level=33),
    LocationData("Pokemon Mansion 3F-Wild", "Wild Pokemon - 3", ["Koffing", "Grimer"],
                 rom_addresses["Wild_PokemonMansion3F"] + 5, None, event=True, type="Wild Encounter", level=35),
    LocationData("Pokemon Mansion 3F-Wild", "Wild Pokemon - 4", "Ponyta", rom_addresses["Wild_PokemonMansion3F"] + 7,
                 None, event=True, type="Wild Encounter", level=32),
    LocationData("Pokemon Mansion 3F-Wild", "Wild Pokemon - 5", ["Ponyta", "Magmar"],
                 rom_addresses["Wild_PokemonMansion3F"] + 9, None, event=True, type="Wild Encounter", level=34),
    LocationData("Pokemon Mansion 3F-Wild", "Wild Pokemon - 6", ["Weezing", "Muk"],
                 rom_addresses["Wild_PokemonMansion3F"] + 11, None, event=True, type="Wild Encounter", level=40),
    LocationData("Pokemon Mansion 3F-Wild", "Wild Pokemon - 7", ["Grimer", "Koffing"],
                 rom_addresses["Wild_PokemonMansion3F"] + 13, None, event=True, type="Wild Encounter", level=34),
    LocationData("Pokemon Mansion 3F-Wild", "Wild Pokemon - 8", ["Weezing", "Muk"],
                 rom_addresses["Wild_PokemonMansion3F"] + 15, None, event=True, type="Wild Encounter", level=38),
    LocationData("Pokemon Mansion 3F-Wild", "Wild Pokemon - 9", "Ponyta", rom_addresses["Wild_PokemonMansion3F"] + 17,
                 None, event=True, type="Wild Encounter", level=36),
    LocationData("Pokemon Mansion 3F-Wild", "Wild Pokemon - 10", ["Muk", "Weezing"],
                 rom_addresses["Wild_PokemonMansion3F"] + 19, None, event=True, type="Wild Encounter", level=42),
    LocationData("Pokemon Mansion B1F", "Wild Pokemon - 1", ["Koffing", "Grimer"],
                 rom_addresses["Wild_PokemonMansionB1F"] + 1, None, event=True, type="Wild Encounter", level=33),
    LocationData("Pokemon Mansion B1F", "Wild Pokemon - 2", ["Koffing", "Grimer"],
                 rom_addresses["Wild_PokemonMansionB1F"] + 3, None, event=True, type="Wild Encounter", level=31),
    LocationData("Pokemon Mansion B1F", "Wild Pokemon - 3", ["Growlithe", "Vulpix"],
                 rom_addresses["Wild_PokemonMansionB1F"] + 5, None, event=True, type="Wild Encounter", level=35),
    LocationData("Pokemon Mansion B1F", "Wild Pokemon - 4", "Ponyta", rom_addresses["Wild_PokemonMansionB1F"] + 7,
                 None, event=True, type="Wild Encounter", level=32),
    LocationData("Pokemon Mansion B1F", "Wild Pokemon - 5", ["Koffing", "Grimer"],
                 rom_addresses["Wild_PokemonMansionB1F"] + 9, None, event=True, type="Wild Encounter", level=31),
    LocationData("Pokemon Mansion B1F", "Wild Pokemon - 6", ["Weezing", "Muk"],
                 rom_addresses["Wild_PokemonMansionB1F"] + 11, None, event=True, type="Wild Encounter", level=40),
    LocationData("Pokemon Mansion B1F", "Wild Pokemon - 7", "Ponyta", rom_addresses["Wild_PokemonMansionB1F"] + 13,
                 None, event=True, type="Wild Encounter", level=34),
    LocationData("Pokemon Mansion B1F", "Wild Pokemon - 8", ["Grimer", "Koffing"],
                 rom_addresses["Wild_PokemonMansionB1F"] + 15, None, event=True, type="Wild Encounter", level=35),
    LocationData("Pokemon Mansion B1F", "Wild Pokemon - 9", ["Weezing", "Magmar"],
                 rom_addresses["Wild_PokemonMansionB1F"] + 17, None, event=True, type="Wild Encounter", level=42),
    LocationData("Pokemon Mansion B1F", "Wild Pokemon - 10", ["Muk", "Weezing"],
                 rom_addresses["Wild_PokemonMansionB1F"] + 19, None, event=True, type="Wild Encounter", level=42),
    LocationData("Route 21", "Wild Pokemon - 1", "Rattata", rom_addresses["Wild_Route21"] + 1, None, event=True,
                 type="Wild Encounter", level=21),
    LocationData("Route 21", "Wild Pokemon - 2", "Pidgey", rom_addresses["Wild_Route21"] + 3, None, event=True,
                 type="Wild Encounter", level=23),
    LocationData("Route 21", "Wild Pokemon - 3", "Raticate", rom_addresses["Wild_Route21"] + 5, None, event=True,
                 type="Wild Encounter", level=30),
    LocationData("Route 21", "Wild Pokemon - 4", "Rattata", rom_addresses["Wild_Route21"] + 7, None, event=True,
                 type="Wild Encounter", level=23),
    LocationData("Route 21", "Wild Pokemon - 5", "Pidgey", rom_addresses["Wild_Route21"] + 9, None, event=True,
                 type="Wild Encounter", level=21),
    LocationData("Route 21", "Wild Pokemon - 6", "Pidgeotto", rom_addresses["Wild_Route21"] + 11, None, event=True,
                 type="Wild Encounter", level=30),
    LocationData("Route 21", "Wild Pokemon - 7", "Pidgeotto", rom_addresses["Wild_Route21"] + 13, None, event=True,
                 type="Wild Encounter", level=32),
    LocationData("Route 21", "Wild Pokemon - 8", "Tangela", rom_addresses["Wild_Route21"] + 15, None, event=True,
                 type="Wild Encounter", level=28),
    LocationData("Route 21", "Wild Pokemon - 9", "Tangela", rom_addresses["Wild_Route21"] + 17, None, event=True,
                 type="Wild Encounter", level=30),
    LocationData("Route 21", "Wild Pokemon - 10", "Tangela", rom_addresses["Wild_Route21"] + 19, None, event=True,
                 type="Wild Encounter", level=32),
    LocationData("Cerulean Cave 1F-Wild", "Wild Pokemon - 1", "Golbat", rom_addresses["Wild_CeruleanCave1F"] + 1, None,
                 event=True, type="Wild Encounter", level=46),
    LocationData("Cerulean Cave 1F-Wild", "Wild Pokemon - 2", "Hypno", rom_addresses["Wild_CeruleanCave1F"] + 3, None,
                 event=True, type="Wild Encounter", level=46),
    LocationData("Cerulean Cave 1F-Wild", "Wild Pokemon - 3", "Magneton", rom_addresses["Wild_CeruleanCave1F"] + 5,
                 None, event=True, type="Wild Encounter", level=46),
    LocationData("Cerulean Cave 1F-Wild", "Wild Pokemon - 4", "Dodrio", rom_addresses["Wild_CeruleanCave1F"] + 7, None,
                 event=True, type="Wild Encounter", level=49),
    LocationData("Cerulean Cave 1F-Wild", "Wild Pokemon - 5", "Venomoth", rom_addresses["Wild_CeruleanCave1F"] + 9,
                 None, event=True, type="Wild Encounter", level=49),
    LocationData("Cerulean Cave 1F-Wild", "Wild Pokemon - 6", ["Arbok", "Sandslash"],
                 rom_addresses["Wild_CeruleanCave1F"] + 11, None, event=True, type="Wild Encounter", level=52),
    LocationData("Cerulean Cave 1F-Wild", "Wild Pokemon - 7", "Kadabra", rom_addresses["Wild_CeruleanCave1F"] + 13,
                 None, event=True, type="Wild Encounter", level=49),
    LocationData("Cerulean Cave 1F-Wild", "Wild Pokemon - 8", "Parasect", rom_addresses["Wild_CeruleanCave1F"] + 15,
                 None, event=True, type="Wild Encounter", level=52),
    LocationData("Cerulean Cave 1F-Wild", "Wild Pokemon - 9", "Raichu", rom_addresses["Wild_CeruleanCave1F"] + 17, None,
                 event=True, type="Wild Encounter", level=53),
    LocationData("Cerulean Cave 1F-Wild", "Wild Pokemon - 10", "Ditto", rom_addresses["Wild_CeruleanCave1F"] + 19, None,
                 event=True, type="Wild Encounter", level=53),
    LocationData("Cerulean Cave 2F-Wild", "Wild Pokemon - 1", "Dodrio", rom_addresses["Wild_CeruleanCave2F"] + 1, None,
                 event=True, type="Wild Encounter", level=51),
    LocationData("Cerulean Cave 2F-Wild", "Wild Pokemon - 2", "Venomoth", rom_addresses["Wild_CeruleanCave2F"] + 3,
                 None, event=True, type="Wild Encounter", level=51),
    LocationData("Cerulean Cave 2F-Wild", "Wild Pokemon - 3", "Kadabra", rom_addresses["Wild_CeruleanCave2F"] + 5, None,
                 event=True, type="Wild Encounter", level=51),
    LocationData("Cerulean Cave 2F-Wild", "Wild Pokemon - 4", "Rhydon", rom_addresses["Wild_CeruleanCave2F"] + 7, None,
                 event=True, type="Wild Encounter", level=52),
    LocationData("Cerulean Cave 2F-Wild", "Wild Pokemon - 5", "Marowak", rom_addresses["Wild_CeruleanCave2F"] + 9, None,
                 event=True, type="Wild Encounter", level=52),
    LocationData("Cerulean Cave 2F-Wild", "Wild Pokemon - 6", "Electrode", rom_addresses["Wild_CeruleanCave2F"] + 11,
                 None, event=True, type="Wild Encounter", level=52),
    LocationData("Cerulean Cave 2F-Wild", "Wild Pokemon - 7", "Chansey", rom_addresses["Wild_CeruleanCave2F"] + 13,
                 None, event=True, type="Wild Encounter", level=56),
    LocationData("Cerulean Cave 2F-Wild", "Wild Pokemon - 8", "Wigglytuff", rom_addresses["Wild_CeruleanCave2F"] + 15,
                 None, event=True, type="Wild Encounter", level=54),
    LocationData("Cerulean Cave 2F-Wild", "Wild Pokemon - 9", "Ditto", rom_addresses["Wild_CeruleanCave2F"] + 17, None,
                 event=True, type="Wild Encounter", level=55),
    LocationData("Cerulean Cave 2F-Wild", "Wild Pokemon - 10", "Ditto", rom_addresses["Wild_CeruleanCave2F"] + 19, None,
                 event=True, type="Wild Encounter", level=60),
    LocationData("Cerulean Cave B1F", "Wild Pokemon - 1", "Rhydon", rom_addresses["Wild_CeruleanCaveB1F"] + 1,
                 None, event=True, type="Wild Encounter", level=55),
    LocationData("Cerulean Cave B1F", "Wild Pokemon - 2", "Marowak", rom_addresses["Wild_CeruleanCaveB1F"] + 3,
                 None, event=True, type="Wild Encounter", level=55),
    LocationData("Cerulean Cave B1F", "Wild Pokemon - 3", "Electrode", rom_addresses["Wild_CeruleanCaveB1F"] + 5,
                 None, event=True, type="Wild Encounter", level=55),
    LocationData("Cerulean Cave B1F", "Wild Pokemon - 4", "Chansey", rom_addresses["Wild_CeruleanCaveB1F"] + 7,
                 None, event=True, type="Wild Encounter", level=64),
    LocationData("Cerulean Cave B1F", "Wild Pokemon - 5", "Parasect", rom_addresses["Wild_CeruleanCaveB1F"] + 9,
                 None, event=True, type="Wild Encounter", level=64),
    LocationData("Cerulean Cave B1F", "Wild Pokemon - 6", "Raichu", rom_addresses["Wild_CeruleanCaveB1F"] + 11,
                 None, event=True, type="Wild Encounter", level=64),
    LocationData("Cerulean Cave B1F", "Wild Pokemon - 7", ["Arbok", "Sandslash"],
                 rom_addresses["Wild_CeruleanCaveB1F"] + 13,
                 None, event=True, type="Wild Encounter", level=57),
    LocationData("Cerulean Cave B1F", "Wild Pokemon - 8", "Ditto", rom_addresses["Wild_CeruleanCaveB1F"] + 15,
                 None, event=True, type="Wild Encounter", level=65),
    LocationData("Cerulean Cave B1F", "Wild Pokemon - 9", "Ditto", rom_addresses["Wild_CeruleanCaveB1F"] + 17,
                 None, event=True, type="Wild Encounter", level=63),
    LocationData("Cerulean Cave B1F", "Wild Pokemon - 10", "Ditto", rom_addresses["Wild_CeruleanCaveB1F"] + 19,
                 None, event=True, type="Wild Encounter", level=67),
    LocationData("Power Plant", "Wild Pokemon - 1", "Voltorb", rom_addresses["Wild_PowerPlant"] + 1, None,
                 event=True, type="Wild Encounter", level=21),
    LocationData("Power Plant", "Wild Pokemon - 2", "Magnemite", rom_addresses["Wild_PowerPlant"] + 3, None,
                 event=True, type="Wild Encounter", level=21),
    LocationData("Power Plant", "Wild Pokemon - 3", "Pikachu", rom_addresses["Wild_PowerPlant"] + 5, None,
                 event=True, type="Wild Encounter", level=20),
    LocationData("Power Plant", "Wild Pokemon - 4", "Pikachu", rom_addresses["Wild_PowerPlant"] + 7, None,
                 event=True, type="Wild Encounter", level=24),
    LocationData("Power Plant", "Wild Pokemon - 5", "Magnemite", rom_addresses["Wild_PowerPlant"] + 9, None,
                 event=True, type="Wild Encounter", level=23),
    LocationData("Power Plant", "Wild Pokemon - 6", "Voltorb", rom_addresses["Wild_PowerPlant"] + 11, None,
                 event=True, type="Wild Encounter", level=23),
    LocationData("Power Plant", "Wild Pokemon - 7", "Magneton", rom_addresses["Wild_PowerPlant"] + 13, None,
                 event=True, type="Wild Encounter", level=32),
    LocationData("Power Plant", "Wild Pokemon - 8", "Magneton", rom_addresses["Wild_PowerPlant"] + 15, None,
                 event=True, type="Wild Encounter", level=35),
    LocationData("Power Plant", "Wild Pokemon - 9", ["Electabuzz", "Raichu"], rom_addresses["Wild_PowerPlant"] + 17,
                 None, event=True, type="Wild Encounter", level=33),
    LocationData("Power Plant", "Wild Pokemon - 10", ["Electabuzz", "Raichu"],
                 rom_addresses["Wild_PowerPlant"] + 19, None, event=True, type="Wild Encounter", level=36),
    LocationData("Route 23-Grass", "Wild Pokemon - 1", ["Ekans", "Sandshrew"], rom_addresses["Wild_Route23"] + 1,
                 None, event=True, type="Wild Encounter", level=26),
    LocationData("Route 23-Grass", "Wild Pokemon - 2", "Ditto", rom_addresses["Wild_Route23"] + 3, None, event=True,
                 type="Wild Encounter", level=33),
    LocationData("Route 23-Grass", "Wild Pokemon - 3", "Spearow", rom_addresses["Wild_Route23"] + 5, None,
                 event=True, type="Wild Encounter", level=26),
    LocationData("Route 23-Grass", "Wild Pokemon - 4", "Fearow", rom_addresses["Wild_Route23"] + 7, None,
                 event=True, type="Wild Encounter", level=38),
    LocationData("Route 23-Grass", "Wild Pokemon - 5", "Ditto", rom_addresses["Wild_Route23"] + 9, None, event=True,
                 type="Wild Encounter", level=38),
    LocationData("Route 23-Grass", "Wild Pokemon - 6", "Fearow", rom_addresses["Wild_Route23"] + 11, None,
                 event=True, type="Wild Encounter", level=38),
    LocationData("Route 23-Grass", "Wild Pokemon - 7", ["Arbok", "Sandslash"], rom_addresses["Wild_Route23"] + 13,
                 None, event=True, type="Wild Encounter", level=41),
    LocationData("Route 23-Grass", "Wild Pokemon - 8", "Ditto", rom_addresses["Wild_Route23"] + 15, None,
                 event=True, type="Wild Encounter", level=43),
    LocationData("Route 23-Grass", "Wild Pokemon - 9", "Fearow", rom_addresses["Wild_Route23"] + 17, None,
                 event=True, type="Wild Encounter", level=41),
    LocationData("Route 23-Grass", "Wild Pokemon - 10", "Fearow", rom_addresses["Wild_Route23"] + 19, None,
                 event=True, type="Wild Encounter", level=43),
    LocationData("Victory Road 2F-Wild", "Wild Pokemon - 1", "Machop", rom_addresses["Wild_VictoryRoad2F"] + 1, None,
                 event=True, type="Wild Encounter", level=22),
    LocationData("Victory Road 2F-Wild", "Wild Pokemon - 2", "Geodude", rom_addresses["Wild_VictoryRoad2F"] + 3, None,
                 event=True, type="Wild Encounter", level=24),
    LocationData("Victory Road 2F-Wild", "Wild Pokemon - 3", "Zubat", rom_addresses["Wild_VictoryRoad2F"] + 5, None,
                 event=True, type="Wild Encounter", level=26),
    LocationData("Victory Road 2F-Wild", "Wild Pokemon - 4", "Onix", rom_addresses["Wild_VictoryRoad2F"] + 7, None,
                 event=True, type="Wild Encounter", level=36),
    LocationData("Victory Road 2F-Wild", "Wild Pokemon - 5", "Onix", rom_addresses["Wild_VictoryRoad2F"] + 9, None,
                 event=True, type="Wild Encounter", level=39),
    LocationData("Victory Road 2F-Wild", "Wild Pokemon - 6", "Onix", rom_addresses["Wild_VictoryRoad2F"] + 11, None,
                 event=True, type="Wild Encounter", level=42),
    LocationData("Victory Road 2F-Wild", "Wild Pokemon - 7", "Machoke", rom_addresses["Wild_VictoryRoad2F"] + 13, None,
                 event=True, type="Wild Encounter", level=41),
    LocationData("Victory Road 2F-Wild", "Wild Pokemon - 8", "Golbat", rom_addresses["Wild_VictoryRoad2F"] + 15, None,
                 event=True, type="Wild Encounter", level=40),
    LocationData("Victory Road 2F-Wild", "Wild Pokemon - 9", "Marowak", rom_addresses["Wild_VictoryRoad2F"] + 17, None,
                 event=True, type="Wild Encounter", level=40),
    LocationData("Victory Road 2F-Wild", "Wild Pokemon - 10", "Graveler", rom_addresses["Wild_VictoryRoad2F"] + 19, None,
                 event=True, type="Wild Encounter", level=43),
    LocationData("Victory Road 3F-Wild", "Wild Pokemon - 1", "Machop", rom_addresses["Wild_VictoryRoad3F"] + 1, None,
                 event=True, type="Wild Encounter", level=24),
    LocationData("Victory Road 3F-Wild", "Wild Pokemon - 2", "Geodude", rom_addresses["Wild_VictoryRoad3F"] + 3, None,
                 event=True, type="Wild Encounter", level=26),
    LocationData("Victory Road 3F-Wild", "Wild Pokemon - 3", "Zubat", rom_addresses["Wild_VictoryRoad3F"] + 5, None,
                 event=True, type="Wild Encounter", level=22),
    LocationData("Victory Road 3F-Wild", "Wild Pokemon - 4", "Onix", rom_addresses["Wild_VictoryRoad3F"] + 7, None,
                 event=True, type="Wild Encounter", level=42),
    LocationData("Victory Road 3F-Wild", "Wild Pokemon - 5", "Venomoth", rom_addresses["Wild_VictoryRoad3F"] + 9, None,
                 event=True, type="Wild Encounter", level=40),
    LocationData("Victory Road 3F-Wild", "Wild Pokemon - 6", "Onix", rom_addresses["Wild_VictoryRoad3F"] + 11, None,
                 event=True, type="Wild Encounter", level=45),
    LocationData("Victory Road 3F-Wild", "Wild Pokemon - 7", "Graveler", rom_addresses["Wild_VictoryRoad3F"] + 13, None,
                 event=True, type="Wild Encounter", level=43),
    LocationData("Victory Road 3F-Wild", "Wild Pokemon - 8", "Golbat", rom_addresses["Wild_VictoryRoad3F"] + 15, None,
                 event=True, type="Wild Encounter", level=41),
    LocationData("Victory Road 3F-Wild", "Wild Pokemon - 9", "Machoke", rom_addresses["Wild_VictoryRoad3F"] + 17, None,
                 event=True, type="Wild Encounter", level=42),
    LocationData("Victory Road 3F-Wild", "Wild Pokemon - 10", "Machoke", rom_addresses["Wild_VictoryRoad3F"] + 19, None,
                 event=True, type="Wild Encounter", level=45),
    LocationData("Victory Road 1F-Wild", "Wild Pokemon - 1", "Machop", rom_addresses["Wild_VictoryRoad1F"] + 1, None,
                 event=True, type="Wild Encounter", level=24),
    LocationData("Victory Road 1F-Wild", "Wild Pokemon - 2", "Geodude", rom_addresses["Wild_VictoryRoad1F"] + 3, None,
                 event=True, type="Wild Encounter", level=26),
    LocationData("Victory Road 1F-Wild", "Wild Pokemon - 3", "Zubat", rom_addresses["Wild_VictoryRoad1F"] + 5, None,
                 event=True, type="Wild Encounter", level=22),
    LocationData("Victory Road 1F-Wild", "Wild Pokemon - 4", "Onix", rom_addresses["Wild_VictoryRoad1F"] + 7, None,
                 event=True, type="Wild Encounter", level=36),
    LocationData("Victory Road 1F-Wild", "Wild Pokemon - 5", "Onix", rom_addresses["Wild_VictoryRoad1F"] + 9, None,
                 event=True, type="Wild Encounter", level=39),
    LocationData("Victory Road 1F-Wild", "Wild Pokemon - 6", "Onix", rom_addresses["Wild_VictoryRoad1F"] + 11, None,
                 event=True, type="Wild Encounter", level=42),
    LocationData("Victory Road 1F-Wild", "Wild Pokemon - 7", "Graveler", rom_addresses["Wild_VictoryRoad1F"] + 13, None,
                 event=True, type="Wild Encounter", level=41),
    LocationData("Victory Road 1F-Wild", "Wild Pokemon - 8", "Golbat", rom_addresses["Wild_VictoryRoad1F"] + 15, None,
                 event=True, type="Wild Encounter", level=41),
    LocationData("Victory Road 1F-Wild", "Wild Pokemon - 9", "Machoke", rom_addresses["Wild_VictoryRoad1F"] + 17, None,
                 event=True, type="Wild Encounter", level=42),
    LocationData("Victory Road 1F-Wild", "Wild Pokemon - 10", "Marowak", rom_addresses["Wild_VictoryRoad1F"] + 19, None,
                 event=True, type="Wild Encounter", level=43),
    LocationData("Diglett's Cave", "Wild Pokemon - 1", "Diglett", rom_addresses["Wild_DiglettsCave"] + 1, None,
                 event=True, type="Wild Encounter", level=18),
    LocationData("Diglett's Cave", "Wild Pokemon - 2", "Diglett", rom_addresses["Wild_DiglettsCave"] + 3, None,
                 event=True, type="Wild Encounter", level=19),
    LocationData("Diglett's Cave", "Wild Pokemon - 3", "Diglett", rom_addresses["Wild_DiglettsCave"] + 5, None,
                 event=True, type="Wild Encounter", level=17),
    LocationData("Diglett's Cave", "Wild Pokemon - 4", "Diglett", rom_addresses["Wild_DiglettsCave"] + 7, None,
                 event=True, type="Wild Encounter", level=20),
    LocationData("Diglett's Cave", "Wild Pokemon - 5", "Diglett", rom_addresses["Wild_DiglettsCave"] + 9, None,
                 event=True, type="Wild Encounter", level=16),
    LocationData("Diglett's Cave", "Wild Pokemon - 6", "Diglett", rom_addresses["Wild_DiglettsCave"] + 11, None,
                 event=True, type="Wild Encounter", level=15),
    LocationData("Diglett's Cave", "Wild Pokemon - 7", "Diglett", rom_addresses["Wild_DiglettsCave"] + 13, None,
                 event=True, type="Wild Encounter", level=21),
    LocationData("Diglett's Cave", "Wild Pokemon - 8", "Diglett", rom_addresses["Wild_DiglettsCave"] + 15, None,
                 event=True, type="Wild Encounter", level=22),
    LocationData("Diglett's Cave", "Wild Pokemon - 9", "Dugtrio", rom_addresses["Wild_DiglettsCave"] + 17, None,
                 event=True, type="Wild Encounter", level=29),
    LocationData("Diglett's Cave", "Wild Pokemon - 10", "Dugtrio", rom_addresses["Wild_DiglettsCave"] + 19, None,
                 event=True, type="Wild Encounter", level=31),
    LocationData("Good Rod Fishing", "Good Rod Pokemon - 1", "Goldeen", rom_addresses["Wild_Good_Rod"] + 1, None,
                 event=True, type="Wild Encounter", level=10),
    LocationData("Good Rod Fishing", "Good Rod Pokemon - 2", "Poliwag", rom_addresses["Wild_Good_Rod"] + 3, None,
                 event=True, type="Wild Encounter", level=10),
    LocationData("Old Rod Fishing", "Old Rod Pokemon", "Magikarp", rom_addresses["Wild_Old_Rod"] + 1, None,
                 event=True, type="Wild Encounter", level=5, level_address=rom_addresses["Wild_Old_Rod"] + 2), #, level=5, level_after=True),


    # "Wild encounters" means a Pokemon you cannot miss or release and lose - re-use it for these
    LocationData("Celadon Prize Corner", "Pokemon Prize - 1", "Abra", [rom_addresses["Prize_Mon_A"],
                                                                       rom_addresses["Prize_Mon_A2"]], None, event=True,
                 type="Wild Encounter"),
    LocationData("Celadon Prize Corner", "Pokemon Prize - 2", "Clefairy", [rom_addresses["Prize_Mon_B"],
                                                                           rom_addresses["Prize_Mon_B2"]], None,
                 event=True, type="Wild Encounter"),
    LocationData("Celadon Prize Corner", "Pokemon Prize - 3", ["Nidorina", "Nidorino"], [rom_addresses["Prize_Mon_C"],
                                                                                         rom_addresses["Prize_Mon_C2"]],
                 None,
                 event=True, type="Wild Encounter"),
    LocationData("Celadon Prize Corner", "Pokemon Prize - 4", ["Dratini", "Pinsir"], [rom_addresses["Prize_Mon_D"],
                                                                                      rom_addresses["Prize_Mon_D2"]],
                 None, event=True, type="Wild Encounter"),
    LocationData("Celadon Prize Corner", "Pokemon Prize - 5", ["Scyther", "Dratini"], [rom_addresses["Prize_Mon_E"],
                                                                                       rom_addresses["Prize_Mon_E2"]],
                 None, event=True, type="Wild Encounter"),
    LocationData("Celadon Prize Corner", "Pokemon Prize - 6", "Porygon", [rom_addresses["Prize_Mon_F"],
                                                                          rom_addresses["Prize_Mon_F2"]], None,
                 event=True, type="Wild Encounter"),

    # counted for pokedex, because they cannot be permanently "missed" but not for HMs since they can be released
    # or evolved forms may not be able to learn the same HMs
    LocationData("Celadon Mansion Roof House", "Celadon Mansion Pokemon", "Eevee", rom_addresses["Gift_Eevee"], None,
                 event=True, type="Static Pokemon", level=25),
    LocationData("Silph Co 7F-NW", "Gift Pokemon", "Lapras", rom_addresses["Gift_Lapras"], None,
                 event=True, type="Static Pokemon", level=15),
    LocationData("Route 4 Pokemon Center", "Pokemon For Sale", "Magikarp", rom_addresses["Gift_Magikarp"], None,
                 event=True, type="Static Pokemon", level=5),

    # Currently, all Fossil Pokemon's levels are set from the same byte in-game, so they are handled in a hacky way
    # as a Trainer Party
    LocationData("Cinnabar Lab Fossil Room", "Old Amber Pokemon", "Aerodactyl", rom_addresses["Gift_Aerodactyl"], None,
                 event=True, type="Static Pokemon"),
    LocationData("Cinnabar Lab Fossil Room", "Helix Fossil Pokemon", "Omanyte", rom_addresses["Gift_Omanyte"], None,
                 event=True, type="Static Pokemon"),
    LocationData("Cinnabar Lab Fossil Room", "Dome Fossil Pokemon", "Kabuto", rom_addresses["Gift_Kabuto"], None,
                 event=True, type="Static Pokemon"),

    LocationData("Route 2 Trade House", "Marcel Trade", "Mr Mime", rom_addresses["Trade_Marcel"] + 1, None, event=True,
                 type="Static Pokemon"),
    LocationData("Underground Path Route 5", "Spot Trade", "Nidoran F", rom_addresses["Trade_Spot"] + 1, None,
                 event=True, type="Static Pokemon"),
    LocationData("Route 11 Gate 2F", "Terry Trade", "Nidorina", rom_addresses["Trade_Terry"] + 1, None, event=True,
                 type="Static Pokemon"),
    LocationData("Route 18 Gate 2F", "Marc Trade", "Lickitung", rom_addresses["Trade_Marc"] + 1, None, event=True,
                 type="Static Pokemon"),
    LocationData("Cinnabar Lab Fossil Room", "Sailor Trade", "Seel", rom_addresses["Trade_Sailor"] + 1, None, event=True,
                 type="Static Pokemon"),
    LocationData("Cinnabar Lab Trade Room", "Crinkles Trade", "Tangela", rom_addresses["Trade_Crinkles"] + 1, None,
                 event=True, type="Static Pokemon"),
    LocationData("Cinnabar Lab Trade Room", "Doris Trade", "Electrode", rom_addresses["Trade_Doris"] + 1, None,
                 event=True, type="Static Pokemon"),
    LocationData("Vermilion Trade House", "Dux Trade", "Farfetchd", rom_addresses["Trade_Dux"] + 1, None, event=True,
                 type="Static Pokemon"),
    LocationData("Cerulean Trade House", "Lola Trade", "Jynx", rom_addresses["Trade_Lola"] + 1, None, event=True,
                 type="Static Pokemon"),

    LocationData("Power Plant", "Fake Pokeball Battle 1", "Voltorb", [rom_addresses["Static_Encounter_Voltorb_A"], rom_addresses["Reset_C"]],
                 None, event=True, type="Static Pokemon", level=40, level_address=rom_addresses["Static_Encounter_Voltorb_A"] + 1),
    LocationData("Power Plant", "Fake Pokeball Battle 2", "Voltorb", [rom_addresses["Static_Encounter_Voltorb_B"], rom_addresses["Reset_D"]],
                 None, event=True, type="Static Pokemon", level=40, level_address=rom_addresses["Static_Encounter_Voltorb_B"] + 1),
    LocationData("Power Plant", "Fake Pokeball Battle 3", "Voltorb", [rom_addresses["Static_Encounter_Voltorb_C"], rom_addresses["Reset_E"]],
                 None, event=True, type="Static Pokemon", level=40, level_address=rom_addresses["Static_Encounter_Voltorb_C"] + 1),
    LocationData("Power Plant", "Fake Pokeball Battle 4", "Voltorb", [rom_addresses["Static_Encounter_Voltorb_D"], rom_addresses["Reset_G"]],
                 None, event=True, type="Static Pokemon", level=40, level_address=rom_addresses["Static_Encounter_Voltorb_D"] + 1),
    LocationData("Power Plant", "Fake Pokeball Battle 5", "Voltorb", [rom_addresses["Static_Encounter_Voltorb_E"], rom_addresses["Reset_H"]],
                 None, event=True, type="Static Pokemon", level=40, level_address=rom_addresses["Static_Encounter_Voltorb_E"] + 1),
    LocationData("Power Plant", "Fake Pokeball Battle 6", "Voltorb", [rom_addresses["Static_Encounter_Voltorb_F"], rom_addresses["Reset_J"]],
                 None, event=True, type="Static Pokemon", level=40, level_address=rom_addresses["Static_Encounter_Voltorb_F"] + 1),
    LocationData("Power Plant", "Fake Pokeball Battle 7", "Electrode", [rom_addresses["Static_Encounter_Electrode_A"], rom_addresses["Reset_F"]],
                 None, event=True, type="Static Pokemon", level=43, level_address=rom_addresses["Static_Encounter_Electrode_A"] + 1),
    LocationData("Power Plant", "Fake Pokeball Battle 8", "Electrode", [rom_addresses["Static_Encounter_Electrode_B"], rom_addresses["Reset_I"]],
                 None, event=True, type="Static Pokemon", level=43, level_address=rom_addresses["Static_Encounter_Electrode_B"] + 1),

    LocationData("Pokemon Tower 6F", "Restless Soul", "Marowak", [rom_addresses["Ghost_Battle1"],
                                                                  rom_addresses["Ghost_Battle2"],
                                                                  rom_addresses["Ghost_Battle3"],
                                                                  rom_addresses["Ghost_Battle4"],
                                                                  rom_addresses["Ghost_Battle5"],
                                                                  rom_addresses["Ghost_Battle6"]], None, event=True,
                 type="Missable Pokemon", level=30, level_address=rom_addresses["Ghost_Battle_Level"]),

    LocationData("Route 12-W", "Sleeping Pokemon", "Snorlax", [rom_addresses["Static_Encounter_Snorlax_A"], rom_addresses["Reset_A"]],
                 None, event=True, type="Static Pokemon", level=30, level_address=rom_addresses["Static_Encounter_Snorlax_A_Level"]),
    LocationData("Route 16-C", "Sleeping Pokemon", "Snorlax", [rom_addresses["Static_Encounter_Snorlax_B"], rom_addresses["Reset_B"]],
                 None, event=True, type="Static Pokemon", level=30, level_address=rom_addresses["Static_Encounter_Snorlax_B_Level"]),

    LocationData("Saffron Fighting Dojo", "Gift 1", "Hitmonlee", rom_addresses["Gift_Hitmonlee"],
                 None, event=True, type="Missable Pokemon", level=30, level_address=rom_addresses["Gift_Hitmonlee_Level"]),
    LocationData("Saffron Fighting Dojo", "Gift 2", "Hitmonchan", rom_addresses["Gift_Hitmonchan"],
                 None, event=True, type="Missable Pokemon", level=30, level_address=rom_addresses["Gift_Hitmonchan_Level"]),

    LocationData("Oak's Lab", "Starter 1", "Charmander",
                 [rom_addresses["Starter1_A"], rom_addresses["Starter1_B"], rom_addresses["Starter1_C"],
                  rom_addresses["Starter1_D"], rom_addresses["Starter1_F"], rom_addresses["Starter1_H"]],
                 None, event=True,
                 type="Starter Pokemon"),

    LocationData("Oak's Lab", "Starter 2", "Squirtle",
                 [rom_addresses["Starter2_A"], rom_addresses["Starter2_B"], rom_addresses["Starter2_E"],
                  rom_addresses["Starter2_F"], rom_addresses["Starter2_G"], rom_addresses["Starter2_H"],
                  rom_addresses["Starter2_I"], rom_addresses["Starter2_J"], rom_addresses["Starter2_K"],
                  rom_addresses["Starter2_L"], rom_addresses["Starter2_M"], rom_addresses["Starter2_N"],
                  rom_addresses["Starter2_O"], rom_addresses["Starter2_P"]], None,
                 event=True, type="Starter Pokemon"),

    LocationData("Oak's Lab", "Starter 3", "Bulbasaur",
                 [rom_addresses["Starter3_A"], rom_addresses["Starter3_B"], rom_addresses["Starter3_C"],
                  rom_addresses["Starter3_D"], rom_addresses["Starter3_E"], rom_addresses["Starter3_G"],
                  rom_addresses["Starter3_I"], rom_addresses["Starter3_J"], rom_addresses["Starter3_K"],
                  rom_addresses["Starter3_L"], rom_addresses["Starter3_M"], rom_addresses["Starter3_N"],
                  rom_addresses["Starter3_O"], rom_addresses["Starter3_P"]], None,
                 event=True, type="Starter Pokemon"),

    LocationData("Power Plant", "Legendary Pokemon", "Zapdos", [rom_addresses["Static_Encounter_Zapdos"], rom_addresses["Reset_K"]],
                 None, event=True, type="Legendary Pokemon", level=50, level_address=rom_addresses["Static_Encounter_Zapdos"] + 1),
    LocationData("Seafoam Islands B4F", "Legendary Pokemon", "Articuno", [rom_addresses["Static_Encounter_Articuno"], rom_addresses["Reset_L"]],
                 None, event=True, type="Legendary Pokemon", level=50, level_address=rom_addresses["Static_Encounter_Articuno"] + 1),
    LocationData("Victory Road 2F-NW", "Legendary Pokemon", "Moltres", [rom_addresses["Static_Encounter_Moltres"], rom_addresses["Reset_M"]],
                 None, event=True, type="Legendary Pokemon", level=50, level_address=rom_addresses["Static_Encounter_Moltres"] + 1),
    LocationData("Cerulean Cave B1F-E", "Legendary Pokemon", "Mewtwo", [rom_addresses["Static_Encounter_Mewtwo"], rom_addresses["Reset_N"]],
                 None, event=True, type="Legendary Pokemon", level=70, level_address=rom_addresses["Static_Encounter_Mewtwo"] + 1),
    LocationData("Vermilion Dock", "Legendary Pokemon", "Mew", [rom_addresses["Static_Encounter_Mew"], rom_addresses["Reset_O"]],
                 None, event=True, type="Legendary Pokemon", level=10, level_address=rom_addresses["Static_Encounter_Mew"] + 1),

]

i = 0
for location in location_data:
    if (not location.event) and location.rom_address is not None:
        location.address = loc_id_start + i
        i += 1

trainer_data = {
    "Fossil Level": [{"level": 30, "party": [], "party_address": "Fossil_Level"}],
    'Route 3': [{'level': 11, 'party': ['Rattata', 'Ekans'], 'party_address': 'Trainer_Party_Route_3_Youngster_A'},
                {'level': 14, 'party': ['Spearow'], 'party_address': 'Trainer_Party_Route_3_Youngster_B'},
                {'level': 10, 'party': ['Caterpie', 'Weedle', 'Caterpie'],
                 'party_address': 'Trainer_Party_Route_3_BugCatcher_A'},
                {'level': 9, 'party': ['Weedle', 'Kakuna', 'Caterpie', 'Metapod'],
                 'party_address': 'Trainer_Party_Route_3_BugCatcher_B'},
                {'level': 11, 'party': ['Caterpie', 'Metapod'], 'party_address': 'Trainer_Party_Route_3_BugCatcher_C'},
                {'level': 9, 'party': ['Pidgey', 'Pidgey'], 'party_address': 'Trainer_Party_Route_3_Lass_A'},
                {'level': 10, 'party': ['Rattata', 'Nidoran M'], 'party_address': 'Trainer_Party_Route_3_Lass_B'},
                {'level': 14, 'party': ['Jigglypuff'], 'party_address': 'Trainer_Party_Route_3_Lass_C'}],
    'Mt Moon 1F': [{'level': 10, 'party': ['Rattata', 'Rattata', 'Zubat'],
                    'party_address': 'Trainer_Party_Mt_Moon_1F_Youngster_A'},
                   {'level': 11, 'party': ['Weedle', 'Kakuna'],
                    'party_address': 'Trainer_Party_Mt_Moon_1F_BugCatcher_A'},
                   {'level': 10, 'party': ['Caterpie', 'Metapod', 'Caterpie'],
                    'party_address': 'Trainer_Party_Mt_Moon_1F_BugCatcher_B'},
                   {'level': 11, 'party': ['Oddish', 'Bellsprout'], 'party_address': 'Trainer_Party_Mt_Moon_1F_Lass_A'},
                   {'level': 14, 'party': ['Clefairy'], 'party_address': 'Trainer_Party_Mt_Moon_1F_Lass_B'},
                   {'level': 11, 'party': ['Magnemite', 'Voltorb'],
                    'party_address': 'Trainer_Party_Mt_Moon_1F_SuperNerd_A'},
                   {'level': 10, 'party': ['Geodude', 'Geodude', 'Onix'],
                    'party_address': 'Trainer_Party_Mt_Moon_1F_Hiker_A'}],
    'S.S. Anne 1F Rooms-Youngster and Lass Room': [{'level': 18, 'party': ['Pidgey', 'Nidoran F'], 'party_address': 'Trainer_Party_SS_Anne_1F_Rooms_Lass_A'},
        {'level': 21, 'party': ['Nidoran M'], 'party_address': 'Trainer_Party_SS_Anne_1F_Rooms_Youngster_A'},

                                         ],
    'S.S. Anne 1F Rooms-East Gentleman Room': [
        {'level': 18, 'party': ['Growlithe', 'Growlithe'],
         'party_address': 'Trainer_Party_SS_Anne_1F_Rooms_Gentleman_A'}],
    'S.S. Anne 1F Rooms-West Gentleman Room': [
        {'level': 19, 'party': ['Nidoran M', 'Nidoran F'],
         'party_address': 'Trainer_Party_SS_Anne_1F_Rooms_Gentleman_B'}], 'Viridian Forest': [
        {'level': 6, 'party': ['Weedle', 'Caterpie'], 'party_address': 'Trainer_Party_Viridian_Forest_BugCatcher_A'},
        {'level': 7, 'party': ['Weedle', 'Kakuna', 'Weedle'],
         'party_address': 'Trainer_Party_Viridian_Forest_BugCatcher_B'},
        {'level': 9, 'party': ['Weedle'], 'party_address': 'Trainer_Party_Viridian_Forest_BugCatcher_C'}],
    'Route 24': [{'level': 14, 'party': ['Caterpie', 'Weedle'], 'party_address': 'Trainer_Party_Route_24_BugCatcher_A'},
                 {'level': 16, 'party': ['Pidgey', 'Nidoran F'], 'party_address': 'Trainer_Party_Route_24_Lass_A'},
                 {'level': 14, 'party': ['Pidgey', 'Nidoran F'], 'party_address': 'Trainer_Party_Route_24_Lass_B'},
                 {'level': 14, 'party': ['Rattata', 'Ekans'], 'party_address': 'Trainer_Party_Route_24_JrTrainerM_A'},
                 {'level': 18, 'party': ['Mankey'], 'party_address': 'Trainer_Party_Route_24_JrTrainerM_C'},
                 {'level': 15, 'party': ['Ekans', 'Zubat'], 'party_address': 'Trainer_Party_Route_24_Rocket_A'},
                 {'level': 14, 'party': ['Rattata', 'Ekans', 'Zubat'],
                  'party_address': 'Trainer_Party_Route_24_Youngster_A'}], 'Route 6': [
        {'level': 16, 'party': ['Weedle', 'Caterpie', 'Weedle'], 'party_address': 'Trainer_Party_Route_6_BugCatcher_A'},
        {'level': 20, 'party': ['Butterfree'], 'party_address': 'Trainer_Party_Route_6_BugCatcher_B'},
        {'level': 20, 'party': ['Squirtle'], 'party_address': 'Trainer_Party_Route_6_JrTrainerM_A'},
        {'level': 16, 'party': ['Spearow', 'Raticate'], 'party_address': 'Trainer_Party_Route_6_JrTrainerM_B'},
        {'level': 16, 'party': ['Rattata', 'Pikachu'], 'party_address': 'Trainer_Party_Route_6_JrTrainerF_A'},
        {'level': 16, 'party': ['Pidgey', 'Pidgey', 'Pidgey'], 'party_address': 'Trainer_Party_Route_6_JrTrainerF_B'}],
    'Route 9': [{'level': 19, 'party': ['Beedrill', 'Beedrill'], 'party_address': 'Trainer_Party_Route_9_BugCatcher_A'},
                {'level': 20, 'party': ['Caterpie', 'Weedle', 'Venonat'],
                 'party_address': 'Trainer_Party_Route_9_BugCatcher_B'},
                {'level': 21, 'party': ['Growlithe', 'Charmander'],
                 'party_address': 'Trainer_Party_Route_9_JrTrainerM_A'},
                {'level': 19, 'party': ['Rattata', 'Diglett', 'Ekans', 'Sandshrew'],
                 'party_address': 'Trainer_Party_Route_9_JrTrainerM_B'},
                {'level': 18, 'party': ['Oddish', 'Bellsprout', 'Oddish', 'Bellsprout'],
                 'party_address': 'Trainer_Party_Route_9_JrTrainerF_A'},
                {'level': 23, 'party': ['Meowth'], 'party_address': 'Trainer_Party_Route_9_JrTrainerF_B'},
                {'level': 21, 'party': ['Geodude', 'Onix'], 'party_address': 'Trainer_Party_Route_9_Hiker_A'},
                {'level': 20, 'party': ['Geodude', 'Machop', 'Geodude'],
                 'party_address': 'Trainer_Party_Route_9_Hiker_B'},
                {'level': 20, 'party': ['Machop', 'Onix'], 'party_address': 'Trainer_Party_Route_9_Hiker_D'}],
    'Route 4-Lass': [
        {'level': 31, 'party': ['Paras', 'Paras', 'Parasect'], 'party_address': 'Trainer_Party_Route_4_Lass_A'}],
    'Route 25': [{'level': 15, 'party': ['Nidoran M', 'Nidoran F'], 'party_address': 'Trainer_Party_Route_25_Lass_A'},
                 {'level': 13, 'party': ['Oddish', 'Pidgey', 'Oddish'],
                  'party_address': 'Trainer_Party_Route_25_Lass_B'},
                 {'level': 14, 'party': ['Rattata', 'Ekans'], 'party_address': 'Trainer_Party_Route_25_JrTrainerM_A'},
                 {'level': 15, 'party': ['Machop', 'Geodude'], 'party_address': 'Trainer_Party_Route_25_Hiker_A'},
                 {'level': 13, 'party': ['Geodude', 'Geodude', 'Machop', 'Geodude'],
                  'party_address': 'Trainer_Party_Route_25_Hiker_B'},
                 {'level': 17, 'party': ['Onix'], 'party_address': 'Trainer_Party_Route_25_Hiker_C'},
                 {'level': 15, 'party': ['Rattata', 'Spearow'], 'party_address': 'Trainer_Party_Route_25_Youngster_A'},
                 {'level': 17, 'party': ['Slowpoke'], 'party_address': 'Trainer_Party_Route_25_Youngster_B'},
                 {'level': 14, 'party': ['Ekans', 'Sandshrew'], 'party_address': 'Trainer_Party_Route_25_Youngster_C'}],
    'S.S. Anne 2F Rooms-Gentleman and Lass Room': [
        {'level': 18, 'party': ['Rattata', 'Pikachu'], 'party_address': 'Trainer_Party_SS_Anne_2F_Rooms_Lass_A'},
        {'level': 17, 'party': ['Growlithe', 'Ponyta'], 'party_address': 'Trainer_Party_SS_Anne_2F_Rooms_Gentleman_C'}],
    'S.S. Anne 2F Rooms-Fisherman and Gentleman Room': [
        {'level': 17, 'party': ['Goldeen', 'Tentacool', 'Goldeen'],
         'party_address': 'Trainer_Party_SS_Anne_2F_Rooms_Fisher_A'},
        {'level': 23, 'party': ['Pikachu'], 'party_address': 'Trainer_Party_SS_Anne_2F_Rooms_Gentleman_A'},],
    'Route 8': [{'level': 23, 'party': ['Nidoran F', 'Nidorina'], 'party_address': 'Trainer_Party_Route_8_Lass_A'},
                {'level': 24, 'party': ['Meowth', 'Meowth', 'Meowth'], 'party_address': 'Trainer_Party_Route_8_Lass_B'},
                {'level': 19, 'party': ['Pidgey', 'Rattata', 'Nidoran M', 'Meowth', 'Pikachu'],
                 'party_address': 'Trainer_Party_Route_8_Lass_C'},
                {'level': 22, 'party': ['Clefairy', 'Clefairy'], 'party_address': 'Trainer_Party_Route_8_Lass_D'},
                {'level': 20, 'party': ['Voltorb', 'Koffing', 'Voltorb', 'Magnemite'],
                 'party_address': 'Trainer_Party_Route_8_SuperNerd_A'},
                {'level': 22, 'party': ['Grimer', 'Muk', 'Grimer'],
                 'party_address': 'Trainer_Party_Route_8_SuperNerd_B'},
                {'level': 26, 'party': ['Koffing'], 'party_address': 'Trainer_Party_Route_8_SuperNerd_C'},
                {'level': 22, 'party': ['Poliwag', 'Poliwag', 'Poliwhirl'],
                 'party_address': 'Trainer_Party_Route_8_Gambler_A'},
                {'level': 24, 'party': ['Growlithe', 'Vulpix'], 'party_address': 'Trainer_Party_Route_8_Gambler_C'}],
    'Celadon Gym': [
        {'level': 23, 'party': ['Bellsprout', 'Weepinbell'], 'party_address': 'Trainer_Party_Celadon_Gym_Lass_A'},
        {'level': 24, 'party': ['Bulbasaur', 'Ivysaur'], 'party_address': 'Trainer_Party_Celadon_Gym_JrTrainerF_A'},
        {'level': 21, 'party': ['Oddish', 'Bellsprout', 'Oddish', 'Bellsprout'],
         'party_address': 'Trainer_Party_Celadon_Gym_Beauty_A'},
        {'level': 24, 'party': ['Bellsprout', 'Bellsprout'], 'party_address': 'Trainer_Party_Celadon_Gym_Beauty_B'}],
    'Celadon Gym-C': [
        {'level': 24, 'party': ['Weepinbell', 'Gloom', 'Ivysaur'],
         'party_address': 'Trainer_Party_Celadon_Gym_CooltrainerF_A'},
        {'level': [29, 24, 29], 'party': ['Victreebel', 'Tangela', 'Vileplume'],
         'party_address': 'Trainer_Party_Erika_A'},
        {'level': 23, 'party': ['Oddish', 'Gloom'], 'party_address': 'Trainer_Party_Celadon_Gym_Lass_B'},
        {'level': 26, 'party': ['Exeggcute'], 'party_address': 'Trainer_Party_Celadon_Gym_Beauty_C'}],

    'S.S. Anne Bow': [
        {'level': 18, 'party': ['Machop', 'Shellder'], 'party_address': 'Trainer_Party_SS_Anne_Stern_Sailor_A'},
        {'level': 17, 'party': ['Machop', 'Tentacool'], 'party_address': 'Trainer_Party_SS_Anne_Stern_Sailor_B'}],
    'S.S. Anne B1F Rooms-Two Sailors Room': [{'level': 21, 'party': ['Shellder'], 'party_address': 'Trainer_Party_SS_Anne_B1F_Rooms_Sailor_A'},
                      {'level': 17, 'party': ['Horsea', 'Shellder', 'Tentacool'],
                       'party_address': 'Trainer_Party_SS_Anne_B1F_Rooms_Sailor_B'}],
    'S.S. Anne B1F Rooms-East Single Sailor Room': [
                      {'level': 17, 'party': ['Horsea', 'Horsea', 'Horsea'],
                       'party_address': 'Trainer_Party_SS_Anne_B1F_Rooms_Sailor_D'}],
    'S.S. Anne B1F Rooms-West Single Sailor Room': [
                      {'level': 18, 'party': ['Tentacool', 'Staryu'],
                       'party_address': 'Trainer_Party_SS_Anne_B1F_Rooms_Sailor_C'},],
    'S.S. Anne B1F Rooms-Fisherman Room': [
                      {'level': 20, 'party': ['Machop'], 'party_address': 'Trainer_Party_SS_Anne_B1F_Rooms_Sailor_E'},
                      {'level': 17, 'party': ['Tentacool', 'Staryu', 'Shellder'],
                       'party_address': 'Trainer_Party_SS_Anne_B1F_Rooms_Fisher_A'}], 'Vermilion Gym': [
        {'level': 21, 'party': ['Pikachu', 'Pikachu'], 'party_address': 'Trainer_Party_Vermilion_Gym_Sailor_A'},
        {'level': 20, 'party': ['Voltorb', 'Magnemite', 'Voltorb'],
         'party_address': 'Trainer_Party_Vermilion_Gym_Rocker_A'},
        {'level': 23, 'party': ['Pikachu'], 'party_address': 'Trainer_Party_Vermilion_Gym_Gentleman_A'},
        {'level': [21, 18, 24], 'party': ['Voltorb', 'Pikachu', 'Raichu'], 'party_address': 'Trainer_Party_LtSurge_A'},],
    'Pewter Gym': [
        {'level': 11, 'party': ['Diglett', 'Sandshrew'], 'party_address': 'Trainer_Party_Pewter_Gym_JrTrainerM_A'},
    {'level': [12, 14], 'party': ['Geodude', 'Onix'], 'party_address': 'Trainer_Party_Brock_A'},],
    'Route 12-Grass': [{'level': 24, 'party': ['Magikarp', 'Magikarp'], 'party_address': 'Trainer_Party_Route_12_Fisher_F'}],
    'Route 12-S': [{'level': 29, 'party': ['Nidoran M', 'Nidorino'], 'party_address': 'Trainer_Party_Route_12_JrTrainerM_A'},
 {'level': 29, 'party': ['Voltorb', 'Electrode'], 'party_address': 'Trainer_Party_Route_12_Rocker_A'}],
    'Route 12-N': [

        {'level': 22, 'party': ['Goldeen', 'Poliwag', 'Goldeen'], 'party_address': 'Trainer_Party_Route_12_Fisher_A'},
        {'level': 24, 'party': ['Tentacool', 'Goldeen'], 'party_address': 'Trainer_Party_Route_12_Fisher_B'},
        {'level': 27, 'party': ['Goldeen'], 'party_address': 'Trainer_Party_Route_12_Fisher_C'},
        {'level': 21, 'party': ['Poliwag', 'Shellder', 'Goldeen', 'Horsea'],
         'party_address': 'Trainer_Party_Route_12_Fisher_D'}],
    'Cerulean Gym': [{'level': 19, 'party': ['Goldeen'], 'party_address': 'Trainer_Party_Cerulean_Gym_JrTrainerF_A'},
                     {'level': 16, 'party': ['Horsea', 'Shellder'],
                      'party_address': 'Trainer_Party_Cerulean_Gym_Swimmer_A'},
        {'level': [18, 21], 'party': ['Staryu', 'Starmie'], 'party_address': 'Trainer_Party_Misty_A'},],
    'Route 10-N': [{'level': 20, 'party': ['Pikachu', 'Clefairy'], 'party_address': 'Trainer_Party_Route_10_JrTrainerF_A'}],
    'Route 10-C': [
        {'level': 30, 'party': ['Rhyhorn', 'Lickitung'], 'party_address': 'Trainer_Party_Route_10_Pokemaniac_A'}],
    'Route 10-S': [
        {'level': 21, 'party': ['Pidgey', 'Pidgeotto'], 'party_address': 'Trainer_Party_Route_10_JrTrainerF_B'},
        {'level': 20, 'party': ['Cubone', 'Slowpoke'], 'party_address': 'Trainer_Party_Route_10_Pokemaniac_B'},
        {'level': 21, 'party': ['Geodude', 'Onix'], 'party_address': 'Trainer_Party_Route_10_Hiker_A'},
        {'level': 19, 'party': ['Onix', 'Graveler'], 'party_address': 'Trainer_Party_Route_10_Hiker_B'}],
    'Rock Tunnel B1F-W': [{'level': 21, 'party': ['Jigglypuff', 'Pidgey', 'Meowth'],
                         'party_address': 'Trainer_Party_Rock_Tunnel_B1F_JrTrainerF_A'},
                        {'level': 20, 'party': ['Slowpoke', 'Slowpoke', 'Slowpoke'],
                         'party_address': 'Trainer_Party_Rock_Tunnel_B1F_Pokemaniac_A'},
                        {'level': 21, 'party': ['Geodude', 'Geodude', 'Graveler'],
                         'party_address': 'Trainer_Party_Rock_Tunnel_B1F_Hiker_A'},],
    'Rock Tunnel B1F-E': [
        {'level': 22, 'party': ['Oddish', 'Bulbasaur'],
         'party_address': 'Trainer_Party_Rock_Tunnel_B1F_JrTrainerF_B'},
        {'level': 22, 'party': ['Charmander', 'Cubone'],
         'party_address': 'Trainer_Party_Rock_Tunnel_B1F_Pokemaniac_B'},
        {'level': 25, 'party': ['Slowpoke'],
         'party_address': 'Trainer_Party_Rock_Tunnel_B1F_Pokemaniac_C'},
        {'level': 25, 'party': ['Geodude'], 'party_address': 'Trainer_Party_Rock_Tunnel_B1F_Hiker_B'},
        {'level': 20, 'party': ['Machop', 'Onix'],
         'party_address': 'Trainer_Party_Rock_Tunnel_B1F_Hiker_D'}],
    'Route 13-E': [
        {'level': 28, 'party': ['Goldeen', 'Poliwag', 'Horsea'],
         'party_address': 'Trainer_Party_Route_13_JrTrainerF_D'},
        {'level': 29, 'party': ['Pidgey', 'Pidgeotto'], 'party_address': 'Trainer_Party_Route_13_BirdKeeper_A'},
        {'level': 24, 'party': ['Pidgey', 'Meowth', 'Rattata', 'Pikachu', 'Meowth'],
         'party_address': 'Trainer_Party_Route_13_JrTrainerF_A'},
    ],
    'Route 13': [
        {'level': 30, 'party': ['Poliwag', 'Poliwag'], 'party_address': 'Trainer_Party_Route_13_JrTrainerF_B'},
        {'level': 27, 'party': ['Pidgey', 'Meowth', 'Pidgey', 'Pidgeotto'],
         'party_address': 'Trainer_Party_Route_13_JrTrainerF_C'},
        {'level': 28, 'party': ['Koffing', 'Koffing', 'Koffing'], 'party_address': 'Trainer_Party_Route_13_Biker_A'},
        {'level': 27, 'party': ['Rattata', 'Pikachu', 'Rattata'], 'party_address': 'Trainer_Party_Route_13_Beauty_A'},
        {'level': 29, 'party': ['Clefairy', 'Meowth'], 'party_address': 'Trainer_Party_Route_13_Beauty_B'},
        {'level': 25, 'party': ['Spearow', 'Pidgey', 'Pidgey', 'Spearow', 'Spearow'],
         'party_address': 'Trainer_Party_Route_13_BirdKeeper_B'},
        {'level': 26, 'party': ['Pidgey', 'Pidgeotto', 'Spearow', 'Fearow'],
         'party_address': 'Trainer_Party_Route_13_BirdKeeper_C'}],

    'Route 20-E': [
        {'level': 31, 'party': ['Shellder', 'Cloyster'], 'party_address': 'Trainer_Party_Route_20_Swimmer_A'},
        {'level': 28, 'party': ['Horsea', 'Horsea', 'Seadra', 'Horsea'],

         'party_address': 'Trainer_Party_Route_20_Swimmer_C'},

        {'level': 30, 'party': ['Seadra', 'Horsea', 'Seadra'],
         'party_address': 'Trainer_Party_Route_20_Beauty_E'},
        {'level': 35, 'party': ['Seaking'], 'party_address': 'Trainer_Party_Route_20_Beauty_A'},],
    'Route 20-W': [
        {'level': 31, 'party': ['Goldeen', 'Seaking'], 'party_address': 'Trainer_Party_Route_20_JrTrainerF_A'},
                 {'level': 30, 'party': ['Tentacool', 'Horsea', 'Seel'],
                  'party_address': 'Trainer_Party_Route_20_JrTrainerF_C'},

                 {'level': 35, 'party': ['Staryu'], 'party_address': 'Trainer_Party_Route_20_Swimmer_B'},

                 {'level': 30, 'party': ['Shellder', 'Shellder', 'Cloyster'],
                  'party_address': 'Trainer_Party_Route_20_Beauty_B'},
                 {'level': 31, 'party': ['Poliwag', 'Seaking'], 'party_address': 'Trainer_Party_Route_20_Beauty_C'},

                 {'level': 30, 'party': ['Fearow', 'Fearow', 'Pidgeotto'],
                  'party_address': 'Trainer_Party_Route_20_BirdKeeper_A'}], 'Rock Tunnel 1F-S': [ ###
        {'level': 22, 'party': ['Bellsprout', 'Clefairy'],
         'party_address': 'Trainer_Party_Rock_Tunnel_1F_JrTrainerF_A'},
        {'level': 20, 'party': ['Meowth', 'Oddish', 'Pidgey'],
         'party_address': 'Trainer_Party_Rock_Tunnel_1F_JrTrainerF_B'},
        {'level': 19, 'party': ['Pidgey', 'Rattata', 'Rattata', 'Bellsprout'],
         'party_address': 'Trainer_Party_Rock_Tunnel_1F_JrTrainerF_C'}],
    'Rock Tunnel 1F-NE': [
        {'level': 23, 'party': ['Cubone', 'Slowpoke'], 'party_address': 'Trainer_Party_Rock_Tunnel_1F_Pokemaniac_A'}],
    'Rock Tunnel 1F-NW': [
        {'level': 19, 'party': ['Geodude', 'Machop', 'Geodude', 'Geodude'],
         'party_address': 'Trainer_Party_Rock_Tunnel_1F_Hiker_A'},
        {'level': 20, 'party': ['Onix', 'Onix', 'Geodude'], 'party_address': 'Trainer_Party_Rock_Tunnel_1F_Hiker_B'},
        {'level': 21, 'party': ['Geodude', 'Graveler'], 'party_address': 'Trainer_Party_Rock_Tunnel_1F_Hiker_C'}],
    'Route 15-N': [
        {'level': 33, 'party': ['Clefairy'], 'party_address': 'Trainer_Party_Route_15_JrTrainerF_C'}],
    'Route 15': [
        {'level': 28, 'party': ['Gloom', 'Oddish', 'Oddish'], 'party_address': 'Trainer_Party_Route_15_JrTrainerF_A'},
        {'level': 29, 'party': ['Pikachu', 'Raichu'], 'party_address': 'Trainer_Party_Route_15_JrTrainerF_B'},
        {'level': 29, 'party': ['Bellsprout', 'Oddish', 'Tangela'],
         'party_address': 'Trainer_Party_Route_15_JrTrainerF_D'},
        {'level': 25, 'party': ['Koffing', 'Koffing', 'Weezing', 'Koffing', 'Grimer'],
         'party_address': 'Trainer_Party_Route_15_Biker_A'},
        {'level': 28, 'party': ['Koffing', 'Grimer', 'Weezing'], 'party_address': 'Trainer_Party_Route_15_Biker_B'},
        {'level': 29, 'party': ['Pidgeotto', 'Wigglytuff'], 'party_address': 'Trainer_Party_Route_15_Beauty_A'},
        {'level': 29, 'party': ['Bulbasaur', 'Ivysaur'], 'party_address': 'Trainer_Party_Route_15_Beauty_B'},
        {'level': 26, 'party': ['Pidgeotto', 'Farfetchd', 'Doduo', 'Pidgey'],
         'party_address': 'Trainer_Party_Route_15_BirdKeeper_A'},
        {'level': 28, 'party': ['Dodrio', 'Doduo', 'Doduo'], 'party_address': 'Trainer_Party_Route_15_BirdKeeper_B'}],
    'Victory Road 2F-NW': [{'level': 40, 'party': ['Charmeleon', 'Lapras', 'Lickitung'],
                         'party_address': 'Trainer_Party_Victory_Road_2F_Pokemaniac_A'}],
    'Victory Road 2F-C': [
        {'level': 41, 'party': ['Drowzee', 'Hypno', 'Kadabra', 'Kadabra'],
         'party_address': 'Trainer_Party_Victory_Road_2F_Juggler_A'},
        {'level': 48, 'party': ['Mr Mime'], 'party_address': 'Trainer_Party_Victory_Road_2F_Juggler_C'},
        {'level': 44, 'party': ['Persian', 'Golduck'],
         'party_address': 'Trainer_Party_Victory_Road_2F_Tamer_A'},
        {'level': 43, 'party': ['Machoke', 'Machop', 'Machoke'],
         'party_address': 'Trainer_Party_Victory_Road_2F_Blackbelt_A'}], 'Mt Moon B2F': [
        {'level': 12, 'party': ['Grimer', 'Voltorb', 'Koffing'],
         'party_address': 'Trainer_Party_Mt_Moon_B2F_SuperNerd_A'},
        {'level': 13, 'party': ['Rattata', 'Zubat'], 'party_address': 'Trainer_Party_Mt_Moon_B2F_Rocket_A'},
        {'level': 16, 'party': ['Raticate'], 'party_address': 'Trainer_Party_Mt_Moon_B2F_Rocket_D'}],
    'Mt Moon B2F-NE': [{'level': 12, 'party': ['Zubat', 'Ekans'], 'party_address': 'Trainer_Party_Mt_Moon_B2F_Rocket_C'}],
    'Mt Moon B2F-C': [
        {'level': 11, 'party': ['Sandshrew', 'Rattata', 'Zubat'],
         'party_address': 'Trainer_Party_Mt_Moon_B2F_Rocket_B'}], 'Cinnabar Gym': [
        {'level': 36, 'party': ['Vulpix', 'Vulpix', 'Ninetales'],
         'party_address': 'Trainer_Party_Cinnabar_Gym_SuperNerd_A'},
        {'level': 34, 'party': ['Ponyta', 'Charmander', 'Vulpix', 'Growlithe'],
         'party_address': 'Trainer_Party_Cinnabar_Gym_SuperNerd_B'},
        {'level': 41, 'party': ['Rapidash'], 'party_address': 'Trainer_Party_Cinnabar_Gym_SuperNerd_C'},
        {'level': 37, 'party': ['Growlithe', 'Vulpix'], 'party_address': 'Trainer_Party_Cinnabar_Gym_SuperNerd_D'},
        {'level': 36, 'party': ['Growlithe', 'Vulpix', 'Ninetales'],
         'party_address': 'Trainer_Party_Cinnabar_Gym_Burglar_A'},
        {'level': 41, 'party': ['Ponyta'], 'party_address': 'Trainer_Party_Cinnabar_Gym_Burglar_B'},
        {'level': 37, 'party': ['Vulpix', 'Growlithe'], 'party_address': 'Trainer_Party_Cinnabar_Gym_Burglar_C'},
        {'level': [42, 40, 42, 47], 'party': ['Growlithe', 'Ponyta', 'Rapidash', 'Arcanine'],
         'party_address': 'Trainer_Party_Blaine_A'}],
    'Route 14': [{'level': 29, 'party': ['Koffing', 'Grimer'], 'party_address': 'Trainer_Party_Route_14_Biker_A'},
                 {'level': 26, 'party': ['Koffing', 'Koffing', 'Grimer', 'Koffing'],
                  'party_address': 'Trainer_Party_Route_14_Biker_C'},
                 {'level': 28, 'party': ['Grimer', 'Grimer', 'Koffing'],
                  'party_address': 'Trainer_Party_Route_14_Biker_D'},
                 {'level': 29, 'party': ['Koffing', 'Muk'], 'party_address': 'Trainer_Party_Route_14_Biker_E'},
                 {'level': 33, 'party': ['Farfetchd'], 'party_address': 'Trainer_Party_Route_14_BirdKeeper_A'},
                 {'level': 29, 'party': ['Spearow', 'Fearow'], 'party_address': 'Trainer_Party_Route_14_BirdKeeper_B'},
                 {'level': 28, 'party': ['Pidgey', 'Doduo', 'Pidgeotto'],
                  'party_address': 'Trainer_Party_Route_14_BirdKeeper_D'},
                 {'level': 26, 'party': ['Pidgey', 'Spearow', 'Pidgey', 'Fearow'],
                  'party_address': 'Trainer_Party_Route_14_BirdKeeper_E'},
                 {'level': 29, 'party': ['Pidgeotto', 'Fearow'],
                  'party_address': 'Trainer_Party_Route_14_BirdKeeper_F'},
                 {'level': 28, 'party': ['Spearow', 'Doduo', 'Fearow'],
                  'party_address': 'Trainer_Party_Route_14_BirdKeeper_G'}],
    'Route 16-SW': [{'level': 29, 'party': ['Grimer', 'Koffing'], 'party_address': 'Trainer_Party_Route_16_Biker_A'},
                 {'level': 33, 'party': ['Weezing'], 'party_address': 'Trainer_Party_Route_16_Biker_B'},
                 {'level': 26, 'party': ['Grimer', 'Grimer', 'Grimer', 'Grimer'],
                  'party_address': 'Trainer_Party_Route_16_Biker_C'},
                 {'level': 28, 'party': ['Machop', 'Mankey', 'Machop'],
                  'party_address': 'Trainer_Party_Route_16_CueBall_A'},
                 {'level': 29, 'party': ['Mankey', 'Machop'], 'party_address': 'Trainer_Party_Route_16_CueBall_B'},
                 {'level': 33, 'party': ['Machop'], 'party_address': 'Trainer_Party_Route_16_CueBall_C'}], 'Route 17': [
        {'level': 28, 'party': ['Weezing', 'Koffing', 'Weezing'], 'party_address': 'Trainer_Party_Route_17_Biker_A'},
        {'level': 33, 'party': ['Muk'], 'party_address': 'Trainer_Party_Route_17_Biker_B'},
        {'level': 29, 'party': ['Voltorb', 'Voltorb'], 'party_address': 'Trainer_Party_Route_17_Biker_C'},
        {'level': 29, 'party': ['Weezing', 'Muk'], 'party_address': 'Trainer_Party_Route_17_Biker_D'},
        {'level': 25, 'party': ['Koffing', 'Weezing', 'Koffing', 'Koffing', 'Weezing'],
         'party_address': 'Trainer_Party_Route_17_Biker_E'},
        {'level': 29, 'party': ['Mankey', 'Primeape'], 'party_address': 'Trainer_Party_Route_17_CueBall_A'},
        {'level': 29, 'party': ['Machop', 'Machoke'], 'party_address': 'Trainer_Party_Route_17_CueBall_B'},
        {'level': 33, 'party': ['Machoke'], 'party_address': 'Trainer_Party_Route_17_CueBall_C'},
        {'level': 26, 'party': ['Mankey', 'Mankey', 'Machoke', 'Machop'],
         'party_address': 'Trainer_Party_Route_17_CueBall_D'},
        {'level': 29, 'party': ['Primeape', 'Machoke'], 'party_address': 'Trainer_Party_Route_17_CueBall_E'}],
    'Pokemon Mansion 2F': [
        {'level': 34, 'party': ['Charmander', 'Charmeleon'], 'party_address': 'Trainer_Party_Mansion_2F_Burglar_A'}],
    'Pokemon Mansion 3F-SW': [{'level': 38, 'party': ['Ninetales'], 'party_address': 'Trainer_Party_Mansion_3F_Burglar_A'}],
    'Pokemon Mansion 3F-SE': [
                   {'level': 33, 'party': ['Magnemite', 'Magneton', 'Voltorb'],
                    'party_address': 'Trainer_Party_Mansion_3F_Scientist_A'}], 'Pokemon Mansion B1F': [
        {'level': 34, 'party': ['Growlithe', 'Ponyta'], 'party_address': 'Trainer_Party_Mansion_B1F_Burglar_A'},
        {'level': 34, 'party': ['Magnemite', 'Electrode'], 'party_address': 'Trainer_Party_Mansion_B1F_Scientist_A'}],
    'Route 11': [{'level': 21, 'party': ['Magnemite'], 'party_address': 'Trainer_Party_Route_11_Engineer_A'},
                 {'level': 18, 'party': ['Magnemite', 'Magnemite', 'Magneton'],
                  'party_address': 'Trainer_Party_Route_11_Engineer_B'},
                 {'level': 18, 'party': ['Poliwag', 'Horsea'], 'party_address': 'Trainer_Party_Route_11_Gambler_A'},
                 {'level': 18, 'party': ['Bellsprout', 'Oddish'], 'party_address': 'Trainer_Party_Route_11_Gambler_B'},
                 {'level': 18, 'party': ['Voltorb', 'Magnemite'], 'party_address': 'Trainer_Party_Route_11_Gambler_C'},
                 {'level': 18, 'party': ['Growlithe', 'Vulpix'], 'party_address': 'Trainer_Party_Route_11_Gambler_D'},
                 {'level': 21, 'party': ['Ekans'], 'party_address': 'Trainer_Party_Route_11_Youngster_A'},
                 {'level': 19, 'party': ['Sandshrew', 'Zubat'], 'party_address': 'Trainer_Party_Route_11_Youngster_B'},
                 {'level': 17, 'party': ['Rattata', 'Rattata', 'Raticate'],
                  'party_address': 'Trainer_Party_Route_11_Youngster_C'},
                 {'level': 18, 'party': ['Nidoran M', 'Nidorino'],
                  'party_address': 'Trainer_Party_Route_11_Youngster_D'}], 'Route 21': [
        {'level': 28, 'party': ['Seaking', 'Goldeen', 'Seaking', 'Seaking'],
         'party_address': 'Trainer_Party_Route_21_Fisher_A'},
        {'level': 31, 'party': ['Shellder', 'Cloyster'], 'party_address': 'Trainer_Party_Route_21_Fisher_B'},
        {'level': 27, 'party': ['Magikarp', 'Magikarp', 'Magikarp', 'Magikarp', 'Magikarp', 'Magikarp'],
         'party_address': 'Trainer_Party_Route_21_Fisher_C'},
        {'level': 33, 'party': ['Seaking', 'Goldeen'], 'party_address': 'Trainer_Party_Route_21_Fisher_D'},
        {'level': 33, 'party': ['Seadra', 'Tentacruel'], 'party_address': 'Trainer_Party_Route_21_Swimmer_A'},
        {'level': 37, 'party': ['Starmie'], 'party_address': 'Trainer_Party_Route_21_Swimmer_B'},
        {'level': 33, 'party': ['Staryu', 'Wartortle'], 'party_address': 'Trainer_Party_Route_21_Swimmer_C'},
        {'level': 32, 'party': ['Poliwhirl', 'Tentacool', 'Seadra'],
         'party_address': 'Trainer_Party_Route_21_Swimmer_D'},
        {'level': 31, 'party': ['Tentacool', 'Tentacool', 'Tentacruel'],
         'party_address': 'Trainer_Party_Route_21_CueBall_A'}],
    'Route 19-N': [{'level': 30, 'party': ['Tentacool', 'Shellder'], 'party_address': 'Trainer_Party_Route_19_Swimmer_A'},
                 {'level': 29, 'party': ['Goldeen', 'Horsea', 'Staryu'],
                  'party_address': 'Trainer_Party_Route_19_Swimmer_B'},],
    'Route 19-S': [
                 {'level': 30, 'party': ['Poliwag', 'Poliwhirl'], 'party_address': 'Trainer_Party_Route_19_Swimmer_C'},
                 {'level': 27, 'party': ['Horsea', 'Tentacool', 'Tentacool', 'Goldeen'],
                  'party_address': 'Trainer_Party_Route_19_Swimmer_D'},
                 {'level': 29, 'party': ['Goldeen', 'Shellder', 'Seaking'],
                  'party_address': 'Trainer_Party_Route_19_Swimmer_E'},
                 {'level': 30, 'party': ['Horsea', 'Horsea'], 'party_address': 'Trainer_Party_Route_19_Swimmer_F'},
                 {'level': 27, 'party': ['Tentacool', 'Tentacool', 'Staryu', 'Horsea', 'Tentacruel'],
                  'party_address': 'Trainer_Party_Route_19_Swimmer_G'},
                 {'level': 27, 'party': ['Poliwag', 'Goldeen', 'Seaking', 'Goldeen', 'Poliwag'],
                  'party_address': 'Trainer_Party_Route_19_Beauty_A'},
                 {'level': 30, 'party': ['Goldeen', 'Seaking'], 'party_address': 'Trainer_Party_Route_19_Beauty_B'},
                 {'level': 29, 'party': ['Staryu', 'Staryu', 'Staryu'],
                  'party_address': 'Trainer_Party_Route_19_Beauty_C'}],
    'Saffron Gym-C': [
        {'level': [38, 37, 38, 43], 'party': ['Kadabra', 'Mr Mime', 'Venomoth', 'Alakazam'],
         'party_address': 'Trainer_Party_Sabrina_A'},],
    'Saffron Gym-NE': [
        {'level': 31, 'party': ['Kadabra', 'Slowpoke', 'Mr Mime', 'Kadabra'],
         'party_address': 'Trainer_Party_Saffron_Gym_Psychic_A'}],
    'Saffron Gym-E': [
        {'level': 34, 'party': ['Mr Mime', 'Kadabra'], 'party_address': 'Trainer_Party_Saffron_Gym_Psychic_B'}],
    'Saffron Gym-SE': [
        {'level': 33, 'party': ['Slowpoke', 'Slowpoke', 'Slowbro'],
         'party_address': 'Trainer_Party_Saffron_Gym_Psychic_C'}],

    'Saffron Gym-NW': [
        {'level': 38, 'party': ['Slowbro'], 'party_address': 'Trainer_Party_Saffron_Gym_Psychic_D'}],
    'Saffron Gym-N': [
        {'level': 34, 'party': ['Gastly', 'Haunter'], 'party_address': 'Trainer_Party_Saffron_Gym_Channeler_A'}],
    'Saffron Gym-W': [
        {'level': 38, 'party': ['Haunter'], 'party_address': 'Trainer_Party_Saffron_Gym_Channeler_B'}],
    'Saffron Gym-SW': [
        {'level': 33, 'party': ['Gastly', 'Gastly', 'Haunter'],
         'party_address': 'Trainer_Party_Saffron_Gym_Channeler_C'}], 'Silph Co 5F': [
        {'level': 29, 'party': ['Kadabra', 'Mr Mime'], 'party_address': 'Trainer_Party_Silph_Co_5F_Juggler_A'},
        {'level': 26, 'party': ['Magneton', 'Koffing', 'Weezing', 'Magnemite'],
         'party_address': 'Trainer_Party_Silph_Co_5F_Scientist_A'},
        {'level': 33, 'party': ['Arbok'], 'party_address': 'Trainer_Party_Silph_Co_5F_Rocket_A'},
        {'level': 33, 'party': ['Hypno'], 'party_address': 'Trainer_Party_Silph_Co_5F_Rocket_B'}], 'Fuchsia Gym': [
        {'level': 31, 'party': ['Drowzee', 'Drowzee', 'Kadabra', 'Drowzee'],
         'party_address': 'Trainer_Party_Fuchsia_Gym_Juggler_A'},
        {'level': 34, 'party': ['Drowzee', 'Hypno'], 'party_address': 'Trainer_Party_Fuchsia_Gym_Juggler_B'},
        {'level': 38, 'party': ['Hypno'], 'party_address': 'Trainer_Party_Fuchsia_Gym_Juggler_D'},
        {'level': 34, 'party': ['Drowzee', 'Kadabra'], 'party_address': 'Trainer_Party_Fuchsia_Gym_Juggler_E'},
        {'level': 34, 'party': ['Sandslash', 'Arbok'], 'party_address': 'Trainer_Party_Fuchsia_Gym_Tamer_A'},
        {'level': 33, 'party': ['Arbok', 'Sandslash', 'Arbok'], 'party_address': 'Trainer_Party_Fuchsia_Gym_Tamer_B'},
        {'level': [37, 39, 37, 43], 'party': ['Koffing', 'Muk', 'Koffing', 'Weezing'],
         'party_address': 'Trainer_Party_Koga_A'},],
    'Viridian Gym': [{'level': 43, 'party': ['Rhyhorn'], 'party_address': 'Trainer_Party_Viridian_Gym_Tamer_A'},
                     {'level': 39, 'party': ['Arbok', 'Tauros'], 'party_address': 'Trainer_Party_Viridian_Gym_Tamer_B'},
                     {'level': 40, 'party': ['Machop', 'Machoke'],
                      'party_address': 'Trainer_Party_Viridian_Gym_Blackbelt_A'},
                     {'level': 43, 'party': ['Machoke'], 'party_address': 'Trainer_Party_Viridian_Gym_Blackbelt_B'},
                     {'level': 38, 'party': ['Machoke', 'Machop', 'Machoke'],
                      'party_address': 'Trainer_Party_Viridian_Gym_Blackbelt_C'},
                     {'level': [45, 42, 44, 45, 50], 'party': ['Rhyhorn', 'Dugtrio', 'Nidoqueen', 'Nidoking', 'Rhydon'],
                      'party_address': 'Trainer_Party_Viridian_Gym_Giovanni_A'},
                     {'level': 39, 'party': ['Nidorino', 'Nidoking'],
                      'party_address': 'Trainer_Party_Viridian_Gym_CooltrainerM_A'},
                     {'level': 39, 'party': ['Sandslash', 'Dugtrio'],
                      'party_address': 'Trainer_Party_Viridian_Gym_CooltrainerM_C'},
                     {'level': 43, 'party': ['Rhyhorn'], 'party_address': 'Trainer_Party_Viridian_Gym_CooltrainerM_D'}],
    'Route 18-E': [{'level': 29, 'party': ['Spearow', 'Fearow'], 'party_address': 'Trainer_Party_Route_18_BirdKeeper_A'},
                 {'level': 34, 'party': ['Dodrio'], 'party_address': 'Trainer_Party_Route_18_BirdKeeper_B'},
                 {'level': 26, 'party': ['Spearow', 'Spearow', 'Fearow', 'Spearow'],
                  'party_address': 'Trainer_Party_Route_18_BirdKeeper_C'}], 'Saffron Fighting Dojo': [
        {'level': 37, 'party': ['Hitmonlee', 'Hitmonchan'], 'party_address': 'Trainer_Party_Fighting_Dojo_Blackbelt_A'},
        {'level': 31, 'party': ['Mankey', 'Mankey', 'Primeape'],
         'party_address': 'Trainer_Party_Fighting_Dojo_Blackbelt_B'},
        {'level': 32, 'party': ['Machop', 'Machoke'], 'party_address': 'Trainer_Party_Fighting_Dojo_Blackbelt_C'},
        {'level': 36, 'party': ['Primeape'], 'party_address': 'Trainer_Party_Fighting_Dojo_Blackbelt_D'},
        {'level': 31, 'party': ['Machop', 'Mankey', 'Primeape'],
         'party_address': 'Trainer_Party_Fighting_Dojo_Blackbelt_E'}],
    "Oak's Lab": [{'level': 5, 'party': [['Squirtle'], ['Bulbasaur'], ['Charmander']],
                      'party_address': ['Trainer_Party_Pallet_Town_Green1_A', 'Trainer_Party_Pallet_Town_Green1_B',
                                        'Trainer_Party_Pallet_Town_Green1_C']}],
    'Route 22': [{'level': [9, 8], 'party': [['Pidgey', 'Squirtle'], ['Pidgey', 'Bulbasaur'], ['Pidgey', 'Charmander']],
                   'party_address': ['Trainer_Party_Route_22_Green1_A', 'Trainer_Party_Route_22_Green1_B','Trainer_Party_Route_22_Green1_C']}],
    'Route 22-F':
        [{'level': [47, 45, 45, 47, 50, 53], 'party': [['Pidgeot', 'Rhyhorn', 'Growlithe', 'Exeggcute', 'Alakazam',
                        'Blastoise'], ['Pidgeot', 'Rhyhorn', 'Gyarados', 'Growlithe', 'Alakazam', 'Venusaur'], ['Pidgeot', 'Rhyhorn', 'Exeggcute',
                                                  'Gyarados', 'Alakazam', 'Charizard']],
         'party_address': ['Trainer_Party_Route_22_Green2_A', 'Trainer_Party_Route_22_Green2_B', 'Trainer_Party_Route_22_Green2_C']}],
    'Cerulean City': [{'level': [18, 15, 15, 17], 'party': [['Pidgeotto', 'Abra', 'Rattata', 'Squirtle'],
                                                            ['Pidgeotto', 'Abra', 'Rattata', 'Bulbasaur'],
                                                            ['Pidgeotto', 'Abra', 'Rattata', 'Charmander']],
                       'party_address': ['Trainer_Party_Cerulean_City_Green1_A', 'Trainer_Party_Cerulean_City_Green1_B', 'Trainer_Party_Cerulean_City_Green1_C']},
                      {'level': 17, 'party': ['Machop', 'Drowzee'],
                       'party_address': 'Trainer_Party_Cerulean_City_Rocket_A'}], 'Pokemon Mansion 1F-SE': [
        {'level': 29, 'party': ['Electrode', 'Weezing'], 'party_address': 'Trainer_Party_Mansion_1F_Scientist_A'}],
    'Silph Co 2F-SW': [{'level': 26, 'party': ['Grimer', 'Weezing', 'Koffing', 'Weezing'],
                      'party_address': 'Trainer_Party_Silph_Co_2F_Scientist_A'}],
    'Silph Co 2F': [{'level': 28, 'party': ['Magnemite', 'Voltorb', 'Magneton'],
                      'party_address': 'Trainer_Party_Silph_Co_2F_Scientist_B'},
                     {'level': 29, 'party': ['Cubone', 'Zubat'], 'party_address': 'Trainer_Party_Silph_Co_2F_Rocket_A'},
                     {'level': 25, 'party': ['Golbat', 'Zubat', 'Zubat', 'Raticate', 'Zubat'],
                      'party_address': 'Trainer_Party_Silph_Co_2F_Rocket_B'}], 'Silph Co 3F-W': [
        {'level': 29, 'party': ['Electrode', 'Weezing'], 'party_address': 'Trainer_Party_Silph_Co_3F_Scientist_A'}],
        'Silph Co 3F': [{'level': 28, 'party': ['Raticate', 'Hypno', 'Raticate'],
         'party_address': 'Trainer_Party_Silph_Co_3F_Rocket_A'}],
    'Silph Co 4F-N': [{'level': 33, 'party': ['Electrode'], 'party_address': 'Trainer_Party_Silph_Co_4F_Scientist_A'}],
                    'Silph Co 4F': [{'level': 29, 'party': ['Machop', 'Drowzee'],
                      'party_address': 'Trainer_Party_Silph_Co_4F_Rocket_A'},
                     {'level': 28, 'party': ['Ekans', 'Zubat', 'Cubone'],
                      'party_address': 'Trainer_Party_Silph_Co_4F_Rocket_B'}], 'Silph Co 6F': [
        {'level': 25, 'party': ['Voltorb', 'Koffing', 'Magneton', 'Magnemite', 'Koffing'],
         'party_address': 'Trainer_Party_Silph_Co_6F_Scientist_A'},
        {'level': 29, 'party': ['Machop', 'Machoke'], 'party_address': 'Trainer_Party_Silph_Co_6F_Rocket_A'},
        {'level': 28, 'party': ['Zubat', 'Zubat', 'Golbat'], 'party_address': 'Trainer_Party_Silph_Co_6F_Rocket_B'}],
    'Silph Co 7F': [
        {'level': 29, 'party': ['Electrode', 'Muk'], 'party_address': 'Trainer_Party_Silph_Co_7F_Scientist_A'},
        {'level': 26, 'party': ['Raticate', 'Arbok', 'Koffing', 'Golbat'],
         'party_address': 'Trainer_Party_Silph_Co_7F_Rocket_A'},
        {'level': 29, 'party': ['Cubone', 'Cubone'], 'party_address': 'Trainer_Party_Silph_Co_7F_Rocket_B'}],
    'Silph Co 7F-SE': [
        {'level': 29, 'party': ['Sandshrew', 'Sandslash'], 'party_address': 'Trainer_Party_Silph_Co_7F_Rocket_C'}],
    'Silph Co 7F-NW': [{'level': [37, 38, 35, 35, 40], 'party': [['Pidgeot', 'Growlithe', 'Exeggcute', 'Alakazam', 'Blastoise'],
                                                   ['Pidgeot', 'Gyarados', 'Growlithe', 'Alakazam', 'Venusaur'],
                                                   ['Pidgeot', 'Exeggcute', 'Gyarados', 'Alakazam', 'Charizard']],
         'party_address': ['Trainer_Party_Silph_Co_7F_Green2_A', 'Trainer_Party_Silph_Co_7F_Green2_B', 'Trainer_Party_Silph_Co_7F_Green2_C']}],
        'Silph Co 8F': [
        {'level': 29, 'party': ['Grimer', 'Electrode'], 'party_address': 'Trainer_Party_Silph_Co_8F_Scientist_A'},
        {'level': 26, 'party': ['Raticate', 'Zubat', 'Golbat', 'Rattata'],
         'party_address': 'Trainer_Party_Silph_Co_8F_Rocket_A'},
        {'level': 28, 'party': ['Weezing', 'Golbat', 'Koffing'],
         'party_address': 'Trainer_Party_Silph_Co_8F_Rocket_B'}], 'Silph Co 9F': [
        {'level': 28, 'party': ['Voltorb', 'Koffing', 'Magneton'],
         'party_address': 'Trainer_Party_Silph_Co_9F_Scientist_A'},
        {'level': 28, 'party': ['Golbat', 'Drowzee', 'Hypno'], 'party_address': 'Trainer_Party_Silph_Co_9F_Rocket_B'}],
    'Silph Co 9F-NW': [
        {'level': 28, 'party': ['Drowzee', 'Grimer', 'Machop'], 'party_address': 'Trainer_Party_Silph_Co_9F_Rocket_A'},],
    'Silph Co 10F': [
        {'level': 29, 'party': ['Magnemite', 'Koffing'], 'party_address': 'Trainer_Party_Silph_Co_10F_Scientist_A'},
        {'level': 33, 'party': ['Machoke'], 'party_address': 'Trainer_Party_Silph_Co_10F_Rocket_A'}],
    'Rocket Hideout B4F': [{'level': [25, 24, 29], 'party': ['Onix', 'Rhyhorn', 'Kangaskhan'],
                            'party_address': 'Trainer_Party_Rocket_Hideout_B4F_Giovanni_A'},
                           {'level': 23, 'party': ['Sandshrew', 'Ekans', 'Sandslash'],
                            'party_address': 'Trainer_Party_Rocket_Hideout_B4F_Rocket_A'},
                           {'level': 23, 'party': ['Ekans', 'Sandshrew', 'Arbok'],
                            'party_address': 'Trainer_Party_Rocket_Hideout_B4F_Rocket_B'}],
    'Rocket Hideout B4F-NW': [
                           {'level': 21, 'party': ['Koffing', 'Zubat'],
                            'party_address': 'Trainer_Party_Rocket_Hideout_B4F_Rocket_C'}], 'Silph Co 11F': [
        {'level': 25, 'party': ['Rattata', 'Rattata', 'Zubat', 'Rattata', 'Ekans'],
         'party_address': 'Trainer_Party_Silph_Co_11F_Rocket_A'},],
    'Silph Co 11F-W': [
        {'level': 32, 'party': ['Cubone', 'Drowzee', 'Marowak'],
         'party_address': 'Trainer_Party_Silph_Co_11F_Rocket_B'}],
    'Silph Co 11F-C': [
        {'level': [37, 35, 37, 41], 'party': ['Nidorino', 'Kangaskhan', 'Rhyhorn', 'Nidoqueen'],
         'party_address': 'Trainer_Party_Silph_Co_11F_Giovanni_A'}],
    'Celadon Game Corner': [
        {'level': 20, 'party': ['Raticate', 'Zubat'], 'party_address': 'Trainer_Party_Game_Corner_Rocket_A'}],
    'Rocket Hideout B1F': [
        {'level': 21, 'party': ['Drowzee', 'Machop'], 'party_address': 'Trainer_Party_Rocket_Hideout_B1F_Rocket_A'},
        {'level': 21, 'party': ['Raticate', 'Raticate'], 'party_address': 'Trainer_Party_Rocket_Hideout_B1F_Rocket_B'}],
    'Rocket Hideout B1F-S': [
        {'level': 20, 'party': ['Grimer', 'Koffing', 'Koffing'],
         'party_address': 'Trainer_Party_Rocket_Hideout_B1F_Rocket_C'},
        {'level': 19, 'party': ['Rattata', 'Raticate', 'Raticate', 'Rattata'],
         'party_address': 'Trainer_Party_Rocket_Hideout_B1F_Rocket_D'}],
    'Rocket Hideout B1F-SE': [
        {'level': 22, 'party': ['Grimer', 'Koffing'], 'party_address': 'Trainer_Party_Rocket_Hideout_B1F_Rocket_E'}],
    'Rocket Hideout B2F': [{'level': 17, 'party': ['Zubat', 'Koffing', 'Grimer', 'Zubat', 'Raticate'],
                            'party_address': 'Trainer_Party_Rocket_Hideout_B2F_Rocket_A'}], 'Rocket Hideout B3F': [
        {'level': 20, 'party': ['Rattata', 'Raticate', 'Drowzee'],
         'party_address': 'Trainer_Party_Rocket_Hideout_B3F_Rocket_A'},
        {'level': 21, 'party': ['Machop', 'Machop'], 'party_address': 'Trainer_Party_Rocket_Hideout_B3F_Rocket_B'}],
    'Pokemon Tower 7F': [{'level': 25, 'party': ['Zubat', 'Zubat', 'Golbat'],
                          'party_address': 'Trainer_Party_Pokemon_Tower_7F_Rocket_A'},
                         {'level': 26, 'party': ['Koffing', 'Drowzee'],
                          'party_address': 'Trainer_Party_Pokemon_Tower_7F_Rocket_B'},
                         {'level': 23, 'party': ['Zubat', 'Rattata', 'Raticate', 'Zubat'],
                          'party_address': 'Trainer_Party_Pokemon_Tower_7F_Rocket_C'}],
    'Victory Road 3F': [{'level': 43, 'party': ['Exeggutor', 'Cloyster', 'Arcanine'],
         'party_address': 'Trainer_Party_Victory_Road_3F_CooltrainerM_A'},
        {'level': 43, 'party': ['Parasect', 'Dewgong', 'Chansey'],
         'party_address': 'Trainer_Party_Victory_Road_3F_CooltrainerF_B'}],
    'Victory Road 3F-S': [
        {'level': 43, 'party': ['Kingler', 'Tentacruel', 'Blastoise'],
         'party_address': 'Trainer_Party_Victory_Road_3F_CooltrainerM_B'},
        {'level': 43, 'party': ['Bellsprout', 'Weepinbell', 'Victreebel'],
         'party_address': 'Trainer_Party_Victory_Road_3F_CooltrainerF_A'},
], 'Victory Road 1F': [
        {'level': 42, 'party': ['Ivysaur', 'Wartortle', 'Charmeleon', 'Charizard'],
         'party_address': 'Trainer_Party_Victory_Road_1F_CooltrainerM_A'},
        {'level': 44, 'party': ['Persian', 'Ninetales'],
         'party_address': 'Trainer_Party_Victory_Road_1F_CooltrainerF_A'}],


    "Indigo Plateau Bruno's Room": [
        {'level': [53, 55, 55, 56, 58], 'party': ['Onix', 'Hitmonchan', 'Hitmonlee', 'Onix', 'Machamp'],
         'party_address': 'Trainer_Party_Bruno_A'}],
    "Indigo Plateau Lorelei's Room": [{'level': [54, 53, 54, 56, 56], 'party': ['Dewgong', 'Cloyster', 'Slowbro', 'Jynx', 'Lapras'],
         'party_address': 'Trainer_Party_Lorelei_A'},],
    "Indigo Plateau Agatha's Room": [
        {'level': [56, 56, 55, 58, 60], 'party': ['Gengar', 'Golbat', 'Haunter', 'Arbok', 'Gengar'],
         'party_address': 'Trainer_Party_Agatha_A'},],
    "Indigo Plateau Lance's Room": [
        {'level': [58, 56, 56, 60, 62], 'party': ['Gyarados', 'Dragonair', 'Dragonair', 'Aerodactyl', 'Dragonite'],
         'party_address': 'Trainer_Party_Lance_A'}],


    'S.S. Anne 2F': [{'level': [19, 16, 18, 20], 'party': [['Pidgeotto', 'Raticate', 'Kadabra', 'Wartortle'], ['Pidgeotto', 'Raticate', 'Kadabra', 'Ivysaur'], ['Pidgeotto', 'Raticate', 'Kadabra', 'Charmeleon']],
         'party_address': ['Trainer_Party_SS_Anne_2F_Green2_A', 'Trainer_Party_SS_Anne_2F_Green2_B', 'Trainer_Party_SS_Anne_2F_Green2_C']}],

    'Pokemon Tower 2F':
        [{'level': [25, 23, 22, 20, 25], 'party': [['Pidgeotto', 'Growlithe', 'Exeggcute', 'Kadabra', 'Wartortle'], ['Pidgeotto', 'Gyarados', 'Growlithe', 'Kadabra', 'Ivysaur'], ['Pidgeotto', 'Exeggcute', 'Gyarados', 'Kadabra', 'Charmeleon']],
         'party_address': ['Trainer_Party_Pokemon_Tower_2F_Green2_A', 'Trainer_Party_Pokemon_Tower_2F_Green2_B', 'Trainer_Party_Pokemon_Tower_2F_Green2_C']}],

    "Indigo Plateau Champion's Room": [
        {'level': [61, 59, 61, 61, 63, 65],
         'party': [['Pidgeot', 'Alakazam', 'Rhydon', 'Arcanine', 'Exeggutor', 'Blastoise'], ['Pidgeot', 'Alakazam', 'Rhydon',
                                                                               'Gyarados', 'Arcanine', 'Venusaur'],['Pidgeot', 'Alakazam', 'Rhydon', 'Exeggutor', 'Gyarados', 'Charizard']],
         'party_address': ['Trainer_Party_Indigo_Plateau_Green3_A', 'Trainer_Party_Indigo_Plateau_Green3_B', 'Trainer_Party_Indigo_Plateau_Green3_C']}],


    'Pokemon Tower 3F': [
        {'level': 23, 'party': ['Gastly'], 'party_address': 'Trainer_Party_Pokemon_Tower_3F_Channeler_A'},
        {'level': 24, 'party': ['Gastly'], 'party_address': 'Trainer_Party_Pokemon_Tower_3F_Channeler_B'},
        {'level': 22, 'party': ['Gastly'], 'party_address': 'Trainer_Party_Pokemon_Tower_3F_Channeler_D'}],
    'Pokemon Tower 4F': [
        {'level': 24, 'party': ['Gastly'], 'party_address': 'Trainer_Party_Pokemon_Tower_4F_Channeler_A'},
        {'level': 23, 'party': ['Gastly', 'Gastly'], 'party_address': 'Trainer_Party_Pokemon_Tower_4F_Channeler_B'},
        {'level': 22, 'party': ['Gastly'], 'party_address': 'Trainer_Party_Pokemon_Tower_4F_Channeler_D'}],
    'Pokemon Tower 5F': [
        {'level': 23, 'party': ['Haunter'], 'party_address': 'Trainer_Party_Pokemon_Tower_5F_Channeler_A'},
        {'level': 22, 'party': ['Gastly'], 'party_address': 'Trainer_Party_Pokemon_Tower_5F_Channeler_C'},
        {'level': 24, 'party': ['Gastly'], 'party_address': 'Trainer_Party_Pokemon_Tower_5F_Channeler_D'},
        {'level': 22, 'party': ['Haunter'], 'party_address': 'Trainer_Party_Pokemon_Tower_5F_Channeler_E'}],
    'Pokemon Tower 6F': [{'level': 22, 'party': ['Gastly', 'Gastly', 'Gastly'],
                          'party_address': 'Trainer_Party_Pokemon_Tower_6F_Channeler_A'},
                         {'level': 24, 'party': ['Gastly'],
                          'party_address': 'Trainer_Party_Pokemon_Tower_6F_Channeler_B'},
                         {'level': 24, 'party': ['Gastly'],
                          'party_address': 'Trainer_Party_Pokemon_Tower_6F_Channeler_C'}]}

level_object_list = [(loc.name, loc.level) for loc in location_data if (loc.type == "Wild Encounter" or "Pokemon" in loc.type) and loc.level is not None]

for region in trainer_data:
    party_loc = LocationData(region, "Trainer Parties", "Trainer Parties", event=True, type="Trainer Parties")
    party_loc.party_data = trainer_data[region]
    for trainer in party_loc.party_data:
        if isinstance(trainer["level"], int):
            level_object_list.append(((trainer["party_address"][0] if isinstance(trainer["party_address"], list)
                                                else trainer["party_address"], 0), trainer["level"]))
        else:
            for i, level in enumerate(trainer["level"]):
                level_object_list.append(((trainer["party_address"][0] if isinstance(trainer["party_address"], list) else trainer["party_address"], i), level))
    location_data.append(party_loc)
level_object_list.sort(key=lambda i: i[1])
level_list = [i[1] for i in level_object_list]
level_name_list = [i[0] for i in level_object_list]


for mon in poke_data.evolves_from:
    location_data.append(LocationData("Evolution", mon, mon, event=True))


class PokemonRBLocation(Location):
    game = "Pokemon Red and Blue"

    def __init__(self, player, name, address, rom_address, type, level, level_address):
        super(PokemonRBLocation, self).__init__(
            player, name,
            address
        )
        self.rom_address = rom_address
        self.type = type
        self.level = level
        self.party_data = None
        self.level_address = level_address
        if type == "Trainer Parties":
            self.item_rule = lambda i: i.player == player and i.name == "Trainer Parties"
        elif type == "Wild Encounter" or "Pokemon" in type:
            self.item_rule = lambda i: (i.player == player and i.name in poke_data.pokemon_data or
                                        " ".join(i.name.split(" ")[1:]) in poke_data.pokemon_data)
