from BaseClasses import Location

class HitmanLocation(Location):
    game: str = "HITMAN World of Assassination"
    # location ids ranges:
    # 	1-209      Itempickup Checks
	# 	1000-1087  Completion Checks
	# 	1500-2414  Itempickup Checks by level
	# 	3000-3289  Disguise Checks
	# 	5000-9502  Elimination Checks
	# 	10000      All Contract Pieces Collected 

    # 0: id
    # 1: location entitlments (one of required)
    # 2: settings requirement (one of required)
    # 3: required items (one of)
    # 4: location entitlements if not master difficulty (one of, combined with location entitlements)
    # 5: required items when not on master (one of, combined with required items)
    # 6: location_groups
item_pickup_location_table = {
    "Itempickup - Crowbar":(1, ["ica_facility", "paris", "sapienza", "marrakesh", "bangkok", "colorado", "hokkaido", "miami", "santa_fortuna", "mumbai", "whittleton_creek", "ambrose_island", "isle_of_sgail", "new_york", "haven_island", "dubai", "dartmoor", "berlin", "chongqing", "mendoza"], ["itemsanity"], ["Level - ICA Facility","Level - Paris","Level - Sapienza","Level - Marrakesh","Level - Bangkok","Level - Colorado","Level - Hokkaido","Level - Miami","Level - Santa Fortuna","Level - Mumbai","Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - New York","Level - Haven Island","Level - Dubai","Level - Dartmoor","Level - Berlin","Level - Chongqing","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Hammer":(2, ["ica_facility", "paris", "sapienza", "marrakesh", "bangkok", "colorado", "hokkaido", "miami", "santa_fortuna", "mumbai", "whittleton_creek", "ambrose_island", "isle_of_sgail", "haven_island", "dubai", "dartmoor", "berlin", "chongqing"], ["itemsanity"], ["Level - ICA Facility","Level - Paris","Level - Sapienza","Level - Marrakesh","Level - Bangkok","Level - Colorado","Level - Hokkaido","Level - Miami","Level - Santa Fortuna","Level - Mumbai","Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - Haven Island","Level - Dubai","Level - Dartmoor","Level - Berlin","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Coin":(3, ["ica_facility", "paris", "sapienza", "marrakesh", "bangkok", "colorado", "hokkaido", "hawkes_bay", "miami", "santa_fortuna", "mumbai", "whittleton_creek", "ambrose_island", "isle_of_sgail", "new_york", "haven_island", "dubai", "dartmoor", "berlin", "chongqing", "mendoza"], ["itemsanity"], ["Level - ICA Facility","Level - Paris","Level - Sapienza","Level - Marrakesh","Level - Bangkok","Level - Colorado","Level - Hokkaido","Level - Hawkes Bay","Level - Miami","Level - Santa Fortuna","Level - Mumbai","Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - New York","Level - Haven Island","Level - Dubai","Level - Dartmoor","Level - Berlin","Level - Chongqing","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Emetic Rat Poison":(4, ["ica_facility", "sapienza", "marrakesh", "bangkok", "colorado", "hokkaido", "hawkes_bay", "miami", "santa_fortuna", "mumbai", "whittleton_creek", "ambrose_island", "isle_of_sgail", "new_york", "haven_island", "dubai", "dartmoor", "berlin", "chongqing", "mendoza"], ["itemsanity"], ["Level - ICA Facility","Level - Sapienza","Level - Marrakesh","Level - Bangkok","Level - Colorado","Level - Hokkaido","Level - Hawkes Bay","Level - Miami","Level - Santa Fortuna","Level - Mumbai","Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - New York","Level - Haven Island","Level - Dubai","Level - Dartmoor","Level - Berlin","Level - Chongqing","Level - Mendoza"], ["paris"], ["Level - Paris"], ["Itempickup - Any"]),
    "Itempickup - Wrench":(5, ["ica_facility", "paris", "sapienza", "marrakesh", "bangkok", "colorado", "hokkaido", "hawkes_bay", "miami", "santa_fortuna", "mumbai", "whittleton_creek", "ambrose_island", "isle_of_sgail", "new_york", "haven_island", "dubai", "dartmoor", "berlin", "chongqing", "mendoza"], ["itemsanity"], ["Level - ICA Facility","Level - Paris","Level - Sapienza","Level - Marrakesh","Level - Bangkok","Level - Colorado","Level - Hokkaido","Level - Hawkes Bay","Level - Miami","Level - Santa Fortuna","Level - Mumbai","Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - New York","Level - Haven Island","Level - Dubai","Level - Dartmoor","Level - Berlin","Level - Chongqing","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Lead Pipe":(6, ["ica_facility", "paris", "sapienza", "bangkok", "colorado", "hokkaido", "hawkes_bay", "miami", "santa_fortuna", "mumbai", "whittleton_creek", "ambrose_island", "isle_of_sgail", "new_york", "haven_island", "dartmoor", "berlin", "chongqing"], ["itemsanity"], ["Level - ICA Facility","Level - Paris","Level - Sapienza","Level - Bangkok","Level - Colorado","Level - Hokkaido","Level - Hawkes Bay","Level - Miami","Level - Santa Fortuna","Level - Mumbai","Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - New York","Level - Haven Island","Level - Dartmoor","Level - Berlin","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Pool Ball":(7, ["ica_facility", "marrakesh", "bangkok", "santa_fortuna", "new_york", "dartmoor", "berlin"], ["itemsanity"], ["Level - ICA Facility","Level - Marrakesh","Level - Bangkok","Level - Santa Fortuna","Level - New York","Level - Dartmoor","Level - Berlin"], [], [], ["Itempickup - Any"]),
    "Itempickup - Brick":(8, ["ica_facility", "paris", "sapienza", "marrakesh", "colorado", "miami", "santa_fortuna", "mumbai", "whittleton_creek", "ambrose_island", "isle_of_sgail", "dartmoor", "berlin", "chongqing", "mendoza", "carpathian_mountains"], ["itemsanity"], ["Level - ICA Facility","Level - Paris","Level - Sapienza","Level - Marrakesh","Level - Colorado","Level - Miami","Level - Santa Fortuna","Level - Mumbai","Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - Dartmoor","Level - Berlin","Level - Chongqing","Level - Mendoza","Level - Carpathian Mountains"], [], [], ["Itempickup - Any"]),
    "Itempickup - Bust":(9, ["ica_facility", "paris", "sapienza", "hokkaido", "hawkes_bay", "miami", "whittleton_creek", "isle_of_sgail", "new_york", "dartmoor"], ["itemsanity"], ["Level - ICA Facility","Level - Paris","Level - Sapienza","Level - Hokkaido","Level - Hawkes Bay","Level - Miami","Level - Whittleton Creek","Level - Isle of Sgail","Level - New York","Level - Dartmoor"], [], [], ["Itempickup - Any"]),
    "Itempickup - Scissors":(10, ["paris", "sapienza", "marrakesh", "hokkaido", "hawkes_bay", "miami", "santa_fortuna", "mumbai", "whittleton_creek", "ambrose_island", "isle_of_sgail", "new_york", "haven_island", "dubai", "dartmoor", "chongqing"], ["itemsanity"], ["Level - Paris","Level - Sapienza","Level - Marrakesh","Level - Hokkaido","Level - Hawkes Bay","Level - Miami","Level - Santa Fortuna","Level - Mumbai","Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - New York","Level - Haven Island","Level - Dubai","Level - Dartmoor","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Screwdriver":(11, ["paris", "sapienza", "marrakesh", "bangkok", "colorado", "hokkaido", "hawkes_bay", "miami", "santa_fortuna", "mumbai", "whittleton_creek", "ambrose_island", "isle_of_sgail", "new_york", "haven_island", "dubai", "dartmoor", "berlin", "chongqing", "mendoza"], ["itemsanity"], ["Level - Paris","Level - Sapienza","Level - Marrakesh","Level - Bangkok","Level - Colorado","Level - Hokkaido","Level - Hawkes Bay","Level - Miami","Level - Santa Fortuna","Level - Mumbai","Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - New York","Level - Haven Island","Level - Dubai","Level - Dartmoor","Level - Berlin","Level - Chongqing","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Letter Opener":(12, ["paris", "sapienza", "marrakesh", "bangkok", "santa_fortuna", "mumbai", "whittleton_creek", "ambrose_island", "isle_of_sgail", "new_york", "haven_island", "dubai", "dartmoor", "chongqing"], ["itemsanity"], ["Level - Paris","Level - Sapienza","Level - Marrakesh","Level - Bangkok","Level - Santa Fortuna","Level - Mumbai","Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - New York","Level - Haven Island","Level - Dubai","Level - Dartmoor","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Fire Axe":(13, ["paris", "sapienza", "marrakesh", "bangkok", "hokkaido", "miami", "mumbai", "whittleton_creek", "isle_of_sgail", "new_york", "haven_island", "dubai", "berlin", "chongqing", "mendoza", "carpathian_mountains"], ["itemsanity"], ["Level - Paris","Level - Sapienza","Level - Marrakesh","Level - Bangkok","Level - Hokkaido","Level - Miami","Level - Mumbai","Level - Whittleton Creek","Level - Isle of Sgail","Level - New York","Level - Haven Island","Level - Dubai","Level - Berlin","Level - Chongqing","Level - Mendoza","Level - Carpathian Mountains"], [], [], ["Itempickup - Any"]),
    "Itempickup - Fusil G2":(14, ["paris", "bangkok", "colorado", "whittleton_creek", "isle_of_sgail", "haven_island"], ["itemsanity"], ["Level - Paris","Level - Bangkok","Level - Colorado","Level - Whittleton Creek","Level - Isle of Sgail","Level - Haven Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Remote Explosive":(15, ["paris", "sapienza", "marrakesh", "santa_fortuna", "whittleton_creek", "haven_island", "chongqing"], ["itemsanity"], ["Level - Paris","Level - Sapienza","Level - Marrakesh","Level - Santa Fortuna","Level - Whittleton Creek","Level - Haven Island","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Bartoli 75R":(16, ["paris", "sapienza", "marrakesh", "bangkok", "colorado", "miami", "whittleton_creek", "new_york", "dubai", "berlin", "chongqing"], ["itemsanity"], ["Level - Paris","Level - Sapienza","Level - Marrakesh","Level - Bangkok","Level - Colorado","Level - Miami","Level - Whittleton Creek","Level - New York","Level - Dubai","Level - Berlin","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Fire Extinguisher":(17, ["paris", "sapienza", "marrakesh", "bangkok", "colorado", "hokkaido", "miami", "santa_fortuna", "mumbai", "whittleton_creek", "ambrose_island", "isle_of_sgail", "new_york", "haven_island", "dubai", "berlin", "chongqing", "mendoza", "carpathian_mountains"], ["itemsanity"], ["Level - Paris","Level - Sapienza","Level - Marrakesh","Level - Bangkok","Level - Colorado","Level - Hokkaido","Level - Miami","Level - Santa Fortuna","Level - Mumbai","Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - New York","Level - Haven Island","Level - Dubai","Level - Berlin","Level - Chongqing","Level - Mendoza","Level - Carpathian Mountains"], [], [], ["Itempickup - Any"]),
    "Itempickup - Tactical Bartoli 12G":(18, ["paris", "sapienza", "marrakesh", "bangkok", "colorado", "hokkaido", "miami", "isle_of_sgail", "new_york", "haven_island", "berlin", "chongqing"], ["itemsanity"], ["Level - Paris","Level - Sapienza","Level - Marrakesh","Level - Bangkok","Level - Colorado","Level - Hokkaido","Level - Miami","Level - Isle of Sgail","Level - New York","Level - Haven Island","Level - Berlin","Level - Chongqing"], ["hawkes_bay"], ["Level - Hawkes Bay"], ["Itempickup - Any"]),
    "Itempickup - Kitchen Knife":(19, ["paris", "sapienza", "marrakesh", "bangkok", "colorado", "hokkaido", "hawkes_bay", "miami", "santa_fortuna", "mumbai", "whittleton_creek", "ambrose_island", "isle_of_sgail", "haven_island", "dubai", "dartmoor", "berlin", "chongqing", "mendoza"], ["itemsanity"], ["Level - Paris","Level - Sapienza","Level - Marrakesh","Level - Bangkok","Level - Colorado","Level - Hokkaido","Level - Hawkes Bay","Level - Miami","Level - Santa Fortuna","Level - Mumbai","Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - Haven Island","Level - Dubai","Level - Dartmoor","Level - Berlin","Level - Chongqing","Level - Mendoza"], ["new_york"], ["Level - New York"], ["Itempickup - Any"]),
    "Itempickup - Propane Flask":(20, ["paris", "sapienza", "marrakesh", "bangkok", "colorado", "hokkaido", "hawkes_bay", "miami", "santa_fortuna", "mumbai", "whittleton_creek", "ambrose_island", "isle_of_sgail", "new_york", "haven_island", "dubai", "dartmoor", "berlin", "chongqing", "mendoza"], ["itemsanity"], ["Level - Paris","Level - Sapienza","Level - Marrakesh","Level - Bangkok","Level - Colorado","Level - Hokkaido","Level - Hawkes Bay","Level - Miami","Level - Santa Fortuna","Level - Mumbai","Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - New York","Level - Haven Island","Level - Dubai","Level - Dartmoor","Level - Berlin","Level - Chongqing","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Cleaver":(21, ["paris", "sapienza", "marrakesh", "bangkok", "colorado", "hokkaido", "hawkes_bay", "miami", "santa_fortuna", "mumbai", "ambrose_island", "isle_of_sgail", "haven_island", "dubai", "dartmoor", "chongqing"], ["itemsanity"], ["Level - Paris","Level - Sapienza","Level - Marrakesh","Level - Bangkok","Level - Colorado","Level - Hokkaido","Level - Hawkes Bay","Level - Miami","Level - Santa Fortuna","Level - Mumbai","Level - Ambrose Island","Level - Isle of Sgail","Level - Haven Island","Level - Dubai","Level - Dartmoor","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Frying Pan":(22, ["paris", "hokkaido", "miami", "santa_fortuna", "mumbai", "ambrose_island", "isle_of_sgail", "haven_island", "dubai", "berlin", "chongqing", "mendoza"], ["itemsanity"], ["Level - Paris","Level - Hokkaido","Level - Miami","Level - Santa Fortuna","Level - Mumbai","Level - Ambrose Island","Level - Isle of Sgail","Level - Haven Island","Level - Dubai","Level - Berlin","Level - Chongqing","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Fire Poker":(23, ["paris", "sapienza", "hokkaido", "hawkes_bay", "isle_of_sgail", "dartmoor", "mendoza"], ["itemsanity"], ["Level - Paris","Level - Sapienza","Level - Hokkaido","Level - Hawkes Bay","Level - Isle of Sgail","Level - Dartmoor","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Hatchet":(24, ["paris", "sapienza", "bangkok", "whittleton_creek", "isle_of_sgail", "haven_island", "dartmoor", "mendoza"], ["itemsanity"], ["Level - Paris","Level - Sapienza","Level - Bangkok","Level - Whittleton Creek","Level - Isle of Sgail","Level - Haven Island","Level - Dartmoor","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Battle Axe":(25, ["paris", "sapienza", "marrakesh", "miami", "whittleton_creek", "isle_of_sgail", "berlin"], ["itemsanity"], ["Level - Paris","Level - Sapienza","Level - Marrakesh","Level - Miami","Level - Whittleton Creek","Level - Isle of Sgail","Level - Berlin"], [], [], ["Itempickup - Any"]),
    "Itempickup - Saber":(26, ["paris", "sapienza", "marrakesh", "mumbai", "isle_of_sgail", "dartmoor"], ["itemsanity"], ["Level - Paris","Level - Sapienza","Level - Marrakesh","Level - Mumbai","Level - Isle of Sgail","Level - Dartmoor"], [], [], ["Itempickup - Any"]),
    "Itempickup - Golf Club":(27, ["paris", "sapienza", "bangkok", "miami", "whittleton_creek", "new_york", "haven_island", "dubai", "dartmoor"], ["itemsanity"], ["Level - Paris","Level - Sapienza","Level - Bangkok","Level - Miami","Level - Whittleton Creek","Level - New York","Level - Haven Island","Level - Dubai","Level - Dartmoor"], [], [], ["Itempickup - Any"]),
    "Itempickup - Police Baton":(28, ["paris", "sapienza", "bangkok", "hokkaido", "miami", "new_york", "haven_island", "berlin"], ["itemsanity"], ["Level - Paris","Level - Sapienza","Level - Bangkok","Level - Hokkaido","Level - Miami","Level - New York","Level - Haven Island","Level - Berlin"], [], [], ["Itempickup - Any"]),
    "Itempickup - Lethal Poison Pill Jar":(29, ["marrakesh", "bangkok", "colorado", "hawkes_bay", "miami", "santa_fortuna", "mumbai", "new_york", "haven_island", "dubai", "dartmoor", "chongqing", "mendoza"], ["itemsanity"], ["Level - Marrakesh","Level - Bangkok","Level - Colorado","Level - Hawkes Bay","Level - Miami","Level - Santa Fortuna","Level - Mumbai","Level - New York","Level - Haven Island","Level - Dubai","Level - Dartmoor","Level - Chongqing","Level - Mendoza"], ["paris"], ["Level - Paris"], ["Itempickup - Any"]),
    "Itempickup - Shovel":(30, ["sapienza", "bangkok", "colorado", "hokkaido", "miami", "santa_fortuna", "mumbai", "whittleton_creek", "ambrose_island", "isle_of_sgail", "haven_island", "dubai", "dartmoor", "berlin", "mendoza"], ["itemsanity"], ["Level - Sapienza","Level - Bangkok","Level - Colorado","Level - Hokkaido","Level - Miami","Level - Santa Fortuna","Level - Mumbai","Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - Haven Island","Level - Dubai","Level - Dartmoor","Level - Berlin","Level - Mendoza"], ["hawkes_bay"], ["Level - Hawkes Bay"], ["Itempickup - Any"]),
    "Itempickup - Circumcision Knife":(31, ["sapienza", "isle_of_sgail"], ["itemsanity"], ["Level - Sapienza","Level - Isle of Sgail"], [], [], ["Itempickup - Any"]),
    "Itempickup - Amputation Knife":(32, ["sapienza", "miami", "mumbai"], ["itemsanity"], ["Level - Sapienza","Level - Miami","Level - Mumbai"], [], [], ["Itempickup - Any"]),
    "Itempickup - Toy Tank":(33, ["sapienza", "marrakesh", "new_york", "berlin", "chongqing"], ["itemsanity"], ["Level - Sapienza","Level - Marrakesh","Level - New York","Level - Berlin","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Expired Can of Spaghetti Sauce":(34, ["sapienza", "hawkes_bay", "santa_fortuna", "mumbai", "whittleton_creek", "isle_of_sgail"], ["itemsanity"], ["Level - Sapienza","Level - Hawkes Bay","Level - Santa Fortuna","Level - Mumbai","Level - Whittleton Creek","Level - Isle of Sgail"], [], [], ["Itempickup - Any"]),
    "Itempickup - Soda Can":(35, ["sapienza", "marrakesh", "bangkok", "colorado", "hokkaido", "hawkes_bay", "miami", "santa_fortuna", "mumbai", "whittleton_creek", "ambrose_island", "isle_of_sgail", "new_york", "haven_island", "dubai", "dartmoor", "berlin", "chongqing", "mendoza", "carpathian_mountains"], ["itemsanity"], ["Level - Sapienza","Level - Marrakesh","Level - Bangkok","Level - Colorado","Level - Hokkaido","Level - Hawkes Bay","Level - Miami","Level - Santa Fortuna","Level - Mumbai","Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - New York","Level - Haven Island","Level - Dubai","Level - Dartmoor","Level - Berlin","Level - Chongqing","Level - Mendoza","Level - Carpathian Mountains"], [], [], ["Itempickup - Any"]),
    "Itempickup - Bartoli 75S":(36, ["sapienza", "santa_fortuna", "mumbai", "isle_of_sgail", "haven_island", "mendoza"], ["itemsanity"], ["Level - Sapienza","Level - Santa Fortuna","Level - Mumbai","Level - Isle of Sgail","Level - Haven Island","Level - Mendoza"], ["hawkes_bay"], ["Level - Hawkes Bay"], ["Itempickup - Any"]),
    "Itempickup - Virus Prototype":(37, ["sapienza"], ["itemsanity"], ["Level - Sapienza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Combat Knife":(38, ["sapienza", "berlin", "mendoza"], ["itemsanity"], ["Level - Sapienza","Level - Berlin","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Baseball Bat":(39, ["sapienza", "bangkok", "colorado", "hokkaido", "miami", "santa_fortuna", "mumbai", "whittleton_creek", "isle_of_sgail", "haven_island", "berlin"], ["itemsanity"], ["Level - Sapienza","Level - Bangkok","Level - Colorado","Level - Hokkaido","Level - Miami","Level - Santa Fortuna","Level - Mumbai","Level - Whittleton Creek","Level - Isle of Sgail","Level - Haven Island","Level - Berlin"], [], [], ["Itempickup - Any"]),
    "Itempickup - Explosive Golf Ball":(40, ["sapienza", "dubai"], ["itemsanity"], ["Level - Sapienza","Level - Dubai"], [], [], ["Itempickup - Any"]),
    "Itempickup - Folding Knife":(41, ["sapienza", "hawkes_bay", "santa_fortuna", "mumbai", "ambrose_island", "new_york", "haven_island", "dubai", "dartmoor"], ["itemsanity"], ["Level - Sapienza","Level - Hawkes Bay","Level - Santa Fortuna","Level - Mumbai","Level - Ambrose Island","Level - New York","Level - Haven Island","Level - Dubai","Level - Dartmoor"], [], [], ["Itempickup - Any"]),
    "Itempickup - Old Axe":(42, ["sapienza", "colorado", "miami", "mumbai", "ambrose_island", "isle_of_sgail", "berlin", "mendoza"], ["itemsanity"], ["Level - Sapienza","Level - Colorado","Level - Miami","Level - Mumbai","Level - Ambrose Island","Level - Isle of Sgail","Level - Berlin","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Radio":(43, ["sapienza"], ["itemsanity"], ["Level - Sapienza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Bag of Gunpowder":(44, ["sapienza", "santa_fortuna", "isle_of_sgail", "mendoza"], ["itemsanity"], ["Level - Sapienza","Level - Santa Fortuna","Level - Isle of Sgail","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Cannonball":(45, ["sapienza", "ambrose_island", "isle_of_sgail", "mendoza"], ["itemsanity"], ["Level - Sapienza","Level - Ambrose Island","Level - Isle of Sgail","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Bartoli 12G":(46, ["sapienza", "colorado", "santa_fortuna", "mumbai"], ["itemsanity"], ["Level - Sapienza","Level - Colorado","Level - Santa Fortuna","Level - Mumbai"], [], [], ["Itempickup - Any"]),
    "Itempickup - Katana":(47, ["sapienza", "bangkok", "hokkaido", "hawkes_bay", "isle_of_sgail"], ["itemsanity"], ["Level - Sapienza","Level - Bangkok","Level - Hokkaido","Level - Hawkes Bay","Level - Isle of Sgail"], [], [], ["Itempickup - Any"]),
    "Itempickup - Shashka A33":(48, ["marrakesh", "santa_fortuna", "mumbai", "ambrose_island"], ["itemsanity"], ["Level - Marrakesh","Level - Santa Fortuna","Level - Mumbai","Level - Ambrose Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Fusil G1-4":(49, ["marrakesh", "dubai"], ["itemsanity"], ["Level - Marrakesh","Level - Dubai"], [], [], ["Itempickup - Any"]),
    "Itempickup - Insecticide":(50, ["bangkok", "whittleton_creek", "berlin"], ["itemsanity"], ["Level - Bangkok","Level - Whittleton Creek","Level - Berlin"], [], [], ["Itempickup - Any"]),
    "Itempickup - Coconut":(51, ["bangkok", "miami", "santa_fortuna", "ambrose_island", "isle_of_sgail", "haven_island", "dubai", "berlin"], ["itemsanity"], ["Level - Bangkok","Level - Miami","Level - Santa Fortuna","Level - Ambrose Island","Level - Isle of Sgail","Level - Haven Island","Level - Dubai","Level - Berlin"], [], [], ["Itempickup - Any"]),
    "Itempickup - Sapper's Axe":(52, ["bangkok", "isle_of_sgail", "mendoza"], ["itemsanity"], ["Level - Bangkok","Level - Isle of Sgail","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Apricot":(53, ["colorado", "miami", "santa_fortuna", "ambrose_island", "isle_of_sgail", "new_york", "dartmoor", "chongqing"], ["itemsanity"], ["Level - Colorado","Level - Miami","Level - Santa Fortuna","Level - Ambrose Island","Level - Isle of Sgail","Level - New York","Level - Dartmoor","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Baseball":(54, ["colorado", "miami", "santa_fortuna", "whittleton_creek", "haven_island", "dartmoor", "berlin"], ["itemsanity"], ["Level - Colorado","Level - Miami","Level - Santa Fortuna","Level - Whittleton Creek","Level - Haven Island","Level - Dartmoor","Level - Berlin"], [], [], ["Itempickup - Any"]),
    "Itempickup - Cowboy Bust":(55, ["colorado", "hokkaido", "santa_fortuna", "isle_of_sgail", "chongqing"], ["itemsanity"], ["Level - Colorado","Level - Hokkaido","Level - Santa Fortuna","Level - Isle of Sgail","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Explosive Watch Battery":(56, ["colorado"], ["itemsanity"], ["Level - Colorado"], [], [], ["Itempickup - Any"]),
    "Itempickup - Nitroglycerin":(57, ["colorado", "ambrose_island", "isle_of_sgail"], ["itemsanity"], ["Level - Colorado","Level - Ambrose Island","Level - Isle of Sgail"], [], [], ["Itempickup - Any"]),
    "Itempickup - Modern Lethal Syringe":(58, ["colorado", "miami", "berlin"], ["itemsanity"], ["Level - Colorado","Level - Miami","Level - Berlin"], [], [], ["Itempickup - Any"]),
    "Itempickup - HX-10":(59, ["colorado", "isle_of_sgail", "haven_island", "dubai"], ["itemsanity"], ["Level - Colorado","Level - Isle of Sgail","Level - Haven Island","Level - Dubai"], [], [], ["Itempickup - Any"]),
    "Itempickup - Branding Iron":(60, ["colorado", "isle_of_sgail"], ["itemsanity"], ["Level - Colorado","Level - Isle of Sgail"], [], [], ["Itempickup - Any"]),
    "Itempickup - Mannequin Arm":(61, ["colorado", "chongqing"], ["itemsanity"], ["Level - Colorado","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - HX-7":(62, ["colorado", "hokkaido"], ["itemsanity"], ["Level - Colorado","Level - Hokkaido"], ["hawkes_bay"], ["Level - Hawkes Bay"], ["Itempickup - Any"]),
    "Itempickup - Scalpel":(63, ["hokkaido", "isle_of_sgail", "haven_island"], ["itemsanity"], ["Level - Hokkaido","Level - Isle of Sgail","Level - Haven Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Botulinum Toxin":(64, ["hokkaido", "isle_of_sgail"], ["itemsanity"], ["Level - Hokkaido","Level - Isle of Sgail"], [], [], ["Itempickup - Any"]),
    "Itempickup - Hackl 9S Covert":(65, ["santa_fortuna", "whittleton_creek", "isle_of_sgail", "haven_island", "dubai", "dartmoor", "chongqing", "mendoza"], ["itemsanity"], ["Level - Santa Fortuna","Level - Whittleton Creek","Level - Isle of Sgail","Level - Haven Island","Level - Dubai","Level - Dartmoor","Level - Chongqing","Level - Mendoza"], ["hawkes_bay"], ["Level - Hawkes Bay"], ["Itempickup - Any"]),
    "Itempickup - Kalmer 1 - Tranquilizer":(66, ["new_york"], ["itemsanity"], ["Level - New York"], ["hawkes_bay"], ["Level - Hawkes Bay"], ["Itempickup - Any"]),
    "Itempickup - Chloroform Flask":(67, ["hawkes_bay", "isle_of_sgail", "new_york", "chongqing"], ["itemsanity"], ["Level - Hawkes Bay","Level - Isle of Sgail","Level - New York","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Squeaky Toy":(68, ["hawkes_bay"], ["itemsanity"], ["Level - Hawkes Bay"], [], [], ["Itempickup - Any"]),
    "Itempickup - Shuriken":(69, ["hawkes_bay"], ["itemsanity"], ["Level - Hawkes Bay"], [], [], ["Itempickup - Any"]),
    "Itempickup - Maori Paddle":(70, ["haven_island", "dartmoor"], ["itemsanity"], ["Level - Haven Island","Level - Dartmoor"], ["hawkes_bay"], ["Level - Hawkes Bay"], ["Itempickup - Any"]),
    "Itempickup - Wristwatch Alarm":(71, ["hawkes_bay", "new_york"], ["itemsanity"], ["Level - Hawkes Bay","Level - New York"], [], [], ["Itempickup - Any"]),
    "Itempickup - Driftwood Log":(72, ["hawkes_bay", "santa_fortuna", "ambrose_island", "isle_of_sgail", "haven_island", "dartmoor", "chongqing"], ["itemsanity"], ["Level - Hawkes Bay","Level - Santa Fortuna","Level - Ambrose Island","Level - Isle of Sgail","Level - Haven Island","Level - Dartmoor","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Car Battery":(73, ["hawkes_bay", "santa_fortuna", "mumbai", "whittleton_creek", "ambrose_island", "isle_of_sgail", "new_york", "dubai", "dartmoor", "berlin", "chongqing", "mendoza"], ["itemsanity"], ["Level - Hawkes Bay","Level - Santa Fortuna","Level - Mumbai","Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - New York","Level - Dubai","Level - Dartmoor","Level - Berlin","Level - Chongqing","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Apple":(74, ["hawkes_bay", "whittleton_creek", "ambrose_island", "isle_of_sgail", "new_york", "haven_island", "dubai", "dartmoor", "chongqing", "mendoza"], ["itemsanity"], ["Level - Hawkes Bay","Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - New York","Level - Haven Island","Level - Dubai","Level - Dartmoor","Level - Chongqing","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Fragmentation Grenade":(75, ["hawkes_bay", "carpathian_mountains"], ["itemsanity"], ["Level - Hawkes Bay","Level - Carpathian Mountains"], [], [], ["Itempickup - Any"]),
    "Itempickup - Kronstadt Octane Booster":(76, ["miami"], ["itemsanity"], ["Level - Miami"], [], [], ["Itempickup - Any"]),
    "Itempickup - Didgeridoo":(77, ["miami"], ["itemsanity"], ["Level - Miami"], [], [], ["Itempickup - Any"]),
    "Itempickup - Android Arm":(78, ["miami"], ["itemsanity"], ["Level - Miami"], [], [], ["Itempickup - Any"]),
    "Itempickup - Bag of Sugar":(79, ["miami", "ambrose_island", "dartmoor", "berlin"], ["itemsanity"], ["Level - Miami","Level - Ambrose Island","Level - Dartmoor","Level - Berlin"], [], [], ["Itempickup - Any"]),
    "Itempickup - Fish":(80, ["miami", "mumbai", "ambrose_island", "isle_of_sgail", "haven_island", "dartmoor", "mendoza"], ["itemsanity"], ["Level - Miami","Level - Mumbai","Level - Ambrose Island","Level - Isle of Sgail","Level - Haven Island","Level - Dartmoor","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Pneumatic Wrench":(81, ["miami"], ["itemsanity"], ["Level - Miami"], [], [], ["Itempickup - Any"]),
    "Itempickup - Car Bomb":(82, ["miami", "whittleton_creek"], ["itemsanity"], ["Level - Miami","Level - Whittleton Creek"], [], [], ["Itempickup - Any"]),
    "Itempickup - Cocaine Brick":(83, ["miami", "santa_fortuna", "isle_of_sgail", "berlin", "mendoza"], ["itemsanity"], ["Level - Miami","Level - Santa Fortuna","Level - Isle of Sgail","Level - Berlin","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Starfish":(84, ["miami", "ambrose_island", "isle_of_sgail", "haven_island"], ["itemsanity"], ["Level - Miami","Level - Ambrose Island","Level - Isle of Sgail","Level - Haven Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Cannabis Joint":(85, ["miami", "whittleton_creek"], ["itemsanity"], ["Level - Miami","Level - Whittleton Creek"], [], [], ["Itempickup - Any"]),
    "Itempickup - The Big One":(86, ["miami"], ["itemsanity"], ["Level - Miami"], [], [], ["Itempickup - Any"]),
    "Itempickup - Meaty Bone":(87, ["santa_fortuna", "whittleton_creek", "ambrose_island", "isle_of_sgail", "haven_island", "dubai", "chongqing", "mendoza"], ["itemsanity"], ["Level - Santa Fortuna","Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - Haven Island","Level - Dubai","Level - Chongqing","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - DAK X2":(88, ["santa_fortuna", "mumbai", "whittleton_creek", "new_york"], ["itemsanity"], ["Level - Santa Fortuna","Level - Mumbai","Level - Whittleton Creek","Level - New York"], [], [], ["Itempickup - Any"]),
    "Itempickup - Poisonous Flower (Emetic)":(89, ["santa_fortuna", "ambrose_island", "haven_island", "dartmoor", "mendoza"], ["itemsanity"], ["Level - Santa Fortuna","Level - Ambrose Island","Level - Haven Island","Level - Dartmoor","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Poisonous Flower (Lethal)":(90, ["santa_fortuna"], ["itemsanity"], ["Level - Santa Fortuna"], [], [], ["Itempickup - Any"]),
    "Itempickup - Lethal Poisonous Frog":(91, ["santa_fortuna", "whittleton_creek", "ambrose_island", "haven_island"], ["itemsanity"], ["Level - Santa Fortuna","Level - Whittleton Creek","Level - Ambrose Island","Level - Haven Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Letterbomb Parcel":(92, ["santa_fortuna", "new_york"], ["itemsanity"], ["Level - Santa Fortuna","Level - New York"], [], [], ["Itempickup - Any"]),
    "Itempickup - Collectors Baseball Bat":(93, ["santa_fortuna"], ["itemsanity"], ["Level - Santa Fortuna"], [], [], ["Itempickup - Any"]),
    "Itempickup - Machete":(94, ["santa_fortuna", "haven_island", "mendoza"], ["itemsanity"], ["Level - Santa Fortuna","Level - Haven Island","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Claw Hammer":(95, ["santa_fortuna", "new_york", "mendoza", "carpathian_mountains"], ["itemsanity"], ["Level - Santa Fortuna","Level - New York","Level - Mendoza","Level - Carpathian Mountains"], [], [], ["Itempickup - Any"]),
    "Itempickup - Shashka A33 Gold":(96, ["santa_fortuna", "ambrose_island"], ["itemsanity"], ["Level - Santa Fortuna","Level - Ambrose Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Gold Idol":(97, ["santa_fortuna", "ambrose_island", "isle_of_sgail", "new_york", "haven_island", "dubai", "berlin"], ["itemsanity"], ["Level - Santa Fortuna","Level - Ambrose Island","Level - Isle of Sgail","Level - New York","Level - Haven Island","Level - Dubai","Level - Berlin"], [], [], ["Itempickup - Any"]),
    "Itempickup - Sacrificial Knife":(98, ["santa_fortuna", "isle_of_sgail"], ["itemsanity"], ["Level - Santa Fortuna","Level - Isle of Sgail"], [], [], ["Itempickup - Any"]),
    "Itempickup - Barber Razor":(99, ["santa_fortuna", "mumbai", "ambrose_island", "haven_island", "dartmoor", "carpathian_mountains"], ["itemsanity"], ["Level - Santa Fortuna","Level - Mumbai","Level - Ambrose Island","Level - Haven Island","Level - Dartmoor","Level - Carpathian Mountains"], [], [], ["Itempickup - Any"]),
    "Itempickup - \"El Matador\"":(100, ["santa_fortuna"], ["itemsanity"], ["Level - Santa Fortuna"], [], [], ["Itempickup - Any"]),
    "Itempickup - Cocaine Souvenir":(101, ["santa_fortuna"], ["itemsanity"], ["Level - Santa Fortuna"], [], [], ["Itempickup - Any"]),
    "Itempickup - Beak Staff":(102, ["mumbai", "whittleton_creek"], ["itemsanity"], ["Level - Mumbai","Level - Whittleton Creek"], [], [], ["Itempickup - Any"]),
    "Itempickup - Iron":(103, ["mumbai", "ambrose_island", "isle_of_sgail", "new_york", "haven_island", "dubai", "dartmoor", "berlin", "chongqing"], ["itemsanity"], ["Level - Mumbai","Level - Ambrose Island","Level - Isle of Sgail","Level - New York","Level - Haven Island","Level - Dubai","Level - Dartmoor","Level - Berlin","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Chennai Cricket Ball":(104, ["mumbai"], ["itemsanity"], ["Level - Mumbai"], [], [], ["Itempickup - Any"]),
    "Itempickup - Lever":(105, ["mumbai"], ["itemsanity"], ["Level - Mumbai"], [], [], ["Itempickup - Any"]),
    "Itempickup - Colored Smoke":(106, ["mumbai"], ["itemsanity"], ["Level - Mumbai"], [], [], ["Itempickup - Any"]),
    "Itempickup - Khatvanga":(107, ["mumbai", "ambrose_island", "isle_of_sgail"], ["itemsanity"], ["Level - Mumbai","Level - Ambrose Island","Level - Isle of Sgail"], [], [], ["Itempickup - Any"]),
    "Itempickup - Measuring Tape":(108, ["mumbai"], ["itemsanity"], ["Level - Mumbai"], [], [], ["Itempickup - Any"]),
    "Itempickup - Druzhina 34":(109, ["mumbai"], ["itemsanity"], ["Level - Mumbai"], [], [], ["Itempickup - Any"]),
    "Itempickup - Rake":(110, ["mumbai", "whittleton_creek", "dartmoor", "mendoza"], ["itemsanity"], ["Level - Mumbai","Level - Whittleton Creek","Level - Dartmoor","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - DAK X2 Covert Special":(111, ["whittleton_creek"], ["itemsanity"], ["Level - Whittleton Creek"], [], [], ["Itempickup - Any"]),
    "Itempickup - Flash Grenade":(112, ["whittleton_creek", "isle_of_sgail", "new_york", "carpathian_mountains"], ["itemsanity"], ["Level - Whittleton Creek","Level - Isle of Sgail","Level - New York","Level - Carpathian Mountains"], [], [], ["Itempickup - Any"]),
    "Itempickup - Blueberry Muffin":(113, ["whittleton_creek", "isle_of_sgail", "new_york", "haven_island", "dubai", "berlin", "chongqing", "carpathian_mountains"], ["itemsanity"], ["Level - Whittleton Creek","Level - Isle of Sgail","Level - New York","Level - Haven Island","Level - Dubai","Level - Berlin","Level - Chongqing","Level - Carpathian Mountains"], [], [], ["Itempickup - Any"]),
    "Itempickup - Newspaper":(114, ["whittleton_creek", "ambrose_island", "isle_of_sgail", "new_york", "haven_island", "dartmoor", "chongqing"], ["itemsanity"], ["Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - New York","Level - Haven Island","Level - Dartmoor","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Lethal Pills":(115, ["whittleton_creek", "berlin"], ["itemsanity"], ["Level - Whittleton Creek","Level - Berlin"], [], [], ["Itempickup - Any"]),
    "Itempickup - Emetic Pills":(116, ["whittleton_creek", "dubai"], ["itemsanity"], ["Level - Whittleton Creek","Level - Dubai"], [], [], ["Itempickup - Any"]),
    "Itempickup - \"Rude Ruby\"":(117, ["whittleton_creek"], ["itemsanity"], ["Level - Whittleton Creek"], [], [], ["Itempickup - Any"]),
    "Itempickup - Remote CX Demo Block":(118, ["whittleton_creek"], ["itemsanity"], ["Level - Whittleton Creek"], [], [], ["Itempickup - Any"]),
    "Itempickup - RS-15":(119, ["whittleton_creek"], ["itemsanity"], ["Level - Whittleton Creek"], [], [], ["Itempickup - Any"]),
    "Itempickup - TAC-4 AR Auto":(120, ["whittleton_creek"], ["itemsanity"], ["Level - Whittleton Creek"], [], [], ["Itempickup - Any"]),
    "Itempickup - Fusil G1-4|C":(121, ["whittleton_creek"], ["itemsanity"], ["Level - Whittleton Creek"], [], [], ["Itempickup - Any"]),
    "Itempickup - Paddle":(122, ["whittleton_creek", "ambrose_island", "isle_of_sgail", "haven_island"], ["itemsanity"], ["Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - Haven Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Package":(123, ["whittleton_creek", "new_york", "chongqing"], ["itemsanity"], ["Level - Whittleton Creek","Level - New York","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Cigar Box":(124, ["whittleton_creek", "ambrose_island", "isle_of_sgail", "dartmoor", "chongqing"], ["itemsanity"], ["Level - Whittleton Creek","Level - Ambrose Island","Level - Isle of Sgail","Level - Dartmoor","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Fishing Line":(125, ["ambrose_island", "mendoza"], ["itemsanity"], ["Level - Ambrose Island","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Wooden Torch":(126, ["ambrose_island"], ["itemsanity"], ["Level - Ambrose Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Garden Fork":(127, ["ambrose_island", "dartmoor", "berlin", "chongqing", "mendoza"], ["itemsanity"], ["Level - Ambrose Island","Level - Dartmoor","Level - Berlin","Level - Chongqing","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Whiskey Bottle":(128, ["ambrose_island", "dubai", "chongqing"], ["itemsanity"], ["Level - Ambrose Island","Level - Dubai","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Spray Can":(129, ["ambrose_island", "berlin"], ["itemsanity"], ["Level - Ambrose Island","Level - Berlin"], [], [], ["Itempickup - Any"]),
    "Itempickup - Vodka Bottle":(130, ["ambrose_island"], ["itemsanity"], ["Level - Ambrose Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Soap":(131, ["ambrose_island", "dubai", "dartmoor", "chongqing", "carpathian_mountains"], ["itemsanity"], ["Level - Ambrose Island","Level - Dubai","Level - Dartmoor","Level - Chongqing","Level - Carpathian Mountains"], [], [], ["Itempickup - Any"]),
    "Itempickup - Banana":(132, ["ambrose_island", "haven_island", "dubai", "dartmoor", "berlin", "chongqing", "mendoza"], ["itemsanity"], ["Level - Ambrose Island","Level - Haven Island","Level - Dubai","Level - Dartmoor","Level - Berlin","Level - Chongqing","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Durian":(133, ["ambrose_island"], ["itemsanity"], ["Level - Ambrose Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Meat Fork":(134, ["ambrose_island"], ["itemsanity"], ["Level - Ambrose Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Kukri Machete":(135, ["ambrose_island"], ["itemsanity"], ["Level - Ambrose Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Seashell":(136, ["ambrose_island", "haven_island"], ["itemsanity"], ["Level - Ambrose Island","Level - Haven Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Lethal Poison Vial":(137, ["ambrose_island"], ["itemsanity"], ["Level - Ambrose Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Emetic Gas Grenade":(138, ["ambrose_island"], ["itemsanity"], ["Level - Ambrose Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Sawed-Off Bartoli 12G":(139, ["ambrose_island"], ["itemsanity"], ["Level - Ambrose Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Hook":(140, ["ambrose_island"], ["itemsanity"], ["Level - Ambrose Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Brine-Damaged SMG":(141, ["ambrose_island"], ["itemsanity"], ["Level - Ambrose Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Molotov Cocktail":(142, ["ambrose_island"], ["itemsanity"], ["Level - Ambrose Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Makeshift Explosive":(143, ["ambrose_island"], ["itemsanity"], ["Level - Ambrose Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Remote CX Demo Block MK II":(144, ["ambrose_island", "mendoza"], ["itemsanity"], ["Level - Ambrose Island","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Scrap Sword":(145, ["ambrose_island", "berlin", "chongqing"], ["itemsanity"], ["Level - Ambrose Island","Level - Berlin","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Umbrella":(146, ["ambrose_island", "chongqing", "mendoza"], ["itemsanity"], ["Level - Ambrose Island","Level - Chongqing","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Shears":(147, ["ambrose_island", "dartmoor", "mendoza"], ["itemsanity"], ["Level - Ambrose Island","Level - Dartmoor","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Hobby Knife":(148, ["ambrose_island", "new_york", "berlin", "chongqing", "mendoza"], ["itemsanity"], ["Level - Ambrose Island","Level - New York","Level - Berlin","Level - Chongqing","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Militia-Issued HX-10 SMG":(149, ["ambrose_island"], ["itemsanity"], ["Level - Ambrose Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Remote Breaching Charge":(150, ["ambrose_island"], ["itemsanity"], ["Level - Ambrose Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Doubloon":(151, ["ambrose_island", "haven_island"], ["itemsanity"], ["Level - Ambrose Island","Level - Haven Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Jarl's Pirate Saber":(152, ["ambrose_island", "haven_island", "mendoza"], ["itemsanity"], ["Level - Ambrose Island","Level - Haven Island","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Mace":(153, ["isle_of_sgail"], ["itemsanity"], ["Level - Isle of Sgail"], [], [], ["Itempickup - Any"]),
    "Itempickup - Broadsword":(154, ["isle_of_sgail", "mendoza"], ["itemsanity"], ["Level - Isle of Sgail","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Viking Axe":(155, ["isle_of_sgail"], ["itemsanity"], ["Level - Isle of Sgail"], [], [], ["Itempickup - Any"]),
    "Itempickup - HX-7 Covert":(156, ["isle_of_sgail"], ["itemsanity"], ["Level - Isle of Sgail"], [], [], ["Itempickup - Any"]),
    "Itempickup - Aztec Necklace":(157, ["isle_of_sgail"], ["itemsanity"], ["Level - Isle of Sgail"], [], [], ["Itempickup - Any"]),
    "Itempickup - Imperial Filigree Egg":(158, ["isle_of_sgail", "new_york", "haven_island", "dubai", "dartmoor", "mendoza", "carpathian_mountains"], ["itemsanity"], ["Level - Isle of Sgail","Level - New York","Level - Haven Island","Level - Dubai","Level - Dartmoor","Level - Mendoza","Level - Carpathian Mountains"], [], [], ["Itempickup - Any"]),
    "Itempickup - Torch":(159, ["isle_of_sgail", "mendoza"], ["itemsanity"], ["Level - Isle of Sgail","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Hackl 9S":(160, [], ["itemsanity"], [], ["isle_of_sgail"], ["Level - Isle of Sgail"], ["Itempickup - Any"]),
    "Itempickup - Commemorative Token":(161, ["isle_of_sgail", "new_york"], ["itemsanity"], ["Level - Isle of Sgail","Level - New York"], [], [], ["Itempickup - Any"]),
    "Itempickup - Cheeseburger":(162, ["isle_of_sgail", "new_york", "haven_island"], ["itemsanity"], ["Level - Isle of Sgail","Level - New York","Level - Haven Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Small Goldbar":(163, ["new_york"], ["itemsanity"], ["Level - New York"], [], [], ["Itempickup - Any"]),
    "Itempickup - Violin":(164, ["new_york", "mendoza"], ["itemsanity"], ["Level - New York","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Earphones":(165, ["new_york", "haven_island"], ["itemsanity"], ["Level - New York","Level - Haven Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Tanto":(166, ["new_york", "chongqing"], ["itemsanity"], ["Level - New York","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Burial Dagger":(167, ["new_york"], ["itemsanity"], ["Level - New York"], [], [], ["Itempickup - Any"]),
    "Itempickup - Golden Sawed Off Bartoli 12G":(168, ["new_york"], ["itemsanity"], ["Level - New York"], [], [], ["Itempickup - Any"]),
    "Itempickup - Concussion Grenade":(169, ["new_york"], ["itemsanity"], ["Level - New York"], [], [], ["Itempickup - Any"]),
    "Itempickup - Wet Floor Sign":(170, ["new_york", "haven_island", "dubai", "mendoza"], ["itemsanity"], ["Level - New York","Level - Haven Island","Level - Dubai","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Antique Carved Knife":(171, ["new_york"], ["itemsanity"], ["Level - New York"], [], [], ["Itempickup - Any"]),
    "Itempickup - Goldbar":(172, ["new_york", "dubai"], ["itemsanity"], ["Level - New York","Level - Dubai"], [], [], ["Itempickup - Any"]),
    "Itempickup - Feather Duster":(173, ["new_york", "haven_island", "dartmoor"], ["itemsanity"], ["Level - New York","Level - Haven Island","Level - Dartmoor"], [], [], ["Itempickup - Any"]),
    "Itempickup - Stethoscope":(174, ["haven_island", "chongqing"], ["itemsanity"], ["Level - Haven Island","Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Modern Emetic Syringe":(175, ["haven_island"], ["itemsanity"], ["Level - Haven Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Kettlebell":(176, ["haven_island"], ["itemsanity"], ["Level - Haven Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Pearl":(177, ["haven_island"], ["itemsanity"], ["Level - Haven Island"], [], [], ["Itempickup - Any"]),
    "Itempickup - Ornate Scimitar":(178, ["dubai"], ["itemsanity"], ["Level - Dubai"], [], [], ["Itempickup - Any"]),
    "Itempickup - Model of the Sceptre":(179, ["dubai"], ["itemsanity"], ["Level - Dubai"], [], [], ["Itempickup - Any"]),
    "Itempickup - Classic Coin":(180, ["dartmoor"], ["itemsanity"], ["Level - Dartmoor"], [], [], ["Itempickup - Any"]),
    "Itempickup - Walking Cane":(181, ["dartmoor"], ["itemsanity"], ["Level - Dartmoor"], [], [], ["Itempickup - Any"]),
    "Itempickup - Unicorn Horn":(182, ["dartmoor"], ["itemsanity"], ["Level - Dartmoor"], [], [], ["Itempickup - Any"]),
    "Itempickup - Bartoli Hunting Shotgun":(183, ["dartmoor", "berlin", "mendoza"], ["itemsanity"], ["Level - Dartmoor","Level - Berlin","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Modern Sedative Syringe":(184, ["berlin"], ["itemsanity"], ["Level - Berlin"], [], [], ["Itempickup - Any"]),
    "Itempickup - Bartoli Woodsman Hunting Rifle":(185, ["berlin", "mendoza"], ["itemsanity"], ["Level - Berlin","Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Bird's Egg":(186, ["berlin"], ["itemsanity"], ["Level - Berlin"], [], [], ["Itempickup - Any"]),
    "Itempickup - Poisonous (Emetic) Mushroom":(187, ["berlin"], ["itemsanity"], ["Level - Berlin"], [], [], ["Itempickup - Any"]),
    "Itempickup - Concealable Knife":(188, ["berlin"], ["itemsanity"], ["Level - Berlin"], [], [], ["Itempickup - Any"]),
    "Itempickup - ICA Remote Audio Distraction Mk III":(189, ["berlin"], ["itemsanity"], ["Level - Berlin"], [], [], ["Itempickup - Any"]),
    "Itempickup - Hackl Leviathan Sniper Rifle Covert":(190, ["chongqing"], ["itemsanity"], ["Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - ICA SMG Raptor Covert":(191, ["chongqing"], ["itemsanity"], ["Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Fusil X2000 Stealth":(192, ["chongqing"], ["itemsanity"], ["Level - Chongqing"], [], [], ["Itempickup - Any"]),
    "Itempickup - Cabernet Sauvignon":(193, ["mendoza"], ["itemsanity"], ["Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Grape Knife":(194, ["mendoza"], ["itemsanity"], ["Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Grapevine":(195, ["mendoza"], ["itemsanity"], ["Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Pinot Noir":(196, ["mendoza"], ["itemsanity"], ["Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Malbec":(197, ["mendoza"], ["itemsanity"], ["Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - 1945 Grand Paladin":(198, ["mendoza"], ["itemsanity"], ["Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Sieger AR552 Tactical":(199, ["mendoza"], ["itemsanity"], ["Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Sieger 300 Tactical":(200, ["mendoza"], ["itemsanity"], ["Level - Mendoza"], [], [], ["Itempickup - Any"]),
    "Itempickup - Icicle":(201, ["mendoza", "carpathian_mountains"], ["itemsanity"], ["Level - Mendoza","Level - Carpathian Mountains"], [], [], ["Itempickup - Any"]),
    "Itempickup - Rusty Crowbar":(202, ["carpathian_mountains"], ["itemsanity"], ["Level - Carpathian Mountains"], [], [], ["Itempickup - Any"]),
    "Itempickup - ICA SMG White Raptor Covert":(203, ["carpathian_mountains"], ["itemsanity"], ["Level - Carpathian Mountains"], [], [], ["Itempickup - Any"]),
    "Itempickup - HWK21 Pale":(204, ["carpathian_mountains"], ["itemsanity"], ["Level - Carpathian Mountains"], [], [], ["Itempickup - Any"]),
    "Itempickup - Rusty Screwdriver":(205, ["carpathian_mountains"], ["itemsanity"], ["Level - Carpathian Mountains"], [], [], ["Itempickup - Any"]),
    "Itempickup - ICA Tactical Shotgun Covert":(206, ["carpathian_mountains"], ["itemsanity"], ["Level - Carpathian Mountains"], [], [], ["Itempickup - Any"]),
    "Itempickup - Flash Grenade Mk III":(207, ["carpathian_mountains"], ["itemsanity"], ["Level - Carpathian Mountains"], [], [], ["Itempickup - Any"]),
    "Itempickup - Fiber Wire":(208, ["carpathian_mountains"], ["itemsanity"], ["Level - Carpathian Mountains"], [], [], ["Itempickup - Any"]),
    "Itempickup - ICA19 Black Lily":(209, ["carpathian_mountains"], ["itemsanity"], ["Level - Carpathian Mountains"], [], [], ["Itempickup - Any"]),
    "Itempickup - Small Pumpkin":(210, ["colorado"], ["itemsanity"], ["Level - Colorado"], [], [], ["Itempickup - Any"])
}

split_item_pickup_location_table = {
    "Itempickup - ICA Facility - Crowbar":(1500, ["ica_facility"], ["split_itemsanity"], ["Level - ICA Facility"],[], [], ["Itempickup - Any"]),
    "Itempickup - ICA Facility - Hammer":(1501, ["ica_facility"], ["split_itemsanity"], ["Level - ICA Facility"],[], [], ["Itempickup - Any"]),
    "Itempickup - ICA Facility - Coin":(1502, ["ica_facility"], ["split_itemsanity"], ["Level - ICA Facility"],[], [], ["Itempickup - Any"]),
    "Itempickup - ICA Facility - Emetic Rat Poison":(1503, ["ica_facility"], ["split_itemsanity"], ["Level - ICA Facility"],[], [], ["Itempickup - Any"]),
    "Itempickup - ICA Facility - Wrench":(1504, ["ica_facility"], ["split_itemsanity"], ["Level - ICA Facility"],[], [], ["Itempickup - Any"]),
    "Itempickup - ICA Facility - Lead Pipe":(1505, ["ica_facility"], ["split_itemsanity"], ["Level - ICA Facility"],[], [], ["Itempickup - Any"]),
    "Itempickup - ICA Facility - Pool Ball":(1506, ["ica_facility"], ["split_itemsanity"], ["Level - ICA Facility"],[], [], ["Itempickup - Any"]),
    "Itempickup - ICA Facility - Brick":(1507, ["ica_facility"], ["split_itemsanity"], ["Level - ICA Facility"],[], [], ["Itempickup - Any"]),
    "Itempickup - ICA Facility - Bust":(1508, ["ica_facility"], ["split_itemsanity"], ["Level - ICA Facility"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Scissors":(1509, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Screwdriver":(1510, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Letter Opener":(1511, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Hammer":(1512, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Bust":(1513, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Emetic Rat Poison":(1514, [], ["split_itemsanity"], [],["paris"], ["Level - Paris"], ["Itempickup - Any"]),
    "Itempickup - Paris - Fire Axe":(1515, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Crowbar":(1516, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Wrench":(1517, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Fusil G2":(1518, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Remote Explosive":(1519, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Bartoli 75R":(1520, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Fire Extinguisher":(1521, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Tactical Bartoli 12G":(1522, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Kitchen Knife":(1523, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Lead Pipe":(1524, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Propane Flask":(1525, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Cleaver":(1526, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Frying Pan":(1527, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Fire Poker":(1528, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Hatchet":(1529, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Coin":(1530, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Battle Axe":(1531, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Saber":(1532, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Brick":(1533, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Golf Club":(1534, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Police Baton":(1535, ["paris"], ["split_itemsanity"], ["Level - Paris"],[], [], ["Itempickup - Any"]),
    "Itempickup - Paris - Lethal Poison Pill Jar":(1536, [], ["split_itemsanity"], [],["paris"], ["Level - Paris"], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Wrench":(1537, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Crowbar":(1538, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Fire Extinguisher":(1539, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Bust":(1540, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Coin":(1541, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Lead Pipe":(1542, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Brick":(1543, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Shovel":(1544, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Circumcision Knife":(1545, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Amputation Knife":(1546, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Fire Axe":(1547, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Propane Flask":(1548, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Letter Opener":(1549, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Toy Tank":(1550, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Expired Can of Spaghetti Sauce":(1551, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Soda Can":(1552, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Fire Poker":(1553, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Emetic Rat Poison":(1554, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Screwdriver":(1555, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Hatchet":(1556, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Kitchen Knife":(1557, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Saber":(1558, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Bartoli 75S":(1559, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Scissors":(1560, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Golf Club":(1561, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Virus Prototype":(1562, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Hammer":(1563, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Combat Knife":(1564, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Tactical Bartoli 12G":(1565, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Remote Explosive":(1566, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Baseball Bat":(1567, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Bartoli 75R":(1568, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Explosive Golf Ball":(1569, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Folding Knife":(1570, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Police Baton":(1571, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Old Axe":(1572, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Radio":(1573, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Bag of Gunpowder":(1574, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Cannonball":(1575, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Battle Axe":(1576, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Bartoli 12G":(1577, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Katana":(1578, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Sapienza - Cleaver":(1579, ["sapienza"], ["split_itemsanity"], ["Level - Sapienza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Brick":(1580, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Screwdriver":(1581, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Soda Can":(1582, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Wrench":(1583, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Kitchen Knife":(1584, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Propane Flask":(1585, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Hammer":(1586, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Cleaver":(1587, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Scissors":(1588, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Fire Extinguisher":(1589, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Crowbar":(1590, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Emetic Rat Poison":(1591, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Letter Opener":(1592, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Remote Explosive":(1593, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Fire Axe":(1594, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Tactical Bartoli 12G":(1595, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Bartoli 75R":(1596, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Shashka A33":(1597, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Saber":(1598, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Coin":(1599, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Toy Tank":(1600, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Fusil G1-4":(1601, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Pool Ball":(1602, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Lethal Poison Pill Jar":(1603, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Marrakesh - Battle Axe":(1604, ["marrakesh"], ["split_itemsanity"], ["Level - Marrakesh"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Fire Extinguisher":(1605, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Hammer":(1606, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Coin":(1607, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Shovel":(1608, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Hatchet":(1609, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Emetic Rat Poison":(1610, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Insecticide":(1611, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Soda Can":(1612, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Fusil G2":(1613, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Lead Pipe":(1614, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Propane Flask":(1615, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Crowbar":(1616, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Wrench":(1617, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Fire Axe":(1618, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Screwdriver":(1619, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Coconut":(1620, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Cleaver":(1621, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Kitchen Knife":(1622, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Lethal Poison Pill Jar":(1623, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Bartoli 75R":(1624, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Police Baton":(1625, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Pool Ball":(1626, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Letter Opener":(1627, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Baseball Bat":(1628, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Katana":(1629, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Golf Club":(1630, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Sapper's Axe":(1631, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Bangkok - Tactical Bartoli 12G":(1632, ["bangkok"], ["split_itemsanity"], ["Level - Bangkok"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Apricot":(1633, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Wrench":(1634, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Screwdriver":(1635, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Crowbar":(1636, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Baseball":(1637, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Cowboy Bust":(1638, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Explosive Watch Battery":(1639, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Nitroglycerin":(1640, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Soda Can":(1641, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Baseball Bat":(1642, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Emetic Rat Poison":(1643, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Hammer":(1644, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Bartoli 12G":(1645, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Fire Extinguisher":(1646, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Modern Lethal Syringe":(1647, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Shovel":(1648, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Propane Flask":(1649, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Coin":(1650, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Lead Pipe":(1651, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Brick":(1652, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Fusil G2":(1653, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Tactical Bartoli 12G":(1654, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Cleaver":(1655, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Kitchen Knife":(1656, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - HX-10":(1657, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Lethal Poison Pill Jar":(1658, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Branding Iron":(1659, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Mannequin Arm":(1660, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - HX-7":(1661, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Bartoli 75R":(1662, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Old Axe":(1663, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Cowboy Bust":(1664, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Soda Can":(1665, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Fire Extinguisher":(1666, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Tactical Bartoli 12G":(1667, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Police Baton":(1668, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Wrench":(1669, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Hammer":(1670, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Emetic Rat Poison":(1671, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Fire Axe":(1672, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Fire Poker":(1673, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Scalpel":(1674, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Screwdriver":(1675, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Kitchen Knife":(1676, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Cleaver":(1677, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Frying Pan":(1678, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Baseball Bat":(1679, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Crowbar":(1680, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Katana":(1681, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Coin":(1682, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - HX-7":(1683, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Bust":(1684, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Botulinum Toxin":(1685, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Shovel":(1686, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Propane Flask":(1687, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Scissors":(1688, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hokkaido - Lead Pipe":(1689, ["hokkaido"], ["split_itemsanity"], ["Level - Hokkaido"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Screwdriver":(1690, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Tactical Bartoli 12G":(1691, [], ["split_itemsanity"], [],["hawkes_bay"], ["Level - Hawkes Bay"], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Bartoli 75S":(1692, [], ["split_itemsanity"], [],["hawkes_bay"], ["Level - Hawkes Bay"], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Hackl 9S Covert":(1693, [], ["split_itemsanity"], [],["hawkes_bay"], ["Level - Hawkes Bay"], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Kalmer 1 - Tranquilizer":(1694, [], ["split_itemsanity"], [],["hawkes_bay"], ["Level - Hawkes Bay"], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - HX-7":(1695, [], ["split_itemsanity"], [],["hawkes_bay"], ["Level - Hawkes Bay"], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Soda Can":(1696, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Chloroform Flask":(1697, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Propane Flask":(1698, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Expired Can of Spaghetti Sauce":(1699, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Emetic Rat Poison":(1700, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Lethal Poison Pill Jar":(1701, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Squeaky Toy":(1702, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Katana":(1703, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Shuriken":(1704, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Maori Paddle":(1705, [], ["split_itemsanity"], [],["hawkes_bay"], ["Level - Hawkes Bay"], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Wristwatch Alarm":(1706, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Folding Knife":(1707, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Driftwood Log":(1708, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Kitchen Knife":(1709, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Cleaver":(1710, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Wrench":(1711, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Car Battery":(1712, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Lead Pipe":(1713, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Apple":(1714, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Scissors":(1715, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Coin":(1716, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Fire Poker":(1717, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Fragmentation Grenade":(1718, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Bust":(1719, ["hawkes_bay"], ["split_itemsanity"], ["Level - Hawkes Bay"],[], [], ["Itempickup - Any"]),
    "Itempickup - Hawkes Bay - Shovel":(1720, [], ["split_itemsanity"], [],["hawkes_bay"], ["Level - Hawkes Bay"], ["Itempickup - Any"]),
    "Itempickup - Miami - Shovel":(1721, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Crowbar":(1722, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Hammer":(1723, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Screwdriver":(1724, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Fire Axe":(1725, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Kronstadt Octane Booster":(1726, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Soda Can":(1727, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Coin":(1728, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Lead Pipe":(1729, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Fire Extinguisher":(1730, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Didgeridoo":(1731, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Android Arm":(1732, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Wrench":(1733, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Emetic Rat Poison":(1734, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Scissors":(1735, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Propane Flask":(1736, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Apricot":(1737, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Police Baton":(1738, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Tactical Bartoli 12G":(1739, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Bartoli 75R":(1740, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Bag of Sugar":(1741, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Fish":(1742, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Frying Pan":(1743, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Kitchen Knife":(1744, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Cleaver":(1745, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Baseball":(1746, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Baseball Bat":(1747, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Pneumatic Wrench":(1748, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Car Bomb":(1749, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Old Axe":(1750, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Coconut":(1751, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Lethal Poison Pill Jar":(1752, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Amputation Knife":(1753, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Brick":(1754, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Bust":(1755, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Golf Club":(1756, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Cocaine Brick":(1757, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Starfish":(1758, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Modern Lethal Syringe":(1759, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Battle Axe":(1760, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - Cannabis Joint":(1761, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Miami - The Big One":(1762, ["miami"], ["split_itemsanity"], ["Level - Miami"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Coin":(1763, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Soda Can":(1764, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Car Battery":(1765, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Coconut":(1766, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Propane Flask":(1767, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Brick":(1768, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Lead Pipe":(1769, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Emetic Rat Poison":(1770, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Crowbar":(1771, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Screwdriver":(1772, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Hammer":(1773, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Apricot":(1774, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Kitchen Knife":(1775, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Baseball Bat":(1776, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Baseball":(1777, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Frying Pan":(1778, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Wrench":(1779, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Shovel":(1780, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Letter Opener":(1781, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Scissors":(1782, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Cleaver":(1783, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Meaty Bone":(1784, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Lethal Poison Pill Jar":(1785, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - DAK X2":(1786, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Bartoli 12G":(1787, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Shashka A33":(1788, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Bartoli 75S":(1789, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Poisonous Flower (Emetic)":(1790, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Poisonous Flower (Lethal)":(1791, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Lethal Poisonous Frog":(1792, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Fire Extinguisher":(1793, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Letterbomb Parcel":(1794, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Pool Ball":(1795, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Collectors Baseball Bat":(1796, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Driftwood Log":(1797, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Machete":(1798, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Cocaine Brick":(1799, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Remote Explosive":(1800, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Bag of Gunpowder":(1801, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Claw Hammer":(1802, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Shashka A33 Gold":(1803, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Hackl 9S Covert":(1804, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Gold Idol":(1805, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Sacrificial Knife":(1806, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Folding Knife":(1807, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Barber Razor":(1808, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - \"El Matador\"":(1809, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Cowboy Bust":(1810, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Cocaine Souvenir":(1811, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Santa Fortuna - Expired Can of Spaghetti Sauce":(1812, ["santa_fortuna"], ["split_itemsanity"], ["Level - Santa Fortuna"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Kitchen Knife":(1813, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Beak Staff":(1814, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Brick":(1815, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Bartoli 12G":(1816, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Emetic Rat Poison":(1817, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Iron":(1818, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Expired Can of Spaghetti Sauce":(1819, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Chennai Cricket Ball":(1820, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Baseball Bat":(1821, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Fish":(1822, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Shovel":(1823, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Wrench":(1824, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Crowbar":(1825, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Propane Flask":(1826, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Lever":(1827, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Car Battery":(1828, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Coin":(1829, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Old Axe":(1830, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Lead Pipe":(1831, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Colored Smoke":(1832, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Shashka A33":(1833, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Frying Pan":(1834, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Soda Can":(1835, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Lethal Poison Pill Jar":(1836, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Khatvanga":(1837, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Scissors":(1838, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Screwdriver":(1839, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Hammer":(1840, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Fire Extinguisher":(1841, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Barber Razor":(1842, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Fire Axe":(1843, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Amputation Knife":(1844, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Cleaver":(1845, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Folding Knife":(1846, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Bartoli 75S":(1847, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Letter Opener":(1848, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - DAK X2":(1849, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Saber":(1850, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Measuring Tape":(1851, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Druzhina 34":(1852, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mumbai - Rake":(1853, ["mumbai"], ["split_itemsanity"], ["Level - Mumbai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - DAK X2 Covert Special":(1854, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Bartoli 75R":(1855, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Car Bomb":(1856, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Flash Grenade":(1857, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Kitchen Knife":(1858, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Apple":(1859, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Screwdriver":(1860, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Shovel":(1861, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Soda Can":(1862, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Blueberry Muffin":(1863, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Baseball":(1864, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Wrench":(1865, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Hammer":(1866, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Propane Flask":(1867, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Golf Club":(1868, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Fire Extinguisher":(1869, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Coin":(1870, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Newspaper":(1871, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Fire Axe":(1872, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Lethal Poisonous Frog":(1873, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Emetic Rat Poison":(1874, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Bust":(1875, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Car Battery":(1876, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Lethal Pills":(1877, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Emetic Pills":(1878, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Scissors":(1879, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Letter Opener":(1880, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - \"Rude Ruby\"":(1881, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Remote CX Demo Block":(1882, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Crowbar":(1883, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - DAK X2":(1884, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Hackl 9S Covert":(1885, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Remote Explosive":(1886, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - RS-15":(1887, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - TAC-4 AR Auto":(1888, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Fusil G1-4|C":(1889, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Fusil G2":(1890, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Lead Pipe":(1891, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Baseball Bat":(1892, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Meaty Bone":(1893, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Battle Axe":(1894, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Expired Can of Spaghetti Sauce":(1895, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Hatchet":(1896, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Insecticide":(1897, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Paddle":(1898, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Package":(1899, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Brick":(1900, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Beak Staff":(1901, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Cannabis Joint":(1902, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Cigar Box":(1903, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Whittleton Creek - Rake":(1904, ["whittleton_creek"], ["split_itemsanity"], ["Level - Whittleton Creek"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Fishing Line":(1905, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Wooden Torch":(1906, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Coconut":(1907, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Driftwood Log":(1908, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Lead Pipe":(1909, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Garden Fork":(1910, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Brick":(1911, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Hammer":(1912, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Fire Extinguisher":(1913, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Crowbar":(1914, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Car Battery":(1915, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Whiskey Bottle":(1916, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Spray Can":(1917, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Apple":(1918, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Paddle":(1919, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Vodka Bottle":(1920, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Starfish":(1921, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Soda Can":(1922, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Scissors":(1923, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Wrench":(1924, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Soap":(1925, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Cleaver":(1926, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Frying Pan":(1927, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Fish":(1928, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Bag of Sugar":(1929, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Emetic Rat Poison":(1930, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Banana":(1931, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Shovel":(1932, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Durian":(1933, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Kitchen Knife":(1934, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Meat Fork":(1935, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Letter Opener":(1936, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Lethal Poisonous Frog":(1937, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Kukri Machete":(1938, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Seashell":(1939, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Poisonous Flower (Emetic)":(1940, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Cannonball":(1941, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Khatvanga":(1942, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Screwdriver":(1943, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Apricot":(1944, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Propane Flask":(1945, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Folding Knife":(1946, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Coin":(1947, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Lethal Poison Vial":(1948, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Emetic Gas Grenade":(1949, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Old Axe":(1950, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Sawed-Off Bartoli 12G":(1951, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Hook":(1952, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Brine-Damaged SMG":(1953, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Molotov Cocktail":(1954, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Makeshift Explosive":(1955, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Remote CX Demo Block MK II":(1956, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Shashka A33":(1957, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Scrap Sword":(1958, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Umbrella":(1959, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Gold Idol":(1960, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Newspaper":(1961, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Shears":(1962, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Shashka A33 Gold":(1963, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Barber Razor":(1964, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Cigar Box":(1965, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Iron":(1966, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Meaty Bone":(1967, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Hobby Knife":(1968, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Militia-Issued HX-10 SMG":(1969, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Remote Breaching Charge":(1970, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Doubloon":(1971, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Jarl's Pirate Saber":(1972, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Ambrose Island - Nitroglycerin":(1973, ["ambrose_island"], ["split_itemsanity"], ["Level - Ambrose Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Mace":(1974, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Battle Axe":(1975, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Sapper's Axe":(1976, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Broadsword":(1977, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Cigar Box":(1978, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Old Axe":(1979, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Bust":(1980, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Saber":(1981, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Cannonball":(1982, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Viking Axe":(1983, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Fire Extinguisher":(1984, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Fire Poker":(1985, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Bartoli 75S":(1986, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Hatchet":(1987, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Car Battery":(1988, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Propane Flask":(1989, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Baseball Bat":(1990, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Emetic Rat Poison":(1991, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Shovel":(1992, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Chloroform Flask":(1993, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Scalpel":(1994, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Paddle":(1995, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Crowbar":(1996, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Screwdriver":(1997, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Letter Opener":(1998, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Coconut":(1999, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Cowboy Bust":(2000, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Coin":(2001, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Tactical Bartoli 12G":(2002, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Soda Can":(2003, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Wrench":(2004, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Hammer":(2005, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Apple":(2006, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Brick":(2007, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Expired Can of Spaghetti Sauce":(2008, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Branding Iron":(2009, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Meaty Bone":(2010, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Lead Pipe":(2011, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Frying Pan":(2012, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Cleaver":(2013, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Kitchen Knife":(2014, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Apricot":(2015, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Fish":(2016, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Fire Axe":(2017, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Bag of Gunpowder":(2018, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - HX-7 Covert":(2019, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Circumcision Knife":(2020, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Scissors":(2021, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Newspaper":(2022, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Botulinum Toxin":(2023, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Gold Idol":(2024, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Katana":(2025, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Aztec Necklace":(2026, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Imperial Filigree Egg":(2027, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Khatvanga":(2028, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Torch":(2029, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Fusil G2":(2030, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Hackl 9S":(2031, [], ["split_itemsanity"], [],["isle_of_sgail"], ["Level - Isle of Sgail"], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - HX-10":(2032, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Blueberry Muffin":(2033, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Iron":(2034, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Hackl 9S Covert":(2035, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Cocaine Brick":(2036, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Commemorative Token":(2037, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Nitroglycerin":(2038, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Flash Grenade":(2039, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Driftwood Log":(2040, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Cheeseburger":(2041, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Starfish":(2042, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - Isle of Sgail - Sacrificial Knife":(2043, ["isle_of_sgail"], ["split_itemsanity"], ["Level - Isle of Sgail"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Fire Extinguisher":(2044, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Letter Opener":(2045, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Screwdriver":(2046, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Bust":(2047, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Package":(2048, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Fire Axe":(2049, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Wrench":(2050, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Iron":(2051, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Small Goldbar":(2052, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Imperial Filigree Egg":(2053, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Emetic Rat Poison":(2054, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Propane Flask":(2055, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Violin":(2056, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Police Baton":(2057, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Scissors":(2058, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Earphones":(2059, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Tanto":(2060, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Hobby Knife":(2061, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Burial Dagger":(2062, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Golden Sawed Off Bartoli 12G":(2063, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Crowbar":(2064, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Wristwatch Alarm":(2065, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Lethal Poison Pill Jar":(2066, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Concussion Grenade":(2067, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Soda Can":(2068, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Newspaper":(2069, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Wet Floor Sign":(2070, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Kitchen Knife":(2071, [], ["split_itemsanity"], [],["new_york"], ["Level - New York"], ["Itempickup - Any"]),
    "Itempickup - New York - Car Battery":(2072, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Flash Grenade":(2073, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Tactical Bartoli 12G":(2074, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Cheeseburger":(2075, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Antique Carved Knife":(2076, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Letterbomb Parcel":(2077, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Gold Idol":(2078, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Bartoli 75R":(2079, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Chloroform Flask":(2080, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Kalmer 1 - Tranquilizer":(2081, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Commemorative Token":(2082, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Goldbar":(2083, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Coin":(2084, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Folding Knife":(2085, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Apple":(2086, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Blueberry Muffin":(2087, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Apricot":(2088, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Feather Duster":(2089, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Golf Club":(2090, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Pool Ball":(2091, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Lead Pipe":(2092, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - DAK X2":(2093, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Claw Hammer":(2094, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - New York - Toy Tank":(2095, ["new_york"], ["split_itemsanity"], ["Level - New York"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Earphones":(2096, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Soda Can":(2097, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Fire Extinguisher":(2098, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Barber Razor":(2099, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Apple":(2100, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Coin":(2101, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Golf Club":(2102, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Scissors":(2103, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Stethoscope":(2104, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Iron":(2105, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Baseball":(2106, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Baseball Bat":(2107, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Modern Emetic Syringe":(2108, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Lethal Poison Pill Jar":(2109, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Scalpel":(2110, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Machete":(2111, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Emetic Rat Poison":(2112, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Shovel":(2113, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Bartoli 75S":(2114, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Remote Explosive":(2115, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Police Baton":(2116, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Crowbar":(2117, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Blueberry Muffin":(2118, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Wet Floor Sign":(2119, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Folding Knife":(2120, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Banana":(2121, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Screwdriver":(2122, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Wrench":(2123, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Starfish":(2124, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Kettlebell":(2125, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Lead Pipe":(2126, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Frying Pan":(2127, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Meaty Bone":(2128, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Cleaver":(2129, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Propane Flask":(2130, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Kitchen Knife":(2131, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Paddle":(2132, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Pearl":(2133, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Fish":(2134, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Hackl 9S Covert":(2135, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Coconut":(2136, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Cheeseburger":(2137, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Gold Idol":(2138, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Tactical Bartoli 12G":(2139, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Hatchet":(2140, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Fusil G2":(2141, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - HX-10":(2142, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Hammer":(2143, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Feather Duster":(2144, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Letter Opener":(2145, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Seashell":(2146, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Lethal Poisonous Frog":(2147, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Newspaper":(2148, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Imperial Filigree Egg":(2149, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Poisonous Flower (Emetic)":(2150, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Driftwood Log":(2151, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Jarl's Pirate Saber":(2152, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Doubloon":(2153, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Fire Axe":(2154, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Haven Island - Maori Paddle":(2155, ["haven_island"], ["split_itemsanity"], ["Level - Haven Island"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Golf Club":(2156, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Apple":(2157, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Coin":(2158, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Crowbar":(2159, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Car Battery":(2160, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Letter Opener":(2161, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Gold Idol":(2162, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Imperial Filigree Egg":(2163, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Ornate Scimitar":(2164, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - HX-10":(2165, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Whiskey Bottle":(2166, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Goldbar":(2167, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Model of the Sceptre":(2168, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Kitchen Knife":(2169, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Frying Pan":(2170, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Meaty Bone":(2171, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Emetic Rat Poison":(2172, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Screwdriver":(2173, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Soap":(2174, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Propane Flask":(2175, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Fire Axe":(2176, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Hammer":(2177, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Cleaver":(2178, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Soda Can":(2179, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Emetic Pills":(2180, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Wet Floor Sign":(2181, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Bartoli 75R":(2182, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Banana":(2183, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Fusil G1-4":(2184, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Fire Extinguisher":(2185, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Wrench":(2186, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Scissors":(2187, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Shovel":(2188, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Coconut":(2189, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Explosive Golf Ball":(2190, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Folding Knife":(2191, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Lethal Poison Pill Jar":(2192, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Hackl 9S Covert":(2193, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Blueberry Muffin":(2194, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dubai - Iron":(2195, ["dubai"], ["split_itemsanity"], ["Level - Dubai"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Hatchet":(2196, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Driftwood Log":(2197, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Brick":(2198, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Shears":(2199, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Rake":(2200, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Classic Coin":(2201, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Folding Knife":(2202, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Emetic Rat Poison":(2203, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Shovel":(2204, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Garden Fork":(2205, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Cigar Box":(2206, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Hammer":(2207, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Baseball":(2208, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Crowbar":(2209, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Poisonous Flower (Emetic)":(2210, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Wrench":(2211, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Screwdriver":(2212, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Walking Cane":(2213, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Unicorn Horn":(2214, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Letter Opener":(2215, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Barber Razor":(2216, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Newspaper":(2217, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Bust":(2218, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Lead Pipe":(2219, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Apple":(2220, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Feather Duster":(2221, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Saber":(2222, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Bartoli Hunting Shotgun":(2223, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Car Battery":(2224, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Coin":(2225, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Lethal Poison Pill Jar":(2226, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Fire Poker":(2227, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Golf Club":(2228, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Iron":(2229, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Apricot":(2230, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Bag of Sugar":(2231, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Cleaver":(2232, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Scissors":(2233, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Propane Flask":(2234, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Soda Can":(2235, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Kitchen Knife":(2236, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Soap":(2237, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Banana":(2238, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Imperial Filigree Egg":(2239, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Maori Paddle":(2240, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Pool Ball":(2241, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Fish":(2242, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Dartmoor - Hackl 9S Covert":(2243, ["dartmoor"], ["split_itemsanity"], ["Level - Dartmoor"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Baseball Bat":(2244, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Toy Tank":(2245, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Tactical Bartoli 12G":(2246, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Fire Extinguisher":(2247, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Soda Can":(2248, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Coin":(2249, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Kitchen Knife":(2250, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Banana":(2251, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Coconut":(2252, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Emetic Rat Poison":(2253, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Screwdriver":(2254, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Fire Axe":(2255, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Modern Sedative Syringe":(2256, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Wrench":(2257, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Hobby Knife":(2258, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Propane Flask":(2259, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Police Baton":(2260, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Crowbar":(2261, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Hammer":(2262, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Lead Pipe":(2263, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Pool Ball":(2264, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Battle Axe":(2265, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Frying Pan":(2266, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Cocaine Brick":(2267, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Car Battery":(2268, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Shovel":(2269, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Bartoli 75R":(2270, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Insecticide":(2271, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Garden Fork":(2272, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Gold Idol":(2273, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Bartoli Woodsman Hunting Rifle":(2274, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Spray Can":(2275, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Bag of Sugar":(2276, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Brick":(2277, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Scrap Sword":(2278, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Blueberry Muffin":(2279, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Bird's Egg":(2280, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Combat Knife":(2281, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Baseball":(2282, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Old Axe":(2283, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Iron":(2284, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Poisonous (Emetic) Mushroom":(2285, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Bartoli Hunting Shotgun":(2286, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Lethal Pills":(2287, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Modern Lethal Syringe":(2288, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - Concealable Knife":(2289, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Berlin - ICA Remote Audio Distraction Mk III":(2290, ["berlin"], ["split_itemsanity"], ["Level - Berlin"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Brick":(2291, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Hammer":(2292, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Lead Pipe":(2293, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Frying Pan":(2294, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Apple":(2295, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Soda Can":(2296, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Screwdriver":(2297, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Fire Axe":(2298, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Wrench":(2299, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Tanto":(2300, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Crowbar":(2301, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Letter Opener":(2302, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Hackl Leviathan Sniper Rifle Covert":(2303, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Umbrella":(2304, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Scrap Sword":(2305, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Whiskey Bottle":(2306, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Blueberry Muffin":(2307, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Chloroform Flask":(2308, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Coin":(2309, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Mannequin Arm":(2310, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Remote Explosive":(2311, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Bartoli 75R":(2312, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Hackl 9S Covert":(2313, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - ICA SMG Raptor Covert":(2314, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Fusil X2000 Stealth":(2315, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Tactical Bartoli 12G":(2316, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Emetic Rat Poison":(2317, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Package":(2318, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Newspaper":(2319, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Banana":(2320, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Apricot":(2321, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Cleaver":(2322, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Meaty Bone":(2323, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Kitchen Knife":(2324, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Iron":(2325, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Soap":(2326, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Car Battery":(2327, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Toy Tank":(2328, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Scissors":(2329, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Driftwood Log":(2330, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Hobby Knife":(2331, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Fire Extinguisher":(2332, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Cowboy Bust":(2333, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Stethoscope":(2334, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Lethal Poison Pill Jar":(2335, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Garden Fork":(2336, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Propane Flask":(2337, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Chongqing - Cigar Box":(2338, ["chongqing"], ["split_itemsanity"], ["Level - Chongqing"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Emetic Rat Poison":(2339, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Cannonball":(2340, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Broadsword":(2341, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Bag of Gunpowder":(2342, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Jarl's Pirate Saber":(2343, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Bartoli Woodsman Hunting Rifle":(2344, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Old Axe":(2345, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Lethal Poison Pill Jar":(2346, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Sapper's Axe":(2347, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Shears":(2348, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Violin":(2349, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Imperial Filigree Egg":(2350, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Garden Fork":(2351, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Shovel":(2352, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Umbrella":(2353, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Brick":(2354, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Soda Can":(2355, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Fire Poker":(2356, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Apple":(2357, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Frying Pan":(2358, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Meaty Bone":(2359, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Banana":(2360, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Cabernet Sauvignon":(2361, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Bartoli Hunting Shotgun":(2362, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Rake":(2363, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Wrench":(2364, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Grape Knife":(2365, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Car Battery":(2366, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Torch":(2367, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Grapevine":(2368, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Poisonous Flower (Emetic)":(2369, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Pinot Noir":(2370, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Screwdriver":(2371, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Malbec":(2372, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - 1945 Grand Paladin":(2373, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Fire Extinguisher":(2374, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Fire Axe":(2375, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Wet Floor Sign":(2376, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Crowbar":(2377, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Combat Knife":(2378, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Coin":(2379, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Cocaine Brick":(2380, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Sieger AR552 Tactical":(2381, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Sieger 300 Tactical":(2382, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Remote CX Demo Block MK II":(2383, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Hatchet":(2384, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Claw Hammer":(2385, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Machete":(2386, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Propane Flask":(2387, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Fishing Line":(2388, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Fish":(2389, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Hobby Knife":(2390, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Icicle":(2391, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Kitchen Knife":(2392, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Bartoli 75S":(2393, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Mendoza - Hackl 9S Covert":(2394, ["mendoza"], ["split_itemsanity"], ["Level - Mendoza"],[], [], ["Itempickup - Any"]),
    "Itempickup - Carpathian Mountains - Rusty Crowbar":(2395, ["carpathian_mountains"], ["split_itemsanity"], ["Level - Carpathian Mountains"],[], [], ["Itempickup - Any"]),
    "Itempickup - Carpathian Mountains - Soap":(2396, ["carpathian_mountains"], ["split_itemsanity"], ["Level - Carpathian Mountains"],[], [], ["Itempickup - Any"]),
    "Itempickup - Carpathian Mountains - Imperial Filigree Egg":(2397, ["carpathian_mountains"], ["split_itemsanity"], ["Level - Carpathian Mountains"],[], [], ["Itempickup - Any"]),
    "Itempickup - Carpathian Mountains - Flash Grenade":(2398, ["carpathian_mountains"], ["split_itemsanity"], ["Level - Carpathian Mountains"],[], [], ["Itempickup - Any"]),
    "Itempickup - Carpathian Mountains - Icicle":(2399, ["carpathian_mountains"], ["split_itemsanity"], ["Level - Carpathian Mountains"],[], [], ["Itempickup - Any"]),
    "Itempickup - Carpathian Mountains - ICA SMG White Raptor Covert":(2400, ["carpathian_mountains"], ["split_itemsanity"], ["Level - Carpathian Mountains"],[], [], ["Itempickup - Any"]),
    "Itempickup - Carpathian Mountains - HWK21 Pale":(2401, ["carpathian_mountains"], ["split_itemsanity"], ["Level - Carpathian Mountains"],[], [], ["Itempickup - Any"]),
    "Itempickup - Carpathian Mountains - Brick":(2402, ["carpathian_mountains"], ["split_itemsanity"], ["Level - Carpathian Mountains"],[], [], ["Itempickup - Any"]),
    "Itempickup - Carpathian Mountains - Rusty Screwdriver":(2403, ["carpathian_mountains"], ["split_itemsanity"], ["Level - Carpathian Mountains"],[], [], ["Itempickup - Any"]),
    "Itempickup - Carpathian Mountains - Soda Can":(2404, ["carpathian_mountains"], ["split_itemsanity"], ["Level - Carpathian Mountains"],[], [], ["Itempickup - Any"]),
    "Itempickup - Carpathian Mountains - ICA Tactical Shotgun Covert":(2405, ["carpathian_mountains"], ["split_itemsanity"], ["Level - Carpathian Mountains"],[], [], ["Itempickup - Any"]),
    "Itempickup - Carpathian Mountains - Fragmentation Grenade":(2406, ["carpathian_mountains"], ["split_itemsanity"], ["Level - Carpathian Mountains"],[], [], ["Itempickup - Any"]),
    "Itempickup - Carpathian Mountains - Blueberry Muffin":(2407, ["carpathian_mountains"], ["split_itemsanity"], ["Level - Carpathian Mountains"],[], [], ["Itempickup - Any"]),
    "Itempickup - Carpathian Mountains - Claw Hammer":(2408, ["carpathian_mountains"], ["split_itemsanity"], ["Level - Carpathian Mountains"],[], [], ["Itempickup - Any"]),
    "Itempickup - Carpathian Mountains - Flash Grenade Mk III":(2409, ["carpathian_mountains"], ["split_itemsanity"], ["Level - Carpathian Mountains"],[], [], ["Itempickup - Any"]),
    "Itempickup - Carpathian Mountains - Barber Razor":(2410, ["carpathian_mountains"], ["split_itemsanity"], ["Level - Carpathian Mountains"],[], [], ["Itempickup - Any"]),
    "Itempickup - Carpathian Mountains - Fire Axe":(2411, ["carpathian_mountains"], ["split_itemsanity"], ["Level - Carpathian Mountains"],[], [], ["Itempickup - Any"]),
    "Itempickup - Carpathian Mountains - Fire Extinguisher":(2412, ["carpathian_mountains"], ["split_itemsanity"], ["Level - Carpathian Mountains"],[], [], ["Itempickup - Any"]),
    "Itempickup - Carpathian Mountains - Fiber Wire":(2413, ["carpathian_mountains"], ["split_itemsanity"], ["Level - Carpathian Mountains"],[], [], ["Itempickup - Any"]),
    "Itempickup - Carpathian Mountains - ICA19 Black Lily":(2414, ["carpathian_mountains"], ["split_itemsanity"], ["Level - Carpathian Mountains"],[], [], ["Itempickup - Any"]),
    "Itempickup - Colorado - Small Pumpkin":(2415, ["colorado"], ["split_itemsanity"], ["Level - Colorado"],[], [], ["Itempickup - Any"])
}

level_completion_location_table = { #id, location entitlments (one of required), settings requirement (one of required), required items (one of), unused, unused
    "ICA Facility Completed":(1000,["free","ica_facility"],["completed","ica_facility_completed"],["Level - ICA Facility"],[],[],["Any Completed"]),
    "Paris Completed":(1001,["h1","paris"],["completed","paris_completed"],["Level - Paris"],[],[],["Any Completed"]),
    "Sapienza Completed":(1002,["h1","sapienza"],["completed","sapienza_completed"],["Level - Sapienza"],[],[],["Any Completed"]),
    "Marrakesh Completed":(1003,["h1","marrakesh"],["completed","marrakesh_completed"],["Level - Marrakesh"],[],[],["Any Completed"]),
    "Bangkok Completed":(1004,["h1","bangkok"],["completed","bangkok_completed"],["Level - Bangkok"],[],[],["Any Completed"]),
    "Colorado Completed":(1005,["h1","colorado"],["completed","colorado_completed"],["Level - Colorado"],[],[],["Any Completed"]),
    "Hokkaido Completed":(1006,["h1","hokkaido"],["completed","hokkaido_completed"],["Level - Hokkaido"],[],[],["Any Completed"]),
    "Hawkes Bay Completed":(1007,["h2","hawkes_bay"],["completed","hawkes_bay_completed"],["Level - Hawkes Bay"],[],[],["Any Completed"]),
    "Miami Completed":(1008,["h2","miami"],["completed","miami_completed"],["Level - Miami"],[],[],["Any Completed"]),
    "Santa Fortuna Completed":(1009,["h2","santa_fortuna"],["completed","santa_fortuna_completed"],["Level - Santa Fortuna"],[],[],["Any Completed"]),
    "Mumbai Completed":(1010,["h2","mumbai"],["completed","mumbai_completed"],["Level - Mumbai"],[],[],["Any Completed"]),
    "Whittleton Creek Completed":(1011,["h2","whittleton_creek"],["completed","whittleton_creek_completed"],["Level - Whittleton Creek"],[],[],["Any Completed"]),
    "Isle of Sgail Completed":(1012,["h2","isle_of_sgail"],["completed","isle_of_sgail_completed"],["Level - Isle of Sgail"],[],[],["Any Completed"]),
    "New York Completed":(1013,["h2_dlc","new_york"],["completed","new_york_completed"],["Level - New York"],[],[],["Any Completed"]),
    "Haven Island Completed":(1014,["h2_dlc","haven_island"],["completed","haven_island_completed"],["Level - Haven Island"],[],[],["Any Completed"]),
    "Dubai Completed":(1015,["h3","dubai"],["completed","dubai_completed"],["Level - Dubai"],[],[],["Any Completed"]),
    "Dartmoor Completed":(1016,["h3","dartmoor"],["completed","dartmoor_completed"],["Level - Dartmoor"],[],[],["Any Completed"]),
    "Berlin Completed":(1017,["h3","berlin"],["completed","berlin_completed"],["Level - Berlin"],[],[],["Any Completed"]),
    "Chongqing Completed":(1018,["h3","chongqing"],["completed","chongqing_completed"],["Level - Chongqing"],[],[],["Any Completed"]),
    "Mendoza Completed":(1019,["h3","mendoza"],["completed","mendoza_completed"],["Level - Mendoza"],[],[],["Any Completed"]),
    "Carpathian Mountains Completed":(1020,["h3","carpathian_mountains"],["completed","carpathian_mountains_completed"],["Level - Carpathian Mountains"],[],[],["Any Completed"]),
    "Ambrose Island Completed":(1021,["h3","ambrose_island"],["completed","ambrose_island_completed"],["Level - Ambrose Island"],[],[],["Any Completed"]),
    "ICA Facility Completed - Silent Assassin":(1022,["free","ica_facility"],["sa","ica_facility_sa"],["Level - ICA Facility"],[],[],["Any Completed - Silent Assassin"]),
    "Paris Completed - Silent Assassin":(1023,["h1","paris"],["sa","paris_sa"],["Level - Paris"],[],[],["Any Completed - Silent Assassin"]),
    "Sapienza Completed - Silent Assassin":(1024,["h1","sapienza"],["sa","sapienza_sa"],["Level - Sapienza"],[],[],["Any Completed - Silent Assassin"]),
    "Marrakesh Completed - Silent Assassin":(1025,["h1","marrakesh"],["sa","marrakesh_sa"],["Level - Marrakesh"],[],[],["Any Completed - Silent Assassin"]),
    "Bangkok Completed - Silent Assassin":(1026,["h1","bangkok"],["sa","bangkok_sa"],["Level - Bangkok"],[],[],["Any Completed - Silent Assassin"]),
    "Colorado Completed - Silent Assassin":(1027,["h1","colorado"],["sa","colorado_sa"],["Level - Colorado"],[],[],["Any Completed - Silent Assassin"]),
    "Hokkaido Completed - Silent Assassin":(1028,["h1","hokkaido"],["sa","hokkaido_sa"],["Level - Hokkaido"],[],[],["Any Completed - Silent Assassin"]),
    "Hawkes Bay Completed - Silent Assassin":(1029,["h2","hawkes_bay"],["sa","hawkes_bay_sa"],["Level - Hawkes Bay"],[],[],["Any Completed - Silent Assassin"]),
    "Miami Completed - Silent Assassin":(1030,["h2","miami"],["sa","miami_sa"],["Level - Miami"],[],[],["Any Completed - Silent Assassin"]),
    "Santa Fortuna Completed - Silent Assassin":(1031,["h2","santa_fortuna"],["sa","santa_fortuna_sa"],["Level - Santa Fortuna"],[],[],["Any Completed - Silent Assassin"]),
    "Mumbai Completed - Silent Assassin":(1032,["h2","mumbai"],["sa","mumbai_sa"],["Level - Mumbai"],[],[],["Any Completed - Silent Assassin"]),
    "Whittleton Creek Completed - Silent Assassin":(1033,["h2","whittleton_creek"],["sa","whittleton_creek_sa"],["Level - Whittleton Creek"],[],[],["Any Completed - Silent Assassin"]),
    "Isle of Sgail Completed - Silent Assassin":(1034,["h2","isle_of_sgail"],["sa","isle_of_sgail_sa"],["Level - Isle of Sgail"],[],[],["Any Completed - Silent Assassin"]),
    "New York Completed - Silent Assassin":(1035,["h2_dlc","new_york"],["sa","new_york_sa"],["Level - New York"],[],[],["Any Completed - Silent Assassin"]),
    "Haven Island Completed - Silent Assassin":(1036,["h2_dlc","haven_island"],["sa","haven_island_sa"],["Level - Haven Island"],[],[],["Any Completed - Silent Assassin"]),
    "Dubai Completed - Silent Assassin":(1037,["h3","dubai"],["sa","dubai_sa"],["Level - Dubai"],[],[],["Any Completed - Silent Assassin"]),
    "Dartmoor Completed - Silent Assassin":(1038,["h3","dartmoor"],["sa","dartmoor_sa"],["Level - Dartmoor"],[],[],["Any Completed - Silent Assassin"]),
    "Berlin Completed - Silent Assassin":(1039,["h3","berlin"],["sa","berlin_sa"],["Level - Berlin"],[],[],["Any Completed - Silent Assassin"]),
    "Chongqing Completed - Silent Assassin":(1040,["h3","chongqing"],["sa","chongqing_sa"],["Level - Chongqing"],[],[],["Any Completed - Silent Assassin"]),
    "Mendoza Completed - Silent Assassin":(1041,["h3","mendoza"],["sa","mendoza_sa"],["Level - Mendoza"],[],[],["Any Completed - Silent Assassin"]),
    "Carpathian Mountains Completed - Silent Assassin":(1042,["h3","carpathian_mountains"],["sa","carpathian_mountains_sa"],["Level - Carpathian Mountains"],[],[],["Any Completed - Silent Assassin"]),
    "Ambrose Island Completed - Silent Assassin":(1043,["h3","ambrose_island"],["sa","ambrose_island_sa"],["Level - Ambrose Island"],[],[],["Any Completed - Silent Assassin"]),
    "ICA Facility Completed - Suit Only":(1044,["free","ica_facility"],["so","ica_facility_so"],["Level - ICA Facility"],[],[],["Any Completed - Suit Only"]),
    "Paris Completed - Suit Only":(1045,["h1","paris"],["so","paris_so"],["Level - Paris"],[],[],["Any Completed - Suit Only"]),
    "Sapienza Completed - Suit Only":(1046,["h1","sapienza"],["so","sapienza_so"],["Level - Sapienza"],[],[],["Any Completed - Suit Only"]),
    "Marrakesh Completed - Suit Only":(1047,["h1","marrakesh"],["so","marrakesh_so"],["Level - Marrakesh"],[],[],["Any Completed - Suit Only"]),
    "Bangkok Completed - Suit Only":(1048,["h1","bangkok"],["so","bangkok_so"],["Level - Bangkok"],[],[],["Any Completed - Suit Only"]),
    "Colorado Completed - Suit Only":(1049,["h1","colorado"],["so","colorado_so"],["Level - Colorado"],[],[],["Any Completed - Suit Only"]),
    "Hokkaido Completed - Suit Only":(1050,["h1","hokkaido"],["so","hokkaido_so"],["Level - Hokkaido"],[],[],["Any Completed - Suit Only"]),
    "Hawkes Bay Completed - Suit Only":(1051,["h2","hawkes_bay"],["so","hawkes_bay_so"],["Level - Hawkes Bay"],[],[],["Any Completed - Suit Only"]),
    "Miami Completed - Suit Only":(1052,["h2","miami"],["so","miami_so"],["Level - Miami"],[],[],["Any Completed - Suit Only"]),
    "Santa Fortuna Completed - Suit Only":(1053,["h2","santa_fortuna"],["so","santa_fortuna_so"],["Level - Santa Fortuna"],[],[],["Any Completed - Suit Only"]),
    "Mumbai Completed - Suit Only":(1054,["h2","mumbai"],["so","mumbai_so"],["Level - Mumbai"],[],[],["Any Completed - Suit Only"]),
    "Whittleton Creek Completed - Suit Only":(1055,["h2","whittleton_creek"],["so","whittleton_creek_so"],["Level - Whittleton Creek"],[],[],["Any Completed - Suit Only"]),
    "Isle of Sgail Completed - Suit Only":(1056,["h2","isle_of_sgail"],["so","isle_of_sgail_so"],["Level - Isle of Sgail"],[],[],["Any Completed - Suit Only"]),
    "New York Completed - Suit Only":(1057,["h2_dlc","new_york"],["so","new_york_so"],["Level - New York"],[],[],["Any Completed - Suit Only"]),
    "Haven Island Completed - Suit Only":(1058,["h2_dlc","haven_island"],["so","haven_island_so"],["Level - Haven Island"],[],[],["Any Completed - Suit Only"]),
    "Dubai Completed - Suit Only":(1059,["h3","dubai"],["so","dubai_so"],["Level - Dubai"],[],[],["Any Completed - Suit Only"]),
    "Dartmoor Completed - Suit Only":(1060,["h3","dartmoor"],["so","dartmoor_so"],["Level - Dartmoor"],[],[],["Any Completed - Suit Only"]),
    "Berlin Completed - Suit Only":(1061,["h3","berlin"],["so","berlin_so"],["Level - Berlin"],[],[],["Any Completed - Suit Only"]),
    "Chongqing Completed - Suit Only":(1062,["h3","chongqing"],["so","chongqing_so"],["Level - Chongqing"],[],[],["Any Completed - Suit Only"]),
    "Mendoza Completed - Suit Only":(1063,["h3","mendoza"],["so","mendoza_so"],["Level - Mendoza"],[],[],["Any Completed - Suit Only"]),
    "Carpathian Mountains Completed - Suit Only":(1064,["h3","carpathian_mountains"],["so","carpathian_mountains_so"],["Level - Carpathian Mountains"],[],[],["Any Completed - Suit Only"]),
    "Ambrose Island Completed - Suit Only":(1065,["h3","ambrose_island"],["so","ambrose_island_so"],["Level - Ambrose Island"],[],[],["Any Completed - Suit Only"]),
    "ICA Facility Completed - Silent Assassin, Suit Only":(1066,["free","ica_facility"],["saso","ica_facility_saso"],["Level - ICA Facility"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "Paris Completed - Silent Assassin, Suit Only":(1067,["h1","paris"],["saso","paris_saso"],["Level - Paris"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "Sapienza Completed - Silent Assassin, Suit Only":(1068,["h1","sapienza"],["saso","sapienza_saso"],["Level - Sapienza"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "Marrakesh Completed - Silent Assassin, Suit Only":(1069,["h1","marrakesh"],["saso","marrakesh_saso"],["Level - Marrakesh"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "Bangkok Completed - Silent Assassin, Suit Only":(1070,["h1","bangkok"],["saso","bangkok_saso"],["Level - Bangkok"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "Colorado Completed - Silent Assassin, Suit Only":(1071,["h1","colorado"],["saso","colorado_saso"],["Level - Colorado"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "Hokkaido Completed - Silent Assassin, Suit Only":(1072,["h1","hokkaido"],["saso","hokkaido_saso"],["Level - Hokkaido"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "Hawkes Bay Completed - Silent Assassin, Suit Only":(1073,["h2","hawkes_bay"],["saso","hawkes_bay_saso"],["Level - Hawkes Bay"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "Miami Completed - Silent Assassin, Suit Only":(1074,["h2","miami"],["saso","miami_saso"],["Level - Miami"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "Santa Fortuna Completed - Silent Assassin, Suit Only":(1075,["h2","santa_fortuna"],["saso","santa_fortuna_saso"],["Level - Santa Fortuna"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "Mumbai Completed - Silent Assassin, Suit Only":(1076,["h2","mumbai"],["saso","mumbai_saso"],["Level - Mumbai"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "Whittleton Creek Completed - Silent Assassin, Suit Only":(1077,["h2","whittleton_creek"],["saso","whittleton_creek_saso"],["Level - Whittleton Creek"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "Isle of Sgail Completed - Silent Assassin, Suit Only":(1078,["h2","isle_of_sgail"],["saso","isle_of_sgail_saso"],["Level - Isle of Sgail"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "New York Completed - Silent Assassin, Suit Only":(1079,["h2_dlc","new_york"],["saso","new_york_saso"],["Level - New York"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "Haven Island Completed - Silent Assassin, Suit Only":(1080,["h2_dlc","haven_island"],["saso","haven_island_saso"],["Level - Haven Island"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "Dubai Completed - Silent Assassin, Suit Only":(1081,["h3","dubai"],["saso","dubai_saso"],["Level - Dubai"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "Dartmoor Completed - Silent Assassin, Suit Only":(1082,["h3","dartmoor"],["saso","dartmoor_saso"],["Level - Dartmoor"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "Berlin Completed - Silent Assassin, Suit Only":(1083,["h3","berlin"],["saso","berlin_saso"],["Level - Berlin"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "Chongqing Completed - Silent Assassin, Suit Only":(1084,["h3","chongqing"],["saso","chongqing_saso"],["Level - Chongqing"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "Mendoza Completed - Silent Assassin, Suit Only":(1085,["h3","mendoza"],["saso","mendoza_saso"],["Level - Mendoza"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "Carpathian Mountains Completed - Silent Assassin, Suit Only":(1086,["h3","carpathian_mountains"],["saso","carpathian_mountains_saso"],["Level - Carpathian Mountains"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
    "Ambrose Island Completed - Silent Assassin, Suit Only":(1087,["h3","ambrose_island"],["saso","ambrose_island_saso"],["Level - Ambrose Island"],[],[],["Any Completed - Silent Assassin, Suit Only"]),
}

target_kill_location_table = {
    "Elimination - ICA Facility - Jasper Knight":(5000, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Szymon Woźniak":(5001, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Kelly R. Edwards":(5002, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Alex Zhirov":(5003, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Ben Byrne":(5004, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Moses Butusov":(5005, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Leo Kazantsev":(5006, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Maxim Yevdokimov":(5007, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Wincenty Sobczak":(5008, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Yuri Abdulov":(5009, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Alex Mironov":(5010, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Ksawery Kowalski":(5011, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - John Nixon":(5012, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Genghis Demidov":(5013, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Cilas Netzke":(5014, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - James Pak":(5015, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Sebastian Murray":(5016, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Jacob Kimball":(5017, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - George Power":(5018, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Rodion Evdokimov":(5019, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Dorota Gorski":(5020, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Herman Evseev":(5021, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Emeryk Kamiński":(5022, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Korneli Pawłowski":(5023, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Calvin Fulton":(5024, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Christopher Matthews":(5025, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Ignat Kirillov":(5026, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Luke Yuriev":(5027, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - David Hoosier":(5028, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Klimek Nowicki":(5029, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Freddie Leach":(5030, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Leonti Golovanov":(5031, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Jame Sisco":(5032, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Malik Kalinin":(5033, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Andrew Turnbull":(5034, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Oscar Woronoff":(5035, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Michael Miller":(5036, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Riley Russell":(5037, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Aaron Spencer":(5038, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Christopher May":(5039, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Edward Evdokimov":(5040, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - William Iddings":(5041, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Luca Wood":(5042, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Longin Nowakowski":(5043, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - Evan Gomez":(5044, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - ICA Facility - James Martin":(5045, ["ica_facility"], ["skipped"], ["Level - ICA Facility"], [], [], ["Elimination - ICA Facility - Any","Elimination - Any"]),
    "Elimination - Paris - Viktor Novikov":(5046, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Dalia Margolis":(5047, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Lotye Lepage":(5048, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Felicien Montminy":(5049, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Benoit Vadeboncoeur":(5050, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Sébastien Pellerin":(5051, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Ayrald Ruel":(5052, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Nicholas Dostie":(5053, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Joan M. Harrison":(5054, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Florus Bolduc":(5055, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Nathalie Bourque":(5056, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Emil LaSalle":(5057, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Jérôme Quirion":(5058, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Mike Birkhead":(5059, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Philip Von Zell":(5060, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Francis Bourgeois":(5061, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Scoville Marier":(5062, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Yves Beauchemin":(5063, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Marcel DiMarco":(5064, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Justin Forest":(5065, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Roland Bertrand":(5066, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - William Brae DeLey":(5067, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Joseph Ducharme":(5068, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Benjamin Lacasse":(5069, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Joques Devanchent":(5070, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Onur Karadamir":(5071, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Lothaire Quessy":(5072, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Aurélien Ulliel":(5073, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Andrea Martinez":(5074, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Valiant Renaud":(5075, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Olivier Lauzier":(5076, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Irina Vladimir":(5077, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - David Boyer":(5078, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Tanguy Bostin":(5079, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Dana Zuka":(5080, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Céline Matoux":(5081, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Charlotte Bolton":(5082, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Olvan Shillingford":(5083, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Alfred Paquette":(5084, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Arianna DuMer":(5085, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Bayard Vadnais":(5086, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Hugues Ducharme":(5087, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Bob Moran":(5088, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Benjamin Charbonneau":(5089, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Bruce":(5090, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Mercer Givry":(5091, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Faustin D'Aoust":(5092, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Jasper Deleuran":(5093, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Orson Bler":(5094, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Romaine Loiselle":(5095, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Kerman Lagacé":(5096, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Hilaire Loiseau":(5097, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Francis Langelier":(5098, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Patrick Saurel":(5099, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Leroy Couet":(5100, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Peter Van Valdhorn":(5101, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Jacob Arpin":(5102, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Ilza Van Pferkuchen":(5103, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Eustache Marcoux":(5104, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Charles Bernier":(5105, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Yseult D'Aoust":(5106, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Rémy Guibord":(5107, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Daniel Duhamel":(5108, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Alex Vladimir":(5109, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Peppin Monjeau":(5110, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Creissant Mireault":(5111, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Nicolas Frank":(5112, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Cloridan Panetier":(5113, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Jacqueline Ducloitre":(5114, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Richard Mouet":(5115, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Cédric Bostin":(5116, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Marmion Monty":(5117, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Jesper Dupéré":(5118, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Auguste Du Trieux":(5119, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Pierrette de Brisay":(5120, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Arturo Gimenez":(5121, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Agatha Équipage":(5122, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Tristan Dupuis":(5123, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Octave Bazin":(5124, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Fabian Mora":(5125, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Patrick Bisson":(5126, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Anton Flamand":(5127, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Anne Schmidt":(5128, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Marushka Balewa":(5129, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Jean-Luc Salois":(5130, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Stéphane Lafrenière":(5131, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Courtland Pelchat":(5132, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Raymond Varieur":(5133, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Julien Beausoleil":(5134, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Guerin Fortier":(5135, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Aubert Achin":(5136, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Roland Landry":(5137, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Christophe Bienvenue":(5138, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Charles Le Gars":(5139, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Nicolas Cliche":(5140, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Kurt Donovan":(5141, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Hugh Neufville":(5142, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - André Furchard":(5143, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Håkan Almér":(5144, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Loyal Fluet":(5145, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Georges Cliche":(5146, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Rafael Dante":(5147, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Avril Lamour":(5148, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Baptiste Niro":(5149, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Normand Garcia":(5150, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Didier Paquet":(5151, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Émile Petrie":(5152, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Edward Stark":(5153, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Julee":(5154, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Pierre Rosso":(5155, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Laurent Denis Michel":(5156, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Patrick Brunault":(5157, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Jeremy Huxley":(5158, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Claire Swanson":(5159, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Bruce Faure":(5160, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Francis Guilmette":(5161, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Eliot Montminy":(5162, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Tren Po":(5163, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - André Beaulé":(5164, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Soren Sicard":(5165, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Anette Engstrom":(5166, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Julian Wakefield":(5167, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Guillaume Garceau":(5168, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Ernest Mousseau":(5169, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Angelique":(5170, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Christophe Nightlinglam":(5171, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Emilio Richard":(5172, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Lance Artois":(5173, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Walther Konig":(5174, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Elisabeth Weaver":(5175, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Arnou Vincent":(5176, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Léopold Georges":(5177, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Christophe Mothé":(5178, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Melissa Vanderzande":(5179, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Juliette Lauzier":(5180, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Luc Tessier":(5181, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Aubert Sanschagrin":(5182, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Falerina Phaneuf":(5183, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Rémi Ricard":(5184, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Benoit LaGarde":(5185, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Alexandre Montmorency":(5186, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Roland D'Aubigné":(5187, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Sabine Jorgensen":(5188, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Max Decker":(5189, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Congressman Walsh":(5190, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Jared Dorst":(5191, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Viviane Dejardin":(5192, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Florence Faucher":(5193, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Germain Marleau":(5194, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Toussaint Corbin":(5195, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Eugène Marleau":(5196, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Helmut Kruger":(5197, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Valérie Lazure":(5198, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Adrien Desilets":(5199, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Lana Caprice":(5200, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Felicienne Rancourt":(5201, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Frédérique Guay":(5202, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Emmanuel Bourgeois":(5203, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Alex Bourgeau":(5204, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Axel Lindholm":(5205, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Bruce Proulx":(5206, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Léopold Beaudoin":(5207, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Hilaire Durepos":(5208, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Alain Rocheleau":(5209, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Émile Beauchamp":(5210, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Daniel Rosenberg":(5211, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Arnou Camus":(5212, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Océane Bisson":(5213, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Clarence Caubert":(5214, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Rasmys Ammerfelt":(5215, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Aubin Angélil":(5216, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - William Boyer":(5217, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Jose Routhier":(5218, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Lee Sorel":(5219, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Édouard Leblanc":(5220, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Jaques Rosso":(5221, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Mallory Brunelle":(5222, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Félicien Bourque":(5223, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Inès Jetté":(5224, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Gwen Dawson":(5225, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Jacqueline Chicoine":(5226, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Auguste Marcheterre":(5227, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Jay Smart":(5228, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Ignace Richard":(5229, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Georges Busque":(5230, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Martha Herris":(5231, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Nicolas Bernard":(5232, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Stephane Marichal":(5233, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Turner Salois":(5234, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Alice Théret":(5235, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Gaspar Desforges":(5236, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Jacques Bonbon":(5237, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Marc Eunuque":(5238, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - André Cliche":(5239, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Paul Lizotte":(5240, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Denis Poulin":(5241, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Isaac Édouard":(5242, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Yelena Belova ":(5243, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - George Caisse":(5244, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Axel du Mont":(5245, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Lindsey La Coeur":(5246, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Adèle Rousseau":(5247, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Daniel Morel":(5248, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Denis Léger":(5249, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Dreux Descoteaux":(5250, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Gilles Favreau":(5251, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Raoul Blanc":(5252, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Mark Parker":(5253, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Sibyla Auger":(5254, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Amedee Paquin":(5255, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Dakota Krusemark":(5256, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Nico Gros":(5257, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Mabaya Mzabuni ":(5258, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Ramon":(5259, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Courtland Aupry":(5260, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Gretchen":(5261, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Chappell Francoeur":(5262, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Philippe Quiron":(5263, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Emma Lanoie":(5264, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Ray Baron":(5265, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Fabian Grégoire":(5266, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Malou A. Christiansen":(5267, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Donatien Marleau":(5268, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Alain Gendron":(5269, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Akiko Crilley":(5270, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Loïc Courcelle":(5271, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Catherine Burlet":(5272, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Romeo Markus":(5273, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Roger Dupont":(5274, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Didier Dennis":(5275, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Élise Labelle":(5276, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Pierre Fournier":(5277, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Hailey Brennan":(5278, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Valerie St. Claire":(5279, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Samantha Renard":(5280, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Eliot Lesage":(5281, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Carmine Falco":(5282, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Désiré Maheu":(5283, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Jean Moreau":(5284, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Justin Mills":(5285, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Fabienne Boucher":(5286, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Evangelinaya":(5287, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Sir Humphrey Titus Rutherford":(5288, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Yseult Boisclair":(5289, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Luc Ménard":(5290, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Bertrand Poussard":(5291, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Roch Bourdette":(5292, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Cédric Gendron":(5293, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Olivier Assis":(5294, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Charline Babin":(5295, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Moe Yamazaki":(5296, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Eric Hébert":(5297, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Orson Séguin":(5298, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Ellionora Lapresse":(5299, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Francois Debout":(5300, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Mathias Labelle":(5301, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Talbot Gougeon":(5302, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Guerin Hervé":(5303, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Fred Beaujolie":(5304, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Michel Laux":(5305, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - François Rouzier":(5306, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Sophus Fatale":(5307, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Fabrice Sansouci":(5308, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Tanguy Hétu":(5309, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Felicien Vallée":(5310, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Dominic Guimond":(5311, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Desire Lapresse":(5312, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Gloria Rosenberg":(5313, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Claude Deleuran":(5314, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Alexandre Favreau":(5315, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Michel Trier":(5316, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Philippe Dutrieux":(5317, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Liza McKenzie":(5318, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Hugh Provencher":(5319, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Anna Ljungren Hellander":(5320, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Igorrr Gautier":(5321, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Olivier Casgrain":(5322, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Jessika Truesdale":(5323, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Madison Lang":(5324, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Lothair Daoust":(5325, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Chapin Leroy":(5326, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Sheikh Salman al-Ghazali":(5327, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Satordi Roux":(5328, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Michael Archambault":(5329, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Benjamin Lacroix":(5330, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Gaspar Caillot":(5331, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Matthieu Francoeur":(5332, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Irene Obstacle":(5333, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Dennis The Agent":(5334, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Whoukr Serre":(5335, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Jacques Sansouci":(5336, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Montague Boisvert":(5337, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Sébastien Charbonneau":(5338, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Jean-Pierre Bourget":(5339, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Laurent Potvin":(5340, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - William Corbin":(5341, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Nelle Brent":(5342, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Sebastian Sato":(5343, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Michel Charest":(5344, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Paris - Jean-Luc Marchand":(5345, ["paris"], ["skipped"], ["Level - Paris"], [], [], ["Elimination - Paris - Any","Elimination - Any"]),
    "Elimination - Sapienza - Francesca De Santis":(5346, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Silvio Caruso":(5347, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Ermanno Siciliano":(5348, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Rinaldo Lucchese":(5349, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Davide Cantonato":(5350, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Claudio Onio":(5351, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Agnese Pagnotta":(5352, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Herb McGreenwood":(5353, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Berto Lo Cascio":(5354, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Maria Fretto":(5355, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Gina Napoleone":(5356, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Silvio Timeteo":(5357, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Fabiano Graziani":(5358, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Claudio Marinacci":(5359, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Cristiano Depretis":(5360, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Michael Brumm":(5361, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Ramiro Barese":(5362, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Gigliola Marcelo":(5363, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Gabrielli Onio":(5364, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Renardo Camerini":(5365, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Savino Angelo":(5366, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Leonardo Corleone":(5367, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Celestina De Francesco":(5368, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Rossana Franchi":(5369, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Angelo Manfredo":(5370, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Alessia Bambino":(5371, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Mona Pomella":(5372, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Quintiliano Amore":(5373, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Stefania Bistaffa":(5374, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Luigi Germano":(5375, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Sofia Bignotti":(5376, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Idir Alexander":(5377, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Leopardo Nigro":(5378, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Anna Vaccaro":(5379, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Giuditta Contu":(5380, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Pedro Busquets":(5381, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Davide Di Meo":(5382, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Paola Pollini":(5383, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Federica Basadonne":(5384, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Gianmario Lemma":(5385, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Lorenzo Panzarasa":(5386, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Enzo Pecha":(5387, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Thomas Marbaek Nielsen":(5388, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Emiliano Palombi":(5389, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Sergey Horoshih":(5390, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Rufino Rolla":(5391, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Lionel N. Suarez":(5392, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Stephan Ampburner":(5393, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Michelle Romano":(5394, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Laura Bagnaschi":(5395, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Mamante Cassino":(5396, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Alessio Biagioni":(5397, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Denise Fachetti":(5398, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Michela Velardo":(5399, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Lisandro Manocchio":(5400, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Alessio Cremente":(5401, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Angelo Pagliarini":(5402, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Tamara Sabbatini":(5403, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Uschi Neubrandt":(5404, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Elia Mirro":(5405, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Paciano Sagese":(5406, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Dante Eggerburg":(5407, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Chiara Balbo":(5408, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Manuele Li Fonti":(5409, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Ilario Mazzanti":(5410, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Maria Torraca":(5411, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Romeo Palmiero":(5412, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Rico Siciliano":(5413, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Robert Alves":(5414, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Alice Biondi":(5415, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Renardo Palmiero":(5416, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Dani Iniesta":(5417, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Andrea Andrighetto":(5418, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Greta Palerma":(5419, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Dimitri Napolitani":(5420, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Nadia Barese":(5421, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Sergio Centomo":(5422, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Fiorenzo Arcuri":(5423, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Gina Bellucci":(5424, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Marco Vienna":(5425, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Marcelo Faravelli":(5426, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Umberto Megazzini":(5427, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Giuliano Paglia":(5428, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Tommaso Selvaggio":(5429, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Gil Scherzer":(5430, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Benvenuto Lucchese":(5431, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Valeria Rosetti":(5432, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Carla Spinato":(5433, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Caterina Prevelia":(5434, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Stefano DeRose":(5435, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Raffaele Lanfranchi":(5436, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Paciano Giovanelli":(5437, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Rinaldo Cattaneo":(5438, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Francesco Vivaldi":(5439, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Paciano Anzaldo":(5440, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Beata De Salvatori":(5441, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Luca Platini":(5442, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Daniel Samper":(5443, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Torres Piombo":(5444, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Lisa Almestoy":(5445, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Claudia Musella":(5446, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Alessandro Guenzi":(5447, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Valfredo Matarrese":(5448, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Maria Delaurentis":(5449, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Clodoveo Rametta":(5450, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Empirio Torres":(5451, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Silvia Masullo":(5452, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Orlando Siciliano":(5453, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Giorgio Liguori":(5454, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Adalberto Valassi":(5455, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Iacopo La Petina":(5456, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Lorenzo Lancini":(5457, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Bella Carillo":(5458, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Silvia Morando":(5459, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Mads S. Jorgensen":(5460, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Aubron Wood":(5461, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Loris Brigandi":(5462, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Miguel Anzaldo":(5463, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Fabiano Torraca":(5464, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Michele Inversini":(5465, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Jack Please":(5466, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Barbara Donati":(5467, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Nazareno Dimario":(5468, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Edmondo Giordano":(5469, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Veronica Mantovani":(5470, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Paolo Fellegara":(5471, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Terenzio Famiglietti":(5472, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Araldo Labate":(5473, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Stefano Orecchio":(5474, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Sebastiano Noce":(5475, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Sergio Pantalone":(5476, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Siffredo Nocera":(5477, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Paciano Panzarella":(5478, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Uberto Navone":(5479, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Reginaldo Neglia":(5480, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Tulio Paluzzi":(5481, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Tristiano Nicoletti":(5482, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Amintore Palmiero":(5483, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Reginaldo Spitale":(5484, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Timoteo Muccino":(5485, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Abbondanzio Miano":(5486, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Massimiliano Scanarotti":(5487, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Davide Bergamaschi":(5488, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Luigi Saltatore":(5489, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Manuele Pignatelli":(5490, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Fabrizio Davide":(5491, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Giuliano Esposito":(5492, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Gennaro Esposito":(5493, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Prudenzio Endrizzi":(5494, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Salomone Marandola":(5495, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Orlando Zito":(5496, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Nicola Scanarotti":(5497, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Olinto Trevisan":(5498, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Roberto Vargas":(5499, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Viana Buccho":(5500, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Cesario Bolognese":(5501, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Claudio Spaghetti":(5502, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Stefano Alberti":(5503, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Ruggero Ferri":(5504, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Andrea Cacciatore":(5505, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Claudio Velotta":(5506, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Aldo Trentino":(5507, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Raffaele Ossola":(5508, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Ennio Bruno":(5509, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Olinto Scanarotti":(5510, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Benedetto Bozzuto":(5511, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Sergio DeRose":(5512, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Roman Langella":(5513, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Antonio Ferrari":(5514, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Gianmario Lorenzini":(5515, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Chef Marcello Ray":(5516, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Valeria Pinelli":(5517, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Marino Manna":(5518, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Alberto Genovesi":(5519, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Tarso Rossano":(5520, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Fazio Mennella":(5521, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Stefano Zelaschi":(5522, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Rina Moretti":(5523, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Luciano Maino":(5524, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Argelia Petillo":(5525, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Alessandro Andreotti":(5526, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Severino Romani":(5527, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Nicola Trevisan":(5528, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Iacopo Grassi":(5529, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Benito Onio":(5530, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Apuleio Di Lauro":(5531, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Marcello Romani":(5532, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Virgilio Lucciano":(5533, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Luigi Cresso":(5534, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Enzo Ferri":(5535, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Andrea Penca":(5536, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Mauro Romani":(5537, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Alexis Caso":(5538, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Remondo Guerrera":(5539, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Lucio Gallarini":(5540, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Eulalia Milani":(5541, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Flemming Andreetto":(5542, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Filippo Rossi":(5543, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Elisa Giorgio":(5544, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Antonella Varotto":(5545, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Carlo Scarpa":(5546, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Bruno Domenica":(5547, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Alfredo Rizzo":(5548, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Santo Masiello":(5549, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Enrico Genovesi":(5550, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Paolo Parella":(5551, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Bertoldo Velardo":(5552, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Eufebio Cosenza":(5553, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Arsenio Milani":(5554, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Riccardo Parella":(5555, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Arcibaldo Nasi":(5556, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Aquilino Bozzuto":(5557, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Fabrizio Veritiero":(5558, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Tiziano Lo Duca":(5559, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Gioia Fallaci":(5560, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Giuliano Beneventi":(5561, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Marcello Grassi":(5562, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Viliberto Branca":(5563, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Diego Bergamaschi":(5564, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Filiberto Nucci":(5565, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Matteo Martinelli":(5566, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Edoardo Pugliesi":(5567, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Luis Pique":(5568, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Filippo Nucci":(5569, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Settimo De Luca":(5570, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Marco Arcuri":(5571, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Girolamo Giombi":(5572, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Alfredino Russo":(5573, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Osvaldo Paniccia":(5574, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Dr. Oscar Lafayette":(5575, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Angelo Della Morte":(5576, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Timoteo Costa":(5577, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Lorenzo Finale":(5578, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Rosson Ansovino ":(5579, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Silvano Colavecchio":(5580, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Mariano Davide":(5581, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Argelia Degrandi":(5582, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Diego Bernaschi":(5583, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Alessio Guilizzoni":(5584, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Isaia Maita":(5585, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Diego Rigoni":(5586, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Padre Francesco":(5587, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Cataldo Pisani":(5588, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Ugolino Catena":(5589, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Leardo Padovesi":(5590, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Serafina Crosetti":(5591, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Jakob Oxenvad":(5592, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Delfio Endrizzi":(5593, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Mauro Toscano":(5594, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Terenzio Endrizzi":(5595, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Mario Masiello":(5596, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Ferrece Bambino":(5597, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Palladia Tancredi":(5598, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Claudia Di Meo":(5599, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Guido Lori":(5600, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Severino Arcuri":(5601, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Marcello Franceschi":(5602, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Indro Pagnotto":(5603, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Leonardo Trentini":(5604, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Cristina Dionisi":(5605, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Angelo Panicucci":(5606, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Germano Crosetti":(5607, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Sal Falcone":(5608, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Riccardo Lombardo":(5609, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Gianluca Bravo":(5610, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Anacleto Rossi":(5611, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Craig \"Rocco\" McVeigh":(5612, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Rosario Sapone":(5613, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Giulio Baresi":(5614, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Susanna Vacchi":(5615, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Giuseppa Ferri":(5616, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Marcello Colombo":(5617, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Geraldo Dellucci":(5618, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Ugo Panicucci":(5619, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Serena Salice":(5620, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Claudio Parisi":(5621, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Prisco Arcuri":(5622, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Amintore Betti":(5623, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Paciano Sassoli":(5624, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Beatrice Fernandi":(5625, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Paulino Beletti":(5626, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Evodio Minnella":(5627, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Sergio Alba":(5628, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Ignazio Alberti":(5629, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Emilio Milani":(5630, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Gabrielli Monaco":(5631, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Giovanni Anselmi":(5632, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Daniele Pozzi":(5633, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Riccardo Lancini":(5634, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Gianmario Lorenzetti":(5635, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Riccardo Barosselli":(5636, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Salvatore Lemma":(5637, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Paola Maffucci":(5638, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Paciano Altobello":(5639, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Carla Pollini":(5640, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Fabio Pavione":(5641, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Sapienza - Mario Saltatore":(5642, ["sapienza"], ["skipped"], ["Level - Sapienza"], [], [], ["Elimination - Sapienza - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Reza Zaydan":(5643, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Claus Hugo Strandberg":(5644, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Irshaad Begum":(5645, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Nimah Turay":(5646, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Nada Ozer":(5647, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Itch Schtulman":(5648, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Aamir Iman":(5649, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Maymoonah Ozer":(5650, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Mariam Jafari":(5651, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Safdar Matin":(5652, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Faarooq Omer":(5653, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Haneef Ghazi":(5654, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Zaahid Jamal":(5655, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Tayyab Samra":(5656, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Fawzi Jawdah Koury":(5657, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ikraam Dawood":(5658, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Asad Farag":(5659, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Misbaah Popal":(5660, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Khadijah Asmar":(5661, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Aarif Akram":(5662, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Hussein Fahad Sarkis":(5663, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Mariam Guler":(5664, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Basmah Beshara":(5665, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Hasan Halim":(5666, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Shaikh Hakim":(5667, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Salaamah Naim":(5668, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Baaqir Ismael":(5669, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Tasnim Masih":(5670, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Riaasat Hussein":(5671, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Kosi Von Kaisheva":(5672, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Orlando Herrington":(5673, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Link Parr":(5674, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Royden Cloutier":(5675, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Stearne Snelgrove":(5676, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Hayyan Nazih Boulos":(5677, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Renell Gunnells":(5678, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Mirna Camirand":(5679, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Dawn Seegobin":(5680, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Lulwa Arij Tannous":(5681, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Cornelia Eriksson":(5682, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Khair al Din Yusef Sarkis":(5683, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Gilberto Dillingham":(5684, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Izo Von Kaishev":(5685, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Erik Egerup":(5686, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ellissa Sagris":(5687, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Reggie Afkham":(5688, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Haley Tuen":(5689, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Agretha Dupont":(5690, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Joanna Coldwell":(5691, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Roman Gribsch":(5692, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Juan Ortegon":(5693, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Charleston Coldwell":(5694, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Cloe Statile":(5695, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Oliver Norfolk":(5696, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Rolph Griffith":(5697, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Darla Crabe":(5698, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Yusef Sultan Asker":(5699, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Nabhan Shamim Sleiman":(5700, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Kimmie Soumis":(5701, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Vincenz Senten":(5702, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Khaleel Humam Harb":(5703, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Salwa Fahada Nahas":(5704, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Andreana Corey":(5705, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Rasool Abdelrahman":(5706, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Maysa Saah":(5707, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Carrie Brodfuehrer":(5708, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Dabir Wasim Abboud":(5709, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Tammara McWaters":(5710, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Nimah Sultana":(5711, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Faraj Budail Saliba":(5712, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ree Stutts":(5713, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ahmed Hashim":(5714, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Noori Humam Harb":(5715, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Evin Kingdon":(5716, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Sahar Anwaar":(5717, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Kevin Goertzen":(5718, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Latifa Eid":(5719, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Rashid Labib Gaber":(5720, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Sabih Munjid Tuma":(5721, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Iqbaal Rahaim":(5722, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Jawwaad Reza":(5723, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Louise Jakobsson":(5724, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Nazeer Ishmael":(5725, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ajmal Khalil":(5726, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Irfaan Haidar":(5727, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ann-Katrin Svensson":(5728, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ihsan Ba":(5729, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Iqbaal Abbasi":(5730, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Khalida Ghazi":(5731, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Magnus Nordin":(5732, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Azhar Zahra":(5733, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Mada Anwaar Sleiman":(5734, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Erik Linden":(5735, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ismat Kazmi":(5736, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Faisal Murad Asghar":(5737, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Benjamin Forsman":(5738, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Freja Johansson":(5739, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Nijad Khaled Rahal":(5740, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Markus Landen":(5741, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Stefania Ghattas":(5742, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Mushtaaq Mohammadi":(5743, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Khalaf Seif al Din Tannous":(5744, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Terry Strong":(5745, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Akhtar Dajani":(5746, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ja'far Farrah":(5747, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Faheem Attar":(5748, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Anette Engstrom":(5749, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ja'far Sayed":(5750, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Julia Sten":(5751, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Shahin Abdul-Barr Maalouf":(5752, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Sinan Nizar Khouri":(5753, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Mustafaa Hai":(5754, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Nabhan Rashid Haik":(5755, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Hudhaifah Mushtaq Shadid":(5756, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ameen Mu'nis Salib":(5757, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Jesper Karlsson":(5758, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ashraf Mahfouz":(5759, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Asma Jafari":(5760, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Shaikh Darwish":(5761, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Robert Eriksson":(5762, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Khaleel Rani Nahas":(5763, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Zaahir Faraj":(5764, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Aamir Mohamed":(5765, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Nadeem Qazi":(5766, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Kai Abdul-Barr Maalouf":(5767, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Badri Fakhiri Handal":(5768, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ellinore Ivarsson":(5769, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Bishr Nusrah Deeb":(5770, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Anwaar Aly":(5771, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ashraf Raghib Mustafa":(5772, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Mukarram Javid":(5773, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Orvar Liljeström":(5774, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Baaqir Moghaddam":(5775, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Harry Olsson":(5776, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Nadeem Ghaffari":(5777, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Viggo Hofsted Andersen":(5778, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Boulos Majid Saliba":(5779, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Johnathan Wallin":(5780, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - E'jaaz Akram":(5781, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Asad Habeeb":(5782, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Junaid Irani":(5783, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Mahbub Jalal al Din Ganim":(5784, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ismat Meskin":(5785, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Oskar Åberg":(5786, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Layla Hashmi":(5787, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Edward Malmqvist":(5788, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Björn Ekbom":(5789, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Bishr Abdul-Shahid Bahar":(5790, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Masruq Khalid Almasi":(5791, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Bayhas Bishr Attia":(5792, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Hilda Berg":(5793, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Marta Monarka":(5794, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Alden Riauff Hansson":(5795, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Shahbaaz Hallal":(5796, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Amaan Zaki":(5797, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Adan Rasil Gerges":(5798, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Nash'at Hakeem Botros":(5799, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Hiram Daher":(5800, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Hannes Engdahl":(5801, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Robert Dahl":(5802, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ellinor Westrup":(5803, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Rami Suhayl Handal":(5804, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - In'am Yusri Kouri":(5805, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Hektor Lindberg":(5806, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Anas Meer":(5807, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Nazeer Ammar":(5808, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Aamal Asalah Kassis":(5809, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Habeeb-Allah Saleh":(5810, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Basheer Jan":(5811, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Shafee Hosseini":(5812, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Labib Abdul-Wajid Sabbag":(5813, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Khaaliq Awan":(5814, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Linnea Dahberg":(5815, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Timmie Beavington":(5816, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Mazhar Haider":(5817, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Aamir Qadir":(5818, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Rafeeq Younes":(5819, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Rune Soir":(5820, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Raji Emir Ghanem":(5821, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Lasse Braun Hansson":(5822, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Oskar Engstrom":(5823, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ziyad Jameel Gerges":(5824, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Zaa'ir Aman":(5825, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Mihyar Ra'id Kassis":(5826, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Nazeer Hammoud":(5827, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Nasuh Wahhab Saliba":(5828, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Asma Turay":(5829, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Khuzaimah Afeef Saliba":(5830, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Nils Göransson":(5831, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Iqbaal Hashmi":(5832, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Nasuh Kedar Boutros":(5833, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Afaaf Jafari":(5834, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Mukarram Awan":(5835, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Jens-Kristian Nielsson":(5836, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Riaasat Yousif":(5837, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Abdul-Waliy Wakil Salib":(5838, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Riaasat Ishmael":(5839, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Sayyed Mohammed":(5840, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Patrik Fransson":(5841, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Jonas Mårtensson":(5842, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Wikus Fahmy":(5843, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Peter Papersson":(5844, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Shuaib Aly":(5845, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Håkan Almer":(5846, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Naadim Wahab":(5847, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Hanif Rasmi Antoun":(5848, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Haddad Nawaf Seif":(5849, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Rafeeq Lone":(5850, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ajmal Farhat":(5851, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Arshad Mohammadi":(5852, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Andre Engström":(5853, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Zaahir Ashraf":(5854, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Shaukat Shahan":(5855, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Nuhaid Muneer Guirguis":(5856, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Juwayriyah Sadek":(5857, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Zafir Lablab Tannous":(5858, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Adam Ahlgren":(5859, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Peter Hägg":(5860, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Knut Marklund":(5861, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Othman Jaun Fakhoury":(5862, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Taqqee Akel":(5863, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Thea Lundin":(5864, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ismat Masri":(5865, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Haamid Firman":(5866, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Jesper Olson":(5867, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Faisal Shahid":(5868, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Darwish Jumu'ah Shamoun":(5869, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Lars Christiansson":(5870, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Zaki Diab":(5871, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Tyler Clark":(5872, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Kazim Falah Bishara":(5873, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Dhakwan Rafiq Daher":(5874, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ameen Sahli":(5875, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - L'jaaz Latif":(5876, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Gustav Sundin":(5877, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Umayr Samih Bitar":(5878, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Konny Engström":(5879, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ms. Persson":(5880, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Jakob Ringholm":(5881, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Yahya Lablab Naifeh":(5882, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Bassam Sadad Attia":(5883, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Jenni Holm":(5884, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Pamela Kingsley":(5885, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Sayid Laham":(5886, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Hektor Berggren":(5887, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Anton Olofsson":(5888, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - M Sofranov":(5889, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Irshaad Ismail":(5890, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Tayyab Mahmood":(5891, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Shaukat Muhammad":(5892, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Usaid Hai":(5893, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Safee-Ullah Hussain":(5894, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Taslim Faraj Abboud":(5895, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Rafeeq Samaan":(5896, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Tomas Persson":(5897, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Erik Olander":(5898, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ziyad Boulos Sleiman":(5899, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Jameel Haq":(5900, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Saleem Hai":(5901, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Nadeem Amar":(5902, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Bashir Lubaid Sarkis":(5903, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Lars Ljungren":(5904, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ola Matisson":(5905, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Steffane Quinn":(5906, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Anwaar Shaheed":(5907, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Markus Janson":(5908, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Mansoor Jamail":(5909, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Mansoor Shaikh":(5910, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Pernille Hansson":(5911, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Zaa'ir Koroma":(5912, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Faheem Dajani":(5913, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Khalidah Darwish":(5914, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Emil Hult":(5915, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Axel Hansdotter":(5916, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Waleed Suraqah Tahan":(5917, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Amjad Abdelnour":(5918, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Lena Nilsson":(5919, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Jan Dragsström":(5920, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Emil Persson":(5921, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Aarif Ghazi":(5922, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Altaaf Jabour":(5923, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Ubayy Saud Mifsud":(5924, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Rasmus Gyllenhaal":(5925, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Safi Diya al Din Ganim":(5926, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Vincent Robertsson":(5927, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Jeff Baker":(5928, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Emanuel Holmlund":(5929, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Anna Nordin":(5930, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Shaahid Safar":(5931, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Marrakesh - Peder Valind":(5932, ["marrakesh"], ["skipped"], ["Level - Marrakesh"], [], [], ["Elimination - Marrakesh - Any","Elimination - Any"]),
    "Elimination - Bangkok - Jordan Cross":(5933, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Ken Morgan":(5934, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Lion Forrest":(5935, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Anna Stone":(5936, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Nicholas Kelly":(5937, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Madee Phyachai":(5938, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Dr. Jones Yama":(5939, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Yod rak Sirisopa":(5940, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Sukhon":(5941, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Tinn Tansoongnen":(5942, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Victor Huttingdon":(5943, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Charanya Darakorn":(5944, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Keerati Siracha":(5945, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Utumporn Lampoon":(5946, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Sanan Theprak":(5947, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Oliver Shepherd":(5948, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - George Austin":(5949, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Orapan Sanya":(5950, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Chanchai":(5951, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Nam Srisati":(5952, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Lamom Montri":(5953, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Arthit Prugsanapan":(5954, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Morgan Fleming":(5955, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Erica Marcantoni":(5956, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Kamon":(5957, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Vlad Volodin":(5958, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Anakiné Himmeltramp":(5959, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Pawel Stanton":(5960, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Somwadi Jiravate":(5961, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Lukas Himmeltramp":(5962, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Kong Aromdee":(5963, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Duchess Mette Von Pødenphant II":(5964, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Rand Chiravat":(5965, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Ivona Dumitrache":(5966, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Tadthon Nitpattanasai":(5967, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Arthit Rardchawat":(5968, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Clarice Huttingdon":(5969, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Channarong":(5970, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Arthit":(5971, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Seri Chadee":(5972, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Somporn Shimma":(5973, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Lady Martha Mendoza ":(5974, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Tayakorn Sindudeja":(5975, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Charles Slaughter":(5976, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Duangkamol":(5977, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Dang":(5978, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Pakdhi Samsen":(5979, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Chutamas Preecha":(5980, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Chompunut Pichit":(5981, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Tibur Ragan":(5982, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - A-Wut":(5983, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Victoria Cole":(5984, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Jack Torrent":(5985, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Sean Stokes":(5986, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Alice J. Lowry":(5987, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Peter Tibucharta ":(5988, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Somboon Murang":(5989, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Parun Kaewmanee":(5990, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Thomas Craig":(5991, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Surawong Wiwantra":(5992, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Willy Ponhpaiboon":(5993, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Pedro Parker":(5994, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Jariya Chansiri":(5995, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Akkarat Chaikarn":(5996, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Thep Kantawong":(5997, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Feyd Reuter":(5998, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Dorn Palathai":(5999, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Tharn Srisai":(6000, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Pu Patalung":(6001, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Naruemon Thanom":(6002, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Niwat Chalermchon":(6003, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Tunlaya Janpong":(6004, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Hannah Devaux":(6005, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Harrington McDonald":(6006, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Nattapat Juntasa":(6007, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Ulrich Gloeckner":(6008, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Vincent Devaux":(6009, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Pasut Juntasa":(6010, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Alexandra Churchill":(6011, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Christian Sato":(6012, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Millicent McDonald":(6013, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Amnuay Tanasugarn":(6014, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Bernadette Benoit":(6015, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Lloyd":(6016, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Francis Fish":(6017, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Magnus Pike":(6018, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Thanaboon Boonliang":(6019, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Chatri Wongsakul":(6020, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Konthee Samak":(6021, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Danit Vanich":(6022, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Rama Malee":(6023, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Savitree Srisak":(6024, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Lamom Songprawati":(6025, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Parin Chan'ocha":(6026, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Sudarak Kasemsun":(6027, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Thanaboon Wattana":(6028, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Boontum Chaipatana":(6029, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Pravat Sudham":(6030, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Ratsami Panichwit":(6031, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Saichon Sirikun":(6032, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Chaidet Prasongsanti":(6033, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Kittinan Janpong":(6034, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Thammaporn Mongkoltham":(6035, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Kriangsak Phakdi":(6036, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Parit Plainukool":(6037, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Taptim Nitpattanasai":(6038, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Roxana Franklin":(6039, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Chalong Akradej":(6040, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Lek Chalerm":(6041, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Simon Powel":(6042, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Martin Holas":(6043, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Khae Kasemsun":(6044, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Amnuay Suparat":(6045, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Thongtae Ornlamai":(6046, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Ronald Sump":(6047, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Yada Pimolkittikool":(6048, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Nibun Panyachon":(6049, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Thomas Vaughn":(6050, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Susanne Vargas":(6051, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Jordie Fergusson":(6052, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Tiwat Kitjakarn":(6053, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Phimtha Anant":(6054, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Orwell Newton":(6055, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Sinn Tithikul":(6056, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Alexander Hoffman":(6057, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Duncan Lindsey":(6058, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Somchai":(6059, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Marie Hoffmann":(6060, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Toby Hicks":(6061, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Nattapong":(6062, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Duangrudee Prugsanapan":(6063, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Werawat":(6064, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Wongsa Jaidee":(6065, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Nopjira Lui":(6066, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Noi Lertkunakorn":(6067, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Jackie Tan":(6068, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Anurat":(6069, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Thong Kon Cheenchamras":(6070, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Sud Prasarttong":(6071, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Charoen Kongkatitum":(6072, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Isaree Keacham":(6073, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Suprang Sirisaeng":(6074, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Rama Yodsuwan":(6075, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Bahn Nakpradith":(6076, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Anada Kammana":(6077, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Supaporn Gason":(6078, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Teerasak":(6079, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Hans Graub":(6080, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Tumar Bimbombur":(6081, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Vipada Ahunai":(6082, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Prawta Buaborn":(6083, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Niran Wichasak":(6084, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Louie Pan":(6085, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Kriang Sak Taksin":(6086, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Magnu":(6087, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Ivan Rogers":(6088, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Keith McKenzie":(6089, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Birapan Phromporn":(6090, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Thong Daeng":(6091, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Maelng":(6092, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Buddy Akward":(6093, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Kong Lekcharuthas":(6094, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Apsorn Kwangnoi":(6095, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Prapas Narkhirunkanok":(6096, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Abel De Silva":(6097, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Kantharat Vilailuck":(6098, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Douglas Shearer":(6099, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Aidan Boyle":(6100, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Holly":(6101, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Ellis Carey":(6102, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - 'Bones' Gordon":(6103, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Kian Potter":(6104, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Erik Francis":(6105, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Robert Walker":(6106, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Rodrigo Santo":(6107, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Tanutam Charoenkul":(6108, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - James 'Sparky' Parker":(6109, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Khun Sasipa":(6110, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Savitree Pureesrisak":(6111, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Rob Neve":(6112, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Kevin Johnson":(6113, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Nicholas Cross":(6114, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Alan Froge":(6115, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Sid Hammer":(6116, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Mekhla Mahagitsiri":(6117, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Declan Houghton":(6118, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Kamnan Sindudeja":(6119, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Steve Albino":(6120, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Edgar Froge":(6121, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Steve Tilsbury":(6122, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Brian Jones":(6123, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Thomas Burton":(6124, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - George Groves":(6125, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Tarrin":(6126, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Bob 'Altmuligman' Ganoosh":(6127, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Walt Gervers":(6128, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Bunyapoo Jetjirawat":(6129, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Pran Sanya":(6130, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Barry \"Relax\" O'Bannion":(6131, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Chaiya":(6132, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Christopher Lees":(6133, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Tuk Kitjakarn":(6134, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Tinnawat Mahanakorn":(6135, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Niew":(6136, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Phonphan":(6137, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Rodrigo Santoro":(6138, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Siddhi Mongkoltham":(6139, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Tham-boon Shinnawat":(6140, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Taylor Todd":(6141, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Dugald Dalgetty":(6142, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Kamol":(6143, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Colin Dwight":(6144, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Michael Emerson":(6145, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Heidi Santoro":(6146, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Bailey Rees":(6147, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Wes Liston":(6148, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Shane":(6149, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Manny Boscovitch":(6150, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Crowbar":(6151, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Narisa Somwan":(6152, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Mitch Leary":(6153, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Frank Horrigan":(6154, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Clayton Mint":(6155, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Benjamin Bertram":(6156, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Samuel \"Gamgee\" McGee":(6157, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Thijs Fhakir":(6158, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Otis Kaplan":(6159, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Jordan Harding":(6160, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Jerry Busey":(6161, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Boonma Chavalit":(6162, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Phet Pichit":(6163, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Tanawat":(6164, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Yingyai Chaiprasit":(6165, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Jack Guard":(6166, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Kurt Hondo":(6167, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Jude O'Sullivan":(6168, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Geoff Cloney":(6169, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Anton Scales":(6170, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Wattana":(6171, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Jack \"Hellhound\" Cerberus":(6172, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Russ Jones":(6173, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Jason Hunter":(6174, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Seri Sanya":(6175, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Gavin 'Crusher' Lewis":(6176, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Suda":(6177, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Daniel Norris":(6178, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Nipat Narkhirunkanok":(6179, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Chulabhorn Ratana":(6180, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Phet Rardchawat":(6181, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Bob":(6182, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Thomas Zimmerman":(6183, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Suchin Thanom":(6184, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Declan Glover":(6185, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Al 'Tootsie' Avery":(6186, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Fred Bones":(6187, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Kasem Sakda":(6188, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Jackie Carrington":(6189, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Magnud Johnson":(6190, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Johnatan Kindane":(6191, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Prasert":(6192, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Al D'Andrea":(6193, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Wiriya":(6194, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Henry Norman":(6195, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Penchan Khad":(6196, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Khun mae Anand":(6197, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Stan Taggart":(6198, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Scott \"Adkins\" Edmunson":(6199, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Alf Newcombe":(6200, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Dexy Barat":(6201, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Ubbe Leffesson":(6202, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Alex \"Bullet\" Harrower":(6203, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Prem":(6204, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Steve Bacon":(6205, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Rookie Nelson":(6206, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Julian":(6207, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Edward Johnston":(6208, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Sam Emerson":(6209, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Neil Burgess":(6210, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Max 'Blue' Balls":(6211, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Andrew Abbott":(6212, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Jed 'Knuckles' Pitt":(6213, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Lexington \"Luthor\" Sayles":(6214, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - John Harrison":(6215, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Ed Greaves":(6216, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Peder Koch":(6217, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Mrs. Mookjai":(6218, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Garrett Detail":(6219, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Param Rojviriya":(6220, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Evan Briggs":(6221, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Mike Hunt":(6222, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Nathan 'Napalm' Palmer":(6223, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Thomas Pentz":(6224, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Gabriel Cook":(6225, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Bangkok - Sean Richards":(6226, ["bangkok"], ["skipped"], ["Level - Bangkok"], [], [], ["Elimination - Bangkok - Any","Elimination - Any"]),
    "Elimination - Colorado - Sean Rose":(6227, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Penelope Graves":(6228, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Ezra Berg":(6229, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Maya Parvati":(6230, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - William Candler":(6231, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Dexter Beaman":(6232, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Craig Abel":(6233, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Thomas Harner":(6234, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Morris Estrella":(6235, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Roy Marcum":(6236, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Thomas Joy":(6237, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Liam Butler":(6238, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Joey Barker":(6239, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Frank Chappell":(6240, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Andre Washington":(6241, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Leo Frost":(6242, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Claude Ramsey":(6243, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Seth Thomas":(6244, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Ernest Ward":(6245, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Proust Kisser":(6246, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Kenneth Anderson":(6247, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Edward Sanders":(6248, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Jacob Segal":(6249, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Travis Eliason":(6250, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Grant Brundage":(6251, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Drew Askins":(6252, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Carlos Vandenbosch":(6253, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Billy Goodwin":(6254, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Franklin Henry":(6255, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Cary Dunson":(6256, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Larry Bauman":(6257, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Blake Massie":(6258, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Joseph Stevens":(6259, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - David Nasser":(6260, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Ryan Miller":(6261, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Daniel Romero":(6262, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Philip Durden":(6263, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Benjamin Howells":(6264, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Raymond Kane":(6265, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Douglas Gray":(6266, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Tyler Gordon":(6267, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Mark Hicks":(6268, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Lester Galvan":(6269, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Elliot Carey":(6270, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Milton Smith":(6271, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Dylan Sanders":(6272, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Michael Adams":(6273, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Brandon Davis":(6274, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Mario Jarosz":(6275, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Collin McDonald":(6276, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Kory Campbell":(6277, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - George Lassiter":(6278, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Vince Derringer":(6279, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Wilbur Douglas":(6280, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Donald Banks":(6281, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Robert Powell":(6282, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Richard Kirkland":(6283, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Reggie Duncan":(6284, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Matthew Robertson":(6285, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Michael Rowland":(6286, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Quince Elliott":(6287, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Austin Mohler":(6288, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Reece Faulkner":(6289, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Dwayne Clark":(6290, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Eddie Hobbs":(6291, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Terry Ehrhart":(6292, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Anthony Jackson":(6293, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Kyle Watson":(6294, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Scott Quinones":(6295, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Tony Donahue":(6296, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Devin Neeley":(6297, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Warren Sharp":(6298, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Julio Yingst":(6299, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Johnathan Hernandez":(6300, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Dustin Soto":(6301, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Jarrod Casson":(6302, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Herman Sommer":(6303, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Isaac Kay":(6304, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Curt Navarro":(6305, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Arnold Johnson":(6306, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Albert Knarr":(6307, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Timothy Guerrero":(6308, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Ewan Morton":(6309, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Harrison Donnelly":(6310, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Clinton Webster":(6311, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Samuel Reber":(6312, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Logan Akhtar":(6313, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Dean Johnson":(6314, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Joshua Trumbo":(6315, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Peter Briggs":(6316, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Leroy Ewers":(6317, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Dale Ward":(6318, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Miguel Ellis":(6319, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Floyd Tackett":(6320, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - George Mancuso":(6321, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Scott Harris":(6322, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Mario Thompson":(6323, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Harold Chaney":(6324, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Don Rosé":(6325, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Timothy Arneson":(6326, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Mason Burgess":(6327, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Jack Reid":(6328, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Mac Jackson":(6329, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Spencer Pugh":(6330, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Joel Bolton":(6331, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Brian Truong":(6332, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Milton Geiger":(6333, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Finn Jacobs":(6334, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Tyrone Balderas":(6335, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Lindsey Sims":(6336, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Adam May":(6337, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Tommy Mack":(6338, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Preston Becker":(6339, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Luke Poole":(6340, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Paul Mackey":(6341, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Bruce Guenther":(6342, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Dennis Chapin":(6343, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Danny Arceo":(6344, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Everett Wagner":(6345, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Lawrence Mark":(6346, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Lloyd Burgess":(6347, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Andrew Francis":(6348, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Jake Day":(6349, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Stanley Perez":(6350, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Brent Kerr":(6351, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Franklin Crew":(6352, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - James Reynolds":(6353, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Marcus Nolan":(6354, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - George Jenkins":(6355, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Bobby Arnott":(6356, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Jonathan Coplin":(6357, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Greg Barnes":(6358, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Chad Duhon":(6359, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Alexander Patrick Strandlod":(6360, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Aaron Collier":(6361, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Colorado - Nicholas Chow":(6362, ["colorado"], ["skipped"], ["Level - Colorado"], [], [], ["Elimination - Colorado - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Yuki Yamazaki":(6363, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Makio Yanagisawa":(6364, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Genta Kakuta":(6365, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Gakushi Yamaoka":(6366, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Chiyoe Tawara":(6367, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Tsuneto Ozaki":(6368, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Kai Bennett":(6369, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Yuusou Ishikuno":(6370, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Tsumugi Iwai":(6371, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Mitsuhiro Oyanagi":(6372, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Gracie Anderson":(6373, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Kouchi Yuasa":(6374, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Morris Bjornsson":(6375, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Maury Veich":(6376, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Seiichi Asada":(6377, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Tamami Kuroki":(6378, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Nokadota":(6379, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Kazuyasu Maruyama":(6380, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Aaron Bates":(6381, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Gouki Ootsuki":(6382, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Emiri Nimiya":(6383, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Yukio Matsushima":(6384, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Risae Oosawa":(6385, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Marie Pépin":(6386, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Philipa Wallis Fujioka":(6387, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Hifumi Yoshii":(6388, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Emma Lane":(6389, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Wakana Tsutsumi":(6390, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Shuusuke Kitajima":(6391, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Kathrin Kuster":(6392, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Hokuto Yamamoto":(6393, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Kouki Shimizu":(6394, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Lord Harvey Silk":(6395, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Axel George":(6396, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Justin Speer":(6397, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Chiyuu Matsusaki":(6398, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - J. Brooke":(6399, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Genya Nakada":(6400, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Candice Valencia":(6401, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Mekashita":(6402, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Shoudai Kurosawa":(6403, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Chiyuri Nakamoto":(6404, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Angelina Kleiner":(6405, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Youki Yamamura":(6406, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Lowell Aucoin":(6407, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Shuusuke Seki":(6408, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Hanna Olsen":(6409, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Sadato Murai":(6410, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Ikkei Andou":(6411, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Shiki Fujino":(6412, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Dwyer G. Pitt":(6413, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - John Maverick":(6414, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Riki Hirayama":(6415, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Kyoko Asai":(6416, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Diane Reddington":(6417, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Nails":(6418, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Fuuki Suitani":(6419, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Kaimei Kuroki":(6420, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Kyuuya Sugiyama":(6421, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Bunka Shintani":(6422, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Masayoshi Sakakihara":(6423, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Kii Ine":(6424, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Nikica Pranjić":(6425, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Nicholas Laurent":(6426, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Sorahiko Satou":(6427, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Ikuma Nakazawa":(6428, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Amos Dexter":(6429, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Franco Valencia":(6430, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Oscar Himura":(6431, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Isaac Bradshaw":(6432, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Shoichi Kataoka":(6433, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Tadao Motsuzuki":(6434, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Kenichi Arakawa":(6435, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Minao Morishita":(6436, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Eva-Lis Larsen Nugent":(6437, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Tamika Oomori":(6438, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Michael Brennan":(6439, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Tomochika Koizumi":(6440, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Helena Ootsuka":(6441, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - James Stewart":(6442, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Yasuaki Inagaki":(6443, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Waku Ochiai":(6444, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Kouyuu Okuta":(6445, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Miamoto San":(6446, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Jason Portman":(6447, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Tomochika Honma":(6448, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Chikashi Nakatani":(6449, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Andrew Roovers":(6450, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Edward Veitch":(6451, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Bertine Gerhardsen":(6452, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Kyouta Shinden":(6453, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - James Carey":(6454, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Alexander Kellerman":(6455, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Kaname Konishi":(6456, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Hans Hansson":(6457, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Yuuto Saiki":(6458, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Akihide Nishihara":(6459, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Sakio Miyazawa":(6460, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Ikkei Tsutsui":(6461, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Yoshifumi Yagawa":(6462, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Paula Ungar":(6463, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Noori Shadid":(6464, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Mitsuko Kinjou":(6465, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Ray Miller":(6466, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Jikushikatate":(6467, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Sadato Katagiri":(6468, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Samuel Santos Lima":(6469, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Tenma Kanou":(6470, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Saita Shinoda":(6471, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Harry Hansson":(6472, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Hidaka Uno":(6473, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Heita Ozawa":(6474, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Aiko Kawashima":(6475, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Spencer Short":(6476, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Haruo Nakamoto":(6477, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Kou Tokunaga":(6478, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Souji Yamamura":(6479, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Toshihisa Taniguchi":(6480, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Homare Kanai":(6481, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Kinji Yamazaki":(6482, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Yukiya Kubo":(6483, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Kouko Yoshioka":(6484, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Masumi Okamoto":(6485, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Lara Carvalho Lima":(6486, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Hidetoshi Higa":(6487, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Huan Yue Hao":(6488, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Hideyo Shibata":(6489, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Johan Ishibashi":(6490, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Feng Ch'eng":(6491, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Lisa Rickardson":(6492, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Yamato Narita":(6493, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Yukihisa Nagaoka":(6494, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Yoshikazu Sasaki":(6495, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Oliver Drabløs":(6496, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Eric 'Sandā no ashi' Sjövold":(6497, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Leah Parker":(6498, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Melissa M. Adams":(6499, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Satoyo Takano":(6500, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Katashi Ito":(6501, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Rafn Helguson":(6502, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Toshimi Shinden":(6503, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Hayato Shinden":(6504, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Jeoffroi Durepos":(6505, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Tomiyuki Fujihara":(6506, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Masashi Morioka":(6507, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Junsuke Okamoto":(6508, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Lyle Gaulin":(6509, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Salvio Parra Rojo":(6510, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Tenri Shinosaki":(6511, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Ellinor Yasuda":(6512, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Junya Andou":(6513, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Spartaco Gallo":(6514, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Olivier Damon":(6515, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Takemi Shiraishi":(6516, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Erik Baumgartner":(6517, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Azuma Murayama":(6518, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Yui Uemura":(6519, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Max Gerber":(6520, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Fumihiro Ochiai":(6521, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Debra Askew":(6522, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Tommy JJ Gervais":(6523, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Hope Ershova":(6524, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Satomu Sugiyama":(6525, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Carlton Smith":(6526, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Harumi Sakei":(6527, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Akira Nakamura":(6528, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Shikuna":(6529, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Sakutarou Oyama":(6530, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Hayaki Fukasawa":(6531, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Alma Reynard":(6532, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Roger Booth":(6533, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Matthew Bowman":(6534, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Orson Mills":(6535, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Preston Morce":(6536, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Charlie Burke":(6537, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Nat Ivers":(6538, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Jarvis Corey":(6539, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Theo Linwood":(6540, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Carey Huxley":(6541, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - James Ellsworth":(6542, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Dennis Elder":(6543, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Archie Gilliam":(6544, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Shane Minett":(6545, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Pat Thacker":(6546, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Perry Firmin":(6547, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Doug Shelby":(6548, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Alec Shaw":(6549, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Gerard Mann":(6550, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Henry Todd":(6551, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Val Solomon":(6552, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Neil Bunker":(6553, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Clifton Waterman":(6554, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Kris Mathews":(6555, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Eugene Burrell":(6556, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Dee Morriss":(6557, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Will Irwin":(6558, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Dwight Nye":(6559, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Kyle Roscoe":(6560, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Julian Rowntree":(6561, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Hawkes Bay - Eddie Wilcox":(6562, ["hawkes_bay"], ["skipped"], ["Level - Hawkes Bay"], [], [], ["Elimination - Hawkes Bay - Any","Elimination - Any"]),
    "Elimination - Miami - Sierra Knox":(6563, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Robert Knox":(6564, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Nickolas Eliott":(6565, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Montgomery Statham":(6566, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Samuel Kahn":(6567, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Allan Blackwood":(6568, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Guy Garrod":(6569, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Louie Merrigold":(6570, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Floyd Cooke":(6571, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Mariela Volbuena":(6572, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Thierry Durand":(6573, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Leyla Otis":(6574, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Zhong Zhao":(6575, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Johnny Himenez":(6576, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Andie Martin":(6577, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Ruperto Devine":(6578, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Lennart Nichols":(6579, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Brittany Mayes":(6580, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Reynard Armstrong":(6581, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Reina Brownlow":(6582, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Clement Augustine":(6583, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Pablo Quirindongo":(6584, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Merilyn Aguando":(6585, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Jose Nino":(6586, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Therese Ilbert":(6587, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Emerson Maria":(6588, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Martin Rains":(6589, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Melvyn Fosse":(6590, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Dennis Elliot":(6591, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Jude Gonzales":(6592, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Eduardo Vasquez":(6593, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Kian Pelaez":(6594, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Mark Spencer":(6595, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Abdul Suleiman":(6596, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Mable Colton":(6597, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Levi Akerman":(6598, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Finn Wheeler":(6599, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Alexandra Wynne":(6600, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Peter DelaSangre":(6601, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Alyson Derby":(6602, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Earl Faison":(6603, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Dyson Ortega":(6604, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Reynard Wash":(6605, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Ewart Richardson":(6606, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Érica Stenet":(6607, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Derek Rigsby":(6608, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Brad Easton":(6609, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Tracy Du Toit":(6610, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Lance Bryant":(6611, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Quinn Mac Reachtain":(6612, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Robyn Haywood":(6613, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Mike Kozlowski":(6614, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Fishy Joe":(6615, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Ben Estevez":(6616, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Francois Ricot":(6617, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Mikkel Bekenbauer":(6618, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Moses Lee":(6619, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Marcus Bellamy":(6620, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Irene Bronson":(6621, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Vernon Wilton":(6622, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Freddie Bradford":(6623, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Perlita Maynard":(6624, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Summer Turner":(6625, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Gaten Henderson":(6626, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Kit Arkwright":(6627, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Spencer Moneysong":(6628, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Lucas McLaughlin":(6629, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Bessie Smith":(6630, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Glenn Henson":(6631, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Travis Norman":(6632, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Dexter Drake":(6633, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Nellye Goode":(6634, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Steven Benton":(6635, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Cam Patton":(6636, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Michael Dough":(6637, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Simon Powell":(6638, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Kit Sangster":(6639, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Quinton Kendrick":(6640, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Tobias Cropper":(6641, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Marc Wallace":(6642, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Alexandra Smith":(6643, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Lionel Hambleton":(6644, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Dyson Courtenay":(6645, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Layton Caine":(6646, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - John Smith":(6647, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Giacinto Ronchi":(6648, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Sammi Espinoza":(6649, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Gabriel Griffin":(6650, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Håkan Almer":(6651, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Pedigo Rijos":(6652, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Matt Lucas":(6653, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Simon Petersson":(6654, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Trevor Jones":(6655, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - John Petrock":(6656, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Jeff Castle":(6657, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Tim Beckham":(6658, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Denholm Cook":(6659, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Nick Richards":(6660, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Ewart Bloxham":(6661, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - John Doe":(6662, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Jaylene Kevins":(6663, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Markus Blekinson":(6664, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Nicholas Velmorres":(6665, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Angus Bloodworth":(6666, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Benny Potter":(6667, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Rasmus Hammerfield":(6668, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Dane Audley":(6669, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Lorenzo Santo":(6670, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Keanna Smith":(6671, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Brendon Fulton":(6672, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Eldred Deadman":(6673, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Mike Hull":(6674, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Henry Ling":(6675, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Michael Kane":(6676, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Marcus Lindsday":(6677, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Alex Moyer":(6678, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Terry Nealy":(6679, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Wu Yang":(6680, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Nick Young":(6681, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Tyler Geier":(6682, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Rebecca Merchant":(6683, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Brigitte Cabot":(6684, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Chen Li":(6685, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Marisela Frank":(6686, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Floyd Raglin":(6687, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Adolph Rey":(6688, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Kate Switzer":(6689, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Mark Sempers":(6690, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Rylan Fulton":(6691, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Duncan Rains":(6692, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Megan Franklyn":(6693, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Jay Smart":(6694, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Albert Noah":(6695, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Brent Leroy Jenkins":(6696, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Michael Mercer":(6697, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Jodie Richardson":(6698, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Nicole Elmer":(6699, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Daniela Estevez":(6700, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Irving Fryer":(6701, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Douglas Nelson":(6702, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Edwin Quira":(6703, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Raphael Benitez":(6704, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Frank Johnsson":(6705, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Elly Boon":(6706, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Homer Dedrick":(6707, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Ivy Dresselhaus":(6708, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Jimeno Vasquez":(6709, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Linsdey Morrison":(6710, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Rafferty Butler":(6711, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Arnold Pender":(6712, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Dean Nash":(6713, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Thomas Ferrero":(6714, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Hector Delgado":(6715, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Tristen Skinner":(6716, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Paul Mu Adib":(6717, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Luke Brenton":(6718, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Darell Hart":(6719, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Larry Tracey":(6720, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Aidan Hambleton":(6721, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Cathryn Castle":(6722, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Kanye Belmonte":(6723, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Carl Breunmann":(6724, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Valentine Wilton":(6725, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Derek McInnis":(6726, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Nathaniel Pearce":(6727, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - John Carpenter":(6728, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Fabian Woodham":(6729, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Andrea Pantano":(6730, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Steve Addison":(6731, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Dwain Neil":(6732, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Julien Heijmans":(6733, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Chuck Cowden":(6734, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Marty Will Patrick":(6735, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Jude Black":(6736, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Evan Saunders":(6737, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Chris Perkins":(6738, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Richard Nimeth":(6739, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Alice Lund":(6740, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - William Pettus":(6741, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Leonzio Naggi":(6742, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Bryenne Franklin":(6743, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Alexander Rios":(6744, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Fu Ling":(6745, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Timmothy Aisle":(6746, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Eddie Brock":(6747, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Matt Villareba":(6748, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Davis White":(6749, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Alex Wiesenhauer":(6750, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Antonio Suarez":(6751, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Michael Gibb":(6752, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Fernando Berry":(6753, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Ellen Ives":(6754, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Willis Bronson":(6755, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Clem Milburn":(6756, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Antoine Mack ":(6757, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Ava Snider":(6758, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Wilmer Truman":(6759, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Richard Rissler":(6760, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Lindsey La Coeur":(6761, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Ike Hill":(6762, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Mona Campo":(6763, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Jack Harrison":(6764, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Olivier Quintero":(6765, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Benjamin Smith":(6766, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Sam Palacious":(6767, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - James Kennedy":(6768, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Donald Fede":(6769, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Maxwell Rutter":(6770, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Matthew Nimeth":(6771, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Reed Oliver":(6772, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Dan Lovel":(6773, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Kent Wakefield":(6774, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Kenny Alonso":(6775, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Jeana Brannon":(6776, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Jared Benton":(6777, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Sam Williams":(6778, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Leopold Harrold":(6779, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Jack Baxter":(6780, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Kiko Stills":(6781, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Kraig Hevitt":(6782, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Irvin Attwood":(6783, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - James  Wade":(6784, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Maynard Daniell":(6785, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Elmo Johnsson":(6786, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Elisa Graves":(6787, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - John Spencer":(6788, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Craig Erickson":(6789, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Norbert Mikey Traves":(6790, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Samantha Pena":(6791, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Wright Herbertson":(6792, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Anne Washington":(6793, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Elisabeth Olmos":(6794, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Luther Quick":(6795, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Brandon Brent":(6796, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Leroy Wakefield":(6797, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Curtis Armstrong":(6798, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Sixto Perez":(6799, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Deon Wilson":(6800, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Dennis Delaney":(6801, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Yun Liao":(6802, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Chip Ellsworth":(6803, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Wu Ruan":(6804, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Grace Miller":(6805, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Grace Smith":(6806, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Melvin Lynwood":(6807, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Xavier Perez":(6808, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Kierra Preston":(6809, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Harmony Barnett":(6810, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Leta Boyce":(6811, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Jun Zheng":(6812, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Gustav Gerber":(6813, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Edwin Schmitz":(6814, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Erin Saunders":(6815, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Brandon Riggins":(6816, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Brian Bautista":(6817, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Jenelle Gonzalez":(6818, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Alton Gerig":(6819, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Felipe Rojas":(6820, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Ally Keen":(6821, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Nick Riera":(6822, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Casimiro Cookson":(6823, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Levi Risher":(6824, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Alonso Ricardo Villareba":(6825, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Theo Braddock":(6826, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Mark Ridgewell":(6827, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Garnett Castelo":(6828, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Michael Napolitano":(6829, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Edward Deering":(6830, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Catherine Harding":(6831, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Jorge Padilla":(6832, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Ronald Pacheco":(6833, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Martha Stevenson":(6834, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Steven Atkinson":(6835, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Eliseo Ramirez":(6836, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Alexander Rienks":(6837, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Dorita Sinclair":(6838, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Ernesto Nedina":(6839, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Baltazar Morrison":(6840, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Heidi Santoro":(6841, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Felix Riego":(6842, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Rich Platt":(6843, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Hector Mateus":(6844, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Brett Lampini":(6845, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Terry Johnsson":(6846, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Kirsten Willard":(6847, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Edward \"Ted\" Mendez":(6848, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Derryl Bunker":(6849, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Johnattan Kindane":(6850, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Mariella Benitez":(6851, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Gyles Sims":(6852, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Lee Harlan":(6853, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Ted Montgomery":(6854, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Miles Hopson":(6855, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Timothy Hobbs":(6856, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Leonard Howland":(6857, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Alys Horn":(6858, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Brandon Doughty":(6859, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Nancy Soto":(6860, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Vicky Erickson":(6861, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Miami - Thorben PAwlitzki":(6862, ["miami"], ["skipped"], ["Level - Miami"], [], [], ["Elimination - Miami - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Andrea Martínez":(6863, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Rico Delgado":(6864, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Jorge Franco":(6865, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Concordia Trejo Palacios":(6866, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Henry Cotto Echevarría":(6867, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Neyén Rojas Valenzuela":(6868, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Zenobio Almaraz Benítez":(6869, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Luca Olivares Rosas":(6870, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Crisipo Esparza Montano":(6871, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Mateos Curiel Romero":(6872, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Fulxencio Urías Perea":(6873, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Baruc Archuleta Bravo":(6874, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Apeles Olivares Carbajal":(6875, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Melchior Tejeda Romo":(6876, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Vespasiano Soria Covas":(6877, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Aldano Ruelas Pabón":(6878, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Juan Carlos Aragón Loya":(6879, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Alf Chavarría Valdez":(6880, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Damaris Olivera Covarrubias":(6881, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Remo Esparza Uribe":(6882, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Jehová Patino Limón":(6883, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Querubín Cardona Patino":(6884, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Antígono Henríquez Rosas":(6885, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Manfredo Valladares Godoy":(6886, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Eros Ponce Miramontes":(6887, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Dan Buckman":(6888, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Idumeo Gallegos Medina":(6889, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Elena Pequeño Samaniego":(6890, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ubaldo Flores Uribe":(6891, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Giuliano Garibay Montemayor":(6892, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Vladimir Valladares Tirado":(6893, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Anat Olivárez Leyva":(6894, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Nilton Toledo Domínquez":(6895, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Lahual Acuna León":(6896, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Hiram Santacruz Montero":(6897, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Obdulio Guerrero Bahena":(6898, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Carlos Soria Calvillo":(6899, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Basil Rubio Prieto":(6900, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Aristocles Paez Meléndez":(6901, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Margarita E. Bergeron":(6902, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Nicasio Quiñónez Nino":(6903, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Taciano Rolón Ceballos":(6904, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Piperion Puente Alaniz":(6905, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Matthew Muñiz Serna":(6906, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Gaxan Galarza Tamez":(6907, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Erakil Echevarría Santana":(6908, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Uberto Navarrete Casares":(6909, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Gregory M. Yeager":(6910, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Alaor Parra Figueroa":(6911, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Loreley Caballero Tejeda":(6912, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Romano Quintero Trujillo":(6913, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Constantino Loya Duarte":(6914, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Gisberto Orozco Maestas":(6915, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Badomero Murillo Ocampo":(6916, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Reinardo Limón Chacón":(6917, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Salvatore Soliz Polanco":(6918, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Livio Vigil Domínquez":(6919, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Solón Sosa Vargas":(6920, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Joseph V. McCoy":(6921, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Whoukr Serre":(6922, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Diocles Gaona Mota":(6923, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Maro Santiago Alba":(6924, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Heldo Calderón Cepeda":(6925, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Miguelito Estruendo Soliz":(6926, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Casildo Alva Murillo":(6927, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Andrés Sigilo Terán":(6928, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Evando Casares Verdugo":(6929, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Britanic Reséndez Dávila":(6930, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Karen Elizondo Barajas":(6931, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Fulk Angulo Mireles":(6932, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Harry D. Hendrix":(6933, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Bartolomé Reséndez Venegas":(6934, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Arlet Padrón Roldán":(6935, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ariadna Tapia Carmona":(6936, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Laumer Bravo Alicea":(6937, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ray Comejo Tijerina":(6938, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Fulvio Quiroz Ontiveros":(6939, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Menelao Canales Vergara":(6940, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Mentor Curiel Zelaya":(6941, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Favio Comejo Quintero":(6942, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Duncan Soliz Hernádez":(6943, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Linus Flamenco Oestecamino":(6944, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Clementino Sevilla Rubio":(6945, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Lie Balderas Leiva":(6946, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Larry Steven Martin":(6947, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Heber Griego Sepúlveda":(6948, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Anfos Zapata Ruelas":(6949, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Quintilian Toro Naranjo":(6950, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ryder Granados Abrego":(6951, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ibero Segura Padilla":(6952, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Nancy C. Jarrett":(6953, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Mahoma López Ulloa":(6954, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Oswald Zaragoza Viera":(6955, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Day Nava Mercado":(6956, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Landolfo Gracia Cotto":(6957, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Indíbil Casares Rosario":(6958, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Aciscio Nava Fierro":(6959, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Dorotea Sanches Cárdenas":(6960, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Demian Reyes Ruelas":(6961, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Gordon Jáquez Yáñez":(6962, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Suyai García Arévalo":(6963, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Pelagio Huerta Centeno":(6964, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Amaranto Benítez Godoy":(6965, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Zenzo Valdivia Cantú":(6966, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Jack R. Espinoza":(6967, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Lisa T. Johnson":(6968, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Adolphus Navarro Tamayo":(6969, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Geordie Bustos Arana":(6970, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Martzel Mascarenas Najerae":(6971, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Aron Galvez Quintana":(6972, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ulises Flórez Aranda":(6973, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ligia Hidalgo Zarate":(6974, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Hermenegildo Galarza Leyva":(6975, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Agop Mota Alcantar":(6976, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Frine Aguilar Manzanares":(6977, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Raul Covas Ibarra":(6978, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Pompei Zelaya Cabán":(6979, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Rudy Lucero Medina":(6980, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Iosef Gastelum Pacheco":(6981, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Adhemar Árias Ledesma":(6982, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Manfredo Collado Ledesma":(6983, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Giulio Ramón Vázquez":(6984, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Millaray Benítez Reyna":(6985, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Merlino Marrero Valdez":(6986, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Zohar Abeyta Frías":(6987, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Alfeo Arteaga Cervantes":(6988, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Luano Trujillo Polanco":(6989, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ticiano Barragán Soliz":(6990, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Iona Mateo Benítez":(6991, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Amy Griffiths":(6992, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ubaldo Rosario Arenas":(6993, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Bowie Mondragón Atencio":(6994, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Alan Llarnas Collado":(6995, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Nolberto Raya Mesa":(6996, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Oderico Rosas Leyva":(6997, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Fulvio Reynoso Zarate":(6998, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Charles J. Taylor":(6999, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Victorio González Mesa":(7000, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Pericles Bernal Muro":(7001, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Gaspard Sánchez Villagómez":(7002, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Vanisher":(7003, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Mederico Olmos Sánchez":(7004, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Hermalindo Armenta Griego":(7005, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Eladia Rolón Collado":(7006, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Wendy J. Farmer":(7007, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Lotario Venegas Núñez":(7008, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Numa Torres Ramón":(7009, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Odon Collazo Hurtado":(7010, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Betiana Banda Yáñez":(7011, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Enrique Rosas Garay":(7012, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Casio Olivera Manzanares":(7013, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Juan Carlos Palomo Santana":(7014, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Benicio Zelaya Mora":(7015, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Astor Herrera Valenzuela":(7016, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Vespasiano Coronado Dueñas":(7017, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Cherie S. Kimble":(7018, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Pablo Benítez Farías":(7019, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Laurentino Riojas Alba":(7020, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Amandio Muñiz Rivero":(7021, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Dalmazio Coronado Bañuelos":(7022, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Nazario Botello Arreola":(7023, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Victoria R. Hairston":(7024, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Tristán Abeyta Narváez":(7025, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Laurence Perales Bonilla":(7026, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Adriel Sandoval Galván":(7027, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Phoebe Spencer":(7028, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ademaro Juárez Montez":(7029, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Barbelo Salgado Ulibarri":(7030, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Anna Horton":(7031, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Damocles Caballero Bernal":(7032, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Asael Granado Romo":(7033, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Dimas Mota Pulido":(7034, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Javier Valenzuela Pedroza":(7035, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Rocco Garza Blanco":(7036, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Brandon Arellano Sandoval":(7037, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ginette Cantú Sierra":(7038, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Percival Luevano Rascón":(7039, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Floreal Briseño Trujillo":(7040, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Pampín Padilla Domínquez":(7041, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ibero Samaniego Valadez":(7042, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Marón Viera Coronado":(7043, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Liberto Velásquez Linares":(7044, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Sofiel Patino Crespo":(7045, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Alucio Ocampo Zayas":(7046, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Quintilo Sosa Raya":(7047, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Floreal Cordova Melgar":(7048, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Danny Crespo Alonso":(7049, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Orangel Medrano Mota":(7050, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Alessandro Mejía Comejo":(7051, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ion Escamilla Orozco":(7052, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Taita":(7053, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Nedar Mena Flores":(7054, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Lea Lerma Rocha":(7055, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Héctor Delgado":(7056, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Emerio Solorio Alcalá":(7057, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Paola Bravo Magana":(7058, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Gotardo Vera Saldana":(7059, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Hermes Cortez Núñez":(7060, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Gundelinda Villagómez Castillo":(7061, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Juven Rivera Ramón":(7062, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Osmaro Camacho Mendoza":(7063, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ladislao Alonzo Collazo":(7064, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Jules Prieto Gamez":(7065, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Areb Sepúlveda Aguilera":(7066, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Peer Baeza Villa":(7067, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Quintilio Salcedo Chacón":(7068, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Giusto Bueno Benavidez":(7069, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Raifroid Chacón Cavazos":(7070, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Liam Mascarenas Guillén":(7071, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Erakil Mendoza Rentería":(7072, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Pascua Jáquez Caballero":(7073, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Jennifer Montanez Tirado":(7074, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Rode Alba Rodrígez":(7075, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ezer Ávila Villanueva":(7076, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Bru Garica Jurado":(7077, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Rafael N. Rangel":(7078, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Remo Zayas Paredes":(7079, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Yoko Escamilla Espinoza":(7080, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Cleandro Ybarra Pedroza":(7081, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ciril Adame Cabrera":(7082, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Esperance Cano Alvarez":(7083, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ciro Serrano Cortés":(7084, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Enrique N. Sager":(7085, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Walker H. Hambright":(7086, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Hygin Esparza Caraballo":(7087, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Tom E. Shockley":(7088, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Licio Domínquez Camarillo":(7089, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Dustin Rubio Villalobos":(7090, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Danika Molina Rico":(7091, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Fazzio Campos Ramón":(7092, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Carlomagno Yáñez Pacheco":(7093, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ceferino Franco Cervántez":(7094, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Atanasio Salazar Grijalva":(7095, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Odina Castellanos Villareal":(7096, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Olimpo Rojas Gaytan":(7097, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Gaspar Gastelum Escamilla":(7098, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Pat K. Miller":(7099, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Urbano Solorio Aguayo":(7100, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Gus Santiago Arellano":(7101, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Emiliano Acuna Cárdenas":(7102, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Gandolfo Leiva Rentería":(7103, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Caifas Aragón Jaime":(7104, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Pelayo Angulo Castaneda":(7105, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Zunilda Lozano Segovia":(7106, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Laina Hernández Paez":(7107, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Astolfo Llarnas Leyva":(7108, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Saúl Rojas Caraballo":(7109, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Bayard Domínquez Carmona":(7110, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Mateo Luna Covarrubias":(7111, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Pusaki Alanis Pacheco":(7112, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Policarpo Escobedo Candelaria":(7113, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Tarsicio Godoy Saldivar":(7114, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Juana Física Peralta":(7115, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Aristarco Loera Naranjo":(7116, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Onésimo Polanco Alonzo":(7117, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Errolán Baca Ornelas":(7118, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Liborio Velez Alcaraz":(7119, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ram Gonzales Torres":(7120, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Sinforoso Chapa Marín":(7121, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Vittorio Covas Galarza":(7122, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ananías Ayala Centeno":(7123, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Agila Quintanilla Palomino":(7124, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Tarquino Loya Lerma":(7125, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Argeo Rodriguez":(7126, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Yrko Sierra Aguirre":(7127, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Paul Powers":(7128, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Caren Carrillo Segovia":(7129, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Catalina Delgado":(7130, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Werner Bernal Caraballo":(7131, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Bella Chapa Guardado":(7132, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Juanito Cocineropapa Veliz":(7133, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Mariangela Zambrano Muñoz":(7134, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Vic Mateo Sandoval":(7135, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Polo Leal Aguirre":(7136, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Ezio Ruvalcaba Ochoa":(7137, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Vulcano Baez Zelaya":(7138, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Shaun M. Kinney":(7139, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Salviano Ulibarri Lovato":(7140, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Germain Espinosa Godoy":(7141, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Kara G. Hill":(7142, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Jeanette Cedillo Montenegro":(7143, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Susan M. Delong":(7144, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Crisol Herrera Zarate":(7145, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Peregrino Aparicio Santiago":(7146, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - John C. Moser":(7147, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Aureo Baca Alaniz":(7148, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Micael Matías Juárez":(7149, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Otelo Enríquez Jasso":(7150, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Delfor Sandoval Ortega":(7151, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Macario Lira Negrón":(7152, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Lauro Parra Solano":(7153, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Kristy E. Green":(7154, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Antonino Agosto Comejo":(7155, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Adamo Campos Varela":(7156, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Torres Piombo":(7157, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Dióscoro Ávalos Posada":(7158, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - César Calderón Duran":(7159, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Alejandrina Arteaga Sierra":(7160, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - Vero Valencia Verduzco":(7161, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Mumbai - Vanya Shah":(7162, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Dawood Rangan":(7163, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Wazir Kale":(7164, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Krishna Chadha":(7165, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Pran Narayana":(7166, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Vinay Sanjeev":(7167, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Vihaan Chawla":(7168, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Siddharth Banerjee":(7169, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Gaurav Mukherjee":(7170, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Aditya Banerjee":(7171, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Adit Rao":(7172, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Karthik Kulkarni":(7173, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Krishna Garg":(7174, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Trishna Pravina":(7175, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ansh Lal":(7176, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Kalyan Ram":(7177, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Tanvi Naidu":(7178, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Deepak Narayana":(7179, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Lakshmi Sachdev":(7180, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Manish Jayanta":(7181, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ramesh Jain":(7182, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - The Kashmirian":(7183, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Raahithya Amin":(7184, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Rajesh Naidu":(7185, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Madhavaditya Basu":(7186, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Prem Goel":(7187, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Pallav Jayesh":(7188, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Darsh Babu":(7189, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Lakshmi Purohit":(7190, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Amitabh Yash":(7191, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Chandan Acharya":(7192, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Gilford Bootyswang":(7193, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Raja Narayan":(7194, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Pratik Kavi":(7195, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Sellah Singh":(7196, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Pradeep Narinder":(7197, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Aarav Banerjee":(7198, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Aarna Sharma":(7199, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ravindra Pankaj":(7200, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Arnav Joshi":(7201, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Puran Prailebish":(7202, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Kamal Das":(7203, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Siddharth Arya":(7204, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Lucky Parminder":(7205, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Mitul Ravindra":(7206, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Muhammad Apte":(7207, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Apurva Abhinav":(7208, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Abhay Mallick":(7209, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Sree Saral":(7210, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Tejas Deshpande":(7211, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ajay Dhillon":(7212, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Loftur":(7213, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Anaisha Anand":(7214, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Aadesh Chawla":(7215, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Mukesh Pankaj":(7216, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Myra Singh":(7217, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Arjun Abhinav":(7218, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Aditya Gurmeet":(7219, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Anand Krishna":(7220, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Vasant Suman":(7221, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Mehul Sharma":(7222, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Suman Manoj":(7223, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Karan Kohli":(7224, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Shyam Nilam":(7225, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Daksh Bhatt":(7226, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Neha":(7227, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Navin Dayaram":(7228, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Kamal Ganguly":(7229, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Anika Dixit":(7230, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Harish Kaur":(7231, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Dev Bedi":(7232, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Jaswinder Deepika":(7233, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Anup Chetan":(7234, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Eklavya Chabra":(7235, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Kabir Balakrishnan":(7236, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Saloni Sagar":(7237, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Nishant Saral":(7238, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Viraj Ashok":(7239, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ayush Chadha":(7240, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Harish Anand":(7241, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Rajiv Chauhan":(7242, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Jagan Garg":(7243, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Pallavi Manjeet":(7244, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Vivek Chandan":(7245, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Kabir Lal":(7246, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Kumar Hari":(7247, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Puneet Dileep":(7248, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Rishabh Mannan":(7249, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Aditi Bakshi":(7250, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Anupam Pankaj":(7251, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Raahithya Zacharia":(7252, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Bodhi Kumar":(7253, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Tanvi Mannan":(7254, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ananya Chabra":(7255, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Kiara Batra":(7256, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Venkata Aravinda":(7257, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Govinda Khanna":(7258, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Vinod Malhotra":(7259, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Rishabh Chandra":(7260, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Karthik Deol":(7261, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Kapil Madhur":(7262, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Avinash Nitin":(7263, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Bodhi Amin":(7264, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Arya Apoorva":(7265, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Prasanna Anupam":(7266, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Bishan Mahinder":(7267, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Kamal Datta":(7268, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Raja Narayana":(7269, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Shaurya Iyer":(7270, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Punit Lal":(7271, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Gobind Deo":(7272, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Shiva Kanti":(7273, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Mohan Jain":(7274, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Raahithya Dalal":(7275, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Prasanna Om":(7276, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Trisha Bhasin":(7277, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ninad Singh":(7278, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Raahithya Bajwa":(7279, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Shreya Dhillon":(7280, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Reyansh Amin":(7281, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Mitra Nitin":(7282, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Sarvesh Dileep":(7283, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Geevarghese Mahesh":(7284, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Om Mukherjee":(7285, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Chandan Gill":(7286, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ramesh Mallick":(7287, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Rajesh Varma":(7288, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ramakrishna Mayur":(7289, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Hari Anuj":(7290, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Jai Acharya":(7291, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Atharv Chabra":(7292, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Sarah Datta":(7293, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Devi Deepa":(7294, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Yash Varma":(7295, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Kushal Joshi":(7296, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Karthik Laghari":(7297, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Chandan Apte":(7298, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Nishant Harshal":(7299, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Anika Ahluwalia":(7300, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Sarah Singh":(7301, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Rajiv Dhar":(7302, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Tejas Biswas":(7303, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Hakhon Onjarli":(7304, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Gaurav Varma":(7305, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Rahul Devraj":(7306, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Laxman Kuldeep":(7307, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Balwinder Devadas":(7308, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Abhay Vimal":(7309, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Jai Deshmukh":(7310, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Rachana Kirtida":(7311, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ramesh Rao":(7312, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Pari Lal":(7313, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Muhammad Chadha":(7314, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Aparajita Sameera":(7315, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Arnav Mangal":(7316, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Mohan Mahavir":(7317, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Rishi Ninad":(7318, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Akshay Kapoor":(7319, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Rajender Sanjeev":(7320, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Babu Raav":(7321, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Karthik Bhasin":(7322, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Dev Babu":(7323, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Abdul Chabra":(7324, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Mira Khan":(7325, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Baldev Hardeep":(7326, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Mukul Jaywant":(7327, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ranjit Jayadev":(7328, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Pranay Ajith":(7329, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Dhruv Banerjee":(7330, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Jitendra Navdeep":(7331, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Gopal Vasant":(7332, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Samir Madhav":(7333, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Kishan Dev":(7334, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Lalita Punita":(7335, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Saral Yash":(7336, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Aakash Joshi":(7337, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Satish Jagannath":(7338, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Vivek Saral":(7339, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Bharath Chilamkurthy":(7340, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Angel Parekh":(7341, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Vivaan Dhar":(7342, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Dushyant Anil":(7343, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Rohan Ajith":(7344, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Vimal Sanjay":(7345, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Jagjit Dinesh":(7346, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Bhavin Sagar":(7347, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Rishabh Chowdhury":(7348, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Amarjeet Vimal":(7349, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Apoorva Praileshbadeep":(7350, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Inderjeet Dharma":(7351, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Kiara Das":(7352, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Kishore Rahul":(7353, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Kuldeep Neelam":(7354, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Darsh Grover":(7355, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Sima Kanti":(7356, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Prabhu Jagjit":(7357, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Arjun Chadha":(7358, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ram Jayesh":(7359, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Rohan Bhasin":(7360, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Aarav Mannan":(7361, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Chanda Barigai":(7362, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Preeti Shila":(7363, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Kafe Hudsa":(7364, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Deepak Shah":(7365, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ashok Kartik":(7366, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Gautam Burman":(7367, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Reyansh Mani":(7368, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Adit Chopra":(7369, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Deepak Chowdhury":(7370, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Prem Mehta":(7371, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Balwinder Ravi":(7372, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ayaan Chauhan":(7373, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Aryan Agarwal":(7374, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Nithin Varghese":(7375, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Roshni Amandeep":(7376, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Pranav Ganguly":(7377, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Harsha Laxmi":(7378, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Geevarghese Pratap":(7379, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Hemant Laghari":(7380, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Shyama Drishti":(7381, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Manisha Shailaja":(7382, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Pratyush Naidu":(7383, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Aahana Dayal":(7384, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Anika Kapadia":(7385, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Zayn Agarwal":(7386, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Jayendra Dushyant":(7387, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Bana Kapoor":(7388, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Aditya Balakrishna":(7389, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Aziz Sagar":(7390, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Jaya Pranay":(7391, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Kabir Chauhan":(7392, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Harshal Sukhdeep":(7393, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Balakrishna Kumaran":(7394, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Gautam Prasanna":(7395, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Hari Chopra":(7396, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ashwin Jagdish":(7397, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Rajkumari Nilima":(7398, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Jayadev Nitya":(7399, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Prakash Murali":(7400, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Gurdeep Gokhale":(7401, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Arya Vasu":(7402, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Kaveri Sona":(7403, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Sharma Jitender":(7404, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Amandeep Purohit":(7405, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Olivia Haldar":(7406, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Govind Satish":(7407, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Lakshman Abhilash":(7408, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Rima Shah":(7409, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Dushyant Arjun":(7410, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Rudra Iyer":(7411, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Vaishnavi Dayal":(7412, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Kharisma Haasan":(7413, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Aakash Deol":(7414, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Murali Gautam":(7415, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Kanta Dayaram":(7416, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Prabhat Abhilash":(7417, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ishaan Babu":(7418, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Chand Pandya":(7419, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Basant Sanjay":(7420, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Rudra Basu":(7421, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Dinesh Ray":(7422, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ayush Thakur":(7423, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Zara Purohit":(7424, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Arnav Reddy":(7425, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Anand Vipin":(7426, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ishaan Dixit":(7427, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Nitya Abhilash":(7428, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Navin Rama":(7429, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Pratibha Meena":(7430, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ravinder Samir":(7431, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Jai Bhatt":(7432, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Rakesh Baldev":(7433, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Pranav Varma":(7434, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Madhu Nithin":(7435, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Vivaan Dubey":(7436, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Kumar Chamipur":(7437, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Rohit Chauhan":(7438, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Advik Haldar":(7439, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ayaan Seth":(7440, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Ninad Vimal":(7441, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Hrithik Puri":(7442, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Cujo A. Hora":(7443, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Siddharth Anupam":(7444, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Balwinder Abhishek":(7445, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Lakshman Aravinda":(7446, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Suraj Mahesh":(7447, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Jitendra Jyoti":(7448, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Harsh Bhatt":(7449, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Assistane Personal":(7450, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Yash Mangal":(7451, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Mike":(7452, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Zalim Barigai":(7453, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Samarth Madan":(7454, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Mohinder Nishant":(7455, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Mumbai - Shrinivas Madhur":(7456, ["mumbai"], ["skipped"], ["Level - Mumbai"], [], [], ["Elimination - Mumbai - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Janus":(7457, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Nolan Cassidy":(7458, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Derek Swensen":(7459, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Darell Manzano":(7460, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Samir Chandra":(7461, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Grant Brie":(7462, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Lance Brown Hanson":(7463, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Petra Vue":(7464, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Dewitt Grammer":(7465, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Fabio Buck":(7466, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Jose Alvarez":(7467, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - James Burton":(7468, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Susan Wilson":(7469, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Sam Haines":(7470, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Richard Wilson":(7471, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Jospeh Renda":(7472, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Maryjane Chapple":(7473, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Marty Forest Ducksvalley":(7474, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Valentine Creech":(7475, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Benedict Scheffler":(7476, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Malcolm Hammer":(7477, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Sergio Simonds":(7478, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Robert Hanson":(7479, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Tod Bottoms":(7480, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Amelia Garros":(7481, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Trevor Skinner":(7482, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Jen Bellows":(7483, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Daron Blumberg":(7484, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Lon Monroe":(7485, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Joseph Rickman":(7486, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Stan Rodgers":(7487, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Emmanuel Bruhn":(7488, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Stephen Hampshire":(7489, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Olive Haskel":(7490, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Ramon Schreffler":(7491, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Jerold Fryar":(7492, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Keven Body":(7493, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Gayle Pooley":(7494, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Leopoldo Olmeda":(7495, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Jared Hawkins":(7496, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Dale Anderson":(7497, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Donald Christopher":(7498, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Fredrick Roderick":(7499, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - James Batty":(7500, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Micheal Desilets":(7501, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Bobby Caretaker":(7502, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Donn Cervantez":(7503, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Helen West":(7504, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Haley Mccormick":(7505, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Amanda Brie":(7506, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Quinn Cothran":(7507, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Lissy Arlington":(7508, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Aiden Kelly":(7509, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Lance Gerken":(7510, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Thaddeus Rivero":(7511, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Coleman Keown":(7512, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Jed West":(7513, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Vanda Mcmurry":(7514, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Jae Serio":(7515, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Rudolf Vento":(7516, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Hollis Mack":(7517, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Major Becraft":(7518, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Nelson Lafayette":(7519, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Allyn Roye":(7520, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Theron Wiliams":(7521, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Louis Mogensen":(7522, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Julietta Feliz":(7523, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Joseph Brinson":(7524, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Ann Wilkins":(7525, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Geraldine Fidzgerald":(7526, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Daren Swart":(7527, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Herbert West":(7528, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Julianne Hawthorne":(7529, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Bobby Ashcroft":(7530, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Alicia Laurie":(7531, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Brad Eastman":(7532, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Rosalee Sunderland":(7533, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Alfonso Hernandez":(7534, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Penelope Troutt":(7535, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Jonathon Credle":(7536, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Johnny Frick":(7537, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Gunther Mueller":(7538, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Charlie Hollowell":(7539, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Fermin Delvecchio":(7540, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Sarah Buck":(7541, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Grant Masterson":(7542, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Billy Pidgeon":(7543, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Sebastian Skinner":(7544, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Gabriel Burlison":(7545, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Bernie Valladares":(7546, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Spencer \"The Hammer\" Green":(7547, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Frank Bateson":(7548, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Kennith Hemmer":(7549, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Ramon Drees":(7550, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Alfred Troutt":(7551, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Tiffaney Prout":(7552, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Larry Creed":(7553, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Darrell Senior":(7554, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Barton Rentz":(7555, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Ida Pagel":(7556, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Larry Whiteside":(7557, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Cornell Meier":(7558, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Billy Diemer":(7559, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Charles Blake III":(7560, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Philip Housman":(7561, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Whittleton Creek - Rachel Pichardo":(7562, ["whittleton_creek"], ["skipped"], ["Level - Whittleton Creek"], [], [], ["Elimination - Whittleton Creek - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - The Constant":(7563, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Miguel E. Samuels":(7564, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Zak Briggs":(7565, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Melissa Fleming":(7566, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Malcolm Hughes":(7567, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Greg Clarke":(7568, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Louis Briggs":(7569, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Dylan Day":(7570, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Declan Barton":(7571, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Michelle Price":(7572, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Leon K. Peters":(7573, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Alexander C. Crespin":(7574, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Frederick Engelhorn":(7575, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Henry Lambert":(7576, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Rita Jenkins":(7577, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Michael T. Pendergrass":(7578, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Peter Burton":(7579, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Carson Law":(7580, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Joseph Patterson":(7581, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Bradley Long":(7582, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Robert Thornton":(7583, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Julie R. Draper":(7584, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Zara Lamb":(7585, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Sonja Cohen":(7586, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Shannon Iqbal":(7587, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Paul V. Lumpkin":(7588, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Freya Cameron":(7589, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Katherine Turnbull":(7590, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - James V. Nelson":(7591, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Andre P. McClain":(7592, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Richard K. Basham":(7593, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Kirsty Calhoun":(7594, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Austin Brady":(7595, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Jennifer Holden":(7596, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Maisie Henderson":(7597, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Bryan Smith":(7598, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Samuel Slater":(7599, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Ezra Witt":(7600, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Elizabeth Hewitt":(7601, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Tyler Hewitt":(7602, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Thomas C. Howard":(7603, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - David Taylor":(7604, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Kelvin M. Smith":(7605, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Zoe Robinson":(7606, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Richard C. Eisenberg":(7607, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Morgan Walker":(7608, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Joshua Allen":(7609, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Elisabeth D. Copeland":(7610, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Jonathan Gardiner":(7611, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Kai O'Sullivan":(7612, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - William Hartman":(7613, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Larry T. Nicholas":(7614, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Ella Coleman":(7615, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Harry E. Witherspoon":(7616, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Kevin G. Bohman":(7617, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Chelsea Webster":(7618, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Dennis Bertrand":(7619, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Henry Goodwin":(7620, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Lilly Murray":(7621, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Charles Burns":(7622, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - William H. Garrett":(7623, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Reece Bryant":(7624, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Gerald D. Hahn":(7625, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Eugene Watson":(7626, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Robert Francis":(7627, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Bernadette Craig":(7628, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Ben McKenzie":(7629, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Tony J. Watkins":(7630, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - William Clayton":(7631, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Andrew Randall":(7632, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Joseph E. Padilla":(7633, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Noah A. Oneil":(7634, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Joseph Scott":(7635, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Judy T. Houchins":(7636, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Elizabeth M. Newman":(7637, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Robert A. Nelson":(7638, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Eve Hudson":(7639, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Tim Coleman":(7640, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Lucas Hutchinson":(7641, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Connor Wade":(7642, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Douglas Cain":(7643, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Edward Field":(7644, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Corey McLean":(7645, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Danny Rice":(7646, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Mason Hill":(7647, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Toby Whittaker":(7648, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Marcus Schultz":(7649, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Robert Y. Rivet":(7650, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Lucas Bartlett":(7651, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Catherine \"Kiki\" Zola":(7652, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - James F. Fuentes":(7653, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Terri R. Minor":(7654, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Jeffery D. Alban":(7655, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Ruth Miller":(7656, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Sean Lopez":(7657, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - John Lowe":(7658, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Woodrow Keller":(7659, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Ellis Howe":(7660, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Curtis Y. Driscoll":(7661, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Ronald D. Morales":(7662, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Michael E. Hoyos":(7663, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Marco C. Norton":(7664, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Chelsea Mellor":(7665, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Freya Hancock":(7666, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Jack C. Flemings":(7667, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - John A. Walker":(7668, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Aaron Nelson":(7669, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Sonya R. Briggs":(7670, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Harry F. Moss":(7671, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Greg S. Tweed":(7672, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Darrell E. Granger":(7673, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Gabriel Bartlett":(7674, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Cornelia Stuyvesant":(7675, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Shane R. Myers":(7676, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Louis Cooke":(7677, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Ronny Thao":(7678, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Aaron Barlow":(7679, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Scott Dixon":(7680, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Macey Taylor":(7681, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Katharine Hampton":(7682, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Robert N. Randle":(7683, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Isaac Talbot":(7684, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Ethan Saunders":(7685, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Sebastian Ellis":(7686, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Royce R. White":(7687, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Isabelle Norris":(7688, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Joshua Ross":(7689, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Katherine Spencer":(7690, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Jennifer Murray":(7691, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Thaddeus Hartwell":(7692, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Sonja J. Cevallos":(7693, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Burt Gilbert":(7694, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Damian Moral":(7695, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Jayden Lowe":(7696, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Alisha Noble":(7697, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Rachel Ferguson":(7698, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Abby Faulkner":(7699, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Melissa Slater":(7700, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Brian D. Lagunas":(7701, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Troy S. Anderson":(7702, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Evan Holden":(7703, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Josh Brady":(7704, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Carl D. Morales":(7705, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Douglas C. Leavitt":(7706, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Logan Archer":(7707, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Frankie Matthews":(7708, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Ryan I. Pires":(7709, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Jorge M. Johnson":(7710, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Maya Newman":(7711, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - James R. Hayes":(7712, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Samuel Pope":(7713, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Richard H. Anderson":(7714, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Alfie Collins":(7715, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Finley Henry":(7716, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Muriel Mortensen":(7717, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Miguel D. Cornette":(7718, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Christy Welch":(7719, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Leon Townsend":(7720, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Charlie Parsons":(7721, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Millie Howell":(7722, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Grace Simmons":(7723, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Michael L. Brandon":(7724, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Josh Shepherd":(7725, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Allen A. Brown":(7726, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Blake I. Marsh":(7727, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Bryant A. Henderson":(7728, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Anthony C. Bowman":(7729, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Kevin Lowe":(7730, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Harold K. Sizemore":(7731, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Benny Guzman":(7732, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Barbara W. Nichols":(7733, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - John S. Shelby":(7734, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Dylan Parkin":(7735, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Floyd D. Mowry":(7736, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Michael C. Tardiff":(7737, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Douglas E. Carlisle":(7738, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Ava Christensen":(7739, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Michael Robson":(7740, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Dan Burton":(7741, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Owen Kim":(7742, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Jay Evans":(7743, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Benny Johnson":(7744, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Rick Knight":(7745, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Roman Zelenko":(7746, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Elsie J. Peterson":(7747, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Carlos Green":(7748, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Todd Nelson":(7749, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Ryan King":(7750, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - James J. Edwards":(7751, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Jasmine Roberts":(7752, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Daryll Rhodes":(7753, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Melissa Wilkins":(7754, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Marek Sinclair":(7755, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Glen B. Rouillard":(7756, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Nicholas Holden":(7757, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Stewart J. Weston":(7758, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Harold A. Medina":(7759, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Clyde E. Rafter":(7760, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Lilly Buckley":(7761, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Phoebe Jarvis":(7762, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Hung Boss":(7763, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Steven Bryant":(7764, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Lance Reid":(7765, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Bradley Hicks":(7766, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Sean S. Wilder":(7767, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Ewan Pearson":(7768, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Toby Fletcher":(7769, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Samantha Law":(7770, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Cory M. Watterson":(7771, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Ian J. Carpino":(7772, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Isabelle Mitchell":(7773, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Sophia Washington":(7774, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - William K. Ater":(7775, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Sean Wilkinson":(7776, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Keira Smith":(7777, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Paul Munroe":(7778, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Jasmine George":(7779, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Samuel Butcher":(7780, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Kaiden Lara":(7781, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Marion C. Rain":(7782, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Jade Atkins":(7783, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Harrison Watts":(7784, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Logan Parkinson":(7785, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Logan Cunningham":(7786, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Lee Lawson":(7787, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Martin Hunt":(7788, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Scott Long":(7789, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Kai Flynn":(7790, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Harrison Waters":(7791, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Allen M. Gonzalez":(7792, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Sara Gregory":(7793, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Thomas Garner":(7794, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Brad Phelps":(7795, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Drew M. Neff":(7796, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Steven M. Milbourn":(7797, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Vincent P. Wilkins":(7798, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Raoul Silva":(7799, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Bailey Long":(7800, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Aaron Osborne":(7801, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Bernard Lindsey":(7802, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Eleanor Jennings":(7803, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Billy Taylor":(7804, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Todd C. Cook":(7805, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Adrian Salazar":(7806, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Louis Bryant":(7807, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - David Bradley":(7808, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Charles Norton":(7809, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Michael G. Johnson":(7810, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Joseph D. Collins":(7811, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - David P. Bryan":(7812, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Tommy C. Perna":(7813, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Murray L. Haas":(7814, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - William J. Ferguson":(7815, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Joe Potts":(7816, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Cedric E. Towns":(7817, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Demi Herbert":(7818, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Jimmy Reed":(7819, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Andre I. Cruz":(7820, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Natasha Cooke":(7821, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Tyson M. Billings":(7822, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Angela M. Dixon":(7823, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Jemima McLeod":(7824, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Dominic Stephenson":(7825, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Morgan Thornton":(7826, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Melissa Arnold":(7827, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - David Spencer":(7828, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Axel Phenniger":(7829, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Kenneth Griffin":(7830, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Robert S. Gilson":(7831, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Corey Potter":(7832, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - William H. Gallo":(7833, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Leo Rice":(7834, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Glen Thomas":(7835, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Louis Tyler":(7836, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Blake Nathaniel":(7837, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - James Dawson":(7838, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Sam Walker":(7839, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Ryan Hunter":(7840, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Desmond L. Curry":(7841, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Zoe Washington":(7842, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Evie Pope":(7843, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Charles L. Lundgren":(7844, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Mason Lambert":(7845, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Ava Morgan":(7846, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Conrad Nunez":(7847, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Larry Rogers":(7848, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Stanley B. Muff":(7849, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Poppy Douglas":(7850, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Joshua S. Bernier":(7851, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Donny Huong":(7852, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Philip La Verne":(7853, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Benjamin M. Beck":(7854, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Kian Tyler":(7855, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - John Doe":(7856, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Ken Porter":(7857, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Liam Lloyd":(7858, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Anthony S. Peoples":(7859, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Ben Foster":(7860, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Mark Brown":(7861, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Tyler Burke":(7862, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Dan Morales":(7863, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Godfrey Hagen":(7864, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Jason Harris":(7865, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Logan Begum":(7866, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Albert Cummings":(7867, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Derrick C. Hughes":(7868, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Jake Horton":(7869, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - George Barnes":(7870, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Adam Hobbs":(7871, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Jebediah Block":(7872, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Charles L. Vega":(7873, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Robert D. Lewis":(7874, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Richard V. Sam":(7875, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Joel Parry":(7876, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Lysander Rothchester":(7877, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Tyrell T. Wells":(7878, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Charlie Grant":(7879, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Harvey Wood":(7880, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Jason Portman":(7881, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Georgina LaGrande":(7882, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Travis V. Velez":(7883, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Roland Hart":(7884, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Alexander Faulkner":(7885, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Joseph A. Moore":(7886, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Thomas R. Vasques":(7887, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Randy Chapman":(7888, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Bradley Winter":(7889, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Orville S. Hernandez":(7890, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Constantin":(7891, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Louis Richardson":(7892, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Maya Grant":(7893, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Karen G. Jackson":(7894, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Guillermo A. Smith":(7895, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Billy Hayward":(7896, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Demi Allen":(7897, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Kurt Grayson":(7898, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - James D. Laster":(7899, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Shawn Parker":(7900, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Donald H. Gerling":(7901, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Jerry A. Meyers":(7902, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Mac S. Dudley":(7903, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Randall G. Olguin":(7904, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Finlay Chambers":(7905, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Larry D. Jackson":(7906, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - David M. Melendez":(7907, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Emily Patel":(7908, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Timothy T. Lopez":(7909, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Richard Y. Schiffer":(7910, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Steven L. McGeorge":(7911, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Gregorio W. Wooley":(7912, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Earl Cox":(7913, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Arthur Evans":(7914, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Kara Soto":(7915, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Archie Ryan":(7916, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Amos Dexter":(7917, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - David A. Hood":(7918, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Bobby R. Arias":(7919, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Adam Middleton":(7920, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - William S. West":(7921, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Rebecca Hale":(7922, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Cedrick B. Clark":(7923, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Maggie Cook":(7924, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - James A. Sardina":(7925, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Charles K. Mays":(7926, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - Isle of Sgail - Amelie Bolton":(7927, ["isle_of_sgail"], ["skipped"], ["Level - Isle of Sgail"], [], [], ["Elimination - Isle of Sgail - Any","Elimination - Any"]),
    "Elimination - New York - Athena Savalas":(7928, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Nicole Samson":(7929, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Oswald Sydney":(7930, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Ray Poyner":(7931, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Gidget Jone":(7932, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Scot Baratta":(7933, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Juli Artis":(7934, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Madelyn Leonard":(7935, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Linwood Klass":(7936, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Benjamin Hunsicker":(7937, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Milton Laprade":(7938, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Frank Winkelman":(7939, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Lacresha Meier":(7940, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Dudley Claypool":(7941, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Billie Crouch":(7942, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Danyell Muir":(7943, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Patric Nilsen":(7944, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Roy":(7945, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Les Clabaugh":(7946, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Heidy Nilson":(7947, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Wendell Poss":(7948, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Elissa Willis":(7949, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Denzil Keyes":(7950, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Winford Woodson":(7951, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Inger Hopes":(7952, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Kelley Lightle":(7953, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Ronald Orona":(7954, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Winford Mattison":(7955, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Sylvester Cartier":(7956, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Elvis Pullen":(7957, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Ramiro Raposa":(7958, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Allan Mitsuhide":(7959, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Kevin Nardone":(7960, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Josiah Cole":(7961, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Sita Morris":(7962, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Jamee Falgout":(7963, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Travers Nye":(7964, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Earle Cutlip":(7965, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Marty Allmon":(7966, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Elvis Lankford":(7967, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Laree Parrish":(7968, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Sugar Squirrel":(7969, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Curt Reinhardt":(7970, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Jayson Lefler":(7971, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Jonathan Hutchinson":(7972, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Edgar Scudder":(7973, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Mateo Pérez":(7974, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Selby Judd":(7975, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Leonardo Scanlon":(7976, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Jimmie Gladwin":(7977, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Bradford Nader":(7978, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Karen Farrow":(7979, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Angelo Gillispie":(7980, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Vicky Barger":(7981, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Lewis Thomas":(7982, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Darius Ocampo":(7983, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Doreen Ambrose":(7984, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Alaina Napoleon":(7985, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Joss":(7986, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Jeanna Preston":(7987, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Erna Seamans":(7988, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Melissa Chien":(7989, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Mahala Hendry":(7990, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Tory Litchfield":(7991, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Murray Sprayberry":(7992, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Jesusita Highsmith":(7993, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Matt Platt":(7994, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Jenni Hailey":(7995, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Wayne Bronson":(7996, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Bertram Tellez":(7997, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Carlee Talpur":(7998, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Lisa Bird":(7999, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Pasty Monaghan":(8000, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Florene Cheung":(8001, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Gregg Cook":(8002, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Yasmine Khatri":(8003, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Cornelius Bak":(8004, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Nguyet Tisdale":(8005, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Chester Nuckols":(8006, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Cathrine Kenyon":(8007, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Hadyn Holme":(8008, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Gayle Wenger":(8009, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Jeana Decarlo":(8010, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Julianne Cason":(8011, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Claud Schwan":(8012, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Trenton Heier":(8013, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Nathanial Bravo":(8014, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Ruben Fergerson":(8015, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Raymond Bissett":(8016, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Nilsa Weatherby":(8017, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Foster Liner":(8018, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Ruby Red":(8019, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Ezequiel Grogan":(8020, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Sebastian Mattson":(8021, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Vicenta Bryan":(8022, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Gourd":(8023, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Jay Huntley":(8024, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Tim Weimer":(8025, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Kaye Zahn":(8026, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Madeleine Beliveau":(8027, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Tanner Godley":(8028, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Aldo Tennison":(8029, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Harley Vanetten":(8030, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Brenton Hawk":(8031, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Kennith Guse":(8032, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Sean Greenlee":(8033, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Enoch Holly":(8034, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Rosendo Hedlund":(8035, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Antony Doty":(8036, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Sherwood Borchert":(8037, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Nicky Fergus":(8038, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Rolf Hoehn":(8039, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Fabian Mann":(8040, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Virgil Spells":(8041, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Leana Huie":(8042, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Arron Baxley":(8043, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Ashley Berndt":(8044, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Abbey Simcox":(8045, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Jonas Plaisance":(8046, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Allan Maulwurf Kristensen":(8047, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Kiran Panwar":(8048, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Charles Davenport":(8049, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Nicky Pavone":(8050, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Shana Christison":(8051, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Freeman Luoma":(8052, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Reid Robson":(8053, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Anita Williams":(8054, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Dortha Warthen":(8055, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Maxene Chancellor":(8056, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Ralph Eagan":(8057, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Joni Bateson":(8058, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Josue Federico":(8059, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Charles Lang":(8060, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Harvey Brennan":(8061, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Logan Jackson":(8062, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Thanh Dillman":(8063, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Davis Stamper":(8064, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - New York - Felipe Suniga":(8065, ["new_york"], ["skipped"], ["Level - New York"], [], [], ["Elimination - New York - Any","Elimination - Any"]),
    "Elimination - Haven Island - Ljudmila Vetrova":(8066, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Steven Bradley":(8067, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Tyson Williams":(8068, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Carrie Long":(8069, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Akshay Babu":(8070, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - William Patterson":(8071, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Rick O´neil":(8072, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Maria Ramirez":(8073, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Akshay Ratti":(8074, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Lochan Bhandari":(8075, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Loretta Thompson":(8076, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Larry Cox":(8077, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Sara Edwards":(8078, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Aryan Salvi":(8079, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Camille Lawson":(8080, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Malcolm Roberts":(8081, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Alexis White":(8082, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Magdalene Sherman":(8083, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Clark Foster":(8084, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Frank Sanders":(8085, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Arjuna Adhya":(8086, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Sip Nam-Sun":(8087, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Chanthavong Chantrea":(8088, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Scott Mitchell":(8089, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Narendra Nigam":(8090, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Leah Cooper":(8091, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Tenho Valkama":(8092, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Dr. Singh":(8093, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Dorris Miller":(8094, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Rufus Tillerman":(8095, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Kaye Zahn":(8096, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Aruna Narain":(8097, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Diego de la Torres":(8098, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Charles Kraemer":(8099, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Alonzo Landeros":(8100, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Daniel Keen":(8101, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Cai Yang":(8102, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Simonetta Alfredi":(8103, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Surya Dada":(8104, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Chad Yongrui":(8105, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Zach Cheng":(8106, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Cinzia Frattaglia":(8107, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Louis Freeman":(8108, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Mike Thompson":(8109, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Aakash Prabhu":(8110, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Ajit Bakshi":(8111, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Preston Coleman":(8112, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Daisy Kuruvilla":(8113, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Jaelyn Deluna":(8114, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Mirtilla Mood":(8115, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Jonathan Marquis":(8116, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Orson Williams":(8117, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Grace Sanders":(8118, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Dhriti Gala":(8119, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Prasad Ratti":(8120, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Luo Shoushan":(8121, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Rose Xiaoling":(8122, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Asha Patil":(8123, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Selina Martinez":(8124, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Brad Walker":(8125, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Suman Dalal":(8126, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Om Edwin":(8127, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Naomi Oliveira":(8128, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Mamta Prabhu":(8129, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Carl Lewis":(8130, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Sun Xiaoli":(8131, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Benson Wilder":(8132, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Chee Mi":(8133, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Howard Garcia":(8134, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Rakesh Dyal":(8135, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Paula Hansen":(8136, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Dong Fen":(8137, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Conrad Agozzino":(8138, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Dean Pettington":(8139, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Samir Mander":(8140, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Pranav Rastogi":(8141, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Ramza el-Dia":(8142, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Nick Thorn":(8143, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Ashley Montague":(8144, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Shresth Mammen":(8145, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Aravind Goswami":(8146, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Melanie Green":(8147, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Tom Evans":(8148, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Maxwell Rutter":(8149, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Adnan Sule":(8150, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Trey Palmer":(8151, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Bob Schwab":(8152, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Chef Rampart":(8153, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Shantanu Batra":(8154, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Raafida al-Salem":(8155, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Kevin Hawkins":(8156, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Spencer Hughes":(8157, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Mike Osmond":(8158, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Cooper Gilliam":(8159, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Sally Qing":(8160, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Bharat Kurian":(8161, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Michael Collins":(8162, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Daniele \"Chaos Agent\" Carco":(8163, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Daas Bakshi":(8164, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Brent Upton":(8165, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Letitia Campbell":(8166, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Henna Chacko":(8167, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Christie Howards":(8168, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Mario Giovine":(8169, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Shao Luli":(8170, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Rodney Hemovich":(8171, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Jim Murphy":(8172, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Captain Rutherford":(8173, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Alexander Balakrishnan":(8174, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Laura Nayak":(8175, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Eric Waltz":(8176, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Jack Gable":(8177, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Alonso Herva":(8178, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Michelle Hayes":(8179, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Luke Gilmore":(8180, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Carlos Finch":(8181, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Steve Morgan":(8182, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Saral Saini":(8183, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Vince Keer":(8184, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Jordan \"Jack 9mm\" Cucci":(8185, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Sofia Bedi":(8186, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Christopher Johnson":(8187, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Asmar el-Raad":(8188, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Justin Lee":(8189, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Pramod Munshi":(8190, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Tim Johnson":(8191, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Ahmed Montero":(8192, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - James Firth":(8193, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Pierre Larcher":(8194, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Mathew Parker":(8195, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Zoé Caravella ":(8196, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Adam Crest":(8197, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Tushar Ramachandran":(8198, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Parvati Banerjee":(8199, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Evan Hines":(8200, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Sai Parekh":(8201, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Harsh Ganesh":(8202, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Nick Swanson":(8203, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Richardo Flores":(8204, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Susan Langley":(8205, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Bana Malhotra":(8206, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Vihaan Kohli":(8207, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Rajani Dhawan":(8208, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Murali Krishnan":(8209, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Lance Xiu":(8210, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Jesse Lawhead":(8211, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Xiang Guozhi":(8212, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Jakson Mamao":(8213, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Pablo Garcia":(8214, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Brian Settler":(8215, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Jason Portman":(8216, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Benjamin Lewis":(8217, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Zeng Shen":(8218, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Nirmal Mukhopadhyay":(8219, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Lian An":(8220, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Xiao Dongmei":(8221, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Manish Basak":(8222, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Dexter Hooper":(8223, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Maggie Fan":(8224, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Chris Hawkins":(8225, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Helinä Pirinen":(8226, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Jacqueline Wealthy":(8227, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Sophie Liang":(8228, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Bethany Fiedler":(8229, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Garret Graham":(8230, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Cindy McEnroe ":(8231, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Anah Bajaj":(8232, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Hilde Sorbetto":(8233, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Gao Xiaodan":(8234, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Chuck Wright":(8235, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Radha Dewan":(8236, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Indra Konda":(8237, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Prem Sidhu":(8238, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Corben Dillas":(8239, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Harrold Miller":(8240, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Lesley Salazar":(8241, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Chris Dallas":(8242, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Priya Mathews":(8243, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Vishnu De":(8244, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Liam Young":(8245, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Dylan Taylor":(8246, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Mayur Kapur":(8247, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Aarush Lal":(8248, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Lochan Chokshi":(8249, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - David Green":(8250, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Greg Scottsdale":(8251, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Alma Page":(8252, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Kavi Bhattacharyya":(8253, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Donny Jeffords":(8254, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Aasima al-Galla":(8255, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Rita Whitehaven":(8256, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Indira Tandon":(8257, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Larry Bid":(8258, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Hank Smith":(8259, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Fred Filmstone":(8260, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Kalvin Hall":(8261, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Jason Randhawa":(8262, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Ben \"Urben\" Urbach":(8263, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Melanie Port":(8264, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Logan Rye":(8265, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Rami Carter":(8266, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Carlos Huntley":(8267, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Jason Brennan":(8268, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Mitch Nocannon":(8269, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Tommy Dixon":(8270, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Leslie Gengrich":(8271, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Dennis Singer":(8272, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Andrew Goulden":(8273, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Edward Campbell":(8274, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Lance Bennet":(8275, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Stefania Bella":(8276, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Rachele Santiago":(8277, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Carl Peterson":(8278, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Haven Island - Jane Silver":(8279, ["haven_island"], ["skipped"], ["Level - Haven Island"], [], [], ["Elimination - Haven Island - Any","Elimination - Any"]),
    "Elimination - Dubai - Carl Ingram":(8280, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Marcus Stuyvesant":(8281, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Petula Killam":(8282, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Ateefah Imran":(8283, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Nazeer Hoda":(8284, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Zana \"The Vulture\" Kazemi":(8285, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Sayyed Khatib":(8286, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Usama Parsa":(8287, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Aroos Shah":(8288, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Padma Bassi":(8289, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Mary Dickson":(8290, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Chaman Goda":(8291, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Shaaf Abdul":(8292, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Opal Hayley":(8293, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Taqqee Koroma":(8294, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Khaatim Ali":(8295, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Henry Seymour":(8296, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Janak Ramroop":(8297, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Henry Nigel":(8298, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Shaima Din":(8299, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Janna Wyght":(8300, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Niraj Narasimhan":(8301, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Nabila Agha":(8302, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Nazeer Zahra":(8303, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Richard Chace":(8304, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Waseem Bey":(8305, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Nabeel Saber":(8306, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Mukarram Fayad":(8307, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Trent Holmes":(8308, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Hans Lucht":(8309, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Namimah Wahba":(8310, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Muayid Sofran":(8311, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Siddeeq Farman":(8312, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Harrison Cassel":(8313, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Mary Derricks":(8314, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Afaaf Zaman":(8315, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Tommy Marevick":(8316, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Garret Harrelson":(8317, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Usama Tahir":(8318, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Aslam Younan":(8319, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Asad Raad":(8320, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Munira Saba":(8321, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Niraj Gara":(8322, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Shaidaa Bangura":(8323, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Akshay Iyer":(8324, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Ian Readdie":(8325, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Pearl Sydney":(8326, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Dina Conner":(8327, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Alice Clark":(8328, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Jawwaad Rahmani":(8329, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Sarmila Bhatt":(8330, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - In'aam Mahdavi":(8331, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Miranda Morrison":(8332, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Husain Akel":(8333, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Linsey Furtado":(8334, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Nadira Kaiser":(8335, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Irfaan Zamani":(8336, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Zaheer Pasha":(8337, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Ismat Hassen":(8338, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Sameer Sani":(8339, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Mariam Amir":(8340, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Qaasim Saah":(8341, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Lucy Phillips":(8342, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Mukarram Sabir":(8343, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Sandie Doughty":(8344, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Dharam Dass":(8345, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Ritesh Kunda":(8346, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Ahmed Dada":(8347, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Zanna Milton":(8348, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Lalit Mandal":(8349, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Malashree Bora":(8350, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Asidhan Din":(8351, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Lisa Thorn":(8352, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Naadim Yacoub":(8353, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Jenette Craig":(8354, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Maya Shepard":(8355, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Aslam Wahba":(8356, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Fanny Wyght":(8357, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Joshua Jack":(8358, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Tereasa Salas":(8359, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Umar Latif":(8360, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Akbar Fayad":(8361, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Richard Voltaire":(8362, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Roy Albert":(8363, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Misbaah Asad":(8364, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Athar Farhat":(8365, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Delora Nichol":(8366, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Sebastian Sato":(8367, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Luther Amir":(8368, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Santosh Dixit":(8369, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Hanako Kato":(8370, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Aabid Din":(8371, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Mushtaaq Shaer":(8372, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Naasir Yusuf":(8373, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Muhsin Srour":(8374, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Jameel Mitri":(8375, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Bashaarat Farah":(8376, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Khalid Salim":(8377, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Naadim Mohammadi":(8378, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Keiji Kono":(8379, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Margaret Banks":(8380, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Donna Parris":(8381, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Udaya Thaker":(8382, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Zaheer Sadiq":(8383, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Jaswant Khare":(8384, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Mostafa Anserini":(8385, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Lata Acharya":(8386, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Amber Thwaite":(8387, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Parvati Sheth":(8388, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Henrietta Hussain":(8389, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Azeem Khalili":(8390, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Mas'ood Abad":(8391, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Rafeeq Sawaya":(8392, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Bernard Salek":(8393, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Foolwati Pal":(8394, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Susanna Gorsuch":(8395, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Iman Allee":(8396, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Yaseera Muhammad":(8397, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Malika Imam":(8398, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Neeraj Rana":(8399, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Mubashshir Shehata":(8400, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Annabelle Harrison":(8401, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Zaahid Akel":(8402, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Irshaad Karam":(8403, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Rocco Levitt":(8404, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Imtiaaz Mohammadi":(8405, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Joel Whyte":(8406, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Devmani Sangha":(8407, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Aabid Moussa":(8408, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Lars Blocker":(8409, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Vincent Dickson":(8410, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Kamilah Samaan":(8411, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Sneha Banerjee":(8412, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Roberto Franculitta":(8413, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Nada Amara":(8414, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Mobeen Dar":(8415, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Lauren Kidd":(8416, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Theresa Young":(8417, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Rahul Sahni":(8418, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Lucy Waller":(8419, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Ricky Macon":(8420, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Sameer Ghazi":(8421, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Tsuyoshi Ogawa":(8422, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Govind Malhotra":(8423, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Oscar Malm":(8424, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Cindy Burns":(8425, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Karthik Kulkarni":(8426, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Hasan Baig":(8427, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Kin Ishida":(8428, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Kalyan Kar":(8429, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Jade Rennell":(8430, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Julia Roberge":(8431, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Siraaj Begum":(8432, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Qaasim Karim":(8433, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Omar Al-Ghazali":(8434, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Ameer Younan":(8435, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Mubashshir Mohamed":(8436, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Aadil Sabir":(8437, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Karida Sabir":(8438, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Mahmood Salman":(8439, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Ma'shooq Mattar":(8440, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Hajir Salaam":(8441, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Jamilah Hasen":(8442, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Shaaf Hossain":(8443, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Yogendra Nayak":(8444, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Noel Swanner":(8445, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Yoshi Morita":(8446, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Ayako Jouda":(8447, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - John Rahmani":(8448, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Rickie Shuffler":(8449, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Cornelia Stuyvesant":(8450, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Sandy Jernigan":(8451, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Ajmal Ishak":(8452, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Akira Suzuki":(8453, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Altaaf Karim":(8454, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Nabeel Eid":(8455, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Antonio Marreghereti":(8456, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Buffy Loesch":(8457, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Aaqib Salek":(8458, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Shameem Demian":(8459, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Saabir Javid":(8460, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Kelly To":(8461, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Alan Haley":(8462, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Phoebe Whyte":(8463, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Asad Imam":(8464, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Basant Pai":(8465, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Lamont Blackwood":(8466, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Bilaal Amen":(8467, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Michael Majumdar":(8468, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Carl Thorn":(8469, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Nimah Jamil":(8470, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Irshaad Turay":(8471, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Naoko Sakamoto":(8472, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Prem Mitra":(8473, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Mukarram Soltani":(8474, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Trina Royce":(8475, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Zaakir Hana":(8476, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Mantana Mir":(8477, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Aazaad Aziz":(8478, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Asgar Jama":(8479, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Faisal Muhammad":(8480, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Michael Tolman":(8481, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Elton Hambledon":(8482, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Mobeen Kamal":(8483, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Prudence Ramsey":(8484, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Khaleel Akhter":(8485, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Zafar Shabazz":(8486, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Ameer Sahli":(8487, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Amaan Kassem":(8488, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Habeeb Hannan":(8489, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dubai - Akbar Salam":(8490, ["dubai"], ["skipped"], ["Level - Dubai"], [], [], ["Elimination - Dubai - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Alexa Carlisle":(8491, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Mr. Fernsby":(8492, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Layla Carr":(8493, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Ellen Moss":(8494, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Oscar Walsh":(8495, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Ruben Doyle":(8496, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Jamie Harper":(8497, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Elliot Knight":(8498, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Annabel Jones":(8499, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Spencer West":(8500, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Edith Foster":(8501, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Josh Barker":(8502, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Felix Adams":(8503, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Oliver Dickens":(8504, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Rebecca Carlisle":(8505, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Toby Roberts":(8506, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Jay Harris":(8507, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Daniel Fraser":(8508, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Lawrence Hunt":(8509, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Leonard Parsons":(8510, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Noel Stewart":(8511, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Lucian Barker":(8512, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Flynn Sharp":(8513, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Joseph Miller":(8514, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Henry Williams":(8515, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Layton Gill":(8516, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Patrick Carlisle":(8517, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Lenny West":(8518, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Richard Bell":(8519, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Joel Taylor":(8520, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Alice Rogers":(8521, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Robert Clarke":(8522, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Edward Carlisle":(8523, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Jordan Webb":(8524, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Samuel Simpson":(8525, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Aron Black":(8526, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Elliott Hudson":(8527, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Phinas Whitmer":(8528, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Layton Rose":(8529, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Christopher Phillips":(8530, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Harvey Wright":(8531, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Halle Davidson":(8532, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Seth Marshall":(8533, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Harvey Wells":(8534, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Rae Fisher":(8535, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Greyson Mason":(8536, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Sarah Turner":(8537, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Brodie Clarke":(8538, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Layton Chapman":(8539, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Cillian Russell":(8540, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Annie Holland":(8541, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Adrian Lloyd":(8542, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Ethel White":(8543, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Noel Rose":(8544, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - James Clarke":(8545, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Otto Lee":(8546, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Theo Willis":(8547, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Ray Gibson":(8548, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Dante Woods":(8549, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Paul Carter":(8550, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Eddie Jones":(8551, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Blake Holland":(8552, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Hector Armstrong":(8553, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Matilda Allen":(8554, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Albert Hill":(8555, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Lincoln Berry":(8556, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Emma Carlisle":(8557, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Amelia Reid":(8558, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Ben Moore":(8559, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Ray Wright":(8560, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Sophie Byrne":(8561, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Jude Graham":(8562, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Alfred Houghton":(8563, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Luke Griffiths":(8564, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Magnus Clark":(8565, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Isaac Hunter":(8566, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Vincent Brown":(8567, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Francis Riley":(8568, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Mary Moore":(8569, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Alex Robinson":(8570, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Fabian Reid":(8571, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Gregory Carlisle":(8572, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Elena Black":(8573, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Elaine Sutton":(8574, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Frank Evans":(8575, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Logan Richards":(8576, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Jake Watts":(8577, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Diego Bennett":(8578, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Aron Ford Jr":(8579, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Samuel Taylor":(8580, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Rosie Jones":(8581, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Toby Rees":(8582, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Maxwell Rees":(8583, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Helena West":(8584, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Olly Marshall":(8585, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Sean Collins":(8586, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Betsy Williams":(8587, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Spencer Hunter":(8588, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Daniel Brooks":(8589, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Otto Burns":(8590, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Isaac King":(8591, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Ben Stone":(8592, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Ralph Burke":(8593, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Sean Reynolds":(8594, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Travis Adams":(8595, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Cathrine Burns":(8596, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Jane Moss":(8597, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Brandon Ryan":(8598, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Oliver Hill":(8599, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Berlin - Agent Montgomery":(8600, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Agent Swan":(8601, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Agent Davenport":(8602, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Agent Green":(8603, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Agent Thames":(8604, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Agent Banner":(8605, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Agent Rhodes":(8606, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Agent Tremaine":(8607, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Agent Lowenthal":(8608, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Agent Chamberlin":(8609, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Lorenz Specht":(8610, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Ursula Holtz":(8611, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Hugo Pletcher":(8612, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Elias Bachman":(8613, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Katarina Glass":(8614, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Diederik van der heijden":(8615, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Hanna Gerhard":(8616, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Herbert Gottschalk":(8617, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Didde Gärtner":(8618, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Emanuel Knepp":(8619, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Ekkehard Siekert":(8620, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Timo Hoover":(8621, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Theresia Rose":(8622, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Zoe Buckholtz":(8623, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Ludwig Leer":(8624, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Ernst Lorentz":(8625, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Rudolf Sorge":(8626, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Helmut Scholz":(8627, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Julia Mendel":(8628, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Teresa Schwarz":(8629, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Adam Friedhelm":(8630, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Viktor Hofmann":(8631, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Bruno Hofer":(8632, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Edgar Martin":(8633, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Saskia Schlosser":(8634, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Tatiana Mayer":(8635, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Xiulan Guo":(8636, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Jannik Szwaczka":(8637, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Saskia Färber":(8638, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Marco Breiner":(8639, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Kristiane Horn":(8640, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Oswald Plank":(8641, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Maja Sauer":(8642, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Boris Schröter":(8643, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Wolfram Gwerder":(8644, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Hendrik Post":(8645, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Moritz Fürst":(8646, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Klemens Diefenbach":(8647, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Conrad Berg":(8648, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Jessika Fleischer":(8649, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Louise Voll":(8650, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Dietlinde Pabst":(8651, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Alban Jäger":(8652, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Lasse Danegod":(8653, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Sievert Hartmann":(8654, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Gabriele Berger":(8655, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Ottmar Braband":(8656, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - David Vogts":(8657, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Reinhold Schultze":(8658, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Manfred Messmann":(8659, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - David Merkel":(8660, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Karl Friedemann":(8661, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Lea Schultze":(8662, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Edelgard Winter":(8663, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Svenja Mueller":(8664, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Raffael Gaertner":(8665, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Julius de Koning":(8666, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Sigmund Rose":(8667, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Gerald Gotti":(8668, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Gustav Reuter":(8669, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Siegmund Bach":(8670, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Horst Simmon":(8671, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Brigitte Baumbach":(8672, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Michael Kauffmann":(8673, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Malte Bennewitz":(8674, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Volker Würtz":(8675, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Alexander Boesch":(8676, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Natalia Heinrich":(8677, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Hendrik Trumbauer":(8678, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Daniel Fleischer":(8679, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Eckart Küchler":(8680, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Heino Oliver":(8681, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Immanuel Kohler":(8682, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Doris Schultheiss":(8683, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Karim Jirason":(8684, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Karl Joakim Mattsson":(8685, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Meinrad Vogts":(8686, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Olaf Boesch":(8687, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Waldemar Borchard":(8688, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Hilde Kolbe":(8689, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Gustaf Raskop":(8690, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Bjarke Gärtner":(8691, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Michail \"Mishoo\" Nenkov":(8692, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Bruno Denzel":(8693, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Gerhard Haberkorn":(8694, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Wilhelmina Messner":(8695, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Anton Geisler":(8696, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Eckhart Neuman":(8697, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Patrick Vogel":(8698, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Richard Baumgärtner":(8699, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Hildegard Kaufer":(8700, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Magdalena Hauer":(8701, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Hendrik Laurenz":(8702, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Bianka Krantz":(8703, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Erich Bambach":(8704, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Levin Tolkien":(8705, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Marius Schmitt":(8706, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Egon Sorg":(8707, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Manfred Herbert":(8708, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Shun Liu":(8709, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Otto Sommer":(8710, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Maja Spitz":(8711, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Detlev Norbert":(8712, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Gilbert Hoefler":(8713, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Siegmund Amsel":(8714, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Ansgar Althaus":(8715, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Paul Wirt":(8716, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Hendrik Beckenbauer":(8717, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Irma Baumgärtner":(8718, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Wilhelmina Gerst":(8719, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Valeria Dreier":(8720, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Arnold Krauss":(8721, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Rüdiger Bäcker":(8722, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Severin Auer":(8723, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Waldemar Siegfried":(8724, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Astrid Gerst":(8725, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Dieter Gott":(8726, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Waldemar Kaufman":(8727, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Marwin Jäger":(8728, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Otto Kerper":(8729, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Martin Brant":(8730, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Jessika Göbel":(8731, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Benedikt Fleischer":(8732, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Diethelm Fuhrmann":(8733, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Reiner Von Essen":(8734, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Niklaus Fuchs":(8735, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Witold Schuchert":(8736, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Nikola Schweitzer":(8737, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Rolf Hirschmüller":(8738, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Christoph Wulf":(8739, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Aurel Krauß":(8740, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Eckhard Wolff":(8741, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Hartmut Bauers":(8742, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Hartmut König":(8743, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Friedemann Roth":(8744, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Nicholas Velmorres":(8745, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Regula Maurer":(8746, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - André Planck":(8747, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Gebhard Schmeling":(8748, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Hagen Becker":(8749, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Udo Würtz":(8750, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Helfried Ziegler":(8751, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Hanna Kurz":(8752, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Philomena Ackermann":(8753, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Hugo Sieger":(8754, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Walther Siegert":(8755, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Gabriel Sauer":(8756, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Luise Hummel":(8757, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Jakob Gutermuth":(8758, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Franz Everhart":(8759, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Ronald Stein":(8760, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Karla Dreschner":(8761, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Joachim Blum":(8762, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Hugo Großer":(8763, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Dennis Sachs":(8764, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Cecilia Unruh":(8765, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Baldur Althaus":(8766, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Maya Danegod":(8767, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Detlef Achterberg":(8768, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Maria Gerig":(8769, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Jonathan Rushworth":(8770, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Kristiane Spellmeyer":(8771, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Freya Kistner":(8772, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Helena Senft":(8773, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Rüdiger Fertig":(8774, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Michael Beyer":(8775, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Wilfried Steube":(8776, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Noemi Krämer":(8777, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Ingolf Maurer":(8778, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Sofia Behringer":(8779, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Heinrich Mein":(8780, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Burkhart Althaus":(8781, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Harald Förstner":(8782, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Egbert-Jan de Graaf":(8783, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Günter Schuhmacher":(8784, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Leona Rosenfeld":(8785, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Edgar Planck":(8786, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Jochen Lafrenz":(8787, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Hagen Bischoffs":(8788, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Ronald Hüber":(8789, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Vasilis \"The Beast\" Fezoulidis":(8790, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Mathias Hubertus":(8791, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Irene Bauers":(8792, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Simon-Pierre Therriault":(8793, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Joseph Böttcher":(8794, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Reinhold Stauss":(8795, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Helmut Lawrenz":(8796, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Dominik Schmidt":(8797, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Louisa Kaufman":(8798, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Albina Horländer":(8799, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Gestur":(8800, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Jutta Waltz":(8801, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Tobias Schlösser":(8802, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Patrick Achilles":(8803, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Cornelius Wolter":(8804, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Kristine Hirschel":(8805, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Arnaud de Lange":(8806, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Helmuth Habich":(8807, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Simon Amsel":(8808, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Gilbert Pichler":(8809, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Baldur Schreier":(8810, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Berlin - Sebastian Kaiser":(8811, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Chongqing - Imogen Royce":(8812, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Hush":(8813, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Huiqing Wen":(8814, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Martin Brooke":(8815, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Danny Ellington":(8816, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Daryl Bridgers":(8817, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Lutero Pernell":(8818, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Efrain Carper":(8819, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Xiaoqing Feng":(8820, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - James Gordon":(8821, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Shihong Luo":(8822, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Aubrey Bacon":(8823, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Bryce Stasiak":(8824, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Chet Pellegrino":(8825, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Meifeng Zhao":(8826, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Merrill Krantz":(8827, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Huifang Qian":(8828, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Clevie Stat":(8829, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Lee Hong":(8830, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Shaoqing Wen":(8831, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Vincent Knowles":(8832, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Geming Qiao":(8833, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Jingfei Kang":(8834, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Marilee Tyrrell":(8835, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Robin Espino":(8836, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Feng Zhao":(8837, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Hui Zeng":(8838, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Jean McCorkell":(8839, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Meixiu He":(8840, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Geming Zhen":(8841, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Huang Peng":(8842, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Sharon Reed":(8843, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Leeland Shariff":(8844, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Tomas Perren":(8845, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Pierre Whorton":(8846, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Sherwin Kung":(8847, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Tingfeng Gu":(8848, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Eduardo Leverette":(8849, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Frida Mounsdon":(8850, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Aron Fant":(8851, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Alan Newbold":(8852, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Salvador Moline":(8853, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Allie Ventura":(8854, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Qiu Wen":(8855, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Guoliang Ding":(8856, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Lavern Cancel":(8857, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Tingguang Dai":(8858, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Townie Thurley":(8859, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Junjie Chang":(8860, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Chonglin Deng":(8861, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Buck Mckeever":(8862, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Hugh Jansson":(8863, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Leilah Sourisseau":(8864, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Xingjuan Yuan":(8865, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Luli He":(8866, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Herman Leone":(8867, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Ling Yin":(8868, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Wilfred Reaves":(8869, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Jefferey Malloy":(8870, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Oskar Gamble":(8871, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Huiqing Zhu":(8872, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Rong Lin":(8873, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - John Babin":(8874, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Fa Fu":(8875, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Tao Yi":(8876, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Sherman Marcoux":(8877, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Emery Nurse":(8878, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Boqin Yan":(8879, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Yuan Lin":(8880, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Lou Bourne":(8881, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Jeremy Bolt":(8882, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Nuying Xue":(8883, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Berrie Kearney":(8884, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Erica Bourne":(8885, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Adam Knudson":(8886, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Leslie Huguley":(8887, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - He Hou":(8888, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Bill Bernard":(8889, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Scotty Knott":(8890, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Gaby Luff":(8891, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Sam Brownlee":(8892, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Ai Jin":(8893, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Jinhai Zhao":(8894, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Qingshan Yao":(8895, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Fengge Fang":(8896, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Dianna Rivera":(8897, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Dean Zirko":(8898, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Emerson Beecher":(8899, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Hank Panker":(8900, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Jim Aguilera":(8901, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Meilin Du":(8902, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Meifeng Yao":(8903, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Lanfen Bai":(8904, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Dusty Feltner":(8905, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Kirsten Petersen":(8906, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Hung Smithers":(8907, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Palmer Wang":(8908, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Virgilio Nelms":(8909, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Boris Lacayo":(8910, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Yue Cheng":(8911, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Guoliang Xu":(8912, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Ling Ma":(8913, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Xiaofan Dai":(8914, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Jeremy Prunty":(8915, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Mei Sun":(8916, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Xiurong Zhou":(8917, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Chen Ting":(8918, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Darcee Julian":(8919, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Lawrence Armendariz":(8920, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Mogwai":(8921, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Alva Cowell":(8922, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Fa Dai":(8923, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Gao Ling":(8924, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Rocco Hinds":(8925, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Liu Xia":(8926, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Donnie Demiraca":(8927, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Marcus Easterwood":(8928, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Josef Trojanowski":(8929, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Huizhong Xiong":(8930, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Shaoqing Fan":(8931, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Meirong Qiu":(8932, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Roscoe Costanza":(8933, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Doug Downer":(8934, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Da Yin":(8935, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Tung-mei Wu":(8936, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Nianzu Li":(8937, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Marcos Franco":(8938, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Longwei Feng":(8939, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Weiyuan Bai":(8940, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Guozhi Yuan":(8941, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Alicia Reynolds":(8942, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Nianzu Shao":(8943, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Filiberto Newbold":(8944, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Delmor Merrick":(8945, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Raymundo Alfano":(8946, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Abe Freeborn":(8947, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Erik Bjarne Thorpe":(8948, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Jamie Mercurio":(8949, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Harald Newcombe":(8950, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Nicolas Casale":(8951, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Qingshan Fu":(8952, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Rong Wan":(8953, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Qiang Wang":(8954, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Angus Pritchard":(8955, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Fang Zhao":(8956, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Shunyuan Guo":(8957, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Joel Weinberg":(8958, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Matt Charest":(8959, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Harry Peters":(8960, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Maia Barlow":(8961, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Hui Hou":(8962, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Shirong Dai":(8963, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Daren Rinehart":(8964, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Armand Funk":(8965, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Changying He":(8966, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Fan Ren":(8967, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Samuel Gleaton":(8968, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Felix Oakes":(8969, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Junli Xu":(8970, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Martin Tedrow":(8971, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Lei Meng":(8972, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Major Theroux":(8973, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Harvey Reichel":(8974, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Hussein Oam":(8975, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Sister Lei":(8976, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Suyin Shen":(8977, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Maynard Storch":(8978, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Graig Juhl":(8979, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Hobert Hilbert":(8980, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Xiang Wei":(8981, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Junjie Jiang":(8982, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Yingtai Tang":(8983, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Fu Luoyang":(8984, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Delun Ma":(8985, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Valentine Bloomer":(8986, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Alphonse Underwood":(8987, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Xiao Ming":(8988, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Xia Yi":(8989, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Chongqing - Helen Claire":(8990, ["chongqing"], ["skipped"], ["Level - Chongqing"], [], [], ["Elimination - Chongqing - Any","Elimination - Any"]),
    "Elimination - Mendoza - Don Archibald Yates":(8991, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Tamara Vidal":(8992, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Mario Llosa":(8993, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Jorge Giordano":(8994, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Fabricio Giordano":(8995, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Ira Ramirez":(8996, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Igone Ramirez":(8997, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Javier Blanco":(8998, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Fraco Blanco":(8999, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Andrew Harrison":(9000, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Aurelio Escobar":(9001, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Aureliano Herrera":(9002, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Emiliano Kämpfer":(9003, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Claudio Barrios":(9004, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Yvette Ochoa":(9005, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Alex Rheinhart":(9006, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Ellinor Westrup":(9007, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Richard Jones":(9008, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Sophia Robinson":(9009, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Hugo Molina":(9010, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Elvira Colombo":(9011, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Ally Monroe":(9012, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Mario ToscanoW":(9013, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Isobel Riley":(9014, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Caleb Woods":(9015, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Mauricio Domínguez":(9016, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Valentina Yates":(9017, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Jason Slater":(9018, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Hernan Di Stefano":(9019, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Juan Carlos Malavia":(9020, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Hira Amala":(9021, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Violetta Mendez":(9022, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Federico Autino":(9023, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Ben Christie":(9024, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Franco Rios":(9025, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Gabriel Khan":(9026, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Zac Johnston":(9027, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Sandro Tarella":(9028, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Frederick Wilson":(9029, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Néstor Sosa":(9030, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Montel Benítez":(9031, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Franco Pugliesi":(9032, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Atahualpa Soria":(9033, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Narcisa Angelo":(9034, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Melvin Hoover":(9035, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Alexandra Stavroula":(9036, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Veto Ibañez":(9037, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Joshua Macías":(9038, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Brooklyn Bush":(9039, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Pablo Farías":(9040, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Fresco DeRose":(9041, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Tim Quinn":(9042, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Montrel Moreno":(9043, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Melissa Harper":(9044, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Jerico DeRose":(9045, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Bartolomeo Rutherford":(9046, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Christoffer Feldtmann":(9047, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Mason Kennedy":(9048, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Raoul Salazar":(9049, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Sal Buccho":(9050, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Esperanza Ibáñez":(9051, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Platon Coronel":(9052, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Kenneth Langley":(9053, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Leandra Marchesi":(9054, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Pablo Beneventi":(9055, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Patricio Iglesias":(9056, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Geraldine Quill":(9057, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Raulo Dominguez":(9058, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Martin Cooke":(9059, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Jack McLaughlin":(9060, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Teyo Leguizamón":(9061, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Peter Mills":(9062, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Ernesto March":(9063, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Connor Baird":(9064, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Juan Domingo Siciliano":(9065, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Gabrio Ibanez":(9066, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Jorge Capon":(9067, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Miguel Boedo":(9068, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Lonzo Malavia":(9069, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Hernando Ferreyra":(9070, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Fletcher Fernandez":(9071, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Heidi Sutton":(9072, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Manny Russo":(9073, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Frisco Olleros":(9074, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Quinto Ortiz":(9075, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Fernán Castiglione":(9076, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Florencio Ortiz":(9077, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Madalena Marchesi":(9078, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Anderson Silviero":(9079, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Heidi Santoro":(9080, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Amaya Leonard":(9081, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Adrían Napolitano":(9082, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Nathaniel Richardson":(9083, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Julia Green":(9084, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Martin Ansdal":(9085, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Hortencia Vargas":(9086, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Leonard Bright":(9087, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Lawrence Colombo":(9088, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Leon Wood":(9089, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Tommy Hamilton":(9090, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Leighton McMahon":(9091, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Bartolomeo Pinto":(9092, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Conrado Olleros":(9093, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Bailey Clark":(9094, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Layne Estrada":(9095, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Declan Barrett":(9096, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Felix Albert":(9097, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Monica Ansdal":(9098, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Lucero Romano":(9099, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Duncan Lindsay":(9100, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Leon Khan":(9101, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Jorge Lorenzo":(9102, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Carlomagno Schmidt":(9103, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Demi Dawson":(9104, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Logan Stone":(9105, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Shaun Mcgee":(9106, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Eira Duffy":(9107, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Alicia Lawson":(9108, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Guadalupe D'Onofrio":(9109, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Reynaldo Rojas":(9110, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Hugo Siciliano":(9111, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Shreya Mcarthur":(9112, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Enzo Roca":(9113, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Liam Hamilton":(9114, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Juanita Oteros":(9115, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Kolten Case":(9116, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Chavez Pereira":(9117, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Estephanie Hernándezawe":(9118, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Rufio Acuña":(9119, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Megan Mcdonald":(9120, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Hilario Tocci":(9121, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Victor Figueroa":(9122, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Curro Torres":(9123, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Miranda Rutherford":(9124, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Owen Chambers":(9125, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Alba Martín":(9126, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Oliverios Nunez":(9127, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Allan Guzman":(9128, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Ernest Castro":(9129, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Arturo Lori":(9130, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Geraldo Rodriguez":(9131, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Ignazio Lombardo":(9132, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Hazel Page":(9133, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Jerrald Endrizzi":(9134, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Zechariah Stafford":(9135, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Bailey Rogers":(9136, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Isaac Evans":(9137, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Jorge De Luca":(9138, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Charlotte Wood":(9139, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Jerrald Dukaroff":(9140, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Charlee Ball":(9141, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Ramon Avelardez":(9142, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Natasha Jones":(9143, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Reynaldo Alonso":(9144, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Lucas Fletcher":(9145, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Belinda Toscano":(9146, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Spencer Brown":(9147, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Lilly Poole":(9148, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Abbie Andrews":(9149, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Luciano Villalba":(9150, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Henriqua March":(9151, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Dexy Barat":(9152, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Lalo Rios":(9153, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Deangelo Cote":(9154, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Lena Bjoernshauge":(9155, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Gervasio Correa":(9156, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Jay Smart":(9157, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Juliano Carrizo":(9158, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Kyle Bradley":(9159, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Kieran Simmons":(9160, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Calvino Roca":(9161, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Pam Kingsley":(9162, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Konnor Langley":(9163, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Heriberto Romano":(9164, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Montez Narzecian":(9165, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Brinley Tyson":(9166, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Montego Echeverria":(9167, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Reno Davide":(9168, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Socorro Barrios":(9169, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Fidelina Pugliesi":(9170, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Gabriel Vargas":(9171, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Leandro Avelardez":(9172, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Holden Joyner":(9173, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Faron Piazza":(9174, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Toro Morettids":(9175, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Santino Lombardi":(9176, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Corvo Black":(9177, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Conrado Giordano":(9178, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Guadalupe Borroni":(9179, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Salomon Schiavone":(9180, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Melody Riddle":(9181, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Hernando Loggia":(9182, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Dolores Powell":(9183, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Dario Udinese":(9184, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Sam Day":(9185, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Samuel Cooke":(9186, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Juan Cortázar":(9187, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Rodolfo Blanco":(9188, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Leo Collins":(9189, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Garcia Martin":(9190, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Nabeela Neale":(9191, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Zackary Hensley":(9192, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Mateo Roca":(9193, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - George Baker":(9194, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Gael Stanley":(9195, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Nehuen Chávez":(9196, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Ambrosio Beneventi":(9197, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Elliot Gill":(9198, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Ritchie Vidal":(9199, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Aurelius Castiglione":(9200, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Nicolas Borroni":(9201, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Isabel Munoz":(9202, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Gil Sosa":(9203, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Bautista Castiglione":(9204, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Joseph Byrne":(9205, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Lyle McAllister":(9206, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Juliano Moreno":(9207, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Leila Nuñez":(9208, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Reese Turner":(9209, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Faron Valdézw":(9210, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Eden Marsh":(9211, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Aureliano Arce":(9212, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Andrew Harper":(9213, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Montrel Piazza":(9214, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Pablo Llosa":(9215, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Marco Vera":(9216, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Luciano Davide":(9217, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Mikhail Kadir":(9218, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Niamh Duncan":(9219, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Elias Medina":(9220, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Jonah Sherman":(9221, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Montes Lo Duca":(9222, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Augusto Albarez":(9223, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Brandon Jackson":(9224, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Anastasio Napolitano":(9225, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Montes Castillo":(9226, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Jonathan Richards":(9227, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Tavio Suarez":(9228, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Archie Riley":(9229, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Prospero Romano":(9230, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Frisco Ortíz":(9231, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Elizabeth Fritz":(9232, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Carmelita Martin":(9233, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Timo Schmidt":(9234, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Joseph Spears":(9235, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Godfredo Lorenzo":(9236, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Wang YinYuan":(9237, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Theo Kelly":(9238, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Jake Berry":(9239, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Fresco Ibañez":(9240, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Emesto Mendoza":(9241, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Chaya Zetticcia":(9242, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Didde Bjornshauge":(9243, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Ruben Belasio":(9244, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Patrick Harper":(9245, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Guadalupe Buccho":(9246, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Zarita Farías":(9247, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Montel Beneventi":(9248, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Quinto Alvarez":(9249, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Eneas Palermo":(9250, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Kenneth Flower":(9251, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Ash Deveraux":(9252, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Martin Simone":(9253, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Peter Thomas":(9254, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Nesto Sabella":(9255, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Tom Holland":(9256, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Joel Sutton":(9257, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - James Robertson":(9258, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Pascual French":(9259, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Elija Bravo":(9260, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Beltran Rossi":(9261, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Juan Pablo Díaz":(9262, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Geraldo Lavezzi":(9263, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Héctor Córdoba":(9264, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Andreo Olleros":(9265, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Demi Deveraux":(9266, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Ollie Lawrence":(9267, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Finley Reynolds":(9268, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Shawn Cooke":(9269, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Curcio Ibañez":(9270, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Raúl Sal":(9271, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Hortencia Boedo":(9272, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Terciero Álvarez":(9273, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Bruno Elizondo":(9274, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Jerome Hodge":(9275, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Shauna Wolfe":(9276, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Pirro Salazar":(9277, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Cayetano Giordano":(9278, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Salvatore Devia":(9279, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Clodoveo Mendoza":(9280, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Leonides Udinesi":(9281, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Kate Gilmore":(9282, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Senon Zetticci":(9283, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Aron Ford Jr.":(9284, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Isabelle Wells":(9285, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Jermaine Crosby":(9286, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Lacey Hall":(9287, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Nestor Lettiere":(9288, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Nesto Sanchez":(9289, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Mark Cash":(9290, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Angelito Colombo":(9291, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Emma Houghton":(9292, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Mendoza - Reece John":(9293, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Noel Crest":(9294, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Sinhi \"Akka\" Palla":(9295, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Adarsh Char":(9296, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Trambak Bal":(9297, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Devinder Chhabra":(9298, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Mahmood Sampath":(9299, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Madhvan Pant":(9300, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Chandrashekhar Kannan":(9301, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Siddarth Mogul":(9302, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Kirti Mathew":(9303, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Carlton Smith":(9304, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Joyo Yani":(9305, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Trilok Balan":(9306, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Satyendra Johal":(9307, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Amitabh Chia":(9308, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Gulzar Kade":(9309, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Durga Chakraborty":(9310, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Jagdish Sridhar":(9311, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Balkishan Narnie":(9312, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Sahil Chhabra":(9313, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Sadashiv Kohli":(9314, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Amar Chanda":(9315, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Dev Livan":(9316, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Girilal Dugar":(9317, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Gangaadhar Chandra":(9318, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Chinmayananda Sarna":(9319, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Gajendra Mahajan":(9320, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Badrinsth Sami":(9321, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Gregory M. Yeager":(9322, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Torres Piombo":(9323, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Philip Milner":(9324, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Oscar Moorhead":(9325, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Patrick Herold":(9326, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Erasmo Kays":(9327, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Gregorio Markovich":(9328, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Long Sheahan":(9329, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Kirby Faulkner":(9330, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Carrol Fulgham":(9331, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Lihua He":(9332, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Sonu Bhakta":(9333, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Faustino Goad":(9334, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Danial Nathaniel":(9335, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Stephan Middlebrooks":(9336, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Edwardo Carbone":(9337, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Orson Mills":(9338, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Fabian Chretien":(9339, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Edwin Whitaker":(9340, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Qingsheng Zhao":(9341, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Homer Whitehair":(9342, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Roger Fikes":(9343, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Nianzu Chen":(9344, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Peter Fikes":(9345, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Jed Matsumoto":(9346, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Laverne Guillot":(9347, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Christoper Defazio":(9348, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Ethan Plaster":(9349, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Branden Dupuis":(9350, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Damian Asencio":(9351, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Shon Abrahams":(9352, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Cyril Monn":(9353, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Zackary Pullman":(9354, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Dominick Peppers":(9355, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Fairlie Salvato":(9356, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Manindra Subramanian":(9357, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Diksha Kothari":(9358, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Marcos Morningstar":(9359, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Shuchun Tan":(9360, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Jayashree Natt":(9361, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Shunyuan Liao":(9362, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Kumar Sarna":(9363, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Huizhong Ding":(9364, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Brajesh Rastogi":(9365, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Sweta Sitompul":(9366, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Giri Parekh":(9367, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Nikhil Doshi":(9368, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Kamalesh Butala":(9369, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Durga Shan":(9370, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Bhaskar Karpe":(9371, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Vedmohan Dhaliwal":(9372, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Utsav Nigam":(9373, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Suyin Wang":(9374, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Arvalan Mand":(9375, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Yuan Ma":(9376, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Shivani Ranganathan":(9377, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Dylan Saul":(9378, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Cherla Raj":(9379, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Lata Raval":(9380, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Amar Bains":(9381, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Kalyan Kapur":(9382, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Kanupriya Ravi":(9383, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Satish Pathak":(9384, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Shambhu Borra":(9385, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Dewey MacFarlane":(9386, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Mumtaz Meda":(9387, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Aaarti Narang":(9388, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Tej Varty":(9389, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Nero Pamperin":(9390, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Amar Panchal":(9391, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Huizhong Lai":(9392, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Boqin Lin":(9393, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Haripreet Saha":(9394, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Rohit Ray":(9395, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Chetan Bali":(9396, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Gandharva Magar":(9397, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Ravi Kunda":(9398, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Ghanasyaam Desai":(9399, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Anganan Beharry":(9400, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Adinata Manullang":(9401, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Lyle Colbert":(9402, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Gorakhnath Deol":(9403, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Satyen Batra":(9404, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Madhukanta Saran":(9405, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Candrakanta Sitompul":(9406, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Madhumati Deshmukh":(9407, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Mortie O'Regan":(9408, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Anup Hayer":(9409, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Mahidol Songprawati":(9410, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Anand Rattan":(9411, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Chandrayan Bora":(9412, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Chintanika Venkataraman":(9413, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Sri Narasimhan":(9414, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Marcin Tsabi":(9415, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Bhuvan Jhaveri":(9416, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Eswari Ravi":(9417, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Dwarka Kohli":(9418, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Lakshminath Halder":(9419, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Aradhna Chaudhari":(9420, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Bandasak Srisai":(9421, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Dharmaraaj Hari":(9422, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Durgeswar Dhingra":(9423, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Reksa Samosir":(9424, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Gurudas Keer":(9425, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Manmohan Nadig":(9426, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Abhaijeet Oak":(9427, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Hemant Balan":(9428, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Jianjun Liao":(9429, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Gopal Kant":(9430, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Adolph Damon":(9431, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Henry Chander":(9432, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Dylon Swanson":(9433, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Jay Brahmbhatt":(9434, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Everett Bernabe":(9435, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Jamel Remick":(9436, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Satyajeet Sengupta":(9437, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Farah":(9438, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Jeramey Ziemba":(9439, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Gulzar Chand":(9440, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Jere Daw":(9441, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Mahesh Varty":(9442, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Nirmal Lad":(9443, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Baidehi Varty":(9444, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Chander Sheth":(9445, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Earnest Eckard":(9446, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Aradhna Jha":(9447, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Idukala Dani":(9448, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Chandrashekhar Venkatesh":(9449, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Babu Ramroop":(9450, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Nikhil Nair":(9451, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Hemachandra Jani":(9452, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Ajimat Kusumo":(9453, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Milan Mukherjee":(9454, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Jaladhija More":(9455, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Aaarti Bal":(9456, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Vinay Palla":(9457, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Vaishvi More":(9458, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Qiang Jia":(9459, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Ronny Lass":(9460, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Rahul Patil":(9461, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Rufus Ehrhart":(9462, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Ravinder Pall":(9463, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Daamodar Jain":(9464, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Sarla Tandon":(9465, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Somnath Gara":(9466, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Satyen Barad":(9467, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Bhushan Ratti":(9468, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Ambrose Island - Kashi Radhakrishnan":(9469, ["ambrose_island"], ["skipped"], ["Level - Ambrose Island"], [], [], ["Elimination - Ambrose Island - Any","Elimination - Any"]),
    "Elimination - Carpathian Mountains - Arthur Edwards":(9500, ["carpathian_mountains"], ["skipped"], ["Level - Carpathian Mountains"], [], [], ["Elimination - Carpathian Mountains - Any","Elimination - Any"]),
    "Elimination - Hokkaido - Erich Soders":(9501, ["hokkaido"], ["skipped"], ["Level - Hokkaido"], [], [], ["Elimination - Hokkaido - Any","Elimination - Any"]),
    "Elimination - Berlin - Agent Price":(9502, ["berlin"], ["skipped"], ["Level - Berlin"], [], [], ["Elimination - Berlin - Any","Elimination - Any"]),
    "Elimination - Mendoza - Diana Burnwood":(9503, ["mendoza"], ["skipped"], ["Level - Mendoza"], [], [], ["Elimination - Mendoza - Any","Elimination - Any"]),
    "Elimination - Santa Fortuna - María Luisa Zamorano":(9504, ["santa_fortuna"], ["skipped"], ["Level - Santa Fortuna"], [], [], ["Elimination - Santa Fortuna - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Leonard Gore":(9505, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"]),
    "Elimination - Dartmoor - Samantha Hunter":(9506, ["dartmoor"], ["skipped"], ["Level - Dartmoor"], [], [], ["Elimination - Dartmoor - Any","Elimination - Any"])
}

disguise_location_table = {
    "Disguise - ICA Facility - Airplane Mechanic":(3000, ["ica_facility"], ["disguisesanity"], ["Level - ICA Facility"], [], [], ["Disguise - Any", "Disguise - ICA Facility - Any"]),
    "Disguise - ICA Facility - Airfield Security":(3001, ["ica_facility"], ["disguisesanity"], ["Level - ICA Facility"], [], [], ["Disguise - Any", "Disguise - ICA Facility - Any"]),
    "Disguise - ICA Facility - KGB Officer":(3002, ["ica_facility"], ["disguisesanity"], ["Level - ICA Facility"], [], [], ["Disguise - Any", "Disguise - ICA Facility - Any"]),
    "Disguise - ICA Facility - Soviet Soldier":(3003, ["ica_facility"], ["disguisesanity"], ["Level - ICA Facility"], [], [], ["Disguise - Any", "Disguise - ICA Facility - Any"]),
    "Disguise - Paris - CICADA Bodyguard":(3004, ["paris"], ["disguisesanity"], ["Level - Paris"], [], [], ["Disguise - Any", "Disguise - Paris - Any"]),
    "Disguise - Paris - Security Guard":(3005, ["paris"], ["disguisesanity"], ["Level - Paris"], [], [], ["Disguise - Any", "Disguise - Paris - Any"]),
    "Disguise - Paris - Palace Staff":(3006, ["paris"], ["disguisesanity"], ["Level - Paris"], [], [], ["Disguise - Any", "Disguise - Paris - Any"]),
    "Disguise - Paris - Vampire Magician":(3007, ["paris"], ["disguisesanity"], ["Level - Paris"], [], [], ["Disguise - Any", "Disguise - Paris - Any"]),
    "Disguise - Paris - Auction Staff":(3008, ["paris"], ["disguisesanity"], ["Level - Paris"], [], [], ["Disguise - Any", "Disguise - Paris - Any"]),
    "Disguise - Paris - Tech Crew":(3009, ["paris"], ["disguisesanity"], ["Level - Paris"], [], [], ["Disguise - Any", "Disguise - Paris - Any"]),
    "Disguise - Paris - Stylist":(3010, ["paris"], ["disguisesanity"], ["Level - Paris"], [], [], ["Disguise - Any", "Disguise - Paris - Any"]),
    "Disguise - Paris - Helmut Kruger":(3011, ["paris"], ["disguisesanity"], ["Level - Paris"], [], [], ["Disguise - Any", "Disguise - Paris - Any"]),
    "Disguise - Paris - Sheikh Salman al-Ghazali":(3012, ["paris"], ["disguisesanity"], ["Level - Paris"], [], [], ["Disguise - Any", "Disguise - Paris - Any"]),
    "Disguise - Paris - Chef":(3013, ["paris"], ["disguisesanity"], ["Level - Paris"], [], [], ["Disguise - Any", "Disguise - Paris - Any"]),
    "Disguise - Sapienza - Mansion Chef":(3014, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Priest":(3015, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Red Plumber":(3016, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Bohemian":(3017, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Biolab Security":(3018, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Dr. Oscar Lafayette":(3019, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Church Staff":(3020, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Waiter":(3021, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Street Performer":(3022, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Housekeeper":(3023, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Delivery Man":(3024, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Gardener":(3025, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Kitchen Assistant":(3026, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Hazmat Suit":(3027, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Lab Technician":(3028, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Mansion Staff":(3029, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Store Clerk":(3030, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Bodyguard":(3031, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Mansion Security":(3032, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Cyclist":(3033, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Roberto Vargas":(3034, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Private Detective":(3035, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Green Plumber":(3036, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Butler":(3037, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Sapienza - Plague Doctor":(3038, ["sapienza"], ["disguisesanity"], ["Level - Sapienza"], [], [], ["Disguise - Any", "Disguise - Sapienza - Any"]),
    "Disguise - Marrakesh - Bodyguard":(3039, ["marrakesh"], ["disguisesanity"], ["Level - Marrakesh"], [], [], ["Disguise - Any", "Disguise - Marrakesh - Any"]),
    "Disguise - Marrakesh - Elite Soldier":(3040, ["marrakesh"], ["disguisesanity"], ["Level - Marrakesh"], [], [], ["Disguise - Any", "Disguise - Marrakesh - Any"]),
    "Disguise - Marrakesh - Consulate Security":(3041, ["marrakesh"], ["disguisesanity"], ["Level - Marrakesh"], [], [], ["Disguise - Any", "Disguise - Marrakesh - Any"]),
    "Disguise - Marrakesh - Military Officer":(3042, ["marrakesh"], ["disguisesanity"], ["Level - Marrakesh"], [], [], ["Disguise - Any", "Disguise - Marrakesh - Any"]),
    "Disguise - Marrakesh - Military Soldier":(3043, ["marrakesh"], ["disguisesanity"], ["Level - Marrakesh"], [], [], ["Disguise - Any", "Disguise - Marrakesh - Any"]),
    "Disguise - Marrakesh - Cameraman":(3044, ["marrakesh"], ["disguisesanity"], ["Level - Marrakesh"], [], [], ["Disguise - Any", "Disguise - Marrakesh - Any"]),
    "Disguise - Marrakesh - Consulate Intern":(3045, ["marrakesh"], ["disguisesanity"], ["Level - Marrakesh"], [], [], ["Disguise - Any", "Disguise - Marrakesh - Any"]),
    "Disguise - Marrakesh - Masseur":(3046, ["marrakesh"], ["disguisesanity"], ["Level - Marrakesh"], [], [], ["Disguise - Any", "Disguise - Marrakesh - Any"]),
    "Disguise - Marrakesh - Fortune Teller":(3047, ["marrakesh"], ["disguisesanity"], ["Level - Marrakesh"], [], [], ["Disguise - Any", "Disguise - Marrakesh - Any"]),
    "Disguise - Marrakesh - Headmaster":(3048, ["marrakesh"], ["disguisesanity"], ["Level - Marrakesh"], [], [], ["Disguise - Any", "Disguise - Marrakesh - Any"]),
    "Disguise - Marrakesh - Prisoner":(3049, ["marrakesh"], ["disguisesanity"], ["Level - Marrakesh"], [], [], ["Disguise - Any", "Disguise - Marrakesh - Any"]),
    "Disguise - Marrakesh - Waiter":(3050, ["marrakesh"], ["disguisesanity"], ["Level - Marrakesh"], [], [], ["Disguise - Any", "Disguise - Marrakesh - Any"]),
    "Disguise - Marrakesh - Consulate Janitor":(3051, ["marrakesh"], ["disguisesanity"], ["Level - Marrakesh"], [], [], ["Disguise - Any", "Disguise - Marrakesh - Any"]),
    "Disguise - Marrakesh - Handyman":(3052, ["marrakesh"], ["disguisesanity"], ["Level - Marrakesh"], [], [], ["Disguise - Any", "Disguise - Marrakesh - Any"]),
    "Disguise - Marrakesh - Food Vendor":(3053, ["marrakesh"], ["disguisesanity"], ["Level - Marrakesh"], [], [], ["Disguise - Any", "Disguise - Marrakesh - Any"]),
    "Disguise - Marrakesh - Local Printing Crew":(3054, ["marrakesh"], ["disguisesanity"], ["Level - Marrakesh"], [], [], ["Disguise - Any", "Disguise - Marrakesh - Any"]),
    "Disguise - Marrakesh - Shopkeeper":(3055, ["marrakesh"], ["disguisesanity"], ["Level - Marrakesh"], [], [], ["Disguise - Any", "Disguise - Marrakesh - Any"]),
    "Disguise - Bangkok - Hotel Security":(3056, ["bangkok"], ["disguisesanity"], ["Level - Bangkok"], [], [], ["Disguise - Any", "Disguise - Bangkok - Any"]),
    "Disguise - Bangkok - Abel de Silva":(3057, ["bangkok"], ["disguisesanity"], ["Level - Bangkok"], [], [], ["Disguise - Any", "Disguise - Bangkok - Any"]),
    "Disguise - Bangkok - Exterminator":(3058, ["bangkok"], ["disguisesanity"], ["Level - Bangkok"], [], [], ["Disguise - Any", "Disguise - Bangkok - Any"]),
    "Disguise - Bangkok - Groundskeeper":(3059, ["bangkok"], ["disguisesanity"], ["Level - Bangkok"], [], [], ["Disguise - Any", "Disguise - Bangkok - Any"]),
    "Disguise - Bangkok - Hotel Staff":(3060, ["bangkok"], ["disguisesanity"], ["Level - Bangkok"], [], [], ["Disguise - Any", "Disguise - Bangkok - Any"]),
    "Disguise - Bangkok - Kitchen Staff":(3061, ["bangkok"], ["disguisesanity"], ["Level - Bangkok"], [], [], ["Disguise - Any", "Disguise - Bangkok - Any"]),
    "Disguise - Bangkok - Recording Crew":(3062, ["bangkok"], ["disguisesanity"], ["Level - Bangkok"], [], [], ["Disguise - Any", "Disguise - Bangkok - Any"]),
    "Disguise - Bangkok - Waiter":(3063, ["bangkok"], ["disguisesanity"], ["Level - Bangkok"], [], [], ["Disguise - Any", "Disguise - Bangkok - Any"]),
    "Disguise - Bangkok - Jordan Cross' Bodyguard":(3064, ["bangkok"], ["disguisesanity"], ["Level - Bangkok"], [], [], ["Disguise - Any", "Disguise - Bangkok - Any"]),
    "Disguise - Bangkok - Stalker":(3065, ["bangkok"], ["disguisesanity"], ["Level - Bangkok"], [], [], ["Disguise - Any", "Disguise - Bangkok - Any"]),
    "Disguise - Colorado - Militia Soldier":(3066, ["colorado"], ["disguisesanity"], ["Level - Colorado"], [], [], ["Disguise - Any", "Disguise - Colorado - Any"]),
    "Disguise - Colorado - Militia Cook":(3067, ["colorado"], ["disguisesanity"], ["Level - Colorado"], [], [], ["Disguise - Any", "Disguise - Colorado - Any"]),
    "Disguise - Colorado - Explosives Specialist":(3068, ["colorado"], ["disguisesanity"], ["Level - Colorado"], [], [], ["Disguise - Any", "Disguise - Colorado - Any"]),
    "Disguise - Colorado - Militia Elite":(3069, ["colorado"], ["disguisesanity"], ["Level - Colorado"], [], [], ["Disguise - Any", "Disguise - Colorado - Any"]),
    "Disguise - Colorado - Militia Spec Ops":(3070, ["colorado"], ["disguisesanity"], ["Level - Colorado"], [], [], ["Disguise - Any", "Disguise - Colorado - Any"]),
    "Disguise - Colorado - Militia Technician":(3071, ["colorado"], ["disguisesanity"], ["Level - Colorado"], [], [], ["Disguise - Any", "Disguise - Colorado - Any"]),
    "Disguise - Colorado - Scarecrow":(3072, ["colorado"], ["disguisesanity"], ["Level - Colorado"], [], [], ["Disguise - Any", "Disguise - Colorado - Any"]),
    "Disguise - Colorado - Point Man":(3073, ["colorado"], ["disguisesanity"], ["Level - Colorado"], [], [], ["Disguise - Any", "Disguise - Colorado - Any"]),
    "Disguise - Colorado - Hacker":(3074, ["colorado"], ["disguisesanity"], ["Level - Colorado"], [], [], ["Disguise - Any", "Disguise - Colorado - Any"]),
    "Disguise - Hokkaido - Bodyguard":(3075, ["hokkaido"], ["disguisesanity"], ["Level - Hokkaido"], [], [], ["Disguise - Any", "Disguise - Hokkaido - Any"]),
    "Disguise - Hokkaido - Resort Security":(3076, ["hokkaido"], ["disguisesanity"], ["Level - Hokkaido"], [], [], ["Disguise - Any", "Disguise - Hokkaido - Any"]),
    "Disguise - Hokkaido - Chief Surgeon":(3077, ["hokkaido"], ["disguisesanity"], ["Level - Hokkaido"], [], [], ["Disguise - Any", "Disguise - Hokkaido - Any"]),
    "Disguise - Hokkaido - Helicopter Pilot":(3078, ["hokkaido"], ["disguisesanity"], ["Level - Hokkaido"], [], [], ["Disguise - Any", "Disguise - Hokkaido - Any"]),
    "Disguise - Hokkaido - Hospital Director":(3079, ["hokkaido"], ["disguisesanity"], ["Level - Hokkaido"], [], [], ["Disguise - Any", "Disguise - Hokkaido - Any"]),
    "Disguise - Hokkaido - VIP Patient (Dexter)":(3080, ["hokkaido"], ["disguisesanity"], ["Level - Hokkaido"], [], [], ["Disguise - Any", "Disguise - Hokkaido - Any"]),
    "Disguise - Hokkaido - VIP Patient (Portman)":(3081, ["hokkaido"], ["disguisesanity"], ["Level - Hokkaido"], [], [], ["Disguise - Any", "Disguise - Hokkaido - Any"]),
    "Disguise - Hokkaido - Yoga Instructor":(3082, ["hokkaido"], ["disguisesanity"], ["Level - Hokkaido"], [], [], ["Disguise - Any", "Disguise - Hokkaido - Any"]),
    "Disguise - Hokkaido - Chef":(3083, ["hokkaido"], ["disguisesanity"], ["Level - Hokkaido"], [], [], ["Disguise - Any", "Disguise - Hokkaido - Any"]),
    "Disguise - Hokkaido - Doctor":(3084, ["hokkaido"], ["disguisesanity"], ["Level - Hokkaido"], [], [], ["Disguise - Any", "Disguise - Hokkaido - Any"]),
    "Disguise - Hokkaido - Handyman":(3085, ["hokkaido"], ["disguisesanity"], ["Level - Hokkaido"], [], [], ["Disguise - Any", "Disguise - Hokkaido - Any"]),
    "Disguise - Hokkaido - Morgue Doctor":(3086, ["hokkaido"], ["disguisesanity"], ["Level - Hokkaido"], [], [], ["Disguise - Any", "Disguise - Hokkaido - Any"]),
    "Disguise - Hokkaido - Resort Staff":(3087, ["hokkaido"], ["disguisesanity"], ["Level - Hokkaido"], [], [], ["Disguise - Any", "Disguise - Hokkaido - Any"]),
    "Disguise - Hokkaido - Surgeon":(3088, ["hokkaido"], ["disguisesanity"], ["Level - Hokkaido"], [], [], ["Disguise - Any", "Disguise - Hokkaido - Any"]),
    "Disguise - Hokkaido - Motorcyclist":(3089, ["hokkaido"], ["disguisesanity"], ["Level - Hokkaido"], [], [], ["Disguise - Any", "Disguise - Hokkaido - Any"]),
    "Disguise - Hokkaido - Baseball Player":(3090, ["hokkaido"], ["disguisesanity"], ["Level - Hokkaido"], [], [], ["Disguise - Any", "Disguise - Hokkaido - Any"]),
    "Disguise - Hawkes Bay - Bodyguard":(3091, ["hawkes_bay"], ["disguisesanity"], ["Level - Hawkes Bay"], [], [], ["Disguise - Any", "Disguise - Hawkes Bay - Any"]),
    "Disguise - Miami - Race Coordinator":(3092, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Kronstadt Mechanic":(3093, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Kowoon Mechanic":(3094, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Aeon Mechanic":(3095, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Thwack Mechanic":(3096, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Sotteraneo Mechanic":(3097, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Kowoon Driver":(3098, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Aeon Driver":(3099, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Blue Seed Driver":(3100, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Thwack Driver":(3101, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Mascot":(3102, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Ted Mendez":(3103, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Kronstadt Security":(3104, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Event Security":(3105, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Event Crew":(3106, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Kitchen Staff":(3107, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Race Marshal":(3108, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Waiter":(3109, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Kronstadt Researcher":(3110, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Kronstadt Engineer":(3111, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Moses Lee":(3112, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Pale Rider":(3113, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Medic":(3114, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Food Vendor":(3115, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Journalist":(3116, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Street Musician":(3117, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Sheik":(3118, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Crashed Driver Kronstadt":(3119, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Miami - Florida Man":(3120, ["miami"], ["disguisesanity"], ["Level - Miami"], [], [], ["Disguise - Any", "Disguise - Miami - Any"]),
    "Disguise - Santa Fortuna - Shaman":(3121, ["santa_fortuna"], ["disguisesanity"], ["Level - Santa Fortuna"], [], [], ["Disguise - Any", "Disguise - Santa Fortuna - Any"]),
    "Disguise - Santa Fortuna - Tattooist (P-Power)":(3122, ["santa_fortuna"], ["disguisesanity"], ["Level - Santa Fortuna"], [], [], ["Disguise - Any", "Disguise - Santa Fortuna - Any"]),
    "Disguise - Santa Fortuna - Band Member (Drummer)":(3123, ["santa_fortuna"], ["disguisesanity"], ["Level - Santa Fortuna"], [], [], ["Disguise - Any", "Disguise - Santa Fortuna - Any"]),
    "Disguise - Santa Fortuna - Submarine Engineer":(3124, ["santa_fortuna"], ["disguisesanity"], ["Level - Santa Fortuna"], [], [], ["Disguise - Any", "Disguise - Santa Fortuna - Any"]),
    "Disguise - Santa Fortuna - Hippo Whisperer":(3125, ["santa_fortuna"], ["disguisesanity"], ["Level - Santa Fortuna"], [], [], ["Disguise - Any", "Disguise - Santa Fortuna - Any"]),
    "Disguise - Santa Fortuna - Hippie":(3126, ["santa_fortuna"], ["disguisesanity"], ["Level - Santa Fortuna"], [], [], ["Disguise - Any", "Disguise - Santa Fortuna - Any"]),
    "Disguise - Santa Fortuna - Street Soldier":(3127, ["santa_fortuna"], ["disguisesanity"], ["Level - Santa Fortuna"], [], [], ["Disguise - Any", "Disguise - Santa Fortuna - Any"]),
    "Disguise - Santa Fortuna - Construction Worker":(3128, ["santa_fortuna"], ["disguisesanity"], ["Level - Santa Fortuna"], [], [], ["Disguise - Any", "Disguise - Santa Fortuna - Any"]),
    "Disguise - Santa Fortuna - Barman":(3129, ["santa_fortuna"], ["disguisesanity"], ["Level - Santa Fortuna"], [], [], ["Disguise - Any", "Disguise - Santa Fortuna - Any"]),
    "Disguise - Santa Fortuna - Mansion Guard":(3130, ["santa_fortuna"], ["disguisesanity"], ["Level - Santa Fortuna"], [], [], ["Disguise - Any", "Disguise - Santa Fortuna - Any"]),
    "Disguise - Santa Fortuna - Chef":(3131, ["santa_fortuna"], ["disguisesanity"], ["Level - Santa Fortuna"], [], [], ["Disguise - Any", "Disguise - Santa Fortuna - Any"]),
    "Disguise - Santa Fortuna - Gardener":(3132, ["santa_fortuna"], ["disguisesanity"], ["Level - Santa Fortuna"], [], [], ["Disguise - Any", "Disguise - Santa Fortuna - Any"]),
    "Disguise - Santa Fortuna - Mansion Staff":(3133, ["santa_fortuna"], ["disguisesanity"], ["Level - Santa Fortuna"], [], [], ["Disguise - Any", "Disguise - Santa Fortuna - Any"]),
    "Disguise - Santa Fortuna - Coca Field Guard":(3134, ["santa_fortuna"], ["disguisesanity"], ["Level - Santa Fortuna"], [], [], ["Disguise - Any", "Disguise - Santa Fortuna - Any"]),
    "Disguise - Santa Fortuna - Coca Field Worker":(3135, ["santa_fortuna"], ["disguisesanity"], ["Level - Santa Fortuna"], [], [], ["Disguise - Any", "Disguise - Santa Fortuna - Any"]),
    "Disguise - Santa Fortuna - Drug Lab Worker":(3136, ["santa_fortuna"], ["disguisesanity"], ["Level - Santa Fortuna"], [], [], ["Disguise - Any", "Disguise - Santa Fortuna - Any"]),
    "Disguise - Santa Fortuna - Elite Guard":(3137, ["santa_fortuna"], ["disguisesanity"], ["Level - Santa Fortuna"], [], [], ["Disguise - Any", "Disguise - Santa Fortuna - Any"]),
    "Disguise - Santa Fortuna - Submarine Crew":(3138, ["santa_fortuna"], ["disguisesanity"], ["Level - Santa Fortuna"], [], [], ["Disguise - Any", "Disguise - Santa Fortuna - Any"]),
    "Disguise - Mumbai - Bollywood Crew":(3139, ["mumbai"], ["disguisesanity"], ["Level - Mumbai"], [], [], ["Disguise - Any", "Disguise - Mumbai - Any"]),
    "Disguise - Mumbai - Vanya' Servant":(3140, ["mumbai"], ["disguisesanity"], ["Level - Mumbai"], [], [], ["Disguise - Any", "Disguise - Mumbai - Any"]),
    "Disguise - Mumbai - Dancer":(3141, ["mumbai"], ["disguisesanity"], ["Level - Mumbai"], [], [], ["Disguise - Any", "Disguise - Mumbai - Any"]),
    "Disguise - Mumbai - Metal Worker":(3142, ["mumbai"], ["disguisesanity"], ["Level - Mumbai"], [], [], ["Disguise - Any", "Disguise - Mumbai - Any"]),
    "Disguise - Mumbai - Food Vendor":(3143, ["mumbai"], ["disguisesanity"], ["Level - Mumbai"], [], [], ["Disguise - Any", "Disguise - Mumbai - Any"]),
    "Disguise - Mumbai - Laundry Worker":(3144, ["mumbai"], ["disguisesanity"], ["Level - Mumbai"], [], [], ["Disguise - Any", "Disguise - Mumbai - Any"]),
    "Disguise - Mumbai - Thug":(3145, ["mumbai"], ["disguisesanity"], ["Level - Mumbai"], [], [], ["Disguise - Any", "Disguise - Mumbai - Any"]),
    "Disguise - Mumbai - Queen's Guard":(3146, ["mumbai"], ["disguisesanity"], ["Level - Mumbai"], [], [], ["Disguise - Any", "Disguise - Mumbai - Any"]),
    "Disguise - Mumbai - Queen's Bodyguard":(3147, ["mumbai"], ["disguisesanity"], ["Level - Mumbai"], [], [], ["Disguise - Any", "Disguise - Mumbai - Any"]),
    "Disguise - Mumbai - Elite Thug":(3148, ["mumbai"], ["disguisesanity"], ["Level - Mumbai"], [], [], ["Disguise - Any", "Disguise - Mumbai - Any"]),
    "Disguise - Mumbai - Local Security":(3149, ["mumbai"], ["disguisesanity"], ["Level - Mumbai"], [], [], ["Disguise - Any", "Disguise - Mumbai - Any"]),
    "Disguise - Mumbai - Bollywood Bodyguard":(3150, ["mumbai"], ["disguisesanity"], ["Level - Mumbai"], [], [], ["Disguise - Any", "Disguise - Mumbai - Any"]),
    "Disguise - Mumbai - Tailor":(3151, ["mumbai"], ["disguisesanity"], ["Level - Mumbai"], [], [], ["Disguise - Any", "Disguise - Mumbai - Any"]),
    "Disguise - Mumbai - Painter":(3152, ["mumbai"], ["disguisesanity"], ["Level - Mumbai"], [], [], ["Disguise - Any", "Disguise - Mumbai - Any"]),
    "Disguise - Mumbai - Kashmirian":(3153, ["mumbai"], ["disguisesanity"], ["Level - Mumbai"], [], [], ["Disguise - Any", "Disguise - Mumbai - Any"]),
    "Disguise - Mumbai - Holy Man":(3154, ["mumbai"], ["disguisesanity"], ["Level - Mumbai"], [], [], ["Disguise - Any", "Disguise - Mumbai - Any"]),
    "Disguise - Mumbai - Lead Actor":(3155, ["mumbai"], ["disguisesanity"], ["Level - Mumbai"], [], [], ["Disguise - Any", "Disguise - Mumbai - Any"]),
    "Disguise - Mumbai - Barber":(3156, ["mumbai"], ["disguisesanity"], ["Level - Mumbai"], [], [], ["Disguise - Any", "Disguise - Mumbai - Any"]),
    "Disguise - Mumbai - Laundry Foreman":(3157, ["mumbai"], ["disguisesanity"], ["Level - Mumbai"], [], [], ["Disguise - Any", "Disguise - Mumbai - Any"]),
    "Disguise - Whittleton Creek - Janus' Bodyguard":(3158, ["whittleton_creek"], ["disguisesanity"], ["Level - Whittleton Creek"], [], [], ["Disguise - Any", "Disguise - Whittleton Creek - Any"]),
    "Disguise - Whittleton Creek - James Batty":(3159, ["whittleton_creek"], ["disguisesanity"], ["Level - Whittleton Creek"], [], [], ["Disguise - Any", "Disguise - Whittleton Creek - Any"]),
    "Disguise - Whittleton Creek - BBQ Owner":(3160, ["whittleton_creek"], ["disguisesanity"], ["Level - Whittleton Creek"], [], [], ["Disguise - Any", "Disguise - Whittleton Creek - Any"]),
    "Disguise - Whittleton Creek - Nurse":(3161, ["whittleton_creek"], ["disguisesanity"], ["Level - Whittleton Creek"], [], [], ["Disguise - Any", "Disguise - Whittleton Creek - Any"]),
    "Disguise - Whittleton Creek - Server":(3162, ["whittleton_creek"], ["disguisesanity"], ["Level - Whittleton Creek"], [], [], ["Disguise - Any", "Disguise - Whittleton Creek - Any"]),
    "Disguise - Whittleton Creek - Politician":(3163, ["whittleton_creek"], ["disguisesanity"], ["Level - Whittleton Creek"], [], [], ["Disguise - Any", "Disguise - Whittleton Creek - Any"]),
    "Disguise - Whittleton Creek - Construction Worker":(3164, ["whittleton_creek"], ["disguisesanity"], ["Level - Whittleton Creek"], [], [], ["Disguise - Any", "Disguise - Whittleton Creek - Any"]),
    "Disguise - Whittleton Creek - Spencer \"The Hammer\" Green":(3165, ["whittleton_creek"], ["disguisesanity"], ["Level - Whittleton Creek"], [], [], ["Disguise - Any", "Disguise - Whittleton Creek - Any"]),
    "Disguise - Whittleton Creek - Cassidy Bodyguard":(3166, ["whittleton_creek"], ["disguisesanity"], ["Level - Whittleton Creek"], [], [], ["Disguise - Any", "Disguise - Whittleton Creek - Any"]),
    "Disguise - Whittleton Creek - Sheriff Masterson":(3167, ["whittleton_creek"], ["disguisesanity"], ["Level - Whittleton Creek"], [], [], ["Disguise - Any", "Disguise - Whittleton Creek - Any"]),
    "Disguise - Whittleton Creek - Mailman":(3168, ["whittleton_creek"], ["disguisesanity"], ["Level - Whittleton Creek"], [], [], ["Disguise - Any", "Disguise - Whittleton Creek - Any"]),
    "Disguise - Whittleton Creek - Gardener":(3169, ["whittleton_creek"], ["disguisesanity"], ["Level - Whittleton Creek"], [], [], ["Disguise - Any", "Disguise - Whittleton Creek - Any"]),
    "Disguise - Whittleton Creek - Gunther Mueller":(3170, ["whittleton_creek"], ["disguisesanity"], ["Level - Whittleton Creek"], [], [], ["Disguise - Any", "Disguise - Whittleton Creek - Any"]),
    "Disguise - Whittleton Creek - Politician's Assistant":(3171, ["whittleton_creek"], ["disguisesanity"], ["Level - Whittleton Creek"], [], [], ["Disguise - Any", "Disguise - Whittleton Creek - Any"]),
    "Disguise - Whittleton Creek - Exterminator":(3172, ["whittleton_creek"], ["disguisesanity"], ["Level - Whittleton Creek"], [], [], ["Disguise - Any", "Disguise - Whittleton Creek - Any"]),
    "Disguise - Whittleton Creek - Police Deputy":(3173, ["whittleton_creek"], ["disguisesanity"], ["Level - Whittleton Creek"], [], [], ["Disguise - Any", "Disguise - Whittleton Creek - Any"]),
    "Disguise - Whittleton Creek - Real Estate Broker":(3174, ["whittleton_creek"], ["disguisesanity"], ["Level - Whittleton Creek"], [], [], ["Disguise - Any", "Disguise - Whittleton Creek - Any"]),
    "Disguise - Whittleton Creek - Garbage Man":(3175, ["whittleton_creek"], ["disguisesanity"], ["Level - Whittleton Creek"], [], [], ["Disguise - Any", "Disguise - Whittleton Creek - Any"]),
    "Disguise - Whittleton Creek - Plumber":(3176, ["whittleton_creek"], ["disguisesanity"], ["Level - Whittleton Creek"], [], [], ["Disguise - Any", "Disguise - Whittleton Creek - Any"]),
    "Disguise - Whittleton Creek - Arkian Robe":(3177, ["whittleton_creek"], ["disguisesanity"], ["Level - Whittleton Creek"], [], [], ["Disguise - Any", "Disguise - Whittleton Creek - Any"]),
    "Disguise - Isle of Sgail - Master of Ceremonies":(3178, ["isle_of_sgail"], ["disguisesanity"], ["Level - Isle of Sgail"], [], [], ["Disguise - Any", "Disguise - Isle of Sgail - Any"]),
    "Disguise - Isle of Sgail - Ark Member":(3179, ["isle_of_sgail"], ["disguisesanity"], ["Level - Isle of Sgail"], [], [], ["Disguise - Any", "Disguise - Isle of Sgail - Any"]),
    "Disguise - Isle of Sgail - Architect":(3180, ["isle_of_sgail"], ["disguisesanity"], ["Level - Isle of Sgail"], [], [], ["Disguise - Any", "Disguise - Isle of Sgail - Any"]),
    "Disguise - Isle of Sgail - Initiate":(3181, ["isle_of_sgail"], ["disguisesanity"], ["Level - Isle of Sgail"], [], [], ["Disguise - Any", "Disguise - Isle of Sgail - Any"]),
    "Disguise - Isle of Sgail - Entertainer":(3182, ["isle_of_sgail"], ["disguisesanity"], ["Level - Isle of Sgail"], [], [], ["Disguise - Any", "Disguise - Isle of Sgail - Any"]),
    "Disguise - Isle of Sgail - Burial Robes":(3183, ["isle_of_sgail"], ["disguisesanity"], ["Level - Isle of Sgail"], [], [], ["Disguise - Any", "Disguise - Isle of Sgail - Any"]),
    "Disguise - Isle of Sgail - Blake Nathaniel":(3184, ["isle_of_sgail"], ["disguisesanity"], ["Level - Isle of Sgail"], [], [], ["Disguise - Any", "Disguise - Isle of Sgail - Any"]),
    "Disguise - Isle of Sgail - Jebediah Block":(3185, ["isle_of_sgail"], ["disguisesanity"], ["Level - Isle of Sgail"], [], [], ["Disguise - Any", "Disguise - Isle of Sgail - Any"]),
    "Disguise - Isle of Sgail - Knight’s Armour":(3186, ["isle_of_sgail"], ["disguisesanity"], ["Level - Isle of Sgail"], [], [], ["Disguise - Any", "Disguise - Isle of Sgail - Any"]),
    "Disguise - Isle of Sgail - Guard":(3187, ["isle_of_sgail"], ["disguisesanity"], ["Level - Isle of Sgail"], [], [], ["Disguise - Any", "Disguise - Isle of Sgail - Any"]),
    "Disguise - Isle of Sgail - Raider":(3188, ["isle_of_sgail"], ["disguisesanity"], ["Level - Isle of Sgail"], [], [], ["Disguise - Any", "Disguise - Isle of Sgail - Any"]),
    "Disguise - Isle of Sgail - Elite Guard":(3189, ["isle_of_sgail"], ["disguisesanity"], ["Level - Isle of Sgail"], [], [], ["Disguise - Any", "Disguise - Isle of Sgail - Any"]),
    "Disguise - Isle of Sgail - Chef":(3190, ["isle_of_sgail"], ["disguisesanity"], ["Level - Isle of Sgail"], [], [], ["Disguise - Any", "Disguise - Isle of Sgail - Any"]),
    "Disguise - Isle of Sgail - Custodian":(3191, ["isle_of_sgail"], ["disguisesanity"], ["Level - Isle of Sgail"], [], [], ["Disguise - Any", "Disguise - Isle of Sgail - Any"]),
    "Disguise - Isle of Sgail - Event Staff":(3192, ["isle_of_sgail"], ["disguisesanity"], ["Level - Isle of Sgail"], [], [], ["Disguise - Any", "Disguise - Isle of Sgail - Any"]),
    "Disguise - Isle of Sgail - Butler":(3193, ["isle_of_sgail"], ["disguisesanity"], ["Level - Isle of Sgail"], [], [], ["Disguise - Any", "Disguise - Isle of Sgail - Any"]),
    "Disguise - Isle of Sgail - Castle Staff":(3194, ["isle_of_sgail"], ["disguisesanity"], ["Level - Isle of Sgail"], [], [], ["Disguise - Any", "Disguise - Isle of Sgail - Any"]),
    "Disguise - New York - High Security Guard":(3195, ["new_york"], ["disguisesanity"], ["Level - New York"], [], [], ["Disguise - Any", "Disguise - New York - Any"]),
    "Disguise - New York - Investment Banker":(3196, ["new_york"], ["disguisesanity"], ["Level - New York"], [], [], ["Disguise - Any", "Disguise - New York - Any"]),
    "Disguise - New York - IT Worker":(3197, ["new_york"], ["disguisesanity"], ["Level - New York"], [], [], ["Disguise - Any", "Disguise - New York - Any"]),
    "Disguise - New York - Security Guard":(3198, ["new_york"], ["disguisesanity"], ["Level - New York"], [], [], ["Disguise - Any", "Disguise - New York - Any"]),
    "Disguise - New York - Janitor":(3199, ["new_york"], ["disguisesanity"], ["Level - New York"], [], [], ["Disguise - Any", "Disguise - New York - Any"]),
    "Disguise - New York - Bank Teller":(3200, ["new_york"], ["disguisesanity"], ["Level - New York"], [], [], ["Disguise - Any", "Disguise - New York - Any"]),
    "Disguise - New York - Bank Robber":(3201, ["new_york"], ["disguisesanity"], ["Level - New York"], [], [], ["Disguise - Any", "Disguise - New York - Any"]),
    "Disguise - New York - Fired Banker":(3202, ["new_york"], ["disguisesanity"], ["Level - New York"], [], [], ["Disguise - Any", "Disguise - New York - Any"]),
    "Disguise - New York - Job Applicant":(3203, ["new_york"], ["disguisesanity"], ["Level - New York"], [], [], ["Disguise - Any", "Disguise - New York - Any"]),
    "Disguise - Haven Island - Boat Captain":(3204, ["haven_island"], ["disguisesanity"], ["Level - Haven Island"], [], [], ["Disguise - Any", "Disguise - Haven Island - Any"]),
    "Disguise - Haven Island - Snorkel Instructor":(3205, ["haven_island"], ["disguisesanity"], ["Level - Haven Island"], [], [], ["Disguise - Any", "Disguise - Haven Island - Any"]),
    "Disguise - Haven Island - Villa Guard":(3206, ["haven_island"], ["disguisesanity"], ["Level - Haven Island"], [], [], ["Disguise - Any", "Disguise - Haven Island - Any"]),
    "Disguise - Haven Island - Personal Trainer":(3207, ["haven_island"], ["disguisesanity"], ["Level - Haven Island"], [], [], ["Disguise - Any", "Disguise - Haven Island - Any"]),
    "Disguise - Haven Island - Life Guard":(3208, ["haven_island"], ["disguisesanity"], ["Level - Haven Island"], [], [], ["Disguise - Any", "Disguise - Haven Island - Any"]),
    "Disguise - Haven Island - Bodyguard":(3209, ["haven_island"], ["disguisesanity"], ["Level - Haven Island"], [], [], ["Disguise - Any", "Disguise - Haven Island - Any"]),
    "Disguise - Haven Island - Waiter":(3210, ["haven_island"], ["disguisesanity"], ["Level - Haven Island"], [], [], ["Disguise - Any", "Disguise - Haven Island - Any"]),
    "Disguise - Haven Island - Chef":(3211, ["haven_island"], ["disguisesanity"], ["Level - Haven Island"], [], [], ["Disguise - Any", "Disguise - Haven Island - Any"]),
    "Disguise - Haven Island - Gas Suit":(3212, ["haven_island"], ["disguisesanity"], ["Level - Haven Island"], [], [], ["Disguise - Any", "Disguise - Haven Island - Any"]),
    "Disguise - Haven Island - Villa Staff":(3213, ["haven_island"], ["disguisesanity"], ["Level - Haven Island"], [], [], ["Disguise - Any", "Disguise - Haven Island - Any"]),
    "Disguise - Haven Island - Resort Guard":(3214, ["haven_island"], ["disguisesanity"], ["Level - Haven Island"], [], [], ["Disguise - Any", "Disguise - Haven Island - Any"]),
    "Disguise - Haven Island - Masseur":(3215, ["haven_island"], ["disguisesanity"], ["Level - Haven Island"], [], [], ["Disguise - Any", "Disguise - Haven Island - Any"]),
    "Disguise - Haven Island - Resort Staff":(3216, ["haven_island"], ["disguisesanity"], ["Level - Haven Island"], [], [], ["Disguise - Any", "Disguise - Haven Island - Any"]),
    "Disguise - Haven Island - Swimwear":(3217, ["haven_island"], ["disguisesanity"], ["Level - Haven Island"], [], [], ["Disguise - Any", "Disguise - Haven Island - Any"]),
    "Disguise - Haven Island - Doctor":(3218, ["haven_island"], ["disguisesanity"], ["Level - Haven Island"], [], [], ["Disguise - Any", "Disguise - Haven Island - Any"]),
    "Disguise - Haven Island - Butler":(3219, ["haven_island"], ["disguisesanity"], ["Level - Haven Island"], [], [], ["Disguise - Any", "Disguise - Haven Island - Any"]),
    "Disguise - Haven Island - Tech Crew":(3220, ["haven_island"], ["disguisesanity"], ["Level - Haven Island"], [], [], ["Disguise - Any", "Disguise - Haven Island - Any"]),
    "Disguise - Dubai - The Assassin":(3221, ["dubai"], ["disguisesanity"], ["Level - Dubai"], [], [], ["Disguise - Any", "Disguise - Dubai - Any"]),
    "Disguise - Dubai - Famous Chef":(3222, ["dubai"], ["disguisesanity"], ["Level - Dubai"], [], [], ["Disguise - Any", "Disguise - Dubai - Any"]),
    "Disguise - Dubai - Penthouse Guard":(3223, ["dubai"], ["disguisesanity"], ["Level - Dubai"], [], [], ["Disguise - Any", "Disguise - Dubai - Any"]),
    "Disguise - Dubai - Event Staff":(3224, ["dubai"], ["disguisesanity"], ["Level - Dubai"], [], [], ["Disguise - Any", "Disguise - Dubai - Any"]),
    "Disguise - Dubai - Helicopter Pilot":(3225, ["dubai"], ["disguisesanity"], ["Level - Dubai"], [], [], ["Disguise - Any", "Disguise - Dubai - Any"]),
    "Disguise - Dubai - Penthouse Staff":(3226, ["dubai"], ["disguisesanity"], ["Level - Dubai"], [], [], ["Disguise - Any", "Disguise - Dubai - Any"]),
    "Disguise - Dubai - Event Security":(3227, ["dubai"], ["disguisesanity"], ["Level - Dubai"], [], [], ["Disguise - Any", "Disguise - Dubai - Any"]),
    "Disguise - Dubai - Maintenance Staff":(3228, ["dubai"], ["disguisesanity"], ["Level - Dubai"], [], [], ["Disguise - Any", "Disguise - Dubai - Any"]),
    "Disguise - Dubai - Kitchen Staff":(3229, ["dubai"], ["disguisesanity"], ["Level - Dubai"], [], [], ["Disguise - Any", "Disguise - Dubai - Any"]),
    "Disguise - Dubai - Art Crew":(3230, ["dubai"], ["disguisesanity"], ["Level - Dubai"], [], [], ["Disguise - Any", "Disguise - Dubai - Any"]),
    "Disguise - Dubai - Ingram's Bodyguard":(3231, ["dubai"], ["disguisesanity"], ["Level - Dubai"], [], [], ["Disguise - Any", "Disguise - Dubai - Any"]),
    "Disguise - Dartmoor - Private Investigator":(3232, ["dartmoor"], ["disguisesanity"], ["Level - Dartmoor"], [], [], ["Disguise - Any", "Disguise - Dartmoor - Any"]),
    "Disguise - Dartmoor - Undertaker":(3233, ["dartmoor"], ["disguisesanity"], ["Level - Dartmoor"], [], [], ["Disguise - Any", "Disguise - Dartmoor - Any"]),
    "Disguise - Dartmoor - Lawyer":(3234, ["dartmoor"], ["disguisesanity"], ["Level - Dartmoor"], [], [], ["Disguise - Any", "Disguise - Dartmoor - Any"]),
    "Disguise - Dartmoor - Photographer":(3235, ["dartmoor"], ["disguisesanity"], ["Level - Dartmoor"], [], [], ["Disguise - Any", "Disguise - Dartmoor - Any"]),
    "Disguise - Dartmoor - Mansion Guard":(3236, ["dartmoor"], ["disguisesanity"], ["Level - Dartmoor"], [], [], ["Disguise - Any", "Disguise - Dartmoor - Any"]),
    "Disguise - Dartmoor - Bodyguard":(3237, ["dartmoor"], ["disguisesanity"], ["Level - Dartmoor"], [], [], ["Disguise - Any", "Disguise - Dartmoor - Any"]),
    "Disguise - Dartmoor - Mansion Staff":(3238, ["dartmoor"], ["disguisesanity"], ["Level - Dartmoor"], [], [], ["Disguise - Any", "Disguise - Dartmoor - Any"]),
    "Disguise - Dartmoor - Gardener":(3239, ["dartmoor"], ["disguisesanity"], ["Level - Dartmoor"], [], [], ["Disguise - Any", "Disguise - Dartmoor - Any"]),
    "Disguise - Berlin - Technician":(3240, ["berlin"], ["disguisesanity"], ["Level - Berlin"], [], [], ["Disguise - Any", "Disguise - Berlin - Any"]),
    "Disguise - Berlin - Florida Man":(3241, ["berlin"], ["disguisesanity"], ["Level - Berlin"], [], [], ["Disguise - Any", "Disguise - Berlin - Any"]),
    "Disguise - Berlin - Delivery Guy":(3242, ["berlin"], ["disguisesanity"], ["Level - Berlin"], [], [], ["Disguise - Any", "Disguise - Berlin - Any"]),
    "Disguise - Berlin - Dealer":(3243, ["berlin"], ["disguisesanity"], ["Level - Berlin"], [], [], ["Disguise - Any", "Disguise - Berlin - Any"]),
    "Disguise - Berlin - Club Security":(3244, ["berlin"], ["disguisesanity"], ["Level - Berlin"], [], [], ["Disguise - Any", "Disguise - Berlin - Any"]),
    "Disguise - Berlin - Club Crew":(3245, ["berlin"], ["disguisesanity"], ["Level - Berlin"], [], [], ["Disguise - Any", "Disguise - Berlin - Any"]),
    "Disguise - Berlin - Bartender":(3246, ["berlin"], ["disguisesanity"], ["Level - Berlin"], [], [], ["Disguise - Any", "Disguise - Berlin - Any"]),
    "Disguise - Berlin - Biker":(3247, ["berlin"], ["disguisesanity"], ["Level - Berlin"], [], [], ["Disguise - Any", "Disguise - Berlin - Any"]),
    "Disguise - Berlin - Rolf Hirschmüller":(3248, ["berlin"], ["disguisesanity"], ["Level - Berlin"], [], [], ["Disguise - Any", "Disguise - Berlin - Any"]),
    "Disguise - Berlin - DJ":(3249, ["berlin"], ["disguisesanity"], ["Level - Berlin"], [], [], ["Disguise - Any", "Disguise - Berlin - Any"]),
    "Disguise - Chongqing - Street Guard":(3250, ["chongqing"], ["disguisesanity"], ["Level - Chongqing"], [], [], ["Disguise - Any", "Disguise - Chongqing - Any"]),
    "Disguise - Chongqing - Homeless Person":(3251, ["chongqing"], ["disguisesanity"], ["Level - Chongqing"], [], [], ["Disguise - Any", "Disguise - Chongqing - Any"]),
    "Disguise - Chongqing - Dumpling Cook":(3252, ["chongqing"], ["disguisesanity"], ["Level - Chongqing"], [], [], ["Disguise - Any", "Disguise - Chongqing - Any"]),
    "Disguise - Chongqing - The Board Member":(3253, ["chongqing"], ["disguisesanity"], ["Level - Chongqing"], [], [], ["Disguise - Any", "Disguise - Chongqing - Any"]),
    "Disguise - Chongqing - Facility Analyst":(3254, ["chongqing"], ["disguisesanity"], ["Level - Chongqing"], [], [], ["Disguise - Any", "Disguise - Chongqing - Any"]),
    "Disguise - Chongqing - Facility Engineer":(3255, ["chongqing"], ["disguisesanity"], ["Level - Chongqing"], [], [], ["Disguise - Any", "Disguise - Chongqing - Any"]),
    "Disguise - Chongqing - Researcher":(3256, ["chongqing"], ["disguisesanity"], ["Level - Chongqing"], [], [], ["Disguise - Any", "Disguise - Chongqing - Any"]),
    "Disguise - Chongqing - Block Guard":(3257, ["chongqing"], ["disguisesanity"], ["Level - Chongqing"], [], [], ["Disguise - Any", "Disguise - Chongqing - Any"]),
    "Disguise - Chongqing - Perfect Test Subject":(3258, ["chongqing"], ["disguisesanity"], ["Level - Chongqing"], [], [], ["Disguise - Any", "Disguise - Chongqing - Any"]),
    "Disguise - Chongqing - Facility Security":(3259, ["chongqing"], ["disguisesanity"], ["Level - Chongqing"], [], [], ["Disguise - Any", "Disguise - Chongqing - Any"]),
    "Disguise - Chongqing - Facility Guard":(3260, ["chongqing"], ["disguisesanity"], ["Level - Chongqing"], [], [], ["Disguise - Any", "Disguise - Chongqing - Any"]),
    "Disguise - Mendoza - Gaucho":(3261, ["mendoza"], ["disguisesanity"], ["Level - Mendoza"], [], [], ["Disguise - Any", "Disguise - Mendoza - Any"]),
    "Disguise - Mendoza - Mercenary":(3262, ["mendoza"], ["disguisesanity"], ["Level - Mendoza"], [], [], ["Disguise - Any", "Disguise - Mendoza - Any"]),
    "Disguise - Mendoza - Bodyguard":(3263, ["mendoza"], ["disguisesanity"], ["Level - Mendoza"], [], [], ["Disguise - Any", "Disguise - Mendoza - Any"]),
    "Disguise - Mendoza - Providence Herald":(3264, ["mendoza"], ["disguisesanity"], ["Level - Mendoza"], [], [], ["Disguise - Any", "Disguise - Mendoza - Any"]),
    "Disguise - Mendoza - Tango Musician":(3265, ["mendoza"], ["disguisesanity"], ["Level - Mendoza"], [], [], ["Disguise - Any", "Disguise - Mendoza - Any"]),
    "Disguise - Mendoza - Asado Chef":(3266, ["mendoza"], ["disguisesanity"], ["Level - Mendoza"], [], [], ["Disguise - Any", "Disguise - Mendoza - Any"]),
    "Disguise - Mendoza - Waiter":(3267, ["mendoza"], ["disguisesanity"], ["Level - Mendoza"], [], [], ["Disguise - Any", "Disguise - Mendoza - Any"]),
    "Disguise - Mendoza - Sommelier":(3268, ["mendoza"], ["disguisesanity"], ["Level - Mendoza"], [], [], ["Disguise - Any", "Disguise - Mendoza - Any"]),
    "Disguise - Mendoza - Winery Worker":(3269, ["mendoza"], ["disguisesanity"], ["Level - Mendoza"], [], [], ["Disguise - Any", "Disguise - Mendoza - Any"]),
    "Disguise - Mendoza - Lawyer":(3270, ["mendoza"], ["disguisesanity"], ["Level - Mendoza"], [], [], ["Disguise - Any", "Disguise - Mendoza - Any"]),
    "Disguise - Mendoza - Head of Security":(3271, ["mendoza"], ["disguisesanity"], ["Level - Mendoza"], [], [], ["Disguise - Any", "Disguise - Mendoza - Any"]),
    "Disguise - Mendoza - Chief Winemaker":(3272, ["mendoza"], ["disguisesanity"], ["Level - Mendoza"], [], [], ["Disguise - Any", "Disguise - Mendoza - Any"]),
    "Disguise - Mendoza - Tactical Wetsuit":(3273, ["mendoza"], ["disguisesanity"], ["Level - Mendoza"], [], [], ["Disguise - Any", "Disguise - Mendoza - Any"]),
    "Disguise - Mendoza - 47's Signature Suit with Gloves":(3274, ["mendoza"], ["disguisesanity"], ["Level - Mendoza"], [], [], ["Disguise - Any", "Disguise - Mendoza - Any"]),
    "Disguise - Mendoza - Corvo Black":(3275, ["mendoza"], ["disguisesanity"], ["Level - Mendoza"], [], [], ["Disguise - Any", "Disguise - Mendoza - Any"]),
    "Disguise - Carpathian Mountains - Providence Security Guard A":(3276, ["carpathian_mountains"], ["disguisesanity"], ["Level - Carpathian Mountains"], [], [], ["Disguise - Any", "Disguise - Carpathian Mountains - Any"]),
    "Disguise - Carpathian Mountains - Providence Commando":(3277, ["carpathian_mountains"], ["disguisesanity"], ["Level - Carpathian Mountains"], [], [], ["Disguise - Any", "Disguise - Carpathian Mountains - Any"]),
    "Disguise - Carpathian Mountains - Providence Commando Leader":(3278, ["carpathian_mountains"], ["disguisesanity"], ["Level - Carpathian Mountains"], [], [], ["Disguise - Any", "Disguise - Carpathian Mountains - Any"]),
    "Disguise - Carpathian Mountains - Providence Elite Guard":(3279, ["carpathian_mountains"], ["disguisesanity"], ["Level - Carpathian Mountains"], [], [], ["Disguise - Any", "Disguise - Carpathian Mountains - Any"]),
    "Disguise - Carpathian Mountains - Providence Security Guard B":(3280, ["carpathian_mountains"], ["disguisesanity"], ["Level - Carpathian Mountains"], [], [], ["Disguise - Any", "Disguise - Carpathian Mountains - Any"]),
    "Disguise - Carpathian Mountains - Providence Doctor":(3281, ["carpathian_mountains"], ["disguisesanity"], ["Level - Carpathian Mountains"], [], [], ["Disguise - Any", "Disguise - Carpathian Mountains - Any"]),
    "Disguise - Carpathian Mountains - Office Staff":(3282, ["carpathian_mountains"], ["disguisesanity"], ["Level - Carpathian Mountains"], [], [], ["Disguise - Any", "Disguise - Carpathian Mountains - Any"]),
    "Disguise - Ambrose Island - Engineer":(3283, ["ambrose_island"], ["disguisesanity"], ["Level - Ambrose Island"], [], [], ["Disguise - Any", "Disguise - Ambrose Island - Any"]),
    "Disguise - Ambrose Island - Militia Soldier":(3284, ["ambrose_island"], ["disguisesanity"], ["Level - Ambrose Island"], [], [], ["Disguise - Any", "Disguise - Ambrose Island - Any"]),
    "Disguise - Ambrose Island - Cook":(3285, ["ambrose_island"], ["disguisesanity"], ["Level - Ambrose Island"], [], [], ["Disguise - Any", "Disguise - Ambrose Island - Any"]),
    "Disguise - Ambrose Island - Hippie":(3286, ["ambrose_island"], ["disguisesanity"], ["Level - Ambrose Island"], [], [], ["Disguise - Any", "Disguise - Ambrose Island - Any"]),
    "Disguise - Ambrose Island - Metal Worker":(3287, ["ambrose_island"], ["disguisesanity"], ["Level - Ambrose Island"], [], [], ["Disguise - Any", "Disguise - Ambrose Island - Any"]),
    "Disguise - Ambrose Island - Pirate":(3288, ["ambrose_island"], ["disguisesanity"], ["Level - Ambrose Island"], [], [], ["Disguise - Any", "Disguise - Ambrose Island - Any"]),
    "Disguise - Ambrose Island - The Buccaneer":(3289, ["ambrose_island"], ["disguisesanity"], ["Level - Ambrose Island"], [], [], ["Disguise - Any", "Disguise - Ambrose Island - Any"]),
}

location_table = item_pickup_location_table | level_completion_location_table | split_item_pickup_location_table | target_kill_location_table | disguise_location_table

location_table["All Contract Pieces Collected"] = (10000,[],["contract_mode"],["Contract Piece"],[],[],[])

goal_table = {
    "ica_facility":"ICA Facility",
    "paris":"Paris",
    "sapienza":"Sapienza",
    "marrakesh":"Marrakesh",
    "bangkok":"Bangkok",
    "colorado":"Colorado",
    "hokkaido":"Hokkaido",
    "hawkes_bay":"Hawkes Bay",
    "miami":"Miami",
    "santa_fortuna":"Santa Fortuna",
    "mumbai":"Mumbai",
    "whittleton_creek":"Whittleton Creek",
    "isle_of_sgail":"Isle of Sgail",
    "new_york":"New York",
    "haven_island":"Haven Island",
    "dubai":"Dubai",
    "dartmoor":"Dartmoor",
    "berlin":"Berlin",
    "chongqing":"Chongqing",
    "mendoza":"Mendoza",
    "carpathian_mountains":"Carpathian Mountains",
    "ambrose_island":"Ambrose Island"
}

valid_targets_table = {
    "ica_facility":[5000,5001,5002,5003,5004,5005,5006,5007,5008,5009,5010,5011,5012,5013,5014,5015,5016,5017,5018,5019,5020,5021,5022,5023,5024,5025,5026,5027,5028,5029,5030,5031,5032,5033,5034,5035,5036,5037,5038,5039,5040,5041,5042,5043,5044,5045],
    "paris":[5046,5047,5048,5049,5050,5051,5052,5053,5054,5055,5056,5057,5058,5059,5060,5061,5062,5063,5064,5065,5066,5067,5068,5069,5070,5071,5072,5073,5074,5075,5076,5077,5078,5079,5080,5081,5082,5083,5084,5085,5086,5087,5088,5089,5090,5091,5092,5093,5094,5095,5096,5097,5098,5099,5100,5101,5102,5103,5104,5105,5106,5107,5108,5109,5110,5111,5112,5113,5114,5115,5116,5117,5118,5119,5120,5121,5122,5123,5124,5125,5126,5127,5128,5129,5130,5131,5132,5133,5134,5135,5136,5137,5138,5139,5140,5141,5142,5143,5144,5145,5146,5147,5148,5149,5150,5151,5152,5153,5154,5155,5156,5157,5158,5159,5160,5161,5162,5163,5164,5165,5166,5167,5168,5169,5170,5171,5172,5173,5174,5175,5176,5177,5178,5179,5180,5181,5182,5183,5184,5185,5186,5187,5188,5189,5190,5191,5192,5193,5194,5195,5196,5197,5198,5199,5200,5201,5202,5203,5204,5205,5206,5207,5208,5209,5210,5211,5212,5213,5214,5215,5216,5217,5218,5219,5220,5221,5222,5223,5224,5225,5226,5227,5228,5229,5230,5231,5232,5233,5234,5235,5236,5237,5238,5239,5240,5241,5242,5243,5244,5245,5246,5247,5248,5249,5250,5251,5252,5253,5254,5255,5256,5257,5258,5259,5260,5261,5262,5263,5264,5265,5266,5267,5268,5269,5270,5271,5272,5273,5274,5275,5276,5277,5278,5279,5280,5281,5282,5283,5284,5285,5286,5287,5288,5289,5290,5291,5292,5293,5294,5295,5296,5297,5298,5299,5300,5301,5302,5303,5304,5305,5306,5307,5308,5309,5310,5311,5312,5313,5314,5315,5316,5317,5318,5319,5320,5321,5322,5323,5324,5325,5326,5327,5328,5329,5330,5331,5332,5333,5334,5335,5336,5337,5338,5339,5340,5341,5342,5343,5344,5345],
    "sapienza":[5346,5347,5348,5349,5350,5351,5352,5353,5354,5355,5356,5357,5358,5359,5360,5361,5362,5363,5364,5365,5366,5367,5368,5369,5370,5371,5372,5373,5374,5375,5376,5377,5378,5379,5380,5381,5382,5383,5384,5385,5386,5387,5388,5389,5390,5391,5392,5393,5394,5395,5396,5397,5398,5399,5400,5401,5402,5403,5404,5405,5406,5407,5408,5409,5410,5411,5412,5413,5414,5415,5416,5417,5418,5419,5420,5421,5422,5423,5424,5425,5426,5427,5428,5429,5430,5431,5432,5433,5434,5435,5436,5437,5438,5439,5440,5441,5442,5443,5444,5445,5446,5447,5448,5449,5450,5451,5452,5453,5454,5455,5456,5457,5458,5459,5460,5461,5462,5463,5464,5465,5466,5467,5468,5469,5470,5471,5472,5473,5474,5475,5476,5477,5478,5479,5480,5481,5482,5483,5484,5485,5486,5487,5488,5489,5490,5491,5492,5493,5494,5495,5496,5497,5498,5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514,5515,5516,5517,5518,5519,5520,5521,5522,5523,5524,5525,5526,5527,5528,5529,5530,5531,5532,5533,5534,5535,5536,5537,5538,5539,5540,5541,5542,5543,5544,5545,5546,5547,5548,5549,5550,5551,5552,5553,5554,5555,5556,5557,5558,5559,5560,5561,5562,5563,5564,5565,5566,5567,5568,5569,5570,5571,5572,5573,5574,5575,5576,5577,5578,5579,5580,5581,5582,5583,5584,5585,5586,5587,5588,5589,5590,5591,5592,5593,5594,5595,5596,5597,5598,5599,5600,5601,5602,5603,5604,5605,5606,5607,5608,5609,5610,5611,5612,5613,5614,5615,5616,5617,5618,5619,5620,5621,5622,5623,5624,5625,5626,5627,5628,5629,5630,5631,5632,5633,5634,5635,5636,5637,5638,5639,5640,5641,5642],
    "marrakesh":[5643,5644,5645,5646,5647,5648,5649,5650,5651,5652,5653,5654,5655,5656,5657,5658,5659,5660,5661,5662,5663,5664,5665,5666,5667,5668,5669,5670,5671,5672,5673,5674,5675,5676,5677,5678,5679,5680,5681,5682,5683,5684,5685,5686,5687,5688,5689,5690,5691,5692,5693,5694,5695,5696,5697,5698,5699,5700,5701,5702,5703,5704,5705,5706,5707,5708,5709,5710,5711,5712,5713,5714,5715,5716,5717,5718,5719,5720,5721,5722,5723,5724,5725,5726,5727,5728,5729,5730,5731,5732,5733,5734,5735,5736,5737,5738,5739,5740,5741,5742,5743,5744,5745,5746,5747,5748,5749,5750,5751,5752,5753,5754,5755,5756,5757,5758,5759,5760,5761,5762,5763,5764,5765,5766,5767,5768,5769,5770,5771,5772,5773,5774,5775,5776,5777,5778,5779,5780,5781,5782,5783,5784,5785,5786,5787,5788,5789,5790,5791,5792,5793,5794,5795,5796,5797,5798,5799,5800,5801,5802,5803,5804,5805,5806,5807,5808,5809,5810,5811,5812,5813,5814,5815,5816,5817,5818,5819,5820,5821,5822,5823,5824,5825,5826,5827,5828,5829,5830,5831,5832,5833,5834,5835,5836,5837,5838,5839,5840,5841,5842,5843,5844,5845,5846,5847,5848,5849,5850,5851,5852,5853,5854,5855,5856,5857,5858,5859,5860,5861,5862,5863,5864,5865,5866,5867,5868,5869,5870,5871,5872,5873,5874,5875,5876,5877,5878,5879,5880,5881,5882,5883,5884,5885,5886,5887,5888,5889,5890,5891,5892,5893,5894,5895,5896,5897,5898,5899,5900,5901,5902,5903,5904,5905,5906,5907,5908,5909,5910,5911,5912,5913,5914,5915,5916,5917,5918,5919,5920,5921,5922,5923,5924,5925,5926,5927,5928,5929,5930,5931,5932],
    "bangkok":[5933,5934,5936,5937,5938,5939,5940,5941,5942,5943,5944,5945,5946,5947,5948,5949,5950,5951,5952,5953,5954,5955,5956,5957,5958,5959,5960,5961,5962,5963,5964,5965,5966,5967,5968,5969,5970,5971,5972,5973,5974,5975,5976,5977,5978,5979,5980,5981,5982,5983,5984,5985,5986,5987,5988,5989,5990,5991,5992,5993,5994,5995,5996,5997,5998,5999,6000,6001,6002,6003,6004,6005,6006,6007,6008,6009,6010,6011,6012,6013,6014,6015,6016,6017,6018,6019,6020,6021,6022,6023,6024,6025,6026,6027,6028,6029,6030,6031,6032,6033,6034,6035,6036,6037,6038,6039,6040,6041,6042,6043,6044,6045,6046,6047,6048,6049,6050,6051,6052,6053,6054,6055,6056,6057,6058,6059,6060,6061,6062,6063,6064,6065,6066,6067,6068,6069,6070,6071,6072,6073,6074,6075,6076,6077,6078,6079,6080,6081,6082,6083,6084,6085,6086,6087,6088,6089,6090,6091,6092,6093,6094,6095,6096,6097,6098,6099,6100,6101,6102,6103,6104,6105,6106,6107,6