from ..Locations import Loc as Data

# https://xenoblade.github.io/xbx/bdat/common_local_us/BTL_EnBook.html
# flake8: noqa
enemies_data: list[Data] = [
Data("Origin Blatta"),
Data("Callow Grex"),
Data("Elder Grex"),
Data("Volkampf, the Pursuer"),
Data("Glennar"),
Data("Goetia"),
Data("Tainted Sphinx"),
Data("Almandal"),
Data("Dagahn"),
Data("Ryyz"),
Data("Wrothian Enacter"),
Data("Wrothian Sneaker"),
Data("Ga Jiarg"),
Data("Ga Buidhe"),
Data("Vasara"),
Data("Deva Caladar"),
Data("Caladar"),
Data("Zu Pharg"),
Data("Prog Ares"),
Data("Vita"),
Data("Shield Satellis"),
Data("Strike Satellis"),
Data("Link Satellis"),
Data("Enhancer Satellis"),
Data("Pursuit Satellis Alpha"),
Data("Pursuit Satellis Beta"),
Data("Pursuit Satellis Gamma"),
Data("Soldier Chimera"),
Data("Lao", regions=["Chapter 12"]),
Data("Queen Chimera"),
Data("Minor Chimera"),
Data("Mezzo Chimera"),
Data("Major Chimera"),
Data("Nardacyon, the Shadowless"),
Data("Lugalbanda, the Wanderer-King"),
Data("Vortice, the Deific Blast"),
Data("Leva'el, the Terminus"),
Data("Sentinel Satellis"),
Data("Atreides, the Distinguished"),
Data("Gesserith, the Wileworm"),
Data("Pharsis, the Everqueen"),
Data("Pyotr, the Shepherd"),
Data("Heidi, the Lively"),
Data("Claire, the Sheltered"),
Data("Shuravas, the Enraged"),
Data("Dadaan, the Strongest Prone"),
Data("The Dadaan Girls"),
Data("Dadaan Squad Member"),
Data("Gradivus, the Headless Emperor"),
Data("Telethia, the Endbringer", regions=["Chapter 12"]),
Data("HH100: Hierana"),
Data("Briggs"),
Data("Fosdyke"),
Data("Moorehouse"),
Data("Cross Qmoeva"),
Data("Lightning Strike"),
Data("Lineage"),
Data("Brutal Prone"),
Data("Blood Despair"),
Data("Grenade Pizza F"),
Data("Twin Qmoeva"),
Data("Ajiba Falgo"),
Data("Mujiba Falgo"),
Data("Galba Vassago"),
Data("Leroy's Ire"),
Data("Loda Gorida"),
Data("Odsent"),
Data("Slovity Pagus_1"),
Data("MG062: Megisia"),
Data("MG068: Megisia"),
Data("Harvey"),
Data("Nopopon Incarnate"),
Data("Napopon Incarnate"),
Data("Nipopon Incarnate"),
Data("Nupopon Incarnate"),
Data("Gi Ziorde"),
Data("EN090503_NAME_F00_1", valid=False),
Data("EN090503_NAME_F00_2", valid=False),
Data("Gi Ziordo"),
Data("Zo Zazhi"),
Data("Sazon Caladar"),
Data("Soghu Caladar"),
Data("De Ezich"),
Data("Naguth Caladar"),
Data("Girhi Caladar"),
Data("Zeulbe Caladar"),
Data("Ladha Caladar"),
Data("Ga Bewhe"),
Data("Slovity Pagus_2"),
Data("Gwin_1"),
Data("Ozuchi Caladar"),
Data("EN090503_NAME_F00_3", valid=False),
Data("JS178: Jushe"),
Data("Gold Courage"),
Data("SG002: Slenna"),
Data("ER001: Emeroa"),
Data("HP001: Harriess"),
Data("JD001: Juda"),
Data("Rexoskell"),
Data("DE913: Dieara"),
Data("EN090503_NAME_F00_4", valid=False),
Data("Dolba the Wrecker"),
Data("Gadd"),
Data("MO037: Moore"),
Data("Gi Zang"),
Data("EN090503_NAME_F00_5", valid=False),
Data("LV757: Lyvia"),
Data("Gwin_2"),
Data("ST816: Stalio"),
Data("Blood-king Gelvo Banth"),
Data("Running Shark"),
Data("Interfearence"),
Data("Alexa Special"),
Data("SN333: Jisanne"),
Data("Pawn Puge"),
Data("Dagger Puge"),
Data("Sword Puge"),
Data("Buster Puge"),
Data("Lance Puge"),
Data("EN090503_NAME_F00_6", valid=False),
Data("Prototype Puge"),
Data("EN090503_NAME_F00_7", valid=False),
Data("Knight Puge"),
Data("Guardian Puge"),
Data("EN090503_NAME_F00_8", valid=False),
Data("Night Combat Puge"),
Data("Pawn Pugilith"),
Data("Dagger Pugilith"),
Data("Sword Pugilith"),
Data("EN090503_NAME_F00_9", valid=False),
Data("EN090503_NAME_F00_10", valid=False),
Data("Master Pugilith"),
Data("Raider Pugilith"),
Data("Knight Pugilith"),
Data("Guardian Pugilith"),
Data("EN090503_NAME_F00_11", valid=False),
Data("High-Output Pugilith"),
Data("EN090503_NAME_F00_12", valid=False),
Data("Talon Raptor Galdr"),
Data("Talon Eagle Galdr"),
Data("Armed Recon Galdr"),
Data("EN090503_NAME_F00_13", valid=False),
Data("EN090503_NAME_F00_14", valid=False),
Data("Revolver Eagle Galdr"),
Data("Armed Engineer Galdr"),
Data("Guide Owl Galdr"),
Data("Guide Raptor Galdr"),
Data("Guide Eagle Galdr"),
Data("Air Support Galdr"),
Data("EN090503_NAME_F00_15", valid=False),
Data("EN090503_NAME_F00_16", valid=False),
Data("Gun Eagle Galdr"),
Data("Armed Destroyer Galdr"),
Data("Lyla's Galdr"),
Data("Chantai's Galdr"),
Data("Duran's Galdr"),
Data("EN090503_NAME_F00_17", valid=False),
Data("Green Lance Galdr"),
Data("Vendura's Galdr"),
Data("Drone Pawn Quo"),
Data("Drone Knight Quo"),
Data("Drone Rook Quo"),
Data("Drone Queen Quo"),
Data("Drone King Quo"),
Data("Logistical Support Quo"),
Data("EN090503_NAME_F00_18", valid=False),
Data("Machine Rook Quo"),
Data("Machine Queen Quo"),
Data("Machine King Quo"),
Data("Frontline Medic Quo"),
Data("Rubidium Oc-serv"),
Data("EN090503_NAME_F00_19", valid=False),
Data("EN090503_NAME_F00_20", valid=False),
Data("Titanium Oc-serv"),
Data("Oc-serv, the Ancient"),
Data("Selenium Oc-serv"),
Data("Tantalum Oc-serv"),
Data("Rhenium Oc-serv"),
Data("Na-mulk, the Rebellious"),
Data("Tellurium Oc-serv"),
Data("Niobium Oc-serv"),
Data("Thallium Oc-serv"),
Data("Bismuth Oc-serv"),
Data("Si-el, the Vacuous"),
Data("Chromium Oc-serv"),
Data("EN090503_NAME_F00_21", valid=False),
Data("Ro-darm, the Demon Claw"),
Data("Talon Knight Qmoeva"),
Data("EN090503_NAME_F00_22", valid=False),
Data("Talon Queen Qmoeva"),
Data("Talon King Qmoeva"),
Data("Infantry Support Qmoeva"),
Data("Palace Knight Qmoeva"),
Data("EN090503_NAME_F00_23", valid=False),
Data("Palace Queen Qmoeva"),
Data("Palace King Qmoeva"),
Data("Multi Knight Qmoeva"),
Data("Multi Rook Qmoeva"),
Data("Multi Queen Qmoeva"),
Data("EN090503_NAME_F00_24", valid=False),
Data("Intermediate Arsenal Qmoeva"),
Data("Suppressor Knight Qmoeva"),
Data("Suppressor Rook Qmoeva"),
Data("Suppressor Queen Qmoeva"),
Data("EN090503_NAME_F00_25", valid=False),
Data("Daril's Qmoeva"),
Data("EN090503_NAME_F00_26", valid=False),
Data("War Emperor Qmoeva"),
Data("War Kaizer Qmoeva"),
Data("Urdu's Qmoeva"),
Data("Sadar's Qmoeva"),
Data("Enhanced Attack Seidr"),
Data("Armored Cruiser Seidr"),
Data("Enhanced Defense Seidr"),
Data("EN090503_NAME_F00_27", valid=False),
Data("Sharnaak's Seidr"),
Data("Badul's Seidr"),
Data("Ahama's Seidr"),
Data("Orion Xern"),
Data("Luxaar's Xern"),
Data("Fleet Shrad"),
Data("Quick Shrad"),
Data("Swift Shrad"),
Data("Jet Shrad"),
Data("Sector Security Shrad"),
Data("EN090503_NAME_F00_28", valid=False),
Data("Rocket Shrad"),
Data("Mach Shrad"),
Data("Experimental Flight Shrad"),
Data("Du-rha, the Imprisoned"),
Data("Strontium Xe-dom"),
Data("Gi-zho, the Iron Deity"),
Data("Molybdenum Xe-dom"),
Data("Bismuth Xe-dom"),
Data("Go-rha, the Guardian Deity"),
Data("EN090503_NAME_F00_29", valid=False),
Data("Strike Barrager Zig"),
Data("Strike Gunner Zig"),
Data("Strike Launcher Zig"),
Data("Experimental Compact Zig"),
Data("EN090503_NAME_F00_30", valid=False),
Data("Revolver Barrager Zig"),
Data("Revolver Gunner Zig"),
Data("EN090503_NAME_F00_31", valid=False),
Data("Enhanced Search Zig"),
Data("Mortar Sniper Zig"),
Data("EN090503_NAME_F00_32", valid=False),
Data("Mortar Gunner Zig"),
Data("Mortar Launcher Zig"),
Data("Unlimited Output Zig"),
Data("EN090503_NAME_F00_33", valid=False),
Data("Palace Barrager Zig"),
Data("EN090503_NAME_F00_34", valid=False),
Data("EN090503_NAME_F00_35", valid=False),
Data("Enhanced Support Zig"),
Data("EN090503_NAME_F00_36", valid=False),
Data("Assault Barrager Zig"),
Data("Assault Gunner Zig"),
Data("Assault Launcher Zig"),
Data("Damaged Zig"),
Data("EN090503_NAME_F00_37", valid=False),
Data("Vulcan Barrager Zig"),
Data("Vulcan Gunner Zig"),
Data("Vulcan Launcher Zig"),
Data("Experimental Second-Gen Zig"),
Data("EN090503_NAME_F00_38", valid=False),
Data("Howitzer Barrager Zig"),
Data("Howitzer Gunner Zig"),
Data("Howitzer Launcher Zig"),
Data("Enhanced Attack Range Zig"),
Data("EN090503_NAME_F00_39", valid=False),
Data("Enhanced Barrager Zig"),
Data("Enhanced Gunner Zig"),
Data("Enhanced Launcher Zig"),
Data("Frontline Surveillance Zig"),
Data("EN090503_NAME_F00_40", valid=False),
Data("EN090503_NAME_F00_41", valid=False),
Data("Rubidium Fal-swo"),
Data("Thallium Fal-swo"),
Data("Ji-ett, the Thunderclap"),
Data("Selenium Fal-swo"),
Data("Rhenium Fal-swo"),
Data("Ya-rhat, the Thundercloud"),
Data("Stainless Fal-swo"),
Data("Tellurium Fal-swo"),
Data("Chromium Fal-swo"),
Data("Ga-uhl, the Precept-Keeper"),
Data("EN090503_NAME_F00_42", valid=False),
Data("EN090503_NAME_F00_43", valid=False),
Data("Marnuck Admiral"),
Data("EN090503_NAME_F00_44", valid=False),
Data("Sadar, the Unhinged"),
Data("EN090503_NAME_F00_45", valid=False),
Data("EN090503_NAME_F00_46", valid=False),
Data("EN090503_NAME_F00_47", valid=False),
Data("EN090503_NAME_F00_48", valid=False),
Data("Gadaf, the Pulverizer"),
Data("EN090503_NAME_F00_49", valid=False),
Data("EN090503_NAME_F00_50", valid=False),
Data("EN090503_NAME_F00_51", valid=False),
Data("EN090503_NAME_F00_52", valid=False),
Data("Duran, the Draconian"),
Data("EN090503_NAME_F00_53", valid=False),
Data("EN090503_NAME_F00_54", valid=False),
Data("EN090503_NAME_F00_55", valid=False),
Data("EN090503_NAME_F00_56", valid=False),
Data("Daril, the Eradicator"),
Data("Ahama, the Covetous"),
Data("Berserker Marnuck"),
Data("Milsaadi Fighter"),
Data("Milsaadi Hunter"),
Data("Milsaadi Assassin"),
Data("Sharnaak, the Technician"),
Data("Milsaadi Executioner"),
Data("Milsaadi Specter"),
Data("Badul, the One-Eyed"),
Data("EN090503_NAME_F00_57", valid=False),
Data("Milsaadi Rampager"),
Data("Milsaadi Savage"),
Data("Chantai, the Insect Maiden"),
Data("Milsaadi Hitman"),
Data("Milsaadi Champion"),
Data("Lyla, the Lustrous"),
Data("EN090503_NAME_F00_58", valid=False),
Data("Goliath Sylooth"),
Data("Brobdingnagian Sylooth"),
Data("Yama, the Obliviator"),
Data("EN090503_NAME_F00_59", valid=False),
Data("EN090503_NAME_F00_60", valid=False),
Data("Gaia Gularth"),
Data("Ilithios, the Enlightened"),
Data("Mountain Sylooth"),
Data("Territorial Sylooth"),
Data("Anselm, the Triumphant"),
Data("Alithios, the Indignant"),
Data("Canyon Sylooth"),
Data("EN090503_NAME_F00_61", valid=False),
Data("EN090503_NAME_F00_62", valid=False),
Data("Climati, the Chilling Wind"),
Data("EN090503_NAME_F00_63", valid=False),
Data("EN090503_NAME_F00_64", valid=False),
Data("EN090503_NAME_F00_65", valid=False),
Data("EN090503_NAME_F00_66", valid=False),
Data("EN090503_NAME_F00_67", valid=False),
Data("EN090503_NAME_F00_68", valid=False),
Data("EN090503_NAME_F00_69", valid=False),
Data("EN090503_NAME_F00_70", valid=False),
Data("EN090503_NAME_F00_71", valid=False),
Data("EN090503_NAME_F00_72", valid=False),
Data("EN090503_NAME_F00_73", valid=False),
Data("EN090503_NAME_F00_74", valid=False),
Data("EN090503_NAME_F00_75", valid=False),
Data("EN090503_NAME_F00_76", valid=False),
Data("Vendura, the Spellbinder"),
Data("Definian Copy"),
Data("Definian Clone"),
Data("WR512: Urdu"),
Data("Neodymium Petramand"),
Data("Ytterby Petramand"),
Data("Malium Petramand"),
Data("Caesar, the Hundred-Eyed"),
Data("Grassland Scirpo"),
Data("Tree Scirpo"),
Data("Green Scirpo"),
Data("Wood Scirpo"),
Data("Native Scirpo"),
Data("Merciful Scirpo"),
Data("Yelena, the Sequestered"),
Data("EN090503_NAME_F00_77", valid=False),
Data("Lantern Petramand"),
Data("Ceres Petramand"),
Data("Lutetia Petramand"),
Data("Candelario, the Bronze"),
Data("Thulium Petramand"),
Data("Samarium Petramand"),
Data("Gadolinium Petramand"),
Data("Erbium Petramand"),
Data("Eisen, the Ebon Rock"),
Data("Lepidolite Scirpo"),
Data("Lapis Scirpo"),
Data("Jade Scirpo"),
Data("Citrine Scirpo"),
Data("EN090503_NAME_F00_78", valid=False),
Data("Garnet Scirpo"),
Data("Desdemona, the Subterranean"),
Data("Beach Forfex"),
Data("Sea Forfex"),
Data("Coral Forfex"),
Data("Hydro Forfex"),
Data("Ocean Forfex"),
Data("Raging Forfex"),
Data("Sven, the Sturdy"),
Data("Sand Forfex"),
Data("Land Forfex"),
Data("EN090503_NAME_F00_79", valid=False),
Data("Native Forfex"),
Data("Tourteau, the Delectable"),
Data("Violet Forfex"),
Data("Cobalt Forfex"),
Data("Viridian Forfex"),
Data("EN090503_NAME_F00_80", valid=False),
Data("Lazuli Forfex"),
Data("Schneider, the Cliffpercher"),
Data("EN090503_NAME_F00_81", valid=False),
Data("EN090503_NAME_F00_82", valid=False),
Data("Nectar Scirpo"),
Data("Haoma Scirpo"),
Data("Kvass Scirpo"),
Data("Elena, the Infernal"),
Data("EN090503_NAME_F00_83", valid=False),
Data("EN090503_NAME_F00_84", valid=False),
Data("Praseodymium Petramand"),
Data("Europium Petramand"),
Data("EN090503_NAME_F00_85", valid=False),
Data("EN090503_NAME_F00_86", valid=False),
Data("Truppe, the Ceaseless Dark"),
Data("Dysprosium Petramand"),
Data("Terbium Petramand"),
Data("Lutetium Petramand"),
Data("Piernus, the Scorcher"),
Data("EN090503_NAME_F00_87", valid=False),
Data("Copper Cinicula"),
Data("Bronze Cinicula"),
Data("Iron Cinicula"),
Data("EN090503_NAME_F00_88", valid=False),
Data("Eckart, the Indestructible"),
Data("Lake Falsaxum"),
Data("Ghillie Falsaxum"),
Data("EN090503_NAME_F00_89", valid=False),
Data("EN090503_NAME_F00_90", valid=False),
Data("Clemente, the Iron Meteor"),
Data("EN090503_NAME_F00_91", valid=False),
Data("EN090503_NAME_F00_92", valid=False),
Data("Lava Cinicula"),
Data("Calore, the Lava Walker"),
Data("EN090503_NAME_F00_93", valid=False),
Data("EN090503_NAME_F00_94", valid=False),
Data("Shadow Falsaxum"),
Data("EN090503_NAME_F00_95", valid=False),
Data("Mikulas, the Keystone"),
Data("EN090503_NAME_F00_96", valid=False),
Data("EN090503_NAME_F00_97", valid=False),
Data("Translucent Cinicula"),
Data("EN090503_NAME_F00_98", valid=False),
Data("Glowing Cinicula"),
Data("EN090503_NAME_F00_99", valid=False),
Data("Thaddaeus, the Ultramafic"),
Data("EN090503_NAME_F00_100", valid=False),
Data("Falchion, the Vibrant"),
Data("EN090503_NAME_F00_101", valid=False),
Data("EN090503_NAME_F00_102", valid=False),
Data("Carrion Vivohast"),
Data("Grand Vivohast"),
Data("Lethal Vivohast"),
Data("Lockhart, the Killer of Hope"),
Data("Echo Thallus"),
Data("False Thallus"),
Data("EN090503_NAME_F00_103", valid=False),
Data("Cunning Thallus"),
Data("Pizelle, the Purple Lightning"),
Data("Recluse Thallus"),
Data("Faded Thallus"),
Data("EN090503_NAME_F00_104", valid=False),
Data("Edgardo, the Carefree"),
Data("Hermit Tectinsula"),
Data("Negator Tectinsula"),
Data("Silhouette Tectinsula"),
Data("Stealth Tectinsula"),
Data("EN090503_NAME_F00_105", valid=False),
Data("EN090503_NAME_F00_106", valid=False),
Data("Soil Tectinsula"),
Data("Clay Tectinsula"),
Data("Tectonic Tectinsula"),
Data("Vittorio, the Battle-Scarred"),
Data("Smalt Arenatect"),
Data("Cerulean Arenatect"),
Data("Turqoise Arenatect"),
Data("Man'an, the Water Whisperer"),
Data("EN090503_NAME_F00_107", valid=False),
Data("EN090503_NAME_F00_108", valid=False),
Data("Saffron Arenatect"),
Data("Topaz Arenatect"),
Data("Antara, the Water Diviner"),
Data("Pebble Blatta"),
Data("Swift Blatta"),
Data("Tough Blatta"),
Data("Black Blatta"),
Data("Dark Blatta"),
Data("Hell Blatta"),
Data("Casper, the Unhealthy Eater"),
Data("Egg Blatta"),
Data("Lava Blatta"),
Data("Chrysalis Blatta"),
Data("Guise Blatta"),
Data("Young Blatta"),
Data("EN090503_NAME_F00_109", valid=False),
Data("Prinsipe, the Ravenous"),
Data("Creeping Blatta"),
Data("Sneaking Blatta"),
Data("Stalker Blatta"),
Data("Crawler Blatta"),
Data("Judge Blatta"),
Data("Cursed Blatta"),
Data("Joker, the Unknowable"),
Data("Agito, the Golden"),
Data("Roimi, the Affluent"),
Data("Muruse, the Opulent"),
Data("Yuiro, the Luxuriant"),
Data("Dui, the Invaluable"),
Data("Tico, the Precious"),
Data("Hiro, the Priceless"),
Data("Ald, the Extravagant"),
Data("Camus, the Treasured"),
Data("Natt, the Inestimable"),
Data("White Blatta"),
Data("Metal Blatta"),
Data("Wootz Blatta"),
Data("Platinum Blatta"),
Data("Diamond Blatta"),
Data("Crystal Blatta"),
Data("Vorpall, the Sickle-Fanged"),
Data("Dove Turba"),
Data("Lark Turba"),
Data("Kite Turba"),
Data("Crane Turba"),
Data("Tormenta, the Scarlet-Clad"),
Data("Miniature Adsecula"),
Data("Shadow Adsecula"),
Data("Savanna Adsecula"),
Data("Dusk Adsecula"),
Data("Umbral Adsecula"),
Data("Photon Adsecula"),
Data("Etutanne, the Bloodthirsty"),
Data("EN090503_NAME_F00_110", valid=False),
Data("Honey Papil"),
Data("Lake Papil"),
Data("River Papil"),
Data("Silver Papil"),
Data("Gold Papil"),
Data("EN090503_NAME_F00_111", valid=False),
Data("Drone Adsecula"),
Data("Recluse Adsecula"),
Data("Faded Adsecula"),
Data("Mirage Adsecula"),
Data("Ghost Adsecula"),
Data("Bertrand, the Gorge Scourge"),
Data("Druid Papil"),
Data("Sorcerer Papil"),
Data("Witch Papil"),
Data("Wizard Papil"),
Data("Magus Papil"),
Data("Sacrum, the Noctilucent"),
Data("EN090503_NAME_F00_112", valid=False),
Data("Indigo Turba"),
Data("EN090503_NAME_F00_113", valid=False),
Data("Adonis Turba"),
Data("Delft Turba"),
Data("EN090503_NAME_F00_114", valid=False),
Data("Feld, the Indigo-Clad"),
Data("Violet Germivore"),
Data("Cobalt Germivore"),
Data("Viridian Germivore"),
Data("Saffron Germivore"),
Data("EN090503_NAME_F00_115", valid=False),
Data("Carmine Germivore"),
Data("Lomoth, the Beast-Eater"),
Data("Skulker Germivore"),
Data("Echo Germivore"),
Data("Shadow Germivore"),
Data("Secret Germivore"),
Data("Survivor Germivore"),
Data("Lethal Germivore"),
Data("Florence, the Hell Maggot"),
Data("Squallo, the Sand Mirer"),
Data("EN090503_NAME_F00_116", valid=False),
Data("EN090503_NAME_F00_117", valid=False),
Data("Sandy Sabula"),
Data("Inferno Ictus"),
Data("Immortal Ictus"),
Data("Valyrian, the Iron Cleaver"),
Data("EN090503_NAME_F00_118", valid=False),
Data("Sand Aeviter"),
Data("Macabre Aeviter"),
Data("Berthold, the Blue-Eyed"),
Data("EN090503_NAME_F00_119", valid=False),
Data("Frightening Ictus"),
Data("Fearsome Ictus"),
Data("EN090503_NAME_F00_120", valid=False),
Data("Belenguer, the Gunhammer"),
Data("Warlord Ictus"),
Data("Chieftain Ictus"),
Data("Daimyo Ictus"),
Data("Terenty, the Blademaster"),
Data("Balduino, the Wicked-Eyed"),
Data("Flame Lophid"),
Data("Blast Lophid"),
Data("Burning Lophid"),
Data("Izgnanie, the Smoldering"),
Data("EN090503_NAME_F00_121", valid=False),
Data("EN090503_NAME_F00_122", valid=False),
Data("EN090503_NAME_F00_123", valid=False),
Data("Albin, the Wicked Meddler"),
Data("Darling Purgovent"),
Data("Ocean Lophid"),
Data("Marine Lophid"),
Data("Ridill, the Arrogant"),
Data("Coral Purgovent"),
Data("Ocean Purgovent"),
Data("EN090503_NAME_F00_124", valid=False),
Data("Cave Duoguill"),
Data("Placid Duoguill"),
Data("Nether Duoguill"),
Data("Blood Duoguill"),
Data("Lethal Duoguill"),
Data("Hephaestus, the Absconder"),
Data("Electric Scintimure"),
Data("Blitz Scintimure"),
Data("Thunder Scintimure"),
Data("EN090503_NAME_F00_125", valid=False),
Data("Eddy, the Electric Heat"),
Data("Thunder Duoguill"),
Data("EN090503_NAME_F00_126", valid=False),
Data("Electro Duoguill"),
Data("Plasma Duoguill"),
Data("Valeriano, the Rolling Thunder"),
Data("EN090503_NAME_F00_127", valid=False),
Data("EN090503_NAME_F00_128", valid=False),
Data("EN090503_NAME_F00_129", valid=False),
Data("Blind Scintimure"),
Data("Zohan, the Thunderbolt"),
Data("Tainted Scintimure"),
Data("EN090503_NAME_F00_130", valid=False),
Data("Glimmering Scintimure"),
Data("Bright Scintimure"),
Data("Statue Scintimure"),
Data("Legato, the Sky Watcher"),
Data("Coil, the Never-Ending"),
Data("EN090503_NAME_F00_131", valid=False),
Data("Sky Aetrygon"),
Data("Lofty Aetrygon"),
Data("EN090503_NAME_F00_132", valid=False),
Data("Ramus, the Supersonic"),
Data("EN090503_NAME_F00_133", valid=False),
Data("Beach Xiphias"),
Data("Sea Xiphias"),
Data("Coral Xiphias"),
Data("Ocean Xiphias"),
Data("EN090503_NAME_F00_134", valid=False),
Data("EN090503_NAME_F00_135", valid=False),
Data("Quick Aetrygon"),
Data("Fleet Aetrygon"),
Data("Vilem, the Gold-Scaled"),
Data("EN090503_NAME_F00_136", valid=False),
Data("EN090503_NAME_F00_137", valid=False),
Data("Cave Xiphias"),
Data("Brandys, the Spectral Light"),
Data("EN090503_NAME_F00_138", valid=False),
Data("EN090503_NAME_F00_139", valid=False),
Data("Draken, the Drifting Cloud"),
Data("EN090503_NAME_F00_140", valid=False),
Data("Valiant Ceto"),
Data("Vanguard Ceto"),
Data("Polaris, the Firmamental"),
Data("EN090503_NAME_F00_141", valid=False),
Data("Coral Balaena"),
Data("Sea Balaena"),
Data("Ocean Balaena"),
Data("Rajidi, the Cumuliform"),
Data("Lunar Ceto"),
Data("Selenic Ceto"),
Data("Elaine, the Lunar Eclipse"),
Data("Young Grex"),
Data("Bush Grex"),
Data("Giant Grex"),
Data("Lawless Grex"),
Data("Dieter, the Epicure"),
Data("EN090503_NAME_F00_142", valid=False),
Data("Lava Caro"),
Data("Servant Caro"),
Data("Deadland Caro"),
Data("Kringe, the Hunting Arrow"),
Data("Tainted Caro"),
Data("Soldier Grex"),
Data("Hunter Grex"),
Data("Scourer Grex"),
Data("EN090503_NAME_F00_143", valid=False),
Data("Celedonio, the Battle-Tested"),
Data("Sand Caro"),
Data("Prisoner Caro"),
Data("Spaniel, the Obedient"),
Data("EN090503_NAME_F00_144", valid=False),
Data("Legion Caro"),
Data("Arch Caro"),
Data("Lost Caro"),
Data("Andrei, the Cunning"),
Data("Little Caro"),
Data("Berserk Vigent"),
Data("Brutal Vigent"),
Data("Barnabas, the Despot"),
Data("Fiendish Virago"),
Data("EN090503_NAME_F00_145", valid=False),
Data("Buchwald, the Guardian"),
Data("EN090503_NAME_F00_146", valid=False),
Data("Seeker Vigent"),
Data("Goliath, the Stronghold"),
Data("Nether Virago"),
Data("Behemoth, the Netherdweller"),
Data("Volcannon Vigent"),
Data("Vainamo, the Bellower"),
Data("Toy Monoceros"),
Data("EN090503_NAME_F00_147", valid=False),
Data("Monoceros Colt"),
Data("EN090503_NAME_F00_148", valid=False),
Data("Uluora, the Burgeoning"),
Data("Hallowed Progen"),
Data("Lightning Progen"),
Data("Sacred Progen"),
Data("Sanctuary Progen"),
Data("Celestin, the Spring Storm"),
Data("EN090503_NAME_F00_149", valid=False),
Data("Viridian Monoceros"),
Data("EN090503_NAME_F00_150", valid=False),
Data("Alexei, the Jade"),
Data("Wise Progen"),
Data("Ancient Progen"),
Data("EN090503_NAME_F00_151", valid=False),
Data("Ernest, the Contemplative"),
Data("Cliff Monoceros"),
Data("Land Monoceros"),
Data("Volcannon Monoceros"),
Data("Dawid, the Destrier"),
Data("White Progen"),
Data("EN090503_NAME_F00_152", valid=False),
Data("Mountain Progen"),
Data("Blaudolch, the Chalcedony"),
Data("Young Simius"),
Data("Rock Simius"),
Data("Iron Simius"),
Data("Blitz Simius"),
Data("EN090503_NAME_F00_153", valid=False),
Data("Hayreddin, the Territorial"),
Data("Juvenile Simius"),
Data("EN090503_NAME_F00_154", valid=False),
Data("Canyon Cantor"),
Data("Cave Cantor"),
Data("Origin Cantor"),
Data("Eustachio, the Eccentric"),
Data("Raging Simius"),
Data("Angry Simius"),
Data("Furious Simius"),
Data("Wrathful Simius"),
Data("Punisher Simius"),
Data("Demetrio, the Tempestuous"),
Data("EN090503_NAME_F00_155", valid=False),
Data("Recluse Cantor"),
Data("Leandro, the Sneering"),
Data("EN090503_NAME_F00_156", valid=False),
Data("EN090503_NAME_F00_157", valid=False),
Data("Daylight Aprica"),
Data("EN090503_NAME_F00_158", valid=False),
Data("EN090503_NAME_F00_159", valid=False),
Data("EN090503_NAME_F00_160", valid=False),
Data("Shaman Cervus"),
Data("Pastoral Cervus"),
Data("Seti, the Light of Stars"),
Data("Wise Aprica"),
Data("EN090503_NAME_F00_161", valid=False),
Data("Primal Aprica"),
Data("Sviatoslav, the Reproachful"),
Data("EN090503_NAME_F00_162", valid=False),
Data("Old Cervus"),
Data("Asana, the Azure Star"),
Data("Brass Suid"),
Data("Iron Suid"),
Data("Steel Suid"),
Data("Adamant Suid"),
Data("Silver Suid"),
Data("EN090503_NAME_F00_163", valid=False),
Data("Gugli, the Relentless"),
Data("Megatonne, the Hell Express"),
Data("Little Suid"),
Data("Domestic Armored Suid"),
Data("EN090503_NAME_F00_164", valid=False),
Data("Trained Armored Suid"),
Data("EN090503_NAME_F00_165", valid=False),
Data("Tough Armored Suid"),
Data("Macho Armored Suid"),
Data("Bogdan, the Dense"),
Data("Brass Femina Suid"),
Data("Iron Femina Suid"),
Data("Steel Femina Suid"),
Data("Bronze Femina Suid"),
Data("Silver Femina Suid"),
Data("Melanya, the Sound Sleeper"),
Data("Little Femina Suid"),
Data("River Suid"),
Data("Forest Suid"),
Data("EN090503_NAME_F00_166", valid=False),
Data("Lurker Suid"),
Data("Olegario, the Iron-Helmed"),
Data("EN090503_NAME_F00_167", valid=False),
Data("Forest Femina Suid"),
Data("EN090503_NAME_F00_168", valid=False),
Data("EN090503_NAME_F00_169", valid=False),
Data("Manuelita, the Affectionate"),
Data("Grassland Ovis"),
Data("Docile Ovis"),
Data("Rogue Ovis"),
Data("EN090503_NAME_F00_170", valid=False),
Data("Baabara, the Evangelical"),
Data("EN090503_NAME_F00_171", valid=False),
Data("EN090503_NAME_F00_172", valid=False),
Data("White Ovis"),
Data("Wandering Ovis"),
Data("Native Ovis"),
Data("Clara, the Pure White"),
Data("EN090503_NAME_F00_173", valid=False),
Data("Eternal Millesaur"),
Data("Everlasting Millesaur"),
Data("Fernando, the Immovable"),
Data("Ancient Coronid"),
Data("Xair, the Cerulean Walker"),
Data("Luciel, the Eternal"),
Data("Frenzied Coronid"),
Data("Ignit, the Ultimate Chaos"),
Data("Quick Evello"),
Data("Fleet Evello"),
Data("Swift Evello"),
Data("Roderick, the Fleet-Footed"),
Data("Cowardly Caecus"),
Data("Thug Caecus"),
Data("EN090503_NAME_F00_174", valid=False),
Data("Cliff Caecus"),
Data("Land Caecus"),
Data("Pelicollo, the Panzer"),
Data("Poisonous Caecus"),
Data("Villainous Caecus"),
Data("EN090503_NAME_F00_175", valid=False),
Data("Andrea, the Famished Hunter"),
Data("Wasteland Evello"),
Data("Grand Evello"),
Data("Ludvik, the Picky Eater"),
Data("Spear Insidia"),
Data("Pike Insidia"),
Data("Javelin Insidia"),
Data("Glaive Insidia"),
Data("EN090503_NAME_F00_176", valid=False),
Data("Lambert, the Divine Wind"),
Data("Sludge Caecus"),
Data("Darting Caecus"),
Data("Drake, the Waypost"),
Data("EN090503_NAME_F00_177", valid=False),
Data("Vermilion Insidia"),
Data("Griffus, the Tartarean"),
Data("Feliciano, the All-Seeing"),
Data("EN090503_NAME_F00_178", valid=False),
Data("Bluff Gerrid"),
Data("Land Gerrid"),
Data("EN090503_NAME_F00_179", valid=False),
Data("Bartley, the Conflagration"),
Data("EN090503_NAME_F00_180", valid=False),
Data("Wood Lepyx"),
Data("Prairie Lepyx"),
Data("EN090503_NAME_F00_181", valid=False),
Data("EN090503_NAME_F00_182", valid=False),
Data("Sirene, the Lost"),
Data("Pollen Lepyx"),
Data("Nomad Lepyx"),
Data("EN090503_NAME_F00_183", valid=False),
Data("EN090503_NAME_F00_184", valid=False),
Data("Giraffin, the Old Hand"),
Data("Macabre Gerrid"),
Data("Evil Gerrid"),
Data("Daemon, the Undertaker"),
Data("Plant Mortifole"),
Data("Lake Mortifole"),
Data("Gardener Mortifole"),
Data("EN090503_NAME_F00_185", valid=False),
Data("Native Mortifole"),
Data("EN090503_NAME_F00_186", valid=False),
Data("Yessenia, the Husky-Voiced"),
Data("Abyssal Sacrifole"),
Data("Giant Sacrifole"),
Data("Mega Sacrifole"),
Data("Dobromila, the Alluring"),
Data("Drone Mortifole"),
Data("Recluse Mortifole"),
Data("EN090503_NAME_F00_187", valid=False),
Data("Jindriska, the Serene"),
Data("Poisonous Mortifole"),
Data("EN090503_NAME_F00_188", valid=False),
Data("Toxic Mortifole"),
Data("EN090503_NAME_F00_189", valid=False),
Data("Eliane, the Unmoved"),
Data("EN090503_NAME_F00_190", valid=False),
Data("Grotto Mortifole"),
Data("Cave Mortifole"),
Data("Crusher Mortifole"),
Data("EN090503_NAME_F00_191", valid=False),
Data("EN090503_NAME_F00_192", valid=False),
Data("Katerina, the Cliffhanger"),
Data("Aquatic Sacrifole"),
Data("Puddle Sacrifole"),
Data("Lake Sacrifole"),
Data("Foul Sacrifole"),
Data("Angelita, the Blade Bouquet"),
Data("Lava Sacrifole"),
Data("EN090503_NAME_F00_193", valid=False),
Data("Vegetal, the Heatcrux"),
Data("EN090503_NAME_F00_194", valid=False),
Data("Welkin Auravis"),
Data("Reaver Auravis"),
Data("Sky Auravis"),
Data("EN090503_NAME_F00_195", valid=False),
Data("Bohdan, the Mistral"),
Data("EN090503_NAME_F00_196", valid=False),
Data("Rocket Jacul"),
Data("Storm Jacul"),
Data("Tornado Jacul"),
Data("Jia Mian, the Beloved"),
Data("EN090503_NAME_F00_197", valid=False),
Data("Gale Auravis"),
Data("Blast Auravis"),
Data("Typhoon Auravis"),
Data("Tempest Auravis"),
Data("Gotthard, the Intimidating"),
Data("EN090503_NAME_F00_198", valid=False),
Data("Jade Jacul"),
Data("Canyon Jacul"),
Data("Mountain Jacul"),
Data("Radovan, the Sky Baron"),
Data("Welkin Levitath"),
Data("EN090503_NAME_F00_199", valid=False),
Data("Eutropio, the Sea Rumble"),
Data("Cataract Levitath"),
Data("Abyssal Levitath"),
Data("Silvestre, the Morning Light"),
Data("Scarlet Levitath"),
Data("Antares Levitath"),
Data("Frajeel, the Purgatorial"),
Data("Elvira, the Talondrake"),
Data("EN090503_NAME_F00_200", valid=False),
Data("EN090503_NAME_F00_201", valid=False),
Data("EN090503_NAME_F00_202", valid=False),
Data("Hartmut, the Calamity"),
Data("Spring Unafulge"),
Data("Floating Unafulge"),
Data("Drifter Unafulge"),
Data("Lethal Unafulge"),
Data("Abyssal Unafulge"),
Data("Planetes, the Torrential"),
Data("EN090503_NAME_F00_203", valid=False),
Data("EN090503_NAME_F00_204", valid=False),
Data("EN090503_NAME_F00_205", valid=False),
Data("Lake Visigel"),
Data("EN090503_NAME_F00_206", valid=False),
Data("Sapphire Visigel"),
Data("Yune, the Ambusher"),
Data("Lava Unafulge"),
Data("Ruth, the Shunner of Light"),
Data("Coast Visigel"),
Data("Cave Visigel"),
Data("EN090503_NAME_F00_207", valid=False),
Data("Razer Visigel"),
Data("Spore Filiavent"),
Data("Laurencio, the Fog Bow"),
Data("EN090503_NAME_F00_208", valid=False),
Data("Phosphorous Filiavent"),
Data("Trueno, the Cataclysm"),
Data("EN090503_NAME_F00_209", valid=False),
Data("Nocturnal Vesper"),
Data("Blind Vesper"),
Data("Dark Vesper"),
Data("Mortal Vesper"),
Data("Ripper Vesper"),
Data("EN090503_NAME_F00_210", valid=False),
Data("Necro, the Cavelord"),
Data("Hushed Murra"),
Data("Silent Murra"),
Data("Quiet Murra"),
Data("Strange Murra"),
Data("Uncanny Murra"),
Data("Camille, the Immortal"),
Data("Froste, the Courteous"),
Data("Lake Terebra"),
Data("Pit Terebra"),
Data("Whirling Terebra"),
Data("Shinhwa, the Sagacious"),
Data("Mischievous Mephite"),
Data("Impish Mephite"),
Data("Malicious Mephite"),
Data("Gerhardt, the Lone and Proud"),
Data("EN090503_NAME_F00_211", valid=False),
Data("Pond Terebra"),
Data("Nomad Terebra"),
Data("Crusher Terebra"),
Data("EN090503_NAME_F00_212", valid=False),
Data("Fell Terebra"),
Data("Archibolt, the Revolutionary"),
Data("Prowler Mephite"),
Data("Stray Mephite"),
Data("EN090503_NAME_F00_213", valid=False),
Data("Ferdinand, the Fortuitous"),
Data("EN090503_NAME_F00_214", valid=False),
Data("Lawless Mephite"),
Data("Evil Mephite"),
Data("EN090503_NAME_F00_215", valid=False),
Data("Lask, the Unscrupulous"),
Data("Jocular Saltat"),
Data("Droll Saltat"),
Data("Sapara, the Laconic"),
Data("EN090503_NAME_F00_216", valid=False),
Data("Strange Liceor"),
Data("Glowing Liceor"),
Data("Dazzling Liceor"),
Data("Stola, the Champion"),
Data("EN090503_NAME_F00_217", valid=False),
Data("Viridian Saltat"),
Data("Saffron Saltat"),
Data("EN090503_NAME_F00_218", valid=False),
Data("Citrine Saltat"),
Data("EN090503_NAME_F00_219", valid=False),
Data("Garnet Saltat"),
Data("Zdenka, the Raucous"),
Data("EN090503_NAME_F00_220", valid=False),
Data("Ruby Saltat"),
Data("Jarosch, the Sensational"),
Data("EN090503_NAME_F00_221", valid=False),
Data("Awakened Liceor"),
Data("Divine Liceor"),
Data("Stola, the Unchained"),
Data("EN090503_NAME_F00_222", valid=False),
Data("Itinerant Saltat"),
Data("Strange Saltat"),
Data("Gypsy Saltat"),
Data("EN090503_NAME_F00_223", valid=False),
Data("Island Saltat"),
Data("Native Saltat"),
Data("Mystic Saltat"),
Data("Crested Saltat"),
Data("Cloud Saltat"),
Data("Zorn, the Wanderer"),
Data("EN090503_NAME_F00_224", valid=False),
Data("EN090503_NAME_F00_225", valid=False),
Data("Sorrowful Saltat"),
Data("Rapture Saltat"),
Data("EN090503_NAME_F00_226", valid=False),
Data("Prisoner Saltat"),
Data("EN090503_NAME_F00_227", valid=False),
Data("Fiasco Saltat"),
Data("Imbecile Saltat"),
Data("Sluggish Saltat"),
Data("Bressole, the Fugitive"),
Data("Stone Potamus"),
Data("Rock Potamus"),
Data("Copper Potamus"),
Data("EN090503_NAME_F00_228", valid=False),
Data("Mesgen, the Fairweathered"),
Data("Brother Potamus"),
Data("Merciful Dilus"),
Data("Acid Dilus"),
Data("Hunter Dilus"),
Data("EN090503_NAME_F00_229", valid=False),
Data("EN090503_NAME_F00_230", valid=False),
Data("EN090503_NAME_F00_231", valid=False),
Data("Volcannon Tersqual"),
Data("Agnes, the Divine-Scaled"),
Data("EN090503_NAME_F00_232", valid=False),
Data("EN090503_NAME_F00_233", valid=False),
Data("Lake Dilus"),
Data("EN090503_NAME_F00_234", valid=False),
Data("EN090503_NAME_F00_235", valid=False),
Data("EN090503_NAME_F00_236", valid=False),
Data("Sheldon, the Dentally Challenged"),
Data("EN090503_NAME_F00_237", valid=False),
Data("Lively Tersqual"),
Data("Latis, the Bristle-Scaled"),
Data("Green Master Galdr"),
Data("Experimental Composite Qmoeva"),
Data("EN090503_NAME_F00_238", valid=False),
Data("EN090503_NAME_F00_239", valid=False),
Data("EN090503_NAME_F00_240", valid=False),
Data("EN090503_NAME_F00_241", valid=False),
Data("Langul, the Alien Payload"),
Data("Volcannon Cinicula"),
Data("Pure Cinicula"),
Data("Alfombra, the Transcendent"),
Data("Minor Sabula"),
Data("Crazed Aeviter"),
Data("Libra, the Long-Lived"),
Data("Rain Scintimure"),
Data("Storm Scintimure"),
Data("EN090503_NAME_F00_242", valid=False),
Data("Shatskikh, the Flash"),
Data("Mighty Virago"),
Data("Callow Virago"),
Data("Vice Simius"),
Data("Mortal Simius"),
Data("EN090503_NAME_F00_243", valid=False),
Data("Diogenes, the Covetous"),
Data("Oskar, the Summer Squall"),
Data("EN090503_NAME_F00_244", valid=False),
Data("EN090503_NAME_F00_245", valid=False),
Data("Stray Ovis"),
Data("EN090503_NAME_F00_246", valid=False),
Data("EN090503_NAME_F00_247", valid=False),
Data("EN090503_NAME_F00_248", valid=False),
Data("Prowler Ovis"),
Data("EN090503_NAME_F00_249", valid=False),
Data("Germaine, the Treasure Keeper"),
Data("Parasite Gerrid"),
Data("EN090503_NAME_F00_250", valid=False),
Data("Hell Gerrid"),
Data("EN090503_NAME_F00_251", valid=False),
Data("Mirage Mortifole"),
Data("EN090503_NAME_F00_252", valid=False),
Data("EN090503_NAME_F00_253", valid=False),
Data("Poppy, the Pyromaniac"),
Data("Blood Vesper"),
Data("Carmine Vesper"),
Data("Aria, the Zauberflöte"),
Data("Jade Saltat"),
Data("Wenzel, the Inebriated"),
Data("EN090503_NAME_F00_254", valid=False),
Data("Rolf, the Sonorous"),
Data("Minion Potamus"),
Data("Companion Potamus"),
Data("Rodriguez, the Twin-Tusked"),
Data("Sarcosuchus, the Iron-Eater"),
Data("EN090503_NAME_F00_255", valid=False),
Data("Yellow Arenatect"),
Data("EN090503_NAME_F00_256", valid=False),
Data("Ymir Gularth"),
Data("Laser Raptor Seidr"),
Data("Aegis Raptor Seidr"),
Data("Grav Raptor Seidr"),
Data("EN090503_NAME_F00_257", valid=False),
Data("EN090503_NAME_F00_258", valid=False),
Data("EN090503_NAME_F00_259", valid=False),
Data("Autosentry"),
Data("Autosentry Mk.II"),
Data("Buster Emperor Qmoeva"),
Data("Duel Emperor Qmoeva"),
Data("Rebel Emperor Qmoeva"),
Data("EN090503_NAME_F00_260", valid=False),
Data("Forest Aprica"),
Data("Shoal Balaena"),
Data("Support Trainee Qmoeva"),
Data("Caranau, the Water Drake"),
Data("Highland Lepyx"),
Data("Nu-rhor, the Dark Deity"),
Data("EN090503_NAME_F00_261", valid=False),
Data("Nickel Fal-swo"),
Data("EN090503_NAME_F00_262", valid=False),
Data("Zirconium Fal-swo"),
Data("No-dhor, the Shadowcaster"),
Data("Gadaf's Qmoeva"),
Data("Sizzling Visigel"),
Data("Lord Xe-dom"),
Data("Bravo Unafulge"),
Data("Marnuck Commander"),
Data("Marnuck Ruffian"),
Data("Marnuck Slugger"),
Data("Marnuck Hornet"),
Data("Marnuck Grappler"),
Data("Marnuck Jaeger"),
Data("Marnuck Blaster"),
Data("Marnuck Firetrooper"),
Data("Marnuck Loader"),
Data("Marnuck Howitzer"),
Data("Marnuck Minor"),
Data("Marnuck Soldier"),
Data("Marnuck Vanguard"),
Data("Marnuck Support"),
Data("Marnuck Guardian"),
Data("Marnuck Marksman"),
Data("Marnuck Imperial"),
Data("Marnuck Burster"),
Data("Marnuck Gatling"),
Data("Marnuck Slayer"),
Data("Marnuck Crasher"),
Data("Marnuck Pulser"),
Data("Marnuck Dynamo"),
Data("Marnuck Transitioner"),
Data("Marnuck Converger"),
Data("Marnuck Recon"),
Data("Marnuck Mercenary"),
Data("Marnuck Barrager"),
Data("Marnuck Pawn"),
Data("Marnuck Shield Trooper"),
Data("Marnuck Sentinel"),
Data("Prone Major"),
Data("Prone Warrior"),
Data("Prone Butcher"),
Data("Prone Eater"),
Data("Prone Soldier"),
Data("Prone Typhoon"),
Data("Prone Rampager"),
Data("Prone Berserker"),
Data("Prone Trainer"),
Data("Prone Owl"),
Data("Prone Vulture"),
Data("Prone Eagle"),
Data("Prone Hawk"),
Data("Prone Barbarian"),
Data("Prone Slayer"),
Data("Prone Bully"),
Data("Prone Commander"),
Data("Prone Fury"),
Data("Prone Admiral"),
Data("Prone Condemned"),
Data("Prone Savage"),
Data("Prone Vix Guard"),
Data("Prone Vix Beta"),
Data("Prone Vix Owl"),
Data("Prone Vix Vulture"),
Data("Prone Vix Crow"),
Data("Prone Vix Hawk"),
Data("Prone Vix Griffin"),
Data("Prone Vix Alpha"),
Data("Prone Vix Prisoner"),
Data("Prone Vix Delta"),
Data("Prone Vix Brutalizer"),
Data("Pyro Sacrifole"),
Data("Gu Ladha"),
Data("Fighter Pugilith"),
Data("Tantalum Fal-swo"),
Data("Forest Adsecula"),
Data("Sparrow Adsecula"),
Data("Endeavorer Adsecula"),
Data("Alba Lepyx"),
Data("Innocent Ovis"),
Data("Red Master Galdr"),
Data("EN090503_NAME_F00_263", valid=False),
Data("EN090503_NAME_F00_264", valid=False),
Data("Rebel Kaizer Qmoeva"),
Data("Prometheus Petramand"),
Data("Soma Scirpo"),
Data("Amrita Scirpo"),
Data("Logi Scirpo"),
Data("Surtr Scirpo"),
Data("Bacchanal Scirpo"),
Data("Tharros Scirpo"),
Data("Scandium Petramand"),
Data("Holmium Petramand"),
Data("EN090503_NAME_F00_265", valid=False),
Data("Shadow Scirpo"),
Data("Carnelian Scirpo"),
Data("Carmine Forfex"),
Data("Garnet Forfex"),
Data("Mother Forfex"),
Data("Ruby Forfex"),
Data("Femme Forfex"),
Data("Big Forfex"),
Data("Iolite Forfex"),
Data("Sapphire Forfex"),
Data("Rock Cinicula"),
Data("Putrid Falsaxum"),
Data("Mirage Vivohast"),
Data("Blitz Blatta"),
Data("Ogre Blatta"),
Data("Mirage Blatta"),
Data("Hrym Blatta"),
Data("Logi Blatta"),
Data("Seeker Blatta"),
Data("Sonic Blatta"),
Data("Zeppelin Blatta"),
Data("Prairie Blatta"),
Data("Coal Blatta"),
Data("Tectonic Blatta"),
Data("Chartreuse Blatta"),
Data("Raven Blatta"),
Data("Tranquil Blatta"),
Data("Vampire Blatta"),
Data("Magus Blatta"),
Data("Hellion Blatta"),
Data("Azure Blatta"),
Data("Moon Blatta"),
Data("Mirror Blatta"),
Data("Copper Papil"),
Data("Bronze Papil"),
Data("Zeppelin Germivore"),
Data("Terrible Germivore"),
Data("Hermit Ictus"),
Data("Tidal Purgovent"),
Data("Bolt Duoguill"),
Data("Callous Scintimure"),
Data("Storm Caro"),
Data("Grand Cantor"),
Data("Violet Cervus"),
Data("Western Suid"),
Data("Bronze Suid"),
Data("Adamant Armored Suid"),
Data("Crazed Femina Suid"),
Data("Alba Femina Suid"),
Data("Origin Mortifole"),
Data("Pit Mortifole"),
Data("Callous Mortifole"),
Data("Wind Auravis"),
Data("Fluid Jacul"),
Data("Highland Jacul"),
Data("Creek Unafulge"),
Data("Dryland Unafulge"),
Data("Strange Vesper"),
Data("Abyssal Vesper"),
Data("Uncanny Vesper"),
Data("Thug Mephite"),
Data("Prankster Mephite"),
Data("Huge Potamus"),
Data("Young Cinicula"),
Data("Blazing Lophid"),
Data("Gate Puge"),
Data("Porter Puge"),
Data("Fighter Puge"),
Data("Border Puge"),
Data("Remote Puge"),
Data("Spear Puge"),
Data("Cavalier Puge"),
Data("Solid Puge"),
Data("EN090503_NAME_F00_266", valid=False),
Data("Broadsword Pugilith"),
Data("Remote Pugilith"),
Data("Spear Pugilith"),
Data("Judge Pugilith"),
Data("Magna Galdr"),
Data("Flood Galdr"),
Data("Border King Quo"),
Data("Reject Oc-serv"),
Data("Rebel Oc-serv"),
Data("Beryllium Oc-serv"),
Data("Barbed Rook Qmoeva"),
Data("Barbed Remote Qmoeva"),
Data("Barbed Queen Qmoeva"),
Data("EN090503_NAME_F00_267", valid=False),
Data("Striker Qmoeva"),
Data("Purger Queen Qmoeva"),
Data("Brave Rook Qmoeva"),
Data("Brave Queen Qmoeva"),
Data("Brave King Qmoeva"),
Data("True Queen Qmoeva"),
Data("Rebel Queen Qmoeva"),
Data("True King Qmoeva"),
Data("EN090503_NAME_F00_268", valid=False),
Data("Suppressor Hermit Qmoeva"),
Data("Hazard Shrad"),
Data("Avaricious Shrad"),
Data("Luminous Puge"),
Data("Coffin Puge"),
Data("Ataraxia Oc-serv"),
Data("EN090503_NAME_F00_269", valid=False),
Data("Auto Gunner Zig"),
Data("EN090503_NAME_F00_270", valid=False),
Data("EN090503_NAME_F00_271", valid=False),
Data("Marnuck Aspirer"),
Data("Marnuck Damager"),
Data("Marnuck Evildoer"),
Data("Marnuck Cutthroat"),
Data("Milsaadi Herald"),
Data("Milsaadi Protobattler"),
Data("Milsaadi Robber"),
Data("Milsaadi Astran"),
Data("Prone Purger"),
Data("Prone Judge"),
Data("Prone Sorcerer"),
Data("Breather Scirpo"),
Data("Pillager Scirpo"),
Data("Carnelian Forfex"),
Data("Spinel Forfex"),
Data("Promethium Petramand"),
Data("Rust Blatta"),
Data("Alba Blatta"),
Data("Green Blatta"),
Data("Squall Blatta"),
Data("Striker Blatta"),
Data("Stalwart Blatta"),
Data("Penetrator Adsecula"),
Data("Giddy Adsecula"),
Data("Cursed Adsecula"),
Data("Dryland Papil"),
Data("Raven Turba"),
Data("Gloam Turba"),
Data("Crazed Germivore"),
Data("Mist Germivore"),
Data("Gehenna Lophid"),
Data("Striker Simius"),
Data("Conjurer Cervus"),
Data("Miniature Suid"),
Data("Miniature Femina Suid"),
Data("Volcannon Sacrifole"),
Data("Stream Jacul"),
Data("Aquatic Visigel"),
Data("Wild Mephite"),
Data("Witless Saltat"),
Data("Caged Saltat"),
Data("Crater Saltat"),
Data("Buster Kaizer Qmoeva"),
Data("Durvin, the Perceptive"),
Data("Star Cinicula"),
Data("Nocto Blatta"),
Data("Wood Potamus"),
Data("Buoyant Lophid"),
Data("Young Unafulge"),
Data("Marnuck Windtrooper"),
]
