# from https://xenoblade.github.io/xbx/bdat/common_local_us/DRP_AffixTable.html
from typing import NamedTuple
class DropSkill(NamedTuple):
	prob: int
	name: str


DS = DropSkill

# flake8: noqa
dropSkillsData:list[list[DropSkill]] = [
[],
[],
[],
[],
[],
[],
[],
[],
[],
[],
[],
[],
[],
[],
[],
[],
[],
[],
[],
[],
[],
[],
[],
[],
[DS(5, "Melee: Blaze I"), DS(10, "Melee: Shock I"), DS(10, "Melee: TP Gain Up"), DS(20, "Potential Up I"), DS(30, "Humanoid Criticals Up I"), DS(30, "Mechanoid Criticals Up I"), DS(30, "Theroid Criticals Up I"), DS(100, "Melee Accuracy Up I")],
[DS(5, "Appendage Crusher"), DS(10, "Weapon Attack Power Up I"), DS(10, "Critical Chance Up I"), DS(20, "Melee: Recover HP I"), DS(30, "Arts: Gain TP I"), DS(30, "Melee: Physical Res Down I"), DS(30, "Melee Attack Boost I"), DS(100, "Melee Attack Up I")],
[DS(10, "Melee: Blaze I"), DS(15, "Melee: Shock I"), DS(15, "Melee: TP Gain Up"), DS(25, "Potential Up I"), DS(35, "Humanoid Criticals Up I"), DS(35, "Mechanoid Criticals Up I"), DS(35, "Theroid Criticals Up I"), DS(100, "Destabilizer I")],
[DS(10, "Appendage Crusher"), DS(15, "Weapon Attack Power Up I"), DS(15, "Critical Chance Up I"), DS(25, "Melee: Recover HP I"), DS(35, "Arts: Gain TP I"), DS(35, "Melee: Physical Res Down I"), DS(35, "Melee Attack Boost I"), DS(100, "Melee Attack Up I")],
[DS(5, "Front Attack Plus I"), DS(10, "Opening Art: Damage Up I"), DS(10, "Firing Range Up I"), DS(20, "Potential Up I"), DS(30, "Mechanoid Slayer I"), DS(30, "Humanoid Slayer I"), DS(30, "Piscinoid Slayer I"), DS(100, "Ranged Accuracy Up I")],
[DS(5, "Cooldown Reducer I"), DS(10, "Weapon Attack Power Up I"), DS(10, "Magazine Capacity Up I"), DS(20, "Physical Attack Plus I"), DS(30, "Arts: Recover HP I"), DS(30, "Critical Chance Up I"), DS(30, "Ranged Attack Boost I"), DS(100, "Ranged Attack Up I")],
[DS(10, "Front Attack Plus I"), DS(15, "Opening Art: Damage Up I"), DS(15, "Firing Range Up I"), DS(25, "Potential Up I"), DS(35, "Mechanoid Slayer I"), DS(35, "Humanoid Slayer I"), DS(35, "Piscinoid Slayer I"), DS(100, "Destabilizer I")],
[DS(10, "Cooldown Reducer I"), DS(15, "Weapon Attack Power Up I"), DS(15, "Magazine Capacity Up I"), DS(25, "Physical Attack Plus I"), DS(35, "Arts: Recover HP I"), DS(35, "Critical Chance Up I"), DS(35, "Ranged Attack Boost I"), DS(100, "Ranged Attack Up I")],
[DS(5, "Melee: Blaze III"), DS(10, "Melee: Shock III"), DS(10, "Melee: TP Gain Up"), DS(20, "Potential Up III"), DS(30, "Humanoid Criticals Up III"), DS(30, "Mechanoid Criticals Up III"), DS(30, "Theroid Criticals Up III"), DS(100, "Melee Accuracy Up III")],
[DS(5, "Appendage Crusher"), DS(10, "Weapon Attack Power Up III"), DS(10, "Critical Chance Up III"), DS(20, "Melee: Recover HP III"), DS(30, "Arts: Gain TP III"), DS(30, "Melee: Physical Res Down III"), DS(30, "Melee Attack Boost III"), DS(100, "Melee Attack Up III")],
[DS(10, "Melee: Blaze III"), DS(15, "Melee: Shock III"), DS(15, "Melee: TP Gain Up"), DS(25, "Potential Up III"), DS(35, "Humanoid Criticals Up III"), DS(35, "Mechanoid Criticals Up III"), DS(35, "Theroid Criticals Up III"), DS(100, "Destabilizer III")],
[DS(10, "Appendage Crusher"), DS(15, "Weapon Attack Power Up III"), DS(15, "Critical Chance Up III"), DS(25, "Melee: Recover HP III"), DS(35, "Arts: Gain TP III"), DS(35, "Melee: Physical Res Down III"), DS(35, "Melee Attack Boost III"), DS(100, "Melee Attack Up III")],
[DS(5, "Melee: Blaze V"), DS(10, "Melee: Shock V"), DS(10, "Melee: TP Gain Up"), DS(20, "Potential Up V"), DS(30, "Humanoid Criticals Up V"), DS(30, "Mechanoid Criticals Up V"), DS(30, "Theroid Criticals Up V"), DS(100, "Melee Accuracy Up V")],
[DS(5, "Appendage Crusher"), DS(10, "Weapon Attack Power Up V"), DS(10, "Critical Chance Up V"), DS(20, "Melee: Recover HP V"), DS(30, "Arts: Gain TP V"), DS(30, "Melee: Physical Res Down V"), DS(30, "Melee Attack Boost V"), DS(100, "Melee Attack Up V")],
[DS(10, "Melee: Blaze V"), DS(15, "Melee: Shock V"), DS(15, "Melee: TP Gain Up"), DS(25, "Potential Up V"), DS(35, "Humanoid Criticals Up V"), DS(35, "Mechanoid Criticals Up V"), DS(35, "Theroid Criticals Up V"), DS(100, "Destabilizer V")],
[DS(10, "Appendage Crusher"), DS(15, "Weapon Attack Power Up V"), DS(15, "Critical Chance Up V"), DS(25, "Melee: Recover HP V"), DS(35, "Arts: Gain TP V"), DS(35, "Melee: Physical Res Down V"), DS(35, "Melee Attack Boost V"), DS(100, "Melee Attack Up V")],
[DS(5, "Ether Resistance Up I"), DS(10, "Front Attack Plus I"), DS(10, "Electric Resistance Up I"), DS(20, "Resist Stagger I"), DS(30, "Humanoid Criticals Up I"), DS(30, "Mechanoid Criticals Up I"), DS(30, "Theroid Criticals Up I"), DS(100, "Melee Accuracy Up I")],
[DS(5, "Gravity Resistance Up I"), DS(10, "Weapon Attack Power Up I"), DS(10, "Thermal Resistance Up I"), DS(20, "Resist Topple I"), DS(30, "Topple: Barrier I"), DS(30, "Resist Launch I"), DS(30, "Resist Knockback I"), DS(100, "Melee Attack Up I")],
[DS(10, "Ether Resistance Up I"), DS(15, "Front Attack Plus I"), DS(15, "Electric Resistance Up I"), DS(25, "Resist Stagger I"), DS(35, "Humanoid Criticals Up I"), DS(35, "Mechanoid Criticals Up I"), DS(35, "Theroid Criticals Up I"), DS(100, "Destabilizer I")],
[DS(10, "Gravity Resistance Up I"), DS(15, "Weapon Attack Power Up I"), DS(15, "Thermal Resistance Up I"), DS(25, "Resist Topple I"), DS(35, "Topple: Barrier I"), DS(35, "Resist Launch I"), DS(35, "Resist Knockback I"), DS(100, "Melee Attack Up I")],
[DS(5, "Ether Resistance Up III"), DS(10, "Front Attack Plus III"), DS(10, "Electric Resistance Up III"), DS(20, "Resist Stagger III"), DS(30, "Humanoid Criticals Up III"), DS(30, "Mechanoid Criticals Up III"), DS(30, "Theroid Criticals Up III"), DS(100, "Melee Accuracy Up III")],
[DS(5, "Gravity Resistance Up III"), DS(10, "Weapon Attack Power Up III"), DS(10, "Thermal Resistance Up III"), DS(20, "Resist Topple III"), DS(30, "Topple: Barrier III"), DS(30, "Resist Launch III"), DS(30, "Resist Knockback III"), DS(100, "Melee Attack Up III")],
[DS(10, "Ether Resistance Up III"), DS(15, "Front Attack Plus III"), DS(15, "Electric Resistance Up III"), DS(25, "Resist Stagger III"), DS(35, "Humanoid Criticals Up III"), DS(35, "Mechanoid Criticals Up III"), DS(35, "Theroid Criticals Up III"), DS(100, "Destabilizer III")],
[DS(10, "Gravity Resistance Up III"), DS(15, "Weapon Attack Power Up III"), DS(15, "Thermal Resistance Up III"), DS(25, "Resist Topple III"), DS(35, "Topple: Barrier III"), DS(35, "Resist Launch III"), DS(35, "Resist Knockback III"), DS(100, "Melee Attack Up III")],
[DS(5, "Ether Resistance Up V"), DS(10, "Front Attack Plus V"), DS(10, "Electric Resistance Up V"), DS(20, "Resist Stagger V"), DS(30, "Humanoid Criticals Up V"), DS(30, "Mechanoid Criticals Up V"), DS(30, "Theroid Criticals Up V"), DS(100, "Melee Accuracy Up V")],
[DS(5, "Gravity Resistance Up V"), DS(10, "Weapon Attack Power Up V"), DS(10, "Thermal Resistance Up V"), DS(20, "Resist Topple V"), DS(30, "Topple: Barrier V"), DS(30, "Resist Launch V"), DS(30, "Resist Knockback V"), DS(100, "Melee Attack Up V")],
[DS(10, "Ether Resistance Up V"), DS(15, "Front Attack Plus V"), DS(15, "Electric Resistance Up V"), DS(25, "Resist Stagger V"), DS(35, "Humanoid Criticals Up V"), DS(35, "Mechanoid Criticals Up V"), DS(35, "Theroid Criticals Up V"), DS(100, "Destabilizer V")],
[DS(10, "Gravity Resistance Up V"), DS(15, "Weapon Attack Power Up V"), DS(15, "Thermal Resistance Up V"), DS(25, "Resist Topple V"), DS(35, "Topple: Barrier V"), DS(35, "Resist Launch V"), DS(35, "Resist Knockback V"), DS(100, "Melee Attack Up V")],
[DS(5, "Front Attack Plus III"), DS(10, "Opening Art: Damage Up III"), DS(10, "Firing Range Up III"), DS(20, "Potential Up III"), DS(30, "Mechanoid Slayer III"), DS(30, "Humanoid Slayer III"), DS(30, "Piscinoid Slayer III"), DS(100, "Ranged Accuracy Up III")],
[DS(5, "Cooldown Reducer III"), DS(10, "Weapon Attack Power Up III"), DS(10, "Magazine Capacity Up III"), DS(20, "Physical Attack Plus III"), DS(30, "Arts: Recover HP III"), DS(30, "Critical Chance Up III"), DS(30, "Ranged Attack Boost III"), DS(100, "Ranged Attack Up III")],
[DS(10, "Front Attack Plus III"), DS(15, "Opening Art: Damage Up III"), DS(15, "Firing Range Up III"), DS(25, "Potential Up III"), DS(35, "Mechanoid Slayer III"), DS(35, "Humanoid Slayer III"), DS(35, "Piscinoid Slayer III"), DS(100, "Destabilizer III")],
[DS(10, "Cooldown Reducer III"), DS(15, "Weapon Attack Power Up III"), DS(15, "Magazine Capacity Up III"), DS(25, "Physical Attack Plus III"), DS(35, "Arts: Recover HP III"), DS(35, "Critical Chance Up III"), DS(35, "Ranged Attack Boost III"), DS(100, "Ranged Attack Up III")],
[DS(5, "Front Attack Plus V"), DS(10, "Opening Art: Damage Up V"), DS(10, "Firing Range Up V"), DS(20, "Potential Up V"), DS(30, "Mechanoid Slayer V"), DS(30, "Humanoid Slayer V"), DS(30, "Piscinoid Slayer V"), DS(100, "Ranged Accuracy Up V")],
[DS(5, "Cooldown Reducer V"), DS(10, "Weapon Attack Power Up V"), DS(10, "Magazine Capacity Up V"), DS(20, "Physical Attack Plus V"), DS(30, "Arts: Recover HP V"), DS(30, "Critical Chance Up V"), DS(30, "Ranged Attack Boost V"), DS(100, "Ranged Attack Up V")],
[DS(10, "Front Attack Plus V"), DS(15, "Opening Art: Damage Up V"), DS(15, "Firing Range Up V"), DS(25, "Potential Up V"), DS(35, "Mechanoid Slayer V"), DS(35, "Humanoid Slayer V"), DS(35, "Piscinoid Slayer V"), DS(100, "Destabilizer V")],
[DS(10, "Cooldown Reducer V"), DS(15, "Weapon Attack Power Up V"), DS(15, "Magazine Capacity Up V"), DS(25, "Physical Attack Plus V"), DS(35, "Arts: Recover HP V"), DS(35, "Critical Chance Up V"), DS(35, "Ranged Attack Boost V"), DS(100, "Ranged Attack Up V")],
[DS(5, "Melee: Blaze VII"), DS(10, "Melee: Shock VII"), DS(10, "Melee: TP Gain Up"), DS(20, "Potential Up VII"), DS(30, "Humanoid Criticals Up VII"), DS(30, "Mechanoid Criticals Up VII"), DS(30, "Theroid Criticals Up VII"), DS(100, "Melee Accuracy Up VII")],
[DS(5, "Appendage Crusher"), DS(10, "Weapon Attack Power Up VII"), DS(10, "Critical Chance Up VII"), DS(20, "Melee: Recover HP VII"), DS(30, "Arts: Gain TP VII"), DS(30, "Melee: Physical Res Down VII"), DS(30, "Melee Attack Boost VII"), DS(100, "Melee Attack Up VII")],
[DS(10, "Melee: Blaze VII"), DS(15, "Melee: Shock VII"), DS(15, "Melee: TP Gain Up"), DS(25, "Potential Up VII"), DS(35, "Humanoid Criticals Up VII"), DS(35, "Mechanoid Criticals Up VII"), DS(35, "Theroid Criticals Up VII"), DS(100, "Destabilizer VII")],
[DS(10, "Appendage Crusher"), DS(15, "Weapon Attack Power Up VII"), DS(15, "Critical Chance Up VII"), DS(25, "Melee: Recover HP VII"), DS(35, "Arts: Gain TP VII"), DS(35, "Melee: Physical Res Down VII"), DS(35, "Melee Attack Boost VII"), DS(100, "Melee Attack Up VII")],
[DS(5, "Melee: Blaze IX"), DS(10, "Melee: Shock IX"), DS(10, "Melee: TP Gain Up"), DS(20, "Potential Up IX"), DS(30, "Humanoid Criticals Up IX"), DS(30, "Mechanoid Criticals Up IX"), DS(30, "Theroid Criticals Up IX"), DS(100, "Melee Accuracy Up IX")],
[DS(5, "Appendage Crusher"), DS(10, "Weapon Attack Power Up IX"), DS(10, "Critical Chance Up IX"), DS(20, "Melee: Recover HP IX"), DS(30, "Arts: Gain TP IX"), DS(30, "Melee: Physical Res Down IX"), DS(30, "Melee Attack Boost IX"), DS(100, "Melee Attack Up IX")],
[DS(10, "Melee: Blaze IX"), DS(15, "Melee: Shock IX"), DS(15, "Melee: TP Gain Up"), DS(25, "Potential Up IX"), DS(35, "Humanoid Criticals Up IX"), DS(35, "Mechanoid Criticals Up IX"), DS(35, "Theroid Criticals Up IX"), DS(100, "Destabilizer IX")],
[DS(10, "Appendage Crusher"), DS(15, "Weapon Attack Power Up IX"), DS(15, "Critical Chance Up IX"), DS(25, "Melee: Recover HP IX"), DS(35, "Arts: Gain TP IX"), DS(35, "Melee: Physical Res Down IX"), DS(35, "Melee Attack Boost IX"), DS(100, "Melee Attack Up IX")],
[DS(5, "Ether Resistance Up VII"), DS(10, "Front Attack Plus VII"), DS(10, "Electric Resistance Up VII"), DS(20, "Resist Stagger VII"), DS(30, "Humanoid Criticals Up VII"), DS(30, "Mechanoid Criticals Up VII"), DS(30, "Theroid Criticals Up VII"), DS(100, "Melee Accuracy Up VII")],
[DS(5, "Gravity Resistance Up VII"), DS(10, "Weapon Attack Power Up VII"), DS(10, "Thermal Resistance Up VII"), DS(20, "Resist Topple VII"), DS(30, "Topple: Barrier VII"), DS(30, "Resist Launch VII"), DS(30, "Resist Knockback VII"), DS(100, "Melee Attack Up VII")],
[DS(10, "Ether Resistance Up VII"), DS(15, "Front Attack Plus VII"), DS(15, "Electric Resistance Up VII"), DS(25, "Resist Stagger VII"), DS(35, "Humanoid Criticals Up VII"), DS(35, "Mechanoid Criticals Up VII"), DS(35, "Theroid Criticals Up VII"), DS(100, "Destabilizer VII")],
[DS(10, "Gravity Resistance Up VII"), DS(15, "Weapon Attack Power Up VII"), DS(15, "Thermal Resistance Up VII"), DS(25, "Resist Topple VII"), DS(35, "Topple: Barrier VII"), DS(35, "Resist Launch VII"), DS(35, "Resist Knockback VII"), DS(100, "Melee Attack Up VII")],
[DS(5, "Ether Resistance Up IX"), DS(10, "Front Attack Plus IX"), DS(10, "Electric Resistance Up IX"), DS(20, "Resist Stagger IX"), DS(30, "Humanoid Criticals Up IX"), DS(30, "Mechanoid Criticals Up IX"), DS(30, "Theroid Criticals Up IX"), DS(100, "Melee Accuracy Up IX")],
[DS(5, "Gravity Resistance Up IX"), DS(10, "Weapon Attack Power Up IX"), DS(10, "Thermal Resistance Up IX"), DS(20, "Resist Topple IX"), DS(30, "Topple: Barrier IX"), DS(30, "Resist Launch IX"), DS(30, "Resist Knockback IX"), DS(100, "Melee Attack Up IX")],
[DS(10, "Ether Resistance Up IX"), DS(15, "Front Attack Plus IX"), DS(15, "Electric Resistance Up IX"), DS(25, "Resist Stagger IX"), DS(35, "Humanoid Criticals Up IX"), DS(35, "Mechanoid Criticals Up IX"), DS(35, "Theroid Criticals Up IX"), DS(100, "Destabilizer IX")],
[DS(10, "Gravity Resistance Up IX"), DS(15, "Weapon Attack Power Up IX"), DS(15, "Thermal Resistance Up IX"), DS(25, "Resist Topple IX"), DS(35, "Topple: Barrier IX"), DS(35, "Resist Launch IX"), DS(35, "Resist Knockback IX"), DS(100, "Melee Attack Up IX")],
[DS(5, "Front Attack Plus VII"), DS(10, "Opening Art: Damage Up VII"), DS(10, "Firing Range Up VII"), DS(20, "Potential Up VII"), DS(30, "Mechanoid Slayer VII"), DS(30, "Humanoid Slayer VII"), DS(30, "Piscinoid Slayer VII"), DS(100, "Ranged Accuracy Up VII")],
[DS(5, "Cooldown Reducer VII"), DS(10, "Weapon Attack Power Up VII"), DS(10, "Magazine Capacity Up VII"), DS(20, "Physical Attack Plus VII"), DS(30, "Arts: Recover HP VII"), DS(30, "Critical Chance Up VII"), DS(30, "Ranged Attack Boost VII"), DS(100, "Ranged Attack Up VII")],
[DS(10, "Front Attack Plus VII"), DS(15, "Opening Art: Damage Up VII"), DS(15, "Firing Range Up VII"), DS(25, "Potential Up VII"), DS(35, "Mechanoid Slayer VII"), DS(35, "Humanoid Slayer VII"), DS(35, "Piscinoid Slayer VII"), DS(100, "Destabilizer VII")],
[DS(10, "Cooldown Reducer VII"), DS(15, "Weapon Attack Power Up VII"), DS(15, "Magazine Capacity Up VII"), DS(25, "Physical Attack Plus VII"), DS(35, "Arts: Recover HP VII"), DS(35, "Critical Chance Up VII"), DS(35, "Ranged Attack Boost VII"), DS(100, "Ranged Attack Up VII")],
[DS(5, "Front Attack Plus IX"), DS(10, "Opening Art: Damage Up IX"), DS(10, "Firing Range Up IX"), DS(20, "Potential Up IX"), DS(30, "Mechanoid Slayer IX"), DS(30, "Humanoid Slayer IX"), DS(30, "Piscinoid Slayer IX"), DS(100, "Ranged Accuracy Up IX")],
[DS(5, "Cooldown Reducer IX"), DS(10, "Weapon Attack Power Up IX"), DS(10, "Magazine Capacity Up IX"), DS(20, "Physical Attack Plus IX"), DS(30, "Arts: Recover HP IX"), DS(30, "Critical Chance Up IX"), DS(30, "Ranged Attack Boost IX"), DS(100, "Ranged Attack Up IX")],
[DS(10, "Front Attack Plus IX"), DS(15, "Opening Art: Damage Up IX"), DS(15, "Firing Range Up IX"), DS(25, "Potential Up IX"), DS(35, "Mechanoid Slayer IX"), DS(35, "Humanoid Slayer IX"), DS(35, "Piscinoid Slayer IX"), DS(100, "Destabilizer IX")],
[DS(10, "Cooldown Reducer IX"), DS(15, "Weapon Attack Power Up IX"), DS(15, "Magazine Capacity Up IX"), DS(25, "Physical Attack Plus IX"), DS(35, "Arts: Recover HP IX"), DS(35, "Critical Chance Up IX"), DS(35, "Ranged Attack Boost IX"), DS(100, "Ranged Attack Up IX")],
[DS(5, "Melee: Blaze XI"), DS(10, "Melee: Shock XI"), DS(10, "Melee: TP Gain Up"), DS(20, "Potential Up XI"), DS(30, "Humanoid Criticals Up XI"), DS(30, "Mechanoid Criticals Up XI"), DS(30, "Theroid Criticals Up XI"), DS(100, "Melee Accuracy Up XI")],
[DS(5, "Appendage Crusher"), DS(10, "Weapon Attack Power Up XI"), DS(10, "Critical Chance Up XI"), DS(20, "Melee: Recover HP XI"), DS(30, "Arts: Gain TP XI"), DS(30, "Melee: Physical Res Down XI"), DS(30, "Melee Attack Boost XI"), DS(100, "Melee Attack Up XI")],
[DS(10, "Melee: Blaze XI"), DS(15, "Melee: Shock XI"), DS(15, "Melee: TP Gain Up"), DS(25, "Potential Up XI"), DS(35, "Humanoid Criticals Up XI"), DS(35, "Mechanoid Criticals Up XI"), DS(35, "Theroid Criticals Up XI"), DS(100, "Destabilizer XI")],
[DS(10, "Appendage Crusher"), DS(15, "Weapon Attack Power Up XI"), DS(15, "Critical Chance Up XI"), DS(25, "Melee: Recover HP XI"), DS(35, "Arts: Gain TP XI"), DS(35, "Melee: Physical Res Down XI"), DS(35, "Melee Attack Boost XI"), DS(100, "Melee Attack Up XI")],
[DS(5, "Melee: Blaze XIII"), DS(8, "Melee: Shock XIII"), DS(8, "Melee: TP Gain Up"), DS(10, "Potential Up XIII"), DS(15, "Humanoid Criticals Up XIII"), DS(15, "Mechanoid Criticals Up XIII"), DS(15, "Theroid Criticals Up XIII"), DS(100, "Melee Accuracy Up XIII")],
[DS(5, "Appendage Crusher"), DS(8, "Weapon Attack Power Up XIII"), DS(8, "Critical Chance Up XIII"), DS(10, "Melee: Recover HP XIII"), DS(15, "Arts: Gain TP XIII"), DS(15, "Melee: Physical Res Down XIII"), DS(15, "Melee Attack Boost XIII"), DS(100, "Melee Attack Up XIII")],
[DS(3, "Melee: Blaze XV"), DS(5, "Melee: Shock XV"), DS(5, "Melee: TP Gain Up"), DS(8, "Potential Up XV"), DS(10, "Humanoid Criticals Up XV"), DS(10, "Mechanoid Criticals Up XV"), DS(10, "Theroid Criticals Up XV"), DS(100, "Melee Accuracy Up XV")],
[DS(3, "Appendage Crusher"), DS(5, "Weapon Attack Power Up XV"), DS(5, "Critical Chance Up XV"), DS(8, "Melee: Recover HP XV"), DS(10, "Arts: Gain TP XV"), DS(10, "Melee: Physical Res Down XV"), DS(10, "Melee Attack Boost XV"), DS(100, "Melee Attack Up XV")],
[DS(5, "Ether Resistance Up XI"), DS(10, "Front Attack Plus XI"), DS(10, "Electric Resistance Up XI"), DS(20, "Resist Stagger XI"), DS(30, "Humanoid Criticals Up XI"), DS(30, "Mechanoid Criticals Up XI"), DS(30, "Theroid Criticals Up XI"), DS(100, "Melee Accuracy Up XI")],
[DS(5, "Gravity Resistance Up XI"), DS(10, "Weapon Attack Power Up XI"), DS(10, "Thermal Resistance Up XI"), DS(20, "Resist Topple XI"), DS(30, "Topple: Barrier XI"), DS(30, "Resist Launch XI"), DS(30, "Resist Knockback XI"), DS(100, "Melee Attack Up XI")],
[DS(10, "Ether Resistance Up XI"), DS(15, "Front Attack Plus XI"), DS(15, "Electric Resistance Up XI"), DS(25, "Resist Stagger XI"), DS(35, "Humanoid Criticals Up XI"), DS(35, "Mechanoid Criticals Up XI"), DS(35, "Theroid Criticals Up XI"), DS(100, "Destabilizer XI")],
[DS(10, "Gravity Resistance Up XI"), DS(15, "Weapon Attack Power Up XI"), DS(15, "Thermal Resistance Up XI"), DS(25, "Resist Topple XI"), DS(35, "Topple: Barrier XI"), DS(35, "Resist Launch XI"), DS(35, "Resist Knockback XI"), DS(100, "Melee Attack Up XI")],
[DS(5, "Ether Resistance Up XIII"), DS(8, "Front Attack Plus XIII"), DS(8, "Electric Resistance Up XIII"), DS(10, "Resist Stagger XIII"), DS(15, "Humanoid Criticals Up XIII"), DS(15, "Mechanoid Criticals Up XIII"), DS(15, "Theroid Criticals Up XIII"), DS(100, "Melee Accuracy Up XIII")],
[DS(5, "Gravity Resistance Up XIII"), DS(8, "Weapon Attack Power Up XIII"), DS(8, "Thermal Resistance Up XIII"), DS(10, "Resist Topple XIII"), DS(15, "Topple: Barrier XIII"), DS(15, "Resist Launch XIII"), DS(15, "Resist Knockback XIII"), DS(100, "Melee Attack Up XIII")],
[DS(3, "Ether Resistance Up XV"), DS(5, "Front Attack Plus XV"), DS(5, "Electric Resistance Up XV"), DS(8, "Resist Stagger XV"), DS(10, "Humanoid Criticals Up XV"), DS(10, "Mechanoid Criticals Up XV"), DS(10, "Theroid Criticals Up XV"), DS(100, "Melee Accuracy Up XV")],
[DS(3, "Gravity Resistance Up XV"), DS(5, "Weapon Attack Power Up XV"), DS(5, "Thermal Resistance Up XV"), DS(8, "Resist Topple XV"), DS(10, "Topple: Barrier XV"), DS(10, "Resist Launch XV"), DS(10, "Resist Knockback XV"), DS(100, "Melee Attack Up XV")],
[DS(5, "Front Attack Plus XI"), DS(10, "Opening Art: Damage Up XI"), DS(10, "Firing Range Up XI"), DS(20, "Potential Up XI"), DS(30, "Mechanoid Slayer XI"), DS(30, "Humanoid Slayer XI"), DS(30, "Piscinoid Slayer XI"), DS(100, "Ranged Accuracy Up XI")],
[DS(5, "Cooldown Reducer XI"), DS(10, "Weapon Attack Power Up XI"), DS(10, "Magazine Capacity Up XI"), DS(20, "Physical Attack Plus XI"), DS(30, "Arts: Recover HP XI"), DS(30, "Critical Chance Up XI"), DS(30, "Ranged Attack Boost XI"), DS(100, "Ranged Attack Up XI")],
[DS(10, "Front Attack Plus XI"), DS(15, "Opening Art: Damage Up XI"), DS(15, "Firing Range Up XI"), DS(25, "Potential Up XI"), DS(35, "Mechanoid Slayer XI"), DS(35, "Humanoid Slayer XI"), DS(35, "Piscinoid Slayer XI"), DS(100, "Destabilizer XI")],
[DS(10, "Cooldown Reducer XI"), DS(15, "Weapon Attack Power Up XI"), DS(15, "Magazine Capacity Up XI"), DS(25, "Physical Attack Plus XI"), DS(35, "Arts: Recover HP XI"), DS(35, "Critical Chance Up XI"), DS(35, "Ranged Attack Boost XI"), DS(100, "Ranged Attack Up XI")],
[DS(5, "Front Attack Plus XIII"), DS(8, "Opening Art: Damage Up XIII"), DS(8, "Firing Range Up XIII"), DS(10, "Potential Up XIII"), DS(15, "Mechanoid Slayer XIII"), DS(15, "Humanoid Slayer XIII"), DS(15, "Piscinoid Slayer XIII"), DS(100, "Ranged Accuracy Up XIII")],
[DS(5, "Cooldown Reducer XIII"), DS(8, "Weapon Attack Power Up XIII"), DS(8, "Magazine Capacity Up XIII"), DS(10, "Physical Attack Plus XIII"), DS(15, "Arts: Recover HP XIII"), DS(15, "Critical Chance Up XIII"), DS(15, "Ranged Attack Boost XIII"), DS(100, "Ranged Attack Up XIII")],
[DS(3, "Front Attack Plus XV"), DS(5, "Opening Art: Damage Up XV"), DS(5, "Firing Range Up XV"), DS(8, "Potential Up XV"), DS(10, "Mechanoid Slayer XV"), DS(10, "Humanoid Slayer XV"), DS(10, "Piscinoid Slayer XV"), DS(100, "Ranged Accuracy Up XV")],
[DS(3, "Cooldown Reducer XV"), DS(5, "Weapon Attack Power Up XV"), DS(5, "Magazine Capacity Up XV"), DS(8, "Physical Attack Plus XV"), DS(10, "Arts: Recover HP XV"), DS(10, "Critical Chance Up XV"), DS(10, "Ranged Attack Boost XV"), DS(100, "Ranged Attack Up XV")],
[DS(5, "Melee: Fatigue I"), DS(10, "Mechanoid Criticals Up I"), DS(10, "Humanoid Criticals Up I"), DS(20, "Potential Up I"), DS(30, "Insectoid Criticals Up I"), DS(30, "Theroid Criticals Up I"), DS(30, "Piscinoid Criticals Up I"), DS(100, "Stabilizer I")],
[DS(5, "Weapon Attack Power Up I"), DS(10, "Potential Boost I"), DS(10, "Critical Chance Up I"), DS(20, "Melee: Recover HP I"), DS(30, "Arts: Recover HP I"), DS(30, "Melee: Beam Res Down I"), DS(30, "Melee Accuracy Boost I"), DS(100, "Melee Accuracy Up I")],
[DS(10, "Melee: Fatigue I"), DS(15, "Mechanoid Criticals Up I"), DS(15, "Humanoid Criticals Up I"), DS(25, "Potential Up I"), DS(35, "Insectoid Criticals Up I"), DS(35, "Theroid Criticals Up I"), DS(35, "Piscinoid Criticals Up I"), DS(100, "Destabilizer I")],
[DS(10, "Weapon Attack Power Up I"), DS(15, "Potential Boost I"), DS(15, "Critical Chance Up I"), DS(25, "Melee: Recover HP I"), DS(35, "Arts: Recover HP I"), DS(35, "Melee: Beam Res Down I"), DS(35, "Melee Accuracy Boost I"), DS(100, "Melee Accuracy Up I")],
[DS(5, "Side Attack Plus I"), DS(10, "Overdrive Count Up I"), DS(10, "Humanoid Slayer I"), DS(20, "Potential Up I"), DS(30, "Theroid Slayer I"), DS(30, "Piscinoid Slayer I"), DS(30, "Insectoid Slayer I"), DS(100, "Stabilizer I")],
[DS(5, "Weapon Attack Power Up I"), DS(10, "Ranged: TP Gain Up"), DS(10, "Magazine Capacity Up I"), DS(20, "Beam Attack Plus I"), DS(30, "Arts: Gain TP I"), DS(30, "Critical Chance Up I"), DS(30, "Ranged Accuracy Boost I"), DS(100, "Ranged Accuracy Up I")],
[DS(10, "Side Attack Plus I"), DS(15, "Overdrive Count Up I"), DS(15, "Humanoid Slayer I"), DS(25, "Potential Up I"), DS(35, "Theroid Slayer I"), DS(35, "Piscinoid Slayer I"), DS(35, "Insectoid Slayer I"), DS(100, "Destabilizer I")],
[DS(10, "Weapon Attack Power Up I"), DS(15, "Ranged: TP Gain Up"), DS(15, "Magazine Capacity Up I"), DS(25, "Beam Attack Plus I"), DS(35, "Arts: Gain TP I"), DS(35, "Critical Chance Up I"), DS(35, "Ranged Accuracy Boost I"), DS(100, "Ranged Accuracy Up I")],
[DS(5, "Melee: Fatigue III"), DS(10, "Mechanoid Criticals Up III"), DS(10, "Humanoid Criticals Up III"), DS(20, "Potential Up III"), DS(30, "Insectoid Criticals Up III"), DS(30, "Theroid Criticals Up III"), DS(30, "Piscinoid Criticals Up III"), DS(100, "Stabilizer III")],
[DS(5, "Weapon Attack Power Up III"), DS(10, "Potential Boost III"), DS(10, "Critical Chance Up III"), DS(20, "Melee: Recover HP III"), DS(30, "Arts: Recover HP III"), DS(30, "Melee: Beam Res Down III"), DS(30, "Melee Accuracy Boost III"), DS(100, "Melee Accuracy Up III")],
[DS(10, "Melee: Fatigue III"), DS(15, "Mechanoid Criticals Up III"), DS(15, "Humanoid Criticals Up III"), DS(25, "Potential Up III"), DS(35, "Insectoid Criticals Up III"), DS(35, "Theroid Criticals Up III"), DS(35, "Piscinoid Criticals Up III"), DS(100, "Destabilizer III")],
[DS(10, "Weapon Attack Power Up III"), DS(15, "Potential Boost III"), DS(15, "Critical Chance Up III"), DS(25, "Melee: Recover HP III"), DS(35, "Arts: Recover HP III"), DS(35, "Melee: Beam Res Down III"), DS(35, "Melee Accuracy Boost III"), DS(100, "Melee Accuracy Up III")],
[DS(5, "Melee: Fatigue V"), DS(10, "Mechanoid Criticals Up V"), DS(10, "Humanoid Criticals Up V"), DS(20, "Potential Up V"), DS(30, "Insectoid Criticals Up V"), DS(30, "Theroid Criticals Up V"), DS(30, "Piscinoid Criticals Up V"), DS(100, "Stabilizer V")],
[DS(5, "Weapon Attack Power Up V"), DS(10, "Potential Boost V"), DS(10, "Critical Chance Up V"), DS(20, "Melee: Recover HP V"), DS(30, "Arts: Recover HP V"), DS(30, "Melee: Beam Res Down V"), DS(30, "Melee Accuracy Boost V"), DS(100, "Melee Accuracy Up V")],
[DS(10, "Melee: Fatigue V"), DS(15, "Mechanoid Criticals Up V"), DS(15, "Humanoid Criticals Up V"), DS(25, "Potential Up V"), DS(35, "Insectoid Criticals Up V"), DS(35, "Theroid Criticals Up V"), DS(35, "Piscinoid Criticals Up V"), DS(100, "Destabilizer V")],
[DS(10, "Weapon Attack Power Up V"), DS(15, "Potential Boost V"), DS(15, "Critical Chance Up V"), DS(25, "Melee: Recover HP V"), DS(35, "Arts: Recover HP V"), DS(35, "Melee: Beam Res Down V"), DS(35, "Melee Accuracy Boost V"), DS(100, "Melee Accuracy Up V")],
[DS(5, "Ether Resistance Up I"), DS(10, "Side Attack Plus I"), DS(10, "Physical Resistance Up I"), DS(20, "Resist Flinch I"), DS(30, "Insectoid Criticals Up I"), DS(30, "Theroid Criticals Up I"), DS(30, "Piscinoid Criticals Up I"), DS(100, "Stabilizer I")],
[DS(5, "Gravity Resistance Up I"), DS(10, "Weapon Attack Power Up I"), DS(10, "Resist Topple I"), DS(20, "Resist Stagger I"), DS(30, "Taunt: Decoy I"), DS(30, "Resist Knockback I"), DS(30, "Resist Launch I"), DS(100, "Melee Accuracy Up I")],
[DS(10, "Ether Resistance Up I"), DS(15, "Side Attack Plus I"), DS(15, "Physical Resistance Up I"), DS(25, "Resist Flinch I"), DS(35, "Insectoid Criticals Up I"), DS(35, "Theroid Criticals Up I"), DS(35, "Piscinoid Criticals Up I"), DS(100, "Destabilizer I")],
[DS(10, "Gravity Resistance Up I"), DS(15, "Weapon Attack Power Up I"), DS(15, "Resist Topple I"), DS(25, "Resist Stagger I"), DS(35, "Taunt: Decoy I"), DS(35, "Resist Knockback I"), DS(35, "Resist Launch I"), DS(100, "Melee Accuracy Up I")],
[DS(5, "Ether Resistance Up III"), DS(10, "Side Attack Plus III"), DS(10, "Physical Resistance Up III"), DS(20, "Resist Flinch III"), DS(30, "Insectoid Criticals Up III"), DS(30, "Theroid Criticals Up III"), DS(30, "Piscinoid Criticals Up III"), DS(100, "Stabilizer III")],
[DS(5, "Gravity Resistance Up III"), DS(10, "Weapon Attack Power Up III"), DS(10, "Resist Topple III"), DS(20, "Resist Stagger III"), DS(30, "Taunt: Decoy III"), DS(30, "Resist Knockback III"), DS(30, "Resist Launch III"), DS(100, "Melee Accuracy Up III")],
[DS(10, "Ether Resistance Up III"), DS(15, "Side Attack Plus III"), DS(15, "Physical Resistance Up III"), DS(25, "Resist Flinch III"), DS(35, "Insectoid Criticals Up III"), DS(35, "Theroid Criticals Up III"), DS(35, "Piscinoid Criticals Up III"), DS(100, "Destabilizer III")],
[DS(10, "Gravity Resistance Up III"), DS(15, "Weapon Attack Power Up III"), DS(15, "Resist Topple III"), DS(25, "Resist Stagger III"), DS(35, "Taunt: Decoy III"), DS(35, "Resist Knockback III"), DS(35, "Resist Launch III"), DS(100, "Melee Accuracy Up III")],
[DS(5, "Ether Resistance Up V"), DS(10, "Side Attack Plus V"), DS(10, "Physical Resistance Up V"), DS(20, "Resist Flinch V"), DS(30, "Insectoid Criticals Up V"), DS(30, "Theroid Criticals Up V"), DS(30, "Piscinoid Criticals Up V"), DS(100, "Stabilizer V")],
[DS(5, "Gravity Resistance Up V"), DS(10, "Weapon Attack Power Up V"), DS(10, "Resist Topple V"), DS(20, "Resist Stagger V"), DS(30, "Taunt: Decoy V"), DS(30, "Resist Knockback V"), DS(30, "Resist Launch V"), DS(100, "Melee Accuracy Up V")],
[DS(10, "Ether Resistance Up V"), DS(15, "Side Attack Plus V"), DS(15, "Physical Resistance Up V"), DS(25, "Resist Flinch V"), DS(35, "Insectoid Criticals Up V"), DS(35, "Theroid Criticals Up V"), DS(35, "Piscinoid Criticals Up V"), DS(100, "Destabilizer V")],
[DS(10, "Gravity Resistance Up V"), DS(15, "Weapon Attack Power Up V"), DS(15, "Resist Topple V"), DS(25, "Resist Stagger V"), DS(35, "Taunt: Decoy V"), DS(35, "Resist Knockback V"), DS(35, "Resist Launch V"), DS(100, "Melee Accuracy Up V")],
[DS(5, "Side Attack Plus III"), DS(10, "Overdrive Count Up III"), DS(10, "Humanoid Slayer III"), DS(20, "Potential Up III"), DS(30, "Theroid Slayer III"), DS(30, "Piscinoid Slayer III"), DS(30, "Insectoid Slayer III"), DS(100, "Stabilizer III")],
[DS(5, "Weapon Attack Power Up III"), DS(10, "Ranged: TP Gain Up"), DS(10, "Magazine Capacity Up III"), DS(20, "Beam Attack Plus III"), DS(30, "Arts: Gain TP III"), DS(30, "Critical Chance Up III"), DS(30, "Ranged Accuracy Boost III"), DS(100, "Ranged Accuracy Up III")],
[DS(10, "Side Attack Plus III"), DS(15, "Overdrive Count Up III"), DS(15, "Humanoid Slayer III"), DS(25, "Potential Up III"), DS(35, "Theroid Slayer III"), DS(35, "Piscinoid Slayer III"), DS(35, "Insectoid Slayer III"), DS(100, "Destabilizer III")],
[DS(10, "Weapon Attack Power Up III"), DS(15, "Ranged: TP Gain Up"), DS(15, "Magazine Capacity Up III"), DS(25, "Beam Attack Plus III"), DS(35, "Arts: Gain TP III"), DS(35, "Critical Chance Up III"), DS(35, "Ranged Accuracy Boost III"), DS(100, "Ranged Accuracy Up III")],
[DS(5, "Side Attack Plus V"), DS(10, "Overdrive Count Up V"), DS(10, "Humanoid Slayer V"), DS(20, "Potential Up V"), DS(30, "Theroid Slayer V"), DS(30, "Piscinoid Slayer V"), DS(30, "Insectoid Slayer V"), DS(100, "Stabilizer V")],
[DS(5, "Weapon Attack Power Up V"), DS(10, "Ranged: TP Gain Up"), DS(10, "Magazine Capacity Up V"), DS(20, "Beam Attack Plus V"), DS(30, "Arts: Gain TP V"), DS(30, "Critical Chance Up V"), DS(30, "Ranged Accuracy Boost V"), DS(100, "Ranged Accuracy Up V")],
[DS(10, "Side Attack Plus V"), DS(15, "Overdrive Count Up V"), DS(15, "Humanoid Slayer V"), DS(25, "Potential Up V"), DS(35, "Theroid Slayer V"), DS(35, "Piscinoid Slayer V"), DS(35, "Insectoid Slayer V"), DS(100, "Destabilizer V")],
[DS(10, "Weapon Attack Power Up V"), DS(15, "Ranged: TP Gain Up"), DS(15, "Magazine Capacity Up V"), DS(25, "Beam Attack Plus V"), DS(35, "Arts: Gain TP V"), DS(35, "Critical Chance Up V"), DS(35, "Ranged Accuracy Boost V"), DS(100, "Ranged Accuracy Up V")],
[DS(5, "Melee: Fatigue VII"), DS(10, "Mechanoid Criticals Up VII"), DS(10, "Humanoid Criticals Up VII"), DS(20, "Potential Up VII"), DS(30, "Insectoid Criticals Up VII"), DS(30, "Theroid Criticals Up VII"), DS(30, "Piscinoid Criticals Up VII"), DS(100, "Stabilizer VII")],
[DS(5, "Weapon Attack Power Up VII"), DS(10, "Potential Boost VII"), DS(10, "Critical Chance Up VII"), DS(20, "Melee: Recover HP VII"), DS(30, "Arts: Recover HP VII"), DS(30, "Melee: Beam Res Down VII"), DS(30, "Melee Accuracy Boost VII"), DS(100, "Melee Accuracy Up VII")],
[DS(10, "Melee: Fatigue VII"), DS(15, "Mechanoid Criticals Up VII"), DS(15, "Humanoid Criticals Up VII"), DS(25, "Potential Up VII"), DS(35, "Insectoid Criticals Up VII"), DS(35, "Theroid Criticals Up VII"), DS(35, "Piscinoid Criticals Up VII"), DS(100, "Destabilizer VII")],
[DS(10, "Weapon Attack Power Up VII"), DS(15, "Potential Boost VII"), DS(15, "Critical Chance Up VII"), DS(25, "Melee: Recover HP VII"), DS(35, "Arts: Recover HP VII"), DS(35, "Melee: Beam Res Down VII"), DS(35, "Melee Accuracy Boost VII"), DS(100, "Melee Accuracy Up VII")],
[DS(5, "Melee: Fatigue IX"), DS(10, "Mechanoid Criticals Up IX"), DS(10, "Humanoid Criticals Up IX"), DS(20, "Potential Up IX"), DS(30, "Insectoid Criticals Up IX"), DS(30, "Theroid Criticals Up IX"), DS(30, "Piscinoid Criticals Up IX"), DS(100, "Stabilizer IX")],
[DS(5, "Weapon Attack Power Up IX"), DS(10, "Potential Boost IX"), DS(10, "Critical Chance Up IX"), DS(20, "Melee: Recover HP IX"), DS(30, "Arts: Recover HP IX"), DS(30, "Melee: Beam Res Down IX"), DS(30, "Melee Accuracy Boost IX"), DS(100, "Melee Accuracy Up IX")],
[DS(10, "Melee: Fatigue IX"), DS(15, "Mechanoid Criticals Up IX"), DS(15, "Humanoid Criticals Up IX"), DS(25, "Potential Up IX"), DS(35, "Insectoid Criticals Up IX"), DS(35, "Theroid Criticals Up IX"), DS(35, "Piscinoid Criticals Up IX"), DS(100, "Destabilizer IX")],
[DS(10, "Weapon Attack Power Up IX"), DS(15, "Potential Boost IX"), DS(15, "Critical Chance Up IX"), DS(25, "Melee: Recover HP IX"), DS(35, "Arts: Recover HP IX"), DS(35, "Melee: Beam Res Down IX"), DS(35, "Melee Accuracy Boost IX"), DS(100, "Melee Accuracy Up IX")],
[DS(5, "Ether Resistance Up VII"), DS(10, "Side Attack Plus VII"), DS(10, "Physical Resistance Up VII"), DS(20, "Resist Flinch VII"), DS(30, "Insectoid Criticals Up VII"), DS(30, "Theroid Criticals Up VII"), DS(30, "Piscinoid Criticals Up VII"), DS(100, "Stabilizer VII")],
[DS(5, "Gravity Resistance Up VII"), DS(10, "Weapon Attack Power Up VII"), DS(10, "Resist Topple VII"), DS(20, "Resist Stagger VII"), DS(30, "Taunt: Decoy VII"), DS(30, "Resist Knockback VII"), DS(30, "Resist Launch VII"), DS(100, "Melee Accuracy Up VII")],
[DS(10, "Ether Resistance Up VII"), DS(15, "Side Attack Plus VII"), DS(15, "Physical Resistance Up VII"), DS(25, "Resist Flinch VII"), DS(35, "Insectoid Criticals Up VII"), DS(35, "Theroid Criticals Up VII"), DS(35, "Piscinoid Criticals Up VII"), DS(100, "Destabilizer VII")],
[DS(10, "Gravity Resistance Up VII"), DS(15, "Weapon Attack Power Up VII"), DS(15, "Resist Topple VII"), DS(25, "Resist Stagger VII"), DS(35, "Taunt: Decoy VII"), DS(35, "Resist Knockback VII"), DS(35, "Resist Launch VII"), DS(100, "Melee Accuracy Up VII")],
[DS(5, "Ether Resistance Up IX"), DS(10, "Side Attack Plus IX"), DS(10, "Physical Resistance Up IX"), DS(20, "Resist Flinch IX"), DS(30, "Insectoid Criticals Up IX"), DS(30, "Theroid Criticals Up IX"), DS(30, "Piscinoid Criticals Up IX"), DS(100, "Stabilizer IX")],
[DS(5, "Gravity Resistance Up IX"), DS(10, "Weapon Attack Power Up IX"), DS(10, "Resist Topple IX"), DS(20, "Resist Stagger IX"), DS(30, "Taunt: Decoy IX"), DS(30, "Resist Knockback IX"), DS(30, "Resist Launch IX"), DS(100, "Melee Accuracy Up IX")],
[DS(10, "Ether Resistance Up IX"), DS(15, "Side Attack Plus IX"), DS(15, "Physical Resistance Up IX"), DS(25, "Resist Flinch IX"), DS(35, "Insectoid Criticals Up IX"), DS(35, "Theroid Criticals Up IX"), DS(35, "Piscinoid Criticals Up IX"), DS(100, "Destabilizer IX")],
[DS(10, "Gravity Resistance Up IX"), DS(15, "Weapon Attack Power Up IX"), DS(15, "Resist Topple IX"), DS(25, "Resist Stagger IX"), DS(35, "Taunt: Decoy IX"), DS(35, "Resist Knockback IX"), DS(35, "Resist Launch IX"), DS(100, "Melee Accuracy Up IX")],
[DS(5, "Side Attack Plus VII"), DS(10, "Overdrive Count Up VII"), DS(10, "Humanoid Slayer VII"), DS(20, "Potential Up VII"), DS(30, "Theroid Slayer VII"), DS(30, "Piscinoid Slayer VII"), DS(30, "Insectoid Slayer VII"), DS(100, "Stabilizer VII")],
[DS(5, "Weapon Attack Power Up VII"), DS(10, "Ranged: TP Gain Up"), DS(10, "Magazine Capacity Up VII"), DS(20, "Beam Attack Plus VII"), DS(30, "Arts: Gain TP VII"), DS(30, "Critical Chance Up VII"), DS(30, "Ranged Accuracy Boost VII"), DS(100, "Ranged Accuracy Up VII")],
[DS(10, "Side Attack Plus VII"), DS(15, "Overdrive Count Up VII"), DS(15, "Humanoid Slayer VII"), DS(25, "Potential Up VII"), DS(35, "Theroid Slayer VII"), DS(35, "Piscinoid Slayer VII"), DS(35, "Insectoid Slayer VII"), DS(100, "Destabilizer VII")],
[DS(10, "Weapon Attack Power Up VII"), DS(15, "Ranged: TP Gain Up"), DS(15, "Magazine Capacity Up VII"), DS(25, "Beam Attack Plus VII"), DS(35, "Arts: Gain TP VII"), DS(35, "Critical Chance Up VII"), DS(35, "Ranged Accuracy Boost VII"), DS(100, "Ranged Accuracy Up VII")],
[DS(5, "Side Attack Plus IX"), DS(10, "Overdrive Count Up IX"), DS(10, "Humanoid Slayer IX"), DS(20, "Potential Up IX"), DS(30, "Theroid Slayer IX"), DS(30, "Piscinoid Slayer IX"), DS(30, "Insectoid Slayer IX"), DS(100, "Stabilizer IX")],
[DS(5, "Weapon Attack Power Up IX"), DS(10, "Ranged: TP Gain Up"), DS(10, "Magazine Capacity Up IX"), DS(20, "Beam Attack Plus IX"), DS(30, "Arts: Gain TP IX"), DS(30, "Critical Chance Up IX"), DS(30, "Ranged Accuracy Boost IX"), DS(100, "Ranged Accuracy Up IX")],
[DS(10, "Side Attack Plus IX"), DS(15, "Overdrive Count Up IX"), DS(15, "Humanoid Slayer IX"), DS(25, "Potential Up IX"), DS(35, "Theroid Slayer IX"), DS(35, "Piscinoid Slayer IX"), DS(35, "Insectoid Slayer IX"), DS(100, "Destabilizer IX")],
[DS(10, "Weapon Attack Power Up IX"), DS(15, "Ranged: TP Gain Up"), DS(15, "Magazine Capacity Up IX"), DS(25, "Beam Attack Plus IX"), DS(35, "Arts: Gain TP IX"), DS(35, "Critical Chance Up IX"), DS(35, "Ranged Accuracy Boost IX"), DS(100, "Ranged Accuracy Up IX")],
[DS(5, "Melee: Fatigue XI"), DS(10, "Mechanoid Criticals Up XI"), DS(10, "Humanoid Criticals Up XI"), DS(20, "Potential Up XI"), DS(30, "Insectoid Criticals Up XI"), DS(30, "Theroid Criticals Up XI"), DS(30, "Piscinoid Criticals Up XI"), DS(100, "Stabilizer XI")],
[DS(5, "Weapon Attack Power Up XI"), DS(10, "Potential Boost XI"), DS(10, "Critical Chance Up XI"), DS(20, "Melee: Recover HP XI"), DS(30, "Arts: Recover HP XI"), DS(30, "Melee: Beam Res Down XI"), DS(30, "Melee Accuracy Boost XI"), DS(100, "Melee Accuracy Up XI")],
[DS(10, "Melee: Fatigue XI"), DS(15, "Mechanoid Criticals Up XI"), DS(15, "Humanoid Criticals Up XI"), DS(25, "Potential Up XI"), DS(35, "Insectoid Criticals Up XI"), DS(35, "Theroid Criticals Up XI"), DS(35, "Piscinoid Criticals Up XI"), DS(100, "Destabilizer XI")],
[DS(10, "Weapon Attack Power Up XI"), DS(15, "Potential Boost XI"), DS(15, "Critical Chance Up XI"), DS(25, "Melee: Recover HP XI"), DS(35, "Arts: Recover HP XI"), DS(35, "Melee: Beam Res Down XI"), DS(35, "Melee Accuracy Boost XI"), DS(100, "Melee Accuracy Up XI")],
[DS(5, "Melee: Fatigue XIII"), DS(8, "Mechanoid Criticals Up XIII"), DS(8, "Humanoid Criticals Up XIII"), DS(10, "Potential Up XIII"), DS(15, "Insectoid Criticals Up XIII"), DS(15, "Theroid Criticals Up XIII"), DS(15, "Piscinoid Criticals Up XIII"), DS(100, "Stabilizer XIII")],
[DS(5, "Weapon Attack Power Up XIII"), DS(8, "Potential Boost XIII"), DS(8, "Critical Chance Up XIII"), DS(10, "Melee: Recover HP XIII"), DS(15, "Arts: Recover HP XIII"), DS(15, "Melee: Beam Res Down XIII"), DS(15, "Melee Accuracy Boost XIII"), DS(100, "Melee Accuracy Up XIII")],
[DS(3, "Melee: Fatigue XV"), DS(5, "Mechanoid Criticals Up XV"), DS(5, "Humanoid Criticals Up XV"), DS(8, "Potential Up XV"), DS(10, "Insectoid Criticals Up XV"), DS(10, "Theroid Criticals Up XV"), DS(10, "Piscinoid Criticals Up XV"), DS(100, "Stabilizer XV")],
[DS(3, "Weapon Attack Power Up XV"), DS(5, "Potential Boost XV"), DS(5, "Critical Chance Up XV"), DS(8, "Melee: Recover HP XV"), DS(10, "Arts: Recover HP XV"), DS(10, "Melee: Beam Res Down XV"), DS(10, "Melee Accuracy Boost XV"), DS(100, "Melee Accuracy Up XV")],
[DS(5, "Ether Resistance Up XI"), DS(10, "Side Attack Plus XI"), DS(10, "Physical Resistance Up XI"), DS(20, "Resist Flinch XI"), DS(30, "Insectoid Criticals Up XI"), DS(30, "Theroid Criticals Up XI"), DS(30, "Piscinoid Criticals Up XI"), DS(100, "Stabilizer XI")],
[DS(5, "Gravity Resistance Up XI"), DS(10, "Weapon Attack Power Up XI"), DS(10, "Resist Topple XI"), DS(20, "Resist Stagger XI"), DS(30, "Taunt: Decoy XI"), DS(30, "Resist Knockback XI"), DS(30, "Resist Launch XI"), DS(100, "Melee Accuracy Up XI")],
[DS(10, "Ether Resistance Up XI"), DS(15, "Side Attack Plus XI"), DS(15, "Physical Resistance Up XI"), DS(25, "Resist Flinch XI"), DS(35, "Insectoid Criticals Up XI"), DS(35, "Theroid Criticals Up XI"), DS(35, "Piscinoid Criticals Up XI"), DS(100, "Destabilizer XI")],
[DS(10, "Gravity Resistance Up XI"), DS(15, "Weapon Attack Power Up XI"), DS(15, "Resist Topple XI"), DS(25, "Resist Stagger XI"), DS(35, "Taunt: Decoy XI"), DS(35, "Resist Knockback XI"), DS(35, "Resist Launch XI"), DS(100, "Melee Accuracy Up XI")],
[DS(5, "Ether Resistance Up XIII"), DS(8, "Side Attack Plus XIII"), DS(8, "Physical Resistance Up XIII"), DS(10, "Resist Flinch XIII"), DS(15, "Insectoid Criticals Up XIII"), DS(15, "Theroid Criticals Up XIII"), DS(15, "Piscinoid Criticals Up XIII"), DS(100, "Stabilizer XIII")],
[DS(5, "Gravity Resistance Up XIII"), DS(8, "Weapon Attack Power Up XIII"), DS(8, "Resist Topple XIII"), DS(10, "Resist Stagger XIII"), DS(15, "Taunt: Decoy XIII"), DS(15, "Resist Knockback XIII"), DS(15, "Resist Launch XIII"), DS(100, "Melee Accuracy Up XIII")],
[DS(3, "Ether Resistance Up XV"), DS(5, "Side Attack Plus XV"), DS(5, "Physical Resistance Up XV"), DS(8, "Resist Flinch XV"), DS(10, "Insectoid Criticals Up XV"), DS(10, "Theroid Criticals Up XV"), DS(10, "Piscinoid Criticals Up XV"), DS(100, "Stabilizer XV")],
[DS(3, "Gravity Resistance Up XV"), DS(5, "Weapon Attack Power Up XV"), DS(5, "Resist Topple XV"), DS(8, "Resist Stagger XV"), DS(10, "Taunt: Decoy XV"), DS(10, "Resist Knockback XV"), DS(10, "Resist Launch XV"), DS(100, "Melee Accuracy Up XV")],
[DS(5, "Side Attack Plus XI"), DS(10, "Overdrive Count Up XI"), DS(10, "Humanoid Slayer XI"), DS(20, "Potential Up XI"), DS(30, "Theroid Slayer XI"), DS(30, "Piscinoid Slayer XI"), DS(30, "Insectoid Slayer XI"), DS(100, "Stabilizer XI")],
[DS(5, "Weapon Attack Power Up XI"), DS(10, "Ranged: TP Gain Up"), DS(10, "Magazine Capacity Up XI"), DS(20, "Beam Attack Plus XI"), DS(30, "Arts: Gain TP XI"), DS(30, "Critical Chance Up XI"), DS(30, "Ranged Accuracy Boost XI"), DS(100, "Ranged Accuracy Up XI")],
[DS(10, "Side Attack Plus XI"), DS(15, "Overdrive Count Up XI"), DS(15, "Humanoid Slayer XI"), DS(25, "Potential Up XI"), DS(35, "Theroid Slayer XI"), DS(35, "Piscinoid Slayer XI"), DS(35, "Insectoid Slayer XI"), DS(100, "Destabilizer XI")],
[DS(10, "Weapon Attack Power Up XI"), DS(15, "Ranged: TP Gain Up"), DS(15, "Magazine Capacity Up XI"), DS(25, "Beam Attack Plus XI"), DS(35, "Arts: Gain TP XI"), DS(35, "Critical Chance Up XI"), DS(35, "Ranged Accuracy Boost XI"), DS(100, "Ranged Accuracy Up XI")],
[DS(5, "Side Attack Plus XIII"), DS(8, "Overdrive Count Up XIII"), DS(8, "Humanoid Slayer XIII"), DS(10, "Potential Up XIII"), DS(15, "Theroid Slayer XIII"), DS(15, "Piscinoid Slayer XIII"), DS(15, "Insectoid Slayer XIII"), DS(100, "Stabilizer XIII")],
[DS(5, "Weapon Attack Power Up XIII"), DS(8, "Ranged: TP Gain Up"), DS(8, "Magazine Capacity Up XIII"), DS(10, "Beam Attack Plus XIII"), DS(15, "Arts: Gain TP XIII"), DS(15, "Critical Chance Up XIII"), DS(15, "Ranged Accuracy Boost XIII"), DS(100, "Ranged Accuracy Up XIII")],
[DS(3, "Side Attack Plus XV"), DS(5, "Overdrive Count Up XV"), DS(5, "Humanoid Slayer XV"), DS(8, "Potential Up XV"), DS(10, "Theroid Slayer XV"), DS(10, "Piscinoid Slayer XV"), DS(10, "Insectoid Slayer XV"), DS(100, "Stabilizer XV")],
[DS(3, "Weapon Attack Power Up XV"), DS(5, "Ranged: TP Gain Up"), DS(5, "Magazine Capacity Up XV"), DS(8, "Beam Attack Plus XV"), DS(10, "Arts: Gain TP XV"), DS(10, "Critical Chance Up XV"), DS(10, "Ranged Accuracy Boost XV"), DS(100, "Ranged Accuracy Up XV")],
[DS(5, "Melee: Ether Res Down III"), DS(10, "Potential Boost III"), DS(10, "Melee: TP Gain Up"), DS(20, "Humanoid Criticals Up III"), DS(30, "Mechanoid Criticals Up III"), DS(30, "Piscinoid Criticals Up III"), DS(30, "Night Vision III"), DS(100, "Melee Accuracy Up III")],
[DS(5, "Weapon Attack Power Up III"), DS(10, "Crush: Gain TP III"), DS(10, "Critical Chance Up III"), DS(20, "Arts: Gain TP III"), DS(30, "Theroid Criticals Up III"), DS(30, "Insectoid Criticals Up III"), DS(30, "Melee Attack Up III"), DS(100, "Soft Touch III")],
[DS(10, "Melee: Ether Res Down III"), DS(15, "Potential Boost III"), DS(15, "Melee: TP Gain Up"), DS(25, "Humanoid Criticals Up III"), DS(35, "Mechanoid Criticals Up III"), DS(35, "Piscinoid Criticals Up III"), DS(35, "Night Vision III"), DS(100, "Destabilizer III")],
[DS(10, "Weapon Attack Power Up III"), DS(15, "Crush: Gain TP III"), DS(15, "Critical Chance Up III"), DS(25, "Arts: Gain TP III"), DS(35, "Theroid Criticals Up III"), DS(35, "Insectoid Criticals Up III"), DS(35, "Melee Attack Up III"), DS(100, "Soft Touch III")],
[DS(5, "Melee: Ether Res Down V"), DS(10, "Potential Boost V"), DS(10, "Melee: TP Gain Up"), DS(20, "Humanoid Criticals Up V"), DS(30, "Mechanoid Criticals Up V"), DS(30, "Piscinoid Criticals Up V"), DS(30, "Night Vision V"), DS(100, "Melee Accuracy Up V")],
[DS(5, "Weapon Attack Power Up V"), DS(10, "Crush: Gain TP V"), DS(10, "Critical Chance Up V"), DS(20, "Arts: Gain TP V"), DS(30, "Theroid Criticals Up V"), DS(30, "Insectoid Criticals Up V"), DS(30, "Melee Attack Up V"), DS(100, "Soft Touch V")],
[DS(10, "Melee: Ether Res Down V"), DS(15, "Potential Boost V"), DS(15, "Melee: TP Gain Up"), DS(25, "Humanoid Criticals Up V"), DS(35, "Mechanoid Criticals Up V"), DS(35, "Piscinoid Criticals Up V"), DS(35, "Night Vision V"), DS(100, "Destabilizer V")],
[DS(10, "Weapon Attack Power Up V"), DS(15, "Crush: Gain TP V"), DS(15, "Critical Chance Up V"), DS(25, "Arts: Gain TP V"), DS(35, "Theroid Criticals Up V"), DS(35, "Insectoid Criticals Up V"), DS(35, "Melee Attack Up V"), DS(100, "Soft Touch V")],
[DS(5, "Physical Resistance Up III"), DS(10, "Thermal Resistance Up III"), DS(10, "Electric Resistance Up III"), DS(20, "Humanoid Criticals Up III"), DS(30, "Mechanoid Criticals Up III"), DS(30, "Piscinoid Criticals Up III"), DS(30, "Night Vision III"), DS(100, "Melee Accuracy Up III")],
[DS(5, "Gravity Resistance Up III"), DS(10, "Crush: Gain TP III"), DS(10, "Beam Resistance Up III"), DS(20, "Resist Topple III"), DS(30, "Stun: Barrier III"), DS(30, "Resist Launch III"), DS(30, "Resist Flinch III"), DS(100, "Soft Touch III")],
[DS(10, "Physical Resistance Up III"), DS(15, "Thermal Resistance Up III"), DS(15, "Electric Resistance Up III"), DS(25, "Humanoid Criticals Up III"), DS(35, "Mechanoid Criticals Up III"), DS(35, "Piscinoid Criticals Up III"), DS(35, "Night Vision III"), DS(100, "Destabilizer III")],
[DS(10, "Gravity Resistance Up III"), DS(15, "Crush: Gain TP III"), DS(15, "Beam Resistance Up III"), DS(25, "Resist Topple III"), DS(35, "Stun: Barrier III"), DS(35, "Resist Launch III"), DS(35, "Resist Flinch III"), DS(100, "Soft Touch III")],
[DS(5, "Physical Resistance Up V"), DS(10, "Thermal Resistance Up V"), DS(10, "Electric Resistance Up V"), DS(20, "Humanoid Criticals Up V"), DS(30, "Mechanoid Criticals Up V"), DS(30, "Piscinoid Criticals Up V"), DS(30, "Night Vision V"), DS(100, "Melee Accuracy Up V")],
[DS(5, "Gravity Resistance Up V"), DS(10, "Crush: Gain TP V"), DS(10, "Beam Resistance Up V"), DS(20, "Resist Topple V"), DS(30, "Stun: Barrier V"), DS(30, "Resist Launch V"), DS(30, "Resist Flinch V"), DS(100, "Soft Touch V")],
[DS(10, "Physical Resistance Up V"), DS(15, "Thermal Resistance Up V"), DS(15, "Electric Resistance Up V"), DS(25, "Humanoid Criticals Up V"), DS(35, "Mechanoid Criticals Up V"), DS(35, "Piscinoid Criticals Up V"), DS(35, "Night Vision V"), DS(100, "Destabilizer V")],
[DS(10, "Gravity Resistance Up V"), DS(15, "Crush: Gain TP V"), DS(15, "Beam Resistance Up V"), DS(25, "Resist Topple V"), DS(35, "Stun: Barrier V"), DS(35, "Resist Launch V"), DS(35, "Resist Flinch V"), DS(100, "Soft Touch V")],
[DS(5, "Vantage Attack Plus III"), DS(10, "Theroid Slayer III"), DS(10, "Potential Up III"), DS(20, "Mechanoid Slayer III"), DS(30, "Humanoid Slayer III"), DS(30, "Arts: Gain TP III"), DS(30, "Night Vision III"), DS(100, "Ranged Accuracy Up III")],
[DS(5, "Magazine Capacity Up III"), DS(10, "Ranged: TP Gain Up"), DS(10, "Firing Range Up III"), DS(20, "Ether Attack Plus III"), DS(30, "Insectoid Slayer III"), DS(30, "Piscinoid Slayer III"), DS(30, "Ranged Attack Up III"), DS(100, "Soft Touch III")],
[DS(10, "Vantage Attack Plus III"), DS(15, "Theroid Slayer III"), DS(15, "Potential Up III"), DS(25, "Mechanoid Slayer III"), DS(35, "Humanoid Slayer III"), DS(35, "Arts: Gain TP III"), DS(35, "Night Vision III"), DS(100, "Destabilizer III")],
[DS(10, "Magazine Capacity Up III"), DS(15, "Ranged: TP Gain Up"), DS(15, "Firing Range Up III"), DS(25, "Ether Attack Plus III"), DS(35, "Insectoid Slayer III"), DS(35, "Piscinoid Slayer III"), DS(35, "Ranged Attack Up III"), DS(100, "Soft Touch III")],
[DS(5, "Vantage Attack Plus V"), DS(10, "Theroid Slayer V"), DS(10, "Potential Up V"), DS(20, "Mechanoid Slayer V"), DS(30, "Humanoid Slayer V"), DS(30, "Arts: Gain TP V"), DS(30, "Night Vision V"), DS(100, "Ranged Accuracy Up V")],
[DS(5, "Magazine Capacity Up V"), DS(10, "Ranged: TP Gain Up"), DS(10, "Firing Range Up V"), DS(20, "Ether Attack Plus V"), DS(30, "Insectoid Slayer V"), DS(30, "Piscinoid Slayer V"), DS(30, "Ranged Attack Up V"), DS(100, "Soft Touch V")],
[DS(10, "Vantage Attack Plus V"), DS(15, "Theroid Slayer V"), DS(15, "Potential Up V"), DS(25, "Mechanoid Slayer V"), DS(35, "Humanoid Slayer V"), DS(35, "Arts: Gain TP V"), DS(35, "Night Vision V"), DS(100, "Destabilizer V")],
[DS(10, "Magazine Capacity Up V"), DS(15, "Ranged: TP Gain Up"), DS(15, "Firing Range Up V"), DS(25, "Ether Attack Plus V"), DS(35, "Insectoid Slayer V"), DS(35, "Piscinoid Slayer V"), DS(35, "Ranged Attack Up V"), DS(100, "Soft Touch V")],
[DS(5, "Melee: Ether Res Down VII"), DS(10, "Potential Boost VII"), DS(10, "Melee: TP Gain Up"), DS(20, "Humanoid Criticals Up VII"), DS(30, "Mechanoid Criticals Up VII"), DS(30, "Piscinoid Criticals Up VII"), DS(30, "Night Vision VII"), DS(100, "Melee Accuracy Up VII")],
[DS(5, "Weapon Attack Power Up VII"), DS(10, "Crush: Gain TP VII"), DS(10, "Critical Chance Up VII"), DS(20, "Arts: Gain TP VII"), DS(30, "Theroid Criticals Up VII"), DS(30, "Insectoid Criticals Up VII"), DS(30, "Melee Attack Up VII"), DS(100, "Soft Touch VII")],
[DS(10, "Melee: Ether Res Down VII"), DS(15, "Potential Boost VII"), DS(15, "Melee: TP Gain Up"), DS(25, "Humanoid Criticals Up VII"), DS(35, "Mechanoid Criticals Up VII"), DS(35, "Piscinoid Criticals Up VII"), DS(35, "Night Vision VII"), DS(100, "Destabilizer VII")],
[DS(10, "Weapon Attack Power Up VII"), DS(15, "Crush: Gain TP VII"), DS(15, "Critical Chance Up VII"), DS(25, "Arts: Gain TP VII"), DS(35, "Theroid Criticals Up VII"), DS(35, "Insectoid Criticals Up VII"), DS(35, "Melee Attack Up VII"), DS(100, "Soft Touch VII")],
[DS(5, "Melee: Ether Res Down IX"), DS(10, "Potential Boost IX"), DS(10, "Melee: TP Gain Up"), DS(20, "Humanoid Criticals Up IX"), DS(30, "Mechanoid Criticals Up IX"), DS(30, "Piscinoid Criticals Up IX"), DS(30, "Night Vision IX"), DS(100, "Melee Accuracy Up IX")],
[DS(5, "Weapon Attack Power Up IX"), DS(10, "Crush: Gain TP IX"), DS(10, "Critical Chance Up IX"), DS(20, "Arts: Gain TP IX"), DS(30, "Theroid Criticals Up IX"), DS(30, "Insectoid Criticals Up IX"), DS(30, "Melee Attack Up IX"), DS(100, "Soft Touch IX")],
[DS(10, "Melee: Ether Res Down IX"), DS(15, "Potential Boost IX"), DS(15, "Melee: TP Gain Up"), DS(25, "Humanoid Criticals Up IX"), DS(35, "Mechanoid Criticals Up IX"), DS(35, "Piscinoid Criticals Up IX"), DS(35, "Night Vision IX"), DS(100, "Destabilizer IX")],
[DS(10, "Weapon Attack Power Up IX"), DS(15, "Crush: Gain TP IX"), DS(15, "Critical Chance Up IX"), DS(25, "Arts: Gain TP IX"), DS(35, "Theroid Criticals Up IX"), DS(35, "Insectoid Criticals Up IX"), DS(35, "Melee Attack Up IX"), DS(100, "Soft Touch IX")],
[DS(5, "Physical Resistance Up VII"), DS(10, "Thermal Resistance Up VII"), DS(10, "Electric Resistance Up VII"), DS(20, "Humanoid Criticals Up VII"), DS(30, "Mechanoid Criticals Up VII"), DS(30, "Piscinoid Criticals Up VII"), DS(30, "Night Vision VII"), DS(100, "Melee Accuracy Up VII")],
[DS(5, "Gravity Resistance Up VII"), DS(10, "Crush: Gain TP VII"), DS(10, "Beam Resistance Up VII"), DS(20, "Resist Topple VII"), DS(30, "Stun: Barrier VII"), DS(30, "Resist Launch VII"), DS(30, "Resist Flinch VII"), DS(100, "Soft Touch VII")],
[DS(10, "Physical Resistance Up VII"), DS(15, "Thermal Resistance Up VII"), DS(15, "Electric Resistance Up VII"), DS(25, "Humanoid Criticals Up VII"), DS(35, "Mechanoid Criticals Up VII"), DS(35, "Piscinoid Criticals Up VII"), DS(35, "Night Vision VII"), DS(100, "Destabilizer VII")],
[DS(10, "Gravity Resistance Up VII"), DS(15, "Crush: Gain TP VII"), DS(15, "Beam Resistance Up VII"), DS(25, "Resist Topple VII"), DS(35, "Stun: Barrier VII"), DS(35, "Resist Launch VII"), DS(35, "Resist Flinch VII"), DS(100, "Soft Touch VII")],
[DS(5, "Physical Resistance Up IX"), DS(10, "Thermal Resistance Up IX"), DS(10, "Electric Resistance Up IX"), DS(20, "Humanoid Criticals Up IX"), DS(30, "Mechanoid Criticals Up IX"), DS(30, "Piscinoid Criticals Up IX"), DS(30, "Night Vision IX"), DS(100, "Melee Accuracy Up IX")],
[DS(5, "Gravity Resistance Up IX"), DS(10, "Crush: Gain TP IX"), DS(10, "Beam Resistance Up IX"), DS(20, "Resist Topple IX"), DS(30, "Stun: Barrier IX"), DS(30, "Resist Launch IX"), DS(30, "Resist Flinch IX"), DS(100, "Soft Touch IX")],
[DS(10, "Physical Resistance Up IX"), DS(15, "Thermal Resistance Up IX"), DS(15, "Electric Resistance Up IX"), DS(25, "Humanoid Criticals Up IX"), DS(35, "Mechanoid Criticals Up IX"), DS(35, "Piscinoid Criticals Up IX"), DS(35, "Night Vision IX"), DS(100, "Destabilizer IX")],
[DS(10, "Gravity Resistance Up IX"), DS(15, "Crush: Gain TP IX"), DS(15, "Beam Resistance Up IX"), DS(25, "Resist Topple IX"), DS(35, "Stun: Barrier IX"), DS(35, "Resist Launch IX"), DS(35, "Resist Flinch IX"), DS(100, "Soft Touch IX")],
[DS(5, "Vantage Attack Plus VII"), DS(10, "Theroid Slayer VII"), DS(10, "Potential Up VII"), DS(20, "Mechanoid Slayer VII"), DS(30, "Humanoid Slayer VII"), DS(30, "Arts: Gain TP VII"), DS(30, "Night Vision VII"), DS(100, "Ranged Accuracy Up VII")],
[DS(5, "Magazine Capacity Up VII"), DS(10, "Ranged: TP Gain Up"), DS(10, "Firing Range Up VII"), DS(20, "Ether Attack Plus VII"), DS(30, "Insectoid Slayer VII"), DS(30, "Piscinoid Slayer VII"), DS(30, "Ranged Attack Up VII"), DS(100, "Soft Touch VII")],
[DS(10, "Vantage Attack Plus VII"), DS(15, "Theroid Slayer VII"), DS(15, "Potential Up VII"), DS(25, "Mechanoid Slayer VII"), DS(35, "Humanoid Slayer VII"), DS(35, "Arts: Gain TP VII"), DS(35, "Night Vision VII"), DS(100, "Destabilizer VII")],
[DS(10, "Magazine Capacity Up VII"), DS(15, "Ranged: TP Gain Up"), DS(15, "Firing Range Up VII"), DS(25, "Ether Attack Plus VII"), DS(35, "Insectoid Slayer VII"), DS(35, "Piscinoid Slayer VII"), DS(35, "Ranged Attack Up VII"), DS(100, "Soft Touch VII")],
[DS(5, "Vantage Attack Plus IX"), DS(10, "Theroid Slayer IX"), DS(10, "Potential Up IX"), DS(20, "Mechanoid Slayer IX"), DS(30, "Humanoid Slayer IX"), DS(30, "Arts: Gain TP IX"), DS(30, "Night Vision IX"), DS(100, "Ranged Accuracy Up IX")],
[DS(5, "Magazine Capacity Up IX"), DS(10, "Ranged: TP Gain Up"), DS(10, "Firing Range Up IX"), DS(20, "Ether Attack Plus IX"), DS(30, "Insectoid Slayer IX"), DS(30, "Piscinoid Slayer IX"), DS(30, "Ranged Attack Up IX"), DS(100, "Soft Touch IX")],
[DS(10, "Vantage Attack Plus IX"), DS(15, "Theroid Slayer IX"), DS(15, "Potential Up IX"), DS(25, "Mechanoid Slayer IX"), DS(35, "Humanoid Slayer IX"), DS(35, "Arts: Gain TP IX"), DS(35, "Night Vision IX"), DS(100, "Destabilizer IX")],
[DS(10, "Magazine Capacity Up IX"), DS(15, "Ranged: TP Gain Up"), DS(15, "Firing Range Up IX"), DS(25, "Ether Attack Plus IX"), DS(35, "Insectoid Slayer IX"), DS(35, "Piscinoid Slayer IX"), DS(35, "Ranged Attack Up IX"), DS(100, "Soft Touch IX")],
[DS(5, "Melee: Ether Res Down XI"), DS(10, "Potential Boost XI"), DS(10, "Melee: TP Gain Up"), DS(20, "Humanoid Criticals Up XI"), DS(30, "Mechanoid Criticals Up XI"), DS(30, "Piscinoid Criticals Up XI"), DS(30, "Night Vision XI"), DS(100, "Melee Accuracy Up XI")],
[DS(5, "Weapon Attack Power Up XI"), DS(10, "Crush: Gain TP XI"), DS(10, "Critical Chance Up XI"), DS(20, "Arts: Gain TP XI"), DS(30, "Theroid Criticals Up XI"), DS(30, "Insectoid Criticals Up XI"), DS(30, "Melee Attack Up XI"), DS(100, "Soft Touch XI")],
[DS(10, "Melee: Ether Res Down XI"), DS(15, "Potential Boost XI"), DS(15, "Melee: TP Gain Up"), DS(25, "Humanoid Criticals Up XI"), DS(35, "Mechanoid Criticals Up XI"), DS(35, "Piscinoid Criticals Up XI"), DS(35, "Night Vision XI"), DS(100, "Destabilizer XI")],
[DS(10, "Weapon Attack Power Up XI"), DS(15, "Crush: Gain TP XI"), DS(15, "Critical Chance Up XI"), DS(25, "Arts: Gain TP XI"), DS(35, "Theroid Criticals Up XI"), DS(35, "Insectoid Criticals Up XI"), DS(35, "Melee Attack Up XI"), DS(100, "Soft Touch XI")],
[DS(5, "Melee: Ether Res Down XIII"), DS(8, "Potential Boost XIII"), DS(8, "Melee: TP Gain Up"), DS(10, "Humanoid Criticals Up XIII"), DS(15, "Mechanoid Criticals Up XIII"), DS(15, "Piscinoid Criticals Up XIII"), DS(15, "Night Vision XIII"), DS(100, "Melee Accuracy Up XIII")],
[DS(5, "Weapon Attack Power Up XIII"), DS(8, "Crush: Gain TP XIII"), DS(8, "Critical Chance Up XIII"), DS(10, "Arts: Gain TP XIII"), DS(15, "Theroid Criticals Up XIII"), DS(15, "Insectoid Criticals Up XIII"), DS(15, "Melee Attack Up XIII"), DS(100, "Soft Touch XIII")],
[DS(3, "Melee: Ether Res Down XV"), DS(5, "Potential Boost XV"), DS(5, "Melee: TP Gain Up"), DS(8, "Humanoid Criticals Up XV"), DS(10, "Mechanoid Criticals Up XV"), DS(10, "Piscinoid Criticals Up XV"), DS(10, "Night Vision XV"), DS(100, "Melee Accuracy Up XV")],
[DS(3, "Weapon Attack Power Up XV"), DS(5, "Crush: Gain TP XV"), DS(5, "Critical Chance Up XV"), DS(8, "Arts: Gain TP XV"), DS(10, "Theroid Criticals Up XV"), DS(10, "Insectoid Criticals Up XV"), DS(10, "Melee Attack Up XV"), DS(100, "Soft Touch XV")],
[DS(5, "Physical Resistance Up XI"), DS(10, "Thermal Resistance Up XI"), DS(10, "Electric Resistance Up XI"), DS(20, "Humanoid Criticals Up XI"), DS(30, "Mechanoid Criticals Up XI"), DS(30, "Piscinoid Criticals Up XI"), DS(30, "Night Vision XI"), DS(100, "Melee Accuracy Up XI")],
[DS(5, "Gravity Resistance Up XI"), DS(10, "Crush: Gain TP XI"), DS(10, "Beam Resistance Up XI"), DS(20, "Resist Topple XI"), DS(30, "Stun: Barrier XI"), DS(30, "Resist Launch XI"), DS(30, "Resist Flinch XI"), DS(100, "Soft Touch XI")],
[DS(10, "Physical Resistance Up XI"), DS(15, "Thermal Resistance Up XI"), DS(15, "Electric Resistance Up XI"), DS(25, "Humanoid Criticals Up XI"), DS(35, "Mechanoid Criticals Up XI"), DS(35, "Piscinoid Criticals Up XI"), DS(35, "Night Vision XI"), DS(100, "Destabilizer XI")],
[DS(10, "Gravity Resistance Up XI"), DS(15, "Crush: Gain TP XI"), DS(15, "Beam Resistance Up XI"), DS(25, "Resist Topple XI"), DS(35, "Stun: Barrier XI"), DS(35, "Resist Launch XI"), DS(35, "Resist Flinch XI"), DS(100, "Soft Touch XI")],
[DS(5, "Physical Resistance Up XIII"), DS(8, "Thermal Resistance Up XIII"), DS(8, "Electric Resistance Up XIII"), DS(10, "Humanoid Criticals Up XIII"), DS(15, "Mechanoid Criticals Up XIII"), DS(15, "Piscinoid Criticals Up XIII"), DS(15, "Night Vision XIII"), DS(100, "Melee Accuracy Up XIII")],
[DS(5, "Gravity Resistance Up XIII"), DS(8, "Crush: Gain TP XIII"), DS(8, "Beam Resistance Up XIII"), DS(10, "Resist Topple XIII"), DS(15, "Stun: Barrier XIII"), DS(15, "Resist Launch XIII"), DS(15, "Resist Flinch XIII"), DS(100, "Soft Touch XIII")],
[DS(3, "Physical Resistance Up XV"), DS(5, "Thermal Resistance Up XV"), DS(5, "Electric Resistance Up XV"), DS(8, "Humanoid Criticals Up XV"), DS(10, "Mechanoid Criticals Up XV"), DS(10, "Piscinoid Criticals Up XV"), DS(10, "Night Vision XV"), DS(100, "Melee Accuracy Up XV")],
[DS(3, "Gravity Resistance Up XV"), DS(5, "Crush: Gain TP XV"), DS(5, "Beam Resistance Up XV"), DS(8, "Resist Topple XV"), DS(10, "Stun: Barrier XV"), DS(10, "Resist Launch XV"), DS(10, "Resist Flinch XV"), DS(100, "Soft Touch XV")],
[DS(5, "Vantage Attack Plus XI"), DS(10, "Theroid Slayer XI"), DS(10, "Potential Up XI"), DS(20, "Mechanoid Slayer XI"), DS(30, "Humanoid Slayer XI"), DS(30, "Arts: Gain TP XI"), DS(30, "Night Vision XI"), DS(100, "Ranged Accuracy Up XI")],
[DS(5, "Magazine Capacity Up XI"), DS(10, "Ranged: TP Gain Up"), DS(10, "Firing Range Up XI"), DS(20, "Ether Attack Plus XI"), DS(30, "Insectoid Slayer XI"), DS(30, "Piscinoid Slayer XI"), DS(30, "Ranged Attack Up XI"), DS(100, "Soft Touch XI")],
[DS(10, "Vantage Attack Plus XI"), DS(15, "Theroid Slayer XI"), DS(15, "Potential Up XI"), DS(25, "Mechanoid Slayer XI"), DS(35, "Humanoid Slayer XI"), DS(35, "Arts: Gain TP XI"), DS(35, "Night Vision XI"), DS(100, "Destabilizer XI")],
[DS(10, "Magazine Capacity Up XI"), DS(15, "Ranged: TP Gain Up"), DS(15, "Firing Range Up XI"), DS(25, "Ether Attack Plus XI"), DS(35, "Insectoid Slayer XI"), DS(35, "Piscinoid Slayer XI"), DS(35, "Ranged Attack Up XI"), DS(100, "Soft Touch XI")],
[DS(5, "Vantage Attack Plus XIII"), DS(8, "Theroid Slayer XIII"), DS(8, "Potential Up XIII"), DS(10, "Mechanoid Slayer XIII"), DS(15, "Humanoid Slayer XIII"), DS(15, "Arts: Gain TP XIII"), DS(15, "Night Vision XIII"), DS(100, "Ranged Accuracy Up XIII")],
[DS(5, "Magazine Capacity Up XIII"), DS(8, "Ranged: TP Gain Up"), DS(8, "Firing Range Up XIII"), DS(10, "Ether Attack Plus XIII"), DS(15, "Insectoid Slayer XIII"), DS(15, "Piscinoid Slayer XIII"), DS(15, "Ranged Attack Up XIII"), DS(100, "Soft Touch XIII")],
[DS(3, "Vantage Attack Plus XV"), DS(5, "Theroid Slayer XV"), DS(5, "Potential Up XV"), DS(8, "Mechanoid Slayer XV"), DS(10, "Humanoid Slayer XV"), DS(10, "Arts: Gain TP XV"), DS(10, "Night Vision XV"), DS(100, "Ranged Accuracy Up XV")],
[DS(3, "Magazine Capacity Up XV"), DS(5, "Ranged: TP Gain Up"), DS(5, "Firing Range Up XV"), DS(8, "Ether Attack Plus XV"), DS(10, "Insectoid Slayer XV"), DS(10, "Piscinoid Slayer XV"), DS(10, "Ranged Attack Up XV"), DS(100, "Soft Touch XV")],
[DS(5, "Melee: Electric Res Down III"), DS(10, "Nullify Electric Reflect III"), DS(10, "Melee: Recover HP III"), DS(20, "Melee Accuracy Boost III"), DS(30, "Humanoid Criticals Up III"), DS(30, "Theroid Criticals Up III"), DS(30, "Insectoid Criticals Up III"), DS(100, "Melee Accuracy Up III")],
[DS(5, "Crush: Gain TP III"), DS(10, "Melee: Shock III"), DS(10, "Critical Chance Up III"), DS(20, "Melee: Fatigue III"), DS(30, "Melee: Blackout III"), DS(30, "Night Vision III"), DS(30, "Potential Boost III"), DS(100, "Potential Up III")],
[DS(10, "Melee: Electric Res Down III"), DS(15, "Nullify Electric Reflect III"), DS(15, "Melee: Recover HP III"), DS(25, "Melee Accuracy Boost III"), DS(35, "Humanoid Criticals Up III"), DS(35, "Theroid Criticals Up III"), DS(35, "Insectoid Criticals Up III"), DS(100, "Destabilizer III")],
[DS(10, "Crush: Gain TP III"), DS(15, "Melee: Shock III"), DS(15, "Critical Chance Up III"), DS(25, "Melee: Fatigue III"), DS(35, "Melee: Blackout III"), DS(35, "Night Vision III"), DS(35, "Potential Boost III"), DS(100, "Potential Up III")],
[DS(5, "Melee: Electric Res Down V"), DS(10, "Nullify Electric Reflect V"), DS(10, "Melee: Recover HP V"), DS(20, "Melee Accuracy Boost V"), DS(30, "Humanoid Criticals Up V"), DS(30, "Theroid Criticals Up V"), DS(30, "Insectoid Criticals Up V"), DS(100, "Melee Accuracy Up V")],
[DS(5, "Crush: Gain TP V"), DS(10, "Melee: Shock V"), DS(10, "Critical Chance Up V"), DS(20, "Melee: Fatigue V"), DS(30, "Melee: Blackout V"), DS(30, "Night Vision V"), DS(30, "Potential Boost V"), DS(100, "Potential Up V")],
[DS(10, "Melee: Electric Res Down V"), DS(15, "Nullify Electric Reflect V"), DS(15, "Melee: Recover HP V"), DS(25, "Melee Accuracy Boost V"), DS(35, "Humanoid Criticals Up V"), DS(35, "Theroid Criticals Up V"), DS(35, "Insectoid Criticals Up V"), DS(100, "Destabilizer V")],
[DS(10, "Crush: Gain TP V"), DS(15, "Melee: Shock V"), DS(15, "Critical Chance Up V"), DS(25, "Melee: Fatigue V"), DS(35, "Melee: Blackout V"), DS(35, "Night Vision V"), DS(35, "Potential Boost V"), DS(100, "Potential Up V")],
[DS(5, "Back Attack Plus III"), DS(10, "Thermal Resistance Up III"), DS(10, "Beam Resistance Up III"), DS(20, "Resist Knockback III"), DS(30, "Humanoid Criticals Up III"), DS(30, "Theroid Criticals Up III"), DS(30, "Insectoid Criticals Up III"), DS(100, "Melee Accuracy Up III")],
[DS(5, "Gravity Resistance Up III"), DS(10, "Ether Resistance Up III"), DS(10, "Resist Stagger III"), DS(20, "Melee: Fatigue III"), DS(30, "Melee: Blackout III"), DS(30, "Night Vision III"), DS(30, "Potential Boost III"), DS(100, "Potential Up III")],
[DS(10, "Back Attack Plus III"), DS(15, "Thermal Resistance Up III"), DS(15, "Beam Resistance Up III"), DS(25, "Resist Knockback III"), DS(35, "Humanoid Criticals Up III"), DS(35, "Theroid Criticals Up III"), DS(35, "Insectoid Criticals Up III"), DS(100, "Destabilizer III")],
[DS(10, "Gravity Resistance Up III"), DS(15, "Ether Resistance Up III"), DS(15, "Resist Stagger III"), DS(25, "Melee: Fatigue III"), DS(35, "Melee: Blackout III"), DS(35, "Night Vision III"), DS(35, "Potential Boost III"), DS(100, "Potential Up III")],
[DS(5, "Back Attack Plus V"), DS(10, "Thermal Resistance Up V"), DS(10, "Beam Resistance Up V"), DS(20, "Resist Knockback V"), DS(30, "Humanoid Criticals Up V"), DS(30, "Theroid Criticals Up V"), DS(30, "Insectoid Criticals Up V"), DS(100, "Melee Accuracy Up V")],
[DS(5, "Gravity Resistance Up V"), DS(10, "Ether Resistance Up V"), DS(10, "Resist Stagger V"), DS(20, "Melee: Fatigue V"), DS(30, "Melee: Blackout V"), DS(30, "Night Vision V"), DS(30, "Potential Boost V"), DS(100, "Potential Up V")],
[DS(10, "Back Attack Plus V"), DS(15, "Thermal Resistance Up V"), DS(15, "Beam Resistance Up V"), DS(25, "Resist Knockback V"), DS(35, "Humanoid Criticals Up V"), DS(35, "Theroid Criticals Up V"), DS(35, "Insectoid Criticals Up V"), DS(100, "Destabilizer V")],
[DS(10, "Gravity Resistance Up V"), DS(15, "Ether Resistance Up V"), DS(15, "Resist Stagger V"), DS(25, "Melee: Fatigue V"), DS(35, "Melee: Blackout V"), DS(35, "Night Vision V"), DS(35, "Potential Boost V"), DS(100, "Potential Up V")],
[DS(5, "Overdrive Count Up III"), DS(10, "Vantage Attack Plus III"), DS(10, "Firing Range Up III"), DS(20, "Ranged Accuracy Boost III"), DS(30, "Theroid Slayer III"), DS(30, "Insectoid Slayer III"), DS(30, "Humanoid Slayer III"), DS(100, "Ranged Accuracy Up III")],
[DS(5, "Ranged Appendage Damage III"), DS(10, "Magazine Capacity Up III"), DS(10, "Electric Attack Plus III"), DS(20, "Ranged Attack Up III"), DS(30, "Critical Chance Up III"), DS(30, "Night Vision III"), DS(30, "Potential Boost III"), DS(100, "Potential Up III")],
[DS(10, "Overdrive Count Up III"), DS(15, "Vantage Attack Plus III"), DS(15, "Firing Range Up III"), DS(25, "Ranged Accuracy Boost III"), DS(35, "Theroid Slayer III"), DS(35, "Insectoid Slayer III"), DS(35, "Humanoid Slayer III"), DS(100, "Destabilizer III")],
[DS(10, "Ranged Appendage Damage III"), DS(15, "Magazine Capacity Up III"), DS(15, "Electric Attack Plus III"), DS(25, "Ranged Attack Up III"), DS(35, "Critical Chance Up III"), DS(35, "Night Vision III"), DS(35, "Potential Boost III"), DS(100, "Potential Up III")],
[DS(5, "Overdrive Count Up V"), DS(10, "Vantage Attack Plus V"), DS(10, "Firing Range Up V"), DS(20, "Ranged Accuracy Boost V"), DS(30, "Theroid Slayer V"), DS(30, "Insectoid Slayer V"), DS(30, "Humanoid Slayer V"), DS(100, "Ranged Accuracy Up V")],
[DS(5, "Ranged Appendage Damage V"), DS(10, "Magazine Capacity Up V"), DS(10, "Electric Attack Plus V"), DS(20, "Ranged Attack Up V"), DS(30, "Critical Chance Up V"), DS(30, "Night Vision V"), DS(30, "Potential Boost V"), DS(100, "Potential Up V")],
[DS(10, "Overdrive Count Up V"), DS(15, "Vantage Attack Plus V"), DS(15, "Firing Range Up V"), DS(25, "Ranged Accuracy Boost V"), DS(35, "Theroid Slayer V"), DS(35, "Insectoid Slayer V"), DS(35, "Humanoid Slayer V"), DS(100, "Destabilizer V")],
[DS(10, "Ranged Appendage Damage V"), DS(15, "Magazine Capacity Up V"), DS(15, "Electric Attack Plus V"), DS(25, "Ranged Attack Up V"), DS(35, "Critical Chance Up V"), DS(35, "Night Vision V"), DS(35, "Potential Boost V"), DS(100, "Potential Up V")],
[DS(5, "Melee: Electric Res Down VII"), DS(10, "Nullify Electric Reflect VII"), DS(10, "Melee: Recover HP VII"), DS(20, "Melee Accuracy Boost VII"), DS(30, "Humanoid Criticals Up VII"), DS(30, "Theroid Criticals Up VII"), DS(30, "Insectoid Criticals Up VII"), DS(100, "Melee Accuracy Up VII")],
[DS(5, "Crush: Gain TP VII"), DS(10, "Melee: Shock VII"), DS(10, "Critical Chance Up VII"), DS(20, "Melee: Fatigue VII"), DS(30, "Melee: Blackout VII"), DS(30, "Night Vision VII"), DS(30, "Potential Boost VII"), DS(100, "Potential Up VII")],
[DS(10, "Melee: Electric Res Down VII"), DS(15, "Nullify Electric Reflect VII"), DS(15, "Melee: Recover HP VII"), DS(25, "Melee Accuracy Boost VII"), DS(35, "Humanoid Criticals Up VII"), DS(35, "Theroid Criticals Up VII"), DS(35, "Insectoid Criticals Up VII"), DS(100, "Destabilizer VII")],
[DS(10, "Crush: Gain TP VII"), DS(15, "Melee: Shock VII"), DS(15, "Critical Chance Up VII"), DS(25, "Melee: Fatigue VII"), DS(35, "Melee: Blackout VII"), DS(35, "Night Vision VII"), DS(35, "Potential Boost VII"), DS(100, "Potential Up VII")],
[DS(5, "Melee: Electric Res Down IX"), DS(10, "Nullify Electric Reflect IX"), DS(10, "Melee: Recover HP IX"), DS(20, "Melee Accuracy Boost IX"), DS(30, "Humanoid Criticals Up IX"), DS(30, "Theroid Criticals Up IX"), DS(30, "Insectoid Criticals Up IX"), DS(100, "Melee Accuracy Up IX")],
[DS(5, "Crush: Gain TP IX"), DS(10, "Melee: Shock IX"), DS(10, "Critical Chance Up IX"), DS(20, "Melee: Fatigue IX"), DS(30, "Melee: Blackout IX"), DS(30, "Night Vision IX"), DS(30, "Potential Boost IX"), DS(100, "Potential Up IX")],
[DS(10, "Melee: Electric Res Down IX"), DS(15, "Nullify Electric Reflect IX"), DS(15, "Melee: Recover HP IX"), DS(25, "Melee Accuracy Boost IX"), DS(35, "Humanoid Criticals Up IX"), DS(35, "Theroid Criticals Up IX"), DS(35, "Insectoid Criticals Up IX"), DS(100, "Destabilizer IX")],
[DS(10, "Crush: Gain TP IX"), DS(15, "Melee: Shock IX"), DS(15, "Critical Chance Up IX"), DS(25, "Melee: Fatigue IX"), DS(35, "Melee: Blackout IX"), DS(35, "Night Vision IX"), DS(35, "Potential Boost IX"), DS(100, "Potential Up IX")],
[DS(5, "Back Attack Plus VII"), DS(10, "Thermal Resistance Up VII"), DS(10, "Beam Resistance Up VII"), DS(20, "Resist Knockback VII"), DS(30, "Humanoid Criticals Up VII"), DS(30, "Theroid Criticals Up VII"), DS(30, "Insectoid Criticals Up VII"), DS(100, "Melee Accuracy Up VII")],
[DS(5, "Gravity Resistance Up VII"), DS(10, "Ether Resistance Up VII"), DS(10, "Resist Stagger VII"), DS(20, "Melee: Fatigue VII"), DS(30, "Melee: Blackout VII"), DS(30, "Night Vision VII"), DS(30, "Potential Boost VII"), DS(100, "Potential Up VII")],
[DS(10, "Back Attack Plus VII"), DS(15, "Thermal Resistance Up VII"), DS(15, "Beam Resistance Up VII"), DS(25, "Resist Knockback VII"), DS(35, "Humanoid Criticals Up VII"), DS(35, "Theroid Criticals Up VII"), DS(35, "Insectoid Criticals Up VII"), DS(100, "Destabilizer VII")],
[DS(10, "Gravity Resistance Up VII"), DS(15, "Ether Resistance Up VII"), DS(15, "Resist Stagger VII"), DS(25, "Melee: Fatigue VII"), DS(35, "Melee: Blackout VII"), DS(35, "Night Vision VII"), DS(35, "Potential Boost VII"), DS(100, "Potential Up VII")],
[DS(5, "Back Attack Plus IX"), DS(10, "Thermal Resistance Up IX"), DS(10, "Beam Resistance Up IX"), DS(20, "Resist Knockback IX"), DS(30, "Humanoid Criticals Up IX"), DS(30, "Theroid Criticals Up IX"), DS(30, "Insectoid Criticals Up IX"), DS(100, "Melee Accuracy Up IX")],
[DS(5, "Gravity Resistance Up IX"), DS(10, "Ether Resistance Up IX"), DS(10, "Resist Stagger IX"), DS(20, "Melee: Fatigue IX"), DS(30, "Melee: Blackout IX"), DS(30, "Night Vision IX"), DS(30, "Potential Boost IX"), DS(100, "Potential Up IX")],
[DS(10, "Back Attack Plus IX"), DS(15, "Thermal Resistance Up IX"), DS(15, "Beam Resistance Up IX"), DS(25, "Resist Knockback IX"), DS(35, "Humanoid Criticals Up IX"), DS(35, "Theroid Criticals Up IX"), DS(35, "Insectoid Criticals Up IX"), DS(100, "Destabilizer IX")],
[DS(10, "Gravity Resistance Up IX"), DS(15, "Ether Resistance Up IX"), DS(15, "Resist Stagger IX"), DS(25, "Melee: Fatigue IX"), DS(35, "Melee: Blackout IX"), DS(35, "Night Vision IX"), DS(35, "Potential Boost IX"), DS(100, "Potential Up IX")],
[DS(5, "Overdrive Count Up VII"), DS(10, "Vantage Attack Plus VII"), DS(10, "Firing Range Up VII"), DS(20, "Ranged Accuracy Boost VII"), DS(30, "Theroid Slayer VII"), DS(30, "Insectoid Slayer VII"), DS(30, "Humanoid Slayer VII"), DS(100, "Ranged Accuracy Up VII")],
[DS(5, "Ranged Appendage Damage VII"), DS(10, "Magazine Capacity Up VII"), DS(10, "Electric Attack Plus VII"), DS(20, "Ranged Attack Up VII"), DS(30, "Critical Chance Up VII"), DS(30, "Night Vision VII"), DS(30, "Potential Boost VII"), DS(100, "Potential Up VII")],
[DS(10, "Overdrive Count Up VII"), DS(15, "Vantage Attack Plus VII"), DS(15, "Firing Range Up VII"), DS(25, "Ranged Accuracy Boost VII"), DS(35, "Theroid Slayer VII"), DS(35, "Insectoid Slayer VII"), DS(35, "Humanoid Slayer VII"), DS(100, "Destabilizer VII")],
[DS(10, "Ranged Appendage Damage VII"), DS(15, "Magazine Capacity Up VII"), DS(15, "Electric Attack Plus VII"), DS(25, "Ranged Attack Up VII"), DS(35, "Critical Chance Up VII"), DS(35, "Night Vision VII"), DS(35, "Potential Boost VII"), DS(100, "Potential Up VII")],
[DS(5, "Overdrive Count Up IX"), DS(10, "Vantage Attack Plus IX"), DS(10, "Firing Range Up IX"), DS(20, "Ranged Accuracy Boost IX"), DS(30, "Theroid Slayer IX"), DS(30, "Insectoid Slayer IX"), DS(30, "Humanoid Slayer IX"), DS(100, "Ranged Accuracy Up IX")],
[DS(5, "Ranged Appendage Damage IX"), DS(10, "Magazine Capacity Up IX"), DS(10, "Electric Attack Plus IX"), DS(20, "Ranged Attack Up IX"), DS(30, "Critical Chance Up IX"), DS(30, "Night Vision IX"), DS(30, "Potential Boost IX"), DS(100, "Potential Up IX")],
[DS(10, "Overdrive Count Up IX"), DS(15, "Vantage Attack Plus IX"), DS(15, "Firing Range Up IX"), DS(25, "Ranged Accuracy Boost IX"), DS(35, "Theroid Slayer IX"), DS(35, "Insectoid Slayer IX"), DS(35, "Humanoid Slayer IX"), DS(100, "Destabilizer IX")],
[DS(10, "Ranged Appendage Damage IX"), DS(15, "Magazine Capacity Up IX"), DS(15, "Electric Attack Plus IX"), DS(25, "Ranged Attack Up IX"), DS(35, "Critical Chance Up IX"), DS(35, "Night Vision IX"), DS(35, "Potential Boost IX"), DS(100, "Potential Up IX")],
[DS(5, "Melee: Electric Res Down XI"), DS(10, "Nullify Electric Reflect XI"), DS(10, "Melee: Recover HP XI"), DS(20, "Melee Accuracy Boost XI"), DS(30, "Humanoid Criticals Up XI"), DS(30, "Theroid Criticals Up XI"), DS(30, "Insectoid Criticals Up XI"), DS(100, "Melee Accuracy Up XI")],
[DS(5, "Crush: Gain TP XI"), DS(10, "Melee: Shock XI"), DS(10, "Critical Chance Up XI"), DS(20, "Melee: Fatigue XI"), DS(30, "Melee: Blackout XI"), DS(30, "Night Vision XI"), DS(30, "Potential Boost XI"), DS(100, "Potential Up XI")],
[DS(10, "Melee: Electric Res Down XI"), DS(15, "Nullify Electric Reflect XI"), DS(15, "Melee: Recover HP XI"), DS(25, "Melee Accuracy Boost XI"), DS(35, "Humanoid Criticals Up XI"), DS(35, "Theroid Criticals Up XI"), DS(35, "Insectoid Criticals Up XI"), DS(100, "Destabilizer XI")],
[DS(10, "Crush: Gain TP XI"), DS(15, "Melee: Shock XI"), DS(15, "Critical Chance Up XI"), DS(25, "Melee: Fatigue XI"), DS(35, "Melee: Blackout XI"), DS(35, "Night Vision XI"), DS(35, "Potential Boost XI"), DS(100, "Potential Up XI")],
[DS(5, "Melee: Electric Res Down XIII"), DS(8, "Nullify Electric Reflect XIII"), DS(8, "Melee: Recover HP XIII"), DS(10, "Melee Accuracy Boost XIII"), DS(15, "Humanoid Criticals Up XIII"), DS(15, "Theroid Criticals Up XIII"), DS(15, "Insectoid Criticals Up XIII"), DS(100, "Melee Accuracy Up XIII")],
[DS(5, "Crush: Gain TP XIII"), DS(8, "Melee: Shock XIII"), DS(8, "Critical Chance Up XIII"), DS(10, "Melee: Fatigue XIII"), DS(15, "Melee: Blackout XIII"), DS(15, "Night Vision XIII"), DS(15, "Potential Boost XIII"), DS(100, "Potential Up XIII")],
[DS(3, "Melee: Electric Res Down XV"), DS(5, "Nullify Electric Reflect XV"), DS(5, "Melee: Recover HP XV"), DS(8, "Melee Accuracy Boost XV"), DS(10, "Humanoid Criticals Up XV"), DS(10, "Theroid Criticals Up XV"), DS(10, "Insectoid Criticals Up XV"), DS(100, "Melee Accuracy Up XV")],
[DS(3, "Crush: Gain TP XV"), DS(5, "Melee: Shock XV"), DS(5, "Critical Chance Up XV"), DS(8, "Melee: Fatigue XV"), DS(10, "Melee: Blackout XV"), DS(10, "Night Vision XV"), DS(10, "Potential Boost XV"), DS(100, "Potential Up XV")],
[DS(5, "Back Attack Plus XI"), DS(10, "Thermal Resistance Up XI"), DS(10, "Beam Resistance Up XI"), DS(20, "Resist Knockback XI"), DS(30, "Humanoid Criticals Up XI"), DS(30, "Theroid Criticals Up XI"), DS(30, "Insectoid Criticals Up XI"), DS(100, "Melee Accuracy Up XI")],
[DS(5, "Gravity Resistance Up XI"), DS(10, "Ether Resistance Up XI"), DS(10, "Resist Stagger XI"), DS(20, "Melee: Fatigue XI"), DS(30, "Melee: Blackout XI"), DS(30, "Night Vision XI"), DS(30, "Potential Boost XI"), DS(100, "Potential Up XI")],
[DS(10, "Back Attack Plus XI"), DS(15, "Thermal Resistance Up XI"), DS(15, "Beam Resistance Up XI"), DS(25, "Resist Knockback XI"), DS(35, "Humanoid Criticals Up XI"), DS(35, "Theroid Criticals Up XI"), DS(35, "Insectoid Criticals Up XI"), DS(100, "Destabilizer XI")],
[DS(10, "Gravity Resistance Up XI"), DS(15, "Ether Resistance Up XI"), DS(15, "Resist Stagger XI"), DS(25, "Melee: Fatigue XI"), DS(35, "Melee: Blackout XI"), DS(35, "Night Vision XI"), DS(35, "Potential Boost XI"), DS(100, "Potential Up XI")],
[DS(5, "Back Attack Plus XIII"), DS(8, "Thermal Resistance Up XIII"), DS(8, "Beam Resistance Up XIII"), DS(10, "Resist Knockback XIII"), DS(15, "Humanoid Criticals Up XIII"), DS(15, "Theroid Criticals Up XIII"), DS(15, "Insectoid Criticals Up XIII"), DS(100, "Melee Accuracy Up XIII")],
[DS(5, "Gravity Resistance Up XIII"), DS(8, "Ether Resistance Up XIII"), DS(8, "Resist Stagger XIII"), DS(10, "Melee: Fatigue XIII"), DS(15, "Melee: Blackout XIII"), DS(15, "Night Vision XIII"), DS(15, "Potential Boost XIII"), DS(100, "Potential Up XIII")],
[DS(3, "Back Attack Plus XV"), DS(5, "Thermal Resistance Up XV"), DS(5, "Beam Resistance Up XV"), DS(8, "Resist Knockback XV"), DS(10, "Humanoid Criticals Up XV"), DS(10, "Theroid Criticals Up XV"), DS(10, "Insectoid Criticals Up XV"), DS(100, "Melee Accuracy Up XV")],
[DS(3, "Gravity Resistance Up XV"), DS(5, "Ether Resistance Up XV"), DS(5, "Resist Stagger XV"), DS(8, "Melee: Fatigue XV"), DS(10, "Melee: Blackout XV"), DS(10, "Night Vision XV"), DS(10, "Potential Boost XV"), DS(100, "Potential Up XV")],
[DS(5, "Overdrive Count Up XI"), DS(10, "Vantage Attack Plus XI"), DS(10, "Firing Range Up XI"), DS(20, "Ranged Accuracy Boost XI"), DS(30, "Theroid Slayer XI"), DS(30, "Insectoid Slayer XI"), DS(30, "Humanoid Slayer XI"), DS(100, "Ranged Accuracy Up XI")],
[DS(5, "Ranged Appendage Damage XI"), DS(10, "Magazine Capacity Up XI"), DS(10, "Electric Attack Plus XI"), DS(20, "Ranged Attack Up XI"), DS(30, "Critical Chance Up XI"), DS(30, "Night Vision XI"), DS(30, "Potential Boost XI"), DS(100, "Potential Up XI")],
[DS(10, "Overdrive Count Up XI"), DS(15, "Vantage Attack Plus XI"), DS(15, "Firing Range Up XI"), DS(25, "Ranged Accuracy Boost XI"), DS(35, "Theroid Slayer XI"), DS(35, "Insectoid Slayer XI"), DS(35, "Humanoid Slayer XI"), DS(100, "Destabilizer XI")],
[DS(10, "Ranged Appendage Damage XI"), DS(15, "Magazine Capacity Up XI"), DS(15, "Electric Attack Plus XI"), DS(25, "Ranged Attack Up XI"), DS(35, "Critical Chance Up XI"), DS(35, "Night Vision XI"), DS(35, "Potential Boost XI"), DS(100, "Potential Up XI")],
[DS(5, "Overdrive Count Up XIII"), DS(8, "Vantage Attack Plus XIII"), DS(8, "Firing Range Up XIII"), DS(10, "Ranged Accuracy Boost XIII"), DS(15, "Theroid Slayer XIII"), DS(15, "Insectoid Slayer XIII"), DS(15, "Humanoid Slayer XIII"), DS(100, "Ranged Accuracy Up XIII")],
[DS(5, "Ranged Appendage Damage XIII"), DS(8, "Magazine Capacity Up XIII"), DS(8, "Electric Attack Plus XIII"), DS(10, "Ranged Attack Up XIII"), DS(15, "Critical Chance Up XIII"), DS(15, "Night Vision XIII"), DS(15, "Potential Boost XIII"), DS(100, "Potential Up XIII")],
[DS(3, "Overdrive Count Up XV"), DS(5, "Vantage Attack Plus XV"), DS(5, "Firing Range Up XV"), DS(8, "Ranged Accuracy Boost XV"), DS(10, "Theroid Slayer XV"), DS(10, "Insectoid Slayer XV"), DS(10, "Humanoid Slayer XV"), DS(100, "Ranged Accuracy Up XV")],
[DS(3, "Ranged Appendage Damage XV"), DS(5, "Magazine Capacity Up XV"), DS(5, "Electric Attack Plus XV"), DS(8, "Ranged Attack Up XV"), DS(10, "Critical Chance Up XV"), DS(10, "Night Vision XV"), DS(10, "Potential Boost XV"), DS(100, "Potential Up XV")],
[DS(5, "Crush: Gain TP III"), DS(10, "Side Attack Plus III"), DS(10, "Melee: Fatigue III"), DS(20, "Melee: TP Gain Up"), DS(30, "Mechanoid Criticals Up III"), DS(30, "Humanoid Criticals Up III"), DS(30, "Piscinoid Criticals Up III"), DS(100, "Melee Accuracy Up III")],
[DS(5, "Weapon Attack Power Up III"), DS(10, "Critical Chance Up III"), DS(10, "Melee: Blaze III"), DS(20, "Melee: Thermal Res Down III"), DS(30, "Arts: Recover HP III"), DS(30, "Melee: Recover HP III"), DS(30, "Melee Attack Boost III"), DS(100, "Melee Attack Up III")],
[DS(10, "Crush: Gain TP III"), DS(15, "Side Attack Plus III"), DS(15, "Melee: Fatigue III"), DS(25, "Melee: TP Gain Up"), DS(35, "Mechanoid Criticals Up III"), DS(35, "Humanoid Criticals Up III"), DS(35, "Piscinoid Criticals Up III"), DS(100, "Destabilizer III")],
[DS(10, "Weapon Attack Power Up III"), DS(15, "Critical Chance Up III"), DS(15, "Melee: Blaze III"), DS(25, "Melee: Thermal Res Down III"), DS(35, "Arts: Recover HP III"), DS(35, "Melee: Recover HP III"), DS(35, "Melee Attack Boost III"), DS(100, "Melee Attack Up III")],
[DS(5, "Crush: Gain TP V"), DS(10, "Side Attack Plus V"), DS(10, "Melee: Fatigue V"), DS(20, "Melee: TP Gain Up"), DS(30, "Mechanoid Criticals Up V"), DS(30, "Humanoid Criticals Up V"), DS(30, "Piscinoid Criticals Up V"), DS(100, "Melee Accuracy Up V")],
[DS(5, "Weapon Attack Power Up V"), DS(10, "Critical Chance Up V"), DS(10, "Melee: Blaze V"), DS(20, "Melee: Thermal Res Down V"), DS(30, "Arts: Recover HP V"), DS(30, "Melee: Recover HP V"), DS(30, "Melee Attack Boost V"), DS(100, "Melee Attack Up V")],
[DS(10, "Crush: Gain TP V"), DS(15, "Side Attack Plus V"), DS(15, "Melee: Fatigue V"), DS(25, "Melee: TP Gain Up"), DS(35, "Mechanoid Criticals Up V"), DS(35, "Humanoid Criticals Up V"), DS(35, "Piscinoid Criticals Up V"), DS(100, "Destabilizer V")],
[DS(10, "Weapon Attack Power Up V"), DS(15, "Critical Chance Up V"), DS(15, "Melee: Blaze V"), DS(25, "Melee: Thermal Res Down V"), DS(35, "Arts: Recover HP V"), DS(35, "Melee: Recover HP V"), DS(35, "Melee Attack Boost V"), DS(100, "Melee Attack Up V")],
[DS(5, "Crush: Gain TP III"), DS(10, "Ether Resistance Up III"), DS(10, "Melee: Fatigue III"), DS(20, "Resist Stagger III"), DS(30, "Humanoid Criticals Up III"), DS(30, "Mechanoid Criticals Up III"), DS(30, "Piscinoid Criticals Up III"), DS(100, "Melee Accuracy Up III")],
[DS(5, "Gravity Resistance Up III"), DS(10, "Electric Resistance Up III"), DS(10, "Physical Resistance Up III"), DS(20, "Resist Topple III"), DS(30, "Taunt: Barrier III"), DS(30, "Resist Launch III"), DS(30, "Melee Attack Boost III"), DS(100, "Melee Attack Up III")],
[DS(10, "Crush: Gain TP III"), DS(15, "Ether Resistance Up III"), DS(15, "Melee: Fatigue III"), DS(25, "Resist Stagger III"), DS(35, "Humanoid Criticals Up III"), DS(35, "Mechanoid Criticals Up III"), DS(35, "Piscinoid Criticals Up III"), DS(100, "Destabilizer III")],
[DS(10, "Gravity Resistance Up III"), DS(15, "Electric Resistance Up III"), DS(15, "Physical Resistance Up III"), DS(25, "Resist Topple III"), DS(35, "Taunt: Barrier III"), DS(35, "Resist Launch III"), DS(35, "Melee Attack Boost III"), DS(100, "Melee Attack Up III")],
[DS(5, "Crush: Gain TP V"), DS(10, "Ether Resistance Up V"), DS(10, "Melee: Fatigue V"), DS(20, "Resist Stagger V"), DS(30, "Humanoid Criticals Up V"), DS(30, "Mechanoid Criticals Up V"), DS(30, "Piscinoid Criticals Up V"), DS(100, "Melee Accuracy Up V")],
[DS(5, "Gravity Resistance Up V"), DS(10, "Electric Resistance Up V"), DS(10, "Physical Resistance Up V"), DS(20, "Resist Topple V"), DS(30, "Taunt: Barrier V"), DS(30, "Resist Launch V"), DS(30, "Melee Attack Boost V"), DS(100, "Melee Attack Up V")],
[DS(10, "Crush: Gain TP V"), DS(15, "Ether Resistance Up V"), DS(15, "Melee: Fatigue V"), DS(25, "Resist Stagger V"), DS(35, "Humanoid Criticals Up V"), DS(35, "Mechanoid Criticals Up V"), DS(35, "Piscinoid Criticals Up V"), DS(100, "Destabilizer V")],
[DS(10, "Gravity Resistance Up V"), DS(15, "Electric Resistance Up V"), DS(15, "Physical Resistance Up V"), DS(25, "Resist Topple V"), DS(35, "Taunt: Barrier V"), DS(35, "Resist Launch V"), DS(35, "Melee Attack Boost V"), DS(100, "Melee Attack Up V")],
[DS(5, "Opening Art: Damage Up III"), DS(10, "Critical Chance Up III"), DS(10, "Firing Range Up III"), DS(20, "Soft Touch III"), DS(30, "Mechanoid Slayer III"), DS(30, "Humanoid Slayer III"), DS(30, "Nullify Thermal Reflect III"), DS(100, "Ranged Accuracy Up III")],
[DS(5, "Secondary CD Reducer III"), DS(10, "Thermal Attack Plus III"), DS(10, "Ultrafauna Slayer III"), DS(20, "Arts: Gain TP III"), DS(30, "Overdrive Count Up III"), DS(30, "Piscinoid Slayer III"), DS(30, "Ranged Attack Boost III"), DS(100, "Ranged Attack Up III")],
[DS(10, "Opening Art: Damage Up III"), DS(15, "Critical Chance Up III"), DS(15, "Firing Range Up III"), DS(25, "Soft Touch III"), DS(35, "Mechanoid Slayer III"), DS(35, "Humanoid Slayer III"), DS(35, "Nullify Thermal Reflect III"), DS(100, "Destabilizer III")],
[DS(10, "Secondary CD Reducer III"), DS(15, "Thermal Attack Plus III"), DS(15, "Ultrafauna Slayer III"), DS(25, "Arts: Gain TP III"), DS(35, "Overdrive Count Up III"), DS(35, "Piscinoid Slayer III"), DS(35, "Ranged Attack Boost III"), DS(100, "Ranged Attack Up III")],
[DS(5, "Opening Art: Damage Up V"), DS(10, "Critical Chance Up V"), DS(10, "Firing Range Up V"), DS(20, "Soft Touch V"), DS(30, "Mechanoid Slayer V"), DS(30, "Humanoid Slayer V"), DS(30, "Nullify Thermal Reflect V"), DS(100, "Ranged Accuracy Up V")],
[DS(5, "Secondary CD Reducer V"), DS(10, "Thermal Attack Plus V"), DS(10, "Ultrafauna Slayer V"), DS(20, "Arts: Gain TP V"), DS(30, "Overdrive Count Up V"), DS(30, "Piscinoid Slayer V"), DS(30, "Ranged Attack Boost V"), DS(100, "Ranged Attack Up V")],
[DS(10, "Opening Art: Damage Up V"), DS(15, "Critical Chance Up V"), DS(15, "Firing Range Up V"), DS(25, "Soft Touch V"), DS(35, "Mechanoid Slayer V"), DS(35, "Humanoid Slayer V"), DS(35, "Nullify Thermal Reflect V"), DS(100, "Destabilizer V")],
[DS(10, "Secondary CD Reducer V"), DS(15, "Thermal Attack Plus V"), DS(15, "Ultrafauna Slayer V"), DS(25, "Arts: Gain TP V"), DS(35, "Overdrive Count Up V"), DS(35, "Piscinoid Slayer V"), DS(35, "Ranged Attack Boost V"), DS(100, "Ranged Attack Up V")],
[DS(5, "Crush: Gain TP VII"), DS(10, "Side Attack Plus VII"), DS(10, "Melee: Fatigue VII"), DS(20, "Melee: TP Gain Up"), DS(30, "Mechanoid Criticals Up VII"), DS(30, "Humanoid Criticals Up VII"), DS(30, "Piscinoid Criticals Up VII"), DS(100, "Melee Accuracy Up VII")],
[DS(5, "Weapon Attack Power Up VII"), DS(10, "Critical Chance Up VII"), DS(10, "Melee: Blaze VII"), DS(20, "Melee: Thermal Res Down VII"), DS(30, "Arts: Recover HP VII"), DS(30, "Melee: Recover HP VII"), DS(30, "Melee Attack Boost VII"), DS(100, "Melee Attack Up VII")],
[DS(10, "Crush: Gain TP VII"), DS(15, "Side Attack Plus VII"), DS(15, "Melee: Fatigue VII"), DS(25, "Melee: TP Gain Up"), DS(35, "Mechanoid Criticals Up VII"), DS(35, "Humanoid Criticals Up VII"), DS(35, "Piscinoid Criticals Up VII"), DS(100, "Destabilizer VII")],
[DS(10, "Weapon Attack Power Up VII"), DS(15, "Critical Chance Up VII"), DS(15, "Melee: Blaze VII"), DS(25, "Melee: Thermal Res Down VII"), DS(35, "Arts: Recover HP VII"), DS(35, "Melee: Recover HP VII"), DS(35, "Melee Attack Boost VII"), DS(100, "Melee Attack Up VII")],
[DS(5, "Crush: Gain TP IX"), DS(10, "Side Attack Plus IX"), DS(10, "Melee: Fatigue IX"), DS(20, "Melee: TP Gain Up"), DS(30, "Mechanoid Criticals Up IX"), DS(30, "Humanoid Criticals Up IX"), DS(30, "Piscinoid Criticals Up IX"), DS(100, "Melee Accuracy Up IX")],
[DS(5, "Weapon Attack Power Up IX"), DS(10, "Critical Chance Up IX"), DS(10, "Melee: Blaze IX"), DS(20, "Melee: Thermal Res Down IX"), DS(30, "Arts: Recover HP IX"), DS(30, "Melee: Recover HP IX"), DS(30, "Melee Attack Boost IX"), DS(100, "Melee Attack Up IX")],
[DS(10, "Crush: Gain TP IX"), DS(15, "Side Attack Plus IX"), DS(15, "Melee: Fatigue IX"), DS(25, "Melee: TP Gain Up"), DS(35, "Mechanoid Criticals Up IX"), DS(35, "Humanoid Criticals Up IX"), DS(35, "Piscinoid Criticals Up IX"), DS(100, "Destabilizer IX")],
[DS(10, "Weapon Attack Power Up IX"), DS(15, "Critical Chance Up IX"), DS(15, "Melee: Blaze IX"), DS(25, "Melee: Thermal Res Down IX"), DS(35, "Arts: Recover HP IX"), DS(35, "Melee: Recover HP IX"), DS(35, "Melee Attack Boost IX"), DS(100, "Melee Attack Up IX")],
[DS(5, "Crush: Gain TP VII"), DS(10, "Ether Resistance Up VII"), DS(10, "Melee: Fatigue VII"), DS(20, "Resist Stagger VII"), DS(30, "Humanoid Criticals Up VII"), DS(30, "Mechanoid Criticals Up VII"), DS(30, "Piscinoid Criticals Up VII"), DS(100, "Melee Accuracy Up VII")],
[DS(5, "Gravity Resistance Up VII"), DS(10, "Electric Resistance Up VII"), DS(10, "Physical Resistance Up VII"), DS(20, "Resist Topple VII"), DS(30, "Taunt: Barrier VII"), DS(30, "Resist Launch VII"), DS(30, "Melee Attack Boost VII"), DS(100, "Melee Attack Up VII")],
[DS(10, "Crush: Gain TP VII"), DS(15, "Ether Resistance Up VII"), DS(15, "Melee: Fatigue VII"), DS(25, "Resist Stagger VII"), DS(35, "Humanoid Criticals Up VII"), DS(35, "Mechanoid Criticals Up VII"), DS(35, "Piscinoid Criticals Up VII"), DS(100, "Destabilizer VII")],
[DS(10, "Gravity Resistance Up VII"), DS(15, "Electric Resistance Up VII"), DS(15, "Physical Resistance Up VII"), DS(25, "Resist Topple VII"), DS(35, "Taunt: Barrier VII"), DS(35, "Resist Launch VII"), DS(35, "Melee Attack Boost VII"), DS(100, "Melee Attack Up VII")],
[DS(5, "Crush: Gain TP IX"), DS(10, "Ether Resistance Up IX"), DS(10, "Melee: Fatigue IX"), DS(20, "Resist Stagger IX"), DS(30, "Humanoid Criticals Up IX"), DS(30, "Mechanoid Criticals Up IX"), DS(30, "Piscinoid Criticals Up IX"), DS(100, "Melee Accuracy Up IX")],
[DS(5, "Gravity Resistance Up IX"), DS(10, "Electric Resistance Up IX"), DS(10, "Physical Resistance Up IX"), DS(20, "Resist Topple IX"), DS(30, "Taunt: Barrier IX"), DS(30, "Resist Launch IX"), DS(30, "Melee Attack Boost IX"), DS(100, "Melee Attack Up IX")],
[DS(10, "Crush: Gain TP IX"), DS(15, "Ether Resistance Up IX"), DS(15, "Melee: Fatigue IX"), DS(25, "Resist Stagger IX"), DS(35, "Humanoid Criticals Up IX"), DS(35, "Mechanoid Criticals Up IX"), DS(35, "Piscinoid Criticals Up IX"), DS(100, "Destabilizer IX")],
[DS(10, "Gravity Resistance Up IX"), DS(15, "Electric Resistance Up IX"), DS(15, "Physical Resistance Up IX"), DS(25, "Resist Topple IX"), DS(35, "Taunt: Barrier IX"), DS(35, "Resist Launch IX"), DS(35, "Melee Attack Boost IX"), DS(100, "Melee Attack Up IX")],
[DS(5, "Opening Art: Damage Up VII"), DS(10, "Critical Chance Up VII"), DS(10, "Firing Range Up VII"), DS(20, "Soft Touch VII"), DS(30, "Mechanoid Slayer VII"), DS(30, "Humanoid Slayer VII"), DS(30, "Nullify Thermal Reflect VII"), DS(100, "Ranged Accuracy Up VII")],
[DS(5, "Secondary CD Reducer VII"), DS(10, "Thermal Attack Plus VII"), DS(10, "Ultrafauna Slayer VII"), DS(20, "Arts: Gain TP VII"), DS(30, "Overdrive Count Up VII"), DS(30, "Piscinoid Slayer VII"), DS(30, "Ranged Attack Boost VII"), DS(100, "Ranged Attack Up VII")],
[DS(10, "Opening Art: Damage Up VII"), DS(15, "Critical Chance Up VII"), DS(15, "Firing Range Up VII"), DS(25, "Soft Touch VII"), DS(35, "Mechanoid Slayer VII"), DS(35, "Humanoid Slayer VII"), DS(35, "Nullify Thermal Reflect VII"), DS(100, "Destabilizer VII")],
[DS(10, "Secondary CD Reducer VII"), DS(15, "Thermal Attack Plus VII"), DS(15, "Ultrafauna Slayer VII"), DS(25, "Arts: Gain TP VII"), DS(35, "Overdrive Count Up VII"), DS(35, "Piscinoid Slayer VII"), DS(35, "Ranged Attack Boost VII"), DS(100, "Ranged Attack Up VII")],
[DS(5, "Opening Art: Damage Up IX"), DS(10, "Critical Chance Up IX"), DS(10, "Firing Range Up IX"), DS(20, "Soft Touch IX"), DS(30, "Mechanoid Slayer IX"), DS(30, "Humanoid Slayer IX"), DS(30, "Nullify Thermal Reflect IX"), DS(100, "Ranged Accuracy Up IX")],
[DS(5, "Secondary CD Reducer IX"), DS(10, "Thermal Attack Plus IX"), DS(10, "Ultrafauna Slayer IX"), DS(20, "Arts: Gain TP IX"), DS(30, "Overdrive Count Up IX"), DS(30, "Piscinoid Slayer IX"), DS(30, "Ranged Attack Boost IX"), DS(100, "Ranged Attack Up IX")],
[DS(10, "Opening Art: Damage Up IX"), DS(15, "Critical Chance Up IX"), DS(15, "Firing Range Up IX"), DS(25, "Soft Touch IX"), DS(35, "Mechanoid Slayer IX"), DS(35, "Humanoid Slayer IX"), DS(35, "Nullify Thermal Reflect IX"), DS(100, "Destabilizer IX")],
[DS(10, "Secondary CD Reducer IX"), DS(15, "Thermal Attack Plus IX"), DS(15, "Ultrafauna Slayer IX"), DS(25, "Arts: Gain TP IX"), DS(35, "Overdrive Count Up IX"), DS(35, "Piscinoid Slayer IX"), DS(35, "Ranged Attack Boost IX"), DS(100, "Ranged Attack Up IX")],
[DS(5, "Crush: Gain TP XI"), DS(10, "Side Attack Plus XI"), DS(10, "Melee: Fatigue XI"), DS(20, "Melee: TP Gain Up"), DS(30, "Mechanoid Criticals Up XI"), DS(30, "Humanoid Criticals Up XI"), DS(30, "Piscinoid Criticals Up XI"), DS(100, "Melee Accuracy Up XI")],
[DS(5, "Weapon Attack Power Up XI"), DS(10, "Critical Chance Up XI"), DS(10, "Melee: Blaze XI"), DS(20, "Melee: Thermal Res Down XI"), DS(30, "Arts: Recover HP XI"), DS(30, "Melee: Recover HP XI"), DS(30, "Melee Attack Boost XI"), DS(100, "Melee Attack Up XI")],
[DS(10, "Crush: Gain TP XI"), DS(15, "Side Attack Plus XI"), DS(15, "Melee: Fatigue XI"), DS(25, "Melee: TP Gain Up"), DS(35, "Mechanoid Criticals Up XI"), DS(35, "Humanoid Criticals Up XI"), DS(35, "Piscinoid Criticals Up XI"), DS(100, "Destabilizer XI")],
[DS(10, "Weapon Attack Power Up XI"), DS(15, "Critical Chance Up XI"), DS(15, "Melee: Blaze XI"), DS(25, "Melee: Thermal Res Down XI"), DS(35, "Arts: Recover HP XI"), DS(35, "Melee: Recover HP XI"), DS(35, "Melee Attack Boost XI"), DS(100, "Melee Attack Up XI")],
[DS(5, "Crush: Gain TP XIII"), DS(8, "Side Attack Plus XIII"), DS(8, "Melee: Fatigue XIII"), DS(10, "Melee: TP Gain Up"), DS(15, "Mechanoid Criticals Up XIII"), DS(15, "Humanoid Criticals Up XIII"), DS(15, "Piscinoid Criticals Up XIII"), DS(100, "Melee Accuracy Up XIII")],
[DS(5, "Weapon Attack Power Up XIII"), DS(8, "Critical Chance Up XIII"), DS(8, "Melee: Blaze XIII"), DS(10, "Melee: Thermal Res Down XIII"), DS(15, "Arts: Recover HP XIII"), DS(15, "Melee: Recover HP XIII"), DS(15, "Melee Attack Boost XIII"), DS(100, "Melee Attack Up XIII")],
[DS(3, "Crush: Gain TP XV"), DS(5, "Side Attack Plus XV"), DS(5, "Melee: Fatigue XV"), DS(8, "Melee: TP Gain Up"), DS(10, "Mechanoid Criticals Up XV"), DS(10, "Humanoid Criticals Up XV"), DS(10, "Piscinoid Criticals Up XV"), DS(100, "Melee Accuracy Up XV")],
[DS(3, "Weapon Attack Power Up XV"), DS(5, "Critical Chance Up XV"), DS(5, "Melee: Blaze XV"), DS(8, "Melee: Thermal Res Down XV"), DS(10, "Arts: Recover HP XV"), DS(10, "Melee: Recover HP XV"), DS(10, "Melee Attack Boost XV"), DS(100, "Melee Attack Up XV")],
[DS(5, "Crush: Gain TP XI"), DS(10, "Ether Resistance Up XI"), DS(10, "Melee: Fatigue XI"), DS(20, "Resist Stagger XI"), DS(30, "Humanoid Criticals Up XI"), DS(30, "Mechanoid Criticals Up XI"), DS(30, "Piscinoid Criticals Up XI"), DS(100, "Melee Accuracy Up XI")],
[DS(5, "Gravity Resistance Up XI"), DS(10, "Electric Resistance Up XI"), DS(10, "Physical Resistance Up XI"), DS(20, "Resist Topple XI"), DS(30, "Taunt: Barrier XI"), DS(30, "Resist Launch XI"), DS(30, "Melee Attack Boost XI"), DS(100, "Melee Attack Up XI")],
[DS(10, "Crush: Gain TP XI"), DS(15, "Ether Resistance Up XI"), DS(15, "Melee: Fatigue XI"), DS(25, "Resist Stagger XI"), DS(35, "Humanoid Criticals Up XI"), DS(35, "Mechanoid Criticals Up XI"), DS(35, "Piscinoid Criticals Up XI"), DS(100, "Destabilizer XI")],
[DS(10, "Gravity Resistance Up XI"), DS(15, "Electric Resistance Up XI"), DS(15, "Physical Resistance Up XI"), DS(25, "Resist Topple XI"), DS(35, "Taunt: Barrier XI"), DS(35, "Resist Launch XI"), DS(35, "Melee Attack Boost XI"), DS(100, "Melee Attack Up XI")],
[DS(5, "Crush: Gain TP XIII"), DS(8, "Ether Resistance Up XIII"), DS(8, "Melee: Fatigue XIII"), DS(10, "Resist Stagger XIII"), DS(15, "Humanoid Criticals Up XIII"), DS(15, "Mechanoid Criticals Up XIII"), DS(15, "Piscinoid Criticals Up XIII"), DS(100, "Melee Accuracy Up XIII")],
[DS(5, "Gravity Resistance Up XIII"), DS(8, "Electric Resistance Up XIII"), DS(8, "Physical Resistance Up XIII"), DS(10, "Resist Topple XIII"), DS(15, "Taunt: Barrier XIII"), DS(15, "Resist Launch XIII"), DS(15, "Melee Attack Boost XIII"), DS(100, "Melee Attack Up XIII")],
[DS(3, "Crush: Gain TP XV"), DS(5, "Ether Resistance Up XV"), DS(5, "Melee: Fatigue XV"), DS(8, "Resist Stagger XV"), DS(10, "Humanoid Criticals Up XV"), DS(10, "Mechanoid Criticals Up XV"), DS(10, "Piscinoid Criticals Up XV"), DS(100, "Melee Accuracy Up XV")],
[DS(3, "Gravity Resistance Up XV"), DS(5, "Electric Resistance Up XV"), DS(5, "Physical Resistance Up XV"), DS(8, "Resist Topple XV"), DS(10, "Taunt: Barrier XV"), DS(10, "Resist Launch XV"), DS(10, "Melee Attack Boost XV"), DS(100, "Melee Attack Up XV")],
[DS(5, "Opening Art: Damage Up XI"), DS(10, "Critical Chance Up XI"), DS(10, "Firing Range Up XI"), DS(20, "Soft Touch XI"), DS(30, "Mechanoid Slayer XI"), DS(30, "Humanoid Slayer XI"), DS(30, "Nullify Thermal Reflect XI"), DS(100, "Ranged Accuracy Up XI")],
[DS(5, "Secondary CD Reducer XI"), DS(10, "Thermal Attack Plus XI"), DS(10, "Ultrafauna Slayer XI"), DS(20, "Arts: Gain TP XI"), DS(30, "Overdrive Count Up XI"), DS(30, "Piscinoid Slayer XI"), DS(30, "Ranged Attack Boost XI"), DS(100, "Ranged Attack Up XI")],
[DS(10, "Opening Art: Damage Up XI"), DS(15, "Critical Chance Up XI"), DS(15, "Firing Range Up XI"), DS(25, "Soft Touch XI"), DS(35, "Mechanoid Slayer XI"), DS(35, "Humanoid Slayer XI"), DS(35, "Nullify Thermal Reflect XI"), DS(100, "Destabilizer XI")],
[DS(10, "Secondary CD Reducer XI"), DS(15, "Thermal Attack Plus XI"), DS(15, "Ultrafauna Slayer XI"), DS(25, "Arts: Gain TP XI"), DS(35, "Overdrive Count Up XI"), DS(35, "Piscinoid Slayer XI"), DS(35, "Ranged Attack Boost XI"), DS(100, "Ranged Attack Up XI")],
[DS(5, "Opening Art: Damage Up XIII"), DS(8, "Critical Chance Up XIII"), DS(8, "Firing Range Up XIII"), DS(10, "Soft Touch XIII"), DS(15, "Mechanoid Slayer XIII"), DS(15, "Humanoid Slayer XIII"), DS(15, "Nullify Thermal Reflect XIII"), DS(100, "Ranged Accuracy Up XIII")],
[DS(5, "Secondary CD Reducer XIII"), DS(8, "Thermal Attack Plus XIII"), DS(8, "Ultrafauna Slayer XIII"), DS(10, "Arts: Gain TP XIII"), DS(15, "Overdrive Count Up XIII"), DS(15, "Piscinoid Slayer XIII"), DS(15, "Ranged Attack Boost XIII"), DS(100, "Ranged Attack Up XIII")],
[DS(3, "Opening Art: Damage Up XV"), DS(5, "Critical Chance Up XV"), DS(5, "Firing Range Up XV"), DS(8, "Soft Touch XV"), DS(10, "Mechanoid Slayer XV"), DS(10, "Humanoid Slayer XV"), DS(10, "Nullify Thermal Reflect XV"), DS(100, "Ranged Accuracy Up XV")],
[DS(3, "Secondary CD Reducer XV"), DS(5, "Thermal Attack Plus XV"), DS(5, "Ultrafauna Slayer XV"), DS(8, "Arts: Gain TP XV"), DS(10, "Overdrive Count Up XV"), DS(10, "Piscinoid Slayer XV"), DS(10, "Ranged Attack Boost XV"), DS(100, "Ranged Attack Up XV")],
[DS(5, "Back Attack Plus III"), DS(10, "Side Attack Plus III"), DS(10, "Melee Attack Boost III"), DS(20, "Critical Chance Up III"), DS(30, "Insectoid Criticals Up III"), DS(30, "Piscinoid Criticals Up III"), DS(30, "Humanoid Criticals Up III"), DS(100, "Melee Accuracy Up III")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Melee: Gravity Res Down III"), DS(10, "Melee: Fatigue III"), DS(20, "Vantage Attack Plus III"), DS(30, "Melee Attack Up III"), DS(30, "Theroid Criticals Up III"), DS(30, "Nullify Gravity Reflect III"), DS(100, "Melee: Blackout III")],
[DS(10, "Back Attack Plus III"), DS(15, "Side Attack Plus III"), DS(15, "Melee Attack Boost III"), DS(25, "Critical Chance Up III"), DS(35, "Insectoid Criticals Up III"), DS(35, "Piscinoid Criticals Up III"), DS(35, "Humanoid Criticals Up III"), DS(100, "Destabilizer III")],
[DS(10, "Overdrive Blue Bonus"), DS(15, "Melee: Gravity Res Down III"), DS(15, "Melee: Fatigue III"), DS(25, "Vantage Attack Plus III"), DS(35, "Melee Attack Up III"), DS(35, "Theroid Criticals Up III"), DS(35, "Nullify Gravity Reflect III"), DS(100, "Melee: Blackout III")],
[DS(5, "Back Attack Plus V"), DS(10, "Side Attack Plus V"), DS(10, "Melee Attack Boost V"), DS(20, "Critical Chance Up V"), DS(30, "Insectoid Criticals Up V"), DS(30, "Piscinoid Criticals Up V"), DS(30, "Humanoid Criticals Up V"), DS(100, "Melee Accuracy Up V")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Melee: Gravity Res Down V"), DS(10, "Melee: Fatigue V"), DS(20, "Vantage Attack Plus V"), DS(30, "Melee Attack Up V"), DS(30, "Theroid Criticals Up V"), DS(30, "Nullify Gravity Reflect V"), DS(100, "Melee: Blackout V")],
[DS(10, "Back Attack Plus V"), DS(15, "Side Attack Plus V"), DS(15, "Melee Attack Boost V"), DS(25, "Critical Chance Up V"), DS(35, "Insectoid Criticals Up V"), DS(35, "Piscinoid Criticals Up V"), DS(35, "Humanoid Criticals Up V"), DS(100, "Destabilizer V")],
[DS(10, "Overdrive Blue Bonus"), DS(15, "Melee: Gravity Res Down V"), DS(15, "Melee: Fatigue V"), DS(25, "Vantage Attack Plus V"), DS(35, "Melee Attack Up V"), DS(35, "Theroid Criticals Up V"), DS(35, "Nullify Gravity Reflect V"), DS(100, "Melee: Blackout V")],
[DS(5, "Ether Resistance Up III"), DS(10, "Resist Topple III"), DS(10, "Melee Attack Boost III"), DS(20, "Critical Chance Up III"), DS(30, "Insectoid Criticals Up III"), DS(30, "Piscinoid Criticals Up III"), DS(30, "Humanoid Criticals Up III"), DS(100, "Melee Accuracy Up III")],
[DS(5, "Gravity Resistance Up III"), DS(10, "Melee: Gravity Res Down III"), DS(10, "Melee: Fatigue III"), DS(20, "Stun: Decoy III"), DS(30, "Melee Attack Up III"), DS(30, "Theroid Criticals Up III"), DS(30, "Resist Launch III"), DS(100, "Resist Flinch III")],
[DS(10, "Ether Resistance Up III"), DS(15, "Resist Topple III"), DS(15, "Melee Attack Boost III"), DS(25, "Critical Chance Up III"), DS(35, "Insectoid Criticals Up III"), DS(35, "Piscinoid Criticals Up III"), DS(35, "Humanoid Criticals Up III"), DS(100, "Destabilizer III")],
[DS(10, "Gravity Resistance Up III"), DS(15, "Melee: Gravity Res Down III"), DS(15, "Melee: Fatigue III"), DS(25, "Stun: Decoy III"), DS(35, "Melee Attack Up III"), DS(35, "Theroid Criticals Up III"), DS(35, "Resist Launch III"), DS(100, "Resist Flinch III")],
[DS(5, "Ether Resistance Up V"), DS(10, "Resist Topple V"), DS(10, "Melee Attack Boost V"), DS(20, "Critical Chance Up V"), DS(30, "Insectoid Criticals Up V"), DS(30, "Piscinoid Criticals Up V"), DS(30, "Humanoid Criticals Up V"), DS(100, "Melee Accuracy Up V")],
[DS(5, "Gravity Resistance Up V"), DS(10, "Melee: Gravity Res Down V"), DS(10, "Melee: Fatigue V"), DS(20, "Stun: Decoy V"), DS(30, "Melee Attack Up V"), DS(30, "Theroid Criticals Up V"), DS(30, "Resist Launch V"), DS(100, "Resist Flinch V")],
[DS(10, "Ether Resistance Up V"), DS(15, "Resist Topple V"), DS(15, "Melee Attack Boost V"), DS(25, "Critical Chance Up V"), DS(35, "Insectoid Criticals Up V"), DS(35, "Piscinoid Criticals Up V"), DS(35, "Humanoid Criticals Up V"), DS(100, "Destabilizer V")],
[DS(10, "Gravity Resistance Up V"), DS(15, "Melee: Gravity Res Down V"), DS(15, "Melee: Fatigue V"), DS(25, "Stun: Decoy V"), DS(35, "Melee Attack Up V"), DS(35, "Theroid Criticals Up V"), DS(35, "Resist Launch V"), DS(100, "Resist Flinch V")],
[DS(5, "Back Attack Plus III"), DS(10, "Side Attack Plus III"), DS(10, "Ranged Attack Boost III"), DS(20, "Critical Chance Up III"), DS(30, "Piscinoid Slayer III"), DS(30, "Insectoid Slayer III"), DS(30, "Theroid Slayer III"), DS(100, "Ranged Accuracy Up III")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Gravity Attack Plus III"), DS(10, "Magazine Capacity Up III"), DS(20, "Vantage Attack Plus III"), DS(30, "Ranged Attack Up III"), DS(30, "Humanoid Slayer III"), DS(30, "Nullify Gravity Reflect III"), DS(100, "Firing Range Up III")],
[DS(10, "Back Attack Plus III"), DS(15, "Side Attack Plus III"), DS(15, "Ranged Attack Boost III"), DS(25, "Critical Chance Up III"), DS(35, "Piscinoid Slayer III"), DS(35, "Insectoid Slayer III"), DS(35, "Theroid Slayer III"), DS(100, "Destabilizer III")],
[DS(10, "Overdrive Green Bonus"), DS(15, "Gravity Attack Plus III"), DS(15, "Magazine Capacity Up III"), DS(25, "Vantage Attack Plus III"), DS(35, "Ranged Attack Up III"), DS(35, "Humanoid Slayer III"), DS(35, "Nullify Gravity Reflect III"), DS(100, "Firing Range Up III")],
[DS(5, "Back Attack Plus V"), DS(10, "Side Attack Plus V"), DS(10, "Ranged Attack Boost V"), DS(20, "Critical Chance Up V"), DS(30, "Piscinoid Slayer V"), DS(30, "Insectoid Slayer V"), DS(30, "Theroid Slayer V"), DS(100, "Ranged Accuracy Up V")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Gravity Attack Plus V"), DS(10, "Magazine Capacity Up V"), DS(20, "Vantage Attack Plus V"), DS(30, "Ranged Attack Up V"), DS(30, "Humanoid Slayer V"), DS(30, "Nullify Gravity Reflect V"), DS(100, "Firing Range Up V")],
[DS(10, "Back Attack Plus V"), DS(15, "Side Attack Plus V"), DS(15, "Ranged Attack Boost V"), DS(25, "Critical Chance Up V"), DS(35, "Piscinoid Slayer V"), DS(35, "Insectoid Slayer V"), DS(35, "Theroid Slayer V"), DS(100, "Destabilizer V")],
[DS(10, "Overdrive Green Bonus"), DS(15, "Gravity Attack Plus V"), DS(15, "Magazine Capacity Up V"), DS(25, "Vantage Attack Plus V"), DS(35, "Ranged Attack Up V"), DS(35, "Humanoid Slayer V"), DS(35, "Nullify Gravity Reflect V"), DS(100, "Firing Range Up V")],
[DS(5, "Back Attack Plus VII"), DS(10, "Side Attack Plus VII"), DS(10, "Melee Attack Boost VII"), DS(20, "Critical Chance Up VII"), DS(30, "Insectoid Criticals Up VII"), DS(30, "Piscinoid Criticals Up VII"), DS(30, "Humanoid Criticals Up VII"), DS(100, "Melee Accuracy Up VII")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Melee: Gravity Res Down VII"), DS(10, "Melee: Fatigue VII"), DS(20, "Vantage Attack Plus VII"), DS(30, "Melee Attack Up VII"), DS(30, "Theroid Criticals Up VII"), DS(30, "Nullify Gravity Reflect VII"), DS(100, "Melee: Blackout VII")],
[DS(10, "Back Attack Plus VII"), DS(15, "Side Attack Plus VII"), DS(15, "Melee Attack Boost VII"), DS(25, "Critical Chance Up VII"), DS(35, "Insectoid Criticals Up VII"), DS(35, "Piscinoid Criticals Up VII"), DS(35, "Humanoid Criticals Up VII"), DS(100, "Destabilizer VII")],
[DS(10, "Overdrive Blue Bonus"), DS(15, "Melee: Gravity Res Down VII"), DS(15, "Melee: Fatigue VII"), DS(25, "Vantage Attack Plus VII"), DS(35, "Melee Attack Up VII"), DS(35, "Theroid Criticals Up VII"), DS(35, "Nullify Gravity Reflect VII"), DS(100, "Melee: Blackout VII")],
[DS(5, "Back Attack Plus IX"), DS(10, "Side Attack Plus IX"), DS(10, "Melee Attack Boost IX"), DS(20, "Critical Chance Up IX"), DS(30, "Insectoid Criticals Up IX"), DS(30, "Piscinoid Criticals Up IX"), DS(30, "Humanoid Criticals Up IX"), DS(100, "Melee Accuracy Up IX")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Melee: Gravity Res Down IX"), DS(10, "Melee: Fatigue IX"), DS(20, "Vantage Attack Plus IX"), DS(30, "Melee Attack Up IX"), DS(30, "Theroid Criticals Up IX"), DS(30, "Nullify Gravity Reflect IX"), DS(100, "Melee: Blackout IX")],
[DS(10, "Back Attack Plus IX"), DS(15, "Side Attack Plus IX"), DS(15, "Melee Attack Boost IX"), DS(25, "Critical Chance Up IX"), DS(35, "Insectoid Criticals Up IX"), DS(35, "Piscinoid Criticals Up IX"), DS(35, "Humanoid Criticals Up IX"), DS(100, "Destabilizer IX")],
[DS(10, "Overdrive Blue Bonus"), DS(15, "Melee: Gravity Res Down IX"), DS(15, "Melee: Fatigue IX"), DS(25, "Vantage Attack Plus IX"), DS(35, "Melee Attack Up IX"), DS(35, "Theroid Criticals Up IX"), DS(35, "Nullify Gravity Reflect IX"), DS(100, "Melee: Blackout IX")],
[DS(5, "Ether Resistance Up VII"), DS(10, "Resist Topple VII"), DS(10, "Melee Attack Boost VII"), DS(20, "Critical Chance Up VII"), DS(30, "Insectoid Criticals Up VII"), DS(30, "Piscinoid Criticals Up VII"), DS(30, "Humanoid Criticals Up VII"), DS(100, "Melee Accuracy Up VII")],
[DS(5, "Gravity Resistance Up VII"), DS(10, "Melee: Gravity Res Down VII"), DS(10, "Melee: Fatigue VII"), DS(20, "Stun: Decoy VII"), DS(30, "Melee Attack Up VII"), DS(30, "Theroid Criticals Up VII"), DS(30, "Resist Launch VII"), DS(100, "Resist Flinch VII")],
[DS(10, "Ether Resistance Up VII"), DS(15, "Resist Topple VII"), DS(15, "Melee Attack Boost VII"), DS(25, "Critical Chance Up VII"), DS(35, "Insectoid Criticals Up VII"), DS(35, "Piscinoid Criticals Up VII"), DS(35, "Humanoid Criticals Up VII"), DS(100, "Destabilizer VII")],
[DS(10, "Gravity Resistance Up VII"), DS(15, "Melee: Gravity Res Down VII"), DS(15, "Melee: Fatigue VII"), DS(25, "Stun: Decoy VII"), DS(35, "Melee Attack Up VII"), DS(35, "Theroid Criticals Up VII"), DS(35, "Resist Launch VII"), DS(100, "Resist Flinch VII")],
[DS(5, "Ether Resistance Up IX"), DS(10, "Resist Topple IX"), DS(10, "Melee Attack Boost IX"), DS(20, "Critical Chance Up IX"), DS(30, "Insectoid Criticals Up IX"), DS(30, "Piscinoid Criticals Up IX"), DS(30, "Humanoid Criticals Up IX"), DS(100, "Melee Accuracy Up IX")],
[DS(5, "Gravity Resistance Up IX"), DS(10, "Melee: Gravity Res Down IX"), DS(10, "Melee: Fatigue IX"), DS(20, "Stun: Decoy IX"), DS(30, "Melee Attack Up IX"), DS(30, "Theroid Criticals Up IX"), DS(30, "Resist Launch IX"), DS(100, "Resist Flinch IX")],
[DS(10, "Ether Resistance Up IX"), DS(15, "Resist Topple IX"), DS(15, "Melee Attack Boost IX"), DS(25, "Critical Chance Up IX"), DS(35, "Insectoid Criticals Up IX"), DS(35, "Piscinoid Criticals Up IX"), DS(35, "Humanoid Criticals Up IX"), DS(100, "Destabilizer IX")],
[DS(10, "Gravity Resistance Up IX"), DS(15, "Melee: Gravity Res Down IX"), DS(15, "Melee: Fatigue IX"), DS(25, "Stun: Decoy IX"), DS(35, "Melee Attack Up IX"), DS(35, "Theroid Criticals Up IX"), DS(35, "Resist Launch IX"), DS(100, "Resist Flinch IX")],
[DS(5, "Back Attack Plus VII"), DS(10, "Side Attack Plus VII"), DS(10, "Ranged Attack Boost VII"), DS(20, "Critical Chance Up VII"), DS(30, "Piscinoid Slayer VII"), DS(30, "Insectoid Slayer VII"), DS(30, "Theroid Slayer VII"), DS(100, "Ranged Accuracy Up VII")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Gravity Attack Plus VII"), DS(10, "Magazine Capacity Up VII"), DS(20, "Vantage Attack Plus VII"), DS(30, "Ranged Attack Up VII"), DS(30, "Humanoid Slayer VII"), DS(30, "Nullify Gravity Reflect VII"), DS(100, "Firing Range Up VII")],
[DS(10, "Back Attack Plus VII"), DS(15, "Side Attack Plus VII"), DS(15, "Ranged Attack Boost VII"), DS(25, "Critical Chance Up VII"), DS(35, "Piscinoid Slayer VII"), DS(35, "Insectoid Slayer VII"), DS(35, "Theroid Slayer VII"), DS(100, "Destabilizer VII")],
[DS(10, "Overdrive Green Bonus"), DS(15, "Gravity Attack Plus VII"), DS(15, "Magazine Capacity Up VII"), DS(25, "Vantage Attack Plus VII"), DS(35, "Ranged Attack Up VII"), DS(35, "Humanoid Slayer VII"), DS(35, "Nullify Gravity Reflect VII"), DS(100, "Firing Range Up VII")],
[DS(5, "Back Attack Plus IX"), DS(10, "Side Attack Plus IX"), DS(10, "Ranged Attack Boost IX"), DS(20, "Critical Chance Up IX"), DS(30, "Piscinoid Slayer IX"), DS(30, "Insectoid Slayer IX"), DS(30, "Theroid Slayer IX"), DS(100, "Ranged Accuracy Up IX")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Gravity Attack Plus IX"), DS(10, "Magazine Capacity Up IX"), DS(20, "Vantage Attack Plus IX"), DS(30, "Ranged Attack Up IX"), DS(30, "Humanoid Slayer IX"), DS(30, "Nullify Gravity Reflect IX"), DS(100, "Firing Range Up IX")],
[DS(10, "Back Attack Plus IX"), DS(15, "Side Attack Plus IX"), DS(15, "Ranged Attack Boost IX"), DS(25, "Critical Chance Up IX"), DS(35, "Piscinoid Slayer IX"), DS(35, "Insectoid Slayer IX"), DS(35, "Theroid Slayer IX"), DS(100, "Destabilizer IX")],
[DS(10, "Overdrive Green Bonus"), DS(15, "Gravity Attack Plus IX"), DS(15, "Magazine Capacity Up IX"), DS(25, "Vantage Attack Plus IX"), DS(35, "Ranged Attack Up IX"), DS(35, "Humanoid Slayer IX"), DS(35, "Nullify Gravity Reflect IX"), DS(100, "Firing Range Up IX")],
[DS(5, "Back Attack Plus XI"), DS(10, "Side Attack Plus XI"), DS(10, "Melee Attack Boost XI"), DS(20, "Critical Chance Up XI"), DS(30, "Insectoid Criticals Up XI"), DS(30, "Piscinoid Criticals Up XI"), DS(30, "Humanoid Criticals Up XI"), DS(100, "Melee Accuracy Up XI")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Melee: Gravity Res Down XI"), DS(10, "Melee: Fatigue XI"), DS(20, "Vantage Attack Plus XI"), DS(30, "Melee Attack Up XI"), DS(30, "Theroid Criticals Up XI"), DS(30, "Nullify Gravity Reflect XI"), DS(100, "Melee: Blackout XI")],
[DS(10, "Back Attack Plus XI"), DS(15, "Side Attack Plus XI"), DS(15, "Melee Attack Boost XI"), DS(25, "Critical Chance Up XI"), DS(35, "Insectoid Criticals Up XI"), DS(35, "Piscinoid Criticals Up XI"), DS(35, "Humanoid Criticals Up XI"), DS(100, "Destabilizer XI")],
[DS(10, "Overdrive Blue Bonus"), DS(15, "Melee: Gravity Res Down XI"), DS(15, "Melee: Fatigue XI"), DS(25, "Vantage Attack Plus XI"), DS(35, "Melee Attack Up XI"), DS(35, "Theroid Criticals Up XI"), DS(35, "Nullify Gravity Reflect XI"), DS(100, "Melee: Blackout XI")],
[DS(5, "Back Attack Plus XIII"), DS(10, "Side Attack Plus XIII"), DS(10, "Melee Attack Boost XIII"), DS(10, "Critical Chance Up XIII"), DS(15, "Insectoid Criticals Up XIII"), DS(15, "Piscinoid Criticals Up XIII"), DS(15, "Humanoid Criticals Up XIII"), DS(100, "Melee Accuracy Up XIII")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Melee: Gravity Res Down XIII"), DS(10, "Melee: Fatigue XIII"), DS(10, "Vantage Attack Plus XIII"), DS(15, "Melee Attack Up XIII"), DS(15, "Theroid Criticals Up XIII"), DS(15, "Nullify Gravity Reflect XIII"), DS(100, "Melee: Blackout XIII")],
[DS(3, "Back Attack Plus XV"), DS(8, "Side Attack Plus XV"), DS(8, "Melee Attack Boost XV"), DS(8, "Critical Chance Up XV"), DS(10, "Insectoid Criticals Up XV"), DS(10, "Piscinoid Criticals Up XV"), DS(10, "Humanoid Criticals Up XV"), DS(100, "Melee Accuracy Up XV")],
[DS(3, "Overdrive Blue Bonus"), DS(8, "Melee: Gravity Res Down XV"), DS(8, "Melee: Fatigue XV"), DS(8, "Vantage Attack Plus XV"), DS(10, "Melee Attack Up XV"), DS(10, "Theroid Criticals Up XV"), DS(10, "Nullify Gravity Reflect XV"), DS(100, "Melee: Blackout XV")],
[DS(5, "Ether Resistance Up XI"), DS(5, "Resist Topple XI"), DS(5, "Melee Attack Boost XI"), DS(20, "Critical Chance Up XI"), DS(30, "Insectoid Criticals Up XI"), DS(30, "Piscinoid Criticals Up XI"), DS(30, "Humanoid Criticals Up XI"), DS(100, "Melee Accuracy Up XI")],
[DS(5, "Gravity Resistance Up XI"), DS(5, "Melee: Gravity Res Down XI"), DS(5, "Melee: Fatigue XI"), DS(20, "Stun: Decoy XI"), DS(30, "Melee Attack Up XI"), DS(30, "Theroid Criticals Up XI"), DS(30, "Resist Launch XI"), DS(100, "Resist Flinch XI")],
[DS(10, "Ether Resistance Up XI"), DS(15, "Resist Topple XI"), DS(15, "Melee Attack Boost XI"), DS(25, "Critical Chance Up XI"), DS(35, "Insectoid Criticals Up XI"), DS(35, "Piscinoid Criticals Up XI"), DS(35, "Humanoid Criticals Up XI"), DS(100, "Destabilizer XI")],
[DS(10, "Gravity Resistance Up XI"), DS(15, "Melee: Gravity Res Down XI"), DS(15, "Melee: Fatigue XI"), DS(25, "Stun: Decoy XI"), DS(35, "Melee Attack Up XI"), DS(35, "Theroid Criticals Up XI"), DS(35, "Resist Launch XI"), DS(100, "Resist Flinch XI")],
[DS(5, "Ether Resistance Up XIII"), DS(8, "Resist Topple XIII"), DS(8, "Melee Attack Boost XIII"), DS(10, "Critical Chance Up XIII"), DS(15, "Insectoid Criticals Up XIII"), DS(15, "Piscinoid Criticals Up XIII"), DS(15, "Humanoid Criticals Up XIII"), DS(100, "Melee Accuracy Up XIII")],
[DS(5, "Gravity Resistance Up XIII"), DS(8, "Melee: Gravity Res Down XIII"), DS(8, "Melee: Fatigue XIII"), DS(10, "Stun: Decoy XIII"), DS(15, "Melee Attack Up XIII"), DS(15, "Theroid Criticals Up XIII"), DS(15, "Resist Launch XIII"), DS(100, "Resist Flinch XIII")],
[DS(3, "Ether Resistance Up XV"), DS(5, "Resist Topple XV"), DS(5, "Melee Attack Boost XV"), DS(8, "Critical Chance Up XV"), DS(10, "Insectoid Criticals Up XV"), DS(10, "Piscinoid Criticals Up XV"), DS(10, "Humanoid Criticals Up XV"), DS(100, "Melee Accuracy Up XV")],
[DS(3, "Gravity Resistance Up XV"), DS(5, "Melee: Gravity Res Down XV"), DS(5, "Melee: Fatigue XV"), DS(8, "Stun: Decoy XV"), DS(10, "Melee Attack Up XV"), DS(10, "Theroid Criticals Up XV"), DS(10, "Resist Launch XV"), DS(100, "Resist Flinch XV")],
[DS(5, "Back Attack Plus XI"), DS(10, "Side Attack Plus XI"), DS(10, "Ranged Attack Boost XI"), DS(20, "Critical Chance Up XI"), DS(30, "Piscinoid Slayer XI"), DS(30, "Insectoid Slayer XI"), DS(30, "Theroid Slayer XI"), DS(100, "Ranged Accuracy Up XI")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Gravity Attack Plus XI"), DS(10, "Magazine Capacity Up XI"), DS(20, "Vantage Attack Plus XI"), DS(30, "Ranged Attack Up XI"), DS(30, "Humanoid Slayer XI"), DS(30, "Nullify Gravity Reflect XI"), DS(100, "Firing Range Up XI")],
[DS(10, "Back Attack Plus XI"), DS(15, "Side Attack Plus XI"), DS(15, "Ranged Attack Boost XI"), DS(25, "Critical Chance Up XI"), DS(35, "Piscinoid Slayer XI"), DS(35, "Insectoid Slayer XI"), DS(35, "Theroid Slayer XI"), DS(100, "Destabilizer XI")],
[DS(10, "Overdrive Green Bonus"), DS(15, "Gravity Attack Plus XI"), DS(15, "Magazine Capacity Up XI"), DS(25, "Vantage Attack Plus XI"), DS(35, "Ranged Attack Up XI"), DS(35, "Humanoid Slayer XI"), DS(35, "Nullify Gravity Reflect XI"), DS(100, "Firing Range Up XI")],
[DS(5, "Back Attack Plus XIII"), DS(8, "Side Attack Plus XIII"), DS(8, "Ranged Attack Boost XIII"), DS(10, "Critical Chance Up XIII"), DS(15, "Piscinoid Slayer XIII"), DS(15, "Insectoid Slayer XIII"), DS(15, "Theroid Slayer XIII"), DS(100, "Ranged Accuracy Up XIII")],
[DS(5, "Overdrive Green Bonus"), DS(8, "Gravity Attack Plus XIII"), DS(8, "Magazine Capacity Up XIII"), DS(10, "Vantage Attack Plus XIII"), DS(15, "Ranged Attack Up XIII"), DS(15, "Humanoid Slayer XIII"), DS(15, "Nullify Gravity Reflect XIII"), DS(100, "Firing Range Up XIII")],
[DS(3, "Back Attack Plus XV"), DS(5, "Side Attack Plus XV"), DS(5, "Ranged Attack Boost XV"), DS(8, "Critical Chance Up XV"), DS(10, "Piscinoid Slayer XV"), DS(10, "Insectoid Slayer XV"), DS(10, "Theroid Slayer XV"), DS(100, "Ranged Accuracy Up XV")],
[DS(3, "Overdrive Green Bonus"), DS(5, "Gravity Attack Plus XV"), DS(5, "Magazine Capacity Up XV"), DS(8, "Vantage Attack Plus XV"), DS(10, "Ranged Attack Up XV"), DS(10, "Humanoid Slayer XV"), DS(10, "Nullify Gravity Reflect XV"), DS(100, "Firing Range Up XV")],
[DS(5, "Overdrive Count Up III"), DS(10, "Critical Chance Up III"), DS(10, "Humanoid Criticals Up III"), DS(20, "Melee Accuracy Up III"), DS(30, "Side Attack Plus III"), DS(30, "Nullify Gravity Reflect III"), DS(30, "Nullify Ether Reflect III"), DS(100, "Stabilizer III")],
[DS(5, "Weapon Attack Power Up III"), DS(10, "Melee: Recover HP III"), DS(10, "Potential Up III"), DS(20, "Melee Accuracy Boost III"), DS(30, "Melee: Fatigue III"), DS(30, "Soft Touch III"), DS(30, "Melee Attack Boost III"), DS(100, "Melee Attack Up III")],
[DS(10, "Overdrive Count Up III"), DS(15, "Critical Chance Up III"), DS(15, "Humanoid Criticals Up III"), DS(25, "Melee Accuracy Up III"), DS(35, "Side Attack Plus III"), DS(35, "Nullify Gravity Reflect III"), DS(35, "Nullify Ether Reflect III"), DS(100, "Destabilizer III")],
[DS(10, "Weapon Attack Power Up III"), DS(15, "Melee: Recover HP III"), DS(15, "Potential Up III"), DS(25, "Melee Accuracy Boost III"), DS(35, "Melee: Fatigue III"), DS(35, "Soft Touch III"), DS(35, "Melee Attack Boost III"), DS(100, "Melee Attack Up III")],
[DS(5, "Overdrive Count Up V"), DS(10, "Critical Chance Up V"), DS(10, "Humanoid Criticals Up V"), DS(20, "Melee Accuracy Up V"), DS(30, "Side Attack Plus V"), DS(30, "Nullify Gravity Reflect V"), DS(30, "Nullify Ether Reflect V"), DS(100, "Stabilizer V")],
[DS(5, "Weapon Attack Power Up V"), DS(10, "Melee: Recover HP V"), DS(10, "Potential Up V"), DS(20, "Melee Accuracy Boost V"), DS(30, "Melee: Fatigue V"), DS(30, "Soft Touch V"), DS(30, "Melee Attack Boost V"), DS(100, "Melee Attack Up V")],
[DS(10, "Overdrive Count Up V"), DS(15, "Critical Chance Up V"), DS(15, "Humanoid Criticals Up V"), DS(25, "Melee Accuracy Up V"), DS(35, "Side Attack Plus V"), DS(35, "Nullify Gravity Reflect V"), DS(35, "Nullify Ether Reflect V"), DS(100, "Destabilizer V")],
[DS(10, "Weapon Attack Power Up V"), DS(15, "Melee: Recover HP V"), DS(15, "Potential Up V"), DS(25, "Melee Accuracy Boost V"), DS(35, "Melee: Fatigue V"), DS(35, "Soft Touch V"), DS(35, "Melee Attack Boost V"), DS(100, "Melee Attack Up V")],
[DS(5, "Overdrive Count Up III"), DS(10, "Critical Chance Up III"), DS(10, "Humanoid Criticals Up III"), DS(20, "Melee Accuracy Up III"), DS(30, "Resist Stagger III"), DS(30, "Resist Launch III"), DS(30, "Resist Knockback III"), DS(100, "Stabilizer III")],
[DS(5, "Weapon Attack Power Up III"), DS(10, "Melee: Recover HP III"), DS(10, "Physical Resistance Up III"), DS(20, "Melee Accuracy Boost III"), DS(30, "Topple: Decoy III"), DS(30, "Soft Touch III"), DS(30, "Resist Flinch III"), DS(100, "Melee Attack Up III")],
[DS(10, "Overdrive Count Up III"), DS(15, "Critical Chance Up III"), DS(15, "Humanoid Criticals Up III"), DS(25, "Melee Accuracy Up III"), DS(35, "Resist Stagger III"), DS(35, "Resist Launch III"), DS(35, "Resist Knockback III"), DS(100, "Destabilizer III")],
[DS(10, "Weapon Attack Power Up III"), DS(15, "Melee: Recover HP III"), DS(15, "Physical Resistance Up III"), DS(25, "Melee Accuracy Boost III"), DS(35, "Topple: Decoy III"), DS(35, "Soft Touch III"), DS(35, "Resist Flinch III"), DS(100, "Melee Attack Up III")],
[DS(5, "Overdrive Count Up V"), DS(10, "Critical Chance Up V"), DS(10, "Humanoid Criticals Up V"), DS(20, "Melee Accuracy Up V"), DS(30, "Resist Stagger V"), DS(30, "Resist Launch V"), DS(30, "Resist Knockback V"), DS(100, "Stabilizer V")],
[DS(5, "Weapon Attack Power Up V"), DS(10, "Melee: Recover HP V"), DS(10, "Physical Resistance Up V"), DS(20, "Melee Accuracy Boost V"), DS(30, "Topple: Decoy V"), DS(30, "Soft Touch V"), DS(30, "Resist Flinch V"), DS(100, "Melee Attack Up V")],
[DS(10, "Overdrive Count Up V"), DS(15, "Critical Chance Up V"), DS(15, "Humanoid Criticals Up V"), DS(25, "Melee Accuracy Up V"), DS(35, "Resist Stagger V"), DS(35, "Resist Launch V"), DS(35, "Resist Knockback V"), DS(100, "Destabilizer V")],
[DS(10, "Weapon Attack Power Up V"), DS(15, "Melee: Recover HP V"), DS(15, "Physical Resistance Up V"), DS(25, "Melee Accuracy Boost V"), DS(35, "Topple: Decoy V"), DS(35, "Soft Touch V"), DS(35, "Resist Flinch V"), DS(100, "Melee Attack Up V")],
[DS(5, "Opening Art: Damage Up III"), DS(10, "Critical Chance Up III"), DS(10, "Humanoid Slayer III"), DS(20, "Ranged Accuracy Up III"), DS(30, "Side Attack Plus III"), DS(30, "Nullify Gravity Reflect III"), DS(30, "Nullify Ether Reflect III"), DS(100, "Stabilizer III")],
[DS(5, "Weapon Attack Power Up III"), DS(10, "Ranged: TP Gain Up"), DS(10, "Magazine Capacity Up III"), DS(20, "Ranged Accuracy Boost III"), DS(30, "Firing Range Up III"), DS(30, "Vantage Attack Plus III"), DS(30, "Ranged Attack Boost III"), DS(100, "Ranged Attack Up III")],
[DS(10, "Opening Art: Damage Up III"), DS(15, "Critical Chance Up III"), DS(15, "Humanoid Slayer III"), DS(25, "Ranged Accuracy Up III"), DS(35, "Side Attack Plus III"), DS(35, "Nullify Gravity Reflect III"), DS(35, "Nullify Ether Reflect III"), DS(100, "Destabilizer III")],
[DS(10, "Weapon Attack Power Up III"), DS(15, "Ranged: TP Gain Up"), DS(15, "Magazine Capacity Up III"), DS(25, "Ranged Accuracy Boost III"), DS(35, "Firing Range Up III"), DS(35, "Vantage Attack Plus III"), DS(35, "Ranged Attack Boost III"), DS(100, "Ranged Attack Up III")],
[DS(5, "Opening Art: Damage Up V"), DS(10, "Critical Chance Up V"), DS(10, "Humanoid Slayer V"), DS(20, "Ranged Accuracy Up V"), DS(30, "Side Attack Plus V"), DS(30, "Nullify Gravity Reflect V"), DS(30, "Nullify Ether Reflect V"), DS(100, "Stabilizer V")],
[DS(5, "Weapon Attack Power Up V"), DS(10, "Ranged: TP Gain Up"), DS(10, "Magazine Capacity Up V"), DS(20, "Ranged Accuracy Boost V"), DS(30, "Firing Range Up V"), DS(30, "Vantage Attack Plus V"), DS(30, "Ranged Attack Boost V"), DS(100, "Ranged Attack Up V")],
[DS(10, "Opening Art: Damage Up V"), DS(15, "Critical Chance Up V"), DS(15, "Humanoid Slayer V"), DS(25, "Ranged Accuracy Up V"), DS(35, "Side Attack Plus V"), DS(35, "Nullify Gravity Reflect V"), DS(35, "Nullify Ether Reflect V"), DS(100, "Destabilizer V")],
[DS(10, "Weapon Attack Power Up V"), DS(15, "Ranged: TP Gain Up"), DS(15, "Magazine Capacity Up V"), DS(25, "Ranged Accuracy Boost V"), DS(35, "Firing Range Up V"), DS(35, "Vantage Attack Plus V"), DS(35, "Ranged Attack Boost V"), DS(100, "Ranged Attack Up V")],
[DS(5, "Overdrive Count Up VII"), DS(10, "Critical Chance Up VII"), DS(10, "Humanoid Criticals Up VII"), DS(20, "Melee Accuracy Up VII"), DS(30, "Side Attack Plus VII"), DS(30, "Nullify Gravity Reflect VII"), DS(30, "Nullify Ether Reflect VII"), DS(100, "Stabilizer VII")],
[DS(5, "Weapon Attack Power Up VII"), DS(10, "Melee: Recover HP VII"), DS(10, "Potential Up VII"), DS(20, "Melee Accuracy Boost VII"), DS(30, "Melee: Fatigue VII"), DS(30, "Soft Touch VII"), DS(30, "Melee Attack Boost VII"), DS(100, "Melee Attack Up VII")],
[DS(10, "Overdrive Count Up VII"), DS(15, "Critical Chance Up VII"), DS(15, "Humanoid Criticals Up VII"), DS(25, "Melee Accuracy Up VII"), DS(35, "Side Attack Plus VII"), DS(35, "Nullify Gravity Reflect VII"), DS(35, "Nullify Ether Reflect VII"), DS(100, "Destabilizer VII")],
[DS(10, "Weapon Attack Power Up VII"), DS(15, "Melee: Recover HP VII"), DS(15, "Potential Up VII"), DS(25, "Melee Accuracy Boost VII"), DS(35, "Melee: Fatigue VII"), DS(35, "Soft Touch VII"), DS(35, "Melee Attack Boost VII"), DS(100, "Melee Attack Up VII")],
[DS(5, "Overdrive Count Up IX"), DS(10, "Critical Chance Up IX"), DS(10, "Humanoid Criticals Up IX"), DS(20, "Melee Accuracy Up IX"), DS(30, "Side Attack Plus IX"), DS(30, "Nullify Gravity Reflect IX"), DS(30, "Nullify Ether Reflect IX"), DS(100, "Stabilizer IX")],
[DS(5, "Weapon Attack Power Up IX"), DS(10, "Melee: Recover HP IX"), DS(10, "Potential Up IX"), DS(20, "Melee Accuracy Boost IX"), DS(30, "Melee: Fatigue IX"), DS(30, "Soft Touch IX"), DS(30, "Melee Attack Boost IX"), DS(100, "Melee Attack Up IX")],
[DS(10, "Overdrive Count Up IX"), DS(15, "Critical Chance Up IX"), DS(15, "Humanoid Criticals Up IX"), DS(25, "Melee Accuracy Up IX"), DS(35, "Side Attack Plus IX"), DS(35, "Nullify Gravity Reflect IX"), DS(35, "Nullify Ether Reflect IX"), DS(100, "Destabilizer IX")],
[DS(10, "Weapon Attack Power Up IX"), DS(15, "Melee: Recover HP IX"), DS(15, "Potential Up IX"), DS(25, "Melee Accuracy Boost IX"), DS(35, "Melee: Fatigue IX"), DS(35, "Soft Touch IX"), DS(35, "Melee Attack Boost IX"), DS(100, "Melee Attack Up IX")],
[DS(5, "Overdrive Count Up VII"), DS(10, "Critical Chance Up VII"), DS(10, "Humanoid Criticals Up VII"), DS(20, "Melee Accuracy Up VII"), DS(30, "Resist Stagger VII"), DS(30, "Resist Launch VII"), DS(30, "Resist Knockback VII"), DS(100, "Stabilizer VII")],
[DS(5, "Weapon Attack Power Up VII"), DS(10, "Melee: Recover HP VII"), DS(10, "Physical Resistance Up VII"), DS(20, "Melee Accuracy Boost VII"), DS(30, "Topple: Decoy VII"), DS(30, "Soft Touch VII"), DS(30, "Resist Flinch VII"), DS(100, "Melee Attack Up VII")],
[DS(10, "Overdrive Count Up VII"), DS(15, "Critical Chance Up VII"), DS(15, "Humanoid Criticals Up VII"), DS(25, "Melee Accuracy Up VII"), DS(35, "Resist Stagger VII"), DS(35, "Resist Launch VII"), DS(35, "Resist Knockback VII"), DS(100, "Destabilizer VII")],
[DS(10, "Weapon Attack Power Up VII"), DS(15, "Melee: Recover HP VII"), DS(15, "Physical Resistance Up VII"), DS(25, "Melee Accuracy Boost VII"), DS(35, "Topple: Decoy VII"), DS(35, "Soft Touch VII"), DS(35, "Resist Flinch VII"), DS(100, "Melee Attack Up VII")],
[DS(5, "Overdrive Count Up IX"), DS(10, "Critical Chance Up IX"), DS(10, "Humanoid Criticals Up IX"), DS(20, "Melee Accuracy Up IX"), DS(30, "Resist Stagger IX"), DS(30, "Resist Launch IX"), DS(30, "Resist Knockback IX"), DS(100, "Stabilizer IX")],
[DS(5, "Weapon Attack Power Up IX"), DS(10, "Melee: Recover HP IX"), DS(10, "Physical Resistance Up IX"), DS(20, "Melee Accuracy Boost IX"), DS(30, "Topple: Decoy IX"), DS(30, "Soft Touch IX"), DS(30, "Resist Flinch IX"), DS(100, "Melee Attack Up IX")],
[DS(10, "Overdrive Count Up IX"), DS(15, "Critical Chance Up IX"), DS(15, "Humanoid Criticals Up IX"), DS(25, "Melee Accuracy Up IX"), DS(35, "Resist Stagger IX"), DS(35, "Resist Launch IX"), DS(35, "Resist Knockback IX"), DS(100, "Destabilizer IX")],
[DS(10, "Weapon Attack Power Up IX"), DS(15, "Melee: Recover HP IX"), DS(15, "Physical Resistance Up IX"), DS(25, "Melee Accuracy Boost IX"), DS(35, "Topple: Decoy IX"), DS(35, "Soft Touch IX"), DS(35, "Resist Flinch IX"), DS(100, "Melee Attack Up IX")],
[DS(5, "Opening Art: Damage Up VII"), DS(10, "Critical Chance Up VII"), DS(10, "Humanoid Slayer VII"), DS(20, "Ranged Accuracy Up VII"), DS(30, "Side Attack Plus VII"), DS(30, "Nullify Gravity Reflect VII"), DS(30, "Nullify Ether Reflect VII"), DS(100, "Stabilizer VII")],
[DS(5, "Weapon Attack Power Up VII"), DS(10, "Ranged: TP Gain Up"), DS(10, "Magazine Capacity Up VII"), DS(20, "Ranged Accuracy Boost VII"), DS(30, "Firing Range Up VII"), DS(30, "Vantage Attack Plus VII"), DS(30, "Ranged Attack Boost VII"), DS(100, "Ranged Attack Up VII")],
[DS(10, "Opening Art: Damage Up VII"), DS(15, "Critical Chance Up VII"), DS(15, "Humanoid Slayer VII"), DS(25, "Ranged Accuracy Up VII"), DS(35, "Side Attack Plus VII"), DS(35, "Nullify Gravity Reflect VII"), DS(35, "Nullify Ether Reflect VII"), DS(100, "Destabilizer VII")],
[DS(10, "Weapon Attack Power Up VII"), DS(15, "Ranged: TP Gain Up"), DS(15, "Magazine Capacity Up VII"), DS(25, "Ranged Accuracy Boost VII"), DS(35, "Firing Range Up VII"), DS(35, "Vantage Attack Plus VII"), DS(35, "Ranged Attack Boost VII"), DS(100, "Ranged Attack Up VII")],
[DS(5, "Opening Art: Damage Up IX"), DS(10, "Critical Chance Up IX"), DS(10, "Humanoid Slayer IX"), DS(20, "Ranged Accuracy Up IX"), DS(30, "Side Attack Plus IX"), DS(30, "Nullify Gravity Reflect IX"), DS(30, "Nullify Ether Reflect IX"), DS(100, "Stabilizer IX")],
[DS(5, "Weapon Attack Power Up IX"), DS(10, "Ranged: TP Gain Up"), DS(10, "Magazine Capacity Up IX"), DS(20, "Ranged Accuracy Boost IX"), DS(30, "Firing Range Up IX"), DS(30, "Vantage Attack Plus IX"), DS(30, "Ranged Attack Boost IX"), DS(100, "Ranged Attack Up IX")],
[DS(10, "Opening Art: Damage Up IX"), DS(15, "Critical Chance Up IX"), DS(15, "Humanoid Slayer IX"), DS(25, "Ranged Accuracy Up IX"), DS(35, "Side Attack Plus IX"), DS(35, "Nullify Gravity Reflect IX"), DS(35, "Nullify Ether Reflect IX"), DS(100, "Destabilizer IX")],
[DS(10, "Weapon Attack Power Up IX"), DS(15, "Ranged: TP Gain Up"), DS(15, "Magazine Capacity Up IX"), DS(25, "Ranged Accuracy Boost IX"), DS(35, "Firing Range Up IX"), DS(35, "Vantage Attack Plus IX"), DS(35, "Ranged Attack Boost IX"), DS(100, "Ranged Attack Up IX")],
[DS(5, "Overdrive Count Up XI"), DS(10, "Critical Chance Up XI"), DS(10, "Humanoid Criticals Up XI"), DS(20, "Melee Accuracy Up XI"), DS(30, "Side Attack Plus XI"), DS(30, "Nullify Gravity Reflect XI"), DS(30, "Nullify Ether Reflect XI"), DS(100, "Stabilizer XI")],
[DS(5, "Weapon Attack Power Up XI"), DS(10, "Melee: Recover HP XI"), DS(10, "Potential Up XI"), DS(20, "Melee Accuracy Boost XI"), DS(30, "Melee: Fatigue XI"), DS(30, "Soft Touch XI"), DS(30, "Melee Attack Boost XI"), DS(100, "Melee Attack Up XI")],
[DS(10, "Overdrive Count Up XI"), DS(15, "Critical Chance Up XI"), DS(15, "Humanoid Criticals Up XI"), DS(25, "Melee Accuracy Up XI"), DS(35, "Side Attack Plus XI"), DS(35, "Nullify Gravity Reflect XI"), DS(35, "Nullify Ether Reflect XI"), DS(100, "Destabilizer XI")],
[DS(10, "Weapon Attack Power Up XI"), DS(15, "Melee: Recover HP XI"), DS(15, "Potential Up XI"), DS(25, "Melee Accuracy Boost XI"), DS(35, "Melee: Fatigue XI"), DS(35, "Soft Touch XI"), DS(35, "Melee Attack Boost XI"), DS(100, "Melee Attack Up XI")],
[DS(5, "Overdrive Count Up XIII"), DS(8, "Critical Chance Up XIII"), DS(8, "Humanoid Criticals Up XIII"), DS(10, "Melee Accuracy Up XIII"), DS(15, "Side Attack Plus XIII"), DS(15, "Nullify Gravity Reflect XIII"), DS(15, "Nullify Ether Reflect XIII"), DS(100, "Stabilizer XIII")],
[DS(5, "Weapon Attack Power Up XIII"), DS(8, "Melee: Recover HP XIII"), DS(8, "Potential Up XIII"), DS(10, "Melee Accuracy Boost XIII"), DS(15, "Melee: Fatigue XIII"), DS(15, "Soft Touch XIII"), DS(15, "Melee Attack Boost XIII"), DS(100, "Melee Attack Up XIII")],
[DS(3, "Overdrive Count Up XV"), DS(5, "Critical Chance Up XV"), DS(5, "Humanoid Criticals Up XV"), DS(8, "Melee Accuracy Up XV"), DS(10, "Side Attack Plus XV"), DS(10, "Nullify Gravity Reflect XV"), DS(10, "Nullify Ether Reflect XV"), DS(100, "Stabilizer XV")],
[DS(3, "Weapon Attack Power Up XV"), DS(5, "Melee: Recover HP XV"), DS(5, "Potential Up XV"), DS(8, "Melee Accuracy Boost XV"), DS(10, "Melee: Fatigue XV"), DS(10, "Soft Touch XV"), DS(10, "Melee Attack Boost XV"), DS(100, "Melee Attack Up XV")],
[DS(5, "Overdrive Count Up XI"), DS(10, "Critical Chance Up XI"), DS(10, "Humanoid Criticals Up XI"), DS(20, "Melee Accuracy Up XI"), DS(30, "Resist Stagger XI"), DS(30, "Resist Launch XI"), DS(30, "Resist Knockback XI"), DS(100, "Stabilizer XI")],
[DS(5, "Weapon Attack Power Up XI"), DS(10, "Melee: Recover HP XI"), DS(10, "Physical Resistance Up XI"), DS(20, "Melee Accuracy Boost XI"), DS(30, "Topple: Decoy XI"), DS(30, "Soft Touch XI"), DS(30, "Resist Flinch XI"), DS(100, "Melee Attack Up XI")],
[DS(10, "Overdrive Count Up XI"), DS(15, "Critical Chance Up XI"), DS(15, "Humanoid Criticals Up XI"), DS(25, "Melee Accuracy Up XI"), DS(35, "Resist Stagger XI"), DS(35, "Resist Launch XI"), DS(35, "Resist Knockback XI"), DS(100, "Destabilizer XI")],
[DS(10, "Weapon Attack Power Up XI"), DS(15, "Melee: Recover HP XI"), DS(15, "Physical Resistance Up XI"), DS(25, "Melee Accuracy Boost XI"), DS(35, "Topple: Decoy XI"), DS(35, "Soft Touch XI"), DS(35, "Resist Flinch XI"), DS(100, "Melee Attack Up XI")],
[DS(5, "Overdrive Count Up XIII"), DS(8, "Critical Chance Up XIII"), DS(8, "Humanoid Criticals Up XIII"), DS(10, "Melee Accuracy Up XIII"), DS(15, "Resist Stagger XIII"), DS(15, "Resist Launch XIII"), DS(15, "Resist Knockback XIII"), DS(100, "Stabilizer XIII")],
[DS(5, "Weapon Attack Power Up XIII"), DS(8, "Melee: Recover HP XIII"), DS(8, "Physical Resistance Up XIII"), DS(10, "Melee Accuracy Boost XIII"), DS(15, "Topple: Decoy XIII"), DS(15, "Soft Touch XIII"), DS(15, "Resist Flinch XIII"), DS(100, "Melee Attack Up XIII")],
[DS(3, "Overdrive Count Up XV"), DS(5, "Critical Chance Up XV"), DS(5, "Humanoid Criticals Up XV"), DS(8, "Melee Accuracy Up XV"), DS(10, "Resist Stagger XV"), DS(10, "Resist Launch XV"), DS(10, "Resist Knockback XV"), DS(100, "Stabilizer XV")],
[DS(3, "Weapon Attack Power Up XV"), DS(5, "Melee: Recover HP XV"), DS(5, "Physical Resistance Up XV"), DS(8, "Melee Accuracy Boost XV"), DS(10, "Topple: Decoy XV"), DS(10, "Soft Touch XV"), DS(10, "Resist Flinch XV"), DS(100, "Melee Attack Up XV")],
[DS(5, "Opening Art: Damage Up XI"), DS(10, "Critical Chance Up XI"), DS(10, "Humanoid Slayer XI"), DS(20, "Ranged Accuracy Up XI"), DS(30, "Side Attack Plus XI"), DS(30, "Nullify Gravity Reflect XI"), DS(30, "Nullify Ether Reflect XI"), DS(100, "Stabilizer XI")],
[DS(5, "Weapon Attack Power Up XI"), DS(10, "Ranged: TP Gain Up"), DS(10, "Magazine Capacity Up XI"), DS(20, "Ranged Accuracy Boost XI"), DS(30, "Firing Range Up XI"), DS(30, "Vantage Attack Plus XI"), DS(30, "Ranged Attack Boost XI"), DS(100, "Ranged Attack Up XI")],
[DS(10, "Opening Art: Damage Up XI"), DS(15, "Critical Chance Up XI"), DS(15, "Humanoid Slayer XI"), DS(25, "Ranged Accuracy Up XI"), DS(35, "Side Attack Plus XI"), DS(35, "Nullify Gravity Reflect XI"), DS(35, "Nullify Ether Reflect XI"), DS(100, "Destabilizer XI")],
[DS(10, "Weapon Attack Power Up XI"), DS(15, "Ranged: TP Gain Up"), DS(15, "Magazine Capacity Up XI"), DS(25, "Ranged Accuracy Boost XI"), DS(35, "Firing Range Up XI"), DS(35, "Vantage Attack Plus XI"), DS(35, "Ranged Attack Boost XI"), DS(100, "Ranged Attack Up XI")],
[DS(5, "Opening Art: Damage Up XIII"), DS(8, "Critical Chance Up XIII"), DS(8, "Humanoid Slayer XIII"), DS(10, "Ranged Accuracy Up XIII"), DS(15, "Side Attack Plus XIII"), DS(15, "Nullify Gravity Reflect XIII"), DS(15, "Nullify Ether Reflect XIII"), DS(100, "Stabilizer XIII")],
[DS(5, "Weapon Attack Power Up XIII"), DS(8, "Ranged: TP Gain Up"), DS(8, "Magazine Capacity Up XIII"), DS(10, "Ranged Accuracy Boost XIII"), DS(15, "Firing Range Up XIII"), DS(15, "Vantage Attack Plus XIII"), DS(15, "Ranged Attack Boost XIII"), DS(100, "Ranged Attack Up XIII")],
[DS(3, "Opening Art: Damage Up XV"), DS(5, "Critical Chance Up XV"), DS(5, "Humanoid Slayer XV"), DS(8, "Ranged Accuracy Up XV"), DS(10, "Side Attack Plus XV"), DS(10, "Nullify Gravity Reflect XV"), DS(10, "Nullify Ether Reflect XV"), DS(100, "Stabilizer XV")],
[DS(3, "Weapon Attack Power Up XV"), DS(5, "Ranged: TP Gain Up"), DS(5, "Magazine Capacity Up XV"), DS(8, "Ranged Accuracy Boost XV"), DS(10, "Firing Range Up XV"), DS(10, "Vantage Attack Plus XV"), DS(10, "Ranged Attack Boost XV"), DS(100, "Ranged Attack Up XV")],
[DS(5, "Critical Chance Up VII"), DS(10, "Thermal Attack Plus VII"), DS(10, "Melee Accuracy Boost VII"), DS(20, "Melee Accuracy Up VII"), DS(30, "Front Attack Plus VII"), DS(30, "Melee: Thermal Res Down VII"), DS(30, "Crush: Gain TP VII"), DS(100, "Stabilizer VII")],
[DS(5, "Weapon Attack Power Up VII"), DS(10, "Arts: Recover HP VII"), DS(10, "Ultrafauna Criticals Up VII"), DS(20, "Ranged Appendage Damage VII"), DS(30, "Ultrafauna Slayer VII"), DS(30, "Mechanoid Criticals Up VII"), DS(30, "Melee: TP Gain Up"), DS(100, "Nullify Physical Reflect VII")],
[DS(10, "Critical Chance Up VII"), DS(15, "Thermal Attack Plus VII"), DS(15, "Melee Accuracy Boost VII"), DS(25, "Melee Accuracy Up VII"), DS(35, "Front Attack Plus VII"), DS(35, "Melee: Thermal Res Down VII"), DS(35, "Crush: Gain TP VII"), DS(100, "Destabilizer VII")],
[DS(10, "Weapon Attack Power Up VII"), DS(15, "Arts: Recover HP VII"), DS(15, "Ultrafauna Criticals Up VII"), DS(25, "Ranged Appendage Damage VII"), DS(35, "Ultrafauna Slayer VII"), DS(35, "Mechanoid Criticals Up VII"), DS(35, "Melee: TP Gain Up"), DS(100, "Nullify Physical Reflect VII")],
[DS(5, "Critical Chance Up IX"), DS(10, "Thermal Attack Plus IX"), DS(10, "Melee Accuracy Boost IX"), DS(20, "Melee Accuracy Up IX"), DS(30, "Front Attack Plus IX"), DS(30, "Melee: Thermal Res Down IX"), DS(30, "Crush: Gain TP IX"), DS(100, "Stabilizer IX")],
[DS(5, "Weapon Attack Power Up IX"), DS(10, "Arts: Recover HP IX"), DS(10, "Ultrafauna Criticals Up IX"), DS(20, "Ranged Appendage Damage IX"), DS(30, "Ultrafauna Slayer IX"), DS(30, "Mechanoid Criticals Up IX"), DS(30, "Melee: TP Gain Up"), DS(100, "Nullify Physical Reflect IX")],
[DS(10, "Critical Chance Up IX"), DS(15, "Thermal Attack Plus IX"), DS(15, "Melee Accuracy Boost IX"), DS(25, "Melee Accuracy Up IX"), DS(35, "Front Attack Plus IX"), DS(35, "Melee: Thermal Res Down IX"), DS(35, "Crush: Gain TP IX"), DS(100, "Destabilizer IX")],
[DS(10, "Weapon Attack Power Up IX"), DS(15, "Arts: Recover HP IX"), DS(15, "Ultrafauna Criticals Up IX"), DS(25, "Ranged Appendage Damage IX"), DS(35, "Ultrafauna Slayer IX"), DS(35, "Mechanoid Criticals Up IX"), DS(35, "Melee: TP Gain Up"), DS(100, "Nullify Physical Reflect IX")],
[DS(5, "Front Attack Plus VII"), DS(10, "Overdrive Count Up VII"), DS(10, "Ranged Accuracy Boost VII"), DS(20, "Ranged Accuracy Up VII"), DS(30, "Nullify Ether Reflect VII"), DS(30, "Nullify Beam Reflect VII"), DS(30, "Nullify Thermal Reflect VII"), DS(100, "Stabilizer VII")],
[DS(5, "Weapon Attack Power Up VII"), DS(10, "Ranged: TP Gain Up"), DS(10, "Magazine Capacity Up VII"), DS(20, "Appendage Crusher"), DS(30, "Ultrafauna Slayer VII"), DS(30, "Mechanoid Slayer VII"), DS(30, "Night Vision VII"), DS(100, "Nullify Physical Reflect VII")],
[DS(10, "Front Attack Plus VII"), DS(15, "Overdrive Count Up VII"), DS(15, "Ranged Accuracy Boost VII"), DS(25, "Ranged Accuracy Up VII"), DS(35, "Nullify Ether Reflect VII"), DS(35, "Nullify Beam Reflect VII"), DS(35, "Nullify Thermal Reflect VII"), DS(100, "Destabilizer VII")],
[DS(10, "Weapon Attack Power Up VII"), DS(15, "Ranged: TP Gain Up"), DS(15, "Magazine Capacity Up VII"), DS(25, "Appendage Crusher"), DS(35, "Ultrafauna Slayer VII"), DS(35, "Mechanoid Slayer VII"), DS(35, "Night Vision VII"), DS(100, "Nullify Physical Reflect VII")],
[DS(5, "Front Attack Plus IX"), DS(10, "Overdrive Count Up IX"), DS(10, "Ranged Accuracy Boost IX"), DS(20, "Ranged Accuracy Up IX"), DS(30, "Nullify Ether Reflect IX"), DS(30, "Nullify Beam Reflect IX"), DS(30, "Nullify Thermal Reflect IX"), DS(100, "Stabilizer IX")],
[DS(5, "Weapon Attack Power Up IX"), DS(10, "Ranged: TP Gain Up"), DS(10, "Magazine Capacity Up IX"), DS(20, "Appendage Crusher"), DS(30, "Ultrafauna Slayer IX"), DS(30, "Mechanoid Slayer IX"), DS(30, "Night Vision IX"), DS(100, "Nullify Physical Reflect IX")],
[DS(10, "Front Attack Plus IX"), DS(15, "Overdrive Count Up IX"), DS(15, "Ranged Accuracy Boost IX"), DS(25, "Ranged Accuracy Up IX"), DS(35, "Nullify Ether Reflect IX"), DS(35, "Nullify Beam Reflect IX"), DS(35, "Nullify Thermal Reflect IX"), DS(100, "Destabilizer IX")],
[DS(10, "Weapon Attack Power Up IX"), DS(15, "Ranged: TP Gain Up"), DS(15, "Magazine Capacity Up IX"), DS(25, "Appendage Crusher"), DS(35, "Ultrafauna Slayer IX"), DS(35, "Mechanoid Slayer IX"), DS(35, "Night Vision IX"), DS(100, "Nullify Physical Reflect IX")],
[DS(5, "Critical Chance Up XI"), DS(10, "Thermal Attack Plus XI"), DS(10, "Melee Accuracy Boost XI"), DS(20, "Melee Accuracy Up XI"), DS(30, "Front Attack Plus XI"), DS(30, "Melee: Thermal Res Down XI"), DS(30, "Crush: Gain TP XI"), DS(100, "Stabilizer XI")],
[DS(5, "Weapon Attack Power Up XI"), DS(10, "Arts: Recover HP XI"), DS(10, "Ultrafauna Criticals Up XI"), DS(20, "Ranged Appendage Damage XI"), DS(30, "Ultrafauna Slayer XI"), DS(30, "Mechanoid Criticals Up XI"), DS(30, "Melee: TP Gain Up"), DS(100, "Nullify Physical Reflect XI")],
[DS(10, "Critical Chance Up XI"), DS(15, "Thermal Attack Plus XI"), DS(15, "Melee Accuracy Boost XI"), DS(25, "Melee Accuracy Up XI"), DS(35, "Front Attack Plus XI"), DS(35, "Melee: Thermal Res Down XI"), DS(35, "Crush: Gain TP XI"), DS(100, "Destabilizer XI")],
[DS(10, "Weapon Attack Power Up XI"), DS(15, "Arts: Recover HP XI"), DS(15, "Ultrafauna Criticals Up XI"), DS(25, "Ranged Appendage Damage XI"), DS(35, "Ultrafauna Slayer XI"), DS(35, "Mechanoid Criticals Up XI"), DS(35, "Melee: TP Gain Up"), DS(100, "Nullify Physical Reflect XI")],
[DS(5, "Critical Chance Up XIII"), DS(8, "Thermal Attack Plus XIII"), DS(8, "Melee Accuracy Boost XIII"), DS(10, "Melee Accuracy Up XIII"), DS(15, "Front Attack Plus XIII"), DS(15, "Melee: Thermal Res Down XIII"), DS(15, "Crush: Gain TP XIII"), DS(100, "Stabilizer XIII")],
[DS(5, "Weapon Attack Power Up XIII"), DS(8, "Arts: Recover HP XIII"), DS(8, "Ultrafauna Criticals Up XIII"), DS(10, "Ranged Appendage Damage XIII"), DS(15, "Ultrafauna Slayer XIII"), DS(15, "Mechanoid Criticals Up XIII"), DS(15, "Melee: TP Gain Up"), DS(100, "Nullify Physical Reflect XIII")],
[DS(3, "Critical Chance Up XV"), DS(5, "Thermal Attack Plus XV"), DS(5, "Melee Accuracy Boost XV"), DS(8, "Melee Accuracy Up XV"), DS(10, "Front Attack Plus XV"), DS(10, "Melee: Thermal Res Down XV"), DS(10, "Crush: Gain TP XV"), DS(100, "Stabilizer XV")],
[DS(3, "Weapon Attack Power Up XV"), DS(5, "Arts: Recover HP XV"), DS(5, "Ultrafauna Criticals Up XV"), DS(8, "Ranged Appendage Damage XV"), DS(10, "Ultrafauna Slayer XV"), DS(10, "Mechanoid Criticals Up XV"), DS(10, "Melee: TP Gain Up"), DS(100, "Nullify Physical Reflect XV")],
[DS(5, "Front Attack Plus XI"), DS(10, "Overdrive Count Up XI"), DS(10, "Ranged Accuracy Boost XI"), DS(20, "Ranged Accuracy Up XI"), DS(30, "Nullify Ether Reflect XI"), DS(30, "Nullify Beam Reflect XI"), DS(30, "Nullify Thermal Reflect XI"), DS(100, "Stabilizer XI")],
[DS(5, "Weapon Attack Power Up XI"), DS(10, "Ranged: TP Gain Up"), DS(10, "Magazine Capacity Up XI"), DS(20, "Appendage Crusher"), DS(30, "Ultrafauna Slayer XI"), DS(30, "Mechanoid Slayer XI"), DS(30, "Night Vision XI"), DS(100, "Nullify Physical Reflect XI")],
[DS(10, "Front Attack Plus XI"), DS(15, "Overdrive Count Up XI"), DS(15, "Ranged Accuracy Boost XI"), DS(25, "Ranged Accuracy Up XI"), DS(35, "Nullify Ether Reflect XI"), DS(35, "Nullify Beam Reflect XI"), DS(35, "Nullify Thermal Reflect XI"), DS(100, "Destabilizer XI")],
[DS(10, "Weapon Attack Power Up XI"), DS(15, "Ranged: TP Gain Up"), DS(15, "Magazine Capacity Up XI"), DS(25, "Appendage Crusher"), DS(35, "Ultrafauna Slayer XI"), DS(35, "Mechanoid Slayer XI"), DS(35, "Night Vision XI"), DS(100, "Nullify Physical Reflect XI")],
[DS(5, "Front Attack Plus XIII"), DS(8, "Overdrive Count Up XIII"), DS(8, "Ranged Accuracy Boost XIII"), DS(10, "Ranged Accuracy Up XIII"), DS(15, "Nullify Ether Reflect XIII"), DS(15, "Nullify Beam Reflect XIII"), DS(15, "Nullify Thermal Reflect XIII"), DS(100, "Stabilizer XIII")],
[DS(5, "Weapon Attack Power Up XIII"), DS(8, "Ranged: TP Gain Up"), DS(8, "Magazine Capacity Up XIII"), DS(10, "Appendage Crusher"), DS(15, "Ultrafauna Slayer XIII"), DS(15, "Mechanoid Slayer XIII"), DS(15, "Night Vision XIII"), DS(100, "Nullify Physical Reflect XIII")],
[DS(3, "Front Attack Plus XV"), DS(5, "Overdrive Count Up XV"), DS(5, "Ranged Accuracy Boost XV"), DS(8, "Ranged Accuracy Up XV"), DS(10, "Nullify Ether Reflect XV"), DS(10, "Nullify Beam Reflect XV"), DS(10, "Nullify Thermal Reflect XV"), DS(100, "Stabilizer XV")],
[DS(3, "Weapon Attack Power Up XV"), DS(5, "Ranged: TP Gain Up"), DS(5, "Magazine Capacity Up XV"), DS(8, "Appendage Crusher"), DS(10, "Ultrafauna Slayer XV"), DS(10, "Mechanoid Slayer XV"), DS(10, "Night Vision XV"), DS(100, "Nullify Physical Reflect XV")],
[DS(10, "Weather Master I"), DS(25, "EXP Boost I"), DS(50, "Resist Taunt I"), DS(100, "Taunt: Barrier I")],
[DS(10, "Treasure Sensor I"), DS(25, "Potential Boost I"), DS(100, "Potential Up I")],
[DS(5, "Weather Master II"), DS(15, "EXP Boost II"), DS(30, "Resist Taunt II"), DS(100, "Taunt: Barrier II")],
[DS(5, "Treasure Sensor II"), DS(15, "Potential Boost II"), DS(100, "Potential Up II")],
[DS(10, "Brimstone Rain Screen"), DS(20, "Reflect: Physical"), DS(30, "Max HP Boost I"), DS(50, "Resist Flinch I"), DS(100, "Resist Physical Res Down I")],
[DS(10, "Aura Rapid Cooldown I"), DS(20, "HP Rebound I"), DS(30, "Resist Blaze I"), DS(30, "High Danger Surge I"), DS(50, "Danger Surge I"), DS(100, "Max HP Up I")],
[DS(5, "Brimstone Rain Screen"), DS(10, "Reflect: Physical"), DS(15, "Max HP Boost II"), DS(25, "Resist Flinch II"), DS(100, "Resist Physical Res Down II")],
[DS(5, "Aura Rapid Cooldown II"), DS(10, "HP Rebound II"), DS(15, "Resist Blaze II"), DS(15, "High Danger Surge II"), DS(25, "Danger Surge II"), DS(100, "Max HP Up II")],
[DS(10, "Overdrive: Recover HP I"), DS(20, "Melee Draw Surge I"), DS(30, "Artful Execution Surge I"), DS(100, "Melee Attack Up I")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Front Attack Plus I"), DS(30, "Physical Resistance Up I"), DS(30, "Crush Surge I"), DS(100, "Max HP Up I")],
[DS(5, "Overdrive: Recover HP II"), DS(10, "Melee Draw Surge II"), DS(15, "Artful Execution Surge II"), DS(100, "Melee Attack Up II")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Front Attack Plus II"), DS(15, "Physical Resistance Up II"), DS(30, "Crush Surge II"), DS(100, "Max HP Up II")],
[DS(10, "Overdrive: Recover HP I"), DS(20, "Art Draw Surge I"), DS(30, "Overdrive Surge I"), DS(100, "Melee Attack Up I")],
[DS(10, "Secondary CD Reducer I"), DS(20, "Vantage Attack Plus I"), DS(30, "Physical Resistance Up I"), DS(30, "Underdog Surge I"), DS(100, "Max TP Up I")],
[DS(5, "Overdrive: Recover HP II"), DS(10, "Art Draw Surge II"), DS(15, "Overdrive Surge II"), DS(100, "Melee Attack Up II")],
[DS(5, "Secondary CD Reducer II"), DS(10, "Vantage Attack Plus II"), DS(15, "Physical Resistance Up II"), DS(30, "Underdog Surge II"), DS(100, "Max TP Up II")],
[DS(10, "TP Rebound I"), DS(25, "Resist Topple I"), DS(50, "Topple: Barrier I"), DS(100, "Max TP Up I")],
[DS(10, "Evasion Boost I"), DS(25, "Focused Evasion I"), DS(30, "Resistance Reducer I"), DS(30, "Resist Gravity Res Down I"), DS(50, "Resist Stagger I"), DS(100, "Resist Knockback I")],
[DS(5, "TP Rebound II"), DS(15, "Resist Topple II"), DS(30, "Topple: Barrier II"), DS(100, "Max TP Up II")],
[DS(5, "Evasion Boost II"), DS(15, "Focused Evasion II"), DS(20, "Resistance Reducer II"), DS(20, "Resist Gravity Res Down II"), DS(30, "Resist Stagger II"), DS(100, "Resist Knockback II")],
[DS(10, "Weather Master II"), DS(25, "EXP Boost II"), DS(50, "Resist Taunt II"), DS(100, "Taunt: Barrier II")],
[DS(10, "Treasure Sensor II"), DS(25, "Potential Boost II"), DS(100, "Potential Up II")],
[DS(5, "Weather Master IV"), DS(15, "EXP Boost IV"), DS(30, "Resist Taunt IV"), DS(100, "Taunt: Barrier IV")],
[DS(5, "Treasure Sensor IV"), DS(15, "Potential Boost IV"), DS(100, "Potential Up IV")],
[DS(10, "Weather Master IV"), DS(25, "EXP Boost IV"), DS(50, "Resist Taunt IV"), DS(100, "Taunt: Barrier IV")],
[DS(10, "Treasure Sensor IV"), DS(25, "Potential Boost IV"), DS(100, "Potential Up IV")],
[DS(5, "Weather Master VI"), DS(15, "EXP Boost VI"), DS(30, "Resist Taunt VI"), DS(100, "Taunt: Barrier VI")],
[DS(5, "Treasure Sensor VI"), DS(15, "Potential Boost VI"), DS(100, "Potential Up VI")],
[DS(10, "Brimstone Rain Screen"), DS(20, "Reflect: Physical"), DS(30, "Max HP Boost II"), DS(50, "Resist Flinch II"), DS(100, "Resist Physical Res Down II")],
[DS(10, "Aura Rapid Cooldown II"), DS(20, "HP Rebound II"), DS(30, "Resist Blaze II"), DS(30, "High Danger Surge II"), DS(50, "Danger Surge II"), DS(100, "Max HP Up II")],
[DS(5, "Brimstone Rain Screen"), DS(10, "Reflect: Physical"), DS(15, "Max HP Boost IV"), DS(25, "Resist Flinch IV"), DS(100, "Resist Physical Res Down IV")],
[DS(5, "Aura Rapid Cooldown IV"), DS(10, "HP Rebound IV"), DS(15, "Resist Blaze IV"), DS(15, "High Danger Surge IV"), DS(25, "Danger Surge IV"), DS(100, "Max HP Up IV")],
[DS(10, "Brimstone Rain Screen"), DS(20, "Reflect: Physical"), DS(30, "Max HP Boost IV"), DS(50, "Resist Flinch IV"), DS(100, "Resist Physical Res Down IV")],
[DS(10, "Aura Rapid Cooldown IV"), DS(20, "HP Rebound IV"), DS(30, "Resist Blaze IV"), DS(30, "High Danger Surge IV"), DS(50, "Danger Surge IV"), DS(100, "Max HP Up IV")],
[DS(5, "Brimstone Rain Screen"), DS(10, "Reflect: Physical"), DS(15, "Max HP Boost VI"), DS(25, "Resist Flinch VI"), DS(100, "Resist Physical Res Down VI")],
[DS(5, "Aura Rapid Cooldown VI"), DS(10, "HP Rebound VI"), DS(15, "Resist Blaze VI"), DS(15, "High Danger Surge VI"), DS(25, "Danger Surge VI"), DS(100, "Max HP Up VI")],
[DS(10, "Overdrive: Recover HP II"), DS(20, "Melee Draw Surge II"), DS(30, "Artful Execution Surge II"), DS(100, "Melee Attack Up II")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Front Attack Plus II"), DS(30, "Physical Resistance Up II"), DS(30, "Crush Surge II"), DS(100, "Max HP Up II")],
[DS(5, "Overdrive: Recover HP IV"), DS(10, "Melee Draw Surge IV"), DS(15, "Artful Execution Surge IV"), DS(100, "Melee Attack Up IV")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Front Attack Plus IV"), DS(15, "Physical Resistance Up IV"), DS(30, "Crush Surge IV"), DS(100, "Max HP Up IV")],
[DS(10, "Overdrive: Recover HP IV"), DS(20, "Melee Draw Surge IV"), DS(30, "Artful Execution Surge IV"), DS(100, "Melee Attack Up IV")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Front Attack Plus IV"), DS(30, "Physical Resistance Up IV"), DS(30, "Crush Surge IV"), DS(100, "Max HP Up IV")],
[DS(5, "Overdrive: Recover HP VI"), DS(10, "Melee Draw Surge VI"), DS(15, "Artful Execution Surge VI"), DS(100, "Melee Attack Up VI")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Front Attack Plus VI"), DS(15, "Physical Resistance Up VI"), DS(30, "Crush Surge VI"), DS(100, "Max HP Up VI")],
[DS(10, "Overdrive: Recover HP II"), DS(20, "Art Draw Surge II"), DS(30, "Overdrive Surge II"), DS(100, "Melee Attack Up II")],
[DS(10, "Secondary CD Reducer II"), DS(20, "Vantage Attack Plus II"), DS(30, "Physical Resistance Up II"), DS(30, "Underdog Surge II"), DS(100, "Max TP Up II")],
[DS(5, "Overdrive: Recover HP IV"), DS(10, "Art Draw Surge IV"), DS(15, "Overdrive Surge IV"), DS(100, "Melee Attack Up IV")],
[DS(5, "Secondary CD Reducer IV"), DS(10, "Vantage Attack Plus IV"), DS(15, "Physical Resistance Up IV"), DS(30, "Underdog Surge IV"), DS(100, "Max TP Up IV")],
[DS(10, "Overdrive: Recover HP IV"), DS(20, "Art Draw Surge IV"), DS(30, "Overdrive Surge IV"), DS(100, "Melee Attack Up IV")],
[DS(10, "Secondary CD Reducer IV"), DS(20, "Vantage Attack Plus IV"), DS(30, "Physical Resistance Up IV"), DS(30, "Underdog Surge IV"), DS(100, "Max TP Up IV")],
[DS(5, "Overdrive: Recover HP VI"), DS(10, "Art Draw Surge VI"), DS(15, "Overdrive Surge VI"), DS(100, "Melee Attack Up VI")],
[DS(5, "Secondary CD Reducer VI"), DS(10, "Vantage Attack Plus VI"), DS(15, "Physical Resistance Up VI"), DS(30, "Underdog Surge VI"), DS(100, "Max TP Up VI")],
[DS(10, "TP Rebound II"), DS(25, "Resist Topple II"), DS(50, "Topple: Barrier II"), DS(100, "Max TP Up II")],
[DS(10, "Evasion Boost II"), DS(25, "Focused Evasion II"), DS(30, "Resistance Reducer II"), DS(30, "Resist Gravity Res Down II"), DS(50, "Resist Stagger II"), DS(100, "Resist Knockback II")],
[DS(5, "TP Rebound IV"), DS(15, "Resist Topple IV"), DS(30, "Topple: Barrier IV"), DS(100, "Max TP Up IV")],
[DS(5, "Evasion Boost IV"), DS(15, "Focused Evasion IV"), DS(20, "Resistance Reducer IV"), DS(20, "Resist Gravity Res Down IV"), DS(30, "Resist Stagger IV"), DS(100, "Resist Knockback IV")],
[DS(10, "TP Rebound IV"), DS(25, "Resist Topple IV"), DS(50, "Topple: Barrier IV"), DS(100, "Max TP Up IV")],
[DS(10, "Evasion Boost IV"), DS(25, "Focused Evasion IV"), DS(30, "Resistance Reducer IV"), DS(30, "Resist Gravity Res Down IV"), DS(50, "Resist Stagger IV"), DS(100, "Resist Knockback IV")],
[DS(5, "TP Rebound VI"), DS(15, "Resist Topple VI"), DS(30, "Topple: Barrier VI"), DS(100, "Max TP Up VI")],
[DS(5, "Evasion Boost VI"), DS(15, "Focused Evasion VI"), DS(20, "Resistance Reducer VI"), DS(20, "Resist Gravity Res Down VI"), DS(30, "Resist Stagger VI"), DS(100, "Resist Knockback VI")],
[DS(10, "Weather Master VI"), DS(25, "EXP Boost VI"), DS(50, "Resist Taunt VI"), DS(100, "Taunt: Barrier VI")],
[DS(10, "Treasure Sensor VI"), DS(25, "Potential Boost VI"), DS(100, "Potential Up VI")],
[DS(5, "Weather Master VIII"), DS(15, "EXP Boost VIII"), DS(30, "Resist Taunt VIII"), DS(100, "Taunt: Barrier VIII")],
[DS(5, "Treasure Sensor VIII"), DS(15, "Potential Boost VIII"), DS(100, "Potential Up VIII")],
[DS(10, "Weather Master VIII"), DS(25, "EXP Boost VIII"), DS(50, "Resist Taunt VIII"), DS(100, "Taunt: Barrier VIII")],
[DS(10, "Treasure Sensor VIII"), DS(25, "Potential Boost VIII"), DS(100, "Potential Up VIII")],
[DS(5, "Weather Master X"), DS(15, "EXP Boost X"), DS(30, "Resist Taunt X"), DS(100, "Taunt: Barrier X")],
[DS(5, "Treasure Sensor X"), DS(15, "Potential Boost X"), DS(100, "Potential Up X")],
[DS(10, "Brimstone Rain Screen"), DS(20, "Reflect: Physical"), DS(30, "Max HP Boost VI"), DS(50, "Resist Flinch VI"), DS(100, "Resist Physical Res Down VI")],
[DS(10, "Aura Rapid Cooldown VI"), DS(20, "HP Rebound VI"), DS(30, "Resist Blaze VI"), DS(30, "High Danger Surge VI"), DS(50, "Danger Surge VI"), DS(100, "Max HP Up VI")],
[DS(5, "Brimstone Rain Screen"), DS(10, "Reflect: Physical"), DS(15, "Max HP Boost VIII"), DS(25, "Resist Flinch VIII"), DS(100, "Resist Physical Res Down VIII")],
[DS(5, "Aura Rapid Cooldown VIII"), DS(10, "HP Rebound VIII"), DS(15, "Resist Blaze VIII"), DS(15, "High Danger Surge VIII"), DS(25, "Danger Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(10, "Brimstone Rain Screen"), DS(20, "Reflect: Physical"), DS(30, "Max HP Boost VIII"), DS(50, "Resist Flinch VIII"), DS(100, "Resist Physical Res Down VIII")],
[DS(10, "Aura Rapid Cooldown VIII"), DS(20, "HP Rebound VIII"), DS(30, "Resist Blaze VIII"), DS(30, "High Danger Surge VIII"), DS(50, "Danger Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(5, "Brimstone Rain Screen"), DS(10, "Reflect: Physical"), DS(15, "Max HP Boost X"), DS(25, "Resist Flinch X"), DS(100, "Resist Physical Res Down X")],
[DS(5, "Aura Rapid Cooldown X"), DS(10, "HP Rebound X"), DS(15, "Resist Blaze X"), DS(15, "High Danger Surge X"), DS(25, "Danger Surge X"), DS(100, "Max HP Up X")],
[DS(10, "Overdrive: Recover HP VI"), DS(20, "Melee Draw Surge VI"), DS(30, "Artful Execution Surge VI"), DS(100, "Melee Attack Up VI")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Front Attack Plus VI"), DS(30, "Physical Resistance Up VI"), DS(30, "Crush Surge VI"), DS(100, "Max HP Up VI")],
[DS(5, "Overdrive: Recover HP VIII"), DS(10, "Melee Draw Surge VIII"), DS(15, "Artful Execution Surge VIII"), DS(100, "Melee Attack Up VIII")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Front Attack Plus VIII"), DS(15, "Physical Resistance Up VIII"), DS(30, "Crush Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(10, "Overdrive: Recover HP VIII"), DS(20, "Melee Draw Surge VIII"), DS(30, "Artful Execution Surge VIII"), DS(100, "Melee Attack Up VIII")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Front Attack Plus VIII"), DS(30, "Physical Resistance Up VIII"), DS(30, "Crush Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(5, "Overdrive: Recover HP X"), DS(10, "Melee Draw Surge X"), DS(15, "Artful Execution Surge X"), DS(100, "Melee Attack Up X")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Front Attack Plus X"), DS(15, "Physical Resistance Up X"), DS(30, "Crush Surge X"), DS(100, "Max HP Up X")],
[DS(10, "Overdrive: Recover HP VI"), DS(20, "Art Draw Surge VI"), DS(30, "Overdrive Surge VI"), DS(100, "Melee Attack Up VI")],
[DS(10, "Secondary CD Reducer VI"), DS(20, "Vantage Attack Plus VI"), DS(30, "Physical Resistance Up VI"), DS(30, "Underdog Surge VI"), DS(100, "Max TP Up VI")],
[DS(5, "Overdrive: Recover HP VIII"), DS(10, "Art Draw Surge VIII"), DS(15, "Overdrive Surge VIII"), DS(100, "Melee Attack Up VIII")],
[DS(5, "Secondary CD Reducer VIII"), DS(10, "Vantage Attack Plus VIII"), DS(15, "Physical Resistance Up VIII"), DS(30, "Underdog Surge VIII"), DS(100, "Max TP Up VIII")],
[DS(10, "Overdrive: Recover HP VIII"), DS(20, "Art Draw Surge VIII"), DS(30, "Overdrive Surge VIII"), DS(100, "Melee Attack Up VIII")],
[DS(10, "Secondary CD Reducer VIII"), DS(20, "Vantage Attack Plus VIII"), DS(30, "Physical Resistance Up VIII"), DS(30, "Underdog Surge VIII"), DS(100, "Max TP Up VIII")],
[DS(5, "Overdrive: Recover HP X"), DS(10, "Art Draw Surge X"), DS(15, "Overdrive Surge X"), DS(100, "Melee Attack Up X")],
[DS(5, "Secondary CD Reducer X"), DS(10, "Vantage Attack Plus X"), DS(15, "Physical Resistance Up X"), DS(30, "Underdog Surge X"), DS(100, "Max TP Up X")],
[DS(10, "TP Rebound VI"), DS(25, "Resist Topple VI"), DS(50, "Topple: Barrier VI"), DS(100, "Max TP Up VI")],
[DS(10, "Evasion Boost VI"), DS(25, "Focused Evasion VI"), DS(30, "Resistance Reducer VI"), DS(30, "Resist Gravity Res Down VI"), DS(50, "Resist Stagger VI"), DS(100, "Resist Knockback VI")],
[DS(5, "TP Rebound VIII"), DS(15, "Resist Topple VIII"), DS(30, "Topple: Barrier VIII"), DS(100, "Max TP Up VIII")],
[DS(5, "Evasion Boost VIII"), DS(15, "Focused Evasion VIII"), DS(20, "Resistance Reducer VIII"), DS(20, "Resist Gravity Res Down VIII"), DS(30, "Resist Stagger VIII"), DS(100, "Resist Knockback VIII")],
[DS(10, "TP Rebound VIII"), DS(25, "Resist Topple VIII"), DS(50, "Topple: Barrier VIII"), DS(100, "Max TP Up VIII")],
[DS(10, "Evasion Boost VIII"), DS(25, "Focused Evasion VIII"), DS(30, "Resistance Reducer VIII"), DS(30, "Resist Gravity Res Down VIII"), DS(50, "Resist Stagger VIII"), DS(100, "Resist Knockback VIII")],
[DS(5, "TP Rebound X"), DS(15, "Resist Topple X"), DS(30, "Topple: Barrier X"), DS(100, "Max TP Up X")],
[DS(5, "Evasion Boost X"), DS(15, "Focused Evasion X"), DS(20, "Resistance Reducer X"), DS(20, "Resist Gravity Res Down X"), DS(30, "Resist Stagger X"), DS(100, "Resist Knockback X")],
[DS(10, "Weather Master X"), DS(25, "EXP Boost X"), DS(50, "Resist Taunt X"), DS(100, "Taunt: Barrier X")],
[DS(10, "Treasure Sensor X"), DS(25, "Potential Boost X"), DS(100, "Potential Up X")],
[DS(5, "Weather Master XII"), DS(15, "EXP Boost XII"), DS(30, "Resist Taunt XII"), DS(100, "Taunt: Barrier XII")],
[DS(5, "Treasure Sensor XII"), DS(15, "Potential Boost XII"), DS(100, "Potential Up XII")],
[DS(5, "Weather Master XII"), DS(15, "EXP Boost XII"), DS(30, "Resist Taunt XII"), DS(100, "Taunt: Barrier XII")],
[DS(5, "Treasure Sensor XII"), DS(15, "Potential Boost XII"), DS(100, "Potential Up XII")],
[DS(5, "Weather Master XIV"), DS(15, "EXP Boost XIV"), DS(30, "Resist Taunt XIV"), DS(100, "Taunt: Barrier XIV")],
[DS(5, "Treasure Sensor XIV"), DS(15, "Potential Boost XIV"), DS(100, "Potential Up XIV")],
[DS(10, "Brimstone Rain Screen"), DS(20, "Reflect: Physical"), DS(30, "Max HP Boost X"), DS(50, "Resist Flinch X"), DS(100, "Resist Physical Res Down X")],
[DS(10, "Aura Rapid Cooldown X"), DS(20, "HP Rebound X"), DS(30, "Resist Blaze X"), DS(30, "High Danger Surge X"), DS(50, "Danger Surge X"), DS(100, "Max HP Up X")],
[DS(5, "Brimstone Rain Screen"), DS(10, "Reflect: Physical"), DS(15, "Max HP Boost XII"), DS(25, "Resist Flinch XII"), DS(100, "Resist Physical Res Down XII")],
[DS(5, "Aura Rapid Cooldown XII"), DS(10, "HP Rebound XII"), DS(15, "Resist Blaze XII"), DS(15, "High Danger Surge XII"), DS(25, "Danger Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "Brimstone Rain Screen"), DS(10, "Reflect: Physical"), DS(15, "Max HP Boost XII"), DS(25, "Resist Flinch XII"), DS(100, "Resist Physical Res Down XII")],
[DS(5, "Aura Rapid Cooldown XII"), DS(10, "HP Rebound XII"), DS(15, "Resist Blaze XII"), DS(15, "High Danger Surge XII"), DS(25, "Danger Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "Brimstone Rain Screen"), DS(10, "Reflect: Physical"), DS(15, "Max HP Boost XIV"), DS(25, "Resist Flinch XIV"), DS(100, "Resist Physical Res Down XIV")],
[DS(5, "Aura Rapid Cooldown XIV"), DS(10, "HP Rebound XIV"), DS(15, "Resist Blaze XIV"), DS(15, "High Danger Surge XIV"), DS(25, "Danger Surge XIV"), DS(100, "Max HP Up XIV")],
[DS(10, "Overdrive: Recover HP X"), DS(20, "Melee Draw Surge X"), DS(30, "Artful Execution Surge X"), DS(100, "Melee Attack Up X")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Front Attack Plus X"), DS(30, "Physical Resistance Up X"), DS(30, "Crush Surge X"), DS(100, "Max HP Up X")],
[DS(5, "Overdrive: Recover HP XII"), DS(10, "Melee Draw Surge XII"), DS(15, "Artful Execution Surge XII"), DS(100, "Melee Attack Up XII")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Front Attack Plus XII"), DS(15, "Physical Resistance Up XII"), DS(30, "Crush Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "Overdrive: Recover HP XII"), DS(10, "Melee Draw Surge XII"), DS(15, "Artful Execution Surge XII"), DS(100, "Melee Attack Up XII")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Front Attack Plus XII"), DS(15, "Physical Resistance Up XII"), DS(30, "Crush Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "Overdrive: Recover HP XIV"), DS(10, "Melee Draw Surge XIV"), DS(15, "Artful Execution Surge XIV"), DS(100, "Melee Attack Up XIV")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Front Attack Plus XIV"), DS(15, "Physical Resistance Up XIV"), DS(30, "Crush Surge XIV"), DS(100, "Max HP Up XIV")],
[DS(10, "Overdrive: Recover HP X"), DS(20, "Art Draw Surge X"), DS(30, "Overdrive Surge X"), DS(100, "Melee Attack Up X")],
[DS(10, "Secondary CD Reducer X"), DS(20, "Vantage Attack Plus X"), DS(30, "Physical Resistance Up X"), DS(30, "Underdog Surge X"), DS(100, "Max TP Up X")],
[DS(5, "Overdrive: Recover HP XII"), DS(10, "Art Draw Surge XII"), DS(15, "Overdrive Surge XII"), DS(100, "Melee Attack Up XII")],
[DS(5, "Secondary CD Reducer XII"), DS(10, "Vantage Attack Plus XII"), DS(15, "Physical Resistance Up XII"), DS(30, "Underdog Surge XII"), DS(100, "Max TP Up XII")],
[DS(5, "Overdrive: Recover HP XII"), DS(10, "Art Draw Surge XII"), DS(15, "Overdrive Surge XII"), DS(100, "Melee Attack Up XII")],
[DS(5, "Secondary CD Reducer XII"), DS(10, "Vantage Attack Plus XII"), DS(15, "Physical Resistance Up XII"), DS(30, "Underdog Surge XII"), DS(100, "Max TP Up XII")],
[DS(5, "Overdrive: Recover HP XIV"), DS(10, "Art Draw Surge XIV"), DS(15, "Overdrive Surge XIV"), DS(100, "Melee Attack Up XIV")],
[DS(5, "Secondary CD Reducer XIV"), DS(10, "Vantage Attack Plus XIV"), DS(15, "Physical Resistance Up XIV"), DS(30, "Underdog Surge XIV"), DS(100, "Max TP Up XIV")],
[DS(10, "TP Rebound X"), DS(25, "Resist Topple X"), DS(50, "Topple: Barrier X"), DS(100, "Max TP Up X")],
[DS(10, "Evasion Boost X"), DS(25, "Focused Evasion X"), DS(30, "Resistance Reducer X"), DS(30, "Resist Gravity Res Down X"), DS(50, "Resist Stagger X"), DS(100, "Resist Knockback X")],
[DS(5, "TP Rebound XII"), DS(15, "Resist Topple XII"), DS(30, "Topple: Barrier XII"), DS(100, "Max TP Up XII")],
[DS(5, "Evasion Boost XII"), DS(15, "Focused Evasion XII"), DS(20, "Resistance Reducer XII"), DS(20, "Resist Gravity Res Down XII"), DS(30, "Resist Stagger XII"), DS(100, "Resist Knockback XII")],
[DS(5, "TP Rebound XII"), DS(15, "Resist Topple XII"), DS(30, "Topple: Barrier XII"), DS(100, "Max TP Up XII")],
[DS(5, "Evasion Boost XII"), DS(15, "Focused Evasion XII"), DS(20, "Resistance Reducer XII"), DS(20, "Resist Gravity Res Down XII"), DS(30, "Resist Stagger XII"), DS(100, "Resist Knockback XII")],
[DS(5, "TP Rebound XIV"), DS(15, "Resist Topple XIV"), DS(30, "Topple: Barrier XIV"), DS(100, "Max TP Up XIV")],
[DS(5, "Evasion Boost XIV"), DS(15, "Focused Evasion XIV"), DS(20, "Resistance Reducer XIV"), DS(20, "Resist Gravity Res Down XIV"), DS(30, "Resist Stagger XIV"), DS(100, "Resist Knockback XIV")],
[DS(10, "Weather Master I"), DS(25, "EXP Boost I"), DS(50, "Resist Stun I"), DS(100, "Stun: Decoy I")],
[DS(10, "Treasure Sensor I"), DS(25, "Potential Boost I"), DS(100, "Potential Up I")],
[DS(5, "Weather Master II"), DS(15, "EXP Boost II"), DS(30, "Resist Stun II"), DS(100, "Stun: Decoy II")],
[DS(5, "Treasure Sensor II"), DS(15, "Potential Boost II"), DS(100, "Potential Up II")],
[DS(10, "EM Storm Screen"), DS(20, "Reflect: Beam"), DS(30, "Max HP Boost I"), DS(50, "Resist Flinch I"), DS(100, "Resist Beam Res Down I")],
[DS(10, "Extend Aura I"), DS(20, "HP Rebound I"), DS(30, "Resist Shock I"), DS(30, "Incapacitation Surge I"), DS(50, "Danger Surge I"), DS(100, "Max HP Up I")],
[DS(5, "EM Storm Screen"), DS(10, "Reflect: Beam"), DS(15, "Max HP Boost II"), DS(25, "Resist Flinch II"), DS(100, "Resist Beam Res Down II")],
[DS(5, "Extend Aura II"), DS(10, "HP Rebound II"), DS(15, "Resist Shock II"), DS(15, "Incapacitation Surge II"), DS(25, "Danger Surge II"), DS(100, "Max HP Up II")],
[DS(10, "Overdrive: Gain TP I"), DS(20, "Ranged Draw Surge I"), DS(30, "Artful Execution Surge I"), DS(100, "Ranged Attack Up I")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Side Attack Plus I"), DS(30, "Beam Resistance Up I"), DS(30, "Critical Surge I"), DS(100, "Max HP Up I")],
[DS(5, "Overdrive: Gain TP II"), DS(10, "Ranged Draw Surge II"), DS(15, "Artful Execution Surge II"), DS(100, "Ranged Attack Up II")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus II"), DS(15, "Beam Resistance Up II"), DS(30, "Critical Surge II"), DS(100, "Max HP Up II")],
[DS(10, "Overdrive: Gain TP I"), DS(20, "Art Draw Surge I"), DS(30, "Overdrive Surge I"), DS(100, "Ranged Attack Up I")],
[DS(10, "Secondary CD Reducer I"), DS(20, "Vantage Attack Plus I"), DS(30, "Beam Resistance Up I"), DS(30, "Aura Surge I"), DS(100, "Max TP Up I")],
[DS(5, "Overdrive: Gain TP II"), DS(10, "Art Draw Surge II"), DS(15, "Overdrive Surge II"), DS(100, "Ranged Attack Up II")],
[DS(5, "Secondary CD Reducer II"), DS(10, "Vantage Attack Plus II"), DS(15, "Beam Resistance Up II"), DS(30, "Aura Surge II"), DS(100, "Max TP Up II")],
[DS(10, "TP Rebound I"), DS(25, "Resist Stagger I"), DS(50, "Topple: Decoy I"), DS(100, "Max TP Up I")],
[DS(10, "Evasion Boost I"), DS(25, "Visual Cloaking I"), DS(30, "Untouchable Dash I"), DS(30, "Resist Topple I"), DS(50, "Resist Gravity Res Down I"), DS(100, "Resist Launch I")],
[DS(5, "TP Rebound II"), DS(15, "Resist Stagger II"), DS(30, "Topple: Decoy II"), DS(100, "Max TP Up II")],
[DS(5, "Evasion Boost II"), DS(15, "Visual Cloaking II"), DS(20, "Untouchable Dash II"), DS(20, "Resist Topple II"), DS(30, "Resist Gravity Res Down II"), DS(100, "Resist Launch II")],
[DS(10, "Weather Master II"), DS(25, "EXP Boost II"), DS(50, "Resist Stun II"), DS(100, "Stun: Decoy II")],
[DS(10, "Treasure Sensor II"), DS(25, "Potential Boost II"), DS(100, "Potential Up II")],
[DS(5, "Weather Master IV"), DS(15, "EXP Boost IV"), DS(30, "Resist Stun IV"), DS(100, "Stun: Decoy IV")],
[DS(5, "Treasure Sensor IV"), DS(15, "Potential Boost IV"), DS(100, "Potential Up IV")],
[DS(10, "Weather Master IV"), DS(25, "EXP Boost IV"), DS(50, "Resist Stun IV"), DS(100, "Stun: Decoy IV")],
[DS(10, "Treasure Sensor IV"), DS(25, "Potential Boost IV"), DS(100, "Potential Up IV")],
[DS(5, "Weather Master VI"), DS(15, "EXP Boost VI"), DS(30, "Resist Stun VI"), DS(100, "Stun: Decoy VI")],
[DS(5, "Treasure Sensor VI"), DS(15, "Potential Boost VI"), DS(100, "Potential Up VI")],
[DS(10, "EM Storm Screen"), DS(20, "Reflect: Beam"), DS(30, "Max HP Boost II"), DS(50, "Resist Flinch II"), DS(100, "Resist Beam Res Down II")],
[DS(10, "Extend Aura II"), DS(20, "HP Rebound II"), DS(30, "Resist Shock II"), DS(30, "Incapacitation Surge II"), DS(50, "Danger Surge II"), DS(100, "Max HP Up II")],
[DS(5, "EM Storm Screen"), DS(10, "Reflect: Beam"), DS(15, "Max HP Boost IV"), DS(25, "Resist Flinch IV"), DS(100, "Resist Beam Res Down IV")],
[DS(5, "Extend Aura IV"), DS(10, "HP Rebound IV"), DS(15, "Resist Shock IV"), DS(15, "Incapacitation Surge IV"), DS(25, "Danger Surge IV"), DS(100, "Max HP Up IV")],
[DS(10, "EM Storm Screen"), DS(20, "Reflect: Beam"), DS(30, "Max HP Boost IV"), DS(50, "Resist Flinch IV"), DS(100, "Resist Beam Res Down IV")],
[DS(10, "Extend Aura IV"), DS(20, "HP Rebound IV"), DS(30, "Resist Shock IV"), DS(30, "Incapacitation Surge IV"), DS(50, "Danger Surge IV"), DS(100, "Max HP Up IV")],
[DS(5, "EM Storm Screen"), DS(10, "Reflect: Beam"), DS(15, "Max HP Boost VI"), DS(25, "Resist Flinch VI"), DS(100, "Resist Beam Res Down VI")],
[DS(5, "Extend Aura VI"), DS(10, "HP Rebound VI"), DS(15, "Resist Shock VI"), DS(15, "Incapacitation Surge VI"), DS(25, "Danger Surge VI"), DS(100, "Max HP Up VI")],
[DS(10, "Overdrive: Gain TP II"), DS(20, "Ranged Draw Surge II"), DS(30, "Artful Execution Surge II"), DS(100, "Ranged Attack Up II")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Side Attack Plus II"), DS(30, "Beam Resistance Up II"), DS(30, "Critical Surge II"), DS(100, "Max HP Up II")],
[DS(5, "Overdrive: Gain TP IV"), DS(10, "Ranged Draw Surge IV"), DS(15, "Artful Execution Surge IV"), DS(100, "Ranged Attack Up IV")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus IV"), DS(15, "Beam Resistance Up IV"), DS(30, "Critical Surge IV"), DS(100, "Max HP Up IV")],
[DS(10, "Overdrive: Gain TP IV"), DS(20, "Ranged Draw Surge IV"), DS(30, "Artful Execution Surge IV"), DS(100, "Ranged Attack Up IV")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Side Attack Plus IV"), DS(30, "Beam Resistance Up IV"), DS(30, "Critical Surge IV"), DS(100, "Max HP Up IV")],
[DS(5, "Overdrive: Gain TP VI"), DS(10, "Ranged Draw Surge VI"), DS(15, "Artful Execution Surge VI"), DS(100, "Ranged Attack Up VI")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus VI"), DS(15, "Beam Resistance Up VI"), DS(30, "Critical Surge VI"), DS(100, "Max HP Up VI")],
[DS(10, "Overdrive: Gain TP II"), DS(20, "Art Draw Surge II"), DS(30, "Overdrive Surge II"), DS(100, "Ranged Attack Up II")],
[DS(10, "Secondary CD Reducer II"), DS(20, "Vantage Attack Plus II"), DS(30, "Beam Resistance Up II"), DS(30, "Aura Surge II"), DS(100, "Max TP Up II")],
[DS(5, "Overdrive: Gain TP IV"), DS(10, "Art Draw Surge IV"), DS(15, "Overdrive Surge IV"), DS(100, "Ranged Attack Up IV")],
[DS(5, "Secondary CD Reducer IV"), DS(10, "Vantage Attack Plus IV"), DS(15, "Beam Resistance Up IV"), DS(30, "Aura Surge IV"), DS(100, "Max TP Up IV")],
[DS(10, "Overdrive: Gain TP IV"), DS(20, "Art Draw Surge IV"), DS(30, "Overdrive Surge IV"), DS(100, "Ranged Attack Up IV")],
[DS(10, "Secondary CD Reducer IV"), DS(20, "Vantage Attack Plus IV"), DS(30, "Beam Resistance Up IV"), DS(30, "Aura Surge IV"), DS(100, "Max TP Up IV")],
[DS(5, "Overdrive: Gain TP VI"), DS(10, "Art Draw Surge VI"), DS(15, "Overdrive Surge VI"), DS(100, "Ranged Attack Up VI")],
[DS(5, "Secondary CD Reducer VI"), DS(10, "Vantage Attack Plus VI"), DS(15, "Beam Resistance Up VI"), DS(30, "Aura Surge VI"), DS(100, "Max TP Up VI")],
[DS(10, "TP Rebound II"), DS(25, "Resist Stagger II"), DS(50, "Topple: Decoy II"), DS(100, "Max TP Up II")],
[DS(10, "Evasion Boost II"), DS(25, "Visual Cloaking II"), DS(30, "Untouchable Dash II"), DS(30, "Resist Topple II"), DS(50, "Resist Gravity Res Down II"), DS(100, "Resist Launch II")],
[DS(5, "TP Rebound IV"), DS(15, "Resist Stagger IV"), DS(30, "Topple: Decoy IV"), DS(100, "Max TP Up IV")],
[DS(5, "Evasion Boost IV"), DS(15, "Visual Cloaking IV"), DS(20, "Untouchable Dash IV"), DS(20, "Resist Topple IV"), DS(30, "Resist Gravity Res Down IV"), DS(100, "Resist Launch IV")],
[DS(10, "TP Rebound IV"), DS(25, "Resist Stagger IV"), DS(50, "Topple: Decoy IV"), DS(100, "Max TP Up IV")],
[DS(10, "Evasion Boost IV"), DS(25, "Visual Cloaking IV"), DS(30, "Untouchable Dash IV"), DS(30, "Resist Topple IV"), DS(50, "Resist Gravity Res Down IV"), DS(100, "Resist Launch IV")],
[DS(5, "TP Rebound VI"), DS(15, "Resist Stagger VI"), DS(30, "Topple: Decoy VI"), DS(100, "Max TP Up VI")],
[DS(5, "Evasion Boost VI"), DS(15, "Visual Cloaking VI"), DS(20, "Untouchable Dash VI"), DS(20, "Resist Topple VI"), DS(30, "Resist Gravity Res Down VI"), DS(100, "Resist Launch VI")],
[DS(10, "Weather Master VI"), DS(25, "EXP Boost VI"), DS(50, "Resist Stun VI"), DS(100, "Stun: Decoy VI")],
[DS(10, "Treasure Sensor VI"), DS(25, "Potential Boost VI"), DS(100, "Potential Up VI")],
[DS(5, "Weather Master VIII"), DS(15, "EXP Boost VIII"), DS(50, "Resist Stun VIII"), DS(100, "Stun: Decoy VIII")],
[DS(5, "Treasure Sensor VIII"), DS(15, "Potential Boost VIII"), DS(100, "Potential Up VIII")],
[DS(10, "Weather Master VIII"), DS(25, "EXP Boost VIII"), DS(50, "Resist Stun VIII"), DS(100, "Stun: Decoy VIII")],
[DS(10, "Treasure Sensor VIII"), DS(25, "Potential Boost VIII"), DS(100, "Potential Up VIII")],
[DS(5, "Weather Master X"), DS(15, "EXP Boost X"), DS(50, "Resist Stun X"), DS(100, "Stun: Decoy X")],
[DS(5, "Treasure Sensor X"), DS(15, "Potential Boost X"), DS(100, "Potential Up X")],
[DS(10, "EM Storm Screen"), DS(20, "Reflect: Beam"), DS(30, "Max HP Boost VI"), DS(50, "Resist Flinch VI"), DS(100, "Resist Beam Res Down VI")],
[DS(10, "Extend Aura VI"), DS(20, "HP Rebound VI"), DS(30, "Resist Shock VI"), DS(30, "Incapacitation Surge VI"), DS(50, "Danger Surge VI"), DS(100, "Max HP Up VI")],
[DS(5, "EM Storm Screen"), DS(10, "Reflect: Beam"), DS(30, "Max HP Boost VIII"), DS(50, "Resist Flinch VIII"), DS(100, "Resist Beam Res Down VIII")],
[DS(5, "Extend Aura VIII"), DS(10, "HP Rebound VIII"), DS(30, "Resist Shock VIII"), DS(30, "Incapacitation Surge VIII"), DS(50, "Danger Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(10, "EM Storm Screen"), DS(20, "Reflect: Beam"), DS(30, "Max HP Boost VIII"), DS(50, "Resist Flinch VIII"), DS(100, "Resist Beam Res Down VIII")],
[DS(10, "Extend Aura VIII"), DS(20, "HP Rebound VIII"), DS(30, "Resist Shock VIII"), DS(30, "Incapacitation Surge VIII"), DS(50, "Danger Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(5, "EM Storm Screen"), DS(10, "Reflect: Beam"), DS(30, "Max HP Boost X"), DS(50, "Resist Flinch X"), DS(100, "Resist Beam Res Down X")],
[DS(5, "Extend Aura X"), DS(10, "HP Rebound X"), DS(30, "Resist Shock X"), DS(30, "Incapacitation Surge X"), DS(50, "Danger Surge X"), DS(100, "Max HP Up X")],
[DS(10, "Overdrive: Gain TP VI"), DS(20, "Ranged Draw Surge VI"), DS(30, "Artful Execution Surge VI"), DS(100, "Ranged Attack Up VI")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Side Attack Plus VI"), DS(30, "Beam Resistance Up VI"), DS(30, "Critical Surge VI"), DS(100, "Max HP Up VI")],
[DS(5, "Overdrive: Gain TP VIII"), DS(10, "Ranged Draw Surge VIII"), DS(30, "Artful Execution Surge VIII"), DS(100, "Ranged Attack Up VIII")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus VIII"), DS(30, "Beam Resistance Up VIII"), DS(30, "Critical Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(10, "Overdrive: Gain TP VIII"), DS(20, "Ranged Draw Surge VIII"), DS(30, "Artful Execution Surge VIII"), DS(100, "Ranged Attack Up VIII")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Side Attack Plus VIII"), DS(30, "Beam Resistance Up VIII"), DS(30, "Critical Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(5, "Overdrive: Gain TP X"), DS(10, "Ranged Draw Surge X"), DS(30, "Artful Execution Surge X"), DS(100, "Ranged Attack Up X")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus X"), DS(30, "Beam Resistance Up X"), DS(30, "Critical Surge X"), DS(100, "Max HP Up X")],
[DS(10, "Overdrive: Gain TP VI"), DS(20, "Art Draw Surge VI"), DS(30, "Overdrive Surge VI"), DS(100, "Ranged Attack Up VI")],
[DS(10, "Secondary CD Reducer VI"), DS(20, "Vantage Attack Plus VI"), DS(30, "Beam Resistance Up VI"), DS(30, "Aura Surge VI"), DS(100, "Max TP Up VI")],
[DS(5, "Overdrive: Gain TP VIII"), DS(10, "Art Draw Surge VIII"), DS(30, "Overdrive Surge VIII"), DS(100, "Ranged Attack Up VIII")],
[DS(5, "Secondary CD Reducer VIII"), DS(10, "Vantage Attack Plus VIII"), DS(30, "Beam Resistance Up VIII"), DS(30, "Aura Surge VIII"), DS(100, "Max TP Up VIII")],
[DS(10, "Overdrive: Gain TP VIII"), DS(20, "Art Draw Surge VIII"), DS(30, "Overdrive Surge VIII"), DS(100, "Ranged Attack Up VIII")],
[DS(10, "Secondary CD Reducer VIII"), DS(20, "Vantage Attack Plus VIII"), DS(30, "Beam Resistance Up VIII"), DS(30, "Aura Surge VIII"), DS(100, "Max TP Up VIII")],
[DS(5, "Overdrive: Gain TP X"), DS(10, "Art Draw Surge X"), DS(30, "Overdrive Surge X"), DS(100, "Ranged Attack Up X")],
[DS(5, "Secondary CD Reducer X"), DS(10, "Vantage Attack Plus X"), DS(30, "Beam Resistance Up X"), DS(30, "Aura Surge X"), DS(100, "Max TP Up X")],
[DS(10, "TP Rebound VI"), DS(25, "Resist Stagger VI"), DS(50, "Topple: Decoy VI"), DS(100, "Max TP Up VI")],
[DS(10, "Evasion Boost VI"), DS(25, "Visual Cloaking VI"), DS(30, "Untouchable Dash VI"), DS(30, "Resist Topple VI"), DS(50, "Resist Gravity Res Down VI"), DS(100, "Resist Launch VI")],
[DS(5, "TP Rebound VIII"), DS(15, "Resist Stagger VIII"), DS(50, "Topple: Decoy VIII"), DS(100, "Max TP Up VIII")],
[DS(5, "Evasion Boost VIII"), DS(15, "Visual Cloaking VIII"), DS(30, "Untouchable Dash VIII"), DS(30, "Resist Topple VIII"), DS(50, "Resist Gravity Res Down VIII"), DS(100, "Resist Launch VIII")],
[DS(10, "TP Rebound VIII"), DS(25, "Resist Stagger VIII"), DS(50, "Topple: Decoy VIII"), DS(100, "Max TP Up VIII")],
[DS(10, "Evasion Boost VIII"), DS(25, "Visual Cloaking VIII"), DS(30, "Untouchable Dash VIII"), DS(30, "Resist Topple VIII"), DS(50, "Resist Gravity Res Down VIII"), DS(100, "Resist Launch VIII")],
[DS(5, "TP Rebound X"), DS(15, "Resist Stagger X"), DS(50, "Topple: Decoy X"), DS(100, "Max TP Up X")],
[DS(5, "Evasion Boost X"), DS(15, "Visual Cloaking X"), DS(30, "Untouchable Dash X"), DS(30, "Resist Topple X"), DS(50, "Resist Gravity Res Down X"), DS(100, "Resist Launch X")],
[DS(10, "Weather Master X"), DS(25, "EXP Boost X"), DS(50, "Resist Stun X"), DS(100, "Stun: Decoy X")],
[DS(10, "Treasure Sensor X"), DS(25, "Potential Boost X"), DS(100, "Potential Up X")],
[DS(5, "Weather Master XII"), DS(15, "EXP Boost XII"), DS(30, "Resist Stun XII"), DS(100, "Stun: Decoy XII")],
[DS(5, "Treasure Sensor XII"), DS(15, "Potential Boost XII"), DS(100, "Potential Up XII")],
[DS(5, "Weather Master XII"), DS(15, "EXP Boost XII"), DS(30, "Resist Stun XII"), DS(100, "Stun: Decoy XII")],
[DS(5, "Treasure Sensor XII"), DS(15, "Potential Boost XII"), DS(100, "Potential Up XII")],
[DS(5, "Weather Master XIV"), DS(15, "EXP Boost XIV"), DS(30, "Resist Stun XIV"), DS(100, "Stun: Decoy XIV")],
[DS(5, "Treasure Sensor XIV"), DS(15, "Potential Boost XIV"), DS(100, "Potential Up XIV")],
[DS(10, "EM Storm Screen"), DS(20, "Reflect: Beam"), DS(30, "Max HP Boost X"), DS(50, "Resist Flinch X"), DS(100, "Resist Beam Res Down X")],
[DS(10, "Extend Aura X"), DS(20, "HP Rebound X"), DS(30, "Resist Shock X"), DS(30, "Incapacitation Surge X"), DS(50, "Danger Surge X"), DS(100, "Max HP Up X")],
[DS(5, "EM Storm Screen"), DS(10, "Reflect: Beam"), DS(15, "Max HP Boost XII"), DS(25, "Resist Flinch XII"), DS(100, "Resist Beam Res Down XII")],
[DS(5, "Extend Aura XII"), DS(10, "HP Rebound XII"), DS(15, "Resist Shock XII"), DS(15, "Incapacitation Surge XII"), DS(25, "Danger Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "EM Storm Screen"), DS(10, "Reflect: Beam"), DS(15, "Max HP Boost XII"), DS(25, "Resist Flinch XII"), DS(100, "Resist Beam Res Down XII")],
[DS(5, "Extend Aura XII"), DS(10, "HP Rebound XII"), DS(15, "Resist Shock XII"), DS(15, "Incapacitation Surge XII"), DS(25, "Danger Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "EM Storm Screen"), DS(10, "Reflect: Beam"), DS(15, "Max HP Boost XIV"), DS(25, "Resist Flinch XIV"), DS(100, "Resist Beam Res Down XIV")],
[DS(5, "Extend Aura XIV"), DS(10, "HP Rebound XIV"), DS(15, "Resist Shock XIV"), DS(15, "Incapacitation Surge XIV"), DS(25, "Danger Surge XIV"), DS(100, "Max HP Up XIV")],
[DS(10, "Overdrive: Gain TP X"), DS(20, "Ranged Draw Surge X"), DS(30, "Artful Execution Surge X"), DS(100, "Ranged Attack Up X")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Side Attack Plus X"), DS(30, "Beam Resistance Up X"), DS(30, "Critical Surge X"), DS(100, "Max HP Up X")],
[DS(5, "Overdrive: Gain TP XII"), DS(10, "Ranged Draw Surge XII"), DS(15, "Artful Execution Surge XII"), DS(100, "Ranged Attack Up XII")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus XII"), DS(15, "Beam Resistance Up XII"), DS(30, "Critical Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "Overdrive: Gain TP XII"), DS(10, "Ranged Draw Surge XII"), DS(15, "Artful Execution Surge XII"), DS(100, "Ranged Attack Up XII")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus XII"), DS(15, "Beam Resistance Up XII"), DS(30, "Critical Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "Overdrive: Gain TP XIV"), DS(10, "Ranged Draw Surge XIV"), DS(15, "Artful Execution Surge XIV"), DS(100, "Ranged Attack Up XIV")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus XIV"), DS(15, "Beam Resistance Up XIV"), DS(30, "Critical Surge XIV"), DS(100, "Max HP Up XIV")],
[DS(10, "Overdrive: Gain TP X"), DS(20, "Art Draw Surge X"), DS(30, "Overdrive Surge X"), DS(100, "Ranged Attack Up X")],
[DS(10, "Secondary CD Reducer X"), DS(20, "Vantage Attack Plus X"), DS(30, "Beam Resistance Up X"), DS(30, "Aura Surge X"), DS(100, "Max TP Up X")],
[DS(5, "Overdrive: Gain TP XII"), DS(10, "Art Draw Surge XII"), DS(15, "Overdrive Surge XII"), DS(100, "Ranged Attack Up XII")],
[DS(5, "Secondary CD Reducer XII"), DS(10, "Vantage Attack Plus XII"), DS(15, "Beam Resistance Up XII"), DS(30, "Aura Surge XII"), DS(100, "Max TP Up XII")],
[DS(5, "Overdrive: Gain TP XII"), DS(10, "Art Draw Surge XII"), DS(15, "Overdrive Surge XII"), DS(100, "Ranged Attack Up XII")],
[DS(5, "Secondary CD Reducer XII"), DS(10, "Vantage Attack Plus XII"), DS(15, "Beam Resistance Up XII"), DS(30, "Aura Surge XII"), DS(100, "Max TP Up XII")],
[DS(5, "Overdrive: Gain TP XIV"), DS(10, "Art Draw Surge XIV"), DS(15, "Overdrive Surge XIV"), DS(100, "Ranged Attack Up XIV")],
[DS(5, "Secondary CD Reducer XIV"), DS(10, "Vantage Attack Plus XIV"), DS(15, "Beam Resistance Up XIV"), DS(30, "Aura Surge XIV"), DS(100, "Max TP Up XIV")],
[DS(10, "TP Rebound X"), DS(25, "Resist Stagger X"), DS(50, "Topple: Decoy X"), DS(100, "Max TP Up X")],
[DS(10, "Evasion Boost X"), DS(25, "Visual Cloaking X"), DS(30, "Untouchable Dash X"), DS(30, "Resist Topple X"), DS(50, "Resist Gravity Res Down X"), DS(100, "Resist Launch X")],
[DS(5, "TP Rebound XII"), DS(15, "Resist Stagger XII"), DS(30, "Topple: Decoy XII"), DS(100, "Max TP Up XII")],
[DS(5, "Evasion Boost XII"), DS(15, "Visual Cloaking XII"), DS(20, "Untouchable Dash XII"), DS(20, "Resist Topple XII"), DS(30, "Resist Gravity Res Down XII"), DS(100, "Resist Launch XII")],
[DS(5, "TP Rebound XII"), DS(15, "Resist Stagger XII"), DS(30, "Topple: Decoy XII"), DS(100, "Max TP Up XII")],
[DS(5, "Evasion Boost XII"), DS(15, "Visual Cloaking XII"), DS(20, "Untouchable Dash XII"), DS(20, "Resist Topple XII"), DS(30, "Resist Gravity Res Down XII"), DS(100, "Resist Launch XII")],
[DS(5, "TP Rebound XIV"), DS(15, "Resist Stagger XIV"), DS(30, "Topple: Decoy XIV"), DS(100, "Max TP Up XIV")],
[DS(5, "Evasion Boost XIV"), DS(15, "Visual Cloaking XIV"), DS(20, "Untouchable Dash XIV"), DS(20, "Resist Topple XIV"), DS(30, "Resist Gravity Res Down XIV"), DS(100, "Resist Launch XIV")],
[DS(10, "Weather Master II"), DS(25, "EXP Boost II"), DS(50, "Resist Blackout II"), DS(100, "Stun: Barrier II")],
[DS(10, "Treasure Sensor II"), DS(25, "Potential Boost II"), DS(100, "Potential Up II")],
[DS(5, "Weather Master IV"), DS(15, "EXP Boost IV"), DS(30, "Resist Blackout IV"), DS(100, "Stun: Barrier IV")],
[DS(5, "Treasure Sensor IV"), DS(15, "Potential Boost IV"), DS(100, "Potential Up IV")],
[DS(10, "Weather Master IV"), DS(25, "EXP Boost IV"), DS(50, "Resist Blackout IV"), DS(100, "Stun: Barrier IV")],
[DS(10, "Treasure Sensor IV"), DS(25, "Potential Boost IV"), DS(100, "Potential Up IV")],
[DS(5, "Weather Master VI"), DS(15, "EXP Boost VI"), DS(30, "Resist Blackout VI"), DS(100, "Stun: Barrier VI")],
[DS(5, "Treasure Sensor VI"), DS(15, "Potential Boost VI"), DS(100, "Potential Up VI")],
[DS(10, "Crimson Aurora Screen"), DS(20, "Reflect: Ether"), DS(30, "Max HP Boost II"), DS(50, "Resist Flinch II"), DS(100, "Resist Ether Res Down II")],
[DS(10, "Extend Aura II"), DS(20, "Debuff Suppressor II"), DS(30, "Resist HP Recovery Down II"), DS(30, "High Danger Surge II"), DS(50, "Danger Surge II"), DS(100, "Max HP Up II")],
[DS(5, "Crimson Aurora Screen"), DS(10, "Reflect: Ether"), DS(15, "Max HP Boost IV"), DS(25, "Resist Flinch IV"), DS(100, "Resist Ether Res Down IV")],
[DS(5, "Extend Aura IV"), DS(10, "Debuff Suppressor IV"), DS(15, "Resist HP Recovery Down IV"), DS(15, "High Danger Surge IV"), DS(25, "Danger Surge IV"), DS(100, "Max HP Up IV")],
[DS(10, "Crimson Aurora Screen"), DS(20, "Reflect: Ether"), DS(30, "Max HP Boost IV"), DS(50, "Resist Flinch IV"), DS(100, "Resist Ether Res Down IV")],
[DS(10, "Extend Aura IV"), DS(20, "Debuff Suppressor IV"), DS(30, "Resist HP Recovery Down IV"), DS(30, "High Danger Surge IV"), DS(50, "Danger Surge IV"), DS(100, "Max HP Up IV")],
[DS(5, "Crimson Aurora Screen"), DS(10, "Reflect: Ether"), DS(15, "Max HP Boost VI"), DS(25, "Resist Flinch VI"), DS(100, "Resist Ether Res Down VI")],
[DS(5, "Extend Aura VI"), DS(10, "Debuff Suppressor VI"), DS(15, "Resist HP Recovery Down VI"), DS(15, "High Danger Surge VI"), DS(25, "Danger Surge VI"), DS(100, "Max HP Up VI")],
[DS(10, "Overdrive: Gain TP II"), DS(20, "Ranged Draw Surge II"), DS(30, "Aura Surge II"), DS(100, "Ranged Attack Boost II")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Side Attack Plus II"), DS(30, "Ether Resistance Up II"), DS(30, "Artful Execution Surge II"), DS(100, "Max HP Up II")],
[DS(5, "Overdrive: Gain TP IV"), DS(10, "Ranged Draw Surge IV"), DS(15, "Aura Surge IV"), DS(100, "Ranged Attack Boost IV")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus IV"), DS(15, "Ether Resistance Up IV"), DS(30, "Artful Execution Surge IV"), DS(100, "Max HP Up IV")],
[DS(10, "Overdrive: Gain TP IV"), DS(20, "Ranged Draw Surge IV"), DS(30, "Aura Surge IV"), DS(100, "Ranged Attack Boost IV")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Side Attack Plus IV"), DS(30, "Ether Resistance Up IV"), DS(30, "Artful Execution Surge IV"), DS(100, "Max HP Up IV")],
[DS(5, "Overdrive: Gain TP VI"), DS(10, "Ranged Draw Surge VI"), DS(15, "Aura Surge VI"), DS(100, "Ranged Attack Boost VI")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus VI"), DS(15, "Ether Resistance Up VI"), DS(30, "Artful Execution Surge VI"), DS(100, "Max HP Up VI")],
[DS(10, "Overdrive: Gain TP II"), DS(20, "Crush Surge II"), DS(30, "Critical Surge II"), DS(100, "Ranged Attack Boost II")],
[DS(10, "Secondary CD Reducer II"), DS(20, "Vantage Attack Plus II"), DS(30, "Ether Resistance Up II"), DS(30, "Underdog Surge II"), DS(100, "Max TP Up II")],
[DS(5, "Overdrive: Gain TP IV"), DS(10, "Crush Surge IV"), DS(15, "Critical Surge IV"), DS(100, "Ranged Attack Boost IV")],
[DS(5, "Secondary CD Reducer IV"), DS(10, "Vantage Attack Plus IV"), DS(15, "Ether Resistance Up IV"), DS(30, "Underdog Surge IV"), DS(100, "Max TP Up IV")],
[DS(10, "Overdrive: Gain TP IV"), DS(20, "Crush Surge IV"), DS(30, "Critical Surge IV"), DS(100, "Ranged Attack Boost IV")],
[DS(10, "Secondary CD Reducer IV"), DS(20, "Vantage Attack Plus IV"), DS(30, "Ether Resistance Up IV"), DS(30, "Underdog Surge IV"), DS(100, "Max TP Up IV")],
[DS(5, "Overdrive: Gain TP VI"), DS(10, "Crush Surge VI"), DS(15, "Critical Surge VI"), DS(100, "Ranged Attack Boost VI")],
[DS(5, "Secondary CD Reducer VI"), DS(10, "Vantage Attack Plus VI"), DS(15, "Ether Resistance Up VI"), DS(30, "Underdog Surge VI"), DS(100, "Max TP Up VI")],
[DS(10, "TP Rebound II"), DS(25, "Resist Topple II"), DS(50, "Topple: Barrier II"), DS(100, "Max TP Up II")],
[DS(10, "Evasion Up II"), DS(25, "Visual Cloaking II"), DS(30, "Resistance Reducer II"), DS(30, "Resist Gravity Res Down II"), DS(50, "Resist Stagger II"), DS(100, "Resist Knockback II")],
[DS(5, "TP Rebound IV"), DS(15, "Resist Topple IV"), DS(30, "Topple: Barrier IV"), DS(100, "Max TP Up IV")],
[DS(5, "Evasion Up IV"), DS(15, "Visual Cloaking IV"), DS(20, "Resistance Reducer IV"), DS(20, "Resist Gravity Res Down IV"), DS(30, "Resist Stagger IV"), DS(100, "Resist Knockback IV")],
[DS(10, "TP Rebound IV"), DS(25, "Resist Topple IV"), DS(50, "Topple: Barrier IV"), DS(100, "Max TP Up IV")],
[DS(10, "Evasion Up IV"), DS(25, "Visual Cloaking IV"), DS(30, "Resistance Reducer IV"), DS(30, "Resist Gravity Res Down IV"), DS(50, "Resist Stagger IV"), DS(100, "Resist Knockback IV")],
[DS(5, "TP Rebound VI"), DS(15, "Resist Topple VI"), DS(30, "Topple: Barrier VI"), DS(100, "Max TP Up VI")],
[DS(5, "Evasion Up VI"), DS(15, "Visual Cloaking VI"), DS(20, "Resistance Reducer VI"), DS(20, "Resist Gravity Res Down VI"), DS(30, "Resist Stagger VI"), DS(100, "Resist Knockback VI")],
[DS(10, "Weather Master VI"), DS(25, "EXP Boost VI"), DS(50, "Resist Blackout VI"), DS(100, "Stun: Barrier VI")],
[DS(10, "Treasure Sensor VI"), DS(25, "Potential Boost VI"), DS(100, "Potential Up VI")],
[DS(5, "Weather Master VIII"), DS(15, "EXP Boost VIII"), DS(30, "Resist Blackout VIII"), DS(100, "Stun: Barrier VIII")],
[DS(5, "Treasure Sensor VIII"), DS(15, "Potential Boost VIII"), DS(100, "Potential Up VIII")],
[DS(10, "Weather Master VIII"), DS(25, "EXP Boost VIII"), DS(50, "Resist Blackout VIII"), DS(100, "Stun: Barrier VIII")],
[DS(10, "Treasure Sensor VIII"), DS(25, "Potential Boost VIII"), DS(100, "Potential Up VIII")],
[DS(5, "Weather Master X"), DS(15, "EXP Boost X"), DS(30, "Resist Blackout X"), DS(100, "Stun: Barrier X")],
[DS(5, "Treasure Sensor X"), DS(15, "Potential Boost X"), DS(100, "Potential Up X")],
[DS(10, "Crimson Aurora Screen"), DS(20, "Reflect: Ether"), DS(30, "Max HP Boost VI"), DS(50, "Resist Flinch VI"), DS(100, "Resist Ether Res Down VI")],
[DS(10, "Extend Aura VI"), DS(20, "Debuff Suppressor VI"), DS(30, "Resist HP Recovery Down VI"), DS(30, "High Danger Surge VI"), DS(50, "Danger Surge VI"), DS(100, "Max HP Up VI")],
[DS(5, "Crimson Aurora Screen"), DS(10, "Reflect: Ether"), DS(15, "Max HP Boost VIII"), DS(25, "Resist Flinch VIII"), DS(100, "Resist Ether Res Down VIII")],
[DS(5, "Extend Aura VIII"), DS(10, "Debuff Suppressor VIII"), DS(15, "Resist HP Recovery Down VIII"), DS(15, "High Danger Surge VIII"), DS(25, "Danger Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(10, "Crimson Aurora Screen"), DS(20, "Reflect: Ether"), DS(30, "Max HP Boost VIII"), DS(50, "Resist Flinch VIII"), DS(100, "Resist Ether Res Down VIII")],
[DS(10, "Extend Aura VIII"), DS(20, "Debuff Suppressor VIII"), DS(30, "Resist HP Recovery Down VIII"), DS(30, "High Danger Surge VIII"), DS(50, "Danger Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(5, "Crimson Aurora Screen"), DS(10, "Reflect: Ether"), DS(15, "Max HP Boost X"), DS(25, "Resist Flinch X"), DS(100, "Resist Ether Res Down X")],
[DS(5, "Extend Aura X"), DS(10, "Debuff Suppressor X"), DS(15, "Resist HP Recovery Down X"), DS(15, "High Danger Surge X"), DS(25, "Danger Surge X"), DS(100, "Max HP Up X")],
[DS(10, "Overdrive: Gain TP VI"), DS(20, "Ranged Draw Surge VI"), DS(30, "Aura Surge VI"), DS(100, "Ranged Attack Boost VI")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Side Attack Plus VI"), DS(30, "Ether Resistance Up VI"), DS(30, "Artful Execution Surge VI"), DS(100, "Max HP Up VI")],
[DS(5, "Overdrive: Gain TP VIII"), DS(10, "Ranged Draw Surge VIII"), DS(15, "Aura Surge VIII"), DS(100, "Ranged Attack Boost VIII")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus VIII"), DS(15, "Ether Resistance Up VIII"), DS(30, "Artful Execution Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(10, "Overdrive: Gain TP VIII"), DS(20, "Ranged Draw Surge VIII"), DS(30, "Aura Surge VIII"), DS(100, "Ranged Attack Boost VIII")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Side Attack Plus VIII"), DS(30, "Ether Resistance Up VIII"), DS(30, "Artful Execution Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(5, "Overdrive: Gain TP X"), DS(10, "Ranged Draw Surge X"), DS(15, "Aura Surge X"), DS(100, "Ranged Attack Boost X")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus X"), DS(15, "Ether Resistance Up X"), DS(30, "Artful Execution Surge X"), DS(100, "Max HP Up X")],
[DS(10, "Overdrive: Gain TP VI"), DS(20, "Crush Surge VI"), DS(30, "Critical Surge VI"), DS(100, "Ranged Attack Boost VI")],
[DS(10, "Secondary CD Reducer VI"), DS(20, "Vantage Attack Plus VI"), DS(30, "Ether Resistance Up VI"), DS(30, "Underdog Surge VI"), DS(100, "Max TP Up VI")],
[DS(5, "Overdrive: Gain TP VIII"), DS(10, "Crush Surge VIII"), DS(15, "Critical Surge VIII"), DS(100, "Ranged Attack Boost VIII")],
[DS(5, "Secondary CD Reducer VIII"), DS(10, "Vantage Attack Plus VIII"), DS(15, "Ether Resistance Up VIII"), DS(30, "Underdog Surge VIII"), DS(100, "Max TP Up VIII")],
[DS(10, "Overdrive: Gain TP VIII"), DS(20, "Crush Surge VIII"), DS(30, "Critical Surge VIII"), DS(100, "Ranged Attack Boost VIII")],
[DS(10, "Secondary CD Reducer VIII"), DS(20, "Vantage Attack Plus VIII"), DS(30, "Ether Resistance Up VIII"), DS(30, "Underdog Surge VIII"), DS(100, "Max TP Up VIII")],
[DS(5, "Overdrive: Gain TP X"), DS(10, "Crush Surge X"), DS(15, "Critical Surge X"), DS(100, "Ranged Attack Boost X")],
[DS(5, "Secondary CD Reducer X"), DS(10, "Vantage Attack Plus X"), DS(15, "Ether Resistance Up X"), DS(30, "Underdog Surge X"), DS(100, "Max TP Up X")],
[DS(10, "TP Rebound VI"), DS(25, "Resist Topple VI"), DS(50, "Topple: Barrier VI"), DS(100, "Max TP Up VI")],
[DS(10, "Evasion Up VI"), DS(25, "Visual Cloaking VI"), DS(30, "Resistance Reducer VI"), DS(30, "Resist Gravity Res Down VI"), DS(50, "Resist Stagger VI"), DS(100, "Resist Knockback VI")],
[DS(5, "TP Rebound VIII"), DS(15, "Resist Topple VIII"), DS(30, "Topple: Barrier VIII"), DS(100, "Max TP Up VIII")],
[DS(5, "Evasion Up VIII"), DS(15, "Visual Cloaking VIII"), DS(20, "Resistance Reducer VIII"), DS(20, "Resist Gravity Res Down VIII"), DS(30, "Resist Stagger VIII"), DS(100, "Resist Knockback VIII")],
[DS(10, "TP Rebound VIII"), DS(25, "Resist Topple VIII"), DS(50, "Topple: Barrier VIII"), DS(100, "Max TP Up VIII")],
[DS(10, "Evasion Up VIII"), DS(25, "Visual Cloaking VIII"), DS(30, "Resistance Reducer VIII"), DS(30, "Resist Gravity Res Down VIII"), DS(50, "Resist Stagger VIII"), DS(100, "Resist Knockback VIII")],
[DS(5, "TP Rebound X"), DS(15, "Resist Topple X"), DS(30, "Topple: Barrier X"), DS(100, "Max TP Up X")],
[DS(5, "Evasion Up X"), DS(15, "Visual Cloaking X"), DS(20, "Resistance Reducer X"), DS(20, "Resist Gravity Res Down X"), DS(30, "Resist Stagger X"), DS(100, "Resist Knockback X")],
[DS(10, "Weather Master X"), DS(25, "EXP Boost X"), DS(50, "Resist Blackout X"), DS(100, "Stun: Barrier X")],
[DS(10, "Treasure Sensor X"), DS(25, "Potential Boost X"), DS(100, "Potential Up X")],
[DS(5, "Weather Master XII"), DS(15, "EXP Boost XII"), DS(30, "Resist Blackout XII"), DS(100, "Stun: Barrier XII")],
[DS(5, "Treasure Sensor XII"), DS(15, "Potential Boost XII"), DS(100, "Potential Up XII")],
[DS(5, "Weather Master XII"), DS(15, "EXP Boost XII"), DS(30, "Resist Blackout XII"), DS(100, "Stun: Barrier XII")],
[DS(5, "Treasure Sensor XII"), DS(15, "Potential Boost XII"), DS(100, "Potential Up XII")],
[DS(5, "Weather Master XIV"), DS(15, "EXP Boost XIV"), DS(30, "Resist Blackout XIV"), DS(100, "Stun: Barrier XIV")],
[DS(5, "Treasure Sensor XIV"), DS(15, "Potential Boost XIV"), DS(100, "Potential Up XIV")],
[DS(10, "Crimson Aurora Screen"), DS(20, "Reflect: Ether"), DS(30, "Max HP Boost X"), DS(50, "Resist Flinch X"), DS(100, "Resist Ether Res Down X")],
[DS(10, "Extend Aura X"), DS(20, "Debuff Suppressor X"), DS(30, "Resist HP Recovery Down X"), DS(30, "High Danger Surge X"), DS(50, "Danger Surge X"), DS(100, "Max HP Up X")],
[DS(5, "Crimson Aurora Screen"), DS(10, "Reflect: Ether"), DS(15, "Max HP Boost XII"), DS(25, "Resist Flinch XII"), DS(100, "Resist Ether Res Down XII")],
[DS(5, "Extend Aura XII"), DS(10, "Debuff Suppressor XII"), DS(15, "Resist HP Recovery Down XII"), DS(15, "High Danger Surge XII"), DS(25, "Danger Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "Crimson Aurora Screen"), DS(10, "Reflect: Ether"), DS(15, "Max HP Boost XII"), DS(25, "Resist Flinch XII"), DS(100, "Resist Ether Res Down XII")],
[DS(5, "Extend Aura XII"), DS(10, "Debuff Suppressor XII"), DS(15, "Resist HP Recovery Down XII"), DS(15, "High Danger Surge XII"), DS(25, "Danger Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "Crimson Aurora Screen"), DS(10, "Reflect: Ether"), DS(15, "Max HP Boost XIV"), DS(25, "Resist Flinch XIV"), DS(100, "Resist Ether Res Down XIV")],
[DS(5, "Extend Aura XIV"), DS(10, "Debuff Suppressor XIV"), DS(15, "Resist HP Recovery Down XIV"), DS(15, "High Danger Surge XIV"), DS(25, "Danger Surge XIV"), DS(100, "Max HP Up XIV")],
[DS(10, "Overdrive: Gain TP X"), DS(20, "Ranged Draw Surge X"), DS(30, "Aura Surge X"), DS(100, "Ranged Attack Boost X")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Side Attack Plus X"), DS(30, "Ether Resistance Up X"), DS(30, "Artful Execution Surge X"), DS(100, "Max HP Up X")],
[DS(5, "Overdrive: Gain TP XII"), DS(10, "Ranged Draw Surge XII"), DS(15, "Aura Surge XII"), DS(100, "Ranged Attack Boost XII")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus XII"), DS(15, "Ether Resistance Up XII"), DS(30, "Artful Execution Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "Overdrive: Gain TP XII"), DS(10, "Ranged Draw Surge XII"), DS(15, "Aura Surge XII"), DS(100, "Ranged Attack Boost XII")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus XII"), DS(15, "Ether Resistance Up XII"), DS(30, "Artful Execution Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "Overdrive: Gain TP XIV"), DS(10, "Ranged Draw Surge XIV"), DS(15, "Aura Surge XIV"), DS(100, "Ranged Attack Boost XIV")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus XIV"), DS(15, "Ether Resistance Up XIV"), DS(30, "Artful Execution Surge XIV"), DS(100, "Max HP Up XIV")],
[DS(10, "Overdrive: Gain TP X"), DS(20, "Crush Surge X"), DS(30, "Critical Surge X"), DS(100, "Ranged Attack Boost X")],
[DS(10, "Secondary CD Reducer X"), DS(20, "Vantage Attack Plus X"), DS(30, "Ether Resistance Up X"), DS(30, "Underdog Surge X"), DS(100, "Max TP Up X")],
[DS(5, "Overdrive: Gain TP XII"), DS(10, "Crush Surge XII"), DS(15, "Critical Surge XII"), DS(100, "Ranged Attack Boost XII")],
[DS(5, "Secondary CD Reducer XII"), DS(10, "Vantage Attack Plus XII"), DS(15, "Ether Resistance Up XII"), DS(30, "Underdog Surge XII"), DS(100, "Max TP Up XII")],
[DS(5, "Overdrive: Gain TP XII"), DS(10, "Crush Surge XII"), DS(15, "Critical Surge XII"), DS(100, "Ranged Attack Boost XII")],
[DS(5, "Secondary CD Reducer XII"), DS(10, "Vantage Attack Plus XII"), DS(15, "Ether Resistance Up XII"), DS(30, "Underdog Surge XII"), DS(100, "Max TP Up XII")],
[DS(5, "Overdrive: Gain TP XIV"), DS(10, "Crush Surge XIV"), DS(15, "Critical Surge XIV"), DS(100, "Ranged Attack Boost XIV")],
[DS(5, "Secondary CD Reducer XIV"), DS(10, "Vantage Attack Plus XIV"), DS(15, "Ether Resistance Up XIV"), DS(30, "Underdog Surge XIV"), DS(100, "Max TP Up XIV")],
[DS(10, "TP Rebound X"), DS(25, "Resist Topple X"), DS(50, "Topple: Barrier X"), DS(100, "Max TP Up X")],
[DS(10, "Evasion Up X"), DS(25, "Visual Cloaking X"), DS(30, "Resistance Reducer X"), DS(30, "Resist Gravity Res Down X"), DS(50, "Resist Stagger X"), DS(100, "Resist Knockback X")],
[DS(5, "TP Rebound XII"), DS(15, "Resist Topple XII"), DS(30, "Topple: Barrier XII"), DS(100, "Max TP Up XII")],
[DS(5, "Evasion Up XII"), DS(15, "Visual Cloaking XII"), DS(20, "Resistance Reducer XII"), DS(20, "Resist Gravity Res Down XII"), DS(30, "Resist Stagger XII"), DS(100, "Resist Knockback XII")],
[DS(5, "TP Rebound XII"), DS(15, "Resist Topple XII"), DS(30, "Topple: Barrier XII"), DS(100, "Max TP Up XII")],
[DS(5, "Evasion Up XII"), DS(15, "Visual Cloaking XII"), DS(20, "Resistance Reducer XII"), DS(20, "Resist Gravity Res Down XII"), DS(30, "Resist Stagger XII"), DS(100, "Resist Knockback XII")],
[DS(5, "TP Rebound XIV"), DS(15, "Resist Topple XIV"), DS(30, "Topple: Barrier XIV"), DS(100, "Max TP Up XIV")],
[DS(5, "Evasion Up XIV"), DS(15, "Visual Cloaking XIV"), DS(20, "Resistance Reducer XIV"), DS(20, "Resist Gravity Res Down XIV"), DS(30, "Resist Stagger XIV"), DS(100, "Resist Knockback XIV")],
[DS(10, "Weather Master II"), DS(25, "EXP Boost II"), DS(50, "Resist Sleep II"), DS(100, "Stun: Barrier II")],
[DS(10, "Treasure Sensor II"), DS(25, "Potential Boost II"), DS(100, "Potential Up II")],
[DS(5, "Weather Master IV"), DS(15, "EXP Boost IV"), DS(30, "Resist Sleep IV"), DS(100, "Stun: Barrier IV")],
[DS(5, "Treasure Sensor IV"), DS(15, "Potential Boost IV"), DS(100, "Potential Up IV")],
[DS(10, "Weather Master IV"), DS(25, "EXP Boost IV"), DS(50, "Resist Sleep IV"), DS(100, "Stun: Barrier IV")],
[DS(10, "Treasure Sensor IV"), DS(25, "Potential Boost IV"), DS(100, "Potential Up IV")],
[DS(5, "Weather Master VI"), DS(15, "EXP Boost VI"), DS(30, "Resist Sleep VI"), DS(100, "Stun: Barrier VI")],
[DS(5, "Treasure Sensor VI"), DS(15, "Potential Boost VI"), DS(100, "Potential Up VI")],
[DS(10, "EM Storm Screen"), DS(20, "Reflect: Electric"), DS(30, "Reflect Damage Up II"), DS(50, "Resist Flinch II"), DS(100, "Resist Electric Res Down II")],
[DS(10, "Extend Aura II"), DS(20, "HP Rebound II"), DS(30, "Resist Shock II"), DS(30, "Incapacitation Surge II"), DS(50, "Danger Surge II"), DS(100, "Max HP Up II")],
[DS(5, "EM Storm Screen"), DS(10, "Reflect: Electric"), DS(15, "Reflect Damage Up IV"), DS(25, "Resist Flinch IV"), DS(100, "Resist Electric Res Down IV")],
[DS(5, "Extend Aura IV"), DS(10, "HP Rebound IV"), DS(15, "Resist Shock IV"), DS(15, "Incapacitation Surge IV"), DS(25, "Danger Surge IV"), DS(100, "Max HP Up IV")],
[DS(10, "EM Storm Screen"), DS(20, "Reflect: Electric"), DS(30, "Reflect Damage Up IV"), DS(50, "Resist Flinch IV"), DS(100, "Resist Electric Res Down IV")],
[DS(10, "Extend Aura IV"), DS(20, "HP Rebound IV"), DS(30, "Resist Shock IV"), DS(30, "Incapacitation Surge IV"), DS(50, "Danger Surge IV"), DS(100, "Max HP Up IV")],
[DS(5, "EM Storm Screen"), DS(10, "Reflect: Electric"), DS(15, "Reflect Damage Up VI"), DS(25, "Resist Flinch VI"), DS(100, "Resist Electric Res Down VI")],
[DS(5, "Extend Aura VI"), DS(10, "HP Rebound VI"), DS(15, "Resist Shock VI"), DS(15, "Incapacitation Surge VI"), DS(25, "Danger Surge VI"), DS(100, "Max HP Up VI")],
[DS(10, "Aura: Refuel II"), DS(20, "Melee Draw Surge II"), DS(30, "Critical Surge II"), DS(100, "Melee Attack Up II")],
[DS(10, "Overdrive Green Bonus"), DS(20, "Back Attack Plus II"), DS(30, "Electric Resistance Up II"), DS(30, "Overdrive Count Up II"), DS(100, "Max HP Up II")],
[DS(5, "Aura: Refuel IV"), DS(10, "Melee Draw Surge IV"), DS(15, "Critical Surge IV"), DS(100, "Melee Attack Up IV")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Back Attack Plus IV"), DS(15, "Electric Resistance Up IV"), DS(30, "Overdrive Count Up IV"), DS(100, "Max HP Up IV")],
[DS(10, "Aura: Refuel IV"), DS(20, "Melee Draw Surge IV"), DS(30, "Critical Surge IV"), DS(100, "Melee Attack Up IV")],
[DS(10, "Overdrive Green Bonus"), DS(20, "Back Attack Plus IV"), DS(30, "Electric Resistance Up IV"), DS(30, "Overdrive Count Up IV"), DS(100, "Max HP Up IV")],
[DS(5, "Aura: Refuel VI"), DS(10, "Melee Draw Surge VI"), DS(15, "Critical Surge VI"), DS(100, "Melee Attack Up VI")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Back Attack Plus VI"), DS(15, "Electric Resistance Up VI"), DS(30, "Overdrive Count Up VI"), DS(100, "Max HP Up VI")],
[DS(10, "Aura: Refuel II"), DS(20, "Art Draw Surge II"), DS(30, "Overdrive Surge II"), DS(100, "Melee Attack Up II")],
[DS(10, "Extend Overdrive II"), DS(20, "Vantage Attack Plus II"), DS(30, "Electric Resistance Up II"), DS(30, "Underdog Surge II"), DS(100, "Max TP Up II")],
[DS(5, "Aura: Refuel IV"), DS(10, "Art Draw Surge IV"), DS(15, "Overdrive Surge IV"), DS(100, "Melee Attack Up IV")],
[DS(5, "Extend Overdrive IV"), DS(10, "Vantage Attack Plus IV"), DS(15, "Electric Resistance Up IV"), DS(30, "Underdog Surge IV"), DS(100, "Max TP Up IV")],
[DS(10, "Aura: Refuel IV"), DS(20, "Art Draw Surge IV"), DS(30, "Overdrive Surge IV"), DS(100, "Melee Attack Up IV")],
[DS(10, "Extend Overdrive IV"), DS(20, "Vantage Attack Plus IV"), DS(30, "Electric Resistance Up IV"), DS(30, "Underdog Surge IV"), DS(100, "Max TP Up IV")],
[DS(5, "Aura: Refuel VI"), DS(10, "Art Draw Surge VI"), DS(15, "Overdrive Surge VI"), DS(100, "Melee Attack Up VI")],
[DS(5, "Extend Overdrive VI"), DS(10, "Vantage Attack Plus VI"), DS(15, "Electric Resistance Up VI"), DS(30, "Underdog Surge VI"), DS(100, "Max TP Up VI")],
[DS(10, "Max TP Boost II"), DS(25, "Resist Topple II"), DS(50, "Topple: Barrier II"), DS(100, "Max TP Up II")],
[DS(10, "Evasion Up II"), DS(25, "Resist Stagger II"), DS(30, "Terrain Damage Reducer II"), DS(30, "Resist Gravity Res Down II"), DS(50, "Resist Launch II"), DS(100, "Resist Knockback II")],
[DS(5, "Max TP Boost IV"), DS(15, "Resist Topple IV"), DS(30, "Topple: Barrier IV"), DS(100, "Max TP Up IV")],
[DS(5, "Evasion Up IV"), DS(15, "Resist Stagger IV"), DS(20, "Terrain Damage Reducer IV"), DS(20, "Resist Gravity Res Down IV"), DS(30, "Resist Launch IV"), DS(100, "Resist Knockback IV")],
[DS(10, "Max TP Boost IV"), DS(25, "Resist Topple IV"), DS(50, "Topple: Barrier IV"), DS(100, "Max TP Up IV")],
[DS(10, "Evasion Up IV"), DS(25, "Resist Stagger IV"), DS(30, "Terrain Damage Reducer IV"), DS(30, "Resist Gravity Res Down IV"), DS(50, "Resist Launch IV"), DS(100, "Resist Knockback IV")],
[DS(5, "Max TP Boost VI"), DS(15, "Resist Topple VI"), DS(30, "Topple: Barrier VI"), DS(100, "Max TP Up VI")],
[DS(5, "Evasion Up VI"), DS(15, "Resist Stagger VI"), DS(20, "Terrain Damage Reducer VI"), DS(20, "Resist Gravity Res Down VI"), DS(30, "Resist Launch VI"), DS(100, "Resist Knockback VI")],
[DS(10, "Weather Master VI"), DS(25, "EXP Boost VI"), DS(50, "Resist Sleep VI"), DS(100, "Stun: Barrier VI")],
[DS(10, "Treasure Sensor VI"), DS(25, "Potential Boost VI"), DS(100, "Potential Up VI")],
[DS(5, "Weather Master VIII"), DS(15, "EXP Boost VIII"), DS(30, "Resist Sleep VIII"), DS(100, "Stun: Barrier VIII")],
[DS(5, "Treasure Sensor VIII"), DS(15, "Potential Boost VIII"), DS(100, "Potential Up VIII")],
[DS(10, "Weather Master VIII"), DS(25, "EXP Boost VIII"), DS(50, "Resist Sleep VIII"), DS(100, "Stun: Barrier VIII")],
[DS(10, "Treasure Sensor VIII"), DS(25, "Potential Boost VIII"), DS(100, "Potential Up VIII")],
[DS(5, "Weather Master X"), DS(15, "EXP Boost X"), DS(30, "Resist Sleep X"), DS(100, "Stun: Barrier X")],
[DS(5, "Treasure Sensor X"), DS(15, "Potential Boost X"), DS(100, "Potential Up X")],
[DS(10, "EM Storm Screen"), DS(20, "Reflect: Electric"), DS(30, "Reflect Damage Up VI"), DS(50, "Resist Flinch VI"), DS(100, "Resist Electric Res Down VI")],
[DS(10, "Extend Aura VI"), DS(20, "HP Rebound VI"), DS(30, "Resist Shock VI"), DS(30, "Incapacitation Surge VI"), DS(50, "Danger Surge VI"), DS(100, "Max HP Up VI")],
[DS(5, "EM Storm Screen"), DS(10, "Reflect: Electric"), DS(15, "Reflect Damage Up VIII"), DS(25, "Resist Flinch VIII"), DS(100, "Resist Electric Res Down VIII")],
[DS(5, "Extend Aura VIII"), DS(10, "HP Rebound VIII"), DS(15, "Resist Shock VIII"), DS(15, "Incapacitation Surge VIII"), DS(25, "Danger Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(10, "EM Storm Screen"), DS(20, "Reflect: Electric"), DS(30, "Reflect Damage Up VIII"), DS(50, "Resist Flinch VIII"), DS(100, "Resist Electric Res Down VIII")],
[DS(10, "Extend Aura VIII"), DS(20, "HP Rebound VIII"), DS(30, "Resist Shock VIII"), DS(30, "Incapacitation Surge VIII"), DS(50, "Danger Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(5, "EM Storm Screen"), DS(10, "Reflect: Electric"), DS(15, "Reflect Damage Up X"), DS(25, "Resist Flinch X"), DS(100, "Resist Electric Res Down X")],
[DS(5, "Extend Aura X"), DS(10, "HP Rebound X"), DS(15, "Resist Shock X"), DS(15, "Incapacitation Surge X"), DS(25, "Danger Surge X"), DS(100, "Max HP Up X")],
[DS(10, "Aura: Refuel VI"), DS(20, "Melee Draw Surge VI"), DS(30, "Critical Surge VI"), DS(100, "Melee Attack Up VI")],
[DS(10, "Overdrive Green Bonus"), DS(20, "Back Attack Plus VI"), DS(30, "Electric Resistance Up VI"), DS(30, "Overdrive Count Up VI"), DS(100, "Max HP Up VI")],
[DS(5, "Aura: Refuel VIII"), DS(10, "Melee Draw Surge VIII"), DS(15, "Critical Surge VIII"), DS(100, "Melee Attack Up VIII")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Back Attack Plus VIII"), DS(15, "Electric Resistance Up VIII"), DS(30, "Overdrive Count Up VIII"), DS(100, "Max HP Up VIII")],
[DS(10, "Aura: Refuel VIII"), DS(20, "Melee Draw Surge VIII"), DS(30, "Critical Surge VIII"), DS(100, "Melee Attack Up VIII")],
[DS(10, "Overdrive Green Bonus"), DS(20, "Back Attack Plus VIII"), DS(30, "Electric Resistance Up VIII"), DS(30, "Overdrive Count Up VIII"), DS(100, "Max HP Up VIII")],
[DS(5, "Aura: Refuel X"), DS(10, "Melee Draw Surge X"), DS(15, "Critical Surge X"), DS(100, "Melee Attack Up X")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Back Attack Plus X"), DS(15, "Electric Resistance Up X"), DS(30, "Overdrive Count Up X"), DS(100, "Max HP Up X")],
[DS(10, "Aura: Refuel VI"), DS(20, "Art Draw Surge VI"), DS(30, "Overdrive Surge VI"), DS(100, "Melee Attack Up VI")],
[DS(10, "Extend Overdrive VI"), DS(20, "Vantage Attack Plus VI"), DS(30, "Electric Resistance Up VI"), DS(30, "Underdog Surge VI"), DS(100, "Max TP Up VI")],
[DS(5, "Aura: Refuel VIII"), DS(10, "Art Draw Surge VIII"), DS(15, "Overdrive Surge VIII"), DS(100, "Melee Attack Up VIII")],
[DS(5, "Extend Overdrive VIII"), DS(10, "Vantage Attack Plus VIII"), DS(15, "Electric Resistance Up VIII"), DS(30, "Underdog Surge VIII"), DS(100, "Max TP Up VIII")],
[DS(10, "Aura: Refuel VIII"), DS(20, "Art Draw Surge VIII"), DS(30, "Overdrive Surge VIII"), DS(100, "Melee Attack Up VIII")],
[DS(10, "Extend Overdrive VIII"), DS(20, "Vantage Attack Plus VIII"), DS(30, "Electric Resistance Up VIII"), DS(30, "Underdog Surge VIII"), DS(100, "Max TP Up VIII")],
[DS(5, "Aura: Refuel X"), DS(10, "Art Draw Surge X"), DS(15, "Overdrive Surge X"), DS(100, "Melee Attack Up X")],
[DS(5, "Extend Overdrive X"), DS(10, "Vantage Attack Plus X"), DS(15, "Electric Resistance Up X"), DS(30, "Underdog Surge X"), DS(100, "Max TP Up X")],
[DS(10, "Max TP Boost VI"), DS(25, "Resist Topple VI"), DS(50, "Topple: Barrier VI"), DS(100, "Max TP Up VI")],
[DS(10, "Evasion Up VI"), DS(25, "Resist Stagger VI"), DS(30, "Terrain Damage Reducer VI"), DS(30, "Resist Gravity Res Down VI"), DS(50, "Resist Launch VI"), DS(100, "Resist Knockback VI")],
[DS(5, "Max TP Boost VIII"), DS(15, "Resist Topple VIII"), DS(30, "Topple: Barrier VIII"), DS(100, "Max TP Up VIII")],
[DS(5, "Evasion Up VIII"), DS(15, "Resist Stagger VIII"), DS(20, "Terrain Damage Reducer VIII"), DS(20, "Resist Gravity Res Down VIII"), DS(30, "Resist Launch VIII"), DS(100, "Resist Knockback VIII")],
[DS(10, "Max TP Boost VIII"), DS(25, "Resist Topple VIII"), DS(50, "Topple: Barrier VIII"), DS(100, "Max TP Up VIII")],
[DS(10, "Evasion Up VIII"), DS(25, "Resist Stagger VIII"), DS(30, "Terrain Damage Reducer VIII"), DS(30, "Resist Gravity Res Down VIII"), DS(50, "Resist Launch VIII"), DS(100, "Resist Knockback VIII")],
[DS(5, "Max TP Boost X"), DS(15, "Resist Topple X"), DS(30, "Topple: Barrier X"), DS(100, "Max TP Up X")],
[DS(5, "Evasion Up X"), DS(15, "Resist Stagger X"), DS(20, "Terrain Damage Reducer X"), DS(20, "Resist Gravity Res Down X"), DS(30, "Resist Launch X"), DS(100, "Resist Knockback X")],
[DS(10, "Weather Master X"), DS(25, "EXP Boost X"), DS(50, "Resist Sleep X"), DS(100, "Stun: Barrier X")],
[DS(10, "Treasure Sensor X"), DS(25, "Potential Boost X"), DS(100, "Potential Up X")],
[DS(5, "Weather Master XII"), DS(15, "EXP Boost XII"), DS(30, "Resist Sleep XII"), DS(100, "Stun: Barrier XII")],
[DS(5, "Treasure Sensor XII"), DS(15, "Potential Boost XII"), DS(100, "Potential Up XII")],
[DS(5, "Weather Master XII"), DS(15, "EXP Boost XII"), DS(30, "Resist Sleep XII"), DS(100, "Stun: Barrier XII")],
[DS(5, "Treasure Sensor XII"), DS(15, "Potential Boost XII"), DS(100, "Potential Up XII")],
[DS(5, "Weather Master XIV"), DS(15, "EXP Boost XIV"), DS(30, "Resist Sleep XIV"), DS(100, "Stun: Barrier XIV")],
[DS(5, "Treasure Sensor XIV"), DS(15, "Potential Boost XIV"), DS(100, "Potential Up XIV")],
[DS(10, "EM Storm Screen"), DS(20, "Reflect: Electric"), DS(30, "Reflect Damage Up X"), DS(50, "Resist Flinch X"), DS(100, "Resist Electric Res Down X")],
[DS(10, "Extend Aura X"), DS(20, "HP Rebound X"), DS(30, "Resist Shock X"), DS(30, "Incapacitation Surge X"), DS(50, "Danger Surge X"), DS(100, "Max HP Up X")],
[DS(5, "EM Storm Screen"), DS(10, "Reflect: Electric"), DS(15, "Reflect Damage Up XII"), DS(25, "Resist Flinch XII"), DS(100, "Resist Electric Res Down XII")],
[DS(5, "Extend Aura XII"), DS(10, "HP Rebound XII"), DS(15, "Resist Shock XII"), DS(15, "Incapacitation Surge XII"), DS(25, "Danger Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "EM Storm Screen"), DS(10, "Reflect: Electric"), DS(15, "Reflect Damage Up XII"), DS(25, "Resist Flinch XII"), DS(100, "Resist Electric Res Down XII")],
[DS(5, "Extend Aura XII"), DS(10, "HP Rebound XII"), DS(15, "Resist Shock XII"), DS(15, "Incapacitation Surge XII"), DS(25, "Danger Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "EM Storm Screen"), DS(10, "Reflect: Electric"), DS(15, "Reflect Damage Up XIV"), DS(25, "Resist Flinch XIV"), DS(100, "Resist Electric Res Down XIV")],
[DS(5, "Extend Aura XIV"), DS(10, "HP Rebound XIV"), DS(15, "Resist Shock XIV"), DS(15, "Incapacitation Surge XIV"), DS(25, "Danger Surge XIV"), DS(100, "Max HP Up XIV")],
[DS(10, "Aura: Refuel X"), DS(20, "Melee Draw Surge X"), DS(30, "Critical Surge X"), DS(100, "Melee Attack Up X")],
[DS(10, "Overdrive Green Bonus"), DS(20, "Back Attack Plus X"), DS(30, "Electric Resistance Up X"), DS(30, "Overdrive Count Up X"), DS(100, "Max HP Up X")],
[DS(5, "Aura: Refuel XII"), DS(10, "Melee Draw Surge XII"), DS(15, "Critical Surge XII"), DS(100, "Melee Attack Up XII")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Back Attack Plus XII"), DS(15, "Electric Resistance Up XII"), DS(30, "Overdrive Count Up XII"), DS(100, "Max HP Up XII")],
[DS(5, "Aura: Refuel XII"), DS(10, "Melee Draw Surge XII"), DS(15, "Critical Surge XII"), DS(100, "Melee Attack Up XII")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Back Attack Plus XII"), DS(15, "Electric Resistance Up XII"), DS(30, "Overdrive Count Up XII"), DS(100, "Max HP Up XII")],
[DS(5, "Aura: Refuel XIV"), DS(10, "Melee Draw Surge XIV"), DS(15, "Critical Surge XIV"), DS(100, "Melee Attack Up XIV")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Back Attack Plus XIV"), DS(15, "Electric Resistance Up XIV"), DS(30, "Overdrive Count Up XIV"), DS(100, "Max HP Up XIV")],
[DS(10, "Aura: Refuel X"), DS(20, "Art Draw Surge X"), DS(30, "Overdrive Surge X"), DS(100, "Melee Attack Up X")],
[DS(10, "Extend Overdrive X"), DS(20, "Vantage Attack Plus X"), DS(30, "Electric Resistance Up X"), DS(30, "Underdog Surge X"), DS(100, "Max TP Up X")],
[DS(5, "Aura: Refuel XII"), DS(10, "Art Draw Surge XII"), DS(15, "Overdrive Surge XII"), DS(100, "Melee Attack Up XII")],
[DS(5, "Extend Overdrive XII"), DS(10, "Vantage Attack Plus XII"), DS(15, "Electric Resistance Up XII"), DS(30, "Underdog Surge XII"), DS(100, "Max TP Up XII")],
[DS(5, "Aura: Refuel XII"), DS(10, "Art Draw Surge XII"), DS(15, "Overdrive Surge XII"), DS(100, "Melee Attack Up XII")],
[DS(5, "Extend Overdrive XII"), DS(10, "Vantage Attack Plus XII"), DS(15, "Electric Resistance Up XII"), DS(30, "Underdog Surge XII"), DS(100, "Max TP Up XII")],
[DS(5, "Aura: Refuel XIV"), DS(10, "Art Draw Surge XIV"), DS(15, "Overdrive Surge XIV"), DS(100, "Melee Attack Up XIV")],
[DS(5, "Extend Overdrive XIV"), DS(10, "Vantage Attack Plus XIV"), DS(15, "Electric Resistance Up XIV"), DS(30, "Underdog Surge XIV"), DS(100, "Max TP Up XIV")],
[DS(10, "Max TP Boost X"), DS(25, "Resist Topple X"), DS(50, "Topple: Barrier X"), DS(100, "Max TP Up X")],
[DS(10, "Evasion Up X"), DS(25, "Resist Stagger X"), DS(30, "Terrain Damage Reducer X"), DS(30, "Resist Gravity Res Down X"), DS(50, "Resist Launch X"), DS(100, "Resist Knockback X")],
[DS(5, "Max TP Boost XII"), DS(15, "Resist Topple XII"), DS(30, "Topple: Barrier XII"), DS(100, "Max TP Up XII")],
[DS(5, "Evasion Up XII"), DS(15, "Resist Stagger XII"), DS(20, "Terrain Damage Reducer XII"), DS(20, "Resist Gravity Res Down XII"), DS(30, "Resist Launch XII"), DS(100, "Resist Knockback XII")],
[DS(5, "Max TP Boost XII"), DS(15, "Resist Topple XII"), DS(30, "Topple: Barrier XII"), DS(100, "Max TP Up XII")],
[DS(5, "Evasion Up XII"), DS(15, "Resist Stagger XII"), DS(20, "Terrain Damage Reducer XII"), DS(20, "Resist Gravity Res Down XII"), DS(30, "Resist Launch XII"), DS(100, "Resist Knockback XII")],
[DS(5, "Max TP Boost XIV"), DS(15, "Resist Topple XIV"), DS(30, "Topple: Barrier XIV"), DS(100, "Max TP Up XIV")],
[DS(5, "Evasion Up XIV"), DS(15, "Resist Stagger XIV"), DS(20, "Terrain Damage Reducer XIV"), DS(20, "Resist Gravity Res Down XIV"), DS(30, "Resist Launch XIV"), DS(100, "Resist Knockback XIV")],
[DS(10, "Weather Master II"), DS(25, "EXP Boost II"), DS(50, "Resist Stun II"), DS(100, "Taunt: Decoy II")],
[DS(10, "Treasure Sensor II"), DS(25, "Potential Boost II"), DS(100, "Potential Up II")],
[DS(5, "Weather Master IV"), DS(15, "EXP Boost IV"), DS(30, "Resist Stun IV"), DS(100, "Taunt: Decoy IV")],
[DS(5, "Treasure Sensor IV"), DS(15, "Potential Boost IV"), DS(100, "Potential Up IV")],
[DS(10, "Weather Master IV"), DS(25, "EXP Boost IV"), DS(50, "Resist Stun IV"), DS(100, "Taunt: Decoy IV")],
[DS(10, "Treasure Sensor IV"), DS(25, "Potential Boost IV"), DS(100, "Potential Up IV")],
[DS(5, "Weather Master VI"), DS(15, "EXP Boost VI"), DS(30, "Resist Stun VI"), DS(100, "Taunt: Decoy VI")],
[DS(5, "Treasure Sensor VI"), DS(15, "Potential Boost VI"), DS(100, "Potential Up VI")],
[DS(10, "Crimson Aurora Screen"), DS(20, "Reflect: Gravity"), DS(30, "Max HP Boost II"), DS(50, "Resist Flinch II"), DS(100, "Resist HP Recovery Down II")],
[DS(10, "Debuff Suppressor II"), DS(20, "Reflect Damage Up II"), DS(30, "Resist Virus II"), DS(30, "Incapacitation Surge II"), DS(50, "Danger Surge II"), DS(100, "Max HP Up II")],
[DS(5, "Crimson Aurora Screen"), DS(10, "Reflect: Gravity"), DS(15, "Max HP Boost IV"), DS(25, "Resist Flinch IV"), DS(100, "Resist HP Recovery Down IV")],
[DS(5, "Debuff Suppressor IV"), DS(10, "Reflect Damage Up IV"), DS(15, "Resist Virus IV"), DS(15, "Incapacitation Surge IV"), DS(25, "Danger Surge IV"), DS(100, "Max HP Up IV")],
[DS(10, "Crimson Aurora Screen"), DS(20, "Reflect: Gravity"), DS(30, "Max HP Boost IV"), DS(50, "Resist Flinch IV"), DS(100, "Resist HP Recovery Down IV")],
[DS(10, "Debuff Suppressor IV"), DS(20, "Reflect Damage Up IV"), DS(30, "Resist Virus IV"), DS(30, "Incapacitation Surge IV"), DS(50, "Danger Surge IV"), DS(100, "Max HP Up IV")],
[DS(5, "Crimson Aurora Screen"), DS(10, "Reflect: Gravity"), DS(15, "Max HP Boost VI"), DS(25, "Resist Flinch VI"), DS(100, "Resist HP Recovery Down VI")],
[DS(5, "Debuff Suppressor VI"), DS(10, "Reflect Damage Up VI"), DS(15, "Resist Virus VI"), DS(15, "Incapacitation Surge VI"), DS(25, "Danger Surge VI"), DS(100, "Max HP Up VI")],
[DS(10, "Aura: Refuel II"), DS(20, "Ranged Draw Surge II"), DS(30, "Art Draw Surge II"), DS(100, "Ranged Attack Up II")],
[DS(10, "Overdrive Green Bonus"), DS(20, "Back Attack Plus II"), DS(30, "Gravity Resistance Up II"), DS(30, "Artful Execution Surge II"), DS(100, "Max HP Up II")],
[DS(5, "Aura: Refuel IV"), DS(10, "Ranged Draw Surge IV"), DS(15, "Art Draw Surge IV"), DS(100, "Ranged Attack Up IV")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Back Attack Plus IV"), DS(15, "Gravity Resistance Up IV"), DS(30, "Artful Execution Surge IV"), DS(100, "Max HP Up IV")],
[DS(10, "Aura: Refuel IV"), DS(20, "Ranged Draw Surge IV"), DS(30, "Art Draw Surge IV"), DS(100, "Ranged Attack Up IV")],
[DS(10, "Overdrive Green Bonus"), DS(20, "Back Attack Plus IV"), DS(30, "Gravity Resistance Up IV"), DS(30, "Artful Execution Surge IV"), DS(100, "Max HP Up IV")],
[DS(5, "Aura: Refuel VI"), DS(10, "Ranged Draw Surge VI"), DS(15, "Art Draw Surge VI"), DS(100, "Ranged Attack Up VI")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Back Attack Plus VI"), DS(15, "Gravity Resistance Up VI"), DS(30, "Artful Execution Surge VI"), DS(100, "Max HP Up VI")],
[DS(10, "Aura: Refuel II"), DS(20, "Extend Overdrive II"), DS(30, "Extend Critical Power II"), DS(100, "Ranged Attack Up II")],
[DS(10, "Overdrive Count Up II"), DS(20, "Vantage Attack Plus II"), DS(30, "Gravity Resistance Up II"), DS(30, "Underdog Surge II"), DS(100, "Max TP Up II")],
[DS(5, "Aura: Refuel IV"), DS(10, "Extend Overdrive IV"), DS(15, "Extend Critical Power IV"), DS(100, "Ranged Attack Up IV")],
[DS(5, "Overdrive Count Up IV"), DS(10, "Vantage Attack Plus IV"), DS(15, "Gravity Resistance Up IV"), DS(30, "Underdog Surge IV"), DS(100, "Max TP Up IV")],
[DS(10, "Aura: Refuel IV"), DS(20, "Extend Overdrive IV"), DS(30, "Extend Critical Power IV"), DS(100, "Ranged Attack Up IV")],
[DS(10, "Overdrive Count Up IV"), DS(20, "Vantage Attack Plus IV"), DS(30, "Gravity Resistance Up IV"), DS(30, "Underdog Surge IV"), DS(100, "Max TP Up IV")],
[DS(5, "Aura: Refuel VI"), DS(10, "Extend Overdrive VI"), DS(15, "Extend Critical Power VI"), DS(100, "Ranged Attack Up VI")],
[DS(5, "Overdrive Count Up VI"), DS(10, "Vantage Attack Plus VI"), DS(15, "Gravity Resistance Up VI"), DS(30, "Underdog Surge VI"), DS(100, "Max TP Up VI")],
[DS(10, "Max TP Boost II"), DS(25, "Resist Stagger II"), DS(50, "Topple: Decoy II"), DS(100, "Terrain Damage Reducer II")],
[DS(10, "Evasion Up II"), DS(25, "Max TP Up II"), DS(30, "Untouchable Dash II"), DS(30, "Resist Gravity Res Down II"), DS(50, "Resist Knockback II"), DS(100, "Resist Launch II")],
[DS(5, "Max TP Boost IV"), DS(15, "Resist Stagger IV"), DS(30, "Topple: Decoy IV"), DS(100, "Terrain Damage Reducer IV")],
[DS(5, "Evasion Up IV"), DS(15, "Max TP Up IV"), DS(20, "Untouchable Dash IV"), DS(20, "Resist Gravity Res Down IV"), DS(30, "Resist Knockback IV"), DS(100, "Resist Launch IV")],
[DS(10, "Max TP Boost IV"), DS(25, "Resist Stagger IV"), DS(50, "Topple: Decoy IV"), DS(100, "Terrain Damage Reducer IV")],
[DS(10, "Evasion Up IV"), DS(25, "Max TP Up IV"), DS(30, "Untouchable Dash IV"), DS(30, "Resist Gravity Res Down IV"), DS(50, "Resist Knockback IV"), DS(100, "Resist Launch IV")],
[DS(5, "Max TP Boost VI"), DS(15, "Resist Stagger VI"), DS(30, "Topple: Decoy VI"), DS(100, "Terrain Damage Reducer VI")],
[DS(5, "Evasion Up VI"), DS(15, "Max TP Up VI"), DS(20, "Untouchable Dash VI"), DS(20, "Resist Gravity Res Down VI"), DS(30, "Resist Knockback VI"), DS(100, "Resist Launch VI")],
[DS(10, "Weather Master VI"), DS(25, "EXP Boost VI"), DS(50, "Resist Stun VI"), DS(100, "Taunt: Decoy VI")],
[DS(10, "Treasure Sensor VI"), DS(25, "Potential Boost VI"), DS(100, "Potential Up VI")],
[DS(5, "Weather Master VIII"), DS(15, "EXP Boost VIII"), DS(30, "Resist Stun VIII"), DS(100, "Taunt: Decoy VIII")],
[DS(5, "Treasure Sensor VIII"), DS(15, "Potential Boost VIII"), DS(100, "Potential Up VIII")],
[DS(10, "Weather Master VIII"), DS(25, "EXP Boost VIII"), DS(50, "Resist Stun VIII"), DS(100, "Taunt: Decoy VIII")],
[DS(10, "Treasure Sensor VIII"), DS(25, "Potential Boost VIII"), DS(100, "Potential Up VIII")],
[DS(5, "Weather Master X"), DS(15, "EXP Boost X"), DS(30, "Resist Stun X"), DS(100, "Taunt: Decoy X")],
[DS(5, "Treasure Sensor X"), DS(15, "Potential Boost X"), DS(100, "Potential Up X")],
[DS(10, "Crimson Aurora Screen"), DS(20, "Reflect: Gravity"), DS(30, "Max HP Boost VI"), DS(50, "Resist Flinch VI"), DS(100, "Resist HP Recovery Down VI")],
[DS(10, "Debuff Suppressor VI"), DS(20, "Reflect Damage Up VI"), DS(30, "Resist Virus VI"), DS(30, "Incapacitation Surge VI"), DS(50, "Danger Surge VI"), DS(100, "Max HP Up VI")],
[DS(5, "Crimson Aurora Screen"), DS(10, "Reflect: Gravity"), DS(15, "Max HP Boost VIII"), DS(25, "Resist Flinch VIII"), DS(100, "Resist HP Recovery Down VIII")],
[DS(5, "Debuff Suppressor VIII"), DS(10, "Reflect Damage Up VIII"), DS(15, "Resist Virus VIII"), DS(15, "Incapacitation Surge VIII"), DS(25, "Danger Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(10, "Crimson Aurora Screen"), DS(20, "Reflect: Gravity"), DS(30, "Max HP Boost VIII"), DS(50, "Resist Flinch VIII"), DS(100, "Resist HP Recovery Down VIII")],
[DS(10, "Debuff Suppressor VIII"), DS(20, "Reflect Damage Up VIII"), DS(30, "Resist Virus VIII"), DS(30, "Incapacitation Surge VIII"), DS(50, "Danger Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(5, "Crimson Aurora Screen"), DS(10, "Reflect: Gravity"), DS(15, "Max HP Boost X"), DS(25, "Resist Flinch X"), DS(100, "Resist HP Recovery Down X")],
[DS(5, "Debuff Suppressor X"), DS(10, "Reflect Damage Up X"), DS(15, "Resist Virus X"), DS(15, "Incapacitation Surge X"), DS(25, "Danger Surge X"), DS(100, "Max HP Up X")],
[DS(10, "Aura: Refuel VI"), DS(20, "Ranged Draw Surge VI"), DS(30, "Art Draw Surge VI"), DS(100, "Ranged Attack Up VI")],
[DS(10, "Overdrive Green Bonus"), DS(20, "Back Attack Plus VI"), DS(30, "Gravity Resistance Up VI"), DS(30, "Artful Execution Surge VI"), DS(100, "Max HP Up VI")],
[DS(5, "Aura: Refuel VIII"), DS(10, "Ranged Draw Surge VIII"), DS(15, "Art Draw Surge VIII"), DS(100, "Ranged Attack Up VIII")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Back Attack Plus VIII"), DS(15, "Gravity Resistance Up VIII"), DS(30, "Artful Execution Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(10, "Aura: Refuel VIII"), DS(20, "Ranged Draw Surge VIII"), DS(30, "Art Draw Surge VIII"), DS(100, "Ranged Attack Up VIII")],
[DS(10, "Overdrive Green Bonus"), DS(20, "Back Attack Plus VIII"), DS(30, "Gravity Resistance Up VIII"), DS(30, "Artful Execution Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(5, "Aura: Refuel X"), DS(10, "Ranged Draw Surge X"), DS(15, "Art Draw Surge X"), DS(100, "Ranged Attack Up X")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Back Attack Plus X"), DS(15, "Gravity Resistance Up X"), DS(30, "Artful Execution Surge X"), DS(100, "Max HP Up X")],
[DS(10, "Aura: Refuel VI"), DS(20, "Extend Overdrive VI"), DS(30, "Extend Critical Power VI"), DS(100, "Ranged Attack Up VI")],
[DS(10, "Overdrive Count Up VI"), DS(20, "Vantage Attack Plus VI"), DS(30, "Gravity Resistance Up VI"), DS(30, "Underdog Surge VI"), DS(100, "Max TP Up VI")],
[DS(5, "Aura: Refuel VIII"), DS(10, "Extend Overdrive VIII"), DS(15, "Extend Critical Power VIII"), DS(100, "Ranged Attack Up VIII")],
[DS(5, "Overdrive Count Up VIII"), DS(10, "Vantage Attack Plus VIII"), DS(15, "Gravity Resistance Up VIII"), DS(30, "Underdog Surge VIII"), DS(100, "Max TP Up VIII")],
[DS(10, "Aura: Refuel VIII"), DS(20, "Extend Overdrive VIII"), DS(30, "Extend Critical Power VIII"), DS(100, "Ranged Attack Up VIII")],
[DS(10, "Overdrive Count Up VIII"), DS(20, "Vantage Attack Plus VIII"), DS(30, "Gravity Resistance Up VIII"), DS(30, "Underdog Surge VIII"), DS(100, "Max TP Up VIII")],
[DS(5, "Aura: Refuel X"), DS(10, "Extend Overdrive X"), DS(15, "Extend Critical Power X"), DS(100, "Ranged Attack Up X")],
[DS(5, "Overdrive Count Up X"), DS(10, "Vantage Attack Plus X"), DS(15, "Gravity Resistance Up X"), DS(30, "Underdog Surge X"), DS(100, "Max TP Up X")],
[DS(10, "Max TP Boost VI"), DS(25, "Resist Stagger VI"), DS(50, "Topple: Decoy VI"), DS(100, "Terrain Damage Reducer VI")],
[DS(10, "Evasion Up VI"), DS(25, "Max TP Up VI"), DS(30, "Untouchable Dash VI"), DS(30, "Resist Gravity Res Down VI"), DS(50, "Resist Knockback VI"), DS(100, "Resist Launch VI")],
[DS(5, "Max TP Boost VIII"), DS(15, "Resist Stagger VIII"), DS(30, "Topple: Decoy VIII"), DS(100, "Terrain Damage Reducer VIII")],
[DS(5, "Evasion Up VIII"), DS(15, "Max TP Up VIII"), DS(20, "Untouchable Dash VIII"), DS(20, "Resist Gravity Res Down VIII"), DS(30, "Resist Knockback VIII"), DS(100, "Resist Launch VIII")],
[DS(10, "Max TP Boost VIII"), DS(25, "Resist Stagger VIII"), DS(50, "Topple: Decoy VIII"), DS(100, "Terrain Damage Reducer VIII")],
[DS(10, "Evasion Up VIII"), DS(25, "Max TP Up VIII"), DS(30, "Untouchable Dash VIII"), DS(30, "Resist Gravity Res Down VIII"), DS(50, "Resist Knockback VIII"), DS(100, "Resist Launch VIII")],
[DS(5, "Max TP Boost X"), DS(15, "Resist Stagger X"), DS(30, "Topple: Decoy X"), DS(100, "Terrain Damage Reducer X")],
[DS(5, "Evasion Up X"), DS(15, "Max TP Up X"), DS(20, "Untouchable Dash X"), DS(20, "Resist Gravity Res Down X"), DS(30, "Resist Knockback X"), DS(100, "Resist Launch X")],
[DS(10, "Weather Master X"), DS(25, "EXP Boost X"), DS(50, "Resist Stun X"), DS(100, "Taunt: Decoy X")],
[DS(10, "Treasure Sensor X"), DS(25, "Potential Boost X"), DS(100, "Potential Up X")],
[DS(5, "Weather Master XII"), DS(15, "EXP Boost XII"), DS(30, "Resist Stun XII"), DS(100, "Taunt: Decoy XII")],
[DS(5, "Treasure Sensor XII"), DS(15, "Potential Boost XII"), DS(100, "Potential Up XII")],
[DS(5, "Weather Master XII"), DS(15, "EXP Boost XII"), DS(30, "Resist Stun XII"), DS(100, "Taunt: Decoy XII")],
[DS(5, "Treasure Sensor XII"), DS(15, "Potential Boost XII"), DS(100, "Potential Up XII")],
[DS(5, "Weather Master XIV"), DS(15, "EXP Boost XIV"), DS(30, "Resist Stun XIV"), DS(100, "Taunt: Decoy XIV")],
[DS(5, "Treasure Sensor XIV"), DS(15, "Potential Boost XIV"), DS(100, "Potential Up XIV")],
[DS(10, "Crimson Aurora Screen"), DS(20, "Reflect: Gravity"), DS(30, "Max HP Boost X"), DS(50, "Resist Flinch X"), DS(100, "Resist HP Recovery Down X")],
[DS(10, "Debuff Suppressor X"), DS(20, "Reflect Damage Up X"), DS(30, "Resist Virus X"), DS(30, "Incapacitation Surge X"), DS(50, "Danger Surge X"), DS(100, "Max HP Up X")],
[DS(5, "Crimson Aurora Screen"), DS(10, "Reflect: Gravity"), DS(15, "Max HP Boost XII"), DS(25, "Resist Flinch XII"), DS(100, "Resist HP Recovery Down XII")],
[DS(5, "Debuff Suppressor XII"), DS(10, "Reflect Damage Up XII"), DS(15, "Resist Virus XII"), DS(15, "Incapacitation Surge XII"), DS(25, "Danger Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "Crimson Aurora Screen"), DS(10, "Reflect: Gravity"), DS(15, "Max HP Boost XII"), DS(25, "Resist Flinch XII"), DS(100, "Resist HP Recovery Down XII")],
[DS(5, "Debuff Suppressor XII"), DS(10, "Reflect Damage Up XII"), DS(15, "Resist Virus XII"), DS(15, "Incapacitation Surge XII"), DS(25, "Danger Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "Crimson Aurora Screen"), DS(10, "Reflect: Gravity"), DS(15, "Max HP Boost XIV"), DS(25, "Resist Flinch XIV"), DS(100, "Resist HP Recovery Down XIV")],
[DS(5, "Debuff Suppressor XIV"), DS(10, "Reflect Damage Up XIV"), DS(15, "Resist Virus XIV"), DS(15, "Incapacitation Surge XIV"), DS(25, "Danger Surge XIV"), DS(100, "Max HP Up XIV")],
[DS(10, "Aura: Refuel X"), DS(20, "Ranged Draw Surge X"), DS(30, "Art Draw Surge X"), DS(100, "Ranged Attack Up X")],
[DS(10, "Overdrive Green Bonus"), DS(20, "Back Attack Plus X"), DS(30, "Gravity Resistance Up X"), DS(30, "Artful Execution Surge X"), DS(100, "Max HP Up X")],
[DS(5, "Aura: Refuel XII"), DS(10, "Ranged Draw Surge XII"), DS(15, "Art Draw Surge XII"), DS(100, "Ranged Attack Up XII")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Back Attack Plus XII"), DS(15, "Gravity Resistance Up XII"), DS(30, "Artful Execution Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "Aura: Refuel XII"), DS(10, "Ranged Draw Surge XII"), DS(15, "Art Draw Surge XII"), DS(100, "Ranged Attack Up XII")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Back Attack Plus XII"), DS(15, "Gravity Resistance Up XII"), DS(30, "Artful Execution Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "Aura: Refuel XIV"), DS(10, "Ranged Draw Surge XIV"), DS(15, "Art Draw Surge XIV"), DS(100, "Ranged Attack Up XIV")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Back Attack Plus XIV"), DS(15, "Gravity Resistance Up XIV"), DS(30, "Artful Execution Surge XIV"), DS(100, "Max HP Up XIV")],
[DS(10, "Aura: Refuel X"), DS(20, "Extend Overdrive X"), DS(30, "Extend Critical Power X"), DS(100, "Ranged Attack Up X")],
[DS(10, "Overdrive Count Up X"), DS(20, "Vantage Attack Plus X"), DS(30, "Gravity Resistance Up X"), DS(30, "Underdog Surge X"), DS(100, "Max TP Up X")],
[DS(5, "Aura: Refuel XII"), DS(10, "Extend Overdrive XII"), DS(15, "Extend Critical Power XII"), DS(100, "Ranged Attack Up XII")],
[DS(5, "Overdrive Count Up XII"), DS(10, "Vantage Attack Plus XII"), DS(15, "Gravity Resistance Up XII"), DS(30, "Underdog Surge XII"), DS(100, "Max TP Up XII")],
[DS(5, "Aura: Refuel XII"), DS(10, "Extend Overdrive XII"), DS(15, "Extend Critical Power XII"), DS(100, "Ranged Attack Up XII")],
[DS(5, "Overdrive Count Up XII"), DS(10, "Vantage Attack Plus XII"), DS(15, "Gravity Resistance Up XII"), DS(30, "Underdog Surge XII"), DS(100, "Max TP Up XII")],
[DS(5, "Aura: Refuel XIV"), DS(10, "Extend Overdrive XIV"), DS(15, "Extend Critical Power XIV"), DS(100, "Ranged Attack Up XIV")],
[DS(5, "Overdrive Count Up XIV"), DS(10, "Vantage Attack Plus XIV"), DS(15, "Gravity Resistance Up XIV"), DS(30, "Underdog Surge XIV"), DS(100, "Max TP Up XIV")],
[DS(10, "Max TP Boost X"), DS(25, "Resist Stagger X"), DS(50, "Topple: Decoy X"), DS(100, "Terrain Damage Reducer X")],
[DS(10, "Evasion Up X"), DS(25, "Max TP Up X"), DS(30, "Untouchable Dash X"), DS(30, "Resist Gravity Res Down X"), DS(50, "Resist Knockback X"), DS(100, "Resist Launch X")],
[DS(5, "Max TP Boost XII"), DS(15, "Resist Stagger XII"), DS(30, "Topple: Decoy XII"), DS(100, "Terrain Damage Reducer XII")],
[DS(5, "Evasion Up XII"), DS(15, "Max TP Up XII"), DS(20, "Untouchable Dash XII"), DS(20, "Resist Gravity Res Down XII"), DS(30, "Resist Knockback XII"), DS(100, "Resist Launch XII")],
[DS(5, "Max TP Boost XII"), DS(15, "Resist Stagger XII"), DS(30, "Topple: Decoy XII"), DS(100, "Terrain Damage Reducer XII")],
[DS(5, "Evasion Up XII"), DS(15, "Max TP Up XII"), DS(20, "Untouchable Dash XII"), DS(20, "Resist Gravity Res Down XII"), DS(30, "Resist Knockback XII"), DS(100, "Resist Launch XII")],
[DS(5, "Max TP Boost XIV"), DS(15, "Resist Stagger XIV"), DS(30, "Topple: Decoy XIV"), DS(100, "Terrain Damage Reducer XIV")],
[DS(5, "Evasion Up XIV"), DS(15, "Max TP Up XIV"), DS(20, "Untouchable Dash XIV"), DS(20, "Resist Gravity Res Down XIV"), DS(30, "Resist Knockback XIV"), DS(100, "Resist Launch XIV")],
[DS(10, "Weather Master II"), DS(25, "EXP Boost II"), DS(50, "Resist Control II"), DS(100, "Taunt: Supercharge II")],
[DS(10, "Treasure Sensor II"), DS(25, "Potential Boost II"), DS(100, "Potential Up II")],
[DS(5, "Weather Master IV"), DS(15, "EXP Boost IV"), DS(30, "Resist Control IV"), DS(100, "Taunt: Supercharge IV")],
[DS(5, "Treasure Sensor IV"), DS(15, "Potential Boost IV"), DS(100, "Potential Up IV")],
[DS(10, "Weather Master IV"), DS(25, "EXP Boost IV"), DS(50, "Resist Control IV"), DS(100, "Taunt: Supercharge IV")],
[DS(10, "Treasure Sensor IV"), DS(25, "Potential Boost IV"), DS(100, "Potential Up IV")],
[DS(5, "Weather Master VI"), DS(15, "EXP Boost VI"), DS(30, "Resist Control VI"), DS(100, "Taunt: Supercharge VI")],
[DS(5, "Treasure Sensor VI"), DS(15, "Potential Boost VI"), DS(100, "Potential Up VI")],
[DS(10, "Brimstone Rain Screen"), DS(20, "Reflect: Thermal"), DS(30, "Resist HP Recovery Down II"), DS(50, "Resist Flinch II"), DS(100, "Resist Thermal Res Down II")],
[DS(10, "Aura Rapid Cooldown II"), DS(20, "HP Rebound II"), DS(30, "Resist Blaze II"), DS(30, "Incapacitation Surge II"), DS(50, "High Danger Surge II"), DS(100, "Max HP Up II")],
[DS(5, "Brimstone Rain Screen"), DS(10, "Reflect: Thermal"), DS(15, "Resist HP Recovery Down IV"), DS(25, "Resist Flinch IV"), DS(100, "Resist Thermal Res Down IV")],
[DS(5, "Aura Rapid Cooldown IV"), DS(10, "HP Rebound IV"), DS(15, "Resist Blaze IV"), DS(15, "Incapacitation Surge IV"), DS(25, "High Danger Surge IV"), DS(100, "Max HP Up IV")],
[DS(10, "Brimstone Rain Screen"), DS(20, "Reflect: Thermal"), DS(30, "Resist HP Recovery Down IV"), DS(50, "Resist Flinch IV"), DS(100, "Resist Thermal Res Down IV")],
[DS(10, "Aura Rapid Cooldown IV"), DS(20, "HP Rebound IV"), DS(30, "Resist Blaze IV"), DS(30, "Incapacitation Surge IV"), DS(50, "High Danger Surge IV"), DS(100, "Max HP Up IV")],
[DS(5, "Brimstone Rain Screen"), DS(10, "Reflect: Thermal"), DS(15, "Resist HP Recovery Down VI"), DS(25, "Resist Flinch VI"), DS(100, "Resist Thermal Res Down VI")],
[DS(5, "Aura Rapid Cooldown VI"), DS(10, "HP Rebound VI"), DS(15, "Resist Blaze VI"), DS(15, "Incapacitation Surge VI"), DS(25, "High Danger Surge VI"), DS(100, "Max HP Up VI")],
[DS(10, "Overdrive: Recover HP II"), DS(20, "Melee Draw Surge II"), DS(30, "Underdog Surge II"), DS(100, "Melee Attack Boost II")],
[DS(10, "Overdrive Green Bonus"), DS(20, "Front Attack Plus II"), DS(30, "Thermal Resistance Up II"), DS(30, "Crush Surge II"), DS(100, "Max HP Up II")],
[DS(5, "Overdrive: Recover HP IV"), DS(10, "Melee Draw Surge IV"), DS(15, "Underdog Surge IV"), DS(100, "Melee Attack Boost IV")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Front Attack Plus IV"), DS(15, "Thermal Resistance Up IV"), DS(30, "Crush Surge IV"), DS(100, "Max HP Up IV")],
[DS(10, "Overdrive: Recover HP IV"), DS(20, "Melee Draw Surge IV"), DS(30, "Underdog Surge IV"), DS(100, "Melee Attack Boost IV")],
[DS(10, "Overdrive Green Bonus"), DS(20, "Front Attack Plus IV"), DS(30, "Thermal Resistance Up IV"), DS(30, "Crush Surge IV"), DS(100, "Max HP Up IV")],
[DS(5, "Overdrive: Recover HP VI"), DS(10, "Melee Draw Surge VI"), DS(15, "Underdog Surge VI"), DS(100, "Melee Attack Boost VI")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Front Attack Plus VI"), DS(15, "Thermal Resistance Up VI"), DS(30, "Crush Surge VI"), DS(100, "Max HP Up VI")],
[DS(10, "Overdrive: Recover HP II"), DS(20, "Aura Surge II"), DS(30, "Critical Surge II"), DS(100, "Melee Attack Boost II")],
[DS(10, "Extend Overdrive II"), DS(20, "Vantage Attack Plus II"), DS(30, "Thermal Resistance Up II"), DS(30, "Aura: Refuel II"), DS(100, "Max TP Up II")],
[DS(5, "Overdrive: Recover HP IV"), DS(10, "Aura Surge IV"), DS(15, "Critical Surge IV"), DS(100, "Melee Attack Boost IV")],
[DS(5, "Extend Overdrive IV"), DS(10, "Vantage Attack Plus IV"), DS(15, "Thermal Resistance Up IV"), DS(30, "Aura: Refuel IV"), DS(100, "Max TP Up IV")],
[DS(10, "Overdrive: Recover HP IV"), DS(20, "Aura Surge IV"), DS(30, "Critical Surge IV"), DS(100, "Melee Attack Boost IV")],
[DS(10, "Extend Overdrive IV"), DS(20, "Vantage Attack Plus IV"), DS(30, "Thermal Resistance Up IV"), DS(30, "Aura: Refuel IV"), DS(100, "Max TP Up IV")],
[DS(5, "Overdrive: Recover HP VI"), DS(10, "Aura Surge VI"), DS(15, "Critical Surge VI"), DS(100, "Melee Attack Boost VI")],
[DS(5, "Extend Overdrive VI"), DS(10, "Vantage Attack Plus VI"), DS(15, "Thermal Resistance Up VI"), DS(30, "Aura: Refuel VI"), DS(100, "Max TP Up VI")],
[DS(10, "Max TP Boost II"), DS(25, "TP Rebound II"), DS(50, "Topple: Decoy II"), DS(100, "Resist Launch II")],
[DS(10, "Evasion Boost II"), DS(25, "Focused Evasion II"), DS(30, "Terrain Damage Reducer II"), DS(30, "Resist Gravity Res Down II"), DS(50, "Resist Stagger II"), DS(100, "Resist Knockback II")],
[DS(5, "Max TP Boost IV"), DS(15, "TP Rebound IV"), DS(30, "Topple: Decoy IV"), DS(100, "Resist Launch IV")],
[DS(5, "Evasion Boost IV"), DS(15, "Focused Evasion IV"), DS(20, "Terrain Damage Reducer IV"), DS(20, "Resist Gravity Res Down IV"), DS(30, "Resist Stagger IV"), DS(100, "Resist Knockback IV")],
[DS(10, "Max TP Boost IV"), DS(25, "TP Rebound IV"), DS(50, "Topple: Decoy IV"), DS(100, "Resist Launch IV")],
[DS(10, "Evasion Boost IV"), DS(25, "Focused Evasion IV"), DS(30, "Terrain Damage Reducer IV"), DS(30, "Resist Gravity Res Down IV"), DS(50, "Resist Stagger IV"), DS(100, "Resist Knockback IV")],
[DS(5, "Max TP Boost VI"), DS(15, "TP Rebound VI"), DS(30, "Topple: Decoy VI"), DS(100, "Resist Launch VI")],
[DS(5, "Evasion Boost VI"), DS(15, "Focused Evasion VI"), DS(20, "Terrain Damage Reducer VI"), DS(20, "Resist Gravity Res Down VI"), DS(30, "Resist Stagger VI"), DS(100, "Resist Knockback VI")],
[DS(10, "Weather Master VI"), DS(25, "EXP Boost VI"), DS(50, "Resist Control VI"), DS(100, "Taunt: Supercharge VI")],
[DS(10, "Treasure Sensor VI"), DS(25, "Potential Boost VI"), DS(100, "Potential Up VI")],
[DS(5, "Weather Master VIII"), DS(15, "EXP Boost VIII"), DS(30, "Resist Control VIII"), DS(100, "Taunt: Supercharge VIII")],
[DS(5, "Treasure Sensor VIII"), DS(15, "Potential Boost VIII"), DS(100, "Potential Up VIII")],
[DS(10, "Weather Master VIII"), DS(25, "EXP Boost VIII"), DS(50, "Resist Control VIII"), DS(100, "Taunt: Supercharge VIII")],
[DS(10, "Treasure Sensor VIII"), DS(25, "Potential Boost VIII"), DS(100, "Potential Up VIII")],
[DS(5, "Weather Master X"), DS(15, "EXP Boost X"), DS(30, "Resist Control X"), DS(100, "Taunt: Supercharge X")],
[DS(5, "Treasure Sensor X"), DS(15, "Potential Boost X"), DS(100, "Potential Up X")],
[DS(10, "Brimstone Rain Screen"), DS(20, "Reflect: Thermal"), DS(30, "Resist HP Recovery Down VI"), DS(50, "Resist Flinch VI"), DS(100, "Resist Thermal Res Down VI")],
[DS(10, "Aura Rapid Cooldown VI"), DS(20, "HP Rebound VI"), DS(30, "Resist Blaze VI"), DS(30, "Incapacitation Surge VI"), DS(50, "High Danger Surge VI"), DS(100, "Max HP Up VI")],
[DS(5, "Brimstone Rain Screen"), DS(10, "Reflect: Thermal"), DS(15, "Resist HP Recovery Down VIII"), DS(25, "Resist Flinch VIII"), DS(100, "Resist Thermal Res Down VIII")],
[DS(5, "Aura Rapid Cooldown VIII"), DS(10, "HP Rebound VIII"), DS(15, "Resist Blaze VIII"), DS(15, "Incapacitation Surge VIII"), DS(25, "High Danger Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(10, "Brimstone Rain Screen"), DS(20, "Reflect: Thermal"), DS(30, "Resist HP Recovery Down VIII"), DS(50, "Resist Flinch VIII"), DS(100, "Resist Thermal Res Down VIII")],
[DS(10, "Aura Rapid Cooldown VIII"), DS(20, "HP Rebound VIII"), DS(30, "Resist Blaze VIII"), DS(30, "Incapacitation Surge VIII"), DS(50, "High Danger Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(5, "Brimstone Rain Screen"), DS(10, "Reflect: Thermal"), DS(15, "Resist HP Recovery Down X"), DS(25, "Resist Flinch X"), DS(100, "Resist Thermal Res Down X")],
[DS(5, "Aura Rapid Cooldown X"), DS(10, "HP Rebound X"), DS(15, "Resist Blaze X"), DS(15, "Incapacitation Surge X"), DS(25, "High Danger Surge X"), DS(100, "Max HP Up X")],
[DS(10, "Overdrive: Recover HP VI"), DS(20, "Melee Draw Surge VI"), DS(30, "Underdog Surge VI"), DS(100, "Melee Attack Boost VI")],
[DS(10, "Overdrive Green Bonus"), DS(20, "Front Attack Plus VI"), DS(30, "Thermal Resistance Up VI"), DS(30, "Crush Surge VI"), DS(100, "Max HP Up VI")],
[DS(5, "Overdrive: Recover HP VIII"), DS(10, "Melee Draw Surge VIII"), DS(15, "Underdog Surge VIII"), DS(100, "Melee Attack Boost VIII")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Front Attack Plus VIII"), DS(15, "Thermal Resistance Up VIII"), DS(30, "Crush Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(10, "Overdrive: Recover HP VIII"), DS(20, "Melee Draw Surge VIII"), DS(30, "Underdog Surge VIII"), DS(100, "Melee Attack Boost VIII")],
[DS(10, "Overdrive Green Bonus"), DS(20, "Front Attack Plus VIII"), DS(30, "Thermal Resistance Up VIII"), DS(30, "Crush Surge VIII"), DS(100, "Max HP Up VIII")],
[DS(5, "Overdrive: Recover HP X"), DS(10, "Melee Draw Surge X"), DS(15, "Underdog Surge X"), DS(100, "Melee Attack Boost X")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Front Attack Plus X"), DS(15, "Thermal Resistance Up X"), DS(30, "Crush Surge X"), DS(100, "Max HP Up X")],
[DS(10, "Overdrive: Recover HP VI"), DS(20, "Aura Surge VI"), DS(30, "Critical Surge VI"), DS(100, "Melee Attack Boost VI")],
[DS(10, "Extend Overdrive VI"), DS(20, "Vantage Attack Plus VI"), DS(30, "Thermal Resistance Up VI"), DS(30, "Aura: Refuel VI"), DS(100, "Max TP Up VI")],
[DS(5, "Overdrive: Recover HP VIII"), DS(10, "Aura Surge VIII"), DS(15, "Critical Surge VIII"), DS(100, "Melee Attack Boost VIII")],
[DS(5, "Extend Overdrive VIII"), DS(10, "Vantage Attack Plus VIII"), DS(15, "Thermal Resistance Up VIII"), DS(30, "Aura: Refuel VIII"), DS(100, "Max TP Up VIII")],
[DS(10, "Overdrive: Recover HP VIII"), DS(20, "Aura Surge VIII"), DS(30, "Critical Surge VIII"), DS(100, "Melee Attack Boost VIII")],
[DS(10, "Extend Overdrive VIII"), DS(20, "Vantage Attack Plus VIII"), DS(30, "Thermal Resistance Up VIII"), DS(30, "Aura: Refuel VIII"), DS(100, "Max TP Up VIII")],
[DS(5, "Overdrive: Recover HP X"), DS(10, "Aura Surge X"), DS(15, "Critical Surge X"), DS(100, "Melee Attack Boost X")],
[DS(5, "Extend Overdrive X"), DS(10, "Vantage Attack Plus X"), DS(15, "Thermal Resistance Up X"), DS(30, "Aura: Refuel X"), DS(100, "Max TP Up X")],
[DS(10, "Max TP Boost VI"), DS(25, "TP Rebound VI"), DS(50, "Topple: Decoy VI"), DS(100, "Resist Launch VI")],
[DS(10, "Evasion Boost VI"), DS(25, "Focused Evasion VI"), DS(30, "Terrain Damage Reducer VI"), DS(30, "Resist Gravity Res Down VI"), DS(50, "Resist Stagger VI"), DS(100, "Resist Knockback VI")],
[DS(5, "Max TP Boost VIII"), DS(15, "TP Rebound VIII"), DS(30, "Topple: Decoy VIII"), DS(100, "Resist Launch VIII")],
[DS(5, "Evasion Boost VIII"), DS(15, "Focused Evasion VIII"), DS(20, "Terrain Damage Reducer VIII"), DS(20, "Resist Gravity Res Down VIII"), DS(30, "Resist Stagger VIII"), DS(100, "Resist Knockback VIII")],
[DS(10, "Max TP Boost VIII"), DS(25, "TP Rebound VIII"), DS(50, "Topple: Decoy VIII"), DS(100, "Resist Launch VIII")],
[DS(10, "Evasion Boost VIII"), DS(25, "Focused Evasion VIII"), DS(30, "Terrain Damage Reducer VIII"), DS(30, "Resist Gravity Res Down VIII"), DS(50, "Resist Stagger VIII"), DS(100, "Resist Knockback VIII")],
[DS(5, "Max TP Boost X"), DS(15, "TP Rebound X"), DS(30, "Topple: Decoy X"), DS(100, "Resist Launch X")],
[DS(5, "Evasion Boost X"), DS(15, "Focused Evasion X"), DS(20, "Terrain Damage Reducer X"), DS(20, "Resist Gravity Res Down X"), DS(30, "Resist Stagger X"), DS(100, "Resist Knockback X")],
[DS(10, "Weather Master X"), DS(25, "EXP Boost X"), DS(50, "Resist Control X"), DS(100, "Taunt: Supercharge X")],
[DS(10, "Treasure Sensor X"), DS(25, "Potential Boost X"), DS(100, "Potential Up X")],
[DS(5, "Weather Master XII"), DS(15, "EXP Boost XII"), DS(30, "Resist Control XII"), DS(100, "Taunt: Supercharge XII")],
[DS(5, "Treasure Sensor XII"), DS(15, "Potential Boost XII"), DS(100, "Potential Up XII")],
[DS(5, "Weather Master XII"), DS(15, "EXP Boost XII"), DS(30, "Resist Control XII"), DS(100, "Taunt: Supercharge XII")],
[DS(5, "Treasure Sensor XII"), DS(15, "Potential Boost XII"), DS(100, "Potential Up XII")],
[DS(5, "Weather Master XIV"), DS(15, "EXP Boost XIV"), DS(30, "Resist Control XIV"), DS(100, "Taunt: Supercharge XIV")],
[DS(5, "Treasure Sensor XIV"), DS(15, "Potential Boost XIV"), DS(100, "Potential Up XIV")],
[DS(10, "Brimstone Rain Screen"), DS(20, "Reflect: Thermal"), DS(30, "Resist HP Recovery Down X"), DS(50, "Resist Flinch X"), DS(100, "Resist Thermal Res Down X")],
[DS(10, "Aura Rapid Cooldown X"), DS(20, "HP Rebound X"), DS(30, "Resist Blaze X"), DS(30, "Incapacitation Surge X"), DS(50, "High Danger Surge X"), DS(100, "Max HP Up X")],
[DS(5, "Brimstone Rain Screen"), DS(10, "Reflect: Thermal"), DS(15, "Resist HP Recovery Down XII"), DS(25, "Resist Flinch XII"), DS(100, "Resist Thermal Res Down XII")],
[DS(5, "Aura Rapid Cooldown XII"), DS(10, "HP Rebound XII"), DS(15, "Resist Blaze XII"), DS(15, "Incapacitation Surge XII"), DS(25, "High Danger Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "Brimstone Rain Screen"), DS(10, "Reflect: Thermal"), DS(15, "Resist HP Recovery Down XII"), DS(25, "Resist Flinch XII"), DS(100, "Resist Thermal Res Down XII")],
[DS(5, "Aura Rapid Cooldown XII"), DS(10, "HP Rebound XII"), DS(15, "Resist Blaze XII"), DS(15, "Incapacitation Surge XII"), DS(25, "High Danger Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "Brimstone Rain Screen"), DS(10, "Reflect: Thermal"), DS(15, "Resist HP Recovery Down XIV"), DS(25, "Resist Flinch XIV"), DS(100, "Resist Thermal Res Down XIV")],
[DS(5, "Aura Rapid Cooldown XIV"), DS(10, "HP Rebound XIV"), DS(15, "Resist Blaze XIV"), DS(15, "Incapacitation Surge XIV"), DS(25, "High Danger Surge XIV"), DS(100, "Max HP Up XIV")],
[DS(10, "Overdrive: Recover HP X"), DS(20, "Melee Draw Surge X"), DS(30, "Underdog Surge X"), DS(100, "Melee Attack Boost X")],
[DS(10, "Overdrive Green Bonus"), DS(20, "Front Attack Plus X"), DS(30, "Thermal Resistance Up X"), DS(30, "Crush Surge X"), DS(100, "Max HP Up X")],
[DS(5, "Overdrive: Recover HP XII"), DS(10, "Melee Draw Surge XII"), DS(15, "Underdog Surge XII"), DS(100, "Melee Attack Boost XII")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Front Attack Plus XII"), DS(15, "Thermal Resistance Up XII"), DS(30, "Crush Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "Overdrive: Recover HP XII"), DS(10, "Melee Draw Surge XII"), DS(15, "Underdog Surge XII"), DS(100, "Melee Attack Boost XII")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Front Attack Plus XII"), DS(15, "Thermal Resistance Up XII"), DS(30, "Crush Surge XII"), DS(100, "Max HP Up XII")],
[DS(5, "Overdrive: Recover HP XIV"), DS(10, "Melee Draw Surge XIV"), DS(15, "Underdog Surge XIV"), DS(100, "Melee Attack Boost XIV")],
[DS(5, "Overdrive Green Bonus"), DS(10, "Front Attack Plus XIV"), DS(15, "Thermal Resistance Up XIV"), DS(30, "Crush Surge XIV"), DS(100, "Max HP Up XIV")],
[DS(10, "Overdrive: Recover HP X"), DS(20, "Aura Surge X"), DS(30, "Critical Surge X"), DS(100, "Melee Attack Boost X")],
[DS(10, "Extend Overdrive X"), DS(20, "Vantage Attack Plus X"), DS(30, "Thermal Resistance Up X"), DS(30, "Aura: Refuel X"), DS(100, "Max TP Up X")],
[DS(5, "Overdrive: Recover HP XII"), DS(10, "Aura Surge XII"), DS(15, "Critical Surge XII"), DS(100, "Melee Attack Boost XII")],
[DS(5, "Extend Overdrive XII"), DS(10, "Vantage Attack Plus XII"), DS(15, "Thermal Resistance Up XII"), DS(30, "Aura: Refuel XII"), DS(100, "Max TP Up XII")],
[DS(5, "Overdrive: Recover HP XII"), DS(10, "Aura Surge XII"), DS(15, "Critical Surge XII"), DS(100, "Melee Attack Boost XII")],
[DS(5, "Extend Overdrive XII"), DS(10, "Vantage Attack Plus XII"), DS(15, "Thermal Resistance Up XII"), DS(30, "Aura: Refuel XII"), DS(100, "Max TP Up XII")],
[DS(5, "Overdrive: Recover HP XIV"), DS(10, "Aura Surge XIV"), DS(15, "Critical Surge XIV"), DS(100, "Melee Attack Boost XIV")],
[DS(5, "Extend Overdrive XIV"), DS(10, "Vantage Attack Plus XIV"), DS(15, "Thermal Resistance Up XIV"), DS(30, "Aura: Refuel XIV"), DS(100, "Max TP Up XIV")],
[DS(10, "Max TP Boost X"), DS(25, "TP Rebound X"), DS(50, "Topple: Decoy X"), DS(100, "Resist Launch X")],
[DS(10, "Evasion Boost X"), DS(25, "Focused Evasion X"), DS(30, "Terrain Damage Reducer X"), DS(30, "Resist Gravity Res Down X"), DS(50, "Resist Stagger X"), DS(100, "Resist Knockback X")],
[DS(5, "Max TP Boost XII"), DS(15, "TP Rebound XII"), DS(30, "Topple: Decoy XII"), DS(100, "Resist Launch XII")],
[DS(5, "Evasion Boost XII"), DS(15, "Focused Evasion XII"), DS(20, "Terrain Damage Reducer XII"), DS(20, "Resist Gravity Res Down XII"), DS(30, "Resist Stagger XII"), DS(100, "Resist Knockback XII")],
[DS(5, "Max TP Boost XII"), DS(15, "TP Rebound XII"), DS(30, "Topple: Decoy XII"), DS(100, "Resist Launch XII")],
[DS(5, "Evasion Boost XII"), DS(15, "Focused Evasion XII"), DS(20, "Terrain Damage Reducer XII"), DS(20, "Resist Gravity Res Down XII"), DS(30, "Resist Stagger XII"), DS(100, "Resist Knockback XII")],
[DS(5, "Max TP Boost XIV"), DS(15, "TP Rebound XIV"), DS(30, "Topple: Decoy XIV"), DS(100, "Resist Launch XIV")],
[DS(5, "Evasion Boost XIV"), DS(15, "Focused Evasion XIV"), DS(20, "Terrain Damage Reducer XIV"), DS(20, "Resist Gravity Res Down XIV"), DS(30, "Resist Stagger XIV"), DS(100, "Resist Knockback XIV")],
[DS(10, "Weather Master II"), DS(25, "Resist Control II"), DS(50, "Potential Up II"), DS(100, "EXP Boost II")],
[DS(10, "Treasure Sensor II"), DS(25, "Potential Drive II"), DS(100, "Bind: Refuel II")],
[DS(5, "Weather Master IV"), DS(15, "Resist Control IV"), DS(30, "Potential Up IV"), DS(100, "EXP Boost IV")],
[DS(5, "Treasure Sensor IV"), DS(15, "Potential Drive IV"), DS(100, "Bind: Refuel IV")],
[DS(10, "Weather Master IV"), DS(25, "Resist Control IV"), DS(50, "Potential Up IV"), DS(100, "EXP Boost IV")],
[DS(10, "Treasure Sensor IV"), DS(25, "Potential Drive IV"), DS(100, "Bind: Refuel IV")],
[DS(5, "Weather Master VI"), DS(15, "Resist Control VI"), DS(30, "Potential Up VI"), DS(100, "EXP Boost VI")],
[DS(5, "Treasure Sensor VI"), DS(15, "Potential Drive VI"), DS(100, "Bind: Refuel VI")],
[DS(10, "Reinvigorate II"), DS(20, "Reflect: Physical"), DS(30, "Max HP Boost II"), DS(50, "Resist Flinch II"), DS(100, "Resist Physical Res Down II")],
[DS(10, "Aura Rapid Cooldown II"), DS(20, "HP Rebound II"), DS(30, "Incapacitation Surge II"), DS(30, "High Danger Surge II"), DS(50, "Danger Surge II"), DS(100, "Max HP Drive II")],
[DS(5, "Reinvigorate IV"), DS(10, "Reflect: Physical"), DS(15, "Max HP Boost IV"), DS(25, "Resist Flinch IV"), DS(100, "Resist Physical Res Down IV")],
[DS(5, "Aura Rapid Cooldown IV"), DS(10, "HP Rebound IV"), DS(15, "Incapacitation Surge IV"), DS(15, "High Danger Surge IV"), DS(25, "Danger Surge IV"), DS(100, "Max HP Drive IV")],
[DS(10, "Reinvigorate IV"), DS(20, "Reflect: Physical"), DS(30, "Max HP Boost IV"), DS(50, "Resist Flinch IV"), DS(100, "Resist Physical Res Down IV")],
[DS(10, "Aura Rapid Cooldown IV"), DS(20, "HP Rebound IV"), DS(30, "Incapacitation Surge IV"), DS(30, "High Danger Surge IV"), DS(50, "Danger Surge IV"), DS(100, "Max HP Drive IV")],
[DS(5, "Reinvigorate VI"), DS(10, "Reflect: Physical"), DS(15, "Max HP Boost VI"), DS(25, "Resist Flinch VI"), DS(100, "Resist Physical Res Down VI")],
[DS(5, "Aura Rapid Cooldown VI"), DS(10, "HP Rebound VI"), DS(15, "Incapacitation Surge VI"), DS(15, "High Danger Surge VI"), DS(25, "Danger Surge VI"), DS(100, "Max HP Drive VI")],
[DS(10, "Overdrive: Recover HP II"), DS(20, "Melee Draw Surge II"), DS(30, "Artful Execution Surge II"), DS(100, "Melee Accuracy Drive II")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Front Attack Plus II"), DS(30, "Max HP Up II"), DS(30, "Crush Surge II"), DS(100, "Melee Attack Drive II")],
[DS(5, "Overdrive: Recover HP IV"), DS(10, "Melee Draw Surge IV"), DS(15, "Artful Execution Surge IV"), DS(100, "Melee Accuracy Drive IV")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Front Attack Plus IV"), DS(15, "Max HP Up IV"), DS(30, "Crush Surge IV"), DS(100, "Melee Attack Drive IV")],
[DS(10, "Overdrive: Recover HP IV"), DS(20, "Melee Draw Surge IV"), DS(30, "Artful Execution Surge IV"), DS(100, "Melee Accuracy Drive IV")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Front Attack Plus IV"), DS(30, "Max HP Up IV"), DS(30, "Crush Surge IV"), DS(100, "Melee Attack Drive IV")],
[DS(5, "Overdrive: Recover HP VI"), DS(10, "Melee Draw Surge VI"), DS(15, "Artful Execution Surge VI"), DS(100, "Melee Accuracy Drive VI")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Front Attack Plus VI"), DS(15, "Max HP Up VI"), DS(30, "Crush Surge VI"), DS(100, "Melee Attack Drive VI")],
[DS(10, "Overdrive: Recover HP II"), DS(20, "Art Draw Surge II"), DS(30, "Overdrive Surge II"), DS(100, "Melee Accuracy Drive II")],
[DS(10, "Secondary CD Reducer II"), DS(20, "Vantage Attack Plus II"), DS(30, "Max TP Up II"), DS(30, "Underdog Surge II"), DS(100, "Melee Attack Drive II")],
[DS(5, "Overdrive: Recover HP IV"), DS(10, "Art Draw Surge IV"), DS(15, "Overdrive Surge IV"), DS(100, "Melee Accuracy Drive IV")],
[DS(5, "Secondary CD Reducer IV"), DS(10, "Vantage Attack Plus IV"), DS(15, "Max TP Up IV"), DS(30, "Underdog Surge IV"), DS(100, "Melee Attack Drive IV")],
[DS(10, "Overdrive: Recover HP IV"), DS(20, "Art Draw Surge IV"), DS(30, "Overdrive Surge IV"), DS(100, "Melee Accuracy Drive IV")],
[DS(10, "Secondary CD Reducer IV"), DS(20, "Vantage Attack Plus IV"), DS(30, "Max TP Up IV"), DS(30, "Underdog Surge IV"), DS(100, "Melee Attack Drive IV")],
[DS(5, "Overdrive: Recover HP VI"), DS(10, "Art Draw Surge VI"), DS(15, "Overdrive Surge VI"), DS(100, "Melee Accuracy Drive VI")],
[DS(5, "Secondary CD Reducer VI"), DS(10, "Vantage Attack Plus VI"), DS(15, "Max TP Up VI"), DS(30, "Underdog Surge VI"), DS(100, "Melee Attack Drive VI")],
[DS(10, "TP Rebound II"), DS(25, "Topple: Barrier II"), DS(50, "Resist Stagger II"), DS(100, "Max GP Drive II")],
[DS(10, "Evasion Boost II"), DS(25, "Focused Evasion II"), DS(30, "Terrain Damage Reducer II"), DS(30, "Resist Topple II"), DS(50, "Resist Launch II"), DS(100, "Resistance Reducer II")],
[DS(5, "TP Rebound IV"), DS(15, "Topple: Barrier IV"), DS(30, "Resist Stagger IV"), DS(100, "Max GP Drive IV")],
[DS(5, "Evasion Boost IV"), DS(15, "Focused Evasion IV"), DS(20, "Terrain Damage Reducer IV"), DS(20, "Resist Topple IV"), DS(30, "Resist Launch IV"), DS(100, "Resistance Reducer IV")],
[DS(10, "TP Rebound IV"), DS(25, "Topple: Barrier IV"), DS(50, "Resist Stagger IV"), DS(100, "Max GP Drive IV")],
[DS(10, "Evasion Boost IV"), DS(25, "Focused Evasion IV"), DS(30, "Terrain Damage Reducer IV"), DS(30, "Resist Topple IV"), DS(50, "Resist Launch IV"), DS(100, "Resistance Reducer IV")],
[DS(5, "TP Rebound VI"), DS(15, "Topple: Barrier VI"), DS(30, "Resist Stagger VI"), DS(100, "Max GP Drive VI")],
[DS(5, "Evasion Boost VI"), DS(15, "Focused Evasion VI"), DS(20, "Terrain Damage Reducer VI"), DS(20, "Resist Topple VI"), DS(30, "Resist Launch VI"), DS(100, "Resistance Reducer VI")],
[DS(10, "Weather Master VI"), DS(25, "Resist Control VI"), DS(50, "Potential Up VI"), DS(100, "EXP Boost VI")],
[DS(10, "Treasure Sensor VI"), DS(25, "Potential Drive VI"), DS(100, "Bind: Refuel VI")],
[DS(5, "Weather Master VIII"), DS(15, "Resist Control VIII"), DS(30, "Potential Up VIII"), DS(100, "EXP Boost VIII")],
[DS(5, "Treasure Sensor VIII"), DS(15, "Potential Drive VIII"), DS(100, "Bind: Refuel VIII")],
[DS(10, "Weather Master VIII"), DS(25, "Resist Control VIII"), DS(50, "Potential Up VIII"), DS(100, "EXP Boost VIII")],
[DS(10, "Treasure Sensor VIII"), DS(25, "Potential Drive VIII"), DS(100, "Bind: Refuel VIII")],
[DS(5, "Weather Master X"), DS(15, "Resist Control X"), DS(30, "Potential Up X"), DS(100, "EXP Boost X")],
[DS(5, "Treasure Sensor X"), DS(15, "Potential Drive X"), DS(100, "Bind: Refuel X")],
[DS(10, "Reinvigorate VI"), DS(20, "Reflect: Physical"), DS(30, "Max HP Boost VI"), DS(50, "Resist Flinch VI"), DS(100, "Resist Physical Res Down VI")],
[DS(10, "Aura Rapid Cooldown VI"), DS(20, "HP Rebound VI"), DS(30, "Incapacitation Surge VI"), DS(30, "High Danger Surge VI"), DS(50, "Danger Surge VI"), DS(100, "Max HP Drive VI")],
[DS(5, "Reinvigorate VIII"), DS(10, "Reflect: Physical"), DS(15, "Max HP Boost VIII"), DS(25, "Resist Flinch VIII"), DS(100, "Resist Physical Res Down VIII")],
[DS(5, "Aura Rapid Cooldown VIII"), DS(10, "HP Rebound VIII"), DS(15, "Incapacitation Surge VIII"), DS(15, "High Danger Surge VIII"), DS(25, "Danger Surge VIII"), DS(100, "Max HP Drive VIII")],
[DS(10, "Reinvigorate VIII"), DS(20, "Reflect: Physical"), DS(30, "Max HP Boost VIII"), DS(50, "Resist Flinch VIII"), DS(100, "Resist Physical Res Down VIII")],
[DS(10, "Aura Rapid Cooldown VIII"), DS(20, "HP Rebound VIII"), DS(30, "Incapacitation Surge VIII"), DS(30, "High Danger Surge VIII"), DS(50, "Danger Surge VIII"), DS(100, "Max HP Drive VIII")],
[DS(5, "Reinvigorate X"), DS(10, "Reflect: Physical"), DS(15, "Max HP Boost X"), DS(25, "Resist Flinch X"), DS(100, "Resist Physical Res Down X")],
[DS(5, "Aura Rapid Cooldown X"), DS(10, "HP Rebound X"), DS(15, "Incapacitation Surge X"), DS(15, "High Danger Surge X"), DS(25, "Danger Surge X"), DS(100, "Max HP Drive X")],
[DS(10, "Overdrive: Recover HP VI"), DS(20, "Melee Draw Surge VI"), DS(30, "Artful Execution Surge VI"), DS(100, "Melee Accuracy Drive VI")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Front Attack Plus VI"), DS(30, "Max HP Up VI"), DS(30, "Crush Surge VI"), DS(100, "Melee Attack Drive VI")],
[DS(5, "Overdrive: Recover HP VIII"), DS(10, "Melee Draw Surge VIII"), DS(15, "Artful Execution Surge VIII"), DS(100, "Melee Accuracy Drive VIII")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Front Attack Plus VIII"), DS(15, "Max HP Up VIII"), DS(30, "Crush Surge VIII"), DS(100, "Melee Attack Drive VIII")],
[DS(10, "Overdrive: Recover HP VIII"), DS(20, "Melee Draw Surge VIII"), DS(30, "Artful Execution Surge VIII"), DS(100, "Melee Accuracy Drive VIII")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Front Attack Plus VIII"), DS(30, "Max HP Up VIII"), DS(30, "Crush Surge VIII"), DS(100, "Melee Attack Drive VIII")],
[DS(5, "Overdrive: Recover HP X"), DS(10, "Melee Draw Surge X"), DS(15, "Artful Execution Surge X"), DS(100, "Melee Accuracy Drive X")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Front Attack Plus X"), DS(15, "Max HP Up X"), DS(30, "Crush Surge X"), DS(100, "Melee Attack Drive X")],
[DS(10, "Overdrive: Recover HP VI"), DS(20, "Art Draw Surge VI"), DS(30, "Overdrive Surge VI"), DS(100, "Melee Accuracy Drive VI")],
[DS(10, "Secondary CD Reducer VI"), DS(20, "Vantage Attack Plus VI"), DS(30, "Max TP Up VI"), DS(30, "Underdog Surge VI"), DS(100, "Melee Attack Drive VI")],
[DS(5, "Overdrive: Recover HP VIII"), DS(10, "Art Draw Surge VIII"), DS(15, "Overdrive Surge VIII"), DS(100, "Melee Accuracy Drive VIII")],
[DS(5, "Secondary CD Reducer VIII"), DS(10, "Vantage Attack Plus VIII"), DS(15, "Max TP Up VIII"), DS(30, "Underdog Surge VIII"), DS(100, "Melee Attack Drive VIII")],
[DS(10, "Overdrive: Recover HP VIII"), DS(20, "Art Draw Surge VIII"), DS(30, "Overdrive Surge VIII"), DS(100, "Melee Accuracy Drive VIII")],
[DS(10, "Secondary CD Reducer VIII"), DS(20, "Vantage Attack Plus VIII"), DS(30, "Max TP Up VIII"), DS(30, "Underdog Surge VIII"), DS(100, "Melee Attack Drive VIII")],
[DS(5, "Overdrive: Recover HP X"), DS(10, "Art Draw Surge X"), DS(15, "Overdrive Surge X"), DS(100, "Melee Accuracy Drive X")],
[DS(5, "Secondary CD Reducer X"), DS(10, "Vantage Attack Plus X"), DS(15, "Max TP Up X"), DS(30, "Underdog Surge X"), DS(100, "Melee Attack Drive X")],
[DS(10, "TP Rebound VI"), DS(25, "Topple: Barrier VI"), DS(50, "Resist Stagger VI"), DS(100, "Max GP Drive VI")],
[DS(10, "Evasion Boost VI"), DS(25, "Focused Evasion VI"), DS(30, "Terrain Damage Reducer VI"), DS(30, "Resist Topple VI"), DS(50, "Resist Launch VI"), DS(100, "Resistance Reducer VI")],
[DS(5, "TP Rebound VIII"), DS(15, "Topple: Barrier VIII"), DS(30, "Resist Stagger VIII"), DS(100, "Max GP Drive VIII")],
[DS(5, "Evasion Boost VIII"), DS(15, "Focused Evasion VIII"), DS(20, "Terrain Damage Reducer VIII"), DS(20, "Resist Topple VIII"), DS(30, "Resist Launch VIII"), DS(100, "Resistance Reducer VIII")],
[DS(10, "TP Rebound VIII"), DS(25, "Topple: Barrier VIII"), DS(50, "Resist Stagger VIII"), DS(100, "Max GP Drive VIII")],
[DS(10, "Evasion Boost VIII"), DS(25, "Focused Evasion VIII"), DS(30, "Terrain Damage Reducer VIII"), DS(30, "Resist Topple VIII"), DS(50, "Resist Launch VIII"), DS(100, "Resistance Reducer VIII")],
[DS(5, "TP Rebound X"), DS(15, "Topple: Barrier X"), DS(30, "Resist Stagger X"), DS(100, "Max GP Drive X")],
[DS(5, "Evasion Boost X"), DS(15, "Focused Evasion X"), DS(20, "Terrain Damage Reducer X"), DS(20, "Resist Topple X"), DS(30, "Resist Launch X"), DS(100, "Resistance Reducer X")],
[DS(10, "Weather Master X"), DS(25, "Resist Control X"), DS(50, "Potential Up X"), DS(100, "EXP Boost X")],
[DS(10, "Treasure Sensor X"), DS(25, "Potential Drive X"), DS(100, "Bind: Refuel X")],
[DS(5, "Weather Master XII"), DS(15, "Resist Control XII"), DS(30, "Potential Up XII"), DS(100, "EXP Boost XII")],
[DS(5, "Treasure Sensor XII"), DS(15, "Potential Drive XII"), DS(100, "Bind: Refuel XII")],
[DS(5, "Weather Master XII"), DS(15, "Resist Control XII"), DS(30, "Potential Up XII"), DS(100, "EXP Boost XII")],
[DS(5, "Treasure Sensor XII"), DS(15, "Potential Drive XII"), DS(100, "Bind: Refuel XII")],
[DS(5, "Weather Master XIV"), DS(15, "Resist Control XIV"), DS(30, "Potential Up XIV"), DS(100, "EXP Boost XIV")],
[DS(5, "Treasure Sensor XIV"), DS(15, "Potential Drive XIV"), DS(100, "Bind: Refuel XIV")],
[DS(10, "Reinvigorate X"), DS(20, "Reflect: Physical"), DS(30, "Max HP Boost X"), DS(50, "Resist Flinch X"), DS(100, "Resist Physical Res Down X")],
[DS(10, "Aura Rapid Cooldown X"), DS(20, "HP Rebound X"), DS(30, "Incapacitation Surge X"), DS(30, "High Danger Surge X"), DS(50, "Danger Surge X"), DS(100, "Max HP Drive X")],
[DS(5, "Reinvigorate XII"), DS(10, "Reflect: Physical"), DS(15, "Max HP Boost XII"), DS(25, "Resist Flinch XII"), DS(100, "Resist Physical Res Down XII")],
[DS(5, "Aura Rapid Cooldown XII"), DS(10, "HP Rebound XII"), DS(15, "Incapacitation Surge XII"), DS(15, "High Danger Surge XII"), DS(25, "Danger Surge XII"), DS(100, "Max HP Drive XII")],
[DS(5, "Reinvigorate XII"), DS(10, "Reflect: Physical"), DS(15, "Max HP Boost XII"), DS(25, "Resist Flinch XII"), DS(100, "Resist Physical Res Down XII")],
[DS(5, "Aura Rapid Cooldown XII"), DS(10, "HP Rebound XII"), DS(15, "Incapacitation Surge XII"), DS(15, "High Danger Surge XII"), DS(25, "Danger Surge XII"), DS(100, "Max HP Drive XII")],
[DS(5, "Reinvigorate XIV"), DS(10, "Reflect: Physical"), DS(15, "Max HP Boost XIV"), DS(25, "Resist Flinch XIV"), DS(100, "Resist Physical Res Down XIV")],
[DS(5, "Aura Rapid Cooldown XIV"), DS(10, "HP Rebound XIV"), DS(15, "Incapacitation Surge XIV"), DS(15, "High Danger Surge XIV"), DS(25, "Danger Surge XIV"), DS(100, "Max HP Drive XIV")],
[DS(10, "Overdrive: Recover HP X"), DS(20, "Melee Draw Surge X"), DS(30, "Artful Execution Surge X"), DS(100, "Melee Accuracy Drive X")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Front Attack Plus X"), DS(30, "Max HP Up X"), DS(30, "Crush Surge X"), DS(100, "Melee Attack Drive X")],
[DS(5, "Overdrive: Recover HP XII"), DS(10, "Melee Draw Surge XII"), DS(15, "Artful Execution Surge XII"), DS(100, "Melee Accuracy Drive XII")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Front Attack Plus XII"), DS(15, "Max HP Up XII"), DS(30, "Crush Surge XII"), DS(100, "Melee Attack Drive XII")],
[DS(5, "Overdrive: Recover HP XII"), DS(10, "Melee Draw Surge XII"), DS(15, "Artful Execution Surge XII"), DS(100, "Melee Accuracy Drive XII")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Front Attack Plus XII"), DS(15, "Max HP Up XII"), DS(30, "Crush Surge XII"), DS(100, "Melee Attack Drive XII")],
[DS(5, "Overdrive: Recover HP XIV"), DS(10, "Melee Draw Surge XIV"), DS(15, "Artful Execution Surge XIV"), DS(100, "Melee Accuracy Drive XIV")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Front Attack Plus XIV"), DS(15, "Max HP Up XIV"), DS(30, "Crush Surge XIV"), DS(100, "Melee Attack Drive XIV")],
[DS(10, "Overdrive: Recover HP X"), DS(20, "Art Draw Surge X"), DS(30, "Overdrive Surge X"), DS(100, "Melee Accuracy Drive X")],
[DS(10, "Secondary CD Reducer X"), DS(20, "Vantage Attack Plus X"), DS(30, "Max TP Up X"), DS(30, "Underdog Surge X"), DS(100, "Melee Attack Drive X")],
[DS(5, "Overdrive: Recover HP XII"), DS(10, "Art Draw Surge XII"), DS(15, "Overdrive Surge XII"), DS(100, "Melee Accuracy Drive XII")],
[DS(5, "Secondary CD Reducer XII"), DS(10, "Vantage Attack Plus XII"), DS(15, "Max TP Up XII"), DS(30, "Underdog Surge XII"), DS(100, "Melee Attack Drive XII")],
[DS(5, "Overdrive: Recover HP XII"), DS(10, "Art Draw Surge XII"), DS(15, "Overdrive Surge XII"), DS(100, "Melee Accuracy Drive XII")],
[DS(5, "Secondary CD Reducer XII"), DS(10, "Vantage Attack Plus XII"), DS(15, "Max TP Up XII"), DS(30, "Underdog Surge XII"), DS(100, "Melee Attack Drive XII")],
[DS(5, "Overdrive: Recover HP XIV"), DS(10, "Art Draw Surge XIV"), DS(15, "Overdrive Surge XIV"), DS(100, "Melee Accuracy Drive XIV")],
[DS(5, "Secondary CD Reducer XIV"), DS(10, "Vantage Attack Plus XIV"), DS(15, "Max TP Up XIV"), DS(30, "Underdog Surge XIV"), DS(100, "Melee Attack Drive XIV")],
[DS(10, "TP Rebound X"), DS(25, "Topple: Barrier X"), DS(50, "Resist Stagger X"), DS(100, "Max GP Drive X")],
[DS(10, "Evasion Boost X"), DS(25, "Focused Evasion X"), DS(30, "Terrain Damage Reducer X"), DS(30, "Resist Topple X"), DS(50, "Resist Launch X"), DS(100, "Resistance Reducer X")],
[DS(5, "TP Rebound XII"), DS(15, "Topple: Barrier XII"), DS(30, "Resist Stagger XII"), DS(100, "Max GP Drive XII")],
[DS(5, "Evasion Boost XII"), DS(15, "Focused Evasion XII"), DS(20, "Terrain Damage Reducer XII"), DS(20, "Resist Topple XII"), DS(30, "Resist Launch XII"), DS(100, "Resistance Reducer XII")],
[DS(5, "TP Rebound XII"), DS(15, "Topple: Barrier XII"), DS(30, "Resist Stagger XII"), DS(100, "Max GP Drive XII")],
[DS(5, "Evasion Boost XII"), DS(15, "Focused Evasion XII"), DS(20, "Terrain Damage Reducer XII"), DS(20, "Resist Topple XII"), DS(30, "Resist Launch XII"), DS(100, "Resistance Reducer XII")],
[DS(5, "TP Rebound XIV"), DS(15, "Topple: Barrier XIV"), DS(30, "Resist Stagger XIV"), DS(100, "Max GP Drive XIV")],
[DS(5, "Evasion Boost XIV"), DS(15, "Focused Evasion XIV"), DS(20, "Terrain Damage Reducer XIV"), DS(20, "Resist Topple XIV"), DS(30, "Resist Launch XIV"), DS(100, "Resistance Reducer XIV")],
[DS(10, "Weather Master II"), DS(25, "Resist Blackout II"), DS(50, "Potential Up II"), DS(100, "EXP Boost II")],
[DS(10, "Treasure Sensor II"), DS(25, "Potential Drive II"), DS(100, "Fuel Efficiency Up II")],
[DS(5, "Weather Master IV"), DS(15, "Resist Blackout IV"), DS(30, "Potential Up IV"), DS(100, "EXP Boost IV")],
[DS(5, "Treasure Sensor IV"), DS(15, "Potential Drive IV"), DS(100, "Fuel Efficiency Up IV")],
[DS(10, "Weather Master IV"), DS(25, "Resist Blackout IV"), DS(50, "Potential Up IV"), DS(100, "EXP Boost IV")],
[DS(10, "Treasure Sensor IV"), DS(25, "Potential Drive IV"), DS(100, "Fuel Efficiency Up IV")],
[DS(5, "Weather Master VI"), DS(15, "Resist Blackout VI"), DS(30, "Potential Up VI"), DS(100, "EXP Boost VI")],
[DS(5, "Treasure Sensor VI"), DS(15, "Potential Drive VI"), DS(100, "Fuel Efficiency Up VI")],
[DS(10, "Debuff Suppressor II"), DS(20, "Reflect: Beam"), DS(30, "Max HP Boost II"), DS(50, "Danger Surge II"), DS(100, "Resist Beam Res Down II")],
[DS(10, "Extend Aura II"), DS(20, "HP Rebound II"), DS(30, "Resist HP Recovery Down II"), DS(30, "High Danger Surge II"), DS(50, "Incapacitation Surge II"), DS(100, "Max HP Drive II")],
[DS(5, "Debuff Suppressor IV"), DS(10, "Reflect: Beam"), DS(15, "Max HP Boost IV"), DS(25, "Danger Surge IV"), DS(100, "Resist Beam Res Down IV")],
[DS(5, "Extend Aura IV"), DS(10, "HP Rebound IV"), DS(15, "Resist HP Recovery Down IV"), DS(15, "High Danger Surge IV"), DS(25, "Incapacitation Surge IV"), DS(100, "Max HP Drive IV")],
[DS(10, "Debuff Suppressor IV"), DS(20, "Reflect: Beam"), DS(30, "Max HP Boost IV"), DS(50, "Danger Surge IV"), DS(100, "Resist Beam Res Down IV")],
[DS(10, "Extend Aura IV"), DS(20, "HP Rebound IV"), DS(30, "Resist HP Recovery Down IV"), DS(30, "High Danger Surge IV"), DS(50, "Incapacitation Surge IV"), DS(100, "Max HP Drive IV")],
[DS(5, "Debuff Suppressor VI"), DS(10, "Reflect: Beam"), DS(15, "Max HP Boost VI"), DS(25, "Danger Surge VI"), DS(100, "Resist Beam Res Down VI")],
[DS(5, "Extend Aura VI"), DS(10, "HP Rebound VI"), DS(15, "Resist HP Recovery Down VI"), DS(15, "High Danger Surge VI"), DS(25, "Incapacitation Surge VI"), DS(100, "Max HP Drive VI")],
[DS(10, "Overdrive: Gain TP II"), DS(20, "Ranged Draw Surge II"), DS(30, "Artful Execution Surge II"), DS(100, "Ranged Accuracy Drive II")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Side Attack Plus II"), DS(30, "Max HP Up II"), DS(30, "Critical Surge II"), DS(100, "Ranged Attack Drive II")],
[DS(5, "Overdrive: Gain TP IV"), DS(10, "Ranged Draw Surge IV"), DS(15, "Artful Execution Surge IV"), DS(100, "Ranged Accuracy Drive IV")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus IV"), DS(15, "Max HP Up IV"), DS(30, "Critical Surge IV"), DS(100, "Ranged Attack Drive IV")],
[DS(10, "Overdrive: Gain TP IV"), DS(20, "Ranged Draw Surge IV"), DS(30, "Artful Execution Surge IV"), DS(100, "Ranged Accuracy Drive IV")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Side Attack Plus IV"), DS(30, "Max HP Up IV"), DS(30, "Critical Surge IV"), DS(100, "Ranged Attack Drive IV")],
[DS(5, "Overdrive: Gain TP VI"), DS(10, "Ranged Draw Surge VI"), DS(15, "Artful Execution Surge VI"), DS(100, "Ranged Accuracy Drive VI")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus VI"), DS(15, "Max HP Up VI"), DS(30, "Critical Surge VI"), DS(100, "Ranged Attack Drive VI")],
[DS(10, "Overdrive: Gain TP II"), DS(20, "Art Draw Surge II"), DS(30, "Overdrive Surge II"), DS(100, "Ranged Accuracy Drive II")],
[DS(10, "Secondary CD Reducer II"), DS(20, "Vantage Attack Plus II"), DS(30, "Max TP Up II"), DS(30, "Aura Surge II"), DS(100, "Ranged Attack Drive II")],
[DS(5, "Overdrive: Gain TP IV"), DS(10, "Art Draw Surge IV"), DS(15, "Overdrive Surge IV"), DS(100, "Ranged Accuracy Drive IV")],
[DS(5, "Secondary CD Reducer IV"), DS(10, "Vantage Attack Plus IV"), DS(15, "Max TP Up IV"), DS(30, "Aura Surge IV"), DS(100, "Ranged Attack Drive IV")],
[DS(10, "Overdrive: Gain TP IV"), DS(20, "Art Draw Surge IV"), DS(30, "Overdrive Surge IV"), DS(100, "Ranged Accuracy Drive IV")],
[DS(10, "Secondary CD Reducer IV"), DS(20, "Vantage Attack Plus IV"), DS(30, "Max TP Up IV"), DS(30, "Aura Surge IV"), DS(100, "Ranged Attack Drive IV")],
[DS(5, "Overdrive: Gain TP VI"), DS(10, "Art Draw Surge VI"), DS(15, "Overdrive Surge VI"), DS(100, "Ranged Accuracy Drive VI")],
[DS(5, "Secondary CD Reducer VI"), DS(10, "Vantage Attack Plus VI"), DS(15, "Max TP Up VI"), DS(30, "Aura Surge VI"), DS(100, "Ranged Attack Drive VI")],
[DS(10, "TP Rebound II"), DS(25, "Topple: Decoy II"), DS(50, "Resist Stagger II"), DS(100, "Max TP Up II")],
[DS(10, "Evasion Boost II"), DS(25, "Visual Cloaking II"), DS(30, "Resistance Reducer II"), DS(30, "Terrain Damage Reducer II"), DS(50, "Evasion Drive II"), DS(100, "Untouchable Dash II")],
[DS(5, "TP Rebound IV"), DS(15, "Topple: Decoy IV"), DS(30, "Resist Stagger IV"), DS(100, "Max TP Up IV")],
[DS(5, "Evasion Boost IV"), DS(15, "Visual Cloaking IV"), DS(20, "Resistance Reducer IV"), DS(20, "Terrain Damage Reducer IV"), DS(30, "Evasion Drive IV"), DS(100, "Untouchable Dash IV")],
[DS(10, "TP Rebound IV"), DS(25, "Topple: Decoy IV"), DS(50, "Resist Stagger IV"), DS(100, "Max TP Up IV")],
[DS(10, "Evasion Boost IV"), DS(25, "Visual Cloaking IV"), DS(30, "Resistance Reducer IV"), DS(30, "Terrain Damage Reducer IV"), DS(50, "Evasion Drive IV"), DS(100, "Untouchable Dash IV")],
[DS(5, "TP Rebound VI"), DS(15, "Topple: Decoy VI"), DS(30, "Resist Stagger VI"), DS(100, "Max TP Up VI")],
[DS(5, "Evasion Boost VI"), DS(15, "Visual Cloaking VI"), DS(20, "Resistance Reducer VI"), DS(20, "Terrain Damage Reducer VI"), DS(30, "Evasion Drive VI"), DS(100, "Untouchable Dash VI")],
[DS(10, "Weather Master VI"), DS(25, "Resist Blackout VI"), DS(50, "Potential Up VI"), DS(100, "EXP Boost VI")],
[DS(10, "Treasure Sensor VI"), DS(25, "Potential Drive VI"), DS(100, "Fuel Efficiency Up VI")],
[DS(5, "Weather Master VIII"), DS(15, "Resist Blackout VIII"), DS(30, "Potential Up VIII"), DS(100, "EXP Boost VIII")],
[DS(5, "Treasure Sensor VIII"), DS(15, "Potential Drive VIII"), DS(100, "Fuel Efficiency Up VIII")],
[DS(10, "Weather Master VIII"), DS(25, "Resist Blackout VIII"), DS(50, "Potential Up VIII"), DS(100, "EXP Boost VIII")],
[DS(10, "Treasure Sensor VIII"), DS(25, "Potential Drive VIII"), DS(100, "Fuel Efficiency Up VIII")],
[DS(5, "Weather Master X"), DS(15, "Resist Blackout X"), DS(30, "Potential Up X"), DS(100, "EXP Boost X")],
[DS(5, "Treasure Sensor X"), DS(15, "Potential Drive X"), DS(100, "Fuel Efficiency Up X")],
[DS(10, "Debuff Suppressor VI"), DS(20, "Reflect: Beam"), DS(30, "Max HP Boost VI"), DS(50, "Danger Surge VI"), DS(100, "Resist Beam Res Down VI")],
[DS(10, "Extend Aura VI"), DS(20, "HP Rebound VI"), DS(30, "Resist HP Recovery Down VI"), DS(30, "High Danger Surge VI"), DS(50, "Incapacitation Surge VI"), DS(100, "Max HP Drive VI")],
[DS(5, "Debuff Suppressor VIII"), DS(10, "Reflect: Beam"), DS(15, "Max HP Boost VIII"), DS(25, "Danger Surge VIII"), DS(100, "Resist Beam Res Down VIII")],
[DS(5, "Extend Aura VIII"), DS(10, "HP Rebound VIII"), DS(15, "Resist HP Recovery Down VIII"), DS(15, "High Danger Surge VIII"), DS(25, "Incapacitation Surge VIII"), DS(100, "Max HP Drive VIII")],
[DS(10, "Debuff Suppressor VIII"), DS(20, "Reflect: Beam"), DS(30, "Max HP Boost VIII"), DS(50, "Danger Surge VIII"), DS(100, "Resist Beam Res Down VIII")],
[DS(10, "Extend Aura VIII"), DS(20, "HP Rebound VIII"), DS(30, "Resist HP Recovery Down VIII"), DS(30, "High Danger Surge VIII"), DS(50, "Incapacitation Surge VIII"), DS(100, "Max HP Drive VIII")],
[DS(5, "Debuff Suppressor X"), DS(10, "Reflect: Beam"), DS(15, "Max HP Boost X"), DS(25, "Danger Surge X"), DS(100, "Resist Beam Res Down X")],
[DS(5, "Extend Aura X"), DS(10, "HP Rebound X"), DS(15, "Resist HP Recovery Down X"), DS(15, "High Danger Surge X"), DS(25, "Incapacitation Surge X"), DS(100, "Max HP Drive X")],
[DS(10, "Overdrive: Gain TP VI"), DS(20, "Ranged Draw Surge VI"), DS(30, "Artful Execution Surge VI"), DS(100, "Ranged Accuracy Drive VI")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Side Attack Plus VI"), DS(30, "Max HP Up VI"), DS(30, "Critical Surge VI"), DS(100, "Ranged Attack Drive VI")],
[DS(5, "Overdrive: Gain TP VIII"), DS(10, "Ranged Draw Surge VIII"), DS(15, "Artful Execution Surge VIII"), DS(100, "Ranged Accuracy Drive VIII")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus VIII"), DS(15, "Max HP Up VIII"), DS(30, "Critical Surge VIII"), DS(100, "Ranged Attack Drive VIII")],
[DS(10, "Overdrive: Gain TP VIII"), DS(20, "Ranged Draw Surge VIII"), DS(30, "Artful Execution Surge VIII"), DS(100, "Ranged Accuracy Drive VIII")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Side Attack Plus VIII"), DS(30, "Max HP Up VIII"), DS(30, "Critical Surge VIII"), DS(100, "Ranged Attack Drive VIII")],
[DS(5, "Overdrive: Gain TP X"), DS(10, "Ranged Draw Surge X"), DS(15, "Artful Execution Surge X"), DS(100, "Ranged Accuracy Drive X")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus X"), DS(15, "Max HP Up X"), DS(30, "Critical Surge X"), DS(100, "Ranged Attack Drive X")],
[DS(10, "Overdrive: Gain TP VI"), DS(20, "Art Draw Surge VI"), DS(30, "Overdrive Surge VI"), DS(100, "Ranged Accuracy Drive VI")],
[DS(10, "Secondary CD Reducer VI"), DS(20, "Vantage Attack Plus VI"), DS(30, "Max TP Up VI"), DS(30, "Aura Surge VI"), DS(100, "Ranged Attack Drive VI")],
[DS(5, "Overdrive: Gain TP VIII"), DS(10, "Art Draw Surge VIII"), DS(15, "Overdrive Surge VIII"), DS(100, "Ranged Accuracy Drive VIII")],
[DS(5, "Secondary CD Reducer VIII"), DS(10, "Vantage Attack Plus VIII"), DS(15, "Max TP Up VIII"), DS(30, "Aura Surge VIII"), DS(100, "Ranged Attack Drive VIII")],
[DS(10, "Overdrive: Gain TP VIII"), DS(20, "Art Draw Surge VIII"), DS(30, "Overdrive Surge VIII"), DS(100, "Ranged Accuracy Drive VIII")],
[DS(10, "Secondary CD Reducer VIII"), DS(20, "Vantage Attack Plus VIII"), DS(30, "Max TP Up VIII"), DS(30, "Aura Surge VIII"), DS(100, "Ranged Attack Drive VIII")],
[DS(5, "Overdrive: Gain TP X"), DS(10, "Art Draw Surge X"), DS(15, "Overdrive Surge X"), DS(100, "Ranged Accuracy Drive X")],
[DS(5, "Secondary CD Reducer X"), DS(10, "Vantage Attack Plus X"), DS(15, "Max TP Up X"), DS(30, "Aura Surge X"), DS(100, "Ranged Attack Drive X")],
[DS(10, "TP Rebound VI"), DS(25, "Topple: Decoy VI"), DS(50, "Resist Stagger VI"), DS(100, "Max TP Up VI")],
[DS(10, "Evasion Boost VI"), DS(25, "Visual Cloaking VI"), DS(30, "Resistance Reducer VI"), DS(30, "Terrain Damage Reducer VI"), DS(50, "Evasion Drive VI"), DS(100, "Untouchable Dash VI")],
[DS(5, "TP Rebound VIII"), DS(15, "Topple: Decoy VIII"), DS(30, "Resist Stagger VIII"), DS(100, "Max TP Up VIII")],
[DS(5, "Evasion Boost VIII"), DS(15, "Visual Cloaking VIII"), DS(20, "Resistance Reducer VIII"), DS(20, "Terrain Damage Reducer VIII"), DS(30, "Evasion Drive VIII"), DS(100, "Untouchable Dash VIII")],
[DS(10, "TP Rebound VIII"), DS(25, "Topple: Decoy VIII"), DS(50, "Resist Stagger VIII"), DS(100, "Max TP Up VIII")],
[DS(10, "Evasion Boost VIII"), DS(25, "Visual Cloaking VIII"), DS(30, "Resistance Reducer VIII"), DS(30, "Terrain Damage Reducer VIII"), DS(50, "Evasion Drive VIII"), DS(100, "Untouchable Dash VIII")],
[DS(5, "TP Rebound X"), DS(15, "Topple: Decoy X"), DS(30, "Resist Stagger X"), DS(100, "Max TP Up X")],
[DS(5, "Evasion Boost X"), DS(15, "Visual Cloaking X"), DS(20, "Resistance Reducer X"), DS(20, "Terrain Damage Reducer X"), DS(30, "Evasion Drive X"), DS(100, "Untouchable Dash X")],
[DS(10, "Weather Master X"), DS(25, "Resist Blackout X"), DS(50, "Potential Up X"), DS(100, "EXP Boost X")],
[DS(10, "Treasure Sensor X"), DS(25, "Potential Drive X"), DS(100, "Fuel Efficiency Up X")],
[DS(5, "Weather Master XII"), DS(15, "Resist Blackout XII"), DS(30, "Potential Up XII"), DS(100, "EXP Boost XII")],
[DS(5, "Treasure Sensor XII"), DS(15, "Potential Drive XII"), DS(100, "Fuel Efficiency Up XII")],
[DS(5, "Weather Master XII"), DS(15, "Resist Blackout XII"), DS(30, "Potential Up XII"), DS(100, "EXP Boost XII")],
[DS(5, "Treasure Sensor XII"), DS(15, "Potential Drive XII"), DS(100, "Fuel Efficiency Up XII")],
[DS(5, "Weather Master XIV"), DS(15, "Resist Blackout XIV"), DS(30, "Potential Up XIV"), DS(100, "EXP Boost XIV")],
[DS(5, "Treasure Sensor XIV"), DS(15, "Potential Drive XIV"), DS(100, "Fuel Efficiency Up XIV")],
[DS(10, "Debuff Suppressor X"), DS(20, "Reflect: Beam"), DS(30, "Max HP Boost X"), DS(50, "Danger Surge X"), DS(100, "Resist Beam Res Down X")],
[DS(10, "Extend Aura X"), DS(20, "HP Rebound X"), DS(30, "Resist HP Recovery Down X"), DS(30, "High Danger Surge X"), DS(50, "Incapacitation Surge X"), DS(100, "Max HP Drive X")],
[DS(5, "Debuff Suppressor XII"), DS(10, "Reflect: Beam"), DS(15, "Max HP Boost XII"), DS(25, "Danger Surge XII"), DS(100, "Resist Beam Res Down XII")],
[DS(5, "Extend Aura XII"), DS(10, "HP Rebound XII"), DS(15, "Resist HP Recovery Down XII"), DS(15, "High Danger Surge XII"), DS(25, "Incapacitation Surge XII"), DS(100, "Max HP Drive XII")],
[DS(5, "Debuff Suppressor XII"), DS(10, "Reflect: Beam"), DS(15, "Max HP Boost XII"), DS(25, "Danger Surge XII"), DS(100, "Resist Beam Res Down XII")],
[DS(5, "Extend Aura XII"), DS(10, "HP Rebound XII"), DS(15, "Resist HP Recovery Down XII"), DS(15, "High Danger Surge XII"), DS(25, "Incapacitation Surge XII"), DS(100, "Max HP Drive XII")],
[DS(5, "Debuff Suppressor XIV"), DS(10, "Reflect: Beam"), DS(15, "Max HP Boost XIV"), DS(25, "Danger Surge XIV"), DS(100, "Resist Beam Res Down XIV")],
[DS(5, "Extend Aura XIV"), DS(10, "HP Rebound XIV"), DS(15, "Resist HP Recovery Down XIV"), DS(15, "High Danger Surge XIV"), DS(25, "Incapacitation Surge XIV"), DS(100, "Max HP Drive XIV")],
[DS(10, "Overdrive: Gain TP X"), DS(20, "Ranged Draw Surge X"), DS(30, "Artful Execution Surge X"), DS(100, "Ranged Accuracy Drive X")],
[DS(10, "Overdrive Blue Bonus"), DS(20, "Side Attack Plus X"), DS(30, "Max HP Up X"), DS(30, "Critical Surge X"), DS(100, "Ranged Attack Drive X")],
[DS(5, "Overdrive: Gain TP XII"), DS(10, "Ranged Draw Surge XII"), DS(15, "Artful Execution Surge XII"), DS(100, "Ranged Accuracy Drive XII")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus XII"), DS(15, "Max HP Up XII"), DS(30, "Critical Surge XII"), DS(100, "Ranged Attack Drive XII")],
[DS(5, "Overdrive: Gain TP XII"), DS(10, "Ranged Draw Surge XII"), DS(15, "Artful Execution Surge XII"), DS(100, "Ranged Accuracy Drive XII")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus XII"), DS(15, "Max HP Up XII"), DS(30, "Critical Surge XII"), DS(100, "Ranged Attack Drive XII")],
[DS(5, "Overdrive: Gain TP XIV"), DS(10, "Ranged Draw Surge XIV"), DS(15, "Artful Execution Surge XIV"), DS(100, "Ranged Accuracy Drive XIV")],
[DS(5, "Overdrive Blue Bonus"), DS(10, "Side Attack Plus XIV"), DS(15, "Max HP Up XIV"), DS(30, "Critical Surge XIV"), DS(100, "Ranged Attack Drive XIV")],
[DS(10, "Overdrive: Gain TP X"), DS(20, "Art Draw Surge X"), DS(30, "Overdrive Surge X"), DS(100, "Ranged Accuracy Drive X")],
[DS(10, "Secondary CD Reducer X"), DS(20, "Vantage Attack Plus X"), DS(30, "Max TP Up X"), DS(30, "Aura Surge X"), DS(100, "Ranged Attack Drive X")],
[DS(5, "Overdrive: Gain TP XII"), DS(10, "Art Draw Surge XII"), DS(15, "Overdrive Surge XII"), DS(100, "Ranged Accuracy Drive XII")],
[DS(5, "Secondary CD Reducer XII"), DS(10, "Vantage Attack Plus XII"), DS(15, "Max TP Up XII"), DS(30, "Aura Surge XII"), DS(100, "Ranged Attack Drive XII")],
[DS(5, "Overdrive: Gain TP XII"), DS(10, "Art Draw Surge XII"), DS(15, "Overdrive Surge XII"), DS(100, "Ranged Accuracy Drive XII")],
[DS(5, "Secondary CD Reducer XII"), DS(10, "Vantage Attack Plus XII"), DS(15, "Max TP Up XII"), DS(30, "Aura Surge XII"), DS(100, "Ranged Attack Drive XII")],
[DS(5, "Overdrive: Gain TP XIV"), DS(10, "Art Draw Surge XIV"), DS(15, "Overdrive Surge XIV"), DS(100, "Ranged Accuracy Drive XIV")],
[DS(5, "Secondary CD Reducer XIV"), DS(10, "Vantage Attack Plus XIV"), DS(15, "Max TP Up XIV"), DS(30, "Aura Surge XIV"), DS(100, "Ranged Attack Drive XIV")],
[DS(10, "TP Rebound X"), DS(25, "Topple: Decoy X"), DS(50, "Resist Stagger X"), DS(100, "Max TP Up X")],
[DS(10, "Evasion Boost X"), DS(25, "Visual Cloaking X"), DS(30, "Resistance Reducer X"), DS(30, "Terrain Damage Reducer X"), DS(50, "Evasion Drive X"), DS(100, "Untouchable Dash X")],
[DS(5, "TP Rebound XII"), DS(15, "Topple: Decoy XII"), DS(30, "Resist Stagger XII"), DS(100, "Max TP Up XII")],
[DS(5, "Evasion Boost XII"), DS(15, "Visual Cloaking XII"), DS(20, "Resistance Reducer XII"), DS(20, "Terrain Damage Reducer XII"), DS(30, "Evasion Drive XII"), DS(100, "Untouchable Dash XII")],
[DS(5, "TP Rebound XII"), DS(15, "Topple: Decoy XII"), DS(30, "Resist Stagger XII"), DS(100, "Max TP Up XII")],
[DS(5, "Evasion Boost XII"), DS(15, "Visual Cloaking XII"), DS(20, "Resistance Reducer XII"), DS(20, "Terrain Damage Reducer XII"), DS(30, "Evasion Drive XII"), DS(100, "Untouchable Dash XII")],
[DS(5, "TP Rebound XIV"), DS(15, "Topple: Decoy XIV"), DS(30, "Resist Stagger XIV"), DS(100, "Max TP Up XIV")],
[DS(5, "Evasion Boost XIV"), DS(15, "Visual Cloaking XIV"), DS(20, "Resistance Reducer XIV"), DS(20, "Terrain Damage Reducer XIV"), DS(30, "Evasion Drive XIV"), DS(100, "Untouchable Dash XIV")],
[DS(15, "Melee Accuracy Up III"), DS(10, "Evasion Up III"), DS(15, "Melee Attack Up III"), DS(10, "Potential Up III"), DS(10, "Chimeroid Slayer XV"), DS(20, "Debuff Suppressor XVI"), DS(20, "Critical Chance Up XVI"), DS(20, "Insectoid Criticals Up XVI"), DS(20, "Piscinoid Criticals Up XVI")],
[DS(15, "Melee Accuracy Up III"), DS(10, "Evasion Up III"), DS(15, "Melee Attack Up III"), DS(10, "Potential Up III"), DS(10, "Ultrafauna Slayer XV"), DS(20, "Debuff Suppressor XVI"), DS(20, "Critical Chance Up XVI"), DS(20, "Insectoid Criticals Up XVI"), DS(20, "Piscinoid Criticals Up XVI")],
[DS(15, "Melee Accuracy Up III"), DS(10, "Evasion Up III"), DS(15, "Melee Attack Up III"), DS(10, "Potential Up III"), DS(10, "Physical Attack Plus XV"), DS(20, "Debuff Suppressor XVI"), DS(20, "Critical Chance Up XVI"), DS(20, "Insectoid Criticals Up XVI"), DS(20, "Piscinoid Criticals Up XVI")],
[DS(15, "Melee Accuracy Up III"), DS(10, "Evasion Up III"), DS(15, "Melee Attack Up III"), DS(10, "Potential Up III"), DS(10, "Beam Attack Plus XV"), DS(20, "Debuff Suppressor XVI"), DS(20, "Critical Chance Up XVI"), DS(20, "Insectoid Criticals Up XVI"), DS(20, "Piscinoid Criticals Up XVI")],
[DS(15, "Melee Accuracy Up III"), DS(10, "Evasion Up III"), DS(15, "Melee Attack Up III"), DS(10, "Potential Up III"), DS(10, "Ether Attack Plus XV"), DS(20, "Debuff Suppressor XVI"), DS(20, "Critical Chance Up XVI"), DS(20, "Insectoid Criticals Up XVI"), DS(20, "Piscinoid Criticals Up XVI")],
[DS(15, "Melee Accuracy Up III"), DS(10, "Evasion Up III"), DS(15, "Melee Attack Up III"), DS(10, "Potential Up III"), DS(10, "Thermal Attack Plus XV"), DS(20, "Debuff Suppressor XVI"), DS(20, "Critical Chance Up XVI"), DS(20, "Insectoid Criticals Up XVI"), DS(20, "Piscinoid Criticals Up XVI")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Evasion Up V"), DS(15, "Melee Attack Up V"), DS(10, "Potential Up V"), DS(10, "Chimeroid Slayer XVII"), DS(20, "Debuff Suppressor XVIII"), DS(20, "Critical Chance Up XVIII"), DS(20, "Insectoid Criticals Up XVIII"), DS(20, "Piscinoid Criticals Up XVIII")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Evasion Up V"), DS(15, "Melee Attack Up V"), DS(10, "Potential Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(20, "Debuff Suppressor XVIII"), DS(20, "Critical Chance Up XVIII"), DS(20, "Insectoid Criticals Up XVIII"), DS(20, "Piscinoid Criticals Up XVIII")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Evasion Up V"), DS(15, "Melee Attack Up V"), DS(10, "Potential Up V"), DS(10, "Physical Attack Plus XVII"), DS(20, "Debuff Suppressor XVIII"), DS(20, "Critical Chance Up XVIII"), DS(20, "Insectoid Criticals Up XVIII"), DS(20, "Piscinoid Criticals Up XVIII")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Evasion Up V"), DS(15, "Melee Attack Up V"), DS(10, "Potential Up V"), DS(10, "Beam Attack Plus XVII"), DS(20, "Debuff Suppressor XVIII"), DS(20, "Critical Chance Up XVIII"), DS(20, "Insectoid Criticals Up XVIII"), DS(20, "Piscinoid Criticals Up XVIII")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Evasion Up V"), DS(15, "Melee Attack Up V"), DS(10, "Potential Up V"), DS(10, "Ether Attack Plus XVII"), DS(20, "Debuff Suppressor XVIII"), DS(20, "Critical Chance Up XVIII"), DS(20, "Insectoid Criticals Up XVIII"), DS(20, "Piscinoid Criticals Up XVIII")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Evasion Up V"), DS(15, "Melee Attack Up V"), DS(10, "Potential Up V"), DS(10, "Thermal Attack Plus XVII"), DS(20, "Debuff Suppressor XVIII"), DS(20, "Critical Chance Up XVIII"), DS(20, "Insectoid Criticals Up XVIII"), DS(20, "Piscinoid Criticals Up XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(15, "Melee Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Chimeroid Slayer XIX"), DS(20, "Debuff Suppressor XX"), DS(20, "Critical Chance Up XX"), DS(20, "Insectoid Criticals Up XX"), DS(20, "Piscinoid Criticals Up XX")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(15, "Melee Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(20, "Debuff Suppressor XX"), DS(20, "Critical Chance Up XX"), DS(20, "Insectoid Criticals Up XX"), DS(20, "Piscinoid Criticals Up XX")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(15, "Melee Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Physical Attack Plus XIX"), DS(20, "Debuff Suppressor XX"), DS(20, "Critical Chance Up XX"), DS(20, "Insectoid Criticals Up XX"), DS(20, "Piscinoid Criticals Up XX")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(15, "Melee Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Beam Attack Plus XIX"), DS(20, "Debuff Suppressor XX"), DS(20, "Critical Chance Up XX"), DS(20, "Insectoid Criticals Up XX"), DS(20, "Piscinoid Criticals Up XX")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(15, "Melee Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Ether Attack Plus XIX"), DS(20, "Debuff Suppressor XX"), DS(20, "Critical Chance Up XX"), DS(20, "Insectoid Criticals Up XX"), DS(20, "Piscinoid Criticals Up XX")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(15, "Melee Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Thermal Attack Plus XIX"), DS(20, "Debuff Suppressor XX"), DS(20, "Critical Chance Up XX"), DS(20, "Insectoid Criticals Up XX"), DS(20, "Piscinoid Criticals Up XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(15, "Melee Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Ultrafauna Slayer I"), DS(20, "Critical Chance Up II"), DS(20, "Theroid Criticals Up II"), DS(20, "Piscinoid Criticals Up II"), DS(20, "Humanoid Criticals Up II")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(15, "Melee Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Physical Attack Plus I"), DS(20, "Critical Chance Up II"), DS(20, "Theroid Criticals Up II"), DS(20, "Piscinoid Criticals Up II"), DS(20, "Humanoid Criticals Up II")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(15, "Melee Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Beam Attack Plus I"), DS(20, "Critical Chance Up II"), DS(20, "Theroid Criticals Up II"), DS(20, "Piscinoid Criticals Up II"), DS(20, "Humanoid Criticals Up II")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(15, "Melee Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Ether Attack Plus I"), DS(20, "Critical Chance Up II"), DS(20, "Theroid Criticals Up II"), DS(20, "Piscinoid Criticals Up II"), DS(20, "Humanoid Criticals Up II")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(15, "Melee Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Thermal Attack Plus I"), DS(20, "Critical Chance Up II"), DS(20, "Theroid Criticals Up II"), DS(20, "Piscinoid Criticals Up II"), DS(20, "Humanoid Criticals Up II")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(15, "Melee Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Electric Attack Plus I"), DS(20, "Critical Chance Up II"), DS(20, "Theroid Criticals Up II"), DS(20, "Piscinoid Criticals Up II"), DS(20, "Humanoid Criticals Up II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(15, "Melee Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Ultrafauna Slayer III"), DS(20, "Critical Chance Up IV"), DS(20, "Theroid Criticals Up IV"), DS(20, "Piscinoid Criticals Up IV"), DS(20, "Humanoid Criticals Up IV")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(15, "Melee Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Physical Attack Plus III"), DS(20, "Critical Chance Up IV"), DS(20, "Theroid Criticals Up IV"), DS(20, "Piscinoid Criticals Up IV"), DS(20, "Humanoid Criticals Up IV")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(15, "Melee Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Beam Attack Plus III"), DS(20, "Critical Chance Up IV"), DS(20, "Theroid Criticals Up IV"), DS(20, "Piscinoid Criticals Up IV"), DS(20, "Humanoid Criticals Up IV")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(15, "Melee Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Ether Attack Plus III"), DS(20, "Critical Chance Up IV"), DS(20, "Theroid Criticals Up IV"), DS(20, "Piscinoid Criticals Up IV"), DS(20, "Humanoid Criticals Up IV")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(15, "Melee Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Thermal Attack Plus III"), DS(20, "Critical Chance Up IV"), DS(20, "Theroid Criticals Up IV"), DS(20, "Piscinoid Criticals Up IV"), DS(20, "Humanoid Criticals Up IV")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(15, "Melee Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Electric Attack Plus III"), DS(20, "Critical Chance Up IV"), DS(20, "Theroid Criticals Up IV"), DS(20, "Piscinoid Criticals Up IV"), DS(20, "Humanoid Criticals Up IV")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Melee Attack Boost IV"), DS(15, "Ranged Attack Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Resist Shock XVII"), DS(15, "Electric Attack Plus XVI"), DS(15, "Gravity Attack Plus XVI"), DS(15, "Front Attack Plus XVI")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Melee Attack Boost IV"), DS(15, "Ranged Attack Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Resist Shock XVII"), DS(15, "Gravity Attack Plus XVI"), DS(15, "Front Attack Plus XVI"), DS(15, "Melee: Blaze XVI")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Melee Attack Boost IV"), DS(15, "Ranged Attack Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Gravity Attack Plus XVI"), DS(15, "Front Attack Plus XVI"), DS(15, "Ultrafauna Criticals Up XVII"), DS(15, "Extend Critical Power XVII"), DS(15, "Insectoid Slayer XVI"), DS(15, "Piscinoid Slayer XVI")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Melee Attack Boost IV"), DS(15, "Ranged Attack Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Resist Shock XVII"), DS(15, "Ultrafauna Criticals Up XVII"), DS(15, "Extend Critical Power XVII"), DS(15, "Insectoid Slayer XVI"), DS(15, "Piscinoid Slayer XVI")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Melee Attack Boost IV"), DS(15, "Ranged Attack Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Ultrafauna Criticals Up XVII"), DS(15, "Extend Critical Power XVII"), DS(15, "Insectoid Slayer XVI"), DS(15, "Piscinoid Slayer XVI"), DS(15, "Humanoid Slayer XVI"), DS(15, "Mechanoid Slayer XVI")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Melee Attack Boost IV"), DS(15, "Ranged Attack Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Resist Shock XVII"), DS(15, "Vantage Attack Plus XVI"), DS(15, "Melee: Ether Res Down XVI"), DS(15, "Melee: Gravity Res Down XVI")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Melee Attack Boost IV"), DS(15, "Ranged Attack Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Resist Shock XVII"), DS(15, "Back Attack Plus XVI"), DS(15, "Melee: Beam Res Down XVI"), DS(15, "Melee: Electric Res Down XVI")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Melee Attack Boost IV"), DS(15, "Ranged Attack Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Resist Shock XVII"), DS(15, "Vantage Attack Plus XVI"), DS(15, "Back Attack Plus XVI"), DS(15, "Melee: Blackout XVI")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Melee Attack Boost IV"), DS(15, "Ranged Attack Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Resist Shock XVII"), DS(15, "Vantage Attack Plus XVI"), DS(15, "Back Attack Plus XVI"), DS(15, "Melee: Fatigue XVI")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Melee Attack Boost IV"), DS(15, "Ranged Attack Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Resist Shock XVII"), DS(15, "Vantage Attack Plus XVI"), DS(15, "Back Attack Plus XVI"), DS(15, "Melee: Physical Res Down XVI")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Melee Attack Boost IV"), DS(15, "Ranged Attack Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Resist Shock XVII"), DS(15, "Vantage Attack Plus XVI"), DS(15, "Back Attack Plus XVI"), DS(15, "Melee: Thermal Res Down XVI")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Melee Attack Boost VI"), DS(15, "Ranged Attack Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Resist Shock XIX"), DS(15, "Electric Attack Plus XVIII"), DS(15, "Gravity Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Melee Attack Boost VI"), DS(15, "Ranged Attack Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Resist Shock XIX"), DS(15, "Gravity Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII"), DS(15, "Melee: Blaze XVIII")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Melee Attack Boost VI"), DS(15, "Ranged Attack Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Gravity Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII"), DS(15, "Ultrafauna Criticals Up XIX"), DS(15, "Extend Critical Power XIX"), DS(15, "Insectoid Slayer XVIII"), DS(15, "Piscinoid Slayer XVIII")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Melee Attack Boost VI"), DS(15, "Ranged Attack Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Resist Shock XIX"), DS(15, "Ultrafauna Criticals Up XIX"), DS(15, "Extend Critical Power XIX"), DS(15, "Insectoid Slayer XVIII"), DS(15, "Piscinoid Slayer XVIII")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Melee Attack Boost VI"), DS(15, "Ranged Attack Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Ultrafauna Criticals Up XIX"), DS(15, "Extend Critical Power XIX"), DS(15, "Insectoid Slayer XVIII"), DS(15, "Piscinoid Slayer XVIII"), DS(15, "Humanoid Slayer XVIII"), DS(15, "Mechanoid Slayer XVIII")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Melee Attack Boost VI"), DS(15, "Ranged Attack Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Resist Shock XIX"), DS(15, "Vantage Attack Plus XVIII"), DS(15, "Melee: Ether Res Down XVIII"), DS(15, "Melee: Gravity Res Down XVIII")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Melee Attack Boost VI"), DS(15, "Ranged Attack Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Resist Shock XIX"), DS(15, "Back Attack Plus XVIII"), DS(15, "Melee: Beam Res Down XVIII"), DS(15, "Melee: Electric Res Down XVIII")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Melee Attack Boost VI"), DS(15, "Ranged Attack Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Resist Shock XIX"), DS(15, "Vantage Attack Plus XVIII"), DS(15, "Back Attack Plus XVIII"), DS(15, "Melee: Blackout XVIII")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Melee Attack Boost VI"), DS(15, "Ranged Attack Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Resist Shock XIX"), DS(15, "Vantage Attack Plus XVIII"), DS(15, "Back Attack Plus XVIII"), DS(15, "Melee: Fatigue XVIII")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Melee Attack Boost VI"), DS(15, "Ranged Attack Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Resist Shock XIX"), DS(15, "Vantage Attack Plus XVIII"), DS(15, "Back Attack Plus XVIII"), DS(15, "Melee: Physical Res Down XVIII")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Melee Attack Boost VI"), DS(15, "Ranged Attack Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Resist Shock XIX"), DS(15, "Vantage Attack Plus XVIII"), DS(15, "Back Attack Plus XVIII"), DS(15, "Melee: Thermal Res Down XVIII")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(15, "Ranged Attack Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Debuff Suppressor I"), DS(15, "Electric Attack Plus XX"), DS(15, "Gravity Attack Plus XX"), DS(15, "Front Attack Plus XX")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(15, "Ranged Attack Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Debuff Suppressor I"), DS(15, "Gravity Attack Plus XX"), DS(15, "Front Attack Plus XX"), DS(15, "Melee: Blaze XX")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(15, "Ranged Attack Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Gravity Attack Plus XX"), DS(15, "Front Attack Plus XX"), DS(15, "Extend Critical Power I"), DS(15, "Zero Critical"), DS(15, "Insectoid Slayer XX"), DS(15, "Piscinoid Slayer XX")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(15, "Ranged Attack Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Debuff Suppressor I"), DS(15, "Extend Critical Power I"), DS(15, "Zero Critical"), DS(15, "Insectoid Slayer XX"), DS(15, "Piscinoid Slayer XX")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(15, "Ranged Attack Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Extend Critical Power I"), DS(15, "Zero Critical"), DS(15, "Insectoid Slayer XX"), DS(15, "Piscinoid Slayer XX"), DS(15, "Humanoid Slayer XX"), DS(15, "Mechanoid Slayer XX")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(15, "Ranged Attack Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Debuff Suppressor I"), DS(15, "Vantage Attack Plus XX"), DS(15, "Melee: Ether Res Down XX"), DS(15, "Melee: Gravity Res Down XX")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(15, "Ranged Attack Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Debuff Suppressor I"), DS(15, "Back Attack Plus XX"), DS(15, "Melee: Beam Res Down XX"), DS(15, "Melee: Electric Res Down XX")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(15, "Ranged Attack Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Debuff Suppressor I"), DS(15, "Vantage Attack Plus XX"), DS(15, "Back Attack Plus XX"), DS(15, "Melee: Blackout XX")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(15, "Ranged Attack Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Debuff Suppressor I"), DS(15, "Vantage Attack Plus XX"), DS(15, "Back Attack Plus XX"), DS(15, "Melee: Fatigue XX")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(15, "Ranged Attack Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Debuff Suppressor I"), DS(15, "Vantage Attack Plus XX"), DS(15, "Back Attack Plus XX"), DS(15, "Melee: Physical Res Down XX")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(15, "Ranged Attack Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Debuff Suppressor I"), DS(15, "Vantage Attack Plus XX"), DS(15, "Back Attack Plus XX"), DS(15, "Melee: Thermal Res Down XX")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Melee Attack Boost X"), DS(15, "Ranged Attack Boost X"), DS(10, "Max HP Drive X"), DS(10, "Debuff Suppressor III"), DS(15, "Gravity Attack Plus II"), DS(15, "Front Attack Plus II"), DS(15, "Side Attack Plus II")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Melee Attack Boost X"), DS(15, "Ranged Attack Boost X"), DS(10, "Max HP Drive X"), DS(10, "Debuff Suppressor III"), DS(15, "Front Attack Plus II"), DS(15, "Side Attack Plus II"), DS(15, "Melee: Shock II")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Melee Attack Boost X"), DS(15, "Ranged Attack Boost X"), DS(10, "Max HP Drive X"), DS(10, "Front Attack Plus II"), DS(15, "Side Attack Plus II"), DS(15, "Extend Critical Power III"), DS(15, "Theroid Slayer II"), DS(15, "Piscinoid Slayer II"), DS(15, "Humanoid Slayer II")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Melee Attack Boost X"), DS(15, "Ranged Attack Boost X"), DS(10, "Max HP Drive X"), DS(10, "Debuff Suppressor III"), DS(15, "Extend Critical Power III"), DS(15, "Theroid Slayer II"), DS(15, "Piscinoid Slayer II"), DS(15, "Humanoid Slayer II")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Melee Attack Boost X"), DS(15, "Ranged Attack Boost X"), DS(10, "Max HP Drive X"), DS(10, "Extend Critical Power III"), DS(15, "Theroid Slayer II"), DS(15, "Piscinoid Slayer II"), DS(15, "Humanoid Slayer II"), DS(15, "Mechanoid Slayer II"), DS(15, "Chimeroid Slayer II")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Melee Attack Boost X"), DS(15, "Ranged Attack Boost X"), DS(10, "Max HP Drive X"), DS(10, "Debuff Suppressor III"), DS(15, "Melee: Blackout II"), DS(15, "Melee: Thermal Res Down II"), DS(15, "Melee: Blaze II")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Melee Attack Boost X"), DS(15, "Ranged Attack Boost X"), DS(10, "Max HP Drive X"), DS(10, "Debuff Suppressor III"), DS(15, "Vantage Attack Plus II"), DS(15, "Melee: Ether Res Down II"), DS(15, "Melee: Gravity Res Down II")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Melee Attack Boost X"), DS(15, "Ranged Attack Boost X"), DS(10, "Max HP Drive X"), DS(10, "Debuff Suppressor III"), DS(15, "Melee: Blackout II"), DS(15, "Vantage Attack Plus II"), DS(15, "Melee: Fatigue II")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Melee Attack Boost X"), DS(15, "Ranged Attack Boost X"), DS(10, "Max HP Drive X"), DS(10, "Debuff Suppressor III"), DS(15, "Melee: Blackout II"), DS(15, "Vantage Attack Plus II"), DS(15, "Melee: Physical Res Down II")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Melee Attack Boost X"), DS(15, "Ranged Attack Boost X"), DS(10, "Max HP Drive X"), DS(10, "Debuff Suppressor III"), DS(15, "Melee: Blackout II"), DS(15, "Vantage Attack Plus II"), DS(15, "Melee: Beam Res Down II")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Melee Attack Boost X"), DS(15, "Ranged Attack Boost X"), DS(10, "Max HP Drive X"), DS(10, "Debuff Suppressor III"), DS(15, "Melee: Blackout II"), DS(15, "Vantage Attack Plus II"), DS(15, "Melee: Electric Res Down II")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Melee Attack Boost XII"), DS(15, "Ranged Attack Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Debuff Suppressor V"), DS(15, "Gravity Attack Plus IV"), DS(15, "Front Attack Plus IV"), DS(15, "Side Attack Plus IV")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Melee Attack Boost XII"), DS(15, "Ranged Attack Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Debuff Suppressor V"), DS(15, "Front Attack Plus IV"), DS(15, "Side Attack Plus IV"), DS(15, "Melee: Shock IV")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Melee Attack Boost XII"), DS(15, "Ranged Attack Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Front Attack Plus IV"), DS(15, "Side Attack Plus IV"), DS(15, "Extend Critical Power V"), DS(15, "Theroid Slayer IV"), DS(15, "Piscinoid Slayer IV"), DS(15, "Humanoid Slayer IV")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Melee Attack Boost XII"), DS(15, "Ranged Attack Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Debuff Suppressor V"), DS(15, "Extend Critical Power V"), DS(15, "Theroid Slayer IV"), DS(15, "Piscinoid Slayer IV"), DS(15, "Humanoid Slayer IV")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Melee Attack Boost XII"), DS(15, "Ranged Attack Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Extend Critical Power V"), DS(15, "Theroid Slayer IV"), DS(15, "Piscinoid Slayer IV"), DS(15, "Humanoid Slayer IV"), DS(15, "Mechanoid Slayer IV"), DS(15, "Chimeroid Slayer IV")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Melee Attack Boost XII"), DS(15, "Ranged Attack Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Debuff Suppressor V"), DS(15, "Melee: Blackout IV"), DS(15, "Melee: Thermal Res Down IV"), DS(15, "Melee: Blaze IV")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Melee Attack Boost XII"), DS(15, "Ranged Attack Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Debuff Suppressor V"), DS(15, "Vantage Attack Plus IV"), DS(15, "Melee: Ether Res Down IV"), DS(15, "Melee: Gravity Res Down IV")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Melee Attack Boost XII"), DS(15, "Ranged Attack Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Debuff Suppressor V"), DS(15, "Melee: Blackout IV"), DS(15, "Vantage Attack Plus IV"), DS(15, "Melee: Fatigue IV")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Melee Attack Boost XII"), DS(15, "Ranged Attack Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Debuff Suppressor V"), DS(15, "Melee: Blackout IV"), DS(15, "Vantage Attack Plus IV"), DS(15, "Melee: Physical Res Down IV")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Melee Attack Boost XII"), DS(15, "Ranged Attack Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Debuff Suppressor V"), DS(15, "Melee: Blackout IV"), DS(15, "Vantage Attack Plus IV"), DS(15, "Melee: Beam Res Down IV")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Melee Attack Boost XII"), DS(15, "Ranged Attack Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Debuff Suppressor V"), DS(15, "Melee: Blackout IV"), DS(15, "Vantage Attack Plus IV"), DS(15, "Melee: Electric Res Down IV")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Evasion Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Potential Up III"), DS(10, "Chimeroid Slayer XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI"), DS(15, "Theroid Criticals Up XVI")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Evasion Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Potential Up III"), DS(10, "Ultrafauna Slayer XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI"), DS(15, "Theroid Criticals Up XVI")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Evasion Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Potential Up III"), DS(10, "Physical Attack Plus XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI"), DS(15, "Theroid Criticals Up XVI")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Evasion Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Potential Up III"), DS(10, "Beam Attack Plus XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI"), DS(15, "Theroid Criticals Up XVI")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Evasion Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Potential Up III"), DS(10, "Ether Attack Plus XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI"), DS(15, "Theroid Criticals Up XVI")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Evasion Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Potential Up III"), DS(10, "Thermal Attack Plus XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI"), DS(15, "Theroid Criticals Up XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Evasion Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Potential Up V"), DS(10, "Chimeroid Slayer XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII"), DS(15, "Theroid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Evasion Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Potential Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII"), DS(15, "Theroid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Evasion Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Potential Up V"), DS(10, "Physical Attack Plus XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII"), DS(15, "Theroid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Evasion Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Potential Up V"), DS(10, "Beam Attack Plus XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII"), DS(15, "Theroid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Evasion Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Potential Up V"), DS(10, "Ether Attack Plus XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII"), DS(15, "Theroid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Evasion Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Potential Up V"), DS(10, "Thermal Attack Plus XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII"), DS(15, "Theroid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Chimeroid Slayer XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX"), DS(15, "Theroid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX"), DS(15, "Theroid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Physical Attack Plus XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX"), DS(15, "Theroid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Beam Attack Plus XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX"), DS(15, "Theroid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Ether Attack Plus XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX"), DS(15, "Theroid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Thermal Attack Plus XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX"), DS(15, "Theroid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Ultrafauna Slayer I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II"), DS(15, "Insectoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Physical Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II"), DS(15, "Insectoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Beam Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II"), DS(15, "Insectoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Ether Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II"), DS(15, "Insectoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Thermal Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II"), DS(15, "Insectoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Electric Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II"), DS(15, "Insectoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Ultrafauna Slayer III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Physical Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Beam Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Ether Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Thermal Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Electric Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV")],
[DS(15, "Evasion Boost IV"), DS(10, "Melee Attack Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Resist Shock XVII"), DS(15, "Gravity Attack Plus XVI"), DS(15, "Front Attack Plus XVI"), DS(15, "Side Attack Plus XVI")],
[DS(15, "Evasion Boost IV"), DS(10, "Melee Attack Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Resist Shock XVII"), DS(15, "Gravity Attack Plus XVI"), DS(15, "Front Attack Plus XVI"), DS(15, "Side Attack Plus XVI")],
[DS(15, "Evasion Boost IV"), DS(10, "Melee Attack Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Resist Shock XVII"), DS(15, "Gravity Attack Plus XVI"), DS(15, "Front Attack Plus XVI"), DS(15, "Side Attack Plus XVI"), DS(15, "Gravity Resistance Up IV"), DS(15, "Stabilizer XIX")],
[DS(15, "Evasion Boost IV"), DS(10, "Melee Attack Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Resist Shock XVII"), DS(15, "Gravity Attack Plus XVI"), DS(15, "Front Attack Plus XVI"), DS(15, "Side Attack Plus XVI"), DS(15, "Weapon Attack Power Up IV"), DS(15, "Stabilizer XIX")],
[DS(15, "Evasion Boost IV"), DS(10, "Melee Attack Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Resist Shock XVII"), DS(15, "Ultrafauna Criticals Up XVII"), DS(15, "Extend Critical Power XVII"), DS(15, "Insectoid Slayer XVI"), DS(15, "Piscinoid Slayer XVI"), DS(15, "Theroid Slayer XVI")],
[DS(15, "Evasion Boost IV"), DS(10, "Melee Attack Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Resist Shock XVII"), DS(15, "Ultrafauna Criticals Up XVII"), DS(15, "Extend Critical Power XVII"), DS(15, "Humanoid Slayer XVI"), DS(15, "Mechanoid Slayer XVI"), DS(15, "Theroid Slayer XVI")],
[DS(15, "Evasion Boost VI"), DS(10, "Melee Attack Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Resist Shock XIX"), DS(15, "Gravity Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII"), DS(15, "Side Attack Plus XVIII")],
[DS(15, "Evasion Boost VI"), DS(10, "Melee Attack Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Resist Shock XIX"), DS(15, "Gravity Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII"), DS(15, "Side Attack Plus XVIII")],
[DS(15, "Evasion Boost VI"), DS(10, "Melee Attack Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Resist Shock XIX"), DS(15, "Gravity Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII"), DS(15, "Side Attack Plus XVIII"), DS(15, "Gravity Resistance Up V"), DS(15, "Destabilizer I")],
[DS(15, "Evasion Boost VI"), DS(10, "Melee Attack Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Resist Shock XIX"), DS(15, "Gravity Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII"), DS(15, "Side Attack Plus XVIII"), DS(15, "Weapon Attack Power Up V"), DS(15, "Destabilizer I")],
[DS(15, "Evasion Boost VI"), DS(10, "Melee Attack Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Resist Shock XIX"), DS(15, "Ultrafauna Criticals Up XIX"), DS(15, "Extend Critical Power XIX"), DS(15, "Insectoid Slayer XVIII"), DS(15, "Piscinoid Slayer XVIII"), DS(15, "Theroid Slayer XVIII")],
[DS(15, "Evasion Boost VI"), DS(10, "Melee Attack Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Resist Shock XIX"), DS(15, "Ultrafauna Criticals Up XIX"), DS(15, "Extend Critical Power XIX"), DS(15, "Humanoid Slayer XVIII"), DS(15, "Mechanoid Slayer XVIII"), DS(15, "Theroid Slayer XVIII")],
[DS(15, "Evasion Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Debuff Suppressor I"), DS(15, "Gravity Attack Plus XX"), DS(15, "Front Attack Plus XX"), DS(15, "Side Attack Plus XX")],
[DS(15, "Evasion Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Debuff Suppressor I"), DS(15, "Gravity Attack Plus XX"), DS(15, "Front Attack Plus XX"), DS(15, "Side Attack Plus XX")],
[DS(15, "Evasion Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Debuff Suppressor I"), DS(15, "Gravity Attack Plus XX"), DS(15, "Front Attack Plus XX"), DS(15, "Side Attack Plus XX"), DS(15, "Gravity Resistance Up VI"), DS(15, "Destabilizer III")],
[DS(15, "Evasion Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Debuff Suppressor I"), DS(15, "Gravity Attack Plus XX"), DS(15, "Front Attack Plus XX"), DS(15, "Side Attack Plus XX"), DS(15, "Weapon Attack Power Up VI"), DS(15, "Destabilizer III")],
[DS(15, "Evasion Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Debuff Suppressor I"), DS(15, "Extend Critical Power I"), DS(15, "Zero Critical"), DS(15, "Insectoid Slayer XX"), DS(15, "Piscinoid Slayer XX"), DS(15, "Theroid Slayer XX")],
[DS(15, "Evasion Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Debuff Suppressor I"), DS(15, "Extend Critical Power I"), DS(15, "Zero Critical"), DS(15, "Humanoid Slayer XX"), DS(15, "Mechanoid Slayer XX"), DS(15, "Theroid Slayer XX")],
[DS(15, "Evasion Boost X"), DS(10, "Melee Attack Boost X"), DS(15, "Potential Boost X"), DS(10, "Max HP Drive X"), DS(10, "Debuff Suppressor III"), DS(15, "Front Attack Plus II"), DS(15, "Side Attack Plus II"), DS(15, "Back Attack Plus II")],
[DS(15, "Evasion Boost X"), DS(10, "Melee Attack Boost X"), DS(15, "Potential Boost X"), DS(10, "Max HP Drive X"), DS(10, "Debuff Suppressor III"), DS(15, "Front Attack Plus II"), DS(15, "Side Attack Plus II"), DS(15, "Back Attack Plus II")],
[DS(15, "Evasion Boost X"), DS(10, "Melee Attack Boost X"), DS(15, "Potential Boost X"), DS(10, "Max HP Drive X"), DS(10, "Debuff Suppressor III"), DS(15, "Front Attack Plus II"), DS(15, "Side Attack Plus II"), DS(15, "Back Attack Plus II"), DS(15, "Gravity Resistance Up VII"), DS(15, "Destabilizer V")],
[DS(15, "Evasion Boost X"), DS(10, "Melee Attack Boost X"), DS(15, "Potential Boost X"), DS(10, "Max HP Drive X"), DS(10, "Debuff Suppressor III"), DS(15, "Front Attack Plus II"), DS(15, "Side Attack Plus II"), DS(15, "Back Attack Plus II"), DS(15, "Weapon Attack Power Up VII"), DS(15, "Destabilizer V")],
[DS(15, "Evasion Boost X"), DS(10, "Melee Attack Boost X"), DS(15, "Potential Boost X"), DS(10, "Max HP Drive X"), DS(10, "Debuff Suppressor III"), DS(15, "Extend Critical Power III"), DS(15, "Theroid Slayer II"), DS(15, "Piscinoid Slayer II"), DS(15, "Humanoid Slayer II"), DS(15, "Insectoid Slayer II")],
[DS(15, "Evasion Boost X"), DS(10, "Melee Attack Boost X"), DS(15, "Potential Boost X"), DS(10, "Max HP Drive X"), DS(10, "Debuff Suppressor III"), DS(15, "Extend Critical Power III"), DS(15, "Theroid Slayer II"), DS(15, "Mechanoid Slayer II"), DS(15, "Chimeroid Slayer II"), DS(15, "Insectoid Slayer II")],
[DS(15, "Evasion Boost XII"), DS(10, "Melee Attack Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Debuff Suppressor V"), DS(15, "Front Attack Plus IV"), DS(15, "Side Attack Plus IV"), DS(15, "Back Attack Plus IV")],
[DS(15, "Evasion Boost XII"), DS(10, "Melee Attack Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Debuff Suppressor V"), DS(15, "Front Attack Plus IV"), DS(15, "Side Attack Plus IV"), DS(15, "Back Attack Plus IV")],
[DS(15, "Evasion Boost XII"), DS(10, "Melee Attack Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Debuff Suppressor V"), DS(15, "Front Attack Plus IV"), DS(15, "Side Attack Plus IV"), DS(15, "Back Attack Plus IV"), DS(15, "Gravity Resistance Up VIII"), DS(15, "Destabilizer VII")],
[DS(15, "Evasion Boost XII"), DS(10, "Melee Attack Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Debuff Suppressor V"), DS(15, "Front Attack Plus IV"), DS(15, "Side Attack Plus IV"), DS(15, "Back Attack Plus IV"), DS(15, "Weapon Attack Power Up VIII"), DS(15, "Destabilizer VII")],
[DS(15, "Evasion Boost XII"), DS(10, "Melee Attack Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Debuff Suppressor V"), DS(15, "Extend Critical Power V"), DS(15, "Theroid Slayer IV"), DS(15, "Piscinoid Slayer IV"), DS(15, "Humanoid Slayer IV"), DS(15, "Insectoid Slayer IV")],
[DS(15, "Evasion Boost XII"), DS(10, "Melee Attack Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Debuff Suppressor V"), DS(15, "Extend Critical Power V"), DS(15, "Theroid Slayer IV"), DS(15, "Mechanoid Slayer IV"), DS(15, "Chimeroid Slayer IV"), DS(15, "Insectoid Slayer IV")],
[DS(15, "Melee Accuracy Up III"), DS(10, "Melee Attack Up III"), DS(10, "Chimeroid Slayer XV"), DS(15, "Nullify Electric Reflect XV"), DS(15, "Resist Shock XVI")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Melee Attack Up V"), DS(10, "Chimeroid Slayer XVII"), DS(15, "Nullify Electric Reflect XVII"), DS(15, "Resist Shock XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Melee Attack Up VII"), DS(10, "Chimeroid Slayer XIX"), DS(15, "Nullify Electric Reflect XIX"), DS(15, "Resist Shock XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Melee Attack Up IX"), DS(10, "Ultrafauna Slayer I"), DS(15, "Nullify Gravity Reflect I"), DS(15, "Debuff Suppressor II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Melee Attack Up XI"), DS(10, "Ultrafauna Slayer III"), DS(15, "Nullify Gravity Reflect III"), DS(15, "Debuff Suppressor IV")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Ranged Attack Boost IV"), DS(10, "Chimeroid Slayer XVI"), DS(10, "Ether Resistance Up VII"), DS(10, "Magazine Capacity Up XIX"), DS(15, "Resist Shock XVII"), DS(15, "Extend Debuff Res Down XIII"), DS(15, "Electric Attack Plus XVI"), DS(15, "Front Attack Plus XVI"), DS(10, "ITM_SKL_IN_FST_FDEX14_name")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ranged Attack Boost VI"), DS(10, "Chimeroid Slayer XVIII"), DS(10, "Ether Resistance Up IX"), DS(10, "Melee: TP Gain Up"), DS(15, "Resist Shock XIX"), DS(15, "Extend Debuff Res Down XIII"), DS(15, "Electric Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII"), DS(10, "ITM_SKL_IN_FST_FDEX16_name")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ranged Attack Boost VIII"), DS(10, "Chimeroid Slayer XX"), DS(10, "Ether Resistance Up XI"), DS(10, "Cooldown Reducer I"), DS(15, "Debuff Suppressor I"), DS(15, "Extend Debuff Res Down XIII"), DS(15, "Electric Attack Plus XX"), DS(15, "Front Attack Plus XX"), DS(10, "ITM_SKL_IN_FST_FDEX18_name")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Ranged Attack Boost X"), DS(10, "Ultrafauna Slayer II"), DS(10, "Ether Resistance Up XIII"), DS(10, "Cooldown Reducer III"), DS(15, "Debuff Suppressor III"), DS(15, "Extend Debuff Res Down XIII"), DS(15, "Gravity Attack Plus II"), DS(15, "Side Attack Plus II"), DS(10, "ITM_SKL_IN_FST_FDEX20_name")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Ranged Attack Boost XII"), DS(10, "Ultrafauna Slayer IV"), DS(10, "Ether Resistance Up XV"), DS(10, "Cooldown Reducer V"), DS(15, "Debuff Suppressor V"), DS(15, "Extend Debuff Res Down XIII"), DS(15, "Gravity Attack Plus IV"), DS(15, "Side Attack Plus IV"), DS(10, "ITM_SKL_IN_FST_SDEX02_name")],
[DS(15, "Melee Accuracy Up III"), DS(10, "Melee Attack Up III"), DS(10, "Chimeroid Slayer XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Melee Attack Up V"), DS(10, "Chimeroid Slayer XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Melee Attack Up VII"), DS(10, "Chimeroid Slayer XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Melee Attack Up IX"), DS(10, "Ultrafauna Slayer I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Melee Attack Up XI"), DS(10, "Ultrafauna Slayer III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Ranged Attack Boost IV"), DS(10, "Chimeroid Slayer XVI"), DS(10, "Stabilizer XIX"), DS(10, "Magazine Capacity Up XIX"), DS(10, "Stabilizer IV"), DS(15, "Resist Shock XVII"), DS(15, "Gravity Attack Plus XVI"), DS(15, "Front Attack Plus XVI")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ranged Attack Boost VI"), DS(10, "Chimeroid Slayer XVIII"), DS(10, "Destabilizer I"), DS(10, "Melee: TP Gain Up"), DS(10, "Stabilizer IV"), DS(15, "Resist Shock XIX"), DS(15, "Gravity Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ranged Attack Boost VIII"), DS(10, "Chimeroid Slayer XX"), DS(10, "Destabilizer III"), DS(10, "Cooldown Reducer I"), DS(10, "Stabilizer IV"), DS(15, "Debuff Suppressor I"), DS(15, "Gravity Attack Plus XX"), DS(15, "Front Attack Plus XX")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Ranged Attack Boost X"), DS(10, "Ultrafauna Slayer II"), DS(10, "Destabilizer V"), DS(10, "Cooldown Reducer III"), DS(10, "Stabilizer IV"), DS(15, "Debuff Suppressor III"), DS(15, "Front Attack Plus II"), DS(15, "Side Attack Plus II")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Ranged Attack Boost XII"), DS(10, "Ultrafauna Slayer IV"), DS(10, "Destabilizer VII"), DS(10, "Cooldown Reducer V"), DS(10, "Stabilizer IV"), DS(15, "Debuff Suppressor V"), DS(15, "Front Attack Plus IV"), DS(15, "Side Attack Plus IV")],
[DS(15, "Melee Accuracy Up III"), DS(10, "Melee Attack Up III"), DS(10, "Chimeroid Slayer XV"), DS(15, "Resist Shock XVI")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Melee Attack Up V"), DS(10, "Chimeroid Slayer XVII"), DS(15, "Resist Shock XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Melee Attack Up VII"), DS(10, "Chimeroid Slayer XIX"), DS(15, "Resist Shock XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Melee Attack Up IX"), DS(10, "Ultrafauna Slayer I"), DS(15, "Debuff Suppressor II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Melee Attack Up XI"), DS(10, "Ultrafauna Slayer III"), DS(15, "Debuff Suppressor IV")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Ranged Attack Boost IV"), DS(10, "Chimeroid Slayer XVI"), DS(15, "Resist Shock XVII"), DS(15, "Electric Attack Plus XVI"), DS(15, "Front Attack Plus XVI"), DS(10, "ITM_SKL_IN_FST_FDEX14_name"), DS(15, "Debuff Suppressor XVII"), DS(15, "Critical Chance Up XVII"), DS(15, "Piscinoid Criticals Up XVII")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ranged Attack Boost VI"), DS(10, "Chimeroid Slayer XVIII"), DS(15, "Resist Shock XIX"), DS(15, "Electric Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII"), DS(10, "ITM_SKL_IN_FST_FDEX16_name"), DS(15, "Debuff Suppressor XIX"), DS(15, "Critical Chance Up XIX"), DS(15, "Piscinoid Criticals Up XIX")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ranged Attack Boost VIII"), DS(10, "Chimeroid Slayer XX"), DS(15, "Debuff Suppressor I"), DS(15, "Electric Attack Plus XX"), DS(15, "Front Attack Plus XX"), DS(10, "ITM_SKL_IN_FST_FDEX18_name"), DS(15, "Critical Chance Up I"), DS(15, "Theroid Criticals Up I"), DS(15, "Humanoid Criticals Up I")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Ranged Attack Boost X"), DS(10, "Ultrafauna Slayer II"), DS(15, "Debuff Suppressor III"), DS(15, "Gravity Attack Plus II"), DS(15, "Side Attack Plus II"), DS(10, "ITM_SKL_IN_FST_FDEX20_name"), DS(15, "Critical Chance Up III"), DS(15, "Theroid Criticals Up III"), DS(15, "Humanoid Criticals Up III")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Ranged Attack Boost XII"), DS(10, "Ultrafauna Slayer IV"), DS(15, "Debuff Suppressor V"), DS(15, "Gravity Attack Plus IV"), DS(15, "Side Attack Plus IV"), DS(10, "ITM_SKL_IN_FST_SDEX02_name"), DS(15, "Critical Chance Up V"), DS(15, "Theroid Criticals Up V"), DS(15, "Humanoid Criticals Up V")],
[DS(15, "Melee Accuracy Up III"), DS(10, "Melee Attack Up III"), DS(10, "Ultrafauna Slayer XV"), DS(15, "Extend Taunt XIII"), DS(15, "Resist Shock XVI")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Melee Attack Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(15, "Extend Taunt XV"), DS(15, "Resist Shock XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Melee Attack Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(15, "Extend Taunt XVII"), DS(15, "Resist Shock XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Melee Attack Up IX"), DS(10, "Physical Attack Plus I"), DS(15, "Extend Taunt XIX"), DS(15, "Debuff Suppressor II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Melee Attack Up XI"), DS(10, "Physical Attack Plus III"), DS(15, "Extend Control I"), DS(15, "Debuff Suppressor IV")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Ranged Attack Boost IV"), DS(10, "Ultrafauna Slayer XVI"), DS(15, "Extend Taunt XIV"), DS(10, "Magazine Capacity Up XIX"), DS(15, "Debuff Suppressor XVII"), DS(15, "Critical Chance Up XVII"), DS(15, "Piscinoid Criticals Up XVII")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ranged Attack Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(15, "Extend Taunt XVI"), DS(10, "Melee: TP Gain Up"), DS(15, "Debuff Suppressor XIX"), DS(15, "Critical Chance Up XIX"), DS(15, "Piscinoid Criticals Up XIX")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ranged Attack Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(15, "Extend Taunt XVIII"), DS(10, "Cooldown Reducer I"), DS(15, "Critical Chance Up I"), DS(15, "Theroid Criticals Up I"), DS(15, "Humanoid Criticals Up I")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Ranged Attack Boost X"), DS(10, "Physical Attack Plus II"), DS(15, "Extend Taunt XX"), DS(10, "Cooldown Reducer III"), DS(15, "Critical Chance Up III"), DS(15, "Theroid Criticals Up III"), DS(15, "Humanoid Criticals Up III")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Ranged Attack Boost XII"), DS(10, "Physical Attack Plus IV"), DS(15, "Extend Control II"), DS(10, "Cooldown Reducer V"), DS(15, "Critical Chance Up V"), DS(15, "Theroid Criticals Up V"), DS(15, "Humanoid Criticals Up V")],
[DS(15, "Melee Accuracy Up III"), DS(10, "Melee Attack Up III"), DS(10, "Thermal Attack Plus XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Melee Attack Up V"), DS(10, "Thermal Attack Plus XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Melee Attack Up VII"), DS(10, "Thermal Attack Plus XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Melee Attack Up IX"), DS(10, "Electric Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Melee Attack Up XI"), DS(10, "Electric Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Ranged Attack Boost IV"), DS(10, "Thermal Attack Plus XVI"), DS(15, "Resist Shock XVII"), DS(10, "Ether Resistance Up VII"), DS(10, "Magazine Capacity Up XIX"), DS(15, "Stabilizer XIX"), DS(15, "Electric Attack Plus XVI"), DS(15, "Front Attack Plus XVI"), DS(10, "Stabilizer IV")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ranged Attack Boost VI"), DS(10, "Thermal Attack Plus XVIII"), DS(15, "Resist Shock XIX"), DS(10, "Ether Resistance Up IX"), DS(10, "Melee: TP Gain Up"), DS(15, "Destabilizer I"), DS(15, "Electric Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII"), DS(10, "Stabilizer IV")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ranged Attack Boost VIII"), DS(10, "Thermal Attack Plus XX"), DS(15, "Debuff Suppressor I"), DS(10, "Ether Resistance Up XI"), DS(10, "Cooldown Reducer I"), DS(15, "Destabilizer III"), DS(15, "Electric Attack Plus XX"), DS(15, "Front Attack Plus XX"), DS(10, "Stabilizer IV")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Ranged Attack Boost X"), DS(10, "Electric Attack Plus II"), DS(15, "Debuff Suppressor III"), DS(10, "Ether Resistance Up XIII"), DS(10, "Cooldown Reducer III"), DS(15, "Destabilizer V"), DS(15, "Gravity Attack Plus II"), DS(15, "Side Attack Plus II"), DS(10, "Stabilizer IV")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Ranged Attack Boost XII"), DS(10, "Electric Attack Plus IV"), DS(15, "Debuff Suppressor V"), DS(10, "Ether Resistance Up XV"), DS(10, "Cooldown Reducer V"), DS(15, "Destabilizer VII"), DS(15, "Gravity Attack Plus IV"), DS(15, "Side Attack Plus IV"), DS(10, "Stabilizer IV")],
[DS(15, "Melee Accuracy Up III"), DS(10, "Melee Attack Up III"), DS(10, "Thermal Attack Plus XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Melee Attack Up V"), DS(10, "Thermal Attack Plus XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Melee Attack Up VII"), DS(10, "Thermal Attack Plus XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Melee Attack Up IX"), DS(10, "Electric Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Melee Attack Up XI"), DS(10, "Electric Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Ranged Attack Boost IV"), DS(10, "Thermal Attack Plus XVI"), DS(15, "Resist Shock XVII"), DS(10, "Ether Resistance Up VII"), DS(10, "Magazine Capacity Up XIX"), DS(15, "Stabilizer XIX"), DS(15, "Resist Electric Res Down XVII"), DS(15, "Ranged Attack Drive VII"), DS(10, "Stabilizer IV")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ranged Attack Boost VI"), DS(10, "Thermal Attack Plus XVIII"), DS(15, "Resist Shock XIX"), DS(10, "Ether Resistance Up IX"), DS(10, "Melee: TP Gain Up"), DS(15, "Destabilizer I"), DS(15, "Resist Electric Res Down XIX"), DS(15, "Ranged Attack Drive IX"), DS(10, "Stabilizer IV")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ranged Attack Boost VIII"), DS(10, "Thermal Attack Plus XX"), DS(15, "Debuff Suppressor I"), DS(10, "Ether Resistance Up XI"), DS(10, "Cooldown Reducer I"), DS(15, "Destabilizer III"), DS(15, "Resist Ether Res Down I"), DS(15, "Ranged Attack Drive XI"), DS(10, "Stabilizer IV")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Ranged Attack Boost X"), DS(10, "Electric Attack Plus II"), DS(15, "Debuff Suppressor III"), DS(10, "Ether Resistance Up XIII"), DS(10, "Cooldown Reducer III"), DS(15, "Destabilizer V"), DS(15, "Resist Ether Res Down III"), DS(15, "Ranged Attack Drive XIII"), DS(10, "Stabilizer IV")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Ranged Attack Boost XII"), DS(10, "Electric Attack Plus IV"), DS(15, "Debuff Suppressor V"), DS(10, "Ether Resistance Up XV"), DS(10, "Cooldown Reducer V"), DS(15, "Destabilizer VII"), DS(15, "Resist Ether Res Down V"), DS(15, "Ranged Attack Drive XV"), DS(10, "Stabilizer IV")],
[DS(15, "Melee Accuracy Up III"), DS(10, "Melee Attack Up III"), DS(10, "Ultrafauna Slayer XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI"), DS(15, "Theroid Criticals Up XVI")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Melee Attack Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII"), DS(15, "Theroid Criticals Up XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Melee Attack Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX"), DS(15, "Theroid Criticals Up XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Melee Attack Up IX"), DS(10, "Physical Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II"), DS(15, "Insectoid Criticals Up II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Melee Attack Up XI"), DS(10, "Physical Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Ranged Attack Boost IV"), DS(10, "Ultrafauna Slayer XVI"), DS(15, "Stabilizer XIX"), DS(10, "Magazine Capacity Up XIX"), DS(15, "Ultrafauna Criticals Up XVII"), DS(15, "Extend Critical Power XVII"), DS(15, "Piscinoid Slayer XVI"), DS(15, "Theroid Slayer XVI"), DS(15, "Insectoid Slayer XVI")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ranged Attack Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(15, "Destabilizer I"), DS(10, "Melee: TP Gain Up"), DS(15, "Ultrafauna Criticals Up XIX"), DS(15, "Extend Critical Power XIX"), DS(15, "Piscinoid Slayer XVIII"), DS(15, "Theroid Slayer XVIII"), DS(15, "Insectoid Slayer XVIII")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ranged Attack Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(15, "Destabilizer III"), DS(10, "Cooldown Reducer I"), DS(15, "Extend Critical Power I"), DS(15, "Zero Critical"), DS(15, "Piscinoid Slayer XX"), DS(15, "Theroid Slayer XX"), DS(15, "Insectoid Slayer XX")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Ranged Attack Boost X"), DS(10, "Physical Attack Plus II"), DS(15, "Destabilizer V"), DS(10, "Cooldown Reducer III"), DS(15, "Extend Critical Power III"), DS(15, "Theroid Slayer II"), DS(15, "Humanoid Slayer II"), DS(15, "Insectoid Slayer II"), DS(15, "Piscinoid Slayer II")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Ranged Attack Boost XII"), DS(10, "Physical Attack Plus IV"), DS(15, "Destabilizer VII"), DS(10, "Cooldown Reducer V"), DS(15, "Extend Critical Power V"), DS(15, "Theroid Slayer IV"), DS(15, "Humanoid Slayer IV"), DS(15, "Insectoid Slayer IV"), DS(15, "Piscinoid Slayer IV")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Ranged Attack Up III"), DS(10, "Ultrafauna Slayer XV"), DS(15, "Melee Accuracy Drive VI"), DS(15, "Resist Shock XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(15, "Melee Accuracy Drive VIII"), DS(15, "Resist Shock XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(15, "Melee Accuracy Drive X"), DS(15, "Resist Shock XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Physical Attack Plus I"), DS(15, "Melee Accuracy Drive XII"), DS(15, "Debuff Suppressor II")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Physical Attack Plus III"), DS(15, "Melee Accuracy Drive XIV"), DS(15, "Debuff Suppressor IV")],
[DS(15, "Evasion Boost IV"), DS(10, "Potential Boost IV"), DS(10, "Ultrafauna Slayer XVI"), DS(10, "Magazine Capacity Up XIX"), DS(15, "Electric Attack Plus XVI"), DS(15, "Front Attack Plus XVI"), DS(15, "ITM_SKL_IN_FST_FDEX14_name"), DS(15, "Extend Debuff Res Down XIV")],
[DS(15, "Evasion Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(10, "Melee: TP Gain Up"), DS(15, "Electric Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII"), DS(15, "ITM_SKL_IN_FST_FDEX16_name"), DS(15, "Extend Debuff Res Down XVI")],
[DS(15, "Evasion Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(10, "Cooldown Reducer I"), DS(15, "Electric Attack Plus XX"), DS(15, "Front Attack Plus XX"), DS(15, "ITM_SKL_IN_FST_FDEX18_name"), DS(15, "Extend Debuff Res Down XVIII")],
[DS(15, "Evasion Boost X"), DS(10, "Potential Boost X"), DS(10, "Physical Attack Plus II"), DS(10, "Cooldown Reducer III"), DS(15, "Gravity Attack Plus II"), DS(15, "Side Attack Plus II"), DS(15, "ITM_SKL_IN_FST_FDEX20_name"), DS(15, "Extend Debuff Res Down XX")],
[DS(15, "Evasion Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Physical Attack Plus IV"), DS(10, "Cooldown Reducer V"), DS(15, "Gravity Attack Plus IV"), DS(15, "Side Attack Plus IV"), DS(15, "ITM_SKL_IN_FST_SDEX02_name"), DS(15, "ITM_SKL_IN_TIME_EX_HPDN02_name")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Ranged Attack Up III"), DS(10, "Chimeroid Slayer XV"), DS(15, "Resist Shock XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Chimeroid Slayer XVII"), DS(15, "Resist Shock XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Chimeroid Slayer XIX"), DS(15, "Resist Shock XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Ultrafauna Slayer I"), DS(15, "Debuff Suppressor II")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Ultrafauna Slayer III"), DS(15, "Debuff Suppressor IV")],
[DS(15, "Evasion Boost IV"), DS(10, "Potential Boost IV"), DS(10, "Chimeroid Slayer XVI"), DS(10, "Magazine Capacity Up XIX"), DS(15, "Electric Attack Plus XVI"), DS(15, "Gravity Attack Plus XVI"), DS(15, "Front Attack Plus XVI"), DS(15, "Side Attack Plus XVI")],
[DS(15, "Evasion Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Chimeroid Slayer XVIII"), DS(10, "Melee: TP Gain Up"), DS(15, "Electric Attack Plus XVIII"), DS(15, "Gravity Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII"), DS(15, "Side Attack Plus XVIII")],
[DS(15, "Evasion Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Chimeroid Slayer XX"), DS(10, "Cooldown Reducer I"), DS(15, "Electric Attack Plus XX"), DS(15, "Gravity Attack Plus XX"), DS(15, "Front Attack Plus XX"), DS(15, "Side Attack Plus XX")],
[DS(15, "Evasion Boost X"), DS(10, "Potential Boost X"), DS(10, "Ultrafauna Slayer II"), DS(10, "Cooldown Reducer III"), DS(15, "Gravity Attack Plus II"), DS(15, "Front Attack Plus II"), DS(15, "Side Attack Plus II"), DS(15, "Back Attack Plus II")],
[DS(15, "Evasion Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Ultrafauna Slayer IV"), DS(10, "Cooldown Reducer V"), DS(15, "Gravity Attack Plus IV"), DS(15, "Front Attack Plus IV"), DS(15, "Side Attack Plus IV"), DS(15, "Back Attack Plus IV")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Ranged Attack Up III"), DS(10, "Beam Attack Plus XV"), DS(15, "Extend Virus XIII"), DS(15, "Resist Shock XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Beam Attack Plus XVII"), DS(15, "Extend Virus XV"), DS(15, "Resist Shock XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Beam Attack Plus XIX"), DS(15, "Extend Virus XVII"), DS(15, "Resist Shock XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Ether Attack Plus I"), DS(15, "Extend Virus XIX"), DS(15, "Debuff Suppressor II")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Ether Attack Plus III"), DS(15, "Extend Blackout I"), DS(15, "Debuff Suppressor IV")],
[DS(15, "Evasion Boost IV"), DS(10, "Potential Boost IV"), DS(10, "Beam Attack Plus XVI"), DS(10, "Magazine Capacity Up XIX"), DS(15, "Electric Attack Plus XVI"), DS(15, "Gravity Attack Plus XVI"), DS(15, "Front Attack Plus XVI"), DS(15, "Extend Debuff Res Down XIV")],
[DS(15, "Evasion Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Beam Attack Plus XVIII"), DS(10, "Melee: TP Gain Up"), DS(15, "Electric Attack Plus XVIII"), DS(15, "Gravity Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII"), DS(15, "Extend Debuff Res Down XVI")],
[DS(15, "Evasion Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Beam Attack Plus XX"), DS(10, "Cooldown Reducer I"), DS(15, "Electric Attack Plus XX"), DS(15, "Gravity Attack Plus XX"), DS(15, "Front Attack Plus XX"), DS(15, "Extend Debuff Res Down XVIII")],
[DS(15, "Evasion Boost X"), DS(10, "Potential Boost X"), DS(10, "Ether Attack Plus II"), DS(10, "Cooldown Reducer III"), DS(15, "Gravity Attack Plus II"), DS(15, "Front Attack Plus II"), DS(15, "Side Attack Plus II"), DS(15, "Extend Debuff Res Down XX")],
[DS(15, "Evasion Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Ether Attack Plus IV"), DS(10, "Cooldown Reducer V"), DS(15, "Gravity Attack Plus IV"), DS(15, "Front Attack Plus IV"), DS(15, "Side Attack Plus IV"), DS(15, "ITM_SKL_IN_TIME_EX_HPDN02_name")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Ranged Attack Up III"), DS(10, "Beam Attack Plus XV"), DS(15, "Arts: Gain TP XIII"), DS(15, "Resist Shock XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Beam Attack Plus XVII"), DS(15, "Arts: Gain TP XV"), DS(15, "Resist Shock XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Beam Attack Plus XIX"), DS(15, "Arts: Gain TP XVII"), DS(15, "Resist Shock XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Ether Attack Plus I"), DS(15, "Arts: Gain TP XIX"), DS(15, "Debuff Suppressor II")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Ether Attack Plus III"), DS(15, "Arts: Recover HP I"), DS(15, "Debuff Suppressor IV")],
[DS(15, "Evasion Boost IV"), DS(10, "Potential Boost IV"), DS(10, "Beam Attack Plus XVI"), DS(10, "Magazine Capacity Up XIX"), DS(15, "Extend Critical Power XVII"), DS(15, "Theroid Slayer XVI"), DS(15, "Piscinoid Slayer XVI"), DS(15, "Insectoid Slayer XVI"), DS(15, "Ultrafauna Criticals Up XVII")],
[DS(15, "Evasion Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Beam Attack Plus XVIII"), DS(10, "Melee: TP Gain Up"), DS(15, "Extend Critical Power XIX"), DS(15, "Theroid Slayer XVIII"), DS(15, "Piscinoid Slayer XVIII"), DS(15, "Insectoid Slayer XVIII"), DS(15, "Ultrafauna Criticals Up XIX")],
[DS(15, "Evasion Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Beam Attack Plus XX"), DS(10, "Cooldown Reducer I"), DS(15, "Zero Critical"), DS(15, "Theroid Slayer XX"), DS(15, "Piscinoid Slayer XX"), DS(15, "Insectoid Slayer XX"), DS(15, "Extend Critical Power I")],
[DS(15, "Evasion Boost X"), DS(10, "Potential Boost X"), DS(10, "Ether Attack Plus II"), DS(10, "Cooldown Reducer III"), DS(15, "Theroid Slayer II"), DS(15, "Insectoid Slayer II"), DS(15, "Humanoid Slayer II"), DS(15, "Piscinoid Slayer II"), DS(15, "Extend Critical Power III")],
[DS(15, "Evasion Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Ether Attack Plus IV"), DS(10, "Cooldown Reducer V"), DS(15, "Theroid Slayer IV"), DS(15, "Insectoid Slayer IV"), DS(15, "Humanoid Slayer IV"), DS(15, "Piscinoid Slayer IV"), DS(15, "Extend Critical Power V")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Ranged Attack Up III"), DS(10, "Ultrafauna Slayer XV"), DS(15, "Potential Up III"), DS(15, "Resist Shock XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(15, "Potential Up V"), DS(15, "Resist Shock XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(15, "Potential Up VII"), DS(15, "Resist Shock XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Physical Attack Plus I"), DS(15, "Potential Up IX"), DS(15, "Debuff Suppressor II")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Physical Attack Plus III"), DS(15, "Potential Up XI"), DS(15, "Debuff Suppressor IV")],
[DS(15, "Evasion Boost IV"), DS(10, "Potential Boost IV"), DS(10, "Ultrafauna Slayer XVI"), DS(15, "Max HP Drive IV"), DS(10, "Magazine Capacity Up XIX"), DS(15, "Nullify Thermal Reflect XVI")],
[DS(15, "Evasion Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(15, "Max HP Drive VI"), DS(10, "Melee: TP Gain Up"), DS(15, "Nullify Thermal Reflect XVIII")],
[DS(15, "Evasion Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(15, "Max HP Drive VIII"), DS(10, "Cooldown Reducer I"), DS(15, "Nullify Thermal Reflect XX")],
[DS(15, "Evasion Boost X"), DS(10, "Potential Boost X"), DS(10, "Physical Attack Plus II"), DS(15, "Max HP Drive X"), DS(10, "Cooldown Reducer III"), DS(15, "Nullify Electric Reflect II")],
[DS(15, "Evasion Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Physical Attack Plus IV"), DS(15, "Max HP Drive XII"), DS(10, "Cooldown Reducer V"), DS(15, "Nullify Electric Reflect IV")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Ranged Attack Up III"), DS(10, "Ultrafauna Slayer XV"), DS(15, "Potential Up III"), DS(15, "Resist Shock XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(15, "Potential Up V"), DS(15, "Resist Shock XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(15, "Potential Up VII"), DS(15, "Resist Shock XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Physical Attack Plus I"), DS(15, "Potential Up IX"), DS(15, "Debuff Suppressor II")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Physical Attack Plus III"), DS(15, "Potential Up XI"), DS(15, "Debuff Suppressor IV")],
[DS(15, "Evasion Boost IV"), DS(10, "Potential Boost IV"), DS(10, "Ultrafauna Slayer XVI"), DS(15, "Max HP Drive IV"), DS(10, "Magazine Capacity Up XIX"), DS(15, "Nullify Thermal Reflect XVI")],
[DS(15, "Evasion Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(15, "Max HP Drive VI"), DS(10, "Melee: TP Gain Up"), DS(15, "Nullify Thermal Reflect XVIII")],
[DS(15, "Evasion Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(15, "Max HP Drive VIII"), DS(10, "Cooldown Reducer I"), DS(15, "Nullify Thermal Reflect XX")],
[DS(15, "Evasion Boost X"), DS(10, "Potential Boost X"), DS(10, "Physical Attack Plus II"), DS(15, "Max HP Drive X"), DS(10, "Cooldown Reducer III"), DS(15, "Nullify Electric Reflect II")],
[DS(15, "Evasion Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Physical Attack Plus IV"), DS(15, "Max HP Drive XII"), DS(10, "Cooldown Reducer V"), DS(15, "Nullify Electric Reflect IV")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Ranged Attack Up III"), DS(10, "Ultrafauna Slayer XV"), DS(15, "Extend Debuff Res Down XIII"), DS(15, "Critical Chance Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI"), DS(15, "Theroid Criticals Up XVI"), DS(15, "Debuff Suppressor XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(15, "Extend Debuff Res Down XV"), DS(15, "Critical Chance Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Debuff Suppressor XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(15, "Extend Debuff Res Down XVII"), DS(15, "Critical Chance Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Debuff Suppressor XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Physical Attack Plus I"), DS(15, "Extend Debuff Res Down XIX"), DS(15, "Theroid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Critical Chance Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Physical Attack Plus III"), DS(15, "ITM_SKL_IN_TIME_EX_HPDN01_name"), DS(15, "Theroid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Critical Chance Up IV")],
[DS(15, "Evasion Boost IV"), DS(10, "Potential Boost IV"), DS(10, "Ultrafauna Slayer XVI"), DS(10, "Magazine Capacity Up XIX"), DS(15, "Extend Critical Power XVII"), DS(15, "Theroid Slayer XVI"), DS(15, "Piscinoid Slayer XVI"), DS(15, "Insectoid Slayer XVI"), DS(15, "Ultrafauna Criticals Up XVII")],
[DS(15, "Evasion Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(10, "Melee: TP Gain Up"), DS(15, "Extend Critical Power XIX"), DS(15, "Theroid Slayer XVIII"), DS(15, "Piscinoid Slayer XVIII"), DS(15, "Insectoid Slayer XVIII"), DS(15, "Ultrafauna Criticals Up XIX")],
[DS(15, "Evasion Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(10, "Cooldown Reducer I"), DS(15, "Zero Critical"), DS(15, "Theroid Slayer XX"), DS(15, "Piscinoid Slayer XX"), DS(15, "Insectoid Slayer XX"), DS(15, "Extend Critical Power I")],
[DS(15, "Evasion Boost X"), DS(10, "Potential Boost X"), DS(10, "Physical Attack Plus II"), DS(10, "Cooldown Reducer III"), DS(15, "Theroid Slayer II"), DS(15, "Insectoid Slayer II"), DS(15, "Humanoid Slayer II"), DS(15, "Piscinoid Slayer II"), DS(15, "Extend Critical Power III")],
[DS(15, "Evasion Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Physical Attack Plus IV"), DS(10, "Cooldown Reducer V"), DS(15, "Theroid Slayer IV"), DS(15, "Insectoid Slayer IV"), DS(15, "Humanoid Slayer IV"), DS(15, "Piscinoid Slayer IV"), DS(15, "Extend Critical Power V")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Ranged Attack Up III"), DS(10, "Ultrafauna Slayer XV"), DS(15, "Extend Taunt XIII"), DS(15, "Extend Debuff Res Down XIII")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(15, "Extend Taunt XV"), DS(15, "Extend Debuff Res Down XV")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(15, "Extend Taunt XVII"), DS(15, "Extend Debuff Res Down XVII")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Physical Attack Plus I"), DS(15, "Extend Taunt XIX"), DS(15, "Extend Debuff Res Down XIX")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Physical Attack Plus III"), DS(15, "Extend Control I"), DS(15, "ITM_SKL_IN_TIME_EX_HPDN01_name")],
[DS(15, "Evasion Boost IV"), DS(10, "Potential Boost IV"), DS(10, "Ultrafauna Slayer XVI"), DS(10, "Magazine Capacity Up XIX"), DS(10, "ITM_SKL_IN_FST_SDEX14_name"), DS(15, "Nullify Thermal Reflect XVI")],
[DS(15, "Evasion Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(10, "Melee: TP Gain Up"), DS(10, "ITM_SKL_IN_FST_SDEX16_name"), DS(15, "Nullify Thermal Reflect XVIII")],
[DS(15, "Evasion Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(10, "Cooldown Reducer I"), DS(10, "ITM_SKL_IN_FST_SDEX18_name"), DS(15, "Nullify Thermal Reflect XX")],
[DS(15, "Evasion Boost X"), DS(10, "Potential Boost X"), DS(10, "Physical Attack Plus II"), DS(10, "Cooldown Reducer III"), DS(10, "ITM_SKL_IN_FST_SDEX20_name"), DS(15, "Nullify Electric Reflect II")],
[DS(15, "Evasion Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Physical Attack Plus IV"), DS(10, "Cooldown Reducer V"), DS(10, "ITM_SKL_IN_FST_EVA02_name"), DS(15, "Nullify Electric Reflect IV")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Ranged Attack Up III"), DS(10, "Ultrafauna Slayer XV"), DS(15, "Resist Shock XVI"), DS(15, "Theroid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI"), DS(15, "Insectoid Criticals Up XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(15, "Resist Shock XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII"), DS(15, "Insectoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(15, "Resist Shock XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX"), DS(15, "Insectoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Physical Attack Plus I"), DS(15, "Debuff Suppressor II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Humanoid Criticals Up II"), DS(15, "Piscinoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Physical Attack Plus III"), DS(15, "Debuff Suppressor IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV")],
[DS(15, "Evasion Boost IV"), DS(10, "Potential Boost IV"), DS(10, "Ultrafauna Slayer XVI"), DS(10, "Magazine Capacity Up XIX"), DS(10, "Destabilizer XIX"), DS(15, "Theroid Slayer XVI"), DS(15, "Piscinoid Slayer XVI"), DS(15, "Insectoid Slayer XVI"), DS(15, "Max HP Boost IV")],
[DS(15, "Evasion Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(10, "Melee: TP Gain Up"), DS(10, "Magazine Capacity Up I"), DS(15, "Theroid Slayer XVIII"), DS(15, "Piscinoid Slayer XVIII"), DS(15, "Insectoid Slayer XVIII"), DS(15, "Max HP Boost VI")],
[DS(15, "Evasion Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(10, "Cooldown Reducer I"), DS(10, "Magazine Capacity Up III"), DS(15, "Theroid Slayer XX"), DS(15, "Piscinoid Slayer XX"), DS(15, "Insectoid Slayer XX"), DS(15, "Max HP Boost VIII")],
[DS(15, "Evasion Boost X"), DS(10, "Potential Boost X"), DS(10, "Physical Attack Plus II"), DS(10, "Cooldown Reducer III"), DS(10, "Magazine Capacity Up V"), DS(15, "Insectoid Slayer II"), DS(15, "Humanoid Slayer II"), DS(15, "Piscinoid Slayer II"), DS(15, "Max HP Boost X")],
[DS(15, "Evasion Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Physical Attack Plus IV"), DS(10, "Cooldown Reducer V"), DS(10, "Magazine Capacity Up VII"), DS(15, "Insectoid Slayer IV"), DS(15, "Humanoid Slayer IV"), DS(15, "Piscinoid Slayer IV"), DS(15, "Max HP Boost XII")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Ranged Attack Up III"), DS(10, "Beam Attack Plus XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Theroid Criticals Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Beam Attack Plus XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Beam Attack Plus XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Ether Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Ether Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Evasion Boost IV"), DS(10, "Potential Boost IV"), DS(10, "Beam Attack Plus XVI"), DS(15, "Cooldown Reducer XVII"), DS(15, "Firing Range Up XVII"), DS(10, "Resist Stagger XVII"), DS(15, "Resist Flinch XVII"), DS(15, "Resist Topple XVII"), DS(10, "Weapon Attack Power Up IV"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Beam Attack Plus XVIII"), DS(15, "Cooldown Reducer XIX"), DS(15, "Firing Range Up XIX"), DS(10, "Resist Stagger XIX"), DS(15, "Resist Flinch XIX"), DS(15, "Resist Topple XIX"), DS(10, "Weapon Attack Power Up V"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Beam Attack Plus XX"), DS(15, "Firing Range Up I"), DS(15, "Resist Stagger I"), DS(10, "Resist Flinch I"), DS(15, "Resist Topple I"), DS(15, "Resist Knockback I"), DS(10, "Weapon Attack Power Up VI"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost X"), DS(10, "Potential Boost X"), DS(10, "Ether Attack Plus II"), DS(15, "Firing Range Up III"), DS(15, "Resist Stagger III"), DS(10, "Resist Flinch III"), DS(15, "Resist Topple III"), DS(15, "Resist Knockback III"), DS(10, "Weapon Attack Power Up VII"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Ether Attack Plus IV"), DS(15, "Firing Range Up V"), DS(15, "Resist Stagger V"), DS(10, "Resist Flinch V"), DS(15, "Resist Topple V"), DS(15, "Resist Knockback V"), DS(10, "Weapon Attack Power Up VIII"), DS(10, "Stabilizer X")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Ranged Attack Up III"), DS(10, "Potential Up III"), DS(10, "Ultrafauna Slayer XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Theroid Criticals Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Potential Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Physical Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Physical Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Evasion Boost IV"), DS(10, "Potential Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Ultrafauna Slayer XVI"), DS(15, "Resist Blackout XVII"), DS(15, "Resist Gravity Res Down XVII"), DS(10, "Topple: Decoy II"), DS(10, "Weapon Attack Power Up IV"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(15, "Resist Blackout XIX"), DS(15, "Resist Gravity Res Down XIX"), DS(10, "Topple: Decoy IV"), DS(10, "Weapon Attack Power Up V"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Ultrafauna Slayer XX"), DS(15, "Resist Fatigue I"), DS(15, "Resist Time Bomb I"), DS(10, "Topple: Decoy VI"), DS(10, "Weapon Attack Power Up VI"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost X"), DS(10, "Potential Boost X"), DS(10, "Max HP Drive X"), DS(10, "Physical Attack Plus II"), DS(15, "Resist Fatigue III"), DS(15, "Resist Time Bomb III"), DS(10, "Topple: Decoy VIII"), DS(10, "Weapon Attack Power Up VII"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Physical Attack Plus IV"), DS(15, "Resist Fatigue V"), DS(15, "Resist Time Bomb V"), DS(10, "Topple: Decoy X"), DS(10, "Weapon Attack Power Up VIII"), DS(10, "Stabilizer X")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Ranged Attack Up III"), DS(10, "Beam Attack Plus XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Theroid Criticals Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Beam Attack Plus XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Beam Attack Plus XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Ether Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Ether Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Evasion Boost IV"), DS(10, "Potential Boost IV"), DS(10, "Beam Attack Plus XVI"), DS(15, "Cooldown Reducer XVII"), DS(15, "Firing Range Up XVII"), DS(10, "Resist Stagger XVII"), DS(15, "Resist Flinch XVII"), DS(15, "Resist Topple XVII"), DS(10, "Weapon Attack Power Up IV"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Beam Attack Plus XVIII"), DS(15, "Cooldown Reducer XIX"), DS(15, "Firing Range Up XIX"), DS(10, "Resist Stagger XIX"), DS(15, "Resist Flinch XIX"), DS(15, "Resist Topple XIX"), DS(10, "Weapon Attack Power Up V"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Beam Attack Plus XX"), DS(15, "Firing Range Up I"), DS(15, "Resist Stagger I"), DS(10, "Resist Flinch I"), DS(15, "Resist Topple I"), DS(15, "Resist Knockback I"), DS(10, "Weapon Attack Power Up VI"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost X"), DS(10, "Potential Boost X"), DS(10, "Ether Attack Plus II"), DS(15, "Firing Range Up III"), DS(15, "Resist Stagger III"), DS(10, "Resist Flinch III"), DS(15, "Resist Topple III"), DS(15, "Resist Knockback III"), DS(10, "Weapon Attack Power Up VII"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Ether Attack Plus IV"), DS(15, "Firing Range Up V"), DS(15, "Resist Stagger V"), DS(10, "Resist Flinch V"), DS(15, "Resist Topple V"), DS(15, "Resist Knockback V"), DS(10, "Weapon Attack Power Up VIII"), DS(10, "Stabilizer X")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Ranged Attack Up III"), DS(10, "Ultrafauna Slayer XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Theroid Criticals Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Physical Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Physical Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Evasion Boost IV"), DS(10, "Potential Boost IV"), DS(10, "Ultrafauna Slayer XVI"), DS(10, "Ultrafauna Criticals Up XVII"), DS(10, "Extend Critical Power XVII"), DS(10, "Theroid Slayer XVI"), DS(10, "Insectoid Slayer XVI"), DS(10, "Piscinoid Slayer XVI")],
[DS(15, "Evasion Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(10, "Ultrafauna Criticals Up XIX"), DS(10, "Extend Critical Power XIX"), DS(10, "Theroid Slayer XVIII"), DS(10, "Insectoid Slayer XVIII"), DS(10, "Piscinoid Slayer XVIII")],
[DS(15, "Evasion Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(10, "Extend Critical Power I"), DS(10, "Zero Critical"), DS(10, "Theroid Slayer XX"), DS(10, "Insectoid Slayer XX"), DS(10, "Piscinoid Slayer XX")],
[DS(15, "Evasion Boost X"), DS(10, "Potential Boost X"), DS(10, "Physical Attack Plus II"), DS(10, "Extend Critical Power III"), DS(10, "Theroid Slayer II"), DS(10, "Insectoid Slayer II"), DS(10, "Piscinoid Slayer II"), DS(10, "Humanoid Slayer II")],
[DS(15, "Evasion Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Physical Attack Plus IV"), DS(10, "Extend Critical Power V"), DS(10, "Theroid Slayer IV"), DS(10, "Insectoid Slayer IV"), DS(10, "Piscinoid Slayer IV"), DS(10, "Humanoid Slayer IV")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Evasion Up III"), DS(10, "Overdrive Count Up XV")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Evasion Up V"), DS(10, "Overdrive Count Up XVII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(10, "Overdrive Count Up XIX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(10, "Extend Overdrive I")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(10, "Extend Overdrive III")],
[DS(15, "Evasion Boost IV"), DS(10, "Melee Attack Boost IV"), DS(10, "Overdrive Count Up XVI"), DS(15, "Firing Range Up XVII"), DS(15, "Resist Knockback XVII"), DS(15, "Resist Launch XVII"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost VI"), DS(10, "Melee Attack Boost VI"), DS(10, "Overdrive Count Up XVIII"), DS(15, "Firing Range Up XIX"), DS(15, "Resist Knockback XIX"), DS(15, "Resist Launch XIX"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(10, "Overdrive Count Up XX"), DS(15, "Resist Stagger I"), DS(15, "Resist Launch I"), DS(15, "Resist Stun I"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost X"), DS(10, "Melee Attack Boost X"), DS(10, "Extend Overdrive II"), DS(15, "Resist Stagger III"), DS(15, "Resist Launch III"), DS(15, "Resist Stun III"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost XII"), DS(10, "Melee Attack Boost XII"), DS(10, "Extend Overdrive IV"), DS(15, "Resist Stagger V"), DS(15, "Resist Launch V"), DS(15, "Resist Stun V"), DS(10, "Stabilizer X")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Ranged Attack Up III"), DS(10, "Ether Attack Plus XV"), DS(15, "Arts: Recover HP XIV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Theroid Criticals Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Ether Attack Plus XVII"), DS(15, "Arts: Recover HP XIV"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Ether Attack Plus XIX"), DS(15, "Arts: Recover HP XIV"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Thermal Attack Plus I"), DS(15, "Arts: Recover HP XIV"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Thermal Attack Plus III"), DS(15, "Arts: Recover HP XIV"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Evasion Boost IV"), DS(10, "Potential Boost IV"), DS(10, "Ether Attack Plus XVI"), DS(10, "Stabilizer XIX"), DS(10, "Magazine Capacity Up XIX"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Ether Attack Plus XVIII"), DS(10, "Destabilizer I"), DS(10, "Melee: TP Gain Up"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Ether Attack Plus XX"), DS(10, "Destabilizer III"), DS(10, "Cooldown Reducer I"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost X"), DS(10, "Potential Boost X"), DS(10, "Thermal Attack Plus II"), DS(10, "Destabilizer V"), DS(10, "Cooldown Reducer III"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Thermal Attack Plus IV"), DS(10, "Destabilizer VII"), DS(10, "Cooldown Reducer V"), DS(10, "Stabilizer X")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Ranged Attack Up III"), DS(10, "Ultrafauna Slayer XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Theroid Criticals Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Physical Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Physical Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Evasion Boost IV"), DS(10, "Potential Boost IV"), DS(10, "Ultrafauna Slayer XVI"), DS(10, "Extend Critical Power V"), DS(10, "Theroid Slayer IV"), DS(10, "Insectoid Slayer IV"), DS(10, "Piscinoid Slayer IV"), DS(10, "Humanoid Slayer IV"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(10, "Extend Critical Power V"), DS(10, "Theroid Slayer IV"), DS(10, "Insectoid Slayer IV"), DS(10, "Piscinoid Slayer IV"), DS(10, "Humanoid Slayer IV"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(10, "Extend Critical Power V"), DS(10, "Theroid Slayer IV"), DS(10, "Insectoid Slayer IV"), DS(10, "Piscinoid Slayer IV"), DS(10, "Humanoid Slayer IV"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost X"), DS(10, "Potential Boost X"), DS(10, "Physical Attack Plus II"), DS(10, "Extend Critical Power V"), DS(10, "Theroid Slayer IV"), DS(10, "Insectoid Slayer IV"), DS(10, "Piscinoid Slayer IV"), DS(10, "Humanoid Slayer IV"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Physical Attack Plus IV"), DS(10, "Extend Critical Power V"), DS(10, "Theroid Slayer IV"), DS(10, "Insectoid Slayer IV"), DS(10, "Piscinoid Slayer IV"), DS(10, "Humanoid Slayer IV"), DS(10, "Stabilizer X")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Melee Accuracy Up III"), DS(10, "Evasion Up III"), DS(15, "Ranged Attack Up III"), DS(15, "Melee Attack Up III"), DS(10, "Chimeroid Slayer XV")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Melee Accuracy Up V"), DS(10, "Evasion Up V"), DS(15, "Ranged Attack Up V"), DS(15, "Melee Attack Up V"), DS(10, "Chimeroid Slayer XVII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Melee Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(15, "Ranged Attack Up VII"), DS(15, "Melee Attack Up VII"), DS(10, "Chimeroid Slayer XIX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Melee Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(15, "Ranged Attack Up IX"), DS(15, "Melee Attack Up IX"), DS(10, "Ultrafauna Slayer I")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Melee Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(15, "Ranged Attack Up XI"), DS(15, "Melee Attack Up XI"), DS(10, "Ultrafauna Slayer III")],
[DS(10, "Max HP Up IV"), DS(10, "Melee: Recover HP XVI"), DS(10, "Chimeroid Slayer XVI"), DS(15, "Max GP Drive VII"), DS(10, "Magazine Capacity Up XIX"), DS(10, "Stabilizer XIX")],
[DS(10, "Max HP Up VI"), DS(10, "Melee: Recover HP XVIII"), DS(10, "Chimeroid Slayer XVIII"), DS(15, "Max GP Drive IX"), DS(10, "Melee: TP Gain Up"), DS(10, "Destabilizer I")],
[DS(10, "Max HP Up VIII"), DS(10, "Melee: Recover HP XX"), DS(10, "Chimeroid Slayer XX"), DS(15, "Max GP Drive XI"), DS(10, "Cooldown Reducer I"), DS(10, "Destabilizer III")],
[DS(10, "Max HP Up X"), DS(10, "Soft Touch II"), DS(10, "Ultrafauna Slayer II"), DS(15, "Max GP Drive XIII"), DS(10, "Cooldown Reducer III"), DS(10, "Destabilizer V")],
[DS(10, "Max HP Up XII"), DS(10, "Soft Touch IV"), DS(10, "Ultrafauna Slayer IV"), DS(15, "Max GP Drive XV"), DS(10, "Cooldown Reducer V"), DS(10, "Destabilizer VII")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Melee Accuracy Up III"), DS(10, "Evasion Up III"), DS(15, "Ranged Attack Up III"), DS(15, "Melee Attack Up III"), DS(10, "Ultrafauna Slayer XV")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Melee Accuracy Up V"), DS(10, "Evasion Up V"), DS(15, "Ranged Attack Up V"), DS(15, "Melee Attack Up V"), DS(10, "Ultrafauna Slayer XVII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Melee Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(15, "Ranged Attack Up VII"), DS(15, "Melee Attack Up VII"), DS(10, "Ultrafauna Slayer XIX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Melee Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(15, "Ranged Attack Up IX"), DS(15, "Melee Attack Up IX"), DS(10, "Physical Attack Plus I")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Melee Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(15, "Ranged Attack Up XI"), DS(15, "Melee Attack Up XI"), DS(10, "Physical Attack Plus III")],
[DS(10, "Max HP Up IV"), DS(10, "Melee: Recover HP XVI"), DS(10, "Ultrafauna Slayer XVI"), DS(15, "Melee Accuracy Drive VII"), DS(15, "Ranged Accuracy Drive VII"), DS(10, "Magazine Capacity Up XIX"), DS(10, "Stabilizer XIX")],
[DS(10, "Max HP Up VI"), DS(10, "Melee: Recover HP XVIII"), DS(10, "Ultrafauna Slayer XVIII"), DS(15, "Melee Accuracy Drive IX"), DS(15, "Ranged Accuracy Drive IX"), DS(10, "Melee: TP Gain Up"), DS(10, "Destabilizer I")],
[DS(10, "Max HP Up VIII"), DS(10, "Melee: Recover HP XX"), DS(10, "Ultrafauna Slayer XX"), DS(15, "Melee Accuracy Drive XI"), DS(15, "Ranged Accuracy Drive XI"), DS(10, "Cooldown Reducer I"), DS(10, "Destabilizer III")],
[DS(10, "Max HP Up X"), DS(10, "Soft Touch II"), DS(10, "Physical Attack Plus II"), DS(15, "Melee Accuracy Drive XIII"), DS(15, "Ranged Accuracy Drive XIII"), DS(10, "Cooldown Reducer III"), DS(10, "Destabilizer V")],
[DS(10, "Max HP Up XII"), DS(10, "Soft Touch IV"), DS(10, "Physical Attack Plus IV"), DS(15, "Melee Accuracy Drive XV"), DS(15, "Ranged Accuracy Drive XV"), DS(10, "Cooldown Reducer V"), DS(10, "Destabilizer VII")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Melee Accuracy Up III"), DS(10, "Evasion Up III"), DS(15, "Ranged Attack Up III"), DS(15, "Melee Attack Up III"), DS(10, "Beam Attack Plus XV")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Melee Accuracy Up V"), DS(10, "Evasion Up V"), DS(15, "Ranged Attack Up V"), DS(15, "Melee Attack Up V"), DS(10, "Beam Attack Plus XVII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Melee Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(15, "Ranged Attack Up VII"), DS(15, "Melee Attack Up VII"), DS(10, "Beam Attack Plus XIX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Melee Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(15, "Ranged Attack Up IX"), DS(15, "Melee Attack Up IX"), DS(10, "Ether Attack Plus I")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Melee Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(15, "Ranged Attack Up XI"), DS(15, "Melee Attack Up XI"), DS(10, "Ether Attack Plus III")],
[DS(10, "Max HP Up IV"), DS(10, "Melee: Recover HP XVI"), DS(10, "Beam Attack Plus XVI"), DS(15, "Evasion Drive VII"), DS(10, "Magazine Capacity Up XIX"), DS(10, "Stabilizer XIX")],
[DS(10, "Max HP Up VI"), DS(10, "Melee: Recover HP XVIII"), DS(10, "Beam Attack Plus XVIII"), DS(15, "Evasion Drive IX"), DS(10, "Melee: TP Gain Up"), DS(10, "Destabilizer I")],
[DS(10, "Max HP Up VIII"), DS(10, "Melee: Recover HP XX"), DS(10, "Beam Attack Plus XX"), DS(15, "Evasion Drive XI"), DS(10, "Cooldown Reducer I"), DS(10, "Destabilizer III")],
[DS(10, "Max HP Up X"), DS(10, "Soft Touch II"), DS(10, "Ether Attack Plus II"), DS(15, "Evasion Drive XIII"), DS(10, "Cooldown Reducer III"), DS(10, "Destabilizer V")],
[DS(10, "Max HP Up XII"), DS(10, "Soft Touch IV"), DS(10, "Ether Attack Plus IV"), DS(15, "Evasion Drive XV"), DS(10, "Cooldown Reducer V"), DS(10, "Destabilizer VII")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Melee Accuracy Up III"), DS(10, "Evasion Up III"), DS(15, "Ranged Attack Up III"), DS(15, "Melee Attack Up III"), DS(10, "Thermal Attack Plus XV")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Melee Accuracy Up V"), DS(10, "Evasion Up V"), DS(15, "Ranged Attack Up V"), DS(15, "Melee Attack Up V"), DS(10, "Thermal Attack Plus XVII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Melee Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(15, "Ranged Attack Up VII"), DS(15, "Melee Attack Up VII"), DS(10, "Thermal Attack Plus XIX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Melee Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(15, "Ranged Attack Up IX"), DS(15, "Melee Attack Up IX"), DS(10, "Electric Attack Plus I")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Melee Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(15, "Ranged Attack Up XI"), DS(15, "Melee Attack Up XI"), DS(10, "Electric Attack Plus III")],
[DS(10, "Max HP Up IV"), DS(10, "Melee: Recover HP XVI"), DS(10, "Thermal Attack Plus XVI"), DS(15, "Melee Attack Drive VII"), DS(15, "Ranged Attack Drive VII"), DS(10, "Magazine Capacity Up XIX"), DS(10, "Stabilizer XIX")],
[DS(10, "Max HP Up VI"), DS(10, "Melee: Recover HP XVIII"), DS(10, "Thermal Attack Plus XVIII"), DS(15, "Melee Attack Drive IX"), DS(15, "Ranged Attack Drive IX"), DS(10, "Melee: TP Gain Up"), DS(10, "Destabilizer I")],
[DS(10, "Max HP Up VIII"), DS(10, "Melee: Recover HP XX"), DS(10, "Thermal Attack Plus XX"), DS(15, "Melee Attack Drive XI"), DS(15, "Ranged Attack Drive XI"), DS(10, "Cooldown Reducer I"), DS(10, "Destabilizer III")],
[DS(10, "Max HP Up X"), DS(10, "Soft Touch II"), DS(10, "Electric Attack Plus II"), DS(15, "Melee Attack Drive XIII"), DS(15, "Ranged Attack Drive XIII"), DS(10, "Cooldown Reducer III"), DS(10, "Destabilizer V")],
[DS(10, "Max HP Up XII"), DS(10, "Soft Touch IV"), DS(10, "Electric Attack Plus IV"), DS(15, "Melee Attack Drive XV"), DS(15, "Ranged Attack Drive XV"), DS(10, "Cooldown Reducer V"), DS(10, "Destabilizer VII")],
[DS(15, "Melee Accuracy Up III"), DS(10, "Melee Attack Up III"), DS(10, "Evasion Up III"), DS(10, "Beam Attack Plus XV"), DS(15, "Evasion Drive VI")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Melee Attack Up V"), DS(10, "Evasion Up V"), DS(10, "Beam Attack Plus XVII"), DS(15, "Evasion Drive VIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Melee Attack Up VII"), DS(10, "Evasion Up VII"), DS(10, "Beam Attack Plus XIX"), DS(15, "Evasion Drive X")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Melee Attack Up IX"), DS(10, "Evasion Up IX"), DS(10, "Ether Attack Plus I"), DS(15, "Evasion Drive XII")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Melee Attack Up XI"), DS(10, "Evasion Up XI"), DS(10, "Ether Attack Plus III"), DS(15, "Evasion Drive XIV")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Ranged Attack Boost IV"), DS(10, "Melee Attack Boost IV"), DS(10, "Beam Attack Plus XVI"), DS(15, "Evasion Drive VII"), DS(10, "Magazine Capacity Up XIX"), DS(10, "HP Rebound XVI")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ranged Attack Boost VI"), DS(10, "Melee Attack Boost VI"), DS(10, "Beam Attack Plus XVIII"), DS(15, "Evasion Drive IX"), DS(10, "Melee: TP Gain Up"), DS(10, "HP Rebound XVIII")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ranged Attack Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(10, "Beam Attack Plus XX"), DS(15, "Evasion Drive XI"), DS(10, "Cooldown Reducer I"), DS(10, "HP Rebound XX")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Ranged Attack Boost X"), DS(10, "Melee Attack Boost X"), DS(10, "Ether Attack Plus II"), DS(15, "Evasion Drive XIII"), DS(10, "Cooldown Reducer III"), DS(10, "TP Rebound II")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Ranged Attack Boost XII"), DS(10, "Melee Attack Boost XII"), DS(10, "Ether Attack Plus IV"), DS(15, "Evasion Drive XV"), DS(10, "Cooldown Reducer V"), DS(10, "TP Rebound IV")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Evasion Up III"), DS(15, "Resist Control XVII"), DS(15, "Resist Blackout XVII"), DS(15, "Resist Sleep XVII"), DS(15, "Resist Taunt XVII"), DS(10, "Overdrive: Recover HP XV")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Evasion Up V"), DS(15, "Resist Control XIX"), DS(15, "Resist Blackout XIX"), DS(15, "Resist Sleep XIX"), DS(15, "Resist Taunt XIX"), DS(10, "Overdrive: Recover HP XVII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(15, "Resist Virus I"), DS(15, "Resist Fatigue I"), DS(15, "Resist Taunt I"), DS(15, "Resist Control I"), DS(10, "Overdrive: Recover HP XIX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(15, "Resist Virus III"), DS(15, "Resist Fatigue III"), DS(15, "Resist Taunt III"), DS(15, "Resist Control III"), DS(10, "Overdrive: Gain TP I")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(15, "Resist Virus V"), DS(15, "Resist Fatigue V"), DS(15, "Resist Taunt V"), DS(15, "Resist Control V"), DS(10, "Overdrive: Gain TP III")],
[DS(15, "Evasion Boost IV"), DS(10, "Melee Attack Boost IV"), DS(15, "Resist Control XVII"), DS(15, "Resist Blackout XVII"), DS(15, "Resist Sleep XVII"), DS(15, "Resist Taunt XVII"), DS(10, "ITM_SKL_IN_FST_EVA13_name")],
[DS(15, "Evasion Boost VI"), DS(10, "Melee Attack Boost VI"), DS(15, "Resist Control XIX"), DS(15, "Resist Blackout XIX"), DS(15, "Resist Sleep XIX"), DS(15, "Resist Taunt XIX"), DS(10, "ITM_SKL_IN_FST_EVA15_name")],
[DS(15, "Evasion Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(15, "Resist Virus I"), DS(15, "Resist Fatigue I"), DS(15, "Resist Taunt I"), DS(15, "Resist Control I"), DS(10, "ITM_SKL_IN_FST_EVA17_name")],
[DS(15, "Evasion Boost X"), DS(10, "Melee Attack Boost X"), DS(15, "Resist Virus III"), DS(15, "Resist Fatigue III"), DS(15, "Resist Taunt III"), DS(15, "Resist Control III"), DS(10, "ITM_SKL_IN_FST_EVA19_name")],
[DS(15, "Evasion Boost XII"), DS(10, "Melee Attack Boost XII"), DS(15, "Resist Virus V"), DS(15, "Resist Fatigue V"), DS(15, "Resist Taunt V"), DS(15, "Resist Control V"), DS(10, "ITM_SKL_IN_FST_FPOW01_name")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Evasion Up III"), DS(15, "Resist Virus XVII"), DS(15, "Resist Blackout XVII"), DS(15, "Resist Sleep XVII"), DS(15, "Resist Taunt XVII"), DS(10, "Extend Overdrive XV")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Evasion Up V"), DS(15, "Resist Virus XIX"), DS(15, "Resist Blackout XIX"), DS(15, "Resist Sleep XIX"), DS(15, "Resist Taunt XIX"), DS(10, "Extend Overdrive XVII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(15, "Resist Blackout I"), DS(15, "Resist Fatigue I"), DS(15, "Resist Taunt I"), DS(15, "Resist Control I"), DS(10, "Extend Overdrive XIX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(15, "Resist Blackout III"), DS(15, "Resist Fatigue III"), DS(15, "Resist Taunt III"), DS(15, "Resist Control III"), DS(10, "Overdrive Blue Bonus")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(15, "Resist Blackout V"), DS(15, "Resist Fatigue V"), DS(15, "Resist Taunt V"), DS(15, "Resist Control V"), DS(10, "Extend Aura I")],
[DS(15, "Evasion Boost IV"), DS(10, "Melee Attack Boost IV"), DS(15, "Resist Virus XVII"), DS(15, "Resist Blackout XVII"), DS(15, "Resist Sleep XVII"), DS(15, "Resist Taunt XVII"), DS(10, "ITM_SKL_IN_FST_EVA13_name")],
[DS(15, "Evasion Boost VI"), DS(10, "Melee Attack Boost VI"), DS(15, "Resist Virus XIX"), DS(15, "Resist Blackout XIX"), DS(15, "Resist Sleep XIX"), DS(15, "Resist Taunt XIX"), DS(10, "ITM_SKL_IN_FST_EVA15_name")],
[DS(15, "Evasion Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(15, "Resist Blackout I"), DS(15, "Resist Fatigue I"), DS(15, "Resist Taunt I"), DS(15, "Resist Control I"), DS(10, "ITM_SKL_IN_FST_EVA17_name")],
[DS(15, "Evasion Boost X"), DS(10, "Melee Attack Boost X"), DS(15, "Resist Blackout III"), DS(15, "Resist Fatigue III"), DS(15, "Resist Taunt III"), DS(15, "Resist Control III"), DS(10, "ITM_SKL_IN_FST_EVA19_name")],
[DS(15, "Evasion Boost XII"), DS(10, "Melee Attack Boost XII"), DS(15, "Resist Blackout V"), DS(15, "Resist Fatigue V"), DS(15, "Resist Taunt V"), DS(15, "Resist Control V"), DS(10, "ITM_SKL_IN_FST_FPOW01_name")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Evasion Up III"), DS(10, "Ranged Attack Up III"), DS(10, "Potential Up III"), DS(10, "Max HP Up III")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Evasion Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Potential Up V"), DS(10, "Max HP Up V")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Max HP Up VII")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Max HP Up IX")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Max HP Up XI")],
[DS(15, "Evasion Boost IV"), DS(10, "Melee Attack Boost IV"), DS(10, "Potential Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Max TP Boost IV")],
[DS(15, "Evasion Boost VI"), DS(10, "Melee Attack Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Max TP Boost VI")],
[DS(15, "Evasion Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Max TP Boost VIII")],
[DS(15, "Evasion Boost X"), DS(10, "Melee Attack Boost X"), DS(10, "Potential Boost X"), DS(10, "Max HP Drive X"), DS(10, "Max TP Boost X")],
[DS(15, "Evasion Boost XII"), DS(10, "Melee Attack Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Max TP Boost XII")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Ranged Attack Up III"), DS(10, "Chimeroid Slayer XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Theroid Criticals Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Chimeroid Slayer XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Chimeroid Slayer XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Ultrafauna Slayer I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Ultrafauna Slayer III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Evasion Boost IV"), DS(10, "Potential Boost IV"), DS(10, "Chimeroid Slayer XVI"), DS(10, "Destabilizer XIX"), DS(10, "Magazine Capacity Up XIX"), DS(10, "Gravity Resistance Up IV")],
[DS(15, "Evasion Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Chimeroid Slayer XVIII"), DS(10, "Magazine Capacity Up I"), DS(10, "Melee: TP Gain Up"), DS(10, "Gravity Resistance Up V")],
[DS(15, "Evasion Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Chimeroid Slayer XX"), DS(10, "Magazine Capacity Up III"), DS(10, "Cooldown Reducer I"), DS(10, "Gravity Resistance Up VI")],
[DS(15, "Evasion Boost X"), DS(10, "Potential Boost X"), DS(10, "Ultrafauna Slayer II"), DS(10, "Magazine Capacity Up V"), DS(10, "Cooldown Reducer III"), DS(10, "Gravity Resistance Up VII")],
[DS(15, "Evasion Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Ultrafauna Slayer IV"), DS(10, "Magazine Capacity Up VII"), DS(10, "Cooldown Reducer V"), DS(10, "Gravity Resistance Up VIII")],
[DS(15, "Ranged Accuracy Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Ultrafauna Slayer XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Theroid Criticals Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Physical Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Physical Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Evasion Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Ultrafauna Slayer XVI"), DS(10, "Ultrafauna Criticals Up XVII"), DS(10, "Extend Critical Power XVII"), DS(10, "Theroid Slayer XVI"), DS(10, "Piscinoid Slayer XVI"), DS(10, "Insectoid Slayer XVI"), DS(10, "Gravity Resistance Up IV")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(10, "Ultrafauna Criticals Up XIX"), DS(10, "Extend Critical Power XIX"), DS(10, "Theroid Slayer XVIII"), DS(10, "Piscinoid Slayer XVIII"), DS(10, "Insectoid Slayer XVIII"), DS(10, "Gravity Resistance Up V")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(10, "Extend Critical Power I"), DS(10, "Zero Critical"), DS(10, "Theroid Slayer XX"), DS(10, "Piscinoid Slayer XX"), DS(10, "Insectoid Slayer XX"), DS(10, "Gravity Resistance Up VI")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Physical Attack Plus II"), DS(10, "Extend Critical Power III"), DS(10, "Theroid Slayer II"), DS(10, "Insectoid Slayer II"), DS(10, "Humanoid Slayer II"), DS(10, "Piscinoid Slayer II"), DS(10, "Gravity Resistance Up VII")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Physical Attack Plus IV"), DS(10, "Extend Critical Power V"), DS(10, "Theroid Slayer IV"), DS(10, "Insectoid Slayer IV"), DS(10, "Humanoid Slayer IV"), DS(10, "Piscinoid Slayer IV"), DS(10, "Gravity Resistance Up VIII")],
[DS(15, "Ranged Accuracy Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Chimeroid Slayer XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Theroid Criticals Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Chimeroid Slayer XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Chimeroid Slayer XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Ultrafauna Slayer I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Ultrafauna Slayer III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Evasion Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Chimeroid Slayer XVI"), DS(10, "Destabilizer XIX"), DS(10, "Destabilizer XIX"), DS(10, "Magazine Capacity Up XIX"), DS(15, "Electric Attack Plus XVI"), DS(10, "Front Attack Plus XVI"), DS(10, "Side Attack Plus XVI")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Chimeroid Slayer XVIII"), DS(10, "Magazine Capacity Up I"), DS(10, "Magazine Capacity Up I"), DS(10, "Melee: TP Gain Up"), DS(15, "Electric Attack Plus XVIII"), DS(10, "Front Attack Plus XVIII"), DS(10, "Side Attack Plus XVIII")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Chimeroid Slayer XX"), DS(10, "Magazine Capacity Up III"), DS(10, "Magazine Capacity Up III"), DS(10, "Cooldown Reducer I"), DS(15, "Electric Attack Plus XX"), DS(10, "Front Attack Plus XX"), DS(10, "Side Attack Plus XX")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Ultrafauna Slayer II"), DS(10, "Magazine Capacity Up V"), DS(10, "Magazine Capacity Up V"), DS(10, "Cooldown Reducer III"), DS(15, "Gravity Attack Plus II"), DS(10, "Side Attack Plus II"), DS(10, "Back Attack Plus II")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Ultrafauna Slayer IV"), DS(10, "Magazine Capacity Up VII"), DS(10, "Magazine Capacity Up VII"), DS(10, "Cooldown Reducer V"), DS(15, "Gravity Attack Plus IV"), DS(10, "Side Attack Plus IV"), DS(10, "Back Attack Plus IV")],
[DS(15, "Ranged Accuracy Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Ether Attack Plus XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Theroid Criticals Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Ether Attack Plus XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Ether Attack Plus XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Thermal Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Thermal Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Evasion Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Ether Attack Plus XVI"), DS(15, "Arts: Recover HP XIV"), DS(10, "Ultrafauna Criticals Up XVII"), DS(10, "Extend Critical Power XVII"), DS(10, "Theroid Slayer XVI"), DS(10, "Piscinoid Slayer XVI"), DS(10, "Insectoid Slayer XVI")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Ether Attack Plus XVIII"), DS(15, "Arts: Recover HP XVI"), DS(10, "Ultrafauna Criticals Up XIX"), DS(10, "Extend Critical Power XIX"), DS(10, "Theroid Slayer XVIII"), DS(10, "Piscinoid Slayer XVIII"), DS(10, "Insectoid Slayer XVIII")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Ether Attack Plus XX"), DS(15, "Arts: Recover HP XVIII"), DS(10, "Extend Critical Power I"), DS(10, "Zero Critical"), DS(10, "Theroid Slayer XX"), DS(10, "Piscinoid Slayer XX"), DS(10, "Insectoid Slayer XX")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Thermal Attack Plus II"), DS(15, "Arts: Recover HP XX"), DS(10, "Extend Critical Power III"), DS(10, "Theroid Slayer II"), DS(10, "Insectoid Slayer II"), DS(10, "Humanoid Slayer II"), DS(10, "Piscinoid Slayer II")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Thermal Attack Plus IV"), DS(15, "Secondary CD Reducer II"), DS(10, "Extend Critical Power V"), DS(10, "Theroid Slayer IV"), DS(10, "Insectoid Slayer IV"), DS(10, "Humanoid Slayer IV"), DS(10, "Piscinoid Slayer IV")],
[DS(15, "Ranged Accuracy Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Beam Attack Plus XV"), DS(15, "Nullify Electric Reflect XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Beam Attack Plus XVII"), DS(15, "Nullify Electric Reflect XVI")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Beam Attack Plus XIX"), DS(15, "Nullify Electric Reflect XVI")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Ether Attack Plus I"), DS(15, "Nullify Electric Reflect XVI")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Ether Attack Plus III"), DS(15, "Nullify Electric Reflect XVI")],
[DS(15, "Evasion Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Beam Attack Plus XVI"), DS(10, "Destabilizer XIX"), DS(10, "Magazine Capacity Up XIX")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Beam Attack Plus XVIII"), DS(10, "Magazine Capacity Up I"), DS(10, "Melee: TP Gain Up")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Beam Attack Plus XX"), DS(10, "Magazine Capacity Up III"), DS(10, "Cooldown Reducer I")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Ether Attack Plus II"), DS(10, "Magazine Capacity Up V"), DS(10, "Cooldown Reducer III")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Ether Attack Plus IV"), DS(10, "Magazine Capacity Up VII"), DS(10, "Cooldown Reducer V")],
[DS(15, "Ranged Accuracy Up III"), DS(15, "Overdrive Count Up XV"), DS(10, "Evasion Up III")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Overdrive Count Up XVII"), DS(10, "Evasion Up V")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Overdrive Count Up XIX"), DS(10, "Evasion Up VII")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Extend Overdrive I"), DS(10, "Evasion Up IX")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Extend Overdrive III"), DS(10, "Evasion Up XI")],
[DS(15, "Resist Control XVII"), DS(15, "Resist Taunt XVII"), DS(10, "Destabilizer XIX"), DS(10, "Magazine Capacity Up XIX"), DS(10, "Soft Touch XVI")],
[DS(15, "Resist Control XIX"), DS(15, "Resist Taunt XIX"), DS(10, "Magazine Capacity Up I"), DS(10, "Melee: TP Gain Up"), DS(10, "Soft Touch XVIII")],
[DS(15, "Resist Virus I"), DS(15, "Resist Control I"), DS(10, "Magazine Capacity Up III"), DS(10, "Cooldown Reducer I"), DS(10, "Soft Touch XX")],
[DS(15, "Resist Virus III"), DS(15, "Resist Control III"), DS(10, "Magazine Capacity Up V"), DS(10, "Cooldown Reducer III"), DS(10, "HP Rebound II")],
[DS(15, "Resist Virus V"), DS(15, "Resist Control V"), DS(10, "Magazine Capacity Up VII"), DS(10, "Cooldown Reducer V"), DS(10, "HP Rebound IV")],
[DS(15, "Ranged Accuracy Up III"), DS(15, "Extend Overdrive XV"), DS(10, "Evasion Up III")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Extend Overdrive XVII"), DS(10, "Evasion Up V")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Extend Overdrive XIX"), DS(10, "Evasion Up VII")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Overdrive Blue Bonus"), DS(10, "Evasion Up IX")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Extend Aura I"), DS(10, "Evasion Up XI")],
[DS(15, "Resist Virus XVII"), DS(15, "Resist Blackout XVII"), DS(10, "Destabilizer XIX"), DS(10, "Magazine Capacity Up XIX"), DS(10, "Soft Touch XVI")],
[DS(15, "Resist Virus XIX"), DS(15, "Resist Blackout XIX"), DS(10, "Magazine Capacity Up I"), DS(10, "Melee: TP Gain Up"), DS(10, "Soft Touch XVIII")],
[DS(15, "Resist Blackout I"), DS(15, "Resist Fatigue I"), DS(10, "Magazine Capacity Up III"), DS(10, "Cooldown Reducer I"), DS(10, "Soft Touch XX")],
[DS(15, "Resist Blackout III"), DS(15, "Resist Fatigue III"), DS(10, "Magazine Capacity Up V"), DS(10, "Cooldown Reducer III"), DS(10, "HP Rebound II")],
[DS(15, "Resist Blackout V"), DS(15, "Resist Fatigue V"), DS(10, "Magazine Capacity Up VII"), DS(10, "Cooldown Reducer V"), DS(10, "HP Rebound IV")],
[DS(15, "Ranged Accuracy Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Beam Attack Plus XV")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Beam Attack Plus XVII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Beam Attack Plus XIX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Ether Attack Plus I")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Ether Attack Plus III")],
[DS(15, "Evasion Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Beam Attack Plus XVI"), DS(10, "Destabilizer XIX"), DS(10, "Magazine Capacity Up XIX")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Beam Attack Plus XVIII"), DS(10, "Magazine Capacity Up I"), DS(10, "Melee: TP Gain Up")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Beam Attack Plus XX"), DS(10, "Magazine Capacity Up III"), DS(10, "Cooldown Reducer I")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Ether Attack Plus II"), DS(10, "Magazine Capacity Up V"), DS(10, "Cooldown Reducer III")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Ether Attack Plus IV"), DS(10, "Magazine Capacity Up VII"), DS(10, "Cooldown Reducer V")],
[DS(15, "Ranged Accuracy Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Potential Up III"), DS(10, "Ultrafauna Slayer XV")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Potential Up V"), DS(10, "Ultrafauna Slayer XVII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Ultrafauna Slayer XIX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Physical Attack Plus I")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Physical Attack Plus III")],
[DS(15, "Evasion Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Ultrafauna Slayer XVI"), DS(10, "Destabilizer XIX"), DS(10, "Magazine Capacity Up XIX")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(10, "Magazine Capacity Up I"), DS(10, "Melee: TP Gain Up")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Ultrafauna Slayer XX"), DS(10, "Magazine Capacity Up III"), DS(10, "Cooldown Reducer I")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Max HP Drive X"), DS(10, "Physical Attack Plus II"), DS(10, "Magazine Capacity Up V"), DS(10, "Cooldown Reducer III")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Physical Attack Plus IV"), DS(10, "Magazine Capacity Up VII"), DS(10, "Cooldown Reducer V")],
[DS(15, "Ranged Accuracy Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Ultrafauna Slayer XV")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Ultrafauna Slayer XVII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Ultrafauna Slayer XIX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Physical Attack Plus I")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Physical Attack Plus III")],
[DS(15, "Evasion Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Ultrafauna Slayer XVI"), DS(10, "ITM_SKL_IN_FST_SDEX14_name"), DS(10, "Topple: Decoy II")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(10, "ITM_SKL_IN_FST_SDEX16_name"), DS(10, "Topple: Decoy IV")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(10, "ITM_SKL_IN_FST_SDEX18_name"), DS(10, "Topple: Decoy VI")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Physical Attack Plus II"), DS(10, "ITM_SKL_IN_FST_SDEX20_name"), DS(10, "Topple: Decoy VIII")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Physical Attack Plus IV"), DS(10, "ITM_SKL_IN_FST_EVA02_name"), DS(10, "Topple: Decoy X")],
[DS(15, "Ranged Accuracy Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Potential Up III"), DS(10, "Beam Attack Plus XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Piscinoid Criticals Up XVI"), DS(15, "Insectoid Criticals Up XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Potential Up V"), DS(10, "Beam Attack Plus XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII"), DS(15, "Insectoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Beam Attack Plus XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Piscinoid Criticals Up XX"), DS(15, "Insectoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Ether Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Humanoid Criticals Up II"), DS(15, "Piscinoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Ether Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV")],
[DS(15, "Evasion Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Beam Attack Plus XVI"), DS(10, "Ultrafauna Criticals Up XVII"), DS(10, "Extend Critical Power XVII"), DS(10, "Piscinoid Slayer XVI"), DS(10, "Insectoid Slayer XVI")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Beam Attack Plus XVIII"), DS(10, "Ultrafauna Criticals Up XIX"), DS(10, "Extend Critical Power XIX"), DS(10, "Piscinoid Slayer XVIII"), DS(10, "Insectoid Slayer XVIII")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Beam Attack Plus XX"), DS(10, "Extend Critical Power I"), DS(10, "Zero Critical"), DS(10, "Piscinoid Slayer XX"), DS(10, "Insectoid Slayer XX")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Max HP Drive X"), DS(10, "Ether Attack Plus II"), DS(10, "Extend Critical Power III"), DS(10, "Theroid Slayer II"), DS(10, "Humanoid Slayer II"), DS(10, "Piscinoid Slayer II")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Ether Attack Plus IV"), DS(10, "Extend Critical Power V"), DS(10, "Theroid Slayer IV"), DS(10, "Humanoid Slayer IV"), DS(10, "Piscinoid Slayer IV")],
[DS(15, "Ranged Accuracy Up III"), DS(15, "Extend Aura XIII"), DS(10, "Resist Blackout XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Extend Aura XV"), DS(10, "Resist Blackout XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Extend Aura XVII"), DS(10, "Resist Blackout XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Extend Aura XIX"), DS(10, "Resist Fatigue II")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Aura Rapid Cooldown I"), DS(10, "Resist Fatigue IV")],
[DS(15, "Evasion Boost IV"), DS(15, "Extend Aura XIV"), DS(10, "Destabilizer XIX"), DS(10, "Destabilizer XIX"), DS(10, "Magazine Capacity Up XIX")],
[DS(15, "Evasion Boost VI"), DS(15, "Extend Aura XVI"), DS(10, "Magazine Capacity Up I"), DS(10, "Magazine Capacity Up I"), DS(10, "Melee: TP Gain Up")],
[DS(15, "Evasion Boost VIII"), DS(15, "Extend Aura XVIII"), DS(10, "Magazine Capacity Up III"), DS(10, "Magazine Capacity Up III"), DS(10, "Cooldown Reducer I")],
[DS(15, "Evasion Boost X"), DS(15, "Extend Aura XX"), DS(10, "Magazine Capacity Up V"), DS(10, "Magazine Capacity Up V"), DS(10, "Cooldown Reducer III")],
[DS(15, "Evasion Boost XII"), DS(15, "Aura Rapid Cooldown II"), DS(10, "Magazine Capacity Up VII"), DS(10, "Magazine Capacity Up VII"), DS(10, "Cooldown Reducer V")],
[DS(15, "Ranged Accuracy Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Beam Attack Plus XV")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Beam Attack Plus XVII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Beam Attack Plus XIX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Ether Attack Plus I")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Ether Attack Plus III")],
[DS(15, "Evasion Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Beam Attack Plus XVI"), DS(10, "Stabilizer XIX"), DS(10, "Destabilizer XIX"), DS(10, "Magazine Capacity Up XIX")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Beam Attack Plus XVIII"), DS(10, "Destabilizer I"), DS(10, "Magazine Capacity Up I"), DS(10, "Melee: TP Gain Up")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Beam Attack Plus XX"), DS(10, "Destabilizer III"), DS(10, "Magazine Capacity Up III"), DS(10, "Cooldown Reducer I")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Ether Attack Plus II"), DS(10, "Destabilizer V"), DS(10, "Magazine Capacity Up V"), DS(10, "Cooldown Reducer III")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Ether Attack Plus IV"), DS(10, "Destabilizer VII"), DS(10, "Magazine Capacity Up VII"), DS(10, "Cooldown Reducer V")],
[DS(15, "Ranged Accuracy Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Beam Attack Plus XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Theroid Criticals Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Beam Attack Plus XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Beam Attack Plus XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Ether Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Ether Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Evasion Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Beam Attack Plus XVI"), DS(10, "Destabilizer XIX"), DS(10, "Magazine Capacity Up XIX"), DS(10, "ITM_SKL_IN_FST_FPOW14_name"), DS(10, "ITM_SKL_IN_FST_SPOW14_name")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Beam Attack Plus XVIII"), DS(10, "Magazine Capacity Up I"), DS(10, "Melee: TP Gain Up"), DS(10, "ITM_SKL_IN_FST_FPOW16_name"), DS(10, "ITM_SKL_IN_FST_SPOW16_name")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Beam Attack Plus XX"), DS(10, "Magazine Capacity Up III"), DS(10, "Cooldown Reducer I"), DS(10, "ITM_SKL_IN_FST_FPOW18_name"), DS(10, "ITM_SKL_IN_FST_SPOW18_name")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Ether Attack Plus II"), DS(10, "Magazine Capacity Up V"), DS(10, "Cooldown Reducer III"), DS(10, "ITM_SKL_IN_FST_FPOW20_name"), DS(10, "ITM_SKL_IN_FST_SPOW20_name")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Ether Attack Plus IV"), DS(10, "Magazine Capacity Up VII"), DS(10, "Cooldown Reducer V"), DS(10, "ITM_SKL_IN_FST_SPOW02_name"), DS(10, "ITM_SKL_IN_FST_MIND02_name")],
[DS(15, "Ranged Accuracy Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Physical Attack Plus XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Theroid Criticals Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Physical Attack Plus XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Physical Attack Plus XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Beam Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Beam Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Evasion Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Destabilizer XIX"), DS(10, "Magazine Capacity Up XIX"), DS(10, "ITM_SKL_IN_FST_FPOW14_name"), DS(10, "ITM_SKL_IN_FST_SPOW14_name")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Magazine Capacity Up I"), DS(10, "Melee: TP Gain Up"), DS(10, "ITM_SKL_IN_FST_FPOW16_name"), DS(10, "ITM_SKL_IN_FST_SPOW16_name")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Magazine Capacity Up III"), DS(10, "Cooldown Reducer I"), DS(10, "ITM_SKL_IN_FST_FPOW18_name"), DS(10, "ITM_SKL_IN_FST_SPOW18_name")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Max HP Drive X"), DS(10, "Magazine Capacity Up V"), DS(10, "Cooldown Reducer III"), DS(10, "ITM_SKL_IN_FST_FPOW20_name"), DS(10, "ITM_SKL_IN_FST_SPOW20_name")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Magazine Capacity Up VII"), DS(10, "Cooldown Reducer V"), DS(10, "ITM_SKL_IN_FST_SPOW02_name"), DS(10, "ITM_SKL_IN_FST_MIND02_name")],
[DS(15, "Ranged Accuracy Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Beam Attack Plus XV"), DS(15, "Nullify Electric Reflect XV"), DS(10, "Resist Shock XVI")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Beam Attack Plus XVII"), DS(15, "Nullify Electric Reflect XVII"), DS(10, "Resist Shock XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Beam Attack Plus XIX"), DS(15, "Nullify Electric Reflect XIX"), DS(10, "Resist Shock XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Ether Attack Plus I"), DS(15, "Nullify Gravity Reflect I"), DS(10, "Debuff Suppressor II")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Ether Attack Plus III"), DS(15, "Nullify Gravity Reflect III"), DS(10, "Debuff Suppressor IV")],
[DS(15, "Evasion Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Beam Attack Plus XVI"), DS(15, "Evasion Drive VII"), DS(10, "Resist Shock XVII"), DS(15, "Destabilizer XIX"), DS(10, "Magazine Capacity Up XIX"), DS(10, "HP Rebound XVI")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Beam Attack Plus XVIII"), DS(15, "Evasion Drive IX"), DS(10, "Resist Shock XIX"), DS(15, "Magazine Capacity Up I"), DS(10, "Melee: TP Gain Up"), DS(10, "HP Rebound XVIII")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Beam Attack Plus XX"), DS(15, "Evasion Drive XI"), DS(10, "Debuff Suppressor I"), DS(15, "Magazine Capacity Up III"), DS(10, "Cooldown Reducer I"), DS(10, "HP Rebound XX")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Ether Attack Plus II"), DS(15, "Evasion Drive XIII"), DS(10, "Debuff Suppressor III"), DS(15, "Magazine Capacity Up V"), DS(10, "Cooldown Reducer III"), DS(10, "TP Rebound II")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Ether Attack Plus IV"), DS(15, "Evasion Drive XV"), DS(10, "Debuff Suppressor V"), DS(15, "Magazine Capacity Up VII"), DS(10, "Cooldown Reducer V"), DS(10, "TP Rebound IV")],
[DS(15, "Melee Accuracy Up III"), DS(15, "Ranged Accuracy Up III"), DS(10, "Evasion Up III"), DS(10, "Melee Attack Up III"), DS(15, "Ranged Attack Up III"), DS(15, "Potential Up III"), DS(10, "Max HP Up III")],
[DS(15, "Melee Accuracy Up V"), DS(15, "Ranged Accuracy Up V"), DS(10, "Evasion Up V"), DS(10, "Melee Attack Up V"), DS(15, "Ranged Attack Up V"), DS(15, "Potential Up V"), DS(10, "Max HP Up V")],
[DS(15, "Melee Accuracy Up VII"), DS(15, "Ranged Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(10, "Melee Attack Up VII"), DS(15, "Ranged Attack Up VII"), DS(15, "Potential Up VII"), DS(10, "Max HP Up VII")],
[DS(15, "Melee Accuracy Up IX"), DS(15, "Ranged Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(10, "Melee Attack Up IX"), DS(15, "Ranged Attack Up IX"), DS(15, "Potential Up IX"), DS(10, "Max HP Up IX")],
[DS(15, "Melee Accuracy Up XI"), DS(15, "Ranged Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(10, "Melee Attack Up XI"), DS(15, "Ranged Attack Up XI"), DS(15, "Potential Up XI"), DS(10, "Max HP Up XI")],
[DS(15, "Melee Attack Up IV"), DS(15, "Ranged Attack Up IV"), DS(10, "Potential Up IV"), DS(10, "Max TP Boost IV"), DS(10, "Destabilizer XIX"), DS(10, "Magazine Capacity Up XIX"), DS(10, "Resist Gravity Res Down XVII"), DS(10, "Resist HP Recovery Down XVII"), DS(10, "ITM_SKL_IN_FST_FAKE09_name")],
[DS(15, "Melee Attack Up VI"), DS(15, "Ranged Attack Up VI"), DS(10, "Potential Up VI"), DS(10, "Max TP Boost VI"), DS(10, "Magazine Capacity Up I"), DS(10, "Melee: TP Gain Up"), DS(10, "Resist Gravity Res Down XIX"), DS(10, "Resist HP Recovery Down XIX"), DS(10, "ITM_SKL_IN_FST_FAKE11_name")],
[DS(15, "Melee Attack Up VIII"), DS(15, "Ranged Attack Up VIII"), DS(10, "Potential Up VIII"), DS(10, "Max TP Boost VIII"), DS(10, "Magazine Capacity Up III"), DS(10, "Cooldown Reducer I"), DS(10, "Resist Time Bomb I"), DS(10, "Resist Blaze I"), DS(10, "ITM_SKL_IN_FST_FAKE13_name")],
[DS(15, "Melee Attack Up X"), DS(15, "Ranged Attack Up X"), DS(10, "Potential Up X"), DS(10, "Max TP Boost X"), DS(10, "Magazine Capacity Up V"), DS(10, "Cooldown Reducer III"), DS(10, "Resist Time Bomb III"), DS(10, "Resist Blaze III"), DS(10, "ITM_SKL_IN_FST_FAKE15_name")],
[DS(15, "Melee Attack Up XII"), DS(15, "Ranged Attack Up XII"), DS(10, "Potential Up XII"), DS(10, "Max TP Boost XII"), DS(10, "Magazine Capacity Up VII"), DS(10, "Cooldown Reducer V"), DS(10, "Resist Time Bomb V"), DS(10, "Resist Blaze V"), DS(10, "ITM_SKL_IN_FST_FAKE17_name")],
[DS(15, "Ranged Accuracy Up III"), DS(15, "Overdrive: Recover HP XV"), DS(10, "Resist Launch XVI"), DS(10, "Max HP Up III")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Overdrive: Recover HP XVII"), DS(10, "Resist Launch XVIII"), DS(10, "Max HP Up V")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Overdrive: Recover HP XIX"), DS(10, "Resist Launch XX"), DS(10, "Max HP Up VII")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Overdrive: Gain TP I"), DS(10, "Resist Stun II"), DS(10, "Max HP Up IX")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Overdrive: Gain TP III"), DS(10, "Resist Stun IV"), DS(10, "Max HP Up XI")],
[DS(15, "Evasion Boost IV"), DS(15, "Overdrive: Recover HP XVI"), DS(10, "Resist Launch XVII"), DS(10, "Resist Sleep XVII"), DS(10, "Max TP Boost IV"), DS(10, "TP Rebound XVI"), DS(10, "Taunt: Barrier XVI"), DS(10, "Soft Touch XVI")],
[DS(15, "Evasion Boost VI"), DS(15, "Overdrive: Recover HP XVIII"), DS(10, "Resist Launch XIX"), DS(10, "Resist Sleep XIX"), DS(10, "Max TP Boost VI"), DS(10, "TP Rebound XVIII"), DS(10, "Taunt: Barrier XVIII"), DS(10, "Soft Touch XVIII")],
[DS(15, "Evasion Boost VIII"), DS(15, "Overdrive: Recover HP XX"), DS(10, "Resist Stun I"), DS(10, "Resist Taunt I"), DS(10, "Max TP Boost VIII"), DS(10, "TP Rebound XX"), DS(10, "Taunt: Barrier XX"), DS(10, "Soft Touch XX")],
[DS(15, "Evasion Boost X"), DS(15, "Overdrive: Gain TP II"), DS(10, "Resist Stun III"), DS(10, "Resist Taunt III"), DS(10, "Max TP Boost X"), DS(10, "Taunt: Barrier II"), DS(10, "Taunt: Decoy II"), DS(10, "HP Rebound II")],
[DS(15, "Evasion Boost XII"), DS(15, "Overdrive: Gain TP IV"), DS(10, "Resist Stun V"), DS(10, "Resist Taunt V"), DS(10, "Max TP Boost XII"), DS(10, "Taunt: Barrier IV"), DS(10, "Taunt: Decoy IV"), DS(10, "HP Rebound IV")],
[DS(15, "Ranged Accuracy Up III"), DS(15, "Overdrive: Gain TP XV"), DS(10, "Resist Taunt XVI"), DS(10, "Resist Control XVI"), DS(10, "Max HP Up III")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Overdrive: Gain TP XVII"), DS(10, "Resist Taunt XVIII"), DS(10, "Resist Control XVIII"), DS(10, "Max HP Up V")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Overdrive: Gain TP XIX"), DS(10, "Resist Taunt XX"), DS(10, "Resist Control XX"), DS(10, "Max HP Up VII")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Overdrive Count Up I"), DS(10, "Resist Control II"), DS(10, "Resist Virus II"), DS(10, "Max HP Up IX")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Overdrive Count Up III"), DS(10, "Resist Control IV"), DS(10, "Resist Virus IV"), DS(10, "Max HP Up XI")],
[DS(15, "Evasion Boost IV"), DS(15, "Overdrive: Gain TP XVI"), DS(10, "Resist Taunt XVII"), DS(10, "Resist Blackout XVII"), DS(10, "Max TP Boost IV"), DS(10, "TP Rebound XVI"), DS(10, "Taunt: Barrier XVI"), DS(10, "Soft Touch XVI")],
[DS(15, "Evasion Boost VI"), DS(15, "Overdrive: Gain TP XVIII"), DS(10, "Resist Taunt XIX"), DS(10, "Resist Blackout XIX"), DS(10, "Max TP Boost VI"), DS(10, "TP Rebound XVIII"), DS(10, "Taunt: Barrier XVIII"), DS(10, "Soft Touch XVIII")],
[DS(15, "Evasion Boost VIII"), DS(15, "Overdrive: Gain TP XX"), DS(10, "Resist Control I"), DS(10, "Resist Fatigue I"), DS(10, "Max TP Boost VIII"), DS(10, "TP Rebound XX"), DS(10, "Taunt: Barrier XX"), DS(10, "Soft Touch XX")],
[DS(15, "Evasion Boost X"), DS(15, "Overdrive Count Up II"), DS(10, "Resist Control III"), DS(10, "Resist Fatigue III"), DS(10, "Max TP Boost X"), DS(10, "Taunt: Barrier II"), DS(10, "Taunt: Decoy II"), DS(10, "HP Rebound II")],
[DS(15, "Evasion Boost XII"), DS(15, "Overdrive Count Up IV"), DS(10, "Resist Control V"), DS(10, "Resist Fatigue V"), DS(10, "Max TP Boost XII"), DS(10, "Taunt: Barrier IV"), DS(10, "Taunt: Decoy IV"), DS(10, "HP Rebound IV")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Potential Up III"), DS(10, "Secondary CD Reducer XIII"), DS(15, "Resist Fatigue XVI"), DS(10, "Max HP Up III")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Potential Up V"), DS(10, "Secondary CD Reducer XV"), DS(15, "Resist Fatigue XVIII"), DS(10, "Max HP Up V")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Potential Up VII"), DS(10, "Secondary CD Reducer XVII"), DS(15, "Resist Fatigue XX"), DS(10, "Max HP Up VII")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Potential Up IX"), DS(10, "Secondary CD Reducer XIX"), DS(15, "Resist Slow Arts II"), DS(10, "Max HP Up IX")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Potential Up XI"), DS(10, "Extend Taunt I"), DS(15, "Resist Slow Arts IV"), DS(10, "Max HP Up XI")],
[DS(15, "Evasion Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Secondary CD Reducer XIV"), DS(15, "Resist Fatigue XVII"), DS(10, "Max TP Boost IV"), DS(10, "TP Rebound XVI"), DS(10, "Soft Touch XVI")],
[DS(15, "Evasion Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Secondary CD Reducer XVI"), DS(15, "Resist Fatigue XIX"), DS(10, "Max TP Boost VI"), DS(10, "TP Rebound XVIII"), DS(10, "Soft Touch XVIII")],
[DS(15, "Evasion Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Secondary CD Reducer XVIII"), DS(15, "Resist Slow Arts I"), DS(10, "Max TP Boost VIII"), DS(10, "TP Rebound XX"), DS(10, "Soft Touch XX")],
[DS(15, "Evasion Boost X"), DS(10, "Max HP Drive X"), DS(10, "Secondary CD Reducer XX"), DS(15, "Resist Slow Arts III"), DS(10, "Max TP Boost X"), DS(10, "Taunt: Barrier II"), DS(10, "HP Rebound II")],
[DS(15, "Evasion Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Extend Taunt II"), DS(15, "Resist Slow Arts V"), DS(10, "Max TP Boost XII"), DS(10, "Taunt: Barrier IV"), DS(10, "HP Rebound IV")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Potential Up III"), DS(10, "Extend Taunt XIII"), DS(15, "Resist Slow Arts XVI"), DS(10, "Max HP Up III")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Potential Up V"), DS(10, "Extend Taunt XV"), DS(15, "Resist Slow Arts XVIII"), DS(10, "Max HP Up V")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Potential Up VII"), DS(10, "Extend Taunt XVII"), DS(15, "Resist Slow Arts XX"), DS(10, "Max HP Up VII")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Potential Up IX"), DS(10, "Extend Taunt XIX"), DS(15, "Resist Physical Res Down II"), DS(10, "Max HP Up IX")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Potential Up XI"), DS(10, "Extend Control I"), DS(15, "Resist Physical Res Down IV"), DS(10, "Max HP Up XI")],
[DS(15, "Evasion Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Extend Taunt XIV"), DS(15, "Resist Slow Arts XVII"), DS(10, "Max TP Boost IV"), DS(10, "TP Rebound XVI"), DS(10, "Soft Touch XVI")],
[DS(15, "Evasion Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Extend Taunt XVI"), DS(15, "Resist Slow Arts XIX"), DS(10, "Max TP Boost VI"), DS(10, "TP Rebound XVIII"), DS(10, "Soft Touch XVIII")],
[DS(15, "Evasion Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Extend Taunt XVIII"), DS(15, "Resist Physical Res Down I"), DS(10, "Max TP Boost VIII"), DS(10, "TP Rebound XX"), DS(10, "Soft Touch XX")],
[DS(15, "Evasion Boost X"), DS(10, "Max HP Drive X"), DS(10, "Extend Taunt XX"), DS(15, "Resist Physical Res Down III"), DS(10, "Max TP Boost X"), DS(10, "Taunt: Barrier II"), DS(10, "HP Rebound II")],
[DS(15, "Evasion Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Extend Control II"), DS(15, "Resist Physical Res Down V"), DS(10, "Max TP Boost XII"), DS(10, "Taunt: Barrier IV"), DS(10, "HP Rebound IV")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Potential Up III"), DS(10, "Extend Control XIII"), DS(15, "Resist Thermal Res Down XVI"), DS(10, "Max HP Up III")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Potential Up V"), DS(10, "Extend Control XV"), DS(15, "Resist Thermal Res Down XVIII"), DS(10, "Max HP Up V")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Potential Up VII"), DS(10, "Extend Control XVII"), DS(15, "Resist Thermal Res Down XX"), DS(10, "Max HP Up VII")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Potential Up IX"), DS(10, "Extend Control XIX"), DS(15, "Resist Electric Res Down II"), DS(10, "Max HP Up IX")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Potential Up XI"), DS(10, "Extend Virus I"), DS(15, "Resist Electric Res Down IV"), DS(10, "Max HP Up XI")],
[DS(15, "Evasion Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Extend Control XIV"), DS(15, "Resist Thermal Res Down XVII"), DS(10, "Max TP Boost IV"), DS(10, "TP Rebound XVI"), DS(10, "Soft Touch XVI")],
[DS(15, "Evasion Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Extend Control XVI"), DS(15, "Resist Thermal Res Down XIX"), DS(10, "Max TP Boost VI"), DS(10, "TP Rebound XVIII"), DS(10, "Soft Touch XVIII")],
[DS(15, "Evasion Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Extend Control XVIII"), DS(15, "Resist Electric Res Down I"), DS(10, "Max TP Boost VIII"), DS(10, "TP Rebound XX"), DS(10, "Soft Touch XX")],
[DS(15, "Evasion Boost X"), DS(10, "Max HP Drive X"), DS(10, "Extend Control XX"), DS(15, "Resist Electric Res Down III"), DS(10, "Max TP Boost X"), DS(10, "Taunt: Barrier II"), DS(10, "HP Rebound II")],
[DS(15, "Evasion Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Extend Virus II"), DS(15, "Resist Electric Res Down V"), DS(10, "Max TP Boost XII"), DS(10, "Taunt: Barrier IV"), DS(10, "HP Rebound IV")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Potential Up III"), DS(10, "Extend Blackout XIII"), DS(15, "Resist Beam Res Down XVI"), DS(10, "Max HP Up III")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Potential Up V"), DS(10, "Extend Blackout XV"), DS(15, "Resist Beam Res Down XVIII"), DS(10, "Max HP Up V")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Potential Up VII"), DS(10, "Extend Blackout XVII"), DS(15, "Resist Beam Res Down XX"), DS(10, "Max HP Up VII")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Potential Up IX"), DS(10, "Extend Blackout XIX"), DS(15, "Resist Thermal Res Down II"), DS(10, "Max HP Up IX")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Potential Up XI"), DS(10, "Extend Fatigue I"), DS(15, "Resist Thermal Res Down IV"), DS(10, "Max HP Up XI")],
[DS(15, "Evasion Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Extend Blackout XIV"), DS(15, "Resist Beam Res Down XVII"), DS(10, "Max TP Boost IV"), DS(10, "TP Rebound XVI"), DS(10, "Soft Touch XVI")],
[DS(15, "Evasion Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Extend Blackout XVI"), DS(15, "Resist Beam Res Down XIX"), DS(10, "Max TP Boost VI"), DS(10, "TP Rebound XVIII"), DS(10, "Soft Touch XVIII")],
[DS(15, "Evasion Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Extend Blackout XVIII"), DS(15, "Resist Thermal Res Down I"), DS(10, "Max TP Boost VIII"), DS(10, "TP Rebound XX"), DS(10, "Soft Touch XX")],
[DS(15, "Evasion Boost X"), DS(10, "Max HP Drive X"), DS(10, "Extend Blackout XX"), DS(15, "Resist Thermal Res Down III"), DS(10, "Max TP Boost X"), DS(10, "Taunt: Barrier II"), DS(10, "HP Rebound II")],
[DS(15, "Evasion Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Extend Blackout XIV"), DS(15, "Resist Beam Res Down XVII"), DS(10, "Max TP Boost IV"), DS(10, "TP Rebound XVI"), DS(10, "Soft Touch XVI")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Potential Up III"), DS(10, "Extend Virus XIII"), DS(15, "Resist Physical Res Down XVI"), DS(10, "Max HP Up III")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Potential Up V"), DS(10, "Extend Virus XV"), DS(15, "Resist Physical Res Down XVIII"), DS(10, "Max HP Up V")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Potential Up VII"), DS(10, "Extend Virus XVII"), DS(15, "Resist Physical Res Down XX"), DS(10, "Max HP Up VII")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Potential Up IX"), DS(10, "Extend Virus XIX"), DS(15, "Resist Beam Res Down II"), DS(10, "Max HP Up IX")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Potential Up XI"), DS(10, "Extend Blackout I"), DS(15, "Resist Beam Res Down IV"), DS(10, "Max HP Up XI")],
[DS(15, "Evasion Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Extend Virus XIV"), DS(15, "Resist Physical Res Down XVII"), DS(10, "Max TP Boost IV"), DS(10, "TP Rebound XVI"), DS(10, "Soft Touch XVI")],
[DS(15, "Evasion Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Extend Virus XVI"), DS(15, "Resist Physical Res Down XIX"), DS(10, "Max TP Boost VI"), DS(10, "TP Rebound XVIII"), DS(10, "Soft Touch XVIII")],
[DS(15, "Evasion Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Extend Virus XVIII"), DS(15, "Resist Beam Res Down I"), DS(10, "Max TP Boost VIII"), DS(10, "TP Rebound XX"), DS(10, "Soft Touch XX")],
[DS(15, "Evasion Boost X"), DS(10, "Max HP Drive X"), DS(10, "Extend Virus XX"), DS(15, "Resist Beam Res Down III"), DS(10, "Max TP Boost X"), DS(10, "Taunt: Barrier II"), DS(10, "HP Rebound II")],
[DS(15, "Evasion Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Extend Blackout II"), DS(15, "Resist Beam Res Down V"), DS(10, "Max TP Boost XII"), DS(10, "Taunt: Barrier IV"), DS(10, "HP Rebound IV")],
[DS(15, "Ranged Accuracy Up III"), DS(10, "Potential Up III"), DS(10, "Extend Fatigue XIII"), DS(15, "Resist Electric Res Down XVI"), DS(10, "Max HP Up III")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Potential Up V"), DS(10, "Extend Fatigue XV"), DS(15, "Resist Electric Res Down XVIII"), DS(10, "Max HP Up V")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Potential Up VII"), DS(10, "Extend Fatigue XVII"), DS(15, "Resist Electric Res Down XX"), DS(10, "Max HP Up VII")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Potential Up IX"), DS(10, "Extend Fatigue XIX"), DS(15, "Resist Ether Res Down II"), DS(10, "Max HP Up IX")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Potential Up XI"), DS(10, "Extend Slow Arts I"), DS(15, "Resist Ether Res Down IV"), DS(10, "Max HP Up XI")],
[DS(15, "Evasion Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Extend Fatigue XIV"), DS(15, "Resist Electric Res Down XVII"), DS(10, "Max TP Boost IV"), DS(10, "TP Rebound XVI"), DS(10, "Soft Touch XVI")],
[DS(15, "Evasion Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Extend Fatigue XVI"), DS(15, "Resist Electric Res Down XIX"), DS(10, "Max TP Boost VI"), DS(10, "TP Rebound XVIII"), DS(10, "Soft Touch XVIII")],
[DS(15, "Evasion Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Extend Fatigue XVIII"), DS(15, "Resist Ether Res Down I"), DS(10, "Max TP Boost VIII"), DS(10, "TP Rebound XX"), DS(10, "Soft Touch XX")],
[DS(15, "Evasion Boost X"), DS(10, "Max HP Drive X"), DS(10, "Extend Fatigue XX"), DS(15, "Resist Ether Res Down III"), DS(10, "Max TP Boost X"), DS(10, "Taunt: Barrier II"), DS(10, "HP Rebound II")],
[DS(15, "Evasion Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Extend Slow Arts II"), DS(15, "Resist Ether Res Down V"), DS(10, "Max TP Boost XII"), DS(10, "Taunt: Barrier IV"), DS(10, "HP Rebound IV")],
[DS(15, "Melee Accuracy Up III"), DS(10, "Ranged Accuracy Up III"), DS(10, "Evasion Up III"), DS(10, "Melee: Recover HP XV"), DS(10, "Max HP Up III"), DS(15, "Cooldown Reducer XVI"), DS(10, "Resist Stagger XVI"), DS(10, "Resist Flinch XVI"), DS(10, "Resist Topple XVI")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Ranged Accuracy Up V"), DS(10, "Evasion Up V"), DS(10, "Melee: Recover HP XVII"), DS(10, "Max HP Up V"), DS(15, "Cooldown Reducer XVIII"), DS(10, "Resist Stagger XVIII"), DS(10, "Resist Flinch XVIII"), DS(10, "Resist Topple XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Ranged Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(10, "Melee: Recover HP XIX"), DS(10, "Max HP Up VII"), DS(15, "Cooldown Reducer XX"), DS(10, "Resist Stagger XX"), DS(10, "Resist Flinch XX"), DS(10, "Resist Topple XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Ranged Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(10, "Soft Touch I"), DS(10, "Max HP Up IX"), DS(15, "Firing Range Up II"), DS(10, "Resist Flinch II"), DS(10, "Resist Topple II"), DS(10, "Resist Knockback II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Ranged Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(10, "Soft Touch III"), DS(10, "Max HP Up XI"), DS(15, "Firing Range Up IV"), DS(10, "Resist Flinch IV"), DS(10, "Resist Topple IV"), DS(10, "Resist Knockback IV")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Evasion Boost IV"), DS(10, "Melee Attack Boost IV"), DS(10, "Melee: Recover HP XVI"), DS(10, "Max TP Boost IV"), DS(15, "Cooldown Reducer XVII"), DS(10, "Resist Stagger XVII"), DS(10, "Resist Flinch XVII"), DS(10, "Resist Topple XVII")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Evasion Boost VI"), DS(10, "Melee Attack Boost VI"), DS(10, "Melee: Recover HP XVIII"), DS(10, "Max TP Boost VI"), DS(15, "Cooldown Reducer XIX"), DS(10, "Resist Stagger XIX"), DS(10, "Resist Flinch XIX"), DS(10, "Resist Topple XIX")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Evasion Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(10, "Melee: Recover HP XX"), DS(10, "Max TP Boost VIII"), DS(15, "Firing Range Up I"), DS(10, "Resist Flinch I"), DS(10, "Resist Topple I"), DS(10, "Resist Knockback I")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Evasion Boost X"), DS(10, "Melee Attack Boost X"), DS(10, "Soft Touch II"), DS(10, "Max TP Boost X"), DS(15, "Firing Range Up III"), DS(10, "Resist Flinch III"), DS(10, "Resist Topple III"), DS(10, "Resist Knockback III")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Evasion Boost XII"), DS(10, "Melee Attack Boost XII"), DS(10, "Soft Touch IV"), DS(10, "Max TP Boost XII"), DS(15, "Firing Range Up V"), DS(10, "Resist Flinch V"), DS(10, "Resist Topple V"), DS(10, "Resist Knockback V")],
[DS(15, "Melee Accuracy Up III"), DS(10, "Ranged Accuracy Up III"), DS(10, "Evasion Up III"), DS(10, "Melee: Recover HP XV"), DS(10, "Max HP Up III"), DS(15, "Cooldown Reducer XVI"), DS(10, "Resist Stagger XVI"), DS(10, "Resist Flinch XVI"), DS(10, "Resist Topple XVI")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Ranged Accuracy Up V"), DS(10, "Evasion Up V"), DS(10, "Melee: Recover HP XVII"), DS(10, "Max HP Up V"), DS(15, "Cooldown Reducer XVIII"), DS(10, "Resist Stagger XVIII"), DS(10, "Resist Flinch XVIII"), DS(10, "Resist Topple XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Ranged Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(10, "Melee: Recover HP XIX"), DS(10, "Max HP Up VII"), DS(15, "Cooldown Reducer XX"), DS(10, "Resist Stagger XX"), DS(10, "Resist Flinch XX"), DS(10, "Resist Topple XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Ranged Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(10, "Soft Touch I"), DS(10, "Max HP Up IX"), DS(15, "Firing Range Up II"), DS(10, "Resist Flinch II"), DS(10, "Resist Topple II"), DS(10, "Resist Knockback II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Ranged Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(10, "Soft Touch III"), DS(10, "Max HP Up XI"), DS(15, "Firing Range Up IV"), DS(10, "Resist Flinch IV"), DS(10, "Resist Topple IV"), DS(10, "Resist Knockback IV")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Evasion Boost IV"), DS(10, "Melee Attack Boost IV"), DS(10, "Melee: Recover HP XVI"), DS(10, "Max TP Boost IV"), DS(15, "Cooldown Reducer XVII"), DS(10, "Resist Stagger XVII"), DS(10, "Resist Flinch XVII"), DS(10, "Resist Topple XVII")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Evasion Boost VI"), DS(10, "Melee Attack Boost VI"), DS(10, "Melee: Recover HP XVIII"), DS(10, "Max TP Boost VI"), DS(15, "Cooldown Reducer XIX"), DS(10, "Resist Stagger XIX"), DS(10, "Resist Flinch XIX"), DS(10, "Resist Topple XIX")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Evasion Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(10, "Melee: Recover HP XX"), DS(10, "Max TP Boost VIII"), DS(15, "Firing Range Up I"), DS(10, "Resist Flinch I"), DS(10, "Resist Topple I"), DS(10, "Resist Knockback I")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Evasion Boost X"), DS(10, "Melee Attack Boost X"), DS(10, "Soft Touch II"), DS(10, "Max TP Boost X"), DS(15, "Firing Range Up III"), DS(10, "Resist Flinch III"), DS(10, "Resist Topple III"), DS(10, "Resist Knockback III")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Evasion Boost XII"), DS(10, "Melee Attack Boost XII"), DS(10, "Soft Touch IV"), DS(10, "Max TP Boost XII"), DS(15, "Firing Range Up V"), DS(10, "Resist Flinch V"), DS(10, "Resist Topple V"), DS(10, "Resist Knockback V")],
[DS(15, "Melee Accuracy Up III"), DS(10, "Ranged Accuracy Up III"), DS(10, "Evasion Up III"), DS(10, "Melee: Recover HP XV"), DS(10, "Max HP Up III"), DS(15, "Cooldown Reducer XVI"), DS(10, "Resist Stagger XVI"), DS(10, "Resist Flinch XVI"), DS(10, "Resist Topple XVI")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Ranged Accuracy Up V"), DS(10, "Evasion Up V"), DS(10, "Melee: Recover HP XVII"), DS(10, "Max HP Up V"), DS(15, "Cooldown Reducer XVIII"), DS(10, "Resist Stagger XVIII"), DS(10, "Resist Flinch XVIII"), DS(10, "Resist Topple XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Ranged Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(10, "Melee: Recover HP XIX"), DS(10, "Max HP Up VII"), DS(15, "Cooldown Reducer XX"), DS(10, "Resist Stagger XX"), DS(10, "Resist Flinch XX"), DS(10, "Resist Topple XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Ranged Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(10, "Soft Touch I"), DS(10, "Max HP Up IX"), DS(15, "Firing Range Up II"), DS(10, "Resist Flinch II"), DS(10, "Resist Topple II"), DS(10, "Resist Knockback II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Ranged Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(10, "Soft Touch III"), DS(10, "Max HP Up XI"), DS(15, "Firing Range Up IV"), DS(10, "Resist Flinch IV"), DS(10, "Resist Topple IV"), DS(10, "Resist Knockback IV")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Evasion Boost IV"), DS(10, "Melee Attack Boost IV"), DS(10, "Melee: Recover HP XVI"), DS(10, "Max TP Boost IV"), DS(15, "Cooldown Reducer XVII"), DS(10, "Resist Stagger XVII"), DS(10, "Resist Flinch XVII"), DS(10, "Resist Topple XVII")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Evasion Boost VI"), DS(10, "Melee Attack Boost VI"), DS(10, "Melee: Recover HP XVIII"), DS(10, "Max TP Boost VI"), DS(15, "Cooldown Reducer XIX"), DS(10, "Resist Stagger XIX"), DS(10, "Resist Flinch XIX"), DS(10, "Resist Topple XIX")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Evasion Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(10, "Melee: Recover HP XX"), DS(10, "Max TP Boost VIII"), DS(15, "Firing Range Up I"), DS(10, "Resist Flinch I"), DS(10, "Resist Topple I"), DS(10, "Resist Knockback I")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Evasion Boost X"), DS(10, "Melee Attack Boost X"), DS(10, "Soft Touch II"), DS(10, "Max TP Boost X"), DS(15, "Firing Range Up III"), DS(10, "Resist Flinch III"), DS(10, "Resist Topple III"), DS(10, "Resist Knockback III")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Evasion Boost XII"), DS(10, "Melee Attack Boost XII"), DS(10, "Soft Touch IV"), DS(10, "Max TP Boost XII"), DS(15, "Firing Range Up V"), DS(10, "Resist Flinch V"), DS(10, "Resist Topple V"), DS(10, "Resist Knockback V")],
[DS(15, "Melee Accuracy Up III"), DS(10, "Ranged Attack Up III"), DS(10, "Potential Up III"), DS(10, "Melee: Recover HP XV"), DS(10, "Max HP Up III"), DS(15, "Cooldown Reducer XVI"), DS(10, "Resist Stagger XVI"), DS(10, "Resist Flinch XVI"), DS(10, "Resist Topple XVI")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Potential Up V"), DS(10, "Melee: Recover HP XVII"), DS(10, "Max HP Up V"), DS(15, "Cooldown Reducer XVIII"), DS(10, "Resist Stagger XVIII"), DS(10, "Resist Flinch XVIII"), DS(10, "Resist Topple XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Melee: Recover HP XIX"), DS(10, "Max HP Up VII"), DS(15, "Cooldown Reducer XX"), DS(10, "Resist Stagger XX"), DS(10, "Resist Flinch XX"), DS(10, "Resist Topple XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Soft Touch I"), DS(10, "Max HP Up IX"), DS(15, "Firing Range Up II"), DS(10, "Resist Flinch II"), DS(10, "Resist Topple II"), DS(10, "Resist Knockback II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Soft Touch III"), DS(10, "Max HP Up XI"), DS(15, "Firing Range Up IV"), DS(10, "Resist Flinch IV"), DS(10, "Resist Topple IV"), DS(10, "Resist Knockback IV")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Potential Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Melee: Recover HP XVI"), DS(10, "Max TP Boost IV"), DS(15, "Cooldown Reducer XVII"), DS(10, "Resist Stagger XVII"), DS(10, "Resist Flinch XVII"), DS(10, "Resist Topple XVII")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Melee: Recover HP XVIII"), DS(10, "Max TP Boost VI"), DS(15, "Cooldown Reducer XIX"), DS(10, "Resist Stagger XIX"), DS(10, "Resist Flinch XIX"), DS(10, "Resist Topple XIX")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Melee: Recover HP XX"), DS(10, "Max TP Boost VIII"), DS(15, "Firing Range Up I"), DS(10, "Resist Flinch I"), DS(10, "Resist Topple I"), DS(10, "Resist Knockback I")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Potential Boost X"), DS(10, "Max HP Drive X"), DS(10, "Soft Touch II"), DS(10, "Max TP Boost X"), DS(15, "Firing Range Up III"), DS(10, "Resist Flinch III"), DS(10, "Resist Topple III"), DS(10, "Resist Knockback III")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Soft Touch IV"), DS(10, "Max TP Boost XII"), DS(15, "Firing Range Up V"), DS(10, "Resist Flinch V"), DS(10, "Resist Topple V"), DS(10, "Resist Knockback V")],
[DS(15, "Melee Accuracy Up III"), DS(10, "Ranged Attack Up III"), DS(10, "Potential Up III"), DS(10, "Melee: Recover HP XV"), DS(10, "Max HP Up III"), DS(15, "Cooldown Reducer XVI"), DS(10, "Resist Stagger XVI"), DS(10, "Resist Flinch XVI"), DS(10, "Resist Topple XVI")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Potential Up V"), DS(10, "Melee: Recover HP XVII"), DS(10, "Max HP Up V"), DS(15, "Cooldown Reducer XVIII"), DS(10, "Resist Stagger XVIII"), DS(10, "Resist Flinch XVIII"), DS(10, "Resist Topple XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Melee: Recover HP XIX"), DS(10, "Max HP Up VII"), DS(15, "Cooldown Reducer XX"), DS(10, "Resist Stagger XX"), DS(10, "Resist Flinch XX"), DS(10, "Resist Topple XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Soft Touch I"), DS(10, "Max HP Up IX"), DS(15, "Firing Range Up II"), DS(10, "Resist Flinch II"), DS(10, "Resist Topple II"), DS(10, "Resist Knockback II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Soft Touch III"), DS(10, "Max HP Up XI"), DS(15, "Firing Range Up IV"), DS(10, "Resist Flinch IV"), DS(10, "Resist Topple IV"), DS(10, "Resist Knockback IV")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Potential Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Melee: Recover HP XVI"), DS(10, "Max TP Boost IV"), DS(15, "Cooldown Reducer XVII"), DS(10, "Resist Stagger XVII"), DS(10, "Resist Flinch XVII"), DS(10, "Resist Topple XVII")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Melee: Recover HP XVIII"), DS(10, "Max TP Boost VI"), DS(15, "Cooldown Reducer XIX"), DS(10, "Resist Stagger XIX"), DS(10, "Resist Flinch XIX"), DS(10, "Resist Topple XIX")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Melee: Recover HP XX"), DS(10, "Max TP Boost VIII"), DS(15, "Firing Range Up I"), DS(10, "Resist Flinch I"), DS(10, "Resist Topple I"), DS(10, "Resist Knockback I")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Potential Boost X"), DS(10, "Max HP Drive X"), DS(10, "Soft Touch II"), DS(10, "Max TP Boost X"), DS(15, "Firing Range Up III"), DS(10, "Resist Flinch III"), DS(10, "Resist Topple III"), DS(10, "Resist Knockback III")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Soft Touch IV"), DS(10, "Max TP Boost XII"), DS(15, "Firing Range Up V"), DS(10, "Resist Flinch V"), DS(10, "Resist Topple V"), DS(10, "Resist Knockback V")],
[DS(15, "Melee Accuracy Up III"), DS(10, "Ranged Attack Up III"), DS(10, "Potential Up III"), DS(10, "Melee: Recover HP XV"), DS(10, "Max HP Up III"), DS(15, "Cooldown Reducer XVI"), DS(10, "Resist Stagger XVI"), DS(10, "Resist Flinch XVI"), DS(10, "Resist Topple XVI")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Potential Up V"), DS(10, "Melee: Recover HP XVII"), DS(10, "Max HP Up V"), DS(15, "Cooldown Reducer XVIII"), DS(10, "Resist Stagger XVIII"), DS(10, "Resist Flinch XVIII"), DS(10, "Resist Topple XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Melee: Recover HP XIX"), DS(10, "Max HP Up VII"), DS(15, "Cooldown Reducer XX"), DS(10, "Resist Stagger XX"), DS(10, "Resist Flinch XX"), DS(10, "Resist Topple XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Soft Touch I"), DS(10, "Max HP Up IX"), DS(15, "Firing Range Up II"), DS(10, "Resist Flinch II"), DS(10, "Resist Topple II"), DS(10, "Resist Knockback II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Soft Touch III"), DS(10, "Max HP Up XI"), DS(15, "Firing Range Up IV"), DS(10, "Resist Flinch IV"), DS(10, "Resist Topple IV"), DS(10, "Resist Knockback IV")],
[DS(15, "Ranged Accuracy Boost IV"), DS(10, "Potential Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Melee: Recover HP XVI"), DS(10, "Max TP Boost IV"), DS(15, "Cooldown Reducer XVII"), DS(10, "Resist Stagger XVII"), DS(10, "Resist Flinch XVII"), DS(10, "Resist Topple XVII")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Melee: Recover HP XVIII"), DS(10, "Max TP Boost VI"), DS(15, "Cooldown Reducer XIX"), DS(10, "Resist Stagger XIX"), DS(10, "Resist Flinch XIX"), DS(10, "Resist Topple XIX")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Melee: Recover HP XX"), DS(10, "Max TP Boost VIII"), DS(15, "Firing Range Up I"), DS(10, "Resist Flinch I"), DS(10, "Resist Topple I"), DS(10, "Resist Knockback I")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Potential Boost X"), DS(10, "Max HP Drive X"), DS(10, "Soft Touch II"), DS(10, "Max TP Boost X"), DS(15, "Firing Range Up III"), DS(10, "Resist Flinch III"), DS(10, "Resist Topple III"), DS(10, "Resist Knockback III")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Soft Touch IV"), DS(10, "Max TP Boost XII"), DS(15, "Firing Range Up V"), DS(10, "Resist Flinch V"), DS(10, "Resist Topple V"), DS(10, "Resist Knockback V")],
[DS(15, "Melee Accuracy Up III"), DS(15, "Ranged Accuracy Up III"), DS(10, "Evasion Up III"), DS(10, "Melee: Recover HP XV"), DS(10, "Max HP Up III"), DS(10, "Firing Range Up XVI"), DS(10, "Resist Knockback XVI"), DS(10, "Resist Launch XVI"), DS(10, "Resist Sleep XVI")],
[DS(15, "Melee Accuracy Up V"), DS(15, "Ranged Accuracy Up V"), DS(10, "Evasion Up V"), DS(10, "Melee: Recover HP XVII"), DS(10, "Max HP Up V"), DS(10, "Firing Range Up XVIII"), DS(10, "Resist Knockback XVIII"), DS(10, "Resist Launch XVIII"), DS(10, "Resist Sleep XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(15, "Ranged Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(10, "Melee: Recover HP XIX"), DS(10, "Max HP Up VII"), DS(10, "Firing Range Up XX"), DS(10, "Resist Knockback XX"), DS(10, "Resist Launch XX"), DS(10, "Resist Sleep XX")],
[DS(15, "Melee Accuracy Up IX"), DS(15, "Ranged Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(10, "Soft Touch I"), DS(10, "Max HP Up IX"), DS(10, "Resist Stagger II"), DS(10, "Resist Launch II"), DS(10, "Resist Stun II"), DS(10, "Resist Taunt II")],
[DS(15, "Melee Accuracy Up XI"), DS(15, "Ranged Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(10, "Soft Touch III"), DS(10, "Max HP Up XI"), DS(10, "Resist Stagger IV"), DS(10, "Resist Launch IV"), DS(10, "Resist Stun IV"), DS(10, "Resist Taunt IV")],
[DS(15, "Ranged Accuracy Boost IV"), DS(15, "Evasion Boost IV"), DS(10, "Melee Attack Boost IV"), DS(10, "Melee: Recover HP XVI"), DS(10, "Max TP Boost IV"), DS(10, "Firing Range Up XVII"), DS(10, "Resist Knockback XVII"), DS(10, "Resist Launch XVII"), DS(10, "Resist Sleep XVII"), DS(10, "Taunt: Decoy XIII")],
[DS(15, "Ranged Accuracy Boost VI"), DS(15, "Evasion Boost VI"), DS(10, "Melee Attack Boost VI"), DS(10, "Melee: Recover HP XVIII"), DS(10, "Max TP Boost VI"), DS(10, "Firing Range Up XIX"), DS(10, "Resist Knockback XIX"), DS(10, "Resist Launch XIX"), DS(10, "Resist Sleep XIX"), DS(10, "Taunt: Decoy XIII")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(15, "Evasion Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(10, "Melee: Recover HP XX"), DS(10, "Max TP Boost VIII"), DS(10, "Resist Stagger I"), DS(10, "Resist Launch I"), DS(10, "Resist Stun I"), DS(10, "Resist Taunt I"), DS(10, "Taunt: Decoy XIII")],
[DS(15, "Ranged Accuracy Boost X"), DS(15, "Evasion Boost X"), DS(10, "Melee Attack Boost X"), DS(10, "Soft Touch II"), DS(10, "Max TP Boost X"), DS(10, "Resist Stagger III"), DS(10, "Resist Launch III"), DS(10, "Resist Stun III"), DS(10, "Resist Taunt III"), DS(10, "Taunt: Decoy XIII")],
[DS(15, "Ranged Accuracy Boost XII"), DS(15, "Evasion Boost XII"), DS(10, "Melee Attack Boost XII"), DS(10, "Soft Touch IV"), DS(10, "Max TP Boost XII"), DS(10, "Resist Stagger V"), DS(10, "Resist Launch V"), DS(10, "Resist Stun V"), DS(10, "Resist Taunt V"), DS(10, "Taunt: Decoy XIII")],
[DS(15, "Melee Accuracy Up III"), DS(15, "Ranged Accuracy Up III"), DS(10, "Evasion Up III"), DS(10, "Melee: Recover HP XV"), DS(10, "Max HP Up III"), DS(10, "Firing Range Up XVI"), DS(10, "Resist Knockback XVI"), DS(10, "Resist Launch XVI"), DS(10, "Resist Sleep XVI")],
[DS(15, "Melee Accuracy Up V"), DS(15, "Ranged Accuracy Up V"), DS(10, "Evasion Up V"), DS(10, "Melee: Recover HP XVII"), DS(10, "Max HP Up V"), DS(10, "Firing Range Up XVIII"), DS(10, "Resist Knockback XVIII"), DS(10, "Resist Launch XVIII"), DS(10, "Resist Sleep XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(15, "Ranged Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(10, "Melee: Recover HP XIX"), DS(10, "Max HP Up VII"), DS(10, "Firing Range Up XX"), DS(10, "Resist Knockback XX"), DS(10, "Resist Launch XX"), DS(10, "Resist Sleep XX")],
[DS(15, "Melee Accuracy Up IX"), DS(15, "Ranged Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(10, "Soft Touch I"), DS(10, "Max HP Up IX"), DS(10, "Resist Stagger II"), DS(10, "Resist Launch II"), DS(10, "Resist Stun II"), DS(10, "Resist Taunt II")],
[DS(15, "Melee Accuracy Up XI"), DS(15, "Ranged Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(10, "Soft Touch III"), DS(10, "Max HP Up XI"), DS(10, "Resist Stagger IV"), DS(10, "Resist Launch IV"), DS(10, "Resist Stun IV"), DS(10, "Resist Taunt IV")],
[DS(15, "Ranged Accuracy Boost IV"), DS(15, "Evasion Boost IV"), DS(10, "Melee Attack Boost IV"), DS(10, "Melee: Recover HP XVI"), DS(10, "Max TP Boost IV"), DS(10, "Firing Range Up XVII"), DS(10, "Resist Knockback XVII"), DS(10, "Resist Launch XVII"), DS(10, "Resist Sleep XVII"), DS(10, "Taunt: Decoy XIV")],
[DS(15, "Ranged Accuracy Boost VI"), DS(15, "Evasion Boost VI"), DS(10, "Melee Attack Boost VI"), DS(10, "Melee: Recover HP XVIII"), DS(10, "Max TP Boost VI"), DS(10, "Firing Range Up XIX"), DS(10, "Resist Knockback XIX"), DS(10, "Resist Launch XIX"), DS(10, "Resist Sleep XIX"), DS(10, "Taunt: Decoy XIV")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(15, "Evasion Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(10, "Melee: Recover HP XX"), DS(10, "Max TP Boost VIII"), DS(10, "Resist Stagger I"), DS(10, "Resist Launch I"), DS(10, "Resist Stun I"), DS(10, "Resist Taunt I"), DS(10, "Taunt: Decoy XIV")],
[DS(15, "Ranged Accuracy Boost X"), DS(15, "Evasion Boost X"), DS(10, "Melee Attack Boost X"), DS(10, "Soft Touch II"), DS(10, "Max TP Boost X"), DS(10, "Resist Stagger III"), DS(10, "Resist Launch III"), DS(10, "Resist Stun III"), DS(10, "Resist Taunt III"), DS(10, "Taunt: Decoy XIV")],
[DS(15, "Ranged Accuracy Boost XII"), DS(15, "Evasion Boost XII"), DS(10, "Melee Attack Boost XII"), DS(10, "Soft Touch IV"), DS(10, "Max TP Boost XII"), DS(10, "Resist Stagger V"), DS(10, "Resist Launch V"), DS(10, "Resist Stun V"), DS(10, "Resist Taunt V"), DS(10, "Taunt: Decoy XIV")],
[DS(15, "Melee Accuracy Up III"), DS(15, "Ranged Accuracy Up III"), DS(10, "Evasion Up III"), DS(10, "Melee: Recover HP XV"), DS(10, "Max HP Up III"), DS(10, "Firing Range Up XVI"), DS(10, "Resist Knockback XVI"), DS(10, "Resist Launch XVI"), DS(10, "Resist Sleep XVI")],
[DS(15, "Melee Accuracy Up V"), DS(15, "Ranged Accuracy Up V"), DS(10, "Evasion Up V"), DS(10, "Melee: Recover HP XVII"), DS(10, "Max HP Up V"), DS(10, "Firing Range Up XVIII"), DS(10, "Resist Knockback XVIII"), DS(10, "Resist Launch XVIII"), DS(10, "Resist Sleep XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(15, "Ranged Accuracy Up VII"), DS(10, "Evasion Up VII"), DS(10, "Melee: Recover HP XIX"), DS(10, "Max HP Up VII"), DS(10, "Firing Range Up XX"), DS(10, "Resist Knockback XX"), DS(10, "Resist Launch XX"), DS(10, "Resist Sleep XX")],
[DS(15, "Melee Accuracy Up IX"), DS(15, "Ranged Accuracy Up IX"), DS(10, "Evasion Up IX"), DS(10, "Soft Touch I"), DS(10, "Max HP Up IX"), DS(10, "Resist Stagger II"), DS(10, "Resist Launch II"), DS(10, "Resist Stun II"), DS(10, "Resist Taunt II")],
[DS(15, "Melee Accuracy Up XI"), DS(15, "Ranged Accuracy Up XI"), DS(10, "Evasion Up XI"), DS(10, "Soft Touch III"), DS(10, "Max HP Up XI"), DS(10, "Resist Stagger IV"), DS(10, "Resist Launch IV"), DS(10, "Resist Stun IV"), DS(10, "Resist Taunt IV")],
[DS(15, "Ranged Accuracy Boost IV"), DS(15, "Evasion Boost IV"), DS(10, "Melee Attack Boost IV"), DS(10, "Melee: Recover HP XVI"), DS(10, "Max TP Boost IV"), DS(10, "Firing Range Up XVII"), DS(10, "Resist Knockback XVII"), DS(10, "Resist Launch XVII"), DS(10, "Resist Sleep XVII"), DS(10, "Taunt: Decoy XV")],
[DS(15, "Ranged Accuracy Boost VI"), DS(15, "Evasion Boost VI"), DS(10, "Melee Attack Boost VI"), DS(10, "Melee: Recover HP XVIII"), DS(10, "Max TP Boost VI"), DS(10, "Firing Range Up XIX"), DS(10, "Resist Knockback XIX"), DS(10, "Resist Launch XIX"), DS(10, "Resist Sleep XIX"), DS(10, "Taunt: Decoy XV")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(15, "Evasion Boost VIII"), DS(10, "Melee Attack Boost VIII"), DS(10, "Melee: Recover HP XX"), DS(10, "Max TP Boost VIII"), DS(10, "Resist Stagger I"), DS(10, "Resist Launch I"), DS(10, "Resist Stun I"), DS(10, "Resist Taunt I"), DS(10, "Taunt: Decoy XV")],
[DS(15, "Ranged Accuracy Boost X"), DS(15, "Evasion Boost X"), DS(10, "Melee Attack Boost X"), DS(10, "Soft Touch II"), DS(10, "Max TP Boost X"), DS(10, "Resist Stagger III"), DS(10, "Resist Launch III"), DS(10, "Resist Stun III"), DS(10, "Resist Taunt III"), DS(10, "Taunt: Decoy XV")],
[DS(15, "Ranged Accuracy Boost XII"), DS(15, "Evasion Boost XII"), DS(10, "Melee Attack Boost XII"), DS(10, "Soft Touch IV"), DS(10, "Max TP Boost XII"), DS(10, "Resist Stagger V"), DS(10, "Resist Launch V"), DS(10, "Resist Stun V"), DS(10, "Resist Taunt V"), DS(10, "Taunt: Decoy XV")],
[DS(15, "Melee Attack Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Potential Up III"), DS(10, "Melee: Recover HP XV"), DS(10, "Max HP Up III"), DS(10, "Firing Range Up XVI"), DS(10, "Resist Knockback XVI"), DS(10, "Resist Launch XVI"), DS(10, "Resist Sleep XVI")],
[DS(15, "Melee Attack Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Potential Up V"), DS(10, "Melee: Recover HP XVII"), DS(10, "Max HP Up V"), DS(10, "Firing Range Up XVIII"), DS(10, "Resist Knockback XVIII"), DS(10, "Resist Launch XVIII"), DS(10, "Resist Sleep XVIII")],
[DS(15, "Melee Attack Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Melee: Recover HP XIX"), DS(10, "Max HP Up VII"), DS(10, "Firing Range Up XX"), DS(10, "Resist Knockback XX"), DS(10, "Resist Launch XX"), DS(10, "Resist Sleep XX")],
[DS(15, "Melee Attack Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Soft Touch I"), DS(10, "Max HP Up IX"), DS(10, "Resist Stagger II"), DS(10, "Resist Launch II"), DS(10, "Resist Stun II"), DS(10, "Resist Taunt II")],
[DS(15, "Melee Attack Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Soft Touch III"), DS(10, "Max HP Up XI"), DS(10, "Resist Stagger IV"), DS(10, "Resist Launch IV"), DS(10, "Resist Stun IV"), DS(10, "Resist Taunt IV")],
[DS(15, "Ranged Attack Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Melee: Recover HP XVI"), DS(10, "Max TP Boost IV"), DS(10, "Firing Range Up XVII"), DS(10, "Resist Knockback XVII"), DS(10, "Resist Launch XVII"), DS(10, "Resist Sleep XVII"), DS(10, "Taunt: Decoy XVII")],
[DS(15, "Ranged Attack Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Melee: Recover HP XVIII"), DS(10, "Max TP Boost VI"), DS(10, "Firing Range Up XIX"), DS(10, "Resist Knockback XIX"), DS(10, "Resist Launch XIX"), DS(10, "Resist Sleep XIX"), DS(10, "Taunt: Decoy XVII")],
[DS(15, "Ranged Attack Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Melee: Recover HP XX"), DS(10, "Max TP Boost VIII"), DS(10, "Resist Stagger I"), DS(10, "Resist Launch I"), DS(10, "Resist Stun I"), DS(10, "Resist Taunt I"), DS(10, "Taunt: Decoy XVII")],
[DS(15, "Ranged Attack Boost X"), DS(15, "Potential Boost X"), DS(10, "Max HP Drive X"), DS(10, "Soft Touch II"), DS(10, "Max TP Boost X"), DS(10, "Resist Stagger III"), DS(10, "Resist Launch III"), DS(10, "Resist Stun III"), DS(10, "Resist Taunt III"), DS(10, "Taunt: Decoy XVII")],
[DS(15, "Ranged Attack Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Soft Touch IV"), DS(10, "Max TP Boost XII"), DS(10, "Resist Stagger V"), DS(10, "Resist Launch V"), DS(10, "Resist Stun V"), DS(10, "Resist Taunt V"), DS(10, "Taunt: Decoy XVII")],
[DS(15, "Melee Attack Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Potential Up III"), DS(10, "Melee: Recover HP XV"), DS(10, "Max HP Up III"), DS(10, "Firing Range Up XVI"), DS(10, "Resist Knockback XVI"), DS(10, "Resist Launch XVI"), DS(10, "Resist Sleep XVI")],
[DS(15, "Melee Attack Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Potential Up V"), DS(10, "Melee: Recover HP XVII"), DS(10, "Max HP Up V"), DS(10, "Firing Range Up XVIII"), DS(10, "Resist Knockback XVIII"), DS(10, "Resist Launch XVIII"), DS(10, "Resist Sleep XVIII")],
[DS(15, "Melee Attack Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Melee: Recover HP XIX"), DS(10, "Max HP Up VII"), DS(10, "Firing Range Up XX"), DS(10, "Resist Knockback XX"), DS(10, "Resist Launch XX"), DS(10, "Resist Sleep XX")],
[DS(15, "Melee Attack Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Soft Touch I"), DS(10, "Max HP Up IX"), DS(10, "Resist Stagger II"), DS(10, "Resist Launch II"), DS(10, "Resist Stun II"), DS(10, "Resist Taunt II")],
[DS(15, "Melee Attack Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Soft Touch III"), DS(10, "Max HP Up XI"), DS(10, "Resist Stagger IV"), DS(10, "Resist Launch IV"), DS(10, "Resist Stun IV"), DS(10, "Resist Taunt IV")],
[DS(15, "Ranged Attack Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Melee: Recover HP XVI"), DS(10, "Max TP Boost IV"), DS(10, "Firing Range Up XVII"), DS(10, "Resist Knockback XVII"), DS(10, "Resist Launch XVII"), DS(10, "Resist Sleep XVII"), DS(10, "Taunt: Decoy XVI")],
[DS(15, "Ranged Attack Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Melee: Recover HP XVIII"), DS(10, "Max TP Boost VI"), DS(10, "Firing Range Up XIX"), DS(10, "Resist Knockback XIX"), DS(10, "Resist Launch XIX"), DS(10, "Resist Sleep XIX"), DS(10, "Taunt: Decoy XVI")],
[DS(15, "Ranged Attack Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Melee: Recover HP XX"), DS(10, "Max TP Boost VIII"), DS(10, "Resist Stagger I"), DS(10, "Resist Launch I"), DS(10, "Resist Stun I"), DS(10, "Resist Taunt I"), DS(10, "Taunt: Decoy XVI")],
[DS(15, "Ranged Attack Boost X"), DS(15, "Potential Boost X"), DS(10, "Max HP Drive X"), DS(10, "Soft Touch II"), DS(10, "Max TP Boost X"), DS(10, "Resist Stagger III"), DS(10, "Resist Launch III"), DS(10, "Resist Stun III"), DS(10, "Resist Taunt III"), DS(10, "Taunt: Decoy XVI")],
[DS(15, "Ranged Attack Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Soft Touch IV"), DS(10, "Max TP Boost XII"), DS(10, "Resist Stagger V"), DS(10, "Resist Launch V"), DS(10, "Resist Stun V"), DS(10, "Resist Taunt V"), DS(10, "Taunt: Decoy XVI")],
[DS(15, "Melee Attack Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Potential Up III"), DS(10, "Melee: Recover HP XV"), DS(10, "Max HP Up III"), DS(10, "Firing Range Up XVI"), DS(10, "Resist Knockback XVI"), DS(10, "Resist Launch XVI"), DS(10, "Resist Sleep XVI")],
[DS(15, "Melee Attack Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Potential Up V"), DS(10, "Melee: Recover HP XVII"), DS(10, "Max HP Up V"), DS(10, "Firing Range Up XVIII"), DS(10, "Resist Knockback XVIII"), DS(10, "Resist Launch XVIII"), DS(10, "Resist Sleep XVIII")],
[DS(15, "Melee Attack Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Melee: Recover HP XIX"), DS(10, "Max HP Up VII"), DS(10, "Firing Range Up XX"), DS(10, "Resist Knockback XX"), DS(10, "Resist Launch XX"), DS(10, "Resist Sleep XX")],
[DS(15, "Melee Attack Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Soft Touch I"), DS(10, "Max HP Up IX"), DS(10, "Resist Stagger II"), DS(10, "Resist Launch II"), DS(10, "Resist Stun II"), DS(10, "Resist Taunt II")],
[DS(15, "Melee Attack Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Soft Touch III"), DS(10, "Max HP Up XI"), DS(10, "Resist Stagger IV"), DS(10, "Resist Launch IV"), DS(10, "Resist Stun IV"), DS(10, "Resist Taunt IV")],
[DS(15, "Ranged Attack Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Melee: Recover HP XVI"), DS(10, "Max TP Boost IV"), DS(10, "Firing Range Up XVII"), DS(10, "Resist Knockback XVII"), DS(10, "Resist Launch XVII"), DS(10, "Resist Sleep XVII"), DS(10, "Taunt: Decoy XVIII")],
[DS(15, "Ranged Attack Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Melee: Recover HP XVIII"), DS(10, "Max TP Boost VI"), DS(10, "Firing Range Up XIX"), DS(10, "Resist Knockback XIX"), DS(10, "Resist Launch XIX"), DS(10, "Resist Sleep XIX"), DS(10, "Taunt: Decoy XVIII")],
[DS(15, "Ranged Attack Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Melee: Recover HP XX"), DS(10, "Max TP Boost VIII"), DS(10, "Resist Stagger I"), DS(10, "Resist Launch I"), DS(10, "Resist Stun I"), DS(10, "Resist Taunt I"), DS(10, "Taunt: Decoy XVIII")],
[DS(15, "Ranged Attack Boost X"), DS(15, "Potential Boost X"), DS(10, "Max HP Drive X"), DS(10, "Soft Touch II"), DS(10, "Max TP Boost X"), DS(10, "Resist Stagger III"), DS(10, "Resist Launch III"), DS(10, "Resist Stun III"), DS(10, "Resist Taunt III"), DS(10, "Taunt: Decoy XVIII")],
[DS(15, "Ranged Attack Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Soft Touch IV"), DS(10, "Max TP Boost XII"), DS(10, "Resist Stagger V"), DS(10, "Resist Launch V"), DS(10, "Resist Stun V"), DS(10, "Resist Taunt V"), DS(10, "Taunt: Decoy XVIII")],
[DS(15, "Ranged Accuracy Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Chimeroid Slayer XV"), DS(10, "Resist Shock XVI"), DS(10, "Electric Attack Plus XV"), DS(10, "Gravity Attack Plus XV"), DS(10, "Front Attack Plus XV"), DS(10, "Side Attack Plus XV")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Chimeroid Slayer XVII"), DS(10, "Resist Shock XVIII"), DS(10, "Electric Attack Plus XVII"), DS(10, "Gravity Attack Plus XVII"), DS(10, "Front Attack Plus XVII"), DS(10, "Side Attack Plus XVII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Chimeroid Slayer XIX"), DS(10, "Resist Shock XX"), DS(10, "Electric Attack Plus XIX"), DS(10, "Gravity Attack Plus XIX"), DS(10, "Front Attack Plus XIX"), DS(10, "Side Attack Plus XIX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Ultrafauna Slayer I"), DS(10, "Debuff Suppressor II"), DS(10, "Gravity Attack Plus I"), DS(10, "Front Attack Plus I"), DS(10, "Side Attack Plus I"), DS(10, "Back Attack Plus I")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Ultrafauna Slayer III"), DS(10, "Debuff Suppressor IV"), DS(10, "Gravity Attack Plus III"), DS(10, "Front Attack Plus III"), DS(10, "Side Attack Plus III"), DS(10, "Back Attack Plus III")],
[DS(15, "Evasion Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Chimeroid Slayer XVI"), DS(10, "Electric Attack Plus XVI"), DS(10, "Gravity Attack Plus XVI"), DS(10, "Front Attack Plus XVI"), DS(10, "Side Attack Plus XVI"), DS(10, "Gravity Resistance Up IV"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Chimeroid Slayer XVIII"), DS(10, "Electric Attack Plus XVIII"), DS(10, "Gravity Attack Plus XVIII"), DS(10, "Front Attack Plus XVIII"), DS(10, "Side Attack Plus XVIII"), DS(10, "Gravity Resistance Up V"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Chimeroid Slayer XX"), DS(10, "Electric Attack Plus XX"), DS(10, "Gravity Attack Plus XX"), DS(10, "Front Attack Plus XX"), DS(10, "Side Attack Plus XX"), DS(10, "Gravity Resistance Up VI"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Ultrafauna Slayer II"), DS(10, "Gravity Attack Plus II"), DS(10, "Front Attack Plus II"), DS(10, "Side Attack Plus II"), DS(10, "Back Attack Plus II"), DS(10, "Gravity Resistance Up VII"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Ultrafauna Slayer IV"), DS(10, "Gravity Attack Plus IV"), DS(10, "Front Attack Plus IV"), DS(10, "Side Attack Plus IV"), DS(10, "Back Attack Plus IV"), DS(10, "Gravity Resistance Up VIII"), DS(10, "Stabilizer X")],
[DS(15, "Ranged Accuracy Up III"), DS(15, "Ranged Attack Up III"), DS(10, "Potential Up III"), DS(10, "Physical Attack Plus XV"), DS(10, "Resist Shock XVI"), DS(10, "Electric Attack Plus XV"), DS(10, "Gravity Attack Plus XV"), DS(10, "Front Attack Plus XV"), DS(10, "Side Attack Plus XV")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Potential Up V"), DS(10, "Physical Attack Plus XVII"), DS(10, "Resist Shock XVIII"), DS(10, "Electric Attack Plus XVII"), DS(10, "Gravity Attack Plus XVII"), DS(10, "Front Attack Plus XVII"), DS(10, "Side Attack Plus XVII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Potential Up VII"), DS(10, "Physical Attack Plus XIX"), DS(10, "Resist Shock XX"), DS(10, "Electric Attack Plus XIX"), DS(10, "Gravity Attack Plus XIX"), DS(10, "Front Attack Plus XIX"), DS(10, "Side Attack Plus XIX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Potential Up IX"), DS(10, "Beam Attack Plus I"), DS(10, "Debuff Suppressor II"), DS(10, "Gravity Attack Plus I"), DS(10, "Front Attack Plus I"), DS(10, "Side Attack Plus I"), DS(10, "Back Attack Plus I")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Potential Up XI"), DS(10, "Beam Attack Plus III"), DS(10, "Debuff Suppressor IV"), DS(10, "Gravity Attack Plus III"), DS(10, "Front Attack Plus III"), DS(10, "Side Attack Plus III"), DS(10, "Back Attack Plus III")],
[DS(15, "Evasion Boost IV"), DS(15, "Potential Boost IV"), DS(10, "Max HP Drive IV"), DS(10, "Physical Attack Plus XVI"), DS(10, "Electric Attack Plus XVI"), DS(10, "Gravity Attack Plus XVI"), DS(10, "Front Attack Plus XVI"), DS(10, "Side Attack Plus XVI"), DS(10, "Gravity Resistance Up IV"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Max HP Drive VI"), DS(10, "Physical Attack Plus XVIII"), DS(10, "Electric Attack Plus XVIII"), DS(10, "Gravity Attack Plus XVIII"), DS(10, "Front Attack Plus XVIII"), DS(10, "Side Attack Plus XVIII"), DS(10, "Gravity Resistance Up V"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Max HP Drive VIII"), DS(10, "Physical Attack Plus XX"), DS(10, "Electric Attack Plus XX"), DS(10, "Gravity Attack Plus XX"), DS(10, "Front Attack Plus XX"), DS(10, "Side Attack Plus XX"), DS(10, "Gravity Resistance Up VI"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Max HP Drive X"), DS(10, "Beam Attack Plus II"), DS(10, "Gravity Attack Plus II"), DS(10, "Front Attack Plus II"), DS(10, "Side Attack Plus II"), DS(10, "Back Attack Plus II"), DS(10, "Gravity Resistance Up VII"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Max HP Drive XII"), DS(10, "Beam Attack Plus IV"), DS(10, "Gravity Attack Plus IV"), DS(10, "Front Attack Plus IV"), DS(10, "Side Attack Plus IV"), DS(10, "Back Attack Plus IV"), DS(10, "Gravity Resistance Up VIII"), DS(10, "Stabilizer X")],
[DS(15, "Melee Accuracy Up III"), DS(15, "Evasion Up III"), DS(15, "Melee Accuracy Up III"), DS(10, "Ultrafauna Slayer XV"), DS(10, "Resist Shock XVI"), DS(10, "Electric Attack Plus XV"), DS(10, "Gravity Attack Plus XV"), DS(10, "Front Attack Plus XV"), DS(10, "Extend Taunt XIII")],
[DS(15, "Melee Accuracy Up V"), DS(15, "Evasion Up V"), DS(15, "Melee Accuracy Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(10, "Resist Shock XVIII"), DS(10, "Electric Attack Plus XVII"), DS(10, "Gravity Attack Plus XVII"), DS(10, "Front Attack Plus XVII"), DS(10, "Extend Taunt XV")],
[DS(15, "Melee Accuracy Up VII"), DS(15, "Evasion Up VII"), DS(15, "Melee Accuracy Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(10, "Resist Shock XX"), DS(10, "Electric Attack Plus XIX"), DS(10, "Gravity Attack Plus XIX"), DS(10, "Front Attack Plus XIX"), DS(10, "Extend Taunt XVII")],
[DS(15, "Melee Accuracy Up IX"), DS(15, "Evasion Up IX"), DS(15, "Melee Accuracy Up IX"), DS(10, "Physical Attack Plus I"), DS(10, "Debuff Suppressor II"), DS(10, "Gravity Attack Plus I"), DS(10, "Front Attack Plus I"), DS(10, "Side Attack Plus I"), DS(10, "Extend Taunt XIX")],
[DS(15, "Melee Accuracy Up XI"), DS(15, "Evasion Up XI"), DS(15, "Melee Accuracy Up XI"), DS(10, "Physical Attack Plus III"), DS(10, "Debuff Suppressor IV"), DS(10, "Gravity Attack Plus III"), DS(10, "Front Attack Plus III"), DS(10, "Side Attack Plus III"), DS(10, "Extend Control I")],
[DS(15, "Ranged Accuracy Boost IV"), DS(15, "Melee Attack Boost IV"), DS(15, "Ranged Accuracy Boost IV"), DS(10, "Ultrafauna Slayer XVI"), DS(10, "Resist Shock XVII"), DS(10, "Electric Attack Plus XVI"), DS(10, "Gravity Attack Plus XVI"), DS(10, "Front Attack Plus XVI"), DS(10, "Topple: Decoy II")],
[DS(15, "Ranged Accuracy Boost VI"), DS(15, "Melee Attack Boost VI"), DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(10, "Resist Shock XIX"), DS(10, "Electric Attack Plus XVIII"), DS(10, "Gravity Attack Plus XVIII"), DS(10, "Front Attack Plus XVIII"), DS(10, "Topple: Decoy IV")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(15, "Melee Attack Boost VIII"), DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(10, "Debuff Suppressor I"), DS(10, "Electric Attack Plus XX"), DS(10, "Gravity Attack Plus XX"), DS(10, "Front Attack Plus XX"), DS(10, "Topple: Decoy VI")],
[DS(15, "Ranged Accuracy Boost X"), DS(15, "Melee Attack Boost X"), DS(15, "Ranged Accuracy Boost X"), DS(10, "Physical Attack Plus II"), DS(10, "Debuff Suppressor III"), DS(10, "Gravity Attack Plus II"), DS(10, "Front Attack Plus II"), DS(10, "Side Attack Plus II"), DS(10, "Topple: Decoy VIII")],
[DS(15, "Ranged Accuracy Boost XII"), DS(15, "Melee Attack Boost XII"), DS(15, "Ranged Accuracy Boost XII"), DS(10, "Physical Attack Plus IV"), DS(10, "Debuff Suppressor V"), DS(10, "Gravity Attack Plus IV"), DS(10, "Front Attack Plus IV"), DS(10, "Side Attack Plus IV"), DS(10, "Topple: Decoy X")],
[DS(15, "Melee Accuracy Up III"), DS(15, "Evasion Up III"), DS(15, "Melee Accuracy Up III"), DS(10, "Ether Attack Plus XV"), DS(10, "Resist Shock XVI"), DS(10, "Electric Attack Plus XV"), DS(10, "Gravity Attack Plus XV"), DS(10, "Front Attack Plus XV"), DS(10, "Arts: Recover HP XIII")],
[DS(15, "Melee Accuracy Up V"), DS(15, "Evasion Up V"), DS(15, "Melee Accuracy Up V"), DS(10, "Ether Attack Plus XVII"), DS(10, "Resist Shock XVIII"), DS(10, "Electric Attack Plus XVII"), DS(10, "Gravity Attack Plus XVII"), DS(10, "Front Attack Plus XVII"), DS(10, "Arts: Recover HP XV")],
[DS(15, "Melee Accuracy Up VII"), DS(15, "Evasion Up VII"), DS(15, "Melee Accuracy Up VII"), DS(10, "Ether Attack Plus XIX"), DS(10, "Resist Shock XX"), DS(10, "Electric Attack Plus XIX"), DS(10, "Gravity Attack Plus XIX"), DS(10, "Front Attack Plus XIX"), DS(10, "Arts: Recover HP XVII")],
[DS(15, "Melee Accuracy Up IX"), DS(15, "Evasion Up IX"), DS(15, "Melee Accuracy Up IX"), DS(10, "Thermal Attack Plus I"), DS(10, "Debuff Suppressor II"), DS(10, "Gravity Attack Plus I"), DS(10, "Front Attack Plus I"), DS(10, "Side Attack Plus I"), DS(10, "Arts: Recover HP XIX")],
[DS(15, "Melee Accuracy Up XI"), DS(15, "Evasion Up XI"), DS(15, "Melee Accuracy Up XI"), DS(10, "Thermal Attack Plus III"), DS(10, "Debuff Suppressor IV"), DS(10, "Gravity Attack Plus III"), DS(10, "Front Attack Plus III"), DS(10, "Side Attack Plus III"), DS(10, "Secondary CD Reducer I")],
[DS(15, "Ranged Accuracy Boost IV"), DS(15, "Melee Attack Boost IV"), DS(15, "Ranged Accuracy Boost IV"), DS(10, "Ether Attack Plus XVI"), DS(10, "Resist Shock XVII"), DS(10, "Electric Attack Plus XVI"), DS(10, "Gravity Attack Plus XVI"), DS(10, "Front Attack Plus XVI"), DS(10, "Reflect: Beam")],
[DS(15, "Ranged Accuracy Boost VI"), DS(15, "Melee Attack Boost VI"), DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ether Attack Plus XVIII"), DS(10, "Resist Shock XIX"), DS(10, "Electric Attack Plus XVIII"), DS(10, "Gravity Attack Plus XVIII"), DS(10, "Front Attack Plus XVIII"), DS(10, "Reflect: Thermal")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(15, "Melee Attack Boost VIII"), DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ether Attack Plus XX"), DS(10, "Debuff Suppressor I"), DS(10, "Electric Attack Plus XX"), DS(10, "Gravity Attack Plus XX"), DS(10, "Front Attack Plus XX"), DS(10, "Reflect: Gravity")],
[DS(15, "Ranged Accuracy Boost X"), DS(15, "Melee Attack Boost X"), DS(15, "Ranged Accuracy Boost X"), DS(10, "Thermal Attack Plus II"), DS(10, "Debuff Suppressor III"), DS(10, "Gravity Attack Plus II"), DS(10, "Front Attack Plus II"), DS(10, "Side Attack Plus II"), DS(10, "Reflect Damage Up II")],
[DS(15, "Ranged Accuracy Boost XII"), DS(15, "Melee Attack Boost XII"), DS(15, "Ranged Accuracy Boost XII"), DS(10, "Thermal Attack Plus IV"), DS(10, "Debuff Suppressor V"), DS(10, "Gravity Attack Plus IV"), DS(10, "Front Attack Plus IV"), DS(10, "Side Attack Plus IV"), DS(10, "Reflect Damage Up IV")],
[DS(15, "Melee Accuracy Up III"), DS(15, "Evasion Up III"), DS(15, "Melee Accuracy Up III"), DS(10, "Ultrafauna Slayer XV"), DS(10, "Resist Shock XVI"), DS(10, "Electric Attack Plus XV"), DS(10, "Gravity Attack Plus XV"), DS(10, "Front Attack Plus XV"), DS(10, "Extend Taunt XIII")],
[DS(15, "Melee Accuracy Up V"), DS(15, "Evasion Up V"), DS(15, "Melee Accuracy Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(10, "Resist Shock XVIII"), DS(10, "Electric Attack Plus XVII"), DS(10, "Gravity Attack Plus XVII"), DS(10, "Front Attack Plus XVII"), DS(10, "Extend Taunt XV")],
[DS(15, "Melee Accuracy Up VII"), DS(15, "Evasion Up VII"), DS(15, "Melee Accuracy Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(10, "Resist Shock XX"), DS(10, "Electric Attack Plus XIX"), DS(10, "Gravity Attack Plus XIX"), DS(10, "Front Attack Plus XIX"), DS(10, "Extend Taunt XVII")],
[DS(15, "Melee Accuracy Up IX"), DS(15, "Evasion Up IX"), DS(15, "Melee Accuracy Up IX"), DS(10, "Physical Attack Plus I"), DS(10, "Debuff Suppressor II"), DS(10, "Gravity Attack Plus I"), DS(10, "Front Attack Plus I"), DS(10, "Side Attack Plus I"), DS(10, "Extend Taunt XIX")],
[DS(15, "Melee Accuracy Up XI"), DS(15, "Evasion Up XI"), DS(15, "Melee Accuracy Up XI"), DS(10, "Physical Attack Plus III"), DS(10, "Debuff Suppressor IV"), DS(10, "Gravity Attack Plus III"), DS(10, "Front Attack Plus III"), DS(10, "Side Attack Plus III"), DS(10, "Extend Control I")],
[DS(15, "Ranged Accuracy Boost IV"), DS(15, "Melee Attack Boost IV"), DS(15, "Ranged Accuracy Boost IV"), DS(10, "Ultrafauna Slayer XVI"), DS(10, "Resist Shock XVII"), DS(10, "Electric Attack Plus XVI"), DS(10, "Gravity Attack Plus XVI"), DS(10, "Front Attack Plus XVI"), DS(10, "Topple: Decoy II")],
[DS(15, "Ranged Accuracy Boost VI"), DS(15, "Melee Attack Boost VI"), DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(10, "Resist Shock XIX"), DS(10, "Electric Attack Plus XVIII"), DS(10, "Gravity Attack Plus XVIII"), DS(10, "Front Attack Plus XVIII"), DS(10, "Topple: Decoy IV")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(15, "Melee Attack Boost VIII"), DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(10, "Debuff Suppressor I"), DS(10, "Electric Attack Plus XX"), DS(10, "Gravity Attack Plus XX"), DS(10, "Front Attack Plus XX"), DS(10, "Topple: Decoy VI")],
[DS(15, "Ranged Accuracy Boost X"), DS(15, "Melee Attack Boost X"), DS(15, "Ranged Accuracy Boost X"), DS(10, "Physical Attack Plus II"), DS(10, "Debuff Suppressor III"), DS(10, "Gravity Attack Plus II"), DS(10, "Front Attack Plus II"), DS(10, "Side Attack Plus II"), DS(10, "Topple: Decoy VIII")],
[DS(15, "Ranged Accuracy Boost XII"), DS(15, "Melee Attack Boost XII"), DS(15, "Ranged Accuracy Boost XII"), DS(10, "Physical Attack Plus IV"), DS(10, "Debuff Suppressor V"), DS(10, "Gravity Attack Plus IV"), DS(10, "Front Attack Plus IV"), DS(10, "Side Attack Plus IV"), DS(10, "Topple: Decoy X")],
[DS(15, "Melee Accuracy Up III"), DS(15, "Evasion Up III"), DS(15, "Melee Accuracy Up III"), DS(10, "Ultrafauna Slayer XV"), DS(10, "Resist Shock XVI"), DS(10, "Electric Attack Plus XV"), DS(10, "Gravity Attack Plus XV"), DS(10, "Front Attack Plus XV")],
[DS(15, "Melee Accuracy Up V"), DS(15, "Evasion Up V"), DS(15, "Melee Accuracy Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(10, "Resist Shock XVIII"), DS(10, "Electric Attack Plus XVII"), DS(10, "Gravity Attack Plus XVII"), DS(10, "Front Attack Plus XVII")],
[DS(15, "Melee Accuracy Up VII"), DS(15, "Evasion Up VII"), DS(15, "Melee Accuracy Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(10, "Resist Shock XX"), DS(10, "Electric Attack Plus XIX"), DS(10, "Gravity Attack Plus XIX"), DS(10, "Front Attack Plus XIX")],
[DS(15, "Melee Accuracy Up IX"), DS(15, "Evasion Up IX"), DS(15, "Melee Accuracy Up IX"), DS(10, "Physical Attack Plus I"), DS(10, "Debuff Suppressor II"), DS(10, "Gravity Attack Plus I"), DS(10, "Front Attack Plus I"), DS(10, "Side Attack Plus I")],
[DS(15, "Melee Accuracy Up XI"), DS(15, "Evasion Up XI"), DS(15, "Melee Accuracy Up XI"), DS(10, "Physical Attack Plus III"), DS(10, "Debuff Suppressor IV"), DS(10, "Gravity Attack Plus III"), DS(10, "Front Attack Plus III"), DS(10, "Side Attack Plus III")],
[DS(15, "Ranged Accuracy Boost IV"), DS(15, "Melee Attack Boost IV"), DS(15, "Ranged Accuracy Boost IV"), DS(10, "Ultrafauna Slayer XVI"), DS(10, "Resist Shock XVII"), DS(10, "Electric Attack Plus XVI"), DS(10, "Gravity Attack Plus XVI"), DS(10, "Front Attack Plus XVI"), DS(10, "Topple: Decoy II")],
[DS(15, "Ranged Accuracy Boost VI"), DS(15, "Melee Attack Boost VI"), DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(10, "Resist Shock XIX"), DS(10, "Electric Attack Plus XVIII"), DS(10, "Gravity Attack Plus XVIII"), DS(10, "Front Attack Plus XVIII"), DS(10, "Topple: Decoy IV")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(15, "Melee Attack Boost VIII"), DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(10, "Debuff Suppressor I"), DS(10, "Electric Attack Plus XX"), DS(10, "Gravity Attack Plus XX"), DS(10, "Front Attack Plus XX"), DS(10, "Topple: Decoy VI")],
[DS(15, "Ranged Accuracy Boost X"), DS(15, "Melee Attack Boost X"), DS(15, "Ranged Accuracy Boost X"), DS(10, "Physical Attack Plus II"), DS(10, "Debuff Suppressor III"), DS(10, "Gravity Attack Plus II"), DS(10, "Front Attack Plus II"), DS(10, "Side Attack Plus II"), DS(10, "Topple: Decoy VIII")],
[DS(15, "Ranged Accuracy Boost XII"), DS(15, "Melee Attack Boost XII"), DS(15, "Ranged Accuracy Boost XII"), DS(10, "Physical Attack Plus IV"), DS(10, "Debuff Suppressor V"), DS(10, "Gravity Attack Plus IV"), DS(10, "Front Attack Plus IV"), DS(10, "Side Attack Plus IV"), DS(10, "Topple: Decoy X")],
[DS(15, "Melee Accuracy Up III"), DS(15, "Evasion Up III"), DS(15, "Melee Accuracy Up III"), DS(10, "Ultrafauna Slayer XV"), DS(10, "Resist Shock XVI"), DS(10, "Electric Attack Plus XV"), DS(10, "Gravity Attack Plus XV"), DS(10, "Front Attack Plus XV")],
[DS(15, "Melee Accuracy Up V"), DS(15, "Evasion Up V"), DS(15, "Melee Accuracy Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(10, "Resist Shock XVIII"), DS(10, "Electric Attack Plus XVII"), DS(10, "Gravity Attack Plus XVII"), DS(10, "Front Attack Plus XVII")],
[DS(15, "Melee Accuracy Up VII"), DS(15, "Evasion Up VII"), DS(15, "Melee Accuracy Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(10, "Resist Shock XX"), DS(10, "Electric Attack Plus XIX"), DS(10, "Gravity Attack Plus XIX"), DS(10, "Front Attack Plus XIX")],
[DS(15, "Melee Accuracy Up IX"), DS(15, "Evasion Up IX"), DS(15, "Melee Accuracy Up IX"), DS(10, "Physical Attack Plus I"), DS(10, "Debuff Suppressor II"), DS(10, "Gravity Attack Plus I"), DS(10, "Front Attack Plus I"), DS(10, "Side Attack Plus I")],
[DS(15, "Melee Accuracy Up XI"), DS(15, "Evasion Up XI"), DS(15, "Melee Accuracy Up XI"), DS(10, "Physical Attack Plus III"), DS(10, "Debuff Suppressor IV"), DS(10, "Gravity Attack Plus III"), DS(10, "Front Attack Plus III"), DS(10, "Side Attack Plus III")],
[DS(15, "Ranged Accuracy Boost IV"), DS(15, "Melee Attack Boost IV"), DS(15, "Ranged Accuracy Boost IV"), DS(10, "Ultrafauna Slayer XVI"), DS(10, "Resist Shock XVII"), DS(10, "Electric Attack Plus XVI"), DS(10, "Gravity Attack Plus XVI"), DS(10, "Front Attack Plus XVI"), DS(10, "Topple: Decoy II")],
[DS(15, "Ranged Accuracy Boost VI"), DS(15, "Melee Attack Boost VI"), DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(10, "Resist Shock XIX"), DS(10, "Electric Attack Plus XVIII"), DS(10, "Gravity Attack Plus XVIII"), DS(10, "Front Attack Plus XVIII"), DS(10, "Topple: Decoy IV")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(15, "Melee Attack Boost VIII"), DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(10, "Debuff Suppressor I"), DS(10, "Electric Attack Plus XX"), DS(10, "Gravity Attack Plus XX"), DS(10, "Front Attack Plus XX"), DS(10, "Topple: Decoy VI")],
[DS(15, "Ranged Accuracy Boost X"), DS(15, "Melee Attack Boost X"), DS(15, "Ranged Accuracy Boost X"), DS(10, "Physical Attack Plus II"), DS(10, "Debuff Suppressor III"), DS(10, "Gravity Attack Plus II"), DS(10, "Front Attack Plus II"), DS(10, "Side Attack Plus II"), DS(10, "Topple: Decoy VIII")],
[DS(15, "Ranged Accuracy Boost XII"), DS(15, "Melee Attack Boost XII"), DS(15, "Ranged Accuracy Boost XII"), DS(10, "Physical Attack Plus IV"), DS(10, "Debuff Suppressor V"), DS(10, "Gravity Attack Plus IV"), DS(10, "Front Attack Plus IV"), DS(10, "Side Attack Plus IV"), DS(10, "Topple: Decoy X")],
[DS(15, "Melee Accuracy Up III"), DS(15, "Melee Accuracy Up III"), DS(15, "Potential Up III"), DS(10, "Physical Attack Plus XV"), DS(10, "Resist Shock XVI"), DS(10, "Electric Attack Plus XV"), DS(10, "Gravity Attack Plus XV"), DS(10, "Front Attack Plus XV"), DS(10, "Stun: Barrier I")],
[DS(15, "Melee Accuracy Up V"), DS(15, "Melee Accuracy Up V"), DS(15, "Potential Up V"), DS(10, "Physical Attack Plus XVII"), DS(10, "Resist Shock XVIII"), DS(10, "Electric Attack Plus XVII"), DS(10, "Gravity Attack Plus XVII"), DS(10, "Front Attack Plus XVII"), DS(10, "Stun: Barrier III")],
[DS(15, "Melee Accuracy Up VII"), DS(15, "Melee Accuracy Up VII"), DS(15, "Potential Up VII"), DS(10, "Physical Attack Plus XIX"), DS(10, "Resist Shock XX"), DS(10, "Electric Attack Plus XIX"), DS(10, "Gravity Attack Plus XIX"), DS(10, "Front Attack Plus XIX"), DS(10, "Stun: Barrier V")],
[DS(15, "Melee Accuracy Up IX"), DS(15, "Melee Accuracy Up IX"), DS(15, "Potential Up IX"), DS(10, "Beam Attack Plus I"), DS(10, "Debuff Suppressor II"), DS(10, "Gravity Attack Plus I"), DS(10, "Front Attack Plus I"), DS(10, "Side Attack Plus I"), DS(10, "Stun: Barrier VII")],
[DS(15, "Melee Accuracy Up XI"), DS(15, "Melee Accuracy Up XI"), DS(15, "Potential Up XI"), DS(10, "Beam Attack Plus III"), DS(10, "Debuff Suppressor IV"), DS(10, "Gravity Attack Plus III"), DS(10, "Front Attack Plus III"), DS(10, "Side Attack Plus III"), DS(10, "Stun: Barrier IX")],
[DS(15, "Ranged Accuracy Boost IV"), DS(15, "Ranged Accuracy Boost IV"), DS(15, "Max HP Drive IV"), DS(10, "Physical Attack Plus XVI"), DS(10, "Resist Shock XVII"), DS(10, "Electric Attack Plus XVI"), DS(10, "Gravity Attack Plus XVI"), DS(10, "Front Attack Plus XVI"), DS(10, "Resist Thermal Res Down XVII")],
[DS(15, "Ranged Accuracy Boost VI"), DS(15, "Ranged Accuracy Boost VI"), DS(15, "Max HP Drive VI"), DS(10, "Physical Attack Plus XVIII"), DS(10, "Resist Shock XIX"), DS(10, "Electric Attack Plus XVIII"), DS(10, "Gravity Attack Plus XVIII"), DS(10, "Front Attack Plus XVIII"), DS(10, "Resist Thermal Res Down XIX")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(15, "Ranged Accuracy Boost VIII"), DS(15, "Max HP Drive VIII"), DS(10, "Physical Attack Plus XX"), DS(10, "Debuff Suppressor I"), DS(10, "Electric Attack Plus XX"), DS(10, "Gravity Attack Plus XX"), DS(10, "Front Attack Plus XX"), DS(10, "Resist Electric Res Down I")],
[DS(15, "Ranged Accuracy Boost X"), DS(15, "Ranged Accuracy Boost X"), DS(15, "Max HP Drive X"), DS(10, "Beam Attack Plus II"), DS(10, "Debuff Suppressor III"), DS(10, "Gravity Attack Plus II"), DS(10, "Front Attack Plus II"), DS(10, "Side Attack Plus II"), DS(10, "Resist Electric Res Down III")],
[DS(15, "Ranged Accuracy Boost XII"), DS(15, "Ranged Accuracy Boost XII"), DS(15, "Max HP Drive XII"), DS(10, "Beam Attack Plus IV"), DS(10, "Debuff Suppressor V"), DS(10, "Gravity Attack Plus IV"), DS(10, "Front Attack Plus IV"), DS(10, "Side Attack Plus IV"), DS(10, "Resist Electric Res Down V")],
[DS(10, "Beam Attack Plus XV"), DS(15, "Debuff Suppressor XVI"), DS(15, "Critical Chance Up XVI"), DS(15, "Theroid Criticals Up XVI"), DS(15, "Insectoid Criticals Up XVI"), DS(15, "Piscinoid Criticals Up XVI")],
[DS(10, "Beam Attack Plus XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(10, "Beam Attack Plus XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(10, "Ether Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(10, "Ether Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(10, "Beam Attack Plus XVI"), DS(15, "Resist Shock XVII"), DS(10, "Destabilizer XIX"), DS(10, "Magazine Capacity Up XIX"), DS(10, "Ultrafauna Criticals Up XVII"), DS(10, "Extend Critical Power XVII"), DS(10, "Piscinoid Slayer XVI"), DS(10, "Theroid Slayer XVI"), DS(10, "Insectoid Slayer XVI")],
[DS(10, "Beam Attack Plus XVIII"), DS(15, "Resist Shock XIX"), DS(10, "Magazine Capacity Up I"), DS(10, "Melee: TP Gain Up"), DS(10, "Ultrafauna Criticals Up XIX"), DS(10, "Extend Critical Power XIX"), DS(10, "Piscinoid Slayer XVIII"), DS(10, "Theroid Slayer XVIII"), DS(10, "Insectoid Slayer XVIII")],
[DS(10, "Beam Attack Plus XX"), DS(15, "Debuff Suppressor I"), DS(10, "Magazine Capacity Up III"), DS(10, "Cooldown Reducer I"), DS(10, "Extend Critical Power I"), DS(10, "Zero Critical"), DS(10, "Piscinoid Slayer XX"), DS(10, "Theroid Slayer XX"), DS(10, "Insectoid Slayer XX")],
[DS(10, "Ether Attack Plus II"), DS(15, "Debuff Suppressor III"), DS(10, "Magazine Capacity Up V"), DS(10, "Cooldown Reducer III"), DS(10, "Extend Critical Power III"), DS(10, "Theroid Slayer II"), DS(10, "Humanoid Slayer II"), DS(10, "Insectoid Slayer II"), DS(10, "Piscinoid Slayer II")],
[DS(10, "Ether Attack Plus IV"), DS(15, "Debuff Suppressor V"), DS(10, "Magazine Capacity Up VII"), DS(10, "Cooldown Reducer V"), DS(10, "Extend Critical Power V"), DS(10, "Theroid Slayer IV"), DS(10, "Humanoid Slayer IV"), DS(10, "Insectoid Slayer IV"), DS(10, "Piscinoid Slayer IV")],
[DS(15, "Overdrive Count Up XV"), DS(15, "Resist Control XVI")],
[DS(15, "Overdrive Count Up XVII"), DS(15, "Resist Control XVIII")],
[DS(15, "Overdrive Count Up XIX"), DS(15, "Resist Control XX")],
[DS(15, "Extend Overdrive I"), DS(15, "Resist Virus II")],
[DS(15, "Extend Overdrive III"), DS(15, "Resist Virus IV")],
[DS(15, "Melee: Recover HP XV"), DS(10, "Stabilizer X"), DS(10, "Destabilizer XIX"), DS(10, "Stabilizer XIX"), DS(10, "Magazine Capacity Up XIX")],
[DS(15, "Melee: Recover HP XV"), DS(10, "Stabilizer X"), DS(10, "Magazine Capacity Up I"), DS(10, "Destabilizer I"), DS(10, "Melee: TP Gain Up")],
[DS(15, "Melee: Recover HP XV"), DS(10, "Stabilizer X"), DS(10, "Magazine Capacity Up III"), DS(10, "Destabilizer III"), DS(10, "Cooldown Reducer I")],
[DS(15, "Melee: Recover HP XV"), DS(10, "Stabilizer X"), DS(10, "Magazine Capacity Up V"), DS(10, "Destabilizer V"), DS(10, "Cooldown Reducer III")],
[DS(15, "Melee: Recover HP XV"), DS(10, "Stabilizer X"), DS(10, "Magazine Capacity Up VII"), DS(10, "Destabilizer VII"), DS(10, "Cooldown Reducer V")],
[DS(15, "Extend Overdrive XV"), DS(15, "Resist Virus XVI")],
[DS(15, "Extend Overdrive XVII"), DS(15, "Resist Virus XVIII")],
[DS(15, "Extend Overdrive XIX"), DS(15, "Resist Virus XX")],
[DS(15, "Overdrive Blue Bonus"), DS(15, "Resist Blackout II")],
[DS(15, "Extend Aura I"), DS(15, "Resist Blackout IV")],
[DS(15, "Melee: Recover HP XV"), DS(10, "Stabilizer X"), DS(10, "Destabilizer XIX"), DS(10, "Stabilizer XIX"), DS(10, "Magazine Capacity Up XIX")],
[DS(15, "Melee: Recover HP XV"), DS(10, "Stabilizer X"), DS(10, "Magazine Capacity Up I"), DS(10, "Destabilizer I"), DS(10, "Melee: TP Gain Up")],
[DS(15, "Melee: Recover HP XV"), DS(10, "Stabilizer X"), DS(10, "Magazine Capacity Up III"), DS(10, "Destabilizer III"), DS(10, "Cooldown Reducer I")],
[DS(15, "Melee: Recover HP XV"), DS(10, "Stabilizer X"), DS(10, "Destabilizer XIX"), DS(10, "Stabilizer XIX"), DS(10, "Magazine Capacity Up XIX")],
[DS(15, "Melee: Recover HP XV"), DS(10, "Stabilizer X"), DS(10, "Magazine Capacity Up VII"), DS(10, "Destabilizer VII"), DS(10, "Cooldown Reducer V")],
[DS(20, "Melee Accuracy Up III"), DS(20, "Ranged Accuracy Up III"), DS(20, "Evasion Up III"), DS(20, "Resist Control XVI"), DS(20, "Resist Blackout XVI")],
[DS(20, "Melee Accuracy Up V"), DS(20, "Ranged Accuracy Up V"), DS(20, "Evasion Up V"), DS(20, "Resist Control XVIII"), DS(20, "Resist Blackout XVIII")],
[DS(20, "Melee Accuracy Up VII"), DS(20, "Ranged Accuracy Up VII"), DS(20, "Evasion Up VII"), DS(20, "Resist Control XX"), DS(20, "Resist Blackout XX")],
[DS(20, "Melee Accuracy Up IX"), DS(20, "Ranged Accuracy Up IX"), DS(20, "Evasion Up IX"), DS(20, "Resist Virus II"), DS(20, "Resist Fatigue II")],
[DS(20, "Melee Accuracy Up XI"), DS(20, "Ranged Accuracy Up XI"), DS(20, "Evasion Up XI"), DS(20, "Resist Virus IV"), DS(20, "Resist Fatigue IV")],
[DS(20, "Ranged Accuracy Boost IV"), DS(20, "Evasion Boost IV"), DS(20, "Melee Attack Boost IV"), DS(20, "Resist Control XVII"), DS(20, "Resist Blackout XVII"), DS(10, "Melee Accuracy Drive VII"), DS(10, "Evasion Drive VII"), DS(5, "Max GP Drive VII")],
[DS(20, "Ranged Accuracy Boost VI"), DS(20, "Evasion Boost VI"), DS(20, "Melee Attack Boost VI"), DS(20, "Resist Control XIX"), DS(20, "Resist Blackout XIX"), DS(10, "Melee Accuracy Drive IX"), DS(10, "Evasion Drive IX"), DS(5, "Max GP Drive IX")],
[DS(20, "Ranged Accuracy Boost VIII"), DS(20, "Evasion Boost VIII"), DS(20, "Melee Attack Boost VIII"), DS(20, "Resist Virus I"), DS(20, "Resist Fatigue I"), DS(10, "Melee Accuracy Drive XI"), DS(10, "Evasion Drive XI"), DS(5, "Max GP Drive XI")],
[DS(20, "Ranged Accuracy Boost X"), DS(20, "Evasion Boost X"), DS(20, "Melee Attack Boost X"), DS(20, "Resist Virus III"), DS(20, "Resist Fatigue III"), DS(10, "Melee Accuracy Drive XIII"), DS(10, "Evasion Drive XIII"), DS(5, "Max GP Drive XIII")],
[DS(20, "Ranged Accuracy Boost XII"), DS(20, "Evasion Boost XII"), DS(20, "Melee Attack Boost XII"), DS(20, "Resist Virus V"), DS(20, "Resist Fatigue V"), DS(10, "Melee Accuracy Drive XV"), DS(10, "Evasion Drive XV"), DS(5, "Max GP Drive XV")],
[DS(20, "Melee Accuracy Up III"), DS(20, "Ranged Accuracy Up III"), DS(20, "Evasion Up III"), DS(20, "Melee Attack Up III"), DS(20, "Ranged Attack Up III")],
[DS(20, "Melee Accuracy Up V"), DS(20, "Ranged Accuracy Up V"), DS(20, "Evasion Up V"), DS(20, "Melee Attack Up V"), DS(20, "Ranged Attack Up V")],
[DS(20, "Melee Accuracy Up VII"), DS(20, "Ranged Accuracy Up VII"), DS(20, "Evasion Up VII"), DS(20, "Melee Attack Up VII"), DS(20, "Ranged Attack Up VII")],
[DS(20, "Melee Accuracy Up IX"), DS(20, "Ranged Accuracy Up IX"), DS(20, "Evasion Up IX"), DS(20, "Melee Attack Up IX"), DS(20, "Ranged Attack Up IX")],
[DS(20, "Melee Accuracy Up XI"), DS(20, "Ranged Accuracy Up XI"), DS(20, "Evasion Up XI"), DS(20, "Melee Attack Up XI"), DS(20, "Ranged Attack Up XI")],
[DS(20, "Ranged Accuracy Boost IV"), DS(20, "Evasion Boost IV"), DS(20, "Melee Attack Boost IV"), DS(20, "Ranged Attack Boost IV"), DS(20, "Potential Boost IV"), DS(10, "Max TP Boost IV"), DS(10, "Melee Accuracy Drive VII"), DS(10, "Evasion Drive VII"), DS(5, "Max GP Drive VII")],
[DS(20, "Ranged Accuracy Boost VI"), DS(20, "Evasion Boost VI"), DS(20, "Melee Attack Boost VI"), DS(20, "Ranged Attack Boost VI"), DS(20, "Potential Boost VI"), DS(10, "Max TP Boost VI"), DS(10, "Melee Accuracy Drive IX"), DS(10, "Evasion Drive IX"), DS(5, "Max GP Drive IX")],
[DS(20, "Ranged Accuracy Boost VIII"), DS(20, "Evasion Boost VIII"), DS(20, "Melee Attack Boost VIII"), DS(20, "Ranged Attack Boost VIII"), DS(20, "Potential Boost VIII"), DS(10, "Max TP Boost VIII"), DS(10, "Melee Accuracy Drive XI"), DS(10, "Evasion Drive XI"), DS(5, "Max GP Drive XI")],
[DS(20, "Ranged Accuracy Boost X"), DS(20, "Evasion Boost X"), DS(20, "Melee Attack Boost X"), DS(20, "Ranged Attack Boost X"), DS(20, "Potential Boost X"), DS(10, "Max TP Boost X"), DS(10, "Melee Accuracy Drive XIII"), DS(10, "Evasion Drive XIII"), DS(5, "Max GP Drive XIII")],
[DS(20, "Ranged Accuracy Boost XII"), DS(20, "Evasion Boost XII"), DS(20, "Melee Attack Boost XII"), DS(20, "Ranged Attack Boost XII"), DS(20, "Potential Boost XII"), DS(10, "Max TP Boost XII"), DS(10, "Melee Accuracy Drive XV"), DS(10, "Evasion Drive XV"), DS(5, "Max GP Drive XV")],
[DS(20, "Melee Accuracy Up III"), DS(20, "Ranged Accuracy Up III"), DS(20, "Melee Attack Up III"), DS(20, "Ranged Attack Up III")],
[DS(20, "Melee Accuracy Up V"), DS(20, "Ranged Accuracy Up V"), DS(20, "Melee Attack Up V"), DS(20, "Ranged Attack Up V")],
[DS(20, "Melee Accuracy Up VII"), DS(20, "Ranged Accuracy Up VII"), DS(20, "Melee Attack Up VII"), DS(20, "Ranged Attack Up VII")],
[DS(20, "Melee Accuracy Up IX"), DS(20, "Ranged Accuracy Up IX"), DS(20, "Melee Attack Up IX"), DS(20, "Ranged Attack Up IX")],
[DS(20, "Melee Accuracy Up XI"), DS(20, "Ranged Accuracy Up XI"), DS(20, "Melee Attack Up XI"), DS(20, "Ranged Attack Up XI")],
[DS(20, "Ranged Accuracy Boost IV"), DS(20, "Evasion Boost IV"), DS(20, "Ranged Attack Boost IV"), DS(20, "Potential Boost IV"), DS(10, "Melee Accuracy Drive VII"), DS(10, "Evasion Drive VII"), DS(5, "Max GP Drive VII")],
[DS(20, "Ranged Accuracy Boost VI"), DS(20, "Evasion Boost VI"), DS(20, "Ranged Attack Boost VI"), DS(20, "Potential Boost VI"), DS(10, "Melee Accuracy Drive IX"), DS(10, "Evasion Drive IX"), DS(5, "Max GP Drive IX")],
[DS(20, "Ranged Accuracy Boost VIII"), DS(20, "Evasion Boost VIII"), DS(20, "Ranged Attack Boost VIII"), DS(20, "Potential Boost VIII"), DS(10, "Melee Accuracy Drive XI"), DS(10, "Evasion Drive XI"), DS(5, "Max GP Drive XI")],
[DS(20, "Ranged Accuracy Boost X"), DS(20, "Evasion Boost X"), DS(20, "Ranged Attack Boost X"), DS(20, "Potential Boost X"), DS(10, "Melee Accuracy Drive XIII"), DS(10, "Evasion Drive XIII"), DS(5, "Max GP Drive XIII")],
[DS(20, "Ranged Accuracy Boost XII"), DS(20, "Evasion Boost XII"), DS(20, "Ranged Attack Boost XII"), DS(20, "Potential Boost XII"), DS(10, "Melee Accuracy Drive XV"), DS(10, "Evasion Drive XV"), DS(5, "Max GP Drive XV")],
[DS(20, "Evasion Up III"), DS(20, "Cooldown Reducer XVI"), DS(20, "Resist Slow Arts XVI"), DS(20, "Resist Physical Res Down XVI")],
[DS(20, "Evasion Up V"), DS(20, "Cooldown Reducer XVIII"), DS(20, "Resist Slow Arts XVIII"), DS(20, "Resist Physical Res Down XVIII")],
[DS(20, "Evasion Up VII"), DS(20, "Cooldown Reducer XX"), DS(20, "Resist Slow Arts XX"), DS(20, "Resist Physical Res Down XX")],
[DS(20, "Evasion Up IX"), DS(20, "Firing Range Up II"), DS(20, "Resist Physical Res Down II"), DS(20, "Resist Beam Res Down II")],
[DS(20, "Evasion Up XII"), DS(20, "Firing Range Up V"), DS(20, "Resist Physical Res Down V"), DS(20, "Resist Beam Res Down V")],
[DS(20, "Melee Attack Boost IV"), DS(10, "Potential Drive VII"), DS(20, "Cooldown Reducer XVII"), DS(20, "Melee Accuracy Drive VII"), DS(20, "Evasion Drive VII"), DS(10, "Max TP Boost IV"), DS(10, "Melee Accuracy Drive VII"), DS(10, "Evasion Drive VII"), DS(5, "Max GP Drive VII")],
[DS(20, "Melee Attack Boost VI"), DS(10, "Potential Drive IX"), DS(20, "Cooldown Reducer XIX"), DS(20, "Melee Accuracy Drive IX"), DS(20, "Evasion Drive IX"), DS(10, "Max TP Boost VI"), DS(10, "Melee Accuracy Drive IX"), DS(10, "Evasion Drive IX"), DS(5, "Max GP Drive IX")],
[DS(20, "Melee Attack Boost VIII"), DS(10, "Potential Drive XI"), DS(20, "Firing Range Up I"), DS(20, "Melee Accuracy Drive XI"), DS(20, "Evasion Drive XI"), DS(10, "Max TP Boost VIII"), DS(10, "Melee Accuracy Drive XI"), DS(10, "Evasion Drive XI"), DS(5, "Max GP Drive XI")],
[DS(20, "Melee Attack Boost X"), DS(10, "Potential Drive XIII"), DS(20, "Firing Range Up III"), DS(20, "Melee Accuracy Drive XIII"), DS(20, "Evasion Drive XIII"), DS(10, "Max TP Boost X"), DS(10, "Melee Accuracy Drive XIII"), DS(10, "Evasion Drive XIII"), DS(5, "Max GP Drive XIII")],
[DS(20, "Melee Attack Boost XII"), DS(10, "Potential Drive XV"), DS(20, "Firing Range Up V"), DS(20, "Melee Accuracy Drive XV"), DS(20, "Evasion Drive XV"), DS(10, "Max TP Boost XII"), DS(10, "Melee Accuracy Drive XV"), DS(10, "Evasion Drive XV"), DS(5, "Max GP Drive XV")],
[DS(20, "Melee Accuracy Up III"), DS(20, "Ranged Accuracy Up III"), DS(20, "Evasion Up III"), DS(20, "Melee: Recover HP XV"), DS(20, "Resist Knockback XVI"), DS(20, "Resist Launch XVI"), DS(10, "Firing Range Up XVI")],
[DS(20, "Melee Accuracy Up V"), DS(20, "Ranged Accuracy Up V"), DS(20, "Evasion Up V"), DS(20, "Melee: Recover HP XVII"), DS(20, "Resist Knockback XVIII"), DS(20, "Resist Launch XVIII"), DS(10, "Firing Range Up XVIII")],
[DS(20, "Melee Accuracy Up VII"), DS(20, "Ranged Accuracy Up VII"), DS(20, "Evasion Up VII"), DS(20, "Melee: Recover HP XIX"), DS(20, "Resist Knockback XX"), DS(20, "Resist Launch XX"), DS(10, "Firing Range Up XX")],
[DS(20, "Melee Accuracy Up IX"), DS(20, "Ranged Accuracy Up IX"), DS(20, "Evasion Up IX"), DS(20, "Soft Touch I"), DS(20, "Resist Launch II"), DS(20, "Resist Stun II"), DS(10, "Resist Stagger II")],
[DS(20, "Melee Accuracy Up XI"), DS(20, "Ranged Accuracy Up XI"), DS(20, "Evasion Up XI"), DS(20, "Soft Touch III"), DS(20, "Resist Launch IV"), DS(20, "Resist Stun IV"), DS(10, "Resist Stagger IV")],
[DS(20, "Ranged Accuracy Boost IV"), DS(20, "Evasion Boost IV"), DS(20, "Melee Attack Boost IV"), DS(20, "Melee: Recover HP XVI"), DS(20, "Resist Knockback XVII"), DS(20, "Resist Launch XVII"), DS(10, "Firing Range Up XVII"), DS(10, "Ranged Accuracy Drive VII"), DS(5, "Max GP Drive VII")],
[DS(20, "Ranged Accuracy Boost VI"), DS(20, "Evasion Boost VI"), DS(20, "Melee Attack Boost VI"), DS(20, "Melee: Recover HP XVIII"), DS(20, "Resist Knockback XIX"), DS(20, "Resist Launch XIX"), DS(10, "Firing Range Up XIX"), DS(10, "Ranged Accuracy Drive IX"), DS(5, "Max GP Drive IX")],
[DS(20, "Ranged Accuracy Boost VIII"), DS(20, "Evasion Boost VIII"), DS(20, "Melee Attack Boost VIII"), DS(20, "Melee: Recover HP XX"), DS(20, "Resist Launch I"), DS(20, "Resist Stun I"), DS(10, "Resist Stagger I"), DS(10, "Ranged Accuracy Drive XI"), DS(5, "Max GP Drive XI")],
[DS(20, "Ranged Accuracy Boost X"), DS(20, "Evasion Boost X"), DS(20, "Melee Attack Boost X"), DS(20, "Soft Touch II"), DS(20, "Resist Launch III"), DS(20, "Resist Stun III"), DS(10, "Resist Stagger III"), DS(10, "Ranged Accuracy Drive XIII"), DS(5, "Max GP Drive XIII")],
[DS(20, "Ranged Accuracy Boost XII"), DS(20, "Evasion Boost XII"), DS(20, "Melee Attack Boost XII"), DS(20, "Soft Touch IV"), DS(20, "Resist Launch V"), DS(20, "Resist Stun V"), DS(10, "Resist Stagger V"), DS(10, "Ranged Accuracy Drive XV"), DS(5, "Max GP Drive XV")],
[DS(20, "Melee Accuracy Up III"), DS(20, "Ranged Accuracy Up III"), DS(20, "Evasion Up III"), DS(20, "Melee Attack Up III"), DS(20, "Ranged Attack Up III"), DS(20, "Melee: Recover HP XV")],
[DS(20, "Melee Accuracy Up V"), DS(20, "Ranged Accuracy Up V"), DS(20, "Evasion Up V"), DS(20, "Melee Attack Up V"), DS(20, "Ranged Attack Up V"), DS(20, "Melee: Recover HP XVII")],
[DS(20, "Melee Accuracy Up VII"), DS(20, "Ranged Accuracy Up VII"), DS(20, "Evasion Up VII"), DS(20, "Melee Attack Up VII"), DS(20, "Ranged Attack Up VII"), DS(20, "Melee: Recover HP XIX")],
[DS(20, "Melee Accuracy Up IX"), DS(20, "Ranged Accuracy Up IX"), DS(20, "Evasion Up IX"), DS(20, "Melee Attack Up IX"), DS(20, "Ranged Attack Up IX"), DS(20, "Soft Touch I")],
[DS(20, "Melee Accuracy Up XI"), DS(20, "Ranged Accuracy Up XI"), DS(20, "Evasion Up XI"), DS(20, "Melee Attack Up XI"), DS(20, "Ranged Attack Up XI"), DS(20, "Soft Touch III")],
[DS(20, "Ranged Accuracy Boost IV"), DS(20, "Evasion Boost IV"), DS(20, "Melee Attack Boost IV"), DS(20, "Ranged Attack Boost IV"), DS(20, "Potential Boost IV"), DS(20, "Melee: Recover HP XVI"), DS(10, "Max TP Boost IV"), DS(10, "Potential Drive VII"), DS(10, "Ranged Accuracy Drive VII"), DS(5, "Max GP Drive VII")],
[DS(20, "Ranged Accuracy Boost VI"), DS(20, "Evasion Boost VI"), DS(20, "Melee Attack Boost VI"), DS(20, "Ranged Attack Boost VI"), DS(20, "Potential Boost VI"), DS(20, "Melee: Recover HP XVIII"), DS(10, "Max TP Boost VI"), DS(10, "Potential Drive IX"), DS(10, "Ranged Accuracy Drive IX"), DS(5, "Max GP Drive IX")],
[DS(20, "Ranged Accuracy Boost VIII"), DS(20, "Evasion Boost VIII"), DS(20, "Melee Attack Boost VIII"), DS(20, "Ranged Attack Boost VIII"), DS(20, "Potential Boost VIII"), DS(20, "Melee: Recover HP XX"), DS(10, "Max TP Boost VIII"), DS(10, "Potential Drive XI"), DS(10, "Ranged Accuracy Drive XI"), DS(5, "Max GP Drive XI")],
[DS(20, "Ranged Accuracy Boost X"), DS(20, "Evasion Boost X"), DS(20, "Melee Attack Boost X"), DS(20, "Ranged Attack Boost X"), DS(20, "Potential Boost X"), DS(20, "Soft Touch II"), DS(10, "Max TP Boost X"), DS(10, "Potential Drive XIII"), DS(10, "Ranged Accuracy Drive XIII"), DS(5, "Max GP Drive XIII")],
[DS(20, "Ranged Accuracy Boost XII"), DS(20, "Evasion Boost XII"), DS(20, "Melee Attack Boost XII"), DS(20, "Ranged Attack Boost XII"), DS(20, "Potential Boost XII"), DS(20, "Soft Touch IV"), DS(10, "Max TP Boost XII"), DS(10, "Potential Drive XV"), DS(10, "Ranged Accuracy Drive XV"), DS(5, "Max GP Drive XV")],
[DS(20, "Melee Accuracy Up III"), DS(20, "Ranged Accuracy Up III"), DS(20, "Evasion Up III"), DS(20, "Melee Attack Up III"), DS(20, "Ranged Attack Up III"), DS(20, "Melee: Recover HP XV")],
[DS(20, "Melee Accuracy Up V"), DS(20, "Ranged Accuracy Up V"), DS(20, "Evasion Up V"), DS(20, "Melee Attack Up V"), DS(20, "Ranged Attack Up V"), DS(20, "Melee: Recover HP XVII")],
[DS(20, "Melee Accuracy Up VII"), DS(20, "Ranged Accuracy Up VII"), DS(20, "Evasion Up VII"), DS(20, "Melee Attack Up VII"), DS(20, "Ranged Attack Up VII"), DS(20, "Melee: Recover HP XIX")],
[DS(20, "Melee Accuracy Up IX"), DS(20, "Ranged Accuracy Up IX"), DS(20, "Evasion Up IX"), DS(20, "Melee Attack Up IX"), DS(20, "Ranged Attack Up IX"), DS(20, "Soft Touch I")],
[DS(20, "Melee Accuracy Up XI"), DS(20, "Ranged Accuracy Up XI"), DS(20, "Evasion Up XI"), DS(20, "Melee Attack Up XI"), DS(20, "Ranged Attack Up XI"), DS(20, "Soft Touch III")],
[DS(20, "Ranged Accuracy Boost IV"), DS(20, "Evasion Boost IV"), DS(20, "Melee Attack Boost IV"), DS(20, "Ranged Attack Boost IV"), DS(20, "Potential Boost IV"), DS(20, "Melee: Recover HP XVI"), DS(10, "Ranged Accuracy Drive VII"), DS(5, "Max GP Drive VII")],
[DS(20, "Ranged Accuracy Boost VI"), DS(20, "Evasion Boost VI"), DS(20, "Melee Attack Boost VI"), DS(20, "Ranged Attack Boost VI"), DS(20, "Potential Boost VI"), DS(20, "Melee: Recover HP XVIII"), DS(10, "Ranged Accuracy Drive IX"), DS(5, "Max GP Drive IX")],
[DS(20, "Ranged Accuracy Boost VIII"), DS(20, "Evasion Boost VIII"), DS(20, "Melee Attack Boost VIII"), DS(20, "Ranged Attack Boost VIII"), DS(20, "Potential Boost VIII"), DS(20, "Melee: Recover HP XX"), DS(10, "Ranged Accuracy Drive XI"), DS(5, "Max GP Drive XI")],
[DS(20, "Ranged Accuracy Boost X"), DS(20, "Evasion Boost X"), DS(20, "Melee Attack Boost X"), DS(20, "Ranged Attack Boost X"), DS(20, "Potential Boost X"), DS(20, "Soft Touch II"), DS(10, "Ranged Accuracy Drive XIII"), DS(5, "Max GP Drive XIII")],
[DS(20, "Ranged Accuracy Boost XII"), DS(20, "Evasion Boost XII"), DS(20, "Melee Attack Boost XII"), DS(20, "Ranged Attack Boost XII"), DS(20, "Potential Boost XII"), DS(20, "Soft Touch IV"), DS(10, "Ranged Accuracy Drive XV"), DS(5, "Max GP Drive XV")],
[DS(20, "Evasion Up III"), DS(10, "Resist Stagger XVI"), DS(20, "Resist Beam Res Down XVI")],
[DS(20, "Evasion Up V"), DS(10, "Resist Stagger XVIII"), DS(20, "Resist Beam Res Down XVIII")],
[DS(20, "Evasion Up VII"), DS(10, "Resist Stagger XX"), DS(20, "Resist Beam Res Down XX")],
[DS(20, "Evasion Up IX"), DS(10, "Resist Flinch II"), DS(20, "Resist Thermal Res Down II")],
[DS(20, "Evasion Up XI"), DS(10, "Resist Flinch IV"), DS(20, "Resist Thermal Res Down IV")],
[DS(20, "Melee Attack Boost IV"), DS(10, "Resist Stagger XVII"), DS(20, "Resist Beam Res Down XVII"), DS(10, "Max TP Boost IV"), DS(10, "Potential Drive VII"), DS(10, "Ranged Accuracy Drive VII"), DS(5, "Max GP Drive VII")],
[DS(20, "Melee Attack Boost VI"), DS(10, "Resist Stagger XIX"), DS(20, "Resist Beam Res Down XIX"), DS(10, "Max TP Boost VI"), DS(10, "Potential Drive IX"), DS(10, "Ranged Accuracy Drive IX"), DS(5, "Max GP Drive IX")],
[DS(20, "Melee Attack Boost VIII"), DS(10, "Resist Flinch I"), DS(20, "Resist Thermal Res Down I"), DS(10, "Max TP Boost VIII"), DS(10, "Potential Drive XI"), DS(10, "Ranged Accuracy Drive XI"), DS(5, "Max GP Drive XI")],
[DS(20, "Melee Attack Boost X"), DS(10, "Resist Flinch III"), DS(20, "Resist Thermal Res Down III"), DS(10, "Max TP Boost X"), DS(10, "Potential Drive XIII"), DS(10, "Ranged Accuracy Drive XIII"), DS(5, "Max GP Drive XIII")],
[DS(20, "Melee Attack Boost XII"), DS(10, "Resist Flinch V"), DS(20, "Resist Thermal Res Down V"), DS(10, "Max TP Boost XII"), DS(10, "Potential Drive XV"), DS(10, "Ranged Accuracy Drive XV"), DS(5, "Max GP Drive XV")],
[DS(20, "Melee Accuracy Up III"), DS(20, "Ranged Accuracy Up III"), DS(20, "Evasion Up III")],
[DS(20, "Melee Accuracy Up V"), DS(20, "Ranged Accuracy Up V"), DS(20, "Evasion Up V")],
[DS(20, "Melee Accuracy Up VII"), DS(20, "Ranged Accuracy Up VII"), DS(20, "Evasion Up VII")],
[DS(20, "Melee Accuracy Up IX"), DS(20, "Ranged Accuracy Up IX"), DS(20, "Evasion Up IX")],
[DS(20, "Melee Accuracy Up XI"), DS(20, "Ranged Accuracy Up XI"), DS(20, "Evasion Up XI")],
[DS(20, "Ranged Accuracy Boost IV"), DS(20, "Evasion Boost IV"), DS(20, "Melee Attack Boost IV"), DS(10, "Melee Accuracy Drive VII"), DS(10, "Evasion Drive VII"), DS(5, "Max GP Drive VII")],
[DS(20, "Ranged Accuracy Boost VI"), DS(20, "Evasion Boost VI"), DS(20, "Melee Attack Boost VI"), DS(10, "Melee Accuracy Drive IX"), DS(10, "Evasion Drive IX"), DS(5, "Max GP Drive IX")],
[DS(20, "Ranged Accuracy Boost VIII"), DS(20, "Evasion Boost VIII"), DS(20, "Melee Attack Boost VIII"), DS(10, "Melee Accuracy Drive XI"), DS(10, "Evasion Drive XI"), DS(5, "Max GP Drive XI")],
[DS(20, "Ranged Accuracy Boost X"), DS(20, "Evasion Boost X"), DS(20, "Melee Attack Boost X"), DS(10, "Melee Accuracy Drive XIII"), DS(10, "Evasion Drive XIII"), DS(5, "Max GP Drive XIII")],
[DS(20, "Ranged Accuracy Boost XII"), DS(20, "Evasion Boost XII"), DS(20, "Melee Attack Boost XII"), DS(10, "Melee Accuracy Drive XV"), DS(10, "Evasion Drive XV"), DS(5, "Max GP Drive XV")],
[DS(20, "Melee Accuracy Up III"), DS(20, "Ranged Accuracy Up III"), DS(20, "Evasion Up III"), DS(20, "Melee Attack Up III"), DS(20, "Ranged Attack Up III")],
[DS(20, "Melee Accuracy Up V"), DS(20, "Ranged Accuracy Up V"), DS(20, "Evasion Up V"), DS(20, "Melee Attack Up V"), DS(20, "Ranged Attack Up V")],
[DS(20, "Melee Accuracy Up VII"), DS(20, "Ranged Accuracy Up VII"), DS(20, "Evasion Up VII"), DS(20, "Melee Attack Up VII"), DS(20, "Ranged Attack Up VII")],
[DS(20, "Melee Accuracy Up IX"), DS(20, "Ranged Accuracy Up IX"), DS(20, "Evasion Up IX"), DS(20, "Melee Attack Up IX"), DS(20, "Ranged Attack Up IX")],
[DS(20, "Melee Accuracy Up XI"), DS(20, "Ranged Accuracy Up XI"), DS(20, "Evasion Up XI"), DS(20, "Melee Attack Up XI"), DS(20, "Ranged Attack Up XI")],
[DS(20, "Ranged Accuracy Boost IV"), DS(20, "Evasion Boost IV"), DS(20, "Melee Attack Boost IV"), DS(20, "Ranged Attack Boost IV"), DS(20, "Potential Boost IV"), DS(10, "Max TP Boost IV"), DS(10, "Melee Accuracy Drive VII"), DS(10, "Evasion Drive VII"), DS(5, "Max GP Drive VII")],
[DS(20, "Ranged Accuracy Boost VI"), DS(20, "Evasion Boost VI"), DS(20, "Melee Attack Boost VI"), DS(20, "Ranged Attack Boost VI"), DS(20, "Potential Boost VI"), DS(10, "Max TP Boost VI"), DS(10, "Melee Accuracy Drive IX"), DS(10, "Evasion Drive IX"), DS(5, "Max GP Drive IX")],
[DS(20, "Ranged Accuracy Boost VIII"), DS(20, "Evasion Boost VIII"), DS(20, "Melee Attack Boost VIII"), DS(20, "Ranged Attack Boost VIII"), DS(20, "Potential Boost VIII"), DS(10, "Max TP Boost VIII"), DS(10, "Melee Accuracy Drive XI"), DS(10, "Evasion Drive XI"), DS(5, "Max GP Drive XI")],
[DS(20, "Ranged Accuracy Boost X"), DS(20, "Evasion Boost X"), DS(20, "Melee Attack Boost X"), DS(20, "Ranged Attack Boost X"), DS(20, "Potential Boost X"), DS(10, "Max TP Boost X"), DS(10, "Melee Accuracy Drive XIII"), DS(10, "Evasion Drive XIII"), DS(5, "Max GP Drive XIII")],
[DS(20, "Ranged Accuracy Boost XII"), DS(20, "Evasion Boost XII"), DS(20, "Melee Attack Boost XII"), DS(20, "Ranged Attack Boost XII"), DS(20, "Potential Boost XII"), DS(10, "Max TP Boost XII"), DS(10, "Melee Accuracy Drive XV"), DS(10, "Evasion Drive XV"), DS(5, "Max GP Drive XV")],
[DS(20, "Melee Accuracy Up III"), DS(20, "Ranged Accuracy Up III"), DS(20, "Melee Attack Up III"), DS(20, "Ranged Attack Up III")],
[DS(20, "Melee Accuracy Up V"), DS(20, "Ranged Accuracy Up V"), DS(20, "Melee Attack Up V"), DS(20, "Ranged Attack Up V")],
[DS(20, "Melee Accuracy Up VII"), DS(20, "Ranged Accuracy Up VII"), DS(20, "Melee Attack Up VII"), DS(20, "Ranged Attack Up VII")],
[DS(20, "Melee Accuracy Up IX"), DS(20, "Ranged Accuracy Up IX"), DS(20, "Melee Attack Up IX"), DS(20, "Ranged Attack Up IX")],
[DS(20, "Melee Accuracy Up XI"), DS(20, "Ranged Accuracy Up XI"), DS(20, "Melee Attack Up XI"), DS(20, "Ranged Attack Up XI")],
[DS(20, "Ranged Accuracy Boost IV"), DS(20, "Evasion Boost IV"), DS(20, "Ranged Attack Boost IV"), DS(20, "Potential Boost IV"), DS(10, "Melee Accuracy Drive VII"), DS(10, "Evasion Drive VII"), DS(5, "Max GP Drive VII")],
[DS(20, "Ranged Accuracy Boost VI"), DS(20, "Evasion Boost VI"), DS(20, "Ranged Attack Boost VI"), DS(20, "Potential Boost VI"), DS(10, "Melee Accuracy Drive IX"), DS(10, "Evasion Drive IX"), DS(5, "Max GP Drive IX")],
[DS(20, "Ranged Accuracy Boost VIII"), DS(20, "Evasion Boost VIII"), DS(20, "Ranged Attack Boost VIII"), DS(20, "Potential Boost VIII"), DS(10, "Melee Accuracy Drive XI"), DS(10, "Evasion Drive XI"), DS(5, "Max GP Drive XI")],
[DS(20, "Ranged Accuracy Boost X"), DS(20, "Evasion Boost X"), DS(20, "Ranged Attack Boost X"), DS(20, "Potential Boost X"), DS(10, "Melee Accuracy Drive XIII"), DS(10, "Evasion Drive XIII"), DS(5, "Max GP Drive XIII")],
[DS(20, "Ranged Accuracy Boost XII"), DS(20, "Evasion Boost XII"), DS(20, "Ranged Attack Boost XII"), DS(20, "Potential Boost XII"), DS(10, "Melee Accuracy Drive XV"), DS(10, "Evasion Drive XV"), DS(5, "Max GP Drive XV")],
[DS(20, "Evasion Up III"), DS(20, "Cooldown Reducer XVI"), DS(10, "Resist Flinch XVI")],
[DS(20, "Evasion Up V"), DS(20, "Cooldown Reducer XVIII"), DS(10, "Resist Flinch XVIII")],
[DS(20, "Evasion Up VII"), DS(20, "Cooldown Reducer XX"), DS(10, "Resist Flinch XX")],
[DS(20, "Evasion Up IX"), DS(20, "Firing Range Up II"), DS(10, "Resist Topple II")],
[DS(20, "Evasion Up XI"), DS(20, "Firing Range Up IV"), DS(10, "Resist Topple IV")],
[DS(20, "Melee Attack Boost IV"), DS(20, "Cooldown Reducer XVII"), DS(10, "Resist Flinch XVII"), DS(10, "Melee Accuracy Drive VII"), DS(10, "Evasion Drive VII"), DS(5, "Max GP Drive VII")],
[DS(20, "Melee Attack Boost VI"), DS(20, "Cooldown Reducer XIX"), DS(10, "Resist Flinch XIX"), DS(10, "Melee Accuracy Drive IX"), DS(10, "Evasion Drive IX"), DS(5, "Max GP Drive IX")],
[DS(20, "Melee Attack Boost VIII"), DS(20, "Firing Range Up I"), DS(10, "Resist Topple I"), DS(10, "Melee Accuracy Drive XI"), DS(10, "Evasion Drive XI"), DS(5, "Max GP Drive XI")],
[DS(20, "Melee Attack Boost X"), DS(20, "Firing Range Up III"), DS(10, "Resist Topple III"), DS(10, "Melee Accuracy Drive XIII"), DS(10, "Evasion Drive XIII"), DS(5, "Max GP Drive XIII")],
[DS(20, "Melee Attack Boost XII"), DS(20, "Firing Range Up V"), DS(10, "Resist Topple V"), DS(10, "Melee Accuracy Drive XV"), DS(10, "Evasion Drive XV"), DS(5, "Max GP Drive XV")],
[DS(20, "Max HP Up III"), DS(20, "Max HP Boost III"), DS(20, "Melee: Recover HP XV"), DS(20, "Resist Debuff Res Down XVI"), DS(20, "Resist HP Recovery Down XVI"), DS(10, "Firing Range Up XVI")],
[DS(20, "Max HP Up V"), DS(20, "Max HP Boost V"), DS(20, "Melee: Recover HP XVII"), DS(20, "Resist Debuff Res Down XVIII"), DS(20, "Resist HP Recovery Down XVIII"), DS(10, "Firing Range Up XVIII")],
[DS(20, "Max HP Up VII"), DS(20, "Max HP Boost VII"), DS(20, "Melee: Recover HP XIX"), DS(20, "Resist Debuff Res Down XX"), DS(20, "Resist HP Recovery Down XX"), DS(10, "Firing Range Up XX")],
[DS(20, "Max HP Up IX"), DS(20, "Max HP Boost IX"), DS(20, "Soft Touch I"), DS(20, "Resist HP Recovery Down II"), DS(20, "Resist Blaze II"), DS(10, "Resist Stagger II")],
[DS(20, "Max HP Up XI"), DS(20, "Max HP Boost XI"), DS(20, "Soft Touch III"), DS(20, "Resist HP Recovery Down IV"), DS(20, "Resist Blaze IV"), DS(10, "Resist Stagger IV")],
[DS(20, "Max TP Boost IV"), DS(20, "Max HP Boost IV"), DS(20, "Melee: Recover HP XVI"), DS(10, "Soft Touch XVI"), DS(10, "ITM_SKL_IN_FST_DARM14_name"), DS(10, "Melee Accuracy Drive VII"), DS(10, "Evasion Drive VII"), DS(10, "Ranged Accuracy Drive VII"), DS(5, "Max GP Drive VII")],
[DS(20, "Max TP Boost VI"), DS(20, "Max HP Boost VI"), DS(20, "Melee: Recover HP XVIII"), DS(10, "Soft Touch XVIII"), DS(10, "ITM_SKL_IN_FST_DARM16_name"), DS(10, "Melee Accuracy Drive IX"), DS(10, "Evasion Drive IX"), DS(10, "Ranged Accuracy Drive IX"), DS(5, "Max GP Drive IX")],
[DS(20, "Max TP Boost VIII"), DS(20, "Max HP Boost VIII"), DS(20, "Melee: Recover HP XX"), DS(10, "Soft Touch XX"), DS(10, "ITM_SKL_IN_FST_DARM18_name"), DS(10, "Melee Accuracy Drive XI"), DS(10, "Evasion Drive XI"), DS(10, "Ranged Accuracy Drive XI"), DS(5, "Max GP Drive XI")],
[DS(20, "Max TP Boost X"), DS(20, "Max HP Boost X"), DS(20, "Soft Touch II"), DS(10, "HP Rebound II"), DS(10, "ITM_SKL_IN_FST_DARM20_name"), DS(10, "Melee Accuracy Drive XIII"), DS(10, "Evasion Drive XIII"), DS(10, "Ranged Accuracy Drive XIII"), DS(5, "Max GP Drive XIII")],
[DS(20, "Max TP Boost XII"), DS(20, "Max HP Boost XII"), DS(20, "Soft Touch IV"), DS(10, "HP Rebound IV"), DS(10, "ITM_SKL_IN_FST_BULLET02_name"), DS(10, "Melee Accuracy Drive XV"), DS(10, "Evasion Drive XV"), DS(10, "Ranged Accuracy Drive XV"), DS(5, "Max GP Drive XV")],
[DS(20, "Max HP Up III"), DS(20, "Max HP Boost III"), DS(20, "Melee: Recover HP XV"), DS(20, "Resist Debuff Res Down XVI"), DS(20, "Resist HP Recovery Down XVI")],
[DS(20, "Max HP Up V"), DS(20, "Max HP Boost V"), DS(20, "Melee: Recover HP XVII"), DS(20, "Resist Debuff Res Down XVIII"), DS(20, "Resist HP Recovery Down XVIII")],
[DS(20, "Max HP Up VII"), DS(20, "Max HP Boost VII"), DS(20, "Melee: Recover HP XIX"), DS(20, "Resist Debuff Res Down XX"), DS(20, "Resist HP Recovery Down XX")],
[DS(20, "Max HP Up IX"), DS(20, "Max HP Boost IX"), DS(20, "Soft Touch I"), DS(20, "Resist HP Recovery Down II"), DS(20, "Resist Blaze II")],
[DS(20, "Max HP Up XI"), DS(20, "Max HP Boost XI"), DS(20, "Soft Touch III"), DS(20, "Resist HP Recovery Down IV"), DS(20, "Resist Blaze IV")],
[DS(20, "Max TP Boost IV"), DS(20, "Max HP Boost IV"), DS(20, "Melee: Recover HP XVI"), DS(10, "Potential Drive VII"), DS(10, "Fuel Efficiency Up VII"), DS(10, "Soft Touch XVI"), DS(10, "Melee Accuracy Drive VII"), DS(10, "Evasion Drive VII"), DS(10, "Ranged Accuracy Drive VII"), DS(5, "Max GP Drive VII")],
[DS(20, "Max TP Boost VI"), DS(20, "Max HP Boost VI"), DS(20, "Melee: Recover HP XVIII"), DS(10, "Potential Drive IX"), DS(10, "Fuel Efficiency Up IX"), DS(10, "Soft Touch XVIII"), DS(10, "Melee Accuracy Drive IX"), DS(10, "Evasion Drive IX"), DS(10, "Ranged Accuracy Drive IX"), DS(5, "Max GP Drive IX")],
[DS(20, "Max TP Boost VIII"), DS(20, "Max HP Boost VIII"), DS(20, "Melee: Recover HP XX"), DS(10, "Potential Drive XI"), DS(10, "Fuel Efficiency Up XI"), DS(10, "Soft Touch XX"), DS(10, "Melee Accuracy Drive XI"), DS(10, "Evasion Drive XI"), DS(10, "Ranged Accuracy Drive XI"), DS(5, "Max GP Drive XI")],
[DS(20, "Max TP Boost X"), DS(20, "Max HP Boost X"), DS(20, "Soft Touch II"), DS(10, "Potential Drive XIII"), DS(10, "Fuel Efficiency Up XIII"), DS(10, "HP Rebound II"), DS(10, "Melee Accuracy Drive XIII"), DS(10, "Evasion Drive XIII"), DS(10, "Ranged Accuracy Drive XIII"), DS(5, "Max GP Drive XIII")],
[DS(20, "Max TP Boost XII"), DS(20, "Max HP Boost XII"), DS(20, "Soft Touch IV"), DS(10, "Potential Drive XV"), DS(10, "Fuel Efficiency Up XV"), DS(10, "HP Rebound IV"), DS(10, "Melee Accuracy Drive XV"), DS(10, "Evasion Drive XV"), DS(10, "Ranged Accuracy Drive XV"), DS(5, "Max GP Drive XV")],
[DS(20, "Max HP Up III"), DS(20, "Max HP Boost III"), DS(20, "Melee: Recover HP XV"), DS(20, "Resist Debuff Res Down XVI"), DS(20, "Resist HP Recovery Down XVI")],
[DS(20, "Max HP Up V"), DS(20, "Max HP Boost V"), DS(20, "Melee: Recover HP XVII"), DS(20, "Resist Debuff Res Down XVIII"), DS(20, "Resist HP Recovery Down XVIII")],
[DS(20, "Max HP Up VII"), DS(20, "Max HP Boost VII"), DS(20, "Melee: Recover HP XIX"), DS(20, "Resist Debuff Res Down XX"), DS(20, "Resist HP Recovery Down XX")],
[DS(20, "Max HP Up IX"), DS(20, "Max HP Boost IX"), DS(20, "Soft Touch I"), DS(20, "Resist HP Recovery Down II"), DS(20, "Resist Blaze II")],
[DS(20, "Max HP Up XI"), DS(20, "Max HP Boost XI"), DS(20, "Soft Touch III"), DS(20, "Resist HP Recovery Down IV"), DS(20, "Resist Blaze IV")],
[DS(20, "Max TP Boost IV"), DS(20, "Max HP Boost IV"), DS(20, "Melee: Recover HP XVI"), DS(10, "ITM_SKL_IN_FST_SDEX14_name"), DS(10, "Melee Accuracy Drive VII"), DS(10, "Evasion Drive VII"), DS(10, "Ranged Accuracy Drive VII"), DS(5, "Max GP Drive VII")],
[DS(20, "Max TP Boost VI"), DS(20, "Max HP Boost VI"), DS(20, "Melee: Recover HP XVIII"), DS(10, "ITM_SKL_IN_FST_SDEX16_name"), DS(10, "Melee Accuracy Drive IX"), DS(10, "Evasion Drive IX"), DS(10, "Ranged Accuracy Drive IX"), DS(5, "Max GP Drive IX")],
[DS(20, "Max TP Boost VIII"), DS(20, "Max HP Boost VIII"), DS(20, "Melee: Recover HP XX"), DS(10, "ITM_SKL_IN_FST_SDEX18_name"), DS(10, "Melee Accuracy Drive XI"), DS(10, "Evasion Drive XI"), DS(10, "Ranged Accuracy Drive XI"), DS(5, "Max GP Drive XI")],
[DS(20, "Max TP Boost X"), DS(20, "Max HP Boost X"), DS(20, "Soft Touch II"), DS(10, "ITM_SKL_IN_FST_SDEX20_name"), DS(10, "Melee Accuracy Drive XIII"), DS(10, "Evasion Drive XIII"), DS(10, "Ranged Accuracy Drive XIII"), DS(5, "Max GP Drive XIII")],
[DS(20, "Max TP Boost XII"), DS(20, "Max HP Boost XII"), DS(20, "Soft Touch IV"), DS(10, "ITM_SKL_IN_FST_EVA02_name"), DS(10, "Melee Accuracy Drive XV"), DS(10, "Evasion Drive XV"), DS(10, "Ranged Accuracy Drive XV"), DS(5, "Max GP Drive XV")],
[DS(20, "Max HP Up III"), DS(20, "Max HP Boost III"), DS(20, "Melee: Recover HP XV"), DS(20, "Resist Debuff Res Down XVI"), DS(20, "Resist HP Recovery Down XVI")],
[DS(20, "Max HP Up V"), DS(20, "Max HP Boost V"), DS(20, "Melee: Recover HP XVII"), DS(20, "Resist Debuff Res Down XVIII"), DS(20, "Resist HP Recovery Down XVIII")],
[DS(20, "Max HP Up VII"), DS(20, "Max HP Boost VII"), DS(20, "Melee: Recover HP XIX"), DS(20, "Resist Debuff Res Down XX"), DS(20, "Resist HP Recovery Down XX")],
[DS(20, "Max HP Up IX"), DS(20, "Max HP Boost IX"), DS(20, "Soft Touch I"), DS(20, "Resist HP Recovery Down II"), DS(20, "Resist Blaze II")],
[DS(20, "Max HP Up XI"), DS(20, "Max HP Boost XI"), DS(20, "Soft Touch III"), DS(20, "Resist HP Recovery Down IV"), DS(20, "Resist Blaze IV")],
[DS(20, "Max TP Boost IV"), DS(20, "Max HP Boost IV"), DS(20, "Melee: Recover HP XVI"), DS(10, "Potential Drive VII"), DS(10, "Fuel Efficiency Up VII"), DS(10, "Melee Accuracy Drive VII"), DS(10, "Evasion Drive VII"), DS(10, "Ranged Accuracy Drive VII"), DS(5, "Max GP Drive VII")],
[DS(20, "Max TP Boost VI"), DS(20, "Max HP Boost VI"), DS(20, "Melee: Recover HP XVIII"), DS(10, "Potential Drive IX"), DS(10, "Fuel Efficiency Up IX"), DS(10, "Melee Accuracy Drive IX"), DS(10, "Evasion Drive IX"), DS(10, "Ranged Accuracy Drive IX"), DS(5, "Max GP Drive IX")],
[DS(20, "Max TP Boost VIII"), DS(20, "Max HP Boost VIII"), DS(20, "Melee: Recover HP XX"), DS(10, "Potential Drive XI"), DS(10, "Fuel Efficiency Up XI"), DS(10, "Melee Accuracy Drive XI"), DS(10, "Evasion Drive XI"), DS(10, "Ranged Accuracy Drive XI"), DS(5, "Max GP Drive XI")],
[DS(20, "Max TP Boost X"), DS(20, "Max HP Boost X"), DS(20, "Soft Touch II"), DS(10, "Potential Drive XIII"), DS(10, "Fuel Efficiency Up XIII"), DS(10, "Melee Accuracy Drive XIII"), DS(10, "Evasion Drive XIII"), DS(10, "Ranged Accuracy Drive XIII"), DS(5, "Max GP Drive XIII")],
[DS(20, "Max TP Boost XII"), DS(20, "Max HP Boost XII"), DS(20, "Soft Touch IV"), DS(10, "Potential Drive XV"), DS(10, "Fuel Efficiency Up XV"), DS(10, "Melee Accuracy Drive XV"), DS(10, "Evasion Drive XV"), DS(10, "Ranged Accuracy Drive XV"), DS(5, "Max GP Drive XV")],
[DS(20, "Melee Accuracy Up III"), DS(20, "Ranged Accuracy Up III"), DS(20, "Evasion Up III"), DS(10, "Firing Range Up XVI"), DS(20, "Resist Control XVI")],
[DS(20, "Melee Accuracy Up V"), DS(20, "Ranged Accuracy Up V"), DS(20, "Evasion Up V"), DS(10, "Firing Range Up XVIII"), DS(20, "Resist Control XVIII")],
[DS(20, "Melee Accuracy Up VII"), DS(20, "Ranged Accuracy Up VII"), DS(20, "Evasion Up VII"), DS(10, "Firing Range Up XX"), DS(20, "Resist Control XX")],
[DS(20, "Melee Accuracy Up IX"), DS(20, "Ranged Accuracy Up IX"), DS(20, "Evasion Up IX"), DS(10, "Resist Stagger II"), DS(20, "Resist Virus II")],
[DS(20, "Melee Accuracy Up XI"), DS(20, "Ranged Accuracy Up XI"), DS(20, "Evasion Up XI"), DS(10, "Resist Stagger IV"), DS(20, "Resist Virus IV")],
[DS(20, "Ranged Accuracy Boost IV"), DS(20, "Evasion Boost IV"), DS(20, "Melee Attack Boost IV"), DS(10, "Firing Range Up XVII"), DS(20, "Resist Control XVII"), DS(10, "Melee Accuracy Drive VII"), DS(10, "Evasion Drive VII"), DS(10, "Ranged Accuracy Drive VII"), DS(5, "Max GP Drive VII")],
[DS(20, "Ranged Accuracy Boost VI"), DS(20, "Evasion Boost VI"), DS(20, "Melee Attack Boost VI"), DS(10, "Firing Range Up XIX"), DS(20, "Resist Control XIX"), DS(10, "Melee Accuracy Drive IX"), DS(10, "Evasion Drive IX"), DS(10, "Ranged Accuracy Drive IX"), DS(5, "Max GP Drive IX")],
[DS(20, "Ranged Accuracy Boost VIII"), DS(20, "Evasion Boost VIII"), DS(20, "Melee Attack Boost VIII"), DS(10, "Resist Stagger I"), DS(20, "Resist Virus I"), DS(10, "Melee Accuracy Drive XI"), DS(10, "Evasion Drive XI"), DS(10, "Ranged Accuracy Drive XI"), DS(5, "Max GP Drive XI")],
[DS(20, "Ranged Accuracy Boost X"), DS(20, "Evasion Boost X"), DS(20, "Melee Attack Boost X"), DS(10, "Resist Stagger III"), DS(20, "Resist Virus III"), DS(10, "Melee Accuracy Drive XIII"), DS(10, "Evasion Drive XIII"), DS(10, "Ranged Accuracy Drive XIII"), DS(5, "Max GP Drive XIII")],
[DS(20, "Ranged Accuracy Boost XII"), DS(20, "Evasion Boost XII"), DS(20, "Melee Attack Boost XII"), DS(10, "Resist Stagger V"), DS(20, "Resist Virus V"), DS(10, "Melee Accuracy Drive XV"), DS(10, "Evasion Drive XV"), DS(10, "Ranged Accuracy Drive XV"), DS(5, "Max GP Drive XV")],
[DS(20, "Melee Accuracy Up III"), DS(20, "Ranged Accuracy Up III"), DS(20, "Evasion Up III"), DS(20, "Melee Attack Up III")],
[DS(20, "Melee Accuracy Up V"), DS(20, "Ranged Accuracy Up V"), DS(20, "Evasion Up V"), DS(20, "Melee Attack Up V")],
[DS(20, "Melee Accuracy Up VII"), DS(20, "Ranged Accuracy Up VII"), DS(20, "Evasion Up VII"), DS(20, "Melee Attack Up VII")],
[DS(20, "Melee Accuracy Up IX"), DS(20, "Ranged Accuracy Up IX"), DS(20, "Evasion Up IX"), DS(20, "Melee Attack Up IX")],
[DS(20, "Melee Accuracy Up XI"), DS(20, "Ranged Accuracy Up XI"), DS(20, "Evasion Up XI"), DS(20, "Melee Attack Up XI")],
[DS(20, "Ranged Accuracy Boost IV"), DS(20, "Evasion Boost IV"), DS(20, "Melee Attack Boost IV"), DS(20, "Ranged Attack Boost IV"), DS(10, "Potential Drive VII"), DS(10, "Melee Accuracy Drive VII"), DS(10, "Evasion Drive VII"), DS(10, "Ranged Accuracy Drive VII"), DS(5, "Max GP Drive VII")],
[DS(20, "Ranged Accuracy Boost VI"), DS(20, "Evasion Boost VI"), DS(20, "Melee Attack Boost VI"), DS(20, "Ranged Attack Boost VI"), DS(10, "Potential Drive IX"), DS(10, "Melee Accuracy Drive IX"), DS(10, "Evasion Drive IX"), DS(10, "Ranged Accuracy Drive IX"), DS(5, "Max GP Drive IX")],
[DS(20, "Ranged Accuracy Boost VIII"), DS(20, "Evasion Boost VIII"), DS(20, "Melee Attack Boost VIII"), DS(20, "Ranged Attack Boost VIII"), DS(10, "Potential Drive XI"), DS(10, "Melee Accuracy Drive XI"), DS(10, "Evasion Drive XI"), DS(10, "Ranged Accuracy Drive XI"), DS(5, "Max GP Drive XI")],
[DS(20, "Ranged Accuracy Boost X"), DS(20, "Evasion Boost X"), DS(20, "Melee Attack Boost X"), DS(20, "Ranged Attack Boost X"), DS(10, "Potential Drive XIII"), DS(10, "Melee Accuracy Drive XIII"), DS(10, "Evasion Drive XIII"), DS(10, "Ranged Accuracy Drive XIII"), DS(5, "Max GP Drive XIII")],
[DS(20, "Ranged Accuracy Boost XII"), DS(20, "Evasion Boost XII"), DS(20, "Melee Attack Boost XII"), DS(20, "Ranged Attack Boost XII"), DS(10, "Potential Drive XV"), DS(10, "Melee Accuracy Drive XV"), DS(10, "Evasion Drive XV"), DS(10, "Ranged Accuracy Drive XV"), DS(5, "Max GP Drive XV")],
[DS(20, "Melee Accuracy Up III"), DS(20, "Ranged Accuracy Up III"), DS(20, "Melee Attack Up III"), DS(20, "Ranged Attack Up III"), DS(20, "Resist Virus XVI")],
[DS(20, "Melee Accuracy Up V"), DS(20, "Ranged Accuracy Up V"), DS(20, "Melee Attack Up V"), DS(20, "Ranged Attack Up V"), DS(20, "Resist Virus XVIII")],
[DS(20, "Melee Accuracy Up VII"), DS(20, "Ranged Accuracy Up VII"), DS(20, "Melee Attack Up VII"), DS(20, "Ranged Attack Up VII"), DS(20, "Resist Virus XX")],
[DS(20, "Melee Accuracy Up IX"), DS(20, "Ranged Accuracy Up IX"), DS(20, "Melee Attack Up IX"), DS(20, "Ranged Attack Up IX"), DS(20, "Resist Blackout II")],
[DS(20, "Melee Accuracy Up XI"), DS(20, "Ranged Accuracy Up XI"), DS(20, "Melee Attack Up XI"), DS(20, "Ranged Attack Up XI"), DS(20, "Resist Blackout IV")],
[DS(20, "Ranged Accuracy Boost IV"), DS(20, "Evasion Boost IV"), DS(20, "Ranged Attack Boost IV"), DS(20, "Potential Boost IV"), DS(10, "Physical Resistance Up VII"), DS(10, "Melee Accuracy Drive VII"), DS(10, "Evasion Drive VII"), DS(10, "Ranged Accuracy Drive VII"), DS(5, "Max GP Drive VII")],
[DS(20, "Ranged Accuracy Boost VI"), DS(20, "Evasion Boost VI"), DS(20, "Ranged Attack Boost VI"), DS(20, "Potential Boost VI"), DS(10, "Physical Resistance Up IX"), DS(10, "Melee Accuracy Drive IX"), DS(10, "Evasion Drive IX"), DS(10, "Ranged Accuracy Drive IX"), DS(5, "Max GP Drive IX")],
[DS(20, "Ranged Accuracy Boost VIII"), DS(20, "Evasion Boost VIII"), DS(20, "Ranged Attack Boost VIII"), DS(20, "Potential Boost VIII"), DS(10, "Physical Resistance Up XI"), DS(10, "Melee Accuracy Drive XI"), DS(10, "Evasion Drive XI"), DS(10, "Ranged Accuracy Drive XI"), DS(5, "Max GP Drive XI")],
[DS(20, "Ranged Accuracy Boost X"), DS(20, "Evasion Boost X"), DS(20, "Ranged Attack Boost X"), DS(20, "Potential Boost X"), DS(10, "Physical Resistance Up XIII"), DS(10, "Melee Accuracy Drive XIII"), DS(10, "Evasion Drive XIII"), DS(10, "Ranged Accuracy Drive XIII"), DS(5, "Max GP Drive XIII")],
[DS(20, "Ranged Accuracy Boost XII"), DS(20, "Evasion Boost XII"), DS(20, "Ranged Attack Boost XII"), DS(20, "Potential Boost XII"), DS(10, "Physical Resistance Up XV"), DS(10, "Melee Accuracy Drive XV"), DS(10, "Evasion Drive XV"), DS(10, "Ranged Accuracy Drive XV"), DS(5, "Max GP Drive XV")],
[DS(20, "Evasion Up III"), DS(10, "Resist Stagger XVI"), DS(10, "Resist Flinch XVI"), DS(10, "Resist Topple XVI")],
[DS(20, "Evasion Up V"), DS(10, "Resist Stagger XVIII"), DS(10, "Resist Flinch XVIII"), DS(10, "Resist Topple XVIII")],
[DS(20, "Evasion Up VII"), DS(10, "Resist Stagger XX"), DS(10, "Resist Flinch XX"), DS(10, "Resist Topple XX")],
[DS(20, "Evasion Up IX"), DS(10, "Resist Flinch II"), DS(10, "Resist Topple II"), DS(10, "Resist Knockback II")],
[DS(20, "Evasion Up XI"), DS(10, "Resist Flinch IV"), DS(10, "Resist Topple IV"), DS(10, "Resist Knockback IV")],
[DS(20, "Melee Attack Boost IV"), DS(10, "Resist Stagger XVII"), DS(10, "Resist Flinch XVII"), DS(10, "Resist Topple XVII"), DS(10, "Potential Drive VII"), DS(10, "Melee Accuracy Drive VII"), DS(10, "Evasion Drive VII"), DS(10, "Ranged Accuracy Drive VII"), DS(5, "Max GP Drive VII")],
[DS(20, "Melee Attack Boost VI"), DS(10, "Resist Stagger XIX"), DS(10, "Resist Flinch XIX"), DS(10, "Resist Topple XIX"), DS(10, "Potential Drive IX"), DS(10, "Melee Accuracy Drive IX"), DS(10, "Evasion Drive IX"), DS(10, "Ranged Accuracy Drive IX"), DS(5, "Max GP Drive IX")],
[DS(20, "Melee Attack Boost VIII"), DS(10, "Resist Flinch I"), DS(10, "Resist Topple I"), DS(10, "Resist Knockback I"), DS(10, "Potential Drive XI"), DS(10, "Melee Accuracy Drive XI"), DS(10, "Evasion Drive XI"), DS(10, "Ranged Accuracy Drive XI"), DS(5, "Max GP Drive XI")],
[DS(20, "Melee Attack Boost X"), DS(10, "Resist Flinch III"), DS(10, "Resist Topple III"), DS(10, "Resist Knockback III"), DS(10, "Potential Drive XIII"), DS(10, "Melee Accuracy Drive XIII"), DS(10, "Evasion Drive XIII"), DS(10, "Ranged Accuracy Drive XIII"), DS(5, "Max GP Drive XIII")],
[DS(20, "Melee Attack Boost XII"), DS(10, "Resist Flinch V"), DS(10, "Resist Topple V"), DS(10, "Resist Knockback V"), DS(10, "Potential Drive XV"), DS(10, "Melee Accuracy Drive XV"), DS(10, "Evasion Drive XV"), DS(10, "Ranged Accuracy Drive XV"), DS(5, "Max GP Drive XV")],
[DS(20, "Melee Accuracy Up III"), DS(20, "Ranged Accuracy Up III"), DS(20, "Potential Up III"), DS(20, "Resist Stun XVI"), DS(20, "Resist Taunt XVI"), DS(10, "Firing Range Up XVI")],
[DS(20, "Melee Accuracy Up V"), DS(20, "Ranged Accuracy Up V"), DS(20, "Potential Up V"), DS(20, "Resist Stun XVIII"), DS(20, "Resist Taunt XVIII"), DS(10, "Firing Range Up XVIII")],
[DS(20, "Melee Accuracy Up VII"), DS(20, "Ranged Accuracy Up VII"), DS(20, "Potential Up VII"), DS(20, "Resist Stun XX"), DS(20, "Resist Taunt XX"), DS(10, "Firing Range Up XX")],
[DS(20, "Melee Accuracy Up IX"), DS(20, "Ranged Accuracy Up IX"), DS(20, "Potential Up IX"), DS(20, "Resist Sleep II"), DS(20, "Resist Control II"), DS(10, "Resist Stagger II")],
[DS(20, "Melee Accuracy Up XI"), DS(20, "Ranged Accuracy Up XI"), DS(20, "Potential Up XI"), DS(20, "Resist Sleep IV"), DS(20, "Resist Control IV"), DS(10, "Resist Stagger IV")],
[DS(20, "Ranged Accuracy Boost IV"), DS(20, "Evasion Boost IV"), DS(20, "Max HP Drive IV"), DS(20, "Resist Stun XVII"), DS(20, "Resist Taunt XVII"), DS(10, "Firing Range Up XVII"), DS(10, "Opening Art: Damage Up XIV"), DS(10, "ITM_SKL_IN_FST_CRTC14_name"), DS(10, "Melee Attack Drive VII"), DS(10, "Ranged Attack Drive VII")],
[DS(20, "Ranged Accuracy Boost VI"), DS(20, "Evasion Boost VI"), DS(20, "Max HP Drive VI"), DS(20, "Resist Stun XIX"), DS(20, "Resist Taunt XIX"), DS(10, "Firing Range Up XIX"), DS(10, "Opening Art: Damage Up XVI"), DS(10, "ITM_SKL_IN_FST_CRTC16_name"), DS(10, "Melee Attack Drive IX"), DS(10, "Ranged Attack Drive IX")],
[DS(20, "Ranged Accuracy Boost VIII"), DS(20, "Evasion Boost VIII"), DS(20, "Max HP Drive VIII"), DS(20, "Resist Sleep I"), DS(20, "Resist Control I"), DS(10, "Resist Stagger I"), DS(10, "Opening Art: Damage Up XVIII"), DS(10, "ITM_SKL_IN_FST_CRTC18_name"), DS(10, "Melee Attack Drive XI"), DS(10, "Ranged Attack Drive XI")],
[DS(20, "Ranged Accuracy Boost X"), DS(20, "Evasion Boost X"), DS(20, "Max HP Drive X"), DS(20, "Resist Sleep III"), DS(20, "Resist Control III"), DS(10, "Resist Stagger III"), DS(10, "Opening Art: Damage Up XX"), DS(10, "ITM_SKL_IN_FST_CRTC20_name"), DS(10, "Melee Attack Drive XIII"), DS(10, "Ranged Attack Drive XIII")],
[DS(20, "Ranged Accuracy Boost XII"), DS(20, "Evasion Boost XII"), DS(20, "Max HP Drive XII"), DS(20, "Resist Sleep V"), DS(20, "Resist Control V"), DS(10, "Resist Stagger V"), DS(10, "ITM_SKL_IN_FST_CRTC02_name"), DS(10, "ITM_SKL_IN_FST_FDEX02_name"), DS(10, "Melee Attack Drive XV"), DS(10, "Ranged Attack Drive XV")],
[DS(20, "Melee Accuracy Up III"), DS(20, "Ranged Accuracy Up III"), DS(20, "Melee Attack Up III"), DS(20, "Ranged Attack Up III"), DS(20, "Potential Up III")],
[DS(20, "Melee Accuracy Up V"), DS(20, "Ranged Accuracy Up V"), DS(20, "Melee Attack Up V"), DS(20, "Ranged Attack Up V"), DS(20, "Potential Up V")],
[DS(20, "Melee Accuracy Up VII"), DS(20, "Ranged Accuracy Up VII"), DS(20, "Melee Attack Up VII"), DS(20, "Ranged Attack Up VII"), DS(20, "Potential Up VII")],
[DS(20, "Melee Accuracy Up IX"), DS(20, "Ranged Accuracy Up IX"), DS(20, "Melee Attack Up IX"), DS(20, "Ranged Attack Up IX"), DS(20, "Potential Up IX")],
[DS(20, "Melee Accuracy Up XI"), DS(20, "Ranged Accuracy Up XI"), DS(20, "Melee Attack Up XI"), DS(20, "Ranged Attack Up XI"), DS(20, "Potential Up XI")],
[DS(20, "Ranged Accuracy Boost IV"), DS(20, "Evasion Boost IV"), DS(20, "Ranged Attack Boost IV"), DS(20, "Potential Boost IV"), DS(20, "Max HP Drive IV"), DS(10, "ITM_SKL_IN_FST_EVA14_name"), DS(5, "Resist Blaze XVII"), DS(10, "Melee: Shock XVI"), DS(10, "Melee Attack Drive VII"), DS(10, "Ranged Attack Drive VII")],
[DS(20, "Ranged Accuracy Boost VI"), DS(20, "Evasion Boost VI"), DS(20, "Ranged Attack Boost VI"), DS(20, "Potential Boost VI"), DS(20, "Max HP Drive VI"), DS(10, "ITM_SKL_IN_FST_EVA16_name"), DS(5, "Resist Blaze XIX"), DS(10, "Melee: Shock XVIII"), DS(10, "Melee Attack Drive IX"), DS(10, "Ranged Attack Drive IX")],
[DS(20, "Ranged Accuracy Boost VIII"), DS(20, "Evasion Boost VIII"), DS(20, "Ranged Attack Boost VIII"), DS(20, "Potential Boost VIII"), DS(20, "Max HP Drive VIII"), DS(10, "ITM_SKL_IN_FST_EVA18_name"), DS(5, "Resist Shock I"), DS(10, "Melee: Shock XX"), DS(10, "Melee Attack Drive XI"), DS(10, "Ranged Attack Drive XI")],
[DS(20, "Ranged Accuracy Boost X"), DS(20, "Evasion Boost X"), DS(20, "Ranged Attack Boost X"), DS(20, "Potential Boost X"), DS(20, "Max HP Drive X"), DS(10, "ITM_SKL_IN_FST_EVA20_name"), DS(5, "Resist Shock III"), DS(10, "Melee: Recover HP II"), DS(10, "Melee Attack Drive XIII"), DS(10, "Ranged Attack Drive XIII")],
[DS(20, "Ranged Accuracy Boost XII"), DS(20, "Evasion Boost XII"), DS(20, "Ranged Attack Boost XII"), DS(20, "Potential Boost XII"), DS(20, "Max HP Drive XII"), DS(10, "ITM_SKL_IN_FST_FPOW02_name"), DS(5, "Resist Shock V"), DS(10, "Melee: Recover HP IV"), DS(10, "Melee Attack Drive XV"), DS(10, "Ranged Attack Drive XV")],
[DS(20, "Melee Accuracy Up III"), DS(20, "Ranged Accuracy Up III"), DS(20, "Melee Attack Up III"), DS(20, "Ranged Attack Up III"), DS(20, "Potential Up III")],
[DS(20, "Melee Accuracy Up V"), DS(20, "Ranged Accuracy Up V"), DS(20, "Melee Attack Up V"), DS(20, "Ranged Attack Up V"), DS(20, "Potential Up V")],
[DS(20, "Melee Accuracy Up VII"), DS(20, "Ranged Accuracy Up VII"), DS(20, "Melee Attack Up VII"), DS(20, "Ranged Attack Up VII"), DS(20, "Potential Up VII")],
[DS(20, "Melee Accuracy Up IX"), DS(20, "Ranged Accuracy Up IX"), DS(20, "Melee Attack Up IX"), DS(20, "Ranged Attack Up IX"), DS(20, "Potential Up IX")],
[DS(20, "Melee Accuracy Up XI"), DS(20, "Ranged Accuracy Up XI"), DS(20, "Melee Attack Up XI"), DS(20, "Ranged Attack Up XI"), DS(20, "Potential Up XI")],
[DS(20, "Ranged Accuracy Boost IV"), DS(20, "Evasion Boost IV"), DS(20, "Ranged Attack Boost IV"), DS(20, "Potential Boost IV"), DS(20, "Max HP Drive IV"), DS(10, "Max HP Boost IV")],
[DS(20, "Ranged Accuracy Boost VI"), DS(20, "Evasion Boost VI"), DS(20, "Ranged Attack Boost VI"), DS(20, "Potential Boost VI"), DS(20, "Max HP Drive VI"), DS(10, "Max HP Boost VI")],
[DS(20, "Ranged Accuracy Boost VIII"), DS(20, "Evasion Boost VIII"), DS(20, "Ranged Attack Boost VIII"), DS(20, "Potential Boost VIII"), DS(20, "Max HP Drive VIII"), DS(10, "Max HP Boost VIII")],
[DS(20, "Ranged Accuracy Boost X"), DS(20, "Evasion Boost X"), DS(20, "Ranged Attack Boost X"), DS(20, "Potential Boost X"), DS(20, "Max HP Drive X"), DS(10, "Max HP Boost X")],
[DS(20, "Ranged Accuracy Boost XII"), DS(20, "Evasion Boost XII"), DS(20, "Ranged Attack Boost XII"), DS(20, "Potential Boost XII"), DS(20, "Max HP Drive XII"), DS(10, "Max HP Boost XII")],
[DS(20, "Potential Up III"), DS(10, "Resist Stagger XVI"), DS(10, "Resist Flinch XVI"), DS(10, "Resist Topple XVI"), DS(20, "Max HP Boost III"), DS(10, "Melee Attack Drive VI"), DS(10, "Ranged Attack Drive VI")],
[DS(20, "Potential Up V"), DS(10, "Resist Stagger XVIII"), DS(10, "Resist Flinch XVIII"), DS(10, "Resist Topple XVIII"), DS(20, "Max HP Boost V"), DS(10, "Melee Attack Drive VIII"), DS(10, "Ranged Attack Drive VIII")],
[DS(20, "Potential Up VII"), DS(10, "Resist Stagger XX"), DS(10, "Resist Flinch XX"), DS(10, "Resist Topple XX"), DS(20, "Max HP Boost VII"), DS(10, "Melee Attack Drive X"), DS(10, "Ranged Attack Drive X")],
[DS(20, "Potential Up IX"), DS(10, "Resist Flinch II"), DS(10, "Resist Topple II"), DS(10, "Resist Knockback II"), DS(20, "Max HP Boost IX"), DS(10, "Melee Attack Drive XII"), DS(10, "Ranged Attack Drive XII")],
[DS(20, "Potential Up XI"), DS(10, "Resist Flinch IV"), DS(10, "Resist Topple IV"), DS(10, "Resist Knockback IV"), DS(20, "Max HP Boost XI"), DS(10, "Melee Attack Drive XIV"), DS(10, "Ranged Attack Drive XIV")],
[DS(20, "Max HP Drive IV"), DS(10, "Resist Stagger XVII"), DS(5, "Resist Blaze XVII"), DS(10, "Melee: Shock XVI"), DS(10, "ITM_SKL_IN_FST_FAKE09_name"), DS(10, "Melee Attack Drive VII"), DS(10, "Ranged Attack Drive VII")],
[DS(20, "Max HP Drive VI"), DS(10, "Resist Stagger XIX"), DS(5, "Resist Blaze XIX"), DS(10, "Melee: Shock XVIII"), DS(10, "ITM_SKL_IN_FST_FAKE11_name"), DS(10, "Melee Attack Drive IX"), DS(10, "Ranged Attack Drive IX")],
[DS(20, "Max HP Drive VIII"), DS(10, "Resist Flinch I"), DS(5, "Resist Shock I"), DS(10, "Melee: Shock XX"), DS(10, "ITM_SKL_IN_FST_FAKE13_name"), DS(10, "Melee Attack Drive XI"), DS(10, "Ranged Attack Drive XI")],
[DS(20, "Max HP Drive X"), DS(10, "Resist Flinch III"), DS(5, "Resist Shock III"), DS(10, "Melee: Recover HP II"), DS(10, "ITM_SKL_IN_FST_FAKE15_name"), DS(10, "Melee Attack Drive XIII"), DS(10, "Ranged Attack Drive XIII")],
[DS(20, "Max HP Drive XII"), DS(10, "Resist Flinch V"), DS(5, "Resist Shock V"), DS(10, "Melee: Recover HP IV"), DS(10, "ITM_SKL_IN_FST_FAKE17_name"), DS(10, "Melee Attack Drive XV"), DS(10, "Ranged Attack Drive XV")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII"), DS(10, "Insectoid Slayer XVII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX"), DS(10, "Insectoid Slayer XIX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Physical Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Humanoid Criticals Up II"), DS(10, "Piscinoid Slayer I")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Physical Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV"), DS(10, "Piscinoid Slayer III")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(10, "Destabilizer I"), DS(10, "Magazine Capacity Up I"), DS(10, "Melee: TP Gain Up"), DS(15, "Gravity Attack Plus XVIII"), DS(10, "Front Attack Plus XVIII"), DS(10, "Side Attack Plus XVIII")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(10, "Destabilizer III"), DS(10, "Magazine Capacity Up III"), DS(10, "Cooldown Reducer I"), DS(15, "Gravity Attack Plus XX"), DS(10, "Front Attack Plus XX"), DS(10, "Side Attack Plus XX")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Physical Attack Plus II"), DS(10, "Destabilizer V"), DS(10, "Magazine Capacity Up V"), DS(10, "Cooldown Reducer III"), DS(15, "Front Attack Plus II"), DS(10, "Side Attack Plus II"), DS(10, "Back Attack Plus II")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Physical Attack Plus IV"), DS(10, "Destabilizer VII"), DS(10, "Magazine Capacity Up VII"), DS(10, "Cooldown Reducer V"), DS(15, "Front Attack Plus IV"), DS(10, "Side Attack Plus IV"), DS(10, "Back Attack Plus IV")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Melee Attack Up V"), DS(10, "Chimeroid Slayer XVII"), DS(15, "Extend Debuff Res Down XV")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Melee Attack Up VII"), DS(10, "Chimeroid Slayer XIX"), DS(15, "Extend Debuff Res Down XVII")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Melee Attack Up IX"), DS(10, "Ultrafauna Slayer I"), DS(15, "Extend Debuff Res Down XIX")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Melee Attack Up XI"), DS(10, "Ultrafauna Slayer III"), DS(15, "ITM_SKL_IN_TIME_EX_HPDN01_name")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ranged Attack Boost VI"), DS(10, "Chimeroid Slayer XVIII"), DS(15, "Resist Shock XIX"), DS(15, "Electric Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII"), DS(10, "ITM_SKL_IN_FST_FDEX16_name"), DS(15, "Ultrafauna Criticals Up XIX"), DS(15, "Extend Critical Power XIX"), DS(15, "Piscinoid Slayer XVIII")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ranged Attack Boost VIII"), DS(10, "Chimeroid Slayer XX"), DS(15, "Debuff Suppressor I"), DS(15, "Electric Attack Plus XX"), DS(15, "Front Attack Plus XX"), DS(10, "ITM_SKL_IN_FST_FDEX18_name"), DS(15, "Extend Critical Power I"), DS(15, "Zero Critical"), DS(15, "Piscinoid Slayer XX")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Ranged Attack Boost X"), DS(10, "Ultrafauna Slayer II"), DS(15, "Debuff Suppressor III"), DS(15, "Gravity Attack Plus II"), DS(15, "Side Attack Plus II"), DS(10, "ITM_SKL_IN_FST_FDEX20_name"), DS(15, "Extend Critical Power III"), DS(15, "Theroid Slayer II"), DS(15, "Humanoid Slayer II")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Ranged Attack Boost XII"), DS(10, "Ultrafauna Slayer IV"), DS(15, "Debuff Suppressor V"), DS(15, "Gravity Attack Plus IV"), DS(15, "Side Attack Plus IV"), DS(10, "ITM_SKL_IN_FST_SDEX02_name"), DS(15, "Extend Critical Power V"), DS(15, "Theroid Slayer IV"), DS(15, "Humanoid Slayer IV")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Melee Attack Up V"), DS(10, "Beam Attack Plus XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Melee Attack Up VII"), DS(10, "Beam Attack Plus XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Melee Attack Up IX"), DS(10, "Ether Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Melee Attack Up XI"), DS(10, "Ether Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ranged Attack Boost VI"), DS(10, "Beam Attack Plus XVIII"), DS(10, "Destabilizer I"), DS(10, "Melee: TP Gain Up"), DS(10, "Stabilizer IV"), DS(15, "Resist Shock XIX"), DS(15, "Gravity Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ranged Attack Boost VIII"), DS(10, "Beam Attack Plus XX"), DS(10, "Destabilizer III"), DS(10, "Cooldown Reducer I"), DS(10, "Stabilizer IV"), DS(15, "Debuff Suppressor I"), DS(15, "Gravity Attack Plus XX"), DS(15, "Front Attack Plus XX")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Ranged Attack Boost X"), DS(10, "Ether Attack Plus II"), DS(10, "Destabilizer V"), DS(10, "Cooldown Reducer III"), DS(10, "Stabilizer IV"), DS(15, "Debuff Suppressor III"), DS(15, "Front Attack Plus II"), DS(15, "Side Attack Plus II")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Ranged Attack Boost XII"), DS(10, "Ether Attack Plus IV"), DS(10, "Destabilizer VII"), DS(10, "Cooldown Reducer V"), DS(10, "Stabilizer IV"), DS(15, "Debuff Suppressor V"), DS(15, "Front Attack Plus IV"), DS(15, "Side Attack Plus IV")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Beam Attack Plus XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Beam Attack Plus XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Ether Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Ether Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Evasion Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Beam Attack Plus XVIII"), DS(15, "Cooldown Reducer XIX"), DS(15, "Firing Range Up XIX"), DS(10, "Resist Stagger XIX"), DS(15, "Resist Flinch XIX"), DS(15, "Resist Topple XIX"), DS(10, "Weapon Attack Power Up IV"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Beam Attack Plus XX"), DS(15, "Firing Range Up I"), DS(15, "Resist Stagger I"), DS(10, "Resist Flinch I"), DS(15, "Resist Topple I"), DS(15, "Resist Knockback I"), DS(10, "Weapon Attack Power Up V"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost X"), DS(10, "Potential Boost X"), DS(10, "Ether Attack Plus II"), DS(15, "Firing Range Up III"), DS(15, "Resist Stagger III"), DS(10, "Resist Flinch III"), DS(15, "Resist Topple III"), DS(15, "Resist Knockback III"), DS(10, "Weapon Attack Power Up VI"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Ether Attack Plus IV"), DS(15, "Firing Range Up V"), DS(15, "Resist Stagger V"), DS(10, "Resist Flinch V"), DS(15, "Resist Topple V"), DS(15, "Resist Knockback V"), DS(10, "Weapon Attack Power Up VII"), DS(10, "Stabilizer X")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Physical Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Physical Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(10, "Destabilizer I"), DS(10, "Magazine Capacity Up I"), DS(10, "Melee: TP Gain Up"), DS(15, "Gravity Attack Plus XVIII"), DS(10, "Front Attack Plus XVIII"), DS(10, "Side Attack Plus XVIII")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(10, "Destabilizer III"), DS(10, "Magazine Capacity Up III"), DS(10, "Cooldown Reducer I"), DS(15, "Gravity Attack Plus XX"), DS(10, "Front Attack Plus XX"), DS(10, "Side Attack Plus XX")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Physical Attack Plus II"), DS(10, "Destabilizer V"), DS(10, "Magazine Capacity Up V"), DS(10, "Cooldown Reducer III"), DS(15, "Front Attack Plus II"), DS(10, "Side Attack Plus II"), DS(10, "Back Attack Plus II")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Physical Attack Plus IV"), DS(10, "Destabilizer VII"), DS(10, "Magazine Capacity Up VII"), DS(10, "Cooldown Reducer V"), DS(15, "Front Attack Plus IV"), DS(10, "Side Attack Plus IV"), DS(10, "Back Attack Plus IV")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Ether Attack Plus XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(10, "Piscinoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Ether Attack Plus XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(10, "Piscinoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Thermal Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(10, "Humanoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Thermal Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(10, "Humanoid Criticals Up IV")],
[DS(15, "Evasion Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Ether Attack Plus XVIII"), DS(10, "Destabilizer I"), DS(10, "Melee: TP Gain Up"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Ether Attack Plus XX"), DS(10, "Destabilizer III"), DS(10, "Cooldown Reducer I"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost X"), DS(10, "Potential Boost X"), DS(10, "Thermal Attack Plus II"), DS(10, "Destabilizer V"), DS(10, "Cooldown Reducer III"), DS(10, "Stabilizer X")],
[DS(15, "Evasion Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Thermal Attack Plus IV"), DS(10, "Destabilizer VII"), DS(10, "Cooldown Reducer V"), DS(10, "Stabilizer X")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Beam Attack Plus XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Beam Attack Plus XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Ether Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Ether Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Beam Attack Plus XVIII"), DS(10, "Destabilizer I"), DS(10, "Magazine Capacity Up I"), DS(10, "Melee: TP Gain Up"), DS(15, "Gravity Attack Plus XVIII"), DS(10, "Front Attack Plus XVIII")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Beam Attack Plus XX"), DS(10, "Destabilizer III"), DS(10, "Magazine Capacity Up III"), DS(10, "Cooldown Reducer I"), DS(15, "Gravity Attack Plus XX"), DS(10, "Front Attack Plus XX")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Ether Attack Plus II"), DS(10, "Destabilizer V"), DS(10, "Magazine Capacity Up V"), DS(10, "Cooldown Reducer III"), DS(15, "Front Attack Plus II"), DS(10, "Side Attack Plus II")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Ether Attack Plus IV"), DS(10, "Destabilizer VII"), DS(10, "Magazine Capacity Up VII"), DS(10, "Cooldown Reducer V"), DS(15, "Front Attack Plus IV"), DS(10, "Side Attack Plus IV")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Physical Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Physical Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(10, "Destabilizer I"), DS(10, "Magazine Capacity Up I"), DS(10, "Melee: TP Gain Up"), DS(15, "Gravity Attack Plus XVIII"), DS(10, "Front Attack Plus XVIII"), DS(10, "Side Attack Plus XVIII")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(10, "Destabilizer III"), DS(10, "Magazine Capacity Up III"), DS(10, "Cooldown Reducer I"), DS(15, "Gravity Attack Plus XX"), DS(10, "Front Attack Plus XX"), DS(10, "Side Attack Plus XX")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Physical Attack Plus II"), DS(10, "Destabilizer V"), DS(10, "Magazine Capacity Up V"), DS(10, "Cooldown Reducer III"), DS(15, "Front Attack Plus II"), DS(10, "Side Attack Plus II"), DS(10, "Back Attack Plus II")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Physical Attack Plus IV"), DS(10, "Destabilizer VII"), DS(10, "Magazine Capacity Up VII"), DS(10, "Cooldown Reducer V"), DS(15, "Front Attack Plus IV"), DS(10, "Side Attack Plus IV"), DS(10, "Back Attack Plus IV")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Physical Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Physical Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Evasion Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(10, "Ultrafauna Criticals Up XIX"), DS(10, "Extend Critical Power XIX"), DS(10, "Theroid Slayer XVIII"), DS(10, "Piscinoid Slayer XVIII"), DS(10, "Insectoid Slayer XVIII")],
[DS(15, "Evasion Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(10, "Extend Critical Power I"), DS(10, "Zero Critical"), DS(10, "Theroid Slayer XX"), DS(10, "Piscinoid Slayer XX"), DS(10, "Insectoid Slayer XX")],
[DS(15, "Evasion Boost X"), DS(10, "Potential Boost X"), DS(10, "Physical Attack Plus II"), DS(10, "Extend Critical Power III"), DS(10, "Theroid Slayer II"), DS(10, "Insectoid Slayer II"), DS(10, "Humanoid Slayer II"), DS(10, "Piscinoid Slayer II")],
[DS(15, "Evasion Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Physical Attack Plus IV"), DS(10, "Extend Critical Power V"), DS(10, "Theroid Slayer IV"), DS(10, "Insectoid Slayer IV"), DS(10, "Humanoid Slayer IV"), DS(10, "Piscinoid Slayer IV")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Ultrafauna Slayer XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Ultrafauna Slayer XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Physical Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Physical Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Ultrafauna Slayer XVIII"), DS(10, "Destabilizer I"), DS(10, "Magazine Capacity Up I"), DS(10, "Melee: TP Gain Up"), DS(15, "Gravity Attack Plus XVIII"), DS(10, "Front Attack Plus XVIII"), DS(10, "Side Attack Plus XVIII")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Ultrafauna Slayer XX"), DS(10, "Destabilizer III"), DS(10, "Magazine Capacity Up III"), DS(10, "Cooldown Reducer I"), DS(15, "Gravity Attack Plus XX"), DS(10, "Front Attack Plus XX"), DS(10, "Side Attack Plus XX")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Physical Attack Plus II"), DS(10, "Destabilizer V"), DS(10, "Magazine Capacity Up V"), DS(10, "Cooldown Reducer III"), DS(15, "Front Attack Plus II"), DS(10, "Side Attack Plus II"), DS(10, "Back Attack Plus II")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Physical Attack Plus IV"), DS(10, "Destabilizer VII"), DS(10, "Magazine Capacity Up VII"), DS(10, "Cooldown Reducer V"), DS(15, "Front Attack Plus IV"), DS(10, "Side Attack Plus IV"), DS(10, "Back Attack Plus IV")],
[DS(15, "Ranged Accuracy Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Physical Attack Plus XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Theroid Criticals Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Ranged Accuracy Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Physical Attack Plus XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Theroid Criticals Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Ranged Accuracy Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Beam Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Insectoid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Ranged Accuracy Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Beam Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Insectoid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Evasion Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Physical Attack Plus XVIII"), DS(10, "Magazine Capacity Up I"), DS(10, "Melee: TP Gain Up"), DS(10, "Gravity Resistance Up IX")],
[DS(15, "Evasion Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Physical Attack Plus XX"), DS(10, "Magazine Capacity Up III"), DS(10, "Cooldown Reducer I"), DS(10, "Gravity Resistance Up XI")],
[DS(15, "Evasion Boost X"), DS(10, "Potential Boost X"), DS(10, "Beam Attack Plus II"), DS(10, "Magazine Capacity Up V"), DS(10, "Cooldown Reducer III"), DS(10, "Gravity Resistance Up XIII")],
[DS(15, "Evasion Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Beam Attack Plus IV"), DS(10, "Magazine Capacity Up VII"), DS(10, "Cooldown Reducer V"), DS(10, "Gravity Resistance Up XV")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Physical Attack Plus XVII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Physical Attack Plus XIX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Beam Attack Plus I")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Beam Attack Plus III")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Physical Attack Plus XVIII"), DS(10, "Destabilizer I"), DS(10, "Melee: TP Gain Up")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Physical Attack Plus XX"), DS(10, "Destabilizer III"), DS(10, "Cooldown Reducer I")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Beam Attack Plus II"), DS(10, "Destabilizer V"), DS(10, "Cooldown Reducer III")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Beam Attack Plus IV"), DS(10, "Destabilizer VII"), DS(10, "Cooldown Reducer V")],
[DS(15, "Ranged Accuracy Up V"), DS(15, "Ranged Attack Up V"), DS(10, "Beam Attack Plus XVII")],
[DS(15, "Ranged Accuracy Up VII"), DS(15, "Ranged Attack Up VII"), DS(10, "Beam Attack Plus XIX")],
[DS(15, "Ranged Accuracy Up IX"), DS(15, "Ranged Attack Up IX"), DS(10, "Ether Attack Plus I")],
[DS(15, "Ranged Accuracy Up XI"), DS(15, "Ranged Attack Up XI"), DS(10, "Ether Attack Plus III")],
[DS(15, "Evasion Boost VI"), DS(15, "Potential Boost VI"), DS(10, "Beam Attack Plus XVIII"), DS(10, "Destabilizer I"), DS(10, "Melee: TP Gain Up")],
[DS(15, "Evasion Boost VIII"), DS(15, "Potential Boost VIII"), DS(10, "Beam Attack Plus XX"), DS(10, "Destabilizer III"), DS(10, "Cooldown Reducer I")],
[DS(15, "Evasion Boost X"), DS(15, "Potential Boost X"), DS(10, "Ether Attack Plus II"), DS(10, "Destabilizer V"), DS(10, "Cooldown Reducer III")],
[DS(15, "Evasion Boost XII"), DS(15, "Potential Boost XII"), DS(10, "Ether Attack Plus IV"), DS(10, "Destabilizer VII"), DS(10, "Cooldown Reducer V")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Melee Attack Up V"), DS(10, "Chimeroid Slayer XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Melee Attack Up VII"), DS(10, "Chimeroid Slayer XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Melee Attack Up IX"), DS(10, "Ultrafauna Slayer I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Melee Attack Up XI"), DS(10, "Ultrafauna Slayer III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ranged Attack Boost VI"), DS(10, "Chimeroid Slayer XVIII"), DS(10, "Destabilizer I"), DS(10, "Melee: TP Gain Up"), DS(10, "Stabilizer IV"), DS(15, "Resist Shock XIX"), DS(15, "Gravity Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ranged Attack Boost VIII"), DS(10, "Chimeroid Slayer XX"), DS(10, "Destabilizer III"), DS(10, "Cooldown Reducer I"), DS(10, "Stabilizer IV"), DS(15, "Debuff Suppressor I"), DS(15, "Gravity Attack Plus XX"), DS(15, "Front Attack Plus XX")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Ranged Attack Boost X"), DS(10, "Ultrafauna Slayer II"), DS(10, "Destabilizer V"), DS(10, "Cooldown Reducer III"), DS(10, "Stabilizer IV"), DS(15, "Debuff Suppressor III"), DS(15, "Front Attack Plus II"), DS(15, "Side Attack Plus II")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Ranged Attack Boost XII"), DS(10, "Ultrafauna Slayer IV"), DS(10, "Destabilizer VII"), DS(10, "Cooldown Reducer V"), DS(10, "Stabilizer IV"), DS(15, "Debuff Suppressor V"), DS(15, "Front Attack Plus IV"), DS(15, "Side Attack Plus IV")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Melee Attack Up V"), DS(10, "Chimeroid Slayer XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Melee Attack Up VII"), DS(10, "Chimeroid Slayer XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Melee Attack Up IX"), DS(10, "Ultrafauna Slayer I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Melee Attack Up XI"), DS(10, "Ultrafauna Slayer III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ranged Attack Boost VI"), DS(10, "Chimeroid Slayer XVIII"), DS(10, "Destabilizer I"), DS(10, "Melee: TP Gain Up"), DS(10, "Stabilizer IV"), DS(15, "Resist Shock XIX"), DS(15, "Gravity Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ranged Attack Boost VIII"), DS(10, "Chimeroid Slayer XX"), DS(10, "Destabilizer III"), DS(10, "Cooldown Reducer I"), DS(10, "Stabilizer IV"), DS(15, "Debuff Suppressor I"), DS(15, "Gravity Attack Plus XX"), DS(15, "Front Attack Plus XX")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Ranged Attack Boost X"), DS(10, "Ultrafauna Slayer II"), DS(10, "Destabilizer V"), DS(10, "Cooldown Reducer III"), DS(10, "Stabilizer IV"), DS(15, "Debuff Suppressor III"), DS(15, "Front Attack Plus II"), DS(15, "Side Attack Plus II")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Ranged Attack Boost XII"), DS(10, "Ultrafauna Slayer IV"), DS(10, "Destabilizer VII"), DS(10, "Cooldown Reducer V"), DS(10, "Stabilizer IV"), DS(15, "Debuff Suppressor V"), DS(15, "Front Attack Plus IV"), DS(15, "Side Attack Plus IV")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Melee Attack Up V"), DS(10, "Beam Attack Plus XVII"), DS(15, "Resist Shock XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Melee Attack Up VII"), DS(10, "Beam Attack Plus XIX"), DS(15, "Resist Shock XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Melee Attack Up IX"), DS(10, "Ether Attack Plus I"), DS(15, "Debuff Suppressor II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Melee Attack Up XI"), DS(10, "Ether Attack Plus III"), DS(15, "Debuff Suppressor IV")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ranged Attack Boost VI"), DS(10, "Beam Attack Plus XVIII"), DS(10, "Melee: TP Gain Up"), DS(15, "Ultrafauna Criticals Up XIX"), DS(15, "Extend Critical Power XIX"), DS(15, "Piscinoid Slayer XVIII")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ranged Attack Boost VIII"), DS(10, "Beam Attack Plus XX"), DS(10, "Cooldown Reducer I"), DS(15, "Extend Critical Power I"), DS(15, "Zero Critical"), DS(15, "Piscinoid Slayer XX")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Ranged Attack Boost X"), DS(10, "Ether Attack Plus II"), DS(10, "Cooldown Reducer III"), DS(15, "Extend Critical Power III"), DS(15, "Theroid Slayer II"), DS(15, "Humanoid Slayer II")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Ranged Attack Boost XII"), DS(10, "Ether Attack Plus IV"), DS(10, "Cooldown Reducer V"), DS(15, "Extend Critical Power V"), DS(15, "Theroid Slayer IV"), DS(15, "Humanoid Slayer IV")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Melee Attack Up V"), DS(10, "Thermal Attack Plus XVII"), DS(15, "Resist Shock XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Melee Attack Up VII"), DS(10, "Thermal Attack Plus XIX"), DS(15, "Resist Shock XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Melee Attack Up IX"), DS(10, "Electric Attack Plus I"), DS(15, "Debuff Suppressor II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Melee Attack Up XI"), DS(10, "Electric Attack Plus III"), DS(15, "Debuff Suppressor IV")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ranged Attack Boost VI"), DS(10, "Thermal Attack Plus XVIII"), DS(10, "Melee: TP Gain Up"), DS(15, "Ultrafauna Criticals Up XIX"), DS(15, "Extend Critical Power XIX"), DS(15, "Piscinoid Slayer XVIII")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ranged Attack Boost VIII"), DS(10, "Thermal Attack Plus XX"), DS(10, "Cooldown Reducer I"), DS(15, "Extend Critical Power I"), DS(15, "Zero Critical"), DS(15, "Piscinoid Slayer XX")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Ranged Attack Boost X"), DS(10, "Electric Attack Plus II"), DS(10, "Cooldown Reducer III"), DS(15, "Extend Critical Power III"), DS(15, "Theroid Slayer II"), DS(15, "Humanoid Slayer II")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Ranged Attack Boost XII"), DS(10, "Electric Attack Plus IV"), DS(10, "Cooldown Reducer V"), DS(15, "Extend Critical Power V"), DS(15, "Theroid Slayer IV"), DS(15, "Humanoid Slayer IV")],
[DS(15, "Ranged Attack Up V"), DS(10, "Ranged Attack Up V"), DS(10, "Beam Attack Plus XVII"), DS(15, "Resist Shock XVIII")],
[DS(15, "Ranged Attack Up VII"), DS(10, "Ranged Attack Up VII"), DS(10, "Beam Attack Plus XIX"), DS(15, "Resist Shock XX")],
[DS(15, "Ranged Attack Up IX"), DS(10, "Ranged Attack Up IX"), DS(10, "Ether Attack Plus I"), DS(15, "Debuff Suppressor II")],
[DS(15, "Ranged Attack Up XI"), DS(10, "Ranged Attack Up XI"), DS(10, "Ether Attack Plus III"), DS(15, "Debuff Suppressor IV")],
[DS(15, "Potential Boost VI"), DS(10, "Potential Boost VI"), DS(10, "Beam Attack Plus XVIII"), DS(10, "Melee: TP Gain Up"), DS(15, "Electric Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII"), DS(15, "ITM_SKL_IN_FST_FDEX16_name"), DS(15, "Extend Debuff Res Down XVI")],
[DS(15, "Potential Boost VIII"), DS(10, "Potential Boost VIII"), DS(10, "Beam Attack Plus XX"), DS(10, "Cooldown Reducer I"), DS(15, "Electric Attack Plus XX"), DS(15, "Front Attack Plus XX"), DS(15, "ITM_SKL_IN_FST_FDEX18_name"), DS(15, "Extend Debuff Res Down XVIII")],
[DS(15, "Potential Boost X"), DS(10, "Potential Boost X"), DS(10, "Ether Attack Plus II"), DS(10, "Cooldown Reducer III"), DS(15, "Gravity Attack Plus II"), DS(15, "Side Attack Plus II"), DS(15, "ITM_SKL_IN_FST_FDEX20_name"), DS(15, "Extend Debuff Res Down XX")],
[DS(15, "Potential Boost XII"), DS(10, "Potential Boost XII"), DS(10, "Ether Attack Plus IV"), DS(10, "Cooldown Reducer V"), DS(15, "Gravity Attack Plus IV"), DS(15, "Side Attack Plus IV"), DS(15, "ITM_SKL_IN_FST_SDEX02_name"), DS(15, "ITM_SKL_IN_TIME_EX_HPDN02_name")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Melee Attack Up V"), DS(10, "Chimeroid Slayer XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Melee Attack Up VII"), DS(10, "Chimeroid Slayer XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Melee Attack Up IX"), DS(10, "Ultrafauna Slayer I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Melee Attack Up XI"), DS(10, "Ultrafauna Slayer III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ranged Attack Boost VI"), DS(10, "Chimeroid Slayer XVIII"), DS(10, "Destabilizer I"), DS(10, "Melee: TP Gain Up"), DS(10, "Stabilizer IV"), DS(15, "Resist Shock XIX"), DS(15, "Gravity Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ranged Attack Boost VIII"), DS(10, "Chimeroid Slayer XX"), DS(10, "Destabilizer III"), DS(10, "Cooldown Reducer I"), DS(10, "Stabilizer IV"), DS(15, "Debuff Suppressor I"), DS(15, "Gravity Attack Plus XX"), DS(15, "Front Attack Plus XX")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Ranged Attack Boost X"), DS(10, "Ultrafauna Slayer II"), DS(10, "Destabilizer V"), DS(10, "Cooldown Reducer III"), DS(10, "Stabilizer IV"), DS(15, "Debuff Suppressor III"), DS(15, "Front Attack Plus II"), DS(15, "Side Attack Plus II")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Ranged Attack Boost XII"), DS(10, "Ultrafauna Slayer IV"), DS(10, "Destabilizer VII"), DS(10, "Cooldown Reducer V"), DS(10, "Stabilizer IV"), DS(15, "Debuff Suppressor V"), DS(15, "Front Attack Plus IV"), DS(15, "Side Attack Plus IV")],
[DS(15, "Melee Accuracy Up V"), DS(10, "Melee Attack Up V"), DS(10, "Physical Attack Plus XVII"), DS(15, "Debuff Suppressor XVIII"), DS(15, "Critical Chance Up XVIII"), DS(15, "Insectoid Criticals Up XVIII"), DS(15, "Piscinoid Criticals Up XVIII")],
[DS(15, "Melee Accuracy Up VII"), DS(10, "Melee Attack Up VII"), DS(10, "Physical Attack Plus XIX"), DS(15, "Debuff Suppressor XX"), DS(15, "Critical Chance Up XX"), DS(15, "Insectoid Criticals Up XX"), DS(15, "Piscinoid Criticals Up XX")],
[DS(15, "Melee Accuracy Up IX"), DS(10, "Melee Attack Up IX"), DS(10, "Beam Attack Plus I"), DS(15, "Critical Chance Up II"), DS(15, "Theroid Criticals Up II"), DS(15, "Piscinoid Criticals Up II"), DS(15, "Humanoid Criticals Up II")],
[DS(15, "Melee Accuracy Up XI"), DS(10, "Melee Attack Up XI"), DS(10, "Beam Attack Plus III"), DS(15, "Critical Chance Up IV"), DS(15, "Theroid Criticals Up IV"), DS(15, "Piscinoid Criticals Up IV"), DS(15, "Humanoid Criticals Up IV")],
[DS(15, "Ranged Accuracy Boost VI"), DS(10, "Ranged Attack Boost VI"), DS(10, "Physical Attack Plus XVIII"), DS(15, "Resist Shock XIX"), DS(10, "Ether Resistance Up IX"), DS(10, "Melee: TP Gain Up"), DS(15, "Destabilizer I"), DS(15, "Electric Attack Plus XVIII"), DS(15, "Front Attack Plus XVIII"), DS(10, "Stabilizer IV")],
[DS(15, "Ranged Accuracy Boost VIII"), DS(10, "Ranged Attack Boost VIII"), DS(10, "Physical Attack Plus XX"), DS(15, "Debuff Suppressor I"), DS(10, "Ether Resistance Up XI"), DS(10, "Cooldown Reducer I"), DS(15, "Destabilizer III"), DS(15, "Electric Attack Plus XX"), DS(15, "Front Attack Plus XX"), DS(10, "Stabilizer IV")],
[DS(15, "Ranged Accuracy Boost X"), DS(10, "Ranged Attack Boost X"), DS(10, "Beam Attack Plus II"), DS(15, "Debuff Suppressor III"), DS(10, "Ether Resistance Up XIII"), DS(10, "Cooldown Reducer III"), DS(15, "Destabilizer V"), DS(15, "Gravity Attack Plus II"), DS(15, "Side Attack Plus II"), DS(10, "Stabilizer IV")],
[DS(15, "Ranged Accuracy Boost XII"), DS(10, "Ranged Attack Boost XII"), DS(10, "Beam Attack Plus IV"), DS(15, "Debuff Suppressor V"), DS(10, "Ether Resistance Up XV"), DS(10, "Cooldown Reducer V"), DS(15, "Destabilizer VII"), DS(15, "Gravity Attack Plus IV"), DS(15, "Side Attack Plus IV"), DS(10, "Stabilizer IV")],
]