"""Stores the data for the locations of colored bananas and balloons in Angry Aztec."""

from randomizer.Enums.Events import Events
from randomizer.Enums.Kongs import Kongs
from randomizer.Enums.Regions import Regions
from randomizer.Enums.Maps import Maps
from randomizer.LogicClasses import Balloon, ColoredBananaGroup

ColoredBananaGroupList = [
    ColoredBananaGroup(
        group=1,
        map_id=Maps.FranticFactory,
        name="Entrance on K. Rool mat",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        locations=[[5, 1.0, 1265, 836, 2504]],
    ),
    ColoredBananaGroup(
        group=2,
        map_id=Maps.FranticFactory,
        name="Around hatch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        locations=[
            [1, 1.0, 554, 805, 2078],
            [1, 1.0, 509, 805, 2000],
            [1, 1.0, 464, 805, 1922],
            [1, 1.0, 534, 805, 1837],
            [1, 1.0, 604, 805, 1752],
            [1, 1.0, 688, 805, 1752],
            [1, 1.0, 758, 805, 1837],
            [1, 1.0, 828, 805, 1922],
            [1, 1.0, 783, 805, 2000],
            [1, 1.0, 738, 805, 2078],
        ],
    ),
    ColoredBananaGroup(
        group=3,
        map_id=Maps.FranticFactory,
        name="On Hatch switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        locations=[[5, 1.0, 1266, 852, 2198]],
    ),
    ColoredBananaGroup(
        group=4,
        map_id=Maps.FranticFactory,
        name="Hatch switch room left wall",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        locations=[
            [1, 1.0, 1064, 843, 2254],
            [1, 1.0, 1064, 843, 2205],
            [1, 1.0, 1064, 843, 2156],
            [1, 1.0, 1064, 843, 2107],
            [1, 1.0, 1064, 843, 2058],
        ],
    ),
    ColoredBananaGroup(
        group=5,
        map_id=Maps.FranticFactory,
        name="Hatch switch room on console",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        locations=[[5, 1.0, 1300, 873, 2048], [5, 1.0, 1232, 873, 2048]],
    ),
    ColoredBananaGroup(
        group=6,
        map_id=Maps.FranticFactory,
        name="W3 (1 custom, 1 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,  # Other bunch is in FranticFactoryStart
        locations=[[5, 1.0, 1541.3790283203125, 823.6666870117188, 2159.98583984375]],
    ),
    ColoredBananaGroup(
        group=6,
        map_id=Maps.FranticFactory,
        name="W3 (1 custom, 1 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        locations=[[5, 1.0, 1436, 858, 2174]],
    ),
    ColoredBananaGroup(
        group=7,
        map_id=Maps.FranticFactory,
        name="Snide room on metal boxes",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[[5, 1.0, 1515, 856, 2255], [5, 1.0, 1557, 856, 2092]],
    ),
    ColoredBananaGroup(
        group=8,
        map_id=Maps.FranticFactory,
        name="Pole from entrance to testing - upper room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[[5, 1.0, 2094, 1031, 2292], [5, 1.0, 1948, 1031, 2292]],
    ),
    ColoredBananaGroup(
        group=9,
        map_id=Maps.FranticFactory,
        name="Tunnel to Snide room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[
            [1, 1.0, 1566, 1026, 1989],
            [1, 1.0, 1566, 1026, 1915],
            [1, 1.0, 1686, 1026, 1915],
            [1, 1.0, 1806, 1026, 1915],
            [1, 1.0, 1926, 1026, 1915],
        ],
    ),
    ColoredBananaGroup(
        group=10,
        map_id=Maps.FranticFactory,
        name="Snide room pole - upper room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[[5, 1.0, 1506, 1031, 2030], [5, 1.0, 1640, 1031, 2030]],
    ),
    ColoredBananaGroup(
        group=11,
        map_id=Maps.FranticFactory,
        name="Block tower room under stairs with DK coins",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[[5, 1.0, 2083, 1032, 1376], [5, 1.0, 2033, 1032, 1376], [5, 1.0, 1983, 1032, 1376]],
    ),
    ColoredBananaGroup(
        group=12,
        map_id=Maps.FranticFactory,
        name="Block tower room on top of DK coins stairs in front of window",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[
            [1, 1.0, 1988, 1110, 1504],
            [1, 1.0, 1988, 1110, 1440],
            [1, 1.0, 1988, 1110, 1376],
            [1, 1.0, 1988, 1110, 1312],
            [1, 1.0, 1988, 1110, 1248],
        ],
    ),
    ColoredBananaGroup(
        group=13,
        map_id=Maps.FranticFactory,
        name="On the floor at the base of block tower",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[[5, 1.0, 2496, 1032, 1217], [5, 1.0, 2330, 1032, 1382]],
    ),
    ColoredBananaGroup(
        group=14,
        map_id=Maps.FranticFactory,
        name="On corner block of Block tower",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[[5, 1.0, 2498, 1072, 1377]],
    ),
    ColoredBananaGroup(
        group=15,
        map_id=Maps.FranticFactory,
        name="Block tower room on box pile to tag barrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[[5, 1.0, 2489, 1072, 1038]],
    ),
    ColoredBananaGroup(
        group=16,
        map_id=Maps.FranticFactory,
        name="Block tower room on box by tag barrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[[5, 1.0, 2653, 1152, 861]],
    ),
    ColoredBananaGroup(
        group=17,
        map_id=Maps.FranticFactory,
        name="Block tower room on grate between Mini Monkey and Tag barrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[
            [1, 1.0, 2660, 1111, 1011],
            [1, 1.0, 2590, 1107, 1011],
            [1, 1.0, 2520, 1107, 1011],
            [1, 1.0, 2450, 1107, 1011],
            [1, 1.0, 2380, 1107, 1011],
        ],
    ),
    ColoredBananaGroup(
        group=18,
        map_id=Maps.FranticFactory,
        name="Block tower room by tunnel to spinning wheel (1 custom, 1 Tiny bunch)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[
            [5, 1.0, 2258, 1132, 894],
            [5, 1.059999942779541, 2342.00390625, 1108.814697265625, 852.6431274414062],
        ],
    ),
    ColoredBananaGroup(
        group=19,
        map_id=Maps.FranticFactory,
        name="All around Block tower room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[
            [1, 1.0, 2510, 1027, 1594],
            [1, 1.0, 2635, 1027, 1594],
            [1, 1.0, 2760, 1027, 1594],
            [1, 1.0, 2760, 1027, 1488],
            [1, 1.0, 2760, 1027, 1362],
            [1, 1.0, 2760, 1027, 1234],
            [1, 1.0, 2700, 1027, 1000],
            [1, 1.0, 2580, 1027, 1000],
            [1, 1.0, 2460, 1027, 1000],
            [1, 1.0, 2340, 1027, 1000],
            [1, 1.0, 2220, 1027, 1000],
            [1, 1.0, 2100, 1027, 1000],
            [1, 1.0, 1980, 1027, 1000],
            [1, 1.0, 1980, 1027, 1120],
            [1, 1.0, 1980, 1027, 1260],
            [1, 1.0, 1980, 1027, 1390],
            [1, 1.0, 1980, 1027, 1520],
            [1, 1.0, 2100, 1027, 1594],
            [1, 1.0, 2208, 1027, 1594],
            [1, 1.0, 2316, 1027, 1594],
        ],
    ),
    ColoredBananaGroup(
        group=20,
        map_id=Maps.FranticFactory,
        name="Around numbers game",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[
            [1, 1.0, 2767, 1002, 1948],
            [1, 1.0, 2690, 1002, 1948],
            [1, 1.0, 2612, 1002, 1948],
            [1, 1.0, 2534, 1002, 1948],
            [1, 1.0, 2534, 1002, 1817],
            [1, 1.0, 2534, 1002, 1686],
            [1, 1.0, 2612, 1002, 1686],
            [1, 1.0, 2690, 1002, 1686],
            [1, 1.0, 2767, 1002, 1686],
            [1, 1.0, 2767, 1002, 1817],
        ],
    ),
    ColoredBananaGroup(
        group=21,
        map_id=Maps.FranticFactory,
        name="Tunnel to numbers game (5 custom, 5 Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[
            [1, 1.0, 2929, 1002, 1835],
            [1, 1.0, 2968, 1036, 1698],
            [1, 1.0, 2970, 1076, 1570],
            [1, 1.0, 2970, 1107, 1439],
            [1, 1.0, 2836, 1108, 1424],
            [1, 1.0, 2832.239990234375, 1002.0, 1828.9998779296875],
            [1, 1.0, 2917.779296875, 1106.820556640625, 1424.7611083984375],
            [1, 1.0, 2972.089599609375, 1096.0538330078125, 1512.5328369140625],
            [1, 1.0, 2966.458740234375, 1058.765380859375, 1628.7216796875],
            [1, 1.0, 2964.000732421875, 1012.113037109375, 1770.9490966796875],
        ],
    ),
    ColoredBananaGroup(
        group=22,
        map_id=Maps.FranticFactory,
        name="Block tower (lower block towards R&D and tunnel to numbers game)",
        konglist=[Kongs.diddy, Kongs.lanky],
        region=Regions.Testing,
        logic=lambda l: ((l.spring or l.CanMoontail()) and l.isdiddy) or (l.balloon and l.islanky),
        locations=[[5, 1.0, 2495, 1152, 1296]],
    ),
    ColoredBananaGroup(
        group=23,
        map_id=Maps.FranticFactory,
        name="Block tower (R block near top)",
        konglist=[Kongs.diddy],
        region=Regions.Testing,
        logic=lambda l: l.spring or l.CanMoontail(),
        locations=[[5, 1.0, 2416, 1432, 1338]],
    ),
    ColoredBananaGroup(
        group=24,
        map_id=Maps.FranticFactory,
        name="Block tower (middle D block on the right path up)",
        konglist=[Kongs.diddy],
        region=Regions.Testing,
        logic=lambda l: l.spring or l.CanMoontail(),
        locations=[[5, 1.0, 2375, 1272, 1378]],
    ),
    ColoredBananaGroup(
        group=25,
        map_id=Maps.FranticFactory,
        name="Pole to R&D - lower room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[[5, 1.0, 3034, 1032, 1032], [5, 1.0, 3056, 1032, 1162]],
    ),
    ColoredBananaGroup(
        group=26,
        map_id=Maps.FranticFactory,
        name="R&D Pole",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandD,
        locations=[
            [1, 1.0, 3146, 1056, 1081],
            [1, 1.0, 3146, 1116, 1081],
            [1, 1.0, 3146, 1176, 1081],
            [1, 1.0, 3146, 1236, 1081],
            [1, 1.0, 3146, 1296, 1081],
        ],
    ),
    ColoredBananaGroup(
        group=27,
        map_id=Maps.FranticFactory,
        name="R&D pole - upper room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandD,
        locations=[[5, 1.0, 3264, 1269, 1000], [5, 1.0, 3276, 1269, 1138]],
    ),
    ColoredBananaGroup(
        group=28,
        map_id=Maps.FranticFactory,
        name="Tunnel from pole to R&D room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandD,
        locations=[
            [1, 1.0, 3280, 1264, 1066],
            [1, 1.0, 3355, 1264, 1060],
            [1, 1.0, 3430, 1264, 1054],
            [1, 1.0, 3505, 1264, 1048],
            [1, 1.0, 3580, 1264, 1042],
        ],
    ),
    ColoredBananaGroup(
        group=29,
        map_id=Maps.FranticFactory,
        name="Lower R&D pathway (10 custom, 5 Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandD,
        locations=[
            [1, 1.0, 3972, 1261, 1266],
            [1, 1.0, 3898, 1261, 1476],
            [1, 1.0, 3918, 1261, 1403],
            [1, 1.0, 3888, 1261, 1320],
            [1, 1.0, 3808, 1261, 1263],
            [1, 1.0, 3631, 1261, 1122],
            [1, 1.0, 3634, 1261, 898],
            [1, 1.0, 3732, 1261, 754],
            [1, 1.0, 3812, 1261, 712],
            [1, 1.0, 3810, 1261, 610],
            [1, 1.0, 3901.118896484375, 1261.0, 1267.69384765625],
            [1, 1.0, 3633.382568359375, 1261.0, 1017.0160522460938],
            [1, 1.0, 3707.191650390625, 1261.0, 1187.133544921875],
            [1, 1.0, 3881.731201171875, 1261.0, 697.243408203125],
            [1, 1.0, 3691.752685546875, 1261.0, 813.1149291992188],
        ],
    ),
    ColoredBananaGroup(
        group=30,
        map_id=Maps.FranticFactory,
        name="R&D in grate with 4 Chunky coins",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandDUpper,
        logic=lambda l: (l.grab and l.donkey) or l.CanPhase(),
        locations=[[5, 1.0, 4053, 1313, 784]],
    ),
    ColoredBananaGroup(
        group=31,
        map_id=Maps.FranticFactory,
        name="Tunnel from R&D room to above Power shed",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandDUpper,
        locations=[
            [1, 1.0, 4530, 1336, 936],
            [1, 1.0, 4455, 1336, 940],
            [1, 1.0, 4380, 1336, 944],
            [1, 1.0, 4305, 1336, 948],
            [1, 1.0, 4230, 1336, 952],
        ],
    ),
    ColoredBananaGroup(
        group=32,
        map_id=Maps.FranticFactory,
        name="R&D corners of room with lever",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandD,
        locations=[[5, 1.0, 3687, 1269, 1564], [5, 1.0, 3672, 1269, 1344]],
    ),
    ColoredBananaGroup(
        group=33,
        map_id=Maps.FranticFactory,
        name="Corners of Car race room (right)",
        konglist=[Kongs.tiny],
        region=Regions.FactoryTinyRaceLobby,
        logic=lambda l: l.mini or l.CanPhase(),
        locations=[[5, 1.0, 3442, 1269, 1314], [5, 1.0, 3515, 1269, 1220]],
    ),
    ColoredBananaGroup(
        group=34,
        map_id=Maps.FranticFactory,
        name="Corners of Car race room (left)",
        konglist=[Kongs.tiny],
        region=Regions.FactoryTinyRaceLobby,
        logic=lambda l: l.mini or l.CanPhase(),
        locations=[[5, 1.0, 3632, 1269, 1310], [5, 1.0, 3555, 1269, 1410]],
    ),
    ColoredBananaGroup(
        group=35,
        map_id=Maps.FranticFactory,
        name="Diddy R&D room",
        konglist=[Kongs.diddy],
        region=Regions.RandDUpper,
        logic=lambda l: l.guitar or l.CanPhase(),
        locations=[
            [1, 1.0, 4340, 1336, 680],
            [1, 1.0, 4380, 1336, 740],
            [1, 1.0, 4420, 1336, 800],
            [1, 1.0, 4480, 1336, 760],
            [1, 1.0, 4540, 1336, 720],
            [1, 1.0, 4265, 1336, 565],
            [1, 1.0, 4225, 1336, 505],
            [1, 1.0, 4185, 1336, 445],
            [1, 1.0, 4245, 1336, 405],
            [1, 1.0, 4305, 1336, 365],
        ],
    ),
    ColoredBananaGroup(
        group=36,
        map_id=Maps.FranticFactory,
        name="Diddy R&D room in front of 4 buttons",
        konglist=[Kongs.diddy],
        region=Regions.RandDUpper,
        logic=lambda l: l.guitar or l.CanPhase(),
        locations=[[5, 1.0, 4565, 1341, 273], [5, 1.0, 4593, 1341, 316], [5, 1.0, 4709, 1341, 485], [5, 1.0, 4735, 1341, 526]],
    ),
    ColoredBananaGroup(
        group=37,
        map_id=Maps.FranticFactory,
        name="Leading to Chunky R&D room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandDUpper,
        logic=lambda l: l.punch and l.chunky and l.climbing,
        locations=[[1, 1.0, 4404, 1421, 1396], [1, 1.0, 4346, 1417, 1355]],
    ),
    ColoredBananaGroup(
        group=37,
        map_id=Maps.FranticFactory,
        name="Leading to Chunky R&D room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandDUpper,
        locations=[[1, 1.0, 4288, 1417, 1314], [1, 1.0, 4230, 1417, 1273], [1, 1.0, 4192, 1380, 1251]],
    ),
    ColoredBananaGroup(
        group=38,
        map_id=Maps.FranticFactory,
        name="Chunky R&D room behind chest",
        konglist=[Kongs.chunky],
        region=Regions.RandD,
        logic=lambda l: l.CanAccessRNDRoom() or (l.punch and l.triangle and l.climbing),
        locations=[[5, 1.0, 5000, 1341, 1748], [5, 1.0, 4980, 1341, 1778]],
    ),
    ColoredBananaGroup(
        group=39,
        map_id=Maps.FranticFactory,
        name="Lanky R&D room upper 3 barrels",
        konglist=[Kongs.lanky],
        region=Regions.RandD,
        logic=lambda l: l.CanAccessRNDRoom() or l.trombone,
        locations=[[5, 1.0, 3293, 1323, 454], [5, 1.0, 3320, 1323, 415], [5, 1.0, 3348, 1323, 376]],
    ),
    ColoredBananaGroup(
        group=40,
        map_id=Maps.FranticFactory,
        name="Lanky R&D room lower 3 barrels",
        konglist=[Kongs.lanky],
        region=Regions.RandD,
        logic=lambda l: l.CanAccessRNDRoom() or l.trombone,
        locations=[[5, 1.0, 3330, 1311, 481], [5, 1.0, 3359, 1311, 444], [5, 1.0, 3386, 1311, 407]],
    ),
    ColoredBananaGroup(
        group=41,
        map_id=Maps.FranticFactory,
        name="On F Key",
        konglist=[Kongs.lanky],
        region=Regions.RandD,
        logic=lambda l: l.CanAccessRNDRoom() or l.trombone,
        locations=[[5, 1.0, 3460, 1285, 424]],
    ),
    ColoredBananaGroup(
        group=42,
        map_id=Maps.FranticFactory,
        name="Side walls of Lanky R&D room",
        konglist=[Kongs.lanky],
        region=Regions.RandD,
        logic=lambda l: l.CanAccessRNDRoom() or l.trombone,
        locations=[
            [1, 1.0, 3243, 1264, 590],
            [1, 1.0, 3281, 1264, 617],
            [1, 1.0, 3319, 1264, 643],
            [1, 1.0, 3357, 1264, 670],
            [1, 1.0, 3395, 1264, 696],
            [1, 1.0, 3638, 1264, 344],
            [1, 1.0, 3600, 1264, 316],
            [1, 1.0, 3561, 1264, 288],
            [1, 1.0, 3522, 1264, 262],
            [1, 1.0, 3483, 1264, 236],
        ],
    ),
    ColoredBananaGroup(
        group=43,
        map_id=Maps.FranticFactory,
        name="In fall from the hatch to power shed",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ChunkyRoomPlatform,
        locations=[[5, 1.0, 1448, 164, 892]],
    ),
    # ColoredBananaGroup(
    #     group=44,
    #     map_id=Maps.FranticFactory,
    #     name="On vines to Beaver Bother barrel",
    #     konglist=[Kongs.diddy],
    #     lregion=Regions.ChunkyRoomPlatform,
    #     logic=lambda l: l.CanSlamSwitch(Levels.FranticFactory, 1) and l.can_use_vines,
    #     locations=[[5, 1.0, 1327, 160, 839], [5, 1.0, 1237, 178, 840]],
    # ),
    ColoredBananaGroup(
        group=45,
        map_id=Maps.FactoryPowerHut,
        name="On box-shaped vents",
        konglist=[Kongs.donkey],
        region=Regions.PowerHut,
        locations=[[5, 1.0, 185, 42, 93], [5, 1.0, 185, 42, 116]],
    ),
    ColoredBananaGroup(
        group=46,
        map_id=Maps.FranticFactory,
        name="In Dark room on box",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        logic=lambda l: l.punch or l.CanPhase(),
        locations=[[5, 1.0, 2130, 52, 528]],
    ),
    ColoredBananaGroup(
        group=47,
        map_id=Maps.FranticFactory,
        name="On Simian Spring ledge with coins",
        konglist=[Kongs.diddy],
        region=Regions.BeyondHatch,
        logic=lambda l: ((l.spring or l.CanMoontail()) and l.isdiddy) or l.CanPhase(),
        locations=[[5, 1.0, 1072, 182, 478], [5, 1.0, 1092, 182, 478]],
    ),
    ColoredBananaGroup(
        group=48,
        map_id=Maps.FranticFactory,
        name="On box in stack of boxes to Candy/Cranky - left",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[[5, 1.0, 976, 52, 868]],
    ),
    ColoredBananaGroup(
        group=49,
        map_id=Maps.FranticFactory,
        name="On box in stack of boxes to Candy/Cranky - right",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[[5, 1.0, 972, 52, 628]],
    ),
    ColoredBananaGroup(
        group=50,
        map_id=Maps.FranticFactory,
        name="From BBlast pad to Tiny BP pole",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[
            [1, 1.0, 1294, 7, 216],
            [1, 1.0, 1294, 7, 296],
            [1, 1.0, 1294, 7, 376],
            [1, 1.0, 1294, 7, 456],
            [1, 1.0, 1294, 7, 536],
        ],
    ),
    ColoredBananaGroup(
        group=51,
        map_id=Maps.FranticFactory,
        name="From Prod room to Chunky room (1 custom, 4 Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[
            [1, 1.0, 1038, 8, 1310],
            [1, 1.0, 1292.458740234375, 6.320634365081787, 978.1195678710938],
            [1, 1.0, 1289.9219970703125, 6.295598983764648, 1168.0338134765625],
            [1, 1.0, 1176.5501708984375, 6.483366012573242, 1310.6490478515625],
            [1, 1.0, 1292.2669677734375, 6.333333492279053, 1302.4984130859375],
        ],
    ),
    ColoredBananaGroup(
        group=52,
        map_id=Maps.FranticFactory,
        name="Bottom of production room (3 custom, 12 Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[
            [1, 1.0, 344, 0, 1434],
            [1, 1.0, 540, 0, 1076],
            [1, 1.0, 844, 0, 1148],
            [1, 1.0, 353.6761474609375, 7.0, 1333.6446533203125],
            [1, 1.0, 788.5835571289062, 0, 1579.6070556640625],
            [1, 1.0, 626.1305541992188, 0, 1601.9178466796875],
            [1, 1.0, 504.216552734375, 0, 1590.93701171875],
            [1, 1.0, 397.0317687988281, 0, 1504.6707763671875],
            [1, 1.0, 886.3936157226562, 0, 1226.4381103515625],
            [1, 1.0, 634.0552368164062, 0, 1078.4891357421875],
            [1, 1.0, 788.5068359375, 0, 1100.0301513671875],
            [1, 1.0, 476.7261962890625, 0, 1098.4151611328125],
            [1, 1.0, 916.1127319335938, 8.0, 1335.650634765625],
            [1, 1.0, 881.6343383789062, 0, 1476.0279541015625],
            [1, 1.0, 357.8980712890625, 0, 1189.2847900390625],
        ],
    ),
    ColoredBananaGroup(
        group=53,
        map_id=Maps.FranticFactory,
        name="Prod room Chunky switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[[5, 1.0, 875, 10, 1064]],
    ),
    ColoredBananaGroup(
        group=54,
        map_id=Maps.FranticFactory,
        name="Prod room Diddy switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[[5, 1.0, 365, 10, 1092]],
    ),
    ColoredBananaGroup(
        group=55,
        map_id=Maps.FranticFactory,
        name="Prod room Lanky switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[[5, 1.0, 357, 10, 1561]],
    ),
    ColoredBananaGroup(
        group=56,
        map_id=Maps.FranticFactory,
        name="Prod room Tiny switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[[5, 1.0, 891, 10, 1582]],
    ),
    ColoredBananaGroup(
        group=57,
        map_id=Maps.FranticFactory,
        name="Prod room from elevator to center",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCore,
        locations=[
            [1, 1.0, 410, 137, 1642],
            [1, 1.0, 434, 147, 1664],
            [1, 1.0, 456, 157, 1684],
            [1, 1.0, 525, 157, 1690],
            [1, 1.0, 596, 157, 1680],
            [1, 1.0, 660, 157, 1678],
            [1, 1.0, 738, 157, 1664],
            [1, 1.0, 812, 157, 1616],
            [1, 1.0, 853, 157, 1573],
            [1, 1.0, 887, 157, 1504],
            [1, 1.0, 881, 154, 1441],
            [1, 1.0, 903, 154, 1398],
            [1, 1.0, 899, 155, 1336],
            [1, 1.0, 842, 151, 1335],
            [1, 1.0, 785, 155, 1335],
        ],
    ),
    ColoredBananaGroup(
        group=58,
        map_id=Maps.FranticFactory,
        name="Prod room around center piece (lower floor)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MiddleCore,
        locations=[
            [1, 1.0, 738, 188, 1334],
            [1, 1.0, 738, 188, 1375],
            [1, 1.0, 724, 188, 1424],
            [1, 1.0, 670, 188, 1447],
            [1, 1.0, 620, 188, 1447],
            [1, 1.0, 569, 188, 1446],
            [1, 1.0, 530, 188, 1420],
            [1, 1.0, 516, 188, 1369],
            [1, 1.0, 516, 188, 1310],
            [1, 1.0, 516, 188, 1260],
            [1, 1.0, 553, 188, 1226],
            [1, 1.0, 604, 188, 1220],
            [1, 1.0, 658, 188, 1220],
            [1, 1.0, 711, 188, 1228],
            [1, 1.0, 738, 188, 1272],
        ],
    ),
    ColoredBananaGroup(
        group=59,
        map_id=Maps.FranticFactory,
        name="Prod room around center piece (higher floor)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.SpinningCore,
        locations=[
            [1, 1.0, 646, 309, 1397],
            [1, 1.0, 693, 309, 1377],
            [1, 1.0, 693, 309, 1333],
            [1, 1.0, 693, 309, 1289],
            [1, 1.0, 646, 309, 1269],
            [1, 1.0, 604, 309, 1269],
            [1, 1.0, 560, 309, 1289],
            [1, 1.0, 560, 309, 1333],
            [1, 1.0, 560, 309, 1377],
            [1, 1.0, 604, 309, 1397],
        ],
    ),
    ColoredBananaGroup(
        group=60,
        map_id=Maps.FranticFactory,
        name="Prod room on spinning cylinder out from center piece",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.SpinningCore,
        locations=[
            [1, 1.0, 630, 309, 1209],
            [1, 1.0, 630, 309, 1155],
            [1, 1.0, 630, 309, 1101],
            [1, 1.0, 630, 309, 1047],
            [1, 1.0, 630, 309, 993],
        ],
    ),
    ColoredBananaGroup(
        group=61,
        map_id=Maps.FranticFactory,
        name="Bunches on W4",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.SpinningCore,
        locations=[[5, 1.0, 908, 436, 1534]],
    ),
    ColoredBananaGroup(
        group=61,
        map_id=Maps.FranticFactory,
        name="Bunches on W4",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[[5, 1.0, 916, 15, 1331]],
    ),
    ColoredBananaGroup(
        group=62,
        map_id=Maps.FranticFactory,
        name="Prod room upper level from elevators to spinning cylinders",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCore,
        locations=[
            [1, 1.0, 960, 605, 1197],
            [1, 1.0, 914, 605, 1161],
            [1, 1.0, 868, 605, 1125],
            [1, 1.0, 822, 605, 1089],
            [1, 1.0, 776, 605, 1053],
            [1, 1.0, 710, 605, 1049],
            [1, 1.0, 644, 605, 1044],
            [1, 1.0, 578, 605, 1039],
            [1, 1.0, 512, 605, 1034],
            [1, 1.0, 464, 605, 1064],
            [1, 1.0, 415, 605, 1094],
            [1, 1.0, 366, 605, 1124],
            [1, 1.0, 324, 605, 1186],
            [1, 1.0, 298, 605, 1241],
            [1, 1.0, 294, 605, 1304],
        ],
    ),
    ColoredBananaGroup(
        group=63,
        map_id=Maps.FranticFactory,
        name="Prod room below Tiny conveyors",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCore,
        locations=[[5, 1.0, 783, 683, 972], [5, 1.0, 472, 683, 972]],
    ),
    ColoredBananaGroup(
        group=64,
        map_id=Maps.FranticFactory,
        name="Prod room on box-shaped vents below the upper level",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCore,
        locations=[[5, 1.0, 274, 484, 1484], [5, 1.0, 274, 372, 1176], [5, 1.0, 987, 332, 1176]],
    ),
    ColoredBananaGroup(
        group=65,
        map_id=Maps.FranticFactory,
        name="From long pole to prod room (4 custom, 6 Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[
            [1, 1.0, 236, 7, 1346],
            [1, 1.0, 150, 7, 1346],
            [1, 1.0, 64, 7, 1346],
            [1, 1.0, 64, 94, 1926],
            [1, 1.0, 176.51025390625, 99.96085357666016, 1933.923828125],
            [1, 1.0, 67.12920379638672, 84.7029800415039, 1805.5093994140625],
            [1, 1.0, 287.1856689453125, 129.66278076171875, 1935.6805419921875],
            [1, 1.0, 419.18310546875, 164.7201385498047, 1937.3157958984375],
            [1, 1.0, 66.03046417236328, 47.04559326171875, 1625.56640625],
            [1, 1.0, 67.29706573486328, 13.427433967590332, 1467.4581298828125],
        ],
    ),
    ColoredBananaGroup(
        group=66,
        map_id=Maps.FranticFactory,
        name="Bottom of long pole around room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[
            [1, 1.0, 558, 168, 1765],
            [1, 1.0, 489, 168, 1813],
            [1, 1.0, 500, 168, 2023],
            [1, 1.0, 562, 168, 2023],
            [1, 1.0, 624, 168, 2023],
            [1, 1.0, 686, 168, 2023],
            [1, 1.0, 686, 168, 1963],
            [1, 1.0, 686, 168, 1903],
            [1, 1.0, 686, 168, 1843],
            [1, 1.0, 686, 168, 1783],
        ],
    ),
    ColoredBananaGroup(
        group=67,
        map_id=Maps.FranticFactory,
        name="Pole room to arcade",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FactoryArcadeTunnel,
        locations=[[5, 1.0, 1210, 1112, 984], [5, 1.0, 1352, 1112, 990]],
    ),
    ColoredBananaGroup(
        group=68,
        map_id=Maps.FranticFactory,
        name="Pole room to arcade around pole",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FactoryArcadeTunnel,
        locations=[
            [1, 1.0, 1204, 1107, 844],
            [1, 1.0, 1202, 1107, 890],
            [1, 1.0, 1215, 1107, 940],
            [1, 1.0, 1260, 1107, 990],
            [1, 1.0, 1310, 1107, 967],
            [1, 1.0, 1351, 1107, 924],
            [1, 1.0, 1365, 1107, 872],
            [1, 1.0, 1338, 1107, 832],
            [1, 1.0, 1296, 1107, 813],
            [1, 1.0, 1240, 1107, 817],
        ],
    ),
    ColoredBananaGroup(
        group=69,
        map_id=Maps.FranticFactory,
        name="Tunnel to Stash Snatch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FactoryArcadeTunnel,
        locations=[
            [1, 1.0, 1275, 1107, 1408],
            [1, 1.0, 1274, 1107, 1482],
            [1, 1.0, 1273, 1107, 1557],
            [1, 1.0, 1272, 1107, 1632],
            [1, 1.0, 1271, 1107, 1708],
        ],
    ),
    ColoredBananaGroup(
        group=70,
        map_id=Maps.FranticFactory,
        name="Stash Snatch room",
        konglist=[Kongs.chunky],
        region=Regions.FactoryArcadeTunnel,
        logic=lambda l: l.punch,
        locations=[[5, 1.0, 1340, 1112, 1762], [5, 1.0, 1202, 1112, 1754]],
    ),
    ColoredBananaGroup(
        group=71,
        map_id=Maps.FranticFactory,
        name="Under W5 table",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FactoryArcadeTunnel,
        locations=[[5, 1.0, 1790, 1110, 1372]],
    ),
    ColoredBananaGroup(
        group=72,
        map_id=Maps.FranticFactory,
        name="Under table to Mini Monkey GB",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FactoryArcadeTunnel,
        locations=[[5, 1.0, 1812, 1110, 1520], [5, 1.0, 1852, 1110, 1520], [5, 1.0, 1892, 1110, 1520]],
    ),
    ColoredBananaGroup(
        group=73,
        map_id=Maps.FranticFactory,
        name="On table to Mini Monkey GB",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FactoryArcadeTunnel,
        locations=[[5, 1.0, 1925, 1149, 1515], [5, 1.0, 1748, 1193, 1525]],
    ),
    ColoredBananaGroup(
        group=74,
        map_id=Maps.FranticFactory,
        name="On DK Arcade",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FactoryArcadeTunnel,
        locations=[[5, 1.0, 1862, 1172, 1228]],
    ),
    ColoredBananaGroup(
        group=75,
        map_id=Maps.FranticFactory,
        name="Tunnel to DK Arcade (5 custom, 5 Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FactoryArcadeTunnel,
        locations=[
            [1, 1.0, 1682, 1107, 1372],
            [1, 1.0, 1512, 1107, 1370],
            [1, 1.0, 1358, 1107, 1368],
            [1, 1.0, 1278, 1107, 1282],
            [1, 1.0, 1278, 1107, 1108],
            [1, 1.0, 1271.2330322265625, 1106.447021484375, 1364.8533935546875],
            [1, 1.0, 1277.8587646484375, 1106.6650390625, 1187.0267333984375],
            [1, 1.0, 1416.66748046875, 1106.657958984375, 1371.5650634765625],
            [1, 1.0, 1596.6556396484375, 1106.6666259765625, 1372.5570068359375],
            [1, 1.0, 1285.6282958984375, 1106.353515625, 1017.747802734375],
        ],
    ),
    ColoredBananaGroup(
        group=76,
        map_id=Maps.FranticFactory,
        name="Funky room boxes on left",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[[5, 1.0, 1296, 1159, 602], [5, 1.0, 1468, 1134, 768]],
    ),
    ColoredBananaGroup(
        group=77,
        map_id=Maps.FranticFactory,
        name="Funky room on high boxes",
        konglist=[Kongs.diddy, Kongs.tiny],
        region=Regions.Testing,
        locations=[[5, 1.0, 1498, 1219, 790]],
    ),
    ColoredBananaGroup(
        group=78,
        map_id=Maps.FranticFactory,
        name="Around Funky platform",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[[5, 1.0, 1580, 1120, 611], [5, 1.0, 1472, 1120, 666], [5, 1.0, 1622, 1120, 492]],
    ),
    ColoredBananaGroup(
        group=79,
        map_id=Maps.FranticFactory,
        name="Funky's room boxes on right",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[[5, 1.0, 1574, 1159, 362], [5, 1.0, 1752, 1159, 526]],
    ),
    ColoredBananaGroup(
        group=80,
        map_id=Maps.FranticFactory,
        name="Tunnel to Funky's room (2 custom, 3 Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[
            [1, 1.0, 1809, 1114, 832],
            [1, 1.0, 1929, 1114, 954],
            [1, 1.0, 1987.3868408203125, 1113.0771484375, 1008.6240844726562],
            [1, 1.0, 1876.5101318359375, 1113.3311767578125, 898.8901977539062],
            [1, 1.0, 1753.6839599609375, 1113.2442626953125, 777.5462036132812],
        ],
    ),
    ColoredBananaGroup(
        group=81,
        map_id=Maps.FranticFactory,
        name="Funky's room around Funky's platform",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[
            [1, 1.0, 1524, 1114, 359],
            [1, 1.0, 1575, 1114, 399],
            [1, 1.0, 1616, 1114, 439],
            [1, 1.0, 1625, 1114, 537],
            [1, 1.0, 1588, 1114, 580],
            [1, 1.0, 1550, 1114, 623],
            [1, 1.0, 1512, 1114, 666],
            [1, 1.0, 1410, 1114, 666],
            [1, 1.0, 1363, 1114, 621],
            [1, 1.0, 1316, 1114, 576],
        ],
    ),
    ColoredBananaGroup(
        group=82,
        map_id=Maps.FranticFactory,
        name="Bunches around Funky's store",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[[5, 1.0, 1372, 1137, 556], [5, 1.0, 1496, 1137, 590], [5, 1.0, 1552, 1137, 516]],
    ),
    ColoredBananaGroup(
        group=83,
        map_id=Maps.FranticFactory,
        name="Production room spinning arms, inside ring (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.SpinningCore,
        vanilla=True,
        locations=[
            [5, 1.0, 740.1113891601562, 428.0, 1333.6373291015625],
            [5, 1.0, 483.6172790527344, 428.7723388671875, 1335.5596923828125],
        ],
    ),
    ColoredBananaGroup(
        group=84,
        map_id=Maps.FranticFactory,
        name="Production room spinning arms, outside ring (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.SpinningCore,
        vanilla=True,
        locations=[
            [5, 1.0, 889.6050415039062, 428.30029296875, 1334.5589599609375],
            [5, 1.0, 354.6239318847656, 428.0, 1335.3211669921875],
        ],
    ),
    ColoredBananaGroup(
        group=85,
        map_id=Maps.FranticFactory,
        name="Dark room above moving platforms (Chunky)",
        konglist=[Kongs.chunky],
        region=Regions.BeyondHatch,
        vanilla=True,
        logic=lambda l: l.punch,
        locations=[
            [5, 1.0, 1960.4481201171875, 106.5, 584.5081787109375],
            [5, 1.0, 1961.8372802734375, 126.5, 677.7713012695312],
            [5, 1.0, 1952.3826904296875, 136.5, 768.63232421875],
        ],
    ),
    ColoredBananaGroup(
        group=86,
        map_id=Maps.FranticFactory,
        name="Tunnel from entrance to hatch (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        vanilla=True,
        locations=[
            [1, 1.0, 763.54931640625, 803.3333129882812, 2374.302001953125],
            [1, 1.0, 847.5364379882812, 803.3123168945312, 2454.430908203125],
            [1, 1.0, 962.6754760742188, 819.6641235351562, 2504.7275390625],
            [1, 1.0, 651.3635864257812, 804.157470703125, 2130.60693359375],
            [1, 1.0, 668.0018920898438, 803.36328125, 2266.045654296875],
        ],
    ),
    ColoredBananaGroup(
        group=87,
        map_id=Maps.FranticFactory,
        name="Block tower (set of 3 bunches) (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.Testing,
        vanilla=True,
        logic=lambda l: l.spring or l.CanMoontail(),
        locations=[
            [5, 1.0, 2334.96826171875, 1120.81298828125, 1253.9190673828125],
            [5, 1.0, 2460.02587890625, 1474.8333740234375, 1258.8880615234375],
            [5, 1.0, 2411.53466796875, 1354.8333740234375, 1259.6536865234375],
        ],
    ),
    ColoredBananaGroup(
        group=88,
        map_id=Maps.FranticFactory,
        name="Block tower (set of 2 bunches) (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.Testing,
        vanilla=True,
        logic=lambda l: l.spring or l.CanMoontail(),
        locations=[
            [5, 1.0, 2340.177490234375, 1192.8333740234375, 1337.7464599609375],
            [5, 1.0, 2501.7470703125, 1392.8333740234375, 1342.0328369140625],
        ],
    ),
    ColoredBananaGroup(
        group=89,
        map_id=Maps.FranticFactory,
        name="W5 (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        vanilla=True,
        locations=[[5, 1.0, 1622.599609375, 1125.1666259765625, 643.2669677734375]],
    ),
    ColoredBananaGroup(
        group=89,
        map_id=Maps.FranticFactory,
        name="W5 (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        vanilla=True,
        locations=[[5, 1.0, 1807.6861572265625, 1150.8333740234375, 1373.5850830078125]],
    ),
    ColoredBananaGroup(
        group=90,
        map_id=Maps.FranticFactory,
        name="Prod room rotating cylinders (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCore,
        vanilla=True,
        locations=[
            [5, 1.0, 540.67431640625, 623.0, 1692.7386474609375],
            [5, 1.0, 376.5771484375, 615.0, 1563.20947265625],
            [5, 1.0, 302.7023010253906, 615.0, 1410.3233642578125],
        ],
    ),
    ColoredBananaGroup(
        group=91,
        map_id=Maps.FranticFactory,
        name="R&D upper walkway (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandDUpper,
        vanilla=True,
        locations=[
            [1, 1.0, 3983.73828125, 1336.0, 714.7798461914062],
            [1, 1.0, 4086.731201171875, 1336.0, 826.6878051757812],
            [1, 1.0, 4153.29345703125, 1336.0, 995.606689453125],
            [1, 1.0, 4123.34619140625, 1333.0, 1162.5694580078125],
            [1, 1.0, 4031.6806640625, 1336.0, 1238.927490234375],
        ],
    ),
    ColoredBananaGroup(
        group=92,
        map_id=Maps.FranticFactory,
        name="Path from stack of boxes to Candy & Cranky (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        vanilla=True,
        locations=[
            [1, 1.0, 629.0328979492188, 165.91612243652344, 727.03125],
            [1, 1.0, 946.8685913085938, 166.47434997558594, 730.9727172851562],
            [1, 1.0, 786.7265014648438, 166.3333282470703, 729.853515625],
            [1, 1.0, 397.683837890625, 177.39886474609375, 727.379638671875],
            [1, 1.0, 296.029296875, 217.748291015625, 726.2611694335938],
        ],
    ),
    ColoredBananaGroup(
        group=93,
        map_id=Maps.FranticFactory,
        name="Pipe in corner of Chunky's room (Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.FactoryStoragePipe,
        vanilla=True,
        locations=[
            [1, 1.0, 1612.77197265625, 209.3333282470703, 484.9771728515625],
            [1, 1.0, 1543.5341796875, 193.69114685058594, 490.4968566894531],
            [1, 1.0, 1503.2747802734375, 158.1122283935547, 492.1888732910156],
            [1, 1.0, 1475.77587890625, 110.58588409423828, 490.0295104980469],
        ],
    ),
    ColoredBananaGroup(
        group=93,
        map_id=Maps.FranticFactory,
        name="Pipe in corner of Chunky's room (Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.BeyondHatch,
        vanilla=True,
        locations=[[1, 1.0, 1451.1593017578125, 67.33332824707031, 490.5133056640625]],
    ),
    ColoredBananaGroup(
        group=94,
        map_id=Maps.FranticFactory,
        name="Pipe at the top of Prod room (Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.UpperCore,
        vanilla=True,
        logic=lambda l: l.handstand or l.CanPhase(),
        locations=[
            [5, 1.0, 948.8671875, 818.39599609375, 1477.1390380859375],
            [5, 1.0, 847.3552856445312, 770.4682006835938, 1490.0218505859375],
            [5, 1.0, 783.449462890625, 704.2567749023438, 1524.0718994140625],
            [5, 1.0, 717.9872436523438, 649.302734375, 1569.759765625],
        ],
    ),
    ColoredBananaGroup(
        group=94,
        map_id=Maps.FranticFactory,
        name="Pipe at the top of Prod room (Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.UpperCore,
        vanilla=True,
        locations=[[5, 1.0, 657.2835083007812, 604.8435668945312, 1653.2054443359375]],
    ),
    ColoredBananaGroup(
        group=95,
        map_id=Maps.FranticFactory,
        name="Prod room on the middle steps between rotating cylinders and the spinning arms (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.SpinningCore,
        vanilla=True,
        locations=[
            [5, 1.0, 551.6519165039062, 317.6666564941406, 996.9663696289062],
            [5, 1.0, 431.9739685058594, 379.1558837890625, 1061.8323974609375],
            [5, 1.0, 339.6698913574219, 429.8802185058594, 1146.26416015625],
        ],
    ),
    ColoredBananaGroup(
        group=96,
        map_id=Maps.FranticFactory,
        name="W2 (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandD,
        vanilla=True,
        locations=[[5, 1.0, 3800.656005859375, 1279.0, 1147.1461181640625]],
    ),
    ColoredBananaGroup(
        group=96,
        map_id=Maps.FranticFactory,
        name="W2 (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        vanilla=True,
        locations=[[5, 1.0, 1373.3612060546875, 860.6666870117188, 2504.092529296875]],
    ),
    ColoredBananaGroup(
        group=97,
        map_id=Maps.FranticFactory,
        name="Tunnel from starting room towards Testing (2 custom, 3 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        vanilla=True,
        locations=[
            [1, 1.0, 1512.7220458984375, 837.0, 2509.02978515625],
            [1, 1.0, 1645.29150390625, 837.0, 2463.952880859375],
            [1, 1.0, 1722.1805419921875, 836.9647827148438, 2393.843505859375],
            [1, 1.0, 1808, 849, 2390],
            [1, 1.0, 1715, 837, 2330],
        ],
    ),
    ColoredBananaGroup(
        group=98,
        map_id=Maps.FranticFactory,
        name="Tunnel from pole past blue switch gate to T junction (3 custom, 2 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        vanilla=True,
        locations=[
            [1, 1.0, 2017.6278076171875, 1026.1666259765625, 2224.815185546875],
            [1, 1.0, 2019.4151611328125, 1026.1666259765625, 2071.315673828125],
            [1, 1.0, 2018, 1026, 2140],
            [1, 1.0, 2018, 1026, 2000],
            [1, 1.0, 2018, 1026, 1950],
        ],
    ),
    ColoredBananaGroup(
        group=99,
        map_id=Maps.FranticFactory,
        name="Tunnel from T junction to block tower (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        vanilla=True,
        locations=[
            [1, 1.0, 2142.112548828125, 1026.164306640625, 1924.0523681640625],
            [1, 1.0, 2264.905517578125, 1026.1666259765625, 1928.5286865234375],
            [1, 1.0, 2393.48486328125, 1025.7698974609375, 1933.2158203125],
            [1, 1.0, 2415.376220703125, 1026.4959716796875, 1813.3853759765625],
            [1, 1.0, 2418.752685546875, 1026.4254150390625, 1655.2547607421875],
        ],
    ),
    ColoredBananaGroup(
        group=100,
        map_id=Maps.FranticFactory,
        name="Tunnel to Car race (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandD,
        vanilla=True,
        locations=[
            [1, 1.0, 3905.2041015625, 1263.7860107421875, 1695.5986328125],
            [1, 1.0, 3882.6455078125, 1264.0, 1830.1141357421875],
            [1, 1.0, 3795.470458984375, 1263.8236083984375, 1930.0062255859375],
            [1, 1.0, 3673.251953125, 1263.982177734375, 1986.0234375],
            [1, 1.0, 3566.732666015625, 1263.8333740234375, 1994.4442138671875],
            [1, 1.0, 3469.451416015625, 1264.0, 1814.7056884765625],
            [1, 1.0, 3497.5791015625, 1264.0, 1664.1314697265625],
            [1, 1.0, 3604.471435546875, 1264.0025634765625, 1529.27490234375],
            [1, 1.0, 3906.136474609375, 1264.0, 1580.1553955078125],
            [1, 1.0, 3480.614013671875, 1263.8333740234375, 1978.9749755859375],
        ],
    ),
    ColoredBananaGroup(
        group=101,
        map_id=Maps.FranticFactory,
        name="Prod room on conveyors to bonus barrel (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCore,
        vanilla=True,
        locations=[
            [5, 1.0, 559.0079956054688, 805.0, 969.701171875],
            [5, 1.0, 889.0130004882812, 700.0, 1065.2659912109375],
            [5, 1.0, 731.421630859375, 785.0, 979.9063110351562],
            [5, 1.0, 405.4700927734375, 855.0, 1040.4110107421875],
        ],
    ),
    ColoredBananaGroup(
        group=102,
        map_id=Maps.FranticFactory,
        name="Prod room on far platform past Bonus Barrel (Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.UpperCore,
        vanilla=True,
        logic=lambda l: l.twirl,
        locations=[[5, 1.0, 386.4722900390625, 861.5, 1598.4136962890625]],
    ),
    ColoredBananaGroup(
        group=103,
        map_id=Maps.FranticFactory,
        name="Arcade room, by Mini Monkey tunnel (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FactoryArcadeTunnel,
        vanilla=True,
        locations=[[5, 1.0, 1798.70751953125, 1192.0, 1525.5546875]],
    ),
    ColoredBananaGroup(
        group=104,
        map_id=Maps.FranticFactory,
        name="In Spinning wheel room (Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.Testing,
        vanilla=True,
        logic=lambda l: l.mini or l.CanPhase(),
        locations=[[5, 1.0, 2479.365234375, 1106.81640625, 850.234130859375]],
    ),
    ColoredBananaGroup(
        group=105,
        map_id=Maps.FranticFactory,
        name="By middle window outside of production room (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AlcoveBeyondHatch,
        vanilla=True,
        locations=[
            [5, 1.0, 598.0451049804688, 459.3333435058594, 1745.70458984375],
            [5, 1.0, 686.716552734375, 459.3333435058594, 1749.0380859375],
        ],
    ),
    ColoredBananaGroup(
        group=106,
        map_id=Maps.FranticFactory,
        name="On pole down hatch (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        vanilla=True,
        logic=lambda l: Events.HatchOpened in l.Events,
        locations=[
            [1, 1.0, 635.0736083984375, 717.8333129882812, 1891.0057373046875],
            [1, 1.0, 634.122802734375, 417.83331298828125, 1896.0335693359375],
            [1, 1.0, 634.122802734375, 517.8333129882812, 1893.46630859375],
            [1, 1.0, 634.122802734375, 617.8333129882812, 1890.5869140625],
            [1, 1.0, 634.7103271484375, 667.8333129882812, 1890.17236328125],
            [1, 1.0, 635.4014282226562, 767.8333129882812, 1891.0389404296875],
            [1, 1.0, 634.122802734375, 567.8333129882812, 1892.01123046875],
            [1, 1.0, 634.122802734375, 467.83331298828125, 1894.4410400390625],
            [1, 1.0, 634.122802734375, 367.83331298828125, 1897.1483154296875],
            [1, 1.0, 634.122802734375, 317.83331298828125, 1898.1036376953125],
        ],
    ),
    ColoredBananaGroup(
        group=107,
        map_id=Maps.FranticFactory,
        name="Chunky R&D room left side (Chunky)",
        konglist=[Kongs.chunky],
        region=Regions.RandDUpper,
        vanilla=True,
        logic=lambda l: (l.punch and l.triangle and l.climbing) or l.CanAccessRNDRoom(),
        locations=[
            [1, 1.0, 4655.8388671875, 1339.0, 1240.5621337890625],
            [1, 1.0, 4767.98388671875, 1339.0, 1316.2774658203125],
            [1, 1.0, 4967.30126953125, 1339.0, 1456.23388671875],
            [1, 1.0, 5080.56689453125, 1339.0, 1534.8184814453125],
            [1, 1.0, 4860.52099609375, 1339.0, 1379.9078369140625],
        ],
    ),
    ColoredBananaGroup(
        group=108,
        map_id=Maps.FranticFactory,
        name="Chunky R&D room right side (Chunky)",
        konglist=[Kongs.chunky],
        region=Regions.RandDUpper,
        vanilla=True,
        logic=lambda l: (l.punch and l.triangle and l.climbing) or l.CanAccessRNDRoom(),
        locations=[
            [1, 1.0, 4385.7177734375, 1339.0, 1695.80419921875],
            [1, 1.0, 4492.11083984375, 1339.0, 1768.3846435546875],
            [1, 1.0, 4590.28857421875, 1339.0, 1837.7354736328125],
            [1, 1.0, 4686.16064453125, 1339.0, 1903.7115478515625],
            [1, 1.0, 4793.607421875, 1339.0, 1975.6563720703125],
        ],
    ),
    ColoredBananaGroup(
        group=109,
        map_id=Maps.FranticFactory,
        name="W1 (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        vanilla=True,
        locations=[[5, 1.0, 1152.5001220703125, 860.6666870117188, 2502.669677734375]],
    ),
    ColoredBananaGroup(
        group=109,
        map_id=Maps.FranticFactory,
        name="W1 (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        vanilla=True,
        locations=[[5, 1.0, 1575.7498779296875, 21.5, 520.7964477539062]],
    ),
    ColoredBananaGroup(
        group=110,
        map_id=Maps.FactoryPowerHut,
        name="On boxes in corners (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.PowerHut,
        vanilla=True,
        locations=[
            [5, 1.0, 186.18470764160156, 26.33333396911621, 52.53104019165039],
            [5, 1.0, 185.98797607421875, 31.66666603088379, 172.21888732910156],
            [5, 1.0, 51.3305549621582, 21.0, 177.4900360107422],
        ],
    ),
    ColoredBananaGroup(
        group=111,
        map_id=Maps.FactoryCrusher,
        name="On conveyors (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.InsideCore,
        vanilla=True,
        logic=lambda l: l.strongKong,
        locations=[
            [5, 1.0, 303.0682373046875, 15.0, 459.1358642578125],
            [5, 1.0, 121.00019073486328, 15.0, 465.156494140625],
            [5, 1.0, 118.80945587158203, 15.0, 289.1971435546875],
        ],
    ),
    ColoredBananaGroup(
        group=112,
        map_id=Maps.FactoryBaboonBlast,
        name="Baboon Blast group 1 (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.FactoryBaboonBlast,
        vanilla=True,
        locations=[
            [5, 1.0, 878.044921875, 722.0, 1174.5888671875],
            [5, 1.0, 1254.5228271484375, 734.0, 1300.882568359375],
        ],
    ),
    ColoredBananaGroup(
        group=113,
        map_id=Maps.FactoryBaboonBlast,
        name="Baboon Blast group 2 (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.FactoryBaboonBlast,
        vanilla=True,
        locations=[
            [5, 1.0, 623.1658325195312, 719.0, 1043.0872802734375],
            [5, 1.0, 999.823486328125, 573.0, 1446.8406982421875],
        ],
    ),
    # Wave 2 by Snap
    ColoredBananaGroup(
        group=114,
        map_id=Maps.FranticFactory,
        name="Entrance portal",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        locations=[[1, 1.0, 1343, 830, 2688], [1, 1.0, 1302, 830, 2688], [1, 1.0, 1262, 830, 2688], [1, 1.0, 1221, 830, 2688], [1, 1.0, 1181, 830, 2688]],
    ),
    ColoredBananaGroup(
        group=115,
        map_id=Maps.FranticFactory,
        name="Lobby factory-map",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        locations=[[5, 1.0, 1094, 875, 2361]],
    ),
    ColoredBananaGroup(
        group=116,
        map_id=Maps.FranticFactory,
        name="Krem Co. clock",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        locations=[[5, 1.0, 1263, 910, 2055]],
    ),
    ColoredBananaGroup(
        group=117,
        map_id=Maps.FranticFactory,
        name="Windows of the hatch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        locations=[
            [5, 1.0, 645, 850, 1733],
            [5, 1.0, 643, 490, 1731],
            [5, 1.0, 641, 215, 1734],
        ],
    ),
    ColoredBananaGroup(
        group=118,
        map_id=Maps.FranticFactory,
        name="Production factory-map",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[[5, 1.0, 435, 23, 1333]],
    ),
    ColoredBananaGroup(
        group=119,
        map_id=Maps.FranticFactory,
        name="Production Reject line",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[[1, 1.0, 628, 26, 1518], [1, 1.0, 628, 26, 1560], [1, 1.0, 628, 26, 1603], [1, 1.0, 628, 26, 1645], [1, 1.0, 628, 26, 1687]],
    ),
    ColoredBananaGroup(
        group=120,
        map_id=Maps.FranticFactory,
        name="Production Accept line",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[[1, 1.0, 628, 26, 1148], [1, 1.0, 628, 26, 1104], [1, 1.0, 628, 26, 1059], [1, 1.0, 628, 26, 1015], [1, 1.0, 628, 26, 971]],
    ),
    ColoredBananaGroup(
        group=121,
        map_id=Maps.FranticFactory,
        name="In front of the crusher entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[
            [1, 1.0, 837, 8, 1333],
            [1, 1.0, 852, 8, 1333],
            [1, 1.0, 837, 8, 1318],
            [1, 1.0, 822, 8, 1333],
            [1, 1.0, 837, 8, 1348],
        ],
    ),
    ColoredBananaGroup(
        group=122,
        map_id=Maps.FranticFactory,
        name="In the big piston",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.SpinningCore,
        logic=lambda l: Events.MainCoreActivated in l.Events,
        locations=[[5, 1.2, 620, 470, 1331]],
    ),
    ColoredBananaGroup(
        group=123,
        map_id=Maps.FranticFactory,
        name="First elevator to upper production room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.SpinningCore,
        locations=[[1, 1.0, 1002, 367, 1353], [1, 1.0, 1002, 397, 1353], [1, 1.0, 1002, 427, 1353], [1, 1.0, 1002, 457, 1353], [1, 1.0, 1002, 487, 1353]],
    ),
    ColoredBananaGroup(
        group=124,
        map_id=Maps.FranticFactory,
        name="Second elevator to upper production room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.SpinningCore,
        locations=[[1, 1.0, 996, 428, 1296], [1, 1.0, 996, 458, 1296], [1, 1.0, 996, 488, 1296], [1, 1.0, 996, 518, 1296], [1, 1.0, 996, 548, 1296]],
    ),
    ColoredBananaGroup(
        group=125,
        map_id=Maps.FranticFactory,
        name="Third elevator to upper production room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCore,
        locations=[[1, 1.0, 1001, 495, 1241], [1, 1.0, 1001, 525, 1241], [1, 1.0, 1001, 555, 1241], [1, 1.0, 1001, 584, 1241], [1, 1.0, 1001, 614, 1241]],
    ),
    ColoredBananaGroup(
        group=126,
        map_id=Maps.FranticFactory,
        name="Upper production tag barrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCore,
        locations=[
            [1, 1.0, 625, 605, 1001],
            [1, 1.0, 640, 605, 1001],
            [1, 1.0, 625, 605, 986],
            [1, 1.0, 610, 605, 1001],
            [1, 1.0, 625, 605, 1016],
        ],
    ),
    ColoredBananaGroup(
        group=127, map_id=Maps.FranticFactory, name="Spring jump in upper production", konglist=[Kongs.diddy], region=Regions.UpperCore, logic=lambda l: l.spring, locations=[[5, 1.0, 585, 720, 1628]]
    ),
    ColoredBananaGroup(
        group=128,
        map_id=Maps.FranticFactory,
        name="Twirl from Tiny's highest spot in production to a very cursed vent",  # Hard
        konglist=[Kongs.tiny],
        region=Regions.UpperCore,
        logic=lambda l: l.twirl,
        locations=[
            [5, 1.0, 755, 745, 1677],
            [5, 1.0, 792, 745, 1659],
        ],
    ),
    ColoredBananaGroup(
        group=129,
        map_id=Maps.FranticFactory,
        name="On the vent right under Lanky's pipe",
        konglist=[Kongs.lanky],
        region=Regions.UpperCore,
        logic=lambda l: l.handstand,
        locations=[
            [1, 1.0, 985, 677, 1479],
            [1, 1.0, 1000, 677, 1479],
            [1, 1.0, 985, 677, 1464],
            [1, 1.0, 970, 677, 1479],
            [1, 1.0, 985, 677, 1494],
        ],
    ),
    ColoredBananaGroup(
        group=130,
        map_id=Maps.FranticFactory,
        name="Storage factory-map",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[[5, 1.0, 1539, 26, 914]],
    ),
    ColoredBananaGroup(
        group=131,
        map_id=Maps.FranticFactory,
        name="On the door frame to arcade",
        konglist=[Kongs.diddy],
        region=Regions.BeyondHatch,
        logic=lambda l: l.spring,
        locations=[[1, 1.0, 1248, 98, 476], [1, 1.0, 1266, 106, 476], [1, 1.0, 1292, 116, 476], [1, 1.0, 1314, 108, 476], [1, 1.0, 1335, 99, 476]],
    ),
    ColoredBananaGroup(
        group=132,
        map_id=Maps.FranticFactory,
        name="Boxes near the storage pipe",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[[1, 1.0, 1439, 6, 527], [1, 1.0, 1405, 6, 508], [1, 1.0, 1368, 6, 481], [1, 1.0, 1389, 26, 488], [1, 1.0, 1413, 46, 477]],
    ),
    ColoredBananaGroup(
        group=133,
        map_id=Maps.FranticFactory,
        name="Storage metal support beam",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[[1, 1.0, 1510, 6, 752], [1, 1.0, 1510, 20, 752], [1, 1.0, 1510, 33, 752], [1, 1.0, 1510, 47, 752], [1, 1.0, 1510, 60, 752]],
    ),
    ColoredBananaGroup(
        group=134,
        map_id=Maps.FranticFactory,
        name="Among the storage boxes",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[
            [1, 1.0, 1050, 6, 636],
            [1, 1.0, 1070, 46, 718],
            [1, 1.0, 1042, 41, 861],
            [1, 1.0, 962, 86, 801],
            [1, 1.0, 972, 106, 668],
            [1, 1.0, 1100, 26, 837],
            [1, 1.0, 1123, 6, 757],
            [1, 1.0, 1003, 66, 742],
            [1, 1.0, 1003, 46, 653],
            [1, 1.0, 982, 146, 765],
        ],
    ),
    ColoredBananaGroup(
        group=135,
        map_id=Maps.FranticFactory,
        name="Between the storage shops",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[
            [1, 1.0, 212, 225, 727],
            [1, 1.0, 227, 225, 727],
            [1, 1.0, 212, 225, 712],
            [1, 1.0, 197, 225, 727],
            [1, 1.0, 212, 225, 742],
        ],
    ),
    ColoredBananaGroup(
        group=136,
        map_id=Maps.FranticFactory,
        name="Between boxes near the storage shops",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        locations=[
            [5, 1.0, 370, 170, 546],
            [5, 1.0, 373, 170, 918],
        ],
    ),
    ColoredBananaGroup(
        group=137,
        map_id=Maps.FranticFactory,
        name="Dark room entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        logic=lambda l: l.chunky and l.punch,
        locations=[
            [1, 1.0, 1747, 6, 667],
            [1, 1.0, 1762, 6, 667],
            [1, 1.0, 1747, 6, 652],
            [1, 1.0, 1732, 6, 667],
            [1, 1.0, 1747, 6, 682],
        ],
    ),
    ColoredBananaGroup(
        group=138,
        map_id=Maps.FranticFactory,
        name="Box in a corner of dark room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        logic=lambda l: l.chunky and l.punch,
        locations=[[5, 1.0, 1804, 42, 914]],
    ),
    ColoredBananaGroup(
        group=139,
        map_id=Maps.FranticFactory,
        name="On the table around warp 5",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FactoryArcadeTunnel,
        locations=[
            [1, 1.0, 1817, 1137, 1399],
            [1, 1.0, 1828, 1137, 1384],
            [1, 1.0, 1828, 1137, 1366],
            [1, 1.0, 1817, 1137, 1351],
            [1, 1.0, 1799, 1137, 1345],
            [1, 1.0, 1781, 1137, 1351],
            [1, 1.0, 1770, 1137, 1366],
            [1, 1.0, 1770, 1137, 1384],
            [1, 1.0, 1781, 1137, 1399],
            [1, 1.0, 1799, 1137, 1405],
        ],
    ),
    ColoredBananaGroup(
        group=140,
        map_id=Maps.FranticFactory,
        name="Lower step of Snide",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[[1, 1.0, 1627, 818, 2087], [1, 1.0, 1627, 818, 2148], [1, 1.0, 1674, 818, 2148], [1, 1.0, 1746, 818, 2148], [1, 1.0, 1828, 818, 2148]],
    ),
    ColoredBananaGroup(
        group=141,
        map_id=Maps.FranticFactory,
        name="Testing factory-map",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[[5, 1.0, 2142, 1088, 993]],
    ),
    ColoredBananaGroup(
        group=142,
        map_id=Maps.FranticFactory,
        name="Triangle shoot-blocks near arcade window",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[
            [1, 1.0, 2257, 1057, 1572],
            [1, 1.0, 2257, 1074, 1572],
            [1, 1.0, 2257, 1092, 1572],
            [1, 1.0, 2257, 1109, 1572],
            [1, 1.0, 2257, 1126, 1572],
            [1, 1.0, 2155, 1057, 1572],
            [1, 1.0, 2155, 1074, 1572],
            [1, 1.0, 2155, 1092, 1572],
            [1, 1.0, 2155, 1109, 1572],
            [1, 1.0, 2155, 1126, 1572],
            [1, 1.0, 2058, 1057, 1572],
            [1, 1.0, 2058, 1074, 1572],
            [1, 1.0, 2058, 1092, 1572],
            [1, 1.0, 2058, 1109, 1572],
            [1, 1.0, 2058, 1126, 1572],
        ],
    ),
    ColoredBananaGroup(
        group=143,
        map_id=Maps.FranticFactory,
        name="Triangle shoot-blocks near number game",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[
            [1, 1.0, 2754, 1057, 1549],
            [1, 1.0, 2754, 1074, 1549],
            [1, 1.0, 2754, 1092, 1549],
            [1, 1.0, 2754, 1109, 1549],
            [1, 1.0, 2754, 1126, 1549],
            [1, 1.0, 2754, 1057, 1426],
            [1, 1.0, 2754, 1074, 1426],
            [1, 1.0, 2754, 1092, 1426],
            [1, 1.0, 2754, 1109, 1426],
            [1, 1.0, 2754, 1126, 1426],
            [1, 1.0, 2754, 1057, 1289],
            [1, 1.0, 2754, 1074, 1289],
            [1, 1.0, 2754, 1092, 1289],
            [1, 1.0, 2754, 1109, 1289],
            [1, 1.0, 2754, 1126, 1289],
        ],
    ),
    ColoredBananaGroup(
        group=144,
        map_id=Maps.FranticFactory,
        name="Triangle shoot-block to Funky",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[[1, 1.0, 2035, 1057, 1053], [1, 1.0, 2035, 1074, 1053], [1, 1.0, 2035, 1092, 1053], [1, 1.0, 2035, 1109, 1053], [1, 1.0, 2035, 1126, 1053]],
    ),
    ColoredBananaGroup(
        group=145,
        map_id=Maps.FranticFactory,
        name="Mini-block steps up the block tower",
        konglist=[Kongs.diddy],
        region=Regions.Testing,
        logic=lambda l: l.spring or l.CanMoontail(),
        locations=[
            [1, 1.0, 2387, 1206, 1326],
            [1, 1.0, 2386, 1206, 1346],
            [1, 1.0, 2426, 1286, 1366],
            [1, 1.0, 2427, 1286, 1387],
            [1, 1.0, 2446, 1366, 1326],
            [1, 1.0, 2466, 1366, 1326],
            [1, 1.0, 2387, 1326, 1266],
            [1, 1.0, 2386, 1326, 1244],
            [1, 1.0, 2427, 1406, 1226],
            [1, 1.0, 2426, 1406, 1205],
        ],
    ),
    ColoredBananaGroup(
        group=146,
        map_id=Maps.FranticFactory,
        name="Under testing tag barrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[
            [1, 1.0, 2712, 1106, 908],
            [1, 1.0, 2727, 1106, 908],
            [1, 1.0, 2712, 1106, 893],
            [1, 1.0, 2697, 1106, 908],
            [1, 1.0, 2712, 1106, 923],
        ],
    ),
    ColoredBananaGroup(
        group=147,
        map_id=Maps.FranticFactory,
        name="On the number game",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[
            [1, 1.0, 2716, 1055, 1845],
            [1, 1.0, 2639, 1055, 1878],
            [1, 1.0, 2639, 1055, 1888],
            [1, 1.0, 2607, 1055, 1802],
            [1, 1.0, 2599, 1055, 1802],
            [1, 1.0, 2603, 1055, 1809],
            [1, 1.0, 2684, 1055, 1767],
            [1, 1.0, 2679, 1055, 1762],
            [1, 1.0, 2674, 1055, 1767],
            [1, 1.0, 2679, 1055, 1772],
        ],
    ),
    ColoredBananaGroup(
        group=148,
        map_id=Maps.FranticFactory,
        name="Lower tunnel to R&D",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        locations=[
            [1, 1.0, 2994, 1026, 1101],
            [1, 1.0, 3009, 1026, 1101],
            [1, 1.0, 2994, 1026, 1086],
            [1, 1.0, 2979, 1026, 1101],
            [1, 1.0, 2994, 1026, 1116],
        ],
    ),
    ColoredBananaGroup(
        group=149,
        map_id=Maps.FranticFactory,
        name="Upper tunnel to R&D",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandD,
        locations=[
            [1, 1.0, 3377, 1264, 1059],
            [1, 1.0, 3392, 1264, 1059],
            [1, 1.0, 3377, 1264, 1044],
            [1, 1.0, 3362, 1264, 1059],
            [1, 1.0, 3377, 1264, 1074],
        ],
    ),
    ColoredBananaGroup(
        group=150,
        map_id=Maps.FranticFactory,
        name="R&D factory-map",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandD,
        locations=[[5, 1.0, 3581, 1295, 812]],
    ),
    ColoredBananaGroup(
        group=151,
        map_id=Maps.FranticFactory,
        name="Between the car race windows",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandD,
        locations=[
            [1, 1.0, 3693, 1264, 1274],
            [1, 1.0, 3708, 1264, 1274],
            [1, 1.0, 3693, 1264, 1259],
            [1, 1.0, 3678, 1264, 1274],
            [1, 1.0, 3693, 1264, 1289],
        ],
    ),
    ColoredBananaGroup(
        group=152,
        map_id=Maps.FranticFactory,
        name="Toy sales board in the lever room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandD,
        locations=[[5, 1.0, 3758, 1309, 1437]],
    ),
    ColoredBananaGroup(
        group=153,
        map_id=Maps.FranticFactory,
        name="On the R&D trombone pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandD,
        locations=[[5, 1.0, 3592, 1275, 608]],
    ),
    ColoredBananaGroup(
        group=154,
        map_id=Maps.FranticFactory,
        name="On the R&D guitar pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandDUpper,
        locations=[[5, 1.0, 4242, 1347, 661]],
    ),
    ColoredBananaGroup(
        group=155,
        map_id=Maps.FranticFactory,
        name="On the R&D triangle pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandDUpper,
        logic=lambda l: l.chunky and l.punch and l.climbing,
        locations=[[5, 1.0, 4405, 1427, 1395]],
    ),
    ColoredBananaGroup(
        group=156,
        map_id=Maps.FranticFactory,
        name="Power hut coconut switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ChunkyRoomPlatform,
        locations=[[5, 1.0, 1609, 131, 904]],
    ),
]

BalloonList = [
    Balloon(
        id=1,
        map_id=Maps.FranticFactory,
        name="First room left corner",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        points=[[1067, 890, 2634], [1067, 895, 2534], [1167, 885, 2634]],
    ),
    Balloon(
        id=2,
        map_id=Maps.FranticFactory,
        name="First room right side",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        points=[[1377, 890, 2386], [1440, 885, 2449], [1440, 885, 2557], [1377, 890, 2636], [1311, 880, 2515]],
    ),
    Balloon(
        id=3,
        map_id=Maps.FranticFactory,
        name="First room by robots left side",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        points=[[1149, 890, 2258], [1068, 890, 2247]],
    ),
    Balloon(
        id=4,
        map_id=Maps.FranticFactory,
        name="Tunnel by Snide's window",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        points=[[1730, 890, 2304], [1680, 880, 2348]],
    ),
    Balloon(
        id=5,
        map_id=Maps.FranticFactory,
        name="Pole to block tower lower room",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        points=[[2048, 930, 2309], [1947, 925, 2321], [1908, 930, 2427], [2028, 920, 2494], [2082, 925, 2407]],
    ),
    Balloon(
        id=6,
        map_id=Maps.FranticFactory,
        name="Pole to block tower upper room",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        points=[[2093, 1090, 2426], [1974, 1090, 2452]],
    ),
    Balloon(
        id=7,
        map_id=Maps.FranticFactory,
        name="Tunnel between Snide's and block tower",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        points=[
            [1978, 1080, 1942],
            [2170, 1076, 1900],
            [2309, 1084, 1932],
            [2183, 1080, 1953],
            [2000, 1078, 1898],
            [1804, 1082, 1946],
            [1662, 1084, 1915],
            [1795, 1078, 1900],
        ],
    ),
    Balloon(
        id=8,
        map_id=Maps.FranticFactory,
        name="Block tower room above arcade window",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        points=[[1990, 1195, 1512], [1990, 1190, 1236]],
    ),
    Balloon(
        id=9,
        map_id=Maps.FranticFactory,
        name="Block tower room above block tower",
        speed=5,
        konglist=[Kongs.diddy],
        region=Regions.Testing,
        logic=lambda l: l.spring or l.CanMoontail(),
        points=[[2418, 1620, 1224], [2494, 1610, 1300], [2418, 1625, 1376], [2342, 1615, 1300]],
    ),
    Balloon(
        id=10,
        map_id=Maps.FranticFactory,
        name="Around bottom of block tower",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        points=[[2544, 1100, 1425], [2544, 1105, 1178], [2286, 1100, 1178], [2286, 1095, 1425]],
    ),
    Balloon(
        id=11,
        map_id=Maps.FranticFactory,
        name="Block tower room in front of numbers game window",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        points=[[2302, 1170, 1586], [2720, 1160, 1586]],
    ),
    Balloon(
        id=12,
        map_id=Maps.FranticFactory,
        name="Tunnel to numbers game",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        points=[[2994, 1160, 1458], [2994, 1050, 1812]],
    ),
    Balloon(
        id=13,
        map_id=Maps.FranticFactory,
        name="Block tower room by Mini Monkey barrel",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        points=[[2393, 1160, 862], [2264, 1170, 898]],
    ),
    Balloon(
        id=14,
        map_id=Maps.FranticFactory,
        name="Block tower room by tag barrel",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        points=[[2701, 1160, 858], [2777, 1160, 858], [2777, 1170, 944]],
    ),
    Balloon(
        id=15,
        map_id=Maps.FranticFactory,
        name="Funky's room high and around room",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        points=[[1723, 1210, 550], [1546, 1230, 413], [1368, 1230, 588], [1517, 1220, 736], [1704, 1230, 730]],
    ),
    Balloon(
        id=16,
        map_id=Maps.FranticFactory,
        name="In spinning wheel room",
        speed=5,
        konglist=[Kongs.tiny],
        region=Regions.Testing,
        logic=lambda l: l.mini or l.CanPhase(),
        points=[[2450, 1160, 944], [2444, 1160, 860], [2583, 1160, 860], [2444, 1160, 860]],
    ),
    Balloon(
        id=17,
        map_id=Maps.FranticFactory,
        name="Pole to R&D lower room",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        points=[[3205, 1085, 1003], [3238, 1085, 1137], [3101, 1085, 1163], [3068, 1085, 1014]],
    ),
    Balloon(
        id=18,
        map_id=Maps.FranticFactory,
        name="Pole to R&D upper room",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandDUpper,
        points=[[3126, 1340, 1001], [3240, 1340, 1010]],
    ),
    # Balloon(
    #     id=19,
    #     map_id=Maps.FranticFactory,
    #     name="All around R&D room",
    #     speed=5,
    #     konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
    #     region=Regions.RandD,
    #     points=[
    #         [3751, 1360, 745],
    #         [4000, 1410, 692],
    #         [4122, 1405, 901],
    #         [4094, 1400, 1215],
    #         [3836, 1370, 1291],
    #         [3669, 1360, 1180],
    #         [3603, 1355, 932],
    #     ],
    # ), # Removed because it goes too far and deloads
    Balloon(
        id=19,
        map_id=Maps.FranticFactory,
        name="R&D left side",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandD,
        points=[[3658, 1382, 854], [3798, 1420, 720], [3990, 1437, 672], [4046, 1427, 831], [3990, 1437, 672], [3798, 1420, 720]],
    ),
    Balloon(
        id=20,
        map_id=Maps.FranticFactory,
        name="Piano game right side",
        speed=5,
        konglist=[Kongs.lanky],
        region=Regions.RandD,
        logic=lambda l: l.trombone or l.CanAccessRNDRoom(),
        points=[[3600, 1390, 359], [3482, 1390, 266]],
    ),
    Balloon(
        id=21,
        map_id=Maps.FranticFactory,
        name="In window by car race Mini Monkey",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandD,
        points=[[3665, 1310, 1370], [3744, 1310, 1424]],
    ),
    Balloon(
        id=22,
        map_id=Maps.FranticFactory,
        name="Tunnel to car race",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandD,
        points=[[3469, 1330, 2012], [3445, 1320, 1784], [3469, 1330, 2012], [3730, 1320, 1996]],
    ),
    Balloon(
        id=23,
        map_id=Maps.FranticFactory,
        name="Chunky R&D room",
        speed=4,
        konglist=[Kongs.chunky],
        region=Regions.RandDUpper,
        logic=lambda l: (l.punch and l.triangle and l.climbing) or l.CanAccessRNDRoom(),
        points=[[5086, 1580, 1562], [4830, 1560, 1948]],
    ),
    Balloon(
        id=24,
        map_id=Maps.FranticFactory,
        name="Cranky/Candy room",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        points=[[541, 240, 788], [555, 260, 662], [488, 270, 611]],
    ),
    Balloon(
        id=25,
        map_id=Maps.FranticFactory,
        name="Chunky room above blue switch",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        points=[[1016, 205, 878], [1354, 210, 878]],
    ),
    Balloon(
        id=26,
        map_id=Maps.FranticFactory,
        name="Chunky room above dark room entrance",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        points=[[1582, 200, 711], [1582, 200, 570]],
    ),
    Balloon(
        id=27,
        map_id=Maps.FranticFactory,
        name="Dark room",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        logic=lambda l: l.punch or l.CanPhase(),
        points=[[2078, 150, 510], [2078, 150, 810]],
    ),
    Balloon(
        id=28,
        map_id=Maps.FranticFactory,
        name="Arcade room",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FactoryArcadeTunnel,
        points=[[1646, 1165, 1285], [1656, 1160, 1454]],
    ),
    Balloon(
        id=29,
        map_id=Maps.FranticFactory,
        name="Production room very top",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCore,
        points=[
            [500, 980, 1240],
            [640, 970, 1200],
            [762, 975, 1274],
            [742, 990, 1451],
            [575, 1000, 1466],
            [500, 990, 1373],
        ],
    ),
    Balloon(
        id=30,
        map_id=Maps.FranticFactory,
        name="Production room near wall under Lanky pipe",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCore,
        points=[[838, 460, 1020], [942, 450, 1175]],
    ),
    Balloon(
        id=31,
        map_id=Maps.FranticFactory,
        name="Production room in front of middle window",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.SpinningCore,
        points=[[598, 510, 1675], [704, 505, 1684]],
    ),
    Balloon(
        id=32,
        map_id=Maps.FranticFactory,
        name="Production room in front of high window",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCore,
        points=[[598, 880, 1675], [704, 875, 1684]],
    ),
    Balloon(
        id=33,
        map_id=Maps.FranticFactory,
        name="Around hatch (Chunky)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        vanilla=True,
        points=[[521, 862, 1993], [605, 870, 1762], [776, 876, 2000]],
    ),
    Balloon(
        id=34,
        map_id=Maps.FranticFactory,
        name="Top of pole by Snide (Chunky)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        vanilla=True,
        points=[[1653, 1085, 2108], [1498, 1087, 2100]],
    ),
    Balloon(
        id=35,
        map_id=Maps.FranticFactory,
        name="In piano game room (Lanky)",
        speed=6,
        konglist=[Kongs.lanky],
        region=Regions.RandD,
        vanilla=True,
        logic=lambda l: (l.trombone or l.CanAccessRNDRoom()),
        points=[[3594, 1380, 404], [3516, 1384, 520], [3423, 1386, 628]],
    ),
    Balloon(
        id=36,
        map_id=Maps.FranticFactory,
        name="In front of Snide (Tiny)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        vanilla=True,
        points=[[1665, 871, 2094], [1799, 870, 2194]],
    ),
    Balloon(
        id=37,
        map_id=Maps.FranticFactory,
        name="In Diddy's R&D room (back) (Diddy)",
        speed=3,
        konglist=[Kongs.diddy],
        region=Regions.RandDUpper,
        vanilla=True,
        logic=lambda l: l.guitar or l.CanAccessRNDRoom(),
        points=[[4539, 1484, 344], [4679, 1488, 571]],
    ),
    Balloon(
        id=38,
        map_id=Maps.FranticFactory,
        name="In Diddy's R&D room (front) (Diddy)",
        speed=5,
        konglist=[Kongs.diddy],
        region=Regions.RandDUpper,
        vanilla=True,
        logic=lambda l: l.guitar or l.CanAccessRNDRoom(),
        points=[[4413, 1498, 709], [4336, 1510, 583], [4244, 1502, 450]],
    ),
    Balloon(
        id=39,
        map_id=Maps.FranticFactory,
        name="In R&D above hatch to Chunky's room (Donkey)",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandDUpper,
        vanilla=True,
        points=[[4665, 1389, 860], [4652, 1389, 1014]],
    ),
    Balloon(
        id=40,
        map_id=Maps.FranticFactory,
        name="In front of Candy & Cranky (Donkey)",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        vanilla=True,
        points=[[209, 309, 754], [344, 243, 893], [301, 241, 781], [406, 263, 834], [360, 261, 640]],
    ),
    Balloon(
        id=41,
        map_id=Maps.FranticFactory,
        name="Around numbers game (Donkey)",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        vanilla=True,
        points=[
            [2612, 1080, 1673],
            [2733, 1060, 1696],
            [2751, 1066, 1940],
            [2547, 1068, 1947],
            [2537, 1066, 1870],
            [2554, 1060, 1725],
        ],
    ),
    Balloon(
        id=42,
        map_id=Maps.FranticFactory,
        name="In Diddy's R&D room (left) (Diddy)",
        speed=6,
        konglist=[Kongs.diddy],
        region=Regions.RandDUpper,
        vanilla=True,
        logic=lambda l: l.guitar or l.CanAccessRNDRoom(),
        points=[[4313, 1484, 446], [4521, 1486, 315]],
    ),
    Balloon(
        id=43,
        map_id=Maps.FranticFactory,
        name="Prod room, by center (Tiny)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MiddleCore,
        vanilla=True,
        points=[[746, 254, 1411], [752, 260, 1255]],
    ),
    Balloon(
        id=44,
        map_id=Maps.FranticFactory,
        name="In front of Funky (Tiny)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        vanilla=True,
        points=[[1453, 1179, 689], [1592, 1181, 590], [1643, 1177, 442]],
    ),
    Balloon(
        id=45,
        map_id=Maps.FranticFactory,
        name="Prod room, by highest tag barrel (Lanky)",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCore,
        vanilla=True,
        points=[[360, 685, 1099], [456, 683, 1030], [575, 681, 1001]],
    ),
    Balloon(
        id=46,
        map_id=Maps.FranticFactory,
        name="Chunky R&D room (Chunky)",
        speed=6,
        konglist=[Kongs.chunky],
        region=Regions.RandDUpper,
        vanilla=True,
        logic=lambda l: ((l.punch and l.triangle and l.climbing) or l.CanAccessRNDRoom()),
        points=[[4424, 1490, 1560], [4567, 1486, 1341]],
    ),
    Balloon(
        id=47,
        map_id=Maps.FactoryCrusher,
        name="In crusher room (Lanky)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.InsideCore,
        vanilla=True,
        points=[[286, 44, 508], [272, 38, 415]],
    ),
    # Wave 2 by Snap
    Balloon(
        id=48,
        map_id=Maps.FranticFactory,
        name="Top of the hatch",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryStart,
        points=[[617, 860, 1904], [617, 680, 1904], [617, 670, 1904]],
    ),
    Balloon(
        id=49,
        map_id=Maps.FranticFactory,
        name="Tunnel from hatch to production",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        points=[[438, 200, 1959], [52, 130, 1959], [38, 110, 1718], [52, 130, 1959]],
    ),
    Balloon(
        id=50,
        map_id=Maps.FranticFactory,
        name="Around the lower production pipe",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        points=[[821, 150, 1517], [874, 211, 1470], [970, 138, 1390], [912, 84, 1409], [846, 171, 1405], [895, 191, 1490], [947, 124, 1496], [832, 69, 1537]],
    ),
    Balloon(
        id=51,
        map_id=Maps.FranticFactory,
        name="Around the rotating pipe",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MiddleCore,
        points=[[623, 362, 1133], [708, 269, 1127], [626, 213, 1078], [522, 290, 1119]],
    ),
    Balloon(
        id=52,
        map_id=Maps.FranticFactory,
        name="Around the big piston",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.SpinningCore,
        points=[[575, 555, 1276], [738, 566, 1316], [583, 542, 1453]],
    ),
    Balloon(
        id=53,
        map_id=Maps.FranticFactory,
        name="Around the Lanky pipe",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCore,
        points=[[660, 694, 1516], [782, 686, 1606], [856, 641, 1518], [815, 711, 1404], [743, 822, 1487]],
    ),
    Balloon(
        id=54,
        map_id=Maps.FranticFactory,
        name="Along the storage pipe",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        points=[[1495, 6, 532], [1495, 64, 532], [1554, 171, 543], [1625, 171, 542], [1554, 171, 543], [1495, 64, 532]],
    ),
    Balloon(
        id=55,
        map_id=Maps.FranticFactory,
        name="Above the headphones",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BeyondHatch,
        points=[[976, 80, 488], [976, 222, 488]],
    ),
    Balloon(
        id=56,
        map_id=Maps.FranticFactory,
        name="Arcade machine",
        speed=12,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FactoryArcadeTunnel,
        points=[[1862, 1136, 1292], [1862, 1136, 1150]],
    ),
    Balloon(
        id=57,
        map_id=Maps.FranticFactory,
        name="Window of the number game",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        points=[[2447, 1035, 1780], [2455, 1080, 1794], [2457, 1044, 1840]],
    ),
    Balloon(
        id=58,
        map_id=Maps.FranticFactory,
        name="Shoot at the moon",  # Hard, maybe insane even tbh
        speed=2,
        konglist=[Kongs.diddy],
        region=Regions.Testing,
        logic=lambda l: l.spring or l.CanMoontail(),
        points=[[2259, 1800, 1241], [2259, 1795, 1241]],
    ),
    Balloon(
        id=59,
        map_id=Maps.FranticFactory,
        name="Ceiling pipe towards Funky",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Testing,
        points=[[2287, 1214, 1156], [2063, 1194, 1032]],
    ),
    Balloon(
        id=60,
        map_id=Maps.FranticFactory,
        name="Top of pole to R&D",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandD,
        points=[[3202, 1319, 1086], [3202, 1200, 1086]],
    ),
    Balloon(
        id=61,
        map_id=Maps.FranticFactory,
        name="R&D right side",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.RandD,
        points=[[3643, 1380, 1145], [3836, 1415, 1274], [4011, 1427, 1267], [4149, 1429, 1157], [4011, 1427, 1267], [3836, 1415, 1274]],
    ),
    Balloon(
        id=62,
        map_id=Maps.FactoryCrusher,
        name="Under the last crusher",
        speed=9,
        konglist=[Kongs.donkey],
        region=Regions.InsideCore,
        logic=lambda l: l.strongKong,
        points=[[67, 7, 280], [171, 34, 280], [171, 7, 280], [67, 34, 280]],
    ),
]
