from typing import NamedTuple, TYPE_CHECKING

from BaseClasses import CollectionState
from worlds.generic.Rules import set_rule, add_rule

from .constants import base_id
from .logic_helpers import has_sword, has_melee

if TYPE_CHECKING:
    from . import TunicWorld


class TunicLocationData(NamedTuple):
    region: str
    er_region: str  # entrance rando region
    location_group: str | None = None


# todo: remove region, make all of these regions append grass to the name
# and then set the rules on the region entrances instead of the locations directly
grass_location_table: dict[str, TunicLocationData] = {
    "Overworld - Overworld Grass (576) (7.0, 4.0, -223.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (572) (6.0, 4.0, -223.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (574) (7.0, 4.0, -224.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (568) (5.0, 4.0, -223.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (562) (4.0, 4.0, -223.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (570) (6.0, 4.0, -224.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (569) (5.0, 4.0, -225.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (566) (5.0, 4.0, -224.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (563) (4.0, 4.0, -224.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (564) (4.0, 4.0, -225.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (573) (6.0, 4.0, -225.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (577) (7.0, 4.0, -225.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (578) (3.0, 4.0, -223.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (575) (2.0, 4.0, -223.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (579) (3.0, 4.0, -224.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (571) (2.0, 4.0, -224.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (583) (-2.4, 4.0, -224.4)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (580) (-3.4, 4.0, -224.4)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (581) (-2.4, 4.0, -225.4)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (582) (-3.4, 4.0, -225.4)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (586) (-3.4, 4.0, -219.6)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (584) (-3.4, 4.0, -218.6)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (585) (-2.4, 4.0, -219.6)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (587) (-2.4, 4.0, -218.6)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (615) (13.0, 8.0, -217.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (616) (14.0, 8.0, -217.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (614) (13.0, 8.0, -216.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (613) (14.0, 8.0, -216.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (142) (13.0, 8.0, -224.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (141) (13.0, 8.0, -226.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (140) (13.0, 8.0, -228.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (591) (-8.0, 12.0, -212.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (590) (-8.0, 12.0, -212.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (589) (-9.0, 12.0, -212.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (588) (-9.0, 12.0, -213.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (592) (-8.0, 12.0, -213.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (606) (8.0, 12.0, -208.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (607) (8.0, 12.0, -209.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (608) (9.0, 12.0, -208.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (605) (9.0, 12.0, -209.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (600) (12.0, 12.0, -199.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (598) (12.0, 12.0, -200.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (599) (13.0, 12.0, -199.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (597) (13.0, 12.0, -200.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (602) (12.0, 12.0, -198.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (603) (13.0, 12.0, -197.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (601) (13.0, 12.0, -198.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (604) (12.0, 12.0, -197.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (593) (8.0, 12.0, -190.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (596) (9.0, 12.0, -190.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (594) (9.0, 12.0, -189.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (595) (8.0, 12.0, -189.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (612) (-8.0, 12.0, -188.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (609) (-8.0, 12.0, -189.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (610) (-9.0, 12.0, -188.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (611) (-9.0, 12.0, -189.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (895) (-6.0, 12.0, -134.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (894) (-6.0, 12.0, -133.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (891) (-6.0, 12.0, -132.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (892) (-7.0, 12.0, -133.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (889) (-7.0, 12.0, -132.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (893) (-7.0, 12.0, -134.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (899) (-7.0, 12.0, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (905) (-8.0, 12.0, -132.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (890) (-6.0, 12.0, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (906) (-9.0, 12.0, -132.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (907) (-10.0, 12.0, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (908) (-10.0, 12.0, -132.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (898) (-15.0, 12.0, -134.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (897) (-15.0, 12.0, -133.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (909) (-14.0, 12.0, -132.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (887) (-15.0, 12.0, -132.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (900) (-16.0, 12.0, -133.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (888) (-16.0, 12.0, -132.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (896) (-16.0, 12.0, -134.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (901) (-17.0, 12.0, -132.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (886) (-16.0, 12.0, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (904) (-17.0, 12.0, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (902) (-18.0, 12.0, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (903) (-18.0, 12.0, -132.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (334) (-20.0, 12.0, -133.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (322) (-20.0, 12.0, -132.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (320) (-20.0, 12.0, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (321) (-21.0, 12.0, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (332) (-21.0, 12.0, -133.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (323) (-21.0, 12.0, -132.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (337) (-22.0, 12.0, -132.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (336) (-22.0, 12.0, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (339) (-23.0, 12.0, -132.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (338) (-23.0, 12.0, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (335) (-20.0, 12.0, -134.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (333) (-21.0, 12.0, -134.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (349) (-21.0, 12.0, -141.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (344) (-22.0, 12.0, -142.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (346) (-23.0, 12.0, -142.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (345) (-22.0, 12.0, -143.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (347) (-23.0, 12.0, -143.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (340) (-20.0, 12.0, -142.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (343) (-21.0, 12.0, -143.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (342) (-21.0, 12.0, -142.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (356) (-21.0, 12.0, -144.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (353) (-19.0, 12.0, -143.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (351) (-20.0, 12.0, -141.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (358) (-20.0, 12.0, -144.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (341) (-20.0, 12.0, -143.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (348) (-21.0, 12.0, -140.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (354) (-18.0, 12.0, -142.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (352) (-19.0, 12.0, -142.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (350) (-20.0, 12.0, -140.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (359) (-20.0, 12.0, -145.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (357) (-21.0, 12.0, -145.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (355) (-18.0, 12.0, -143.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (131) (13.0, 12.0, -143.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (130) (13.0, 12.0, -141.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (129) (15.0, 12.0, -141.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (372) (14.5, 12.0, -139.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (128) (13.0, 12.0, -139.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (375) (14.5, 12.0, -138.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (373) (15.5, 12.0, -139.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (379) (16.5, 12.0, -138.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (376) (16.5, 12.0, -139.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (374) (15.5, 12.0, -138.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (369) (15.5, 12.0, -137.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (368) (14.5, 12.0, -137.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (366) (13.5, 12.0, -136.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (365) (13.5, 12.0, -137.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (371) (14.5, 12.0, -136.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (364) (12.5, 12.0, -137.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (367) (12.5, 12.0, -136.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (361) (13.5, 12.0, -135.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (127) (15.0, 12.0, -135.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (370) (15.5, 12.0, -136.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (362) (13.5, 12.0, -134.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (363) (12.5, 12.0, -134.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (360) (12.5, 12.0, -135.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (388) (16.5, 12.0, -137.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (389) (17.5, 12.0, -137.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (378) (17.5, 12.0, -138.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (377) (17.5, 12.0, -139.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (391) (16.5, 12.0, -136.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (392) (18.5, 12.0, -135.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (390) (17.5, 12.0, -136.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (385) (17.5, 12.0, -135.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (384) (16.5, 12.0, -135.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (386) (17.5, 12.0, -134.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (387) (16.5, 12.0, -134.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (382) (17.5, 12.0, -140.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (383) (16.5, 12.0, -140.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (381) (17.5, 12.0, -141.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (395) (18.5, 12.0, -134.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (394) (19.5, 12.0, -134.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (285) (19.5, 12.0, -132.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (279) (19.5, 12.0, -133.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (124) (18.0, 12.0, -133.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (393) (19.5, 12.0, -135.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (397) (20.5, 12.0, -134.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (282) (20.5, 12.0, -133.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (284) (20.5, 12.0, -132.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (289) (21.5, 12.0, -134.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (287) (21.5, 12.0, -133.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (281) (22.5, 12.0, -132.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (278) (22.5, 12.0, -133.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (286) (21.5, 12.0, -132.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (267) (21.5, 12.0, -131.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (126) (20.0, 12.0, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (125) (18.0, 12.0, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (283) (22.5, 12.0, -134.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (277) (23.5, 12.0, -132.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (276) (23.5, 12.0, -133.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (271) (22.5, 12.0, -131.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (269) (24.5, 12.0, -132.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (268) (24.5, 12.0, -133.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (266) (24.5, 12.0, -131.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (270) (24.5, 12.0, -130.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (275) (23.5, 12.0, -131.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (274) (23.5, 12.0, -130.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (272) (22.5, 12.0, -130.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (273) (21.5, 12.0, -130.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (396) (20.5, 12.0, -135.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (288) (21.5, 12.0, -135.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (280) (22.5, 12.0, -135.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (380) (16.5, 12.0, -141.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (262) (44.0, 12.0, -145.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (264) (45.0, 12.0, -144.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (263) (45.0, 12.0, -145.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (255) (39.5, 12.0, -151.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (256) (39.5, 12.0, -150.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (251) (39.5, 12.0, -152.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (254) (38.5, 12.0, -151.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (252) (38.5, 12.0, -152.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (257) (38.5, 12.0, -150.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (261) (40.5, 12.0, -152.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (258) (40.5, 12.0, -153.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (250) (39.5, 12.0, -153.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (260) (41.5, 12.0, -152.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (259) (41.5, 12.0, -153.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (253) (38.5, 12.0, -153.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (106) (47.0, 12.0, -147.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (31) (48.0, 12.0, -153.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (249) (50.5, 12.0, -153.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (245) (50.5, 12.0, -151.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (247) (50.5, 12.0, -152.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (242) (50.5, 12.0, -150.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (246) (51.5, 12.0, -152.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (244) (51.5, 12.0, -151.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (248) (51.5, 12.0, -153.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (17) (53.0, 12.0, -153.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (16) (53.0, 12.0, -151.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (243) (51.5, 12.0, -150.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (30) (51.0, 12.0, -149.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (32) (55.0, 12.0, -153.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (28) (55.0, 12.0, -149.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (13) (53.0, 12.0, -149.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (11) (53.0, 12.0, -147.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (27) (55.0, 12.0, -147.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (29) (51.0, 12.0, -147.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (33) (55.0, 12.0, -157.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (876) (68.0, 12.0, -156.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (878) (69.0, 12.0, -155.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (877) (69.0, 12.0, -154.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (879) (70.0, 12.0, -155.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (880) (70.0, 12.0, -154.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (873) (67.0, 12.0, -156.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (875) (68.0, 12.0, -157.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (874) (67.0, 12.0, -157.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (184) (69.5, 12.0, -157.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (183) (71.5, 12.0, -155.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (182) (71.5, 12.0, -157.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (871) (74.0, 12.0, -155.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (185) (73.5, 12.0, -157.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (870) (73.0, 12.0, -155.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (869) (73.0, 12.0, -154.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (872) (74.0, 12.0, -154.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (195) (65.5, 12.0, -157.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (950) (75.0, 12.0, -156.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (951) (75.0, 12.0, -157.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (953) (76.0, 12.0, -156.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (952) (76.0, 12.0, -157.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (194) (73.5, 12.0, -150.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (954) (76.5, 12.0, -150.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (189) (75.5, 12.0, -148.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (193) (73.5, 12.0, -148.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (955) (76.5, 12.0, -151.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (867) (78.5, 12.0, -151.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (866) (77.5, 12.0, -151.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (861) (79.5, 12.0, -150.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (862) (79.5, 12.0, -151.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (868) (78.5, 12.0, -150.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (865) (77.5, 12.0, -150.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (964) (78.5, 12.0, -156.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (965) (78.5, 12.0, -157.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (967) (79.5, 12.0, -156.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (966) (79.5, 12.0, -157.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (960) (80.5, 12.0, -156.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (962) (81.5, 12.0, -157.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (956) (80.5, 12.0, -158.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (961) (80.5, 12.0, -157.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (963) (81.5, 12.0, -156.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (957) (80.5, 12.0, -159.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (959) (81.5, 12.0, -158.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (958) (81.5, 12.0, -159.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (930) (84.5, 12.0, -158.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (933) (85.5, 12.0, -158.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (913) (86.5, 12.0, -155.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (40) (87.0, 12.0, -157.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (39) (87.0, 12.0, -159.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (41) (89.0, 12.0, -157.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (914) (87.5, 12.0, -155.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (48) (89.0, 12.0, -155.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (915) (87.5, 12.0, -154.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (912) (86.5, 12.0, -154.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (42) (91.0, 12.0, -157.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (47) (91.0, 12.0, -155.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (940) (89.5, 12.0, -153.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (938) (88.5, 12.0, -152.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (939) (88.5, 12.0, -153.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (941) (89.5, 12.0, -152.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (943) (88.5, 12.0, -151.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (944) (89.5, 12.0, -151.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (945) (89.5, 12.0, -150.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (942) (88.5, 12.0, -150.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (948) (89.5, 12.0, -149.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (949) (89.5, 12.0, -148.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (947) (88.5, 12.0, -149.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (946) (88.5, 12.0, -148.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (934) (94.5, 12.0, -154.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (85) (93.0, 12.0, -155.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (43) (93.0, 12.0, -157.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (935) (94.5, 12.0, -155.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (936) (95.5, 12.0, -155.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (84) (95.0, 12.0, -157.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (937) (95.5, 12.0, -154.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (932) (85.5, 12.0, -159.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (928) (85.5, 12.0, -161.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (929) (85.5, 12.0, -160.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (916) (84.5, 12.0, -160.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (931) (84.5, 12.0, -159.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (38) (87.0, 12.0, -161.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (310) (86.5, 12.0, -162.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (917) (84.5, 12.0, -161.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (313) (87.5, 12.0, -162.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (311) (86.5, 12.0, -163.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (312) (87.5, 12.0, -163.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (980) (86.5, 12.0, -170.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (981) (86.5, 12.0, -171.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (982) (87.5, 12.0, -171.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (983) (87.5, 12.0, -170.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (968) (86.5, 12.0, -174.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (969) (86.5, 12.0, -175.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (979) (85.5, 12.0, -174.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (971) (87.5, 12.0, -174.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (970) (87.5, 12.0, -175.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (975) (87.5, 12.0, -176.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (978) (85.5, 12.0, -175.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (976) (84.5, 12.0, -174.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (977) (84.5, 12.0, -175.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (972) (86.5, 12.0, -176.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (973) (86.5, 12.0, -177.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (974) (87.5, 12.0, -177.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (619) (-3.0, 20.0, -126.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (621) (-4.0, 20.0, -126.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (626) (-5.0, 20.0, -126.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (623) (-5.0, 20.0, -127.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (624) (-6.0, 20.0, -126.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (622) (-3.0, 20.0, -127.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (620) (-4.0, 20.0, -127.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (452) (-3.0, 20.0, -128.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (451) (-3.0, 20.0, -129.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (625) (-6.0, 20.0, -127.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (627) (-14.0, 20.0, -126.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (630) (-14.0, 20.0, -127.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (629) (-15.0, 20.0, -126.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (628) (-15.0, 20.0, -127.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (423) (-9.0, 20.0, -116.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (449) (-8.0, 20.0, -118.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (415) (-8.0, 20.0, -116.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (446) (-8.0, 20.0, -117.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (448) (-7.0, 20.0, -117.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (447) (-7.0, 20.0, -118.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (425) (-10.0, 20.0, -116.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (417) (-7.0, 20.0, -116.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (411) (-7.0, 20.0, -115.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (413) (-8.0, 20.0, -115.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (424) (-9.0, 20.0, -115.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (422) (-10.0, 20.0, -115.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (840) (14.0, 20.0, -117.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (844) (16.0, 20.0, -118.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (841) (16.0, 20.0, -117.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (838) (15.0, 20.0, -117.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (839) (15.0, 20.0, -116.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (837) (14.0, 20.0, -116.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (843) (17.0, 20.0, -117.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (833) (14.0, 20.0, -114.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (836) (14.0, 20.0, -115.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (834) (15.0, 20.0, -115.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (835) (15.0, 20.0, -114.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (831) (19.5, 20.0, -128.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (830) (19.5, 20.0, -129.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (829) (18.5, 20.0, -128.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (832) (18.5, 20.0, -129.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (821) (20.5, 20.0, -128.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (828) (20.5, 20.0, -127.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (822) (21.5, 20.0, -129.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (826) (21.5, 20.0, -127.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (823) (21.5, 20.0, -128.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (824) (20.5, 20.0, -129.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (825) (20.5, 20.0, -126.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (827) (21.5, 20.0, -126.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (536) (8.0, 28.0, -94.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (508) (9.0, 28.0, -94.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (534) (7.0, 28.0, -94.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (506) (10.0, 28.0, -94.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (509) (10.0, 28.0, -93.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (507) (9.0, 28.0, -93.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (535) (8.0, 28.0, -93.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (537) (7.0, 28.0, -93.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (500) (12.0, 28.0, -95.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (503) (12.0, 28.0, -96.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (504) (12.0, 28.0, -97.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (498) (13.0, 28.0, -95.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (505) (13.0, 28.0, -96.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (502) (13.0, 28.0, -97.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (499) (12.0, 28.0, -94.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (501) (13.0, 28.0, -94.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (517) (7.0, 28.0, -99.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (515) (8.0, 28.0, -99.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (514) (7.0, 28.0, -100.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (516) (8.0, 28.0, -100.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (484) (12.0, 28.0, -102.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (483) (12.0, 28.0, -103.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (491) (11.0, 28.0, -104.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (485) (13.0, 28.0, -102.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (489) (12.0, 28.0, -104.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (482) (13.0, 28.0, -103.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (486) (12.0, 28.0, -105.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (488) (13.0, 28.0, -105.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (487) (13.0, 28.0, -104.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (492) (11.0, 28.0, -105.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (493) (10.0, 28.0, -104.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (490) (10.0, 28.0, -105.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (513) (9.0, 28.0, -106.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (511) (10.0, 28.0, -106.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (512) (10.0, 28.0, -107.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (510) (9.0, 28.0, -107.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (495) (8.0, 28.0, -104.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (496) (8.0, 28.0, -105.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (497) (7.0, 28.0, -104.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (494) (7.0, 28.0, -105.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (520) (-4.0, 28.0, -94.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (521) (-5.0, 28.0, -93.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (525) (-5.0, 28.0, -95.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (518) (-5.0, 28.0, -94.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (519) (-4.0, 28.0, -93.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (523) (-6.0, 28.0, -95.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (631) (-7.0, 28.0, -95.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (522) (-5.0, 28.0, -96.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (524) (-6.0, 28.0, -96.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (632) (-7.0, 28.0, -96.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (533) (-7.0, 28.0, -97.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (633) (-8.0, 28.5, -95.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (634) (-8.0, 28.0, -96.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (531) (-8.0, 28.0, -97.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (532) (-8.0, 28.0, -98.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (530) (-7.0, 28.0, -98.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (769) (-8.5, 28.0, -105.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (772) (-8.5, 28.0, -104.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (770) (-9.5, 28.0, -104.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (771) (-9.5, 28.0, -105.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (758) (-7.5, 28.0, -107.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (760) (-6.5, 28.0, -107.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (754) (-5.5, 28.0, -107.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (757) (-6.5, 28.0, -108.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (755) (-5.5, 28.0, -108.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (764) (-6.5, 28.0, -109.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (753) (-4.5, 28.0, -108.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (756) (-4.5, 28.0, -107.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (765) (-2.5, 28.0, -107.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (168) (-3.0, 28.0, -109.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (767) (-3.5, 28.0, -107.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (766) (-3.5, 28.0, -106.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (768) (-2.5, 28.0, -106.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (169) (-5.0, 28.0, -111.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (166) (-3.0, 28.0, -111.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (167) (-5.0, 28.0, -113.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (116) (-3.0, 28.0, -113.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (761) (-6.5, 28.0, -110.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (762) (-7.5, 28.0, -109.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (759) (-7.5, 28.0, -108.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (763) (-7.5, 28.0, -110.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (151) (-21.0, 28.0, -109.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (170) (-21.0, 28.0, -111.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (171) (-19.0, 28.0, -113.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (149) (-23.0, 28.0, -107.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (24) (-25.0, 28.0, -109.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (138) (-25.0, 28.0, -111.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (148) (-25.0, 28.0, -113.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (172) (-23.0, 28.0, -113.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (25) (-25.0, 28.0, -107.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (150) (-21.0, 28.0, -107.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (26) (-19.0, 28.0, -107.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (23) (-19.0, 28.0, -105.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (9) (-19.0, 28.0, -103.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (471) (-16.0, 36.0, -87.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (472) (-16.0, 36.0, -86.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (470) (-17.0, 36.0, -86.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (473) (-17.0, 36.0, -87.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (468) (-17.0, 36.0, -88.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (466) (-16.0, 36.0, -88.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (474) (-15.0, 36.0, -88.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (467) (-17.0, 36.0, -89.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (469) (-16.0, 36.0, -89.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (477) (-15.0, 36.0, -89.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (475) (-14.0, 36.0, -89.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (476) (-14.0, 36.0, -88.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (459) (-4.0, 36.0, -75.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (460) (-4.0, 36.0, -74.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (458) (-3.0, 36.0, -74.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (461) (-3.0, 36.0, -75.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (457) (-4.0, 36.0, -73.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (455) (-3.0, 36.0, -73.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (456) (-3.0, 36.0, -72.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (454) (-4.0, 36.0, -72.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (463) (-9.0, 36.0, -70.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (465) (-8.0, 36.0, -70.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (462) (-8.0, 36.0, -69.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (464) (-9.0, 36.0, -69.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (567) (-7.0, 36.0, -68.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (617) (-7.0, 36.0, -67.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (618) (-6.0, 36.0, -68.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (565) (-6.0, 36.0, -67.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (792) (-14.5, 36.0, -63.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (789) (-14.5, 36.0, -62.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (790) (-15.5, 36.0, -63.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (791) (-15.5, 36.0, -62.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (180) (-13.0, 36.0, -61.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (776) (-12.5, 36.0, -59.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (779) (-11.5, 36.0, -60.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (778) (-11.5, 36.0, -61.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (777) (-10.5, 36.0, -60.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (780) (-10.5, 36.0, -61.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (774) (-13.5, 36.0, -59.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (178) (-11.0, 36.0, -59.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (773) (-12.5, 36.0, -58.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (775) (-13.5, 36.0, -58.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (785) (-14.5, 36.0, -58.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (788) (-14.5, 36.0, -59.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (786) (-15.5, 36.0, -59.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (179) (-13.0, 36.0, -57.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (177) (-11.0, 36.0, -57.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (174) (-13.0, 36.0, -55.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (784) (-14.5, 36.0, -57.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (781) (-14.5, 36.0, -56.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (176) (-15.0, 36.0, -55.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (783) (-15.5, 36.0, -56.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (782) (-15.5, 36.0, -57.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (787) (-15.5, 36.0, -58.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (173) (-11.0, 36.0, -55.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (181) (-17.0, 36.0, -58.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (800) (-16.5, 36.0, -53.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (175) (-15.0, 36.0, -53.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (797) (-16.5, 36.0, -52.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (136) (-15.0, 36.0, -51.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (796) (-16.5, 36.0, -51.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (793) (-16.5, 36.0, -50.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (794) (-17.5, 36.0, -51.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (799) (-17.5, 36.0, -52.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (798) (-17.5, 36.0, -53.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (135) (-15.0, 36.0, -49.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (134) (-17.0, 36.0, -49.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (795) (-17.5, 36.0, -50.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (132) (-15.0, 36.0, -47.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (133) (-17.0, 36.0, -47.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (437) (11.0, 36.0, -72.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (434) (11.0, 36.0, -71.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (435) (10.0, 36.0, -72.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (433) (10.0, 36.0, -70.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (436) (10.0, 36.0, -71.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (432) (11.0, 36.0, -70.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (441) (9.0, 36.0, -72.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (438) (9.0, 36.0, -71.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (440) (8.0, 36.0, -71.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (439) (8.0, 36.0, -72.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (445) (8.0, 36.0, -74.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (442) (8.0, 36.0, -73.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (430) (10.0, 36.0, -69.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (431) (11.0, 36.0, -69.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (444) (7.0, 36.0, -73.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (443) (7.0, 36.0, -74.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (652) (28.0, 36.0, -110.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (647) (27.0, 36.0, -112.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (648) (26.0, 36.0, -112.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (654) (28.0, 36.0, -111.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (646) (28.0, 36.0, -112.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (645) (28.0, 36.0, -113.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (649) (27.0, 36.0, -113.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (653) (29.0, 36.0, -111.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (643) (29.0, 36.0, -113.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (644) (29.0, 36.0, -112.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (651) (29.0, 36.0, -110.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (650) (26.0, 36.0, -113.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (845) (-4.5, 44.0, -68.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (847) (-3.5, 44.0, -68.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (846) (-4.5, 44.0, -69.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (848) (-3.5, 44.0, -69.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (850) (9.5, 44.0, -65.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (856) (7.5, 44.0, -66.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (853) (8.5, 44.0, -65.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (854) (8.5, 44.0, -66.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (859) (7.5, 44.0, -67.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (860) (7.5, 44.0, -68.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (857) (8.5, 44.0, -67.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (858) (8.5, 44.0, -68.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (849) (9.5, 44.0, -64.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (851) (10.5, 44.0, -64.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (852) (10.5, 44.0, -65.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (855) (7.5, 44.0, -65.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (410) (-6.0, 44.0, -64.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (416) (-6.0, 44.0, -65.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (421) (-4.0, 44.0, -63.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (407) (-6.0, 44.0, -63.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (420) (-5.0, 44.0, -63.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (403) (-6.0, 44.0, -62.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (409) (-7.0, 44.0, -63.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (418) (-5.0, 44.0, -62.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (412) (-7.0, 44.0, -64.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (405) (-7.0, 44.0, -62.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (400) (-7.0, 44.0, -61.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (414) (-7.0, 44.0, -65.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (402) (-8.0, 44.0, -62.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (399) (-8.0, 44.0, -61.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (406) (-8.0, 44.0, -63.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (401) (-6.0, 44.0, -61.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (404) (-9.0, 44.0, -62.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (408) (-9.0, 44.0, -63.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (426) (-8.0, 44.0, -60.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (398) (-9.0, 44.0, -61.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (429) (-8.0, 44.0, -59.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (428) (-9.0, 44.0, -59.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (427) (-9.0, 44.0, -60.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (667) (-6.0, 44.0, -50.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (669) (-5.0, 44.0, -50.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (668) (-5.0, 44.0, -51.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (670) (-6.0, 44.0, -51.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (665) (-6.0, 44.0, -48.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (666) (-5.0, 44.0, -48.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (664) (-6.0, 44.0, -47.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (663) (-5.0, 44.0, -47.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (672) (8.0, 44.0, -48.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (674) (7.0, 44.0, -48.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (671) (7.0, 44.0, -47.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (677) (6.0, 44.0, -48.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (676) (6.0, 44.0, -49.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (675) (5.0, 44.0, -48.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (678) (5.0, 44.0, -49.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (673) (8.0, 44.0, -47.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (5) (12.0, 44.0, -6.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (4) (13.0, 44.0, -6.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (3) (12.0, 44.0, -5.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1) (13.0, 44.0, -5.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (6) (11.0, 44.0, -5.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (13.0, 44.0, -4.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (2) (12.0, 44.0, -4.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (7) (11.0, 44.0, -4.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (30) (10.0, 44.0, -4.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1137) (8.0, 46.0, -2.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1135) (9.0, 46.0, -2.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1138) (9.0, 46.0, -3.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1136) (8.0, 46.0, -1.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1134) (9.0, 46.0, -1.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1139) (-4.0, 46.0, -1.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1141) (-4.0, 46.0, -2.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1142) (-5.0, 46.0, -2.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1140) (-5.0, 46.0, -1.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (26) (-6.5, 44.0, -5.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (27) (-6.5, 44.0, -4.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (24) (-7.5, 44.0, -5.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (25) (-7.5, 44.0, -4.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (28) (-8.5, 44.0, -6.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (22) (-8.5, 44.0, -5.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (21) (-8.5, 44.0, -4.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (29) (-9.5, 44.0, -6.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (18) (-8.5, 44.0, -10.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (11) (-8.5, 44.0, -12.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (13) (-8.5, 44.0, -11.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (19) (-9.5, 44.0, -10.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (12) (-9.5, 44.0, -11.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (15) (-7.5, 44.0, -12.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (9) (-9.5, 44.0, -12.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (8) (-9.5, 44.0, -13.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (10) (-8.5, 44.0, -13.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (16) (-6.5, 44.0, -12.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (17) (-6.5, 44.0, -13.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (14) (-7.5, 44.0, -13.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (698) (-32.0, 38.0, -49.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (699) (-31.0, 38.0, -49.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (697) (-32.0, 38.0, -50.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (700) (-31.0, 38.0, -50.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (696) (-32.5, 38.0, -46.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (693) (-33.5, 38.5, -45.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (695) (-33.5, 38.0, -46.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (694) (-33.5, 38.5, -45.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (691) (-34.5, 38.0, -46.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (692) (-34.5, 38.0, -45.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (560) (-32.0, 40.0, -33.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (554) (-31.0, 40.0, -34.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (553) (-31.0, 40.0, -33.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (555) (-30.0, 40.0, -34.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (557) (-31.0, 40.0, -35.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (550) (-31.0, 40.0, -32.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (552) (-30.0, 40.0, -33.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (551) (-30.0, 40.0, -32.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (559) (-32.0, 40.0, -32.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (558) (-33.0, 40.0, -32.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (561) (-33.0, 40.0, -33.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (139) (-31.0, 40.0, -28.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (145) (-33.0, 40.0, -30.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (143) (-33.0, 40.0, -28.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (556) (-30.0, 40.0, -35.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (137) (-39.0, 40.0, -28.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (93) (-41.0, 40.0, -28.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (94) (-39.0, 40.0, -33.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (479) (-38.5, 40.0, -34.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (480) (-38.5, 40.0, -35.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (478) (-39.5, 40.0, -34.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (190) (-37.0, 40.0, -33.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (481) (-39.5, 40.0, -35.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (-41.0, 40.0, -37.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (6) (-39.0, 40.0, -37.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (1) (-41.0, 40.0, -39.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (4) (-39.0, 40.0, -39.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (2) (-41.0, 40.0, -41.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (7) (-39.0, 40.0, -41.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (128) (-39.5, 40.0, -43.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (130) (-39.5, 40.0, -42.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (5) (-41.0, 40.0, -43.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (545) (-37.5, 40.0, -41.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (538) (-37.5, 40.0, -42.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (131) (-38.5, 40.0, -43.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (126) (-38.5, 40.0, -42.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (544) (-36.5, 40.0, -41.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (542) (-37.5, 40.0, -40.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (543) (-36.5, 40.0, -40.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (541) (-37.5, 40.0, -43.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (540) (-36.5, 40.0, -43.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (539) (-36.5, 40.0, -42.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (546) (-35.5, 40.0, -42.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (548) (-34.5, 40.0, -43.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (549) (-35.5, 40.0, -43.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (547) (-34.5, 40.0, -42.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (191) (-38.0, 40.0, -45.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (689) (-40.0, 40.0, -44.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (687) (-41.0, 40.0, -44.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (690) (-40.0, 40.0, -45.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (688) (-41.0, 40.0, -45.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (117) (-42.5, 40.0, -41.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (114) (-42.5, 40.0, -40.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (98) (-43.0, 40.0, -39.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (116) (-43.5, 40.0, -40.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (115) (-43.5, 40.0, -41.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (121) (-44.5, 40.0, -41.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (113) (-44.5, 40.0, -39.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (118) (-44.5, 40.0, -40.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (192) (-43.0, 40.0, -43.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (110) (-44.5, 40.0, -38.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (95) (-43.0, 40.0, -37.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (96) (-45.0, 40.0, -37.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (112) (-45.5, 40.0, -38.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (111) (-45.5, 40.0, -39.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (124) (-46.5, 40.0, -38.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (97) (-47.0, 40.0, -37.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (122) (-47.5, 40.0, -38.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (123) (-46.5, 40.0, -39.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (125) (-47.5, 40.0, -39.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (134) (-46.5, 40.0, -40.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (120) (-45.5, 40.0, -40.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (119) (-45.5, 40.0, -41.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (108) (-48.5, 40.0, -37.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (109) (-49.5, 40.0, -37.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (136) (-47.5, 40.0, -40.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (135) (-47.5, 40.0, -41.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (137) (-46.5, 40.0, -41.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (196) (-47.3, 40.0, -43.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (133) (-49.0, 40.0, -44.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (686) (-50.0, 40.0, -43.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (685) (-51.0, 40.0, -42.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (684) (-52.0, 40.0, -42.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (683) (-52.0, 40.0, -43.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (682) (-51.0, 40.0, -43.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (680) (-52.0, 40.0, -44.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (127) (-50.0, 40.0, -44.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (129) (-51.0, 40.0, -44.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (450) (-51.0, 40.0, -45.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (681) (-52.0, 40.0, -45.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (453) (-50.0, 40.0, -45.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (679) (-49.0, 40.0, -45.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (115) (-53.5, 40.0, -43.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (8) (-51.0, 40.0, -39.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (99) (-51.0, 40.0, -37.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (106) (-49.5, 40.0, -36.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (3) (-53.0, 40.0, -37.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (107) (-48.5, 40.0, -36.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (138) (-71.5, 40.0, -38.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (141) (-71.5, 40.0, -39.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (140) (-72.5, 40.0, -38.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (139) (-72.5, 40.0, -39.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (102) (-72.0, 40.0, -41.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (105) (-72.0, 40.0, -43.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (104) (-74.0, 40.0, -41.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (101) (-74.0, 40.0, -39.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (153) (-76.5, 40.0, -41.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (145) (-75.5, 40.0, -39.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (152) (-75.5, 40.0, -40.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (151) (-75.5, 40.0, -41.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (143) (-76.5, 40.0, -39.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (150) (-76.5, 40.0, -40.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (103) (-74.0, 40.0, -43.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (144) (-76.5, 40.0, -38.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (142) (-75.5, 40.0, -38.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (100) (-76.0, 40.0, -37.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (147) (-77.5, 40.0, -37.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (148) (-77.5, 40.0, -36.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (149) (-78.5, 40.0, -37.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (146) (-78.5, 40.0, -36.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (156) (-82.5, 40.0, -36.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (155) (-82.5, 40.0, -37.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (154) (-83.5, 40.0, -36.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (157) (-83.5, 40.0, -37.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (907) (-48.5, 43.0, 20.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (908) (-48.5, 43.0, 21.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (905) (-49.5, 43.0, 21.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (906) (-49.5, 43.0, 20.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (911) (-53.8, 43.0, 20.3)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (909) (-53.8, 43.0, 21.3)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (910) (-54.8, 43.0, 21.3)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (819) (-52.0, 28.0, -52.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (817) (-51.0, 28.0, -52.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (818) (-52.0, 28.0, -53.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (820) (-51.0, 28.0, -53.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (813) (-46.5, 28.0, -61.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (816) (-46.5, 28.0, -62.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (814) (-47.5, 28.0, -62.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (815) (-47.5, 28.0, -61.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (807) (-44.0, 28.0, -62.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (803) (-45.0, 28.0, -64.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (806) (-44.0, 28.0, -63.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (801) (-44.0, 28.0, -64.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (805) (-43.0, 28.0, -62.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (808) (-43.0, 28.0, -63.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (811) (-42.0, 28.0, -63.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (809) (-41.0, 28.0, -63.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (810) (-42.0, 28.0, -64.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (812) (-41.0, 28.0, -64.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (804) (-44.0, 28.0, -65.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (802) (-45.0, 28.0, -65.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (529) (-35.0, 28.0, -62.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (527) (-34.0, 28.0, -61.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (528) (-34.0, 28.0, -62.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (526) (-35.0, 28.0, -61.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (641) (-32.0, 28.0, -65.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (642) (-32.0, 28.0, -66.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (640) (-31.0, 28.0, -65.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (636) (-30.0, 28.0, -65.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (639) (-31.0, 28.0, -66.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (637) (-29.0, 28.0, -66.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (635) (-29.0, 28.0, -65.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (638) (-30.0, 28.0, -66.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (744) (-32.5, 28.0, -85.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (741) (-32.5, 28.0, -86.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (158) (-32.0, 28.0, -84.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (742) (-31.5, 28.0, -85.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (743) (-31.5, 28.0, -86.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (748) (-29.5, 28.0, -84.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (745) (-30.5, 28.0, -83.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (746) (-30.5, 28.0, -84.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (163) (-30.0, 28.0, -88.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (162) (-30.0, 28.0, -86.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (747) (-29.5, 28.0, -83.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (750) (-30.5, 28.0, -90.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (749) (-30.5, 28.0, -89.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (751) (-29.5, 28.0, -89.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (752) (-29.5, 28.0, -90.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (165) (-57.5, 28.0, -64.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (162) (-57.5, 28.0, -63.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (164) (-58.5, 28.0, -63.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (163) (-58.5, 28.0, -64.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (176) (-59.5, 28.0, -65.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (173) (-59.5, 28.0, -64.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (170) (-59.5, 28.0, -63.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (159) (-59.5, 28.0, -62.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (172) (-60.5, 28.0, -63.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (174) (-60.5, 28.0, -65.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (171) (-60.5, 28.0, -64.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (175) (-59.5, 28.0, -66.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (177) (-60.5, 28.0, -66.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (112) (-56.0, 28.0, -64.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (110) (-58.0, 28.0, -62.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (111) (-56.0, 28.0, -62.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (160) (-59.5, 28.0, -61.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (169) (-59.5, 28.0, -60.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (108) (-58.0, 28.0, -60.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (158) (-60.5, 28.0, -61.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (161) (-60.5, 28.0, -62.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (109) (-56.0, 28.0, -60.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (107) (-58.0, 28.0, -58.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (166) (-59.5, 28.0, -59.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (168) (-60.5, 28.0, -59.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (167) (-60.5, 28.0, -60.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (180) (-61.5, 28.0, -61.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (178) (-62.5, 28.0, -61.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (179) (-61.5, 28.0, -62.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (181) (-62.5, 28.0, -62.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (713) (-62.5, 28.0, -74.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (714) (-62.5, 28.0, -75.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (715) (-63.5, 28.0, -74.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (716) (-63.5, 28.0, -75.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (711) (-66.0, 28.0, -76.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (710) (-66.0, 28.0, -77.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (712) (-67.0, 28.0, -76.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (709) (-67.0, 28.0, -77.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (160) (-61.5, 28.0, -81.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (157) (-59.5, 28.0, -81.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (156) (-59.5, 28.0, -79.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (154) (-57.5, 28.0, -79.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (159) (-61.5, 28.0, -83.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (155) (-59.5, 28.0, -83.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (152) (-57.5, 28.0, -83.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (153) (-57.5, 28.0, -81.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (727) (-63.0, 28.0, -83.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (725) (-64.0, 28.0, -83.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (728) (-64.0, 28.0, -84.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (726) (-63.0, 28.0, -84.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (722) (-63.0, 28.0, -86.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (723) (-63.0, 28.0, -85.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (721) (-64.0, 28.0, -85.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (717) (-62.0, 28.0, -85.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (720) (-62.0, 28.0, -86.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (719) (-61.0, 28.0, -85.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (724) (-64.0, 28.0, -86.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (718) (-61.0, 28.0, -86.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (234) (-69.5, 28.0, -96.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (236) (-68.5, 28.0, -96.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (237) (-69.5, 28.0, -97.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (230) (-69.5, 28.0, -98.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (240) (-67.5, 28.0, -98.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (232) (-68.5, 28.0, -98.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (235) (-68.5, 28.0, -97.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (233) (-69.5, 28.0, -99.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (231) (-68.5, 28.0, -99.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (239) (-67.5, 28.0, -99.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (241) (-66.5, 28.0, -99.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (238) (-66.5, 28.0, -98.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (739) (-71.5, 28.0, -84.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (737) (-72.5, 28.0, -84.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (734) (-73.5, 28.0, -84.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (735) (-73.5, 28.0, -83.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (733) (-74.5, 28.0, -83.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (736) (-74.5, 28.0, -84.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (740) (-72.5, 28.0, -85.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (738) (-71.5, 28.0, -85.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (731) (-74.5, 28.0, -85.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (729) (-75.5, 28.0, -85.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (732) (-75.5, 28.0, -86.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (730) (-74.5, 28.0, -86.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (227) (-83.5, 28.0, -84.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (229) (-84.5, 28.0, -84.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (228) (-83.5, 28.0, -83.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (226) (-84.5, 28.0, -83.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (222) (-85.5, 28.0, -85.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (119) (-86.0, 28.0, -82.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (122) (-86.0, 28.0, -84.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (224) (-86.5, 28.0, -85.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (211) (-87.5, 28.0, -84.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (208) (-87.5, 28.0, -83.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (210) (-88.5, 28.0, -83.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (209) (-88.5, 28.0, -84.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (223) (-86.5, 28.0, -86.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (161) (-88.0, 28.0, -86.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (225) (-85.5, 28.0, -86.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (217) (-89.5, 28.0, -86.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (186) (-88.0, 28.0, -88.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (165) (-88.0, 28.0, -88.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (164) (-86.0, 28.0, -88.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (203) (-89.5, 28.0, -84.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (218) (-89.5, 28.0, -85.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (214) (-89.5, 28.0, -83.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (216) (-90.5, 28.0, -85.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (215) (-90.5, 28.0, -84.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (202) (-90.5, 28.0, -83.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (219) (-90.5, 28.0, -86.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (207) (-89.5, 28.0, -82.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (198) (-89.5, 28.0, -81.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (123) (-88.0, 28.0, -82.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (213) (-89.5, 28.0, -80.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (199) (-90.5, 28.0, -82.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (121) (-88.0, 28.0, -80.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (200) (-89.5, 28.0, -79.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (212) (-90.5, 28.0, -79.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (201) (-90.5, 28.0, -80.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (206) (-90.5, 28.0, -81.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (220) (-91.5, 28.0, -81.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (205) (-91.5, 28.0, -82.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (221) (-92.5, 28.0, -82.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (204) (-92.5, 28.0, -81.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (120) (-86.0, 28.0, -80.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (118) (-88.0, 28.0, -78.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (703) (-78.0, 28.0, -75.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (704) (-78.0, 28.0, -76.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (705) (-77.0, 28.0, -74.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (702) (-77.0, 28.0, -75.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (701) (-77.0, 28.0, -76.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (706) (-76.0, 28.0, -74.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (708) (-77.0, 28.0, -73.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (707) (-76.0, 28.0, -73.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (117) (-57.0, 28.0, -47.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (114) (-55.0, 28.0, -45.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Bush (113) (-57.0, 28.0, -45.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (183) (-58.5, 28.0, -45.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (184) (-58.5, 28.0, -44.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (185) (-59.5, 28.0, -45.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (197) (-60.5, 28.0, -46.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (196) (-61.5, 28.0, -45.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (195) (-61.5, 28.0, -46.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (194) (-60.5, 28.0, -45.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (190) (-62.5, 28.0, -45.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (193) (-62.5, 28.0, -46.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (191) (-63.5, 28.0, -46.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (182) (-59.5, 28.0, -44.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (192) (-63.5, 28.0, -45.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (189) (-64.5, 28.0, -45.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (186) (-64.5, 28.0, -44.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (187) (-65.5, 28.0, -45.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (188) (-65.5, 28.0, -44.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (-132.0, 28.0, -52.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (3) (-132.0, 28.0, -53.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1) (-133.0, 28.0, -52.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (2) (-131.0, 28.0, -52.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (5) (-120.5, 28.0, -52.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (4) (-119.5, 28.0, -52.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (7) (-119.5, 28.0, -51.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (8) (-117.5, 28.0, -55.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (6) (-116.5, 28.0, -55.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (9) (-116.5, 28.0, -54.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1083) (-86.5, 12.0, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1082) (-85.5, 12.0, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1084) (-85.5, 12.0, -130.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1085) (-86.5, 12.0, -130.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1087) (-87.5, 12.0, -130.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1089) (-88.5, 12.0, -130.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1086) (-87.5, 12.0, -129.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1088) (-88.5, 12.0, -129.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1080) (-89.0, 12.0, -143.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1081) (-90.0, 12.0, -143.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1078) (-89.0, 12.0, -144.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1075) (-88.0, 12.0, -144.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1079) (-90.0, 12.0, -144.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1074) (-87.0, 12.0, -144.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1077) (-88.0, 12.0, -145.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1076) (-87.0, 12.0, -145.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1070) (-78.0, 12.0, -142.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1072) (-77.0, 12.0, -143.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1071) (-77.0, 12.0, -142.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1073) (-78.0, 12.0, -143.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (294) (-64.0, 12.0, -144.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (292) (-64.0, 12.0, -145.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (290) (-64.0, 12.0, -143.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (74) (-65.0, 12.0, -143.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (293) (-63.0, 12.0, -144.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (132) (-63.0, 12.0, -143.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (291) (-63.0, 12.0, -145.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (77) (-64.0, 12.0, -142.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (76) (-63.0, 12.0, -142.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (73) (-65.0, 12.0, -142.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (75) (-66.0, 12.0, -143.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (70) (-66.0, 12.0, -142.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1093) (-55.0, 12.0, -136.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1092) (-54.0, 12.0, -136.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1090) (-55.0, 12.0, -135.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1091) (-54.0, 12.0, -135.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1056) (-68.0, 12.0, -134.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1054) (-69.0, 12.0, -134.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1050) (-67.0, 12.0, -134.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1057) (-68.0, 12.0, -133.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1052) (-66.0, 12.0, -134.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1053) (-66.0, 12.0, -133.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1051) (-67.0, 12.0, -133.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1060) (-68.0, 12.5, -132.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1055) (-69.0, 12.0, -133.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1058) (-69.0, 12.5, -132.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1062) (-70.0, 12.5, -132.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1061) (-68.0, 12.5, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1059) (-69.0, 12.5, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1063) (-70.0, 12.5, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1065) (-71.0, 12.0, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1064) (-71.0, 12.0, -132.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1047) (-72.0, 12.0, -132.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1068) (-72.0, 13.0, -129.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1067) (-72.0, 12.5, -130.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1048) (-72.0, 12.0, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1066) (-73.0, 12.5, -130.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1069) (-73.0, 12.5, -129.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1046) (-73.0, 12.0, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1044) (-74.0, 12.0, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1043) (-74.0, 12.0, -130.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1049) (-73.0, 12.0, -132.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1045) (-75.0, 12.0, -131.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (1042) (-75.0, 12.0, -130.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (842) (17.0, 20.0, -118.5)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Grass (419) (-4.0, 44.0, -62.0)": TunicLocationData("Overworld", "Overworld"),
    "Overworld - Overworld Swamp Lower Entry Grass (1103) (80.5, 2.7, -175.6)": TunicLocationData(
        "Overworld Swamp Lower Entry", "Overworld Swamp Lower Entry"),
    "Overworld - Overworld Swamp Lower Entry Grass (1102) (80.5, 2.7, -174.6)": TunicLocationData(
        "Overworld Swamp Lower Entry", "Overworld Swamp Lower Entry"),
    "Overworld - Overworld Swamp Lower Entry Grass (1100) (79.5, 2.1, -174.6)": TunicLocationData(
        "Overworld Swamp Lower Entry", "Overworld Swamp Lower Entry"),
    "Overworld - Overworld Swamp Lower Entry Grass (1101) (79.5, 2.1, -175.6)": TunicLocationData(
        "Overworld Swamp Lower Entry", "Overworld Swamp Lower Entry"),
    "Overworld - Overworld Swamp Lower Entry Grass (1096) (78.4, 2.2, -171.6)": TunicLocationData(
        "Overworld Swamp Lower Entry", "Overworld Swamp Lower Entry"),
    "Overworld - Overworld Swamp Lower Entry Grass (1097) (77.5, 2.0, -171.6)": TunicLocationData(
        "Overworld Swamp Lower Entry", "Overworld Swamp Lower Entry"),
    "Overworld - Overworld Swamp Lower Entry Grass (1099) (77.4, 2.2, -170.6)": TunicLocationData(
        "Overworld Swamp Lower Entry", "Overworld Swamp Lower Entry"),
    "Overworld - Overworld Swamp Lower Entry Grass (1098) (78.5, 2.6, -170.6)": TunicLocationData(
        "Overworld Swamp Lower Entry", "Overworld Swamp Lower Entry"),
    "Overworld - After Ruined Passage Grass (327) (53.0, 20.0, -144.0)": TunicLocationData("After Ruined Passage",
                                                                                           "After Ruined Passage"),
    "Overworld - After Ruined Passage Grass (296) (52.0, 20.0, -144.0)": TunicLocationData("After Ruined Passage",
                                                                                           "After Ruined Passage"),
    "Overworld - After Ruined Passage Grass (297) (51.0, 20.0, -144.0)": TunicLocationData("After Ruined Passage",
                                                                                           "After Ruined Passage"),
    "Overworld - After Ruined Passage Grass (326) (54.0, 20.0, -144.0)": TunicLocationData("After Ruined Passage",
                                                                                           "After Ruined Passage"),
    "Overworld - After Ruined Passage Grass (295) (52.0, 20.0, -145.0)": TunicLocationData("After Ruined Passage",
                                                                                           "After Ruined Passage"),
    "Overworld - After Ruined Passage Grass (265) (51.0, 20.0, -145.0)": TunicLocationData("After Ruined Passage",
                                                                                           "After Ruined Passage"),
    "Overworld - After Ruined Passage Grass (325) (53.0, 20.0, -145.0)": TunicLocationData("After Ruined Passage",
                                                                                           "After Ruined Passage"),
    "Overworld - After Ruined Passage Grass (298) (54.0, 20.0, -145.0)": TunicLocationData("After Ruined Passage",
                                                                                           "After Ruined Passage"),
    "Overworld - After Ruined Passage Grass (661) (47.5, 20.0, -142.5)": TunicLocationData("After Ruined Passage",
                                                                                           "After Ruined Passage"),
    "Overworld - After Ruined Passage Grass (328) (47.5, 20.0, -141.5)": TunicLocationData("After Ruined Passage",
                                                                                           "After Ruined Passage"),
    "Overworld - After Ruined Passage Grass (662) (46.5, 20.0, -142.5)": TunicLocationData("After Ruined Passage",
                                                                                           "After Ruined Passage"),
    "Overworld - After Ruined Passage Grass (660) (46.5, 20.0, -141.5)": TunicLocationData("After Ruined Passage",
                                                                                           "After Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (31) (66.0, 28.0, -120.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (29) (67.0, 28.0, -120.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (28) (67.0, 28.0, -119.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (26) (67.0, 28.0, -118.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (30) (66.0, 28.0, -119.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (21) (67.0, 28.0, -116.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (27) (67.0, 28.0, -117.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (25) (66.0, 28.0, -117.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (24) (66.0, 28.0, -118.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (20) (67.0, 28.0, -115.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (23) (66.0, 28.0, -116.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (22) (66.0, 28.0, -115.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (12) (56.0, 28.0, -126.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (10) (56.0, 28.0, -128.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (13) (56.0, 28.0, -127.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (14) (55.0, 28.0, -126.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (15) (55.0, 28.0, -127.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (5) (55.0, 28.0, -128.0)": TunicLocationData("Above Ruined Passage",
                                                                                         "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (11) (57.0, 28.0, -128.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (9) (57.0, 28.0, -129.0)": TunicLocationData("Above Ruined Passage",
                                                                                         "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (8) (56.0, 28.0, -129.0)": TunicLocationData("Above Ruined Passage",
                                                                                         "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (18) (54.0, 28.0, -127.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (4) (54.0, 28.0, -128.0)": TunicLocationData("Above Ruined Passage",
                                                                                         "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (6) (54.0, 28.0, -129.0)": TunicLocationData("Above Ruined Passage",
                                                                                         "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (17) (53.0, 28.0, -126.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (16) (53.0, 28.0, -127.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (3) (53.0, 28.0, -128.0)": TunicLocationData("Above Ruined Passage",
                                                                                         "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (2) (53.0, 28.0, -129.0)": TunicLocationData("Above Ruined Passage",
                                                                                         "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (1) (52.0, 28.0, -128.0)": TunicLocationData("Above Ruined Passage",
                                                                                         "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (52.0, 28.0, -129.0)": TunicLocationData("Above Ruined Passage",
                                                                                     "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (7) (55.0, 28.0, -129.0)": TunicLocationData("Above Ruined Passage",
                                                                                         "Above Ruined Passage"),
    "Overworld - Above Ruined Passage Grass (19) (54.0, 28.0, -126.0)": TunicLocationData("Above Ruined Passage",
                                                                                          "Above Ruined Passage"),
    "Overworld - East Overworld Grass (1118) (98.5, 36.0, -136.0)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1119) (98.5, 36.0, -137.0)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1116) (99.5, 36.0, -136.0)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1115) (98.5, 36.0, -139.0)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1114) (98.5, 36.0, -138.0)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1112) (99.5, 36.0, -138.0)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1117) (99.5, 36.0, -137.0)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1113) (99.5, 36.0, -139.0)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1109) (95.0, 36.0, -127.0)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1104) (95.0, 36.0, -128.0)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1108) (95.0, 36.0, -126.0)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1111) (94.0, 36.0, -127.0)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1110) (94.0, 36.0, -126.0)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1106) (94.0, 36.0, -128.0)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1107) (94.0, 36.0, -129.0)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1105) (95.0, 36.0, -129.0)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (331) (86.0, 36.0, -128.0)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (329) (85.0, 36.0, -128.0)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (655) (85.0, 36.0, -129.0)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (657) (84.0, 36.0, -129.0)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (658) (84.0, 36.0, -128.0)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (330) (86.0, 36.0, -129.0)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (656) (83.0, 36.0, -128.0)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (659) (83.0, 36.0, -129.0)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (1120) (86.0, 36.0, -123.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1124) (86.0, 36.0, -122.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1126) (83.0, 36.0, -120.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1127) (82.0, 36.0, -120.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (309) (81.5, 36.0, -118.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (308) (81.5, 36.0, -119.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (307) (80.5, 36.0, -118.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (324) (80.5, 36.0, -119.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (305) (79.5, 36.0, -118.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (304) (79.5, 36.0, -119.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (300) (79.5, 36.0, -121.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (301) (79.5, 36.0, -120.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (1128) (82.0, 36.0, -121.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (303) (78.5, 36.0, -118.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (306) (78.5, 36.0, -119.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (299) (78.5, 36.0, -120.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (1122) (77.5, 36.0, -120.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1123) (77.5, 36.0, -121.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1121) (76.5, 36.0, -121.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (302) (78.5, 36.0, -121.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Bush (18) (82.5, 44.0, -109.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (20) (82.5, 44.0, -111.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (92) (84.5, 44.0, -109.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (19) (82.5, 44.0, -107.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (78) (79.0, 44.0, -112.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (83) (80.0, 44.0, -112.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (85) (80.0, 44.0, -113.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (84) (81.0, 44.0, -112.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (80) (79.0, 44.0, -113.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (87) (82.0, 44.0, -112.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (82) (81.0, 44.0, -113.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (86) (83.0, 44.0, -113.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (89) (82.0, 44.0, -113.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (88) (83.0, 44.0, -112.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (81) (78.0, 44.0, -112.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (52) (76.0, 44.0, -113.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (50) (76.0, 44.0, -112.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (53) (75.0, 44.0, -112.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (79) (78.0, 44.0, -113.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (51) (75.0, 44.0, -113.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (57) (78.0, 44.0, -107.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (21) (80.0, 44.0, -107.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (56) (76.5, 44.0, -107.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (54) (76.5, 44.0, -106.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (55) (75.5, 44.0, -107.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (57) (75.5, 44.0, -106.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (103) (90.0, 44.0, -113.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (105) (90.0, 44.0, -112.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (102) (91.0, 44.0, -112.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (104) (91.0, 44.0, -113.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Bush (44) (93.0, 44.0, -113.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (45) (95.0, 44.0, -113.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (1150) (94.5, 44.0, -111.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1149) (95.5, 44.0, -111.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1151) (94.5, 44.0, -110.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Bush (50) (97.0, 44.0, -113.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (56) (97.0, 44.0, -113.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (1148) (95.5, 44.0, -110.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (96) (94.5, 44.0, -109.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (95) (93.5, 44.0, -109.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (101) (95.5, 44.0, -109.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (94) (94.5, 44.0, -108.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (97) (93.5, 44.0, -108.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (99) (95.5, 44.0, -108.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (46) (95.0, 44.0, -107.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (22) (93.0, 44.0, -107.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (90) (91.5, 44.0, -107.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (55) (97.0, 44.0, -107.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (49) (97.0, 44.0, -107.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (92) (91.5, 44.0, -106.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (91) (90.5, 44.0, -106.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (93) (90.5, 44.0, -107.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (46) (71.0, 44.0, -110.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (15) (72.5, 44.0, -111.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (48) (71.0, 44.0, -111.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (61) (70.5, 44.0, -107.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (10) (70.5, 44.0, -109.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (49) (70.0, 44.0, -110.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (62) (69.0, 44.0, -107.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (63) (68.5, 44.0, -109.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (65) (68.0, 44.0, -107.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (58) (67.0, 44.0, -107.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (45) (68.0, 44.0, -111.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (43) (68.0, 44.0, -110.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (44) (69.0, 44.0, -110.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (42) (69.0, 44.0, -111.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (47) (70.0, 44.0, -111.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (64) (69.0, 44.0, -106.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (63) (68.0, 44.0, -106.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (60) (67.0, 44.0, -106.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (59) (66.0, 44.0, -106.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (61) (66.0, 44.0, -107.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (60) (66.5, 44.0, -109.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (83) (64.5, 44.0, -107.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (62) (66.5, 44.0, -111.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (80) (66.5, 44.0, -113.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (58) (58.0, 44.0, -109.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (30) (56.5, 44.0, -109.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (59) (58.0, 44.0, -111.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (34) (56.5, 44.0, -110.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (36) (56.5, 44.0, -111.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (14) (58.0, 44.0, -113.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (32) (56.5, 44.0, -108.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (64) (56.0, 44.0, -107.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (37) (55.5, 44.0, -110.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (31) (55.5, 44.0, -108.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (33) (55.5, 44.0, -109.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (35) (55.5, 44.0, -111.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (38) (54.5, 44.0, -110.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (40) (54.5, 44.0, -111.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (41) (53.5, 44.0, -110.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (81) (54.0, 44.0, -113.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (39) (53.5, 44.0, -111.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (26) (52.5, 44.0, -111.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (65) (54.0, 44.0, -109.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (28) (52.5, 44.0, -110.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (16) (52.5, 44.0, -108.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (14) (52.5, 44.0, -109.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (17) (51.5, 44.0, -109.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (27) (51.5, 44.0, -110.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (29) (51.5, 44.0, -111.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (12) (58.0, 44.0, -107.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (66) (54.0, 44.0, -107.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (11) (52.5, 44.0, -107.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (12) (51.5, 44.0, -107.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (15) (51.5, 44.0, -108.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (24) (50.5, 44.0, -108.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (18) (50.5, 44.0, -107.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (22) (50.5, 44.0, -109.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (25) (49.5, 44.0, -109.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (21) (49.5, 44.0, -107.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (23) (49.5, 44.0, -108.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (13) (51.5, 44.0, -106.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (10) (52.5, 44.0, -106.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (20) (50.5, 44.0, -106.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (19) (49.5, 44.0, -106.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (69) (48.0, 44.0, -109.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (68) (48.0, 44.0, -111.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (67) (48.0, 44.0, -113.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (72) (46.0, 44.0, -111.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (70) (46.0, 44.0, -113.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (71) (46.0, 44.0, -109.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (76) (44.0, 44.0, -111.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (73) (44.0, 44.0, -113.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (66) (46.5, 44.0, -107.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (69) (45.5, 44.0, -107.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (67) (45.5, 44.0, -106.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (82) (44.0, 44.0, -107.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (68) (46.5, 44.0, -106.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (79) (42.0, 44.0, -107.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (78) (42.0, 44.0, -109.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (74) (40.0, 44.0, -109.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (77) (42.0, 44.0, -111.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (75) (42.0, 44.0, -113.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (88) (40.0, 44.0, -107.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (1006) (33.5, 44.0, -109.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1008) (33.5, 44.0, -108.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Bush (89) (33.0, 44.0, -111.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (72) (34.5, 44.0, -112.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Bush (90) (33.0, 44.0, -113.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (984) (35.5, 44.0, -112.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (985) (34.5, 44.0, -113.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (71) (35.5, 44.0, -113.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (1009) (32.5, 44.0, -109.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1007) (32.5, 44.0, -108.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (986) (31.5, 44.0, -109.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Bush (91) (31.0, 44.0, -111.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (989) (30.5, 44.0, -109.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (987) (30.5, 44.0, -108.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (988) (31.5, 44.0, -108.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (1000) (31.5, 44.0, -106.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (998) (31.5, 44.0, -107.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (1001) (30.5, 44.0, -107.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (999) (30.5, 44.0, -106.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (1005) (30.5, 44.0, -105.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1002) (31.5, 44.0, -105.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1004) (31.5, 44.0, -104.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (1003) (30.5, 44.0, -104.5)": TunicLocationData("East Overworld",
                                                                                      "East Overworld"),
    "Overworld - East Overworld Grass (993) (36.5, 44.0, -105.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (990) (37.5, 44.0, -105.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (991) (36.5, 44.0, -104.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (992) (37.5, 44.0, -104.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (994) (37.5, 44.0, -103.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (996) (37.5, 44.0, -102.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (997) (36.5, 44.0, -103.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (995) (36.5, 44.0, -102.5)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (881) (27.8, 44.0, -74.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (864) (28.8, 44.0, -75.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (863) (28.8, 44.0, -74.0)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (1012) (23.5, 44.0, -98.0)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (1011) (22.5, 44.0, -98.0)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (1013) (22.5, 44.0, -99.0)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (1010) (23.5, 44.0, -99.0)": TunicLocationData("East Overworld",
                                                                                     "East Overworld"),
    "Overworld - East Overworld Grass (319) (36.5, 44.0, -40.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (318) (35.5, 44.0, -40.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (315) (35.5, 44.0, -41.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (316) (34.5, 44.0, -41.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (882) (65.3, 44.0, -15.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (317) (65.3, 44.0, -14.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - East Overworld Grass (883) (64.3, 44.0, -14.5)": TunicLocationData("East Overworld", "East Overworld"),
    "Overworld - Upper Overworld Grass (904) (30.3, 66.0, 26.5)": TunicLocationData("Upper Overworld",
                                                                                    "Upper Overworld"),
    "Overworld - Upper Overworld Grass (901) (29.3, 66.0, 27.3)": TunicLocationData("Upper Overworld",
                                                                                    "Upper Overworld"),
    "Overworld - Upper Overworld Grass (903) (29.3, 66.0, 26.5)": TunicLocationData("Upper Overworld",
                                                                                    "Upper Overworld"),
    "Overworld - Upper Overworld Grass (902) (28.3, 66.0, 27.3)": TunicLocationData("Upper Overworld",
                                                                                    "Upper Overworld"),
    "Overworld - Upper Overworld Grass (898) (17.5, 66.0, 25.3)": TunicLocationData("Upper Overworld",
                                                                                    "Upper Overworld"),
    "Overworld - Upper Overworld Grass (899) (17.5, 66.0, 26.3)": TunicLocationData("Upper Overworld",
                                                                                    "Upper Overworld"),
    "Overworld - Upper Overworld Grass (900) (16.5, 66.0, 26.3)": TunicLocationData("Upper Overworld",
                                                                                    "Upper Overworld"),
    "Overworld - Upper Overworld Grass (897) (16.5, 66.0, 25.3)": TunicLocationData("Upper Overworld",
                                                                                    "Upper Overworld"),
    "Overworld - Upper Overworld Grass (927) (-30.8, 66.0, 34.3)": TunicLocationData("Upper Overworld",
                                                                                     "Upper Overworld"),
    "Overworld - Upper Overworld Grass (924) (-30.8, 66.0, 35.3)": TunicLocationData("Upper Overworld",
                                                                                     "Upper Overworld"),
    "Overworld - Upper Overworld Grass (925) (-31.8, 66.0, 34.3)": TunicLocationData("Upper Overworld",
                                                                                     "Upper Overworld"),
    "Overworld - Upper Overworld Grass (926) (-31.8, 66.0, 35.3)": TunicLocationData("Upper Overworld",
                                                                                     "Upper Overworld"),
    "Overworld - Upper Overworld Grass (922) (-40.3, 66.0, 33.5)": TunicLocationData("Upper Overworld",
                                                                                     "Upper Overworld"),
    "Overworld - Upper Overworld Grass (919) (-40.3, 66.0, 34.5)": TunicLocationData("Upper Overworld",
                                                                                     "Upper Overworld"),
    "Overworld - Upper Overworld Grass (923) (-41.3, 66.0, 33.5)": TunicLocationData("Upper Overworld",
                                                                                     "Upper Overworld"),
    "Overworld - Upper Overworld Grass (918) (-40.3, 66.0, 35.5)": TunicLocationData("Upper Overworld",
                                                                                     "Upper Overworld"),
    "Overworld - Upper Overworld Grass (921) (-41.3, 66.0, 35.5)": TunicLocationData("Upper Overworld",
                                                                                     "Upper Overworld"),
    "Overworld - Upper Overworld Grass (920) (-41.3, 66.0, 34.5)": TunicLocationData("Upper Overworld",
                                                                                     "Upper Overworld"),
    "Overworld - Overworld at Patrol Cave Grass (1094) (65.0, 44.0, 17.5)": TunicLocationData(
        "Overworld at Patrol Cave", "Overworld at Patrol Cave"),
    "Overworld - Overworld at Patrol Cave Grass (885) (65.0, 44.0, 18.5)": TunicLocationData("Overworld at Patrol Cave",
                                                                                             "Overworld at Patrol Cave"),
    "Overworld - Overworld at Patrol Cave Grass (314) (66.0, 44.0, 19.5)": TunicLocationData("Overworld at Patrol Cave",
                                                                                             "Overworld at Patrol Cave"),
    "Overworld - Overworld at Patrol Cave Grass (1095) (66.0, 44.0, 18.5)": TunicLocationData(
        "Overworld at Patrol Cave", "Overworld at Patrol Cave"),
    "Overworld - Overworld at Patrol Cave Grass (884) (65.0, 44.0, 19.5)": TunicLocationData("Overworld at Patrol Cave",
                                                                                             "Overworld at Patrol Cave"),
    "Overworld - Overworld at Patrol Cave Grass (888) (57.0, 44.0, 18.3)": TunicLocationData("Overworld at Patrol Cave",
                                                                                             "Overworld at Patrol Cave"),
    "Overworld - Overworld at Patrol Cave Grass (887) (57.0, 44.0, 19.3)": TunicLocationData("Overworld at Patrol Cave",
                                                                                             "Overworld at Patrol Cave"),
    "Overworld - Overworld at Patrol Cave Grass (893) (56.0, 44.0, 19.3)": TunicLocationData("Overworld at Patrol Cave",
                                                                                             "Overworld at Patrol Cave"),
    "Overworld - Overworld at Patrol Cave Grass (892) (56.0, 44.0, 18.3)": TunicLocationData("Overworld at Patrol Cave",
                                                                                             "Overworld at Patrol Cave"),
    "Overworld - Overworld above Patrol Cave Grass (895) (44.0, 55.0, 23.5)": TunicLocationData(
        "Overworld above Patrol Cave", "Overworld above Patrol Cave"),
    "Overworld - Overworld above Patrol Cave Grass (896) (43.0, 55.0, 23.5)": TunicLocationData(
        "Overworld above Patrol Cave", "Overworld above Patrol Cave"),
    "Overworld - Overworld above Patrol Cave Grass (886) (37.3, 55.0, 23.5)": TunicLocationData(
        "Overworld above Patrol Cave", "Overworld above Patrol Cave"),
    "Overworld - Overworld above Patrol Cave Grass (889) (37.3, 55.0, 22.5)": TunicLocationData(
        "Overworld above Patrol Cave", "Overworld above Patrol Cave"),
    "Overworld - Overworld above Patrol Cave Grass (891) (36.3, 55.0, 23.5)": TunicLocationData(
        "Overworld above Patrol Cave", "Overworld above Patrol Cave"),
    "Overworld - Overworld above Patrol Cave Grass (890) (36.3, 55.0, 22.5)": TunicLocationData(
        "Overworld above Patrol Cave", "Overworld above Patrol Cave"),
    "Overworld - Overworld above Patrol Cave Grass (894) (35.3, 55.0, 23.5)": TunicLocationData(
        "Overworld above Patrol Cave", "Overworld above Patrol Cave"),
    "Overworld - Overworld to West Garden from Furnace Grass (1145) (-182.5, 4.0, -45.5)": TunicLocationData(
        "West Garden", "Overworld to West Garden from Furnace"),
    "Overworld - Overworld to West Garden from Furnace Grass (1143) (-181.5, 4.0, -44.5)": TunicLocationData(
        "West Garden", "Overworld to West Garden from Furnace"),
    "Overworld - Overworld to West Garden from Furnace Grass (1144) (-182.5, 4.0, -44.5)": TunicLocationData(
        "West Garden", "Overworld to West Garden from Furnace"),
    "Overworld - Overworld to West Garden from Furnace Grass (1146) (-183.5, 4.0, -45.5)": TunicLocationData(
        "West Garden", "Overworld to West Garden from Furnace"),
    "Overworld - Overworld to West Garden from Furnace Grass (1147) (-183.5, 4.0, -44.5)": TunicLocationData(
        "West Garden", "Overworld to West Garden from Furnace"),
    "Overworld - Overworld Beach Grass (1032) (-118.5, 3.5, -144.0)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1031) (-118.5, 3.5, -143.0)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1036) (-118.5, 3.5, -142.0)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1033) (-119.5, 3.5, -144.0)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1037) (-119.5, 3.5, -142.0)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1034) (-119.5, 3.5, -141.0)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1030) (-119.5, 3.5, -143.0)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1035) (-118.5, 3.5, -141.0)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1023) (-118.5, 3.5, -136.5)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1024) (-118.5, 3.5, -137.5)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1025) (-119.5, 3.5, -137.5)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1027) (-118.5, 3.5, -134.5)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1028) (-118.5, 3.5, -135.5)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1022) (-119.5, 3.5, -136.5)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1029) (-119.5, 3.5, -135.5)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1026) (-119.5, 3.5, -134.5)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1016) (-120.5, 3.5, -135.5)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1017) (-121.5, 3.5, -135.5)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1040) (-118.5, 3.5, -131.5)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1041) (-119.5, 3.5, -131.5)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1015) (-120.5, 3.5, -134.5)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1038) (-119.5, 3.5, -130.5)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1020) (-120.5, 3.5, -133.5)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1019) (-120.5, 3.5, -132.5)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1018) (-121.5, 3.5, -132.5)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1021) (-121.5, 3.5, -133.5)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1014) (-121.5, 3.5, -134.5)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1039) (-118.5, 3.5, -130.5)": TunicLocationData("Overworld Beach",
                                                                                        "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1131) (-167.0, 1.0, -88.5)": TunicLocationData("Overworld Beach",
                                                                                       "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1125) (-166.0, 1.0, -87.5)": TunicLocationData("Overworld Beach",
                                                                                       "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1130) (-167.0, 1.0, -87.5)": TunicLocationData("Overworld Beach",
                                                                                       "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1129) (-166.0, 1.0, -86.5)": TunicLocationData("Overworld Beach",
                                                                                       "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1132) (-168.0, 1.0, -88.5)": TunicLocationData("Overworld Beach",
                                                                                       "Overworld Beach"),
    "Overworld - Overworld Beach Grass (1133) (-168.0, 1.0, -87.5)": TunicLocationData("Overworld Beach",
                                                                                       "Overworld Beach"),
    "Stick House - Stick House Grass (1) (14.0, 0.0, 9.0)": TunicLocationData("Stick House", "Stick House"),
    "Stick House - Stick House Grass (4) (15.0, 0.0, 10.0)": TunicLocationData("Stick House", "Stick House"),
    "Stick House - Stick House Grass (3) (15.0, 0.0, 8.0)": TunicLocationData("Stick House", "Stick House"),
    "Stick House - Stick House Grass (15.0, 0.0, 9.0)": TunicLocationData("Stick House", "Stick House"),
    "Stick House - Stick House Grass (2) (14.0, 0.0, 10.0)": TunicLocationData("Stick House", "Stick House"),
    "Ruined Passage - Ruined Passage Grass (2) (186.5, 16.8, 40.3)": TunicLocationData("Ruined Passage",
                                                                                       "Ruined Passage"),
    "Ruined Passage - Ruined Passage Grass (4) (187.7, 16.5, 39.3)": TunicLocationData("Ruined Passage",
                                                                                       "Ruined Passage"),
    "Ruined Passage - Ruined Passage Grass (1) (187.7, 16.8, 40.3)": TunicLocationData("Ruined Passage",
                                                                                       "Ruined Passage"),
    "Ruined Passage - Ruined Passage Grass (3) (186.5, 17.0, 41.5)": TunicLocationData("Ruined Passage",
                                                                                       "Ruined Passage"),
    "Ruined Passage - Ruined Passage Grass (187.7, 17.0, 41.4)": TunicLocationData("Ruined Passage", "Ruined Passage"),
    "Forest Belltower - Forest Belltower Upper Grass (65) (592.5, 62.0, 114.3)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (64) (593.5, 62.0, 114.3)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (62) (592.5, 62.0, 115.3)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (66) (591.5, 62.0, 114.3)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (56) (593.5, 62.0, 115.3)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (68) (591.5, 62.0, 115.3)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (72) (600.8, 62.3, 112.5)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (74) (601.8, 62.3, 112.5)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (75) (601.8, 62.3, 113.5)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (70) (600.8, 62.3, 114.5)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (73) (600.8, 62.3, 113.5)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (67) (599.8, 62.3, 114.5)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (69) (599.8, 62.3, 115.5)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (71) (600.8, 62.3, 115.5)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (55) (601.5, 62.0, 107.3)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (54) (601.5, 62.0, 106.3)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (52) (602.5, 62.0, 106.3)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (53) (602.5, 62.0, 107.3)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (58) (603.5, 62.0, 108.3)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (60) (602.5, 62.0, 108.3)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (59) (603.5, 62.0, 109.3)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (61) (602.5, 62.0, 109.3)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (79) (602.8, 62.0, 102.1)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (76) (603.8, 62.0, 103.1)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (78) (603.8, 62.0, 102.1)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (77) (602.8, 62.0, 103.1)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (593.0, 14.0, 91.0)": TunicLocationData("Forest Belltower Upper",
                                                                                             "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (3) (592.0, 14.0, 91.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (10) (591.0, 14.0, 91.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (1) (593.0, 14.0, 90.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (2) (592.0, 14.0, 90.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (9) (591.0, 14.0, 90.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (11) (590.0, 14.0, 91.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (8) (590.0, 14.0, 90.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (7) (592.0, 14.0, 89.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (6) (592.0, 14.0, 88.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (5) (593.0, 14.0, 89.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (4) (593.0, 14.0, 88.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (35) (589.0, 14.0, 84.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (30) (589.0, 14.0, 85.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (31) (589.0, 14.0, 86.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (29) (588.0, 14.0, 85.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (39) (591.0, 14.0, 84.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (36) (590.0, 14.0, 84.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (28) (588.0, 14.0, 86.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (34) (589.0, 14.0, 83.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (33) (588.0, 14.0, 83.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (32) (588.0, 14.0, 84.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (37) (590.0, 14.0, 83.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (43) (589.0, 14.0, 82.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (38) (591.0, 14.0, 83.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (40) (588.0, 14.0, 82.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (41) (588.0, 14.0, 81.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (42) (589.0, 14.0, 81.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (50) (583.0, 14.0, 92.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (13) (584.0, 14.0, 92.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (51) (583.0, 14.0, 93.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (14) (585.0, 14.0, 92.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (15) (585.0, 14.0, 93.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (12) (584.0, 14.0, 93.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (49) (582.0, 14.0, 92.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (48) (582.0, 14.0, 93.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (47) (581.0, 14.0, 93.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (46) (581.0, 14.0, 92.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (44) (580.0, 14.0, 93.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (45) (580.0, 14.0, 92.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (27) (592.0, 14.0, 76.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (20) (593.0, 14.0, 78.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (21) (593.0, 14.0, 77.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (24) (591.0, 14.0, 76.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (19) (594.0, 14.0, 76.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (22) (594.0, 14.0, 77.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (16) (593.0, 14.0, 76.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (17) (593.0, 14.0, 75.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (23) (594.0, 14.0, 78.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (26) (592.0, 14.0, 75.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (18) (594.0, 14.0, 75.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Upper Grass (25) (591.0, 14.0, 75.0)": TunicLocationData(
        "Forest Belltower Upper", "Forest Belltower Upper"),
    "Forest Belltower - Forest Belltower Main Bush (3) (469.0, 38.0, 118.0)": TunicLocationData("Forest Belltower Main",
                                                                                                "Forest Belltower Main"),
    "Forest Belltower - Forest Belltower Main Bush (4) (467.0, 38.0, 118.0)": TunicLocationData("Forest Belltower Main",
                                                                                                "Forest Belltower Main"),
    "Forest Belltower - Forest Belltower Main Bush (469.0, 38.0, 120.0)": TunicLocationData("Forest Belltower Main",
                                                                                            "Forest Belltower Main"),
    "Forest Belltower - Forest Belltower Main Bush (1) (467.0, 38.0, 120.0)": TunicLocationData("Forest Belltower Main",
                                                                                                "Forest Belltower Main"),
    "Forest Belltower - Forest Belltower Main Bush (8) (465.0, 38.0, 119.0)": TunicLocationData("Forest Belltower Main",
                                                                                                "Forest Belltower Main"),
    "Forest Belltower - Forest Belltower Main Bush (7) (477.0, 38.0, 117.0)": TunicLocationData("Forest Belltower Main",
                                                                                                "Forest Belltower Main"),
    "Forest Belltower - Forest Belltower Main Bush (6) (476.0, 38.0, 119.0)": TunicLocationData("Forest Belltower Main",
                                                                                                "Forest Belltower Main"),
    "Forest Belltower - Forest Belltower Main Bush (5) (460.0, 38.0, 116.0)": TunicLocationData("Forest Belltower Main",
                                                                                                "Forest Belltower Main"),
    "East Forest - East Forest Grass (486) (78.0, 8.0, 71.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (488) (78.0, 8.0, 72.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (482) (77.0, 8.0, 73.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (487) (79.0, 8.0, 71.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (489) (79.0, 8.0, 72.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (483) (78.0, 8.0, 73.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (484) (77.0, 8.0, 74.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (485) (78.0, 8.0, 74.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (454) (82.5, 8.0, 62.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (457) (83.5, 8.0, 62.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (455) (82.5, 8.0, 63.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (456) (83.5, 8.0, 63.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (450) (80.8, 4.0, 56.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (453) (81.8, 4.0, 56.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (451) (80.8, 4.0, 57.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (448) (83.3, 4.0, 54.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (447) (82.3, 4.0, 54.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (452) (81.8, 4.0, 57.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (446) (82.3, 4.0, 53.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (449) (83.3, 4.0, 53.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (458) (78.8, 0.0, 47.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (357) (84.0, 0.0, 48.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (356) (84.0, 0.0, 47.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (367) (83.0, 0.0, 50.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (366) (83.0, 0.0, 51.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (365) (82.0, 0.0, 51.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (359) (85.0, 0.0, 47.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (358) (85.0, 0.0, 48.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (361) (87.0, 0.0, 46.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (74) (86.5, 0.0, 48.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (363) (88.0, 0.0, 45.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (362) (88.0, 0.0, 46.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (360) (87.0, 0.0, 45.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (461) (77.8, 0.0, 47.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (460) (77.8, 0.0, 46.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (459) (78.8, 0.0, 46.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (389) (71.5, 0.0, 38.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (387) (70.5, 0.0, 37.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (388) (70.5, 0.0, 38.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (390) (71.5, 0.0, 37.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (393) (71.5, 0.0, 36.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (392) (70.5, 0.0, 36.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (391) (70.5, 0.0, 35.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (394) (71.5, 0.0, 35.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (396) (71.5, 0.0, 34.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (397) (72.5, 0.0, 34.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (81) (69.0, 0.0, 37.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (80) (69.0, 0.0, 39.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (401) (69.5, 0.0, 35.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (439) (67.5, 0.0, 37.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (400) (68.5, 0.0, 35.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (399) (68.5, 0.0, 34.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (440) (67.5, 0.0, 36.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (82) (67.0, 0.0, 35.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (402) (69.5, 0.0, 34.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (438) (66.5, 0.0, 36.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (443) (67.5, 0.0, 33.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (445) (66.5, 0.0, 33.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (442) (66.5, 0.0, 32.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (444) (67.5, 0.0, 32.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (436) (67.5, 0.0, 38.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (435) (67.5, 0.0, 39.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (379) (68.5, 0.0, 40.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (380) (68.5, 0.0, 41.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (382) (69.5, 0.0, 40.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (381) (69.5, 0.0, 41.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (437) (66.5, 0.0, 39.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (434) (66.5, 0.0, 38.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (441) (66.5, 0.0, 37.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (375) (68.5, 0.0, 42.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (376) (68.5, 0.0, 43.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (432) (67.5, 0.0, 43.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (433) (67.5, 0.0, 42.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (378) (69.5, 0.0, 42.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (377) (69.5, 0.0, 43.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (383) (70.5, 0.0, 42.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (418) (67.5, 0.0, 44.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (429) (67.5, 0.0, 44.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (78) (69.0, 0.0, 45.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (428) (67.5, 0.0, 45.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (417) (67.5, 0.0, 45.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (431) (66.5, 0.0, 42.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (427) (66.5, 0.0, 44.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (430) (66.5, 0.0, 43.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (415) (66.5, 0.0, 44.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (384) (70.5, 0.0, 43.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (386) (71.5, 0.0, 42.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (385) (71.5, 0.0, 43.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (371) (70.5, 0.0, 44.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (374) (71.5, 0.0, 44.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (373) (71.5, 0.0, 45.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (372) (70.5, 0.0, 45.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (76) (69.0, 0.0, 47.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (77) (71.0, 0.0, 47.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (416) (66.5, 0.0, 45.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (364) (72.5, 0.0, 46.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (370) (73.5, 0.0, 46.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (369) (73.5, 0.0, 47.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (368) (72.5, 0.0, 47.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (79) (67.0, 0.0, 47.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (422) (65.5, 0.0, 46.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (421) (65.5, 0.0, 47.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (83) (65.0, 0.0, 45.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (419) (64.5, 0.0, 46.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (420) (64.5, 0.0, 47.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (426) (67.5, 0.0, 48.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (423) (66.5, 0.0, 48.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (425) (67.5, 0.0, 49.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (424) (66.5, 0.0, 49.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (398) (72.5, 0.0, 33.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (395) (71.5, 0.0, 33.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (404) (72.5, 0.0, 32.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (405) (73.5, 0.0, 32.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (413) (72.5, 0.0, 30.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (403) (72.5, 0.0, 31.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (412) (71.5, 0.0, 30.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (406) (73.5, 0.0, 31.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (408) (73.5, 0.0, 30.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (411) (71.5, 0.0, 29.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (414) (72.5, 0.0, 29.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (407) (73.5, 0.0, 29.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (409) (74.5, 0.0, 30.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (410) (74.5, 0.0, 29.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (341) (100.3, 0.0, 30.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (340) (100.3, 0.0, 29.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (343) (101.3, 0.0, 29.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (342) (101.3, 0.0, 30.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (345) (102.3, 0.0, 30.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (346) (103.3, 0.0, 30.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (352) (103.3, 0.0, 31.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (347) (103.3, 0.0, 29.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (344) (102.3, 0.0, 29.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (350) (105.3, 0.0, 30.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (351) (105.3, 0.0, 29.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (348) (104.3, 0.0, 29.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (349) (104.3, 0.0, 30.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (355) (104.3, 0.0, 31.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (354) (104.3, 0.0, 32.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (353) (103.3, 0.0, 32.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (463) (106.5, 0.0, 46.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (465) (106.5, 0.0, 45.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (462) (107.5, 0.0, 45.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (339) (109.8, 0.0, 47.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (464) (107.5, 0.0, 46.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (336) (108.8, 0.0, 47.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (337) (108.8, 0.0, 48.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (338) (109.8, 0.0, 48.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (330) (104.3, 0.0, 49.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (331) (104.3, 0.0, 48.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (328) (103.3, 0.0, 48.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (329) (103.3, 0.0, 49.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (327) (102.3, 0.0, 48.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (326) (102.3, 0.0, 49.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (324) (101.3, 0.0, 48.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (325) (101.3, 0.0, 49.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (72) (101.8, 0.0, 50.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (71) (99.5, 0.0, 50.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (67) (97.5, 0.0, 50.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (316) (97.0, 0.0, 49.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (323) (96.0, 0.0, 50.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (317) (98.0, 0.0, 49.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (73) (99.5, 0.0, 48.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (318) (98.0, 0.0, 48.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (333) (98.0, 0.0, 47.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (319) (97.0, 0.0, 48.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (334) (99.0, 0.0, 47.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (332) (98.0, 0.0, 46.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (335) (99.0, 0.0, 46.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (322) (96.0, 0.0, 51.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (321) (95.0, 0.0, 51.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (320) (95.0, 0.0, 50.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (309) (127.3, 0.0, 43.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (308) (128.3, 0.0, 43.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (70) (129.3, 0.0, 43.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (306) (128.3, 0.0, 44.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (307) (127.2, 0.0, 44.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (278) (131.8, 0.0, 38.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (280) (131.8, 0.0, 37.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (279) (132.8, 0.0, 38.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (281) (132.8, 0.0, 37.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (276) (133.8, 0.0, 37.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (274) (133.8, 0.0, 38.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (284) (133.8, 0.0, 39.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (285) (134.8, 0.0, 39.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (277) (134.8, 0.0, 37.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (275) (134.8, 0.0, 38.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (283) (134.8, 0.0, 40.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (282) (133.8, 0.0, 40.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (271) (133.8, 0.0, 36.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (270) (132.8, 0.0, 36.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (273) (133.8, 0.0, 35.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (272) (132.8, 0.0, 35.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (267) (131.8, 0.0, 34.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (69) (133.3, 0.0, 34.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (66) (135.3, 0.0, 36.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (266) (130.8, 0.0, 34.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (269) (131.8, 0.0, 33.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (255) (132.8, 0.0, 32.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (262) (131.8, 0.0, 32.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (252) (133.8, 0.0, 32.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (268) (130.8, 0.0, 33.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (68) (135.3, 0.0, 32.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (265) (130.8, 0.0, 32.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (264) (131.8, 0.0, 31.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (254) (132.8, 0.0, 31.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (253) (133.8, 0.0, 31.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (260) (132.8, 0.0, 29.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (261) (132.8, 0.0, 30.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (256) (134.8, 0.0, 30.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (258) (134.8, 0.0, 29.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (259) (133.8, 0.0, 30.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (257) (133.8, 0.0, 29.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (299) (135.8, 0.0, 27.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (263) (130.8, 0.0, 31.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (295) (135.8, 0.0, 25.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (301) (135.8, 0.0, 26.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (294) (134.8, 0.0, 25.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (300) (134.8, 0.0, 26.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (296) (134.8, 0.0, 24.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (298) (134.8, 0.0, 27.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (302) (131.8, 0.0, 23.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (304) (131.8, 0.0, 22.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (290) (133.8, 0.0, 23.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (303) (132.8, 0.0, 23.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (305) (132.8, 0.0, 22.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (292) (133.8, 0.0, 22.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (297) (135.8, 0.0, 24.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (291) (134.8, 0.0, 23.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (289) (134.8, 0.0, 20.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (293) (134.8, 0.0, 22.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (287) (134.8, 0.0, 21.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (286) (133.8, 0.0, 21.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (288) (133.8, 0.0, 20.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (466) (117.5, 0.0, 13.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (469) (117.5, 0.0, 12.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (470) (117.5, 0.0, 11.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (468) (116.5, 0.0, 13.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (467) (116.5, 0.0, 12.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (472) (116.5, 0.0, 11.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (471) (116.5, 0.0, 10.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (473) (117.5, 0.0, 10.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (315) (109.3, -1.3, 0.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (310) (110.3, -0.8, 2.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (314) (110.3, -1.3, 0.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (313) (108.3, 0.0, 3.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (311) (108.3, 0.0, 4.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (312) (107.3, 0.0, 3.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (497) (105.8, 0.0, 8.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (501) (103.5, 0.0, 7.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (502) (103.5, 0.0, 6.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (495) (104.8, 0.0, 8.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (493) (105.8, 0.0, 10.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (494) (105.8, 0.0, 9.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (496) (104.8, 0.0, 9.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (498) (103.5, 0.0, 8.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (490) (105.8, 0.0, 11.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (491) (104.8, 0.0, 10.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (492) (104.8, 0.0, 11.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (505) (103.5, 0.0, 5.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (499) (102.5, 0.0, 7.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (504) (102.5, 0.0, 6.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (500) (102.5, 0.0, 8.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (503) (102.5, 0.0, 5.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (507) (87.3, -4.0, -1.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (509) (88.3, -4.0, -1.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (513) (86.3, -4.0, -1.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (506) (88.3, -4.0, -0.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (508) (87.3, -4.0, -0.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (510) (86.3, -4.0, -0.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (512) (85.3, -4.0, -0.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (511) (77.3, -4.0, -1.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (514) (77.3, -4.0, -0.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (516) (76.3, -4.0, -1.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (515) (76.3, -4.0, -0.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (519) (88.5, -4.0, -11.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (520) (88.5, -4.0, -12.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (524) (89.8, -4.0, -10.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (517) (89.5, -4.0, -12.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (518) (89.5, -4.0, -11.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (523) (89.8, -4.0, -9.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (521) (90.8, -4.0, -10.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (522) (90.8, -4.0, -9.8)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (89) (131.5, 0.0, -5.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (87) (132.5, 0.0, -6.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (84) (132.5, 0.0, -7.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (85) (133.5, 0.0, -7.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (88) (130.5, 0.0, -5.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (86) (133.5, 0.0, -6.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (78) (133.5, 0.0, -4.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (77) (133.5, 0.0, -5.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (76) (132.5, 0.0, -5.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (90) (131.5, 0.0, -4.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (91) (130.5, 0.0, -4.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (79) (132.5, 0.0, -4.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (80) (132.5, 0.0, -3.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (93) (131.5, 0.0, -2.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (92) (130.5, 0.0, -2.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (83) (132.5, 0.0, -2.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (94) (131.5, 0.0, -1.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (95) (130.5, 0.0, -1.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (81) (133.5, 0.0, -3.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (43) (135.0, 0.0, -5.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (82) (133.5, 0.0, -2.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (44) (135.0, 0.0, -7.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (58) (137.5, 0.0, -7.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (73) (137.5, 0.0, -8.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (74) (136.5, 0.0, -8.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (75) (136.5, 0.0, -9.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (59) (136.5, 0.0, -7.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (56) (137.5, 0.0, -6.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (57) (136.5, 0.0, -6.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (98) (135.5, 0.0, -12.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (46) (135.0, 0.0, -11.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (99) (134.5, 0.0, -12.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (96) (134.5, 0.0, -13.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (55) (136.5, 0.0, -11.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (52) (136.5, 0.0, -10.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (97) (135.5, 0.0, -13.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (33) (137.0, 0.0, -13.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (32) (139.0, 0.0, -13.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (54) (137.5, 0.0, -11.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (38) (139.0, 0.0, -11.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (53) (137.5, 0.0, -10.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (72) (137.5, 0.0, -9.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (29) (141.0, 0.0, -13.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (68) (142.5, 0.0, -10.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (35) (141.0, 0.0, -11.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (70) (139.5, 0.0, -9.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (37) (141.0, 0.0, -9.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (65) (139.5, 0.0, -8.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (71) (138.5, 0.0, -9.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (66) (138.5, 0.0, -8.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (42) (143.0, 0.0, -9.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (63) (142.5, 0.0, -7.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (60) (143.5, 0.0, -7.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (62) (142.5, 0.0, -6.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (39) (141.0, 0.0, -7.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (69) (143.5, 0.0, -10.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (67) (144.5, 0.0, -8.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (64) (144.5, 0.0, -9.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (41) (145.0, 0.0, -7.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (61) (143.5, 0.0, -6.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (40) (143.0, 0.0, -5.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (102) (135.5, 0.0, -18.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (100) (134.5, 0.0, -19.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (103) (134.5, 0.0, -18.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (101) (135.5, 0.0, -19.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (34) (137.0, 0.0, -19.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (107) (138.5, 0.0, -20.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (31) (139.0, 0.0, -19.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (104) (138.5, 0.0, -21.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (106) (139.5, 0.0, -20.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (105) (139.5, 0.0, -21.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (36) (141.0, 0.0, -21.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (30) (141.0, 0.0, -19.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (115) (138.0, 0.0, -24.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (112) (138.0, 0.0, -25.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (114) (139.0, 0.0, -24.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (113) (139.0, 0.0, -25.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (111) (140.5, 0.0, -26.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (118) (133.5, 0.0, -26.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (117) (133.5, 0.0, -27.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (119) (132.5, 0.0, -26.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (116) (132.5, 0.0, -27.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (110) (141.5, 0.0, -26.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (108) (140.5, 0.0, -27.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (109) (141.5, 0.0, -27.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (123) (142.5, 0.0, -28.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (120) (142.5, 0.0, -29.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (122) (143.5, 0.0, -28.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (121) (143.5, 0.0, -29.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (244) (135.5, 8.0, -0.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (247) (135.5, 8.0, -1.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (246) (134.5, 8.0, -0.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (245) (134.5, 8.0, -1.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (250) (140.5, 8.0, -2.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (249) (140.5, 8.0, -3.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (251) (141.5, 8.0, -3.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (248) (141.5, 8.0, -2.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (213) (147.5, 8.0, 0.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (215) (146.5, 8.0, 0.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (212) (146.5, 8.0, 1.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (203) (146.5, 8.0, 2.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (207) (143.5, 8.0, 4.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (61) (143.0, 8.0, 3.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (237) (141.5, 8.0, 2.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (205) (142.5, 8.0, 4.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (238) (141.5, 8.0, 3.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (239) (140.5, 8.0, 2.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (236) (140.5, 8.0, 3.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (1) (141.0, 8.0, 5.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (7) (139.0, 8.0, 5.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (206) (142.5, 8.0, 5.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (204) (143.5, 8.0, 5.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (60) (145.0, 8.0, 5.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (3) (143.0, 8.0, 9.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (2) (141.0, 8.0, 7.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (242) (137.5, 8.0, 5.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (5) (137.0, 8.0, 7.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (4) (139.0, 8.0, 7.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (240) (136.5, 8.0, 5.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (243) (136.5, 8.0, 4.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (241) (137.5, 8.0, 4.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (137.0, 8.0, 9.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (6) (135.0, 8.0, 7.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (211) (144.5, 8.0, 6.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (208) (144.5, 8.0, 7.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (209) (145.5, 8.0, 6.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (210) (145.5, 8.0, 7.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (56) (149.0, 8.0, 5.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (59) (147.0, 8.0, 5.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (58) (147.0, 8.0, 7.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (15) (149.0, 8.0, 7.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (9) (145.0, 8.0, 9.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (201) (146.5, 8.0, 3.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (200) (147.5, 8.0, 3.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (202) (147.5, 8.0, 2.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (57) (149.0, 8.0, 3.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (63) (151.0, 8.0, 1.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (214) (147.5, 8.0, 1.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (62) (149.0, 8.0, 1.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (224) (153.5, 8.0, 1.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (225) (152.5, 8.0, 0.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (226) (152.5, 8.0, 1.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (65) (151.0, 8.0, 5.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (64) (151.0, 8.0, 3.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (17) (153.0, 8.0, 7.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (16) (151.0, 8.0, 7.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (18) (155.0, 8.0, 7.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (233) (157.5, 8.0, 10.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (20) (155.0, 8.0, 9.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (235) (156.5, 8.0, 10.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (232) (156.5, 8.0, 11.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (23) (155.0, 8.0, 11.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (22) (153.0, 8.0, 11.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (19) (153.0, 8.0, 9.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (234) (157.5, 8.0, 11.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (230) (154.5, 8.0, 1.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (228) (155.5, 8.0, 1.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (229) (154.5, 8.0, 0.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (227) (153.5, 8.0, 0.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (231) (155.5, 8.0, 0.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (218) (149.5, 8.0, -0.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (217) (149.5, 8.0, -1.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (219) (148.5, 8.0, -1.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (216) (148.5, 8.0, -0.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (221) (150.5, 8.0, -1.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (222) (150.5, 8.0, -0.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (220) (151.5, 8.0, -0.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (223) (151.5, 8.0, -1.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (546) (167.0, 7.8, -23.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (545) (167.0, 7.8, -22.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (543) (166.0, 7.8, -22.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (544) (166.0, 7.8, -23.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (167) (130.0, 24.0, 52.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (164) (130.0, 24.0, 53.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (165) (131.0, 24.0, 52.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (166) (131.0, 24.0, 53.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (135) (125.5, 24.0, 52.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (133) (124.5, 24.0, 52.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (49) (123.0, 24.0, 53.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (131) (121.5, 24.0, 52.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (128) (121.5, 24.0, 53.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (129) (120.5, 24.0, 52.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (176) (119.5, 24.0, 47.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (178) (118.5, 24.0, 47.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (177) (118.5, 24.0, 46.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (179) (119.5, 24.0, 46.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (134) (124.5, 24.0, 53.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (132) (125.5, 24.0, 53.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (137) (124.5, 24.0, 56.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (139) (125.5, 24.0, 56.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (48) (123.0, 24.0, 57.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (45) (121.0, 24.0, 55.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (130) (120.5, 24.0, 53.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (149) (119.5, 24.0, 54.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (145) (119.5, 24.0, 56.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (47) (121.0, 24.0, 57.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (150) (119.5, 24.0, 55.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (146) (119.5, 24.0, 57.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (144) (118.5, 24.0, 57.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (147) (118.5, 24.0, 56.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (148) (118.5, 24.0, 55.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (173) (117.5, 24.0, 56.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (151) (118.5, 24.0, 54.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (174) (117.5, 24.0, 57.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (172) (116.5, 24.0, 57.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (175) (116.5, 24.0, 56.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Bush (50) (115.0, 24.0, 57.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (170) (113.5, 24.0, 57.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (126) (113.5, 24.0, 58.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (125) (113.5, 24.0, 59.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (169) (113.5, 24.0, 56.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (127) (112.5, 24.0, 58.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (124) (112.5, 24.0, 59.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (168) (112.5, 24.0, 57.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (171) (112.5, 24.0, 56.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (141) (121.5, 24.0, 58.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (155) (123.5, 24.0, 58.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (153) (122.5, 24.0, 58.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (142) (121.5, 24.0, 59.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (152) (123.5, 24.0, 59.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (154) (122.5, 24.0, 59.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (143) (120.5, 24.0, 58.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (140) (120.5, 24.0, 59.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (159) (126.0, 24.0, 62.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (163) (128.0, 24.0, 60.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (157) (125.0, 24.0, 62.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (161) (127.0, 24.0, 60.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (162) (127.0, 24.0, 61.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (160) (128.0, 24.0, 61.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (156) (126.0, 24.0, 63.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (158) (125.0, 24.0, 63.0)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (136) (125.5, 24.0, 57.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (138) (124.5, 24.0, 57.5)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (476) (130.0, 0.0, 8.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (474) (131.0, 0.0, 8.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (477) (131.0, 0.0, 7.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (475) (130.0, 0.0, 7.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (479) (132.5, 0.0, 9.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (481) (133.5, 0.0, 9.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (478) (133.5, 0.0, 10.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Grass (480) (132.5, 0.0, 10.3)": TunicLocationData("East Forest", "East Forest"),
    "East Forest - East Forest Dance Fox Spot Grass (548) (95.5, 16.0, 75.0)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (550) (96.5, 16.0, 75.0)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (547) (95.5, 16.0, 76.0)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (549) (96.5, 16.0, 76.0)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (180) (88.0, 16.0, 65.0)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (181) (88.0, 16.0, 64.0)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (182) (87.0, 16.0, 64.0)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (183) (87.0, 16.0, 65.0)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Bush (52) (89.5, 16.0, 64.5)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Bush (55) (89.5, 16.0, 62.5)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (189) (85.0, 16.0, 61.5)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (190) (84.0, 16.0, 60.5)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (188) (84.0, 16.0, 61.5)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (191) (85.0, 16.0, 60.5)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Bush (51) (89.5, 16.0, 60.5)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Bush (54) (95.5, 16.0, 62.5)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Bush (53) (95.5, 16.0, 64.5)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (197) (91.5, 16.0, 56.0)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (198) (90.5, 16.0, 55.0)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (196) (90.5, 16.0, 56.0)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (199) (91.5, 16.0, 55.0)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (187) (90.5, 16.0, 54.0)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (184) (91.5, 16.0, 54.0)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (186) (91.5, 16.0, 53.0)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (185) (90.5, 16.0, 53.0)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (194) (92.5, 16.0, 53.0)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (192) (92.5, 16.0, 54.0)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (193) (93.5, 16.0, 54.0)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - East Forest Dance Fox Spot Grass (195) (93.5, 16.0, 53.0)": TunicLocationData(
        "East Forest Dance Fox Spot", "East Forest Dance Fox Spot"),
    "East Forest - Lower Forest Grass (528) (86.5, -12.0, -15.3)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (529) (87.5, -12.0, -16.3)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (525) (87.5, -12.0, -15.3)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (527) (86.5, -12.0, -14.3)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (526) (87.5, -12.0, -14.3)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (533) (86.0, -20.3, -21.8)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (530) (87.0, -20.3, -21.8)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (531) (87.0, -20.3, -20.8)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (532) (86.0, -20.3, -20.8)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Bush (14) (99.0, -26.0, -53.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Bush (8) (99.0, -26.0, -49.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Bush (13) (99.0, -26.0, -51.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Bush (10) (104.0, -26.0, -49.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (1) (98.0, -26.0, -57.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (15) (98.0, -26.0, -56.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (12) (98.0, -26.0, -55.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (16) (97.0, -26.0, -57.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (13) (99.0, -26.0, -56.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (99.0, -26.0, -57.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (14) (99.0, -26.0, -55.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (31) (105.0, -26.0, -50.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (26) (105.0, -26.0, -51.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (29) (106.0, -26.0, -50.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (24) (106.0, -26.0, -51.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (23) (106.0, -26.0, -54.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (27) (106.0, -26.0, -52.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (20) (106.0, -26.0, -53.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (22) (105.0, -26.0, -53.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (25) (105.0, -26.0, -52.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (28) (105.0, -26.0, -55.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (21) (105.0, -26.0, -54.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (30) (106.0, -26.0, -55.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (5) (99.0, -26.0, -60.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Bush (24) (105.0, -26.0, -61.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Bush (26) (105.0, -26.0, -59.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Bush (25) (107.0, -26.0, -59.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (38) (109.0, -26.0, -59.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (37) (109.0, -26.0, -60.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (39) (110.0, -26.0, -60.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (36) (110.0, -26.0, -59.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (35) (112.0, -26.0, -60.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (41) (112.0, -26.0, -62.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (42) (112.0, -26.0, -61.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (40) (111.0, -26.0, -61.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (33) (111.0, -26.0, -60.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (43) (111.0, -26.0, -62.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (32) (112.0, -26.0, -59.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (34) (111.0, -26.0, -59.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (6) (99.0, -26.0, -59.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (2) (98.0, -26.0, -58.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (7) (98.0, -26.0, -60.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (4) (98.0, -26.0, -59.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (3) (99.0, -26.0, -58.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (10) (99.0, -26.0, -61.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (9) (99.0, -26.0, -62.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (8) (98.0, -26.0, -61.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (11) (98.0, -26.0, -62.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (19) (97.0, -26.0, -58.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (17) (96.0, -26.0, -58.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (18) (96.0, -26.0, -57.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (50) (99.0, -26.0, -66.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (48) (98.0, -26.0, -66.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (44) (96.0, -26.0, -66.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (46) (97.0, -26.0, -66.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (45) (97.0, -26.0, -67.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (47) (96.0, -26.0, -67.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (49) (99.0, -26.0, -67.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (51) (98.0, -26.0, -67.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Bush (27) (91.0, -26.0, -52.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Bush (28) (91.0, -26.0, -54.0)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (68) (100.3, -30.5, -69.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (73) (100.3, -30.5, -70.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (65) (100.3, -30.5, -68.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (67) (101.3, -30.5, -69.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (74) (101.3, -30.5, -70.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (66) (101.3, -30.5, -68.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (71) (99.3, -30.5, -69.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (70) (99.3, -30.5, -68.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (69) (98.3, -30.5, -68.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (72) (98.3, -30.5, -69.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (75) (101.3, -30.5, -71.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (534) (100.3, -30.5, -71.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (541) (85.3, -30.5, -52.8)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (536) (88.8, -30.5, -55.3)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (535) (87.8, -30.5, -55.3)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (542) (84.3, -30.5, -52.8)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (540) (85.3, -30.5, -51.8)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (539) (84.3, -30.5, -51.8)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (538) (87.8, -30.5, -56.3)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (537) (88.8, -30.5, -56.3)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (53) (142.8, -26.0, -52.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (54) (142.8, -26.0, -51.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (52) (141.8, -26.0, -52.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (55) (141.8, -26.0, -51.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (56) (141.8, -26.0, -35.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (57) (142.8, -26.0, -35.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (60) (141.8, -26.0, -34.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (59) (142.8, -26.0, -34.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (62) (130.5, -26.0, -34.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (63) (130.5, -26.0, -33.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (64) (129.5, -26.0, -33.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "East Forest - Lower Forest Grass (61) (129.5, -26.0, -34.5)": TunicLocationData("Lower Forest", "Lower Forest"),
    "Guardhouse 1 - Guard House 1 West Grass (40) (129.0, 0.0, 50.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (44) (127.0, 0.0, 52.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (46) (127.0, 0.0, 51.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (36) (127.0, 0.0, 50.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (45) (128.0, 0.0, 51.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (47) (128.0, 0.0, 52.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (39) (128.0, 0.0, 50.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (43) (130.0, 0.0, 50.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (32) (125.0, 0.0, 49.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (34) (125.0, 0.0, 50.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (33) (126.0, 0.0, 50.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (35) (126.0, 0.0, 49.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (38) (127.0, 0.0, 49.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (42) (129.0, 0.0, 49.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (37) (128.0, 0.0, 49.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (41) (130.0, 0.0, 49.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (24) (118.0, 0.0, 55.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (26) (118.0, 0.0, 56.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (30) (118.0, 0.0, 54.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (27) (119.0, 0.0, 55.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (25) (119.0, 0.0, 56.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (29) (119.0, 0.0, 54.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (31) (119.0, 0.0, 53.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (28) (118.0, 0.0, 53.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (22) (130.0, 0.0, 69.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (9) (128.0, 0.0, 69.0)": TunicLocationData("Guard House 1 West",
                                                                                        "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (10) (128.0, 0.0, 68.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (21) (129.0, 0.0, 70.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (20) (129.0, 0.0, 69.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (11) (127.0, 0.0, 68.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (14) (133.0, 0.0, 72.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (15) (132.0, 0.0, 71.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (12) (132.0, 0.0, 72.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (23) (130.0, 0.0, 70.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (8) (127.0, 0.0, 69.0)": TunicLocationData("Guard House 1 West",
                                                                                        "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (13) (133.0, 0.0, 71.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (18) (134.0, 0.0, 73.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (16) (133.0, 0.0, 73.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (19) (134.0, 0.0, 74.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (17) (133.0, 0.0, 74.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (3) (116.0, 16.0, 78.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (1) (117.0, 16.0, 79.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (2) (117.0, 16.0, 78.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (116.0, 16.0, 79.0)": TunicLocationData("Guard House 1 West",
                                                                                     "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (5) (117.0, 16.0, 74.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (7) (118.0, 16.0, 73.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (4) (118.0, 16.0, 74.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 1 - Guard House 1 West Grass (6) (117.0, 16.0, 73.0)": TunicLocationData("Guard House 1 West",
                                                                                         "Guard House 1 West"),
    "Guardhouse 2 - Guard House 2 Upper Grass (25) (150.5, 0.0, -15.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                           "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (11) (150.5, 0.0, -13.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                           "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (26) (150.5, 0.0, -14.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                           "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (24) (151.5, 0.0, -14.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                           "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (9) (151.5, 0.0, -13.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (27) (151.5, 0.0, -15.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                           "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Bush (7) (155.0, 0.0, -17.0)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                         "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Bush (5) (153.0, 0.0, -15.0)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                         "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Bush (6) (153.0, 0.0, -17.0)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                         "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (7) (152.5, 0.0, -13.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (6) (153.5, 0.0, -12.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (5) (153.5, 0.0, -13.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (1) (154.5, 0.0, -12.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (2) (154.5, 0.0, -13.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Bush (4) (155.0, 0.0, -15.0)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                         "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (155.5, 0.0, -12.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                      "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (3) (155.5, 0.0, -13.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (32) (156.5, 0.0, -14.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                           "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Bush (9) (153.0, 0.0, -11.0)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                         "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (4) (152.5, 0.0, -12.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (10) (151.5, 0.0, -12.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                           "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (13) (151.5, 0.0, -9.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Bush (8) (151.0, 0.0, -11.0)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                         "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (8) (150.5, 0.0, -12.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (15) (150.5, 0.0, -9.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (35) (156.5, 0.0, -15.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                           "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (29) (155.5, 0.0, -19.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                           "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (30) (155.5, 0.0, -18.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                           "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (31) (154.5, 0.0, -19.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                           "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (28) (154.5, 0.0, -18.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                           "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (33) (157.5, 0.0, -15.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                           "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (34) (157.5, 0.0, -14.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                           "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Bush (3) (157.0, 0.0, -13.0)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                         "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (37) (157.5, 0.0, -11.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                           "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (38) (157.5, 0.0, -10.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                           "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (39) (156.5, 0.0, -11.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                           "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (36) (156.5, 0.0, -10.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                           "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Bush (2) (155.0, 0.0, -11.0)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                         "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (41) (154.5, 0.0, -9.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (43) (155.5, 0.0, -9.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (40) (155.5, 0.0, -8.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (42) (154.5, 0.0, -8.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (14) (151.5, 0.0, -8.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (19) (151.5, 0.0, -7.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (16) (151.5, 0.0, -6.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (18) (150.5, 0.0, -6.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Bush (153.0, 0.0, -7.0)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                    "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Bush (1) (153.0, 0.0, -9.0)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                        "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (17) (150.5, 0.0, -7.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (12) (150.5, 0.0, -8.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (23) (149.5, 0.0, -7.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (20) (149.5, 0.0, -6.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (22) (148.5, 0.0, -6.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Guardhouse 2 - Guard House 2 Upper Grass (21) (148.5, 0.0, -7.5)": TunicLocationData("Guard House 2 Upper after bushes",
                                                                                          "Guard House 2 Upper after bushes"),
    "Forest Grave Path - Forest Grave Path Main Bush (110) (-70.0, -4.0, -185.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (112) (-66.0, -4.0, -181.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (111) (-64.0, -4.0, -181.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (113) (-64.0, -4.0, -183.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (76) (-62.8, -4.0, -182.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (82) (-59.8, -4.0, -181.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (83) (-60.8, -4.0, -181.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (78) (-61.8, -4.0, -181.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (77) (-61.8, -4.0, -182.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (79) (-62.8, -4.0, -181.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (119) (-65.0, -4.0, -193.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (118) (-65.0, -4.0, -195.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (120) (-63.0, -4.0, -195.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (90) (-59.5, -4.0, -187.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (121) (-59.0, -4.0, -197.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (122) (-57.0, -4.0, -191.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (91) (-58.5, -4.0, -187.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (86) (-57.5, -4.0, -189.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (89) (-57.5, -4.0, -188.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (87) (-56.5, -4.0, -189.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (88) (-56.5, -4.0, -188.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (106) (-53.0, -4.0, -191.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (107) (-55.0, -4.0, -191.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (104) (-53.0, -4.0, -187.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (115) (-55.0, -4.0, -187.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (108) (-55.0, -4.0, -189.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (105) (-53.0, -4.0, -189.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (117) (-55.0, -4.0, -185.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (109) (-57.0, -4.0, -187.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (92) (-58.5, -4.0, -186.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (93) (-59.5, -4.0, -186.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (103) (-53.0, -4.0, -185.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (81) (-52.5, -4.0, -181.8)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (116) (-53.0, -4.0, -183.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (85) (-53.5, -4.0, -180.8)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (80) (-53.5, -4.0, -181.8)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (84) (-52.5, -4.0, -180.8)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (133) (-45.0, 0.0, -185.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (136) (-43.0, 0.0, -189.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (135) (-43.0, 0.0, -187.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (42) (-42.5, 0.0, -190.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (47) (-41.5, 0.0, -188.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (56) (-41.5, 0.0, -187.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (44) (-41.5, 0.0, -189.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (45) (-40.5, 0.0, -189.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (33) (-46.5, 0.0, -185.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (134) (-43.0, 0.0, -185.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (43) (-43.5, 0.0, -190.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (34) (-46.5, 0.0, -184.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (35) (-47.5, 0.0, -184.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (32) (-47.5, 0.0, -185.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (59) (-41.5, 0.0, -186.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (137) (-41.0, 0.0, -191.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (40) (-43.5, 0.0, -191.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (138) (-43.0, 0.0, -193.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (41) (-42.5, 0.0, -191.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (61) (-40.5, 0.0, -195.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (36) (-41.5, 0.0, -193.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (39) (-41.5, 0.0, -192.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (60) (-41.5, 0.0, -195.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (63) (-41.5, 0.0, -194.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (62) (-40.5, 0.0, -194.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (38) (-40.5, 0.0, -192.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (37) (-40.5, 0.0, -193.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (53) (-38.5, 0.0, -189.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (50) (-38.5, 0.0, -190.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (49) (-38.5, 0.0, -191.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (48) (-39.5, 0.0, -191.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (52) (-39.5, 0.0, -189.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (51) (-39.5, 0.0, -190.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (46) (-40.5, 0.0, -188.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (54) (-38.5, 0.0, -188.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (55) (-39.5, 0.0, -188.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (57) (-40.5, 0.0, -187.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (58) (-40.5, 0.0, -186.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (141) (-47.0, 0.0, -195.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (139) (-43.0, 0.0, -195.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (140) (-45.0, 0.0, -195.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (66) (-43.0, 0.0, -200.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (67) (-44.0, 0.0, -200.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (64) (-44.0, 0.0, -201.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (65) (-43.0, 0.0, -201.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (68) (-40.0, 0.0, -201.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (71) (-40.0, 0.0, -200.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (70) (-39.0, 0.0, -200.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (69) (-39.0, 0.0, -201.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (75) (-31.5, 0.0, -192.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (72) (-31.5, 0.0, -193.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (73) (-30.5, 0.0, -193.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (74) (-30.5, 0.0, -192.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (147) (-35.0, 0.0, -185.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (146) (-33.0, 0.0, -185.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (28) (-33.5, 0.0, -184.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (29) (-32.5, 0.0, -184.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (23) (-31.5, 0.0, -184.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (20) (-31.5, 0.0, -185.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (21) (-30.5, 0.0, -185.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (26) (-32.5, 0.0, -181.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (30) (-32.5, 0.0, -183.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (25) (-32.5, 0.0, -182.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (31) (-33.5, 0.0, -183.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (24) (-33.5, 0.0, -182.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (27) (-33.5, 0.0, -181.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (148) (-35.0, 0.0, -183.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (22) (-30.5, 0.0, -184.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (12) (-29.5, 0.0, -185.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (13) (-28.5, 0.0, -185.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (10) (-27.5, 0.0, -186.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (11) (-27.5, 0.0, -187.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (15) (-29.5, 0.0, -184.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (3) (-23.5, 0.0, -187.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (132) (-25.0, 0.0, -187.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (8) (-26.5, 0.0, -187.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (9) (-26.5, 0.0, -186.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (130) (-25.0, 0.0, -185.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (131) (-27.0, 0.0, -185.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (14) (-28.5, 0.0, -184.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (-23.5, 0.0, -186.5)": TunicLocationData("Forest Grave Path Main",
                                                                                               "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (2) (-22.5, 0.0, -187.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (1) (-22.5, 0.0, -186.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (126) (-19.0, 0.0, -185.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (6) (-20.5, 0.0, -185.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (4) (-20.5, 0.0, -184.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (7) (-21.5, 0.0, -185.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (5) (-21.5, 0.0, -184.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (129) (-23.0, 0.0, -185.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (19) (-17.5, 0.0, -186.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (16) (-17.5, 0.0, -187.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (18) (-16.5, 0.0, -186.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (17) (-16.5, 0.0, -187.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (125) (-15.0, 0.0, -187.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (124) (-15.0, 0.0, -185.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (123) (-17.0, 0.0, -185.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (127) (-14.0, 0.0, -194.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (116) (-23.8, -4.3, -205.8)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (97) (-27.3, -6.3, -210.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (96) (-26.3, -6.3, -210.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (117) (-22.8, -4.3, -205.8)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (119) (-22.8, -4.3, -204.8)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (95) (-26.3, -6.3, -211.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (118) (-23.8, -4.3, -204.8)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (123) (-20.5, -4.3, -208.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (121) (-20.5, -4.3, -209.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (114) (-15.5, -4.3, -212.3)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (112) (-15.5, -4.3, -213.3)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (115) (-14.5, -4.3, -212.3)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (113) (-14.5, -4.3, -213.3)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (110) (-13.5, -4.3, -213.3)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (111) (-12.5, -4.3, -213.3)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (109) (-12.5, -4.3, -212.3)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (108) (-13.5, -4.3, -212.3)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (106) (-24.3, -6.2, -215.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (102) (-24.3, -6.3, -214.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (103) (-23.3, -6.3, -214.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (99) (-25.3, -6.3, -213.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (101) (-26.3, -6.3, -212.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (98) (-26.3, -6.3, -213.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (94) (-27.3, -6.3, -211.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (107) (-23.3, -6.3, -215.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (105) (-24.3, -6.3, -213.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (100) (-25.3, -6.3, -212.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Grass (104) (-23.3, -6.3, -213.5)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (144) (-21.5, 8.0, -179.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (145) (-23.5, 8.0, -179.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path Main Bush (149) (-25.5, 8.0, -179.0)": TunicLocationData(
        "Forest Grave Path Main", "Forest Grave Path Main"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (58) (8.5, 4.0, -190.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (57) (8.5, 4.0, -191.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Bush (102) (9.0, 4.0, -189.0)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (59) (9.5, 4.0, -191.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (56) (9.5, 4.0, -190.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (52) (12.5, 4.0, -190.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (55) (12.5, 4.0, -191.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (54) (13.5, 4.0, -190.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (53) (13.5, 4.0, -191.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (47) (14.5, 4.0, -189.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (44) (14.5, 4.0, -188.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (49) (13.5, 4.0, -189.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (50) (13.5, 4.0, -188.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (51) (12.5, 4.0, -189.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (48) (12.5, 4.0, -188.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Bush (100) (11.0, 4.0, -189.0)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Bush (99) (15.0, 4.0, -191.0)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (45) (15.5, 4.0, -189.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (7) (16.5, 4.0, -190.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (5) (16.5, 4.0, -191.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (21) (19.5, 4.0, -193.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (30) (19.5, 4.0, -194.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (22) (19.5, 4.0, -192.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (14) (18.5, 4.0, -191.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (20) (18.5, 4.0, -192.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (28) (18.5, 4.0, -194.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (23) (18.5, 4.0, -193.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Bush (98) (17.0, 4.0, -193.0)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (6) (17.5, 4.0, -191.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (9) (19.5, 4.0, -188.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (15) (19.5, 4.0, -191.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (11) (19.5, 4.0, -189.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (13) (19.5, 4.0, -190.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (8) (18.5, 4.0, -188.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (12) (18.5, 4.0, -190.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (10) (18.5, 4.0, -189.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (2) (17.5, 4.0, -189.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (4) (17.5, 4.0, -190.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (1) (17.5, 4.0, -188.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (3) (16.5, 4.0, -189.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Bush (97) (17.0, 4.0, -187.0)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (16.5, 4.0, -188.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (46) (15.5, 4.0, -188.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Bush (89) (21.0, 4.0, -195.0)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (31) (18.5, 4.0, -195.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (29) (19.5, 4.0, -195.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (26) (23.5, 4.0, -192.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (25) (23.5, 4.0, -193.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Bush (90) (23.0, 4.0, -195.0)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (27) (22.5, 4.0, -193.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (24) (22.5, 4.0, -192.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Bush (88) (21.0, 4.0, -193.0)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Bush (75) (21.0, 4.0, -191.0)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Bush (71) (21.0, 4.0, -189.0)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (37) (22.5, 4.0, -187.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Bush (91) (25.0, 4.0, -195.0)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Bush (93) (29.0, 4.0, -195.0)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Bush (92) (27.0, 4.0, -195.0)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (35) (23.5, 4.0, -185.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (33) (22.5, 4.0, -185.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (38) (22.5, 4.0, -186.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (36) (23.5, 4.0, -186.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (39) (23.5, 4.0, -187.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Bush (95) (27.0, 4.0, -185.0)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Bush (96) (25.0, 4.0, -185.0)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (32) (23.5, 4.0, -184.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (40) (21.5, 4.0, -184.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (43) (21.5, 4.0, -185.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (34) (22.5, 4.0, -184.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (42) (20.5, 4.0, -184.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (41) (20.5, 4.0, -185.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Bush (94) (29.0, 4.0, -185.0)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (17) (17.5, 4.0, -184.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (19) (17.5, 4.0, -185.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (16) (16.5, 4.0, -184.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "Forest Grave Path - Forest Grave Path by Grave Grass (18) (16.5, 4.0, -185.5)": TunicLocationData(
        "Forest Grave Path by Grave", "Forest Grave Path by Grave"),
    "West Garden - West Garden Grass (297) (-115.0, 4.0, 159.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (300) (-113.8, 4.0, 159.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (296) (-115.0, 4.0, 160.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (298) (-116.0, 4.0, 160.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (187) (-125.5, 4.0, 160.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (189) (-124.5, 4.0, 160.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (185) (-131.0, 4.0, 160.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (206) (-131.0, 4.0, 159.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (188) (-131.0, 4.0, 159.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (186) (-132.0, 4.0, 160.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (218) (-131.8, 2.3, 151.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (219) (-131.8, 1.8, 150.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (217) (-130.5, 2.3, 151.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (216) (-130.5, 2.8, 152.8)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (241) (-161.6, 2.0, 124.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (192) (-158.0, 1.5, 122.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (191) (-158.0, 1.5, 123.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (193) (-157.0, 1.5, 122.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (190) (-157.0, 1.5, 123.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (239) (-159.7, 1.5, 117.7)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (235) (-159.8, 1.5, 116.7)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (236) (-160.8, 1.5, 116.7)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (237) (-161.8, 1.5, 116.7)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (194) (-165.4, 2.0, 121.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (196) (-162.5, 2.0, 123.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (238) (-162.5, 2.0, 124.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (195) (-165.4, 2.0, 120.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (240) (-162.5, 2.0, 125.4)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Bush (20) (-162.0, 10.0, 139.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Bush (18) (-160.0, 10.0, 139.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Bush (19) (-160.0, 10.0, 141.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (295) (-159.5, 9.8, 160.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Bush (21) (-180.0, 10.0, 139.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Bush (23) (-180.0, 10.0, 141.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Bush (22) (-178.0, 10.0, 139.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (212) (-174.5, 2.0, 123.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (213) (-174.5, 2.0, 124.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (214) (-174.5, 2.0, 125.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (215) (-175.5, 2.0, 124.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Bush (24) (-185.0, 1.9, 143.9)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (198) (-185.0, 2.5, 148.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (197) (-185.0, 2.5, 149.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (202) (-185.0, 2.5, 150.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (201) (-186.0, 2.5, 150.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (200) (-186.0, 2.5, 149.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (216) (-192.3, 1.0, 145.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (217) (-192.3, 1.0, 146.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (211) (-193.3, 0.9, 145.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (406) (-190.8, 1.3, 149.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (405) (-189.8, 1.3, 149.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Bush (25) (-196.0, 0.8, 152.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (203) (-198.5, 1.0, 150.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (199) (-198.5, 1.0, 151.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (205) (-199.5, 1.0, 151.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (204) (-199.5, 1.0, 150.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (213) (-196.0, 4.0, 160.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (214) (-197.0, 4.0, 159.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (212) (-197.0, 4.0, 160.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (211) (-198.0, 4.0, 160.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (215) (-198.0, 4.0, 159.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (31) (-250.5, 4.0, 147.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (34) (-251.5, 4.0, 147.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (10) (-253.5, 3.8, 150.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (7) (-252.5, 3.8, 150.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (8) (-253.5, 3.8, 151.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (40) (-261.0, 4.0, 151.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (42) (-261.0, 4.0, 150.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (37) (-262.0, 4.0, 151.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (36) (-263.0, 4.0, 151.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (35) (-262.0, 4.0, 150.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (38) (-263.0, 4.0, 150.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (5) (-256.1, 4.0, 160.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (4) (-255.1, 4.0, 160.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (6) (-256.1, 4.0, 161.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (3) (-255.1, 4.0, 161.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (11) (-262.5, 4.0, 172.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (13) (-262.5, 4.0, 173.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (12) (-263.5, 4.0, 173.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (14) (-263.5, 4.0, 172.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (18) (-256.0, 4.0, 173.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (17) (-255.0, 4.0, 174.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (15) (-255.0, 4.0, 173.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (16) (-256.0, 4.0, 174.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (22) (-260.5, 4.0, 177.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (19) (-259.5, 4.0, 177.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (21) (-259.5, 4.0, 178.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (20) (-260.5, 4.0, 178.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (75) (-254.0, 4.0, 183.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (30) (-253.0, 4.0, 183.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (28) (-253.0, 4.0, 181.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (29) (-252.0, 4.0, 181.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Bush (26) (-265.3, 4.0, 167.8)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Bush (27) (-267.3, 4.0, 167.8)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Bush (28) (-271.8, 4.0, 162.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (41) (-278.0, 1.0, 168.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (39) (-278.0, 1.0, 167.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (207) (-310.8, 1.3, 164.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (210) (-310.8, 1.3, 165.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (209) (-312.0, 1.3, 165.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (208) (-312.0, 1.3, 164.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (103) (-323.5, 4.0, 128.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (101) (-323.5, 4.0, 129.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (102) (-324.5, 4.0, 129.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (104) (-324.5, 4.0, 128.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (95) (-332.0, 4.0, 127.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (348) (-331.0, 4.0, 128.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (94) (-331.0, 4.0, 127.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (343) (-331.0, 4.0, 129.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (353) (-330.1, 4.0, 129.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (354) (-330.1, 4.0, 128.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (344) (-332.0, 4.0, 129.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (347) (-332.0, 4.0, 128.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (349) (-333.0, 4.0, 129.3)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (90) (-323.5, 4.0, 113.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (89) (-323.5, 4.0, 112.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (92) (-322.5, 4.0, 113.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (93) (-322.5, 4.0, 112.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (91) (-324.5, 4.0, 113.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (1) (-324.5, 4.0, 112.5)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (115) (-334.0, 4.0, 109.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (116) (-333.0, 4.0, 109.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (117) (-334.0, 4.0, 108.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (100) (-339.5, 4.0, 114.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (99) (-339.5, 4.0, 115.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (98) (-340.5, 4.0, 115.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (171) (-348.5, 4.0, 124.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (167) (-348.5, 4.0, 123.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (114) (-349.5, 4.0, 123.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (170) (-349.5, 4.0, 124.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (168) (-348.5, 4.0, 122.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (169) (-349.5, 4.0, 122.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (341) (-345.6, 4.0, 127.3)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (119) (-348.5, 4.0, 129.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (120) (-348.5, 4.0, 128.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (118) (-349.5, 4.0, 129.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (340) (-344.6, 4.0, 126.3)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (338) (-345.6, 4.0, 126.3)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (342) (-344.6, 4.0, 127.3)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (346) (-342.6, 4.0, 127.3)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (345) (-343.6, 4.0, 127.3)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (44) (-325.0, 4.0, 88.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (45) (-325.0, 4.0, 87.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (74) (-327.9, 4.0, 88.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (73) (-326.9, 4.0, 88.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (49) (-326.0, 4.0, 88.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (48) (-326.0, 4.0, 87.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (43) (-324.0, 4.0, 88.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (46) (-324.0, 4.0, 87.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (51) (-324.5, 4.0, 78.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (54) (-324.5, 4.0, 77.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (52) (-323.5, 4.0, 77.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (53) (-323.5, 4.0, 78.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (397) (-328.9, 4.0, 68.4)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (398) (-329.9, 4.0, 67.4)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (396) (-327.9, 4.0, 67.4)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (395) (-327.9, 4.0, 68.4)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (393) (-328.9, 4.0, 67.4)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (55) (-342.5, 4.0, 78.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (57) (-341.5, 4.0, 78.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (56) (-341.5, 4.0, 77.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (58) (-342.5, 4.0, 77.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (97) (-346.8, 4.0, 72.4)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (394) (-346.8, 4.0, 73.4)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (392) (-345.8, 4.0, 72.4)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (96) (-345.8, 4.0, 71.4)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (76) (-346.8, 4.0, 71.4)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Bush (30) (-285.5, 0.5, 74.9)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Bush (29) (-283.4, 0.5, 74.9)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (153) (-295.5, 0.8, 70.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (264) (-295.5, 0.8, 69.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (152) (-296.5, 0.8, 70.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (154) (-296.5, 0.8, 69.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Bush (32) (-291.4, 0.5, 69.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Bush (33) (-293.1, 0.5, 67.1)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Bush (31) (-289.5, 0.5, 69.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (133) (-261.0, 0.3, 61.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (132) (-261.0, 0.3, 62.3)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (135) (-262.3, 0.3, 62.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (134) (-262.3, 0.3, 61.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (429) (-249.3, 4.0, 113.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (427) (-250.3, 4.0, 112.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (426) (-250.3, 4.0, 113.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (425) (-251.3, 4.0, 113.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (428) (-249.3, 4.0, 112.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (424) (-251.3, 4.0, 112.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (434) (-241.3, 4.0, 117.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (435) (-240.3, 4.0, 117.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (431) (-241.3, 4.0, 118.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (430) (-240.3, 4.0, 118.5)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (141) (-273.5, 0.0, 37.8)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (140) (-272.5, 0.0, 37.8)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (142) (-273.5, 0.3, 36.8)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (180) (-275.8, 0.8, 37.8)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (177) (-275.8, 0.8, 38.8)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (221) (-274.8, 0.6, 37.8)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (219) (-271.9, 0.0, 35.4)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (220) (-271.9, 0.3, 34.4)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (218) (-270.9, 0.0, 35.4)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (139) (-283.0, 2.0, 41.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (138) (-284.0, 2.0, 41.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (137) (-284.0, 2.0, 42.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (136) (-283.0, 2.0, 42.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (126) (-308.5, 2.0, 39.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (355) (-308.5, 2.0, 42.1)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (127) (-308.5, 2.0, 40.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (352) (-308.5, 2.0, 41.1)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (351) (-309.5, 2.0, 41.1)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (124) (-309.5, 2.0, 40.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (125) (-309.5, 2.0, 39.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (350) (-309.5, 2.0, 42.1)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (359) (-300.4, 2.0, 24.5)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (356) (-301.4, 2.0, 24.5)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (357) (-301.4, 2.0, 23.5)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (358) (-300.4, 2.0, 23.5)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (112) (-322.0, 2.0, 43.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (110) (-322.0, 2.0, 44.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (113) (-321.0, 2.0, 43.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (108) (-321.0, 2.0, 45.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (109) (-321.0, 2.0, 44.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (111) (-322.0, 2.0, 45.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (360) (-323.0, 2.0, 45.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (414) (-337.8, 2.0, 44.5)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (413) (-338.8, 2.0, 44.5)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (412) (-338.8, 2.0, 45.5)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (411) (-337.8, 2.0, 45.5)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (416) (-343.8, 2.0, 42.3)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (415) (-344.8, 2.0, 42.3)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (106) (-359.0, 1.5, 45.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (105) (-359.0, 1.5, 46.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (407) (-358.0, 1.8, 46.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (408) (-358.0, 1.8, 45.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (409) (-358.0, 1.8, 47.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (410) (-359.0, 1.5, 47.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (107) (-360.0, 1.3, 45.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (123) (-322.5, 1.8, 14.8)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (121) (-321.5, 1.8, 15.8)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (122) (-322.5, 1.8, 15.8)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (251) (-313.8, 2.0, 12.3)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (250) (-313.8, 2.0, 13.3)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (253) (-312.8, 2.0, 13.3)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (173) (-308.5, 2.0, 14.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (172) (-309.5, 2.0, 14.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (175) (-309.5, 2.0, 13.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (252) (-310.6, 2.0, 13.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (128) (-308.5, 2.0, -4.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (130) (-309.5, 2.0, -5.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (129) (-309.5, 2.0, -4.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (364) (-291.4, 2.0, -6.9)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (365) (-291.4, 2.0, -5.8)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (363) (-292.4, 2.0, -6.9)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (362) (-292.4, 2.0, -5.9)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (361) (-293.4, 2.0, -5.9)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (249) (-287.3, 2.0, -8.9)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (254) (-286.3, 2.0, -8.9)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (255) (-286.3, 2.0, -9.9)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (256) (-285.3, 1.8, -9.9)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (257) (-285.3, 1.8, -8.8)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (367) (-284.3, 1.5, -10.8)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (368) (-283.3, 1.4, -10.8)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (369) (-283.3, 1.4, -9.6)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (366) (-284.3, 1.5, -9.8)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (131) (-279.0, 2.0, -4.5)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (143) (-278.0, 2.0, -4.5)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (146) (-278.0, 2.0, -5.5)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (145) (-277.0, 2.0, -5.5)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (144) (-277.0, 2.0, -4.5)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (374) (-245.5, 1.0, 1.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (371) (-243.5, 1.0, 1.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (373) (-244.5, 1.0, 2.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (372) (-244.5, 1.0, 1.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (375) (-245.5, 1.0, 2.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (149) (-246.5, 1.0, 3.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (148) (-245.5, 1.0, 3.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (150) (-246.5, 1.0, 4.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (147) (-245.5, 1.0, 4.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (370) (-243.5, 1.0, 2.0)": TunicLocationData("none", "West Garden West Combat"),
    "West Garden - West Garden Grass (377) (-256.8, 1.9, 16.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (376) (-256.8, 1.9, 15.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (378) (-257.8, 1.9, 15.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (382) (-256.8, 1.9, 17.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (379) (-257.8, 1.9, 16.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (380) (-257.8, 1.9, 17.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (384) (-255.8, 1.9, 17.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (386) (-254.8, 1.9, 17.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (383) (-256.8, 1.9, 18.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (381) (-257.8, 1.9, 18.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (229) (-234.6, 8.0, 8.6)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (230) (-234.6, 8.0, 7.6)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (225) (-233.6, 8.0, 7.6)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (227) (-233.6, 8.0, 8.6)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (228) (-233.6, 8.0, 9.6)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (181) (-240.5, 8.0, 5.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (184) (-240.5, 8.0, 4.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (182) (-241.5, 8.0, 5.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (183) (-241.5, 8.0, 4.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (223) (-228.5, 8.0, 37.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (226) (-228.5, 8.0, 36.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (419) (-228.5, 8.0, 35.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (417) (-227.5, 8.0, 36.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (25) (-226.0, 8.0, 35.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (423) (-226.5, 8.0, 36.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (222) (-227.5, 8.0, 37.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (418) (-227.5, 8.0, 35.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (420) (-225.5, 8.0, 36.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (421) (-225.5, 8.0, 37.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (422) (-226.5, 8.0, 37.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (224) (-229.5, 8.0, 37.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (26) (-224.3, 8.0, 36.8)": TunicLocationData("none", "West Garden South Checkpoint"),
    # these 4 are above the magic dagger house, choosing south checkpoint based on vibes
    "West Garden - West Garden Grass (157) (-193.0, 8.0, 40.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (156) (-192.0, 8.0, 40.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (151) (-192.0, 8.0, 41.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (158) (-193.0, 8.0, 41.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (248) (-197.4, 1.0, 22.3)": TunicLocationData("none", "West Garden at Dagger House"),
    "West Garden - West Garden Grass (245) (-195.4, 1.0, 23.3)": TunicLocationData("none", "West Garden at Dagger House"),
    "West Garden - West Garden Grass (246) (-196.4, 1.0, 23.3)": TunicLocationData("none", "West Garden at Dagger House"),
    "West Garden - West Garden Grass (247) (-197.4, 1.0, 23.3)": TunicLocationData("none", "West Garden at Dagger House"),
    "West Garden - West Garden Grass (162) (-206.5, 1.0, 28.0)": TunicLocationData("none", "West Garden at Dagger House"),
    "West Garden - West Garden Grass (159) (-205.5, 1.0, 28.0)": TunicLocationData("none", "West Garden at Dagger House"),
    "West Garden - West Garden Grass (160) (-206.5, 1.0, 29.0)": TunicLocationData("none", "West Garden at Dagger House"),
    "West Garden - West Garden Grass (161) (-205.5, 1.0, 29.0)": TunicLocationData("none", "West Garden at Dagger House"),
    "West Garden - West Garden Grass (163) (-211.5, 1.0, 35.0)": TunicLocationData("none", "West Garden at Dagger House"),
    "West Garden - West Garden Grass (166) (-212.5, 1.0, 35.0)": TunicLocationData("none", "West Garden at Dagger House"),
    "West Garden - West Garden Grass (165) (-211.5, 1.0, 36.0)": TunicLocationData("none", "West Garden at Dagger House"),
    "West Garden - West Garden Grass (164) (-212.5, 1.0, 36.0)": TunicLocationData("none", "West Garden at Dagger House"),
    "West Garden - West Garden Grass (318) (-243.8, 8.0, 72.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (319) (-244.8, 8.0, 72.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (313) (-247.5, 8.0, 67.8)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (62) (-244.0, 8.0, 65.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (61) (-245.0, 8.0, 64.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (64) (-244.0, 8.0, 64.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (63) (-245.0, 8.0, 65.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (314) (-246.5, 8.0, 68.8)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (317) (-244.8, 8.0, 71.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (315) (-247.5, 8.0, 68.8)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (320) (-243.8, 8.0, 71.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (316) (-246.5, 8.0, 67.8)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (50) (-247.5, 8.0, 83.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (59) (-246.5, 8.0, 83.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (47) (-247.5, 8.0, 84.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (60) (-246.5, 8.0, 84.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (65) (-226.0, 8.0, 67.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (68) (-225.0, 8.0, 67.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (67) (-226.0, 8.0, 68.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (66) (-225.0, 8.0, 68.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (69) (-226.0, 8.0, 72.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (72) (-225.0, 8.0, 72.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (71) (-226.0, 8.0, 73.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (70) (-225.0, 8.0, 73.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (303) (-215.3, 8.0, 83.8)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (17) (-215.0, 8.0, 85.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (27) (-217.0, 8.0, 81.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (24) (-217.0, 8.0, 87.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (301) (-215.3, 8.0, 82.8)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (13) (-213.0, 8.0, 83.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (304) (-214.3, 8.0, 82.8)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (302) (-214.3, 8.0, 83.8)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (16) (-211.0, 8.0, 85.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (12) (-213.0, 8.0, 85.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (14) (-213.0, 8.0, 87.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (15) (-211.0, 8.0, 87.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (309) (-203.5, 8.0, 86.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (11) (-203.0, 8.0, 85.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (312) (-202.5, 8.0, 86.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (2) (-199.0, 8.0, 83.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (308) (-200.5, 8.0, 84.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (305) (-201.5, 8.0, 84.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (307) (-201.5, 8.0, 85.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (-199.0, 8.0, 87.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (306) (-200.5, 8.0, 85.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (7) (-201.0, 8.0, 87.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (310) (-202.5, 8.0, 87.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (311) (-203.5, 8.0, 87.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (1) (-199.0, 8.0, 85.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (4) (-197.0, 8.0, 85.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (5) (-197.0, 8.0, 83.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (3) (-197.0, 8.0, 87.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (6) (-197.0, 8.0, 81.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (10) (-191.0, 8.0, 81.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (8) (-191.0, 8.0, 87.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Bush (9) (-193.0, 8.0, 87.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (333) (-226.0, 8.0, 92.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (336) (-225.0, 8.0, 92.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (334) (-225.0, 8.0, 93.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (339) (-226.0, 8.0, 97.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (337) (-225.0, 8.0, 97.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (335) (-225.0, 8.0, 98.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (329) (-229.3, 8.0, 101.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (332) (-228.3, 8.0, 101.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (331) (-229.3, 8.0, 102.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (328) (-229.3, 8.0, 103.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (330) (-228.3, 8.0, 102.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (325) (-230.3, 8.0, 103.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (326) (-229.3, 8.0, 104.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (327) (-230.3, 8.0, 104.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (321) (-232.8, 8.0, 109.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (324) (-231.8, 8.0, 109.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (323) (-232.8, 8.0, 110.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (322) (-231.8, 8.0, 110.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (399) (-233.8, 8.0, 111.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (400) (-234.8, 8.0, 111.3)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (84) (-244.0, 8.0, 101.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (81) (-245.0, 8.0, 101.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (82) (-244.0, 8.0, 100.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (83) (-245.0, 8.0, 100.5)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (77) (-247.5, 8.0, 98.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (80) (-246.5, 8.0, 98.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (79) (-247.5, 8.0, 97.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (78) (-246.5, 8.0, 97.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (88) (-246.5, 8.0, 109.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (85) (-247.5, 8.0, 109.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (86) (-246.5, 8.0, 110.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (87) (-247.5, 8.0, 110.0)": TunicLocationData("none", "West Garden South Checkpoint"),
    "West Garden - West Garden Grass (283) (-225.4, 20.0, 172.9)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (284) (-225.4, 20.0, 173.9)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (282) (-226.4, 20.0, 172.9)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (285) (-226.4, 20.0, 173.9)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (279) (-222.3, 20.0, 177.6)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (278) (-222.3, 20.0, 178.6)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (32) (-221.3, 20.0, 178.8)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (33) (-221.3, 20.0, 177.8)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (280) (-221.3, 20.0, 176.6)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (275) (-222.3, 20.0, 179.8)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (9) (-221.3, 20.0, 179.8)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (281) (-223.3, 20.0, 179.8)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (385) (-246.6, 20.0, 172.0)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (294) (-247.6, 20.0, 172.0)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (291) (-247.6, 20.0, 173.0)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (290) (-247.6, 20.0, 174.0)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (292) (-246.6, 20.0, 174.0)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (293) (-246.6, 20.0, 173.0)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (287) (-244.8, 20.0, 176.0)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (288) (-244.8, 20.0, 175.0)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (286) (-245.8, 20.0, 175.0)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (289) (-245.8, 20.0, 176.0)": TunicLocationData("none", "West Garden before Boss"),
    "West Garden - West Garden Grass (-287.0, 4.0, 117.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (2) (-287.0, 4.0, 118.0)": TunicLocationData("none", "West Garden before Terry"),
    "West Garden - West Garden Grass (174) (-243.9, 0.5, 52.1)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (262) (-244.8, 0.5, 51.3)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (263) (-244.8, 0.5, 52.3)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (179) (-334.0, 4.0, 103.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (176) (-335.0, 4.0, 103.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Grass (178) (-334.0, 4.0, 102.0)": TunicLocationData("none", "West Garden after Terry"),
    "West Garden - West Garden Portal Grass (243) (-202.5, 8.0, -19.9)": TunicLocationData("none", "West Garden Portal"),
    "West Garden - West Garden Portal Grass (244) (-203.4, 8.0, -20.9)": TunicLocationData("none", "West Garden Portal"),
    "West Garden - West Garden Portal Grass (242) (-203.6, 8.0, -19.9)": TunicLocationData("none", "West Garden Portal"),
    "West Garden - West Garden Portal Grass (233) (-197.4, 8.0, -20.9)": TunicLocationData("none", "West Garden Portal"),
    "West Garden - West Garden Portal Grass (232) (-198.4, 8.0, -19.9)": TunicLocationData("none", "West Garden Portal"),
    "West Garden - West Garden Portal Grass (234) (-197.4, 8.0, -19.9)": TunicLocationData("none", "West Garden Portal"),
    "West Garden - West Garden Portal Grass (231) (-196.4, 8.0, -19.9)": TunicLocationData("none", "West Garden Portal"),
    "West Garden - West Garden Laurels Exit Grass (261) (-182.8, 2.0, 75.0)": TunicLocationData("none", "West Garden Laurels Exit Region"),
    "West Garden - West Garden Laurels Exit Grass (259) (-183.8, 2.0, 75.0)": TunicLocationData("none", "West Garden Laurels Exit Region"),
    "West Garden - West Garden Laurels Exit Grass (258) (-184.8, 2.0, 75.0)": TunicLocationData("none", "West Garden Laurels Exit Region"),
    "West Garden - West Garden Laurels Exit Grass (260) (-183.8, 2.0, 74.0)": TunicLocationData("none", "West Garden Laurels Exit Region"),
    "West Garden - West Garden Laurels Exit Grass (404) (-172.1, 2.0, 80.0)": TunicLocationData("none", "West Garden Laurels Exit Region"),
    "West Garden - West Garden Laurels Exit Grass (402) (-172.1, 2.0, 82.5)": TunicLocationData("none", "West Garden Laurels Exit Region"),
    "West Garden - West Garden Laurels Exit Grass (299) (-172.1, 2.0, 81.5)": TunicLocationData("none", "West Garden Laurels Exit Region"),
    "West Garden - West Garden Laurels Exit Grass (403) (-173.4, 2.0, 81.0)": TunicLocationData("none", "West Garden Laurels Exit Region"),
    "West Garden - West Garden Laurels Exit Grass (401) (-173.4, 2.0, 82.5)": TunicLocationData("none", "West Garden Laurels Exit Region"),
    "West Garden - West Garden Laurels Exit Grass (269) (-162.5, 2.0, 75.0)": TunicLocationData("none", "West Garden Laurels Exit Region"),
    "West Garden - West Garden Laurels Exit Grass (267) (-161.3, 2.0, 75.0)": TunicLocationData("none", "West Garden Laurels Exit Region"),
    "West Garden - West Garden Laurels Exit Grass (268) (-161.3, 2.0, 74.0)": TunicLocationData("none", "West Garden Laurels Exit Region"),
    "West Garden - West Garden Laurels Exit Grass (273) (-152.8, 2.0, 73.5)": TunicLocationData("none", "West Garden Laurels Exit Region"),
    "West Garden - West Garden Laurels Exit Grass (271) (-154.0, 2.0, 72.5)": TunicLocationData("none", "West Garden Laurels Exit Region"),
    "West Garden - West Garden Laurels Exit Grass (272) (-152.8, 2.0, 72.5)": TunicLocationData("none", "West Garden Laurels Exit Region"),
    "West Garden - West Garden Laurels Exit Grass (270) (-154.0, 2.0, 71.3)": TunicLocationData("none", "West Garden Laurels Exit Region"),
    "West Garden - West Garden Laurels Exit Grass (274) (-137.0, 2.0, 75.0)": TunicLocationData("none", "West Garden Laurels Exit Region"),
    "West Garden - West Garden Laurels Exit Grass (277) (-136.0, 2.0, 74.0)": TunicLocationData("none", "West Garden Laurels Exit Region"),
    "West Garden - West Garden Laurels Exit Grass (276) (-136.0, 2.0, 75.0)": TunicLocationData("none", "West Garden Laurels Exit Region"),
    "Ruined Atoll - Ruined Atoll Grass beach (132) (-17.0, 0.3, 59.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (133) (-17.0, 0.3, 60.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (131) (-16.0, 0.0, 59.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (130) (-16.0, 0.0, 60.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (129) (-15.0, 0.0, 60.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (134) (-15.0, 0.3, 61.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (139) (-20.0, 0.5, 47.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (140) (-20.0, 0.5, 48.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (138) (-19.0, 0.0, 46.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (137) (-19.0, 0.0, 47.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (136) (-19.0, 0.0, 48.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (141) (-20.0, 0.5, 49.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (135) (-19.0, 0.0, 49.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (109) (-30.3, 2.0, 40.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (106) (-31.3, 2.0, 40.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (107) (-31.3, 1.8, 39.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (110) (-32.3, 2.0, 39.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (108) (-30.3, 1.8, 39.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (111) (-31.3, 1.5, 38.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (123) (-27.8, 1.5, 61.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (121) (-27.8, 1.5, 62.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (118) (-27.8, 1.5, 63.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (122) (-26.8, 1.8, 62.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (117) (-26.8, 1.8, 63.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (115) (-26.8, 2.0, 64.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (114) (-25.8, 2.3, 64.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (113) (-25.8, 2.8, 65.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (112) (-26.8, 2.3, 65.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (119) (-27.8, 1.8, 64.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (120) (-27.8, 1.8, 65.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (179) (-30.3, 0.0, 23.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (176) (-31.3, 0.0, 22.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (178) (-31.3, 0.0, 23.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (177) (-30.3, 0.3, 22.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (174) (-31.3, 0.5, 21.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (180) (-30.3, 0.3, 21.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (182) (-32.0, 0.5, 17.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (183) (-31.0, 0.8, 17.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (184) (-31.0, 0.8, 16.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (185) (-32.0, 0.5, 16.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (186) (-32.0, 0.5, 15.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (187) (-33.0, 0.3, 15.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (126) (-29.3, 2.0, 3.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (116) (-28.3, 2.0, 3.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (128) (-28.3, 2.3, 4.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (127) (-29.3, 2.3, 4.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (143) (-27.3, 2.3, 5.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (142) (-28.3, 2.3, 5.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (147) (-26.3, 2.3, 5.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (146) (-26.3, 2.3, 6.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (145) (-27.3, 2.3, 6.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (171) (-34.3, 0.0, -6.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (170) (-34.3, 0.0, -7.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (156) (-33.3, 0.5, -8.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (173) (-33.3, 0.5, -7.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (172) (-33.3, 0.5, -6.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (157) (-34.3, 0.0, -8.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (144) (-32.3, 0.5, -8.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (125) (-32.3, 0.5, -9.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (155) (-32.3, 0.5, -8.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (124) (-33.3, 0.5, -9.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (152) (-19.3, 1.5, -5.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (151) (-19.3, 1.5, -4.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (158) (-17.3, 1.3, -6.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (159) (-17.3, 1.5, -5.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (161) (-16.3, 1.3, -5.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (153) (-20.3, 1.5, -5.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (150) (-20.3, 1.5, -4.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (149) (-21.3, 1.8, -4.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (154) (-21.3, 1.8, -5.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (148) (-22.3, 2.0, -4.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (166) (-16.3, 1.3, -8.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (169) (-15.3, 1.5, -9.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (162) (-16.3, 1.3, -7.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (165) (-15.3, 1.5, -8.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (163) (-15.3, 1.5, -7.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (160) (-16.3, 1.3, -6.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (164) (-15.3, 1.3, -6.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (168) (-14.3, 1.8, -9.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (167) (-14.3, 1.8, -8.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (181) (-20.5, 0.5, -16.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (188) (-19.5, 0.5, -16.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (189) (-19.5, 0.5, -17.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (175) (-20.5, 0.3, -17.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (192) (-20.5, 0.0, -18.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (190) (-21.5, 0.3, -17.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (191) (-21.5, -0.3, -18.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (21) (32.0, 0.9, 9.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (81) (30.0, 0.8, 7.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (82) (31.0, 0.8, 7.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (79) (31.0, 0.8, 9.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (19) (31.0, 0.6, 10.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (80) (30.0, 0.8, 9.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (83) (29.0, 0.8, 7.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (84) (29.0, 0.8, 8.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (20) (32.0, 0.8, 10.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (75) (41.0, 0.5, 9.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (77) (41.0, 0.5, 8.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (22) (42.0, 0.5, 9.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (78) (42.0, 0.5, 8.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (23) (42.0, 0.3, 10.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (76) (41.0, 0.5, 10.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (74) (42.0, 0.5, 11.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (25) (43.0, 0.3, 11.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (26) (43.0, 0.3, 10.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (91) (21.0, 1.3, 41.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (89) (22.0, 1.3, 40.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (28) (23.0, 1.0, 41.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (27) (23.0, 1.3, 40.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (93) (22.0, 1.0, 42.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (90) (22.0, 1.3, 41.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (92) (21.0, 1.0, 42.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (24) (24.0, 1.3, 40.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (29) (15.5, 0.8, 47.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (30) (15.5, 0.8, 48.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (33) (15.5, 0.8, 49.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (34) (15.5, 0.8, 50.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (31) (14.5, 0.8, 48.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (32) (14.5, 0.8, 49.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (86) (10.5, 3.0, 64.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (14) (9.5, 3.0, 64.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (35) (9.5, 2.5, 63.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (85) (8.5, 2.5, 63.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (15) (8.5, 3.0, 64.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (87) (24.0, 1.5, 64.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (18) (25.0, 1.5, 64.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (16) (25.0, 1.5, 65.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (17) (24.0, 1.5, 65.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (88) (23.0, 2.0, 65.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (237) (-99.0, 0.3, 61.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (393) (-100.0, 0.0, 62.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (226) (-100.0, 0.0, 61.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (228) (-99.0, 0.3, 60.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (227) (-100.0, 0.0, 60.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (390) (-99.0, 0.3, 59.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (260) (-83.7, 2.0, 19.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (261) (-83.7, 1.8, 18.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (259) (-82.5, 1.5, 18.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (257) (-82.5, 1.8, 19.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (258) (-81.2, 1.3, 18.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (256) (-81.2, 1.5, 19.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (255) (-80.5, 1.5, 14.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (254) (-80.5, 1.8, 13.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (249) (-79.5, 2.0, 12.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (248) (-79.5, 1.8, 13.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (251) (-80.5, 1.8, 11.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (252) (-80.5, 1.8, 12.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (247) (-79.5, 1.8, 14.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (246) (-79.5, 1.5, 15.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (253) (-79.5, 2.0, 10.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (250) (-79.5, 2.0, 11.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (264) (-53.8, 1.3, 14.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (265) (-53.8, 1.0, 13.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (263) (-52.8, 1.0, 14.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (266) (-53.8, 0.8, 12.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (262) (-52.8, 0.5, 13.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (267) (-53.3, 1.3, 20.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (270) (-54.3, 1.8, 20.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (268) (-53.3, 1.0, 21.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (269) (-54.3, 1.5, 21.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (272) (-69.5, 1.8, -23.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (273) (-69.5, 1.8, -23.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (271) (-69.5, 1.8, -22.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (274) (-70.2, 1.0, -33.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (275) (-70.2, 0.8, -34.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (277) (-69.2, 1.0, -33.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (278) (-69.2, 0.5, -34.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (276) (-69.2, 1.0, -34.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (279) (-68.2, 0.5, -34.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (193) (-88.2, 1.8, -52.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (194) (-88.2, 1.8, -53.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (195) (-88.2, 2.0, -54.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (197) (-87.2, 1.8, -53.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (196) (-87.2, 1.8, -54.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (192) (-97.2, 1.5, -66.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (191) (-96.5, 1.5, -66.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (189) (-96.5, 1.5, -67.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (190) (-95.5, 1.5, -67.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (187) (-95.5, 1.5, -68.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (188) (-96.5, 1.5, -68.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (186) (-95.5, 1.5, -69.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (185) (-96.0, 1.8, -72.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (184) (-96.0, 2.0, -73.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (183) (-96.5, 2.0, -73.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (169) (-100.5, 1.5, -74.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (165) (-99.5, 1.5, -75.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (167) (-101.5, 1.3, -75.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (168) (-101.5, 1.3, -74.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (170) (-102.5, 1.3, -74.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (166) (-100.5, 1.5, -75.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (176) (-103.5, 1.0, -68.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (172) (-103.5, 1.3, -69.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (179) (-102.5, 1.3, -67.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (180) (-101.5, 1.3, -67.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (181) (-101.5, 1.3, -66.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (177) (-103.5, 1.0, -67.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (182) (-102.5, 1.3, -66.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (171) (-103.5, 1.3, -70.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (173) (-104.5, 1.3, -69.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (175) (-104.5, 1.0, -68.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (178) (-104.5, 1.0, -67.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (174) (-104.5, 1.3, -70.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (153) (-98.0, 1.8, -80.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (156) (-99.0, 1.8, -80.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (148) (-96.7, 1.8, -82.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (151) (-96.7, 1.8, -83.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (152) (-96.7, 1.8, -84.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (150) (-95.7, 1.8, -83.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (149) (-95.7, 1.8, -82.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (155) (-95.7, 1.8, -84.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (154) (-95.7, 1.8, -85.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (145) (-91.5, 3.0, -87.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (146) (-91.5, 3.3, -86.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (144) (-90.5, 3.3, -87.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (143) (-89.5, 3.5, -87.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (147) (-90.5, 3.8, -86.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (142) (-89.5, 4.0, -86.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (158) (-102.8, 1.0, -91.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (157) (-102.8, 1.0, -92.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (159) (-104.0, 1.0, -92.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (160) (-104.0, 1.0, -93.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (161) (-102.0, 1.8, -97.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (162) (-101.0, 1.8, -97.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (163) (-102.0, 0.8, -98.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (122) (-85.7, 2.8, -94.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (141) (-85.5, 3.3, -89.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (139) (-85.5, 3.3, -90.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (140) (-84.5, 3.3, -90.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (121) (-84.7, 3.0, -94.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (118) (-83.7, 3.3, -94.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (120) (-84.7, 2.8, -95.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (119) (-83.7, 2.8, -95.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (125) (-78.2, 3.5, -94.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (128) (-78.2, 3.3, -95.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (127) (-78.2, 3.0, -96.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (126) (-79.2, 3.0, -96.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (123) (-79.2, 3.5, -95.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (124) (-79.2, 3.5, -94.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (113) (-83.7, 1.3, -104.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (114) (-83.7, 0.8, -105.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (115) (-82.7, 0.8, -105.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (112) (-82.7, 1.3, -104.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (109) (-80.7, 1.3, -104.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (116) (-80.7, 1.5, -103.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (111) (-81.7, 1.3, -104.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (117) (-81.7, 1.5, -103.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (17) (-37.0, 1.9, -82.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (18) (-36.0, 1.9, -82.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (22) (-35.0, 1.9, -82.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (24) (-35.0, 1.9, -81.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (20) (-36.0, 1.9, -81.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (19) (-37.0, 1.9, -81.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (21) (-34.0, 1.9, -81.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (27) (-34.0, 1.9, -80.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (23) (-34.0, 1.9, -82.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (26) (-35.0, 1.9, -80.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (28) (-35.0, 1.9, -79.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (25) (-34.0, 2.4, -79.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (30) (-29.0, 1.9, -85.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (31) (-28.0, 1.9, -85.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (38) (-28.0, 1.9, -86.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (39) (-28.0, 2.4, -87.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (32) (-29.0, 1.9, -84.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (35) (-27.0, 1.9, -85.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (37) (-27.0, 1.9, -86.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (40) (-27.0, 2.3, -87.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (29) (-28.0, 1.9, -84.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (34) (-27.0, 1.9, -84.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (33) (-26.0, 1.9, -84.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (36) (-26.0, 1.9, -85.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (80) (-26.2, 3.6, -74.6)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (78) (-26.2, 3.6, -73.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (81) (-25.2, 3.1, -74.6)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (77) (-25.2, 3.1, -73.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (79) (-27.3, 4.4, -73.6)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (82) (-24.1, 2.4, -73.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (10) (-14.0, 2.7, -76.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (9) (-14.0, 2.9, -77.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (1) (-12.0, 2.9, -77.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (4) (-13.0, 2.9, -77.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (3) (-13.0, 2.9, -76.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (8) (-13.0, 2.9, -78.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (2) (-12.0, 2.9, -78.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (-12.0, 2.9, -76.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (7) (-11.0, 3.1, -78.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (12) (-11.0, 2.8, -79.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (5) (-12.0, 2.9, -79.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (11) (-11.0, 2.6, -80.9)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (6) (-12.0, 2.4, -80.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (90) (-10.0, 1.9, -95.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (93) (-10.0, 1.9, -96.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (94) (-10.0, 1.9, -97.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (83) (-9.0, 1.9, -96.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (89) (-9.0, 1.9, -95.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (86) (-9.0, 1.9, -97.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (87) (-9.0, 1.9, -98.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (84) (-8.0, 1.9, -96.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (88) (-8.0, 1.9, -98.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (91) (-7.0, 1.9, -96.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (92) (-7.0, 1.9, -97.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (85) (-8.0, 1.9, -97.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (95) (-18.8, 0.8, -97.4)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (96) (-18.8, 0.9, -96.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (98) (-17.8, 0.9, -97.4)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (97) (-17.7, 1.1, -96.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (101) (-18.0, 0.7, -98.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (100) (-18.9, 0.6, -98.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (99) (-19.9, 0.7, -97.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (164) (-101.0, 1.5, -98.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (74) (-89.5, 7.8, -82.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (75) (-89.5, 7.8, -81.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (70) (-84.5, 8.0, -84.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (71) (-84.5, 8.0, -85.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (73) (-82.5, 8.0, -85.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (69) (-82.5, 8.0, -84.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (68) (-83.5, 8.0, -84.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (72) (-83.5, 8.0, -85.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (65) (-82.5, 8.0, -83.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (66) (-82.5, 8.0, -84.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (64) (-83.5, 8.0, -83.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (67) (-83.5, 8.0, -84.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (63) (-85.7, 13.3, -70.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (60) (-88.5, 12.8, -72.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (62) (-85.7, 13.8, -69.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (58) (-88.5, 13.3, -70.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (59) (-88.5, 12.8, -71.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (78) (-81.7, 15.0, -61.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (77) (-82.7, 15.0, -61.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (76) (-83.7, 15.0, -61.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (202) (-83.0, 15.0, -62.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (203) (-84.0, 15.0, -62.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (79) (-79.7, 18.3, -78.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (80) (-79.7, 18.0, -79.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (87) (-77.5, 25.0, -69.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (88) (-77.5, 25.0, -70.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (86) (-78.5, 25.0, -69.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (85) (-70.2, 25.0, -77.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (83) (-71.2, 25.0, -78.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (82) (-70.2, 25.0, -78.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (81) (-69.2, 25.0, -78.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (84) (-69.2, 25.0, -77.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (297) (-99.0, 0.8, 7.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (296) (-98.0, 0.8, 7.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (103) (-8.0, 1.8, -40.4)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (102) (-8.0, 1.8, -39.4)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (104) (-9.0, 1.8, -40.4)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (197) (-11.3, 1.5, -30.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (196) (-12.3, 1.3, -30.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (195) (-12.3, 1.0, -31.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (199) (-12.3, 1.0, -29.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (194) (-13.3, 0.8, -31.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (193) (-13.3, 0.8, -30.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (198) (-11.3, 1.3, -29.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (201) (-12.0, 0.0, -46.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (202) (-12.0, 0.3, -45.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (204) (-13.0, 0.0, -46.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (200) (-11.0, 0.0, -46.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (203) (-11.0, 0.3, -45.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (206) (-30.0, 0.3, -33.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (205) (-30.0, 0.3, -32.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (207) (-29.0, 0.0, -33.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (208) (-29.0, 0.0, -32.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (245) (48.0, 1.0, 51.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (242) (48.0, 0.8, 52.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (244) (47.3, 0.8, 51.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (243) (48.0, 0.8, 53.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (240) (47.3, 0.5, 53.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (241) (47.3, 0.8, 52.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (231) (46.3, 0.5, 53.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (239) (47.3, 0.5, 54.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (238) (46.3, 0.5, 54.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (235) (64.8, 0.8, 53.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (229) (64.8, 0.8, 54.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (234) (65.8, 0.5, 53.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (232) (65.8, 0.8, 54.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (233) (62.8, 0.8, 54.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (230) (63.8, 0.8, 54.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (236) (62.8, 0.8, 55.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (223) (68.5, 1.5, 52.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (224) (68.5, 1.5, 51.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (220) (69.5, 2.0, 52.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (221) (69.5, 2.0, 51.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (222) (68.5, 1.8, 53.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (219) (69.5, 2.0, 53.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (5) (53.5, 6.0, 70.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (4) (53.5, 6.0, 70.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (23) (52.5, 6.0, 70.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (25) (55.8, 6.0, 72.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (27) (56.8, 6.0, 74.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (26) (56.8, 6.0, 73.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (24) (55.8, 6.0, 73.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (43) (67.8, 5.8, 82.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (42) (68.8, 5.8, 82.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (33) (67.8, 5.8, 83.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (35) (69.8, 5.8, 83.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (41) (69.8, 5.8, 82.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (34) (68.8, 5.8, 83.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (49) (69.8, 5.8, 84.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (50) (70.8, 5.8, 84.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (46) (74.8, 5.8, 82.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (45) (75.8, 5.8, 82.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (44) (76.8, 5.8, 82.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (48) (76.8, 5.8, 83.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (47) (75.8, 5.8, 83.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (113) (72.5, 2.8, 87.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (111) (71.5, 2.8, 86.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (112) (72.5, 2.8, 86.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (114) (71.5, 2.8, 87.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (115) (70.5, 2.8, 87.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (110) (70.5, 2.8, 86.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (90) (69.8, 12.8, 80.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (30) (59.8, 7.8, 62.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (31) (58.8, 7.8, 62.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (32) (58.8, 8.0, 61.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (29) (59.8, 8.0, 61.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (28) (59.8, 8.3, 60.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (38) (68.5, 11.8, 59.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (39) (67.5, 11.8, 60.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (37) (68.5, 11.8, 60.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (108) (61.8, 12.8, 67.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (109) (61.8, 12.8, 68.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (89) (69.8, 12.8, 79.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (51) (68.8, 12.8, 79.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (91) (68.8, 12.8, 80.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (106) (64.5, 13.5, 63.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (107) (65.5, 14.0, 63.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (92) (64.5, 13.5, 64.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (200) (69.8, 15.8, 62.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (198) (70.8, 16.0, 62.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (95) (78.5, 18.8, 64.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (94) (79.5, 18.8, 64.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (93) (79.5, 18.8, 65.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (104) (75.5, 20.8, 66.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (105) (74.5, 20.8, 66.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (97) (63.8, 20.8, 69.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (96) (62.8, 20.8, 69.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (98) (62.8, 20.8, 68.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (103) (68.8, 20.8, 77.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (102) (69.8, 20.8, 77.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (99) (68.8, 20.8, 78.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (100) (69.8, 20.8, 78.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (101) (70.8, 20.8, 78.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (215) (72.3, 0.3, 26.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (216) (72.3, 0.3, 25.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (214) (73.3, 0.3, 26.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (217) (68.5, 1.3, 15.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (211) (68.5, 1.0, 14.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (212) (69.5, 1.3, 14.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (209) (69.5, 1.3, 13.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (213) (69.5, 1.3, 15.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (210) (68.5, 1.0, 13.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (218) (69.5, 1.3, 16.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (62.0, 2.0, 5.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (1) (62.0, 2.0, 4.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (2) (63.0, 2.5, 4.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (73) (54.5, 0.5, -1.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (72) (53.5, 0.5, -1.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (5) (54.5, 1.0, -2.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (6) (53.5, 0.5, -2.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (7) (53.5, 0.5, -3.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (70) (52.5, 0.5, -3.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (71) (52.5, 0.5, -2.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (4) (54.5, 0.5, -3.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (8) (54.5, 0.5, -4.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (10) (55.5, 1.0, -3.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (9) (55.5, 0.5, -4.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (382) (83.5, 3.3, 69.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (381) (83.5, 3.3, 70.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (379) (82.5, 3.5, 69.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (380) (82.5, 3.5, 70.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (372) (85.0, 3.3, 75.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (371) (85.0, 3.3, 76.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (370) (84.0, 3.5, 76.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (373) (84.0, 3.5, 77.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (374) (84.0, 3.5, 78.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (369) (84.0, 3.5, 75.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (378) (83.0, 4.0, 77.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (375) (84.0, 3.3, 79.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (377) (83.0, 4.0, 78.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (376) (83.0, 3.8, 79.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (368) (89.0, 2.0, 79.9)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (367) (88.0, 2.0, 79.9)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (366) (88.0, 2.3, 78.9)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (364) (89.0, 2.3, 78.9)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (365) (90.0, 2.3, 78.9)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (389) (92.6, 1.9, 72.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (388) (92.6, 2.2, 71.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (383) (93.6, 1.4, 72.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (384) (93.6, 1.9, 71.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (386) (94.6, 1.9, 70.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (385) (94.6, 1.7, 71.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (387) (93.6, 1.9, 70.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (357) (98.5, 3.5, 67.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (356) (99.5, 3.5, 67.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (360) (100.5, 3.5, 67.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (358) (99.5, 3.3, 68.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (359) (100.5, 3.3, 68.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (363) (102.5, 3.3, 67.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (355) (102.5, 3.5, 65.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (361) (103.5, 3.0, 65.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (362) (103.5, 2.8, 67.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (292) (68.3, 0.8, -39.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (293) (68.3, 0.8, -40.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (294) (69.5, 1.0, -41.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (290) (69.3, 1.0, -39.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (289) (69.3, 1.3, -40.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (291) (69.3, 0.8, -38.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (295) (70.3, 1.0, -41.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (287) (60.0, 1.0, -29.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (288) (60.0, 1.3, -28.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (286) (59.0, 0.8, -29.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (284) (59.0, 1.0, -28.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (285) (59.0, 1.3, -27.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (282) (58.0, 1.3, -27.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (283) (58.0, 0.8, -28.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (94) (36.5, 1.3, -20.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (36) (37.5, 1.3, -20.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (96) (37.5, 1.3, -21.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (95) (36.5, 1.3, -19.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (37) (37.5, 1.1, -19.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (38) (38.5, 0.9, -20.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (97) (38.5, 1.3, -21.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (50) (21.4, 0.8, -33.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (51) (21.4, 0.8, -34.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (60) (21.4, 0.8, -32.4)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (48) (20.4, 0.4, -34.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (59) (20.4, 0.4, -35.6)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (49) (20.4, 0.4, -33.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (63) (25.0, 0.5, -42.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (64) (24.0, 0.0, -42.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (61) (25.0, 0.4, -43.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (65) (24.0, 0.0, -43.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (62) (25.0, 0.5, -44.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (103) (26.0, 0.6, -44.4)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (104) (26.0, 0.5, -43.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (101) (33.5, 0.8, -38.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (100) (33.5, 0.8, -37.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (99) (32.5, 0.8, -36.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (67) (34.5, 0.6, -37.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (102) (34.5, 0.8, -38.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (66) (34.5, 0.6, -36.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (68) (33.5, 0.8, -36.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (98) (32.5, 0.8, -35.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (69) (33.5, 0.8, -35.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (46) (36.0, 0.1, -49.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (45) (36.0, 0.1, -48.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (47) (35.0, 0.3, -48.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (41) (33.5, 2.6, -72.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (40) (34.5, 3.1, -71.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (39) (34.5, 3.1, -72.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (42) (34.5, 3.1, -73.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (43) (39.0, 2.5, -74.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (44) (40.0, 2.5, -74.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (105) (40.0, 2.5, -74.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (54) (41.4, 1.3, -87.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (56) (40.4, 1.3, -86.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (55) (42.4, 1.0, -87.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (53) (41.4, 1.3, -86.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (52) (42.4, 1.0, -86.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (58) (41.5, 1.1, -85.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (57) (40.4, 1.3, -85.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (105) (30.3, 2.0, -106.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (107) (31.3, 2.0, -106.3)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (110) (30.5, 0.3, -109.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (106) (30.5, 0.5, -108.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (280) (31.5, 1.0, -108.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (108) (31.5, 1.0, -108.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (281) (31.5, 0.3, -109.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (61) (19.1, 2.1, -100.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (59) (19.1, 2.1, -101.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (63) (18.1, 2.1, -100.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (62) (18.1, 2.1, -99.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (64) (19.1, 2.0, -99.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (60) (18.1, 2.1, -101.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (44) (17.1, 2.1, -101.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (41) (16.1, 2.1, -101.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (45) (17.1, 2.1, -102.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (43) (16.1, 2.1, -103.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (42) (16.1, 2.1, -102.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (58) (18.1, 2.1, -102.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (46) (17.1, 2.1, -103.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (57) (19.1, 2.1, -102.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (48) (16.1, 2.1, -104.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (47) (17.1, 2.1, -104.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (52) (18.1, 2.1, -97.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (50) (18.1, 2.1, -96.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (53) (18.1, 2.1, -95.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (55) (18.1, 2.1, -94.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (54) (17.1, 2.1, -95.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (49) (17.1, 2.1, -97.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (51) (17.1, 2.1, -96.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (56) (17.1, 2.1, -94.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (66) (16.1, 2.1, -110.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (68) (16.1, 2.1, -111.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (65) (17.1, 2.1, -110.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (67) (17.1, 2.1, -111.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (72) (18.1, 2.1, -111.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (71) (18.1, 2.1, -110.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (73) (18.1, 2.1, -109.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (74) (19.1, 2.1, -109.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (70) (19.1, 2.1, -110.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (76) (18.1, 2.1, -108.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (75) (19.1, 2.1, -108.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (69) (19.1, 2.1, -111.1)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (130) (-3.5, 0.5, -116.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (131) (-3.5, 0.5, -117.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (129) (-2.5, 0.3, -116.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (132) (-2.5, 0.3, -117.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (133) (-2.5, 0.3, -118.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (138) (8.0, 0.5, -124.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (137) (8.0, 0.0, -125.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (135) (10.0, 0.5, -124.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (136) (9.0, 0.0, -125.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (134) (9.0, 0.5, -124.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (395) (67.8, 2.5, -80.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (394) (67.8, 2.5, -79.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (391) (66.8, 2.5, -79.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (397) (68.8, 2.5, -79.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (396) (66.8, 2.5, -80.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (392) (65.8, 2.5, -79.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (400) (63.3, 2.8, -74.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (399) (64.3, 3.0, -74.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (401) (63.3, 2.8, -73.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (398) (64.3, 3.0, -73.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (402) (62.3, 2.5, -73.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (405) (60.5, 1.3, -68.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (404) (59.5, 0.5, -68.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (406) (60.5, 1.3, -69.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (403) (59.5, 0.5, -69.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (407) (61.5, 1.5, -69.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (325) (-111.8, 1.3, 2.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (323) (-111.8, 1.3, 1.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (316) (-110.5, 1.3, 3.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (319) (-111.5, 1.3, 4.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (317) (-111.5, 1.3, 3.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (318) (-110.5, 1.3, 4.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (321) (-112.3, 1.3, 4.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (320) (-112.3, 1.3, 3.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (326) (-112.8, 1.3, 2.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (327) (-113.5, 1.3, 2.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (324) (-112.8, 1.3, 1.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (322) (-113.5, 1.3, 1.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (328) (-112.0, 0.8, -2.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (329) (-112.0, 0.5, -3.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (333) (-111.3, 0.8, -2.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (331) (-111.3, 0.5, -3.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (330) (-110.3, 0.5, -3.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (332) (-110.3, 0.8, -2.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (334) (-111.0, 0.3, -4.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (337) (-110.3, 0.3, -4.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (354) (-113.0, 0.3, -4.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (353) (-112.0, 0.3, -4.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (336) (-109.3, 0.3, -4.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (338) (-109.3, -0.3, -5.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (339) (-110.3, -0.3, -5.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (335) (-111.0, -0.3, -5.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (350) (-112.0, -0.3, -5.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (349) (-113.8, 0.3, -4.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (351) (-113.0, -0.3, -5.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (352) (-113.8, -0.3, -5.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (314) (-112.3, 0.8, 6.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (315) (-112.3, 0.8, 7.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (313) (-111.5, 0.8, 6.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (311) (-111.5, 0.8, 7.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (310) (-110.5, 0.8, 7.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (306) (-110.5, 0.8, 8.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (312) (-110.5, 0.8, 6.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (307) (-109.5, 0.8, 8.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (308) (-111.5, 0.8, 8.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (300) (-107.5, 0.0, 10.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (301) (-107.5, 0.3, 9.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (304) (-108.3, 0.0, 10.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (299) (-108.5, 0.0, 10.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (303) (-110.5, 0.3, 9.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (302) (-109.5, 0.3, 9.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (305) (-109.5, 0.0, 10.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (298) (-108.5, 0.3, 9.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (341) (-113.5, 0.8, 10.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (344) (-113.5, 0.5, 11.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (346) (-113.5, 0.8, 9.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (309) (-111.5, 0.5, 9.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (345) (-112.5, 0.8, 9.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (342) (-112.5, 0.8, 8.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (340) (-112.5, 0.8, 10.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (347) (-114.3, 0.8, 8.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (348) (-114.3, 0.8, 9.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass beach (343) (-113.5, 0.8, 8.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (191) (-89.5, 6.5, 53.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (190) (-89.5, 6.5, 54.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (189) (-88.5, 6.5, 54.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (188) (-88.5, 6.5, 53.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (197) (-87.0, 13.0, 75.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (194) (-87.0, 13.0, 74.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (184) (-86.0, 13.0, 73.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (183) (-86.0, 13.0, 74.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (181) (-86.0, 13.0, 75.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (185) (-84.7, 13.0, 73.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (182) (-83.0, 13.0, 72.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (199) (-83.0, 13.0, 70.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (201) (-84.0, 13.0, 70.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (135) (-83.5, 13.0, 58.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (128) (-82.5, 13.0, 57.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (130) (-82.5, 13.0, 58.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (147) (-86.0, 13.0, 54.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (132) (-82.5, 13.0, 60.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (134) (-83.5, 13.0, 59.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (131) (-82.5, 13.0, 59.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (136) (-78.5, 13.0, 56.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (139) (-79.5, 13.0, 55.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (133) (-79.5, 13.0, 56.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (138) (-80.5, 13.0, 55.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (137) (-80.5, 13.0, 56.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (143) (-85.0, 13.0, 53.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (142) (-86.0, 13.0, 53.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (145) (-87.0, 13.0, 53.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (146) (-87.0, 13.0, 54.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (140) (-85.0, 13.0, 52.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (141) (-86.0, 13.0, 52.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (144) (-84.0, 13.0, 52.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (192) (-70.5, 13.0, 56.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (186) (-69.5, 13.0, 56.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (187) (-69.5, 13.0, 55.8)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (123) (-82.5, 13.0, 44.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (126) (-82.5, 13.0, 45.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (121) (-83.5, 13.0, 45.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (124) (-83.5, 13.0, 44.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (125) (-83.5, 13.0, 43.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (151) (-82.5, 13.0, 27.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (152) (-82.5, 13.0, 26.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (150) (-81.5, 13.0, 27.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (148) (-81.5, 13.0, 25.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (149) (-81.5, 13.0, 26.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (154) (-79.0, 13.0, 23.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (153) (-78.0, 13.0, 23.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (161) (-68.0, 13.0, 26.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (162) (-68.0, 13.0, 27.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (165) (-69.0, 13.0, 27.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (164) (-69.0, 13.0, 28.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (163) (-68.0, 13.0, 28.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (166) (-68.0, 13.0, 29.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (167) (-63.0, 13.0, 24.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (168) (-62.0, 13.0, 24.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (170) (-61.0, 13.0, 25.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (169) (-62.0, 13.0, 25.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (172) (-62.0, 13.0, 26.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (178) (-61.0, 13.0, 43.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (175) (-60.0, 13.0, 43.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (177) (-61.0, 13.0, 44.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (174) (-59.0, 13.0, 42.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (173) (-59.0, 13.0, 43.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (171) (-59.0, 13.0, 44.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (176) (-60.0, 13.0, 44.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (159) (-83.5, 8.0, 23.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (160) (-83.5, 8.0, 24.5)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (158) (-83.5, 8.0, 22.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (155) (-82.5, 8.0, 24.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (157) (-82.5, 8.0, 22.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Grass (156) (-82.5, 8.0, 23.0)": TunicLocationData("Ruined Atoll", "Ruined Atoll"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass beach (413) (-10.3, 0.3, 128.5)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass beach (414) (-10.3, 0.3, 127.5)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass beach (412) (-11.3, 0.0, 129.5)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass beach (411) (-11.3, 0.0, 128.5)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass beach (410) (-11.3, 0.0, 127.5)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass beach (408) (-4.0, 1.0, 118.0)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass beach (13) (-4.0, 1.0, 116.8)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass beach (12) (-3.0, 1.0, 116.8)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass beach (409) (-3.0, 0.8, 115.8)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass beach (11) (-3.0, 1.0, 117.8)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass beach (3) (-3.0, 1.0, 118.8)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass (129) (32.5, 0.8, 84.8)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass (179) (33.5, 0.8, 84.8)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass (180) (34.5, 0.8, 84.8)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass (195) (33.5, 0.3, 85.8)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass (193) (35.3, 0.8, 84.8)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass (196) (34.5, 0.3, 85.8)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass beach (418) (54.5, 0.8, 78.3)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass beach (419) (54.5, 0.8, 77.3)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass beach (417) (55.8, 0.8, 78.3)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass beach (416) (55.8, 1.0, 77.3)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Lower Entry Area Grass beach (415) (56.8, 0.8, 78.3)": TunicLocationData(
        "Ruined Atoll Lower Entry Area", "Ruined Atoll Lower Entry Area"),
    "Ruined Atoll - Ruined Atoll Frog Mouth Grass (20) (87.5, 12.5, 59.0)": TunicLocationData("Ruined Atoll Frog Mouth",
                                                                                              "Ruined Atoll Frog Mouth"),
    "Ruined Atoll - Ruined Atoll Frog Mouth Grass (17) (86.5, 12.5, 59.0)": TunicLocationData("Ruined Atoll Frog Mouth",
                                                                                              "Ruined Atoll Frog Mouth"),
    "Ruined Atoll - Ruined Atoll Frog Mouth Grass (16) (86.5, 12.5, 60.0)": TunicLocationData("Ruined Atoll Frog Mouth",
                                                                                              "Ruined Atoll Frog Mouth"),
    "Ruined Atoll - Ruined Atoll Frog Mouth Grass (21) (87.5, 12.5, 60.0)": TunicLocationData("Ruined Atoll Frog Mouth",
                                                                                              "Ruined Atoll Frog Mouth"),
    "Ruined Atoll - Ruined Atoll Frog Mouth Grass (15) (91.5, 12.5, 58.0)": TunicLocationData("Ruined Atoll Frog Mouth",
                                                                                              "Ruined Atoll Frog Mouth"),
    "Ruined Atoll - Ruined Atoll Frog Mouth Grass (14) (91.5, 12.5, 57.0)": TunicLocationData("Ruined Atoll Frog Mouth",
                                                                                              "Ruined Atoll Frog Mouth"),
    "Ruined Atoll - Ruined Atoll Frog Mouth Grass (13) (92.5, 12.5, 57.0)": TunicLocationData("Ruined Atoll Frog Mouth",
                                                                                              "Ruined Atoll Frog Mouth"),
    "Ruined Atoll - Ruined Atoll Frog Mouth Grass (12) (92.5, 12.5, 58.0)": TunicLocationData("Ruined Atoll Frog Mouth",
                                                                                              "Ruined Atoll Frog Mouth"),
    "Ruined Atoll - Ruined Atoll Frog Mouth Grass (10) (93.5, 12.5, 57.0)": TunicLocationData("Ruined Atoll Frog Mouth",
                                                                                              "Ruined Atoll Frog Mouth"),
    "Ruined Atoll - Ruined Atoll Frog Mouth Grass (11) (93.5, 12.5, 58.0)": TunicLocationData("Ruined Atoll Frog Mouth",
                                                                                              "Ruined Atoll Frog Mouth"),
    "Frog Stairway - Frog Stairs Upper Grass (24) (187.0, 106.0, -65.0)": TunicLocationData("Frog Stairs Upper",
                                                                                            "Frog Stairs Upper"),
    "Frog Stairway - Frog Stairs Upper Grass (23) (188.0, 106.0, -65.0)": TunicLocationData("Frog Stairs Upper",
                                                                                            "Frog Stairs Upper"),
    "Frog Stairway - Frog Stairs Upper Grass (22) (189.0, 106.0, -64.0)": TunicLocationData("Frog Stairs Upper",
                                                                                            "Frog Stairs Upper"),
    "Frog Stairway - Frog Stairs Upper Grass (20) (188.0, 106.0, -64.0)": TunicLocationData("Frog Stairs Upper",
                                                                                            "Frog Stairs Upper"),
    "Frog Stairway - Frog Stairs Upper Grass (17) (187.0, 106.0, -64.0)": TunicLocationData("Frog Stairs Upper",
                                                                                            "Frog Stairs Upper"),
    "Frog Stairway - Frog Stairs Upper Grass (14) (191.0, 106.0, -64.0)": TunicLocationData("Frog Stairs Upper",
                                                                                            "Frog Stairs Upper"),
    "Frog Stairway - Frog Stairs Upper Grass (12) (192.0, 106.0, -63.0)": TunicLocationData("Frog Stairs Upper",
                                                                                            "Frog Stairs Upper"),
    "Frog Stairway - Frog Stairs Upper Grass (15) (191.0, 106.0, -63.0)": TunicLocationData("Frog Stairs Upper",
                                                                                            "Frog Stairs Upper"),
    "Frog Stairway - Frog Stairs Upper Grass (13) (192.0, 106.0, -64.0)": TunicLocationData("Frog Stairs Upper",
                                                                                            "Frog Stairs Upper"),
    "Frog Stairway - Frog Stairs Upper Grass (25) (192.0, 106.0, -65.0)": TunicLocationData("Frog Stairs Upper",
                                                                                            "Frog Stairs Upper"),
    "Frog Stairway - Frog Stairs Upper Grass (16) (189.0, 106.0, -63.0)": TunicLocationData("Frog Stairs Upper",
                                                                                            "Frog Stairs Upper"),
    "Frog Stairway - Frog Stairs Upper Grass (21) (188.0, 106.0, -63.0)": TunicLocationData("Frog Stairs Upper",
                                                                                            "Frog Stairs Upper"),
    "Frog Stairway - Frog Stairs Upper Grass (10) (193.0, 106.0, -64.0)": TunicLocationData("Frog Stairs Upper",
                                                                                            "Frog Stairs Upper"),
    "Frog Stairway - Frog Stairs Upper Grass (11) (193.0, 106.0, -63.0)": TunicLocationData("Frog Stairs Upper",
                                                                                            "Frog Stairs Upper"),
    "Frog Stairway - Frog Stairs Upper Grass (26) (193.0, 106.0, -62.0)": TunicLocationData("Frog Stairs Upper",
                                                                                            "Frog Stairs Upper"),
    "Frog Stairway - Frog Stairs Upper Grass (27) (196.6, 106.0, -62.5)": TunicLocationData("Frog Stairs Upper",
                                                                                            "Frog Stairs Upper"),
    "Frog Stairway - Frog Stairs Lower Grass (9) (179.8, 61.9, -67.1)": TunicLocationData("Frog Stairs Lower",
                                                                                          "Frog Stairs Lower"),
    "Frog Stairway - Frog Stairs Lower Grass (8) (178.6, 61.9, -67.1)": TunicLocationData("Frog Stairs Lower",
                                                                                          "Frog Stairs Lower"),
    "Frog Stairway - Frog Stairs Lower Grass (7) (204.4, 58.1, -94.1)": TunicLocationData("Frog Stairs Lower",
                                                                                          "Frog Stairs Lower"),
    "Frog Stairway - Frog Stairs Lower Grass (5) (205.5, 58.1, -94.1)": TunicLocationData("Frog Stairs Lower",
                                                                                          "Frog Stairs Lower"),
    "Frog Stairway - Frog Stairs Lower Grass (6) (205.5, 58.1, -93.0)": TunicLocationData("Frog Stairs Lower",
                                                                                          "Frog Stairs Lower"),
    "Frog Stairway - Frog Stairs Lower Grass (2) (205.5, 54.0, -77.0)": TunicLocationData("Frog Stairs Lower",
                                                                                          "Frog Stairs Lower"),
    "Frog Stairway - Frog Stairs Lower Grass (205.5, 54.0, -76.0)": TunicLocationData("Frog Stairs Lower",
                                                                                      "Frog Stairs Lower"),
    "Frog Stairway - Frog Stairs Lower Grass (1) (204.5, 54.0, -76.0)": TunicLocationData("Frog Stairs Lower",
                                                                                          "Frog Stairs Lower"),
    "Frog Stairway - Frog Stairs Lower Grass (4) (201.4, 54.3, -71.3)": TunicLocationData("Frog Stairs Lower",
                                                                                          "Frog Stairs Lower"),
    "Frog Stairway - Frog Stairs Lower Grass (3) (200.4, 54.3, -71.3)": TunicLocationData("Frog Stairs Lower",
                                                                                          "Frog Stairs Lower"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (77) (-8.8, -4.0, -169.5)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (78) (-7.8, -4.0, -169.5)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (81) (-7.8, -4.0, -168.5)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (80) (-6.8, -4.0, -168.5)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (79) (-6.8, -4.0, -169.5)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Bush (8) (-7.3, -4.0, -171.0)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (25) (-5.5, -4.0, -150.0)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (28) (-4.5, -4.0, -151.0)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (26) (-4.5, -4.0, -150.0)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (24) (-3.3, -4.0, -149.0)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (23) (-4.5, -4.0, -149.0)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (22) (-8.3, -4.0, -138.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (21) (-7.3, -4.0, -138.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (18) (-7.3, -4.0, -137.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (20) (-8.3, -4.0, -137.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (13) (-2.0, -4.0, -137.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (17) (-1.0, -4.0, -138.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (14) (-1.0, -4.0, -137.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (16) (0.0, -4.0, -138.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (15) (0.0, -4.0, -137.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Bush (6) (-18.0, -4.0, -145.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (12) (-18.3, -4.0, -144.0)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (10) (-17.0, -4.0, -142.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (11) (-18.3, -4.0, -142.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (76) (-17.3, -4.0, -151.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (74) (-17.3, -4.0, -152.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (438) (-18.3, -4.0, -150.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (75) (-18.3, -4.0, -151.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (73) (-18.3, -4.0, -152.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (32) (-2.5, -4.0, -156.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (29) (-1.5, -4.0, -156.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (31) (-2.5, -4.0, -157.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from East Forest Grass (30) (-1.5, -4.0, -157.8)": TunicLocationData(
        "Fortress Exterior from East Forest", "Fortress Exterior from East Forest"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (44) (-26.8, -5.0, -135.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (39) (-26.8, -5.0, -134.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (38) (-26.8, -5.0, -133.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (41) (-28.8, -5.0, -134.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (37) (-27.8, -5.0, -133.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (40) (-27.8, -5.0, -134.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (43) (-27.8, -5.0, -135.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (42) (-28.8, -5.0, -135.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (49) (-21.5, -5.0, -133.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (47) (-20.5, -5.0, -134.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (48) (-21.5, -5.0, -132.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (46) (-20.5, -5.0, -133.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (45) (-20.5, -5.0, -132.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (34) (-16.8, -5.5, -126.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (27) (-17.8, -5.6, -125.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (33) (-17.8, -5.5, -126.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (19) (-16.8, -5.5, -125.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (154) (-20.0, -4.5, -118.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (155) (-19.0, -4.5, -118.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (153) (-20.0, -4.5, -117.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (152) (-19.0, -4.5, -117.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (157) (-26.0, -5.0, -116.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (156) (-26.0, -5.0, -117.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (158) (-25.0, -5.0, -117.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (160) (-26.0, -5.0, -118.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (159) (-25.0, -5.0, -118.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (58) (-24.5, -4.5, -110.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (57) (-24.5, -4.5, -109.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (56) (-24.5, -4.5, -108.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (55) (-25.5, -4.5, -108.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (54) (-25.5, -4.5, -109.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (59) (-25.5, -4.5, -110.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (53) (-26.5, -4.5, -109.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (52) (-18.5, -4.3, -109.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (50) (-18.5, -4.3, -108.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (51) (-19.5, -4.3, -108.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (67) (-14.5, 0.0, -94.3)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (63) (-15.5, 0.0, -93.3)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (66) (-13.5, 0.0, -94.3)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (64) (-14.5, 0.0, -93.3)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (69) (-16.5, 0.0, -93.3)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Bush (1) (-17.3, 0.0, -95.3)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (62) (-15.5, 0.0, -92.3)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (68) (-16.5, 0.0, -92.3)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (60) (-13.5, 0.0, -92.3)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (65) (-13.5, 0.0, -93.3)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (61) (-14.5, 0.0, -92.3)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Bush (-12.0, 0.0, -94.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Bush (3) (-7.3, 0.0, -102.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Bush (2) (-9.3, 0.0, -102.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Bush (4) (-7.3, 0.0, -104.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (72) (-5.8, 0.0, -91.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (70) (-4.8, 0.0, -90.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (71) (-5.8, 0.0, -90.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (8) (9.0, 0.0, -90.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (7) (8.0, 0.0, -90.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (9) (7.0, 0.0, -89.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (5) (9.0, 0.0, -89.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (6) (8.0, 0.0, -89.8)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Bush (5) (4.8, 0.0, -90.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (84) (1.8, 0.0, -74.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (122) (3.0, 0.0, -74.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (82) (-1.8, 0.0, -74.3)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (86) (-1.8, 0.0, -75.3)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (83) (-2.8, 0.0, -74.3)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (87) (-2.8, 0.0, -75.3)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (85) (-2.6, 0.0, -71.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (88) (-3.6, 0.0, -71.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (89) (-2.6, 0.0, -70.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Bush (11) (-15.5, 0.0, -70.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Bush (7) (-17.5, 0.0, -68.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Bush (9) (-15.5, 0.0, -68.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (164) (-26.0, 0.0, -74.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (163) (-25.0, 0.0, -74.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (168) (-24.3, 0.0, -74.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (167) (-23.3, 0.0, -74.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (162) (-25.0, 0.0, -75.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (161) (-26.0, 0.0, -75.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (166) (-23.3, 0.0, -75.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (165) (-24.3, 0.0, -75.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (102) (-26.0, 0.0, -82.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Bush (13) (-28.5, 0.0, -83.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (103) (-24.0, 0.0, -83.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (101) (-25.0, 0.0, -82.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (100) (-25.0, 0.0, -83.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (99) (-26.0, 0.0, -83.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Bush (12) (-30.5, 0.0, -85.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Bush (10) (-28.5, 0.0, -85.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (110) (-34.0, 0.0, -85.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (111) (-35.0, 0.0, -84.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (109) (-35.0, 0.0, -85.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (106) (-21.0, 0.0, -85.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (107) (-20.0, 0.0, -85.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (104) (-20.0, 0.0, -86.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (105) (-21.0, 0.0, -86.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (108) (-19.0, 0.0, -86.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (93) (-41.5, 0.0, -61.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (92) (-40.5, 0.0, -61.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (90) (-41.5, 0.0, -60.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (91) (-40.5, 0.0, -60.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (97) (-52.0, 0.0, -63.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (95) (-52.0, 0.0, -62.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (96) (-51.0, 0.0, -62.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (94) (-53.0, 0.0, -62.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (98) (-53.0, 0.0, -63.5)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (2) (11.0, 9.0, -92.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (3) (11.0, 9.0, -93.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior from Overworld Grass (4) (10.0, 9.0, -92.0)": TunicLocationData(
        "Fortress Exterior from Overworld", "Fortress Exterior from Overworld"),
    "Fortress Courtyard - Fortress Exterior near cave Grass (113) (-54.0, 0.0, -34.0)": TunicLocationData(
        "Fortress Exterior near cave", "Fortress Exterior near cave"),
    "Fortress Courtyard - Fortress Exterior near cave Grass (112) (-54.0, 0.0, -33.0)": TunicLocationData(
        "Fortress Exterior near cave", "Fortress Exterior near cave"),
    "Fortress Courtyard - Fortress Exterior near cave Grass (114) (-55.0, 0.0, -33.0)": TunicLocationData(
        "Fortress Exterior near cave", "Fortress Exterior near cave"),
    "Fortress Courtyard - Fortress Exterior near cave Grass (115) (-50.0, 0.0, -43.5)": TunicLocationData(
        "Fortress Exterior near cave", "Fortress Exterior near cave"),
    "Fortress Courtyard - Fortress Exterior near cave Grass (116) (-50.0, 0.0, -44.5)": TunicLocationData(
        "Fortress Exterior near cave", "Fortress Exterior near cave"),
    "Fortress Courtyard - Fortress Courtyard Grass (355) (-14.0, 0.0, -30.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (353) (-14.0, 0.0, -30.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (346) (-13.0, 0.0, -29.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (348) (-13.0, 0.0, -29.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (344) (-13.0, 0.0, -28.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (349) (-12.0, 0.0, -29.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (347) (-12.0, 0.0, -29.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (354) (-15.0, 0.0, -30.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (342) (-15.0, 0.0, -28.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (352) (-15.0, 0.0, -30.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (340) (-15.0, 0.0, -28.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (350) (-15.0, 0.0, -29.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (341) (-14.0, 0.0, -28.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (343) (-14.0, 0.0, -28.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (351) (-14.0, 0.0, -29.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (345) (-12.0, 0.0, -28.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (339) (-14.0, 0.0, -27.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (325) (-13.0, 0.0, -24.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (324) (-13.0, 0.0, -24.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (315) (-16.0, 0.0, -25.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (309) (-16.0, 0.0, -24.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (317) (-16.0, 0.0, -26.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (316) (-17.0, 0.0, -26.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (314) (-17.0, 0.0, -25.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (321) (-14.0, 0.0, -26.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (323) (-14.0, 0.0, -26.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (313) (-14.0, 0.0, -24.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (311) (-14.0, 0.0, -24.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (319) (-14.0, 0.0, -25.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (310) (-15.0, 0.0, -24.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (312) (-15.0, 0.0, -24.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (318) (-15.0, 0.0, -25.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (338) (-15.0, 0.0, -27.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (320) (-15.0, 0.0, -26.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (322) (-15.0, 0.0, -26.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (300) (-17.0, 0.0, -22.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (304) (-17.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (302) (-17.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (305) (-16.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (301) (-16.0, 0.0, -22.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (303) (-16.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (306) (-15.0, 0.0, -21.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (307) (-15.0, 0.0, -21.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (308) (-17.0, 0.0, -24.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (295) (-16.0, 0.0, -21.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (293) (-16.0, 0.0, -21.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (288) (-14.0, 0.0, -18.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (289) (-14.0, 0.0, -18.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (283) (-15.0, 0.0, -19.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (287) (-15.0, 0.0, -20.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (285) (-15.0, 0.0, -20.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (272) (-18.0, 0.0, -18.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (278) (-18.0, 0.0, -19.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (291) (-18.0, 0.0, -21.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (280) (-18.0, 0.0, -20.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (274) (-16.0, 0.0, -18.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (284) (-16.0, 0.0, -20.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (282) (-16.0, 0.0, -19.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (286) (-16.0, 0.0, -20.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (276) (-16.0, 0.0, -18.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (281) (-17.0, 0.0, -20.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (294) (-17.0, 0.0, -21.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (279) (-17.0, 0.0, -19.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (273) (-17.0, 0.0, -18.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (292) (-17.0, 0.0, -21.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (290) (-19.0, 0.0, -21.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (296) (-19.0, 0.0, -22.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (299) (-18.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (297) (-18.0, 0.0, -22.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (298) (-19.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (277) (-15.0, 0.0, -18.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (275) (-15.0, 0.0, -18.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (135) (-14.8, 0.0, -6.5)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (133) (-13.8, 0.0, -6.5)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (134) (-13.8, 0.0, -7.5)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (132) (-12.8, 0.0, -7.5)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (131) (-12.8, 0.0, -6.5)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (367) (-29.0, 0.0, -29.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (365) (-29.0, 0.0, -29.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (363) (-29.0, 0.0, -28.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (368) (-28.0, 0.0, -29.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (369) (-27.0, 0.0, -29.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (373) (-27.0, 0.0, -30.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (371) (-27.0, 0.0, -30.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (362) (-30.0, 0.0, -28.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (364) (-30.0, 0.0, -29.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (366) (-30.0, 0.0, -29.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (356) (-30.0, 0.0, -30.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (357) (-29.0, 0.0, -30.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (361) (-29.0, 0.0, -31.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (359) (-29.0, 0.0, -31.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (358) (-30.0, 0.0, -31.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (360) (-30.0, 0.0, -31.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (372) (-28.0, 0.0, -30.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (370) (-28.0, 0.0, -30.0)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (117) (-15.9, 2.9, -44.6)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (120) (-14.9, 3.1, -45.6)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (118) (-14.9, 3.1, -44.6)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (121) (-13.8, 3.4, -44.6)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (328) (7.0, 0.0, -26.0)": TunicLocationData("Fortress Courtyard",
                                                                                               "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (334) (4.0, 0.0, -26.0)": TunicLocationData("Fortress Courtyard",
                                                                                               "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (336) (4.0, 0.0, -27.0)": TunicLocationData("Fortress Courtyard",
                                                                                               "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (335) (5.0, 0.0, -26.0)": TunicLocationData("Fortress Courtyard",
                                                                                               "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (337) (5.0, 0.0, -27.0)": TunicLocationData("Fortress Courtyard",
                                                                                               "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (333) (6.0, 0.0, -27.0)": TunicLocationData("Fortress Courtyard",
                                                                                               "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (332) (6.0, 0.0, -26.0)": TunicLocationData("Fortress Courtyard",
                                                                                               "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (327) (9.0, 0.0, -27.0)": TunicLocationData("Fortress Courtyard",
                                                                                               "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (329) (8.0, 0.0, -26.0)": TunicLocationData("Fortress Courtyard",
                                                                                               "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (331) (8.0, 0.0, -27.0)": TunicLocationData("Fortress Courtyard",
                                                                                               "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (330) (7.0, 0.0, -27.0)": TunicLocationData("Fortress Courtyard",
                                                                                               "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (264) (12.0, 0.0, -25.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (262) (12.0, 0.0, -25.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (226) (12.0, 0.0, -26.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (249) (11.0, 0.0, -27.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (326) (9.0, 0.0, -26.0)": TunicLocationData("Fortress Courtyard",
                                                                                               "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (246) (10.0, 0.0, -26.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (248) (10.0, 0.0, -27.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (247) (11.0, 0.0, -26.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (254) (12.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (260) (12.0, 0.0, -24.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (252) (12.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (256) (10.0, 0.0, -28.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (257) (11.0, 0.0, -28.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (228) (12.0, 0.0, -27.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (236) (12.0, 0.0, -28.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (227) (13.0, 0.0, -26.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (237) (13.0, 0.0, -28.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (229) (13.0, 0.0, -27.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (261) (13.0, 0.0, -24.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (259) (11.0, 0.0, -29.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (258) (10.0, 0.0, -29.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (238) (12.0, 0.0, -29.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (239) (13.0, 0.0, -29.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (270) (16.0, 0.0, -27.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (268) (16.0, 0.0, -27.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (233) (15.0, 0.0, -27.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (245) (15.0, 0.0, -29.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (241) (15.0, 0.0, -28.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (243) (15.0, 0.0, -29.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (235) (15.0, 0.0, -27.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (244) (14.0, 0.0, -29.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (232) (14.0, 0.0, -27.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (234) (14.0, 0.0, -27.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (240) (14.0, 0.0, -28.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (242) (14.0, 0.0, -29.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (269) (17.0, 0.0, -27.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (267) (17.0, 0.0, -26.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (271) (17.0, 0.0, -27.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (266) (16.0, 0.0, -26.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (224) (16.0, 0.0, -25.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (222) (16.0, 0.0, -25.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (231) (15.0, 0.0, -26.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (219) (15.0, 0.0, -25.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (230) (14.0, 0.0, -26.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (218) (14.0, 0.0, -25.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (265) (13.0, 0.0, -25.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (263) (13.0, 0.0, -25.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (220) (16.0, 0.0, -24.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (217) (15.0, 0.0, -24.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (209) (15.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (216) (14.0, 0.0, -24.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (208) (14.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (255) (13.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (253) (13.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (207) (15.0, 0.0, -22.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (210) (16.0, 0.0, -22.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (214) (16.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (212) (16.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (198) (18.0, 0.0, -25.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (223) (17.0, 0.0, -25.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (221) (17.0, 0.0, -24.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (225) (17.0, 0.0, -25.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (196) (18.0, 0.0, -24.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (195) (21.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (193) (21.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (191) (21.0, 0.0, -22.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (194) (20.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (190) (20.0, 0.0, -22.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (200) (20.0, 0.0, -24.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (192) (20.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (183) (19.0, 0.0, -21.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (197) (19.0, 0.0, -24.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (185) (19.0, 0.0, -21.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (189) (19.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (187) (19.0, 0.0, -22.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (184) (18.0, 0.0, -21.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (186) (18.0, 0.0, -22.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (182) (18.0, 0.0, -21.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (188) (18.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (215) (17.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (213) (17.0, 0.0, -23.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (211) (17.0, 0.0, -22.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (176) (18.0, 0.0, -19.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (180) (18.0, 0.0, -20.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (174) (18.0, 0.0, -19.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (179) (17.0, 0.0, -21.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (35) (17.0, 0.0, -18.0)": TunicLocationData("Fortress Courtyard",
                                                                                               "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (171) (17.0, 0.0, -19.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (169) (17.0, 0.0, -20.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (16.0, 0.0, -18.0)": TunicLocationData("Fortress Courtyard",
                                                                                          "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (36) (16.0, 0.0, -20.0)": TunicLocationData("Fortress Courtyard",
                                                                                               "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (178) (16.0, 0.0, -21.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (170) (16.0, 0.0, -19.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (206) (14.0, 0.0, -22.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (251) (13.0, 0.0, -22.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (250) (12.0, 0.0, -22.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (199) (19.0, 0.0, -25.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (181) (19.0, 0.0, -20.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (173) (19.0, 0.0, -18.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (177) (19.0, 0.0, -19.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (175) (19.0, 0.0, -19.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (172) (18.0, 0.0, -18.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (202) (20.0, 0.0, -25.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (204) (20.0, 0.0, -25.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (201) (21.0, 0.0, -24.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (203) (21.0, 0.0, -25.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (205) (21.0, 0.0, -25.0)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (126) (26.8, 0.0, -15.8)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (127) (25.8, 0.0, -15.8)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (125) (26.8, 0.0, -14.8)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (128) (25.8, 0.0, -14.8)": TunicLocationData("Fortress Courtyard",
                                                                                                "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (119) (-21.8, 2.0, -51.3)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (130) (-20.8, 2.0, -50.3)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (129) (-20.8, 2.0, -51.3)": TunicLocationData("Fortress Courtyard",
                                                                                                 "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (124) (16.5, 0.0, -6.5)": TunicLocationData("Fortress Courtyard",
                                                                                               "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Grass (123) (17.5, 0.0, -6.5)": TunicLocationData("Fortress Courtyard",
                                                                                               "Fortress Courtyard"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (421) (32.5, 8.0, -41.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (143) (32.5, 8.0, -42.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (145) (32.5, 8.0, -43.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (419) (32.5, 8.0, -41.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (382) (36.5, 8.0, -39.5)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (384) (36.5, 8.0, -39.5)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (380) (36.5, 8.0, -38.5)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (383) (37.5, 8.0, -39.5)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (385) (37.5, 8.0, -39.5)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (381) (37.5, 8.0, -38.5)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (144) (31.5, 8.0, -43.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (142) (31.5, 8.0, -42.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (141) (37.5, 8.0, -35.5)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (375) (37.5, 8.0, -36.5)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (379) (37.5, 8.0, -37.5)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (377) (37.5, 8.0, -37.5)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (374) (36.5, 8.0, -36.5)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (376) (36.5, 8.0, -37.5)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (140) (36.5, 8.0, -35.5)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (378) (36.5, 8.0, -37.5)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (431) (35.5, 8.0, -38.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (429) (35.5, 8.0, -37.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (433) (35.5, 8.0, -38.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (432) (34.5, 8.0, -38.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (430) (34.5, 8.0, -38.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (415) (32.5, 8.0, -39.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (413) (32.5, 8.0, -39.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (408) (32.5, 8.0, -36.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (411) (32.5, 8.0, -38.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (409) (32.5, 8.0, -37.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (405) (32.5, 8.0, -35.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (407) (31.5, 8.0, -37.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (404) (31.5, 8.0, -36.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (423) (34.5, 8.0, -35.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (427) (34.5, 8.0, -36.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (428) (34.5, 8.0, -37.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (425) (34.5, 8.0, -36.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (424) (33.5, 8.0, -36.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (422) (33.5, 8.0, -35.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (426) (33.5, 8.0, -36.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (416) (31.5, 8.0, -40.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (414) (31.5, 8.0, -39.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (412) (31.5, 8.0, -39.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (410) (31.5, 8.0, -38.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (417) (32.5, 8.0, -40.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (420) (31.5, 8.0, -41.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (418) (31.5, 8.0, -41.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (138) (36.5, 8.0, -34.5)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (137) (37.5, 8.0, -34.5)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (136) (37.5, 8.0, -33.5)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (139) (36.5, 8.0, -33.5)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (406) (31.5, 8.0, -35.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (396) (36.5, 8.0, -22.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (394) (36.5, 8.0, -22.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (389) (36.5, 8.0, -20.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (398) (36.5, 8.0, -23.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (392) (36.5, 8.0, -21.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (397) (37.5, 8.0, -22.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (391) (37.5, 8.0, -20.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (395) (37.5, 8.0, -22.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (393) (37.5, 8.0, -21.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (401) (37.5, 8.0, -24.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (399) (37.5, 8.0, -23.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (436) (37.5, 8.0, -25.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (403) (37.5, 8.0, -24.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (400) (36.5, 8.0, -24.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (402) (36.5, 8.0, -24.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (437) (36.5, 8.0, -25.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (390) (37.5, 8.0, -19.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (387) (37.5, 8.0, -18.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (388) (36.5, 8.0, -18.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (386) (36.5, 8.0, -19.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (435) (37.5, 8.0, -26.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (434) (36.5, 8.0, -26.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (150) (31.8, 8.0, -9.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (146) (31.8, 8.0, -7.8)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (147) (32.8, 8.0, -7.8)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (149) (32.8, 8.0, -6.8)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (151) (32.8, 8.0, -9.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (148) (31.8, 8.0, -6.8)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Fortress Courtyard - Fortress Courtyard Upper Grass (1) (72.0, 8.0, -29.0)": TunicLocationData(
        "Fortress Courtyard Upper", "Fortress Courtyard Upper"),
    "Eastern Vault Fortress - Eastern Vault Fortress Grass (12) (-94.8, 7.0, 41.0)": TunicLocationData(
        "Eastern Vault Fortress", "Eastern Vault Fortress"),
    "Eastern Vault Fortress - Eastern Vault Fortress Grass (14) (-94.8, 7.0, 42.0)": TunicLocationData(
        "Eastern Vault Fortress", "Eastern Vault Fortress"),
    "Eastern Vault Fortress - Eastern Vault Fortress Grass (15) (-95.8, 7.0, 41.0)": TunicLocationData(
        "Eastern Vault Fortress", "Eastern Vault Fortress"),
    "Eastern Vault Fortress - Eastern Vault Fortress Grass (13) (-95.8, 7.0, 42.0)": TunicLocationData(
        "Eastern Vault Fortress", "Eastern Vault Fortress"),
    "Eastern Vault Fortress - Eastern Vault Fortress Grass (23) (-60.5, -1.0, 38.5)": TunicLocationData(
        "Eastern Vault Fortress", "Eastern Vault Fortress"),
    "Eastern Vault Fortress - Eastern Vault Fortress Grass (20) (-59.5, -1.0, 38.5)": TunicLocationData(
        "Eastern Vault Fortress", "Eastern Vault Fortress"),
    "Eastern Vault Fortress - Eastern Vault Fortress Grass (21) (-60.5, -1.0, 39.5)": TunicLocationData(
        "Eastern Vault Fortress", "Eastern Vault Fortress"),
    "Eastern Vault Fortress - Eastern Vault Fortress Grass (22) (-59.5, -1.0, 39.5)": TunicLocationData(
        "Eastern Vault Fortress", "Eastern Vault Fortress"),
    "Eastern Vault Fortress - Eastern Vault Fortress Grass (10) (-42.0, -1.0, 17.0)": TunicLocationData(
        "Eastern Vault Fortress", "Eastern Vault Fortress"),
    "Eastern Vault Fortress - Eastern Vault Fortress Grass (9) (-41.0, -1.0, 17.0)": TunicLocationData(
        "Eastern Vault Fortress", "Eastern Vault Fortress"),
    "Eastern Vault Fortress - Eastern Vault Fortress Grass (11) (-42.0, -1.0, 18.0)": TunicLocationData(
        "Eastern Vault Fortress", "Eastern Vault Fortress"),
    "Eastern Vault Fortress - Eastern Vault Fortress Grass (8) (-41.0, -1.0, 18.0)": TunicLocationData(
        "Eastern Vault Fortress", "Eastern Vault Fortress"),
    "Eastern Vault Fortress - Eastern Vault Fortress Grass (4) (-3.3, 7.0, 63.8)": TunicLocationData(
        "Eastern Vault Fortress", "Eastern Vault Fortress"),
    "Eastern Vault Fortress - Eastern Vault Fortress Grass (5) (-3.3, 7.0, 62.8)": TunicLocationData(
        "Eastern Vault Fortress", "Eastern Vault Fortress"),
    "Eastern Vault Fortress - Eastern Vault Fortress Grass (6) (-4.3, 7.0, 63.8)": TunicLocationData(
        "Eastern Vault Fortress", "Eastern Vault Fortress"),
    "Eastern Vault Fortress - Eastern Vault Fortress Grass (7) (-4.3, 7.0, 62.8)": TunicLocationData(
        "Eastern Vault Fortress", "Eastern Vault Fortress"),
    "Eastern Vault Fortress - Eastern Vault Fortress Grass (2) (6.3, 7.0, 66.3)": TunicLocationData(
        "Eastern Vault Fortress", "Eastern Vault Fortress"),
    "Eastern Vault Fortress - Eastern Vault Fortress Grass (3) (5.3, 7.0, 66.3)": TunicLocationData(
        "Eastern Vault Fortress", "Eastern Vault Fortress"),
    "Eastern Vault Fortress - Eastern Vault Fortress Grass (1) (6.3, 7.0, 67.3)": TunicLocationData(
        "Eastern Vault Fortress", "Eastern Vault Fortress"),
    "Eastern Vault Fortress - Eastern Vault Fortress Grass (5.3, 7.0, 67.3)": TunicLocationData(
        "Eastern Vault Fortress", "Eastern Vault Fortress"),
    "Fortress Grave Path - Fortress Grave Path Grass (90) (122.0, 0.0, -40.5)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (88) (121.0, 0.0, -40.5)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (89) (122.0, 0.0, -41.5)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (91) (121.0, 0.0, -41.5)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (95) (121.0, 0.0, -42.5)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (92) (121.0, 0.0, -43.5)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (93) (122.0, 0.0, -42.5)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (94) (122.0, 0.0, -43.5)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (44) (132.0, 0.0, -42.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (72) (132.0, 0.0, -45.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (85) (131.0, 0.0, -45.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (46) (133.0, 0.0, -42.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (74) (133.0, 0.0, -45.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (47) (132.0, 0.0, -41.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (56) (134.0, 0.0, -43.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (51) (134.0, 0.0, -42.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (59) (134.0, 0.0, -44.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (49) (135.0, 0.0, -42.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (48) (134.0, 0.0, -41.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (45) (133.0, 0.0, -41.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (43) (132.0, 0.0, -40.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (52) (134.0, 0.0, -40.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (41) (133.0, 0.0, -40.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (87) (130.0, 0.0, -45.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (86) (131.0, 0.0, -46.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (84) (130.0, 0.0, -46.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (83) (130.0, 0.0, -48.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (80) (130.0, 0.0, -47.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (75) (132.0, 0.0, -46.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (82) (131.0, 0.0, -47.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (81) (131.0, 0.0, -48.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (77) (133.0, 0.0, -47.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (73) (133.0, 0.0, -46.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (76) (132.0, 0.0, -48.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (79) (132.0, 0.0, -47.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (60) (134.0, 0.0, -46.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (63) (134.0, 0.0, -45.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (78) (133.0, 0.0, -48.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (62) (135.0, 0.0, -46.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (64) (136.0, 0.0, -46.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (67) (136.0, 0.0, -47.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (68) (136.0, 0.0, -45.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (61) (135.0, 0.0, -45.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (57) (135.0, 0.0, -44.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (109) (136.0, 0.0, -48.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (65) (137.0, 0.0, -47.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (66) (137.0, 0.0, -46.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (70) (137.0, 0.0, -45.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (71) (136.0, 0.0, -44.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (69) (137.0, 0.0, -44.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (58) (135.0, 0.0, -43.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (108) (137.0, 0.0, -48.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (110) (136.0, 0.0, -49.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (111) (137.0, 0.0, -49.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (112) (138.0, 0.0, -49.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (115) (138.0, 0.0, -48.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (113) (139.0, 0.0, -48.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (118) (140.0, 0.0, -50.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (119) (139.0, 0.0, -50.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (114) (139.0, 0.0, -49.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (117) (139.0, 0.0, -51.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (116) (138.0, 0.0, -51.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (120) (138.0, 0.0, -50.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (130) (143.0, 0.0, -51.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (129) (143.0, 0.0, -50.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (128) (142.0, 0.0, -50.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (131) (142.0, 0.0, -51.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (167) (141.5, 0.0, -47.5)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (121) (141.0, 0.0, -51.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (122) (141.0, 0.0, -50.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (165) (141.5, 0.0, -46.5)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (166) (140.5, 0.0, -46.5)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (123) (140.0, 0.0, -51.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (124) (144.0, 0.0, -51.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (127) (144.0, 0.0, -50.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (50) (135.0, 0.0, -41.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (54) (135.0, 0.0, -40.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (53) (135.0, 0.0, -39.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (55) (134.0, 0.0, -39.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (42) (133.0, 0.0, -39.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (35) (132.0, 0.0, -38.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (40) (132.0, 0.0, -39.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (34) (133.0, 0.0, -37.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (33) (133.0, 0.0, -38.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (17) (137.0, 0.0, -34.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (38) (133.0, 0.0, -36.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (29) (134.0, 0.0, -34.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (31) (134.0, 0.0, -35.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (26) (134.0, 0.0, -36.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (27) (135.0, 0.0, -35.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (25) (135.0, 0.0, -34.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (28) (135.0, 0.0, -33.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (30) (135.0, 0.0, -36.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (16) (136.0, 0.0, -33.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (23) (136.0, 0.0, -34.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (37) (133.0, 0.0, -35.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (36) (132.0, 0.0, -36.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (39) (132.0, 0.0, -35.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (32) (132.0, 0.0, -37.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (22) (137.0, 0.0, -33.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (24) (134.0, 0.0, -33.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (12) (139.0, 0.0, -31.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (21) (137.0, 0.0, -32.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (14) (138.0, 0.0, -32.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (15) (139.0, 0.0, -32.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (3) (139.0, 0.0, -30.0)": TunicLocationData("Fortress Grave Path",
                                                                                                 "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (2) (138.0, 0.0, -30.0)": TunicLocationData("Fortress Grave Path",
                                                                                                 "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (1) (138.0, 0.0, -29.0)": TunicLocationData("Fortress Grave Path",
                                                                                                 "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (13) (138.0, 0.0, -31.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (18) (137.0, 0.0, -31.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (20) (136.0, 0.0, -32.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (19) (136.0, 0.0, -31.0)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (139.0, 0.0, -29.0)": TunicLocationData("Fortress Grave Path",
                                                                                             "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (125) (145.0, 0.0, -50.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (126) (145.0, 0.0, -51.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (132) (146.0, 0.0, -50.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (135) (146.0, 0.0, -49.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (133) (147.0, 0.0, -50.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (137) (149.0, 0.0, -50.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (139) (148.0, 0.0, -50.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (143) (150.0, 0.0, -47.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (140) (150.0, 0.0, -48.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (145) (149.0, 0.0, -47.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (138) (149.0, 0.0, -49.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (146) (149.0, 0.0, -48.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (147) (148.0, 0.0, -48.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (136) (148.0, 0.0, -49.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (144) (148.0, 0.0, -47.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (134) (147.0, 0.0, -49.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (141) (151.0, 0.0, -47.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (142) (151.0, 0.0, -48.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (148) (151.0, 0.0, -46.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (149) (151.0, 0.0, -45.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (153) (151.0, 0.0, -41.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (152) (151.0, 0.0, -42.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (150) (151.0, 0.0, -43.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (151) (151.0, 0.0, -44.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (164) (150.0, 0.0, -43.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (169) (149.0, 0.0, -43.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (170) (149.0, 0.0, -44.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (168) (150.0, 0.0, -44.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (154) (151.0, 0.0, -39.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (155) (151.0, 0.0, -40.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (157) (151.0, 0.0, -37.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (159) (151.0, 0.0, -36.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (156) (151.0, 0.0, -38.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (162) (150.0, 0.0, -37.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (163) (150.0, 0.0, -36.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (160) (151.0, 0.0, -34.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (158) (151.0, 0.0, -35.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (161) (151.0, 0.0, -33.0)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (4) (148.5, 0.0, -31.5)": TunicLocationData("Fortress Grave Path",
                                                                                                 "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (7) (148.5, 0.0, -32.5)": TunicLocationData("Fortress Grave Path",
                                                                                                 "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (5) (147.5, 0.0, -31.5)": TunicLocationData("Fortress Grave Path",
                                                                                                 "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (6) (147.5, 0.0, -32.5)": TunicLocationData("Fortress Grave Path",
                                                                                                 "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (106) (150.5, 0.0, -31.5)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (107) (149.5, 0.0, -32.5)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (104) (149.5, 0.0, -31.5)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (99) (162.5, 0.0, -49.5)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (9) (162.5, 0.0, -50.5)": TunicLocationData("Fortress Grave Path",
                                                                                                 "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (96) (162.5, 0.0, -48.5)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (10) (162.5, 0.0, -51.5)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (11) (163.5, 0.0, -51.5)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (8) (163.5, 0.0, -50.5)": TunicLocationData("Fortress Grave Path",
                                                                                                 "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (97) (163.5, 0.0, -49.5)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (102) (163.5, 0.0, -47.5)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (98) (163.5, 0.0, -48.5)": TunicLocationData("Fortress Grave Path",
                                                                                                  "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (101) (163.5, 0.0, -46.5)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (100) (162.5, 0.0, -47.5)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Grass (103) (162.5, 0.0, -46.5)": TunicLocationData(
        "Fortress Grave Path", "Fortress Grave Path Combat"),
    "Fortress Grave Path - Fortress Grave Path Dusty Entrance Grass (172) (184.5, -1.0, -12.5)": TunicLocationData(
        "Fortress Grave", "Fortress Grave Path Dusty Entrance Region"),
    "Fortress Grave Path - Fortress Grave Path Dusty Entrance Grass (105) (185.5, -1.0, -13.5)": TunicLocationData(
        "Fortress Grave", "Fortress Grave Path Dusty Entrance Region"),
    "Fortress Grave Path - Fortress Grave Path Dusty Entrance Grass (171) (185.5, -1.0, -12.5)": TunicLocationData(
        "Fortress Grave", "Fortress Grave Path Dusty Entrance Region"),
    "Fortress Arena - Fortress Arena Grass (91) (2.0, -4.0, 26.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (90) (3.0, -4.0, 26.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (92) (2.0, -4.0, 25.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (89) (3.0, -4.0, 25.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (60) (2.0, 8.0, 155.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (61) (2.0, 8.0, 154.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (63) (3.0, 8.0, 154.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (62) (3.0, 8.0, 155.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (57) (4.0, 8.0, 154.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (53) (7.0, 8.0, 155.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (52) (7.0, 8.0, 156.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (54) (6.0, 8.0, 156.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (55) (6.0, 8.0, 155.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (59) (5.0, 8.0, 154.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (58) (5.0, 8.0, 155.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (56) (4.0, 8.0, 155.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (25) (3.0, 8.0, 172.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (24) (3.0, 8.0, 173.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (7) (4.0, 8.0, 172.0)": TunicLocationData("Fortress Arena",
                                                                                     "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (17) (4.0, 8.0, 170.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (16) (4.0, 8.0, 171.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (3) (4.0, 8.0, 173.0)": TunicLocationData("Fortress Arena",
                                                                                     "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (6) (5.0, 8.0, 172.0)": TunicLocationData("Fortress Arena",
                                                                                     "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (27) (2.0, 8.0, 172.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (26) (2.0, 8.0, 173.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (9) (6.0, 8.0, 170.0)": TunicLocationData("Fortress Arena",
                                                                                     "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (32) (6.0, 8.0, 169.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (8) (6.0, 8.0, 171.0)": TunicLocationData("Fortress Arena",
                                                                                     "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (19) (5.0, 8.0, 170.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (18) (5.0, 8.0, 171.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (12) (8.0, 8.0, 171.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (10) (7.0, 8.0, 171.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (2) (5.0, 8.0, 173.0)": TunicLocationData("Fortress Arena",
                                                                                     "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (29) (5.0, 8.0, 176.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (28) (5.0, 8.0, 177.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (1) (5.0, 8.0, 174.0)": TunicLocationData("Fortress Arena",
                                                                                     "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (5.0, 8.0, 175.0)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (35) (4.0, 8.0, 176.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (34) (4.0, 8.0, 177.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (4) (4.0, 8.0, 174.0)": TunicLocationData("Fortress Arena",
                                                                                     "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (5) (4.0, 8.0, 175.0)": TunicLocationData("Fortress Arena",
                                                                                     "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (20) (3.0, 8.0, 175.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (21) (3.0, 8.0, 174.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (22) (2.0, 8.0, 175.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (23) (2.0, 8.0, 174.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (33) (6.0, 8.0, 168.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (31) (7.0, 8.0, 168.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (11) (7.0, 8.0, 170.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (30) (7.0, 8.0, 169.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (13) (8.0, 8.0, 170.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (15) (9.0, 8.0, 170.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (14) (9.0, 8.0, 171.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (37) (11.0, 8.0, 173.0)": TunicLocationData("Fortress Arena",
                                                                                       "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (39) (12.0, 8.0, 173.0)": TunicLocationData("Fortress Arena",
                                                                                       "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (38) (12.0, 8.0, 174.0)": TunicLocationData("Fortress Arena",
                                                                                       "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (36) (11.0, 8.0, 174.0)": TunicLocationData("Fortress Arena",
                                                                                       "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (68) (5.0, 8.0, 183.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (71) (5.0, 8.0, 182.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (70) (4.0, 8.0, 183.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (69) (4.0, 8.0, 182.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (66) (3.0, 8.0, 182.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (67) (2.0, 8.0, 182.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (75) (5.0, 8.0, 184.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (65) (3.0, 8.0, 183.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (64) (2.0, 8.0, 183.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (72) (5.0, 8.0, 185.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (74) (4.0, 8.0, 185.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (73) (4.0, 8.0, 184.0)": TunicLocationData("Fortress Arena",
                                                                                      "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (78) (-3.0, 8.0, 187.0)": TunicLocationData("Fortress Arena",
                                                                                       "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (77) (-3.0, 8.0, 186.0)": TunicLocationData("Fortress Arena",
                                                                                       "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (85) (-4.0, 8.0, 184.0)": TunicLocationData("Fortress Arena",
                                                                                       "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (86) (-4.0, 8.0, 185.0)": TunicLocationData("Fortress Arena",
                                                                                       "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (83) (-3.0, 8.0, 184.0)": TunicLocationData("Fortress Arena",
                                                                                       "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (80) (-3.0, 8.0, 185.0)": TunicLocationData("Fortress Arena",
                                                                                       "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (79) (-2.0, 8.0, 186.0)": TunicLocationData("Fortress Arena",
                                                                                       "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (82) (-2.0, 8.0, 185.0)": TunicLocationData("Fortress Arena",
                                                                                       "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (81) (-2.0, 8.0, 184.0)": TunicLocationData("Fortress Arena",
                                                                                       "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (76) (-2.0, 8.0, 187.0)": TunicLocationData("Fortress Arena",
                                                                                       "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (84) (-5.0, 8.0, 185.0)": TunicLocationData("Fortress Arena",
                                                                                       "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (87) (-5.0, 8.0, 184.0)": TunicLocationData("Fortress Arena",
                                                                                       "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (50) (-14.0, 8.0, 173.0)": TunicLocationData("Fortress Arena",
                                                                                        "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (48) (-13.0, 8.0, 173.0)": TunicLocationData("Fortress Arena",
                                                                                        "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (40) (-12.0, 8.0, 173.0)": TunicLocationData("Fortress Arena",
                                                                                        "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (44) (-12.0, 8.0, 175.0)": TunicLocationData("Fortress Arena",
                                                                                        "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (45) (-12.0, 8.0, 174.0)": TunicLocationData("Fortress Arena",
                                                                                        "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (47) (-11.0, 8.0, 174.0)": TunicLocationData("Fortress Arena",
                                                                                        "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (42) (-11.0, 8.0, 173.0)": TunicLocationData("Fortress Arena",
                                                                                        "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (46) (-11.0, 8.0, 175.0)": TunicLocationData("Fortress Arena",
                                                                                        "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (49) (-13.0, 8.0, 172.0)": TunicLocationData("Fortress Arena",
                                                                                        "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (51) (-14.0, 8.0, 172.0)": TunicLocationData("Fortress Arena",
                                                                                        "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (43) (-11.0, 8.0, 172.0)": TunicLocationData("Fortress Arena",
                                                                                        "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (41) (-12.0, 8.0, 172.0)": TunicLocationData("Fortress Arena",
                                                                                        "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-12.4, 8.0, 190.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-11.4, 8.0, 190.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-11.4, 8.0, 191.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-12.4, 8.0, 191.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-12.4, 8.0, 192.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-11.4, 8.0, 192.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-12.4, 8.0, 193.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-11.4, 8.0, 193.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-14.4, 8.0, 194.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-14.4, 8.0, 192.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-14.4, 8.0, 193.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-14.4, 8.0, 195.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-13.4, 8.0, 195.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-13.4, 8.0, 193.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-13.4, 8.0, 192.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-13.4, 8.0, 194.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-2.8, 8.0, 194.5)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-3.8, 8.0, 194.5)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-2.8, 8.0, 195.5)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-3.8, 8.0, 195.5)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-2.8, 8.0, 199.5)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-4.8, 8.0, 200.5)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-3.8, 8.0, 199.5)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-3.8, 8.0, 200.5)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-2.8, 8.0, 200.5)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-1.8, 8.0, 200.5)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-1.8, 8.0, 199.5)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-0.8, 8.0, 199.5)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-3.8, 8.0, 202.5)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-3.8, 8.0, 201.5)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-4.8, 8.0, 202.5)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-4.8, 8.0, 201.5)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (-0.8, 8.0, 200.5)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (4.6, 8.0, 196.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (1.6, 8.0, 198.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (3.6, 8.0, 196.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (3.6, 8.0, 197.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (4.6, 8.0, 199.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (4.6, 8.0, 198.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (3.6, 8.0, 198.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (3.6, 8.0, 199.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (2.6, 8.0, 199.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (2.6, 8.0, 198.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (1.6, 8.0, 199.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (4.6, 8.0, 197.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (5.6, 8.0, 194.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (6.6, 8.0, 194.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (8.6, 8.0, 194.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (8.6, 8.0, 193.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (9.6, 8.0, 194.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (9.6, 8.0, 193.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (6.6, 8.0, 193.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (9.6, 8.0, 191.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (9.6, 8.0, 192.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (10.6, 8.0, 191.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (10.6, 8.0, 192.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (11.6, 8.0, 194.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (11.6, 8.0, 193.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (10.6, 8.0, 193.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (10.6, 8.0, 194.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (13.6, 8.0, 190.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (13.6, 8.0, 191.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (14.6, 8.0, 191.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (14.6, 8.0, 190.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (15.6, 8.0, 189.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (15.6, 8.0, 190.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (16.6, 8.0, 190.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (16.6, 8.0, 189.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (21.6, 8.0, 189.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (21.6, 8.0, 188.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (22.6, 8.0, 189.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (22.6, 8.0, 188.4)": TunicLocationData("Fortress Arena", "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (94) (-13.0, 8.0, 223.8)": TunicLocationData("Fortress Arena",
                                                                                        "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (96) (-12.0, 8.0, 224.8)": TunicLocationData("Fortress Arena",
                                                                                        "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (99) (-12.0, 8.0, 223.8)": TunicLocationData("Fortress Arena",
                                                                                        "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (97) (-11.0, 8.0, 223.8)": TunicLocationData("Fortress Arena",
                                                                                        "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (98) (-11.0, 8.0, 224.8)": TunicLocationData("Fortress Arena",
                                                                                        "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (103) (-12.0, 8.0, 225.8)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (100) (-12.0, 8.0, 226.8)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (101) (-11.0, 8.0, 225.8)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (102) (-11.0, 8.0, 226.8)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (88) (-14.0, 8.0, 223.8)": TunicLocationData("Fortress Arena",
                                                                                        "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (93) (-13.0, 8.0, 222.8)": TunicLocationData("Fortress Arena",
                                                                                        "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (95) (-14.0, 8.0, 222.8)": TunicLocationData("Fortress Arena",
                                                                                        "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (117) (-38.5, 8.0, 218.3)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (120) (-38.5, 8.0, 217.3)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (116) (-38.5, 8.0, 219.3)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (121) (-38.5, 8.0, 216.3)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (118) (-39.5, 8.0, 219.3)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (122) (-39.5, 8.0, 217.3)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (119) (-39.5, 8.0, 218.3)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (123) (-39.5, 8.0, 216.3)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (108) (-33.3, 8.0, 208.8)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (112) (-35.3, 8.0, 209.8)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (114) (-36.3, 8.0, 209.8)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (113) (-35.3, 8.0, 208.8)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (115) (-36.3, 8.0, 208.8)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (109) (-33.3, 8.0, 207.8)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (107) (-34.3, 8.0, 205.8)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (110) (-34.3, 8.0, 208.8)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (111) (-34.3, 8.0, 207.8)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (106) (-34.3, 8.0, 206.8)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (105) (-33.3, 8.0, 205.8)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Fortress Arena - Fortress Arena Grass (104) (-33.3, 8.0, 206.8)": TunicLocationData("Fortress Arena",
                                                                                         "Fortress Arena"),
    "Quarry - Quarry Back Grass (26) (-50.3, 31.8, 74.3)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (27) (-49.3, 31.8, 74.3)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (20) (-50.3, 31.8, 75.3)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (21) (-49.3, 31.8, 75.3)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (22) (-50.3, 31.8, 76.3)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (23) (-49.3, 31.8, 76.3)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (13) (-44.0, 28.0, 59.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (14) (-45.0, 28.0, 60.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (12) (-45.0, 28.0, 59.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (15) (-44.0, 28.0, 60.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (6) (-40.0, 28.0, 59.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (7) (-39.0, 28.0, 59.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (11) (-37.0, 28.0, 58.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (9) (-37.0, 28.0, 57.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (4) (-40.0, 28.0, 60.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (5) (-39.0, 28.0, 60.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (2) (-38.0, 28.0, 59.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (8) (-38.0, 28.0, 57.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (10) (-38.0, 28.0, 58.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (3) (-37.0, 28.0, 59.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (-37.0, 28.0, 60.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (1) (-38.0, 28.0, 60.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (17) (-23.3, 28.0, 55.5)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (16) (-24.3, 28.0, 55.5)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (18) (-24.3, 28.0, 56.5)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (19) (-23.3, 28.0, 56.5)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (29) (-57.5, -4.5, 16.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (38) (-56.5, -4.0, 16.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (34) (-56.5, -4.0, 16.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (28) (-57.5, -4.5, 15.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (24) (-58.5, -4.5, 15.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (25) (-58.5, -4.5, 16.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (37) (-55.5, -4.0, 16.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (41) (-55.5, -4.0, 16.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (40) (-56.5, -4.0, 15.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (36) (-56.5, -4.0, 15.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (39) (-55.5, -4.0, 15.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (35) (-55.5, -4.0, 15.0)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (32) (-57.5, -12.0, 11.5)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (30) (-57.5, -12.0, 10.5)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (33) (-56.5, -12.0, 10.5)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (31) (-56.5, -12.0, 11.5)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (44) (-51.0, -12.0, 11.5)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (43) (-49.5, -12.0, 11.5)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (47) (-49.5, -12.0, 12.5)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (49) (-52.0, -12.0, 12.5)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (48) (-51.0, -12.0, 12.5)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (50) (-52.0, -12.0, 13.5)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (46) (-48.5, -12.0, 11.5)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (45) (-48.5, -12.0, 12.5)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Quarry - Quarry Back Grass (42) (-50.3, -12.0, 13.5)": TunicLocationData("Quarry Back", "Quarry Back"),
    "Swamp - Swamp Front Grass swamp (36) (-100.0, -0.3, -10.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (37) (-100.0, -0.5, -9.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (35) (-99.0, -0.5, -9.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (38) (-99.0, -0.8, -10.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (40) (-88.3, 0.3, -18.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (41) (-87.3, -0.3, -19.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (34) (-87.3, 0.5, -18.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (31) (-89.5, -0.3, -10.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (32) (-89.5, -0.5, -9.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (33) (-88.5, -0.8, -10.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (30) (-88.5, -0.5, -9.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (39) (-88.3, 0.5, -19.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (27) (-82.3, 0.3, -14.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (28) (-82.3, 0.3, -13.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (29) (-81.3, -0.5, -14.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (26) (-81.3, -0.3, -13.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (24) (-80.3, 0.3, -12.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (23) (-80.3, 0.3, -13.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (22) (-79.3, -0.3, -12.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (25) (-79.3, -0.5, -13.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (56) (-83.3, 0.3, -21.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (54) (-82.3, 0.5, -21.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (57) (-82.3, -1.0, -22.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (55) (-83.3, 0.0, -22.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (43) (-77.3, -1.3, -6.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (45) (-76.3, -1.8, -6.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (42) (-76.3, -1.5, -5.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (44) (-77.3, -1.3, -5.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (19) (-73.5, 0.3, -18.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (21) (-72.5, 0.5, -18.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (18) (-72.5, -0.3, -17.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (20) (-73.5, 0.3, -17.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (15) (-61.8, 0.3, -22.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (16) (-61.8, 0.3, -21.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (17) (-60.8, -0.5, -22.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (14) (-60.8, -0.3, -21.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (60) (-64.0, -1.0, -27.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (58) (-63.0, -1.0, -27.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (61) (-63.0, -1.3, -28.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (59) (-64.0, -1.5, -28.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (63) (-62.0, -0.5, -29.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (64) (-62.0, -0.5, -28.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (449) (-58.5, -0.8, -16.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (451) (-57.5, -0.8, -16.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (448) (-57.5, -1.0, -15.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (450) (-58.5, -0.8, -15.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (445) (-51.5, 0.0, -9.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (447) (-50.5, -0.3, -9.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (446) (-51.5, 0.0, -8.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (444) (-50.5, -0.5, -8.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (432) (-55.8, -0.5, -2.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (430) (-56.8, -0.5, -2.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (431) (-56.8, -0.5, -1.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (429) (-55.8, -0.8, -1.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (437) (-60.8, -0.3, -2.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (439) (-61.8, 0.0, -2.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (438) (-61.8, 0.0, -3.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (436) (-62.8, -0.3, -4.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (433) (-62.8, -0.5, -3.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (434) (-63.8, -0.3, -4.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (435) (-63.8, -0.3, -3.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (48) (-61.0, -1.0, -8.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (47) (-61.0, -1.3, -9.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (46) (-60.0, -1.3, -8.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (441) (-61.0, -0.3, 5.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (443) (-60.0, -0.3, 5.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (440) (-60.0, -0.5, 6.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (442) (-61.0, -0.3, 6.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (204) (-70.0, -0.3, 11.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (206) (-69.0, -0.3, 11.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (207) (-69.3, -0.3, 12.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (212) (-70.3, 0.0, 12.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (183) (-70.0, -1.3, 7.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (185) (-71.0, -1.0, 8.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (187) (-72.0, -1.0, 8.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (175) (-72.5, 0.5, 13.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (176) (-72.5, 0.5, 14.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (181) (-69.0, -1.3, 7.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (174) (-71.5, 0.5, 14.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (172) (-71.5, 0.0, 13.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (186) (-72.0, -1.3, 7.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (180) (-69.0, -1.5, 6.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (182) (-70.0, -1.5, 6.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (184) (-71.0, -1.3, 7.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (266) (-77.8, -1.3, 11.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (267) (-78.0, -1.3, 12.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (268) (-78.5, -1.3, 12.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (265) (-78.8, -1.5, 11.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (165) (-84.0, -0.5, 5.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (167) (-84.0, 0.0, 4.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (166) (-83.0, -0.5, 5.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (56) (-83.0, -0.5, 4.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (169) (-75.3, -0.8, 21.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (171) (-75.3, -0.3, 20.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (168) (-74.3, -0.8, 20.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (170) (-74.3, -0.8, 21.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (199) (-73.8, -0.3, 24.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (196) (-72.8, -0.8, 24.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (197) (-73.8, -0.8, 25.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (198) (-72.8, -0.8, 25.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (200) (-78.3, -1.0, 27.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (203) (-79.3, -0.5, 27.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (201) (-79.3, -0.8, 28.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (202) (-78.3, -0.5, 28.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (192) (-64.3, -0.5, 25.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (194) (-64.3, -0.3, 26.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (205) (-66.3, -0.3, 26.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (211) (-65.3, -0.3, 25.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (195) (-65.3, -0.3, 25.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (193) (-65.3, -0.3, 26.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (209) (-66.3, -0.3, 27.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (208) (-67.3, -0.3, 27.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (210) (-67.3, -0.3, 26.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (178) (-62.3, -0.3, 13.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (179) (-62.3, -0.3, 14.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (177) (-61.3, -0.3, 14.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (173) (-61.3, -0.3, 13.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (191) (-59.0, -0.3, 20.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (188) (-58.0, -0.8, 20.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (190) (-58.0, -0.8, 21.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (189) (-59.0, -0.8, 21.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (52) (-58.0, 0.0, -35.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (50) (-57.0, -0.3, -35.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (51) (-58.0, -0.3, -36.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (7) (-54.3, -1.3, -38.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (53) (-57.0, -0.8, -36.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (10) (-53.5, 0.0, -30.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (13) (-52.5, -0.5, -31.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (11) (-53.5, 0.0, -29.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (9) (-52.5, -0.3, -29.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (12) (-52.5, -0.5, -30.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (5) (-53.3, -1.5, -38.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (4) (-51.0, -1.5, -37.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1) (-51.0, -1.0, -36.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (8) (-53.3, -2.0, -39.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (6) (-54.3, -1.8, -39.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (3) (-50.0, -1.8, -37.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (2) (-50.0, -1.3, -36.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (272) (-46.5, -1.0, -11.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (271) (-46.5, -1.0, -12.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (270) (-45.5, -1.0, -11.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (269) (-45.5, -1.3, -12.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (273) (-44.5, -1.5, -13.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (275) (-43.5, -1.5, -12.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (274) (-43.5, -1.5, -13.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (276) (-44.5, -1.5, -12.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (284) (-36.5, -0.8, -5.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (281) (-36.5, -1.0, -7.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (283) (-35.5, -0.8, -5.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (282) (-35.5, -1.0, -7.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (280) (-35.3, -1.3, -8.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (278) (-34.3, -1.3, -9.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (279) (-34.3, -1.3, -8.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (277) (-35.3, -1.3, -9.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (234) (-21.0, -0.5, -14.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (236) (-21.0, -0.5, -15.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (235) (-20.0, -0.5, -14.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (233) (-20.0, -0.5, -15.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (307) (-24.0, -0.5, -22.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (341) (-24.0, -0.5, -21.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (344) (-22.0, -0.5, -22.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (345) (-21.0, -0.5, -22.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (308) (-25.0, -0.5, -21.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (342) (-25.0, -0.5, -22.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (343) (-21.0, -0.5, -23.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (346) (-22.0, -0.5, -23.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (108) (-12.5, -2.0, -19.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (110) (-12.5, -1.8, -20.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (107) (-11.5, -1.8, -20.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (109) (-11.5, -2.0, -19.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (350) (-12.5, -0.5, -28.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (348) (-12.5, -0.3, -27.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (349) (-11.5, -0.3, -27.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (347) (-11.5, -0.5, -28.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (78) (-6.3, 0.0, -21.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (80) (-6.3, 0.0, -22.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (79) (-5.3, 0.0, -21.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (77) (-5.3, 0.0, -22.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (76) (-5.3, 0.0, -20.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (73) (-4.3, 0.0, -20.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (75) (-4.3, 0.0, -19.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (74) (-5.3, 0.0, -19.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (238) (-3.3, -1.0, -31.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (239) (-2.3, -1.0, -31.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (240) (-3.3, -1.3, -32.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (243) (-3.3, -1.5, -33.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (237) (-2.3, -1.3, -32.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (242) (-4.3, -1.5, -33.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (241) (-3.3, -1.8, -34.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (244) (-4.3, -1.8, -34.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (21) (4.3, -2.0, -18.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (24) (3.3, -2.0, -18.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (23) (4.3, -1.8, -17.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (22) (3.3, -1.8, -17.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (69) (2.8, -0.3, -14.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (28) (8.5, -1.8, -17.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (26) (8.5, -1.5, -16.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (25) (9.5, -1.8, -17.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (32) (9.5, -1.3, -15.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (27) (9.5, -1.5, -16.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (35) (12.5, -1.3, -15.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (33) (12.5, -1.5, -16.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (36) (11.5, -1.5, -16.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (34) (11.5, -1.3, -15.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (29) (10.5, -1.3, -15.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (31) (10.5, -1.0, -14.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (30) (9.5, -1.0, -14.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (112) (15.3, 0.3, -4.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (114) (15.3, 0.3, -5.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (111) (16.3, 0.3, -5.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (113) (16.3, 0.3, -4.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (118) (19.5, 0.0, -5.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (116) (19.5, 0.0, -4.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (38) (14.0, 0.0, -10.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (37) (15.0, 0.0, -11.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (39) (15.0, 0.0, -10.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (40) (14.0, 0.0, -11.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (115) (20.5, 0.0, -5.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (117) (20.5, 0.0, -4.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (123) (21.8, 0.0, -9.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (124) (21.8, 0.0, -8.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (381) (21.8, 0.0, -17.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (379) (21.8, 0.0, -18.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (376) (19.8, 0.0, -27.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (378) (19.8, -0.3, -28.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (375) (20.8, 0.0, -28.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (377) (20.8, 0.0, -27.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (372) (16.0, -1.3, -32.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (373) (17.0, -1.3, -32.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (367) (17.0, -1.3, -33.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (374) (16.0, -1.5, -33.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (6.3, 0.0, -4.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1) (6.3, 0.0, -5.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (4) (5.3, 0.0, -5.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (2) (5.3, 0.0, -5.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (3) (5.3, 0.0, -4.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (62) (-2.3, 0.0, -10.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (63) (-1.3, 0.0, -10.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (61) (-1.3, 0.0, -11.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (64) (-2.3, 0.0, -11.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (68) (-0.3, 0.0, -11.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (66) (-0.3, 0.0, -10.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (67) (0.8, 0.0, -10.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (65) (0.8, 0.0, -11.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (70) (1.8, 0.0, -13.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (72) (1.8, 0.0, -14.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (71) (2.8, -0.3, -13.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (59) (-4.5, 0.0, -5.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (57) (-4.5, 0.0, -6.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (58) (-5.5, 0.0, -5.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (60) (-5.5, 0.0, -6.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (53) (-6.5, 0.0, -5.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (55) (-6.5, 0.0, -4.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (54) (-7.5, 0.0, -4.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (47) (-10.8, 0.0, 2.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (48) (-11.8, 0.0, 1.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (46) (-11.8, 0.0, 2.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (45) (-10.8, 0.0, 1.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (16) (-7.3, 0.0, 4.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (13) (-6.3, 0.0, 4.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (15) (-6.3, 0.0, 5.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (14) (-7.3, 0.0, 5.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (17) (-8.5, 0.0, 8.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (49) (-11.8, 0.0, 3.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (51) (-11.8, 0.0, 4.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (52) (-12.8, 0.0, 3.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (50) (-12.8, 0.0, 4.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (20) (-9.5, 0.0, 8.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (19) (-8.5, 0.0, 9.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (18) (-9.5, 0.0, 9.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (12) (-2.5, 0.0, 10.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (44) (-1.5, 0.0, 8.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (42) (-1.5, 0.0, 9.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (41) (-0.5, 0.0, 8.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (43) (-0.5, 0.0, 9.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (9) (-3.5, 0.0, 10.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (7) (1.5, 0.0, 10.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (5) (1.5, 0.0, 9.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (6) (0.5, 0.0, 10.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (8) (0.5, 0.0, 9.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (10) (-2.5, 0.0, 11.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (11) (-3.5, 0.0, 11.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (82) (13.8, 0.0, 5.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (91) (14.8, 0.0, 7.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (81) (14.8, 0.0, 4.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (84) (14.8, 0.0, 5.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (83) (13.8, 0.0, 4.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (88) (16.8, 0.0, 6.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (85) (16.8, 0.0, 5.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (87) (15.8, 0.0, 5.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (86) (15.8, 0.0, 6.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (92) (15.8, 0.0, 8.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (89) (15.8, 0.0, 7.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (90) (14.8, 0.0, 8.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (101) (19.5, 0.0, 5.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (98) (20.5, 0.0, 5.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (99) (19.5, 0.0, 6.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (102) (20.5, 0.0, 6.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (97) (21.5, 0.0, 8.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (100) (21.5, 0.0, 9.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (93) (21.5, 0.0, 10.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (95) (20.5, 0.0, 10.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (94) (20.5, 0.0, 11.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (96) (21.5, 0.0, 11.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (135) (20.8, 0.0, 26.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (138) (21.8, 0.0, 26.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (136) (21.8, 0.0, 27.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (137) (20.8, 0.0, 27.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (140) (15.5, 0.0, 26.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (141) (14.5, 0.0, 26.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (142) (15.5, 0.0, 25.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (139) (14.5, 0.0, 25.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (718) (21.0, -0.5, 30.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (719) (21.0, -0.5, 31.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (721) (22.0, -0.5, 30.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (720) (22.0, -0.5, 31.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (717) (22.0, -0.5, 32.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (714) (21.0, -0.5, 32.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (716) (22.0, -0.5, 33.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (715) (21.0, -0.5, 33.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (705) (15.8, -0.5, 43.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (704) (15.8, -0.5, 44.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (702) (14.8, -0.5, 43.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (703) (14.8, -0.5, 44.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (708) (13.8, -0.5, 44.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (709) (13.8, -0.5, 43.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (707) (12.8, -0.5, 44.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (706) (12.8, -0.5, 43.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (134) (6.5, -0.5, 34.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (132) (6.5, -0.5, 35.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (133) (5.5, -0.5, 35.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (131) (5.5, -0.5, 34.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (149) (2.1, -0.9, 33.4)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (148) (3.1, -0.9, 33.4)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (150) (3.1, -1.1, 32.4)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (147) (2.1, -1.1, 32.4)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (130) (5.3, -1.0, 31.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (126) (6.3, -1.3, 30.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (129) (6.3, -1.0, 31.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (127) (5.3, -1.3, 30.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (125) (5.3, -1.8, 29.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (128) (6.3, -1.8, 29.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (151) (4.4, -0.5, 42.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (158) (2.5, -0.5, 44.4)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (156) (2.5, -0.5, 45.4)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (153) (4.4, -0.5, 43.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (152) (5.4, -0.5, 43.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (161) (-0.4, -0.5, 45.4)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (157) (1.5, -0.5, 45.4)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (155) (1.5, -0.5, 44.4)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (160) (0.6, -0.5, 45.4)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (154) (5.4, -0.5, 42.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (162) (-5.6, -0.5, 38.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (164) (-5.6, -0.5, 37.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (159) (-6.6, -0.5, 37.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (163) (-6.6, -0.5, 38.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (146) (-2.3, -1.6, 31.4)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (145) (-1.3, -0.9, 32.4)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (144) (-2.3, -1.6, 32.4)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (143) (-1.3, -1.6, 31.4)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (120) (1.5, -1.8, 21.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (121) (2.5, -1.8, 21.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (122) (1.5, -1.8, 20.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (119) (2.5, -1.8, 20.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (411) (-18.8, -0.8, 16.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (409) (-18.8, -0.3, 17.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (405) (-17.8, -0.3, 15.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (410) (-19.8, -0.3, 17.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (412) (-19.8, -0.5, 16.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (406) (-18.8, -0.3, 15.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (408) (-18.8, -0.5, 14.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (407) (-17.8, -0.8, 14.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (415) (-22.0, -0.8, 17.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (413) (-22.0, -0.3, 18.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (414) (-23.0, -0.3, 18.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (416) (-23.0, -0.5, 17.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (400) (-24.5, -0.5, 22.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (398) (-24.5, -0.3, 23.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (399) (-23.5, -0.8, 22.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (397) (-23.5, -0.3, 23.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (401) (-25.5, -0.8, 15.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (402) (-26.5, -0.8, 15.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (403) (-25.5, -1.3, 14.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (404) (-26.5, -1.3, 14.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (393) (-31.8, -1.0, 22.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (395) (-31.8, -1.5, 21.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (396) (-32.8, -1.8, 21.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (394) (-32.8, -1.5, 22.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (389) (-30.3, -0.3, 32.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (391) (-30.3, -0.3, 31.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (452) (-31.3, -0.3, 30.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (454) (-31.3, -0.3, 29.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (390) (-31.3, -0.5, 32.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (392) (-31.3, -0.5, 31.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (453) (-32.3, -0.3, 30.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (455) (-32.3, -0.5, 29.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (458) (-34.8, -1.0, 32.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (456) (-34.8, -1.3, 33.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (457) (-35.8, -1.3, 33.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (459) (-35.8, -1.3, 32.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (461) (-44.0, -0.3, 26.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (460) (-43.0, -0.3, 26.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (463) (-44.0, -0.8, 25.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (462) (-43.0, -0.3, 25.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (224) (-42.5, -1.0, 42.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (221) (-42.5, -0.5, 43.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (223) (-41.5, -0.3, 43.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (222) (-41.5, -0.8, 42.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (326) (-43.5, -1.3, 47.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (327) (-43.5, -1.0, 48.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (328) (-44.5, -1.3, 47.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (325) (-44.5, -0.8, 48.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (228) (-29.3, -0.5, 44.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (226) (-28.3, -0.8, 44.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (225) (-29.3, -0.8, 45.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (227) (-28.3, -0.8, 45.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (388) (-27.8, -0.5, 37.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (387) (-27.8, -0.3, 38.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (386) (-26.8, -0.5, 38.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (385) (-26.8, -0.8, 37.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (230) (-22.5, -1.0, 41.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (231) (-22.5, -0.5, 42.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (232) (-23.5, -0.8, 41.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (229) (-23.5, -0.3, 42.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (422) (-18.3, -0.8, 45.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (421) (-18.3, -1.3, 44.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (424) (-19.3, -0.5, 44.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (423) (-19.3, 0.0, 45.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (219) (-41.0, -1.5, 14.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (217) (-42.0, -1.5, 14.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (220) (-42.0, -1.5, 13.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (218) (-41.0, -2.0, 13.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (215) (-48.5, -1.8, 18.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (213) (-49.5, -1.8, 18.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (216) (-49.5, -1.8, 17.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (214) (-48.5, -2.3, 17.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (286) (-51.0, -1.8, 24.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (292) (-51.0, -1.8, 23.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (289) (-50.0, -1.8, 24.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (287) (-50.0, -2.3, 23.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (320) (-53.0, -1.8, 24.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (318) (-52.0, -2.3, 24.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (317) (-53.0, -1.8, 25.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (319) (-52.0, -1.8, 25.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (338) (-51.0, -0.5, 38.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (337) (-52.0, 0.3, 39.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (339) (-51.0, 0.0, 39.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (340) (-52.0, -0.5, 38.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (330) (-48.0, -0.8, 45.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (332) (-49.0, -0.8, 45.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (334) (-50.0, -0.5, 44.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (333) (-51.0, 0.0, 45.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (336) (-51.0, -0.5, 44.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (335) (-50.0, -0.3, 45.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (329) (-49.0, -0.3, 46.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (331) (-48.0, -0.5, 46.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (104) (-11.3, -1.5, -10.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (106) (-11.3, -1.8, -11.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (103) (-10.3, -1.8, -11.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (105) (-10.3, -1.5, -10.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (248) (0.3, 0.0, -44.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (245) (1.3, 0.0, -44.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (247) (1.3, -0.3, -43.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (249) (-0.8, -0.3, -45.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (251) (-0.8, 0.0, -44.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (252) (-1.8, -0.3, -45.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (250) (-1.8, 0.3, -44.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (365) (1.3, -0.5, -49.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (366) (0.3, -0.5, -50.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (364) (0.3, 0.0, -49.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (246) (0.3, 0.0, -43.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (254) (-7.3, -0.5, -49.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (253) (-6.3, -0.8, -50.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (255) (-6.3, -0.5, -49.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (256) (-7.3, -1.0, -50.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (257) (-1.5, -1.8, -60.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (258) (-1.5, -1.8, -61.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (259) (-0.5, -1.8, -60.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (260) (-0.5, -1.5, -61.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (261) (-5.0, -0.5, -66.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (262) (-5.0, -0.5, -67.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (263) (-4.0, -0.5, -66.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (264) (-4.0, -0.3, -67.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (467) (10.8, -0.5, -55.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (465) (10.8, -0.3, -54.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (359) (11.0, -1.0, -61.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (358) (12.0, -0.5, -61.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (357) (12.0, -0.8, -62.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (466) (11.8, -0.5, -54.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (464) (11.8, -0.5, -55.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (362) (10.0, -1.3, -62.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (361) (10.0, -1.5, -63.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (356) (11.0, -1.0, -62.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (363) (9.0, -1.8, -62.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (360) (9.0, -1.8, -63.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (368) (13.0, -1.5, -66.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (371) (13.0, -1.5, -65.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (370) (14.0, -1.0, -65.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (369) (14.0, -1.3, -66.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (354) (21.0, 0.0, -66.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (355) (22.0, 0.0, -65.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (353) (22.0, 0.0, -66.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (382) (21.2, -0.2, -63.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (383) (21.2, -0.5, -62.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (380) (20.2, -0.7, -63.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (384) (20.2, -0.5, -62.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (351) (21.0, 0.0, -67.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (352) (22.0, 0.0, -67.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (316) (20.8, -0.3, -72.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (313) (20.8, -0.6, -73.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (315) (21.8, -0.3, -72.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (314) (21.8, -0.6, -73.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (545) (34.8, 0.0, -92.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (546) (34.8, -0.5, -93.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (542) (35.8, -0.5, -93.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (543) (35.8, -0.3, -92.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (571) (30.8, 0.0, -88.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (572) (30.8, 0.0, -87.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (574) (29.8, 0.0, -88.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (573) (29.8, 0.3, -87.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (541) (27.5, -0.3, -88.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (544) (26.5, -0.5, -88.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (529) (25.5, -0.8, -88.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (530) (25.5, -0.8, -87.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (531) (24.5, -0.5, -87.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (532) (24.5, -0.8, -88.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (538) (27.5, -0.3, -89.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (539) (26.5, -0.3, -89.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (533) (25.5, -0.8, -90.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (534) (25.5, -0.8, -89.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (535) (24.5, -0.5, -89.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (540) (26.5, -0.5, -90.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (537) (27.5, -0.3, -90.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (536) (24.5, -0.8, -90.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (578) (33.3, 0.0, -80.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (575) (34.3, 0.0, -80.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (570) (34.3, 0.0, -82.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (569) (34.3, 0.3, -81.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (567) (35.3, 0.0, -82.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (568) (35.3, 0.0, -81.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (576) (34.3, 0.0, -79.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (577) (33.3, 0.3, -79.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (549) (27.5, 0.3, -81.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (548) (28.5, 0.0, -81.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (547) (28.5, 0.0, -82.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (550) (27.5, 0.0, -82.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (525) (25.8, 0.0, -79.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (521) (26.8, 0.0, -77.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (524) (25.8, 0.0, -77.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (523) (25.8, 0.3, -76.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (522) (26.8, 0.0, -76.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (526) (25.8, 0.0, -78.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (527) (24.8, 0.3, -78.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (528) (24.8, 0.0, -79.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (579) (34.0, 0.0, -74.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (580) (34.0, 0.0, -73.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (581) (33.0, 0.3, -73.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (582) (33.0, 0.0, -74.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (520) (31.0, 0.0, -70.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (517) (32.0, 0.0, -70.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (518) (32.0, 0.0, -69.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (497) (27.0, 0.0, -71.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (555) (33.5, 0.0, -67.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (556) (33.5, 0.0, -66.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (561) (34.5, 0.3, -67.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (562) (34.5, 0.0, -68.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (559) (35.5, 0.0, -68.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (560) (35.5, 0.0, -67.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (516) (30.0, 0.0, -66.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (510) (29.0, 0.0, -66.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (509) (29.0, 0.0, -67.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (558) (32.5, 0.0, -67.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (519) (31.0, 0.3, -69.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (514) (31.0, 0.0, -65.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (513) (31.0, 0.0, -66.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (505) (29.0, 0.0, -69.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (506) (29.0, 0.0, -68.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (512) (28.0, 0.0, -67.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (507) (28.0, 0.3, -68.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (508) (28.0, 0.0, -69.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (498) (27.0, 0.0, -70.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (515) (30.0, 0.3, -65.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (511) (28.0, 0.3, -66.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (502) (27.0, 0.0, -68.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (557) (32.5, 0.3, -66.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (501) (27.0, 0.0, -69.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (503) (26.0, 0.3, -68.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (504) (26.0, 0.0, -69.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (499) (26.0, 0.3, -70.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (500) (26.0, 0.0, -71.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (551) (37.8, 0.0, -65.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (552) (37.8, 0.0, -64.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (554) (36.8, 0.0, -65.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (553) (36.8, 0.3, -64.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (566) (41.5, 2.5, -61.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (584) (40.5, 2.0, -61.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (565) (41.5, 3.0, -60.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (564) (42.5, 3.0, -60.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (563) (42.5, 2.5, -61.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (615) (44.3, 0.5, -66.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (613) (45.3, 1.0, -65.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (612) (45.3, 0.5, -66.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (614) (44.3, 1.3, -65.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (585) (47.8, 0.5, -66.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (583) (47.8, 0.3, -67.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (587) (46.8, 0.3, -67.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (586) (46.8, 0.8, -66.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (496) (43.0, -1.0, -71.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (493) (44.0, -1.0, -71.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (495) (43.0, -0.5, -70.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (490) (46.0, -1.0, -71.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (486) (46.0, -1.3, -72.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (491) (45.0, -0.8, -71.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (492) (45.0, -1.3, -72.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (494) (44.0, -0.8, -70.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (468) (46.0, -0.5, -83.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (470) (46.0, -0.8, -82.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (471) (45.0, -0.5, -83.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (469) (45.0, -0.5, -82.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (672) (49.8, 0.0, -90.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (673) (49.8, -0.3, -91.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (670) (50.8, -0.3, -90.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (671) (50.8, -0.3, -91.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (668) (51.8, 0.0, -91.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (669) (51.8, -0.3, -92.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (666) (52.8, -0.3, -91.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (667) (52.8, -0.3, -92.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (618) (54.3, -0.3, -95.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (619) (54.3, -0.5, -96.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (616) (55.3, -0.5, -96.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (617) (55.3, -0.5, -95.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (674) (46.3, -0.3, -95.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (676) (45.3, 0.0, -95.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (675) (46.3, -0.3, -96.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (677) (45.3, -0.3, -96.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (682) (58.0, -0.5, -78.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (683) (58.0, -0.5, -79.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (680) (59.0, 0.0, -79.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (681) (59.0, -0.3, -80.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (685) (57.0, -0.5, -79.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (679) (60.0, -0.3, -80.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (678) (60.0, -0.3, -79.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (684) (57.0, -0.3, -78.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (591) (57.3, -0.8, -76.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (588) (57.3, -0.8, -77.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (599) (56.3, -1.0, -77.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (598) (56.3, -0.8, -76.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (600) (56.8, -0.5, -72.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (601) (56.8, -0.5, -71.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (603) (55.8, -0.8, -72.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (602) (55.8, -0.5, -71.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (607) (60.8, -0.3, -68.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (606) (60.8, 0.3, -67.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (611) (62.8, 0.3, -67.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (605) (61.8, 0.3, -67.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (604) (61.8, -0.3, -68.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (608) (63.8, 0.3, -67.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (610) (62.8, 0.8, -66.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (609) (63.8, 0.8, -66.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (693) (66.8, 0.5, -66.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (690) (67.8, 0.5, -66.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (691) (67.8, 0.8, -65.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (686) (66.8, 1.0, -64.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (692) (66.8, 1.0, -65.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (687) (66.8, 1.0, -63.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (688) (65.8, 1.3, -63.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (689) (65.8, 1.0, -64.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (592) (55.3, 1.3, -65.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (597) (56.3, 1.3, -65.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (596) (57.3, 1.3, -65.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (589) (53.3, 1.5, -64.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (595) (54.3, 1.3, -65.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (594) (54.3, 1.8, -64.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (593) (55.3, 1.5, -64.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (590) (52.3, 1.8, -64.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (699) (77.0, 0.8, -71.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (701) (76.0, 0.5, -71.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (700) (76.0, 1.0, -70.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (698) (77.0, 1.0, -70.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (694) (73.0, 0.0, -68.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (695) (73.0, 0.0, -69.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (697) (72.0, 0.0, -69.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (696) (72.0, 0.3, -68.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1489) (89.0, -0.8, -73.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (664) (90.0, -1.0, -74.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (665) (90.0, -1.5, -75.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (663) (91.0, -1.3, -74.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1486) (90.0, -0.8, -73.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (660) (92.0, -1.3, -74.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1481) (93.0, -0.8, -73.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (661) (92.0, -1.0, -73.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (662) (91.0, -0.8, -73.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1380) (94.0, -0.8, -73.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1479) (93.0, -0.3, -72.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1478) (94.0, -0.8, -72.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1487) (90.0, -0.8, -72.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1488) (89.0, -0.3, -72.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (658) (96.0, -1.3, -81.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (657) (97.0, -1.5, -81.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (659) (96.0, -1.5, -82.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (656) (97.0, -1.5, -82.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (655) (109.5, -1.5, -85.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (652) (110.5, -1.5, -85.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (654) (109.5, -1.3, -84.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (653) (110.5, -1.5, -84.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (638) (116.3, -0.3, -88.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (639) (116.3, -0.5, -89.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (637) (117.3, -0.5, -88.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (636) (117.3, -0.5, -89.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (649) (111.8, -0.5, -94.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (650) (110.8, -0.3, -94.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (648) (111.8, -0.5, -95.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (651) (110.8, -0.5, -95.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (645) (107.0, -0.3, -98.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (647) (106.0, -0.5, -99.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (646) (106.0, -0.3, -98.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (644) (107.0, -0.5, -99.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (641) (105.0, -0.5, -95.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (642) (104.0, -0.3, -95.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (643) (104.0, -0.5, -96.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (640) (105.0, -0.5, -96.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (478) (117.5, 0.0, -78.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (479) (117.5, -0.3, -79.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (483) (116.5, -0.3, -77.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (476) (118.5, -0.3, -79.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (480) (117.5, -0.3, -77.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (477) (118.5, -0.3, -78.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (475) (118.5, -0.3, -77.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (482) (116.5, 0.0, -76.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (485) (115.5, -0.3, -77.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (474) (118.5, 0.0, -76.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (481) (117.5, -0.3, -76.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (484) (115.5, 0.0, -76.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (472) (119.5, -0.3, -77.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (473) (119.5, -0.3, -76.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (633) (128.0, -1.0, -85.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (632) (128.0, -1.3, -86.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (634) (127.0, -0.8, -85.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (635) (127.0, -1.3, -86.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (628) (122.5, -0.3, -82.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (629) (122.5, -0.3, -81.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (630) (121.5, 0.0, -81.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (631) (121.5, -0.3, -82.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (489) (135.8, -2.0, -90.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (488) (135.8, -1.8, -89.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (487) (136.8, -2.0, -89.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (733) (163.8, -0.8, -85.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (732) (163.8, -0.3, -84.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (730) (164.8, -0.8, -85.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (731) (164.8, -0.5, -84.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (737) (165.0, -0.3, -80.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (734) (166.0, -0.3, -80.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (729) (167.5, -0.3, -82.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (727) (168.5, -0.5, -81.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (726) (168.5, -0.5, -82.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (728) (167.5, 0.0, -81.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (735) (166.0, -0.5, -79.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (736) (165.0, -0.3, -79.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (725) (146.3, -1.3, -79.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (724) (146.3, -0.8, -78.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (723) (147.3, -1.0, -78.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (722) (147.3, -1.3, -79.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1087) (131.0, 4.3, -85.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1081) (132.0, 4.0, -85.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1398) (133.0, 4.3, -84.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1395) (131.0, 4.0, -86.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1079) (132.0, 4.0, -86.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1396) (134.0, 4.0, -85.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1399) (133.0, 4.0, -85.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1397) (134.0, 4.0, -84.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1403) (138.3, 4.0, -77.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1400) (139.3, 4.0, -77.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1402) (138.3, 4.3, -76.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1401) (139.3, 4.0, -76.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1415) (132.3, 4.0, -73.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1412) (133.3, 4.0, -73.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1413) (133.3, 4.0, -72.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1414) (132.3, 4.3, -72.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1417) (131.3, 4.0, -72.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1416) (131.3, 4.0, -73.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1418) (130.3, 4.3, -72.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1419) (130.3, 4.0, -73.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1420) (129.3, 4.0, -72.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1421) (128.3, 4.3, -72.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1408) (139.8, 4.0, -69.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1409) (139.8, 4.0, -68.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1407) (140.8, 4.0, -69.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1404) (141.8, 4.0, -69.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1515) (141.8, 4.3, -70.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1411) (138.8, 4.0, -69.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1511) (142.8, 4.0, -70.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1516) (142.8, 4.0, -71.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1517) (141.8, 4.0, -71.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1405) (141.8, 4.0, -68.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1406) (140.8, 4.3, -68.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1410) (138.8, 4.3, -68.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1425) (131.0, 7.8, -69.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1424) (132.0, 7.8, -68.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1423) (132.0, 7.8, -69.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1422) (131.0, 7.8, -68.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1518) (127.3, 7.8, -62.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1520) (127.3, 7.8, -61.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1519) (126.3, 7.8, -61.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1521) (126.3, 7.8, -62.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1432) (116.8, 7.8, -64.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1427) (114.8, 7.8, -65.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1428) (114.8, 7.8, -64.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1431) (115.8, 7.8, -64.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1426) (113.8, 7.8, -64.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1429) (113.8, 7.8, -65.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1430) (112.8, 7.8, -64.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1438) (105.3, 7.8, -62.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1439) (105.3, 7.8, -61.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1436) (106.3, 7.8, -62.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1437) (104.3, 7.8, -61.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1435) (107.3, 7.8, -61.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1434) (107.3, 7.8, -62.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1433) (106.3, 7.8, -61.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1441) (94.1, 7.8, -61.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1440) (93.1, 7.8, -61.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1456) (86.5, 7.8, -60.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1455) (86.5, 7.8, -61.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1457) (85.5, 7.8, -61.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1454) (85.5, 7.8, -60.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1444) (88.0, 7.8, -66.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1442) (87.0, 7.8, -66.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1445) (87.0, 7.8, -67.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1524) (89.0, 7.8, -67.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1443) (88.0, 7.8, -67.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1522) (93.1, 7.8, -66.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1525) (93.1, 7.8, -67.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1523) (94.1, 7.8, -67.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1451) (73.5, 4.0, -61.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1452) (73.5, 4.0, -60.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1450) (72.5, 4.0, -60.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1453) (72.5, 4.0, -61.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1449) (82.3, 4.0, -65.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1447) (83.3, 4.0, -65.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1446) (82.3, 4.0, -64.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1448) (83.3, 4.0, -64.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1480) (96.0, 4.0, -68.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1485) (97.0, 4.0, -69.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1482) (97.0, 4.0, -68.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1484) (98.0, 4.0, -68.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1483) (98.0, 4.0, -69.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1319) (123.5, 12.0, -46.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1321) (122.5, 12.0, -46.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1322) (122.5, 12.0, -45.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1320) (121.5, 12.0, -45.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1317) (124.5, 12.0, -46.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1316) (123.5, 12.0, -45.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1323) (121.5, 12.0, -46.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1318) (124.5, 12.0, -45.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1512) (114.9, 12.0, -48.7)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1513) (114.9, 12.0, -47.7)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1514) (113.9, 12.0, -48.7)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1295) (136.8, 12.0, -53.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1296) (136.8, 12.0, -52.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1297) (135.8, 12.0, -53.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1298) (137.8, 12.0, -52.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1294) (135.8, 12.0, -52.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1299) (138.8, 12.0, -52.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1300) (140.0, 12.0, -58.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1302) (141.0, 12.0, -58.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1303) (140.0, 12.0, -59.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1301) (141.0, 12.0, -59.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1307) (146.3, 12.0, -53.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1304) (146.3, 12.0, -52.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1306) (147.3, 12.0, -52.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1305) (147.3, 12.0, -53.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1309) (144.8, 12.0, -62.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1310) (144.8, 12.0, -61.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1308) (143.8, 12.0, -61.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1311) (143.8, 12.0, -62.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1312) (133.3, 12.0, -65.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1315) (133.3, 12.0, -66.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1313) (134.3, 12.0, -66.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1314) (134.3, 12.0, -65.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1327) (96.8, 12.0, -46.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1326) (97.8, 12.0, -45.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1325) (97.8, 12.0, -46.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1329) (99.8, 12.0, -45.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1328) (98.8, 12.0, -45.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1324) (96.8, 12.0, -45.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1331) (104.8, 12.0, -45.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1330) (103.8, 12.0, -45.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1335) (84.0, 12.0, -46.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1332) (84.0, 12.0, -45.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1333) (85.0, 12.0, -46.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1334) (85.0, 12.0, -45.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1369) (68.5, 12.0, -58.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1372) (68.5, 12.0, -59.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1371) (69.5, 12.0, -58.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1370) (69.5, 12.0, -59.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1375) (65.0, 12.0, -60.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1373) (64.0, 12.0, -60.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1374) (65.0, 12.0, -61.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1376) (64.0, 12.0, -61.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1348) (60.0, 12.0, -50.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1345) (60.0, 12.0, -49.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1346) (61.0, 12.0, -50.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1347) (61.0, 12.0, -49.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1343) (53.3, 12.0, -49.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1344) (54.3, 12.0, -49.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1341) (51.3, 12.0, -49.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1342) (52.3, 12.0, -49.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1340) (50.3, 12.0, -49.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1337) (49.3, 12.0, -50.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1338) (49.3, 12.0, -49.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1336) (48.3, 12.0, -49.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1339) (48.3, 12.0, -50.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1367) (51.5, 12.0, -62.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1368) (50.5, 12.0, -63.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1365) (50.5, 12.0, -62.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1366) (51.5, 12.0, -63.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1363) (37.3, 12.0, -58.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1361) (36.3, 12.0, -58.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1364) (36.3, 12.0, -59.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1362) (37.3, 12.0, -59.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1356) (33.3, 12.0, -54.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1353) (33.3, 12.0, -53.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1354) (34.3, 12.0, -54.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1355) (34.3, 12.0, -53.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1351) (33.3, 12.0, -51.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1350) (33.3, 12.0, -52.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1349) (32.3, 12.0, -51.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1352) (32.3, 12.0, -52.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1359) (31.0, 12.0, -44.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1358) (31.0, 12.0, -45.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1357) (30.0, 12.0, -44.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1360) (30.0, 12.0, -45.5)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1390) (42.3, 12.0, -34.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1387) (42.3, 12.0, -33.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1388) (43.3, 12.0, -34.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1389) (43.3, 12.0, -33.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1392) (40.0, 12.0, -26.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1394) (39.0, 12.0, -26.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1393) (40.0, 12.0, -25.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1391) (39.0, 12.0, -25.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1385) (31.8, 7.5, -29.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1383) (31.8, 7.5, -26.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1382) (31.8, 7.5, -27.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1384) (30.8, 7.5, -27.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1381) (30.8, 7.5, -26.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (1386) (31.8, 7.5, -28.3)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (425) (-85.0, -0.3, -11.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (428) (-85.0, -0.5, -12.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (427) (-86.0, 0.0, -11.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (426) (-86.0, 0.0, -12.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (623) (70.5, -0.5, -92.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (620) (71.5, -0.5, -92.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (622) (70.5, -0.3, -91.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (621) (71.5, -0.3, -91.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (741) (76.8, -0.8, -98.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (742) (77.8, -0.5, -98.0)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (627) (67.0, -1.0, -83.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (624) (68.0, -1.0, -83.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (625) (68.0, -1.5, -82.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Front Grass swamp (626) (67.0, -1.0, -82.8)": TunicLocationData("Swamp Front", "Swamp Front"),
    "Swamp - Swamp Mid Grass swamp (925) (34.5, 0.0, -7.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (922) (35.5, 0.0, -7.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (924) (34.5, 0.3, -6.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (923) (35.5, 0.3, -6.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (920) (42.3, -0.3, -7.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (921) (42.3, -0.8, -8.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (918) (43.3, -1.0, -8.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (919) (43.3, -0.8, -7.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (914) (45.3, -1.3, -7.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (916) (44.3, -0.5, -6.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (917) (44.3, -1.0, -7.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (915) (45.3, -1.0, -6.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (908) (47.8, -0.8, 6.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (909) (47.8, -1.0, 5.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (906) (48.8, -1.3, 5.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (907) (48.8, -1.3, 6.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (905) (51.5, -1.8, 13.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (902) (51.5, -0.5, 15.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (903) (51.5, -1.0, 14.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (900) (52.5, -1.0, 14.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (904) (52.5, -1.8, 13.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (897) (54.5, -0.5, 16.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (896) (54.5, -0.8, 15.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (898) (53.5, -0.3, 16.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (901) (52.5, -0.8, 15.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (899) (53.5, -0.8, 15.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (926) (39.0, 0.0, 10.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (927) (39.0, 0.3, 11.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (931) (38.0, 0.0, 13.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (930) (38.0, 0.0, 12.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (928) (38.0, 0.3, 11.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (932) (37.0, 0.3, 13.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (933) (37.0, 0.0, 12.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (929) (38.0, 0.0, 10.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (935) (39.8, 0.0, 25.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (934) (39.8, 0.0, 24.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (936) (38.8, 0.3, 25.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (937) (38.8, 0.0, 24.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (893) (63.5, 0.0, 12.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (895) (62.5, 0.0, 11.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (894) (62.5, 0.3, 12.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (889) (61.5, 0.0, 11.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (890) (60.5, 0.3, 11.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (891) (60.5, 0.0, 10.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (892) (63.5, 0.0, 11.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (888) (61.5, 0.0, 10.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (881) (60.5, 0.0, -4.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (880) (60.5, 0.0, -5.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (884) (61.5, 0.0, -3.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (887) (60.5, 0.0, -3.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (886) (60.5, 0.3, -2.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (885) (61.5, 0.0, -2.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (883) (59.5, -0.3, -5.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (882) (59.5, 0.0, -4.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (877) (67.0, 0.0, -12.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (874) (68.0, 0.3, -11.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (875) (68.0, 0.0, -12.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (873) (69.0, 0.0, -11.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (872) (69.0, 0.0, -12.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (878) (66.0, 0.3, -12.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (879) (66.0, -0.3, -13.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (876) (67.0, -0.3, -13.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (743) (82.5, 0.0, -3.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (738) (83.5, 0.0, -3.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (740) (82.5, 0.3, -2.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (739) (83.5, 0.0, -2.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (910) (77.5, 0.0, 1.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (911) (77.5, 0.0, 2.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (913) (76.5, 0.0, 1.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (912) (76.5, 0.3, 2.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (756) (76.0, -1.3, 6.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (754) (77.0, -1.0, 8.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (755) (77.0, -1.3, 7.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (757) (76.0, -1.3, 7.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (759) (75.0, -1.3, 6.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (758) (75.0, -1.3, 7.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (752) (78.0, -1.0, 7.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (753) (78.0, -1.3, 8.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (786) (95.8, 0.3, 15.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (785) (96.8, 0.0, 15.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (784) (96.8, 0.0, 14.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (787) (95.8, 0.0, 14.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (776) (100.8, 0.0, 14.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (777) (100.8, 0.0, 15.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (779) (99.8, 0.0, 14.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (778) (99.8, 0.3, 15.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (788) (97.3, 0.0, 19.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (789) (97.3, 0.0, 20.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (791) (96.3, 0.0, 19.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (790) (96.3, 0.3, 20.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (792) (98.3, 0.0, 22.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (796) (103.0, 0.0, 22.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (795) (103.0, 0.0, 21.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (798) (102.0, 0.0, 21.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (793) (98.3, 0.0, 23.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (794) (97.3, 0.3, 23.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (782) (101.8, 0.3, 16.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (781) (102.8, 0.0, 16.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (783) (101.8, 0.0, 15.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (780) (102.8, 0.0, 15.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (833) (108.5, 0.0, 20.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (830) (109.5, 0.0, 20.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (831) (109.5, 0.0, 21.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (832) (108.5, 0.3, 21.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (945) (112.3, 0.3, 12.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (946) (112.3, 0.0, 11.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (944) (113.3, 0.0, 12.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (943) (113.3, 0.0, 11.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (772) (114.3, 0.0, 9.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (771) (112.3, 0.0, 7.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (770) (112.3, 0.3, 8.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (774) (113.3, 0.3, 10.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (775) (113.3, 0.0, 9.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (768) (113.3, 0.0, 7.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (769) (113.3, 0.0, 8.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (773) (114.3, 0.0, 10.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (767) (104.5, 0.0, 3.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (766) (104.5, 0.3, 4.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (765) (105.5, 0.0, 4.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (764) (105.5, 0.0, 3.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (761) (103.5, 0.0, 3.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (762) (102.5, 0.3, 3.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (763) (102.5, 0.0, 2.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (760) (103.5, 0.0, 2.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (971) (104.8, 0.3, -12.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (970) (105.8, 0.0, -12.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (967) (106.8, 0.3, -9.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (963) (106.8, 0.3, -11.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (968) (106.8, 0.0, -10.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (961) (107.8, 0.0, -12.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (964) (106.8, 0.0, -12.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (969) (105.8, 0.0, -13.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (972) (104.8, 0.0, -13.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (965) (107.8, 0.0, -10.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (962) (107.8, 0.0, -11.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (966) (107.8, 0.0, -9.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (747) (88.3, 0.0, -12.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (744) (89.3, 0.0, -12.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (745) (89.3, 0.0, -11.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (746) (88.3, 0.3, -11.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (751) (94.5, 0.0, -10.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (748) (95.5, 0.0, -10.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (749) (95.5, 0.0, -9.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (750) (94.5, 0.3, -9.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (975) (118.5, 0.3, -12.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (976) (118.5, 0.0, -13.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (974) (119.5, 0.0, -12.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (973) (119.5, 0.0, -13.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (856) (120.8, -1.5, -1.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (857) (120.8, -1.5, -0.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (859) (119.8, -1.0, -1.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (858) (119.8, -0.8, -0.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (871) (126.0, -1.8, 0.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (868) (127.0, -1.8, 0.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (869) (127.0, -1.8, 1.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (870) (126.0, -1.5, 1.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (951) (132.3, -0.3, 11.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (952) (132.3, -0.3, 12.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (947) (130.3, -0.5, 11.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (953) (131.3, -0.3, 12.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (954) (131.3, -0.5, 11.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (852) (128.5, -1.0, 8.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (948) (130.3, -0.5, 12.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (949) (129.3, -0.5, 12.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (950) (129.3, -0.8, 11.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (853) (127.5, -1.0, 8.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (851) (128.5, -1.0, 7.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (854) (127.5, -1.3, 7.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (855) (126.5, -1.3, 7.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (988) (140.0, -1.3, 6.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (985) (141.0, -1.3, 6.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (986) (140.0, -1.0, 7.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (987) (141.0, -1.0, 7.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (862) (134.3, -1.0, -4.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (861) (135.3, -0.8, -4.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (865) (133.3, -1.5, -3.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (864) (133.3, -1.5, -4.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (867) (132.3, -1.8, -4.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (866) (132.3, -1.8, -3.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (860) (135.3, -0.8, -5.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (863) (134.3, -1.0, -5.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (982) (139.3, 0.3, -10.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (984) (139.3, 0.0, -11.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (983) (140.3, 0.0, -10.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (979) (139.3, 0.0, -12.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (980) (138.3, 0.0, -13.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (978) (138.3, 0.3, -12.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (981) (140.3, 0.0, -11.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (977) (139.3, 0.0, -13.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (960) (151.0, 0.0, -3.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (956) (152.0, 0.5, -3.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (955) (151.0, 0.0, -1.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (959) (151.0, 0.3, -2.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (958) (150.0, 0.0, -1.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (957) (150.0, 0.3, -0.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1238) (160.3, 1.8, -12.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1244) (159.3, 0.3, -14.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1245) (160.3, 0.3, -14.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1243) (160.3, 0.8, -13.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1237) (161.3, 2.3, -11.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1236) (160.3, 2.5, -11.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1235) (162.0, 3.8, -5.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1239) (162.0, 3.8, -4.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1201) (162.0, 3.8, -0.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1222) (162.0, 3.8, 0.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1223) (161.0, 3.8, -0.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1221) (161.0, 4.0, 0.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1227) (156.5, 3.8, 2.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1224) (157.5, 3.8, 2.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1228) (158.5, 3.8, 3.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1226) (157.5, 3.8, 3.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1225) (156.5, 4.0, 3.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1232) (148.8, 3.8, 15.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1233) (148.8, 3.8, 14.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1231) (149.8, 3.8, 14.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1229) (149.8, 3.8, 15.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1230) (148.8, 4.0, 16.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (837) (145.0, 0.0, 17.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (836) (145.0, 0.3, 18.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (844) (145.0, 0.0, 20.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (843) (145.0, 0.0, 19.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (845) (144.0, 0.3, 20.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (846) (144.0, 0.0, 19.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1234) (145.3, 0.0, 15.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (847) (145.3, 0.0, 13.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (848) (145.3, 0.0, 14.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (849) (144.3, 0.3, 14.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (850) (144.3, 0.0, 13.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (834) (146.0, 0.0, 17.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (835) (146.0, 0.0, 18.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (842) (142.3, 1.0, 23.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (841) (141.3, 1.0, 24.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (838) (142.3, 1.3, 24.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (839) (142.3, 1.8, 25.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (840) (141.3, 1.8, 25.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (828) (132.5, 1.5, 35.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (829) (132.5, 1.0, 34.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (826) (133.5, 1.3, 34.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (827) (133.5, 1.3, 35.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (822) (131.5, -0.3, 44.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (818) (131.5, 0.0, 43.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (823) (130.5, 0.3, 44.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (824) (130.5, 0.0, 43.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (825) (129.5, 0.3, 44.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (819) (126.3, 0.0, 41.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (821) (126.3, 0.0, 42.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (815) (124.3, 0.0, 41.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (820) (125.3, 0.3, 41.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (814) (124.3, 0.0, 40.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (817) (123.3, -0.3, 40.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (816) (123.3, 0.0, 41.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (812) (120.5, -0.3, 33.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (810) (121.5, -0.3, 32.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (811) (121.5, -0.3, 33.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (808) (119.5, 0.0, 31.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (813) (120.5, -0.5, 32.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (807) (120.5, 0.0, 31.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (806) (120.5, 0.0, 30.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (809) (119.5, -0.3, 30.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (804) (120.8, 0.3, 26.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (805) (120.8, 0.0, 25.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (802) (121.8, 0.0, 25.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (803) (121.8, 0.0, 26.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (800) (122.8, 0.3, 25.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (801) (122.8, 0.0, 24.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (797) (123.8, 0.0, 24.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (799) (123.8, 0.0, 25.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1379) (88.3, -0.5, 43.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1458) (88.3, -0.8, 44.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1377) (89.3, -0.8, 42.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1378) (89.3, -0.8, 43.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1459) (88.3, -0.8, 45.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1462) (90.8, 0.0, 55.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1463) (90.8, -0.3, 54.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1460) (91.8, -0.3, 54.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1461) (91.8, -0.3, 55.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1466) (88.3, -0.5, 71.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1467) (88.3, -0.8, 70.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1465) (89.3, -0.5, 71.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1464) (89.3, -0.5, 70.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1468) (88.3, -0.3, 82.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1471) (87.3, -0.3, 82.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1469) (88.3, -0.3, 83.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1470) (87.3, 0.0, 83.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1476) (86.5, -0.3, 88.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1477) (86.5, -0.3, 89.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1472) (86.5, -0.3, 90.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1474) (85.5, 0.0, 91.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1475) (85.5, -0.3, 90.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1261) (156.8, 4.0, -60.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1264) (156.8, 4.0, -61.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1262) (157.8, 4.0, -61.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1208) (160.8, 7.5, 15.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1207) (160.8, 7.5, 16.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1216) (158.8, 7.5, 18.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1203) (163.8, 7.5, 14.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1202) (162.8, 7.5, 15.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1204) (162.8, 7.5, 14.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1206) (161.8, 7.5, 15.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1205) (161.8, 7.5, 16.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1210) (161.8, 7.5, 17.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1209) (161.8, 7.5, 18.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1212) (160.8, 7.5, 17.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1211) (160.8, 7.5, 18.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1214) (159.8, 7.5, 18.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1213) (159.8, 7.5, 19.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1215) (158.8, 7.5, 19.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1200) (163.0, 7.5, 9.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1198) (163.0, 7.5, 10.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1199) (164.0, 7.5, 9.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1197) (164.0, 7.5, 10.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1219) (155.3, 7.5, 11.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1217) (156.3, 7.5, 11.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1218) (156.3, 7.5, 10.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1220) (155.3, 7.5, 10.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1240) (165.8, 7.5, 2.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1241) (165.8, 7.5, 1.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1270) (157.0, 15.8, -43.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1272) (157.0, 15.8, -42.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1273) (158.0, 15.8, -42.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1269) (157.0, 15.8, -44.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1268) (156.0, 15.8, -43.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1271) (156.0, 15.8, -44.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1248) (168.5, 15.8, -40.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1246) (169.5, 15.8, -40.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1247) (169.5, 15.8, -39.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1242) (168.5, 15.8, -39.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1249) (168.5, 15.8, -50.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1252) (168.5, 15.8, -51.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1251) (169.5, 15.8, -50.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1250) (169.5, 15.8, -51.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1255) (172.3, 15.8, -54.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1253) (171.3, 15.8, -54.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1256) (171.3, 15.8, -55.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1254) (172.3, 15.8, -55.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1257) (166.8, 15.8, -58.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1260) (166.8, 15.8, -59.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1259) (167.8, 15.8, -58.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1258) (167.8, 15.8, -59.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1266) (158.5, 15.8, -57.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1265) (158.5, 15.8, -58.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1263) (157.5, 15.8, -57.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1267) (157.5, 15.8, -58.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1285) (140.5, 15.8, -45.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1282) (140.5, 15.8, -44.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1283) (141.5, 15.8, -45.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1284) (141.5, 15.8, -44.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1288) (132.5, 15.8, -48.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1293) (129.5, 15.8, -48.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1290) (129.5, 15.8, -47.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1289) (131.5, 15.8, -49.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1286) (131.5, 15.8, -48.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1291) (130.5, 15.8, -48.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1292) (130.5, 15.8, -47.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1287) (132.5, 15.8, -49.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1281) (169.5, 15.8, -28.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1275) (168.3, 15.8, -26.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1279) (170.5, 15.8, -28.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1280) (170.5, 15.8, -27.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1278) (169.5, 15.8, -27.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1276) (168.3, 15.8, -25.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1277) (167.3, 15.8, -26.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1274) (167.3, 15.8, -25.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1167) (170.0, 15.8, -18.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1169) (170.0, 15.8, -19.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1166) (171.0, 15.8, -18.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1168) (171.0, 15.8, -19.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1163) (171.0, 15.8, -20.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1165) (171.0, 15.8, -21.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1164) (172.0, 15.8, -21.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1162) (172.0, 15.8, -20.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1148) (183.8, 15.8, -18.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1161) (180.0, 15.8, -14.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1157) (181.0, 15.8, -13.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1160) (181.0, 15.8, -14.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1159) (180.0, 15.8, -13.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1146) (183.8, 15.8, -17.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1152) (184.8, 15.8, -20.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1150) (184.8, 15.8, -19.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1145) (184.8, 15.8, -17.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1147) (184.8, 15.8, -18.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1151) (185.8, 15.8, -20.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1149) (185.8, 15.8, -19.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1156) (187.8, 15.8, -24.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1154) (188.8, 15.8, -24.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1158) (187.8, 15.8, -25.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1155) (192.8, 15.8, -15.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1153) (192.8, 15.8, -14.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1093) (192.0, 15.8, -9.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1098) (193.0, 15.8, -8.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1099) (193.0, 15.8, -9.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1094) (193.0, 15.8, -9.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1102) (193.0, 15.8, -5.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1101) (193.0, 15.8, -4.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1096) (192.0, 15.8, -10.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1095) (193.0, 15.8, -10.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1097) (193.0, 15.8, -2.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1018) (193.0, 15.8, -1.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1100) (193.0, 15.8, -3.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1019) (192.0, 15.8, -1.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1017) (193.0, 15.8, -0.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1022) (193.0, 15.8, 0.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1027) (192.0, 15.8, 2.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1023) (192.0, 15.8, 0.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1020) (192.0, 15.8, 1.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1016) (192.0, 15.8, -0.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1026) (193.0, 15.8, 2.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1021) (193.0, 15.8, 1.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1133) (190.0, 15.8, 1.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1135) (190.0, 15.8, 0.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1136) (189.0, 15.8, 0.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1134) (189.0, 15.8, 1.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1137) (185.3, 15.8, -0.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1139) (185.3, 15.8, -1.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1028) (191.0, 15.8, 3.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1029) (191.0, 15.8, 2.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1025) (193.0, 15.8, 3.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1024) (192.0, 15.8, 3.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1031) (193.0, 15.8, 5.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1032) (193.0, 15.8, 4.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1138) (184.3, 15.8, -0.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1140) (184.3, 15.8, -1.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1131) (173.0, 15.8, -1.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1127) (171.0, 15.8, -0.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1130) (172.0, 15.8, -0.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1132) (172.0, 15.8, -1.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1129) (173.0, 15.8, -0.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1142) (176.8, 15.8, -7.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1141) (177.8, 15.8, -7.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1143) (177.8, 15.8, -8.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1144) (176.8, 15.8, -8.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1128) (170.0, 15.8, -0.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1125) (171.0, 15.8, 0.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1126) (170.0, 15.8, 0.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1121) (177.8, 15.8, 5.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1123) (177.8, 15.8, 4.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1122) (176.8, 15.8, 5.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1124) (176.8, 15.8, 4.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1010) (173.8, 15.8, 9.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1011) (172.8, 15.8, 9.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1013) (175.8, 15.8, 11.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1014) (175.8, 15.8, 10.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1012) (174.8, 15.8, 11.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1015) (174.8, 15.8, 10.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1008) (172.8, 15.8, 10.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1009) (173.8, 15.8, 10.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1001) (168.3, 15.8, 15.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1003) (169.3, 15.8, 15.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1006) (168.3, 15.8, 14.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (999) (168.3, 15.8, 17.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1000) (168.3, 15.8, 16.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1004) (169.3, 15.8, 16.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1005) (169.3, 15.8, 17.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1007) (167.3, 15.8, 14.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1002) (167.3, 15.8, 15.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1188) (164.3, 15.8, 21.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1186) (163.3, 15.8, 22.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1189) (163.3, 15.8, 21.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1110) (180.8, 15.8, 13.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1109) (180.8, 15.8, 14.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1107) (181.8, 15.8, 14.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1108) (181.8, 15.8, 13.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1105) (181.3, 15.8, 11.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1103) (182.3, 15.8, 11.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1112) (182.8, 15.8, 15.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1111) (182.8, 15.8, 16.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1114) (181.8, 15.8, 15.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1113) (181.8, 15.8, 16.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1106) (181.3, 15.8, 10.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1104) (182.3, 15.8, 10.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1115) (182.3, 15.8, 9.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1116) (181.3, 15.8, 9.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1117) (187.8, 15.8, 10.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1118) (186.8, 15.8, 10.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1120) (186.8, 15.8, 9.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1119) (187.8, 15.8, 9.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1036) (192.0, 15.8, 13.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1039) (192.0, 15.8, 12.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1042) (189.3, 15.8, 16.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1043) (188.3, 15.8, 16.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1040) (193.0, 15.8, 11.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1038) (193.0, 15.8, 12.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1037) (193.0, 15.8, 13.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1034) (193.0, 15.8, 14.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1033) (193.0, 15.8, 15.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1030) (192.0, 15.8, 15.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1035) (192.0, 15.8, 14.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1047) (187.0, 15.8, 18.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1048) (186.0, 15.8, 18.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1041) (188.3, 15.8, 17.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1045) (187.0, 15.8, 19.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1046) (186.0, 15.8, 19.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1044) (186.0, 15.8, 20.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Bush (1) (182.3, 16.0, 33.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Bush (184.3, 16.0, 33.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1173) (184.8, 15.8, 30.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1170) (184.8, 15.8, 31.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1171) (185.8, 15.8, 31.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1172) (185.8, 15.8, 30.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1088) (188.8, 15.8, 33.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1078) (187.8, 15.8, 32.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1077) (186.8, 15.8, 32.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1075) (186.8, 15.8, 33.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1074) (186.8, 15.8, 34.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1080) (186.8, 15.8, 31.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1076) (185.8, 15.8, 33.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1073) (185.8, 15.8, 34.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1072) (185.8, 15.8, 35.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1069) (185.8, 15.8, 36.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1059) (184.8, 15.8, 37.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1051) (184.8, 15.8, 35.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1050) (184.8, 15.8, 36.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1057) (183.8, 15.8, 38.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1052) (183.8, 15.8, 35.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1060) (183.8, 15.8, 37.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1049) (183.8, 15.8, 36.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1055) (182.8, 15.8, 35.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1054) (182.8, 15.8, 36.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1053) (181.8, 15.8, 36.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1056) (181.8, 15.8, 35.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1176) (179.5, 15.8, 36.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1071) (186.8, 15.8, 35.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1070) (186.8, 15.8, 36.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1092) (187.8, 15.8, 35.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1085) (188.8, 15.8, 34.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1086) (189.8, 15.8, 34.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1090) (188.8, 15.8, 36.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1091) (188.8, 15.8, 35.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1089) (187.8, 15.8, 36.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1067) (186.8, 15.8, 39.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1066) (186.8, 15.8, 40.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1068) (185.8, 15.8, 39.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1062) (184.8, 15.8, 40.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1058) (184.8, 15.8, 38.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1063) (184.8, 15.8, 39.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1064) (183.8, 15.8, 39.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1061) (183.8, 15.8, 40.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1065) (185.8, 15.8, 40.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1175) (179.5, 15.8, 37.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1177) (178.5, 15.8, 36.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1174) (178.5, 15.8, 37.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Bush (2) (178.3, 16.0, 39.0)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1179) (176.8, 15.8, 40.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1180) (176.8, 15.8, 39.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1178) (175.8, 15.8, 40.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1181) (175.8, 15.8, 39.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1192) (169.0, 15.8, 38.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1191) (170.0, 15.8, 38.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1190) (170.0, 15.8, 39.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1187) (169.0, 15.8, 39.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1183) (165.3, 15.8, 33.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1182) (164.3, 15.8, 33.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1185) (164.3, 15.8, 32.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1184) (165.3, 15.8, 32.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1510) (165.0, 16.5, 42.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1509) (166.0, 16.0, 42.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1508) (166.0, 16.0, 43.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1507) (165.0, 16.5, 43.5)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1196) (153.8, 15.8, 40.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1195) (154.8, 15.8, 40.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1194) (154.8, 15.8, 41.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1193) (153.8, 15.8, 41.8)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1505) (148.0, 15.8, 31.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1504) (148.0, 15.8, 30.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1503) (147.0, 15.8, 31.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Swamp Mid Grass swamp (1506) (147.0, 15.8, 30.3)": TunicLocationData("Swamp Mid", "Swamp Mid"),
    "Swamp - Back of Swamp Grass swamp (1494) (83.8, -0.3, 129.5)": TunicLocationData("Back of Swamp", "Back of Swamp"),
    "Swamp - Back of Swamp Grass swamp (1495) (83.8, -0.3, 130.5)": TunicLocationData("Back of Swamp", "Back of Swamp"),
    "Swamp - Back of Swamp Grass swamp (1496) (82.8, 0.0, 130.5)": TunicLocationData("Back of Swamp", "Back of Swamp"),
    "Swamp - Back of Swamp Grass swamp (1497) (82.8, -0.3, 129.5)": TunicLocationData("Back of Swamp", "Back of Swamp"),
    "Swamp - Back of Swamp Grass swamp (1501) (82.8, -0.3, 131.5)": TunicLocationData("Back of Swamp", "Back of Swamp"),
    "Swamp - Back of Swamp Grass swamp (1498) (83.8, -0.3, 131.5)": TunicLocationData("Back of Swamp", "Back of Swamp"),
    "Swamp - Back of Swamp Grass swamp (1499) (83.8, -0.3, 132.5)": TunicLocationData("Back of Swamp", "Back of Swamp"),
    "Swamp - Back of Swamp Grass swamp (1500) (83.0, -1.0, 141.5)": TunicLocationData("Back of Swamp", "Back of Swamp"),
    "Swamp - Back of Swamp Grass swamp (1502) (83.0, -1.0, 142.5)": TunicLocationData("Back of Swamp", "Back of Swamp"),
    "Swamp - Back of Swamp Laurels Area Grass swamp (991) (34.5, 8.3, 31.8)": TunicLocationData(
        "Back of Swamp Laurels Area", "Back of Swamp Laurels Area"),
    "Swamp - Back of Swamp Laurels Area Grass swamp (992) (34.5, 8.0, 30.8)": TunicLocationData(
        "Back of Swamp Laurels Area", "Back of Swamp Laurels Area"),
    "Swamp - Back of Swamp Laurels Area Grass swamp (989) (35.5, 8.0, 30.8)": TunicLocationData(
        "Back of Swamp Laurels Area", "Back of Swamp Laurels Area"),
    "Swamp - Back of Swamp Laurels Area Grass swamp (990) (35.5, 8.0, 31.8)": TunicLocationData(
        "Back of Swamp Laurels Area", "Back of Swamp Laurels Area"),
    "Swamp - Back of Swamp Laurels Area Grass swamp (995) (32.5, 8.3, 31.8)": TunicLocationData(
        "Back of Swamp Laurels Area", "Back of Swamp Laurels Area"),
    "Swamp - Back of Swamp Laurels Area Grass swamp (994) (33.5, 8.0, 31.8)": TunicLocationData(
        "Back of Swamp Laurels Area", "Back of Swamp Laurels Area"),
}

excluded_grass_locations = {
    "Overworld - Overworld Bush (7) (-39.0, 40.0, -41.0)",
    "Overworld - Overworld Bush (2) (-41.0, 40.0, -41.0)",
    "Overworld - Overworld Bush (16) (53.0, 12.0, -151.0)",
    "Overworld - Overworld Bush (9) (-19.0, 28.0, -103.0)",
    "Overworld - Overworld Bush (23) (-19.0, 28.0, -105.0)",
    "Overworld - Overworld Bush (26) (-19.0, 28.0, -107.0)",
    "Overworld - Overworld Bush (47) (91.0, 12.0, -155.0)",
    "Overworld - Overworld Bush (42) (91.0, 12.0, -157.0)",
    "Overworld - East Overworld Bush (58) (58.0, 44.0, -109.0)",
    "Overworld - East Overworld Bush (62) (66.5, 44.0, -111.0)",
    "Overworld - East Overworld Bush (64) (56.0, 44.0, -107.0)",
}

grass_base_id = base_id + 302
grass_location_name_to_id: dict[str, int] = {name: grass_base_id + index for index, name in enumerate(grass_location_table)}

grass_location_name_groups: dict[str, set[str]] = {}
for loc_name, loc_data in grass_location_table.items():
    area_name = loc_name.split(" - ", 1)[0]
    # adding it to the normal location group and a grass-only one
    grass_location_name_groups.setdefault(area_name, set()).add(loc_name)
    grass_location_name_groups.setdefault(area_name + " Grass", set()).add(loc_name)


def can_break_grass(state: CollectionState, world: "TunicWorld") -> bool:
    player = world.player
    # no gun or wand because they're extremely tedious
    return (has_sword(state, player)
            or (has_melee(state, player) and state.has("Glass Cannon", player)))


def set_grass_location_rules(world: "TunicWorld") -> None:
    player = world.player

    if not world.options.start_with_sword:
        for location in grass_location_table.keys():
            set_rule(world.get_location(location),
                     lambda state: can_break_grass(state, world))

    set_rule(world.get_location("Fortress Courtyard - Fortress Courtyard Upper Grass (1) (72.0, 8.0, -29.0)"),
             lambda state: state.has("Magic Wand", player))
    
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (325) (-111.8, 1.3, 2.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (323) (-111.8, 1.3, 1.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (316) (-110.5, 1.3, 3.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (319) (-111.5, 1.3, 4.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (317) (-111.5, 1.3, 3.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (318) (-110.5, 1.3, 4.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (321) (-112.3, 1.3, 4.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (320) (-112.3, 1.3, 3.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (326) (-112.8, 1.3, 2.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (327) (-113.5, 1.3, 2.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (324) (-112.8, 1.3, 1.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (322) (-113.5, 1.3, 1.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (328) (-112.0, 0.8, -2.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (329) (-112.0, 0.5, -3.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (333) (-111.3, 0.8, -2.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (331) (-111.3, 0.5, -3.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (330) (-110.3, 0.5, -3.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (332) (-110.3, 0.8, -2.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (334) (-111.0, 0.3, -4.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (337) (-110.3, 0.3, -4.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (354) (-113.0, 0.3, -4.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (353) (-112.0, 0.3, -4.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (336) (-109.3, 0.3, -4.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (338) (-109.3, -0.3, -5.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (339) (-110.3, -0.3, -5.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (335) (-111.0, -0.3, -5.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (350) (-112.0, -0.3, -5.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (349) (-113.8, 0.3, -4.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (351) (-113.0, -0.3, -5.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (352) (-113.8, -0.3, -5.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (314) (-112.3, 0.8, 6.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (315) (-112.3, 0.8, 7.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (313) (-111.5, 0.8, 6.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (311) (-111.5, 0.8, 7.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (310) (-110.5, 0.8, 7.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (306) (-110.5, 0.8, 8.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (312) (-110.5, 0.8, 6.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (307) (-109.5, 0.8, 8.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (308) (-111.5, 0.8, 8.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (300) (-107.5, 0.0, 10.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (301) (-107.5, 0.3, 9.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (304) (-108.3, 0.0, 10.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (299) (-108.5, 0.0, 10.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (303) (-110.5, 0.3, 9.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (302) (-109.5, 0.3, 9.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (305) (-109.5, 0.0, 10.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (298) (-108.5, 0.3, 9.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (341) (-113.5, 0.8, 10.5)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (344) (-113.5, 0.5, 11.5)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (346) (-113.5, 0.8, 9.5)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (309) (-111.5, 0.5, 9.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (345) (-112.5, 0.8, 9.5)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (342) (-112.5, 0.8, 8.5)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (340) (-112.5, 0.8, 10.5)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (347) (-114.3, 0.8, 8.5)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (348) (-114.3, 0.8, 9.5)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (343) (-113.5, 0.8, 8.5)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (297) (-99.0, 0.8, 7.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass beach (296) (-98.0, 0.8, 7.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (191) (-89.5, 6.5, 53.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (190) (-89.5, 6.5, 54.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (189) (-88.5, 6.5, 54.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (188) (-88.5, 6.5, 53.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (197) (-87.0, 13.0, 75.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (194) (-87.0, 13.0, 74.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (184) (-86.0, 13.0, 73.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (183) (-86.0, 13.0, 74.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (181) (-86.0, 13.0, 75.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (185) (-84.7, 13.0, 73.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (182) (-83.0, 13.0, 72.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (199) (-83.0, 13.0, 70.8)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (201) (-84.0, 13.0, 70.8)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (135) (-83.5, 13.0, 58.8)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (128) (-82.5, 13.0, 57.8)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (130) (-82.5, 13.0, 58.8)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (147) (-86.0, 13.0, 54.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (132) (-82.5, 13.0, 60.8)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (134) (-83.5, 13.0, 59.8)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (131) (-82.5, 13.0, 59.8)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (136) (-78.5, 13.0, 56.8)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (139) (-79.5, 13.0, 55.8)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (133) (-79.5, 13.0, 56.8)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (138) (-80.5, 13.0, 55.8)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (137) (-80.5, 13.0, 56.8)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (143) (-85.0, 13.0, 53.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (142) (-86.0, 13.0, 53.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (145) (-87.0, 13.0, 53.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (146) (-87.0, 13.0, 54.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (140) (-85.0, 13.0, 52.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (141) (-86.0, 13.0, 52.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (144) (-84.0, 13.0, 52.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (192) (-70.5, 13.0, 56.8)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (186) (-69.5, 13.0, 56.8)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (187) (-69.5, 13.0, 55.8)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (123) (-82.5, 13.0, 44.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (126) (-82.5, 13.0, 45.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (121) (-83.5, 13.0, 45.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (124) (-83.5, 13.0, 44.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (125) (-83.5, 13.0, 43.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (151) (-82.5, 13.0, 27.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (152) (-82.5, 13.0, 26.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (150) (-81.5, 13.0, 27.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (148) (-81.5, 13.0, 25.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (149) (-81.5, 13.0, 26.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (154) (-79.0, 13.0, 23.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (153) (-78.0, 13.0, 23.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (161) (-68.0, 13.0, 26.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (162) (-68.0, 13.0, 27.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (165) (-69.0, 13.0, 27.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (164) (-69.0, 13.0, 28.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (163) (-68.0, 13.0, 28.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (166) (-68.0, 13.0, 29.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (167) (-63.0, 13.0, 24.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (168) (-62.0, 13.0, 24.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (170) (-61.0, 13.0, 25.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (169) (-62.0, 13.0, 25.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (172) (-62.0, 13.0, 26.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (178) (-61.0, 13.0, 43.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (175) (-60.0, 13.0, 43.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (177) (-61.0, 13.0, 44.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (174) (-59.0, 13.0, 42.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (173) (-59.0, 13.0, 43.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (171) (-59.0, 13.0, 44.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (176) (-60.0, 13.0, 44.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (159) (-83.5, 8.0, 23.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (160) (-83.5, 8.0, 24.5)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (158) (-83.5, 8.0, 22.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (155) (-82.5, 8.0, 24.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (157) (-82.5, 8.0, 22.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Ruined Atoll - Ruined Atoll Grass (156) (-82.5, 8.0, 23.0)"), lambda state: state.has_any(("Hero's Laurels", "Magic Orb"), player))
    add_rule(world.get_location("Frog Stairway - Frog Stairs Lower Grass (9) (179.8, 61.9, -67.1)"), lambda state: state.has("Magic Orb", player))
    add_rule(world.get_location("Frog Stairway - Frog Stairs Lower Grass (8) (178.6, 61.9, -67.1)"), lambda state: state.has("Magic Orb", player))
    add_rule(world.get_location("Frog Stairway - Frog Stairs Lower Grass (7) (204.4, 58.1, -94.1)"), lambda state: state.has("Magic Orb", player))
    add_rule(world.get_location("Frog Stairway - Frog Stairs Lower Grass (5) (205.5, 58.1, -94.1)"), lambda state: state.has("Magic Orb", player))
    add_rule(world.get_location("Frog Stairway - Frog Stairs Lower Grass (6) (205.5, 58.1, -93.0)"), lambda state: state.has("Magic Orb", player))
    add_rule(world.get_location("Frog Stairway - Frog Stairs Lower Grass (2) (205.5, 54.0, -77.0)"), lambda state: state.has("Magic Orb", player))
    add_rule(world.get_location("Frog Stairway - Frog Stairs Lower Grass (205.5, 54.0, -76.0)"), lambda state: state.has("Magic Orb", player))
    add_rule(world.get_location("Frog Stairway - Frog Stairs Lower Grass (1) (204.5, 54.0, -76.0)"), lambda state: state.has("Magic Orb", player))
    add_rule(world.get_location("Frog Stairway - Frog Stairs Lower Grass (4) (201.4, 54.3, -71.3)"), lambda state: state.has("Magic Orb", player))
    add_rule(world.get_location("Frog Stairway - Frog Stairs Lower Grass (3) (200.4, 54.3, -71.3)"), lambda state: state.has("Magic Orb", player))
    add_rule(world.get_location("West Garden - West Garden Grass (207) (-310.8, 1.3, 164.5)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("West Garden - West Garden Grass (210) (-310.8, 1.3, 165.5)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("West Garden - West Garden Grass (209) (-312.0, 1.3, 165.5)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("West Garden - West Garden Grass (208) (-312.0, 1.3, 164.5)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("West Garden - West Garden Grass (174) (-243.9, 0.5, 52.1)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("West Garden - West Garden Grass (262) (-244.8, 0.5, 51.3)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("West Garden - West Garden Grass (263) (-244.8, 0.5, 52.3)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("West Garden - West Garden Laurels Exit Grass (269) (-162.5, 2.0, 75.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("West Garden - West Garden Laurels Exit Grass (267) (-161.3, 2.0, 75.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("West Garden - West Garden Laurels Exit Grass (268) (-161.3, 2.0, 74.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("West Garden - West Garden Laurels Exit Grass (299) (-172.1, 2.0, 81.5)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("West Garden - West Garden Laurels Exit Grass (404) (-172.1, 2.0, 80.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("West Garden - West Garden Laurels Exit Grass (402) (-172.1, 2.0, 82.5)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("West Garden - West Garden Laurels Exit Grass (403) (-173.4, 2.0, 81.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("West Garden - West Garden Laurels Exit Grass (401) (-173.4, 2.0, 82.5)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("West Garden - West Garden Laurels Exit Grass (261) (-182.8, 2.0, 75.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("West Garden - West Garden Laurels Exit Grass (259) (-183.8, 2.0, 75.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("West Garden - West Garden Laurels Exit Grass (260) (-183.8, 2.0, 74.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("West Garden - West Garden Laurels Exit Grass (258) (-184.8, 2.0, 75.0)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Swamp - Back of Swamp Laurels Area Grass swamp (991) (34.5, 8.3, 31.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Swamp - Back of Swamp Laurels Area Grass swamp (992) (34.5, 8.0, 30.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Swamp - Back of Swamp Laurels Area Grass swamp (989) (35.5, 8.0, 30.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Swamp - Back of Swamp Laurels Area Grass swamp (990) (35.5, 8.0, 31.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Swamp - Back of Swamp Laurels Area Grass swamp (995) (32.5, 8.3, 31.8)"), lambda state: state.has("Hero's Laurels", player))
    add_rule(world.get_location("Swamp - Back of Swamp Laurels Area Grass swamp (994) (33.5, 8.0, 31.8)"), lambda state: state.has("Hero's Laurels", player))
