# all of the descriptions come from DS2S META
# https://github.com/pseudostripy/DS2S-META/blob/master/DS2S%20META/Randomizer/CasualItemSet.cs

from typing import Optional, Dict, List, Set
from dataclasses import dataclass

@dataclass
class LocationData:
    code: int
    name: str
    default_items: list[str]
    sotfs: Optional[bool] = False   # whether the location is only in sotfs
    vanilla: Optional[bool] = False # whether the location is only in vanilla
    ngp: Optional[bool] = False  # whether the location is only in new game plus
    shop: Optional[bool] = False
    event: Optional[bool] = False
    skip: Optional[bool] = False # if true, dont place progression items in this location

location_table = {
    "Things Betwixt": [
        LocationData(10025010, "[Betwixt] Wooden chest at the attic of Fire Keeper's cottage", ['Human Effigy']),
        LocationData(10026000, "[Betwixt] On the right side ledge before Fire Keeper's cottage", ['Rusted Coin']),
        LocationData(10026001, "[Betwixt] On the right side ledge before Fire Keeper's cottage in NG+", ['Rusted Coin'], ngp=True),
        LocationData(10026020, "[Betwixt] Guarded by hippo before Fire Keeper's cottage", ['Gold Pine Resin']),
        LocationData(10026030, "[Betwixt] Under waterfall", ['Small Smooth & Silky Stone']),
        LocationData(10026031, "[Betwixt] Under waterfall in NG+", ['Smooth & Silky Stone'], ngp=True),
        LocationData(10026040, "[Betwixt] One ledge down from the crow nest", ['Soul of a Nameless Soldier']),
        LocationData(10026050, "[Betwixt] Behind the wagon next to bonfire", ['Soul of a Lost Undead', 'Torch']),
        LocationData(10026060, "[Betwixt] Behind a door in small alcove", ['Rotunda Lockstone']), # this is not the default item
        LocationData(10026070, "[Betwixt] On path after the backstab tutorial", ['Dagger']),
        LocationData(10026080, "[Betwixt] Next to fog gate and archer", ['Lifegem']),
        LocationData(10026090, "[Betwixt] Other side of the jumpable gap", ['Amber Herb']),
        LocationData(10026100, "[Betwixt] In the basilisk pit", ['Estus Flask Shard'], sotfs=True),
        # LocationData(10027000, "Bone of Order", ['Bone of Order']),
    ],
    "Majula": [
        LocationData(None, "Rotate the Majula Rotunda", None, event=True),
        LocationData(10045000, "[Majula] Wooden chest on the attic of Maughlin the Armorer", ['Titanite Shard']),
        LocationData(10045001, "[Majula] Wooden chest on the attic of Maughlin the Armorer in NG+1", ['Large Titanite Shard'], ngp=True),
        LocationData(10045002, "[Majula] Wooden chest on the attic of Maughlin the Armorer in NG+2", ['Moon Butterfly Shield'], ngp=True),
        LocationData(10045010, "[Majula] Wooden chest on the attic of Majula mansion", ['Titanite Shard', 'Torch']),
        LocationData(10045040, "[Majula] Wooden chest in Lenigrast's workshop", ['Short Bow']),
        LocationData(10045060, "[Majula] Metal chest on the way towards forest", ['Rusted Coin']),
        LocationData(10045070, "[Majula] Metal chest in staircase towards Heide's Tower of Flame", ['Crimson Parma']),
        # LocationData(10045500, "Rubbish", ['Rubbish']),
        LocationData(10045600, "[Majula] Metal chest in Cale's house basement", ['Soul Vessel']),
        LocationData(10046000, "[Majula] Majula well", ['Estus Flask Shard']),
        LocationData(10046010, "[Majula] Under the tree on the way from Things Betwixt", ['Divine Blessing']),
        LocationData(10046020, "[Majula] Drop from cliff (near vanilla binos)", ['Morning Star', "Cleric's Sacred Chime"]),
        LocationData(10046030, "[Majula] Drop from cliff and end of the path", ['Binoculars']),
        LocationData(10046040, "[Majula] Next to Lenigrast's workshop", ['Soul of a Nameless Soldier', 'Lifegem']),
        LocationData(10046070, "[Majula] Corpse in Cale's house basement", ['Estus Flask Shard']),
        LocationData(10046100, "[Majula] Library room in Cale's house", ["Pharros' Lockstone"]),
        LocationData(10046110, "[Majula] Next to Champion's covenant", ['Homeward Bone']),
        LocationData(10046120, "[Majula] Tent next to cat Shalquoir", ['Lifegem']),
        LocationData(10296000, "[Majula] In small room next to petrified Rosabeth", ["Lloyd's Talisman"]),
        LocationData(10296010, "[Majula] Corpse next to Benhart", ['Lifegem', 'Homeward Bone']),
        LocationData(70400004, "[Laddersmith Gilligan - Majula] Reinforced Club", ["Reinforced Club"], shop=True),
        LocationData(70400005, "[Laddersmith Gilligan - Majula] Claws", ["Claws"], shop=True),
        LocationData(70400006, "[Laddersmith Gilligan - Majula] Whip", ["Whip"], shop=True),
        LocationData(70400007, "[Laddersmith Gilligan - Majula] Wooden Shield", ["Wooden Shield"], shop=True),
        LocationData(70400204, "[Laddersmith Gilligan - Majula] Thief Mask", ["Thief Mask"], shop=True),
        LocationData(70400205, "[Laddersmith Gilligan - Majula] Black Leather Armor", ["Black Leather Armor"], shop=True),
        LocationData(70400206, "[Laddersmith Gilligan - Majula] Black Leather Gloves", ["Black Leather Gloves"], shop=True),
        LocationData(70400207, "[Laddersmith Gilligan - Majula] Black Leather Boots", ["Black Leather Boots"], shop=True),
        LocationData(70400501, "[Laddersmith Gilligan - Majula] Ladder Miniature", ["Ladder Miniature"], shop=True),
        # LocationData(70400603, "[Laddersmith Gilligan - Majula] Aromatic Ooze", ["Aromatic Ooze"], shop=True),
        # LocationData(70400604, "[Laddersmith Gilligan - Majula] Lacerating Knife", ["Lacerating Knife"], shop=True),
        # LocationData(70400605, "[Laddersmith Gilligan - Majula] Bleeding Serum", ["Bleeding Serum"], shop=True),
        # LocationData(75400601, "[Merchant Hag Melentia - Majula] Lifegem", ["Lifegem"], shop=True),
        LocationData(77700400, "[Sweet Shalquoir] Silvercat Ring", ["Silvercat Ring"], shop=True),
        LocationData(77700401, "[Sweet Shalquoir] Redeye ring", ["Redeye Ring"], shop=True),
        LocationData(77700402, "[Sweet Shalquoir] Name-engraved Ring", ["Name-engraved Ring"], shop=True),
        LocationData(77700403, "[Sweet Shalquoir] Ring of Whispers", ["Ring of Whispers"], shop=True),
        LocationData(77700404, "[Sweet Shalquoir] Ring of the Evil Eye", ["Ring of the Evil Eye"], shop=True),
        # LocationData(77700600, "[Sweet Shalquoir] Prism Stone", ["Prism Stone"], shop=True),
        # LocationData(77700601, "[Sweet Shalquoir] Alluring Skull", ["Alluring Skull"], shop=True),
        # LocationData(77700602, "[Sweet Shalquoir] Lloyd's Talisman", ["Lloyd's Talisman"], shop=True),
        # LocationData(77700603, "[Sweet Shalquoir] Homeward Bone", ["Homeward Bone"], shop=True),
        # LocationData(77700604, "[Sweet Shalquoir - Shrine of Winter] Prism Stone", ["Prism Stone"], shop=True),
        # LocationData(77700605, "[Sweet Shalquoir - Shrine of Winter] Alluring Skull", ["Alluring Skull"], shop=True),
        # LocationData(77700606, "[Sweet Shalquoir - Shrine of Winter] Lloyd's Talisman", ["Lloyd's Talisman"], shop=True),
        # LocationData(77700607, "[Sweet Shalquoir - Shrine of Winter] Homeward Bone", ["Homeward Bone"], shop=True),
        LocationData(76100000, "[Maughlin the Armourer] Iron Parma", ["Iron Parma"], shop=True),
        LocationData(76100001, "[Maughlin the Armourer] Silver Eagle Kite Shield", ["Silver Eagle Kite Shield"], shop=True),
        LocationData(76100002, "[Maughlin the Armourer] Twin Dragon Greatshield", ["Twin Dragon Greatshield"], shop=True),
        LocationData(76100200, "[Maughlin the Armourer] Standard Helm", ["Standard Helm"], shop=True),
        LocationData(76100201, "[Maughlin the Armourer] Hard Leather Armor", ["Hard Leather Armor"], shop=True),
        LocationData(76100202, "[Maughlin the Armourer] Hard Leather Gauntlets", ["Hard Leather Gauntlets"], shop=True),
        LocationData(76100203, "[Maughlin the Armourer] Hard Leather Boots", ["Hard Leather Boots"], shop=True),
        LocationData(76100204, "[Maughlin the Armourer] Falconer Helm", ["Falconer Helm"], shop=True),
        LocationData(76100205, "[Maughlin the Armourer] Falconer Armor", ["Falconer Armor"], shop=True),
        LocationData(76100206, "[Maughlin the Armourer] Falconer Gloves", ["Falconer Gloves"], shop=True),
        LocationData(76100207, "[Maughlin the Armourer] Falconer Boots", ["Falconer Boots"], shop=True),
        LocationData(76100208, "[Maughlin the Armourer] Infantry Armor", ["Infantry Armor"], shop=True),
        LocationData(76100209, "[Maughlin the Armourer] Infantry Gloves", ["Infantry Gloves"], shop=True),
        LocationData(76100210, "[Maughlin the Armourer] Infantry Boots", ["Infantry Boots"], shop=True),
        LocationData(76300300, "[Rosabeth of Melfia] Fireball", ["Fireball"], shop=True),
        LocationData(76300301, "[Rosabeth of Melfia] Fire Orb", ["Fire Orb"], shop=True),
        LocationData(76300302, "[Rosabeth of Melfia] Combustion", ["Combustion"], shop=True),
        LocationData(76300303, "[Rosabeth of Melfia] Poison Mist", ["Poison Mist"], shop=True),
        LocationData(76300304, "[Rosabeth of Melfia] Flash Sweat", ["Flash Sweat"], shop=True),
        LocationData(76300305, "[Rosabeth of Melfia] Iron Flesh", ["Iron Flesh"], shop=True),
        LocationData(76300400, "[Rosabeth of Melfia] Flame Quartz Ring", ["Flame Quartz Ring"], shop=True),
        LocationData(76300401, "[Rosabeth of Melfia] Thunder Quartz Ring", ["Thunder Quartz Ring"], shop=True),
        LocationData(76300402, "[Rosabeth of Melfia] Dark Quartz Ring", ["Dark Quartz Ring"], shop=True),
        # LocationData(76300600, "[Rosabeth of Melfia] Small Blue Burr", ["Small Blue Burr"], shop=True),
        # LocationData(76300601, "[Rosabeth of Melfia] Small Yellow Burr", ["Small Yellow Burr"], shop=True),
        # LocationData(76300602, "[Rosabeth of Melfia] Small Orange Burr", ["Small Orange Burr"], shop=True),
        # LocationData(76300603, "[Rosabeth of Melfia] Fire Seed", ["Fire Seed"], shop=True),
        LocationData(76400000, "[Blacksmith Lenigrast] Longsword", ["Longsword"], shop=True),
        LocationData(76400001, "[Blacksmith Lenigrast] Broadsword", ["Broadsword"], shop=True),
        LocationData(76400002, "[Blacksmith Lenigrast] Estoc", ["Estoc"], shop=True),
        LocationData(76400003, "[Blacksmith Lenigrast] Rapier", ["Rapier"], shop=True),
        LocationData(76400004, "[Blacksmith Lenigrast] Falchion", ["Falchion"], shop=True),
        LocationData(76400005, "[Blacksmith Lenigrast] Battle Axe", ["Battle Axe"], shop=True),
        LocationData(76400006, "[Blacksmith Lenigrast] Mace", ["Mace"], shop=True),
        LocationData(76400007, "[Blacksmith Lenigrast] Spear", ["Spear"], shop=True),
        # LocationData(76400600, "[Blacksmith Lenigrast] Wood Arrow", ["Wood Arrow"], shop=True),
        # LocationData(76400601, "[Blacksmith Lenigrast] Iron Arrow", ["Iron Arrow"], shop=True),
        # LocationData(76400602, "[Blacksmith Lenigrast] Wood Bolt", ["Wood Bolt"], shop=True),
        # LocationData(76400603, "[Blacksmith Lenigrast] Heavy Bolt", ["Heavy Bolt"], shop=True),
        # LocationData(76400604, "[Blacksmith Lenigrast] Titanite Shard", ["Titanite Shard"], shop=True),
        LocationData(76400605, "[Blacksmith Lenigrast] Repair Powder", ["Repair Powder"], shop=True),
    ],
    "Forest of Fallen Giants": [
        LocationData(None, "Defeat the Last Giant", None, event=True),
        LocationData(309600, "[FOFG] Last Giant drop", ['Soul of the Last Giant', 'Soldier Key']),
        LocationData(1751000, "[FOFG] Gift from Cale when talking to him", ['House Key'], skip=True),
        LocationData(10105010, "[FOFG] Wooden chest in upper floor of cardinal tower", ['Small Leather Shield', 'Repair Powder']),
        LocationData(10105020, "[FOFG] Wooden chest under the bridge after the drawgate", ['Human Effigy']),
        LocationData(10105021, "[FOFG] Wooden chest under the bridge after the drawgate in NG+", ['Human Effigy'], ngp=True),
        LocationData(10105030, "[FOFG] Metal chest in the side room under the ballista-trap", ['Life Ring', 'Large Titanite Shard']),
        LocationData(10105040, "[FOFG] Trapped wooden chest under the ballista-trap", ['Titanite Shard']),
        LocationData(10105041, "[FOFG] Trapped wooden chest under the ballista-trap in NG+", ['Titanite Chunk'], ngp=True),
        LocationData(10105070, "[FOFG] Metal chest in upper floor of cardinal tower", ['Estus Flask Shard', 'Small White Sign Soapstone'], vanilla=True),
        LocationData(10105070, "[FOFG] Metal chest in upper floor of cardinal tower", ['Small White Sign Soapstone', 'Radiant Lifegem'], sotfs=True),
        LocationData(10105080, "[FOFG] First metal chest behind Pharros' contraption under the ballista-trap", ['Chloranthy Ring']),
        LocationData(10105090, "[FOFG] Second metal chest behind Pharros' contraption under the ballista-trap", ['Titanite Slab']),
        LocationData(10105100, "[FOFG] Metal chest in the guard room over the barrel courtyard", ['Mail Breaker', 'Infantry Helm']),
        LocationData(10105130, "[FOFG] Metal chest in the tunnel where you get fireballed by a salamander", ['Longsword']),
        LocationData(10105140, "[FOFG] Metal chest behind a illusory wall after the gate trap room", ["Sorcerer's Staff", 'Amber Herb']),
        LocationData(10106000, "[FOFG] At the end of the small stream", ['Soul of a Lost Undead']),
        LocationData(10106020, "[FOFG] At the right of the water stream right before the bonfire", ['Lifegem'], vanilla=True),
        LocationData(10106030, "[FOFG] Next to turtle in seashore hall", ['Amber Herb']),
        LocationData(10106050, "[FOFG] Drop onto tree branch from upper floor of Cardinal Tower", ['Divine Blessing']),
        LocationData(10106060, "[FOFG] Behind a shelf in small side room after the first fog gate", ['Wood Bolt']),
        LocationData(10106061, "[FOFG] Behind a shelf in small side room after the first fog gate in NG+", ['Heavy Bolt'], ngp=True),
        LocationData(10106090, "[FOFG] Above the door leading to Pursuer arena", ['Lifegem', 'Homeward Bone']),
        LocationData(10106100, "[FOFG] On the huge sword", ['Halberd', 'Soul of a Nameless Soldier']),
        LocationData(10106110, "[FOFG] Corpse in the watery cave in the beginning of the area", ['Homeward Bone', 'Soul of a Lost Undead']),
        LocationData(10106140, "[FOFG] Behind the soldier that stands on tree root and throws fire bombs just before Cardinal Tower", ['Buckler']),
        LocationData(10106150, "[FOFG] Just before Cale on boulder path", ['Human Effigy']),
        LocationData(10106160, "[FOFG] At corridor after the gate trap", ['Aromatic Ooze']),
        LocationData(10106170, "[FOFG] On higher level requiring a jump from area before first fog gate", ['Soul of a Nameless Soldier', 'Throwing Knife']),
        LocationData(10106180, "[FOFG] Behind the stairs outside the ballista trap room", ['Green Blossom']),
        LocationData(10106190, "[FOFG] Behind the giant-tree in the middle courtyard", ['Large Soul of a Lost Undead']),
        LocationData(10106200, "[FOFG] On upper ledge of the circular room before the first fog gate", ['Shortsword', 'Soul of a Lost Undead']),
        LocationData(10106210, "[FOFG] On a giant tree root", ['Soul of a Lost Undead', 'Torch']),
        LocationData(10106220, "[FOFG] On the wall after climbing the ladder by Memory of Vammar", ['Light Crossbow']),
        LocationData(10106230, "[FOFG] A corpse in the circular room before the first fog gate", ['Broken Straight Sword']),
        LocationData(10106240, "[FOFG] In the round tower where you drop from a tree root", ['Torch']),
        LocationData(10106250, "[FOFG] Lower end of dead end stairs near the seaside fog gate", ['Large Leather Shield', 'Lifegem']),
        LocationData(10106260, "[FOFG] A corpse in the circular room before the first fog gate (2)", ['Human Effigy']),
        LocationData(10106270, "[FOFG] On ledge near the scaffolding in front of Cardinal Tower", ['Human Effigy']),
        LocationData(10106280, "[FOFG] A corpse in the circular room before the first fog gate (3)", ['Lifegem']),
        LocationData(10106300, "[FOFG] On the other end of the small bridge going over the fire area", ['Soul of a Lost Undead']),
        LocationData(10106320, "[FOFG] On ledge next to Cale", ['Amber Herb']),
        LocationData(10106321, "[FOFG] On ledge next to Cale in NG+", ['Wilted Dusk Herb'], ngp=True),
        LocationData(10106340, "[FOFG] On floor just outside the lower Salamander pit exit", ['Soul of a Proud Knight']),
        LocationData(10106380, "[FOFG] On topmost ledge of the circular room", ['Soul of a Nameless Soldier']),
        LocationData(10106390, "[FOFG] Behind corner outside cardinal tower", ['Witching Urn']),
        LocationData(10106400, "[FOFG] In front of the pile of garbage that blocks the big gate to the fire area", ['Lifegem']),
        LocationData(10106410, "[FOFG] Next to upper level of the elevator", ['Fire Arrow']),
        LocationData(10106440, "[FOFG] In the middle of the ballista trap area", ['Great Soul Arrow']),
        LocationData(10106450, "[FOFG] In the middle of the ballista trap area (2)", ['Large Soul of a Lost Undead', 'Blue Wooden Shield']),
        LocationData(10106490, "[FOFG] Behind the wagon at Cardinal Tower upper floor", ['Hand Axe', 'Radiant Lifegem']),
        LocationData(10106500, "[FOFG] On wooden floor boards above the guard room over the courtyard", ['Soul of a Nameless Soldier', 'Torch']),
        LocationData(10106520, "[FOFG] Second corpse on the platform where you meet pursuer for first time", ['Estus Flask Shard'], sotfs=True),
        LocationData(10106530, "[FOFG] Third corpse on the platform where you meet pursuer for first time", ['Human Effigy', 'Lifegem'], sotfs=True),
        LocationData(10106540, "[FOFG] Fourth corpse on the platform where you meet pursuer for first time", ['Torch'], sotfs=True),
        LocationData(10106550, "[FOFG] First corpse on the platform where you meet pursuer for first time", ['Repair Powder'], sotfs=True),
        LocationData(10106560, "[FOFG] At the hole in the wall before cardinal tower", ['Lifegem'], sotfs=True),
        LocationData(10106570, "[FOFG] Behind a table at cardinal tower upper floor", ['Hollow Soldier Helm'], sotfs=True),
        LocationData(10106580, "[FOFG] A corpse in the circular room before the first fog gate (4)", ['Broken Straight Sword'], sotfs=True),
        LocationData(10106590, "[FOFG] A corpse in the circular room before the first fog gate (5)", ['Green Blossom'], sotfs=True),
        LocationData(10106600, "[FOFG] Under a tree above the small tunnel guarded by turtle", ['Prism Stone'], sotfs=True),
        LocationData(75400000, "[Merchant Hag Melentia] Broken Straight Sword", ["Broken Straight Sword"], shop=True),
        LocationData(75400001, "[Merchant Hag Melentia] Hand Axe", ["Hand Axe"], shop=True),
        LocationData(75400002, "[Merchant Hag Melentia] Club", ["Club"], shop=True),
        LocationData(75400003, "[Merchant Hag Melentia] Caestus", ["Caestus"], shop=True),
        LocationData(75400200, "[Merchant Hag Melentia] Traveling Merchant Hat", ["Traveling Merchant Hat"], shop=True),
        LocationData(75400201, "[Merchant Hag Melentia] Traveling Merchant Coat", ["Traveling Merchant Coat"], shop=True),
        LocationData(75400202, "[Merchant Hag Melentia] Traveling Merchant Gloves", ["Traveling Merchant Gloves"], shop=True),
        LocationData(75400203, "[Merchant Hag Melentia] Traveling Merchant Boots", ["Traveling Merchant Boots"], shop=True),
        LocationData(75400300, "[Merchant Hag Melentia] Soul Arrow", ["Soul Arrow"], shop=True),
        LocationData(75400301, "[Merchant Hag Melentia] Heal", ["Heal"], shop=True),
        LocationData(75400500, "[Merchant Hag Melentia] Lenigrast's Key", ["Lenigrast's Key"], shop=True),
        # LocationData(75400600, "[Merchant Hag Melentia - Forest of Fallen Giants] Lifegem", ["Lifegem"], shop=True),
        # LocationData(75400602, "[Merchant Hag Melentia - Lost Sinner] Radiant Lifegem", ["Radiant Lifegem"], shop=True),
        # LocationData(75400603, "[Merchant Hag Melentia] Amber Herb", ["Amber Herb"], shop=True),
        # LocationData(75400604, "[Merchant Hag Melentia] Throwing Knife", ["Throwing Knife"], shop=True),
        # LocationData(75400605, "[Merchant Hag Melentia] Witching Urn", ["Witching Urn"], shop=True),
        # LocationData(75400606, "[Merchant Hag Melentia] Firebomb", ["Firebomb"], shop=True),
        # LocationData(75400607, "[Merchant Hag Melentia] Human Effigy", ["Human Effigy"], shop=True),
        LocationData(75400608, "[Merchant Hag Melentia] Pharros' Lockstone", ["Pharros' Lockstone"], shop=True),
        # LocationData(75400609, "[Merchant Hag Melentia] Brightbug", ["Brightbug"], shop=True),
        LocationData(75400615, "[Merchant Hag Melentia] Fragrant Branch of Yore", ["Fragrant Branch of Yore"], shop=True, sotfs=True),
    ],
    "FOFG - Salamander Pit": [
        LocationData(10105110, "[FOFG] Metal chest in the top-level of Salamander pit", ['Flame Quartz Ring+1']),
        LocationData(10106310, "[FOFG] In small tunnel guarded by turtle", ['Hollow Soldier Helm'], vanilla=True),
        LocationData(10106310, "[FOFG] In small tunnel guarded by turtle", ['Foot Soldier Shield'], sotfs=True),
        LocationData(10106350, "[FOFG] First corpse in the lower fire area", ['Cracked Red Eye Orb']),
        LocationData(10106360, "[FOFG] Second corpse in the lower fire area", ["Rebel's Greatshield"], vanilla=True),
        LocationData(10106360, "[FOFG] Second corpse in the lower fire area", ["Rebel's Greatshield", 'Heavy Iron Key'], sotfs=True),
        LocationData(10106460, "[FOFG] First corpse in the upper fire area", ['Firedrake Stone']),
        LocationData(10106470, "[FOFG] Second corpse in the upper fire area", ['Hawk Ring']),
        LocationData(10106480, "[FOFG] Third corpse in the upper fire area", ['Large Soul of a Proud Knight']),
    ],
    "FOFG - Soldier Key": [
        LocationData(None, "Defeat the Pursuer (in the proper arena)", None, event=True),
        LocationData(318000, "[FOFG] Pursuer (in the proper arena) drop", ['Soul of the Pursuer', 'Ring of Blades'], skip=True),
        LocationData(10105050, "[FOFG] Wooden chest in a side corridor on the way to the king's door", ['Ring of Restoration', 'Torch']),
        LocationData(10105150, "[FOFG] Wooden chest next to king's door", ['Amber Herb'], sotfs=True),
        LocationData(10105120, "[FOFG] Wooden chest near Soldier's Rest bonfire", ['Large Soul of a Proud Knight', "Hunter's Hat", 'Leather Armor', 'Leather Gloves', 'Leather Boots']),
        LocationData(10106010, "[FOFG] First corpse at rooftop near Soldier's Rest bonfire", ['Soul of a Nameless Soldier', 'Cracked Red Eye Orb']),
        LocationData(10106070, "[FOFG] In the beginning of the dark skeleton tunnel", ['Black Firebomb', 'Homeward Bone']),
        LocationData(10106080, "[FOFG] At the end of the dark skeleton tunnel", ['Torch']),
        LocationData(10106120, "[FOFG] In the small stone house near Soldier's Rest bonfire", ['Bastard Sword'], vanilla=True),
        LocationData(10106120, "[FOFG] In the small stone house near Soldier's Rest bonfire", ['Human Effigy'], sotfs=True),
        LocationData(10106130, "[FOFG] Next to ruined house by water near Soldier's Rest", ['Titanite Shard']),
        LocationData(10106290, "[FOFG] In a crevasse in floor near the eagles nest", ['Drangleic Sword', 'Drangleic Shield', 'Drangleic Mail', 'Drangleic Gauntlets', 'Drangleic Leggings']),
        LocationData(10106370, "[FOFG] Just before pursuer arena", ['Soul of a Nameless Soldier', 'Lifegem']),
        LocationData(10106371, "[FOFG] Just before pursuer arena in NG+", ['Large Soul of a Proud Knight', 'Old Radiant Lifegem'], ngp=True),
        LocationData(10106430, "[FOFG] Next to portcullis near Soldier's rest bonfire", ['Amber Herb', 'Green Blossom']),
        LocationData(10106510, "[FOFG] Corpse next to king's door", ['Grand Lance'], sotfs=True),
        LocationData(10106610, "[FOFG] Second corpse at rooftop near Soldier's Rest bonfire", ['Bastard Sword'], sotfs=True),
        LocationData(10106620, "[FOFG] Third corpse at rooftop near Soldier's Rest bonfire", ['Whip'], sotfs=True),
        LocationData(10106630, "[FOFG] Fourth corpse at rooftop near Soldier's Rest bonfire", ['Human Effigy'], sotfs=True),
        LocationData(10106420, "[FOFG] On scaffolding near the Place Unbeknownst bonfire", ['Twinkling Titanite'], vanilla=True),
        LocationData(10106420, "[FOFG] On scaffolding near the Place Unbeknownst bonfire", ['Twinkling Titanite', 'Fragrant Branch of Yore'], sotfs=True),
    ],
    "Brightstone Cove": [
        LocationData(106000, "[Tseldora] Prowling Magus and Congregation drop", ['Titanite Slab']),
        LocationData(None, "Defeat the Duke's Dear Freja", None, event=True),
        LocationData(603000, "[Tseldora] Duke's Dear Freja drop", ["Soul of the Duke's Dear Freja"]),
        LocationData(603001, "[Tseldora] Duke's Dear Freja drop in NG+", ["Soul of the Duke's Dear Freja", 'Old Paledrake Soul'], ngp=True),
        LocationData(1140300, "[Tseldora] Drop from Duke Tseldora after Freja", ['Brightstone Key', 'Fragrant Branch of Yore', 'Dark Quartz Ring+1'], skip=True),
        LocationData(1742000, "[Tseldora] Gift from Pate or Creighton when helping in the fight against the other", ['Tseldora Den Key'], skip=True),
        LocationData(10145050, "[Tseldora] Wooden chest inside the small house in falconer camp", ['Human Effigy'], vanilla=True),
        LocationData(10145060, "[Tseldora] Spider-trapped wooden chest before Congregation", ['Heavy Bolt']),
        LocationData(10145061, "[Tseldora] Spider-trapped wooden chest before Congregation in NG+", ['Magic Bolt'], ngp=True),
        LocationData(10145070, "[Tseldora] Wooden chest in Tseldora den", ['Rusted Coin']),
        LocationData(10145080, "[Tseldora] Metal chest in Tseldora den", ['Engraved Gauntlets']),
        LocationData(10145110, "[Tseldora] Metal chest in secret alcove behind shelf in room next to Ornifex's Tseldora room", ['Crescent Axe', 'Soul Vortex']),
        LocationData(10145120, "[Tseldora] Metal chest on lowerable platform", ['Southern Ritual Band+1']),
        LocationData(10145130, "[Tseldora] Metal chest behind locked door in pickaxe room", ['Black Knight Ultra Greatsword', 'Great Fireball', 'Fire Seed']),
        LocationData(10146000, "[Tseldora] Behind a bench in the pickaxe room", ['Soul of a Hero', 'Gold Pine Resin']),
        LocationData(10146010, "[Tseldora] In urn in Ornifex's Tseldora room", ["Pharros' Lockstone"]),
        LocationData(10146020, "[Tseldora] On a corpse next to Cromwell", ['Fading Soul', "Cleric's Small Shield"]),
        LocationData(10146030, "[Tseldora] On balcony of the house just before the spiky mining field", ['Large Titanite Shard']),
        LocationData(10146040, "[Tseldora] Hanging from window behind illusory wall before congregation", ['Estus Flask Shard'], vanilla=True),
        LocationData(10146040, "[Tseldora] Hanging from window behind illusory wall before congregation", ['Priestess Headpiece', 'Priestess Robe', 'Priestess Gloves', 'Priestess Skirt'], sotfs=True),
        LocationData(10146050, "[Tseldora] Hanging on side of the well in falconer camp", ['Titanite Shard']),
        LocationData(10146051, "[Tseldora] Hanging on side of the well in falconer camp in NG+", ['Titanite Shard', 'Large Titanite Shard'], ngp=True),
        LocationData(10146060, "[Tseldora] A corpse around miner in falconer camp", ['Soul of a Nameless Soldier']),
        LocationData(10146070, "[Tseldora] On ledge before the first spider-decorated door", ['Large Titanite Shard']),
        LocationData(10146080, "[Tseldora] Under the stairs next to Chapel Threshold bonfire", ['Soul of a Proud Knight']),
        LocationData(10146090, "[Tseldora] On ledge above the sand whirlpool", ['Titanite Chunk', 'Twinkling Titanite']),
        LocationData(10146100, "[Tseldora] On roof of a house next to the sand whirlpool", ['Large Titanite Shard']),
        LocationData(10146110, "[Tseldora] A corpse around miner in falconer camp (2)", ['Soul of a Nameless Soldier']),
        LocationData(10146120, "[Tseldora] On ledge guarded by parasitized undead", ['Titanite Chunk']),
        LocationData(10146130, "[Tseldora] In the well in falconer camp", ['Holy Water Urn']),
        LocationData(10146140, "[Tseldora] A corpse around miner in falconer camp (3)", ['Soul of a Nameless Soldier']),
        LocationData(10146150, "[Tseldora] A corpse around miner in falconer camp (4)", ['Large Soul of a Proud Knight']),
        LocationData(10146160, "[Tseldora] On path under the first boulder", ['Soul of a Nameless Soldier']),
        LocationData(10146170, "[Tseldora] Room on upper floor from Lower Brightstone Cove bonfire", ['Lightning Urn']),
        LocationData(10146180, "[Tseldora] In back room between the two sand areas", ['Titanite Chunk']),
        LocationData(10146181, "[Tseldora] In back room between the two sand areas in ng+", ['Titanite Chunk', 'Titanite Slab'], ngp=True),
        LocationData(10146190, "[Tseldora] Behind shelf in Ornifex's Tseldora room", ['Flame Butterfly']),
        LocationData(10146200, "[Tseldora] In a house next to the sand whirlpool", ['Estus Flask Shard']),
        LocationData(10146210, "[Tseldora] In a house in cliffside above the sand whirlpool", ['Large Titanite Shard']),
        LocationData(10146220, "[Tseldora] On mini staircase in room after pate/creighton fight", ['Torch']),
        LocationData(10146230, "[Tseldora] In urn next to the ruined house in falconer camp", ['Large Soul of a Nameless Soldier']),
        LocationData(10146240, "[Tseldora] On a corpse next to Cromwell (2)", ['Fading Soul']),
        LocationData(10146250, "[Tseldora] On a corpse next to Cromwell (3)", ["Skeptic's Spice"]),
        LocationData(10146260, "[Tseldora] On a corpse next to Cromwell (4)", ['Bonfire Ascetic']),
        LocationData(10146270, "[Tseldora] On a corpse next to Cromwell (5)", ['Fading Soul']),
        LocationData(10146280, "[Tseldora] In the right side alcove of the pickaxe room", ['Homeward Bone']),
        LocationData(10146290, "[Tseldora] On top of the wooden tower in falconer camp", ['Lacerating Arrow']),
        LocationData(10146300, "[Tseldora] In urn in the first room on a way from doors of pharros", ['Radiant Lifegem']),
        LocationData(10146310, "[Tseldora] In urn in the first room after Chapel Threshold bonfire", ['Wilted Dusk Herb']),
        LocationData(10146320, "[Tseldora] In urn in room with pate/creighton fight", ['Charcoal Pine Resin']),
        LocationData(10146330, "[Tseldora] In urn on middle level of the web room before Freja", ["Pharros' Lockstone"]),
        LocationData(10146340, "[Tseldora] On middle level of the web room before Freja", ['Torch']),
        LocationData(10146350, "[Tseldora] On spider web in the web room before Freja", ['Radiant Lifegem']),
        LocationData(10146360, "[Tseldora] Behind pilar in the lowest level of the web room before Freja", ['Corrosive Urn']),
        LocationData(10146370, "[Tseldora] Under spider web in the web room before Freja", ["Simpleton's Spice"]),
        LocationData(10146380, "[Tseldora] On middle level of the web room before Freja (2)", ['Twilight Herb']),
        LocationData(10146381, "[Tseldora] On middle level of the final hall before Freja in NG+", ['Wilted Dusk Herb'], ngp=True),
        LocationData(10146390, "[Tseldora] Next to a boulder in the beginning of the area", ['Soul of a Brave Warrior']),
        LocationData(10146400, "[Tseldora] On ground close to the sand whirlpool", ['Petrified Dragon Bone']),
        LocationData(10146410, "[Tseldora] A corpse in the spiky mining field", ['Torch'], sotfs=True),
        LocationData(10146420, "[Tseldora] A corpse in the spiky mining field (2)", ['Titanite Shard', 'Titanite Chunk', 'Titanite Slab'], sotfs=True),
        LocationData(10146480, "[Tseldora] In urn next to Congregation foggate", ['Human Effigy'], sotfs=True),
        LocationData(10146490, "[Tseldora] In urn on right side when leaving Congregation fight", ['Cracked Red Eye Orb'], sotfs=True),
        LocationData(10146500, "[Tseldora] Guide a pig from the campsite to lower tseldora and let it eat mushrooms", ['Pickaxe'], skip=True),
        LocationData(10146510, "[Tseldora] In urn in the 2nd floor of a house just before the spiky mining field", ['Torch'], sotfs=True),
        LocationData(10146520, "[Tseldora] In urn in the pickaxe room", ['Poison Arrow'], sotfs=True),
        LocationData(78400200, "[Cromwell the Pardoner] White Priest Headpiece", ["White Priest Headpiece"], shop=True),
        LocationData(78400201, "[Cromwell the Pardoner] White Priest Robe", ["White Priest Robe"], shop=True),
        LocationData(78400202, "[Cromwell the Pardoner] White Priest Gloves", ["White Priest Gloves"], shop=True),
        LocationData(78400203, "[Cromwell the Pardoner] White Priest Skirt", ["White Priest Skirt"], shop=True),
        LocationData(78400300, "[Cromwell the Pardoner] Great Heal", ["Great Heal"], shop=True),
        LocationData(78400301, "[Cromwell the Pardoner] Replenishment", ["Replenishment"], shop=True),
        LocationData(78400302, "[Cromwell the Pardoner] Caressing Prayer", ["Caressing Prayer"], shop=True),
        LocationData(78400303, "[Cromwell the Pardoner] Force", ["Force"], shop=True),
        LocationData(78400304, "[Cromwell the Pardoner] Emit Force", ["Emit Force"], shop=True),
        LocationData(78400305, "[Cromwell the Pardoner] Heavenly Thunder", ["Heavenly Thunder"], shop=True),
        LocationData(78400306, "[Cromwell the Pardoner] Perseverance", ["Perseverance"], shop=True),
        LocationData(78400307, "[Cromwell the Pardoner] Scraps of Life", ["Scraps of Life"], shop=True),
        LocationData(78400400, "[Cromwell the Pardoner] Poisonbite Ring", ["Poisonbite Ring"], shop=True),
        LocationData(78400401, "[Cromwell the Pardoner] Bloodbite Ring", ["Bloodbite Ring"], shop=True),
        LocationData(78400402, "[Cromwell the Pardoner] Cursebite Ring", ["Cursebite Ring"], shop=True),
        # LocationData(78400600, "[Cromwell the Pardoner] Dark Troches", ["Dark Troches"], shop=True),
    ],
    "Aldia's Keep": [
        LocationData(212000, "[AldiasKeep] Guardian Dragon drop", ['Guardian Dragon Soul']),
        LocationData(1157000, "[AldiasKeep] Drop from Petrified Undead Traveller just before Giant Basilisk", ['Bonfire Ascetic'], skip=True),
        LocationData(1157100, "[AldiasKeep] Drop from Centre petrified Undead Traveller just before Giant Basilisk", ['Wilted Dusk Herb', 'Elizabeth Mushroom'], skip=True),
        LocationData(1150000, "[AldiasKeep] Drop from Petrified Ogre blocking stairway near Bone Dragon", ['Dragon Acolyte Mask'], skip=True),
        LocationData(1153100, "[AldiasKeep] Drop from Mimic trapped in final hanging cage in corridor with paintings", ['Fragrant Branch of Yore'], sotfs=True, skip=True),
        LocationData(10155000, "[AldiasKeep] Metal chest in a side corridor next to the mirror room", ['Great Magic Barrier']),
        LocationData(10155010, "[AldiasKeep] Metal chest in a side corridor next to the giant basilisk", ['Bonfire Ascetic']),
        LocationData(10155020, "[AldiasKeep] Metal chest behind the breakable chained door", ['Malformed Shell']),
        LocationData(10155030, "[AldiasKeep] Metal chest in the mirror room", ['Brightbug'], sotfs=True),
        LocationData(10156000, "[AldiasKeep] In front of the skeleton dragon", ['Fading Soul']),
        LocationData(10156010, "[AldiasKeep] In the mirror room", ['Northern Ritual Band+2', 'Petrified Dragon Bone']),
        LocationData(10156020, "[AldiasKeep] In the foregarden courtyard", ['Alluring Skull']),
        LocationData(10156030, "[AldiasKeep] Under a table in the long corridor", ['Radiant Lifegem']),
        LocationData(10156031, "[AldiasKeep] Under a table in the long corridor in NG+", ['Elizabeth Mushroom'], ngp=True),
        LocationData(10156040, "[AldiasKeep] Inside a barrel in the corner in side room with caged Gargoyle", ['Large Soul of a Brave Warrior']),
        LocationData(10156050, "[AldiasKeep] Room just before Guardian dragon", ["Simpleton's Spice", 'Twilight Herb']),
        LocationData(10156060, "[AldiasKeep] In front of the giant basilisk", ['Crimson Water']),
        LocationData(10156070, "[AldiasKeep] In the acid pool", ['Soul Geyser', 'Petrified Dragon Bone']),
        LocationData(10156080, "[AldiasKeep] In the Foregarden courtyard", ['Poison Throwing Knife']),
        LocationData(10156090, "[AldiasKeep] To the right at the start of the Foregarden courtyard stairs", ['Fire Seed']),
        LocationData(10156100, "[AldiasKeep] In the acid pool (2)", ['Aldia Key'], vanilla=True),
        LocationData(10156100, "[AldiasKeep] In the acid pool (2)", ['Divine Blessing'], sotfs=True),
        LocationData(10156130, "[AldiasKeep] Behind a shelf in the potion room", ["Pharros' Lockstone"]),
        LocationData(10156140, "[AldiasKeep] On table in side room with caged Gargoyle", ['Soul of a Proud Knight']),
        LocationData(10156150, "[AldiasKeep] Just before the elevator to the dragon aerie", ['Dragon Scale']),
        LocationData(10156160, "[AldiasKeep] In the acid pool (3)", ['Large Soul of a Nameless Soldier', 'Corrosive Urn']),
        LocationData(10156161, "[AldiasKeep] In the acid pool in NG+", ['Soul of a Hero', 'Corrosive Urn'], ngp=True),
        LocationData(10156170, "[AldiasKeep] In the Foregarden courtyard (2)", ['Soul of a Nameless Soldier', 'Petrified Dragon Bone']),
        LocationData(10156180, "[AldiasKeep] In the water-feature in the middle of the stairs approaching Aslatiel", ['Radiant Lifegem']),
        LocationData(10156190, "[AldiasKeep] In the left side of the front door", ['Twilight Herb']),
        LocationData(10156200, "[AldiasKeep] Stuck in a mirror in the mirror room", ['Large Soul of a Brave Warrior'], sotfs=True),
        LocationData(60050000, "[AldiasKeep] Drop from the Skeleton Dragon after defeating four Forlorns", ["Aldia Key"], sotfs=True),
    ],
    "Belfry Luna": [
        LocationData(324000, "[BelfryLuna] Belfry Gargoyles drop", ['Belfry Gargoyle Soul']),
        LocationData(324001, "[BelfryLuna] Belfry Gargoyles drop in NG+", ['Belfry Gargoyle Soul', 'Covetous Gold Serpent Ring+2'], ngp=True),
        LocationData(10165200, "[BelfryLuna] Wooden chest at topmost floor", ['Radiant Lifegem', 'Twilight Herb']),
        LocationData(10165220, "[BelfryLuna] Metal chest after dropping through hole from 2nd floor", ['Blue Tearstone Ring']),
        LocationData(10165230, "[BelfryLuna] Metal chest after Gargoyles", ['Southern Ritual Band']),
        LocationData(10166140, "[BelfryLuna] On railing 2nd floor", ["Skeptic's Spice"]),
        LocationData(10166160, "[BelfryLuna] Corpse after dropping through hole from 2nd floor", ["Skeptic's Spice"]),
        LocationData(10166170, "[BelfryLuna] Corpse on topmost floor", ["Skeptic's Spice"]),
        LocationData(10166250, "[BelfryLuna] At lower level in pit after Gargoyles", ['Bastille Key'], vanilla=True),
        LocationData(10166250, "[BelfryLuna] At lower level in pit after Gargoyles", ['Dragon Tooth', 'Petrified Something', 'Brightbug'], sotfs=True),
        LocationData(10166390, "[BelfryLuna] At upper level in pit after Gargoyles", ['Falchion']),
        LocationData(10166400, "[BelfryLuna] On ledge at Gargoyle arena", ['Soul of a Proud Knight']),
    ],
    "Sinners' Rise":[
        LocationData(None, "Defeat the Lost Sinner", None, event=True),
        LocationData(626000, "[SinnersRise] Lost Sinner drop", ['Soul of the Lost Sinner']),
        LocationData(626001, "[SinnersRise] Lost Sinner drop in NG+", ['Soul of the Lost Sinner', 'Old Witch Soul'], ngp=True),
        LocationData(10165120, "[SinnersRise] Metal chest after the lost sinner", ['Fragrant Branch of Yore', 'Elizabeth Mushroom']),
        LocationData(10166060, "[SinnersRise] On small ledge very near bonfire", ['Large Soul of a Lost Undead']),
        LocationData(10166090, "[SinnersRise] Right side just after bottom of elevator", ['Large Soul of a Nameless Soldier']),
        LocationData(10166110, "[SinnersRise] Item in elevator shaft", ['Lacerating Knife']),
        LocationData(10166120, "[SinnersRise] Left side just after bottom of elevator", ['Sublime Bone Dust'], vanilla=True),
        LocationData(10166120, "[SinnersRise] Left side just after bottom of elevator", ['Blossom Kite Shield'], sotfs=True),
        LocationData(10166230, "[SinnersRise] Behind illusory wall at right side just after elevator", ['Northern Ritual Band', 'Bleed Stone']),
        LocationData(10166280, "[SinnersRise] In open cell left side lower level", ['Soul of a Proud Knight', "Pharros' Lockstone"]),
        LocationData(10166330, "[SinnersRise] In locked cell left side upper level", ['Fire Seed']),
        LocationData(10166350, "[SinnersRise] In right side oil-sconce room just before the Sinner", ['Smooth & Silky Stone']),
        LocationData(10166360, "[SinnersRise] Left side just before the Sinner", ['Radiant Lifegem']),
        LocationData(10166450, "[SinnersRise] On ledge outside tower at top of elevator", ['Human Effigy']),
        LocationData(76100243, "[Maughlin the Armourer - Lost Sinner] Penal Mask", ["Penal Mask"], shop=True),
        LocationData(76100244, "[Maughlin the Armourer - Lost Sinner] Penal Straightjacket", ["Penal Straightjacket"], shop=True),
        LocationData(76100245, "[Maughlin the Armourer - Lost Sinner] Penal Handcuffs", ["Penal Handcuffs"], shop=True),
        LocationData(76100246, "[Maughlin the Armourer - Lost Sinner] Penal Skirt", ["Penal Skirt"], shop=True),
    ],
    "Lost Bastille - Wharf": [
        LocationData(10165050, "[Bastille] Metal chest behind in the dog/pursuer courtyard", ['Estus Flask Shard', 'Large Titanite Shard']),
        LocationData(10166010, "[Bastille] On top of the scaffolding in dog courtyard", ['Alluring Skull']),
        LocationData(10166030, "[Bastille] End of the rubble path", ['Soul of a Brave Warrior', 'Human Effigy']),
        LocationData(10166300, "[Bastille] Cell near Exile Holding Cells bonfire", ['Common Fruit']),
        LocationData(10166310, "[Bastille] In a room with explosive hollows near Antiquated door", ['Flame Butterfly']),
        LocationData(10166460, "[Bastille] In a cell at top of elevator ride after Flexile", ['Soul of a Proud Knight', 'Radiant Lifegem']),
        LocationData(10166470, "[Bastille] In hidden tunnel after riding down on top of the elevator after Flexile", ['Scimitar', 'Repair Powder']),
    ],
    "Lost Bastille - FOFG": [
        LocationData(10165140, "[Bastille] Metal chest where Pursuer attacks near the Tower Apart", ['Antiquated Key', 'Covetous Silver Serpent Ring'], vanilla=True),
        LocationData(10165140, "[Bastille] Metal chest where Pursuer attacks near the Tower Apart", ['Covetous Silver Serpent Ring', 'Human Effigy', 'Fragrant Branch of Yore'], sotfs=True),
        LocationData(10165250, "[Bastille] Metal chest next to tower apart bonfire", ['Human Effigy'], sotfs=True),
        LocationData(10165260, "[Bastille] Metal chest next to tower apart bonfire (2)", ['Dull Ember'], sotfs=True),
        LocationData(10166080, "[Bastille] On ledge near tower apart bonfire", ['Radiant Lifegem', 'Large Titanite Shard']),
    ],
    "Early Lost Bastille": [
        LocationData(10165150, "[Bastille] Metal chest in McDuff's workshop", ["Craftsman's Hammer", 'Twinkling Titanite']),
        LocationData(10165160, "[Bastille] First wooden chest in McDuff's workshop", ['Large Titanite Shard']),
        LocationData(10165170, "[Bastille] Second wooden chest in McDuff's workshop", ['Titanite Shard']),
        LocationData(10165180, "[Bastille] Third wooden chest in McDuff's workshop", ['Iron Arrow']),
        LocationData(10165190, "[Bastille] Fourth wooden chest in McDuff's workshop", ['Heavy Bolt']),
        LocationData(10165240, "[Bastille] Metal chest next to Lucatiel", ['Antiquated Key'], sotfs=True),
        LocationData(10166070, "[Bastille] On the left-hand-side on the way to mcduff", ['Gold Pine Resin']),
        LocationData(10166420, "[Bastille] Upper floor of tower above Lucatiel", ['Large Titanite Shard']),
        LocationData(10166421, "[Bastille] Upper floor of tower above Lucatiel in NG+", ['Large Titanite Shard'], ngp=True),
        LocationData(76430000, "[Steady Hand McDuff] Uchigatana", ["Uchigatana"], shop=True),
        LocationData(76430001, "[Steady Hand McDuff] Bastard Sword", ["Bastard Sword"], shop=True),
        LocationData(76430002, "[Steady Hand McDuff] Greataxe", ["Greataxe"], shop=True),
        LocationData(76430003, "[Steady Hand McDuff] Winged Spear", ["Winged Spear"], shop=True),
        LocationData(76430004, "[Steady Hand McDuff] Scythe", ["Scythe"], shop=True),
        LocationData(76430005, "[Steady Hand McDuff] Long Bow", ["Long Bow"], shop=True),
        LocationData(76430006, "[Steady Hand McDuff] Light Crossbow", ["Light Crossbow"], shop=True),
        LocationData(76430100, "[Steady Hand McDuff] Royal Kite Shield", ["Royal Kite Shield"], shop=True),
        # LocationData(76430600, "[Steady Hand McDuff] Wood Arrow", ["Wood Arrow"], shop=True),
        # LocationData(76430601, "[Steady Hand McDuff] Iron Arrow", ["Iron Arrow"], shop=True),
        # LocationData(76430602, "[Steady Hand McDuff] Wood Bolt", ["Wood Bolt"], shop=True),
        # LocationData(76430603, "[Steady Hand McDuff] Heavy Bolt", ["Heavy Bolt"], shop=True),
        # LocationData(76430604, "[Steady Hand McDuff] Iron Greatarrow", ["Iron Greatarrow"], shop=True),
        # LocationData(76430605, "[Steady Hand McDuff] Large Titanite Shard", ["Large Titanite Shard"], shop=True),
        LocationData(76430606, "[Steady Hand McDuff] Repair Powder", ["Repair Powder"], shop=True),
    ],
    "Lost Bastille - After Statue": [
        LocationData(325000, "[Bastille] Ruin sentinels drop", ['Ruin Sentinel Soul']),
        LocationData(10165040, "[Bastille] Wooden chest behind illusory wall from stairs after Sentinels", ['Rouge Water']),
        LocationData(10165041, "[Bastille] Wooden chest behind illusory wall from stairs after Sentinels in NG+", ['Crimson Water'], ngp=True),
        LocationData(10165080, "[Bastille] Wooden chest behind illusory wall from Sentinel's room", ['Target Shield']),
        LocationData(10165130, "[Bastille] Metal chest in the room under Servants' Quarters bonfire", ["Priest's Chime"]),
        LocationData(10165210, "[Bastille] Metal chest behind illusory wall in sentinel's room", ['Hush']),
        LocationData(10166000, "[Bastille] On upper ledge in Sentinel's room", ['Homeward Bone']),
        LocationData(10166020, "[Bastille] Item hidden immediately behind door after Servants' Quarters bonfire", ['Soul of a Nameless Soldier']),
        LocationData(10166100, "[Bastille] Corpse behind illusory wall in Sentinel's room", ['Rusted Coin']),
        LocationData(10166150, "[Bastille] In a cell in the narrow corridor after Sentinels", ['Soul of a Nameless Soldier']),
        LocationData(10166180, "[Bastille] On ledge behind boxes", ['Human Effigy'], vanilla=True),
        LocationData(10166180, "[Bastille] On ledge behind boxes", ['Bastille Key'], sotfs=True),
        LocationData(10166270, "[Bastille] At bottom of ladder before ruin sentinels", ['Soul of a Proud Knight', 'Human Effigy']),
        LocationData(10166290, "[Bastille] On roof after servants' quarters", ['Flame Butterfly']),
        LocationData(10166320, "[Bastille] In a cell before Sentinels", ['Radiant Lifegem']),
        LocationData(10166370, "[Bastille] On opposite roof (jump) after Servants' Quarters", ['Large Soul of a Nameless Soldier']),
        LocationData(10166380, "[Bastille] In the room under the Servants' Quarters bonfire", ['Large Club']),
    ],
    "Lost Bastille - After Key": [
        LocationData(10165000, "[Bastille] First metal chest in Pharros/elevator room", ['Parrying Dagger']),
        LocationData(10165010, "[Bastille] Wooden chest behind Pharros' contraption in Pharros/elevator room", ['Soul Vessel']),
        LocationData(10165020, "[Bastille] Second metal chest near in Pharros/elevator room", ['Bone Staff']),
        LocationData(10165070, "[Bastille] Third metal chest in Pharros/elevator room", ['Twinblade']),
        LocationData(10165110, "[Bastille] Metal chest next to elevator in Pharros/elevator room", ['Wilted Dusk Herb']),
        LocationData(10166050, "[Bastille] Corpse up the ladder", ['Large Soul of a Nameless Soldier', 'Green Blossom']),
        LocationData(10166430, "[Bastille] Blow up wall by pharros/elevator room", ['Archdrake Robes', 'Archdrake Shield']),
        LocationData(10166490, "[Bastille] In the well", ['Wanderer Hood', 'Wanderer Coat', 'Wanderer Manchettes', 'Wanderer Boots'], sotfs=True),
    ],
    "Late Lost Bastille": [
        LocationData(10166040, "[Bastille] On a corpse at the end of a long thin ledge above Mcduff's workshop", ['Soul of a Brave Warrior', 'Golden Wing Shield']),
        LocationData(10166130, "[Bastille] Corpse at top of elevator", ["Skeptic's Spice"]),
        LocationData(10166190, "[Bastille] Behind the corner at beginning of the bridge to Sinner's Rise", ['Lifegem']),
        LocationData(10166191, "[Bastille] Behind the corner at beginning of the bridge to Sinner's Rise in NG+", ['Radiant Lifegem'], ngp=True),
        LocationData(10166200, "[Bastille] End of the path after double illusory wall above dog/Pursuer courtyard", ['Bracing Knuckle Ring']),
        LocationData(10166260, "[Bastille] On corpse after jumping gap after the illusory wall", ['Flame Butterfly', 'Torch']),
        LocationData(10166410, "[Bastille] On ledge halfway up elevator shaft", ['Bonfire Ascetic']),
        LocationData(10166440, "[Bastille] In a cell next to Straid's cell", ['Petrified Dragon Bone', 'Firebomb']),
        LocationData(10166441, "[Bastille] In a cell next to Straid's cell in NG+", ['Resplendent Life', 'Firebomb'], ngp=True),
        LocationData(10166480, "[Bastille] In the corridor after one illusory wall", ['Green Blossom'], sotfs=True),
        LocationData(76800300, "[Straid of Olaphis] Homing Soul Arrow", ["Homing Soul Arrow"], shop=True),
        LocationData(76800301, "[Straid of Olaphis] Resplendent Life", ["Resplendent Life"], shop=True),
        LocationData(76800303, "[Straid of Olaphis] Unveil", ["Unveil"], shop=True),
        LocationData(76800305, "[Straid of Olaphis] Lingering Flame", ["Lingering Flame"], shop=True),
        LocationData(76800306, "[Straid of Olaphis] Flame Swathe", ["Flame Swathe"], shop=True),
        LocationData(76800307, "[Straid of Olaphis] Dark Orb", ["Dark Orb"], shop=True),
        LocationData(76800308, "[Straid of Olaphis] Dark Hail", ["Dark Hail"], shop=True),
        LocationData(76800309, "[Straid of Olaphis] Dark Fog", ["Dark Fog"], shop=True),
        LocationData(76800310, "[Straid of Olaphis] Affinity", ["Affinity"], shop=True),
        LocationData(76800311, "[Straid of Olaphis] Strong Magic Shield", ["Strong Magic Shield"], shop=True),
        LocationData(76800312, "[Straid of Olaphis] Cast Light", ["Cast Light"], shop=True),
        LocationData(76800400, "[Straid of Olaphis] Ring of Knowledge", ["Ring of Knowledge"], shop=True),
        LocationData(76800401, "[Straid of Olaphis] Lingering Dragoncrest Ring", ["Lingering Dragoncrest Ring"], shop=True),
        LocationData(76800402, "[Straid of Olaphis] Agape Ring", ["Agape Ring"], shop=True),
        # LocationData(76800600, "[Straid of Olaphis] Rouge Water", ["Rouge Water"], shop=True),
    ],
    "Earthen Peak": [
        LocationData(500000, "[EarthernPeak] Covetous Demon drop", ['Covetous Demon Soul']),
        LocationData(None, "Defeat Mytha, the Baneful Queen", None, event=True),
        LocationData(501000, "[EarthernPeak] Mytha drop", ['Mytha, the Baneful Queen Soul']),
        LocationData(501001, "[EarthernPeak] Mytha drop in NG+", ['Mytha, the Baneful Queen Soul', 'Covetous Silver Serpent Ring+2'], ngp=True),
        LocationData(10175020, "[HarvestValley] Wooden chest inside the small cave where you meet Gavlan", ['Raw Stone']),
        LocationData(10175021, "[HarvestValley] Wooden chest inside the small cave where you meet Gavlan in NG+", ['Raw Stone', 'Palestone'], ngp=True),
        LocationData(10175030, "[HarvestValley] Metal chest next to ladders leading down into the poison filled tunnel", ['Poison Stone', 'Rotten Pine Resin']),
        LocationData(10175040, "[EarthernPeak] Wooden chest on a lower side ledge of the main hall", ['Pike']),
        LocationData(10175050, "[EarthernPeak] Wooden chest behind illusory wall in the top floor", ['Petrified Something']),
        LocationData(10175060, "[EarthernPeak] Metal chest in side room where you need to jump before Covetous Demon", ['Heavy Crossbow', 'Heavy Bolt']),
        LocationData(10175070, "[EarthernPeak] Trapped wooden chest in side room before Covetous Demon", ['Torch']),
        LocationData(10175090, "[EarthernPeak] Trapped wooden chest next to two desert sorceress", ["Pharros' Lockstone"]),
        LocationData(10175110, "[HarvestValley] Metal chest inside the small cave where you meet Gavlan", ['Fire Seed', 'Divine Blessing']),
        LocationData(10175120, "[EarthernPeak] Metal chest on the other side of a jumpable gap", ['Soul of a Brave Warrior', 'Crimson Water']),
        LocationData(10175130, "[EarthernPeak] Metal chest behind Pharros contraption in the lowest level next to Lucatiel", ['Poisonbite Ring', 'Soul of a Proud Knight']),
        LocationData(10175140, "[EarthernPeak] Metal chest in a small room behind a locked door next to Pate (need to drop from above)", ['Great Heavy Soul Arrow']),
        LocationData(10175150, "[EarthernPeak] Metal chest in a bigger room behind a locked door next to pate (need to drop from above)", ['Lightning Spear']),
        LocationData(10175160, "[EarthernPeak] Metal chest on upper end of the raisable wooden platform", ['Mirrah Shield']),
        LocationData(10176000, "[HarvestValley] Behind a plank wall in the area with multiple sickle undeads", ['Lifegem']),
        LocationData(10176010, "[EarthernPeak] On a broken bridge part with manikin in the central hall", ['Broadsword', 'Human Effigy']),
        LocationData(10176020, "[HarvestValley] On a ledge before the first poison area", ['Lifegem']),
        LocationData(10176030, "[HarvestValley] On a ledge right after the first poison area", ['Torch']),
        LocationData(10176040, "[EarthernPeak] Behind illusory wall on mytha's foggate level near the ladders", ['Spell Quartz Ring+1']),
        LocationData(10176050, "[EarthernPeak] Under the raisable wooden platform", ['Large Soul of a Proud Knight', 'Divine Blessing']),
        LocationData(10176060, "[HarvestValley] On upper end of the ladders before the gate guarded by desert sorceress", ['Hexing Urn']),
        LocationData(10176070, "[HarvestValley] A corpse behind a plank wall you need a mounted overseer to break", ['Radiant Lifegem', 'Smooth & Silky Stone']),
        LocationData(10176080, "[HarvestValley] Behind a plank wall in the area with multiple sickle undeads (2)", ["Skeptic's Spice"]),
        LocationData(10176090, "[HarvestValley] A corpse behind a plank wall you need a mounted overseer to break (2)", ['Torch']),
        LocationData(10176100, "[EarthernPeak] In a poison filled corridor in the lowest level", ['Estus Flask Shard'], vanilla=True),
        LocationData(10176100, "[EarthernPeak] In a poison filled corridor in the lowest level", ['Repair Powder'], sotfs=True),
        LocationData(10176110, "[EarthernPeak] In a narrow crevasse right before Covetous Demon", ["Skeptic's Spice"]),
        LocationData(10176120, "[EarthernPeak] In the corner of the first room after Covetous bonfire", ['Radiant Lifegem']),
        LocationData(10176130, "[HarvestValley] A corpse behind a plank wall you need a mounted overseer to break (3)", ['Soul of a Lost Undead']),
        LocationData(10176140, "[EarthernPeak] On a ledge where you need to buy ladders from gilligan", ["Pharros' Lockstone", 'Twinkling Titanite']),
        LocationData(10176150, "[EarthernPeak] Outside of the wooden breakable railing", ["Simpleton's Spice"]),
        LocationData(10176160, "[HarvestValley] A corpse behind a plank wall you need a mounted overseer to break (4)", ['Old Knight Pike', 'Old Knight Greatshield']),
        LocationData(10176170, "[EarthernPeak] Corpse on the other side of a jumpable gap", ['Radiant Lifegem']),
        LocationData(10176171, "[EarthernPeak] Corpse on the other side of a jumpable gap in NG+", ['Divine Blessing'], ngp=True),
        LocationData(10176180, "[HarvestValley] A corpse inside the small cave where you meet Gavlan", ['Fragrant Branch of Yore', 'Torch']),
        LocationData(10176190, "[EarthernPeak] Corpse in side room where you need to jump before Covetous Demon", ['Soul of a Nameless Soldier', 'Titanite Shard']),
        LocationData(10176200, "[HarvestValley] A corpse in the first poison area", ['Small Smooth & Silky Stone', 'Titanite Shard']),
        LocationData(10176210, "[HarvestValley] In the poison filled tunnel closer to Earthen Peak end", ['Fading Soul']),
        LocationData(10176220, "[HarvestValley] In a small poison filled alcove from the poison area in front of Earthen Peak", ['Human Effigy', 'Large Titanite Shard']),
        LocationData(10176221, "[HarvestValley] In a small poison filled alcove from the poison area in front of Earthen Peak in NG+", ['Human Effigy', 'Large Titanite Shard'], ngp=True),
        LocationData(10176230, "[HarvestValley] A corpse in the first poison area (2)", ['Titanite Chunk']),
        LocationData(10176231, "[HarvestValley] A corpse in the first poison area in NG+", ['Titanite Chunk'], ngp=True),
        LocationData(10176250, "[HarvestValley] A corpse in the first poison area (3)", ['Fading Soul', 'Small Smooth & Silky Stone']),
        LocationData(10176260, "[HarvestValley] A corpse in the first poison area (4)", ['Fading Soul']),
        LocationData(10176270, "[HarvestValley] A corpse in the first poison area (5)", ['Fading Soul']),
        LocationData(10176280, "[HarvestValley] A corpse in the first poison area (6)", ['Fading Soul']),
        LocationData(10176290, "[HarvestValley] A corpse in the first poison area (7)", ['Fading Soul', 'Titanite Shard']),
        LocationData(10176300, "[HarvestValley] A corpse in the first poison area (8)", ['Poison Throwing Knife']),
        LocationData(10176340, "[HarvestValley] In the poison filled tunnel closer to Earthen Peak", ["Simpleton's Spice"]),
        LocationData(10176350, "[HarvestValley] A corpse in the poison area before Earthen Peak", ['Chameleon', 'Soul of a Brave Warrior']),
        LocationData(10176370, "[HarvestValley] A corpse in the poison area before earthen peak", ['Titanite Shard']),
        LocationData(10176390, "[HarvestValley] On a ledge after the tunnel leading away from the area with multiple sickle undeads", ['Fragrant Branch of Yore'], vanilla=True),
        LocationData(10176390, "[HarvestValley] On a ledge after the tunnel leading away from the area with multiple sickle undeads", ['Petrified Something'], sotfs=True),
        LocationData(10176400, "[HarvestValley] Behind a plank wall in the area with multiple sickle undeads (3)", ['Large Soul of a Brave Warrior', 'Radiant Lifegem']),
        LocationData(10176410, "[HarvestValley] In the poison filled tunnel further Earthen Peak", ['Soul of a Nameless Soldier']),
        LocationData(10176420, "[EarthernPeak] One floor up from the second bonfire", ['Black Firebomb']),
        LocationData(10176430, "[EarthernPeak] One floor up from the second bonfire (2)", ['Manikin Mask']),
        LocationData(10176440, "[EarthernPeak] Next to mimic on upper floor", ['Small Smooth & Silky Stone']),
        LocationData(10176450, "[EarthernPeak] In the poison pool just before mytha", ['Poison Stone']),
        LocationData(10176460, "[HarvestValley] In a tunnel leading away from the area with multiple sickle undeads", ['Titanite Shard']),
        LocationData(10176461, "[HarvestValley] In a tunnel leading away from the area with multiple sickle undeads in NG+", ['Twinkling Titanite'], ngp=True),
        LocationData(10176470, "[HarvestValley] Behind a plank wall in the area with multiple sickle undeads (4)", ['Large Titanite Shard']),
        LocationData(10176480, "[HarvestValley] Behind a plank wall in the area with multiple sickle undeads (5)", ["Simpleton's Spice"]),
        LocationData(10176490, "[HarvestValley] In the middle of the area with multiple sickle undeads", ['Green Blossom']),
        LocationData(10176500, "[HarvestValley] A corpse in the first poison area (9)", ['Titanite Shard'], sotfs=True),
        LocationData(10176510, "[HarvestValley] A corpse in the first poison area (10)", ['Fading Soul'], sotfs=True),
        LocationData(10176520, "[HarvestValley] A corpse in the first poison area (11)", ['Titanite Chunk'], sotfs=True),
        LocationData(10176530, "[HarvestValley] A corpse in the first poison area (12)", ['Titanite Shard'], sotfs=True),
        LocationData(10176540, "[HarvestValley] A corpse in the first poison area (13)", ['Torch'], sotfs=True),
        LocationData(10176550, "[HarvestValley] A corpse in the first poison area (14)", ['Titanite Shard'], sotfs=True),
        LocationData(10176560, "[HarvestValley] A corpse in the first poison area (15)", ['Titanite Shard'], sotfs=True),
        LocationData(10176570, "[HarvestValley] A corpse in the first poison area (16)", ['Fading Soul'], sotfs=True),
        LocationData(10176580, "[HarvestValley] A corpse in the poison area before earthen peak (2)", ['Titanite Shard'], sotfs=True),
        LocationData(10176590, "[HarvestValley] A corpse in the poison area before earthen peak (3)", ['Titanite Slab'], sotfs=True),
        LocationData(10176600, "[HarvestValley] A corpse in the poison area before earthen peak (4)", ['Washing Pole'], sotfs=True),
        LocationData(10176610, "[HarvestValley] A corpse in the poison area before earthen peak (5)", ['Dragon Charm'], sotfs=True),
        LocationData(10176620, "[HarvestValley] A corpse in the poison area before earthen peak (6)", ['Titanite Shard'], sotfs=True),
        LocationData(10176630, "[EarthernPeak] Short corridor with poison on floor", ['Flame Butterfly'], sotfs=True),
        LocationData(70400000, "[Laddersmith Gilligan - Earthen Peak] Reinforced Club", ["Reinforced Club"], shop=True),
        LocationData(70400001, "[Laddersmith Gilligan - Earthen Peak] Claws", ["Claws"], shop=True),
        LocationData(70400002, "[Laddersmith Gilligan - Earthen Peak] Whip", ["Whip"], shop=True),
        LocationData(70400003, "[Laddersmith Gilligan - Earthen Peak] Wooden Shield", ["Wooden Shield"], shop=True),
        LocationData(70400200, "[Laddersmith Gilligan - Earthen Peak] Thief Mask", ["Thief Mask"], shop=True),
        LocationData(70400201, "[Laddersmith Gilligan - Earthen Peak] Black Leather Armor", ["Black Leather Armor"], shop=True),
        LocationData(70400202, "[Laddersmith Gilligan - Earthen Peak] Black Leather Gloves", ["Black Leather Gloves"], shop=True),
        LocationData(70400203, "[Laddersmith Gilligan - Earthen Peak] Black Leather Boots", ["Black Leather Boots"], shop=True),
        LocationData(70400500, "[Laddersmith Gilligan - Earthen Peak] Ladder Miniature", ["Ladder Miniature"], shop=True),
        # LocationData(70400600, "[Laddersmith Gilligan - Earthen Peak] Aromatic Ooze", ["Aromatic Ooze"], shop=True),
        # LocationData(70400601, "[Laddersmith Gilligan - Earthen Peak] Lacerating Knife", ["Lacerating Knife"], shop=True),
        # LocationData(70400602, "[Laddersmith Gilligan - Earthen Peak] Bleeding Serum", ["Bleeding Serum"], shop=True),
        LocationData(None, "Speak with Lonesome Gavlan in Harvest Valley", None, event=True),
        LocationData(72600401, "[Lonesome Gavlan - Harvest Valley] Ring of Giants", ["Ring of Giants"], shop=True),
        LocationData(76200300, "[Stone Trader Chloanne] Soul Appease", ["Soul Appease"], shop=True),
        LocationData(76200301, "[Stone Trader Chloanne] Dead Again", ["Dead Again"], shop=True),
        # LocationData(76200600, "[Stone Trader Chloanne] Titanite Shard", ["Titanite Shard"], shop=True),
        # LocationData(76200601, "[Stone Trader Chloanne - Old Iron King] Titanite Shard", ["Titanite Shard"], shop=True),
        # LocationData(76200602, "[Stone Trader Chloanne - Old Iron King] Large Titanite Shard", ["Large Titanite Shard"], shop=True),
        # LocationData(76200603, "[Stone Trader Chloanne - Looking Glass Knight] Large Titanite Shard", ["Large Titanite Shard"], shop=True),
        # LocationData(76200604, "[Stone Trader Chloanne - Velstadt] Titanite Chunk", ["Titanite Chunk"], shop=True),
        # LocationData(76200605, "[Stone Trader Chloanne - Nashandra] Titanite Chunk", ["Titanite Chunk"], shop=True),
        # LocationData(76200607, "[Stone Trader Chloanne - Velstadt] Twinkling Titanite", ["Twinkling Titanite"], shop=True),
        # LocationData(76200608, "[Stone Trader Chloanne - Velstadt] Petrified Dragon Bone", ["Petrified Dragon Bone"], shop=True),
        # LocationData(76200609, "[Stone Trader Chloanne - Velstadt] Faintstone", ["Faintstone"], shop=True),
        # LocationData(76200610, "[Stone Trader Chloanne - Velstadt] Boltstone", ["Boltstone"], shop=True),
        # LocationData(76200611, "[Stone Trader Chloanne - Velstadt] Firedrake Stone", ["Firedrake Stone"], shop=True),
        # LocationData(76200612, "[Stone Trader Chloanne - Velstadt] Darknight Stone", ["Darknight Stone"], shop=True),
        # LocationData(76200613, "[Stone Trader Chloanne - Looking Glass Knight] Poison Stone", ["Poison Stone"], shop=True),
        # LocationData(76200614, "[Stone Trader Chloanne - Looking Glass Knight] Bleed Stone", ["Bleed Stone"], shop=True),
        # LocationData(76200615, "[Stone Trader Chloanne - Velstadt] Raw Stone", ["Raw Stone"], shop=True),
        # LocationData(76200616, "[Stone Trader Chloanne - Velstadt] Magic Stone", ["Magic Stone"], shop=True),
        # LocationData(76200617, "[Stone Trader Chloanne - Velstadt] Old Mundane Stone", ["Old Mundane Stone"], shop=True),
        LocationData(76200618, "[Stone Trader Chloanne] Bonfire Ascetic", ["Bonfire Ascetic"], shop=True),
    ],
    "No-man's Wharf": [
        LocationData(303300, "[Wharf] Flexile Sentry drop", ['Flexile Sentry Soul']),
        LocationData(10185000, "[Wharf] Wooden chest in the first house in Wharf", ['Titanite Shard']),
        LocationData(10185001, "[Wharf] Wooden chest in the first house in Wharf in NG+", ['Titanite Chunk'], ngp=True),
        LocationData(10185030, "[Wharf] Wooden chest on the 2nd floor of the house next to central courtyard", ['Repair Powder', 'Titanite Shard']),
        LocationData(10185040, "[Wharf] Metal chest in house next to central courtyard", ['Bandit Axe', 'Brigand Hood', 'Brigand Armor', 'Brigand Gauntlets', 'Brigand Trousers']),
        LocationData(10185050, "[Wharf] Metal chest in the topmost house with dark stalkers", ['Greatsword']),
        LocationData(10185060, "[Wharf] Metal chest in the secret alcove in the poison jar room", ["Royal Soldier's Ring"]),
        LocationData(10185070, "[Wharf] Metal chest behind illusory wall underneath Wharf Gavlan", ['Large Titanite Shard']),
        LocationData(10185071, "[Wharf] Metal chest behind illusory wall underneath Wharf Gavlan NG+", ['Large Titanite Shard'], ngp=True),
        LocationData(10185080, "[Wharf] Wooden chest behind illusory wall underneath Wharf Gavlan", ['Firebomb']),
        LocationData(10185081, "[Wharf] Wooden chest behind illusory wall underneath Wharf Gavlan in NG+", ['Black Firebomb'], ngp=True),
        LocationData(10185100, "[Wharf] Trapped wooden chest in the topmost house with dark stalkers", ['Silver Talisman']),
        LocationData(10185110, "[Wharf] Metal chest in the poison jar room", ['Estus Flask Shard'], vanilla=True),
        LocationData(10185110, "[Wharf] Metal chest in the poison jar room", ['Fragrant Branch of Yore'], sotfs=True),
        LocationData(10185120, "[Wharf] Metal chest after Flexile Sentry", ['Pyromancy Flame', 'Fireball']),
        LocationData(10186000, "[Wharf] Corpse on top balcony in the first building on left", ['Soul of a Proud Knight']),
        LocationData(10186010, "[Wharf] On tipped boat in water", ['Human Effigy', 'Lifegem']),
        LocationData(10186020, "[Wharf] In staircase in a house after the ship-calling bell", ['Fire Arrow']),
        LocationData(10186021, "[Wharf] In staircase in a house after the ship-calling bell in NG+", ['Fire Arrow'], ngp=True),
        LocationData(10186030, "[Wharf] Behind a shelf in alcove", ['Ring of Life Protection'], vanilla=True),
        LocationData(10186030, "[Wharf] Behind a shelf in alcove", ['Human Effigy'], sotfs=True),
        LocationData(10186050, "[Wharf] In the shallow water", ['Large Soul of a Lost Undead', 'Lifegem']),
        LocationData(10186070, "[Wharf] In the house under the Pharros' contraption", ['Iron Arrow']),
        LocationData(10186071, "[Wharf] In the house under the Pharros' contraption in NG+", ['Iron Arrow'], ngp=True),
        LocationData(10186100, "[Wharf] On the roof of the house under the Pharros' contraption", ['Large Soul of a Proud Knight', 'Small Smooth & Silky Stone']),
        LocationData(10186110, "[Wharf] On the high ledge", ['Large Soul of a Lost Undead', 'Emit Force']),
        LocationData(10186120, "[Wharf] Corpse in the secret alcove of the poison jar room", ['Fading Soul']),
        LocationData(10186130, "[Wharf] Rooftop after the ship-calling bell", ['Lifegem', 'Homeward Bone']),
        LocationData(10186140, "[Wharf] Corpse in the secret alcove of the poison jar room (2)", ['Soul of a Nameless Soldier']),
        LocationData(10186150, "[Wharf] In the left house before the first stairs", ['Dark Pine Resin']),
        LocationData(10186160, "[Wharf] Corpse in the secret alcove of the poison jar room (3)", ['Large Soul of a Nameless Soldier', 'Lifegem']),
        LocationData(10186170, "[Wharf] In alcove behind the poison jars", ['Throwing Knife', 'Flame Butterfly']),
        LocationData(None, "Speak with Lonesome Gavlan in No-man's Wharf", None, event=True),
        # LocationData(72600400, "[Lonesome Gavlan - No-man's Wharf] Ring of Giants", ["Ring of Giants"], shop=True),
        # LocationData(72600600, "[Lonesome Gavlan] Poison Moss", ["Poison Moss"], shop=True),
        # LocationData(72600601, "[Lonesome Gavlan] Rotten Pine Resin", ["Rotten Pine Resin"], shop=True),
        # LocationData(72600602, "[Lonesome Gavlan] Poison Throwing Knife", ["Poison Throwing Knife"], shop=True),
        # LocationData(72600603, "[Lonesome Gavlan] Poison Arrow", ["Poison Arrow"], shop=True),
    ],
    "Belfry Sol":[
        LocationData(10195050, "[BelfrySol] Metal chest behind illusory wall after Belfry Sol exit", ['Black Knight Greatsword']),
        LocationData(10195060, "[BelfrySol] Metal chest behind illusory wall after Belfry Sol exit (2)", ['Protective Chime', 'Grand Spirit Tree Shield']),
        LocationData(10195120, "[BelfrySol] Metal chest immediately after completing Belfy Sol", ['Immolation']),
        LocationData(10195130, "[BelfrySol] Metal chest next to Belfry Sol bonfire", ['Thunder Quartz Ring+1']),
        LocationData(10196000, "[BelfrySol] Behind the Belfry", ["Simpleton's Spice"]),
        LocationData(10196010, "[BelfrySol] On the far side of the sloped roof in Belfry Sol", ["Simpleton's Spice"]),
        LocationData(10196020, "[BelfrySol] Next to the ladder near the exit of Belfry Sol", ["Simpleton's Spice"]),
        LocationData(10196200, "[BelfrySol] Corpse at bottom of stairs after Belfy Sol exit", ['Human Effigy', 'Triclops Snake Troches']),
    ],
    "Iron Keep": [
        LocationData(None, "Defeat the Smelter Demon", None, event=True),
        LocationData(305000, "[IronKeep] Smelter Demon drop", ['Smelter Demon Soul']),
        LocationData(None, "Defeat the Old Iron King", None, event=True),
        LocationData(607000, "[IronKeep] Old Iron King drop", ['Old Iron King Soul']),
        LocationData(607001, "[IronKeep] Old Iron King drop in NG+", ['Old Iron King Soul', 'Old King Soul'], ngp=True),
        LocationData(10195000, "[IronKeep] Wooden chest at upper level of the room with changing platforms", ['Destructive Greatarrow']),
        LocationData(10195001, "[IronKeep] Wooden chest at upper level of the room with changing platforms in NG+", ['Destructive Greatarrow'], ngp=True),
        LocationData(10195030, "[IronKeep] Metal chest next to Pharros contraption after Dull ember jump", ['Zweihander']),
        LocationData(10195040, "[IronKeep] Metal chest next to archer on upper left side of the first big lava room", ['Life Ring+1', 'Twinkling Titanite']),
        LocationData(10195090, "[IronKeep] Metal chest at the top of the high tower with a hole in the middle of it", ['Black Knight Greataxe']),
        LocationData(10195100, "[IronKeep] Metal chest in lava at right side of the first big lava room", ['Phoenix Parma'], skip=True),
        LocationData(10195110, "[IronKeep] Metal chest in lava in the room with changing platforms", ['Chaos Storm'], skip=True),
        LocationData(10195140, "[IronKeep] Metal chest immediately after Smelter demon", ['Porcine Shield', 'Flame Butterfly']),
        LocationData(10195150, "[IronKeep] Metal chest after Old Iron King", ['Sublime Bone Dust'], vanilla=True),
        LocationData(10195150, "[IronKeep] Metal chest after Old Iron King", ['Petrified Something'], sotfs=True),
        LocationData(10196030, "[IronKeep] On lower left side of the first big lava room", ['Soul of a Proud Knight', 'Repair Powder']),
        LocationData(10196040, "[IronKeep] Corpse at the top of the high tower with three Alonne captains", ["Simpleton's Spice"]),
        LocationData(10196050, "[IronKeep] Under the fire of bull statues before Old Iron King", ['Short Bow']),
        LocationData(10196060, "[IronKeep] On pilar on right side of the first big lava room", ['Large Soul of a Nameless Soldier', 'Red Leech Troches']),
        LocationData(10196070, "[IronKeep] Behind ladder after furnace in the first big lava room", ['Old Radiant Lifegem', 'Green Blossom']),
        LocationData(10196080, "[IronKeep] Under the fire of bull statue in the first hall", ['Iron Key']),
        LocationData(10196090, "[IronKeep] On ledge above the first hall", ["Pharros' Lockstone"]),
        LocationData(10196100, "[IronKeep] On crisscrossing platforms in a hole in the middle of the high tower", ['Cracked Red Eye Orb', 'Torch']),
        LocationData(10196110, "[IronKeep] On a central platform in the room with changing platforms", ['Large Soul of a Nameless Soldier']),
        LocationData(10196111, "[IronKeep] On a central platform in the room with changing platforms in NG+", ['Soul of a Brave Warrior'], ngp=True),
        LocationData(10196120, "[IronKeep] On right side of the room with changing platforms", ['Large Soul of a Proud Knight', 'Radiant Lifegem']),
        LocationData(10196130, "[IronKeep] Next to fog gate in the room with changing platforms", ['Large Soul of a Nameless Soldier', 'Monastery Charm']),
        LocationData(10196140, "[IronKeep] On lava on the right of bridge by first bonfire", ['Bonfire Ascetic'], vanilla=True, skip=True),
        LocationData(10196140, "[IronKeep] On lava on the right of bridge by first bonfire", ['Bonfire Ascetic', "Simpleton's Spice"], sotfs=True, skip=True),
        LocationData(10196150, "[IronKeep] Behind illusory wall next to ballista", ['Fire Arrow']),
        LocationData(10196160, "[IronKeep] On broken stairs in the first big lava room", ['Dull Ember'], vanilla=True),
        LocationData(10196160, "[IronKeep] On broken stairs in the first big lava room", ['Petrified Dragon Bone'], sotfs=True),
        LocationData(10196170, "[IronKeep] In large smelting pot hanging above bridges", ['Covetous Gold Serpent Ring']),
        LocationData(10196180, "[IronKeep] On lava next to the first bonfire", ['Human Effigy'], skip=True),
        LocationData(10196190, "[IronKeep] Corpse in lava in the room with changing platforms", ['Fire Seed']),
        LocationData(10196210, "[IronKeep] Inside the central kiln", ['Large Titanite Shard', 'Petrified Dragon Bone']),
        LocationData(10196211, "[IronKeep] Inside the central kiln in NG+", ['Twinkling Titanite', 'Petrified Dragon Bone'], ngp=True),
        LocationData(10196220, "[IronKeep] Corpse at the top of the high tower with three Alonne captains (2)", ['Titanite Shard', 'Fire Arrow'], sotfs=True),
        LocationData(76100235, "[Maughlin the Armourer - Smelter Demon] Smelter Demon Helm", ["Smelter Demon Helm"], shop=True),
        LocationData(76100236, "[Maughlin the Armourer - Smelter Demon] Smelter Demon Armor", ["Smelter Demon Armor"], shop=True),
        LocationData(76100237, "[Maughlin the Armourer - Smelter Demon] Smelter Demon Gauntlets", ["Smelter Demon Gauntlets"], shop=True),
        LocationData(76100238, "[Maughlin the Armourer - Smelter Demon] Smelter Demon Leggings", ["Smelter Demon Leggings"], shop=True),
        LocationData(77200200, "[Magerold of Lanafir] Spiked Bandit Helm", ["Spiked Bandit Helm"], shop=True),
        LocationData(77200201, "[Magerold of Lanafir] Bandit Armor", ["Bandit Armor"], shop=True),
        LocationData(77200202, "[Magerold of Lanafir] Bandit Gauntlets", ["Bandit Gauntlets"], shop=True),
        LocationData(77200203, "[Magerold of Lanafir] Bandit Boots", ["Bandit Boots"], shop=True),
        LocationData(77200204, "[Magerold of Lanafir] Jester's Cap", ["Jester's Cap"], shop=True),
        LocationData(77200205, "[Magerold of Lanafir] Jester's Robes", ["Jester's Robes"], shop=True),
        LocationData(77200206, "[Magerold of Lanafir] Jester's Gloves", ["Jester's Gloves"], shop=True),
        LocationData(77200207, "[Magerold of Lanafir] Jester's Tights", ["Jester's Tights"], shop=True),
        LocationData(77200208, "[Magerold of Lanafir - NG+2] Dragonrider Helm", ["Dragonrider Helm"], ngp=True, shop=True),
        LocationData(77200209, "[Magerold of Lanafir - NG+2] Dragonrider Armor", ["Dragonrider Armor"], ngp=True, shop=True),
        LocationData(77200210, "[Magerold of Lanafir - NG+2] Dragonrider Gauntlets", ["Dragonrider Gauntlets"], ngp=True, shop=True),
        LocationData(77200211, "[Magerold of Lanafir - NG+2] Dragonrider Leggings", ["Dragonrider Leggings"], ngp=True, shop=True),
        LocationData(77200300, "[Magerold of Lanafir] Soul Arrow", ["Soul Arrow"], shop=True),
        LocationData(77200301, "[Magerold of Lanafir] Great Soul Arrow", ["Great Soul Arrow"], shop=True),
        LocationData(77200302, "[Magerold of Lanafir] Heavy Soul Arrow", ["Heavy Soul Arrow"], shop=True),
        LocationData(77200303, "[Magerold of Lanafir] Great Heavy Soul Arrow", ["Great Heavy Soul Arrow"], shop=True),
        LocationData(77200304, "[Magerold of Lanafir] Dark Hail", ["Dark Hail"], shop=True),
        LocationData(77200305, "[Magerold of Lanafir] Darkstorm", ["Darkstorm"], shop=True),
        LocationData(77200306, "[Magerold of Lanafir] Fall Control", ["Fall Control"], shop=True),
        LocationData(77200400, "[Magerold of Lanafir] Cursebite Ring", ["Cursebite Ring"], shop=True),
        LocationData(77200500, "[Magerold of Lanafir] Hello Carving", ["Hello Carving"], shop=True),
        LocationData(77200501, "[Magerold of Lanafir] Thank You Carving", ["Thank You Carving"], shop=True),
        LocationData(77200502, "[Magerold of Lanafir] I'm Sorry Carving", ["I'm Sorry Carving"], shop=True),
        LocationData(77200503, "[Magerold of Lanafir] Very Good! Carving", ["Very Good! Carving"], shop=True),
        # LocationData(77200600, "[Magerold of Lanafir] Green Blossom", ["Green Blossom"], shop=True),
        # LocationData(77200601, "[Magerold of Lanafir] Charcoal Pine Resin", ["Charcoal Pine Resin"], shop=True),
        # LocationData(77200602, "[Magerold of Lanafir] Black Firebomb", ["Black Firebomb"], shop=True),
        # LocationData(77200603, "[Magerold of Lanafir] Rusted Coin", ["Rusted Coin"], shop=True),
        LocationData(77200604, "[Magerold of Lanafir] Repair Powder", ["Repair Powder"], shop=True),
        LocationData(77200605, "[Magerold of Lanafir] Human Effigy", ["Human Effigy"], shop=True),
        LocationData(77200606, "[Magerold of Lanafir] Fragrant Branch of Yore", ["Fragrant Branch of Yore"], shop=True),
    ],
    "Huntsman's Copse": [
        LocationData(None, "Defeat the Skeleton Lords", None, event=True),
        LocationData(154000, "[Copse] Skeleton Lords drop", ["Skeleton Lord's Soul"]),
        LocationData(154001, "[Copse] Skeleton Lords drop in NG+", ["Skeleton Lord's Soul", 'Clear Bluestone Ring+2'], ngp=True),
        LocationData(619100, "[Chariot] Executioner's Chariot drop", ["Executioner's Chariot Soul"]),
        LocationData(619101, "[Chariot] Executioner's Chariot drop in NG+", ["Executioner's Chariot Soul", 'Chloranthy Ring+2'], ngp=True),
        LocationData(10046080, "[Copse] On ground after rotating rotunda towards Huntsman's Copse", ['Rouge Water']),
        LocationData(10235010, "[Copse] Metal chest in the cave with the giant basilisk", ["Ricard's Rapier"]),
        LocationData(10235020, "[Copse] Metal chest in a round hut where you drop from above", ['Sublime Bone Dust'], sotfs=True),
        LocationData(10236000, "[Copse] On ledge right above the Bridge Approach bonfire", ['Cracked Red Eye Orb']),
        LocationData(10236010, "[Chariot] Above the stairs leading to the bonfire", ['Cracked Red Eye Orb']),
        LocationData(10236020, "[Copse] Next to a big cliff face guarded by a sickle undead", ['Aromatic Ooze']),
        LocationData(10236021, "[Copse] Next to a big cliff face guarded by a sickle undead in NG+", ['Aromatic Ooze'], ngp=True),
        LocationData(10236030, "[Copse] On the left side of the path before the first stone bridge", ['Large Soul of a Lost Undead', 'Small Orange Burr']),
        LocationData(10236040, "[Copse] On a ledge on the way to Executioner's Chariot", ['Notched Whip']),
        LocationData(10236050, "[Copse] Corpse in the necromancer cave closest to the Undead Lockaway bonfire", ['Mace', 'Titanite Shard']),
        LocationData(10236060, "[Copse] On small ledge with a necromancer", ['Combustion', 'Titanite Shard']),
        LocationData(10236070, "[Copse] Hanging on the side of the big circular hole in the room in the beginning of the area", ['Soul of a Nameless Soldier', 'Lifegem']),
        LocationData(10236071, "[Copse] Hanging on the side of the big circular hole in the room in the beginning of the area in NG+", ['Large Soul of a Proud Knight', 'Old Radiant Lifegem'], ngp=True),
        LocationData(10236080, "[Copse] On the roof of the room with the big circular hole in the beginning of the area", ['Poison Moss', 'Lifegem']),
        LocationData(10236090, "[Copse] Round hut next to a big cliff face", ['Morning Star', 'Large Soul of a Nameless Soldier']),
        LocationData(10236100, "[Copse] First corpse in a round hut where you drop from above", ['Poison Moss', 'Green Blossom']),
        LocationData(10236110, "[Copse] Second corpse in a round hut where you drop from above", ['Soul Spear']),
        LocationData(10236120, "[Copse] In the room with the big circular hole in the beginning of the area", ["Bandit's Knife"]),
        LocationData(10236130, "[Copse] On the left side of the path after the first stone bridge", ['Lifegem']),
        LocationData(10236131, "[Copse] On the left side of the path after the first stone bridge in NG+", ['Elizabeth Mushroom'], ngp=True),
        LocationData(10236140, "[Copse] Next to portcullis in the necromancer cave", ['Flame Butterfly'], vanilla=True),
        LocationData(10236140, "[Copse] Next to portcullis in the necromancer cave", ['Estus Flask Shard'], sotfs=True),
        LocationData(10236150, "[Copse] On the pillar under the chariot bridge", ["Pharros' Lockstone", 'Token of Fidelity']),
        LocationData(10236160, "[Copse] Where Merciless Roenna invades", ['Poison Throwing Knife'], vanilla=True),
        LocationData(10236160, "[Copse] Where Merciless Roenna invades", ['Undead Lockaway Key'], sotfs=True),
        LocationData(10236170, "[Copse] On a small ledge where you drop from the area where Merciless Roenna invades", ['Poison Moss'], vanilla=True),
        LocationData(10236170, "[Copse] On a small ledge where you drop from the area where Merciless Roenna invades", ['Flamberge'], sotfs=True),
        LocationData(10236180, "[Chariot] First corpse in the Chariot arena", ['Fading Soul']),
        LocationData(10236190, "[Chariot] Second corpse in the Chariot arena", ['Fading Soul']),
        LocationData(10236200, "[Chariot] Third corpse in the Chariot arena", ['Fading Soul']),
        LocationData(10236210, "[Chariot] Fourth corpse in the Chariot arena", ['Fading Soul']),
        LocationData(10236220, "[Chariot] Fifth corpse in the Chariot arena", ['Soul of a Brave Warrior']),
        LocationData(10236230, "[Copse] Round hut on the way to Skeleton Lords", ['Undead Lockaway Key'], vanilla=True),
        LocationData(10236230, "[Copse] Round hut on the way to Skeleton Lords", ['Flame Butterfly'], sotfs=True),
        LocationData(10236240, "[Copse] On the side ledge just before Executioner's Chariot boss", ['Sublime Bone Dust', 'Fire Seed'], vanilla=True),
        LocationData(10236240, "[Copse] On the side ledge just before Executioner's Chariot boss", ['Fire Seed'], sotfs=True),
        LocationData(10236250, "[Copse] On lower end of the elevator from the cave with the giant basilisk", ['Large Soul of a Nameless Soldier']),
        LocationData(10236260, "[Copse] On a stone bridge in the cave with the giant basilisk", ['Monastery Charm', 'Soul of a Proud Knight']),
        LocationData(10236270, "[Copse] On a stone pillar inside the necromancer cave", ['Human Effigy', 'Lacerating Arrow', 'Prism Stone'], sotfs=True),
        # LocationData(78300000, "[Titchy Gren] Great Scythe", ["Great Scythe"], shop=True),
        # LocationData(78300001, "[Titchy Gren] Priest's Chime", ["Priest's Chime"], shop=True),
        # LocationData(78300200, "[Titchy Gren - Skeleton Lords] Bone Crown", ["Bone Crown"], shop=True),
        # LocationData(78300201, "[Titchy Gren - Skeleton Lords] Bone King Robe", ["Bone King Robe"], shop=True),
        # LocationData(78300202, "[Titchy Gren - Skeleton Lords] Bone King Cuffs", ["Bone King Cuffs"], shop=True),
        # LocationData(78300203, "[Titchy Gren - Skeleton Lords] Bone King Skirt", ["Bone King Skirt"], shop=True),
        # LocationData(78300204, "[Titchy Gren - Shrine of Winter] Executioner Helm", ["Executioner Helm"], shop=True),
        # LocationData(78300205, "[Titchy Gren - Shrine of Winter] Executioner Armor", ["Executioner Armor"], shop=True),
        # LocationData(78300206, "[Titchy Gren - Shrine of Winter] Executioner Gauntlets", ["Executioner Gauntlets"], shop=True),
        # LocationData(78300207, "[Titchy Gren - Shrine of Winter] Executioner Leggings", ["Executioner Leggings"], shop=True),
        # LocationData(78300300, "[Titchy Gren] Firestorm", ["Firestorm"], shop=True),
        # LocationData(78300301, "[Titchy Gren] Great Combustion", ["Great Combustion"], shop=True),
        # LocationData(78300302, "[Titchy Gren] Fire Whip", ["Fire Whip"], shop=True),
        # LocationData(78300400, "[Titchy Gren] Delicate String", ["Delicate String"], shop=True),
        # LocationData(78300600, "[Titchy Gren] Red Sign Soapstone", ["Red Sign Soapstone"], shop=True),
        # LocationData(78300601, "[Titchy Gren] Silver Talisman", ["Silver Talisman"], shop=True),
        # LocationData(78300602, "[Titchy Gren] Hexing Urn", ["Hexing Urn"], shop=True),
        # LocationData(78300603, "[Titchy Gren - NG+] Cracked Red Eye Orb", ["Cracked Red Eye Orb"], shop=True, ngp=True),
        # LocationData(78300604, "[Titchy Gren] Cracked Red Eye Orb", ["Cracked Red Eye Orb"], shop=True),
    ],
    "The Gutter": [
        LocationData(None, "Defeat the Rotten", None, event=True),
        LocationData(326000, "[Gulch] The Rotten drop", ['Soul of the Rotten']),
        LocationData(326001, "[Gulch] The Rotten drop in NG+", ['Soul of the Rotten', 'Old Dead One Soul'], ngp=True),
        LocationData(10255010, "[Gutter] Wooden chest on top of small structure in the end of the first long bridge", ['Black Firebomb']),
        LocationData(10255020, "[Gutter] Wooden chest on the middle floor of an wooden building near where Melinda the Butcher invades", ['Twinkling Titanite', 'Small Smooth & Silky Stone'], vanilla=True),
        LocationData(10255030, "[Gutter] Wooden chest on ledge in multiple ladders area", ['Great Club']),
        LocationData(10255040, "[Gutter] Metal chest near where Melinda the Butcher invades", ['Ring of Soul Protection']),
        LocationData(10255050, "[Gulch] Wooden chest in the side tunnel after the worms", ['Divine Blessing'], skip=True),
        LocationData(10255090, "[Gulch] Metal chest in side room next to Gulch Giants", ['Ring of Giants+1', 'Petrified Dragon Bone']),
        LocationData(10255100, "[Gutter] Metal chest in the cave with corrosive bugs", ['Wicked Eye Greatshield']),
        LocationData(10255110, "[Gutter] Metal chest in the base of the tower where the zip-line starts", ['Ring of the Evil Eye'], vanilla=True),
        LocationData(10255110, "[Gutter] Metal chest in the base of the tower where the zip-line starts", ['Helm of Aurous', 'Armor of Aurous', 'Gauntlets of Aurous', 'Leggings of Aurous'], sotfs=True),
        LocationData(10255120, "[Gulch] Metal chest after the Rotten", ['Sublime Bone Dust'], vanilla=True),
        LocationData(10255120, "[Gulch] Metal chest after the Rotten", ['Petrified Something', "Simpleton's Spice", "Skeptic's Spice"], sotfs=True),
        LocationData(10255130, "[Gulch] Metal chest in the side tunnel before the worms", ['Shotel', 'Great Magic Weapon']),
        LocationData(10256000, "[Gutter] Urn behind the forgotten door", ["Havel's Greatshield", "Havel's Helm", "Havel's Armor", "Havel's Gauntlets", "Havel's Leggings"]),
        LocationData(10256030, "[Gutter] Urn inside a small structure on top of the tower where the zip-line starts", ['Bandit Greataxe']),
        LocationData(10256060, "[Gutter] Urn in top level near the three torches side by side", ['Soul of a Nameless Soldier']),
        LocationData(10256090, "[Gutter] Urn in lower level of the structure where second long bridge ends", ['Black Firebomb']),
        LocationData(10256130, "[Gutter] Second urn at the bottom of the multiple ladders area", ['Dark Fog', 'Torch']),
        LocationData(10256160, "[Gutter] Before the entrance to the Black Gulch", ['Fragrant Branch of Yore']),
        LocationData(10256170, "[Gutter] First urn behind the ant queen", ['Poison Moss']),
        LocationData(10256210, "[Gulch] In the fire in the Rotten arena", ['Fire Seed']),
        LocationData(10256220, "[Gutter] Urn next to upper gutter bonfire", ['Dung Pie']),
        LocationData(10256230, "[Gutter] Urn in area with tar pits", ['Large Soul of a Nameless Soldier']),
        LocationData(10256240, "[Gutter] Urn next to upper gutter bonfire on a little bit higher ledge", ['Lifegem']),
        LocationData(10256250, "[Gutter] Urn in lower level near the ring of torches", ['Dark Pyromancy Flame', 'Rotten Pine Resin']),
        LocationData(10256260, "[Gutter] Urn in the 2nd floor of the tower where the zip-line starts", ['Titanite Chunk']),
        LocationData(10256270, "[Gutter] Urn next to hanging poison statue in the base of the tower where the zip-line starts", ['Tattered Cloth Hood', 'Tattered Cloth Robe', 'Tattered Cloth Manchettes', 'Heavy Boots']),
        LocationData(10256280, "[Gutter] Urn on top of the tower where the zip-line starts", ['Soul of a Proud Knight']),
        LocationData(10256290, "[Gutter] Urn in tight corner on middle level of the tower where the zip-line starts", ['Flame Butterfly']),
        LocationData(10256300, "[Gutter] Second urn behind the ant queen", ['Poison Moss']),
        LocationData(10256310, "[Gutter] Urn in between the fog gate and the ant queen", ['Poison Arrow']),
        LocationData(10256320, "[Gutter] Urn in the area with multiple ladders", ['Dung Pie']),
        LocationData(10256330, "[Gutter] Urn in wooden floor in multiple ladders area", ['Rotten Pine Resin']),
        LocationData(10256340, "[Gutter] First urn at the bottom of the multiple ladders area", ['Lifegem']),
        LocationData(10256350, "[Gulch] Urn at the bottom of the elevator near Gulch Giants", ['Silver Talisman']),
        LocationData(10256360, "[Gulch] Urn next to the second bonfire", ["Pharros' Lockstone"]),
        LocationData(10256370, "[Gulch] First urn in the front of the worms", ['Large Soul of a Nameless Soldier']),
        LocationData(10256380, "[Gulch] Second urn in the front of the worms", ['Scraps of Life', 'Torch']),
        LocationData(10256390, "[Gulch] Urn in the wide area before the rotten", ['Radiant Lifegem']),
        LocationData(10256400, "[Gutter] Corpse on top of the tower where the zip-line starts", ['Estus Flask Shard'], sotfs=True),
        LocationData(10256410, "[Gutter] First corpse in top level; near Jeff jump", ['Human Effigy'], sotfs=True),
        LocationData(10256420, "[Gutter] Second corpse in top level; near Jeff jump", ['Smooth & Silky Stone'], sotfs=True),
        LocationData(10256430, "[Gutter] Third corpse in top level; near Jeff jump", ['Twinkling Titanite'], sotfs=True),
        LocationData(10256440, "[Gutter] Fourth corpse in top level; near Jeff jump", ['Smooth & Silky Stone'], sotfs=True),
        LocationData(10256450, "[Gutter] Fifth corpse in top level; near Jeff jump", ['Fragrant Branch of Yore'], sotfs=True),
        LocationData(10256500, "[Gulch] Dropped from rotten's arm", ["Pharros' Lockstone"], skip=True),
        LocationData(60001000, "[Gulch] Reward for killing Gulch Giants", ['Forgotten Key', 'Soul of a Giant']),
    ],
    "Dragon Aerie": [
        LocationData(600000, "[DragonShrine] Ancient dragon drop", ['Ashen Mist Heart', 'Soul of a Giant', 'Petrified Dragon Bone']),
        LocationData(1787000, "[DragonShrine] Gift from ancient dragon when speaking to him", ['Ashen Mist Heart']),
        LocationData(10275000, "[DragonShrine] Metal chest in a side room right after the bonfire", ['Bonfire Ascetic']),
        LocationData(10275010, "[DragonShrine] Wooden chest on right side of the stairs", ['Titanite Slab']),
        LocationData(10275020, "[DragonShrine] Wooden chest on roof on the path to the left of the second Drakekeeper", ['Twinkling Titanite']),
        LocationData(10275021, "[DragonShrine] Wooden chest on roof on the path to the left of the second Drakekeeper in NG+", ['Twinkling Titanite'], ngp=True),
        LocationData(10275030, "[DragonShrine] Metal chest on a ledge that you jump to from the watchtower", ["Drakekeeper's Greataxe", "Drakekeeper's Greatshield"]),
        LocationData(10275040, "[DragonShrine] Metal chest just past petrified egg door", ['Third Dragon Ring']),
        LocationData(10275050, "[DragonShrine] Metal chest on outer ledge next to the petrified egg", ['Crystal Magic Weapon'], vanilla=True),
        LocationData(10275050, "[DragonShrine] Metal chest on outer ledge next to the petrified egg", ['Crystal Magic Weapon', 'Fragrant Branch of Yore'], sotfs=True),
        LocationData(10275060, "[DragonShrine] Metal chest behind the Pharros contraption under the staircase", ['Staff of Wisdom', 'Mask of Judgment', 'Robe of Judgment', 'Manchettes of Judgment', 'Tights of Judgment'], vanilla=True),
        LocationData(10275060, "[DragonShrine] Metal chest behind the Pharros contraption under the staircase", ['Mask of Judgment', 'Robe of Judgment', 'Manchettes of Judgment', 'Tights of Judgment'], sotfs=True),
        LocationData(10275070, "[DragonShrine] Metal chest next to the petrified egg", ['Watchdragon Parma'], vanilla=True),
        LocationData(10275070, "[DragonShrine] Metal chest next to the petrified egg", ['Petrified Something'], sotfs=True),
        LocationData(10276000, "[Aerie] On droppable small ledge before the third dragon nest", ['Soul of a Brave Warrior']),
        LocationData(10276010, "[Aerie] Corpse in the first dragon nest", ['Dragon Tooth']),
        LocationData(10276020, "[Aerie] Corpse in the first dragon nest (2)", ['Boltstone']),
        LocationData(10276030, "[Aerie] Corpse in the first dragon nest (3)", ['Soul of a Brave Warrior']),
        LocationData(10276040, "[Aerie] In the cave under the first dragon nest", ['Radiant Lifegem']),
        LocationData(10276041, "[Aerie] In the cave under the first dragon nest in NG+", ['Elizabeth Mushroom'], ngp=True),
        LocationData(10276050, "[Aerie] On droppable small ledge before the third dragon nest (2)", ["Pharros' Lockstone"]),
        LocationData(10276060, "[Aerie] Near the hollow priest by the second dragon nest", ['Petrified Dragon Bone']),
        LocationData(10276061, "[Aerie] Near the hollow priest by the second dragon nest in NG+", ['Petrified Dragon Bone'], ngp=True),
        LocationData(10276070, "[Aerie] In the middle of Aerie", ['Old Radiant Lifegem']),
        LocationData(10276080, "[Aerie] Corpse in the second dragon nest", ['Large Soul of a Brave Warrior']),
        LocationData(10276090, "[Aerie] Corpse in the third dragon nest", ['Firedrake Stone']),
        LocationData(10276100, "[Aerie] Corpse in the third dragon nest (2)", ['Ring of the Evil Eye+1']),
        LocationData(10276110, "[Aerie] Corpse in the third dragon nest (3)", ['Dragon Charm']),
        LocationData(10276120, "[Aerie] Corpse in the first dragon nest (4)", ['Darknight Stone']),
        LocationData(10276130, "[Aerie] On droppable small ledge close to the zip-line start", ['Twinkling Titanite']),
        LocationData(10276140, "[DragonShrine] On a corpse hanging off the ledge in the watchtower", ['Faintstone']),
        LocationData(10276150, "[DragonShrine] On a corpse in the corner before petrified egg door", ["Skeptic's Spice", 'Twilight Herb']),
        LocationData(10276160, "[Aerie] On a stone pillar you need to drop to from the zip-line", ['Soul of a Great Hero']),
        LocationData(10276170, "[Aerie] Corpse in the third dragon nest (4)", ['Bleed Stone']),
        LocationData(10276180, "[Aerie] Corpse in the second dragon nest (2)", ['Magic Stone']),
        LocationData(10276190, "[Aerie] In the cave under the first dragon nest (2)", ['Bonfire Ascetic'], sotfs=True),
    ],
    "Heide's Tower of Flame": [
        LocationData(611000, "[Heides] Dragonrider boss drop", ['Dragonrider Soul']),
        LocationData(1310500, "[Heides] Second enemy after first bonfire", ['Sublime Bone Dust'], vanilla=True, skip=True),
        LocationData(10305010, "[Heides] Metal chest behind petrified hollow after Dragonrider", ['Knight Helm', 'Knight Armor', 'Knight Gauntlets', 'Knight Leggings']),
        LocationData(10305020, "[Heides] Metal chest guarded by syan soldier after dragonrider", ['Sublime Bone Dust'], sotfs=True),
        LocationData(10306000, "[Heides] In alcove", ['Soul of a Proud Knight']),
        LocationData(10306010, "[Heides] Corpse on railing", ['Human Effigy', 'Dark Troches']),
        LocationData(10306020, "[Heides] In alcove (2)", ['Old Knight Halberd']),
        LocationData(10306030, "[Heides] On railing behind petrified hollow", ['Estus Flask Shard'], sotfs=True),
        LocationData(10315000, "[Heides] Metal chest before Dragonrider", ['Green Blossom'], vanilla=True),
        LocationData(10315000, "[Heides] Metal chest before Dragonrider", ['Ring of Binding'], sotfs=True),
        LocationData(10315001, "[Heides] Metal chest before Dragonrider in NG+", ['Human Effigy', 'Green Blossom'], ngp=True, vanilla=True),
        LocationData(10315001, "[Heides] Metal chest before Dragonrider in NG+", ['Human Effigy', 'Ring of Binding'], ngp=True, sotfs=True),
        LocationData(10316010, "[Heides] On the railing near first bonfire", ['Soul of a Nameless Soldier', 'Human Effigy']),
        LocationData(10316040, "[Heides] Under the spiral staircase after Dragonrider", ['Monastery Charm']),
        LocationData(10316041, "[Heides] Under the spiral staircase after Dragonrider in NG+", ['Monastery Charm'], ngp=True),
        LocationData(10316050, "[Heides] On the ledge on the way towards the cathedral", ['Divine Blessing']),
        LocationData(10316090, "[Heides] In the waterway from Majula", ['Soul of a Lost Undead', 'Broken Thief Sword']),
        LocationData(10316100, "[Heides] On a corpse near the first lever", ["Lloyd's Talisman"]),
        LocationData(10316101, "[Heides] On a corpse near the first lever in NG+", ["Skeptic's Spice"], ngp=True),
        LocationData(76900000, "[Licia of Lindeldt] Cleric's Sacred Chime", ["Cleric's Sacred Chime"], shop=True),
        LocationData(76900300, "[Licia of Lindeldt] Heal", ["Heal"], shop=True),
        LocationData(76900301, "[Licia of Lindeldt] Med Heal", ["Med Heal"], shop=True),
        LocationData(76900302, "[Licia of Lindeldt] Great Heal Excerpt", ["Great Heal Excerpt"], shop=True),
        LocationData(76900303, "[Licia of Lindeldt] Replenishment", ["Replenishment"], shop=True),
        LocationData(76900304, "[Licia of Lindeldt] Resplendent Life", ["Resplendent Life"], shop=True),
        LocationData(76900305, "[Licia of Lindeldt] Caressing Prayer", ["Caressing Prayer"], shop=True),
        LocationData(76900306, "[Licia of Lindeldt] Force", ["Force"], shop=True),
        LocationData(76900307, "[Licia of Lindeldt] Lightning Spear", ["Lightning Spear"], shop=True),
        LocationData(76900308, "[Licia of Lindeldt] Homeward", ["Homeward"], shop=True),
        LocationData(76900309, "[Licia of Lindeldt] Guidance", ["Guidance"], shop=True),
        LocationData(76900400, "[Licia of Lindeldt] Ring of Prayer", ["Ring of Prayer"], shop=True),
    ],
    "Cathedral of Blue": [
        LocationData(625000, "[Heides] Old Dragonslayer boss drop", ['Old Dragonslayer Soul', 'Old Leo Ring']),
        LocationData(10315010, "[Heides] Metal chest after Old Dragonslayer", ['Heide Knight Iron Mask', 'Tower Shield'], vanilla=True),
        LocationData(10315010, "[Heides] Metal chest after Old Dragonslayer", ["Cleric's Parma", 'Tower Shield'], sotfs=True),
        LocationData(10315020, "[Heides] Wooden chest after Old Dragonslayer", ['Cracked Blue Eye Orb']),
        LocationData(10315030, "[Heides] Metal chest before Old Dragonslayer", ['Ring of Binding', 'Human Effigy'], vanilla=True),
        LocationData(10315030, "[Heides] Metal chest before Old Dragonslayer", ['Human Effigy'], sotfs=True),
        LocationData(10316110, "[Heides] Next to metal chest before Old Dragonslayer", ['Old Radiant Lifegem']),
    ],
    "Shaded Woods": [
        LocationData(None, "Open Shrine of Winter", None, event=True),
        LocationData(503000, "[ShadedWoods] Scorpioness Najka drop", ['Scorpioness Najka Soul']),
        LocationData(503001, "[ShadedWoods] Scorpioness Najka drop in NG+", ['Scorpioness Najka Soul', 'Southern Ritual Band+2'], ngp=True),
        LocationData(1320100, "[ShadedWoods] Drop from Petrified Lion Warrior next to Golden Lion Warrior", ['Warlock Mask'], sotfs=True, skip=True),
        LocationData(1502000, "[ShadedWoods] Gift from Manscorpion Tark after defeating Najka", ['Fragrant Branch of Yore']),
        LocationData(10295000, "[ShadedWoods] Metal chest next to the Old Akelarre bonfire", ['Estus Flask Shard']),
        LocationData(10296020, "[ShadedWoods] Corpse in the room above the Old Akelarre bonfire", ['Soul of a Proud Knight', 'Human Effigy']),
        LocationData(10325000, "[ShadedWoods] Wooden chest on lower floor of the main Shaded Ruins bridge", ['Magic Bolt']),
        LocationData(10325001, "[ShadedWoods] Wooden chest On lower floor of the main Shaded Ruins bridge in NG+", ['Magic Bolt'], ngp=True),
        LocationData(10325010, "[ShadedWoods] Wooden chest on upper floor of the main Shaded Ruins bridge", ['Titanite Chunk', 'Petrified Dragon Bone']),
        LocationData(10325020, "[ShadedWoods] Metal chest on left side of the fog area", ['Chloranthy Ring+1']),
        LocationData(10325030, "[ShadedWoods] Metal chest on upper area by Manscorpion tark", ['Scythe']),
        LocationData(10325040, "[ShadedWoods] Metal chest in room blocked by petrified statue", ['Fragrant Branch of Yore', 'Lion Mage Robe', 'Lion Mage Cuffs', 'Lion Mage Skirt']),
        LocationData(10325050, "[ShadedWoods] Metal chest on right side of the fog area", ['Old Sun Ring']),
        LocationData(10325060, "[ShadedWoods] Metal chest next to Darkdiver Grandahl", ['Homing Soulmass']),
        LocationData(10325080, "[ShadedWoods] Metal chest next to a big tree in fog area", ['Clear Bluestone Ring+1']),
        LocationData(10325100, "[ShadedWoods] Metal chest blocked by petrified statue", ['Human Effigy', 'Bleeding Serum'], vanilla=True),
        LocationData(10325100, "[ShadedWoods] Metal chest blocked by petrified statue", ['Repair', 'Human Effigy', 'Bleeding Serum'], sotfs=True),
        LocationData(10325110, "[ShadedWoods] Metal chest under the main shaded ruins bridge", ['Black Knight Halberd']),
        LocationData(10325120, "[ShadedWoods] Metal chest in area behind two petrified statues", ['Sublime Bone Dust'], sotfs=True),
        LocationData(10326000, "[ShadedWoods] On ledge left side of the path to Ruined Fork Road bonfire", ["Pharros' Lockstone"]),
        LocationData(10326010, "[ShadedWoods] Left of the building leading to Manscorpion Tark", ['Flame Butterfly', 'Torch']),
        LocationData(10326020, "[ShadedWoods] On a ledge on left side of the path between Ruined Fork Road bonfire and Shrine of Winter", ['Ring of Life Protection', 'Large Soul of a Proud Knight'], vanilla=True),
        LocationData(10326020, "[ShadedWoods] On a ledge on left side of the path between Ruined Fork Road bonfire and Shrine of Winter", ['Large Soul of a Proud Knight', 'Human Effigy', 'Twinkling Titanite'], sotfs=True),
        LocationData(10326030, "[ShadedWoods] In front of the ruined gate just before shrine of winter", ["Dragonslayer's Crescent Axe", 'Golden Falcon Shield']),
        LocationData(10326040, "[ShadedWoods] On 2nd floor of the area with many lion warriors", ["Pharros' Lockstone", 'Soul of a Brave Warrior']),
        LocationData(10326060, "[ShadedWoods] Corpse just before the stone circle next to Head of Vengarl", ['Soul of a Proud Knight', 'Human Effigy']),
        LocationData(10326070, "[ShadedWoods] Corpse next to a tree in fog area", ['Soul of a Nameless Soldier', 'Radiant Lifegem']),
        LocationData(10326080, "[ShadedWoods] Corpse next to a big tree in fog area", ['Large Soul of a Nameless Soldier']),
        LocationData(10326081, "[ShadedWoods] Corpse next to a big tree in fog area in NG+", ['Soul of a Brave Warrior'], ngp=True),
        LocationData(10326090, "[ShadedWoods] Corpse in the middle of the fog area", ['Amber Herb']),
        LocationData(10326100, "[ShadedWoods] Corpse on right side of the fog area", ["Lloyd's Talisman"]),
        LocationData(10326101, "[ShadedWoods] Corpse on right side of the fog area in NG+", ["Gower's Ring of Protection", "Lloyd's Talisman"], ngp=True),
        LocationData(10326110, "[ShadedWoods] On the path to Ruined Fork Road bonfire", ['Fading Soul']),
        LocationData(10326120, "[ShadedWoods] On ledge next to the exit from the corrosive puddles area", ['Soul of a Brave Warrior', 'Firebomb']),
        LocationData(10326130, "[ShadedWoods] On upper floor above Shaded Ruins bonfire", ['Radiant Lifegem']),
        LocationData(10326140, "[ShadedWoods] Cave on right side of the door to Ornifex", ['Twinkling Titanite']),
        LocationData(10326141, "[ShadedWoods] Cave on right side of the door to Ornifex in NG+", ['Twinkling Titanite'], ngp=True),
        LocationData(10326150, "[ShadedWoods] Corpse next to chest in area behind two petrified statues and Vengarl's body", ['Soul of a Brave Warrior', 'Twilight Herb']),
        LocationData(10326160, "[ShadedWoods] Room where Ornifex is locked", ['Estus Flask Shard'], vanilla=True),
        LocationData(10326160, "[ShadedWoods] Room where Ornifex is locked", ['Fragrant Branch of Yore'], sotfs=True),
        LocationData(10326170, "[ShadedWoods] In the mud next to hippo", ['Red Tearstone Ring']),
        LocationData(10326180, "[ShadedWoods] On collapsed stairs next to Creighton", ['Soul of a Brave Warrior', "Skeptic's Spice"]),
        LocationData(10326190, "[ShadedWoods] Corpse next to the big collapsing floor", ['Lifegem']),
        LocationData(10326191, "[ShadedWoods] Corpse next to the big collapsing floor in NG+", ['Divine Blessing'], ngp=True),
        LocationData(10326200, "[ShadedWoods] On tree in Najka's arena", ['Flame Butterfly'], skip=True),
        LocationData(10326210, "[ShadedWoods] On lower floor of the building leading to Manscorpion Tark", ['Soul of a Brave Warrior', "Pharros' Lockstone"]),
        LocationData(10326230, "[ShadedWoods] Next to Vengarl's body", ['Torch']),
        LocationData(10326240, "[ShadedWoods] Behind the stone circle by Head of Vengarl", ['Fire Seed']),
        LocationData(10326270, "[ShadedWoods] Corpse getting eaten by goblins just before Ruined Fork Road bonfire", ['Soul of a Proud Knight'], sotfs=True),
        LocationData(10326280, "[ShadedWoods] Corpse getting eaten by goblins just before the Ruined Fork Road bonfire", ['Human Effigy'], sotfs=True),
        LocationData(30700000, "[Head of Vengarl] Claymore", ["Claymore"], shop=True),
        LocationData(30700001, "[Head of Vengarl] Greatsword", ["Greatsword"], shop=True),
        LocationData(30700002, "[Head of Vengarl] Red Rust Sword", ["Red Rust Sword"], shop=True),
        LocationData(30700003, "[Head of Vengarl] Red Rust Scimitar", ["Red Rust Scimitar"], shop=True),
        LocationData(30700100, "[Head of Vengarl] Red Rust Shield", ["Red Rust Shield"], shop=True),
        LocationData(30700300, "[Head of Vengarl] Magic Barrier", ["Magic Barrier"], shop=True),
        # LocationData(30700600, "[Head of Vengarl] Gold Pine Resin", ["Gold Pine Resin"], shop=True),
        # LocationData(30700601, "[Head of Vengarl] Lightning Urn", ["Lightning Urn"], shop=True),
        # LocationData(30700602, "[Head of Vengarl] Destructive Greatarrow", ["Destructive Greatarrow"], shop=True),
        LocationData(60009000, "[ShadedWoods] Drop from the petrified lion warrior by the tree bridge", ['Fang Key'], skip=True),
    ],
    "Doors of Pharros": [
        LocationData(None, "Defeat the Royal Rat Authority", None, event=True),
        LocationData(223500, "[Pharros] Royal Rat Authority drop", ['Royal Rat Authority Soul', 'Rat Tail']),
        LocationData(10335000, "[Pharros] Wooden chest in room after using top Pharros contraption and dropping down near the toxic rats", ['Faintstone', 'Twinkling Titanite']),
        LocationData(10335010, "[Pharros] Trapped wooden chest", ['Titanite Chunk', 'Petrified Dragon Bone']),
        LocationData(10335020, "[Pharros] Trapped wooden chest behind (floor) Pharros contraption in the upper level", ['Magic Arrow']),
        LocationData(10335021, "[Pharros] Trapped wooden chest behind (floor) Pharros contraption in the upper level in NG+", ['Magic Arrow'], ngp=True),
        LocationData(10335030, "[Pharros] Wooden chest in an alcove guarded by dwarf in the beginning of the long stairs to Brightstone", ['Dragon Charm']),
        LocationData(10335031, "[Pharros] Wooden chest in an alcove guarded by dwarf in the beginning of the long stairs to Brightstone in NG+", ['Dragon Charm'], ngp=True),
        LocationData(10335040, "[Pharros] Metal chest behind three-part pharros door in the lower level", ["Santier's Spear"]),
        LocationData(10336000, "[Pharros] In water before the first bonfire", ['Prism Stone']),
        LocationData(10336010, "[Pharros] In the room with Gavlan", ['Lifegem']),
        LocationData(10336011, "[Pharros] In the room with Gavlan in NG+", ['Old Radiant Lifegem'], ngp=True),
        LocationData(10336020, "[Pharros] Corpse- behind three-part Pharros' door in the upper level", ['Soul of a Brave Warrior']),
        LocationData(10336040, "[Pharros] In water in the far side of the first (lower) big hall", ['Amber Herb']),
        LocationData(10336041, "[Pharros] In water in the big hall right after Gyrm's Respite bonfire in NG+", ['Wilted Dusk Herb'], ngp=True),
        LocationData(10336050, "[Pharros] Corpse on a middle-level ledge in the first room", ['Gyrm Axe', 'Torch']),
        LocationData(10336060, "[Pharros] On ledge after climbing the ladder up from the water", ['Twisted Barricade', 'Soul of a Proud Knight']),
        LocationData(10336070, "[Pharros] Upper level", ["Pharros' Lockstone", 'Large Soul of a Nameless Soldier']),
        LocationData(10336080, "[Pharros] On 2nd floor next to dwarf statues", ['Large Soul of a Brave Warrior']),
        LocationData(72600402, "[Lonesome Gavlan - Doors of Pharros] Ring of Giants", ["Ring of Giants"], shop=True),
        LocationData(77700200, "[Sweet Shalquoir - Royal Rat Authority, Royal Rat Vanguard] Flying Feline Boots", ["Flying Feline Boots"], shop=True),
        # LocationData(72600604, "[Lonesome Gavlan - Doors of Pharros] Poison Moss", ["Poison Moss"], shop=True),
        # LocationData(72600605, "[Lonesome Gavlan - Doors of Pharros] Rotten Pine Resin", ["Rotten Pine Resin"], shop=True),
        # LocationData(72600606, "[Lonesome Gavlan - Doors of Pharros] Poison Throwing Knife", ["Poison Throwing Knife"], shop=True),
        # LocationData(72600607, "[Lonesome Gavlan - Doors of Pharros] Poison Arrow", ["Poison Arrow"], shop=True),
    ],
    "Grave of Saints": [
        LocationData(None, "Defeat the Royal Rat Vanguard", None, event=True),
        LocationData(226100, "[GraveOfSaints] Royal rat vanguard drop", ['Royal Rat Vanguard Soul', 'Rat Tail']),
        LocationData(10045020, "[Pit] First metal chest behind the forgotten door", ['Soul Vortex']),
        LocationData(10045030, "[Pit] Third metal chest behind the forgotten door", ['Great Lightning Spear']),
        LocationData(10045050, "[Pit] Second metal chest behind the forgotten door", ['Witchtree Branch', 'Witchtree Bellvine']),
        LocationData(10046050, "[Pit] Third board in the pit", ['Poison Moss']),
        LocationData(10046060, "[Pit] Second board in the pit", ["Pharros' Lockstone"]),
        LocationData(10046090, "[Pit] Fourth board in the pit", ['Ring of the Evil Eye+1']),
        LocationData(10046130, "[Pit] First board in the pit", ['Radiant Lifegem']),
        LocationData(10046140, "[Pit] Corpse behind the forgotten door", ['Dragon Talon'], sotfs=True),
        LocationData(10046150, "[Pit] Entrance to corridor before bridge crystal lizard", ['Homeward Bone'], sotfs=True),
        LocationData(10345000, "[Pit] Metal chest after jumping across the wooden bridge in the circular room with explosive hollows", ['Ash Knuckle Ring']),
        LocationData(10345010, "[Pit] Wooden chest under the scaffolding before the gutter", ['Token of Spite']),
        LocationData(10345020, "[Pit] Metal chest guarded by syan soldier", ['Sublime Bone Dust'], sotfs=True),
        LocationData(10346000, "[Pit] First corpse on scaffolding before the Gutter", ['Human Effigy']),
        LocationData(10346010, "[Pit] Second corpse on scaffolding before the Gutter", ['Radiant Lifegem']),
        LocationData(10346020, "[GraveOfSaints] 2nd floor on other side of the drawbridges", ['Whisper of Despair', 'Torch']),
        LocationData(10346030, "[GraveOfSaints] In the first circular room of Grave of Saints", ['Large Soul of a Nameless Soldier']),
        LocationData(10346031, "[GraveOfSaints] In the first circular room of Grave of Saints in NG+", ['Large Soul of a Brave Warrior'], ngp=True),
        LocationData(10346040, "[GraveOfSaints] 2nd floor left side next to table", ['Homeward Bone']),
        LocationData(10346050, "[GraveOfSaints] 1st floor on other side of the drawbridges", ['Poison Moss']),
        LocationData(10346060, "[GraveOfSaints] In the middle circle of the circular room", ["Pharros' Lockstone"]),
        LocationData(10346070, "[Pit] First corpse in the circular room", ['Great Heal']),
        LocationData(10346080, "[GraveOfSaints] 1st floor left side", ['Small Smooth & Silky Stone']),
        LocationData(10346090, "[Pit] On the higher bridge  of the circular room after Rat Vanguard", ['Bleed Stone']),
        LocationData(10346091, "[Pit] On the higher bridge of the circular room after Rat Vanguard in NG+", ['Twinkling Titanite', 'Bleed Stone'], ngp=True),
        LocationData(10346100, "[Pit] On a small unconnected ledge offset from the wooden bridge in the circular room", ['Disc Chime']),
        LocationData(10346110, "[Pit] Second corpse in the circular room with explosive hollows", ['Homeward Bone'], sotfs=True),
    ],
    "Memory of Jeigh":[
        LocationData(309700, "[MemoryJeigh] Giant Lord drop", ['Giant Lord Soul', "Giant's Kinship"]),
        LocationData(309701, "[MemoryJeigh] Giant Lord drop in NG+", ['Giant Lord Soul', "Giant's Kinship", 'Ring of Giants+2'], ngp=True),
        LocationData(20106100, "[MemoryJeigh] First left in Giant Lord's memory", ['Bonfire Ascetic']),
        LocationData(20106110, "[MemoryJeigh] On the battlefield", ['Old Radiant Lifegem']),
        LocationData(20106111, "[MemoryJeigh] On the battlefield in NG+", ['Divine Blessing'], ngp=True),
        LocationData(20106120, "[MemoryJeigh] Up the second set of stairs in the Giant Lord memory", ['Fire Seed']),
    ],
    "Memory of Vammar":[
        LocationData(20105000, "[MemoryVammar] Wooden chest in side room opposite Captain Drummond", ['Smooth & Silky Stone']),
        LocationData(20105001, "[MemoryVammar] Wooden chest in side room opposite Captain Drummond in NG+", ['Smooth & Silky Stone', 'Petrified Something'], ngp=True),
        LocationData(20105010, "[MemoryVammar] Metal chest in the corner of the main battlefield area", ['Blossom Kite Shield'], vanilla=True),
        LocationData(20105010, "[MemoryVammar] Metal chest in the corner of the main battlefield area", ['Petrified Something'], sotfs=True),
        LocationData(20106000, "[MemoryVammar] Behind a corner in the first corridor after Drummond", ['Fire Seed']),
        LocationData(20106010, "[MemoryVammar] On the second floor of the ruined house", ['Large Soul of a Nameless Soldier']),
        LocationData(20106011, "[MemoryVammar] On the second floor of the ruined house in NG+", ['Large Soul of a Brave Warrior'], ngp=True),
        LocationData(20106020, "[MemoryVammar] In the corner of the roof", ['Soul of a Great Hero', 'Bonfire Ascetic']),
        LocationData(20106030, "[MemoryVammar] In the far right corner of the main battlefield area", ['Giant Warrior Club']),
        LocationData(20106040, "[MemoryVammar] At the top of the final stairs in Memory of Vammar", ['Old Radiant Lifegem']),
        LocationData(20106060, "[MemoryVammar] Next to the stairs just before the end of Memory of Vammar", ['Rouge Water']),
        LocationData(20106061, "[MemoryVammar] Next to the stairs just before the end of Memory of Vammar in NG+", ['Crimson Water'], ngp=True),
        LocationData(20106150, "[MemoryVammar] In the corner of the last platform in Memory of Vammar", ['Soul of a Great Hero', 'Torch']),
    ],
    "Memory of Orro":[
        LocationData(20105020, "[MemoryOrro] Trapped wooden chest behind a Pharros' contraption on the second floor", ['Soul of a Hero']),
        LocationData(20105030, "[MemoryOrro] Metal chest behind a Pharros contraption and an illusory wall on the second floor", ['Fire Seed']),
        LocationData(20105040, "[MemoryOrro] Metal chest behind a Pharros contraption and an illusory wall on the second floor (2)", ['Steel Helm', 'Steel Armor', 'Steel Gauntlets', 'Steel Leggings']),
        LocationData(20105050, "[MemoryOrro] Metal chest in the room where you need to drop the crane", ['Bonfire Ascetic']),
        LocationData(20105060, "[MemoryOrro] Metal chest in the room where you need to drop the crane (2)", ['Grand Lance'], vanilla=True),
        LocationData(20105060, "[MemoryOrro] Metal chest in the room where you need to drop the crane (2)", ["Simpleton's Spice", "Skeptic's Spice"], sotfs=True),
        LocationData(20106050, "[MemoryOrro] In the corner of the second floor room of the entrace stairs", ['Fading Soul']),
        LocationData(20106070, "[MemoryOrro] On the bridge above courtyard", ['Soul of a Brave Warrior']),
        LocationData(20106080, "[MemoryOrro] In the corner of the courtyard", ['Soul of a Great Hero', 'Soul Vessel']),
        LocationData(20106090, "[MemoryOrro] At the side of the center of the courtyard", ['Large Soul of a Proud Knight']),
        LocationData(20106130, "[MemoryOrro] On the roof looking onto courtyard after climbing ladder", ['Wilted Dusk Herb']),
        LocationData(20106140, "[MemoryOrro] On scaffolding after climbing a ladder from the courtyard", ['Soul of a Proud Knight']),
        LocationData(20106141, "[MemoryOrro] On scaffolding after climbing a ladder from the courtyard in NG+", ['Soul of a Hero'], ngp=True),
    ],
    "Shrine of Amana": [
        LocationData(602000, "[Amana] Demon of Song drop", ['Demon of Song Soul', 'Key to the Embedded']),
        LocationData(20115000, "[Amana] Wooden chest on side path right through door a few steps below the first bonfire", ['Wilted Dusk Herb', "Skeptic's Spice"]),
        LocationData(20115010, "[Amana] Wooden chest submerged in water immediately left from the bottom of the first staircase", ['Elizabeth Mushroom']),
        LocationData(20115020, "[Amana] Wooden chest in water on left before the first fog gate", ['Dragon Charm']),
        LocationData(20115030, "[Amana] Wooden chest behind the first hut", ['Crimson Water']),
        LocationData(20115040, "[Amana] Metal chest in cave before the first fog gate", ['Twinkling Titanite', 'Smooth & Silky Stone']),
        LocationData(20115050, "[Amana] Wooden chest in water to the right of the door to Undead Crypt", ['Magic Arrow']),
        LocationData(20115051, "[Amana] Wooden chest in water to the right of the door to Undead Crypt in NG+", ['Magic Arrow', 'Dark Arrow'], ngp=True),
        LocationData(20115060, "[Amana] Metal chest at the end of the narrow underwater walkway", ['Sunlight Blade']),
        LocationData(20115070, "[Amana] Metal chest behind a door that opens after defeating vendrick", ["King's Crown", "King's Armor", "King's Gauntlets", "King's Leggings"]),
        LocationData(20115080, "[Amana] Metal chest in water side from the second hut", ['Fire Tempest']),
        LocationData(20115090, "[Amana] Metal chest behind a pharros contraption near the crumbled ruins bonfire", ['Helix Halberd']),
        LocationData(20115100, "[Amana] Metal chest in left-side water at bottom of stairs by the praying Milfanito", ['Manslayer']),
        LocationData(20115110, "[Amana] Metal chest in right-side water at bottom of stairs by the praying Milfanito", ['Bonfire Ascetic']),
        LocationData(20115500, "[Amana] On a throne behind a door that opens after defeating vendrick", ['Soul of the King']),
        LocationData(20116000, "[Amana] On narrow walkway just after Rhoy's Resting Place bonfire", ['Large Soul of a Proud Knight', 'Green Blossom']),
        LocationData(20116010, "[Amana] Under the circular staircase in the beginning of the area", ['Large Soul of a Nameless Soldier']),
        LocationData(20116011, "[Amana] Under the circular staircase in the beginning of the area in NG+", ['Soul of a Brave Warrior'], ngp=True),
        LocationData(20116020, "[Amana] On island with three archdrakes before the first fog gate", ['Soul of a Lost Undead', "Skeptic's Spice"]),
        LocationData(20116030, "[Amana] In the end of the narrow underwater walkway", ['Estus Flask Shard']),
        LocationData(20116040, "[Amana] Near the half circle of pillars", ['Fire Seed']),
        LocationData(20116060, "[Amana] In the middle of circle of pillars after the rhoy's resting place bonfire", ["Skeptic's Spice"]),
        LocationData(20116070, "[Amana] In the middle of circle of pillars after the rhoy's resting place bonfire (2)", ['Soul of a Brave Warrior', 'Petrified Dragon Bone']),
        LocationData(20116080, "[Amana] In the middle of circle of pillars after the rhoy's resting place bonfire (3)", ['Red Iron Twinblade', 'Soul of a Proud Knight']),
        LocationData(20116090, "[Amana] Behind a fallen pilar next to the circle of pillars after the Rhoy's Resting place bonfire", ['Homing Crystal Soulmass']),
        LocationData(20116100, "[Amana] Next to torch before the demon of song", ['Large Soul of a Proud Knight', 'Green Blossom']),
        LocationData(20116110, "[Amana] In cave under the stairs leading down from the praying Milfanito", ['Fire Seed']),
        LocationData(20116120, "[Amana] On island with three archdrakes before the first fog gate (2)", ['Large Soul of a Proud Knight']),
        LocationData(20116130, "[Amana] Corpse hanging from branch in the beginning of the area", ['Flame Butterfly', 'Twinkling Titanite']),
        LocationData(20116140, "[Amana] On narrow walkway to the right of the second fog gate", ['Soul of a Hero', 'Divine Blessing']),
        LocationData(20116150, "[Amana] Behind roots before the first bonfire", ['Green Blossom']),
        LocationData(20116160, "[Amana] On island with three archdrakes before the first fog gate (3)", ['Soul of a Lost Undead', 'Torch']),
        LocationData(20116170, "[Amana] In the second hut", ['Large Soul of a Proud Knight', 'Old Radiant Lifegem']),
        LocationData(20116171, "[Amana] In the second hut in NG+", ['Large Soul of a Brave Warrior', 'Elizabeth Mushroom'], ngp=True),
        LocationData(20116190, "[Amana] On rising-beam to the left of the second fog gate", ['Alluring Skull']),
        LocationData(20116200, "[Amana] In a cave behind roots with a hippo", ["Singer's Dress", 'Life Ring+2']),
        LocationData(20116210, "[Amana] In the second hut (2)", ['Smooth & Silky Stone'], sotfs=True),
        LocationData(20116220, "[Amana] On small island surrounding by lizardmen", ['Human Effigy'], sotfs=True),
    ],
    "Throne of Want": [
        LocationData(332000, "[Drangleic] Throne Watcher and Defender drop", ['Throne Defender Soul', 'Throne Watcher Soul']),
        LocationData(332001, "[Drangleic] Throne Watcher and Defender drop in NG+", ['Throne Defender Soul', 'Throne Watcher Soul', 'Ring of the Evil Eye+2'], ngp=True),
        LocationData(None, "Defeat Nashandra", None, event=True),
        LocationData(627000, "[Drangleic] Nashandra drop", ['Soul of Nashandra']),
    ],
    "Drangleic Castle": [
        LocationData(309610, "[Drangleic] Twin Dragonriders drop", ['Dragonrider Soul']),
        LocationData(10326220, "[ShadedWoods] Behind the ruined gate", ['Repair', 'Large Soul of a Lost Undead'], vanilla=True),
        LocationData(10326220, "[ShadedWoods] Behind the ruined gate", ['Soul of a Hero'], sotfs=True),
        LocationData(10326250, "[ShadedWoods] On the path after Shrine of Winter", ['Divine Blessing']),
        LocationData(10326260, "[ShadedWoods] On a wall along the path after Shrine of Winter", ['Large Soul of a Nameless Soldier', 'Human Effigy']),
        LocationData(20215000, "[Drangleic] Metal chest one level down from the Forgotten Chamber bonfire", ["Hunter's Blackbow", 'Iron Arrow']),
        LocationData(20215010, "[Drangleic] Wooden chest in acid pool", ['Corrosive Urn']),
        LocationData(20215011, "[Drangleic] Wooden chest in acid pool in NG+", ['Titanite Slab', 'Corrosive Urn'], ngp=True),
        LocationData(20215020, "[Drangleic] Wooden chest right after the multi-door sentinel room", ['Dark Arrow']),
        LocationData(20215021, "[Drangleic] Wooden chest right after the multi-door sentinel room in ng+", ['Dark Arrow'], ngp=True),
        LocationData(20215040, "[Drangleic] Trapped wooden chest in room with Chariot", ['Fire Greatarrow'], vanilla=True),
        LocationData(20215041, "[Drangleic] Trapped wooden chest in room with Chariot in NG+", ['Fire Greatarrow', 'Destructive Greatarrow'], ngp=True, vanilla=True),
        LocationData(20215050, "[Drangleic] Metal chest in alcove of one of the doors in the multi-door Sentinel room", ["Royal Soldier's Ring+1"]),
        LocationData(20215060, "[Drangleic] Metal chest in the embedded room", ['Soul Vessel', 'Fire Seed']),
        LocationData(20215070, "[Drangleic] Metal chest in the desert sorceress room", ['Estus Flask Shard']),
        LocationData(20215080, "[Drangleic] Metal chest on the right side of the Drangleic gate", ['Great Combustion', 'Fire Seed']),
        LocationData(20215090, "[Drangleic] Metal chest in the upper level of the Drangleic Executioner Chariot room", ['Firestorm']),
        LocationData(20215100, "[Drangleic] Metal chest (left) in the embedded room", ["Key to King's Passage"]),
        LocationData(20215110, "[Drangleic] Metal chest in the embedded room (2)", ['Strong Magic Shield']),
        LocationData(20215120, "[Drangleic] Metal chest in room after the soul-catching golem", ['Old Knight Hammer']),
        LocationData(20215130, "[Drangleic] Metal chest in alcove of one of the doors in the multi-door Sentinel room (2)", ['Mastodon Greatsword']),
        LocationData(20215140, "[Drangleic] Metal chest in room after the soul-catching golem (2)", ["Caitha's Chime", 'Soul Greatsword']),
        LocationData(20215160, "[Drangleic] Metal chest on left-hand side behind wellager", ['Sublime Bone Dust'], sotfs=True),
        LocationData(20215170, "[Drangleic] Wooden chest in the poison dart trap room", ['Large Soul of a Brave Warrior', 'Twinkling Titanite'], sotfs=True),
        LocationData(20216000, "[Drangleic] In alcove of one of the doors in the multi-door Sentinel room", ["Pharros' Lockstone"]),
        LocationData(20216010, "[Drangleic] In the cave next to the entrance to the dark chasm", ['Faraam Helm', 'Faraam Armor', 'Faraam Gauntlets', 'Faraam Boots']),
        LocationData(20216020, "[Drangleic] Next to stairs right after the multi-door sentinel room", ['Soul of a Hero', 'Old Radiant Lifegem', 'Monastery Charm']),
        LocationData(20216021, "[Drangleic] Next to stairs right after the multi-door sentinel room in ng+", ['Great Magic Barrier'], ngp=True),
        LocationData(20216030, "[Drangleic] In acid pool", ['Elizabeth Mushroom']),
        LocationData(20216040, "[Drangleic] In the room with cursed painting of Nashandra", ['Large Soul of a Brave Warrior', 'Twinkling Titanite'], vanilla=True),
        LocationData(20216040, "[Drangleic] In the room with cursed painting of Nashandra", ['Fire Greatarrow', 'Destructive Greatarrow'], sotfs=True),
        LocationData(20216050, "[Drangleic] Next to Forgotten Chamber bonfire", ['Soul of a Brave Warrior']),
        LocationData(20216090, "[Drangleic] Behind a rock on the path towards drangleic castle", ['Holy Water Urn']),
        LocationData(20216100, "[Drangleic] Corpse in the desert sorceress room", ['Repair Powder', 'Flame Butterfly']),
        LocationData(20216110, "[Drangleic] In front of the stairs right after the multi-door sentinel room", ['Frozen Flower'], sotfs=True),
        LocationData(20216130, "[Drangleic] In the room with cursed painting of Nashandra (2)", ['Petrified Dragon Bone'], sotfs=True),
        LocationData(20216140, "[Drangleic] In the room with cursed painting of Nashandra (3)", ['Torch'], sotfs=True),
        LocationData(72110000, "[Chancellor Wellager] Flamberge", ["Flamberge"], shop=True),
        LocationData(72110001, "[Chancellor Wellager] Lucerne", ["Lucerne"], shop=True),
        LocationData(72110007, "[Chancellor Wellager - NG+2] Curved Twinblade", ["Curved Twinblade"], ngp=True, shop=True),
        LocationData(72110008, "[Chancellor Wellager - NG+2] Crescent Sickle", ["Crescent Sickle"], ngp=True, shop=True),
        LocationData(72110105, "[Chancellor Wellager - NG+2] Spirit Tree Shield", ["Spirit Tree Shield"], ngp=True, shop=True),
        LocationData(72110300, "[Chancellor Wellager - NG+2] Wrath of the Gods", ["Wrath of the Gods"], ngp=True, shop=True),
        LocationData(72110301, "[Chancellor Wellager - NG+2] Bountiful Sunlight", ["Bountiful Sunlight"], ngp=True, shop=True),
        LocationData(72110302, "[Chancellor Wellager - NG+2] Great Chaos Fireball", ["Great Chaos Fireball"], ngp=True, shop=True),
        LocationData(72110303, "[Chancellor Wellager] Great Magic Barrier", ["Great Magic Barrier"], shop=True),
        LocationData(72110400, "[Chancellor Wellager] Bracing Knuckle Ring+1", ["Bracing Knuckle Ring+1"], shop=True),
        # LocationData(72110600, "[Chancellor Wellager] Old Radiant Lifegem", ["Old Radiant Lifegem"], shop=True),
        # LocationData(72110601, "[Chancellor Wellager] Wilted Dusk Herb", ["Wilted Dusk Herb"], shop=True),
        LocationData(72110602, "[Chancellor Wellager] Divine Blessing", ["Divine Blessing"], shop=True),
        # LocationData(72110603, "[Chancellor Wellager] Repair Powder", ["Repair Powder"], shop=True),
        # LocationData(72110604, "[Chancellor Wellager] Magic Arrow", ["Magic Arrow"], shop=True),
        # LocationData(72110605, "[Chancellor Wellager] Lightning Arrow", ["Lightning Arrow"], shop=True),
        # LocationData(72110606, "[Chancellor Wellager] Magic Bolt", ["Magic Bolt"], shop=True),
        # LocationData(72110607, "[Chancellor Wellager] Lightning Bolt", ["Lightning Bolt"], shop=True),
        # LocationData(72500300, "[Darkdiver Grandahl] Cast Light", ["Cast Light"], shop=True),
        # LocationData(72500301, "[Darkdiver Grandahl] Dark Orb", ["Dark Orb"], shop=True),
        # LocationData(72500302, "[Darkdiver Grandahl] Dark Hail", ["Dark Hail"], shop=True),
        # LocationData(72500303, "[Darkdiver Grandahl] Darkstorm", ["Darkstorm"], shop=True),
        # LocationData(72500304, "[Darkdiver Grandahl] Profound Still", ["Profound Still"], shop=True),
        # LocationData(72500600, "[Darkdiver Grandahl] Human Effigy", ["Human Effigy"], shop=True),
        # LocationData(72500601, "[Darkdiver Grandahl] Bonfire Ascetic", ["Bonfire Ascetic"], shop=True),
    ],
    "King's Passage": [
        LocationData(None, "Defeat the Looking Glass Knight", None, event=True),
        LocationData(504000, "[Drangleic] Looking Glass Knight drop", ['Looking Glass Knight Soul']),
        LocationData(504001, "[Drangleic] Looking Glass Knight drop in NG+", ['Looking Glass Knight Soul', 'Ring of Steel Protection+2'], ngp=True),
        LocationData(20215150, "[Drangleic] Metal chest after looking glass knight", ['Soul Bolt', 'Spell Quartz Ring+2', 'Bonfire Ascetic']),
        LocationData(20216060, "[Drangleic] Between the stone horse-knights", ['Lifegem']),
        LocationData(20216061, "[Drangleic] Between the stone horse-knights in NG+", ['Old Radiant Lifegem', 'Petrified Dragon Bone'], ngp=True),
        LocationData(20216070, "[Drangleic] Between the stone horse-knights (2)", ['Soul of a Proud Knight', 'Twinkling Titanite']),
        LocationData(20216080, "[Drangleic] First right side in mirror knight approach corridor", ['Alluring Skull']),
        LocationData(20216120, "[Drangleic] Between the stone horse-knights (3)", ['Petrified Something'], sotfs=True),
        LocationData(72110002, "[Chancellor Wellager - Looking Glass Knight] Black Flamestone Dagger", ["Black Flamestone Dagger"], shop=True),
        LocationData(72110003, "[Chancellor Wellager - Looking Glass Knight] Yellow Quartz Longsword", ["Yellow Quartz Longsword"], shop=True),
        LocationData(72110004, "[Chancellor Wellager - Looking Glass Knight] Bound Hand Axe", ["Bound Hand Axe"], shop=True),
        LocationData(72110005, "[Chancellor Wellager - Looking Glass Knight] Homunculus Mace", ["Homunculus Mace"], shop=True),
        LocationData(72110006, "[Chancellor Wellager - Looking Glass Knight] Transgressor's Staff", ["Transgressor's Staff"], shop=True),
        LocationData(72110100, "[Chancellor Wellager - Looking Glass Knight] Black Flamestone Parma", ["Black Flamestone Parma"], shop=True),
        LocationData(72110101, "[Chancellor Wellager - Looking Glass Knight] Yellow Quartz Shield", ["Yellow Quartz Shield"], shop=True),
        LocationData(72110102, "[Chancellor Wellager - Looking Glass Knight] Bound Wooden Shield", ["Bound Wooden Shield"], shop=True),
        LocationData(72110103, "[Chancellor Wellager - Looking Glass Knight] Homunculus Wooden Shield", ["Homunculus Wooden Shield"], shop=True),
        LocationData(72110104, "[Chancellor Wellager - Looking Glass Knight] Transgressor's Leather Shield", ["Transgressor's Leather Shield"], shop=True),
        LocationData(76100239, "[Maughlin the Armourer - Looking Glass Knight] Looking Glass Mask", ["Looking Glass Mask"], shop=True),
        LocationData(76100240, "[Maughlin the Armourer - Looking Glass Knight] Looking Glass Armor", ["Looking Glass Armor"], shop=True),
        LocationData(76100241, "[Maughlin the Armourer - Looking Glass Knight] Looking Glass Gauntlets", ["Looking Glass Gauntlets"], shop=True),
        LocationData(76100242, "[Maughlin the Armourer - Looking Glass Knight] Looking Glass Leggings", ["Looking Glass Leggings"], shop=True),
    ],
    "Undead Crypt": [
        LocationData(None, "Defeat Velstadt", None, event=True),
        LocationData(333000, "[Crypt] Velstadt drop", ['Soul of Velstadt']),
        LocationData(333001, "[Crypt] Velstadt drop in NG+", ['Soul of Velstadt', "Royal Soldier's Ring+2"], ngp=True),
        LocationData(2240100, "[Crypt] Drop from an Insolent Knight that spawns when you light up the Crypt", ['Fragrant Branch of Yore'], sotfs=True, skip=True),
        LocationData(20245000, "[Crypt] Metal chest near the torch that lights up the big statues", ['Soul Vessel']),
        LocationData(20245010, "[Crypt] Wooden chest on left side of the doorway leading to the great hall and Velstadt", ['Magic Stone', 'Darknight Stone']),
        LocationData(20245020, "[Crypt] Metal chest on balcony of the second graveyard room", ['Dried Fingers', 'Bonfire Ascetic', 'Twinkling Titanite']),
        LocationData(20245030, "[Crypt] Metal chest above the bridge after agdayne", ['Crushed Eye Orb', 'Fire Seed']),
        LocationData(20245040, "[Crypt] Metal chest behind a illusory wall and a Pharros contraption from the third graveyard room", ["Olenford's Staff", 'Great Lightning Spear']),
        LocationData(20245050, "[Crypt] Metal chest behind a illusory wall from the room where Nameless Usurper invades", ['Avelyn', 'Heavy Bolt']),
        LocationData(20245070, "[Crypt] Metal chest right before Velstadt", ['Fragrant Branch of Yore'], sotfs=True),
        LocationData(20245080, "[Crypt] Metal chest right before Velstadt (2)", ['Torch'], sotfs=True),
        LocationData(20245090, "[Crypt] Metal chest right before Velstadt (3)", ['Poison Throwing Knife'], sotfs=True),
        LocationData(20245100, "[Crypt] Metal chest right before Velstadt (4)", ['Darknight Stone'], sotfs=True),
        LocationData(20246000, "[Crypt] Right side of the stairs next to Undead Crypt Entrance bonfire", ['Radiant Lifegem']),
        LocationData(20246010, "[Crypt] Next to Agdayne", ['Large Soul of a Nameless Soldier']),
        LocationData(20246011, "[Crypt] Next to Agdayne in NG+", ['Soul of a Brave Warrior'], ngp=True),
        LocationData(20246030, "[Crypt] Under the bridge leading from Agdayne to the second bonfire", ["Simpleton's Spice", 'Soul of a Great Hero']),
        LocationData(20246040, "[Crypt] Corpse in the first graveyard room", ["Simpleton's Spice", 'Black Firebomb']),
        LocationData(20246050, "[Crypt] Corpse in the second graveyard room", ['Bracing Knuckle Ring+2']),
        LocationData(20246070, "[Crypt] In side tunnel of the third graveyard room", ['Large Soul of a Proud Knight', 'Dragon Charm']),
        LocationData(20246100, "[Crypt] In small room above the second bonfire", ['Soul of a Hero']),
        LocationData(20246110, "[Crypt] Corpse in the first graveyard room (2)", ['Titanite Chunk', 'Petrified Dragon Bone']),
        LocationData(20246111, "[Crypt] Corpse in the first graveyard room in NG+", ['Titanite Chunk', 'Petrified Dragon Bone'], ngp=True),
        LocationData(20246120, "[Crypt] Corpse in the second graveyard room (2)", ['Soul of a Lost Undead']),
        LocationData(20246121, "[Crypt] Corpse in the second graveyard room in NG+", ['Large Soul of a Brave Warrior'], ngp=True),
        LocationData(20246130, "[Crypt] In room where Nameless Usurper invades", ['Divine Blessing', 'Soul of a Hero']),
        LocationData(20246140, "[Crypt] In room where Nameless Usurper invades (2)", ['Mace of the Insolent', 'Soul of a Hero']),
        LocationData(20246150, "[Crypt] Corpse in the third graveyard room", ['Radiant Lifegem', 'Homeward Bone']),
        LocationData(20246151, "[Crypt] Corpse in the third graveyard room in NG+", ['Elizabeth Mushroom', 'Homeward Bone'], ngp=True),
        LocationData(20246180, "[Crypt] Corpse in the first graveyard room (3)", ['Human Effigy'], sotfs=True),
        LocationData(20246190, "[Crypt] Corpse in the first graveyard room (4)", ['Smooth & Silky Stone'], sotfs=True),
        LocationData(20246200, "[Crypt] Corpse in the first graveyard room (5)", ['Smooth & Silky Stone'], sotfs=True),
        LocationData(20246210, "[Crypt] Corpse in the first graveyard room (6)", ['Smooth & Silky Stone'], sotfs=True),
        LocationData(20246220, "[Crypt] Corpse in the first graveyard room (7)", ['Soul of a Hero'], sotfs=True),
        LocationData(20246500, "[Crypt] Looted from vendrick's armor", ["King's Ring"]),
        LocationData(50600300, "[Grave Warden Agdayne] Soul Spear", ["Soul Spear"], shop=True),
        LocationData(50600301, "[Grave Warden Agdayne] Soul Vortex", ["Soul Vortex"], shop=True),
        LocationData(50600302, "[Grave Warden Agdayne] Soul Appease", ["Soul Appease"], shop=True),
        LocationData(50600303, "[Grave Warden Agdayne] Warmth", ["Warmth"], shop=True),
        LocationData(50600401, "[Grave Warden Agdayne] Ring of Thorns+1", ["Ring of Thorns+1"], shop=True),
        # LocationData(50600600, "[Grave Warden Agdayne] Human Effigy", ["Human Effigy"], shop=True),
        # LocationData(50600601, "[Grave Warden Agdayne] Elizabeth Mushroom", ["Elizabeth Mushroom"], shop=True),
        # LocationData(50600602, "[Grave Warden Agdayne] Dark Arrow", ["Dark Arrow"], shop=True),
        # LocationData(50600603, "[Grave Warden Agdayne] Dark Bolt", ["Dark Bolt"], shop=True),
        LocationData(76100247, "[Maughlin the Armourer - Velstadt] Velstadt's Helm", ["Velstadt's Helm"], shop=True),
        LocationData(76100248, "[Maughlin the Armourer - Velstadt] Velstadt's Armor", ["Velstadt's Armor"], shop=True),
        LocationData(76100249, "[Maughlin the Armourer - Velstadt] Velstadt's Gauntlets", ["Velstadt's Gauntlets"], shop=True),
        LocationData(76100250, "[Maughlin the Armourer - Velstadt] Velstadt's Leggings", ["Velstadt's Leggings"], shop=True),
        LocationData(76200606, "[Stone Trader Chloanne - Velstadt] Titanite Slab", ["Titanite Slab"], shop=True),
    ],
    "Dark Chasm of Old": [
        LocationData(506100, "[Drangleic] Darklurker drop", ['Darklurker Soul']),
    ],
    "Shulva - Dragon Stone": [
        LocationData(681000, "[DLC1] Sinh", ['Soul of Sinh, the Slumbering Dragon']),
        LocationData(682000, "[DLC1] Elana", ['Soul of Elana, Squalid Queen']),
        LocationData(50356450, "[DLC1] In corridor one level up from Sanctum Interior bonfire", ['Hexing Urn']),
        LocationData(50356460, "[DLC1] In side corridor one level up from Dragon's rest", ['Large Soul of a Brave Warrior']),
        LocationData(50356470, "[DLC1] In side corridor one level up from Dragon's rest (2)", ['Twinkling Titanite']),
        LocationData(50356480, "[DLC1] In side corridor one level up from Dragon's rest (3)", ['Small Smooth & Silky Stone']),
        LocationData(50356490, "[DLC1] In side corridor one level up from Dragon's rest (4)", ['Twinkling Titanite']),
        LocationData(50356500, "[DLC1] In side corridor one level up from Dragon's rest (5)", ['Vine Balm']),
        LocationData(50356520, "[DLC1] In the room with many opened chests one level down from Sanctum Interior bonfire", ['Drakeblood Helm', 'Drakeblood Armor', 'Drakeblood Gauntlets', 'Drakeblood Leggings']),
        LocationData(50356540, "[DLC1] In Sinh's arena", ["Yorgh's Ring"]),
    ],
    "Shulva - Sanctum Key": [
        LocationData(862000, "[DLC1] Gank Squad drop", ['Twinkling Titanite', 'Petrified Dragon Bone', 'Titanite Slab']),
        LocationData(862001, "[DLC1] Gank Squad drop in NG+", ['Twinkling Titanite', 'Petrified Dragon Bone', 'Titanite Slab'], ngp=True),
        LocationData(50355190, "[DLC1] Metal chest behind the door that is opened with Eternal Sanctum key", ['Dried Root']),
        LocationData(50355200, "[DLC1] Metal chest behind the door that is opened with Eternal Sanctum key (2)", ['Dried Root']),
        LocationData(50355210, "[DLC1] Metal chest behind the door that is opened with Eternal Sanctum key (3)", ['Dried Root']),
        LocationData(50355220, "[DLC1] Metal chest behind the door that is opened with Eternal Sanctum key (4)", ['Lightning Clutch Ring']),
        LocationData(50355230, "[DLC1] Metal chest behind the door that is opened with Eternal Sanctum key (5)", ['Dried Root'], vanilla=True),
        LocationData(50355230, "[DLC1] Metal chest behind the door that is opened with Eternal Sanctum key (5)", ['Bonfire Ascetic'], sotfs=True),
        LocationData(50355240, "[DLC1] Metal chest in the topmost room (up ladder on the way to gank squad)", ['Sanctum Shield']),
        LocationData(50355180, "[DLC1] Metal chest after gank squad fight", ['Flower Skirt']),
        LocationData(50356390, "[DLC1] Hanging from ledge in the middle level of the elevator that connects to the Cave of the Dead", ['Torch']),
        LocationData(50355140, "[DLC1] Metal chest in the middle level of the elevator that connects to the Cave of the Dead", ['Dark Greatsword']),
        LocationData(50355150, "[DLC1] Metal chest in the Cave of the Dead", ['Petrified Something']),
        LocationData(50356610, "[DLC1] In the cave of the dead", ['Brightbug']),
        LocationData(50356620, "[DLC1] In the cave of the dead (2)", ['Bonfire Ascetic']),
        LocationData(50356240, "[DLC1] In the lower elevator room that connects to the Cave of the Dead", ['Rusted Coin']),
        LocationData(50356670, "[DLC1] In the lower level of the Cave of the Dead", ['Alluring Skull']),
        LocationData(50356210, "[DLC1] Corpse after Gank Squad fight", ['Blackweed Balm']),
    ],
    "Shulva": [
        LocationData(50355010, "[DLC1] Trapped wooden chest close to the first rotating door", ['Bonfire Ascetic'], vanilla=True),
        LocationData(50355010, "[DLC1] Trapped wooden chest close to the first rotating door", ['Dried Root'], sotfs=True),
        LocationData(50355020, "[DLC1] Wooden chest in the room after the spike trapped stairs by Puzzling Sword", ['Boltstone', 'Bleed Stone']),
        LocationData(50355030, "[DLC1] Wooden chest in the room after the spike trapped stairs by Puzzling Sword (2)", ['Twinkling Titanite', 'Petrified Dragon Bone']),
        LocationData(50355050, "[DLC1] Metal chest in the room with the first two ghosts", ['Catarina Helm']),
        LocationData(50355060, "[DLC1] Metal chest in the room after the spike trapped stairs", ['Puzzling Stone Sword']),
        LocationData(50355070, "[DLC1] Metal chest next to the entrance to the ghost armor room", ['Bloodbite Ring+1']),
        LocationData(50355090, "[DLC1] In a metal chest in the room up the ladder above the bug room", ["Flynn's Ring"]),
        LocationData(50355110, "[DLC1] Trapped wooden chest next to the entrance to the ghost armor room", ["Lloyd's Talisman"]),
        LocationData(50355120, "[DLC1] Metal chest in room opened by single button next to the spiky field", ['Dragon Stone']),
        LocationData(50355130, "[DLC1] Metal chest behind the rotating door next to the spiky field", ['Denial']),
        LocationData(50355250, "[DLC1] Metal chest in the room with the two ghosts", ['Destructive Greatarrow']),
        LocationData(50355260, "[DLC1] Metal chest in the room with the two ghosts (2)", ['Soul Vessel']),
        LocationData(50355270, "[DLC1] Metal chest in the room with the two ghosts (3)", ['Old Growth Balm']),
        LocationData(50355280, "[DLC1] Metal chest in the room with the two ghosts (4)", ['Titanite Slab']),
        LocationData(50355350, "[DLC1] Metal chest in room that opens from ceiling button close to the first rotating door", ['Twinkling Titanite', 'Petrified Dragon Bone']),
        LocationData(50356000, "[DLC1] On the top of the first building by Photoshop Jump", ['Poisonbite Ring+1']),
        LocationData(50356010, "[DLC1] In the first corrosive bug room", ['Goldenfruit Balm']),
        LocationData(50356020, "[DLC1] Beneath the switch in front of you directly after Photoshop Jump", ['Lightning Urn']),
        LocationData(50356030, "[DLC1] On ledge outside the first corrosive bug room", ['Old Growth Balm']),
        LocationData(50356040, "[DLC1] Stationary tower next to the Tower of Prayer bonfire", ['Sanctum Mace']),
        LocationData(50356050, "[DLC1] On outer ledge of the Tower of Prayer bonfire", ['Dried Root']),
        LocationData(50356060, "[DLC1] On the path next to the row of raising towers below Tower of Prayer", ["Lloyd's Talisman"]),
        LocationData(50356090, "[DLC1] In the spike trapped stairs by Puzzling Sword", ['Soul of a Hero']),
        LocationData(50356100, "[DLC1] In the spike trapped stairs by Puzzling Sword (2)", ['Human Effigy']),
        LocationData(50356130, "[DLC1] In the corner of a corridor just after the DLC1 opening door", ['Dragon Charm']),
        LocationData(50356140, "[DLC1] On ledge one stairs down from the Sanctum Walk bonfire", ['Old Growth Balm']),
        LocationData(50356150, "[DLC1] Just before the bridge activated by Dragon Stone", ['Human Effigy']),
        LocationData(50356160, "[DLC1] On ledge next to the two first raising towers", ['Lifegem']),
        LocationData(50356170, "[DLC1] Hanging from the ledge on the far side just below the first raising towers", ['Poison Stone']),
        LocationData(50356190, "[DLC1] On ledge in the second corrosive bug room", ['Elizabeth Mushroom']),
        LocationData(50356200, "[DLC1] In the base of the tower with the Tower of Prayer bonfire", ['Magic Bolt']),
        LocationData(50356220, "[DLC1] On the path next to the row of raising towers below Tower of Prayer (2)", ['Twinkling Titanite']),
        LocationData(50356250, "[DLC1] Next to the bridge which Sinh fireballs leading to the Dragon's Sanctum", ['Focus Souls']),
        LocationData(50356260, "[DLC1] In the room with the first rotating door", ['Human Effigy']),
        LocationData(50356270, "[DLC1] Where you drop back to the corridor after flynn's ring", ['Repair Powder']),
        LocationData(50356280, "[DLC1] In the bug room before Flynn's Ring", ['Old Growth Balm']),
        LocationData(50356290, "[DLC1] In the bug room before Flynn's Ring (2)", ['Lifegem']),
        LocationData(50356300, "[DLC1] In the bug room before Flynn's Ring (3)", ['Dung Pie']),
        LocationData(50356310, "[DLC1] On the stairs in the bug room before Flynn's Ring", ['Poison Throwing Knife']),
        LocationData(50356320, "[DLC1] In the spiky field near Dragon Stone", ['Torch']),
        LocationData(50356330, "[DLC1] In the spiky field near Dragon Stone (2)", ['Holy Water Urn']),
        LocationData(50356340, "[DLC1] In the spiky field near Dragon Stone (3)", ['Twinkling Titanite']),
        LocationData(50356350, "[DLC1] In the spiky field near Dragon Stone (4)", ['Human Effigy']),
        LocationData(50356360, "[DLC1] Corpse near the stairs before Jester Thomas invades", ['Old Growth Balm']),
        LocationData(50356370, "[DLC1] In the water area with Dinobutts", ['Soul of a Great Hero']),
        LocationData(50356380, "[DLC1] Next to the whipping tree", ['Notched Whip']),
        LocationData(50356400, "[DLC1] On top of a raising tower in the first area", ['Long Bow']),
        LocationData(50356410, "[DLC1] In the middle level of the raising tower that creates the path to the whipping tree", ['Torch']),
        LocationData(50356420, "[DLC1] Next to the hidden sanctum chamber bonfire", ['Sanctum Crossbow']),
        LocationData(50356430, "[DLC1] In small room that opens from button in the beginning of sanctum", ['Soul of a Great Hero', 'Dragon Charm']),
        LocationData(50356440, "[DLC1] In the water area with Dinobutts (2)", ['Petrified Dragon Bone']),
        LocationData(50356510, "[DLC1] Near the bottom of the elevator that takes you to elana's bridge", ['Drakeblood Greatsword']),
        LocationData(50356530, "[DLC1] Next to the whipping tree (2)", ['Promised Walk of Peace']),
        LocationData(50356560, "[DLC1] On top of a stationary tower in the first raising tower area", ['Dark Quartz Ring+3']),
        LocationData(50356570, "[DLC1] In the middle level of one of the raising towers next to Tower of Prayer", ['Darknight Stone']),
        LocationData(50356580, "[DLC1] In the middle level of one of the raising towers next to Tower of Prayer (2)", ['Thunder Quartz Ring+3']),
        LocationData(50356590, "[DLC1] Next to the first poison statue clump", ['Cracked Red Eye Orb']),
        LocationData(50356600, "[DLC1] Next to the first poison statue clump (2)", ['Throwing Knife']),
        LocationData(50356630, "[DLC1] In the ghost armor room", ['Eternal Sanctum Key']),
        LocationData(50356640, "[DLC1] In the ghost armor room (2)", ['Sanctum Knight Helm']),
        LocationData(50356650, "[DLC1] In the water area with Dinobutts (3)", ['Dried Root']),
        LocationData(50356660, "[DLC1] In the water area with Dinobutts (4)", ['Human Effigy']),
    ],
    "Memory of the Old Iron King": [
        LocationData(680000, "[DLC2] Sir Alonne drop", ['Soul of Sir Alonne']),
        LocationData(50366910, "[DLC2] In the middle of the first hall in Alonne memory", ["Skeptic's Spice"]),
        LocationData(50366920, "[DLC2] In the middle of the first hall in Alonne memory (2)", ['Smooth & Silky Stone']),
        LocationData(50366930, "[DLC2] In the middle of the first hall in Alonne memory (3)", ['Human Effigy']),
        LocationData(50366940, "[DLC2] On side alcove on the left side of the first hall in Alonne memory", ['Rusted Coin']),
        LocationData(50366950, "[DLC2] In the middle of the second hall in Alonne memory", ['Repair Powder']),
        LocationData(50366960, "[DLC2] On side alcove on the lower level of the second hall in Alonne memory", ['Twinblade']),
        LocationData(50366970, "[DLC2] In the middle of the second hall in Alonne memory (2)", ['Radiant Lifegem']),
    ],
    "Iron Passage": [
        LocationData(305010, "[DLC2] Blue Smelter Demon drop", ['Smelter Demon Soul']),
        LocationData(50366740, "[DLC2] One elevator up from the Iron Passage bonfire", ['Twilight Herb']),
        LocationData(50366980, "[DLC2] On an upper ledge of the third big room after passing through the second gate in Iron Passage", ['Old Growth Balm']),
        LocationData(50366990, "[DLC2] On an upper ledge of the third big room after passing through the second gate in Iron Passage (2)", ['Cracked Red Eye Orb']),
        LocationData(50367000, "[DLC2] On lower level of the third big room before Blue Smelter", ['Dried Root']),
        LocationData(50367010, "[DLC2] In a cell on the right just before the first gate in Iron Passage", ['Large Titanite Shard']),
        LocationData(50367020, "[DLC2] In a cell just before the second gate in Iron Passage", ['Torch']),
        LocationData(50367030, "[DLC2] In a cell just before the second gate in Iron Passage (2)", ["Simpleton's Spice"]),
        LocationData(50367040, "[DLC2] On an upper ledge of the first big room after passing through first gate in Iron Passage", ['Crimson Water']),
        LocationData(50367050, "[DLC2] On an upper ledge of the second big room after passing through first gate and dropping in Iron Passage", ['Wilted Dusk Herb']),
        LocationData(50367060, "[DLC2] Right after the Blue Smelter Demon", ['Pharros Mask']),
    ],
    "Brume Tower - scepter": [
        LocationData(675000, "[DLC2] Fume Knight drop", ['Soul of the Fume Knight', 'Soul of Nadalia, Bride of Ash']),
        LocationData(675010, "[DLC2] Fume Knight drop in NG+", ['Soul of the Fume Knight'], ngp=True),
        LocationData(50365020, "[DLC2] Metal chest next to ashen idol on the same level as the upper floor bonfire", ['Life Ring+3']),
        LocationData(50365080, "[DLC2] Metal chest in a side room above fume's elevator", ['Sorcery Clutch Ring']),
        LocationData(50365550, "[DLC2] Metal chest in a small room where you need to jump from an elevator next to the upper floor bonfire", ["Pilgrim's Spontoon"]),
        LocationData(50365580, "[DLC2] Metal chest in room with lizard; jump from the elevator going up from foyer", ['Brightbug']),
        LocationData(50365650, "[DLC2] Metal chest in the upper floor of curved corridor opposite the gate to Sir Alonne", ['Smelter Wedge']),
        LocationData(50365680, "[DLC2] Metal chest on the top floor of the multi-level room", ['Strength Ring']),
        LocationData(50365690, "[DLC2] Metal chest behind illusory wall from the elevator shaft going up from the Upper Floor bonfire", ['Hollow Skin']),
        LocationData(50366070, "[DLC2] On outside ledge accessed from a room with a rotating fiery bull statue next to the upper floor bonfire", ["Simpleton's Ring"]),
        LocationData(50366210, "[DLC2] Corpse on the cliff edge of ash area one level below foyer bonfire", ['Tower Key']),
        LocationData(50366240, "[DLC2] Behind a door next to Ashen idol on the same level as the Upper Floor bonfire (1)", ['Titanite Shard']),
        LocationData(50366250, "[DLC2] Behind a door next to Ashen idol on the same level as the Upper Floor bonfire (2)", ['Titanite Slab', 'Titanite Chunk']),
        LocationData(50366530, "[DLC2] In front of a rotating fiery bull statue in a room next to the Upper Floor bonfire", ['Old Radiant Lifegem']),
        LocationData(50366680, "[DLC2] In the lower floor of curved corridor opposite the gate to Sir Alonne", ['Lacerating Knife']),
        LocationData(50366700, "[DLC2] Behind explodable wall the curved corridor opposite the gate to sir alonne", ['Dispelling Ring+1']),
        LocationData(50366710, "[DLC2] On an ash covered area one level down from the Foyer bonfire near vanilla Tower Key", ['Human Effigy']),
        LocationData(50366720, "[DLC2] On an ash covered area one level down from the Foyer bonfire near vanilla Tower Key (2)", ["Skeptic's Spice"]),
        LocationData(50366760, "[DLC2] In the lower room of the multi-level room on the way to Fume Knight", ['Partizan']),
        LocationData(50366830, "[DLC2] On an ash covered area one level down from the Foyer bonfire near vanilla Tower Key (3)", ['Wilted Dusk Herb']),
        LocationData(50366850, "[DLC2] On an ash covered area one level down from the Foyer bonfire near vanilla Tower Key (4)", ['Titanite Chunk']),
        LocationData(50366860, "[DLC2] On an ash covered area one level down from the Foyer bonfire near vanilla Tower Key (5)", ['Twinkling Titanite']),
        LocationData(50366870, "[DLC2] On an ash covered area one level down from the Foyer bonfire near vanilla Tower Key (6)", ['Charcoal Pine Resin']),
        LocationData(50366880, "[DLC2] Behind a door next to Ashen Idol on the same level as the Upper Floor bonfire (3)", ['Broadsword']),
        LocationData(50366890, "[DLC2] Behind a door next to Ashen Idol on the same level as the Upper Floor bonfire (4)", ['Petrified Something']),
        LocationData(50367130, "[DLC2] Behind a door next to Ashen idol on the same level as the Upper Floor bonfire (5)", ['Flame Butterfly']),
        LocationData(50367140, "[DLC2] On railing on top of the tower next to the throne floor bonfire requiring elevator", ['Baneful Bird Ring']),
        LocationData(50368010, "[DLC2] Inside ash statue on the left side of the Fume Knight arena", ['Soul of a Brave Warrior']),
        LocationData(50368070, "[DLC2] In ash statue in area one level down from the Foyer bonfire near vanilla Tower Key", ['Large Soul of a Nameless Soldier']),
        LocationData(50368080, "[DLC2] Inside ash statue on the right side of the Fume Knight arena", ['Titanite Chunk']),
    ],
    "Brume Tower": [
        LocationData(50365000, "[DLC2] Metal chest just above the second Ashen Idol guarded by possessed armor", ['Bonfire Ascetic', 'Human Effigy']),
        LocationData(50365010, "[DLC2] Wooden chest outside just before the Upper Floor bonfire", ['Caestus']),
        LocationData(50365030, "[DLC2] Wooden chest in the left of the dark cursed area next to the Foyer bonfire", ['Old Radiant Lifegem']),
        LocationData(50365090, "[DLC2] Wooden chest in a side corridor next to the Upper Floor bonfire", ['Twinkling Titanite']),
        LocationData(50365500, "[DLC2] Metal chest behind Leap of Faith illusory rock after the second Ashen Idol", ['Old Radiant Lifegem', 'Wilted Dusk Herb']),
        LocationData(50365510, "[DLC2] Metal chest behind Leap of Faith illusory rock after the second Ashen Idol (2)", ['Soul Vessel']),
        LocationData(50365540, "[DLC2] Metal chest behind explodable wall in the corridor with fume sorcerers", ['Catarina Gauntlets', 'Catarina Leggings']),
        LocationData(50365560, "[DLC2] Metal chest up the ladder from the second Ashen Idol", ['Titanite Slab']),
        LocationData(50365570, "[DLC2] Metal chest in the dark cursed area next to the Foyer bonfire", ['Fire Snake']),
        LocationData(50365590, "[DLC2] Metal chest behind explodable wall in the corridor with fume sorcerers (2)", ['Petrified Dragon Bone']),
        LocationData(50365700, "[DLC2] Metal chest next to Maldron", ['Bonfire Ascetic']),
        LocationData(50366000, "[DLC2] In the corner of small room next to the second Ashen Idol", ['Dance of Fire']),
        LocationData(50366020, "[DLC2] On the topmost round platform of the central pillar", ['Old Growth Balm']),
        LocationData(50366030, "[DLC2] On a corpose underneath the first chain towards Throne Floor bonfire", ['Twilight Herb']),
        LocationData(50366170, "[DLC2] In the corner next to foyer bonfire", ['Spell Quartz Ring+3']),
        LocationData(50366260, "[DLC2] In Lever Room with the third Ashen Idol and multiple other enemies", ['Flame Quartz Ring+3']),
        LocationData(50366280, "[DLC2] In a circle of loot just after Lever Room guarded by possessed armor", ['Dried Root']),
        LocationData(50366300, "[DLC2] In a circle of loot just after Lever Room guarded by possessed armor (2)", ['Large Titanite Shard']),
        LocationData(50366310, "[DLC2] In a circle of loot just after Lever Room guarded by possessed armor (3)", ['Human Effigy']),
        LocationData(50366320, "[DLC2] In a circle of loot just after Lever Room guarded by possessed armor (4)", ['Twinkling Titanite']),
        LocationData(50366340, "[DLC2] In the end of the stairs by the first ashen idol at the top of the tower", ['Dexterity Ring']),
        LocationData(50366350, "[DLC2] In first (top) ash ledge beneath the chain; near a gate", ['Rouge Water']),
        LocationData(50366360, "[DLC2] On a round platform of the central pillar close to the top of the tower", ['Scythe']),
        LocationData(50366370, "[DLC2] In a corridor up the ladder from the second Ashen Idol", ['Prism Stone']),
        LocationData(50366380, "[DLC2] On a round platform of the central pillar close to the top of the tower (2)", ['Blackweed Balm']),
        LocationData(50366390, "[DLC2] On ledge next to the Leap of Faith illusory rock after the second Ashen Idol", ["Lloyd's Talisman"]),
        LocationData(50366480, "[DLC2] On ledge with two Fume Sorcerers above the outside ash field", ['Human Effigy']),
        LocationData(50366510, "[DLC2] In corner just before the chain bridge to the tower where Maldron invades", ['Raw Stone']),
        LocationData(50366520, "[DLC2] On altar in the dark cursed area next to the Foyer bonfire", ['Large Titanite Shard']),
        LocationData(50366570, "[DLC2] In the shortcut between the tower where Scorching Iron Scepter is and the Foyer bonfire", ['Dried Root']),
        LocationData(50366580, "[DLC2] In the room immediately after the Foyer bonfire", ['Magic Stone']),
        LocationData(50366800, "[DLC2] Metal chest in the bottom of the tower where Maldron invades", ['Majestic Greatsword']),
        LocationData(50366810, "[DLC2] On a round platform of the central pillar of the tower where Maldron invades", ['Alonne Greatbow']),
        LocationData(50366820, "[DLC2] In the stairs of the tower where Maldron invades", ['Silver Talisman']),
        LocationData(50366900, "[DLC2] In the first area with Cask Runners", ['Goldenfruit Balm']),
        LocationData(50367090, "[DLC2] In a small sideroom above the Quicksword Rachel invasion", ['Dried Root']),
        LocationData(50367100, "[DLC2] In the curved corridor with crawlers before Quicksword Rachel", ['Petrified Dragon Bone']),
        LocationData(50367110, "[DLC2] In a small sideroom next to the room where Quicksword Rachel invades", ['Twinkling Titanite']),
        LocationData(50367120, "[DLC2] In a small sideroom next to the room where Quicksword Rachel invades (2)", ['Recollection']),        
        LocationData(50368000, "[DLC2] Inside ash statue in the first (top) ash-covered ledge beneath the chain", ['Large Soul of a Proud Knight']),
        LocationData(50368020, "[DLC2] Inside ash statue on ledge after the second Ashen Idol", ['Old Mundane Stone']),
        LocationData(50368030, "[DLC2] Inside ash statue on bigger ash covered field before the Foyer bonfire", ['Soul of a Great Hero']),
        LocationData(50368040, "[DLC2] Inside ash statue on bigger ash covered field before the Foyer bonfire (2)", ['Large Soul of a Proud Knight']),
        LocationData(50368050, "[DLC2] Inside ash statue on bigger ash covered field before the Foyer bonfire (3)", ['Soul of a Hero']),
        LocationData(50368060, "[DLC2] Inside ash statue at the bottom of the tower where Maldron invades", ['Palestone']),
        LocationData(60014000, "[DLC2] Bottom floor of side tower after foyer", ['Scorching Iron Scepter']),
    ],
    "Frigid Outskirts": [
        LocationData(679010, "[DLC3] Lud and Zallen drop", ["Soul of Lud, the King's Pet", "Soul of Zallen, the King's Pet"]),
        LocationData(50376220, "[DLC3] In the first house in Frigid Outskirts", ['Dried Root']),
        LocationData(50376230, "[DLC3] Between the first and the second house in Frigid Outskirts", ['Lacerating Knife']),
        LocationData(50376450, "[DLC3] Outside the first house in Frigid Outskirts", ['Mirrah Hat']),
        LocationData(50376460, "[DLC3] Between the second and the third house in Frigid Outskirts", ['Twinkling Titanite']),
        LocationData(50376470, "[DLC3] In the third house in Frigid Outskirts", ['Human Effigy']),
        LocationData(50376710, "[DLC3] On ledge just before bridge to Lud and Zallen", ['Ring of the Living']),
        LocationData(50376730, "[DLC3] Under the coffin you ride in on in Frigid Outskirts", ['Wilted Dusk Herb']),
        LocationData(50376740, "[DLC3] In one of the coffins at the start of Frigid Outskirts", ['Blackweed Balm']),
    ],
    "Eleum Loyce": [
        LocationData(679000, "[DLC3] Aava drop", ["Soul of Aava, the King's Pet"]),
        LocationData(690000, "[DLC3] Ivory King drop", ['Soul of the Ivory King']),
        LocationData(50375500, "[DLC3] On altar", ['Eye of the Priestess']),
        LocationData(50375510, "[DLC3] Metal chest on roof of a house near the square with a fountain", ['Divine Blessing']),
        LocationData(50375520, "[DLC3] Metal chest on roof of a house near the square with a fountain (2)", ["Sorcerer's Twinblade"]),
        LocationData(50375530, "[DLC3] Metal chest behind the elevator full of coffins", ['Soul Flash']),
        LocationData(50375540, "[DLC3] Metal chest on roof of a house near the square with a fountain (3)", ['Soul Vessel']),
        LocationData(50375550, "[DLC3] Metal chest at the end of the main ballista bridge", ['Elizabeth Mushroom']),
        LocationData(50375560, "[DLC3] Metal chest on upper level of the Lower Garrison courtyard", ['Boltstone']),
        LocationData(50375580, "[DLC3] Metal chest in round room with mimic near Expulsion Chamber bonfire", ['Brightbug']),
        LocationData(50375590, "[DLC3] Metal chest in round room with mimic near Expulsion Chamber bonfire (2)", ['Bonfire Ascetic']),
        LocationData(50375600, "[DLC3] Metal chest in round room with mimic near Expulsion Chamber bonfire (3)", ['Old Radiant Lifegem']),
        LocationData(50375610, "[DLC3] Metal chest in round room with mimic near Expulsion Chamber bonfire (4)", ['Titanite Slab']),
        LocationData(50375640, "[DLC3] Metal chest on top floor of the tower with the invisible ladder", ['Splintering Lightning Spear']),
        LocationData(50375660, "[DLC3] Metal chest behind inner wall illusory wall and up stairs", ['Fire Clutch Ring']),
        LocationData(50375670, "[DLC3] Metal chest behind Inner Wall illusory near route back to bonfire", ['Twin-headed Greatbow']),
        LocationData(50375680, "[DLC3] Wooden chest on bottom floor of (wooden) multi-level area down the middle ballista bridge stairs", ['Wilted Dusk Herb']),
        LocationData(50375690, "[DLC3] Metal chest under ice in the first room of Inner Wall", ['Twinkling Titanite', 'Petrified Dragon Bone']),
        LocationData(50375700, "[DLC3] Metal chest surrounded by three Frozen Golems on upper floor of Inner Wall", ['Curved Nil Greatsword']),
        LocationData(50375710, "[DLC3] Metal chest after aava", ['Vessel Shield']),
        LocationData(50375730, "[DLC3] Metal chest in the corridor where Holy Knight Aurheim invades", ['Silver Talisman']),
        LocationData(50375740, "[DLC3] Metal chest behind Pharros contraption on the ballista bridge", ["Durgo's Hat"]),
        LocationData(50376000, "[DLC3] Near vanilla dark clutch on snowy ledge accessed by dropping from the roof before fountain square", ['Monastery Charm']),
        LocationData(50376010, "[DLC3] Behind ice just before the square with a fountain", ['Retainer Staff']),
        LocationData(50376050, "[DLC3] Under the stairs before the square with a fountain", ['Torch']),
        LocationData(50376060, "[DLC3] Under ice in the square with a fountain", ['Repair Powder']),
        LocationData(50376070, "[DLC3] In small room right after the square with a fountain", ['Small Blue Burr']),
        LocationData(50376080, "[DLC3] Under a tree accessed by dropping from the roof before fountain square", ['Dark Clutch Ring']),
        LocationData(50376090, "[DLC3] On ledge at the end of the path on left side before abandoned dwelling bonfire", ['Old Bell Helm']),
        LocationData(50376100, "[DLC3] On the courtyard after Abandoned Dwelling bonfire", ["Lloyd's Talisman"]),
        LocationData(50376110, "[DLC3] Next to a rampart golem by the lever to outer wall", ['Radiant Lifegem']),
        LocationData(50376120, "[DLC3] On the main ballista bridge", ['Goldenfruit Balm']),
        LocationData(50376130, "[DLC3] On the main ballista bridge (2)", ['Large Soul of a Brave Warrior']),
        LocationData(50376140, "[DLC3] On the main ballista bridge (3)", ['Prism Stone']),
        LocationData(50376150, "[DLC3] Next to a Rampart Golem near the tower with the invisible ladder", ['Green Blossom']),
        LocationData(50376160, "[DLC3] Just before the fog gate leading to the Inner Wall bonfire", ['Alluring Skull']),
        LocationData(50376170, "[DLC3] Just before the fog gate leading to the Inner Wall bonfire (2)", ["Skeptic's Spice"]),
        LocationData(50376180, "[DLC3] Before Hexer Nicolai invades behind a pillar near hedgehogs", ['Twilight Herb']),
        LocationData(50376190, "[DLC3] Where Hexer Nicolai invades guarded by a hedgehog", ['Old Growth Balm']),
        LocationData(50376200, "[DLC3] Hanging from ledge near Lower Garrison bonfire", ['Magic Stone']),
        LocationData(50376300, "[DLC3] Guarded by flexile sentry in the cave opened by lighting torches", ['Garrison Ward Key']),
        LocationData(50376310, "[DLC3] Guarded by three hedgehogs at the start of the Lower Garrison area", ['Monastery Charm']),
        LocationData(50376320, "[DLC3] Guarded by three hedgehogs just at the start of the Lower Garrison area", ['Goldenfruit Balm']),
        LocationData(50376340, "[DLC3] In a corner of the first room right from the Outer Wall bonfire", ['Radiant Lifegem']),
        LocationData(50376350, "[DLC3] In an area with ice dogs in the beginning", ['Winged Spear']),
        LocationData(50376360, "[DLC3] On middle floor balcony of the tower with the invisible ladder", ['Soul of a Great Hero']),
        LocationData(50376370, "[DLC3] In small room between stairs leading to the Eye of the Priestess", ['Crimson Water']),
        LocationData(50376380, "[DLC3] In a dead end corridor in Inner Wall near the Eleum Knight and by the illusory wall", ['Flame Butterfly']),
        LocationData(50376400, "[DLC3] On lower-middle floor balcony of the (wooden) multi-level area down the middle ballista bridge stairs", ['Ring of Resistance+1']),
        LocationData(50376410, "[DLC3] In a narrow corridor in the beginning of the area", ['Goldenfruit Balm']),
        LocationData(50376420, "[DLC3] On the broken where the snowball finishes", ["Azal's Staff"]),
        LocationData(50376430, "[DLC3] On the broken where the snowball finishes (2)", ['Radiant Lifegem']),
        LocationData(50376440, "[DLC3] On the broken where the snowball finishes (3)", ['Cracked Red Eye Orb']),
        LocationData(50376510, "[DLC3] On upper floor balcony of the (wooden) multi-level area down the middle ballista bridge stairs", ["Priest's Chime"]),
        LocationData(50376520, "[DLC3] Hanging from the ledge outside the tower of the Eleum Knight near snowball start", ['Vine Balm']),
        LocationData(50376530, "[DLC3] On a higher part of the courtyard after Abandoned Dwelling bonfire", ['Dark Dance']),
        LocationData(50376540, "[DLC3] On a snow ledge after a narrow gap between buildings after abandoned dwelling bonfire", ['Ring of the Embedded']),
        LocationData(50376560, "[DLC3] On upper floor behind the elevator full of coffins", ['Northwarder Hood', 'Northwarder Robe', 'Northwarder Manchettes', 'Northwarder Trousers']),
        LocationData(50376570, "[DLC3] Behind illusory wall in the left side of the cave opened by lighting torches", ['Bone Fist']),
        LocationData(50376580, "[DLC3] In the right side of the cave opened by lighting torches", ['Human Effigy']),
        LocationData(50376590, "[DLC3] On lower floor of the tower with the invisible ladder", ['Human Effigy']),
        LocationData(50376600, "[DLC3] In the large empty room in the middle floor of Inner Wall", ['Dried Root']),
        LocationData(50376610, "[DLC3] In Covetous Demons cave", ['Crimson Water']),
        LocationData(50376620, "[DLC3] In Covetous Demons cave (2)", ['Smooth & Silky Stone']),
        LocationData(50376630, "[DLC3] In Covetous Demons cave (3)", ['Dried Root']),
        LocationData(50376640, "[DLC3] On a corpse by hedgehogs and frozen golems on the way to snowball", ['Charcoal Pine Resin']),
        LocationData(50376650, "[DLC3] On a corpse by hedgehogs and frozen golems on the way to snowball (2)", ["Pharros' Lockstone"]),
        LocationData(50376660, "[DLC3] Where Hexer Nicolai invades", ['Amber Herb']),
        LocationData(50376670, "[DLC3] In Covetous Demons cave (4)", ['Large Club']),
        LocationData(50376680, "[DLC3] In Covetous Demons cave (5)", ['Dried Root']),
        LocationData(50376690, "[DLC3] In Covetous Demons cave (6)", ['Twinkling Titanite']),
        LocationData(50376750, "[DLC3] Behind ice just before the square with a fountain (2)", ['Dried Root']),
        LocationData(50376760, "[DLC3] Behind ice just before the square with a fountain (3)", ['Goldenfruit Balm']),
        LocationData(50376770, "[DLC3] Next to the shortcut door up a ladder in multi-level area down the middle ballista bridge stairs", ['Elizabeth Mushroom']),
    ],
    # "Dyna & Tillo": [
    #     LocationData(50000000, "[Crows] First set of 10 drops (all active) for the Small Smooth and Silky Stone table at crows", ['Soul of a Lost Undead', 'Lifegem', 'Amber Herb', 'Titanite Shard', 'Human Effigy', 'Cracked Blue Eye Orb', 'Cracked Red Eye Orb', 'Soul of a Proud Knight', 'Faintstone', 'Boltstone']),
    #     LocationData(50000001, "[Crows] Second set of 10 drops (all active) for the Small Smooth and Silky Stone table at crows", ['Firedrake Stone', 'Darknight Stone', 'Poison Stone', 'Bleed Stone', 'Raw Stone', 'Magic Stone', 'Old Mundane Stone', 'Titanite Chunk', 'Crimson Water', 'Divine Blessing']),
    #     LocationData(50000002, "[Crows] Third set of 10 drops (7 active) for the Small Smooth and Silky Stone table at crows", ['Twinkling Titanite', 'Petrified Dragon Bone', 'Soul of a Great Hero', 'Titanite Slab', 'Ring of Life Protection', "Demon's Great Hammer", 'Old Whip', "Channeler's Trident", 'Ring of Soul Protection', 'White Ring']),
    #     LocationData(50000003, "[Crows] Fourth set of 10 drops (none active) for the Small Smooth and Silky Stone table at crows", ['Rubbish', 'Lifegem', 'Fading Soul', 'Homeward Bone', 'Small Blue Burr', 'Small Yellow Burr', 'Small Orange Burr', 'Amber Herb', 'Human Effigy', 'Titanite Shard']),
    #     LocationData(50000100, "[Crows] First set of 10 drops (6 active) for the Smooth and Silky Stone table at crows", ['Soul of a Lost Undead', 'Lifegem', 'Amber Herb', 'Titanite Shard', 'Human Effigy', 'Cracked Blue Eye Orb', 'Cracked Red Eye Orb', 'Soul of a Proud Knight', 'Faintstone', 'Boltstone']),
    #     LocationData(50000101, "[Crows] Second set of 10 drops (all active) for the Smooth and Silky Stone table at crows", ['Firedrake Stone', 'Darknight Stone', 'Poison Stone', 'Bleed Stone', 'Raw Stone', 'Magic Stone', 'Old Mundane Stone', 'Titanite Chunk', 'Crimson Water', 'Divine Blessing']),
    #     LocationData(50000102, "[Crows] Third set of 10 drops (7 active) for the Smooth and Silky Stone table at crows", ['Twinkling Titanite', 'Petrified Dragon Bone', 'Soul of a Great Hero', 'Titanite Slab', 'Ring of Life Protection', "Demon's Great Hammer", 'Old Whip', "Channeler's Trident", 'Ring of Soul Protection', 'White Ring']),
    #     LocationData(50000103, "[Crows] Fourth set of 10 drops (none active) for the Smooth and Silky Stone table at crows", ['Rubbish', 'Lifegem', 'Fading Soul', 'Homeward Bone', 'Small Blue Burr', 'Small Yellow Burr', 'Small Orange Burr', 'Amber Herb', 'Human Effigy', 'Titanite Shard']),
    #     LocationData(50000200, "[Crows] First set of 10 drops (none active) for the Petrified Something table at crows", ['Soul of a Lost Undead', 'Lifegem', 'Amber Herb', 'Titanite Shard', 'Human Effigy', 'Cracked Blue Eye Orb', 'Cracked Red Eye Orb', 'Soul of a Proud Knight', 'Faintstone', 'Boltstone']),
    #     LocationData(50000201, "[Crows] Second set of 10 drops (none active) for the Petrified Something table at crows", ['Firedrake Stone', 'Darknight Stone', 'Poison Stone', 'Bleed Stone', 'Raw Stone', 'Magic Stone', 'Old Mundane Stone', 'Titanite Chunk', 'Crimson Water', 'Divine Blessing']),
    #     LocationData(50000202, "[Crows] Third set of 10 drops (7 active) for the Petrified Something table at crows", ['Twinkling Titanite', 'Petrified Dragon Bone', 'Soul of a Great Hero', 'Titanite Slab', 'Ring of Life Protection', "Demon's Great Hammer", 'Old Whip', "Channeler's Trident", 'Ring of Soul Protection', 'White Ring']),
    #     LocationData(50000203, "[Crows] Fourth set of 10 drops (none active) for the Petrified Something table at crows", ['Rubbish', 'Lifegem', 'Fading Soul', 'Homeward Bone', 'Small Blue Burr', 'Small Yellow Burr', 'Small Orange Burr', 'Amber Herb', 'Human Effigy', 'Titanite Shard']),
    #     LocationData(50000300, "[Crows] First set of 10 drops (none active) for the Prism Stone table at crows", ['Soul of a Lost Undead', 'Lifegem', 'Amber Herb', 'Titanite Shard', 'Human Effigy', 'Cracked Blue Eye Orb', 'Cracked Red Eye Orb', 'Soul of a Proud Knight', 'Faintstone', 'Boltstone']),
    #     LocationData(50000301, "[Crows] Second set of 10 drops (none active) for the Prism Stone table at crows", ['Firedrake Stone', 'Darknight Stone', 'Poison Stone', 'Bleed Stone', 'Raw Stone', 'Magic Stone', 'Old Mundane Stone', 'Titanite Chunk', 'Crimson Water', 'Divine Blessing']),
    #     LocationData(50000302, "[Crows] Third set of 10 drops (none active) for the Prism Stone table at crows", ['Twinkling Titanite', 'Petrified Dragon Bone', 'Soul of a Great Hero', 'Titanite Slab', 'Ring of Life Protection', "Demon's Great Hammer", 'Old Whip', "Channeler's Trident", 'Ring of Soul Protection', 'White Ring']),
    #     LocationData(50000303, "[Crows] Fourth set of 10 drops (all active) for the Prism Stone table at crows", ['Rubbish', 'Lifegem', 'Fading Soul', 'Homeward Bone', 'Small Blue Burr', 'Small Yellow Burr', 'Small Orange Burr', 'Amber Herb', 'Human Effigy', 'Titanite Shard']),
    # ],
    # "NPC": [
    #     LocationData(1307000, "[ShadedWoods] Gift from Head of Vengarl after exhausting his dialogue", ["Vengarl's Helm"]),
    #     LocationData(1307100, "Vengarl's Helm. Maybe some kind of fail-safe?", ["Vengarl's Helm"]),
    #     LocationData(1502010, "[ShadedWoods] Gift from manscorpion Tark after defeating Freja", ['Second Dragon Ring'], vanilla=True),
    #     LocationData(1502010, "[ShadedWoods] Gift from manscorpion Tark after defeating Freja", ['Black Scorpion Stinger', 'Second Dragon Ring'], sotfs=True),
    #     LocationData(1506000, "[Crypt] Gift from Agdayne after getting King's Ring", ['Darkdrift', "Agdayne's Black Robe", "Agdayne's Cuffs", "Agdayne's Kilt"]),
    #     LocationData(1700000, "[Majula] Gift from the emerald herald", ['Estus Flask']),
    #     LocationData(1701000, "[Aerie] Gift from the Emerald Herald", ['Aged Feather']),
    #     LocationData(1704000, "[Majula] Gift from Gilligan after buying the longest ladders", ['Melu Scimitar']),
    #     LocationData(1705000, "[Betwixt] Gift from the fire keepers after getting the King's Ring", ['Human Effigy']),
    #     LocationData(1721000, "[Drangleic] Gift from Chancellor Wellager after defeating the Giant Lord", ['Royal Dirk', 'Espada Ropera'], vanilla=True),
    #     LocationData(1721000, "[Drangleic] Gift from Chancellor Wellager after defeating the Giant Lord", ['Royal Dirk', 'Espada Ropera', 'Llewellyn Armor', 'Llewellyn Gloves', 'Llewellyn Shoes'], sotfs=True),
    #     LocationData(1723000, "[Betwixt] Gift from Milibeth after killing 3 hippos", ["Handmaid's Ladle"]),
    #     LocationData(1724000, "[MemoryVammar] Gift from Captain Drummond after defeating Giant lord", ['Drangleic Helm']),
    #     LocationData(1725000, "[Drangleic] Pilgrams of Dark", ['Dragon Chime']),
    #     LocationData(1726000, "[Misc] Gift from Gavlan after spending 16000 souls", ['Gyrm Greataxe']),
    #     LocationData(1741000, "[Majula] Gift from Saulden after 100 deaths", ['Ring of Steel Protection']),
    #     LocationData(1741010, "[Majula] Gift from Saulden after bringing 4 people to Majula", ['Soul Vessel']),
    #     LocationData(1742010, "[Tseldora] Gift from Creighton when helping in the fight against Pate", ["Creighton's Steel Mask", "Creighton's Chainmail", "Creighton's Chain Gloves", "Creighton's Chain Leggings"]),
    #     LocationData(1743000, "[MemoryOrro] Gift from Benhart if he has survived at least three summons", ['Bluemoon Greatsword', "Benhart's Parma", "Benhart's Knight Helm", "Benhart's Armor", "Benhart's Gauntlets", "Benhart's Boots"]),
    #     LocationData(1744000, "Tseldora den key (not from creighton though)?", ['Tseldora Den Key']),
    #     LocationData(1744010, "[EarthernPeak] Gift from Pate if player has summoned him to the Last Giant fight", ["Pate's Spear", "Pate's Shield", "Pate's Helm", "Pate's Armor", "Pate's Gloves", "Pate's Trousers", 'Ring of Thorns']),
    #     LocationData(1744020, "[FOFG] Gift from Pate after escaping the gate trap room", ['White Sign Soapstone']),
    #     LocationData(1751010, "[Majula] Gift from Cale after lighting all fires in the map", ["Cale's Helm", "Cale's Leather Armor", "Cale's Shoes"]),
    #     LocationData(1752000, "[AldiasKeep] Gift from Lucatiel if she has survived at least three summons", ['Mirrah Greatsword', "Lucatiel's Mask", "Lucatiel's Vest", "Lucatiel's Gloves", "Lucatiel's Trousers"]),
    #     LocationData(1752010, "[Misc] Gift from Lucatiel after speaking to her the second time", ['Human Effigy']),
    #     LocationData(1752020, "[Misc] Gift from Lucatiel after speaking to her the third time", ['Ring of Steel Protection+1']),
    #     LocationData(1753000, "5 rusted coins. Maybe related to talking to bell guard", ['Rusted Coin']),
    #     LocationData(1753020, "[Misc] Bell Keepers join", ["Bell Keeper's Seal"]),
    #     LocationData(1754000, "[Misc] Gift from Melentia after spending 10000 souls", ['Covetous Silver Serpent Ring+1']),
    #     LocationData(1756000, "Crest of the Rat", ['Crest of the Rat']),
    #     LocationData(1760000, "[Amana] Gift from Milfanito near Tower of Prayer bonfire after defeating Demon of song", ['Divine Blessing']),
    #     LocationData(1760010, "[Amana] Gift from Milfanito near Tower of Prayer bonfire", ['Smooth & Silky Stone']),
    #     LocationData(1760020, "[Amana] Gift from Milfanito near Tower of Prayer bonfire after releasing the Milfanito in Drangleic castle", ['Divine Blessing']),
    #     LocationData(1760100, "[Amana] Gift from Milfanito near Rise of the Dead bonfire after defeating Demon of song", ['Divine Blessing']),
    #     LocationData(1760110, "[Amana] Gift from Milfanito near Rise of the Dead bonfire", ['Smooth & Silky Stone'], vanilla=True),
    #     LocationData(1760110, "[Amana] Gift from Milfanito near Rise of the Dead bonfire", ['Petrified Something'], sotfs=True),
    #     LocationData(1760120, "[Amana] Gift from Milfanito near Rise of the Dead bonfire after releasing the Milfanito in Drangleic castle", ['Fire Seed']),
    #     LocationData(1760200, "[Drangleic] Gift when releasing Milfanito from highest tower up the Drangleic elevator", ['Ring of the Dead']),
    #     LocationData(1761000, "[Majula] Gift from Maughlin after spending 15000 souls and then speaking to him with no souls", ['Helm of Aurous', 'Armor of Aurous', 'Gauntlets of Aurous', 'Leggings of Aurous']),
    #     LocationData(1762000, "[Majula] Gift from Chloanne after spending 20000 souls", ['Twinkling Titanite']),
    #     LocationData(1763000, "[Majula] Gift from Rosabeth after unpetrifying her", ['Prism Stone']),
    #     LocationData(1764000, "[Majula] Gift from Lenigrast after spending 8000 souls on upgrades", ["Blacksmith's Hammer"]),
    #     LocationData(1764300, "[Bastille] Given to you after spending 12k on upgrades/infusions at Mcduff", ['Titanite Slab']),
    #     LocationData(1766000, "[Misc] Gift from Carhillion when over 30INT", ['Northern Ritual Band+1']),
    #     LocationData(1768000, "[Bastille] Gift from Straid after trading 4 boss souls", ['Black Hood', 'Black Robes', 'Black Gloves', 'Black Boots']),
    #     LocationData(1769000, "[Misc] Gift from Licia when over 30FTH", ["Idol's Chime", "Saint's Hood", "Saint's Dress", "Saint's Long Gloves", "Saint's Trousers"]),
    #     LocationData(1770000, "[Copse] Gift from Felkin when over 20INT and 20FTH", ['Sunset Staff', "Hexer's Hood", "Hexer's Robes", "Hexer's Gloves", "Hexer's Boots"]),
    #     LocationData(1771000, "[AldiasKeep] Gift from Navlaan after completing all assassination jobs", ['Chaos Hood', 'Chaos Robe', 'Chaos Gloves', 'Chaos Boots']),
    #     LocationData(1771010, "[AldiasKeep] Gift from Navlaan after bringing him Ladder Miniature", ['Dispelling Ring']),
    #     LocationData(1771020, "[AldiasKeep] Gift from Navlaan after bringing him Cale's Helm", ["Simpleton's Spice"]),
    #     LocationData(1771030, "[AldiasKeep] Gift from Navlaan after bringing him Sunset Staff", ['Forbidden Sun']),
    #     LocationData(1771040, "[AldiasKeep] Gift from Navlaan after bringing him Aged Feather", ['Unleash Magic']),
    #     LocationData(1772000, "[IronKeep] Gift from Magerold after spending 16000 souls", ['Covetous Gold Serpent Ring+1']),
    #     LocationData(1776000, "Human Effigy", ['Human Effigy']),
    #     LocationData(1783040, "[Chariot] Gift from Titchy Gren after Brotherhood of Blood Rank 3", ['Scythe of Nahr Alma', 'Nahr Alma Hood', 'Nahr Alma Robes']),
    #     LocationData(1784000, "[Tseldora] Gift from Cromwell when over 35FTH", ['Ring of Resistance']),
    #     LocationData(1785040, "[Heides] Gift from Blue Sentinel Targray after getting to 3rd rank in the Blue Sentinels", ["Targray's Helm", "Targray's Armor", "Targray's Manifers", "Targray's Leggings"]),
    #     LocationData(1788000, "[DLC3] Gift from Alsanna after bringing her 5 Loyce souls", ['Loyce Gauntlets', 'Loyce Leggings']),
    #     LocationData(1788010, "[DLC3] Gift from Alsanna after bringing her 15 Loyce souls", ['Loyce Armor']),
    #     LocationData(1788020, "[DLC3] Gift from Alsanna after bringing her 35 Loyce souls", ['Loyce Helm']),
    #     LocationData(1788030, "[DLC3] Gift from Alsanna after bringing her 50 Loyce souls; or killing her", ['Soul of Alsanna, Silent Oracle']),
    # ],
    # "Covenant": [
    #     LocationData(2001000, "[Majula] Way of Blue join", ['Blue Seal']),
    #     LocationData(2001011, "[Majula] Way of Blue 1st rank reward", ['Bloodbite Ring']),
    #     LocationData(2001012, "[Majula] Way of Blue 2nd rank reward", ['Hush']),
    #     LocationData(2001013, "[Majula] Way of Blue 3rd rank reward", ['Blue Tearstone Ring']),
    #     LocationData(2002000, "[Heides] Blue sentinels join", ["Guardian's Seal"]),
    #     LocationData(2002011, "[Heides] Blue sentinels 1st rank reward", ['Spirit Tree Shield']),
    #     LocationData(2002012, "[Heides] Blue sentinels 2nd rank reward", ['Wrath of the Gods']),
    #     LocationData(2002013, "[Heides] Blue sentinels 3rd rank reward", ['Bountiful Sunlight']),
    #     LocationData(2003000, "[Chariot] Brotherhood of Blood join", ['Crest of Blood']),
    #     LocationData(2003011, "[Chariot] Brotherhood of Blood 1st rank reward", ['Curved Twinblade']),
    #     LocationData(2003012, "[Chariot] Brotherhood of Blood 2nd rank reward", ['Crescent Sickle']),
    #     LocationData(2003013, "[Chariot] Brotherhood of Blood 3rd rank reward", ['Great Chaos Fireball']),
    #     LocationData(2004000, "Bell Keeper's Seal", ["Bell Keeper's Seal"]),
    #     LocationData(2004011, "[Misc] Bell Keepers 1st rank reward", ['Titanite Slab']),
    #     LocationData(2004012, "[Misc] Bell Keepers 2nd rank reward", ['Hidden Weapon']),
    #     LocationData(2004013, "[Misc] Bell Keepers 3rd rank reward", ['Bell Keeper Helmet', 'Bell Keeper Bellyband', 'Bell Keeper Cuffs', 'Bell Keeper Trousers']),
    #     LocationData(2005000, "[Misc] Rat King covenant join", ['Crest of the Rat']),
    #     LocationData(2005011, "[Misc] Rat King covenant 1st rank reward", ['Small Smooth & Silky Stone']),
    #     LocationData(2005012, "[Misc] Rat King covenant 2nd rank reward", ['Smooth & Silky Stone']),
    #     LocationData(2005013, "[Misc] Rat King covenant 3rd rank reward", ['Slumbering Dragoncrest Ring']),
    #     LocationData(2006000, "[Drangleic] Pilgrims of Dark join", ['Abyss Seal']),
    #     LocationData(2006011, "[Drangleic] Pilgrims of Dark", ['Resonant Soul']),
    #     LocationData(2006012, "[Drangleic] Pilgrims of Dark (2)", ['Great Resonant Soul']),
    #     LocationData(2006013, "[Drangleic] Reward for Rank 3 Darklurker covenant", ['Climax', 'Xanthous Crown', 'Xanthous Overcoat', 'Xanthous Gloves', 'Xanthous Waistcloth']),
    #     LocationData(2007000, "[HarvestValley] Heirs of the Sun join", ['Sun Seal']),
    #     LocationData(2007011, "[HarvestValley] Heirs of the Sun 1st rank reward", ['Sunlight Parma']),
    #     LocationData(2007012, "[HarvestValley] Heirs of the Sun 2nd rank reward", ['Sun Sword']),
    #     LocationData(2007013, "[HarvestValley] Heirs of the Sun 3rd rank reward", ['Sunlight Spear']),
    #     LocationData(2008000, "[IronKeep] Dragon Remnants join", ['Ancient Dragon Seal', 'Dragon Eye']),
    #     LocationData(2008011, "[IronKeep] Dragon Remnants 1st rank reward", ['Dragon Head Stone']),
    #     LocationData(2008012, "[IronKeep] Dragon Remnants 2nd rank reward", ['Dragon Torso Stone']),
    #     LocationData(2008013, "[IronKeep] Dragon Remnants 3rd rank reward", ['Black Dragon Greatsword']),
    #     LocationData(2009000, "[Majula] Company of Champions join", ["Champion's Tablet"]),
    #     LocationData(2009011, "[Majula] Company of Champions 1st rank reward", ['Great Magic Weapon']),
    #     LocationData(2009012, "[Majula] Company of Champions 2nd rank reward", ['First Dragon Ring']),
    #     LocationData(2009013, "[Majula] Company of Champions 3rd rank reward", ["Vanquisher's Seal"]),
    # ],
    # "Gesture": [
    #     LocationData(3001000, "Gesture: Point. Gestures seemingly not tied to expected events though", ['"Point" Gesture']),
    #     LocationData(3002000, "Gesture: I won't bite. Gestures seemingly not tied to expected events though", ['"I won\'t bite" Gesture']),
    #     LocationData(3004000, "Gesture: Bow. Gestures seemingly not tied to expected events though", ['"Bow" Gesture']),
    #     LocationData(3005000, "Gesture: Welcome. Gestures seemingly not tied to expected events though", ['"Welcome" Gesture']),
    #     LocationData(3006000, "Gesture: Duel Bow. Gestures seemingly not tied to expected events though", ['"Duel bow" Gesture']),
    #     LocationData(3007000, "Gesture: Wave. Gestures seemingly not tied to expected events though", ['"Wave" Gesture']),
    #     LocationData(3008000, "Gesture: Pumped Up. Gestures seemingly not tied to expected events though", ['"Pumped up" Gesture']),
    #     LocationData(3009000, "Gesture: Joy. Gestures seemingly not tied to expected events though", ['"Joy" Gesture']),
    #     LocationData(3010000, "Gesture: Warcry. Gestures seemingly not tied to expected events though", ['"Warcry" Gesture']),
    #     LocationData(3011000, "Gesture: Warmup. Gestures seemingly not tied to expected events though", ['"Warmup" Gesture']),
    #     LocationData(3012000, "Gesture: Hurrah!. Gestures seemingly not tied to expected events though", ['"Hurrah!" Gesture']),
    #     LocationData(3013000, "Gesture: Righty-ho!. Gestures seemingly not tied to expected events though", ['"Righty-ho!" Gesture']),
    #     LocationData(3014000, "Gesture: No Way. Gestures seemingly not tied to expected events though", ['"No way" Gesture']),
    #     LocationData(3015000, "Gesture: This one's me. Gestures seemingly not tied to expected events though", ['"This one\'s me" Gesture']),
    #     LocationData(3016000, "Gesture: Have mercy. Gestures seemingly not tied to expected events though", ['"Have mercy!" Gesture']),
    #     LocationData(3017000, "Gesture: Prostration. Gestures seemingly not tied to expected events though", ['"Prostration" Gesture']),
    #     LocationData(3018000, "Gesture: Decapitate. Gestures seemingly not tied to expected events though", ['"Decapitate" Gesture']),
    #     LocationData(3019000, "Gesture: Fist pump. Gestures seemingly not tied to expected events though", ['"Fist pump" Gesture']),
    #     LocationData(3020000, "Gesture: Mock. Gestures seemingly not tied to expected events though", ['"Mock" Gesture']),
    #     LocationData(3021000, "Gesture: Praise the Sun. Gestures seemingly not tied to expected events though", ['"Praise the Sun" Gesture']),
    # ],
    # "Event": [
    #     LocationData(60002000, "[FOFG] On the tree near solider's rest bonfire", ['Seed of a Tree of Giants']),
    #     LocationData(60003000, "[DragonShrine] Near the invader in dragon shrine", ['Petrified Egg']),
    #     LocationData(60004000, "[MemoryJeigh] Giant corpse at end of all memories", ['Soul of a Giant']),
    #     LocationData(60005000, "[Tseldora] From the Ancient dragon corpse in the memory after Freja", ['Ancient Dragon Soul']),
    #     LocationData(60006000, "[Misc] Reward for killing Licia using the Crushed Eye Orb", ['Rotunda Lockstone', 'Soothing Sunlight', "Idol's Chime", "Saint's Hood", "Saint's Dress", "Saint's Long Gloves", "Saint's Trousers"]),
    #     LocationData(60007000, "Reward for killing 1000 invading red phantoms", ['Lingering Dragoncrest Ring+2']),
    #     LocationData(60007100, "Reward for invading and killing 1000 other worlds", ['Ring of Thorns+2']),
    #     LocationData(60007200, "Reward for completing the game without dying", ['Illusory Ring of a Conqueror']),
    #     LocationData(60007300, "Reward for completing the game without taking a bonfire", ['Illusory Ring of the Exalted']),
    #     LocationData(60008000, "[FOFG] Pursuer (on the platform) drop", ['Soul of the Pursuer', 'Ring of Blades']),
    #     LocationData(60008100, "[Betwixt] Pursuer drop", ['Twinkling Titanite'], sotfs=True),
    #     LocationData(60008110, "[Betwixt] Pursuer drop in NG+", ['Twinkling Titanite'], ngp=True, sotfs=True),
    #     LocationData(60010000, "Reward for killing Last Giant when crammed (Soldier key only)", ['Soldier Key']),
    #     LocationData(60011000, "Reward for killing Ancient Dragon (Ashen Mist only) when crammed", ['Ashen Mist Heart']),
    #     LocationData(60012000, "[DLC2] Ashen Idol (the second ashen idol from the top of the tower)", ['Soul of Nadalia, Bride of Ash']),
    #     LocationData(60012010, "[DLC2] Ashen Idol on the left side of the Fume Knight arena", ['Soul of Nadalia, Bride of Ash']),
    #     LocationData(60012020, "[DLC2] Ashen Idol on the left side of the Fume Knight arena (2)", ['Soul of Nadalia, Bride of Ash']),
    #     LocationData(60012030, "[DLC2] Ashen Idol on the right side of the Fume Knight arena", ['Soul of Nadalia, Bride of Ash']),
    #     LocationData(60012040, "[DLC2] Ashen Idol on the right side of the Fume Knight arena (2)", ['Soul of Nadalia, Bride of Ash']),
    #     LocationData(60012050, "[DLC2] Ashen Idol in the Lever Rooom with multiple other enemies", ['Soul of Nadalia, Bride of Ash']),
    #     LocationData(60012060, "[DLC2] Ashen Idol down the stairs from the Smelter Throne bonfire", ['Soul of Nadalia, Bride of Ash']),
    #     LocationData(60012070, "[DLC2] Ashen Idol in the dark curse area next to Foyer bonfire", ['Soul of Nadalia, Bride of Ash']),
    #     LocationData(60012080, "[DLC2] Ashen idol in the tower where Maldron invades", ['Soul of Nadalia, Bride of Ash']),
    #     LocationData(60012090, "[DLC2] Ashen Idol on ledge behind a door on the same level as the Upper floor bonfire", ['Soul of Nadalia, Bride of Ash']),
    #     LocationData(60012100, "[DLC2] Ashen Idol in the top of the tower next to the Throne Floor bonfire", ['Soul of Nadalia, Bride of Ash']),
    #     LocationData(60013000, "[DLC2] On throne after Sir Alonne", ['Smelter Wedge']),
    #     LocationData(60015000, "[Misc] Full Soul of Nadalia", ['Soul of Nadalia, Bride of Ash']),
    #     LocationData(60016000, "[DLC2] In ash pile after defeating fume knight", ['Crown of the Old Iron King']),
    #     LocationData(60019000, "[DLC2] Very first ash pile before the first chain bridge", ['Smelter Wedge']),
    #     LocationData(60020000, "[DLC1] In sinh's arena after defeating him", ['Crown of the Sunken King']),
    #     LocationData(60030000, "Soul of Aava + Garrison ward key?? Cut content??", ["Soul of Aava, the King's Pet", 'Garrison Ward Key']),
    #     LocationData(60031000, "[DLC3] In the ivory king arena after defeating him", ['Crown of the Ivory King']),
    #     LocationData(60040000, "Last Giant Soul drop by itself", ['Soul of the Last Giant']),
    #     LocationData(60041000, "Ancient Dragon Soul drop by itself", ['Ancient Dragon Soul']),
    #     LocationData(60042000, "Reward for killing Gulch Giants when crammed (Forgotten Key only)", ['Forgotten Key']),
    #     LocationData(60043000, "Reward for killing Giant Lord when crammed (Kinship only)", ["Giant's Kinship"]),
    #     LocationData(60044000, "Giant Lord Soul drop by itself", ['Giant Lord Soul']),
    #     LocationData(60044001, "Giant Lord Soul and Ring of Giants +2. Dropped only when crammed after defeating Giant Lord in NG+", ['Giant Lord Soul', 'Ring of Giants+2'], ngp=True),
    #     LocationData(60045000, "Reward for killing Licia using the Crushed Eye Orb whilst crammed (Rotunda only)", ['Rotunda Lockstone']),
    #     LocationData(60046000, "Key to the Embedded by itself?", ['Key to the Embedded']),
    #     LocationData(60046001, "Demon of Song Soul by itself? Possibly related to when Key to Embedded was a key and cramming", ['Demon of Song Soul']),
    # ],
    # "Shop": [
    #     LocationData(75400004, "[Merchant Hag Melentia - Grave Warden Agdayne] Darkdrift", ["Darkdrift"], shop=True),
    #     LocationData(75400005, "[Merchant Hag Melentia - Lucatiel of Mirrah] Mirrah Greatsword", ["Mirrah Greatsword"], shop=True),
    #     LocationData(75400006, "[Merchant Hag Melentia - Titchy Gren] Scythe of Nahr Alma", ["Scythe of Nahr Alma"], shop=True),
    #     LocationData(75400007, "[Merchant Hag Melentia - Manscorpion Tark] Black Scorpion Stinger", ["Black Scorpion Stinger"], sotfs=True, shop=True),
    #     LocationData(75400100, "[Merchant Hag Melentia - Benhart of Jugo] Benhart's Parma", ["Benhart's Parma"], shop=True),
    #     LocationData(75400101, "[Merchant Hag Melentia - Mild Mannered Pate] Pate's Shield", ["Pate's Shield"], shop=True),
    #     LocationData(75400204, "[Merchant Hag Melentia - Grave Warden Agdayne] Agdayne's Black Robe", ["Agdayne's Black Robe"], shop=True),
    #     LocationData(75400205, "[Merchant Hag Melentia - Grave Warden Agdayne] Agdayne's Cuffs", ["Agdayne's Cuffs"], shop=True),
    #     LocationData(75400206, "[Merchant Hag Melentia - Creighton the Wanderer] Creighton's Chainmail", ["Creighton's Chainmail"], shop=True),
    #     LocationData(75400207, "[Merchant Hag Melentia - Creighton the Wanderer] Creighton's Chain Gloves", ["Creighton's Chain Gloves"], shop=True),
    #     LocationData(75400208, "[Merchant Hag Melentia - Creighton the Wanderer] Creighton's Chain Leggings", ["Creighton's Chain Leggings"], shop=True),
    #     LocationData(75400209, "[Merchant Hag Melentia - Benhart of Jugo] Benhart's Knight Helm", ["Benhart's Knight Helm"], shop=True),
    #     LocationData(75400210, "[Merchant Hag Melentia - Benhart of Jugo] Benhart's Armor", ["Benhart's Armor"], shop=True),
    #     LocationData(75400211, "[Merchant Hag Melentia - Benhart of Jugo] Benhart's Gauntlets", ["Benhart's Gauntlets"], shop=True),
    #     LocationData(75400212, "[Merchant Hag Melentia - Benhart of Jugo] Benhart's Boots", ["Benhart's Boots"], shop=True),
    #     LocationData(75400213, "[Merchant Hag Melentia - Mild Mannered Pate] Pate's Helm", ["Pate's Helm"], shop=True),
    #     LocationData(75400214, "[Merchant Hag Melentia - Mild Mannered Pate] Pate's Armor", ["Pate's Armor"], shop=True),
    #     LocationData(75400215, "[Merchant Hag Melentia - Mild Mannered Pate] Pate's Gloves", ["Pate's Gloves"], shop=True),
    #     LocationData(75400216, "[Merchant Hag Melentia - Mild Mannered Pate] Pate's Trousers", ["Pate's Trousers"], shop=True),
    #     LocationData(75400217, "[Merchant Hag Melentia - Cale the Cartographer] Cale's Leather Armor", ["Cale's Leather Armor"], shop=True),
    #     LocationData(75400218, "[Merchant Hag Melentia - Cale the Cartographer] Cale's Shoes", ["Cale's Shoes"], shop=True),
    #     LocationData(75400219, "[Merchant Hag Melentia - Lucatiel of Mirrah] Lucatiel's Vest", ["Lucatiel's Vest"], shop=True),
    #     LocationData(75400220, "[Merchant Hag Melentia - Lucatiel of Mirrah] Lucatiel's Gloves", ["Lucatiel's Gloves"], shop=True),
    #     LocationData(75400221, "[Merchant Hag Melentia - Lucatiel of Mirrah] Lucatiel's Trousers", ["Lucatiel's Trousers"], shop=True),
    #     LocationData(75400222, "[Merchant Hag Melentia - Straid of Olaphis] Black Robes", ["Black Robes"], shop=True),
    #     LocationData(75400223, "[Merchant Hag Melentia - Straid of Olaphis] Black Gloves", ["Black Gloves"], shop=True),
    #     LocationData(75400224, "[Merchant Hag Melentia - Straid of Olaphis] Black Boots", ["Black Boots"], shop=True),
    #     LocationData(75400225, "[Merchant Hag Melentia - Licia of Lindeldt] Saint's Hood", ["Saint's Hood"], shop=True),
    #     LocationData(75400226, "[Merchant Hag Melentia - Licia of Lindeldt] Saint's Dress", ["Saint's Dress"], shop=True),
    #     LocationData(75400227, "[Merchant Hag Melentia - Licia of Lindeldt] Saint's Long Gloves", ["Saint's Long Gloves"], shop=True),
    #     LocationData(75400228, "[Merchant Hag Melentia - Licia of Lindeldt] Saint's Trousers", ["Saint's Trousers"], shop=True),
    #     LocationData(75400229, "[Merchant Hag Melentia - Felkin the Outcast] Hexer's Hood", ["Hexer's Hood"], shop=True),
    #     LocationData(75400230, "[Merchant Hag Melentia - Felkin the Outcast] Hexer's Robes", ["Hexer's Robes"], shop=True),
    #     LocationData(75400231, "[Merchant Hag Melentia - Felkin the Outcast] Hexer's Gloves", ["Hexer's Gloves"], shop=True),
    #     LocationData(75400232, "[Merchant Hag Melentia - Felkin the Outcast] Hexer's Boots", ["Hexer's Boots"], shop=True),
    #     LocationData(75400233, "[Merchant Hag Melentia - Royal Sorcerer Navlaan] Chaos Robe", ["Chaos Robe"], shop=True),
    #     LocationData(75400234, "[Merchant Hag Melentia - Royal Sorcerer Navlaan] Chaos Gloves", ["Chaos Gloves"], shop=True),
    #     LocationData(75400235, "[Merchant Hag Melentia - Royal Sorcerer Navlaan] Chaos Boots", ["Chaos Boots"], shop=True),
    #     LocationData(75400236, "[Merchant Hag Melentia - Titchy Gren] Nahr Alma Robes", ["Nahr Alma Robes"], shop=True),
    #     LocationData(75400237, "[Merchant Hag Melentia - Blue Sentinel Targray] Targray's Helm", ["Targray's Helm"], shop=True),
    #     LocationData(75400238, "[Merchant Hag Melentia - Blue Sentinel Targray] Targray's Armor", ["Targray's Armor"], shop=True),
    #     LocationData(75400239, "[Merchant Hag Melentia - Blue Sentinel Targray] Targray's Manifers", ["Targray's Manifers"], shop=True),
    #     LocationData(75400240, "[Merchant Hag Melentia - Blue Sentinel Targray] Targray's Leggings", ["Targray's Leggings"], shop=True),
    #     LocationData(75400610, "[Merchant Hag Melentia - 1 Major Boss] Brightbug", ["Brightbug"], shop=True),
    #     LocationData(75400611, "[Merchant Hag Melentia - 2 Major Bosses] Brightbug", ["Brightbug"], shop=True),
    #     LocationData(75400612, "[Merchant Hag Melentia - 3 Major Bosses] Brightbug", ["Brightbug"], shop=True),
    #     LocationData(75400613, "[Merchant Hag Melentia - 4 Major Bosses] Brightbug", ["Brightbug"], shop=True),
    #     LocationData(75400614, "[Merchant Hag Melentia - 5 Major Bosses] Brightbug", ["Brightbug"], shop=True),
    #     LocationData(75600600, "[The Rat King] Common Fruit", ["Common Fruit"], shop=True),
    #     LocationData(75600601, "[The Rat King] Red Leech Troches", ["Red Leech Troches"], shop=True),
    #     LocationData(75600602, "[The Rat King] Triclops Snake Troches", ["Triclops Snake Troches"], shop=True),
    #     LocationData(75600603, "[The Rat King] Dung Pie", ["Dung Pie"], shop=True),
    #     LocationData(75600604, "[The Rat King] Corrosive Urn", ["Corrosive Urn"], shop=True),
    #     LocationData(76100211, "[Maughlin the Armourer - 1000 Souls] Royal Soldier Helm", ["Royal Soldier Helm"], shop=True),
    #     LocationData(76100212, "[Maughlin the Armourer - 1000 Souls] Royal Soldier Armor", ["Royal Soldier Armor"], shop=True),
    #     LocationData(76100213, "[Maughlin the Armourer - 1000 Souls] Royal Soldier Gauntlet", ["Royal Soldier Gauntlets"], shop=True),
    #     LocationData(76100214, "[Maughlin the Armourer - 1000 Souls] Royal Soldier Leggings", ["Royal Soldier Leggings"], shop=True),
    #     LocationData(76100215, "[Maughlin the Armourer - 1000 Souls] Elite Knight Helm", ["Elite Knight Helm"], shop=True),
    #     LocationData(76100216, "[Maughlin the Armourer - 1000 Souls] Elite Knight Armor", ["Elite Knight Armor"], shop=True),
    #     LocationData(76100217, "[Maughlin the Armourer - 1000 Souls] Elite Knight Gloves", ["Elite Knight Gloves"], shop=True),
    #     LocationData(76100218, "[Maughlin the Armourer - 1000 Souls] Elite Knight Leggings", ["Elite Knight Leggings"], shop=True),
    #     LocationData(76100219, "[Maughlin the Armourer - 1000 Souls] Royal Soldier Helm", ["Royal Soldier Helm"], shop=True),
    #     LocationData(76100220, "[Maughlin the Armourer - 1000 Souls] Royal Soldier Armor", ["Royal Soldier Armor"], shop=True),
    #     LocationData(76100221, "[Maughlin the Armourer - 1000 Souls] Royal Soldier Gauntlets", ["Royal Soldier Gauntlets"], shop=True),
    #     LocationData(76100222, "[Maughlin the Armourer - 1000 Souls] Royal Soldier Leggings", ["Royal Soldier Leggings"], shop=True),
    #     LocationData(76100223, "[Maughlin the Armourer - 1000 Souls] Elite Knight Helm", ["Elite Knight Helm"], shop=True),
    #     LocationData(76100224, "[Maughlin the Armourer - 1000 Souls] Elite Knight Armor", ["Elite Knight Armor"], shop=True),
    #     LocationData(76100225, "[Maughlin the Armourer - 1000 Souls] Elite Knight Gloves", ["Elite Knight Gloves"], shop=True),
    #     LocationData(76100226, "[Maughlin the Armourer - 1000 Souls] Elite Knight Leggings", ["Elite Knight Leggings"], shop=True),
    #     LocationData(76100227, "[Maughlin the Armourer - 15000 Souls] Alva Helm", ["Alva Helm"], shop=True),
    #     LocationData(76100228, "[Maughlin the Armourer - 15000 Souls] Alva Armor", ["Alva Armor"], shop=True),
    #     LocationData(76100229, "[Maughlin the Armourer - 15000 Souls] Alva Gauntlets", ["Alva Gauntlets"], shop=True),
    #     LocationData(76100230, "[Maughlin the Armourer - 15000 Souls] Alva Leggings", ["Alva Leggings"], shop=True),
    #     LocationData(76100251, "[Maughlin the Armourer - Thorne Defenders] Throne Defender Helm", ["Throne Defender Helm"], shop=True),
    #     LocationData(76100252, "[Maughlin the Armourer - Thorne Defenders] Throne Defender Armor", ["Throne Defender Armor"], shop=True),
    #     LocationData(76100253, "[Maughlin the Armourer - Thorne Defenders] Throne Defender Gauntlets", ["Throne Defender Gauntlets"], shop=True),
    #     LocationData(76100254, "[Maughlin the Armourer - Thorne Defenders] Throne Defender Leggings", ["Throne Defender Leggings"], shop=True),
    #     LocationData(76100255, "[Maughlin the Armourer - Thorne Defenders] Throne Watcher Helm", ["Throne Watcher Helm"], shop=True),
    #     LocationData(76100256, "[Maughlin the Armourer - Thorne Defenders] Throne Watcher Armor", ["Throne Watcher Armor"], shop=True),
    #     LocationData(76100257, "[Maughlin the Armourer - Thorne Defenders] Throne Watcher Gauntlets", ["Throne Watcher Gauntlets"], shop=True),
    #     LocationData(76100258, "[Maughlin the Armourer - Thorne Defenders] Throne Watcher Leggings", ["Throne Watcher Leggings"], shop=True),
    #     LocationData(76100259, "[Maughlin the Armourer - 15000 Souls, NG+3] Moon Butterfly Hat", ["Moon Butterfly Hat"], shop=True),
    #     LocationData(76100260, "[Maughlin the Armourer - 15000 Souls, NG+2] Moon Butterfly Wings", ["Moon Butterfly Wings"], shop=True),
    #     LocationData(76100261, "[Maughlin the Armourer - 15000 Souls, NG+2] Moon Butterfly Cuffs", ["Moon Butterfly Cuffs"], shop=True),
    #     LocationData(76100262, "[Maughlin the Armourer - 15000 Souls, NG+2] Moon Butterfly Skirt", ["Moon Butterfly Skirt"], shop=True),
    #     LocationData(76100263, "[Maughlin the Armourer - Burnt Ivory King, 50 Loyce Souls] Ivory King Helm", ["Ivory King Helm"], shop=True),
    #     LocationData(76100264, "[Maughlin the Armourer - Burnt Ivory King, 50 Loyce Souls] Ivory King Armor", ["Ivory King Armor"], shop=True),
    #     LocationData(76100265, "[Maughlin the Armourer - Burnt Ivory King, 50 Loyce Souls] Ivory King Gauntlets", ["Ivory King Gauntlets"], shop=True),
    #     LocationData(76100266, "[Maughlin the Armourer - Burnt Ivory King, 50 Loyce Souls] Ivory King Leggings", ["Ivory King Leggings"], shop=True),
    #     LocationData(76600000, "[Carhillion of the Fold] Sorcerer's Staff", ["Sorcerer's Staff"], shop=True),
    #     LocationData(76600300, "[Carhillion of the Fold] Soul Arrow", ["Soul Arrow"], shop=True),
    #     LocationData(76600301, "[Carhillion of the Fold] Great Soul Arrow", ["Great Soul Arrow"], shop=True),
    #     LocationData(76600302, "[Carhillion of the Fold] Heavy Soul Arrow", ["Heavy Soul Arrow"], shop=True),
    #     LocationData(76600303, "[Carhillion of the Fold] Great Heavy Soul Arrow", ["Great Heavy Soul Arrow"], shop=True),
    #     LocationData(76600304, "[Carhillion of the Fold] Shockwave", ["Shockwave"], shop=True),
    #     LocationData(76600305, "[Carhillion of the Fold] Soul Spear Barrage", ["Soul Spear Barrage"], shop=True),
    #     LocationData(76600306, "[Carhillion of the Fold] Magic Weapon", ["Magic Weapon"], shop=True),
    #     LocationData(76600307, "[Carhillion of the Fold] Yearn", ["Yearn"], shop=True),
    #     LocationData(76600400, "[Carhillion of the Fold] Spell Quartz Ring", ["Spell Quartz Ring"], shop=True),
    #     LocationData(76600401, "[Carhillion of the Fold] Clear Bluestone Ring", ["Clear Bluestone Ring"], shop=True),
    #     LocationData(76600600, "[Carhillion of the Fold] Amber Herb", ["Amber Herb"], shop=True),
    #     LocationData(76600601, "[Carhillion of the Fold] Twilight Herb", ["Twilight Herb"], shop=True),
    #     LocationData(76600602, "[Carhillion of the Fold] Simpleton's Spice", ["Simpleton's Spice"], shop=True),
    #     LocationData(76600308, "[Carhillion of the Fold - Shrine of Winter] Soul Arrow", ["Soul Arrow"], shop=True),
    #     LocationData(76600309, "[Carhillion of the Fold - Shrine of Winter] Great Soul Arrow", ["Great Soul Arrow"], shop=True),
    #     LocationData(76600310, "[Carhillion of the Fold - Shrine of Winter] Heavy Soul Arrow", ["Heavy Soul Arrow"], shop=True),
    #     LocationData(76600311, "[Carhillion of the Fold - Shrine of Winter] Great Heavy Soul Arrow", ["Great Heavy Soul Arrow"], shop=True),
    #     LocationData(76600312, "[Carhillion of the Fold - Shrine of Winter] Shockwave", ["Shockwave"], shop=True),
    #     LocationData(76600313, "[Carhillion of the Fold - Shrine of Winter] Soul Spear Barrage", ["Soul Spear Barrage"], shop=True),
    #     LocationData(76600314, "[Carhillion of the Fold - Shrine of Winter] Magic Weapon", ["Magic Weapon"], shop=True),
    #     LocationData(76600315, "[Carhillion of the Fold - Shrine of Winter] Yearn", ["Yearn"], shop=True),
    #     LocationData(76800000, "[Straid of Olaphis - 5 Forlorn] Greatsword of the Forlorn", ["Greatsword of the Forlorn"], sotfs=True, shop=True),
    #     LocationData(76800001, "[Straid of Olaphis - 5 Forlorn] Scythe of the Forlorn", ["Scythe of the Forlorn"], sotfs=True, shop=True),
    #     LocationData(76800200, "[Straid of Olaphis - 1 Forlorn] Hood of the Forlorn", ["Hood of the Forlorn"], sotfs=True, shop=True),
    #     LocationData(76800201, "[Straid of Olaphis - 4 Forlorn] Armor of the Forlorn", ["Armor of the Forlorn"], sotfs=True, shop=True),
    #     LocationData(76800202, "[Straid of Olaphis - 2 Forlorn] Gauntlets of the Forlorn", ["Gauntlets of the Forlorn"], sotfs=True, shop=True),
    #     LocationData(76800203, "[Straid of Olaphis - 3 Forlorn] Leggings of the Forlorn", ["Leggings of the Forlorn"], sotfs=True, shop=True),
    #     LocationData(76800302, "[Straid of Olaphis - Velstadt] Great Lightning Spear", ["Great Lightning Spear"], shop=True),
    #     LocationData(76800304, "[Straid of Olaphis - Velstadt] Sunlight Blade", ["Sunlight Blade"], shop=True),
    #     LocationData(76801000, "[Straid of Olaphis - Soul of the Pursuer] Pursuer's Ultra Greatsword", ["Pursuer's Ultra Greatsword"], shop=True),
    #     LocationData(76801001, "[Straid of Olaphis - Soul of the Pursuer] Pursuer's Greatshield", ["Pursuer's Greatshield"], shop=True),
    #     LocationData(76801002, "[Straid of Olaphis - Soul of the Last Giant] Giant Stone Axe", ["Giant Stone Axe"], shop=True),
    #     LocationData(76801003, "[Straid of Olaphis - Dragonrider Soul] Dragonrider's Halberd", ["Dragonrider's Halberd"], shop=True),
    #     LocationData(76801004, "[Straid of Olaphis - Dragonrider Soul] Dragonrider Bow", ["Dragonrider Bow"], shop=True),
    #     LocationData(76801005, "[Straid of Olaphis - Dragonrider Soul] Dragonrider Twinblade", ["Dragonrider Twinblade"], shop=True),
    #     LocationData(76801006, "[Straid of Olaphis - Dragonrider Soul] Dragonrider Greatshield", ["Dragonrider Greatshield"], shop=True),
    #     LocationData(76801007, "[Straid of Olaphis - Flexile Sentry Soul] Warped Sword", ["Warped Sword"], shop=True),
    #     LocationData(76801008, "[Straid of Olaphis - Flexile Sentry Soul] Barbed Club", ["Barbed Club"], shop=True),
    #     LocationData(76801009, "[Straid of Olaphis - Flexile Sentry Soul] Arced Sword", ["Arced Sword"], shop=True),
    #     LocationData(76801010, "[Straid of Olaphis - Executioner's Chariot Soul] Chariot Lance", ["Chariot Lance"], shop=True),
    #     LocationData(76801011, "[Straid of Olaphis - Executioner's Chariot Soul] Shield Crossbow", ["Shield Crossbow"], shop=True),
    #     LocationData(76801012, "[Straid of Olaphis - Skeleton Lord's Soul] Roaring Halberd", ["Roaring Halberd"], shop=True),
    #     LocationData(76801013, "[Straid of Olaphis - Skeleton Lord's Soul] Bone Scythe", ["Bone Scythe"], shop=True),
    #     LocationData(76801014, "[Straid of Olaphis - Mytha, the Baneful Queen Soul] Mytha's Bent Blade", ["Mytha's Bent Blade"], shop=True),
    #     LocationData(76801015, "[Straid of Olaphis - Smelter Demon Soul] Smelter Sword", ["Smelter Sword"], shop=True),
    #     LocationData(76801016, "[Straid of Olaphis - Demon of Song Soul] Spotted Whip", ["Spotted Whip"], shop=True),
    #     LocationData(76801017, "[Straid of Olaphis - Belfry Gargoyle Soul] Gargoyle Bident", ["Gargoyle Bident"], shop=True),
    #     LocationData(76801100, "[Straid of Olaphis - Ruin Sentinel Soul] Heavy Homing Soul Arrow", ["Heavy Homing Soul Arrow"], shop=True),
    #     LocationData(76801101, "[Straid of Olaphis - Royal Rat Vanguard Soul] Toxic Mist", ["Toxic Mist"], shop=True),
    #     LocationData(76801102, "[Straid of Olaphis - Scorpioness Najka Soul] Soul Shower", ["Soul Shower"], shop=True),
    #     LocationData(76801103, "[Straid of Olaphis - Royal Rat Authority Soul] Acid Surge", ["Acid Surge"], shop=True),
    #     LocationData(76801104, "[Straid of Olaphis - Soul of Velstadt] Sacred Oath", ["Sacred Oath"], shop=True),
    #     LocationData(76801105, "[Straid of Olaphis - Giant Lord Soul] Repel", ["Repel"], shop=True),
    #     LocationData(76801106, "[Straid of Olaphis - Darklurker Soul] Lifedrain Patch", ["Lifedrain Patch"], shop=True),
    #     LocationData(76801107, "[Straid of Olaphis - Old Witch Soul] Flame Weapon", ["Flame Weapon"], shop=True),
    #     LocationData(76801108, "[Straid of Olaphis - Old King Soul] Blinding Bolt", ["Blinding Bolt"], shop=True),
    #     LocationData(76801109, "[Straid of Olaphis - Old Dead One Soul] Numbness", ["Numbness"], shop=True),
    #     LocationData(76801110, "[Straid of Olaphis - Old Paledrake Soul] Crystal Soul Spear", ["Crystal Soul Spear"], shop=True),
    #     LocationData(76801111, "[Straid of Olaphis - Soul of Nadalia, Bride of Ash] Outcry", ["Outcry"], shop=True),
    #     LocationData(76801200, "[Straid of Olaphis - Soul of the Pursuer] Pursuer's Ultra Greatsword", ["Pursuer's Ultra Greatsword"], shop=True),
    #     LocationData(76801201, "[Straid of Olaphis - Soul of the Pursuer] Pursuer's Greatshield", ["Pursuer's Greatshield"], shop=True),
    #     LocationData(76801202, "[Straid of Olaphis - Soul of the Last Giant] Giant Stone Axe", ["Giant Stone Axe"], shop=True),
    #     LocationData(76801203, "[Straid of Olaphis - Dragonrider Soul] Dragonrider's Halberd", ["Dragonrider's Halberd"], shop=True),
    #     LocationData(76801204, "[Straid of Olaphis - Dragonrider Soul] Dragonrider Bow", ["Dragonrider Bow"], shop=True),
    #     LocationData(76801205, "[Straid of Olaphis - Dragonrider Soul] Dragonrider Twinblade", ["Dragonrider Twinblade"], shop=True),
    #     LocationData(76801206, "[Straid of Olaphis - Dragonrider Soul] Dragonrider Greatshield", ["Dragonrider Greatshield"], shop=True),
    #     LocationData(76801207, "[Straid of Olaphis - Flexile Sentry Soul] Warped Sword", ["Warped Sword"], shop=True),
    #     LocationData(76801208, "[Straid of Olaphis - Flexile Sentry Soul] Barbed Club", ["Barbed Club"], shop=True),
    #     LocationData(76801209, "[Straid of Olaphis - Flexile Sentry Soul] Arced Sword", ["Arced Sword"], shop=True),
    #     LocationData(76801210, "[Straid of Olaphis - Executioner's Chariot Soul] Chariot Lance", ["Chariot Lance"], shop=True),
    #     LocationData(76801211, "[Straid of Olaphis - Executioner's Chariot Soul] Shield Crossbow", ["Shield Crossbow"], shop=True),
    #     LocationData(76801212, "[Straid of Olaphis - Skeleton Lord's Soul] Roaring Halberd", ["Roaring Halberd"], shop=True),
    #     LocationData(76801213, "[Straid of Olaphis - Skeleton Lord's Soul] Bone Scythe", ["Bone Scythe"], shop=True),
    #     LocationData(76801214, "[Straid of Olaphis - Mytha, the Baneful Queen Soul] Mytha's Bent Blade", ["Mytha's Bent Blade"], shop=True),
    #     LocationData(76801215, "[Straid of Olaphis - Smelter Demon Soul] Smelter Sword", ["Smelter Sword"], shop=True),
    #     LocationData(76801216, "[Straid of Olaphis - Demon of Song Soul] Spotted Whip", ["Spotted Whip"], shop=True),
    #     LocationData(76801217, "[Straid of Olaphis - Belfry Gargoyle Soul] Gargoyle Bident", ["Gargoyle Bident"], shop=True),
    #     LocationData(76801300, "[Straid of Olaphis - Ruin Sentinel Soul] Heavy Homing Soul Arrow", ["Heavy Homing Soul Arrow"], shop=True),
    #     LocationData(76801301, "[Straid of Olaphis - Royal Rat Vanguard Soul] Toxic Mist", ["Toxic Mist"], shop=True),
    #     LocationData(76801302, "[Straid of Olaphis - Scorpioness Najka Soul] Soul Shower", ["Soul Shower"], shop=True),
    #     LocationData(76801303, "[Straid of Olaphis - Royal Rat Authority Soul] Acid Surge", ["Acid Surge"], shop=True),
    #     LocationData(76801304, "[Straid of Olaphis - Soul of Velstadt] Sacred Oath", ["Sacred Oath"], shop=True),
    #     LocationData(76801305, "[Straid of Olaphis - Giant Lord Soul] Repel", ["Repel"], shop=True),
    #     LocationData(76801306, "[Straid of Olaphis - Darklurker Soul] Lifedrain Patch", ["Lifedrain Patch"], shop=True),
    #     LocationData(77000000, "[Felkin the Outcast] Archdrake Staff", ["Archdrake Staff"], shop=True),
    #     LocationData(77000001, "[Felkin the Outcast] Archdrake Chime", ["Archdrake Chime"], shop=True),
    #     LocationData(77000002, "[Felkin the Outcast] Chaos Rapier", ["Chaos Rapier"], sotfs=True, shop=True),
    #     LocationData(77000100, "[Felkin the Outcast] Chaos Shield", ["Chaos Shield"], sotfs=True, shop=True),
    #     LocationData(77000300, "[Felkin the Outcast] Dark Orb", ["Dark Orb"], shop=True),
    #     LocationData(77000301, "[Felkin the Outcast] Dark Weapon", ["Dark Weapon"], shop=True),
    #     LocationData(77000302, "[Felkin the Outcast] Resonant Flesh", ["Resonant Flesh"], shop=True),
    #     LocationData(77000303, "[Felkin the Outcast] Resonant Weapon", ["Resonant Weapon"], shop=True),
    #     LocationData(77000304, "[Felkin the Outcast] Magic Barrier", ["Magic Barrier"], shop=True),
    #     LocationData(77000305, "[Felkin the Outcast] Resonant Soul", ["Resonant Soul"], shop=True),
    #     LocationData(77000306, "[Felkin the Outcast] Great Resonant Soul", ["Great Resonant Soul"], shop=True),
    #     LocationData(77000400, "[Felkin the Outcast] Ring of Life Protection", ["Ring of Life Protection"], shop=True),
    #     LocationData(77000600, "[Felkin the Outcast] Dark Pine Resin", ["Dark Pine Resin"], shop=True),
    #     LocationData(77100200, "[Royal Sorcerer Navlaan] Moon Hat", ["Moon Hat"], shop=True),
    #     LocationData(77100201, "[Royal Sorcerer Navlaan] Astrologist's Robe", ["Astrologist's Robe"], shop=True),
    #     LocationData(77100202, "[Royal Sorcerer Navlaan] Astrologist's Gauntlets", ["Astrologist's Gauntlets"], shop=True),
    #     LocationData(77100203, "[Royal Sorcerer Navlaan] Astrologist's Bottoms", ["Astrologist's Bottoms"], shop=True),
    #     LocationData(77100204, "[Royal Sorcerer Navlaan] Black Witch Hat", ["Black Witch Hat"], shop=True),
    #     LocationData(77100205, "[Royal Sorcerer Navlaan] Black Witch Robe", ["Black Witch Robe"], shop=True),
    #     LocationData(77100206, "[Royal Sorcerer Navlaan] Black Witch Gloves", ["Black Witch Gloves"], shop=True),
    #     LocationData(77100207, "[Royal Sorcerer Navlaan] Black Witch Trousers", ["Black Witch Trousers"], shop=True),
    #     LocationData(77100300, "[Royal Sorcerer Navlaan] Great Magic Weapon", ["Great Magic Weapon"], shop=True),
    #     LocationData(77100301, "[Royal Sorcerer Navlaan] Strong Magic Shield", ["Strong Magic Shield"], shop=True),
    #     LocationData(77100400, "[Royal Sorcerer Navlaan] Thunder Quartz Ring+2", ["Thunder Quartz Ring+2"], shop=True),
    #     LocationData(77100500, "[Royal Sorcerer Navlaan] Bonfire Ascetic", ["Bonfire Ascetic"], shop=True),
    #     LocationData(77100600, "[Royal Sorcerer Navlaan] Dragon Charm", ["Dragon Charm"], shop=True),
    #     LocationData(77100601, "[Royal Sorcerer Navlaan] Crimson Water", ["Crimson Water"], shop=True),
    #     LocationData(77100602, "[Royal Sorcerer Navlaan] Lightning Greatarrow", ["Lightning Greatarrow"], shop=True),
    #     LocationData(77100603, "[Royal Sorcerer Navlaan] Fire Greatarrow", ["Fire Greatarrow"], shop=True),
    #     LocationData(77100604, "[Royal Sorcerer Navlaan] Destructive Greatarrow", ["Destructive Greatarrow"], shop=True),
    #     LocationData(77200212, "[Magerold of Lanafir - Fume Knight] Raime's Helm", ["Raime's Helm"], shop=True),
    #     LocationData(77200213, "[Magerold of Lanafir - Fume Knight] Raime's Armor", ["Raime's Armor"], shop=True),
    #     LocationData(77200214, "[Magerold of Lanafir - Fume Knight] Raime's Gauntlets", ["Raime's Gauntlets"], shop=True),
    #     LocationData(77200215, "[Magerold of Lanafir - Fume Knight] Raime's Leggings", ["Raime's Leggings"], shop=True),
    #     LocationData(77200216, "[Magerold of Lanafir - Sir Alonne] Alonne's Helm", ["Alonne's Helm"], shop=True),
    #     LocationData(77200217, "[Magerold of Lanafir - Sir Alonne] Alonne's Armor", ["Alonne's Armor"], shop=True),
    #     LocationData(77200218, "[Magerold of Lanafir - Sir Alonne] Alonne's Gauntlets", ["Alonne's Gauntlets"], shop=True),
    #     LocationData(77200219, "[Magerold of Lanafir - Sir Alonne] Alonne's Leggings", ["Alonne's Leggings"], shop=True),
    #     LocationData(77600000, "[Weaponsmith Ornifex] Monastery Scimitar", ["Murakumo"], shop=True),
    #     LocationData(77600001, "[Weaponsmith Ornifex] Manikin Claws", ["Twinblade"], shop=True),
    #     LocationData(77600002, "[Weaponsmith Ornifex] Manikin Knife", ["Partizan"], shop=True),
    #     LocationData(77600003, "[Weaponsmith Ornifex] Lion Greataxe", ["Composite Bow"], shop=True),
    #     LocationData(77600004, "[Weaponsmith Ornifex] Silverblack Sickle", ["Heavy Crossbow"], shop=True),
    #     LocationData(77600300, "[Weaponsmith Ornifex] Homing Soul Arrow", ["Homing Soul Arrow"], shop=True),
    #     LocationData(77600301, "[Weaponsmith Ornifex] Homing Soulmass", ["Homing Soulmass"], shop=True),
    #     LocationData(77600302, "[Weaponsmith Ornifex] Fall Control", ["Fall Control"], shop=True),
    #     LocationData(77600600, "[Weaponsmith Ornifex] Flame Butterfly", ["Flame Butterfly"], shop=True),
    #     LocationData(77600601, "[Weaponsmith Ornifex] Fire Arrow", ["Fire Arrow"], shop=True),
    #     LocationData(77600602, "[Weaponsmith Ornifex] Fire Bolt", ["Fire Bolt"], shop=True),
    #     LocationData(77600603, "[Weaponsmith Ornifex] Green Blossom", ["Green Blossom"], shop=True),
    #     LocationData(77600604, "[Weaponsmith Ornifex] Amber Herb", ["Amber Herb"], shop=True),
    #     LocationData(77600605, "[Weaponsmith Ornifex - Nashandra] Green Blossom", ["Green Blossom"], shop=True),
    #     LocationData(77600606, "[Weaponsmith Ornifex - Nashandra] Twilight Herb", ["Amber Herb"], vanilla=True, shop=True),
    #     LocationData(77600606, "[Weaponsmith Ornifex - Nashandra] Twilight Herb", ["Twilight Herb"], sotfs=True, shop=True),
    #     LocationData(77601000, "[Weaponsmith Ornifex - Old Dragonslayer Soul] Dragonslayer Spear", ["Dragonslayer Spear"], shop=True),
    #     LocationData(77601001, "[Weaponsmith Ornifex - Soul of the Lost Sinner] Lost Sinner's Sword", ["Lost Sinner's Sword"], shop=True),
    #     LocationData(77601002, "[Weaponsmith Ornifex - Old Iron King Soul] Iron King Hammer", ["Iron King Hammer"], shop=True),
    #     LocationData(77601003, "[Weaponsmith Ornifex - Soul of the Rotten] Butcher's Knife", ["Butcher's Knife"], shop=True),
    #     LocationData(77601004, "[Weaponsmith Ornifex - Soul of the Duke's Dear Freja] Spider's Silk", ["Spider's Silk"], shop=True),
    #     LocationData(77601005, "[Weaponsmith Ornifex - Soul of the Duke's Dear Freja] Spider Fang", ["Spider Fang"], shop=True),
    #     LocationData(77601006, "[Weaponsmith Ornifex - Looking Glass Knight Soul] Thorned Greatsword", ["Thorned Greatsword"], shop=True),
    #     LocationData(77601007, "[Weaponsmith Ornifex - Looking Glass Knight Soul] King's Mirror", ["King's Mirror"], shop=True),
    #     LocationData(77601008, "[Weaponsmith Ornifex - Soul of Velstadt] Sacred Chime Hammer", ["Sacred Chime Hammer"], shop=True),
    #     LocationData(77601009, "[Weaponsmith Ornifex - Soul of the King] Ruler's Sword", ["Ruler's Sword"], shop=True),
    #     LocationData(77601010, "[Weaponsmith Ornifex - Soul of the King] King's Ultra Greatsword", ["King's Ultra Greatsword"], shop=True),
    #     LocationData(77601011, "[Weaponsmith Ornifex - Soul of the King] King's Shield", ["King's Shield"], shop=True),
    #     LocationData(77601012, "[Weaponsmith Ornifex - Guardian Dragon Soul] Spitfire Spear", ["Spitfire Spear"], shop=True),
    #     LocationData(77601013, "[Weaponsmith Ornifex - Guardian Dragon Soul] Drakewing Ultra Greatsword", ["Drakewing Ultra Greatsword"], shop=True),
    #     LocationData(77601014, "[Weaponsmith Ornifex - Ancient Dragon Soul] Curved Dragon Greatsword", ["Curved Dragon Greatsword"], shop=True),
    #     LocationData(77601015, "[Weaponsmith Ornifex - Soul of Nashandra] Scythe of Want", ["Scythe of Want"], shop=True),
    #     LocationData(77601016, "[Weaponsmith Ornifex - Soul of Nashandra] Chime of Want", ["Chime of Want"], shop=True),
    #     LocationData(77601017, "[Weaponsmith Ornifex - Soul of Nashandra] Bow of Want", ["Bow of Want"], shop=True),
    #     LocationData(77601018, "[Weaponsmith Ornifex - Throne Defender Soul] Defender Greatsword", ["Defender Greatsword"], shop=True),
    #     LocationData(77601019, "[Weaponsmith Ornifex - Throne Defender Soul] Defender's Shield", ["Defender's Shield"], shop=True),
    #     LocationData(77601020, "[Weaponsmith Ornifex - Throne Watcher Soul] Watcher Greatsword", ["Watcher Greatsword"], shop=True),
    #     LocationData(77601021, "[Weaponsmith Ornifex - Throne Watcher Soul] Watcher's Shield", ["Watcher's Shield"], shop=True),
    #     LocationData(77601022, "[Weaponsmith Ornifex - Old Paledrake Soul] Moonlight Greatsword", ["Moonlight Greatsword"], shop=True),
    #     LocationData(77601023, "[Weaponsmith Ornifex - Old Dead One Soul] Crypt Blacksword", ["Crypt Blacksword"], shop=True),
    #     LocationData(77601024, "[Weaponsmith Ornifex - Old Witch Soul] Chaos Blade", ["Chaos Blade"], shop=True),
    #     LocationData(77601025, "[Weaponsmith Ornifex - Old King Soul] Dragonslayer Greatbow", ["Dragonslayer Greatbow"], shop=True),
    #     LocationData(77601026, "[Weaponsmith Ornifex - Soul of Sinh, the Slumbering Dragon] Yorgh's Spear", ["Yorgh's Spear"], shop=True),
    #     LocationData(77601027, "[Weaponsmith Ornifex - Soul of Elana, Squalid Queen] Wrathful Axe", ["Wrathful Axe"], shop=True),
    #     LocationData(77601028, "[Weaponsmith Ornifex - Soul of Nadalia, Bride of Ash] Chime of Screams", ["Chime of Screams"], shop=True),
    #     LocationData(77601029, "[Weaponsmith Ornifex - Soul of the Fume Knight] Fume Sword", ["Fume Sword"], shop=True),
    #     LocationData(77601030, "[Weaponsmith Ornifex - Soul of the Fume Knight] Fume Ultra Greatsword", ["Fume Ultra Greatsword"], shop=True),
    #     LocationData(77601031, "[Weaponsmith Ornifex - Soul of Sir Alonne] Bewitched Alonne Sword", ["Bewitched Alonne Sword"], shop=True),
    #     LocationData(77601032, "[Weaponsmith Ornifex - Smelter Demon Soul] Aged Smelter Sword", ["Aged Smelter Sword"], shop=True),
    #     LocationData(77601033, "[Weaponsmith Ornifex - Soul of Aava, the King's Pet] Ivory Straight Sword", ["Ivory Straight Sword"], shop=True),
    #     LocationData(77601034, "[Weaponsmith Ornifex - Soul of Zallen, the King's Pet] Loyce Shield", ["Loyce Shield"], shop=True),
    #     LocationData(77601035, "[Weaponsmith Ornifex - Soul of Lud, the King's Pet] Loyce Greatsword", ["Loyce Greatsword"], shop=True),
    #     LocationData(77601036, "[Weaponsmith Ornifex - Soul of the Ivory King] Ivory King Ultra Greatsword", ["Ivory King Ultra Greatsword"], shop=True),
    #     LocationData(77601037, "[Weaponsmith Ornifex - Soul of Alsanna, Silent Oracle] Eleum Loyce", ["Eleum Loyce"], shop=True),
    #     LocationData(77601100, "[Weaponsmith Ornifex - Old Dragonslayer Soul] Dragonslayer Spear", ["Dragonslayer Spear"], shop=True),
    #     LocationData(77601101, "[Weaponsmith Ornifex - Soul of the Lost Sinner] Lost Sinner's Sword", ["Lost Sinner's Sword"], shop=True),
    #     LocationData(77601102, "[Weaponsmith Ornifex - Old Iron King Soul] Iron King Hammer", ["Iron King Hammer"], shop=True),
    #     LocationData(77601103, "[Weaponsmith Ornifex - Soul of the Rotten] Butcher's Knife", ["Butcher's Knife"], shop=True),
    #     LocationData(77601104, "[Weaponsmith Ornifex - Soul of the Duke's Dear Freja] Spider's Silk", ["Spider's Silk"], shop=True),
    #     LocationData(77601105, "[Weaponsmith Ornifex - Soul of the Duke's Dear Freja] Spider Fang", ["Spider Fang"], shop=True),
    #     LocationData(77601106, "[Weaponsmith Ornifex - Looking Glass Knight Soul] Thorned Greatsword", ["Thorned Greatsword"], shop=True),
    #     LocationData(77601107, "[Weaponsmith Ornifex - Looking Glass Knight Soul] King's Mirror", ["King's Mirror"], shop=True),
    #     LocationData(77601108, "[Weaponsmith Ornifex - Soul of Velstadt] Sacred Chime Hammer", ["Sacred Chime Hammer"], shop=True),
    #     LocationData(77601109, "[Weaponsmith Ornifex - Soul of the King] Ruler's Sword", ["Ruler's Sword"], shop=True),
    #     LocationData(77601110, "[Weaponsmith Ornifex - Soul of the King] King's Ultra Greatsword", ["King's Ultra Greatsword"], shop=True),
    #     LocationData(77601111, "[Weaponsmith Ornifex - Soul of the King] King's Shield", ["King's Shield"], shop=True),
    #     LocationData(77601112, "[Weaponsmith Ornifex - Guardian Dragon Soul] Spitfire Spear", ["Spitfire Spear"], shop=True),
    #     LocationData(77601113, "[Weaponsmith Ornifex - Guardian Dragon Soul] Drakewing Ultra Greatsword", ["Drakewing Ultra Greatsword"], shop=True),
    #     LocationData(77601114, "[Weaponsmith Ornifex - Ancient Dragon Soul] Curved Dragon Greatsword", ["Curved Dragon Greatsword"], shop=True),
    #     LocationData(77601115, "[Weaponsmith Ornifex - Soul of Nashandra] Scythe of Want", ["Scythe of Want"], shop=True),
    #     LocationData(77601116, "[Weaponsmith Ornifex - Soul of Nashandra] Chime of Want", ["Chime of Want"], shop=True),
    #     LocationData(77601117, "[Weaponsmith Ornifex - Soul of Nashandra] Bow of Want", ["Bow of Want"], shop=True),
    #     LocationData(77601118, "[Weaponsmith Ornifex - Throne Defender Soul] Defender Greatsword", ["Defender Greatsword"], shop=True),
    #     LocationData(77601119, "[Weaponsmith Ornifex - Throne Defender Soul] Defender's Shield", ["Defender's Shield"], shop=True),
    #     LocationData(77601120, "[Weaponsmith Ornifex - Throne Watcher Soul] Watcher Greatsword", ["Watcher Greatsword"], shop=True),
    #     LocationData(77601121, "[Weaponsmith Ornifex - Throne Watcher Soul] Watcher's Shield", ["Watcher's Shield"], shop=True),
    #     LocationData(77602000, "[Weaponsmith Ornifex - Old Dragonslayer Soul] Dragonslayer Spear", ["Dragonslayer Spear"], shop=True),
    #     LocationData(77602001, "[Weaponsmith Ornifex - Soul of the Lost Sinner] Lost Sinner's Sword", ["Lost Sinner's Sword"], shop=True),
    #     LocationData(77602002, "[Weaponsmith Ornifex - Old Iron King Soul] Iron King Hammer", ["Iron King Hammer"], shop=True),
    #     LocationData(77602003, "[Weaponsmith Ornifex - Soul of the Rotten] Butcher's Knife", ["Butcher's Knife"], shop=True),
    #     LocationData(77602004, "[Weaponsmith Ornifex - Soul of the Duke's Dear Freja] Spider's Silk", ["Spider's Silk"], shop=True),
    #     LocationData(77602005, "[Weaponsmith Ornifex - Soul of the Duke's Dear Freja] Spider Fang", ["Spider Fang"], shop=True),
    #     LocationData(77602006, "[Weaponsmith Ornifex - Looking Glass Knight Soul] Thorned Greatsword", ["Thorned Greatsword"], shop=True),
    #     LocationData(77602007, "[Weaponsmith Ornifex - Looking Glass Knight Soul] King's Mirror", ["King's Mirror"], shop=True),
    #     LocationData(77602008, "[Weaponsmith Ornifex - Soul of Velstadt] Sacred Chime Hammer", ["Sacred Chime Hammer"], shop=True),
    #     LocationData(77602009, "[Weaponsmith Ornifex - Soul of the King] Ruler's Sword", ["Ruler's Sword"], shop=True),
    #     LocationData(77602010, "[Weaponsmith Ornifex - Soul of the King] King's Ultra Greatsword", ["King's Ultra Greatsword"], shop=True),
    #     LocationData(77602011, "[Weaponsmith Ornifex - Soul of the King] King's Shield", ["King's Shield"], shop=True),
    #     LocationData(77602012, "[Weaponsmith Ornifex - Guardian Dragon Soul] Spitfire Spear", ["Spitfire Spear"], shop=True),
    #     LocationData(77602013, "[Weaponsmith Ornifex - Guardian Dragon Soul] Drakewing Ultra Greatsword", ["Drakewing Ultra Greatsword"], shop=True),
    #     LocationData(77602014, "[Weaponsmith Ornifex - Ancient Dragon Soul] Curved Dragon Greatsword", ["Curved Dragon Greatsword"], shop=True),
    #     LocationData(77602015, "[Weaponsmith Ornifex - Soul of Nashandra] Scythe of Want", ["Scythe of Want"], shop=True),
    #     LocationData(77602016, "[Weaponsmith Ornifex - Soul of Nashandra] Chime of Want", ["Chime of Want"], shop=True),
    #     LocationData(77602017, "[Weaponsmith Ornifex - Soul of Nashandra] Bow of Want", ["Bow of Want"], shop=True),
    #     LocationData(77602018, "[Weaponsmith Ornifex - Throne Defender Soul] Defender Greatsword", ["Defender Greatsword"], shop=True),
    #     LocationData(77602019, "[Weaponsmith Ornifex - Throne Defender Soul] Defender's Shield", ["Defender's Shield"], shop=True),
    #     LocationData(77602020, "[Weaponsmith Ornifex - Throne Watcher Soul] Watcher Greatsword", ["Watcher Greatsword"], shop=True),
    #     LocationData(77602021, "[Weaponsmith Ornifex - Throne Watcher Soul] Watcher's Shield", ["Watcher's Shield"], shop=True),
    #     LocationData(77602022, "[Weaponsmith Ornifex - Old Paledrake Soul] Moonlight Greatsword", ["Moonlight Greatsword"], shop=True),
    #     LocationData(77602023, "[Weaponsmith Ornifex - Old Dead One Soul] Crypt Blacksword", ["Crypt Blacksword"], shop=True),
    #     LocationData(77602024, "[Weaponsmith Ornifex - Old Witch Soul] Chaos Blade", ["Chaos Blade"], shop=True),
    #     LocationData(77602025, "[Weaponsmith Ornifex - Old King Soul] Dragonslayer Greatbow", ["Dragonslayer Greatbow"], shop=True),
    #     LocationData(77602026, "[Weaponsmith Ornifex - Soul of Sinh, the Slumbering Dragon] Yorgh's Spear", ["Yorgh's Spear"], shop=True),
    #     LocationData(77602027, "[Weaponsmith Ornifex - Soul of Sinh, the Slumbering Dragon] Yorgh's Spear", ["Wrathful Axe"], shop=True),
    #     LocationData(77602028, "[Weaponsmith Ornifex - Soul of Nadalia, Bride of Ash] Chime of Screams", ["Chime of Screams"], shop=True),
    #     LocationData(77602029, "[Weaponsmith Ornifex - Soul of the Fume Knight] Fume Sword", ["Fume Sword"], shop=True),
    #     LocationData(77602030, "[Weaponsmith Ornifex - Soul of the Fume Knight] Fume Ultra Greatsword", ["Fume Ultra Greatsword"], shop=True),
    #     LocationData(77602031, "[Weaponsmith Ornifex - Soul of Sir Alonne] Bewitched Alonne Sword", ["Bewitched Alonne Sword"], shop=True),
    #     LocationData(77602032, "[Weaponsmith Ornifex - Smelter Demon Soul] Aged Smelter Sword", ["Aged Smelter Sword"], shop=True),
    #     LocationData(77602033, "[Weaponsmith Ornifex - Soul of Aava, the King's Pet] Ivory Straight Sword", ["Ivory Straight Sword"], shop=True),
    #     LocationData(77602034, "[Weaponsmith Ornifex - Soul of Zallen, the King's Pet] Loyce Shield", ["Loyce Shield"], shop=True),
    #     LocationData(77602035, "[Weaponsmith Ornifex - Soul of Lud, the King's Pet] Loyce Greatsword", ["Loyce Greatsword"], shop=True),
    #     LocationData(77602036, "[Weaponsmith Ornifex - Soul of the Ivory King] Ivory King Ultra Greatsword", ["Ivory King Ultra Greatsword"], shop=True),
    #     LocationData(77602037, "[Weaponsmith Ornifex - Soul of Alsanna, Silent Oracle] Eleum Loyce", ["Eleum Loyce"], shop=True),
    #     LocationData(77602100, "[Weaponsmith Ornifex - Old Dragonslayer Soul] Dragonslayer Spear", ["Dragonslayer Spear"], shop=True),
    #     LocationData(77602101, "[Weaponsmith Ornifex - Soul of the Lost Sinner] Lost Sinner's Sword", ["Lost Sinner's Sword"], shop=True),
    #     LocationData(77602102, "[Weaponsmith Ornifex - Old Iron King Soul] Iron King Hammer", ["Iron King Hammer"], shop=True),
    #     LocationData(77602103, "[Weaponsmith Ornifex - Soul of the Rotten] Butcher's Knife", ["Butcher's Knife"], shop=True),
    #     LocationData(77602104, "[Weaponsmith Ornifex - Soul of the Duke's Dear Freja] Spider's Silk", ["Spider's Silk"], shop=True),
    #     LocationData(77602105, "[Weaponsmith Ornifex - Soul of the Duke's Dear Freja] Spider Fang", ["Spider Fang"], shop=True),
    #     LocationData(77602106, "[Weaponsmith Ornifex - Looking Glass Knight Soul] Thorned Greatsword", ["Thorned Greatsword"], shop=True),
    #     LocationData(77602107, "[Weaponsmith Ornifex - Looking Glass Knight Soul] King's Mirror", ["King's Mirror"], shop=True),
    #     LocationData(77602108, "[Weaponsmith Ornifex - Soul of Velstadt] Sacred Chime Hammer", ["Sacred Chime Hammer"], shop=True),
    #     LocationData(77602109, "[Weaponsmith Ornifex - Soul of the King] Ruler's Sword", ["Ruler's Sword"], shop=True),
    #     LocationData(77602110, "[Weaponsmith Ornifex - Soul of the King] King's Ultra Greatsword", ["King's Ultra Greatsword"], shop=True),
    #     LocationData(77602111, "[Weaponsmith Ornifex - Soul of the King] King's Shield", ["King's Shield"], shop=True),
    #     LocationData(77602112, "[Weaponsmith Ornifex - Guardian Dragon Soul] Spitfire Spear", ["Spitfire Spear"], shop=True),
    #     LocationData(77602113, "[Weaponsmith Ornifex - Guardian Dragon Soul] Drakewing Ultra Greatsword", ["Drakewing Ultra Greatsword"], shop=True),
    #     LocationData(77602114, "[Weaponsmith Ornifex - Ancient Dragon Soul] Curved Dragon Greatsword", ["Curved Dragon Greatsword"], shop=True),
    #     LocationData(77602115, "[Weaponsmith Ornifex - Soul of Nashandra] Scythe of Want", ["Scythe of Want"], shop=True),
    #     LocationData(77602116, "[Weaponsmith Ornifex - Soul of Nashandra] Chime of Want", ["Chime of Want"], shop=True),
    #     LocationData(77602117, "[Weaponsmith Ornifex - Soul of Nashandra] Bow of Want", ["Bow of Want"], shop=True),
    #     LocationData(77602118, "[Weaponsmith Ornifex - Throne Defender Soul] Defender Greatsword", ["Defender Greatsword"], shop=True),
    #     LocationData(77602119, "[Weaponsmith Ornifex - Throne Defender Soul] Defender's Shield", ["Defender's Shield"], shop=True),
    #     LocationData(77602120, "[Weaponsmith Ornifex - Throne Watcher Soul] Watcher Greatsword", ["Watcher Greatsword"], shop=True),
    #     LocationData(77602121, "[Weaponsmith Ornifex - Throne Watcher Soul] Watcher's Shield", ["Watcher's Shield"], shop=True),
    #     LocationData(78400308, "[Cromwell the Pardoner - Unknown Event] Great Heal", ["Great Heal"], shop=True),
    #     LocationData(78400309, "[Cromwell the Pardoner - Unknown Event] Replenishment", ["Replenishment"], shop=True),
    #     LocationData(78400310, "[Cromwell the Pardoner - Unknown Event] Caressing Prayer", ["Caressing Prayer"], shop=True),
    #     LocationData(78400311, "[Cromwell the Pardoner - Unknown Event] Force", ["Force"], shop=True),
    #     LocationData(78400312, "[Cromwell the Pardoner - Unknown Event] Emit Force", ["Emit Force"], shop=True),
    #     LocationData(78400313, "[Cromwell the Pardoner - Unknown Event] Heavenly Thunder", ["Heavenly Thunder"], shop=True),
    #     LocationData(78400314, "[Cromwell the Pardoner - Unknown Event] Perseverance", ["Perseverance"], shop=True),
    #     LocationData(78400315, "[Cromwell the Pardoner - Unknown Event] Scraps of Life", ["Scraps of Life"], shop=True),
    #     LocationData(78500000, "[Blue Sentinel Targray] Morning Star", ["Morning Star"], shop=True),
    #     LocationData(78500001, "[Blue Sentinel Targray] Halberd", ["Halberd"], shop=True),
    #     LocationData(78500300, "[Blue Sentinel Targray] Emit Force", ["Emit Force"], shop=True),
    #     LocationData(78500301, "[Blue Sentinel Targray] Heavenly Thunder", ["Heavenly Thunder"], shop=True),
    #     LocationData(78500600, "[Blue Sentinel Targray] Monastery Charm", ["Monastery Charm"], shop=True),
    #     LocationData(78500601, "[Blue Sentinel Targray] Holy Water Urn", ["Holy Water Urn"], shop=True),
    #     LocationData(78500602, "[Blue Sentinel Targray] Boltstone", ["Boltstone"], shop=True),
    #     LocationData(78500603, "[Blue Sentinel Targray, NG+] Cracked Blue Eye Orb", ["Cracked Blue Eye Orb"], shop=True),
    # ],
}

location_name_groups: Dict[str, Set[str]] = {}

for region in location_table:
    for location in location_table[region]:
        if location.event: continue
        if location.code == 309700: continue # "[MemoryJeigh] Giant Lord drop"
        if region not in location_name_groups:
            location_name_groups[region] = {location.name}
        else:
            location_name_groups[region].add(location.name)
