from dataclasses import dataclass

from .constants import TMCEvent, TMCFlagGroup


@dataclass
class ROMData:
    offset: int
    data: int


@dataclass
class AddressData:
    First: str | None
    Second: str | None
    Third: str | None
    Fourth: str | None
    Fifth: str | None
    Sixth: str | None
    Seventh: str | None
    Eighth: str | None


flag_group_by_name: dict[str, int] = {
    TMCFlagGroup.SIGNATURE: 0xFF1000,  # 0x2002A40, 0x01
    TMCFlagGroup.INITIALISED: 0xFF1001,  # 0x2002A41, 0x01
    TMCFlagGroup.TEXTSPEED: 0xFF1002,  # 0x2002A42, 0x01
    TMCFlagGroup.BRIGHTNESS: 0xFF1003,  # 0x2002A43, 0x01
    TMCFlagGroup.LIGHT_FORCE_ON_FILE_SELECT: 0xFF1006,  # 0x2002A46, 0x01
    TMCFlagGroup.DEEPWOOD_SHRINE_BARREL_STATE: 0xFF1007,  # 0x2002A47, 0x01
    TMCFlagGroup.GAME_STAGE: 0xFF1008,  # 0x2002A48, 0x01
    TMCFlagGroup.FIGURINES_AVAILABLE_COUNT: 0xFF1009,  # 0x2002A49, 0x01
    TMCFlagGroup.QUEST_MAP_MARKERS: 0xFF1020,  # 0x2002A60, 0x02
    TMCFlagGroup.MAP_SQUARE_REVEALED: 0xFF1040,  # 0x2002A80, 0x03
    TMCFlagGroup.WIND_CRESTS: 0xFF1043,  # 0x2002A83, 0x01
    TMCFlagGroup.ENEMY_KILL_COUNT: 0xFF1050,  # 0x2002A90, 0x04
    TMCFlagGroup.ITEMS_BOUGHT_FROM_STOCKWELL: 0xFF105C,  # 0x2002A9C, 0x01
    TMCFlagGroup.OVERWORLD_VISITED_LOCATIONS: 0xFF1060,  # 0x2002AA0, 0x03
    TMCFlagGroup.DUNGEON_VISITED_LOCATIONS: 0xFF1063,  # 0x2002AA3, 0x01
    TMCFlagGroup.FILE_NAME: 0xFF1080,  # 0x2002AC0, 0x06

    TMCFlagGroup.ROOM_TRANSITIONING_TO_AREA_ID: 0xFF1088,  # 0x2002AC8, 0x01
    TMCFlagGroup.ROOM_TRANSITIONING_TO_ROOM_ID: 0xFF1089,  # 0x2002AC9, 0x01
    TMCFlagGroup.TRANSITION_FACING_DIRECTION: 0xFF108A,  # 0x2002ACA, 0x01
    TMCFlagGroup.TRANSITION_ANIMATION: 0xFF108B,  # 0x2002ACB, 0x01
    TMCFlagGroup.TRANSITION_DESTINATION_X_COORDINATE_OFFSET: 0xFF108C,  # 0x2002ACC, 0x02
    TMCFlagGroup.TRANSITION_DESTINATION_Y_COORDINATE_OFFSET: 0xFF108E,  # 0x2002ACE, 0x02
    TMCFlagGroup.TRANSITION_DESTINATION_LAYER: 0xFF1090,  # 0x2002AD0, 0x01
    TMCFlagGroup.LAST_DUNGEON_ENTERED_AREA_ID: 0xFF1092,  # 0x2002AD2, 0x01
    TMCFlagGroup.LAST_DUNGEON_ENTERED_ROOM_ID: 0xFF1093,  # 0x2002AD3, 0x01
    TMCFlagGroup.LAST_DUNGEON_ENTERED_X_COORDINATE: 0xFF1094,  # 0x2002AD4, 0x02
    TMCFlagGroup.LAST_DUNGEON_ENTERED_Y_COORDINATE: 0xFF1096,  # 0x2002AD6, 0x02
    TMCFlagGroup.CURRENT_DUNGEON_X_COORDINATE: 0xFF1098,  # 0x2002AD8, 0x02
    TMCFlagGroup.CURRENT_DUNGEON_Y_COORDINATE: 0xFF109A,  # 0x2002ADA, 0x02
    TMCFlagGroup.CURRENT_OVERWORLD_X_COORDINATE: 0xFF109C,  # 0x2002ADC, 0x02
    TMCFlagGroup.CURRENT_OVERWORLD_Y_COORDINATE: 0xFF109E,  # 0x2002ADE, 0x02

    TMCFlagGroup.WALLET_SIZE: 0xFF10A8,  # 0x2002AE8, 0x01
    TMCFlagGroup.HEART_PIECES: 0xFF10A9,  # 0x2002AE9, 0x01
    TMCFlagGroup.LINKS_CURRENT_HEALTH: 0xFF10AA,  # 0x2002AEA, 0x01
    TMCFlagGroup.LINKS_MAX_HEALTH: 0xFF10AB,  # 0x2002AEB, 0x01
    TMCFlagGroup.BOMB_COUNT: 0xFF10AC,  # 0x2002AEC, 0x01
    TMCFlagGroup.ARROW_COUNT: 0xFF10AD,  # 0x2002AED, 0x01
    TMCFlagGroup.BOMB_BAG: 0xFF10AE,  # 0x2002AEE, 0x01
    TMCFlagGroup.QUIVER: 0xFF10AF,  # 0x2002AEF, 0x01
    TMCFlagGroup.FIGURINE_COUNT: 0xFF10B0,  # 0x2002AF0, 0x01
    TMCFlagGroup.COLLECTED_ALL_FIGURINES: 0xFF10B1,  # 0x2002AF1, 0x01
    TMCFlagGroup.ACTIVE_CHARM: 0xFF10B2,  # 0x2002AF2, 0x01
    TMCFlagGroup.ACTIVE_PICOLYTE: 0xFF10B3,  # 0x2002AF3, 0x01
    TMCFlagGroup.A_BUTTON_ITEMS: 0xFF10B4,  # 0x2002AF4, 0x01
    TMCFlagGroup.B_BUTTON_ITEMS: 0xFF10B5,  # 0x2002AF5, 0x01
    TMCFlagGroup.BOTTLE_1_CONTENTS: 0xFF10B6,  # 0x2002AF6, 0x01
    TMCFlagGroup.BOTTLE_2_CONTENTS: 0xFF10B7,  # 0x2002AF7, 0x01
    TMCFlagGroup.BOTTLE_3_CONTENTS: 0xFF10B8,  # 0x2002AF8, 0x01
    TMCFlagGroup.BOTTLE_4_CONTENTS: 0xFF10B9,  # 0x2002AF9, 0x01
    TMCFlagGroup.EFFECT: 0xFF10BA,  # 0x2002AFA, 0x01
    TMCFlagGroup.MYSTERIOUS_SHELLS_DISABLED: 0xFF10BB,  # 0x2002AFB, 0x01
    TMCFlagGroup.RUPEES: 0xFF10C0,  # 0x2002B00, 0x02
    TMCFlagGroup.MYSTERIOUS_SHELLS: 0xFF10C2,  # 0x2002B02, 0x02
    TMCFlagGroup.CHARM_TIMER: 0xFF10C4,  # 0x2002B04, 0x02
    TMCFlagGroup.PICOLYTE_TIMER: 0xFF10C6,  # 0x2002B06, 0x02
    TMCFlagGroup.FIGURINE_COLLECTED_FLAGS: 0xFF10CE,  # 0x2002B0E, 0x12
    TMCFlagGroup.INVENTORY: 0xFF10F2,  # 0x2002B32, 0x1E

    TMCFlagGroup.DONE_ALL_FUSIONS: 0xFF1116,  # 0x2002B56, 0x01
    TMCFlagGroup.FUSIONS_COUNT: 0xFF1117,  # 0x2002B57, 0x01

    TMCFlagGroup.KINSTONE_TYPE_IN_SLOT_1: 0xFF1118,  # 0x2002B58, 0x01
    TMCFlagGroup.KINSTONE_TYPE_IN_SLOT_2: 0xFF1119,  # 0x2002B59, 0x01
    TMCFlagGroup.KINSTONE_TYPE_IN_SLOT_3: 0xFF111A,  # 0x2002B5A, 0x01
    TMCFlagGroup.KINSTONE_TYPE_IN_SLOT_4: 0xFF111B,  # 0x2002B5B, 0x01
    TMCFlagGroup.KINSTONE_TYPE_IN_SLOT_5: 0xFF111C,  # 0x2002B5C, 0x01
    TMCFlagGroup.KINSTONE_TYPE_IN_SLOT_6: 0xFF111D,  # 0x2002B5D, 0x01
    TMCFlagGroup.KINSTONE_TYPE_IN_SLOT_7: 0xFF111E,  # 0x2002B5E, 0x01
    TMCFlagGroup.KINSTONE_TYPE_IN_SLOT_8: 0xFF111F,  # 0x2002B5F, 0x01
    TMCFlagGroup.KINSTONE_TYPE_IN_SLOT_9: 0xFF1120,  # 0x2002B60, 0x01
    TMCFlagGroup.KINSTONE_TYPE_IN_SLOT_10: 0xFF1121,  # 0x2002B61, 0x01
    TMCFlagGroup.KINSTONE_TYPE_IN_SLOT_11: 0xFF1122,  # 0x2002B62, 0x01
    TMCFlagGroup.KINSTONE_TYPE_IN_SLOT_12: 0xFF1123,  # 0x2002B63, 0x01
    TMCFlagGroup.KINSTONE_TYPE_IN_SLOT_13: 0xFF1124,  # 0x2002B64, 0x01
    TMCFlagGroup.KINSTONE_TYPE_IN_SLOT_14: 0xFF1125,  # 0x2002B65, 0x01
    TMCFlagGroup.KINSTONE_TYPE_IN_SLOT_15: 0xFF1126,  # 0x2002B66, 0x01
    TMCFlagGroup.KINSTONE_TYPE_IN_SLOT_16: 0xFF1127,  # 0x2002B67, 0x01
    TMCFlagGroup.KINSTONE_TYPE_IN_SLOT_17: 0xFF1128,  # 0x2002B68, 0x01
    TMCFlagGroup.KINSTONE_TYPE_IN_SLOT_18: 0xFF1129,  # 0x2002B69, 0x01
    TMCFlagGroup.KINSTONE_TYPE_IN_SLOT_19: 0xFF112A,  # 0x2002B6A, 0x01

    TMCFlagGroup.KINSTONE_COUNT_IN_SLOT_1: 0xFF112B,  # 0x2002B6B, 0x01
    TMCFlagGroup.KINSTONE_COUNT_IN_SLOT_2: 0xFF112C,  # 0x2002B6C, 0x01
    TMCFlagGroup.KINSTONE_COUNT_IN_SLOT_3: 0xFF112D,  # 0x2002B6D, 0x01
    TMCFlagGroup.KINSTONE_COUNT_IN_SLOT_4: 0xFF112E,  # 0x2002B6E, 0x01
    TMCFlagGroup.KINSTONE_COUNT_IN_SLOT_5: 0xFF112F,  # 0x2002B6F, 0x01
    TMCFlagGroup.KINSTONE_COUNT_IN_SLOT_6: 0xFF1130,  # 0x2002B70, 0x01
    TMCFlagGroup.KINSTONE_COUNT_IN_SLOT_7: 0xFF1131,  # 0x2002B71, 0x01
    TMCFlagGroup.KINSTONE_COUNT_IN_SLOT_8: 0xFF1132,  # 0x2002B72, 0x01
    TMCFlagGroup.KINSTONE_COUNT_IN_SLOT_9: 0xFF1133,  # 0x2002B73, 0x01
    TMCFlagGroup.KINSTONE_COUNT_IN_SLOT_10: 0xFF1134,  # 0x2002B74, 0x01
    TMCFlagGroup.KINSTONE_COUNT_IN_SLOT_11: 0xFF1135,  # 0x2002B75, 0x01
    TMCFlagGroup.KINSTONE_COUNT_IN_SLOT_12: 0xFF1136,  # 0x2002B76, 0x01
    TMCFlagGroup.KINSTONE_COUNT_IN_SLOT_13: 0xFF1137,  # 0x2002B77, 0x01
    TMCFlagGroup.KINSTONE_COUNT_IN_SLOT_14: 0xFF1138,  # 0x2002B78, 0x01
    TMCFlagGroup.KINSTONE_COUNT_IN_SLOT_15: 0xFF1139,  # 0x2002B79, 0x01
    TMCFlagGroup.KINSTONE_COUNT_IN_SLOT_16: 0xFF113A,  # 0x2002B7A, 0x01
    TMCFlagGroup.KINSTONE_COUNT_IN_SLOT_17: 0xFF113B,  # 0x2002B7B, 0x01
    TMCFlagGroup.KINSTONE_COUNT_IN_SLOT_18: 0xFF113C,  # 0x2002B7C, 0x01
    TMCFlagGroup.KINSTONE_COUNT_IN_SLOT_19: 0xFF113D,  # 0x2002B7D, 0x01

    TMCFlagGroup.SMITH_LINKS_HOUSE_FUSIONS_COMPLETED: 0xFF1142,  # 0x2002B82, 0x01
    TMCFlagGroup.KING_DALTUS_MISSING_FUSIONS_COMPLETED: 0xFF1143,  # 0x2002B83, 0x01
    TMCFlagGroup.MINISTER_POTHO_MISSING_FUSIONS_COMPLETED: 0xFF1144,  # 0x2002B84, 0x01
    TMCFlagGroup.MAYOR_HAGEN_TOWN_FUSIONS_COMPLETED: 0xFF1145,  # 0x2002B85, 0x01
    TMCFlagGroup.STURGEON_LIBRARY_UPSTAIRS_FUSIONS_COMPLETED: 0xFF1146,  # 0x2002B86, 0x01
    TMCFlagGroup.GRAYBLADE_CRENEL_DOJO_FUSIONS_COMPLETED: 0xFF1147,  # 0x2002B87, 0x01
    TMCFlagGroup.WAVEBLADE_LAKE_DOJO_FUSIONS_COMPLETED: 0xFF1148,  # 0x2002B88, 0x01
    TMCFlagGroup.GRIMBLADE_CASTLE_DOJO_FUSIONS_COMPLETED: 0xFF1149,  # 0x2002B89, 0x01
    TMCFlagGroup.CRENEL_HERMIT_FUSIONS_COMPLETED: 0xFF114A,  # 0x2002B8A, 0x01
    TMCFlagGroup.ANJU_CUCCO_LADY_FUSIONS_COMPLETED: 0xFF114B,  # 0x2002B8B, 0x01
    TMCFlagGroup.TINA_SCHOOL_PINK_TEACHER_FUSIONS_COMPLETED: 0xFF114C,  # 0x2002B8C, 0x01
    TMCFlagGroup.JOEL_SCHOOL_SLEEPING_BOY_FUSIONS_COMPLETED: 0xFF114D,  # 0x2002B8D, 0x01
    TMCFlagGroup.HARRISON_SCHOOL_TWIN_BOY_FUSIONS_COMPLETED: 0xFF114E,  # 0x2002B8E, 0x01
    TMCFlagGroup.ERIK_SCHOOL_TWIN_BOY_FUSIONS_COMPLETED: 0xFF114F,  # 0x2002B8F, 0x01
    TMCFlagGroup.JIM_SCHOOL_READING_BOY_FUSIONS_COMPLETED: 0xFF1150,  # 0x2002B90, 0x01
    TMCFlagGroup.BERRY_SCHOOL_BRUNETTE_GIRL_FUSIONS_COMPLETED: 0xFF1151,  # 0x2002B91, 0x01
    TMCFlagGroup.LEILA_SCHOOL_BLONDE_GIRL_FUSIONS_COMPLETED: 0xFF1152,  # 0x2002B92, 0x01
    TMCFlagGroup.MAMA_CAFE_BLONDE_LADY_FUSIONS_COMPLETED: 0xFF1153,  # 0x2002B93, 0x01
    TMCFlagGroup.BARIS_CAFE_SAT_MAN_FUSIONS_COMPLETED: 0xFF1154,  # 0x2002B94, 0x01
    TMCFlagGroup.CHAI_CAFE_SAT_LADY_FUSIONS_COMPLETED: 0xFF1155,  # 0x2002B95, 0x01
    TMCFlagGroup.HERB_OUTSIDE_CAFE_MAN_FUSIONS_COMPLETED: 0xFF1156,  # 0x2002B96, 0x01
    TMCFlagGroup.JASMINE_OUTSIDE_CAFE_LADY_FUSIONS_COMPLETED: 0xFF1157,  # 0x2002B97, 0x01
    TMCFlagGroup.BREVE_CAFE_OLD_LADY_FUSIONS_COMPLETED: 0xFF1158,  # 0x2002B98, 0x01
    TMCFlagGroup.BINDLE_INN_1F_MAN_FUSIONS_COMPLETED: 0xFF1159,  # 0x2002B99, 0x01
    TMCFlagGroup.SATCHEL_INN_SITTING_FUSIONS_COMPLETED: 0xFF115A,  # 0x2002B9A, 0x01
    TMCFlagGroup.BROCCO_MARKET_VEG_FUSIONS_COMPLETED: 0xFF115B,  # 0x2002B9B, 0x01
    TMCFlagGroup.PINA_MARKET_FRUIT_FUSIONS_COMPLETED: 0xFF115C,  # 0x2002B9C, 0x01
    TMCFlagGroup.POSTMAN_TOWN_FUSIONS_COMPLETED: 0xFF115D,  # 0x2002B9D, 0x01
    TMCFlagGroup.ZILL_LIBRARY_ROOF_SNOTTY_BOY_FUSIONS_COMPLETED: 0xFF115E,  # 0x2002B9E, 0x01
    TMCFlagGroup.LOLLY_LIBRARY_ROOF_MIDDLE_BOY_FUSIONS_COMPLETED: 0xFF115F,  # 0x2002B9F, 0x01
    TMCFlagGroup.CANDY_LIBRARY_ROOF_GIRL_FUSIONS_COMPLETED: 0xFF1160,  # 0x2002BA0, 0x01
    TMCFlagGroup.MUTOH_CARPENTER_BOSS_FUSIONS_COMPLETED: 0xFF1161,  # 0x2002BA1, 0x01
    TMCFlagGroup.MACK_CARPENTER_FUSIONS_COMPLETED: 0xFF1162,  # 0x2002BA2, 0x01
    TMCFlagGroup.DOYLE_CARPENTER_FUSIONS_COMPLETED: 0xFF1163,  # 0x2002BA3, 0x01
    TMCFlagGroup.BREMOR_MISSING_CARPENTER_FUSIONS_COMPLETED: 0xFF1164,  # 0x2002BA4, 0x01
    TMCFlagGroup.BRENT_CARPENTER_FUSIONS_COMPLETED: 0xFF1165,  # 0x2002BA5, 0x01
    TMCFlagGroup.ROMIO_TOWN_FUSIONS_COMPLETED: 0xFF1166,  # 0x2002BA6, 0x01
    TMCFlagGroup.JULIETTA_MISSING_FUSIONS_COMPLETED: 0xFF1167,  # 0x2002BA7, 0x01
    TMCFlagGroup.VERONA_MISSING_JULIET_MOM_FUSIONS_COMPLETED: 0xFF1168,  # 0x2002BA8, 0x01
    TMCFlagGroup.ANTON_BARLOV_SHOP_FUSIONS_COMPLETED: 0xFF1169,  # 0x2002BA9, 0x01
    TMCFlagGroup.SHEILA_TOWN_BELL_BLONDE_FUSIONS_COMPLETED: 0xFF116A,  # 0x2002BAA, 0x01
    TMCFlagGroup.JUNE_BRUNETTE_NEAR_CAFE_FUSIONS_COMPLETED: 0xFF116B,  # 0x2002BAB, 0x01
    TMCFlagGroup.KEELEY_MARKET_BLONDE_LADY_FUSIONS_COMPLETED: 0xFF116C,  # 0x2002BAC, 0x01
    TMCFlagGroup.HURDY_GURDY_MAN_CAFE_FUSIONS_COMPLETED: 0xFF116D,  # 0x2002BAD, 0x01
    TMCFlagGroup.KLAUS_OLD_MAN_LIBRARY_FUSIONS_COMPLETED: 0xFF116E,  # 0x2002BAE, 0x01
    TMCFlagGroup.MARSHALL_OLD_MAN_NEAR_INN_FUSIONS_COMPLETED: 0xFF116F,  # 0x2002BAF, 0x01
    TMCFlagGroup.DOTTIE_MARKET_OLD_LADY_FUSIONS_COMPLETED: 0xFF1170,  # 0x2002BB0, 0x01
    TMCFlagGroup.STRANGER_TOWN_FUSIONS_COMPLETED: 0xFF1171,  # 0x2002BB1, 0x01
    TMCFlagGroup.GALE_CLOUDS_WIND_TRIBE_1F_FUSIONS_COMPLETED: 0xFF1172,  # 0x2002BB2, 0x01
    TMCFlagGroup.CAPRICE_WIND_TRIBE_2F_UPPER_FUSIONS_COMPLETED: 0xFF1173,  # 0x2002BB3, 0x01
    TMCFlagGroup.HAILEY_CLOUDS_WIND_TRIBE_UPPER_BLOCKER_FUSIONS_COMPLETED: 0xFF1174,  # 0x2002BB4, 0x01
    TMCFlagGroup.SIROC_WIND_TRIBE_OLD_LADY_FUSIONS_COMPLETED: 0xFF1175,  # 0x2002BB5, 0x01
    TMCFlagGroup.FLURRIS_WIND_TRIBE_LOWER_BLOCKER_FUSIONS_COMPLETED: 0xFF1176,  # 0x2002BB6, 0x01
    TMCFlagGroup.GREGAL_WIND_TRIBE_OLD_MAN_FUSIONS_COMPLETED: 0xFF1177,  # 0x2002BB7, 0x01
    TMCFlagGroup.TALON_LONLON_RANCH_FUSIONS_COMPLETED: 0xFF1178,  # 0x2002BB8, 0x01
    TMCFlagGroup.MALON_TOWN_FUSIONS_COMPLETED: 0xFF1179,  # 0x2002BB9, 0x01
    TMCFlagGroup.EPONA_TOWN_FUSIONS_COMPLETED: 0xFF117A,  # 0x2002BBA, 0x01
    TMCFlagGroup.DAMPE_GRAVEYARD_FUSIONS_COMPLETED: 0xFF117B,  # 0x2002BBB, 0x01
    TMCFlagGroup.TINGLE_SOUTH_FIELD_FUSIONS_COMPLETED: 0xFF117C,  # 0x2002BBC, 0x01
    TMCFlagGroup.ANKLE_LONLON_TINGLE_FUSIONS_COMPLETED: 0xFF117D,  # 0x2002BBD, 0x01
    TMCFlagGroup.KNUCKLE_TRILBY_TINGLE_FUSIONS_COMPLETED: 0xFF117E,  # 0x2002BBE, 0x01
    TMCFlagGroup.DAVID_JR_LAKE_TINGLE_FUSIONS_COMPLETED: 0xFF117F,  # 0x2002BBF, 0x01
    TMCFlagGroup.EENIE_UPPER_FARMER_FUSIONS_COMPLETED: 0xFF1180,  # 0x2002BC0, 0x01
    TMCFlagGroup.MEENIE_LOWER_FARMER_FUSIONS_COMPLETED: 0xFF1181,  # 0x2002BC1, 0x01
    TMCFlagGroup.PERCY_WESTERN_WOODS_FUSIONS_COMPLETED: 0xFF1182,  # 0x2002BC2, 0x01
    TMCFlagGroup.NAYRU_TOWN_INN_FUSIONS_COMPLETED: 0xFF1183,  # 0x2002BC3, 0x01
    TMCFlagGroup.FARORE_TOWN_INN_FUSIONS_COMPLETED: 0xFF1184,  # 0x2002BC4, 0x01
    TMCFlagGroup.DIN_TOWN_INN_FUSIONS_COMPLETED: 0xFF1185,  # 0x2002BC5, 0x01
    TMCFlagGroup.SPOOKTER_GRAVEYARD_GHOST_FUSIONS_COMPLETED: 0xFF1186,  # 0x2002BC6, 0x01
    TMCFlagGroup.GINA_PINK_GHOST_FUSIONS_COMPLETED: 0xFF1187,  # 0x2002BC7, 0x01
    TMCFlagGroup.FESTARI_VILLAGE_PRIEST_FUSIONS_COMPLETED: 0xFF1188,  # 0x2002BC8, 0x01
    TMCFlagGroup.GENTARI_VILLAGE_ELDER_FUSIONS_COMPLETED: 0xFF1189,  # 0x2002BC9, 0x01
    TMCFlagGroup.VILLAGE_BARREL_TOP_MINISH_FUSIONS_COMPLETED: 0xFF118A,  # 0x2002BCA, 0x01
    TMCFlagGroup.VILLAGE_BARREL_LADDER_MINISH_FUSIONS_COMPLETED: 0xFF118B,  # 0x2002BCB, 0x01
    TMCFlagGroup.VILLAGE_VASE_HOUSE_MINISH__FUSIONS_COMPLETED: 0xFF118C,  # 0x2002BCC, 0x01
    TMCFlagGroup.VILLAGE_GREEN_HOUSE_MINISH_FUSIONS_COMPLETED: 0xFF118D,  # 0x2002BCD, 0x01
    TMCFlagGroup.VILLAGE_LAKE_MINISH_FUSIONS_COMPLETED: 0xFF118E,  # 0x2002BCE, 0x01
    TMCFlagGroup.MELARI_CRENEL_FUSIONS_COMPLETED: 0xFF118F,  # 0x2002BCF, 0x01
    TMCFlagGroup.MELARI_KITCHEN_MINISH_FUSIONS_COMPLETED: 0xFF1190,  # 0x2002BD0, 0x01
    TMCFlagGroup.MELARI_NEAR_BEDROOM_MINISH_FUSIONS_COMPLETED: 0xFF1191,  # 0x2002BD1, 0x01
    TMCFlagGroup.MELARI_EXIT_MINISH_FUSIONS_COMPLETED: 0xFF1192,  # 0x2002BD2, 0x01
    TMCFlagGroup.MELARI_TOP_LEFT_MINISH_FUSIONS_COMPLETED: 0xFF1193,  # 0x2002BD3, 0x01
    TMCFlagGroup.WESTERN_WOODS_MINISH_FUSIONS_COMPLETED: 0xFF1194,  # 0x2002BD4, 0x01
    TMCFlagGroup.SOUTH_FIELD_MINISH_FUSIONS_COMPLETED: 0xFF1195,  # 0x2002BD5, 0x01
    TMCFlagGroup.TRILBY_MINISH_FUSIONS_COMPLETED: 0xFF1196,  # 0x2002BD6, 0x01
    TMCFlagGroup.HILLS_MINISH_FUSIONS_COMPLETED: 0xFF1197,  # 0x2002BD7, 0x01
    TMCFlagGroup.TOWN_MUSHROOM_MINISH_FUSIONS_COMPLETED: 0xFF1198,  # 0x2002BD8, 0x01
    TMCFlagGroup.BELARI_BOMB_MINISH_FUSIONS_COMPLETED: 0xFF1199,  # 0x2002BD9, 0x01
    TMCFlagGroup.LAKE_CREST_MINISH_FUSIONS_COMPLETED: 0xFF119A,  # 0x2002BDA, 0x01
    TMCFlagGroup.LAKE_EAST_MINISH_FUSIONS_COMPLETED: 0xFF119B,  # 0x2002BDB, 0x01
    TMCFlagGroup.CASTLE_MINISH_FUSIONS_COMPLETED: 0xFF119C,  # 0x2002BDC, 0x01
    TMCFlagGroup.CRENEL_BASE_MINISH_FUSIONS_COMPLETED: 0xFF119D,  # 0x2002BDD, 0x01
    TMCFlagGroup.NORTH_FIELD_MINISH_FUSIONS_COMPLETED: 0xFF119E,  # 0x2002BDE, 0x01
    TMCFlagGroup.RUINS_MINISH_FUSIONS_COMPLETED: 0xFF119F,  # 0x2002BDF, 0x01
    TMCFlagGroup.CARPENTER_MINISH_FUSIONS_COMPLETED: 0xFF11A0,  # 0x2002BE0, 0x01
    TMCFlagGroup.CAFE_FOREST_MINISH_FUSIONS_COMPLETED: 0xFF11A1,  # 0x2002BE1, 0x01
    TMCFlagGroup.CAFE_MINISH_LEFT_FUSIONS_COMPLETED: 0xFF11A2,  # 0x2002BE2, 0x01
    TMCFlagGroup.CAFE_MINISH_RIGHT_FUSIONS_COMPLETED: 0xFF11A3,  # 0x2002BE3, 0x01
    TMCFlagGroup.LIBRARY_MINISH_BLUE_FUSIONS_COMPLETED: 0xFF11A4,  # 0x2002BE4, 0x01
    TMCFlagGroup.LIBRARI_FUSIONS_COMPLETED: 0xFF11A5,  # 0x2002BE5, 0x01
    TMCFlagGroup.LIBRARY_MINISH_YELLOW_FUSIONS_COMPLETED: 0xFF11A6,  # 0x2002BE6, 0x01
    TMCFlagGroup.TRILBY_MYSTERIOUS_WALL_FUSIONS_COMPLETED: 0xFF11A7,  # 0x2002BE7, 0x01
    TMCFlagGroup.HILLS_MYSTERIOUS_WALL_FUSIONS_COMPLETED: 0xFF11A8,  # 0x2002BE8, 0x01
    TMCFlagGroup.CRENEL_MYSTERIOUS_WALL_FUSIONS_COMPLETED: 0xFF11A9,  # 0x2002BE9, 0x01
    TMCFlagGroup.MINISH_MYSTERIOUS_WALL_FUSIONS_COMPLETED: 0xFF11AA,  # 0x2002BEA, 0x01
    TMCFlagGroup.LAKE_MYSTERIOUS_WALL_FUSIONS_COMPLETED: 0xFF11AB,  # 0x2002BEB, 0x01
    TMCFlagGroup.LEFT_GORON_FUSIONS_COMPLETED: 0xFF11AC,  # 0x2002BEC, 0x01
    TMCFlagGroup.RIGHT_GORON_FUSIONS_COMPLETED: 0xFF11AD,  # 0x2002BED, 0x01
    TMCFlagGroup.CRENEL_BUSINESS_SCRUB_FUSIONS_COMPLETED: 0xFF11AE,  # 0x2002BEE, 0x01
    TMCFlagGroup.SWAMP_BUSINESS_SCRUB_FUSIONS_COMPLETED: 0xFF11AF,  # 0x2002BEF, 0x01
    TMCFlagGroup.MINISH_BUSINESS_SCRUB_FUSIONS_COMPLETED: 0xFF11B0,  # 0x2002BF0, 0x01
    TMCFlagGroup.BORKEN_FIFI_LAKE_DOG_FUSIONS_COMPLETED: 0xFF11B1,  # 0x2002BF1, 0x01
    TMCFlagGroup.ROLF_ROMEO_DOG_FUSIONS_COMPLETED: 0xFF11B2,  # 0x2002BF2, 0x01
    TMCFlagGroup.GROWLER_WEST_DOG_FUSIONS_COMPLETED: 0xFF11B3,  # 0x2002BF3, 0x01
    TMCFlagGroup.SCRATCHER_JULIET_CAT_FUSIONS_COMPLETED: 0xFF11B4,  # 0x2002BF4, 0x01
    TMCFlagGroup.PURRY_BRIDGE_CAT_FUSIONS_COMPLETED: 0xFF11B5,  # 0x2002BF5, 0x01
    TMCFlagGroup.ROOF_CUCCO_FUSIONS_COMPLETED: 0xFF11B6,  # 0x2002BF6, 0x01
    TMCFlagGroup.CUCCO_CHICK_FUSIONS_COMPLETED: 0xFF11B7,  # 0x2002BF7, 0x01
    TMCFlagGroup.ELSIE_LONLON_COW_FUSIONS_COMPLETED: 0xFF11B8,  # 0x2002BF8, 0x01

    TMCFlagGroup.SMITH_LINKS_HOUSE_FUSIONS_OFFERED: 0xFF11C2,  # 0x2002C02, 0x01
    TMCFlagGroup.KING_DALTUS_MISSING_FUSIONS_OFFERED: 0xFF11C3,  # 0x2002C03, 0x01
    TMCFlagGroup.MINISTER_POTHO_MISSING_FUSIONS_OFFERED: 0xFF11C4,  # 0x2002C04, 0x01
    TMCFlagGroup.MAYOR_HAGEN_TOWN_FUSIONS_OFFERED: 0xFF11C5,  # 0x2002C05, 0x01
    TMCFlagGroup.STURGEON_LIBRARY_UPSTAIRS_FUSIONS_OFFERED: 0xFF11C6,  # 0x2002C06, 0x01
    TMCFlagGroup.GRAYBLADE_CRENEL_DOJO_FUSIONS_OFFERED: 0xFF11C7,  # 0x2002C07, 0x01
    TMCFlagGroup.WAVEBLADE_LAKE_DOJO_FUSIONS_OFFERED: 0xFF11C8,  # 0x2002C08, 0x01
    TMCFlagGroup.GRIMBLADE_CASTLE_DOJO_FUSIONS_OFFERED: 0xFF11C9,  # 0x2002C09, 0x01
    TMCFlagGroup.CRENEL_HERMIT_FUSIONS_OFFERED: 0xFF11CA,  # 0x2002C0A, 0x01
    TMCFlagGroup.ANJU_CUCCO_LADY_FUSIONS_OFFERED: 0xFF11CB,  # 0x2002C0B, 0x01
    TMCFlagGroup.TINA_SCHOOL_PINK_TEACHER_FUSIONS_OFFERED: 0xFF11CC,  # 0x2002C0C, 0x01
    TMCFlagGroup.JOEL_SCHOOL_SLEEPING_BOY_FUSIONS_OFFERED: 0xFF11CD,  # 0x2002C0D, 0x01
    TMCFlagGroup.HARRISON_SCHOOL_TWIN_BOY_FUSIONS_OFFERED: 0xFF11CE,  # 0x2002C0E, 0x01
    TMCFlagGroup.ERIK_SCHOOL_TWIN_BOY_FUSIONS_OFFERED: 0xFF11CF,  # 0x2002C0F, 0x01
    TMCFlagGroup.JIM_SCHOOL_READING_BOY_FUSIONS_OFFERED: 0xFF11D0,  # 0x2002C10, 0x01
    TMCFlagGroup.BERRY_SCHOOL_BRUNETTE_GIRL_FUSIONS_OFFERED: 0xFF11D1,  # 0x2002C11, 0x01
    TMCFlagGroup.LEILA_SCHOOL_BLONDE_GIRL_FUSIONS_OFFERED: 0xFF11D2,  # 0x2002C12, 0x01
    TMCFlagGroup.MAMA_CAFE_BLONDE_LADY_FUSIONS_OFFERED: 0xFF11D3,  # 0x2002C13, 0x01
    TMCFlagGroup.BARIS_CAFE_SAT_MAN_FUSIONS_OFFERED: 0xFF11D4,  # 0x2002C14, 0x01
    TMCFlagGroup.CHAI_CAFE_SAT_LADY_FUSIONS_OFFERED: 0xFF11D5,  # 0x2002C15, 0x01
    TMCFlagGroup.HERB_OUTSIDE_CAFE_MAN_FUSIONS_OFFERED: 0xFF11D6,  # 0x2002C16, 0x01
    TMCFlagGroup.JASMINE_OUTSIDE_CAFE_LADY_FUSIONS_OFFERED: 0xFF11D7,  # 0x2002C17, 0x01
    TMCFlagGroup.BREVE_CAFE_OLD_LADY_FUSIONS_OFFERED: 0xFF11D8,  # 0x2002C18, 0x01
    TMCFlagGroup.BINDLE_INN_1F_MAN_FUSIONS_OFFERED: 0xFF11D9,  # 0x2002C19, 0x01
    TMCFlagGroup.SATCHEL_INN_SITTING_FUSIONS_OFFERED: 0xFF11DA,  # 0x2002C1A, 0x01
    TMCFlagGroup.BROCCO_MARKET_VEG_FUSIONS_OFFERED: 0xFF11DB,  # 0x2002C1B, 0x01
    TMCFlagGroup.PINA_MARKET_FRUIT_FUSIONS_OFFERED: 0xFF11DC,  # 0x2002C1C, 0x01
    TMCFlagGroup.POSTMAN_TOWN_FUSIONS_OFFERED: 0xFF11DD,  # 0x2002C1D, 0x01
    TMCFlagGroup.ZILL_LIBRARY_ROOF_SNOTTY_BOY_FUSIONS_OFFERED: 0xFF11DE,  # 0x2002C1E, 0x01
    TMCFlagGroup.LOLLY_LIBRARY_ROOF_MIDDLE_BOY_FUSIONS_OFFERED: 0xFF11DF,  # 0x2002C1F, 0x01
    TMCFlagGroup.CANDY_LIBRARY_ROOF_GIRL_FUSIONS_OFFERED: 0xFF11E0,  # 0x2002C20, 0x01
    TMCFlagGroup.MUTOH_CARPENTER_BOSS_FUSIONS_OFFERED: 0xFF11E1,  # 0x2002C21, 0x01
    TMCFlagGroup.MACK_CARPENTER_FUSIONS_OFFERED: 0xFF11E2,  # 0x2002C22, 0x01
    TMCFlagGroup.DOYLE_CARPENTER_FUSIONS_OFFERED: 0xFF11E3,  # 0x2002C23, 0x01
    TMCFlagGroup.BREMOR_MISSING_CARPENTER_FUSIONS_OFFERED: 0xFF11E4,  # 0x2002C24, 0x01
    TMCFlagGroup.BRENT_CARPENTER_FUSIONS_OFFERED: 0xFF11E5,  # 0x2002C25, 0x01
    TMCFlagGroup.ROMIO_TOWN_FUSIONS_OFFERED: 0xFF11E6,  # 0x2002C26, 0x01
    TMCFlagGroup.JULIETTA_MISSING_FUSIONS_OFFERED: 0xFF11E7,  # 0x2002C27, 0x01
    TMCFlagGroup.VERONA_MISSING_JULIET_MOM_FUSIONS_OFFERED: 0xFF11E8,  # 0x2002C28, 0x01
    TMCFlagGroup.ANTON_BARLOV_SHOP_FUSIONS_OFFERED: 0xFF11E9,  # 0x2002C29, 0x01
    TMCFlagGroup.SHEILA_TOWN_BELL_BLONDE_FUSIONS_OFFERED: 0xFF11EA,  # 0x2002C2A, 0x01
    TMCFlagGroup.JUNE_BRUNETTE_NEAR_CAFE_FUSIONS_OFFERED: 0xFF11EB,  # 0x2002C2B, 0x01
    TMCFlagGroup.KEELEY_MARKET_BLONDE_LADY_FUSIONS_OFFERED: 0xFF11EC,  # 0x2002C2C, 0x01
    TMCFlagGroup.HURDY_GURDY_MAN_CAFE_FUSIONS_OFFERED: 0xFF11ED,  # 0x2002C2D, 0x01
    TMCFlagGroup.KLAUS_OLD_MAN_LIBRARY_FUSIONS_OFFERED: 0xFF11EE,  # 0x2002C2E, 0x01
    TMCFlagGroup.MARSHALL_OLD_MAN_NEAR_INN_FUSIONS_OFFERED: 0xFF11EF,  # 0x2002C2F, 0x01
    TMCFlagGroup.DOTTIE_MARKET_OLD_LADY_FUSIONS_OFFERED: 0xFF11F0,  # 0x2002C30, 0x01
    TMCFlagGroup.STRANGER_TOWN_FUSIONS_OFFERED: 0xFF11F1,  # 0x2002C31, 0x01
    TMCFlagGroup.GALE_CLOUDS_WIND_TRIBE_1F_FUSIONS_OFFERED: 0xFF11F2,  # 0x2002C32, 0x01
    TMCFlagGroup.CAPRICE_WIND_TRIBE_2F_UPPER_FUSIONS_OFFERED: 0xFF11F3,  # 0x2002C33, 0x01
    TMCFlagGroup.HAILEY_CLOUDS_WIND_TRIBE_UPPER_BLOCKER_FUSIONS_OFFERED: 0xFF11F4,  # 0x2002C34, 0x01
    TMCFlagGroup.SIROC_WIND_TRIBE_OLD_LADY_FUSIONS_OFFERED: 0xFF11F5,  # 0x2002C35, 0x01
    TMCFlagGroup.FLURRIS_WIND_TRIBE_LOWER_BLOCKER_FUSIONS_OFFERED: 0xFF11F6,  # 0x2002C36, 0x01
    TMCFlagGroup.GREGAL_WIND_TRIBE_OLD_MAN_FUSIONS_OFFERED: 0xFF11F7,  # 0x2002C37, 0x01
    TMCFlagGroup.TALON_LONLON_RANCH_FUSIONS_OFFERED: 0xFF11F8,  # 0x2002C38, 0x01
    TMCFlagGroup.MALON_TOWN_FUSIONS_OFFERED: 0xFF11F9,  # 0x2002C39, 0x01
    TMCFlagGroup.EPONA_TOWN_FUSIONS_OFFERED: 0xFF11FA,  # 0x2002C3A, 0x01
    TMCFlagGroup.DAMPE_GRAVEYARD_FUSIONS_OFFERED: 0xFF11FB,  # 0x2002C3B, 0x01
    TMCFlagGroup.TINGLE_SOUTH_FIELD_FUSIONS_OFFERED: 0xFF11FC,  # 0x2002C3C, 0x01
    TMCFlagGroup.ANKLE_LONLON_TINGLE_FUSIONS_OFFERED: 0xFF11FD,  # 0x2002C3D, 0x01
    TMCFlagGroup.KNUCKLE_TRILBY_TINGLE_FUSIONS_OFFERED: 0xFF11FE,  # 0x2002C3E, 0x01
    TMCFlagGroup.DAVID_JR_LAKE_TINGLE_FUSIONS_OFFERED: 0xFF11FF,  # 0x2002C3F, 0x01
    TMCFlagGroup.EENIE_UPPER_FARMER_FUSIONS_OFFERED: 0xFF1200,  # 0x2002C40, 0x01
    TMCFlagGroup.MEENIE_LOWER_FARMER_FUSIONS_OFFERED: 0xFF1201,  # 0x2002C41, 0x01
    TMCFlagGroup.PERCY_WESTERN_WOODS_FUSIONS_OFFERED: 0xFF1202,  # 0x2002C42, 0x01
    TMCFlagGroup.NAYRU_TOWN_INN_FUSIONS_OFFERED: 0xFF1203,  # 0x2002C43, 0x01
    TMCFlagGroup.FARORE_TOWN_INN_FUSIONS_OFFERED: 0xFF1204,  # 0x2002C44, 0x01
    TMCFlagGroup.DIN_TOWN_INN_FUSIONS_OFFERED: 0xFF1205,  # 0x2002C45, 0x01
    TMCFlagGroup.SPOOKTER_GRAVEYARD_GHOST_FUSIONS_OFFERED: 0xFF1206,  # 0x2002C46, 0x01
    TMCFlagGroup.GINA_PINK_GHOST_FUSIONS_OFFERED: 0xFF1207,  # 0x2002C47, 0x01
    TMCFlagGroup.FESTARI_VILLAGE_PRIEST_FUSIONS_OFFERED: 0xFF1208,  # 0x2002C48, 0x01
    TMCFlagGroup.GENTARI_VILLAGE_ELDER_FUSIONS_OFFERED: 0xFF1209,  # 0x2002C49, 0x01
    TMCFlagGroup.VILLAGE_BARREL_TOP_MINISH_FUSIONS_OFFERED: 0xFF120A,  # 0x2002C4A, 0x01
    TMCFlagGroup.VILLAGE_BARREL_LADDER_MINISH_FUSIONS_OFFERED: 0xFF120B,  # 0x2002C4B, 0x01
    TMCFlagGroup.VILLAGE_VASE_HOUSE_MINISH__FUSIONS_OFFERED: 0xFF120C,  # 0x2002C4C, 0x01
    TMCFlagGroup.VILLAGE_GREEN_HOUSE_MINISH_FUSIONS_OFFERED: 0xFF120D,  # 0x2002C4D, 0x01
    TMCFlagGroup.VILLAGE_LAKE_MINISH_FUSIONS_OFFERED: 0xFF120E,  # 0x2002C4E, 0x01
    TMCFlagGroup.MELARI_CRENEL_FUSIONS_OFFERED: 0xFF120F,  # 0x2002C4F, 0x01
    TMCFlagGroup.MELARI_KITCHEN_MINISH_FUSIONS_OFFERED: 0xFF1210,  # 0x2002C50, 0x01
    TMCFlagGroup.MELARI_NEAR_BEDROOM_MINISH_FUSIONS_OFFERED: 0xFF1211,  # 0x2002C51, 0x01
    TMCFlagGroup.MELARI_EXIT_MINISH_FUSIONS_OFFERED: 0xFF1212,  # 0x2002C52, 0x01
    TMCFlagGroup.MELARI_TOP_LEFT_MINISH_FUSIONS_OFFERED: 0xFF1213,  # 0x2002C53, 0x01
    TMCFlagGroup.WESTERN_WOODS_MINISH_FUSIONS_OFFERED: 0xFF1214,  # 0x2002C54, 0x01
    TMCFlagGroup.SOUTH_FIELD_MINISH_FUSIONS_OFFERED: 0xFF1215,  # 0x2002C55, 0x01
    TMCFlagGroup.TRILBY_MINISH_FUSIONS_OFFERED: 0xFF1216,  # 0x2002C56, 0x01
    TMCFlagGroup.HILLS_MINISH_FUSIONS_OFFERED: 0xFF1217,  # 0x2002C57, 0x01
    TMCFlagGroup.TOWN_MUSHROOM_MINISH_FUSIONS_OFFERED: 0xFF1218,  # 0x2002C58, 0x01
    TMCFlagGroup.BELARI_BOMB_MINISH_FUSIONS_OFFERED: 0xFF1219,  # 0x2002C59, 0x01
    TMCFlagGroup.LAKE_CREST_MINISH_FUSIONS_OFFERED: 0xFF121A,  # 0x2002C5A, 0x01
    TMCFlagGroup.LAKE_EAST_MINISH_FUSIONS_OFFERED: 0xFF121B,  # 0x2002C5B, 0x01
    TMCFlagGroup.CASTLE_MINISH_FUSIONS_OFFERED: 0xFF121C,  # 0x2002C5C, 0x01
    TMCFlagGroup.CRENEL_BASE_MINISH_FUSIONS_OFFERED: 0xFF121D,  # 0x2002C5D, 0x01
    TMCFlagGroup.NORTH_FIELD_MINISH_FUSIONS_OFFERED: 0xFF121E,  # 0x2002C5E, 0x01
    TMCFlagGroup.RUINS_MINISH_FUSIONS_OFFERED: 0xFF121F,  # 0x2002C5F, 0x01
    TMCFlagGroup.CARPENTER_MINISH_FUSIONS_OFFERED: 0xFF1220,  # 0x2002C60, 0x01
    TMCFlagGroup.CAFE_FOREST_MINISH_FUSIONS_OFFERED: 0xFF1221,  # 0x2002C61, 0x01
    TMCFlagGroup.CAFE_MINISH_LEFT_FUSIONS_OFFERED: 0xFF1222,  # 0x2002C62, 0x01
    TMCFlagGroup.CAFE_MINISH_RIGHT_FUSIONS_OFFERED: 0xFF1223,  # 0x2002C63, 0x01
    TMCFlagGroup.LIBRARY_MINISH_BLUE_FUSIONS_OFFERED: 0xFF1224,  # 0x2002C64, 0x01
    TMCFlagGroup.LIBRARI_FUSIONS_OFFERED: 0xFF1225,  # 0x2002C65, 0x01
    TMCFlagGroup.LIBRARY_MINISH_YELLOW_FUSIONS_OFFERED: 0xFF1226,  # 0x2002C66, 0x01
    TMCFlagGroup.TRILBY_MYSTERIOUS_WALL_FUSIONS_OFFERED: 0xFF1227,  # 0x2002C67, 0x01
    TMCFlagGroup.HILLS_MYSTERIOUS_WALL_FUSIONS_OFFERED: 0xFF1228,  # 0x2002C68, 0x01
    TMCFlagGroup.CRENEL_MYSTERIOUS_WALL_FUSIONS_OFFERED: 0xFF1229,  # 0x2002C69, 0x01
    TMCFlagGroup.MINISH_MYSTERIOUS_WALL_FUSIONS_OFFERED: 0xFF122A,  # 0x2002C6A, 0x01
    TMCFlagGroup.LAKE_MYSTERIOUS_WALL_FUSIONS_OFFERED: 0xFF122B,  # 0x2002C6B, 0x01
    TMCFlagGroup.LEFT_GORON_FUSIONS_OFFERED: 0xFF122C,  # 0x2002C6C, 0x01
    TMCFlagGroup.RIGHT_GORON_FUSIONS_OFFERED: 0xFF122D,  # 0x2002C6D, 0x01
    TMCFlagGroup.CRENEL_BUSINESS_SCRUB_FUSIONS_OFFERED: 0xFF122E,  # 0x2002C6E, 0x01
    TMCFlagGroup.SWAMP_BUSINESS_SCRUB_FUSIONS_OFFERED: 0xFF122F,  # 0x2002C6F, 0x01
    TMCFlagGroup.MINISH_BUSINESS_SCRUB_FUSIONS_OFFERED: 0xFF1230,  # 0x2002C70, 0x01
    TMCFlagGroup.BORKEN_FIFI_LAKE_DOG_FUSIONS_OFFERED: 0xFF1231,  # 0x2002C71, 0x01
    TMCFlagGroup.ROLF_ROMEO_DOG_FUSIONS_OFFERED: 0xFF1232,  # 0x2002C72, 0x01
    TMCFlagGroup.GROWLER_WEST_DOG_FUSIONS_OFFERED: 0xFF1233,  # 0x2002C73, 0x01
    TMCFlagGroup.SCRATCHER_JULIET_CAT_FUSIONS_OFFERED: 0xFF1234,  # 0x2002C74, 0x01
    TMCFlagGroup.PURRY_BRIDGE_CAT_FUSIONS_OFFERED: 0xFF1235,  # 0x2002C75, 0x01
    TMCFlagGroup.ROOF_CUCCO_FUSIONS_OFFERED: 0xFF1236,  # 0x2002C76, 0x01
    TMCFlagGroup.CUCCO_CHICK_FUSIONS_OFFERED: 0xFF1237,  # 0x2002C77, 0x01
    TMCFlagGroup.ELSIE_LONLON_COW_FUSIONS_OFFERED: 0xFF1238,  # 0x2002C78, 0x01

    TMCFlagGroup.COMPLETED_FUSIONS: 0xFF1241,  # 0x2002C81, 0x0D
    TMCFlagGroup.FUSION_MAP_ICON_FLAGS: 0xFF124F,  # 0x2002C8F, 0x0C

    TMCFlagGroup.GLOBAL_FLAGS: 0xFF125C,  # 0x2002C9C, 0x0D
    TMCFlagGroup.UNUSED_DUNGEON_FLAGS: 0xFF1271,  # 0x2002CB1, 0x02
    TMCFlagGroup.REPEATING_SIMON_SIMULATION_FLAG: 0xFF1274,  # 0x2002CB4, 0x01
    TMCFlagGroup.OVERWORLD_FLAGS: 0xFF127C,  # 0x2002CBC, 0x59
    TMCFlagGroup.OVERWORLD_CAVE_FLAGS: 0xFF12DC,  # 0x2002D1C, 0x11
    TMCFlagGroup.DWS_FLAGS: 0xFF12FC,  # 0x2002D3C, 0x0B
    TMCFlagGroup.COF_FLAGS: 0xFF1314,  # 0x2002D54, 0x09
    TMCFlagGroup.FOW_FLAGS: 0xFF132C,  # 0x2002D6C, 0x0A
    TMCFlagGroup.TOD_FLAGS: 0xFF1344,  # 0x2002D84, 0x14
    TMCFlagGroup.POW_FLAGS: 0xFF135C,  # 0x2002D9C, 0x11
    TMCFlagGroup.DHC_FLAGS: 0xFF1374,  # 0x2002DB4, 0x13

    TMCFlagGroup.UNUSED_D1_SMALL_KEYS: 0xFF145C,  # 0x2002E9C, 0x01
    TMCFlagGroup.DWS_SMALL_KEYS: 0xFF145D,  # 0x2002E9D, 0x01
    TMCFlagGroup.COF_SMALL_KEYS: 0xFF145E,  # 0x2002E9E, 0x01
    TMCFlagGroup.FOW_SMALL_KEYS: 0xFF145F,  # 0x2002E9F, 0x01
    TMCFlagGroup.TOD_SMALL_KEYS: 0xFF1460,  # 0x2002EA0, 0x01
    TMCFlagGroup.POW_SMALL_KEYS: 0xFF1461,  # 0x2002EA1, 0x01
    TMCFlagGroup.DHC_SMALL_KEYS: 0xFF1462,  # 0x2002EA2, 0x01
    TMCFlagGroup.RC_SMALL_KEYS: 0xFF1463,  # 0x2002EA3, 0x01
    TMCFlagGroup.UNUSED_D2_SMALL_KEYS: 0xFF1464,  # 0x2002EA4, 0x01

    TMCFlagGroup.UNUSED_D1_DUNGEON_ITEMS: 0xFF146C,  # 0x2002EAC, 0x01
    TMCFlagGroup.DWS_DUNGEON_ITEMS: 0xFF146D,  # 0x2002EAD, 0x01
    TMCFlagGroup.COF_DUNGEON_ITEMS: 0xFF146E,  # 0x2002EAE, 0x01
    TMCFlagGroup.FOW_DUNGEON_ITEMS: 0xFF146F,  # 0x2002EAF, 0x01
    TMCFlagGroup.TOD_DUNGEON_ITEMS: 0xFF1470,  # 0x2002EB0, 0x01
    TMCFlagGroup.POW_DUNGEON_ITEMS: 0xFF1471,  # 0x2002EB1, 0x01
    TMCFlagGroup.DHC_DUNGEON_ITEMS: 0xFF1472,  # 0x2002EB2, 0x01
    TMCFlagGroup.UNUSED_RC_DUNGEON_ITEMS: 0xFF1473,  # 0x2002EB3, 0x01
    TMCFlagGroup.UNUSED_D2_DUNGEON_ITEMS: 0xFF1474,  # 0x2002EB4, 0x01

    TMCFlagGroup.UNUSED_D1_WARPS: 0xFF147C,  # 0x2002EBC, 0x01
    TMCFlagGroup.DWS_WARPS: 0xFF147D,  # 0x2002EBD, 0x01
    TMCFlagGroup.COF_WARPS: 0xFF147E,  # 0x2002EBE, 0x01
    TMCFlagGroup.FOW_WARPS: 0xFF147F,  # 0x2002EBF, 0x01
    TMCFlagGroup.TOD_WARPS: 0xFF1480,  # 0x2002EC0, 0x01
    TMCFlagGroup.POW_WARPS: 0xFF1481,  # 0x2002EC1, 0x01
    TMCFlagGroup.DHC_WARPS: 0xFF1482,  # 0x2002EC2, 0x01
    TMCFlagGroup.UNUSED_RC_WARPS: 0xFF1483,  # 0x2002EC3, 0x01
    TMCFlagGroup.UNUSED_D2_WARPS: 0xFF1484,  # 0x2002EC4, 0x01

    TMCFlagGroup.VAATI_DARKNUT_TIMER: 0xFF148C,  # 0x2002ECC, 0x04
    TMCFlagGroup.STORED_KILL_COUNTER_FOR_PICO_BLOOMS: 0xFF1490,  # 0x2002ED0, 0x04
    TMCFlagGroup.BIGGORON_SHIELD_TIMER: 0xFF1494,  # 0x2002ED4, 0x04
    TMCFlagGroup.VAATI_3_EZLO_CANE_HINT_TIMERUS: 0xFF1498,  # 0x2002ED8, 0x04
    TMCFlagGroup.KIOSK_DEMO_TIMER: 0xFF14A8,  # 0x2002EE8, 0x04
}

WIND_CRESTS: dict[str, ROMData] = {
    # 0x2A83
    TMCEvent.CRENEL_CREST: ROMData(flag_group_by_name[TMCFlagGroup.WIND_CRESTS], 0x01),
    TMCEvent.FALLS_CREST: ROMData(flag_group_by_name[TMCFlagGroup.WIND_CRESTS], 0x02),
    TMCEvent.CLOUDS_CREST: ROMData(flag_group_by_name[TMCFlagGroup.WIND_CRESTS], 0x04),
    TMCEvent.TOWN_CREST: ROMData(flag_group_by_name[TMCFlagGroup.WIND_CRESTS], 0x08),
    TMCEvent.LAKE_CREST: ROMData(flag_group_by_name[TMCFlagGroup.WIND_CRESTS], 0x10),
    TMCEvent.SWAMP_CREST: ROMData(flag_group_by_name[TMCFlagGroup.WIND_CRESTS], 0x20),
    TMCEvent.SHF_CREST: ROMData(flag_group_by_name[TMCFlagGroup.WIND_CRESTS], 0x40),
    TMCEvent.MINISH_CREST: ROMData(flag_group_by_name[TMCFlagGroup.WIND_CRESTS], 0x80),
}

GLOBAL_FLAGS: dict[str, ROMData] = {
    # 0x2C9C
    TMCEvent.SIMON_CHEST_OPEN: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS], 0x02),
    TMCEvent.DEFEAT_GREEN_CHU: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS], 0x04),
    TMCEvent.DEFEAT_GLEEROK: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS], 0x08),
    TMCEvent.DEFEAT_MAZAAL: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS], 0x10),
    TMCEvent.DEFEAT_OCTO: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS], 0x20),
    TMCEvent.DEFEAT_GYORG: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS], 0x40),
    # 0x2C9D
    # 0x2C9E
    TMCEvent.TOWN_SUCK_DUST: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 2, 0x04),
    TMCEvent.MET_ZELDA: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 2, 0x08),
    TMCEvent.HAVE_EZLO: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 2, 0x10),
    TMCEvent.INTRO_THRONE_CUTSCENE: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 2, 0x20),
    TMCEvent.DEEPWOOD_SUCKED_BARREL_WEB: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 2, 0x80),
    # 0x2C9F
    TMCEvent.TOWN_RED_HOUSE: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 3, 0x01),
    TMCEvent.TOWN_RED_HOUSE_FRAME: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 3, 0x02),
    TMCEvent.CRENEL_HOLDING_BEAN: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 3, 0x04),
    TMCEvent.CRENEL_PLACED_BEAN: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 3, 0x08),
    TMCEvent.ZELDA_FOLLOWS: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 3, 0x10),
    TMCEvent.TALON_LLR_KEY: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 3, 0x20),
    TMCEvent.EARLY_BOOTS_FLAG: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 3, 0x40),
    TMCEvent.DR_LEFT_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 3, 0x80),
    # 0x2CA0
    TMCEvent.GRAVEYARD_KEY_LOST: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 4, 0x01),
    TMCEvent.GRAVEYARD_KEY_FOUND: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 4, 0x02),
    TMCEvent.VEIL_FALLS_TORNADO: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 4, 0x08),
    TMCEvent.CLOUD_TOPS_TORNADO: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 4, 0x10),
    # 0x2CA1
    TMCEvent.BOOK_QUEST_START: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 5, 0x02),
    TMCEvent.GREEN_BOOK_FALL: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 5, 0x04),
    TMCEvent.RENTED_HOUSE_DIN: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 5, 0x08),
    TMCEvent.RENTED_HOUSE_NAYRU: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 5, 0x10),
    TMCEvent.RENTED_HOUSE_FARORE: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 5, 0x20),
    TMCEvent.NEW_HOUSE_DIN: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 5, 0x40),
    TMCEvent.NEW_HOUSE_NAYRU: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 5, 0x80),
    # 0x2CA2
    TMCEvent.NEW_HOUSE_FARORE: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 6, 0x01),
    TMCEvent.DEFEATED_RUINS_GOLDEN_OCTO: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 6, 0x02),
    TMCEvent.DEFEATED_CRENELBASE_GOLDEN_TEKTITE: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 6, 0x04),
    TMCEvent.DEFEATED_SWAMP_GOLDEN_ROPE: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 6, 0x08),
    TMCEvent.DEFEATED_HILLS_GOLDEN_ROPE: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 6, 0x10),
    TMCEvent.DEFEATED_GARDEN_GOLDEN_ROPE: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 6, 0x20),
    TMCEvent.DEFEATED_FALLS_GOLDEN_TEKTITE: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 6, 0x40),
    TMCEvent.DEFEATED_CRENEL_GOLDEN_TEKTITE: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 6, 0x80),
    # 0x2CA3
    TMCEvent.DEFEATED_MINISH_GOLDEN_OCTO: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 7, 0x01),
    TMCEvent.DEFEATED_WESTERN_GOLDEN_OCTO: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 7, 0x02),
    TMCEvent.FUSIONS_COMPLETE: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 7, 0x04),
    TMCEvent.YELLOW_PICO_BLOOM: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 7, 0x08),
    TMCEvent.BLUE_PICO_BLOOM: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 7, 0x10),
    TMCEvent.ORANGE_PICO_BLOOM: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 7, 0x20),
    TMCEvent.GORON_MERCHANT_RESTOCK_LV2: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 7, 0x40),
    TMCEvent.GORON_MERCHANT_RESTOCK_LV3: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 7, 0x80),
    # 0x2CA4
    TMCEvent.GORON_MERCHANT_RESTOCK_LV4: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 8, 0x01),
    TMCEvent.GORON_MERCHANT_RESTOCK_LV5: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 8, 0x02),
    TMCEvent.GORON_MERCHANT_SOLD_L: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 8, 0x04),
    TMCEvent.GORON_MERCHANT_SOLD_M: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 8, 0x08),
    TMCEvent.GORON_MERCHANT_SOLD_R: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 8, 0x10),
    TMCEvent.CASTLE_BASEMENT_DOOR_OPEN: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 8, 0x20),
    TMCEvent.GORMAN_RENTED_HOUSE: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 8, 0x80),
    # 0x2CA5
    TMCEvent.GORMAN_NEW_HOUSE: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 9, 0x01),
    TMCEvent.OUTDOOR: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 9, 0x02),
    TMCEvent.FOUNTAIN_BLUE_MINISH: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 9, 0x04),
    TMCEvent.CUCCO_LV_BIT0: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 9, 0x08),
    TMCEvent.CUCCO_LV_BIT1: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 9, 0x10),
    TMCEvent.CUCCO_LV_BIT2: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 9, 0x20),
    TMCEvent.CUCCO_LV_BIT3: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 9, 0x40),
    TMCEvent.CUCCO_HEART: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 9, 0x80),
    # 0x2CA6
    TMCEvent.SIMON_WAKEUP: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xA, 0x01),
    TMCEvent.ENDING: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xA, 0x02),
    TMCEvent.EZLO_OCARINA: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xA, 0x04),
    TMCEvent.EZLO_CREST: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xA, 0x08),
    TMCEvent.PICO_BLOOM_ITEM: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xA, 0x10),
    TMCEvent.GAMECLEAR: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xA, 0x20),
    TMCEvent.MELARI_MOVE: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xA, 0x40),
    TMCEvent.NORTH_FIELD_LADDER_SPAWN: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xA, 0x80),
    # 0x2CA7
    TMCEvent.WIND_TRIBE_STATE: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xB, 0x01),
    TMCEvent.FIGURINE_COMPLETE: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xB, 0x02),
    TMCEvent.SCRUB_BOTTLE: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xB, 0x04),
    TMCEvent.DOGFOOD_USE: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xB, 0x08),
    TMCEvent.TINGLE_SPAWN: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xB, 0x10),
    TMCEvent.SANCTUARY_BGM: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xB, 0x20),
    TMCEvent.PORTAL_STUMP: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xB, 0x40),
    TMCEvent.PORTAL_ROCK: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xB, 0x80),
    # 0x2CA8
    TMCEvent.PORTAL_POT: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xC, 0x01),
    TMCEvent.BOOK_QUEST_RECEPTIONIST: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xC, 0x02),
    TMCEvent.MAZE_CLEAR: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xC, 0x04),
    TMCEvent.EZLO_COF: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xC, 0x08),
    TMCEvent.CASTLE_BGM: ROMData(flag_group_by_name[TMCFlagGroup.GLOBAL_FLAGS] + 0xC, 0x10),
}

UNUSED_DUNGEON_FLAGS: dict[str, ROMData] = {
    # 0x2CB1
    TMCEvent.UNUSED_DUNGEON_DOOR_1: ROMData(flag_group_by_name[TMCFlagGroup.UNUSED_DUNGEON_FLAGS], 0x40),
    TMCEvent.UNUSED_DUNGEON_DOOR_2L: ROMData(flag_group_by_name[TMCFlagGroup.UNUSED_DUNGEON_FLAGS], 0x80),
    # 0x2CB2
    TMCEvent.UNUSED_DUNGEON_DOOR_2R: ROMData(flag_group_by_name[TMCFlagGroup.UNUSED_DUNGEON_FLAGS] + 1, 0x01),
    TMCEvent.UNUSED_DUNGEON_DOOR_3: ROMData(flag_group_by_name[TMCFlagGroup.UNUSED_DUNGEON_FLAGS] + 1, 0x02),
}

REPEATING_SIMON_SIMULATION_FLAG: dict[str, ROMData] = {
    # 0x2CB4
    TMCEvent.SIMON_REPEAT: ROMData(flag_group_by_name[TMCFlagGroup.REPEATING_SIMON_SIMULATION_FLAG], 0x40),
}

OVERWORLD_FLAGS: dict[str, ROMData] = {
    # 0x2CBC
    TMCEvent.EZLO_DWS_CLEAR: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS], 0x02),
    TMCEvent.EZLO_COF_CLEAR: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS], 0x04),
    TMCEvent.EZLO_FOW_CLEAR: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS], 0x08),
    TMCEvent.EZLO_TOD_CLEAR: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS], 0x10),
    TMCEvent.EZLO_POW_CLEAR: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS], 0x20),
    TMCEvent.LAKE_BONK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS], 0x40),
    TMCEvent.LAKE_BOULDER: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS], 0x80),
    # 0x2CBD
    TMCEvent.LAKE_NORTH_HEART: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 1, 0x01),
    TMCEvent.LAKE_POND_HEART: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 1, 0x02),
    TMCEvent.LAKE_SOUTH_HEART: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 1, 0x04),
    TMCEvent.SWAMP_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 1, 0x10),
    TMCEvent.GARDEN_CASTLE_LADDER: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 1, 0x20),
    TMCEvent.GARDEN_DOJO_LADDER: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 1, 0x80),
    # 0x2CBE
    TMCEvent.CASTLE_BONK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 2, 0x01),
    TMCEvent.GUARD_CAPTURE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 2, 0x02),
    TMCEvent.GARDEN_WATER_CHEST_LEFT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 2, 0x04),
    TMCEvent.GARDEN_WATER_CHEST_RIGHT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 2, 0x08),
    TMCEvent.EZLO_GARDEN: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 2, 0x10),
    TMCEvent.EZLO_SANCTUARY: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 2, 0x20),
    TMCEvent.SWAMP_BOULDER_MIDDLE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 2, 0x40),
    TMCEvent.SWAMP_BOULDER_SOUTH: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 2, 0x80),
    # 0x2CBF
    TMCEvent.EZLO_SWAMP_0: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 3, 0x08),
    TMCEvent.EZLO_SWAMP_1: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 3, 0x10),
    TMCEvent.EZLO_SWAMP_2: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 3, 0x20),
    TMCEvent.SWAMP_RUINS_BLOCK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 3, 0x40),
    TMCEvent.SWAMP_BOULDER_NORTH: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 3, 0x80),
    # 0x2CC0
    TMCEvent.SWAMP_GRAVE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 4, 0x01),
    TMCEvent.SWAMP_WATER_TOP: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 4, 0x04),
    TMCEvent.SWAMP_WATER_MIDDLE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 4, 0x08),
    TMCEvent.SWAMP_WATER_BOTTOM: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 4, 0x10),
    TMCEvent.RUINS_ENTER: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 4, 0x20),
    TMCEvent.RUINS_BOULDER_1: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 4, 0x40),
    TMCEvent.RUINS_BOMBWALL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 4, 0x80),
    # 0x2CC1
    TMCEvent.RUINS_TEKTITE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 5, 0x01),
    TMCEvent.RUINS_BOULDER_2: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 5, 0x08),
    TMCEvent.RUINS_GRASS_TOP: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 5, 0x10),
    TMCEvent.RUINS_GRASS_MIDDLE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 5, 0x20),
    TMCEvent.RUINS_GRASS_LEFT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 5, 0x40),
    TMCEvent.RUINS_GRASS_RIGHT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 5, 0x80),
    # 0x2CC2
    TMCEvent.RUINS_GRASS_BOTTOM: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 6, 0x01),
    TMCEvent.RUINS_ARMOS: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 6, 0x02),
    TMCEvent.RUINS_BEETLES: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 6, 0x04),
    TMCEvent.RUINS_ARMOS_CHEST_LEFT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 6, 0x08),
    TMCEvent.RUINS_ARMOS_CHEST_RIGHT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 6, 0x10),
    TMCEvent.UNUSED_MINISH_LEFT_ROCK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 6, 0x20),
    TMCEvent.UNUSED_MINISH_RIGHT_ROCK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 6, 0x40),
    TMCEvent.MINISH_LEFT_ROCK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 6, 0x80),
    # 0x2CC3
    TMCEvent.MINISH_MIDDLE_ROCK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 7, 0x01),
    TMCEvent.MINISH_RIGHT_ROCK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 7, 0x02),
    TMCEvent.EZLO_MINISH_PORTAL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 7, 0x04),
    TMCEvent.MINISH_NORTH_HEART: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 7, 0x08),
    TMCEvent.MINISH_SOUTH_HEART: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 7, 0x10),
    TMCEvent.EZLO_MINISH_SHRINK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 7, 0x20),
    TMCEvent.CRENEL_RAIN_BOULDER_BOTTOM: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 7, 0x40),
    TMCEvent.CRENEL_RAIN_BOULDER_TOP: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 7, 0x80),
    # 0x2CC4
    TMCEvent.CRENEL_WALL_BOMBWALL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 8, 0x01),
    TMCEvent.CRENEL_SCRUB_BOMBWALL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 8, 0x02),
    TMCEvent.CRENEL_FAIRY_HP_BOMBWALL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 8, 0x04),
    TMCEvent.CRENEL_MUSHROOM_BOMBWALL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 8, 0x08),
    TMCEvent.CRENEL_BASE_HP_BOMBWALL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 8, 0x10),
    TMCEvent.UNUSED_CRENEL_BASE_TILE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 8, 0x20),
    TMCEvent.UNUSED_CRENEL_WALL_TILE_BOTTOM: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 8, 0x40),
    TMCEvent.UNUSED_CRENEL_WALL_TILE_TOP: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 8, 0x80),
    # 0x2CC5
    TMCEvent.EZLO_CRENEL_TORNADO: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 9, 0x01),
    TMCEvent.CRENEL_BASE_RUPEE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 9, 0x02),
    TMCEvent.CRENEL_BASE_SPRING_ROCK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 9, 0x08),
    TMCEvent.CRENEL_BASE_GREEN_BEAN: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 9, 0x10),
    TMCEvent.CRENEL_BASE_BLUE_BEAN: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 9, 0x20),
    TMCEvent.CRENEL_BASE_FAIRY_BOMBWALL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 9, 0x40),
    TMCEvent.CRENEL_BASE_MIDDLE_BOMBWALL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 9, 0x80),
    # 0x2CC6
    TMCEvent.CRENEL_BASE_SPRING_BOMBWALL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0A, 0x01),
    TMCEvent.CRENEL_BASE_PORTAL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0A, 0x02),
    TMCEvent.CRENEL_BASE_HOLE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0A, 0x04),
    TMCEvent.CRENEL_BASE_SCRUB_BOMBWALL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0A, 0x08),
    TMCEvent.VALLEY_CRYPT_ENTRANCE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0A, 0x10),
    TMCEvent.VALLEY_GRAVE_RIGHT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0A, 0x20),
    TMCEvent.VALLEY_GRAVE_LEFT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0A, 0x40),
    TMCEvent.VALLEY_GRAVE_MIDDLE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0A, 0x80),
    # 0x2CC7
    TMCEvent.EZLO_VALLEY: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0B, 0x01),
    TMCEvent.VALLEY_BOMBWALL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0B, 0x02),
    TMCEvent.VALLEY_SECRET_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0B, 0x04),
    TMCEvent.EZLO_VALLEY_KEY: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0B, 0x08),
    TMCEvent.SOUTH_FIELD_WEST_TREE_TOP: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0B, 0x10),
    TMCEvent.SOUTH_FIELD_WEST_TREE_MIDDLE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0B, 0x20),
    TMCEvent.SOUTH_FIELD_WEST_TREE_BOTTOM: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0B, 0x40),
    TMCEvent.SOUTH_FIELD_SOUTHWEST_TREE_TOP: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0B, 0x80),
    # 0x2CC8
    TMCEvent.SOUTH_FIELD_SOUTHWEST_TREE_MIDDLE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0C, 0x01),
    TMCEvent.SOUTH_FIELD_SOUTHWEST_TREE_BOTTOM: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0C, 0x02),
    TMCEvent.SOUTH_FIELD_SOUTHEAST_TREE_TOP: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0C, 0x04),
    TMCEvent.SOUTH_FIELD_SOUTHEAST_TREE_MIDDLE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0C, 0x08),
    TMCEvent.SOUTH_FIELD_SOUTHEAST_TREE_BOTTOM: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0C, 0x10),
    TMCEvent.SOUTH_FIELD_NORTH_TREE_TOP: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0C, 0x20),
    TMCEvent.SOUTH_FIELD_NORTH_TREE_MIDDLE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0C, 0x40),
    TMCEvent.SOUTH_FIELD_NORTH_TREE_BOTTOM: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0C, 0x80),
    # 0x2CC9
    TMCEvent.SOUTH_FIELD_NORTH_TREE_HIDDEN: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0D, 0x01),
    TMCEvent.SOUTH_FIELD_BOMBWALL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0D, 0x02),
    TMCEvent.SOUTH_FIELD_BONK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0D, 0x04),
    TMCEvent.SOUTH_FIELD_ZELDA_LEAVE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0D, 0x08),
    TMCEvent.SOUTH_HILLS_LEFT_ROCK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0D, 0x10),
    TMCEvent.SOUTH_HILLS_RIGHT_ROCK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0D, 0x20),
    TMCEvent.HILLS_BOMBWALL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0D, 0x40),
    TMCEvent.HILLS_TOP_ROCK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0D, 0x80),
    # 0x2CCA
    TMCEvent.HILLS_LEFT_ROCK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0E, 0x01),
    TMCEvent.HILLS_RIGHT_ROCK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0E, 0x02),
    TMCEvent.HILLS_BOTTOM_ROCK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0E, 0x04),
    TMCEvent.LONLON_TOP_ROCK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0E, 0x08),
    TMCEvent.LONLON_MIDDLE_TOP_ROCK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0E, 0x10),
    TMCEvent.LONLON_MIDDLE_BOTTOM_ROCK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0E, 0x20),
    TMCEvent.LONLON_BOTTOM_ROCK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0E, 0x40),
    TMCEvent.LONLON_GORON_OPEN: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0E, 0x80),
    # 0x2CCB
    TMCEvent.LONLON_BOULDER_NORTH: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0F, 0x01),
    TMCEvent.LONLON_BOULDER_SOUTH: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0F, 0x02),
    TMCEvent.LONLON_BOULDER_GORON: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0F, 0x04),
    TMCEvent.LONLON_BONK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0F, 0x08),
    TMCEvent.LONLON_HEART: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0F, 0x10),
    TMCEvent.LONLON_DIG: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0F, 0x20),
    TMCEvent.EZLO_LONLON: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0F, 0x40),
    TMCEvent.NORTH_FIELD_TREE_TOP: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x0F, 0x80),
    # 0x2CCC
    TMCEvent.NORTH_FIELD_TREE_MIDDLE_TOP: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x10, 0x01),
    TMCEvent.NORTH_FIELD_TREE_MIDDLE_BOTTOM: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x10, 0x02),
    TMCEvent.NORTH_FIELD_TREE_BOTTOM: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x10, 0x04),
    TMCEvent.NORTH_FIELD_EAST_ROCK_LEFT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x10, 0x08),
    TMCEvent.NORTH_FIELD_EAST_ROCK_RIGHT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x10, 0x10),
    TMCEvent.UNUSED_NORTH_FIELD_LEFT_FENCE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x10, 0x20),
    TMCEvent.UNUSED_NORTH_FIELD_RIGHT_FENCE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x10, 0x40),
    TMCEvent.NORTH_FIELD_WEST_ROCK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x10, 0x80),
    # 0x2CCD
    TMCEvent.NORTH_FIELD_MINISH_HOLE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x11, 0x01),
    TMCEvent.NORTH_FIELD_SCRUB: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x11, 0x02),
    TMCEvent.NORTH_FIELD_MOBLINS: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x11, 0x04),
    TMCEvent.NORTH_FIELD_BONK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x11, 0x08),
    TMCEvent.NORTH_FIELD_BRIDGE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x11, 0x10),
    TMCEvent.NORTH_FIELD_DIG: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x11, 0x20),
    TMCEvent.TRILBY_WEST_BOMBWALL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x11, 0x40),
    TMCEvent.TRILBY_EAST_BOMBWALL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x11, 0x80),
    # 0x2CCE
    TMCEvent.TRILBY_BOULDER: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x12, 0x01),
    TMCEvent.WESTERN_BOULDER: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x12, 0x04),
    TMCEvent.WESTERN_DIG_TOP_LEFT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x12, 0x08),
    TMCEvent.WESTERN_DIG_BOTTOM_LEFT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x12, 0x10),
    TMCEvent.WESTERN_DIG_TOP_CENTER: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x12, 0x20),
    TMCEvent.WESTERN_DIG_BOTTOM_CENTER: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x12, 0x40),
    TMCEvent.WESTERN_DIG_TOP_RIGHT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x12, 0x80),
    # 0x2CCF
    TMCEvent.WESTERN_DIG_BOTTOM_RIGHT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x13, 0x01),
    TMCEvent.WESTERN_DIG_LEFT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x13, 0x02),
    TMCEvent.WESTERN_DIG_RIGHT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x13, 0x04),
    TMCEvent.WESTERN_CUTSCENE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x13, 0x08),
    TMCEvent.WESTERN_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x13, 0x10),
    TMCEvent.CASTLE_WAKE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x13, 0x40),
    TMCEvent.CASTLE_MAID: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x13, 0x80),
    # 0x2CD0
    TMCEvent.FALLS_HEART: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x14, 0x01),
    TMCEvent.FALLS_CLIFF_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x14, 0x02),
    TMCEvent.LOWER_FALLS_RUPEE_TOP: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x14, 0x04),
    TMCEvent.LOWER_FALLS_RUPEE_LEFT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x14, 0x08),
    TMCEvent.LOWER_FALLS_RUPEE_RIGHT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x14, 0x10),
    TMCEvent.EZLO_FALLS: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x14, 0x20),
    TMCEvent.FALLS_DIG_TOP: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x14, 0x80),
    # 0x2CD1
    TMCEvent.LOWER_FALLS_HEART: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x15, 0x02),
    TMCEvent.EZLO_FALLS_TOP: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x15, 0x04),
    TMCEvent.BIGGORON_SHIELD: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x15, 0x08),
    TMCEvent.BIGGORON_EATING: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x15, 0x10),
    TMCEvent.CRENEL_BEANSTALK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x15, 0x20),
    TMCEvent.LAKE_BEANSTALK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x15, 0x40),
    TMCEvent.RUINS_BEANSTALK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x15, 0x80),
    # 0x2CD2
    TMCEvent.HILLS_BEANSTALK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x16, 0x01),
    TMCEvent.WESTERN_BEANSTALK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x16, 0x02),
    TMCEvent.HILLS_FUSION_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x16, 0x04),
    TMCEvent.MINISH_WEST_FUSION_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x16, 0x08),
    TMCEvent.RUINS_NEAR_FOW_FUSION_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x16, 0x10),
    TMCEvent.MINISH_EAST_FUSION_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x16, 0x20),
    TMCEvent.TRILBY_TOP_FUSION_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x16, 0x40),
    TMCEvent.MINISH_SOUTH_FUSION_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x16, 0x80),
    # 0x2CD3
    TMCEvent.MINISH_NORTH_FUSION_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x17, 0x01),
    TMCEvent.SOUTH_FIELD_FUSION_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x17, 0x02),
    TMCEvent.VALLEY_LEFT_FUSION_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x17, 0x04),
    TMCEvent.VALLEY_RIGHT_FUSION_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x17, 0x08),
    TMCEvent.TRILBY_MIDDLE_FUSION_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x17, 0x10),
    TMCEvent.PRE_VALLEY_FUSION_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x17, 0x20),
    TMCEvent.LOWER_FALLS_FUSION_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x17, 0x40),
    TMCEvent.FALLS_FUSION_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x17, 0x80),
    # 0x2CD4
    TMCEvent.CRENEL_FUSION_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x18, 0x01),
    TMCEvent.CRENEL_BASE_FUSION_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x18, 0x02),
    TMCEvent.RUINS_PILLARS_FUSION_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x18, 0x04),
    TMCEvent.TOWN_GUARD_TALK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x18, 0x10),
    TMCEvent.TOWN_LIBRARY_PORTAL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x18, 0x20),
    TMCEvent.TOWN_SCHOOL_ROOF_PORTAL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x18, 0x40),
    TMCEvent.TOWN_BOX: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x18, 0x80),
    # 0x2CD5
    TMCEvent.TOWN_INN_LEDGE_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x19, 0x01),
    TMCEvent.TOWN_SCHOOL_ROOF_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x19, 0x02),
    TMCEvent.TOWN_INTRO: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x19, 0x04),
    TMCEvent.TOWN_WEST_GUARD: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x19, 0x08),
    TMCEvent.TOWN_DOG: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x19, 0x10),
    TMCEvent.TOWN_BELL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x19, 0x20),
    TMCEvent.TOWN_MUSIC_HOUSE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x19, 0x40),
    TMCEvent.TOWN_GOSSIP_1: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x19, 0x80),
    # 0x2CD6
    TMCEvent.TOWN_GOSSIP_2: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1A, 0x01),
    TMCEvent.TOWN_TALK_FOUNTAIN_1: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1A, 0x02),
    TMCEvent.TOWN_TALK_FOUNTAIN_2: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1A, 0x04),
    TMCEvent.TOWN_TALK_GUY_2: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1A, 0x08),
    TMCEvent.TOWN_TALK_GUY_4: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1A, 0x10),
    TMCEvent.TOWN_TALK_GUY_5: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1A, 0x20),
    TMCEvent.TOWN_CAFE_LADY_NPC: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1A, 0x40),
    TMCEvent.TOWN_HERB: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1A, 0x80),
    # 0x2CD7
    TMCEvent.TOWN_DOG_HUMAN: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1B, 0x01),
    TMCEvent.EZLO_CLOUDS_TOWER: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1B, 0x02),
    TMCEvent.UNUSED_EZLO_CLOUDS: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1B, 0x04),
    TMCEvent.CLOUDS_FREE_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1B, 0x08),
    TMCEvent.CLOUDS_SOUTH_MIDDLE_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1B, 0x10),
    TMCEvent.CLOUDS_NORTH_WEST_BOTTOM_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1B, 0x20),
    TMCEvent.CLOUDS_NORTH_WEST_LEFT_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1B, 0x40),
    TMCEvent.CLOUDS_NORTH_WEST_RIGHT_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1B, 0x80),
    # 0x2CD8
    TMCEvent.CLOUDS_SOUTH_LEFT_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1C, 0x01),
    TMCEvent.CLOUDS_SOUTH_RIGHT_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1C, 0x02),
    TMCEvent.CLOUDS_NORTH_WEST_DIG_SPOT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1C, 0x04),
    TMCEvent.CLOUDS_NORTH_EAST_DIG_SPOT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1C, 0x08),
    TMCEvent.CLOUDS_SOUTH_MIDDLE_DIG_SPOT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1C, 0x10),
    TMCEvent.CLOUDS_SOUTH_EAST_TOP_DIG_SPOT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1C, 0x20),
    TMCEvent.CLOUDS_SOUTH_LEFT_DIG_SPOT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1C, 0x40),
    TMCEvent.CLOUDS_SOUTH_RIGHT_DIG_SPOT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1C, 0x80),
    # 0x2CD9
    TMCEvent.CLOUDS_SOUTH_EAST_BOTTOM_DIG_SPOT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1D, 0x01),
    TMCEvent.EZLO_CLOUDS_ENTER: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1D, 0x04),
    TMCEvent.CLOUDS_PINWHEEL_TOP_RIGHT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1D, 0x08),
    TMCEvent.CLOUDS_PINWHEEL_BOTTOM_LEFT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1D, 0x10),
    TMCEvent.CLOUDS_PINWHEEL_TOP_LEFT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1D, 0x20),
    TMCEvent.CLOUDS_PINWHEEL_MIDDLE: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1D, 0x40),
    TMCEvent.CLOUDS_PINWHEEL_BOTTOM_RIGHT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1D, 0x80),
    # 0x2CDA
    TMCEvent.CLOUDS_NORTH_KILL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1E, 0x01),
    TMCEvent.CLOUDS_NORTH_COLLECT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1E, 0x02),
    TMCEvent.CLOUDS_SOUTH_KILL: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1E, 0x04),
    TMCEvent.CLOUDS_SOUTH_COLLECT: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1E, 0x08),
    TMCEvent.CLOUDS_GALE_TALK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1E, 0x10),
    TMCEvent.CLOUDS_HAILEY_TALK: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1E, 0x20),
    TMCEvent.FALLS_DIG_BOTTOM: ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1E, 0x80),
    # 0x2CDB
    TMCEvent.EZLO_CRENEL_MINISH:
        ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1F, 0x01),
    TMCEvent.RUINS_ARMOS_CAMERA:
        ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1F, 0x02),
    TMCEvent.RUINS_BEETLES_CAMERA:
        ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1F, 0x04),
    TMCEvent.MINISH_WOODS_POST_VILLAGE_FUSION_CHEST:
        ROMData(flag_group_by_name[TMCFlagGroup.OVERWORLD_FLAGS] + 0x1F, 0x08),
}

DWS_FLAGS: dict[str, ROMData] = {
    # 0x2D3C
    TMCEvent.UNUSED_DWS_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS], 0x01),
    TMCEvent.DWS_VISIT_00: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS], 0x02),
    TMCEvent.DWS_VISIT_01: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS], 0x04),
    TMCEvent.DWS_VISIT_02: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS], 0x08),
    TMCEvent.DWS_VISIT_03: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS], 0x10),
    TMCEvent.DWS_VISIT_04: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS], 0x20),
    TMCEvent.DWS_VISIT_05: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS], 0x40),
    TMCEvent.DWS_VISIT_06: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS], 0x80),
    # 0x2D3D
    # 0x2D3E
    # 0x2D3F
    TMCEvent.DWS_1F_MADDER_RIGHT_WEB: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS] + 3, 0x02),
    TMCEvent.DWS_1F_MADDER_BOTTOM_WEB: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS] + 3, 0x04),
    TMCEvent.DWS_1F_MADDER_BIG_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS] + 3, 0x08),
    TMCEvent.DWS_1F_BLUE_WARP_SOUTH_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS] + 3, 0x10),
    TMCEvent.DWS_1F_BLUE_WARP_SWITCH: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS] + 3, 0x20),
    TMCEvent.DWS_1F_BLUE_WARP_LEFT_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS] + 3, 0x40),
    TMCEvent.DWS_1F_BLUE_WARP_LEFT_CHEST_SWITCH: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS] + 3, 0x80),
    # 0x2D40
    # 0x2D41
    # 0x2D42
    # 0x2D43
    TMCEvent.DWS_1F_SLUG_TOP_LEFT: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS] + 7, 0x01),
    TMCEvent.DWS_1F_SLUG_BOTTOM_LEFT: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS] + 7, 0x02),
    TMCEvent.DWS_1F_SLUG_TOP_RIGHT: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS] + 7, 0x04),
    TMCEvent.DWS_1F_SLUG_BOTTOM_RIGHT: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS] + 7, 0x08),
    TMCEvent.DWS_1F_SLUG_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS] + 7, 0x10),
    TMCEvent.DWS_1F_SLUG_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS] + 7, 0x20),
    TMCEvent.DWS_B1_RED_WARP_SWITCH: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS] + 7, 0x40),
    TMCEvent.DWS_B1_RED_WARP_BIG_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.DWS_FLAGS] + 7, 0x80),

}
COF_FLAGS: dict[str, ROMData] = {
    # 0x2D54
    TMCEvent.COF_VISIT_00: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS], 0x02),
    TMCEvent.COF_VISIT_01: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS], 0x04),
    TMCEvent.COF_VISIT_02: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS], 0x08),
    TMCEvent.COF_VISIT_03: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS], 0x10),
    TMCEvent.COF_VISIT_04: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS], 0x20),
    TMCEvent.COF_VISIT_05: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS], 0x40),
    TMCEvent.COF_VISIT_06: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS], 0x80),
    # 0x2D55
    TMCEvent.COF_VISIT_07: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 1, 0x01),
    TMCEvent.COF_VISIT_08: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 1, 0x02),
    TMCEvent.COF_VISIT_09: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 1, 0x04),
    TMCEvent.COF_VISIT_10: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 1, 0x08),
    TMCEvent.COF_VISIT_11: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 1, 0x10),
    TMCEvent.COF_VISIT_12: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 1, 0x20),
    TMCEvent.COF_VISIT_13: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 1, 0x40),
    TMCEvent.COF_VISIT_14: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 1, 0x80),
    # 0x2D56
    TMCEvent.COF_VISIT_15: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 2, 0x01),
    TMCEvent.COF_VISIT_16: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 2, 0x02),
    TMCEvent.COF_VISIT_17: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 2, 0x04),
    TMCEvent.COF_VISIT_BOSS: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 2, 0x08),
    TMCEvent.COF_B1_BLUE_WARP_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 2, 0x10),
    TMCEvent.COF_B1_BLUE_WARP_SWITCH: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 2, 0x20),
    TMCEvent.COF_B1_SPINY_CHU_DEFEATED: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 2, 0x40),
    TMCEvent.COF_B1_SPINY_CHU_PILLAR: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 2, 0x80),
    # 0x2D57
    # 0x2D58
    # 0x2D59
    # 0x2D5A
    TMCEvent.COF_B2_SPIKE_TRAP_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 6, 0x01),
    TMCEvent.COF_1F_BEETLES_DEFEATED: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 6, 0x02),
    TMCEvent.COF_1F_BEETLES_BIG_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 6, 0x04),
    TMCEvent.EZLO_COF_BEETLES: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 6, 0x08),
    TMCEvent.COF_1F_BOBOMB_WALL: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 6, 0x10),
    TMCEvent.COF_B2_RED_WARP_SWITCH: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 6, 0x20),
    TMCEvent.COF_B2_BOSS_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 6, 0x40),
    TMCEvent.COF_B2_LAVA_LEFT_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.COF_FLAGS] + 6, 0x80),
}

FOW_FLAGS: dict[str, ROMData] = {
    # 0x2D6C
    TMCEvent.FOW_VISIT_00: ROMData(flag_group_by_name[TMCFlagGroup.FOW_FLAGS], 0x02),
    TMCEvent.FOW_VISIT_01: ROMData(flag_group_by_name[TMCFlagGroup.FOW_FLAGS], 0x04),
    TMCEvent.FOW_VISIT_02: ROMData(flag_group_by_name[TMCFlagGroup.FOW_FLAGS], 0x08),
    TMCEvent.FOW_VISIT_03: ROMData(flag_group_by_name[TMCFlagGroup.FOW_FLAGS], 0x10),
    TMCEvent.FOW_VISIT_04: ROMData(flag_group_by_name[TMCFlagGroup.FOW_FLAGS], 0x20),
    # 0x2D6D
    # 0x2D6E
    # 0x2D6F
    # 0x2D70
    TMCEvent.FOW_3F_RIGHT_LEVER: ROMData(flag_group_by_name[TMCFlagGroup.FOW_FLAGS] + 4, 0x01),
    TMCEvent.FOW_3F_TOP_EYES: ROMData(flag_group_by_name[TMCFlagGroup.FOW_FLAGS] + 4, 0x02),
    TMCEvent.FOW_3F_RIGHT_EYES: ROMData(flag_group_by_name[TMCFlagGroup.FOW_FLAGS] + 4, 0x04),
    TMCEvent.FOW_3F_LEFT_DROPPED: ROMData(flag_group_by_name[TMCFlagGroup.FOW_FLAGS] + 4, 0x08),
    TMCEvent.FOW_3F_LEFT_LEVER: ROMData(flag_group_by_name[TMCFlagGroup.FOW_FLAGS] + 4, 0x10),
    TMCEvent.FOW_RED_WARP_SWITCH: ROMData(flag_group_by_name[TMCFlagGroup.FOW_FLAGS] + 4, 0x20),
    TMCEvent.FOW_BOSS_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.FOW_FLAGS] + 4, 0x40),
    TMCEvent.FOW_DEFEAT_DARKNUT: ROMData(flag_group_by_name[TMCFlagGroup.FOW_FLAGS] + 4, 0x80),
}

TOD_FLAGS: dict[str, ROMData] = {
    # 0x2D84
    TMCEvent.TOD_VISIT_00: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS], 0x02),
    TMCEvent.TOD_VISIT_01: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS], 0x04),
    TMCEvent.TOD_VISIT_02: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS], 0x08),
    TMCEvent.TOD_VISIT_03: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS], 0x10),
    TMCEvent.TOD_VISIT_04: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS], 0x20),
    TMCEvent.TOD_VISIT_05: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS], 0x40),
    TMCEvent.TOD_VISIT_06: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS], 0x80),
    # 0x2D85
    TMCEvent.TOD_VISIT_07: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 1, 0x01),
    TMCEvent.TOD_VISIT_08: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 1, 0x02),
    TMCEvent.TOD_VISIT_09: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 1, 0x04),
    TMCEvent.TOD_VISIT_0A: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 1, 0x08),
    TMCEvent.TOD_VISIT_0B: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 1, 0x10),
    TMCEvent.TOD_VISIT_0C: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 1, 0x20),
    TMCEvent.TOD_VISIT_0D: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 1, 0x40),
    TMCEvent.TOD_VISIT_0E: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 1, 0x80),
    # 0x2D86
    TMCEvent.TOD_VISIT_0F: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 2, 0x01),
    TMCEvent.TOD_VISIT_10: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 2, 0x02),
    TMCEvent.TOD_VISIT_11: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 2, 0x04),
    TMCEvent.TOD_VISIT_20: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 2, 0x08),
    TMCEvent.TOD_VISIT_21: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 2, 0x10),
    TMCEvent.TOD_VISIT_22: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 2, 0x20),
    TMCEvent.TOD_VISIT_23: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 2, 0x40),
    TMCEvent.TOD_VISIT_24: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 2, 0x80),
    # 0x2D87
    TMCEvent.TOD_VISIT_25: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 3, 0x01),
    TMCEvent.TOD_VISIT_26: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 3, 0x02),
    TMCEvent.TOD_VISIT_27: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 3, 0x04),
    TMCEvent.TOD_VISIT_28: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 3, 0x08),
    TMCEvent.TOD_VISIT_29: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 3, 0x10),
    TMCEvent.TOD_VISIT_2A: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 3, 0x20),
    TMCEvent.TOD_VISIT_2B: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 3, 0x40),
    TMCEvent.TOD_VISIT_2C: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 3, 0x80),
    # 0x2D88
    TMCEvent.TOD_VISIT_2D: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 4, 0x01),
    TMCEvent.TOD_VISIT_2E: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 4, 0x02),
    TMCEvent.TOD_VISIT_2F: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 4, 0x04),
    TMCEvent.TOD_VISIT_30: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 4, 0x08),
    TMCEvent.TOD_VISIT_31: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 4, 0x10),
    TMCEvent.TOD_VISIT_32: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 4, 0x20),
    TMCEvent.TOD_VISIT_33: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 4, 0x40),
    TMCEvent.TOD_VISIT_34: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 4, 0x80),
    # 0x2D89
    TMCEvent.TOD_VISIT_35: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 5, 0x01),
    TMCEvent.TOD_INIT_LIGHT: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 5, 0x02),
    TMCEvent.TOD_ENTRANCE_WEST_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 5, 0x04),
    TMCEvent.EZLO_TOD_ENTRANCE: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 5, 0x08),
    TMCEvent.TOD_BOSS_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 5, 0x10),
    TMCEvent.TOD_DEFEAT_SCISSOR_BLUE: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 5, 0x40),
    # 0x2D8A
    # 0x2D8B
    # 0x2D8C
    # 0x2D8D
    # 0x2D8E
    # 0x2D8F
    # 0x2D90
    # 0x2D91
    # 0x2D92
    TMCEvent.TOD_RED_WARP_SWITCH: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 0x0E, 0x01),
    TMCEvent.TOD_RED_WARP_BOMBWALL: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 0x0E, 0x02),
    TMCEvent.TOD_LEFTPATH_B2_GATE1_SWITCH: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 0x0E, 0x04),
    TMCEvent.TOD_LEFTPATH_B2_LILYPAD: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 0x0E, 0x08),
    TMCEvent.TOD_RIGHTPATH_B2_ICE_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 0x0E, 0x10),
    TMCEvent.TOD_RIGHTPATH_B2_ICE_RIGHT: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 0x0E, 0x20),
    TMCEvent.TOD_RIGHTPATH_B2_ICECHEST: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 0x0E, 0x40),
    TMCEvent.TOD_ICEMADDERPILLAR_BIGCHEST: ROMData(flag_group_by_name[TMCFlagGroup.TOD_FLAGS] + 0x0E, 0x80),
}

POW_FLAGS: dict[str, ROMData] = {
    # 0x2D9C
    TMCEvent.POW_VISIT_00: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS], 0x02),
    TMCEvent.POW_VISIT_01: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS], 0x04),
    TMCEvent.POW_VISIT_02: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS], 0x08),
    TMCEvent.POW_VISIT_03: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS], 0x10),
    TMCEvent.POW_VISIT_04: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS], 0x20),
    TMCEvent.POW_VISIT_05: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS], 0x40),
    TMCEvent.POW_VISIT_06: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS], 0x80),
    # 0x2D9D
    # 0x2D9E
    # 0x2D9F
    # 0x2DA0
    # 0x2DA1
    # 0x2DA2
    # 0x2DA3
    # 0x2DA4
    # 0x2DA5
    TMCEvent.POW_2ND_HALF_4F_BLOCK_MAZE_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS] + 9, 0x02),
    TMCEvent.POW_2ND_HALF_4F_FINAL_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS] + 9, 0x04),
    TMCEvent.POW_2ND_HALF_4F_MIDDLE_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS] + 9, 0x08),
    TMCEvent.POW_2ND_HALF_4F_SWITCH_HIT: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS] + 9, 0x10),
    TMCEvent.POW_2ND_HALF_4F_LEFT_TORCH: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS] + 9, 0x20),
    TMCEvent.POW_2ND_HALF_4F_RIGHT_TORCH: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS] + 9, 0x40),
    TMCEvent.POW_2ND_HALF_4F_SWITCH_HIT_CHEST: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS] + 9, 0x80),
    # 0x2DA6
    # 0x2DA7
    # 0x2DA8
    # 0x2DA9
    # 0x2DAA
    # 0x2DAB
    # 0x2DAC
    TMCEvent.POW_2ND_HALF_4F_HEART: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS] + 0x10, 0x01),
    TMCEvent.POW_1ST_HALF_5F_MOBLIN_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS] + 0x10, 0x02),
    TMCEvent.POW_1ST_HALF_5F_ITEM_DROP: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS] + 0x10, 0x04),
    TMCEvent.POW_BLUE_WARP_SWITCH: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS] + 0x10, 0x10),
    TMCEvent.POW_1ST_HALF_2F_BEETLES: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS] + 0x10, 0x20),
    TMCEvent.POW_RED_WARP_SWITCH: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS] + 0x10, 0x40),
    TMCEvent.POW_1ST_HALF_3F_ITEM_DROP: ROMData(flag_group_by_name[TMCFlagGroup.POW_FLAGS] + 0x10, 0x80),
}
DHC_FLAGS: dict[str, ROMData] = {
    # 0x2DB4
    TMCEvent.DHC_VISIT_00: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS], 0x02),
    TMCEvent.DHC_VISIT_01: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS], 0x04),
    TMCEvent.DHC_VISIT_02: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS], 0x08),
    TMCEvent.DHC_VISIT_03: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS], 0x10),
    TMCEvent.DHC_VISIT_04: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS], 0x20),
    TMCEvent.DHC_VISIT_05: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS], 0x40),
    TMCEvent.DHC_VISIT_06: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS], 0x80),
    # 0x2DB5
    # 0x2DB6
    # 0x2DB7
    # 0x2DB8
    # 0x2DB9
    # 0x2DBA
    # 0x2DBB
    # 0x2DBC
    # 0x2DBD
    # 0x2DBE
    # 0x2DBF
    # 0x2DC0
    # 0x2DC1
    # 0x2DC2
    # 0x2DC3
    # 0x2DC4
    TMCEvent.DHC_2F_NW_EYES: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS] + 0x10, 0x01),
    TMCEvent.DHC_B2_JAIL: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS] + 0x10, 0x02),
    TMCEvent.DHC_2F_OUT_BRIDGE_1: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS] + 0x10, 0x04),
    TMCEvent.DHC_2F_OUT_BRIDGE_2: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS] + 0x10, 0x08),
    TMCEvent.EZLO_DHC_SANC: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS] + 0x10, 0x20),
    TMCEvent.DHC_BLUE_WARP_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS] + 0x10, 0x40),
    TMCEvent.DHC_2F_NE_GHINI_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS] + 0x10, 0x80),
    # 0x2DC5
    TMCEvent.DHC_2F_NW_DARKNUT_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS] + 0x11, 0x01),
    TMCEvent.DHC_2F_NE_DARKNUT_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS] + 0x11, 0x02),
    TMCEvent.DHC_2F_SW_DARKNUT_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS] + 0x11, 0x04),
    TMCEvent.DHC_RED_WARP_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS] + 0x11, 0x08),
    TMCEvent.DHC_2F_SE_DARKNUT_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS] + 0x11, 0x10),
    TMCEvent.DHC_2F_SW_GHINI_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS] + 0x11, 0x20),
    TMCEvent.DHC_1F_THRONE_DOOR: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS] + 0x11, 0x40),
    TMCEvent.DHC_B2_CAMERA: ROMData(flag_group_by_name[TMCFlagGroup.DHC_FLAGS] + 0x11, 0x80),
}

DWS_WARPS: dict[str, ROMData] = {
    # 0x2EBD
    TMCEvent.DWS_BLUE_WARP: ROMData(flag_group_by_name[TMCFlagGroup.DWS_WARPS], 0x01),
    TMCEvent.DWS_RED_WARP: ROMData(flag_group_by_name[TMCFlagGroup.DWS_WARPS], 0x02),
}

COF_WARPS: dict[str, ROMData] = {
    # 0x2EBE
    TMCEvent.COF_BLUE_WARP: ROMData(flag_group_by_name[TMCFlagGroup.COF_WARPS], 0x01),
    TMCEvent.COF_RED_WARP: ROMData(flag_group_by_name[TMCFlagGroup.COF_WARPS], 0x02),
}

FOW_WARPS: dict[str, ROMData] = {
    # 0x2EBF
    TMCEvent.FOW_BLUE_WARP: ROMData(flag_group_by_name[TMCFlagGroup.FOW_WARPS], 0x01),
    TMCEvent.FOW_RED_WARP: ROMData(flag_group_by_name[TMCFlagGroup.FOW_WARPS], 0x02),
}

TOD_WARPS: dict[str, ROMData] = {
    # 0x2EA0
    TMCEvent.TOD_BLUE_WARP: ROMData(flag_group_by_name[TMCFlagGroup.TOD_WARPS], 0x01),
    TMCEvent.TOD_RED_WARP: ROMData(flag_group_by_name[TMCFlagGroup.TOD_WARPS], 0x02),
}

POW_WARPS: dict[str, ROMData] = {
    # 0x2EA1
    TMCEvent.POW_BLUE_WARP: ROMData(flag_group_by_name[TMCFlagGroup.POW_WARPS], 0x01),
    TMCEvent.POW_RED_WARP: ROMData(flag_group_by_name[TMCFlagGroup.POW_WARPS], 0x02),
}
DHC_WARPS: dict[str, ROMData] = {
    # 0x2EA2
    TMCEvent.DHC_BLUE_WARP: ROMData(flag_group_by_name[TMCFlagGroup.DHC_WARPS], 0x01),
    TMCEvent.DHC_RED_WARP: ROMData(flag_group_by_name[TMCFlagGroup.DHC_WARPS], 0x02),
}

flag_table_by_name: dict[str, ROMData] = (
        WIND_CRESTS |
        GLOBAL_FLAGS |
        UNUSED_DUNGEON_FLAGS |
        REPEATING_SIMON_SIMULATION_FLAG |
        OVERWORLD_FLAGS |
        DWS_FLAGS |
        COF_FLAGS |
        FOW_FLAGS |
        TOD_FLAGS |
        POW_FLAGS |
        DHC_FLAGS |
        DWS_WARPS |
        COF_WARPS |
        FOW_WARPS |
        TOD_WARPS |
        POW_WARPS |
        DHC_WARPS
)
