from collections.abc import Callable

from BaseClasses import Item, ItemClassification, Location, Region


class MinishCapItem(Item):
    game: str = "The Minish Cap"


class MinishCapLocation(Location):
    game: str = "The Minish Cap"


class MinishCapEvent(Item):
    game: str = "The Minish Cap"


class MinishCapRegion(Region):
    game: str = "The Minish Cap"


class TMCItem:
    INACCESSIBLE = "Inaccessible"
    SMITHS_SWORD = "Smith's Sword"
    WHITE_SWORD_GREEN = "White Sword (Green)"
    WHITE_SWORD_RED = "White Sword (Red)"
    WHITE_SWORD_BLUE = "White Sword (Blue)"
    FOUR_SWORD = "Four Sword"
    BOMB = "Bomb"
    REMOTE_BOMB = "Remote Bomb"
    BOW = "Bow"
    LIGHT_ARROW = "Light Arrow"
    BOOMERANG = "Boomerang"
    MAGIC_BOOMERANG = "Magic Boomerang"
    SHIELD = "Shield"
    MIRROR_SHIELD = "Mirror Shield"
    LANTERN = "Lantern"
    GUST_JAR = "Gust Jar"
    CANE_OF_PACCI = "Cane of Pacci"
    MOLE_MITTS = "Mole Mitts"
    ROCS_CAPE = "Roc's Cape"
    PEGASUS_BOOTS = "Pegasus Boots"
    FIRE_ROD = "Fire Rod"
    OCARINA = "Ocarina"
    BOTTLE = "Bottle (Null)"
    BOTTLE_1 = "Bottle 1"
    BOTTLE_2 = "Bottle 2"
    BOTTLE_3 = "Bottle 3"
    BOTTLE_4 = "Bottle 4"
    EMPTY_BOTTLE = "Bottle (Empty)"
    LON_LON_BUTTER = "Bottle (Lon Lon Butter)"
    LON_LON_MILK = "Bottle (Lon Lon Milk)"
    LON_LON_MILK_HALF = "Bottle (Lon Lon Milk (1/2))"
    RED_POTION = "Bottle (Red Potion)"
    BLUE_POTION = "Bottle (Blue Potion)"
    WATER = "Bottle (Water)"
    MINERAL_WATER = "Bottle (Mineral Water)"
    BOTTLED_FAIRY = "Bottle (Bottled Fairy)"
    RED_PICOLYTE = "Bottle (Red Picolyte)"
    ORANGE_PICOLYTE = "Bottle (Orange Picolyte)"
    YELLOW_PICOLYTE = "Bottle (Yellow Picolyte)"
    GREEN_PICOLYTE = "Bottle (Green Picolyte)"
    BLUE_PICOLYTE = "Bottle (Blue Picolyte)"
    WHITE_PICOLYTE = "Bottle (White Picolyte)"
    NAYRU_CHARM = "Bottle (Nayru Charm)"
    FARORE_CHARM = "Bottle (Farore Charm)"
    DINS_CHARM = "Bottle (Dins Charm)"
    SMITH_SWORD_QUEST = "Smith Sword (Quest)"
    BROKEN_PICORI_BLADE = "Broken Picori Blade"
    DOG_FOOD = "Dog Food"
    LONLON_KEY = "LonLon Key"
    WAKEUP_MUSHROOM = "Wakeup Mushroom"
    RED_BOOK = "Red Book (Hyrulian Bestiary)"
    GREEN_BOOK = "Green Book (Picori Legend)"
    BLUE_BOOK = "Blue Book (History of Masks)"
    GRAVEYARD_KEY = "Graveyard Key"
    TINGLE_TROPHY = "Tingle Trophy"
    CARLOV_MEDAL = "Carlov Medal"
    SHELLS = "Shells"
    EARTH_ELEMENT = "Earth Element"
    FIRE_ELEMENT = "Fire Element"
    WATER_ELEMENT = "Water Element"
    WIND_ELEMENT = "Wind Element"
    GRIP_RING = "Grip Ring"
    POWER_BRACELETS = "Power Bracelets"
    FLIPPERS = "Flippers"
    HYRULE_MAP = "Hyrule Map"
    SPIN_ATTACK = "Spin Attack"
    ROLL_ATTACK = "Roll Attack"
    DASH_ATTACK = "Dash Attack"
    ROCK_BREAKER = "Rock Breaker"
    SWORD_BEAM = "Sword Beam"
    GREATSPIN = "Greatspin"
    DOWNTHRUST = "DownThrust"
    PERIL_BEAM = "Peril Beam"
    RUPEES_1 = "1 Rupee"
    RUPEES_5 = "5 Rupees"
    RUPEES_20 = "20 Rupees"
    RUPEES_50 = "50 Rupees"
    RUPEES_100 = "100 Rupees"
    RUPEES_200 = "200 Rupees"
    JABBER_NUT = "Jabber Nut"
    KINSTONE = "Broken Kinstone (Report Me!)"
    KINSTONE_GOLD_CLOUD = "Kinstone Cloud Tops"
    KINSTONE_GOLD_SWAMP = "Kinstone Swamp"
    KINSTONE_GOLD_FALLS = "Kinstone Falls"
    KINSTONE_RED_W = "Kinstone Red W"
    KINSTONE_RED_ANGLE = "Kinstone Red >"
    KINSTONE_RED_E = "Kinstone Red E"
    KINSTONE_BLUE_L = "Kinstone Blue L"
    KINSTONE_BLUE_6 = "Kinstone Blue 6"
    KINSTONE_GREEN_ANGLE = "Kinstone Green <"
    KINSTONE_GREEN_SQUARE = "Kinstone Green ["
    KINSTONE_GREEN_P = "Kinstone Green P"
    SHELLS_30 = "30 Shells"
    HEART_CONTAINER = "Heart Container"
    HEART_PIECE = "Heart Piece"
    BIG_WALLET = "Big Wallet"
    BOMB_BAG = "Bomb Bag"
    QUIVER = "Quiver"
    KINSTONE_BAG = "Kinstone Bag"
    BRIOCHE = "Brioche"
    CROISSANT = "Croissant"
    PIE = "Pie"
    CAKE = "Cake"
    HEART_REFILL = "Recovery Heart"
    FAIRY_REFILL = "Fairy Refill"
    BOMB_REFILL_5 = "5 Bomb Refill"
    ARROW_REFILL_5 = "5 Arrow Refill"
    BOMB_REFILL_10 = "10 Bomb Refill"
    BOMB_REFILL_30 = "30 Bomb Refill"
    ARROW_REFILL_10 = "10 Arrow Refill"
    ARROW_REFILL_30 = "30 Arrow Refill"
    BOW_BUTTERFLY = "Bow Butterfly"
    DIG_BUTTERFLY = "Dig Butterfly"
    SWIM_BUTTERFLY = "Swim Butterfly"
    FAST_SPIN_SCROLL = "Fast Spin Scroll"
    FAST_SPLIT_SCROLL = "Fast Split Scroll"
    LONG_SPIN = "Long Spin"
    PROGRESSIVE_SWORD = "Progressive Sword"
    PROGRESSIVE_BOMB = "Progressive Bomb"
    PROGRESSIVE_BOW = "Progressive Bow"
    PROGRESSIVE_BOOMERANG = "Progressive Boomerang"
    PROGRESSIVE_SHIELD = "Progressive Shield"
    PROGRESSIVE_SCROLL = "Progressive Spin Scroll"

    TRAP_ICE = "Freeze Trap"
    TRAP_FIRE = "Burn Trap"
    TRAP_ZAP = "Zap Trap"
    TRAP_BOMB = "Bomb Trap"
    TRAP_MONEY = "Rupee Trap"
    TRAP_STINK = "Stink Trap"
    TRAP_ROPE = "Rope Trap"
    TRAP_BAT = "Bat Trap"
    TRAP_LIKE = "LikeLike Trap"
    TRAP_CURSE = "Curse Trap"

    DUNGEON_MAP_DWS = "Dungeon Map (DWS)"
    DUNGEON_MAP_COF = "Dungeon Map (CoF)"
    DUNGEON_MAP_FOW = "Dungeon Map (FoW)"
    DUNGEON_MAP_TOD = "Dungeon Map (ToD)"
    DUNGEON_MAP_POW = "Dungeon Map (PoW)"
    DUNGEON_MAP_DHC = "Dungeon Map (DHC)"

    DUNGEON_COMPASS_DWS = "Dungeon Compass (DWS)"
    DUNGEON_COMPASS_COF = "Dungeon Compass (CoF)"
    DUNGEON_COMPASS_FOW = "Dungeon Compass (FoW)"
    DUNGEON_COMPASS_TOD = "Dungeon Compass (ToD)"
    DUNGEON_COMPASS_POW = "Dungeon Compass (PoW)"
    DUNGEON_COMPASS_DHC = "Dungeon Compass (DHC)"

    BIG_KEY_DWS = "Big Key (DWS)"
    BIG_KEY_COF = "Big Key (CoF)"
    BIG_KEY_FOW = "Big Key (FoW)"
    BIG_KEY_TOD = "Big Key (ToD)"
    BIG_KEY_POW = "Big Key (PoW)"
    BIG_KEY_DHC = "Big Key (DHC)"

    SMALL_KEY_DWS = "Small Key (DWS)"
    SMALL_KEY_COF = "Small Key (CoF)"
    SMALL_KEY_FOW = "Small Key (FoW)"
    SMALL_KEY_TOD = "Small Key (ToD)"
    SMALL_KEY_POW = "Small Key (PoW)"
    SMALL_KEY_DHC = "Small Key (DHC)"
    SMALL_KEY_RC = "Small Key (RC)"


class TMCLocation:
    SMITH_HOUSE_CHEST = "South Field Smith House Chest"
    SMITH_HOUSE_SWORD = "South Field Smith House Left Item"
    SMITH_HOUSE_SHIELD = "South Field Smith House Right Item"
    SOUTH_FIELD_PUDDLE_FUSION_ITEM1 = "South Field Puddle Fusion Item Top Left"
    SOUTH_FIELD_PUDDLE_FUSION_ITEM2 = "South Field Puddle Fusion Item Top Middle Left"
    SOUTH_FIELD_PUDDLE_FUSION_ITEM3 = "South Field Puddle Fusion Item Top Middle"
    SOUTH_FIELD_PUDDLE_FUSION_ITEM4 = "South Field Puddle Fusion Item Top Middle Right"
    SOUTH_FIELD_PUDDLE_FUSION_ITEM5 = "South Field Puddle Fusion Item Top Right"
    SOUTH_FIELD_PUDDLE_FUSION_ITEM6 = "South Field Puddle Fusion Item Center Left"
    SOUTH_FIELD_PUDDLE_FUSION_ITEM7 = "South Field Puddle Fusion Item Center Middle Left"
    SOUTH_FIELD_PUDDLE_FUSION_ITEM8 = "South Field Puddle Fusion Item Center Middle"
    SOUTH_FIELD_PUDDLE_FUSION_ITEM9 = "South Field Puddle Fusion Item Center Middle Right"
    SOUTH_FIELD_PUDDLE_FUSION_ITEM10 = "South Field Puddle Fusion Item Center Right"
    SOUTH_FIELD_PUDDLE_FUSION_ITEM11 = "South Field Puddle Fusion Item Bottom Left"
    SOUTH_FIELD_PUDDLE_FUSION_ITEM12 = "South Field Puddle Fusion Item Bottom Middle Left"
    SOUTH_FIELD_PUDDLE_FUSION_ITEM13 = "South Field Puddle Fusion Item Bottom Middle"
    SOUTH_FIELD_PUDDLE_FUSION_ITEM14 = "South Field Puddle Fusion Item Bottom Middle Right"
    SOUTH_FIELD_PUDDLE_FUSION_ITEM15 = "South Field Puddle Fusion Item Bottom Right"
    SOUTH_FIELD_FUSION_CHEST = "South Field Fusion Chest"
    SOUTH_FIELD_TREE_FUSION_HP = "South Field Tree Fusion Item"
    SOUTH_FIELD_MINISH_SIZE_WATER_HOLE_HP = "South Field Minish Size Water Hole Item"
    SOUTH_FIELD_TINGLE_NPC = "South Field Tingle NPC"
    TOWN_CAFE_LADY_NPC = "Town Cafe Lady NPC"
    TOWN_SHOP_80_ITEM = "Town Shop 80 Item"
    TOWN_SHOP_300_ITEM = "Town Shop 300 Item"
    TOWN_SHOP_600_ITEM = "Town Shop 600 Item"
    TOWN_SHOP_EXTRA_600_ITEM = "Town Shop 600 Item 2"
    TOWN_SHOP_BEHIND_COUNTER_ITEM = "Town Shop Behind Counter Item"
    TOWN_SHOP_ATTIC_CHEST = "Town Shop Attic Chest"
    TOWN_BAKERY_ATTIC_CHEST = "Town Bakery Attic Chest"
    TOWN_INN_BACKDOOR_HP = "Town Inn Backdoor HP"
    TOWN_INN_LEDGE_CHEST = "Town Inn Ledge Chest"
    TOWN_INN_POT = "Town Inn Pot"
    TOWN_WELL_RIGHT_CHEST = "Town Well Right Chest"
    TOWN_GORON_MERCHANT_1_LEFT = "Town Goron Merchant 1 Left"
    TOWN_GORON_MERCHANT_1_MIDDLE = "Town Goron Merchant 1 Middle"
    TOWN_GORON_MERCHANT_1_RIGHT = "Town Goron Merchant 1 Right"
    TOWN_GORON_MERCHANT_2_LEFT = "Town Goron Merchant 2 Left"
    TOWN_GORON_MERCHANT_2_MIDDLE = "Town Goron Merchant 2 Middle"
    TOWN_GORON_MERCHANT_2_RIGHT = "Town Goron Merchant 2 Right"
    TOWN_GORON_MERCHANT_3_LEFT = "Town Goron Merchant 3 Left"
    TOWN_GORON_MERCHANT_3_MIDDLE = "Town Goron Merchant 3 Middle"
    TOWN_GORON_MERCHANT_3_RIGHT = "Town Goron Merchant 3 Right"
    TOWN_GORON_MERCHANT_4_LEFT = "Town Goron Merchant 4 Left"
    TOWN_GORON_MERCHANT_4_MIDDLE = "Town Goron Merchant 4 Middle"
    TOWN_GORON_MERCHANT_4_RIGHT = "Town Goron Merchant 4 Right"
    TOWN_GORON_MERCHANT_5_LEFT = "Town Goron Merchant 5 Left"
    TOWN_GORON_MERCHANT_5_MIDDLE = "Town Goron Merchant 5 Middle"
    TOWN_GORON_MERCHANT_5_RIGHT = "Town Goron Merchant 5 Right"
    TOWN_DOJO_NPC_1 = "Town Dojo NPC Sword"
    TOWN_DOJO_NPC_2 = "Town Dojo NPC Green Sword"
    TOWN_DOJO_NPC_3 = "Town Dojo NPC Boots + Sword"
    TOWN_DOJO_NPC_4 = "Town Dojo NPC Cape + Sword"
    TOWN_WELL_TOP_CHEST = "Town Well Top Chest"
    TOWN_SCHOOL_ROOF_CHEST = "Town School Roof Chest"
    TOWN_SCHOOL_PATH_FUSION_CHEST = "Town School Path Fusion Chest"
    TOWN_SCHOOL_PATH_LEFT_CHEST = "Town School Path Left Chest"
    TOWN_SCHOOL_PATH_MIDDLE_CHEST = "Town School Path Middle Chest"
    TOWN_SCHOOL_PATH_RIGHT_CHEST = "Town School Path Right Chest"
    TOWN_SCHOOL_PATH_HP = "Town School Path HP"
    TOWN_DIGGING_TOP_CHEST = "Town Digging Top Chest"
    TOWN_DIGGING_RIGHT_CHEST = "Town Digging Right Chest"
    TOWN_DIGGING_LEFT_CHEST = "Town Digging Left Chest"
    TOWN_WELL_LEFT_CHEST = "Town Well Left Chest"
    TOWN_BELL_HP = "Town Bell HP"
    TOWN_WATERFALL_FUSION_CHEST = "Town Waterfall Fusion Chest"
    TOWN_CARLOV_NPC = "Town Carlov NPC"
    TOWN_WELL_BOTTOM_CHEST = "Town Well Bottom Chest"
    TOWN_CUCCOS_LV_1_NPC = "Town Cuccos Lv 1"
    TOWN_CUCCOS_LV_2_NPC = "Town Cuccos Lv 2"
    TOWN_CUCCOS_LV_3_NPC = "Town Cuccos Lv 3"
    TOWN_CUCCOS_LV_4_NPC = "Town Cuccos Lv 4"
    TOWN_CUCCOS_LV_5_NPC = "Town Cuccos Lv 5"
    TOWN_CUCCOS_LV_6_NPC = "Town Cuccos Lv 6"
    TOWN_CUCCOS_LV_7_NPC = "Town Cuccos Lv 7"
    TOWN_CUCCOS_LV_8_NPC = "Town Cuccos Lv 8"
    TOWN_CUCCOS_LV_9_NPC = "Town Cuccos Lv 9"
    TOWN_CUCCOS_LV_10_NPC = "Town Cuccos Lv 10"
    TOWN_JULLIETA_ITEM = "Town Jullieta Item"
    TOWN_SIMULATION_CHEST = "Town Simulation Chest"
    TOWN_SHOE_SHOP_NPC = "Town Shoe Shop NPC"
    TOWN_MUSIC_HOUSE_LEFT_CHEST = "Town Music House Left Chest"
    TOWN_MUSIC_HOUSE_MIDDLE_CHEST = "Town Music House Middle Chest"
    TOWN_MUSIC_HOUSE_RIGHT_CHEST = "Town Music House Right Chest"
    TOWN_MUSIC_HOUSE_HP = "Town Music House HP"
    TOWN_WELL_PILLAR_CHEST = "Town Well Pillar Chest"
    TOWN_DR_LEFT_ATTIC_ITEM = "Town Dr Left Attic Item"
    TOWN_FOUNTAIN_BIG_CHEST = "Town Fountain Big Chest"
    TOWN_FOUNTAIN_SMALL_CHEST = "Town Fountain Small Chest"
    TOWN_FOUNTAIN_HP = "Town Fountain HP"
    TOWN_LIBRARY_YELLOW_MINISH_NPC = "Town Library Yellow Minish NPC"
    TOWN_UNDER_LIBRARY_FROZEN_CHEST = "Town Under Library Frozen Chest"
    TOWN_UNDER_LIBRARY_BIG_CHEST = "Town Under Library Big Chest"
    TOWN_UNDER_LIBRARY_UNDERWATER = "Town Under Library Underwater"
    NORTH_FIELD_DIG_SPOT = "North Field Dig Spot"
    NORTH_FIELD_HP = "North Field HP"
    NORTH_FIELD_TREE_FUSION_TOP_LEFT_CHEST = "North Field Tree Fusion Top Left Chest"
    NORTH_FIELD_TREE_FUSION_TOP_RIGHT_CHEST = "North Field Tree Fusion Top Right Chest"
    NORTH_FIELD_TREE_FUSION_BOTTOM_LEFT_CHEST = "North Field Tree Fusion Bottom Left Chest"
    NORTH_FIELD_TREE_FUSION_BOTTOM_RIGHT_CHEST = "North Field Tree Fusion Bottom Right Chest"
    NORTH_FIELD_TREE_FUSION_CENTER_BIG_CHEST = "North Field Tree Fusion Center Big Chest"
    NORTH_FIELD_WATERFALL_FUSION_DOJO_NPC = "North Field Waterfall Fusion Dojo NPC"
    CASTLE_MOAT_LEFT_CHEST = "Castle Moat Left Chest"
    CASTLE_MOAT_RIGHT_CHEST = "Castle Moat Right Chest"
    CASTLE_GOLDEN_ROPE = "Castle Golden Rope"
    CASTLE_RIGHT_FOUNTAIN_FUSION_HP = "Castle Right Fountain Fusion HP"
    CASTLE_DOJO_HP = "Castle Dojo HP"
    CASTLE_DOJO_NPC = "Castle Dojo NPC"
    CASTLE_RIGHT_FOUNTAIN_FUSION_MINISH_HOLE_CHEST = "Castle Right Fountain Fusion Minish Hole Chest"
    CASTLE_LEFT_FOUNTAIN_FUSION_MINISH_HOLE_CHEST = "Castle Left Fountain Fusion Minish Hole Chest"
    DHC_MAIN_ENTRANCE = "Dungeon Entrance in Castle Gardens Main Entrance"
    DHC_SIDE_ENTRANCE = "Dungeon Entrance in Castle Gardens Secret Path"
    HILLS_GOLDEN_ROPE = "Hills Golden Rope"
    HILLS_FUSION_CHEST = "Hills Fusion Chest"
    HILLS_BEANSTALK_FUSION_LEFT_CHEST = "Hills Beanstalk Fusion Left Chest"
    HILLS_BEANSTALK_FUSION_HP = "Hills Beanstalk Fusion HP"
    HILLS_BEANSTALK_FUSION_RIGHT_CHEST = "Hills Beanstalk Fusion Right Chest"
    HILLS_BOMB_CAVE_CHEST = "Hills Bomb Cave Chest"
    MINISH_GREAT_FAIRY_NPC = "Minish Great Fairy NPC"
    HILLS_FARM_DIG_CAVE_ITEM = "Hills Farm Dig Cave Item"
    LON_LON_RANCH_POT = "Lon Lon Ranch Pot"
    LON_LON_PUDDLE_FUSION_BIG_CHEST = "Lon Lon Puddle Fusion Big Chest"
    LON_LON_CAVE_CHEST = "Lon Lon Cave Chest"
    LON_LON_CAVE_SECRET_CHEST = "Lon Lon Cave Secret Chest"
    LON_LON_PATH_FUSION_CHEST = "Lon Lon Path Fusion Chest"
    LON_LON_PATH_HP = "Lon Lon Path HP"
    LON_LON_DIG_SPOT = "Lon Lon Dig Spot"
    LON_LON_NORTH_MINISH_CRACK_CHEST = "Lon Lon North Minish Crack Chest"
    LON_LON_GORON_CAVE_FUSION_SMALL_CHEST = "Lon Lon Goron Cave Fusion Small Chest"
    LON_LON_GORON_CAVE_FUSION_BIG_CHEST = "Lon Lon Goron Cave Fusion Big Chest"
    FALLS_LOWER_LON_LON_FUSION_CHEST = "Falls Lower Lon Lon Fusion Chest"
    FALLS_LOWER_HP = "Falls Lower HP"
    FALLS_LOWER_WATERFALL_FUSION_DOJO_NPC = "Falls Lower Waterfall Fusion Dojo NPC"
    FALLS_LOWER_ROCK_ITEM1 = "Falls Lower Rock Item1"
    FALLS_LOWER_ROCK_ITEM2 = "Falls Lower Rock Item2"
    FALLS_LOWER_ROCK_ITEM3 = "Falls Lower Rock Item3"
    FALLS_LOWER_DIG_CAVE_LEFT_CHEST = "Falls Lower Dig Cave Left Chest"
    FALLS_LOWER_DIG_CAVE_RIGHT_CHEST = "Falls Lower Dig Cave Right Chest"
    HYLIA_SUNKEN_HP = "Hylia Sunken HP"
    HYLIA_DOG_NPC = "Hylia Dog NPC"
    HYLIA_SMALL_ISLAND_HP = "Hylia Small Island HP"
    HYLIA_CAPE_CAVE_TOP_RIGHT = "Hylia Cape Cave Top Right"
    HYLIA_CAPE_CAVE_BOTTOM_LEFT = "Hylia Cape Cave Bottom Left"
    HYLIA_CAPE_CAVE_TOP_LEFT = "Hylia Cape Cave Top Left"
    HYLIA_CAPE_CAVE_TOP_MIDDLE = "Hylia Cape Cave Top Middle"
    HYLIA_CAPE_CAVE_RIGHT = "Hylia Cape Cave Right"
    HYLIA_CAPE_CAVE_BOTTOM_RIGHT = "Hylia Cape Cave Bottom Right"
    HYLIA_CAPE_CAVE_BOTTOM_MIDDLE = "Hylia Cape Cave Bottom Middle"
    HYLIA_CAPE_CAVE_LON_LON_HP = "Hylia Cape Cave Lon Lon HP"
    HYLIA_BEANSTALK_FUSION_LEFT_CHEST = "Hylia Beanstalk Fusion Left Chest"
    HYLIA_BEANSTALK_FUSION_HP = "Hylia Beanstalk Fusion HP"
    HYLIA_BEANSTALK_FUSION_RIGHT_CHEST = "Hylia Beanstalk Fusion Right Chest"
    HYLIA_MIDDLE_ISLAND_FUSION_DIG_CAVE_CHEST = "Hylia Middle Island Fusion Dig Cave Chest"
    TOD_ENTRANCE = "Dungeon Entrance in Lake Hylia"
    HYLIA_BOTTOM_HP = "Hylia Bottom HP"
    HYLIA_DOJO_HP = "Hylia Dojo HP"
    HYLIA_DOJO_NPC = "Hylia Dojo NPC"
    HYLIA_CRACK_FUSION_LIBRARI_NPC = "Hylia Crack Fusion Librari NPC"
    HYLIA_NORTH_MINISH_HOLE_CHEST = "Hylia North Minish Hole Chest"
    HYLIA_SOUTH_MINISH_HOLE_CHEST = "Hylia South Minish Hole Chest"
    HYLIA_CABIN_PATH_FUSION_CHEST = "Hylia Cabin Path Fusion Chest"
    HYLIA_MAYOR_CABIN_ITEM = "Hylia Mayor Cabin Item"
    MINISH_WOODS_GOLDEN_OCTO = "Minish Woods Golden Octo"
    MINISH_WOODS_WITCH_HUT_ITEM = "Minish Woods Witch Hut Item"
    WITCH_DIGGING_CAVE_CHEST = "Witch Digging Cave Chest"
    MINISH_WOODS_NORTH_FUSION_CHEST = "Minish Woods North Fusion Chest"
    MINISH_WOODS_TOP_HP = "Minish Woods Top HP"
    MINISH_WOODS_WEST_FUSION_CHEST = "Minish Woods West Fusion Chest"
    MINISH_WOODS_LIKE_LIKE_DIGGING_CAVE_LEFT_CHEST = "Minish Woods Like Like Digging Cave Left Chest"
    MINISH_WOODS_LIKE_LIKE_DIGGING_CAVE_RIGHT_CHEST = "Minish Woods Like Like Digging Cave Right Chest"
    MINISH_WOODS_EAST_FUSION_CHEST = "Minish Woods East Fusion Chest"
    MINISH_WOODS_SOUTH_FUSION_CHEST = "Minish Woods South Fusion Chest"
    MINISH_WOODS_BOTTOM_HP = "Minish Woods Bottom HP"
    MINISH_WOODS_CRACK_FUSION_CHEST = "Minish Woods Crack Fusion Chest"
    MINISH_WOODS_MINISH_PATH_FUSION_CHEST = "Minish Woods Minish Path Fusion Chest"
    MINISH_VILLAGE_BARREL_HOUSE_ITEM = "Minish Village Barrel House Item"
    MINISH_VILLAGE_HP = "Minish Village HP"
    DWS_ENTRANCE = "Dungeon Entrance in Minish Woods"
    MINISH_WOODS_BOMB_MINISH_NPC_1 = "Minish Woods Bomb Minish NPC 1"
    MINISH_WOODS_BOMB_MINISH_NPC_2 = "Minish Woods Bomb Minish NPC 2"
    MINISH_WOODS_POST_VILLAGE_FUSION_CHEST = "Minish Woods Post Village Fusion Chest"
    MINISH_WOODS_FLIPPER_HOLE_MIDDLE_CHEST = "Minish Woods Flipper Hole Middle Chest"
    MINISH_WOODS_FLIPPER_HOLE_RIGHT_CHEST = "Minish Woods Flipper Hole Right Chest"
    MINISH_WOODS_FLIPPER_HOLE_LEFT_CHEST = "Minish Woods Flipper Hole Left Chest"
    MINISH_WOODS_FLIPPER_HOLE_HP = "Minish Woods Flipper Hole HP"
    TRILBY_MIDDLE_FUSION_CHEST = "Trilby Middle Fusion Chest"
    TRILBY_TOP_FUSION_CHEST = "Trilby Top Fusion Chest"
    TRILBY_DIG_CAVE_LEFT_CHEST = "Trilby Dig Cave Left Chest"
    TRILBY_DIG_CAVE_RIGHT_CHEST = "Trilby Dig Cave Right Chest"
    TRILBY_DIG_CAVE_WATER_FUSION_CHEST = "Trilby Dig Cave Water Fusion Chest"
    TRILBY_SCRUB_NPC = "Trilby Scrub NPC"
    TRILBY_BOMB_CAVE_CHEST = "Trilby Bomb Cave Chest"
    TRILBY_PUDDLE_FUSION_ITEM1 = "Trilby Puddle Fusion Item Top Left"
    TRILBY_PUDDLE_FUSION_ITEM2 = "Trilby Puddle Fusion Item Top Middle Left"
    TRILBY_PUDDLE_FUSION_ITEM3 = "Trilby Puddle Fusion Item Top Middle"
    TRILBY_PUDDLE_FUSION_ITEM4 = "Trilby Puddle Fusion Item Top Middle Right"
    TRILBY_PUDDLE_FUSION_ITEM5 = "Trilby Puddle Fusion Item Top Right"
    TRILBY_PUDDLE_FUSION_ITEM6 = "Trilby Puddle Fusion Item Center Left"
    TRILBY_PUDDLE_FUSION_ITEM7 = "Trilby Puddle Fusion Item Center Middle Left"
    TRILBY_PUDDLE_FUSION_ITEM8 = "Trilby Puddle Fusion Item Center Middle"
    TRILBY_PUDDLE_FUSION_ITEM9 = "Trilby Puddle Fusion Item Center Middle Right"
    TRILBY_PUDDLE_FUSION_ITEM10 = "Trilby Puddle Fusion Item Center Right"
    TRILBY_PUDDLE_FUSION_ITEM11 = "Trilby Puddle Fusion Item Bottom Left"
    TRILBY_PUDDLE_FUSION_ITEM12 = "Trilby Puddle Fusion Item Bottom Middle Left"
    TRILBY_PUDDLE_FUSION_ITEM13 = "Trilby Puddle Fusion Item Bottom Middle"
    TRILBY_PUDDLE_FUSION_ITEM14 = "Trilby Puddle Fusion Item Bottom Middle Right"
    TRILBY_PUDDLE_FUSION_ITEM15 = "Trilby Puddle Fusion Item Bottom Right"
    WESTERN_WOODS_FUSION_CHEST = "Western Woods Fusion Chest"
    WESTERN_WOODS_TREE_FUSION_HP = "Western Woods Tree Fusion HP"
    WESTERN_WOODS_TOP_DIG1 = "Western Woods Top Dig 1"
    WESTERN_WOODS_TOP_DIG2 = "Western Woods Top Dig 2"
    WESTERN_WOODS_TOP_DIG3 = "Western Woods Top Dig 3"
    WESTERN_WOODS_TOP_DIG4 = "Western Woods Top Dig 4"
    WESTERN_WOODS_TOP_DIG5 = "Western Woods Top Dig 5"
    WESTERN_WOODS_TOP_DIG6 = "Western Woods Top Dig 6"
    WESTERN_WOODS_PERCY_FUSION_MOBLIN = "Western Woods Percy Fusion Moblin"
    WESTERN_WOODS_PERCY_FUSION_PERCY = "Western Woods Percy Fusion Percy"
    WESTERN_WOODS_BOTTOM_DIG1 = "Western Woods Bottom Dig 1"
    WESTERN_WOODS_BOTTOM_DIG2 = "Western Woods Bottom Dig 2"
    WESTERN_WOODS_GOLDEN_OCTO = "Western Woods Golden Octo"
    WESTERN_WOODS_BEANSTALK_FUSION_CHEST = "Western Woods Beanstalk Fusion Chest"
    WESTERN_WOODS_BEANSTALK_FUSION_ITEM1 = "Western Woods Beanstalk Fusion Item 1"
    WESTERN_WOODS_BEANSTALK_FUSION_ITEM2 = "Western Woods Beanstalk Fusion Item 2"
    WESTERN_WOODS_BEANSTALK_FUSION_ITEM3 = "Western Woods Beanstalk Fusion Item 3"
    WESTERN_WOODS_BEANSTALK_FUSION_ITEM4 = "Western Woods Beanstalk Fusion Item 4"
    WESTERN_WOODS_BEANSTALK_FUSION_ITEM5 = "Western Woods Beanstalk Fusion Item 5"
    WESTERN_WOODS_BEANSTALK_FUSION_ITEM6 = "Western Woods Beanstalk Fusion Item 6"
    WESTERN_WOODS_BEANSTALK_FUSION_ITEM7 = "Western Woods Beanstalk Fusion Item 7"
    WESTERN_WOODS_BEANSTALK_FUSION_ITEM8 = "Western Woods Beanstalk Fusion Item 8"
    WESTERN_WOODS_BEANSTALK_FUSION_ITEM9 = "Western Woods Beanstalk Fusion Item 9"
    WESTERN_WOODS_BEANSTALK_FUSION_ITEM10 = "Western Woods Beanstalk Fusion Item 10"
    WESTERN_WOODS_BEANSTALK_FUSION_ITEM11 = "Western Woods Beanstalk Fusion Item 11"
    WESTERN_WOODS_BEANSTALK_FUSION_ITEM12 = "Western Woods Beanstalk Fusion Item 12"
    WESTERN_WOODS_BEANSTALK_FUSION_ITEM13 = "Western Woods Beanstalk Fusion Item 13"
    WESTERN_WOODS_BEANSTALK_FUSION_ITEM14 = "Western Woods Beanstalk Fusion Item 14"
    WESTERN_WOODS_BEANSTALK_FUSION_ITEM15 = "Western Woods Beanstalk Fusion Item 15"
    WESTERN_WOODS_BEANSTALK_FUSION_ITEM16 = "Western Woods Beanstalk Fusion Item 16"
    CRENEL_BASE_ENTRANCE_VINE = "Crenel Base Entrance Vine"
    CRENEL_BASE_FAIRY_CAVE_ITEM1 = "Crenel Base Fairy Cave Item Left"
    CRENEL_BASE_FAIRY_CAVE_ITEM2 = "Crenel Base Fairy Cave Item Middle"
    CRENEL_BASE_FAIRY_CAVE_ITEM3 = "Crenel Base Fairy Cave Item Right"
    CRENEL_BASE_GREEN_WATER_FUSION_CHEST = "Crenel Base Green Water Fusion Chest"
    CRENEL_BASE_WEST_FUSION_CHEST = "Crenel Base West Fusion Chest"
    CRENEL_BASE_WATER_CAVE_LEFT_CHEST = "Crenel Base Water Cave Left Chest"
    CRENEL_BASE_WATER_CAVE_RIGHT_CHEST = "Crenel Base Water Cave Right Chest"
    CRENEL_BASE_WATER_CAVE_HP = "Crenel Base Water Cave HP"
    CRENEL_BASE_MINISH_VINE_HOLE_CHEST = "Crenel Base Minish Vine Hole Chest"
    CRENEL_BASE_MINISH_CRACK_CHEST = "Crenel Base Minish Crack Chest"
    CRENEL_VINE_TOP_GOLDEN_TEKTITE = "Crenel Vine Top Golden Tektite"
    CRENEL_BRIDGE_CAVE_CHEST = "Crenel Bridge Cave Chest"
    CRENEL_FAIRY_CAVE_HP = "Crenel Fairy Cave HP"
    CRENEL_BELOW_COF_GOLDEN_TEKTITE = "Crenel Below CoF Golden Tektite"
    CRENEL_SCRUB_NPC = "Crenel Scrub NPC"
    CRENEL_DOJO_LEFT_CHEST = "Crenel Dojo Left Chest"
    CRENEL_DOJO_RIGHT_CHEST = "Crenel Dojo Right Chest"
    CRENEL_DOJO_HP = "Crenel Dojo HP"
    CRENEL_DOJO_NPC = "Crenel Dojo NPC"
    CRENEL_GREAT_FAIRY_NPC = "Crenel Great Fairy NPC"
    CRENEL_CLIMB_FUSION_CHEST = "Crenel Climb Fusion Chest"
    CRENEL_DIG_CAVE_HP = "Crenel Dig Cave HP"
    CRENEL_BEANSTALK_FUSION_HP = "Crenel Beanstalk Fusion HP"
    CRENEL_BEANSTALK_FUSION_ITEM1 = "Crenel Beanstalk Fusion Item 1"
    CRENEL_BEANSTALK_FUSION_ITEM2 = "Crenel Beanstalk Fusion Item 2"
    CRENEL_BEANSTALK_FUSION_ITEM3 = "Crenel Beanstalk Fusion Item 3"
    CRENEL_BEANSTALK_FUSION_ITEM4 = "Crenel Beanstalk Fusion Item 4"
    CRENEL_BEANSTALK_FUSION_ITEM5 = "Crenel Beanstalk Fusion Item 5"
    CRENEL_BEANSTALK_FUSION_ITEM6 = "Crenel Beanstalk Fusion Item 6"
    CRENEL_BEANSTALK_FUSION_ITEM7 = "Crenel Beanstalk Fusion Item 7"
    CRENEL_BEANSTALK_FUSION_ITEM8 = "Crenel Beanstalk Fusion Item 8"
    CRENEL_RAIN_PATH_FUSION_CHEST = "Crenel Rain Path Fusion Chest"
    CRENEL_UPPER_BLOCK_CHEST = "Crenel Upper Block Chest"
    CRENEL_MINES_PATH_FUSION_CHEST = "Crenel Mines Path Fusion Chest"
    CRENEL_MELARI_LEFT_DIG = "Melari Mines: Left Dig"
    CRENEL_MELARI_CENTER_DIG = "Melari Mines: Center Dig"
    CRENEL_MELARI_BOTTOM_LEFT_DIG = "Melari Mines: Bottom Left Dig"
    CRENEL_MELARI_BOTTOM_MIDDLE_DIG = "Melari Mines: Bottom Middle Dig"
    CRENEL_MELARI_BOTTOM_RIGHT_DIG = "Melari Mines: Bottom Right Dig"
    CRENEL_MELARI_TOP_RIGHT_DIG = "Melari Mines: Top Right Dig"
    CRENEL_MELARI_TOP_MIDDLE_DIG = "Melari Mines: Top Middle Dig"
    CRENEL_MELARI_TOP_LEFT_DIG = "Melari Mines: Top Left Dig"
    COF_ENTRANCE = "Dungeon Entrance in Mt Crenel"
    SWAMP_BUTTERFLY_FUSION_ITEM = "Swamp Butterfly Fusion Item"
    SWAMP_CENTER_CAVE_DARKNUT_CHEST = "Swamp Center Cave Darknut Chest"
    SWAMP_CENTER_CHEST = "Swamp Center Chest"
    SWAMP_GOLDEN_ROPE = "Swamp Golden Rope"
    SWAMP_NEAR_WATERFALL_CAVE_HP = "Swamp Near Waterfall Cave HP"
    SWAMP_WATERFALL_FUSION_DOJO_NPC = "Swamp Waterfall Fusion Dojo NPC"
    SWAMP_NORTH_CAVE_CHEST = "Swamp North Cave Chest"
    SWAMP_DIGGING_CAVE_LEFT_CHEST = "Swamp Digging Cave Left Chest"
    SWAMP_DIGGING_CAVE_RIGHT_CHEST = "Swamp Digging Cave Right Chest"
    SWAMP_UNDERWATER_TOP = "Swamp Underwater Top"
    SWAMP_UNDERWATER_MIDDLE = "Swamp Underwater Middle"
    SWAMP_UNDERWATER_BOTTOM = "Swamp Underwater Bottom"
    SWAMP_SOUTH_CAVE_CHEST = "Swamp South Cave Chest"
    SWAMP_DOJO_HP = "Swamp Dojo HP"
    SWAMP_DOJO_NPC = "Swamp Dojo NPC"
    SWAMP_MINISH_FUSION_NORTH_CRACK_CHEST = "Swamp Minish Fusion North Crack Chest"
    SWAMP_MINISH_MULLDOZER_BIG_CHEST = "Swamp Minish Mulldozer Big Chest"
    SWAMP_MINISH_FUSION_NORTH_WEST_CRACK_CHEST = "Swamp Minish Fusion North West Crack Chest"
    SWAMP_MINISH_FUSION_WEST_CRACK_CHEST = "Swamp Minish Fusion West Crack Chest"
    SWAMP_MINISH_FUSION_VINE_CRACK_CHEST = "Swamp Minish Fusion Vine Crack Chest"
    SWAMP_MINISH_FUSION_WATER_HOLE_CHEST = "Swamp Minish Fusion Water Hole Chest"
    SWAMP_MINISH_FUSION_WATER_HOLE_HP = "Swamp Minish Fusion Water Hole HP"
    RUINS_BUTTERFLY_FUSION_ITEM = "Ruins Butterfly Fusion Item"
    RUINS_BOMB_CAVE_CHEST = "Ruins Bomb Cave Chest"
    RUINS_MINISH_HOME_CHEST = "Ruins Minish Home Chest"
    RUINS_PILLARS_FUSION_CHEST = "Ruins Pillars Fusion Chest"
    RUINS_BEAN_STALK_FUSION_BIG_CHEST = "Ruins Bean Stalk Fusion Big Chest"
    RUINS_CRACK_FUSION_CHEST = "Ruins Crack Fusion Chest"
    RUINS_MINISH_CAVE_HP = "Ruins Minish Cave HP"
    RUINS_ARMOS_KILL_LEFT_CHEST = "Ruins Armos Kill Left Chest"
    RUINS_ARMOS_KILL_RIGHT_CHEST = "Ruins Armos Kill Right Chest"
    RUINS_GOLDEN_OCTO = "Ruins Golden Octo"
    RUINS_NEAR_FOW_FUSION_CHEST = "Ruins Near Dungeon Fusion Chest"
    FOW_ENTRANCE = "Dungeon Entrance in Wind Ruins"
    VALLEY_PRE_VALLEY_FUSION_CHEST = "Valley Pre Valley Fusion Chest"
    VALLEY_GREAT_FAIRY_NPC = "Valley Great Fairy NPC"
    VALLEY_LOST_WOODS_CHEST = "Valley Lost Woods Chest"
    VALLEY_DAMPE_NPC = "Valley Dampe NPC"
    VALLEY_GRAVEYARD_BUTTERFLY_FUSION_ITEM = "Valley Graveyard Butterfly Fusion Item"
    VALLEY_GRAVEYARD_LEFT_FUSION_CHEST = "Valley Graveyard Left Fusion Chest"
    VALLEY_GRAVEYARD_LEFT_GRAVE_HP = "Valley Graveyard Left Grave HP"
    VALLEY_GRAVEYARD_RIGHT_FUSION_CHEST = "Valley Graveyard Right Fusion Chest"
    VALLEY_GRAVEYARD_RIGHT_GRAVE_FUSION_CHEST = "Valley Graveyard Right Grave Fusion Chest"
    RC_ENTRANCE = "Dungeon Entrance in Graveyard"
    CRYPT_GIBDO_LEFT_ITEM = "Crypt Gibdo Left Item"
    CRYPT_GIBDO_RIGHT_ITEM = "Crypt Gibdo Right Item"
    CRYPT_LEFT_ITEM = "Crypt Left Item"
    CRYPT_RIGHT_ITEM = "Crypt Right Item"
    CRYPT_PRIZE = "Crypt Prize"
    FALLS_ENTRANCE_HP = "Falls Entrance HP"
    FALLS_WATER_DIG_CAVE_FUSION_HP = "Falls Water Dig Cave Fusion HP"
    FALLS_WATER_DIG_CAVE_FUSION_CHEST = "Falls Water Dig Cave Fusion Chest"
    FALLS_1ST_CAVE_CHEST = "Falls 1st Cave Chest"
    FALLS_CLIFF_CHEST = "Falls Cliff Chest"
    FALLS_SOUTH_DIG_SPOT = "Falls South Dig Spot"
    FALLS_GOLDEN_TEKTITE = "Falls Golden Tektite"
    FALLS_NORTH_DIG_SPOT = "Falls North Dig Spot"
    FALLS_ROCK_FUSION_CHEST = "Falls Rock Fusion Chest"
    FALLS_WATERFALL_FUSION_HP = "Falls Waterfall Fusion HP"
    FALLS_RUPEE_CAVE_TOP_TOP = "Falls Rupee Cave Top Top"
    FALLS_RUPEE_CAVE_TOP_LEFT = "Falls Rupee Cave Top Left"
    FALLS_RUPEE_CAVE_TOP_MIDDLE = "Falls Rupee Cave Top Middle"
    FALLS_RUPEE_CAVE_TOP_RIGHT = "Falls Rupee Cave Top Right"
    FALLS_RUPEE_CAVE_TOP_BOTTOM = "Falls Rupee Cave Top Bottom"
    FALLS_RUPEE_CAVE_SIDE_TOP = "Falls Rupee Cave Side Top"
    FALLS_RUPEE_CAVE_SIDE_LEFT = "Falls Rupee Cave Side Left"
    FALLS_RUPEE_CAVE_SIDE_RIGHT = "Falls Rupee Cave Side Right"
    FALLS_RUPEE_CAVE_SIDE_BOTTOM = "Falls Rupee Cave Side Bottom"
    FALLS_RUPEE_CAVE_UNDERWATER_TOP_LEFT = "Falls Rupee Cave Underwater Top Left"
    FALLS_RUPEE_CAVE_UNDERWATER_TOP_RIGHT = "Falls Rupee Cave Underwater Top Right"
    FALLS_RUPEE_CAVE_UNDERWATER_MIDDLE_LEFT = "Falls Rupee Cave Underwater Middle Left"
    FALLS_RUPEE_CAVE_UNDERWATER_MIDDLE_RIGHT = "Falls Rupee Cave Underwater Middle Right"
    FALLS_RUPEE_CAVE_UNDERWATER_BOTTOM_LEFT = "Falls Rupee Cave Underwater Bottom Left"
    FALLS_RUPEE_CAVE_UNDERWATER_BOTTOM_RIGHT = "Falls Rupee Cave Underwater Bottom Right"
    FALLS_TOP_CAVE_BOMB_WALL_CHEST = "Falls Top Cave Bomb Wall Chest"
    FALLS_TOP_CAVE_CHEST = "Falls Top Cave Chest"
    FALLS_BIGGORON = "Falls Biggoron Item"
    CLOUDS_FREE_CHEST = "Clouds Free Chest"
    CLOUDS_NORTH_EAST_DIG_SPOT = "Clouds North East Dig Spot"
    CLOUDS_NORTH_KILL = "Clouds North Shark Kill"
    CLOUDS_NORTH_WEST_RIGHT_CHEST = "Clouds North West Right Chest"
    CLOUDS_NORTH_WEST_LEFT_CHEST = "Clouds North West Left Chest"
    CLOUDS_NORTH_WEST_DIG_SPOT = "Clouds North West Dig Spot"
    CLOUDS_NORTH_WEST_BOTTOM_CHEST = "Clouds North West Bottom Chest"
    CLOUDS_SOUTH_LEFT_CHEST = "Clouds South Left Chest"
    CLOUDS_SOUTH_DIG_SPOT = "Clouds South Dig Spot"
    CLOUDS_SOUTH_MIDDLE_CHEST = "Clouds South Middle Chest"
    CLOUDS_SOUTH_MIDDLE_DIG_SPOT = "Clouds South Middle Dig Spot"
    CLOUDS_SOUTH_KILL = "Clouds South Shark Kill"
    CLOUDS_SOUTH_RIGHT_CHEST = "Clouds South Right Chest"
    CLOUDS_SOUTH_RIGHT_DIG_SPOT = "Clouds South Right Dig Spot"
    CLOUDS_SOUTH_EAST_BOTTOM_DIG_SPOT = "Clouds South East Bottom Dig Spot"
    CLOUDS_SOUTH_EAST_TOP_DIG_SPOT = "Clouds South East Top Dig Spot"
    WIND_TRIBE_1F_LEFT_CHEST = "Wind Tribe 1F Left Chest"
    WIND_TRIBE_1F_RIGHT_CHEST = "Wind Tribe 1F Right Chest"
    WIND_TRIBE_2F_CHEST = "Wind Tribe 2F Chest"
    WIND_TRIBE_2F_GREGAL_NPC_1 = "Wind Tribe 2F Gregal NPC 1"
    WIND_TRIBE_2F_GREGAL_NPC_2 = "Wind Tribe 2F Gregal NPC 2"
    WIND_TRIBE_3F_LEFT_CHEST = "Wind Tribe 3F Left Chest"
    WIND_TRIBE_3F_CENTER_CHEST = "Wind Tribe 3F Center Chest"
    WIND_TRIBE_3F_RIGHT_CHEST = "Wind Tribe 3F Right Chest"
    WIND_TRIBE_4F_LEFT_CHEST = "Wind Tribe 4F Left Chest"
    WIND_TRIBE_4F_RIGHT_CHEST = "Wind Tribe 4F Right Chest"
    POW_ENTRANCE = "Dungeon Entrance in Wind Tribe"
    DEEPWOOD_2F_CHEST = "Deepwood 2F Chest"
    DEEPWOOD_1F_SLUG_TORCHES_CHEST = "Deepwood 1F Slug Torches Chest"
    DEEPWOOD_1F_BARREL_ROOM_CHEST = "Deepwood 1F Barrel Room Chest"
    DEEPWOOD_1F_WEST_BIG_CHEST = "Deepwood 1F West Big Chest"
    DEEPWOOD_1F_WEST_STATUE_PUZZLE_CHEST = "Deepwood 1F West Statue Puzzle Chest"
    DEEPWOOD_1F_EAST_MULLDOZER_FIGHT_ITEM = "Deepwood 1F East Mulldozer Fight Item"
    DEEPWOOD_1F_NORTH_EAST_CHEST = "Deepwood 1F North East Chest"
    DEEPWOOD_B1_SWITCH_ROOM_BIG_CHEST = "Deepwood B1 Switch Room Big Chest"
    DEEPWOOD_B1_SWITCH_ROOM_CHEST = "Deepwood B1 Switch Room Chest"
    DEEPWOOD_1F_BLUE_WARP_HP = "Deepwood 1F Blue Warp HP"
    DEEPWOOD_1F_BLUE_WARP_LEFT_CHEST = "Deepwood 1F Blue Warp Left Chest"
    DEEPWOOD_1F_BLUE_WARP_RIGHT_CHEST = "Deepwood 1F Blue Warp Right Chest"
    DEEPWOOD_1F_MADDERPILLAR_BIG_CHEST = "Deepwood 1F Madderpillar Big Chest"
    DEEPWOOD_1F_MADDERPILLAR_HP = "Deepwood 1F Madderpillar HP"
    DEEPWOOD_B1_WEST_BIG_CHEST = "Deepwood B1 West Big Chest"
    DEEPWOOD_BOSS_ITEM = "Deepwood Boss Item"
    DEEPWOOD_PRIZE = "Deepwood Prize"
    COF_1F_SPIKE_BEETLE_BIG_CHEST = "CoF 1F Spike Beetle Big Chest"
    COF_1F_ITEM1 = "CoF 1F Item Top Left"
    COF_1F_ITEM2 = "CoF 1F Item Top Middle"
    COF_1F_ITEM3 = "CoF 1F Item Top Right"
    COF_1F_ITEM4 = "CoF 1F Item Bottom Left"
    COF_1F_ITEM5 = "CoF 1F Item Bottom Right"
    COF_B1_HAZY_ROOM_BIG_CHEST = "CoF B1 Hazy Room Big Chest"
    COF_B1_HAZY_ROOM_SMALL_CHEST = "CoF B1 Hazy Room Small Chest"
    COF_B1_ROLLOBITE_CHEST = "CoF B1 Rollobite Chest"
    COF_B1_ROLLOBITE_PILLAR_CHEST = "CoF B1 Rollobite Pillar Chest"
    COF_B1_SPIKEY_CHUS_PILLAR_CHEST = "CoF B1 Spikey Chus Pillar Chest"
    COF_B1_HP = "CoF B1 HP"
    COF_B1_SPIKEY_CHUS_BIG_CHEST = "CoF B1 Spikey Chus Big Chest"
    COF_B2_PRE_LAVA_NORTH_CHEST = "CoF B2 Pre Lava North Chest"
    COF_B2_PRE_LAVA_SOUTH_CHEST = "CoF B2 Pre Lava South Chest"
    COF_B2_LAVA_ROOM_BLADE_CHEST = "CoF B2 Lava Room Blade Chest"
    COF_B2_LAVA_ROOM_RIGHT_CHEST = "CoF B2 Lava Room Right Chest"
    COF_B2_LAVA_ROOM_LEFT_CHEST = "CoF B2 Lava Room Left Chest"
    COF_B2_LAVA_ROOM_BIG_CHEST = "CoF B2 Lava Room Big Chest"
    COF_BOSS_ITEM = "CoF Boss Item"
    COF_PRIZE = "CoF Prize"
    CRENEL_MELARI_NPC = "Crenel Melari Dungeon Reward"
    FORTRESS_ENTRANCE_1F_LEFT_CHEST = "Fortress Entrance 1F Left Chest"
    FORTRESS_ENTRANCE_1F_LEFT_WIZZROBE_CHEST = "Fortress Entrance 1F Left Wizzrobe Chest"
    FORTRESS_ENTRANCE_1F_RIGHT_ITEM = "Fortress Entrance 1F Right Item"
    FORTRESS_LEFT_2F_DIG_CHEST = "Fortress Left 2F Dig Chest"
    FORTRESS_LEFT_2F_ITEM1 = "Fortress Left 2F Item 1"
    FORTRESS_LEFT_2F_ITEM2 = "Fortress Left 2F Item 2"
    FORTRESS_LEFT_2F_ITEM3 = "Fortress Left 2F Item 3"
    FORTRESS_LEFT_2F_ITEM4 = "Fortress Left 2F Item 4"
    FORTRESS_LEFT_2F_ITEM5 = "Fortress Left 2F Item 5"
    FORTRESS_LEFT_2F_ITEM6 = "Fortress Left 2F Item 6"
    FORTRESS_LEFT_2F_ITEM7 = "Fortress Left 2F Item 7"
    FORTRESS_LEFT_3F_SWITCH_CHEST = "Fortress Left 3F Switch Chest"
    FORTRESS_LEFT_3F_EYEGORE_BIG_CHEST = "Fortress Left 3F Eyegore Big Chest"
    FORTRESS_LEFT_3F_ITEM_DROP = "Fortress Left 3F Item Drop"
    FORTRESS_MIDDLE_2F_BIG_CHEST = "Fortress Middle 2F Big Chest"
    FORTRESS_MIDDLE_2F_STATUE_CHEST = "Fortress Middle 2F Statue Chest"
    FORTRESS_RIGHT_2F_LEFT_CHEST = "Fortress Right 2F Left Chest"
    FORTRESS_RIGHT_2F_RIGHT_CHEST = "Fortress Right 2F Right Chest"
    FORTRESS_RIGHT_2F_DIG_CHEST = "Fortress Right 2F Dig Chest"
    FORTRESS_RIGHT_3F_DIG_CHEST = "Fortress Right 3F Dig Chest"
    FORTRESS_RIGHT_3F_ITEM_DROP = "Fortress Right 3F Item Drop"
    FORTRESS_ENTRANCE_1F_RIGHT_HP = "Fortress Entrance 1F Right HP"
    FORTRESS_BACK_LEFT_BIG_CHEST = "Fortress Back Left Big Chest"
    FORTRESS_BACK_LEFT_SMALL_CHEST = "Fortress Back Left Small Chest"
    FORTRESS_BACK_RIGHT_STATUE_ITEM_DROP = "Fortress Back Right Statue Item Drop"
    FORTRESS_BACK_RIGHT_MINISH_ITEM_DROP = "Fortress Back Right Minish Item Drop"
    FORTRESS_BACK_RIGHT_DIG_ROOM_TOP_POT = "Fortress Back Right Dig Room Top Pot"
    FORTRESS_BACK_RIGHT_DIG_ROOM_BOTTOM_POT = "Fortress Back Right Dig Room Bottom Pot"
    FORTRESS_BACK_RIGHT_BIG_CHEST = "Fortress Back Right Big Chest"
    FORTRESS_BOSS_ITEM = "Fortress Boss Item"
    FORTRESS_PRIZE = "Fortress Prize"
    DROPLETS_ENTRANCE_B2_EAST_ICEBLOCK = "Droplets Entrance B2 East Iceblock"
    DROPLETS_ENTRANCE_B2_WEST_ICEBLOCK = "Droplets Entrance B2 West Iceblock"
    DROPLETS_LEFT_PATH_B1_UNDERPASS_ITEM1 = "Droplets Left Path B1 Underpass Item1"
    DROPLETS_LEFT_PATH_B1_UNDERPASS_ITEM2 = "Droplets Left Path B1 Underpass Item2"
    DROPLETS_LEFT_PATH_B1_UNDERPASS_ITEM3 = "Droplets Left Path B1 Underpass Item3"
    DROPLETS_LEFT_PATH_B1_UNDERPASS_ITEM4 = "Droplets Left Path B1 Underpass Item4"
    DROPLETS_LEFT_PATH_B1_UNDERPASS_ITEM5 = "Droplets Left Path B1 Underpass Item5"
    DROPLETS_LEFT_PATH_B1_WATERFALL_BIG_CHEST = "Droplets Left Path B1 Waterfall Big Chest"
    DROPLETS_LEFT_PATH_B1_WATERFALL_UNDERWATER1 = "Droplets Left Path B1 Waterfall Underwater 1"
    DROPLETS_LEFT_PATH_B1_WATERFALL_UNDERWATER2 = "Droplets Left Path B1 Waterfall Underwater 2"
    DROPLETS_LEFT_PATH_B1_WATERFALL_UNDERWATER3 = "Droplets Left Path B1 Waterfall Underwater 3"
    DROPLETS_LEFT_PATH_B1_WATERFALL_UNDERWATER4 = "Droplets Left Path B1 Waterfall Underwater 4"
    DROPLETS_LEFT_PATH_B1_WATERFALL_UNDERWATER5 = "Droplets Left Path B1 Waterfall Underwater 5"
    DROPLETS_LEFT_PATH_B1_WATERFALL_UNDERWATER6 = "Droplets Left Path B1 Waterfall Underwater 6"
    DROPLETS_LEFT_PATH_B2_WATERFALL_UNDERWATER1 = "Droplets Left Path B2 Waterfall Underwater 1"
    DROPLETS_LEFT_PATH_B2_WATERFALL_UNDERWATER2 = "Droplets Left Path B2 Waterfall Underwater 2"
    DROPLETS_LEFT_PATH_B2_WATERFALL_UNDERWATER3 = "Droplets Left Path B2 Waterfall Underwater 3"
    DROPLETS_LEFT_PATH_B2_WATERFALL_UNDERWATER4 = "Droplets Left Path B2 Waterfall Underwater 4"
    DROPLETS_LEFT_PATH_B2_WATERFALL_UNDERWATER5 = "Droplets Left Path B2 Waterfall Underwater 5"
    DROPLETS_LEFT_PATH_B2_WATERFALL_UNDERWATER6 = "Droplets Left Path B2 Waterfall Underwater 6"
    DROPLETS_LEFT_PATH_B2_UNDERWATER_POT = "Droplets Left Path B2 Underwater Pot"
    DROPLETS_LEFT_PATH_B2_ICE_MADDERPILLAR_BIG_CHEST = "Droplets Left Path B2 Ice Madderpillar Big Chest"
    DROPLETS_LEFT_PATH_B2_ICE_PLAIN_FROZEN_CHEST = "Droplets Left Path B2 Ice Plain Frozen Chest"
    DROPLETS_LEFT_PATH_B2_ICE_PLAIN_CHEST = "Droplets Left Path B2 Ice Plain Chest"
    DROPLETS_LEFT_PATH_B2_LILYPAD_CORNER_FROZEN_CHEST = "Droplets Left Path B2 Lilypad Corner Frozen Chest"
    DROPLETS_RIGHT_PATH_B1_1ST_CHEST = "Droplets Right Path B1 1st Chest"
    DROPLETS_RIGHT_PATH_B1_2ND_CHEST = "Droplets Right Path B1 2nd Chest"
    DROPLETS_RIGHT_PATH_B1_POT = "Droplets Right Path B1 Pot"
    DROPLETS_RIGHT_PATH_B3_FROZEN_CHEST = "Droplets Right Path B3Frozen Chest"
    DROPLETS_RIGHT_PATH_B1_BLU_CHU_BIG_CHEST = "Droplets Right Path B1 Blu Chu Big Chest"
    DROPLETS_RIGHT_PATH_B2_FROZEN_CHEST = "Droplets Right Path B2Frozen Chest"
    DROPLETS_RIGHT_PATH_B2_DARK_MAZE_BOTTOM_CHEST = "Droplets Right Path B2 Dark Maze Bottom Chest"
    DROPLETS_RIGHT_PATH_B2_MULLDOZERS_ITEM_DROP = "Droplets Right Path B2 Mulldozers Item Drop"
    DROPLETS_RIGHT_PATH_B2_DARK_MAZE_TOP_RIGHT_CHEST = "Droplets Right Path B2 Dark Maze Top Right Chest"
    DROPLETS_RIGHT_PATH_B2_DARK_MAZE_TOP_LEFT_CHEST = "Droplets Right Path B2 Dark Maze Top Left Chest"
    DROPLETS_RIGHT_PATH_B2_UNDERPASS_ITEM1 = "Droplets Right Path B2 Underpass Item1"
    DROPLETS_RIGHT_PATH_B2_UNDERPASS_ITEM2 = "Droplets Right Path B2 Underpass Item2"
    DROPLETS_RIGHT_PATH_B2_UNDERPASS_ITEM3 = "Droplets Right Path B2 Underpass Item3"
    DROPLETS_RIGHT_PATH_B2_UNDERPASS_ITEM4 = "Droplets Right Path B2 Underpass Item4"
    DROPLETS_RIGHT_PATH_B2_UNDERPASS_ITEM5 = "Droplets Right Path B2 Underpass Item5"
    DROPLETS_BOSS_ITEM = "Droplets Boss Item"
    DROPLETS_PRIZE = "Droplets Prize"
    PALACE_1ST_HALF_1F_GRATE_CHEST = "Palace 1st Half 1F Grate Chest"
    PALACE_1ST_HALF_1F_WIZZROBE_BIG_CHEST = "Palace 1st Half 1F Wizzrobe Big Chest"
    PALACE_1ST_HALF_2F_ITEM1 = "Palace 1st Half 2F Item1"
    PALACE_1ST_HALF_2F_ITEM2 = "Palace 1st Half 2F Item2"
    PALACE_1ST_HALF_2F_ITEM3 = "Palace 1st Half 2F Item3"
    PALACE_1ST_HALF_2F_ITEM4 = "Palace 1st Half 2F Item4"
    PALACE_1ST_HALF_2F_ITEM5 = "Palace 1st Half 2F Item5"
    PALACE_1ST_HALF_3F_POT_PUZZLE_ITEM_DROP = "Palace 1st Half 3F Pot Puzzle Item Drop"
    PALACE_1ST_HALF_4F_BOW_MOBLINS_CHEST = "Palace 1st Half 4F Bow Moblins Chest"
    PALACE_1ST_HALF_5F_BALL_AND_CHAIN_SOLDIERS_ITEM_DROP = "Palace 1st Half 5F Ball And Chain Soldiers Item Drop"
    PALACE_1ST_HALF_5F_FAN_LOOP_CHEST = "Palace 1st Half 5F Fan Loop Chest"
    PALACE_1ST_HALF_5F_BIG_CHEST = "Palace 1st Half 5F Big Chest"
    PALACE_2ND_HALF_1F_DARK_ROOM_BIG_CHEST = "Palace 2nd Half 1F Dark Room Big Chest"
    PALACE_2ND_HALF_1F_DARK_ROOM_SMALL_CHEST = "Palace 2nd Half 1F Dark Room Small Chest"
    PALACE_2ND_HALF_2F_MANY_ROLLERS_CHEST = "Palace 2nd Half 2F Many Rollers Chest"
    PALACE_2ND_HALF_2F_TWIN_WIZZROBES_CHEST = "Palace 2nd Half 2F Twin Wizzrobes Chest"
    PALACE_2ND_HALF_3F_FIRE_WIZZROBES_BIG_CHEST = "Palace 2nd Half 3F Fire Wizzrobes Big Chest"
    PALACE_2ND_HALF_4F_HP = "Palace 2nd Half 4F HP"
    PALACE_2ND_HALF_4F_SWITCH_HIT_CHEST = "Palace 2nd Half 4F Switch Hit Chest"
    PALACE_2ND_HALF_5F_BOMBAROSSA_CHEST = "Palace 2nd Half 5F Bombarossa Chest"
    PALACE_2ND_HALF_4F_BLOCK_MAZE_CHEST = "Palace 2nd Half 4F Block Maze Chest"
    PALACE_2ND_HALF_5F_RIGHT_SIDE_CHEST = "Palace 2nd Half 5F Right Side Chest"
    PALACE_BOSS_ITEM = "Palace Boss Item"
    PALACE_PRIZE = "Palace Prize"
    SANCTUARY_PEDESTAL_ITEM1 = "Sanctuary Pedestal Item1"
    SANCTUARY_PEDESTAL_ITEM2 = "Sanctuary Pedestal Item2"
    SANCTUARY_PEDESTAL_ITEM3 = "Sanctuary Pedestal Item3"
    PEDESTAL_REQUIREMENT_REWARD = "Pedestal Requirement Reward"
    DHC_B2_KING = "DHC B2 King"
    DHC_B1_BIG_CHEST = "DHC B1 Big Chest"
    DHC_1F_BLADE_CHEST = "DHC 1F Blade Chest"
    DHC_1F_THRONE_BIG_CHEST = "DHC 1F Throne Big Chest"
    DHC_3F_NORTH_WEST_CHEST = "DHC 3F North West Chest"
    DHC_3F_NORTH_EAST_CHEST = "DHC 3F North East Chest"
    DHC_3F_SOUTH_WEST_CHEST = "DHC 3F South West Chest"
    DHC_3F_SOUTH_EAST_CHEST = "DHC 3F South East Chest"
    DHC_2F_BLUE_WARP_BIG_CHEST = "DHC 2F Blue Warp Big Chest"


class TMCFlagGroup:
    SIGNATURE = "Signature"
    INITIALISED = "Initialised"
    TEXTSPEED = "TextSpeed"
    BRIGHTNESS = "Brightness"
    LIGHT_FORCE_ON_FILE_SELECT = "Light Force on File Select"
    DEEPWOOD_SHRINE_BARREL_STATE = "State of Deepwood Shrine Barrel"
    GAME_STAGE = "Game Stage"
    FIGURINES_AVAILABLE_COUNT = "Total Number of Figurines Available"
    QUEST_MAP_MARKERS = "Quest Map Markers"
    MAP_SQUARE_REVEALED = "Map Square Revealed"
    WIND_CRESTS = "Wind Crests"
    ENEMY_KILL_COUNT = "Enemy Kill count"
    ITEMS_BOUGHT_FROM_STOCKWELL = "Items Bought from Stockwell"
    OVERWORLD_VISITED_LOCATIONS = "Overworld Visited Locations"
    DUNGEON_VISITED_LOCATIONS = "Dungeon Visited Locations"
    FILE_NAME = "File Name"

    ROOM_TRANSITIONING_TO_AREA_ID = "Area ID of Room transitioning to"
    ROOM_TRANSITIONING_TO_ROOM_ID = "Room ID of Room transitioning to"
    TRANSITION_FACING_DIRECTION = "Transition Facing Direction"
    TRANSITION_ANIMATION = "Transition Animation"
    TRANSITION_DESTINATION_X_COORDINATE_OFFSET = "Transition destination X coordinate offset"
    TRANSITION_DESTINATION_Y_COORDINATE_OFFSET = "Transition destination Y coordinate offset"
    TRANSITION_DESTINATION_LAYER = "Transition destination Layer"
    LAST_DUNGEON_ENTERED_AREA_ID = "Area ID of Last Dungeon Entered"
    LAST_DUNGEON_ENTERED_ROOM_ID = "Room ID of Last Dungeon Entered"
    LAST_DUNGEON_ENTERED_X_COORDINATE = "Last Dungeon Entered(X coordinate)"
    LAST_DUNGEON_ENTERED_Y_COORDINATE = "Last Dungeon Entered(Y coordinate)"
    CURRENT_DUNGEON_X_COORDINATE = "Current Dungeon X coordinate"
    CURRENT_DUNGEON_Y_COORDINATE = "Current Dungeon Y coordinate"
    CURRENT_OVERWORLD_X_COORDINATE = "Current Overworld X coordinate"
    CURRENT_OVERWORLD_Y_COORDINATE = "Current Overworld Y coordinate"

    WALLET_SIZE = "Wallet Size"
    HEART_PIECES = "Heart Pieces"
    LINKS_CURRENT_HEALTH = "Link's Current Health"
    LINKS_MAX_HEALTH = "Link's Max Health"
    BOMB_COUNT = "Bomb Count"
    ARROW_COUNT = "Arrow Count"
    BOMB_BAG = "Bomb Bag"
    QUIVER = "Quiver"
    FIGURINE_COUNT = "Amount of Figurines"
    COLLECTED_ALL_FIGURINES = "Collected All Figurines"
    ACTIVE_CHARM = "Active Charm"
    ACTIVE_PICOLYTE = "Active Picolyte"
    A_BUTTON_ITEMS = "A Button Items"
    B_BUTTON_ITEMS = "B Button Items"
    BOTTLE_1_CONTENTS = "Bottle 1 Contents"
    BOTTLE_2_CONTENTS = "Bottle 2 Contents"
    BOTTLE_3_CONTENTS = "Bottle 3 Contents"
    BOTTLE_4_CONTENTS = "Bottle 4 Contents"
    EFFECT = "Effect"
    MYSTERIOUS_SHELLS_DISABLED = "Mysterious Shells Disabled"
    RUPEES = "Rupees"
    MYSTERIOUS_SHELLS = "Mysterious Shells"
    CHARM_TIMER = "Charm Timer"
    PICOLYTE_TIMER = "Picolyte Timer"
    FIGURINE_COLLECTED_FLAGS = "Figurine Collected Flags"
    INVENTORY = "Inventory"

    DONE_ALL_FUSIONS = "Done all Fusions"
    FUSIONS_COUNT = "Amount of Fuses Done"

    KINSTONE_TYPE_IN_SLOT_1 = "Type of Kinstone in Slot 1"
    KINSTONE_TYPE_IN_SLOT_2 = "Type of Kinstone in Slot 2"
    KINSTONE_TYPE_IN_SLOT_3 = "Type of Kinstone in Slot 3"
    KINSTONE_TYPE_IN_SLOT_4 = "Type of Kinstone in Slot 4"
    KINSTONE_TYPE_IN_SLOT_5 = "Type of Kinstone in Slot 5"
    KINSTONE_TYPE_IN_SLOT_6 = "Type of Kinstone in Slot 6"
    KINSTONE_TYPE_IN_SLOT_7 = "Type of Kinstone in Slot 7"
    KINSTONE_TYPE_IN_SLOT_8 = "Type of Kinstone in Slot 8"
    KINSTONE_TYPE_IN_SLOT_9 = "Type of Kinstone in Slot 9"
    KINSTONE_TYPE_IN_SLOT_10 = "Type of Kinstone in Slot 10"
    KINSTONE_TYPE_IN_SLOT_11 = "Type of Kinstone in Slot 11"
    KINSTONE_TYPE_IN_SLOT_12 = "Type of Kinstone in Slot 12"
    KINSTONE_TYPE_IN_SLOT_13 = "Type of Kinstone in Slot 13"
    KINSTONE_TYPE_IN_SLOT_14 = "Type of Kinstone in Slot 14"
    KINSTONE_TYPE_IN_SLOT_15 = "Type of Kinstone in Slot 15"
    KINSTONE_TYPE_IN_SLOT_16 = "Type of Kinstone in Slot 16"
    KINSTONE_TYPE_IN_SLOT_17 = "Type of Kinstone in Slot 17"
    KINSTONE_TYPE_IN_SLOT_18 = "Type of Kinstone in Slot 18"
    KINSTONE_TYPE_IN_SLOT_19 = "Type of Kinstone in Slot 19"

    KINSTONE_COUNT_IN_SLOT_1 = "Amount of Kinstone in Slot 1"
    KINSTONE_COUNT_IN_SLOT_2 = "Amount of Kinstone in Slot 2"
    KINSTONE_COUNT_IN_SLOT_3 = "Amount of Kinstone in Slot 3"
    KINSTONE_COUNT_IN_SLOT_4 = "Amount of Kinstone in Slot 4"
    KINSTONE_COUNT_IN_SLOT_5 = "Amount of Kinstone in Slot 5"
    KINSTONE_COUNT_IN_SLOT_6 = "Amount of Kinstone in Slot 6"
    KINSTONE_COUNT_IN_SLOT_7 = "Amount of Kinstone in Slot 7"
    KINSTONE_COUNT_IN_SLOT_8 = "Amount of Kinstone in Slot 8"
    KINSTONE_COUNT_IN_SLOT_9 = "Amount of Kinstone in Slot 9"
    KINSTONE_COUNT_IN_SLOT_10 = "Amount of Kinstone in Slot 10"
    KINSTONE_COUNT_IN_SLOT_11 = "Amount of Kinstone in Slot 11"
    KINSTONE_COUNT_IN_SLOT_12 = "Amount of Kinstone in Slot 12"
    KINSTONE_COUNT_IN_SLOT_13 = "Amount of Kinstone in Slot 13"
    KINSTONE_COUNT_IN_SLOT_14 = "Amount of Kinstone in Slot 14"
    KINSTONE_COUNT_IN_SLOT_15 = "Amount of Kinstone in Slot 15"
    KINSTONE_COUNT_IN_SLOT_16 = "Amount of Kinstone in Slot 16"
    KINSTONE_COUNT_IN_SLOT_17 = "Amount of Kinstone in Slot 17"
    KINSTONE_COUNT_IN_SLOT_18 = "Amount of Kinstone in Slot 18"
    KINSTONE_COUNT_IN_SLOT_19 = "Amount of Kinstone in Slot 19"

    SMITH_LINKS_HOUSE_FUSIONS_COMPLETED = "Smith (Link's House) Fusions Completed"
    KING_DALTUS_MISSING_FUSIONS_COMPLETED = "King Daltus (Missing) Fusions Completed"
    MINISTER_POTHO_MISSING_FUSIONS_COMPLETED = "Minister Potho (Missing) Fusions Completed"
    MAYOR_HAGEN_TOWN_FUSIONS_COMPLETED = "Mayor Hagen (Town) Fusions Completed"
    STURGEON_LIBRARY_UPSTAIRS_FUSIONS_COMPLETED = "Sturgeon (Library Upstairs) Fusions Completed"
    GRAYBLADE_CRENEL_DOJO_FUSIONS_COMPLETED = "Grayblade (Crenel Dojo) Fusions Completed"
    WAVEBLADE_LAKE_DOJO_FUSIONS_COMPLETED = "Waveblade (Lake Dojo) Fusions Completed"
    GRIMBLADE_CASTLE_DOJO_FUSIONS_COMPLETED = "Grimblade (Castle Dojo) Fusions Completed"
    CRENEL_HERMIT_FUSIONS_COMPLETED = "Crenel Hermit Fusions Completed"
    ANJU_CUCCO_LADY_FUSIONS_COMPLETED = "Anju (Cucco Lady) Fusions Completed"
    TINA_SCHOOL_PINK_TEACHER_FUSIONS_COMPLETED = "Tina (School Pink Teacher) Fusions Completed"
    JOEL_SCHOOL_SLEEPING_BOY_FUSIONS_COMPLETED = "Joel (School Sleeping Boy) Fusions Completed"
    HARRISON_SCHOOL_TWIN_BOY_FUSIONS_COMPLETED = "Harrison (School Twin Boy) Fusions Completed"
    ERIK_SCHOOL_TWIN_BOY_FUSIONS_COMPLETED = "Erik (School Twin Boy) Fusions Completed"
    JIM_SCHOOL_READING_BOY_FUSIONS_COMPLETED = "Jim (School Reading Boy) Fusions Completed"
    BERRY_SCHOOL_BRUNETTE_GIRL_FUSIONS_COMPLETED = "Berry (School Brunette Girl) Fusions Completed"
    LEILA_SCHOOL_BLONDE_GIRL_FUSIONS_COMPLETED = "Leila (School Blonde Girl) Fusions Completed"
    MAMA_CAFE_BLONDE_LADY_FUSIONS_COMPLETED = "Mama (Cafe Blonde Lady) Fusions Completed"
    BARIS_CAFE_SAT_MAN_FUSIONS_COMPLETED = "Baris (Cafe Sat Man) Fusions Completed"
    CHAI_CAFE_SAT_LADY_FUSIONS_COMPLETED = "Chai (Cafe Sat Lady) Fusions Completed"
    HERB_OUTSIDE_CAFE_MAN_FUSIONS_COMPLETED = "Herb (Outside Cafe Man) Fusions Completed"
    JASMINE_OUTSIDE_CAFE_LADY_FUSIONS_COMPLETED = "Jasmine (Outside Cafe Lady) Fusions Completed"
    BREVE_CAFE_OLD_LADY_FUSIONS_COMPLETED = "Breve (Cafe Old Lady) Fusions Completed"
    BINDLE_INN_1F_MAN_FUSIONS_COMPLETED = "Bindle (Inn 1F Man) Fusions Completed"
    SATCHEL_INN_SITTING_FUSIONS_COMPLETED = "Satchel (Inn Sitting) Fusions Completed"
    BROCCO_MARKET_VEG_FUSIONS_COMPLETED = "Brocco (Market Veg) Fusions Completed"
    PINA_MARKET_FRUIT_FUSIONS_COMPLETED = "Pina (Market Fruit) Fusions Completed"
    POSTMAN_TOWN_FUSIONS_COMPLETED = "Postman (Town) Fusions Completed"
    ZILL_LIBRARY_ROOF_SNOTTY_BOY_FUSIONS_COMPLETED = "Zill (Library Roof Snotty Boy) Fusions Completed"
    LOLLY_LIBRARY_ROOF_MIDDLE_BOY_FUSIONS_COMPLETED = "Lolly (Library Roof Middle Boy) Fusions Completed"
    CANDY_LIBRARY_ROOF_GIRL_FUSIONS_COMPLETED = "Candy (Library Roof Girl) Fusions Completed"
    MUTOH_CARPENTER_BOSS_FUSIONS_COMPLETED = "Mutoh (Carpenter Boss) Fusions Completed"
    MACK_CARPENTER_FUSIONS_COMPLETED = "Mack (Carpenter) Fusions Completed"
    DOYLE_CARPENTER_FUSIONS_COMPLETED = "Doyle (Carpenter) Fusions Completed"
    BREMOR_MISSING_CARPENTER_FUSIONS_COMPLETED = "Bremor (Missing Carpenter) Fusions Completed"
    BRENT_CARPENTER_FUSIONS_COMPLETED = "Brent (Carpenter) Fusions Completed"
    ROMIO_TOWN_FUSIONS_COMPLETED = "Romio (Town) Fusions Completed"
    JULIETTA_MISSING_FUSIONS_COMPLETED = "Julietta (Missing) Fusions Completed"
    VERONA_MISSING_JULIET_MOM_FUSIONS_COMPLETED = "Verona (Missing Juliet Mom) Fusions Completed"
    ANTON_BARLOV_SHOP_FUSIONS_COMPLETED = "Anton (Barlov Shop) Fusions Completed"
    SHEILA_TOWN_BELL_BLONDE_FUSIONS_COMPLETED = "Sheila (Town Bell Blonde) Fusions Completed"
    JUNE_BRUNETTE_NEAR_CAFE_FUSIONS_COMPLETED = "June (Brunette near Cafe) Fusions Completed"
    KEELEY_MARKET_BLONDE_LADY_FUSIONS_COMPLETED = "Keeley (Market Blonde Lady) Fusions Completed"
    HURDY_GURDY_MAN_CAFE_FUSIONS_COMPLETED = "Hurdy-Gurdy Man (Cafe) Fusions Completed"
    KLAUS_OLD_MAN_LIBRARY_FUSIONS_COMPLETED = "Klaus (Old Man Library) Fusions Completed"
    MARSHALL_OLD_MAN_NEAR_INN_FUSIONS_COMPLETED = "Marshall (Old Man near Inn) Fusions Completed"
    DOTTIE_MARKET_OLD_LADY_FUSIONS_COMPLETED = "Dottie (Market Old Lady) Fusions Completed"
    STRANGER_TOWN_FUSIONS_COMPLETED = "Stranger (Town) Fusions Completed"
    GALE_CLOUDS_WIND_TRIBE_1F_FUSIONS_COMPLETED = "Gale (Clouds + Wind Tribe 1F) Fusions Completed"
    CAPRICE_WIND_TRIBE_2F_UPPER_FUSIONS_COMPLETED = "Caprice (Wind Tribe 2F Upper) Fusions Completed"
    HAILEY_CLOUDS_WIND_TRIBE_UPPER_BLOCKER_FUSIONS_COMPLETED = "Hailey (Clouds + Wind Tribe Upper Blocker) Fusions Completed"
    SIROC_WIND_TRIBE_OLD_LADY_FUSIONS_COMPLETED = "Siroc (Wind Tribe Old Lady) Fusions Completed"
    FLURRIS_WIND_TRIBE_LOWER_BLOCKER_FUSIONS_COMPLETED = "Flurris (Wind Tribe Lower Blocker) Fusions Completed"
    GREGAL_WIND_TRIBE_OLD_MAN_FUSIONS_COMPLETED = "Gregal (Wind Tribe Old Man) Fusions Completed"
    TALON_LONLON_RANCH_FUSIONS_COMPLETED = "Talon (LonLon Ranch) Fusions Completed"
    MALON_TOWN_FUSIONS_COMPLETED = "Malon (Town) Fusions Completed"
    EPONA_TOWN_FUSIONS_COMPLETED = "Epona (Town) Fusions Completed"
    DAMPE_GRAVEYARD_FUSIONS_COMPLETED = "Dampé (Graveyard) Fusions Completed"
    TINGLE_SOUTH_FIELD_FUSIONS_COMPLETED = "Tingle (South Field) Fusions Completed"
    ANKLE_LONLON_TINGLE_FUSIONS_COMPLETED = "Ankle (LonLon Tingle) Fusions Completed"
    KNUCKLE_TRILBY_TINGLE_FUSIONS_COMPLETED = "Knuckle (Trilby Tingle) Fusions Completed"
    DAVID_JR_LAKE_TINGLE_FUSIONS_COMPLETED = "David Jr. (Lake Tingle) Fusions Completed"
    EENIE_UPPER_FARMER_FUSIONS_COMPLETED = "Eenie (Upper Farmer) Fusions Completed"
    MEENIE_LOWER_FARMER_FUSIONS_COMPLETED = "Meenie (Lower Farmer) Fusions Completed"
    PERCY_WESTERN_WOODS_FUSIONS_COMPLETED = "Percy (Western Woods) Fusions Completed"
    NAYRU_TOWN_INN_FUSIONS_COMPLETED = "Nayru (Town Inn) Fusions Completed"
    FARORE_TOWN_INN_FUSIONS_COMPLETED = "Farore (Town Inn) Fusions Completed"
    DIN_TOWN_INN_FUSIONS_COMPLETED = "Din (Town Inn) Fusions Completed"
    SPOOKTER_GRAVEYARD_GHOST_FUSIONS_COMPLETED = "Spookter (Graveyard Ghost) Fusions Completed"
    GINA_PINK_GHOST_FUSIONS_COMPLETED = "Gina (Pink Ghost) Fusions Completed"
    FESTARI_VILLAGE_PRIEST_FUSIONS_COMPLETED = "Festari (Village Priest) Fusions Completed"
    GENTARI_VILLAGE_ELDER_FUSIONS_COMPLETED = "Gentari (Village Elder) Fusions Completed"
    VILLAGE_BARREL_TOP_MINISH_FUSIONS_COMPLETED = "Village Barrel Top Minish Fusions Completed"
    VILLAGE_BARREL_LADDER_MINISH_FUSIONS_COMPLETED = "Village Barrel Ladder Minish Fusions Completed"
    VILLAGE_VASE_HOUSE_MINISH__FUSIONS_COMPLETED = "Village Vase House Minish  Fusions Completed"
    VILLAGE_GREEN_HOUSE_MINISH_FUSIONS_COMPLETED = "Village Green House Minish Fusions Completed"
    VILLAGE_LAKE_MINISH_FUSIONS_COMPLETED = "Village Lake Minish Fusions Completed"
    MELARI_CRENEL_FUSIONS_COMPLETED = "Melari (Crenel) Fusions Completed"
    MELARI_KITCHEN_MINISH_FUSIONS_COMPLETED = "Melari Kitchen Minish Fusions Completed"
    MELARI_NEAR_BEDROOM_MINISH_FUSIONS_COMPLETED = "Melari Near Bedroom Minish Fusions Completed"
    MELARI_EXIT_MINISH_FUSIONS_COMPLETED = "Melari Exit Minish Fusions Completed"
    MELARI_TOP_LEFT_MINISH_FUSIONS_COMPLETED = "Melari Top Left Minish Fusions Completed"
    WESTERN_WOODS_MINISH_FUSIONS_COMPLETED = "Western Woods Minish Fusions Completed"
    SOUTH_FIELD_MINISH_FUSIONS_COMPLETED = "South Field Minish Fusions Completed"
    TRILBY_MINISH_FUSIONS_COMPLETED = "Trilby Minish Fusions Completed"
    HILLS_MINISH_FUSIONS_COMPLETED = "Hills Minish Fusions Completed"
    TOWN_MUSHROOM_MINISH_FUSIONS_COMPLETED = "Town Mushroom Minish Fusions Completed"
    BELARI_BOMB_MINISH_FUSIONS_COMPLETED = "Belari (Bomb Minish) Fusions Completed"
    LAKE_CREST_MINISH_FUSIONS_COMPLETED = "Lake Crest Minish Fusions Completed"
    LAKE_EAST_MINISH_FUSIONS_COMPLETED = "Lake East Minish Fusions Completed"
    CASTLE_MINISH_FUSIONS_COMPLETED = "Castle Minish Fusions Completed"
    CRENEL_BASE_MINISH_FUSIONS_COMPLETED = "Crenel Base Minish Fusions Completed"
    NORTH_FIELD_MINISH_FUSIONS_COMPLETED = "North Field Minish Fusions Completed"
    RUINS_MINISH_FUSIONS_COMPLETED = "Ruins Minish Fusions Completed"
    CARPENTER_MINISH_FUSIONS_COMPLETED = "Carpenter Minish Fusions Completed"
    CAFE_FOREST_MINISH_FUSIONS_COMPLETED = "Cafe Forest Minish Fusions Completed"
    CAFE_MINISH_LEFT_FUSIONS_COMPLETED = "Cafe Minish (Left) Fusions Completed"
    CAFE_MINISH_RIGHT_FUSIONS_COMPLETED = "Cafe Minish (Right) Fusions Completed"
    LIBRARY_MINISH_BLUE_FUSIONS_COMPLETED = "Library Minish (Blue) Fusions Completed"
    LIBRARI_FUSIONS_COMPLETED = "Librari Fusions Completed"
    LIBRARY_MINISH_YELLOW_FUSIONS_COMPLETED = "Library Minish (Yellow) Fusions Completed"
    TRILBY_MYSTERIOUS_WALL_FUSIONS_COMPLETED = "Trilby Mysterious Wall Fusions Completed"
    HILLS_MYSTERIOUS_WALL_FUSIONS_COMPLETED = "Hills Mysterious Wall Fusions Completed"
    CRENEL_MYSTERIOUS_WALL_FUSIONS_COMPLETED = "Crenel Mysterious Wall Fusions Completed"
    MINISH_MYSTERIOUS_WALL_FUSIONS_COMPLETED = "Minish Mysterious Wall Fusions Completed"
    LAKE_MYSTERIOUS_WALL_FUSIONS_COMPLETED = "Lake Mysterious Wall Fusions Completed"
    LEFT_GORON_FUSIONS_COMPLETED = "Left Goron Fusions Completed"
    RIGHT_GORON_FUSIONS_COMPLETED = "Right Goron Fusions Completed"
    CRENEL_BUSINESS_SCRUB_FUSIONS_COMPLETED = "Crenel Business Scrub Fusions Completed"
    SWAMP_BUSINESS_SCRUB_FUSIONS_COMPLETED = "Swamp Business Scrub Fusions Completed"
    MINISH_BUSINESS_SCRUB_FUSIONS_COMPLETED = "Minish Business Scrub Fusions Completed"
    BORKEN_FIFI_LAKE_DOG_FUSIONS_COMPLETED = "Borken/Fifi (Lake Dog) Fusions Completed"
    ROLF_ROMEO_DOG_FUSIONS_COMPLETED = "Rolf (Romeo Dog) Fusions Completed"
    GROWLER_WEST_DOG_FUSIONS_COMPLETED = "Growler (West Dog) Fusions Completed"
    SCRATCHER_JULIET_CAT_FUSIONS_COMPLETED = "Scratcher (Juliet Cat) Fusions Completed"
    PURRY_BRIDGE_CAT_FUSIONS_COMPLETED = "Purry (Bridge Cat) Fusions Completed"
    ROOF_CUCCO_FUSIONS_COMPLETED = "Roof Cucco Fusions Completed"
    CUCCO_CHICK_FUSIONS_COMPLETED = "Cucco Chick Fusions Completed"
    ELSIE_LONLON_COW_FUSIONS_COMPLETED = "Elsie (LonLon Cow) Fusions Completed"

    SMITH_LINKS_HOUSE_FUSIONS_OFFERED = "Smith (Link's House) Fusions Offered"
    KING_DALTUS_MISSING_FUSIONS_OFFERED = "King Daltus (Missing) Fusions Offered"
    MINISTER_POTHO_MISSING_FUSIONS_OFFERED = "Minister Potho (Missing) Fusions Offered"
    MAYOR_HAGEN_TOWN_FUSIONS_OFFERED = "Mayor Hagen (Town) Fusions Offered"
    STURGEON_LIBRARY_UPSTAIRS_FUSIONS_OFFERED = "Sturgeon (Library Upstairs) Fusions Offered"
    GRAYBLADE_CRENEL_DOJO_FUSIONS_OFFERED = "Grayblade (Crenel Dojo) Fusions Offered"
    WAVEBLADE_LAKE_DOJO_FUSIONS_OFFERED = "Waveblade (Lake Dojo) Fusions Offered"
    GRIMBLADE_CASTLE_DOJO_FUSIONS_OFFERED = "Grimblade (Castle Dojo) Fusions Offered"
    CRENEL_HERMIT_FUSIONS_OFFERED = "Crenel Hermit Fusions Offered"
    ANJU_CUCCO_LADY_FUSIONS_OFFERED = "Anju (Cucco Lady) Fusions Offered"
    TINA_SCHOOL_PINK_TEACHER_FUSIONS_OFFERED = "Tina (School Pink Teacher) Fusions Offered"
    JOEL_SCHOOL_SLEEPING_BOY_FUSIONS_OFFERED = "Joel (School Sleeping Boy) Fusions Offered"
    HARRISON_SCHOOL_TWIN_BOY_FUSIONS_OFFERED = "Harrison (School Twin Boy) Fusions Offered"
    ERIK_SCHOOL_TWIN_BOY_FUSIONS_OFFERED = "Erik (School Twin Boy) Fusions Offered"
    JIM_SCHOOL_READING_BOY_FUSIONS_OFFERED = "Jim (School Reading Boy) Fusions Offered"
    BERRY_SCHOOL_BRUNETTE_GIRL_FUSIONS_OFFERED = "Berry (School Brunette Girl) Fusions Offered"
    LEILA_SCHOOL_BLONDE_GIRL_FUSIONS_OFFERED = "Leila (School Blonde Girl) Fusions Offered"
    MAMA_CAFE_BLONDE_LADY_FUSIONS_OFFERED = "Mama (Cafe Blonde Lady) Fusions Offered"
    BARIS_CAFE_SAT_MAN_FUSIONS_OFFERED = "Baris (Cafe Sat Man) Fusions Offered"
    CHAI_CAFE_SAT_LADY_FUSIONS_OFFERED = "Chai (Cafe Sat Lady) Fusions Offered"
    HERB_OUTSIDE_CAFE_MAN_FUSIONS_OFFERED = "Herb (Outside Cafe Man) Fusions Offered"
    JASMINE_OUTSIDE_CAFE_LADY_FUSIONS_OFFERED = "Jasmine (Outside Cafe Lady) Fusions Offered"
    BREVE_CAFE_OLD_LADY_FUSIONS_OFFERED = "Breve (Cafe Old Lady) Fusions Offered"
    BINDLE_INN_1F_MAN_FUSIONS_OFFERED = "Bindle (Inn 1F Man) Fusions Offered"
    SATCHEL_INN_SITTING_FUSIONS_OFFERED = "Satchel (Inn Sitting) Fusions Offered"
    BROCCO_MARKET_VEG_FUSIONS_OFFERED = "Brocco (Market Veg) Fusions Offered"
    PINA_MARKET_FRUIT_FUSIONS_OFFERED = "Pina (Market Fruit) Fusions Offered"
    POSTMAN_TOWN_FUSIONS_OFFERED = "Postman (Town) Fusions Offered"
    ZILL_LIBRARY_ROOF_SNOTTY_BOY_FUSIONS_OFFERED = "Zill (Library Roof Snotty Boy) Fusions Offered"
    LOLLY_LIBRARY_ROOF_MIDDLE_BOY_FUSIONS_OFFERED = "Lolly (Library Roof Middle Boy) Fusions Offered"
    CANDY_LIBRARY_ROOF_GIRL_FUSIONS_OFFERED = "Candy (Library Roof Girl) Fusions Offered"
    MUTOH_CARPENTER_BOSS_FUSIONS_OFFERED = "Mutoh (Carpenter Boss) Fusions Offered"
    MACK_CARPENTER_FUSIONS_OFFERED = "Mack (Carpenter) Fusions Offered"
    DOYLE_CARPENTER_FUSIONS_OFFERED = "Doyle (Carpenter) Fusions Offered"
    BREMOR_MISSING_CARPENTER_FUSIONS_OFFERED = "Bremor (Missing Carpenter) Fusions Offered"
    BRENT_CARPENTER_FUSIONS_OFFERED = "Brent (Carpenter) Fusions Offered"
    ROMIO_TOWN_FUSIONS_OFFERED = "Romio (Town) Fusions Offered"
    JULIETTA_MISSING_FUSIONS_OFFERED = "Julietta (Missing) Fusions Offered"
    VERONA_MISSING_JULIET_MOM_FUSIONS_OFFERED = "Verona (Missing Juliet Mom) Fusions Offered"
    ANTON_BARLOV_SHOP_FUSIONS_OFFERED = "Anton (Barlov Shop) Fusions Offered"
    SHEILA_TOWN_BELL_BLONDE_FUSIONS_OFFERED = "Sheila (Town Bell Blonde) Fusions Offered"
    JUNE_BRUNETTE_NEAR_CAFE_FUSIONS_OFFERED = "June (Brunette near Cafe) Fusions Offered"
    KEELEY_MARKET_BLONDE_LADY_FUSIONS_OFFERED = "Keeley (Market Blonde Lady) Fusions Offered"
    HURDY_GURDY_MAN_CAFE_FUSIONS_OFFERED = "Hurdy-Gurdy Man (Cafe) Fusions Offered"
    KLAUS_OLD_MAN_LIBRARY_FUSIONS_OFFERED = "Klaus (Old Man Library) Fusions Offered"
    MARSHALL_OLD_MAN_NEAR_INN_FUSIONS_OFFERED = "Marshall (Old Man near Inn) Fusions Offered"
    DOTTIE_MARKET_OLD_LADY_FUSIONS_OFFERED = "Dottie (Market Old Lady) Fusions Offered"
    STRANGER_TOWN_FUSIONS_OFFERED = "Stranger (Town) Fusions Offered"
    GALE_CLOUDS_WIND_TRIBE_1F_FUSIONS_OFFERED = "Gale (Clouds + Wind Tribe 1F) Fusions Offered"
    CAPRICE_WIND_TRIBE_2F_UPPER_FUSIONS_OFFERED = "Caprice (Wind Tribe 2F Upper) Fusions Offered"
    HAILEY_CLOUDS_WIND_TRIBE_UPPER_BLOCKER_FUSIONS_OFFERED = "Hailey (Clouds + Wind Tribe Upper Blocker) Fusions Offered"
    SIROC_WIND_TRIBE_OLD_LADY_FUSIONS_OFFERED = "Siroc (Wind Tribe Old Lady) Fusions Offered"
    FLURRIS_WIND_TRIBE_LOWER_BLOCKER_FUSIONS_OFFERED = "Flurris (Wind Tribe Lower Blocker) Fusions Offered"
    GREGAL_WIND_TRIBE_OLD_MAN_FUSIONS_OFFERED = "Gregal (Wind Tribe Old Man) Fusions Offered"
    TALON_LONLON_RANCH_FUSIONS_OFFERED = "Talon (LonLon Ranch) Fusions Offered"
    MALON_TOWN_FUSIONS_OFFERED = "Malon (Town) Fusions Offered"
    EPONA_TOWN_FUSIONS_OFFERED = "Epona (Town) Fusions Offered"
    DAMPE_GRAVEYARD_FUSIONS_OFFERED = "Dampé (Graveyard) Fusions Offered"
    TINGLE_SOUTH_FIELD_FUSIONS_OFFERED = "Tingle (South Field) Fusions Offered"
    ANKLE_LONLON_TINGLE_FUSIONS_OFFERED = "Ankle (LonLon Tingle) Fusions Offered"
    KNUCKLE_TRILBY_TINGLE_FUSIONS_OFFERED = "Knuckle (Trilby Tingle) Fusions Offered"
    DAVID_JR_LAKE_TINGLE_FUSIONS_OFFERED = "David Jr. (Lake Tingle) Fusions Offered"
    EENIE_UPPER_FARMER_FUSIONS_OFFERED = "Eenie (Upper Farmer) Fusions Offered"
    MEENIE_LOWER_FARMER_FUSIONS_OFFERED = "Meenie (Lower Farmer) Fusions Offered"
    PERCY_WESTERN_WOODS_FUSIONS_OFFERED = "Percy (Western Woods) Fusions Offered"
    NAYRU_TOWN_INN_FUSIONS_OFFERED = "Nayru (Town Inn) Fusions Offered"
    FARORE_TOWN_INN_FUSIONS_OFFERED = "Farore (Town Inn) Fusions Offered"
    DIN_TOWN_INN_FUSIONS_OFFERED = "Din (Town Inn) Fusions Offered"
    SPOOKTER_GRAVEYARD_GHOST_FUSIONS_OFFERED = "Spookter (Graveyard Ghost) Fusions Offered"
    GINA_PINK_GHOST_FUSIONS_OFFERED = "Gina (Pink Ghost) Fusions Offered"
    FESTARI_VILLAGE_PRIEST_FUSIONS_OFFERED = "Festari (Village Priest) Fusions Offered"
    GENTARI_VILLAGE_ELDER_FUSIONS_OFFERED = "Gentari (Village Elder) Fusions Offered"
    VILLAGE_BARREL_TOP_MINISH_FUSIONS_OFFERED = "Village Barrel Top Minish Fusions Offered"
    VILLAGE_BARREL_LADDER_MINISH_FUSIONS_OFFERED = "Village Barrel Ladder Minish Fusions Offered"
    VILLAGE_VASE_HOUSE_MINISH__FUSIONS_OFFERED = "Village Vase House Minish  Fusions Offered"
    VILLAGE_GREEN_HOUSE_MINISH_FUSIONS_OFFERED = "Village Green House Minish Fusions Offered"
    VILLAGE_LAKE_MINISH_FUSIONS_OFFERED = "Village Lake Minish Fusions Offered"
    MELARI_CRENEL_FUSIONS_OFFERED = "Melari (Crenel) Fusions Offered"
    MELARI_KITCHEN_MINISH_FUSIONS_OFFERED = "Melari Kitchen Minish Fusions Offered"
    MELARI_NEAR_BEDROOM_MINISH_FUSIONS_OFFERED = "Melari Near Bedroom Minish Fusions Offered"
    MELARI_EXIT_MINISH_FUSIONS_OFFERED = "Melari Exit Minish Fusions Offered"
    MELARI_TOP_LEFT_MINISH_FUSIONS_OFFERED = "Melari Top Left Minish Fusions Offered"
    WESTERN_WOODS_MINISH_FUSIONS_OFFERED = "Western Woods Minish Fusions Offered"
    SOUTH_FIELD_MINISH_FUSIONS_OFFERED = "South Field Minish Fusions Offered"
    TRILBY_MINISH_FUSIONS_OFFERED = "Trilby Minish Fusions Offered"
    HILLS_MINISH_FUSIONS_OFFERED = "Hills Minish Fusions Offered"
    TOWN_MUSHROOM_MINISH_FUSIONS_OFFERED = "Town Mushroom Minish Fusions Offered"
    BELARI_BOMB_MINISH_FUSIONS_OFFERED = "Belari (Bomb Minish) Fusions Offered"
    LAKE_CREST_MINISH_FUSIONS_OFFERED = "Lake Crest Minish Fusions Offered"
    LAKE_EAST_MINISH_FUSIONS_OFFERED = "Lake East Minish Fusions Offered"
    CASTLE_MINISH_FUSIONS_OFFERED = "Castle Minish Fusions Offered"
    CRENEL_BASE_MINISH_FUSIONS_OFFERED = "Crenel Base Minish Fusions Offered"
    NORTH_FIELD_MINISH_FUSIONS_OFFERED = "North Field Minish Fusions Offered"
    RUINS_MINISH_FUSIONS_OFFERED = "Ruins Minish Fusions Offered"
    CARPENTER_MINISH_FUSIONS_OFFERED = "Carpenter Minish Fusions Offered"
    CAFE_FOREST_MINISH_FUSIONS_OFFERED = "Cafe Forest Minish Fusions Offered"
    CAFE_MINISH_LEFT_FUSIONS_OFFERED = "Cafe Minish (Left) Fusions Offered"
    CAFE_MINISH_RIGHT_FUSIONS_OFFERED = "Cafe Minish (Right) Fusions Offered"
    LIBRARY_MINISH_BLUE_FUSIONS_OFFERED = "Library Minish (Blue) Fusions Offered"
    LIBRARI_FUSIONS_OFFERED = "Librari Fusions Offered"
    LIBRARY_MINISH_YELLOW_FUSIONS_OFFERED = "Library Minish (Yellow) Fusions Offered"
    TRILBY_MYSTERIOUS_WALL_FUSIONS_OFFERED = "Trilby Mysterious Wall Fusions Offered"
    HILLS_MYSTERIOUS_WALL_FUSIONS_OFFERED = "Hills Mysterious Wall Fusions Offered"
    CRENEL_MYSTERIOUS_WALL_FUSIONS_OFFERED = "Crenel Mysterious Wall Fusions Offered"
    MINISH_MYSTERIOUS_WALL_FUSIONS_OFFERED = "Minish Mysterious Wall Fusions Offered"
    LAKE_MYSTERIOUS_WALL_FUSIONS_OFFERED = "Lake Mysterious Wall Fusions Offered"
    LEFT_GORON_FUSIONS_OFFERED = "Left Goron Fusions Offered"
    RIGHT_GORON_FUSIONS_OFFERED = "Right Goron Fusions Offered"
    CRENEL_BUSINESS_SCRUB_FUSIONS_OFFERED = "Crenel Business Scrub Fusions Offered"
    SWAMP_BUSINESS_SCRUB_FUSIONS_OFFERED = "Swamp Business Scrub Fusions Offered"
    MINISH_BUSINESS_SCRUB_FUSIONS_OFFERED = "Minish Business Scrub Fusions Offered"
    BORKEN_FIFI_LAKE_DOG_FUSIONS_OFFERED = "Borken/Fifi (Lake Dog) Fusions Offered"
    ROLF_ROMEO_DOG_FUSIONS_OFFERED = "Rolf (Romeo Dog) Fusions Offered"
    GROWLER_WEST_DOG_FUSIONS_OFFERED = "Growler (West Dog) Fusions Offered"
    SCRATCHER_JULIET_CAT_FUSIONS_OFFERED = "Scratcher (Juliet Cat) Fusions Offered"
    PURRY_BRIDGE_CAT_FUSIONS_OFFERED = "Purry (Bridge Cat) Fusions Offered"
    ROOF_CUCCO_FUSIONS_OFFERED = "Roof Cucco Fusions Offered"
    CUCCO_CHICK_FUSIONS_OFFERED = "Cucco Chick Fusions Offered"
    ELSIE_LONLON_COW_FUSIONS_OFFERED = "Elsie (LonLon Cow) Fusions Offered"

    COMPLETED_FUSIONS = "Completed Fusions"
    FUSION_MAP_ICON_FLAGS = "Fusion Map Icon Flags"

    GLOBAL_FLAGS = "Global Flags"
    UNUSED_DUNGEON_FLAGS = "Unused Dungeon Flags"
    REPEATING_SIMON_SIMULATION_FLAG = "Repeating Simon Simulation Flag"
    OVERWORLD_FLAGS = "Overworld Flags"
    OVERWORLD_CAVE_FLAGS = "Overworld Cave Flags"
    DWS_FLAGS = "Deepwood Flags"
    COF_FLAGS = "Cave of Flames Flags"
    FOW_FLAGS = "Fortress Flags"
    TOD_FLAGS = "Droplets Flags"
    POW_FLAGS = "Palace Flags"
    DHC_FLAGS = "DHC Flags"

    UNUSED_D1_SMALL_KEYS = "Unused Dungeon 1 Small Keys"
    DWS_SMALL_KEYS = "Deepwood Shrine Small Keys"
    COF_SMALL_KEYS = "Cave of Flames Small Keys"
    FOW_SMALL_KEYS = "Fortress of Winds Small Keys"
    TOD_SMALL_KEYS = "Temple of Droplets Small Keys"
    POW_SMALL_KEYS = "Palace of Winds Small Keys"
    DHC_SMALL_KEYS = "Dark Hyrule Castle Small Keys"
    RC_SMALL_KEYS = "Royal Crypt Small Keys"
    UNUSED_D2_SMALL_KEYS = "Unused Dungeon 2 Small Keys"

    UNUSED_D1_DUNGEON_ITEMS = "Unused Dungeon 1 Dungeon Items"
    DWS_DUNGEON_ITEMS = "Deepwood Shrine Dungeon Items"
    COF_DUNGEON_ITEMS = "Cave of Flames Dungeon Items"
    FOW_DUNGEON_ITEMS = "Fortress of Winds Dungeon Items"
    TOD_DUNGEON_ITEMS = "Temple of Droplets Dungeon Items"
    POW_DUNGEON_ITEMS = "Palace of Winds Dungeon Items"
    DHC_DUNGEON_ITEMS = "Dark Hyrule Castle Dungeon Items"
    UNUSED_RC_DUNGEON_ITEMS = "Unused Royal Crypt Dungeon Items"
    UNUSED_D2_DUNGEON_ITEMS = "Unused Dungeon 2 Dungeon Items"

    UNUSED_D1_WARPS = "Unused Dungeon 1 Warps"
    DWS_WARPS = "Deepwood Shrine Warps"
    COF_WARPS = "Cave of Flames Warps"
    FOW_WARPS = "Fortress of Winds Warps"
    TOD_WARPS = "Temple of Droplets Warps"
    POW_WARPS = "Palace of Winds Warps"
    DHC_WARPS = "Dark Hyrule Castle Warps"
    UNUSED_RC_WARPS = "Royal Crypt Warps"
    UNUSED_D2_WARPS = "Unused Dungeon 2 Warps"

    VAATI_DARKNUT_TIMER = "Vaati Darknut Timer"
    STORED_KILL_COUNTER_FOR_PICO_BLOOMS = "Stored Kill counter for Pico Blooms"
    BIGGORON_SHIELD_TIMER = "Biggoron Shield Timer"
    VAATI_3_EZLO_CANE_HINT_TIMERUS = "Vaati 3 Ezlo Cane Hint Timer(US)"
    KIOSK_DEMO_TIMER = "Kiosk Demo Timer"


class TMCEvent:
    CRENEL_CREST = "Mt Crenel"
    FALLS_CREST = "Veil Falls"
    CLOUDS_CREST = "Cloud Tops"
    TOWN_CREST = "Hyrule Town"
    LAKE_CREST = "Lake Hylia"
    SWAMP_CREST = "Castor Wilds"
    SHF_CREST = "South Hyrule Field"
    MINISH_CREST = "Minish Woods"

    SIMON_CHEST_OPEN = "Simon Chest Opened"
    DEFEAT_GREEN_CHU = "Defeat Green Chu"
    DEFEAT_GLEEROK = "Defeat Gleerok"
    DEFEAT_MAZAAL = "Defeat Mazaal"
    DEFEAT_OCTO = "Defeat Octo"
    DEFEAT_GYORG = "Defeat Gyorg"

    TOWN_SUCK_DUST = "Sucked dust in market"
    MET_ZELDA = "Met Zelda"
    HAVE_EZLO = "Have Ezlo"
    INTRO_THRONE_CUTSCENE = "Seen Intro Throneroom Cutscene"
    DEEPWOOD_SUCKED_BARREL_WEB = "Deepwood Sucked Barrel Web"
    TOWN_RED_HOUSE = "Town Red House construction complete"
    TOWN_RED_HOUSE_FRAME = "Town Red House construction started"
    CRENEL_HOLDING_BEAN = "Crenel Holding Green Bean"
    CRENEL_PLACED_BEAN = "Crenel Placed Green Bean"
    ZELDA_FOLLOWS = "Zelda Follows Link"
    TALON_LLR_KEY = "Gave Key to Talon"
    EARLY_BOOTS_FLAG = "Read sign or visited swamp"
    DR_LEFT_DOOR = "Dr Left Door Unlocked"
    GRAVEYARD_KEY_LOST = "Graveyard Key Lost"
    GRAVEYARD_KEY_FOUND = "Graveyard Key Found"
    VEIL_FALLS_TORNADO = "Veil Falls Tornado Entered"
    CLOUD_TOPS_TORNADO = "Cloud Tops Tornado Spawned"
    BOOK_QUEST_START = "Book Quest Started"
    GREEN_BOOK_FALL = "Dr Left Green Book Falling"
    RENTED_HOUSE_DIN = "Din moves to Blue House"
    RENTED_HOUSE_NAYRU = "Nayru moves to Blue House"
    RENTED_HOUSE_FARORE = "Farore moves to Blue House"
    NEW_HOUSE_DIN = "Din moves to Red House"
    NEW_HOUSE_NAYRU = "Nayru moves to Red House"
    NEW_HOUSE_FARORE = "Farore moves to Red House"
    DEFEATED_RUINS_GOLDEN_OCTO = "Ruins Golden Octo Defeated"
    DEFEATED_CRENELBASE_GOLDEN_TEKTITE = "Crenel Base Golden Tektite Defeated"
    DEFEATED_SWAMP_GOLDEN_ROPE = "Swamp Golden Rope Defeated"
    DEFEATED_HILLS_GOLDEN_ROPE = "Hills Golden Rope Defeated"
    DEFEATED_GARDEN_GOLDEN_ROPE = "Castle Garden Golden Rope Defeated"
    DEFEATED_FALLS_GOLDEN_TEKTITE = "Veil Falls Golden Tektite Defeated"
    DEFEATED_CRENEL_GOLDEN_TEKTITE = "Crenel Golden Tektite Defeated"
    DEFEATED_MINISH_GOLDEN_OCTO = "Minish Woods Golden Octo Defeated"
    DEFEATED_WESTERN_GOLDEN_OCTO = "Western Woods Golden Octo Defeated"
    FUSIONS_COMPLETE = "Talk to Tingle with all fusions completed"
    YELLOW_PICO_BLOOM = "Yellow Pico Bloom"
    BLUE_PICO_BLOOM = "Blue Pico Bloom"
    ORANGE_PICO_BLOOM = "Orange Pico Bloom"
    GORON_MERCHANT_RESTOCK_LV2 = "Goron Merchant Restock LV2"
    GORON_MERCHANT_RESTOCK_LV3 = "Goron Merchant Restock LV3"
    GORON_MERCHANT_RESTOCK_LV4 = "Goron Merchant Restock LV4"
    GORON_MERCHANT_RESTOCK_LV5 = "Goron Merchant Restock LV5"
    GORON_MERCHANT_SOLD_L = "Goron Merchant Sold Left"
    GORON_MERCHANT_SOLD_M = "Goron Merchant Sold Middle"
    GORON_MERCHANT_SOLD_R = "Goron Merchant Sold Right"
    CASTLE_BASEMENT_DOOR_OPEN = "Castle Basement Door Opened"
    GORMAN_RENTED_HOUSE = "Gorman Renting Blue House"
    GORMAN_NEW_HOUSE = "Gorman Renting Red House"
    OUTDOOR = "Exit Link's House"
    FOUNTAIN_BLUE_MINISH = "Minish Blocking Fountain Moved"
    CUCCO_LV_BIT0 = "Cucco LV Bit0"
    CUCCO_LV_BIT1 = "Cucco LV Bit1"
    CUCCO_LV_BIT2 = "Cucco LV Bit2"
    CUCCO_LV_BIT3 = "Cucco LV Bit3"
    CUCCO_HEART = "Cucco Heartpiece"
    SIMON_WAKEUP = "Waking up in Simon's House"
    ENDING = "Vaati's Wrath Defeated"
    EZLO_OCARINA = "Ezlo talks about Ocarina the first time"
    EZLO_CREST = "Ezlo talks about crests the first time"
    PICO_BLOOM_ITEM = "Gave Pico Minish an item"
    GAMECLEAR = "Major Feat accomplished"
    MELARI_MOVE = "Move Melari and the Minish into side rooms"
    NORTH_FIELD_LADDER_SPAWN = "Spawns the ladder in North Hyrule Field"
    WIND_TRIBE_STATE = "Wind Tribe NPCs Moved"
    FIGURINE_COMPLETE = "Talked to Carlov after getting all figurines"
    SCRUB_BOTTLE = "Bought item from Deku Scrub"
    DOGFOOD_USE = "Gave Dogfood"
    TINGLE_SPAWN = "Spawn Tingle Brothers"
    SANCTUARY_BGM = "Tense music in Sanctuary"
    PORTAL_STUMP = "Seen Tree Stump Minish Portal Cutscene"
    PORTAL_ROCK = "Seen Rock Minish Portal Cutscene"
    PORTAL_POT = "Seen Pot Minish Portal Cutscene"
    BOOK_QUEST_RECEPTIONIST = "Spoke to the Receptionist to make Dr Left Door unlockable"
    MAZE_CLEAR = "Lost Woods Maze Jingle"
    EZLO_COF = "Ezlo talks about Minish Portals"
    CASTLE_BGM = "Castle background music during intro"

    UNUSED_DUNGEON_DOOR_1 = "Unused Dungeon 1st Room Door"
    UNUSED_DUNGEON_DOOR_2L = "Unused Dungeon 2nd Room Left Door"
    UNUSED_DUNGEON_DOOR_2R = "Unused Dungeon 2nd Room Right Door"
    UNUSED_DUNGEON_DOOR_3 = "Unused Dungeon 3rd Room Door"

    SIMON_REPEAT = "Entered Simon Simulation after already collecting the item"

    EZLO_DWS_CLEAR = "Ezlo Deepwood Cleared message seen"
    EZLO_COF_CLEAR = "Ezlo Cave of Flames Cleared message seen"
    EZLO_FOW_CLEAR = "Ezlo Fortress Cleared message seen"
    EZLO_TOD_CLEAR = "Ezlo Droplets Cleared message seen"
    EZLO_POW_CLEAR = "Ezlo Palace Cleared message seen"
    LAKE_BONK = "Bonked Lake Hylia Minish Portal Tree"
    LAKE_BOULDER = "Pushed Shortcut Boulder in Lake Hylia"
    LAKE_NORTH_HEART = "Collected Lake Hylia North Heart Piece"
    LAKE_POND_HEART = "Collected Lake Hylia Pond Heart Piece"
    LAKE_SOUTH_HEART = "Collected Lake Hylia South Heart Piece"
    SWAMP_CHEST = "Opened Chest in the middle of swamp"
    GARDEN_CASTLE_LADDER = "Revealed Ladder to Castle Basement"
    GARDEN_DOJO_LADDER = "Revealed Ladder to Castel Dojo"
    CASTLE_BONK = "Bonked Castle Garden Minish Portal Tree"
    GUARD_CAPTURE = "Caught by Guards"
    GARDEN_WATER_CHEST_LEFT = "Castle Garden Moat Left Chest"
    GARDEN_WATER_CHEST_RIGHT = "Castle Garden Moat Right Chest"
    EZLO_GARDEN = "Ezlo talks in Castle Garden"
    EZLO_SANCTUARY = "Ezlo talks in Castle Sanctuary"
    SWAMP_BOULDER_MIDDLE = "Pushed Shortcut Boulder in Swamp Middle"
    SWAMP_BOULDER_SOUTH = "Pushed Shortcut Boulder in Swamp South"
    EZLO_SWAMP_0 = "Ezlo talks in Swamp near entrance"
    EZLO_SWAMP_1 = "Ezlo talks in Swamp about sinking"
    EZLO_SWAMP_2 = "Ezlo talks in Swamp about eyegores"
    SWAMP_RUINS_BLOCK = "Opened Wind Ruins Entrance"
    SWAMP_BOULDER_NORTH = "Pushed Shortcut Boulder in Swamp North"
    SWAMP_GRAVE = "Opened Swamp Grave Dojo"
    SWAMP_WATER_TOP = "Swamp Underwater item top"
    SWAMP_WATER_MIDDLE = "Swamp Underwater item middle"
    SWAMP_WATER_BOTTOM = "Swamp Underwater item bottom"
    RUINS_ENTER = "Entered Wind Ruins"
    RUINS_BOULDER_1 = "Pushed First Shortcut Boulder in Wind Ruins"
    RUINS_BOMBWALL = "Blow up wall in Wind Ruins"
    RUINS_TEKTITE = "Defeated Wind Ruins Tektites"
    RUINS_BOULDER_2 = "Pushed Second Shortcut Boulder in Wind Ruins"
    RUINS_GRASS_TOP = "Cut top grass in Wind Ruins"
    RUINS_GRASS_MIDDLE = "Cut middle grass in Wind Ruins"
    RUINS_GRASS_LEFT = "Cut left grass in Wind Ruins"
    RUINS_GRASS_RIGHT = "Cut right grass in Wind Ruins"
    RUINS_GRASS_BOTTOM = "Cut bottom grass in Wind Ruins"
    RUINS_ARMOS = "Defeated Wind Ruins Armos"
    RUINS_BEETLES = "Defeated Wind Ruins Beetles and Ropes"
    RUINS_ARMOS_CHEST_LEFT = "Opened Wind Ruins Armos Fight Left Chest"
    RUINS_ARMOS_CHEST_RIGHT = "Opened Wind Ruins Armos Fight Right Chest"
    UNUSED_MINISH_LEFT_ROCK = "Unused Blow up left rock in minish woods"
    UNUSED_MINISH_RIGHT_ROCK = "Unused Blow up right rock in minish woods"
    MINISH_LEFT_ROCK = "Blow up left rock in minish woods"
    MINISH_MIDDLE_ROCK = "Blow up middle rock in minish woods"
    MINISH_RIGHT_ROCK = "Blow up right rock in minish woods"
    EZLO_MINISH_PORTAL = "Ezlo talks in minish woods about portals"
    MINISH_NORTH_HEART = "Collected Minish Woods North Heart Piece"
    MINISH_SOUTH_HEART = "Collected Minish Woods South Heart Piece"
    EZLO_MINISH_SHRINK = "Ezlo talks in minish woods about shrinking"
    CRENEL_RAIN_BOULDER_BOTTOM = "Pushed Bottom Shortcut Boulder in Mt Crenel Peak"
    CRENEL_RAIN_BOULDER_TOP = "Pushed Top Shortcut Boulder in Mt Crenel Peak"
    CRENEL_WALL_BOMBWALL = "Blow up wall in Mt Crenel Climbing Wall"
    CRENEL_SCRUB_BOMBWALL = "Blow up wall in Mt Crenel to Scrub Cave"
    CRENEL_FAIRY_HP_BOMBWALL = "Blow up wall in Mt Crenel to Fairy Heart Piece Cave"
    CRENEL_MUSHROOM_BOMBWALL = "Blow up wall in Mt Crenel near mushroom"
    CRENEL_BASE_HP_BOMBWALL = "Blow up wall in Mt Crenel near water Heart Piece cave"
    UNUSED_CRENEL_BASE_TILE = "Unused blow up tile in Mt Crenel near water Heart Piece cave"
    UNUSED_CRENEL_WALL_TILE_BOTTOM = "Unused blow up tile bottom in Mt Crenel near big wall climb"
    UNUSED_CRENEL_WALL_TILE_TOP = "Unused blow up tile top in Mt Crenel near big wall climb"
    EZLO_CRENEL_TORNADO = "Ezlo talks in mt crenel about tornado"
    CRENEL_BASE_RUPEE = "Collected Crenel Base Rupee"
    CRENEL_BASE_SPRING_ROCK = "Blow up rock in Crenel Base to Spring"
    CRENEL_BASE_GREEN_BEAN = "Crenel Base Green bean grown"
    CRENEL_BASE_BLUE_BEAN = "Crenel Base Blue bean grown"
    CRENEL_BASE_FAIRY_BOMBWALL = "Blow up wall in Crenel Base to Fairy Cave"
    CRENEL_BASE_MIDDLE_BOMBWALL = "Blow up wall in Crenel Base to Middle Cave"
    CRENEL_BASE_SPRING_BOMBWALL = "Blow up wall in Crenel Base to Spring"
    CRENEL_BASE_PORTAL = "Reveal Portal in Mt Crenel Base"
    CRENEL_BASE_HOLE = "Reveal Minish Hole in Mt Crenel Base"
    CRENEL_BASE_SCRUB_BOMBWALL = "Blow up wall in Crenel Base to Scrub Cave"
    VALLEY_CRYPT_ENTRANCE = "Opened the Graveyard Royal Crypt Entrance"
    VALLEY_GRAVE_RIGHT = "Opened the Graveyard Right Grave Entrance"
    VALLEY_GRAVE_LEFT = "Opened the Graveyard Left Grave Entrance"
    VALLEY_GRAVE_MIDDLE = "Opened the Graveyard Middle Grave"
    EZLO_VALLEY = "Ezlo talks about Royal Valley"
    VALLEY_BOMBWALL = "Blow up wall in Royal Valley"
    VALLEY_SECRET_CHEST = "Collected Secret Lost Woods Chest"
    EZLO_VALLEY_KEY = "Ezlo talks about Graveyard Key"
    SOUTH_FIELD_WEST_TREE_TOP = "South Hyrule Field West Trees Top cut"
    SOUTH_FIELD_WEST_TREE_MIDDLE = "South Hyrule Field West Trees Middle cut"
    SOUTH_FIELD_WEST_TREE_BOTTOM = "South Hyrule Field West Trees Bottom cut"
    SOUTH_FIELD_SOUTHWEST_TREE_TOP = "South Hyrule Field SouthWest Trees Top cut"
    SOUTH_FIELD_SOUTHWEST_TREE_MIDDLE = "South Hyrule Field SouthWest Trees Middle cut"
    SOUTH_FIELD_SOUTHWEST_TREE_BOTTOM = "South Hyrule Field SouthWest Trees Bottom cut"
    SOUTH_FIELD_SOUTHEAST_TREE_TOP = "South Hyrule Field SouthEast Trees Top cut"
    SOUTH_FIELD_SOUTHEAST_TREE_MIDDLE = "South Hyrule Field SouthEast Trees Middle cut"
    SOUTH_FIELD_SOUTHEAST_TREE_BOTTOM = "South Hyrule Field SouthEast Trees Bottom cut"
    SOUTH_FIELD_NORTH_TREE_TOP = "South Hyrule Field North Trees Top cut"
    SOUTH_FIELD_NORTH_TREE_MIDDLE = "South Hyrule Field North Trees Middle cut"
    SOUTH_FIELD_NORTH_TREE_BOTTOM = "South Hyrule Field North Trees Bottom cut"
    SOUTH_FIELD_NORTH_TREE_HIDDEN = "South Hyrule Field North Trees Hidden cut"
    SOUTH_FIELD_BOMBWALL = "Blow up wall in South Field"
    SOUTH_FIELD_BONK = "Bonked South Field Minish Portal Tree"
    SOUTH_FIELD_ZELDA_LEAVE = "Zelda has left South Hyrule Field"
    SOUTH_HILLS_LEFT_ROCK = "Blow up left rock in South Eastern Hills"
    SOUTH_HILLS_RIGHT_ROCK = "Blow up right rock in South Eastern Hills"
    HILLS_BOMBWALL = "Blow up wall in Eastern Hills"
    HILLS_TOP_ROCK = "Blow up top rock in Eastern Hills"
    HILLS_LEFT_ROCK = "Blow up left rock in Eastern Hills"
    HILLS_RIGHT_ROCK = "Blow up right rock in Eastern Hills"
    HILLS_BOTTOM_ROCK = "Blow up bottom rock in Eastern Hills"
    LONLON_TOP_ROCK = "Blow up top rock in LonLon Ranch"
    LONLON_MIDDLE_TOP_ROCK = "Blow up middle-top rock in LonLon Ranch"
    LONLON_MIDDLE_BOTTOM_ROCK = "Blow up middle-bottom rock in LonLon Ranch"
    LONLON_BOTTOM_ROCK = "Blow up bottom rock in LonLon Ranch"
    LONLON_GORON_OPEN = "Goron cave is opened"
    LONLON_BOULDER_NORTH = "Pushed North Shortcut Boulder in LonLon Ranch"
    LONLON_BOULDER_SOUTH = "Pushed South Shortcut Boulder in LonLon Ranch"
    LONLON_BOULDER_GORON = "Pushed Goron Cave Shortcut Boulder in LonLon Ranch"
    LONLON_BONK = "Bonked LonLon Ranch Minish Portal Tree"
    LONLON_HEART = "Collected Hylia Cape Cave Lon Lon HP"
    LONLON_DIG = "Collected LonLon Digging spot"
    EZLO_LONLON = "Ezlo talks about cows"
    NORTH_FIELD_TREE_TOP = "North Hyrule Field LonLon entrance trees top cut"
    NORTH_FIELD_TREE_MIDDLE_TOP = "North Hyrule Field LonLon entrance trees middle-top cut"
    NORTH_FIELD_TREE_MIDDLE_BOTTOM = "North Hyrule Field LonLon entrance trees middle-bottom cut"
    NORTH_FIELD_TREE_BOTTOM = "North Hyrule Field LonLon entrance trees bottom cut"
    NORTH_FIELD_EAST_ROCK_LEFT = "Blow up left rock in Eastern North Hyrule Field"
    NORTH_FIELD_EAST_ROCK_RIGHT = "Blow up right rock in Eastern North Hyrule Field"
    UNUSED_NORTH_FIELD_LEFT_FENCE = "Unused blow up fence near Cave in North Hyrule Field"
    UNUSED_NORTH_FIELD_RIGHT_FENCE = "Unused blow up fence near Cave in North Hyrule Field"
    NORTH_FIELD_WEST_ROCK = "Blow up west rock in North Hyrule Field"
    NORTH_FIELD_MINISH_HOLE = "Reveal the Minish Hole in North Hyrule Field"
    NORTH_FIELD_SCRUB = "Defeat the Scrub in North Hyrule Field"
    NORTH_FIELD_MOBLINS = "Defeat the Moblins in North Hyrule Field"
    NORTH_FIELD_BONK = "Bonked North Hyrule Field Minish Portal Tree"
    NORTH_FIELD_BRIDGE = "Extend the Bridge in North Hyrule Field"
    NORTH_FIELD_DIG = "Collected North Hyrule Field Digging spot"
    TRILBY_WEST_BOMBWALL = "Blow up west wall in Tribly Highlands"
    TRILBY_EAST_BOMBWALL = "Blow up east wall in Tribly Highlands"
    TRILBY_BOULDER = "Pushed Shortcut Boulder in Tribly Highlands"
    WESTERN_BOULDER = "Pushed Shortcut Boulder in Western Woods"
    WESTERN_DIG_TOP_LEFT = "Collected Top Left Digging spot in North Western Woods"
    WESTERN_DIG_BOTTOM_LEFT = "Collected Bottom Left Digging spot in North Western Woods"
    WESTERN_DIG_TOP_CENTER = "Collected Top Center Digging spot in North Western Woods"
    WESTERN_DIG_BOTTOM_CENTER = "Collected Bottom Center Digging spot in North Western Woods"
    WESTERN_DIG_TOP_RIGHT = "Collected Top Right Digging spot in North Western Woods"
    WESTERN_DIG_BOTTOM_RIGHT = "Collected Bottom Right Digging spot in North Western Woods"
    WESTERN_DIG_LEFT = "Collected Left Digging spot in South Western Woods"
    WESTERN_DIG_RIGHT = "Collected Right Digging spot in South Western Woods"
    WESTERN_CUTSCENE = "Seen Western Woods Cutscene"
    WESTERN_CHEST = "Collected Western Woods Chest"
    CASTLE_WAKE = "Disable sleeping cutscene in Hyrule Castle Bedroom"
    CASTLE_MAID = "Talked to the Maid in Hyrule Castle Bedroom"
    FALLS_HEART = "Collected Veil Falls Entrance Heart Piece"
    FALLS_CLIFF_CHEST = "Collected Veil Falls Cliff Chest"
    LOWER_FALLS_RUPEE_TOP = "Collected South Veil Falls Top Rupee spot"
    LOWER_FALLS_RUPEE_LEFT = "Collected South Veil Falls Left Rupee spot"
    LOWER_FALLS_RUPEE_RIGHT = "Collected South Veil Falls Right Rupee spot"
    EZLO_FALLS = "Ezlo talks in veil falls entrance"
    FALLS_DIG_TOP = "Collected Falls Upper Dig Spot near Wind Crest"
    LOWER_FALLS_HEART = "Collected Veil Falls South Heart Piece"
    EZLO_FALLS_TOP = "Ezlo talks in veil falls about tornado"
    BIGGORON_SHIELD = "Biggoron has been given a shield"
    BIGGORON_EATING = "Biggoron is eating"
    CRENEL_BEANSTALK = "Beanstalk has grown in Mt Crenel"
    LAKE_BEANSTALK = "Beanstalk has grown in Lake Hylia"
    RUINS_BEANSTALK = "Beanstalk has grown in Wind Ruins"
    HILLS_BEANSTALK = "Beanstalk has grown in Eastern Hills"
    WESTERN_BEANSTALK = "Beanstalk has grown in Western Woods"
    HILLS_FUSION_CHEST = "Collected Eastern Hills Fusion Chest"
    MINISH_WEST_FUSION_CHEST = "Collected Minish Woods West Fusion Chest"
    RUINS_NEAR_FOW_FUSION_CHEST = "Collected Ruins Near Dungeon Fusion Chest"
    MINISH_EAST_FUSION_CHEST = "Collected Minish Woods East Fusion Chest"
    TRILBY_TOP_FUSION_CHEST = "Collected Triby Highlands North Fusion Chest"
    MINISH_SOUTH_FUSION_CHEST = "Collected Minish Woods South Fusion Chest"
    MINISH_NORTH_FUSION_CHEST = "Collected Minish Woods North Fusion Chest"
    SOUTH_FIELD_FUSION_CHEST = "Collected South Hyrule Field Fusion Chest"
    VALLEY_LEFT_FUSION_CHEST = "Collected Graveyard Left Fusion Chest"
    VALLEY_RIGHT_FUSION_CHEST = "Collected Graveyard Right Fusion Chest"
    TRILBY_MIDDLE_FUSION_CHEST = "Collected Triby Highlands Middle Fusion Chest"
    PRE_VALLEY_FUSION_CHEST = "Collected Pre-Valley Fusion Chest in North Hyrule Field"
    LOWER_FALLS_FUSION_CHEST = "Collected Lower Fusion Chest in LonLon Ranch"
    FALLS_FUSION_CHEST = "Collected Upper Falls Fusion Chest"
    CRENEL_FUSION_CHEST = "Collected Mt Crenel Wall Fusion Chest"
    CRENEL_BASE_FUSION_CHEST = "Collected Mt Crenel Base Fusion Chest"
    RUINS_PILLARS_FUSION_CHEST = "Collected Wind Ruins Pillars Fusion Chest"
    TOWN_GUARD_TALK = "Talked to Guard in town before showing Spin Attack"
    TOWN_LIBRARY_PORTAL = "Flips Minish Portal on Library Roof"
    TOWN_SCHOOL_ROOF_PORTAL = "Un-flips Minish Portal on School Roof"
    TOWN_BOX = "Pushed box in minish cat path"
    TOWN_INN_LEDGE_CHEST = "Collected Town Inn ledge chest"
    TOWN_SCHOOL_ROOF_CHEST = " Collected School Roof Chest"
    TOWN_INTRO = "Move NPC blockers during intro to leave festival"
    TOWN_WEST_GUARD = "Move Guard in Town west exit"
    TOWN_DOG = "Move Dog in Town west"
    TOWN_BELL = "Collected Town Bell Heart Piece"
    TOWN_MUSIC_HOUSE = "Town Music House is Unlocked"
    TOWN_GOSSIP_1 = "Talked to Right Gossip Woman near well"
    TOWN_GOSSIP_2 = "Talked to Left Gossip Woman near well"
    TOWN_TALK_FOUNTAIN_1 = "Talked to the boy near the fountain"
    TOWN_TALK_FOUNTAIN_2 = "Talked to the girl near the fountain"
    TOWN_TALK_GUY_2 = "Talked to the guy near the stranger house in state 2"
    TOWN_TALK_GUY_4 = "Talked to the guy near the stranger house in state 4"
    TOWN_TALK_GUY_5 = "Talked to the guy near the stranger house in state 5"
    TOWN_CAFE_LADY_NPC = "Collected Town Cafe Lady NPC"
    TOWN_HERB = "Talked to Music House Owner"
    TOWN_DOG_HUMAN = "Talked to Dog in Town west when normal sized"
    EZLO_CLOUDS_TOWER = "Ezlo talks about Wind Tribe Tower"
    UNUSED_EZLO_CLOUDS = "Unused Ezlo Talks about Wind Tribe Tower"
    CLOUDS_FREE_CHEST = "Collected Cloud Tops Free Chest"
    CLOUDS_SOUTH_MIDDLE_CHEST = "Collected Cloud Tops South, Middle Chest"
    CLOUDS_NORTH_WEST_BOTTOM_CHEST = "Collected Cloud Tops North West, Bottom Chest"
    CLOUDS_NORTH_WEST_LEFT_CHEST = "Collected Cloud Tops North West, Left Chest"
    CLOUDS_NORTH_WEST_RIGHT_CHEST = "Collected Cloud Tops North West, Right Chest"
    CLOUDS_SOUTH_LEFT_CHEST = "Collected Cloud Tops South, Left Chest"
    CLOUDS_SOUTH_RIGHT_CHEST = "Collected Cloud Tops South, Right Chest"
    CLOUDS_NORTH_WEST_DIG_SPOT = "Collected Cloud Tops North West, Dig Spot"
    CLOUDS_NORTH_EAST_DIG_SPOT = "Collected Cloud Tops North East, Dig Spot"
    CLOUDS_SOUTH_MIDDLE_DIG_SPOT = "Collected Cloud Tops South, Middle Dig Spot"
    CLOUDS_SOUTH_EAST_TOP_DIG_SPOT = "Collected Cloud Tops South East, Top Dig Spot"
    CLOUDS_SOUTH_LEFT_DIG_SPOT = "Collected Cloud Tops South, Left Dig Spot"
    CLOUDS_SOUTH_RIGHT_DIG_SPOT = "Collected Cloud Tops South, Right Dig Spot"
    CLOUDS_SOUTH_EAST_BOTTOM_DIG_SPOT = "Collected Cloud Tops South East, Bottom Dig Spot"
    EZLO_CLOUDS_ENTER = "Ezlo talks about Cloud Tops"
    CLOUDS_PINWHEEL_TOP_RIGHT = "Cloud tops top right pinwheel spinning"
    CLOUDS_PINWHEEL_BOTTOM_LEFT = "Cloud tops bottom left pinwheel spinning"
    CLOUDS_PINWHEEL_TOP_LEFT = "Cloud tops top left pinwheel spinning"
    CLOUDS_PINWHEEL_MIDDLE = "Cloud tops middle pinwheel spinning"
    CLOUDS_PINWHEEL_BOTTOM_RIGHT = "Cloud tops bottom right pinwheel spinning"
    CLOUDS_NORTH_KILL = "Cloud tops kill north sharks"
    CLOUDS_NORTH_COLLECT = "Collected Cloud Tops North Kill"
    CLOUDS_SOUTH_KILL = "Cloud tops kill south sharks"
    CLOUDS_SOUTH_COLLECT = "Collected Cloud Tops South Kill"
    CLOUDS_GALE_TALK = "Spoke to in Gale Cloud tops"
    CLOUDS_HAILEY_TALK = "Spoke to in Hailey Cloud tops"
    FALLS_DIG_BOTTOM = "Collected Falls Lower Dig Spot near LikeLike"
    EZLO_CRENEL_MINISH = "Ezlo talks after Mt Crenel Minish Cutscene"
    RUINS_ARMOS_CAMERA = "Camera pans to disapearing pillars after defeating Armos"
    RUINS_BEETLES_CAMERA = "Camera pans to disapearing pillars after defeating Beetles and Ropes"
    MINISH_WOODS_POST_VILLAGE_FUSION_CHEST = "Collected Minish Woods post village fusion chest"

    UNUSED_DWS_DOOR = "Unused DWS Room, opened door"
    DWS_VISIT_00 = "Visited DWS room 0x00: 1F: Madderpillar"
    DWS_VISIT_01 = "Visited DWS room 0x01: 1F: Blue Warp"
    DWS_VISIT_02 = "Visited DWS room 0x02: 1F: Stairs to B1"
    DWS_VISIT_03 = "Visited DWS room 0x03: 1F: West pot switch bridge"
    DWS_VISIT_04 = "Visited DWS room 0x04: 1F: West two statues"
    DWS_VISIT_05 = "Visited DWS room 0x05: 1F: West Big Chest and Heart Piece"
    DWS_VISIT_06 = "Visited DWS room 0x06: 1F: Central Room (with the Barrel)"

    DWS_1F_MADDER_RIGHT_WEB = "DWS: Sucked the right web in Madderpillar room blocking the doorway"
    DWS_1F_MADDER_BOTTOM_WEB = "DWS: Sucked the bottom web in Madderpillar room blocking the doorway"
    DWS_1F_MADDER_BIG_CHEST = "DWS: Opened the Big chest in the Madderpillar room"
    DWS_1F_BLUE_WARP_SOUTH_DOOR = "DWS: Opened the shortcut door between Blue Warp room and Center Barrel room"
    DWS_1F_BLUE_WARP_SWITCH = "DWS: Press the switch to activate the Blue Warp"
    DWS_1F_BLUE_WARP_LEFT_DOOR = "DWS: Used a small key on the door to the Madderpillar room"
    DWS_1F_BLUE_WARP_LEFT_CHEST_SWITCH = "DWS: Press the switch in the Blue Warp room to activate the Left Chest"

    DWS_1F_SLUG_TOP_LEFT = "DWS: Press the top left switch in the Slug room"
    DWS_1F_SLUG_BOTTOM_LEFT = "DWS: Press the bottom left switch in the Slug room"
    DWS_1F_SLUG_TOP_RIGHT = "DWS: Press the top right switch in the Slug room"
    DWS_1F_SLUG_BOTTOM_RIGHT = "DWS: Press the bottom right switch in the Slug room"
    DWS_1F_SLUG_DOOR = "DWS: Used a small key on the door in the Slug room"
    DWS_1F_SLUG_CHEST = "DWS: Opened the chest in the Slug room"
    DWS_B1_RED_WARP_SWITCH = "DWS: Press the switch to activate the Red Warp"
    DWS_B1_RED_WARP_BIG_CHEST = "DWS: Opened the Big chest in the Red Warp room"

    COF_VISIT_00 = "Visited CoF room 0x00: B1: Blue Warp"
    COF_VISIT_01 = "Visited CoF room 0x01: B1: Spiny Chu Fight"
    COF_VISIT_02 = "Visited CoF room 0x02: B1: Minecart Bridge"
    COF_VISIT_03 = "Visited CoF room 0x03: 1F: Entrance"
    COF_VISIT_04 = "Visited CoF room 0x04: B1: Main Cart Junction"
    COF_VISIT_05 = "Visited CoF room 0x05: 1F: Rupees and LikeLike"
    COF_VISIT_06 = "Visited CoF room 0x06: B1: Minecart Hallways"
    COF_VISIT_07 = "Visited CoF room 0x07: B1: Helmasaur Fight"
    COF_VISIT_08 = "Visited CoF room 0x08: B1: Rollobite Lava"
    COF_VISIT_09 = "Visited CoF room 0x09: B1: Hazy Lava Room"
    COF_VISIT_10 = "Visited CoF room 0x10: B2: Minish Spike Trap"
    COF_VISIT_11 = "Visited CoF room 0x11: B2: Four Rollobite Switch"
    COF_VISIT_12 = "Visited CoF room 0x12: B2: Hole to Gleerok"
    COF_VISIT_13 = "Visited CoF room 0x13: B2: Lava Basement North"
    COF_VISIT_14 = "Visited CoF room 0x14: B2: Lava Basement North East"
    COF_VISIT_15 = "Visited CoF room 0x15: B1: Spikey Beetle Fight"
    COF_VISIT_16 = "Visited CoF room 0x16: B1: Bob-omb Cracked Wall"
    COF_VISIT_17 = "Visited CoF room 0x17: B2: Lava Basement"
    COF_VISIT_BOSS = "Visited CoF Boss room"
    COF_B1_BLUE_WARP_DOOR = "COF: Used a small key on the door in the Blue Warp room"
    COF_B1_BLUE_WARP_SWITCH = "COF: Press the switch to activate the Blue Warp"
    COF_B1_SPINY_CHU_DEFEATED = "COF: Defeated the Spiny Chus to spawn the Big Chest"
    COF_B1_SPINY_CHU_PILLAR = "COF: Pushed the pillar with the chest into the hole in the Spiny Chu Fight room"

    COF_B2_SPIKE_TRAP_CHEST = "COF: Opened the chest near the spike traps in the Lava Basement North East"
    COF_1F_BEETLES_DEFEATED = "COF: Defeated the Spikey Beetles to spawn the Big Chest"
    COF_1F_BEETLES_BIG_CHEST = "COF: Opened the big chest in the Spikey Beetle room"
    EZLO_COF_BEETLES = "Ezlo talks about Beetles in Cave of Flames"
    COF_1F_BOBOMB_WALL = "COF: Blow up the wall in the first Bobomb room"
    COF_B2_RED_WARP_SWITCH = "COF: Press the switch to activate the Red Warp"
    COF_B2_BOSS_DOOR = "COF: Opened the Boss Door"
    COF_B2_LAVA_LEFT_CHEST = "COF: Opened the left chest in the B2 Lava Basement"

    FOW_VISIT_00 = "Visited FoW room 0x00: 3F: Double Eyegore"
    FOW_VISIT_01 = "Visited FoW room 0x01: 3F: Before Mazaal"
    FOW_VISIT_02 = "Visited FoW room 0x02: 3F: Right Side Key Lever"
    FOW_VISIT_03 = "Visited FoW room 0x03: 3F: Bow Puzzle Platforms"
    FOW_VISIT_04 = "Visited FoW room 0x04: 3F: Left Side Key Lever"

    FOW_3F_RIGHT_LEVER = "FOW: Pulled the lever on the right side 3F to drop an item"
    FOW_3F_TOP_EYES = "FOW: Opened the door at the top of the Bow Puzzle Platform room"
    FOW_3F_RIGHT_EYES = "FOW: Opened the door on the right of the Bow Puzzle Platform room"
    FOW_3F_LEFT_DROPPED = "FOW: Item dropped from the left side to the ground floor"
    FOW_3F_LEFT_LEVER = "FOW: Pulled the lever on the left side 3F to drop an item"
    FOW_RED_WARP_SWITCH = "FOW: Pushed the block to activate the Red Warp"
    FOW_BOSS_DOOR = "FOW: Opened the Boss Door"
    FOW_DEFEAT_DARKNUT = "FOW: Defeated the Darknut"

    TOD_VISIT_00 = "Visited ToD room 0x00: B1: Entrance Left Hole"
    TOD_VISIT_01 = "Visited ToD room 0x01: B1: North of Entrance"
    TOD_VISIT_02 = "Visited ToD room 0x02: B1: Entrance Right Hole"
    TOD_VISIT_03 = "Visited ToD room 0x03: B1: Entrance"
    TOD_VISIT_04 = "Visited ToD room 0x04: B1: Pre West Lever"
    TOD_VISIT_05 = "Visited ToD room 0x05: B1: Blue Warp"
    TOD_VISIT_06 = "Visited ToD room 0x06: B1: Left Path North Waterfall"
    TOD_VISIT_07 = "Visited ToD room 0x07: "
    TOD_VISIT_08 = "Visited ToD room 0x08: "
    TOD_VISIT_09 = "Visited ToD room 0x09: "
    TOD_VISIT_0A = "Visited ToD room 0x0A: "
    TOD_VISIT_0B = "Visited ToD room 0x0B: "
    TOD_VISIT_0C = "Visited ToD room 0x0C: "
    TOD_VISIT_0D = "Visited ToD room 0x0D: "
    TOD_VISIT_0E = "Visited ToD room 0x0E: "
    TOD_VISIT_0F = "Visited ToD room 0x0F: "
    TOD_VISIT_10 = "Visited ToD room 0x010: "
    TOD_VISIT_11 = "Visited ToD room 0x011: "
    TOD_VISIT_20 = "Visited ToD room 0x020: "
    TOD_VISIT_21 = "Visited ToD room 0x021: "
    TOD_VISIT_22 = "Visited ToD room 0x022: "
    TOD_VISIT_23 = "Visited ToD room 0x023: "
    TOD_VISIT_24 = "Visited ToD room 0x024: "
    TOD_VISIT_25 = "Visited ToD room 0x025: "
    TOD_VISIT_26 = "Visited ToD room 0x026: "
    TOD_VISIT_27 = "Visited ToD room 0x027: "
    TOD_VISIT_28 = "Visited ToD room 0x028: "
    TOD_VISIT_29 = "Visited ToD room 0x029: "
    TOD_VISIT_2A = "Visited ToD room 0x02A: "
    TOD_VISIT_2B = "Visited ToD room 0x02B: "
    TOD_VISIT_2C = "Visited ToD room 0x02C: "
    TOD_VISIT_2D = "Visited ToD room 0x02D: "
    TOD_VISIT_2E = "Visited ToD room 0x02E: "
    TOD_VISIT_2F = "Visited ToD room 0x02F: "
    TOD_VISIT_30 = "Visited ToD room 0x030: "
    TOD_VISIT_31 = "Visited ToD room 0x031: "
    TOD_VISIT_32 = "Visited ToD room 0x032: "
    TOD_VISIT_33 = "Visited ToD room 0x033: "
    TOD_VISIT_34 = "Visited ToD room 0x034: "
    TOD_VISIT_35 = "Visited ToD room 0x035: B2: Left Path Ice Madderpillar"
    TOD_INIT_LIGHT = "TOD: Initialise the Light Ray rooms"
    TOD_ENTRANCE_WEST_DOOR = "TOD: Used a small key on the west door north of the entrance"
    EZLO_TOD_ENTRANCE = "Ezlo talks about how cold it is in Temple of Droplets"
    TOD_BOSS_DOOR = "TOD: Opened the Boss Door"
    TOD_DEFEAT_SCISSOR_BLUE = "TOD: Defeat the Scissor Beetles in the Blue Warp room"

    DROPLETS_EAST_SWITCH = "Droplets East Switch"
    DROPLETS_WEST_SWITCH = "Droplets West Switch"

    TOD_RED_WARP_SWITCH = "TOD: Press the switch to activate the Red Warp"
    TOD_RED_WARP_BOMBWALL = "TOD: Blow up the wall in the Red Warp room"
    TOD_LEFTPATH_B2_GATE1_SWITCH = "TOD: Left Path: Fall down the waterfall and press the switch to activate the Gate"
    TOD_LEFTPATH_B2_LILYPAD = "TOD: Lilypad spawns on the Left Path B2 near the waterfall"
    TOD_RIGHTPATH_B2_ICE_CHEST = "TOD: Melt the Frozen Chest on the Right Path B2 first room"
    TOD_RIGHTPATH_B2_ICE_RIGHT = "TOD: Melt the Ice block on the Right Path B2 first room"
    TOD_RIGHTPATH_B2_ICECHEST = "TOD: Opened the Right Path B2 frozen chest"
    TOD_ICEMADDERPILLAR_BIGCHEST = "TOD: Opened the Left Path B2 Ice Madderpillar Big Chest"

    POW_VISIT_00 = "Visited PoW room 0x00: "
    POW_VISIT_01 = "Visited PoW room 0x01: "
    POW_VISIT_02 = "Visited PoW room 0x02: "
    POW_VISIT_03 = "Visited PoW room 0x03: "
    POW_VISIT_04 = "Visited PoW room 0x04: "
    POW_VISIT_05 = "Visited PoW room 0x05: "
    POW_VISIT_06 = "Visited PoW room 0x06: "

    POW_2ND_HALF_4F_BLOCK_MAZE_CHEST = "PoW: 2nd Half: 4F: Opened the chest in the final block maze"
    POW_2ND_HALF_4F_FINAL_DOOR = "PoW: 2nd Half: 4F: Used a small key on the final locked door"
    POW_2ND_HALF_4F_MIDDLE_DOOR = "PoW: 2nd Half: 4F: Used a small key on the door near the Red Warp"
    POW_2ND_HALF_4F_SWITCH_HIT = "PoW: 2nd Half: 4F: Hit the Switch near the final locked door"
    POW_2ND_HALF_4F_LEFT_TORCH = "PoW: 2nd Half: 4F: Lit the left torch near the Red Warp"
    POW_2ND_HALF_4F_RIGHT_TORCH = "PoW: 2nd Half: 4F: Lit the right torch near the Red Warp"
    POW_2ND_HALF_4F_SWITCH_HIT_CHEST = "PoW: 2nd Half: 4F: Opened the chest by the switch near the final locked door"

    POW_2ND_HALF_4F_HEART = "PoW: 2nd Half: 4F: Collected Palace of Winds Heart Piece"
    POW_1ST_HALF_5F_MOBLIN_DOOR = "PoW: 1st Half: 5F: Door opened after Moblin and Wizrobe fight"
    POW_1ST_HALF_5F_ITEM_DROP = "PoW: 1st Half: 5F: Item dropped after Chainsoldier fight"
    POW_BLUE_WARP_SWITCH = "PoW: Bridge extends after Red Darknut fight at Blue Warp"
    POW_1ST_HALF_2F_BEETLES = "PoW: 1st Half: 2F: Door opened after Spikey Beetle fight"
    POW_RED_WARP_SWITCH = "PoW: 2nd Half: 4F: Torches lit to spawn Red Warp"
    POW_1ST_HALF_3F_ITEM_DROP = "PoW: 2nd Half: 3F: Door opened from hitting switch avoiding pot puzzle"

    DHC_VISIT_00 = "Visited DHC room 0x00: "
    DHC_VISIT_01 = "Visited DHC room 0x01: "
    DHC_VISIT_02 = "Visited DHC room 0x02: "
    DHC_VISIT_03 = "Visited DHC room 0x03: "
    DHC_VISIT_04 = "Visited DHC room 0x04: "
    DHC_VISIT_05 = "Visited DHC room 0x05: "
    DHC_VISIT_06 = "Visited DHC room 0x06: "

    DHC_2F_NW_EYES = "DHC: North West: Hit all the eye switches"
    DHC_B2_JAIL = "DHC: Basement: Opened the Jail doors"
    DHC_2F_OUT_BRIDGE_1 = "DHC: Outside: Extended the first bridge to the doorway"
    DHC_2F_OUT_BRIDGE_2 = "DHC: Outside: Extended the second bridge to the pots"
    EZLO_DHC_SANC = "Ezlo talks about the frozen NPCs"
    DHC_BLUE_WARP_DOOR = "DHC: Blue Warp: Doors opened and Darknuts Spawn around the Dungeon"
    DHC_2F_NE_GHINI_DOOR = "DHC: North East: Doors opened from defeating ghini's"
    DHC_2F_NW_DARKNUT_DOOR = "DHC: North West: Doors opened from defeating Darknut"
    DHC_2F_NE_DARKNUT_DOOR = "DHC: North East: Doors opened from defeating Darknuts"
    DHC_2F_SW_DARKNUT_DOOR = "DHC: South West: Doors opened from defeating Darknuts"
    DHC_RED_WARP_DOOR = "DHC: Red Warp: Doors opened"
    DHC_2F_SE_DARKNUT_DOOR = "DHC: South East: Doors opened from defeating Darknut"
    DHC_2F_SW_GHINI_DOOR = "DHC: South West: Doors opened from defeating ghini's"
    DHC_1F_THRONE_DOOR = "DHC: Throne: Doors opened from defeating Darknut"
    DHC_B2_CAMERA = "DHC: Basement: Camera pans after opening the jail doors"

    DWS_BLUE_WARP = "DWS: Blue Warp active"
    DWS_RED_WARP = "DWS: Red Warp active"
    COF_BLUE_WARP = "COF: Blue Warp active"
    COF_RED_WARP = "COF: Red Warp active"
    FOW_BLUE_WARP = "FOW: Blue Warp active"
    FOW_RED_WARP = "FOW: Red Warp active"
    TOD_BLUE_WARP = "TOD: Blue Warp active"
    TOD_RED_WARP = "TOD: Red Warp active"
    POW_BLUE_WARP = "POW: Blue Warp active"
    POW_RED_WARP = "POW: Red Warp active"
    DHC_BLUE_WARP = "DHC: Blue Warp active"
    DHC_RED_WARP = "DHC: Red Warp active"

    CLEAR_DWS = "Clear DWS"
    CLEAR_COF = "Clear CoF"
    CLEAR_FOW = "Clear FoW"
    CLEAR_TOD = "Clear ToD"
    CLEAR_RC = "Clear RC"
    CLEAR_POW = "Clear PoW"
    CLEAR_PED = "Pedestal Complete"
    CLEAR_DHC = "Kill Vaati"


class TMCRegion:
    SOUTH_FIELD = "South Field"
    SOUTH_PUDDLE = "South Puddle"
    HYRULE_TOWN = "Hyrule Town"
    NORTH_FIELD = "North Field"
    CASTLE_EXTERIOR = "Castle Exterior"
    EASTERN_HILLS = "Eastern Hills"
    LONLON = "LonLon"
    LOWER_FALLS = "Lower Falls"
    LAKE_HYLIA_NORTH = "Lake Hylia North"
    LAKE_HYLIA_SOUTH = "Lake Hylia South"
    MINISH_WOODS = "Minish Woods"
    BELARI = "Belari area"
    TRILBY_HIGHLANDS = "Trilby Highlands"
    WESTERN_WOODS = "Western Woods"
    CRENEL_BASE = "Crenel Base"
    CRENEL = "Crenel"
    MELARI = "Melari"
    CASTOR_WILDS = "Castor Wilds"
    WIND_RUINS = "Ruins"
    ROYAL_VALLEY = "Royal Valley"
    GRAVEYARD = "Graveyard"
    DUNGEON_RC = "Dungeon RC"
    DUNGEON_RC_CLEAR = "Dungeon RC Clear"
    FALLS_ENTRANCE = "Falls Entrance"
    MIDDLE_FALLS = "Middle Falls"
    UPPER_FALLS = "Upper Falls"
    CLOUDS = "Clouds"
    WIND_TRIBE = "Wind Tribe"
    DUNGEON_DWS_ENTRANCE = "Deepwood Shrine Entrance"
    DUNGEON_DWS_BARREL = "Deepwood Shrine Barrel Area"
    DUNGEON_DWS_MULLDOZER = "Deepwood Shrine East Side through locked door"
    DUNGEON_DWS_BACK_HALF = "Deepwood Shrine Back Half"
    DUNGEON_DWS_BLUE_WARP = "Deepwood Shrine Blue Warp"
    DUNGEON_DWS_RED_WARP = "Deepwood Shrine Red Warp"
    DUNGEON_DWS_CLEAR = "Deepwood Shrine Clear"
    DUNGEON_COF_ENTRANCE = "Cave of Flames Entrance"
    DUNGEON_COF_MAIN = "Cave of Flames After Spikey Beetles"
    DUNGEON_COF_MINECART = "Cave of Flames After Minecart 2nd path"
    DUNGEON_COF_BLUE_WARP = "Cave of Flames Blue Warp"
    DUNGEON_COF_LAVA_BASEMENT = "Cave of Flames Lava Basement"
    DUNGEON_COF_CLEAR = "Cave of Flames Clear"
    DUNGEON_FOW_ENTRANCE = "Fortress of Winds Entrance"
    DUNGEON_FOW_EYEGORE = "Fortress of Winds Past Eyegores"
    DUNGEON_FOW_BLUE_WARP = "Fortress of Winds Blue warp"
    DUNGEON_FOW_CLEAR = "Fortress of Winds Clear"
    DUNGEON_TOD_ENTRANCE = "Temple of Droplets Entrance"
    DUNGEON_TOD_MAIN = "Temple of Droplets After Big key"
    DUNGEON_TOD_LEFT_BASEMENT = "Temple of Droplets Left Basement"
    DUNGEON_TOD_DARK_MAZE_END = "Temple of Droplets Dark Maze End"
    DUNGEON_TOD_WEST_SWITCH_LEDGE = "Temple of Droplets West Switch Ledge"
    DUNGEON_TOD_EAST_SWITCH = "Temple of Droplets East Switch"
    DUNGEON_TOD_WEST_SWITCH = "Temple of Droplets West Switch"
    DUNGEON_TOD_CLEAR = "Temple of Droplets Clear"
    DUNGEON_POW_ENTRANCE = "Palace of Winds Entrance"
    DUNGEON_POW_OUT_1F = "Palace of Winds 1st Half 1F"
    DUNGEON_POW_OUT_2F = "Palace of Winds 1st Half 2F"
    DUNGEON_POW_OUT_3F = "Palace of Winds 1st Half 3F"
    DUNGEON_POW_OUT_4F = "Palace of Winds 1st Half 4F"
    DUNGEON_POW_OUT_5F = "Palace of Winds 1st Half 5F"
    DUNGEON_POW_BLUE_WARP = "Palace of Winds Blue warp"
    DUNGEON_POW_IN_1F = "Palace of Winds 2nd Half 1F"
    DUNGEON_POW_IN_2F = "Palace of Winds 2nd Half 2F"
    DUNGEON_POW_IN_3F = "Palace of Winds 2nd Half 3F"
    DUNGEON_POW_IN_3F_SWITCH = "Palace of Winds 2nd Half 3F Switch"
    DUNGEON_POW_IN_4F = "Palace of Winds 2nd Half 4F"
    DUNGEON_POW_RED_WARP = "Palace of Winds Red warp"
    DUNGEON_POW_IN_5F = "Palace of Winds 2nd Half 5F"
    DUNGEON_POW_IN_4F_END = "Palace of Winds 2nd Half 4F End Maze"
    DUNGEON_POW_IN_5F_END = "Palace of Winds 2nd Half 5F End Chest"
    DUNGEON_POW_CLEAR = "Palace of Winds Clear"
    SANCTUARY = "Sanctuary"
    STAINED_GLASS = "Sanctuary - Stained Glass"
    DUNGEON_DHC_B1_WEST = "Dark Hyrule Castle Basement Sanctuary Entrance"
    DUNGEON_DHC_B2 = "Dark Hyrule Castle Basement Jail"
    DUNGEON_DHC_ENTRANCE = "Dark Hyrule Castle Main Entrance"
    DUNGEON_DHC_B1_EAST = "Dark Hyrule Castle Basement Canon Puzzle"
    DUNGEON_DHC_1F = "Dark Hyrule Castle Throne Room"
    DUNGEON_DHC_OUTSIDE = "Dark Hyrule Castle Outside"
    DUNGEON_DHC_RED_WARP = "Dark Hyrule Castle Red Warp"
    DUNGEON_DHC_BLUE_WARP = "Dark Hyrule Castle Blue Warp"
    VAATI_FIGHT = "Vaati Fight"


class TMCWarps:
    DWS_BLUE = "DWS Blue"
    DWS_RED = "DWS Red"
    COF_BLUE = "CoF Blue"
    COF_RED = "CoF Red"
    FOW_BLUE = "FoW Blue"
    FOW_RED = "FoW Red"
    TOD_BLUE = "ToD Blue"
    TOD_RED = "ToD Red"
    POW_BLUE = "PoW Blue"
    POW_RED = "PoW Red"
    DHC_BLUE = "DHC Blue"
    DHC_RED = "DHC Red"


class TMCCrests:
    CRENEL = "wind_crest_crenel"
    FALLS = "wind_crest_falls"
    CLOUDS = "wind_crest_clouds"
    SWAMP = "wind_crest_castor"
    SMITH = "wind_crest_south_field"
    MINISH = "wind_crest_minish_woods"
    TOWN = "wind_crest_town"
    LAKE = "wind_crest_lake"


class TMCTricks:
    BOMB_DUST = "bombable_dust"
    MUSHROOM = "crenel_mushroom_gust_jar"
    ARROWS_BREAK = "light_arrows_break_objects"
    BOBOMB_WALLS = "bobombs_destroy_walls"
    LIKELIKE_SWORDLESS = "like_like_cave_no_sword"
    BOOTS_GUARDS = "boots_skip_town_guard"
    BEAM_CRENEL_SWITCH = "beam_crenel_switch"
    DOWNTHRUST_BEETLE = "down_thrust_spikey_beetle"
    DARK_ROOMS = "dark_rooms_no_lantern"
    CAPE_EXTENSIONS = "cape_extensions"
    LAKE_MINISH = "lake_minish_no_boots"
    CABIN_SWIM = "cabin_swim_no_lilypad"
    SHARKS_SWORDLESS = "cloud_sharks_no_weapons"
    POW_NOCANE = "pow_2f_no_cane"
    POT_PUZZLE = "pot_puzzle_no_bracelets"
    FOW_POT = "fow_pot_gust_jar"
    DHC_CANNONS = "dhc_cannons_no_four_sword"
    DHC_CLONES = "dhc_pads_no_four_sword"
    DHC_SPIN = "dhc_switches_no_four_sword"


ALL_TRICKS = [
    TMCTricks.BOMB_DUST,
    TMCTricks.MUSHROOM,
    TMCTricks.ARROWS_BREAK,
    TMCTricks.BOBOMB_WALLS,
    TMCTricks.LIKELIKE_SWORDLESS,
    TMCTricks.BOOTS_GUARDS,
    TMCTricks.BEAM_CRENEL_SWITCH,
    TMCTricks.DOWNTHRUST_BEETLE,
    TMCTricks.DARK_ROOMS,
    TMCTricks.CAPE_EXTENSIONS,
    TMCTricks.LAKE_MINISH,
    TMCTricks.CABIN_SWIM,
    TMCTricks.SHARKS_SWORDLESS,
    TMCTricks.POW_NOCANE,
    TMCTricks.POT_PUZZLE,
    TMCTricks.FOW_POT,
    TMCTricks.DHC_CANNONS,
    TMCTricks.DHC_CLONES,
    TMCTricks.DHC_SPIN,
]

DUNGEON_ABBR = frozenset({"DWS", "CoF", "FoW", "ToD", "PoW", "DHC", "RC"})
DUNGEON_REGIONS = {
    "DWS": {TMCRegion.DUNGEON_DWS_ENTRANCE, TMCRegion.DUNGEON_DWS_BARREL, TMCRegion.DUNGEON_DWS_MULLDOZER,
            TMCRegion.DUNGEON_DWS_BACK_HALF, TMCRegion.DUNGEON_DWS_BLUE_WARP, TMCRegion.DUNGEON_DWS_RED_WARP,
            TMCRegion.DUNGEON_DWS_CLEAR},
    "CoF": {TMCRegion.DUNGEON_COF_ENTRANCE, TMCRegion.DUNGEON_COF_MAIN, TMCRegion.DUNGEON_COF_MINECART,
            TMCRegion.DUNGEON_COF_BLUE_WARP, TMCRegion.DUNGEON_COF_LAVA_BASEMENT, TMCRegion.DUNGEON_COF_CLEAR},
    "FoW": {TMCRegion.DUNGEON_FOW_ENTRANCE, TMCRegion.DUNGEON_FOW_EYEGORE,
            TMCRegion.DUNGEON_FOW_BLUE_WARP, TMCRegion.DUNGEON_FOW_CLEAR},
    "ToD": {TMCRegion.DUNGEON_TOD_ENTRANCE, TMCRegion.DUNGEON_TOD_MAIN, TMCRegion.DUNGEON_TOD_LEFT_BASEMENT,
            TMCRegion.DUNGEON_TOD_DARK_MAZE_END, TMCRegion.DUNGEON_TOD_WEST_SWITCH_LEDGE,
            TMCRegion.DUNGEON_TOD_EAST_SWITCH, TMCRegion.DUNGEON_TOD_WEST_SWITCH, TMCRegion.DUNGEON_TOD_CLEAR},
    "PoW": {TMCRegion.DUNGEON_POW_ENTRANCE, TMCRegion.DUNGEON_POW_OUT_1F, TMCRegion.DUNGEON_POW_OUT_2F,
            TMCRegion.DUNGEON_POW_OUT_3F, TMCRegion.DUNGEON_POW_OUT_4F, TMCRegion.DUNGEON_POW_OUT_5F,
            TMCRegion.DUNGEON_POW_BLUE_WARP, TMCRegion.DUNGEON_POW_IN_1F, TMCRegion.DUNGEON_POW_IN_2F,
            TMCRegion.DUNGEON_POW_IN_3F, TMCRegion.DUNGEON_POW_IN_3F_SWITCH, TMCRegion.DUNGEON_POW_IN_4F,
            TMCRegion.DUNGEON_POW_RED_WARP, TMCRegion.DUNGEON_POW_IN_5F, TMCRegion.DUNGEON_POW_IN_4F_END,
            TMCRegion.DUNGEON_POW_IN_5F_END, TMCRegion.DUNGEON_POW_CLEAR},
    "DHC": {TMCRegion.DUNGEON_DHC_B1_WEST, TMCRegion.DUNGEON_DHC_B2, TMCRegion.DUNGEON_DHC_ENTRANCE,
            TMCRegion.DUNGEON_DHC_B1_EAST, TMCRegion.DUNGEON_DHC_1F, TMCRegion.DUNGEON_DHC_OUTSIDE,
            TMCRegion.DUNGEON_DHC_RED_WARP, TMCRegion.DUNGEON_DHC_BLUE_WARP},
    "RC": {TMCRegion.DUNGEON_RC, TMCRegion.DUNGEON_RC_CLEAR},
}

WIND_CRESTS = {
    TMCCrests.CRENEL: 0x01,
    TMCCrests.FALLS: 0x02,
    TMCCrests.CLOUDS: 0x04,
    # TMCCrests.TOWN: 0x08, # Temporarily excluded to keep always enabled
    # TMCCrests.LAKE: 0x10, # Temporarily excluded to keep always enabled
    TMCCrests.SWAMP: 0x20,
    TMCCrests.SMITH: 0x40,
    TMCCrests.MINISH: 0x80,
}

EXTERNAL_ITEMS = [0x18, 0x19, 0x1A]
EXTERNAL_ITEM_MAP: dict[ItemClassification, Callable[[object], int]] = {
    ItemClassification.filler: lambda random: 0x1A,
    ItemClassification.progression: lambda random: 0x18,
    ItemClassification.useful: lambda random: 0x19,
    ItemClassification.trap: lambda random: random.choice(EXTERNAL_ITEMS),
    ItemClassification.skip_balancing: lambda random: 0x19,
    ItemClassification.progression_skip_balancing: lambda random: 0x18,
}

ALL_EVENTS: list[tuple[str, str]] = [
    (TMCRegion.DUNGEON_TOD_EAST_SWITCH, TMCEvent.DROPLETS_EAST_SWITCH),
    (TMCRegion.DUNGEON_TOD_WEST_SWITCH, TMCEvent.DROPLETS_WEST_SWITCH),
]

ALL_REGIONS = [
    TMCRegion.SOUTH_FIELD,
    TMCRegion.SOUTH_PUDDLE,
    TMCRegion.HYRULE_TOWN,
    TMCRegion.NORTH_FIELD,
    TMCRegion.CASTLE_EXTERIOR,
    TMCRegion.EASTERN_HILLS,
    TMCRegion.LONLON,
    TMCRegion.LOWER_FALLS,
    TMCRegion.LAKE_HYLIA_NORTH,
    TMCRegion.LAKE_HYLIA_SOUTH,
    TMCRegion.MINISH_WOODS,
    TMCRegion.BELARI,
    TMCRegion.TRILBY_HIGHLANDS,
    TMCRegion.WESTERN_WOODS,
    TMCRegion.CRENEL_BASE,
    TMCRegion.CRENEL,
    TMCRegion.MELARI,
    TMCRegion.CASTOR_WILDS,
    TMCRegion.WIND_RUINS,
    TMCRegion.ROYAL_VALLEY,
    TMCRegion.GRAVEYARD,
    TMCRegion.DUNGEON_RC,
    TMCRegion.DUNGEON_RC_CLEAR,
    TMCRegion.FALLS_ENTRANCE,
    TMCRegion.MIDDLE_FALLS,
    TMCRegion.UPPER_FALLS,
    TMCRegion.CLOUDS,
    TMCRegion.WIND_TRIBE,
    TMCRegion.DUNGEON_DWS_ENTRANCE,
    TMCRegion.DUNGEON_DWS_BARREL,
    TMCRegion.DUNGEON_DWS_MULLDOZER,
    TMCRegion.DUNGEON_DWS_BACK_HALF,
    TMCRegion.DUNGEON_DWS_BLUE_WARP,
    TMCRegion.DUNGEON_DWS_RED_WARP,
    TMCRegion.DUNGEON_DWS_CLEAR,
    TMCRegion.DUNGEON_COF_ENTRANCE,
    TMCRegion.DUNGEON_COF_MAIN,
    TMCRegion.DUNGEON_COF_MINECART,
    TMCRegion.DUNGEON_COF_BLUE_WARP,
    TMCRegion.DUNGEON_COF_LAVA_BASEMENT,
    TMCRegion.DUNGEON_COF_CLEAR,
    TMCRegion.DUNGEON_FOW_ENTRANCE,
    TMCRegion.DUNGEON_FOW_EYEGORE,
    TMCRegion.DUNGEON_FOW_BLUE_WARP,
    TMCRegion.DUNGEON_FOW_CLEAR,
    TMCRegion.DUNGEON_TOD_ENTRANCE,
    TMCRegion.DUNGEON_TOD_MAIN,
    TMCRegion.DUNGEON_TOD_LEFT_BASEMENT,
    TMCRegion.DUNGEON_TOD_DARK_MAZE_END,
    TMCRegion.DUNGEON_TOD_WEST_SWITCH_LEDGE,
    TMCRegion.DUNGEON_TOD_EAST_SWITCH,
    TMCRegion.DUNGEON_TOD_WEST_SWITCH,
    TMCRegion.DUNGEON_TOD_CLEAR,
    TMCRegion.DUNGEON_POW_ENTRANCE,
    TMCRegion.DUNGEON_POW_OUT_1F,
    TMCRegion.DUNGEON_POW_OUT_2F,
    TMCRegion.DUNGEON_POW_OUT_3F,
    TMCRegion.DUNGEON_POW_OUT_4F,
    TMCRegion.DUNGEON_POW_OUT_5F,
    TMCRegion.DUNGEON_POW_BLUE_WARP,
    TMCRegion.DUNGEON_POW_IN_1F,
    TMCRegion.DUNGEON_POW_IN_2F,
    TMCRegion.DUNGEON_POW_IN_3F,
    TMCRegion.DUNGEON_POW_IN_3F_SWITCH,
    TMCRegion.DUNGEON_POW_IN_4F,
    TMCRegion.DUNGEON_POW_RED_WARP,
    TMCRegion.DUNGEON_POW_IN_5F,
    TMCRegion.DUNGEON_POW_IN_4F_END,
    TMCRegion.DUNGEON_POW_IN_5F_END,
    TMCRegion.DUNGEON_POW_CLEAR,
    TMCRegion.SANCTUARY,
    TMCRegion.STAINED_GLASS,
    TMCRegion.DUNGEON_DHC_B1_WEST,
    TMCRegion.DUNGEON_DHC_B2,
    TMCRegion.DUNGEON_DHC_ENTRANCE,
    TMCRegion.DUNGEON_DHC_B1_EAST,
    TMCRegion.DUNGEON_DHC_1F,
    TMCRegion.DUNGEON_DHC_OUTSIDE,
    TMCRegion.DUNGEON_DHC_RED_WARP,
    TMCRegion.DUNGEON_DHC_BLUE_WARP,
    TMCRegion.VAATI_FIGHT,
]