from typing import Dict, Tuple

from ..enums import ZorkGrandInquisitorLocations


tracker_location_groups: Dict[str, Tuple[ZorkGrandInquisitorLocations]] = {
    "Anywhere": (
        ZorkGrandInquisitorLocations.DONT_GO_SPENDING_IT_ALL_IN_ONE_PLACE,
        ZorkGrandInquisitorLocations.OLD_SCRATCH_WINNER,
    ),
    "Anywhere - Deathsanity": (
        ZorkGrandInquisitorLocations.DEATH_LOST_SOUL_TO_OLD_SCRATCH,
    ),
    "Inquisition Headquarters": (
        ZorkGrandInquisitorLocations.ME_I_AM_THE_BOSS_OF_YOU,
        ZorkGrandInquisitorLocations.TOTEMIZED_DAILY_BILLBOARD,
    ),
    "Inquisition Headquarters - Landmarksanity": (
        ZorkGrandInquisitorLocations.LANDMARK_INQUISITION_HEADQUARTERS,
    ),
    "Outside Port Foozle": (
        ZorkGrandInquisitorLocations.ELSEWHERE,
    ),
    "Port Foozle": (
        ZorkGrandInquisitorLocations.ARREST_THE_VANDAL,
        ZorkGrandInquisitorLocations.CUT_THAT_OUT_YOU_LITTLE_CREEP,
        ZorkGrandInquisitorLocations.FIRE_FIRE,
        ZorkGrandInquisitorLocations.GO_AWAY,
        ZorkGrandInquisitorLocations.HELP_ME_CANT_BREATHE,
        ZorkGrandInquisitorLocations.IM_COMPLETELY_NUDE,
        ZorkGrandInquisitorLocations.ITS_ONE_OF_THOSE_ADVENTURERS_AGAIN,
        ZorkGrandInquisitorLocations.I_DONT_WANT_NO_TROUBLE,
        ZorkGrandInquisitorLocations.MEAD_LIGHT,
        ZorkGrandInquisitorLocations.NO_AUTOGRAPHS,
        ZorkGrandInquisitorLocations.NO_BONDAGE,
        ZorkGrandInquisitorLocations.ONLY_YOU_CAN_PREVENT_FOOZLE_FIRES,
        ZorkGrandInquisitorLocations.TALK_TO_ME_GRAND_INQUISITOR,
        ZorkGrandInquisitorLocations.THATS_A_ROPE,
        ZorkGrandInquisitorLocations.THATS_THE_SPIRIT,
        ZorkGrandInquisitorLocations.WHAT_ARE_YOU_STUPID,
        ZorkGrandInquisitorLocations.YOU_ONE_OF_THEM_AGITATORS_AINT_YA,
        ZorkGrandInquisitorLocations.YOU_WANT_A_PIECE_OF_ME_DOCK_BOY,
    ),
    "Port Foozle - Deathsanity": (
        ZorkGrandInquisitorLocations.DEATH_ARRESTED_WITH_JACK,
    ),
    "Port Foozle - Landmarksanity": (
        ZorkGrandInquisitorLocations.LANDMARK_PORT_FOOZLE,
    ),
    "Jack's Shop": (
        ZorkGrandInquisitorLocations.PLANETFALL,
    ),
    "Jack's Shop - Landmarksanity": (
        ZorkGrandInquisitorLocations.LANDMARK_JACKS_SHOP,
    ),
    "Dungeon Master's Lair": (
        ZorkGrandInquisitorLocations.BOING_BOING_BOING,
        ZorkGrandInquisitorLocations.BONK,
        ZorkGrandInquisitorLocations.CASTLE_WATCHING_A_FIELD_GUIDE,
        ZorkGrandInquisitorLocations.DENIED_BY_THE_LAKE_MONSTER,
        ZorkGrandInquisitorLocations.EGGPLANTS,
        ZorkGrandInquisitorLocations.FLYING_SNAPDRAGON,
        ZorkGrandInquisitorLocations.FROBUARY_3_UNDERGROUNDHOG_DAY,
        ZorkGrandInquisitorLocations.HELLO_THIS_IS_SHONA_FROM_GURTH_PUBLISHING,
        ZorkGrandInquisitorLocations.ITS_PLAYING_A_LITTLE_HARD_TO_GET,
        ZorkGrandInquisitorLocations.IT_DOESNT_APPEAR_TO_BE_FOOLED,
        ZorkGrandInquisitorLocations.I_DONT_THINK_YOU_WOULDVE_WANTED_THAT_TO_WORK_ANYWAY,
        ZorkGrandInquisitorLocations.LIT_SUNFLOWERS,
        ZorkGrandInquisitorLocations.MUSHROOM_HAMMERED,
        ZorkGrandInquisitorLocations.NATURAL_AND_SUPERNATURAL_CREATURES_OF_QUENDOR,
        ZorkGrandInquisitorLocations.NOTHIN_LIKE_A_GOOD_STOGIE,
        ZorkGrandInquisitorLocations.OH_WOW_TALK_ABOUT_DEJA_VU,
        ZorkGrandInquisitorLocations.OUTSMART_THE_QUELBEES,
        ZorkGrandInquisitorLocations.PROZORKED,
        ZorkGrandInquisitorLocations.REASSEMBLE_SNAVIG,
        ZorkGrandInquisitorLocations.RIGHT_HELLO_YES_UH_THIS_IS_SNEFFLE,
        ZorkGrandInquisitorLocations.RIGHT_UH_SORRY_ITS_ME_AGAIN_SNEFFLE,
        ZorkGrandInquisitorLocations.TAMING_YOUR_SNAPDRAGON,
        ZorkGrandInquisitorLocations.THROCKED_MUSHROOM_HAMMERED,
        ZorkGrandInquisitorLocations.WANT_SOME_RYE_COURSE_YA_DO,
        ZorkGrandInquisitorLocations.WHITE_HOUSE_TIME_TUNNEL,
        ZorkGrandInquisitorLocations.WOW_IVE_NEVER_GONE_INSIDE_HIM_BEFORE,
        ZorkGrandInquisitorLocations.YAD_GOHDNUORGREDNU_3_YRAUBORF,
        ZorkGrandInquisitorLocations.YOUR_PUNY_WEAPONS_DONT_PHASE_ME_BABY,
    ),
    "Dungeon Master's Lair - Deathsanity": (
        ZorkGrandInquisitorLocations.DEATH_ATTACKED_THE_QUELBEES,
        ZorkGrandInquisitorLocations.DEATH_OUTSMARTED_BY_THE_QUELBEES,
    ),
    "Dungeon Master's Lair - Landmarksanity": (
        ZorkGrandInquisitorLocations.LANDMARK_DUNGEON_MASTERS_HOUSE,
        ZorkGrandInquisitorLocations.LANDMARK_MIRROR_ROOM,
        ZorkGrandInquisitorLocations.LANDMARK_WALKING_CASTLES_HEART,
    ),
    "Flood Control Dam #3": (
        ZorkGrandInquisitorLocations.BEAUTIFUL_THATS_PLENTY,
        ZorkGrandInquisitorLocations.FLOOD_CONTROL_DAM_3_THE_NOT_REMOTELY_BORING_TALE,
        ZorkGrandInquisitorLocations.NATIONAL_TREASURE,
        ZorkGrandInquisitorLocations.SOUVENIR,
        ZorkGrandInquisitorLocations.USELESS_BUT_FUN,
    ),
    "Flood Control Dam #3 - Landmarksanity": (
        ZorkGrandInquisitorLocations.LANDMARK_FLOOD_CONTROL_DAM_3,
    ),
    "Hades": (
        ZorkGrandInquisitorLocations.A_BIG_FAT_SASSY_2_HEADED_MONSTER,
        ZorkGrandInquisitorLocations.A_LETTER_FROM_THE_WHITE_HOUSE,
        ZorkGrandInquisitorLocations.DONT_EVEN_START_WITH_US_SPARKY,
        ZorkGrandInquisitorLocations.DRAGON_ARCHIPELAGO_TIME_TUNNEL,
        ZorkGrandInquisitorLocations.HAVE_A_HELL_OF_A_DAY,
        ZorkGrandInquisitorLocations.I_AM_NOT_IMPRESSED,
        ZorkGrandInquisitorLocations.MAKE_LOVE_NOT_WAR,
        ZorkGrandInquisitorLocations.NOW_YOU_LOOK_LIKE_US_WHICH_IS_AN_IMPROVEMENT,
        ZorkGrandInquisitorLocations.NO_ONE_RETURNS_FROM_HADES,
        ZorkGrandInquisitorLocations.OPEN_THE_GATES_OF_HELL,
    ),
    "Hades - Deathsanity": (
        ZorkGrandInquisitorLocations.DEATH_YOURE_NOT_CHARON,
    ),
    "Hades - Landmarksanity": (
        ZorkGrandInquisitorLocations.LANDMARK_GATES_OF_HELL,
        ZorkGrandInquisitorLocations.LANDMARK_HADES_SHORE,
    ),
    "GUE Tech Hallway": (
        ZorkGrandInquisitorLocations.ARTIFACTS_EXPLAINED,
        ZorkGrandInquisitorLocations.BEBURTT_DEMYSTIFIED,
        ZorkGrandInquisitorLocations.BETTER_SPELL_MANUFACTURING_IN_UNDER_10_MINUTES,
        ZorkGrandInquisitorLocations.CAVES_NOTES,
        ZorkGrandInquisitorLocations.CRISIS_AVERTED,
        ZorkGrandInquisitorLocations.HOW_TO_WIN_AT_DOUBLE_FANUCCI,
        ZorkGrandInquisitorLocations.THE_ONLY_WAY_TO_WIN_IS_NOT_TO_PLAY,
        ZorkGrandInquisitorLocations.TIME_TRAVEL_FOR_DUMMIES,
    ),
    "GUE Tech": (
        ZorkGrandInquisitorLocations.ALARM_SYSTEM_IS_DOWN,
        ZorkGrandInquisitorLocations.A_SMALLWAY,
        ZorkGrandInquisitorLocations.DUNCE_LOCKER,
        ZorkGrandInquisitorLocations.EMERGENCY_MAGICATRONIC_MESSAGE,
        ZorkGrandInquisitorLocations.GETTING_SOME_CHANGE,
        ZorkGrandInquisitorLocations.GUE_TECH_ENTRANCE_EXAM,
        ZorkGrandInquisitorLocations.HEY_FREE_DIRT,
        ZorkGrandInquisitorLocations.ITS_ALMOST_AS_IF_IT_WERE_INFINITE,
        ZorkGrandInquisitorLocations.LOOK_AN_ICE_CREAM_BAR,
        ZorkGrandInquisitorLocations.MIKES_PANTS,
        ZorkGrandInquisitorLocations.NOOOOOOOOOOOOO,
        ZorkGrandInquisitorLocations.PLEASE_DONT_THROCK_THE_GRASS,
        ZorkGrandInquisitorLocations.RESTOCKED_ON_GRUESDAY,
        ZorkGrandInquisitorLocations.SUCKING_ROCKS,
    ),
    "GUE Tech - Deathsanity": (
        ZorkGrandInquisitorLocations.DEATH_JUMPED_IN_BOTTOMLESS_PIT,
        ZorkGrandInquisitorLocations.DEATH_STEPPED_INTO_THE_INFINITE,
        ZorkGrandInquisitorLocations.DEATH_THROCKED_THE_GRASS,
        ZorkGrandInquisitorLocations.DEATH_ZORK_ROCKS_EXPLODED,
    ),
    "GUE Tech - Landmarksanity": (
        ZorkGrandInquisitorLocations.LANDMARK_GUE_TECH_FOUNTAIN_INSIDE,
        ZorkGrandInquisitorLocations.LANDMARK_INFINITE_CORRIDOR,
        ZorkGrandInquisitorLocations.LANDMARK_GUE_TECH_FOUNTAIN_OUTSIDE,
    ),
    "Spell Lab": (
        ZorkGrandInquisitorLocations.FAT_LOT_OF_GOOD_THATLL_DO_YA,
        ZorkGrandInquisitorLocations.IMBUE_BEBURTT,
        ZorkGrandInquisitorLocations.I_LIKE_YOUR_STYLE,
        ZorkGrandInquisitorLocations.I_SPIT_ON_YOUR_FILTHY_COINAGE,
        ZorkGrandInquisitorLocations.OBIDIL_DRIED_UP,
        ZorkGrandInquisitorLocations.PURPLE_BEAST_ALARM_SYSTEM,
        ZorkGrandInquisitorLocations.SNAVIG_REPAIRED,
        ZorkGrandInquisitorLocations.SPELL_CHECK_COMPLETE,
        ZorkGrandInquisitorLocations.THATS_STILL_A_ROPE,
        ZorkGrandInquisitorLocations.YOU_DONT_GO_MESSING_WITH_A_MANS_ZIPPER,
        ZorkGrandInquisitorLocations.YOU_GAINED_86_EXPERIENCE_POINTS,
        ZorkGrandInquisitorLocations.ZIMDOR_IS_UNDAMAGED,
    ),
    "Spell Lab - Deathsanity": (
        ZorkGrandInquisitorLocations.DEATH_SLICED_UP_BY_THE_INVISIBLE_GUARD,
    ),
    "Spell Lab - Landmarksanity": (
        ZorkGrandInquisitorLocations.LANDMARK_SPELL_CHECKER,
    ),
    "Hades Station": (
        ZorkGrandInquisitorLocations.HOW_TO_HYPNOTIZE_YOURSELF,
        ZorkGrandInquisitorLocations.VOYAGE_OF_CAPTAIN_ZAHAB,
    ),
    "Crossroads": (
        ZorkGrandInquisitorLocations.INTO_THE_FOLIAGE,
        ZorkGrandInquisitorLocations.INVISIBLE_FLOWERS,
        ZorkGrandInquisitorLocations.IN_CASE_OF_ADVENTURE,
        ZorkGrandInquisitorLocations.IN_MAGIC_WE_TRUST,
        ZorkGrandInquisitorLocations.THE_UNDERGROUND_UNDERGROUND,
        ZorkGrandInquisitorLocations.UMBRELLA_FLOWERS,
    ),
    "Crossroads - Deathsanity": (
        ZorkGrandInquisitorLocations.DEATH_CLIMBED_OUT_OF_THE_WELL,
    ),
    "Crossroads - Landmarksanity": (
        ZorkGrandInquisitorLocations.LANDMARK_GREAT_UNDERGROUND_EMPIRE_ENTRANCE,
        ZorkGrandInquisitorLocations.LANDMARK_UMBRELLA_TREE,
        ZorkGrandInquisitorLocations.LANDMARK_UNDERGROUND_UNDERGROUND_ENTRANCE,
    ),
    "Crossroads Station": (
        ZorkGrandInquisitorLocations.BRAVE_SOULS_WANTED,
        ZorkGrandInquisitorLocations.ENJOY_YOUR_TRIP,
        ZorkGrandInquisitorLocations.THATS_IT_JUST_KEEP_HITTING_THOSE_BUTTONS,
    ),
    "Monastery": (
        ZorkGrandInquisitorLocations.CLOSING_THE_TIME_TUNNELS,
        ZorkGrandInquisitorLocations.HMMM_INFORMATIVE_YET_DEEPLY_DISTURBING,
        ZorkGrandInquisitorLocations.PERMASEAL,
        ZorkGrandInquisitorLocations.PORT_FOOZLE_TIME_TUNNEL,
        ZorkGrandInquisitorLocations.STRAIGHT_TO_HELL,
        ZorkGrandInquisitorLocations.THE_ALCHEMICAL_DEBACLE,
        ZorkGrandInquisitorLocations.THE_ENDLESS_FIRE,
        ZorkGrandInquisitorLocations.THE_FLATHEADIAN_FUDGE_FIASCO,
        ZorkGrandInquisitorLocations.THE_PERILS_OF_MAGIC,
    ),
    "Monastery - Deathsanity": (
        ZorkGrandInquisitorLocations.DEATH_TOTEMIZED_INFINITY,
        ZorkGrandInquisitorLocations.DEATH_TOTEMIZED_NEWARK_NEW_JERSEY,
        ZorkGrandInquisitorLocations.DEATH_TOTEMIZED_PERMANENTLY_HALLS_OF_INQUISITION,
        ZorkGrandInquisitorLocations.DEATH_TOTEMIZED_PERMANENTLY_INFINITY,
        ZorkGrandInquisitorLocations.DEATH_TOTEMIZED_PERMANENTLY_NEWARK_NEW_JERSEY,
        ZorkGrandInquisitorLocations.DEATH_TOTEMIZED_PERMANENTLY_STRAIGHT_TO_HELL,
        ZorkGrandInquisitorLocations.DEATH_TOTEMIZED_PERMANENTLY_SURFACE_OF_MERZ,
        ZorkGrandInquisitorLocations.DEATH_TOTEMIZED_SURFACE_OF_MERZ,
    ),
    "Monastery - Landmarksanity": (
        ZorkGrandInquisitorLocations.LANDMARK_TOTEMIZER,
    ),
    "Dragon Archipelago": (
        ZorkGrandInquisitorLocations.AN_EXCELLENT_POPPING_UTENSIL,
        ZorkGrandInquisitorLocations.COME_TO_PAPA_YOU_NUT,
        ZorkGrandInquisitorLocations.INFLATUS_THE_ETERNAL,
        ZorkGrandInquisitorLocations.OH_DEAR_GOD_ITS_A_DRAGON,
        ZorkGrandInquisitorLocations.THAR_SHE_BLOWS,
        ZorkGrandInquisitorLocations.THIS_DOESNT_LOOK_ANYTHING_LIKE_THE_BROCHURE,
        ZorkGrandInquisitorLocations.UH_OH_BROG_CANT_SWIM,
    ),
    "Dragon Archipelago - Deathsanity": (
        ZorkGrandInquisitorLocations.DEATH_SWALLOWED_BY_A_DRAGON,
    ),
    "Dragon Archipelago - Landmarksanity": (
        ZorkGrandInquisitorLocations.LANDMARK_DRAGON_ARCHIPELAGO,
    ),
    "Past Port Foozle": (
        ZorkGrandInquisitorLocations.DINGWHACKER_DELUXE,
        ZorkGrandInquisitorLocations.OH_VERY_FUNNY_GUYS,
        ZorkGrandInquisitorLocations.STRIP_GRUE_FIRE_WATER,
        ZorkGrandInquisitorLocations.UM_AH_UM_AH_UM_AH,
        ZorkGrandInquisitorLocations.WANT_SOME_RYE_COURSE_YA_DO_PAST,
        ZorkGrandInquisitorLocations.WE_DONT_SERVE_YOUR_KIND_HERE,
        ZorkGrandInquisitorLocations.WE_GOT_A_HIGH_ROLLER,
        ZorkGrandInquisitorLocations.YOU_LOSE_MUFFET_ANTE_UP,
    ),
    "Past Port Foozle - Deathsanity": (
        ZorkGrandInquisitorLocations.DEATH_LOST_GAME_OF_STRIP_GRUE_FIRE_WATER,
    ),
    "Past Port Foozle - Landmarksanity": (
        ZorkGrandInquisitorLocations.LANDMARK_PAST_PORT_FOOZLE,
    ),
    "White House": (
        ZorkGrandInquisitorLocations.BROG_DO_GOOD,
        ZorkGrandInquisitorLocations.BROG_EAT_ROCKS,
        ZorkGrandInquisitorLocations.BROG_KNOW_DUMB_THAT_DUMB,
        ZorkGrandInquisitorLocations.BROG_MUCH_BETTER_AT_THIS_GAME,
        ZorkGrandInquisitorLocations.DOOOOOOWN,
        ZorkGrandInquisitorLocations.DOWN,
        ZorkGrandInquisitorLocations.GOOD_PUZZLE_SMART_BROG,
        ZorkGrandInquisitorLocations.HMMM_BIG_TOOTHPICK,
        ZorkGrandInquisitorLocations.MAILED_IT_TO_HELL,
        ZorkGrandInquisitorLocations.UP,
        ZorkGrandInquisitorLocations.UUUUUP,
        ZorkGrandInquisitorLocations.WHOOPS,
    ),
    "White House - Deathsanity": (
        ZorkGrandInquisitorLocations.DEATH_EATEN_BY_A_GRUE,
    ),
    "White House - Landmarksanity": (
        ZorkGrandInquisitorLocations.LANDMARK_WHITE_HOUSE,
    ),
}

# X, Y, Left-to-Right?, Maximum per Row
tracker_location_group_configuration: Dict[str, Tuple[int, int, bool, int]] = {
    "Anywhere": (160, 380, True, 10),
    "Anywhere - Deathsanity": (250, 380, False, 10),
    "Inquisition Headquarters": (44, 240, True, 10),
    "Inquisition Headquarters - Landmarksanity": (44, 110, True, 10),
    "Outside Port Foozle": (404, 240, True, 10),
    "Port Foozle": (764, 210, True, 10),
    "Port Foozle - Deathsanity": (1034, 110, False, 10),
    "Port Foozle - Landmarksanity": (764, 110, True, 10),
    "Jack's Shop": (1126, 240, True, 10),
    "Jack's Shop - Landmarksanity": (1126, 110, True, 10),
    "Dungeon Master's Lair": (160, 560, True, 10),
    "Dungeon Master's Lair - Deathsanity": (430, 520, False, 10),
    "Dungeon Master's Lair - Landmarksanity": (160, 520, True, 10),
    "Flood Control Dam #3": (820, 550, True, 10),
    "Flood Control Dam #3 - Landmarksanity": (820, 485, True, 10),
    "Hades": (1050, 530, True, 10),
    "Hades - Deathsanity": (1320, 490, False, 10),
    "Hades - Landmarksanity": (1050, 490, True, 10),
    "GUE Tech Hallway": (650, 690, True, 4),
    "GUE Tech": (560, 760, True, 10),
    "GUE Tech - Deathsanity": (830, 650, False, 10),
    "GUE Tech - Landmarksanity": (560, 650, True, 10),
    "Spell Lab": (960, 720, True, 6),
    "Spell Lab - Deathsanity": (1110, 680, False, 10),
    "Spell Lab - Landmarksanity": (960, 680, True, 10),
    "Hades Station": (1235, 700, True, 10),
    "Crossroads": (135, 880, True, 10),
    "Crossroads - Deathsanity": (315, 840, False, 10),
    "Crossroads - Landmarksanity": (135, 840, True, 10),
    "Crossroads Station": (400, 965, True, 10),
    "Monastery": (1000, 990, True, 5),
    "Monastery - Deathsanity": (1270, 950, False, 10),
    "Monastery - Landmarksanity": (1000, 950, True, 10),
    "Dragon Archipelago": (222, 1326, True, 10),
    "Dragon Archipelago - Deathsanity": (492, 1196, False, 10),
    "Dragon Archipelago - Landmarksanity": (222, 1196, True, 10),
    "Past Port Foozle": (582, 1326, True, 10),
    "Past Port Foozle - Deathsanity": (852, 1196, False, 10),
    "Past Port Foozle - Landmarksanity": (582, 1196, True, 10),
    "White House": (942, 1296, True, 10),
    "White House - Deathsanity": (1212, 1196, False, 10),
    "White House - Landmarksanity": (942, 1196, True, 10),
}
