from typing import Dict, Set, Tuple

from ..enums import ZorkGrandInquisitorRegions as ZGIRegions


entrances_to_game_location_teleports: Dict[
    Tuple[ZGIRegions, ZGIRegions],
    Tuple[str, str],
] = {
    (ZGIRegions.BOTTOM_OF_THE_WELL, ZGIRegions.CROSSROADS): ("u c 1 0", "25"),
    (ZGIRegions.BOTTOM_OF_THE_WELL, ZGIRegions.OUTSIDE_PORT_FOOZLE_WELL): ("p c 1 0", "250"),
    (ZGIRegions.CROSSROADS, ZGIRegions.BOTTOM_OF_THE_WELL): ("u w 1 0", "30"),
    (ZGIRegions.CROSSROADS, ZGIRegions.DM_LAIR): ("d g 1 0", "1410"),
    (ZGIRegions.CROSSROADS, ZGIRegions.GUE_TECH_ENTRANCE): ("t e 1 0", "200"),
    (ZGIRegions.CROSSROADS, ZGIRegions.SUBWAY_CROSSROADS): ("u s 1 0", "1440"),
    (ZGIRegions.DM_LAIR, ZGIRegions.CROSSROADS): ("u c 3 0", "500"),
    (ZGIRegions.DM_LAIR, ZGIRegions.DM_LAIR_INTERIOR): ("d v 1 0", "1590"),
    (ZGIRegions.DM_LAIR_INTERIOR, ZGIRegions.DM_LAIR): ("d g 4 0", "120"),
    (ZGIRegions.DM_LAIR_INTERIOR, ZGIRegions.WALKING_CASTLE): ("d c 1 0", "1150"),
    (ZGIRegions.GUE_TECH, ZGIRegions.GUE_TECH_ENTRANCE): ("t e 3 0", "1010"),
    (ZGIRegions.GUE_TECH, ZGIRegions.GUE_TECH_OUTSIDE): ("t e 4 0", "1120"),
    (ZGIRegions.GUE_TECH_ENTRANCE, ZGIRegions.CROSSROADS): ("u c 4 0", "470"),
    (ZGIRegions.GUE_TECH_ENTRANCE, ZGIRegions.GUE_TECH): ("t r 1 0", "150"),
    (ZGIRegions.GUE_TECH_HALLWAY, ZGIRegions.SPELL_LAB_BRIDGE): ("t p 1 0", "1080"),
    (ZGIRegions.GUE_TECH_OUTSIDE, ZGIRegions.GUE_TECH): ("t r 1 0", "150"),
    (ZGIRegions.HADES, ZGIRegions.HADES_BEYOND_GATES): ("h p 6 0", "380"),
    (ZGIRegions.HADES, ZGIRegions.HADES_SHORE): ("h p 1 0", "1480"),
    (ZGIRegions.HADES_BEYOND_GATES, ZGIRegions.HADES): ("h p 5 0", "1350"),
    (ZGIRegions.HADES_SHORE, ZGIRegions.HADES): ("h p 4 0", "340"),
    (ZGIRegions.HADES_SHORE, ZGIRegions.SUBWAY_HADES): ("u h 1 0", "0"),
    (ZGIRegions.MONASTERY, ZGIRegions.MONASTERY_EXHIBIT): ("m e 2 0", "900"),
    (ZGIRegions.MONASTERY, ZGIRegions.SUBWAY_MONASTERY): ("u m 1 0", "1590"),
    (ZGIRegions.MONASTERY_EXHIBIT, ZGIRegions.MONASTERY): ("m t 3 0", "0"),
    (ZGIRegions.OUTSIDE_PORT_FOOZLE_INQUISITION_HQ, ZGIRegions.OUTSIDE_PORT_FOOZLE_SIGNPOST): ("p s 1 0", "680"),
    (ZGIRegions.OUTSIDE_PORT_FOOZLE_SIGNPOST, ZGIRegions.OUTSIDE_PORT_FOOZLE_INQUISITION_HQ): ("p x 1 0", "50"),
    (ZGIRegions.OUTSIDE_PORT_FOOZLE_SIGNPOST, ZGIRegions.OUTSIDE_PORT_FOOZLE_WELL): ("p s 2 0", "1360"),
    (ZGIRegions.OUTSIDE_PORT_FOOZLE_SIGNPOST, ZGIRegions.PORT_FOOZLE): ("p e 1 0", "210"),
    (ZGIRegions.OUTSIDE_PORT_FOOZLE_WELL, ZGIRegions.BOTTOM_OF_THE_WELL): ("u w 1 0", "0"),
    (ZGIRegions.OUTSIDE_PORT_FOOZLE_WELL, ZGIRegions.OUTSIDE_PORT_FOOZLE_SIGNPOST): ("p s 1 0", "170"),
    (ZGIRegions.PORT_FOOZLE, ZGIRegions.OUTSIDE_PORT_FOOZLE_SIGNPOST): ("p s 1 0", "1430"),
    (ZGIRegions.PORT_FOOZLE, ZGIRegions.PORT_FOOZLE_JACKS_SHOP): ("p p 1 0", "1130"),
    (ZGIRegions.PORT_FOOZLE_JACKS_SHOP, ZGIRegions.PORT_FOOZLE): ("p e 1 0", "1630"),
    (ZGIRegions.SPELL_LAB, ZGIRegions.SPELL_LAB_BRIDGE): ("t p 1 0", "140"),
    (ZGIRegions.SPELL_LAB_BRIDGE, ZGIRegions.GUE_TECH_HALLWAY): ("t h 3 0", "740"),
    (ZGIRegions.SPELL_LAB_BRIDGE, ZGIRegions.SPELL_LAB): ("t p 2 0", "1240"),
    (ZGIRegions.SUBWAY_CROSSROADS, ZGIRegions.CROSSROADS): ("u c 6 0", "1320"),
    (ZGIRegions.SUBWAY_CROSSROADS, ZGIRegions.SUBWAY_FLOOD_CONTROL_DAM): ("u e 2 0", "1030"),
    (ZGIRegions.SUBWAY_CROSSROADS, ZGIRegions.SUBWAY_HADES): ("u h 2 0", "1030"),
    (ZGIRegions.SUBWAY_CROSSROADS, ZGIRegions.SUBWAY_MONASTERY): ("u m 2 0", "1030"),
    (ZGIRegions.SUBWAY_FLOOD_CONTROL_DAM, ZGIRegions.SUBWAY_CROSSROADS): ("u s 2 0", "1030"),
    (ZGIRegions.SUBWAY_FLOOD_CONTROL_DAM, ZGIRegions.SUBWAY_HADES): ("u h 2 0", "1030"),
    (ZGIRegions.SUBWAY_FLOOD_CONTROL_DAM, ZGIRegions.SUBWAY_MONASTERY): ("u m 2 0", "1030"),
    (ZGIRegions.SUBWAY_HADES, ZGIRegions.HADES_SHORE): ("h p 1 0", "530"),
    (ZGIRegions.SUBWAY_HADES, ZGIRegions.SUBWAY_CROSSROADS): ("u s 2 0", "1030"),
    (ZGIRegions.SUBWAY_HADES, ZGIRegions.SUBWAY_FLOOD_CONTROL_DAM): ("u e 2 0", "1030"),
    (ZGIRegions.SUBWAY_HADES, ZGIRegions.SUBWAY_MONASTERY): ("u m 2 0", "1030"),
    (ZGIRegions.SUBWAY_MONASTERY, ZGIRegions.MONASTERY): ("m t 1 0", "1530"),
    (ZGIRegions.SUBWAY_MONASTERY, ZGIRegions.SUBWAY_CROSSROADS): ("u s 2 0", "1030"),
    (ZGIRegions.SUBWAY_MONASTERY, ZGIRegions.SUBWAY_FLOOD_CONTROL_DAM): ("u e 2 0", "1030"),
    (ZGIRegions.SUBWAY_MONASTERY, ZGIRegions.SUBWAY_HADES): ("u h 2 0", "1030"),
    (ZGIRegions.WALKING_CASTLE, ZGIRegions.DM_LAIR_INTERIOR): ("d v 1 0", "680"),
}

entrances_to_game_locations: Dict[
    Tuple[Tuple[ZGIRegions, ZGIRegions]],
    Tuple[Tuple[str, str], ...],
] = {
    (ZGIRegions.BOTTOM_OF_THE_WELL, ZGIRegions.CROSSROADS): (("uw1f", "uc10"),),
    (ZGIRegions.BOTTOM_OF_THE_WELL, ZGIRegions.OUTSIDE_PORT_FOOZLE_WELL): (("uw10", "pc10"),),
    (ZGIRegions.CROSSROADS, ZGIRegions.BOTTOM_OF_THE_WELL): (("uc10", "uw10"),),
    (ZGIRegions.CROSSROADS, ZGIRegions.DM_LAIR): (("uc30", "dg10"),),
    (ZGIRegions.CROSSROADS, ZGIRegions.GUE_TECH_ENTRANCE): (("uc40", "te10"),),
    (ZGIRegions.CROSSROADS, ZGIRegions.SUBWAY_CROSSROADS): (("uc60", "us10"),),
    (ZGIRegions.DM_LAIR, ZGIRegions.CROSSROADS): (("dg10", "uc30"),),
    (ZGIRegions.DM_LAIR, ZGIRegions.DM_LAIR_INTERIOR): (("dg40", "dv10"),),
    (ZGIRegions.DM_LAIR_INTERIOR, ZGIRegions.DM_LAIR): (("dv10", "dg40"),),
    (ZGIRegions.DM_LAIR_INTERIOR, ZGIRegions.WALKING_CASTLE): (("dv10", "dc10"),),
    (ZGIRegions.GUE_TECH, ZGIRegions.GUE_TECH_ENTRANCE): (("tr1g", "te30"),),
    (ZGIRegions.GUE_TECH, ZGIRegions.GUE_TECH_OUTSIDE): (("tr1k", "te40"),),
    (ZGIRegions.GUE_TECH_ENTRANCE, ZGIRegions.CROSSROADS): (("te10", "uc40"),),
    (ZGIRegions.GUE_TECH_ENTRANCE, ZGIRegions.GUE_TECH): (("te3e", "tr10"),),
    (ZGIRegions.GUE_TECH_HALLWAY, ZGIRegions.SPELL_LAB_BRIDGE): (("th30", "tp10"),),
    (ZGIRegions.GUE_TECH_OUTSIDE, ZGIRegions.GUE_TECH): (("te40", "tr10"),),
    (ZGIRegions.HADES, ZGIRegions.HADES_BEYOND_GATES): (("hp50", "hp60"),),
    (ZGIRegions.HADES, ZGIRegions.HADES_SHORE): (("hp4e", "hp10"),),
    (ZGIRegions.HADES_BEYOND_GATES, ZGIRegions.HADES): (("hp60", "hp50"),),
    (ZGIRegions.HADES_SHORE, ZGIRegions.HADES): (("hp1f", "hp40"),),
    (ZGIRegions.HADES_SHORE, ZGIRegions.SUBWAY_HADES): (("hp10", "uh10"),),
    (ZGIRegions.MONASTERY, ZGIRegions.MONASTERY_EXHIBIT): (("mt2e", "me20"), ("mt30", "me20")),
    (ZGIRegions.MONASTERY, ZGIRegions.SUBWAY_MONASTERY): (("mt1e", "um10"),),
    (ZGIRegions.MONASTERY_EXHIBIT, ZGIRegions.MONASTERY): (("me5f", "mt30"),),
    (ZGIRegions.OUTSIDE_PORT_FOOZLE_INQUISITION_HQ, ZGIRegions.OUTSIDE_PORT_FOOZLE_SIGNPOST): (("px10", "ps10"),),
    (ZGIRegions.OUTSIDE_PORT_FOOZLE_SIGNPOST, ZGIRegions.OUTSIDE_PORT_FOOZLE_INQUISITION_HQ): (("ps10", "px10"),),
    (ZGIRegions.OUTSIDE_PORT_FOOZLE_SIGNPOST, ZGIRegions.OUTSIDE_PORT_FOOZLE_WELL): (("ps10", "ps20"),),
    (ZGIRegions.OUTSIDE_PORT_FOOZLE_SIGNPOST, ZGIRegions.PORT_FOOZLE): (("ps10", "pe10"),),
    (ZGIRegions.OUTSIDE_PORT_FOOZLE_WELL, ZGIRegions.BOTTOM_OF_THE_WELL): (("pc1e", "uw10"),),
    (ZGIRegions.OUTSIDE_PORT_FOOZLE_WELL, ZGIRegions.OUTSIDE_PORT_FOOZLE_SIGNPOST): (("ps20", "ps10"),),
    (ZGIRegions.PORT_FOOZLE, ZGIRegions.OUTSIDE_PORT_FOOZLE_SIGNPOST): (("pe10", "ps10"),),
    (ZGIRegions.PORT_FOOZLE, ZGIRegions.PORT_FOOZLE_JACKS_SHOP): (("pe1e", "pp10"),),
    (ZGIRegions.PORT_FOOZLE_JACKS_SHOP, ZGIRegions.PORT_FOOZLE): (("pp10", "pe10"),),
    (ZGIRegions.SPELL_LAB, ZGIRegions.SPELL_LAB_BRIDGE): (("tp20", "tp50"),),
    (ZGIRegions.SPELL_LAB_BRIDGE, ZGIRegions.GUE_TECH_HALLWAY): (("tp10", "th30"),),
    (ZGIRegions.SPELL_LAB_BRIDGE, ZGIRegions.SPELL_LAB): (("tp10", "tp50"),),
    (ZGIRegions.SUBWAY_CROSSROADS, ZGIRegions.CROSSROADS): (("us1e", "uc60"),),
    (ZGIRegions.SUBWAY_CROSSROADS, ZGIRegions.SUBWAY_FLOOD_CONTROL_DAM): (("us2f", "ue2f"),),
    (ZGIRegions.SUBWAY_CROSSROADS, ZGIRegions.SUBWAY_HADES): (("us2f", "uh2f"),),
    (ZGIRegions.SUBWAY_CROSSROADS, ZGIRegions.SUBWAY_MONASTERY): (("us2f", "um2f"),),
    (ZGIRegions.SUBWAY_FLOOD_CONTROL_DAM, ZGIRegions.SUBWAY_CROSSROADS): (("ue2f", "us2f"),),
    (ZGIRegions.SUBWAY_FLOOD_CONTROL_DAM, ZGIRegions.SUBWAY_HADES): (("ue2f", "uh2f"),),
    (ZGIRegions.SUBWAY_FLOOD_CONTROL_DAM, ZGIRegions.SUBWAY_MONASTERY): (("ue2f", "um2f"),),
    (ZGIRegions.SUBWAY_HADES, ZGIRegions.HADES_SHORE): (("uh10", "hp10"),),
    (ZGIRegions.SUBWAY_HADES, ZGIRegions.SUBWAY_CROSSROADS): (("uh2f", "us2f"),),
    (ZGIRegions.SUBWAY_HADES, ZGIRegions.SUBWAY_FLOOD_CONTROL_DAM): (("uh2f", "ue2f"),),
    (ZGIRegions.SUBWAY_HADES, ZGIRegions.SUBWAY_MONASTERY): (("uh2f", "um2f"),),
    (ZGIRegions.SUBWAY_MONASTERY, ZGIRegions.MONASTERY): (("um10", "mt10"),),
    (ZGIRegions.SUBWAY_MONASTERY, ZGIRegions.SUBWAY_CROSSROADS): (("um2f", "us2f"),),
    (ZGIRegions.SUBWAY_MONASTERY, ZGIRegions.SUBWAY_FLOOD_CONTROL_DAM): (("um2f", "ue2f"),),
    (ZGIRegions.SUBWAY_MONASTERY, ZGIRegions.SUBWAY_HADES): (("um2f", "uh2f"),),
    (ZGIRegions.WALKING_CASTLE, ZGIRegions.DM_LAIR_INTERIOR): (("dc10", "dv10"),),
}

entrances_to_game_locations_reverse: Dict[
    Tuple[str, str],
    Tuple[ZGIRegions, ZGIRegions],
] = dict()

entrance_pair: Tuple[ZGIRegions, ZGIRegions]
game_location_pairs: Tuple[Tuple[str, str], ...]
for entrance_pair, game_location_pairs in entrances_to_game_locations.items():
    game_location_pair: Tuple[str, str]
    for game_location_pair in game_location_pairs:
        entrances_to_game_locations_reverse[game_location_pair] = entrance_pair

randomizable_entrances: Tuple[Tuple[ZGIRegions, ZGIRegions]] = (
    (ZGIRegions.BOTTOM_OF_THE_WELL, ZGIRegions.CROSSROADS),
    (ZGIRegions.BOTTOM_OF_THE_WELL, ZGIRegions.OUTSIDE_PORT_FOOZLE_WELL),
    (ZGIRegions.CROSSROADS, ZGIRegions.BOTTOM_OF_THE_WELL),
    (ZGIRegions.CROSSROADS, ZGIRegions.DM_LAIR),
    (ZGIRegions.CROSSROADS, ZGIRegions.GUE_TECH_ENTRANCE),
    (ZGIRegions.CROSSROADS, ZGIRegions.SUBWAY_CROSSROADS),
    (ZGIRegions.DM_LAIR, ZGIRegions.CROSSROADS),
    (ZGIRegions.DM_LAIR, ZGIRegions.DM_LAIR_INTERIOR),
    (ZGIRegions.DM_LAIR_INTERIOR, ZGIRegions.DM_LAIR),
    (ZGIRegions.DM_LAIR_INTERIOR, ZGIRegions.WALKING_CASTLE),
    (ZGIRegions.GUE_TECH, ZGIRegions.GUE_TECH_ENTRANCE),
    (ZGIRegions.GUE_TECH, ZGIRegions.GUE_TECH_OUTSIDE),
    (ZGIRegions.GUE_TECH_ENTRANCE, ZGIRegions.CROSSROADS),
    (ZGIRegions.GUE_TECH_ENTRANCE, ZGIRegions.GUE_TECH),
    (ZGIRegions.GUE_TECH_HALLWAY, ZGIRegions.SPELL_LAB_BRIDGE),
    (ZGIRegions.GUE_TECH_OUTSIDE, ZGIRegions.GUE_TECH),
    (ZGIRegions.HADES, ZGIRegions.HADES_BEYOND_GATES),
    (ZGIRegions.HADES, ZGIRegions.HADES_SHORE),
    (ZGIRegions.HADES_BEYOND_GATES, ZGIRegions.HADES),
    (ZGIRegions.HADES_SHORE, ZGIRegions.HADES),
    (ZGIRegions.HADES_SHORE, ZGIRegions.SUBWAY_HADES),
    (ZGIRegions.MONASTERY, ZGIRegions.MONASTERY_EXHIBIT),
    (ZGIRegions.MONASTERY, ZGIRegions.SUBWAY_MONASTERY),
    (ZGIRegions.MONASTERY_EXHIBIT, ZGIRegions.MONASTERY),
    (ZGIRegions.OUTSIDE_PORT_FOOZLE_INQUISITION_HQ, ZGIRegions.OUTSIDE_PORT_FOOZLE_SIGNPOST),
    (ZGIRegions.OUTSIDE_PORT_FOOZLE_SIGNPOST, ZGIRegions.OUTSIDE_PORT_FOOZLE_INQUISITION_HQ),
    (ZGIRegions.OUTSIDE_PORT_FOOZLE_SIGNPOST, ZGIRegions.OUTSIDE_PORT_FOOZLE_WELL),
    (ZGIRegions.OUTSIDE_PORT_FOOZLE_SIGNPOST, ZGIRegions.PORT_FOOZLE),
    (ZGIRegions.OUTSIDE_PORT_FOOZLE_WELL, ZGIRegions.BOTTOM_OF_THE_WELL),
    (ZGIRegions.OUTSIDE_PORT_FOOZLE_WELL, ZGIRegions.OUTSIDE_PORT_FOOZLE_SIGNPOST),
    (ZGIRegions.PORT_FOOZLE, ZGIRegions.OUTSIDE_PORT_FOOZLE_SIGNPOST),
    (ZGIRegions.PORT_FOOZLE, ZGIRegions.PORT_FOOZLE_JACKS_SHOP),
    (ZGIRegions.PORT_FOOZLE_JACKS_SHOP, ZGIRegions.PORT_FOOZLE),
    (ZGIRegions.SPELL_LAB, ZGIRegions.SPELL_LAB_BRIDGE),
    (ZGIRegions.SPELL_LAB_BRIDGE, ZGIRegions.GUE_TECH_HALLWAY),
    (ZGIRegions.SPELL_LAB_BRIDGE, ZGIRegions.SPELL_LAB),
    (ZGIRegions.SUBWAY_CROSSROADS, ZGIRegions.CROSSROADS),
    (ZGIRegions.SUBWAY_HADES, ZGIRegions.HADES_SHORE),
    (ZGIRegions.SUBWAY_MONASTERY, ZGIRegions.MONASTERY),
    (ZGIRegions.WALKING_CASTLE, ZGIRegions.DM_LAIR_INTERIOR),
)

randomizable_entrances_subway: Tuple[Tuple[ZGIRegions, ZGIRegions]] = (
    (ZGIRegions.SUBWAY_CROSSROADS, ZGIRegions.SUBWAY_FLOOD_CONTROL_DAM),
    (ZGIRegions.SUBWAY_CROSSROADS, ZGIRegions.SUBWAY_HADES),
    (ZGIRegions.SUBWAY_CROSSROADS, ZGIRegions.SUBWAY_MONASTERY),
    (ZGIRegions.SUBWAY_FLOOD_CONTROL_DAM, ZGIRegions.SUBWAY_CROSSROADS),
    (ZGIRegions.SUBWAY_FLOOD_CONTROL_DAM, ZGIRegions.SUBWAY_HADES),
    (ZGIRegions.SUBWAY_FLOOD_CONTROL_DAM, ZGIRegions.SUBWAY_MONASTERY),
    (ZGIRegions.SUBWAY_HADES, ZGIRegions.SUBWAY_CROSSROADS),
    (ZGIRegions.SUBWAY_HADES, ZGIRegions.SUBWAY_FLOOD_CONTROL_DAM),
    (ZGIRegions.SUBWAY_HADES, ZGIRegions.SUBWAY_MONASTERY),
    (ZGIRegions.SUBWAY_MONASTERY, ZGIRegions.SUBWAY_CROSSROADS),
    (ZGIRegions.SUBWAY_MONASTERY, ZGIRegions.SUBWAY_FLOOD_CONTROL_DAM),
    (ZGIRegions.SUBWAY_MONASTERY, ZGIRegions.SUBWAY_HADES),
)

relevant_game_locations: Set[str] = {"cd20", "qs1e", "sg60"}

entrance_pairs: Tuple[Tuple[str, str]]
for entrance_pairs in entrances_to_game_locations.values():
    entrance_from: str
    entrance_to: str
    for entrance_from, entrance_to in entrance_pairs:
        relevant_game_locations.add(entrance_from)
        relevant_game_locations.add(entrance_to)
