from typing import Dict, NamedTuple, Callable, Optional, Set

from BaseClasses import Location


class HereComesNikoLocation(Location):
    game = "Here Comes Niko!"


class HereComesNikoLocationData(NamedTuple):
    region: str
    id: Optional[int] = None
    can_create: Callable = lambda options: True
    locked_item: Optional[str] = None
    location_group: Optional[str] = None

base_id = 598_145_444_000

location_data_table: Dict[str, HereComesNikoLocationData] = {
    # Coins
    "Home - Give High Frog Lunchbox": HereComesNikoLocationData(region="Home",id=base_id + 0),
    # ~ Hairball City
    "Hairball City - BIG VOLLEY": HereComesNikoLocationData(region="Hairball City", id=base_id + 3, location_group="Volley"),
    "Hairball City - Dustan on Lighthouse": HereComesNikoLocationData(region="Hairball City",id=base_id + 4, location_group="Dustan"),
    "Hairball City - Little Gabi's Flowers": HereComesNikoLocationData(region="Hairball City",id=base_id + 5, location_group="Little Gabi"),
    "Hairball City - Gunter on Skyscraper": HereComesNikoLocationData(region="Hairball City",id=base_id + 6),
    "Hairball City - Fish with Fischer": HereComesNikoLocationData(region="Hairball City",id=base_id + 7, location_group="Fischer"),
    "Hairball City - Blessley": HereComesNikoLocationData(region="Hairball City",id=base_id + 8, location_group="Blessley"),
    "Hairball City - Nina": HereComesNikoLocationData(region="Hairball City",id=base_id + 9),
    "Hairball City - Moomy": HereComesNikoLocationData(region="Hairball City",id=base_id + 10),
    "Hairball City - Mitch": HereComesNikoLocationData(region="Hairball City",id=base_id + 11, can_create=lambda options: options.cassette_logic.value!=1, location_group="Mitch & Mai"),
    "Hairball City - Mai": HereComesNikoLocationData(region="Hairball City",id=base_id + 12, can_create=lambda options: options.cassette_logic.value!=1, location_group="Mitch & Mai"),
    "Hairball City - Game Kid": HereComesNikoLocationData(region="Hairball City",id=base_id + 13),
    "Hairball City - Blippy Dog": HereComesNikoLocationData(region="Hairball City",id=base_id + 14, location_group="Blippy"),
    "Hairball City - Blippy": HereComesNikoLocationData(region="Hairball City",id=base_id + 15, location_group="Blippy"),
    "Hairball City - Serschel & Louist": HereComesNikoLocationData(region="Hairball City",id=base_id + 16, location_group="Serschel & Louist"),
    # ~ Turbine Town
    "Turbine Town - Fish with Fischer": HereComesNikoLocationData(region="Turbine Town",id=base_id + 17, location_group="Fischer"),
    "Turbine Town - AIR VOLLEY": HereComesNikoLocationData(region="Turbine Town",id=base_id + 18, location_group="Volley"),
    "Turbine Town - Little Gabi's Flowers": HereComesNikoLocationData(region="Turbine Town",id=base_id + 19, location_group="Little Gabi"),
    "Turbine Town - Pelly the Engineer": HereComesNikoLocationData(region="Turbine Town",id=base_id + 20),
    "Turbine Town - Blessley": HereComesNikoLocationData(region="Turbine Town",id=base_id + 21, location_group="Blessley"),
    "Turbine Town - Dustan on Wind Turbine": HereComesNikoLocationData(region="Turbine Town",id=base_id + 22, location_group="Dustan"),
    "Turbine Town - Mitch": HereComesNikoLocationData(region="Turbine Town",id=base_id + 23, can_create=lambda options: options.cassette_logic.value!=1, location_group="Mitch & Mai"),
    "Turbine Town - Mai": HereComesNikoLocationData(region="Turbine Town",id=base_id + 24, can_create=lambda options: options.cassette_logic.value!=1, location_group="Mitch & Mai"),
    "Turbine Town - Blippy Dog": HereComesNikoLocationData(region="Turbine Town",id=base_id + 25, location_group="Blippy"),
    "Turbine Town - Blippy": HereComesNikoLocationData(region="Turbine Town",id=base_id + 26, location_group="Blippy"),
    "Turbine Town - Serschel & Louist": HereComesNikoLocationData(region="Turbine Town",id=base_id + 27, location_group="Serschel & Louist"),
    # ~ Salmon Creek Forest
    "Salmon Creek Forest - Stijn & Melissa": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 28),
    "Salmon Creek Forest - Mitch": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 29, can_create=lambda options: options.cassette_logic.value!=1, location_group="Mitch & Mai"),
    "Salmon Creek Forest - Dustan on Mountain": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 30, location_group="Dustan"),
    "Salmon Creek Forest - Moomy": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 31),
    "Salmon Creek Forest - Blippy Dog": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 32, location_group="Blippy"),
    "Salmon Creek Forest - Treeman": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 33),
    "Salmon Creek Forest - Blessley": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 34, location_group="Blessley"),
    "Salmon Creek Forest - Secret of the Forest (Waterfall Cave)": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 35),
    "Salmon Creek Forest - SPORTVIVAL": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 36, location_group="Volley"),
    "Salmon Creek Forest - Little Gabi's Flowers": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 37, location_group="Little Gabi"),
    "Salmon Creek Forest - Nina": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 38),
    "Salmon Creek Forest - Mai": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 39, can_create=lambda options: options.cassette_logic.value!=1, location_group="Mitch & Mai"),
    "Salmon Creek Forest - Fish with Fischer": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 40, location_group="Fischer"),
    "Salmon Creek Forest - Game Kid": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 41),
    "Salmon Creek Forest - Blippy": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 42, location_group="Blippy"),
    "Salmon Creek Forest - Serschel & Louist": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 43, location_group="Serschel & Louist"),
    # ~ Public Pool
    "Public Pool - Far Away Island": HereComesNikoLocationData(region="Public Pool",id=base_id + 44),
    "Public Pool - Mai": HereComesNikoLocationData(region="Public Pool",id=base_id + 45, can_create=lambda options: options.cassette_logic.value!=1, location_group="Mitch & Mai"),
    "Public Pool - Blippy Dog": HereComesNikoLocationData(region="Public Pool",id=base_id + 46, location_group="Blippy"),
    "Public Pool - Blippy": HereComesNikoLocationData(region="Public Pool",id=base_id + 47, location_group="Blippy"),
    "Public Pool - Fish with Fischer": HereComesNikoLocationData(region="Public Pool",id=base_id + 48),
    "Public Pool - Frogtective": HereComesNikoLocationData(region="Public Pool",id=base_id + 49),
    "Public Pool - SPORTVIVAL VOLLEY": HereComesNikoLocationData(region="Public Pool",id=base_id + 50, location_group="Volley"),
    "Public Pool - Blessley": HereComesNikoLocationData(region="Public Pool",id=base_id + 51, location_group="Blessley"),
    "Public Pool - Mitch": HereComesNikoLocationData(region="Public Pool",id=base_id + 52, can_create=lambda options: options.cassette_logic.value!=1, location_group="Mitch & Mai"),
    "Public Pool - Little Gabi's Flowers": HereComesNikoLocationData(region="Public Pool",id=base_id + 53, location_group="Little Gabi"),
    # ~ Bathhouse
    "Bathhouse - Serschel & Louist": HereComesNikoLocationData(region="Bathhouse",id=base_id + 54, location_group="Serschel & Louist"),
    "Bathhouse - Moomy": HereComesNikoLocationData(region="Bathhouse",id=base_id + 55),
    "Bathhouse - Poppy": HereComesNikoLocationData(region="Bathhouse",id=base_id + 56),
    "Bathhouse - Nina": HereComesNikoLocationData(region="Bathhouse",id=base_id + 57),
    "Bathhouse - Mitch": HereComesNikoLocationData(region="Bathhouse",id=base_id + 58, can_create=lambda options: options.cassette_logic.value!=1, location_group="Mitch & Mai"),
    "Bathhouse - Mai": HereComesNikoLocationData(region="Bathhouse",id=base_id + 59, can_create=lambda options: options.cassette_logic.value!=1, location_group="Mitch & Mai"),
    "Bathhouse - Dustan on Bathhouse": HereComesNikoLocationData(region="Bathhouse",id=base_id + 60, location_group="Dustan"),
    "Bathhouse - LONG VOLLEY": HereComesNikoLocationData(region="Bathhouse",id=base_id + 61, location_group="Volley"),
    "Bathhouse - Game Kid": HereComesNikoLocationData(region="Bathhouse",id=base_id + 62),
    "Bathhouse - Fish with Fischer": HereComesNikoLocationData(region="Bathhouse",id=base_id + 63, location_group="Fischer"),
    "Bathhouse - Blessley": HereComesNikoLocationData(region="Bathhouse",id=base_id + 64, location_group="Blessley"),
    "Bathhouse - Little Gabi's Flowers": HereComesNikoLocationData(region="Bathhouse",id=base_id + 65, location_group="Little Gabi"),
    "Bathhouse - Blippy Dog": HereComesNikoLocationData(region="Bathhouse",id=base_id + 66, location_group="Blippy"),
    "Bathhouse - Blippy": HereComesNikoLocationData(region="Bathhouse",id=base_id + 67, location_group="Blippy"),
    # ~ Tadpole HQ
    "Tadpole HQ - Mai": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 68, can_create=lambda options: options.cassette_logic.value!=1, location_group="Mitch & Mai"),
    "Tadpole HQ - Mitch": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 69, can_create=lambda options: options.cassette_logic.value!=1, location_group="Mitch & Mai"),
    "Tadpole HQ - Frog King": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 70),
    "Tadpole HQ - HUGE VOLLEY": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 71, location_group="Volley"),
    "Tadpole HQ - Fish with Fischer": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 72, location_group="Fischer"),
    "Tadpole HQ - Little Gabi's Flowers": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 73, location_group="Little Gabi"),
    "Tadpole HQ - Blippy": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 74, location_group="Blippy"),
    "Tadpole HQ - Blessley": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 75, location_group="Blessley"),
    "Tadpole HQ - Serschel & Louist": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 76, location_group="Serschel & Louist"),
    "Tadpole HQ - Blippy Dog": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 77, location_group="Blippy"),

    # Letters
    "Home - Next To Crane": HereComesNikoLocationData(region="Home",id=base_id + 80, location_group="Letter"),
    "Hairball City - Above Tree Near Gabi": HereComesNikoLocationData(region="Hairball City",id=base_id + 81, location_group="Letter"),
    "Hairball City - Behind The Train": HereComesNikoLocationData(region="Hairball City",id=base_id + 82, location_group="Letter"),
    "Turbine Town - Behind Wind Dragon": HereComesNikoLocationData(region="Turbine Town",id=base_id + 83, location_group="Letter"),
    "Turbine Town - Above Partially Sunken Shipping Container": HereComesNikoLocationData(region="Turbine Town",id=base_id + 84, location_group="Letter"),
    "Salmon Creek Forest - Inside Locked Cave": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 85, location_group="Letter"),
    "Salmon Creek Forest - Inside Secret of the Forest (Waterfall Cave)": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 86, location_group="Letter"),
    "Public Pool - Far Away Island Left Side": HereComesNikoLocationData(region="Public Pool",id=base_id + 87, location_group="Letter"),
    "Public Pool - Far Away Island Right Side": HereComesNikoLocationData(region="Public Pool",id=base_id + 88, location_group="Letter"),
    "Bathhouse - Behind Axolotl Family": HereComesNikoLocationData(region="Bathhouse",id=base_id + 89, location_group="Letter"),
    "Bathhouse - Near Game Kid": HereComesNikoLocationData(region="Bathhouse",id=base_id + 90, location_group="Letter"),
    "Tadpole HQ - Ledge Above Elevator": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 250, location_group="Letter"),

    # Keys
    "Turbine Town - Shipping Container With Breakable Boxes": HereComesNikoLocationData(region="Turbine Town",id=base_id + 91),
    "Turbine Town - Stone Pillar Behind Wind Turbine": HereComesNikoLocationData(region="Turbine Town",id=base_id + 92),
    "Salmon Creek Forest - Large Rock In Ocean": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 93),
    "Salmon Creek Forest - Beneath Pond": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 94),
    "Salmon Creek Forest - Behind Frog Statue": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 95),
    "Public Pool - Above Small Island": HereComesNikoLocationData(region="Public Pool",id=base_id + 96),
    "Bathhouse - On Top Of A Torii": HereComesNikoLocationData(region="Bathhouse",id=base_id + 97),
    "Bathhouse - Breakable Box Inside Bathhouse Box": HereComesNikoLocationData(region="Bathhouse",id=base_id + 98),
    "Bathhouse - Beneath Moomy": HereComesNikoLocationData(region="Bathhouse",id=base_id + 99),

    # Cassettes
    "Hairball City - Behind Pepper": HereComesNikoLocationData(region="Hairball City",id=base_id+100),
    "Hairball City - Frog Statue Crown": HereComesNikoLocationData(region="Hairball City",id=base_id + 101),
    "Hairball City - Big Umbrella": HereComesNikoLocationData(region="Hairball City",id=base_id + 102),
    "Hairball City - Lighthouse Front Door": HereComesNikoLocationData(region="Hairball City",id=base_id + 103),
    "Hairball City - Palm Tree": HereComesNikoLocationData(region="Hairball City",id=base_id + 104),
    "Hairball City - Inside Tunnel": HereComesNikoLocationData(region="Hairball City",id=base_id + 105),
    "Hairball City - Breakable Boxes Near Frog Of Destruction": HereComesNikoLocationData(region="Hairball City",id=base_id + 106),
    "Hairball City - Behind Lighthouse": HereComesNikoLocationData(region="Hairball City",id=base_id + 107),
    "Hairball City - Next to Breakable Boxes Under Ramp": HereComesNikoLocationData(region="Hairball City",id=base_id + 108),
    "Hairball City - Above Frog Statue": HereComesNikoLocationData(region="Hairball City",id=base_id + 109),
    #  ~ Turbine Town
    "Turbine Town - Inside Partially Sunken Shipping Container": HereComesNikoLocationData(region="Turbine Town",id=base_id + 111),
    "Turbine Town - Cube Rocks Behind Gabi's Garden": HereComesNikoLocationData(region="Turbine Town",id=base_id + 112),
    "Turbine Town - Above Handsome Frog Container": HereComesNikoLocationData(region="Turbine Town",id=base_id + 113),
    "Turbine Town - Behind Blessley": HereComesNikoLocationData(region="Turbine Town",id=base_id + 114),
    "Turbine Town - Inside Container With Buttons": HereComesNikoLocationData(region="Turbine Town",id=base_id + 115),
    "Turbine Town - Inside Container Behind Pepper": HereComesNikoLocationData(region="Turbine Town",id=base_id + 116),
    "Turbine Town - In Front Of Wind Turbine": HereComesNikoLocationData(region="Turbine Town",id=base_id + 117),
    "Turbine Town - Next To Torii Gates": HereComesNikoLocationData(region="Turbine Town",id=base_id + 118),
    "Turbine Town - Near Fishing Containers": HereComesNikoLocationData(region="Turbine Town",id=base_id + 119),
    "Turbine Town - Near AIR VOLLEY On Zip Line": HereComesNikoLocationData(region="Turbine Town",id=base_id + 120),
    #  ~ Salmon Creek Forest
    "Salmon Creek Forest - Behind Train": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 122),
    "Salmon Creek Forest - Wooden Bridge": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 123),
    "Salmon Creek Forest - Treehouse": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 124),
    "Salmon Creek Forest - Rocks Behind Mountain": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 125),
    "Salmon Creek Forest - Near Breakable Boxes (Waterfall Cave)": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 126),
    "Salmon Creek Forest - Inside Boxes (Waterfall Cave)": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 127),
    "Salmon Creek Forest - Next To Treehouse": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 128),
    "Salmon Creek Forest - Next To Flowers Near Stijn": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 129),
    "Salmon Creek Forest - Behind Mountain": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 130),
    "Salmon Creek Forest - Fallen Tree": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 131),
    "Salmon Creek Forest - Behind A Tent Near Moomy": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 132),
    #  ~ Public Pool
    "Public Pool - Frog Statue": HereComesNikoLocationData(region="Public Pool",id=base_id + 134),
    "Public Pool - On Springboard": HereComesNikoLocationData(region="Public Pool",id=base_id + 135),
    "Public Pool - Behind Palm Tree On Small Island": HereComesNikoLocationData(region="Public Pool",id=base_id + 136),
    "Public Pool - Above Floaties Behind Palm Tree": HereComesNikoLocationData(region="Public Pool",id=base_id + 137),
    "Public Pool - Inside Pool": HereComesNikoLocationData(region="Public Pool",id=base_id + 138),
    "Public Pool - Inside BIG Pool": HereComesNikoLocationData(region="Public Pool",id=base_id + 139),
    "Public Pool - Behind Frog Statue": HereComesNikoLocationData(region="Public Pool",id=base_id + 140),
    "Public Pool - On A Palm Tree": HereComesNikoLocationData(region="Public Pool",id=base_id + 141),
    "Public Pool - Breakable Boxes Near Frogtective": HereComesNikoLocationData(region="Public Pool",id=base_id + 142),
    "Public Pool - Above BIG Pool": HereComesNikoLocationData(region="Public Pool",id=base_id + 143),
    #  ~ Bathhouse
    "Bathhouse - Behind Frog Statue": HereComesNikoLocationData(region="Bathhouse",id=base_id + 145),
    "Bathhouse - In Water Next To Elizabeth IV": HereComesNikoLocationData(region="Bathhouse",id=base_id + 146),
    "Bathhouse - Hut in Water": HereComesNikoLocationData(region="Bathhouse",id=base_id + 147),
    "Bathhouse - Giant Frog Statue Crown": HereComesNikoLocationData(region="Bathhouse",id=base_id + 148),
    "Bathhouse - Lamp near Moomy": HereComesNikoLocationData(region="Bathhouse",id=base_id + 149),
    "Bathhouse - Behind LONG VOLLEY": HereComesNikoLocationData(region="Bathhouse",id=base_id + 150),
    "Bathhouse - Behind Waterfall": HereComesNikoLocationData(region="Bathhouse",id=base_id + 151),
    "Bathhouse - Fan to Fan": HereComesNikoLocationData(region="Bathhouse",id=base_id + 152),
    "Bathhouse - Pipe Under Wooden Bridge": HereComesNikoLocationData(region="Bathhouse",id=base_id + 153),
    "Bathhouse - Mahjong Hideout": HereComesNikoLocationData(region="Bathhouse",id=base_id + 154),
    # ~ Tadpole HQ
    "Tadpole HQ - Inbetween Four Skyscrapers": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 156),
    "Tadpole HQ - Next To Four Skyscrapers": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 157),
    "Tadpole HQ - Behind Bench In Bushes": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 158),
    "Tadpole HQ - Cannon Next To Elevator": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 159),
    "Tadpole HQ - Big Tree Next To Louist": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 160),
    "Tadpole HQ - Golden Frog Statue Crown": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 161),
    "Tadpole HQ - Breakable Boxes near Blessley": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 162),
    "Tadpole HQ - Behind Fischer On A Rock": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 163),
    "Tadpole HQ - Under Giant Umbrella": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 164),
    "Tadpole HQ - Wall Jump Near Breakable Boxes": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 165),

    # Misc
    "Tadpole HQ - Dojo Guy": HereComesNikoLocationData(region="Tadpole HQ", id=base_id + 166),
    "Salmon Creek Forest - Contact List": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 167),
    "Tadpole HQ - Contact List": HereComesNikoLocationData(region="Tadpole HQ", id=base_id + 168),

    # Kiosk
    "Home - Kiosk": HereComesNikoLocationData(region="Home", id=base_id + 170, location_group="Kiosk"),
    "Hairball City - Kiosk": HereComesNikoLocationData(region="Hairball City", id=base_id + 171, location_group="Kiosk"),
    "Turbine Town - Kiosk": HereComesNikoLocationData(region="Turbine Town", id=base_id + 172, location_group="Kiosk"),
    "Salmon Creek Forest - Kiosk": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 173, location_group="Kiosk"),
    "Public Pool - Kiosk": HereComesNikoLocationData(region="Public Pool", id=base_id + 174, location_group="Kiosk"),
    "Bathhouse - Kiosk": HereComesNikoLocationData(region="Bathhouse", id=base_id + 175, location_group="Kiosk"),

    # Achievements
    "Achievement - Frog Fan": HereComesNikoLocationData(region="Tadpole HQ", id=base_id + 176, can_create=lambda options: options.enable_achievements.value != 2),
    "Achievement - Employee Of The Month!": HereComesNikoLocationData(region="Home", id=base_id + 177, can_create=lambda options: options.enable_achievements.value != 2 and options.goal_completion.value != 1),
    "Achievement - Bottled Up": HereComesNikoLocationData(region="Bathhouse", id=base_id + 178, can_create=lambda options: options.enable_achievements.value != 2),
    "Achievement - Snail Fashion Show": HereComesNikoLocationData(region="Tadpole HQ", id=base_id + 179, can_create=lambda options: options.enable_achievements.value == 0),
    "Achievement - Volley Dreams": HereComesNikoLocationData(region="Tadpole HQ", id=base_id + 180, can_create=lambda options: options.enable_achievements.value != 2),
    "Achievement - Hopeless Romantic": HereComesNikoLocationData(region="Tadpole HQ", id=base_id + 181, can_create=lambda options: options.enable_achievements.value != 2),
    "Achievement - Lost at Sea": HereComesNikoLocationData(region="Home", id=base_id + 182, can_create=lambda options: options.enable_achievements.value != 2),

    # DLC Garden
    "Gary's Garden - Tree Branch Near The Top": HereComesNikoLocationData(region="Gary's Garden",id=base_id + 183, can_create=lambda options: options.shuffle_garys_garden.value),
    "Gary's Garden - On Tree Branch": HereComesNikoLocationData(region="Gary's Garden",id=base_id + 184, can_create=lambda options: options.shuffle_garys_garden.value),
    "Gary's Garden - Tree Branch Near Gold Scissor Row": HereComesNikoLocationData(region="Gary's Garden",id=base_id + 185, can_create=lambda options: options.shuffle_garys_garden.value),
    "Gary's Garden - Next Garden Seed On Rocks": HereComesNikoLocationData(region="Gary's Garden",id=base_id + 186, can_create=lambda options: options.shuffle_garys_garden.value),
    "Gary's Garden - Next To Smaller Tree": HereComesNikoLocationData(region="Gary's Garden",id=base_id + 187, can_create=lambda options: options.shuffle_garys_garden.value),
    "Gary's Garden - Near End Of Giant Gold Scissor": HereComesNikoLocationData(region="Gary's Garden",id=base_id + 188, can_create=lambda options: options.shuffle_garys_garden.value),
    "Gary's Garden - Beginning Of Giant Gold Scissor": HereComesNikoLocationData(region="Gary's Garden",id=base_id + 189, can_create=lambda options: options.shuffle_garys_garden.value),
    "Gary's Garden - Behind Large Rock": HereComesNikoLocationData(region="Gary's Garden",id=base_id + 190, can_create=lambda options: options.shuffle_garys_garden.value),
    "Gary's Garden - Small Rocks In Water": HereComesNikoLocationData(region="Gary's Garden",id=base_id + 191, can_create=lambda options: options.shuffle_garys_garden.value),
    "Gary's Garden - Next To Train": HereComesNikoLocationData(region="Gary's Garden",id=base_id + 192, can_create=lambda options: options.shuffle_garys_garden.value),
    "Gary's Garden - Gunter & Little Gabi": HereComesNikoLocationData(region="Gary's Garden", id=base_id + 198, can_create=lambda options: options.shuffle_garys_garden.value),
    "Gary's Garden - Mai": HereComesNikoLocationData(region="Gary's Garden", id=base_id + 199, can_create=lambda options: options.shuffle_garys_garden.value and options.cassette_logic.value!=1, location_group="Mitch & Mai"),
    "Gary's Garden - Mitch": HereComesNikoLocationData(region="Gary's Garden", id=base_id + 200, can_create=lambda options: options.shuffle_garys_garden.value and options.cassette_logic.value!=1, location_group="Mitch & Mai"),
    "Gary's Garden - Handsome Frog": HereComesNikoLocationData(region="Gary's Garden", id=base_id + 201, can_create=lambda options: options.shuffle_garys_garden.value and options.shuffle_handsome_frog.value, location_group="Handsome Frog"),

    # Handsome Frog
    "Hairball City - Handsome Frog": HereComesNikoLocationData(region="Hairball City",id=base_id + 193, can_create=lambda options: options.shuffle_handsome_frog.value, location_group="Handsome Frog"),
    "Turbine Town - Handsome Frog": HereComesNikoLocationData(region="Turbine Town",id=base_id + 194, can_create=lambda options: options.shuffle_handsome_frog.value, location_group="Handsome Frog"),
    "Salmon Creek Forest - Handsome Frog": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 195, can_create=lambda options: options.shuffle_handsome_frog.value, location_group="Handsome Frog"),
    "Public Pool - Handsome Frog": HereComesNikoLocationData(region="Public Pool",id=base_id + 196, can_create=lambda options: options.shuffle_handsome_frog.value, location_group="Handsome Frog"),
    "Bathhouse - Handsome Frog": HereComesNikoLocationData(region="Bathhouse",id=base_id + 197, can_create=lambda options: options.shuffle_handsome_frog.value, location_group="Handsome Frog"),

    #Dustan
    "Dustan - Meeting First Time": HereComesNikoLocationData(region="Home", id=base_id + 202, location_group="Dustan"),

    #Fishsanity
    "Hairball City - Moorish Idol": HereComesNikoLocationData(region="Hairball City", id=base_id + 203, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Hairball City - Not Nemo": HereComesNikoLocationData(region="Hairball City", id=base_id + 204, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Hairball City - Eel": HereComesNikoLocationData(region="Hairball City", id=base_id + 205, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Hairball City - Flying Fish": HereComesNikoLocationData(region="Hairball City", id=base_id + 206, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Hairball City - Orange Fish": HereComesNikoLocationData(region="Hairball City", id=base_id + 207, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Turbine Town - Albino Corydoras": HereComesNikoLocationData(region="Turbine Town", id=base_id + 208, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Turbine Town - Axolotl": HereComesNikoLocationData(region="Turbine Town", id=base_id + 209, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Turbine Town - Prianha": HereComesNikoLocationData(region="Turbine Town", id=base_id + 210, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Turbine Town - Mantaray": HereComesNikoLocationData(region="Turbine Town", id=base_id + 211, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Turbine Town - Sand Shrimp": HereComesNikoLocationData(region="Turbine Town", id=base_id + 212, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Salmon Creek Forest - Bass": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 213, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Salmon Creek Forest - Catfish": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 214, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Salmon Creek Forest - Pike": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 215, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Salmon Creek Forest - Salmon": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 216, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Salmon Creek Forest - Trout": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 217, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Public Pool - Baby Crocodile": HereComesNikoLocationData(region="Public Pool", id=base_id + 218, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Public Pool - Gramma Loreto": HereComesNikoLocationData(region="Public Pool", id=base_id + 219, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Public Pool - Shark": HereComesNikoLocationData(region="Public Pool", id=base_id + 220, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Public Pool - Squid": HereComesNikoLocationData(region="Public Pool", id=base_id + 221, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Public Pool - Turtle": HereComesNikoLocationData(region="Public Pool", id=base_id + 222, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Bathhouse - Anglerfish": HereComesNikoLocationData(region="Bathhouse", id=base_id + 223, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Bathhouse - Clione": HereComesNikoLocationData(region="Bathhouse", id=base_id + 224, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Bathhouse - Little Wiggly Guy": HereComesNikoLocationData(region="Bathhouse", id=base_id + 225, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Bathhouse - Jellyfish": HereComesNikoLocationData(region="Bathhouse", id=base_id + 226, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Bathhouse - Pufferfish": HereComesNikoLocationData(region="Bathhouse", id=base_id + 227, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Tadpole HQ - Blue Fairy Shrimp": HereComesNikoLocationData(region="Tadpole HQ", id=base_id + 228, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Tadpole HQ - Bluestreak Cleaner Wrasse": HereComesNikoLocationData(region="Tadpole HQ", id=base_id + 229, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Tadpole HQ - Honey Gourami": HereComesNikoLocationData(region="Tadpole HQ", id=base_id + 230, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Tadpole HQ - Loach": HereComesNikoLocationData(region="Tadpole HQ", id=base_id + 231, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),
    "Tadpole HQ - Neon Tetra": HereComesNikoLocationData(region="Tadpole HQ", id=base_id + 232, can_create=lambda options: options.fishsanity.value, location_group="Fischer"),

    # Snail Shop
    "Snail Shop - Bowtie": HereComesNikoLocationData(region="Home",id=base_id + 233, can_create=lambda options: options.snail_shop.value),
    "Snail Shop - Motorcycle": HereComesNikoLocationData(region="Home",id=base_id + 234, can_create=lambda options: options.snail_shop.value),
    "Snail Shop - Sunglasses": HereComesNikoLocationData(region="Home",id=base_id + 235, can_create=lambda options: options.snail_shop.value),
    "Snail Shop - Mahjong": HereComesNikoLocationData(region="Home",id=base_id + 236, can_create=lambda options: options.snail_shop.value),
    "Snail Shop - Cap": HereComesNikoLocationData(region="Home",id=base_id + 237, can_create=lambda options: options.snail_shop.value),
    "Snail Shop - King Staff": HereComesNikoLocationData(region="Home",id=base_id + 238, can_create=lambda options: options.snail_shop.value),
    "Snail Shop - Mouse": HereComesNikoLocationData(region="Home",id=base_id + 239, can_create=lambda options: options.snail_shop.value),
    "Snail Shop - Clown Face": HereComesNikoLocationData(region="Home",id=base_id + 240, can_create=lambda options: options.snail_shop.value),
    "Snail Shop - Cat": HereComesNikoLocationData(region="Home",id=base_id + 241, can_create=lambda options: options.snail_shop.value),
    "Snail Shop - Bandanna": HereComesNikoLocationData(region="Home",id=base_id + 242, can_create=lambda options: options.snail_shop.value),
    "Snail Shop - Stars": HereComesNikoLocationData(region="Home",id=base_id + 243, can_create=lambda options: options.snail_shop.value),
    "Snail Shop - Sword": HereComesNikoLocationData(region="Home",id=base_id + 244, can_create=lambda options: options.snail_shop.value),
    "Snail Shop - Top hat": HereComesNikoLocationData(region="Home",id=base_id + 245, can_create=lambda options: options.snail_shop.value),
    "Snail Shop - Glasses": HereComesNikoLocationData(region="Home",id=base_id + 246, can_create=lambda options: options.snail_shop.value),
    "Snail Shop - Flower": HereComesNikoLocationData(region="Home",id=base_id + 247, can_create=lambda options: options.snail_shop.value),
    "Snail Shop - Small Hat": HereComesNikoLocationData(region="Home",id=base_id + 248, can_create=lambda options: options.snail_shop.value),

    #Seedsanity
    "Hairball City - Seed 1": HereComesNikoLocationData(region="Hairball City", id=base_id + 260, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Hairball City - Seed 2": HereComesNikoLocationData(region="Hairball City", id=base_id + 261, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Hairball City - Seed 3": HereComesNikoLocationData(region="Hairball City", id=base_id + 262, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Hairball City - Seed 4": HereComesNikoLocationData(region="Hairball City", id=base_id + 263, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Hairball City - Seed 5": HereComesNikoLocationData(region="Hairball City", id=base_id + 264, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Hairball City - Seed 6": HereComesNikoLocationData(region="Hairball City", id=base_id + 265, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Hairball City - Seed 7": HereComesNikoLocationData(region="Hairball City", id=base_id + 266, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Hairball City - Seed 8": HereComesNikoLocationData(region="Hairball City", id=base_id + 267, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Hairball City - Seed 9": HereComesNikoLocationData(region="Hairball City", id=base_id + 268, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Hairball City - Seed 10": HereComesNikoLocationData(region="Hairball City", id=base_id + 269, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Salmon Creek Forest - Seed 1": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 270, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Salmon Creek Forest - Seed 2": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 271, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Salmon Creek Forest - Seed 3": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 272, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Salmon Creek Forest - Seed 4": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 273, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Salmon Creek Forest - Seed 5": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 274, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Salmon Creek Forest - Seed 6": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 275, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Salmon Creek Forest - Seed 7": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 276, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Salmon Creek Forest - Seed 8": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 277, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Salmon Creek Forest - Seed 9": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 278, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Salmon Creek Forest - Seed 10": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 279, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Bathhouse - Seed 1": HereComesNikoLocationData(region="Bathhouse", id=base_id + 280, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Bathhouse - Seed 2": HereComesNikoLocationData(region="Bathhouse", id=base_id + 281, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Bathhouse - Seed 3": HereComesNikoLocationData(region="Bathhouse", id=base_id + 282, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Bathhouse - Seed 4": HereComesNikoLocationData(region="Bathhouse", id=base_id + 283, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Bathhouse - Seed 5": HereComesNikoLocationData(region="Bathhouse", id=base_id + 284, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Bathhouse - Seed 6": HereComesNikoLocationData(region="Bathhouse", id=base_id + 285, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Bathhouse - Seed 7": HereComesNikoLocationData(region="Bathhouse", id=base_id + 286, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Bathhouse - Seed 8": HereComesNikoLocationData(region="Bathhouse", id=base_id + 287, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Bathhouse - Seed 9": HereComesNikoLocationData(region="Bathhouse", id=base_id + 288, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),
    "Bathhouse - Seed 10": HereComesNikoLocationData(region="Bathhouse", id=base_id + 289, can_create=lambda options: options.seedsanity.value, location_group="Moomy"),

    #Flowersanity
    "Hairball City - Flowerbed 1": HereComesNikoLocationData(region="Hairball City", id=base_id + 300, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Hairball City - Flowerbed 2": HereComesNikoLocationData(region="Hairball City", id=base_id + 301, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Hairball City - Flowerbed 3": HereComesNikoLocationData(region="Hairball City", id=base_id + 302, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Turbine Town - Flowerbed 1": HereComesNikoLocationData(region="Turbine Town", id=base_id + 303, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Turbine Town - Flowerbed 2": HereComesNikoLocationData(region="Turbine Town", id=base_id + 304, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Turbine Town - Flowerbed 3": HereComesNikoLocationData(region="Turbine Town", id=base_id + 305, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Salmon Creek Forest - Flowerbed 1": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 306, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Salmon Creek Forest - Flowerbed 2": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 307, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Salmon Creek Forest - Flowerbed 3": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 308, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Salmon Creek Forest - Flowerbed 4": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 309, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Salmon Creek Forest - Flowerbed 5": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 310, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Salmon Creek Forest - Flowerbed 6": HereComesNikoLocationData(region="Salmon Creek Forest", id=base_id + 311, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Public Pool - Flowerbed 1": HereComesNikoLocationData(region="Public Pool", id=base_id + 312, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Public Pool - Flowerbed 2": HereComesNikoLocationData(region="Public Pool", id=base_id + 313, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Public Pool - Flowerbed 3": HereComesNikoLocationData(region="Public Pool", id=base_id + 314, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Bathhouse - Flowerbed 1": HereComesNikoLocationData(region="Bathhouse", id=base_id + 315, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Bathhouse - Flowerbed 2": HereComesNikoLocationData(region="Bathhouse", id=base_id + 316, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Bathhouse - Flowerbed 3": HereComesNikoLocationData(region="Bathhouse", id=base_id + 317, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Tadpole HQ - Flowerbed 1": HereComesNikoLocationData(region="Tadpole HQ", id=base_id + 318, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Tadpole HQ - Flowerbed 2": HereComesNikoLocationData(region="Tadpole HQ", id=base_id + 319, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Tadpole HQ - Flowerbed 3": HereComesNikoLocationData(region="Tadpole HQ", id=base_id + 320, can_create=lambda options: options.flowersanity.value, location_group="Flower"),
    "Tadpole HQ - Flowerbed 4": HereComesNikoLocationData(region="Tadpole HQ", id=base_id + 321, can_create=lambda options: options.flowersanity.value, location_group="Flower"),

    #Applesanity
    "Hairball City - First Apple Group Between Flowerbed Buildings 1": HereComesNikoLocationData(region="ApplesHC", id=base_id + 322, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Apple Behind Nina 2": HereComesNikoLocationData(region="ApplesHC", id=base_id + 323, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Apple On Pier Above Handsome Frog 6": HereComesNikoLocationData(region="ApplesHC", id=base_id + 324, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Apple On Pier Above Handsome Frog 7": HereComesNikoLocationData(region="ApplesHC", id=base_id + 325, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Apple On Pier Above Handsome Frog 2": HereComesNikoLocationData(region="ApplesHC", id=base_id + 326, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - First Apple Group Between Flowerbed Buildings 2": HereComesNikoLocationData(region="ApplesHC", id=base_id + 327, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - First Apple Group Near Moomy 3": HereComesNikoLocationData(region="ApplesHC", id=base_id + 328, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - First Apple Group Near Moomy 2": HereComesNikoLocationData(region="ApplesHC", id=base_id + 329, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Apple On Frog Statue Island Pier 4": HereComesNikoLocationData(region="ApplesHC", id=base_id + 330, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Second Apple Group Between Flowerbed Buildings 1": HereComesNikoLocationData(region="ApplesHC", id=base_id + 331, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Apple On Frog Statue Island Pier 1": HereComesNikoLocationData(region="ApplesHC", id=base_id + 332, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Apple On Frog Statue Island Pier 5": HereComesNikoLocationData(region="ApplesHC", id=base_id + 333, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Third Apple Group Near Moomy 3": HereComesNikoLocationData(region="ApplesHC", id=base_id + 334, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Second Apple Group Between Flowerbed Buildings 2": HereComesNikoLocationData(region="ApplesHC", id=base_id + 335, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Apple On Frog Statue Island Pier 2": HereComesNikoLocationData(region="ApplesHC", id=base_id + 336, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Apple On Pier Above Handsome Frog 1": HereComesNikoLocationData(region="ApplesHC", id=base_id + 337, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Second Apple Group Between Flowerbed Buildings 3": HereComesNikoLocationData(region="ApplesHC", id=base_id + 338, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Apple On Lower Wooden Post After Tunnel": HereComesNikoLocationData(region="ApplesHC", id=base_id + 339, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Third Apple Group Near Moomy 2": HereComesNikoLocationData(region="ApplesHC", id=base_id + 340, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Apple On Pier Above Handsome Frog 3": HereComesNikoLocationData(region="ApplesHC", id=base_id + 341, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Apple On Higher Wooden Post After Tunnel": HereComesNikoLocationData(region="ApplesHC", id=base_id + 342, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Apple On Pier Above Handsome Frog 4": HereComesNikoLocationData(region="ApplesHC", id=base_id + 343, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - First Apple Group Between Flowerbed Buildings 3": HereComesNikoLocationData(region="ApplesHC", id=base_id + 344, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Third Apple Group Near Moomy 1": HereComesNikoLocationData(region="ApplesHC", id=base_id + 345, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Apple On Frog Statue Island Pier 3": HereComesNikoLocationData(region="ApplesHC", id=base_id + 346, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - First Apple Group Near Moomy 1": HereComesNikoLocationData(region="ApplesHC", id=base_id + 347, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Apple Behind Nina 1": HereComesNikoLocationData(region="ApplesHC", id=base_id + 348, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Second Apple Group Near Moomy 1": HereComesNikoLocationData(region="ApplesHC", id=base_id + 349, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Second Apple Group Near Moomy 3": HereComesNikoLocationData(region="ApplesHC", id=base_id + 350, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Apple Behind Nina 3": HereComesNikoLocationData(region="ApplesHC", id=base_id + 351, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Apple On Pier Above Handsome Frog 5": HereComesNikoLocationData(region="ApplesHC", id=base_id + 352, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Hairball City - Second Apple Group Near Moomy 2": HereComesNikoLocationData(region="ApplesHC", id=base_id + 353, can_create=lambda options: options.applesanity.value, location_group="Apple"),

    "Turbine Town - Apple Group In Front Of Gabi's Garden 2": HereComesNikoLocationData(region="ApplesTT", id=base_id + 354, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple On Cube In Water Between Turbine And Gabi's Garden 2": HereComesNikoLocationData(region="ApplesTT", id=base_id + 355, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple On Cube In Water Between Turbine And Gabi's Garden 1": HereComesNikoLocationData(region="ApplesTT", id=base_id + 356, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple Left Of Turbine 1": HereComesNikoLocationData(region="ApplesTT", id=base_id + 357, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple Between Containers Left Of Center Path 1": HereComesNikoLocationData(region="ApplesTT", id=base_id + 358, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple Between Containers Left Of Center Path 2": HereComesNikoLocationData(region="ApplesTT", id=base_id + 359, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple By Blessley's Container 2": HereComesNikoLocationData(region="ApplesTT", id=base_id + 360, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple On Path Towards Turbine 1": HereComesNikoLocationData(region="ApplesTT", id=base_id + 361, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple Group In Front Of Gabi's Garden 1": HereComesNikoLocationData(region="ApplesTT", id=base_id + 362, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple On Path Towards Turbine 3": HereComesNikoLocationData(region="ApplesTT", id=base_id + 363, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple On Cube In Water Between Turbine And Gabi's Garden 3": HereComesNikoLocationData(region="ApplesTT", id=base_id + 364, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple Left Of Turbine 2": HereComesNikoLocationData(region="ApplesTT", id=base_id + 365, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple Beside Gabi's Garden 3": HereComesNikoLocationData(region="ApplesTT", id=base_id + 366, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple Group In Front Of Gabi's Garden 3": HereComesNikoLocationData(region="ApplesTT", id=base_id + 367, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple At Top Of Ladder Between Turbine And Gabi's Garden": HereComesNikoLocationData(region="ApplesTT", id=base_id + 368, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple By Trash Bags In Center Path": HereComesNikoLocationData(region="ApplesTT", id=base_id + 369, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple By Blessley's Container 1": HereComesNikoLocationData(region="ApplesTT", id=base_id + 370, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple Between Containers Right Of Center Path 2": HereComesNikoLocationData(region="ApplesTT", id=base_id + 371, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple On Path Towards Turbine 5": HereComesNikoLocationData(region="ApplesTT", id=base_id + 372, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple Between Containers Right Of Center Path 3": HereComesNikoLocationData(region="ApplesTT", id=base_id + 373, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple Beside Gabi's Garden 2": HereComesNikoLocationData(region="ApplesTT", id=base_id + 374, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple On Cube In Water Behind Gabi's Garden": HereComesNikoLocationData(region="ApplesTT", id=base_id + 375, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple At Top Of Ladder Behind Gabi's Garden": HereComesNikoLocationData(region="ApplesTT", id=base_id + 376, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple Between Containers Right Of Center Path 1": HereComesNikoLocationData(region="ApplesTT", id=base_id + 377, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple By Blessley's Container 3": HereComesNikoLocationData(region="ApplesTT", id=base_id + 378, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple On Path Towards Turbine 6": HereComesNikoLocationData(region="ApplesTT", id=base_id + 379, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple On Cube In Water By Blessley's Container": HereComesNikoLocationData(region="ApplesTT", id=base_id + 380, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple On Path Towards Turbine 4": HereComesNikoLocationData(region="ApplesTT", id=base_id + 381, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple On Path Towards Turbine 2": HereComesNikoLocationData(region="ApplesTT", id=base_id + 382, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple Left Of Turbine 3": HereComesNikoLocationData(region="ApplesTT", id=base_id + 383, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple Between Containers Left Of Center Path 3": HereComesNikoLocationData(region="ApplesTT", id=base_id + 384, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple On Path Towards Turbine 7": HereComesNikoLocationData(region="ApplesTT", id=base_id + 385, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Turbine Town - Apple Beside Gabi's Garden 1": HereComesNikoLocationData(region="ApplesTT", id=base_id + 386, can_create=lambda options: options.applesanity.value, location_group="Apple"),

    "Salmon Creek Forest - Apple On Rock In Water Next To Flowers Near Stijn 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 387, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Wooden Stairs Towards Moomy 5": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 388, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Crevice In Waterfall Cave 9": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 389, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple By Soda Cannon In Treetops 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 390, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Right Path 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 391, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Rocky Mountain Backside 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 392, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Mountain Backside Highest Ladder 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 393, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Middle Of Waterfall Cave 4": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 394, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On First Rock Cluster Near Front Of Train 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 395, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Rock In Water Next To Flowers Near Stijn 5": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 396, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Third Rock Cluster Near Building Submerged In Ocean 6": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 397, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Third Rock Cluster Near Building Submerged In Ocean 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 398, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Cliff Edge At Lower Pond 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 399, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Rock Towards Message In Bottle In Waterfall Cave 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 400, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Mountain Backside Middle Ladder 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 401, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Third Rock Cluster Near Building Submerged In Ocean 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 402, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Treehouse 5": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 403, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Treehouse 6": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 404, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Mountain Backside Lowest Cliff 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 405, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple Near Handsome Frog 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 406, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Rock In Water Next To Flowers Near Stijn 4": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 407, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On First Stairs": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 408, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Middle Of Waterfall Cave 5": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 409, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Cliff Edge At Lower Pond 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 410, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Second Rock Cluster Near Front Of Train 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 411, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Front Of Lower Pond 7": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 412, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Rock In Water Next To Flowers Near Stijn 6": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 413, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple Around Tree Near Mitch 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 414, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On First Platform Near Treehouse 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 415, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Front Of Lower Pond 8": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 416, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Rocky Mountain Backside 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 417, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Treehouse 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 418, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Wooden Bridge With Coin 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 419, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Crevice In Waterfall Cave 7": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 420, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Path In Front Of Locked Cave 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 421, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On First Rock Cluster Near Building Submerged In Ocean 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 422, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Bench At Stijn's House": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 423, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple By Soda Cannon In Treetops 5": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 424, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Mountain Backside Lowest Cliff 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 425, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple By Soda Cannon In Treetops 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 426, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Third Rock Cluster Near Building Submerged In Ocean 4": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 427, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Front Of Lower Pond 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 428, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Mountain Backside Middle Cliff 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 429, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Wooden Stairs Towards Moomy 6": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 430, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple By Soda Cannon Near River Waterfall 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 431, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple By Soda Cannon Near River Waterfall 4": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 432, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Rock Towards Message In Bottle In Waterfall Cave 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 433, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Rock Towards Message In Bottle In Waterfall Cave 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 434, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Wooden Stairs Towards Moomy 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 435, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Third Rock Cluster Near Building Submerged In Ocean 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 436, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Crevice In Waterfall Cave 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 437, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Front Of Lower Pond 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 438, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On First Platform Near Treehouse 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 439, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Second Rock Cluster Near Front Of Train 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 440, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Path In Front Of Locked Cave 4": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 441, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Third Rock Cluster Near Building Submerged In Ocean 5": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 442, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Mountain Backside Lowest Cliff 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 443, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Second Rock Cluster Near Building Submerged In Ocean 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 444, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Path In Front Of Locked Cave 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 445, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Middle Of Waterfall Cave 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 446, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Crevice In Waterfall Cave 5": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 447, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple By Soda Cannon Near River Waterfall 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 448, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple Around Tree Near Mitch 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 449, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Mountain Backside Middle Ladder 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 450, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple By Soda Cannon In Treetops 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 451, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Crevice In Waterfall Cave 4": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 452, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Mountain Backside Middle Ladder 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 453, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Crevice In Waterfall Cave 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 454, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Wooden Bridge With Coin 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 455, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Mushroom Against Wall In Waterfall Cave 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 456, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On First Platform Near Treehouse 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 457, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On First Rock Cluster Near Building Submerged In Ocean 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 458, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple Around Tree Near Mitch 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 459, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple By Kiosk 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 460, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Lower Wooden Post Near Train": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 461, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Front Of Lower Pond 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 462, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Rocky Mountain Backside 4": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 463, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple By Soda Cannon In Treetops 4": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 464, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Mountain Backside Highest Ladder 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 465, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Rocky Mountain Backside 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 466, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Wooden Bridge With Coin 4": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 467, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Rock In Water Next To Flowers Near Stijn 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 468, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Treehouse 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 469, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On First Rock Cluster Near Front Of Train 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 470, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Middle Of Waterfall Cave 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 471, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Middle Of Waterfall Cave 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 472, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Wooden Bridge With Coin 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 473, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Front Of Lower Pond 4": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 474, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Wooden Stairs Towards Moomy 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 475, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Crevice In Waterfall Cave 6": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 476, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Front Of Lower Pond 5": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 477, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Higher Wooden Post Near Train": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 478, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Right Path 5": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 479, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Mushroom Against Wall In Waterfall Cave 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 480, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Cliff Edge At Lower Pond 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 481, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Mountain Backside Middle Cliff 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 482, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Crevice In Waterfall Cave 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 483, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple Near Handsome Frog 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 484, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Mushroom Against Wall In Waterfall Cave 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 485, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Rock In Water Next To Flowers Near Stijn 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 486, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Rock In Water Next To Flowers Near Stijn 8": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 487, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On First Rock Cluster Near Building Submerged In Ocean 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 488, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Wooden Stairs Towards Moomy 4": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 489, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Right Path 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 490, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Rock In Water Next To Flowers Near Stijn 7": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 491, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple By Kiosk 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 492, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On First Rock Cluster Near Front Of Train 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 493, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Wooden Bridge Near Blessley": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 494, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple By Soda Cannon Near River Waterfall 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 495, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Wooden Post In Frog Statue Pond": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 496, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Treehouse 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 497, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Second Rock Cluster Near Building Submerged In Ocean 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 498, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Second Rock Cluster Near Building Submerged In Ocean 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 499, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Second Rock Cluster Near Front Of Train 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 500, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Path In Front Of Locked Cave 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 501, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Treehouse 4": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 502, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Rock In Water Next To Flowers Near Stijn 9": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 503, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Mountain Backside Highest Ladder 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 504, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Crevice In Waterfall Cave 8": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 505, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple By Kiosk 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 506, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Mountain Backside Middle Cliff 1": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 507, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple In Front Of Lower Pond 6": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 508, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Right Path 3": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 509, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Right Path 4": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 510, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Second Rock Cluster Near Front Of Train 4": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 511, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Salmon Creek Forest - Apple On Wooden Stairs Towards Moomy 2": HereComesNikoLocationData(region="ApplesSCF", id=base_id + 512, can_create=lambda options: options.applesanity.value, location_group="Apple"),

    "Public Pool - Apple Near Soda Cannon To Far Away Island 6": HereComesNikoLocationData(region="ApplesPP", id=base_id + 513, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Handsome Frog 3": HereComesNikoLocationData(region="ApplesPP", id=base_id + 514, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Second Apple Group Near Shallow Pool Second Palm Tree 1": HereComesNikoLocationData(region="ApplesPP", id=base_id + 515, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Third Apple Group Near Shallow Pool First Palm Tree 2": HereComesNikoLocationData(region="ApplesPP", id=base_id + 516, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Beside BIG Pool 13": HereComesNikoLocationData(region="ApplesPP", id=base_id + 517, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Fourth Front Palm Tree": HereComesNikoLocationData(region="ApplesPP", id=base_id + 518, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Beside BIG Pool 14": HereComesNikoLocationData(region="ApplesPP", id=base_id + 519, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Blippy Dog On Ground 1": HereComesNikoLocationData(region="ApplesPP", id=base_id + 520, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Beside BIG Pool 15": HereComesNikoLocationData(region="ApplesPP", id=base_id + 521, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 9": HereComesNikoLocationData(region="ApplesPP", id=base_id + 522, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - First Apple Group Near Shallow Pool Second Palm Tree 1": HereComesNikoLocationData(region="ApplesPP", id=base_id + 523, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Blippy Dog On Stairs 1": HereComesNikoLocationData(region="ApplesPP", id=base_id + 524, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Blessley's Island Outside Fence 2": HereComesNikoLocationData(region="ApplesPP", id=base_id + 525, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Third Apple Group Near Shallow Pool Second Palm Tree 3": HereComesNikoLocationData(region="ApplesPP", id=base_id + 526, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Blippy Dog On Stairs 2": HereComesNikoLocationData(region="ApplesPP", id=base_id + 527, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Handsome Frog 1": HereComesNikoLocationData(region="ApplesPP", id=base_id + 528, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Soda Cannon To Far Away Island 8": HereComesNikoLocationData(region="ApplesPP", id=base_id + 529, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 6": HereComesNikoLocationData(region="ApplesPP", id=base_id + 530, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 11": HereComesNikoLocationData(region="ApplesPP", id=base_id + 531, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 19": HereComesNikoLocationData(region="ApplesPP", id=base_id + 532, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Beside BIG Pool 12": HereComesNikoLocationData(region="ApplesPP", id=base_id + 533, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Mitch Outside Fence 1": HereComesNikoLocationData(region="ApplesPP", id=base_id + 534, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 21": HereComesNikoLocationData(region="ApplesPP", id=base_id + 535, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Beside BIG Pool 5": HereComesNikoLocationData(region="ApplesPP", id=base_id + 536, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Back Left Corner Inside Fence 2": HereComesNikoLocationData(region="ApplesPP", id=base_id + 537, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Second Apple Group Near Shallow Pool Second Palm Tree 2": HereComesNikoLocationData(region="ApplesPP", id=base_id + 538, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 20": HereComesNikoLocationData(region="ApplesPP", id=base_id + 539, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 17": HereComesNikoLocationData(region="ApplesPP", id=base_id + 540, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Beside BIG Pool 1": HereComesNikoLocationData(region="ApplesPP", id=base_id + 541, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Soda Cannon To Far Away Island 5": HereComesNikoLocationData(region="ApplesPP", id=base_id + 542, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Blessley's Island Outside Fence 1": HereComesNikoLocationData(region="ApplesPP", id=base_id + 543, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Beside BIG Pool 10": HereComesNikoLocationData(region="ApplesPP", id=base_id + 544, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 8": HereComesNikoLocationData(region="ApplesPP", id=base_id + 545, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Beside BIG Pool 3": HereComesNikoLocationData(region="ApplesPP", id=base_id + 546, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 1": HereComesNikoLocationData(region="ApplesPP", id=base_id + 547, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 4": HereComesNikoLocationData(region="ApplesPP", id=base_id + 548, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Beside BIG Pool 2": HereComesNikoLocationData(region="ApplesPP", id=base_id + 549, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - First Apple Group Near Shallow Pool First Palm Tree 2": HereComesNikoLocationData(region="ApplesPP", id=base_id + 550, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Blippy Dog On Stairs 3": HereComesNikoLocationData(region="ApplesPP", id=base_id + 551, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Beside BIG Pool 9": HereComesNikoLocationData(region="ApplesPP", id=base_id + 552, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 23": HereComesNikoLocationData(region="ApplesPP", id=base_id + 553, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Back Left Corner Inside Fence 1": HereComesNikoLocationData(region="ApplesPP", id=base_id + 554, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Beside BIG Pool 7": HereComesNikoLocationData(region="ApplesPP", id=base_id + 555, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 22": HereComesNikoLocationData(region="ApplesPP", id=base_id + 556, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Mitch Outside Fence 3": HereComesNikoLocationData(region="ApplesPP", id=base_id + 557, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Soda Cannon To Far Away Island 2": HereComesNikoLocationData(region="ApplesPP", id=base_id + 558, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Blessley's Island Inside Fence 2": HereComesNikoLocationData(region="ApplesPP", id=base_id + 559, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 24": HereComesNikoLocationData(region="ApplesPP", id=base_id + 560, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Third Apple Group Near Shallow Pool First Palm Tree 1": HereComesNikoLocationData(region="ApplesPP", id=base_id + 561, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 3": HereComesNikoLocationData(region="ApplesPP", id=base_id + 562, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Soda Cannon To Far Away Island 4": HereComesNikoLocationData(region="ApplesPP", id=base_id + 563, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Blessley's Island Inside Fence 3": HereComesNikoLocationData(region="ApplesPP", id=base_id + 564, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Third Apple Group Near Shallow Pool Second Palm Tree 1": HereComesNikoLocationData(region="ApplesPP", id=base_id + 565, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Beside BIG Pool 4": HereComesNikoLocationData(region="ApplesPP", id=base_id + 566, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 13": HereComesNikoLocationData(region="ApplesPP", id=base_id + 567, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Soda Cannon To Far Away Island 1": HereComesNikoLocationData(region="ApplesPP", id=base_id + 568, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Back Left Corner Outside Fence 3": HereComesNikoLocationData(region="ApplesPP", id=base_id + 569, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 2": HereComesNikoLocationData(region="ApplesPP", id=base_id + 570, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Soda Cannon To Far Away Island 3": HereComesNikoLocationData(region="ApplesPP", id=base_id + 571, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Second Front Palm Tree": HereComesNikoLocationData(region="ApplesPP", id=base_id + 572, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 18": HereComesNikoLocationData(region="ApplesPP", id=base_id + 573, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Back Left Corner Outside Fence 1": HereComesNikoLocationData(region="ApplesPP", id=base_id + 574, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Back Left Corner Outside Fence 2": HereComesNikoLocationData(region="ApplesPP", id=base_id + 575, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near First Front Palm Tree": HereComesNikoLocationData(region="ApplesPP", id=base_id + 576, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - First Apple Group Near Shallow Pool Second Palm Tree 2": HereComesNikoLocationData(region="ApplesPP", id=base_id + 577, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Blippy Dog On Ground 3": HereComesNikoLocationData(region="ApplesPP", id=base_id + 578, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 10": HereComesNikoLocationData(region="ApplesPP", id=base_id + 579, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Beside BIG Pool 11": HereComesNikoLocationData(region="ApplesPP", id=base_id + 580, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Blessley's Island Inside Fence 1": HereComesNikoLocationData(region="ApplesPP", id=base_id + 581, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Beside BIG Pool 8": HereComesNikoLocationData(region="ApplesPP", id=base_id + 582, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Back Left Corner Inside Fence 3": HereComesNikoLocationData(region="ApplesPP", id=base_id + 583, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - First Apple Group Near Shallow Pool First Palm Tree 1": HereComesNikoLocationData(region="ApplesPP", id=base_id + 584, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Second Apple Group Near Shallow Pool First Palm Tree 1": HereComesNikoLocationData(region="ApplesPP", id=base_id + 585, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 5": HereComesNikoLocationData(region="ApplesPP", id=base_id + 586, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 12": HereComesNikoLocationData(region="ApplesPP", id=base_id + 587, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Handsome Frog 2": HereComesNikoLocationData(region="ApplesPP", id=base_id + 588, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 14": HereComesNikoLocationData(region="ApplesPP", id=base_id + 589, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 16": HereComesNikoLocationData(region="ApplesPP", id=base_id + 590, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - First Apple Group Near Shallow Pool First Palm Tree 3": HereComesNikoLocationData(region="ApplesPP", id=base_id + 591, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 7": HereComesNikoLocationData(region="ApplesPP", id=base_id + 592, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - First Apple Group Near Shallow Pool Second Palm Tree 3": HereComesNikoLocationData(region="ApplesPP", id=base_id + 593, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Mitch Outside Fence 2": HereComesNikoLocationData(region="ApplesPP", id=base_id + 594, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Third Front Palm Tree": HereComesNikoLocationData(region="ApplesPP", id=base_id + 595, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Far Away Island 15": HereComesNikoLocationData(region="ApplesPP", id=base_id + 596, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Second Apple Group Near Shallow Pool First Palm Tree 2": HereComesNikoLocationData(region="ApplesPP", id=base_id + 597, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Third Apple Group Near Shallow Pool Second Palm Tree 2": HereComesNikoLocationData(region="ApplesPP", id=base_id + 598, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Beside BIG Pool 6": HereComesNikoLocationData(region="ApplesPP", id=base_id + 599, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Third Apple Group Near Shallow Pool First Palm Tree 3": HereComesNikoLocationData(region="ApplesPP", id=base_id + 600, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Second Apple Group Near Shallow Pool First Palm Tree 3": HereComesNikoLocationData(region="ApplesPP", id=base_id + 601, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple On Blessley's Island Outside Fence 3": HereComesNikoLocationData(region="ApplesPP", id=base_id + 602, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Soda Cannon To Far Away Island 7": HereComesNikoLocationData(region="ApplesPP", id=base_id + 603, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Blippy Dog On Ground 2": HereComesNikoLocationData(region="ApplesPP", id=base_id + 604, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Second Apple Group Near Shallow Pool Second Palm Tree 3": HereComesNikoLocationData(region="ApplesPP", id=base_id + 605, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Public Pool - Apple Near Mitch Outside Fence 4": HereComesNikoLocationData(region="ApplesPP", id=base_id + 606, can_create=lambda options: options.applesanity.value, location_group="Apple"),

    "Bathhouse - Apple On Bridge Between Mai And Game Kid 3": HereComesNikoLocationData(region="ApplesBath", id=base_id + 607, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Near Louist 5": HereComesNikoLocationData(region="ApplesBath", id=base_id + 608, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Train Tracks In Tunnel 4": HereComesNikoLocationData(region="ApplesBath", id=base_id + 609, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Middle Building First Floor Roof 5": HereComesNikoLocationData(region="ApplesBath", id=base_id + 610, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple By Handsome Frog 3": HereComesNikoLocationData(region="ApplesBath", id=base_id + 611, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Middle Building First Floor Roof 4": HereComesNikoLocationData(region="ApplesBath", id=base_id + 612, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Middle Building First Floor Roof 10": HereComesNikoLocationData(region="ApplesBath", id=base_id + 613, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Up Ladder Above Game Kid 8": HereComesNikoLocationData(region="ApplesBath", id=base_id + 614, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Near Dustan 4": HereComesNikoLocationData(region="ApplesBath", id=base_id + 615, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Up Ladder Above Game Kid 6": HereComesNikoLocationData(region="ApplesBath", id=base_id + 616, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Middle Building First Floor Roof 2": HereComesNikoLocationData(region="ApplesBath", id=base_id + 617, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Up Ladder Above Game Kid 7": HereComesNikoLocationData(region="ApplesBath", id=base_id + 618, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Third Apple Group Near Mai 1": HereComesNikoLocationData(region="ApplesBath", id=base_id + 619, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple By Handsome Frog 7": HereComesNikoLocationData(region="ApplesBath", id=base_id + 620, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Near Louist 1": HereComesNikoLocationData(region="ApplesBath", id=base_id + 621, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Near Dustan 1": HereComesNikoLocationData(region="ApplesBath", id=base_id + 622, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Second Apple Group Near Mai 2": HereComesNikoLocationData(region="ApplesBath", id=base_id + 623, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple By Handsome Frog 9": HereComesNikoLocationData(region="ApplesBath", id=base_id + 624, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Middle Building First Floor Roof 9": HereComesNikoLocationData(region="ApplesBath", id=base_id + 625, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Pipes Near Louist 2": HereComesNikoLocationData(region="ApplesBath", id=base_id + 626, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple By Breakable Box 1": HereComesNikoLocationData(region="ApplesBath", id=base_id + 627, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - First Apple Group Near Mai 2": HereComesNikoLocationData(region="ApplesBath", id=base_id + 628, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Near Dustan 2": HereComesNikoLocationData(region="ApplesBath", id=base_id + 629, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Near Lamp Near Moomy 1": HereComesNikoLocationData(region="ApplesBath", id=base_id + 630, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - First Apple Group Near Mai 1": HereComesNikoLocationData(region="ApplesBath", id=base_id + 631, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Train Tracks In Tunnel 1": HereComesNikoLocationData(region="ApplesBath", id=base_id + 632, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Near Dustan 7": HereComesNikoLocationData(region="ApplesBath", id=base_id + 633, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Near Louist 2": HereComesNikoLocationData(region="ApplesBath", id=base_id + 634, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Second Apple Group Near Mai 1": HereComesNikoLocationData(region="ApplesBath", id=base_id + 635, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Near Dustan 8": HereComesNikoLocationData(region="ApplesBath", id=base_id + 636, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple By Breakable Box 2": HereComesNikoLocationData(region="ApplesBath", id=base_id + 637, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple By Handsome Frog 5": HereComesNikoLocationData(region="ApplesBath", id=base_id + 638, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Third Apple Group Near Mai 2": HereComesNikoLocationData(region="ApplesBath", id=base_id + 639, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Train Tracks In Tunnel 2": HereComesNikoLocationData(region="ApplesBath", id=base_id + 640, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple By Handsome Frog 10": HereComesNikoLocationData(region="ApplesBath", id=base_id + 641, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Middle Building First Floor Roof 3": HereComesNikoLocationData(region="ApplesBath", id=base_id + 642, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Middle Building First Floor Roof 8": HereComesNikoLocationData(region="ApplesBath", id=base_id + 643, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - First Apple Group Near Mai 3": HereComesNikoLocationData(region="ApplesBath", id=base_id + 644, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Middle Building First Floor Roof 7": HereComesNikoLocationData(region="ApplesBath", id=base_id + 645, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Pipes Near Louist 1": HereComesNikoLocationData(region="ApplesBath", id=base_id + 646, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple By Breakable Box 3": HereComesNikoLocationData(region="ApplesBath", id=base_id + 647, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Pipes Near Louist 4": HereComesNikoLocationData(region="ApplesBath", id=base_id + 648, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Near Louist 4": HereComesNikoLocationData(region="ApplesBath", id=base_id + 649, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Middle Building First Floor Roof 6": HereComesNikoLocationData(region="ApplesBath", id=base_id + 650, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Up Ladder Above Game Kid 1": HereComesNikoLocationData(region="ApplesBath", id=base_id + 651, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Up Ladder Above Game Kid 3": HereComesNikoLocationData(region="ApplesBath", id=base_id + 652, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Near Dustan 6": HereComesNikoLocationData(region="ApplesBath", id=base_id + 653, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Near Lamp Near Moomy 2": HereComesNikoLocationData(region="ApplesBath", id=base_id + 654, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Bridge Between Mitch And Mai 3": HereComesNikoLocationData(region="ApplesBath", id=base_id + 655, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple By Handsome Frog 2": HereComesNikoLocationData(region="ApplesBath", id=base_id + 656, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple By Handsome Frog 6": HereComesNikoLocationData(region="ApplesBath", id=base_id + 657, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple By Handsome Frog 8": HereComesNikoLocationData(region="ApplesBath", id=base_id + 658, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Bridge Between Mai And Game Kid 2": HereComesNikoLocationData(region="ApplesBath", id=base_id + 659, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Bridge Between Mitch And Mai 1": HereComesNikoLocationData(region="ApplesBath", id=base_id + 660, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Up Ladder Above Game Kid 2": HereComesNikoLocationData(region="ApplesBath", id=base_id + 661, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Near Lamp Near Moomy 3": HereComesNikoLocationData(region="ApplesBath", id=base_id + 662, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Up Ladder Above Game Kid 4": HereComesNikoLocationData(region="ApplesBath", id=base_id + 663, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Third Apple Group Near Mai 3": HereComesNikoLocationData(region="ApplesBath", id=base_id + 664, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Near Louist 3": HereComesNikoLocationData(region="ApplesBath", id=base_id + 665, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Bridge Between Mai And Game Kid 1": HereComesNikoLocationData(region="ApplesBath", id=base_id + 666, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple By Breakable Box 4": HereComesNikoLocationData(region="ApplesBath", id=base_id + 667, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Pipes Near Louist 5": HereComesNikoLocationData(region="ApplesBath", id=base_id + 668, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple By Handsome Frog 1": HereComesNikoLocationData(region="ApplesBath", id=base_id + 669, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple By Handsome Frog 4": HereComesNikoLocationData(region="ApplesBath", id=base_id + 670, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Pipes Near Louist 3": HereComesNikoLocationData(region="ApplesBath", id=base_id + 671, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Bridge Between Mitch And Mai 2": HereComesNikoLocationData(region="ApplesBath", id=base_id + 672, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Near Dustan 5": HereComesNikoLocationData(region="ApplesBath", id=base_id + 673, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Middle Building First Floor Roof 1": HereComesNikoLocationData(region="ApplesBath", id=base_id + 674, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple On Train Tracks In Tunnel 3": HereComesNikoLocationData(region="ApplesBath", id=base_id + 675, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Second Apple Group Near Mai 3": HereComesNikoLocationData(region="ApplesBath", id=base_id + 676, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Up Ladder Above Game Kid 5": HereComesNikoLocationData(region="ApplesBath", id=base_id + 677, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Bathhouse - Apple Near Dustan 3": HereComesNikoLocationData(region="ApplesBath", id=base_id + 678, can_create=lambda options: options.applesanity.value, location_group="Apple"),

    "Tadpole HQ - Apple By Blessley 2": HereComesNikoLocationData(region="ApplesHQ", id=base_id + 679, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Tadpole HQ - Apple Behind Bench Near Fischer": HereComesNikoLocationData(region="ApplesHQ", id=base_id + 680, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Tadpole HQ - Apple By Blessley 1": HereComesNikoLocationData(region="ApplesHQ", id=base_id + 681, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Tadpole HQ - Apple On Right Path 1": HereComesNikoLocationData(region="ApplesHQ", id=base_id + 682, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Tadpole HQ - Apple On Xylophone": HereComesNikoLocationData(region="ApplesHQ", id=base_id + 683, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Tadpole HQ - Apple On Left Path 1": HereComesNikoLocationData(region="ApplesHQ", id=base_id + 684, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Tadpole HQ - Apple On Left Path 3": HereComesNikoLocationData(region="ApplesHQ", id=base_id + 685, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Tadpole HQ - Apple By Blessley 3": HereComesNikoLocationData(region="ApplesHQ", id=base_id + 686, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Tadpole HQ - Apple On Ledge Near Dojo Guy 1": HereComesNikoLocationData(region="ApplesHQ", id=base_id + 687, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Tadpole HQ - Apple On Left Path 2": HereComesNikoLocationData(region="ApplesHQ", id=base_id + 688, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Tadpole HQ - Apple Behind Fischer Towards Rocks": HereComesNikoLocationData(region="ApplesHQ", id=base_id + 689, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Tadpole HQ - Apple In Front Of Train": HereComesNikoLocationData(region="ApplesHQ", id=base_id + 690, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Tadpole HQ - Apple On Right Path 2": HereComesNikoLocationData(region="ApplesHQ", id=base_id + 691, can_create=lambda options: options.applesanity.value, location_group="Apple"),
    "Tadpole HQ - Apple On Ledge Near Dojo Guy 2": HereComesNikoLocationData(region="ApplesHQ", id=base_id + 692, can_create=lambda options: options.applesanity.value, location_group="Apple"),

    # Progressive Cassette Locations
    "Mitch/Mai - 1": HereComesNikoLocationData(region="Home",id=base_id + 1001, can_create=lambda options: options.cassette_logic.value==1, location_group="Mitch & Mai"),
    "Mitch/Mai - 2": HereComesNikoLocationData(region="Home",id=base_id + 1002, can_create=lambda options: options.cassette_logic.value==1, location_group="Mitch & Mai"),
    "Mitch/Mai - 3": HereComesNikoLocationData(region="Home",id=base_id + 1003, can_create=lambda options: options.cassette_logic.value==1, location_group="Mitch & Mai"),
    "Mitch/Mai - 4": HereComesNikoLocationData(region="Home",id=base_id + 1004, can_create=lambda options: options.cassette_logic.value==1, location_group="Mitch & Mai"),
    "Mitch/Mai - 5": HereComesNikoLocationData(region="Home",id=base_id + 1005, can_create=lambda options: options.cassette_logic.value==1, location_group="Mitch & Mai"),
    "Mitch/Mai - 6": HereComesNikoLocationData(region="Home",id=base_id + 1006, can_create=lambda options: options.cassette_logic.value==1, location_group="Mitch & Mai"),
    "Mitch/Mai - 7": HereComesNikoLocationData(region="Home",id=base_id + 1007, can_create=lambda options: options.cassette_logic.value==1, location_group="Mitch & Mai"),
    "Mitch/Mai - 8": HereComesNikoLocationData(region="Home",id=base_id + 1008, can_create=lambda options: options.cassette_logic.value==1, location_group="Mitch & Mai"),
    "Mitch/Mai - 9": HereComesNikoLocationData(region="Home",id=base_id + 1009, can_create=lambda options: options.cassette_logic.value==1, location_group="Mitch & Mai"),
    "Mitch/Mai - 10": HereComesNikoLocationData(region="Home",id=base_id + 1010, can_create=lambda options: options.cassette_logic.value==1, location_group="Mitch & Mai"),
    "Mitch/Mai - 11": HereComesNikoLocationData(region="Home",id=base_id + 1011, can_create=lambda options: options.cassette_logic.value==1, location_group="Mitch & Mai"),
    "Mitch/Mai - 12": HereComesNikoLocationData(region="Home",id=base_id + 1012, can_create=lambda options: options.cassette_logic.value==1, location_group="Mitch & Mai"),
    "Mitch/Mai - 13": HereComesNikoLocationData(region="Home",id=base_id + 1013, can_create=lambda options: options.cassette_logic.value==1 and options.shuffle_garys_garden.value, location_group="Mitch & Mai"),
    "Mitch/Mai - 14": HereComesNikoLocationData(region="Home",id=base_id + 1014, can_create=lambda options: options.cassette_logic.value==1 and options.shuffle_garys_garden.value, location_group="Mitch & Mai"),

    # Chatsanity (Level Based)
    "Home - Pepper (Chatsanity)": HereComesNikoLocationData(region="ChatHome",id=base_id + 1100, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Mata (Chatsanity)": HereComesNikoLocationData(region="ChatHome",id=base_id + 1101, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Low Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHome",id=base_id + 1102, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - High Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHome",id=base_id + 1103, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Blast Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHome",id=base_id + 1104, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Dispatcher (Chatsanity)": HereComesNikoLocationData(region="ChatHome",id=base_id + 1105, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Info Frog (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1106, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Moomy (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1107, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Blessley (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1108, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Vlog Frog (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1109, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Louist (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1110, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Serschel (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1111, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Dustan (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1112, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Travis (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1113, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Trixie (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1114, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Mitch (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1115, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Mai (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1116, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Gunter (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1117, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Little Gabi (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1118, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Blippy (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1119, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Game Kid (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1120, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Nina (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1121, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Stijn (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1122, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Melissa (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1123, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Fischer (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1124, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Frog King (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1125, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Poppy (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1126, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Paul (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1127, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Frogtective (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1128, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    #"Home - Mata (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1129, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Pelican (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1130, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Minoes (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1131, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Maggie (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1132, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Carrot (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1133, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    #"Home - Dispatcher (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1134, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Mahjong Frog (Chatsanity)": HereComesNikoLocationData(region="ChatParty",id=base_id + 1135, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Home - Hasselhop (Chatsanity)": HereComesNikoLocationData(region="ChatHome",id=base_id + 1440, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),

    "Hairball City - Britney (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1136, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Salty Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1137, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Small Talk Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1138, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Train Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1139, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Bobby (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1140, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Nervous Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1141, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Tough Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1142, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Impatient Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1143, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Vlog Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1144, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Scare Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1145, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Jiji (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1146, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Maggie (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1147, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Minoes (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1148, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Frog of Destruction (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1149, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Simon (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1150, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Brooklyn Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1151, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Carrot (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1152, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Dustan (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1153, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Travis (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1154, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Shovelin' Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1155, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Flowery Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1156, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - HUD Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1157, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Pepper (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1158, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Gunter (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1159, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Blippy Dog (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1160, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Blippy (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1161, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Moomy (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1162, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Blessley (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1163, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Fischer (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1164, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Melissa (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1165, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Stijn (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1166, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Nina (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1167, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Game Kid (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1168, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Serschel (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1169, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Louist (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1170, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Little Gabi (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1171, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Mitch (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1172, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Mai (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1173, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Dispatcher (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1174, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Hairball City - Handsome Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1370, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_handsome_frog.value, location_group="Chatsanity"),
    "Hairball City - Hasselhop (Chatsanity)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1441, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),

    "Turbine Town - Tip Frog (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1175, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Train Frog (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1176, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Vlog Frog (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1177, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Gull Friend (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1178, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Gull Friend 2 (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1179, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Fry loving Gull (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1180, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Baby Gull (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1181, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Britney (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1182, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Culture Gull (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1183, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Melissa & Stijn (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1184, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Knowledgeable Gull (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1185, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Superstitious Gull (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1186, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Mythology Gull (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1187, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Lock Gull (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1188, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Pepper (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1189, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Friendly Gull (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1190, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - AC Gull (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1191, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Button Bird (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1192, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Noah (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1193, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Trixie (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1194, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Wind Dragon (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1195, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Blippy Dog (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1196, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Little Gabi (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1197, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Blessley (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1198, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Fischer (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1199, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Blippy (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1200, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Pelly the Engineer (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1201, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Serschel (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1202, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Louist (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1203, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Dustan (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1204, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Mitch (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1205, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Mai (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1206, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Dispatcher (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1207, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Turbine Town - Handsome Frog (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1371, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_handsome_frog.value, location_group="Chatsanity"),
    "Turbine Town - Hasselhop (Chatsanity)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1442, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),

    "Salmon Creek Forest - Stijn's Dad (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1208, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Stijn's Mom (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1209, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Train Frog (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1210, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Pine Frog (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1211, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Mysterious Doe (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1212, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Turbine Stag (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1213, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Steamy Stag (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1214, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Swimming Doe (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1215, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Loud Stag (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1216, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Vlog Frog (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1217, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Fear Deer (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1218, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Divin' Doe (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1219, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    #"Salmon Creek Forest - Doe of Darkness (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1220, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Poppy (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1221, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Paul (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1222, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Flippy (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1223, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Jippy (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1224, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Mippy (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1225, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Skippy (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1226, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Tippy (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1227, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Clint (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1228, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Coco (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1229, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Culley (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1230, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Clover (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1231, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - David D. Carota (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1232, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Marry D. Carota (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1233, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Woodisch (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1234, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Scarefrog (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1235, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Treeman (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1236, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Melissa (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1237, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Stijn (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1238, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Pepper (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1239, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Blippy Dog (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1240, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Blippy (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1241, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Serschel (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1242, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Louist (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1243, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Little Gabi (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1244, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Blessley (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1245, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Fischer (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1246, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Dustan (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1247, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Trixie (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1248, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Mitch (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1249, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Mai (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1250, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Dispatcher (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1251, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Handsome Frog (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1372, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_handsome_frog.value, location_group="Chatsanity"),
    "Salmon Creek Forest - Hasselhop (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1443, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Nina (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1450, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Salmon Creek Forest - Game Kid (Chatsanity)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1451, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),

    "Public Pool - Culley (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1252, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Hat Kid (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1253, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Vacation Frog (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1254, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Fizzy the Frog (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1255, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Mom Gull (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1256, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Mom Gull 2 (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1257, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Baby Gull (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1258, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Baby Gull 2 (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1259, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Britney (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1260, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Clint (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1261, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Coco (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1262, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Clover (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1263, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - David D. Carota (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1264, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Marry D. Carota (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1265, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Dirk (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1266, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Train Frog (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1267, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Pepper (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1268, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    #"Public Pool - Pepper (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1269, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    #"Public Pool - Pepper (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1270, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Vlog Frog (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1271, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Blippy Dog (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1272, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Blippy (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1273, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Poppy (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1274, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Paul (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1275, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Flippy (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1276, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Jippy (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1277, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Mippy (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1278, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Skippy (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1279, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Tippy (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1280, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Frogtective (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1281, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Little Gabi (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1282, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Blessley (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1283, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Fischer (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1284, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Trixie (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1285, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Mitch (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1286, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Mai (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1287, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Dispatcher (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1288, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Public Pool - Handsome Frog (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1373, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_handsome_frog.value, location_group="Chatsanity"),
    "Public Pool - Hasselhop (Chatsanity)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1444, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),

    "Bathhouse - Melissa (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1289, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Stijn (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1290, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Moe (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1291, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Mickey (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1292, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Marshal (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1293, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Big Bro Stag (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1294, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Lil' Sis Doe (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1295, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Snow Frog Frog (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1296, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Steamy Frog (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1297, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Clint (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1298, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Coco (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1299, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Pepper (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1300, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Culley (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1301, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Clover (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1302, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - David D. Carota (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1303, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Marry D. Carota (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1304, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Penny (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1305, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Gashadokuro (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1306, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Paul (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1307, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Tippy (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1308, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Train Frog (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1309, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Carl (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1310, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Jess (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1311, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Miki (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1312, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Biki (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1313, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Wess (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1314, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Mahjong Frogs (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1315, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Vlog Frog (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1316, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Monty (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1317, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Blippy Dog (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1318, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Blippy (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1319, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Elizabeth IV (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1320, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Travis (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1321, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Serschel (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1322, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Louist (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1323, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Little Gabi (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1324, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Blessley (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1325, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Fischer (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1326, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Dustan (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1327, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Mitch (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1328, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Mai (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1329, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Kiosk (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1330, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Handsome Frog (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1374, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_handsome_frog.value, location_group="Chatsanity"),
    "Bathhouse - Hasselhop (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1445, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Nina (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1448, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Game Kid (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1449, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Bathhouse - Moomy (Chatsanity)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1452, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),

    "Tadpole HQ - (Ex)Employee Of The Month (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1331, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    #"Tadpole HQ - Vlog Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1332, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Melissa & Stijn (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1333, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Sushi Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1334, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Ricky (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1335, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Code Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1336, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Gamedev Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1337, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Tax Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1338, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - R&D Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1339, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - R&D Frog 2 (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1340, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - R&D Frog 3 (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1341, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Slack Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1342, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Accountant Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1343, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Robo Fr0g (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1344, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Alice (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1345, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Pepper (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1346, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Little Gabi (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1347, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - VR Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1348, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1349, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Frogucus the Green (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1350, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Blippy Dog (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1351, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Blippy (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1352, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Vlog Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1353, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Assistant Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1354, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Train Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1355, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Coffee Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1356, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Niko a0.45 (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1357, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Borbie (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1358, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Serschel (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1359, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Louist (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1360, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Blessley (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1361, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Fischer (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1362, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Master (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1363, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Travis (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1364, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Mitch (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1365, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Mai (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1366, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Fix Frog (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1367, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - King (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1368, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),
    "Tadpole HQ - Hasselhop (Chatsanity)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1446, can_create=lambda options: options.chatsanity.value==1, location_group="Chatsanity"),

    "Gary's Garden - Gary (Chatsanity)": HereComesNikoLocationData(region="ChatGarden",id=base_id + 1380, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Gary's Garden - Danger Frog (Chatsanity)": HereComesNikoLocationData(region="ChatGarden",id=base_id + 1381, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Gary's Garden - Bird (Chatsanity)": HereComesNikoLocationData(region="ChatGarden",id=base_id + 1382, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Gary's Garden - Dream Frog (Chatsanity)": HereComesNikoLocationData(region="ChatGarden",id=base_id + 1383, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Gary's Garden - Snip Frog (Chatsanity)": HereComesNikoLocationData(region="ChatGarden",id=base_id + 1384, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Gary's Garden - Fear Frog (Chatsanity)": HereComesNikoLocationData(region="ChatGarden",id=base_id + 1385, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Gary's Garden - Dance Frog (Chatsanity)": HereComesNikoLocationData(region="ChatGarden",id=base_id + 1386, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Gary's Garden - Tourist Frog (Chatsanity)": HereComesNikoLocationData(region="ChatGarden",id=base_id + 1387, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Gary's Garden - Hungry Frog (Chatsanity)": HereComesNikoLocationData(region="ChatGarden",id=base_id + 1388, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Gary's Garden - Handsome Frog (Chatsanity)": HereComesNikoLocationData(region="ChatGarden",id=base_id + 1389, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_garys_garden.value and options.shuffle_handsome_frog.value, location_group="Chatsanity"),
    "Gary's Garden - Flower Frog (Chatsanity)": HereComesNikoLocationData(region="ChatGarden",id=base_id + 1390, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Gary's Garden - Conspiracy Frog (Chatsanity)": HereComesNikoLocationData(region="ChatGarden",id=base_id + 1391, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Gary's Garden - Gunter (Chatsanity)": HereComesNikoLocationData(region="ChatGarden",id=base_id + 1392, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Gary's Garden - Mitch (Chatsanity)": HereComesNikoLocationData(region="ChatGarden",id=base_id + 1393, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Gary's Garden - Mai (Chatsanity)": HereComesNikoLocationData(region="ChatGarden",id=base_id + 1394, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Gary's Garden - Hasselhop (Chatsanity)": HereComesNikoLocationData(region="ChatGarden",id=base_id + 1447, can_create=lambda options: options.chatsanity.value==1 and options.shuffle_garys_garden.value, location_group="Chatsanity"),

    # Thoughtsanity
    "Hairball City - Niko admires a Frog Statue (Thought)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1400, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Hairball City - Niko loves Snacks (Thought)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1401, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Hairball City - Niko finds Sticky Crates (Thought)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1402, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Hairball City - Niko & Dock (Thought)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1403, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Hairball City - Niko & a Bench (Thought)": HereComesNikoLocationData(region="ChatHC",id=base_id + 1404, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),

    "Turbine Town - Niko & Haring Poster (Thought)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1405, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Turbine Town - Niko sees a distant forest (Thought)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1406, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Turbine Town - Niko visits Turbine Town (Thought)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1407, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Turbine Town - Niko & Concrete Blocks (Thought)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1408, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Turbine Town - Niko finds Space Frogs (Thought)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1409, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Turbine Town - Niko & White Torii Gate (Thought)": HereComesNikoLocationData(region="ChatTT",id=base_id + 1410, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),

    "Salmon Creek Forest - Niko & a rock (Thought)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1411, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Salmon Creek Forest - Niko smells money in a cave (Thought)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1412, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Salmon Creek Forest - Niko & Autumn trees (Thought)": HereComesNikoLocationData(region="ChatSCF",id=base_id + 1413, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),

    "Public Pool - Niko smells cotton candy (Thought)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1414, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Public Pool - Niko is ballin' (Thought)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1415, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Public Pool - Niko sees Bathhouse (Thought)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1416, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Public Pool - Niko & 2D (Thought)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1417, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Public Pool - Niko, Pink Frog & King Frog (Thought)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1418, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Public Pool - Niko & Crime (Thought)": HereComesNikoLocationData(region="ChatPP",id=base_id + 1419, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),

    "Bathhouse - Niko visits a maintenance building (Thought)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1420, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Bathhouse - Niko is a ninja (Thought)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1421, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Bathhouse - Niko's ECHO   echo (Thought)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1422, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Bathhouse - Niko & the gold statue (Thought)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1423, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Bathhouse - Niko finds footprints (Thought)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1424, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Bathhouse - Niko & the main building (Thought)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1425, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Bathhouse - Niko & a button (Thought)": HereComesNikoLocationData(region="ChatBath",id=base_id + 1426, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),

    "Tadpole HQ - Niko & a Pond Party (Thought)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1427, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Tadpole HQ - Niko sees swimming statues (Thought)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1428, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    "Tadpole HQ - Niko & Frog King Statue (Thought)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1429, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),
    #"Tadpole HQ - Niko has nightmares (Thought)": HereComesNikoLocationData(region="ChatHQ",id=base_id + 1430, can_create=lambda options: options.thoughtsanity.value==1, location_group="Thoughtsanity"),

    # Chatsanity (Global)
    "Chatsanity - Pepper": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2000, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Mata": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2001, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Low Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2002, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - High Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2003, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Blast Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2004, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Dispatcher": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2005, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Moomy": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2006, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Blessley": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2007, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Vlog Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2008, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Louist": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2009, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Serschel": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2010, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Dustan": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2011, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Travis": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2012, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Trixie": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2013, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Mitch": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2014, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Mai": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2015, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Gunter": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2016, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Little Gabi": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2017, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Game Kid": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2018, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Nina": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2019, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Stijn": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2020, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Melissa": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2021, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Fischer": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2022, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Frog King": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2023, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Poppy": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2024, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Paul": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2025, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Frogtective": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2026, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Pelly the Engineer": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2027, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    #"Chatsanity - Pelican": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2028, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Minoes": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2029, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Maggie": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2030, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Carrot": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2031, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Mahjong Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2032, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Hasselhop": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2033, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Britney": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2034, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Salty Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2035, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Small Talk Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2036, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Bobby": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2037, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Nervous Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2038, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Tough Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2039, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Impatient Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2040, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Jiji": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2041, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Frog of Destruction": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2042, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Simon": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2043, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Brooklyn Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2044, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Shovelin' Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2045, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Flowery Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2046, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - HUD Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2047, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Blippy Dog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2048, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Blippy": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2049, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Handsome Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2050, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Train Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2051, can_create=lambda options: options.chatsanity.value==2 and options.shuffle_handsome_frog.value, location_group="Chatsanity"),
    "Chatsanity - Gull Friend": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2052, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Gull Friend 2": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2053, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Fry loving Gull": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2054, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Baby Gull (TT)": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2055, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Culture Gull": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2056, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Knowledgeable Gull": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2057, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Superstitious Gull": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2058, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Mythology Gull": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2059, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Lock Gull": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2060, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    #"Chatsanity - Fry Gull": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2061, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Friendly Gull": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2062, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - AC Gull": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2063, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Button Bird": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2064, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Noah": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2065, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Wind Dragon": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2066, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Stijn's Dad": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2067, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Stijn's Mom": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2068, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Pine Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2069, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Mysterious Doe": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2070, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Turbine Stag": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2071, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Steamy Stag": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2072, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Swimming Doe": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2073, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Loud Stag": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2074, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Fear Deer": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2075, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Divin' Doe": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2076, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    #"Chatsanity - Doe of Darkness": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2077, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Flippy": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2078, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Jippy": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2079, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Mippy": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2080, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Skippy": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2081, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Tippy": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2082, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Clint": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2083, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Coco": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2084, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Culley": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2085, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Clover": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2086, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - David D. Carota": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2087, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Marry D. Carota": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2088, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Woodisch": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2089, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Scare Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2090, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Treeman": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2091, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    #"Chatsanity - Scarefrog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2092, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Hat Kid": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2093, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Vacation Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2094, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Fizzy the Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2095, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Mom Gull (TT)": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2096, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Mom Gull (PP)": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2097, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Baby Gull (PP)": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2098, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Dirk": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2099, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Moe": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2100, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    #Chatsanity Pool - Pepper": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2101, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    #Chatsanity Pool - Pepper": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2102, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Mickey": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2103, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Marshal": HereComesNikoLocationData(region="ChatBath",id=base_id + 2104, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Big Bro Stag": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2105, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Lil' Sis Doe": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2106, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Snow Frog Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2107, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Steamy Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2108, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Penny": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2109, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Gashadokuro": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2110, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Carl": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2111, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Jess": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2112, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Miki": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2113, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Biki": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2114, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Wess": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2115, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    #"Chatsanity - Mahjong Frogs (Bath)": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2116, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Monty": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2117, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Elizabeth IV": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2118, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - (Ex) Employee of the month": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2119, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    #"Chatsanity - Kiosk": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2120, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Sushi Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2121, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Ricky": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2122, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Code Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2123, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Gamedev Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2124, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Tax Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2125, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - R&D Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2126, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - R&D Frog 2": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2127, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - R&D Frog 3": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2128, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Slack Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2129, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Accountant Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2130, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Robo Fr0g": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2131, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Alice": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2132, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - VR Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2133, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Frog (Frogbucks)": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2134, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Frogucus the Green": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2135, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Assistant Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2136, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Coffee Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2137, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Niko a0.45": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2138, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Borbie": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2139, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Master": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2140, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Fix Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2141, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Tip Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2142, can_create=lambda options: options.chatsanity.value==2, location_group="Chatsanity"),
    "Chatsanity - Gary": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2143, can_create=lambda options: options.chatsanity.value==2 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Chatsanity - Danger Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2144, can_create=lambda options: options.chatsanity.value==2 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Chatsanity - Bird": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2145, can_create=lambda options: options.chatsanity.value==2 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Chatsanity - Dream Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2146, can_create=lambda options: options.chatsanity.value==2 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Chatsanity - Snip Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2147, can_create=lambda options: options.chatsanity.value==2 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Chatsanity - Fear Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2148, can_create=lambda options: options.chatsanity.value==2 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Chatsanity - Dance Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2149, can_create=lambda options: options.chatsanity.value==2 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Chatsanity - Tourist Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2150, can_create=lambda options: options.chatsanity.value==2 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Chatsanity - Hungry Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2151, can_create=lambda options: options.chatsanity.value==2 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Chatsanity - Flower Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2152, can_create=lambda options: options.chatsanity.value==2 and options.shuffle_garys_garden.value, location_group="Chatsanity"),
    "Chatsanity - Conspiracy Frog": HereComesNikoLocationData(region="Chatsanity",id=base_id + 2153, can_create=lambda options: options.chatsanity.value==2 and options.shuffle_garys_garden.value, location_group="Chatsanity"),

    #Bugsanity
    "Hairball City - Bug 1": HereComesNikoLocationData(region="BugsHC",id=base_id + 1501, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 2": HereComesNikoLocationData(region="BugsHC",id=base_id + 1502, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 3": HereComesNikoLocationData(region="BugsHC",id=base_id + 1503, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 4": HereComesNikoLocationData(region="BugsHC",id=base_id + 1504, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 5": HereComesNikoLocationData(region="BugsHC",id=base_id + 1505, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 6": HereComesNikoLocationData(region="BugsHC",id=base_id + 1506, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 7": HereComesNikoLocationData(region="BugsHC",id=base_id + 1507, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 8": HereComesNikoLocationData(region="BugsHC",id=base_id + 1508, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 9": HereComesNikoLocationData(region="BugsHC",id=base_id + 1509, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 10": HereComesNikoLocationData(region="BugsHC",id=base_id + 1510, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 11": HereComesNikoLocationData(region="BugsHC",id=base_id + 1511, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 12": HereComesNikoLocationData(region="BugsHC",id=base_id + 1512, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 13": HereComesNikoLocationData(region="BugsHC",id=base_id + 1513, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 14": HereComesNikoLocationData(region="BugsHC",id=base_id + 1514, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 15": HereComesNikoLocationData(region="BugsHC",id=base_id + 1515, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 16": HereComesNikoLocationData(region="BugsHC",id=base_id + 1516, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 17": HereComesNikoLocationData(region="BugsHC",id=base_id + 1517, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 18": HereComesNikoLocationData(region="BugsHC",id=base_id + 1518, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 19": HereComesNikoLocationData(region="BugsHC",id=base_id + 1519, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 20": HereComesNikoLocationData(region="BugsHC",id=base_id + 1520, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 21": HereComesNikoLocationData(region="BugsHC",id=base_id + 1521, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 22": HereComesNikoLocationData(region="BugsHC",id=base_id + 1522, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 23": HereComesNikoLocationData(region="BugsHC",id=base_id + 1523, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 24": HereComesNikoLocationData(region="BugsHC",id=base_id + 1524, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 25": HereComesNikoLocationData(region="BugsHC",id=base_id + 1525, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 26": HereComesNikoLocationData(region="BugsHC",id=base_id + 1526, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 27": HereComesNikoLocationData(region="BugsHC",id=base_id + 1527, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 28": HereComesNikoLocationData(region="BugsHC",id=base_id + 1528, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 29": HereComesNikoLocationData(region="BugsHC",id=base_id + 1529, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 30": HereComesNikoLocationData(region="BugsHC",id=base_id + 1530, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 31": HereComesNikoLocationData(region="BugsHC",id=base_id + 1531, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 32": HereComesNikoLocationData(region="BugsHC",id=base_id + 1532, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 33": HereComesNikoLocationData(region="BugsHC",id=base_id + 1533, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 34": HereComesNikoLocationData(region="BugsHC",id=base_id + 1534, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 35": HereComesNikoLocationData(region="BugsHC",id=base_id + 1535, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 36": HereComesNikoLocationData(region="BugsHC",id=base_id + 1536, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 37": HereComesNikoLocationData(region="BugsHC",id=base_id + 1537, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 38": HereComesNikoLocationData(region="BugsHC",id=base_id + 1538, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 39": HereComesNikoLocationData(region="BugsHC",id=base_id + 1539, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 40": HereComesNikoLocationData(region="BugsHC",id=base_id + 1540, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 41": HereComesNikoLocationData(region="BugsHC",id=base_id + 1541, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 42": HereComesNikoLocationData(region="BugsHC",id=base_id + 1542, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 43": HereComesNikoLocationData(region="BugsHC",id=base_id + 1543, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 44": HereComesNikoLocationData(region="BugsHC",id=base_id + 1544, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 45": HereComesNikoLocationData(region="BugsHC",id=base_id + 1545, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 46": HereComesNikoLocationData(region="BugsHC",id=base_id + 1546, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 47": HereComesNikoLocationData(region="BugsHC",id=base_id + 1547, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 48": HereComesNikoLocationData(region="BugsHC",id=base_id + 1548, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 49": HereComesNikoLocationData(region="BugsHC",id=base_id + 1549, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 50": HereComesNikoLocationData(region="BugsHC",id=base_id + 1550, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 51": HereComesNikoLocationData(region="BugsHC",id=base_id + 1551, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 52": HereComesNikoLocationData(region="BugsHC",id=base_id + 1552, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 53": HereComesNikoLocationData(region="BugsHC",id=base_id + 1553, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 54": HereComesNikoLocationData(region="BugsHC",id=base_id + 1554, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 55": HereComesNikoLocationData(region="BugsHC",id=base_id + 1555, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 56": HereComesNikoLocationData(region="BugsHC",id=base_id + 1556, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 57": HereComesNikoLocationData(region="BugsHC",id=base_id + 1557, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Hairball City - Bug 58": HereComesNikoLocationData(region="BugsHC",id=base_id + 1558, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),

    "Turbine Town - Bug 1": HereComesNikoLocationData(region="BugsTT",id=base_id + 1559, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 2": HereComesNikoLocationData(region="BugsTT",id=base_id + 1560, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 3": HereComesNikoLocationData(region="BugsTT",id=base_id + 1561, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 4": HereComesNikoLocationData(region="BugsTT",id=base_id + 1562, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 5": HereComesNikoLocationData(region="BugsTT",id=base_id + 1563, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 6": HereComesNikoLocationData(region="BugsTT",id=base_id + 1564, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 7": HereComesNikoLocationData(region="BugsTT",id=base_id + 1565, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 8": HereComesNikoLocationData(region="BugsTT",id=base_id + 1566, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 9": HereComesNikoLocationData(region="BugsTT",id=base_id + 1567, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 10": HereComesNikoLocationData(region="BugsTT",id=base_id + 1568, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 11": HereComesNikoLocationData(region="BugsTT",id=base_id + 1569, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 12": HereComesNikoLocationData(region="BugsTT",id=base_id + 1570, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 13": HereComesNikoLocationData(region="BugsTT",id=base_id + 1571, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 14": HereComesNikoLocationData(region="BugsTT",id=base_id + 1572, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 15": HereComesNikoLocationData(region="BugsTT",id=base_id + 1573, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 16": HereComesNikoLocationData(region="BugsTT",id=base_id + 1574, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 17": HereComesNikoLocationData(region="BugsTT",id=base_id + 1575, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 18": HereComesNikoLocationData(region="BugsTT",id=base_id + 1576, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 19": HereComesNikoLocationData(region="BugsTT",id=base_id + 1577, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 20": HereComesNikoLocationData(region="BugsTT",id=base_id + 1578, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 21": HereComesNikoLocationData(region="BugsTT",id=base_id + 1579, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 22": HereComesNikoLocationData(region="BugsTT",id=base_id + 1580, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 23": HereComesNikoLocationData(region="BugsTT",id=base_id + 1581, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 24": HereComesNikoLocationData(region="BugsTT",id=base_id + 1582, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 25": HereComesNikoLocationData(region="BugsTT",id=base_id + 1583, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 26": HereComesNikoLocationData(region="BugsTT",id=base_id + 1584, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 27": HereComesNikoLocationData(region="BugsTT",id=base_id + 1585, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 28": HereComesNikoLocationData(region="BugsTT",id=base_id + 1586, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 29": HereComesNikoLocationData(region="BugsTT",id=base_id + 1587, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 30": HereComesNikoLocationData(region="BugsTT",id=base_id + 1588, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 31": HereComesNikoLocationData(region="BugsTT",id=base_id + 1589, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 32": HereComesNikoLocationData(region="BugsTT",id=base_id + 1590, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 33": HereComesNikoLocationData(region="BugsTT",id=base_id + 1591, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 34": HereComesNikoLocationData(region="BugsTT",id=base_id + 1592, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 35": HereComesNikoLocationData(region="BugsTT",id=base_id + 1593, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 36": HereComesNikoLocationData(region="BugsTT",id=base_id + 1594, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 37": HereComesNikoLocationData(region="BugsTT",id=base_id + 1595, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 38": HereComesNikoLocationData(region="BugsTT",id=base_id + 1596, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 39": HereComesNikoLocationData(region="BugsTT",id=base_id + 1597, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 40": HereComesNikoLocationData(region="BugsTT",id=base_id + 1598, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 41": HereComesNikoLocationData(region="BugsTT",id=base_id + 1599, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 42": HereComesNikoLocationData(region="BugsTT",id=base_id + 1600, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 43": HereComesNikoLocationData(region="BugsTT",id=base_id + 1601, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 44": HereComesNikoLocationData(region="BugsTT",id=base_id + 1602, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 45": HereComesNikoLocationData(region="BugsTT",id=base_id + 1603, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 46": HereComesNikoLocationData(region="BugsTT",id=base_id + 1604, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 47": HereComesNikoLocationData(region="BugsTT",id=base_id + 1605, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 48": HereComesNikoLocationData(region="BugsTT",id=base_id + 1606, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 49": HereComesNikoLocationData(region="BugsTT",id=base_id + 1607, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 50": HereComesNikoLocationData(region="BugsTT",id=base_id + 1608, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 51": HereComesNikoLocationData(region="BugsTT",id=base_id + 1609, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 52": HereComesNikoLocationData(region="BugsTT",id=base_id + 1610, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 53": HereComesNikoLocationData(region="BugsTT",id=base_id + 1611, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 54": HereComesNikoLocationData(region="BugsTT",id=base_id + 1612, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 55": HereComesNikoLocationData(region="BugsTT",id=base_id + 1613, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 56": HereComesNikoLocationData(region="BugsTT",id=base_id + 1614, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 57": HereComesNikoLocationData(region="BugsTT",id=base_id + 1615, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Turbine Town - Bug 58": HereComesNikoLocationData(region="BugsTT",id=base_id + 1616, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),

    "Salmon Creek Forest - Bug 1": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1617, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 2": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1618, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 3": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1619, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 4": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1620, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 5": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1621, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 6": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1622, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 7": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1623, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 8": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1624, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 9": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1625, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 10": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1626, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 11": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1627, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 12": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1628, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 13": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1629, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 14": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1630, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 15": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1631, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 16": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1632, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 17": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1633, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 18": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1634, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 19": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1635, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 20": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1636, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 21": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1637, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 22": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1638, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 23": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1639, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 24": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1640, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 25": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1641, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 26": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1642, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 27": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1643, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 28": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1644, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 29": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1645, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 30": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1646, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 31": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1647, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 32": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1648, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 33": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1649, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 34": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1650, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 35": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1651, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 36": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1652, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 37": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1653, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 38": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1654, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 39": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1655, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 40": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1656, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 41": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1657, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 42": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1658, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 43": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1659, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 44": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1660, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 45": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1661, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 46": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1662, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 47": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1663, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 48": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1664, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 49": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1665, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 50": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1666, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 51": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1667, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 52": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1668, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 53": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1669, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 54": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1670, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 55": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1671, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 56": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1672, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 57": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1673, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 58": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1674, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 59": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1675, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 60": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1676, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 61": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1677, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 62": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1678, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 63": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1679, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 64": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1680, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 65": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1681, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 66": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1682, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 67": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1683, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 68": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1684, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 69": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1685, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 70": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1686, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 71": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1687, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 72": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1688, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 73": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1689, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 74": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1690, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 75": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1691, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 76": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1692, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 77": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1693, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 78": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1694, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 79": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1695, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 80": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1696, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 81": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1697, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 82": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1698, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 83": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1699, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 84": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1700, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 85": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1701, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 86": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1702, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 87": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1703, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 88": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1704, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Salmon Creek Forest - Bug 89": HereComesNikoLocationData(region="BugsSCF",id=base_id + 1705, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),

    "Public Pool - Bug 1": HereComesNikoLocationData(region="BugsPP",id=base_id + 1706, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 2": HereComesNikoLocationData(region="BugsPP",id=base_id + 1707, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 3": HereComesNikoLocationData(region="BugsPP",id=base_id + 1708, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 4": HereComesNikoLocationData(region="BugsPP",id=base_id + 1709, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 5": HereComesNikoLocationData(region="BugsPP",id=base_id + 1710, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 6": HereComesNikoLocationData(region="BugsPP",id=base_id + 1711, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 7": HereComesNikoLocationData(region="BugsPP",id=base_id + 1712, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 8": HereComesNikoLocationData(region="BugsPP",id=base_id + 1713, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 9": HereComesNikoLocationData(region="BugsPP",id=base_id + 1714, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 10": HereComesNikoLocationData(region="BugsPP",id=base_id + 1715, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 11": HereComesNikoLocationData(region="BugsPP",id=base_id + 1716, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 12": HereComesNikoLocationData(region="BugsPP",id=base_id + 1717, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 13": HereComesNikoLocationData(region="BugsPP",id=base_id + 1718, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 14": HereComesNikoLocationData(region="BugsPP",id=base_id + 1719, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 15": HereComesNikoLocationData(region="BugsPP",id=base_id + 1720, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 16": HereComesNikoLocationData(region="BugsPP",id=base_id + 1721, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 17": HereComesNikoLocationData(region="BugsPP",id=base_id + 1722, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 18": HereComesNikoLocationData(region="BugsPP",id=base_id + 1723, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 19": HereComesNikoLocationData(region="BugsPP",id=base_id + 1724, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 20": HereComesNikoLocationData(region="BugsPP",id=base_id + 1725, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 21": HereComesNikoLocationData(region="BugsPP",id=base_id + 1726, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 22": HereComesNikoLocationData(region="BugsPP",id=base_id + 1727, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 23": HereComesNikoLocationData(region="BugsPP",id=base_id + 1728, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 24": HereComesNikoLocationData(region="BugsPP",id=base_id + 1729, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 25": HereComesNikoLocationData(region="BugsPP",id=base_id + 1730, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 26": HereComesNikoLocationData(region="BugsPP",id=base_id + 1731, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 27": HereComesNikoLocationData(region="BugsPP",id=base_id + 1732, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 28": HereComesNikoLocationData(region="BugsPP",id=base_id + 1733, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 29": HereComesNikoLocationData(region="BugsPP",id=base_id + 1734, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 30": HereComesNikoLocationData(region="BugsPP",id=base_id + 1735, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 31": HereComesNikoLocationData(region="BugsPP",id=base_id + 1736, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 32": HereComesNikoLocationData(region="BugsPP",id=base_id + 1737, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 33": HereComesNikoLocationData(region="BugsPP",id=base_id + 1738, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 34": HereComesNikoLocationData(region="BugsPP",id=base_id + 1739, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 35": HereComesNikoLocationData(region="BugsPP",id=base_id + 1740, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 36": HereComesNikoLocationData(region="BugsPP",id=base_id + 1741, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 37": HereComesNikoLocationData(region="BugsPP",id=base_id + 1742, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 38": HereComesNikoLocationData(region="BugsPP",id=base_id + 1743, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 39": HereComesNikoLocationData(region="BugsPP",id=base_id + 1744, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 40": HereComesNikoLocationData(region="BugsPP",id=base_id + 1745, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 41": HereComesNikoLocationData(region="BugsPP",id=base_id + 1746, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 42": HereComesNikoLocationData(region="BugsPP",id=base_id + 1747, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Public Pool - Bug 43": HereComesNikoLocationData(region="BugsPP",id=base_id + 1748, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),

    "Bathhouse - Bug 1": HereComesNikoLocationData(region="BugsBath",id=base_id + 1749, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 2": HereComesNikoLocationData(region="BugsBath",id=base_id + 1750, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 3": HereComesNikoLocationData(region="BugsBath",id=base_id + 1751, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 4": HereComesNikoLocationData(region="BugsBath",id=base_id + 1752, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 5": HereComesNikoLocationData(region="BugsBath",id=base_id + 1753, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 6": HereComesNikoLocationData(region="BugsBath",id=base_id + 1754, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 7": HereComesNikoLocationData(region="BugsBath",id=base_id + 1755, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 8": HereComesNikoLocationData(region="BugsBath",id=base_id + 1756, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 9": HereComesNikoLocationData(region="BugsBath",id=base_id + 1757, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 10": HereComesNikoLocationData(region="BugsBath",id=base_id + 1758, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 11": HereComesNikoLocationData(region="BugsBath",id=base_id + 1759, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 12": HereComesNikoLocationData(region="BugsBath",id=base_id + 1760, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 13": HereComesNikoLocationData(region="BugsBath",id=base_id + 1761, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 14": HereComesNikoLocationData(region="BugsBath",id=base_id + 1762, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 15": HereComesNikoLocationData(region="BugsBath",id=base_id + 1763, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 16": HereComesNikoLocationData(region="BugsBath",id=base_id + 1764, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 17": HereComesNikoLocationData(region="BugsBath",id=base_id + 1765, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 18": HereComesNikoLocationData(region="BugsBath",id=base_id + 1766, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 19": HereComesNikoLocationData(region="BugsBath",id=base_id + 1767, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 20": HereComesNikoLocationData(region="BugsBath",id=base_id + 1768, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 21": HereComesNikoLocationData(region="BugsBath",id=base_id + 1769, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 22": HereComesNikoLocationData(region="BugsBath",id=base_id + 1770, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 23": HereComesNikoLocationData(region="BugsBath",id=base_id + 1771, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 24": HereComesNikoLocationData(region="BugsBath",id=base_id + 1772, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 25": HereComesNikoLocationData(region="BugsBath",id=base_id + 1773, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 26": HereComesNikoLocationData(region="BugsBath",id=base_id + 1774, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 27": HereComesNikoLocationData(region="BugsBath",id=base_id + 1775, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 28": HereComesNikoLocationData(region="BugsBath",id=base_id + 1776, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 29": HereComesNikoLocationData(region="BugsBath",id=base_id + 1777, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 30": HereComesNikoLocationData(region="BugsBath",id=base_id + 1778, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 31": HereComesNikoLocationData(region="BugsBath",id=base_id + 1779, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 32": HereComesNikoLocationData(region="BugsBath",id=base_id + 1780, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 33": HereComesNikoLocationData(region="BugsBath",id=base_id + 1781, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 34": HereComesNikoLocationData(region="BugsBath",id=base_id + 1782, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 35": HereComesNikoLocationData(region="BugsBath",id=base_id + 1783, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 36": HereComesNikoLocationData(region="BugsBath",id=base_id + 1784, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 37": HereComesNikoLocationData(region="BugsBath",id=base_id + 1785, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 38": HereComesNikoLocationData(region="BugsBath",id=base_id + 1786, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 39": HereComesNikoLocationData(region="BugsBath",id=base_id + 1787, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 40": HereComesNikoLocationData(region="BugsBath",id=base_id + 1788, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 41": HereComesNikoLocationData(region="BugsBath",id=base_id + 1789, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 42": HereComesNikoLocationData(region="BugsBath",id=base_id + 1790, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 43": HereComesNikoLocationData(region="BugsBath",id=base_id + 1791, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 44": HereComesNikoLocationData(region="BugsBath",id=base_id + 1792, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 45": HereComesNikoLocationData(region="BugsBath",id=base_id + 1793, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 46": HereComesNikoLocationData(region="BugsBath",id=base_id + 1794, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 47": HereComesNikoLocationData(region="BugsBath",id=base_id + 1795, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 48": HereComesNikoLocationData(region="BugsBath",id=base_id + 1796, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 49": HereComesNikoLocationData(region="BugsBath",id=base_id + 1797, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 50": HereComesNikoLocationData(region="BugsBath",id=base_id + 1798, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Bathhouse - Bug 51": HereComesNikoLocationData(region="BugsBath",id=base_id + 1799, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),

    "Tadpole HQ - Bug 1": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1800, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 2": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1801, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 3": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1802, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 4": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1803, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 5": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1804, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 6": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1805, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 7": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1806, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 8": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1807, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 9": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1808, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 10": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1809, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 11": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1810, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 12": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1811, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 13": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1812, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 14": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1813, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 15": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1814, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 16": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1815, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 17": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1816, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 18": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1817, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 19": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1818, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 20": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1819, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 21": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1820, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 22": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1821, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 23": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1822, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 24": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1823, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 25": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1824, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 26": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1825, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 27": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1826, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 28": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1827, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 29": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1828, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 30": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1829, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 31": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1830, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 32": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1831, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 33": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1832, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 34": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1833, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 35": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1834, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 36": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1835, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 37": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1836, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 38": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1837, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 39": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1838, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 40": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1839, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 41": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1840, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 42": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1841, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 43": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1842, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 44": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1843, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 45": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1844, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 46": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1845, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 47": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1846, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 48": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1847, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 49": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1848, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),
    "Tadpole HQ - Bug 50": HereComesNikoLocationData(region="BugsHQ",id=base_id + 1849, can_create=lambda options: options.bugsanity.value==1, location_group="Bugsanity"),

    # Bonesanity
    "Hairball City - Bone 1": HereComesNikoLocationData(region="Hairball City",id=base_id + 2201, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Hairball City - Bone 2": HereComesNikoLocationData(region="Hairball City",id=base_id + 2202, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Hairball City - Bone 3": HereComesNikoLocationData(region="Hairball City",id=base_id + 2203, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Hairball City - Bone 4": HereComesNikoLocationData(region="Hairball City",id=base_id + 2204, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Hairball City - Bone 5": HereComesNikoLocationData(region="Hairball City",id=base_id + 2205, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Turbine Town - Bone 1": HereComesNikoLocationData(region="Turbine Town",id=base_id + 2206, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Turbine Town - Bone 2": HereComesNikoLocationData(region="Turbine Town",id=base_id + 2207, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Turbine Town - Bone 3": HereComesNikoLocationData(region="Turbine Town",id=base_id + 2208, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Turbine Town - Bone 4": HereComesNikoLocationData(region="Turbine Town",id=base_id + 2209, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Turbine Town - Bone 5": HereComesNikoLocationData(region="Turbine Town",id=base_id + 2210, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Salmon Creek Forest - Bone 1": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 2211, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Salmon Creek Forest - Bone 2": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 2212, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Salmon Creek Forest - Bone 3": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 2213, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Salmon Creek Forest - Bone 4": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 2214, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Salmon Creek Forest - Bone 5": HereComesNikoLocationData(region="Salmon Creek Forest",id=base_id + 2215, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Public Pool - Bone 1": HereComesNikoLocationData(region="Public Pool",id=base_id + 2216, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Public Pool - Bone 2": HereComesNikoLocationData(region="Public Pool",id=base_id + 2217, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Public Pool - Bone 3": HereComesNikoLocationData(region="Public Pool",id=base_id + 2218, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Public Pool - Bone 4": HereComesNikoLocationData(region="Public Pool",id=base_id + 2219, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Public Pool - Bone 5": HereComesNikoLocationData(region="Public Pool",id=base_id + 2220, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Bathhouse - Bone 1": HereComesNikoLocationData(region="Bathhouse",id=base_id + 2221, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Bathhouse - Bone 2": HereComesNikoLocationData(region="Bathhouse",id=base_id + 2222, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Bathhouse - Bone 3": HereComesNikoLocationData(region="Bathhouse",id=base_id + 2223, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Bathhouse - Bone 4": HereComesNikoLocationData(region="Bathhouse",id=base_id + 2224, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Bathhouse - Bone 5": HereComesNikoLocationData(region="Bathhouse",id=base_id + 2225, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Tadpole HQ - Bone 1": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 2226, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Tadpole HQ - Bone 2": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 2227, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Tadpole HQ - Bone 3": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 2228, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Tadpole HQ - Bone 4": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 2229, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),
    "Tadpole HQ - Bone 5": HereComesNikoLocationData(region="Tadpole HQ",id=base_id + 2230, can_create=lambda options: options.bonesanity.value != 0, location_group="Bonesanity"),

    # Victory
    "You're Hired!": HereComesNikoLocationData(region="Home Party", locked_item="Victory", can_create=lambda options: options.goal_completion.value == 0),
    "Best Employee!": HereComesNikoLocationData(region="Home", locked_item="Victory", can_create=lambda options: options.goal_completion.value == 1)
}

location_name_groups: Dict[str, Set[str]] = {}
for loc_name, loc_data in location_data_table.items():
    if loc_data.locked_item:
        continue
    loc_group_name = loc_name.split(" - ", 1)[0]
    location_name_groups.setdefault(loc_group_name, set()).add(loc_name)
    if loc_data.location_group:
        location_name_groups.setdefault(loc_data.location_group, set()).add(loc_name)

location_table = {name: data.id for name, data in location_data_table.items() if data.id is not None}
id_to_location_table = {data.id: name for name, data in location_data_table.items() if data.id is not None}
locked_locations = {name: data for name, data in location_data_table.items() if data.locked_item}



