from random import Random
from typing import List, NamedTuple, Optional, Set


class FFTAObject:
    memory = 0
    displayName = ''

    def __init__(self, memory, displayName):
        self.memory = memory
        self.displayName = displayName


human_jobs = [0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C]
bangaa_jobs = [0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13]
mou_jobs = [0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B]
viera_jobs = [0x1C, 0x1D, 0x1E, 0x1F, 0x20, 0x21, 0x22, 0x23]
moogle_jobs = [0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B]
monster_jobs = [0x2C, 0x2D, 0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A,
                0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47]

all_jobs = human_jobs + bangaa_jobs + mou_jobs + viera_jobs + moogle_jobs
all_jobs_with_monster = human_jobs + bangaa_jobs + mou_jobs + viera_jobs + moogle_jobs + monster_jobs
attacker_jobs = [0x02, 0x03, 0x04, 0x05, 0x06, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x13, 0x1C, 0x21, 0x22, 0x23,
                 0x25, 0x26, 0x27, 0x28, ]
magic_jobs = [0x08, 0x09, 0x0A, 0x12, 0x15, 0x17, 0x18, 0x1B, 0x1D, 0x1E, 0x20, 0x2A]
support_jobs = [0x07, 0x14, 0x16, 0x1F, 0x24, 0x2B]

mission_item_memory = 0x2002B08
mission_items = []
for i in range(64):
    mission_items.append(mission_item_memory)
    mission_item_memory += 0x04

laws = [20, 74, 64, 75, 37, 43, 65, 21, 30, 4, 68, 22, 72, 47, 23, 50, 44, 67, 34, 70, 41, 38, 20, 4, 74, 25, 69,
        68, 42, 5, 44, 71, 30, 37, 11, 40, 64, 16, 22, 66, 50, 75, 71, 41, 18, 69, 3, 38, 44, 21, 10, 63, 14, 61,
        6, 65, 24, 9, 46, 33, 23, 72, 24, 14, 8, 62, 39, 10, 67, 35, 45, 13, 21, 48, 12, 16, 22, 2, 70, 30, 40, 76,
        49, 36, 46, 62, 7, 14, 17, 68, 82, 10, 25, 13, 34, 1, 43, 15, 3, 63, 45, 1, 82, 42, 33, 39, 8, 73, 3, 14, 50,
        47, 2, 36, 38, 19, 76, 72, 24, 66, 3, 82, 14, 19, 1, 8, 42, 2, 47, 17, 24, 33, 76, 38, 66, 35, 72, 39, 73, 61]

# (recruit, type, other)
mission_data = [(0, 11, 0), (0, 11, 0), (0, 11, 0), (0, 11, 0), (0, 11, 0), (0, 13, 0), (0, 11, 0), (0, 11, 0),
                (0, 11, 0), (0, 11, 0), (0, 11, 0), (0, 13, 0), (0, 9, 0), (0, 11, 0), (0, 13, 0), (0, 11, 0),
                (0, 11, 0), (0, 11, 0), (0, 11, 0), (0, 13, 0), (0, 11, 0), (0, 13, 0), (0, 13, 0), (0, 13, 0),
                (0, 13, 0), (3, 10, 0), (41, 10, 0), (15, 10, 0), (23, 10, 0), (32, 10, 0), (3, 10, 0), (1, 10, 0),
                (1, 10, 0), (1, 10, 0), (1, 10, 0), (111, 10, 0), (1, 10, 0), (41, 10, 0), (94, 10, 0), (94, 10, 0),
                (50, 10, 0), (64, 10, 0), (80, 10, 0), (140, 10, 0), (1, 10, 0), (1, 10, 0), (1, 10, 0), (1, 10, 0),
                (32, 10, 0), (1, 10, 0), (1, 10, 0), (94, 10, 0), (80, 10, 0), (80, 10, 0), (64, 10, 0), (1, 10, 0),
                (1, 10, 0), (1, 10, 0), (1, 10, 0), (1, 10, 0), (50, 10, 0), (1, 10, 0), (1, 10, 0), (146, 10, 0),
                (111, 10, 0), (1, 10, 0), (111, 10, 0), (0, 10, 0), (1, 10, 0), (1, 10, 0), (1, 210, 0), (1, 10, 0),
                (1, 10, 0), (1, 10, 0), (1, 10, 0), (1, 10, 0), (1, 82, 0), (1, 10, 0), (1, 146, 0), (1, 10, 0),
                (1, 10, 0), (1, 10, 0), (1, 10, 0), (1, 18, 0), (111, 10, 0), (111, 10, 0), (111, 10, 0), (111, 10, 0),
                (80, 82, 0), (3, 10, 0), (41, 10, 0), (1, 10, 0), (1, 10, 0), (1, 10, 0), (1, 10, 0), (1, 10, 0),
                (32, 10, 0), (15, 10, 0), (1, 10, 0), (1, 10, 0), (1, 10, 0), (94, 9, 0), (94, 9, 0), (1, 9, 1),
                (15, 9, 0), (23, 9, 0), (32, 9, 0), (41, 9, 0), (1, 9, 0), (1, 9, 0), (1, 9, 1), (1, 9, 0), (0, 9, 0),
                (32, 9, 0), (1, 9, 0), (1, 9, 0), (111, 9, 0), (94, 9, 0), (50, 9, 0), (0, 9, 0), (3, 0, 72),
                (15, 0, 72), (23, 0, 72), (32, 0, 72), (41, 0, 72), (1, 0, 144), (1, 0, 8), (1, 0, 200), (1, 0, 144),
                (1, 0, 144), (1, 0, 144), (1, 0, 144), (1, 0, 80), (1, 0, 80), (1, 0, 80), (1, 0, 136), (1, 0, 144),
                (1, 0, 80), (1, 0, 136), (1, 0, 200), (1, 0, 136), (1, 0, 216), (1, 0, 144), (1, 0, 144), (1, 0, 200),
                (1, 0, 136), (1, 0, 152), (1, 0, 88), (1, 0, 144), (1, 0, 200), (1, 0, 136), (1, 0, 72), (1, 0, 208),
                (1, 0, 136), (1, 0, 136), (1, 0, 72), (1, 0, 136), (1, 0, 80), (1, 0, 136), (1, 0, 136), (1, 0, 136),
                (1, 0, 8), (1, 0, 72), (1, 0, 72), (1, 0, 72), (1, 0, 8), (1, 0, 72), (1, 0, 80), (1, 0, 80),
                (1, 0, 72), (1, 0, 144), (1, 0, 208), (1, 0, 216), (1, 0, 8), (1, 0, 80), (1, 0, 200), (1, 0, 144),
                (1, 0, 88), (1, 0, 136), (1, 0, 136), (1, 0, 8), (1, 0, 200), (1, 0, 72), (1, 0, 144), (1, 0, 8),
                (1, 0, 200), (1, 0, 88), (1, 0, 72), (1, 0, 152), (1, 0, 216), (1, 0, 152), (1, 0, 208), (1, 0, 136),
                (1, 0, 80), (1, 0, 8), (1, 0, 72), (1, 0, 200), (1, 0, 144), (1, 0, 152), (1, 0, 200), (1, 0, 216),
                (1, 0, 216), (1, 0, 8), (1, 0, 8), (1, 0, 144), (1, 0, 8), (1, 144, 200), (1, 0, 80), (1, 0, 208),
                (1, 0, 208), (1, 0, 16), (1, 0, 144), (1, 0, 72), (1, 0, 136), (1, 0, 136), (1, 0, 80), (1, 0, 200),
                (1, 0, 136), (1, 0, 136), (1, 0, 200), (1, 0, 136), (1, 0, 88), (1, 0, 80), (1, 0, 72), (1, 0, 136),
                (1, 0, 200), (1, 0, 136), (1, 0, 144), (1, 0, 136), (1, 0, 80), (1, 0, 136), (1, 0, 72), (1, 0, 72),
                (1, 0, 72), (1, 0, 136), (1, 0, 72), (1, 0, 136), (1, 0, 200), (1, 0, 136), (1, 0, 200), (1, 0, 200),
                (1, 0, 200), (1, 0, 72), (1, 0, 80), (1, 0, 152), (1, 0, 8), (1, 0, 8), (1, 0, 136), (1, 0, 136),
                (1, 0, 200), (1, 0, 200), (1, 0, 144), (1, 16, 216), (1, 16, 216), (1, 208, 216), (1, 80, 216),
                (1, 144, 216), (1, 208, 216), (1, 16, 216), (1, 80, 88), (1, 208, 88), (1, 144, 88), (1, 80, 88),
                (1, 208, 88), (1, 144, 216), (1, 80, 216), (1, 16, 216), (1, 80, 216), (1, 144, 216), (1, 208, 152),
                (1, 16, 152), (1, 80, 216), (1, 16, 216), (1, 208, 216), (1, 144, 216), (1, 144, 216), (1, 0, 80),
                (1, 0, 136), (1, 0, 72), (1, 0, 136), (1, 0, 8), (1, 0, 16), (1, 0, 200), (1, 0, 200), (1, 0, 144),
                (1, 0, 200), (1, 0, 136), (1, 0, 136), (1, 0, 72), (1, 0, 144), (1, 0, 152), (1, 0, 200), (1, 0, 152),
                (1, 0, 8), (1, 0, 216), (1, 0, 136), (1, 0, 136), (1, 0, 144), (1, 0, 136), (1, 0, 88), (1, 0, 208),
                (1, 0, 8), (1, 0, 208), (1, 0, 16), (1, 0, 16), (1, 0, 208), (1, 0, 208), (1, 0, 208), (1, 0, 136),
                (1, 0, 144), (1, 0, 152), (1, 0, 136), (1, 0, 72), (0, 13, 0), (0, 13, 0), (0, 13, 0), (0, 13, 0),
                (0, 13, 0), (0, 13, 0), (0, 13, 0), (0, 13, 0), (0, 13, 0), (0, 13, 0), (94, 0, 200), (94, 0, 200),
                (94, 0, 200), (94, 0, 200), (94, 0, 200), (94, 0, 200), (111, 0, 88), (111, 0, 88), (111, 0, 88),
                (1, 0, 144), (0, 210, 0), (0, 18, 0), (0, 82, 0), (0, 146, 0), (0, 210, 0), (0, 18, 0), (0, 82, 0),
                (0, 146, 0), (0, 210, 0), (0, 18, 0), (0, 82, 0), (0, 146, 0), (0, 210, 0), (0, 18, 0), (0, 82, 0),
                (0, 146, 0), (0, 210, 0), (0, 18, 0), (0, 82, 0), (0, 146, 0), (0, 210, 0), (0, 18, 0), (0, 82, 0),
                (0, 13, 0), (3, 0, 72), (15, 0, 72), (23, 0, 72), (32, 0, 72), (41, 0, 72), (0, 26, 32), (0, 26, 32),
                (0, 26, 32), (0, 26, 96), (0, 26, 96), (0, 26, 96), (0, 26, 160), (0, 26, 160), (0, 26, 160),
                (0, 2, 224), (0, 2, 224), (0, 2, 224), (150, 10, 0), (0, 0, 136), (152, 10, 0), (154, 10, 0),
                (0, 0, 136), (158, 10, 0), (0, 10, 0), (150, 0, 72), (152, 0, 72), (154, 0, 72), (158, 0, 72),
                (0, 10, 0), (0, 10, 0), (0, 10, 0), (0, 10, 0), (0, 10, 0), (0, 10, 0), (0, 10, 0), (0, 10, 0),
                (0, 10, 0), (0, 12, 0), (0, 12, 0), (0, 12, 0), (156, 12, 0), (0, 12, 0), (0, 12, 0), (0, 12, 0),
                (0, 12, 0), (0, 12, 0), (0, 12, 0), (0, 0, 0), (0, 0, 0)]

# Does not include first 6 formations (i.e. formation_types[0] = ffta_data.formations[6].formation_type)
formation_types = [20, 21, 22, 23, 24, 25, 26, 56, 15, 16, 17, 76, 23, 1, 1, 8, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 12, 1, 1, 1, 1, 1, 32,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 10, 1, 1, 1, 1, 1, 30, 57, 58, 59,
                   60, 61, 62, 63, 1, 1, 1, 1, 1, 1, 1, 9, 1, 1, 1, 1, 1, 29, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 12, 1,
                   1, 1, 1, 1, 1, 1, 9, 31, 64, 65, 66, 67, 68, 69, 70, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 13, 1, 1, 1, 1, 28, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 13, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 4, 12, 1, 1, 1, 1, 13, 1, 1, 1, 1, 1, 9, 14, 72, 73, 81, 71, 71,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 28, 29, 32,
                   30, 1, 9, 10, 13, 14, 1, 1, 81, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 82, 82, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 12, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 84, 84, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   4, 12, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 83, 83, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 83,
                   83, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 81, 81, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 81, 81, 1, 1, 1,
                   1, 1, 1, 1, 1, 81, 81, 1, 1, 1, 1, 1, 1, 1, 1, 81, 81, 1, 1, 1,
                   1, 1, 1, 1, 1, 81, 81, 1, 1, 1, 1, 1, 1, 1, 1, 81, 81, 81, 1, 1,
                   1, 81, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 6, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 2, 6, 8,
                   14, 15, 16, 17, 18, 19, 20, 21, 24, 2, 6, 8, 26, 25, 56, 76, 27, 23, 28, 71,
                   29, 2, 6, 8, 72, 30, 31, 32, 73, 36, 45, 48, 49, 2, 6, 1, 50, 51, 52, 53,
                   54, 55, 74, 75, 2, 6, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 6, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 6, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 2, 6, 8, 1, 1, 1, 1, 1, 1, 1, 2, 6, 8, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 2, 6, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
                   6, 8, 1, 1, 1, 1, 1, 1, 1, 1, 2, 6, 8, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 2, 6, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 6, 8, 1,
                   1, 1, 1, 1, 1, 1, 1, 2, 6, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   2, 6, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 6, 8, 1, 1, 1, 1,
                   1, 1, 1, 1, 2, 6, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 6, 8,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 6, 8, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 2, 6, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 6, 8, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 6, 8, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 2, 6, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 6, 8, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 2, 6, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 2, 6, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 6, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 10, 9, 4, 12, 13,
                   4, 12, 13, 10, 9, 1, 1, 1, 1, 1, 91, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 1, 1, 1, 1, 1, 92, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                   1, 1, 90, 91, 92, 1, 1, 1, 1, 1, 10, 14, 1, 1, 9, 1, 1, 1, 4, 1,
                   1, 1, 1, 1]

human_abilities = [[221, 0, 147, 0, 76, 0, 1, 10], [130, 1, 56, 1, 77, 0, 1, 20], [193, 1, 119, 1, 78, 0, 1, 20],
                   [195, 1, 121, 1, 79, 0, 1, 20], [56, 1, 238, 0, 80, 0, 1, 20], [251, 0, 177, 0, 81, 0, 1, 30],
                   [86, 1, 12, 1, 82, 0, 1, 30],
                   [206, 1, 132, 1, 83, 0, 1, 30], [237, 0, 163, 0, 6, 0, 3, 30], [78, 1, 4, 1, 15, 0, 3, 30],
                   [47, 2, 238, 1, 1, 0, 5, 10], [231, 0, 157, 0, 87, 0, 1, 10], [202, 1, 128, 1, 94, 0, 1, 20],
                   [239, 0, 165, 0, 88, 0, 1, 20], [90, 1, 16, 1, 90, 0, 1, 20], [155, 1, 81, 1, 95, 0, 1, 20],
                   [17, 1, 199, 0, 91, 0, 1, 20], [66, 1, 248, 0, 92, 0, 1, 30], [186, 1, 112, 1, 93, 0, 1, 30],
                   [204, 1, 130, 1, 5, 0, 2, 30], [181, 1, 107, 1, 2, 0, 3, 30], [34, 2, 225, 1, 2, 0, 5, 10],
                   [228, 1, 154, 1, 112, 0, 1, 10], [250, 1, 176, 1, 113, 0, 1, 20], [150, 1, 76, 1, 114, 0, 1, 20],
                   [166, 1, 92, 1, 115, 0, 1, 20], [3, 1, 185, 0, 108, 0, 1, 20], [127, 1, 53, 1, 109, 0, 1, 20],
                   [214, 0, 140, 0, 110, 0, 1, 30], [126, 1, 52, 1, 111, 0, 1, 30], [112, 1, 38, 1, 10, 0, 2, 30],
                   [128, 1, 54, 1, 7, 0, 2, 30], [239, 1, 165, 1, 7, 0, 3, 30], [51, 2, 242, 1, 3, 0, 5, 10],
                   [223, 1, 149, 1, 163, 0, 1, 30], [79, 1, 5, 1, 164, 0, 1, 20], [187, 0, 113, 0, 165, 0, 1, 30],
                   [240, 0, 166, 0, 166, 0, 1, 30], [153, 1, 79, 1, 167, 0, 1, 30], [252, 0, 178, 0, 168, 0, 1, 10],
                   [14, 1, 196, 0, 169, 0, 1, 10], [9, 1, 191, 0, 170, 0, 1, 20], [195, 0, 121, 0, 171, 0, 1, 30],
                   [232, 0, 158, 0, 8, 0, 2, 30], [212, 1, 138, 1, 9, 0, 3, 30], [39, 2, 230, 1, 23, 0, 5, 10],
                   [111, 1, 37, 1, 148, 0, 1, 10], [213, 1, 139, 1, 149, 0, 1, 20], [238, 0, 164, 0, 150, 0, 1, 20],
                   [100, 1, 26, 1, 151, 0, 1, 20], [254, 0, 180, 0, 152, 0, 1, 20], [50, 1, 232, 0, 153, 0, 1, 20],
                   [230, 0, 156, 0, 154, 0, 1, 30], [180, 1, 106, 1, 155, 0, 1, 30], [141, 1, 67, 1, 2, 0, 2, 30],
                   [114, 1, 40, 1, 8, 0, 3, 100], [56, 2, 247, 1, 15, 0, 5, 10], [11, 1, 193, 0, 1, 0, 1, 10],
                   [13, 1, 195, 0, 2, 0, 1, 20], [12, 1, 194, 0, 3, 0, 1, 30], [218, 0, 144, 0, 4, 0, 1, 20],
                   [241, 1, 167, 1, 5, 0, 1, 20], [201, 0, 127, 0, 6, 0, 1, 30], [240, 1, 166, 1, 7, 0, 1, 20],
                   [36, 1, 218, 0, 8, 0, 1, 10], [173, 1, 99, 1, 9, 0, 1, 10], [180, 0, 106, 0, 4, 0, 3, 30],
                   [45, 2, 236, 1, 8, 0, 5, 10], [142, 1, 68, 1, 23, 0, 1, 10], [147, 1, 73, 1, 24, 0, 1, 20],
                   [146, 1, 72, 1, 25, 0, 1, 30], [29, 1, 211, 0, 26, 0, 1, 10], [33, 1, 215, 0, 27, 0, 1, 20],
                   [32, 1, 214, 0, 28, 0, 1, 30], [163, 1, 89, 1, 29, 0, 1, 10], [165, 1, 91, 1, 30, 0, 1, 20],
                   [162, 1, 88, 1, 31, 0, 1, 30], [200, 1, 126, 1, 11, 0, 2, 30], [73, 1, 255, 0, 5, 0, 3, 30],
                   [36, 2, 227, 1, 9, 0, 5, 10], [175, 1, 101, 1, 43, 0, 1, 10], [94, 1, 20, 1, 44, 0, 1, 10],
                   [161, 1, 87, 1, 45, 0, 1, 10], [27, 1, 209, 0, 46, 0, 1, 30], [51, 1, 233, 0, 47, 0, 1, 30],
                   [249, 1, 175, 1, 48, 0, 1, 20], [69, 1, 251, 0, 49, 0, 1, 20], [76, 1, 2, 1, 50, 0, 1, 20],
                   [45, 1, 227, 0, 15, 0, 2, 30], [47, 1, 229, 0, 10, 0, 3, 30], [49, 2, 240, 1, 16, 0, 5, 10],
                   [19, 1, 201, 0, 10, 1, 1, 10], [194, 1, 120, 1, 11, 1, 1, 10], [220, 1, 146, 1, 13, 1, 1, 10],
                   [41, 1, 223, 0, 15, 1, 1, 10], [192, 1, 118, 1, 18, 1, 1, 10], [227, 0, 153, 0, 19, 1, 1, 10],
                   [104, 1, 30, 1, 20, 1, 1, 10], [222, 1, 148, 1, 21, 1, 1, 10], [89, 1, 15, 1, 22, 1, 1, 10],
                   [244, 1, 170, 1, 26, 1, 1, 10], [199, 1, 125, 1, 32, 1, 1, 10], [235, 1, 161, 1, 31, 1, 0, 10],
                   [182, 1, 108, 1, 34, 1, 0, 10], [99, 1, 25, 1, 37, 1, 1, 10], [177, 1, 103, 1, 38, 1, 1, 10],
                   [4, 1, 186, 0, 41, 1, 1, 10], [115, 1, 41, 1, 44, 1, 1, 10], [40, 1, 222, 0, 45, 1, 1, 10],
                   [106, 1, 32, 1, 48, 1, 1, 10], [243, 1, 169, 1, 49, 1, 1, 10], [189, 1, 115, 1, 52, 1, 1, 10],
                   [93, 1, 19, 1, 53, 1, 1, 10], [179, 0, 105, 0, 13, 0, 2, 30], [211, 1, 137, 1, 11, 0, 3, 30],
                   [224, 1, 150, 1, 12, 0, 3, 40], [31, 2, 222, 1, 10, 0, 5, 10], [80, 1, 6, 1, 172, 0, 1, 10],
                   [191, 0, 117, 0, 173, 0, 1, 20], [212, 0, 138, 0, 174, 0, 1, 20], [120, 1, 46, 1, 175, 0, 1, 20],
                   [154, 1, 80, 1, 176, 0, 1, 30], [118, 1, 44, 1, 177, 0, 1, 30], [148, 1, 74, 1, 178, 0, 1, 30],
                   [160, 1, 86, 1, 179, 0, 1, 20], [216, 1, 142, 1, 6, 0, 2, 30], [64, 1, 246, 0, 13, 0, 3, 30],
                   [58, 2, 249, 1, 26, 0, 5, 10], [75, 1, 1, 1, 180, 0, 1, 20], [220, 0, 146, 0, 181, 0, 1, 20],
                   [48, 1, 230, 0, 182, 0, 1, 10], [247, 0, 173, 0, 183, 0, 1, 30], [134, 1, 60, 1, 184, 0, 1, 30],
                   [233, 0, 159, 0, 185, 0, 1, 20], [198, 0, 124, 0, 186, 0, 1, 100], [23, 1, 205, 0, 187, 0, 1, 30],
                   [204, 0, 130, 0, 188, 0, 1, 20], [233, 1, 159, 1, 14, 0, 2, 30], [16, 1, 198, 0, 1, 0, 3, 30],
                   [33, 2, 224, 1, 19, 0, 5, 10]]

bangaa_abilities = [[221, 0, 147, 0, 76, 0, 1, 10], [130, 1, 56, 1, 77, 0, 1, 20], [193, 1, 119, 1, 78, 0, 1, 20],
                    [195, 1, 121, 1, 79, 0, 1, 20],
                    [56, 1, 238, 0, 80, 0, 1, 20], [242, 0, 168, 0, 84, 0, 1, 30], [38, 1, 220, 0, 85, 0, 1, 30],
                    [225, 1, 151, 1, 86, 0, 1, 30],
                    [237, 0, 163, 0, 6, 0, 3, 30], [78, 1, 4, 1, 15, 0, 3, 30], [47, 2, 238, 1, 1, 0, 5, 10],
                    [43, 1, 225, 0, 124, 0, 1, 10],
                    [236, 1, 162, 1, 125, 0, 1, 30], [237, 1, 163, 1, 126, 0, 1, 20], [145, 1, 71, 1, 127, 0, 1, 30],
                    [31, 1, 213, 0, 128, 0, 1, 30],
                    [183, 0, 109, 0, 129, 0, 1, 30], [103, 1, 29, 1, 130, 0, 1, 30], [131, 1, 57, 1, 131, 0, 1, 20],
                    [238, 1, 164, 1, 12, 0, 2, 30],
                    [62, 2, 253, 1, 4, 0, 5, 10], [124, 1, 50, 1, 96, 0, 1, 10], [232, 1, 158, 1, 101, 0, 1, 20],
                    [202, 1, 128, 1, 94, 0, 1, 20],
                    [155, 1, 81, 1, 95, 0, 1, 20], [95, 1, 21, 1, 97, 0, 1, 10], [110, 1, 36, 1, 98, 0, 1, 20],
                    [222, 0, 148, 0, 99, 0, 1, 30],
                    [121, 1, 47, 1, 100, 0, 1, 30], [140, 1, 66, 1, 3, 0, 2, 30], [181, 1, 107, 1, 2, 0, 3, 30],
                    [43, 2, 234, 1, 20, 0, 5, 10],
                    [228, 1, 154, 1, 112, 0, 1, 10], [250, 1, 176, 1, 113, 0, 1, 20], [150, 1, 76, 1, 114, 0, 1, 20],
                    [166, 1, 92, 1, 115, 0, 1, 20],
                    [144, 1, 70, 1, 116, 0, 1, 20], [30, 1, 212, 0, 117, 0, 1, 20], [164, 1, 90, 1, 118, 0, 1, 20],
                    [199, 0, 125, 0, 119, 0, 1, 100],
                    [128, 1, 54, 1, 7, 0, 2, 30], [239, 1, 165, 1, 7, 0, 3, 30], [59, 2, 250, 1, 7, 0, 5, 10],
                    [213, 0, 139, 0, 102, 0, 1, 10],
                    [3, 1, 185, 0, 108, 0, 1, 20], [88, 1, 14, 1, 103, 0, 1, 20], [127, 1, 53, 1, 109, 0, 1, 20],
                    [85, 1, 11, 1, 104, 0, 1, 20],
                    [74, 1, 0, 1, 105, 0, 1, 30], [125, 1, 51, 1, 106, 0, 1, 30], [63, 1, 245, 0, 107, 0, 1, 20],
                    [204, 1, 130, 1, 5, 0, 2, 30],
                    [232, 0, 158, 0, 8, 0, 2, 30], [61, 2, 252, 1, 21, 0, 5, 10], [13, 1, 195, 0, 2, 0, 1, 20],
                    [92, 1, 18, 1, 10, 0, 1, 20],
                    [185, 1, 111, 1, 11, 0, 1, 30], [129, 1, 55, 1, 12, 0, 1, 30], [44, 1, 226, 0, 13, 0, 1, 30],
                    [210, 0, 136, 0, 15, 0, 1, 20],
                    [215, 0, 141, 0, 16, 0, 1, 20], [170, 1, 96, 1, 14, 0, 1, 20], [200, 1, 126, 1, 11, 0, 2, 30],
                    [47, 1, 229, 0, 10, 0, 3, 30],
                    [35, 2, 226, 1, 22, 0, 5, 10], [192, 0, 118, 0, 59, 0, 1, 20], [224, 0, 150, 0, 120, 0, 1, 30],
                    [227, 1, 153, 1, 60, 0, 1, 10],
                    [253, 0, 179, 0, 121, 0, 1, 10], [25, 1, 207, 0, 41, 0, 1, 20], [71, 1, 253, 0, 122, 0, 1, 30],
                    [176, 1, 102, 1, 42, 0, 1, 20],
                    [226, 1, 152, 1, 123, 0, 1, 30], [112, 1, 38, 1, 10, 0, 2, 30], [16, 1, 198, 0, 1, 0, 3, 30],
                    [38, 2, 229, 1, 5, 0, 5, 10]]

nu_mou_abilities = [[11, 1, 193, 0, 1, 0, 1, 10], [13, 1, 195, 0, 2, 0, 1, 20], [12, 1, 194, 0, 3, 0, 1, 30],
                    [218, 0, 144, 0, 4, 0, 1, 20],
                    [241, 1, 167, 1, 5, 0, 1, 20], [201, 0, 127, 0, 6, 0, 1, 30], [240, 1, 166, 1, 7, 0, 1, 20],
                    [36, 1, 218, 0, 8, 0, 1, 10],
                    [173, 1, 99, 1, 9, 0, 1, 10], [180, 0, 106, 0, 4, 0, 3, 30], [45, 2, 236, 1, 8, 0, 5, 10],
                    [142, 1, 68, 1, 23, 0, 1, 10],
                    [147, 1, 73, 1, 24, 0, 1, 20], [146, 1, 72, 1, 25, 0, 1, 30], [29, 1, 211, 0, 26, 0, 1, 10],
                    [33, 1, 215, 0, 27, 0, 1, 20],
                    [32, 1, 214, 0, 28, 0, 1, 30], [163, 1, 89, 1, 29, 0, 1, 10], [165, 1, 91, 1, 30, 0, 1, 20],
                    [162, 1, 88, 1, 31, 0, 1, 30],
                    [200, 1, 126, 1, 11, 0, 2, 30], [73, 1, 255, 0, 5, 0, 3, 30], [36, 2, 227, 1, 9, 0, 5, 10],
                    [176, 1, 102, 1, 42, 0, 1, 20],
                    [2, 1, 184, 0, 34, 0, 1, 30], [61, 1, 243, 0, 35, 0, 1, 20], [234, 1, 160, 1, 36, 0, 1, 30],
                    [53, 1, 235, 0, 38, 0, 1, 30],
                    [25, 1, 207, 0, 41, 0, 1, 20], [7, 1, 189, 0, 39, 0, 1, 20], [6, 1, 188, 0, 40, 0, 1, 30],
                    [139, 1, 65, 1, 1, 0, 2, 30],
                    [53, 2, 244, 1, 12, 0, 5, 10], [175, 1, 101, 1, 43, 0, 1, 10], [94, 1, 20, 1, 44, 0, 1, 10],
                    [161, 1, 87, 1, 45, 0, 1, 10],
                    [27, 1, 209, 0, 46, 0, 1, 30], [51, 1, 233, 0, 47, 0, 1, 30], [249, 1, 175, 1, 48, 0, 1, 20],
                    [69, 1, 251, 0, 49, 0, 1, 20],
                    [76, 1, 2, 1, 50, 0, 1, 20], [45, 1, 227, 0, 15, 0, 2, 30], [47, 1, 229, 0, 10, 0, 3, 30],
                    [49, 2, 240, 1, 16, 0, 5, 10],
                    [192, 0, 118, 0, 59, 0, 1, 20], [91, 1, 17, 1, 61, 0, 1, 20], [210, 1, 136, 1, 62, 0, 1, 30],
                    [227, 1, 153, 1, 60, 0, 1, 10],
                    [169, 1, 95, 1, 63, 0, 1, 30], [179, 1, 105, 1, 64, 0, 1, 10], [96, 1, 22, 1, 65, 0, 1, 20],
                    [184, 0, 110, 0, 67, 0, 0, 10],
                    [201, 1, 127, 1, 3, 0, 3, 30], [212, 1, 138, 1, 9, 0, 3, 30], [63, 2, 254, 1, 18, 0, 5, 10],
                    [18, 1, 200, 0, 189, 0, 1, 20],
                    [167, 1, 93, 1, 190, 0, 1, 20], [188, 1, 114, 1, 191, 0, 1, 20], [102, 1, 28, 1, 192, 0, 1, 20],
                    [229, 1, 155, 1, 193, 0, 1, 20],
                    [20, 1, 202, 0, 194, 0, 1, 20], [107, 1, 33, 1, 195, 0, 1, 20], [132, 1, 58, 1, 196, 0, 1, 20],
                    [214, 1, 140, 1, 197, 0, 1, 20],
                    [172, 1, 98, 1, 198, 0, 1, 20], [202, 0, 128, 0, 199, 0, 1, 20], [221, 1, 147, 1, 200, 0, 1, 20],
                    [207, 0, 133, 0, 201, 0, 1, 20],
                    [141, 1, 67, 1, 2, 0, 2, 30], [211, 1, 137, 1, 11, 0, 3, 30], [60, 2, 251, 1, 28, 0, 5, 10],
                    [18, 1, 204, 1, 202, 0, 1, 20],
                    [167, 1, 205, 1, 203, 0, 1, 20], [188, 1, 206, 1, 204, 0, 1, 20], [102, 1, 207, 1, 205, 0, 1, 20],
                    [229, 1, 208, 1, 206, 0, 1, 20],
                    [20, 1, 209, 1, 207, 0, 1, 20], [132, 1, 210, 1, 208, 0, 1, 20], [214, 1, 211, 1, 209, 0, 1, 20],
                    [172, 1, 212, 1, 210, 0, 1, 20],
                    [179, 0, 105, 0, 13, 0, 2, 30], [55, 2, 246, 1, 29, 0, 5, 10], [105, 1, 31, 1, 17, 0, 1, 10],
                    [157, 1, 83, 1, 18, 0, 1, 10],
                    [210, 0, 136, 0, 15, 0, 1, 20], [215, 0, 141, 0, 16, 0, 1, 20], [203, 1, 129, 1, 19, 0, 1, 30],
                    [245, 0, 171, 0, 20, 0, 1, 30],
                    [122, 1, 48, 1, 21, 0, 1, 30], [200, 0, 126, 0, 22, 0, 1, 100], [204, 1, 130, 1, 5, 0, 2, 30],
                    [181, 1, 107, 1, 2, 0, 3, 30],
                    [78, 1, 4, 1, 15, 0, 3, 30], [37, 2, 228, 1, 17, 0, 5, 10]]

viera_abilities = [[77, 1, 3, 1, 140, 0, 1, 10], [52, 1, 234, 0, 141, 0, 1, 20], [82, 1, 8, 1, 142, 0, 1, 30],
                   [58, 1, 240, 0, 143, 0, 1, 20],
                   [62, 1, 244, 0, 144, 0, 1, 30], [168, 1, 94, 1, 145, 0, 1, 30], [119, 1, 45, 1, 146, 0, 1, 20],
                   [108, 1, 34, 1, 147, 0, 1, 20],
                   [204, 1, 130, 1, 5, 0, 2, 30], [78, 1, 4, 1, 15, 0, 3, 30], [54, 2, 245, 1, 6, 0, 5, 10],
                   [143, 1, 69, 1, 51, 0, 1, 10],
                   [181, 0, 107, 0, 52, 0, 1, 20], [190, 1, 116, 1, 53, 0, 1, 10], [42, 1, 224, 0, 54, 0, 1, 20],
                   [15, 1, 197, 0, 55, 0, 1, 30],
                   [178, 1, 104, 1, 56, 0, 1, 20], [59, 1, 241, 0, 57, 0, 1, 20], [174, 1, 100, 1, 58, 0, 1, 30],
                   [45, 1, 227, 0, 15, 0, 2, 30],
                   [46, 2, 237, 1, 14, 0, 5, 10], [129, 1, 55, 1, 12, 0, 1, 30], [142, 1, 68, 1, 23, 0, 1, 10],
                   [29, 1, 211, 0, 26, 0, 1, 10],
                   [163, 1, 89, 1, 29, 0, 1, 10], [11, 1, 193, 0, 1, 0, 1, 10], [60, 1, 242, 0, 32, 0, 1, 20],
                   [179, 1, 105, 1, 64, 0, 1, 10],
                   [248, 1, 174, 1, 33, 0, 1, 100], [246, 0, 172, 0, 4, 0, 2, 30], [201, 1, 127, 1, 3, 0, 3, 30],
                   [32, 2, 223, 1, 11, 0, 5, 10],
                   [11, 1, 193, 0, 1, 0, 1, 10], [13, 1, 195, 0, 2, 0, 1, 20], [12, 1, 194, 0, 3, 0, 1, 30],
                   [218, 0, 144, 0, 4, 0, 1, 20],
                   [241, 1, 167, 1, 5, 0, 1, 20], [201, 0, 127, 0, 6, 0, 1, 30], [240, 1, 166, 1, 7, 0, 1, 20],
                   [36, 1, 218, 0, 8, 0, 1, 10],
                   [173, 1, 99, 1, 9, 0, 1, 10], [180, 0, 106, 0, 4, 0, 3, 30], [45, 2, 236, 1, 8, 0, 5, 10],
                   [219, 1, 145, 1, 68, 0, 1, 20],
                   [206, 0, 132, 0, 69, 0, 1, 20], [230, 1, 156, 1, 70, 0, 1, 20], [35, 1, 217, 0, 71, 0, 1, 20],
                   [249, 0, 175, 0, 72, 0, 1, 20],
                   [228, 0, 154, 0, 73, 0, 1, 30], [151, 1, 77, 1, 74, 0, 1, 30], [198, 1, 124, 1, 75, 0, 1, 30],
                   [47, 1, 229, 0, 10, 0, 3, 30],
                   [44, 2, 235, 1, 13, 0, 5, 10], [80, 1, 6, 1, 172, 0, 1, 10], [191, 0, 117, 0, 173, 0, 1, 20],
                   [212, 0, 138, 0, 174, 0, 1, 20],
                   [120, 1, 46, 1, 175, 0, 1, 20], [154, 1, 80, 1, 176, 0, 1, 30], [118, 1, 44, 1, 177, 0, 1, 30],
                   [148, 1, 74, 1, 178, 0, 1, 30],
                   [160, 1, 86, 1, 179, 0, 1, 20], [216, 1, 142, 1, 6, 0, 2, 30], [64, 1, 246, 0, 13, 0, 3, 30],
                   [58, 2, 249, 1, 26, 0, 5, 10],
                   [236, 0, 162, 0, 156, 0, 1, 20], [72, 1, 254, 0, 157, 0, 1, 30], [37, 1, 219, 0, 158, 0, 1, 20],
                   [190, 0, 116, 0, 159, 0, 1, 30],
                   [223, 0, 149, 0, 160, 0, 1, 20], [149, 1, 75, 1, 161, 0, 1, 30], [180, 1, 106, 1, 155, 0, 1, 30],
                   [197, 0, 123, 0, 162, 0, 1, 100],
                   [215, 1, 141, 1, 9, 0, 2, 30], [40, 2, 231, 1, 24, 0, 5, 10], [247, 1, 173, 1, 223, 0, 1, 30],
                   [191, 1, 117, 1, 219, 0, 1, 20],
                   [193, 0, 119, 0, 220, 0, 1, 30], [67, 1, 249, 0, 221, 0, 1, 10], [197, 1, 123, 1, 222, 0, 1, 30],
                   [182, 0, 108, 0, 224, 0, 1, 30],
                   [209, 0, 135, 0, 225, 0, 1, 30], [24, 1, 206, 0, 226, 0, 1, 20], [233, 1, 159, 1, 14, 0, 2, 30],
                   [48, 2, 239, 1, 25, 0, 5, 10]]

moogle_abilities = [[137, 1, 63, 1, 227, 0, 1, 10], [208, 0, 134, 0, 228, 0, 1, 20], [28, 1, 210, 0, 229, 0, 1, 30],
                    [39, 1, 221, 0, 230, 0, 1, 20],
                    [87, 1, 13, 1, 231, 0, 1, 30], [234, 0, 160, 0, 232, 0, 1, 20], [101, 1, 27, 1, 233, 0, 1, 30],
                    [196, 1, 122, 1, 234, 0, 1, 10],
                    [216, 1, 142, 1, 6, 0, 2, 30], [52, 2, 243, 1, 30, 0, 5, 10], [194, 0, 120, 0, 132, 0, 1, 10],
                    [226, 0, 152, 0, 133, 0, 1, 20],
                    [49, 1, 231, 0, 134, 0, 1, 20], [188, 0, 114, 0, 135, 0, 1, 20], [242, 1, 168, 1, 136, 0, 1, 30],
                    [81, 1, 7, 1, 137, 0, 1, 30],
                    [136, 1, 62, 1, 138, 0, 1, 30], [196, 0, 122, 0, 139, 0, 1, 100], [141, 1, 67, 1, 2, 0, 2, 30],
                    [78, 1, 4, 1, 15, 0, 3, 30],
                    [50, 2, 241, 1, 31, 0, 5, 10], [203, 0, 129, 0, 235, 0, 1, 10], [231, 1, 157, 1, 236, 0, 1, 10],
                    [243, 0, 169, 0, 237, 0, 1, 10],
                    [21, 1, 203, 0, 238, 0, 1, 20], [84, 1, 10, 1, 239, 0, 1, 30], [158, 1, 84, 1, 240, 0, 1, 10],
                    [26, 1, 208, 0, 241, 0, 1, 20],
                    [54, 1, 236, 0, 242, 0, 1, 30], [64, 1, 246, 0, 13, 0, 3, 30], [42, 2, 233, 1, 27, 0, 5, 10],
                    [223, 1, 149, 1, 163, 0, 1, 30],
                    [79, 1, 5, 1, 164, 0, 1, 20], [187, 0, 113, 0, 165, 0, 1, 30], [240, 0, 166, 0, 166, 0, 1, 30],
                    [153, 1, 79, 1, 167, 0, 1, 30],
                    [252, 0, 178, 0, 168, 0, 1, 10], [14, 1, 196, 0, 169, 0, 1, 10], [9, 1, 191, 0, 170, 0, 1, 20],
                    [195, 0, 121, 0, 171, 0, 1, 30],
                    [232, 0, 158, 0, 8, 0, 2, 30], [212, 1, 138, 1, 9, 0, 3, 30], [39, 2, 230, 1, 23, 0, 5, 10],
                    [183, 1, 109, 1, 211, 0, 1, 10],
                    [251, 1, 177, 1, 212, 0, 1, 20], [235, 0, 161, 0, 213, 0, 1, 30], [187, 1, 113, 1, 214, 0, 1, 20],
                    [109, 1, 35, 1, 215, 0, 1, 30],
                    [57, 1, 239, 0, 216, 0, 1, 30], [250, 0, 176, 0, 217, 0, 1, 10], [8, 1, 190, 0, 218, 0, 0, 20],
                    [246, 0, 172, 0, 4, 0, 2, 30],
                    [215, 1, 141, 1, 9, 0, 2, 30], [41, 2, 232, 1, 32, 0, 5, 10], [186, 0, 112, 0, 243, 0, 1, 20],
                    [185, 0, 111, 0, 244, 0, 1, 20],
                    [205, 1, 131, 1, 245, 0, 1, 20], [255, 0, 181, 0, 246, 0, 1, 20], [0, 1, 182, 0, 247, 0, 1, 20],
                    [10, 1, 192, 0, 248, 0, 1, 20],
                    [113, 1, 39, 1, 249, 0, 1, 20], [244, 0, 170, 0, 250, 0, 1, 20], [233, 1, 159, 1, 14, 0, 2, 30],
                    [179, 0, 105, 0, 13, 0, 2, 30],
                    [57, 2, 248, 1, 33, 0, 5, 10], [142, 1, 68, 1, 23, 0, 1, 10], [147, 1, 73, 1, 24, 0, 1, 20],
                    [146, 1, 72, 1, 25, 0, 1, 30],
                    [29, 1, 211, 0, 26, 0, 1, 10], [33, 1, 215, 0, 27, 0, 1, 20], [32, 1, 214, 0, 28, 0, 1, 30],
                    [163, 1, 89, 1, 29, 0, 1, 10],
                    [165, 1, 91, 1, 30, 0, 1, 20], [162, 1, 88, 1, 31, 0, 1, 30], [200, 1, 126, 1, 11, 0, 2, 30],
                    [73, 1, 255, 0, 5, 0, 3, 30],
                    [36, 2, 227, 1, 9, 0, 5, 10], [176, 1, 102, 1, 42, 0, 1, 20], [2, 1, 184, 0, 34, 0, 1, 30],
                    [61, 1, 243, 0, 35, 0, 1, 20],
                    [234, 1, 160, 1, 36, 0, 1, 30], [53, 1, 235, 0, 38, 0, 1, 30], [25, 1, 207, 0, 41, 0, 1, 20],
                    [7, 1, 189, 0, 39, 0, 1, 20],
                    [6, 1, 188, 0, 40, 0, 1, 30], [139, 1, 65, 1, 1, 0, 2, 30], [53, 2, 244, 1, 12, 0, 5, 10]]

monster_abilities = [[19, 1, 201, 0, 10, 1, 1, 10], [232, 0, 158, 0, 8, 0, 2, 30], [181, 1, 107, 1, 2, 0, 3, 30],
                     [194, 1, 120, 1, 11, 1, 1, 10], [207, 1, 133, 1, 12, 1, 1, 10], [216, 1, 142, 1, 6, 0, 2, 30],
                     [16, 1, 198, 0, 1, 0, 3, 30],
                     [220, 1, 146, 1, 13, 1, 1, 10], [218, 1, 144, 1, 14, 1, 1, 10], [142, 1, 68, 1, 23, 0, 4, 10],
                     [147, 1, 73, 1, 24, 0, 4, 20], [146, 1, 72, 1, 25, 0, 4, 30], [232, 0, 158, 0, 8, 0, 2, 30],
                     [181, 1, 107, 1, 2, 0, 3, 30],
                     [220, 1, 146, 1, 13, 1, 1, 10], [218, 1, 144, 1, 14, 1, 1, 10], [163, 1, 89, 1, 29, 0, 4, 10],
                     [165, 1, 91, 1, 30, 0, 4, 20],
                     [162, 1, 88, 1, 31, 0, 4, 30], [216, 1, 142, 1, 6, 0, 2, 30], [16, 1, 198, 0, 1, 0, 3, 30],
                     [220, 1, 146, 1, 13, 1, 1, 10],
                     [218, 1, 144, 1, 14, 1, 1, 10], [29, 1, 211, 0, 26, 0, 4, 10], [33, 1, 215, 0, 27, 0, 4, 20],
                     [32, 1, 214, 0, 28, 0, 4, 30],
                     [204, 1, 130, 1, 5, 0, 2, 30], [73, 1, 255, 0, 5, 0, 3, 30], [41, 1, 223, 0, 15, 1, 1, 10],
                     [171, 1, 97, 1, 16, 1, 1, 10],
                     [232, 0, 158, 0, 8, 0, 2, 30], [181, 1, 107, 1, 2, 0, 3, 30], [41, 1, 223, 0, 15, 1, 1, 10],
                     [55, 1, 237, 0, 17, 1, 1, 10], [216, 1, 142, 1, 6, 0, 2, 30],
                     [16, 1, 198, 0, 1, 0, 3, 30], [192, 1, 118, 1, 18, 1, 1, 10], [183, 0, 109, 0, 129, 0, 1, 30],
                     [232, 0, 158, 0, 8, 0, 2, 30],
                     [181, 1, 107, 1, 2, 0, 3, 30], [227, 0, 153, 0, 19, 1, 1, 10], [145, 1, 71, 1, 127, 0, 1, 30],
                     [216, 1, 142, 1, 6, 0, 2, 30],
                     [16, 1, 198, 0, 1, 0, 3, 30], [104, 1, 30, 1, 20, 1, 1, 10], [31, 1, 213, 0, 128, 0, 1, 30],
                     [204, 1, 130, 1, 5, 0, 2, 30],
                     [73, 1, 255, 0, 5, 0, 3, 30], [222, 1, 148, 1, 21, 1, 1, 10], [138, 1, 64, 1, 23, 1, 1, 10],
                     [97, 1, 23, 1, 24, 1, 4, 10], [232, 0, 158, 0, 8, 0, 2, 30], [181, 1, 107, 1, 2, 0, 3, 30],
                     [89, 1, 15, 1, 22, 1, 1, 10],
                     [97, 1, 23, 1, 24, 1, 1, 10], [5, 1, 187, 0, 25, 1, 4, 10], [216, 1, 142, 1, 6, 0, 2, 30],
                     [16, 1, 198, 0, 1, 0, 3, 30],
                     [244, 1, 170, 1, 26, 1, 1, 10], [34, 1, 216, 0, 27, 1, 1, 10], [232, 0, 158, 0, 8, 0, 2, 30],
                     [181, 1, 107, 1, 2, 0, 3, 30], [244, 1, 170, 1, 26, 1, 1, 10], [245, 1, 171, 1, 28, 1, 1, 10],
                     [83, 1, 9, 1, 29, 1, 4, 10],
                     [216, 1, 142, 1, 6, 0, 2, 30], [16, 1, 198, 0, 1, 0, 3, 30], [248, 0, 174, 0, 30, 1, 1, 10],
                     [199, 1, 125, 1, 32, 1, 1, 10], [232, 0, 158, 0, 8, 0, 2, 30], [181, 1, 107, 1, 2, 0, 3, 30],
                     [235, 1, 161, 1, 31, 1, 1, 10],
                     [241, 0, 167, 0, 33, 1, 1, 10], [248, 0, 174, 0, 30, 1, 4, 10], [216, 1, 142, 1, 6, 0, 2, 30],
                     [16, 1, 198, 0, 1, 0, 3, 30],
                     [182, 1, 108, 1, 34, 1, 1, 10], [208, 1, 134, 1, 35, 1, 4, 10], [232, 0, 158, 0, 8, 0, 2, 30],
                     [181, 1, 107, 1, 2, 0, 3, 30],
                     [182, 1, 108, 1, 34, 1, 1, 10], [211, 0, 137, 0, 36, 1, 4, 10], [216, 1, 142, 1, 6, 0, 2, 30],
                     [16, 1, 198, 0, 1, 0, 3, 30],
                     [99, 1, 25, 1, 37, 1, 1, 10], [116, 1, 42, 1, 39, 1, 1, 10], [68, 1, 250, 0, 14, 0, 3, 30],
                     [232, 0, 158, 0, 8, 0, 2, 30],
                     [177, 1, 103, 1, 38, 1, 1, 10], [159, 1, 85, 1, 40, 1, 1, 10], [68, 1, 250, 0, 14, 0, 3, 30],
                     [216, 1, 142, 1, 6, 0, 2, 30],
                     [4, 1, 186, 0, 41, 1, 1, 10], [117, 1, 43, 1, 42, 1, 1, 10], [232, 0, 158, 0, 8, 0, 2, 30],
                     [181, 1, 107, 1, 2, 0, 3, 30],
                     [4, 1, 186, 0, 41, 1, 1, 10], [229, 0, 155, 0, 43, 1, 1, 10], [216, 1, 142, 1, 6, 0, 2, 30],
                     [16, 1, 198, 0, 1, 0, 3, 30],
                     [115, 1, 41, 1, 44, 1, 1, 10], [189, 0, 115, 0, 46, 1, 1, 10], [232, 0, 158, 0, 8, 0, 2, 30],
                     [181, 1, 107, 1, 2, 0, 3, 30],
                     [40, 1, 222, 0, 45, 1, 1, 10], [22, 1, 204, 0, 47, 1, 1, 10], [216, 1, 142, 1, 6, 0, 2, 30],
                     [16, 1, 198, 0, 1, 0, 3, 30],
                     [106, 1, 32, 1, 48, 1, 1, 10], [46, 1, 228, 0, 50, 1, 1, 10], [232, 0, 158, 0, 8, 0, 2, 30],
                     [181, 1, 107, 1, 2, 0, 3, 30],
                     [243, 1, 169, 1, 49, 1, 1, 10], [46, 1, 228, 0, 50, 1, 1, 10], [205, 0, 131, 0, 51, 1, 4, 10],
                     [216, 1, 142, 1, 6, 0, 2, 30],
                     [16, 1, 198, 0, 1, 0, 3, 30], [189, 1, 115, 1, 52, 1, 1, 10], [156, 1, 82, 1, 54, 1, 1, 10],
                     [232, 0, 158, 0, 8, 0, 2, 30],
                     [181, 1, 107, 1, 2, 0, 3, 30], [93, 1, 19, 1, 53, 1, 1, 10], [246, 1, 172, 1, 55, 1, 4, 10],
                     [216, 1, 142, 1, 6, 0, 2, 30],
                     [16, 1, 198, 0, 1, 0, 3, 30], [255, 1, 181, 1, 64, 1, 1, 30], [0, 2, 182, 1, 65, 1, 1, 30],
                     [232, 0, 158, 0, 8, 0, 2, 30], [181, 1, 107, 1, 2, 0, 3, 30], [1, 2, 183, 1, 66, 1, 1, 30],
                     [2, 2, 184, 1, 67, 1, 1, 30],
                     [3, 2, 185, 1, 68, 1, 1, 30], [4, 2, 186, 1, 69, 1, 1, 10], [216, 1, 142, 1, 6, 0, 2, 30],
                     [16, 1, 198, 0, 1, 0, 3, 30],
                     [252, 1, 178, 1, 61, 1, 1, 30], [253, 1, 179, 1, 62, 1, 1, 30], [7, 1, 189, 0, 39, 0, 1, 20],
                     [6, 1, 188, 0, 40, 0, 1, 30],
                     [232, 0, 158, 0, 8, 0, 2, 30], [181, 1, 107, 1, 2, 0, 3, 30], [254, 1, 180, 1, 63, 1, 1, 10],
                     [192, 0, 118, 0, 59, 0, 1, 20],
                     [216, 1, 142, 1, 6, 0, 2, 30], [16, 1, 198, 0, 1, 0, 3, 30], [10, 2, 192, 1, 75, 1, 1, 20],
                     [11, 2, 193, 1, 76, 1, 1, 20], [12, 2, 194, 1, 77, 1, 1, 30], [13, 2, 195, 1, 78, 1, 1, 20],
                     [14, 2, 196, 1, 79, 1, 1, 30],
                     [15, 2, 197, 1, 80, 1, 1, 10], [16, 2, 198, 1, 81, 1, 1, 10], [232, 0, 158, 0, 8, 0, 2, 30],
                     [181, 1, 107, 1, 2, 0, 3, 30],
                     [27, 1, 209, 0, 46, 0, 1, 30], [32, 1, 214, 0, 28, 0, 1, 30], [71, 1, 253, 0, 122, 0, 1, 30],
                     [6, 1, 188, 0, 40, 0, 1, 30],
                     [61, 1, 243, 0, 35, 0, 1, 20], [216, 1, 142, 1, 6, 0, 2, 30], [16, 1, 198, 0, 1, 0, 3, 30],
                     [5, 2, 187, 1, 70, 1, 1, 30],
                     [6, 2, 188, 1, 71, 1, 1, 20], [232, 0, 158, 0, 8, 0, 2, 30], [181, 1, 107, 1, 2, 0, 3, 30],
                     [255, 1, 181, 1, 64, 1, 1, 30],
                     [7, 2, 189, 1, 72, 1, 1, 30], [8, 2, 190, 1, 73, 1, 1, 10], [9, 2, 191, 1, 74, 1, 1, 10],
                     [216, 1, 142, 1, 6, 0, 2, 30],
                     [16, 1, 198, 0, 1, 0, 3, 30], [17, 2, 199, 1, 56, 1, 1, 10], [18, 2, 200, 1, 57, 1, 1, 10],
                     [19, 2, 201, 1, 58, 1, 1, 10], [20, 2, 202, 1, 59, 1, 1, 10], [21, 2, 203, 1, 60, 1, 1, 10],
                     [22, 2, 213, 1, 82, 1, 1, 100],
                     [23, 2, 214, 1, 83, 1, 1, 10], [24, 2, 215, 1, 84, 1, 1, 30], [25, 2, 216, 1, 85, 1, 1, 10],
                     [26, 2, 217, 1, 86, 1, 1, 20],
                     [27, 2, 218, 1, 87, 1, 1, 10], [28, 2, 219, 1, 88, 1, 1, 100], [29, 2, 220, 1, 89, 1, 1, 20]]

music_id = [0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16,
            0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20, 0x21, 0x22, 0x23,
            0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2D, 0x2F, 0x30, 0x31]
music_addresses = [0x9a5eaa, 0x9a6a02, 0x9be3bf, 0x9a7336, 0x9a894e, 0x9b0fa6, 0x9bde82, 0x9be396, 0x9a7fee]


class MissionOffsets:
    type = 0x02
    rank = 0x03
    cancellation = 0x04
    unlockflag1 = 0x05
    unlockflag2 = 0x08
    unlockflag3 = 0x0b
    pub_visibility = 0x0e
    days_available = 0x0f
    rewardItem1 = 0x22
    rewardItem2 = 0x24
    cardItem1 = 0x26
    cardItem2 = 0x28
    clan_reward = 0x2A
    gil_reward = 0x33
    ap_reward = 0x34
    recruit = 0x35
    required_item1 = 0x36
    required_item2 = 0x37
    required_skill = 0x38
    required_job = 0x39
    price = 0x3e
    timeout_days = 0x40
    mission_display = 0x41
    dispatch_ability = 0x43  # Set to 0 for all to be jumpy time
    mission_location = 0x45


class FFTAMission(FFTAObject):
    recruit: int = 0
    mission_type: int = 0
    other: int = 0

    def __init__(self, memory, name: Optional[str], recruit: int, mission_type: int, other: int):
        self.memory = memory
        self.name = name
        self.recruit = recruit
        self.mission_type = mission_type
        self.other = other


class FFTAItem(FFTAObject):

    def __init__(self, memory, name: Optional[str]):
        self.memory = memory
        self.name = name


class JobOffsets:
    sprite_index = 0x07
    equip_items = 0x2D
    ability_start = 0x2E
    ability_end = 0x2F
    job_requirement = 0x30


class AbilityOffsets:
    mp_cost = 0x04
    weapon_required = 0x05
    type = 0x07
    ap_required = 0x08


class UnitOffsets:
    type = 0x00
    job = 0x01
    level = 0x03
    unit_item1 = 0x08
    unit_item2 = 0x0a
    unit_item3 = 0x0c
    unit_item4 = 0x0e
    unit_item5 = 0x10
    abilities = 0x14
    ability_reaction = 0x28
    ability_support = 0x29


class UnitBattleOffsets:
    # 0x00 is name string
    character_id = 0x004
    first_item = 0x02A
    status_3 = 0x0EA


class ItemOffsets:
    buy_price = 0x04
    sell_price = 0x06
    item_flags = 0x0c  # bits 5 - 7 determine shop availability


class JobID:
    soldier = 0x02
    paladin = 0x03
    fighter = 0x04
    thiefhum = 0x05
    ninja = 0x06
    whitemagehum = 0x07
    blackmagehum = 0x08
    illusionisthum = 0x09
    bluemage = 0x0A
    archerhum = 0x0B
    hunter = 0x0C
    warrior = 0x0D
    dragoon = 0x0E
    defender = 0x0F
    gladiator = 0x10
    whitemonk = 0x11
    bishop = 0x12
    templar = 0x13
    whitemagemou = 0x14
    blackmagemou = 0x15
    timemagemou = 0x16
    illusionistmou = 0x17
    alchemist = 0x18
    beastmaster = 0x19
    morpher = 0x1A
    sage = 0x1B
    fencer = 0x1C
    elementalist = 0x1D
    redmage = 0x1E
    whitemagevra = 0x1F
    summoner = 0x20
    archervra = 0x21
    assassin = 0x22
    sniper = 0x23
    animist = 0x24
    mogknight = 0x25
    gunner = 0x26
    thiefmog = 0x27
    juggler = 0x28
    gadgeteer = 0x29
    blackmagemog = 0x2A
    timemagemog = 0x2B

    # Monsters
    goblin = 0x2C
    red_cap = 0x2D
    jelly = 0x2E
    ice_flan = 0x2F
    cream = 0x30
    bomb = 0x31
    grenade = 0x32
    icedrake = 0x33
    firewyrm = 0x34
    thundrake = 0x35
    lamia = 0x36
    lilith = 0x37
    antlion = 0x38
    jawbreaker = 0x39
    toughskin = 0x3A
    blade_biter = 0x3B
    tonberry = 0x3C
    masterberry = 0x3D
    red_panther = 0x3E
    coeurl = 0x3F
    malboro = 0x40
    big_malboro = 0x41
    floateye = 0x42
    ahriman = 0x43
    zombie = 0x44
    vampire = 0x45
    sprite = 0x46
    titania = 0x47


def master_abilities(address, index):
    address | (1 << index)


class UnitType:
    normal = 0x01
    marche = 0x02
    judge1 = 0x5A


class LocationData(NamedTuple):
    name: str
    label: str
    rom_address: int
    flag: int
    tags: Set[str]


class MemorySpace(NamedTuple):
    offset: int
    byteSize: int
    length: int


class Items(MemorySpace):
    offset = 0x51d1a0
    byteSize = 0x20
    length = 375


class MissionNames(MemorySpace):
    offset = 0x55a64c
    byteSize = 0x4
    length = 0x196


class Jobs(MemorySpace):
    offset = 0x521A14
    byteSize = 0x34
    length = 0x73


class Formation(MemorySpace):
    offset = 0x52cde0
    byteSize = 0x30
    length = 0xA46


class UnitInBattle(MemorySpace):
    offset = 0x2000080
    byteSize = 0x108
    length = 6
    # Maybe see if it applies to enemy units as well?


class Missions(MemorySpace):
    # 0x55ae4c original offset
    # 0x196 original length
    offset = 0x55af1e
    byteSize = 0x46
    length = 0x196


class Abilities(MemorySpace):
    offset = 0x55187C
    byteSize = 0x1C
    length = 0x15A


class HumanAbilities(MemorySpace):
    offset = 0x51bb6c
    byteSize = 0x8
    length = 0x8c


class BangaaAbilities(MemorySpace):
    offset = 0x51bfdc
    byteSize = 0x8
    length = 0x4c


class NuMouAbilities(MemorySpace):
    offset = 0x51c244
    byteSize = 0x8
    length = 0x5e


class VieraAbilities(MemorySpace):
    offset = 0x51c53c
    byteSize = 0x8
    length = 0x54


class MoogleAbilities(MemorySpace):
    offset = 0x51c7e4
    byteSize = 0x8
    length = 0x57


class FFTAFormations(FFTAObject):
    formation_type = 0

    def __init__(self, memory, formation_type):
        self.memory = memory
        self.formation_type = formation_type


class FFTAJobs(FFTAObject):

    def __init__(self, memory):
        self.memory = memory


class FFTAAbility(FFTAObject):

    def __init__(self, memory):
        self.memory = memory


class FFTARaceAbility(FFTAObject):

    def __init__(self, memory):
        self.memory = memory


class FFTAData:
    # itemJobNames: List[str]
    # abilityNames: List[str]
    missionNames: List[str]
    # locations: Dict[str, LocationData]
    # animations: List[int]
    formations: List[FFTAFormations]
    missions: List[FFTAMission]
    abilities: List[FFTAAbility]
    jobs: List[FFTAJobs]
    items: List[FFTAItem]

    def __init__(self):
        # self.itemJobNames = self.initializeItemNames()
        # self.abilityNames = self.initializeAbilityNames()
        # self.missionNames = self.initializeMissionNames()
        self.formations = self.initializeFormations()
        self.missions = self.initializeMissions()
        self.abilities = self.initializeAbilities()
        self.jobs = self.initializeJobs()
        # self.lawSets = self.initializeLawSets()
        self.items = self.initializeItems()

    def initializeMissions(self):
        missions = []
        dataType = Missions(0x55af1e, 0x46, 0x196)
        for n in range(dataType.length):
            memory = dataType.offset + dataType.byteSize * n

            new_item = FFTAMission(memory, "Name", *mission_data[n])

            missions.append(new_item)

        return missions

    def initializeItems(self):
        items = []
        dataType = Items(0x51d1a0, 0x20, 375)
        for n in range(dataType.length):
            memory = dataType.offset + dataType.byteSize * n

            new_item = FFTAItem(memory, "Name")

            items.append(new_item)

        return items

    def initializeFormations(self):
        formations = []
        # 414 original length
        dataType = Formation(0x52cde0, 0x30, 0xA46)
        for n in range(dataType.length):
            memory = dataType.offset + dataType.byteSize * n

            if n >= 6:
                formation_type = formation_types[n - 6]
            else:
                formation_type = -1
            new_item = FFTAFormations(memory, formation_type)

            formations.append(new_item)

        return formations

    def initializeJobs(self):
        jobs = []

        dataType = Jobs(0x521A14, 0x34, 0x73)
        for n in range(dataType.length):
            memory = dataType.offset + dataType.byteSize * n

            new_item = FFTAJobs(memory)

            jobs.append(new_item)

        return jobs

    def initializeAbilities(self):
        abilities = []

        dataType = Abilities(0x55187c, 0x1c, 0x15a)
        for n in range(dataType.length):
            memory = dataType.offset + dataType.byteSize * n

            new_item = FFTAAbility(memory)

            abilities.append(new_item)

        return abilities


def get_random_job(random: Random, random_pool: int):
    human = 0
    bangaa = 1
    mou = 2
    viera = 3
    moogle = 4
    monster = 5
    all = 6
    all_with_monster = 7

    random_job: int

    if random_pool == human:
        random_job = random.choice(human_jobs)
        return random_job

    elif random_pool == bangaa:
        random_job = random.choice(bangaa_jobs)
        return random_job

    elif random_pool == mou:
        random_job = random.choice(mou_jobs)
        return random_job

    elif random_pool == viera:
        random_job = random.choice(viera_jobs)
        return random_job

    elif random_pool == moogle:
        random_job = random.choice(moogle_jobs)
        return random_job

    elif random_pool == monster:
        random_job = random.choice(monster_jobs)
        return random_job

    elif random_pool == all:
        random_job = random.choice(all_jobs)
        return random_job

    elif random_pool == all_with_monster:
        random_job = random.choice(all_jobs_with_monster)
        return random_job
