# -*- coding: mbcs -*-

from ctypes import *
import comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0
from comtypes import (
    _check_version, _COAUTHIDENTITY, _COAUTHINFO, _COSERVERINFO, BSTR,
    CoClass, COMMETHOD, dispid, DISPMETHOD, GUID, helpstring,
    IPersist, IUnknown, tagBIND_OPTS2, wireHWND
)
from ctypes import HRESULT
from ctypes.wintypes import (
    _FILETIME, _LARGE_INTEGER, _ULARGE_INTEGER, DWORD, tagRECT,
    tagSIZE, VARIANT_BOOL
)
from comtypes.typeinfo import (
    IRecordInfo, ITypeComp, ITypeInfo, ITypeLib, tagARRAYDESC,
    tagCALLCONV, tagDESCKIND, tagELEMDESC, tagFUNCDESC, tagFUNCKIND,
    tagIDLDESC, tagPARAMDESC, tagPARAMDESCEX, tagSAFEARRAYBOUND,
    tagSYSKIND, tagTLIBATTR, tagTYPEATTR, tagTYPEDESC, tagTYPEKIND,
    tagVARDESC, tagVARKIND, ULONG_PTR
)
from comtypes.stream import ISequentialStream
from comtypes.automation import (
    DECIMAL, IDispatch, SCODE, tagINVOKEKIND, VARIANT
)
from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from comtypes import hints


_lcid = 0  # change this if required
typelib_path = 'C:\\Windows\\System32\\msvidctl.dll'
WSTRING = c_wchar_p
STRING = c_char_p
LONG_PTR = c_longlong

# values for enumeration 'MSVidSinkStreams'
MSVidSink_Video = 1
MSVidSink_Audio = 2
MSVidSink_Other = 4
MSVidSinkStreams = c_int  # enum

# values for enumeration '_PinDirection'
PINDIR_INPUT = 0
PINDIR_OUTPUT = 1
_PinDirection = c_int  # enum

# values for enumeration '_MF_ATTRIBUTES_MATCH_TYPE'
MF_ATTRIBUTES_MATCH_OUR_ITEMS = 0
MF_ATTRIBUTES_MATCH_THEIR_ITEMS = 1
MF_ATTRIBUTES_MATCH_ALL_ITEMS = 2
MF_ATTRIBUTES_MATCH_INTERSECTION = 3
MF_ATTRIBUTES_MATCH_SMALLER = 4
_MF_ATTRIBUTES_MATCH_TYPE = c_int  # enum

# values for enumeration 'SourceSizeList'
sslFullSize = 0
sslClipByOverScan = 1
sslClipByClipRect = 2
SourceSizeList = c_int  # enum

# values for enumeration 'RecordingType'
CONTENT = 0
REFERENCE = 1
RecordingType = c_int  # enum

# values for enumeration 'MSVidSegmentType'
MSVidSEG_SOURCE = 0
MSVidSEG_XFORM = 1
MSVidSEG_DEST = 2
MSVidSegmentType = c_int  # enum

# values for enumeration '_MFVideoChromaSubsampling'
MFVideoChromaSubsampling_Unknown = 0
MFVideoChromaSubsampling_ProgressiveChroma = 8
MFVideoChromaSubsampling_Horizontally_Cosited = 4
MFVideoChromaSubsampling_Vertically_Cosited = 2
MFVideoChromaSubsampling_Vertically_AlignedChromaPlanes = 1
MFVideoChromaSubsampling_MPEG2 = 5
MFVideoChromaSubsampling_MPEG1 = 1
MFVideoChromaSubsampling_DV_PAL = 6
MFVideoChromaSubsampling_Cosited = 7
MFVideoChromaSubsampling_Last = 8
MFVideoChromaSubsampling_ForceDWORD = 2147483647
_MFVideoChromaSubsampling = c_int  # enum

# values for enumeration 'PositionModeList'
FrameMode = 0
TenthsSecondsMode = 1
PositionModeList = c_int  # enum

# values for enumeration '_MFVideoInterlaceMode'
MFVideoInterlace_Unknown = 0
MFVideoInterlace_Progressive = 2
MFVideoInterlace_FieldInterleavedUpperFirst = 3
MFVideoInterlace_FieldInterleavedLowerFirst = 4
MFVideoInterlace_FieldSingleUpper = 5
MFVideoInterlace_FieldSingleLower = 6
MFVideoInterlace_MixedInterlaceOrProgressive = 7
MFVideoInterlace_Last = 8
MFVideoInterlace_ForceDWORD = 2147483647
_MFVideoInterlaceMode = c_int  # enum

# values for enumeration 'FECMethod'
BDA_FEC_METHOD_NOT_SET = -1
BDA_FEC_METHOD_NOT_DEFINED = 0
BDA_FEC_VITERBI = 1
BDA_FEC_RS_204_188 = 2
BDA_FEC_LDPC = 3
BDA_FEC_BCH = 4
BDA_FEC_RS_147_130 = 5
BDA_FEC_MAX = 6
FECMethod = c_int  # enum

# values for enumeration 'BinaryConvolutionCodeRate'
BDA_BCC_RATE_NOT_SET = -1
BDA_BCC_RATE_NOT_DEFINED = 0
BDA_BCC_RATE_1_2 = 1
BDA_BCC_RATE_2_3 = 2
BDA_BCC_RATE_3_4 = 3
BDA_BCC_RATE_3_5 = 4
BDA_BCC_RATE_4_5 = 5
BDA_BCC_RATE_5_6 = 6
BDA_BCC_RATE_5_11 = 7
BDA_BCC_RATE_7_8 = 8
BDA_BCC_RATE_1_4 = 9
BDA_BCC_RATE_1_3 = 10
BDA_BCC_RATE_2_5 = 11
BDA_BCC_RATE_6_7 = 12
BDA_BCC_RATE_8_9 = 13
BDA_BCC_RATE_9_10 = 14
BDA_BCC_RATE_MAX = 15
BinaryConvolutionCodeRate = c_int  # enum

# values for enumeration 'ModulationType'
BDA_MOD_NOT_SET = -1
BDA_MOD_NOT_DEFINED = 0
BDA_MOD_16QAM = 1
BDA_MOD_32QAM = 2
BDA_MOD_64QAM = 3
BDA_MOD_80QAM = 4
BDA_MOD_96QAM = 5
BDA_MOD_112QAM = 6
BDA_MOD_128QAM = 7
BDA_MOD_160QAM = 8
BDA_MOD_192QAM = 9
BDA_MOD_224QAM = 10
BDA_MOD_256QAM = 11
BDA_MOD_320QAM = 12
BDA_MOD_384QAM = 13
BDA_MOD_448QAM = 14
BDA_MOD_512QAM = 15
BDA_MOD_640QAM = 16
BDA_MOD_768QAM = 17
BDA_MOD_896QAM = 18
BDA_MOD_1024QAM = 19
BDA_MOD_QPSK = 20
BDA_MOD_BPSK = 21
BDA_MOD_OQPSK = 22
BDA_MOD_8VSB = 23
BDA_MOD_16VSB = 24
BDA_MOD_ANALOG_AMPLITUDE = 25
BDA_MOD_ANALOG_FREQUENCY = 26
BDA_MOD_8PSK = 27
BDA_MOD_RF = 28
BDA_MOD_16APSK = 29
BDA_MOD_32APSK = 30
BDA_MOD_NBC_QPSK = 31
BDA_MOD_NBC_8PSK = 32
BDA_MOD_DIRECTV = 33
BDA_MOD_ISDB_T_TMCC = 34
BDA_MOD_ISDB_S_TMCC = 35
BDA_MOD_MAX = 36
ModulationType = c_int  # enum

# values for enumeration 'MSVidCtlStateList'
STATE_UNBUILT = -1
STATE_STOP = 0
STATE_PAUSE = 1
STATE_PLAY = 2
MSVidCtlStateList = c_int  # enum

# values for enumeration '_MFVideoTransferFunction'
MFVideoTransFunc_Unknown = 0
MFVideoTransFunc_10 = 1
MFVideoTransFunc_18 = 2
MFVideoTransFunc_20 = 3
MFVideoTransFunc_22 = 4
MFVideoTransFunc_709 = 5
MFVideoTransFunc_240M = 6
MFVideoTransFunc_sRGB = 7
MFVideoTransFunc_28 = 8
MFVideoTransFunc_Log_100 = 9
MFVideoTransFunc_Log_316 = 10
MFVideoTransFunc_709_sym = 11
MFVideoTransFunc_2020_const = 12
MFVideoTransFunc_2020 = 13
MFVideoTransFunc_26 = 14
MFVideoTransFunc_2084 = 15
MFVideoTransFunc_HLG = 16
MFVideoTransFunc_10_rel = 17
MFVideoTransFunc_BT1361_ECG = 18
MFVideoTransFunc_SMPTE428 = 19
MFVideoTransFunc_Last = 20
MFVideoTransFunc_ForceDWORD = 2147483647
_MFVideoTransferFunction = c_int  # enum

# values for enumeration '_MF_ATTRIBUTE_TYPE'
MF_ATTRIBUTE_UINT32 = 19
MF_ATTRIBUTE_UINT64 = 21
MF_ATTRIBUTE_DOUBLE = 5
MF_ATTRIBUTE_GUID = 72
MF_ATTRIBUTE_STRING = 31
MF_ATTRIBUTE_BLOB = 4113
MF_ATTRIBUTE_IUNKNOWN = 13
_MF_ATTRIBUTE_TYPE = c_int  # enum

# values for enumeration 'DVDMenuIDConstants'
dvdMenu_Title = 2
dvdMenu_Root = 3
dvdMenu_Subpicture = 4
dvdMenu_Audio = 5
dvdMenu_Angle = 6
dvdMenu_Chapter = 7
DVDMenuIDConstants = c_int  # enum

# values for enumeration 'DVDTextStringType'
dvdStruct_Volume = 1
dvdStruct_Title = 2
dvdStruct_ParentalID = 3
dvdStruct_PartOfTitle = 4
dvdStruct_Cell = 5
dvdStream_Audio = 16
dvdStream_Subpicture = 17
dvdStream_Angle = 18
dvdChannel_Audio = 32
dvdGeneral_Name = 48
dvdGeneral_Comments = 49
dvdTitle_Series = 56
dvdTitle_Movie = 57
dvdTitle_Video = 58
dvdTitle_Album = 59
dvdTitle_Song = 60
dvdTitle_Other = 63
dvdTitle_Sub_Series = 64
dvdTitle_Sub_Movie = 65
dvdTitle_Sub_Video = 66
dvdTitle_Sub_Album = 67
dvdTitle_Sub_Song = 68
dvdTitle_Sub_Other = 71
dvdTitle_Orig_Series = 72
dvdTitle_Orig_Movie = 73
dvdTitle_Orig_Video = 74
dvdTitle_Orig_Album = 75
dvdTitle_Orig_Song = 76
dvdTitle_Orig_Other = 79
dvdOther_Scene = 80
dvdOther_Cut = 81
dvdOther_Take = 82
DVDTextStringType = c_int  # enum

# values for enumeration 'DVDSPExt'
dvdSPExt_NotSpecified = 0
dvdSPExt_Caption_Normal = 1
dvdSPExt_Caption_Big = 2
dvdSPExt_Caption_Children = 3
dvdSPExt_CC_Normal = 5
dvdSPExt_CC_Big = 6
dvdSPExt_CC_Children = 7
dvdSPExt_Forced = 9
dvdSPExt_DirectorComments_Normal = 13
dvdSPExt_DirectorComments_Big = 14
dvdSPExt_DirectorComments_Children = 15
DVDSPExt = c_int  # enum

# values for enumeration 'EnTvRat_System'
MPAA = 0
US_TV = 1
Canadian_English = 2
Canadian_French = 3
Reserved4 = 4
System5 = 5
System6 = 6
Reserved7 = 7
PBDA = 8
AgeBased = 9
TvRat_kSystems = 10
TvRat_SystemDontKnow = 255
EnTvRat_System = c_int  # enum

# values for enumeration 'EnTvRat_GenericLevel'
TvRat_0 = 0
TvRat_1 = 1
TvRat_2 = 2
TvRat_3 = 3
TvRat_4 = 4
TvRat_5 = 5
TvRat_6 = 6
TvRat_7 = 7
TvRat_8 = 8
TvRat_9 = 9
TvRat_10 = 10
TvRat_11 = 11
TvRat_12 = 12
TvRat_13 = 13
TvRat_14 = 14
TvRat_15 = 15
TvRat_16 = 16
TvRat_17 = 17
TvRat_18 = 18
TvRat_19 = 19
TvRat_20 = 20
TvRat_21 = 21
TvRat_kLevels = 22
TvRat_Unblock = -1
TvRat_LevelDontKnow = 255
EnTvRat_GenericLevel = c_int  # enum

# values for enumeration '_MFVideoPrimaries'
MFVideoPrimaries_Unknown = 0
MFVideoPrimaries_reserved = 1
MFVideoPrimaries_BT709 = 2
MFVideoPrimaries_BT470_2_SysM = 3
MFVideoPrimaries_BT470_2_SysBG = 4
MFVideoPrimaries_SMPTE170M = 5
MFVideoPrimaries_SMPTE240M = 6
MFVideoPrimaries_EBU3213 = 7
MFVideoPrimaries_SMPTE_C = 8
MFVideoPrimaries_BT2020 = 9
MFVideoPrimaries_XYZ = 10
MFVideoPrimaries_DCI_P3 = 11
MFVideoPrimaries_ACES = 12
MFVideoPrimaries_Display_P3 = 13
MFVideoPrimaries_Last = 14
MFVideoPrimaries_ForceDWORD = 2147483647
_MFVideoPrimaries = c_int  # enum

# values for enumeration '_MFVideoTransferMatrix'
MFVideoTransferMatrix_Unknown = 0
MFVideoTransferMatrix_BT709 = 1
MFVideoTransferMatrix_BT601 = 2
MFVideoTransferMatrix_SMPTE240M = 3
MFVideoTransferMatrix_BT2020_10 = 4
MFVideoTransferMatrix_BT2020_12 = 5
MFVideoTransferMatrix_Identity = 6
MFVideoTransferMatrix_FCC47 = 7
MFVideoTransferMatrix_YCgCo = 8
MFVideoTransferMatrix_SMPTE2085 = 9
MFVideoTransferMatrix_Chroma = 10
MFVideoTransferMatrix_Chroma_const = 11
MFVideoTransferMatrix_ICtCp = 12
MFVideoTransferMatrix_Last = 13
MFVideoTransferMatrix_ForceDWORD = 2147483647
_MFVideoTransferMatrix = c_int  # enum

# values for enumeration '_MFVideoLighting'
MFVideoLighting_Unknown = 0
MFVideoLighting_bright = 1
MFVideoLighting_office = 2
MFVideoLighting_dim = 3
MFVideoLighting_dark = 4
MFVideoLighting_Last = 5
MFVideoLighting_ForceDWORD = 2147483647
_MFVideoLighting = c_int  # enum

# values for enumeration '_MFNominalRange'
MFNominalRange_Unknown = 0
MFNominalRange_Normal = 1
MFNominalRange_Wide = 2
MFNominalRange_0_255 = 1
MFNominalRange_16_235 = 2
MFNominalRange_48_208 = 3
MFNominalRange_64_127 = 4
MFNominalRange_Last = 5
MFNominalRange_ForceDWORD = 2147483647
_MFNominalRange = c_int  # enum

# values for enumeration '_FilterState'
State_Stopped = 0
State_Paused = 1
State_Running = 2
_FilterState = c_int  # enum

# values for enumeration 'ComponentCategory'
CategoryNotSet = -1
CategoryOther = 0
CategoryVideo = 1
CategoryAudio = 2
CategoryText = 3
CategorySubtitles = 4
CategoryCaptions = 5
CategorySuperimpose = 6
CategoryData = 7
CATEGORY_COUNT = 8
ComponentCategory = c_int  # enum

# values for enumeration 'DisplaySizeList'
dslDefaultSize = 0
dslSourceSize = 0
dslHalfSourceSize = 1
dslDoubleSourceSize = 2
dslFullScreen = 3
dslHalfScreen = 4
dslQuarterScreen = 5
dslSixteenthScreen = 6
DisplaySizeList = c_int  # enum

# values for enumeration 'MFVP_MESSAGE_TYPE'
MFVP_MESSAGE_FLUSH = 0
MFVP_MESSAGE_INVALIDATEMEDIATYPE = 1
MFVP_MESSAGE_PROCESSINPUTNOTIFY = 2
MFVP_MESSAGE_BEGINSTREAMING = 3
MFVP_MESSAGE_ENDSTREAMING = 4
MFVP_MESSAGE_ENDOFSTREAM = 5
MFVP_MESSAGE_STEP = 6
MFVP_MESSAGE_CANCELSTEP = 7
MFVP_MESSAGE_TYPE = c_int  # enum

# values for enumeration 'ComponentStatus'
StatusActive = 0
StatusInactive = 1
StatusUnavailable = 2
ComponentStatus = c_int  # enum

# values for enumeration 'BfEnTvRat_GenericAttributes'
BfAttrNone = 0
BfIsBlocked = 1
BfIsAttr_1 = 2
BfIsAttr_2 = 4
BfIsAttr_3 = 8
BfIsAttr_4 = 16
BfIsAttr_5 = 32
BfIsAttr_6 = 64
BfIsAttr_7 = 128
BfValidAttrSubmask = 255
BfEnTvRat_GenericAttributes = c_int  # enum

# values for enumeration 'MSVidCCService'
None_ = 0
Caption1 = 1
Caption2 = 2
Text1 = 3
Text2 = 4
XDS = 5
MSVidCCService = c_int  # enum



class IMSVidDevice(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """MS Video Control Device Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{1C15D47C-911D-11D2-B632-00C04F79498E}')
    _idlflags_ = ['dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_Name(self) -> hints.Incomplete: ...
        Name = hints.normal_property(_get_Name)
        def _get_Status(self) -> hints.Incomplete: ...
        Status = hints.normal_property(_get_Status)
        def _get_Power(self) -> hints.Incomplete: ...
        def _set_Power(self, Power: hints.Incomplete) -> hints.Hresult: ...
        Power = hints.normal_property(_get_Power, _set_Power)
        def _get_Category(self) -> hints.Incomplete: ...
        Category = hints.normal_property(_get_Category)
        def _get_ClassID(self) -> hints.Incomplete: ...
        ClassID = hints.normal_property(_get_ClassID)
        def _get__Category(self) -> hints.Incomplete: ...
        _Category = hints.normal_property(_get__Category)
        def _get__ClassID(self) -> hints.Incomplete: ...
        _ClassID = hints.normal_property(_get__ClassID)
        def IsEqualDevice(self, Device: hints.Incomplete) -> hints.Incomplete: ...


class IMSVidOutputDevice(IMSVidDevice):
    """MS Video Control Output Device Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{37B03546-A4C8-11D2-B634-00C04F79498E}')
    _idlflags_ = ['dual', 'oleautomation', 'proxy']


class IMSVidGenericSink(IMSVidOutputDevice):
    """MS Video Control Generic Sink Output Device"""
    _case_insensitive_ = True
    _iid_ = GUID('{6C29B41D-455B-4C33-963A-0D28E5E555EA}')
    _idlflags_ = ['hidden', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def SetSinkFilter(self, bstrName: hints.Incomplete) -> hints.Hresult: ...
        def _get_SinkStreams(self) -> hints.Incomplete: ...
        def _set_SinkStreams(self, pStreams: hints.Incomplete) -> hints.Hresult: ...
        SinkStreams = hints.normal_property(_get_SinkStreams, _set_SinkStreams)


class IMSVidGenericSink2(IMSVidGenericSink):
    """MS Video Control Generic Sink Output Device 2"""
    _case_insensitive_ = True
    _iid_ = GUID('{6B5A28F3-47F1-4092-B168-60CABEC08F1C}')
    _idlflags_ = ['hidden', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def AddFilter(self, bstrName: hints.Incomplete) -> hints.Hresult: ...
        def ResetFilterList(self) -> hints.Hresult: ...


IMSVidDevice._methods_ = [
    COMMETHOD(
        [dispid(0), 'propget'],
        HRESULT,
        'Name',
        (['out', 'retval'], POINTER(BSTR), 'Name')
    ),
    COMMETHOD(
        [dispid(1), 'propget'],
        HRESULT,
        'Status',
        (['out', 'retval'], POINTER(c_int), 'Status')
    ),
    COMMETHOD(
        [dispid(9), 'propput'],
        HRESULT,
        'Power',
        (['in'], VARIANT_BOOL, 'Power')
    ),
    COMMETHOD(
        [dispid(9), 'propget'],
        HRESULT,
        'Power',
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'Power')
    ),
    COMMETHOD(
        [dispid(23), 'propget'],
        HRESULT,
        'Category',
        (['out', 'retval'], POINTER(BSTR), 'Guid')
    ),
    COMMETHOD(
        [dispid(24), 'propget'],
        HRESULT,
        'ClassID',
        (['out', 'retval'], POINTER(BSTR), 'Clsid')
    ),
    COMMETHOD(
        [dispid(25), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_Category',
        (
            ['out', 'retval'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'Guid',
        )
    ),
    COMMETHOD(
        [dispid(26), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_ClassID',
        (
            ['out', 'retval'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'Clsid',
        )
    ),
    COMMETHOD(
        [dispid(144), helpstring('does the passed in device represent the same underlying hardware')],
        HRESULT,
        'IsEqualDevice',
        (['in'], POINTER(IMSVidDevice), 'Device'),
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'IsEqual')
    ),
]

################################################################
# code template for IMSVidDevice implementation
# class IMSVidDevice_Impl(object):
#     @property
#     def Name(self):
#         '-no docstring-'
#         #return Name
#
#     @property
#     def Status(self):
#         '-no docstring-'
#         #return Status
#
#     def _get(self):
#         '-no docstring-'
#         #return Power
#     def _set(self, Power):
#         '-no docstring-'
#     Power = property(_get, _set, doc = _set.__doc__)
#
#     @property
#     def Category(self):
#         '-no docstring-'
#         #return Guid
#
#     @property
#     def ClassID(self):
#         '-no docstring-'
#         #return Clsid
#
#     @property
#     def _Category(self):
#         '-no docstring-'
#         #return Guid
#
#     @property
#     def _ClassID(self):
#         '-no docstring-'
#         #return Clsid
#
#     def IsEqualDevice(self, Device):
#         'does the passed in device represent the same underlying hardware'
#         #return IsEqual
#

IMSVidOutputDevice._methods_ = [
]

################################################################
# code template for IMSVidOutputDevice implementation
# class IMSVidOutputDevice_Impl(object):

IMSVidGenericSink._methods_ = [
    COMMETHOD(
        [helpstring('Set the sink filter (CLSID)')],
        HRESULT,
        'SetSinkFilter',
        ([], BSTR, 'bstrName')
    ),
    COMMETHOD(
        ['propget', helpstring('SinkPaths')],
        HRESULT,
        'SinkStreams',
        (['out', 'retval'], POINTER(MSVidSinkStreams), 'pStreams')
    ),
    COMMETHOD(
        ['propput', helpstring('SinkPaths')],
        HRESULT,
        'SinkStreams',
        (['in'], MSVidSinkStreams, 'pStreams')
    ),
]

################################################################
# code template for IMSVidGenericSink implementation
# class IMSVidGenericSink_Impl(object):
#     def SetSinkFilter(self, bstrName):
#         'Set the sink filter (CLSID)'
#         #return 
#
#     def _get(self):
#         'SinkPaths'
#         #return pStreams
#     def _set(self, pStreams):
#         'SinkPaths'
#     SinkStreams = property(_get, _set, doc = _set.__doc__)
#

IMSVidGenericSink2._methods_ = [
    COMMETHOD(
        [helpstring('Add another filter to be used in the sink segment')],
        HRESULT,
        'AddFilter',
        ([], BSTR, 'bstrName')
    ),
    COMMETHOD(
        [helpstring('Reset the list of filters to be added by a sink segment')],
        HRESULT,
        'ResetFilterList',
    ),
]

################################################################
# code template for IMSVidGenericSink2 implementation
# class IMSVidGenericSink2_Impl(object):
#     def AddFilter(self, bstrName):
#         'Add another filter to be used in the sink segment'
#         #return 
#
#     def ResetFilterList(self):
#         'Reset the list of filters to be added by a sink segment'
#         #return 
#


class MSVidVideoRenderer(CoClass):
    """MS Video Control Video Renderer(DX7/8) Class"""
    _reg_clsid_ = GUID('{37B03543-A4C8-11D2-B634-00C04F79498E}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


class IMSVidVideoRenderer(IMSVidOutputDevice):
    """MS Video Control Video Renderer Device Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{37B03540-A4C8-11D2-B634-00C04F79498E}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_CustomCompositorClass(self) -> hints.Incomplete: ...
        def _set_CustomCompositorClass(self, CompositorCLSID: hints.Incomplete) -> hints.Hresult: ...
        CustomCompositorClass = hints.normal_property(_get_CustomCompositorClass, _set_CustomCompositorClass)
        def _get__CustomCompositorClass(self) -> hints.Incomplete: ...
        def _set__CustomCompositorClass(self, CompositorCLSID: hints.Incomplete) -> hints.Hresult: ...
        _CustomCompositorClass = hints.normal_property(_get__CustomCompositorClass, _set__CustomCompositorClass)
        def _get__CustomCompositor(self) -> 'IVMRImageCompositor': ...
        def _set__CustomCompositor(self, Compositor: hints.Incomplete) -> hints.Hresult: ...
        _CustomCompositor = hints.normal_property(_get__CustomCompositor, _set__CustomCompositor)
        def _get_MixerBitmap(self) -> hints.Incomplete: ...
        def _set_MixerBitmap(self, MixerPictureDisp: hints.Incomplete) -> hints.Hresult: ...
        MixerBitmap = hints.normal_property(_get_MixerBitmap, _set_MixerBitmap)
        def _get__MixerBitmap(self) -> 'IVMRMixerBitmap': ...
        def _set__MixerBitmap(self, MixerPicture: hints.Incomplete) -> hints.Hresult: ...
        _MixerBitmap = hints.normal_property(_get__MixerBitmap, _set__MixerBitmap)
        def _get_MixerBitmapPositionRect(self) -> 'IMSVidRect': ...
        def _set_MixerBitmapPositionRect(self, rDest: hints.Incomplete) -> hints.Hresult: ...
        MixerBitmapPositionRect = hints.normal_property(_get_MixerBitmapPositionRect, _set_MixerBitmapPositionRect)
        def _get_MixerBitmapOpacity(self) -> hints.Incomplete: ...
        def _set_MixerBitmapOpacity(self, opacity: hints.Incomplete) -> hints.Hresult: ...
        MixerBitmapOpacity = hints.normal_property(_get_MixerBitmapOpacity, _set_MixerBitmapOpacity)
        def SetupMixerBitmap(self, MixerPictureDisp: hints.Incomplete, opacity: hints.Incomplete, rDest: hints.Incomplete) -> hints.Hresult: ...
        def _get_SourceSize(self) -> hints.Incomplete: ...
        def _set_SourceSize(self, CurrentSize: hints.Incomplete) -> hints.Hresult: ...
        SourceSize = hints.normal_property(_get_SourceSize, _set_SourceSize)
        def _get_OverScan(self) -> hints.Incomplete: ...
        def _set_OverScan(self, plPercent: hints.Incomplete) -> hints.Hresult: ...
        OverScan = hints.normal_property(_get_OverScan, _set_OverScan)
        def _get_AvailableSourceRect(self) -> 'IMSVidRect': ...
        AvailableSourceRect = hints.normal_property(_get_AvailableSourceRect)
        def _get_MaxVidRect(self) -> 'IMSVidRect': ...
        MaxVidRect = hints.normal_property(_get_MaxVidRect)
        def _get_MinVidRect(self) -> 'IMSVidRect': ...
        MinVidRect = hints.normal_property(_get_MinVidRect)
        def _get_ClippedSourceRect(self) -> 'IMSVidRect': ...
        def _set_ClippedSourceRect(self, pRect: hints.Incomplete) -> hints.Hresult: ...
        ClippedSourceRect = hints.normal_property(_get_ClippedSourceRect, _set_ClippedSourceRect)
        def _get_UsingOverlay(self) -> hints.Incomplete: ...
        def _set_UsingOverlay(self, UseOverlayVal: hints.Incomplete) -> hints.Hresult: ...
        UsingOverlay = hints.normal_property(_get_UsingOverlay, _set_UsingOverlay)
        def Capture(self) -> hints.Incomplete: ...
        def _get_FramesPerSecond(self) -> hints.Incomplete: ...
        FramesPerSecond = hints.normal_property(_get_FramesPerSecond)
        def _get_DecimateInput(self) -> hints.Incomplete: ...
        def _set_DecimateInput(self, pDeci: hints.Incomplete) -> hints.Hresult: ...
        DecimateInput = hints.normal_property(_get_DecimateInput, _set_DecimateInput)


class IMSVidVideoRenderer2(IMSVidVideoRenderer):
    """MS Video Control Video Renderer Device(DX7/8) Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{6BDD5C1E-2810-4159-94BC-05511AE8549B}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_Allocator(self) -> hints.Incomplete: ...
        Allocator = hints.normal_property(_get_Allocator)
        def _get__Allocator(self) -> 'IVMRSurfaceAllocator': ...
        _Allocator = hints.normal_property(_get__Allocator)
        def _get_Allocator_ID(self) -> hints.Incomplete: ...
        Allocator_ID = hints.normal_property(_get_Allocator_ID)
        def SetAllocator(self, AllocPresent: hints.Incomplete, Id: hints.Incomplete = ...) -> hints.Hresult: ...
        def _SetAllocator(self, AllocPresent: hints.Incomplete, Id: hints.Incomplete = ...) -> hints.Hresult: ...
        def _get_SuppressEffects(self) -> hints.Incomplete: ...
        def _set_SuppressEffects(self, bSuppress: hints.Incomplete) -> hints.Hresult: ...
        SuppressEffects = hints.normal_property(_get_SuppressEffects, _set_SuppressEffects)


class IMSVidDeviceEvent(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """MS Video Control Device Event Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{1C15D480-911D-11D2-B632-00C04F79498E}')
    _idlflags_ = ['oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def StateChange(self, lpd: hints.Incomplete, oldState: hints.Incomplete, newState: hints.Incomplete) -> hints.Hresult: ...


class IMSVidOutputDeviceEvent(IMSVidDeviceEvent):
    """MS Video Control Output Device Event Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{2E6A14E2-571C-11D3-B652-00C04F79498E}')
    _idlflags_ = ['oleautomation', 'proxy']


class IMSVidVideoRendererEvent(IMSVidOutputDeviceEvent):
    """MS Video Control Video Renderer Device Event Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{37B03545-A4C8-11D2-B634-00C04F79498E}')
    _idlflags_ = ['hidden', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def OverlayUnavailable(self) -> hints.Hresult: ...


class IMSVidGraphSegment(IPersist):
    """DShow Graph Segment Builder Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{238DEC54-ADEB-4005-A349-F772B9AFEBC4}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def _get_Init(self) -> hints.Incomplete: ...
        def _set_Init(self, pInit: hints.Incomplete) -> hints.Hresult: ...
        Init = hints.normal_property(_get_Init, _set_Init)
        def EnumFilters(self) -> 'IEnumFilters': ...
        def _get_Container(self) -> 'IMSVidGraphSegmentContainer': ...
        def _set_Container(self, ppCtl: hints.Incomplete) -> hints.Hresult: ...
        Container = hints.normal_property(_get_Container, _set_Container)
        def _get_type(self) -> hints.Incomplete: ...
        type = hints.normal_property(_get_type)
        def _get_Category(self) -> hints.Incomplete: ...
        Category = hints.normal_property(_get_Category)
        def Build(self) -> hints.Hresult: ...
        def PostBuild(self) -> hints.Hresult: ...
        def PreRun(self) -> hints.Hresult: ...
        def PostRun(self) -> hints.Hresult: ...
        def PreStop(self) -> hints.Hresult: ...
        def PostStop(self) -> hints.Hresult: ...
        def OnEventNotify(self, lEventCode: hints.Incomplete, lEventParm1: hints.Incomplete, lEventParm2: hints.Incomplete) -> hints.Hresult: ...
        def Decompose(self) -> hints.Hresult: ...


MSVidVideoRenderer._com_interfaces_ = [IMSVidVideoRenderer2, IMSVidVideoRenderer, IMSVidGraphSegment]
MSVidVideoRenderer._outgoing_interfaces_ = [IMSVidVideoRendererEvent]


class MSVidStreamBufferSink(CoClass):
    """MS Video Control Stream Buffer Engine Sink Class"""
    _reg_clsid_ = GUID('{9E77AAC4-35E5-42A1-BDC2-8F3FF399847C}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


class IMSVidStreamBufferSink(IMSVidOutputDevice):
    """MS Video Control Stream Buffer Sink Output Device Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{159DBB45-CD1B-4DAB-83EA-5CB1F4F21D07}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_ContentRecorder(self, pszFilename: hints.Incomplete) -> 'IMSVidStreamBufferRecordingControl': ...
        ContentRecorder = hints.named_property('ContentRecorder', _get_ContentRecorder)
        def _get_ReferenceRecorder(self, pszFilename: hints.Incomplete) -> 'IMSVidStreamBufferRecordingControl': ...
        ReferenceRecorder = hints.named_property('ReferenceRecorder', _get_ReferenceRecorder)
        def _get_SinkName(self) -> hints.Incomplete: ...
        def _set_SinkName(self, pName: hints.Incomplete) -> hints.Hresult: ...
        SinkName = hints.normal_property(_get_SinkName, _set_SinkName)
        def NameSetLock(self) -> hints.Hresult: ...
        def _get_SBESink(self) -> hints.Incomplete: ...
        SBESink = hints.normal_property(_get_SBESink)


class IMSVidStreamBufferSink2(IMSVidStreamBufferSink):
    """MS Video Control Stream Buffer Sink 2 Output Device Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{2CA9FC63-C131-4E5A-955A-544A47C67146}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def UnlockProfile(self) -> hints.Hresult: ...


class IMSVidStreamBufferSink3(IMSVidStreamBufferSink2):
    """MS Video Control Stream Buffer Sink 3 Output Device Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{4F8721D7-7D59-4D8B-99F5-A77775586BD5}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def SetMinSeek(self) -> hints.Incomplete: ...
        def _get_AudioCounter(self) -> hints.Incomplete: ...
        AudioCounter = hints.normal_property(_get_AudioCounter)
        def _get_VideoCounter(self) -> hints.Incomplete: ...
        VideoCounter = hints.normal_property(_get_VideoCounter)
        def _get_CCCounter(self) -> hints.Incomplete: ...
        CCCounter = hints.normal_property(_get_CCCounter)
        def _get_WSTCounter(self) -> hints.Incomplete: ...
        WSTCounter = hints.normal_property(_get_WSTCounter)
        def _get_AudioAnalysisFilter(self) -> hints.Incomplete: ...
        def _set_AudioAnalysisFilter(self, pszCLSID: hints.Incomplete) -> hints.Hresult: ...
        AudioAnalysisFilter = hints.normal_property(_get_AudioAnalysisFilter, _set_AudioAnalysisFilter)
        def _get__AudioAnalysisFilter(self) -> hints.Incomplete: ...
        def _set__AudioAnalysisFilter(self, pGuid: hints.Incomplete) -> hints.Hresult: ...
        _AudioAnalysisFilter = hints.normal_property(_get__AudioAnalysisFilter, _set__AudioAnalysisFilter)
        def _get_VideoAnalysisFilter(self) -> hints.Incomplete: ...
        def _set_VideoAnalysisFilter(self, pszCLSID: hints.Incomplete) -> hints.Hresult: ...
        VideoAnalysisFilter = hints.normal_property(_get_VideoAnalysisFilter, _set_VideoAnalysisFilter)
        def _get__VideoAnalysisFilter(self) -> hints.Incomplete: ...
        def _set__VideoAnalysisFilter(self, pGuid: hints.Incomplete) -> hints.Hresult: ...
        _VideoAnalysisFilter = hints.normal_property(_get__VideoAnalysisFilter, _set__VideoAnalysisFilter)
        def _get_DataAnalysisFilter(self) -> hints.Incomplete: ...
        def _set_DataAnalysisFilter(self, pszCLSID: hints.Incomplete) -> hints.Hresult: ...
        DataAnalysisFilter = hints.normal_property(_get_DataAnalysisFilter, _set_DataAnalysisFilter)
        def _get__DataAnalysisFilter(self) -> hints.Incomplete: ...
        def _set__DataAnalysisFilter(self, pGuid: hints.Incomplete) -> hints.Hresult: ...
        _DataAnalysisFilter = hints.normal_property(_get__DataAnalysisFilter, _set__DataAnalysisFilter)
        def _get_LicenseErrorCode(self) -> hints.Incomplete: ...
        LicenseErrorCode = hints.normal_property(_get_LicenseErrorCode)


class IMSVidStreamBufferSinkEvent(IMSVidOutputDeviceEvent):
    """MS Video Control Stream Buffer Sink Output Device Event Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{F798A36B-B05B-4BBE-9703-EAEA7D61CD51}')
    _idlflags_ = ['hidden', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def CertificateFailure(self) -> hints.Hresult: ...
        def CertificateSuccess(self) -> hints.Hresult: ...
        def WriteFailure(self) -> hints.Hresult: ...


class IMSVidStreamBufferSinkEvent2(IMSVidStreamBufferSinkEvent):
    """MS Video Control Stream Buffer Sink 2 Device Event Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{3D7A5166-72D7-484B-A06F-286187B80CA1}')
    _idlflags_ = ['hidden', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def EncryptionOn(self) -> hints.Hresult: ...
        def EncryptionOff(self) -> hints.Hresult: ...


class IMSVidStreamBufferSinkEvent3(IMSVidStreamBufferSinkEvent2):
    """MS Video Control Stream Buffer Sink 3 Device Event Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{735AD8D5-C259-48E9-81E7-D27953665B23}')
    _idlflags_ = ['hidden', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def LicenseChange(self, dwProt: hints.Incomplete) -> hints.Hresult: ...


class IMSVidStreamBufferSinkEvent4(IMSVidStreamBufferSinkEvent3):
    """MS Video Control Stream Buffer Sink 4 Device Event Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{1B01DCB0-DAF0-412C-A5D1-590C7F62E2B8}')
    _idlflags_ = ['hidden', 'oleautomation']

    if TYPE_CHECKING:  # commembers
        def WriteFailureClear(self) -> hints.Hresult: ...


MSVidStreamBufferSink._com_interfaces_ = [IMSVidStreamBufferSink3, IMSVidStreamBufferSink2, IMSVidStreamBufferSink, IMSVidGraphSegment]
MSVidStreamBufferSink._outgoing_interfaces_ = [IMSVidStreamBufferSinkEvent4, IMSVidStreamBufferSinkEvent3, IMSVidStreamBufferSinkEvent2, IMSVidStreamBufferSinkEvent]


class IPin(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    _case_insensitive_ = True
    _iid_ = GUID('{56A86891-0AD4-11CE-B03A-0020AF0BA770}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def Connect(self, pReceivePin: hints.Incomplete, pmt: hints.Incomplete) -> hints.Hresult: ...
        def ReceiveConnection(self, pConnector: hints.Incomplete, pmt: hints.Incomplete) -> hints.Hresult: ...
        def Disconnect(self) -> hints.Hresult: ...
        def ConnectedTo(self) -> 'IPin': ...
        def ConnectionMediaType(self) -> hints.Incomplete: ...
        def QueryPinInfo(self) -> hints.Incomplete: ...
        def QueryDirection(self) -> hints.Incomplete: ...
        def QueryId(self) -> hints.Incomplete: ...
        def QueryAccept(self, pmt: hints.Incomplete) -> hints.Hresult: ...
        def EnumMediaTypes(self) -> 'IEnumMediaTypes': ...
        def QueryInternalConnections(self, nPin: hints.Incomplete) -> hints.Tuple['IPin', hints.Incomplete]: ...
        def EndOfStream(self) -> hints.Hresult: ...
        def BeginFlush(self) -> hints.Hresult: ...
        def EndFlush(self) -> hints.Hresult: ...
        def NewSegment(self, tStart: hints.Incomplete, tStop: hints.Incomplete, dRate: hints.Incomplete) -> hints.Hresult: ...


class _AMMediaType(Structure):
    pass


class _PinInfo(Structure):
    pass


class IEnumMediaTypes(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    _case_insensitive_ = True
    _iid_ = GUID('{89C31040-846B-11CE-97D3-00AA0055595A}')
    _idlflags_ = []

    def __iter__(self):
        return self

    def __next__(self):
        item, fetched = self.Next(1)
        if fetched:
            return item
        raise StopIteration

    def __getitem__(self, index):
        self.Reset()
        self.Skip(index)
        item, fetched = self.Next(1)
        if fetched:
            return item
        raise IndexError(index)

    if TYPE_CHECKING:  # commembers
        def Next(self, cMediaTypes: hints.Incomplete) -> hints.Tuple[hints.Incomplete, hints.Incomplete]: ...
        def Skip(self, cMediaTypes: hints.Incomplete) -> hints.Hresult: ...
        def Reset(self) -> hints.Hresult: ...
        def Clone(self) -> 'IEnumMediaTypes': ...


IPin._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'Connect',
        (['in'], POINTER(IPin), 'pReceivePin'),
        (['in'], POINTER(_AMMediaType), 'pmt')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'ReceiveConnection',
        (['in'], POINTER(IPin), 'pConnector'),
        (['in'], POINTER(_AMMediaType), 'pmt')
    ),
    COMMETHOD([], HRESULT, 'Disconnect'),
    COMMETHOD(
        [],
        HRESULT,
        'ConnectedTo',
        (['out'], POINTER(POINTER(IPin)), 'pPin')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'ConnectionMediaType',
        (['out'], POINTER(_AMMediaType), 'pmt')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'QueryPinInfo',
        (['out'], POINTER(_PinInfo), 'pInfo')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'QueryDirection',
        (['out'], POINTER(_PinDirection), 'pPinDir')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'QueryId',
        (['out'], POINTER(WSTRING), 'Id')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'QueryAccept',
        (['in'], POINTER(_AMMediaType), 'pmt')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'EnumMediaTypes',
        (['out'], POINTER(POINTER(IEnumMediaTypes)), 'ppenum')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'QueryInternalConnections',
        (['out'], POINTER(POINTER(IPin)), 'apPin'),
        (['in', 'out'], POINTER(c_ulong), 'nPin')
    ),
    COMMETHOD([], HRESULT, 'EndOfStream'),
    COMMETHOD([], HRESULT, 'BeginFlush'),
    COMMETHOD([], HRESULT, 'EndFlush'),
    COMMETHOD(
        [],
        HRESULT,
        'NewSegment',
        (['in'], c_longlong, 'tStart'),
        (['in'], c_longlong, 'tStop'),
        (['in'], c_double, 'dRate')
    ),
]

################################################################
# code template for IPin implementation
# class IPin_Impl(object):
#     def Connect(self, pReceivePin, pmt):
#         '-no docstring-'
#         #return 
#
#     def ReceiveConnection(self, pConnector, pmt):
#         '-no docstring-'
#         #return 
#
#     def Disconnect(self):
#         '-no docstring-'
#         #return 
#
#     def ConnectedTo(self):
#         '-no docstring-'
#         #return pPin
#
#     def ConnectionMediaType(self):
#         '-no docstring-'
#         #return pmt
#
#     def QueryPinInfo(self):
#         '-no docstring-'
#         #return pInfo
#
#     def QueryDirection(self):
#         '-no docstring-'
#         #return pPinDir
#
#     def QueryId(self):
#         '-no docstring-'
#         #return Id
#
#     def QueryAccept(self, pmt):
#         '-no docstring-'
#         #return 
#
#     def EnumMediaTypes(self):
#         '-no docstring-'
#         #return ppenum
#
#     def QueryInternalConnections(self):
#         '-no docstring-'
#         #return apPin, nPin
#
#     def EndOfStream(self):
#         '-no docstring-'
#         #return 
#
#     def BeginFlush(self):
#         '-no docstring-'
#         #return 
#
#     def EndFlush(self):
#         '-no docstring-'
#         #return 
#
#     def NewSegment(self, tStart, tStop, dRate):
#         '-no docstring-'
#         #return 
#


class tagCABSTRBLOB(Structure):
    pass


class tagBSTRBLOB(Structure):
    pass


tagCABSTRBLOB._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(tagBSTRBLOB)),
]

assert sizeof(tagCABSTRBLOB) == 16, sizeof(tagCABSTRBLOB)
assert alignment(tagCABSTRBLOB) == 8, alignment(tagCABSTRBLOB)


class IStorage(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    _case_insensitive_ = True
    _iid_ = GUID('{0000000B-0000-0000-C000-000000000046}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def CreateStream(self, pwcsName: hints.Incomplete, grfMode: hints.Incomplete, reserved1: hints.Incomplete, reserved2: hints.Incomplete) -> 'IStream': ...
        def RemoteOpenStream(self, pwcsName: hints.Incomplete, cbReserved1: hints.Incomplete, reserved1: hints.Incomplete, grfMode: hints.Incomplete, reserved2: hints.Incomplete) -> 'IStream': ...
        def CreateStorage(self, pwcsName: hints.Incomplete, grfMode: hints.Incomplete, reserved1: hints.Incomplete, reserved2: hints.Incomplete) -> 'IStorage': ...
        def OpenStorage(self, pwcsName: hints.Incomplete, pstgPriority: hints.Incomplete, grfMode: hints.Incomplete, snbExclude: hints.Incomplete, reserved: hints.Incomplete) -> 'IStorage': ...
        def RemoteCopyTo(self, ciidExclude: hints.Incomplete, rgiidExclude: hints.Incomplete, snbExclude: hints.Incomplete, pstgDest: hints.Incomplete) -> hints.Hresult: ...
        def MoveElementTo(self, pwcsName: hints.Incomplete, pstgDest: hints.Incomplete, pwcsNewName: hints.Incomplete, grfFlags: hints.Incomplete) -> hints.Hresult: ...
        def Commit(self, grfCommitFlags: hints.Incomplete) -> hints.Hresult: ...
        def Revert(self) -> hints.Hresult: ...
        def RemoteEnumElements(self, reserved1: hints.Incomplete, cbReserved2: hints.Incomplete, reserved2: hints.Incomplete, reserved3: hints.Incomplete) -> 'IEnumSTATSTG': ...
        def DestroyElement(self, pwcsName: hints.Incomplete) -> hints.Hresult: ...
        def RenameElement(self, pwcsOldName: hints.Incomplete, pwcsNewName: hints.Incomplete) -> hints.Hresult: ...
        def SetElementTimes(self, pwcsName: hints.Incomplete, pctime: hints.Incomplete, patime: hints.Incomplete, pmtime: hints.Incomplete) -> hints.Hresult: ...
        def SetClass(self, Clsid: hints.Incomplete) -> hints.Hresult: ...
        def SetStateBits(self, grfStateBits: hints.Incomplete, grfMask: hints.Incomplete) -> hints.Hresult: ...
        def Stat(self, grfStatFlag: hints.Incomplete) -> hints.Incomplete: ...


class IStream(ISequentialStream):
    _case_insensitive_ = True
    _iid_ = GUID('{0000000C-0000-0000-C000-000000000046}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def RemoteSeek(self, dlibMove: hints.Incomplete, dwOrigin: hints.Incomplete) -> hints.Incomplete: ...
        def SetSize(self, libNewSize: hints.Incomplete) -> hints.Hresult: ...
        def RemoteCopyTo(self, pstm: hints.Incomplete, cb: hints.Incomplete) -> hints.Tuple[hints.Incomplete, hints.Incomplete]: ...
        def Commit(self, grfCommitFlags: hints.Incomplete) -> hints.Hresult: ...
        def Revert(self) -> hints.Hresult: ...
        def LockRegion(self, libOffset: hints.Incomplete, cb: hints.Incomplete, dwLockType: hints.Incomplete) -> hints.Hresult: ...
        def UnlockRegion(self, libOffset: hints.Incomplete, cb: hints.Incomplete, dwLockType: hints.Incomplete) -> hints.Hresult: ...
        def Stat(self, grfStatFlag: hints.Incomplete) -> hints.Incomplete: ...
        def Clone(self) -> 'IStream': ...


class tagRemSNB(Structure):
    pass


wireSNB = POINTER(tagRemSNB)


class IEnumSTATSTG(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    _case_insensitive_ = True
    _iid_ = GUID('{0000000D-0000-0000-C000-000000000046}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def RemoteNext(self, celt: hints.Incomplete) -> hints.Tuple[hints.Incomplete, hints.Incomplete]: ...
        def Skip(self, celt: hints.Incomplete) -> hints.Hresult: ...
        def Reset(self) -> hints.Hresult: ...
        def Clone(self) -> 'IEnumSTATSTG': ...


class tagSTATSTG(Structure):
    pass


IStorage._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'CreateStream',
        (['in'], WSTRING, 'pwcsName'),
        (['in'], c_ulong, 'grfMode'),
        (['in'], c_ulong, 'reserved1'),
        (['in'], c_ulong, 'reserved2'),
        (['out'], POINTER(POINTER(IStream)), 'ppstm')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'RemoteOpenStream',
        (['in'], WSTRING, 'pwcsName'),
        (['in'], c_ulong, 'cbReserved1'),
        (['in'], POINTER(c_ubyte), 'reserved1'),
        (['in'], c_ulong, 'grfMode'),
        (['in'], c_ulong, 'reserved2'),
        (['out'], POINTER(POINTER(IStream)), 'ppstm')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'CreateStorage',
        (['in'], WSTRING, 'pwcsName'),
        (['in'], c_ulong, 'grfMode'),
        (['in'], c_ulong, 'reserved1'),
        (['in'], c_ulong, 'reserved2'),
        (['out'], POINTER(POINTER(IStorage)), 'ppstg')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'OpenStorage',
        (['in'], WSTRING, 'pwcsName'),
        (['in'], POINTER(IStorage), 'pstgPriority'),
        (['in'], c_ulong, 'grfMode'),
        (['in'], wireSNB, 'snbExclude'),
        (['in'], c_ulong, 'reserved'),
        (['out'], POINTER(POINTER(IStorage)), 'ppstg')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'RemoteCopyTo',
        (['in'], c_ulong, 'ciidExclude'),
        (
            ['in'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'rgiidExclude',
        ),
        (['in'], wireSNB, 'snbExclude'),
        (['in'], POINTER(IStorage), 'pstgDest')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'MoveElementTo',
        (['in'], WSTRING, 'pwcsName'),
        (['in'], POINTER(IStorage), 'pstgDest'),
        (['in'], WSTRING, 'pwcsNewName'),
        (['in'], c_ulong, 'grfFlags')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Commit',
        (['in'], c_ulong, 'grfCommitFlags')
    ),
    COMMETHOD([], HRESULT, 'Revert'),
    COMMETHOD(
        [],
        HRESULT,
        'RemoteEnumElements',
        (['in'], c_ulong, 'reserved1'),
        (['in'], c_ulong, 'cbReserved2'),
        (['in'], POINTER(c_ubyte), 'reserved2'),
        (['in'], c_ulong, 'reserved3'),
        (['out'], POINTER(POINTER(IEnumSTATSTG)), 'ppenum')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'DestroyElement',
        (['in'], WSTRING, 'pwcsName')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'RenameElement',
        (['in'], WSTRING, 'pwcsOldName'),
        (['in'], WSTRING, 'pwcsNewName')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'SetElementTimes',
        (['in'], WSTRING, 'pwcsName'),
        (['in'], POINTER(_FILETIME), 'pctime'),
        (['in'], POINTER(_FILETIME), 'patime'),
        (['in'], POINTER(_FILETIME), 'pmtime')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'SetClass',
        (
            ['in'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'Clsid',
        )
    ),
    COMMETHOD(
        [],
        HRESULT,
        'SetStateBits',
        (['in'], c_ulong, 'grfStateBits'),
        (['in'], c_ulong, 'grfMask')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Stat',
        (['out'], POINTER(tagSTATSTG), 'pstatstg'),
        (['in'], c_ulong, 'grfStatFlag')
    ),
]

################################################################
# code template for IStorage implementation
# class IStorage_Impl(object):
#     def CreateStream(self, pwcsName, grfMode, reserved1, reserved2):
#         '-no docstring-'
#         #return ppstm
#
#     def RemoteOpenStream(self, pwcsName, cbReserved1, reserved1, grfMode, reserved2):
#         '-no docstring-'
#         #return ppstm
#
#     def CreateStorage(self, pwcsName, grfMode, reserved1, reserved2):
#         '-no docstring-'
#         #return ppstg
#
#     def OpenStorage(self, pwcsName, pstgPriority, grfMode, snbExclude, reserved):
#         '-no docstring-'
#         #return ppstg
#
#     def RemoteCopyTo(self, ciidExclude, rgiidExclude, snbExclude, pstgDest):
#         '-no docstring-'
#         #return 
#
#     def MoveElementTo(self, pwcsName, pstgDest, pwcsNewName, grfFlags):
#         '-no docstring-'
#         #return 
#
#     def Commit(self, grfCommitFlags):
#         '-no docstring-'
#         #return 
#
#     def Revert(self):
#         '-no docstring-'
#         #return 
#
#     def RemoteEnumElements(self, reserved1, cbReserved2, reserved2, reserved3):
#         '-no docstring-'
#         #return ppenum
#
#     def DestroyElement(self, pwcsName):
#         '-no docstring-'
#         #return 
#
#     def RenameElement(self, pwcsOldName, pwcsNewName):
#         '-no docstring-'
#         #return 
#
#     def SetElementTimes(self, pwcsName, pctime, patime, pmtime):
#         '-no docstring-'
#         #return 
#
#     def SetClass(self, Clsid):
#         '-no docstring-'
#         #return 
#
#     def SetStateBits(self, grfStateBits, grfMask):
#         '-no docstring-'
#         #return 
#
#     def Stat(self, grfStatFlag):
#         '-no docstring-'
#         #return pstatstg
#


class IEnumMSVidGraphSegment(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    """DShow Graph Segment Enumerator"""
    _case_insensitive_ = True
    _iid_ = GUID('{3DD2903E-E0AA-11D2-B63A-00C04F79498E}')
    _idlflags_ = []

    def __iter__(self):
        return self

    def __next__(self):
        item, fetched = self.Next(1)
        if fetched:
            return item
        raise StopIteration

    def __getitem__(self, index):
        self.Reset()
        self.Skip(index)
        item, fetched = self.Next(1)
        if fetched:
            return item
        raise IndexError(index)

    if TYPE_CHECKING:  # commembers
        def Next(self, celt: hints.Incomplete) -> hints.Tuple['IMSVidGraphSegment', hints.Incomplete]: ...
        def Skip(self, celt: hints.Incomplete) -> hints.Hresult: ...
        def Reset(self) -> hints.Hresult: ...
        def Clone(self) -> 'IEnumMSVidGraphSegment': ...


IEnumMSVidGraphSegment._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'Next',
        (['in'], c_ulong, 'celt'),
        (['out'], POINTER(POINTER(IMSVidGraphSegment)), 'rgelt'),
        (['out'], POINTER(c_ulong), 'pceltFetched')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Skip',
        (['in'], c_ulong, 'celt')
    ),
    COMMETHOD([], HRESULT, 'Reset'),
    COMMETHOD(
        [],
        HRESULT,
        'Clone',
        (['out'], POINTER(POINTER(IEnumMSVidGraphSegment)), 'ppenum')
    ),
]

################################################################
# code template for IEnumMSVidGraphSegment implementation
# class IEnumMSVidGraphSegment_Impl(object):
#     def Next(self, celt):
#         '-no docstring-'
#         #return rgelt, pceltFetched
#
#     def Skip(self, celt):
#         '-no docstring-'
#         #return 
#
#     def Reset(self):
#         '-no docstring-'
#         #return 
#
#     def Clone(self):
#         '-no docstring-'
#         #return ppenum
#

IMSVidDeviceEvent._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'StateChange',
        (['in'], POINTER(IMSVidDevice), 'lpd'),
        (['in'], c_int, 'oldState'),
        (['in'], c_int, 'newState')
    ),
]

################################################################
# code template for IMSVidDeviceEvent implementation
# class IMSVidDeviceEvent_Impl(object):
#     def StateChange(self, lpd, oldState, newState):
#         '-no docstring-'
#         #return 
#

IMSVidOutputDeviceEvent._methods_ = [
]

################################################################
# code template for IMSVidOutputDeviceEvent implementation
# class IMSVidOutputDeviceEvent_Impl(object):

IMSVidStreamBufferSinkEvent._methods_ = [
    COMMETHOD(
        [helpstring('Sink Certificate Failure')],
        HRESULT,
        'CertificateFailure',
    ),
    COMMETHOD(
        [helpstring('Sink Certificate Success')],
        HRESULT,
        'CertificateSuccess',
    ),
    COMMETHOD([helpstring('Sink Write Failure')], HRESULT, 'WriteFailure'),
]

################################################################
# code template for IMSVidStreamBufferSinkEvent implementation
# class IMSVidStreamBufferSinkEvent_Impl(object):
#     def CertificateFailure(self):
#         'Sink Certificate Failure'
#         #return 
#
#     def CertificateSuccess(self):
#         'Sink Certificate Success'
#         #return 
#
#     def WriteFailure(self):
#         'Sink Write Failure'
#         #return 
#

IMSVidStreamBufferSinkEvent2._methods_ = [
    COMMETHOD([helpstring('Source Encryption On')], HRESULT, 'EncryptionOn'),
    COMMETHOD([helpstring('Source Encryption Off')], HRESULT, 'EncryptionOff'),
]

################################################################
# code template for IMSVidStreamBufferSinkEvent2 implementation
# class IMSVidStreamBufferSinkEvent2_Impl(object):
#     def EncryptionOn(self):
#         'Source Encryption On'
#         #return 
#
#     def EncryptionOff(self):
#         'Source Encryption Off'
#         #return 
#

IMSVidStreamBufferSinkEvent3._methods_ = [
    COMMETHOD(
        [helpstring('License Change Event')],
        HRESULT,
        'LicenseChange',
        (['in'], c_int, 'dwProt')
    ),
]

################################################################
# code template for IMSVidStreamBufferSinkEvent3 implementation
# class IMSVidStreamBufferSinkEvent3_Impl(object):
#     def LicenseChange(self, dwProt):
#         'License Change Event'
#         #return 
#

IMSVidStreamBufferSinkEvent4._methods_ = [
    COMMETHOD(
        [helpstring('Sink Write Failure Clear')],
        HRESULT,
        'WriteFailureClear',
    ),
]

################################################################
# code template for IMSVidStreamBufferSinkEvent4 implementation
# class IMSVidStreamBufferSinkEvent4_Impl(object):
#     def WriteFailureClear(self):
#         'Sink Write Failure Clear'
#         #return 
#


class IMSVidAudioRenderer(IMSVidOutputDevice):
    """MS Video Control Audio Renderer Device Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{37B0353F-A4C8-11D2-B634-00C04F79498E}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_Volume(self) -> hints.Incomplete: ...
        def _set_Volume(self, lVol: hints.Incomplete) -> hints.Hresult: ...
        Volume = hints.normal_property(_get_Volume, _set_Volume)
        def _get_Balance(self) -> hints.Incomplete: ...
        def _set_Balance(self, lBal: hints.Incomplete) -> hints.Hresult: ...
        Balance = hints.normal_property(_get_Balance, _set_Balance)


IMSVidAudioRenderer._methods_ = [
    COMMETHOD(
        [dispid(7), 'propput'],
        HRESULT,
        'Volume',
        (['in'], c_int, 'lVol')
    ),
    COMMETHOD(
        [dispid(7), 'propget'],
        HRESULT,
        'Volume',
        (['out', 'retval'], POINTER(c_int), 'lVol')
    ),
    COMMETHOD(
        [dispid(8), 'propput'],
        HRESULT,
        'Balance',
        (['in'], c_int, 'lBal')
    ),
    COMMETHOD(
        [dispid(8), 'propget'],
        HRESULT,
        'Balance',
        (['out', 'retval'], POINTER(c_int), 'lBal')
    ),
]

################################################################
# code template for IMSVidAudioRenderer implementation
# class IMSVidAudioRenderer_Impl(object):
#     def _get(self):
#         '-no docstring-'
#         #return lVol
#     def _set(self, lVol):
#         '-no docstring-'
#     Volume = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         '-no docstring-'
#         #return lBal
#     def _set(self, lBal):
#         '-no docstring-'
#     Balance = property(_get, _set, doc = _set.__doc__)
#


class MSVidGenericSink(CoClass):
    """MS Video Control Stream Buffer Engine Sink Class"""
    _reg_clsid_ = GUID('{4A5869CF-929D-4040-AE03-FCAFC5B9CD42}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidGenericSink._com_interfaces_ = [IMSVidGenericSink2, IMSVidGenericSink, IMSVidGraphSegment]
MSVidGenericSink._outgoing_interfaces_ = [IMSVidDeviceEvent]


class IMSVidStreamBufferRecordingControl(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """IMSVidStreamBufferRecordingControl Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{160621AA-BBBC-4326-A824-C395AEBC6E74}')
    _idlflags_ = ['hidden', 'dual', 'nonextensible', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_startTime(self) -> hints.Incomplete: ...
        def _set_startTime(self, rtStart: hints.Incomplete) -> hints.Hresult: ...
        startTime = hints.normal_property(_get_startTime, _set_startTime)
        def _get_StopTime(self) -> hints.Incomplete: ...
        def _set_StopTime(self, rtStop: hints.Incomplete) -> hints.Hresult: ...
        StopTime = hints.normal_property(_get_StopTime, _set_StopTime)
        def _get_RecordingStopped(self) -> hints.Incomplete: ...
        RecordingStopped = hints.normal_property(_get_RecordingStopped)
        def _get_RecordingStarted(self) -> hints.Incomplete: ...
        RecordingStarted = hints.normal_property(_get_RecordingStarted)
        def _get_RecordingType(self) -> hints.Incomplete: ...
        RecordingType = hints.normal_property(_get_RecordingType)
        def _get_RecordingAttribute(self) -> hints.Incomplete: ...
        RecordingAttribute = hints.normal_property(_get_RecordingAttribute)


IMSVidStreamBufferSink._methods_ = [
    COMMETHOD(
        [dispid(170), helpstring('New Recording Object'), 'propget'],
        HRESULT,
        'ContentRecorder',
        (['in'], BSTR, 'pszFilename'),
        (
            ['out', 'retval'],
            POINTER(POINTER(IMSVidStreamBufferRecordingControl)),
            'pRecordingIUnknown',
        )
    ),
    COMMETHOD(
        [dispid(171), helpstring('New Recording Object'), 'propget'],
        HRESULT,
        'ReferenceRecorder',
        (['in'], BSTR, 'pszFilename'),
        (
            ['out', 'retval'],
            POINTER(POINTER(IMSVidStreamBufferRecordingControl)),
            'pRecordingIUnknown',
        )
    ),
    COMMETHOD(
        [dispid(168), helpstring('Sink Name'), 'propget'],
        HRESULT,
        'SinkName',
        (['out', 'retval'], POINTER(BSTR), 'pName')
    ),
    COMMETHOD(
        [dispid(168), helpstring('Sink Name'), 'propput'],
        HRESULT,
        'SinkName',
        (['in'], BSTR, 'pName')
    ),
    COMMETHOD(
        [dispid(176), helpstring('Name Set Lock')],
        HRESULT,
        'NameSetLock',
    ),
    COMMETHOD(
        [dispid(181), helpstring('SBE Sink Interface'), 'propget'],
        HRESULT,
        'SBESink',
        (['out', 'retval'], POINTER(POINTER(IUnknown)), 'sbeConfig')
    ),
]

################################################################
# code template for IMSVidStreamBufferSink implementation
# class IMSVidStreamBufferSink_Impl(object):
#     @property
#     def ContentRecorder(self, pszFilename):
#         'New Recording Object'
#         #return pRecordingIUnknown
#
#     @property
#     def ReferenceRecorder(self, pszFilename):
#         'New Recording Object'
#         #return pRecordingIUnknown
#
#     def _get(self):
#         'Sink Name'
#         #return pName
#     def _set(self, pName):
#         'Sink Name'
#     SinkName = property(_get, _set, doc = _set.__doc__)
#
#     def NameSetLock(self):
#         'Name Set Lock'
#         #return 
#
#     @property
#     def SBESink(self):
#         'SBE Sink Interface'
#         #return sbeConfig
#

IMSVidStreamBufferSink2._methods_ = [
    COMMETHOD(
        [dispid(198), helpstring('Unlock Sink Filename')],
        HRESULT,
        'UnlockProfile',
    ),
]

################################################################
# code template for IMSVidStreamBufferSink2 implementation
# class IMSVidStreamBufferSink2_Impl(object):
#     def UnlockProfile(self):
#         'Unlock Sink Filename'
#         #return 
#

IMSVidStreamBufferSink3._methods_ = [
    COMMETHOD(
        [dispid(200), helpstring('Sets Min Seek Position to now and returns the current position')],
        HRESULT,
        'SetMinSeek',
        (['out', 'retval'], POINTER(c_int), 'pdwMin')
    ),
    COMMETHOD(
        [dispid(202), helpstring('Returns counter interface for the audio path'), 'propget'],
        HRESULT,
        'AudioCounter',
        (['out', 'retval'], POINTER(POINTER(IUnknown)), 'ppunk')
    ),
    COMMETHOD(
        [dispid(203), helpstring('Returns counter interface for the video path'), 'propget'],
        HRESULT,
        'VideoCounter',
        (['out', 'retval'], POINTER(POINTER(IUnknown)), 'ppunk')
    ),
    COMMETHOD(
        [dispid(204), helpstring('Returns counter interface for the closed captioning data path'), 'propget'],
        HRESULT,
        'CCCounter',
        (['out', 'retval'], POINTER(POINTER(IUnknown)), 'ppunk')
    ),
    COMMETHOD(
        [dispid(205), helpstring('Returns counter interface for the wst (teletext) data path'), 'propget'],
        HRESULT,
        'WSTCounter',
        (['out', 'retval'], POINTER(POINTER(IUnknown)), 'ppunk')
    ),
    COMMETHOD(
        [dispid(210), helpstring('Adds a filter to the audio path for analysis, must be signed properly'), 'propput'],
        HRESULT,
        'AudioAnalysisFilter',
        (['in'], BSTR, 'pszCLSID')
    ),
    COMMETHOD(
        [dispid(210), helpstring('Adds a filter to the audio path for analysis, must be signed properly'), 'propget'],
        HRESULT,
        'AudioAnalysisFilter',
        (['out', 'retval'], POINTER(BSTR), 'pszCLSID')
    ),
    COMMETHOD(
        [dispid(213), helpstring('Adds a filter to the audio path for analysis, must be signed properly'), 'restricted', 'hidden', 'propput'],
        HRESULT,
        '_AudioAnalysisFilter',
        (
            ['in'],
            comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID,
            'pGuid',
        )
    ),
    COMMETHOD(
        [dispid(213), helpstring('Adds a filter to the audio path for analysis, must be signed properly'), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_AudioAnalysisFilter',
        (
            ['out', 'retval'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'pGuid',
        )
    ),
    COMMETHOD(
        [dispid(211), helpstring('Adds a filter to the video path for analysis, must be signed properly'), 'propput'],
        HRESULT,
        'VideoAnalysisFilter',
        (['in'], BSTR, 'pszCLSID')
    ),
    COMMETHOD(
        [dispid(211), helpstring('Adds a filter to the video path for analysis, must be signed properly'), 'propget'],
        HRESULT,
        'VideoAnalysisFilter',
        (['out', 'retval'], POINTER(BSTR), 'pszCLSID')
    ),
    COMMETHOD(
        [dispid(214), helpstring('Adds a filter to the video path for analysis, must be signed properly'), 'restricted', 'hidden', 'propput'],
        HRESULT,
        '_VideoAnalysisFilter',
        (
            ['in'],
            comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID,
            'pGuid',
        )
    ),
    COMMETHOD(
        [dispid(214), helpstring('Adds a filter to the video path for analysis, must be signed properly'), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_VideoAnalysisFilter',
        (
            ['out', 'retval'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'pGuid',
        )
    ),
    COMMETHOD(
        [dispid(212), helpstring('Adds a filter to the data (vbi data) path for analysis, must be signed properly'), 'propput'],
        HRESULT,
        'DataAnalysisFilter',
        (['in'], BSTR, 'pszCLSID')
    ),
    COMMETHOD(
        [dispid(212), helpstring('Adds a filter to the data (vbi data) path for analysis, must be signed properly'), 'propget'],
        HRESULT,
        'DataAnalysisFilter',
        (['out', 'retval'], POINTER(BSTR), 'pszCLSID')
    ),
    COMMETHOD(
        [dispid(215), helpstring('Adds a filter to the data (vbi data) path for analysis, must be signed properly'), 'restricted', 'hidden', 'propput'],
        HRESULT,
        '_DataAnalysisFilter',
        (
            ['in'],
            comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID,
            'pGuid',
        )
    ),
    COMMETHOD(
        [dispid(215), helpstring('Adds a filter to the data (vbi data) path for analysis, must be signed properly'), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_DataAnalysisFilter',
        (
            ['out', 'retval'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'pGuid',
        )
    ),
    COMMETHOD(
        [dispid(45), helpstring('Gets last error seen related to licenses'), 'propget'],
        HRESULT,
        'LicenseErrorCode',
        (['out', 'retval'], POINTER(HRESULT), 'hres')
    ),
]

################################################################
# code template for IMSVidStreamBufferSink3 implementation
# class IMSVidStreamBufferSink3_Impl(object):
#     def SetMinSeek(self):
#         'Sets Min Seek Position to now and returns the current position'
#         #return pdwMin
#
#     @property
#     def AudioCounter(self):
#         'Returns counter interface for the audio path'
#         #return ppunk
#
#     @property
#     def VideoCounter(self):
#         'Returns counter interface for the video path'
#         #return ppunk
#
#     @property
#     def CCCounter(self):
#         'Returns counter interface for the closed captioning data path'
#         #return ppunk
#
#     @property
#     def WSTCounter(self):
#         'Returns counter interface for the wst (teletext) data path'
#         #return ppunk
#
#     def _get(self):
#         'Adds a filter to the audio path for analysis, must be signed properly'
#         #return pszCLSID
#     def _set(self, pszCLSID):
#         'Adds a filter to the audio path for analysis, must be signed properly'
#     AudioAnalysisFilter = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Adds a filter to the audio path for analysis, must be signed properly'
#         #return pGuid
#     def _set(self, pGuid):
#         'Adds a filter to the audio path for analysis, must be signed properly'
#     _AudioAnalysisFilter = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Adds a filter to the video path for analysis, must be signed properly'
#         #return pszCLSID
#     def _set(self, pszCLSID):
#         'Adds a filter to the video path for analysis, must be signed properly'
#     VideoAnalysisFilter = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Adds a filter to the video path for analysis, must be signed properly'
#         #return pGuid
#     def _set(self, pGuid):
#         'Adds a filter to the video path for analysis, must be signed properly'
#     _VideoAnalysisFilter = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Adds a filter to the data (vbi data) path for analysis, must be signed properly'
#         #return pszCLSID
#     def _set(self, pszCLSID):
#         'Adds a filter to the data (vbi data) path for analysis, must be signed properly'
#     DataAnalysisFilter = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Adds a filter to the data (vbi data) path for analysis, must be signed properly'
#         #return pGuid
#     def _set(self, pGuid):
#         'Adds a filter to the data (vbi data) path for analysis, must be signed properly'
#     _DataAnalysisFilter = property(_get, _set, doc = _set.__doc__)
#
#     @property
#     def LicenseErrorCode(self):
#         'Gets last error seen related to licenses'
#         #return hres
#


class IEnumGUID(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    _case_insensitive_ = True
    _iid_ = GUID('{0002E000-0000-0000-C000-000000000046}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def RemoteNext(self, celt: hints.Incomplete) -> hints.Tuple[hints.Incomplete, hints.Incomplete]: ...
        def Skip(self, celt: hints.Incomplete) -> hints.Hresult: ...
        def Reset(self) -> hints.Hresult: ...
        def Clone(self) -> 'IEnumGUID': ...


IEnumGUID._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'RemoteNext',
        (['in'], c_ulong, 'celt'),
        (
            ['out'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'rgelt',
        ),
        (['out'], POINTER(c_ulong), 'pceltFetched')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Skip',
        (['in'], c_ulong, 'celt')
    ),
    COMMETHOD([], HRESULT, 'Reset'),
    COMMETHOD(
        [],
        HRESULT,
        'Clone',
        (['out'], POINTER(POINTER(IEnumGUID)), 'ppenum')
    ),
]

################################################################
# code template for IEnumGUID implementation
# class IEnumGUID_Impl(object):
#     def RemoteNext(self, celt):
#         '-no docstring-'
#         #return rgelt, pceltFetched
#
#     def Skip(self, celt):
#         '-no docstring-'
#         #return 
#
#     def Reset(self):
#         '-no docstring-'
#         #return 
#
#     def Clone(self):
#         '-no docstring-'
#         #return ppenum
#


class IMSVidAudioRendererEvent(IMSVidOutputDeviceEvent):
    """MS Video Control Audio Renderer Device Event Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{37B03541-A4C8-11D2-B634-00C04F79498E}')
    _idlflags_ = ['hidden', 'oleautomation', 'proxy']


IMSVidAudioRendererEvent._methods_ = [
]

################################################################
# code template for IMSVidAudioRendererEvent implementation
# class IMSVidAudioRendererEvent_Impl(object):


class tagCALPSTR(Structure):
    pass


tagCALPSTR._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(STRING)),
]

assert sizeof(tagCALPSTR) == 16, sizeof(tagCALPSTR)
assert alignment(tagCALPSTR) == 8, alignment(tagCALPSTR)


class MSVidStreamBufferSource(CoClass):
    """MS Video Control Stream Buffer Engine Playback Device Class"""
    _reg_clsid_ = GUID('{AD8E510D-217F-409B-8076-29C5E73B98E8}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


class IMSVidInputDevice(IMSVidDevice):
    """MS Video Control Input Device Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{37B0353D-A4C8-11D2-B634-00C04F79498E}')
    _idlflags_ = ['dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def IsViewable(self, v: hints.Incomplete) -> hints.Incomplete: ...
        def View(self, v: hints.Incomplete) -> hints.Hresult: ...


class IMSVidPlayback(IMSVidInputDevice):
    """MS Video Control Playback Device Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{37B03538-A4C8-11D2-B634-00C04F79498E}')
    _idlflags_ = ['dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_EnableResetOnStop(self) -> hints.Incomplete: ...
        def _set_EnableResetOnStop(self, pVal: hints.Incomplete) -> hints.Hresult: ...
        EnableResetOnStop = hints.normal_property(_get_EnableResetOnStop, _set_EnableResetOnStop)
        def Run(self) -> hints.Hresult: ...
        def Pause(self) -> hints.Hresult: ...
        def Stop(self) -> hints.Hresult: ...
        def _get_CanStep(self, fBackwards: hints.Incomplete) -> hints.Incomplete: ...
        CanStep = hints.named_property('CanStep', _get_CanStep)
        def Step(self, lStep: hints.Incomplete) -> hints.Hresult: ...
        def _get_Rate(self) -> hints.Incomplete: ...
        def _set_Rate(self, plRate: hints.Incomplete) -> hints.Hresult: ...
        Rate = hints.normal_property(_get_Rate, _set_Rate)
        def _get_CurrentPosition(self) -> hints.Incomplete: ...
        def _set_CurrentPosition(self, lPosition: hints.Incomplete) -> hints.Hresult: ...
        CurrentPosition = hints.normal_property(_get_CurrentPosition, _set_CurrentPosition)
        def _get_PositionMode(self) -> hints.Incomplete: ...
        def _set_PositionMode(self, lPositionMode: hints.Incomplete) -> hints.Hresult: ...
        PositionMode = hints.normal_property(_get_PositionMode, _set_PositionMode)
        def _get_Length(self) -> hints.Incomplete: ...
        Length = hints.normal_property(_get_Length)


class IMSVidFilePlayback(IMSVidPlayback):
    """MS Video Control File Playback Device Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{37B03539-A4C8-11D2-B634-00C04F79498E}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_FileName(self) -> hints.Incomplete: ...
        def _set_FileName(self, FileName: hints.Incomplete) -> hints.Hresult: ...
        FileName = hints.normal_property(_get_FileName, _set_FileName)


class IMSVidStreamBufferSource(IMSVidFilePlayback):
    """MS Video Control Stream Buffer Source Device Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{EB0C8CF9-6950-4772-87B1-47D11CF3A02F}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_Start(self) -> hints.Incomplete: ...
        Start = hints.normal_property(_get_Start)
        def _get_RecordingAttribute(self) -> hints.Incomplete: ...
        RecordingAttribute = hints.normal_property(_get_RecordingAttribute)
        def CurrentRatings(self) -> hints.Tuple[hints.Incomplete, hints.Incomplete, hints.Incomplete]: ...
        def MaxRatingsLevel(self, enSystem: hints.Incomplete, enRating: hints.Incomplete, lbfEnAttr: hints.Incomplete) -> hints.Hresult: ...
        def _set_BlockUnrated(self, rhs: hints.Incomplete) -> hints.Hresult: ...
        BlockUnrated = hints.normal_property(fset=_set_BlockUnrated)
        def _set_UnratedDelay(self, rhs: hints.Incomplete) -> hints.Hresult: ...
        UnratedDelay = hints.normal_property(fset=_set_UnratedDelay)
        def _get_SBESource(self) -> hints.Incomplete: ...
        SBESource = hints.normal_property(_get_SBESource)


class IMSVidStreamBufferSource2(IMSVidStreamBufferSource):
    """MS Video Control Stream Buffer Source Device Interface 2"""
    _case_insensitive_ = True
    _iid_ = GUID('{E4BA9059-B1CE-40D8-B9A0-D4EA4A9989D3}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _set_RateEx(self, dwRate: hints.Incomplete, rhs: hints.Incomplete) -> hints.Hresult: ...
        RateEx = hints.named_property('RateEx', fset=_set_RateEx)
        def _get_AudioCounter(self) -> hints.Incomplete: ...
        AudioCounter = hints.normal_property(_get_AudioCounter)
        def _get_VideoCounter(self) -> hints.Incomplete: ...
        VideoCounter = hints.normal_property(_get_VideoCounter)
        def _get_CCCounter(self) -> hints.Incomplete: ...
        CCCounter = hints.normal_property(_get_CCCounter)
        def _get_WSTCounter(self) -> hints.Incomplete: ...
        WSTCounter = hints.normal_property(_get_WSTCounter)


class IMSVidInputDeviceEvent(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """MS Video Control Input Device Event Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{37B0353E-A4C8-11D2-B634-00C04F79498E}')
    _idlflags_ = ['oleautomation', 'proxy']


class IMSVidPlaybackEvent(IMSVidInputDeviceEvent):
    """MS Video Control Playback Device Event Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{37B0353B-A4C8-11D2-B634-00C04F79498E}')
    _idlflags_ = ['oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def EndOfMedia(self, lpd: hints.Incomplete) -> hints.Hresult: ...


class IMSVidFilePlaybackEvent(IMSVidPlaybackEvent):
    """MS Video Control File Playback Device Event Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{37B0353A-A4C8-11D2-B634-00C04F79498E}')
    _idlflags_ = ['hidden', 'oleautomation', 'proxy']


class IMSVidStreamBufferSourceEvent(IMSVidFilePlaybackEvent):
    """MS Video Control Stream Buffer Source Device Event Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{50CE8A7D-9C28-4DA8-9042-CDFA7116F979}')
    _idlflags_ = ['hidden', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def CertificateFailure(self) -> hints.Hresult: ...
        def CertificateSuccess(self) -> hints.Hresult: ...
        def RatingsBlocked(self) -> hints.Hresult: ...
        def RatingsUnblocked(self) -> hints.Hresult: ...
        def RatingsChanged(self) -> hints.Hresult: ...
        def TimeHole(self, StreamOffsetMS: hints.Incomplete, SizeMS: hints.Incomplete) -> hints.Hresult: ...
        def StaleDataRead(self) -> hints.Hresult: ...
        def ContentBecomingStale(self) -> hints.Hresult: ...
        def StaleFileDeleted(self) -> hints.Hresult: ...


class IMSVidStreamBufferSourceEvent2(IMSVidStreamBufferSourceEvent):
    """MS Video Control Stream Buffer Source Device Event2 Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{7AEF50CE-8E22-4BA8-BC06-A92A458B4EF2}')
    _idlflags_ = ['hidden', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def RateChange(self, qwNewRate: hints.Incomplete, qwOldRate: hints.Incomplete) -> hints.Hresult: ...


class IMSVidStreamBufferSourceEvent3(IMSVidStreamBufferSourceEvent2):
    """MS Video Control Stream Buffer Source Device Event3 Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{CEABD6AB-9B90-4570-ADF1-3CE76E00A763}')
    _idlflags_ = ['hidden', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def BroadcastEvent(self, Guid: hints.Incomplete) -> hints.Hresult: ...
        def BroadcastEventEx(self, Guid: hints.Incomplete, Param1: hints.Incomplete, Param2: hints.Incomplete, Param3: hints.Incomplete, Param4: hints.Incomplete) -> hints.Hresult: ...
        def COPPBlocked(self) -> hints.Hresult: ...
        def COPPUnblocked(self) -> hints.Hresult: ...
        def ContentPrimarilyAudio(self) -> hints.Hresult: ...


MSVidStreamBufferSource._com_interfaces_ = [IMSVidStreamBufferSource2, IMSVidStreamBufferSource, IMSVidGraphSegment]
MSVidStreamBufferSource._outgoing_interfaces_ = [IMSVidStreamBufferSourceEvent3, IMSVidStreamBufferSourceEvent, IMSVidStreamBufferSourceEvent2]


class IMSVidWebDVDAdm(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """IMSVidWebDVDAdm Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{B8BE681A-EB2C-47F0-B415-94D5452F0E05}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def ChangePassword(self, strUserName: hints.Incomplete, strOld: hints.Incomplete, strNew: hints.Incomplete) -> hints.Hresult: ...
        def SaveParentalLevel(self, level: hints.Incomplete, strUserName: hints.Incomplete, strPassword: hints.Incomplete) -> hints.Hresult: ...
        def SaveParentalCountry(self, country: hints.Incomplete, strUserName: hints.Incomplete, strPassword: hints.Incomplete) -> hints.Hresult: ...
        def ConfirmPassword(self, strUserName: hints.Incomplete, strPassword: hints.Incomplete) -> hints.Incomplete: ...
        def GetParentalLevel(self) -> hints.Incomplete: ...
        def GetParentalCountry(self) -> hints.Incomplete: ...
        def _get_DefaultAudioLCID(self) -> hints.Incomplete: ...
        def _set_DefaultAudioLCID(self, pVal: hints.Incomplete) -> hints.Hresult: ...
        DefaultAudioLCID = hints.normal_property(_get_DefaultAudioLCID, _set_DefaultAudioLCID)
        def _get_DefaultSubpictureLCID(self) -> hints.Incomplete: ...
        def _set_DefaultSubpictureLCID(self, pVal: hints.Incomplete) -> hints.Hresult: ...
        DefaultSubpictureLCID = hints.normal_property(_get_DefaultSubpictureLCID, _set_DefaultSubpictureLCID)
        def _get_DefaultMenuLCID(self) -> hints.Incomplete: ...
        def _set_DefaultMenuLCID(self, pVal: hints.Incomplete) -> hints.Hresult: ...
        DefaultMenuLCID = hints.normal_property(_get_DefaultMenuLCID, _set_DefaultMenuLCID)
        def _get_BookmarkOnStop(self) -> hints.Incomplete: ...
        def _set_BookmarkOnStop(self, pVal: hints.Incomplete) -> hints.Hresult: ...
        BookmarkOnStop = hints.normal_property(_get_BookmarkOnStop, _set_BookmarkOnStop)


IMSVidWebDVDAdm._methods_ = [
    COMMETHOD(
        [dispid(149), helpstring('method ChangePassword')],
        HRESULT,
        'ChangePassword',
        (['in'], BSTR, 'strUserName'),
        (['in'], BSTR, 'strOld'),
        (['in'], BSTR, 'strNew')
    ),
    COMMETHOD(
        [dispid(150), helpstring('method SaveParentalLevel')],
        HRESULT,
        'SaveParentalLevel',
        (['in'], c_int, 'level'),
        (['in'], BSTR, 'strUserName'),
        (['in'], BSTR, 'strPassword')
    ),
    COMMETHOD(
        [dispid(151), helpstring('method SaveParentalCountry')],
        HRESULT,
        'SaveParentalCountry',
        (['in'], c_int, 'country'),
        (['in'], BSTR, 'strUserName'),
        (['in'], BSTR, 'strPassword')
    ),
    COMMETHOD(
        [dispid(152), helpstring('method ConfirmPassword'), 'restricted', 'hidden'],
        HRESULT,
        'ConfirmPassword',
        (['in'], BSTR, 'strUserName'),
        (['in'], BSTR, 'strPassword'),
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'pVal')
    ),
    COMMETHOD(
        [dispid(153), helpstring('method GetParentalLevel')],
        HRESULT,
        'GetParentalLevel',
        (['out', 'retval'], POINTER(c_int), 'lLevel')
    ),
    COMMETHOD(
        [dispid(154), helpstring('method GetParentalCountry')],
        HRESULT,
        'GetParentalCountry',
        (['out', 'retval'], POINTER(c_int), 'lCountry')
    ),
    COMMETHOD(
        [dispid(155), helpstring('property DefaultAudioLCID'), 'propget'],
        HRESULT,
        'DefaultAudioLCID',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(155), helpstring('property DefaultAudioLCID'), 'propput'],
        HRESULT,
        'DefaultAudioLCID',
        (['in'], c_int, 'pVal')
    ),
    COMMETHOD(
        [dispid(156), helpstring('property DefaultSubpictureLCID'), 'propget'],
        HRESULT,
        'DefaultSubpictureLCID',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(156), helpstring('property DefaultSubpictureLCID'), 'propput'],
        HRESULT,
        'DefaultSubpictureLCID',
        (['in'], c_int, 'pVal')
    ),
    COMMETHOD(
        [dispid(157), helpstring('property DefaultMenuLCID'), 'propget'],
        HRESULT,
        'DefaultMenuLCID',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(157), helpstring('property DefaultMenuLCID'), 'propput'],
        HRESULT,
        'DefaultMenuLCID',
        (['in'], c_int, 'pVal')
    ),
    COMMETHOD(
        [dispid(158), helpstring('property BookmarkOnStop'), 'propget'],
        HRESULT,
        'BookmarkOnStop',
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'pVal')
    ),
    COMMETHOD(
        [dispid(158), helpstring('property BookmarkOnStop'), 'propput'],
        HRESULT,
        'BookmarkOnStop',
        (['in'], VARIANT_BOOL, 'pVal')
    ),
]

################################################################
# code template for IMSVidWebDVDAdm implementation
# class IMSVidWebDVDAdm_Impl(object):
#     def ChangePassword(self, strUserName, strOld, strNew):
#         'method ChangePassword'
#         #return 
#
#     def SaveParentalLevel(self, level, strUserName, strPassword):
#         'method SaveParentalLevel'
#         #return 
#
#     def SaveParentalCountry(self, country, strUserName, strPassword):
#         'method SaveParentalCountry'
#         #return 
#
#     def ConfirmPassword(self, strUserName, strPassword):
#         'method ConfirmPassword'
#         #return pVal
#
#     def GetParentalLevel(self):
#         'method GetParentalLevel'
#         #return lLevel
#
#     def GetParentalCountry(self):
#         'method GetParentalCountry'
#         #return lCountry
#
#     def _get(self):
#         'property DefaultAudioLCID'
#         #return pVal
#     def _set(self, pVal):
#         'property DefaultAudioLCID'
#     DefaultAudioLCID = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'property DefaultSubpictureLCID'
#         #return pVal
#     def _set(self, pVal):
#         'property DefaultSubpictureLCID'
#     DefaultSubpictureLCID = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'property DefaultMenuLCID'
#         #return pVal
#     def _set(self, pVal):
#         'property DefaultMenuLCID'
#     DefaultMenuLCID = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'property BookmarkOnStop'
#         #return pVal
#     def _set(self, pVal):
#         'property BookmarkOnStop'
#     BookmarkOnStop = property(_get, _set, doc = _set.__doc__)
#


class tagCALPWSTR(Structure):
    pass


tagCALPWSTR._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(WSTRING)),
]

assert sizeof(tagCALPWSTR) == 16, sizeof(tagCALPWSTR)
assert alignment(tagCALPWSTR) == 8, alignment(tagCALPWSTR)

IMSVidVideoRendererEvent._methods_ = [
    COMMETHOD(
        [helpstring('HW Overlay surface in use or not present')],
        HRESULT,
        'OverlayUnavailable',
    ),
]

################################################################
# code template for IMSVidVideoRendererEvent implementation
# class IMSVidVideoRendererEvent_Impl(object):
#     def OverlayUnavailable(self):
#         'HW Overlay surface in use or not present'
#         #return 
#


class IMediaFilter(IPersist):
    _case_insensitive_ = True
    _iid_ = GUID('{56A86899-0AD4-11CE-B03A-0020AF0BA770}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def Stop(self) -> hints.Hresult: ...
        def Pause(self) -> hints.Hresult: ...
        def Run(self, tStart: hints.Incomplete) -> hints.Hresult: ...
        def GetState(self, dwMilliSecsTimeout: hints.Incomplete) -> hints.Incomplete: ...
        def SetSyncSource(self, pClock: hints.Incomplete) -> hints.Hresult: ...
        def GetSyncSource(self) -> 'IReferenceClock': ...


class IBaseFilter(IMediaFilter):
    _case_insensitive_ = True
    _iid_ = GUID('{56A86895-0AD4-11CE-B03A-0020AF0BA770}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def EnumPins(self) -> 'IEnumPins': ...
        def FindPin(self, Id: hints.Incomplete) -> 'IPin': ...
        def QueryFilterInfo(self) -> hints.Incomplete: ...
        def JoinFilterGraph(self, pGraph: hints.Incomplete, pName: hints.Incomplete) -> hints.Hresult: ...
        def QueryVendorInfo(self) -> hints.Incomplete: ...


_PinInfo._fields_ = [
    ('pFilter', POINTER(IBaseFilter)),
    ('dir', _PinDirection),
    ('achName', c_ushort * 128),
]

assert sizeof(_PinInfo) == 272, sizeof(_PinInfo)
assert alignment(_PinInfo) == 8, alignment(_PinInfo)

tagRemSNB._pack_ = 4

tagRemSNB._fields_ = [
    ('ulCntStr', c_ulong),
    ('ulCntChar', c_ulong),
    ('rgString', POINTER(c_ushort)),
]

assert sizeof(tagRemSNB) == 16, sizeof(tagRemSNB)
assert alignment(tagRemSNB) == 4, alignment(tagRemSNB)


class MSVidVMR9(CoClass):
    """MS Video Control Video Renderer 9(DX9) Class"""
    _reg_clsid_ = GUID('{24DC3975-09BF-4231-8655-3EE71F43837D}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


class IMSVidVMR9(IMSVidVideoRenderer):
    """MS Video Control Video Mixing Renderer 9(DX9) Device Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{D58B0015-EBEF-44BB-BBDD-3F3699D76EA1}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_Allocator_ID(self) -> hints.Incomplete: ...
        Allocator_ID = hints.normal_property(_get_Allocator_ID)
        def SetAllocator(self, AllocPresent: hints.Incomplete, Id: hints.Incomplete = ...) -> hints.Hresult: ...
        def _get_SuppressEffects(self) -> hints.Incomplete: ...
        def _set_SuppressEffects(self, bSuppress: hints.Incomplete) -> hints.Hresult: ...
        SuppressEffects = hints.normal_property(_get_SuppressEffects, _set_SuppressEffects)
        def _get_Allocator(self) -> hints.Incomplete: ...
        Allocator = hints.normal_property(_get_Allocator)


MSVidVMR9._com_interfaces_ = [IMSVidVMR9, IMSVidGraphSegment]


class tagCAPROPVARIANT(Structure):
    pass


class tag_inner_PROPVARIANT(Structure):
    pass


tagCAPROPVARIANT._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(tag_inner_PROPVARIANT)),
]

assert sizeof(tagCAPROPVARIANT) == 16, sizeof(tagCAPROPVARIANT)
assert alignment(tagCAPROPVARIANT) == 8, alignment(tagCAPROPVARIANT)


class IVMRImageCompositor(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    """IVMRImageCompositor Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{7A4FB5AF-479F-4074-BB40-CE6722E43C82}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def InitCompositionTarget(self, pD3DDevice: hints.Incomplete, pddsRenderTarget: hints.Incomplete) -> hints.Hresult: ...
        def TermCompositionTarget(self, pD3DDevice: hints.Incomplete, pddsRenderTarget: hints.Incomplete) -> hints.Hresult: ...
        def SetStreamMediaType(self, dwStrmID: hints.Incomplete, pmt: hints.Incomplete, fTexture: hints.Incomplete) -> hints.Hresult: ...
        def CompositeImage(self, pD3DDevice: hints.Incomplete, pddsRenderTarget: hints.Incomplete, pmtRenderTarget: hints.Incomplete, rtStart: hints.Incomplete, rtEnd: hints.Incomplete, dwClrBkGnd: hints.Incomplete, pVideoStreamInfo: hints.Incomplete, cStreams: hints.Incomplete) -> hints.Hresult: ...


class IVMRMixerBitmap(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    """IVMRMixerBitmap Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{1E673275-0257-40AA-AF20-7C608D4A0428}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def SetAlphaBitmap(self, pBmpParms: hints.Incomplete) -> hints.Hresult: ...
        def UpdateAlphaBitmapParameters(self, pBmpParms: hints.Incomplete) -> hints.Hresult: ...
        def GetAlphaBitmapParameters(self) -> hints.Incomplete: ...


class _VMRALPHABITMAP(Structure):
    pass


class IMSVidRect(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """Automation Compliant GDI Rect with Automatic HWND Scaling"""
    _case_insensitive_ = True
    _iid_ = GUID('{7F5000A6-A440-47CA-8ACC-C0E75531A2C2}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def _get_Top(self) -> hints.Incomplete: ...
        def _set_Top(self, TopVal: hints.Incomplete) -> hints.Hresult: ...
        Top = hints.normal_property(_get_Top, _set_Top)
        def _get_Left(self) -> hints.Incomplete: ...
        def _set_Left(self, LeftVal: hints.Incomplete) -> hints.Hresult: ...
        Left = hints.normal_property(_get_Left, _set_Left)
        def _get_Width(self) -> hints.Incomplete: ...
        def _set_Width(self, WidthVal: hints.Incomplete) -> hints.Hresult: ...
        Width = hints.normal_property(_get_Width, _set_Width)
        def _get_Height(self) -> hints.Incomplete: ...
        def _set_Height(self, HeightVal: hints.Incomplete) -> hints.Hresult: ...
        Height = hints.normal_property(_get_Height, _set_Height)
        def _get_HWnd(self) -> hints.Incomplete: ...
        def _set_HWnd(self, HWndVal: hints.Incomplete) -> hints.Hresult: ...
        HWnd = hints.normal_property(_get_HWnd, _set_HWnd)
        def _set_Rect(self, rhs: hints.Incomplete) -> hints.Hresult: ...
        Rect = hints.normal_property(fset=_set_Rect)


IMSVidVideoRenderer._methods_ = [
    COMMETHOD(
        [dispid(134), 'propget'],
        HRESULT,
        'CustomCompositorClass',
        (['out', 'retval'], POINTER(BSTR), 'CompositorCLSID')
    ),
    COMMETHOD(
        [dispid(134), 'propput'],
        HRESULT,
        'CustomCompositorClass',
        (['in'], BSTR, 'CompositorCLSID')
    ),
    COMMETHOD(
        [dispid(133), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_CustomCompositorClass',
        (
            ['out', 'retval'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'CompositorCLSID',
        )
    ),
    COMMETHOD(
        [dispid(133), 'restricted', 'hidden', 'propput'],
        HRESULT,
        '_CustomCompositorClass',
        (
            ['in'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'CompositorCLSID',
        )
    ),
    COMMETHOD(
        [dispid(135), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_CustomCompositor',
        (['out', 'retval'], POINTER(POINTER(IVMRImageCompositor)), 'Compositor')
    ),
    COMMETHOD(
        [dispid(135), 'restricted', 'hidden', 'propput'],
        HRESULT,
        '_CustomCompositor',
        (['in'], POINTER(IVMRImageCompositor), 'Compositor')
    ),
    COMMETHOD(
        [dispid(136), 'propget'],
        HRESULT,
        'MixerBitmap',
        (
            ['out', 'retval'],
            POINTER(POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IPictureDisp)),
            'MixerPictureDisp',
        )
    ),
    COMMETHOD(
        [dispid(137), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_MixerBitmap',
        (['out', 'retval'], POINTER(POINTER(IVMRMixerBitmap)), 'MixerPicture')
    ),
    COMMETHOD(
        [dispid(136), 'propput'],
        HRESULT,
        'MixerBitmap',
        (
            ['in'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IPictureDisp),
            'MixerPictureDisp',
        )
    ),
    COMMETHOD(
        [dispid(137), 'restricted', 'hidden', 'propput'],
        HRESULT,
        '_MixerBitmap',
        (['in'], POINTER(_VMRALPHABITMAP), 'MixerPicture')
    ),
    COMMETHOD(
        [dispid(139), 'propget'],
        HRESULT,
        'MixerBitmapPositionRect',
        (['out', 'retval'], POINTER(POINTER(IMSVidRect)), 'rDest')
    ),
    COMMETHOD(
        [dispid(139), 'propput'],
        HRESULT,
        'MixerBitmapPositionRect',
        (['in'], POINTER(IMSVidRect), 'rDest')
    ),
    COMMETHOD(
        [dispid(138), 'propget'],
        HRESULT,
        'MixerBitmapOpacity',
        (['out', 'retval'], POINTER(c_int), 'opacity')
    ),
    COMMETHOD(
        [dispid(138), 'propput'],
        HRESULT,
        'MixerBitmapOpacity',
        (['in'], c_int, 'opacity')
    ),
    COMMETHOD(
        [dispid(140)],
        HRESULT,
        'SetupMixerBitmap',
        (
            ['in'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IPictureDisp),
            'MixerPictureDisp',
        ),
        (['in'], c_int, 'opacity'),
        (['in'], POINTER(IMSVidRect), 'rDest')
    ),
    COMMETHOD(
        [dispid(41), 'propget'],
        HRESULT,
        'SourceSize',
        (['out', 'retval'], POINTER(SourceSizeList), 'CurrentSize')
    ),
    COMMETHOD(
        [dispid(41), 'propput'],
        HRESULT,
        'SourceSize',
        (['in'], SourceSizeList, 'CurrentSize')
    ),
    COMMETHOD(
        [dispid(5), helpstring('trim each source edge by this amount(in hundredths of percent, e.g. 1.75% == 175)'), 'propget'],
        HRESULT,
        'OverScan',
        (['out', 'retval'], POINTER(c_int), 'plPercent')
    ),
    COMMETHOD(
        [dispid(5), helpstring('trim each source edge by this amount(in hundredths of percent, e.g. 1.75% == 175)'), 'propput'],
        HRESULT,
        'OverScan',
        (['in'], c_int, 'plPercent')
    ),
    COMMETHOD(
        [dispid(33), 'propget'],
        HRESULT,
        'AvailableSourceRect',
        (['out', 'retval'], POINTER(POINTER(IMSVidRect)), 'pRect')
    ),
    COMMETHOD(
        [dispid(159), 'propget'],
        HRESULT,
        'MaxVidRect',
        (['out', 'retval'], POINTER(POINTER(IMSVidRect)), 'ppVidRect')
    ),
    COMMETHOD(
        [dispid(160), 'propget'],
        HRESULT,
        'MinVidRect',
        (['out', 'retval'], POINTER(POINTER(IMSVidRect)), 'ppVidRect')
    ),
    COMMETHOD(
        [dispid(32), 'propget'],
        HRESULT,
        'ClippedSourceRect',
        (['out', 'retval'], POINTER(POINTER(IMSVidRect)), 'pRect')
    ),
    COMMETHOD(
        [dispid(32), 'propput'],
        HRESULT,
        'ClippedSourceRect',
        (['in'], POINTER(IMSVidRect), 'pRect')
    ),
    COMMETHOD(
        [dispid(141), 'propget'],
        HRESULT,
        'UsingOverlay',
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'UseOverlayVal')
    ),
    COMMETHOD(
        [dispid(141), 'propput'],
        HRESULT,
        'UsingOverlay',
        (['in'], VARIANT_BOOL, 'UseOverlayVal')
    ),
    COMMETHOD(
        [dispid(161)],
        HRESULT,
        'Capture',
        (
            ['out', 'retval'],
            POINTER(POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IPictureDisp)),
            'currentImage',
        )
    ),
    COMMETHOD(
        [dispid(80), helpstring('FramesPerSecond'), 'propget'],
        HRESULT,
        'FramesPerSecond',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(162), helpstring('DecimateInput'), 'propget'],
        HRESULT,
        'DecimateInput',
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'pDeci')
    ),
    COMMETHOD(
        [dispid(162), helpstring('DecimateInput'), 'propput'],
        HRESULT,
        'DecimateInput',
        (['in'], VARIANT_BOOL, 'pDeci')
    ),
]

################################################################
# code template for IMSVidVideoRenderer implementation
# class IMSVidVideoRenderer_Impl(object):
#     def _get(self):
#         '-no docstring-'
#         #return CompositorCLSID
#     def _set(self, CompositorCLSID):
#         '-no docstring-'
#     CustomCompositorClass = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         '-no docstring-'
#         #return CompositorCLSID
#     def _set(self, CompositorCLSID):
#         '-no docstring-'
#     _CustomCompositorClass = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         '-no docstring-'
#         #return Compositor
#     def _set(self, Compositor):
#         '-no docstring-'
#     _CustomCompositor = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         '-no docstring-'
#         #return MixerPictureDisp
#     def _set(self, MixerPictureDisp):
#         '-no docstring-'
#     MixerBitmap = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         '-no docstring-'
#         #return MixerPicture
#     def _set(self, MixerPicture):
#         '-no docstring-'
#     _MixerBitmap = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         '-no docstring-'
#         #return rDest
#     def _set(self, rDest):
#         '-no docstring-'
#     MixerBitmapPositionRect = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         '-no docstring-'
#         #return opacity
#     def _set(self, opacity):
#         '-no docstring-'
#     MixerBitmapOpacity = property(_get, _set, doc = _set.__doc__)
#
#     def SetupMixerBitmap(self, MixerPictureDisp, opacity, rDest):
#         '-no docstring-'
#         #return 
#
#     def _get(self):
#         '-no docstring-'
#         #return CurrentSize
#     def _set(self, CurrentSize):
#         '-no docstring-'
#     SourceSize = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'trim each source edge by this amount(in hundredths of percent, e.g. 1.75% == 175)'
#         #return plPercent
#     def _set(self, plPercent):
#         'trim each source edge by this amount(in hundredths of percent, e.g. 1.75% == 175)'
#     OverScan = property(_get, _set, doc = _set.__doc__)
#
#     @property
#     def AvailableSourceRect(self):
#         '-no docstring-'
#         #return pRect
#
#     @property
#     def MaxVidRect(self):
#         '-no docstring-'
#         #return ppVidRect
#
#     @property
#     def MinVidRect(self):
#         '-no docstring-'
#         #return ppVidRect
#
#     def _get(self):
#         '-no docstring-'
#         #return pRect
#     def _set(self, pRect):
#         '-no docstring-'
#     ClippedSourceRect = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         '-no docstring-'
#         #return UseOverlayVal
#     def _set(self, UseOverlayVal):
#         '-no docstring-'
#     UsingOverlay = property(_get, _set, doc = _set.__doc__)
#
#     def Capture(self):
#         '-no docstring-'
#         #return currentImage
#
#     @property
#     def FramesPerSecond(self):
#         'FramesPerSecond'
#         #return pVal
#
#     def _get(self):
#         'DecimateInput'
#         #return pDeci
#     def _set(self, pDeci):
#         'DecimateInput'
#     DecimateInput = property(_get, _set, doc = _set.__doc__)
#


class IVMRSurfaceAllocator(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    """IVMRSurfaceAllocator Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{31CE832E-4484-458B-8CCA-F4D7E3DB0B52}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def AllocateSurface(self, dwUserID: hints.Incomplete, lpAllocInfo: hints.Incomplete, lpdwActualBuffers: hints.Incomplete) -> hints.Tuple[hints.Incomplete, hints.Incomplete]: ...
        def FreeSurface(self, dwID: hints.Incomplete) -> hints.Hresult: ...
        def PrepareSurface(self, dwUserID: hints.Incomplete, lpSurface: hints.Incomplete, dwSurfaceFlags: hints.Incomplete) -> hints.Hresult: ...
        def AdviseNotify(self, lpIVMRSurfAllocNotify: hints.Incomplete) -> hints.Hresult: ...


IMSVidVideoRenderer2._methods_ = [
    COMMETHOD(
        [dispid(163), 'propget'],
        HRESULT,
        'Allocator',
        (['out', 'retval'], POINTER(POINTER(IUnknown)), 'AllocPresent')
    ),
    COMMETHOD(
        [dispid(164), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_Allocator',
        (
            ['out', 'retval'],
            POINTER(POINTER(IVMRSurfaceAllocator)),
            'AllocPresent',
        )
    ),
    COMMETHOD(
        [dispid(165), 'propget'],
        HRESULT,
        'Allocator_ID',
        (['out', 'retval'], POINTER(c_int), 'Id')
    ),
    COMMETHOD(
        [dispid(166)],
        HRESULT,
        'SetAllocator',
        (['in'], POINTER(IUnknown), 'AllocPresent'),
        (['in', 'optional'], c_int, 'Id', -1)
    ),
    COMMETHOD(
        [dispid(167), 'restricted', 'hidden'],
        HRESULT,
        '_SetAllocator',
        (['in'], POINTER(IVMRSurfaceAllocator), 'AllocPresent'),
        (['in', 'optional'], c_int, 'Id', -1)
    ),
    COMMETHOD(
        [dispid(189), 'propput'],
        HRESULT,
        'SuppressEffects',
        (['in'], VARIANT_BOOL, 'bSuppress')
    ),
    COMMETHOD(
        [dispid(189), 'propget'],
        HRESULT,
        'SuppressEffects',
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'bSuppress')
    ),
]

################################################################
# code template for IMSVidVideoRenderer2 implementation
# class IMSVidVideoRenderer2_Impl(object):
#     @property
#     def Allocator(self):
#         '-no docstring-'
#         #return AllocPresent
#
#     @property
#     def _Allocator(self):
#         '-no docstring-'
#         #return AllocPresent
#
#     @property
#     def Allocator_ID(self):
#         '-no docstring-'
#         #return Id
#
#     def SetAllocator(self, AllocPresent, Id):
#         '-no docstring-'
#         #return 
#
#     def _SetAllocator(self, AllocPresent, Id):
#         '-no docstring-'
#         #return 
#
#     def _get(self):
#         '-no docstring-'
#         #return bSuppress
#     def _set(self, bSuppress):
#         '-no docstring-'
#     SuppressEffects = property(_get, _set, doc = _set.__doc__)
#

IMSVidStreamBufferRecordingControl._methods_ = [
    COMMETHOD(
        [dispid(172), helpstring('method StartTime, values in milliseconds'), 'propget'],
        HRESULT,
        'startTime',
        (['out', 'retval'], POINTER(c_int), 'rtStart')
    ),
    COMMETHOD(
        [dispid(172), helpstring('method StartTime, values in milliseconds'), 'propput'],
        HRESULT,
        'startTime',
        (['in'], c_int, 'rtStart')
    ),
    COMMETHOD(
        [dispid(173), helpstring('method StopTime, values in milliseconds'), 'propget'],
        HRESULT,
        'StopTime',
        (['out', 'retval'], POINTER(c_int), 'rtStop')
    ),
    COMMETHOD(
        [dispid(173), helpstring('method StopTime, values in milliseconds'), 'propput'],
        HRESULT,
        'StopTime',
        (['in'], c_int, 'rtStop')
    ),
    COMMETHOD(
        [dispid(174), helpstring('method RecordingStopped'), 'propget'],
        HRESULT,
        'RecordingStopped',
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'phResult')
    ),
    COMMETHOD(
        [dispid(175), helpstring('method RecordingStarted'), 'propget'],
        HRESULT,
        'RecordingStarted',
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'phResult')
    ),
    COMMETHOD(
        [dispid(177), helpstring('property returns type of recording object'), 'propget'],
        HRESULT,
        'RecordingType',
        (['out', 'retval'], POINTER(RecordingType), 'dwType')
    ),
    COMMETHOD(
        [dispid(179), helpstring('get Recording Attribute interface'), 'propget'],
        HRESULT,
        'RecordingAttribute',
        (['out', 'retval'], POINTER(POINTER(IUnknown)), 'pRecordingAttribute')
    ),
]

################################################################
# code template for IMSVidStreamBufferRecordingControl implementation
# class IMSVidStreamBufferRecordingControl_Impl(object):
#     def _get(self):
#         'method StartTime, values in milliseconds'
#         #return rtStart
#     def _set(self, rtStart):
#         'method StartTime, values in milliseconds'
#     startTime = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'method StopTime, values in milliseconds'
#         #return rtStop
#     def _set(self, rtStop):
#         'method StopTime, values in milliseconds'
#     StopTime = property(_get, _set, doc = _set.__doc__)
#
#     @property
#     def RecordingStopped(self):
#         'method RecordingStopped'
#         #return phResult
#
#     @property
#     def RecordingStarted(self):
#         'method RecordingStarted'
#         #return phResult
#
#     @property
#     def RecordingType(self):
#         'property returns type of recording object'
#         #return dwType
#
#     @property
#     def RecordingAttribute(self):
#         'get Recording Attribute interface'
#         #return pRecordingAttribute
#


class _MFVideoSurfaceInfo(Structure):
    pass


class _MFPaletteEntry(Union):
    pass


_MFVideoSurfaceInfo._pack_ = 4

_MFVideoSurfaceInfo._fields_ = [
    ('Format', c_ulong),
    ('PaletteEntries', c_ulong),
    ('Palette', POINTER(_MFPaletteEntry)),
]

assert sizeof(_MFVideoSurfaceInfo) == 16, sizeof(_MFVideoSurfaceInfo)
assert alignment(_MFVideoSurfaceInfo) == 4, alignment(_MFVideoSurfaceInfo)


class _MFVideoCompressedInfo(Structure):
    pass


_MFVideoCompressedInfo._fields_ = [
    ('AvgBitrate', c_longlong),
    ('AvgBitErrorRate', c_longlong),
    ('MaxKeyFrameSpacing', c_ulong),
]

assert sizeof(_MFVideoCompressedInfo) == 24, sizeof(_MFVideoCompressedInfo)
assert alignment(_MFVideoCompressedInfo) == 8, alignment(_MFVideoCompressedInfo)


class IEnumMoniker(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    _case_insensitive_ = True
    _iid_ = GUID('{00000102-0000-0000-C000-000000000046}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def RemoteNext(self, celt: hints.Incomplete) -> hints.Tuple['IMoniker', hints.Incomplete]: ...
        def Skip(self, celt: hints.Incomplete) -> hints.Hresult: ...
        def Reset(self) -> hints.Hresult: ...
        def Clone(self) -> 'IEnumMoniker': ...


class IPersistStream(IPersist):
    _case_insensitive_ = True
    _iid_ = GUID('{00000109-0000-0000-C000-000000000046}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def IsDirty(self) -> hints.Hresult: ...
        def Load(self, pstm: hints.Incomplete) -> hints.Hresult: ...
        def Save(self, pstm: hints.Incomplete, fClearDirty: hints.Incomplete) -> hints.Hresult: ...
        def GetSizeMax(self) -> hints.Incomplete: ...


class IMoniker(IPersistStream):
    _case_insensitive_ = True
    _iid_ = GUID('{0000000F-0000-0000-C000-000000000046}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def RemoteBindToObject(self, pbc: hints.Incomplete, pmkToLeft: hints.Incomplete, riidResult: hints.Incomplete) -> hints.Incomplete: ...
        def RemoteBindToStorage(self, pbc: hints.Incomplete, pmkToLeft: hints.Incomplete, riid: hints.Incomplete) -> hints.Incomplete: ...
        def Reduce(self, pbc: hints.Incomplete, dwReduceHowFar: hints.Incomplete, ppmkToLeft: hints.Incomplete) -> hints.Tuple['IMoniker', 'IMoniker']: ...
        def ComposeWith(self, pmkRight: hints.Incomplete, fOnlyIfNotGeneric: hints.Incomplete) -> 'IMoniker': ...
        def Enum(self, fForward: hints.Incomplete) -> 'IEnumMoniker': ...
        def IsEqual(self, pmkOtherMoniker: hints.Incomplete) -> hints.Hresult: ...
        def Hash(self) -> hints.Incomplete: ...
        def IsRunning(self, pbc: hints.Incomplete, pmkToLeft: hints.Incomplete, pmkNewlyRunning: hints.Incomplete) -> hints.Hresult: ...
        def GetTimeOfLastChange(self, pbc: hints.Incomplete, pmkToLeft: hints.Incomplete) -> hints.Incomplete: ...
        def Inverse(self) -> 'IMoniker': ...
        def CommonPrefixWith(self, pmkOther: hints.Incomplete) -> 'IMoniker': ...
        def RelativePathTo(self, pmkOther: hints.Incomplete) -> 'IMoniker': ...
        def GetDisplayName(self, pbc: hints.Incomplete, pmkToLeft: hints.Incomplete) -> hints.Incomplete: ...
        def ParseDisplayName(self, pbc: hints.Incomplete, pmkToLeft: hints.Incomplete, pszDisplayName: hints.Incomplete) -> hints.Tuple[hints.Incomplete, 'IMoniker']: ...
        def IsSystemMoniker(self) -> hints.Incomplete: ...


IEnumMoniker._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'RemoteNext',
        (['in'], c_ulong, 'celt'),
        (['out'], POINTER(POINTER(IMoniker)), 'rgelt'),
        (['out'], POINTER(c_ulong), 'pceltFetched')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Skip',
        (['in'], c_ulong, 'celt')
    ),
    COMMETHOD([], HRESULT, 'Reset'),
    COMMETHOD(
        [],
        HRESULT,
        'Clone',
        (['out'], POINTER(POINTER(IEnumMoniker)), 'ppenum')
    ),
]

################################################################
# code template for IEnumMoniker implementation
# class IEnumMoniker_Impl(object):
#     def RemoteNext(self, celt):
#         '-no docstring-'
#         #return rgelt, pceltFetched
#
#     def Skip(self, celt):
#         '-no docstring-'
#         #return 
#
#     def Reset(self):
#         '-no docstring-'
#         #return 
#
#     def Clone(self):
#         '-no docstring-'
#         #return ppenum
#

IPersistStream._methods_ = [
    COMMETHOD([], HRESULT, 'IsDirty'),
    COMMETHOD(
        [],
        HRESULT,
        'Load',
        (['in'], POINTER(IStream), 'pstm')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Save',
        (['in'], POINTER(IStream), 'pstm'),
        (['in'], c_int, 'fClearDirty')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetSizeMax',
        (['out'], POINTER(_ULARGE_INTEGER), 'pcbSize')
    ),
]

################################################################
# code template for IPersistStream implementation
# class IPersistStream_Impl(object):
#     def IsDirty(self):
#         '-no docstring-'
#         #return 
#
#     def Load(self, pstm):
#         '-no docstring-'
#         #return 
#
#     def Save(self, pstm, fClearDirty):
#         '-no docstring-'
#         #return 
#
#     def GetSizeMax(self):
#         '-no docstring-'
#         #return pcbSize
#


class IBindCtx(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    _case_insensitive_ = True
    _iid_ = GUID('{0000000E-0000-0000-C000-000000000046}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def RegisterObjectBound(self, punk: hints.Incomplete) -> hints.Hresult: ...
        def RevokeObjectBound(self, punk: hints.Incomplete) -> hints.Hresult: ...
        def ReleaseBoundObjects(self) -> hints.Hresult: ...
        def RemoteSetBindOptions(self, pbindopts: hints.Incomplete) -> hints.Hresult: ...
        def RemoteGetBindOptions(self, pbindopts: hints.Incomplete) -> hints.Incomplete: ...
        def GetRunningObjectTable(self) -> 'IRunningObjectTable': ...
        def RegisterObjectParam(self, pszKey: hints.Incomplete, punk: hints.Incomplete) -> hints.Hresult: ...
        def GetObjectParam(self, pszKey: hints.Incomplete) -> hints.Incomplete: ...
        def EnumObjectParam(self) -> 'IEnumString': ...
        def RevokeObjectParam(self, pszKey: hints.Incomplete) -> hints.Hresult: ...


IMoniker._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'RemoteBindToObject',
        (['in'], POINTER(IBindCtx), 'pbc'),
        (['in'], POINTER(IMoniker), 'pmkToLeft'),
        (
            ['in'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'riidResult',
        ),
        (['out'], POINTER(POINTER(IUnknown)), 'ppvResult')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'RemoteBindToStorage',
        (['in'], POINTER(IBindCtx), 'pbc'),
        (['in'], POINTER(IMoniker), 'pmkToLeft'),
        (
            ['in'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'riid',
        ),
        (['out'], POINTER(POINTER(IUnknown)), 'ppvObj')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Reduce',
        (['in'], POINTER(IBindCtx), 'pbc'),
        (['in'], c_ulong, 'dwReduceHowFar'),
        (['in', 'out'], POINTER(POINTER(IMoniker)), 'ppmkToLeft'),
        (['out'], POINTER(POINTER(IMoniker)), 'ppmkReduced')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'ComposeWith',
        (['in'], POINTER(IMoniker), 'pmkRight'),
        (['in'], c_int, 'fOnlyIfNotGeneric'),
        (['out'], POINTER(POINTER(IMoniker)), 'ppmkComposite')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Enum',
        (['in'], c_int, 'fForward'),
        (['out'], POINTER(POINTER(IEnumMoniker)), 'ppenumMoniker')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'IsEqual',
        (['in'], POINTER(IMoniker), 'pmkOtherMoniker')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Hash',
        (['out'], POINTER(c_ulong), 'pdwHash')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'IsRunning',
        (['in'], POINTER(IBindCtx), 'pbc'),
        (['in'], POINTER(IMoniker), 'pmkToLeft'),
        (['in'], POINTER(IMoniker), 'pmkNewlyRunning')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetTimeOfLastChange',
        (['in'], POINTER(IBindCtx), 'pbc'),
        (['in'], POINTER(IMoniker), 'pmkToLeft'),
        (['out'], POINTER(_FILETIME), 'pfiletime')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Inverse',
        (['out'], POINTER(POINTER(IMoniker)), 'ppmk')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'CommonPrefixWith',
        (['in'], POINTER(IMoniker), 'pmkOther'),
        (['out'], POINTER(POINTER(IMoniker)), 'ppmkPrefix')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'RelativePathTo',
        (['in'], POINTER(IMoniker), 'pmkOther'),
        (['out'], POINTER(POINTER(IMoniker)), 'ppmkRelPath')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetDisplayName',
        (['in'], POINTER(IBindCtx), 'pbc'),
        (['in'], POINTER(IMoniker), 'pmkToLeft'),
        (['out'], POINTER(WSTRING), 'ppszDisplayName')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'ParseDisplayName',
        (['in'], POINTER(IBindCtx), 'pbc'),
        (['in'], POINTER(IMoniker), 'pmkToLeft'),
        (['in'], WSTRING, 'pszDisplayName'),
        (['out'], POINTER(c_ulong), 'pchEaten'),
        (['out'], POINTER(POINTER(IMoniker)), 'ppmkOut')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'IsSystemMoniker',
        (['out'], POINTER(c_ulong), 'pdwMksys')
    ),
]

################################################################
# code template for IMoniker implementation
# class IMoniker_Impl(object):
#     def RemoteBindToObject(self, pbc, pmkToLeft, riidResult):
#         '-no docstring-'
#         #return ppvResult
#
#     def RemoteBindToStorage(self, pbc, pmkToLeft, riid):
#         '-no docstring-'
#         #return ppvObj
#
#     def Reduce(self, pbc, dwReduceHowFar):
#         '-no docstring-'
#         #return ppmkToLeft, ppmkReduced
#
#     def ComposeWith(self, pmkRight, fOnlyIfNotGeneric):
#         '-no docstring-'
#         #return ppmkComposite
#
#     def Enum(self, fForward):
#         '-no docstring-'
#         #return ppenumMoniker
#
#     def IsEqual(self, pmkOtherMoniker):
#         '-no docstring-'
#         #return 
#
#     def Hash(self):
#         '-no docstring-'
#         #return pdwHash
#
#     def IsRunning(self, pbc, pmkToLeft, pmkNewlyRunning):
#         '-no docstring-'
#         #return 
#
#     def GetTimeOfLastChange(self, pbc, pmkToLeft):
#         '-no docstring-'
#         #return pfiletime
#
#     def Inverse(self):
#         '-no docstring-'
#         #return ppmk
#
#     def CommonPrefixWith(self, pmkOther):
#         '-no docstring-'
#         #return ppmkPrefix
#
#     def RelativePathTo(self, pmkOther):
#         '-no docstring-'
#         #return ppmkRelPath
#
#     def GetDisplayName(self, pbc, pmkToLeft):
#         '-no docstring-'
#         #return ppszDisplayName
#
#     def ParseDisplayName(self, pbc, pmkToLeft, pszDisplayName):
#         '-no docstring-'
#         #return pchEaten, ppmkOut
#
#     def IsSystemMoniker(self):
#         '-no docstring-'
#         #return pdwMksys
#


class _MFARGB(Structure):
    pass


_MFARGB._fields_ = [
    ('rgbBlue', c_ubyte),
    ('rgbGreen', c_ubyte),
    ('rgbRed', c_ubyte),
    ('rgbAlpha', c_ubyte),
]

assert sizeof(_MFARGB) == 4, sizeof(_MFARGB)
assert alignment(_MFARGB) == 1, alignment(_MFARGB)


class __MFAYUVSample(Structure):
    pass


__MFAYUVSample._fields_ = [
    ('bCrValue', c_ubyte),
    ('bCbValue', c_ubyte),
    ('bYValue', c_ubyte),
    ('bSampleAlpha8', c_ubyte),
]

assert sizeof(__MFAYUVSample) == 4, sizeof(__MFAYUVSample)
assert alignment(__MFAYUVSample) == 1, alignment(__MFAYUVSample)

_MFPaletteEntry._fields_ = [
    ('ARGB', _MFARGB),
    ('AYCbCr', __MFAYUVSample),
]

assert sizeof(_MFPaletteEntry) == 4, sizeof(_MFPaletteEntry)
assert alignment(_MFPaletteEntry) == 1, alignment(_MFPaletteEntry)


class _MFOffset(Structure):
    pass


_MFOffset._fields_ = [
    ('fract', c_ushort),
    ('Value', c_short),
]

assert sizeof(_MFOffset) == 4, sizeof(_MFOffset)
assert alignment(_MFOffset) == 2, alignment(_MFOffset)

IEnumMediaTypes._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'Next',
        (['in'], c_ulong, 'cMediaTypes'),
        (['out'], POINTER(POINTER(_AMMediaType)), 'ppMediaTypes'),
        (['out'], POINTER(c_ulong), 'pcFetched')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Skip',
        (['in'], c_ulong, 'cMediaTypes')
    ),
    COMMETHOD([], HRESULT, 'Reset'),
    COMMETHOD(
        [],
        HRESULT,
        'Clone',
        (['out'], POINTER(POINTER(IEnumMediaTypes)), 'ppenum')
    ),
]

################################################################
# code template for IEnumMediaTypes implementation
# class IEnumMediaTypes_Impl(object):
#     def Next(self, cMediaTypes):
#         '-no docstring-'
#         #return ppMediaTypes, pcFetched
#
#     def Skip(self, cMediaTypes):
#         '-no docstring-'
#         #return 
#
#     def Reset(self):
#         '-no docstring-'
#         #return 
#
#     def Clone(self):
#         '-no docstring-'
#         #return ppenum
#


class Library(object):
    """MS Video Control 1.0 Type Library"""
    name = 'MSVidCtlLib'
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


IEnumSTATSTG._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'RemoteNext',
        (['in'], c_ulong, 'celt'),
        (['out'], POINTER(tagSTATSTG), 'rgelt'),
        (['out'], POINTER(c_ulong), 'pceltFetched')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Skip',
        (['in'], c_ulong, 'celt')
    ),
    COMMETHOD([], HRESULT, 'Reset'),
    COMMETHOD(
        [],
        HRESULT,
        'Clone',
        (['out'], POINTER(POINTER(IEnumSTATSTG)), 'ppenum')
    ),
]

################################################################
# code template for IEnumSTATSTG implementation
# class IEnumSTATSTG_Impl(object):
#     def RemoteNext(self, celt):
#         '-no docstring-'
#         #return rgelt, pceltFetched
#
#     def Skip(self, celt):
#         '-no docstring-'
#         #return 
#
#     def Reset(self):
#         '-no docstring-'
#         #return 
#
#     def Clone(self):
#         '-no docstring-'
#         #return ppenum
#


class MSVidFilePlaybackDevice(CoClass):
    """MS Video Control File Playback Device Class"""
    _reg_clsid_ = GUID('{37B0353C-A4C8-11D2-B634-00C04F79498E}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


class IMSVidFilePlayback2(IMSVidFilePlayback):
    """MS Video Control File Playback Device 2 Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{2F7E44AF-6E52-4660-BC08-D8D542587D72}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _set__SourceFilter(self, rhs: hints.Incomplete) -> hints.Hresult: ...
        _SourceFilter = hints.normal_property(fset=_set__SourceFilter)
        def _set___SourceFilter(self, rhs: hints.Incomplete) -> hints.Hresult: ...
        __SourceFilter = hints.normal_property(fset=_set___SourceFilter)


MSVidFilePlaybackDevice._com_interfaces_ = [IMSVidFilePlayback2, IMSVidFilePlayback, IMSVidGraphSegment]
MSVidFilePlaybackDevice._outgoing_interfaces_ = [IMSVidFilePlaybackEvent]


class tagVersionedStream(Structure):
    pass


tagVersionedStream._fields_ = [
    ('guidVersion', comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
    ('pStream', POINTER(IStream)),
]

assert sizeof(tagVersionedStream) == 24, sizeof(tagVersionedStream)
assert alignment(tagVersionedStream) == 8, alignment(tagVersionedStream)

IMSVidInputDeviceEvent._methods_ = [
]

################################################################
# code template for IMSVidInputDeviceEvent implementation
# class IMSVidInputDeviceEvent_Impl(object):

IMSVidPlaybackEvent._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'EndOfMedia',
        (['in'], POINTER(IMSVidPlayback), 'lpd')
    ),
]

################################################################
# code template for IMSVidPlaybackEvent implementation
# class IMSVidPlaybackEvent_Impl(object):
#     def EndOfMedia(self, lpd):
#         '-no docstring-'
#         #return 
#

IMSVidFilePlaybackEvent._methods_ = [
]

################################################################
# code template for IMSVidFilePlaybackEvent implementation
# class IMSVidFilePlaybackEvent_Impl(object):


class IEnumPins(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    _case_insensitive_ = True
    _iid_ = GUID('{56A86892-0AD4-11CE-B03A-0020AF0BA770}')
    _idlflags_ = []

    def __iter__(self):
        return self

    def __next__(self):
        item, fetched = self.Next(1)
        if fetched:
            return item
        raise StopIteration

    def __getitem__(self, index):
        self.Reset()
        self.Skip(index)
        item, fetched = self.Next(1)
        if fetched:
            return item
        raise IndexError(index)

    if TYPE_CHECKING:  # commembers
        def Next(self, cPins: hints.Incomplete) -> hints.Tuple['IPin', hints.Incomplete]: ...
        def Skip(self, cPins: hints.Incomplete) -> hints.Hresult: ...
        def Reset(self) -> hints.Hresult: ...
        def Clone(self) -> 'IEnumPins': ...


IEnumPins._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'Next',
        (['in'], c_ulong, 'cPins'),
        (['out'], POINTER(POINTER(IPin)), 'ppPins'),
        (['out'], POINTER(c_ulong), 'pcFetched')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Skip',
        (['in'], c_ulong, 'cPins')
    ),
    COMMETHOD([], HRESULT, 'Reset'),
    COMMETHOD(
        [],
        HRESULT,
        'Clone',
        (['out'], POINTER(POINTER(IEnumPins)), 'ppenum')
    ),
]

################################################################
# code template for IEnumPins implementation
# class IEnumPins_Impl(object):
#     def Next(self, cPins):
#         '-no docstring-'
#         #return ppPins, pcFetched
#
#     def Skip(self, cPins):
#         '-no docstring-'
#         #return 
#
#     def Reset(self):
#         '-no docstring-'
#         #return 
#
#     def Clone(self):
#         '-no docstring-'
#         #return ppenum
#


class MSVidAnalogTunerDevice(CoClass):
    """MS Video Control Analog TV Tuner Device Class"""
    _reg_clsid_ = GUID('{1C15D484-911D-11D2-B632-00C04F79498E}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


class IMSVidVideoInputDevice(IMSVidInputDevice):
    """MS Video Control Video Device Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{1C15D47F-911D-11D2-B632-00C04F79498E}')
    _idlflags_ = ['dual', 'oleautomation', 'proxy']


class IMSVidTuner(IMSVidVideoInputDevice):
    """MS Video Tuner Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{1C15D47D-911D-11D2-B632-00C04F79498E}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_Tune(self) -> 'ITuneRequest': ...
        def _set_Tune(self, ppTR: hints.Incomplete) -> hints.Hresult: ...
        Tune = hints.normal_property(_get_Tune, _set_Tune)
        def _get_TuningSpace(self) -> 'ITuningSpace': ...
        def _set_TuningSpace(self, plTS: hints.Incomplete) -> hints.Hresult: ...
        TuningSpace = hints.normal_property(_get_TuningSpace, _set_TuningSpace)


class IMSVidAnalogTuner(IMSVidTuner):
    """MS Video TV Tuner Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{1C15D47E-911D-11D2-B632-00C04F79498E}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_Channel(self) -> hints.Incomplete: ...
        def _set_Channel(self, Channel: hints.Incomplete) -> hints.Hresult: ...
        Channel = hints.normal_property(_get_Channel, _set_Channel)
        def _get_VideoFrequency(self) -> hints.Incomplete: ...
        VideoFrequency = hints.normal_property(_get_VideoFrequency)
        def _get_AudioFrequency(self) -> hints.Incomplete: ...
        AudioFrequency = hints.normal_property(_get_AudioFrequency)
        def _get_CountryCode(self) -> hints.Incomplete: ...
        def _set_CountryCode(self, lcc: hints.Incomplete) -> hints.Hresult: ...
        CountryCode = hints.normal_property(_get_CountryCode, _set_CountryCode)
        def _get_SAP(self) -> hints.Incomplete: ...
        def _set_SAP(self, pfSapOn: hints.Incomplete) -> hints.Hresult: ...
        SAP = hints.normal_property(_get_SAP, _set_SAP)
        def ChannelAvailable(self, nChannel: hints.Incomplete) -> hints.Tuple[hints.Incomplete, hints.Incomplete]: ...


class IMSVidAnalogTuner2(IMSVidAnalogTuner):
    """MS Video TV Tuner Interface2"""
    _case_insensitive_ = True
    _iid_ = GUID('{37647BF7-3DDE-4CC8-A4DC-0D534D3D0037}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_TVFormats(self) -> hints.Incomplete: ...
        TVFormats = hints.normal_property(_get_TVFormats)
        def _get_TunerModes(self) -> hints.Incomplete: ...
        TunerModes = hints.normal_property(_get_TunerModes)
        def _get_NumAuxInputs(self) -> hints.Incomplete: ...
        NumAuxInputs = hints.normal_property(_get_NumAuxInputs)


class IMSVidTunerEvent(IMSVidInputDeviceEvent):
    """MS Video Control Tuner Device Event Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{1C15D485-911D-11D2-B632-00C04F79498E}')
    _idlflags_ = ['hidden', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def TuneChanged(self, lpd: hints.Incomplete) -> hints.Hresult: ...


class IMSVidAnalogTunerEvent(IMSVidTunerEvent):
    """MS Video Control TV Tuner Device Event Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{1C15D486-911D-11D2-B632-00C04F79498E}')
    _idlflags_ = ['oleautomation', 'proxy']


MSVidAnalogTunerDevice._com_interfaces_ = [IMSVidAnalogTuner2, IMSVidAnalogTuner, IMSVidGraphSegment]
MSVidAnalogTunerDevice._outgoing_interfaces_ = [IMSVidAnalogTunerEvent]


class MSVidWebDVD(CoClass):
    """MSVidWebDVD Class"""
    _reg_clsid_ = GUID('{011B3619-FE63-4814-8A84-15A194CE9CE3}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


class IMSVidWebDVD(IMSVidPlayback):
    """IMSVidWebDVD Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{CF45F88B-AC56-4EE2-A73A-ED04E2885D3C}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def OnDVDEvent(self, lEvent: hints.Incomplete, lParam1: hints.Incomplete, lParam2: hints.Incomplete) -> hints.Hresult: ...
        def PlayTitle(self, lTitle: hints.Incomplete) -> hints.Hresult: ...
        def PlayChapterInTitle(self, lTitle: hints.Incomplete, lChapter: hints.Incomplete) -> hints.Hresult: ...
        def PlayChapter(self, lChapter: hints.Incomplete) -> hints.Hresult: ...
        def PlayChaptersAutoStop(self, lTitle: hints.Incomplete, lstrChapter: hints.Incomplete, lChapterCount: hints.Incomplete) -> hints.Hresult: ...
        def PlayAtTime(self, strTime: hints.Incomplete) -> hints.Hresult: ...
        def PlayAtTimeInTitle(self, lTitle: hints.Incomplete, strTime: hints.Incomplete) -> hints.Hresult: ...
        def PlayPeriodInTitleAutoStop(self, lTitle: hints.Incomplete, strStartTime: hints.Incomplete, strEndTime: hints.Incomplete) -> hints.Hresult: ...
        def ReplayChapter(self) -> hints.Hresult: ...
        def PlayPrevChapter(self) -> hints.Hresult: ...
        def PlayNextChapter(self) -> hints.Hresult: ...
        def StillOff(self) -> hints.Hresult: ...
        def _get_AudioLanguage(self, lStream: hints.Incomplete, fFormat: hints.Incomplete = ...) -> hints.Incomplete: ...
        AudioLanguage = hints.named_property('AudioLanguage', _get_AudioLanguage)
        def ShowMenu(self, MenuID: hints.Incomplete) -> hints.Hresult: ...
        def Resume(self) -> hints.Hresult: ...
        def ReturnFromSubmenu(self) -> hints.Hresult: ...
        def _get_ButtonsAvailable(self) -> hints.Incomplete: ...
        ButtonsAvailable = hints.normal_property(_get_ButtonsAvailable)
        def _get_CurrentButton(self) -> hints.Incomplete: ...
        CurrentButton = hints.normal_property(_get_CurrentButton)
        def SelectAndActivateButton(self, lButton: hints.Incomplete) -> hints.Hresult: ...
        def ActivateButton(self) -> hints.Hresult: ...
        def SelectRightButton(self) -> hints.Hresult: ...
        def SelectLeftButton(self) -> hints.Hresult: ...
        def SelectLowerButton(self) -> hints.Hresult: ...
        def SelectUpperButton(self) -> hints.Hresult: ...
        def ActivateAtPosition(self, xPos: hints.Incomplete, yPos: hints.Incomplete) -> hints.Hresult: ...
        def SelectAtPosition(self, xPos: hints.Incomplete, yPos: hints.Incomplete) -> hints.Hresult: ...
        def _get_ButtonAtPosition(self, xPos: hints.Incomplete, yPos: hints.Incomplete) -> hints.Incomplete: ...
        ButtonAtPosition = hints.named_property('ButtonAtPosition', _get_ButtonAtPosition)
        def _get_NumberOfChapters(self, lTitle: hints.Incomplete) -> hints.Incomplete: ...
        NumberOfChapters = hints.named_property('NumberOfChapters', _get_NumberOfChapters)
        def _get_TotalTitleTime(self) -> hints.Incomplete: ...
        TotalTitleTime = hints.normal_property(_get_TotalTitleTime)
        def _get_TitlesAvailable(self) -> hints.Incomplete: ...
        TitlesAvailable = hints.normal_property(_get_TitlesAvailable)
        def _get_VolumesAvailable(self) -> hints.Incomplete: ...
        VolumesAvailable = hints.normal_property(_get_VolumesAvailable)
        def _get_CurrentVolume(self) -> hints.Incomplete: ...
        CurrentVolume = hints.normal_property(_get_CurrentVolume)
        def _get_CurrentDiscSide(self) -> hints.Incomplete: ...
        CurrentDiscSide = hints.normal_property(_get_CurrentDiscSide)
        def _get_CurrentDomain(self) -> hints.Incomplete: ...
        CurrentDomain = hints.normal_property(_get_CurrentDomain)
        def _get_CurrentChapter(self) -> hints.Incomplete: ...
        CurrentChapter = hints.normal_property(_get_CurrentChapter)
        def _get_CurrentTitle(self) -> hints.Incomplete: ...
        CurrentTitle = hints.normal_property(_get_CurrentTitle)
        def _get_CurrentTime(self) -> hints.Incomplete: ...
        CurrentTime = hints.normal_property(_get_CurrentTime)
        def DVDTimeCode2bstr(self, timeCode: hints.Incomplete) -> hints.Incomplete: ...
        def _get_DVDDirectory(self) -> hints.Incomplete: ...
        def _set_DVDDirectory(self, pVal: hints.Incomplete) -> hints.Hresult: ...
        DVDDirectory = hints.normal_property(_get_DVDDirectory, _set_DVDDirectory)
        def IsSubpictureStreamEnabled(self, lStream: hints.Incomplete) -> hints.Incomplete: ...
        def IsAudioStreamEnabled(self, lStream: hints.Incomplete) -> hints.Incomplete: ...
        def _get_CurrentSubpictureStream(self) -> hints.Incomplete: ...
        def _set_CurrentSubpictureStream(self, pVal: hints.Incomplete) -> hints.Hresult: ...
        CurrentSubpictureStream = hints.normal_property(_get_CurrentSubpictureStream, _set_CurrentSubpictureStream)
        def _get_SubpictureLanguage(self, lStream: hints.Incomplete) -> hints.Incomplete: ...
        SubpictureLanguage = hints.named_property('SubpictureLanguage', _get_SubpictureLanguage)
        def _get_CurrentAudioStream(self) -> hints.Incomplete: ...
        def _set_CurrentAudioStream(self, pVal: hints.Incomplete) -> hints.Hresult: ...
        CurrentAudioStream = hints.normal_property(_get_CurrentAudioStream, _set_CurrentAudioStream)
        def _get_AudioStreamsAvailable(self) -> hints.Incomplete: ...
        AudioStreamsAvailable = hints.normal_property(_get_AudioStreamsAvailable)
        def _get_AnglesAvailable(self) -> hints.Incomplete: ...
        AnglesAvailable = hints.normal_property(_get_AnglesAvailable)
        def _get_CurrentAngle(self) -> hints.Incomplete: ...
        def _set_CurrentAngle(self, pVal: hints.Incomplete) -> hints.Hresult: ...
        CurrentAngle = hints.normal_property(_get_CurrentAngle, _set_CurrentAngle)
        def _get_SubpictureStreamsAvailable(self) -> hints.Incomplete: ...
        SubpictureStreamsAvailable = hints.normal_property(_get_SubpictureStreamsAvailable)
        def _get_SubpictureOn(self) -> hints.Incomplete: ...
        def _set_SubpictureOn(self, pVal: hints.Incomplete) -> hints.Hresult: ...
        SubpictureOn = hints.normal_property(_get_SubpictureOn, _set_SubpictureOn)
        def _get_DVDUniqueID(self) -> hints.Incomplete: ...
        DVDUniqueID = hints.normal_property(_get_DVDUniqueID)
        def AcceptParentalLevelChange(self, fAccept: hints.Incomplete, strUserName: hints.Incomplete, strPassword: hints.Incomplete) -> hints.Hresult: ...
        def NotifyParentalLevelChange(self, newVal: hints.Incomplete) -> hints.Hresult: ...
        def SelectParentalCountry(self, lCountry: hints.Incomplete, strUserName: hints.Incomplete, strPassword: hints.Incomplete) -> hints.Hresult: ...
        def SelectParentalLevel(self, lParentalLevel: hints.Incomplete, strUserName: hints.Incomplete, strPassword: hints.Incomplete) -> hints.Hresult: ...
        def _get_TitleParentalLevels(self, lTitle: hints.Incomplete) -> hints.Incomplete: ...
        TitleParentalLevels = hints.named_property('TitleParentalLevels', _get_TitleParentalLevels)
        def _get_PlayerParentalCountry(self) -> hints.Incomplete: ...
        PlayerParentalCountry = hints.normal_property(_get_PlayerParentalCountry)
        def _get_PlayerParentalLevel(self) -> hints.Incomplete: ...
        PlayerParentalLevel = hints.normal_property(_get_PlayerParentalLevel)
        def Eject(self) -> hints.Hresult: ...
        def UOPValid(self, lUOP: hints.Incomplete) -> hints.Incomplete: ...
        def _get_SPRM(self, lIndex: hints.Incomplete) -> hints.Incomplete: ...
        SPRM = hints.named_property('SPRM', _get_SPRM)
        def _get_GPRM(self, lIndex: hints.Incomplete) -> hints.Incomplete: ...
        def _set_GPRM(self, lIndex: hints.Incomplete, psSPRM: hints.Incomplete) -> hints.Hresult: ...
        GPRM = hints.named_property('GPRM', _get_GPRM, _set_GPRM)
        def _get_DVDTextStringType(self, lLangIndex: hints.Incomplete, lStringIndex: hints.Incomplete) -> hints.Incomplete: ...
        DVDTextStringType = hints.named_property('DVDTextStringType', _get_DVDTextStringType)
        def _get_DVDTextString(self, lLangIndex: hints.Incomplete, lStringIndex: hints.Incomplete) -> hints.Incomplete: ...
        DVDTextString = hints.named_property('DVDTextString', _get_DVDTextString)
        def _get_DVDTextNumberOfStrings(self, lLangIndex: hints.Incomplete) -> hints.Incomplete: ...
        DVDTextNumberOfStrings = hints.named_property('DVDTextNumberOfStrings', _get_DVDTextNumberOfStrings)
        def _get_DVDTextNumberOfLanguages(self) -> hints.Incomplete: ...
        DVDTextNumberOfLanguages = hints.normal_property(_get_DVDTextNumberOfLanguages)
        def _get_DVDTextLanguageLCID(self, lLangIndex: hints.Incomplete) -> hints.Incomplete: ...
        DVDTextLanguageLCID = hints.named_property('DVDTextLanguageLCID', _get_DVDTextLanguageLCID)
        def RegionChange(self) -> hints.Hresult: ...
        def _get_DVDAdm(self) -> hints.Incomplete: ...
        DVDAdm = hints.normal_property(_get_DVDAdm)
        def DeleteBookmark(self) -> hints.Hresult: ...
        def RestoreBookmark(self) -> hints.Hresult: ...
        def SaveBookmark(self) -> hints.Hresult: ...
        def SelectDefaultAudioLanguage(self, lang: hints.Incomplete, ext: hints.Incomplete) -> hints.Hresult: ...
        def SelectDefaultSubpictureLanguage(self, lang: hints.Incomplete, ext: hints.Incomplete) -> hints.Hresult: ...
        def _get_PreferredSubpictureStream(self) -> hints.Incomplete: ...
        PreferredSubpictureStream = hints.normal_property(_get_PreferredSubpictureStream)
        def _get_DefaultMenuLanguage(self) -> hints.Incomplete: ...
        def _set_DefaultMenuLanguage(self, lang: hints.Incomplete) -> hints.Hresult: ...
        DefaultMenuLanguage = hints.normal_property(_get_DefaultMenuLanguage, _set_DefaultMenuLanguage)
        def _get_DefaultSubpictureLanguage(self) -> hints.Incomplete: ...
        DefaultSubpictureLanguage = hints.normal_property(_get_DefaultSubpictureLanguage)
        def _get_DefaultAudioLanguage(self) -> hints.Incomplete: ...
        DefaultAudioLanguage = hints.normal_property(_get_DefaultAudioLanguage)
        def _get_DefaultSubpictureLanguageExt(self) -> hints.Incomplete: ...
        DefaultSubpictureLanguageExt = hints.normal_property(_get_DefaultSubpictureLanguageExt)
        def _get_DefaultAudioLanguageExt(self) -> hints.Incomplete: ...
        DefaultAudioLanguageExt = hints.normal_property(_get_DefaultAudioLanguageExt)
        def _get_LanguageFromLCID(self, lcid: hints.Incomplete) -> hints.Incomplete: ...
        LanguageFromLCID = hints.named_property('LanguageFromLCID', _get_LanguageFromLCID)
        def _get_KaraokeAudioPresentationMode(self) -> hints.Incomplete: ...
        def _set_KaraokeAudioPresentationMode(self, pVal: hints.Incomplete) -> hints.Hresult: ...
        KaraokeAudioPresentationMode = hints.normal_property(_get_KaraokeAudioPresentationMode, _set_KaraokeAudioPresentationMode)
        def _get_KaraokeChannelContent(self, lStream: hints.Incomplete, lChan: hints.Incomplete) -> hints.Incomplete: ...
        KaraokeChannelContent = hints.named_property('KaraokeChannelContent', _get_KaraokeChannelContent)
        def _get_KaraokeChannelAssignment(self, lStream: hints.Incomplete) -> hints.Incomplete: ...
        KaraokeChannelAssignment = hints.named_property('KaraokeChannelAssignment', _get_KaraokeChannelAssignment)
        def RestorePreferredSettings(self) -> hints.Hresult: ...
        def _get_ButtonRect(self, lButton: hints.Incomplete) -> 'IMSVidRect': ...
        ButtonRect = hints.named_property('ButtonRect', _get_ButtonRect)
        def _get_DVDScreenInMouseCoordinates(self) -> 'IMSVidRect': ...
        def _set_DVDScreenInMouseCoordinates(self, ppRect: hints.Incomplete) -> hints.Hresult: ...
        DVDScreenInMouseCoordinates = hints.normal_property(_get_DVDScreenInMouseCoordinates, _set_DVDScreenInMouseCoordinates)


class IMSVidWebDVDEvent(IMSVidPlaybackEvent):
    """MS Video Control File Playback Device Event Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{B4F7A674-9B83-49CB-A357-C63B871BE958}')
    _idlflags_ = ['hidden', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def DVDNotify(self, lEventCode: hints.Incomplete, lParam1: hints.Incomplete, lParam2: hints.Incomplete) -> hints.Hresult: ...
        def PlayForwards(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def PlayBackwards(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def ShowMenu(self, MenuID: hints.Incomplete, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def Resume(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def SelectOrActivateButton(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def StillOff(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def PauseOn(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def ChangeCurrentAudioStream(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def ChangeCurrentSubpictureStream(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def ChangeCurrentAngle(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def PlayAtTimeInTitle(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def PlayAtTime(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def PlayChapterInTitle(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def PlayChapter(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def ReplayChapter(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def PlayNextChapter(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def Stop(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def ReturnFromSubmenu(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def PlayTitle(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def PlayPrevChapter(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def ChangeKaraokePresMode(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...
        def ChangeVideoPresMode(self, bEnabled: hints.Incomplete) -> hints.Hresult: ...


MSVidWebDVD._com_interfaces_ = [IMSVidWebDVD, IMSVidGraphSegment]
MSVidWebDVD._outgoing_interfaces_ = [IMSVidWebDVDEvent]

IMSVidInputDevice._methods_ = [
    COMMETHOD(
        [dispid(21)],
        HRESULT,
        'IsViewable',
        (['in'], POINTER(VARIANT), 'v'),
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'pfViewable')
    ),
    COMMETHOD(
        [dispid(22)],
        HRESULT,
        'View',
        (['in'], POINTER(VARIANT), 'v')
    ),
]

################################################################
# code template for IMSVidInputDevice implementation
# class IMSVidInputDevice_Impl(object):
#     def IsViewable(self, v):
#         '-no docstring-'
#         #return pfViewable
#
#     def View(self, v):
#         '-no docstring-'
#         #return 
#

IMSVidPlayback._methods_ = [
    COMMETHOD(
        [dispid(96), helpstring('EnableResetOnStop'), 'propget'],
        HRESULT,
        'EnableResetOnStop',
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'pVal')
    ),
    COMMETHOD(
        [dispid(96), helpstring('EnableResetOnStop'), 'propput'],
        HRESULT,
        'EnableResetOnStop',
        (['in'], VARIANT_BOOL, 'pVal')
    ),
    COMMETHOD([dispid(35)], HRESULT, 'Run'),
    COMMETHOD([dispid(36)], HRESULT, 'Pause'),
    COMMETHOD([dispid(37)], HRESULT, 'Stop'),
    COMMETHOD(
        [dispid(40), 'propget'],
        HRESULT,
        'CanStep',
        (['in'], VARIANT_BOOL, 'fBackwards'),
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'pfCan')
    ),
    COMMETHOD(
        [dispid(39)],
        HRESULT,
        'Step',
        (['in'], c_int, 'lStep')
    ),
    COMMETHOD(
        [dispid(145), helpstring('Rate'), 'propput'],
        HRESULT,
        'Rate',
        (['in'], c_double, 'plRate')
    ),
    COMMETHOD(
        [dispid(145), helpstring('Rate'), 'propget'],
        HRESULT,
        'Rate',
        (['out', 'retval'], POINTER(c_double), 'plRate')
    ),
    COMMETHOD(
        [dispid(146), helpstring('Position'), 'propput'],
        HRESULT,
        'CurrentPosition',
        (['in'], c_int, 'lPosition')
    ),
    COMMETHOD(
        [dispid(146), helpstring('Position'), 'propget'],
        HRESULT,
        'CurrentPosition',
        (['out', 'retval'], POINTER(c_int), 'lPosition')
    ),
    COMMETHOD(
        [dispid(147), helpstring('PositionMode'), 'propput'],
        HRESULT,
        'PositionMode',
        (['in'], PositionModeList, 'lPositionMode')
    ),
    COMMETHOD(
        [dispid(147), helpstring('PositionMode'), 'propget'],
        HRESULT,
        'PositionMode',
        (['out', 'retval'], POINTER(PositionModeList), 'lPositionMode')
    ),
    COMMETHOD(
        [dispid(148), helpstring('Length'), 'propget'],
        HRESULT,
        'Length',
        (['out', 'retval'], POINTER(c_int), 'lLength')
    ),
]

################################################################
# code template for IMSVidPlayback implementation
# class IMSVidPlayback_Impl(object):
#     def _get(self):
#         'EnableResetOnStop'
#         #return pVal
#     def _set(self, pVal):
#         'EnableResetOnStop'
#     EnableResetOnStop = property(_get, _set, doc = _set.__doc__)
#
#     def Run(self):
#         '-no docstring-'
#         #return 
#
#     def Pause(self):
#         '-no docstring-'
#         #return 
#
#     def Stop(self):
#         '-no docstring-'
#         #return 
#
#     @property
#     def CanStep(self, fBackwards):
#         '-no docstring-'
#         #return pfCan
#
#     def Step(self, lStep):
#         '-no docstring-'
#         #return 
#
#     def _get(self):
#         'Rate'
#         #return plRate
#     def _set(self, plRate):
#         'Rate'
#     Rate = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Position'
#         #return lPosition
#     def _set(self, lPosition):
#         'Position'
#     CurrentPosition = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'PositionMode'
#         #return lPositionMode
#     def _set(self, lPositionMode):
#         'PositionMode'
#     PositionMode = property(_get, _set, doc = _set.__doc__)
#
#     @property
#     def Length(self):
#         'Length'
#         #return lLength
#

IMSVidFilePlayback._methods_ = [
    COMMETHOD(
        [dispid(17), 'propget'],
        HRESULT,
        'FileName',
        (['out', 'retval'], POINTER(BSTR), 'FileName')
    ),
    COMMETHOD(
        [dispid(17), 'propput'],
        HRESULT,
        'FileName',
        (['in'], BSTR, 'FileName')
    ),
]

################################################################
# code template for IMSVidFilePlayback implementation
# class IMSVidFilePlayback_Impl(object):
#     def _get(self):
#         '-no docstring-'
#         #return FileName
#     def _set(self, FileName):
#         '-no docstring-'
#     FileName = property(_get, _set, doc = _set.__doc__)
#

IMSVidFilePlayback2._methods_ = [
    COMMETHOD(
        [dispid(218), 'hidden', 'propput'],
        HRESULT,
        '_SourceFilter',
        (['in'], BSTR, 'rhs')
    ),
    COMMETHOD(
        [dispid(219), 'hidden', 'propput'],
        HRESULT,
        '__SourceFilter',
        (
            ['in'],
            comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID,
            'rhs',
        )
    ),
]

################################################################
# code template for IMSVidFilePlayback2 implementation
# class IMSVidFilePlayback2_Impl(object):
#     def _set(self, rhs):
#         '-no docstring-'
#     _SourceFilter = property(fset = _set, doc = _set.__doc__)
#
#     def _set(self, rhs):
#         '-no docstring-'
#     __SourceFilter = property(fset = _set, doc = _set.__doc__)
#


class _VMRVIDEOSTREAMINFO(Structure):
    pass


IVMRImageCompositor._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'InitCompositionTarget',
        (['in'], POINTER(IUnknown), 'pD3DDevice'),
        (['in'], POINTER(c_ulong), 'pddsRenderTarget')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'TermCompositionTarget',
        (['in'], POINTER(IUnknown), 'pD3DDevice'),
        (['in'], POINTER(c_ulong), 'pddsRenderTarget')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'SetStreamMediaType',
        (['in'], c_ulong, 'dwStrmID'),
        (['in'], POINTER(_AMMediaType), 'pmt'),
        (['in'], c_int, 'fTexture')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'CompositeImage',
        (['in'], POINTER(IUnknown), 'pD3DDevice'),
        (['in'], POINTER(c_ulong), 'pddsRenderTarget'),
        (['in'], POINTER(_AMMediaType), 'pmtRenderTarget'),
        (['in'], c_longlong, 'rtStart'),
        (['in'], c_longlong, 'rtEnd'),
        (['in'], c_ulong, 'dwClrBkGnd'),
        (['in'], POINTER(_VMRVIDEOSTREAMINFO), 'pVideoStreamInfo'),
        (['in'], c_uint, 'cStreams')
    ),
]

################################################################
# code template for IVMRImageCompositor implementation
# class IVMRImageCompositor_Impl(object):
#     def InitCompositionTarget(self, pD3DDevice, pddsRenderTarget):
#         '-no docstring-'
#         #return 
#
#     def TermCompositionTarget(self, pD3DDevice, pddsRenderTarget):
#         '-no docstring-'
#         #return 
#
#     def SetStreamMediaType(self, dwStrmID, pmt, fTexture):
#         '-no docstring-'
#         #return 
#
#     def CompositeImage(self, pD3DDevice, pddsRenderTarget, pmtRenderTarget, rtStart, rtEnd, dwClrBkGnd, pVideoStreamInfo, cStreams):
#         '-no docstring-'
#         #return 
#


class ITuneRequest(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """Tune Request Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{07DDC146-FC3D-11D2-9D8C-00C04F72D980}')
    _idlflags_ = ['dual', 'nonextensible', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_TuningSpace(self) -> 'ITuningSpace': ...
        TuningSpace = hints.normal_property(_get_TuningSpace)
        def _get_Components(self) -> 'IComponents': ...
        Components = hints.normal_property(_get_Components)
        def Clone(self) -> 'ITuneRequest': ...
        def _get_Locator(self) -> 'ILocator': ...
        def _set_Locator(self, Locator: hints.Incomplete) -> hints.Hresult: ...
        Locator = hints.normal_property(_get_Locator, _set_Locator)


class ITuningSpace(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """Tuning Space Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{061C6E30-E622-11D2-9493-00C04F72D980}')
    _idlflags_ = ['dual', 'nonextensible', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_UniqueName(self) -> hints.Incomplete: ...
        def _set_UniqueName(self, Name: hints.Incomplete) -> hints.Hresult: ...
        UniqueName = hints.normal_property(_get_UniqueName, _set_UniqueName)
        def _get_FriendlyName(self) -> hints.Incomplete: ...
        def _set_FriendlyName(self, Name: hints.Incomplete) -> hints.Hresult: ...
        FriendlyName = hints.normal_property(_get_FriendlyName, _set_FriendlyName)
        def _get_Clsid(self) -> hints.Incomplete: ...
        Clsid = hints.normal_property(_get_Clsid)
        def _get_NetworkType(self) -> hints.Incomplete: ...
        def _set_NetworkType(self, NetworkTypeGuid: hints.Incomplete) -> hints.Hresult: ...
        NetworkType = hints.normal_property(_get_NetworkType, _set_NetworkType)
        def _get__NetworkType(self) -> hints.Incomplete: ...
        def _set__NetworkType(self, NetworkTypeGuid: hints.Incomplete) -> hints.Hresult: ...
        _NetworkType = hints.normal_property(_get__NetworkType, _set__NetworkType)
        def CreateTuneRequest(self) -> 'ITuneRequest': ...
        def EnumCategoryGUIDs(self) -> 'IEnumGUID': ...
        def EnumDeviceMonikers(self) -> 'IEnumMoniker': ...
        def _get_DefaultPreferredComponentTypes(self) -> 'IComponentTypes': ...
        def _set_DefaultPreferredComponentTypes(self, ComponentTypes: hints.Incomplete) -> hints.Hresult: ...
        DefaultPreferredComponentTypes = hints.normal_property(_get_DefaultPreferredComponentTypes, _set_DefaultPreferredComponentTypes)
        def _get_FrequencyMapping(self) -> hints.Incomplete: ...
        def _set_FrequencyMapping(self, pMapping: hints.Incomplete) -> hints.Hresult: ...
        FrequencyMapping = hints.normal_property(_get_FrequencyMapping, _set_FrequencyMapping)
        def _get_DefaultLocator(self) -> 'ILocator': ...
        def _set_DefaultLocator(self, LocatorVal: hints.Incomplete) -> hints.Hresult: ...
        DefaultLocator = hints.normal_property(_get_DefaultLocator, _set_DefaultLocator)
        def Clone(self) -> 'ITuningSpace': ...


class IComponents(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """Component Collection Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{39A48091-FFFE-4182-A161-3FF802640E26}')
    _idlflags_ = ['dual', 'nonextensible', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_Count(self) -> hints.Incomplete: ...
        Count = hints.normal_property(_get_Count)
        __len__ = hints.to_dunder_len(Count)
        def _get__NewEnum(self) -> hints.Incomplete: ...
        _NewEnum = hints.normal_property(_get__NewEnum)
        __iter__ = hints.to_dunder_iter(_NewEnum)
        def EnumComponents(self) -> 'IEnumComponents': ...
        def _get_Item(self, Index: hints.Incomplete) -> 'IComponent': ...
        def _set_Item(self, Index: hints.Incomplete, ppComponent: hints.Incomplete) -> hints.Hresult: ...
        Item = hints.named_property('Item', _get_Item, _set_Item)
        __call__ = hints.to_dunder_call(Item)
        __getitem__ = hints.to_dunder_getitem(Item)
        __setitem__ = hints.to_dunder_setitem(Item)
        def Add(self, Component: hints.Incomplete) -> hints.Incomplete: ...
        def Remove(self, Index: hints.Incomplete) -> hints.Hresult: ...
        def Clone(self) -> 'IComponents': ...


class ILocator(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """Generic Locator Information"""
    _case_insensitive_ = True
    _iid_ = GUID('{286D7F89-760C-4F89-80C4-66841D2507AA}')
    _idlflags_ = ['dual', 'nonextensible', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_CarrierFrequency(self) -> hints.Incomplete: ...
        def _set_CarrierFrequency(self, Frequency: hints.Incomplete) -> hints.Hresult: ...
        CarrierFrequency = hints.normal_property(_get_CarrierFrequency, _set_CarrierFrequency)
        def _get_InnerFEC(self) -> hints.Incomplete: ...
        def _set_InnerFEC(self, FEC: hints.Incomplete) -> hints.Hresult: ...
        InnerFEC = hints.normal_property(_get_InnerFEC, _set_InnerFEC)
        def _get_InnerFECRate(self) -> hints.Incomplete: ...
        def _set_InnerFECRate(self, FEC: hints.Incomplete) -> hints.Hresult: ...
        InnerFECRate = hints.normal_property(_get_InnerFECRate, _set_InnerFECRate)
        def _get_OuterFEC(self) -> hints.Incomplete: ...
        def _set_OuterFEC(self, FEC: hints.Incomplete) -> hints.Hresult: ...
        OuterFEC = hints.normal_property(_get_OuterFEC, _set_OuterFEC)
        def _get_OuterFECRate(self) -> hints.Incomplete: ...
        def _set_OuterFECRate(self, FEC: hints.Incomplete) -> hints.Hresult: ...
        OuterFECRate = hints.normal_property(_get_OuterFECRate, _set_OuterFECRate)
        def _get_Modulation(self) -> hints.Incomplete: ...
        def _set_Modulation(self, Modulation: hints.Incomplete) -> hints.Hresult: ...
        Modulation = hints.normal_property(_get_Modulation, _set_Modulation)
        def _get_SymbolRate(self) -> hints.Incomplete: ...
        def _set_SymbolRate(self, Rate: hints.Incomplete) -> hints.Hresult: ...
        SymbolRate = hints.normal_property(_get_SymbolRate, _set_SymbolRate)
        def Clone(self) -> 'ILocator': ...


ITuneRequest._methods_ = [
    COMMETHOD(
        [dispid(1), helpstring('Tuning Space object'), 'propget'],
        HRESULT,
        'TuningSpace',
        (['out', 'retval'], POINTER(POINTER(ITuningSpace)), 'TuningSpace')
    ),
    COMMETHOD(
        [dispid(2), helpstring('Components collection'), 'propget'],
        HRESULT,
        'Components',
        (['out', 'retval'], POINTER(POINTER(IComponents)), 'Components')
    ),
    COMMETHOD(
        [dispid(3), helpstring('Create a new copy of this tune request')],
        HRESULT,
        'Clone',
        (['out', 'retval'], POINTER(POINTER(ITuneRequest)), 'NewTuneRequest')
    ),
    COMMETHOD(
        [dispid(4), helpstring('Locator Object'), 'propget'],
        HRESULT,
        'Locator',
        (['out', 'retval'], POINTER(POINTER(ILocator)), 'Locator')
    ),
    COMMETHOD(
        [dispid(4), helpstring('Locator Object'), 'propput'],
        HRESULT,
        'Locator',
        (['in'], POINTER(ILocator), 'Locator')
    ),
]

################################################################
# code template for ITuneRequest implementation
# class ITuneRequest_Impl(object):
#     @property
#     def TuningSpace(self):
#         'Tuning Space object'
#         #return TuningSpace
#
#     @property
#     def Components(self):
#         'Components collection'
#         #return Components
#
#     def Clone(self):
#         'Create a new copy of this tune request'
#         #return NewTuneRequest
#
#     def _get(self):
#         'Locator Object'
#         #return Locator
#     def _set(self, Locator):
#         'Locator Object'
#     Locator = property(_get, _set, doc = _set.__doc__)
#


class __MIDL_IOleAutomationTypes_0006(Union):
    pass


__MIDL_IOleAutomationTypes_0006._fields_ = [
    ('oInst', c_ulong),
    ('lpvarValue', POINTER(VARIANT)),
]

assert sizeof(__MIDL_IOleAutomationTypes_0006) == 8, sizeof(__MIDL_IOleAutomationTypes_0006)
assert alignment(__MIDL_IOleAutomationTypes_0006) == 8, alignment(__MIDL_IOleAutomationTypes_0006)

ILocator._methods_ = [
    COMMETHOD(
        [dispid(1), helpstring('Carrier Frequency(KHz)'), 'propget'],
        HRESULT,
        'CarrierFrequency',
        (['out', 'retval'], POINTER(c_int), 'Frequency')
    ),
    COMMETHOD(
        [dispid(1), helpstring('Carrier Frequency(KHz)'), 'propput'],
        HRESULT,
        'CarrierFrequency',
        (['in'], c_int, 'Frequency')
    ),
    COMMETHOD(
        [dispid(2), helpstring('Inner Fec Type'), 'propget'],
        HRESULT,
        'InnerFEC',
        (['out', 'retval'], POINTER(FECMethod), 'FEC')
    ),
    COMMETHOD(
        [dispid(2), helpstring('Inner Fec Type'), 'propput'],
        HRESULT,
        'InnerFEC',
        (['in'], FECMethod, 'FEC')
    ),
    COMMETHOD(
        [dispid(3), helpstring('Inner Fec Rate'), 'propget'],
        HRESULT,
        'InnerFECRate',
        (['out', 'retval'], POINTER(BinaryConvolutionCodeRate), 'FEC')
    ),
    COMMETHOD(
        [dispid(3), helpstring('Inner Fec Rate'), 'propput'],
        HRESULT,
        'InnerFECRate',
        (['in'], BinaryConvolutionCodeRate, 'FEC')
    ),
    COMMETHOD(
        [dispid(4), helpstring('Outer Fec Type'), 'propget'],
        HRESULT,
        'OuterFEC',
        (['out', 'retval'], POINTER(FECMethod), 'FEC')
    ),
    COMMETHOD(
        [dispid(4), helpstring('Outer Fec Type'), 'propput'],
        HRESULT,
        'OuterFEC',
        (['in'], FECMethod, 'FEC')
    ),
    COMMETHOD(
        [dispid(5), helpstring('Outer Fec Rate'), 'propget'],
        HRESULT,
        'OuterFECRate',
        (['out', 'retval'], POINTER(BinaryConvolutionCodeRate), 'FEC')
    ),
    COMMETHOD(
        [dispid(5), helpstring('Outer Fec Rate'), 'propput'],
        HRESULT,
        'OuterFECRate',
        (['in'], BinaryConvolutionCodeRate, 'FEC')
    ),
    COMMETHOD(
        [dispid(6), helpstring('Modulation Type'), 'propget'],
        HRESULT,
        'Modulation',
        (['out', 'retval'], POINTER(ModulationType), 'Modulation')
    ),
    COMMETHOD(
        [dispid(6), helpstring('Modulation Type'), 'propput'],
        HRESULT,
        'Modulation',
        (['in'], ModulationType, 'Modulation')
    ),
    COMMETHOD(
        [dispid(7), helpstring('Modulation Symbol Rate'), 'propget'],
        HRESULT,
        'SymbolRate',
        (['out', 'retval'], POINTER(c_int), 'Rate')
    ),
    COMMETHOD(
        [dispid(7), helpstring('Modulation Symbol Rate'), 'propput'],
        HRESULT,
        'SymbolRate',
        (['in'], c_int, 'Rate')
    ),
    COMMETHOD(
        [dispid(8), helpstring('Copy the Locator')],
        HRESULT,
        'Clone',
        (['out', 'retval'], POINTER(POINTER(ILocator)), 'NewLocator')
    ),
]

################################################################
# code template for ILocator implementation
# class ILocator_Impl(object):
#     def _get(self):
#         'Carrier Frequency(KHz)'
#         #return Frequency
#     def _set(self, Frequency):
#         'Carrier Frequency(KHz)'
#     CarrierFrequency = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Inner Fec Type'
#         #return FEC
#     def _set(self, FEC):
#         'Inner Fec Type'
#     InnerFEC = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Inner Fec Rate'
#         #return FEC
#     def _set(self, FEC):
#         'Inner Fec Rate'
#     InnerFECRate = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Outer Fec Type'
#         #return FEC
#     def _set(self, FEC):
#         'Outer Fec Type'
#     OuterFEC = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Outer Fec Rate'
#         #return FEC
#     def _set(self, FEC):
#         'Outer Fec Rate'
#     OuterFECRate = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Modulation Type'
#         #return Modulation
#     def _set(self, Modulation):
#         'Modulation Type'
#     Modulation = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Modulation Symbol Rate'
#         #return Rate
#     def _set(self, Rate):
#         'Modulation Symbol Rate'
#     SymbolRate = property(_get, _set, doc = _set.__doc__)
#
#     def Clone(self):
#         'Copy the Locator'
#         #return NewLocator
#


class DDCOLORKEY(Structure):
    pass


DDCOLORKEY._fields_ = [
    ('dw1', c_ulong),
    ('dw2', c_ulong),
]

assert sizeof(DDCOLORKEY) == 8, sizeof(DDCOLORKEY)
assert alignment(DDCOLORKEY) == 4, alignment(DDCOLORKEY)


class _NORMALIZEDRECT(Structure):
    pass


_NORMALIZEDRECT._fields_ = [
    ('Left', c_float),
    ('Top', c_float),
    ('right', c_float),
    ('bottom', c_float),
]

assert sizeof(_NORMALIZEDRECT) == 16, sizeof(_NORMALIZEDRECT)
assert alignment(_NORMALIZEDRECT) == 4, alignment(_NORMALIZEDRECT)

_VMRVIDEOSTREAMINFO._fields_ = [
    ('pddsVideoSurface', POINTER(c_ulong)),
    ('dwWidth', c_ulong),
    ('dwHeight', c_ulong),
    ('dwStrmID', c_ulong),
    ('fAlpha', c_float),
    ('ddClrKey', DDCOLORKEY),
    ('rNormal', _NORMALIZEDRECT),
]

assert sizeof(_VMRVIDEOSTREAMINFO) == 48, sizeof(_VMRVIDEOSTREAMINFO)
assert alignment(_VMRVIDEOSTREAMINFO) == 8, alignment(_VMRVIDEOSTREAMINFO)


class IEnumFilters(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    _case_insensitive_ = True
    _iid_ = GUID('{56A86893-0AD4-11CE-B03A-0020AF0BA770}')
    _idlflags_ = []

    def __iter__(self):
        return self

    def __next__(self):
        item, fetched = self.Next(1)
        if fetched:
            return item
        raise StopIteration

    def __getitem__(self, index):
        self.Reset()
        self.Skip(index)
        item, fetched = self.Next(1)
        if fetched:
            return item
        raise IndexError(index)

    if TYPE_CHECKING:  # commembers
        def Next(self, cFilters: hints.Incomplete) -> hints.Tuple['IBaseFilter', hints.Incomplete]: ...
        def Skip(self, cFilters: hints.Incomplete) -> hints.Hresult: ...
        def Reset(self) -> hints.Hresult: ...
        def Clone(self) -> 'IEnumFilters': ...


class IMSVidGraphSegmentContainer(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    """DShow Graph Segment Container"""
    _case_insensitive_ = True
    _iid_ = GUID('{3DD2903D-E0AA-11D2-B63A-00C04F79498E}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def _get_Graph(self) -> 'IGraphBuilder': ...
        Graph = hints.normal_property(_get_Graph)
        def _get_Input(self) -> 'IMSVidGraphSegment': ...
        Input = hints.normal_property(_get_Input)
        def _get_Outputs(self) -> 'IEnumMSVidGraphSegment': ...
        Outputs = hints.normal_property(_get_Outputs)
        def _get_VideoRenderer(self) -> 'IMSVidGraphSegment': ...
        VideoRenderer = hints.normal_property(_get_VideoRenderer)
        def _get_AudioRenderer(self) -> 'IMSVidGraphSegment': ...
        AudioRenderer = hints.normal_property(_get_AudioRenderer)
        def _get_Features(self) -> 'IEnumMSVidGraphSegment': ...
        Features = hints.normal_property(_get_Features)
        def _get_Composites(self) -> 'IEnumMSVidGraphSegment': ...
        Composites = hints.normal_property(_get_Composites)
        def _get_ParentContainer(self) -> hints.Incomplete: ...
        ParentContainer = hints.normal_property(_get_ParentContainer)
        def Decompose(self, pSegment: hints.Incomplete) -> hints.Hresult: ...
        def IsWindowless(self) -> hints.Hresult: ...
        def GetFocus(self) -> hints.Hresult: ...


IMSVidGraphSegment._methods_ = [
    COMMETHOD(
        ['propget'],
        HRESULT,
        'Init',
        (['out', 'retval'], POINTER(POINTER(IUnknown)), 'pInit')
    ),
    COMMETHOD(
        ['propput'],
        HRESULT,
        'Init',
        (['in'], POINTER(IUnknown), 'pInit')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'EnumFilters',
        (['out'], POINTER(POINTER(IEnumFilters)), 'pNewEnum')
    ),
    COMMETHOD(
        ['propget', helpstring('Graph that contains this segment')],
        HRESULT,
        'Container',
        (
            ['out', 'retval'],
            POINTER(POINTER(IMSVidGraphSegmentContainer)),
            'ppCtl',
        )
    ),
    COMMETHOD(
        ['propput', helpstring('Graph that contains this segment')],
        HRESULT,
        'Container',
        (['in'], POINTER(IMSVidGraphSegmentContainer), 'ppCtl')
    ),
    COMMETHOD(
        ['propget', helpstring('Type of Segment')],
        HRESULT,
        'type',
        (['out', 'retval'], POINTER(MSVidSegmentType), 'pType')
    ),
    COMMETHOD(
        ['propget', helpstring('Category this segment is for')],
        HRESULT,
        'Category',
        (
            ['out', 'retval'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'pGuid',
        )
    ),
    COMMETHOD([], HRESULT, 'Build'),
    COMMETHOD([], HRESULT, 'PostBuild'),
    COMMETHOD([], HRESULT, 'PreRun'),
    COMMETHOD([], HRESULT, 'PostRun'),
    COMMETHOD([], HRESULT, 'PreStop'),
    COMMETHOD([], HRESULT, 'PostStop'),
    COMMETHOD(
        [],
        HRESULT,
        'OnEventNotify',
        ([], c_int, 'lEventCode'),
        ([], LONG_PTR, 'lEventParm1'),
        ([], LONG_PTR, 'lEventParm2')
    ),
    COMMETHOD([], HRESULT, 'Decompose'),
]

################################################################
# code template for IMSVidGraphSegment implementation
# class IMSVidGraphSegment_Impl(object):
#     def _get(self):
#         '-no docstring-'
#         #return pInit
#     def _set(self, pInit):
#         '-no docstring-'
#     Init = property(_get, _set, doc = _set.__doc__)
#
#     def EnumFilters(self):
#         '-no docstring-'
#         #return pNewEnum
#
#     def _get(self):
#         'Graph that contains this segment'
#         #return ppCtl
#     def _set(self, ppCtl):
#         'Graph that contains this segment'
#     Container = property(_get, _set, doc = _set.__doc__)
#
#     @property
#     def type(self):
#         'Type of Segment'
#         #return pType
#
#     @property
#     def Category(self):
#         'Category this segment is for'
#         #return pGuid
#
#     def Build(self):
#         '-no docstring-'
#         #return 
#
#     def PostBuild(self):
#         '-no docstring-'
#         #return 
#
#     def PreRun(self):
#         '-no docstring-'
#         #return 
#
#     def PostRun(self):
#         '-no docstring-'
#         #return 
#
#     def PreStop(self):
#         '-no docstring-'
#         #return 
#
#     def PostStop(self):
#         '-no docstring-'
#         #return 
#
#     def OnEventNotify(self, lEventCode, lEventParm1, lEventParm2):
#         '-no docstring-'
#         #return 
#
#     def Decompose(self):
#         '-no docstring-'
#         #return 
#


class _IMSVidCtlEvents(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """MS Video Control Events Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{B0EDF164-910A-11D2-B632-00C04F79498E}')
    _idlflags_ = []
    _methods_ = []

    if TYPE_CHECKING:  # dispmembers
        def Click(self) -> hints.Incomplete: ...
        def DblClick(self) -> hints.Incomplete: ...
        def KeyDown(self, KeyCode: hints.Incomplete, Shift: hints.Incomplete) -> hints.Incomplete: ...
        def KeyPress(self, KeyAscii: hints.Incomplete) -> hints.Incomplete: ...
        def KeyUp(self, KeyCode: hints.Incomplete, Shift: hints.Incomplete) -> hints.Incomplete: ...
        def MouseDown(self, Button: hints.Incomplete, Shift: hints.Incomplete, x: hints.Incomplete, y: hints.Incomplete) -> hints.Incomplete: ...
        def MouseMove(self, Button: hints.Incomplete, Shift: hints.Incomplete, x: hints.Incomplete, y: hints.Incomplete) -> hints.Incomplete: ...
        def MouseUp(self, Button: hints.Incomplete, Shift: hints.Incomplete, x: hints.Incomplete, y: hints.Incomplete) -> hints.Incomplete: ...
        def Error(self, Number: hints.Incomplete, Description: hints.Incomplete, Scode: hints.Incomplete, Source: hints.Incomplete, HelpFile: hints.Incomplete, HelpContext: hints.Incomplete, CancelDisplay: hints.Incomplete) -> hints.Incomplete: ...
        def StateChange(self, PrevState: hints.Incomplete, CurrState: hints.Incomplete) -> hints.Incomplete: ...


_IMSVidCtlEvents._disp_methods_ = [
    DISPMETHOD([dispid(-600)], None, 'Click'),
    DISPMETHOD([dispid(-601)], None, 'DblClick'),
    DISPMETHOD(
        [dispid(-602)],
        None,
        'KeyDown',
        ([], POINTER(c_short), 'KeyCode'),
        ([], c_short, 'Shift')
    ),
    DISPMETHOD(
        [dispid(-603)],
        None,
        'KeyPress',
        ([], POINTER(c_short), 'KeyAscii')
    ),
    DISPMETHOD(
        [dispid(-604)],
        None,
        'KeyUp',
        ([], POINTER(c_short), 'KeyCode'),
        ([], c_short, 'Shift')
    ),
    DISPMETHOD(
        [dispid(-605)],
        None,
        'MouseDown',
        ([], c_short, 'Button'),
        ([], c_short, 'Shift'),
        (
            [],
            comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.OLE_XPOS_PIXELS,
            'x',
        ),
        (
            [],
            comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.OLE_YPOS_PIXELS,
            'y',
        )
    ),
    DISPMETHOD(
        [dispid(-606)],
        None,
        'MouseMove',
        ([], c_short, 'Button'),
        ([], c_short, 'Shift'),
        (
            [],
            comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.OLE_XPOS_PIXELS,
            'x',
        ),
        (
            [],
            comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.OLE_YPOS_PIXELS,
            'y',
        )
    ),
    DISPMETHOD(
        [dispid(-607)],
        None,
        'MouseUp',
        ([], c_short, 'Button'),
        ([], c_short, 'Shift'),
        (
            [],
            comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.OLE_XPOS_PIXELS,
            'x',
        ),
        (
            [],
            comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.OLE_YPOS_PIXELS,
            'y',
        )
    ),
    DISPMETHOD(
        [dispid(-608)],
        None,
        'Error',
        ([], c_short, 'Number'),
        ([], POINTER(BSTR), 'Description'),
        ([], c_int, 'Scode'),
        ([], BSTR, 'Source'),
        ([], BSTR, 'HelpFile'),
        ([], c_int, 'HelpContext'),
        ([], STRING, 'CancelDisplay')
    ),
    DISPMETHOD(
        [dispid(21)],
        None,
        'StateChange',
        ([], MSVidCtlStateList, 'PrevState'),
        ([], MSVidCtlStateList, 'CurrState')
    ),
]

IMSVidVideoInputDevice._methods_ = [
]

################################################################
# code template for IMSVidVideoInputDevice implementation
# class IMSVidVideoInputDevice_Impl(object):

IMSVidTuner._methods_ = [
    COMMETHOD(
        [dispid(27), 'propget'],
        HRESULT,
        'Tune',
        (['out', 'retval'], POINTER(POINTER(ITuneRequest)), 'ppTR')
    ),
    COMMETHOD(
        [dispid(27), 'propput'],
        HRESULT,
        'Tune',
        (['in'], POINTER(ITuneRequest), 'ppTR')
    ),
    COMMETHOD(
        [dispid(28), 'propget'],
        HRESULT,
        'TuningSpace',
        (['out', 'retval'], POINTER(POINTER(ITuningSpace)), 'plTS')
    ),
    COMMETHOD(
        [dispid(28), 'restricted', 'hidden', 'propput'],
        HRESULT,
        'TuningSpace',
        (['in'], POINTER(ITuningSpace), 'plTS')
    ),
]

################################################################
# code template for IMSVidTuner implementation
# class IMSVidTuner_Impl(object):
#     def _get(self):
#         '-no docstring-'
#         #return ppTR
#     def _set(self, ppTR):
#         '-no docstring-'
#     Tune = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         '-no docstring-'
#         #return plTS
#     def _set(self, plTS):
#         '-no docstring-'
#     TuningSpace = property(_get, _set, doc = _set.__doc__)
#

IMSVidAnalogTuner._methods_ = [
    COMMETHOD(
        [dispid(10), 'propget'],
        HRESULT,
        'Channel',
        (['out', 'retval'], POINTER(c_int), 'Channel')
    ),
    COMMETHOD(
        [dispid(10), 'propput'],
        HRESULT,
        'Channel',
        (['in'], c_int, 'Channel')
    ),
    COMMETHOD(
        [dispid(14), 'propget'],
        HRESULT,
        'VideoFrequency',
        (['out', 'retval'], POINTER(c_int), 'lcc')
    ),
    COMMETHOD(
        [dispid(15), 'propget'],
        HRESULT,
        'AudioFrequency',
        (['out', 'retval'], POINTER(c_int), 'lcc')
    ),
    COMMETHOD(
        [dispid(4), 'propget'],
        HRESULT,
        'CountryCode',
        (['out', 'retval'], POINTER(c_int), 'lcc')
    ),
    COMMETHOD(
        [dispid(4), 'propput'],
        HRESULT,
        'CountryCode',
        (['in'], c_int, 'lcc')
    ),
    COMMETHOD(
        [dispid(29), 'propget'],
        HRESULT,
        'SAP',
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'pfSapOn')
    ),
    COMMETHOD(
        [dispid(29), 'propput'],
        HRESULT,
        'SAP',
        (['in'], VARIANT_BOOL, 'pfSapOn')
    ),
    COMMETHOD(
        [dispid(13)],
        HRESULT,
        'ChannelAvailable',
        (['in'], c_int, 'nChannel'),
        (['out'], POINTER(c_int), 'SignalStrength'),
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'fSignalPresent')
    ),
]

################################################################
# code template for IMSVidAnalogTuner implementation
# class IMSVidAnalogTuner_Impl(object):
#     def _get(self):
#         '-no docstring-'
#         #return Channel
#     def _set(self, Channel):
#         '-no docstring-'
#     Channel = property(_get, _set, doc = _set.__doc__)
#
#     @property
#     def VideoFrequency(self):
#         '-no docstring-'
#         #return lcc
#
#     @property
#     def AudioFrequency(self):
#         '-no docstring-'
#         #return lcc
#
#     def _get(self):
#         '-no docstring-'
#         #return lcc
#     def _set(self, lcc):
#         '-no docstring-'
#     CountryCode = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         '-no docstring-'
#         #return pfSapOn
#     def _set(self, pfSapOn):
#         '-no docstring-'
#     SAP = property(_get, _set, doc = _set.__doc__)
#
#     def ChannelAvailable(self, nChannel):
#         '-no docstring-'
#         #return SignalStrength, fSignalPresent
#

IMSVidAnalogTuner2._methods_ = [
    COMMETHOD(
        [dispid(193), 'propget'],
        HRESULT,
        'TVFormats',
        (['out', 'retval'], POINTER(c_int), 'Formats')
    ),
    COMMETHOD(
        [dispid(194), 'propget'],
        HRESULT,
        'TunerModes',
        (['out', 'retval'], POINTER(c_int), 'Modes')
    ),
    COMMETHOD(
        [dispid(195), 'propget'],
        HRESULT,
        'NumAuxInputs',
        (['out', 'retval'], POINTER(c_int), 'Inputs')
    ),
]

################################################################
# code template for IMSVidAnalogTuner2 implementation
# class IMSVidAnalogTuner2_Impl(object):
#     @property
#     def TVFormats(self):
#         '-no docstring-'
#         #return Formats
#
#     @property
#     def TunerModes(self):
#         '-no docstring-'
#         #return Modes
#
#     @property
#     def NumAuxInputs(self):
#         '-no docstring-'
#         #return Inputs
#


class _wireSAFEARRAY(Structure):
    pass


class _wireSAFEARRAY_UNION(Structure):
    pass


class __MIDL_IOleAutomationTypes_0001(Union):
    pass


class _wireSAFEARR_BSTR(Structure):
    pass


class _FLAGGED_WORD_BLOB(Structure):
    pass


_wireSAFEARR_BSTR._fields_ = [
    ('Size', c_ulong),
    ('aBstr', POINTER(POINTER(_FLAGGED_WORD_BLOB))),
]

assert sizeof(_wireSAFEARR_BSTR) == 16, sizeof(_wireSAFEARR_BSTR)
assert alignment(_wireSAFEARR_BSTR) == 8, alignment(_wireSAFEARR_BSTR)


class _wireSAFEARR_UNKNOWN(Structure):
    pass


_wireSAFEARR_UNKNOWN._fields_ = [
    ('Size', c_ulong),
    ('apUnknown', POINTER(POINTER(IUnknown))),
]

assert sizeof(_wireSAFEARR_UNKNOWN) == 16, sizeof(_wireSAFEARR_UNKNOWN)
assert alignment(_wireSAFEARR_UNKNOWN) == 8, alignment(_wireSAFEARR_UNKNOWN)


class _wireSAFEARR_DISPATCH(Structure):
    pass


_wireSAFEARR_DISPATCH._fields_ = [
    ('Size', c_ulong),
    ('apDispatch', POINTER(POINTER(IDispatch))),
]

assert sizeof(_wireSAFEARR_DISPATCH) == 16, sizeof(_wireSAFEARR_DISPATCH)
assert alignment(_wireSAFEARR_DISPATCH) == 8, alignment(_wireSAFEARR_DISPATCH)


class _wireSAFEARR_VARIANT(Structure):
    pass


class _wireVARIANT(Structure):
    pass


_wireSAFEARR_VARIANT._fields_ = [
    ('Size', c_ulong),
    ('aVariant', POINTER(POINTER(_wireVARIANT))),
]

assert sizeof(_wireSAFEARR_VARIANT) == 16, sizeof(_wireSAFEARR_VARIANT)
assert alignment(_wireSAFEARR_VARIANT) == 8, alignment(_wireSAFEARR_VARIANT)


class _wireSAFEARR_BRECORD(Structure):
    pass


class _wireBRECORD(Structure):
    pass


_wireSAFEARR_BRECORD._fields_ = [
    ('Size', c_ulong),
    ('aRecord', POINTER(POINTER(_wireBRECORD))),
]

assert sizeof(_wireSAFEARR_BRECORD) == 16, sizeof(_wireSAFEARR_BRECORD)
assert alignment(_wireSAFEARR_BRECORD) == 8, alignment(_wireSAFEARR_BRECORD)


class _wireSAFEARR_HAVEIID(Structure):
    pass


_wireSAFEARR_HAVEIID._fields_ = [
    ('Size', c_ulong),
    ('apUnknown', POINTER(POINTER(IUnknown))),
    ('iid', comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
]

assert sizeof(_wireSAFEARR_HAVEIID) == 32, sizeof(_wireSAFEARR_HAVEIID)
assert alignment(_wireSAFEARR_HAVEIID) == 8, alignment(_wireSAFEARR_HAVEIID)


class _BYTE_SIZEDARR(Structure):
    pass


_BYTE_SIZEDARR._fields_ = [
    ('clSize', c_ulong),
    ('pData', POINTER(c_ubyte)),
]

assert sizeof(_BYTE_SIZEDARR) == 16, sizeof(_BYTE_SIZEDARR)
assert alignment(_BYTE_SIZEDARR) == 8, alignment(_BYTE_SIZEDARR)


class _SHORT_SIZEDARR(Structure):
    pass


_SHORT_SIZEDARR._fields_ = [
    ('clSize', c_ulong),
    ('pData', POINTER(c_ushort)),
]

assert sizeof(_SHORT_SIZEDARR) == 16, sizeof(_SHORT_SIZEDARR)
assert alignment(_SHORT_SIZEDARR) == 8, alignment(_SHORT_SIZEDARR)


class _LONG_SIZEDARR(Structure):
    pass


_LONG_SIZEDARR._fields_ = [
    ('clSize', c_ulong),
    ('pData', POINTER(c_ulong)),
]

assert sizeof(_LONG_SIZEDARR) == 16, sizeof(_LONG_SIZEDARR)
assert alignment(_LONG_SIZEDARR) == 8, alignment(_LONG_SIZEDARR)


class _HYPER_SIZEDARR(Structure):
    pass


_HYPER_SIZEDARR._fields_ = [
    ('clSize', c_ulong),
    ('pData', POINTER(c_longlong)),
]

assert sizeof(_HYPER_SIZEDARR) == 16, sizeof(_HYPER_SIZEDARR)
assert alignment(_HYPER_SIZEDARR) == 8, alignment(_HYPER_SIZEDARR)

__MIDL_IOleAutomationTypes_0001._fields_ = [
    ('BstrStr', _wireSAFEARR_BSTR),
    ('UnknownStr', _wireSAFEARR_UNKNOWN),
    ('DispatchStr', _wireSAFEARR_DISPATCH),
    ('VariantStr', _wireSAFEARR_VARIANT),
    ('RecordStr', _wireSAFEARR_BRECORD),
    ('HaveIidStr', _wireSAFEARR_HAVEIID),
    ('ByteStr', _BYTE_SIZEDARR),
    ('WordStr', _SHORT_SIZEDARR),
    ('LongStr', _LONG_SIZEDARR),
    ('HyperStr', _HYPER_SIZEDARR),
]

assert sizeof(__MIDL_IOleAutomationTypes_0001) == 32, sizeof(__MIDL_IOleAutomationTypes_0001)
assert alignment(__MIDL_IOleAutomationTypes_0001) == 8, alignment(__MIDL_IOleAutomationTypes_0001)

_wireSAFEARRAY_UNION._fields_ = [
    ('sfType', c_ulong),
    ('u', __MIDL_IOleAutomationTypes_0001),
]

assert sizeof(_wireSAFEARRAY_UNION) == 40, sizeof(_wireSAFEARRAY_UNION)
assert alignment(_wireSAFEARRAY_UNION) == 8, alignment(_wireSAFEARRAY_UNION)

_wireSAFEARRAY._fields_ = [
    ('cDims', c_ushort),
    ('fFeatures', c_ushort),
    ('cbElements', c_ulong),
    ('cLocks', c_ulong),
    ('uArrayStructs', _wireSAFEARRAY_UNION),
    ('rgsabound', POINTER(tagSAFEARRAYBOUND)),
]

assert sizeof(_wireSAFEARRAY) == 64, sizeof(_wireSAFEARRAY)
assert alignment(_wireSAFEARRAY) == 8, alignment(_wireSAFEARRAY)
wirePSAFEARRAY = POINTER(POINTER(_wireSAFEARRAY))


class tagCACY(Structure):
    pass


tagCACY._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(c_longlong)),
]

assert sizeof(tagCACY) == 16, sizeof(tagCACY)
assert alignment(tagCACY) == 8, alignment(tagCACY)


class _FilterInfo(Structure):
    pass


class IFilterGraph(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    _case_insensitive_ = True
    _iid_ = GUID('{56A8689F-0AD4-11CE-B03A-0020AF0BA770}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def AddFilter(self, pFilter: hints.Incomplete, pName: hints.Incomplete) -> hints.Hresult: ...
        def RemoveFilter(self, pFilter: hints.Incomplete) -> hints.Hresult: ...
        def EnumFilters(self) -> 'IEnumFilters': ...
        def FindFilterByName(self, pName: hints.Incomplete) -> 'IBaseFilter': ...
        def ConnectDirect(self, ppinOut: hints.Incomplete, ppinIn: hints.Incomplete, pmt: hints.Incomplete) -> hints.Hresult: ...
        def Reconnect(self, pPin: hints.Incomplete) -> hints.Hresult: ...
        def Disconnect(self, pPin: hints.Incomplete) -> hints.Hresult: ...
        def SetDefaultSyncSource(self) -> hints.Hresult: ...


_FilterInfo._fields_ = [
    ('achName', c_ushort * 128),
    ('pGraph', POINTER(IFilterGraph)),
]

assert sizeof(_FilterInfo) == 264, sizeof(_FilterInfo)
assert alignment(_FilterInfo) == 8, alignment(_FilterInfo)


class tagCADATE(Structure):
    pass


tagCADATE._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(c_double)),
]

assert sizeof(tagCADATE) == 16, sizeof(tagCADATE)
assert alignment(tagCADATE) == 8, alignment(tagCADATE)

IMSVidStreamBufferSourceEvent._methods_ = [
    COMMETHOD(
        [helpstring('Source Certificate Failure')],
        HRESULT,
        'CertificateFailure',
    ),
    COMMETHOD(
        [helpstring('Source Certificate Success')],
        HRESULT,
        'CertificateSuccess',
    ),
    COMMETHOD([helpstring('Ratings Blocked')], HRESULT, 'RatingsBlocked'),
    COMMETHOD([helpstring('Ratings Unblocked')], HRESULT, 'RatingsUnblocked'),
    COMMETHOD([helpstring('Ratings Changed')], HRESULT, 'RatingsChanged'),
    COMMETHOD(
        [helpstring('Source Time Hole')],
        HRESULT,
        'TimeHole',
        (['in'], c_int, 'StreamOffsetMS'),
        (['in'], c_int, 'SizeMS')
    ),
    COMMETHOD([helpstring('Source Stale Data Read')], HRESULT, 'StaleDataRead'),
    COMMETHOD(
        [helpstring('Source Content Becoming Stale')],
        HRESULT,
        'ContentBecomingStale',
    ),
    COMMETHOD(
        [helpstring('Source Stale File Deleted')],
        HRESULT,
        'StaleFileDeleted',
    ),
]

################################################################
# code template for IMSVidStreamBufferSourceEvent implementation
# class IMSVidStreamBufferSourceEvent_Impl(object):
#     def CertificateFailure(self):
#         'Source Certificate Failure'
#         #return 
#
#     def CertificateSuccess(self):
#         'Source Certificate Success'
#         #return 
#
#     def RatingsBlocked(self):
#         'Ratings Blocked'
#         #return 
#
#     def RatingsUnblocked(self):
#         'Ratings Unblocked'
#         #return 
#
#     def RatingsChanged(self):
#         'Ratings Changed'
#         #return 
#
#     def TimeHole(self, StreamOffsetMS, SizeMS):
#         'Source Time Hole'
#         #return 
#
#     def StaleDataRead(self):
#         'Source Stale Data Read'
#         #return 
#
#     def ContentBecomingStale(self):
#         'Source Content Becoming Stale'
#         #return 
#
#     def StaleFileDeleted(self):
#         'Source Stale File Deleted'
#         #return 
#


class tagCABSTR(Structure):
    pass


tagCABSTR._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(BSTR)),
]

assert sizeof(tagCABSTR) == 16, sizeof(tagCABSTR)
assert alignment(tagCABSTR) == 8, alignment(tagCABSTR)

IMSVidWebDVDEvent._methods_ = [
    COMMETHOD(
        [helpstring('Notifies the client about DVD Code')],
        HRESULT,
        'DVDNotify',
        (['in'], c_int, 'lEventCode'),
        (['in'], VARIANT, 'lParam1'),
        (['in'], VARIANT, 'lParam2')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'PlayForwards',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'PlayBackwards',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'ShowMenu',
        (['in'], DVDMenuIDConstants, 'MenuID'),
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'Resume',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'SelectOrActivateButton',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'StillOff',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'PauseOn',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'ChangeCurrentAudioStream',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'ChangeCurrentSubpictureStream',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'ChangeCurrentAngle',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'PlayAtTimeInTitle',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'PlayAtTime',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'PlayChapterInTitle',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'PlayChapter',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'ReplayChapter',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'PlayNextChapter',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'Stop',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'ReturnFromSubmenu',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'PlayTitle',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'PlayPrevChapter',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'ChangeKaraokePresMode',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
    COMMETHOD(
        [helpstring('Notifies the client')],
        HRESULT,
        'ChangeVideoPresMode',
        (['in'], VARIANT_BOOL, 'bEnabled')
    ),
]

################################################################
# code template for IMSVidWebDVDEvent implementation
# class IMSVidWebDVDEvent_Impl(object):
#     def DVDNotify(self, lEventCode, lParam1, lParam2):
#         'Notifies the client about DVD Code'
#         #return 
#
#     def PlayForwards(self, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def PlayBackwards(self, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def ShowMenu(self, MenuID, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def Resume(self, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def SelectOrActivateButton(self, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def StillOff(self, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def PauseOn(self, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def ChangeCurrentAudioStream(self, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def ChangeCurrentSubpictureStream(self, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def ChangeCurrentAngle(self, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def PlayAtTimeInTitle(self, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def PlayAtTime(self, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def PlayChapterInTitle(self, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def PlayChapter(self, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def ReplayChapter(self, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def PlayNextChapter(self, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def Stop(self, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def ReturnFromSubmenu(self, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def PlayTitle(self, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def PlayPrevChapter(self, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def ChangeKaraokePresMode(self, bEnabled):
#         'Notifies the client'
#         #return 
#
#     def ChangeVideoPresMode(self, bEnabled):
#         'Notifies the client'
#         #return 
#


class MSVidWebDVDAdm(CoClass):
    """MSVidWebDVDAdm Class"""
    _reg_clsid_ = GUID('{FA7C375B-66A7-4280-879D-FD459C84BB02}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidWebDVDAdm._com_interfaces_ = [IMSVidWebDVDAdm]

IMSVidWebDVD._methods_ = [
    COMMETHOD(
        [dispid(1610940416)],
        HRESULT,
        'OnDVDEvent',
        (['in'], c_int, 'lEvent'),
        (['in'], LONG_PTR, 'lParam1'),
        (['in'], LONG_PTR, 'lParam2')
    ),
    COMMETHOD(
        [dispid(42), helpstring('method PlayTitle')],
        HRESULT,
        'PlayTitle',
        (['in'], c_int, 'lTitle')
    ),
    COMMETHOD(
        [dispid(43), helpstring('method PlayChapterInTitle')],
        HRESULT,
        'PlayChapterInTitle',
        (['in'], c_int, 'lTitle'),
        (['in'], c_int, 'lChapter')
    ),
    COMMETHOD(
        [dispid(44), helpstring('method PlayChapter')],
        HRESULT,
        'PlayChapter',
        (['in'], c_int, 'lChapter')
    ),
    COMMETHOD(
        [dispid(45), helpstring('method PlayChaptersAutoStop')],
        HRESULT,
        'PlayChaptersAutoStop',
        (['in'], c_int, 'lTitle'),
        (['in'], c_int, 'lstrChapter'),
        (['in'], c_int, 'lChapterCount')
    ),
    COMMETHOD(
        [dispid(46), helpstring('method PlayAtTime')],
        HRESULT,
        'PlayAtTime',
        (['in'], BSTR, 'strTime')
    ),
    COMMETHOD(
        [dispid(47), helpstring('method PlayAtTimeInTitle')],
        HRESULT,
        'PlayAtTimeInTitle',
        (['in'], c_int, 'lTitle'),
        (['in'], BSTR, 'strTime')
    ),
    COMMETHOD(
        [dispid(48), helpstring('method PlayPeriodInTitleAutoStop')],
        HRESULT,
        'PlayPeriodInTitleAutoStop',
        (['in'], c_int, 'lTitle'),
        (['in'], BSTR, 'strStartTime'),
        (['in'], BSTR, 'strEndTime')
    ),
    COMMETHOD(
        [dispid(49), helpstring('method ReplayChapter')],
        HRESULT,
        'ReplayChapter',
    ),
    COMMETHOD(
        [dispid(50), helpstring('method PlayPrevChapter')],
        HRESULT,
        'PlayPrevChapter',
    ),
    COMMETHOD(
        [dispid(51), helpstring('method PlayNextChapter')],
        HRESULT,
        'PlayNextChapter',
    ),
    COMMETHOD([dispid(54), helpstring('method StillOff')], HRESULT, 'StillOff'),
    COMMETHOD(
        [dispid(55), helpstring('AudioLanguage'), 'propget'],
        HRESULT,
        'AudioLanguage',
        (['in'], c_int, 'lStream'),
        (['in', 'optional'], VARIANT_BOOL, 'fFormat', False),
        (['out', 'retval'], POINTER(BSTR), 'strAudioLang')
    ),
    COMMETHOD(
        [dispid(56), helpstring('method ShowMenu')],
        HRESULT,
        'ShowMenu',
        (['in'], DVDMenuIDConstants, 'MenuID')
    ),
    COMMETHOD([dispid(57), helpstring('method Resume')], HRESULT, 'Resume'),
    COMMETHOD(
        [dispid(58), helpstring('method ReturnFromSubmenu')],
        HRESULT,
        'ReturnFromSubmenu',
    ),
    COMMETHOD(
        [dispid(59), helpstring('ButtonsAvailable'), 'propget'],
        HRESULT,
        'ButtonsAvailable',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(60), helpstring('CurrentButton'), 'propget'],
        HRESULT,
        'CurrentButton',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(61), helpstring('method SelectAndActivateButton')],
        HRESULT,
        'SelectAndActivateButton',
        (['in'], c_int, 'lButton')
    ),
    COMMETHOD(
        [dispid(62), helpstring('method ActivateButton')],
        HRESULT,
        'ActivateButton',
    ),
    COMMETHOD(
        [dispid(63), helpstring('method SelectRightButton')],
        HRESULT,
        'SelectRightButton',
    ),
    COMMETHOD(
        [dispid(64), helpstring('method SelectLeftButton')],
        HRESULT,
        'SelectLeftButton',
    ),
    COMMETHOD(
        [dispid(65), helpstring('method SelectLowerButton')],
        HRESULT,
        'SelectLowerButton',
    ),
    COMMETHOD(
        [dispid(66), helpstring('method SelectUpperButton')],
        HRESULT,
        'SelectUpperButton',
    ),
    COMMETHOD(
        [dispid(67), helpstring('method ActivateAtPosition')],
        HRESULT,
        'ActivateAtPosition',
        (['in'], c_int, 'xPos'),
        (['in'], c_int, 'yPos')
    ),
    COMMETHOD(
        [dispid(68), helpstring('method SelectAtPosition')],
        HRESULT,
        'SelectAtPosition',
        (['in'], c_int, 'xPos'),
        (['in'], c_int, 'yPos')
    ),
    COMMETHOD(
        [dispid(69), helpstring('ButtonAtPosition'), 'propget'],
        HRESULT,
        'ButtonAtPosition',
        (['in'], c_int, 'xPos'),
        (['in'], c_int, 'yPos'),
        (['out', 'retval'], POINTER(c_int), 'plButton')
    ),
    COMMETHOD(
        [dispid(70), helpstring('NumberOfChapters'), 'propget'],
        HRESULT,
        'NumberOfChapters',
        (['in'], c_int, 'lTitle'),
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(71), helpstring('TotalTitleTime'), 'propget'],
        HRESULT,
        'TotalTitleTime',
        (['out', 'retval'], POINTER(BSTR), 'pVal')
    ),
    COMMETHOD(
        [dispid(72), helpstring('TitlesAvailable'), 'propget'],
        HRESULT,
        'TitlesAvailable',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(73), helpstring('VolumesAvailable'), 'propget'],
        HRESULT,
        'VolumesAvailable',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(74), helpstring('CurrentVolume'), 'propget'],
        HRESULT,
        'CurrentVolume',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(75), helpstring('CurrentDiscSide'), 'propget'],
        HRESULT,
        'CurrentDiscSide',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(76), helpstring('CurrentDomain'), 'propget'],
        HRESULT,
        'CurrentDomain',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(77), helpstring('CurrentChapter'), 'propget'],
        HRESULT,
        'CurrentChapter',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(78), helpstring('CurrentTitle'), 'propget'],
        HRESULT,
        'CurrentTitle',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(79), helpstring('CurrentTime'), 'propget'],
        HRESULT,
        'CurrentTime',
        (['out', 'retval'], POINTER(BSTR), 'pVal')
    ),
    COMMETHOD(
        [dispid(81), helpstring('method DVDTimeCode2bstr')],
        HRESULT,
        'DVDTimeCode2bstr',
        (['in'], c_int, 'timeCode'),
        (['out', 'retval'], POINTER(BSTR), 'pTimeStr')
    ),
    COMMETHOD(
        [dispid(82), helpstring('DVDDirectory'), 'propget'],
        HRESULT,
        'DVDDirectory',
        (['out', 'retval'], POINTER(BSTR), 'pVal')
    ),
    COMMETHOD(
        [dispid(82), helpstring('DVDDirectory'), 'propput'],
        HRESULT,
        'DVDDirectory',
        (['in'], BSTR, 'pVal')
    ),
    COMMETHOD(
        [dispid(83), helpstring('method IsSubpictureStreamEnabled')],
        HRESULT,
        'IsSubpictureStreamEnabled',
        (['in'], c_int, 'lStream'),
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'fEnabled')
    ),
    COMMETHOD(
        [dispid(84), helpstring('method IsAudioStreamEnabled')],
        HRESULT,
        'IsAudioStreamEnabled',
        (['in'], c_int, 'lStream'),
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'fEnabled')
    ),
    COMMETHOD(
        [dispid(85), helpstring('CurrentSubpictureStream'), 'propget'],
        HRESULT,
        'CurrentSubpictureStream',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(85), helpstring('CurrentSubpictureStream'), 'propput'],
        HRESULT,
        'CurrentSubpictureStream',
        (['in'], c_int, 'pVal')
    ),
    COMMETHOD(
        [dispid(86), helpstring('SubpictureLanguage'), 'propget'],
        HRESULT,
        'SubpictureLanguage',
        ([], c_int, 'lStream'),
        (['out', 'retval'], POINTER(BSTR), 'strLanguage')
    ),
    COMMETHOD(
        [dispid(87), helpstring('CurrentAudioStream'), 'propget'],
        HRESULT,
        'CurrentAudioStream',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(87), helpstring('CurrentAudioStream'), 'propput'],
        HRESULT,
        'CurrentAudioStream',
        (['in'], c_int, 'pVal')
    ),
    COMMETHOD(
        [dispid(88), helpstring('AudioStreamsAvailable'), 'propget'],
        HRESULT,
        'AudioStreamsAvailable',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(89), helpstring('AnglesAvailable'), 'propget'],
        HRESULT,
        'AnglesAvailable',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(90), helpstring('CurrentAngle'), 'propget'],
        HRESULT,
        'CurrentAngle',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(90), helpstring('CurrentAngle'), 'propput'],
        HRESULT,
        'CurrentAngle',
        (['in'], c_int, 'pVal')
    ),
    COMMETHOD(
        [dispid(93), helpstring('SubpictureStreamsAvailable'), 'propget'],
        HRESULT,
        'SubpictureStreamsAvailable',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(94), helpstring('SubpictureOn'), 'propget'],
        HRESULT,
        'SubpictureOn',
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'pVal')
    ),
    COMMETHOD(
        [dispid(94), helpstring('SubpictureOn'), 'propput'],
        HRESULT,
        'SubpictureOn',
        (['in'], VARIANT_BOOL, 'pVal')
    ),
    COMMETHOD(
        [dispid(95), helpstring('DVDUniqueID'), 'propget'],
        HRESULT,
        'DVDUniqueID',
        (['out', 'retval'], POINTER(BSTR), 'pVal')
    ),
    COMMETHOD(
        [dispid(97), helpstring('method AcceptParentalLevelChange')],
        HRESULT,
        'AcceptParentalLevelChange',
        (['in'], VARIANT_BOOL, 'fAccept'),
        (['in'], BSTR, 'strUserName'),
        (['in'], BSTR, 'strPassword')
    ),
    COMMETHOD(
        [dispid(98), helpstring('method NotifyParentalLevelChange')],
        HRESULT,
        'NotifyParentalLevelChange',
        (['in'], VARIANT_BOOL, 'newVal')
    ),
    COMMETHOD(
        [dispid(99), helpstring('method SelectParentalCountry')],
        HRESULT,
        'SelectParentalCountry',
        (['in'], c_int, 'lCountry'),
        (['in'], BSTR, 'strUserName'),
        (['in'], BSTR, 'strPassword')
    ),
    COMMETHOD(
        [dispid(100), helpstring('method SelectParentalLevel')],
        HRESULT,
        'SelectParentalLevel',
        (['in'], c_int, 'lParentalLevel'),
        (['in'], BSTR, 'strUserName'),
        (['in'], BSTR, 'strPassword')
    ),
    COMMETHOD(
        [dispid(101), helpstring('TitleParentalLevels'), 'propget'],
        HRESULT,
        'TitleParentalLevels',
        (['in'], c_int, 'lTitle'),
        (['out', 'retval'], POINTER(c_int), 'plParentalLevels')
    ),
    COMMETHOD(
        [dispid(102), helpstring('PlayerParentalCountry'), 'propget'],
        HRESULT,
        'PlayerParentalCountry',
        (['out', 'retval'], POINTER(c_int), 'plCountryCode')
    ),
    COMMETHOD(
        [dispid(103), helpstring('PlayerParentalLevel'), 'propget'],
        HRESULT,
        'PlayerParentalLevel',
        (['out', 'retval'], POINTER(c_int), 'plParentalLevel')
    ),
    COMMETHOD([dispid(104), helpstring('method Eject')], HRESULT, 'Eject'),
    COMMETHOD(
        [dispid(105), helpstring('method UOPValid')],
        HRESULT,
        'UOPValid',
        (['in'], c_int, 'lUOP'),
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'pfValid')
    ),
    COMMETHOD(
        [dispid(106), helpstring('SPRM'), 'propget'],
        HRESULT,
        'SPRM',
        (['in'], c_int, 'lIndex'),
        (['out', 'retval'], POINTER(c_short), 'psSPRM')
    ),
    COMMETHOD(
        [dispid(107), helpstring('GPRM'), 'propget'],
        HRESULT,
        'GPRM',
        (['in'], c_int, 'lIndex'),
        (['out', 'retval'], POINTER(c_short), 'psSPRM')
    ),
    COMMETHOD(
        [dispid(107), helpstring('GPRM'), 'propput'],
        HRESULT,
        'GPRM',
        (['in'], c_int, 'lIndex'),
        (['in'], c_short, 'psSPRM')
    ),
    COMMETHOD(
        [dispid(108), helpstring('DVDTextStringType'), 'propget'],
        HRESULT,
        'DVDTextStringType',
        (['in'], c_int, 'lLangIndex'),
        (['in'], c_int, 'lStringIndex'),
        (['out', 'retval'], POINTER(DVDTextStringType), 'pType')
    ),
    COMMETHOD(
        [dispid(109), helpstring('DVDTextString'), 'propget'],
        HRESULT,
        'DVDTextString',
        (['in'], c_int, 'lLangIndex'),
        (['in'], c_int, 'lStringIndex'),
        (['out', 'retval'], POINTER(BSTR), 'pstrText')
    ),
    COMMETHOD(
        [dispid(110), helpstring('DVDTextNumberOfStrings'), 'propget'],
        HRESULT,
        'DVDTextNumberOfStrings',
        (['in'], c_int, 'lLangIndex'),
        (['out', 'retval'], POINTER(c_int), 'plNumOfStrings')
    ),
    COMMETHOD(
        [dispid(111), helpstring('DVDTextNumberOfLanguages'), 'propget'],
        HRESULT,
        'DVDTextNumberOfLanguages',
        (['out', 'retval'], POINTER(c_int), 'plNumOfLangs')
    ),
    COMMETHOD(
        [dispid(112), helpstring('DVDTextLanguageLCID'), 'propget'],
        HRESULT,
        'DVDTextLanguageLCID',
        (['in'], c_int, 'lLangIndex'),
        (['out', 'retval'], POINTER(c_int), 'lcid')
    ),
    COMMETHOD(
        [dispid(113), helpstring('method RegionChange')],
        HRESULT,
        'RegionChange',
    ),
    COMMETHOD(
        [dispid(114), helpstring('DVDAdm'), 'propget'],
        HRESULT,
        'DVDAdm',
        (['out', 'retval'], POINTER(POINTER(IDispatch)), 'pVal')
    ),
    COMMETHOD(
        [dispid(115), helpstring('method DeleteBookmark')],
        HRESULT,
        'DeleteBookmark',
    ),
    COMMETHOD(
        [dispid(116), helpstring('method RestoreBookmark')],
        HRESULT,
        'RestoreBookmark',
    ),
    COMMETHOD(
        [dispid(117), helpstring('method SaveBookmark')],
        HRESULT,
        'SaveBookmark',
    ),
    COMMETHOD(
        [dispid(118), helpstring('method SelectDefaultAudioLanguage')],
        HRESULT,
        'SelectDefaultAudioLanguage',
        (['in'], c_int, 'lang'),
        (['in'], c_int, 'ext')
    ),
    COMMETHOD(
        [dispid(119), helpstring('method SelectDefaultSubpictureLanguage')],
        HRESULT,
        'SelectDefaultSubpictureLanguage',
        (['in'], c_int, 'lang'),
        (['in'], DVDSPExt, 'ext')
    ),
    COMMETHOD(
        [dispid(120), helpstring('PreferredSubpictureStream'), 'propget'],
        HRESULT,
        'PreferredSubpictureStream',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(121), helpstring('DefaultMenuLanguage'), 'propget'],
        HRESULT,
        'DefaultMenuLanguage',
        (['out', 'retval'], POINTER(c_int), 'lang')
    ),
    COMMETHOD(
        [dispid(121), helpstring('DefaultMenuLanguage'), 'propput'],
        HRESULT,
        'DefaultMenuLanguage',
        (['in'], c_int, 'lang')
    ),
    COMMETHOD(
        [dispid(122), helpstring('DefaultSubpictureLanguage'), 'propget'],
        HRESULT,
        'DefaultSubpictureLanguage',
        (['out', 'retval'], POINTER(c_int), 'lang')
    ),
    COMMETHOD(
        [dispid(123), helpstring('DefaultAudioLanguage'), 'propget'],
        HRESULT,
        'DefaultAudioLanguage',
        (['out', 'retval'], POINTER(c_int), 'lang')
    ),
    COMMETHOD(
        [dispid(124), helpstring('DefaultSubpictureLanguageExt'), 'propget'],
        HRESULT,
        'DefaultSubpictureLanguageExt',
        (['out', 'retval'], POINTER(DVDSPExt), 'ext')
    ),
    COMMETHOD(
        [dispid(125), helpstring('DefaultAudioLanguageExt'), 'propget'],
        HRESULT,
        'DefaultAudioLanguageExt',
        (['out', 'retval'], POINTER(c_int), 'ext')
    ),
    COMMETHOD(
        [dispid(126), helpstring('LanguageFromLCID'), 'propget'],
        HRESULT,
        'LanguageFromLCID',
        (['in'], c_int, 'lcid'),
        (['out', 'retval'], POINTER(BSTR), 'lang')
    ),
    COMMETHOD(
        [dispid(127), helpstring('KaraokeAudioPresentationMode'), 'propget'],
        HRESULT,
        'KaraokeAudioPresentationMode',
        (['out', 'retval'], POINTER(c_int), 'pVal')
    ),
    COMMETHOD(
        [dispid(127), helpstring('KaraokeAudioPresentationMode'), 'propput'],
        HRESULT,
        'KaraokeAudioPresentationMode',
        (['in'], c_int, 'pVal')
    ),
    COMMETHOD(
        [dispid(128), helpstring('KaraokeChannelContent'), 'propget'],
        HRESULT,
        'KaraokeChannelContent',
        (['in'], c_int, 'lStream'),
        (['in'], c_int, 'lChan'),
        (['out', 'retval'], POINTER(c_int), 'lContent')
    ),
    COMMETHOD(
        [dispid(129), helpstring('KaraokeChannelAssignment'), 'propget'],
        HRESULT,
        'KaraokeChannelAssignment',
        (['in'], c_int, 'lStream'),
        (['out', 'retval'], POINTER(c_int), 'lChannelAssignment')
    ),
    COMMETHOD(
        [dispid(130), helpstring('method RestorePreferredSettings')],
        HRESULT,
        'RestorePreferredSettings',
    ),
    COMMETHOD(
        [dispid(131), helpstring('ButtonRect'), 'propget'],
        HRESULT,
        'ButtonRect',
        (['in'], c_int, 'lButton'),
        (['out', 'retval'], POINTER(POINTER(IMSVidRect)), 'pRect')
    ),
    COMMETHOD(
        [dispid(132), helpstring('DVDScreenInMouseCoordinates'), 'propget'],
        HRESULT,
        'DVDScreenInMouseCoordinates',
        (['out', 'retval'], POINTER(POINTER(IMSVidRect)), 'ppRect')
    ),
    COMMETHOD(
        [dispid(132), helpstring('DVDScreenInMouseCoordinates'), 'propput'],
        HRESULT,
        'DVDScreenInMouseCoordinates',
        (['in'], POINTER(IMSVidRect), 'ppRect')
    ),
]

################################################################
# code template for IMSVidWebDVD implementation
# class IMSVidWebDVD_Impl(object):
#     def OnDVDEvent(self, lEvent, lParam1, lParam2):
#         '-no docstring-'
#         #return 
#
#     def PlayTitle(self, lTitle):
#         'method PlayTitle'
#         #return 
#
#     def PlayChapterInTitle(self, lTitle, lChapter):
#         'method PlayChapterInTitle'
#         #return 
#
#     def PlayChapter(self, lChapter):
#         'method PlayChapter'
#         #return 
#
#     def PlayChaptersAutoStop(self, lTitle, lstrChapter, lChapterCount):
#         'method PlayChaptersAutoStop'
#         #return 
#
#     def PlayAtTime(self, strTime):
#         'method PlayAtTime'
#         #return 
#
#     def PlayAtTimeInTitle(self, lTitle, strTime):
#         'method PlayAtTimeInTitle'
#         #return 
#
#     def PlayPeriodInTitleAutoStop(self, lTitle, strStartTime, strEndTime):
#         'method PlayPeriodInTitleAutoStop'
#         #return 
#
#     def ReplayChapter(self):
#         'method ReplayChapter'
#         #return 
#
#     def PlayPrevChapter(self):
#         'method PlayPrevChapter'
#         #return 
#
#     def PlayNextChapter(self):
#         'method PlayNextChapter'
#         #return 
#
#     def StillOff(self):
#         'method StillOff'
#         #return 
#
#     @property
#     def AudioLanguage(self, lStream, fFormat):
#         'AudioLanguage'
#         #return strAudioLang
#
#     def ShowMenu(self, MenuID):
#         'method ShowMenu'
#         #return 
#
#     def Resume(self):
#         'method Resume'
#         #return 
#
#     def ReturnFromSubmenu(self):
#         'method ReturnFromSubmenu'
#         #return 
#
#     @property
#     def ButtonsAvailable(self):
#         'ButtonsAvailable'
#         #return pVal
#
#     @property
#     def CurrentButton(self):
#         'CurrentButton'
#         #return pVal
#
#     def SelectAndActivateButton(self, lButton):
#         'method SelectAndActivateButton'
#         #return 
#
#     def ActivateButton(self):
#         'method ActivateButton'
#         #return 
#
#     def SelectRightButton(self):
#         'method SelectRightButton'
#         #return 
#
#     def SelectLeftButton(self):
#         'method SelectLeftButton'
#         #return 
#
#     def SelectLowerButton(self):
#         'method SelectLowerButton'
#         #return 
#
#     def SelectUpperButton(self):
#         'method SelectUpperButton'
#         #return 
#
#     def ActivateAtPosition(self, xPos, yPos):
#         'method ActivateAtPosition'
#         #return 
#
#     def SelectAtPosition(self, xPos, yPos):
#         'method SelectAtPosition'
#         #return 
#
#     @property
#     def ButtonAtPosition(self, xPos, yPos):
#         'ButtonAtPosition'
#         #return plButton
#
#     @property
#     def NumberOfChapters(self, lTitle):
#         'NumberOfChapters'
#         #return pVal
#
#     @property
#     def TotalTitleTime(self):
#         'TotalTitleTime'
#         #return pVal
#
#     @property
#     def TitlesAvailable(self):
#         'TitlesAvailable'
#         #return pVal
#
#     @property
#     def VolumesAvailable(self):
#         'VolumesAvailable'
#         #return pVal
#
#     @property
#     def CurrentVolume(self):
#         'CurrentVolume'
#         #return pVal
#
#     @property
#     def CurrentDiscSide(self):
#         'CurrentDiscSide'
#         #return pVal
#
#     @property
#     def CurrentDomain(self):
#         'CurrentDomain'
#         #return pVal
#
#     @property
#     def CurrentChapter(self):
#         'CurrentChapter'
#         #return pVal
#
#     @property
#     def CurrentTitle(self):
#         'CurrentTitle'
#         #return pVal
#
#     @property
#     def CurrentTime(self):
#         'CurrentTime'
#         #return pVal
#
#     def DVDTimeCode2bstr(self, timeCode):
#         'method DVDTimeCode2bstr'
#         #return pTimeStr
#
#     def _get(self):
#         'DVDDirectory'
#         #return pVal
#     def _set(self, pVal):
#         'DVDDirectory'
#     DVDDirectory = property(_get, _set, doc = _set.__doc__)
#
#     def IsSubpictureStreamEnabled(self, lStream):
#         'method IsSubpictureStreamEnabled'
#         #return fEnabled
#
#     def IsAudioStreamEnabled(self, lStream):
#         'method IsAudioStreamEnabled'
#         #return fEnabled
#
#     def _get(self):
#         'CurrentSubpictureStream'
#         #return pVal
#     def _set(self, pVal):
#         'CurrentSubpictureStream'
#     CurrentSubpictureStream = property(_get, _set, doc = _set.__doc__)
#
#     @property
#     def SubpictureLanguage(self, lStream):
#         'SubpictureLanguage'
#         #return strLanguage
#
#     def _get(self):
#         'CurrentAudioStream'
#         #return pVal
#     def _set(self, pVal):
#         'CurrentAudioStream'
#     CurrentAudioStream = property(_get, _set, doc = _set.__doc__)
#
#     @property
#     def AudioStreamsAvailable(self):
#         'AudioStreamsAvailable'
#         #return pVal
#
#     @property
#     def AnglesAvailable(self):
#         'AnglesAvailable'
#         #return pVal
#
#     def _get(self):
#         'CurrentAngle'
#         #return pVal
#     def _set(self, pVal):
#         'CurrentAngle'
#     CurrentAngle = property(_get, _set, doc = _set.__doc__)
#
#     @property
#     def SubpictureStreamsAvailable(self):
#         'SubpictureStreamsAvailable'
#         #return pVal
#
#     def _get(self):
#         'SubpictureOn'
#         #return pVal
#     def _set(self, pVal):
#         'SubpictureOn'
#     SubpictureOn = property(_get, _set, doc = _set.__doc__)
#
#     @property
#     def DVDUniqueID(self):
#         'DVDUniqueID'
#         #return pVal
#
#     def AcceptParentalLevelChange(self, fAccept, strUserName, strPassword):
#         'method AcceptParentalLevelChange'
#         #return 
#
#     def NotifyParentalLevelChange(self, newVal):
#         'method NotifyParentalLevelChange'
#         #return 
#
#     def SelectParentalCountry(self, lCountry, strUserName, strPassword):
#         'method SelectParentalCountry'
#         #return 
#
#     def SelectParentalLevel(self, lParentalLevel, strUserName, strPassword):
#         'method SelectParentalLevel'
#         #return 
#
#     @property
#     def TitleParentalLevels(self, lTitle):
#         'TitleParentalLevels'
#         #return plParentalLevels
#
#     @property
#     def PlayerParentalCountry(self):
#         'PlayerParentalCountry'
#         #return plCountryCode
#
#     @property
#     def PlayerParentalLevel(self):
#         'PlayerParentalLevel'
#         #return plParentalLevel
#
#     def Eject(self):
#         'method Eject'
#         #return 
#
#     def UOPValid(self, lUOP):
#         'method UOPValid'
#         #return pfValid
#
#     @property
#     def SPRM(self, lIndex):
#         'SPRM'
#         #return psSPRM
#
#     def _get(self, lIndex):
#         'GPRM'
#         #return psSPRM
#     def _set(self, lIndex, psSPRM):
#         'GPRM'
#     GPRM = property(_get, _set, doc = _set.__doc__)
#
#     @property
#     def DVDTextStringType(self, lLangIndex, lStringIndex):
#         'DVDTextStringType'
#         #return pType
#
#     @property
#     def DVDTextString(self, lLangIndex, lStringIndex):
#         'DVDTextString'
#         #return pstrText
#
#     @property
#     def DVDTextNumberOfStrings(self, lLangIndex):
#         'DVDTextNumberOfStrings'
#         #return plNumOfStrings
#
#     @property
#     def DVDTextNumberOfLanguages(self):
#         'DVDTextNumberOfLanguages'
#         #return plNumOfLangs
#
#     @property
#     def DVDTextLanguageLCID(self, lLangIndex):
#         'DVDTextLanguageLCID'
#         #return lcid
#
#     def RegionChange(self):
#         'method RegionChange'
#         #return 
#
#     @property
#     def DVDAdm(self):
#         'DVDAdm'
#         #return pVal
#
#     def DeleteBookmark(self):
#         'method DeleteBookmark'
#         #return 
#
#     def RestoreBookmark(self):
#         'method RestoreBookmark'
#         #return 
#
#     def SaveBookmark(self):
#         'method SaveBookmark'
#         #return 
#
#     def SelectDefaultAudioLanguage(self, lang, ext):
#         'method SelectDefaultAudioLanguage'
#         #return 
#
#     def SelectDefaultSubpictureLanguage(self, lang, ext):
#         'method SelectDefaultSubpictureLanguage'
#         #return 
#
#     @property
#     def PreferredSubpictureStream(self):
#         'PreferredSubpictureStream'
#         #return pVal
#
#     def _get(self):
#         'DefaultMenuLanguage'
#         #return lang
#     def _set(self, lang):
#         'DefaultMenuLanguage'
#     DefaultMenuLanguage = property(_get, _set, doc = _set.__doc__)
#
#     @property
#     def DefaultSubpictureLanguage(self):
#         'DefaultSubpictureLanguage'
#         #return lang
#
#     @property
#     def DefaultAudioLanguage(self):
#         'DefaultAudioLanguage'
#         #return lang
#
#     @property
#     def DefaultSubpictureLanguageExt(self):
#         'DefaultSubpictureLanguageExt'
#         #return ext
#
#     @property
#     def DefaultAudioLanguageExt(self):
#         'DefaultAudioLanguageExt'
#         #return ext
#
#     @property
#     def LanguageFromLCID(self, lcid):
#         'LanguageFromLCID'
#         #return lang
#
#     def _get(self):
#         'KaraokeAudioPresentationMode'
#         #return pVal
#     def _set(self, pVal):
#         'KaraokeAudioPresentationMode'
#     KaraokeAudioPresentationMode = property(_get, _set, doc = _set.__doc__)
#
#     @property
#     def KaraokeChannelContent(self, lStream, lChan):
#         'KaraokeChannelContent'
#         #return lContent
#
#     @property
#     def KaraokeChannelAssignment(self, lStream):
#         'KaraokeChannelAssignment'
#         #return lChannelAssignment
#
#     def RestorePreferredSettings(self):
#         'method RestorePreferredSettings'
#         #return 
#
#     @property
#     def ButtonRect(self, lButton):
#         'ButtonRect'
#         #return pRect
#
#     def _get(self):
#         'DVDScreenInMouseCoordinates'
#         #return ppRect
#     def _set(self, ppRect):
#         'DVDScreenInMouseCoordinates'
#     DVDScreenInMouseCoordinates = property(_get, _set, doc = _set.__doc__)
#

IMSVidStreamBufferSource._methods_ = [
    COMMETHOD(
        [dispid(178), helpstring('Start'), 'propget'],
        HRESULT,
        'Start',
        (['out', 'retval'], POINTER(c_int), 'lStart')
    ),
    COMMETHOD(
        [dispid(180), helpstring('get Recording Attribute interface'), 'propget'],
        HRESULT,
        'RecordingAttribute',
        (['out', 'retval'], POINTER(POINTER(IUnknown)), 'pRecordingAttribute')
    ),
    COMMETHOD(
        [dispid(182), helpstring('Current Ratings for SBE playback')],
        HRESULT,
        'CurrentRatings',
        (['out'], POINTER(EnTvRat_System), 'pEnSystem'),
        (['out'], POINTER(EnTvRat_GenericLevel), 'pEnRating'),
        (['out'], POINTER(c_int), 'pBfEnAttr')
    ),
    COMMETHOD(
        [dispid(183), helpstring('Maximum Ratings Level for SBE playback')],
        HRESULT,
        'MaxRatingsLevel',
        (['in'], EnTvRat_System, 'enSystem'),
        (['in'], EnTvRat_GenericLevel, 'enRating'),
        (['in'], c_int, 'lbfEnAttr')
    ),
    COMMETHOD(
        [dispid(187), helpstring('Block unrated content'), 'propput'],
        HRESULT,
        'BlockUnrated',
        (['in'], VARIANT_BOOL, 'rhs')
    ),
    COMMETHOD(
        [dispid(188), helpstring('Maximum Ratings Level for SBE playback'), 'propput'],
        HRESULT,
        'UnratedDelay',
        (['in'], c_int, 'rhs')
    ),
    COMMETHOD(
        [dispid(190), helpstring('Stream Buffer Source Interface'), 'propget'],
        HRESULT,
        'SBESource',
        (['out', 'retval'], POINTER(POINTER(IUnknown)), 'sbeFilter')
    ),
]

################################################################
# code template for IMSVidStreamBufferSource implementation
# class IMSVidStreamBufferSource_Impl(object):
#     @property
#     def Start(self):
#         'Start'
#         #return lStart
#
#     @property
#     def RecordingAttribute(self):
#         'get Recording Attribute interface'
#         #return pRecordingAttribute
#
#     def CurrentRatings(self):
#         'Current Ratings for SBE playback'
#         #return pEnSystem, pEnRating, pBfEnAttr
#
#     def MaxRatingsLevel(self, enSystem, enRating, lbfEnAttr):
#         'Maximum Ratings Level for SBE playback'
#         #return 
#
#     def _set(self, rhs):
#         'Block unrated content'
#     BlockUnrated = property(fset = _set, doc = _set.__doc__)
#
#     def _set(self, rhs):
#         'Maximum Ratings Level for SBE playback'
#     UnratedDelay = property(fset = _set, doc = _set.__doc__)
#
#     @property
#     def SBESource(self):
#         'Stream Buffer Source Interface'
#         #return sbeFilter
#


class tagCAFILETIME(Structure):
    pass


tagCAFILETIME._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(_FILETIME)),
]

assert sizeof(tagCAFILETIME) == 16, sizeof(tagCAFILETIME)
assert alignment(tagCAFILETIME) == 8, alignment(tagCAFILETIME)

IMSVidStreamBufferSource2._methods_ = [
    COMMETHOD(
        [dispid(201), helpstring('RateEx'), 'propput'],
        HRESULT,
        'RateEx',
        (['in'], c_double, 'dwRate'),
        (['in'], c_ulong, 'rhs')
    ),
    COMMETHOD(
        [dispid(206), helpstring('Returns counter interface for the audio path'), 'propget'],
        HRESULT,
        'AudioCounter',
        (['out', 'retval'], POINTER(POINTER(IUnknown)), 'ppunk')
    ),
    COMMETHOD(
        [dispid(207), helpstring('Returns counter interface for the video path'), 'propget'],
        HRESULT,
        'VideoCounter',
        (['out', 'retval'], POINTER(POINTER(IUnknown)), 'ppunk')
    ),
    COMMETHOD(
        [dispid(208), helpstring('Returns counter interface for the closed captioning data path'), 'propget'],
        HRESULT,
        'CCCounter',
        (['out', 'retval'], POINTER(POINTER(IUnknown)), 'ppunk')
    ),
    COMMETHOD(
        [dispid(209), helpstring('Returns counter interface for the wst (teletext) data path'), 'propget'],
        HRESULT,
        'WSTCounter',
        (['out', 'retval'], POINTER(POINTER(IUnknown)), 'ppunk')
    ),
]

################################################################
# code template for IMSVidStreamBufferSource2 implementation
# class IMSVidStreamBufferSource2_Impl(object):
#     def _set(self, dwRate, rhs):
#         'RateEx'
#     RateEx = property(fset = _set, doc = _set.__doc__)
#
#     @property
#     def AudioCounter(self):
#         'Returns counter interface for the audio path'
#         #return ppunk
#
#     @property
#     def VideoCounter(self):
#         'Returns counter interface for the video path'
#         #return ppunk
#
#     @property
#     def CCCounter(self):
#         'Returns counter interface for the closed captioning data path'
#         #return ppunk
#
#     @property
#     def WSTCounter(self):
#         'Returns counter interface for the wst (teletext) data path'
#         #return ppunk
#

IFilterGraph._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'AddFilter',
        (['in'], POINTER(IBaseFilter), 'pFilter'),
        (['in'], WSTRING, 'pName')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'RemoveFilter',
        (['in'], POINTER(IBaseFilter), 'pFilter')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'EnumFilters',
        (['out'], POINTER(POINTER(IEnumFilters)), 'ppenum')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'FindFilterByName',
        (['in'], WSTRING, 'pName'),
        (['out'], POINTER(POINTER(IBaseFilter)), 'ppFilter')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'ConnectDirect',
        (['in'], POINTER(IPin), 'ppinOut'),
        (['in'], POINTER(IPin), 'ppinIn'),
        (['in'], POINTER(_AMMediaType), 'pmt')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Reconnect',
        (['in'], POINTER(IPin), 'pPin')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Disconnect',
        (['in'], POINTER(IPin), 'pPin')
    ),
    COMMETHOD([], HRESULT, 'SetDefaultSyncSource'),
]

################################################################
# code template for IFilterGraph implementation
# class IFilterGraph_Impl(object):
#     def AddFilter(self, pFilter, pName):
#         '-no docstring-'
#         #return 
#
#     def RemoveFilter(self, pFilter):
#         '-no docstring-'
#         #return 
#
#     def EnumFilters(self):
#         '-no docstring-'
#         #return ppenum
#
#     def FindFilterByName(self, pName):
#         '-no docstring-'
#         #return ppFilter
#
#     def ConnectDirect(self, ppinOut, ppinIn, pmt):
#         '-no docstring-'
#         #return 
#
#     def Reconnect(self, pPin):
#         '-no docstring-'
#         #return 
#
#     def Disconnect(self, pPin):
#         '-no docstring-'
#         #return 
#
#     def SetDefaultSyncSource(self):
#         '-no docstring-'
#         #return 
#

IVMRMixerBitmap._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'SetAlphaBitmap',
        (['in'], POINTER(_VMRALPHABITMAP), 'pBmpParms')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'UpdateAlphaBitmapParameters',
        (['in'], POINTER(_VMRALPHABITMAP), 'pBmpParms')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetAlphaBitmapParameters',
        (['out'], POINTER(_VMRALPHABITMAP), 'pBmpParms')
    ),
]

################################################################
# code template for IVMRMixerBitmap implementation
# class IVMRMixerBitmap_Impl(object):
#     def SetAlphaBitmap(self, pBmpParms):
#         '-no docstring-'
#         #return 
#
#     def UpdateAlphaBitmapParameters(self, pBmpParms):
#         '-no docstring-'
#         #return 
#
#     def GetAlphaBitmapParameters(self):
#         '-no docstring-'
#         #return pBmpParms
#


class tagCACLSID(Structure):
    pass


tagCACLSID._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID)),
]

assert sizeof(tagCACLSID) == 16, sizeof(tagCACLSID)
assert alignment(tagCACLSID) == 8, alignment(tagCACLSID)


class IComponentTypes(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """ComponentType Collection Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{0DC13D4A-0313-11D3-9D8E-00C04F72D980}')
    _idlflags_ = ['hidden', 'dual', 'nonextensible', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_Count(self) -> hints.Incomplete: ...
        Count = hints.normal_property(_get_Count)
        __len__ = hints.to_dunder_len(Count)
        def _get__NewEnum(self) -> hints.Incomplete: ...
        _NewEnum = hints.normal_property(_get__NewEnum)
        __iter__ = hints.to_dunder_iter(_NewEnum)
        def EnumComponentTypes(self) -> 'IEnumComponentTypes': ...
        def _get_Item(self, Index: hints.Incomplete) -> 'IComponentType': ...
        def _set_Item(self, Index: hints.Incomplete, ComponentType: hints.Incomplete) -> hints.Hresult: ...
        Item = hints.named_property('Item', _get_Item, _set_Item)
        __call__ = hints.to_dunder_call(Item)
        __getitem__ = hints.to_dunder_getitem(Item)
        __setitem__ = hints.to_dunder_setitem(Item)
        def Add(self, ComponentType: hints.Incomplete) -> hints.Incomplete: ...
        def Remove(self, Index: hints.Incomplete) -> hints.Hresult: ...
        def Clone(self) -> 'IComponentTypes': ...


ITuningSpace._methods_ = [
    COMMETHOD(
        [dispid(1), helpstring('Unique name of the Tuning Space'), 'propget'],
        HRESULT,
        'UniqueName',
        (['out', 'retval'], POINTER(BSTR), 'Name')
    ),
    COMMETHOD(
        [dispid(1), helpstring('Unique name of the Tuning Space'), 'propput'],
        HRESULT,
        'UniqueName',
        (['in'], BSTR, 'Name')
    ),
    COMMETHOD(
        [dispid(2), helpstring('User-friendly name of the Tuning Space'), 'propget'],
        HRESULT,
        'FriendlyName',
        (['out', 'retval'], POINTER(BSTR), 'Name')
    ),
    COMMETHOD(
        [dispid(2), helpstring('User-friendly name of the Tuning Space'), 'propput'],
        HRESULT,
        'FriendlyName',
        (['in'], BSTR, 'Name')
    ),
    COMMETHOD(
        [dispid(3), helpstring('Returns the clsid of the tuning space implementation.  provides script access to IPersist:GetClassID'), 'propget'],
        HRESULT,
        'Clsid',
        (['out', 'retval'], POINTER(BSTR), 'SpaceCLSID')
    ),
    COMMETHOD(
        [dispid(4), helpstring('Network Type (Network Proivder CLSID)'), 'propget'],
        HRESULT,
        'NetworkType',
        (['out', 'retval'], POINTER(BSTR), 'NetworkTypeGuid')
    ),
    COMMETHOD(
        [dispid(4), helpstring('Network Type (Network Proivder CLSID)'), 'propput'],
        HRESULT,
        'NetworkType',
        (['in'], BSTR, 'NetworkTypeGuid')
    ),
    COMMETHOD(
        [dispid(5), helpstring('Network Type (Network Proivder CLSID)'), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_NetworkType',
        (
            ['out', 'retval'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'NetworkTypeGuid',
        )
    ),
    COMMETHOD(
        [dispid(5), helpstring('Network Type (Network Proivder CLSID)'), 'restricted', 'hidden', 'propput'],
        HRESULT,
        '_NetworkType',
        (
            ['in'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'NetworkTypeGuid',
        )
    ),
    COMMETHOD(
        [dispid(6), helpstring('Create a Tune Request object')],
        HRESULT,
        'CreateTuneRequest',
        (['out', 'retval'], POINTER(POINTER(ITuneRequest)), 'TuneRequest')
    ),
    COMMETHOD(
        [dispid(7), 'restricted', 'hidden'],
        HRESULT,
        'EnumCategoryGUIDs',
        (['out', 'retval'], POINTER(POINTER(IEnumGUID)), 'ppenum')
    ),
    COMMETHOD(
        [dispid(8), 'restricted', 'hidden'],
        HRESULT,
        'EnumDeviceMonikers',
        (['out', 'retval'], POINTER(POINTER(IEnumMoniker)), 'ppenum')
    ),
    COMMETHOD(
        [dispid(9), 'propget'],
        HRESULT,
        'DefaultPreferredComponentTypes',
        (['out', 'retval'], POINTER(POINTER(IComponentTypes)), 'ComponentTypes')
    ),
    COMMETHOD(
        [dispid(9), 'propput'],
        HRESULT,
        'DefaultPreferredComponentTypes',
        (['in'], POINTER(IComponentTypes), 'ComponentTypes')
    ),
    COMMETHOD(
        [dispid(10), 'propget'],
        HRESULT,
        'FrequencyMapping',
        (['out', 'retval'], POINTER(BSTR), 'pMapping')
    ),
    COMMETHOD(
        [dispid(10), 'propput'],
        HRESULT,
        'FrequencyMapping',
        ([], BSTR, 'pMapping')
    ),
    COMMETHOD(
        [dispid(11), 'propget'],
        HRESULT,
        'DefaultLocator',
        (['out', 'retval'], POINTER(POINTER(ILocator)), 'LocatorVal')
    ),
    COMMETHOD(
        [dispid(11), 'propput'],
        HRESULT,
        'DefaultLocator',
        (['in'], POINTER(ILocator), 'LocatorVal')
    ),
    COMMETHOD(
        [dispid(1610743826)],
        HRESULT,
        'Clone',
        (['out', 'retval'], POINTER(POINTER(ITuningSpace)), 'NewTS')
    ),
]

################################################################
# code template for ITuningSpace implementation
# class ITuningSpace_Impl(object):
#     def _get(self):
#         'Unique name of the Tuning Space'
#         #return Name
#     def _set(self, Name):
#         'Unique name of the Tuning Space'
#     UniqueName = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'User-friendly name of the Tuning Space'
#         #return Name
#     def _set(self, Name):
#         'User-friendly name of the Tuning Space'
#     FriendlyName = property(_get, _set, doc = _set.__doc__)
#
#     @property
#     def Clsid(self):
#         'Returns the clsid of the tuning space implementation.  provides script access to IPersist:GetClassID'
#         #return SpaceCLSID
#
#     def _get(self):
#         'Network Type (Network Proivder CLSID)'
#         #return NetworkTypeGuid
#     def _set(self, NetworkTypeGuid):
#         'Network Type (Network Proivder CLSID)'
#     NetworkType = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Network Type (Network Proivder CLSID)'
#         #return NetworkTypeGuid
#     def _set(self, NetworkTypeGuid):
#         'Network Type (Network Proivder CLSID)'
#     _NetworkType = property(_get, _set, doc = _set.__doc__)
#
#     def CreateTuneRequest(self):
#         'Create a Tune Request object'
#         #return TuneRequest
#
#     def EnumCategoryGUIDs(self):
#         '-no docstring-'
#         #return ppenum
#
#     def EnumDeviceMonikers(self):
#         '-no docstring-'
#         #return ppenum
#
#     def _get(self):
#         '-no docstring-'
#         #return ComponentTypes
#     def _set(self, ComponentTypes):
#         '-no docstring-'
#     DefaultPreferredComponentTypes = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         '-no docstring-'
#         #return pMapping
#     def _set(self, pMapping):
#         '-no docstring-'
#     FrequencyMapping = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         '-no docstring-'
#         #return LocatorVal
#     def _set(self, LocatorVal):
#         '-no docstring-'
#     DefaultLocator = property(_get, _set, doc = _set.__doc__)
#
#     def Clone(self):
#         '-no docstring-'
#         #return NewTS
#


class _RemotableHandle(Structure):
    pass


wireHDC = POINTER(_RemotableHandle)

_VMRALPHABITMAP._fields_ = [
    ('dwFlags', c_ulong),
    ('hdc', wireHDC),
    ('pDDS', POINTER(c_ulong)),
    ('rSrc', tagRECT),
    ('rDest', _NORMALIZEDRECT),
    ('fAlpha', c_float),
    ('clrSrcKey', c_ulong),
]

assert sizeof(_VMRALPHABITMAP) == 64, sizeof(_VMRALPHABITMAP)
assert alignment(_VMRALPHABITMAP) == 8, alignment(_VMRALPHABITMAP)

_FLAGGED_WORD_BLOB._pack_ = 4

_FLAGGED_WORD_BLOB._fields_ = [
    ('fFlags', c_ulong),
    ('clSize', c_ulong),
    ('asData', POINTER(c_ushort)),
]

assert sizeof(_FLAGGED_WORD_BLOB) == 16, sizeof(_FLAGGED_WORD_BLOB)
assert alignment(_FLAGGED_WORD_BLOB) == 4, alignment(_FLAGGED_WORD_BLOB)


class tagCADBL(Structure):
    pass


tagCADBL._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(c_double)),
]

assert sizeof(tagCADBL) == 16, sizeof(tagCADBL)
assert alignment(tagCADBL) == 8, alignment(tagCADBL)


class tagCABOOL(Structure):
    pass


tagCABOOL._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(VARIANT_BOOL)),
]

assert sizeof(tagCABOOL) == 16, sizeof(tagCABOOL)
assert alignment(tagCABOOL) == 8, alignment(tagCABOOL)


class IGraphBuilder(IFilterGraph):
    _case_insensitive_ = True
    _iid_ = GUID('{56A868A9-0AD4-11CE-B03A-0020AF0BA770}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def Connect(self, ppinOut: hints.Incomplete, ppinIn: hints.Incomplete) -> hints.Hresult: ...
        def Render(self, ppinOut: hints.Incomplete) -> hints.Hresult: ...
        def RenderFile(self, lpcwstrFile: hints.Incomplete, lpcwstrPlayList: hints.Incomplete) -> hints.Hresult: ...
        def AddSourceFilter(self, lpcwstrFileName: hints.Incomplete, lpcwstrFilterName: hints.Incomplete) -> 'IBaseFilter': ...
        def SetLogFile(self, hFile: hints.Incomplete) -> hints.Hresult: ...
        def Abort(self) -> hints.Hresult: ...
        def ShouldOperationContinue(self) -> hints.Hresult: ...


IMSVidGraphSegmentContainer._methods_ = [
    COMMETHOD(
        ['propget', helpstring('Graph')],
        HRESULT,
        'Graph',
        (['out'], POINTER(POINTER(IGraphBuilder)), 'ppGraph')
    ),
    COMMETHOD(
        ['propget', helpstring('Input Segment')],
        HRESULT,
        'Input',
        (['out'], POINTER(POINTER(IMSVidGraphSegment)), 'ppInput')
    ),
    COMMETHOD(
        ['propget', helpstring('Output Segment')],
        HRESULT,
        'Outputs',
        (['out'], POINTER(POINTER(IEnumMSVidGraphSegment)), 'ppOutputs')
    ),
    COMMETHOD(
        ['propget', helpstring('Video Renderer')],
        HRESULT,
        'VideoRenderer',
        (['out'], POINTER(POINTER(IMSVidGraphSegment)), 'ppVR')
    ),
    COMMETHOD(
        ['propget', helpstring('Audio Renderer')],
        HRESULT,
        'AudioRenderer',
        (['out'], POINTER(POINTER(IMSVidGraphSegment)), 'ppAR')
    ),
    COMMETHOD(
        ['propget', helpstring('Features')],
        HRESULT,
        'Features',
        (['out'], POINTER(POINTER(IEnumMSVidGraphSegment)), 'ppFeatures')
    ),
    COMMETHOD(
        ['propget', helpstring('Composites')],
        HRESULT,
        'Composites',
        (['out'], POINTER(POINTER(IEnumMSVidGraphSegment)), 'ppComposites')
    ),
    COMMETHOD(
        ['propget', helpstring('Container')],
        HRESULT,
        'ParentContainer',
        (['out'], POINTER(POINTER(IUnknown)), 'ppContainer')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Decompose',
        ([], POINTER(IMSVidGraphSegment), 'pSegment')
    ),
    COMMETHOD([], HRESULT, 'IsWindowless'),
    COMMETHOD([], HRESULT, 'GetFocus'),
]

################################################################
# code template for IMSVidGraphSegmentContainer implementation
# class IMSVidGraphSegmentContainer_Impl(object):
#     @property
#     def Graph(self):
#         'Graph'
#         #return ppGraph
#
#     @property
#     def Input(self):
#         'Input Segment'
#         #return ppInput
#
#     @property
#     def Outputs(self):
#         'Output Segment'
#         #return ppOutputs
#
#     @property
#     def VideoRenderer(self):
#         'Video Renderer'
#         #return ppVR
#
#     @property
#     def AudioRenderer(self):
#         'Audio Renderer'
#         #return ppAR
#
#     @property
#     def Features(self):
#         'Features'
#         #return ppFeatures
#
#     @property
#     def Composites(self):
#         'Composites'
#         #return ppComposites
#
#     @property
#     def ParentContainer(self):
#         'Container'
#         #return ppContainer
#
#     def Decompose(self, pSegment):
#         '-no docstring-'
#         #return 
#
#     def IsWindowless(self):
#         '-no docstring-'
#         #return 
#
#     def GetFocus(self):
#         '-no docstring-'
#         #return 
#


class tagCAC(Structure):
    pass


tagCAC._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(c_ubyte)),
]

assert sizeof(tagCAC) == 16, sizeof(tagCAC)
assert alignment(tagCAC) == 8, alignment(tagCAC)


class tagCASCODE(Structure):
    pass


tagCASCODE._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(SCODE)),
]

assert sizeof(tagCASCODE) == 16, sizeof(tagCASCODE)
assert alignment(tagCASCODE) == 8, alignment(tagCASCODE)

IGraphBuilder._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'Connect',
        (['in'], POINTER(IPin), 'ppinOut'),
        (['in'], POINTER(IPin), 'ppinIn')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Render',
        (['in'], POINTER(IPin), 'ppinOut')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'RenderFile',
        (['in'], WSTRING, 'lpcwstrFile'),
        (['in'], WSTRING, 'lpcwstrPlayList')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'AddSourceFilter',
        (['in'], WSTRING, 'lpcwstrFileName'),
        (['in'], WSTRING, 'lpcwstrFilterName'),
        (['out'], POINTER(POINTER(IBaseFilter)), 'ppFilter')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'SetLogFile',
        (['in'], ULONG_PTR, 'hFile')
    ),
    COMMETHOD([], HRESULT, 'Abort'),
    COMMETHOD([], HRESULT, 'ShouldOperationContinue'),
]

################################################################
# code template for IGraphBuilder implementation
# class IGraphBuilder_Impl(object):
#     def Connect(self, ppinOut, ppinIn):
#         '-no docstring-'
#         #return 
#
#     def Render(self, ppinOut):
#         '-no docstring-'
#         #return 
#
#     def RenderFile(self, lpcwstrFile, lpcwstrPlayList):
#         '-no docstring-'
#         #return 
#
#     def AddSourceFilter(self, lpcwstrFileName, lpcwstrFilterName):
#         '-no docstring-'
#         #return ppFilter
#
#     def SetLogFile(self, hFile):
#         '-no docstring-'
#         #return 
#
#     def Abort(self):
#         '-no docstring-'
#         #return 
#
#     def ShouldOperationContinue(self):
#         '-no docstring-'
#         #return 
#


class __MIDL_IOleAutomationTypes_0004(Union):
    pass


__MIDL_IOleAutomationTypes_0004._fields_ = [
    ('llVal', c_longlong),
    ('lVal', c_int),
    ('bVal', c_ubyte),
    ('iVal', c_short),
    ('fltVal', c_float),
    ('dblVal', c_double),
    ('boolVal', VARIANT_BOOL),
    ('Scode', SCODE),
    ('cyVal', c_longlong),
    ('date', c_double),
    ('bstrVal', POINTER(_FLAGGED_WORD_BLOB)),
    ('punkVal', POINTER(IUnknown)),
    ('pdispVal', POINTER(IDispatch)),
    ('parray', POINTER(POINTER(_wireSAFEARRAY))),
    ('brecVal', POINTER(_wireBRECORD)),
    ('pbVal', POINTER(c_ubyte)),
    ('piVal', POINTER(c_short)),
    ('plVal', POINTER(c_int)),
    ('pllVal', POINTER(c_longlong)),
    ('pfltVal', POINTER(c_float)),
    ('pdblVal', POINTER(c_double)),
    ('pboolVal', POINTER(VARIANT_BOOL)),
    ('pscode', POINTER(SCODE)),
    ('pcyVal', POINTER(c_longlong)),
    ('pdate', POINTER(c_double)),
    ('pbstrVal', POINTER(POINTER(_FLAGGED_WORD_BLOB))),
    ('ppunkVal', POINTER(POINTER(IUnknown))),
    ('ppdispVal', POINTER(POINTER(IDispatch))),
    ('pparray', POINTER(POINTER(POINTER(_wireSAFEARRAY)))),
    ('pvarVal', POINTER(POINTER(_wireVARIANT))),
    ('cVal', c_ubyte),
    ('uiVal', c_ushort),
    ('ulVal', c_ulong),
    ('ullVal', c_ulonglong),
    ('intVal', c_int),
    ('uintVal', c_uint),
    ('decVal', DECIMAL),
    ('pdecVal', POINTER(DECIMAL)),
    ('pcVal', POINTER(c_ubyte)),
    ('puiVal', POINTER(c_ushort)),
    ('pulVal', POINTER(c_ulong)),
    ('pullVal', POINTER(c_ulonglong)),
    ('pintVal', POINTER(c_int)),
    ('puintVal', POINTER(c_uint)),
]

assert sizeof(__MIDL_IOleAutomationTypes_0004) == 16, sizeof(__MIDL_IOleAutomationTypes_0004)
assert alignment(__MIDL_IOleAutomationTypes_0004) == 8, alignment(__MIDL_IOleAutomationTypes_0004)

_wireVARIANT._fields_ = [
    ('clSize', c_ulong),
    ('rpcReserved', c_ulong),
    ('vt', c_ushort),
    ('wReserved1', c_ushort),
    ('wReserved2', c_ushort),
    ('wReserved3', c_ushort),
    ('DUMMYUNIONNAME', __MIDL_IOleAutomationTypes_0004),
]

assert sizeof(_wireVARIANT) == 32, sizeof(_wireVARIANT)
assert alignment(_wireVARIANT) == 8, alignment(_wireVARIANT)


class tagCAUB(Structure):
    pass


tagCAUB._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(c_ubyte)),
]

assert sizeof(tagCAUB) == 16, sizeof(tagCAUB)
assert alignment(tagCAUB) == 8, alignment(tagCAUB)


class tagCLIPDATA(Structure):
    pass


tagCLIPDATA._fields_ = [
    ('cbSize', c_ulong),
    ('ulClipFmt', c_int),
    ('pClipData', POINTER(c_ubyte)),
]

assert sizeof(tagCLIPDATA) == 16, sizeof(tagCLIPDATA)
assert alignment(tagCLIPDATA) == 8, alignment(tagCLIPDATA)


class tagCAI(Structure):
    pass


tagCAI._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(c_short)),
]

assert sizeof(tagCAI) == 16, sizeof(tagCAI)
assert alignment(tagCAI) == 8, alignment(tagCAI)


class tagCAUL(Structure):
    pass


tagCAUL._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(c_ulong)),
]

assert sizeof(tagCAUL) == 16, sizeof(tagCAUL)
assert alignment(tagCAUL) == 8, alignment(tagCAUL)


class _MFVIDEOFORMAT(Structure):
    pass


class _MFVideoInfo(Structure):
    pass


class _MFRatio(Structure):
    pass


_MFRatio._fields_ = [
    ('Numerator', c_ulong),
    ('Denominator', c_ulong),
]

assert sizeof(_MFRatio) == 8, sizeof(_MFRatio)
assert alignment(_MFRatio) == 4, alignment(_MFRatio)


class _MFVideoArea(Structure):
    pass


_MFVideoArea._fields_ = [
    ('OffsetX', _MFOffset),
    ('OffsetY', _MFOffset),
    ('Area', tagSIZE),
]

assert sizeof(_MFVideoArea) == 16, sizeof(_MFVideoArea)
assert alignment(_MFVideoArea) == 4, alignment(_MFVideoArea)

_MFVideoInfo._fields_ = [
    ('dwWidth', c_ulong),
    ('dwHeight', c_ulong),
    ('PixelAspectRatio', _MFRatio),
    ('SourceChromaSubsampling', _MFVideoChromaSubsampling),
    ('InterlaceMode', _MFVideoInterlaceMode),
    ('TransferFunction', _MFVideoTransferFunction),
    ('ColorPrimaries', _MFVideoPrimaries),
    ('TransferMatrix', _MFVideoTransferMatrix),
    ('SourceLighting', _MFVideoLighting),
    ('FramesPerSecond', _MFRatio),
    ('NominalRange', _MFNominalRange),
    ('GeometricAperture', _MFVideoArea),
    ('MinimumDisplayAperture', _MFVideoArea),
    ('PanScanAperture', _MFVideoArea),
    ('VideoFlags', c_ulonglong),
]

assert sizeof(_MFVideoInfo) == 112, sizeof(_MFVideoInfo)
assert alignment(_MFVideoInfo) == 8, alignment(_MFVideoInfo)

_MFVIDEOFORMAT._fields_ = [
    ('dwSize', c_ulong),
    ('videoInfo', _MFVideoInfo),
    ('guidFormat', comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
    ('compressedInfo', _MFVideoCompressedInfo),
    ('surfaceInfo', _MFVideoSurfaceInfo),
]

assert sizeof(_MFVIDEOFORMAT) == 176, sizeof(_MFVIDEOFORMAT)
assert alignment(_MFVIDEOFORMAT) == 8, alignment(_MFVIDEOFORMAT)

tagBSTRBLOB._fields_ = [
    ('cbSize', c_ulong),
    ('pData', POINTER(c_ubyte)),
]

assert sizeof(tagBSTRBLOB) == 16, sizeof(tagBSTRBLOB)
assert alignment(tagBSTRBLOB) == 8, alignment(tagBSTRBLOB)


class IReferenceClock(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    _case_insensitive_ = True
    _iid_ = GUID('{56A86897-0AD4-11CE-B03A-0020AF0BA770}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def GetTime(self) -> hints.Incomplete: ...
        def AdviseTime(self, baseTime: hints.Incomplete, streamTime: hints.Incomplete, hEvent: hints.Incomplete) -> hints.Incomplete: ...
        def AdvisePeriodic(self, startTime: hints.Incomplete, periodTime: hints.Incomplete, hSemaphore: hints.Incomplete) -> hints.Incomplete: ...
        def Unadvise(self, dwAdviseCookie: hints.Incomplete) -> hints.Hresult: ...


IMediaFilter._methods_ = [
    COMMETHOD([], HRESULT, 'Stop'),
    COMMETHOD([], HRESULT, 'Pause'),
    COMMETHOD(
        [],
        HRESULT,
        'Run',
        ([], c_longlong, 'tStart')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetState',
        (['in'], c_ulong, 'dwMilliSecsTimeout'),
        (['out'], POINTER(_FilterState), 'State')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'SetSyncSource',
        (['in'], POINTER(IReferenceClock), 'pClock')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetSyncSource',
        (['out'], POINTER(POINTER(IReferenceClock)), 'pClock')
    ),
]

################################################################
# code template for IMediaFilter implementation
# class IMediaFilter_Impl(object):
#     def Stop(self):
#         '-no docstring-'
#         #return 
#
#     def Pause(self):
#         '-no docstring-'
#         #return 
#
#     def Run(self, tStart):
#         '-no docstring-'
#         #return 
#
#     def GetState(self, dwMilliSecsTimeout):
#         '-no docstring-'
#         #return State
#
#     def SetSyncSource(self, pClock):
#         '-no docstring-'
#         #return 
#
#     def GetSyncSource(self):
#         '-no docstring-'
#         #return pClock
#


class tagCAUI(Structure):
    pass


tagCAUI._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(c_ushort)),
]

assert sizeof(tagCAUI) == 16, sizeof(tagCAUI)
assert alignment(tagCAUI) == 8, alignment(tagCAUI)


class tagBLOB(Structure):
    pass


tagBLOB._fields_ = [
    ('cbSize', c_ulong),
    ('pBlobData', POINTER(c_ubyte)),
]

assert sizeof(tagBLOB) == 16, sizeof(tagBLOB)
assert alignment(tagBLOB) == 8, alignment(tagBLOB)


class tagCAH(Structure):
    pass


tagCAH._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(_LARGE_INTEGER)),
]

assert sizeof(tagCAH) == 16, sizeof(tagCAH)
assert alignment(tagCAH) == 8, alignment(tagCAH)


class tagCAUH(Structure):
    pass


tagCAUH._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(_ULARGE_INTEGER)),
]

assert sizeof(tagCAUH) == 16, sizeof(tagCAUH)
assert alignment(tagCAUH) == 8, alignment(tagCAUH)

IMSVidTunerEvent._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'TuneChanged',
        (['in'], POINTER(IMSVidTuner), 'lpd')
    ),
]

################################################################
# code template for IMSVidTunerEvent implementation
# class IMSVidTunerEvent_Impl(object):
#     def TuneChanged(self, lpd):
#         '-no docstring-'
#         #return 
#

IMSVidAnalogTunerEvent._methods_ = [
]

################################################################
# code template for IMSVidAnalogTunerEvent implementation
# class IMSVidAnalogTunerEvent_Impl(object):


class tagCAL(Structure):
    pass


tagCAL._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(c_int)),
]

assert sizeof(tagCAL) == 16, sizeof(tagCAL)
assert alignment(tagCAL) == 8, alignment(tagCAL)

IReferenceClock._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'GetTime',
        (['out'], POINTER(c_longlong), 'pTime')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'AdviseTime',
        (['in'], c_longlong, 'baseTime'),
        (['in'], c_longlong, 'streamTime'),
        (['in'], ULONG_PTR, 'hEvent'),
        (['out'], POINTER(ULONG_PTR), 'pdwAdviseCookie')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'AdvisePeriodic',
        (['in'], c_longlong, 'startTime'),
        (['in'], c_longlong, 'periodTime'),
        (['in'], ULONG_PTR, 'hSemaphore'),
        (['out'], POINTER(ULONG_PTR), 'pdwAdviseCookie')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Unadvise',
        (['in'], ULONG_PTR, 'dwAdviseCookie')
    ),
]

################################################################
# code template for IReferenceClock implementation
# class IReferenceClock_Impl(object):
#     def GetTime(self):
#         '-no docstring-'
#         #return pTime
#
#     def AdviseTime(self, baseTime, streamTime, hEvent):
#         '-no docstring-'
#         #return pdwAdviseCookie
#
#     def AdvisePeriodic(self, startTime, periodTime, hSemaphore):
#         '-no docstring-'
#         #return pdwAdviseCookie
#
#     def Unadvise(self, dwAdviseCookie):
#         '-no docstring-'
#         #return 
#


class tagCAFLT(Structure):
    pass


tagCAFLT._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(c_float)),
]

assert sizeof(tagCAFLT) == 16, sizeof(tagCAFLT)
assert alignment(tagCAFLT) == 8, alignment(tagCAFLT)


class IEnumComponentTypes(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    _case_insensitive_ = True
    _iid_ = GUID('{8A674B4A-1F63-11D3-B64C-00C04F79498E}')
    _idlflags_ = ['hidden', 'restricted']

    def __iter__(self):
        return self

    def __next__(self):
        item, fetched = self.Next(1)
        if fetched:
            return item
        raise StopIteration

    def __getitem__(self, index):
        self.Reset()
        self.Skip(index)
        item, fetched = self.Next(1)
        if fetched:
            return item
        raise IndexError(index)

    if TYPE_CHECKING:  # commembers
        def Next(self, celt: hints.Incomplete) -> hints.Tuple['IComponentType', hints.Incomplete]: ...
        def Skip(self, celt: hints.Incomplete) -> hints.Hresult: ...
        def Reset(self) -> hints.Hresult: ...
        def Clone(self) -> 'IEnumComponentTypes': ...


class IComponentType(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """Component Type Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{6A340DC0-0311-11D3-9D8E-00C04F72D980}')
    _idlflags_ = ['hidden', 'dual', 'nonextensible', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_Category(self) -> hints.Incomplete: ...
        def _set_Category(self, Category: hints.Incomplete) -> hints.Hresult: ...
        Category = hints.normal_property(_get_Category, _set_Category)
        def _get_MediaMajorType(self) -> hints.Incomplete: ...
        def _set_MediaMajorType(self, MediaMajorType: hints.Incomplete) -> hints.Hresult: ...
        MediaMajorType = hints.normal_property(_get_MediaMajorType, _set_MediaMajorType)
        def _get__MediaMajorType(self) -> hints.Incomplete: ...
        def _set__MediaMajorType(self, MediaMajorTypeGuid: hints.Incomplete) -> hints.Hresult: ...
        _MediaMajorType = hints.normal_property(_get__MediaMajorType, _set__MediaMajorType)
        def _get_MediaSubType(self) -> hints.Incomplete: ...
        def _set_MediaSubType(self, MediaSubType: hints.Incomplete) -> hints.Hresult: ...
        MediaSubType = hints.normal_property(_get_MediaSubType, _set_MediaSubType)
        def _get__MediaSubType(self) -> hints.Incomplete: ...
        def _set__MediaSubType(self, MediaSubTypeGuid: hints.Incomplete) -> hints.Hresult: ...
        _MediaSubType = hints.normal_property(_get__MediaSubType, _set__MediaSubType)
        def _get_MediaFormatType(self) -> hints.Incomplete: ...
        def _set_MediaFormatType(self, MediaFormatType: hints.Incomplete) -> hints.Hresult: ...
        MediaFormatType = hints.normal_property(_get_MediaFormatType, _set_MediaFormatType)
        def _get__MediaFormatType(self) -> hints.Incomplete: ...
        def _set__MediaFormatType(self, MediaFormatTypeGuid: hints.Incomplete) -> hints.Hresult: ...
        _MediaFormatType = hints.normal_property(_get__MediaFormatType, _set__MediaFormatType)
        def _get_MediaType(self) -> hints.Incomplete: ...
        def _set_MediaType(self, MediaType: hints.Incomplete) -> hints.Hresult: ...
        MediaType = hints.normal_property(_get_MediaType, _set_MediaType)
        def Clone(self) -> 'IComponentType': ...


IEnumComponentTypes._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'Next',
        (['in'], c_ulong, 'celt'),
        (['out'], POINTER(POINTER(IComponentType)), 'rgelt'),
        (['out'], POINTER(c_ulong), 'pceltFetched')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Skip',
        (['in'], c_ulong, 'celt')
    ),
    COMMETHOD([], HRESULT, 'Reset'),
    COMMETHOD(
        [],
        HRESULT,
        'Clone',
        (['out'], POINTER(POINTER(IEnumComponentTypes)), 'ppenum')
    ),
]

################################################################
# code template for IEnumComponentTypes implementation
# class IEnumComponentTypes_Impl(object):
#     def Next(self, celt):
#         '-no docstring-'
#         #return rgelt, pceltFetched
#
#     def Skip(self, celt):
#         '-no docstring-'
#         #return 
#
#     def Reset(self):
#         '-no docstring-'
#         #return 
#
#     def Clone(self):
#         '-no docstring-'
#         #return ppenum
#


class __MIDL___MIDL_itf_msvidctl_0003_0263_0001(Union):
    pass


class tagCACLIPDATA(Structure):
    pass


tagCACLIPDATA._fields_ = [
    ('cElems', c_ulong),
    ('pElems', POINTER(tagCLIPDATA)),
]

assert sizeof(tagCACLIPDATA) == 16, sizeof(tagCACLIPDATA)
assert alignment(tagCACLIPDATA) == 8, alignment(tagCACLIPDATA)

__MIDL___MIDL_itf_msvidctl_0003_0263_0001._fields_ = [
    ('cVal', c_ubyte),
    ('bVal', c_ubyte),
    ('iVal', c_short),
    ('uiVal', c_ushort),
    ('lVal', c_int),
    ('ulVal', c_ulong),
    ('intVal', c_int),
    ('uintVal', c_uint),
    ('hVal', _LARGE_INTEGER),
    ('uhVal', _ULARGE_INTEGER),
    ('fltVal', c_float),
    ('dblVal', c_double),
    ('boolVal', VARIANT_BOOL),
    ('__OBSOLETE__VARIANT_BOOL', VARIANT_BOOL),
    ('Scode', SCODE),
    ('cyVal', c_longlong),
    ('date', c_double),
    ('filetime', _FILETIME),
    ('puuid', POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID)),
    ('pClipData', POINTER(tagCLIPDATA)),
    ('bstrVal', BSTR),
    ('bstrblobVal', tagBSTRBLOB),
    ('blob', tagBLOB),
    ('pszVal', STRING),
    ('pwszVal', WSTRING),
    ('punkVal', POINTER(IUnknown)),
    ('pdispVal', POINTER(IDispatch)),
    ('pStream', POINTER(IStream)),
    ('pStorage', POINTER(IStorage)),
    ('pVersionedStream', POINTER(tagVersionedStream)),
    ('parray', wirePSAFEARRAY),
    ('cac', tagCAC),
    ('caub', tagCAUB),
    ('cai', tagCAI),
    ('caui', tagCAUI),
    ('cal', tagCAL),
    ('caul', tagCAUL),
    ('cah', tagCAH),
    ('cauh', tagCAUH),
    ('caflt', tagCAFLT),
    ('cadbl', tagCADBL),
    ('cabool', tagCABOOL),
    ('cascode', tagCASCODE),
    ('cacy', tagCACY),
    ('cadate', tagCADATE),
    ('cafiletime', tagCAFILETIME),
    ('cauuid', tagCACLSID),
    ('caclipdata', tagCACLIPDATA),
    ('cabstr', tagCABSTR),
    ('cabstrblob', tagCABSTRBLOB),
    ('calpstr', tagCALPSTR),
    ('calpwstr', tagCALPWSTR),
    ('capropvar', tagCAPROPVARIANT),
    ('pcVal', POINTER(c_ubyte)),
    ('pbVal', POINTER(c_ubyte)),
    ('piVal', POINTER(c_short)),
    ('puiVal', POINTER(c_ushort)),
    ('plVal', POINTER(c_int)),
    ('pulVal', POINTER(c_ulong)),
    ('pintVal', POINTER(c_int)),
    ('puintVal', POINTER(c_uint)),
    ('pfltVal', POINTER(c_float)),
    ('pdblVal', POINTER(c_double)),
    ('pboolVal', POINTER(VARIANT_BOOL)),
    ('pdecVal', POINTER(DECIMAL)),
    ('pscode', POINTER(SCODE)),
    ('pcyVal', POINTER(c_longlong)),
    ('pdate', POINTER(c_double)),
    ('pbstrVal', POINTER(BSTR)),
    ('ppunkVal', POINTER(POINTER(IUnknown))),
    ('ppdispVal', POINTER(POINTER(IDispatch))),
    ('pparray', POINTER(wirePSAFEARRAY)),
    ('pvarVal', POINTER(tag_inner_PROPVARIANT)),
]

assert sizeof(__MIDL___MIDL_itf_msvidctl_0003_0263_0001) == 16, sizeof(__MIDL___MIDL_itf_msvidctl_0003_0263_0001)
assert alignment(__MIDL___MIDL_itf_msvidctl_0003_0263_0001) == 8, alignment(__MIDL___MIDL_itf_msvidctl_0003_0263_0001)


class IMSVidOutputDevices(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """MS Video Control Output Device Writable Collection Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{C5702CD2-9B79-11D3-B654-00C04F79498E}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_Count(self) -> hints.Incomplete: ...
        Count = hints.normal_property(_get_Count)
        __len__ = hints.to_dunder_len(Count)
        def _get__NewEnum(self) -> hints.Incomplete: ...
        _NewEnum = hints.normal_property(_get__NewEnum)
        __iter__ = hints.to_dunder_iter(_NewEnum)
        def _get_Item(self, v: hints.Incomplete) -> 'IMSVidOutputDevice': ...
        Item = hints.named_property('Item', _get_Item)
        __call__ = hints.to_dunder_call(Item)
        __getitem__ = hints.to_dunder_getitem(Item)
        __setitem__ = hints.to_dunder_setitem(Item)
        def Add(self, pDB: hints.Incomplete) -> hints.Hresult: ...
        def Remove(self, v: hints.Incomplete) -> hints.Hresult: ...


IMSVidOutputDevices._methods_ = [
    COMMETHOD(
        [dispid(16), 'propget'],
        HRESULT,
        'Count',
        (['out', 'retval'], POINTER(c_int), 'lCount')
    ),
    COMMETHOD(
        [dispid(-4), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_NewEnum',
        (
            ['out', 'retval'],
            POINTER(POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IEnumVARIANT)),
            'pD',
        )
    ),
    COMMETHOD(
        [dispid(0), 'propget'],
        HRESULT,
        'Item',
        (['in'], VARIANT, 'v'),
        (['out', 'retval'], POINTER(POINTER(IMSVidOutputDevice)), 'pDB')
    ),
    COMMETHOD(
        [dispid(-553)],
        HRESULT,
        'Add',
        (['in'], POINTER(IMSVidOutputDevice), 'pDB')
    ),
    COMMETHOD(
        [dispid(-555)],
        HRESULT,
        'Remove',
        (['in'], VARIANT, 'v')
    ),
]

################################################################
# code template for IMSVidOutputDevices implementation
# class IMSVidOutputDevices_Impl(object):
#     @property
#     def Count(self):
#         '-no docstring-'
#         #return lCount
#
#     @property
#     def _NewEnum(self):
#         '-no docstring-'
#         #return pD
#
#     @property
#     def Item(self, v):
#         '-no docstring-'
#         #return pDB
#
#     def Add(self, pDB):
#         '-no docstring-'
#         #return 
#
#     def Remove(self, v):
#         '-no docstring-'
#         #return 
#


class IMSVidInputDevices(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """MS Video Control Input Device Writable Collection Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{C5702CD1-9B79-11D3-B654-00C04F79498E}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_Count(self) -> hints.Incomplete: ...
        Count = hints.normal_property(_get_Count)
        __len__ = hints.to_dunder_len(Count)
        def _get__NewEnum(self) -> hints.Incomplete: ...
        _NewEnum = hints.normal_property(_get__NewEnum)
        __iter__ = hints.to_dunder_iter(_NewEnum)
        def _get_Item(self, v: hints.Incomplete) -> 'IMSVidInputDevice': ...
        Item = hints.named_property('Item', _get_Item)
        __call__ = hints.to_dunder_call(Item)
        __getitem__ = hints.to_dunder_getitem(Item)
        __setitem__ = hints.to_dunder_setitem(Item)
        def Add(self, pDB: hints.Incomplete) -> hints.Hresult: ...
        def Remove(self, v: hints.Incomplete) -> hints.Hresult: ...


IMSVidInputDevices._methods_ = [
    COMMETHOD(
        [dispid(16), 'propget'],
        HRESULT,
        'Count',
        (['out', 'retval'], POINTER(c_int), 'lCount')
    ),
    COMMETHOD(
        [dispid(-4), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_NewEnum',
        (
            ['out', 'retval'],
            POINTER(POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IEnumVARIANT)),
            'pD',
        )
    ),
    COMMETHOD(
        [dispid(0), 'propget'],
        HRESULT,
        'Item',
        (['in'], VARIANT, 'v'),
        (['out', 'retval'], POINTER(POINTER(IMSVidInputDevice)), 'pDB')
    ),
    COMMETHOD(
        [dispid(-553)],
        HRESULT,
        'Add',
        (['in'], POINTER(IMSVidInputDevice), 'pDB')
    ),
    COMMETHOD(
        [dispid(-555)],
        HRESULT,
        'Remove',
        (['in'], VARIANT, 'v')
    ),
]

################################################################
# code template for IMSVidInputDevices implementation
# class IMSVidInputDevices_Impl(object):
#     @property
#     def Count(self):
#         '-no docstring-'
#         #return lCount
#
#     @property
#     def _NewEnum(self):
#         '-no docstring-'
#         #return pD
#
#     @property
#     def Item(self, v):
#         '-no docstring-'
#         #return pDB
#
#     def Add(self, pDB):
#         '-no docstring-'
#         #return 
#
#     def Remove(self, v):
#         '-no docstring-'
#         #return 
#

IComponentType._methods_ = [
    COMMETHOD(
        [dispid(1), helpstring('General category of component'), 'propget'],
        HRESULT,
        'Category',
        (['out', 'retval'], POINTER(ComponentCategory), 'Category')
    ),
    COMMETHOD(
        [dispid(1), helpstring('General category of component'), 'propput'],
        HRESULT,
        'Category',
        (['in'], ComponentCategory, 'Category')
    ),
    COMMETHOD(
        [dispid(2), helpstring('DirectShow MediaType Major Type Guid'), 'propget'],
        HRESULT,
        'MediaMajorType',
        (['out', 'retval'], POINTER(BSTR), 'MediaMajorType')
    ),
    COMMETHOD(
        [dispid(2), helpstring('DirectShow MediaType Major Type Guid'), 'propput'],
        HRESULT,
        'MediaMajorType',
        (['in'], BSTR, 'MediaMajorType')
    ),
    COMMETHOD(
        [dispid(3), helpstring('DirectShow MediaType Major Type Guid'), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_MediaMajorType',
        (
            ['out', 'retval'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'MediaMajorTypeGuid',
        )
    ),
    COMMETHOD(
        [dispid(3), helpstring('DirectShow MediaType Major Type Guid'), 'restricted', 'hidden', 'propput'],
        HRESULT,
        '_MediaMajorType',
        (
            ['in'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'MediaMajorTypeGuid',
        )
    ),
    COMMETHOD(
        [dispid(4), helpstring('DirectShow MediaType Sub Type Guid'), 'propget'],
        HRESULT,
        'MediaSubType',
        (['out', 'retval'], POINTER(BSTR), 'MediaSubType')
    ),
    COMMETHOD(
        [dispid(4), helpstring('DirectShow MediaType Sub Type Guid'), 'propput'],
        HRESULT,
        'MediaSubType',
        (['in'], BSTR, 'MediaSubType')
    ),
    COMMETHOD(
        [dispid(5), helpstring('DirectShow MediaType Sub Type Guid'), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_MediaSubType',
        (
            ['out', 'retval'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'MediaSubTypeGuid',
        )
    ),
    COMMETHOD(
        [dispid(5), helpstring('DirectShow MediaType Sub Type Guid'), 'restricted', 'hidden', 'propput'],
        HRESULT,
        '_MediaSubType',
        (
            ['in'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'MediaSubTypeGuid',
        )
    ),
    COMMETHOD(
        [dispid(6), helpstring('DirectShow MediaType Format Guid'), 'propget'],
        HRESULT,
        'MediaFormatType',
        (['out', 'retval'], POINTER(BSTR), 'MediaFormatType')
    ),
    COMMETHOD(
        [dispid(6), helpstring('DirectShow MediaType Format Guid'), 'propput'],
        HRESULT,
        'MediaFormatType',
        (['in'], BSTR, 'MediaFormatType')
    ),
    COMMETHOD(
        [dispid(7), helpstring('DirectShow MediaType Format Guid'), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_MediaFormatType',
        (
            ['out', 'retval'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'MediaFormatTypeGuid',
        )
    ),
    COMMETHOD(
        [dispid(7), helpstring('DirectShow MediaType Format Guid'), 'restricted', 'hidden', 'propput'],
        HRESULT,
        '_MediaFormatType',
        (
            ['in'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'MediaFormatTypeGuid',
        )
    ),
    COMMETHOD(
        [dispid(8), helpstring('DirectShow MediaType Guid, this only retrieves major, sub, format guids not the entire struct'), 'restricted', 'hidden', 'propget'],
        HRESULT,
        'MediaType',
        (['out', 'retval'], POINTER(_AMMediaType), 'MediaType')
    ),
    COMMETHOD(
        [dispid(8), helpstring('DirectShow MediaType Guid, this only retrieves major, sub, format guids not the entire struct'), 'restricted', 'hidden', 'propput'],
        HRESULT,
        'MediaType',
        (['in'], POINTER(_AMMediaType), 'MediaType')
    ),
    COMMETHOD(
        [dispid(9), helpstring('Create a copy of this component type')],
        HRESULT,
        'Clone',
        (['out', 'retval'], POINTER(POINTER(IComponentType)), 'NewCT')
    ),
]

################################################################
# code template for IComponentType implementation
# class IComponentType_Impl(object):
#     def _get(self):
#         'General category of component'
#         #return Category
#     def _set(self, Category):
#         'General category of component'
#     Category = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'DirectShow MediaType Major Type Guid'
#         #return MediaMajorType
#     def _set(self, MediaMajorType):
#         'DirectShow MediaType Major Type Guid'
#     MediaMajorType = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'DirectShow MediaType Major Type Guid'
#         #return MediaMajorTypeGuid
#     def _set(self, MediaMajorTypeGuid):
#         'DirectShow MediaType Major Type Guid'
#     _MediaMajorType = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'DirectShow MediaType Sub Type Guid'
#         #return MediaSubType
#     def _set(self, MediaSubType):
#         'DirectShow MediaType Sub Type Guid'
#     MediaSubType = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'DirectShow MediaType Sub Type Guid'
#         #return MediaSubTypeGuid
#     def _set(self, MediaSubTypeGuid):
#         'DirectShow MediaType Sub Type Guid'
#     _MediaSubType = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'DirectShow MediaType Format Guid'
#         #return MediaFormatType
#     def _set(self, MediaFormatType):
#         'DirectShow MediaType Format Guid'
#     MediaFormatType = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'DirectShow MediaType Format Guid'
#         #return MediaFormatTypeGuid
#     def _set(self, MediaFormatTypeGuid):
#         'DirectShow MediaType Format Guid'
#     _MediaFormatType = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'DirectShow MediaType Guid, this only retrieves major, sub, format guids not the entire struct'
#         #return MediaType
#     def _set(self, MediaType):
#         'DirectShow MediaType Guid, this only retrieves major, sub, format guids not the entire struct'
#     MediaType = property(_get, _set, doc = _set.__doc__)
#
#     def Clone(self):
#         'Create a copy of this component type'
#         #return NewCT
#


class IRunningObjectTable(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    _case_insensitive_ = True
    _iid_ = GUID('{00000010-0000-0000-C000-000000000046}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def Register(self, grfFlags: hints.Incomplete, punkObject: hints.Incomplete, pmkObjectName: hints.Incomplete) -> hints.Incomplete: ...
        def Revoke(self, dwRegister: hints.Incomplete) -> hints.Hresult: ...
        def IsRunning(self, pmkObjectName: hints.Incomplete) -> hints.Hresult: ...
        def GetObject(self, pmkObjectName: hints.Incomplete) -> hints.Incomplete: ...
        def NoteChangeTime(self, dwRegister: hints.Incomplete, pfiletime: hints.Incomplete) -> hints.Hresult: ...
        def GetTimeOfLastChange(self, pmkObjectName: hints.Incomplete) -> hints.Incomplete: ...
        def EnumRunning(self) -> 'IEnumMoniker': ...


IRunningObjectTable._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'Register',
        (['in'], c_ulong, 'grfFlags'),
        (['in'], POINTER(IUnknown), 'punkObject'),
        (['in'], POINTER(IMoniker), 'pmkObjectName'),
        (['out'], POINTER(c_ulong), 'pdwRegister')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Revoke',
        (['in'], c_ulong, 'dwRegister')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'IsRunning',
        (['in'], POINTER(IMoniker), 'pmkObjectName')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetObject',
        (['in'], POINTER(IMoniker), 'pmkObjectName'),
        (['out'], POINTER(POINTER(IUnknown)), 'ppunkObject')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'NoteChangeTime',
        (['in'], c_ulong, 'dwRegister'),
        (['in'], POINTER(_FILETIME), 'pfiletime')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetTimeOfLastChange',
        (['in'], POINTER(IMoniker), 'pmkObjectName'),
        (['out'], POINTER(_FILETIME), 'pfiletime')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'EnumRunning',
        (['out'], POINTER(POINTER(IEnumMoniker)), 'ppenumMoniker')
    ),
]

################################################################
# code template for IRunningObjectTable implementation
# class IRunningObjectTable_Impl(object):
#     def Register(self, grfFlags, punkObject, pmkObjectName):
#         '-no docstring-'
#         #return pdwRegister
#
#     def Revoke(self, dwRegister):
#         '-no docstring-'
#         #return 
#
#     def IsRunning(self, pmkObjectName):
#         '-no docstring-'
#         #return 
#
#     def GetObject(self, pmkObjectName):
#         '-no docstring-'
#         #return ppunkObject
#
#     def NoteChangeTime(self, dwRegister, pfiletime):
#         '-no docstring-'
#         #return 
#
#     def GetTimeOfLastChange(self, pmkObjectName):
#         '-no docstring-'
#         #return pfiletime
#
#     def EnumRunning(self):
#         '-no docstring-'
#         #return ppenumMoniker
#

IMSVidRect._methods_ = [
    COMMETHOD(
        ['propget', helpstring('Rectangle Top')],
        HRESULT,
        'Top',
        (['out', 'retval'], POINTER(c_int), 'TopVal')
    ),
    COMMETHOD(
        ['propput', helpstring('Rectangle Top')],
        HRESULT,
        'Top',
        (['in'], c_int, 'TopVal')
    ),
    COMMETHOD(
        ['propget', helpstring('Rectangle Left')],
        HRESULT,
        'Left',
        (['out', 'retval'], POINTER(c_int), 'LeftVal')
    ),
    COMMETHOD(
        ['propput', helpstring('Rectangle Left')],
        HRESULT,
        'Left',
        (['in'], c_int, 'LeftVal')
    ),
    COMMETHOD(
        ['propget', helpstring('Rectangle Width')],
        HRESULT,
        'Width',
        (['out', 'retval'], POINTER(c_int), 'WidthVal')
    ),
    COMMETHOD(
        ['propput', helpstring('Rectangle Width')],
        HRESULT,
        'Width',
        (['in'], c_int, 'WidthVal')
    ),
    COMMETHOD(
        ['propget', helpstring('Rectangle Height')],
        HRESULT,
        'Height',
        (['out', 'retval'], POINTER(c_int), 'HeightVal')
    ),
    COMMETHOD(
        ['propput', helpstring('Rectangle Height')],
        HRESULT,
        'Height',
        (['in'], c_int, 'HeightVal')
    ),
    COMMETHOD(
        ['propget', helpstring('Coordinates relative to HWnd')],
        HRESULT,
        'HWnd',
        (['out', 'retval'], POINTER(wireHWND), 'HWndVal')
    ),
    COMMETHOD(
        ['propput', helpstring('Coordinates relative to HWnd')],
        HRESULT,
        'HWnd',
        (['in'], wireHWND, 'HWndVal')
    ),
    COMMETHOD(
        ['propput', helpstring('New Rectangle Values')],
        HRESULT,
        'Rect',
        (['in'], POINTER(IMSVidRect), 'rhs')
    ),
]

################################################################
# code template for IMSVidRect implementation
# class IMSVidRect_Impl(object):
#     def _get(self):
#         'Rectangle Top'
#         #return TopVal
#     def _set(self, TopVal):
#         'Rectangle Top'
#     Top = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Rectangle Left'
#         #return LeftVal
#     def _set(self, LeftVal):
#         'Rectangle Left'
#     Left = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Rectangle Width'
#         #return WidthVal
#     def _set(self, WidthVal):
#         'Rectangle Width'
#     Width = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Rectangle Height'
#         #return HeightVal
#     def _set(self, HeightVal):
#         'Rectangle Height'
#     Height = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Coordinates relative to HWnd'
#         #return HWndVal
#     def _set(self, HWndVal):
#         'Coordinates relative to HWnd'
#     HWnd = property(_get, _set, doc = _set.__doc__)
#
#     def _set(self, rhs):
#         'New Rectangle Values'
#     Rect = property(fset = _set, doc = _set.__doc__)
#

IStream._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'RemoteSeek',
        (['in'], _LARGE_INTEGER, 'dlibMove'),
        (['in'], c_ulong, 'dwOrigin'),
        (['out'], POINTER(_ULARGE_INTEGER), 'plibNewPosition')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'SetSize',
        (['in'], _ULARGE_INTEGER, 'libNewSize')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'RemoteCopyTo',
        (['in'], POINTER(IStream), 'pstm'),
        (['in'], _ULARGE_INTEGER, 'cb'),
        (['out'], POINTER(_ULARGE_INTEGER), 'pcbRead'),
        (['out'], POINTER(_ULARGE_INTEGER), 'pcbWritten')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Commit',
        (['in'], c_ulong, 'grfCommitFlags')
    ),
    COMMETHOD([], HRESULT, 'Revert'),
    COMMETHOD(
        [],
        HRESULT,
        'LockRegion',
        (['in'], _ULARGE_INTEGER, 'libOffset'),
        (['in'], _ULARGE_INTEGER, 'cb'),
        (['in'], c_ulong, 'dwLockType')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'UnlockRegion',
        (['in'], _ULARGE_INTEGER, 'libOffset'),
        (['in'], _ULARGE_INTEGER, 'cb'),
        (['in'], c_ulong, 'dwLockType')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Stat',
        (['out'], POINTER(tagSTATSTG), 'pstatstg'),
        (['in'], c_ulong, 'grfStatFlag')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Clone',
        (['out'], POINTER(POINTER(IStream)), 'ppstm')
    ),
]

################################################################
# code template for IStream implementation
# class IStream_Impl(object):
#     def RemoteSeek(self, dlibMove, dwOrigin):
#         '-no docstring-'
#         #return plibNewPosition
#
#     def SetSize(self, libNewSize):
#         '-no docstring-'
#         #return 
#
#     def RemoteCopyTo(self, pstm, cb):
#         '-no docstring-'
#         #return pcbRead, pcbWritten
#
#     def Commit(self, grfCommitFlags):
#         '-no docstring-'
#         #return 
#
#     def Revert(self):
#         '-no docstring-'
#         #return 
#
#     def LockRegion(self, libOffset, cb, dwLockType):
#         '-no docstring-'
#         #return 
#
#     def UnlockRegion(self, libOffset, cb, dwLockType):
#         '-no docstring-'
#         #return 
#
#     def Stat(self, grfStatFlag):
#         '-no docstring-'
#         #return pstatstg
#
#     def Clone(self):
#         '-no docstring-'
#         #return ppstm
#


class __MIDL_IWinTypes_0009(Union):
    pass


__MIDL_IWinTypes_0009._fields_ = [
    ('hInproc', c_int),
    ('hRemote', c_int),
]

assert sizeof(__MIDL_IWinTypes_0009) == 4, sizeof(__MIDL_IWinTypes_0009)
assert alignment(__MIDL_IWinTypes_0009) == 4, alignment(__MIDL_IWinTypes_0009)

_RemotableHandle._fields_ = [
    ('fContext', c_int),
    ('u', __MIDL_IWinTypes_0009),
]

assert sizeof(_RemotableHandle) == 8, sizeof(_RemotableHandle)
assert alignment(_RemotableHandle) == 4, alignment(_RemotableHandle)


class IMSVidVideoRendererDevices(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """MS Video Control Video Renderer Device Writable Collection Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{C5702CD3-9B79-11D3-B654-00C04F79498E}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_Count(self) -> hints.Incomplete: ...
        Count = hints.normal_property(_get_Count)
        __len__ = hints.to_dunder_len(Count)
        def _get__NewEnum(self) -> hints.Incomplete: ...
        _NewEnum = hints.normal_property(_get__NewEnum)
        __iter__ = hints.to_dunder_iter(_NewEnum)
        def _get_Item(self, v: hints.Incomplete) -> 'IMSVidVideoRenderer': ...
        Item = hints.named_property('Item', _get_Item)
        __call__ = hints.to_dunder_call(Item)
        __getitem__ = hints.to_dunder_getitem(Item)
        __setitem__ = hints.to_dunder_setitem(Item)
        def Add(self, pDB: hints.Incomplete) -> hints.Hresult: ...
        def Remove(self, v: hints.Incomplete) -> hints.Hresult: ...


IMSVidVideoRendererDevices._methods_ = [
    COMMETHOD(
        [dispid(16), 'propget'],
        HRESULT,
        'Count',
        (['out', 'retval'], POINTER(c_int), 'lCount')
    ),
    COMMETHOD(
        [dispid(-4), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_NewEnum',
        (
            ['out', 'retval'],
            POINTER(POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IEnumVARIANT)),
            'pD',
        )
    ),
    COMMETHOD(
        [dispid(0), 'propget'],
        HRESULT,
        'Item',
        (['in'], VARIANT, 'v'),
        (['out', 'retval'], POINTER(POINTER(IMSVidVideoRenderer)), 'pDB')
    ),
    COMMETHOD(
        [dispid(-553)],
        HRESULT,
        'Add',
        (['in'], POINTER(IMSVidVideoRenderer), 'pDB')
    ),
    COMMETHOD(
        [dispid(-555)],
        HRESULT,
        'Remove',
        (['in'], VARIANT, 'v')
    ),
]

################################################################
# code template for IMSVidVideoRendererDevices implementation
# class IMSVidVideoRendererDevices_Impl(object):
#     @property
#     def Count(self):
#         '-no docstring-'
#         #return lCount
#
#     @property
#     def _NewEnum(self):
#         '-no docstring-'
#         #return pD
#
#     @property
#     def Item(self, v):
#         '-no docstring-'
#         #return pDB
#
#     def Add(self, pDB):
#         '-no docstring-'
#         #return 
#
#     def Remove(self, v):
#         '-no docstring-'
#         #return 
#


class MSVidEVR(CoClass):
    """MS Video Control Enhanced Video Renderer(DX10) Class"""
    _reg_clsid_ = GUID('{C45268A2-FA81-4E19-B1E3-72EDBD60AEDA}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


class IMSVidEVR(IMSVidVideoRenderer):
    """MS Video Control Enhanced Video Renderer(DX10) Device Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{15E496AE-82A8-4CF9-A6B6-C561DC60398F}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_Presenter(self) -> 'IMFVideoPresenter': ...
        def _set_Presenter(self, ppAllocPresent: hints.Incomplete) -> hints.Hresult: ...
        Presenter = hints.normal_property(_get_Presenter, _set_Presenter)
        def _get_SuppressEffects(self) -> hints.Incomplete: ...
        def _set_SuppressEffects(self, bSuppress: hints.Incomplete) -> hints.Hresult: ...
        SuppressEffects = hints.normal_property(_get_SuppressEffects, _set_SuppressEffects)


class IMSVidEVREvent(IMSVidOutputDeviceEvent):
    """MS Video Control EVR Event Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{349ABB10-883C-4F22-8714-CECAEEE45D62}')
    _idlflags_ = ['hidden', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def OnUserEvent(self, lEventCode: hints.Incomplete) -> hints.Hresult: ...


MSVidEVR._com_interfaces_ = [IMSVidEVR, IMSVidGraphSegment]
MSVidEVR._outgoing_interfaces_ = [IMSVidEVREvent]


class IEnumString(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    _case_insensitive_ = True
    _iid_ = GUID('{00000101-0000-0000-C000-000000000046}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def RemoteNext(self, celt: hints.Incomplete) -> hints.Tuple[hints.Incomplete, hints.Incomplete]: ...
        def Skip(self, celt: hints.Incomplete) -> hints.Hresult: ...
        def Reset(self) -> hints.Hresult: ...
        def Clone(self) -> 'IEnumString': ...


IEnumString._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'RemoteNext',
        (['in'], c_ulong, 'celt'),
        (['out'], POINTER(WSTRING), 'rgelt'),
        (['out'], POINTER(c_ulong), 'pceltFetched')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Skip',
        (['in'], c_ulong, 'celt')
    ),
    COMMETHOD([], HRESULT, 'Reset'),
    COMMETHOD(
        [],
        HRESULT,
        'Clone',
        (['out'], POINTER(POINTER(IEnumString)), 'ppenum')
    ),
]

################################################################
# code template for IEnumString implementation
# class IEnumString_Impl(object):
#     def RemoteNext(self, celt):
#         '-no docstring-'
#         #return rgelt, pceltFetched
#
#     def Skip(self, celt):
#         '-no docstring-'
#         #return 
#
#     def Reset(self):
#         '-no docstring-'
#         #return 
#
#     def Clone(self):
#         '-no docstring-'
#         #return ppenum
#

IMSVidVMR9._methods_ = [
    COMMETHOD(
        [dispid(165), 'propget'],
        HRESULT,
        'Allocator_ID',
        (['out', 'retval'], POINTER(c_int), 'Id')
    ),
    COMMETHOD(
        [dispid(166)],
        HRESULT,
        'SetAllocator',
        (['in'], POINTER(IUnknown), 'AllocPresent'),
        (['in', 'optional'], c_int, 'Id', -1)
    ),
    COMMETHOD(
        [dispid(189), 'propput'],
        HRESULT,
        'SuppressEffects',
        (['in'], VARIANT_BOOL, 'bSuppress')
    ),
    COMMETHOD(
        [dispid(189), 'propget'],
        HRESULT,
        'SuppressEffects',
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'bSuppress')
    ),
    COMMETHOD(
        [dispid(163), 'propget'],
        HRESULT,
        'Allocator',
        (['out', 'retval'], POINTER(POINTER(IUnknown)), 'AllocPresent')
    ),
]

################################################################
# code template for IMSVidVMR9 implementation
# class IMSVidVMR9_Impl(object):
#     @property
#     def Allocator_ID(self):
#         '-no docstring-'
#         #return Id
#
#     def SetAllocator(self, AllocPresent, Id):
#         '-no docstring-'
#         #return 
#
#     def _get(self):
#         '-no docstring-'
#         #return bSuppress
#     def _set(self, bSuppress):
#         '-no docstring-'
#     SuppressEffects = property(_get, _set, doc = _set.__doc__)
#
#     @property
#     def Allocator(self):
#         '-no docstring-'
#         #return AllocPresent
#

IMSVidEVREvent._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'OnUserEvent',
        (['in'], c_int, 'lEventCode')
    ),
]

################################################################
# code template for IMSVidEVREvent implementation
# class IMSVidEVREvent_Impl(object):
#     def OnUserEvent(self, lEventCode):
#         '-no docstring-'
#         #return 
#


class IEnumComponents(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    _case_insensitive_ = True
    _iid_ = GUID('{2A6E2939-2595-11D3-B64C-00C04F79498E}')
    _idlflags_ = ['hidden', 'restricted']

    def __iter__(self):
        return self

    def __next__(self):
        item, fetched = self.Next(1)
        if fetched:
            return item
        raise StopIteration

    def __getitem__(self, index):
        self.Reset()
        self.Skip(index)
        item, fetched = self.Next(1)
        if fetched:
            return item
        raise IndexError(index)

    if TYPE_CHECKING:  # commembers
        def Next(self, celt: hints.Incomplete) -> hints.Tuple['IComponent', hints.Incomplete]: ...
        def Skip(self, celt: hints.Incomplete) -> hints.Hresult: ...
        def Reset(self) -> hints.Hresult: ...
        def Clone(self) -> 'IEnumComponents': ...


class IComponent(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """Component Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{1A5576FC-0E19-11D3-9D8E-00C04F72D980}')
    _idlflags_ = ['dual', 'nonextensible', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_type(self) -> 'IComponentType': ...
        def _set_type(self, CT: hints.Incomplete) -> hints.Hresult: ...
        type = hints.normal_property(_get_type, _set_type)
        def _get_DescLangID(self) -> hints.Incomplete: ...
        def _set_DescLangID(self, LangID: hints.Incomplete) -> hints.Hresult: ...
        DescLangID = hints.normal_property(_get_DescLangID, _set_DescLangID)
        def _get_Status(self) -> hints.Incomplete: ...
        def _set_Status(self, Status: hints.Incomplete) -> hints.Hresult: ...
        Status = hints.normal_property(_get_Status, _set_Status)
        def _get_Description(self) -> hints.Incomplete: ...
        def _set_Description(self, Description: hints.Incomplete) -> hints.Hresult: ...
        Description = hints.normal_property(_get_Description, _set_Description)
        def Clone(self) -> 'IComponent': ...


IComponents._methods_ = [
    COMMETHOD(
        [dispid(1610743808), helpstring('Number of items in the collection'), 'propget'],
        HRESULT,
        'Count',
        (['out', 'retval'], POINTER(c_int), 'Count')
    ),
    COMMETHOD(
        [dispid(-4), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_NewEnum',
        (
            ['out', 'retval'],
            POINTER(POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IEnumVARIANT)),
            'ppNewEnum',
        )
    ),
    COMMETHOD(
        [dispid(1610743810), helpstring('Convenience Function for Use with C'), 'restricted', 'hidden'],
        HRESULT,
        'EnumComponents',
        (['out', 'retval'], POINTER(POINTER(IEnumComponents)), 'ppNewEnum')
    ),
    COMMETHOD(
        [dispid(0), helpstring('Get the Component at the specified index'), 'propget'],
        HRESULT,
        'Item',
        (['in'], VARIANT, 'Index'),
        (['out', 'retval'], POINTER(POINTER(IComponent)), 'ppComponent')
    ),
    COMMETHOD(
        [dispid(-553), helpstring('Add the Component to the collection')],
        HRESULT,
        'Add',
        (['in'], POINTER(IComponent), 'Component'),
        (['out', 'retval'], POINTER(VARIANT), 'NewIndex')
    ),
    COMMETHOD(
        [dispid(-555), helpstring('Remove the Component at the specified index')],
        HRESULT,
        'Remove',
        (['in'], VARIANT, 'Index')
    ),
    COMMETHOD(
        [dispid(1610743814), helpstring('Copy the collection')],
        HRESULT,
        'Clone',
        (['out', 'retval'], POINTER(POINTER(IComponents)), 'NewList')
    ),
    COMMETHOD(
        [dispid(0), helpstring('Get the Component at the specified index'), 'propput'],
        HRESULT,
        'Item',
        (['in'], VARIANT, 'Index'),
        (['in'], POINTER(IComponent), 'ppComponent')
    ),
]

################################################################
# code template for IComponents implementation
# class IComponents_Impl(object):
#     @property
#     def Count(self):
#         'Number of items in the collection'
#         #return Count
#
#     @property
#     def _NewEnum(self):
#         '-no docstring-'
#         #return ppNewEnum
#
#     def EnumComponents(self):
#         'Convenience Function for Use with C'
#         #return ppNewEnum
#
#     def _get(self, Index):
#         'Get the Component at the specified index'
#         #return ppComponent
#     def _set(self, Index, ppComponent):
#         'Get the Component at the specified index'
#     Item = property(_get, _set, doc = _set.__doc__)
#
#     def Add(self, Component):
#         'Add the Component to the collection'
#         #return NewIndex
#
#     def Remove(self, Index):
#         'Remove the Component at the specified index'
#         #return 
#
#     def Clone(self):
#         'Copy the collection'
#         #return NewList
#


class MSVidAudioRenderer(CoClass):
    """MS Video Control Audio Renderer Class"""
    _reg_clsid_ = GUID('{37B03544-A4C8-11D2-B634-00C04F79498E}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidAudioRenderer._com_interfaces_ = [IMSVidAudioRenderer, IMSVidGraphSegment]
MSVidAudioRenderer._outgoing_interfaces_ = [IMSVidAudioRendererEvent]

_AMMediaType._fields_ = [
    ('majortype', comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
    ('subtype', comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
    ('bFixedSizeSamples', c_int),
    ('bTemporalCompression', c_int),
    ('lSampleSize', c_ulong),
    ('formattype', comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
    ('punk', POINTER(IUnknown)),
    ('cbFormat', c_ulong),
    ('pbFormat', POINTER(c_ubyte)),
]

assert sizeof(_AMMediaType) == 88, sizeof(_AMMediaType)
assert alignment(_AMMediaType) == 8, alignment(_AMMediaType)


class IMSVidAudioRendererDevices(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """MS Video Control Audio Renderer Device Writable Collection Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{C5702CD4-9B79-11D3-B654-00C04F79498E}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_Count(self) -> hints.Incomplete: ...
        Count = hints.normal_property(_get_Count)
        __len__ = hints.to_dunder_len(Count)
        def _get__NewEnum(self) -> hints.Incomplete: ...
        _NewEnum = hints.normal_property(_get__NewEnum)
        __iter__ = hints.to_dunder_iter(_NewEnum)
        def _get_Item(self, v: hints.Incomplete) -> 'IMSVidAudioRenderer': ...
        Item = hints.named_property('Item', _get_Item)
        __call__ = hints.to_dunder_call(Item)
        __getitem__ = hints.to_dunder_getitem(Item)
        __setitem__ = hints.to_dunder_setitem(Item)
        def Add(self, pDB: hints.Incomplete) -> hints.Hresult: ...
        def Remove(self, v: hints.Incomplete) -> hints.Hresult: ...


IMSVidAudioRendererDevices._methods_ = [
    COMMETHOD(
        [dispid(16), 'propget'],
        HRESULT,
        'Count',
        (['out', 'retval'], POINTER(c_int), 'lCount')
    ),
    COMMETHOD(
        [dispid(-4), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_NewEnum',
        (
            ['out', 'retval'],
            POINTER(POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IEnumVARIANT)),
            'pD',
        )
    ),
    COMMETHOD(
        [dispid(0), 'propget'],
        HRESULT,
        'Item',
        (['in'], VARIANT, 'v'),
        (['out', 'retval'], POINTER(POINTER(IMSVidAudioRenderer)), 'pDB')
    ),
    COMMETHOD(
        [dispid(-553)],
        HRESULT,
        'Add',
        (['in'], POINTER(IMSVidAudioRenderer), 'pDB')
    ),
    COMMETHOD(
        [dispid(-555)],
        HRESULT,
        'Remove',
        (['in'], VARIANT, 'v')
    ),
]

################################################################
# code template for IMSVidAudioRendererDevices implementation
# class IMSVidAudioRendererDevices_Impl(object):
#     @property
#     def Count(self):
#         '-no docstring-'
#         #return lCount
#
#     @property
#     def _NewEnum(self):
#         '-no docstring-'
#         #return pD
#
#     @property
#     def Item(self, v):
#         '-no docstring-'
#         #return pDB
#
#     def Add(self, pDB):
#         '-no docstring-'
#         #return 
#
#     def Remove(self, v):
#         '-no docstring-'
#         #return 
#


class IVMRSurfaceAllocatorNotify(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    """IVMRSurfaceAllocatorNotify Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{AADA05A8-5A4E-4729-AF0B-CEA27AED51E2}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def AdviseSurfaceAllocator(self, dwUserID: hints.Incomplete, lpIVRMSurfaceAllocator: hints.Incomplete) -> hints.Hresult: ...
        def SetDDrawDevice(self, lpDDrawDevice: hints.Incomplete, hMonitor: hints.Incomplete) -> hints.Hresult: ...
        def ChangeDDrawDevice(self, lpDDrawDevice: hints.Incomplete, hMonitor: hints.Incomplete) -> hints.Hresult: ...
        def RestoreDDrawSurfaces(self) -> hints.Hresult: ...
        def NotifyEvent(self, EventCode: hints.Incomplete, Param1: hints.Incomplete, Param2: hints.Incomplete) -> hints.Hresult: ...
        def SetBorderColor(self, clrBorder: hints.Incomplete) -> hints.Hresult: ...


IVMRSurfaceAllocatorNotify._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'AdviseSurfaceAllocator',
        (['in'], ULONG_PTR, 'dwUserID'),
        (['in'], POINTER(IVMRSurfaceAllocator), 'lpIVRMSurfaceAllocator')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'SetDDrawDevice',
        (['in'], POINTER(c_ulong), 'lpDDrawDevice'),
        (['in'], c_void_p, 'hMonitor')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'ChangeDDrawDevice',
        (['in'], POINTER(c_ulong), 'lpDDrawDevice'),
        (['in'], c_void_p, 'hMonitor')
    ),
    COMMETHOD([], HRESULT, 'RestoreDDrawSurfaces'),
    COMMETHOD(
        [],
        HRESULT,
        'NotifyEvent',
        (['in'], c_int, 'EventCode'),
        (['in'], LONG_PTR, 'Param1'),
        (['in'], LONG_PTR, 'Param2')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'SetBorderColor',
        (['in'], c_ulong, 'clrBorder')
    ),
]

################################################################
# code template for IVMRSurfaceAllocatorNotify implementation
# class IVMRSurfaceAllocatorNotify_Impl(object):
#     def AdviseSurfaceAllocator(self, dwUserID, lpIVRMSurfaceAllocator):
#         '-no docstring-'
#         #return 
#
#     def SetDDrawDevice(self, lpDDrawDevice, hMonitor):
#         '-no docstring-'
#         #return 
#
#     def ChangeDDrawDevice(self, lpDDrawDevice, hMonitor):
#         '-no docstring-'
#         #return 
#
#     def RestoreDDrawSurfaces(self):
#         '-no docstring-'
#         #return 
#
#     def NotifyEvent(self, EventCode, Param1, Param2):
#         '-no docstring-'
#         #return 
#
#     def SetBorderColor(self, clrBorder):
#         '-no docstring-'
#         #return 
#


class IMFClockStateSink(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    _case_insensitive_ = True
    _iid_ = GUID('{F6696E82-74F7-4F3D-A178-8A5E09C3659F}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def OnClockStart(self, hnsSystemTime: hints.Incomplete, llClockStartOffset: hints.Incomplete) -> hints.Hresult: ...
        def OnClockStop(self, hnsSystemTime: hints.Incomplete) -> hints.Hresult: ...
        def OnClockPause(self, hnsSystemTime: hints.Incomplete) -> hints.Hresult: ...
        def OnClockRestart(self, hnsSystemTime: hints.Incomplete) -> hints.Hresult: ...
        def OnClockSetRate(self, hnsSystemTime: hints.Incomplete, flRate: hints.Incomplete) -> hints.Hresult: ...


class IMFVideoPresenter(IMFClockStateSink):
    """IMFVideoPresenter Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{29AFF080-182A-4A5D-AF3B-448F3A6346CB}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def ProcessMessage(self, eMessage: hints.Incomplete, ulParam: hints.Incomplete) -> hints.Hresult: ...
        def GetCurrentMediaType(self) -> 'IMFVideoMediaType': ...


IMSVidEVR._methods_ = [
    COMMETHOD(
        [dispid(164), 'propget'],
        HRESULT,
        'Presenter',
        (
            ['out', 'retval'],
            POINTER(POINTER(IMFVideoPresenter)),
            'ppAllocPresent',
        )
    ),
    COMMETHOD(
        [dispid(164), 'propput'],
        HRESULT,
        'Presenter',
        (['in'], POINTER(IMFVideoPresenter), 'ppAllocPresent')
    ),
    COMMETHOD(
        [dispid(189), 'propput'],
        HRESULT,
        'SuppressEffects',
        (['in'], VARIANT_BOOL, 'bSuppress')
    ),
    COMMETHOD(
        [dispid(189), 'propget'],
        HRESULT,
        'SuppressEffects',
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'bSuppress')
    ),
]

################################################################
# code template for IMSVidEVR implementation
# class IMSVidEVR_Impl(object):
#     def _get(self):
#         '-no docstring-'
#         #return ppAllocPresent
#     def _set(self, ppAllocPresent):
#         '-no docstring-'
#     Presenter = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         '-no docstring-'
#         #return bSuppress
#     def _set(self, bSuppress):
#         '-no docstring-'
#     SuppressEffects = property(_get, _set, doc = _set.__doc__)
#

IMFClockStateSink._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'OnClockStart',
        (['in'], c_longlong, 'hnsSystemTime'),
        (['in'], c_longlong, 'llClockStartOffset')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'OnClockStop',
        (['in'], c_longlong, 'hnsSystemTime')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'OnClockPause',
        (['in'], c_longlong, 'hnsSystemTime')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'OnClockRestart',
        (['in'], c_longlong, 'hnsSystemTime')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'OnClockSetRate',
        (['in'], c_longlong, 'hnsSystemTime'),
        (['in'], c_float, 'flRate')
    ),
]

################################################################
# code template for IMFClockStateSink implementation
# class IMFClockStateSink_Impl(object):
#     def OnClockStart(self, hnsSystemTime, llClockStartOffset):
#         '-no docstring-'
#         #return 
#
#     def OnClockStop(self, hnsSystemTime):
#         '-no docstring-'
#         #return 
#
#     def OnClockPause(self, hnsSystemTime):
#         '-no docstring-'
#         #return 
#
#     def OnClockRestart(self, hnsSystemTime):
#         '-no docstring-'
#         #return 
#
#     def OnClockSetRate(self, hnsSystemTime, flRate):
#         '-no docstring-'
#         #return 
#


class IMFAttributes(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    _case_insensitive_ = True
    _iid_ = GUID('{2CD2D921-C447-44A7-A13C-4ADABFC247E3}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def GetItem(self, guidKey: hints.Incomplete, pValue: hints.Incomplete) -> hints.Incomplete: ...
        def GetItemType(self, guidKey: hints.Incomplete) -> hints.Incomplete: ...
        def CompareItem(self, guidKey: hints.Incomplete, Value: hints.Incomplete) -> hints.Incomplete: ...
        def Compare(self, pTheirs: hints.Incomplete, MatchType: hints.Incomplete) -> hints.Incomplete: ...
        def GetUINT32(self, guidKey: hints.Incomplete) -> hints.Incomplete: ...
        def GetUINT64(self, guidKey: hints.Incomplete) -> hints.Incomplete: ...
        def GetDouble(self, guidKey: hints.Incomplete) -> hints.Incomplete: ...
        def GetGuid(self, guidKey: hints.Incomplete) -> hints.Incomplete: ...
        def GetStringLength(self, guidKey: hints.Incomplete) -> hints.Incomplete: ...
        def GetString(self, guidKey: hints.Incomplete, cchBufSize: hints.Incomplete, pcchLength: hints.Incomplete) -> hints.Tuple[hints.Incomplete, hints.Incomplete]: ...
        def GetAllocatedString(self, guidKey: hints.Incomplete) -> hints.Tuple[hints.Incomplete, hints.Incomplete]: ...
        def GetBlobSize(self, guidKey: hints.Incomplete) -> hints.Incomplete: ...
        def GetBlob(self, guidKey: hints.Incomplete, cbBufSize: hints.Incomplete, pcbBlobSize: hints.Incomplete) -> hints.Tuple[hints.Incomplete, hints.Incomplete]: ...
        def GetAllocatedBlob(self, guidKey: hints.Incomplete) -> hints.Tuple[hints.Incomplete, hints.Incomplete]: ...
        def GetUnknown(self, guidKey: hints.Incomplete, riid: hints.Incomplete) -> hints.Incomplete: ...
        def SetItem(self, guidKey: hints.Incomplete, Value: hints.Incomplete) -> hints.Hresult: ...
        def DeleteItem(self, guidKey: hints.Incomplete) -> hints.Hresult: ...
        def DeleteAllItems(self) -> hints.Hresult: ...
        def SetUINT32(self, guidKey: hints.Incomplete, unValue: hints.Incomplete) -> hints.Hresult: ...
        def SetUINT64(self, guidKey: hints.Incomplete, unValue: hints.Incomplete) -> hints.Hresult: ...
        def SetDouble(self, guidKey: hints.Incomplete, fValue: hints.Incomplete) -> hints.Hresult: ...
        def SetGUID(self, guidKey: hints.Incomplete, guidValue: hints.Incomplete) -> hints.Hresult: ...
        def SetString(self, guidKey: hints.Incomplete, wszValue: hints.Incomplete) -> hints.Hresult: ...
        def SetBlob(self, guidKey: hints.Incomplete, pBuf: hints.Incomplete, cbBufSize: hints.Incomplete) -> hints.Hresult: ...
        def SetUnknown(self, guidKey: hints.Incomplete, pUnknown: hints.Incomplete) -> hints.Hresult: ...
        def LockStore(self) -> hints.Hresult: ...
        def UnlockStore(self) -> hints.Hresult: ...
        def GetCount(self) -> hints.Incomplete: ...
        def GetItemByIndex(self, unIndex: hints.Incomplete, pValue: hints.Incomplete) -> hints.Tuple[hints.Incomplete, hints.Incomplete]: ...
        def CopyAllItems(self, pDest: hints.Incomplete) -> hints.Hresult: ...


class IMFMediaType(IMFAttributes):
    _case_insensitive_ = True
    _iid_ = GUID('{44AE0FA8-EA31-4109-8D2E-4CAE4997C555}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def GetMajorType(self) -> hints.Incomplete: ...
        def IsCompressedFormat(self) -> hints.Incomplete: ...
        def IsEqual(self, pIMediaType: hints.Incomplete) -> hints.Incomplete: ...
        def GetRepresentation(self, guidRepresentation: hints.Incomplete) -> hints.Incomplete: ...
        def FreeRepresentation(self, guidRepresentation: hints.Incomplete, pvRepresentation: hints.Incomplete) -> hints.Hresult: ...


class IMFVideoMediaType(IMFMediaType):
    _case_insensitive_ = True
    _iid_ = GUID('{B99F381F-A8F9-47A2-A5AF-CA3A225A3890}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def GetVideoFormat(self) -> hints.Hresult: ...
        def GetVideoRepresentation(self, guidRepresentation: hints.Incomplete, lStride: hints.Incomplete) -> hints.Incomplete: ...


IMFVideoPresenter._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'ProcessMessage',
        ([], MFVP_MESSAGE_TYPE, 'eMessage'),
        ([], ULONG_PTR, 'ulParam')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetCurrentMediaType',
        (['out'], POINTER(POINTER(IMFVideoMediaType)), 'ppMediaType')
    ),
]

################################################################
# code template for IMFVideoPresenter implementation
# class IMFVideoPresenter_Impl(object):
#     def ProcessMessage(self, eMessage, ulParam):
#         '-no docstring-'
#         #return 
#
#     def GetCurrentMediaType(self):
#         '-no docstring-'
#         #return ppMediaType
#


class __MIDL_IOleAutomationTypes_0005(Union):
    pass


__MIDL_IOleAutomationTypes_0005._fields_ = [
    ('lptdesc', POINTER(tagTYPEDESC)),
    ('lpadesc', POINTER(tagARRAYDESC)),
    ('hreftype', c_ulong),
]

assert sizeof(__MIDL_IOleAutomationTypes_0005) == 8, sizeof(__MIDL_IOleAutomationTypes_0005)
assert alignment(__MIDL_IOleAutomationTypes_0005) == 8, alignment(__MIDL_IOleAutomationTypes_0005)

IEnumComponents._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'Next',
        (['in'], c_ulong, 'celt'),
        (['out'], POINTER(POINTER(IComponent)), 'rgelt'),
        (['out'], POINTER(c_ulong), 'pceltFetched')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Skip',
        (['in'], c_ulong, 'celt')
    ),
    COMMETHOD([], HRESULT, 'Reset'),
    COMMETHOD(
        [],
        HRESULT,
        'Clone',
        (['out'], POINTER(POINTER(IEnumComponents)), 'ppenum')
    ),
]

################################################################
# code template for IEnumComponents implementation
# class IEnumComponents_Impl(object):
#     def Next(self, celt):
#         '-no docstring-'
#         #return rgelt, pceltFetched
#
#     def Skip(self, celt):
#         '-no docstring-'
#         #return 
#
#     def Reset(self):
#         '-no docstring-'
#         #return 
#
#     def Clone(self):
#         '-no docstring-'
#         #return ppenum
#

IComponent._methods_ = [
    COMMETHOD(
        [dispid(1), helpstring('Component Type'), 'propget'],
        HRESULT,
        'type',
        (['out', 'retval'], POINTER(POINTER(IComponentType)), 'CT')
    ),
    COMMETHOD(
        [dispid(1), helpstring('Component Type'), 'restricted', 'hidden', 'propput'],
        HRESULT,
        'type',
        (['in'], POINTER(IComponentType), 'CT')
    ),
    COMMETHOD(
        [dispid(3), helpstring('Language Identifier for Description Language'), 'propget'],
        HRESULT,
        'DescLangID',
        (['out', 'retval'], POINTER(c_int), 'LangID')
    ),
    COMMETHOD(
        [dispid(3), helpstring('Language Identifier for Description Language'), 'propput'],
        HRESULT,
        'DescLangID',
        (['in'], c_int, 'LangID')
    ),
    COMMETHOD(
        [dispid(2), helpstring('Component Status'), 'propget'],
        HRESULT,
        'Status',
        (['out', 'retval'], POINTER(ComponentStatus), 'Status')
    ),
    COMMETHOD(
        [dispid(2), helpstring('Component Status'), 'propput'],
        HRESULT,
        'Status',
        (['in'], ComponentStatus, 'Status')
    ),
    COMMETHOD(
        [dispid(4), helpstring('Component Description'), 'propget'],
        HRESULT,
        'Description',
        (['out', 'retval'], POINTER(BSTR), 'Description')
    ),
    COMMETHOD(
        [dispid(4), helpstring('Component Description'), 'restricted', 'hidden', 'propput'],
        HRESULT,
        'Description',
        (['in'], BSTR, 'Description')
    ),
    COMMETHOD(
        [dispid(5), helpstring('Copy Component')],
        HRESULT,
        'Clone',
        (['out', 'retval'], POINTER(POINTER(IComponent)), 'NewComponent')
    ),
]

################################################################
# code template for IComponent implementation
# class IComponent_Impl(object):
#     def _get(self):
#         'Component Type'
#         #return CT
#     def _set(self, CT):
#         'Component Type'
#     type = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Language Identifier for Description Language'
#         #return LangID
#     def _set(self, LangID):
#         'Language Identifier for Description Language'
#     DescLangID = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Component Status'
#         #return Status
#     def _set(self, Status):
#         'Component Status'
#     Status = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Component Description'
#         #return Description
#     def _set(self, Description):
#         'Component Description'
#     Description = property(_get, _set, doc = _set.__doc__)
#
#     def Clone(self):
#         'Copy Component'
#         #return NewComponent
#


class IMSVidFeatureEvent(IMSVidDeviceEvent):
    """MS Video Control Feature Event Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{3DD2903C-E0AA-11D2-B63A-00C04F79498E}')
    _idlflags_ = ['oleautomation']


IMSVidFeatureEvent._methods_ = [
]

################################################################
# code template for IMSVidFeatureEvent implementation
# class IMSVidFeatureEvent_Impl(object):

IMFAttributes._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'GetItem',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        (['in', 'out'], POINTER(tag_inner_PROPVARIANT), 'pValue')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetItemType',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        (['out'], POINTER(_MF_ATTRIBUTE_TYPE), 'pType')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'CompareItem',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        ([], POINTER(tag_inner_PROPVARIANT), 'Value'),
        (['out'], POINTER(c_int), 'pbResult')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Compare',
        ([], POINTER(IMFAttributes), 'pTheirs'),
        ([], _MF_ATTRIBUTES_MATCH_TYPE, 'MatchType'),
        (['out'], POINTER(c_int), 'pbResult')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetUINT32',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        (['out'], POINTER(c_uint), 'punValue')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetUINT64',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        (['out'], POINTER(c_ulonglong), 'punValue')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetDouble',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        (['out'], POINTER(c_double), 'pfValue')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetGuid',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        (
            ['out'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'pguidValue',
        )
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetStringLength',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        (['out'], POINTER(c_uint), 'pcchLength')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetString',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        (['out'], WSTRING, 'pwszValue'),
        ([], c_uint, 'cchBufSize'),
        (['in', 'out'], POINTER(c_uint), 'pcchLength')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetAllocatedString',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        (['out'], POINTER(WSTRING), 'ppwszValue'),
        (['out'], POINTER(c_uint), 'pcchLength')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetBlobSize',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        (['out'], POINTER(c_uint), 'pcbBlobSize')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetBlob',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        (['out'], POINTER(c_ubyte), 'pBuf'),
        ([], c_uint, 'cbBufSize'),
        (['in', 'out'], POINTER(c_uint), 'pcbBlobSize')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetAllocatedBlob',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        (['out'], POINTER(POINTER(c_ubyte)), 'ppBuf'),
        (['out'], POINTER(c_uint), 'pcbSize')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetUnknown',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'riid',
        ),
        (['out'], POINTER(c_void_p), 'ppv')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'SetItem',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        ([], POINTER(tag_inner_PROPVARIANT), 'Value')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'DeleteItem',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        )
    ),
    COMMETHOD([], HRESULT, 'DeleteAllItems'),
    COMMETHOD(
        [],
        HRESULT,
        'SetUINT32',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        ([], c_uint, 'unValue')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'SetUINT64',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        ([], c_ulonglong, 'unValue')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'SetDouble',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        ([], c_double, 'fValue')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'SetGUID',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidValue',
        )
    ),
    COMMETHOD(
        [],
        HRESULT,
        'SetString',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        (['in'], WSTRING, 'wszValue')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'SetBlob',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        (['in'], POINTER(c_ubyte), 'pBuf'),
        ([], c_uint, 'cbBufSize')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'SetUnknown',
        (
            [],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'guidKey',
        ),
        (['in'], POINTER(IUnknown), 'pUnknown')
    ),
    COMMETHOD([], HRESULT, 'LockStore'),
    COMMETHOD([], HRESULT, 'UnlockStore'),
    COMMETHOD(
        [],
        HRESULT,
        'GetCount',
        (['out'], POINTER(c_uint), 'pcItems')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetItemByIndex',
        ([], c_uint, 'unIndex'),
        (
            ['out'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'pguidKey',
        ),
        (['in', 'out'], POINTER(tag_inner_PROPVARIANT), 'pValue')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'CopyAllItems',
        (['in'], POINTER(IMFAttributes), 'pDest')
    ),
]

################################################################
# code template for IMFAttributes implementation
# class IMFAttributes_Impl(object):
#     def GetItem(self, guidKey):
#         '-no docstring-'
#         #return pValue
#
#     def GetItemType(self, guidKey):
#         '-no docstring-'
#         #return pType
#
#     def CompareItem(self, guidKey, Value):
#         '-no docstring-'
#         #return pbResult
#
#     def Compare(self, pTheirs, MatchType):
#         '-no docstring-'
#         #return pbResult
#
#     def GetUINT32(self, guidKey):
#         '-no docstring-'
#         #return punValue
#
#     def GetUINT64(self, guidKey):
#         '-no docstring-'
#         #return punValue
#
#     def GetDouble(self, guidKey):
#         '-no docstring-'
#         #return pfValue
#
#     def GetGuid(self, guidKey):
#         '-no docstring-'
#         #return pguidValue
#
#     def GetStringLength(self, guidKey):
#         '-no docstring-'
#         #return pcchLength
#
#     def GetString(self, guidKey, cchBufSize):
#         '-no docstring-'
#         #return pwszValue, pcchLength
#
#     def GetAllocatedString(self, guidKey):
#         '-no docstring-'
#         #return ppwszValue, pcchLength
#
#     def GetBlobSize(self, guidKey):
#         '-no docstring-'
#         #return pcbBlobSize
#
#     def GetBlob(self, guidKey, cbBufSize):
#         '-no docstring-'
#         #return pBuf, pcbBlobSize
#
#     def GetAllocatedBlob(self, guidKey):
#         '-no docstring-'
#         #return ppBuf, pcbSize
#
#     def GetUnknown(self, guidKey, riid):
#         '-no docstring-'
#         #return ppv
#
#     def SetItem(self, guidKey, Value):
#         '-no docstring-'
#         #return 
#
#     def DeleteItem(self, guidKey):
#         '-no docstring-'
#         #return 
#
#     def DeleteAllItems(self):
#         '-no docstring-'
#         #return 
#
#     def SetUINT32(self, guidKey, unValue):
#         '-no docstring-'
#         #return 
#
#     def SetUINT64(self, guidKey, unValue):
#         '-no docstring-'
#         #return 
#
#     def SetDouble(self, guidKey, fValue):
#         '-no docstring-'
#         #return 
#
#     def SetGUID(self, guidKey, guidValue):
#         '-no docstring-'
#         #return 
#
#     def SetString(self, guidKey, wszValue):
#         '-no docstring-'
#         #return 
#
#     def SetBlob(self, guidKey, pBuf, cbBufSize):
#         '-no docstring-'
#         #return 
#
#     def SetUnknown(self, guidKey, pUnknown):
#         '-no docstring-'
#         #return 
#
#     def LockStore(self):
#         '-no docstring-'
#         #return 
#
#     def UnlockStore(self):
#         '-no docstring-'
#         #return 
#
#     def GetCount(self):
#         '-no docstring-'
#         #return pcItems
#
#     def GetItemByIndex(self, unIndex):
#         '-no docstring-'
#         #return pguidKey, pValue
#
#     def CopyAllItems(self, pDest):
#         '-no docstring-'
#         #return 
#

IMFMediaType._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'GetMajorType',
        (
            ['out'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'pguidMajorType',
        )
    ),
    COMMETHOD(
        [],
        HRESULT,
        'IsCompressedFormat',
        (['out'], POINTER(c_int), 'pfCompressed')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'IsEqual',
        (['in'], POINTER(IMFMediaType), 'pIMediaType'),
        (['out'], POINTER(c_ulong), 'pdwFlags')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetRepresentation',
        (
            ['in'],
            comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID,
            'guidRepresentation',
        ),
        (['out'], POINTER(c_void_p), 'ppvRepresentation')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'FreeRepresentation',
        (
            ['in'],
            comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID,
            'guidRepresentation',
        ),
        (['in'], c_void_p, 'pvRepresentation')
    ),
]

################################################################
# code template for IMFMediaType implementation
# class IMFMediaType_Impl(object):
#     def GetMajorType(self):
#         '-no docstring-'
#         #return pguidMajorType
#
#     def IsCompressedFormat(self):
#         '-no docstring-'
#         #return pfCompressed
#
#     def IsEqual(self, pIMediaType):
#         '-no docstring-'
#         #return pdwFlags
#
#     def GetRepresentation(self, guidRepresentation):
#         '-no docstring-'
#         #return ppvRepresentation
#
#     def FreeRepresentation(self, guidRepresentation, pvRepresentation):
#         '-no docstring-'
#         #return 
#

IMFVideoMediaType._methods_ = [
    COMMETHOD([], POINTER(_MFVIDEOFORMAT), 'GetVideoFormat'),
    COMMETHOD(
        [],
        HRESULT,
        'GetVideoRepresentation',
        (
            ['in'],
            comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID,
            'guidRepresentation',
        ),
        (['out'], POINTER(c_void_p), 'ppvRepresentation'),
        (['in'], c_int, 'lStride')
    ),
]

################################################################
# code template for IMFVideoMediaType implementation
# class IMFVideoMediaType_Impl(object):
#     def GetVideoFormat(self):
#         '-no docstring-'
#         #return 
#
#     def GetVideoRepresentation(self, guidRepresentation, lStride):
#         '-no docstring-'
#         #return ppvRepresentation
#


class IMSVidFeatures(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """MS Video Control Features Writable Collection Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{C5702CD5-9B79-11D3-B654-00C04F79498E}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_Count(self) -> hints.Incomplete: ...
        Count = hints.normal_property(_get_Count)
        __len__ = hints.to_dunder_len(Count)
        def _get__NewEnum(self) -> hints.Incomplete: ...
        _NewEnum = hints.normal_property(_get__NewEnum)
        __iter__ = hints.to_dunder_iter(_NewEnum)
        def _get_Item(self, v: hints.Incomplete) -> 'IMSVidFeature': ...
        Item = hints.named_property('Item', _get_Item)
        __call__ = hints.to_dunder_call(Item)
        __getitem__ = hints.to_dunder_getitem(Item)
        __setitem__ = hints.to_dunder_setitem(Item)
        def Add(self, pDB: hints.Incomplete) -> hints.Hresult: ...
        def Remove(self, v: hints.Incomplete) -> hints.Hresult: ...


class IMSVidFeature(IMSVidDevice):
    """MS Video Control Feature Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{37B03547-A4C8-11D2-B634-00C04F79498E}')
    _idlflags_ = ['dual', 'oleautomation', 'proxy']


IMSVidFeatures._methods_ = [
    COMMETHOD(
        [dispid(16), 'propget'],
        HRESULT,
        'Count',
        (['out', 'retval'], POINTER(c_int), 'lCount')
    ),
    COMMETHOD(
        [dispid(-4), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_NewEnum',
        (
            ['out', 'retval'],
            POINTER(POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IEnumVARIANT)),
            'pD',
        )
    ),
    COMMETHOD(
        [dispid(0), 'propget'],
        HRESULT,
        'Item',
        (['in'], VARIANT, 'v'),
        (['out', 'retval'], POINTER(POINTER(IMSVidFeature)), 'pDB')
    ),
    COMMETHOD(
        [dispid(-553)],
        HRESULT,
        'Add',
        (['in'], POINTER(IMSVidFeature), 'pDB')
    ),
    COMMETHOD(
        [dispid(-555)],
        HRESULT,
        'Remove',
        (['in'], VARIANT, 'v')
    ),
]

################################################################
# code template for IMSVidFeatures implementation
# class IMSVidFeatures_Impl(object):
#     @property
#     def Count(self):
#         '-no docstring-'
#         #return lCount
#
#     @property
#     def _NewEnum(self):
#         '-no docstring-'
#         #return pD
#
#     @property
#     def Item(self, v):
#         '-no docstring-'
#         #return pDB
#
#     def Add(self, pDB):
#         '-no docstring-'
#         #return 
#
#     def Remove(self, v):
#         '-no docstring-'
#         #return 
#


class IMSVidCompositionSegment(IMSVidGraphSegment):
    """DShow Graph Segment Composition Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{1C15D483-911D-11D2-B632-00C04F79498E}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def Compose(self, upstream: hints.Incomplete, downstream: hints.Incomplete) -> hints.Hresult: ...
        def _get_Up(self) -> 'IMSVidGraphSegment': ...
        Up = hints.normal_property(_get_Up)
        def _get_Down(self) -> 'IMSVidGraphSegment': ...
        Down = hints.normal_property(_get_Down)


IMSVidCompositionSegment._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'Compose',
        (['in'], POINTER(IMSVidGraphSegment), 'upstream'),
        (['in'], POINTER(IMSVidGraphSegment), 'downstream')
    ),
    COMMETHOD(
        ['propget', helpstring('The upstream segment being composed by this composition segment')],
        HRESULT,
        'Up',
        (['out'], POINTER(POINTER(IMSVidGraphSegment)), 'upstream')
    ),
    COMMETHOD(
        ['propget', helpstring('The downstream segment being composed by this composition segment')],
        HRESULT,
        'Down',
        (['out'], POINTER(POINTER(IMSVidGraphSegment)), 'downstream')
    ),
]

################################################################
# code template for IMSVidCompositionSegment implementation
# class IMSVidCompositionSegment_Impl(object):
#     def Compose(self, upstream, downstream):
#         '-no docstring-'
#         #return 
#
#     @property
#     def Up(self):
#         'The upstream segment being composed by this composition segment'
#         #return upstream
#
#     @property
#     def Down(self):
#         'The downstream segment being composed by this composition segment'
#         #return downstream
#


class MSVidDataServicesToStreamBufferSink(CoClass):
    """MS Video Control Custom Composition for Data Services to Stream Buffer Sink"""
    _reg_clsid_ = GUID('{38F03426-E83B-4E68-B65B-DCAE73304838}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidDataServicesToStreamBufferSink._com_interfaces_ = [IMSVidCompositionSegment]


class MSVidDataServicesToXDS(CoClass):
    """MS Video Control Custom Composition for DataServices To XDS"""
    _reg_clsid_ = GUID('{0429EC6E-1144-4BED-B88B-2FB9899A4A3D}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidDataServicesToXDS._com_interfaces_ = [IMSVidCompositionSegment]

tag_inner_PROPVARIANT._fields_ = [
    ('vt', c_ushort),
    ('wReserved1', c_ubyte),
    ('wReserved2', c_ubyte),
    ('wReserved3', c_ulong),
    ('__MIDL____MIDL_itf_msvidctl_0003_02630001', __MIDL___MIDL_itf_msvidctl_0003_0263_0001),
]

assert sizeof(tag_inner_PROPVARIANT) == 24, sizeof(tag_inner_PROPVARIANT)
assert alignment(tag_inner_PROPVARIANT) == 8, alignment(tag_inner_PROPVARIANT)


class MSVidAnalogCaptureToXDS(CoClass):
    """MS Video Control Custom Composition for TV Tuner to XDS"""
    _reg_clsid_ = GUID('{3540D440-5B1D-49CB-821A-E84B8CF065A7}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidAnalogCaptureToXDS._com_interfaces_ = [IMSVidCompositionSegment]


class MSVidCtl(CoClass):
    """MS Video Control Class"""
    _reg_clsid_ = GUID('{B0EDF163-910A-11D2-B632-00C04F79498E}')
    _idlflags_ = ['control']
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


class IMSVidCtl(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """MS Video Control Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{B0EDF162-910A-11D2-B632-00C04F79498E}')
    _idlflags_ = ['hidden', 'dual', 'nonextensible', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_AutoSize(self) -> hints.Incomplete: ...
        def _set_AutoSize(self, pbool: hints.Incomplete) -> hints.Hresult: ...
        AutoSize = hints.normal_property(_get_AutoSize, _set_AutoSize)
        def _get_BackColor(self) -> hints.Incomplete: ...
        def _set_BackColor(self, BackColor: hints.Incomplete) -> hints.Hresult: ...
        BackColor = hints.normal_property(_get_BackColor, _set_BackColor)
        def _get_Enabled(self) -> hints.Incomplete: ...
        def _set_Enabled(self, pbool: hints.Incomplete) -> hints.Hresult: ...
        Enabled = hints.normal_property(_get_Enabled, _set_Enabled)
        def _get_TabStop(self) -> hints.Incomplete: ...
        def _set_TabStop(self, pbool: hints.Incomplete) -> hints.Hresult: ...
        TabStop = hints.normal_property(_get_TabStop, _set_TabStop)
        def _get_Window(self) -> hints.Incomplete: ...
        Window = hints.normal_property(_get_Window)
        def Refresh(self) -> hints.Hresult: ...
        def _get_DisplaySize(self) -> hints.Incomplete: ...
        def _set_DisplaySize(self, CurrentValue: hints.Incomplete) -> hints.Hresult: ...
        DisplaySize = hints.normal_property(_get_DisplaySize, _set_DisplaySize)
        def _get_MaintainAspectRatio(self) -> hints.Incomplete: ...
        def _set_MaintainAspectRatio(self, CurrentValue: hints.Incomplete) -> hints.Hresult: ...
        MaintainAspectRatio = hints.normal_property(_get_MaintainAspectRatio, _set_MaintainAspectRatio)
        def _get_ColorKey(self) -> hints.Incomplete: ...
        def _set_ColorKey(self, CurrentValue: hints.Incomplete) -> hints.Hresult: ...
        ColorKey = hints.normal_property(_get_ColorKey, _set_ColorKey)
        def _get_InputsAvailable(self, CategoryGuid: hints.Incomplete) -> 'IMSVidInputDevices': ...
        InputsAvailable = hints.named_property('InputsAvailable', _get_InputsAvailable)
        def _get_OutputsAvailable(self, CategoryGuid: hints.Incomplete) -> 'IMSVidOutputDevices': ...
        OutputsAvailable = hints.named_property('OutputsAvailable', _get_OutputsAvailable)
        def _get__InputsAvailable(self, CategoryGuid: hints.Incomplete) -> 'IMSVidInputDevices': ...
        _InputsAvailable = hints.named_property('_InputsAvailable', _get__InputsAvailable)
        def _get__OutputsAvailable(self, CategoryGuid: hints.Incomplete) -> 'IMSVidOutputDevices': ...
        _OutputsAvailable = hints.named_property('_OutputsAvailable', _get__OutputsAvailable)
        def _get_VideoRenderersAvailable(self) -> 'IMSVidVideoRendererDevices': ...
        VideoRenderersAvailable = hints.normal_property(_get_VideoRenderersAvailable)
        def _get_AudioRenderersAvailable(self) -> 'IMSVidAudioRendererDevices': ...
        AudioRenderersAvailable = hints.normal_property(_get_AudioRenderersAvailable)
        def _get_FeaturesAvailable(self) -> 'IMSVidFeatures': ...
        FeaturesAvailable = hints.normal_property(_get_FeaturesAvailable)
        def _get_InputActive(self) -> 'IMSVidInputDevice': ...
        def _set_InputActive(self, pVal: hints.Incomplete) -> hints.Hresult: ...
        InputActive = hints.normal_property(_get_InputActive, _set_InputActive)
        def _get_OutputsActive(self) -> 'IMSVidOutputDevices': ...
        def _set_OutputsActive(self, pVal: hints.Incomplete) -> hints.Hresult: ...
        OutputsActive = hints.normal_property(_get_OutputsActive, _set_OutputsActive)
        def _get_VideoRendererActive(self) -> 'IMSVidVideoRenderer': ...
        def _set_VideoRendererActive(self, pVal: hints.Incomplete) -> hints.Hresult: ...
        VideoRendererActive = hints.normal_property(_get_VideoRendererActive, _set_VideoRendererActive)
        def _get_AudioRendererActive(self) -> 'IMSVidAudioRenderer': ...
        def _set_AudioRendererActive(self, pVal: hints.Incomplete) -> hints.Hresult: ...
        AudioRendererActive = hints.normal_property(_get_AudioRendererActive, _set_AudioRendererActive)
        def _get_FeaturesActive(self) -> 'IMSVidFeatures': ...
        def _set_FeaturesActive(self, pVal: hints.Incomplete) -> hints.Hresult: ...
        FeaturesActive = hints.normal_property(_get_FeaturesActive, _set_FeaturesActive)
        def _get_State(self) -> hints.Incomplete: ...
        State = hints.normal_property(_get_State)
        def View(self, v: hints.Incomplete) -> hints.Hresult: ...
        def Build(self) -> hints.Hresult: ...
        def Pause(self) -> hints.Hresult: ...
        def Run(self) -> hints.Hresult: ...
        def Stop(self) -> hints.Hresult: ...
        def Decompose(self) -> hints.Hresult: ...
        def DisableVideo(self) -> hints.Hresult: ...
        def DisableAudio(self) -> hints.Hresult: ...
        def ViewNext(self, v: hints.Incomplete) -> hints.Hresult: ...


MSVidCtl._com_interfaces_ = [IMSVidCtl, IMSVidGraphSegmentContainer]
MSVidCtl._outgoing_interfaces_ = [_IMSVidCtlEvents]

IMSVidCtl._methods_ = [
    COMMETHOD(
        [dispid(-500), 'propget'],
        HRESULT,
        'AutoSize',
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'pbool')
    ),
    COMMETHOD(
        [dispid(-500), 'propput'],
        HRESULT,
        'AutoSize',
        (['in'], VARIANT_BOOL, 'pbool')
    ),
    COMMETHOD(
        [dispid(-501), 'propget'],
        HRESULT,
        'BackColor',
        (
            ['out', 'retval'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.OLE_COLOR),
            'BackColor',
        )
    ),
    COMMETHOD(
        [dispid(-501), 'propput'],
        HRESULT,
        'BackColor',
        (
            ['in'],
            comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.OLE_COLOR,
            'BackColor',
        )
    ),
    COMMETHOD(
        [dispid(-514), 'propget'],
        HRESULT,
        'Enabled',
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'pbool')
    ),
    COMMETHOD(
        [dispid(-514), 'propput'],
        HRESULT,
        'Enabled',
        (['in'], VARIANT_BOOL, 'pbool')
    ),
    COMMETHOD(
        [dispid(-516), 'propget'],
        HRESULT,
        'TabStop',
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'pbool')
    ),
    COMMETHOD(
        [dispid(-516), 'propput'],
        HRESULT,
        'TabStop',
        (['in'], VARIANT_BOOL, 'pbool')
    ),
    COMMETHOD(
        [dispid(-515), 'propget'],
        HRESULT,
        'Window',
        (['out', 'retval'], POINTER(wireHWND), 'phwnd')
    ),
    COMMETHOD([dispid(-550)], HRESULT, 'Refresh'),
    COMMETHOD(
        [dispid(18), 'propget'],
        HRESULT,
        'DisplaySize',
        (['out', 'retval'], POINTER(DisplaySizeList), 'CurrentValue')
    ),
    COMMETHOD(
        [dispid(18), 'propput'],
        HRESULT,
        'DisplaySize',
        (['in'], DisplaySizeList, 'CurrentValue')
    ),
    COMMETHOD(
        [dispid(19), 'propget'],
        HRESULT,
        'MaintainAspectRatio',
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'CurrentValue')
    ),
    COMMETHOD(
        [dispid(19), 'propput'],
        HRESULT,
        'MaintainAspectRatio',
        (['in'], VARIANT_BOOL, 'CurrentValue')
    ),
    COMMETHOD(
        [dispid(20), 'propget'],
        HRESULT,
        'ColorKey',
        (
            ['out', 'retval'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.OLE_COLOR),
            'CurrentValue',
        )
    ),
    COMMETHOD(
        [dispid(20), 'propput'],
        HRESULT,
        'ColorKey',
        (
            ['in'],
            comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.OLE_COLOR,
            'CurrentValue',
        )
    ),
    COMMETHOD(
        [dispid(0), helpstring('Available Input Devices'), 'propget'],
        HRESULT,
        'InputsAvailable',
        (['in'], BSTR, 'CategoryGuid'),
        (['out', 'retval'], POINTER(POINTER(IMSVidInputDevices)), 'pVal')
    ),
    COMMETHOD(
        [dispid(1), helpstring('Available Output Devices'), 'propget'],
        HRESULT,
        'OutputsAvailable',
        (['in'], BSTR, 'CategoryGuid'),
        (['out', 'retval'], POINTER(POINTER(IMSVidOutputDevices)), 'pVal')
    ),
    COMMETHOD(
        [dispid(2), helpstring('Available Input Devices'), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_InputsAvailable',
        (
            ['in'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'CategoryGuid',
        ),
        (['out', 'retval'], POINTER(POINTER(IMSVidInputDevices)), 'pVal')
    ),
    COMMETHOD(
        [dispid(3), helpstring('Available Output Devices'), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_OutputsAvailable',
        (
            ['in'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'CategoryGuid',
        ),
        (['out', 'retval'], POINTER(POINTER(IMSVidOutputDevices)), 'pVal')
    ),
    COMMETHOD(
        [dispid(4), helpstring('Available Video Renderers'), 'propget'],
        HRESULT,
        'VideoRenderersAvailable',
        (
            ['out', 'retval'],
            POINTER(POINTER(IMSVidVideoRendererDevices)),
            'pVal',
        )
    ),
    COMMETHOD(
        [dispid(5), helpstring('Available Audio Renderers'), 'propget'],
        HRESULT,
        'AudioRenderersAvailable',
        (
            ['out', 'retval'],
            POINTER(POINTER(IMSVidAudioRendererDevices)),
            'pVal',
        )
    ),
    COMMETHOD(
        [dispid(6), helpstring('Available Features'), 'propget'],
        HRESULT,
        'FeaturesAvailable',
        (['out', 'retval'], POINTER(POINTER(IMSVidFeatures)), 'pVal')
    ),
    COMMETHOD(
        [dispid(7), helpstring('Currently Selected Input Device'), 'propget'],
        HRESULT,
        'InputActive',
        (['out', 'retval'], POINTER(POINTER(IMSVidInputDevice)), 'pVal')
    ),
    COMMETHOD(
        [dispid(7), helpstring('Currently Selected Input Device'), 'propput'],
        HRESULT,
        'InputActive',
        (['in'], POINTER(IMSVidInputDevice), 'pVal')
    ),
    COMMETHOD(
        [dispid(8), helpstring('Currently Selected Output Devices'), 'propget'],
        HRESULT,
        'OutputsActive',
        (['out', 'retval'], POINTER(POINTER(IMSVidOutputDevices)), 'pVal')
    ),
    COMMETHOD(
        [dispid(8), helpstring('Currently Selected Output Devices'), 'propput'],
        HRESULT,
        'OutputsActive',
        (['in'], POINTER(IMSVidOutputDevices), 'pVal')
    ),
    COMMETHOD(
        [dispid(9), helpstring('Currently Selected Video Renderer'), 'propget'],
        HRESULT,
        'VideoRendererActive',
        (['out', 'retval'], POINTER(POINTER(IMSVidVideoRenderer)), 'pVal')
    ),
    COMMETHOD(
        [dispid(9), helpstring('Currently Selected Video Renderer'), 'propput'],
        HRESULT,
        'VideoRendererActive',
        (['in'], POINTER(IMSVidVideoRenderer), 'pVal')
    ),
    COMMETHOD(
        [dispid(10), helpstring('Currently Selected Audio Renderer'), 'propget'],
        HRESULT,
        'AudioRendererActive',
        (['out', 'retval'], POINTER(POINTER(IMSVidAudioRenderer)), 'pVal')
    ),
    COMMETHOD(
        [dispid(10), helpstring('Currently Selected Audio Renderer'), 'propput'],
        HRESULT,
        'AudioRendererActive',
        (['in'], POINTER(IMSVidAudioRenderer), 'pVal')
    ),
    COMMETHOD(
        [dispid(11), helpstring('Currently Selected Features'), 'propget'],
        HRESULT,
        'FeaturesActive',
        (['out', 'retval'], POINTER(POINTER(IMSVidFeatures)), 'pVal')
    ),
    COMMETHOD(
        [dispid(11), helpstring('Currently Selected Features'), 'propput'],
        HRESULT,
        'FeaturesActive',
        (['in'], POINTER(IMSVidFeatures), 'pVal')
    ),
    COMMETHOD(
        [dispid(22), helpstring('Check the current MSVidCtl state.'), 'propget'],
        HRESULT,
        'State',
        (['out', 'retval'], POINTER(MSVidCtlStateList), 'lState')
    ),
    COMMETHOD(
        [dispid(12), helpstring('Find an input device for viewing the specified item. This may be a string(VT_BSTR) or an object(VT_UNKNOWN).')],
        HRESULT,
        'View',
        (['in'], POINTER(VARIANT), 'v')
    ),
    COMMETHOD([dispid(13), helpstring('Compose the graph')], HRESULT, 'Build'),
    COMMETHOD([dispid(14), helpstring('Stop the graph')], HRESULT, 'Pause'),
    COMMETHOD(
        [dispid(15), helpstring('Compose the graph if necessary and start it running')],
        HRESULT,
        'Run',
    ),
    COMMETHOD([dispid(16), helpstring('Stop the graph')], HRESULT, 'Stop'),
    COMMETHOD(
        [dispid(17), helpstring('Disassemble the graph(Inverse of Build)')],
        HRESULT,
        'Decompose',
    ),
    COMMETHOD(
        [dispid(25), helpstring('set active video renderer to nothing')],
        HRESULT,
        'DisableVideo',
    ),
    COMMETHOD(
        [dispid(26), helpstring('set active Audio renderer to nothing')],
        HRESULT,
        'DisableAudio',
    ),
    COMMETHOD(
        [dispid(27), helpstring('Find another input device for viewing the specified item. Works like View except skips current input')],
        HRESULT,
        'ViewNext',
        (['in'], POINTER(VARIANT), 'v')
    ),
]

################################################################
# code template for IMSVidCtl implementation
# class IMSVidCtl_Impl(object):
#     def _get(self):
#         '-no docstring-'
#         #return pbool
#     def _set(self, pbool):
#         '-no docstring-'
#     AutoSize = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         '-no docstring-'
#         #return BackColor
#     def _set(self, BackColor):
#         '-no docstring-'
#     BackColor = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         '-no docstring-'
#         #return pbool
#     def _set(self, pbool):
#         '-no docstring-'
#     Enabled = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         '-no docstring-'
#         #return pbool
#     def _set(self, pbool):
#         '-no docstring-'
#     TabStop = property(_get, _set, doc = _set.__doc__)
#
#     @property
#     def Window(self):
#         '-no docstring-'
#         #return phwnd
#
#     def Refresh(self):
#         '-no docstring-'
#         #return 
#
#     def _get(self):
#         '-no docstring-'
#         #return CurrentValue
#     def _set(self, CurrentValue):
#         '-no docstring-'
#     DisplaySize = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         '-no docstring-'
#         #return CurrentValue
#     def _set(self, CurrentValue):
#         '-no docstring-'
#     MaintainAspectRatio = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         '-no docstring-'
#         #return CurrentValue
#     def _set(self, CurrentValue):
#         '-no docstring-'
#     ColorKey = property(_get, _set, doc = _set.__doc__)
#
#     @property
#     def InputsAvailable(self, CategoryGuid):
#         'Available Input Devices'
#         #return pVal
#
#     @property
#     def OutputsAvailable(self, CategoryGuid):
#         'Available Output Devices'
#         #return pVal
#
#     @property
#     def _InputsAvailable(self, CategoryGuid):
#         'Available Input Devices'
#         #return pVal
#
#     @property
#     def _OutputsAvailable(self, CategoryGuid):
#         'Available Output Devices'
#         #return pVal
#
#     @property
#     def VideoRenderersAvailable(self):
#         'Available Video Renderers'
#         #return pVal
#
#     @property
#     def AudioRenderersAvailable(self):
#         'Available Audio Renderers'
#         #return pVal
#
#     @property
#     def FeaturesAvailable(self):
#         'Available Features'
#         #return pVal
#
#     def _get(self):
#         'Currently Selected Input Device'
#         #return pVal
#     def _set(self, pVal):
#         'Currently Selected Input Device'
#     InputActive = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Currently Selected Output Devices'
#         #return pVal
#     def _set(self, pVal):
#         'Currently Selected Output Devices'
#     OutputsActive = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Currently Selected Video Renderer'
#         #return pVal
#     def _set(self, pVal):
#         'Currently Selected Video Renderer'
#     VideoRendererActive = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Currently Selected Audio Renderer'
#         #return pVal
#     def _set(self, pVal):
#         'Currently Selected Audio Renderer'
#     AudioRendererActive = property(_get, _set, doc = _set.__doc__)
#
#     def _get(self):
#         'Currently Selected Features'
#         #return pVal
#     def _set(self, pVal):
#         'Currently Selected Features'
#     FeaturesActive = property(_get, _set, doc = _set.__doc__)
#
#     @property
#     def State(self):
#         'Check the current MSVidCtl state.'
#         #return lState
#
#     def View(self, v):
#         'Find an input device for viewing the specified item. This may be a string(VT_BSTR) or an object(VT_UNKNOWN).'
#         #return 
#
#     def Build(self):
#         'Compose the graph'
#         #return 
#
#     def Pause(self):
#         'Stop the graph'
#         #return 
#
#     def Run(self):
#         'Compose the graph if necessary and start it running'
#         #return 
#
#     def Stop(self):
#         'Stop the graph'
#         #return 
#
#     def Decompose(self):
#         'Disassemble the graph(Inverse of Build)'
#         #return 
#
#     def DisableVideo(self):
#         'set active video renderer to nothing'
#         #return 
#
#     def DisableAudio(self):
#         'set active Audio renderer to nothing'
#         #return 
#
#     def ViewNext(self, v):
#         'Find another input device for viewing the specified item. Works like View except skips current input'
#         #return 
#


class MSVidInputDevices(CoClass):
    """MS Video Control Input Device Collection Class"""
    _reg_clsid_ = GUID('{C5702CCC-9B79-11D3-B654-00C04F79498E}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidInputDevices._com_interfaces_ = [IMSVidInputDevices]

IMSVidStreamBufferSourceEvent2._methods_ = [
    COMMETHOD(
        [helpstring('Rate has changed')],
        HRESULT,
        'RateChange',
        (['in'], c_double, 'qwNewRate'),
        (['in'], c_double, 'qwOldRate')
    ),
]

################################################################
# code template for IMSVidStreamBufferSourceEvent2 implementation
# class IMSVidStreamBufferSourceEvent2_Impl(object):
#     def RateChange(self, qwNewRate, qwOldRate):
#         'Rate has changed'
#         #return 
#


class MSVidStreamBufferV2Source(CoClass):
    """MS Video Control Stream Buffer Engine V2 Playback Device Class"""
    _reg_clsid_ = GUID('{FD351EA1-4173-4AF4-821D-80D4AE979048}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


class IMSVidStreamBufferV2SourceEvent(IMSVidFilePlaybackEvent):
    """MS Video Control Stream Buffer V2 Source Device Event Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{49C771F9-41B2-4CF7-9F9A-A313A8F6027E}')
    _idlflags_ = ['hidden', 'oleautomation']

    if TYPE_CHECKING:  # commembers
        def RatingsChanged(self) -> hints.Hresult: ...
        def TimeHole(self, StreamOffsetMS: hints.Incomplete, SizeMS: hints.Incomplete) -> hints.Hresult: ...
        def StaleDataRead(self) -> hints.Hresult: ...
        def ContentBecomingStale(self) -> hints.Hresult: ...
        def StaleFileDeleted(self) -> hints.Hresult: ...
        def RateChange(self, qwNewRate: hints.Incomplete, qwOldRate: hints.Incomplete) -> hints.Hresult: ...
        def BroadcastEvent(self, Guid: hints.Incomplete) -> hints.Hresult: ...
        def BroadcastEventEx(self, Guid: hints.Incomplete, Param1: hints.Incomplete, Param2: hints.Incomplete, Param3: hints.Incomplete, Param4: hints.Incomplete) -> hints.Hresult: ...
        def ContentPrimarilyAudio(self) -> hints.Hresult: ...


MSVidStreamBufferV2Source._com_interfaces_ = [IMSVidStreamBufferSource2, IMSVidStreamBufferSource, IMSVidGraphSegment]
MSVidStreamBufferV2Source._outgoing_interfaces_ = [IMSVidStreamBufferV2SourceEvent]


class MSVidEncoder(CoClass):
    """MS Video Control Encoder"""
    _reg_clsid_ = GUID('{BB530C63-D9DF-4B49-9439-63453962E598}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


class IMSVidEncoder(IMSVidFeature):
    """MS Video Control Encoder Feature Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{C0020FD4-BEE7-43D9-A495-9F213117103D}')
    _idlflags_ = ['dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_VideoEncoderInterface(self) -> hints.Incomplete: ...
        VideoEncoderInterface = hints.normal_property(_get_VideoEncoderInterface)
        def _get_AudioEncoderInterface(self) -> hints.Incomplete: ...
        AudioEncoderInterface = hints.normal_property(_get_AudioEncoderInterface)


MSVidEncoder._com_interfaces_ = [IMSVidEncoder]

IMSVidStreamBufferV2SourceEvent._methods_ = [
    COMMETHOD([helpstring('Ratings Changed')], HRESULT, 'RatingsChanged'),
    COMMETHOD(
        [helpstring('Source Time Hole')],
        HRESULT,
        'TimeHole',
        (['in'], c_int, 'StreamOffsetMS'),
        (['in'], c_int, 'SizeMS')
    ),
    COMMETHOD([helpstring('Source Stale Data Read')], HRESULT, 'StaleDataRead'),
    COMMETHOD(
        [helpstring('Source Content Becoming Stale')],
        HRESULT,
        'ContentBecomingStale',
    ),
    COMMETHOD(
        [helpstring('Source Stale File Deleted')],
        HRESULT,
        'StaleFileDeleted',
    ),
    COMMETHOD(
        [helpstring('Rate has changed')],
        HRESULT,
        'RateChange',
        (['in'], c_double, 'qwNewRate'),
        (['in'], c_double, 'qwOldRate')
    ),
    COMMETHOD(
        [helpstring('Broadcast Event Generic')],
        HRESULT,
        'BroadcastEvent',
        (['in'], BSTR, 'Guid')
    ),
    COMMETHOD(
        [helpstring('Broadcast EventEx Generic')],
        HRESULT,
        'BroadcastEventEx',
        (['in'], BSTR, 'Guid'),
        (['in'], c_ulong, 'Param1'),
        (['in'], c_ulong, 'Param2'),
        (['in'], c_ulong, 'Param3'),
        (['in'], c_ulong, 'Param4')
    ),
    COMMETHOD(
        [helpstring('Source Content Primarily Audio')],
        HRESULT,
        'ContentPrimarilyAudio',
    ),
]

################################################################
# code template for IMSVidStreamBufferV2SourceEvent implementation
# class IMSVidStreamBufferV2SourceEvent_Impl(object):
#     def RatingsChanged(self):
#         'Ratings Changed'
#         #return 
#
#     def TimeHole(self, StreamOffsetMS, SizeMS):
#         'Source Time Hole'
#         #return 
#
#     def StaleDataRead(self):
#         'Source Stale Data Read'
#         #return 
#
#     def ContentBecomingStale(self):
#         'Source Content Becoming Stale'
#         #return 
#
#     def StaleFileDeleted(self):
#         'Source Stale File Deleted'
#         #return 
#
#     def RateChange(self, qwNewRate, qwOldRate):
#         'Rate has changed'
#         #return 
#
#     def BroadcastEvent(self, Guid):
#         'Broadcast Event Generic'
#         #return 
#
#     def BroadcastEventEx(self, Guid, Param1, Param2, Param3, Param4):
#         'Broadcast EventEx Generic'
#         #return 
#
#     def ContentPrimarilyAudio(self):
#         'Source Content Primarily Audio'
#         #return 
#


class MSVidITVCapture(CoClass):
    """MS Video Control iTV Capture"""
    _reg_clsid_ = GUID('{5740A302-EF0B-45CE-BF3B-4470A14A8980}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidITVCapture._com_interfaces_ = [IMSVidGraphSegment, IMSVidFeature]

IBindCtx._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'RegisterObjectBound',
        (['in'], POINTER(IUnknown), 'punk')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'RevokeObjectBound',
        (['in'], POINTER(IUnknown), 'punk')
    ),
    COMMETHOD([], HRESULT, 'ReleaseBoundObjects'),
    COMMETHOD(
        [],
        HRESULT,
        'RemoteSetBindOptions',
        (['in'], POINTER(tagBIND_OPTS2), 'pbindopts')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'RemoteGetBindOptions',
        (['in', 'out'], POINTER(tagBIND_OPTS2), 'pbindopts')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetRunningObjectTable',
        (['out'], POINTER(POINTER(IRunningObjectTable)), 'pprot')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'RegisterObjectParam',
        (['in'], WSTRING, 'pszKey'),
        (['in'], POINTER(IUnknown), 'punk')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'GetObjectParam',
        (['in'], WSTRING, 'pszKey'),
        (['out'], POINTER(POINTER(IUnknown)), 'ppunk')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'EnumObjectParam',
        (['out'], POINTER(POINTER(IEnumString)), 'ppenum')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'RevokeObjectParam',
        (['in'], WSTRING, 'pszKey')
    ),
]

################################################################
# code template for IBindCtx implementation
# class IBindCtx_Impl(object):
#     def RegisterObjectBound(self, punk):
#         '-no docstring-'
#         #return 
#
#     def RevokeObjectBound(self, punk):
#         '-no docstring-'
#         #return 
#
#     def ReleaseBoundObjects(self):
#         '-no docstring-'
#         #return 
#
#     def RemoteSetBindOptions(self, pbindopts):
#         '-no docstring-'
#         #return 
#
#     def RemoteGetBindOptions(self):
#         '-no docstring-'
#         #return pbindopts
#
#     def GetRunningObjectTable(self):
#         '-no docstring-'
#         #return pprot
#
#     def RegisterObjectParam(self, pszKey, punk):
#         '-no docstring-'
#         #return 
#
#     def GetObjectParam(self, pszKey):
#         '-no docstring-'
#         #return ppunk
#
#     def EnumObjectParam(self):
#         '-no docstring-'
#         #return ppenum
#
#     def RevokeObjectParam(self, pszKey):
#         '-no docstring-'
#         #return 
#

IMSVidFeature._methods_ = [
]

################################################################
# code template for IMSVidFeature implementation
# class IMSVidFeature_Impl(object):

IMSVidEncoder._methods_ = [
    COMMETHOD(
        [dispid(185), 'propget'],
        HRESULT,
        'VideoEncoderInterface',
        (['out', 'retval'], POINTER(POINTER(IUnknown)), 'ppEncInt')
    ),
    COMMETHOD(
        [dispid(184), 'propget'],
        HRESULT,
        'AudioEncoderInterface',
        (['out', 'retval'], POINTER(POINTER(IUnknown)), 'ppEncInt')
    ),
]

################################################################
# code template for IMSVidEncoder implementation
# class IMSVidEncoder_Impl(object):
#     @property
#     def VideoEncoderInterface(self):
#         '-no docstring-'
#         #return ppEncInt
#
#     @property
#     def AudioEncoderInterface(self):
#         '-no docstring-'
#         #return ppEncInt
#


class MSVidOutputDevices(CoClass):
    """MS Video Control Output Device Collection Class"""
    _reg_clsid_ = GUID('{C5702CCD-9B79-11D3-B654-00C04F79498E}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidOutputDevices._com_interfaces_ = [IMSVidOutputDevices]


class MSVidVideoRendererDevices(CoClass):
    """MS Video Control Video Renderer Device Collection Class"""
    _reg_clsid_ = GUID('{C5702CCE-9B79-11D3-B654-00C04F79498E}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidVideoRendererDevices._com_interfaces_ = [IMSVidVideoRendererDevices]


class MSVidITVPlayback(CoClass):
    """MS Video Control iTV Playback"""
    _reg_clsid_ = GUID('{9E797ED0-5253-4243-A9B7-BD06C58F8EF3}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidITVPlayback._com_interfaces_ = [IMSVidGraphSegment, IMSVidFeature]


class MSVidAudioRendererDevices(CoClass):
    """MS Video Control Audio Renderer Device Collection Class"""
    _reg_clsid_ = GUID('{C5702CCF-9B79-11D3-B654-00C04F79498E}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidAudioRendererDevices._com_interfaces_ = [IMSVidAudioRendererDevices]


class MSVidFeatures(CoClass):
    """MS Video Control Feature Collection Class"""
    _reg_clsid_ = GUID('{C5702CD0-9B79-11D3-B654-00C04F79498E}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidFeatures._com_interfaces_ = [IMSVidFeatures]


class MSVidGenericComposite(CoClass):
    """MS Video Control Generic Composition Class"""
    _reg_clsid_ = GUID('{2764BCE5-CC39-11D2-B639-00C04F79498E}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidGenericComposite._com_interfaces_ = [IMSVidCompositionSegment]


class MSVidClosedCaptioning(CoClass):
    """MS Video Control Standard Closed Captioning"""
    _reg_clsid_ = GUID('{7F9CB14D-48E4-43B6-9346-1AEBC39C64D3}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


class IMSVidClosedCaptioning(IMSVidFeature):
    """MS Video Control Closed Captioning Feature Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{99652EA1-C1F7-414F-BB7B-1C967DE75983}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_Enable(self) -> hints.Incomplete: ...
        def _set_Enable(self, On: hints.Incomplete) -> hints.Hresult: ...
        Enable = hints.normal_property(_get_Enable, _set_Enable)


class IMSVidClosedCaptioning2(IMSVidClosedCaptioning):
    """MS Video Control Closed Captioning Feature Interface 2"""
    _case_insensitive_ = True
    _iid_ = GUID('{E00CB864-A029-4310-9987-A873F5887D97}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_Service(self) -> hints.Incomplete: ...
        def _set_Service(self, On: hints.Incomplete) -> hints.Hresult: ...
        Service = hints.normal_property(_get_Service, _set_Service)


class IMSVidClosedCaptioning3(IMSVidClosedCaptioning2):
    """MS Video Control Closed Captioning Feature Interface 3"""
    _case_insensitive_ = True
    _iid_ = GUID('{C8638E8A-7625-4C51-9366-2F40A9831FC0}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_TeleTextFilter(self) -> hints.Incomplete: ...
        TeleTextFilter = hints.normal_property(_get_TeleTextFilter)


MSVidClosedCaptioning._com_interfaces_ = [IMSVidClosedCaptioning3, IMSVidClosedCaptioning2, IMSVidClosedCaptioning]


class MSVidAnalogCaptureToOverlayMixer(CoClass):
    """MS Video Control Custom Composition for Analog Capture to Overlay Mixer"""
    _reg_clsid_ = GUID('{E18AF75A-08AF-11D3-B64A-00C04F79498E}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidAnalogCaptureToOverlayMixer._com_interfaces_ = [IMSVidCompositionSegment]


class MSVidCCA(CoClass):
    """MS Video Control Closed Captions Analysis"""
    _reg_clsid_ = GUID('{86151827-E47B-45EE-8421-D10E6E690979}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidCCA._com_interfaces_ = [IMSVidGraphSegment, IMSVidFeature]


class MSVidWebDVDToVideoRenderer(CoClass):
    """MS Video Control Custom Composition for WebDVD to Overlay Mixer"""
    _reg_clsid_ = GUID('{267DB0B3-55E3-4902-949B-DF8F5CEC0191}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidWebDVDToVideoRenderer._com_interfaces_ = [IMSVidCompositionSegment]


class MSVidClosedCaptioningSI(CoClass):
    """MS Video Control CCSI Closed Captioning"""
    _reg_clsid_ = GUID('{92ED88BF-879E-448F-B6B6-A385BCEB846D}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidClosedCaptioningSI._com_interfaces_ = [IMSVidClosedCaptioning3, IMSVidClosedCaptioning2, IMSVidClosedCaptioning]


class MSVidWebDVDToAudioRenderer(CoClass):
    """MS Video Control Custom Composition for WebDVD to Audio Renderer"""
    _reg_clsid_ = GUID('{8D04238E-9FD1-41C6-8DE3-9E1EE309E935}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidWebDVDToAudioRenderer._com_interfaces_ = [IMSVidCompositionSegment]

IMSVidStreamBufferSourceEvent3._methods_ = [
    COMMETHOD(
        [helpstring('Broadcast Event Generic')],
        HRESULT,
        'BroadcastEvent',
        (['in'], BSTR, 'Guid')
    ),
    COMMETHOD(
        [helpstring('Broadcast EventEx Generic')],
        HRESULT,
        'BroadcastEventEx',
        (['in'], BSTR, 'Guid'),
        (['in'], c_ulong, 'Param1'),
        (['in'], c_ulong, 'Param2'),
        (['in'], c_ulong, 'Param3'),
        (['in'], c_ulong, 'Param4')
    ),
    COMMETHOD([helpstring('COPP Blocked')], HRESULT, 'COPPBlocked'),
    COMMETHOD([helpstring('COPP Unblocked')], HRESULT, 'COPPUnblocked'),
    COMMETHOD(
        [helpstring('Source Content Primarily Audio')],
        HRESULT,
        'ContentPrimarilyAudio',
    ),
]

################################################################
# code template for IMSVidStreamBufferSourceEvent3 implementation
# class IMSVidStreamBufferSourceEvent3_Impl(object):
#     def BroadcastEvent(self, Guid):
#         'Broadcast Event Generic'
#         #return 
#
#     def BroadcastEventEx(self, Guid, Param1, Param2, Param3, Param4):
#         'Broadcast EventEx Generic'
#         #return 
#
#     def COPPBlocked(self):
#         'COPP Blocked'
#         #return 
#
#     def COPPUnblocked(self):
#         'COPP Unblocked'
#         #return 
#
#     def ContentPrimarilyAudio(self):
#         'Source Content Primarily Audio'
#         #return 
#


class MSVidOutput(CoClass):
    """dummy class to expose base interface to VB"""
    _reg_clsid_ = GUID('{87EB890D-03AD-4E9D-9866-376E5EC572ED}')
    _idlflags_ = ['hidden', 'restricted', 'noncreatable']
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidOutput._com_interfaces_ = [IMSVidOutputDevice]


class MSVidMPEG2DecoderToClosedCaptioning(CoClass):
    """MS Video Control Custom Composition for Mpeg2 Decoder to Closed Captioning"""
    _reg_clsid_ = GUID('{6AD28EE1-5002-4E71-AAF7-BD077907B1A4}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidMPEG2DecoderToClosedCaptioning._com_interfaces_ = [IMSVidCompositionSegment]

IMSVidClosedCaptioning._methods_ = [
    COMMETHOD(
        [dispid(38), 'propget'],
        HRESULT,
        'Enable',
        (['out', 'retval'], POINTER(VARIANT_BOOL), 'On')
    ),
    COMMETHOD(
        [dispid(38), 'propput'],
        HRESULT,
        'Enable',
        (['in'], VARIANT_BOOL, 'On')
    ),
]

################################################################
# code template for IMSVidClosedCaptioning implementation
# class IMSVidClosedCaptioning_Impl(object):
#     def _get(self):
#         '-no docstring-'
#         #return On
#     def _set(self, On):
#         '-no docstring-'
#     Enable = property(_get, _set, doc = _set.__doc__)
#

IMSVidClosedCaptioning2._methods_ = [
    COMMETHOD(
        [dispid(186), 'propget'],
        HRESULT,
        'Service',
        (['out', 'retval'], POINTER(MSVidCCService), 'On')
    ),
    COMMETHOD(
        [dispid(186), 'propput'],
        HRESULT,
        'Service',
        (['in'], MSVidCCService, 'On')
    ),
]

################################################################
# code template for IMSVidClosedCaptioning2 implementation
# class IMSVidClosedCaptioning2_Impl(object):
#     def _get(self):
#         '-no docstring-'
#         #return On
#     def _set(self, On):
#         '-no docstring-'
#     Service = property(_get, _set, doc = _set.__doc__)
#

IMSVidClosedCaptioning3._methods_ = [
    COMMETHOD(
        [dispid(196), 'propget'],
        HRESULT,
        'TeleTextFilter',
        (['out', 'retval'], POINTER(POINTER(IUnknown)), 'punkTTFilter')
    ),
]

################################################################
# code template for IMSVidClosedCaptioning3 implementation
# class IMSVidClosedCaptioning3_Impl(object):
#     @property
#     def TeleTextFilter(self):
#         '-no docstring-'
#         #return punkTTFilter
#


class MSVidAnalogCaptureToStreamBufferSink(CoClass):
    """MS Video Control Custom Composition for Analog Capture to Stream Buffer Sink"""
    _reg_clsid_ = GUID('{9F50E8B1-9530-4DDC-825E-1AF81D47AED6}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidAnalogCaptureToStreamBufferSink._com_interfaces_ = [IMSVidCompositionSegment]


class MSVidDigitalCaptureToStreamBufferSink(CoClass):
    """MS Video Control Custom Composition for Digital Capture to Stream Buffer Sink"""
    _reg_clsid_ = GUID('{ABE40035-27C3-4A2F-8153-6624471608AF}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidDigitalCaptureToStreamBufferSink._com_interfaces_ = [IMSVidCompositionSegment]


class MSVidDataServices(CoClass):
    """MS Video Control Standard Data Services for Broadcast IP through NDIS stack"""
    _reg_clsid_ = GUID('{334125C0-77E5-11D3-B653-00C04F79498E}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


class IMSVidDataServices(IMSVidFeature):
    """MS Video Control Data Services Feature Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{334125C1-77E5-11D3-B653-00C04F79498E}')
    _idlflags_ = ['hidden', 'dual', 'oleautomation', 'proxy']


MSVidDataServices._com_interfaces_ = [IMSVidDataServices]


class MSVidITVToStreamBufferSink(CoClass):
    """MS Video Control Custom Composition for iTV to Stream Buffer Sink"""
    _reg_clsid_ = GUID('{92B94828-1AF7-4E6E-9EBF-770657F77AF5}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidITVToStreamBufferSink._com_interfaces_ = [IMSVidCompositionSegment]


class MSVidCCAToStreamBufferSink(CoClass):
    """MS Video Control Custom Composition for CCA to Stream Buffer Sink"""
    _reg_clsid_ = GUID('{3EF76D68-8661-4843-8B8F-C37163D8C9CE}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidCCAToStreamBufferSink._com_interfaces_ = [IMSVidCompositionSegment]


class MSVidBDATunerDevice(CoClass):
    """MS Video Control BDA Tuner Device Class"""
    _reg_clsid_ = GUID('{A2E3074E-6C3D-11D3-B653-00C04F79498E}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidBDATunerDevice._com_interfaces_ = [IMSVidTuner, IMSVidGraphSegment]
MSVidBDATunerDevice._outgoing_interfaces_ = [IMSVidTunerEvent]


class MSVidEncoderToStreamBufferSink(CoClass):
    """MS Video Control Custom Composition for Encoder to Stream Buffer Sink"""
    _reg_clsid_ = GUID('{A0B9B497-AFBC-45AD-A8A6-9B077C40D4F2}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidEncoderToStreamBufferSink._com_interfaces_ = [IMSVidCompositionSegment]


class MSVidFilePlaybackToVideoRenderer(CoClass):
    """MS Video Control Custom Composition for File Playback to Video Renderer"""
    _reg_clsid_ = GUID('{B401C5EB-8457-427F-84EA-A4D2363364B0}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidFilePlaybackToVideoRenderer._com_interfaces_ = [IMSVidCompositionSegment]


class MSVidFilePlaybackToAudioRenderer(CoClass):
    """MS Video Control Custom Composition for File Playback to Audio Renderer"""
    _reg_clsid_ = GUID('{CC23F537-18D4-4ECE-93BD-207A84726979}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidFilePlaybackToAudioRenderer._com_interfaces_ = [IMSVidCompositionSegment]


class MSVidAnalogTVToEncoder(CoClass):
    """MS Video Control Custom Composition for TV Tuner to Encoder"""
    _reg_clsid_ = GUID('{28953661-0231-41DB-8986-21FF4388EE9B}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidAnalogTVToEncoder._com_interfaces_ = [IMSVidCompositionSegment]


class MSVidStreamBufferSourceToVideoRenderer(CoClass):
    """MS Video Control Custom Composition for SBE Source to Video renderer"""
    _reg_clsid_ = GUID('{3C4708DC-B181-46A8-8DA8-4AB0371758CD}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidStreamBufferSourceToVideoRenderer._com_interfaces_ = [IMSVidCompositionSegment]


class MSVidAnalogCaptureToCCA(CoClass):
    """MS Video Control Custom Composition for TV Tuner to CCA"""
    _reg_clsid_ = GUID('{942B7909-A28E-49A1-A207-34EBCBCB4B3B}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidAnalogCaptureToCCA._com_interfaces_ = [IMSVidCompositionSegment]


class MSVidDigitalCaptureToCCA(CoClass):
    """MS Video Control Custom Composition for Digital Capture to CCA"""
    _reg_clsid_ = GUID('{73D14237-B9DB-4EFA-A6DD-84350421FB2F}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidDigitalCaptureToCCA._com_interfaces_ = [IMSVidCompositionSegment]

_wireBRECORD._fields_ = [
    ('fFlags', c_ulong),
    ('clSize', c_ulong),
    ('pRecInfo', POINTER(IRecordInfo)),
    ('pRecord', POINTER(c_ubyte)),
]

assert sizeof(_wireBRECORD) == 24, sizeof(_wireBRECORD)
assert alignment(_wireBRECORD) == 8, alignment(_wireBRECORD)


class MSVidDigitalCaptureToITV(CoClass):
    """MS Video Control Custom Composition for Digital Capture to ITV"""
    _reg_clsid_ = GUID('{5D8E73F7-4989-4AC8-8A98-39BA0D325302}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidDigitalCaptureToITV._com_interfaces_ = [IMSVidCompositionSegment]


class MSVidDevice(CoClass):
    """dummy class to expose base interface to VB"""
    _reg_clsid_ = GUID('{6E40476F-9C49-4C3E-8BB9-8587958EFF74}')
    _idlflags_ = ['hidden', 'restricted', 'noncreatable']
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidDevice._com_interfaces_ = [IMSVidDevice]


class tagVMRALLOCATIONINFO(Structure):
    pass


IVMRSurfaceAllocator._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'AllocateSurface',
        (['in'], ULONG_PTR, 'dwUserID'),
        (['in'], POINTER(tagVMRALLOCATIONINFO), 'lpAllocInfo'),
        (['in', 'out'], POINTER(c_ulong), 'lpdwActualBuffers'),
        (['out'], POINTER(POINTER(c_ulong)), 'lplpSurface')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'FreeSurface',
        (['in'], ULONG_PTR, 'dwID')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'PrepareSurface',
        (['in'], ULONG_PTR, 'dwUserID'),
        (['in'], POINTER(c_ulong), 'lpSurface'),
        (['in'], c_ulong, 'dwSurfaceFlags')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'AdviseNotify',
        (['in'], POINTER(IVMRSurfaceAllocatorNotify), 'lpIVMRSurfAllocNotify')
    ),
]

################################################################
# code template for IVMRSurfaceAllocator implementation
# class IVMRSurfaceAllocator_Impl(object):
#     def AllocateSurface(self, dwUserID, lpAllocInfo):
#         '-no docstring-'
#         #return lpdwActualBuffers, lplpSurface
#
#     def FreeSurface(self, dwID):
#         '-no docstring-'
#         #return 
#
#     def PrepareSurface(self, dwUserID, lpSurface, dwSurfaceFlags):
#         '-no docstring-'
#         #return 
#
#     def AdviseNotify(self, lpIVMRSurfAllocNotify):
#         '-no docstring-'
#         #return 
#


class MSVidSBESourceToITV(CoClass):
    """MS Video Control Custom Composition for Stream Buffer Source to ITV"""
    _reg_clsid_ = GUID('{2291478C-5EE3-4BEF-AB5D-B5FF2CF58352}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidSBESourceToITV._com_interfaces_ = [IMSVidCompositionSegment]


class MSVidDevice2(CoClass):
    """dummy class to expose base interface to VB"""
    _reg_clsid_ = GUID('{30997F7D-B3B5-4A1C-983A-1FE8098CB77D}')
    _idlflags_ = ['hidden', 'restricted', 'noncreatable']
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


class IMSVidDevice2(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    """MS Video Control Device Interface 2"""
    _case_insensitive_ = True
    _iid_ = GUID('{87BD2783-EBC0-478C-B4A0-E8E7F43AB78E}')
    _idlflags_ = ['dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_DevicePath(self) -> hints.Incomplete: ...
        DevicePath = hints.normal_property(_get_DevicePath)


MSVidDevice2._com_interfaces_ = [IMSVidDevice2]


class MSVidSBESourceToCC(CoClass):
    """MS Video Control Custom Composition for Stream Buffer Source to CC"""
    _reg_clsid_ = GUID('{9193A8F9-0CBA-400E-AA97-EB4709164576}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidSBESourceToCC._com_interfaces_ = [IMSVidCompositionSegment]

IMSVidDevice2._methods_ = [
    COMMETHOD(
        [dispid(217), 'propget'],
        HRESULT,
        'DevicePath',
        (['out', 'retval'], POINTER(BSTR), 'DevPath')
    ),
]

################################################################
# code template for IMSVidDevice2 implementation
# class IMSVidDevice2_Impl(object):
#     @property
#     def DevicePath(self):
#         '-no docstring-'
#         #return DevPath
#


class MSVidSBESourceToGenericSink(CoClass):
    """MS Video Control Stream Buffer Source to Generic Sink Composition Class"""
    _reg_clsid_ = GUID('{991DA7E5-953F-435B-BE5E-B92A05EDFC42}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidSBESourceToGenericSink._com_interfaces_ = [IMSVidCompositionSegment]


class MSVidInputDevice(CoClass):
    """dummy class to expose base interface to VB"""
    _reg_clsid_ = GUID('{AC1972F2-138A-4CA3-90DA-AE51112EDA28}')
    _idlflags_ = ['hidden', 'restricted', 'noncreatable']
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidInputDevice._com_interfaces_ = [IMSVidInputDevice]


class MSVidCCToVMR(CoClass):
    """MS Video Control Custom Composition for CC to Video Renderer"""
    _reg_clsid_ = GUID('{C4BF2784-AE00-41BA-9828-9C953BD3C54A}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidCCToVMR._com_interfaces_ = [IMSVidCompositionSegment]


class MSVidXDS(CoClass):
    """MS Video Control Encoder"""
    _reg_clsid_ = GUID('{0149EEDF-D08F-4142-8D73-D23903D21E90}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


class IMSVidXDS(IMSVidFeature):
    """MS Video Control XDS Feature Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{11EBC158-E712-4D1F-8BB3-01ED5274C4CE}')
    _idlflags_ = ['dual', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def _get_ChannelChangeInterface(self) -> hints.Incomplete: ...
        ChannelChangeInterface = hints.normal_property(_get_ChannelChangeInterface)


class IMSVidXDSEvent(IMSVidFeatureEvent):
    """MS Video Control XDS Feature Event Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{6DB2317D-3B23-41EC-BA4B-701F407EAF3A}')
    _idlflags_ = ['hidden', 'oleautomation']

    if TYPE_CHECKING:  # commembers
        def RatingChange(self, PrevRatingSystem: hints.Incomplete, PrevLevel: hints.Incomplete, PrevAttributes: hints.Incomplete, NewRatingSystem: hints.Incomplete, NewLevel: hints.Incomplete, NewAttributes: hints.Incomplete) -> hints.Hresult: ...


MSVidXDS._com_interfaces_ = [IMSVidXDS]
MSVidXDS._outgoing_interfaces_ = [IMSVidXDSEvent]

IComponentTypes._methods_ = [
    COMMETHOD(
        [dispid(1610743808), helpstring('Number of items in the collection'), 'propget'],
        HRESULT,
        'Count',
        (['out', 'retval'], POINTER(c_int), 'Count')
    ),
    COMMETHOD(
        [dispid(-4), 'restricted', 'hidden', 'propget'],
        HRESULT,
        '_NewEnum',
        (
            ['out', 'retval'],
            POINTER(POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IEnumVARIANT)),
            'ppNewEnum',
        )
    ),
    COMMETHOD(
        [dispid(1610743810), helpstring('Convenience Function for Use with C'), 'restricted', 'hidden'],
        HRESULT,
        'EnumComponentTypes',
        (['out', 'retval'], POINTER(POINTER(IEnumComponentTypes)), 'ppNewEnum')
    ),
    COMMETHOD(
        [dispid(0), helpstring('Get the ComponentType at the specified index'), 'propget'],
        HRESULT,
        'Item',
        (['in'], VARIANT, 'Index'),
        (['out', 'retval'], POINTER(POINTER(IComponentType)), 'ComponentType')
    ),
    COMMETHOD(
        [dispid(0), helpstring('Get the ComponentType at the specified index'), 'propput'],
        HRESULT,
        'Item',
        (['in'], VARIANT, 'Index'),
        (['in'], POINTER(IComponentType), 'ComponentType')
    ),
    COMMETHOD(
        [dispid(-553), helpstring('Append the ComponentType to the collection')],
        HRESULT,
        'Add',
        (['in'], POINTER(IComponentType), 'ComponentType'),
        (['out', 'retval'], POINTER(VARIANT), 'NewIndex')
    ),
    COMMETHOD(
        [dispid(-555), helpstring('Clear the collection')],
        HRESULT,
        'Remove',
        (['in'], VARIANT, 'Index')
    ),
    COMMETHOD(
        [dispid(1610743815), helpstring('Copy the collection')],
        HRESULT,
        'Clone',
        (['out', 'retval'], POINTER(POINTER(IComponentTypes)), 'NewList')
    ),
]

################################################################
# code template for IComponentTypes implementation
# class IComponentTypes_Impl(object):
#     @property
#     def Count(self):
#         'Number of items in the collection'
#         #return Count
#
#     @property
#     def _NewEnum(self):
#         '-no docstring-'
#         #return ppNewEnum
#
#     def EnumComponentTypes(self):
#         'Convenience Function for Use with C'
#         #return ppNewEnum
#
#     def _get(self, Index):
#         'Get the ComponentType at the specified index'
#         #return ComponentType
#     def _set(self, Index, ComponentType):
#         'Get the ComponentType at the specified index'
#     Item = property(_get, _set, doc = _set.__doc__)
#
#     def Add(self, ComponentType):
#         'Append the ComponentType to the collection'
#         #return NewIndex
#
#     def Remove(self, Index):
#         'Clear the collection'
#         #return 
#
#     def Clone(self):
#         'Copy the collection'
#         #return NewList
#

IEnumFilters._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'Next',
        (['in'], c_ulong, 'cFilters'),
        (['out'], POINTER(POINTER(IBaseFilter)), 'ppFilter'),
        (['out'], POINTER(c_ulong), 'pcFetched')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Skip',
        (['in'], c_ulong, 'cFilters')
    ),
    COMMETHOD([], HRESULT, 'Reset'),
    COMMETHOD(
        [],
        HRESULT,
        'Clone',
        (['out'], POINTER(POINTER(IEnumFilters)), 'ppenum')
    ),
]

################################################################
# code template for IEnumFilters implementation
# class IEnumFilters_Impl(object):
#     def Next(self, cFilters):
#         '-no docstring-'
#         #return ppFilter, pcFetched
#
#     def Skip(self, cFilters):
#         '-no docstring-'
#         #return 
#
#     def Reset(self):
#         '-no docstring-'
#         #return 
#
#     def Clone(self):
#         '-no docstring-'
#         #return ppenum
#


class MSVidCCToAR(CoClass):
    """MS Video Control Custom Composition for CC to Audio Renderer"""
    _reg_clsid_ = GUID('{D76334CA-D89E-4BAF-86AB-DDB59372AFC2}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidCCToAR._com_interfaces_ = [IMSVidCompositionSegment]

IMSVidDataServices._methods_ = [
]

################################################################
# code template for IMSVidDataServices implementation
# class IMSVidDataServices_Impl(object):

tagVMRALLOCATIONINFO._fields_ = [
    ('dwFlags', c_ulong),
    ('lpHdr', POINTER(c_ulong)),
    ('lpPixFmt', POINTER(c_ulong)),
    ('szAspectRatio', tagSIZE),
    ('dwMinBuffers', c_ulong),
    ('dwMaxBuffers', c_ulong),
    ('dwInterlaceFlags', c_ulong),
    ('szNativeSize', tagSIZE),
]

assert sizeof(tagVMRALLOCATIONINFO) == 56, sizeof(tagVMRALLOCATIONINFO)
assert alignment(tagVMRALLOCATIONINFO) == 8, alignment(tagVMRALLOCATIONINFO)


class MSVidVideoInputDevice(CoClass):
    """dummy class to expose base interface to VB"""
    _reg_clsid_ = GUID('{95F4820B-BB3A-4E2D-BC64-5B817BC2C30E}')
    _idlflags_ = ['hidden', 'restricted', 'noncreatable']
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidVideoInputDevice._com_interfaces_ = [IMSVidVideoInputDevice]


class MSEventBinder(CoClass):
    """MSEventBinder Class"""
    _reg_clsid_ = GUID('{577FAA18-4518-445E-8F70-1473F8CF4BA4}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


class IMSEventBinder(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IDispatch):
    """IMSEventBinder Interface"""
    _case_insensitive_ = True
    _iid_ = GUID('{C3A9F406-2222-436D-86D5-BA3229279EFB}')
    _idlflags_ = ['hidden', 'dual', 'nonextensible', 'oleautomation', 'proxy']

    if TYPE_CHECKING:  # commembers
        def Bind(self, pEventObject: hints.Incomplete, EventName: hints.Incomplete, EventHandler: hints.Incomplete) -> hints.Incomplete: ...
        def Unbind(self, CancelCookie: hints.Incomplete) -> hints.Hresult: ...


MSEventBinder._com_interfaces_ = [IMSEventBinder]

tagSTATSTG._fields_ = [
    ('pwcsName', WSTRING),
    ('type', c_ulong),
    ('cbSize', _ULARGE_INTEGER),
    ('mtime', _FILETIME),
    ('ctime', _FILETIME),
    ('atime', _FILETIME),
    ('grfMode', c_ulong),
    ('grfLocksSupported', c_ulong),
    ('Clsid', comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
    ('grfStateBits', c_ulong),
    ('reserved', c_ulong),
]

assert sizeof(tagSTATSTG) == 80, sizeof(tagSTATSTG)
assert alignment(tagSTATSTG) == 8, alignment(tagSTATSTG)

IMSVidXDSEvent._methods_ = [
    COMMETHOD(
        [helpstring('Rating Change')],
        HRESULT,
        'RatingChange',
        (['in'], EnTvRat_System, 'PrevRatingSystem'),
        (['in'], EnTvRat_GenericLevel, 'PrevLevel'),
        (['in'], BfEnTvRat_GenericAttributes, 'PrevAttributes'),
        (['in'], EnTvRat_System, 'NewRatingSystem'),
        (['in'], EnTvRat_GenericLevel, 'NewLevel'),
        (['in'], BfEnTvRat_GenericAttributes, 'NewAttributes')
    ),
]

################################################################
# code template for IMSVidXDSEvent implementation
# class IMSVidXDSEvent_Impl(object):
#     def RatingChange(self, PrevRatingSystem, PrevLevel, PrevAttributes, NewRatingSystem, NewLevel, NewAttributes):
#         'Rating Change'
#         #return 
#


class MSVidStreamBufferRecordingControl(CoClass):
    """MSVidStreamBufferRecordingControl"""
    _reg_clsid_ = GUID('{CAAFDD83-CEFC-4E3D-BA03-175F17A24F91}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidStreamBufferRecordingControl._com_interfaces_ = [IMSVidStreamBufferRecordingControl]


class MSVidAnalogCaptureToDataServices(CoClass):
    """MS Video Control Custom Composition for Analog Capture to Data Services"""
    _reg_clsid_ = GUID('{C5702CD6-9B79-11D3-B654-00C04F79498E}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidAnalogCaptureToDataServices._com_interfaces_ = [IMSVidCompositionSegment]

IMSVidXDS._methods_ = [
    COMMETHOD(
        [dispid(197), 'propget'],
        HRESULT,
        'ChannelChangeInterface',
        (['out', 'retval'], POINTER(POINTER(IUnknown)), 'punkCC')
    ),
]

################################################################
# code template for IMSVidXDS implementation
# class IMSVidXDS_Impl(object):
#     @property
#     def ChannelChangeInterface(self):
#         '-no docstring-'
#         #return punkCC
#

IMSEventBinder._methods_ = [
    COMMETHOD(
        [dispid(24), helpstring('method Bind')],
        HRESULT,
        'Bind',
        (['in'], POINTER(IDispatch), 'pEventObject'),
        (['in'], BSTR, 'EventName'),
        (['in'], BSTR, 'EventHandler'),
        (['out', 'retval'], POINTER(c_int), 'CancelID')
    ),
    COMMETHOD(
        [dispid(23), helpstring('method Unbind')],
        HRESULT,
        'Unbind',
        (['in'], c_ulong, 'CancelCookie')
    ),
]

################################################################
# code template for IMSEventBinder implementation
# class IMSEventBinder_Impl(object):
#     def Bind(self, pEventObject, EventName, EventHandler):
#         'method Bind'
#         #return CancelID
#
#     def Unbind(self, CancelCookie):
#         'method Unbind'
#         #return 
#


class MSVidVideoPlaybackDevice(CoClass):
    """dummy class to expose base interface to VB"""
    _reg_clsid_ = GUID('{1990D634-1A5E-4071-A34A-53AAFFCE9F36}')
    _idlflags_ = ['hidden', 'restricted', 'noncreatable']
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidVideoPlaybackDevice._com_interfaces_ = [IMSVidPlayback]

IBaseFilter._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'EnumPins',
        (['out'], POINTER(POINTER(IEnumPins)), 'ppenum')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'FindPin',
        (['in'], WSTRING, 'Id'),
        (['out'], POINTER(POINTER(IPin)), 'ppPin')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'QueryFilterInfo',
        (['out'], POINTER(_FilterInfo), 'pInfo')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'JoinFilterGraph',
        (['in'], POINTER(IFilterGraph), 'pGraph'),
        (['in'], WSTRING, 'pName')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'QueryVendorInfo',
        (['out'], POINTER(WSTRING), 'pVendorInfo')
    ),
]

################################################################
# code template for IBaseFilter implementation
# class IBaseFilter_Impl(object):
#     def EnumPins(self):
#         '-no docstring-'
#         #return ppenum
#
#     def FindPin(self, Id):
#         '-no docstring-'
#         #return ppPin
#
#     def QueryFilterInfo(self):
#         '-no docstring-'
#         #return pInfo
#
#     def JoinFilterGraph(self, pGraph, pName):
#         '-no docstring-'
#         #return 
#
#     def QueryVendorInfo(self):
#         '-no docstring-'
#         #return pVendorInfo
#


class MSVidFeature(CoClass):
    """dummy class to expose base interface to VB"""
    _reg_clsid_ = GUID('{7748530B-C08A-47EA-B24C-BE8695FF405F}')
    _idlflags_ = ['hidden', 'restricted', 'noncreatable']
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidFeature._com_interfaces_ = [IMSVidFeature]


class MSVidRect(CoClass):
    """Automation compliant scalable rectangle Class"""
    _reg_clsid_ = GUID('{CB4276E6-7D5F-4CF1-9727-629C5E6DB6AE}')
    _idlflags_ = ['hidden', 'restricted']
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{B0EDF154-910A-11D2-B632-00C04F79498E}', 1, 0)


MSVidRect._com_interfaces_ = [IMSVidRect]

__all__ = [
    'IMSVidPlaybackEvent', 'TvRat_14', 'dvdSPExt_Caption_Normal',
    'MFVideoTransFunc_18', 'PositionModeList', 'TvRat_8',
    'MFVP_MESSAGE_PROCESSINPUTNOTIFY', 'tagCAFLT',
    'MFVideoTransferMatrix_Chroma_const', 'IMSVidFeatures',
    'SourceSizeList', 'MSVidWebDVDAdm', 'IMSVidInputDevices',
    'CategoryText', 'dvdTitle_Sub_Series', 'IMSVidCompositionSegment',
    'MF_ATTRIBUTE_UINT64', 'DVDMenuIDConstants',
    'MFVideoTransFunc_SMPTE428', 'dvdTitle_Sub_Movie',
    'MSVidSBESourceToCC', 'StatusActive', 'tagCASCODE',
    'MFVideoLighting_office', 'tagBLOB',
    'MSVidFilePlaybackToAudioRenderer',
    'MFVideoPrimaries_BT470_2_SysBG', 'IMFMediaType',
    'BDA_BCC_RATE_NOT_DEFINED', 'BDA_MOD_320QAM', '_VMRALPHABITMAP',
    '__MIDL_IOleAutomationTypes_0004', 'BfIsAttr_4',
    'dvdTitle_Orig_Other', 'dvdChannel_Audio', 'ComponentCategory',
    'dvdStruct_Volume', 'BDA_MOD_128QAM', '_BYTE_SIZEDARR',
    'PINDIR_INPUT', 'IMSVidStreamBufferSink2', 'BDA_BCC_RATE_2_5',
    'MFVideoTransFunc_20', 'dvdGeneral_Comments',
    'MSVidMPEG2DecoderToClosedCaptioning', 'tagCACLIPDATA',
    'BDA_MOD_256QAM', 'XDS', 'dvdMenu_Audio', 'IMSVidVideoRenderer2',
    'Caption1', '_MFOffset',
    'MFVideoChromaSubsampling_Vertically_AlignedChromaPlanes',
    'tagCLIPDATA', 'BfIsAttr_3', 'IMSVidVideoRenderer',
    'CategoryOther', 'IMSVidAudioRendererDevices', 'BDA_FEC_VITERBI',
    'BDA_MOD_NOT_SET', '_MFVideoPrimaries', 'MSVidOutput',
    'BDA_MOD_NBC_QPSK', 'MSVidDigitalCaptureToCCA',
    'MFVideoPrimaries_Display_P3', 'BDA_FEC_RS_204_188', 'tagCAC',
    'IMediaFilter', 'TvRat_5', 'BfIsAttr_7',
    'MF_ATTRIBUTES_MATCH_SMALLER', 'IMFVideoPresenter',
    'MSVidVideoRendererDevices', 'MSVidFeature',
    'dvdStruct_PartOfTitle', 'dslDefaultSize', '_AMMediaType',
    'IVMRSurfaceAllocatorNotify', 'IMSVidOutputDeviceEvent',
    'dvdMenu_Angle', 'TvRat_19', 'IComponent', 'IEnumPins',
    'BDA_MOD_ISDB_S_TMCC', 'MSVidInputDevices', 'sslClipByClipRect',
    'Library', 'MSVidClosedCaptioning', 'IMSVidClosedCaptioning2',
    'IMSVidFeatureEvent', '_MFRatio', 'MSVidFilePlaybackDevice',
    'BDA_MOD_16VSB', '_FilterState', 'BDA_MOD_512QAM',
    'IVMRImageCompositor', 'typelib_path', 'BDA_BCC_RATE_8_9',
    'MFVideoChromaSubsampling_MPEG1', 'MSVidVideoInputDevice',
    'TvRat_0', 'IMSVidXDS', 'IRunningObjectTable',
    'MFVideoChromaSubsampling_ForceDWORD', 'BDA_MOD_1024QAM',
    'IStream', 'MFVideoTransFunc_Last',
    '__MIDL___MIDL_itf_msvidctl_0003_0263_0001',
    'MFVideoTransFunc_28', 'TvRat_13', 'EnTvRat_GenericLevel',
    'tagCABSTR', 'IEnumMSVidGraphSegment', 'dvdMenu_Title',
    'tag_inner_PROPVARIANT', 'TvRat_9', 'IMSVidGenericSink2',
    'BDA_BCC_RATE_1_3', 'MSVidAnalogTunerDevice',
    'MFVideoChromaSubsampling_MPEG2', 'IMSVidEVREvent',
    'IMSVidFeature', 'tagCAI', 'MFVideoTransFunc_sRGB',
    'IComponentTypes', '_SHORT_SIZEDARR', 'MSVidVMR9', 'BDA_MOD_BPSK',
    'dvdSPExt_DirectorComments_Children', 'TvRat_SystemDontKnow',
    'MFVideoTransFunc_240M', 'TvRat_21', 'IStorage',
    '_MFVideoLighting', 'dvdStream_Angle', '__MIDL_IWinTypes_0009',
    'BDA_MOD_32APSK', 'dvdMenu_Root', 'MFVP_MESSAGE_TYPE',
    '__MIDL_IOleAutomationTypes_0005', 'MFVideoTransFunc_22',
    'IMSVidFilePlaybackEvent', 'dvdSPExt_CC_Children',
    'MSVidVideoRenderer', 'tagCADBL', 'IReferenceClock',
    'dvdTitle_Movie', 'IMSVidAudioRendererEvent', 'State_Running',
    'MFNominalRange_Wide', 'IMSVidWebDVD', 'MFVideoTransFunc_2020',
    'IMSVidGraphSegmentContainer', 'BDA_FEC_METHOD_NOT_DEFINED',
    'BDA_MOD_MAX', 'dslQuarterScreen',
    'MFVideoTransferMatrix_Identity',
    'MFVideoChromaSubsampling_DV_PAL', 'MFVideoTransFunc_HLG',
    'Reserved7', 'MSVidEncoderToStreamBufferSink',
    'MFVideoPrimaries_SMPTE_C', 'dslHalfSourceSize',
    'IMSVidStreamBufferSinkEvent2', 'TenthsSecondsMode',
    'MFVideoPrimaries_BT470_2_SysM',
    'MFVideoChromaSubsampling_ProgressiveChroma',
    '_MFVideoTransferMatrix', 'MPAA', 'IMSVidAnalogTunerEvent',
    'MSVidCCA', '_MF_ATTRIBUTES_MATCH_TYPE', 'BDA_BCC_RATE_2_3',
    'MFVideoInterlace_FieldInterleavedLowerFirst', 'CategoryData',
    'TvRat_12', 'CATEGORY_COUNT', 'StatusInactive',
    'MSVidCCAToStreamBufferSink', 'dvdStream_Audio',
    '_MFNominalRange', 'IMSVidStreamBufferSinkEvent', 'TvRat_17',
    'dslSixteenthScreen', 'tagCABOOL', '_VMRVIDEOSTREAMINFO',
    '_MFVIDEOFORMAT', 'MSVidVideoPlaybackDevice',
    'MFVP_MESSAGE_ENDSTREAMING', 'IGraphBuilder', 'IComponentType',
    'BDA_MOD_896QAM', 'BDA_MOD_ISDB_T_TMCC', 'CategoryVideo',
    'BDA_BCC_RATE_4_5', 'MFVideoTransferMatrix_Unknown',
    'IMSVidInputDevice', 'MFNominalRange_Unknown', '_PinDirection',
    'IMSVidStreamBufferSourceEvent3', 'BfIsAttr_1',
    '_wireSAFEARR_VARIANT', 'MFNominalRange_0_255',
    'MSVidAnalogCaptureToOverlayMixer', 'dvdGeneral_Name',
    'BDA_MOD_NBC_8PSK', 'MSVidDataServicesToXDS',
    'MFVideoPrimaries_EBU3213', 'IEnumComponentTypes',
    'MSVidStreamBufferSource', 'BDA_BCC_RATE_3_4', 'IEnumComponents',
    '_MFPaletteEntry', 'MSVidSink_Video', 'IMSVidClosedCaptioning3',
    'tagCAPROPVARIANT', 'MFVideoTransFunc_2084', '_LONG_SIZEDARR',
    'IMFAttributes', 'STATE_PLAY', 'DisplaySizeList', 'tagCAUH',
    'MFVideoInterlace_ForceDWORD', 'dvdTitle_Series',
    'MFVideoTransFunc_26', 'Caption2', 'IMSVidPlayback',
    'IEnumString', 'MFVideoTransFunc_10_rel', 'dvdTitle_Song',
    'IMSVidStreamBufferSink', 'IMSVidStreamBufferSource2',
    'MSVidSEG_SOURCE', 'PBDA', 'BfIsAttr_5', 'IMSVidDevice',
    'IMSVidVMR9', 'IMSVidDeviceEvent', '_MFVideoSurfaceInfo',
    'MSVidStreamBufferRecordingControl', 'IMSVidWebDVDEvent',
    'IMSVidEncoder', 'TvRat_LevelDontKnow', 'dvdSPExt_Forced',
    'MSVidSBESourceToGenericSink', 'IEnumMoniker',
    'MFVideoPrimaries_BT709', 'BDA_MOD_8PSK',
    '_MFVideoChromaSubsampling', 'MFVideoTransFunc_BT1361_ECG',
    'MFVideoInterlace_FieldSingleUpper', 'BDA_FEC_RS_147_130',
    '_wireSAFEARRAY', 'MF_ATTRIBUTE_STRING', 'tagVMRALLOCATIONINFO',
    'MF_ATTRIBUTE_GUID', 'MF_ATTRIBUTES_MATCH_INTERSECTION',
    'ComponentStatus', 'MSVidWebDVDToAudioRenderer',
    'dvdStruct_ParentalID', 'CategorySubtitles',
    'BDA_MOD_ANALOG_FREQUENCY', 'MSVidInputDevice', 'sslFullSize',
    'MFVideoPrimaries_BT2020', 'BDA_MOD_640QAM', 'IMFVideoMediaType',
    'MFVideoPrimaries_Last', 'MFNominalRange_48_208',
    'dvdTitle_Orig_Movie', 'dvdTitle_Sub_Other',
    '_wireSAFEARR_BRECORD', 'MSVidGenericComposite', 'dvdTitle_Video',
    'BDA_BCC_RATE_7_8', 'MSVidDevice', 'REFERENCE', 'tagCAUB',
    'dslHalfScreen', 'MFVideoTransFunc_ForceDWORD',
    'MFVideoTransferMatrix_SMPTE2085', 'TvRat_4', 'MSVidDataServices',
    'None_', 'tagCALPSTR', 'TvRat_18', 'IEnumSTATSTG', 'TvRat_1',
    'dvdSPExt_DirectorComments_Big', 'MSVidGenericSink',
    'BDA_MOD_DIRECTV', 'MSVidITVToStreamBufferSink',
    'IMSVidGenericSink', 'MFVideoTransferMatrix_ForceDWORD',
    'IMSVidOutputDevice', 'FECMethod', 'BDA_MOD_448QAM',
    'MFVideoTransferMatrix_Chroma', 'MFNominalRange_16_235',
    'MSVidSegmentType', 'IMSVidTunerEvent',
    '_MFVideoTransferFunction', 'TvRat_10', 'MSVidSEG_XFORM',
    'dvdTitle_Sub_Song', 'wireHDC', '_wireVARIANT', '_wireBRECORD',
    'Text1', 'IMSVidVideoRendererDevices', 'System5', 'LONG_PTR',
    'MSVidCtlStateList', 'IMSVidStreamBufferSinkEvent4',
    'MFVideoTransFunc_2020_const', '_PinInfo',
    'MFVideoTransferMatrix_Last', 'BinaryConvolutionCodeRate',
    'MFVideoPrimaries_ACES', 'BDA_MOD_16QAM', 'BDA_BCC_RATE_NOT_SET',
    'MFVideoTransFunc_10', 'IEnumGUID', '_IMSVidCtlEvents',
    'MSVidStreamBufferV2Source', '__MIDL_IOleAutomationTypes_0001',
    'BDA_MOD_OQPSK', 'IMSVidAnalogTuner', 'IMSVidAudioRenderer',
    'BDA_FEC_BCH', 'ModulationType', 'MFVideoTransFunc_709_sym',
    'MFVideoInterlace_MixedInterlaceOrProgressive', 'BDA_MOD_224QAM',
    'sslClipByOverScan', 'PINDIR_OUTPUT', 'MFVideoInterlace_Unknown',
    'MFVideoInterlace_Last', 'MFVideoLighting_bright',
    'BDA_MOD_96QAM', 'MSVidFilePlaybackToVideoRenderer',
    'RecordingType', 'FrameMode', 'MFVideoTransFunc_Unknown',
    'BDA_BCC_RATE_3_5', 'tagCACY', 'MSVidBDATunerDevice',
    'MFVideoPrimaries_SMPTE240M', 'ITuningSpace', 'tagBSTRBLOB',
    'CONTENT', 'MF_ATTRIBUTE_UINT32', '_FilterInfo', 'tagCAFILETIME',
    'MSVidClosedCaptioningSI', 'MFVideoLighting_Unknown',
    'MFVideoTransFunc_Log_100', 'IMSVidFilePlayback2',
    'IMSVidInputDeviceEvent', 'IMSVidCtl', 'MSVidAnalogCaptureToXDS',
    'MFVideoInterlace_Progressive', 'Canadian_English',
    'ITuneRequest', 'MFVideoPrimaries_SMPTE170M',
    'MSVidAudioRenderer', 'MFVideoTransferMatrix_BT709', 'MSVidXDS',
    '__MFAYUVSample', 'TvRat_kSystems', 'STATE_PAUSE', 'tagCAUI',
    'MSVidCCToVMR', 'MFVideoTransferMatrix_SMPTE240M', 'BDA_MOD_8VSB',
    'MFVideoLighting_ForceDWORD', 'IVMRMixerBitmap',
    'MFVideoPrimaries_DCI_P3', 'IMSVidStreamBufferSourceEvent',
    'MFVideoTransferMatrix_BT2020_12', 'BDA_MOD_ANALOG_AMPLITUDE',
    'IMSVidAnalogTuner2', 'BDA_MOD_16APSK', 'MFNominalRange_Normal',
    'TvRat_6', 'BfIsAttr_6', 'BDA_BCC_RATE_5_11', 'MSVidSink_Audio',
    'dslDoubleSourceSize', 'dvdOther_Scene',
    'MSVidDigitalCaptureToStreamBufferSink',
    'MFVideoChromaSubsampling_Unknown', 'dvdSPExt_Caption_Big',
    'MFVideoPrimaries_reserved', 'BDA_BCC_RATE_1_2', 'TvRat_Unblock',
    'CategoryCaptions', 'MFNominalRange_64_127', 'MSVidWebDVD',
    '_FLAGGED_WORD_BLOB', 'STATE_UNBUILT', 'BDA_BCC_RATE_5_6',
    'IMSVidStreamBufferSinkEvent3', 'MF_ATTRIBUTES_MATCH_OUR_ITEMS',
    'dvdTitle_Sub_Album', 'IMSVidStreamBufferRecordingControl',
    'IMSVidTuner', 'dslSourceSize', 'IMSVidVideoRendererEvent',
    'MFVideoTransferMatrix_YCgCo', 'MSVidITVPlayback',
    'MFVideoChromaSubsampling_Cosited', 'MSVidWebDVDToVideoRenderer',
    'IMSVidDataServices', 'TvRat_7', 'ILocator', 'TvRat_2',
    '_NORMALIZEDRECT', 'IMSVidStreamBufferSink3', 'tagCALPWSTR',
    'BfValidAttrSubmask', 'tagSTATSTG', 'MFVP_MESSAGE_CANCELSTEP',
    'dvdTitle_Sub_Video', 'dvdSPExt_NotSpecified',
    'dvdSPExt_CC_Normal', '_wireSAFEARRAY_UNION', 'TvRat_3',
    'MSVidDevice2', 'MSVidSink_Other', 'dvdTitle_Orig_Album',
    'IEnumMediaTypes', 'IPersistStream',
    'MFVideoTransferMatrix_ICtCp', 'MSVidDigitalCaptureToITV',
    'STATE_STOP', 'MSEventBinder', 'tagCADATE',
    'MSVidAnalogTVToEncoder', 'TvRat_kLevels', 'StatusUnavailable',
    'EnTvRat_System', 'dvdMenu_Chapter', 'BDA_MOD_160QAM',
    'Reserved4', 'MSVidDataServicesToStreamBufferSink', 'tagCACLSID',
    'IBindCtx', 'MSVidCCToAR', '_MFVideoInfo', 'MSVidOutputDevices',
    'MFVideoTransFunc_Log_316', 'MF_ATTRIBUTE_DOUBLE',
    'tagCABSTRBLOB', 'MSVidStreamBufferSink', 'tagRemSNB',
    'IMSVidRect', 'Canadian_French', 'BDA_BCC_RATE_6_7',
    'MFVP_MESSAGE_ENDOFSTREAM', 'System6', 'IMoniker',
    'DVDTextStringType', 'Text2', 'MFVP_MESSAGE_INVALIDATEMEDIATYPE',
    'BDA_MOD_32QAM', '_MFVideoInterlaceMode',
    'MFVideoChromaSubsampling_Horizontally_Cosited',
    'BDA_BCC_RATE_MAX', 'MFNominalRange_ForceDWORD', 'BDA_MOD_192QAM',
    'IMSVidClosedCaptioning', 'IMSVidFilePlayback',
    '_wireSAFEARR_DISPATCH', 'MF_ATTRIBUTE_IUNKNOWN',
    'MFVideoLighting_dark', 'IBaseFilter', 'dvdSPExt_CC_Big',
    'dvdTitle_Orig_Song', 'BfAttrNone', 'IMSVidWebDVDAdm',
    'IFilterGraph', 'dvdStream_Subpicture', 'dvdStruct_Title',
    'CategoryNotSet', 'IMSVidXDSEvent', 'CategorySuperimpose',
    'MFVideoChromaSubsampling_Last', 'DVDSPExt', 'MFVP_MESSAGE_STEP',
    'MSVidSinkStreams', 'IMSVidStreamBufferSource',
    'tagVersionedStream', 'US_TV', 'MSVidITVCapture',
    'dvdStruct_Cell', 'MFVideoPrimaries_ForceDWORD',
    '_HYPER_SIZEDARR', 'State_Paused', '_wireSAFEARR_UNKNOWN',
    'CategoryAudio', 'wireSNB', 'BDA_MOD_80QAM', 'MSVidCCService',
    'MFVideoPrimaries_XYZ', 'IMSVidVideoInputDevice',
    'MFVideoTransferMatrix_BT601', 'TvRat_15',
    'dvdSPExt_DirectorComments_Normal', 'IMSVidEVR', 'IMSVidDevice2',
    '__MIDL_IOleAutomationTypes_0006', 'TvRat_16', 'TvRat_11',
    'BDA_MOD_QPSK', 'IMFClockStateSink',
    'MF_ATTRIBUTES_MATCH_THEIR_ITEMS', 'dvdTitle_Orig_Series',
    'dvdTitle_Album', 'dvdTitle_Orig_Video', 'BDA_FEC_LDPC',
    'MSVidAnalogCaptureToDataServices', 'dvdSPExt_Caption_Children',
    'MFVideoTransferMatrix_BT2020_10', 'dvdOther_Cut', '_MFARGB',
    'MSVidSEG_DEST', 'BDA_MOD_768QAM', 'MFVideoPrimaries_Unknown',
    'State_Stopped', 'MFVideoTransFunc_709', 'tagCAUL',
    'dslFullScreen', 'DDCOLORKEY', 'MF_ATTRIBUTES_MATCH_ALL_ITEMS',
    'MF_ATTRIBUTE_BLOB', 'MSVidRect',
    'MSVidStreamBufferSourceToVideoRenderer', 'BDA_BCC_RATE_9_10',
    'MFVideoChromaSubsampling_Vertically_Cosited',
    'MFVP_MESSAGE_BEGINSTREAMING', 'MSVidAudioRendererDevices',
    'BDA_FEC_MAX', '_MF_ATTRIBUTE_TYPE', 'MFNominalRange_Last',
    '_MFVideoArea', 'MFVideoInterlace_FieldInterleavedUpperFirst',
    'IMSVidStreamBufferSourceEvent2', 'dvdOther_Take',
    'MSVidFeatures', '_RemotableHandle', 'BDA_FEC_METHOD_NOT_SET',
    'IMSEventBinder', 'BfEnTvRat_GenericAttributes',
    'IVMRSurfaceAllocator', 'MSVidAnalogCaptureToCCA', 'MSVidCtl',
    'BfIsAttr_2', 'BDA_MOD_RF', 'AgeBased', 'tagCAH',
    '_wireSAFEARR_BSTR', 'MFVideoTransferMatrix_FCC47',
    'BDA_MOD_384QAM', 'IMSVidStreamBufferV2SourceEvent',
    'IComponents', 'dvdTitle_Other', 'tagCAL',
    'MSVidAnalogCaptureToStreamBufferSink', '_MFVideoCompressedInfo',
    'IEnumFilters', 'MSVidSBESourceToITV', 'IMSVidOutputDevices',
    'BDA_MOD_112QAM', 'TvRat_20', 'MSVidEncoder',
    'MFVideoLighting_dim', 'MFVideoInterlace_FieldSingleLower',
    'BDA_MOD_64QAM', 'BDA_BCC_RATE_1_4', 'MSVidEVR', 'BfIsBlocked',
    'MFVP_MESSAGE_FLUSH', 'MFVideoLighting_Last',
    '_wireSAFEARR_HAVEIID', 'IPin', 'BDA_MOD_NOT_DEFINED',
    'dvdMenu_Subpicture', 'wirePSAFEARRAY', 'IMSVidGraphSegment'
]

_check_version('1.4.11', 1757470690.344277)

