# -*- coding: mbcs -*-

from ctypes import *
from ctypes.wintypes import _FILETIME
import comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0
from comtypes import CoClass, COMMETHOD, GUID, IUnknown
from ctypes import HRESULT
from comtypes.automation import VARIANT
from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from comtypes import hints


_lcid = 0  # change this if required
typelib_path = 'c:\\Users\\Lindsay\\source\\repos\\MultiworldGG\\src\\worlds\\poe\\poeClient\\vendor\\pyttsx3\\comtypes\\test\\urlhist.tlb'
WSTRING = c_wchar_p

# values for enumeration '_ADDURL_FLAG'
ADDURL_FIRST = 0
ADDURL_ADDTOHISTORYANDCACHE = 0
ADDURL_ADDTOCACHE = 1
ADDURL_Max = 2147483647
_ADDURL_FLAG = c_int  # enum

# values for enumeration '_STATURLFLAG'
STATURL_QUERYFLAG_ISCACHED = 65536
STATURL_QUERYFLAG_NOURL = 131072
STATURL_QUERYFLAG_NOTITLE = 262144
STATURL_QUERYFLAG_TOPLEVEL = 524288
STATURLFLAG_ISCACHED = 1
STATURLFLAG_ISTOPLEVEL = 2
_STATURLFLAG = c_int  # enum



class IUrlHistoryStg(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    _case_insensitive_ = True
    _iid_ = GUID('{3C374A41-BAE4-11CF-BF7D-00AA006946EE}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def AddUrl(self, pocsUrl: hints.Incomplete, pocsTitle: hints.Incomplete, dwFlags: hints.Incomplete) -> hints.Hresult: ...
        def DeleteUrl(self, pocsUrl: hints.Incomplete, dwFlags: hints.Incomplete) -> hints.Hresult: ...
        def QueryUrl(self, pocsUrl: hints.Incomplete, dwFlags: hints.Incomplete, lpSTATURL: hints.Incomplete) -> hints.Incomplete: ...
        def BindToObject(self, pocsUrl: hints.Incomplete, riid: hints.Incomplete) -> hints.Incomplete: ...
        def EnumUrls(self) -> 'IEnumSTATURL': ...


class _STATURL(Structure):
    pass


class IEnumSTATURL(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    _case_insensitive_ = True
    _iid_ = GUID('{3C374A42-BAE4-11CF-BF7D-00AA006946EE}')
    _idlflags_ = []

    def __iter__(self):
        return self

    def __next__(self):
        item, fetched = self.Next(1)
        if fetched:
            return item
        raise StopIteration

    def __getitem__(self, index):
        self.Reset()
        self.Skip(index)
        item, fetched = self.Next(1)
        if fetched:
            return item
        raise IndexError(index)

    if TYPE_CHECKING:  # commembers
        def Next(self, celt: hints.Incomplete, rgelt: hints.Incomplete, pceltFetched: hints.Incomplete) -> hints.Tuple[hints.Incomplete, hints.Incomplete]: ...
        def Skip(self, celt: hints.Incomplete) -> hints.Hresult: ...
        def Reset(self) -> hints.Hresult: ...
        def Clone(self) -> 'IEnumSTATURL': ...
        def SetFilter(self, poszFilter: hints.Incomplete, dwFlags: hints.Incomplete) -> hints.Hresult: ...


IUrlHistoryStg._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'AddUrl',
        (['in'], WSTRING, 'pocsUrl'),
        (['in'], WSTRING, 'pocsTitle'),
        (['in'], c_ulong, 'dwFlags')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'DeleteUrl',
        (['in'], WSTRING, 'pocsUrl'),
        (['in'], c_ulong, 'dwFlags')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'QueryUrl',
        (['in'], WSTRING, 'pocsUrl'),
        (['in'], c_ulong, 'dwFlags'),
        (['in', 'out'], POINTER(_STATURL), 'lpSTATURL')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'BindToObject',
        (['in'], WSTRING, 'pocsUrl'),
        (
            ['in'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'riid',
        ),
        (['out'], POINTER(c_void_p), 'ppvOut')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'EnumUrls',
        (['out'], POINTER(POINTER(IEnumSTATURL)), 'ppenum')
    ),
]

################################################################
# code template for IUrlHistoryStg implementation
# class IUrlHistoryStg_Impl(object):
#     def AddUrl(self, pocsUrl, pocsTitle, dwFlags):
#         '-no docstring-'
#         #return 
#
#     def DeleteUrl(self, pocsUrl, dwFlags):
#         '-no docstring-'
#         #return 
#
#     def QueryUrl(self, pocsUrl, dwFlags):
#         '-no docstring-'
#         #return lpSTATURL
#
#     def BindToObject(self, pocsUrl, riid):
#         '-no docstring-'
#         #return ppvOut
#
#     def EnumUrls(self):
#         '-no docstring-'
#         #return ppenum
#


class _tagOLECMD(Structure):
    pass


_tagOLECMD._fields_ = [
    ('cmdID', c_ulong),
    ('cmdf', c_ulong),
]

# The size provided by the typelib is incorrect.
# The size and alignment check for _tagOLECMD is skipped.


class Library(object):
    """type library built from urlhist.idl"""
    name = 'urlhistLib'
    _reg_typelib_ = ('{33E3A78D-5470-4320-8486-2339BA19C4EE}', 1, 0)


IEnumSTATURL._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'Next',
        (['in'], c_ulong, 'celt'),
        (['in', 'out'], POINTER(_STATURL), 'rgelt'),
        (['in', 'out'], POINTER(c_ulong), 'pceltFetched')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Skip',
        (['in'], c_ulong, 'celt')
    ),
    COMMETHOD([], HRESULT, 'Reset'),
    COMMETHOD(
        [],
        HRESULT,
        'Clone',
        (['out'], POINTER(POINTER(IEnumSTATURL)), 'ppenum')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'SetFilter',
        (['in'], WSTRING, 'poszFilter'),
        (['in'], c_ulong, 'dwFlags')
    ),
]

################################################################
# code template for IEnumSTATURL implementation
# class IEnumSTATURL_Impl(object):
#     def Next(self, celt):
#         '-no docstring-'
#         #return rgelt, pceltFetched
#
#     def Skip(self, celt):
#         '-no docstring-'
#         #return 
#
#     def Reset(self):
#         '-no docstring-'
#         #return 
#
#     def Clone(self):
#         '-no docstring-'
#         #return ppenum
#
#     def SetFilter(self, poszFilter, dwFlags):
#         '-no docstring-'
#         #return 
#


class IOleCommandTarget(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.IUnknown):
    _case_insensitive_ = True
    _iid_ = GUID('{B722BCCB-4E68-101B-A2BC-00AA00404770}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def QueryStatus(self, pguidCmdGroup: hints.Incomplete, cCmds: hints.Incomplete, prgCmds: hints.Incomplete, pCmdText: hints.Incomplete) -> hints.Tuple[hints.Incomplete, hints.Incomplete]: ...
        def Exec(self, pguidCmdGroup: hints.Incomplete, nCmdID: hints.Incomplete, nCmdexecopt: hints.Incomplete, pvaIn: hints.Incomplete, pvaOut: hints.Incomplete) -> hints.Incomplete: ...


class _tagOLECMDTEXT(Structure):
    pass


IOleCommandTarget._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'QueryStatus',
        (
            ['in'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'pguidCmdGroup',
        ),
        (['in'], c_ulong, 'cCmds'),
        (['in', 'out'], POINTER(_tagOLECMD), 'prgCmds'),
        (['in', 'out'], POINTER(_tagOLECMDTEXT), 'pCmdText')
    ),
    COMMETHOD(
        [],
        HRESULT,
        'Exec',
        (
            ['in'],
            POINTER(comtypes.gen._00020430_0000_0000_C000_000000000046_0_2_0.GUID),
            'pguidCmdGroup',
        ),
        (['in'], c_ulong, 'nCmdID'),
        (['in'], c_ulong, 'nCmdexecopt'),
        (['in'], POINTER(VARIANT), 'pvaIn'),
        (['in', 'out'], POINTER(VARIANT), 'pvaOut')
    ),
]

################################################################
# code template for IOleCommandTarget implementation
# class IOleCommandTarget_Impl(object):
#     def QueryStatus(self, pguidCmdGroup, cCmds):
#         '-no docstring-'
#         #return prgCmds, pCmdText
#
#     def Exec(self, pguidCmdGroup, nCmdID, nCmdexecopt, pvaIn):
#         '-no docstring-'
#         #return pvaOut
#


class UrlHistory(CoClass):
    """UrlHistory Class"""
    _reg_clsid_ = GUID('{3C374A40-BAE4-11CF-BF7D-00AA006946EE}')
    _idlflags_ = []
    _typelib_path_ = typelib_path
    _reg_typelib_ = ('{33E3A78D-5470-4320-8486-2339BA19C4EE}', 1, 0)


UrlHistory._com_interfaces_ = [IUrlHistoryStg]


class IUrlHistoryStg2(IUrlHistoryStg):
    _case_insensitive_ = True
    _iid_ = GUID('{AFA0DC11-C313-11D0-831A-00C04FD5AE38}')
    _idlflags_ = []

    if TYPE_CHECKING:  # commembers
        def AddUrlAndNotify(self, pocsUrl: hints.Incomplete, pocsTitle: hints.Incomplete, dwFlags: hints.Incomplete, fWriteHistory: hints.Incomplete, poctNotify: hints.Incomplete, punkISFolder: hints.Incomplete) -> hints.Hresult: ...
        def ClearHistory(self) -> hints.Hresult: ...


IUrlHistoryStg2._methods_ = [
    COMMETHOD(
        [],
        HRESULT,
        'AddUrlAndNotify',
        (['in'], WSTRING, 'pocsUrl'),
        (['in'], WSTRING, 'pocsTitle'),
        (['in'], c_ulong, 'dwFlags'),
        (['in'], c_int, 'fWriteHistory'),
        (['in'], POINTER(IOleCommandTarget), 'poctNotify'),
        (['in'], POINTER(IUnknown), 'punkISFolder')
    ),
    COMMETHOD([], HRESULT, 'ClearHistory'),
]

################################################################
# code template for IUrlHistoryStg2 implementation
# class IUrlHistoryStg2_Impl(object):
#     def AddUrlAndNotify(self, pocsUrl, pocsTitle, dwFlags, fWriteHistory, poctNotify, punkISFolder):
#         '-no docstring-'
#         #return 
#
#     def ClearHistory(self):
#         '-no docstring-'
#         #return 
#

_tagOLECMDTEXT._fields_ = [
    ('cmdtextf', c_ulong),
    ('cwActual', c_ulong),
    ('cwBuf', c_ulong),
    ('rgwz', POINTER(c_ushort)),
]

# The size provided by the typelib is incorrect.
# The size and alignment check for _tagOLECMDTEXT is skipped.


class IUrlHistoryNotify(IOleCommandTarget):
    _case_insensitive_ = True
    _iid_ = GUID('{BC40BEC1-C493-11D0-831B-00C04FD5AE38}')
    _idlflags_ = []


IUrlHistoryNotify._methods_ = [
]

################################################################
# code template for IUrlHistoryNotify implementation
# class IUrlHistoryNotify_Impl(object):

_STATURL._fields_ = [
    ('cbSize', c_ulong),
    ('pwcsUrl', WSTRING),
    ('pwcsTitle', WSTRING),
    ('ftLastVisited', _FILETIME),
    ('ftLastUpdated', _FILETIME),
    ('ftExpires', _FILETIME),
    ('dwFlags', c_ulong),
]

# The size provided by the typelib is incorrect.
# The size and alignment check for _STATURL is skipped.

__all__ = [
    '_tagOLECMD', 'ADDURL_Max', 'ADDURL_ADDTOCACHE',
    'STATURL_QUERYFLAG_ISCACHED', 'STATURL_QUERYFLAG_NOURL',
    'IEnumSTATURL', 'IOleCommandTarget', '_tagOLECMDTEXT',
    'ADDURL_FIRST', 'STATURLFLAG_ISTOPLEVEL',
    'STATURL_QUERYFLAG_NOTITLE', 'typelib_path',
    'ADDURL_ADDTOHISTORYANDCACHE', 'STATURL_QUERYFLAG_TOPLEVEL',
    'STATURLFLAG_ISCACHED', 'IUrlHistoryStg2', '_STATURL',
    'IUrlHistoryNotify', '_ADDURL_FLAG', '_STATURLFLAG', 'UrlHistory',
    'Library', 'IUrlHistoryStg'
]


