class CCRoom:
    pantry = "Pantry"
    crafts_room = "Crafts Room"
    fish_tank = "Fish Tank"
    bulletin_board = "Bulletin Board"
    vault = "Vault"
    boiler_room = "Boiler Room"
    abandoned_joja_mart = "Abandoned Joja Mart"
    raccoon_requests = "Raccoon Requests"


all_cc_bundle_names = []
all_meme_bundle_names = []


def name_bundle(name: str) -> str:
    return f"{name} Bundle"


def register_bundle(bundle_name: str, is_meme: bool = False) -> str:
    all_cc_bundle_names.append(bundle_name)
    if is_meme:
        all_meme_bundle_names.append(bundle_name)
    return bundle_name


def cc_bundle(name: str, is_meme: bool = False) -> str:
    full_name = name_bundle(name)
    register_bundle(full_name, is_meme)
    # print(full_name)
    return full_name


def meme_bundle(name: str) -> str:
    return cc_bundle(name, True)


class BundleName:
    spring_foraging = cc_bundle("Spring Foraging")
    summer_foraging = cc_bundle("Summer Foraging")
    fall_foraging = cc_bundle("Fall Foraging")
    winter_foraging = cc_bundle("Winter Foraging")
    construction = cc_bundle("Construction")
    exotic_foraging = cc_bundle("Exotic Foraging")
    beach_foraging = cc_bundle("Beach Foraging")
    mines_foraging = cc_bundle("Mines Foraging")
    desert_foraging = cc_bundle("Desert Foraging")
    island_foraging = cc_bundle("Island Foraging")
    sticky = cc_bundle("Sticky")
    forest = cc_bundle("Forest")
    green_rain = cc_bundle("Green Rain")
    totems = cc_bundle("Totems")
    wild_medicine = cc_bundle("Wild Medicine")
    quality_foraging = cc_bundle("Quality Foraging")
    spring_crops = cc_bundle("Spring Crops")
    summer_crops = cc_bundle("Summer Crops")
    fall_crops = cc_bundle("Fall Crops")
    quality_crops = cc_bundle("Quality Crops")
    animal = cc_bundle("Animal")
    artisan = cc_bundle("Artisan")
    rare_crops = cc_bundle("Rare Crops")
    fish_farmer = cc_bundle("Fish Farmer's")
    garden = cc_bundle("Garden")
    brewer = cc_bundle("Brewer's")
    orchard = cc_bundle("Orchard")
    island_crops = cc_bundle("Island Crops")
    agronomist = cc_bundle("Agronomist's")
    slime_farmer = cc_bundle("Slime Farmer")
    sommelier = cc_bundle("Sommelier")
    dry = cc_bundle("Dry")
    river_fish = cc_bundle("River Fish")
    lake_fish = cc_bundle("Lake Fish")
    ocean_fish = cc_bundle("Ocean Fish")
    night_fish = cc_bundle("Night Fishing")
    crab_pot = cc_bundle("Crab Pot")
    trash = cc_bundle("Trash")
    recycling = cc_bundle("Recycling")
    specialty_fish = cc_bundle("Specialty Fish")
    spring_fish = cc_bundle("Spring Fishing")
    summer_fish = cc_bundle("Summer Fishing")
    fall_fish = cc_bundle("Fall Fishing")
    winter_fish = cc_bundle("Winter Fishing")
    rain_fish = cc_bundle("Rain Fishing")
    quality_fish = cc_bundle("Quality Fish")
    master_fisher = cc_bundle("Master Fisher's")
    legendary_fish = cc_bundle("Legendary Fish")
    island_fish = cc_bundle("Island Fish")
    deep_fishing = cc_bundle("Deep Fishing")
    tackle = cc_bundle("Tackle")
    bait = cc_bundle("Master Baiter")
    specific_bait = cc_bundle("Specific Fishing")
    fish_smoker = cc_bundle("Fish Smoker")
    blacksmith = cc_bundle("Blacksmith's")
    geologist = cc_bundle("Geologist's")
    adventurer = cc_bundle("Adventurer's")
    treasure_hunter = cc_bundle("Treasure Hunter's")
    engineer = cc_bundle("Engineer's")
    demolition = cc_bundle("Demolition")
    paleontologist = cc_bundle("Paleontologist's")
    archaeologist = cc_bundle("Archaeologist's")
    chef = cc_bundle("Chef's")
    dye = cc_bundle("Dye")
    field_research = cc_bundle("Field Research")
    fodder = cc_bundle("Fodder")
    enchanter = cc_bundle("Enchanter's")
    children = cc_bundle("Children's")
    forager = cc_bundle("Forager's")
    home_cook = cc_bundle("Home Cook's")
    helper = cc_bundle("Helper's")
    spirit_eve = cc_bundle("Spirit's Eve")
    winter_star = cc_bundle("Winter Star")
    bartender = cc_bundle("Bartender's")
    calico = cc_bundle("Calico")
    raccoon = cc_bundle("Raccoon")
    money_2500 = cc_bundle("2,500g")
    money_5000 = cc_bundle("5,000g")
    money_10000 = cc_bundle("10,000g")
    money_25000 = cc_bundle("25,000g")
    gambler = cc_bundle("Gambler's")
    carnival = cc_bundle("Carnival")
    walnut_hunter = cc_bundle("Walnut Hunter")
    qi_helper = cc_bundle("Qi's Helper")
    missing_bundle = "The Missing Bundle"
    raccoon_fish = "Raccoon Fish"
    raccoon_artisan = "Raccoon Artisan"
    raccoon_food = "Raccoon Food"
    raccoon_foraging = "Raccoon Foraging"


class MemeBundleName:
    reconnection = meme_bundle("Reconnection")
    hint = meme_bundle("Hint")
    # colored_crystals = meme_bundle("Colored Crystals")
    catch_and_release = meme_bundle("Catch And Release")
    pollution = meme_bundle("Pollution")
    sacrifice = meme_bundle("Sacrifice")
    dr_seuss = meme_bundle("Dr Seuss")
    algorerhythm = meme_bundle("TheAlGoreRhythm")
    distracted = meme_bundle("Distracted")
    square_hole = meme_bundle("Square Hole")
    hairy = meme_bundle("Hairy")
    stanley = meme_bundle("Stanley")
    very_sticky = meme_bundle("Very Sticky")
    investment = meme_bundle("Investment")
    doctor = meme_bundle("Doctor")
    scam = meme_bundle("Scam")
    blossom_garden = meme_bundle("Blossom Garden")
    deathlink = meme_bundle("DeathLink")
    humble = meme_bundle("Humble")
    asmr = meme_bundle("ASMR")
    puzzle = meme_bundle("Puzzle")
    cooperation = meme_bundle("Cooperation")
    pomnut = meme_bundle("Pomnut")
    ministry_of_madness = meme_bundle("Ministry of Madness")
    loser_club = meme_bundle("Loser Club")
    frazzleduck = meme_bundle("Frazzleduck")
    argonmatrix = meme_bundle("ArgonMatrix")
    pool = meme_bundle("Pool")
    AAAA = meme_bundle("AAAA")
    amons_fall = meme_bundle("Amon's Fall")
    animal_well = meme_bundle("ANIMAL WELL")
    anything_for_beyonce = meme_bundle("Anything For Beyonce")
    archipela_go = meme_bundle("Archipela-Go!")
    automation = meme_bundle("Automation")
    bad_farmer = meme_bundle("Bad Farmer")
    bad_fisherman = meme_bundle("Bad Fisherman")
    balls = meme_bundle("Balls")
    big_grapes = meme_bundle("Big Grapes")
    bun_dle = register_bundle("Bun-dle", True)
    bundle = meme_bundle("Bundle")
    burger_king = meme_bundle("Burger King")
    burger_king_revenge = meme_bundle("Burger King's Revenge")
    caffeinated = meme_bundle("Caffeinated")
    cap = meme_bundle("Cap")
    capitalist = meme_bundle("Capitalist's")
    celeste = meme_bundle("Celeste")
    chaos_emerald = meme_bundle("Chaos Emerald")
    clickbait = meme_bundle("Clickbait")
    clique = meme_bundle("Clique")
    hibernation = meme_bundle("Hibernation")
    commitment = meme_bundle("Commitment")
    communism = meme_bundle("Communism")
    connection = meme_bundle("Connection")
    cookie_clicker = meme_bundle("Cookie Clicker")
    crab_rave = meme_bundle("Crab Rave")
    crap_pot = meme_bundle("Crap Pot")
    crowdfunding = meme_bundle("Crowdfunding")
    death = meme_bundle("Death")
    doctor_angler = meme_bundle("Doctor Angler")
    eg = meme_bundle("Eg")
    emmalution = meme_bundle("Emmalution")
    exhaustion = meme_bundle("Exhaustion")
    fast = meme_bundle("Fast")
    firstborn = meme_bundle("Firstborn")
    flashbang = meme_bundle("Flashbang")
    floor_is_lava = meme_bundle("The Floor Is Lava")
    fruit = meme_bundle("'Fruit'")
    gacha = meme_bundle("Gacha")
    hats_off_to_you = meme_bundle("Hats Off To You")
    honeywell = meme_bundle("Honeywell")
    honorable = meme_bundle("Honorable")
    hurricane_tortilla = meme_bundle("Hurricane Tortilla")
    ikea = meme_bundle("IKEA")
    joetg = meme_bundle("Joetg")
    journalist = meme_bundle("Journalist's")
    kent_c = meme_bundle("Kent C.")
    legendairy = meme_bundle("Legendairy")
    lemonade_stand = meme_bundle("Lemonade Stand")
    look_at_chickens = meme_bundle("Look At These Chickens")
    mermaid = meme_bundle("Mermaid")
    minecraft = meme_bundle("Minecraft")
    nft = meme_bundle("NFT")
    not_the_bees = meme_bundle("Not The Bees")
    obelisks = meme_bundle("Obelisks")
    off_your_back = meme_bundle("Off Your Back")
    permit_a38 = meme_bundle("Permit A38")
    potato = meme_bundle("Potato")
    restraint = meme_bundle("Restraint")
    reverse = meme_bundle("Reverse")
    rick = meme_bundle("Rick")
    romance = meme_bundle("Romance")
    sappy = meme_bundle("Sappy")
    schrodinger = meme_bundle("Schrodinger's")
    screw_you = meme_bundle("Screw You")
    sisyphus = meme_bundle("Sisyphus")
    smapi = meme_bundle("SMAPI")
    snitch = meme_bundle("Snitch")
    speedrunners = meme_bundle("Speedrunner's")
    sunmaid = meme_bundle("Sunmaid")
    this_is_fine = meme_bundle("This Is Fine")
    tick_tock = meme_bundle("Tick Tock")
    tilesanity = meme_bundle("Tilesanity")
    trap = meme_bundle("Trap")
    trout = meme_bundle("Trout")
    vampire = meme_bundle("Vampire")
    vocaloid = meme_bundle("Vocaloid")
    what_the_rock_is_cooking = meme_bundle("What The Rock Is Cooking")
