from typing import Any, Dict

from Options import Accessibility, ProgressionBalancing
from .options import IgnoreCleansing, AutoRun, DSSPatch, AlwaysAllowSpeedDash, IronMaidenBehavior, BuffRangedFamiliars,\
    BuffSubWeapons, BuffShooterStrength, ItemDropRandomization, HalveDSSCardsPlaced, Countdown, SubWeaponShuffle,\
    DisableBattleArenaMPDrain, RequiredSkirmishes, EarlyEscapeItem, CVCotMDeathLink, CompletionGoal, SkipDialogues,\
    NerfRocWing, SkipTutorials, BattleArenaMusic, PlutoGriffinAirSpeed

all_random_options = {
    "progression_balancing":         "random",
    "accessibility":                 "random",
    "ignore_cleansing":              "random",
    "auto_run":                      "random",
    "dss_patch":                     "random",
    "always_allow_speed_dash":       "random",
    "iron_maiden_behavior":          "random",
    "required_last_keys":            "random",
    "available_last_keys":           "random",
    "buff_ranged_familiars":         "random",
    "buff_sub_weapons":              "random",
    "buff_shooter_strength":         "random",
    "item_drop_randomization":       "random",
    "halve_dss_cards_placed":        "random",
    "countdown":                     "random",
    "sub_weapon_shuffle":            "random",
    "disable_battle_arena_mp_drain": "random",
    "required_skirmishes":           "random",
    "pluto_griffin_air_speed":       "random",
    "skip_dialogues":                "random",
    "skip_tutorials":                "random",
    "nerf_roc_wing":                 "random",
    "early_escape_item":             "random",
    "battle_arena_music":            "random",
    "death_link":                    CVCotMDeathLink.option_off,
    "completion_goal":               "random",
}

beginner_mode_options = {
    "progression_balancing":         ProgressionBalancing.default,
    "accessibility":                 Accessibility.option_full,
    "ignore_cleansing":              IgnoreCleansing.option_false,
    "auto_run":                      AutoRun.option_true,
    "dss_patch":                     DSSPatch.option_true,
    "always_allow_speed_dash":       AlwaysAllowSpeedDash.option_true,
    "iron_maiden_behavior":          IronMaidenBehavior.option_start_broken,
    "required_last_keys":            3,
    "available_last_keys":           6,
    "buff_ranged_familiars":         BuffRangedFamiliars.option_true,
    "buff_sub_weapons":              BuffSubWeapons.option_true,
    "buff_shooter_strength":         BuffShooterStrength.option_true,
    "item_drop_randomization":       ItemDropRandomization.option_normal,
    "halve_dss_cards_placed":        HalveDSSCardsPlaced.option_false,
    "countdown":                     Countdown.option_majors,
    "sub_weapon_shuffle":            SubWeaponShuffle.option_false,
    "disable_battle_arena_mp_drain": DisableBattleArenaMPDrain.option_true,
    "required_skirmishes":           RequiredSkirmishes.option_none,
    "pluto_griffin_air_speed":       PlutoGriffinAirSpeed.option_false,
    "skip_dialogues":                SkipDialogues.option_false,
    "skip_tutorials":                SkipTutorials.option_false,
    "nerf_roc_wing":                 NerfRocWing.option_false,
    "early_escape_item":             EarlyEscapeItem.option_double,
    "battle_arena_music":            BattleArenaMusic.option_nothing,
    "death_link":                    CVCotMDeathLink.option_off,
    "completion_goal":               CompletionGoal.option_dracula,
}

standard_competitive_options = {
    "progression_balancing":         ProgressionBalancing.default,
    "accessibility":                 Accessibility.option_full,
    "ignore_cleansing":              IgnoreCleansing.option_false,
    "auto_run":                      AutoRun.option_false,
    "dss_patch":                     DSSPatch.option_true,
    "always_allow_speed_dash":       AlwaysAllowSpeedDash.option_true,
    "iron_maiden_behavior":          IronMaidenBehavior.option_start_broken,
    "required_last_keys":            3,
    "available_last_keys":           5,
    "buff_ranged_familiars":         BuffRangedFamiliars.option_true,
    "buff_sub_weapons":              BuffSubWeapons.option_true,
    "buff_shooter_strength":         BuffShooterStrength.option_false,
    "item_drop_randomization":       ItemDropRandomization.option_normal,
    "halve_dss_cards_placed":        HalveDSSCardsPlaced.option_true,
    "countdown":                     Countdown.option_majors,
    "sub_weapon_shuffle":            SubWeaponShuffle.option_true,
    "disable_battle_arena_mp_drain": DisableBattleArenaMPDrain.option_false,
    "required_skirmishes":           RequiredSkirmishes.option_none,
    "pluto_griffin_air_speed":       PlutoGriffinAirSpeed.option_false,
    "skip_dialogues":                SkipDialogues.option_true,
    "skip_tutorials":                SkipTutorials.option_true,
    "nerf_roc_wing":                 NerfRocWing.option_false,
    "early_escape_item":             EarlyEscapeItem.option_double,
    "battle_arena_music":            BattleArenaMusic.option_nothing,
    "death_link":                    CVCotMDeathLink.option_off,
    "completion_goal":               CompletionGoal.option_dracula,
}

randomania_2023_options = {
    "progression_balancing":         ProgressionBalancing.default,
    "accessibility":                 Accessibility.option_full,
    "ignore_cleansing":              IgnoreCleansing.option_false,
    "auto_run":                      AutoRun.option_false,
    "dss_patch":                     DSSPatch.option_true,
    "always_allow_speed_dash":       AlwaysAllowSpeedDash.option_true,
    "iron_maiden_behavior":          IronMaidenBehavior.option_vanilla,
    "required_last_keys":            3,
    "available_last_keys":           5,
    "buff_ranged_familiars":         BuffRangedFamiliars.option_true,
    "buff_sub_weapons":              BuffSubWeapons.option_true,
    "buff_shooter_strength":         BuffShooterStrength.option_false,
    "item_drop_randomization":       ItemDropRandomization.option_normal,
    "halve_dss_cards_placed":        HalveDSSCardsPlaced.option_false,
    "countdown":                     Countdown.option_majors,
    "sub_weapon_shuffle":            SubWeaponShuffle.option_true,
    "disable_battle_arena_mp_drain": DisableBattleArenaMPDrain.option_false,
    "required_skirmishes":           RequiredSkirmishes.option_none,
    "pluto_griffin_air_speed":       PlutoGriffinAirSpeed.option_false,
    "skip_dialogues":                SkipDialogues.option_false,
    "skip_tutorials":                SkipTutorials.option_false,
    "nerf_roc_wing":                 NerfRocWing.option_false,
    "early_escape_item":             EarlyEscapeItem.option_double,
    "battle_arena_music":            BattleArenaMusic.option_nothing,
    "death_link":                    CVCotMDeathLink.option_off,
    "completion_goal":               CompletionGoal.option_dracula,
}

competitive_all_bosses_options = {
    "progression_balancing":         ProgressionBalancing.default,
    "accessibility":                 Accessibility.option_full,
    "ignore_cleansing":              IgnoreCleansing.option_false,
    "auto_run":                      AutoRun.option_false,
    "dss_patch":                     DSSPatch.option_true,
    "always_allow_speed_dash":       AlwaysAllowSpeedDash.option_true,
    "iron_maiden_behavior":          IronMaidenBehavior.option_vanilla,
    "required_last_keys":            8,
    "available_last_keys":           8,
    "buff_ranged_familiars":         BuffRangedFamiliars.option_true,
    "buff_sub_weapons":              BuffSubWeapons.option_true,
    "buff_shooter_strength":         BuffShooterStrength.option_false,
    "item_drop_randomization":       ItemDropRandomization.option_tiered,
    "halve_dss_cards_placed":        HalveDSSCardsPlaced.option_true,
    "countdown":                     Countdown.option_none,
    "sub_weapon_shuffle":            SubWeaponShuffle.option_true,
    "disable_battle_arena_mp_drain": DisableBattleArenaMPDrain.option_false,
    "required_skirmishes":           RequiredSkirmishes.option_all_bosses,
    "pluto_griffin_air_speed":       PlutoGriffinAirSpeed.option_false,
    "skip_dialogues":                SkipDialogues.option_true,
    "skip_tutorials":                SkipTutorials.option_true,
    "nerf_roc_wing":                 NerfRocWing.option_false,
    "early_escape_item":             EarlyEscapeItem.option_double,
    "battle_arena_music":            BattleArenaMusic.option_nothing,
    "death_link":                    CVCotMDeathLink.option_off,
    "completion_goal":               CompletionGoal.option_dracula,
}

hardcore_mode_options = {
    "progression_balancing":         ProgressionBalancing.default,
    "accessibility":                 Accessibility.option_minimal,
    "ignore_cleansing":              IgnoreCleansing.option_true,
    "auto_run":                      AutoRun.option_false,
    "dss_patch":                     DSSPatch.option_true,
    "always_allow_speed_dash":       AlwaysAllowSpeedDash.option_false,
    "iron_maiden_behavior":          IronMaidenBehavior.option_vanilla,
    "required_last_keys":            9,
    "available_last_keys":           9,
    "buff_ranged_familiars":         BuffRangedFamiliars.option_false,
    "buff_sub_weapons":              BuffSubWeapons.option_false,
    "buff_shooter_strength":         BuffShooterStrength.option_false,
    "item_drop_randomization":       ItemDropRandomization.option_tiered,
    "halve_dss_cards_placed":        HalveDSSCardsPlaced.option_true,
    "countdown":                     Countdown.option_none,
    "sub_weapon_shuffle":            SubWeaponShuffle.option_true,
    "disable_battle_arena_mp_drain": DisableBattleArenaMPDrain.option_false,
    "required_skirmishes":           RequiredSkirmishes.option_none,
    "pluto_griffin_air_speed":       PlutoGriffinAirSpeed.option_false,
    "skip_dialogues":                SkipDialogues.option_false,
    "skip_tutorials":                SkipTutorials.option_false,
    "nerf_roc_wing":                 NerfRocWing.option_false,
    "early_escape_item":             EarlyEscapeItem.option_double,
    "battle_arena_music":            BattleArenaMusic.option_nothing,
    "death_link":                    CVCotMDeathLink.option_off,
    "completion_goal":               CompletionGoal.option_battle_arena_and_dracula,
}

cvcotm_options_presets: Dict[str, Dict[str, Any]] = {
    "All Random": all_random_options,
    "Beginner Mode": beginner_mode_options,
    "Standard Competitive": standard_competitive_options,
    "Randomania 2023": randomania_2023_options,
    "Competitive All Bosses": competitive_all_bosses_options,
    "Hardcore Mode": hardcore_mode_options,
}
