from typing import List, Optional, NamedTuple, TYPE_CHECKING
from .Options import MagicantMode, ShopRandomizer

if TYPE_CHECKING:
    from . import EarthBoundWorld


class LocationData(NamedTuple):
    region: str
    name: str
    code: Optional[int]


def get_locations(world: "EarthBoundWorld") -> List[LocationData]:

    location_table: List[LocationData] = [
        LocationData("Northern Onett", "Onett - Tracy Gift", 0xEB0000),
        LocationData("Northern Onett", "Onett - Tracy's Room Present", 0xEB0001),
        LocationData("Northern Onett", "Onett - Hilltop Present", 0xEB0002),
        LocationData("Northern Onett", "Onett - Meteor Item", 0xEB0003),
        LocationData("Northern Onett", "Onett - Buzz Buzz", 0xEB0004),
        LocationData("Northern Onett", "Onett - Mani Mani Statue", 0xEB0005),
        LocationData("Onett", "Onett - Library Counter", 0xEB0006),
        LocationData("Onett", "Onett - Library Bookshelf", 0xEB0007),
        LocationData("Onett", "Onett - Burger Shop Trashcan", 0xEB0008),
        LocationData("Onett", "Onett - Treehouse Guy", 0xEB0009),
        LocationData("Onett", "Onett - South Road Present", 0xEB000A),
        LocationData("Onett", "Onett - Hotel Trashcan", 0xEB000B),
        LocationData("Onett", "Onett - Arcade Trashcan", 0xEB000C),
        LocationData("Onett", "Onett - Mayor Pirkle", 0xEB000D),
        LocationData("Onett", "Onett - Traveling Entertainer", 0xEB000E),
        LocationData("Giant Step", "Giant Step - First Cave Present", 0xEB000F),
        LocationData("Giant Step", "Giant Step - Floor 2 Cave Present", 0xEB0010),
        LocationData("Giant Step", "Giant Step - Floor 3 Present", 0xEB0011),
        LocationData("Twoson", "Twoson - Bike Shop Rental", 0xEB0012),
        LocationData("Twoson", "Twoson - Antique Shop", 0xEB0013),
        LocationData("Twoson", "Twoson - Paula's Room Present", 0xEB0014),
        LocationData("Twoson", "Twoson - Apple Kid Trashcan", 0xEB0015),
        LocationData("Twoson", "Twoson - South of Town Present", 0xEB0016),
        LocationData("Twoson", "Twoson - Orange Kid Donation", 0xEB0017),
        LocationData("Twoson", "Twoson - Apple Kid Invention", 0xEB0018),
        LocationData("Twoson", "Twoson - Apple Kid's Mouse", 0xEB0019),
        LocationData("Twoson", "Twoson - Paula's Mother", 0xEB001A),
        LocationData("Everdred's House", "Twoson - Everdred Meeting", 0xEB001B),
        LocationData("Twoson", "Twoson - Insignificant Location", 0xEB001C),
        LocationData("Peaceful Rest Valley", "Peaceful Rest Valley - Split Hill Present", 0xEB001D),
        LocationData("Peaceful Rest Valley", "Peaceful Rest Valley - Hill Nook Present", 0xEB001E),
        LocationData("Peaceful Rest Valley", "Peaceful Rest Valley - South of Bridge Present", 0xEB001F),
        LocationData("Peaceful Rest Valley", "Peaceful Rest Valley - Dead End Present", 0xEB0020),
        LocationData("Peaceful Rest Valley", "Peaceful Rest Valley - River Overlook Present", 0xEB0021),
        LocationData("Peaceful Rest Valley", "Peaceful Rest Valley - North Side Present", 0xEB0022),
        LocationData("Happy-Happy Village", "Happy-Happy Village - Donation Lady", 0xEB0023),
        LocationData("Happy-Happy HQ", "Happy-Happy Village - Right HQ Present", 0xEB0024),
        LocationData("Happy-Happy HQ", "Happy-Happy Village - Left HQ Present", 0xEB0025),
        LocationData("Happy-Happy Village", "Happy-Happy Village - Prisoner Item", 0xEB0026),
        LocationData("Happy-Happy Village", "Happy-Happy Village - Prisoner", 0xEB0027),
        LocationData("Happy-Happy HQ", "Happy-Happy Village - Defeat Carpainter", 0xEB0028),
        LocationData("Lilliput Steps", "Lilliput Steps - Southwest Pool Present", 0xEB0029),
        LocationData("Lilliput Steps", "Lilliput Steps - East Cliff Present", 0xEB002A),
        LocationData("Lilliput Steps", "Lilliput Steps - North Stream Present", 0xEB002B),
        LocationData("Boogey Tent", "Threed - Boogey Tent Trashcan", 0xEB002C),
        LocationData("Threed", "Threed - Cemetery Trashcan", 0xEB002D),
        LocationData("Threed", "Threed - Downtown Trashcan", 0xEB002E),
        LocationData("Threed", "Threed - East Side Trashcan", 0xEB002F),
        LocationData("Threed", "Threed - Northeast Shack Trashcan", 0xEB0030),
        LocationData("Threed", "Threed - Hospital Drawer", 0xEB0031),
        LocationData("Threed", "Threed - Zombie Prisoner", 0xEB0032),
        LocationData("Threed Underground", "Threed Underground - Left Coffin", 0xEB0033),
        LocationData("Threed Underground", "Threed Underground - Right Coffin", 0xEB0034),
        LocationData("Grapefruit Falls", "Grapefruit Falls - South Present", 0xEB0035),
        LocationData("Grapefruit Falls", "Grapefruit Falls - North Present", 0xEB0036),
        LocationData("Grapefruit Falls", "Grapefruit Falls - Saturn Cave Present", 0xEB0037),
        LocationData("Saturn Valley", "Saturn Valley - Ladder Present", 0xEB0038),
        LocationData("Saturn Valley", "Saturn Valley - Trashcan #1", 0xEB0039),
        LocationData("Saturn Valley", "Saturn Valley - Trashcan #2", 0xEB003A),
        LocationData("Saturn Valley", "Saturn Valley - Trashcan #3", 0xEB003B),
        LocationData("Upper Saturn Valley", "Saturn Valley - Saturn Coffee", 0xEB003C),
        LocationData("Saturn Valley", "Saturn Valley - Post Belch Gift #1", 0xEB003D),
        LocationData("Saturn Valley", "Saturn Valley - Post Belch Gift #2", 0xEB003E),
        LocationData("Saturn Valley", "Saturn Valley - Post Belch Gift #3", 0xEB003F),
        LocationData("Milky Well", "Milky Well - Cavern Present", 0xEB0040),
        LocationData("Belch's Factory", "Belch's Factory - Top Right Room Trashcan", 0xEB0041),
        LocationData("Belch's Factory", "Belch's Factory - Pit Room Trashcan #1", 0xEB0042),
        LocationData("Belch's Factory", "Belch's Factory - Pit Room Trashcan #2", 0xEB0043),
        LocationData("Belch's Factory", "Belch's Factory - Balcony Room Trashcan #1", 0xEB0044),
        LocationData("Belch's Factory", "Belch's Factory - Balcony Room Trashcan #2", 0xEB0045),
        LocationData("Belch's Factory", "Belch's Factory - Balcony Room Trashcan #3", 0xEB0046),
        LocationData("Dusty Dunes Desert", "Dusty Dunes - Northwest Corner Present", 0xEB0047),
        LocationData("Dusty Dunes Desert", "Dusty Dunes - South Side Present", 0xEB0048),
        LocationData("Dusty Dunes Desert", "Dusty Dunes - Surrounding Rocks Present", 0xEB0049),
        LocationData("Dusty Dunes Desert", "Dusty Dunes - Black Sesame Present", 0xEB004A),
        LocationData("Dusty Dunes Desert", "Dusty Dunes - Oasis Present", 0xEB004B),
        LocationData("Dusty Dunes Desert", "Dusty Dunes - Northeast Corner Present", 0xEB004C),
        LocationData("Dusty Dunes Desert", "Dusty Dunes - North Central Present", 0xEB004D),
        LocationData("Dusty Dunes Desert", "Dusty Dunes - Shining Spot", 0xEB004E),
        LocationData("Dusty Dunes Desert", "Dusty Dunes - East Peninsula Present", 0xEB004F),
        LocationData("Dusty Dunes Desert", "Dusty Dunes - Mine Reward", 0xEB0050),
        LocationData("Snow Wood Boarding School", "Snow Wood - Many Present Room Present #1", 0xEB0051),
        LocationData("Snow Wood Boarding School", "Snow Wood - Many Present Room Present #2", 0xEB0052),
        LocationData("Snow Wood Boarding School", "Snow Wood - Many Present Room Present #3", 0xEB0053),
        LocationData("Snow Wood Boarding School", "Snow Wood - Many Present Room Present #4", 0xEB0054),
        LocationData("Snow Wood Boarding School", "Snow Wood - Many Present Room Present #5", 0xEB0055),
        LocationData("Snow Wood Boarding School", "Snow Wood - Many Present Room Present #6", 0xEB0056),
        LocationData("Snow Wood Boarding School", "Snow Wood - Many Present Room Present #7", 0xEB0057),
        LocationData("Scaraba", "Scaraba - Snake Bag Salesman", 0xEB0058),
        LocationData("Snow Wood Boarding School", "Snow Wood - Upper Right Locker", 0xEB0059),
        LocationData("Snow Wood Boarding School", "Snow Wood - Upper Left Locker", 0xEB005A),
        LocationData("Snow Wood Boarding School", "Snow Wood - Bottom Right Locker", 0xEB005B),
        LocationData("Snow Wood Boarding School", "Snow Wood - Bottom Left Locker", 0xEB005C),
        LocationData("Snow Wood Boarding School", "Snow Wood - Maxwell Item", 0xEB005D),
        LocationData("Snow Wood Boarding School", "Snow Wood - Bedroom", 0xEB005E),
        LocationData("Winters", "Winters - Drugstore Saleswoman", 0xEB005F),
        LocationData("Brickroad Maze", "Brick Road Maze - Top Path Present", 0xEB0060),
        LocationData("Brickroad Maze", "Brick Road Maze - Guarded Present", 0xEB0061),
        LocationData("Brickroad Maze", "Brick Road Maze - Out of the Way Present", 0xEB0062),
        LocationData("Brickroad Maze", "Brick Road Maze - Alcove Present", 0xEB0063),
        LocationData("Brickroad Maze", "Brick Road Maze - Near Exit Present", 0xEB0064),
        LocationData("Rainy Circle", "Rainy Circle - Isolated Present", 0xEB0065),
        LocationData("Rainy Circle", "Rainy Circle - East Cliff Present", 0xEB0066),
        LocationData("Rainy Circle", "Rainy Circle - Near Ropes Present", 0xEB0067),
        LocationData("Andonuts Lab Area", "Andonuts Lab - Present", 0xEB0068),
        LocationData("Andonuts Lab Area", "Andonuts Lab - Mouse", 0xEB0069),
        LocationData("Stonehenge Base", "Stonehenge - Purple Maze Present", 0xEB006A),
        LocationData("Stonehenge Base", "Stonehenge - Dead End Present", 0xEB006B),
        LocationData("Stonehenge Base", "Stonehenge - Near End of the Maze Present", 0xEB006C),
        LocationData("Stonehenge Base", "Stonehenge - Bridge Room East Balcony Present", 0xEB006D),
        LocationData("Stonehenge Base", "Stonehenge - Bridge Room Lower Present", 0xEB006E),
        LocationData("Stonehenge Base", "Stonehenge - Flashing Room Right Path Present", 0xEB006F),
        LocationData("Stonehenge Base", "Stonehenge - Flashing Room Center Present", 0xEB0070),
        LocationData("Stonehenge Base", "Stonehenge - Flashing Room Upper Present", 0xEB0071),
        LocationData("Stonehenge Base", "Stonehenge - Kidnapped Mr. Saturn", 0xEB0072),
        LocationData("Stonehenge Base", "Stonehenge - Tony Item", 0xEB0073),
        LocationData("Gold Mine", "Gold Mine - Mouse Crossroad Present #1", 0xEB0074),
        LocationData("Gold Mine", "Gold Mine - Mouse Crossroad Present #2", 0xEB0075),
        LocationData("Gold Mine", "Gold Mine - B1F Lonely Mole Present", 0xEB0076),
        LocationData("Gold Mine", "Gold Mine - South Hall Present", 0xEB0077),
        LocationData("Gold Mine", "Gold Mine - South Corner Present", 0xEB0078),
        LocationData("Gold Mine", "Gold Mine - South Mole Present #1", 0xEB0079),
        LocationData("Gold Mine", "Gold Mine - South Mole Present #2", 0xEB007A),
        LocationData("Gold Mine", "Gold Mine - North Crossroad Detour Present", 0xEB007B),
        LocationData("Gold Mine", "Gold Mine - North Mole Present", 0xEB007C),
        LocationData("Gold Mine", "Gold Mine - West Mole Present", 0xEB007D),
        LocationData("Gold Mine", "Gold Mine - B1F Isolated Present", 0xEB007E),
        LocationData("Gold Mine", "Gold Mine - West Crossroad Detour Present", 0xEB007F),
        LocationData("Gold Mine", "Gold Mine - B1F Junction Present", 0xEB0080),
        LocationData("Gold Mine", "Gold Mine - B1F Junction Mole Present", 0xEB0081),
        LocationData("Monkey Caves", "Monkey Caves - 1F Right Chest", 0xEB00F1),
        LocationData("Monkey Caves", "Monkey Caves - 1F Left Chest", 0xEB00F2),
        LocationData("Monkey Caves", "Monkey Caves - West 2F Left Chest", 0xEB00F3),
        LocationData("Monkey Caves", "Monkey Caves - West 2F Right Chest #1", 0xEB00F4),
        LocationData("Monkey Caves", "Monkey Caves - West 2F Right Chest #2", 0xEB00F5),
        LocationData("Monkey Caves", "Monkey Caves - East 2F Left Chest", 0xEB00F6),
        LocationData("Monkey Caves", "Monkey Caves - East 2F Right Chest", 0xEB00F7),
        LocationData("Monkey Caves", "Monkey Caves - East West 3F Right Chest #1", 0xEB00F8),
        LocationData("Monkey Caves", "Monkey Caves - East West 3F Right Chest #2", 0xEB00F9),
        LocationData("Monkey Caves", "Monkey Caves - West End Chest", 0xEB0082),
        LocationData("Monkey Caves", "Monkey Caves - West End Trashcan", 0xEB0083),
        LocationData("Monkey Caves", "Monkey Caves - East End Chest", 0xEB0084),
        LocationData("Monkey Caves", "Monkey Caves - East End Trashcan", 0xEB0085),
        LocationData("Monkey Caves", "Monkey Caves - Bow Monkey Gift", 0xEB0086),
        LocationData("Monkey Caves", "Monkey Caves - Talah Rama Chest #1", 0xEB0087),
        LocationData("Monkey Caves", "Monkey Caves - Talah Rama Chest #2", 0xEB0088),
        LocationData("Monkey Caves", "Monkey Caves - Talah Rama Gift", 0xEB0089),
        LocationData("Monkey Caves", "Monkey Caves - Monkey Power", 0xEB008A),
        LocationData("Fourside", "Fourside - Venus Gift", 0xEB008B),
        LocationData("Moonside", "Fourside - Post-Moonside Delivery", 0xEB008C),
        LocationData("Fourside", "Fourside - Bakery 2F Gift", 0xEB008D),
        LocationData("Moonside", "Moonside - Two Trees Present", 0xEB008E),
        LocationData("Moonside", "Moonside - East Island Present", 0xEB008F),
        LocationData("Moonside", "Moonside - Businessman Present", 0xEB0090),
        LocationData("Moonside", "Moonside - West Island Present", 0xEB0091),
        LocationData("Moonside", "Moonside - Hospital Present", 0xEB0092),
        LocationData("Fourside Dept. Store", "Fourside - Department Store Blackout", 0xEB0093),
        LocationData("Magnet Hill", "Magnet Hill - West Entrance Trashcan", 0xEB0094),
        LocationData("Magnet Hill", "Magnet Hill - First Room Free Door Trashcan", 0xEB0095),
        LocationData("Magnet Hill", "Magnet Hill - First Room Barrel Door Trashcan", 0xEB0096),
        LocationData("Magnet Hill", "Magnet Hill - Second Room Dead End Trashcan", 0xEB0097),
        LocationData("Magnet Hill", "Magnet Hill - Final Room Door Trashcan", 0xEB0098),
        LocationData("Magnet Hill", "Fourside - Magnet Hill Chest", 0xEB0099),
        LocationData("Monotoli Building", "Monotoli Building - One Table Present", 0xEB009A),
        LocationData("Monotoli Building", "Monotoli Building - Two Table Present", 0xEB009B),
        LocationData("Monotoli Building", "Monotoli Building - Electra Gift", 0xEB009C),
        LocationData("Monotoli Building", "Monotoli Building - Monotoli Gift", 0xEB009D),
        LocationData("Monotoli Building", "Monotoli Building - Monotoli Character", 0xEB009E),
        LocationData("Summers Museum", "Summers - Museum Item", 0xEB009F),
        LocationData("Summers", "Summers - Magic Cake", 0xEB00A0),
        LocationData("Dalaam", "Dalaam - Throne Room Chest #1", 0xEB00A1),
        LocationData("Dalaam", "Dalaam - Throne Room Chest #2", 0xEB00A2),
        LocationData("Dalaam", "Dalaam - Throne Room Chest #3", 0xEB00A3),
        LocationData("Dalaam", "Dalaam - Trial of Mu", 0xEB00A4),
        LocationData("Dalaam", "Dalaam - Restaurant Chest #1", 0xEB00A5),
        LocationData("Dalaam", "Dalaam - Restaurant Chest #2", 0xEB00A6),
        LocationData("Dalaam", "Dalaam - Do Do Guy's House Chest", 0xEB00A7),
        LocationData("Dalaam", "Dalaam - Upper House Chest", 0xEB00A8),
        LocationData("Dalaam", "Dalaam - Throne Character", 0xEB00A9),
        LocationData("Ness's Mind", "Poo - Starting Item", 0xEB00AA),
        LocationData("Pink Cloud", "Pink Cloud - Three Holes Present", 0xEB00AB),
        LocationData("Pink Cloud", "Pink Cloud - Left Hole Present", 0xEB00AC),
        LocationData("Pink Cloud", "Pink Cloud - Ground Floor Present", 0xEB00AD),
        LocationData("Pyramid", "Pyramid - Anteroom Sarcophagus", 0xEB00AE),
        LocationData("Pyramid", "Pyramid - Northwest Door Sarcophagus", 0xEB00AF),
        LocationData("Pyramid", "Pyramid - Hallway Sarcophagus #1", 0xEB00B0),
        LocationData("Pyramid", "Pyramid - Hallway Sarcophagus #2", 0xEB00B1),
        LocationData("Pyramid", "Pyramid - Switch Room Sarcophagus", 0xEB00B2),
        LocationData("Pyramid", "Pyramid - Pedestal Item", 0xEB00B3),
        LocationData("Pyramid", "Pyramid - Way Out Sarcophagus", 0xEB00B4),
        LocationData("Southern Scaraba", "Scaraba - Star Master", 0xEB00B5),
        LocationData("Southern Scaraba", "Scaraba - Key Holder", 0xEB00B6),
        LocationData("Dungeon Man", "Dungeon Man - 1F Dead End Present", 0xEB00B7),
        LocationData("Dungeon Man", "Dungeon Man - 1F Long Walk Present", 0xEB00B8),
        LocationData("Dungeon Man", "Dungeon Man - 1F Disappointing Present", 0xEB00B9),
        LocationData("Dungeon Man", "Dungeon Man - 1F Opinion Present", 0xEB00BA),
        LocationData("Dungeon Man", "Dungeon Man - 1F No Sign Present", 0xEB00BB),
        LocationData("Dungeon Man", "Dungeon Man - 2F Unnecessary Billboard Present", 0xEB00BC),
        LocationData("Dungeon Man", "Dungeon Man - 2F Dungeon Exploration Present", 0xEB00BD),
        LocationData("Dungeon Man", "Dungeon Man - 2F South Ledge Present", 0xEB00BE),
        LocationData("Dungeon Man", "Dungeon Man - 2F North Alcove Present", 0xEB00BF),
        LocationData("Dungeon Man", "Dungeon Man - 3F Present", 0xEB00C0),
        LocationData("Dungeon Man", "Dungeon Man - 2F Hole Present", 0xEB00C1),
        LocationData("Dungeon Man", "Dungeon Man - 1F Exit Ledge Present", 0xEB00C2),
        LocationData("Deep Darkness", "Deep Darkness - Teleporting Monkey", 0xEB00C3),
        LocationData("Deep Darkness", "Deep Darkness - Crest of Darkness Present", 0xEB00C4),
        LocationData("Deep Darkness Darkness", "Deep Darkness - Helicopter Present", 0xEB00C5),
        LocationData("Deep Darkness Darkness", "Deep Darkness - Yellow Bird Present", 0xEB00C6),
        LocationData("Deep Darkness Darkness", "Deep Darkness - Swamp Present", 0xEB00C7),
        LocationData("Deep Darkness Darkness", "Deep Darkness - Corner Present", 0xEB00C8),
        LocationData("Deep Darkness Darkness", "Deep Darkness - Alcove Present", 0xEB00C9),
        LocationData("Deep Darkness Darkness", "Deep Darkness - North Alcove Truffle", 0xEB00CA),
        LocationData("Deep Darkness Darkness", "Deep Darkness - Near Land Truffle", 0xEB00CB),
        LocationData("Deep Darkness Darkness", "Deep Darkness - Present Truffle", 0xEB00CC),
        LocationData("Deep Darkness Darkness", "Deep Darkness - Village Truffle", 0xEB00CD),
        LocationData("Deep Darkness Darkness", "Deep Darkness - Entrance Truffle", 0xEB00CE),
        LocationData("Deep Darkness Darkness", "Deep Darkness - Barf Character", 0xEB00CF),
        LocationData("Tenda Village", "Tenda Village - Trashcan", 0xEB00D0),
        LocationData("Tenda Village", "Tenda Village - Tenda Tea", 0xEB00D1),
        LocationData("Tenda Village", "Tenda Village - Tenda Gift", 0xEB00D2),
        LocationData("Tenda Village", "Tenda Village - Tenda Gift #2", 0xEB00D3),
        LocationData("Lumine Hall", "Lumine Hall - B1F Non-Talkative Rock Present", 0xEB00D4),
        LocationData("Lumine Hall", "Lumine Hall - 1F North Path Present", 0xEB00D5),
        LocationData("Lumine Hall", "Lumine Hall - B1F Thankful Rock Corner Present", 0xEB00D6),
        LocationData("Lumine Hall", "Lumine Hall - B1F Thankful Rock Junction Present", 0xEB00D7),
        LocationData("Lumine Hall", "Lumine Hall - 1F Above Belly Button Present", 0xEB00D8),
        LocationData("Lumine Hall", "Lumine Hall - B1F Belly Button Present", 0xEB00D9),
        LocationData("Lumine Hall", "Lumine Hall - 1F Near Exit Present", 0xEB00DA),
        LocationData("Lumine Hall", "Lumine Hall - 1F Dead End Present", 0xEB00DB),
        LocationData("Lumine Hall", "Lumine Hall - B1F West Alcove Present", 0xEB00DC),
        LocationData("Lost Underworld", "Lost Underworld - Talking Rock", 0xEB00DD),
        LocationData("Lost Underworld", "Lost Underworld - East Present", 0xEB00DE),
        LocationData("Lost Underworld", "Lost Underworld - Northeast Present", 0xEB00DF),
        LocationData("Lost Underworld", "Lost Underworld - Northeast of Tenda Tribe Present", 0xEB00E0),
        LocationData("Lost Underworld", "Lost Underworld - Southwest of Tenda Tribe Present", 0xEB00E1),
        LocationData("Lost Underworld", "Lost Underworld - Evacuation Present", 0xEB00E2),
        LocationData("Fire Spring", "Fire Spring - 1st Cave Present", 0xEB00E3),
        LocationData("Fire Spring", "Fire Spring - East Corner Present", 0xEB00E4),
        LocationData("Fire Spring", "Fire Spring - Volcano Present", 0xEB00E5),
        LocationData("Fire Spring", "Fire Spring - Lone Cave Present", 0xEB00E6),
        LocationData("Fire Spring", "Fire Spring - Upper Volcano Present", 0xEB00E7),
        LocationData("Cave of the Present", "Cave of the Present - Star Master", 0xEB00EE),
        LocationData("Cave of the Present", "Cave of the Present - Broken Phase Distorter", 0xEB00EF),

        LocationData("Happy-Happy HQ", "Carpainter Defeated", None),
        LocationData("Belch's Factory", "Belch Defeated", None),
        LocationData("Dungeon Man", "Dungeon Man Submarine", None),
        LocationData("Giant Step", "Giant Step Sanctuary", None),
        LocationData("Lilliput Steps", "Lilliput Steps Sanctuary", None),
        LocationData("Milky Well", "Milky Well Sanctuary", None),
        LocationData("Rainy Circle", "Rainy Circle Sanctuary", None),
        LocationData("Magnet Hill", "Magnet Hill Sanctuary", None),
        LocationData("Pink Cloud", "Pink Cloud Sanctuary", None),
        LocationData("Lumine Hall", "Lumine Hall Sanctuary", None),
        LocationData("Fire Spring", "Fire Spring Sanctuary", None),
        LocationData("Ness's Mind", "Sanctuary Goal", None),
        LocationData("Global ATM Access", "Any ATM", None)
    ]

    if world.options.giygas_required:
        location_table += [
            LocationData("Cave of the Past", "Cave of the Past - Present", 0xEB00F0),
            LocationData("Endgame", "Giygas", None),
        ]

    if world.options.alternate_sanctuary_goal:
        location_table += [
            LocationData("Ness's Mind", "+2 Sanctuaries", None)
        ]

    if world.options.magicant_mode in range(1, 3):
        location_table += [
            LocationData("Sea of Eden", "Magicant - Ness's Nightmare", None),
        ]

    if not world.options.magicant_mode:
        location_table += [
            LocationData("Sea of Eden", "Magicant - Ness's Nightmare", 0xEB00ED),
        ]

    if world.options.magicant_mode < MagicantMode.option_alternate_goal:
        location_table += [
            LocationData("Magicant", "Magicant - Ness's Gift", 0xEB00E8),
            LocationData("Magicant", "Magicant - Present Near Ness", 0xEB00E9),
            LocationData("Magicant", "Magicant - Lonely Present", 0xEB00EA),
            LocationData("Magicant", "Magicant - North Present", 0xEB00EB),
            LocationData("Magicant", "Magicant - Hills Present", 0xEB00EC),
            LocationData("Magicant", "Magicant - Town Present", 0xEB00FA)
        ]
    if world.options.magicant_mode == MagicantMode.option_alternate_goal:
        location_table += [
            LocationData("Ness's Mind", "+1 Sanctuary", None)
        ]

    if world.options.shop_randomizer == ShopRandomizer.option_shopsanity:
        location_table += [
            LocationData("Onett", "Onett Drugstore - Right Counter Slot 1", 0xeb1000),
            LocationData("Onett", "Onett Drugstore - Right Counter Slot 2", 0xeb1001),
            LocationData("Onett", "Onett Drugstore - Right Counter Slot 3", 0xeb1002),
            LocationData("Onett", "Onett Drugstore - Right Counter Slot 4", 0xeb1003),
            LocationData("Onett", "Onett Drugstore - Right Counter Slot 5", 0xeb1004),
            LocationData("Onett", "Onett Drugstore - Left Counter", 0xeb1007),
            LocationData("Summers", "Summers - Beach Cart", 0xeb100e),
            LocationData("Onett", "Onett Burger Shop - Slot 1", 0xeb1015),
            LocationData("Onett", "Onett Burger Shop - Slot 2", 0xeb1016),
            LocationData("Onett", "Onett Burger Shop - Slot 3", 0xeb1017),
            LocationData("Onett", "Onett Burger Shop - Slot 4", 0xeb1018),
            LocationData("Onett", "Onett Bakery - Slot 1", 0xeb101c),
            LocationData("Onett", "Onett Bakery - Slot 2", 0xeb101d),
            LocationData("Onett", "Onett Bakery - Slot 3", 0xeb101e),
            LocationData("Onett", "Onett Bakery - Slot 4", 0xeb101f),
            LocationData("Twoson", "Twoson Department Store Burger Shop - Slot 1", 0xeb1023),
            LocationData("Twoson", "Twoson Department Store Burger Shop - Slot 2", 0xeb1024),
            LocationData("Twoson", "Twoson Department Store Burger Shop - Slot 3", 0xeb1025),
            LocationData("Twoson", "Twoson Department Store Burger Shop - Slot 4", 0xeb1026),
            LocationData("Twoson", "Twoson Department Store Bakery - Slot 1", 0xeb102a),
            LocationData("Twoson", "Twoson Department Store Bakery - Slot 2", 0xeb102b),
            LocationData("Twoson", "Twoson Department Store Bakery - Slot 3", 0xeb102c),
            LocationData("Twoson", "Twoson Department Store Bakery - Slot 4", 0xeb102d),
            LocationData("Twoson", "Twoson Department Store Top Floor - Right Counter Slot 1", 0xeb1031),
            LocationData("Twoson", "Twoson Department Store Top Floor - Right Counter Slot 2", 0xeb1032),
            LocationData("Twoson", "Twoson Department Store Top Floor - Right Counter Slot 3", 0xeb1033),
            LocationData("Twoson", "Twoson Department Store Top Floor - Right Counter Slot 4", 0xeb1034),
            LocationData("Twoson", "Twoson Department Store Top Floor - Right Counter Slot 5", 0xeb1035),
            LocationData("Twoson", "Twoson Department Store Top Floor - Right Counter Slot 6", 0xeb1036),
            LocationData("Twoson", "Twoson Department Store Top Floor - Left Counter Slot 1", 0xeb1038),
            LocationData("Twoson", "Twoson Department Store Top Floor - Left Counter Slot 2", 0xeb1039),
            LocationData("Summers", "Summers - Magic Cake Cart Shop Slot", 0xeb103f),
            LocationData("Twoson", "Burglin Park Junk Shop - Slot 1", 0xeb1046),
            LocationData("Twoson", "Burglin Park Junk Shop - Slot 2", 0xeb1047),
            LocationData("Twoson", "Burglin Park Junk Shop - Slot 3", 0xeb1048),
            LocationData("Twoson", "Burglin Park Junk Shop - Slot 4", 0xeb1049),
            LocationData("Twoson", "Burglin Park Junk Shop - Slot 5", 0xeb104a),
            LocationData("Twoson", "Burglin Park Junk Shop - Slot 6", 0xeb104b),
            LocationData("Twoson", "Burglin Park Bread Stand - Slot 1", 0xeb105b),
            LocationData("Twoson", "Burglin Park Bread Stand - Slot 2", 0xeb105c),
            LocationData("Twoson", "Burglin Park Bread Stand - Slot 3", 0xeb105d),
            LocationData("Twoson", "Burglin Park Bread Stand - Slot 4", 0xeb105e),
            LocationData("Twoson", "Burglin Park Bread Stand - Slot 5", 0xeb105f),
            LocationData("Twoson", "Burglin Park Bread Stand - Slot 6", 0xeb1060),
            LocationData("Twoson", "Burglin Park - Banana Stand", 0xeb1062),
            LocationData("Happy-Happy Village", "Happy-Happy Village Drugstore - Right Counter Slot 1", 0xeb1069),
            LocationData("Happy-Happy Village", "Happy-Happy Village Drugstore - Right Counter Slot 2", 0xeb106a),
            LocationData("Happy-Happy Village", "Happy-Happy Village Drugstore - Right Counter Slot 3", 0xeb106b),
            LocationData("Happy-Happy Village", "Happy-Happy Village Drugstore - Right Counter Slot 4", 0xeb106c),
            LocationData("Happy-Happy Village", "Happy-Happy Village Drugstore - Right Counter Slot 5", 0xeb106d),
            LocationData("Threed", "Threed Drugstore - Right Counter Slot 1", 0xeb1070),
            LocationData("Threed", "Threed Drugstore - Right Counter Slot 2", 0xeb1071),
            LocationData("Threed", "Threed Drugstore - Right Counter Slot 3", 0xeb1072),
            LocationData("Threed", "Threed Drugstore - Right Counter Slot 4", 0xeb1073),
            LocationData("Threed", "Threed Drugstore - Right Counter Slot 5", 0xeb1074),
            LocationData("Threed", "Threed Drugstore - Left Counter Slot 1", 0xeb1077),
            LocationData("Threed", "Threed Drugstore - Left Counter Slot 2", 0xeb1078),
            LocationData("Threed", "Threed Drugstore - Left Counter Slot 3", 0xeb1079),
            LocationData("Threed", "Threed Drugstore - Left Counter Slot 4", 0xeb107a),
            LocationData("Threed", "Threed Drugstore - Left Counter Slot 5", 0xeb107b),
            LocationData("Threed", "Threed - Arms Dealer Slot 1", 0xeb107e),
            LocationData("Threed", "Threed - Arms Dealer Slot 2", 0xeb107f),
            LocationData("Threed", "Threed - Arms Dealer Slot 3", 0xeb1080),
            LocationData("Threed", "Threed - Arms Dealer Slot 4", 0xeb1081),
            LocationData("Threed", "Threed Bakery - Slot 1", 0xeb1085),
            LocationData("Threed", "Threed Bakery - Slot 2", 0xeb1086),
            LocationData("Threed", "Threed Bakery - Slot 3", 0xeb1087),
            LocationData("Threed", "Threed Bakery - Slot 4", 0xeb1088),
            LocationData("Threed", "Threed Bakery - Slot 5", 0xeb1089),
            LocationData("Threed", "Threed Bakery - Slot 6", 0xeb108a),
            LocationData("Threed", "Threed Bakery - Slot 7", 0xeb108b),
            LocationData("Scaraba", "Scaraba - Expensive Water Guy", 0xeb108c),
            LocationData("Winters", "Winters Drugstore - Slot 1", 0xeb1093),
            LocationData("Winters", "Winters Drugstore - Slot 2", 0xeb1094),
            LocationData("Winters", "Winters Drugstore - Slot 3", 0xeb1095),
            LocationData("Winters", "Winters Drugstore - Slot 4", 0xeb1096),
            LocationData("Winters", "Winters Drugstore - Slot 5", 0xeb1097),
            LocationData("Winters", "Winters Drugstore - Slot 6", 0xeb1098),
            LocationData("Winters", "Winters Drugstore - Slot 7", 0xeb1099),
            LocationData("Saturn Valley", "Saturn Valley Shop - Center Saturn Slot 1", 0xeb109a),
            LocationData("Saturn Valley", "Saturn Valley Shop - Center Saturn Slot 2", 0xeb109b),
            LocationData("Saturn Valley", "Saturn Valley Shop - Center Saturn Slot 3", 0xeb109c),
            LocationData("Saturn Valley", "Saturn Valley Shop - Center Saturn Slot 4", 0xeb109d),
            LocationData("Saturn Valley", "Saturn Valley Shop - Center Saturn Slot 5", 0xeb109e),
            LocationData("Dusty Dunes Desert", "Dusty Dunes Drugstore - Counter Slot 1", 0xeb10a1),
            LocationData("Dusty Dunes Desert", "Dusty Dunes Drugstore - Counter Slot 2", 0xeb10a2),
            LocationData("Dusty Dunes Desert", "Dusty Dunes Drugstore - Counter Slot 3", 0xeb10a3),
            LocationData("Dusty Dunes Desert", "Dusty Dunes Drugstore - Counter Slot 4", 0xeb10a4),
            LocationData("Dusty Dunes Desert", "Dusty Dunes Drugstore - Counter Slot 5", 0xeb10a5),
            LocationData("Dusty Dunes Desert", "Dusty Dunes - Arms Dealer Slot 1", 0xeb10a8),
            LocationData("Dusty Dunes Desert", "Dusty Dunes - Arms Dealer Slot 2", 0xeb10a9),
            LocationData("Dusty Dunes Desert", "Dusty Dunes - Arms Dealer Slot 3", 0xeb10aa),
            LocationData("Dusty Dunes Desert", "Dusty Dunes - Arms Dealer Slot 4", 0xeb10ab),
            LocationData("Fourside", "Fourside Bakery - Slot 1", 0xeb10af),
            LocationData("Fourside", "Fourside Bakery - Slot 2", 0xeb10b0),
            LocationData("Fourside", "Fourside Bakery - Slot 3", 0xeb10b1),
            LocationData("Fourside", "Fourside Bakery - Slot 4", 0xeb10b2),
            LocationData("Fourside", "Fourside Bakery - Slot 5", 0xeb10b3),
            LocationData("Fourside", "Fourside Bakery - Slot 6", 0xeb10b4),
            LocationData("Fourside", "Fourside Department Store - Tool Shop Slot 1", 0xeb10b6),
            LocationData("Fourside", "Fourside Department Store - Tool Shop Slot 2", 0xeb10b7),
            LocationData("Fourside", "Fourside Department Store - Tool Shop Slot 3", 0xeb10b8),
            LocationData("Fourside", "Fourside Department Store - Tool Shop Slot 4", 0xeb10b9),
            LocationData("Fourside", "Fourside Department Store - Tool Shop Slot 5", 0xeb10ba),
            LocationData("Fourside", "Fourside Department Store - Tool Shop Slot 6", 0xeb10bb),
            LocationData("Fourside", "Fourside Department Store - Tool Shop Slot 7", 0xeb10bc),
            LocationData("Fourside", "Fourside Department Store - Shop Shop Slot 1", 0xeb10bd),
            LocationData("Fourside", "Fourside Department Store - Shop Shop Slot 2", 0xeb10be),
            LocationData("Fourside", "Fourside Department Store - Shop Shop Slot 3", 0xeb10bf),
            LocationData("Fourside", "Fourside Department Store - Shop Shop Slot 4", 0xeb10c0),
            LocationData("Fourside", "Fourside Department Store - Food Shop Slot 1", 0xeb10c4),
            LocationData("Fourside", "Fourside Department Store - Food Shop Slot 2", 0xeb10c5),
            LocationData("Fourside", "Fourside Department Store - Food Shop Slot 3", 0xeb10c6),
            LocationData("Fourside", "Fourside Department Store - Food Shop Slot 4", 0xeb10c7),
            LocationData("Fourside", "Fourside Department Store - Food Shop Slot 5", 0xeb10c8),
            LocationData("Fourside", "Fourside Department Store - 2F Cart Slot 1", 0xeb10cb),
            LocationData("Fourside", "Fourside Department Store - 2F Cart Slot 2", 0xeb10cc),
            LocationData("Fourside", "Fourside Department Store - 2F Cart Slot 3", 0xeb10cd),
            LocationData("Fourside", "Fourside Department Store - 2F Cart Slot 4", 0xeb10ce),
            LocationData("Fourside", "Fourside Department Store - 2F Cart Slot 5", 0xeb10cf),
            LocationData("Fourside", "Fourside Department Store - 2F Cart Slot 6", 0xeb10d0),
            LocationData("Fourside", "Fourside Department Store - 2F Cart Slot 7", 0xeb10d1),
            LocationData("Fourside", "Fourside Department Store - Toys Shop Slot 1", 0xeb10d2),
            LocationData("Fourside", "Fourside Department Store - Toys Shop Slot 2", 0xeb10d3),
            LocationData("Fourside", "Fourside Department Store - Toys Shop Slot 3", 0xeb10d4),
            LocationData("Fourside", "Fourside Department Store - Toys Shop Slot 4", 0xeb10d5),
            LocationData("Fourside", "Fourside Department Store - Toys Shop Slot 5", 0xeb10d6),
            LocationData("Fourside", "Fourside Department Store - Toys Shop Slot 6", 0xeb10d7),
            LocationData("Fourside", "Fourside Department Store - Sports Shop Slot 1", 0xeb10d9),
            LocationData("Fourside", "Fourside Department Store - Sports Shop Slot 2", 0xeb10da),
            LocationData("Fourside", "Fourside Department Store - Sports Shop Slot 3", 0xeb10db),
            LocationData("Fourside", "Fourside Department Store - Sports Shop Slot 4", 0xeb10dc),
            LocationData("Fourside", "Fourside Department Store - Burger Shop Slot 1", 0xeb10e0),
            LocationData("Fourside", "Fourside Department Store - Burger Shop Slot 2", 0xeb10e1),
            LocationData("Fourside", "Fourside Department Store - Burger Shop Slot 3", 0xeb10e2),
            LocationData("Fourside", "Fourside Department Store - Burger Shop Slot 4", 0xeb10e3),
            LocationData("Fourside", "Fourside Department Store - Burger Shop Slot 5", 0xeb10e4),
            LocationData("Fourside", "Fourside Department Store - Arms Dealer Slot 1", 0xeb10e7),
            LocationData("Fourside", "Fourside Department Store - Arms Dealer Slot 2", 0xeb10e8),
            LocationData("Fourside", "Fourside Department Store - Arms Dealer Slot 3", 0xeb10e9),
            LocationData("Fourside", "Fourside Department Store - Arms Dealer Slot 4", 0xeb10ea),
            LocationData("Fourside", "Fourside Department Store - Arms Dealer Slot 5", 0xeb10eb),
            LocationData("Fourside", "Fourside - Northeast Alley Junk Shop Slot 1", 0xeb10ee),
            LocationData("Fourside", "Fourside - Northeast Alley Junk Shop Slot 2", 0xeb10ef),
            LocationData("Fourside", "Fourside - Northeast Alley Junk Shop Slot 3", 0xeb10f0),
            LocationData("Fourside", "Fourside - Northeast Alley Junk Shop Slot 4", 0xeb10f1),
            LocationData("Summers", "Summers - Scam Shop Slot 1", 0xeb1103),
            LocationData("Summers", "Summers - Scam Shop Slot 2", 0xeb1104),
            LocationData("Summers", "Summers - Scam Shop Slot 3", 0xeb1105),
            LocationData("Summers", "Summers - Scam Shop Slot 4", 0xeb1106),
            LocationData("Summers", "Summers - Scam Shop Slot 5", 0xeb1107),
            LocationData("Summers", "Summers - Scam Shop Slot 6", 0xeb1108),
            LocationData("Summers", "Summers - Scam Shop Slot 7", 0xeb1109),
            LocationData("Summers", "Summers Harbor - Shop Slot 1", 0xeb110a),
            LocationData("Summers", "Summers Harbor - Shop Slot 2", 0xeb110b),
            LocationData("Summers", "Summers Harbor - Shop Slot 3", 0xeb110c),
            LocationData("Summers", "Summers Harbor - Shop Slot 4", 0xeb110d),
            LocationData("Summers", "Summers Harbor - Shop Slot 5", 0xeb110e),
            LocationData("Summers", "Summers Harbor - Shop Slot 6", 0xeb110f),
            LocationData("Summers", "Summers Harbor - Shop Slot 7", 0xeb1110),
            LocationData("Summers", "Summers Restaurant - Slot 1", 0xeb1111),
            LocationData("Summers", "Summers Restaurant - Slot 2", 0xeb1112),
            LocationData("Summers", "Summers Restaurant - Slot 3", 0xeb1113),
            LocationData("Summers", "Summers Restaurant - Slot 4", 0xeb1114),
            LocationData("Summers", "Summers Restaurant - Slot 5", 0xeb1115),
            LocationData("Summers", "Summers Restaurant - Slot 6", 0xeb1116),
            LocationData("Scaraba", "Scaraba - Indoors Shop Slot 1", 0xeb1118),
            LocationData("Scaraba", "Scaraba - Indoors Shop Slot 2", 0xeb1119),
            LocationData("Scaraba", "Scaraba - Indoors Shop Slot 3", 0xeb111a),
            LocationData("Scaraba", "Scaraba - Indoors Shop Slot 4", 0xeb111b),
            LocationData("Scaraba", "Scaraba - Indoors Shop Slot 5", 0xeb111c),
            LocationData("Scaraba", "Scaraba - Indoors Shop Slot 6", 0xeb111d),
            LocationData("Scaraba", "Scaraba Bazaar - Red Snake Carpet Slot 1", 0xeb1126),
            LocationData("Scaraba", "Scaraba Bazaar - Red Snake Carpet Slot 2", 0xeb1127),
            LocationData("Scaraba", "Scaraba Bazaar - Red Snake Carpet Slot 3", 0xeb1128),
            LocationData("Scaraba", "Scaraba Bazaar - Bottom Left Carpet Slot 1", 0xeb112d),
            LocationData("Scaraba", "Scaraba Bazaar - Bottom Left Carpet Slot 2", 0xeb112e),
            LocationData("Scaraba", "Scaraba Bazaar - Bottom Left Carpet Slot 3", 0xeb112f),
            LocationData("Scaraba", "Scaraba Bazaar - Bottom Left Carpet Slot 4", 0xeb1130),
            LocationData("Scaraba", "Scaraba Bazaar - Bottom Left Carpet Slot 5", 0xeb1131),
            LocationData("Scaraba", "Scaraba Bazaar - Bottom Left Carpet Slot 6", 0xeb1132),
            LocationData("Scaraba", "Scaraba Hotel - Arms Dealer Slot 1", 0xeb1134),
            LocationData("Scaraba", "Scaraba Hotel - Arms Dealer Slot 2", 0xeb1135),
            LocationData("Scaraba", "Scaraba Hotel - Arms Dealer Slot 3", 0xeb1136),
            LocationData("Scaraba", "Scaraba Hotel - Arms Dealer Slot 4", 0xeb1137),
            LocationData("Deep Darkness", "Deep Darkness - Businessman Slot 1", 0xeb113b),
            LocationData("Deep Darkness", "Deep Darkness - Businessman Slot 2", 0xeb113c),
            LocationData("Deep Darkness", "Deep Darkness - Businessman Slot 3", 0xeb113d),
            LocationData("Deep Darkness", "Deep Darkness - Businessman Slot 4", 0xeb113e),
            LocationData("Deep Darkness", "Deep Darkness - Businessman Slot 5", 0xeb113f),
            LocationData("Deep Darkness", "Deep Darkness - Businessman Slot 6", 0xeb1140),
            LocationData("Deep Darkness", "Deep Darkness - Businessman Slot 7", 0xeb1141),
            LocationData("Saturn Valley", "Saturn Valley Shop - Post-Belch Saturn Slot 1", 0xeb1157),
            LocationData("Saturn Valley", "Saturn Valley Shop - Post-Belch Saturn Slot 2", 0xeb1158),
            LocationData("Saturn Valley", "Saturn Valley Shop - Post-Belch Saturn Slot 3", 0xeb1159),
            LocationData("Saturn Valley", "Saturn Valley Shop - Post-Belch Saturn Slot 4", 0xeb115a),
            LocationData("Southern Scaraba", "Scaraba - Southern Camel Shop Slot 1", 0xeb115e),
            LocationData("Southern Scaraba", "Scaraba - Southern Camel Shop Slot 2", 0xeb115f),
            LocationData("Southern Scaraba", "Scaraba - Southern Camel Shop Slot 3", 0xeb1160),
            LocationData("Southern Scaraba", "Scaraba - Southern Camel Shop Slot 4", 0xeb1161),
            LocationData("Southern Scaraba", "Scaraba - Southern Camel Shop Slot 5", 0xeb1162),
            LocationData("Southern Scaraba", "Scaraba - Southern Camel Shop Slot 6", 0xeb1163),
            LocationData("Southern Scaraba", "Scaraba - Southern Camel Shop Slot 7", 0xeb1164),
            LocationData("Deep Darkness", "Deep Darkness - Arms Dealer Slot 1", 0xeb1165),
            LocationData("Deep Darkness", "Deep Darkness - Arms Dealer Slot 2", 0xeb1166),
            LocationData("Deep Darkness", "Deep Darkness - Arms Dealer Slot 3", 0xeb1167),
            LocationData("Deep Darkness", "Deep Darkness - Arms Dealer Slot 4", 0xeb1168),
            LocationData("Lost Underworld", "Lost Underworld - Tenda Camp Shop Slot 1", 0xeb116c),
            LocationData("Lost Underworld", "Lost Underworld - Tenda Camp Shop Slot 2", 0xeb116d),
            LocationData("Lost Underworld", "Lost Underworld - Tenda Camp Shop Slot 3", 0xeb116e),
            LocationData("Lost Underworld", "Lost Underworld - Tenda Camp Shop Slot 4", 0xeb116f),
            LocationData("Lost Underworld", "Lost Underworld - Tenda Camp Shop Slot 5", 0xeb1170),
            LocationData("Lost Underworld", "Lost Underworld - Tenda Camp Shop Slot 6", 0xeb1171),
            LocationData("Lost Underworld", "Lost Underworld - Tenda Camp Shop Slot 7", 0xeb1172),
            LocationData("Happy-Happy Village", "Happy-Happy Village Drugstore - Left Counter Slot 1", 0xeb117a),
            LocationData("Happy-Happy Village", "Happy-Happy Village Drugstore - Left Counter Slot 2", 0xeb117b),
            LocationData("Happy-Happy Village", "Happy-Happy Village Drugstore - Left Counter Slot 3", 0xeb117c),
            LocationData("Happy-Happy Village", "Happy-Happy Village Drugstore - Left Counter Slot 4", 0xeb117d),
            LocationData("Happy-Happy Village", "Happy-Happy Village Drugstore - Left Counter Slot 5", 0xeb117e),
            LocationData("Happy-Happy Village", "Happy-Happy Village Drugstore - Left Counter Slot 6", 0xeb117f),
            LocationData("Happy-Happy Village", "Happy-Happy Village Drugstore - Left Counter Slot 7", 0xeb1180),
            LocationData("Grapefruit Falls", "Grapefruit Falls - Hiker Shop Slot 1", 0xeb1181),
            LocationData("Grapefruit Falls", "Grapefruit Falls - Hiker Shop Slot 2", 0xeb1182),
            LocationData("Grapefruit Falls", "Grapefruit Falls - Hiker Shop Slot 3", 0xeb1183),
            LocationData("Saturn Valley", "Saturn Valley Shop - Top Saturn Slot 1", 0xeb1188),
            LocationData("Saturn Valley", "Saturn Valley Shop - Top Saturn Slot 2", 0xeb1189),
            LocationData("Saturn Valley", "Saturn Valley Shop - Top Saturn Slot 3", 0xeb118a),
            LocationData("Saturn Valley", "Saturn Valley Shop - Top Saturn Slot 4", 0xeb118b),
            LocationData("Saturn Valley", "Saturn Valley Shop - Top Saturn Slot 5", 0xeb118c),
            LocationData("Saturn Valley", "Saturn Valley Shop - Top Saturn Slot 6", 0xeb118d),
            LocationData("Saturn Valley", "Saturn Valley Shop - Top Saturn Slot 7", 0xeb118e),
            LocationData("Dusty Dunes Desert", "Dusty Dunes Drugstore - Left Shop Slot 1", 0xeb118f),
            LocationData("Dusty Dunes Desert", "Dusty Dunes Drugstore - Left Shop Slot 2", 0xeb1190),
            LocationData("Dusty Dunes Desert", "Dusty Dunes Drugstore - Left Shop Slot 3", 0xeb1191),
            LocationData("Dusty Dunes Desert", "Dusty Dunes Drugstore - Left Shop Slot 4", 0xeb1192),
            LocationData("Dusty Dunes Desert", "Dusty Dunes Drugstore - Left Shop Slot 5", 0xeb1193),
            LocationData("Dusty Dunes Desert", "Dusty Dunes Drugstore - Left Shop Slot 6", 0xeb1194),
            LocationData("Dusty Dunes Desert", "Dusty Dunes Drugstore - Left Shop Slot 7", 0xeb1195),
            LocationData("Dusty Dunes Desert", "Dusty Dunes - Mine Food Cart Slot 1", 0xeb1196),
            LocationData("Dusty Dunes Desert", "Dusty Dunes - Mine Food Cart Slot 2", 0xeb1197),
            LocationData("Dusty Dunes Desert", "Dusty Dunes - Mine Food Cart Slot 3", 0xeb1198),
            LocationData("Dusty Dunes Desert", "Dusty Dunes - Mine Food Cart Slot 4", 0xeb1199),
            LocationData("Dusty Dunes Desert", "Dusty Dunes - Mine Food Cart Slot 5", 0xeb119a),
            LocationData("Dusty Dunes Desert", "Dusty Dunes - Mine Food Cart Slot 6", 0xeb119b),
            LocationData("Dusty Dunes Desert", "Dusty Dunes - Mine Food Cart Slot 7", 0xeb119c),
            LocationData("Moonside", "Moonside Hotel - Shop Slot 1", 0xeb119d),
            LocationData("Moonside", "Moonside Hotel - Shop Slot 2", 0xeb119e),
            LocationData("Moonside", "Moonside Hotel - Shop Slot 3", 0xeb119f),
            LocationData("Moonside", "Moonside Hotel - Shop Slot 4", 0xeb11a0),
            LocationData("Moonside", "Moonside Hotel - Shop Slot 5", 0xeb11a1),
            LocationData("Dalaam", "Dalaam Restaurant - Slot 1", 0xeb11a4),
            LocationData("Dalaam", "Dalaam Restaurant - Slot 2", 0xeb11a5),
            LocationData("Dalaam", "Dalaam Restaurant - Slot 3", 0xeb11a6),
            LocationData("Dalaam", "Dalaam Restaurant - Slot 4", 0xeb11a7),
            LocationData("Scaraba", "Scaraba Bazaar - Delicacy Shop Slot 1", 0xeb11ab),
            LocationData("Scaraba", "Scaraba Bazaar - Delicacy Shop Slot 2", 0xeb11ac),
            LocationData("Scaraba", "Scaraba Bazaar - Delicacy Shop Slot 3", 0xeb11ad),
            LocationData("Scaraba", "Scaraba Bazaar - Delicacy Shop Slot 4", 0xeb11ae),
            LocationData("Scaraba", "Scaraba Bazaar - Delicacy Shop Slot 5", 0xeb11af),
            LocationData("Scaraba", "Scaraba Bazaar - Delicacy Shop Slot 6", 0xeb11b0),
            LocationData("Scaraba", "Scaraba Bazaar - Delicacy Shop Slot 7", 0xeb11b1),
            LocationData("Common Condiment Shop", "Twoson/Scaraba - Shared Condiment Shop Slot 1", 0xeb11b2),
            LocationData("Common Condiment Shop", "Twoson/Scaraba - Shared Condiment Shop Slot 2", 0xeb11b3),
            LocationData("Common Condiment Shop", "Twoson/Scaraba - Shared Condiment Shop Slot 3", 0xeb11b4),
            LocationData("Common Condiment Shop", "Twoson/Scaraba - Shared Condiment Shop Slot 4", 0xeb11b5),
            LocationData("Common Condiment Shop", "Twoson/Scaraba - Shared Condiment Shop Slot 5", 0xeb11b6),
            LocationData("Common Condiment Shop", "Twoson/Scaraba - Shared Condiment Shop Slot 6", 0xeb11b7),
            LocationData("Common Condiment Shop", "Twoson/Scaraba - Shared Condiment Shop Slot 7", 0xeb11b8),
            LocationData("Andonuts Lab Area", "Andonuts Lab - Caveman Shop Slot 1", 0xeb11c0),
            LocationData("Andonuts Lab Area", "Andonuts Lab - Caveman Shop Slot 2", 0xeb11c1),
            LocationData("Andonuts Lab Area", "Andonuts Lab - Caveman Shop Slot 3", 0xeb11c2),
            LocationData("Andonuts Lab Area", "Andonuts Lab - Caveman Shop Slot 4", 0xeb11c3),
            LocationData("Andonuts Lab Area", "Andonuts Lab - Caveman Shop Slot 5", 0xeb11c4)
        ]

        if world.options.magicant_mode < MagicantMode.option_alternate_goal:
            location_table += [
                LocationData("Magicant", "Magicant - Shop Slot 1", 0xeb10f5),
                LocationData("Magicant", "Magicant - Shop Slot 2", 0xeb10f6)
            ]

    return location_table
