from typing import Dict, NamedTuple, Optional, Set

from BaseClasses import Item, ItemClassification


class KH1Item(Item):
    game: str = "Kingdom Hearts"


class KH1ItemData(NamedTuple):
    category: str
    code: int
    type: str
    classification: ItemClassification = ItemClassification.filler
    max_quantity: int = 1
    weight: int = 1


def get_items_by_category(category: str) -> Dict[str, KH1ItemData]:
    item_dict: Dict[str, KH1ItemData] = {}
    for name, data in item_table.items():
        if data.category == category:
            item_dict.setdefault(name, data)

    return item_dict

def get_items_by_type(type: str) -> Dict[str, KH1ItemData]:
    item_dict: Dict[str, KH1ItemData] = {}
    for name, data in item_table.items():
        if data.type == type:
            item_dict.setdefault(name, data)

    return item_dict


item_table: Dict[str, KH1ItemData] = {
    "Potion":                            KH1ItemData("Item",             code = 264_1001, classification = ItemClassification.filler,      type = "Item",                            ),
    "Hi-Potion":                         KH1ItemData("Item",             code = 264_1002, classification = ItemClassification.filler,      type = "Item",                            ),
    "Ether":                             KH1ItemData("Item",             code = 264_1003, classification = ItemClassification.filler,      type = "Item",                            ),
    "Elixir":                            KH1ItemData("Item",             code = 264_1004, classification = ItemClassification.filler,      type = "Item",                            ),
    #"B05":                              KH1ItemData("Item",             code = 264_1005, classification = ItemClassification.filler,      type = "Item",                            ),
    "Mega-Potion":                       KH1ItemData("Item",             code = 264_1006, classification = ItemClassification.filler,      type = "Item",                            ),
    "Mega-Ether":                        KH1ItemData("Item",             code = 264_1007, classification = ItemClassification.filler,      type = "Item",                            ),
    "Megalixir":                         KH1ItemData("Item",             code = 264_1008, classification = ItemClassification.filler,      type = "Item",                            ),
    "Torn Page":                         KH1ItemData("Torn Pages",       code = 264_1009, classification = ItemClassification.progression, type = "Item",           max_quantity = 5 ),
    "Final Door Key":                    KH1ItemData("Key",              code = 264_1010, classification = ItemClassification.progression, type = "Item",                            ),
    "Destiny Islands":                   KH1ItemData("Worlds",           code = 264_1011, classification = ItemClassification.progression, type = "Item",                            ),
    "Raft Materials":                    KH1ItemData("Key",              code = 264_1012, classification = ItemClassification.progression, type = "Item",           max_quantity = 2 ),
    #"Frost Stone":                      KH1ItemData("Synthesis",        code = 264_1013, classification = ItemClassification.filler,      type = "Item",                            ),
    #"Lightning Stone":                  KH1ItemData("Synthesis",        code = 264_1014, classification = ItemClassification.filler,      type = "Item",                            ),
    #"Dazzling Stone":                   KH1ItemData("Synthesis",        code = 264_1015, classification = ItemClassification.filler,      type = "Item",                            ),
    #"Stormy Stone":                     KH1ItemData("Synthesis",        code = 264_1016, classification = ItemClassification.filler,      type = "Item",                            ),
    "Protect Chain":                     KH1ItemData("Accessory",        code = 264_1017, classification = ItemClassification.useful,      type = "Item",                            ),
    "Protera Chain":                     KH1ItemData("Accessory",        code = 264_1018, classification = ItemClassification.useful,      type = "Item",                            ),
    "Protega Chain":                     KH1ItemData("Accessory",        code = 264_1019, classification = ItemClassification.useful,      type = "Item",                            ),
    "Fire Ring":                         KH1ItemData("Accessory",        code = 264_1020, classification = ItemClassification.useful,      type = "Item",                            ),
    "Fira Ring":                         KH1ItemData("Accessory",        code = 264_1021, classification = ItemClassification.useful,      type = "Item",                            ),
    "Firaga Ring":                       KH1ItemData("Accessory",        code = 264_1022, classification = ItemClassification.useful,      type = "Item",                            ),
    "Blizzard Ring":                     KH1ItemData("Accessory",        code = 264_1023, classification = ItemClassification.useful,      type = "Item",                            ),
    "Blizzara Ring":                     KH1ItemData("Accessory",        code = 264_1024, classification = ItemClassification.useful,      type = "Item",                            ),
    "Blizzaga Ring":                     KH1ItemData("Accessory",        code = 264_1025, classification = ItemClassification.useful,      type = "Item",                            ),
    "Thunder Ring":                      KH1ItemData("Accessory",        code = 264_1026, classification = ItemClassification.useful,      type = "Item",                            ),
    "Thundara Ring":                     KH1ItemData("Accessory",        code = 264_1027, classification = ItemClassification.useful,      type = "Item",                            ),
    "Thundaga Ring":                     KH1ItemData("Accessory",        code = 264_1028, classification = ItemClassification.useful,      type = "Item",                            ),
    "Ability Stud":                      KH1ItemData("Accessory",        code = 264_1029, classification = ItemClassification.useful,      type = "Item",                            ),
    "Guard Earring":                     KH1ItemData("Accessory",        code = 264_1030, classification = ItemClassification.useful,      type = "Item",                            ),
    "Master Earring":                    KH1ItemData("Accessory",        code = 264_1031, classification = ItemClassification.useful,      type = "Item",                            ),
    "Chaos Ring":                        KH1ItemData("Accessory",        code = 264_1032, classification = ItemClassification.useful,      type = "Item",                            ),
    "Dark Ring":                         KH1ItemData("Accessory",        code = 264_1033, classification = ItemClassification.useful,      type = "Item",                            ),
    "Element Ring":                      KH1ItemData("Accessory",        code = 264_1034, classification = ItemClassification.useful,      type = "Item",                            ),
    "Three Stars":                       KH1ItemData("Accessory",        code = 264_1035, classification = ItemClassification.useful,      type = "Item",                            ),
    "Power Chain":                       KH1ItemData("Accessory",        code = 264_1036, classification = ItemClassification.useful,      type = "Item",                            ),
    "Golem Chain":                       KH1ItemData("Accessory",        code = 264_1037, classification = ItemClassification.useful,      type = "Item",                            ),
    "Titan Chain":                       KH1ItemData("Accessory",        code = 264_1038, classification = ItemClassification.useful,      type = "Item",                            ),
    "Energy Bangle":                     KH1ItemData("Accessory",        code = 264_1039, classification = ItemClassification.useful,      type = "Item",                            ),
    "Angel Bangle":                      KH1ItemData("Accessory",        code = 264_1040, classification = ItemClassification.useful,      type = "Item",                            ),
    "Gaia Bangle":                       KH1ItemData("Accessory",        code = 264_1041, classification = ItemClassification.useful,      type = "Item",                            ),
    "Magic Armlet":                      KH1ItemData("Accessory",        code = 264_1042, classification = ItemClassification.useful,      type = "Item",                            ),
    "Rune Armlet":                       KH1ItemData("Accessory",        code = 264_1043, classification = ItemClassification.useful,      type = "Item",                            ),
    "Atlas Armlet":                      KH1ItemData("Accessory",        code = 264_1044, classification = ItemClassification.useful,      type = "Item",                            ),
    "Heartguard":                        KH1ItemData("Accessory",        code = 264_1045, classification = ItemClassification.useful,      type = "Item",                            ),
    "Ribbon":                            KH1ItemData("Accessory",        code = 264_1046, classification = ItemClassification.useful,      type = "Item",                            ),
    "Crystal Crown":                     KH1ItemData("Accessory",        code = 264_1047, classification = ItemClassification.useful,      type = "Item",                            ),
    "Brave Warrior":                     KH1ItemData("Accessory",        code = 264_1048, classification = ItemClassification.useful,      type = "Item",                            ),
    "Ifrit's Horn":                      KH1ItemData("Accessory",        code = 264_1049, classification = ItemClassification.useful,      type = "Item",                            ),
    "Inferno Band":                      KH1ItemData("Accessory",        code = 264_1050, classification = ItemClassification.useful,      type = "Item",                            ),
    "White Fang":                        KH1ItemData("Accessory",        code = 264_1051, classification = ItemClassification.useful,      type = "Item",                            ),
    "Ray of Light":                      KH1ItemData("Accessory",        code = 264_1052, classification = ItemClassification.useful,      type = "Item",                            ),
    "Holy Circlet":                      KH1ItemData("Accessory",        code = 264_1053, classification = ItemClassification.useful,      type = "Item",                            ),
    "Raven's Claw":                      KH1ItemData("Accessory",        code = 264_1054, classification = ItemClassification.useful,      type = "Item",                            ),
    "Omega Arts":                        KH1ItemData("Accessory",        code = 264_1055, classification = ItemClassification.useful,      type = "Item",                            ),
    "EXP Earring":                       KH1ItemData("Accessory",        code = 264_1056, classification = ItemClassification.useful,      type = "Item",                            ),
    #"A41":                              KH1ItemData("Accessory",        code = 264_1057, classification = ItemClassification.useful,      type = "Item",                            ),
    "EXP Ring":                          KH1ItemData("Accessory",        code = 264_1058, classification = ItemClassification.useful,      type = "Item",                            ),
    "EXP Bracelet":                      KH1ItemData("Accessory",        code = 264_1059, classification = ItemClassification.useful,      type = "Item",                            ),
    "EXP Necklace":                      KH1ItemData("Accessory",        code = 264_1060, classification = ItemClassification.useful,      type = "Item",                            ),
    "Firagun Band":                      KH1ItemData("Accessory",        code = 264_1061, classification = ItemClassification.useful,      type = "Item",                            ),
    "Blizzagun Band":                    KH1ItemData("Accessory",        code = 264_1062, classification = ItemClassification.useful,      type = "Item",                            ),
    "Thundagun Band":                    KH1ItemData("Accessory",        code = 264_1063, classification = ItemClassification.useful,      type = "Item",                            ),
    "Ifrit Belt":                        KH1ItemData("Accessory",        code = 264_1064, classification = ItemClassification.useful,      type = "Item",                            ),
    "Shiva Belt":                        KH1ItemData("Accessory",        code = 264_1065, classification = ItemClassification.useful,      type = "Item",                            ),
    "Ramuh Belt":                        KH1ItemData("Accessory",        code = 264_1066, classification = ItemClassification.useful,      type = "Item",                            ),
    "Moogle Badge":                      KH1ItemData("Accessory",        code = 264_1067, classification = ItemClassification.useful,      type = "Item",                            ),
    "Cosmic Arts":                       KH1ItemData("Accessory",        code = 264_1068, classification = ItemClassification.useful,      type = "Item",                            ),
    "Royal Crown":                       KH1ItemData("Accessory",        code = 264_1069, classification = ItemClassification.useful,      type = "Item",                            ),
    "Prime Cap":                         KH1ItemData("Accessory",        code = 264_1070, classification = ItemClassification.useful,      type = "Item",                            ),
    "Obsidian Ring":                     KH1ItemData("Accessory",        code = 264_1071, classification = ItemClassification.useful,      type = "Item",                            ),
    #"A56":                              KH1ItemData("Accessory",        code = 264_1072, classification = ItemClassification.filler,      type = "Item",                            ),
    #"A57":                              KH1ItemData("Accessory",        code = 264_1073, classification = ItemClassification.filler,      type = "Item",                            ),
    #"A58":                              KH1ItemData("Accessory",        code = 264_1074, classification = ItemClassification.filler,      type = "Item",                            ),
    #"A59":                              KH1ItemData("Accessory",        code = 264_1075, classification = ItemClassification.filler,      type = "Item",                            ),
    #"A60":                              KH1ItemData("Accessory",        code = 264_1076, classification = ItemClassification.filler,      type = "Item",                            ),
    #"A61":                              KH1ItemData("Accessory",        code = 264_1077, classification = ItemClassification.filler,      type = "Item",                            ),
    #"A62":                              KH1ItemData("Accessory",        code = 264_1078, classification = ItemClassification.filler,      type = "Item",                            ),
    #"A63":                              KH1ItemData("Accessory",        code = 264_1079, classification = ItemClassification.filler,      type = "Item",                            ),
    #"A64":                              KH1ItemData("Accessory",        code = 264_1080, classification = ItemClassification.filler,      type = "Item",                            ),
    #"Kingdom Key":                      KH1ItemData("Keyblades",        code = 264_1081, classification = ItemClassification.useful,      type = "Item",                            ),
    #"Dream Sword":                      KH1ItemData("Keyblades",        code = 264_1082, classification = ItemClassification.useful,      type = "Item",                            ),
    #"Dream Shield":                     KH1ItemData("Keyblades",        code = 264_1083, classification = ItemClassification.useful,      type = "Item",                            ),
    #"Dream Rod":                        KH1ItemData("Keyblades",        code = 264_1084, classification = ItemClassification.useful,      type = "Item",                            ),
    #"Wooden Sword":                     KH1ItemData("Keyblades",        code = 264_1085, classification = ItemClassification.useful,      type = "Item",                            ),
    "Jungle King":                       KH1ItemData("Keyblades",        code = 264_1086, classification = ItemClassification.progression, type = "Item",                            ),
    "Three Wishes":                      KH1ItemData("Keyblades",        code = 264_1087, classification = ItemClassification.progression, type = "Item",                            ),
    "Fairy Harp":                        KH1ItemData("Keyblades",        code = 264_1088, classification = ItemClassification.progression, type = "Item",                            ),
    "Pumpkinhead":                       KH1ItemData("Keyblades",        code = 264_1089, classification = ItemClassification.progression, type = "Item",                            ),
    "Crabclaw":                          KH1ItemData("Keyblades",        code = 264_1090, classification = ItemClassification.progression, type = "Item",                            ),
    "Divine Rose":                       KH1ItemData("Keyblades",        code = 264_1091, classification = ItemClassification.progression, type = "Item",                            ),
    "Spellbinder":                       KH1ItemData("Keyblades",        code = 264_1092, classification = ItemClassification.progression, type = "Item",                            ),
    "Olympia":                           KH1ItemData("Keyblades",        code = 264_1093, classification = ItemClassification.progression, type = "Item",                            ),
    "Lionheart":                         KH1ItemData("Keyblades",        code = 264_1094, classification = ItemClassification.progression, type = "Item",                            ),
    "Metal Chocobo":                     KH1ItemData("Keyblades",        code = 264_1095, classification = ItemClassification.useful,      type = "Item",                            ),
    "Oathkeeper":                        KH1ItemData("Keyblades",        code = 264_1096, classification = ItemClassification.progression, type = "Item",                            ),
    "Oblivion":                          KH1ItemData("Keyblades",        code = 264_1097, classification = ItemClassification.progression, type = "Item",                            ),
    "Lady Luck":                         KH1ItemData("Keyblades",        code = 264_1098, classification = ItemClassification.progression, type = "Item",                            ),
    "Wishing Star":                      KH1ItemData("Keyblades",        code = 264_1099, classification = ItemClassification.progression, type = "Item",                            ),
    "Ultima Weapon":                     KH1ItemData("Keyblades",        code = 264_1100, classification = ItemClassification.useful,      type = "Item",                            ),
    "Diamond Dust":                      KH1ItemData("Keyblades",        code = 264_1101, classification = ItemClassification.useful,      type = "Item",                            ),
    "One-Winged Angel":                  KH1ItemData("Keyblades",        code = 264_1102, classification = ItemClassification.useful,      type = "Item",                            ),
    #"Mage's Staff":                     KH1ItemData("Weapons",          code = 264_1103, classification = ItemClassification.filler,      type = "Item",                            ),
    "Morning Star":                      KH1ItemData("Weapons",          code = 264_1104, classification = ItemClassification.useful,      type = "Item",                            ),
    "Shooting Star":                     KH1ItemData("Weapons",          code = 264_1105, classification = ItemClassification.useful,      type = "Item",                            ),
    "Magus Staff":                       KH1ItemData("Weapons",          code = 264_1106, classification = ItemClassification.useful,      type = "Item",                            ),
    "Wisdom Staff":                      KH1ItemData("Weapons",          code = 264_1107, classification = ItemClassification.useful,      type = "Item",                            ),
    "Warhammer":                         KH1ItemData("Weapons",          code = 264_1108, classification = ItemClassification.useful,      type = "Item",                            ),
    "Silver Mallet":                     KH1ItemData("Weapons",          code = 264_1109, classification = ItemClassification.useful,      type = "Item",                            ),
    "Grand Mallet":                      KH1ItemData("Weapons",          code = 264_1110, classification = ItemClassification.useful,      type = "Item",                            ),
    "Lord Fortune":                      KH1ItemData("Weapons",          code = 264_1111, classification = ItemClassification.useful,      type = "Item",                            ),
    "Violetta":                          KH1ItemData("Weapons",          code = 264_1112, classification = ItemClassification.useful,      type = "Item",                            ),
    "Dream Rod (Donald)":                KH1ItemData("Weapons",          code = 264_1113, classification = ItemClassification.useful,      type = "Item",                            ),
    "Save the Queen":                    KH1ItemData("Weapons",          code = 264_1114, classification = ItemClassification.useful,      type = "Item",                            ),
    "Wizard's Relic":                    KH1ItemData("Weapons",          code = 264_1115, classification = ItemClassification.useful,      type = "Item",                            ),
    "Meteor Strike":                     KH1ItemData("Weapons",          code = 264_1116, classification = ItemClassification.useful,      type = "Item",                            ),
    "Fantasista":                        KH1ItemData("Weapons",          code = 264_1117, classification = ItemClassification.useful,      type = "Item",                            ),
    #"Unused (Donald)":                  KH1ItemData("Weapons",          code = 264_1118, classification = ItemClassification.filler,      type = "Item",                            ),
    #"Knight's Shield":                  KH1ItemData("Weapons",          code = 264_1119, classification = ItemClassification.filler,      type = "Item",                            ),
    "Mythril Shield":                    KH1ItemData("Weapons",          code = 264_1120, classification = ItemClassification.useful,      type = "Item",                            ),
    "Onyx Shield":                       KH1ItemData("Weapons",          code = 264_1121, classification = ItemClassification.useful,      type = "Item",                            ),
    "Stout Shield":                      KH1ItemData("Weapons",          code = 264_1122, classification = ItemClassification.useful,      type = "Item",                            ),
    "Golem Shield":                      KH1ItemData("Weapons",          code = 264_1123, classification = ItemClassification.useful,      type = "Item",                            ),
    "Adamant Shield":                    KH1ItemData("Weapons",          code = 264_1124, classification = ItemClassification.useful,      type = "Item",                            ),
    "Smasher":                           KH1ItemData("Weapons",          code = 264_1125, classification = ItemClassification.useful,      type = "Item",                            ),
    "Gigas Fist":                        KH1ItemData("Weapons",          code = 264_1126, classification = ItemClassification.useful,      type = "Item",                            ),
    "Genji Shield":                      KH1ItemData("Weapons",          code = 264_1127, classification = ItemClassification.useful,      type = "Item",                            ),
    "Herc's Shield":                     KH1ItemData("Weapons",          code = 264_1128, classification = ItemClassification.useful,      type = "Item",                            ),
    "Dream Shield (Goofy)":              KH1ItemData("Weapons",          code = 264_1129, classification = ItemClassification.useful,      type = "Item",                            ),
    "Save the King":                     KH1ItemData("Weapons",          code = 264_1130, classification = ItemClassification.useful,      type = "Item",                            ),
    "Defender":                          KH1ItemData("Weapons",          code = 264_1131, classification = ItemClassification.useful,      type = "Item",                            ),
    "Mighty Shield":                     KH1ItemData("Weapons",          code = 264_1132, classification = ItemClassification.useful,      type = "Item",                            ),
    "Seven Elements":                    KH1ItemData("Weapons",          code = 264_1133, classification = ItemClassification.useful,      type = "Item",                            ),
    #"Unused (Goofy)":                   KH1ItemData("Weapons",          code = 264_1134, classification = ItemClassification.filler,      type = "Item",                            ),
    #"Spear":                            KH1ItemData("Weapons",          code = 264_1135, classification = ItemClassification.filler,      type = "Item",                            ),
    #"No Weapon":                        KH1ItemData("Weapons",          code = 264_1136, classification = ItemClassification.filler,      type = "Item",                            ),
    #"Genie":                            KH1ItemData("Weapons",          code = 264_1137, classification = ItemClassification.filler,      type = "Item",                            ),
    #"No Weapon":                        KH1ItemData("Weapons",          code = 264_1138, classification = ItemClassification.filler,      type = "Item",                            ),
    #"No Weapon":                        KH1ItemData("Weapons",          code = 264_1139, classification = ItemClassification.filler,      type = "Item",                            ),
    #"Dagger":                           KH1ItemData("Weapons",          code = 264_1140, classification = ItemClassification.filler,      type = "Item",                            ),
    #"Claws":                            KH1ItemData("Weapons",          code = 264_1141, classification = ItemClassification.filler,      type = "Item",                            ),
    "Tent":                              KH1ItemData("Camping",          code = 264_1142, classification = ItemClassification.filler,      type = "Item",                            ),
    "Camping Set":                       KH1ItemData("Camping",          code = 264_1143, classification = ItemClassification.filler,      type = "Item",                            ),
    "Cottage":                           KH1ItemData("Camping",          code = 264_1144, classification = ItemClassification.filler,      type = "Item",                            ),
    #"C04":                              KH1ItemData("Camping",          code = 264_1145, classification = ItemClassification.filler,      type = "Item",                            ),
    #"C05":                              KH1ItemData("Camping",          code = 264_1146, classification = ItemClassification.filler,      type = "Item",                            ),
    #"C06":                              KH1ItemData("Camping",          code = 264_1147, classification = ItemClassification.filler,      type = "Item",                            ),
    #"C07":                              KH1ItemData("Camping",          code = 264_1148, classification = ItemClassification.filler,      type = "Item",                            ),
    "Wonderland":                        KH1ItemData("Worlds",           code = 264_1149, classification = ItemClassification.progression, type = "Item",                            ),
    "Olympus Coliseum":                  KH1ItemData("Worlds",           code = 264_1150, classification = ItemClassification.progression, type = "Item",                            ),
    "Deep Jungle":                       KH1ItemData("Worlds",           code = 264_1151, classification = ItemClassification.progression, type = "Item",                            ),
    "Power Up":                          KH1ItemData("Stat Ups",         code = 264_1152, classification = ItemClassification.filler,      type = "Item",                            ),
    "Defense Up":                        KH1ItemData("Stat Ups",         code = 264_1153, classification = ItemClassification.filler,      type = "Item",                            ),
    "AP Up":                             KH1ItemData("Stat Ups",         code = 264_1154, classification = ItemClassification.filler,      type = "Item",                            ),
    "Agrabah":                           KH1ItemData("Worlds",           code = 264_1155, classification = ItemClassification.progression, type = "Item",                            ),
    "Monstro":                           KH1ItemData("Worlds",           code = 264_1156, classification = ItemClassification.progression, type = "Item",                            ),
    "Atlantica":                         KH1ItemData("Worlds",           code = 264_1157, classification = ItemClassification.progression, type = "Item",                            ),
    "Fire Arts":                         KH1ItemData("Key",              code = 264_1158, classification = ItemClassification.progression, type = "Item",                            ),
    "Blizzard Arts":                     KH1ItemData("Key",              code = 264_1159, classification = ItemClassification.progression, type = "Item",                            ),
    "Thunder Arts":                      KH1ItemData("Key",              code = 264_1160, classification = ItemClassification.progression, type = "Item",                            ),
    "Cure Arts":                         KH1ItemData("Key",              code = 264_1161, classification = ItemClassification.progression, type = "Item",                            ),
    "Gravity Arts":                      KH1ItemData("Key",              code = 264_1162, classification = ItemClassification.progression, type = "Item",                            ),
    "Stop Arts":                         KH1ItemData("Key",              code = 264_1163, classification = ItemClassification.progression, type = "Item",                            ),
    "Aero Arts":                         KH1ItemData("Key",              code = 264_1164, classification = ItemClassification.progression, type = "Item",                            ),
    "Neverland":                         KH1ItemData("Worlds",           code = 264_1165, classification = ItemClassification.progression, type = "Item",                            ),
    "Halloween Town":                    KH1ItemData("Worlds",           code = 264_1166, classification = ItemClassification.progression, type = "Item",                            ),
    "Puppy":                             KH1ItemData("Key",              code = 264_1167, classification = ItemClassification.progression, type = "Item",                            ),
    "Hollow Bastion":                    KH1ItemData("Worlds",           code = 264_1168, classification = ItemClassification.progression, type = "Item",                            ),
    "End of the World":                  KH1ItemData("Worlds",           code = 264_1169, classification = ItemClassification.progression, type = "Item",                            ),
    "Blue Trinity":                      KH1ItemData("Trinities",        code = 264_1170, classification = ItemClassification.progression, type = "Item",                            ),
    "Red Trinity":                       KH1ItemData("Trinities",        code = 264_1171, classification = ItemClassification.progression, type = "Item",                            ),
    "Green Trinity":                     KH1ItemData("Trinities",        code = 264_1172, classification = ItemClassification.progression, type = "Item",                            ),
    "Yellow Trinity":                    KH1ItemData("Trinities",        code = 264_1173, classification = ItemClassification.progression, type = "Item",                            ),
    "White Trinity":                     KH1ItemData("Trinities",        code = 264_1174, classification = ItemClassification.progression, type = "Item",                            ),
    "Progressive Fire":                  KH1ItemData("Magic",            code = 264_1175, classification = ItemClassification.progression, type = "Item",           max_quantity = 3 ),
    "Progressive Blizzard":              KH1ItemData("Magic",            code = 264_1176, classification = ItemClassification.progression, type = "Item",           max_quantity = 3 ),
    "Progressive Thunder":               KH1ItemData("Magic",            code = 264_1177, classification = ItemClassification.progression, type = "Item",           max_quantity = 3 ),
    "Progressive Cure":                  KH1ItemData("Magic",            code = 264_1178, classification = ItemClassification.progression, type = "Item",           max_quantity = 3 ),
    "Progressive Gravity":               KH1ItemData("Magic",            code = 264_1179, classification = ItemClassification.progression, type = "Item",           max_quantity = 3 ),
    "Progressive Stop":                  KH1ItemData("Magic",            code = 264_1180, classification = ItemClassification.progression, type = "Item",           max_quantity = 3 ),
    "Progressive Aero":                  KH1ItemData("Magic",            code = 264_1181, classification = ItemClassification.progression, type = "Item",           max_quantity = 3 ),
    "Phil Cup":                          KH1ItemData("Cups",             code = 264_1182, classification = ItemClassification.progression, type = "Item",                            ),
    "Theon Vol. 6":                      KH1ItemData("Key",              code = 264_1183, classification = ItemClassification.progression, type = "Item",                            ),
    "Pegasus Cup":                       KH1ItemData("Cups",             code = 264_1184, classification = ItemClassification.progression, type = "Item",                            ),
    "Hercules Cup":                      KH1ItemData("Cups",             code = 264_1185, classification = ItemClassification.progression, type = "Item",                            ),
    #"Empty Bottle":                     KH1ItemData("Key",              code = 264_1186, classification = ItemClassification.progression, type = "Item",           max_quantity = 6 ),
    #"Old Book":                         KH1ItemData("Key",              code = 264_1187, classification = ItemClassification.progression, type = "Item",                            ),
    "Emblem Piece (Flame)":              KH1ItemData("Key",              code = 264_1188, classification = ItemClassification.progression, type = "Item",                            ),
    "Emblem Piece (Chest)":              KH1ItemData("Key",              code = 264_1189, classification = ItemClassification.progression, type = "Item",                            ),
    "Emblem Piece (Statue)":             KH1ItemData("Key",              code = 264_1190, classification = ItemClassification.progression, type = "Item",                            ),
    "Emblem Piece (Fountain)":           KH1ItemData("Key",              code = 264_1191, classification = ItemClassification.progression, type = "Item",                            ),
    #"Log":                              KH1ItemData("DI",               code = 264_1192, classification = ItemClassification.progression, type = "Item",           max_quantity = 2 ),
    #"Cloth":                            KH1ItemData("DI",               code = 264_1193, classification = ItemClassification.progression, type = "Item",                            ),
    #"Rope":                             KH1ItemData("DI",               code = 264_1194, classification = ItemClassification.progression, type = "Item",                            ),
    #"Seagull Egg":                      KH1ItemData("DI",               code = 264_1195, classification = ItemClassification.progression, type = "Item",                            ),
    #"Fish":                             KH1ItemData("DI",               code = 264_1196, classification = ItemClassification.progression, type = "Item",           max_quantity = 3 ),
    #"Mushroom":                         KH1ItemData("DI",               code = 264_1197, classification = ItemClassification.progression, type = "Item",           max_quantity = 3 ),
    #"Coconut":                          KH1ItemData("DI",               code = 264_1198, classification = ItemClassification.progression, type = "Item",           max_quantity = 2 ),
    #"Drinking Water":                   KH1ItemData("DI",               code = 264_1199, classification = ItemClassification.progression, type = "Item",                            ),
    #"Navi-G Piece 1":                   KH1ItemData("Key",              code = 264_1200, classification = ItemClassification.progression, type = "Item",                            ),
    #"Navi-G Piece 2":                   KH1ItemData("Key",              code = 264_1201, classification = ItemClassification.progression, type = "Item",                            ),
    #"Navi-Gummi Unused":                KH1ItemData("Key",              code = 264_1202, classification = ItemClassification.progression, type = "Item",                            ),
    #"Navi-G Piece 3":                   KH1ItemData("Key",              code = 264_1203, classification = ItemClassification.progression, type = "Item",                            ),
    #"Navi-G Piece 4":                   KH1ItemData("Key",              code = 264_1204, classification = ItemClassification.progression, type = "Item",                            ),
    #"Navi-Gummi":                       KH1ItemData("Key",              code = 264_1205, classification = ItemClassification.progression, type = "Item",                            ),
    #"Watergleam":                       KH1ItemData("Key",              code = 264_1206, classification = ItemClassification.progression, type = "Item",                            ),
    #"Naturespark":                      KH1ItemData("Key",              code = 264_1207, classification = ItemClassification.progression, type = "Item",                            ),
    #"Fireglow":                         KH1ItemData("Key",              code = 264_1208, classification = ItemClassification.progression, type = "Item",                            ),
    #"Earthshine":                       KH1ItemData("Key",              code = 264_1209, classification = ItemClassification.progression, type = "Item",                            ),
    "Crystal Trident":                   KH1ItemData("Key",              code = 264_1210, classification = ItemClassification.progression, type = "Item",                            ),
    "Postcard":                          KH1ItemData("Key",              code = 264_1211, classification = ItemClassification.progression, type = "Item",           max_quantity = 10),
   #"Torn Page 1":                       KH1ItemData("Torn Pages",       code = 264_1212, classification = ItemClassification.progression, type = "Item",                            ),
   #"Torn Page 2":                       KH1ItemData("Torn Pages",       code = 264_1213, classification = ItemClassification.progression, type = "Item",                            ),
   #"Torn Page 3":                       KH1ItemData("Torn Pages",       code = 264_1214, classification = ItemClassification.progression, type = "Item",                            ),
   #"Torn Page 4":                       KH1ItemData("Torn Pages",       code = 264_1215, classification = ItemClassification.progression, type = "Item",                            ),
   #"Torn Page 5":                       KH1ItemData("Torn Pages",       code = 264_1216, classification = ItemClassification.progression, type = "Item",                            ),
    "Slides":                            KH1ItemData("Key",              code = 264_1217, classification = ItemClassification.progression, type = "Item",                            ),
    #"Slide 2":                          KH1ItemData("Key",              code = 264_1218, classification = ItemClassification.progression, type = "Item",                            ),
    #"Slide 3":                          KH1ItemData("Key",              code = 264_1219, classification = ItemClassification.progression, type = "Item",                            ),
    #"Slide 4":                          KH1ItemData("Key",              code = 264_1220, classification = ItemClassification.progression, type = "Item",                            ),
    #"Slide 5":                          KH1ItemData("Key",              code = 264_1221, classification = ItemClassification.progression, type = "Item",                            ),
    #"Slide 6":                          KH1ItemData("Key",              code = 264_1222, classification = ItemClassification.progression, type = "Item",                            ),
    "Footprints":                        KH1ItemData("Key",              code = 264_1223, classification = ItemClassification.progression, type = "Item",                            ),
    #"Claw Marks":                       KH1ItemData("Key",              code = 264_1224, classification = ItemClassification.progression, type = "Item",                            ),
    #"Stench":                           KH1ItemData("Key",              code = 264_1225, classification = ItemClassification.progression, type = "Item",                            ),
    #"Antenna":                          KH1ItemData("Key",              code = 264_1226, classification = ItemClassification.progression, type = "Item",                            ),
    "Forget-Me-Not":                     KH1ItemData("Key",              code = 264_1227, classification = ItemClassification.progression, type = "Item",                            ),
    "Jack-In-The-Box":                   KH1ItemData("Key",              code = 264_1228, classification = ItemClassification.progression, type = "Item",                            ),
    "Entry Pass":                        KH1ItemData("Key",              code = 264_1229, classification = ItemClassification.progression, type = "Item",                            ),
    #"AP Item":                          KH1ItemData("Key",              code = 264_1230, classification = ItemClassification.progression, type = "Item",                            ),
    "Dumbo":                             KH1ItemData("Summons",          code = 264_1231, classification = ItemClassification.progression, type = "Item",                            ),
    #"N41":                              KH1ItemData("Synthesis",        code = 264_1232, classification = ItemClassification.filler,      type = "Item",                            ),
    "Bambi":                             KH1ItemData("Summons",          code = 264_1233, classification = ItemClassification.progression, type = "Item",                            ),
    "Genie":                             KH1ItemData("Summons",          code = 264_1234, classification = ItemClassification.progression, type = "Item",                            ),
    "Tinker Bell":                       KH1ItemData("Summons",          code = 264_1235, classification = ItemClassification.progression, type = "Item",                            ),
    "Mushu":                             KH1ItemData("Summons",          code = 264_1236, classification = ItemClassification.progression, type = "Item",                            ),
    "Simba":                             KH1ItemData("Summons",          code = 264_1237, classification = ItemClassification.progression, type = "Item",                            ),
    "Lucky Emblem":                      KH1ItemData("Key",              code = 264_1238, classification = ItemClassification.progression, type = "Item",                            ),
    "Max HP Increase":                   KH1ItemData("Level Up",         code = 264_1239, classification = ItemClassification.useful,      type = "Item",           max_quantity = 15),
    "Max MP Increase":                   KH1ItemData("Level Up",         code = 264_1240, classification = ItemClassification.useful,      type = "Item",           max_quantity = 15),
    "Max AP Increase":                   KH1ItemData("Level Up",         code = 264_1241, classification = ItemClassification.useful,      type = "Item",           max_quantity = 15),
    "Strength Increase":                 KH1ItemData("Level Up",         code = 264_1242, classification = ItemClassification.useful,      type = "Item",           max_quantity = 15),
    "Defense Increase":                  KH1ItemData("Level Up",         code = 264_1243, classification = ItemClassification.useful,      type = "Item",           max_quantity = 15),
    "Item Slot Increase":                KH1ItemData("Limited Level Up", code = 264_1244, classification = ItemClassification.useful,      type = "Item",           max_quantity = 15),
    "Accessory Slot Increase":           KH1ItemData("Limited Level Up", code = 264_1245, classification = ItemClassification.useful,      type = "Item",           max_quantity = 15),
    #"Thunder Gem":                      KH1ItemData("Synthesis",        code = 264_1246, classification = ItemClassification.filler,      type = "Item",                            ),
    #"Shiny Crystal":                    KH1ItemData("Synthesis",        code = 264_1247, classification = ItemClassification.filler,      type = "Item",                            ),
    #"Bright Shard":                     KH1ItemData("Synthesis",        code = 264_1248, classification = ItemClassification.filler,      type = "Item",                            ),
    #"Bright Gem":                       KH1ItemData("Synthesis",        code = 264_1249, classification = ItemClassification.filler,      type = "Item",                            ),
    #"Bright Crystal":                   KH1ItemData("Synthesis",        code = 264_1250, classification = ItemClassification.filler,      type = "Item",                            ),
    #"Mystery Goo":                      KH1ItemData("Synthesis",        code = 264_1251, classification = ItemClassification.filler,      type = "Item",                            ),
    #"Gale":                             KH1ItemData("Synthesis",        code = 264_1252, classification = ItemClassification.filler,      type = "Item",                            ),
    #"Mythril Shard":                    KH1ItemData("Synthesis",        code = 264_1253, classification = ItemClassification.filler,      type = "Item",                            ),
    "Mythril":                           KH1ItemData("Key",              code = 264_1254, classification = ItemClassification.progression, type = "Item",           max_quantity = 16),
    "Orichalcum":                        KH1ItemData("Key",              code = 264_1255, classification = ItemClassification.progression, type = "Item",           max_quantity = 17),
    "High Jump":                         KH1ItemData("Shared Abilities", code = 264_2001, classification = ItemClassification.progression, type = "Shared Ability",                  ),
    "Mermaid Kick":                      KH1ItemData("Shared Abilities", code = 264_2002, classification = ItemClassification.progression, type = "Shared Ability",                  ),
    "Progressive Glide":                 KH1ItemData("Shared Abilities", code = 264_2003, classification = ItemClassification.progression, type = "Shared Ability", max_quantity = 2 ),
    #"Superglide":                       KH1ItemData("Shared Abilities", code = 264_2004, classification = ItemClassification.progression, type = "Ability",                         ),
    "Treasure Magnet":                   KH1ItemData("Abilities",        code = 264_3005, classification = ItemClassification.useful,      type = "Ability",        max_quantity = 2 ),
    "Combo Plus":                        KH1ItemData("Abilities",        code = 264_3006, classification = ItemClassification.useful,      type = "Ability",        max_quantity = 4 ),
    "Air Combo Plus":                    KH1ItemData("Abilities",        code = 264_3007, classification = ItemClassification.progression, type = "Ability",        max_quantity = 2 ),
    "Critical Plus":                     KH1ItemData("Abilities",        code = 264_3008, classification = ItemClassification.useful,      type = "Ability",        max_quantity = 3 ),
    #"Second Wind":                      KH1ItemData("Abilities",        code = 264_3009, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Scan":                              KH1ItemData("Abilities",        code = 264_3010, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Sonic Blade":                       KH1ItemData("Abilities",        code = 264_3011, classification = ItemClassification.progression, type = "Ability",                         ),
    "Ars Arcanum":                       KH1ItemData("Abilities",        code = 264_3012, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Strike Raid":                       KH1ItemData("Abilities",        code = 264_3013, classification = ItemClassification.progression, type = "Ability",                         ),
    "Ragnarok":                          KH1ItemData("Abilities",        code = 264_3014, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Trinity Limit":                     KH1ItemData("Abilities",        code = 264_3015, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Cheer":                             KH1ItemData("Abilities",        code = 264_3016, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Vortex":                            KH1ItemData("Abilities",        code = 264_3017, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Aerial Sweep":                      KH1ItemData("Abilities",        code = 264_3018, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Counterattack":                     KH1ItemData("Abilities",        code = 264_3019, classification = ItemClassification.progression, type = "Ability",                         ),
    "Blitz":                             KH1ItemData("Abilities",        code = 264_3020, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Guard":                             KH1ItemData("Abilities",        code = 264_3021, classification = ItemClassification.progression, type = "Ability",                         ),
    "Dodge Roll":                        KH1ItemData("Abilities",        code = 264_3022, classification = ItemClassification.progression, type = "Ability",                         ),
    "MP Haste":                          KH1ItemData("Abilities",        code = 264_3023, classification = ItemClassification.useful,      type = "Ability",                         ),
    "MP Rage":                           KH1ItemData("Abilities",        code = 264_3024, classification = ItemClassification.progression, type = "Ability",                         ),
    "Second Chance":                     KH1ItemData("Abilities",        code = 264_3025, classification = ItemClassification.progression, type = "Ability",                         ),
    "Berserk":                           KH1ItemData("Abilities",        code = 264_3026, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Jackpot":                           KH1ItemData("Abilities",        code = 264_3027, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Lucky Strike":                      KH1ItemData("Abilities",        code = 264_3028, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Charge":                           KH1ItemData("Abilities",        code = 264_3029, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Rocket":                           KH1ItemData("Abilities",        code = 264_3030, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Tornado":                          KH1ItemData("Abilities",        code = 264_3031, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"MP Gift":                          KH1ItemData("Abilities",        code = 264_3032, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Raging Boar":                      KH1ItemData("Abilities",        code = 264_3033, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Asp's Bite":                       KH1ItemData("Abilities",        code = 264_3034, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Healing Herb":                     KH1ItemData("Abilities",        code = 264_3035, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Wind Armor":                       KH1ItemData("Abilities",        code = 264_3036, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Crescent":                         KH1ItemData("Abilities",        code = 264_3037, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Sandstorm":                        KH1ItemData("Abilities",        code = 264_3038, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Applause!":                        KH1ItemData("Abilities",        code = 264_3039, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Blazing Fury":                     KH1ItemData("Abilities",        code = 264_3040, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Icy Terror":                       KH1ItemData("Abilities",        code = 264_3041, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Bolts of Sorrow":                  KH1ItemData("Abilities",        code = 264_3042, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Ghostly Scream":                   KH1ItemData("Abilities",        code = 264_3043, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Humming Bird":                     KH1ItemData("Abilities",        code = 264_3044, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Time-Out":                         KH1ItemData("Abilities",        code = 264_3045, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Storm's Eye":                      KH1ItemData("Abilities",        code = 264_3046, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Ferocious Lunge":                  KH1ItemData("Abilities",        code = 264_3047, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Furious Bellow":                   KH1ItemData("Abilities",        code = 264_3048, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Spiral Wave":                      KH1ItemData("Abilities",        code = 264_3049, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Thunder Potion":                   KH1ItemData("Abilities",        code = 264_3050, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Cure Potion":                      KH1ItemData("Abilities",        code = 264_3051, classification = ItemClassification.useful,      type = "Ability",                         ),
    #"Aero Potion":                      KH1ItemData("Abilities",        code = 264_3052, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Slapshot":                          KH1ItemData("Abilities",        code = 264_3053, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Sliding Dash":                      KH1ItemData("Abilities",        code = 264_3054, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Hurricane Blast":                   KH1ItemData("Abilities",        code = 264_3055, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Ripple Drive":                      KH1ItemData("Abilities",        code = 264_3056, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Stun Impact":                       KH1ItemData("Abilities",        code = 264_3057, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Gravity Break":                     KH1ItemData("Abilities",        code = 264_3058, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Zantetsuken":                       KH1ItemData("Abilities",        code = 264_3059, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Tech Boost":                        KH1ItemData("Abilities",        code = 264_3060, classification = ItemClassification.useful,      type = "Ability",        max_quantity = 4 ),
    "Encounter Plus":                    KH1ItemData("Abilities",        code = 264_3061, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Leaf Bracer":                       KH1ItemData("Abilities",        code = 264_3062, classification = ItemClassification.progression, type = "Ability",                         ),
    #"Evolution":                        KH1ItemData("Abilities",        code = 264_3063, classification = ItemClassification.useful,      type = "Ability",                         ),
    "EXP Zero":                          KH1ItemData("Abilities",        code = 264_3064, classification = ItemClassification.useful,      type = "Ability",                         ),
    "Combo Master":                      KH1ItemData("Abilities",        code = 264_3065, classification = ItemClassification.progression, type = "Ability",                         )
}

event_item_table: Dict[str, KH1ItemData] = {
    "Victory": KH1ItemData("Event", code = None, classification = ItemClassification.progression, type = "Event")
}

#Make item categories
item_name_groups: Dict[str, Set[str]] = {}
for item in item_table.keys():
    category = item_table[item].category
    if category not in item_name_groups.keys():
        item_name_groups[category] = set()
    item_name_groups[category].add(item)
