poptracker_data_detailed = {
    'A Path Through the Goo/': 1490067,
    'A Wall Jump in the Bucket/': 1490007,
    'Across the Dreamscape/': 1490074,
    'Across the Rooftops/': 1490019,
    'Across the Trench of Darkness/': 1490038,
    'Ambush at the Tree Dome/': 1490005,
    'Ambush in the Lighthouse/': 1490021,
    'Balloon Kid #1 (Near Ms. Puff)/': 1490195,
    'Balloon Kid #2 (On beach near moving logs)/': 1490196,
    'Balloon Kid #3 (On beach near sinking logs)/': 1490197,
    'Balloon Kid #4 (On Water near moving logs)/': 1490198,
    'Balloon Kid #5 (On Water near sinking logs)/': 1490199,
    'Beat Bubble Buddy\'s Time/': 1490054,
    'Beat Larry\'s Time/': 1490056,
    'Beat Mermaid Man\'s Time/': 1490065,
    'Beat Mrs. Puff\'s Time/': 1490052,
    'Chum Bucket Lab/KAH - RAH - TAE!': 1490082,
    'Chum Bucket Lab/The Small Shall Rule... Or No': 1490083,
    'Clean out the Bumper Boats/': 1490029,
    'Come Back With the Cruise Bubble/': 1490023,
    'Complete the Rolling Ball Room/': 1490047,
    'Connect the Towers/': 1490025,
    'Cowa-Bungee!/': 1490009,
    'Defeat King Jellyfish/': 1490015,
    'Defeat Prawn/': 1490048,
    'Defeat Robots on Flounder Hill/': 1490053,
    'Defeat Robots on Guppy Mound/': 1490051,
    'Defeat Robots on Sand Mountain/': 1490055,
    'Defeat the Flying Dutchman/': 1490073,
    'Destroy the Robot Ship/': 1490071,
    'Down in the Swamp/': 1490061,
    'Drain the Lake/': 1490013,
    'End of the Road/': 1490016,
    'Extreme Bungee/': 1490022,
    'Find All the Lost Campers/': 1490059,
    'Follow the Bouncing Ball/': 1490075,
    'Frosty Bungee/': 1490049,
    'Get Aloft There, Matey!/': 1490072,
    'Get to the Museum/': 1490033,
    'Golden Underwear #1/': 1490180,
    'Golden Underwear #2/': 1490181,
    'Golden Underwear #3/': 1490182,
    'Goo Tanker Ahoy!/': 1490068,
    'Here You Go/': 1490081,
    'How in Tarnation Do You Get There?/': 1490040,
    'Industrial Park/Cruise Bubble': 1490235,
    'Industrial Park/Defeat Robo-Patrick': 1490057,
    'Kelp Vine Slide/': 1490064,
    'King Jellyfish Jelly/': 1490183,
    'King of the Castle/': 1490024,
    'Krabby Patty Platforms/': 1490079,
    'Krusty Krab/Infestation at the Krusty Krab': 1490006,
    'Krusty Krab/Lost Sock (Destroy furniture)': 1490107,
    'Lasers are Fun and Good for You/': 1490039,
    'Learn Sandy\'s Moves/': 1490017,
    'Lost Camper #1 (Near Ms Puff)/': 1490218,
    'Lost Camper #2 (Near waterfall)/': 1490219,
    'Lost Camper #3 (Near slide area exit)/': 1490220,
    'Lost Camper #4/': 1490221,
    'Lost Camper #5 (At gate)/': 1490222,
    'Lost Camper #6 (Near exit)/': 1490223,
    'Lost Sock #1 (At end after destroying all Sandmans)/': 1490160,
    'Lost Sock #1 (Below bridge)/': 1490155,
    'Lost Sock #1 (Bungee)/': 1490148,
    'Lost Sock #1 (Ledge near exit)/': 1490145,
    'Lost Sock #1 (Ledge near start)/': 1490157,
    'Lost Sock #1 (On Cliff near Clamp)/': 1490118,
    'Lost Sock #1 (On JF rock)/': 1490108,
    'Lost Sock #1 (On broken house)/': 1490122,
    'Lost Sock #1 (On high platform near Ms. Puff)/': 1490165,
    'Lost Sock #1 (On ledge)/': 1490168,
    'Lost Sock #1 (On roof near elevator)/': 1490142,
    'Lost Sock #1 (On slide)/': 1490114,
    'Lost Sock #1 (On top slide near skull)/': 1490175,
    'Lost Sock #1 (On watchtower)/': 1490131,
    'Lost Sock #1 (On windmill)/': 1490126,
    'Lost Sock #1 (Tiki minigame)/': 1490139,
    'Lost Sock #1 (Top ledge near start)/': 1490162,
    'Lost Sock #1 (Under ledge near entrance)/': 1490136,
    'Lost Sock #2 (After slide)/': 1490115,
    'Lost Sock #2 (At waterfall)/': 1490166,
    'Lost Sock #2 (Bungee)/': 1490109,
    'Lost Sock #2 (In broken house)/': 1490123,
    'Lost Sock #2 (In hidden cave)/': 1490163,
    'Lost Sock #2 (In sand castle)/': 1490132,
    'Lost Sock #2 (Midway right ledge)/': 1490146,
    'Lost Sock #2 (Near Duplicatotron)/': 1490149,
    'Lost Sock #2 (Oil tower)/': 1490176,
    'Lost Sock #2 (On goo)/': 1490137,
    'Lost Sock #2 (On last tunnel near end)/': 1490161,
    'Lost Sock #2 (On rock)/': 1490143,
    'Lost Sock #2 (On tiki stack)/': 1490169,
    'Lost Sock #2 (Sliding minigame)/': 1490140,
    'Lost Sock #2 (Snowman)/': 1490156,
    'Lost Sock #2 (Tiki Minigame)/': 1490119,
    'Lost Sock #2 (Under slide)/': 1490127,
    'Lost Sock #2 (Underpass)/': 1490158,
    'Lost Sock #3 (At button under laser)/': 1490150,
    'Lost Sock #3 (Behind house on Swingers platform)/': 1490177,
    'Lost Sock #3 (Behind lighthouse)/': 1490128,
    'Lost Sock #3 (In cave near slide)/': 1490116,
    'Lost Sock #3 (Ledge near end)/': 1490159,
    'Lost Sock #3 (Near slide end)/': 1490144,
    'Lost Sock #3 (Near wall jumps)/': 1490120,
    'Lost Sock #3 (On booth)/': 1490141,
    'Lost Sock #3 (On floating platform)/': 1490124,
    'Lost Sock #3 (On ice platforms)/': 1490164,
    'Lost Sock #3 (On island)/': 1490110,
    'Lost Sock #3 (On juice bar)/': 1490133,
    'Lost Sock #3 (On side ledge)/': 1490138,
    'Lost Sock #3 (Tiki bowling)/': 1490167,
    'Lost Sock #3 (Under entrance)/': 1490147,
    'Lost Sock #4 (Fountain)/': 1490111,
    'Lost Sock #4 (On copper house)/': 1490125,
    'Lost Sock #4 (On goo in cave)/': 1490117,
    'Lost Sock #4 (On top of sand castle)/': 1490134,
    'Lost Sock #5 (On goo)/': 1490112,
    'Lost Sock #5 (Sand castle entrance gate)/': 1490135,
    'Lost Sock #6 (Bowling minigame)/': 1490113,
    'Lost Sock (Behind KK under trash)/': 1490100,
    'Lost Sock (Behind grill)/': 1490179,
    'Lost Sock (Behind tilting platform near end)/': 1490154,
    'Lost Sock (Bungee)/': 1490151,
    'Lost Sock (Conveyor clamp)/': 1490153,
    'Lost Sock (Fountain)/': 1490101,
    'Lost Sock (In air near trampoline)/': 1490178,
    'Lost Sock (In shipwreck)/': 1490173,
    'Lost Sock (On Slide after King JF)/': 1490121,
    'Lost Sock (On ledge near entrance)/': 1490170,
    'Lost Sock (On light)/': 1490152,
    'Lost Sock (On mast platform in goo)/': 1490172,
    'Lost Sock (On rope on robot ship)/': 1490174,
    'Lost Sock (On slide)/': 1490171,
    'Lost Sock (On top)/': 1490129,
    'Lost Sock (Shoals)/': 1490106,
    'Lost Sock (South side)/': 1490130,
    'Mr. Krabs/Pay Mr. Krabs 3000 Shiny Objects': 1490092,
    'Mr. Krabs/Pay Mr. Krabs 3500 Shiny Objects': 1490093,
    'Mr. Krabs/Pay Mr. Krabs 4000 Shiny Objects': 1490094,
    'Mr. Krabs/Pay Mr. Krabs 4500 Shiny Objects': 1490095,
    'Mr. Krabs/Pay Mr. Krabs 5000 Shiny Objects': 1490096,
    'Mr. Krabs/Pay Mr. Krabs 5500 Shiny Objects': 1490097,
    'Mr. Krabs/Pay Mr. Krabs 6500 Shiny Objects': 1490098,
    'Mr. Krabs/Pay Mr. Krabs 7500 Shiny Objects': 1490099,
    'Museum Art #1 (On ledge above bubble buddy)/': 1490200,
    'Museum Art #2 (Near start)/': 1490201,
    'Museum Art #3 (Bottom)/': 1490202,
    'Museum Art #4 (Near exit)/': 1490203,
    'Museum Art #5 (Behind laser)/': 1490204,
    'Museum Art #6 (On Sleepy-Time platform)/': 1490205,
    'Music is in the Ear of the Beholder/': 1490078,
    'Navigate the Canyons and Mesas/': 1490012,
    'On Top of Shady Shoals/': 1490001,
    'On Top of the Chum Bucket/': 1490002,
    'On Top of the Pineapple/': 1490000,
    'Over the Moat/': 1490027,
    'Patrick\'s Dilemma/': 1490011,
    'Patrick\'s Rock/Lost Sock (Destroy furniture)': 1490105,
    'Patrick/Lost Sock (Patrick)': 1490102,
    'Patrick/Return 10 Socks To Patrick': 1490084,
    'Patrick/Return 20 Socks To Patrick': 1490085,
    'Patrick/Return 30 Socks To Patrick': 1490086,
    'Patrick/Return 40 Socks To Patrick': 1490087,
    'Patrick/Return 50 Socks To Patrick': 1490088,
    'Patrick/Return 60 Socks To Patrick': 1490089,
    'Patrick/Return 70 Socks To Patrick': 1490090,
    'Patrick/Return 80 Socks To Patrick': 1490091,
    'Pineapple/Lost Sock (Library)': 1490103,
    'Pineapple/SpongeBob\'s Closet': 1490003,
    'Plundering Robots in the Museum/': 1490037,
    'Poseidome/Bubble Bowl': 1490234,
    'Poseidome/Defeat Robo-Sandy': 1490032,
    'Power Crystal #1 (behind 1st gate)/': 1490224,
    'Power Crystal #2 (water room top)/': 1490225,
    'Power Crystal #3 (top near 3rd gate)/': 1490226,
    'Power Crystal #4 (top big room)/': 1490227,
    'Power Crystal #5 (top tall vine room)/': 1490228,
    'Power Crystal #6 (top last room)/': 1490229,
    'Power Crystal Crisis/': 1490063,
    'Purple Shiny Object #1 (At fenced off glove near lighthouse)/': 1490241,
    'Purple Shiny Object #1 (In hidden cave near entrance)/': 1490254,
    'Purple Shiny Object #1 (On floating platforms)/': 1490243,
    'Purple Shiny Object #1 (On slide under tikis)/': 1490259,
    'Purple Shiny Object #1 (On tikis near start)/': 1490270,
    'Purple Shiny Object #2 (In flower)/': 1490271,
    'Purple Shiny Object #2 (On platform near lighthouse)/': 1490242,
    'Purple Shiny Object #2 (On slide)/': 1490255,
    'Purple Shiny Object #2 (On stone arch)/': 1490260,
    'Purple Shiny Object #2 (On top of windmill blades)/': 1490244,
    'Purple Shiny Object (Above disco floor at 2nd tunnel entrance)/': 1490256,
    'Purple Shiny Object (Behind Chum Bucket)/': 1490236,
    'Purple Shiny Object (Behind Krusty Krab)/': 1490269,
    'Purple Shiny Object (Bungee near waterfall)/': 1490263,
    'Purple Shiny Object (By floating tiki near exit)/': 1490252,
    'Purple Shiny Object (Duplicatotron bowling)/': 1490253,
    'Purple Shiny Object (End of log path near Ms. Puff)/': 1490247,
    'Purple Shiny Object (In ball dispenser)/': 1490257,
    'Purple Shiny Object (In cave on drop to cave exit)/': 1490261,
    'Purple Shiny Object (In tiki stack)/': 1490245,
    'Purple Shiny Object (Near waterfall)/': 1490262,
    'Purple Shiny Object (On clarinet)/': 1490272,
    'Purple Shiny Object (On floating tiki near start)/': 1490273,
    'Purple Shiny Object (On goo near exit)/': 1490238,
    'Purple Shiny Object (On goo under bridge)/': 1490239,
    'Purple Shiny Object (On island)/': 1490237,
    'Purple Shiny Object (On ledge near entrance)/': 1490258,
    'Purple Shiny Object (On ledge under checkpoint)/': 1490248,
    'Purple Shiny Object (On left wall near tubelet)/': 1490266,
    'Purple Shiny Object (On mast under 1st ship wall jump section)/': 1490267,
    'Purple Shiny Object (On roof)/': 1490251,
    'Purple Shiny Object (On slide)/': 1490265,
    'Purple Shiny Object (On tikis after slide)/': 1490249,
    'Purple Shiny Object (On top of mast)/': 1490268,
    'Purple Shiny Object (South side)/': 1490246,
    'Purple Shiny Object (Top of tall room)/': 1490264,
    'Return the Museum\'s Art/': 1490035,
    'Sandman #1 (At Start)/': 1490210,
    'Sandman #2 (Lower path after first turn)/': 1490211,
    'Sandman #3 (On shortcut)/': 1490212,
    'Sandman #4 (On right spiral)/': 1490213,
    'Sandman #5 (On left spiral)/': 1490214,
    'Sandman #6 (Middle path of 1st 3-way split near end)/': 1490215,
    'Sandman #7 (Left path of 1st 3-way split near end)/': 1490216,
    'Sandman #8 (On turn after cave)/': 1490217,
    'Save the Children/': 1490026,
    'Security Override Button #1 (At Computer)/': 1490206,
    'Security Override Button #2 (At Lasers)/': 1490207,
    'Security Override Button #3 (At Top)/': 1490208,
    'Security Override Button #4 (Next to ramp)/': 1490209,
    'Ship Cannon #1 (On deck)/': 1490230,
    'Ship Cannon #2 (On middle mast)/': 1490231,
    'Ship Cannon #3 (On front mast)/': 1490232,
    'Ship Cannon #4 (Near steering wheel)/': 1490233,
    'Shipwreck Bungee/': 1490070,
    'Shut Down the Security System/': 1490043,
    'Slide Leap/': 1490014,
    'Slidin\' Texas Style/': 1490076,
    'Slip Sliding Away/': 1490034,
    'Slip and Slide Under the Pier/': 1490030,
    'Spelunking/': 1490010,
    'Squidward/Annoy Squidward': 1490004,
    'Squidward/Lost Sock (Destroy furniture)': 1490104,
    'Steering Wheel #1 (On tikis near start)/': 1490184,
    'Steering Wheel #10 (East side)/': 1490193,
    'Steering Wheel #11 (North side)/': 1490194,
    'Steering Wheel #2 (On canopy)/': 1490185,
    'Steering Wheel #3 (On house with cannon near rooftops exit)/': 1490186,
    'Steering Wheel #4 (On crashed boat near sea needle)/': 1490187,
    'Steering Wheel #5 (Above G-Love near hole)/': 1490188,
    'Steering Wheel #6 (On pipe near start)/': 1490189,
    'Steering Wheel #7 (Under slide)/': 1490190,
    'Steering Wheel #8 (On floating platforms)/': 1490191,
    'Steering Wheel #9 (At bottom)/': 1490192,
    'Super Bounce/': 1490080,
    'Swingalong Spatula/': 1490036,
    'Swingalong Spatula/Purple Shiny Object (Under Swingalong Spatula)': 1490250,
    'Swingers Ahoy/': 1490077,
    'Swingin\' Sandy/': 1490020,
    'The Funnel Machines/': 1490044,
    'The Spinning Towers of Power/': 1490045,
    'Through the Kelp Caves/': 1490062,
    'Through the Sea Caves/': 1490028,
    'Through the Woods/': 1490058,
    'Tiki Roundup/': 1490060,
    'Tikis Go Boom/': 1490018,
    'Top of the Computer Area/': 1490042,
    'Top of the Entrance Area/': 1490066,
    'Top of the Hill/': 1490008,
    'Top of the Lodge/': 1490050,
    'Top of the Security Tunnel/': 1490046,
    'Top of the Stack of Ships/': 1490069,
    'Tower Bungee/': 1490031
}
poptracker_data_overview = {
    'Chum Bucket Lab/Golden Spatula': 1490082,
    'Chum Bucket Lab/Golden Spatula (requires Bubble Bowl)': 1490083,
    'Chum Bucket/Golden Spatula': 1490007,
    'Downtown Bikini Bottom 1/Golden Spatula': 1490018,
    'Downtown Bikini Bottom 1/Golden Spatula (requires Steering Wheels)': 1490016,
    'Downtown Bikini Bottom 1/Lost Sock': 1490125,
    'Downtown Bikini Bottom 1/Purple Shiny Object': 1490242,
    'Downtown Bikini Bottom 1/Steering Wheel': 1490188,
    'Downtown Bikini Bottom 2/Golden Spatula': 1490020,
    'Downtown Bikini Bottom 2/Lost Sock': 1490128,
    'Downtown Bikini Bottom 2/Purple Shiny Object': 1490244,
    'Downtown Bikini Bottom 2/Steering Wheel': 1490191,
    'Downtown Bikini Bottom 3/Golden Spatula': 1490021,
    'Downtown Bikini Bottom 3/Lost Sock': 1490129,
    'Downtown Bikini Bottom 3/Purple Shiny Object': 1490245,
    'Downtown Bikini Bottom 3/Steering Wheel': 1490192,
    'Downtown Bikini Bottom 4/Golden Spatula': 1490022,
    'Downtown Bikini Bottom 4/Golden Spatula (requires Cruise Bubble)': 1490023,
    'Downtown Bikini Bottom 4/Lost Sock (requires Cruise Bubble)': 1490130,
    'Downtown Bikini Bottom 4/Purple Shiny Object (requires Cruise Bubble)': 1490246,
    'Downtown Bikini Bottom 4/Steering Wheel': 1490194,
    'Flying Dutchman\'s Graveyard 1/Golden Spatula': 1490066,
    'Flying Dutchman\'s Graveyard 1/Golden Spatula (requires Cruise Bubble)': 1490068,
    'Flying Dutchman\'s Graveyard 1/Lost Sock': 1490172,
    'Flying Dutchman\'s Graveyard 1/Purple Shiny Object': 1490266,
    'Flying Dutchman\'s Graveyard 2/Golden Spatula': 1490070,
    'Flying Dutchman\'s Graveyard 2/Lost Sock': 1490173,
    'Flying Dutchman\'s Graveyard 2/Purple Shiny Object': 1490267,
    'Flying Dutchman\'s Graveyard 3/Golden Spatula (requires Cannons)': 1490072,
    'Flying Dutchman\'s Graveyard 3/Lost Sock': 1490174,
    'Flying Dutchman\'s Graveyard 3/Purple Shiny Object (requires Cannons)': 1490268,
    'Flying Dutchman\'s Graveyard 3/Ship Cannon': 1490233,
    'Flying Dutchman\'s Graveyard 4/Golden Spatula': 1490073,
    'Goo Lagoon 1/Balloon Kid': 1490199,
    'Goo Lagoon 1/Golden Spatula': 1490027,
    'Goo Lagoon 1/Golden Spatula (requires Balloon Kids)': 1490026,
    'Goo Lagoon 1/Lost Sock': 1490135,
    'Goo Lagoon 1/Purple Shiny Object': 1490247,
    'Goo Lagoon 2/Golden Spatula': 1490028,
    'Goo Lagoon 2/Lost Sock': 1490138,
    'Goo Lagoon 2/Purple Shiny Object': 1490248,
    'Goo Lagoon 3/Golden Spatula': 1490031,
    'Goo Lagoon 3/Lost Sock': 1490141,
    'Goo Lagoon 3/Purple Shiny Object': 1490249,
    'Hub 1/Golden Spatula': 1490000,
    'Hub 1/Golden Underwear': 1490180,
    'Hub 1/Lost Sock': 1490102,
    'Hub 2/Golden Spatula': 1490001,
    'Hub 2/Golden Underwear': 1490181,
    'Hub 2/Lost Sock': 1490101,
    'Hub 3/Golden Spatula': 1490002,
    'Hub 3/Golden Underwear': 1490182,
    'Hub 3/Lost Sock': 1490100,
    'Hub 3/Purple Shiny Object': 1490236,
    'Industrial Park/Cruise Bubble': 1490235,
    'Industrial Park/Golden Spatula': 1490057,
    'Jellyfish Fields 1/Golden Spatula': 1490009,
    'Jellyfish Fields 1/Golden Spatula (requires King Jellyfish Jelly)': 1490015,
    'Jellyfish Fields 1/Lost Sock': 1490112,
    'Jellyfish Fields 1/Lost Sock (requires Bubble Bowl)': 1490113,
    'Jellyfish Fields 1/Purple Shiny Object': 1490237,
    'Jellyfish Fields 2/Golden Spatula': 1490011,
    'Jellyfish Fields 2/Lost Sock': 1490117,
    'Jellyfish Fields 2/Purple Shiny Object': 1490238,
    'Jellyfish Fields 3/Golden Spatula': 1490013,
    'Jellyfish Fields 3/Lost Sock': 1490120,
    'Jellyfish Fields 3/Lost Sock (requires Cruise Bubble)': 1490119,
    'Jellyfish Fields 3/Purple Shiny Object': 1490239,
    'Jellyfish Fields 4/Golden Spatula': 1490014,
    'Jellyfish Fields 4/King Jellyfish Jelly': 1490183,
    'Jellyfish Fields 4/Lost Sock': 1490121,
    'Jellyfish Fields 4/Purple Shiny Object': 1490240,
    'Kelp Forest 1/Golden Spatula': 1490058,
    'Kelp Forest 1/Golden Spatula (requires Lost Campers)': 1490059,
    'Kelp Forest 1/Lost Camper (requires Cruise Bubble)': 1490220,
    'Kelp Forest 1/Lost Sock': 1490166,
    'Kelp Forest 1/Lost Sock (requires Bubble Bowl)': 1490167,
    'Kelp Forest 1/Purple Shiny Object (requires Cruise Bubble)': 1490262,
    'Kelp Forest 2/Golden Spatula': 1490061,
    'Kelp Forest 2/Lost Camper': 1490222,
    'Kelp Forest 2/Lost Sock': 1490169,
    'Kelp Forest 2/Purple Shiny Object': 1490263,
    'Kelp Forest 4/Golden Spatula (requires Cruise Bubble and Power Crystals)': 1490063,
    'Kelp Forest 4/Golden Spatula (requires Cruise Bubble)': 1490062,
    'Kelp Forest 4/Lost Camper (requires Cruise Bubble)': 1490223,
    'Kelp Forest 4/Lost Sock (requires Cruise Bubble)': 1490170,
    'Kelp Forest 4/Power Crystal (requires Cruise Bubble)': 1490229,
    'Kelp Forest 4/Purple Shiny Object (requires Cruise Bubble)': 1490264,
    'Kelp Forest 5/Golden Spatula': 1490065,
    'Kelp Forest 5/Lost Sock': 1490171,
    'Kelp Forest 5/Purple Shiny Object': 1490265,
    'Krusty Krab/Golden Spatula': 1490006,
    'Krusty Krab/Lost Sock': 1490107,
    'Mermalair 1/Golden Spatula (requires Bubble Bowl)': 1490041,
    'Mermalair 1/Lost Sock (requires Bubble Bowl)': 1490151,
    'Mermalair 1/Purple Shiny Object (requires Bubble Bowl or Cruise Bubble)': 1490253,
    'Mermalair 2/Golden Spatula': 1490045,
    'Mermalair 2/Golden Spatula (requires Security Override Buttons)': 1490043,
    'Mermalair 2/Lost Sock': 1490152,
    'Mermalair 2/Purple Shiny Object': 1490255,
    'Mermalair 2/Security Override Button': 1490207,
    'Mermalair 3/Golden Spatula': 1490046,
    'Mermalair 3/Lost Sock': 1490153,
    'Mermalair 3/Purple Shiny Object': 1490256,
    'Mermalair 3/Security Override Button': 1490208,
    'Mermalair 4/Golden Spatula': 1490047,
    'Mermalair 4/Lost Sock': 1490154,
    'Mermalair 4/Purple Shiny Object': 1490257,
    'Mermalair 4/Security Override Button': 1490209,
    'Mermalair 5/Golden Spatula': 1490048,
    'Mr. Krabs/Golden Spatula #1': 1490092,
    'Mr. Krabs/Golden Spatula #2': 1490093,
    'Mr. Krabs/Golden Spatula #3': 1490094,
    'Mr. Krabs/Golden Spatula #4': 1490095,
    'Mr. Krabs/Golden Spatula #5': 1490096,
    'Mr. Krabs/Golden Spatula #6': 1490097,
    'Mr. Krabs/Golden Spatula #7': 1490098,
    'Mr. Krabs/Golden Spatula #8': 1490099,
    'Patrick\'s Rock/Lost Sock': 1490105,
    'Patrick/Golden Spatula #1': 1490084,
    'Patrick/Golden Spatula #2': 1490085,
    'Patrick/Golden Spatula #3': 1490086,
    'Patrick/Golden Spatula #4': 1490087,
    'Patrick/Golden Spatula #5': 1490088,
    'Patrick/Golden Spatula #6': 1490089,
    'Patrick/Golden Spatula #7': 1490090,
    'Patrick/Golden Spatula #8': 1490091,
    'Pineapple/Golden Spatula': 1490003,
    'Pineapple/Lost Sock': 1490103,
    'Poseidome/Bubble Bowl': 1490234,
    'Poseidome/Golden Spatula': 1490032,
    'Rock Bottom 1/Golden Spatula': 1490036,
    'Rock Bottom 1/Golden Spatula (requires Museum Art)': 1490035,
    'Rock Bottom 1/Lost Sock': 1490144,
    'Rock Bottom 1/Museum Art': 1490201,
    'Rock Bottom 1/Purple Shiny Object': 1490250,
    'Rock Bottom 2/Golden Spatula': 1490037,
    'Rock Bottom 2/Lost Sock': 1490147,
    'Rock Bottom 2/Museum Art': 1490203,
    'Rock Bottom 2/Purple Shiny Object': 1490251,
    'Rock Bottom 3/Golden Spatula': 1490040,
    'Rock Bottom 3/Lost Sock': 1490150,
    'Rock Bottom 3/Museum Art': 1490205,
    'Rock Bottom 3/Purple Shiny Object': 1490252,
    'Sand Mountain 1/Golden Spatula': 1490050,
    'Sand Mountain 1/Lost Sock': 1490156,
    'Sand Mountain 1/Purple Shiny Object': 1490258,
    'Sand Mountain 2/Golden Spatula': 1490052,
    'Sand Mountain 2/Lost Sock': 1490159,
    'Sand Mountain 2/Purple Shiny Object': 1490260,
    'Sand Mountain 3/Golden Spatula': 1490054,
    'Sand Mountain 3/Lost Sock': 1490161,
    'Sand Mountain 3/Lost Sock (requires Sandman)': 1490160,
    'Sand Mountain 3/Sandman': 1490217,
    'Sand Mountain 4/Golden Spatula': 1490056,
    'Sand Mountain 4/Lost Sock': 1490164,
    'Sand Mountain 4/Purple Shiny Object': 1490261,
    'Shoals/Lost Sock': 1490106,
    'Spongebob\'s Dream 1/Golden Spatula': 1490080,
    'Spongebob\'s Dream 1/Golden Spatula (requires Bubble Bowl)': 1490075,
    'Spongebob\'s Dream 1/Purple Shiny Object': 1490269,
    'Spongebob\'s Dream 2/Golden Spatula': 1490077,
    'Spongebob\'s Dream 2/Lost Sock': 1490177,
    'Spongebob\'s Dream 2/Purple Shiny Object': 1490271,
    'Spongebob\'s Dream 3/Golden Spatula': 1490078,
    'Spongebob\'s Dream 3/Lost Sock': 1490178,
    'Spongebob\'s Dream 3/Purple Shiny Object': 1490272,
    'Spongebob\'s Dream 4/Golden Spatula': 1490079,
    'Spongebob\'s Dream 4/Lost Sock': 1490179,
    'Spongebob\'s Dream 4/Purple Shiny Object': 1490273,
    'Spongebob\'s Dream 5/Golden Spatula': 1490081,
    'Squidward/Golden Spatula': 1490004,
    'Squidward/Lost Sock': 1490104,
    'Tree Dome/Golden Spatula': 1490005
}


def map_page_index(data):
    mapping = {
        'HB01': 0,
        'HB02': 0,
        'HB03': 0,
        'HB04': 0,
        'HB05': 0,
        'HB06': 0,
        'HB07': 0,
        'HB08': 0,
        'HB09': 0,
        'HB10': 0,
        'JF01': 1,
        'JF02': 2,
        'JF03': 5,
        'JF04': 6,
        'BB01': 7,
        'BB02': 8,
        'BB03': 9,
        'BB04': 10,
        'GL01': 11,
        'GL02': 12,
        'GL03': 13,
        'B101': 0,
        'BC01': 14,
        'BC02': 15,
        'BC03': 16,
        'BC04': 17,
        'BC05': 18,
        'RB01': 19,
        'RB02': 20,
        'RB03': 21,
        'SM01': 22,
        'SM02': 23,
        'SM03': 24,
        'SM04': 25,
        'B201': 0,
        'KF01': 26,
        'KF02': 27,
        'KF04': 28,
        'KF05': 29,
        'GY01': 30,
        'GY02': 31,
        'GY03': 32,
        'GY04': 33,
        'DB01': 34,
        'DB02': 35,
        'DB03': 36,
        'DB04': 37,
        'DB05': 34,
        'DB06': 34,
        'B302': 0,
        'B303': 0,
    }
    return mapping.get(data, 0)


tracker_world_overview = {
    "map_page_folder": "tracker",
    "map_page_maps": [
        "maps/maps.json",
    ],
    "map_page_locations": [
        "locations/locations.json",
    ],
    "poptracker_name_mapping": poptracker_data_overview,
}

tracker_world_detailed = {
    "map_page_folder": "tracker",
    "map_page_maps": [
        "maps/maps.json",
        "var_detailed/maps/maps_detailed.json",
    ],
    "map_page_locations": [
        "var_detailed/locations/bb.json",
        "var_detailed/locations/bc.json",
        "var_detailed/locations/db.json",
        "var_detailed/locations/gl.json",
        "var_detailed/locations/gy.json",
        "var_detailed/locations/hb.json",
        "var_detailed/locations/jf.json",
        "var_detailed/locations/kf.json",
        "var_detailed/locations/rb.json",
        "var_detailed/locations/sm.json",
    ],
    "map_page_setting_key": "bfbb_current_scene_T{team}_P{player}",
    "map_page_index": map_page_index,
    "poptracker_name_mapping": poptracker_data_detailed,
}
