from typing import Dict, Tuple
from worlds.generic.Rules import CollectionRule, ItemRule
from .Names import names as el

def get_rules(p : int) -> Tuple[Dict[str, CollectionRule], Dict[str, ItemRule]]: 

	macros : Dict[str, CollectionRule] = {
		'3LEDGE'      : lambda s : s.has(el['djump'], p) and s.has(el['silva'], p) and s.has(el['champion'], p),
		'2LEDGE'      : lambda s : s.has(el['djump'], p) and s.has(el['silva'], p) or s.has(el['djump'], p) and s.has(el['champion'], p) or s.has(el['silva'], p) and s.has(el['champion'], p),
		'LEDGE'       : lambda s : s.has(el['djump'], p) or s.has(el['silva'], p) or s.has(el['champion'], p),
		'2HORIZONTAL' : lambda s : s.has(el['dodge'], p) and s.has(el['sinner'], p),
		'HORIZONTAL'  : lambda s : s.has(el['dodge'], p) or s.has(el['sinner'], p),
		'FULLSILVA'   : lambda s : s.has(el['silva'], p) and s.has(el['djump'], p) and s.has(el['dodge'], p),
		'CHARGE'      : lambda s : s.has(el['pierce'], p) and s.has(el['dash'], p),
		'3HEAL'       : lambda s : s.has(el['heal1'], p) and s.has(el['heal2'], p) and s.has(el['heal3'], p),
	}

	locations_rules : Dict[str, CollectionRule] = {
		"The Abyss 01 - Silva's Blight-Stained Note 1"         : lambda s : s.can_reach(el['Abyss01Top'], 'Region', p),
		"The Abyss 01 - Furious Blight x100"                   : lambda s : s.can_reach(el['Abyss01Bottom'], 'Region', p),
		"The Abyss 01 To Verboten Domain 18"                   : lambda s : s.can_reach(el['Abyss01Top'], 'Region', p),
		"The Abyss 01 To The Abyss 02"                         : lambda s : s.can_reach(el['Abyss01Bottom'], 'Region', p) or s.can_reach(el['Abyss01Top'], 'Region', p) and macros['CHARGE'](s) and s.has(el['slam'], p) and s.has(el['swim'], p) and (macros['2HORIZONTAL'](s) and macros['LEDGE'](s) or macros['FULLSILVA'](s) or macros['3LEDGE'](s) or s.has(el['silva'], p) and (s.has(el['dodge'], p) or s.has(el['djump'], p)) or s.has(el['champion'], p) and s.has(el['djump'], p) or s.has(el['claw'], p) and macros['HORIZONTAL'](s) and macros['LEDGE'](s)) and (s.has(el['hook'], p) or macros['FULLSILVA'](s) or macros['3LEDGE'](s) or macros['2HORIZONTAL'](s) and macros['LEDGE'](s)),
		"The Abyss 02 - Amulet Fragment"                       : lambda s : s.can_reach(el['Abyss02Top'], 'Region', p) and s.has(el['claw'], p) and (macros['2LEDGE'](s) or macros['2LEDGE'](s) and macros['HORIZONTAL'](s) or macros['2HORIZONTAL'](s) and macros['LEDGE'](s) or s.has(el['dodge'], p) and s.has(el['dash'], p) and macros['LEDGE'](s)),
		"The Abyss 02 - Silva's Blight-Stained Note 2"         : lambda s : s.can_reach(el['Abyss02Top'], 'Region', p),
		"The Abyss 02 - Fretia's Memoirs 5"                    : lambda s : s.can_reach(el['Abyss02Top'], 'Region', p),
		"The Abyss 02 - White Priestess' Earrings"             : lambda s : s.can_reach(el['Abyss02Top'], 'Region', p),
		"The Abyss 02 To The Abyss 03"                         : lambda s : s.can_reach(el['Abyss02Right'], 'Region', p) or s.can_reach(el['Abyss02Top'], 'Region', p),
		"The Abyss 02 To The Abyss 01"                         : lambda s : s.can_reach(el['Abyss02Top'], 'Region', p) or s.can_reach(el['Abyss02Right'], 'Region', p),
		"The Abyss 03 To The Abyss 02"                         : lambda s : s.can_reach(el['Abyss03Left'], 'Region', p),
		"The Abyss 04 - Upper Stagnant Blight x100"            : lambda s : s.can_reach(el['Abyss04Top'], 'Region', p) and s.has(el['mask'], p) and s.has(el['claw'], p) and s.has(el['slam'], p) and s.has(el['hook'], p) and macros['3HEAL'](s) and s.has(el['dash'], p),
		"The Abyss 04 - Lower Stagnant Blight x100"            : lambda s : s.can_reach(el['Abyss04Top'], 'Region', p) and s.has(el['mask'], p) and s.has(el['claw'], p) and s.has(el['slam'], p) and s.has(el['hook'], p) and macros['3HEAL'](s) and s.has(el['dash'], p),
		"The Abyss 04 To Verboten Domain 12"                   : lambda s : s.can_reach(el['Abyss04Top'], 'Region', p),
		"The Abyss 04 To The Abyss 05"                         : lambda s : s.can_reach(el['Abyss04Bottom'], 'Region', p) or s.can_reach(el['Abyss04Top'], 'Region', p) and s.has(el['mask'], p) and s.has(el['claw'], p) and s.has(el['swim'], p) and s.has(el['slam'], p) and s.has(el['hook'], p) and macros['3HEAL'](s) and s.has(el['dash'], p),
		"The Abyss 05 - Stone Tablet Fragment"                 : lambda s : s.can_reach(el['Abyss05Top'], 'Region', p) and s.has(el['swim'], p),
		"The Abyss 05 - The Deathless Pact"                    : lambda s : s.can_reach(el['Abyss05Top'], 'Region', p) and s.has(el['swim'], p),
		"The Abyss 05 To Verboten Domain 12"                   : lambda s : s.can_reach(el['Abyss05Top'], 'Region', p) and s.has(el['swim'], p),
		"The Abyss 05 - Ancient Soul x2"                       : lambda s : s.can_reach(el['Abyss05Top'], 'Region', p) and s.has(el['swim'], p),
		"The Abyss 05 To The Abyss 04"                         : lambda s : s.can_reach(el['Abyss05Top'], 'Region', p),
		"Ruined Castle 01 - Castle Town Maiden"                : lambda s : s.can_reach(el['Castle01Left'], 'Region', p) or s.can_reach(el['Castle01Right1'], 'Region', p) or s.can_reach(el['Castle01Top'], 'Region', p) or s.can_reach(el['Castle01Right2'], 'Region', p),
		"Ruined Castle 01 - Priestess' Doll"                   : lambda s : s.can_reach(el['Dog'], 'Location', p) and (macros['LEDGE'](s) or macros['HORIZONTAL'](s)),
		"Ruined Castle 01 - Decayed Crown"                     : lambda s : s.can_reach(el['Castle01Right1'], 'Region', p) or s.can_reach(el['Castle01Top'], 'Region', p),
		"Ruined Castle 01 - Stagnant Blight x100"              : lambda s : s.can_reach(el['Dog'], 'Location', p) and macros['CHARGE'](s),
		"Ruined Castle 01 - Furious Blight x100"               : lambda s : s.can_reach(el['Dog'], 'Location', p) and macros['CHARGE'](s),
		"Ruined Castle 01 To Cliffside Hamlet 11"              : lambda s : s.can_reach(el['Castle01Left'], 'Region', p) or s.can_reach(el['Dog'], 'Location', p),
		"Ruined Castle 01 To Ruined Castle 02 Lower"           : lambda s : s.can_reach(el['Castle01Right2'], 'Region', p) or s.can_reach(el['Dog'], 'Location', p) and (macros['HORIZONTAL'](s) or macros['LEDGE'](s) or s.has(el['dash'], p)),
		"Ruined Castle 01 To Ruined Castle 02 Upper"           : lambda s : s.can_reach(el['Castle01Right1'], 'Region', p) or s.can_reach(el['Castle01Top'], 'Region', p),
		"Ruined Castle 01 To Ruined Castle 10"                 : lambda s : s.can_reach(el['Castle01Right1'], 'Region', p) and s.has(el['claw'], p),
		"Ruined Castle 02 - Amulet Fragment"                   : lambda s : s.can_reach(el['Castle02Top'], 'Region', p) and (macros['LEDGE'](s) or macros['HORIZONTAL'](s) or s.has(el['dash'], p) or s.has(el['claw'], p) or s.has(el['hook'], p)),
		"Ruined Castle 02 To Ruined Castle 05"                 : lambda s : s.can_reach(el['Castle02Top'], 'Region', p) or s.can_reach(el['Castle02Left2'], 'Region', p) and (s.has(el['hook'], p) or macros['LEDGE'](s) or s.has(el['claw'], p)),
		"Ruined Castle 02 - Stagnant Blight x30"               : lambda s : s.can_reach(el['Castle02Top'], 'Region', p) and s.has(el['hook'], p),
		"Ruined Castle 02 To Ruined Castle 01 Lower"           : lambda s : s.can_reach(el['Castle02Left2'], 'Region', p) or s.can_reach(el['Castle02Left1'], 'Region', p) or s.can_reach(el['Castle02Top'], 'Region', p) or s.can_reach(el['Castle02Bottom'], 'Region', p),
		"Ruined Castle 02 To Ruined Castle 04"                 : lambda s : s.can_reach(el['Castle02Bottom'], 'Region', p) or s.can_reach(el['Castle02Left2'], 'Region', p),
		"Ruined Castle 02 To Ruined Castle 01 Upper"           : lambda s : s.can_reach(el['Castle02Left1'], 'Region', p) or s.can_reach(el['Castle02Left2'], 'Region', p) and (s.has(el['claw'], p) and (s.has(el['djump'], p) or s.has(el['champion'], p))),
		"Ruined Castle 03 - Amulet Fragment"                   : lambda s : (s.can_reach(el['Castle03Top1'], 'Region', p) or s.can_reach(el['Castle03Top2'], 'Region', p)) and (s.has(el['hook'], p) or s.has(el['claw'], p) or macros['HORIZONTAL'](s) or s.has(el['dash'], p) or macros['LEDGE'](s)),
		"Ruined Castle 03 - Stagnant Blight x30"               : lambda s : (s.can_reach(el['Castle03Top1'], 'Region', p) or s.can_reach(el['Castle03Top2'], 'Region', p)) and (s.has(el['hook'], p) or s.has(el['claw'], p) or macros['LEDGE'](s) and macros['HORIZONTAL'](s)),
		"Ruined Castle 03 To Ruined Castle 05"                 : lambda s : s.can_reach(el['Castle03Bottom'], 'Region', p) or s.can_reach(el['Castle03Top1'], 'Region', p) or s.can_reach(el['Castle03Top2'], 'Region', p),
		"Ruined Castle 03 To Ruined Castle 11 Left"            : lambda s : s.can_reach(el['Castle03Top1'], 'Region', p) and s.has(el['claw'], p) or s.can_reach(el['Castle03Top2'], 'Region', p) and s.has(el['claw'], p) and macros['HORIZONTAL'](s) and macros['2LEDGE'](s) or s.can_reach(el['Castle03Bottom'], 'Region', p) and s.has(el['claw'], p) and (macros['2HORIZONTAL'](s) and macros['2LEDGE'](s) or macros['HORIZONTAL'](s) and macros['3LEDGE'](s)),
		"Ruined Castle 03 To Ruined Castle 11 Right"           : lambda s : s.can_reach(el['Castle03Top2'], 'Region', p) and s.has(el['claw'], p) or s.can_reach(el['Castle03Top1'], 'Region', p) and s.has(el['claw'], p) and macros['HORIZONTAL'](s) and macros['2LEDGE'](s) or s.can_reach(el['Castle03Bottom'], 'Region', p) and s.has(el['claw'], p) and (macros['2HORIZONTAL'](s) and macros['2LEDGE'](s) or macros['HORIZONTAL'](s) and macros['3LEDGE'](s)),
		"Ruined Castle 04 - Report from a Verboten Mage"       : lambda s : s.can_reach(el['Castle04Top'], 'Region', p),
		"Ruined Castle 04 To Ruined Castle 02"                 : lambda s : s.can_reach(el['Castle04Top'], 'Region', p) or s.can_reach(el['RuinedCastleCellar'], 'Location', p) and (macros['LEDGE'](s) or s.has(el['claw'], p) or macros['HORIZONTAL'](s)),
		"Ruined Castle 05 To Ruined Castle 02"                 : lambda s : s.can_reach(el['Castle05Bottom'], 'Region', p) or s.can_reach(el['Castle05Right'], 'Region', p) or s.can_reach(el['Castle05Left'], 'Region', p) or s.can_reach(el['Castle05Top'], 'Region', p),
		"Ruined Castle 05 To Ruined Castle 06"                 : lambda s : s.can_reach(el['Castle05Right'], 'Region', p) or s.can_reach(el['Castle05Bottom'], 'Region', p),
		"Ruined Castle 05 To Ruined Castle 08"                 : lambda s : s.can_reach(el['Castle05Left'], 'Region', p) or s.can_reach(el['Castle05Bottom'], 'Region', p),
		"Ruined Castle 05 To Ruined Castle 03"                 : lambda s : s.can_reach(el['Castle05Top'], 'Region', p),
		"Ruined Castle 06 - Royal Aegis Crest"                 : lambda s : s.can_reach(el['Castle06Top'], 'Region', p),
		"Ruined Castle 06 To Ruined Castle 12"                 : lambda s : s.can_reach(el['Castle06Top'], 'Region', p) or s.can_reach(el['Castle06Right'], 'Region', p),
		"Ruined Castle 06 To Ruined Castle 07"                 : lambda s : s.can_reach(el['Castle06Right'], 'Region', p) or s.can_reach(el['Castle06Top'], 'Region', p) or s.can_reach(el['Castle06Left'], 'Region', p),
		"Ruined Castle 06 - Stagnant Blight x30"               : lambda s : s.can_reach(el['Castle06Right'], 'Region', p) and s.has(el['claw'], p),
		"Ruined Castle 06 To Ruined Castle 05"                 : lambda s : s.can_reach(el['Castle06Left'], 'Region', p) or s.can_reach(el['Castle06Top'], 'Region', p),
		"Ruined Castle 07 - Proof of Founding"                 : lambda s : s.can_reach(el['Castle07Right'], 'Region', p) or s.can_reach(el['Castle07Left'], 'Region', p),
		"Ruined Castle 07 To Twin Spires 01"                   : lambda s : s.can_reach(el['Castle07Right'], 'Region', p) or s.can_reach(el['GuestChamber'], 'Location', p) and (s.has(el['hook'], p) or macros['3LEDGE'](s)),
		"Ruined Castle 07 To Ruined Castle 06"                 : lambda s : s.can_reach(el['Castle07Left'], 'Region', p) or s.can_reach(el['GuestChamber'], 'Location', p),
		"Ruined Castle 08 - Chain of Sorcery"                  : lambda s : s.can_reach(el['Castle08Top'], 'Region', p) and s.has(el['claw'], p) and (macros['LEDGE'](s) or macros['HORIZONTAL'](s) or s.has(el['dash'], p)),
		"Ruined Castle 08 - Blightwreathed Blade"              : lambda s : s.can_reach(el['Castle08Top'], 'Region', p),
		"Ruined Castle 08 - Stagnant Blight x10"               : lambda s : s.can_reach(el['Castle08Top'], 'Region', p),
		"Ruined Castle 08 - Upper Stagnant Blight x10"         : lambda s : s.can_reach(el['Castle08Top'], 'Region', p),
		"Ruined Castle 08 - Lower Stagnant Blight x10"         : lambda s : s.can_reach(el['Castle08Right'], 'Region', p),
		"Ruined Castle 08 To Ruined Castle 05"                 : lambda s : s.can_reach(el['Castle08Right'], 'Region', p) or s.can_reach(el['Castle08Top'], 'Region', p),
		"Ruined Castle 08 To Ruined Castle 09"                 : lambda s : s.can_reach(el['Castle08Top'], 'Region', p) or s.can_reach(el['Castle08Right'], 'Region', p) and (s.has(el['claw'], p) or macros['LEDGE'](s) or macros['HORIZONTAL'](s)),
		"Ruined Castle 09 - Furious Blight x30"                : lambda s : s.can_reach(el['Castle09Left'], 'Region', p) and (macros['2HORIZONTAL'](s) or s.has(el['claw'], p) and (macros['2LEDGE'](s) or macros['LEDGE'](s) and macros['HORIZONTAL'](s)) or macros['FULLSILVA'](s) or macros['LEDGE'](s) and s.has(el['sinner'], p) or s.has(el['djump'], p) and s.has(el['dash'], p) and (s.has(el['silva'], p) or s.has(el['dodge'], p))),
		"Ruined Castle 09 To Ruined Castle 11"                 : lambda s : s.can_reach(el['Castle09Right'], 'Region', p) or s.can_reach(el['Castle09Bottom'], 'Region', p),
		"Ruined Castle 09 To Ruined Castle 08"                 : lambda s : s.can_reach(el['Castle09Bottom'], 'Region', p) or s.can_reach(el['Castle09Right'], 'Region', p) or s.can_reach(el['Castle09Left'], 'Region', p),
		"Ruined Castle 09 To Ruined Castle 10"                 : lambda s : s.can_reach(el['Castle09Left'], 'Region', p) or s.can_reach(el['Castle09Bottom'], 'Region', p),
		"Ruined Castle 10 - Julius' Book"                      : lambda s : s.can_reach(el['Castle10Right'], 'Region', p) or s.can_reach(el['Castle10Bottom'], 'Region', p),
		"Ruined Castle 10 - Stagnant Blight x30"               : lambda s : s.can_reach(el['MaelstromRemparts'], 'Location', p),
		"Ruined Castle 10 To Ruined Castle 09"                 : lambda s : s.can_reach(el['MaelstromRemparts'], 'Location', p),
		"Ruined Castle 10 To Ruined Castle 01"                 : lambda s : s.can_reach(el['MaelstromRemparts'], 'Location', p),
		"Ruined Castle 11 To Ruined Castle 12"                 : lambda s : s.can_reach(el['Castle11Right'], 'Region', p) or s.can_reach(el['Castle11Bottom2'], 'Region', p),
		"Ruined Castle 11 To Ruined Castle 09"                 : lambda s : s.can_reach(el['Castle11Left'], 'Region', p) or s.can_reach(el['Castle11Bottom1'], 'Region', p),
		"Ruined Castle 11 To Ruined Castle 13"                 : lambda s : s.can_reach(el['Castle11Top'], 'Region', p) or s.can_reach(el['Castle11Left'], 'Region', p) and s.can_reach(el['Castle11Right'], 'Region', p) and macros['LEDGE'](s),
		"Ruined Castle 11 To Ruined Castle 03 Left"            : lambda s : s.can_reach(el['Castle11Bottom1'], 'Region', p) or s.can_reach(el['Castle11Left'], 'Region', p),
		"Ruined Castle 11 To Ruined Castle 03 Right"           : lambda s : s.can_reach(el['Castle11Bottom2'], 'Region', p) or s.can_reach(el['Castle11Right'], 'Region', p),
		"Ruined Castle 12 - Chain of Sorcery"                  : lambda s : s.can_reach(el['Castle12Bottom'], 'Region', p) and (s.has(el['hook'], p) or (macros['3LEDGE'](s) and s.has(el['claw'], p) and s.has(el['dodge'], p))),
		"Ruined Castle 12 - King of the First Age's Diary 1"   : lambda s : s.can_reach(el['Castle12Bottom'], 'Region', p),
		"Ruined Castle 12 - King of the First Age's Diary 2"   : lambda s : s.can_reach(el['Castle12Bottom'], 'Region', p),
		"Ruined Castle 12 To Ruined Castle 06"                 : lambda s : s.can_reach(el['Castle12Bottom'], 'Region', p) or s.can_reach(el['Castle12Left'], 'Region', p) and (s.has(el['hook'], p) and (s.has(el['claw'], p) or macros['LEDGE'](s) or macros['HORIZONTAL'](s)) or s.has(el['slam'], p)),
		"Ruined Castle 12 - Stagnant Blight x30"               : lambda s : s.can_reach(el['Castle12Bottom'], 'Region', p) and (s.has(el['hook'], p) or s.has(el['claw'], p) or macros['HORIZONTAL'](s)),
		"Ruined Castle 12 To Ruined Castle 11"                 : lambda s : s.can_reach(el['Castle12Left'], 'Region', p) or s.can_reach(el['Castle12Bottom'], 'Region', p),
		"Ruined Castle 12 To Ruined Castle 21"                 : lambda s : s.can_reach(el['Castle12Right'], 'Region', p) or s.can_reach(el['Castle12Bottom'], 'Region', p) and s.has(el['unlock'], p),
		"Ruined Castle 13 - Amulet Gem"                        : lambda s : s.can_reach(el['Castle13Bottom'], 'Region', p) and (s.has(el['silva'], p) and s.has(el['djump'], p) and s.has(el['claw'], p) or (macros['FULLSILVA'](s) or macros['3LEDGE'](s)) and s.has(el['hook'], p) or macros['2LEDGE'](s) and s.has(el['hook'], p) and s.has(el['claw'], p) or macros['LEDGE'](s) and macros['HORIZONTAL'](s) and s.has(el['claw'], p) and s.has(el['hook'], p)),
		"Ruined Castle 13 To Ruined Castle 17"                 : lambda s : s.can_reach(el['Castle13Left'], 'Region', p) or s.can_reach(el['Castle13Bottom'], 'Region', p),
		"Ruined Castle 13 To Ruined Castle 11"                 : lambda s : s.can_reach(el['Castle13Bottom'], 'Region', p) or s.can_reach(el['Castle13Left'], 'Region', p) or s.can_reach(el['Castle13Right'], 'Region', p),
		"Ruined Castle 13 To Ruined Castle 14"                 : lambda s : s.can_reach(el['Castle13Right'], 'Region', p) or s.can_reach(el['Castle13Bottom'], 'Region', p),
		"Ruined Castle 14 - Amulet Fragment"                   : lambda s : s.can_reach(el['Castle14Left'], 'Region', p) and s.has(el['hook'], p),
		"Ruined Castle 14 - Stagnant Blight x100"              : lambda s : s.can_reach(el['Castle14Left'], 'Region', p) and macros['CHARGE'](s) and (s.has(el['claw'], p) or macros['LEDGE'](s) and macros['HORIZONTAL'](s)),
		"Ruined Castle 14 - Furious Blight x800"               : lambda s : s.can_reach(el['Castle14Left'], 'Region', p) and (s.has(el['claw'], p) and (macros['3LEDGE'](s) or macros['FULLSILVA'](s) or s.has(el['sinner'], p) and macros['2LEDGE'](s) or s.has(el['silva'], p) and macros['2HORIZONTAL'](s) or s.has(el['dodge'], p) and s.has(el['dash'], p) and macros['2LEDGE'](s))),
		"Ruined Castle 14 To Ruined Castle 13"                 : lambda s : s.can_reach(el['Castle14Left'], 'Region', p) or s.can_reach(el['Castle14Top'], 'Region', p),
		"Ruined Castle 14 To Ruined Castle 15"                 : lambda s : s.can_reach(el['Castle14Top'], 'Region', p) or s.can_reach(el['Castle14Left'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['hook'], p)),
		"Ruined Castle 15 - Priestess' Wish"                   : lambda s : s.can_reach(el['TowerAlcove'], 'Location', p),
		"Ruined Castle 15 - Priestess' Castle Memo"            : lambda s : s.can_reach(el['Castle15Bottom'], 'Region', p) or s.can_reach(el['Castle15Left'], 'Region', p),
		"Ruined Castle 15 To Ruined Castle 16"                 : lambda s : s.can_reach(el['TowerAlcove'], 'Location', p) and s.has(el['claw'], p) and (s.has(el['hook'], p) or macros['FULLSILVA'](s) and s.has(el['sinner'], p) or macros['3LEDGE'](s)),
		"Ruined Castle 15 To Ruined Castle 14"                 : lambda s : s.can_reach(el['TowerAlcove'], 'Location', p),
		"Ruined Castle 16 - One-Eyed Royal Aegis"              : lambda s : s.can_reach(el['Castle16Right'], 'Region', p),
		"Ruined Castle 16 - 2nd Stagnant Blight x10"           : lambda s : s.can_reach(el['Aegis'], 'Location', p),
		"Ruined Castle 16 - 5th Stagnant Blight x10"           : lambda s : s.can_reach(el['Aegis'], 'Location', p),
		"Ruined Castle 16 - 9th Stagnant Blight x10"           : lambda s : s.can_reach(el['Aegis'], 'Location', p),
		"Ruined Castle 16 - 1st Stagnant Blight x10"           : lambda s : s.can_reach(el['Aegis'], 'Location', p),
		"Ruined Castle 16 - 8th Stagnant Blight x10"           : lambda s : s.can_reach(el['Aegis'], 'Location', p),
		"Ruined Castle 16 - 3rd Stagnant Blight x10"           : lambda s : s.can_reach(el['Aegis'], 'Location', p),
		"Ruined Castle 16 - 7th Stagnant Blight x10"           : lambda s : s.can_reach(el['Aegis'], 'Location', p),
		"Ruined Castle 16 - 6th Stagnant Blight x10"           : lambda s : s.can_reach(el['Aegis'], 'Location', p),
		"Ruined Castle 16 - 4th Stagnant Blight x10"           : lambda s : s.can_reach(el['Aegis'], 'Location', p),
		"Ruined Castle 16 - 10th Stagnant Blight x10"          : lambda s : s.can_reach(el['Aegis'], 'Location', p) and s.has(el['claw'], p),
		"Ruined Castle 16 To Ruined Castle 18"                 : lambda s : s.can_reach(el['Aegis'], 'Location', p),
		"Ruined Castle 16 To Ruined Castle 15"                 : lambda s : s.can_reach(el['Aegis'], 'Location', p) and (macros['2LEDGE'](s) or s.has(el['claw'], p)),
		"Ruined Castle 17 - Stagnant Blight x30"               : lambda s : s.can_reach(el['Castle17Right'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p) or macros['HORIZONTAL'](s)),
		"Ruined Castle 17 To Ruined Castle 13"                 : lambda s : s.can_reach(el['Castle17Right'], 'Region', p),
		"Ruined Castle 17 To Ruined Castle 18"                 : lambda s : s.can_reach(el['Castle17Top'], 'Region', p) or s.can_reach(el['Castle17Right'], 'Region', p) and macros['LEDGE'](s),
		"Ruined Castle 18 - Amulet Fragment"                   : lambda s : s.can_reach(el['Castle18Right'], 'Region', p) and macros['CHARGE'](s),
		"Ruined Castle 18 - King's Note 2"                     : lambda s : s.can_reach(el['Castle18Bottom'], 'Region', p) and (s.has(el['claw'], p) or s.has(el['hook'], p) and macros['LEDGE'](s)) and macros['CHARGE'](s),
		"Ruined Castle 18 - Eldred's Ring"                     : lambda s : s.can_reach(el['Castle18Bottom'], 'Region', p) and (s.has(el['claw'], p) or s.has(el['hook'], p) and macros['LEDGE'](s)) and macros['CHARGE'](s),
		"Ruined Castle 18 - Furious Blight x100"               : lambda s : s.can_reach(el['Castle18Bottom'], 'Region', p) and s.has(el['hook'], p) and macros['LEDGE'](s) and macros['CHARGE'](s),
		"Ruined Castle 18 To Ruined Castle 19"                 : lambda s : s.can_reach(el['Castle18Right'], 'Region', p) or s.can_reach(el['Castle18Bottom'], 'Region', p) and (s.has(el['claw'], p) or s.has(el['hook'], p) and macros['LEDGE'](s)),
		"Ruined Castle 18 To Ruined Castle 17"                 : lambda s : s.can_reach(el['Castle18Bottom'], 'Region', p) or s.can_reach(el['Castle18Right'], 'Region', p) and (s.has(el['claw'], p) or s.has(el['hook'], p) and macros['LEDGE'](s)) or s.can_reach(el['Castle18Top'], 'Region', p),
		"Ruined Castle 19 - King's Note 1"                     : lambda s : s.can_reach(el['Castle19Right'], 'Region', p) or s.can_reach(el['Castle19Left'], 'Region', p),
		"Ruined Castle 19 To Ruined Castle 20"                 : lambda s : s.can_reach(el['KingsChamber'], 'Location', p),
		"Ruined Castle 19 To Ruined Castle 18"                 : lambda s : s.can_reach(el['KingsChamber'], 'Location', p),
		"Ruined Castle 20 - Knight Captain Julius"             : lambda s : s.can_reach(el['Castle20Left'], 'Region', p),
		"Ruined Castle 20 To Ruined Castle 19"                 : lambda s : s.can_reach(el['Castle20Left'], 'Region', p),
		"Ruined Castle 21 - King of the First Age's Diary 3"   : lambda s : s.can_reach(el['Castle21Left'], 'Region', p),
		"Ruined Castle 21 - Stone Tablet Fragment"             : lambda s : s.can_reach(el['Castle21Left'], 'Region', p),
		"Ruined Castle 21 To Ruined Castle 12"                 : lambda s : s.can_reach(el['Castle21Left'], 'Region', p),
		"Ruined Castle 21 - Stagnant Blight x100"              : lambda s : s.can_reach(el['Castle21Left'], 'Region', p),
		"CathedralCloister"                                    : lambda s : s.can_reach(el['Church05Right'], 'Region', p) or s.can_reach(el['Church05Bottom'], 'Region', p) or s.can_reach(el['Church05Top'], 'Region', p),
		"Catacombs 01 - Fretia's Ring"                         : lambda s : s.can_reach(el['Cave01Bottom'], 'Region', p) or s.can_reach(el['Cave01Left'], 'Region', p),
		"Catacombs 01 - Furious Blight x800"                   : lambda s : s.can_reach(el['Cave01Bottom'], 'Region', p) and (s.has(el['claw'], p) or s.has(el['djump'], p) or s.has(el['champion'], p) or s.has(el['silva'], p) and s.has(el['dodge'], p)) or s.can_reach(el['Cave01Left'], 'Region', p) and macros['3LEDGE'](s) and macros['2HORIZONTAL'](s),
		"Catacombs 01 To Catacombs 02"                         : lambda s : s.can_reach(el['BottomOfTheWell'], 'Location', p),
		"Catacombs 01 To Cliffside Hamlet 12"                  : lambda s : s.can_reach(el['BottomOfTheWell'], 'Location', p),
		"Catacombs 02 - Stagnant Blight x30"                   : lambda s : s.can_reach(el['Cave02Right'], 'Region', p) and (s.has(el['hook'], p) or s.has(el['claw'], p) and (macros['HORIZONTAL'](s) or macros['LEDGE'](s) and s.has(el['dash'], p))),
		"Catacombs 02 - Stagnant Blight x10"                   : lambda s : s.can_reach(el['Cave02Right'], 'Region', p),
		"Catacombs 02 To Catacombs 05"                         : lambda s : s.can_reach(el['Cave02Right'], 'Region', p) or s.can_reach(el['Cave02Bottom'], 'Region', p) or s.can_reach(el['Cave02Top'], 'Region', p),
		"Catacombs 02 To Catacombs 07"                         : lambda s : s.can_reach(el['Cave02Bottom'], 'Region', p) or s.can_reach(el['Cave02Right'], 'Region', p) and s.has(el['slam'], p),
		"Catacombs 02 To Catacombs 01"                         : lambda s : s.can_reach(el['Cave02Right'], 'Region', p) and s.has(el['claw'], p) and (macros['FULLSILVA'](s) and s.has(el['dash'], p) or macros['3LEDGE'](s) or macros['2LEDGE'](s) and macros['2HORIZONTAL'](s) or s.has(el['silva'], p) and macros['2HORIZONTAL'](s) or s.has(el['silva'], p) and s.has(el['sinner'], p) and s.has(el['djump'], p) or s.has(el['dash'], p) and s.has(el['djump'], p) and s.has(el['champion'], p) and s.has(el['sinner'], p)),
		"Catacombs 03 - Defense of the Twin Spires 2"          : lambda s : s.can_reach(el['Cave03Left'], 'Region', p) or s.can_reach(el['Cave03Right'], 'Region', p) or s.can_reach(el['Cave03Top'], 'Region', p),
		"Catacombs 03 - Fretia's Memoirs 4"                    : lambda s : s.can_reach(el['Cave03Right'], 'Region', p),
		"Catacombs 03 To Catacombs 07"                         : lambda s : s.can_reach(el['Cave03Left'], 'Region', p),
		"Catacombs 03 To Catacombs 08"                         : lambda s : s.can_reach(el['Cave03Right'], 'Region', p),
		"Catacombs 03 To Catacombs 06"                         : lambda s : s.can_reach(el['Charnel'], 'Location', p),
		"Catacombs 04 - Amulet Fragment"                       : lambda s : s.can_reach(el['Cave04Bottom'], 'Region', p),
		"Catacombs 04 To Catacombs 16"                         : lambda s : s.can_reach(el['Cave04Right'], 'Region', p) or s.can_reach(el['Cave04Bottom'], 'Region', p),
		"Catacombs 04 To Catacombs 05"                         : lambda s : s.can_reach(el['Cave04Bottom'], 'Region', p) or s.can_reach(el['Cave04Right'], 'Region', p),
		"Catacombs 04 To Catacombs 12"                         : lambda s : s.can_reach(el['Cave04Left'], 'Region', p) or s.can_reach(el['Cave04Bottom'], 'Region', p) and s.has(el['unlock'], p),
		"Catacombs 05 - Furious Blight x10"                    : lambda s : s.can_reach(el['Cave05Bottom'], 'Region', p) and (s.has(el['hook'], p) or macros['LEDGE'](s) or s.has(el['dash'], p) or macros['HORIZONTAL'](s)),
		"Catacombs 05 To Catacombs 02"                         : lambda s : s.can_reach(el['Cave05Left'], 'Region', p) or s.can_reach(el['Cave05Bottom'], 'Region', p),
		"Catacombs 05 To Catacombs 04"                         : lambda s : s.can_reach(el['Cave05Top'], 'Region', p) or s.can_reach(el['Cave05Bottom'], 'Region', p),
		"Catacombs 05 To Catacombs 06"                         : lambda s : s.can_reach(el['Cave05Bottom'], 'Region', p) or s.can_reach(el['Cave05Left'], 'Region', p) or s.can_reach(el['Cave05Right'], 'Region', p) or s.can_reach(el['Cave05Top'], 'Region', p),
		"Catacombs 05 To Catacombs 10"                         : lambda s : s.can_reach(el['Cave05Right'], 'Region', p) or s.can_reach(el['Cave05Bottom'], 'Region', p) and (s.has(el['claw'], p) or macros['2LEDGE'](s) or macros['2HORIZONTAL'](s) or macros['LEDGE'](s) and macros['HORIZONTAL'](s)),
		"Catacombs 06 - Fretia's Memoirs 2"                    : lambda s : s.can_reach(el['Cave06Top'], 'Region', p),
		"Catacombs 06 - Fretia's Memoirs 1"                    : lambda s : s.can_reach(el['Cave06Top'], 'Region', p),
		"Catacombs 06 - Kilteus' Ring"                         : lambda s : s.can_reach(el['Cave06Top'], 'Region', p),
		"Catacombs 06 To Catacombs 05"                         : lambda s : s.can_reach(el['Cave06Top'], 'Region', p) or s.can_reach(el['Cave06Bottom'], 'Region', p),
		"Catacombs 06 To Catacombs 03"                         : lambda s : s.can_reach(el['Cave06Bottom'], 'Region', p) or s.can_reach(el['Cave06Top'], 'Region', p),
		"Catacombs 07 - Elder Crypt Keeper"                    : lambda s : s.can_reach(el['Cave07Right'], 'Region', p) or s.can_reach(el['Cave07Top'], 'Region', p),
		"Catacombs 07 - Stagnant Blight x10"                   : lambda s : s.can_reach(el['Spider'], 'Location', p) and s.has(el['swim'], p),
		"Catacombs 07 To Catacombs 02"                         : lambda s : s.can_reach(el['Spider'], 'Location', p) and s.has(el['claw'], p) and s.has(el['hook'], p) and (macros['FULLSILVA'](s) or macros['3LEDGE'](s)),
		"Catacombs 07 To Catacombs 03"                         : lambda s : s.can_reach(el['Spider'], 'Location', p),
		"Catacombs 08 - Amulet Fragment"                       : lambda s : s.can_reach(el['Cave08Left'], 'Region', p) and s.has(el['slam'], p),
		"Catacombs 08 To Catacombs 09"                         : lambda s : s.can_reach(el['Cave08Top'], 'Region', p) or s.can_reach(el['Cave08Left'], 'Region', p) and (s.has(el['hook'], p) or macros['LEDGE'](s) or s.has(el['dash'], p) or macros['HORIZONTAL'](s)),
		"Catacombs 08 To Catacombs 03"                         : lambda s : s.can_reach(el['Cave08Left'], 'Region', p) or s.can_reach(el['Cave08Top'], 'Region', p) or s.can_reach(el['Cave08Right'], 'Region', p),
		"Catacombs 08 To Catacombs 17"                         : lambda s : s.can_reach(el['Cave08Bottom'], 'Region', p) or s.can_reach(el['Cave08Left'], 'Region', p) and s.has(el['swim'], p) and s.has(el['slam'], p),
		"Catacombs 08 To Catacombs 11"                         : lambda s : s.can_reach(el['Cave08Right'], 'Region', p) or s.can_reach(el['Cave08Left'], 'Region', p),
		"Catacombs 09 - Amulet Fragment"                       : lambda s : s.can_reach(el['Cave09Top'], 'Region', p) and (s.has(el['claw'], p) or macros['LEDGE'](s)),
		"Catacombs 09 - Chain of Sorcery"                      : lambda s : s.can_reach(el['Cave09Top'], 'Region', p),
		"Catacombs 09 To Catacombs 10"                         : lambda s : s.can_reach(el['Cave09Top'], 'Region', p) or s.can_reach(el['Cave09Bottom'], 'Region', p) and (s.has(el['claw'], p) or macros['LEDGE'](s)),
		"Catacombs 09 To Catacombs 08"                         : lambda s : s.can_reach(el['Cave09Bottom'], 'Region', p) or s.can_reach(el['Cave09Top'], 'Region', p) or s.can_reach(el['Cave09Right'], 'Region', p),
		"Catacombs 09 To Catacombs 21"                         : lambda s : s.can_reach(el['Cave09Right'], 'Region', p) or s.can_reach(el['Cave09Top'], 'Region', p) and (s.has(el['sinner'], p) or s.has(el['dodge'], p) and (macros['LEDGE'](s) or s.has(el['dash'], p) and s.has(el['claw'], p)) or s.has(el['djump'], p) and (s.has(el['champion'], p) or s.has(el['silva'], p) or s.has(el['dash'], p)) or s.has(el['claw'], p) and s.has(el['champion'], p)),
		"Catacombs 10 - Amulet Fragment"                       : lambda s : s.can_reach(el['Cave10Left'], 'Region', p),
		"Catacombs 10 - Stagnant Blight x10"                   : lambda s : s.can_reach(el['Cave10Bottom'], 'Region', p),
		"Catacombs 10 To Catacombs 23"                         : lambda s : s.can_reach(el['Cave10Right'], 'Region', p) or s.can_reach(el['Cave10Bottom'], 'Region', p),
		"Catacombs 10 To Catacombs 05"                         : lambda s : s.can_reach(el['Cave10Left'], 'Region', p) or s.can_reach(el['Cave10Bottom'], 'Region', p) and (s.has(el['hook'], p) or macros['2LEDGE'](s) or macros['2HORIZONTAL'](s) or macros['LEDGE'](s) and macros['HORIZONTAL'](s) or s.has(el['sinner'], p) and s.has(el['dash'], p)),
		"Catacombs 10 To Catacombs 09"                         : lambda s : s.can_reach(el['Cave10Bottom'], 'Region', p) or s.can_reach(el['Cave10Right'], 'Region', p) or s.can_reach(el['Cave10Top'], 'Region', p) or s.can_reach(el['Cave10Left'], 'Region', p),
		"Catacombs 10 To Catacombs 16"                         : lambda s : s.can_reach(el['Cave10Top'], 'Region', p) or s.can_reach(el['Cave10Bottom'], 'Region', p),
		"Catacombs 11 - Silva's Note 2"                        : lambda s : s.can_reach(el['Cave11Left'], 'Region', p) or s.can_reach(el['Cave11Top'], 'Region', p) or s.can_reach(el['Cave11Right1'], 'Region', p) or s.can_reach(el['Cave11Right2'], 'Region', p),
		"Catacombs 11 - Stagnant Blight x10"                   : lambda s : s.can_reach(el['Cave11Left'], 'Region', p) and (macros['LEDGE'](s) or macros['HORIZONTAL'](s) or s.has(el['hook'], p) or s.has(el['dash'], p)),
		"Catacombs 11 - Furious Blight x10"                    : lambda s : s.can_reach(el['Cave11Tip'], 'Location', p) and s.has(el['swim'], p),
		"Catacombs 11 To Catacombs 08"                         : lambda s : s.can_reach(el['Cave11Left'], 'Region', p) or s.can_reach(el['Cave11Tip'], 'Location', p) and (s.has(el['hook'], p) or macros['HORIZONTAL'](s) or macros['LEDGE'](s) or s.has(el['claw'], p)),
		"Catacombs 11 To Catacombs 13"                         : lambda s : s.can_reach(el['Cave11Tip'], 'Location', p) and s.has(el['claw'], p),
		"Catacombs 11 To Catacombs 18"                         : lambda s : s.can_reach(el['Cave11Right1'], 'Region', p) or s.can_reach(el['Cave11Tip'], 'Location', p) and (s.has(el['hook'], p) or s.has(el['claw'], p) and (macros['LEDGE'](s) or s.has(el['sinner'], p) or s.has(el['dodge'], p) and s.has(el['dash'], p)) or macros['2LEDGE'](s) or macros['2HORIZONTAL'](s) or macros['LEDGE'](s) and macros['HORIZONTAL'](s)),
		"Catacombs 12 - Stone Tablet Fragment"                 : lambda s : s.can_reach(el['Cave12Right'], 'Region', p) and (s.has(el['champion'], p) or s.has(el['silva'], p)),
		"Catacombs 12 To Catacombs 04"                         : lambda s : s.can_reach(el['Cave12Right'], 'Region', p),
		"Catacombs 13 - Silva's Note 1"                        : lambda s : s.can_reach(el['Cave13Top'], 'Region', p) or s.can_reach(el['Cave13Left'], 'Region', p) or s.can_reach(el['Cave13Right'], 'Region', p) or s.can_reach(el['Cave13Bottom'], 'Region', p),
		"Catacombs 13 - Furious Blight x30"                    : lambda s : s.can_reach(el['Ossuary'], 'Location', p) and s.has(el['hook'], p) or s.can_reach(el['Cave13Bottom'], 'Region', p) and s.has(el['claw'], p),
		"Catacombs 13 - Furious Blight x10"                    : lambda s : s.can_reach(el['Cave13Left'], 'Region', p) and (s.has(el['dash'], p) or macros['LEDGE'](s) or macros['HORIZONTAL'](s)),
		"Catacombs 13 To Catacombs 11"                         : lambda s : s.can_reach(el['Ossuary'], 'Location', p),
		"Catacombs 13 To Catacombs 14"                         : lambda s : s.can_reach(el['Ossuary'], 'Location', p),
		"Catacombs 13 To Catacombs 23"                         : lambda s : s.can_reach(el['Cave13Left'], 'Region', p) or s.can_reach(el['Ossuary'], 'Location', p) and (s.has(el['claw'], p) or macros['2LEDGE'](s) or s.has(el['sinner'], p) or macros['LEDGE'](s) and macros['HORIZONTAL'](s)),
		"Catacombs 13 To Catacombs 20"                         : lambda s : s.can_reach(el['Ossuary'], 'Location', p),
		"Catacombs 14 - Stagnant Blight x10"                   : lambda s : s.can_reach(el['Cave14Right'], 'Region', p),
		"Catacombs 14 To Catacombs 13"                         : lambda s : s.can_reach(el['Cave14Bottom'], 'Region', p) or s.can_reach(el['Cave14Right'], 'Region', p) or s.can_reach(el['Cave14Left'], 'Region', p),
		"Catacombs 14 To Catacombs 15"                         : lambda s : s.can_reach(el['Cave14Left'], 'Region', p) or s.can_reach(el['Cave14Bottom'], 'Region', p) and macros['LEDGE'](s),
		"Catacombs 14 To Catacombs 22"                         : lambda s : s.can_reach(el['Cave14Right'], 'Region', p) or s.can_reach(el['Cave14Bottom'], 'Region', p) and (s.has(el['hook'], p) or s.has(el['claw'], p) or macros['2LEDGE'](s) or macros['LEDGE'](s) and macros['HORIZONTAL'](s)),
		"Catacombs 15 - Defense of the Twin Spires 1"          : lambda s : s.can_reach(el['Cave15Right'], 'Region', p),
		"Catacombs 15 - Right Stagnant Blight x10"             : lambda s : s.can_reach(el['Cave15Right'], 'Region', p) and s.has(el['slam'], p),
		"Catacombs 15 - Left Stagnant Blight x10"              : lambda s : s.can_reach(el['Cave15Right'], 'Region', p) or s.can_reach(el['Cave15Left'], 'Region', p),
		"Catacombs 15 To Catacombs 14"                         : lambda s : s.can_reach(el['Cave15Right'], 'Region', p) or s.can_reach(el['Cave15Left'], 'Region', p) and s.has(el['swim'], p) and (macros['LEDGE'](s) or s.has(el['claw'], p)),
		"Catacombs 15 To Catacombs 16"                         : lambda s : s.can_reach(el['Cave15Left'], 'Region', p) or s.can_reach(el['Cave15Right'], 'Region', p),
		"Catacombs 16 - The Next White Priestess"              : lambda s : s.can_reach(el['Cave16Right'], 'Region', p) or s.can_reach(el['Cave16Bottom'], 'Region', p) or s.can_reach(el['Cave16Left'], 'Region', p),
		"Catacombs 16 - Stagnant Blight x30"                   : lambda s : s.can_reach(el['GreatHall'], 'Location', p) and (s.has(el['hook'], p) or s.has(el['claw'], p) and (macros['2LEDGE'](s) or macros['LEDGE'](s) and macros['HORIZONTAL'](s))),
		"Catacombs 16 To Catacombs 15"                         : lambda s : s.can_reach(el['Cave16Right'], 'Region', p) or s.can_reach(el['GreatHall'], 'Location', p),
		"Catacombs 16 To Catacombs 10"                         : lambda s : s.can_reach(el['Cave16Bottom'], 'Region', p),
		"Catacombs 16 To Catacombs 04"                         : lambda s : s.can_reach(el['Cave16Left'], 'Region', p) or s.can_reach(el['GreatHall'], 'Location', p),
		"Catacombs 17 - Ancient Soul x2"                       : lambda s : s.can_reach(el['Cave17Top'], 'Region', p) and s.has(el['swim'], p),
		"Catacombs 17 To Catacombs 08"                         : lambda s : s.can_reach(el['Cave17Top'], 'Region', p),
		"Catacombs 18 - Holy Spring Water"                     : lambda s : s.can_reach(el['Cave18Left1'], 'Region', p),
		"Catacombs 18 To Catacombs 11 Upper"                   : lambda s : s.can_reach(el['Cave18Left1'], 'Region', p),
		"Catacombs 18 To Catacombs 11 Lower"                   : lambda s : s.can_reach(el['Cave18Left1'], 'Region', p) and s.has(el['swim'], p),
		"Catacombs 19 - Fallen Archer"                         : lambda s : s.can_reach(el['Cave19Top'], 'Region', p) or s.can_reach(el['Cave19Left'], 'Region', p),
		"Catacombs 19 - Priestess' Wish"                       : lambda s : s.can_reach(el['Archer'], 'Location', p),
		"Catacombs 19 - Chain of Sorcery"                      : lambda s : s.can_reach(el['Archer'], 'Location', p) and (s.has(el['hook'], p) or macros['LEDGE'](s) or macros['HORIZONTAL'](s)),
		"Catacombs 19 To Catacombs 20"                         : lambda s : s.can_reach(el['Cave19Top'], 'Region', p) or s.can_reach(el['Archer'], 'Location', p),
		"Catacombs 19 To Catacombs 21"                         : lambda s : s.can_reach(el['Cave19Left'], 'Region', p) or s.can_reach(el['Cave19Top'], 'Region', p) and (macros['HORIZONTAL'](s) and macros['LEDGE'](s) or s.has(el['claw'], p) or macros['2LEDGE'](s)),
		"Catacombs 20 - Amulet Fragment"                       : lambda s : s.can_reach(el['Cave20Top'], 'Region', p),
		"Catacombs 20 - The Heirloom of Land's End"            : lambda s : s.can_reach(el['Cave20Top'], 'Region', p),
		"Catacombs 20 - Stagnant Blight x10"                   : lambda s : s.can_reach(el['Cave20Top'], 'Region', p),
		"Catacombs 20 To Catacombs 22"                         : lambda s : s.can_reach(el['Cave20Top'], 'Region', p) or s.can_reach(el['Cave20Bottom'], 'Region', p) and (s.has(el['hook'], p) or s.has(el['claw'], p) or macros['LEDGE'](s)),
		"Catacombs 20 To Catacombs 19"                         : lambda s : s.can_reach(el['Cave20Bottom'], 'Region', p) or s.can_reach(el['Cave20Left'], 'Region', p) or s.can_reach(el['Cave20Top'], 'Region', p),
		"Catacombs 20 To Catacombs 13"                         : lambda s : s.can_reach(el['Cave20Left'], 'Region', p) or s.can_reach(el['Cave20Bottom'], 'Region', p) or s.can_reach(el['Cave20Top'], 'Region', p),
		"Catacombs 21 - White Priestess Statue"                : lambda s : s.can_reach(el['Cave21Right'], 'Region', p) or s.can_reach(el['Cave21Left'], 'Region', p),
		"Catacombs 21 To Catacombs 09"                         : lambda s : s.can_reach(el['Cave21Left'], 'Region', p) or s.can_reach(el['Cave21Right'], 'Region', p),
		"Catacombs 21 To Catacombs 19"                         : lambda s : s.can_reach(el['Cave21Right'], 'Region', p) or s.can_reach(el['Cave21Left'], 'Region', p),
		"Catacombs 22 - Fretia's Memoirs 3"                    : lambda s : s.can_reach(el['Cave22Right'], 'Region', p),
		"Catacombs 22 To Twin Spires 02"                       : lambda s : s.can_reach(el['Cave22Right'], 'Region', p) or s.can_reach(el['Cave22Bottom'], 'Region', p),
		"Catacombs 22 To Catacombs 14"                         : lambda s : s.can_reach(el['Cave22Left'], 'Region', p) or s.can_reach(el['Cave22Bottom'], 'Region', p) and (macros['2LEDGE'](s) or s.has(el['hook'], p) or s.has(el['claw'], p) or macros['LEDGE'](s) and macros['HORIZONTAL'](s)),
		"Catacombs 22 To Catacombs 20"                         : lambda s : s.can_reach(el['Cave22Bottom'], 'Region', p) or s.can_reach(el['Cave22Right'], 'Region', p) or s.can_reach(el['Cave22Left'], 'Region', p),
		"Catacombs 23 - Guardian Silva"                        : lambda s : s.can_reach(el['Cave23Right'], 'Region', p) or s.can_reach(el['Cave23Left'], 'Region', p),
		"Catacombs 23 - Unfinished Note"                       : lambda s : s.can_reach(el['Silva'], 'Location', p),
		"Catacombs 23 To Catacombs 13"                         : lambda s : s.can_reach(el['Silva'], 'Location', p),
		"Catacombs 23 To Catacombs 10"                         : lambda s : s.can_reach(el['Silva'], 'Location', p),
		"White Parish 01 To White Parish 02"                   : lambda s : s.can_reach(el['Church01Bottom'], 'Region', p) or s.can_reach(el['Church01Left'], 'Region', p) or s.can_reach(el['Church01Top'], 'Region', p),
		"White Parish 01 To White Parish 12"                   : lambda s : s.can_reach(el['Church01Left'], 'Region', p) or s.can_reach(el['Church01Bottom'], 'Region', p) or s.can_reach(el['Church01Top'], 'Region', p),
		"White Parish 02 - Amulet Fragment"                    : lambda s : s.can_reach(el['Church02Right'], 'Region', p),
		"White Parish 02 - Eleine's Letter"                    : lambda s : s.can_reach(el['Church02Right'], 'Region', p),
		"White Parish 02 To White Parish 01"                   : lambda s : s.can_reach(el['Church02Top'], 'Region', p) or s.can_reach(el['Church02Right'], 'Region', p) and (s.has(el['djump'], p) or s.has(el['champion'], p) or s.has(el['silva'], p) and s.has(el['dodge'], p)),
		"White Parish 02 To White Parish 10"                   : lambda s : s.can_reach(el['Church02Right'], 'Region', p) or s.can_reach(el['Church02Top'], 'Region', p),
		"White Parish 03 - Guardian Siegrid"                   : lambda s : s.can_reach(el['Church03Left'], 'Region', p),
		"White Parish 03 To White Parish 05"                   : lambda s : s.can_reach(el['Church03Left'], 'Region', p) or s.can_reach(el['Church03Right'], 'Region', p),
		"White Parish 03 To White Parish 04"                   : lambda s : s.can_reach(el['Church03Right'], 'Region', p) or s.can_reach(el['Church03Left'], 'Region', p),
		"White Parish 04 - Groa's Letter"                      : lambda s : s.can_reach(el['Church04Right'], 'Region', p) or s.can_reach(el['Church04Left'], 'Region', p),
		"White Parish 04 To White Parish 03"                   : lambda s : s.can_reach(el['Church04Left'], 'Region', p) or s.can_reach(el['SaintsPassage'], 'Location', p),
		"White Parish 04 To White Parish 06"                   : lambda s : s.can_reach(el['Church04Right'], 'Region', p) or s.can_reach(el['SaintsPassage'], 'Location', p),
		"White Parish 05 - Soiled Prayer Beads"                : lambda s : s.can_reach(el['Church05Top'], 'Region', p) or s.can_reach(el['CathedralCloister'], 'Location', p) and macros['LEDGE'](s),
		"White Parish 05 To White Parish 11"                   : lambda s : s.can_reach(el['CathedralCloister'], 'Location', p),
		"White Parish 05 To White Parish 03"                   : lambda s : s.can_reach(el['CathedralCloister'], 'Location', p),
		"White Parish 05 To White Parish 09"                   : lambda s : s.can_reach(el['CathedralCloister'], 'Location', p) and s.has(el['claw'], p),
		"White Parish 06 To White Parish 04"                   : lambda s : s.can_reach(el['Church06Left'], 'Region', p) or s.can_reach(el['Church06Right'], 'Region', p),
		"White Parish 06 To White Parish 07"                   : lambda s : s.can_reach(el['Church06Right'], 'Region', p) or s.can_reach(el['Church06Left'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p)),
		"White Parish 07 - Cliffside Hamlet Youth"             : lambda s : s.can_reach(el['Church07Right'], 'Region', p),
		"White Parish 07 - Chain of Sorcery"                   : lambda s : s.can_reach(el['Youth'], 'Location', p) and s.has(el['slam'], p),
		"White Parish 07 To White Parish 06"                   : lambda s : s.can_reach(el['Church07Left'], 'Region', p) or s.can_reach(el['Youth'], 'Location', p) and (macros['LEDGE'](s) or s.has(el['claw'], p)),
		"White Parish 07 To White Parish 08"                   : lambda s : s.can_reach(el['Church07Right'], 'Region', p) or s.can_reach(el['Church07Left'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p)) or s.can_reach(el['Youth'], 'Location', p),
		"White Parish 08 - Amulet Fragment"                    : lambda s : s.can_reach(el['Crossroads'], 'Location', p) and s.has(el['swim'], p),
		"White Parish 08 - The Parish Way 2"                   : lambda s : s.can_reach(el['Church08Top'], 'Region', p) or s.can_reach(el['Church08Bottom'], 'Region', p) or s.can_reach(el['Church08Left'], 'Region', p),
		"White Parish 08 To Cliffside Hamlet 01"               : lambda s : s.can_reach(el['Crossroads'], 'Location', p),
		"White Parish 08 To Witch's Thicket 01"                : lambda s : s.can_reach(el['Crossroads'], 'Location', p),
		"White Parish 08 To White Parish 07"                   : lambda s : s.can_reach(el['Crossroads'], 'Location', p),
		"White Parish 09 - Chief Guardian"                     : lambda s : s.can_reach(el['Church09Bottom'], 'Region', p) or s.can_reach(el['Church09Top'], 'Region', p),
		"White Parish 09 - Vibrant Plume"                      : lambda s : s.can_reach(el['Church09Bottom'], 'Region', p) and macros['CHARGE'](s) and (macros['LEDGE'](s) and s.has(el['claw'], p) or macros['3LEDGE'](s)),
		"White Parish 09 - Furious Blight x30"                 : lambda s : s.can_reach(el['Chief'], 'Location', p),
		"White Parish 09 To White Parish 05"                   : lambda s : s.can_reach(el['Church09Bottom'], 'Region', p) or s.can_reach(el['Church09Top'], 'Region', p),
		"White Parish 09 To White Parish 01"                   : lambda s : s.can_reach(el['Chief'], 'Location', p),
		"White Parish 09 To White Parish 14"                   : lambda s : s.can_reach(el['Church09Bottom'], 'Region', p) and s.has(el['hook'], p),
		"White Parish 10 - On the Blighted 1"                  : lambda s : s.can_reach(el['Church10Left'], 'Region', p) or s.can_reach(el['Church10Right'], 'Region', p),
		"White Parish 10 - On the Blighted 2"                  : lambda s : s.can_reach(el['Cellar'], 'Location', p),
		"White Parish 10 To White Parish 02"                   : lambda s : s.can_reach(el['Church10Left'], 'Region', p) or s.can_reach(el['Cellar'], 'Location', p),
		"White Parish 10 To White Parish 11"                   : lambda s : s.can_reach(el['Church10Right'], 'Region', p) or s.can_reach(el['Cellar'], 'Location', p),
		"White Parish 11 - Amulet Fragment"                    : lambda s : s.can_reach(el['Church11Left'], 'Region', p),
		"White Parish 11 - The Parish Way 1"                   : lambda s : s.can_reach(el['Church11Top'], 'Region', p),
		"White Parish 11 To White Parish 05"                   : lambda s : s.can_reach(el['Church11Top'], 'Region', p) or s.can_reach(el['Church11Left'], 'Region', p),
		"White Parish 11 To White Parish 10"                   : lambda s : s.can_reach(el['Church11Left'], 'Region', p),
		"White Parish 12 - Statue Inscription"                 : lambda s : s.can_reach(el['Church12Right'], 'Region', p),
		"White Parish 12 To White Parish 01"                   : lambda s : s.can_reach(el['Church12Right'], 'Region', p) or s.can_reach(el['Start'], 'Location', p),
		"White Parish 12 To White Parish 13"                   : lambda s : s.can_reach(el['Church12Bottom'], 'Region', p) or s.can_reach(el['Start'], 'Location', p) and (s.has(el['unlock'], p) and (s.has(el['djump'], p) or s.has(el['champion'], p) or s.has(el['silva'], p) and s.has(el['dodge'], p) or s.has(el['claw'], p))),
		"White Parish 13 - Restoring the Aegis Curio"          : lambda s : s.can_reach(el['Church13Top'], 'Region', p),
		"White Parish 13 To White Parish 12"                   : lambda s : s.can_reach(el['Church13Top'], 'Region', p),
		"White Parish 14 - Priestess' Wish"                    : lambda s : s.can_reach(el['Church14Bottom'], 'Region', p),
		"White Parish 14 - Lily's Note"                        : lambda s : s.can_reach(el['Church14Bottom'], 'Region', p),
		"White Parish 14 To White Parish 09"                   : lambda s : s.can_reach(el['Church14Bottom'], 'Region', p),
		"Witch's Thicket 01 To White Parish 08"                : lambda s : s.can_reach(el['Forest01Top'], 'Region', p) or s.can_reach(el['Forest01Right'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p)),
		"Witch's Thicket 01 To Witch's Thicket 02"             : lambda s : s.can_reach(el['Forest01Right'], 'Region', p) or s.can_reach(el['Forest01Top'], 'Region', p),
		"Witch's Thicket 02 - Stagnant Blight x10"             : lambda s : s.can_reach(el['Forest02Left'], 'Region', p) or s.can_reach(el['Forest02Right2'], 'Region', p) and s.has(el['hook'], p),
		"Witch's Thicket 02 To Witch's Thicket 01"             : lambda s : s.can_reach(el['Forest02Left'], 'Region', p) or s.can_reach(el['Forest02Right1'], 'Region', p),
		"Witch's Thicket 02 To Witch's Thicket 04"             : lambda s : s.can_reach(el['Forest02Right1'], 'Region', p) or s.can_reach(el['Forest02Left'], 'Region', p) or s.can_reach(el['Forest02Right2'], 'Region', p) and (s.has(el['claw'], p) or macros['LEDGE'](s)),
		"Witch's Thicket 02 To Witch's Thicket 03"             : lambda s : s.can_reach(el['Forest02Right2'], 'Region', p) or s.can_reach(el['Forest02Left'], 'Region', p),
		"Witch's Thicket 03 - Amulet Fragment"                 : lambda s : s.can_reach(el['Forest03Left'], 'Region', p) and s.has(el['swim'], p),
		"Witch's Thicket 03 - Chain of Sorcery"                : lambda s : s.can_reach(el['Forest03Left'], 'Region', p) and s.has(el['swim'], p),
		"Witch's Thicket 03 To Witch's Thicket 05"             : lambda s : s.can_reach(el['Forest03Right'], 'Region', p) or s.can_reach(el['Forest03Left'], 'Region', p) and (s.has(el['claw'], p) or macros['LEDGE'](s) or macros['HORIZONTAL'](s)),
		"Witch's Thicket 03 To Witch's Thicket 02"             : lambda s : s.can_reach(el['Forest03Left'], 'Region', p) or s.can_reach(el['Forest03Right'], 'Region', p),
		"Witch's Thicket 04 - Amulet Fragment"                 : lambda s : s.can_reach(el['Forest04Right'], 'Region', p),
		"Witch's Thicket 04 - Rusted Blue Ornament"            : lambda s : s.can_reach(el['Forest04Left'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p) and macros['HORIZONTAL'](s)),
		"Witch's Thicket 04 - Stagnant Blight x10"             : lambda s : s.can_reach(el['Forest04Left'], 'Region', p) and (s.has(el['slam'], p) and macros['LEDGE'](s)),
		"Witch's Thicket 04 To Witch's Thicket 05"             : lambda s : s.can_reach(el['Forest04Right'], 'Region', p) or s.can_reach(el['Forest04Left'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p) or macros['HORIZONTAL'](s) and s.has(el['swim'], p)),
		"Witch's Thicket 04 To Witch's Thicket 02"             : lambda s : s.can_reach(el['Forest04Left'], 'Region', p) or s.can_reach(el['Forest04Right'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p)),
		"Witch's Thicket 05 - Coven Handbook"                  : lambda s : s.can_reach(el['Forest05Right'], 'Region', p) or s.can_reach(el['Forest05Left'], 'Region', p) or s.can_reach(el['Forest05Top'], 'Region', p),
		"Witch's Thicket 05 To Witch's Thicket 07"             : lambda s : s.can_reach(el['Forest05Right'], 'Region', p) or s.can_reach(el['DryadLake'], 'Location', p),
		"Witch's Thicket 05 To Witch's Thicket 03"             : lambda s : s.can_reach(el['Forest05Left'], 'Region', p) or s.can_reach(el['DryadLake'], 'Location', p),
		"Witch's Thicket 05 To Witch's Thicket 04"             : lambda s : s.can_reach(el['Forest05Top'], 'Region', p) or s.can_reach(el['DryadLake'], 'Location', p) and macros['LEDGE'](s),
		"Witch's Thicket 06 - Fungal Sorcerer"                 : lambda s : s.can_reach(el['Forest06Bottom'], 'Region', p) and macros['LEDGE'](s),
		"Witch's Thicket 06 - Lover's Letter"                  : lambda s : s.can_reach(el['Forest06Bottom'], 'Region', p) and macros['LEDGE'](s),
		"Witch's Thicket 06 - Furious Blight x10"              : lambda s : s.can_reach(el['Forest06Bottom'], 'Region', p) and (s.has(el['hook'], p) or macros['LEDGE'](s) and s.has(el['slam'], p) or macros['2LEDGE'](s) or macros['LEDGE'](s) and macros['HORIZONTAL'](s)),
		"Witch's Thicket 06 To Witch's Thicket 07"             : lambda s : s.can_reach(el['Forest06Bottom'], 'Region', p),
		"Witch's Thicket 07 - Amulet Fragment"                 : lambda s : (s.can_reach(el['Forest07Left'], 'Region', p) or s.can_reach(el['Forest07Bottom'], 'Region', p)) and (macros['LEDGE'](s) or s.has(el['hook'], p) or macros['HORIZONTAL'](s) or s.has(el['claw'], p)),
		"Witch's Thicket 07 - Stagnant Blight x30"             : lambda s : s.can_reach(el['Forest07Right'], 'Region', p) and (s.has(el['hook'], p) or s.has(el['claw'], p) and macros['LEDGE'](s)),
		"Witch's Thicket 07 - Stagnant Blight x10"             : lambda s : s.can_reach(el['Forest07Left'], 'Region', p) or s.can_reach(el['Forest07Right'], 'Region', p),
		"Witch's Thicket 07 To Stockade 01"                    : lambda s : s.can_reach(el['Forest07Right'], 'Region', p) or s.can_reach(el['Forest07Left'], 'Region', p) and (s.has(el['dodge'], p) and (macros['LEDGE'](s) or s.has(el['dash'], p)) or macros['2LEDGE'](s) or s.has(el['hook'], p) or s.has(el['sinner'], p) or (s.has(el['djump'], p) or s.has(el['champion'], p)) and s.has(el['dash'], p) or s.has(el['silva'], p) and s.has(el['dash'], p) and s.has(el['claw'], p)),
		"Witch's Thicket 07 To Witch's Thicket 08"             : lambda s : s.can_reach(el['Forest07Bottom'], 'Region', p) or s.can_reach(el['Forest07Left'], 'Region', p),
		"Witch's Thicket 07 To Witch's Thicket 05"             : lambda s : s.can_reach(el['Forest07Left'], 'Region', p) or s.can_reach(el['Forest07Bottom'], 'Region', p) and macros['LEDGE'](s) or s.can_reach(el['Forest07Right'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['hook'], p) or macros['HORIZONTAL'](s) or s.has(el['dash'], p)),
		"Witch's Thicket 07 To Witch's Thicket 06"             : lambda s : s.can_reach(el['Forest07Top'], 'Region', p) or s.can_reach(el['Forest07Left'], 'Region', p) and macros['LEDGE'](s),
		"Witch's Thicket 08 - Manisa's Ring"                   : lambda s : s.can_reach(el['Forest08Top'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['hook'], p) or s.has(el['claw'], p) and macros['HORIZONTAL'](s)),
		"Witch's Thicket 08 - Cracked Familiar Stone"          : lambda s : s.can_reach(el['ManisasRing'], 'Location', p) and (macros['2LEDGE'](s) or macros['LEDGE'](s) and macros['HORIZONTAL'](s) or s.has(el['claw'], p) and s.has(el['sinner'], p) or s.has(el['hook'], p)),
		"Witch's Thicket 08 - Furious Blight x10"              : lambda s : s.can_reach(el['Forest08Top'], 'Region', p) and (macros['LEDGE'](s) or macros['HORIZONTAL'](s) or s.has(el['dash'], p)),
		"Witch's Thicket 08 To Witch's Thicket 07"             : lambda s : s.can_reach(el['Forest08Top'], 'Region', p) or s.can_reach(el['Forest08Right'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p)),
		"Witch's Thicket 08 To Witch's Thicket 10"             : lambda s : s.can_reach(el['Forest08Right'], 'Region', p) or s.can_reach(el['Forest08Top'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['hook'], p) or s.has(el['claw'], p)),
		"Witch's Thicket 09 - Priestess' Wish"                 : lambda s : s.can_reach(el['Forest10Left'], 'Region', p) and s.has(el['swim'], p) and (macros['LEDGE'](s) or s.has(el['claw'], p)),
		"Witch's Thicket 09 - Tarnished Picture"               : lambda s : s.can_reach(el['Forest10Left'], 'Region', p) and s.has(el['swim'], p) and (macros['LEDGE'](s) or s.has(el['claw'], p)),
		"Witch's Thicket 09 To Witch's Thicket 10"             : lambda s : s.can_reach(el['Forest09Top'], 'Region', p) or s.can_reach(el['Forest09Left'], 'Region', p) and s.has(el['swim'], p),
		"Witch's Thicket 09 - Furious Blight x10"              : lambda s : (s.can_reach(el['Forest09Top'], 'Region', p) or s.can_reach(el['Forest09Left'], 'Region', p)) and s.has(el['swim'], p),
		"Witch's Thicket 09 To Verboten Domain 02"             : lambda s : s.can_reach(el['Forest09Left'], 'Region', p) or s.can_reach(el['Forest09Top'], 'Region', p) and s.has(el['swim'], p) and (macros['LEDGE'](s) or s.has(el['claw'], p)),
		"Witch's Thicket 10 To Witch's Thicket 11"             : lambda s : s.can_reach(el['Forest10Bottom2'], 'Region', p) or s.can_reach(el['WitchsHermitage'], 'Location', p),
		"Witch's Thicket 10 To Witch's Thicket 09"             : lambda s : s.can_reach(el['Forest10Bottom1'], 'Region', p) or s.can_reach(el['WitchsHermitage'], 'Location', p),
		"Witch's Thicket 10 - Sorcerer's Notes"                : lambda s : s.can_reach(el['Forest10Bottom2'], 'Region', p) or s.can_reach(el['Forest10Bottom1'], 'Region', p) or s.can_reach(el['Forest10Left'], 'Region', p) or s.can_reach(el['Forest10Right'], 'Region', p),
		"Witch's Thicket 10 To Witch's Thicket 08"             : lambda s : s.can_reach(el['Forest10Left'], 'Region', p) or s.can_reach(el['WitchsHermitage'], 'Location', p),
		"Witch's Thicket 10 To Witch's Thicket 12"             : lambda s : s.can_reach(el['Forest10Right'], 'Region', p) or s.can_reach(el['WitchsHermitage'], 'Location', p),
		"Witch's Thicket 11 - Floral Sorceress"                : lambda s : s.can_reach(el['Forest11Top'], 'Region', p),
		"Witch's Thicket 11 - Amulet Fragment"                 : lambda s : s.can_reach(el['Forest11Top'], 'Region', p),
		"Witch's Thicket 11 - Chain of Sorcery"                : lambda s : s.can_reach(el['Forest11Top'], 'Region', p),
		"Witch's Thicket 11 - Ruined Witch's Book"             : lambda s : s.can_reach(el['Forest11Right'], 'Region', p) and (macros['LEDGE'](s) or macros['HORIZONTAL'](s) or s.has(el['dash'], p)),
		"Witch's Thicket 11 To Witch's Thicket 10"             : lambda s : s.can_reach(el['Forest11Top'], 'Region', p) or s.can_reach(el['Forest11Right'], 'Region', p),
		"Witch's Thicket 11 - Stagnant Blight x30"             : lambda s : s.can_reach(el['Forest11Right'], 'Region', p) and (macros['LEDGE'](s) and s.has(el['claw'], p) or s.has(el['hook'], p) or macros['2HORIZONTAL'](s) and (s.has(el['dash'], p) or s.has(el['djump'], p) or s.has(el['silva'], p))),
		"Witch's Thicket 11 - Stagnant Blight x10"             : lambda s : s.can_reach(el['Forest11Right'], 'Region', p) and s.has(el['swim'], p),
		"Witch's Thicket 11 To Witch's Thicket 14"             : lambda s : s.can_reach(el['Forest11Right'], 'Region', p) or s.can_reach(el['Forest11Top'], 'Region', p) and s.has(el['swim'], p),
		"Witch's Thicket 12 - Amulet Fragment"                 : lambda s : s.can_reach(el['Forest12Left'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p) or s.has(el['hook'], p)),
		"Witch's Thicket 12 - Stagnant Blight x10"             : lambda s : s.can_reach(el['Forest12Bottom'], 'Region', p) or s.can_reach(el['Forest12Right'], 'Region', p),
		"Witch's Thicket 12 To Witch's Thicket 10"             : lambda s : s.can_reach(el['Forest12Left'], 'Region', p) or s.can_reach(el['Forest12Bottom'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['hook'], p)),
		"Witch's Thicket 12 To Witch's Thicket 13"             : lambda s : s.can_reach(el['Forest12Bottom'], 'Region', p) or s.can_reach(el['Forest12Right'], 'Region', p) or s.can_reach(el['Forest12Left'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['hook'], p)),
		"Witch's Thicket 12 To Witch's Thicket 17"             : lambda s : s.can_reach(el['Forest12Right'], 'Region', p) or s.can_reach(el['Forest12Left'], 'Region', p) and (s.has(el['claw'], p) and (s.has(el['djump'], p) or s.has(el['champion'], p)) or s.has(el['claw'], p) and macros['LEDGE'](s) and (macros['HORIZONTAL'](s) or s.has(el['dash'], p)) or s.has(el['silva'], p) and s.has(el['djump'], p) or macros['LEDGE'](s) and s.has(el['sinner'], p) or macros['2LEDGE'](s) and macros['HORIZONTAL'](s)) or s.can_reach(el['Forest12Bottom'], 'Region', p) and s.has(el['hook'], p),
		"Witch's Thicket 13 - Stagnant Blight x10"             : lambda s : s.can_reach(el['Forest13Top'], 'Region', p),
		"Witch's Thicket 13 To Witch's Thicket 12"             : lambda s : s.can_reach(el['Forest13Top'], 'Region', p) or s.can_reach(el['Forest13Bottom'], 'Region', p),
		"Witch's Thicket 13 To Witch's Thicket 14"             : lambda s : s.can_reach(el['Forest13Bottom'], 'Region', p) or s.can_reach(el['Forest13Top'], 'Region', p) and macros['LEDGE'](s),
		"Witch's Thicket 13 To Witch's Thicket 16"             : lambda s : s.can_reach(el['Forest13Right'], 'Region', p) or s.can_reach(el['Forest13Top'], 'Region', p) and s.has(el['claw'], p) and s.has(el['unlock'], p) and (macros['LEDGE'](s) and macros['HORIZONTAL'](s) or macros['2LEDGE'](s)),
		"Witch's Thicket 14 - The Parish Way 3"                : lambda s : s.can_reach(el['Forest14Bottom'], 'Region', p) or s.can_reach(el['Forest14Top'], 'Region', p) or s.can_reach(el['Forest14Left'], 'Region', p),
		"Witch's Thicket 14 To Witch's Thicket 15"             : lambda s : s.can_reach(el['CovenHalls'], 'Location', p),
		"Witch's Thicket 14 To Witch's Thicket 13"             : lambda s : s.can_reach(el['CovenHalls'], 'Location', p),
		"Witch's Thicket 14 To Witch's Thicket 11"             : lambda s : s.can_reach(el['Forest14Left'], 'Region', p) or s.can_reach(el['CovenHalls'], 'Location', p) and s.has(el['swim'], p),
		"Witch's Thicket 15 - Dark Witch Eleine"               : lambda s : s.can_reach(el['Forest15Top'], 'Region', p),
		"Witch's Thicket 15 To Witch's Thicket 14"             : lambda s : s.can_reach(el['Forest15Top'], 'Region', p),
		"Witch's Thicket 16 - Eleine's Diary 3"                : lambda s : s.can_reach(el['Forest16Left'], 'Region', p),
		"Witch's Thicket 16 - Stone Tablet Fragment"           : lambda s : s.can_reach(el['Forest16Left'], 'Region', p),
		"Witch's Thicket 16 - Stagnant Blight x800"            : lambda s : s.can_reach(el['Forest16Left'], 'Region', p),
		"Witch's Thicket 16 To Witch's Thicket 13"             : lambda s : s.can_reach(el['Forest16Left'], 'Region', p),
		"Witch's Thicket 17 - Amulet Gem"                      : lambda s : s.can_reach(el['Forest17Left'], 'Region', p) and (s.has(el['claw'], p) or macros['LEDGE'](s)),
		"Witch's Thicket 17 - Eleine's Diary 2"                : lambda s : s.can_reach(el['Forest17Left'], 'Region', p) and (s.has(el['claw'], p) or macros['LEDGE'](s) and s.has(el['hook'], p) or s.has(el['silva'], p) and s.has(el['djump'], p)),
		"Witch's Thicket 17 - Spellbound Anklet"               : lambda s : s.can_reach(el['Forest17Left'], 'Region', p) and (s.has(el['claw'], p) or macros['LEDGE'](s)),
		"Witch's Thicket 17 To Witch's Thicket 12"             : lambda s : s.can_reach(el['Forest17Left'], 'Region', p),
		"Witch's Thicket 17 - Eleine's Diary 1"                : lambda s : s.can_reach(el['Forest17Left'], 'Region', p),
		"Twin Spires 01 - Fallen Sentinel"                     : lambda s : s.can_reach(el['Fort01Left1'], 'Region', p) or s.can_reach(el['Fort01Right'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['hook'], p)),
		"Twin Spires 01 - Furious Blight x30"                  : lambda s : s.can_reach(el['Fort01Left1'], 'Region', p),
		"Twin Spires 01 To Twin Spires 03"                     : lambda s : s.can_reach(el['Fort01Right'], 'Region', p) or s.can_reach(el['Fort01Left1'], 'Region', p) or s.can_reach(el['Fort01Left2'], 'Region', p),
		"Twin Spires 01 To Cliffside Hamlet 15"                : lambda s : s.can_reach(el['Fort01Left2'], 'Region', p) or s.can_reach(el['Fort01Right'], 'Region', p) and s.has(el['swim'], p),
		"Twin Spires 01 To Ruined Castle 07"                   : lambda s : s.can_reach(el['Fort01Left1'], 'Region', p) or s.can_reach(el['Sentinel'], 'Location', p) and s.has(el['hook'], p),
		"Twin Spires 02 - Stagnant Blight x10"                 : lambda s : s.can_reach(el['Fort02Left'], 'Region', p),
		"Twin Spires 02 - Furious Blight x10"                  : lambda s : s.can_reach(el['Fort02Right'], 'Region', p),
		"Twin Spires 02 To Twin Spires 03"                     : lambda s : s.can_reach(el['Fort02Right'], 'Region', p) or s.can_reach(el['Fort02Left'], 'Region', p) and (macros['LEDGE'](s) and macros['HORIZONTAL'](s) or macros['2HORIZONTAL'](s) or s.has(el['djump'], p) and (s.has(el['silva'], p) or s.has(el['champion'], p))),
		"Twin Spires 02 To Catacombs 22"                       : lambda s : s.can_reach(el['Fort02Left'], 'Region', p) or s.can_reach(el['Fort02Right'], 'Region', p) and (macros['LEDGE'](s) and macros['HORIZONTAL'](s) or macros['2HORIZONTAL'](s) or macros['2LEDGE'](s) or s.has(el['sinner'], p) or s.has(el['dash'], p) and macros['LEDGE'](s) or s.has(el['dash'], p) and s.has(el['dodge'], p)),
		"Twin Spires 03 - Bloodied Note 1"                     : lambda s : s.can_reach(el['Fort03Right'], 'Region', p) or s.can_reach(el['Fort03Left1'], 'Region', p) or s.can_reach(el['Fort03Left2'], 'Region', p) or s.can_reach(el['Fort03Top'], 'Region', p),
		"Twin Spires 03 To Twin Spires 04"                     : lambda s : s.can_reach(el['BastionGates'], 'Location', p),
		"Twin Spires 03 To Twin Spires 01"                     : lambda s : s.can_reach(el['BastionGates'], 'Location', p) and (s.has(el['hook'], p) or macros['LEDGE'](s)),
		"Twin Spires 03 To Twin Spires 02"                     : lambda s : s.can_reach(el['BastionGates'], 'Location', p),
		"Twin Spires 03 To Twin Spires 05"                     : lambda s : s.can_reach(el['BastionGates'], 'Location', p) and s.has(el['claw'], p),
		"Twin Spires 04 - Stagnant Blight x100"                : lambda s : s.can_reach(el['Fort04Left'], 'Region', p) and (macros['CHARGE'](s) and (macros['LEDGE'](s) or s.has(el['claw'], p) or macros['HORIZONTAL'](s))),
		"Twin Spires 04 To Twin Spires 05"                     : lambda s : s.can_reach(el['Fort04Top'], 'Region', p) or s.can_reach(el['Fort04Left'], 'Region', p) and macros['LEDGE'](s),
		"Twin Spires 04 To Twin Spires 03"                     : lambda s : s.can_reach(el['Fort04Left'], 'Region', p) or s.can_reach(el['Fort04Top'], 'Region', p),
		"Twin Spires 05 - Amulet Fragment"                     : lambda s : s.can_reach(el['Fort05Right'], 'Region', p) and macros['LEDGE'](s),
		"Twin Spires 05 - Chain of Sorcery"                    : lambda s : s.can_reach(el['Fort05Bottom2'], 'Region', p) and (macros['LEDGE'](s) and (s.has(el['hook'], p) or s.has(el['claw'], p))),
		"Twin Spires 05 - Stagnant Blight x10"                 : lambda s : s.can_reach(el['Fort05Bottom2'], 'Region', p) and macros['LEDGE'](s) and s.has(el['slam'], p) or s.can_reach(el['Fort05Bottom1'], 'Region', p),
		"Twin Spires 05 To Twin Spires 04"                     : lambda s : s.can_reach(el['Fort05Bottom2'], 'Region', p) or s.can_reach(el['Fort05Right'], 'Region', p),
		"Twin Spires 05 To Twin Spires 06"                     : lambda s : s.can_reach(el['Fort05Right'], 'Region', p) or s.can_reach(el['Fort05Bottom2'], 'Region', p) and macros['LEDGE'](s),
		"Twin Spires 05 To Twin Spires 03"                     : lambda s : s.can_reach(el['Fort05Bottom1'], 'Region', p) or s.can_reach(el['Fort05Bottom2'], 'Region', p) and macros['LEDGE'](s),
		"Twin Spires 05 To Twin Spires 15"                     : lambda s : s.can_reach(el['Fort05Bottom2'], 'Region', p) and macros['LEDGE'](s) and s.has(el['claw'], p),
		"Twin Spires 06 - Stagnant Blight x30"                 : lambda s : s.can_reach(el['Fort06Right'], 'Region', p) and (macros['LEDGE'](s) and s.has(el['claw'], p)),
		"Twin Spires 06 To Twin Spires 05"                     : lambda s : s.can_reach(el['Fort06Left'], 'Region', p) or s.can_reach(el['Fort06Bottom'], 'Region', p) or s.can_reach(el['Fort06Right'], 'Region', p) and (macros['LEDGE'](s) or macros['HORIZONTAL'](s) or s.has(el['dash'], p)),
		"Twin Spires 06 To Twin Spires 07"                     : lambda s : s.can_reach(el['Fort06Right'], 'Region', p) or s.can_reach(el['Fort06Left'], 'Region', p) and (macros['LEDGE'](s) or macros['HORIZONTAL'](s) or s.has(el['dash'], p)),
		"Twin Spires 06 To Twin Spires 10"                     : lambda s : s.can_reach(el['Fort06Bottom'], 'Region', p) or s.can_reach(el['Fort06Left'], 'Region', p) or s.can_reach(el['Fort06Right'], 'Region', p),
		"Twin Spires 07 - Stagnant Blight x10"                 : lambda s : s.can_reach(el['Fort07Bottom1'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p)),
		"Twin Spires 07 To Twin Spires 09 Left"                : lambda s : s.can_reach(el['Fort07Right'], 'Region', p) or s.can_reach(el['Fort07Bottom1'], 'Region', p) or s.can_reach(el['Fort07Top'], 'Region', p) or s.can_reach(el['Fort07Bottom2'], 'Region', p) and s.has(el['claw'], p),
		"Twin Spires 07 To Twin Spires 08"                     : lambda s : s.can_reach(el['Fort07Right'], 'Region', p) or s.can_reach(el['Fort07Top'], 'Region', p),
		"Twin Spires 07 To Twin Spires 06"                     : lambda s : s.can_reach(el['Fort07Left'], 'Region', p) or s.can_reach(el['Fort07Top'], 'Region', p) and macros['LEDGE'](s),
		"Twin Spires 07 To Twin Spires 11"                     : lambda s : s.can_reach(el['Fort07Top'], 'Region', p) or s.can_reach(el['Fort07Bottom1'], 'Region', p) or s.can_reach(el['Fort07Left'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p)) or s.can_reach(el['Fort07Right'], 'Region', p),
		"Twin Spires 07 To Twin Spires 09 Right"               : lambda s : s.can_reach(el['Fort07Bottom2'], 'Region', p) or s.can_reach(el['Fort07Bottom1'], 'Region', p) and s.has(el['claw'], p),
		"Twin Spires 08 - Hoenir's Diary 3"                    : lambda s : s.can_reach(el['Fort08Left'], 'Region', p),
		"Twin Spires 08 To Twin Spires 07"                     : lambda s : s.can_reach(el['Fort08Left'], 'Region', p) or s.can_reach(el['SecondSpireChamber'], 'Location', p),
		"Twin Spires 09 - Note on the Castle Wall"             : lambda s : s.can_reach(el['Fort09Left'], 'Region', p),
		"Twin Spires 09 - Snowdrop Bracelet"                   : lambda s : s.can_reach(el['Fort09Left'], 'Region', p) and macros['CHARGE'](s),
		"Twin Spires 09 - Stagnant Blight x10"                 : lambda s : s.can_reach(el['Fort09Top1'], 'Region', p),
		"Twin Spires 09 - Furious Blight x30"                  : lambda s : s.can_reach(el['Fort09Top2'], 'Region', p),
		"Twin Spires 09 To Hinterlands 03"                     : lambda s : s.can_reach(el['Fort09Right'], 'Region', p) or s.can_reach(el['Fort09Top1'], 'Region', p) and s.has(el['claw'], p),
		"Twin Spires 09 To Twin Spires 10"                     : lambda s : s.can_reach(el['Fort09Left'], 'Region', p) or s.can_reach(el['Fort09Right'], 'Region', p) or s.can_reach(el['Fort09Top1'], 'Region', p) or s.can_reach(el['Fort09Top2'], 'Region', p),
		"Twin Spires 09 To Twin Spires 07 Left"                : lambda s : s.can_reach(el['Fort09Top1'], 'Region', p) or s.can_reach(el['Fort09Left'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['hook'], p)),
		"Twin Spires 09 To Twin Spires 07 Right"               : lambda s : s.can_reach(el['Fort09Top2'], 'Region', p) or s.can_reach(el['Fort09Right'], 'Region', p) and macros['LEDGE'](s) and s.has(el['claw'], p),
		"Twin Spires 10 - Amulet Fragment"                     : lambda s : s.can_reach(el['Courtyard'], 'Location', p) and s.has(el['claw'], p) and macros['LEDGE'](s),
		"Twin Spires 10 - Bloodied Note 2"                     : lambda s : s.can_reach(el['Fort10Right'], 'Region', p) or s.can_reach(el['Fort10Top'], 'Region', p),
		"Twin Spires 10 To Twin Spires 09"                     : lambda s : s.can_reach(el['Courtyard'], 'Location', p),
		"Twin Spires 10 To Twin Spires 06"                     : lambda s : s.can_reach(el['Courtyard'], 'Location', p) and s.has(el['claw'], p) and macros['LEDGE'](s),
		"Twin Spires 11 - Ricorus' Ring"                       : lambda s : s.has(el['slam'], p) and s.has(el['swim'], p) and (s.can_reach(el['Fort11Stagnant'], 'Location', p) or s.can_reach(el['Fort11Bottom'], 'Region', p) and (macros['LEDGE'](s) and (s.has(el['sinner'], p) or s.has(el['dodge'], p) and s.has(el['claw'], p)) or macros['2LEDGE'](s))),
		"Twin Spires 11 - Stagnant Blight x30"                 : lambda s : s.can_reach(el['Fort11Top2'], 'Region', p) or s.can_reach(el['Fort11Bottom'], 'Region', p) and (macros['LEDGE'](s) and (s.has(el['sinner'], p) or s.has(el['dodge'], p) and s.has(el['claw'], p)) or macros['2LEDGE'](s)) and (s.has(el['hook'], p) or macros['2LEDGE'](s) and s.has(el['claw'], p) or macros['3LEDGE'](s)),
		"Twin Spires 11 To Twin Spires 07"                     : lambda s : s.can_reach(el['Fort11Bottom'], 'Region', p) or s.can_reach(el['Fort11Left'], 'Region', p) or s.can_reach(el['Fort11Top1'], 'Region', p) or s.can_reach(el['Fort11Top2'], 'Region', p),
		"Twin Spires 11 To Twin Spires 12"                     : lambda s : s.can_reach(el['Fort11Left'], 'Region', p) or s.can_reach(el['Fort11Bottom'], 'Region', p) and macros['LEDGE'](s) or s.can_reach(el['Fort11Top1'], 'Region', p) and (macros['HORIZONTAL'](s) or macros['LEDGE'](s) or s.has(el['dash'], p)),
		"Twin Spires 11 To Twin Spires 13 Left"                : lambda s : s.can_reach(el['Fort11Top1'], 'Region', p) or s.can_reach(el['Fort11Left'], 'Region', p) and (s.has(el['claw'], p) or macros['LEDGE'](s) or macros['HORIZONTAL'](s) or s.has(el['dash'], p)),
		"Twin Spires 11 To Twin Spires 13 Right"               : lambda s : s.can_reach(el['Fort11Top2'], 'Region', p) and s.has(el['claw'], p) or s.can_reach(el['Fort11Stagnant'], 'Location', p) and s.has(el['claw'], p),
		"Twin Spires 12 - Forsaken Fellwyrm"                   : lambda s : s.can_reach(el['Fort12HP'], 'Location', p) and macros['CHARGE'](s),
		"Twin Spires 12 - Amulet Fragment"                     : lambda s : s.can_reach(el['Fort12Top'], 'Region', p) or s.can_reach(el['Fort12Right'], 'Region', p) and (s.has(el['claw'], p) and (macros['LEDGE'](s) and macros['HORIZONTAL'](s) or macros['2LEDGE'](s)) or macros['3LEDGE'](s)),
		"Twin Spires 12 To Twin Spires 11"                     : lambda s : s.can_reach(el['Fort12Right'], 'Region', p) or s.can_reach(el['Fort12Left'], 'Region', p),
		"Twin Spires 12 To Twin Spires 14"                     : lambda s : s.can_reach(el['Fort12Top'], 'Region', p) and macros['LEDGE'](s) and s.has(el['claw'], p),
		"Twin Spires 12 To Twin Spires 16"                     : lambda s : s.can_reach(el['Fort12Left'], 'Region', p) or s.can_reach(el['Fort12Right'], 'Region', p) or s.can_reach(el['Fort12Top'], 'Region', p),
		"Twin Spires 13 - Amulet Fragment"                     : lambda s : s.can_reach(el['Fort13Left'], 'Region', p),
		"Twin Spires 13 - Chain of Sorcery"                    : lambda s : s.can_reach(el['Fort13Bottom1'], 'Region', p) and s.has(el['claw'], p) and macros['LEDGE'](s) or s.can_reach(el['Fort13Top'], 'Region', p),
		"Twin Spires 13 To Twin Spires 11 Left"                : lambda s : s.can_reach(el['Fort13Bottom1'], 'Region', p) or s.can_reach(el['Fort13Bottom2'], 'Region', p) or s.can_reach(el['Fort13Left'], 'Region', p) or s.can_reach(el['Fort13Top'], 'Region', p),
		"Twin Spires 13 To Twin Spires 11 Right"               : lambda s : s.can_reach(el['Fort13Bottom2'], 'Region', p) or s.can_reach(el['Fort13Top'], 'Region', p) or s.can_reach(el['Fort13Bottom1'], 'Region', p),
		"Twin Spires 13 To Twin Spires 14"                     : lambda s : s.can_reach(el['Fort13Left'], 'Region', p) or s.can_reach(el['Fort13Bottom1'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p)),
		"Twin Spires 13 To Twin Spires 19"                     : lambda s : s.can_reach(el['Fort13Top'], 'Region', p) and s.has(el['claw'], p) and macros['LEDGE'](s) or s.can_reach(el['Fort13Bottom1'], 'Region', p) and s.has(el['claw'], p) and macros['LEDGE'](s),
		"Twin Spires 14 - Writing on the Wall"                 : lambda s : s.can_reach(el['Fort14Right'], 'Region', p) and s.has(el['hook'], p) and s.has(el['slam'], p) and s.has(el['unlock'], p) and s.has(el['swim'], p),
		"Twin Spires 14 - Stone Tablet Fragment"               : lambda s : s.can_reach(el['Fort14Right'], 'Region', p) and s.has(el['hook'], p) and s.has(el['slam'], p) and s.has(el['unlock'], p) and s.has(el['swim'], p),
		"Twin Spires 14 - Stagnant Blight x100"                : lambda s : s.can_reach(el['Fort14Bottom'], 'Region', p) and macros['CHARGE'](s),
		"Twin Spires 14 - Stagnant Blight x800"                : lambda s : s.can_reach(el['Fort14Right'], 'Region', p) and s.has(el['hook'], p) and s.has(el['slam'], p) and s.has(el['unlock'], p) and s.has(el['swim'], p),
		"Twin Spires 14 - Furious Blight x10"                  : lambda s : s.can_reach(el['Fort14Right'], 'Region', p) or s.can_reach(el['Fort14Left'], 'Region', p) or s.can_reach(el['Fort14Bottom'], 'Region', p),
		"Twin Spires 14 To Twin Spires 15"                     : lambda s : s.can_reach(el['Fort14Left'], 'Region', p) or s.can_reach(el['Fort14Right'], 'Region', p) and (s.has(el['dash'], p) or macros['HORIZONTAL'](s) or macros['LEDGE'](s)),
		"Twin Spires 14 To Twin Spires 13"                     : lambda s : s.can_reach(el['Fort14Right'], 'Region', p) or s.can_reach(el['Fort14Left'], 'Region', p) or s.can_reach(el['Fort14Bottom'], 'Region', p),
		"Twin Spires 14 To Twin Spires 12"                     : lambda s : s.can_reach(el['Fort14Bottom'], 'Region', p) or s.can_reach(el['Fort14Right'], 'Region', p) or s.can_reach(el['Fort14Left'], 'Region', p),
		"Twin Spires 15 - Bloodied Note 3"                     : lambda s : s.can_reach(el['Fort15Right2'], 'Region', p),
		"Twin Spires 15 - Immortal's Crest"                    : lambda s : s.can_reach(el['Fort15Top'], 'Region', p) and (s.has(el['hook'], p) or macros['2LEDGE'](s)),
		"Twin Spires 15 - Stagnant Blight x30"                 : lambda s : s.can_reach(el['Fort15Right2'], 'Region', p) and s.has(el['claw'], p) or s.can_reach(el['Fort15Top'], 'Region', p) or s.can_reach(el['Fort15Bottom'], 'Region', p),
		"Twin Spires 15 - Stagnant Blight x10"                 : lambda s : s.can_reach(el['Fort15Right2'], 'Region', p) and macros['LEDGE'](s),
		"Twin Spires 15 To Twin Spires 16 Upper"               : lambda s : s.can_reach(el['Fort15Right2'], 'Region', p) or s.can_reach(el['Fort15Right1'], 'Region', p) or s.can_reach(el['Fort15Top'], 'Region', p) or s.can_reach(el['Fort15Bottom'], 'Region', p) and macros['LEDGE'](s),
		"Twin Spires 15 To Twin Spires 14"                     : lambda s : s.can_reach(el['Fort15Right1'], 'Region', p) or s.can_reach(el['Fort15Right2'], 'Region', p) and macros['LEDGE'](s),
		"Twin Spires 15 To Twin Spires 05"                     : lambda s : s.can_reach(el['Fort15Bottom'], 'Region', p) or s.can_reach(el['Fort15Top'], 'Region', p),
		"Twin Spires 15 To Twin Spires 17"                     : lambda s : s.can_reach(el['Fort15Top'], 'Region', p) or s.can_reach(el['Fort15Right3'], 'Region', p) and macros['LEDGE'](s),
		"Twin Spires 15 To Twin Spires 16 Lower"               : lambda s : s.can_reach(el['Fort15Right3'], 'Region', p) or s.can_reach(el['Fort15Bottom'], 'Region', p) and macros['LEDGE'](s) or s.can_reach(el['Fort15Right2'], 'Region', p),
		"Twin Spires 16 - Monument Engraving"                  : lambda s : s.can_reach(el['Fort16Left1'], 'Region', p) or s.can_reach(el['Fort16Top'], 'Region', p) or s.can_reach(el['Fort16Left2'], 'Region', p) or s.can_reach(el['Fort16Right'], 'Region', p),
		"Twin Spires 16 To Twin Spires 15 Upper"               : lambda s : s.can_reach(el['Fort16Left1'], 'Region', p) or s.can_reach(el['MonumentOfTheWindStart'], 'Location', p),
		"Twin Spires 16 To Twin Spires 18"                     : lambda s : s.can_reach(el['Fort16Top'], 'Region', p),
		"Twin Spires 16 To Twin Spires 15 Lower"               : lambda s : s.can_reach(el['Fort16Left2'], 'Region', p),
		"Twin Spires 16 To Twin Spires 12"                     : lambda s : s.can_reach(el['Fort16Right'], 'Region', p),
		"MonumentOfTheWindStart"                               : lambda s : s.can_reach(el['Fort16Left1'], 'Region', p),
		"Twin Spires 17 - Amulet Fragment"                     : lambda s : s.can_reach(el['Fort17Bottom'], 'Region', p),
		"Twin Spires 17 To Twin Spires 15"                     : lambda s : s.can_reach(el['Fort17Bottom'], 'Region', p),
		"Twin Spires 17 To Twin Spires 18"                     : lambda s : s.can_reach(el['Fort17Right'], 'Region', p) or s.can_reach(el['Fort17Bottom'], 'Region', p),
		"Twin Spires 18 - Amulet Gem"                          : lambda s : s.can_reach(el['Fort18Right'], 'Region', p) and (s.has(el['claw'], p) and (s.has(el['sinner'], p) or s.has(el['dodge'], p) and macros['LEDGE'](s) or macros['2LEDGE'](s) or s.has(el['djump'], p) and s.has(el['dash'], p))),
		"Twin Spires 18 - Chain of Sorcery"                    : lambda s : s.can_reach(el['Fort18Bottom'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p)),
		"Twin Spires 18 To Twin Spires 17"                     : lambda s : s.can_reach(el['Fort18Left'], 'Region', p) or s.can_reach(el['Fort18Right'], 'Region', p),
		"Twin Spires 18 To Twin Spires 19"                     : lambda s : s.can_reach(el['Fort18Right'], 'Region', p) or s.can_reach(el['Fort18Left'], 'Region', p) or s.can_reach(el['Fort18Bottom'], 'Region', p),
		"Twin Spires 18 To Twin Spires 16"                     : lambda s : s.can_reach(el['Fort18Bottom'], 'Region', p) or s.can_reach(el['Fort18Right'], 'Region', p),
		"Twin Spires 19 - Ancient Dragon Claw"                 : lambda s : s.can_reach(el['Fort19Top'], 'Region', p),
		"Twin Spires 19 - Furious Blight x30"                  : lambda s : s.can_reach(el['Fort19Top'], 'Region', p) and s.has(el['claw'], p),
		"Twin Spires 19 - Furious Blight x10"                  : lambda s : s.can_reach(el['Fort19Left'], 'Region', p) and s.has(el['slam'], p),
		"Twin Spires 19 To Twin Spires 18"                     : lambda s : s.can_reach(el['Fort19Left'], 'Region', p) or s.can_reach(el['Fort19Top'], 'Region', p) and macros['LEDGE'](s),
		"Twin Spires 19 To Twin Spires 20"                     : lambda s : s.can_reach(el['Fort19Top'], 'Region', p) or s.can_reach(el['Fort19Left'], 'Region', p) and macros['LEDGE'](s),
		"Twin Spires 19 To Twin Spires 13"                     : lambda s : s.can_reach(el['Fort19Bottom'], 'Region', p) or s.can_reach(el['Fort19Top'], 'Region', p) and s.has(el['claw'], p),
		"Twin Spires 20 To Twin Spires 19"                     : lambda s : s.can_reach(el['Fort20Bottom'], 'Region', p) or s.can_reach(el['MourningHall'], 'Location', p),
		"Twin Spires 20 To Twin Spires 21"                     : lambda s : s.can_reach(el['Fort20Top'], 'Region', p) or s.can_reach(el['MourningHall'], 'Location', p),
		"Twin Spires 21 - Ulv, the Mad Knight"                 : lambda s : s.can_reach(el['Fort21Bottom'], 'Region', p),
		"Twin Spires 21 - Priestess' Wish"                     : lambda s : s.can_reach(el['Ulv'], 'Location', p) and (s.has(el['claw'], p) or (s.has(el['silva'], p) and s.has(el['djump'], p) and (s.has(el['champion'], p) or s.has(el['dodge'], p)))),
		"Twin Spires 21 - White Priestess' Bastion Letter"     : lambda s : s.can_reach(el['Ulv'], 'Location', p) and (s.has(el['claw'], p) or (s.has(el['silva'], p) and s.has(el['djump'], p) and (s.has(el['champion'], p) or s.has(el['dodge'], p)))),
		"Twin Spires 21 To Twin Spires 20"                     : lambda s : s.can_reach(el['Fort21Bottom'], 'Region', p),
		"MourningHall"                                         : lambda s : s.can_reach(el['Fort20Bottom'], 'Region', p) or s.can_reach(el['Fort20Top'], 'Region', p),
		"Stockade 01 - Amulet Fragment"                        : lambda s : s.can_reach(el['Oubliette01Left'], 'Region', p) and s.has(el['swim'], p),
		"Stockade 01 - Stagnant Blight x10"                    : lambda s : s.can_reach(el['Oubliette01Left'], 'Region', p) and s.has(el['swim'], p),
		"Stockade 01 To Witch's Thicket 07"                    : lambda s : s.can_reach(el['Oubliette01Left'], 'Region', p) or s.can_reach(el['Oubliette01Right'], 'Region', p) and s.has(el['swim'], p),
		"Stockade 01 To Stockade 02"                           : lambda s : s.can_reach(el['Oubliette01Right'], 'Region', p) or s.can_reach(el['Oubliette01Left'], 'Region', p) and s.has(el['swim'], p),
		"Stockade 02 - Executioner's Vow"                      : lambda s : s.can_reach(el['Oubliette02Left'], 'Region', p) or s.can_reach(el['Oubliette02Right1'], 'Region', p) or s.can_reach(el['Oubliette02Right2'], 'Region', p),
		"Stockade 02 To Stockade 01"                           : lambda s : s.can_reach(el['Oubliette02Left'], 'Region', p) or s.can_reach(el['Aqueduct'], 'Location', p) and (macros['LEDGE'](s) or s.has(el['claw'], p)),
		"Stockade 02 To Stockade 05"                           : lambda s : s.can_reach(el['Oubliette02Right1'], 'Region', p) or s.can_reach(el['Aqueduct'], 'Location', p),
		"Stockade 02 To Stockade 04"                           : lambda s : s.can_reach(el['Oubliette02Right2'], 'Region', p) or s.can_reach(el['Aqueduct'], 'Location', p),
		"Stockade 03 - Right Stagnant Blight x10"              : lambda s : s.can_reach(el['Oubliette03Left'], 'Region', p) and s.has(el['swim'], p),
		"Stockade 03 - Left Stagnant Blight x10"               : lambda s : s.can_reach(el['Oubliette03Left'], 'Region', p) and s.has(el['swim'], p),
		"Stockade 03 To Stockade 04"                           : lambda s : s.can_reach(el['Oubliette03Left'], 'Region', p) or s.can_reach(el['Oubliette03Right'], 'Region', p) and s.has(el['swim'], p),
		"Stockade 03 To Stockade 10"                           : lambda s : s.can_reach(el['Oubliette03Right'], 'Region', p) or s.can_reach(el['Oubliette03Left'], 'Region', p) and s.has(el['swim'], p) or s.can_reach(el['Oubliette03Top'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p) or s.has(el['swim'], p)),
		"Stockade 03 To Stockade 05"                           : lambda s : s.can_reach(el['Oubliette03Top'], 'Region', p) or s.can_reach(el['Oubliette03Right'], 'Region', p) and s.has(el['hook'], p),
		"Stockade 03 - Stagnant Blight x800"                   : lambda s : s.can_reach(el['Oubliette03Right'], 'Region', p) and macros['CHARGE'](s),
		"Stockade 04 - Stagnant Blight x30"                    : lambda s : s.can_reach(el['Oubliette04Left'], 'Region', p) and (macros['FULLSILVA'](s) or s.has(el['hook'], p) or macros['3LEDGE'](s) or s.has(el['sinner'], p) and s.has(el['silva'], p) and s.has(el['djump'], p) or s.has(el['silva'], p) and s.has(el['champion'], p) and s.has(el['dodge'], p) or macros['2HORIZONTAL'](s) and s.has(el['dash'], p) and macros['LEDGE'](s) or s.has(el['djump'], p) and s.has(el['champion'], p) and macros['HORIZONTAL'](s)),
		"Stockade 04 - Furious Blight x10"                     : lambda s : s.can_reach(el['Oubliette04Right'], 'Region', p) or s.can_reach(el['Oubliette04Left'], 'Region', p),
		"Stockade 04 To Stockade 03"                           : lambda s : s.can_reach(el['Oubliette04Right'], 'Region', p) or s.can_reach(el['Oubliette04Left'], 'Region', p),
		"Stockade 04 To Stockade 02"                           : lambda s : s.can_reach(el['Oubliette04Right'], 'Region', p) and (s.has(el['claw'], p) or s.has(el['hook'], p) or macros['LEDGE'](s)) or s.can_reach(el['Oubliette04Left'], 'Region', p),
		"Stockade 05_1 To Stockade 05"                         : lambda s : s.can_reach(el['Oubliette051Bottom'], 'Region', p),
		"Stockade 05_1 - Furious Blight x10"                   : lambda s : s.can_reach(el['Oubliette051Bottom'], 'Region', p),
		"Stockade 05_2 To Stockade 05 Left"                    : lambda s : s.can_reach(el['Oubliette052Bottom1'], 'Region', p) or s.can_reach(el['Oubliette052Bottom2'], 'Region', p),
		"Stockade 05_2 - Stagnant Blight x10"                  : lambda s : s.can_reach(el['Oubliette052Bottom1'], 'Region', p) and (macros['LEDGE'](s) and s.has(el['claw'], p) and s.has(el['hook'], p)),
		"Stockade 05_2 To Stockade 05 Right"                   : lambda s : s.can_reach(el['Oubliette052Bottom2'], 'Region', p) or s.can_reach(el['Oubliette052Bottom1'], 'Region', p) and (macros['LEDGE'](s) and s.has(el['claw'], p) and s.has(el['hook'], p)),
		"Stockade 05_3 - Chain of Sorcery"                     : lambda s : s.can_reach(el['Oubliette053Top'], 'Region', p),
		"Stockade 05_3 To Stockade 05"                         : lambda s : s.can_reach(el['Oubliette053Top'], 'Region', p),
		"Stockade 05 - Amulet Gem"                             : lambda s : s.can_reach(el['Oubliette05Top4'], 'Region', p),
		"Stockade 05 To Stockade 05_2 Left"                    : lambda s : s.can_reach(el['Oubliette05Top2'], 'Region', p) or s.can_reach(el['Oubliette05Top1'], 'Region', p),
		"Stockade 05 To Stockade 05_3"                         : lambda s : s.can_reach(el['Oubliette05Bottom2'], 'Region', p) or s.can_reach(el['Oubliette05Left'], 'Region', p),
		"Stockade 05 To Stockade 07_2"                         : lambda s : s.can_reach(el['Oubliette05Top3'], 'Region', p) or s.can_reach(el['Oubliette05Top1'], 'Region', p),
		"Stockade 05 To Stockade 05_1"                         : lambda s : s.can_reach(el['Oubliette05Top1'], 'Region', p) or s.can_reach(el['Oubliette05Left'], 'Region', p) and macros['LEDGE'](s),
		"Stockade 05 To Stockade 07_1"                         : lambda s : s.can_reach(el['Oubliette05Bottom1'], 'Region', p) or s.can_reach(el['Oubliette05Left'], 'Region', p),
		"Stockade 05 - Stagnant Blight x100"                   : lambda s : s.can_reach(el['Oubliette05Top1'], 'Region', p) and macros['CHARGE'](s),
		"Stockade 05 - Stagnant Blight x30"                    : lambda s : s.can_reach(el['Oubliette05Top4'], 'Region', p),
		"Stockade 05 To Stockade 02"                           : lambda s : s.can_reach(el['Oubliette05Left'], 'Region', p) or s.can_reach(el['Oubliette05Right'], 'Region', p) or s.can_reach(el['Oubliette05Top1'], 'Region', p),
		"Stockade 05 To Stockade 06"                           : lambda s : s.can_reach(el['Oubliette05Right'], 'Region', p) or s.can_reach(el['Oubliette05Top4'], 'Region', p) and s.has(el['slam'], p),
		"Stockade 05 To Stockade 03"                           : lambda s : s.can_reach(el['Oubliette05Bottom3'], 'Region', p) or s.can_reach(el['Oubliette05Left'], 'Region', p),
		"Stockade 05 To Stockade 05_2 Right"                   : lambda s : s.can_reach(el['Oubliette05Top4'], 'Region', p),
		"Stockade 06_1 - Hoenir's Diary 1"                     : lambda s : s.can_reach(el['Oubliette061Left'], 'Region', p),
		"Stockade 06_1 To Stockade 07"                         : lambda s : s.can_reach(el['Oubliette061Left'], 'Region', p) or s.can_reach(el['Cells'], 'Location', p),
		"Stockade 06_2 - Executioner's Gloves"                 : lambda s : s.can_reach(el['Oubliette062Bottom2'], 'Region', p) and s.has(el['swim'], p),
		"Stockade 06_2 To Stockade 07"                         : lambda s : s.can_reach(el['Oubliette062Bottom2'], 'Region', p),
		"Stockade 06_3 - Chain of Sorcery"                     : lambda s : s.can_reach(el['Oubliette063Left1'], 'Region', p),
		"Stockade 06_3 To Stockade 07"                         : lambda s : s.can_reach(el['Oubliette063Left1'], 'Region', p),
		"Stockade 06_4 - Stone Tablet Fragment"                : lambda s : s.can_reach(el['Oubliette064Top'], 'Region', p),
		"Stockade 06_4 To Stockade 07"                         : lambda s : s.can_reach(el['Oubliette064Top'], 'Region', p),
		"Stockade 06 - Amulet Fragment"                        : lambda s : s.can_reach(el['Oubliette06Bottom'], 'Region', p),
		"Stockade 06 - Chain of Sorcery"                       : lambda s : s.can_reach(el['Oubliette06Bottom'], 'Region', p) and s.has(el['hook'], p),
		"Stockade 06 - Stagnant Blight x10"                    : lambda s : s.can_reach(el['Oubliette06Bottom'], 'Region', p),
		"Stockade 06 To Stockade 05"                           : lambda s : s.can_reach(el['Oubliette06Left'], 'Region', p) or s.can_reach(el['Oubliette06Bottom'], 'Region', p) and s.has(el['hook'], p),
		"Stockade 06 To Stockade 07"                           : lambda s : s.can_reach(el['Oubliette06Right'], 'Region', p) or s.can_reach(el['Oubliette06Bottom'], 'Region', p) and s.has(el['hook'], p),
		"Stockade 06 To Stockade 10"                           : lambda s : s.can_reach(el['Oubliette06Bottom'], 'Region', p) or s.can_reach(el['Oubliette06Right'], 'Region', p) or s.can_reach(el['Oubliette06Left'], 'Region', p),
		"Stockade 07_1 - Forbidden Text Scrap"                 : lambda s : s.can_reach(el['Oubliette071Top'], 'Region', p),
		"Stockade 07_1 To Stockade 05"                         : lambda s : s.can_reach(el['Oubliette071Top'], 'Region', p),
		"Stockade 07_2 - Hidden Test Subject"                  : lambda s : s.can_reach(el['Oubliette072Bottom'], 'Region', p),
		"Stockade 07_2 To Stockade 05"                         : lambda s : s.can_reach(el['Oubliette072Bottom'], 'Region', p),
		"Stockade 07 To Stockade 06_1"                         : lambda s : s.can_reach(el['Oubliette07Right1'], 'Region', p) or s.can_reach(el['Oubliette07Bottom1'], 'Region', p) and (s.has(el['hook'], p) or macros['LEDGE'](s)),
		"Stockade 07 To Stockade 06_3"                         : lambda s : s.can_reach(el['Oubliette07Left1'], 'Region', p) or s.can_reach(el['Oubliette07Bottom1'], 'Region', p) and (s.has(el['hook'], p) and (macros['LEDGE'](s) or macros['HORIZONTAL'](s)) or s.has(el['silva'], p) and s.has(el['djump'], p)),
		"Stockade 07 To Stockade 06_2"                         : lambda s : s.can_reach(el['Oubliette07Bottom2'], 'Region', p) or s.can_reach(el['Oubliette07Bottom1'], 'Region', p),
		"Stockade 07 To Stockade 06_4"                         : lambda s : s.can_reach(el['Oubliette07Top'], 'Region', p) or s.can_reach(el['Oubliette07Left1'], 'Region', p) and s.has(el['unlock'], p) and (s.has(el['hook'], p) or s.has(el['claw'], p) and (macros['3LEDGE'](s) or macros['FULLSILVA'](s))),
		"Stockade 07 To Stockade 06"                           : lambda s : s.can_reach(el['Oubliette07Left2'], 'Region', p),
		"Stockade 07 To Stockade 13"                           : lambda s : s.can_reach(el['Oubliette07Right2'], 'Region', p) or s.can_reach(el['Oubliette07Bottom1'], 'Region', p),
		"Stockade 07 To Stockade 09"                           : lambda s : s.can_reach(el['Oubliette07Bottom1'], 'Region', p) or s.can_reach(el['Oubliette07Left1'], 'Region', p) or s.can_reach(el['Oubliette07Left2'], 'Region', p) or s.can_reach(el['Oubliette07Bottom2'], 'Region', p) or s.can_reach(el['Oubliette07Right1'], 'Region', p) or s.can_reach(el['Oubliette07Right2'], 'Region', p),
		"Stockade 08 - Lower Furious Blight x30"               : lambda s : s.has(el['slam'], p) and (s.can_reach(el['Oubliette08Top'], 'Region', p) or s.can_reach(el['Oubliette08Right'], 'Region', p) and (s.has(el['hook'], p) or macros['LEDGE'](s) or macros['HORIZONTAL'](s))),
		"Stockade 08 - Upper Furious Blight x30"               : lambda s : s.can_reach(el['Oubliette08Left'], 'Region', p) and s.has(el['hook'], p),
		"Stockade 08 To Stockade 11"                           : lambda s : s.can_reach(el['Oubliette08Right'], 'Region', p) or s.can_reach(el['Oubliette08Left'], 'Region', p) and macros['LEDGE'](s),
		"Stockade 08 To Stockade 09"                           : lambda s : s.can_reach(el['Oubliette08Left'], 'Region', p) or s.can_reach(el['Oubliette08Right'], 'Region', p) or s.can_reach(el['Oubliette08Top'], 'Region', p),
		"Stockade 08 To Stockade 13"                           : lambda s : s.can_reach(el['Oubliette08Top'], 'Region', p) or s.can_reach(el['Oubliette08Right'], 'Region', p) and s.has(el['hook'], p),
		"Stockade 09 - Right Amulet Fragment"                  : lambda s : s.can_reach(el['Oubliette09Top'], 'Region', p) and s.has(el['claw'], p),
		"Stockade 09 - Left Amulet Fragment"                   : lambda s : s.can_reach(el['Oubliette09Top'], 'Region', p) and s.has(el['claw'], p),
		"Stockade 09 - Stagnant Blight x30"                    : lambda s : s.can_reach(el['Oubliette09Top'], 'Region', p) and s.has(el['swim'], p),
		"Stockade 09 To Stockade 08"                           : lambda s : s.can_reach(el['Oubliette09Right'], 'Region', p) or s.can_reach(el['Oubliette09Top'], 'Region', p) and s.has(el['swim'], p) and macros['HORIZONTAL'](s),
		"Stockade 09 To Stockade 10"                           : lambda s : s.can_reach(el['Oubliette09Left'], 'Region', p) or s.can_reach(el['Oubliette09Top'], 'Region', p) and s.has(el['swim'], p),
		"Stockade 09 To Stockade 07"                           : lambda s : s.can_reach(el['Oubliette09Top'], 'Region', p) or s.can_reach(el['Oubliette09Left'], 'Region', p),
		"Stockade 10 - Executioner's Missive"                  : lambda s : s.can_reach(el['Oubliette10Left1'], 'Region', p) or s.can_reach(el['Oubliette10Right'], 'Region', p) or s.can_reach(el['Oubliette10Left2'], 'Region', p) or s.can_reach(el['Oubliette10Top'], 'Region', p),
		"Stockade 10 To Stockade 09"                           : lambda s : s.can_reach(el['Oubliette10Right'], 'Region', p) or s.can_reach(el['DarkChamber'], 'Location', p),
		"Stockade 10 To Stockade 03"                           : lambda s : s.can_reach(el['Oubliette10Left1'], 'Region', p) or s.can_reach(el['DarkChamber'], 'Location', p),
		"Stockade 10 To Stockade 17"                           : lambda s : s.can_reach(el['Oubliette10Left2'], 'Region', p) or s.can_reach(el['DarkChamber'], 'Location', p) and macros['CHARGE'](s),
		"Stockade 10 To Stockade 06"                           : lambda s : s.can_reach(el['Oubliette10Top'], 'Region', p) or s.can_reach(el['DarkChamber'], 'Location', p),
		"Stockade 11 - Furious Blight x10"                     : lambda s : s.can_reach(el['Oubliette11Left1'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['dash'], p) or macros['HORIZONTAL'](s) or s.has(el['hook'], p)) or s.can_reach(el['Oubliette11Left2'], 'Region', p) and s.has(el['hook'], p),
		"Stockade 11 To Stockade 12"                           : lambda s : s.can_reach(el['Oubliette11Right1'], 'Region', p) or s.can_reach(el['Oubliette11Left1'], 'Region', p) or s.can_reach(el['Oubliette11Top'], 'Region', p),
		"Stockade 11 To Stockade 08"                           : lambda s : s.can_reach(el['Oubliette11Left2'], 'Region', p) or s.can_reach(el['Oubliette11Left1'], 'Region', p) or s.can_reach(el['Oubliette11Right1'], 'Region', p) or s.can_reach(el['Oubliette11Top'], 'Region', p) or s.can_reach(el['Oubliette11Right2'], 'Region', p),
		"Stockade 11 To Stockade 14"                           : lambda s : s.can_reach(el['Oubliette11Right2'], 'Region', p) or s.can_reach(el['Oubliette11Left2'], 'Region', p),
		"Stockade 11 To Stockade 13"                           : lambda s : s.can_reach(el['Oubliette11Left1'], 'Region', p) or s.can_reach(el['Oubliette11Left2'], 'Region', p) and s.has(el['hook'], p) or s.can_reach(el['Oubliette11Right2'], 'Region', p) and (macros['HORIZONTAL'](s) or macros['LEDGE'](s)),
		"Stockade 11 To Stockade 13_2"                         : lambda s : s.can_reach(el['Oubliette11Bottom'], 'Region', p) or s.can_reach(el['Oubliette11Left1'], 'Region', p) and s.has(el['slam'], p),
		"Stockade 11 To Stockade 13_1"                         : lambda s : s.can_reach(el['Oubliette11Top'], 'Region', p) or s.can_reach(el['Oubliette11Left1'], 'Region', p) and s.has(el['claw'], p) and (macros['FULLSILVA'](s) or (s.has(el['hook'], p) and (macros['HORIZONTAL'](s) or macros['LEDGE'](s)))),
		"Stockade 12 - Dark Executioner"                       : lambda s : s.can_reach(el['Oubliette12Left'], 'Region', p),
		"Stockade 12 To Stockade 11"                           : lambda s : s.can_reach(el['Oubliette12Left'], 'Region', p) or s.can_reach(el['Executioner'], 'Location', p),
		"Stockade 13_1 - Aura's Ring"                          : lambda s : s.can_reach(el['Oubliette131Bottom'], 'Region', p),
		"Stockade 13_1 To Stockade 11"                         : lambda s : s.can_reach(el['Oubliette131Bottom'], 'Region', p),
		"Stockade 13_2 - Ancient Soul x1"                      : lambda s : s.can_reach(el['Oubliette132Top'], 'Region', p),
		"Stockade 13_2 To Stockade 11"                         : lambda s : s.can_reach(el['Oubliette132Top'], 'Region', p),
		"Stockade 13 - Chain of Sorcery"                       : lambda s : s.can_reach(el['Oubliette13Right'], 'Region', p) and (s.has(el['claw'], p) and macros['LEDGE'](s) or macros['2LEDGE'](s) or s.has(el['hook'], p)),
		"Stockade 13 - Slip of Paper"                          : lambda s : s.can_reach(el['Oubliette13Left'], 'Region', p),
		"Stockade 13 - Stagnant Blight x30"                    : lambda s : s.can_reach(el['Oubliette13Left'], 'Region', p),
		"Stockade 13 - Stagnant Blight x100"                   : lambda s : s.can_reach(el['Oubliette13Left'], 'Region', p) and macros['CHARGE'](s) and (macros['LEDGE'](s) or macros['HORIZONTAL'](s) or s.has(el['hook'], p) or s.has(el['dash'], p) or s.has(el['claw'], p)),
		"Stockade 13 To Stockade 08"                           : lambda s : s.can_reach(el['Oubliette13Bottom'], 'Region', p) or s.can_reach(el['Oubliette13Right'], 'Region', p),
		"Stockade 13 To Stockade 11"                           : lambda s : s.can_reach(el['Oubliette13Right'], 'Region', p) or s.can_reach(el['Oubliette13Left'], 'Region', p),
		"Stockade 13 To Stockade 07"                           : lambda s : s.can_reach(el['Oubliette13Left'], 'Region', p) or s.can_reach(el['Oubliette13Right'], 'Region', p) and (s.has(el['hook'], p) or macros['LEDGE'](s) and s.has(el['claw'], p) and macros['HORIZONTAL'](s)),
		"Stockade 14 - Hoenir's Diary 2"                       : lambda s : s.can_reach(el['Oubliette14Left'], 'Region', p) or s.can_reach(el['Oubliette14Right'], 'Region', p),
		"Stockade 14 To Stockade 11"                           : lambda s : s.can_reach(el['Oubliette14Left'], 'Region', p) or s.can_reach(el['ExecutionGrounds'], 'Location', p),
		"Stockade 14 To Stockade 15"                           : lambda s : s.can_reach(el['Oubliette14Right'], 'Region', p) or s.can_reach(el['ExecutionGrounds'], 'Location', p),
		"Stockade 15 - Hoenir, Keeper of the Abyss"            : lambda s : s.can_reach(el['Oubliette15Left'], 'Region', p) or s.can_reach(el['Oubliette15Right'], 'Region', p),
		"Stockade 15 To Stockade 14"                           : lambda s : s.can_reach(el['Oubliette15Left'], 'Region', p) or s.can_reach(el['Oubliette15Right'], 'Region', p),
		"Stockade 15 To Stockade 16"                           : lambda s : s.can_reach(el['Oubliette15Right'], 'Region', p) or s.can_reach(el['Oubliette15Left'], 'Region', p),
		"Stockade 16 - Priestess' Wish"                        : lambda s : s.can_reach(el['Oubliette16Right'], 'Region', p),
		"Stockade 16 - Stagnant Blight x10"                    : lambda s : s.can_reach(el['Oubliette16Left'], 'Region', p),
		"Stockade 16 To Stockade 15"                           : lambda s : s.can_reach(el['Oubliette16Left'], 'Region', p) or s.can_reach(el['Oubliette16Right'], 'Region', p),
		"Stockade 16 To Hinterlands 01"                        : lambda s : s.can_reach(el['Oubliette16Right'], 'Region', p) or s.can_reach(el['Oubliette16Left'], 'Region', p) and (s.has(el['hook'], p) and (s.has(el['sinner'], p) and (macros['LEDGE'](s) or s.has(el['dash'], p) or s.has(el['dodge'], p)) or s.has(el['silva'], p) and (s.has(el['djump'], p) or s.has(el['dodge'], p) or s.has(el['champion'], p) and s.has(el['dash'], p)) or s.has(el['djump'], p) and (s.has(el['dodge'], p) or s.has(el['champion'], p))) or s.has(el['silva'], p) and s.has(el['djump'], p) and (s.has(el['claw'], p) or s.has(el['champion'], p) or s.has(el['dodge'], p))),
		"Stockade 17 To Stockade 10"                           : lambda s : s.can_reach(el['Oubliette17Right'], 'Region', p),
		"Stockade 17 To Verboten Domain 06"                    : lambda s : s.can_reach(el['Oubliette17Bottom'], 'Region', p) or s.can_reach(el['Oubliette17Right'], 'Region', p) and (macros['CHARGE'](s) and s.has(el['slam'], p) and (s.has(el['dodge'], p) and s.has(el['claw'], p) or s.has(el['hook'], p))),
		"Hinterlands 01 To Hinterlands 02"                     : lambda s : s.can_reach(el['Outside01Right'], 'Region', p) or s.can_reach(el['Outside01Left1'], 'Region', p) or s.can_reach(el['Outside01Left2'], 'Region', p),
		"Hinterlands 01 To Hinterlands 03"                     : lambda s : s.can_reach(el['Outside01Left1'], 'Region', p) or s.can_reach(el['Outside01Right'], 'Region', p) and s.has(el['claw'], p) and (s.has(el['djump'], p) or s.has(el['champion'], p) or macros['2LEDGE'](s)),
		"Hinterlands 01 To Stockade 16"                        : lambda s : s.can_reach(el['Outside01Left2'], 'Region', p),
		"Hinterlands 02 To Hinterlands 01"                     : lambda s : s.can_reach(el['Outside02Left'], 'Region', p),
		"Hinterlands 03 - King of the First Age's Torn Note 1" : lambda s : s.can_reach(el['Outside03Right'], 'Region', p) and (s.has(el['claw'], p) and (macros['2LEDGE'](s) or macros['LEDGE'](s) and macros['HORIZONTAL'](s) or s.has(el['champion'], p))),
		"Hinterlands 03 - King of the First Age's Torn Note 2" : lambda s : s.can_reach(el['Grotto'], 'Location', p),
		"Hinterlands 03 - Nymphilia's Ring"                    : lambda s : s.can_reach(el['Outside03Right'], 'Region', p) and s.has(el['swim'], p),
		"Hinterlands 03 - Stagnant Blight x100"                : lambda s : s.can_reach(el['Grotto'], 'Location', p),
		"Hinterlands 03 To Hinterlands 01"                     : lambda s : s.can_reach(el['Outside03Right'], 'Region', p) or s.can_reach(el['Outside03Top'], 'Region', p),
		"Hinterlands 03 To Twin Spires 09"                     : lambda s : s.can_reach(el['Outside03Top'], 'Region', p),
		"Verboten Domain 04 - Verboten Champion"               : lambda s : s.can_reach(el['Swamp04Bottom'], 'Region', p) and s.has(el['unlock'], p),
		"Verboten Domain 04 - Chain of Sorcery"                : lambda s : s.can_reach(el['Swamp04Left'], 'Region', p),
		"Verboten Domain 04 To Verboten Domain 05"             : lambda s : s.can_reach(el['Swamp04Bottom'], 'Region', p) or s.can_reach(el['Swamp04Left'], 'Region', p) and macros['LEDGE'](s),
		"Verboten Domain 04 To Verboten Domain 3R"             : lambda s : s.can_reach(el['Swamp04Left'], 'Region', p) or s.can_reach(el['Swamp04Bottom'], 'Region', p) and macros['LEDGE'](s),
		"Verboten Domain 05 - Furious Blight x100"             : lambda s : s.can_reach(el['Swamp05Left'], 'Region', p) and s.has(el['swim'], p),
		"Verboten Domain 05 To Verboten Domain 04"             : lambda s : s.can_reach(el['Swamp05Top'], 'Region', p) or s.can_reach(el['Swamp05Right'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p)),
		"Verboten Domain 05 To Verboten Domain 06"             : lambda s : s.can_reach(el['Swamp05Right'], 'Region', p) or s.can_reach(el['Swamp05Top'], 'Region', p) or s.can_reach(el['Swamp05Left'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p)),
		"Verboten Domain 05 To Verboten Domain 07"             : lambda s : s.can_reach(el['Swamp05Bottom'], 'Region', p) or s.can_reach(el['Swamp05Left'], 'Region', p) and s.has(el['swim'], p) and macros['CHARGE'](s),
		"Verboten Domain 05 To Verboten Domain 09"             : lambda s : s.can_reach(el['Swamp05Left'], 'Region', p) or s.can_reach(el['Swamp05Right'], 'Region', p),
		"Verboten Domain 05 - Stagnant Blight x30"             : lambda s : s.can_reach(el['Swamp05Left'], 'Region', p) and s.has(el['swim'], p),
		"Verboten Domain 06 - Verboten Domain Notice"          : lambda s : s.can_reach(el['Swamp06Left'], 'Region', p) or s.can_reach(el['Swamp06Top'], 'Region', p),
		"Verboten Domain 06 - Heretic's Mask"                  : lambda s : s.can_reach(el['Swamp06Top'], 'Region', p),
		"Verboten Domain 06 - Stagnant Blight x30"             : lambda s : s.can_reach(el['Swamp06Top'], 'Region', p),
		"Verboten Domain 06 To Verboten Domain 05"             : lambda s : s.can_reach(el['Swamp06Left'], 'Region', p) or s.can_reach(el['Lab2'], 'Location', p),
		"Verboten Domain 06 To Stockade 17"                    : lambda s : s.can_reach(el['Swamp06Top'], 'Region', p),
		"Verboten Domain 07 - Amulet Fragment"                 : lambda s : s.can_reach(el['Swamp07Right'], 'Region', p) and s.has(el['claw'], p),
		"Verboten Domain 07 - Calivia's Ring"                  : lambda s : s.can_reach(el['Swamp07Left'], 'Region', p) and (s.has(el['claw'], p) and macros['LEDGE'](s)),
		"Verboten Domain 07 To Verboten Domain 16"             : lambda s : s.can_reach(el['Swamp07Bottom'], 'Region', p) or s.can_reach(el['Swamp07Right'], 'Region', p) and s.can_reach(el['Swamp07Left'], 'Region', p) and s.can_reach(el['Swamp07Top'], 'Region', p),
		"Verboten Domain 07 To Verboten Domain 05"             : lambda s : s.can_reach(el['Swamp07Right'], 'Region', p),
		"Verboten Domain 07 To Verboten Domain 08"             : lambda s : s.can_reach(el['Swamp07Left'], 'Region', p),
		"Verboten Domain 07 To Verboten Domain 3B"             : lambda s : s.can_reach(el['Swamp07Top'], 'Region', p),
		"Verboten Domain 08 - Amulet Gem"                      : lambda s : s.can_reach(el['Swamp08Right2'], 'Region', p) and s.has(el['swim'], p),
		"Verboten Domain 08 - Stagnant Blight x100"            : lambda s : s.can_reach(el['Swamp08Right2'], 'Region', p) and s.has(el['swim'], p),
		"Verboten Domain 08 - Furious Blight x100"             : lambda s : s.can_reach(el['Swamp08Right2'], 'Region', p) and s.has(el['swim'], p),
		"Verboten Domain 08 To Verboten Domain 07"             : lambda s : s.can_reach(el['Swamp08Right1'], 'Region', p) or s.can_reach(el['Swamp08Right2'], 'Region', p) and (s.has(el['hook'], p) or (s.has(el['claw'], p) and (s.has(el['djump'], p) or s.has(el['champion'], p) or s.has(el['silva'], p) and s.has(el['dodge'], p)))) and (s.has(el['djump'], p) or macros['HORIZONTAL'](s)),
		"Verboten Domain 08 To Verboten Domain 15"             : lambda s : s.can_reach(el['Swamp08Right2'], 'Region', p) or s.can_reach(el['Swamp08Top'], 'Region', p) or s.can_reach(el['Swamp08Right1'], 'Region', p),
		"Verboten Domain 08 To Verboten Domain 14"             : lambda s : s.can_reach(el['Swamp08Top'], 'Region', p) or s.can_reach(el['Swamp08Right2'], 'Region', p) and macros['LEDGE'](s),
		"Verboten Domain 09 - Weathered Necklace"              : lambda s : s.can_reach(el['Swamp09Right2'], 'Region', p) and (macros['LEDGE'](s) or macros['HORIZONTAL'](s)),
		"Verboten Domain 09 - Stagnant Blight x30"             : lambda s : s.can_reach(el['Swamp09Right1'], 'Region', p) and (macros['LEDGE'](s) and macros['HORIZONTAL'](s) or macros['2LEDGE'](s)),
		"Verboten Domain 09 To Verboten Domain 13 Left"        : lambda s : s.can_reach(el['Swamp09Bottom1'], 'Region', p) or s.can_reach(el['Swamp09Right1'], 'Region', p) and macros['CHARGE'](s),
		"Verboten Domain 09 To Verboten Domain 03"             : lambda s : s.can_reach(el['Swamp09Right1'], 'Region', p) or s.can_reach(el['Swamp09Right2'], 'Region', p) and (macros['LEDGE'](s) or macros['HORIZONTAL'](s)),
		"Verboten Domain 09 To Verboten Domain 13 Right"       : lambda s : s.can_reach(el['Swamp09Bottom2'], 'Region', p) or s.can_reach(el['Swamp09Right2'], 'Region', p),
		"Verboten Domain 09 To Verboten Domain 05"             : lambda s : s.can_reach(el['Swamp09Right2'], 'Region', p) or s.can_reach(el['Swamp09Right1'], 'Region', p),
		"Verboten Domain 01 - Faden's Archives 3"              : lambda s : s.can_reach(el['Swamp1Bottom'], 'Region', p) or s.can_reach(el['Swamp1Left'], 'Region', p),
		"Verboten Domain 01 To Verboten Domain 03"             : lambda s : s.can_reach(el['Swamp1Bottom'], 'Region', p) or s.can_reach(el['Lab1'], 'Location', p),
		"Verboten Domain 01 To Verboten Domain 02"             : lambda s : s.can_reach(el['Swamp1Left'], 'Region', p) or s.can_reach(el['Lab1'], 'Location', p),
		"Verboten Domain 10 - Faden's Archives 4"              : lambda s : s.can_reach(el['Swamp10Right'], 'Region', p),
		"Verboten Domain 10 - Stagnant Blight x30"             : lambda s : s.can_reach(el['Lab3'], 'Location', p) and s.has(el['swim'], p),
		"Verboten Domain 10 To Verboten Domain 13"             : lambda s : s.can_reach(el['Swamp10Right'], 'Region', p) or s.can_reach(el['Lab3'], 'Location', p),
		"Verboten Domain 11 - Amulet Fragment"                 : lambda s : s.can_reach(el['Swamp11Left'], 'Region', p) and (macros['LEDGE'](s) and macros['HORIZONTAL'](s) or macros['2HORIZONTAL'](s) or s.has(el['silva'], p) and s.has(el['djump'], p)),
		"Verboten Domain 11 - Blighted Appendage"              : lambda s : s.can_reach(el['Swamp11Left'], 'Region', p),
		"Verboten Domain 11 To Verboten Domain 15"             : lambda s : s.can_reach(el['Swamp11Bottom'], 'Region', p) or s.can_reach(el['Swamp11Left'], 'Region', p),
		"Verboten Domain 11 To Verboten Domain 14"             : lambda s : s.can_reach(el['Swamp11Left'], 'Region', p) or s.can_reach(el['Swamp11Bottom'], 'Region', p) and (s.has(el['hook'], p) or s.has(el['claw'], p) or macros['2LEDGE'](s)) and (s.has(el['djump'], p) or s.has(el['champion'], p) or (s.has(el['silva'], p) and s.has(el['dodge'], p))),
		"Verboten Domain 12 - Priestess' Wish"                 : lambda s : s.can_reach(el['Lab4'], 'Location', p) and s.has(el['slam'], p),
		"Verboten Domain 12 - Faden's Archives 2"              : lambda s : s.can_reach(el['Swamp12Left'], 'Region', p) or s.can_reach(el['Swamp12Bottom'], 'Region', p) or s.can_reach(el['Swamp12TP'], 'Region', p),
		"Verboten Domain 12 To Verboten Domain 15"             : lambda s : s.can_reach(el['Swamp12Left'], 'Region', p) or s.can_reach(el['Lab4'], 'Location', p),
		"Verboten Domain 12 To The Abyss 04"                   : lambda s : s.can_reach(el['Swamp12Bottom'], 'Region', p) or s.can_reach(el['Lab4'], 'Location', p) and s.has(el['slam'], p) and s.has(el['unlock'], p),
		"Verboten Domain 13 - Amulet Fragment"                 : lambda s : s.can_reach(el['Swamp13Top2'], 'Region', p),
		"Verboten Domain 13 - Stagnant Blight x30"             : lambda s : s.can_reach(el['Swamp13Top1'], 'Region', p) and s.has(el['slam'], p) or s.can_reach(el['Swamp13Top2'], 'Region', p) and macros['CHARGE'](s) and s.has(el['slam'], p),
		"Verboten Domain 13 - Furious Blight x30"              : lambda s : s.can_reach(el['Swamp13Bottom'], 'Region', p) and (s.has(el['hook'], p) or s.has(el['claw'], p)),
		"Verboten Domain 13 To Verboten Domain 10"             : lambda s : s.can_reach(el['Swamp13Left'], 'Region', p) or s.can_reach(el['Swamp13Top1'], 'Region', p) and s.has(el['slam'], p) or s.can_reach(el['Swamp13Top2'], 'Region', p) and macros['CHARGE'](s) and s.has(el['slam'], p),
		"Verboten Domain 13 To Verboten Domain 09 Left"        : lambda s : s.can_reach(el['Swamp13Top1'], 'Region', p) or s.can_reach(el['Swamp13Bottom'], 'Region', p) and s.has(el['claw'], p) and macros['3LEDGE'](s),
		"Verboten Domain 13 To Verboten Domain 09 Right"       : lambda s : s.can_reach(el['Swamp13Top2'], 'Region', p),
		"Verboten Domain 13 To Verboten Domain 14"             : lambda s : s.can_reach(el['Swamp13Bottom'], 'Region', p) or s.has(el['slam'], p) and (s.can_reach(el['Swamp13Top1'], 'Region', p) or s.can_reach(el['Swamp13Left'], 'Region', p)),
		"Verboten Domain 14 - Chain of Sorcery"                : lambda s : s.can_reach(el['Swamp14Top'], 'Region', p) or s.can_reach(el['Swamp14Bottom'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p) or s.has(el['hook'], p)),
		"Verboten Domain 14 - Stagnant Blight x100"            : lambda s : s.can_reach(el['Swamp14Top'], 'Region', p) and (macros['2LEDGE'](s) or s.has(el['hook'], p)),
		"Verboten Domain 14 To Verboten Domain 13"             : lambda s : s.can_reach(el['Swamp14Top'], 'Region', p) or s.can_reach(el['Swamp14Bottom'], 'Region', p) and s.has(el['claw'], p) and macros['3LEDGE'](s),
		"Verboten Domain 14 To Verboten Domain 11"             : lambda s : s.can_reach(el['Swamp14Right'], 'Region', p) or s.can_reach(el['Swamp14Top'], 'Region', p) or s.can_reach(el['Swamp14Bottom'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p) or s.has(el['hook'], p)),
		"Verboten Domain 14 To Verboten Domain 08"             : lambda s : s.can_reach(el['Swamp14Bottom'], 'Region', p) or s.can_reach(el['Swamp14Right'], 'Region', p),
		"Verboten Domain 15 - Incompetent Sinner"              : lambda s : s.can_reach(el['Swamp15Left'], 'Region', p) and s.has(el['swim'], p) and s.has(el['mask'], p),
		"Verboten Domain 15 - Stagnant Blight x30"             : lambda s : s.can_reach(el['Swamp15Top'], 'Region', p),
		"Verboten Domain 15 To Verboten Domain 11"             : lambda s : s.can_reach(el['Swamp15Top'], 'Region', p) or s.can_reach(el['Swamp15Right'], 'Region', p) and (s.has(el['champion'], p) or s.has(el['djump'], p) or s.has(el['silva'], p) and s.has(el['dodge'], p)),
		"Verboten Domain 15 To Verboten Domain 08"             : lambda s : s.can_reach(el['Swamp15Left'], 'Region', p) or s.can_reach(el['Swamp15Right'], 'Region', p) and macros['LEDGE'](s),
		"Verboten Domain 15 To Verboten Domain 12"             : lambda s : s.can_reach(el['Swamp15Right'], 'Region', p) or s.can_reach(el['Swamp15Left'], 'Region', p) and (s.has(el['claw'], p) or s.has(el['hook'], p)) or s.can_reach(el['Swamp15Top'], 'Region', p),
		"Verboten Domain 16 - Faden's Archives 1"              : lambda s : s.can_reach(el['Swamp16Top'], 'Region', p) or s.can_reach(el['Swamp16Left'], 'Region', p),
		"Verboten Domain 16 To Verboten Domain 07"             : lambda s : s.can_reach(el['Swamp16Top'], 'Region', p) or s.can_reach(el['Lab5'], 'Location', p),
		"Verboten Domain 16 To Verboten Domain 17"             : lambda s : s.can_reach(el['Swamp16Left'], 'Region', p) or s.can_reach(el['Lab5'], 'Location', p),
		"Verboten Domain 17 To Verboten Domain 18"             : lambda s : s.can_reach(el['Swamp17Left'], 'Region', p) or s.can_reach(el['Swamp17Right'], 'Region', p),
		"Verboten Domain 17 To Verboten Domain 16"             : lambda s : s.can_reach(el['Swamp17Right'], 'Region', p) or s.can_reach(el['Swamp17Left'], 'Region', p),
		"Verboten Domain 18 - Miriel's Blighted Letter"        : lambda s : s.can_reach(el['Faden'], 'Location', p),
		"Verboten Domain 18 - Faden's Archives 5"              : lambda s : s.can_reach(el['Faden'], 'Location', p),
		"Verboten Domain 18 - Faden, the Heretic"              : lambda s : s.can_reach(el['Swamp18Right'], 'Region', p),
		"Verboten Domain 18 - Stagnant Blight x800"            : lambda s : s.can_reach(el['Faden'], 'Location', p) and s.has(el['claw'], p) and (macros['3LEDGE'](s) or s.has(el['sinner'], p) and macros['2LEDGE'](s) or macros['FULLSILVA'](s) or s.has(el['dodge'], p) and s.has(el['silva'], p) and s.has(el['champion'], p) or macros['2HORIZONTAL'](s) and s.has(el['champion'], p) and s.has(el['djump'], p)),
		"Verboten Domain 18 To The Abyss 01"                   : lambda s : s.can_reach(el['Swamp18Bottom'], 'Region', p) or s.can_reach(el['Faden'], 'Location', p) and s.has(el['unlock'], p),
		"Verboten Domain 18 To Verboten Domain 17"             : lambda s : s.can_reach(el['Swamp18Right'], 'Region', p) or s.can_reach(el['Faden'], 'Location', p),
		"Verboten Domain 02 - Furious Blight x10"              : lambda s : s.can_reach(el['Swamp2Top'], 'Region', p),
		"Verboten Domain 02 - Furious Blight x30"              : lambda s : s.can_reach(el['Swamp2Top'], 'Region', p) and (s.has(el['claw'], p) or macros['LEDGE'](s) and s.has(el['hook'], p)),
		"Verboten Domain 02 To Verboten Domain 01"             : lambda s : s.can_reach(el['Swamp2Right'], 'Region', p) or s.can_reach(el['Swamp2Top'], 'Region', p) and (s.has(el['dash'], p) or s.has(el['dodge'], p)),
		"Verboten Domain 02 To Witch's Thicket 09"             : lambda s : s.can_reach(el['Swamp2Top'], 'Region', p) or s.can_reach(el['Swamp2Right'], 'Region', p),
		"Verboten Domain 03 - Amulet Fragment"                 : lambda s : s.can_reach(el['Swamp3Top'], 'Region', p) and macros['LEDGE'](s),
		"Verboten Domain 03 - Stagnant Blight x30"             : lambda s : s.can_reach(el['Swamp3Top'], 'Region', p),
		"Verboten Domain 03 To Verboten Domain 09"             : lambda s : s.can_reach(el['Swamp3Left'], 'Region', p) or s.can_reach(el['Swamp3Bottom'], 'Region', p),
		"Verboten Domain 03 To Verboten Domain 01"             : lambda s : s.can_reach(el['Swamp3Top'], 'Region', p) or s.can_reach(el['Swamp3Left'], 'Region', p) and macros['LEDGE'](s),
		"Verboten Domain 03 To Verboten Domain 04"             : lambda s : s.can_reach(el['Swamp3Right'], 'Region', p) or s.can_reach(el['Swamp3Bottom'], 'Region', p) or s.can_reach(el['Swamp3Top'], 'Region', p),
		"Verboten Domain 03 To Verboten Domain 07"             : lambda s : s.can_reach(el['Swamp3Bottom'], 'Region', p) or s.can_reach(el['Swamp3Top'], 'Region', p) or s.can_reach(el['Swamp3Right'], 'Region', p),
		"Cliffside Hamlet 01 To Cliffside Hamlet 02"           : lambda s : s.can_reach(el['Village01Right'], 'Region', p) or s.can_reach(el['Village01Bottom'], 'Region', p),
		"Cliffside Hamlet 01 To White Parish 08"               : lambda s : s.can_reach(el['Village01Bottom'], 'Region', p) or s.can_reach(el['Village01Right'], 'Region', p),
		"Cliffside Hamlet 02 - Amulet Fragment"                : lambda s : s.can_reach(el['Village02Left'], 'Region', p),
		"Cliffside Hamlet 02 - Left Stagnant Blight x10"       : lambda s : s.can_reach(el['Village02Left'], 'Region', p) and (s.has(el['djump'], p) and (s.has(el['silva'], p) or s.has(el['champion'], p)) or (s.has(el['djump'], p) or s.has(el['silva'], p)) and macros['HORIZONTAL'](s) or s.has(el['hook'], p)),
		"Cliffside Hamlet 02 - Right Stagnant Blight x10"      : lambda s : s.can_reach(el['Village02Left'], 'Region', p) and (macros['2LEDGE'](s) or s.has(el['silva'], p) and s.has(el['dodge'], p) or s.has(el['hook'], p) and (macros['LEDGE'](s) or s.has(el['claw'], p))),
		"Cliffside Hamlet 02 To Cliffside Hamlet 03"           : lambda s : s.can_reach(el['Village02Right'], 'Region', p) or s.can_reach(el['Village02Bottom'], 'Region', p) or s.can_reach(el['Village02Left'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p)),
		"Cliffside Hamlet 02 To Cliffside Hamlet 01"           : lambda s : s.can_reach(el['Village02Left'], 'Region', p) or s.can_reach(el['Village02Bottom'], 'Region', p),
		"Cliffside Hamlet 02 To Cliffside Hamlet 13"           : lambda s : s.can_reach(el['Village02Bottom'], 'Region', p) or s.can_reach(el['Village02Right'], 'Region', p),
		"Cliffside Hamlet 03 - Amulet Fragment"                : lambda s : s.has(el['slam'], p) and (s.can_reach(el['Village03Right'], 'Region', p) and (macros['LEDGE'](s) or macros['HORIZONTAL'](s) or s.has(el['hook'], p) or s.has(el['dash'], p)) or s.can_reach(el['Village03Bottom1'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p))),
		"Cliffside Hamlet 03 - Broken Music Box"               : lambda s : s.can_reach(el['Village03Right'], 'Region', p) and (s.has(el['claw'], p) or macros['LEDGE'](s) or macros['HORIZONTAL'](s) or s.has(el['hook'], p) or s.has(el['dash'], p)),
		"Cliffside Hamlet 03 - Stagnant Blight x10"            : lambda s : s.can_reach(el['Village03Right'], 'Region', p) and (macros['LEDGE'](s) or macros['HORIZONTAL'](s) or s.has(el['hook'], p) or s.has(el['dash'], p)) or s.can_reach(el['Village03Bottom1'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p)),
		"Cliffside Hamlet 03 - Furious Blight x10"             : lambda s : s.has(el['slam'], p) and (s.can_reach(el['Village03Right'], 'Region', p) and (macros['LEDGE'](s) or macros['HORIZONTAL'](s) or s.has(el['hook'], p) or s.has(el['dash'], p)) or s.can_reach(el['Village03Bottom1'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p))),
		"Cliffside Hamlet 03 To Cliffside Hamlet 02"           : lambda s : s.can_reach(el['Village03Bottom1'], 'Region', p) or s.can_reach(el['Village03Right'], 'Region', p) and (macros['LEDGE'](s) or macros['HORIZONTAL'](s) or s.has(el['hook'], p) or s.has(el['dash'], p)),
		"Cliffside Hamlet 03 To Cliffside Hamlet 05"           : lambda s : s.can_reach(el['Village03Right'], 'Region', p) or s.can_reach(el['Village03Bottom1'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['claw'], p)),
		"Cliffside Hamlet 03 To Cliffside Hamlet 13"           : lambda s : s.can_reach(el['Village03Bottom2'], 'Region', p) or s.can_reach(el['Village03Right'], 'Region', p) and s.has(el['slam'], p),
		"Cliffside Hamlet 04_1 - Western Merchant"             : lambda s : s.can_reach(el['Village041Bottom'], 'Region', p),
		"Cliffside Hamlet 04_1 To Cliffside Hamlet 04"         : lambda s : s.can_reach(el['Village041Bottom'], 'Region', p),
		"Cliffside Hamlet 04 - Amulet Fragment"                : lambda s : s.can_reach(el['Village04Top'], 'Region', p),
		"Cliffside Hamlet 04 - Bloodstained Ribbon"            : lambda s : s.can_reach(el['Village04Right'], 'Region', p) and (s.has(el['hook'], p) and (macros['LEDGE'](s) or s.has(el['claw'], p)) or macros['LEDGE'](s) and macros['HORIZONTAL'](s) or macros['2LEDGE'](s) or macros['LEDGE'](s) and s.has(el['claw'], p)),
		"Cliffside Hamlet 04 To Cliffside Hamlet 04"           : lambda s : s.can_reach(el['Village04Top'], 'Region', p) or s.can_reach(el['Village04Right'], 'Region', p),
		"Cliffside Hamlet 04 - Stagnant Blight x10"            : lambda s : s.can_reach(el['Village04Top'], 'Region', p),
		"Cliffside Hamlet 04 To Cliffside Hamlet 05"           : lambda s : s.can_reach(el['Village04Right'], 'Region', p) or s.can_reach(el['Village04Top'], 'Region', p),
		"Cliffside Hamlet 05 - True Believer's Note"           : lambda s : s.can_reach(el['Village05Top'], 'Region', p) or s.can_reach(el['Village05Left'], 'Region', p) or s.can_reach(el['Village05Right'], 'Region', p),
		"Cliffside Hamlet 05 To Cliffside Hamlet 04"           : lambda s : s.can_reach(el['Village05Top'], 'Region', p) or s.can_reach(el['CollapsedShack'], 'Location', p),
		"Cliffside Hamlet 05 To Cliffside Hamlet 03"           : lambda s : s.can_reach(el['Village05Left'], 'Region', p) or s.can_reach(el['CollapsedShack'], 'Location', p),
		"Cliffside Hamlet 05 To Cliffside Hamlet 06"           : lambda s : s.can_reach(el['Village05Right'], 'Region', p) or s.can_reach(el['CollapsedShack'], 'Location', p),
		"Cliffside Hamlet 06 - Amulet Fragment"                : lambda s : s.can_reach(el['Village06Left'], 'Region', p),
		"Cliffside Hamlet 06 - Upper Stagnant Blight x10"      : lambda s : s.can_reach(el['Village06Right2'], 'Region', p) and (macros['2LEDGE'](s) or macros['LEDGE'](s) and s.has(el['claw'], p) or (s.has(el['silva'], p) or s.has(el['djump'], p)) and macros['HORIZONTAL'](s) or s.has(el['champion'], p) and s.has(el['sinner'], p)),
		"Cliffside Hamlet 06 - Left Stagnant Blight x10"       : lambda s : s.can_reach(el['Village06Left'], 'Region', p) and s.has(el['slam'], p) and (macros['2LEDGE'](s) or macros['LEDGE'](s) and s.has(el['claw'], p) or s.has(el['hook'], p)),
		"Cliffside Hamlet 06 - Right Stagnant Blight x10"      : lambda s : s.can_reach(el['Village06Left'], 'Region', p) and s.has(el['slam'], p) and (macros['2LEDGE'](s) or macros['LEDGE'](s) and s.has(el['claw'], p) or s.has(el['hook'], p)),
		"Cliffside Hamlet 06 - Upper Furious Blight x10"       : lambda s : s.can_reach(el['Village06Left'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['hook'], p)),
		"Cliffside Hamlet 06 - Lower Furious Blight x10"       : lambda s : s.can_reach(el['Village06Left'], 'Region', p) and s.has(el['slam'], p) and (macros['LEDGE'](s) or s.has(el['hook'], p)),
		"Cliffside Hamlet 06 To Cliffside Hamlet 05"           : lambda s : s.can_reach(el['Village06Left'], 'Region', p) or s.can_reach(el['Village06Right2'], 'Region', p) and macros['LEDGE'](s) and s.has(el['claw'], p),
		"Cliffside Hamlet 06 To Cliffside Hamlet 07"           : lambda s : s.can_reach(el['Village06Right1'], 'Region', p) or s.can_reach(el['Village06Right2'], 'Region', p) and (macros['LEDGE'](s) or macros['HORIZONTAL'](s)),
		"Cliffside Hamlet 06 To Cliffside Hamlet 12"           : lambda s : s.can_reach(el['Village06Bottom'], 'Region', p) or s.can_reach(el['Village06Left'], 'Region', p) and s.has(el['slam'], p),
		"Cliffside Hamlet 06 To Cliffside Hamlet 08"           : lambda s : s.can_reach(el['Village06Right2'], 'Region', p) or s.can_reach(el['Village06Left'], 'Region', p) and (s.has(el['hook'], p) or macros['LEDGE'](s)) or s.can_reach(el['Village06Right1'], 'Region', p),
		"Cliffside Hamlet 07 - Chain of Sorcery"               : lambda s : s.can_reach(el['Village07Left'], 'Region', p),
		"Cliffside Hamlet 07 - Stagnant Blight x10"            : lambda s : s.can_reach(el['Village07Left'], 'Region', p),
		"Cliffside Hamlet 07 - Furious Blight x10"             : lambda s : s.can_reach(el['Village07Left'], 'Region', p) and (s.has(el['hook'], p) or macros['2LEDGE'](s)),
		"Cliffside Hamlet 07 To Cliffside Hamlet 06"           : lambda s : s.can_reach(el['Village07Left'], 'Region', p) or s.can_reach(el['Village07Right'], 'Region', p),
		"Cliffside Hamlet 07 To Cliffside Hamlet 09"           : lambda s : s.can_reach(el['Village07Right'], 'Region', p) or s.can_reach(el['Village07Left'], 'Region', p) or s.can_reach(el['Village07Top'], 'Region', p),
		"Cliffside Hamlet 07 To Cliffside Hamlet 14"           : lambda s : s.can_reach(el['Village07Top'], 'Region', p) or s.can_reach(el['Village07Right'], 'Region', p) and (s.has(el['hook'], p) or macros['LEDGE'](s) and s.has(el['sinner'], p) or s.has(el['djump'], p) and (s.has(el['dodge'], p) or s.has(el['silva'], p) or s.has(el['champion'], p)) or s.has(el['dodge'], p) and (s.has(el['silva'], p) or s.has(el['champion'], p) and s.has(el['dash'], p))),
		"Cliffside Hamlet 08 - Headless Defender"              : lambda s : s.can_reach(el['Village08Left'], 'Region', p),
		"Cliffside Hamlet 08 - Amulet Fragment"                : lambda s : s.can_reach(el['Village08Left'], 'Region', p),
		"Cliffside Hamlet 08 - Stagnant Blight x10"            : lambda s : s.can_reach(el['Village08Left'], 'Region', p) and s.has(el['swim'], p),
		"Cliffside Hamlet 08 To Cliffside Hamlet 06"           : lambda s : s.can_reach(el['Village08Left'], 'Region', p) or s.can_reach(el['Village08Right'], 'Region', p),
		"Cliffside Hamlet 08 To Cliffside Hamlet 09"           : lambda s : s.can_reach(el['Village08Right'], 'Region', p) or s.can_reach(el['Village08Left'], 'Region', p),
		"Cliffside Hamlet 09 - Adherent's Letter"              : lambda s : s.can_reach(el['BridgeHead'], 'Location', p),
		"Cliffside Hamlet 09 - Hamlet Request 1"               : lambda s : s.can_reach(el['Village09Right1'], 'Region', p) or s.can_reach(el['Village09Right2'], 'Region', p) or s.can_reach(el['Village09Left1'], 'Region', p) or s.can_reach(el['Village09Left2'], 'Region', p),
		"Cliffside Hamlet 09 To Cliffside Hamlet 10"           : lambda s : s.can_reach(el['Village09Right1'], 'Region', p) or s.can_reach(el['BridgeHead'], 'Location', p),
		"Cliffside Hamlet 09 To Cliffside Hamlet 15"           : lambda s : s.can_reach(el['Village09Right2'], 'Region', p) or s.can_reach(el['BridgeHead'], 'Location', p) and s.has(el['swim'], p),
		"Cliffside Hamlet 09 To Cliffside Hamlet 07"           : lambda s : s.can_reach(el['Village09Left1'], 'Region', p) or s.can_reach(el['BridgeHead'], 'Location', p),
		"Cliffside Hamlet 09 To Cliffside Hamlet 08"           : lambda s : s.can_reach(el['Village09Left2'], 'Region', p) or s.can_reach(el['BridgeHead'], 'Location', p),
		"Cliffside Hamlet 10 - Gerrod, the Elder Warrior"      : lambda s : s.can_reach(el['Village10Left'], 'Region', p) or s.can_reach(el['Village10Right'], 'Region', p),
		"Cliffside Hamlet 10 To Cliffside Hamlet 09"           : lambda s : s.can_reach(el['Gerrod'], 'Location', p),
		"Cliffside Hamlet 10 To Cliffside Hamlet 11"           : lambda s : s.can_reach(el['Gerrod'], 'Location', p),
		"Cliffside Hamlet 11_1 - Priestess' Wish"              : lambda s : s.can_reach(el['Village111Bottom'], 'Region', p) and s.has(el['slam'], p),
		"Cliffside Hamlet 11_1 To Cliffside Hamlet 11"         : lambda s : s.can_reach(el['Village111Bottom'], 'Region', p),
		"Cliffside Hamlet 11 - Hamlet Scrawl"                  : lambda s : s.can_reach(el['Village11Left'], 'Region', p),
		"Cliffside Hamlet 11 - Hamlet Request 2"               : lambda s : s.can_reach(el['Village11Left'], 'Region', p),
		"Cliffside Hamlet 11 To Cliffside Hamlet 11_1"         : lambda s : s.can_reach(el['Village11Top'], 'Region', p) or s.can_reach(el['Village11Left'], 'Region', p),
		"Cliffside Hamlet 11 - Furious Blight x10"             : lambda s : s.can_reach(el['Village11Left'], 'Region', p),
		"Cliffside Hamlet 11 To Cliffside Hamlet 10"           : lambda s : s.can_reach(el['Village11Left'], 'Region', p) or s.can_reach(el['Village11Right'], 'Region', p) and s.has(el['claw'], p),
		"Cliffside Hamlet 11 To Ruined Castle 01"              : lambda s : s.can_reach(el['Village11Right'], 'Region', p) or s.can_reach(el['Village11Left'], 'Region', p) and s.has(el['claw'], p),
		"Cliffside Hamlet 12 - Stagnant Blight x10"            : lambda s : s.can_reach(el['Village12Left1'], 'Region', p),
		"Cliffside Hamlet 12 To Cliffside Hamlet 06"           : lambda s : s.can_reach(el['Village12Top'], 'Region', p),
		"Cliffside Hamlet 12 To Cliffside Hamlet 13"           : lambda s : s.can_reach(el['Village12Left1'], 'Region', p) or s.can_reach(el['Village12Right'], 'Region', p) and s.can_reach(el['Village12Top'], 'Region', p),
		"Cliffside Hamlet 12 To Catacombs 01"                  : lambda s : s.can_reach(el['Village12Right'], 'Region', p) or s.can_reach(el['Village12Left1'], 'Region', p) and s.can_reach(el['Village12Top'], 'Region', p) and s.has(el['swim'], p),
		"Cliffside Hamlet 12 To Cliffside Hamlet 16"           : lambda s : s.can_reach(el['Village12Left2'], 'Region', p) or s.can_reach(el['Village12Left1'], 'Region', p) and macros['CHARGE'](s),
		"Cliffside Hamlet 13 - Amulet Gem"                     : lambda s : s.can_reach(el['Village13Right'], 'Region', p) and (macros['2LEDGE'](s) or macros['LEDGE'](s) and (s.has(el['dash'], p) or macros['HORIZONTAL'](s))),
		"Cliffside Hamlet 13 - Chain of Sorcery"               : lambda s : s.can_reach(el['Village13Right'], 'Region', p),
		"Cliffside Hamlet 13 - Giant's Ring"                   : lambda s : s.can_reach(el['Village13Left'], 'Region', p) and s.has(el['swim'], p),
		"Cliffside Hamlet 13 - Stagnant Blight x10"            : lambda s : s.can_reach(el['Village13Left'], 'Region', p),
		"Cliffside Hamlet 13 To Cliffside Hamlet 03"           : lambda s : s.can_reach(el['Village13Top'], 'Region', p) or s.can_reach(el['Village13Right'], 'Region', p) and macros['LEDGE'](s),
		"Cliffside Hamlet 13 To Cliffside Hamlet 02"           : lambda s : s.can_reach(el['Village13Left'], 'Region', p) or s.can_reach(el['Village13Right'], 'Region', p),
		"Cliffside Hamlet 13 To Cliffside Hamlet 12"           : lambda s : s.can_reach(el['Village13Right'], 'Region', p) or s.can_reach(el['Village13Top'], 'Region', p),
		"Cliffside Hamlet 14 - Cliffside Hamlet Elder"         : lambda s : s.can_reach(el['Village14Bottom'], 'Region', p) and (macros['LEDGE'](s) or s.has(el['hook'], p)),
		"Cliffside Hamlet 14 - Stagnant Blight x30"            : lambda s : s.can_reach(el['Elder'], 'Location', p) and (s.has(el['slam'], p) and (s.has(el['hook'], p) or macros['LEDGE'](s) and s.has(el['sinner'], p) or s.has(el['silva'], p) and (s.has(el['djump'], p) or s.has(el['dodge'], p)) or s.has(el['champion'], p) and (s.has(el['dash'], p) or s.has(el['claw'], p)) and (s.has(el['silva'], p) or s.has(el['djump'], p)))),
		"Cliffside Hamlet 14 - Furious Blight x30"             : lambda s : s.can_reach(el['Elder'], 'Location', p) and (s.has(el['slam'], p) and (s.has(el['hook'], p) or macros['3LEDGE'](s) or macros['FULLSILVA'](s) or s.has(el['claw'], p) and macros['LEDGE'](s))),
		"Cliffside Hamlet 14 To Cliffside Hamlet 07"           : lambda s : s.can_reach(el['Village14Bottom'], 'Region', p),
		"Cliffside Hamlet 15 - Stagnant Blight x800"           : lambda s : s.can_reach(el['Village15Left'], 'Region', p) and s.has(el['swim'], p) and (s.has(el['claw'], p) and (s.has(el['sinner'], p) and (s.has(el['djump'], p) or s.has(el['champion'], p)) or s.has(el['dodge'], p) and s.has(el['silva'], p) or macros['2LEDGE'](s) and macros['HORIZONTAL'](s)) or s.has(el['hook'], p) and (macros['2LEDGE'](s) or s.has(el['claw'], p) and (macros['LEDGE'](s) or macros['HORIZONTAL'](s)))) or s.can_reach(el['Village15Right'], 'Region', p) and s.has(el['claw'], p) and s.has(el['djump'], p) and s.has(el['silva'], p),
		"Cliffside Hamlet 15 - Stagnant Blight x30"            : lambda s : s.can_reach(el['Village15Right'], 'Region', p) and s.has(el['swim'], p),
		"Cliffside Hamlet 15 - Furious Blight x10"             : lambda s : s.can_reach(el['Village15Left'], 'Region', p) and s.has(el['swim'], p),
		"Cliffside Hamlet 15 To Cliffside Hamlet 09"           : lambda s : s.can_reach(el['Village15Left'], 'Region', p) or s.can_reach(el['Village15Right'], 'Region', p) and s.has(el['swim'], p),
		"Cliffside Hamlet 15 To Twin Spires 01"                : lambda s : s.can_reach(el['Village15Right'], 'Region', p) or s.can_reach(el['Village15Left'], 'Region', p) and s.can_reach(el['Village800'], 'Location', p),
		"Cliffside Hamlet 16 - Faden's Letter"                 : lambda s : s.can_reach(el['Village16Right'], 'Region', p),
		"Cliffside Hamlet 16 - Stone Tablet Fragment"          : lambda s : s.can_reach(el['Village16Right'], 'Region', p),
		"Cliffside Hamlet 16 To Cliffside Hamlet 12"           : lambda s : s.can_reach(el['Village16Right'], 'Region', p),
		"Starting Spirit"                                      : lambda s : True,
		'Ending_A'                                             : lambda s : True,
		'Ending_B'                                             : lambda s : True,
		'Ending_C'                                             : lambda s : s.can_reach('Church_13', 'Region', p) and s.count(el['tablet'], p) >= 7,
	}

	items_rules : Dict[str, ItemRule] = {
		'Starting Spirit' : lambda item : item.player == p and item.name.startswith('Spirit.'),
	}

	return (locations_rules, items_rules)
