from typing import Dict, List


regions = {
    "Abyss_01": [
        "The Abyss 01 - Silva's Blight-Stained Note 1",
        "The Abyss 01 - Furious Blight x100",
        "The Abyss 01 To Verboten Domain 18",
        "The Abyss 01 To The Abyss 02",
    ],
    "Abyss_02": [
        "The Abyss 02 - Amulet Fragment",
        "The Abyss 02 - Silva's Blight-Stained Note 2",
        "The Abyss 02 - Fretia's Memoirs 5",
        "The Abyss 02 - White Priestess' Earrings",
        "The Abyss 02 To The Abyss 03",
        "The Abyss 02 To The Abyss 01",
    ],
    "Abyss_03": ["The Abyss 03 To The Abyss 02", "Ending_B", "Ending_C"],
    "Abyss_04": [
        "The Abyss 04 - Upper Stagnant Blight x100",
        "The Abyss 04 - Lower Stagnant Blight x100",
        "The Abyss 04 To Verboten Domain 12",
        "The Abyss 04 To The Abyss 05",
    ],
    "Abyss_05": [
        "The Abyss 05 - Stone Tablet Fragment",
        "The Abyss 05 - The Deathless Pact",
        "The Abyss 05 - Ancient Soul x2",
        "The Abyss 05 To Verboten Domain 12",
        "The Abyss 05 To The Abyss 04",
    ],
    "Castle_01": [
        "Ruined Castle 01 - Castle Town Maiden",
        "Ruined Castle 01 - Priestess' Doll",
        "Ruined Castle 01 - Decayed Crown",
        "Ruined Castle 01 - Stagnant Blight x100",
        "Ruined Castle 01 - Furious Blight x100",
        "Ruined Castle 01 To Cliffside Hamlet 11",
        "Ruined Castle 01 To Ruined Castle 02 Lower",
        "Ruined Castle 01 To Ruined Castle 02 Upper",
        "Ruined Castle 01 To Ruined Castle 10",
    ],
    "Castle_02": [
        "Ruined Castle 02 - Amulet Fragment",
        "Ruined Castle 02 - Stagnant Blight x30",
        "Ruined Castle 02 To Ruined Castle 05",
        "Ruined Castle 02 To Ruined Castle 01 Lower",
        "Ruined Castle 02 To Ruined Castle 04",
        "Ruined Castle 02 To Ruined Castle 01 Upper",
    ],
    "Castle_03": [
        "Ruined Castle 03 - Amulet Fragment",
        "Ruined Castle 03 - Stagnant Blight x30",
        "Ruined Castle 03 To Ruined Castle 05",
        "Ruined Castle 03 To Ruined Castle 11 Left",
        "Ruined Castle 03 To Ruined Castle 11 Right",
    ],
    "Castle_04": [
        "Ruined Castle 04 - Report from a Verboten Mage",
        "Ruined Castle 04 To Ruined Castle 02",
    ],
    "Castle_05": [
        "Ruined Castle 05 To Ruined Castle 02",
        "Ruined Castle 05 To Ruined Castle 06",
        "Ruined Castle 05 To Ruined Castle 08",
        "Ruined Castle 05 To Ruined Castle 03",
    ],
    "Castle_06": [
        "Ruined Castle 06 - Royal Aegis Crest",
        "Ruined Castle 06 - Stagnant Blight x30",
        "Ruined Castle 06 To Ruined Castle 12",
        "Ruined Castle 06 To Ruined Castle 07",
        "Ruined Castle 06 To Ruined Castle 05",
    ],
    "Castle_07": [
        "Ruined Castle 07 - Proof of Founding",
        "Ruined Castle 07 To Twin Spires 01",
        "Ruined Castle 07 To Ruined Castle 06",
    ],
    "Castle_08": [
        "Ruined Castle 08 - Chain of Sorcery",
        "Ruined Castle 08 - Blightwreathed Blade",
        "Ruined Castle 08 - Stagnant Blight x10",
        "Ruined Castle 08 - Upper Stagnant Blight x10",
        "Ruined Castle 08 - Lower Stagnant Blight x10",
        "Ruined Castle 08 To Ruined Castle 05",
        "Ruined Castle 08 To Ruined Castle 09",
    ],
    "Castle_09": [
        "Ruined Castle 09 - Furious Blight x30",
        "Ruined Castle 09 To Ruined Castle 11",
        "Ruined Castle 09 To Ruined Castle 08",
        "Ruined Castle 09 To Ruined Castle 10",
    ],
    "Castle_10": [
        "Ruined Castle 10 - Julius' Book",
        "Ruined Castle 10 - Stagnant Blight x30",
        "Ruined Castle 10 To Ruined Castle 09",
        "Ruined Castle 10 To Ruined Castle 01",
    ],
    "Castle_11": [
        "Ruined Castle 11 To Ruined Castle 12",
        "Ruined Castle 11 To Ruined Castle 09",
        "Ruined Castle 11 To Ruined Castle 13",
        "Ruined Castle 11 To Ruined Castle 03 Left",
        "Ruined Castle 11 To Ruined Castle 03 Right",
    ],
    "Castle_12": [
        "Ruined Castle 12 - Chain of Sorcery",
        "Ruined Castle 12 - King of the First Age's Diary 1",
        "Ruined Castle 12 - King of the First Age's Diary 2",
        "Ruined Castle 12 - Stagnant Blight x30",
        "Ruined Castle 12 To Ruined Castle 06",
        "Ruined Castle 12 To Ruined Castle 11",
        "Ruined Castle 12 To Ruined Castle 21",
    ],
    "Castle_13": [
        "Ruined Castle 13 - Amulet Gem",
        "Ruined Castle 13 To Ruined Castle 17",
        "Ruined Castle 13 To Ruined Castle 11",
        "Ruined Castle 13 To Ruined Castle 14",
    ],
    "Castle_14": [
        "Ruined Castle 14 - Amulet Fragment",
        "Ruined Castle 14 - Stagnant Blight x100",
        "Ruined Castle 14 - Furious Blight x800",
        "Ruined Castle 14 To Ruined Castle 13",
        "Ruined Castle 14 To Ruined Castle 15",
    ],
    "Castle_15": [
        "Ruined Castle 15 - Priestess' Wish",
        "Ruined Castle 15 - Priestess' Castle Memo",
        "Ruined Castle 15 To Ruined Castle 16",
        "Ruined Castle 15 To Ruined Castle 14",
    ],
    "Castle_16": [
        "Ruined Castle 16 - One-Eyed Royal Aegis",
        "Ruined Castle 16 - 2nd Stagnant Blight x10",
        "Ruined Castle 16 - 5th Stagnant Blight x10",
        "Ruined Castle 16 - 9th Stagnant Blight x10",
        "Ruined Castle 16 - 1st Stagnant Blight x10",
        "Ruined Castle 16 - 8th Stagnant Blight x10",
        "Ruined Castle 16 - 3rd Stagnant Blight x10",
        "Ruined Castle 16 - 7th Stagnant Blight x10",
        "Ruined Castle 16 - 6th Stagnant Blight x10",
        "Ruined Castle 16 - 4th Stagnant Blight x10",
        "Ruined Castle 16 - 10th Stagnant Blight x10",
        "Ruined Castle 16 To Ruined Castle 18",
        "Ruined Castle 16 To Ruined Castle 15",
    ],
    "Castle_17": [
        "Ruined Castle 17 - Stagnant Blight x30",
        "Ruined Castle 17 To Ruined Castle 13",
        "Ruined Castle 17 To Ruined Castle 18",
    ],
    "Castle_18": [
        "Ruined Castle 18 - Amulet Fragment",
        "Ruined Castle 18 - King's Note 2",
        "Ruined Castle 18 - Eldred's Ring",
        "Ruined Castle 18 - Furious Blight x100",
        "Ruined Castle 18 To Ruined Castle 19",
        "Ruined Castle 18 To Ruined Castle 17",
    ],
    "Castle_19": [
        "Ruined Castle 19 - King's Note 1",
        "Ruined Castle 19 To Ruined Castle 20",
        "Ruined Castle 19 To Ruined Castle 18",
    ],
    "Castle_20": [
        "Ruined Castle 20 - Knight Captain Julius",
        "Ruined Castle 20 To Ruined Castle 19",
    ],
    "Castle_21": [
        "Ruined Castle 21 - King of the First Age's Diary 3",
        "Ruined Castle 21 - Stone Tablet Fragment",
        "Ruined Castle 21 - Stagnant Blight x100",
        "Ruined Castle 21 To Ruined Castle 12",
    ],
    "Cave_01": [
        "Catacombs 01 - Fretia's Ring",
        "Catacombs 01 - Furious Blight x800",
        "Catacombs 01 To Catacombs 02",
        "Catacombs 01 To Cliffside Hamlet 12",
    ],
    "Cave_02": [
        "Catacombs 02 - Stagnant Blight x30",
        "Catacombs 02 - Stagnant Blight x10",
        "Catacombs 02 To Catacombs 05",
        "Catacombs 02 To Catacombs 07",
        "Catacombs 02 To Catacombs 01",
    ],
    "Cave_03": [
        "Catacombs 03 - Defense of the Twin Spires 2",
        "Catacombs 03 - Fretia's Memoirs 4",
        "Catacombs 03 To Catacombs 07",
        "Catacombs 03 To Catacombs 08",
        "Catacombs 03 To Catacombs 06",
    ],
    "Cave_04": [
        "Catacombs 04 - Amulet Fragment",
        "Catacombs 04 To Catacombs 16",
        "Catacombs 04 To Catacombs 05",
        "Catacombs 04 To Catacombs 12",
    ],
    "Cave_05": [
        "Catacombs 05 - Furious Blight x10",
        "Catacombs 05 To Catacombs 02",
        "Catacombs 05 To Catacombs 04",
        "Catacombs 05 To Catacombs 06",
        "Catacombs 05 To Catacombs 10",
    ],
    "Cave_06": [
        "Catacombs 06 - Fretia's Memoirs 2",
        "Catacombs 06 - Fretia's Memoirs 1",
        "Catacombs 06 - Kilteus' Ring",
        "Catacombs 06 To Catacombs 05",
        "Catacombs 06 To Catacombs 03",
    ],
    "Cave_07": [
        "Catacombs 07 - Elder Crypt Keeper",
        "Catacombs 07 - Stagnant Blight x10",
        "Catacombs 07 To Catacombs 02",
        "Catacombs 07 To Catacombs 03",
    ],
    "Cave_08": [
        "Catacombs 08 - Amulet Fragment",
        "Catacombs 08 To Catacombs 09",
        "Catacombs 08 To Catacombs 03",
        "Catacombs 08 To Catacombs 17",
        "Catacombs 08 To Catacombs 11",
    ],
    "Cave_09": [
        "Catacombs 09 - Amulet Fragment",
        "Catacombs 09 - Chain of Sorcery",
        "Catacombs 09 To Catacombs 10",
        "Catacombs 09 To Catacombs 08",
        "Catacombs 09 To Catacombs 21",
    ],
    "Cave_10": [
        "Catacombs 10 - Amulet Fragment",
        "Catacombs 10 - Stagnant Blight x10",
        "Catacombs 10 To Catacombs 23",
        "Catacombs 10 To Catacombs 05",
        "Catacombs 10 To Catacombs 09",
        "Catacombs 10 To Catacombs 16",
    ],
    "Cave_11": [
        "Catacombs 11 - Silva's Note 2",
        "Catacombs 11 - Stagnant Blight x10",
        "Catacombs 11 - Furious Blight x10",
        "Catacombs 11 To Catacombs 08",
        "Catacombs 11 To Catacombs 13",
        "Catacombs 11 To Catacombs 18",
    ],
    "Cave_12": ["Catacombs 12 - Stone Tablet Fragment", "Catacombs 12 To Catacombs 04"],
    "Cave_13": [
        "Catacombs 13 - Silva's Note 1",
        "Catacombs 13 - Furious Blight x30",
        "Catacombs 13 - Furious Blight x10",
        "Catacombs 13 To Catacombs 11",
        "Catacombs 13 To Catacombs 14",
        "Catacombs 13 To Catacombs 23",
        "Catacombs 13 To Catacombs 20",
    ],
    "Cave_14": [
        "Catacombs 14 - Stagnant Blight x10",
        "Catacombs 14 To Catacombs 13",
        "Catacombs 14 To Catacombs 15",
        "Catacombs 14 To Catacombs 22",
    ],
    "Cave_15": [
        "Catacombs 15 - Defense of the Twin Spires 1",
        "Catacombs 15 - Right Stagnant Blight x10",
        "Catacombs 15 - Left Stagnant Blight x10",
        "Catacombs 15 To Catacombs 14",
        "Catacombs 15 To Catacombs 16",
    ],
    "Cave_16": [
        "Catacombs 16 - The Next White Priestess",
        "Catacombs 16 - Stagnant Blight x30",
        "Catacombs 16 To Catacombs 15",
        "Catacombs 16 To Catacombs 10",
        "Catacombs 16 To Catacombs 04",
    ],
    "Cave_17": ["Catacombs 17 - Ancient Soul x2", "Catacombs 17 To Catacombs 08"],
    "Cave_18": [
        "Catacombs 18 - Holy Spring Water",
        "Catacombs 18 To Catacombs 11 Upper",
        "Catacombs 18 To Catacombs 11 Lower",
    ],
    "Cave_19": [
        "Catacombs 19 - Fallen Archer",
        "Catacombs 19 - Priestess' Wish",
        "Catacombs 19 - Chain of Sorcery",
        "Catacombs 19 To Catacombs 20",
        "Catacombs 19 To Catacombs 21",
    ],
    "Cave_20": [
        "Catacombs 20 - Amulet Fragment",
        "Catacombs 20 - The Heirloom of Land's End",
        "Catacombs 20 - Stagnant Blight x10",
        "Catacombs 20 To Catacombs 22",
        "Catacombs 20 To Catacombs 19",
        "Catacombs 20 To Catacombs 13",
    ],
    "Cave_21": [
        "Catacombs 21 - White Priestess Statue",
        "Catacombs 21 To Catacombs 09",
        "Catacombs 21 To Catacombs 19",
    ],
    "Cave_22": [
        "Catacombs 22 - Fretia's Memoirs 3",
        "Catacombs 22 To Twin Spires 02",
        "Catacombs 22 To Catacombs 14",
        "Catacombs 22 To Catacombs 20",
    ],
    "Cave_23": [
        "Catacombs 23 - Guardian Silva",
        "Catacombs 23 - Unfinished Note",
        "Catacombs 23 To Catacombs 13",
        "Catacombs 23 To Catacombs 10",
    ],
    "Church_01": [
        "White Parish 01 To White Parish 02",
        "White Parish 01 To White Parish 12",
    ],
    "Church_02": [
        "White Parish 02 - Amulet Fragment",
        "White Parish 02 - Eleine's Letter",
        "White Parish 02 To White Parish 01",
        "White Parish 02 To White Parish 10",
    ],
    "Church_03": [
        "White Parish 03 - Guardian Siegrid",
        "White Parish 03 To White Parish 05",
        "White Parish 03 To White Parish 04",
    ],
    "Church_04": [
        "White Parish 04 - Groa's Letter",
        "White Parish 04 To White Parish 03",
        "White Parish 04 To White Parish 06",
    ],
    "Church_05": [
        "White Parish 05 - Soiled Prayer Beads",
        "White Parish 05 To White Parish 11",
        "White Parish 05 To White Parish 03",
        "White Parish 05 To White Parish 09",
        "CathedralCloister",
    ],
    "Church_06": [
        "White Parish 06 To White Parish 04",
        "White Parish 06 To White Parish 07",
    ],
    "Church_07": [
        "White Parish 07 - Cliffside Hamlet Youth",
        "White Parish 07 - Chain of Sorcery",
        "White Parish 07 To White Parish 06",
        "White Parish 07 To White Parish 08",
    ],
    "Church_08": [
        "White Parish 08 - Amulet Fragment",
        "White Parish 08 - The Parish Way 2",
        "White Parish 08 To Cliffside Hamlet 01",
        "White Parish 08 To Witch's Thicket 01",
        "White Parish 08 To White Parish 07",
    ],
    "Church_09": [
        "White Parish 09 - Chief Guardian",
        "White Parish 09 - Vibrant Plume",
        "White Parish 09 - Furious Blight x30",
        "White Parish 09 To White Parish 05",
        "White Parish 09 To White Parish 01",
        "White Parish 09 To White Parish 14",
    ],
    "Church_10": [
        "White Parish 10 - On the Blighted 1",
        "White Parish 10 - On the Blighted 2",
        "White Parish 10 To White Parish 02",
        "White Parish 10 To White Parish 11",
    ],
    "Church_11": [
        "White Parish 11 - Amulet Fragment",
        "White Parish 11 - The Parish Way 1",
        "White Parish 11 To White Parish 05",
        "White Parish 11 To White Parish 10",
    ],
    "Church_12": [
        "White Parish 12 - Statue Inscription",
        "White Parish 12 To White Parish 01",
        "White Parish 12 To White Parish 13",
    ],
    "Church_13": [
        "White Parish 13 - Restoring the Aegis Curio",
        "White Parish 13 To White Parish 12",
    ],
    "Church_14": [
        "White Parish 14 - Priestess' Wish",
        "White Parish 14 - Lily's Note",
        "White Parish 14 To White Parish 09",
    ],
    "Forest_01": [
        "Witch's Thicket 01 To White Parish 08",
        "Witch's Thicket 01 To Witch's Thicket 02",
    ],
    "Forest_02": [
        "Witch's Thicket 02 - Stagnant Blight x10",
        "Witch's Thicket 02 To Witch's Thicket 01",
        "Witch's Thicket 02 To Witch's Thicket 04",
        "Witch's Thicket 02 To Witch's Thicket 03",
    ],
    "Forest_03": [
        "Witch's Thicket 03 - Amulet Fragment",
        "Witch's Thicket 03 - Chain of Sorcery",
        "Witch's Thicket 03 To Witch's Thicket 05",
        "Witch's Thicket 03 To Witch's Thicket 02",
    ],
    "Forest_04": [
        "Witch's Thicket 04 - Amulet Fragment",
        "Witch's Thicket 04 - Rusted Blue Ornament",
        "Witch's Thicket 04 - Stagnant Blight x10",
        "Witch's Thicket 04 To Witch's Thicket 05",
        "Witch's Thicket 04 To Witch's Thicket 02",
    ],
    "Forest_05": [
        "Witch's Thicket 05 - Coven Handbook",
        "Witch's Thicket 05 To Witch's Thicket 07",
        "Witch's Thicket 05 To Witch's Thicket 03",
        "Witch's Thicket 05 To Witch's Thicket 04",
    ],
    "Forest_06": [
        "Witch's Thicket 06 - Fungal Sorcerer",
        "Witch's Thicket 06 - Lover's Letter",
        "Witch's Thicket 06 - Furious Blight x10",
        "Witch's Thicket 06 To Witch's Thicket 07",
    ],
    "Forest_07": [
        "Witch's Thicket 07 - Amulet Fragment",
        "Witch's Thicket 07 - Stagnant Blight x30",
        "Witch's Thicket 07 - Stagnant Blight x10",
        "Witch's Thicket 07 To Stockade 01",
        "Witch's Thicket 07 To Witch's Thicket 08",
        "Witch's Thicket 07 To Witch's Thicket 05",
        "Witch's Thicket 07 To Witch's Thicket 06",
    ],
    "Forest_08": [
        "Witch's Thicket 08 - Manisa's Ring",
        "Witch's Thicket 08 - Cracked Familiar Stone",
        "Witch's Thicket 08 - Furious Blight x10",
        "Witch's Thicket 08 To Witch's Thicket 07",
        "Witch's Thicket 08 To Witch's Thicket 10",
    ],
    "Forest_09": [
        "Witch's Thicket 09 - Priestess' Wish",
        "Witch's Thicket 09 - Tarnished Picture",
        "Witch's Thicket 09 - Furious Blight x10",
        "Witch's Thicket 09 To Witch's Thicket 10",
        "Witch's Thicket 09 To Verboten Domain 02",
    ],
    "Forest_10": [
        "Witch's Thicket 10 - Sorcerer's Notes",
        "Witch's Thicket 10 To Witch's Thicket 11",
        "Witch's Thicket 10 To Witch's Thicket 09",
        "Witch's Thicket 10 To Witch's Thicket 08",
        "Witch's Thicket 10 To Witch's Thicket 12",
    ],
    "Forest_11": [
        "Witch's Thicket 11 - Floral Sorceress",
        "Witch's Thicket 11 - Amulet Fragment",
        "Witch's Thicket 11 - Chain of Sorcery",
        "Witch's Thicket 11 - Ruined Witch's Book",
        "Witch's Thicket 11 - Stagnant Blight x30",
        "Witch's Thicket 11 - Stagnant Blight x10",
        "Witch's Thicket 11 To Witch's Thicket 10",
        "Witch's Thicket 11 To Witch's Thicket 14",
    ],
    "Forest_12": [
        "Witch's Thicket 12 - Amulet Fragment",
        "Witch's Thicket 12 - Stagnant Blight x10",
        "Witch's Thicket 12 To Witch's Thicket 10",
        "Witch's Thicket 12 To Witch's Thicket 13",
        "Witch's Thicket 12 To Witch's Thicket 17",
    ],
    "Forest_13": [
        "Witch's Thicket 13 - Stagnant Blight x10",
        "Witch's Thicket 13 To Witch's Thicket 12",
        "Witch's Thicket 13 To Witch's Thicket 14",
        "Witch's Thicket 13 To Witch's Thicket 16",
    ],
    "Forest_14": [
        "Witch's Thicket 14 - The Parish Way 3",
        "Witch's Thicket 14 To Witch's Thicket 15",
        "Witch's Thicket 14 To Witch's Thicket 13",
        "Witch's Thicket 14 To Witch's Thicket 11",
    ],
    "Forest_15": [
        "Witch's Thicket 15 - Dark Witch Eleine",
        "Witch's Thicket 15 To Witch's Thicket 14",
    ],
    "Forest_16": [
        "Witch's Thicket 16 - Eleine's Diary 3",
        "Witch's Thicket 16 - Stone Tablet Fragment",
        "Witch's Thicket 16 - Stagnant Blight x800",
        "Witch's Thicket 16 To Witch's Thicket 13",
    ],
    "Forest_17": [
        "Witch's Thicket 17 - Amulet Gem",
        "Witch's Thicket 17 - Eleine's Diary 2",
        "Witch's Thicket 17 - Spellbound Anklet",
        "Witch's Thicket 17 - Eleine's Diary 1",
        "Witch's Thicket 17 To Witch's Thicket 12",
    ],
    "Fort_01": [
        "Twin Spires 01 - Fallen Sentinel",
        "Twin Spires 01 - Furious Blight x30",
        "Twin Spires 01 To Twin Spires 03",
        "Twin Spires 01 To Cliffside Hamlet 15",
        "Twin Spires 01 To Ruined Castle 07",
    ],
    "Fort_02": [
        "Twin Spires 02 - Stagnant Blight x10",
        "Twin Spires 02 - Furious Blight x10",
        "Twin Spires 02 To Twin Spires 03",
        "Twin Spires 02 To Catacombs 22",
    ],
    "Fort_03": [
        "Twin Spires 03 - Bloodied Note 1",
        "Twin Spires 03 To Twin Spires 04",
        "Twin Spires 03 To Twin Spires 01",
        "Twin Spires 03 To Twin Spires 02",
        "Twin Spires 03 To Twin Spires 05",
    ],
    "Fort_04": [
        "Twin Spires 04 - Stagnant Blight x100",
        "Twin Spires 04 To Twin Spires 05",
        "Twin Spires 04 To Twin Spires 03",
    ],
    "Fort_05": [
        "Twin Spires 05 - Amulet Fragment",
        "Twin Spires 05 - Chain of Sorcery",
        "Twin Spires 05 - Stagnant Blight x10",
        "Twin Spires 05 To Twin Spires 04",
        "Twin Spires 05 To Twin Spires 06",
        "Twin Spires 05 To Twin Spires 03",
        "Twin Spires 05 To Twin Spires 15",
    ],
    "Fort_06": [
        "Twin Spires 06 - Stagnant Blight x30",
        "Twin Spires 06 To Twin Spires 05",
        "Twin Spires 06 To Twin Spires 07",
        "Twin Spires 06 To Twin Spires 10",
    ],
    "Fort_07": [
        "Twin Spires 07 - Stagnant Blight x10",
        "Twin Spires 07 To Twin Spires 09 Left",
        "Twin Spires 07 To Twin Spires 08",
        "Twin Spires 07 To Twin Spires 06",
        "Twin Spires 07 To Twin Spires 11",
        "Twin Spires 07 To Twin Spires 09 Right",
    ],
    "Fort_08": [
        "Twin Spires 08 - Hoenir's Diary 3",
        "Twin Spires 08 To Twin Spires 07",
    ],
    "Fort_09": [
        "Twin Spires 09 - Note on the Castle Wall",
        "Twin Spires 09 - Snowdrop Bracelet",
        "Twin Spires 09 - Stagnant Blight x10",
        "Twin Spires 09 - Furious Blight x30",
        "Twin Spires 09 To Hinterlands 03",
        "Twin Spires 09 To Twin Spires 10",
        "Twin Spires 09 To Twin Spires 07 Left",
        "Twin Spires 09 To Twin Spires 07 Right",
    ],
    "Fort_10": [
        "Twin Spires 10 - Amulet Fragment",
        "Twin Spires 10 - Bloodied Note 2",
        "Twin Spires 10 To Twin Spires 09",
        "Twin Spires 10 To Twin Spires 06",
    ],
    "Fort_11": [
        "Twin Spires 11 - Ricorus' Ring",
        "Twin Spires 11 - Stagnant Blight x30",
        "Twin Spires 11 To Twin Spires 07",
        "Twin Spires 11 To Twin Spires 12",
        "Twin Spires 11 To Twin Spires 13 Left",
        "Twin Spires 11 To Twin Spires 13 Right",
    ],
    "Fort_12": [
        "Twin Spires 12 - Forsaken Fellwyrm",
        "Twin Spires 12 - Amulet Fragment",
        "Twin Spires 12 To Twin Spires 11",
        "Twin Spires 12 To Twin Spires 14",
        "Twin Spires 12 To Twin Spires 16",
    ],
    "Fort_13": [
        "Twin Spires 13 - Amulet Fragment",
        "Twin Spires 13 - Chain of Sorcery",
        "Twin Spires 13 To Twin Spires 11 Left",
        "Twin Spires 13 To Twin Spires 11 Right",
        "Twin Spires 13 To Twin Spires 14",
        "Twin Spires 13 To Twin Spires 19",
    ],
    "Fort_14": [
        "Twin Spires 14 - Writing on the Wall",
        "Twin Spires 14 - Stone Tablet Fragment",
        "Twin Spires 14 - Stagnant Blight x100",
        "Twin Spires 14 - Stagnant Blight x800",
        "Twin Spires 14 - Furious Blight x10",
        "Twin Spires 14 To Twin Spires 15",
        "Twin Spires 14 To Twin Spires 13",
        "Twin Spires 14 To Twin Spires 12",
    ],
    "Fort_15": [
        "Twin Spires 15 - Bloodied Note 3",
        "Twin Spires 15 - Immortal's Crest",
        "Twin Spires 15 - Stagnant Blight x30",
        "Twin Spires 15 - Stagnant Blight x10",
        "Twin Spires 15 To Twin Spires 16 Upper",
        "Twin Spires 15 To Twin Spires 14",
        "Twin Spires 15 To Twin Spires 05",
        "Twin Spires 15 To Twin Spires 17",
        "Twin Spires 15 To Twin Spires 16 Lower",
    ],
    "Fort_16": [
        "Twin Spires 16 - Monument Engraving",
        "Twin Spires 16 To Twin Spires 15 Upper",
        "MonumentOfTheWindStart",
        "Twin Spires 16 To Twin Spires 18",
        "Twin Spires 16 To Twin Spires 15 Lower",
        "Twin Spires 16 To Twin Spires 12",
    ],
    "Fort_17": [
        "Twin Spires 17 - Amulet Fragment",
        "Twin Spires 17 To Twin Spires 15",
        "Twin Spires 17 To Twin Spires 18",
    ],
    "Fort_18": [
        "Twin Spires 18 - Amulet Gem",
        "Twin Spires 18 - Chain of Sorcery",
        "Twin Spires 18 To Twin Spires 17",
        "Twin Spires 18 To Twin Spires 19",
        "Twin Spires 18 To Twin Spires 16",
    ],
    "Fort_19": [
        "Twin Spires 19 - Ancient Dragon Claw",
        "Twin Spires 19 - Furious Blight x30",
        "Twin Spires 19 - Furious Blight x10",
        "Twin Spires 19 To Twin Spires 18",
        "Twin Spires 19 To Twin Spires 20",
        "Twin Spires 19 To Twin Spires 13",
    ],
    "Fort_20": [
        "Twin Spires 20 To Twin Spires 19",
        "Twin Spires 20 To Twin Spires 21",
        "MourningHall",
    ],
    "Fort_21": [
        "Twin Spires 21 - Ulv, the Mad Knight",
        "Twin Spires 21 - Priestess' Wish",
        "Twin Spires 21 - White Priestess' Bastion Letter",
        "Twin Spires 21 To Twin Spires 20",
    ],
    "Oubliette_01": [
        "Stockade 01 - Amulet Fragment",
        "Stockade 01 - Stagnant Blight x10",
        "Stockade 01 To Witch's Thicket 07",
        "Stockade 01 To Stockade 02",
    ],
    "Oubliette_02": [
        "Stockade 02 - Executioner's Vow",
        "Stockade 02 To Stockade 01",
        "Stockade 02 To Stockade 05",
        "Stockade 02 To Stockade 04",
    ],
    "Oubliette_03": [
        "Stockade 03 - Right Stagnant Blight x10",
        "Stockade 03 - Left Stagnant Blight x10",
        "Stockade 03 - Stagnant Blight x800",
        "Stockade 03 To Stockade 04",
        "Stockade 03 To Stockade 10",
        "Stockade 03 To Stockade 05",
    ],
    "Oubliette_04": [
        "Stockade 04 - Stagnant Blight x30",
        "Stockade 04 - Furious Blight x10",
        "Stockade 04 To Stockade 03",
        "Stockade 04 To Stockade 02",
    ],
    "Oubliette_05": [
        "Stockade 05 - Amulet Gem",
        "Stockade 05 - Stagnant Blight x100",
        "Stockade 05 - Stagnant Blight x30",
        "Stockade 05 To Stockade 05_2 Left",
        "Stockade 05 To Stockade 05_3",
        "Stockade 05 To Stockade 07_2",
        "Stockade 05 To Stockade 05_1",
        "Stockade 05 To Stockade 07_1",
        "Stockade 05 To Stockade 02",
        "Stockade 05 To Stockade 06",
        "Stockade 05 To Stockade 03",
        "Stockade 05 To Stockade 05_2 Right",
    ],
    "Oubliette_05_1": [
        "Stockade 05_1 - Furious Blight x10",
        "Stockade 05_1 To Stockade 05",
    ],
    "Oubliette_05_2": [
        "Stockade 05_2 - Stagnant Blight x10",
        "Stockade 05_2 To Stockade 05 Left",
        "Stockade 05_2 To Stockade 05 Right",
    ],
    "Oubliette_05_3": [
        "Stockade 05_3 - Chain of Sorcery",
        "Stockade 05_3 To Stockade 05",
    ],
    "Oubliette_06": [
        "Stockade 06 - Amulet Fragment",
        "Stockade 06 - Chain of Sorcery",
        "Stockade 06 - Stagnant Blight x10",
        "Stockade 06 To Stockade 05",
        "Stockade 06 To Stockade 07",
        "Stockade 06 To Stockade 10",
    ],
    "Oubliette_06_1": [
        "Stockade 06_1 - Hoenir's Diary 1",
        "Stockade 06_1 To Stockade 07",
    ],
    "Oubliette_06_2": [
        "Stockade 06_2 - Executioner's Gloves",
        "Stockade 06_2 To Stockade 07",
    ],
    "Oubliette_06_3": [
        "Stockade 06_3 - Chain of Sorcery",
        "Stockade 06_3 To Stockade 07",
    ],
    "Oubliette_06_4": [
        "Stockade 06_4 - Stone Tablet Fragment",
        "Stockade 06_4 To Stockade 07",
    ],
    "Oubliette_07": [
        "Stockade 07 To Stockade 06_1",
        "Stockade 07 To Stockade 06_3",
        "Stockade 07 To Stockade 06_2",
        "Stockade 07 To Stockade 06_4",
        "Stockade 07 To Stockade 06",
        "Stockade 07 To Stockade 13",
        "Stockade 07 To Stockade 09",
    ],
    "Oubliette_07_1": [
        "Stockade 07_1 - Forbidden Text Scrap",
        "Stockade 07_1 To Stockade 05",
    ],
    "Oubliette_07_2": [
        "Stockade 07_2 - Hidden Test Subject",
        "Stockade 07_2 To Stockade 05",
    ],
    "Oubliette_08": [
        "Stockade 08 - Lower Furious Blight x30",
        "Stockade 08 - Upper Furious Blight x30",
        "Stockade 08 To Stockade 11",
        "Stockade 08 To Stockade 09",
        "Stockade 08 To Stockade 13",
    ],
    "Oubliette_09": [
        "Stockade 09 - Right Amulet Fragment",
        "Stockade 09 - Left Amulet Fragment",
        "Stockade 09 - Stagnant Blight x30",
        "Stockade 09 To Stockade 08",
        "Stockade 09 To Stockade 10",
        "Stockade 09 To Stockade 07",
    ],
    "Oubliette_10": [
        "Stockade 10 - Executioner's Missive",
        "Stockade 10 To Stockade 09",
        "Stockade 10 To Stockade 03",
        "Stockade 10 To Stockade 17",
        "Stockade 10 To Stockade 06",
    ],
    "Oubliette_11": [
        "Stockade 11 - Furious Blight x10",
        "Stockade 11 To Stockade 12",
        "Stockade 11 To Stockade 08",
        "Stockade 11 To Stockade 14",
        "Stockade 11 To Stockade 13",
        "Stockade 11 To Stockade 13_2",
        "Stockade 11 To Stockade 13_1",
    ],
    "Oubliette_12": ["Stockade 12 - Dark Executioner", "Stockade 12 To Stockade 11"],
    "Oubliette_13": [
        "Stockade 13 - Chain of Sorcery",
        "Stockade 13 - Slip of Paper",
        "Stockade 13 - Stagnant Blight x30",
        "Stockade 13 - Stagnant Blight x100",
        "Stockade 13 To Stockade 08",
        "Stockade 13 To Stockade 11",
        "Stockade 13 To Stockade 07",
    ],
    "Oubliette_13_1": ["Stockade 13_1 - Aura's Ring", "Stockade 13_1 To Stockade 11"],
    "Oubliette_13_2": [
        "Stockade 13_2 - Ancient Soul x1",
        "Stockade 13_2 To Stockade 11",
    ],
    "Oubliette_14": [
        "Stockade 14 - Hoenir's Diary 2",
        "Stockade 14 To Stockade 11",
        "Stockade 14 To Stockade 15",
    ],
    "Oubliette_15": [
        "Stockade 15 - Hoenir, Keeper of the Abyss",
        "Stockade 15 To Stockade 14",
        "Stockade 15 To Stockade 16",
    ],
    "Oubliette_16": [
        "Stockade 16 - Priestess' Wish",
        "Stockade 16 - Stagnant Blight x10",
        "Stockade 16 To Stockade 15",
        "Stockade 16 To Hinterlands 01",
    ],
    "Oubliette_17": ["Stockade 17 To Stockade 10", "Stockade 17 To Verboten Domain 06"],
    "Outside_01": [
        "Hinterlands 01 To Hinterlands 02",
        "Hinterlands 01 To Hinterlands 03",
        "Hinterlands 01 To Stockade 16",
    ],
    "Outside_02": ["Hinterlands 02 To Hinterlands 01", "Ending_A"],
    "Outside_03": [
        "Hinterlands 03 - King of the First Age's Torn Note 1",
        "Hinterlands 03 - King of the First Age's Torn Note 2",
        "Hinterlands 03 - Nymphilia's Ring",
        "Hinterlands 03 - Stagnant Blight x100",
        "Hinterlands 03 To Hinterlands 01",
        "Hinterlands 03 To Twin Spires 09",
    ],
    "Swamp_01": [
        "Verboten Domain 01 - Faden's Archives 3",
        "Verboten Domain 01 To Verboten Domain 03",
        "Verboten Domain 01 To Verboten Domain 02",
    ],
    "Swamp_02": [
        "Verboten Domain 02 - Furious Blight x10",
        "Verboten Domain 02 - Furious Blight x30",
        "Verboten Domain 02 To Verboten Domain 01",
        "Verboten Domain 02 To Witch's Thicket 09",
    ],
    "Swamp_03": [
        "Verboten Domain 03 - Amulet Fragment",
        "Verboten Domain 03 - Stagnant Blight x30",
        "Verboten Domain 03 To Verboten Domain 09",
        "Verboten Domain 03 To Verboten Domain 01",
        "Verboten Domain 03 To Verboten Domain 04",
        "Verboten Domain 03 To Verboten Domain 07",
    ],
    "Swamp_04": [
        "Verboten Domain 04 - Verboten Champion",
        "Verboten Domain 04 - Chain of Sorcery",
        "Verboten Domain 04 To Verboten Domain 05",
        "Verboten Domain 04 To Verboten Domain 3R",
    ],
    "Swamp_05": [
        "Verboten Domain 05 - Furious Blight x100",
        "Verboten Domain 05 - Stagnant Blight x30",
        "Verboten Domain 05 To Verboten Domain 04",
        "Verboten Domain 05 To Verboten Domain 06",
        "Verboten Domain 05 To Verboten Domain 07",
        "Verboten Domain 05 To Verboten Domain 09",
    ],
    "Swamp_06": [
        "Verboten Domain 06 - Verboten Domain Notice",
        "Verboten Domain 06 - Heretic's Mask",
        "Verboten Domain 06 - Stagnant Blight x30",
        "Verboten Domain 06 To Verboten Domain 05",
        "Verboten Domain 06 To Stockade 17",
    ],
    "Swamp_07": [
        "Verboten Domain 07 - Amulet Fragment",
        "Verboten Domain 07 - Calivia's Ring",
        "Verboten Domain 07 To Verboten Domain 16",
        "Verboten Domain 07 To Verboten Domain 05",
        "Verboten Domain 07 To Verboten Domain 08",
        "Verboten Domain 07 To Verboten Domain 3B",
    ],
    "Swamp_08": [
        "Verboten Domain 08 - Amulet Gem",
        "Verboten Domain 08 - Stagnant Blight x100",
        "Verboten Domain 08 - Furious Blight x100",
        "Verboten Domain 08 To Verboten Domain 07",
        "Verboten Domain 08 To Verboten Domain 15",
        "Verboten Domain 08 To Verboten Domain 14",
    ],
    "Swamp_09": [
        "Verboten Domain 09 - Weathered Necklace",
        "Verboten Domain 09 - Stagnant Blight x30",
        "Verboten Domain 09 To Verboten Domain 13 Left",
        "Verboten Domain 09 To Verboten Domain 03",
        "Verboten Domain 09 To Verboten Domain 13 Right",
        "Verboten Domain 09 To Verboten Domain 05",
    ],
    "Swamp_10": [
        "Verboten Domain 10 - Faden's Archives 4",
        "Verboten Domain 10 - Stagnant Blight x30",
        "Verboten Domain 10 To Verboten Domain 13",
    ],
    "Swamp_11": [
        "Verboten Domain 11 - Amulet Fragment",
        "Verboten Domain 11 - Blighted Appendage",
        "Verboten Domain 11 To Verboten Domain 15",
        "Verboten Domain 11 To Verboten Domain 14",
    ],
    "Swamp_12": [
        "Verboten Domain 12 - Priestess' Wish",
        "Verboten Domain 12 - Faden's Archives 2",
        "Verboten Domain 12 To Verboten Domain 15",
        "Verboten Domain 12 To The Abyss 04",
    ],
    "Swamp_13": [
        "Verboten Domain 13 - Amulet Fragment",
        "Verboten Domain 13 - Stagnant Blight x30",
        "Verboten Domain 13 - Furious Blight x30",
        "Verboten Domain 13 To Verboten Domain 10",
        "Verboten Domain 13 To Verboten Domain 09 Left",
        "Verboten Domain 13 To Verboten Domain 09 Right",
        "Verboten Domain 13 To Verboten Domain 14",
    ],
    "Swamp_14": [
        "Verboten Domain 14 - Chain of Sorcery",
        "Verboten Domain 14 - Stagnant Blight x100",
        "Verboten Domain 14 To Verboten Domain 13",
        "Verboten Domain 14 To Verboten Domain 11",
        "Verboten Domain 14 To Verboten Domain 08",
    ],
    "Swamp_15": [
        "Verboten Domain 15 - Incompetent Sinner",
        "Verboten Domain 15 - Stagnant Blight x30",
        "Verboten Domain 15 To Verboten Domain 11",
        "Verboten Domain 15 To Verboten Domain 08",
        "Verboten Domain 15 To Verboten Domain 12",
    ],
    "Swamp_16": [
        "Verboten Domain 16 - Faden's Archives 1",
        "Verboten Domain 16 To Verboten Domain 07",
        "Verboten Domain 16 To Verboten Domain 17",
    ],
    "Swamp_17": [
        "Verboten Domain 17 To Verboten Domain 18",
        "Verboten Domain 17 To Verboten Domain 16",
    ],
    "Swamp_18": [
        "Verboten Domain 18 - Miriel's Blighted Letter",
        "Verboten Domain 18 - Faden's Archives 5",
        "Verboten Domain 18 - Faden, the Heretic",
        "Verboten Domain 18 - Stagnant Blight x800",
        "Verboten Domain 18 To The Abyss 01",
        "Verboten Domain 18 To Verboten Domain 17",
    ],
    "Village_01": [
        "Cliffside Hamlet 01 To Cliffside Hamlet 02",
        "Cliffside Hamlet 01 To White Parish 08",
    ],
    "Village_02": [
        "Cliffside Hamlet 02 - Amulet Fragment",
        "Cliffside Hamlet 02 - Left Stagnant Blight x10",
        "Cliffside Hamlet 02 - Right Stagnant Blight x10",
        "Cliffside Hamlet 02 To Cliffside Hamlet 03",
        "Cliffside Hamlet 02 To Cliffside Hamlet 01",
        "Cliffside Hamlet 02 To Cliffside Hamlet 13",
    ],
    "Village_03": [
        "Cliffside Hamlet 03 - Amulet Fragment",
        "Cliffside Hamlet 03 - Broken Music Box",
        "Cliffside Hamlet 03 - Stagnant Blight x10",
        "Cliffside Hamlet 03 - Furious Blight x10",
        "Cliffside Hamlet 03 To Cliffside Hamlet 02",
        "Cliffside Hamlet 03 To Cliffside Hamlet 05",
        "Cliffside Hamlet 03 To Cliffside Hamlet 13",
    ],
    "Village_04": [
        "Cliffside Hamlet 04 - Amulet Fragment",
        "Cliffside Hamlet 04 - Bloodstained Ribbon",
        "Cliffside Hamlet 04 - Stagnant Blight x10",
        "Cliffside Hamlet 04 To Cliffside Hamlet 04",
        "Cliffside Hamlet 04 To Cliffside Hamlet 05",
    ],
    "Village_04_1": [
        "Cliffside Hamlet 04_1 - Western Merchant",
        "Cliffside Hamlet 04_1 To Cliffside Hamlet 04",
    ],
    "Village_05": [
        "Cliffside Hamlet 05 - True Believer's Note",
        "Cliffside Hamlet 05 To Cliffside Hamlet 04",
        "Cliffside Hamlet 05 To Cliffside Hamlet 03",
        "Cliffside Hamlet 05 To Cliffside Hamlet 06",
    ],
    "Village_06": [
        "Cliffside Hamlet 06 - Amulet Fragment",
        "Cliffside Hamlet 06 - Upper Stagnant Blight x10",
        "Cliffside Hamlet 06 - Left Stagnant Blight x10",
        "Cliffside Hamlet 06 - Right Stagnant Blight x10",
        "Cliffside Hamlet 06 - Upper Furious Blight x10",
        "Cliffside Hamlet 06 - Lower Furious Blight x10",
        "Cliffside Hamlet 06 To Cliffside Hamlet 05",
        "Cliffside Hamlet 06 To Cliffside Hamlet 07",
        "Cliffside Hamlet 06 To Cliffside Hamlet 12",
        "Cliffside Hamlet 06 To Cliffside Hamlet 08",
    ],
    "Village_07": [
        "Cliffside Hamlet 07 - Chain of Sorcery",
        "Cliffside Hamlet 07 - Stagnant Blight x10",
        "Cliffside Hamlet 07 - Furious Blight x10",
        "Cliffside Hamlet 07 To Cliffside Hamlet 06",
        "Cliffside Hamlet 07 To Cliffside Hamlet 09",
        "Cliffside Hamlet 07 To Cliffside Hamlet 14",
    ],
    "Village_08": [
        "Cliffside Hamlet 08 - Headless Defender",
        "Cliffside Hamlet 08 - Amulet Fragment",
        "Cliffside Hamlet 08 - Stagnant Blight x10",
        "Cliffside Hamlet 08 To Cliffside Hamlet 06",
        "Cliffside Hamlet 08 To Cliffside Hamlet 09",
    ],
    "Village_09": [
        "Cliffside Hamlet 09 - Adherent's Letter",
        "Cliffside Hamlet 09 - Hamlet Request 1",
        "Cliffside Hamlet 09 To Cliffside Hamlet 10",
        "Cliffside Hamlet 09 To Cliffside Hamlet 15",
        "Cliffside Hamlet 09 To Cliffside Hamlet 07",
        "Cliffside Hamlet 09 To Cliffside Hamlet 08",
    ],
    "Village_10": [
        "Cliffside Hamlet 10 - Gerrod, the Elder Warrior",
        "Cliffside Hamlet 10 To Cliffside Hamlet 09",
        "Cliffside Hamlet 10 To Cliffside Hamlet 11",
    ],
    "Village_11": [
        "Cliffside Hamlet 11 - Hamlet Scrawl",
        "Cliffside Hamlet 11 - Hamlet Request 2",
        "Cliffside Hamlet 11 - Furious Blight x10",
        "Cliffside Hamlet 11 To Cliffside Hamlet 11_1",
        "Cliffside Hamlet 11 To Cliffside Hamlet 10",
        "Cliffside Hamlet 11 To Ruined Castle 01",
    ],
    "Village_11_1": [
        "Cliffside Hamlet 11_1 - Priestess' Wish",
        "Cliffside Hamlet 11_1 To Cliffside Hamlet 11",
    ],
    "Village_12": [
        "Cliffside Hamlet 12 - Stagnant Blight x10",
        "Cliffside Hamlet 12 To Cliffside Hamlet 06",
        "Cliffside Hamlet 12 To Cliffside Hamlet 13",
        "Cliffside Hamlet 12 To Catacombs 01",
        "Cliffside Hamlet 12 To Cliffside Hamlet 16",
    ],
    "Village_13": [
        "Cliffside Hamlet 13 - Amulet Gem",
        "Cliffside Hamlet 13 - Chain of Sorcery",
        "Cliffside Hamlet 13 - Giant's Ring",
        "Cliffside Hamlet 13 - Stagnant Blight x10",
        "Cliffside Hamlet 13 To Cliffside Hamlet 03",
        "Cliffside Hamlet 13 To Cliffside Hamlet 02",
        "Cliffside Hamlet 13 To Cliffside Hamlet 12",
    ],
    "Village_14": [
        "Cliffside Hamlet 14 - Cliffside Hamlet Elder",
        "Cliffside Hamlet 14 - Stagnant Blight x30",
        "Cliffside Hamlet 14 - Furious Blight x30",
        "Cliffside Hamlet 14 To Cliffside Hamlet 07",
    ],
    "Village_15": [
        "Cliffside Hamlet 15 - Stagnant Blight x800",
        "Cliffside Hamlet 15 - Stagnant Blight x30",
        "Cliffside Hamlet 15 - Furious Blight x10",
        "Cliffside Hamlet 15 To Cliffside Hamlet 09",
        "Cliffside Hamlet 15 To Twin Spires 01",
    ],
    "Village_16": [
        "Cliffside Hamlet 16 - Faden's Letter",
        "Cliffside Hamlet 16 - Stone Tablet Fragment",
        "Cliffside Hamlet 16 To Cliffside Hamlet 12",
    ],
}

entrances = {
    "Map.map_abyss_01.2": "Abyss_01",
    "Map.map_abyss_01.S18": "Abyss_01",
    "Map.map_abyss_02.1": "Abyss_02",
    "Map.map_abyss_02.3": "Abyss_02",
    "Map.map_abyss_03.2": "Abyss_03",
    "Map.map_abyss_04.2": "Abyss_04",
    "Map.map_abyss_04.5": "Abyss_04",
    "Map.map_abyss_05.4": "Abyss_05",
    "Map.map_castle_01.0": "Castle_01",
    "Map.map_castle_01.10": "Castle_01",
    "Map.map_castle_01.2": "Castle_01",
    "Map.map_castle_01.2B": "Castle_01",
    "Map.map_castle_02.1": "Castle_02",
    "Map.map_castle_02.1B": "Castle_02",
    "Map.map_castle_02.4": "Castle_02",
    "Map.map_castle_02.5": "Castle_02",
    "Map.map_castle_03.11A": "Castle_03",
    "Map.map_castle_03.11B": "Castle_03",
    "Map.map_castle_03.5": "Castle_03",
    "Map.map_castle_04.2": "Castle_04",
    "Map.map_castle_05.2": "Castle_05",
    "Map.map_castle_05.3": "Castle_05",
    "Map.map_castle_05.6": "Castle_05",
    "Map.map_castle_05.8": "Castle_05",
    "Map.map_castle_06.12": "Castle_06",
    "Map.map_castle_06.5": "Castle_06",
    "Map.map_castle_06.7": "Castle_06",
    "Map.map_castle_07.6": "Castle_07",
    "Map.map_castle_07.F1": "Castle_07",
    "Map.map_castle_08.5": "Castle_08",
    "Map.map_castle_08.9": "Castle_08",
    "Map.map_castle_09.10": "Castle_09",
    "Map.map_castle_09.11": "Castle_09",
    "Map.map_castle_09.8": "Castle_09",
    "Map.map_castle_10.1": "Castle_10",
    "Map.map_castle_10.9": "Castle_10",
    "Map.map_castle_11.12": "Castle_11",
    "Map.map_castle_11.13": "Castle_11",
    "Map.map_castle_11.3A": "Castle_11",
    "Map.map_castle_11.3B": "Castle_11",
    "Map.map_castle_11.9": "Castle_11",
    "Map.map_castle_12.11": "Castle_12",
    "Map.map_castle_12.21": "Castle_12",
    "Map.map_castle_12.6": "Castle_12",
    "Map.map_castle_13.11": "Castle_13",
    "Map.map_castle_13.14": "Castle_13",
    "Map.map_castle_13.17": "Castle_13",
    "Map.map_castle_14.13": "Castle_14",
    "Map.map_castle_14.15": "Castle_14",
    "Map.map_castle_15.14": "Castle_15",
    "Map.map_castle_15.16": "Castle_15",
    "Map.map_castle_16.15": "Castle_16",
    "Map.map_castle_17.13": "Castle_17",
    "Map.map_castle_17.18": "Castle_17",
    "Map.map_castle_18.16": "Castle_18",
    "Map.map_castle_18.17": "Castle_18",
    "Map.map_castle_18.19": "Castle_18",
    "Map.map_castle_19.18": "Castle_19",
    "Map.map_castle_19.20": "Castle_19",
    "Map.map_castle_20.19": "Castle_20",
    "Map.map_castle_21.12": "Castle_21",
    "Map.map_cave_01.2": "Cave_01",
    "Map.map_cave_01.V12": "Cave_01",
    "Map.map_cave_02.1": "Cave_02",
    "Map.map_cave_02.5": "Cave_02",
    "Map.map_cave_02.7": "Cave_02",
    "Map.map_cave_03.6": "Cave_03",
    "Map.map_cave_03.7": "Cave_03",
    "Map.map_cave_03.8": "Cave_03",
    "Map.map_cave_04.12": "Cave_04",
    "Map.map_cave_04.16": "Cave_04",
    "Map.map_cave_04.5": "Cave_04",
    "Map.map_cave_05.10": "Cave_05",
    "Map.map_cave_05.2": "Cave_05",
    "Map.map_cave_05.4": "Cave_05",
    "Map.map_cave_05.6": "Cave_05",
    "Map.map_cave_06.3": "Cave_06",
    "Map.map_cave_06.5": "Cave_06",
    "Map.map_cave_07.2": "Cave_07",
    "Map.map_cave_07.3": "Cave_07",
    "Map.map_cave_08.11": "Cave_08",
    "Map.map_cave_08.17": "Cave_08",
    "Map.map_cave_08.3": "Cave_08",
    "Map.map_cave_08.9": "Cave_08",
    "Map.map_cave_09.10": "Cave_09",
    "Map.map_cave_09.21": "Cave_09",
    "Map.map_cave_09.8": "Cave_09",
    "Map.map_cave_10.16": "Cave_10",
    "Map.map_cave_10.23": "Cave_10",
    "Map.map_cave_10.5": "Cave_10",
    "Map.map_cave_10.9": "Cave_10",
    "Map.map_cave_11.13": "Cave_11",
    "Map.map_cave_11.18": "Cave_11",
    "Map.map_cave_11.18B": "Cave_11",
    "Map.map_cave_11.8": "Cave_11",
    "Map.map_cave_12.4": "Cave_12",
    "Map.map_cave_13.11": "Cave_13",
    "Map.map_cave_13.14": "Cave_13",
    "Map.map_cave_13.20": "Cave_13",
    "Map.map_cave_13.23": "Cave_13",
    "Map.map_cave_14.13": "Cave_14",
    "Map.map_cave_14.15": "Cave_14",
    "Map.map_cave_14.22": "Cave_14",
    "Map.map_cave_15.14": "Cave_15",
    "Map.map_cave_15.16": "Cave_15",
    "Map.map_cave_16.10": "Cave_16",
    "Map.map_cave_16.15": "Cave_16",
    "Map.map_cave_16.4": "Cave_16",
    "Map.map_cave_17.8": "Cave_17",
    "Map.map_cave_18.11": "Cave_18",
    "Map.map_cave_19.20": "Cave_19",
    "Map.map_cave_19.21": "Cave_19",
    "Map.map_cave_20.13": "Cave_20",
    "Map.map_cave_20.19": "Cave_20",
    "Map.map_cave_20.22": "Cave_20",
    "Map.map_cave_21.19": "Cave_21",
    "Map.map_cave_21.9": "Cave_21",
    "Map.map_cave_22.14": "Cave_22",
    "Map.map_cave_22.20": "Cave_22",
    "Map.map_cave_22.F2": "Cave_22",
    "Map.map_cave_23.10": "Cave_23",
    "Map.map_cave_23.13": "Cave_23",
    "Map.map_church_01.1": "Church_01",
    "Map.map_church_01.12": "Church_01",
    "Map.map_church_01.2": "Church_01",
    "Map.map_church_02.0": "Church_02",
    "Map.map_church_02.10": "Church_02",
    "Map.map_church_03.0": "Church_03",
    "Map.map_church_03.1": "Church_03",
    "Map.map_church_04.0": "Church_04",
    "Map.map_church_04.1": "Church_04",
    "Map.map_church_05.1": "Church_05",
    "Map.map_church_05.11": "Church_05",
    "Map.map_church_05.9": "Church_05",
    "Map.map_church_06.0": "Church_06",
    "Map.map_church_06.1": "Church_06",
    "Map.map_church_07.0": "Church_07",
    "Map.map_church_07.1": "Church_07",
    "Map.map_church_08.0": "Church_08",
    "Map.map_church_08.1": "Church_08",
    "Map.map_church_08.2": "Church_08",
    "Map.map_church_09.14": "Church_09",
    "Map.map_church_09.5": "Church_09",
    "Map.map_church_10.11": "Church_10",
    "Map.map_church_10.2": "Church_10",
    "Map.map_church_11.10": "Church_11",
    "Map.map_church_11.5": "Church_11",
    "Map.map_church_12.1": "Church_12",
    "Map.map_church_12.3": "Church_12",
    "Map.map_church_13.6": "Church_13",
    "Map.map_church_14.9": "Church_14",
    "Map.map_forest_01.2": "Forest_01",
    "Map.map_forest_01.C8": "Forest_01",
    "Map.map_forest_02.1": "Forest_02",
    "Map.map_forest_02.3": "Forest_02",
    "Map.map_forest_02.4": "Forest_02",
    "Map.map_forest_03.2": "Forest_03",
    "Map.map_forest_03.5": "Forest_03",
    "Map.map_forest_04.2": "Forest_04",
    "Map.map_forest_04.6": "Forest_04",
    "Map.map_forest_05.3": "Forest_05",
    "Map.map_forest_05.4": "Forest_05",
    "Map.map_forest_05.7": "Forest_05",
    "Map.map_forest_06.7": "Forest_06",
    "Map.map_forest_07.5": "Forest_07",
    "Map.map_forest_07.6": "Forest_07",
    "Map.map_forest_07.8": "Forest_07",
    "Map.map_forest_07.O1": "Forest_07",
    "Map.map_forest_08.10": "Forest_08",
    "Map.map_forest_08.7": "Forest_08",
    "Map.map_forest_09.10": "Forest_09",
    "Map.map_forest_09.S2": "Forest_09",
    "Map.map_forest_10.11": "Forest_10",
    "Map.map_forest_10.12": "Forest_10",
    "Map.map_forest_10.8": "Forest_10",
    "Map.map_forest_10.9": "Forest_10",
    "Map.map_forest_11.10": "Forest_11",
    "Map.map_forest_11.14": "Forest_11",
    "Map.map_forest_12.10": "Forest_12",
    "Map.map_forest_12.13": "Forest_12",
    "Map.map_forest_12.17": "Forest_12",
    "Map.map_forest_13.12": "Forest_13",
    "Map.map_forest_13.14": "Forest_13",
    "Map.map_forest_13.16": "Forest_13",
    "Map.map_forest_14.11": "Forest_14",
    "Map.map_forest_14.13": "Forest_14",
    "Map.map_forest_14.15": "Forest_14",
    "Map.map_forest_15.14": "Forest_15",
    "Map.map_forest_16.13": "Forest_16",
    "Map.map_forest_17.12": "Forest_17",
    "Map.map_fort_01.3": "Fort_01",
    "Map.map_fort_01.C7": "Fort_01",
    "Map.map_fort_01.V15": "Fort_01",
    "Map.map_fort_02.3": "Fort_02",
    "Map.map_fort_02.C22": "Fort_02",
    "Map.map_fort_03.1": "Fort_03",
    "Map.map_fort_03.2": "Fort_03",
    "Map.map_fort_03.4": "Fort_03",
    "Map.map_fort_03.5": "Fort_03",
    "Map.map_fort_04.3": "Fort_04",
    "Map.map_fort_04.5": "Fort_04",
    "Map.map_fort_05.15": "Fort_05",
    "Map.map_fort_05.3": "Fort_05",
    "Map.map_fort_05.4": "Fort_05",
    "Map.map_fort_05.6": "Fort_05",
    "Map.map_fort_06.10": "Fort_06",
    "Map.map_fort_06.5": "Fort_06",
    "Map.map_fort_06.7": "Fort_06",
    "Map.map_fort_07.11": "Fort_07",
    "Map.map_fort_07.6": "Fort_07",
    "Map.map_fort_07.8": "Fort_07",
    "Map.map_fort_07.9": "Fort_07",
    "Map.map_fort_07.9B": "Fort_07",
    "Map.map_fort_08.7": "Fort_08",
    "Map.map_fort_09.10": "Fort_09",
    "Map.map_fort_09.7": "Fort_09",
    "Map.map_fort_09.7B": "Fort_09",
    "Map.map_fort_09.O3": "Fort_09",
    "Map.map_fort_10.6": "Fort_10",
    "Map.map_fort_10.9": "Fort_10",
    "Map.map_fort_11.12": "Fort_11",
    "Map.map_fort_11.13": "Fort_11",
    "Map.map_fort_11.53": "Fort_11",
    "Map.map_fort_11.7": "Fort_11",
    "Map.map_fort_12.11": "Fort_12",
    "Map.map_fort_12.14": "Fort_12",
    "Map.map_fort_12.16": "Fort_12",
    "Map.map_fort_13.11": "Fort_13",
    "Map.map_fort_13.11B": "Fort_13",
    "Map.map_fort_13.14": "Fort_13",
    "Map.map_fort_13.19": "Fort_13",
    "Map.map_fort_14.12": "Fort_14",
    "Map.map_fort_14.13": "Fort_14",
    "Map.map_fort_14.15": "Fort_14",
    "Map.map_fort_15.14": "Fort_15",
    "Map.map_fort_15.16": "Fort_15",
    "Map.map_fort_15.16B": "Fort_15",
    "Map.map_fort_15.17": "Fort_15",
    "Map.map_fort_15.5": "Fort_15",
    "Map.map_fort_16.12": "Fort_16",
    "Map.map_fort_16.15": "Fort_16",
    "Map.map_fort_16.15B": "Fort_16",
    "Map.map_fort_16.18": "Fort_16",
    "Map.map_fort_17.15": "Fort_17",
    "Map.map_fort_17.18": "Fort_17",
    "Map.map_fort_18.16": "Fort_18",
    "Map.map_fort_18.17": "Fort_18",
    "Map.map_fort_18.19": "Fort_18",
    "Map.map_fort_19.13": "Fort_19",
    "Map.map_fort_19.18": "Fort_19",
    "Map.map_fort_19.20": "Fort_19",
    "Map.map_fort_20.19": "Fort_20",
    "Map.map_fort_20.21": "Fort_20",
    "Map.map_fort_21.20": "Fort_21",
    "Map.map_oubliette_01.2": "Oubliette_01",
    "Map.map_oubliette_01.F7": "Oubliette_01",
    "Map.map_oubliette_02.1": "Oubliette_02",
    "Map.map_oubliette_02.4": "Oubliette_02",
    "Map.map_oubliette_02.5": "Oubliette_02",
    "Map.map_oubliette_03.10": "Oubliette_03",
    "Map.map_oubliette_03.4": "Oubliette_03",
    "Map.map_oubliette_03.5": "Oubliette_03",
    "Map.map_oubliette_04.2": "Oubliette_04",
    "Map.map_oubliette_04.3": "Oubliette_04",
    "Map.map_oubliette_05.2": "Oubliette_05",
    "Map.map_oubliette_05.3": "Oubliette_05",
    "Map.map_oubliette_05.5_1": "Oubliette_05",
    "Map.map_oubliette_05.5_2": "Oubliette_05",
    "Map.map_oubliette_05.5_2B": "Oubliette_05",
    "Map.map_oubliette_05.5_3": "Oubliette_05",
    "Map.map_oubliette_05.6": "Oubliette_05",
    "Map.map_oubliette_05.7_1": "Oubliette_05",
    "Map.map_oubliette_05.7_2": "Oubliette_05",
    "Map.map_oubliette_05_1.5": "Oubliette_05_1",
    "Map.map_oubliette_05_2.5": "Oubliette_05_2",
    "Map.map_oubliette_05_2.5B": "Oubliette_05_2",
    "Map.map_oubliette_05_3.5": "Oubliette_05_3",
    "Map.map_oubliette_06.10": "Oubliette_06",
    "Map.map_oubliette_06.5": "Oubliette_06",
    "Map.map_oubliette_06.7": "Oubliette_06",
    "Map.map_oubliette_06_1.7": "Oubliette_06_1",
    "Map.map_oubliette_06_2.7": "Oubliette_06_2",
    "Map.map_oubliette_06_3.7": "Oubliette_06_3",
    "Map.map_oubliette_06_4.7": "Oubliette_06_4",
    "Map.map_oubliette_07.13": "Oubliette_07",
    "Map.map_oubliette_07.6": "Oubliette_07",
    "Map.map_oubliette_07.6_1": "Oubliette_07",
    "Map.map_oubliette_07.6_2": "Oubliette_07",
    "Map.map_oubliette_07.6_3": "Oubliette_07",
    "Map.map_oubliette_07.6_4": "Oubliette_07",
    "Map.map_oubliette_07.9": "Oubliette_07",
    "Map.map_oubliette_07_1.5": "Oubliette_07_1",
    "Map.map_oubliette_07_2.5": "Oubliette_07_2",
    "Map.map_oubliette_08.11": "Oubliette_08",
    "Map.map_oubliette_08.13": "Oubliette_08",
    "Map.map_oubliette_08.9": "Oubliette_08",
    "Map.map_oubliette_09.10": "Oubliette_09",
    "Map.map_oubliette_09.7": "Oubliette_09",
    "Map.map_oubliette_09.8": "Oubliette_09",
    "Map.map_oubliette_10.17": "Oubliette_10",
    "Map.map_oubliette_10.3": "Oubliette_10",
    "Map.map_oubliette_10.6": "Oubliette_10",
    "Map.map_oubliette_10.9": "Oubliette_10",
    "Map.map_oubliette_11.12": "Oubliette_11",
    "Map.map_oubliette_11.13": "Oubliette_11",
    "Map.map_oubliette_11.13_1": "Oubliette_11",
    "Map.map_oubliette_11.13_2": "Oubliette_11",
    "Map.map_oubliette_11.14": "Oubliette_11",
    "Map.map_oubliette_11.8": "Oubliette_11",
    "Map.map_oubliette_12.11": "Oubliette_12",
    "Map.map_oubliette_13.11": "Oubliette_13",
    "Map.map_oubliette_13.7": "Oubliette_13",
    "Map.map_oubliette_13.8": "Oubliette_13",
    "Map.map_oubliette_13_1.11": "Oubliette_13_1",
    "Map.map_oubliette_13_2.11": "Oubliette_13_2",
    "Map.map_oubliette_14.11": "Oubliette_14",
    "Map.map_oubliette_14.15": "Oubliette_14",
    "Map.map_oubliette_15.14": "Oubliette_15",
    "Map.map_oubliette_15.16": "Oubliette_15",
    "Map.map_oubliette_16.15": "Oubliette_16",
    "Map.map_oubliette_16.O1": "Oubliette_16",
    "Map.map_oubliette_17.10": "Oubliette_17",
    "Map.map_oubliette_17.S6": "Oubliette_17",
    "Map.map_outside_01.2": "Outside_01",
    "Map.map_outside_01.3": "Outside_01",
    "Map.map_outside_01.O16": "Outside_01",
    "Map.map_outside_02.1": "Outside_02",
    "Map.map_outside_03.1": "Outside_03",
    "Map.map_outside_03.F9": "Outside_03",
    "Map.map_swamp_01.2": "Swamp_01",
    "Map.map_swamp_01.3": "Swamp_01",
    "Map.map_swamp_02.1": "Swamp_02",
    "Map.map_swamp_02.F9": "Swamp_02",
    "Map.map_swamp_03.1": "Swamp_03",
    "Map.map_swamp_03.4": "Swamp_03",
    "Map.map_swamp_03.7": "Swamp_03",
    "Map.map_swamp_03.9": "Swamp_03",
    "Map.map_swamp_04.3": "Swamp_04",
    "Map.map_swamp_04.5": "Swamp_04",
    "Map.map_swamp_05.4": "Swamp_05",
    "Map.map_swamp_05.6": "Swamp_05",
    "Map.map_swamp_05.7": "Swamp_05",
    "Map.map_swamp_05.9": "Swamp_05",
    "Map.map_swamp_06.5": "Swamp_06",
    "Map.map_swamp_06.O17": "Swamp_06",
    "Map.map_swamp_07.16": "Swamp_07",
    "Map.map_swamp_07.3": "Swamp_07",
    "Map.map_swamp_07.5": "Swamp_07",
    "Map.map_swamp_07.8": "Swamp_07",
    "Map.map_swamp_08.14": "Swamp_08",
    "Map.map_swamp_08.15": "Swamp_08",
    "Map.map_swamp_08.7": "Swamp_08",
    "Map.map_swamp_09.13": "Swamp_09",
    "Map.map_swamp_09.13B": "Swamp_09",
    "Map.map_swamp_09.3": "Swamp_09",
    "Map.map_swamp_09.5": "Swamp_09",
    "Map.map_swamp_10.13": "Swamp_10",
    "Map.map_swamp_11.14": "Swamp_11",
    "Map.map_swamp_11.15": "Swamp_11",
    "Map.map_swamp_12.15": "Swamp_12",
    "Map.map_swamp_12.4": "Swamp_12",
    "Map.map_swamp_12.A5": "Swamp_12",
    "Map.map_swamp_13.10": "Swamp_13",
    "Map.map_swamp_13.14": "Swamp_13",
    "Map.map_swamp_13.9": "Swamp_13",
    "Map.map_swamp_13.9B": "Swamp_13",
    "Map.map_swamp_14.11": "Swamp_14",
    "Map.map_swamp_14.13": "Swamp_14",
    "Map.map_swamp_14.8": "Swamp_14",
    "Map.map_swamp_15.11": "Swamp_15",
    "Map.map_swamp_15.12": "Swamp_15",
    "Map.map_swamp_15.8": "Swamp_15",
    "Map.map_swamp_16.17": "Swamp_16",
    "Map.map_swamp_16.7": "Swamp_16",
    "Map.map_swamp_17.16": "Swamp_17",
    "Map.map_swamp_17.18": "Swamp_17",
    "Map.map_swamp_18.17": "Swamp_18",
    "Map.map_swamp_18.A1": "Swamp_18",
    "Map.map_village_01.0": "Village_01",
    "Map.map_village_01.1": "Village_01",
    "Map.map_village_02.0": "Village_02",
    "Map.map_village_02.1": "Village_02",
    "Map.map_village_02.13": "Village_02",
    "Map.map_village_03.0": "Village_03",
    "Map.map_village_03.2": "Village_03",
    "Map.map_village_03.5": "Village_03",
    "Map.map_village_04.2": "Village_04",
    "Map.map_village_04.5": "Village_04",
    "Map.map_village_04_1.0": "Village_04_1",
    "Map.map_village_05.1": "Village_05",
    "Map.map_village_05.3": "Village_05",
    "Map.map_village_05.4": "Village_05",
    "Map.map_village_06.0": "Village_06",
    "Map.map_village_06.1": "Village_06",
    "Map.map_village_06.12": "Village_06",
    "Map.map_village_06.8": "Village_06",
    "Map.map_village_07.0": "Village_07",
    "Map.map_village_07.14": "Village_07",
    "Map.map_village_07.9": "Village_07",
    "Map.map_village_08.6": "Village_08",
    "Map.map_village_08.9": "Village_08",
    "Map.map_village_09.1": "Village_09",
    "Map.map_village_09.2": "Village_09",
    "Map.map_village_09.7": "Village_09",
    "Map.map_village_09.8": "Village_09",
    "Map.map_village_10.0": "Village_10",
    "Map.map_village_10.1": "Village_10",
    "Map.map_village_11.0": "Village_11",
    "Map.map_village_11.1": "Village_11",
    "Map.map_village_11.2": "Village_11",
    "Map.map_village_11_1.0": "Village_11_1",
    "Map.map_village_12.13": "Village_12",
    "Map.map_village_12.16": "Village_12",
    "Map.map_village_12.6": "Village_12",
    "Map.map_village_12.C1": "Village_12",
    "Map.map_village_13.0": "Village_13",
    "Map.map_village_13.12": "Village_13",
    "Map.map_village_13.2": "Village_13",
    "Map.map_village_14.7": "Village_14",
    "Map.map_village_15.0": "Village_15",
    "Map.map_village_15.F1": "Village_15",
    "Map.map_village_16.12": "Village_16",
}

indirect_connections : Dict[str, List[str]]= {
    "The Abyss 01 To Verboten Domain 18": ["Map.map_abyss_01.S18"],
    "The Abyss 01 To The Abyss 02": ["Map.map_abyss_01.2", "Map.map_abyss_01.S18"],
    "The Abyss 02 To The Abyss 03": ["Map.map_abyss_02.1", "Map.map_abyss_02.3"],
    "The Abyss 02 To The Abyss 01": ["Map.map_abyss_02.1", "Map.map_abyss_02.3"],
    "The Abyss 03 To The Abyss 02": ["Map.map_abyss_03.2"],
    "The Abyss 04 To Verboten Domain 12": ["Map.map_abyss_04.2"],
    "The Abyss 04 To The Abyss 05": ["Map.map_abyss_04.5", "Map.map_abyss_04.2"],
    "The Abyss 05 To Verboten Domain 12": ["Map.map_abyss_05.4"],
    "The Abyss 05 To The Abyss 04": ["Map.map_abyss_05.4"],
    "Ruined Castle 01 To Cliffside Hamlet 11": ["Map.map_castle_01.0"],
    "Ruined Castle 01 To Ruined Castle 02 Lower": ["Map.map_castle_01.2"],
    "Ruined Castle 01 To Ruined Castle 02 Upper": [
        "Map.map_castle_01.10",
        "Map.map_castle_01.2B",
    ],
    "Ruined Castle 01 To Ruined Castle 10": ["Map.map_castle_01.2B"],
    "Ruined Castle 02 To Ruined Castle 05": [
        "Map.map_castle_02.1",
        "Map.map_castle_02.5",
    ],
    "Ruined Castle 02 To Ruined Castle 01 Lower": [
        "Map.map_castle_02.4",
        "Map.map_castle_02.1",
        "Map.map_castle_02.5",
        "Map.map_castle_02.1B",
    ],
    "Ruined Castle 02 To Ruined Castle 04": [
        "Map.map_castle_02.4",
        "Map.map_castle_02.1",
    ],
    "Ruined Castle 02 To Ruined Castle 01 Upper": [
        "Map.map_castle_02.1",
        "Map.map_castle_02.1B",
    ],
    "Ruined Castle 03 To Ruined Castle 05": [
        "Map.map_castle_03.5",
        "Map.map_castle_03.11B",
        "Map.map_castle_03.11A",
    ],
    "Ruined Castle 03 To Ruined Castle 11 Left": ["Map.map_castle_03.11A"],
    "Ruined Castle 03 To Ruined Castle 11 Right": ["Map.map_castle_03.11B"],
    "Ruined Castle 04 To Ruined Castle 02": ["Map.map_castle_04.2"],
    "Ruined Castle 05 To Ruined Castle 02": [
        "Map.map_castle_05.6",
        "Map.map_castle_05.2",
        "Map.map_castle_05.8",
        "Map.map_castle_05.3",
    ],
    "Ruined Castle 05 To Ruined Castle 06": [
        "Map.map_castle_05.6",
        "Map.map_castle_05.2",
    ],
    "Ruined Castle 05 To Ruined Castle 08": [
        "Map.map_castle_05.2",
        "Map.map_castle_05.8",
    ],
    "Ruined Castle 05 To Ruined Castle 03": ["Map.map_castle_05.3"],
    "Ruined Castle 06 To Ruined Castle 12": [
        "Map.map_castle_06.7",
        "Map.map_castle_06.12",
    ],
    "Ruined Castle 06 To Ruined Castle 07": [
        "Map.map_castle_06.5",
        "Map.map_castle_06.7",
        "Map.map_castle_06.12",
    ],
    "Ruined Castle 06 To Ruined Castle 05": [
        "Map.map_castle_06.5",
        "Map.map_castle_06.12",
    ],
    "Ruined Castle 07 To Twin Spires 01": ["Map.map_castle_07.F1"],
    "Ruined Castle 07 To Ruined Castle 06": ["Map.map_castle_07.6"],
    "Ruined Castle 08 To Ruined Castle 05": [
        "Map.map_castle_08.5",
        "Map.map_castle_08.9",
    ],
    "Ruined Castle 08 To Ruined Castle 09": [
        "Map.map_castle_08.5",
        "Map.map_castle_08.9",
    ],
    "Ruined Castle 09 To Ruined Castle 11": [
        "Map.map_castle_09.11",
        "Map.map_castle_09.8",
    ],
    "Ruined Castle 09 To Ruined Castle 08": [
        "Map.map_castle_09.11",
        "Map.map_castle_09.8",
        "Map.map_castle_09.10",
    ],
    "Ruined Castle 09 To Ruined Castle 10": [
        "Map.map_castle_09.8",
        "Map.map_castle_09.10",
    ],
    "Ruined Castle 11 To Ruined Castle 12": [
        "Map.map_castle_11.3B",
        "Map.map_castle_11.12",
    ],
    "Ruined Castle 11 To Ruined Castle 09": [
        "Map.map_castle_11.3A",
        "Map.map_castle_11.9",
    ],
    "Ruined Castle 11 To Ruined Castle 13": [
        "Map.map_castle_11.12",
        "Map.map_castle_11.13",
        "Map.map_castle_11.9",
    ],
    "Ruined Castle 11 To Ruined Castle 03 Left": [
        "Map.map_castle_11.9",
        "Map.map_castle_11.3A",
    ],
    "Ruined Castle 11 To Ruined Castle 03 Right": [
        "Map.map_castle_11.3B",
        "Map.map_castle_11.12",
    ],
    "Ruined Castle 12 To Ruined Castle 06": [
        "Map.map_castle_12.11",
        "Map.map_castle_12.6",
    ],
    "Ruined Castle 12 To Ruined Castle 11": [
        "Map.map_castle_12.11",
        "Map.map_castle_12.6",
    ],
    "Ruined Castle 12 To Ruined Castle 21": [
        "Map.map_castle_12.21",
        "Map.map_castle_12.6",
    ],
    "Ruined Castle 13 To Ruined Castle 17": [
        "Map.map_castle_13.11",
        "Map.map_castle_13.17",
    ],
    "Ruined Castle 13 To Ruined Castle 11": [
        "Map.map_castle_13.17",
        "Map.map_castle_13.11",
        "Map.map_castle_13.14",
    ],
    "Ruined Castle 13 To Ruined Castle 14": [
        "Map.map_castle_13.14",
        "Map.map_castle_13.11",
    ],
    "Ruined Castle 14 To Ruined Castle 13": [
        "Map.map_castle_14.13",
        "Map.map_castle_14.15",
    ],
    "Ruined Castle 14 To Ruined Castle 15": [
        "Map.map_castle_14.13",
        "Map.map_castle_14.15",
    ],
    "Ruined Castle 15 To Ruined Castle 14": ["Map.map_castle_15.14"],
    "Ruined Castle 16 To Ruined Castle 18": ["Map.map_castle_17.18"],
    "Ruined Castle 16 To Ruined Castle 15": ["Map.map_castle_16.15"],
    "Ruined Castle 17 To Ruined Castle 13": ["Map.map_castle_17.13"],
    "Ruined Castle 17 To Ruined Castle 18": ["Map.map_castle_17.13"],
    "Ruined Castle 18 To Ruined Castle 19": [
        "Map.map_castle_18.19",
        "Map.map_castle_18.17",
    ],
    "Ruined Castle 18 To Ruined Castle 17": [
        "Map.map_castle_18.19",
        "Map.map_castle_18.17",
        "Map.map_castle_18.16",
    ],
    "Ruined Castle 21 To Ruined Castle 12": ["Map.map_castle_21.12"],
    "Catacombs 02 To Catacombs 05": [
        "Map.map_cave_02.5",
        "Map.map_cave_02.1",
        "Map.map_cave_02.7",
    ],
    "Catacombs 02 To Catacombs 07": ["Map.map_cave_02.5", "Map.map_cave_02.7"],
    "Catacombs 02 To Catacombs 01": ["Map.map_cave_02.5"],
    "Catacombs 03 To Catacombs 07": ["Map.map_cave_03.7"],
    "Catacombs 03 To Catacombs 08": ["Map.map_cave_03.8"],
    "Catacombs 04 To Catacombs 16": ["Map.map_cave_04.5", "Map.map_cave_04.16"],
    "Catacombs 04 To Catacombs 05": ["Map.map_cave_04.16", "Map.map_cave_04.5"],
    "Catacombs 04 To Catacombs 12": ["Map.map_cave_04.5", "Map.map_cave_04.12"],
    "Catacombs 05 To Catacombs 02": ["Map.map_cave_05.2", "Map.map_cave_05.6"],
    "Catacombs 05 To Catacombs 04": ["Map.map_cave_05.4", "Map.map_cave_05.6"],
    "Catacombs 05 To Catacombs 06": [
        "Map.map_cave_05.4",
        "Map.map_cave_05.10",
        "Map.map_cave_05.2",
        "Map.map_cave_05.6",
    ],
    "Catacombs 05 To Catacombs 10": ["Map.map_cave_05.10", "Map.map_cave_05.6"],
    "Catacombs 06 To Catacombs 05": ["Map.map_cave_06.5", "Map.map_cave_06.3"],
    "Catacombs 06 To Catacombs 03": ["Map.map_cave_06.5", "Map.map_cave_06.3"],
    "Catacombs 08 To Catacombs 09": ["Map.map_cave_08.3", "Map.map_cave_08.9"],
    "Catacombs 08 To Catacombs 03": [
        "Map.map_cave_08.11",
        "Map.map_cave_08.3",
        "Map.map_cave_08.9",
    ],
    "Catacombs 08 To Catacombs 17": ["Map.map_cave_08.3", "Map.map_cave_08.17"],
    "Catacombs 08 To Catacombs 11": ["Map.map_cave_08.11", "Map.map_cave_08.3"],
    "Catacombs 09 To Catacombs 10": ["Map.map_cave_09.10", "Map.map_cave_09.8"],
    "Catacombs 09 To Catacombs 08": [
        "Map.map_cave_09.21",
        "Map.map_cave_09.10",
        "Map.map_cave_09.8",
    ],
    "Catacombs 09 To Catacombs 21": ["Map.map_cave_09.21", "Map.map_cave_09.10"],
    "Catacombs 10 To Catacombs 23": ["Map.map_cave_10.9", "Map.map_cave_10.23"],
    "Catacombs 10 To Catacombs 05": ["Map.map_cave_10.9", "Map.map_cave_10.5"],
    "Catacombs 10 To Catacombs 09": [
        "Map.map_cave_10.9",
        "Map.map_cave_10.5",
        "Map.map_cave_10.23",
        "Map.map_cave_10.16",
    ],
    "Catacombs 10 To Catacombs 16": ["Map.map_cave_10.9", "Map.map_cave_10.16"],
    "Catacombs 11 To Catacombs 08": ["Map.map_cave_11.8"],
    "Catacombs 11 To Catacombs 18": ["Map.map_cave_11.18"],
    "Catacombs 12 To Catacombs 04": ["Map.map_cave_12.4"],
    "Catacombs 13 To Catacombs 23": ["Map.map_cave_13.23"],
    "Catacombs 14 To Catacombs 13": [
        "Map.map_cave_14.15",
        "Map.map_cave_14.13",
        "Map.map_cave_14.22",
    ],
    "Catacombs 14 To Catacombs 15": ["Map.map_cave_14.15", "Map.map_cave_14.13"],
    "Catacombs 14 To Catacombs 22": ["Map.map_cave_14.13", "Map.map_cave_14.22"],
    "Catacombs 15 To Catacombs 14": ["Map.map_cave_15.16", "Map.map_cave_15.14"],
    "Catacombs 15 To Catacombs 16": ["Map.map_cave_15.16", "Map.map_cave_15.14"],
    "Catacombs 16 To Catacombs 15": ["Map.map_cave_16.15"],
    "Catacombs 16 To Catacombs 10": ["Map.map_cave_16.10"],
    "Catacombs 16 To Catacombs 04": ["Map.map_cave_16.4"],
    "Catacombs 17 To Catacombs 08": ["Map.map_cave_17.8"],
    "Catacombs 18 To Catacombs 11 Upper": ["Map.map_cave_18.11"],
    "Catacombs 18 To Catacombs 11 Lower": ["Map.map_cave_18.11"],
    "Catacombs 19 To Catacombs 20": ["Map.map_cave_19.20"],
    "Catacombs 19 To Catacombs 21": ["Map.map_cave_19.21", "Map.map_cave_19.20"],
    "Catacombs 20 To Catacombs 22": ["Map.map_cave_20.22", "Map.map_cave_20.19"],
    "Catacombs 20 To Catacombs 19": [
        "Map.map_cave_20.13",
        "Map.map_cave_20.22",
        "Map.map_cave_20.19",
    ],
    "Catacombs 20 To Catacombs 13": [
        "Map.map_cave_20.22",
        "Map.map_cave_20.13",
        "Map.map_cave_20.19",
    ],
    "Catacombs 21 To Catacombs 09": ["Map.map_cave_21.9", "Map.map_cave_21.19"],
    "Catacombs 21 To Catacombs 19": ["Map.map_cave_21.9", "Map.map_cave_21.19"],
    "Catacombs 22 To Twin Spires 02": ["Map.map_cave_22.F2", "Map.map_cave_22.20"],
    "Catacombs 22 To Catacombs 14": ["Map.map_cave_22.20", "Map.map_cave_22.14"],
    "Catacombs 22 To Catacombs 20": [
        "Map.map_cave_22.F2",
        "Map.map_cave_22.20",
        "Map.map_cave_22.14",
    ],
    "White Parish 01 To White Parish 02": [
        "Map.map_church_01.12",
        "Map.map_church_01.2",
        "Map.map_church_01.1",
    ],
    "White Parish 01 To White Parish 12": [
        "Map.map_church_01.12",
        "Map.map_church_01.2",
        "Map.map_church_01.1",
    ],
    "White Parish 02 To White Parish 01": [
        "Map.map_church_02.0",
        "Map.map_church_02.10",
    ],
    "White Parish 02 To White Parish 10": [
        "Map.map_church_02.0",
        "Map.map_church_02.10",
    ],
    "White Parish 03 To White Parish 05": [
        "Map.map_church_03.0",
        "Map.map_church_03.1",
    ],
    "White Parish 03 To White Parish 04": [
        "Map.map_church_03.0",
        "Map.map_church_03.1",
    ],
    "White Parish 04 To White Parish 03": ["Map.map_church_04.0"],
    "White Parish 04 To White Parish 06": ["Map.map_church_04.1"],
    "White Parish 06 To White Parish 04": [
        "Map.map_church_06.0",
        "Map.map_church_06.1",
    ],
    "White Parish 06 To White Parish 07": [
        "Map.map_church_06.1",
        "Map.map_church_06.0",
    ],
    "White Parish 07 To White Parish 06": ["Map.map_church_07.0"],
    "White Parish 07 To White Parish 08": [
        "Map.map_church_07.1",
        "Map.map_church_07.0",
    ],
    "White Parish 09 To White Parish 05": [
        "Map.map_church_09.5",
        "Map.map_church_09.14",
    ],
    "White Parish 09 To White Parish 14": ["Map.map_church_09.5"],
    "White Parish 10 To White Parish 02": ["Map.map_church_10.2"],
    "White Parish 10 To White Parish 11": ["Map.map_church_10.11"],
    "White Parish 11 To White Parish 05": [
        "Map.map_church_11.5",
        "Map.map_church_11.10",
    ],
    "White Parish 11 To White Parish 10": ["Map.map_church_11.10"],
    "White Parish 12 To White Parish 01": ["Map.map_church_12.1"],
    "White Parish 12 To White Parish 13": ["Map.map_church_12.3"],
    "White Parish 13 To White Parish 12": ["Map.map_church_13.6"],
    "White Parish 14 To White Parish 09": ["Map.map_church_14.9"],
    "Witch's Thicket 01 To White Parish 08": [
        "Map.map_forest_01.2",
        "Map.map_forest_01.C8",
    ],
    "Witch's Thicket 01 To Witch's Thicket 02": [
        "Map.map_forest_01.2",
        "Map.map_forest_01.C8",
    ],
    "Witch's Thicket 02 To Witch's Thicket 01": [
        "Map.map_forest_02.1",
        "Map.map_forest_02.4",
    ],
    "Witch's Thicket 02 To Witch's Thicket 04": [
        "Map.map_forest_02.1",
        "Map.map_forest_02.3",
        "Map.map_forest_02.4",
    ],
    "Witch's Thicket 02 To Witch's Thicket 03": [
        "Map.map_forest_02.1",
        "Map.map_forest_02.3",
    ],
    "Witch's Thicket 03 To Witch's Thicket 05": [
        "Map.map_forest_03.5",
        "Map.map_forest_03.2",
    ],
    "Witch's Thicket 03 To Witch's Thicket 02": [
        "Map.map_forest_03.5",
        "Map.map_forest_03.2",
    ],
    "Witch's Thicket 04 To Witch's Thicket 05": [
        "Map.map_forest_04.6",
        "Map.map_forest_04.2",
    ],
    "Witch's Thicket 04 To Witch's Thicket 02": [
        "Map.map_forest_04.6",
        "Map.map_forest_04.2",
    ],
    "Witch's Thicket 05 To Witch's Thicket 07": ["Map.map_forest_05.7"],
    "Witch's Thicket 05 To Witch's Thicket 03": ["Map.map_forest_05.3"],
    "Witch's Thicket 05 To Witch's Thicket 04": ["Map.map_forest_05.4"],
    "Witch's Thicket 06 To Witch's Thicket 07": ["Map.map_forest_06.7"],
    "Witch's Thicket 07 To Stockade 01": [
        "Map.map_forest_07.O1",
        "Map.map_forest_07.5",
    ],
    "Witch's Thicket 07 To Witch's Thicket 08": [
        "Map.map_forest_07.5",
        "Map.map_forest_07.8",
    ],
    "Witch's Thicket 07 To Witch's Thicket 05": [
        "Map.map_forest_07.O1",
        "Map.map_forest_07.5",
        "Map.map_forest_07.8",
    ],
    "Witch's Thicket 07 To Witch's Thicket 06": [
        "Map.map_forest_07.5",
        "Map.map_forest_07.6",
    ],
    "Witch's Thicket 08 To Witch's Thicket 07": [
        "Map.map_forest_08.7",
        "Map.map_forest_08.10",
    ],
    "Witch's Thicket 08 To Witch's Thicket 10": [
        "Map.map_forest_08.10",
        "Map.map_forest_08.7",
    ],
    "Witch's Thicket 09 To Witch's Thicket 10": [
        "Map.map_forest_09.S2",
        "Map.map_forest_09.10",
    ],
    "Witch's Thicket 09 To Verboten Domain 02": [
        "Map.map_forest_09.S2",
        "Map.map_forest_09.10",
    ],
    "Witch's Thicket 10 To Witch's Thicket 11": ["Map.map_forest_10.11"],
    "Witch's Thicket 10 To Witch's Thicket 09": ["Map.map_forest_10.9"],
    "Witch's Thicket 10 To Witch's Thicket 08": ["Map.map_forest_10.8"],
    "Witch's Thicket 10 To Witch's Thicket 12": ["Map.map_forest_10.12"],
    "Witch's Thicket 11 To Witch's Thicket 10": [
        "Map.map_forest_11.10",
        "Map.map_forest_11.14",
    ],
    "Witch's Thicket 11 To Witch's Thicket 14": [
        "Map.map_forest_11.10",
        "Map.map_forest_11.14",
    ],
    "Witch's Thicket 12 To Witch's Thicket 10": [
        "Map.map_forest_12.13",
        "Map.map_forest_12.10",
    ],
    "Witch's Thicket 12 To Witch's Thicket 13": [
        "Map.map_forest_12.13",
        "Map.map_forest_12.10",
        "Map.map_forest_12.17",
    ],
    "Witch's Thicket 12 To Witch's Thicket 17": [
        "Map.map_forest_12.13",
        "Map.map_forest_12.10",
        "Map.map_forest_12.17",
    ],
    "Witch's Thicket 13 To Witch's Thicket 12": [
        "Map.map_forest_13.12",
        "Map.map_forest_13.14",
    ],
    "Witch's Thicket 13 To Witch's Thicket 14": [
        "Map.map_forest_13.12",
        "Map.map_forest_13.14",
    ],
    "Witch's Thicket 13 To Witch's Thicket 16": [
        "Map.map_forest_13.16",
        "Map.map_forest_13.12",
    ],
    "Witch's Thicket 14 To Witch's Thicket 11": ["Map.map_forest_14.11"],
    "Witch's Thicket 15 To Witch's Thicket 14": ["Map.map_forest_15.14"],
    "Witch's Thicket 16 To Witch's Thicket 13": ["Map.map_forest_16.13"],
    "Witch's Thicket 17 To Witch's Thicket 12": ["Map.map_forest_17.12"],
    "Twin Spires 01 To Twin Spires 03": [
        "Map.map_fort_01.C7",
        "Map.map_fort_01.3",
        "Map.map_fort_01.V15",
    ],
    "Twin Spires 01 To Cliffside Hamlet 15": [
        "Map.map_fort_01.3",
        "Map.map_fort_01.V15",
    ],
    "Twin Spires 01 To Ruined Castle 07": ["Map.map_fort_01.C7"],
    "Twin Spires 02 To Twin Spires 03": ["Map.map_fort_02.3", "Map.map_fort_02.C22"],
    "Twin Spires 02 To Catacombs 22": ["Map.map_fort_02.3", "Map.map_fort_02.C22"],
    "Twin Spires 04 To Twin Spires 05": ["Map.map_fort_04.5", "Map.map_fort_04.3"],
    "Twin Spires 04 To Twin Spires 03": ["Map.map_fort_04.5", "Map.map_fort_04.3"],
    "Twin Spires 05 To Twin Spires 04": ["Map.map_fort_05.4", "Map.map_fort_05.6"],
    "Twin Spires 05 To Twin Spires 06": ["Map.map_fort_05.4", "Map.map_fort_05.6"],
    "Twin Spires 05 To Twin Spires 03": ["Map.map_fort_05.4", "Map.map_fort_05.3"],
    "Twin Spires 05 To Twin Spires 15": ["Map.map_fort_05.4"],
    "Twin Spires 06 To Twin Spires 05": [
        "Map.map_fort_06.7",
        "Map.map_fort_06.10",
        "Map.map_fort_06.5",
    ],
    "Twin Spires 06 To Twin Spires 07": ["Map.map_fort_06.7", "Map.map_fort_06.5"],
    "Twin Spires 06 To Twin Spires 10": [
        "Map.map_fort_06.7",
        "Map.map_fort_06.10",
        "Map.map_fort_06.5",
    ],
    "Twin Spires 07 To Twin Spires 09 Left": [
        "Map.map_fort_07.9",
        "Map.map_fort_07.8",
        "Map.map_fort_07.11",
        "Map.map_fort_07.9B",
    ],
    "Twin Spires 07 To Twin Spires 08": ["Map.map_fort_07.8", "Map.map_fort_07.11"],
    "Twin Spires 07 To Twin Spires 06": ["Map.map_fort_07.11", "Map.map_fort_07.6"],
    "Twin Spires 07 To Twin Spires 11": [
        "Map.map_fort_07.9",
        "Map.map_fort_07.8",
        "Map.map_fort_07.6",
        "Map.map_fort_07.11",
    ],
    "Twin Spires 07 To Twin Spires 09 Right": [
        "Map.map_fort_07.9",
        "Map.map_fort_07.9B",
    ],
    "Twin Spires 08 To Twin Spires 07": ["Map.map_fort_08.7"],
    "Twin Spires 09 To Hinterlands 03": ["Map.map_fort_09.O3", "Map.map_fort_09.7"],
    "Twin Spires 09 To Twin Spires 10": [
        "Map.map_fort_09.O3",
        "Map.map_fort_09.7B",
        "Map.map_fort_09.7",
        "Map.map_fort_09.10",
    ],
    "Twin Spires 09 To Twin Spires 07 Left": [
        "Map.map_fort_09.7",
        "Map.map_fort_09.10",
    ],
    "Twin Spires 09 To Twin Spires 07 Right": [
        "Map.map_fort_09.O3",
        "Map.map_fort_09.7B",
    ],
    "Twin Spires 11 To Twin Spires 07": [
        "Map.map_fort_11.12",
        "Map.map_fort_11.53",
        "Map.map_fort_11.7",
        "Map.map_fort_11.13",
    ],
    "Twin Spires 11 To Twin Spires 12": [
        "Map.map_fort_11.12",
        "Map.map_fort_11.7",
        "Map.map_fort_11.13",
    ],
    "Twin Spires 11 To Twin Spires 13 Left": [
        "Map.map_fort_11.12",
        "Map.map_fort_11.13",
    ],
    "Twin Spires 11 To Twin Spires 13 Right": ["Map.map_fort_11.53"],
    "Twin Spires 12 To Twin Spires 11": ["Map.map_fort_12.16", "Map.map_fort_12.11"],
    "Twin Spires 12 To Twin Spires 14": ["Map.map_fort_12.14"],
    "Twin Spires 12 To Twin Spires 16": [
        "Map.map_fort_12.14",
        "Map.map_fort_12.16",
        "Map.map_fort_12.11",
    ],
    "Twin Spires 13 To Twin Spires 11 Left": [
        "Map.map_fort_13.14",
        "Map.map_fort_13.19",
        "Map.map_fort_13.11",
        "Map.map_fort_13.11B",
    ],
    "Twin Spires 13 To Twin Spires 11 Right": [
        "Map.map_fort_13.11",
        "Map.map_fort_13.19",
        "Map.map_fort_13.11B",
    ],
    "Twin Spires 13 To Twin Spires 14": ["Map.map_fort_13.14", "Map.map_fort_13.11"],
    "Twin Spires 13 To Twin Spires 19": ["Map.map_fort_13.19", "Map.map_fort_13.11"],
    "Twin Spires 14 To Twin Spires 15": ["Map.map_fort_14.15", "Map.map_fort_14.13"],
    "Twin Spires 14 To Twin Spires 13": [
        "Map.map_fort_14.15",
        "Map.map_fort_14.13",
        "Map.map_fort_14.12",
    ],
    "Twin Spires 14 To Twin Spires 12": [
        "Map.map_fort_14.15",
        "Map.map_fort_14.13",
        "Map.map_fort_14.12",
    ],
    "Twin Spires 15 To Twin Spires 16 Upper": [
        "Map.map_fort_15.16",
        "Map.map_fort_15.5",
        "Map.map_fort_15.14",
        "Map.map_fort_15.17",
    ],
    "Twin Spires 15 To Twin Spires 14": ["Map.map_fort_15.16", "Map.map_fort_15.14"],
    "Twin Spires 15 To Twin Spires 05": ["Map.map_fort_15.5", "Map.map_fort_15.17"],
    "Twin Spires 15 To Twin Spires 17": ["Map.map_fort_15.16B", "Map.map_fort_15.17"],
    "Twin Spires 15 To Twin Spires 16 Lower": [
        "Map.map_fort_15.5",
        "Map.map_fort_15.16",
        "Map.map_fort_15.16B",
    ],
    "Twin Spires 16 To Twin Spires 15 Upper": ["Map.map_fort_16.15"],
    "Twin Spires 16 To Twin Spires 18": ["Map.map_fort_16.18"],
    "Twin Spires 16 To Twin Spires 15 Lower": ["Map.map_fort_16.15B"],
    "Twin Spires 16 To Twin Spires 12": ["Map.map_fort_16.12"],
    "Twin Spires 17 To Twin Spires 15": ["Map.map_fort_17.15"],
    "Twin Spires 17 To Twin Spires 18": ["Map.map_fort_17.18", "Map.map_fort_17.15"],
    "Twin Spires 18 To Twin Spires 17": ["Map.map_fort_18.17", "Map.map_fort_18.19"],
    "Twin Spires 18 To Twin Spires 19": [
        "Map.map_fort_18.17",
        "Map.map_fort_18.19",
        "Map.map_fort_18.16",
    ],
    "Twin Spires 18 To Twin Spires 16": ["Map.map_fort_18.19", "Map.map_fort_18.16"],
    "Twin Spires 19 To Twin Spires 18": ["Map.map_fort_19.20", "Map.map_fort_19.18"],
    "Twin Spires 19 To Twin Spires 20": ["Map.map_fort_19.18", "Map.map_fort_19.20"],
    "Twin Spires 19 To Twin Spires 13": ["Map.map_fort_19.13", "Map.map_fort_19.20"],
    "Twin Spires 20 To Twin Spires 19": ["Map.map_fort_20.19"],
    "Twin Spires 20 To Twin Spires 21": ["Map.map_fort_20.21"],
    "Twin Spires 21 To Twin Spires 20": ["Map.map_fort_21.20"],
    "Stockade 01 To Witch's Thicket 07": [
        "Map.map_oubliette_01.2",
        "Map.map_oubliette_01.F7",
    ],
    "Stockade 01 To Stockade 02": ["Map.map_oubliette_01.2", "Map.map_oubliette_01.F7"],
    "Stockade 02 To Stockade 01": ["Map.map_oubliette_02.1"],
    "Stockade 02 To Stockade 05": ["Map.map_oubliette_02.5"],
    "Stockade 02 To Stockade 04": ["Map.map_oubliette_02.4"],
    "Stockade 03 To Stockade 04": ["Map.map_oubliette_03.4", "Map.map_oubliette_03.10"],
    "Stockade 03 To Stockade 10": [
        "Map.map_oubliette_03.4",
        "Map.map_oubliette_03.10",
        "Map.map_oubliette_03.5",
    ],
    "Stockade 03 To Stockade 05": ["Map.map_oubliette_03.10", "Map.map_oubliette_03.5"],
    "Stockade 04 To Stockade 03": ["Map.map_oubliette_04.2", "Map.map_oubliette_04.3"],
    "Stockade 04 To Stockade 02": ["Map.map_oubliette_04.2", "Map.map_oubliette_04.3"],
    "Stockade 05_1 To Stockade 05": ["Map.map_oubliette_05_1.5"],
    "Stockade 05_2 To Stockade 05 Left": [
        "Map.map_oubliette_05_2.5",
        "Map.map_oubliette_05_2.5B",
    ],
    "Stockade 05_2 To Stockade 05 Right": [
        "Map.map_oubliette_05_2.5",
        "Map.map_oubliette_05_2.5B",
    ],
    "Stockade 05_3 To Stockade 05": ["Map.map_oubliette_05_3.5"],
    "Stockade 05 To Stockade 05_2 Left": [
        "Map.map_oubliette_05.5_1",
        "Map.map_oubliette_05.5_2",
    ],
    "Stockade 05 To Stockade 05_3": [
        "Map.map_oubliette_05.5_3",
        "Map.map_oubliette_05.2",
    ],
    "Stockade 05 To Stockade 07_2": [
        "Map.map_oubliette_05.7_2",
        "Map.map_oubliette_05.5_1",
    ],
    "Stockade 05 To Stockade 05_1": [
        "Map.map_oubliette_05.2",
        "Map.map_oubliette_05.5_1",
    ],
    "Stockade 05 To Stockade 07_1": [
        "Map.map_oubliette_05.7_1",
        "Map.map_oubliette_05.2",
    ],
    "Stockade 05 To Stockade 02": [
        "Map.map_oubliette_05.6",
        "Map.map_oubliette_05.2",
        "Map.map_oubliette_05.5_1",
    ],
    "Stockade 05 To Stockade 06": [
        "Map.map_oubliette_05.6",
        "Map.map_oubliette_05.5_2B",
    ],
    "Stockade 05 To Stockade 03": ["Map.map_oubliette_05.2", "Map.map_oubliette_05.3"],
    "Stockade 05 To Stockade 05_2 Right": ["Map.map_oubliette_05.5_2B"],
    "Stockade 06_1 To Stockade 07": ["Map.map_oubliette_06_1.7"],
    "Stockade 06_2 To Stockade 07": ["Map.map_oubliette_06_2.7"],
    "Stockade 06_3 To Stockade 07": ["Map.map_oubliette_06_3.7"],
    "Stockade 06_4 To Stockade 07": ["Map.map_oubliette_06_4.7"],
    "Stockade 06 To Stockade 05": ["Map.map_oubliette_06.10", "Map.map_oubliette_06.5"],
    "Stockade 06 To Stockade 07": ["Map.map_oubliette_06.10", "Map.map_oubliette_06.7"],
    "Stockade 06 To Stockade 10": [
        "Map.map_oubliette_06.10",
        "Map.map_oubliette_06.7",
        "Map.map_oubliette_06.5",
    ],
    "Stockade 07_1 To Stockade 05": ["Map.map_oubliette_07_1.5"],
    "Stockade 07_2 To Stockade 05": ["Map.map_oubliette_07_2.5"],
    "Stockade 07 To Stockade 06_1": [
        "Map.map_oubliette_07.6_1",
        "Map.map_oubliette_07.9",
    ],
    "Stockade 07 To Stockade 06_3": [
        "Map.map_oubliette_07.6_3",
        "Map.map_oubliette_07.9",
    ],
    "Stockade 07 To Stockade 06_2": [
        "Map.map_oubliette_07.6_2",
        "Map.map_oubliette_07.9",
    ],
    "Stockade 07 To Stockade 06_4": [
        "Map.map_oubliette_07.6_4",
        "Map.map_oubliette_07.6_3",
    ],
    "Stockade 07 To Stockade 06": ["Map.map_oubliette_07.6"],
    "Stockade 07 To Stockade 13": ["Map.map_oubliette_07.9", "Map.map_oubliette_07.13"],
    "Stockade 07 To Stockade 09": [
        "Map.map_oubliette_07.6_1",
        "Map.map_oubliette_07.6_3",
        "Map.map_oubliette_07.6",
        "Map.map_oubliette_07.6_2",
        "Map.map_oubliette_07.9",
        "Map.map_oubliette_07.13",
    ],
    "Stockade 08 To Stockade 11": ["Map.map_oubliette_08.9", "Map.map_oubliette_08.11"],
    "Stockade 08 To Stockade 09": [
        "Map.map_oubliette_08.9",
        "Map.map_oubliette_08.11",
        "Map.map_oubliette_08.13",
    ],
    "Stockade 08 To Stockade 13": [
        "Map.map_oubliette_08.11",
        "Map.map_oubliette_08.13",
    ],
    "Stockade 09 To Stockade 08": ["Map.map_oubliette_09.7", "Map.map_oubliette_09.8"],
    "Stockade 09 To Stockade 10": ["Map.map_oubliette_09.10", "Map.map_oubliette_09.7"],
    "Stockade 09 To Stockade 07": ["Map.map_oubliette_09.10", "Map.map_oubliette_09.7"],
    "Stockade 10 To Stockade 09": ["Map.map_oubliette_10.9"],
    "Stockade 10 To Stockade 03": ["Map.map_oubliette_10.3"],
    "Stockade 10 To Stockade 17": ["Map.map_oubliette_10.17"],
    "Stockade 10 To Stockade 06": ["Map.map_oubliette_10.6"],
    "Stockade 11 To Stockade 12": [
        "Map.map_oubliette_11.12",
        "Map.map_oubliette_11.13_1",
        "Map.map_oubliette_11.13",
    ],
    "Stockade 11 To Stockade 08": [
        "Map.map_oubliette_11.8",
        "Map.map_oubliette_11.12",
        "Map.map_oubliette_11.14",
        "Map.map_oubliette_11.13",
        "Map.map_oubliette_11.13_1",
    ],
    "Stockade 11 To Stockade 14": ["Map.map_oubliette_11.8", "Map.map_oubliette_11.14"],
    "Stockade 11 To Stockade 13": [
        "Map.map_oubliette_11.8",
        "Map.map_oubliette_11.14",
        "Map.map_oubliette_11.13",
    ],
    "Stockade 11 To Stockade 13_2": [
        "Map.map_oubliette_11.13_2",
        "Map.map_oubliette_11.13",
    ],
    "Stockade 11 To Stockade 13_1": [
        "Map.map_oubliette_11.13",
        "Map.map_oubliette_11.13_1",
    ],
    "Stockade 12 To Stockade 11": ["Map.map_oubliette_12.11"],
    "Stockade 13_1 To Stockade 11": ["Map.map_oubliette_13_1.11"],
    "Stockade 13_2 To Stockade 11": ["Map.map_oubliette_13_2.11"],
    "Stockade 13 To Stockade 08": ["Map.map_oubliette_13.11", "Map.map_oubliette_13.8"],
    "Stockade 13 To Stockade 11": ["Map.map_oubliette_13.7", "Map.map_oubliette_13.11"],
    "Stockade 13 To Stockade 07": ["Map.map_oubliette_13.7", "Map.map_oubliette_13.11"],
    "Stockade 14 To Stockade 11": ["Map.map_oubliette_14.11"],
    "Stockade 14 To Stockade 15": ["Map.map_oubliette_14.15"],
    "Stockade 15 To Stockade 14": [
        "Map.map_oubliette_15.14",
        "Map.map_oubliette_15.16",
    ],
    "Stockade 15 To Stockade 16": [
        "Map.map_oubliette_15.14",
        "Map.map_oubliette_15.16",
    ],
    "Stockade 16 To Stockade 15": [
        "Map.map_oubliette_16.15",
        "Map.map_oubliette_16.O1",
    ],
    "Stockade 16 To Hinterlands 01": [
        "Map.map_oubliette_16.15",
        "Map.map_oubliette_16.O1",
    ],
    "Stockade 17 To Stockade 10": ["Map.map_oubliette_17.10"],
    "Stockade 17 To Verboten Domain 06": [
        "Map.map_oubliette_17.10",
        "Map.map_oubliette_17.S6",
    ],
    "Hinterlands 01 To Hinterlands 02": [
        "Map.map_outside_01.3",
        "Map.map_outside_01.O16",
        "Map.map_outside_01.2",
    ],
    "Hinterlands 01 To Hinterlands 03": [
        "Map.map_outside_01.3",
        "Map.map_outside_01.2",
    ],
    "Hinterlands 01 To Stockade 16": ["Map.map_outside_01.O16"],
    "Hinterlands 02 To Hinterlands 01": ["Map.map_outside_02.1"],
    "Hinterlands 03 To Hinterlands 01": [
        "Map.map_outside_03.1",
        "Map.map_outside_03.F9",
    ],
    "Hinterlands 03 To Twin Spires 09": ["Map.map_outside_03.F9"],
    "Verboten Domain 04 To Verboten Domain 05": [
        "Map.map_swamp_04.5",
        "Map.map_swamp_04.3",
    ],
    "Verboten Domain 04 To Verboten Domain 3R": [
        "Map.map_swamp_04.5",
        "Map.map_swamp_04.3",
    ],
    "Verboten Domain 05 To Verboten Domain 04": [
        "Map.map_swamp_05.6",
        "Map.map_swamp_05.4",
    ],
    "Verboten Domain 05 To Verboten Domain 06": [
        "Map.map_swamp_05.6",
        "Map.map_swamp_05.4",
        "Map.map_swamp_05.9",
    ],
    "Verboten Domain 05 To Verboten Domain 07": [
        "Map.map_swamp_05.9",
        "Map.map_swamp_05.7",
    ],
    "Verboten Domain 05 To Verboten Domain 09": [
        "Map.map_swamp_05.6",
        "Map.map_swamp_05.9",
    ],
    "Verboten Domain 06 To Verboten Domain 05": ["Map.map_swamp_06.5"],
    "Verboten Domain 06 To Stockade 17": ["Map.map_swamp_06.O17"],
    "Verboten Domain 07 To Verboten Domain 16": [
        "Map.map_swamp_07.3",
        "Map.map_swamp_07.16",
        "Map.map_swamp_07.8",
        "Map.map_swamp_07.5",
    ],
    "Verboten Domain 07 To Verboten Domain 05": ["Map.map_swamp_07.5"],
    "Verboten Domain 07 To Verboten Domain 08": ["Map.map_swamp_07.8"],
    "Verboten Domain 07 To Verboten Domain 3B": ["Map.map_swamp_07.3"],
    "Verboten Domain 08 To Verboten Domain 07": [
        "Map.map_swamp_08.15",
        "Map.map_swamp_08.7",
    ],
    "Verboten Domain 08 To Verboten Domain 15": [
        "Map.map_swamp_08.15",
        "Map.map_swamp_08.14",
        "Map.map_swamp_08.7",
    ],
    "Verboten Domain 08 To Verboten Domain 14": [
        "Map.map_swamp_08.15",
        "Map.map_swamp_08.14",
    ],
    "Verboten Domain 09 To Verboten Domain 13 Left": [
        "Map.map_swamp_09.13",
        "Map.map_swamp_09.3",
    ],
    "Verboten Domain 09 To Verboten Domain 03": [
        "Map.map_swamp_09.3",
        "Map.map_swamp_09.5",
    ],
    "Verboten Domain 09 To Verboten Domain 13 Right": [
        "Map.map_swamp_09.5",
        "Map.map_swamp_09.13B",
    ],
    "Verboten Domain 09 To Verboten Domain 05": [
        "Map.map_swamp_09.5",
        "Map.map_swamp_09.3",
    ],
    "Verboten Domain 01 To Verboten Domain 03": ["Map.map_swamp_01.3"],
    "Verboten Domain 01 To Verboten Domain 02": ["Map.map_swamp_01.2"],
    "Verboten Domain 10 To Verboten Domain 13": ["Map.map_swamp_10.13"],
    "Verboten Domain 11 To Verboten Domain 15": [
        "Map.map_swamp_11.14",
        "Map.map_swamp_11.15",
    ],
    "Verboten Domain 11 To Verboten Domain 14": [
        "Map.map_swamp_11.14",
        "Map.map_swamp_11.15",
    ],
    "Verboten Domain 12 To Verboten Domain 15": ["Map.map_swamp_12.15"],
    "Verboten Domain 12 To The Abyss 04": ["Map.map_swamp_12.4"],
    "Verboten Domain 13 To Verboten Domain 10": [
        "Map.map_swamp_13.9B",
        "Map.map_swamp_13.10",
        "Map.map_swamp_13.9",
    ],
    "Verboten Domain 13 To Verboten Domain 09 Left": [
        "Map.map_swamp_13.14",
        "Map.map_swamp_13.9",
    ],
    "Verboten Domain 13 To Verboten Domain 09 Right": ["Map.map_swamp_13.9B"],
    "Verboten Domain 13 To Verboten Domain 14": [
        "Map.map_swamp_13.14",
        "Map.map_swamp_13.10",
        "Map.map_swamp_13.9",
    ],
    "Verboten Domain 14 To Verboten Domain 13": [
        "Map.map_swamp_14.13",
        "Map.map_swamp_14.8",
    ],
    "Verboten Domain 14 To Verboten Domain 11": [
        "Map.map_swamp_14.11",
        "Map.map_swamp_14.13",
        "Map.map_swamp_14.8",
    ],
    "Verboten Domain 14 To Verboten Domain 08": [
        "Map.map_swamp_14.11",
        "Map.map_swamp_14.8",
    ],
    "Verboten Domain 15 To Verboten Domain 11": [
        "Map.map_swamp_15.11",
        "Map.map_swamp_15.12",
    ],
    "Verboten Domain 15 To Verboten Domain 08": [
        "Map.map_swamp_15.12",
        "Map.map_swamp_15.8",
    ],
    "Verboten Domain 15 To Verboten Domain 12": [
        "Map.map_swamp_15.11",
        "Map.map_swamp_15.12",
        "Map.map_swamp_15.8",
    ],
    "Verboten Domain 16 To Verboten Domain 07": ["Map.map_swamp_16.7"],
    "Verboten Domain 16 To Verboten Domain 17": ["Map.map_swamp_16.17"],
    "Verboten Domain 17 To Verboten Domain 18": [
        "Map.map_swamp_17.18",
        "Map.map_swamp_17.16",
    ],
    "Verboten Domain 17 To Verboten Domain 16": [
        "Map.map_swamp_17.16",
        "Map.map_swamp_17.18",
    ],
    "Verboten Domain 18 To The Abyss 01": ["Map.map_swamp_18.A1"],
    "Verboten Domain 18 To Verboten Domain 17": ["Map.map_swamp_18.17"],
    "Verboten Domain 02 To Verboten Domain 01": [
        "Map.map_swamp_02.1",
        "Map.map_swamp_02.F9",
    ],
    "Verboten Domain 02 To Witch's Thicket 09": [
        "Map.map_swamp_02.1",
        "Map.map_swamp_02.F9",
    ],
    "Verboten Domain 03 To Verboten Domain 09": [
        "Map.map_swamp_03.9",
        "Map.map_swamp_03.7",
    ],
    "Verboten Domain 03 To Verboten Domain 01": [
        "Map.map_swamp_03.9",
        "Map.map_swamp_03.1",
    ],
    "Verboten Domain 03 To Verboten Domain 04": [
        "Map.map_swamp_03.1",
        "Map.map_swamp_03.7",
        "Map.map_swamp_03.4",
    ],
    "Verboten Domain 03 To Verboten Domain 07": [
        "Map.map_swamp_03.1",
        "Map.map_swamp_03.7",
        "Map.map_swamp_03.4",
    ],
    "Cliffside Hamlet 01 To Cliffside Hamlet 02": [
        "Map.map_village_01.0",
        "Map.map_village_01.1",
    ],
    "Cliffside Hamlet 01 To White Parish 08": [
        "Map.map_village_01.0",
        "Map.map_village_01.1",
    ],
    "Cliffside Hamlet 02 To Cliffside Hamlet 03": [
        "Map.map_village_02.1",
        "Map.map_village_02.0",
        "Map.map_village_02.13",
    ],
    "Cliffside Hamlet 02 To Cliffside Hamlet 01": [
        "Map.map_village_02.13",
        "Map.map_village_02.0",
    ],
    "Cliffside Hamlet 02 To Cliffside Hamlet 13": [
        "Map.map_village_02.13",
        "Map.map_village_02.1",
    ],
    "Cliffside Hamlet 03 To Cliffside Hamlet 02": [
        "Map.map_village_03.0",
        "Map.map_village_03.5",
    ],
    "Cliffside Hamlet 03 To Cliffside Hamlet 05": [
        "Map.map_village_03.0",
        "Map.map_village_03.5",
    ],
    "Cliffside Hamlet 03 To Cliffside Hamlet 13": [
        "Map.map_village_03.2",
        "Map.map_village_03.5",
    ],
    "Cliffside Hamlet 04_1 To Cliffside Hamlet 04": ["Map.map_village_04_1.0"],
    "Cliffside Hamlet 04 To Cliffside Hamlet 04": [
        "Map.map_village_04.5",
        "Map.map_village_04.2",
    ],
    "Cliffside Hamlet 04 To Cliffside Hamlet 05": [
        "Map.map_village_04.5",
        "Map.map_village_04.2",
    ],
    "Cliffside Hamlet 05 To Cliffside Hamlet 04": ["Map.map_village_05.4"],
    "Cliffside Hamlet 05 To Cliffside Hamlet 03": ["Map.map_village_05.3"],
    "Cliffside Hamlet 05 To Cliffside Hamlet 06": ["Map.map_village_05.1"],
    "Cliffside Hamlet 06 To Cliffside Hamlet 05": [
        "Map.map_village_06.0",
        "Map.map_village_06.8",
    ],
    "Cliffside Hamlet 06 To Cliffside Hamlet 07": [
        "Map.map_village_06.1",
        "Map.map_village_06.8",
    ],
    "Cliffside Hamlet 06 To Cliffside Hamlet 12": [
        "Map.map_village_06.0",
        "Map.map_village_06.12",
    ],
    "Cliffside Hamlet 06 To Cliffside Hamlet 08": [
        "Map.map_village_06.0",
        "Map.map_village_06.1",
        "Map.map_village_06.8",
    ],
    "Cliffside Hamlet 07 To Cliffside Hamlet 06": [
        "Map.map_village_07.9",
        "Map.map_village_07.0",
    ],
    "Cliffside Hamlet 07 To Cliffside Hamlet 09": [
        "Map.map_village_07.0",
        "Map.map_village_07.9",
        "Map.map_village_07.14",
    ],
    "Cliffside Hamlet 07 To Cliffside Hamlet 14": [
        "Map.map_village_07.9",
        "Map.map_village_07.14",
    ],
    "Cliffside Hamlet 08 To Cliffside Hamlet 06": [
        "Map.map_village_08.9",
        "Map.map_village_08.6",
    ],
    "Cliffside Hamlet 08 To Cliffside Hamlet 09": [
        "Map.map_village_08.9",
        "Map.map_village_08.6",
    ],
    "Cliffside Hamlet 09 To Cliffside Hamlet 10": ["Map.map_village_09.1"],
    "Cliffside Hamlet 09 To Cliffside Hamlet 15": ["Map.map_village_09.2"],
    "Cliffside Hamlet 09 To Cliffside Hamlet 07": ["Map.map_village_09.7"],
    "Cliffside Hamlet 09 To Cliffside Hamlet 08": ["Map.map_village_09.8"],
    "Cliffside Hamlet 11_1 To Cliffside Hamlet 11": ["Map.map_village_11_1.0"],
    "Cliffside Hamlet 11 To Cliffside Hamlet 11_1": [
        "Map.map_village_11.0",
        "Map.map_village_11.2",
    ],
    "Cliffside Hamlet 11 To Cliffside Hamlet 10": [
        "Map.map_village_11.1",
        "Map.map_village_11.0",
    ],
    "Cliffside Hamlet 11 To Ruined Castle 01": [
        "Map.map_village_11.1",
        "Map.map_village_11.0",
    ],
    "Cliffside Hamlet 12 To Cliffside Hamlet 06": ["Map.map_village_12.6"],
    "Cliffside Hamlet 12 To Cliffside Hamlet 13": [
        "Map.map_village_12.6",
        "Map.map_village_12.13",
        "Map.map_village_12.C1",
    ],
    "Cliffside Hamlet 12 To Catacombs 01": [
        "Map.map_village_12.6",
        "Map.map_village_12.13",
        "Map.map_village_12.C1",
    ],
    "Cliffside Hamlet 12 To Cliffside Hamlet 16": [
        "Map.map_village_12.16",
        "Map.map_village_12.13",
    ],
    "Cliffside Hamlet 13 To Cliffside Hamlet 03": [
        "Map.map_village_13.0",
        "Map.map_village_13.12",
    ],
    "Cliffside Hamlet 13 To Cliffside Hamlet 02": [
        "Map.map_village_13.12",
        "Map.map_village_13.2",
    ],
    "Cliffside Hamlet 13 To Cliffside Hamlet 12": [
        "Map.map_village_13.0",
        "Map.map_village_13.12",
    ],
    "Cliffside Hamlet 14 To Cliffside Hamlet 07": ["Map.map_village_14.7"],
    "Cliffside Hamlet 15 To Cliffside Hamlet 09": [
        "Map.map_village_15.F1",
        "Map.map_village_15.0",
    ],
    "Cliffside Hamlet 15 To Twin Spires 01": [
        "Map.map_village_15.F1",
        "Map.map_village_15.0",
    ],
    "Cliffside Hamlet 16 To Cliffside Hamlet 12": ["Map.map_village_16.12"],
}
