from typing import Optional, Dict
from enum import Enum
from BaseClasses import ItemClassification as IC


class ItemGroup(Enum):
    """
    Used to group items
    """
    Action  = 0
    Residue = 1
    Amulet  = 2
    Relic   = 3
    Spirit  = 4
    Finding = 5
    Misc    = 6

class ItemData():
    key: str
    code: Optional[int]
    count: Optional[int]
    classification: IC
    item_group: Optional[ItemGroup]
    unused: bool

    def __init__(self, key: str, code:Optional[int]=None,
                 group:Optional[ItemGroup]=None, count: Optional[int]=1,
                classification:IC=IC.filler, unused:bool=False):
        self.key = key
        self.code = code
        self.count = count
        self.classification = classification
        self.unused = unused
        self.item_group = group

items : Dict[str, ItemData] = {
	"Guardian's Wings"                    : ItemData('Aptitude.Dodge',                                code=0x7171e5, count=1 , group=ItemGroup.Action , classification=IC.progression),
	"Executioner's Hook"                  : ItemData('Aptitude.Hook',                                 code=0x7171e6, count=1 , group=ItemGroup.Action , classification=IC.progression),
	"Dash"                                : ItemData('Aptitude.dash',                                 code=0x7171e7, count=1 , group=ItemGroup.Action , classification=IC.progression),
	"Piercing Spectral Lance"             : ItemData('Aptitude.dash_attack',                          code=0x7171e8, count=1 , group=ItemGroup.Action , classification=IC.progression),
	"Witch's Bubble"                      : ItemData('Aptitude.dive',                                 code=0x7171e9, count=1 , group=ItemGroup.Action , classification=IC.progression),
	"Unlock"                              : ItemData('Aptitude.door_unlock',                          code=0x7171ea, count=1 , group=ItemGroup.Action , classification=IC.progression),
	"Guardian's Leap"                     : ItemData('Aptitude.double_jump',                          code=0x7171eb, count=1 , group=ItemGroup.Action , classification=IC.progression),
	"Giant's Hammer"                      : ItemData('Aptitude.pound_attack',                         code=0x7171ec, count=1 , group=ItemGroup.Action , classification=IC.progression),
	"Last Rites"                          : ItemData('Aptitude.special_attack',                       code=0x7171ed, count=1 , group=ItemGroup.Action , classification=IC.progression),
	"Bloody Knight's Claws"               : ItemData('Aptitude.wallgrab',                             code=0x7171ee, count=1 , group=ItemGroup.Action , classification=IC.progression),
	"Stone Tablet Fragment"               : ItemData('Generic.i_FinalPassivePart_Up',                 code=0x7171ef, count=7 , group=ItemGroup.Misc   , classification=IC.progression),
	"Priestess' Wish"                     : ItemData('Generic.i_HealPower_Up',                        code=0x7171f0, count=8 , group=ItemGroup.Misc   , classification=IC.useful),
	"Chain of Sorcery"                    : ItemData('Generic.i_PassiveSlot_Up',                      code=0x7171f1, count=18, group=ItemGroup.Misc   , classification=IC.useful),
	"Stagnant Blight x100"                : ItemData('Generic.i_SpiritCurrencyLv1_L',                 code=0x7171f2, count=12, group=ItemGroup.Residue, classification=IC.useful),
	"Stagnant Blight x800"                : ItemData('Generic.i_SpiritCurrencyLv1_LL',                code=0x7171f3, count=5 , group=ItemGroup.Residue, classification=IC.useful),
	"Stagnant Blight x30"                 : ItemData('Generic.i_SpiritCurrencyLv1_M',                 code=0x7171f4, count=26, group=ItemGroup.Residue, classification=IC.useful),
	"Stagnant Blight x10"                 : ItemData('Generic.i_SpiritCurrencyLv1_S',                 code=0x7171f5, count=49, group=ItemGroup.Residue, classification=IC.useful),
	"Furious Blight x100"                 : ItemData('Generic.i_SpiritCurrencyLv2_L',                 code=0x7171f6, count=5 , group=ItemGroup.Residue, classification=IC.useful),
	"Furious Blight x800"                 : ItemData('Generic.i_SpiritCurrencyLv2_LL',                code=0x7171f7, count=2 , group=ItemGroup.Residue, classification=IC.useful),
	"Furious Blight x30"                  : ItemData('Generic.i_SpiritCurrencyLv2_M',                 code=0x7171f8, count=11, group=ItemGroup.Residue, classification=IC.useful),
	"Furious Blight x10"                  : ItemData('Generic.i_SpiritCurrencyLv2_S',                 code=0x7171f9, count=19, group=ItemGroup.Residue, classification=IC.useful),
	"Ancient Soul x1"                     : ItemData('Generic.i_SpiritCurrencyLv3_1',                 code=0x7171fa, count=1 , group=ItemGroup.Residue, classification=IC.useful),
	"Ancient Soul x2"                     : ItemData('Generic.i_SpiritCurrencyLv3_2',                 code=0x7171fb, count=2 , group=ItemGroup.Residue, classification=IC.useful),
	"Amulet Fragment"                     : ItemData('Parameter.i_maxHPUp_01',                        code=0x7171fc, count=36, group=ItemGroup.Amulet , classification=IC.useful),
	"Amulet Gem"                          : ItemData('Parameter.i_maxHPUp_02',                        code=0x7171fd, count=6 , group=ItemGroup.Amulet , classification=IC.useful),
	"Amulet Jewel"                        : ItemData('Parameter.i_maxHPUp_03',                        code=0x7171fe, count=1 , group=ItemGroup.Amulet , classification=IC.useful, unused=True),
	"Broken Music Box"                    : ItemData('Passive.i_passive_dmgcut_LV1',                  code=0x7171ff, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Cracked Familiar Stone"              : ItemData('Passive.i_passive_dmgcut_LV2',                  code=0x717200, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Snowdrop Bracelet"                   : ItemData('Passive.i_passive_dmgcut_LV3',                  code=0x717201, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Blighted Appendage"                  : ItemData('Passive.i_passive_dmgup',                       code=0x717202, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Ancient Dragon Claw"                 : ItemData('Passive.i_passive_dmgup_airborne',              code=0x717203, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Unused Relic 1"                      : ItemData('Passive.i_passive_dmgup_airborne_LV2',          code=0x717204, count=1 , group=ItemGroup.Relic  , classification=IC.useful, unused=True),
	"Giant's Ring"                        : ItemData('Passive.i_passive_dmgup_grounded',              code=0x717205, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Unused Relic 2"                      : ItemData('Passive.i_passive_dmgup_grounded_LV2',          code=0x717206, count=1 , group=ItemGroup.Relic  , classification=IC.useful, unused=True),
	"Executioner's Gloves"                : ItemData('Passive.i_passive_dmgup_maxhp',                 code=0x717207, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Rusted Blue Ornament"                : ItemData('Passive.i_passive_dmgup_swimming',              code=0x717208, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Bloodstained Ribbon"                 : ItemData('Passive.i_passive_expup_1',                     code=0x717209, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Blightwreathed Blade"                : ItemData('Passive.i_passive_expup_2',                     code=0x71720a, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"White Priestess Statue"              : ItemData('Passive.i_passive_heal_count_up_1',             code=0x71720b, count=1 , group=ItemGroup.Relic  , classification=IC.progression),
	"White Priestess' Earrings"           : ItemData('Passive.i_passive_heal_count_up_2',             code=0x71720c, count=1 , group=ItemGroup.Relic  , classification=IC.progression),
	"Priestess' Doll"                     : ItemData('Passive.i_passive_heal_count_up_3',             code=0x71720d, count=1 , group=ItemGroup.Relic  , classification=IC.progression),
	"Holy Spring Water"                   : ItemData('Passive.i_passive_heal_power_up',               code=0x71720e, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Heretic's Mask"                      : ItemData('Passive.i_passive_ignore_damage_area',          code=0x71720f, count=1 , group=ItemGroup.Relic  , classification=IC.progression),
	"Vibrant Plume"                       : ItemData('Passive.i_passive_jump_height_up',              code=0x717210, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Soiled Prayer Beads"                 : ItemData('Passive.i_passive_maxhpup_LV1',                 code=0x717211, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Royal Aegis Crest"                   : ItemData('Passive.i_passive_maxhpup_LV2',                 code=0x717212, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Unused Relic 3"                      : ItemData('Passive.i_passive_maxhpup_LV3',                 code=0x717213, count=1 , group=ItemGroup.Relic  , classification=IC.useful, unused=True),
	"Ricorus' Ring"                       : ItemData('Passive.i_passive_maxmpup',                     code=0x717214, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Spellbound Anklet"                   : ItemData('Passive.i_passive_move_speed_up',               code=0x717215, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Eldred's Ring"                       : ItemData('Passive.i_passive_mp_restore_up_LV1',           code=0x717216, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Lost Heirloom"                       : ItemData('Passive.i_passive_override_skin_level',         code=0x717217, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Blighted Phantom"                    : ItemData('Passive.i_passive_override_skin_level_max',     code=0x717218, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Fretia's Ring"                       : ItemData('Passive.i_passive_parry',                       code=0x717219, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Iris' Ring"                          : ItemData('Passive.i_passive_post_damage_invincibility',   code=0x71721a, count=1 , group=ItemGroup.Relic  , classification=IC.useful, unused=True),
	"Kilteus' Ring"                       : ItemData('Passive.i_passive_recast_time_cut_LV1',         code=0x71721b, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Calivia's Ring"                      : ItemData('Passive.i_passive_recast_time_cut_LV2',         code=0x71721c, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Unused Relic 4"                      : ItemData('Passive.i_passive_recast_time_cut_LV3',         code=0x71721d, count=1 , group=ItemGroup.Relic  , classification=IC.useful, unused=True),
	"Immortal's Crest"                    : ItemData('Passive.i_passive_regenHP_attack',              code=0x71721e, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Weathered Necklace"                  : ItemData('Passive.i_passive_regenHP_kill',                code=0x71721f, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Nymphilia's Ring"                    : ItemData('Passive.i_passive_shortheal',                   code=0x717220, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Manisa's Ring"                       : ItemData('Passive.i_passive_spirit_maxcast_count_up_LV1', code=0x717221, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Aura's Ring"                         : ItemData('Passive.i_passive_spirit_maxcast_count_up_LV2', code=0x717222, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Unused Relic 5"                      : ItemData('Passive.i_passive_spirit_maxcast_count_up_LV3', code=0x717223, count=1 , group=ItemGroup.Relic  , classification=IC.useful, unused=True),
	"Unused Relic 6"                      : ItemData('Passive.i_passive_stamina_up',                  code=0x717224, count=1 , group=ItemGroup.Relic  , classification=IC.useful, unused=True),
	"Decayed Crown"                       : ItemData('Passive.i_passive_stunstamina_damage_up',       code=0x717225, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Ruined Witch's Book"                 : ItemData('Passive.i_passive_swim_fast',                   code=0x717226, count=1 , group=ItemGroup.Relic  , classification=IC.useful),
	"Headless Defender"                   : ItemData('Spirit.s2002',                                  code=0x717227, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Cliffside Hamlet Youth"              : ItemData('Spirit.s2012',                                  code=0x717228, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Fallen Archer"                       : ItemData('Spirit.s2022',                                  code=0x717229, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"One-Eyed Royal Aegis"                : ItemData('Spirit.s2032',                                  code=0x71722a, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Incompetent Sinner"                  : ItemData('Spirit.s2052',                                  code=0x71722b, count=1 , group=ItemGroup.Spirit , classification=IC.progression),
	"Hidden Test Subject"                 : ItemData('Spirit.s2072',                                  code=0x71722c, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Castle Town Maiden"                  : ItemData('Spirit.s2082',                                  code=0x71722d, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Chief Guardian"                      : ItemData('Spirit.s2092',                                  code=0x71722e, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Western Merchant"                    : ItemData('Spirit.s2102',                                  code=0x71722f, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Cliffside Hamlet Elder"              : ItemData('Spirit.s2112',                                  code=0x717230, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Fungal Sorcerer"                     : ItemData('Spirit.s2122',                                  code=0x717231, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Floral Sorceress"                    : ItemData('Spirit.s2132',                                  code=0x717232, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Elder Crypt Keeper"                  : ItemData('Spirit.s2162',                                  code=0x717233, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Verboten Champion"                   : ItemData('Spirit.s2172',                                  code=0x717234, count=1 , group=ItemGroup.Spirit , classification=IC.progression),
	"Dark Executioner"                    : ItemData('Spirit.s2182',                                  code=0x717235, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Fallen Sentinel"                     : ItemData('Spirit.s2192',                                  code=0x717236, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Forsaken Fellwyrm"                   : ItemData('Spirit.s2232',                                  code=0x717237, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Umbral Knight"                       : ItemData('Spirit.s5000',                                  code=0x717238, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Guardian Siegrid"                    : ItemData('Spirit.s5010',                                  code=0x717239, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Guardian Silva"                      : ItemData('Spirit.s5020',                                  code=0x71723a, count=1 , group=ItemGroup.Spirit , classification=IC.progression),
	"Knight Captain Julius"               : ItemData('Spirit.s5030',                                  code=0x71723b, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Dark Witch Eleine"                   : ItemData('Spirit.s5040',                                  code=0x71723c, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Gerrod, the Elder Warrior"           : ItemData('Spirit.s5050',                                  code=0x71723d, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Hoenir, Keeper of the Abyss"         : ItemData('Spirit.s5060',                                  code=0x71723e, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Ulv, the Mad Knight"                 : ItemData('Spirit.s5070',                                  code=0x71723f, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Faden, the Heretic"                  : ItemData('Spirit.s5080',                                  code=0x717240, count=1 , group=ItemGroup.Spirit , classification=IC.useful),
	"Statue Inscription"                  : ItemData('Tip.tip_001',                                   code=0x717241, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Eleine's Letter"                     : ItemData('Tip.tip_002',                                   code=0x717242, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"On the Blighted 1"                   : ItemData('Tip.tip_003',                                   code=0x717243, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"On the Blighted 2"                   : ItemData('Tip.tip_004',                                   code=0x717244, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Groa's Letter"                       : ItemData('Tip.tip_005',                                   code=0x717245, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Hamlet Scrawl"                       : ItemData('Tip.tip_006',                                   code=0x717246, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Hamlet Request 1"                    : ItemData('Tip.tip_007',                                   code=0x717247, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Hamlet Request 2"                    : ItemData('Tip.tip_008',                                   code=0x717248, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"True Believer's Note"                : ItemData('Tip.tip_009',                                   code=0x717249, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Coven Handbook"                      : ItemData('Tip.tip_010',                                   code=0x71724a, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Lover's Letter"                      : ItemData('Tip.tip_011',                                   code=0x71724b, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Tarnished Picture"                   : ItemData('Tip.tip_012',                                   code=0x71724c, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Sorcerer's Notes"                    : ItemData('Tip.tip_013',                                   code=0x71724d, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Forbidden Text Scrap"                : ItemData('Tip.tip_014',                                   code=0x71724e, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"The Parish Way 1"                    : ItemData('Tip.tip_015',                                   code=0x71724f, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"The Parish Way 2"                    : ItemData('Tip.tip_016',                                   code=0x717250, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"The Parish Way 3"                    : ItemData('Tip.tip_017',                                   code=0x717251, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Adherent's Letter"                   : ItemData('Tip.tip_018',                                   code=0x717252, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Proof of Founding"                   : ItemData('Tip.tip_019',                                   code=0x717253, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"The Next White Priestess"            : ItemData('Tip.tip_020',                                   code=0x717254, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Defense of the Twin Spires 1"        : ItemData('Tip.tip_021',                                   code=0x717255, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Defense of the Twin Spires 2"        : ItemData('Tip.tip_022',                                   code=0x717256, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"The Heirloom of Land's End"          : ItemData('Tip.tip_023',                                   code=0x717257, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Fretia's Memoirs 1"                  : ItemData('Tip.tip_024',                                   code=0x717258, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Fretia's Memoirs 2"                  : ItemData('Tip.tip_025',                                   code=0x717259, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Fretia's Memoirs 3"                  : ItemData('Tip.tip_026',                                   code=0x71725a, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Fretia's Memoirs 4"                  : ItemData('Tip.tip_027',                                   code=0x71725b, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Fretia's Memoirs 5"                  : ItemData('Tip.tip_028',                                   code=0x71725c, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Silva's Note 1"                      : ItemData('Tip.tip_029',                                   code=0x71725d, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Silva's Note 2"                      : ItemData('Tip.tip_030',                                   code=0x71725e, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Unfinished Note"                     : ItemData('Tip.tip_031',                                   code=0x71725f, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Executioner's Vow"                   : ItemData('Tip.tip_032',                                   code=0x717260, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Slip of Paper"                       : ItemData('Tip.tip_033',                                   code=0x717261, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Executioner's Missive"               : ItemData('Tip.tip_034',                                   code=0x717262, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Report from a Verboten Mage"         : ItemData('Tip.tip_035',                                   code=0x717263, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"White Priestess' Bastion Letter"     : ItemData('Tip.tip_036',                                   code=0x717264, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Bloodied Note 1"                     : ItemData('Tip.tip_037',                                   code=0x717265, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Bloodied Note 2"                     : ItemData('Tip.tip_038',                                   code=0x717266, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Bloodied Note 3"                     : ItemData('Tip.tip_039',                                   code=0x717267, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Monument Engraving"                  : ItemData('Tip.tip_040',                                   code=0x717268, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Note on the Castle Wall"             : ItemData('Tip.tip_041',                                   code=0x717269, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"King of the First Age's Diary 1"     : ItemData('Tip.tip_042',                                   code=0x71726a, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"King of the First Age's Diary 2"     : ItemData('Tip.tip_043',                                   code=0x71726b, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"King of the First Age's Diary 3"     : ItemData('Tip.tip_044',                                   code=0x71726c, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"King of the First Age's Torn Note 1" : ItemData('Tip.tip_045',                                   code=0x71726d, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"King of the First Age's Torn Note 2" : ItemData('Tip.tip_046',                                   code=0x71726e, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Miriel's Blighted Letter"            : ItemData('Tip.tip_047',                                   code=0x71726f, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Verboten Domain Notice"              : ItemData('Tip.tip_048',                                   code=0x717270, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Faden's Archives 1"                  : ItemData('Tip.tip_049',                                   code=0x717271, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Faden's Archives 2"                  : ItemData('Tip.tip_050',                                   code=0x717272, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Faden's Archives 3"                  : ItemData('Tip.tip_051',                                   code=0x717273, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Faden's Archives 4"                  : ItemData('Tip.tip_052',                                   code=0x717274, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Faden's Archives 5"                  : ItemData('Tip.tip_053',                                   code=0x717275, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Faden's Letter"                      : ItemData('Tip.tip_054',                                   code=0x717276, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Eleine's Diary 1"                    : ItemData('Tip.tip_055',                                   code=0x717277, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Eleine's Diary 2"                    : ItemData('Tip.tip_056',                                   code=0x717278, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Eleine's Diary 3"                    : ItemData('Tip.tip_057',                                   code=0x717279, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Hoenir's Diary 1"                    : ItemData('Tip.tip_058',                                   code=0x71727a, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Hoenir's Diary 2"                    : ItemData('Tip.tip_059',                                   code=0x71727b, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Hoenir's Diary 3"                    : ItemData('Tip.tip_060',                                   code=0x71727c, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Writing on the Wall"                 : ItemData('Tip.tip_061',                                   code=0x71727d, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"King's Note 1"                       : ItemData('Tip.tip_062',                                   code=0x71727e, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"King's Note 2"                       : ItemData('Tip.tip_063',                                   code=0x71727f, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Julius' Book"                        : ItemData('Tip.tip_064',                                   code=0x717280, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"The Deathless Pact"                  : ItemData('Tip.tip_065',                                   code=0x717281, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Silva's Blight-Stained Note 1"       : ItemData('Tip.tip_066',                                   code=0x717282, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Silva's Blight-Stained Note 2"       : ItemData('Tip.tip_067',                                   code=0x717283, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Restoring the Aegis Curio"           : ItemData('Tip.tip_068',                                   code=0x717284, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Priestess' Castle Memo"              : ItemData('Tip.tip_069',                                   code=0x717285, count=1 , group=ItemGroup.Finding, classification=IC.filler),
	"Lily's Note"                         : ItemData('Tip.tip_070',                                   code=0x717286, count=1 , group=ItemGroup.Finding, classification=IC.filler),
}
