from enum import Enum


class AELocation(Enum):
    W1L1Noonan = "1-1 Fossil Field Monkey 1 - Noonan"
    W1L1Jorjy = "1-1 Fossil Field Monkey 2 - Jorjy"
    W1L1Nati = "1-1 Fossil Field Monkey 3 - Nati"
    W1L1TrayC = "1-1 Fossil Field Monkey 4 - Tray C"
    W1L2Shay = "1-2 Primordial Ooze Monkey 1 - Shay"
    W1L2DrMonk = "1-2 Primordial Ooze Monkey 2 - Dr. Monk"
    W1L2Grunt = "1-2 Primordial Ooze Monkey 3 - Grunt"
    W1L2Ahchoo = "1-2 Primordial Ooze Monkey 4 - Ah-choo"
    W1L2Gornif = "1-2 Primordial Ooze Monkey 5 - Gornif"
    W1L2Tyrone = "1-2 Primordial Ooze Monkey 6 - Tyrone"
    W1L3Scotty = "1-3 Molten Lava Monkey 1 - Scotty"
    W1L3Coco = "1-3 Molten Lava Monkey 2 - Coco"
    W1L3JThomas = "1-3 Molten Lava Monkey 3 - J. Thomas"
    W1L3Mattie = "1-3 Molten Lava Monkey 4 - Mattie"
    W1L3Barney = "1-3 Molten Lava Monkey 5 - Barney"
    W1L3Rocky = "1-3 Molten Lava Monkey 6 - Rocky"
    W1L3Moggan = "1-3 Molten Lava Monkey 7 - Moggan"
    W2L1Marquez = "2-1 Thick Jungle Monkey 1 - Marquez"
    W2L1Livinston = "2-1 Thick Jungle Monkey 2 - Livinston"
    W2L1George = "2-1 Thick Jungle Monkey 3 - George"
    W2L1Maki = "2-1 Thick Jungle Monkey 4 - Maki"
    W2L1Herb = "2-1 Thick Jungle Monkey 5 - Herb"
    W2L1Dilweed = "2-1 Thick Jungle Monkey 6 - Dilweed"
    W2L1Mitong = "2-1 Thick Jungle Monkey 7 - Mitong"
    W2L1Stoddy = "2-1 Thick Jungle Monkey 8 - Stoddy"
    W2L1Nasus = "2-1 Thick Jungle Monkey 9 - Nasus"
    W2L1Selur = "2-1 Thick Jungle Monkey 10 - Selur"
    W2L1Elehcim = "2-1 Thick Jungle Monkey 11 - Elehcim"
    W2L1Gonzo = "2-1 Thick Jungle Monkey 12 - Gonzo"
    W2L1Alphonse = "2-1 Thick Jungle Monkey 13 - Alphonse"
    W2L1Zanzibar = "2-1 Thick Jungle Monkey 14 - Zanzibar"
    W2L2Mooshy = "2-2 Dark Ruins Monkey 1 - Mooshy"
    W2L2Kyle = "2-2 Dark Ruins Monkey 2 - Kyle"
    W2L2Cratman = "2-2 Dark Ruins Monkey 3 - Cratman"
    W2L2Nuzzy = "2-2 Dark Ruins Monkey 4 - Nuzzy"
    W2L2Mav = "2-2 Dark Ruins Monkey 5 - Mav"
    W2L2Stan = "2-2 Dark Ruins Monkey 6 - Stan"
    W2L2Bernt = "2-2 Dark Ruins Monkey 7 - Bernt"
    W2L2Runt = "2-2 Dark Ruins Monkey 8 - Runt"
    W2L2Hoolah = "2-2 Dark Ruins Monkey 9 - Hoolah"
    W2L2Papou = "2-2 Dark Ruins Monkey 10 - Papou"
    W2L2Kenny = "2-2 Dark Ruins Monkey 11 - Kenny"
    W2L2Trance = "2-2 Dark Ruins Monkey 12 - Trance"
    W2L2Chino = "2-2 Dark Ruins Monkey 13 - Chino"
    W2L3Troopa = "2-3 Cryptic Relics Monkey 1 - Troopa"
    W2L3Spanky = "2-3 Cryptic Relics Monkey 2 - Spanky"
    W2L3Stymie = "2-3 Cryptic Relics Monkey 3 - Stymie"
    W2L3Pally = "2-3 Cryptic Relics Monkey 4 - Pally"
    W2L3Freeto = "2-3 Cryptic Relics Monkey 5 - Freeto"
    W2L3Jesta = "2-3 Cryptic Relics Monkey 6 - Jesta"
    W2L3Bazzle = "2-3 Cryptic Relics Monkey 7 - Bazzle"
    W2L3Crash = "2-3 Cryptic Relics Monkey 8 - Crash"
    W4L1CoolBlue = "4-1 Crabby Beach Monkey 1 - Cool Blue"
    W4L1Sandy = "4-1 Crabby Beach Monkey 2 - Sandy"
    W4L1ShellE = "4-1 Crabby Beach Monkey 3 - Shell E."
    W4L1Gidget = "4-1 Crabby Beach Monkey 4 - Gidget"
    W4L1Shaka = "4-1 Crabby Beach Monkey 5 - Shaka"
    W4L1MaxMahalo = "4-1 Crabby Beach Monkey 6 - MaxMahalo"
    W4L1Moko = "4-1 Crabby Beach Monkey 7 - Moko"
    W4L1Puka = "4-1 Crabby Beach Monkey 8 - Puka"
    W4L2Chip = "4-2 Coral Cave Monkey 1 - Chip"
    W4L2Oreo = "4-2 Coral Cave Monkey 2 - Oreo"
    W4L2Puddles = "4-2 Coral Cave Monkey 3 - Puddles"
    W4L2Kalama = "4-2 Coral Cave Monkey 4 - Kalama"
    W4L2Iz = "4-2 Coral Cave Monkey 5 - Iz"
    W4L2Jux = "4-2 Coral Cave Monkey 6 - Jux"
    W4L2BongBong = "4-2 Coral Cave Monkey 7 - Bong-Bong"
    W4L2Pickles = "4-2 Coral Cave Monkey 8 - Pickles"
    W4L3Stuw = "4-3 Dexters Island Monkey 1 - Stuw"
    W4L3TonTon = "4-3 Dexters Island Monkey 2 - Ton Ton"
    W4L3Murky = "4-3 Dexters Island Monkey 3 - Murky"
    W4L3Howeerd = "4-3 Dexters Island Monkey 4 - Howeerd"
    W4L3Robbin = "4-3 Dexters Island Monkey 5 - Robbin"
    W4L3Jakkee = "4-3 Dexters Island Monkey 6 - Jakkee"
    W4L3Frederic = "4-3 Dexters Island Monkey 7 - Frederic"
    W4L3Baba = "4-3 Dexters Island Monkey 8 - Baba"
    W4L3Mars = "4-3 Dexters Island Monkey 9 - Mars"
    W4L3Horke = "4-3 Dexters Island Monkey 10 - Horke"
    W4L3Quirck = "4-3 Dexters Island Monkey 11 - Quirck"
    W5L1Popcicle = "5-1 Snowy Mammoth Monkey 1 - Popcicle"
    W5L1Iced = "5-1 Snowy Mammoth Monkey 2 - Iced"
    W5L1Denggoy = "5-1 Snowy Mammoth Monkey 3 - Denggoy"
    W5L1Skeens = "5-1 Snowy Mammoth Monkey 4 - Skeens"
    W5L1Rickets = "5-1 Snowy Mammoth Monkey 5 - Rickets"
    W5L1Chilly = "5-1 Snowy Mammoth Monkey 6 - Chilly"
    W5L2Storm = "5-2 Frosty Retreat Monkey 1 - Storm"
    W5L2Qube = "5-2 Frosty Retreat Monkey 2 - Qube"
    W5L2Gash = "5-2 Frosty Retreat Monkey 3 - Gash"
    W5L2Kundra = "5-2 Frosty Retreat Monkey 4 - Kundra"
    W5L2Shadow = "5-2 Frosty Retreat Monkey 5 - Shadow"
    W5L2Ranix = "5-2 Frosty Retreat Monkey 6 - Ranix"
    W5L2Sticky = "5-2 Frosty Retreat Monkey 7 - Sticky"
    W5L2Sharpe = "5-2 Frosty Retreat Monkey 8 - Sharpe"
    W5L2Droog = "5-2 Frosty Retreat Monkey 9 - Droog"
    W5L3Punky = "5-3 Hot Springs Monkey 1 - Punky"
    W5L3Ameego = "5-3 Hot Springs Monkey 2 - Ameego"
    W5L3Roti = "5-3 Hot Springs Monkey 3 - Roti"
    W5L3Dissa = "5-3 Hot Springs Monkey 4 - Dissa"
    W5L3Yoky = "5-3 Hot Springs Monkey 5 - Yoky"
    W5L3Jory = "5-3 Hot Springs Monkey 6 - Jory"
    W5L3Crank = "5-3 Hot Springs Monkey 7 - Crank"
    W5L3Claxter = "5-3 Hot Springs Monkey 8 - Claxter"
    W5L3Looza = "5-3 Hot Springs Monkey 9 - Looza"
    W7L1Taku = "7-1 Sushi Temple Monkey 1 - Taku"
    W7L1Rocka = "7-1 Sushi Temple Monkey 2 - Rocka"
    W7L1Maralea = "7-1 Sushi Temple Monkey 3 - Mara-lea"
    W7L1Wog = "7-1 Sushi Temple Monkey 4 - Wog"
    W7L1Long = "7-1 Sushi Temple Monkey 5 - Long"
    W7L1Mayi = "7-1 Sushi Temple Monkey 6 - Mayi"
    W7L1Owyang = "7-1 Sushi Temple Monkey 7 - Owyang"
    W7L1QuelTin = "7-1 Sushi Temple Monkey 8 - Quel Tin"
    W7L1Phaldo = "7-1 Sushi Temple Monkey 9 - Phaldo"
    W7L1Voti = "7-1 Sushi Temple Monkey 10 - Voti"
    W7L1Elly = "7-1 Sushi Temple Monkey 11 - Elly"
    W7L1Chunky = "7-1 Sushi Temple Monkey 12 - Chunky"
    W7L2Minky = "7-2 Wabi Sabi Wall Monkey 1 - Minky"
    W7L2Zobbro = "7-2 Wabi Sabi Wall Monkey 2 - Zobbro"
    W7L2Xeeto = "7-2 Wabi Sabi Wall Monkey 3 - Xeeto"
    W7L2Moops = "7-2 Wabi Sabi Wall Monkey 4 - Moops"
    W7L2Zanabi = "7-2 Wabi Sabi Wall Monkey 5 - Zanabi"
    W7L2Buddha = "7-2 Wabi Sabi Wall Monkey 6 - Buddha"
    W7L2Fooey = "7-2 Wabi Sabi Wall Monkey 7 - Fooey"
    W7L2Doxs = "7-2 Wabi Sabi Wall Monkey 8 - Doxs"
    W7L2Kong = "7-2 Wabi Sabi Wall Monkey 9 - Kong"
    W7L2Phool = "7-2 Wabi Sabi Wall Monkey 10 - Phool"
    W7L3Naners = "7-3 Crumbling Castle Monkey 1 - Naners"
    W7L3Robart = "7-3 Crumbling Castle Monkey 2 - Robart"
    W7L3Neeners = "7-3 Crumbling Castle Monkey 3 - Neeners"
    W7L3Gustav = "7-3 Crumbling Castle Monkey 4 - Gustav"
    W7L3Wilhelm = "7-3 Crumbling Castle Monkey 5 - Willhelm"
    W7L3Emmanuel = "7-3 Crumbling Castle Monkey 6 - Emmanuel"
    W7L3SirCutty = "7-3 Crumbling Castle Monkey 7 - Sir Cutty"
    W7L3Calligan = "7-3 Crumbling Castle Monkey 8 - Calligan"
    W7L3Castalist = "7-3 Crumbling Castle Monkey 9 - Castalist"
    W7L3Deveneom = "7-3 Crumbling Castle Monkey 10 - Deveneom"
    W7L3Igor = "7-3 Crumbling Castle Monkey 11 - Igor"
    W7L3Charles = "7-3 Crumbling Castle Monkey 12 - Charles"
    W7L3Astur = "7-3 Crumbling Castle Monkey 13 - Astur"
    W7L3Kilserack = "7-3 Crumbling Castle Monkey 14 - Kilserack"
    W7L3Ringo = "7-3 Crumbling Castle Monkey 15 - Ringo"
    W7L3Densil = "7-3 Crumbling Castle Monkey 16 - Densil"
    W7L3Figero = "7-3 Crumbling Castle Monkey 17 - Figero"
    W7L3Fej = "7-3 Crumbling Castle Monkey 18 - Fej"
    W7L3Joey = "7-3 Crumbling Castle Monkey 19 - Joey"
    W7L3Donqui = "7-3 Crumbling Castle Monkey 20 - Donqui"
    W7L3Boss73 = "7-3 Crumbling Castle Boss"
    W8L1Kaine = "8-1 City Park Monkey 1 - Kaine"
    W8L1Jaxx = "8-1 City Park Monkey 2 - Jaxx"
    W8L1Gehry = "8-1 City Park Monkey 3 - Gehry"
    W8L1Alcatraz = "8-1 City Park Monkey 4 - Alcatraz"
    W8L1Tino = "8-1 City Park Monkey 5 - Tino"
    W8L1QBee = "8-1 City Park Monkey 6 - Q. Bee"
    W8L1McManic = "8-1 City Park Monkey 7 - McManic"
    W8L1Dywan = "8-1 City Park Monkey 8 - Dywan"
    W8L1CKHutch = "8-1 City Park Monkey 9 - CK Hutch"
    W8L1Winky = "8-1 City Park Monkey 10 - Winky"
    W8L1BLuv = "8-1 City Park Monkey 11 - B Luv"
    W8L1Camper = "8-1 City Park Monkey 12 - Camper"
    W8L1Huener = "8-1 City Park Monkey 13 - Huener"
    W8L2BigShow = "8-2 Specters Factory Monkey 1 - Big Show"
    W8L2Dreos = "8-2 Specters Factory Monkey 2 - Dreos"
    W8L2Reznor = "8-2 Specters Factory Monkey 3 - Reznor"
    W8L2Urkel = "8-2 Specters Factory Monkey 4 - Urkel"
    W8L2VanillaS = "8-2 Specters Factory Monkey 5 - Vanilla S"
    W8L2Radd = "8-2 Specters Factory Monkey 6 - Radd"
    W8L2Shimbo = "8-2 Specters Factory Monkey 7 - Shimbo"
    W8L2Hurt = "8-2 Specters Factory Monkey 8 - Hurt"
    W8L2String = "8-2 Specters Factory Monkey 9 - String"
    W8L2Khamo = "8-2 Specters Factory Monkey 10 - Khamo"
    W8L3Fredo = "8-3 TV Tower Monkey 1 - Fredo"
    W8L3Charlee = "8-3 TV Tower Monkey 2 - Charlee"
    W8L3Mach3 = "8-3 TV Tower Monkey 3 - Mach 3"
    W8L3Tortuss = "8-3 TV Tower Monkey 4 - Tortuss"
    W8L3Manic = "8-3 TV Tower Monkey 5 - Manic"
    W8L3Ruptdis = "8-3 TV Tower Monkey 6 - Ruptdis"
    W8L3Eighty7 = "8-3 TV Tower Monkey 7 - Eighty 7"
    W8L3Danio = "8-3 TV Tower Monkey 8 - Danio"
    W8L3Roosta = "8-3 TV Tower Monkey 9 - Roosta"
    W8L3Tellis = "8-3 TV Tower Monkey 10 - Tellis"
    W8L3Whack = "8-3 TV Tower Monkey 11 - Whack"
    W8L3Frostee = "8-3 TV Tower Monkey 12 - Frostee"
    W8L3Boss83 = "8-3 TV Tower Boss"
    W9L1Goopo = "9-1 Monkey Madness Monkey 1 - Goopo"
    W9L1Porto = "9-1 Monkey Madness Monkey 2 - Porto"
    W9L1Slam = "9-1 Monkey Madness Monkey 3 - Slam"
    W9L1Junk = "9-1 Monkey Madness Monkey 4 - Junk"
    W9L1Crib = "9-1 Monkey Madness Monkey 5 - Crib"
    W9L1Nak = "9-1 Monkey Madness Monkey 6 - Nak"
    W9L1Cloy = "9-1 Monkey Madness Monkey 7 - Cloy"
    W9L1Shaw = "9-1 Monkey Madness Monkey 8 - Shaw"
    W9L1Flea = "9-1 Monkey Madness Monkey 9 - Flea"
    W9L1Schafette = "9-1 Monkey Madness Monkey 10 - Schafette"
    W9L1Donovan = "9-1 Monkey Madness Monkey 11 - Donovan"
    W9L1Laura = "9-1 Monkey Madness Monkey 12 - Laura"
    W9L1Uribe = "9-1 Monkey Madness Monkey 13 - Uribe"
    W9L1Gordo = "9-1 Monkey Madness Monkey 14 - Gordo"
    W9L1Raeski = "9-1 Monkey Madness Monkey 15 - Raeski"
    W9L1Poopie = "9-1 Monkey Madness Monkey 16 - Poo-pie"
    W9L1Teacup = "9-1 Monkey Madness Monkey 17 - Teacup"
    W9L1Shine = "9-1 Monkey Madness Monkey 18 - Shine"
    W9L1Wrench = "9-1 Monkey Madness Monkey 19 - Wrench"
    W9L1Bronson = "9-1 Monkey Madness Monkey 20 - Bronson"
    W9L1Bungee = "9-1 Monkey Madness Monkey 21 - Bungee"
    W9L1Carro = "9-1 Monkey Madness Monkey 22 - Carro"
    W9L1Carlito = "9-1 Monkey Madness Monkey 23 - Carlito"
    W9L1BG = "9-1 Monkey Madness Monkey 24 - BG"
    Boss73 = "7-3 Crumbling Castle - Boss"
    Boss83 = "8-3 TV Tower - Boss"
    W9L1Professor = "9-1 Monkey Madness - Rescue Professor"
    W9L1Jake = "9-1 Monkey Madness - Defeat Jake"
    Specter = "9-1 Monkey Madness - Specter"
    Specter2 = "9-2 Peak Point Matrix - Specter"
    Coin1 = "1-1 Fossil Field Coin - Main"
    Coin2 = "1-2 Primordial Ooze Coin - Main"
    Coin3 = "1-3 Molten Lava Coin - Entry"
    Coin6 = "2-1 Thick Jungle Coin - Entry"
    Coin7 = "2-1 Thick Jungle Coin - Mushroom Area"
    Coin8 = "2-1 Thick Jungle Coin - Fish Room"
    Coin9 = "2-1 Thick Jungle Coin - Tent/Vine Room"
    Coin11 = "2-2 Dark Ruins Coin - Outside"
    Coin12 = "2-2 Dark Ruins Coin - Fan Basement"
    Coin13 = "2-2 Dark Ruins Coin - Obelisk Inside"
    Coin14 = "2-2 Dark Ruins Coin - Water Basement"
    Coin17 = "2-3 Cryptic Relics Coin - Main Ruins"
    Coin19A = "3-1 Stadium Attack Coin 1"
    Coin19B = "3-1 Stadium Attack Coin 2"
    Coin19C = "3-1 Stadium Attack Coin 3"
    Coin19D = "3-1 Stadium Attack Coin 4"
    Coin19E = "3-1 Stadium Attack Coin 5"
    Coin21 = "4-1 Crabby Beach Coin - Second Room"
    Coin23 = "4-2 Coral Cave Coin - Second Room"
    Coin24 = "4-3 Dexters Island Coin - Outside"
    Coin25 = "4-3 Dexters Island Coin - Stomach"
    Coin28 = "4-3 Dexters Island Coin - Slide Room"
    Coin29 = "5-1 Snowy Mammoth Coin - Main"
    Coin30 = "5-2 Frosty Retreat Coin - Entry"
    Coin31 = "5-2 Frosty Retreat Coin - Water Room"
    Coin32 = "5-2 Frosty Retreat Coin - Caverns"
    Coin34 = "5-3 Hot Springs Coin - Hot Spring"
    Coin35 = "5-3 Hot Springs Coin - Polar Bear Cave"
    Coin36A = "6-1 Gladiator Attack Coin 1"
    Coin36B = "6-1 Gladiator Attack Coin 2"
    Coin36C = "6-1 Gladiator Attack Coin 3"
    Coin36D = "6-1 Gladiator Attack Coin 4"
    Coin36E = "6-1 Gladiator Attack Coin 5"
    Coin37 = "7-1 Sushi Temple Coin - Outside"
    Coin38 = "7-1 Sushi Temple Coin - Temple"
    Coin39 = "7-1 Sushi Temple Coin - Well"
    Coin40 = "7-2 Wabi Sabi Wall Coin - First Room"
    Coin41 = "7-2 Wabi Sabi Wall Coin - Gong Room"
    Coin44 = "7-2 Wabi Sabi Wall Coin - Barrel Room"
    Coin45 = "7-3 Crumbling Castle Coin - Outside"
    Coin46 = "7-3 Crumbling Castle Coin - Castle Main"
    Coin49 = "7-3 Crumbling Castle Coin - Button Room"
    Coin50 = "7-3 Crumbling Castle Coin - Elevator Room"
    Coin53 = "8-1 City Park Coin - Outside"
    Coin54 = "8-1 City Park Coin - Sewers Front"
    Coin55 = "8-1 City Park Coin - Barrel Room"
    Coin58 = "8-2 Specters Factory Coin - RC Car Room"
    Coin59 = "8-2 Specters Factory Coin - Lava Room"
    Coin64 = "8-3 TV Tower Coin - Water Basement"
    Coin66 = "8-3 TV Tower Coin - Tank Room"
    Coin73 = "9-1 Monkey Madness Coin - Coaster (Room 1)"
    Coin74 = "9-1 Monkey Madness Coin - Coaster (Room 2)"
    Coin75 = "9-1 Monkey Madness Coin - Haunted House"
    Coin77 = "9-1 Monkey Madness Coin - Western Land"
    Coin78 = "9-1 Monkey Madness Coin - Crater"
    Coin79 = "9-1 Monkey Madness Coin - Outside Castle"
    Coin80 = "9-1 Monkey Madness Coin - Castle Main"
    Coin82 = "9-1 Monkey Madness Coin - Climb (Outside)"
    Coin84 = "9-1 Monkey Madness Coin - Monkey Head"
    Coin85 = "9-1 Monkey Madness Coin - Side Entry"
    Mailbox1 = "1-1 Fossil Field Mailbox - Stun Club Tutorial (Main)"
    Mailbox2 = "1-1 Fossil Field Mailbox - Switch Gadgets Tutorial (Main)"
    Mailbox3 = "1-1 Fossil Field Mailbox - Don't Toss Your Cookies! (Main)"
    Mailbox4 = "1-2 Primordial Ooze Mailbox - Dive Reminder (Main)"
    Mailbox5 = "1-2 Primordial Ooze Mailbox - Climb a Tree (Main)"
    Mailbox6 = "1-2 Primordial Ooze Mailbox - Camera Tutorial (Main)"
    Mailbox7 = "1-2 Primordial Ooze Mailbox - Crawl Tutorial (Main)"
    Mailbox8 = "1-3 Molten Lava Mailbox - Surrounded by a Cliff (Entry)"
    Mailbox9 = "1-3 Molten Lava Mailbox - Energy Chips (Entry)"
    Mailbox10 = "1-3 Molten Lava Mailbox - The T-Rex is Aggressive (Volcano)"
    Mailbox11 = "1-3 Molten Lava Mailbox - Did I Give You That Yet? (Triceratops)"
    Mailbox12 = "1-3 Molten Lava Mailbox - Hit the Bombs! (Triceratops)"
    Mailbox13 = "2-1 Thick Jungle Mailbox - Monkeys are Hiding (Entry)"
    Mailbox14 = "2-1 Thick Jungle Mailbox - Monkey Camera Tutorial (Entry)"
    Mailbox15 = "2-1 Thick Jungle Mailbox - A Flying Gadget (Mushroom Area)"
    Mailbox16 = "2-1 Thick Jungle Mailbox - Completely Cleared (Mushroom Area)"
    Mailbox17 = "2-1 Thick Jungle Mailbox - You \"Must\" Rowboat (Fish Room)"
    Mailbox18 = "2-1 Thick Jungle Mailbox - Come Back Later! (Fish Room)"
    Mailbox19 = "2-1 Thick Jungle Mailbox - A Strange Device (Fish Room)"
    Mailbox20 = "2-1 Thick Jungle Mailbox - Don't Hurt the Plants. (Tent/Vine Room)"
    Mailbox21 = "2-1 Thick Jungle Mailbox - Find Specter Coins (Boulder Room)"
    Mailbox22 = "2-2 Dark Ruins Mailbox - Monkey Attributes (Outside)"
    Mailbox23 = "2-2 Dark Ruins Mailbox - Out of Place Block (Outside)"
    Mailbox24 = "2-2 Dark Ruins Mailbox - Difficult for Beginners (Outside)"
    Mailbox25 = "2-2 Dark Ruins Mailbox - Hmmm... Red Switch (Outside)"
    Mailbox26 = "2-2 Dark Ruins Mailbox - It'll Blow You Away (Fan Basement)"
    Mailbox27 = "2-2 Dark Ruins Mailbox - D-pad Camera Tutorial (Fan Basement)"
    Mailbox28 = "2-2 Dark Ruins Mailbox - Monkeys Lights (Obelisk Inside)"
    Mailbox29 = "2-3 Cryptic Relics Mailbox - Get Rid of the Enemy (Outside)"
    Mailbox30 = "2-3 Cryptic Relics Mailbox - Don't Forget Your Sling (Outside)"
    Mailbox31 = "2-3 Cryptic Relics Mailbox - Back Camera Tutorial (Main Ruins)"
    Mailbox32 = "2-3 Cryptic Relics Mailbox - Remember to Save (Main Ruins)"
    Mailbox33 = "2-3 Cryptic Relics Mailbox - Come Back Later! (Pillar Room)"
    Mailbox34 = "4-1 Crabby Beach Mailbox - Hip Drop Attack (First Room)"
    Mailbox35 = "4-1 Crabby Beach Mailbox - Monkey Lamp Tutorial (First Room)"
    Mailbox36 = "4-1 Crabby Beach Mailbox - Dangerous to Fall (Second Room)"
    Mailbox37 = "4-2 Coral Cave Mailbox - Yellow Pants = Normal (Second Room)"
    Mailbox38 = "4-2 Coral Cave Mailbox - Red Pants = Strong (Second Room)"
    Mailbox39 = "4-3 Dexters Island Mailbox - I Named Him Dexter (Outside)"
    Mailbox40 = "4-3 Dexters Island Mailbox - Blue Pants = Very Fast (Outside)"
    Mailbox41 = "4-3 Dexters Island Mailbox - Don't Get Lost! (Slide Room)"
    Mailbox42 = "4-3 Dexters Island Mailbox - Normal Pellet Scare (Gallery/Boulder)"
    Mailbox43 = "5-1 Snowy Mammoth Mailbox - Severely Cold Sea (Main)"
    Mailbox44 = "5-1 Snowy Mammoth Mailbox - You Are Lost! (Main)"
    Mailbox45 = "5-1 Snowy Mammoth Mailbox - This Hazardous Thing (Main)"
    Mailbox46 = "5-2 Frosty Retreat Mailbox - Select Button Tutorial (Caverns)"
    Mailbox47 = "5-3 Hot Springs Mailbox - Ice Bridge Ahead (Outside)"
    Mailbox48 = "5-3 Hot Springs Mailbox - Wonderful Hot Springs!! (Hot Spring)"
    Mailbox49 = "5-3 Hot Springs Mailbox - Blocked by an Ice Column (Polar Bear Cave)"
    Mailbox50 = "7-1 Sushi Temple Mailbox - Green Pants = Great Vision (Temple)"
    Mailbox51 = "7-1 Sushi Temple Mailbox - Light Blue Pants = Gentle (Temple)"
    Mailbox52 = "7-1 Sushi Temple Mailbox - Rest and Relax (Well)"
    Mailbox53 = "7-2 Wabi Sabi Wall Mailbox - White Pants = Very Alert (Gong Room)"
    Mailbox54 = "7-2 Wabi Sabi Wall Mailbox - Guided Pellet Tutorial (Middle Room)"
    Mailbox55 = "7-2 Wabi Sabi Wall Mailbox - Big Cogwheel (Middle Room)"
    Mailbox56 = "7-2 Wabi Sabi Wall Mailbox - Black Pants = Dangerous (Obstacle Course)"
    Mailbox57 = "7-3 Crumbling Castle Mailbox - Think Clearly (Outside)"
    Mailbox58 = "8-2 Specters Factory Mailbox - Hop In The Tank (Outside)"
    Mailbox59 = "9-1 Monkey Madness Mailbox - The Terror Coaster (Coaster Entry)"
    Mailbox60 = "Time Station Mailbox - Welcome! (Main)"
    Mailbox61 = "Time Station Mailbox - Save Station (Main)"
    Mailbox62 = "Time Station Mailbox - Mini Game Corner (Mini Game Corner)"
    Mailbox63 = "Time Station Mailbox - Training Space (Gadget Training)"


class AEDoor(Enum):
    TIME_ENTRY = "Time Station: Entry"
    TIME_MAIN_TRAINING = "Time Station: Main - Gadget Training"
    TIME_MAIN_MINIGAME = "Time Station: Main - Minigame Corner"
    TIME_TRAINING_MAIN = "Time Station: Gadget Training - Main"
    TIME_MINIGAME_MAIN = "Time Station: Minigame Corner - Main"
    TIME_TRAINING_WATERNET = "Time Station: Gadget Training - Water Net"
    TIME_TRAINING_RADAR = "Time Station: Gadget Training - Radar"
    TIME_TRAINING_SLING = "Time Station: Gadget Training - Slingback Shooter"
    TIME_TRAINING_HOOP = "Time Station: Gadget Training - Super Hoop"
    TIME_TRAINING_FLYER = "Time Station: Gadget Training - Sky Flyer"
    TIME_TRAINING_CAR = "Time Station: Gadget Training - R.C. Car"
    TIME_TRAINING_PUNCH = "Time Station: Gadget Training - Magic Punch"
    FF_ENTRY = "Fossil Field: Main"
    PO_ENTRY = "Primordial Ooze: Main"
    ML_ENTRY = "Molten Lava: Entry"
    ML_ENTRY_VOLCANO = "Molten Lava: Entry - Volcano"
    ML_ENTRY_TRICERATOPS = "Molten Lava: Entry - Triceratops"
    ML_VOLCANO_ENTRY = "Molten Lava: Volcano - Entry"
    ML_TRICERATOPS_ENTRY = "Molten Lava: Triceratops - Entry"
    TJ_ENTRY = "Thick Jungle: Entry"
    TJ_ENTRY_MUSHROOM = "Thick Jungle: Entry - Mushroom"
    TJ_ENTRY_FISH = "Thick Jungle: Entry - Fish"
    TJ_ENTRY_BOULDER = "Thick Jungle: Entry - Boulder"
    TJ_MUSHROOM_ENTRY = "Thick Jungle: Mushroom - Entry"
    TJ_FISH_ENTRY = "Thick Jungle: Fish Room - Entry"
    TJ_FISH_TENT = "Thick Jungle: Fish Room - Tent/Vine Room"
    TJ_TENT_FISH = "Thick Jungle: Tent/Vine Room - Fish Room"
    TJ_TENT_BOULDER = "Thick Jungle: Tent/Vine Room - Boulder Room"
    TJ_BOULDER_ENTRY = "Thick Jungle: Boulder Room - Entry"
    TJ_BOULDER_TENT = "Thick Jungle: Boulder Room - Tent/Vine Room"
    TJ_MUSHROOMMAIN = "Thick Jungle: Mushroom - Main Area" # Helper Region
    TJ_FISHBOAT = "Thick Jungle: Fish Room - Boat Access" # Helper Region
    DR_ENTRY = "Dark Ruins: Entry"
    DR_OUTSIDE_FENCE = "Dark Ruins: Outside - Fan Basement (Fence)"
    DR_OUTSIDE_HOLE = "Dark Ruins: Outside - Fan Basement (Hole)"
    DR_OUTSIDE_OBELISK_BOTTOM = "Dark Ruins: Outside - Obelisk Inside (Bottom)"
    DR_OUTSIDE_OBELISK_TOP = "Dark Ruins: Outside - Obelisk Inside (Top)"
    DR_OUTSIDE_WATER_BUTTON = "Dark Ruins: Outside - Water Room (Side)"
    DR_OUTSIDE_WATER_LEDGE = "Dark Ruins: Outside - Water Room (Ledge)"
    DR_FAN_OUTSIDE_FENCE = "Dark Ruins: Fan Basement - Outside (Fence)"
    DR_FAN_OUTSIDE_HOLE = "Dark Ruins: Fan Basement - Outside (Hole)"
    DR_OBELISK_BOTTOM = "Dark Ruins: Obelisk Inside (Bottom)"
    DR_OBELISK_TOP = "Dark Ruins: Obelisk Inside (Top)"
    DR_WATER_SIDE = "Dark Ruins: Water Basement (Side)"
    DR_WATER_LEDGE = "Dark Ruins: Water Basement (Ledge)"
    CR_ENTRY = "Cryptic Relics: Entry"
    CR_ENTRY_SIDE_ROOM = "Cryptic Relics: Entry - Side Room"
    CR_ENTRY_MAIN_RUINS = "Cryptic Relics: Entry - Main Ruins"
    CR_SIDE_ROOM_ENTRY = "Cryptic Relics: Side Room - Entry"
    CR_MAIN_RUINS_ENTRY = "Cryptic Relics: Main Ruins - Entry"
    CR_MAIN_RUINS_PILLAR_ROOM = "Cryptic Relics: Main Ruins - Pillar Room"
    CR_PILLAR_ROOM_MAIN_RUINS = "Cryptic Relics: Pillar Room - Main Ruins"
    CR_ENTRYOBA = "Cryptic Relics: Entry - Outside Button Area" # Helper Region
    SA_ENTRY = "Stadium Attack: Entry"
    SA_COMPLETE = "Stadium Attack: Complete"
    CB_ENTRY = "Crabby Beach: Entry"
    CB_ENTRY_SECOND_ROOM = "Crabby Beach: Entry - Second Room"
    CB_SECOND_ROOM_ENTRY = "Crabby Beach: Second Room - Entry"
    CCAVE_ENTRY = "Coral Cave: Entry"
    CCAVE_ENTRY_SECOND_ROOM = "Coral Cave: Entry - Second Room"
    CCAVE_SECOND_ROOM_ENTRY = "Coral Cave: Second Room - Entry"
    DI_ENTRY = "Dexter's Island: Entry"
    DI_ENTRY_STOMACH = "Dexter's Island: Entry - Stomach"
    DI_STOMACH_ENTRY = "Dexter's Island: Stomach - Entry"
    DI_STOMACH_SLIDE_ROOM = "Dexter's Island: Stomach - Slide Room"
    DI_SLIDE_ROOM_STOMACH = "Dexter's Island: Slide Room - Stomach"
    DI_SLIDE_ROOM_GALLERY = "Dexter's Island: Slide Room - Gallery"
    DI_SLIDE_ROOM_GALLERY_WATER = "Dexter's Island: Slide Room - Gallery (Water)"
    DI_GALLERY_SLIDE_ROOM_TOP = "Dexter's Island: Gallery - Slide Room (Top)"
    DI_GALLERY_SLIDE_ELEVATOR = "Dexter's Island: Gallery - Slide Room (Elevator)"
    DI_GALLERY_TENTACLE = "Dexter's Island: Gallery - Tentacle Room"
    DI_TENTACLE = "Dexter's Island: Tentacle Room"
    DI_GALLERYBOULDER = "Dexter's Island: Gallery - Boulder Area" # Helper Region
    SM_ENTRY = "Snowy Mammoth: Main"
    FR_ENTRY = "Frosty Retreat: Entry"
    FR_ENTRY_CAVERNS = "Frosty Retreat: Entry - Caverns"
    FR_CAVERNS_ENTRY = "Frosty Retreat: Caverns - Entry"
    FR_CAVERNS_WATER = "Frosty Retreat: Caverns - Water Room"
    FR_WATER_CAVERNS = "Frosty Retreat: Water Room - Caverns"
    HS_ENTRY = "Hot Springs: Entry"
    HS_ENTRY_HOT_SPRING = "Hot Springs: Entry - Hot Springs"
    HS_ENTRY_POLAR_BEAR_CAVE = "Hot Springs: Entry - Polar Bear Cave"
    HS_HOT_SPRING = "Hot Springs: Hot Springs - Entry"
    HS_POLAR_BEAR_CAVE = "Hot Springs: Polar Bear Cave - Entry"
    GA_ENTRY = "Gladiator Attack: Entry"
    GA_COMPLETE = "Gladiator Attack: Complete"
    ST_ENTRY = "Sushi Temple: Entry"
    ST_ENTRY_TEMPLE = "Sushi Temple: Entry - Temple"
    ST_ENTRY_WELL = "Sushi Temple: Entry - Well"
    ST_TEMPLE = "Sushi Temple: Temple - Entry"
    ST_WELL = "Sushi Temple: Well - Entry"
    WSW_ENTRY = "Wabi Sabi Wall: Entry"
    WSW_ENTRY_GONG = "Wabi Sabi Wall: Entry - Gong Room"
    WSW_GONG_ENTRY = "Wabi Sabi Wall: Gong Room - Entry"
    WSW_GONG_MIDDLE = "Wabi Sabi Wall: Gong Room - Middle Room"
    WSW_MIDDLE_GONG = "Wabi Sabi Wall: Middle Room - Gong Room"
    WSW_MIDDLE_OBSTACLE = "Wabi Sabi Wall: Middle Room - Obstacle Course"
    WSW_OBSTACLE_MIDDLE = "Wabi Sabi Wall: Obstacle Course - Middle Room"
    WSW_OBSTACLE_BARREL = "Wabi Sabi Wall: Obstacle Course - Barrel Room"
    WSW_BARREL_OBSTACLE = "Wabi Sabi Wall: Barrel Room - Obstacle Course"
    CC_ENTRY = "Crumbling Castle: Entry"
    CC_ENTRY_CASTLE = "Crumbling Castle: Outside - Castle Main"
    CC_ENTRY_BELL = "Crumbling Castle: Outside - Bell Tower"
    CC_ENTRY_BASEMENT = "Crumbling Castle: Outside - Flooded Basement"
    CC_ENTRY_BOSS = "Crumbling Castle: Outside - Boss"
    CC_CASTLEMAIN_ENTRY = "Crumbling Castle: Castle Main - Outside"
    CC_CASTLEMAIN_BELL = "Crumbling Castle: Castle Main - Bell Tower"
    CC_CASTLEMAIN_ELEVATOR = "Crumbling Castle: Castle Main - Elevator Room"
    CC_BELL_ENTRY = "Crumbling Castle: Bell Tower - Outside"
    CC_BELL_CASTLE = "Crumbling Castle: Bell Tower - Castle Main"
    CC_ELEVATOR_CASTLEMAIN = "Crumbling Castle: Elevator Room - Castle Main"
    CC_ELEVATOR_BASEMENT = "Crumbling Castle: Elevator Room - Flooded Basement"
    CC_BASEMENT_ENTRY = "Crumbling Castle: Flooded Basement - Entry"
    CC_BASEMENT_ELEVATOR = "Crumbling Castle: Flooded Basement - Elevator"
    CC_BASEMENT_BUTTON_DOWN = "Crumbling Castle: Flooded Basement - Button Room (Downstairs)"
    CC_BASEMENT_BUTTON_UP = "Crumbling Castle: Flooded Basement - Button Room (Upstairs)"
    CC_BUTTON_BASEMENT_WATER = "Crumbling Castle: Button Room - Flooded Basement (Water)"
    CC_BUTTON_BASEMENT_LEDGE = "Crumbling Castle: Button Room - Flooded Basement (Ledge)"
    CC_BOSS_ROOM = "Crumbling Castle: Boss - Outside"
    CC_CASTLEMAINTHRONEROOM = "Crumbling Castle: Castle Main - Throne Room" # Helper Region
    CP_ENTRY = "City Park: Entry"
    CP_OUTSIDE_SEWERS_FRONT = "City Park: Outside - Sewers Front"
    CP_OUTSIDE_BARREL = "City Park: Outside - Barrel Room"
    CP_SEWERSFRONT_OUTSIDE = "City Park: Sewers Front - Outside"
    CP_SEWERSFRONT_BARREL = "City Park: Sewers Front - Barrel Room"
    CP_BARREL_OUTSIDE = "City Park: Barrel Room - Outside"
    CP_BARREL_SEWERS_FRONT = "City Park: Barrel Room - Sewers Front"
    CP_BARRELSEWERMIDDLE = "City Park: Barrel Room - Middle Sewer" # Helper Region
    SF_ENTRY = "Specter's Factory: Entry"
    SF_OUTSIDE_FACTORY = "Specter's Factory: Outside - Main Factory"
    SF_FACTORY_OUTSIDE = "Specter's Main Factory: Main Factory - Outside"
    SF_FACTORY_RC_CAR = "Specter's Main Factory: Main Factory - RC Car Room"
    SF_FACTORY_WHEEL_BOTTOM = "Specter's Main Factory: Main Factory - Triple Wheel Room (Bottom)"
    SF_FACTORY_WHEEL_TOP = "Specter's Main Factory: Main Factory - Triple Wheel Room (Top)"
    SF_FACTORY_MECH = "Specter's Main Factory: Main Factory - Mech Room"
    SF_RC_CAR_FACTORY = "Specter's Main Factory: RC Car Room - Main Factory"
    SF_WHEEL_FACTORY_BOTTOM = "Specter's Main Factory: Triple Wheel Room (Bottom) - Main Factory"
    SF_WHEEL_FACTORY_TOP = "Specter's Main Factory: Triple Wheel Room (Top) - Main Factory"
    SF_MECH_FACTORY = "Specter's Main Factory: Mech Room - Main Factory"
    SF_MECH_LAVA = "Specter's Main Factory: Mech Room - Lava Room"
    SF_LAVA_MECH = "Specter's Main Factory: Lava Room - Mech Room"
    SF_LAVA_CONVEYOR = "Specter's Main Factory: Lava Room - Conveyor Room"
    SF_CONVEYOR_LAVA = "Specter's Main Factory: Entry - Lava Room"
    SF_CONVEYOR1_ENTRY = "Specter's Main Factory: Conveyor Room - Conveyor 1 Entry"
    SF_CONVEYOR1_EXIT = "Specter's Main Factory: Conveyor Room - Conveyor 1 Exit"
    SF_CONVEYOR2_ENTRY = "Specter's Main Factory: Conveyor Room - Conveyor 2 Entry"
    SF_CONVEYOR2_EXIT = "Specter's Main Factory: Conveyor Room - Conveyor 2 Exit"
    SF_CONVEYOR3_ENTRY = "Specter's Main Factory: Conveyor Room - Conveyor 3 Entry"
    SF_CONVEYOR3_EXIT = "Specter's Main Factory: Conveyor Room - Conveyor 3 Exit"
    SF_CONVEYOR4_ENTRY = "Specter's Main Factory: Conveyor Room - Conveyor 4 Entry"
    SF_CONVEYOR4_EXIT = "Specter's Main Factory: Conveyor Room - Conveyor 4 Exit"
    SF_CONVEYOR5_ENTRY = "Specter's Main Factory: Conveyor Room - Conveyor 5 Entry"
    SF_CONVEYOR5_EXIT = "Specter's Main Factory: Conveyor Room - Conveyor 5 Exit"
    SF_CONVEYOR6_ENTRY = "Specter's Main Factory: Conveyor Room - Conveyor 6 Entry"
    SF_CONVEYOR6_EXIT = "Specter's Main Factory: Conveyor Room - Conveyor 6 Exit"
    SF_CONVEYOR7_ENTRY = "Specter's Main Factory: Conveyor Room - Conveyor 7 Entry"
    TVT_ENTRY = "TV Tower: Entry"
    TVT_OUTSIDE_LOBBY = "TV Tower: Outside - Lobby"
    TVT_LOBBY_OUTSIDE = "TV Tower: Lobby - Outside"
    TVT_LOBBY_WATER = "TV Tower: Lobby - Water Basement"
    TVT_LOBBY_TANK = "TV Tower: Lobby - Tank Room"
    TVT_WATER_LOBBY = "TV Tower: Water Basement - Lobby"
    TVT_TANK_LOBBY = "TV Tower: Tank Room - Lobby"
    TVT_TANK_FAN = "TV Tower: Tank Room - Fan Room"
    TVT_TANK_BOSS = "TV Tower: Tank Room - Boss"
    TVT_FAN_TANK = "TV Tower: Fan Room - Tank Room"
    TVT_BOSS_TANK = "TV Tower: Boss - Tank Room"
    MM_SL_HUB = "Monkey Madness: Specter Land Hub"
    MM_SL_HUB_WESTERN = "Monkey Madness: Specter Land Hub - Western Land"
    MM_SL_HUB_COASTER = "Monkey Madness: Specter Land Hub - Coaster Entry"
    MM_SL_HUB_CIRCUS = "Monkey Madness: Specter Land Hub - Circus"
    MM_SL_HUB_GO_KARZ = "Monkey Madness: Specter Land Hub - Go Karz"
    MM_SL_HUB_CRATER = "Monkey Madness: Specter Land Hub - Crater"
    MM_WESTERN_SL_HUB = "Monkey Madness: Western Land - Specter Land Hub"
    MM_COASTER_ENTRY_SL_HUB = "Monkey Madness: Coaster Entry - Specter Land Hub"
    MM_COASTER_ENTRY_COASTER1 = "Monkey Madness: Coaster Entry - Coaster 1"
    MM_COASTER_ENTRY_DISEMBARK = "Monkey Madness: Coaster Entry Disembark"
    MM_CIRCUS_SL_HUB = "Monkey Madness: Circus - Specter Land Hub"
    MM_GO_KARZ_SL_HUB = "Monkey Madness: Go Karz - Specter Land Hub"
    MM_COASTER1_ENTRY = "Monkey Madness: Coaster Room 1 Entry"
    MM_COASTER1_COASTER2 = "Monkey Madness: Coaster Room 1 - Coaster Room 2"
    MM_COASTER2_ENTRY = "Monkey Madness: Coaster Room 2 Entry"
    MM_COASTER2_HAUNTED_HOUSE = "Monkey Madness: Coaster Room 2 - Haunted House"
    MM_HAUNTED_HOUSE_DISEMBARK = "Monkey Madness: Haunted House Disembark"
    MM_HAUNTED_HOUSE_COFFIN = "Monkey Madness: Haunted House - Coffin Room"
    MM_COFFIN_HAUNTED_HOUSE = "Monkey Madness: Coffin Room - Haunted House"
    MM_COFFIN_COASTER_ENTRY = "Monkey Madness: Coffin Room - Coaster Entry"
    MM_CRATER_SL_HUB = "Monkey Madness: Crater - Specter Land Hub"
    MM_CRATER_OUTSIDE_CASTLE = "Monkey Madness: Crater - Outside Castle"
    MM_OUTSIDE_CASTLE_CRATER = "Monkey Madness: Outside Castle - Crater"
    MM_OUTSIDE_CASTLE_SIDE_ENTRY = "Monkey Madness: Outside Castle - Castle Side Entry"
    MM_OUTSIDE_CASTLE_CASTLE_MAIN = "Monkey Madness: Outside Castle - Castle Main"
    MM_SIDE_ENTRY_OUTSIDE_CASTLE = "Monkey Madness: Castle Side Entry - Outside Castle"
    MM_CASTLE_MAIN_OUTSIDE_CASTLE = "Monkey Madness: Castle Main - Outside Castle"
    MM_CASTLE_MAIN_MONKEY_HEAD = "Monkey Madness: Castle Main - Monkey Head"
    MM_CASTLE_MAIN_INSIDE_CLIMB = "Monkey Madness: Castle Main - Inside Climb"
    MM_CASTLE_MAIN_FROM_OUTSIDE = "Monkey Madness: Castle Main From Outside"
    MM_CASTLE_MAIN_SPECTER1 = "Monkey Madness: Specter 1 Entrance"
    MM_MONKEY_HEAD_CASTLE_MAIN = "Monkey Madness: Monkey Head - Castle Main"
    MM_INSIDE_CLIMB_CASTLE_MAIN = "Monkey Madness: Inside Climb - Castle Main"
    MM_INSIDE_CLIMB_OUTSIDE_CLIMB = "Monkey Madness: Inside Climb - Outside Climb"
    MM_OUTSIDE_CLIMB_INSIDE_CLIMB = "Monkey Madness: Outside Climb - Inside Climb"
    MM_OUTSIDE_CLIMB_CASTLE_MAIN = "Monkey Madness: Outside Climb - Castle Main"
    MM_SPECTER1_ROOM = "Monkey Madness: Specter 1 Room"
    PPM_ENTRY = "Peak Point Matrix: Entry"

class AEItem(Enum):
    Club = "Stun Club"
    Net = "Time Net"
    Radar = "Monkey Radar"
    Sling = "Slingback Shooter"
    Hoop = "Super Hoop"
    Punch = "Magic Punch"
    Flyer = "Sky Flyer"
    Car = "R.C. Car"
    Key = "World Key"
    Victory = "Victory"
    WaterNet = "Water Net"
    ProgWaterNet = "Progressive Water Net"
    WaterCatch = "Water Catch"
    CB_Lamp = "Crabby Beach Monkey Lamp"
    DI_Lamp = "Dexter's Island Monkey Lamp"
    CrC_Lamp = "Crumbling Castle Monkey Lamp"
    CP_Lamp = "City Park Monkey Lamp"
    SF_Lamp = "Specter's Factory Monkey Lamp"
    TVT_Lobby_Lamp = "TV Tower Monkey Lamp (Lobby)"
    TVT_Tank_Lamp = "TV Tower Monkey Lamp (Tank Room)"
    MM_Lamp = "Monkey Madness Monkey Lamp"
    MM_DoubleDoorKey = "Monkey Madness Double Door Key"
    Token = "Specter Token"
    Nothing = "Nothing"
    Shirt = "Jacket"
    Triangle = "Energy Chip"
    BigTriangle = "5 Energy Chips"
    BiggerTriangle = "25 Energy Chips"
    Cookie = "Cookie"
    FiveCookies = "5 Cookies"
    Flash = "Explosive Pellet"
    ThreeFlash = "3 Explosive Pellets"
    Rocket = "Guided Pellet"
    ThreeRocket = "3 Guided Pellets"
    BananaPeelTrap = "Banana Peel Trap"
    GadgetShuffleTrap = "Gadget Shuffle Trap"
    MonkeyMashTrap = "Monkey Mash Trap"
    IcyHotPantsTrap = "Icy Hot Pants Trap"
    StunTrap = "Stun Trap"
    CameraRotateTrap = "Camera Rotate Trap"
    RainbowCookie = "Rainbow Cookie"
    FAKE_OOL_ITEM = "Fake OOL Item"

DS_Options = ["kickoutprevention","deathlink","autoequip","bhdisplay"]
DS_ButtonAndDoors = ["DIButton","CrCWaterButton","MM_Painting_Button","MM_MonkeyHead_Button","TVT_Lobby_Button","DR_Block"]

Commands_Dict = {
    "ae_commands" : "cmd_ae_commands",
    "bh_itemdisplay" : "cmd_bh_itemdisplay",
    "prevent_kickout":"cmd_prevent_kickout",
    "deathlink" : "cmd_deathlink",
    "auto_equip" : "cmd_auto_equip",
    "syncprogress" : "cmd_syncprogress",
    "spikecolor" : "cmd_spikecolor",
}