from ..assembler import ASM


_LOOPING_MUSIC = (1, 2, 3, 4, 5, 6, 7, 8, 9, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
                  0x18, 0x19, 0x1C, 0x1D, 0x1F, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x2F, 0x31, 0x32, 0x33, 0x37,
                  0x39, 0x3A, 0x3C, 0x3E, 0x40, 0x48, 0x49, 0x4A, 0x4B, 0x4E, 0x50, 0x53, 0x54, 0x55, 0x57, 0x58, 0x59,
                  0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F, 0x60, 0x61)


def randomizeMusic(rom, rnd):
    # Randomize overworld
    for x in range(0, 16, 2):
        for y in range(0, 16, 2):
            idx = x + y * 16
            result = rnd.choice(_LOOPING_MUSIC)
            rom.banks[0x02][idx] = result
            rom.banks[0x02][idx+1] = result
            rom.banks[0x02][idx+16] = result
            rom.banks[0x02][idx+17] = result
    # Random music in dungeons/caves
    for n in range(0x20):
        rom.banks[0x02][0x100 + n] = rnd.choice(_LOOPING_MUSIC)


def noMusic(rom):
    rom.patch(0x1B, 0x001E, ASM("ld hl, $D368\nldi a, [hl]"), ASM("xor a"), fill_nop=True)
    rom.patch(0x1E, 0x001E, ASM("ld hl, $D368\nldi a, [hl]"), ASM("xor a"), fill_nop=True)
