MNEMONICS = {
    "nop": {
        "": 0x00
    },
    "ld": {
        "a": {
            "a": 0x7f,
            "b": 0x78,
            "c": 0x79,
            "d": 0x7a,
            "e": 0x7b,
            "h": 0x7c,
            "l": 0x7d,
            "(bc)": 0x0a,
            "(de)": 0x1a,
            "(hl)": 0x7e,
            "$8": 0x3e,
            "($16)": 0xfa,
            "(ff00+c)": 0xf2,
        },
        "b": {
            "a": 0x47,
            "b": 0x40,
            "c": 0x41,
            "d": 0x42,
            "e": 0x43,
            "h": 0x44,
            "l": 0x45,
            "(hl)": 0x46,
            "$8": 0x06,
        },
        "c": {
            "a": 0x4f,
            "b": 0x48,
            "c": 0x49,
            "d": 0x4a,
            "e": 0x4b,
            "h": 0x4c,
            "l": 0x4d,
            "(hl)": 0x4e,
            "$8": 0x0e,
        },
        "d": {
            "a": 0x57,
            "b": 0x50,
            "c": 0x51,
            "d": 0x52,
            "e": 0x53,
            "h": 0x54,
            "l": 0x55,
            "(hl)": 0x56,
            "$8": 0x16,
        },
        "e": {
            "a": 0x5f,
            "b": 0x58,
            "c": 0x59,
            "d": 0x5a,
            "e": 0x5b,
            "h": 0x5c,
            "l": 0x5d,
            "(hl)": 0x5e,
            "$8": 0x1e,
        },
        "h": {
            "a": 0x67,
            "b": 0x60,
            "c": 0x61,
            "d": 0x62,
            "e": 0x63,
            "h": 0x64,
            "l": 0x65,
            "(hl)": 0x66,
            "$8": 0x26,
        },
        "l": {
            "a": 0x6f,
            "b": 0x68,
            "c": 0x69,
            "d": 0x6a,
            "e": 0x6b,
            "h": 0x6c,
            "l": 0x6d,
            "(hl)": 0x6e,
            "$8": 0x2e,
        },
        "bc": {
            "$16": 0x01,
        },
        "de": {
            "$16": 0x11
        },
        "hl": {
            "$16": 0x21,
            "sp+$8": 0xf8
        },
        "(bc)": {
            "a": 0x02,
        },
        "(de)": {
            "a": 0x12
        },
        "(hl)": {
            "a": 0x77,
            "b": 0x70,
            "c": 0x71,
            "d": 0x72,
            "e": 0x73,
            "h": 0x74,
            "l": 0x75,
            "$8": 0x36
        },
        "($16)": {
            "a": 0xea,
            "sp": 0x08,
        },
        "sp": {
            "$16": 0x31,
            "hl": 0xf9,
        },
        "(ff00+c)": {"a": 0xe2},
    },
    "ldi": {
        "(hl)": {"a": 0x22},
        "a": {"(hl)": 0x2a},
    },
    "ldd": {
        "(hl)": {
            "a": 0x32
        },
        "a": {
            "(hl)": 0x3a
        }
    },
    "ldh": {
        "($8)": {"a": 0xe0},
        "a": {"($8)": 0xf0},
    },
    "inc": {
        "a": 0x3c,
        "b": 0x04,
        "c": 0x0c,
        "d": 0x14,
        "e": 0x1c,
        "h": 0x24,
        "l": 0x2c,
        "bc": 0x03,
        "de": 0x13,
        "hl": 0x23,
        "(hl)": 0x34,
        "sp": 0x33,
    },
    "dec": {
        "a": 0x3d,
        "b": 0x05,
        "c": 0x0d,
        "d": 0x15,
        "e": 0x1d,
        "h": 0x25,
        "l": 0x2d,
        "bc": 0x0b,
        "de": 0x1b,
        "hl": 0x2b,
        "(hl)": 0x35,
        "sp": 0x3b
    },
    "add": {
        "a": {
            "a": 0x87,
            "b": 0x80,
            "c": 0x81,
            "d": 0x82,
            "e": 0x83,
            "h": 0x84,
            "l": 0x85,
            "(hl)": 0x86,
            "$8": 0xc6,
        },
        "hl": {
            "bc": 0x09,
            "de": 0x19,
            "hl": 0x29,
            "sp": 0x39
        },
        "sp": {"$8": 0xe8}
    },
    "adc": {
        "a": {
            "a": 0x8f,
            "b": 0x88,
            "c": 0x89,
            "d": 0x8a,
            "e": 0x8b,
            "h": 0x8c,
            "l": 0x8d,
            "(hl)": 0x8e,
            "$8": 0xce,
        }
    },
    "sub": {
        "a": 0x97,
        "b": 0x90,
        "c": 0x91,
        "d": 0x92,
        "e": 0x93,
        "h": 0x94,
        "l": 0x95,
        "(hl)": 0x96,
        "$8": 0xd6,
    },
    "sbc": {
        "a": {
            "a": 0x9f,
            "b": 0x98,
            "c": 0x99,
            "d": 0x9a,
            "e": 0x9b,
            "h": 0x9c,
            "l": 0x9d,
            "(hl)": 0x9e,
            "$8": 0xde,
        }
    },
    "and": {
        "a": 0xa7,
        "b": 0xa0,
        "c": 0xa1,
        "d": 0xa2,
        "e": 0xa3,
        "h": 0xa4,
        "l": 0xa5,
        "(hl)": 0xa6,
        "$8": 0xe6,
    },
    "xor": {
        "a": 0xaf,
        "b": 0xa8,
        "c": 0xa9,
        "d": 0xaa,
        "e": 0xab,
        "h": 0xac,
        "l": 0xad,
        "(hl)": 0xae,
        "$8": 0xee
    },
    "or": {
        "a": 0xb7,
        "b": 0xb0,
        "c": 0xb1,
        "d": 0xb2,
        "e": 0xb3,
        "h": 0xb4,
        "l": 0xb5,
        "(hl)": 0xb6,
        "$8": 0xf6,
    },
    "cp": {
        "a": 0xbf,
        "b": 0xb8,
        "c": 0xb9,
        "d": 0xba,
        "e": 0xbb,
        "h": 0xbc,
        "l": 0xbd,
        "(hl)": 0xbe,
        "$8": 0xfe,
    },
    "jr": {
        "$8": 0x18,
        "nz": {"$8": 0x20},
        "z": {"$8": 0x28},
        "nc": {"$8": 0x30},
        "c": {"$8": 0x38},
    },
    "jp": {
        "$16": 0xc3,
        "nz": {"$16": 0xc2},
        "z": {"$16": 0xca},
        "nc": {"$16": 0xd2},
        "c": {"$16": 0xda},
        "(hl)": 0xe9,
    },
    "call": {
        "$16": 0xcd,
        "nz": {"$16": 0xc4},
        "z": {"$16": 0xcc},
        "nc": {"$16": 0xd4},
        "c": {"$16": 0xdc}
    },
    "ret": {
        "": 0xc9,
        "z": 0xc8,
        "nz": 0xc0,
        "c": 0xd8,
        "nc": 0xd0,
    },
    "push": {
        "af": 0xf5,
        "bc": 0xc5,
        "de": 0xd5,
        "hl": 0xe5,
    },
    "pop": {
        "af": 0xf1,
        "bc": 0xc1,
        "de": 0xd1,
        "hl": 0xe1,
    },
    "rst": {
        "00": 0xc7,
        "08": 0xcf,
        "10": 0xd7,
        "18": 0xdf,
        "20": 0xe7,
        "28": 0xef,
        "30": 0xf7,
        "38": 0xff,
    },
    "rlca": {
        "": 0x07
    },
    "rrca": {
        "": 0x0f
    },
    "rla": {
        "": 0x17
    },
    "rra": {
        "": 0x1f
    },
    "daa": {
        "": 0x27
    },
    "cpl": {
        "": 0x2f
    },
    "scf": {
        "": 0x37
    },
    "ccf": {
        "": 0x3f
    },
    "reti": {
        "": 0xd9
    },
    "di": {
        "": 0xf3
    },
    "ei": {
        "": 0xfb
    },
    "stop": {"0": 0x10},
    "halt": {
        "": 0x76
    },

    # CB-prefixed mnemonics
    "rlc": {
        "a": [0xcb, 0x07],
        "b": [0xcb, 0x00],
        "c": [0xcb, 0x01],
        "d": [0xcb, 0x02],
        "e": [0xcb, 0x03],
        "h": [0xcb, 0x04],
        "l": [0xcb, 0x05],
        "(hl)": [0xcb, 0x06],
    },
    "rrc": {
        "a": [0xcb, 0x0f],
        "b": [0xcb, 0x08],
        "c": [0xcb, 0x09],
        "d": [0xcb, 0x0a],
        "e": [0xcb, 0x0b],
        "h": [0xcb, 0x0c],
        "l": [0xcb, 0x0d],
        "(hl)": [0xcb, 0x0e],
    },
    "rl": {
        "a": [0xcb, 0x17],
        "b": [0xcb, 0x10],
        "c": [0xcb, 0x11],
        "d": [0xcb, 0x12],
        "e": [0xcb, 0x13],
        "h": [0xcb, 0x14],
        "l": [0xcb, 0x15],
        "(hl)": [0xcb, 0x16],
    },
    "rr": {
        "a": [0xcb, 0x1f],
        "b": [0xcb, 0x18],
        "c": [0xcb, 0x19],
        "d": [0xcb, 0x1a],
        "e": [0xcb, 0x1b],
        "h": [0xcb, 0x1c],
        "l": [0xcb, 0x1d],
        "(hl)": [0xcb, 0x1e],
    },
    "sla": {
        "a": [0xcb, 0x27],
        "b": [0xcb, 0x20],
        "c": [0xcb, 0x21],
        "d": [0xcb, 0x22],
        "e": [0xcb, 0x23],
        "h": [0xcb, 0x24],
        "l": [0xcb, 0x25],
        "(hl)": [0xcb, 0x26],
    },
    "sra": {
        "a": [0xcb, 0x2f],
        "b": [0xcb, 0x28],
        "c": [0xcb, 0x29],
        "d": [0xcb, 0x2a],
        "e": [0xcb, 0x2b],
        "h": [0xcb, 0x2c],
        "l": [0xcb, 0x2d],
        "(hl)": [0xcb, 0x2e],
    },
    "swap": {
        "a": [0xcb, 0x37],
        "b": [0xcb, 0x30],
        "c": [0xcb, 0x31],
        "d": [0xcb, 0x32],
        "e": [0xcb, 0x33],
        "h": [0xcb, 0x34],
        "l": [0xcb, 0x35],
        "(hl)": [0xcb, 0x36],
    },
    "srl": {
        "a": [0xcb, 0x3f],
        "b": [0xcb, 0x38],
        "c": [0xcb, 0x39],
        "d": [0xcb, 0x3a],
        "e": [0xcb, 0x3b],
        "h": [0xcb, 0x3c],
        "l": [0xcb, 0x3d],
        "(hl)": [0xcb, 0x3e],
    },
    "bit": {
        "0": {
            "a": [0xcb, 0x47],
            "b": [0xcb, 0x40],
            "c": [0xcb, 0x41],
            "d": [0xcb, 0x42],
            "e": [0xcb, 0x43],
            "h": [0xcb, 0x44],
            "l": [0xcb, 0x45],
            "(hl)": [0xcb, 0x46],
        },
        "1": {
            "a": [0xcb, 0x4f],
            "b": [0xcb, 0x48],
            "c": [0xcb, 0x49],
            "d": [0xcb, 0x4a],
            "e": [0xcb, 0x4b],
            "h": [0xcb, 0x4c],
            "l": [0xcb, 0x4d],
            "(hl)": [0xcb, 0x4e],
        },
        "2": {
            "a": [0xcb, 0x57],
            "b": [0xcb, 0x50],
            "c": [0xcb, 0x51],
            "d": [0xcb, 0x52],
            "e": [0xcb, 0x53],
            "h": [0xcb, 0x54],
            "l": [0xcb, 0x55],
            "(hl)": [0xcb, 0x56],
        },
        "3": {
            "a": [0xcb, 0x5f],
            "b": [0xcb, 0x58],
            "c": [0xcb, 0x59],
            "d": [0xcb, 0x5a],
            "e": [0xcb, 0x5b],
            "h": [0xcb, 0x5c],
            "l": [0xcb, 0x5d],
            "(hl)": [0xcb, 0x5e],
        },
        "4": {
            "a": [0xcb, 0x67],
            "b": [0xcb, 0x60],
            "c": [0xcb, 0x61],
            "d": [0xcb, 0x62],
            "e": [0xcb, 0x63],
            "h": [0xcb, 0x64],
            "l": [0xcb, 0x65],
            "(hl)": [0xcb, 0x66],
        },
        "5": {
            "a": [0xcb, 0x6f],
            "b": [0xcb, 0x68],
            "c": [0xcb, 0x69],
            "d": [0xcb, 0x6a],
            "e": [0xcb, 0x6b],
            "h": [0xcb, 0x6c],
            "l": [0xcb, 0x6d],
            "(hl)": [0xcb, 0x6e],
        },
        "6": {
            "a": [0xcb, 0x77],
            "b": [0xcb, 0x70],
            "c": [0xcb, 0x71],
            "d": [0xcb, 0x72],
            "e": [0xcb, 0x73],
            "h": [0xcb, 0x74],
            "l": [0xcb, 0x75],
            "(hl)": [0xcb, 0x76],
        },
        "7": {
            "a": [0xcb, 0x7f],
            "b": [0xcb, 0x78],
            "c": [0xcb, 0x79],
            "d": [0xcb, 0x7a],
            "e": [0xcb, 0x7b],
            "h": [0xcb, 0x7c],
            "l": [0xcb, 0x7d],
            "(hl)": [0xcb, 0x7e],
        },
    },
    "res": {
        "0": {
            "a": [0xcb, 0x87],
            "b": [0xcb, 0x80],
            "c": [0xcb, 0x81],
            "d": [0xcb, 0x82],
            "e": [0xcb, 0x83],
            "h": [0xcb, 0x84],
            "l": [0xcb, 0x85],
            "(hl)": [0xcb, 0x86],
        },
        "1": {
            "a": [0xcb, 0x8f],
            "b": [0xcb, 0x88],
            "c": [0xcb, 0x89],
            "d": [0xcb, 0x8a],
            "e": [0xcb, 0x8b],
            "h": [0xcb, 0x8c],
            "l": [0xcb, 0x8d],
            "(hl)": [0xcb, 0x8e],
        },
        "2": {
            "a": [0xcb, 0x97],
            "b": [0xcb, 0x90],
            "c": [0xcb, 0x91],
            "d": [0xcb, 0x92],
            "e": [0xcb, 0x93],
            "h": [0xcb, 0x94],
            "l": [0xcb, 0x95],
            "(hl)": [0xcb, 0x96],
        },
        "3": {
            "a": [0xcb, 0x9f],
            "b": [0xcb, 0x98],
            "c": [0xcb, 0x99],
            "d": [0xcb, 0x9a],
            "e": [0xcb, 0x9b],
            "h": [0xcb, 0x9c],
            "l": [0xcb, 0x9d],
            "(hl)": [0xcb, 0x9e],
        },
        "4": {
            "a": [0xcb, 0xa7],
            "b": [0xcb, 0xa0],
            "c": [0xcb, 0xa1],
            "d": [0xcb, 0xa2],
            "e": [0xcb, 0xa3],
            "h": [0xcb, 0xa4],
            "l": [0xcb, 0xa5],
            "(hl)": [0xcb, 0xa6],
        },
        "5": {
            "a": [0xcb, 0xaf],
            "b": [0xcb, 0xa8],
            "c": [0xcb, 0xa9],
            "d": [0xcb, 0xaa],
            "e": [0xcb, 0xab],
            "h": [0xcb, 0xac],
            "l": [0xcb, 0xad],
            "(hl)": [0xcb, 0xae],
        },
        "6": {
            "a": [0xcb, 0xb7],
            "b": [0xcb, 0xb0],
            "c": [0xcb, 0xb1],
            "d": [0xcb, 0xb2],
            "e": [0xcb, 0xb3],
            "h": [0xcb, 0xb4],
            "l": [0xcb, 0xb5],
            "(hl)": [0xcb, 0xb6],
        },
        "7": {
            "a": [0xcb, 0xbf],
            "b": [0xcb, 0xb8],
            "c": [0xcb, 0xb9],
            "d": [0xcb, 0xba],
            "e": [0xcb, 0xbb],
            "h": [0xcb, 0xbc],
            "l": [0xcb, 0xbd],
            "(hl)": [0xcb, 0xbe],
        },
    },
    "set": {
        "0": {
            "a": [0xcb, 0xc7],
            "b": [0xcb, 0xc0],
            "c": [0xcb, 0xc1],
            "d": [0xcb, 0xc2],
            "e": [0xcb, 0xc3],
            "h": [0xcb, 0xc4],
            "l": [0xcb, 0xc5],
            "(hl)": [0xcb, 0xc6],
        },
        "1": {
            "a": [0xcb, 0xcf],
            "b": [0xcb, 0xc8],
            "c": [0xcb, 0xc9],
            "d": [0xcb, 0xca],
            "e": [0xcb, 0xcb],
            "h": [0xcb, 0xcc],
            "l": [0xcb, 0xcd],
            "(hl)": [0xcb, 0xce],
        },
        "2": {
            "a": [0xcb, 0xd7],
            "b": [0xcb, 0xd0],
            "c": [0xcb, 0xd1],
            "d": [0xcb, 0xd2],
            "e": [0xcb, 0xd3],
            "h": [0xcb, 0xd4],
            "l": [0xcb, 0xd5],
            "(hl)": [0xcb, 0xd6],
        },
        "3": {
            "a": [0xcb, 0xdf],
            "b": [0xcb, 0xd8],
            "c": [0xcb, 0xd9],
            "d": [0xcb, 0xda],
            "e": [0xcb, 0xdb],
            "h": [0xcb, 0xdc],
            "l": [0xcb, 0xdd],
            "(hl)": [0xcb, 0xde],
        },
        "4": {
            "a": [0xcb, 0xe7],
            "b": [0xcb, 0xe0],
            "c": [0xcb, 0xe1],
            "d": [0xcb, 0xe2],
            "e": [0xcb, 0xe3],
            "h": [0xcb, 0xe4],
            "l": [0xcb, 0xe5],
            "(hl)": [0xcb, 0xe6],
        },
        "5": {
            "a": [0xcb, 0xef],
            "b": [0xcb, 0xe8],
            "c": [0xcb, 0xe9],
            "d": [0xcb, 0xea],
            "e": [0xcb, 0xeb],
            "h": [0xcb, 0xec],
            "l": [0xcb, 0xed],
            "(hl)": [0xcb, 0xee],
        },
        "6": {
            "a": [0xcb, 0xf7],
            "b": [0xcb, 0xf0],
            "c": [0xcb, 0xf1],
            "d": [0xcb, 0xf2],
            "e": [0xcb, 0xf3],
            "h": [0xcb, 0xf4],
            "l": [0xcb, 0xf5],
            "(hl)": [0xcb, 0xf6],
        },
        "7": {
            "a": [0xcb, 0xff],
            "b": [0xcb, 0xf8],
            "c": [0xcb, 0xf9],
            "d": [0xcb, 0xfa],
            "e": [0xcb, 0xfb],
            "h": [0xcb, 0xfc],
            "l": [0xcb, 0xfd],
            "(hl)": [0xcb, 0xfe],
        },
    },
}

OLD_MNEMONICS = {
    "nop": 0x00,
    "ld bc,d16": 0x01,
    "ld (bc),a": 0x02,
    "inc bc": 0x03,
    "inc b": 0x04,
    "dec b": 0x05,
    "ld b,d8": 0x06,
    "rlca": 0x07,
    "ld (a16),sp": 0x08,
    "add hl,bc": 0x09,
    "ld a,(bc)": 0x0a,
    "dec bc": 0x0b,
    "inc c": 0x0c,
    "dec c": 0x0d,
    "ld c,d8": 0x0e,
    "rrca": 0x0f,
    "stop 0": 0x10,

    "ld de,d16": 0x11,
    "ld (de),a": 0x12,
    "inc de": 0x13,
    "inc d": 0x14,
    "dec d": 0x15,
    "ld d,d8": 0x16,
    "rla": 0x17,
    "jr r8": 0x18,
    "add hl,de": 0x19,
    "ld a,(de)": 0x1a,
    "dec de": 0x1b,
    "inc e": 0x1c,
    "dec e": 0x1d,
    "ld e,d8": 0x1e,
    "rra": 0x1f,

    "jr nz,r8": 0x20,
    "ld hl,d16": 0x21,
    "ldi (hl),a": 0x22,
    "inc hl": 0x23,
    "inc h": 0x24,
    "dec h": 0x25,
    "ld h,d8": 0x26,
    "daa": 0x27,
    "jr z,r8": 0x28,
    "add hl,hl": 0x29,
    "ldi a,(hl)": 0x2a,
    "dec hl": 0x2b,
    "inc l": 0x2c,
    "dec l": 0x2d,
    "ld l,d8": 0x2e,
    "cpl": 0x2f,

    "jr nc,r8": 0x30,
    "ld sp,d16": 0x31,
    "ldd (hl),a": 0x32,
    "inc sp": 0x33,
    "inc (hl)": 0x34,
    "dec (hl)": 0x35,
    "ld (hl),d8": 0x36,
    "scf": 0x37,
    "jr c,r8": 0x38,
    "add hl,sp": 0x39,
    "ldd a,(hl)": 0x3a,
    "dec sp": 0x3b,
    "inc a": 0x3c,
    "dec a": 0x3d,
    "ld a,d8": 0x3e,
    "ccf": 0x3f,

    "ld b,b": 0x40,
    "ld b,c": 0x41,
    "ld b,d": 0x42,
    "ld b,e": 0x43,
    "ld b,h": 0x44,
    "ld b,l": 0x45,
    "ld b,(hl)": 0x46,
    "ld b,a": 0x47,
    "ld c,b": 0x48,
    "ld c,c": 0x49,
    "ld c,d": 0x4a,
    "ld c,e": 0x4b,
    "ld c,h": 0x4c,
    "ld c,l": 0x4d,
    "ld c,(hl)": 0x4e,
    "ld c,a": 0x4f,

    "ld d,b": 0x50,
    "ld d,c": 0x51,
    "ld d,d": 0x52,
    "ld d,e": 0x53,
    "ld d,h": 0x54,
    "ld d,l": 0x55,
    "ld d,(hl)": 0x56,
    "ld d,a": 0x57,
    "ld e,b": 0x58,
    "ld e,c": 0x59,
    "ld e,d": 0x5a,
    "ld e,e": 0x5b,
    "ld e,h": 0x5c,
    "ld e,l": 0x5d,
    "ld e,(hl)": 0x5e,
    "ld e,a": 0x5f,

    "ld h,b": 0x60,
    "ld h,c": 0x61,
    "ld h,d": 0x62,
    "ld h,e": 0x63,
    "ld h,h": 0x64,
    "ld h,l": 0x65,
    "ld h,(hl)": 0x66,
    "ld h,a": 0x67,
    "ld l,b": 0x68,
    "ld l,c": 0x69,
    "ld l,d": 0x6a,
    "ld l,e": 0x6b,
    "ld l,h": 0x6c,
    "ld l,l": 0x6d,
    "ld l,(hl)": 0x6e,
    "ld l,a": 0x6f,

    "ld (hl),b": 0x70,
    "ld (hl),c": 0x71,
    "ld (hl),d": 0x72,
    "ld (hl),e": 0x73,
    "ld (hl),h": 0x74,
    "ld (hl),l": 0x75,
    "halt": 0x76,
    "ld (hl),a": 0x77,
    "ld a,b": 0x78,
    "ld a,c": 0x79,
    "ld a,d": 0x7a,
    "ld a,e": 0x7b,
    "ld a,h": 0x7c,
    "ld a,l": 0x7d,
    "ld a,(hl)": 0x7e,
    "ld a,a": 0x7f,

    "add a,b": 0x80,
    "add a,c": 0x81,
    "add a,d": 0x82,
    "add a,e": 0x83,
    "add a,h": 0x84,
    "add a,l": 0x85,
    "add a,(hl)": 0x86,
    "add a,a": 0x87,
    "adc a,b": 0x88,
    "adc a,c": 0x89,
    "adc a,d": 0x8a,
    "adc a,e": 0x8b,
    "adc a,h": 0x8c,
    "adc a,l": 0x8d,
    "adc a,(hl)": 0x8e,
    "adc a,a": 0x8f,

    "sub b": 0x90,
    "sub c": 0x91,
    "sub d": 0x92,
    "sub e": 0x93,
    "sub h": 0x94,
    "sub l": 0x95,
    "sub (hl)": 0x96,
    "sub a": 0x97,
    "sbc a,b": 0x98,
    "sbc a,c": 0x99,
    "sbc a,d": 0x9a,
    "sbc a,e": 0x9b,
    "sbc a,h": 0x9c,
    "sbc a,l": 0x9d,
    "sbc a,(hl)": 0x9e,
    "sbc a,a": 0x9f,

    "and b": 0xa0,
    "and c": 0xa1,
    "and d": 0xa2,
    "and e": 0xa3,
    "and h": 0xa4,
    "and l": 0xa5,
    "and (hl)": 0xa6,
    "and a": 0xa7,
    "xor b": 0xa8,
    "xor c": 0xa9,
    "xor d": 0xaa,
    "xor e": 0xab,
    "xor h": 0xac,
    "xor l": 0xad,
    "xor (hl)": 0xae,
    "xor a": 0xaf,

    "or b": 0xb0,
    "or c": 0xb1,
    "or d": 0xb2,
    "or e": 0xb3,
    "or h": 0xb4,
    "or l": 0xb5,
    "or (hl)": 0xb6,
    "or a": 0xb7,
    "cp b": 0xb8,
    "cp c": 0xb9,
    "cp d": 0xba,
    "cp e": 0xbb,
    "cp h": 0xbc,
    "cp l": 0xbd,
    "cp (hl)": 0xbe,
    "cp a": 0xbf,

    "ret nz": 0xc0,
    "pop bc": 0xc1,
    "jp nz,a16": 0xc2,
    "jp a16": 0xc3,
    "call nz,a16": 0xc4,
    "push bc": 0xc5,
    "add a,d8": 0xc6,
    "rst 00": 0xc7,
    "ret z": 0xc8,
    "ret": 0xc9,
    "jp z,a16": 0xca,
    "prefix cb": 0xcb,
    "call z,a16": 0xcc,
    "call a16": 0xcd,
    "adc a,d8": 0xce,
    "rst 08": 0xcf,

    "ret nc": 0xd0,
    "pop de": 0xd1,
    "jp nc,a16": 0xd2,

    "call nc,a16": 0xd4,
    "push de": 0xd5,
    "sub a,d8": 0xd6,
    "rst 10": 0xd7,
    "ret c": 0xd8,
    "reti": 0xd9,
    "jp c,a16": 0xda,

    "call c,a16": 0xdc,

    "sbc a,d8": 0xde,
    "rst 18": 0xdf,

    "ld (ff00+a8),a": 0xe0,
    "pop hl": 0xe1,
    "ld (ff00+c),a": 0xe2,


    "push hl": 0xe5,
    "and a,d8": 0xe6,
    "rst 20": 0xe7,
    "add sp,r8": 0xe8,
    "jp (hl)": 0xe9,
    "ld (a16),a": 0xea,



    "xor a,d8": 0xee,
    "rst 28": 0xef,

    "ld a,(ff00+a8)": 0xf0,
    "pop af": 0xf1,
    "ld a,(ff00+c)": 0xf2,
    "di": 0xf3,

    "push af": 0xf5,
    "or a,d8": 0xf6,
    "rst 30": 0xf7,
    "ld hl,sp+r8": 0xf8,
    "ld sp,hl": 0xf9,
    "ld a,(a16)": 0xfa,
    "ei": 0xfb,

    "cp a,d8": 0xfe,
    "rst 38": 0xff,
}
CB_MNEMONICS = {
    'rlc b': 0x00,
    'rlc c': 0x01,
    'rlc d': 0x02,
    'rlc e': 0x03,
    'rlc h': 0x04,
    'rlc l': 0x05,
    'rlc (hl)': 0x06,
    'rlc a': 0x07,

    'rrc b': 0x08,
    'rrc c': 0x09,
    'rrc d': 0x0a,
    'rrc e': 0x0b,
    'rrc h': 0x0c,
    'rrc l': 0x0d,
    'rrc (hl)': 0x0e,
    'rrc a': 0x0f,

    'rl b': 0x10,
    'rl c': 0x11,
    'rl d': 0x12,
    'rl e': 0x13,
    'rl h': 0x14,
    'rl l': 0x15,
    'rl (hl)': 0x16,
    'rl a': 0x17,

    'rr b': 0x18,
    'rr c': 0x19,
    'rr d': 0x1a,
    'rr e': 0x1b,
    'rr h': 0x1c,
    'rr l': 0x1d,
    'rr (hl)': 0x1e,
    'rr a': 0x1f,

    'sla b': 0x20,
    'sla c': 0x21,
    'sla d': 0x22,
    'sla e': 0x23,
    'sla h': 0x24,
    'sla l': 0x25,
    'sla (hl)': 0x26,
    'sla a': 0x27,

    'sra b': 0x28,
    'sra c': 0x29,
    'sra d': 0x2a,
    'sra e': 0x2b,
    'sra h': 0x2c,
    'sra l': 0x2d,
    'sra (hl)': 0x2e,
    'sra a': 0x2f,

    'swap b': 0x30,
    'swap c': 0x31,
    'swap d': 0x32,
    'swap e': 0x33,
    'swap h': 0x34,
    'swap l': 0x35,
    'swap (hl)': 0x36,
    'swap a': 0x37,

    'srl b': 0x38,
    'srl c': 0x39,
    'srl d': 0x3a,
    'srl e': 0x3b,
    'srl h': 0x3c,
    'srl l': 0x3d,
    'srl (hl)': 0x3e,
    'srl a': 0x3f,

    'bit 0,b': 0x40,
    'bit 0,c': 0x41,
    'bit 0,d': 0x42,
    'bit 0,e': 0x43,
    'bit 0,h': 0x44,
    'bit 0,l': 0x45,
    'bit 0,(hl)': 0x46,
    'bit 0,a': 0x47,

    'bit 1,b': 0x48,
    'bit 1,c': 0x49,
    'bit 1,d': 0x4a,
    'bit 1,e': 0x4b,
    'bit 1,h': 0x4c,
    'bit 1,l': 0x4d,
    'bit 1,(hl)': 0x4e,
    'bit 1,a': 0x4f,
    'bit 2,b': 0x50,
    'bit 2,c': 0x51,
    'bit 2,d': 0x52,
    'bit 2,e': 0x53,
    'bit 2,h': 0x54,
    'bit 2,l': 0x55,
    'bit 2,(hl)': 0x56,
    'bit 2,a': 0x57,
    'bit 3,b': 0x58,
    'bit 3,c': 0x59,
    'bit 3,d': 0x5a,
    'bit 3,e': 0x5b,
    'bit 3,h': 0x5c,
    'bit 3,l': 0x5d,
    'bit 3,(hl)': 0x5e,
    'bit 3,a': 0x5f,
    'bit 4,b': 0x60,
    'bit 4,c': 0x61,
    'bit 4,d': 0x62,
    'bit 4,e': 0x63,
    'bit 4,h': 0x64,
    'bit 4,l': 0x65,
    'bit 4,(hl)': 0x66,
    'bit 4,a': 0x67,
    'bit 5,b': 0x68,
    'bit 5,c': 0x69,
    'bit 5,d': 0x6a,
    'bit 5,e': 0x6b,
    'bit 5,h': 0x6c,
    'bit 5,l': 0x6d,
    'bit 5,(hl)': 0x6e,
    'bit 5,a': 0x6f,
    'bit 6,b': 0x70,
    'bit 6,c': 0x71,
    'bit 6,d': 0x72,
    'bit 6,e': 0x73,
    'bit 6,h': 0x74,
    'bit 6,l': 0x75,
    'bit 6,(hl)': 0x76,
    'bit 6,a': 0x77,
    'bit 7,b': 0x78,
    'bit 7,c': 0x79,
    'bit 7,d': 0x7a,
    'bit 7,e': 0x7b,
    'bit 7,h': 0x7c,
    'bit 7,l': 0x7d,
    'bit 7,(hl)': 0x7e,
    'bit 7,a': 0x7f,

    'res 0,b': 0x80,
    'res 0,c': 0x81,
    'res 0,d': 0x82,
    'res 0,e': 0x83,
    'res 0,h': 0x84,
    'res 0,l': 0x85,
    'res 0,(hl)': 0x86,
    'res 0,a': 0x87,
    'res 1,b': 0x88,
    'res 1,c': 0x89,
    'res 1,d': 0x8a,
    'res 1,e': 0x8b,
    'res 1,h': 0x8c,
    'res 1,l': 0x8d,
    'res 1,(hl)': 0x8e,
    'res 1,a': 0x8f,
    'res 2,b': 0x90,
    'res 2,c': 0x91,
    'res 2,d': 0x92,
    'res 2,e': 0x93,
    'res 2,h': 0x94,
    'res 2,l': 0x95,
    'res 2,(hl)': 0x96,
    'res 2,a': 0x97,
    'res 3,b': 0x98,
    'res 3,c': 0x99,
    'res 3,d': 0x9a,
    'res 3,e': 0x9b,
    'res 3,h': 0x9c,
    'res 3,l': 0x9d,
    'res 3,(hl)': 0x9e,
    'res 3,a': 0x9f,
    'res 4,b': 0xa0,
    'res 4,c': 0xa1,
    'res 4,d': 0xa2,
    'res 4,e': 0xa3,
    'res 4,h': 0xa4,
    'res 4,l': 0xa5,
    'res 4,(hl)': 0xa6,
    'res 4,a': 0xa7,
    'res 5,b': 0xa8,
    'res 5,c': 0xa9,
    'res 5,d': 0xaa,
    'res 5,e': 0xab,
    'res 5,h': 0xac,
    'res 5,l': 0xad,
    'res 5,(hl)': 0xae,
    'res 5,a': 0xaf,
    'res 6,b': 0xb0,
    'res 6,c': 0xb1,
    'res 6,d': 0xb2,
    'res 6,e': 0xb3,
    'res 6,h': 0xb4,
    'res 6,l': 0xb5,
    'res 6,(hl)': 0xb6,
    'res 6,a': 0xb7,
    'res 7,b': 0xb8,
    'res 7,c': 0xb9,
    'res 7,d': 0xba,
    'res 7,e': 0xbb,
    'res 7,h': 0xbc,
    'res 7,l': 0xbd,
    'res 7,(hl)': 0xbe,
    'res 7,a': 0xbf,

    'set 0,b': 0xc0,
    'set 0,c': 0xc1,
    'set 0,d': 0xc2,
    'set 0,e': 0xc3,
    'set 0,h': 0xc4,
    'set 0,l': 0xc5,
    'set 0,(hl)': 0xc6,
    'set 0,a': 0xc7,
    'set 1,b': 0xc8,
    'set 1,c': 0xc9,
    'set 1,d': 0xca,
    'set 1,e': 0xcb,
    'set 1,h': 0xcc,
    'set 1,l': 0xcd,
    'set 1,(hl)': 0xce,
    'set 1,a': 0xcf,
    'set 2,b': 0xd0,
    'set 2,c': 0xd1,
    'set 2,d': 0xd2,
    'set 2,e': 0xd3,
    'set 2,h': 0xd4,
    'set 2,l': 0xd5,
    'set 2,(hl)': 0xd6,
    'set 2,a': 0xd7,
    'set 3,b': 0xd8,
    'set 3,c': 0xd9,
    'set 3,d': 0xda,
    'set 3,e': 0xdb,
    'set 3,h': 0xdc,
    'set 3,l': 0xdd,
    'set 3,(hl)': 0xde,
    'set 3,a': 0xdf,
    'set 4,b': 0xe0,
    'set 4,c': 0xe1,
    'set 4,d': 0xe2,
    'set 4,e': 0xe3,
    'set 4,h': 0xe4,
    'set 4,l': 0xe5,
    'set 4,(hl)': 0xe6,
    'set 4,a': 0xe7,
    'set 5,b': 0xe8,
    'set 5,c': 0xe9,
    'set 5,d': 0xea,
    'set 5,e': 0xeb,
    'set 5,h': 0xec,
    'set 5,l': 0xed,
    'set 5,(hl)': 0xee,
    'set 5,a': 0xef,
    'set 6,b': 0xf0,
    'set 6,c': 0xf1,
    'set 6,d': 0xf2,
    'set 6,e': 0xf3,
    'set 6,h': 0xf4,
    'set 6,l': 0xf5,
    'set 6,(hl)': 0xf6,
    'set 6,a': 0xf7,
    'set 7,b': 0xf8,
    'set 7,c': 0xf9,
    'set 7,d': 0xfa,
    'set 7,e': 0xfb,
    'set 7,h': 0xfc,
    'set 7,l': 0xfd,
    'set 7,(hl)': 0xfe,
    'set 7,a': 0xff,
}
