from .Constants import *

BASE_LOCATION_ID = 27022002000

LOCATIONS_DATA = {
    ##########################################
    "Impa Gift": {
        "region_id": "starting item",
        "vanilla_item": "Progressive Sword",
        "flag_byte": 0xc739,
        "room": 0x0039,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "impaGift",
    },
    "Nayru's House": {
        "region_id": "nayru's house",
        "vanilla_item": "Progressive Harp",
        "flag_byte": 0xc8ae, 
        "room": 0x03ae,
        "map_tile": 0x3a,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "nayruHouse",
    },
    ##########################################
    "Lynna City Chest": {
        "region_id": "lynna city chest",
        "vanilla_item": "Rupees (30)",
        "flag_byte": 0xc749,
        "room": 0x0049,
        "collect": COLLECT_CHEST,
    },
    # -----
    "Lynna Shop #1": {
        "region_id": "lynna shop",
        "vanilla_item": "Progressive Shield",
        "flag_byte": 0xc643,
        "room": 0x025e,
        "map_tile": 0x68,
        "bit_mask": 0x20,
        "scouting_byte": 0xc75e,
        "scouting_mask": 0x10,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "lynnaShop1",
    },
    "Lynna Shop #2": {
        "region_id": "lynna shop",
        "vanilla_item": "Bombs (10)",
        "flag_byte": 0xc643,
        "room": 0x025e,
        "map_tile": 0x68,
        "bit_mask": 0x40,
        "scouting_byte": 0xc75e,
        "scouting_mask": 0x10,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "lynnaShop2",
    },
    "Lynna Shop #3": {
        "region_id": "lynna shop",
        "vanilla_item": "Flute",
        "flag_byte": 0xc643,
        "room": 0x025e,
        "map_tile": 0x68,
        "bit_mask": 0x80,
        "scouting_byte": 0xc75e,
        "scouting_mask": 0x10,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "lynnaShop3",
    },
    # -----
    "Hidden Shop #1": {
        "region_id": "hidden shop",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xc642,
        "room": 0x027e,
        "bit_mask": 0x01,
        "scouting_byte": 0xc77e,
        "scouting_mask": 0x10,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "hiddenShop1",
    },
    "Hidden Shop #2": {
        "region_id": "hidden shop",
        "vanilla_item": "Piece of Heart",
        "flag_byte": 0xc642,
        "room": 0x027e,
        "bit_mask": 0x02,
        "scouting_byte": 0xc77e,
        "scouting_mask": 0x10,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "hiddenShop2",
    },
    "Hidden Shop #3": {
        "region_id": "hidden shop",
        "vanilla_item": "Biggoron's Sword", # That's not the Ring box you're looking for.
        "flag_byte": 0xc642,
        "room": 0x027e,
        "bit_mask": 0x08,
        "scouting_byte": 0xc77e,
        "scouting_mask": 0x10,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "hiddenShop3",
    },
    # -----
    "Mayor Plen's House": {
        "region_id": "mayor plen's house",
        "vanilla_item": "Green Luck Ring",
        "flag_byte": 0xc8f9,
        "room": 0x03f9,
        "map_tile": 0x57,
        "collect": COLLECT_CHEST,
    },
    "Vasu's Gift": {
        "region_id":"vasu's gift",
        "vanilla_item": "Friendship Ring",
        "flag_byte": 0xc615,
        "bit_mask": 0x01,
        "room": 0x02ee,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "vasuGift",
    },
    ##########################################
    "Black Tower Worker": {
        "region_id": "black tower worker",
        "vanilla_item": "Shovel",
        "flag_byte": 0xc9e1,
        "room": 0x04e1,
        "map_tile": 0x176,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "towerWorker",
    },
    "Gasha Farmer": {
        "region_id": "gasha farmer",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xc8fc,
        "room": 0x03fc,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "gashaFarmer",
    },
    # -----
    "Advance Shop #1": {
        "region_id": "advance shop",
        "vanilla_item": "Rupees (100)",
        "flag_byte": 0xc643,
        "room": 0x03ed,
        "bit_mask": 0x01,
        "scouting_byte": 0xc8fe,
        "scouting_mask": 0x10,
        "conditional": True,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "advanceShop1",
    },
    "Advance Shop #2": {
        "region_id": "advance shop",
        "vanilla_item": "GBA Time Ring",
        "flag_byte": 0xc643,
        "bit_mask": 0x02,
        "room": 0x03ed,
        "scouting_byte": 0xc8fe,
        "scouting_mask": 0x10,
        "conditional": True,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "advanceShop2",
    },
    "Advance Shop #3": {
        "region_id": "advance shop",
        "vanilla_item": "Rupees (100)",
        "flag_byte": 0xc643,
        "bit_mask": 0x04,
        "room": 0x03ed,
        "scouting_byte": 0xc8fe,
        "scouting_mask": 0x10,
        "conditional": True,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "advanceShop3",
    },
    # -----
    "Ambi's Palace Chest": {
        "region_id": "ambi's palace chest",
        "vanilla_item": "Gold Luck Ring",
        "flag_byte": 0xcacb,
        "room": 0x05cb,
        "map_tile": 0x107,
        "collect": COLLECT_CHEST,
    },
    "Rescue Nayru": {
        "region_id": "rescue nayru",
        "vanilla_item": "Progressive Harp",
        "flag_byte": 0xc6d1,
        "bit_mask": 0x20,
        "room": 0x0038,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "rescueNayru",
    },
    "Lynna Village Shooting Gallery": {
        "region_id": "lynna shooting gallery",
        "vanilla_item": "Red Ring",
        "flag_byte": 0xc6d9,
        "bit_mask": 0x02,
        "room": 0x02e9,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "lynnaShootingGallery",
    },
    ##########################################
    "Maku Tree gift": {
        "region_id": "maku tree",
        "vanilla_item": "Seed Satchel",
        "flag_byte": 0xc738,
        "room": 0x0038,
        "map_tile": 0x38,
        "collect": COLLECT_MAKU_TREE,
        "symbolic_name": "makuTreeGift",
    },
    # Maku seed is 0xC85D
    ##########################################
    "Shore Dirt Spot": {
        "region_id": "south shore dirt",
        "vanilla_item": "Ricky's Gloves",
        "flag_byte": 0xc798,
        "room": 0x0098,
        "collect": COLLECT_DIG,
        "symbolic_name": "southShoreDirt",
    },
    "Tingle Present": {
        "region_id": "balloon guy's gift",
        "vanilla_item": "Island Chart",
        "flag_byte": 0xc6d0,
        "bit_mask": 0x08,
        "room": 0x0079,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "tingleGift",
    },
    "Tingle Upgrade": {
        "region_id": "balloon guy's upgrade",
        "vanilla_item": "Seed Satchel",
        "flag_byte": 0xc6d8,
        "bit_mask": 0x40,
        "room": 0x0079,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "tingleUpgrade",
    },
    ##########################################
    
    "Cheval's Test": {
        "region_id": "cheval's test",
        "vanilla_item": "Progressive Flippers",
        "flag_byte": 0xcabf,
        "room": 0x05bf,
        "map_tile": 0x5b,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "chevalTest",
    },
    "Cheval's Invention": {
        "region_id": "cheval's invention",
        "vanilla_item": "Cheval Rope",
        "flag_byte": 0xcab6,
        "room": 0x05b6,
        "map_tile": 0x5b,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "chevalInvention",
    },
    "Grave Under The Tree": {
        "region_id": "grave under tree",
        "vanilla_item": "Graveyard Key",
        "flag_byte": 0xcaed,
        "room": 0x05ed,
        "map_tile": 0x8d,
        "collect": COLLECT_DROP,
        "symbolic_name": "graveUnderTree",
    },
    # -----
    "Syrup Shop #1": {
        "region_id": "syrup shop",
        "vanilla_item": "King Zora's Potion",
        "flag_byte": 0xc642,
        "room": 0x03fe,
        "bit_mask": 0x80,
        "scouting_byte": 0xc8ed,
        "scouting_mask": 0x10,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "syrupShop1",
    },
    "Syrup Shop #2": {
        "region_id": "syrup shop",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xc642,
        "room": 0x03fe,
        "bit_mask": 0x20,
        "scouting_byte": 0xc8ed,
        "scouting_mask": 0x10,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "syrupShop2",
    },
    "Syrup Shop #3": {
        "region_id": "syrup shop",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xc642,
        "room": 0x03fe,
        "bit_mask": 0x40,
        "scouting_byte": 0xc8ed,
        "scouting_mask": 0x10,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "syrupShop3",
    },
    ##########################################
    "Fairies' Woods Chest": {
        "region_id": "fairies' woods chest",
        "vanilla_item": "Rupees (20)",
        "flag_byte": 0xc784,
        "room": 0x0084,
        "collect": COLLECT_CHEST,
    },
    ##########################################
    "Deku Forest Cave East": {
        "region_id": "deku forest cave east",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xcab3,
        "room": 0x05b3,
        "map_tile": 0x172,
        "collect": COLLECT_CHEST,
    },
    "Deku Forest Cave West": {
        "region_id": "deku forest cave west",
        "vanilla_item": "Rupees (30)",
        "flag_byte": 0xcab5,
        "room": 0x05b5,
        "map_tile": 0x171,
        "collect": COLLECT_CHEST,
    },
    "Deku Forest Soldier": {
        "region_id": "deku forest soldier",
        "vanilla_item": "Bombs (10)",
        "flag_byte": 0xc6d9,
        "bit_mask": 0x04,
        "room": 0x0172,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "dekuForestSoldier",
    },
    ##########################################
    "Hidden Tokay Cave": {
        "region_id": "hidden tokay cave",
        "vanilla_item": "Progressive Shield",
        "flag_byte": 0xcae9,
        "room": 0x05e9,
        "map_tile": 0x1d9,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "hiddenTokayCave",
    },
    "Tokay Crystal Cave": {
        "region_id": "tokay crystal cave",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xcaca,
        "room": 0x05ca,
        "map_tile": 0x1bb,
        "collect": COLLECT_CHEST,
    },
    "Tokay Bomb Cave": {
        "region_id": "tokay bomb cave",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xc7ce,
        "room": 0x02ce,
        "map_tile": 0x1cd,
        "collect": COLLECT_CHEST,
    },
    "Wild Tokay Game": {
        "region_id": "wild tokay game",
        "vanilla_item": "Scent Seedling",
        "flag_byte": 0xc7de,
        "room": 0x02de,
        "map_tile": 0x1bd,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "wildTokayGame",
    },
    "Tokay Market #1": {
        "region_id": "tokay market 1",
        "vanilla_item": "Progressive Shield",
        "flag_byte": 0xc6d6,
        "room": 0x02e4,
        "bit_mask": 0x40,
        "scouting_byte": 0xc7e4,
        "scouting_mask": 0x10,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "tokayMarket1",
    },
    "Tokay Market #2": {
        "region_id": "tokay market 2",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xc6d6,
        "room": 0x02e4,
        "bit_mask": 0x80,
        "scouting_byte": 0xc7e4,
        "scouting_mask": 0x10,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "tokayMarket2",
    },
    "Tokay Pot Cave": {
        "region_id": "tokay pot cave",
        "vanilla_item": "Power Ring L-2",
        "flag_byte": 0xcaf7,
        "room": 0x05f7,
        "map_tile": 0x1dd,
        "collect": COLLECT_CHEST,
    },
    ##########################################
    "Under Crescent Island": {
        "region_id": "under crescent island",
        "vanilla_item": "Piece of Heart",
        "flag_byte": 0xc8fd,
        "room": 0x03fd,
        "map_tile": 0xba,
        "collect": COLLECT_CHEST,
    },
    ##########################################
    "Nuun Highlands Cave": {
        "region_id": "nuun highlands cave",
        "vanilla_item": "Light Ring L-1",
        "flag_byte": [0xc7ec, 0xcab8, 0xc7f4],
        "room": [0x02ec, 0x05b8, 0x02f4], # Rick, Dim & Moosh respectively
        "map_tile": 0x37, 
        "collect": COLLECT_CHEST,
    },
    ##########################################
    "Symmetry City Brothers": {
        "region_id": "symmetry city brother",
        "vanilla_item": "Cracked Tuni Nut",
        "flag_byte": [0xc86e, 0xc86f],
        "room": [0x036e, 0x036f],
        "map_tile": 0x104,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "symmetryCityBrother",
    },
    "Tokkey's Composition": {
        "region_id": "tokkey's composition",
        "vanilla_item": "Progressive Harp",
        "flag_byte": 0xc88f,
        "room": 0x038f,
        "map_tile": 0x101,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "tokkeyComposition",
    },
    ##########################################
    "Bomb Fairy": {
        "region_id": "bomb fairy",
        "vanilla_item": "Bombs (10)", # "Bomb Upgrade",
        "flag_byte": 0xc6d3,
        "bit_mask": 0x10,
        "room": 0x0050,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "bombFairy",
    },
    "Talus Peaks Chest": {
        "region_id": "talus peaks chest",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xc763,
        "room": 0x0063,
        "collect": COLLECT_CHEST,
    },
    ##########################################
    "Patch Tuni Nut Ceremony": {
        "region_id": "patch tuni nut ceremony",
        "vanilla_item": "Tuni Nut",
        "flag_byte": 0xc6d3,
        "room": 0x03be,
        "bit_mask": 0x40,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "patchTuni",
    },
    "Patch Broken Sword Ceremony": {
        "region_id": "patch broken sword ceremony",
        "vanilla_item": "Progressive Sword",
        "flag_byte": 0xc6d5,
        "room": 0x03be,
        "bit_mask": 0x20,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "patchSword",
    },
    ##########################################
    "Goron Elder": {
        "region_id": "goron elder",
        "vanilla_item": "Crown Key",
        "flag_byte": 0xcac3,
        "room": 0x05c3,
        "map_tile": 0x128,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "goronElder",
    },
    ##########################################
    "Ridge West Surface Stair": {
        "region_id": "ridge west cave",
        "vanilla_item": "Rupees (30)",
        "flag_byte": 0xcac0,
        "room": 0x05c0,
        "map_tile": 0x18,
        "collect": COLLECT_CHEST,
    },
    "Under Moblin Keep": {
        "region_id": "under moblin keep",
        "vanilla_item": "Armor Ring L-1",
        "flag_byte": 0xc7be,
        "room": 0x02be,
        "map_tile": 0x09,
        "collect": COLLECT_CHEST,
    },
    "Defeat Great Moblin": {
        "region_id": "defeat great moblin",
        "vanilla_item": "Bomb Flower",
        "flag_byte": 0xc709,
        "room": 0x0009,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "defeatGreatMoblin",
    },
    "Goron's Hiding Place": {
        "region_id": "goron's hiding place",
        "vanilla_item": "Golden Joy Ring",
        "flag_byte": 0xcabd,
        "room": 0x05bd,
        "map_tile": 0x28,
        "collect": COLLECT_CHEST,
    },
    "Ridge Chest West Base On Terrace": {
        "region_id": "ridge base chest",
        "vanilla_item": "Rupees (50)",
        "flag_byte": 0xcab9,
        "room": 0x05b9,
        "map_tile": 0x28,
        "collect": COLLECT_CHEST,
    },
    ##########################################
    "Bomb Goron Head": {
        "region_id": "bomb goron head",
        "vanilla_item": "Rupees (100)",
        "flag_byte": 0xc7fc,
        "room": 0x02fc,
        "map_tile": 0x10d,
        "collect": COLLECT_CHEST,
    },
    "Treasure Hunting Goron": {
        "region_id": "treasure hunting goron",
        "vanilla_item": "Red Luck Ring",
        "flag_byte": 0xc7f7,
        "room": 0x02f7,
        "collect": COLLECT_CHEST,
    },
    ##########################################
    #"Rolling Ridge Past Old Man": {
    #    "region_id": "rolling ridge past old man",
    #    "vanilla_item": "Rupees (300)",
    #    "flag_byte": 0xFFFF,
    #},
    "First Goron Dance": {
        "region_id": "first goron dance",
        "vanilla_item": "Brother Emblem",
        "flag_byte": 0xc6d0,
        "bit_mask": 0x80,
        "room": [0x2ed, 0x2ef], # present & past
        "map_tile": 0x13d,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "goronDance1",
    },
    "Goron Dance, With Letter": {
        "region_id": "goron dance, with letter",
        "vanilla_item": "Mermaid Key",
        "flag_byte": 0xc6d1,
        "bit_mask": 0x08,
        "room": 0x2ef,
        "map_tile": 0x13d,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "goronDance2",
    },
    "Trade Goron Vase": {
        "region_id": "trade goron vase",
        "vanilla_item": "Goronade",
        "flag_byte": 0xc7ff,
        "room": 0x02ff,
        "map_tile": 0x13d,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "tradeGoronVase",
    },
    ##########################################
    "Ridge Base Past Bomb": {
        "region_id": "ridge base bomb past",
        "vanilla_item": "Rupees (50)",
        "flag_byte": 0xcae0,
        "room": 0x05e0,
        "map_tile": 0x12b,
        "collect": COLLECT_CHEST,
    },
    "Ridge Diamonds Past": {
        "region_id": "ridge diamonds past",
        "vanilla_item": "Rupees (50)",
        "flag_byte": 0xcae1,
        "room": 0x05e1,
        "map_tile": 0x12b,
        "collect": COLLECT_CHEST,
    },
    ##########################################
    "Pool in d6 Entrance": {
        "region_id": "pool in d6 entrance",
        "vanilla_item": "Toss Ring",
        "flag_byte": 0xc80e,
        "room": 0x030e,
        "map_tile": 0x3c,
        "collect": COLLECT_CHEST,
    },
    "Trade Rock Brisket": {
        "region_id": "trade rock brisket",
        "vanilla_item": "Goron Vase",
        "flag_byte": 0xc7fd,
        "room": 0x02fd,
        "map_tile": 0x3d,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "tradeRockBrisket",
    },
    ##########################################
    "Goron shooting gallery Price": {
        "region_id": "goron shooting gallery price",
        "vanilla_item": "Lava Juice",
        "flag_byte": 0xc8e7,
        "room": 0x03e7,
        "map_tile": 0x11d,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "goronShootingGallery",
    },
    "Trade Lava Juice": {
        "region_id": "trade lava juice",
        "vanilla_item": "Letter of Introduction",
        "flag_byte": 0xc81f, 
        "room": 0x031f,
        "bit_mask": 0x40,
        "map_tile": 0x11c,
        "collect": COLLECT_GORON_BUSH_ROOM,
        "symbolic_name": "tradeLavaJuice",
    },
    "Ridge Bush Cave": {
        "region_id": "ridge bush cave",
        "vanilla_item": "Rupees (100)",
        "flag_byte": 0xc81f, 
        "room": 0x031f,
        "map_tile": 0x11c,
        "collect": COLLECT_GORON_BUSH_ROOM,
    },
    ##########################################
    "target carts 1": {
        "region_id": "target carts 1",
        "vanilla_item": "Rock Brisket",
        "flag_byte": 0xcad8,
        "bit_mask": 0x20,
        "room": 0x05d8,
        "map_tile": 0x1d,
        "collect": COLLECT_TARGET_CART,
        "symbolic_name": "targetCart1",
    },
    "target carts 2": {
        "region_id": "target carts 2",
        "vanilla_item": "Boomerang",
        "flag_byte": 0xcad8,
        "bit_mask": 0x40,
        "room": 0x05d8,
        "map_tile": 0x1d,
        "collect": COLLECT_TARGET_CART,
        "symbolic_name": "targetCart2",
    },
    "Big Bang Game": {
        "region_id": "big bang game",
        "vanilla_item": "Old Mermaid Key",
        "flag_byte": 0xc83e,
        "room": 0x033e,
        "map_tile": 0x1c,
        "collect": COLLECT_BIGBANG,
        "symbolic_name": "bigBangGame",
    },
    "Ridge NE Cave Present": {
        "region_id": "ridge NE cave present",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xcaee,
        "room": 0x05ee,
        "map_tile": 0x0d,
        "collect": COLLECT_CHEST,
    },
    "Goron Diamond Cave": {
        "region_id": "goron diamond cave",
        "vanilla_item": "Bombs (10)",
        "flag_byte": 0xcadd,
        "room": 0x05dd,
        "map_tile": 0x1c,
        "collect": COLLECT_CHEST,
    },
    ##########################################
    "Zora Village Present Chest": {
        "region_id": "zora village present",
        "vanilla_item": "Gasha Seed",
        "flag_byte": 0xc7c0,
        "room": 0x02c0,
        "collect": COLLECT_CHEST,
    },
    "Zora Palace Chest": {
        "region_id": "zora palace chest",
        "vanilla_item": "Rupees (200)",
        "flag_byte": 0xcaac,
        "room": 0x05ac,
        "map_tile": 0xa1,
        "collect": COLLECT_CHEST,
    },
    "Zora NW Cave": {
        "region_id": "zora NW cave",
        "vanilla_item": "Blue Luck Ring",
        "flag_byte": 0xcac7,
        "room": 0x05c7,
        "map_tile": 0xa0,
        "collect": COLLECT_CHEST,
    },
    "Fairies' Coast Chest": {
        "region_id": "fairies' coast chest",
        "vanilla_item": "Green Holy Ring",
        "flag_byte": 0xc791,
        "room": 0x0091,
        "collect": COLLECT_CHEST,
    },
    "Zora King Gift": {
        "region_id": "zora king gift",
        "vanilla_item": "Library Key",
        "flag_byte": 0xcaab,
        "room": 0x05ab,
        "map_tile": 0xa1,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "kingZora",
    },
    "Library Present": {
        "region_id": "library present",
        "vanilla_item": "Book of Seals",
        "flag_byte": 0xcac8,
        "room": 0x05c8,
        "map_tile": 0xa5,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "libraryPresent",
    },
    "Library Past": {
        "region_id": "library past",
        "vanilla_item": "Fairy Powder",
        "flag_byte": 0xcae4,
        "room": 0x05e4,
        "map_tile": 0x1a5,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "libraryPast",
    },
    "Zora Seas Chest": {
        "region_id": "zora seas chest",
        "vanilla_item": "Whimsical Ring",
        "flag_byte": 0xc7d5,
        "room": 0x00d5,
        "collect": COLLECT_CHEST,
    },
    "Fisher's Island Cave": {
        "region_id": "fisher's island cave",
        "vanilla_item": "Red Holy Ring",
        "flag_byte": 0xc74f,
        "room": 0x024f,
        "map_tile": 0x1c5,
        "collect": COLLECT_CHEST,
    },
    "Zora's Reward": {
        "region_id": "zora's reward",
        "vanilla_item": "Zora Scale",
        "flag_byte": 0xc7a0,
        "room": 0x02a0,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "zoraReward",
    },
    ##########################################
    "Piratian Captain": {
        "region_id": "piratian captain",
        "vanilla_item": "Tokay Eyeball",
        "flag_byte": 0xcaf8,
        "room": 0x05f8,
        "map_tile": 0x1d7,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "piratianCaptain",
    },
    "Sea of Storms Past": {
        "region_id": "sea of storms past",
        "vanilla_item": "Pegasus Ring",
        "flag_byte": 0xc8ff,
        "room": 0x03ff,
        "map_tile": 0x1c7,
        "collect": COLLECT_CHEST,
        "symbolic_name": "seaofstorm",
    },
    #"Sea of Storms Present": {
    #    "region_id": "sea of storms present",
    #    "vanilla_item": "Gasha Seed",
    #    "flag_byte": 0xFFFF,
    #},
    "Sea of No Return": {
        "region_id": "sea of no return",
        "vanilla_item": "Blue Ring",
        "flag_byte": 0xc86d,
        "room": 0x016d,
        "collect": COLLECT_CHEST,
    },
    ##########################################
    "Yoll Graveyard: Graveyard Poe Trade": {
        "region_id": "graveyard poe trade",
        "vanilla_item": "Poe Clock",
        "flag_byte": 0xc77c,
        "room": 0x007c,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "graveyardPoe",
    },
    "Lynna Village: Postman Trade": {
        "region_id": "postman trade",
        "vanilla_item": "Stationary",
        "flag_byte": 0xc72f,
        "room": 0x022f, 
        "collect": COLLECT_TOUCH,
        "symbolic_name": "postman",
    },
    "Lynna Village: The Toilet Hand Trade": {
        "region_id": "toilet hand trade",
        "vanilla_item": "Stink Bag",
        "flag_byte": 0xc73e,
        "room": 0x023e,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "toiletHand",
    },
    "Crescent Island (Present): Tokay Chef Trade": {
        "region_id": "tokay chef trade",
        "vanilla_item": "Tasty Meat",
        "flag_byte": 0xc73f,
        "room": 0x023f,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "tokayChef",
    },
    "Nuun Highland: Happy Mask Salesman Trade": {
        "region_id": "happy mask salesman trade",
        "vanilla_item": "Doggie Mask",
        "flag_byte": 0xc7e6,
        "room": 0x02e6,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "maskSaleman",
    },
    "Lynna City: Mamamu Yan Trade": {
        "region_id": "mamamu yan trade",
        "vanilla_item": "Dumbbell",
        "flag_byte": 0xc7e7,
        "room": 0x02e7,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "mamamuYan",
    },
    "Symmetry City: Middle Man Trade": {
        "region_id": "symmetry middle man trade",
        "vanilla_item": "Cheesy Mustache",
        "flag_byte": 0xc7e8,
        "room": 0x02e8,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "middleMan",
    },
    "Lynna City: Comedian Trade": {
        "region_id": "lynna city comedian trade",
        "vanilla_item": "Funny Joke",
        "flag_byte": 0xc756,
        "room": 0x0056,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "comedian",
    },
    "Lynna Village: Sad Boi Trade": {
        "region_id": "sad boi trade",
        "vanilla_item": "Touching Book",
        "flag_byte": 0xc7f3,
        "room": 0x02f3,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "sadBoi",
    },
    "Maple Trade": {
        "region_id": "maple trade",
        "vanilla_item": "Magic Oar",
        "flag_byte": 0xc6d2,
        "room": 0x0300,
        "bit_mask": 0x80,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "mapleTrade",
    },
    "Lynna Village: Rafton Trade": {
        "region_id": "rafton trade",
        "vanilla_item": "Sea Ukulele",
        "flag_byte": 0xc71f,
        "room": 0x021f,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "rafton",
    },
    "Rolling Ridge: Old Zora Trade": {
        "region_id": "old zora trade",
        "vanilla_item": "Broken Sword",
        "flag_byte": 0xc7f5,
        "room": 0x02f5, 
        "collect": COLLECT_TOUCH,
        "symbolic_name": "oldZora",
    },
    ##########################################
    "Black Tower Heart Piece": {
        "region_id": "black tower heartpiece",
        "vanilla_item": "Piece of Heart",
        "flag_byte": 0xc886,
        "room": 0x0186,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "blackTowerHP",
    },
    "Maku Path Heart Piece": {
        "region_id": "maku path heartpiece",
        "vanilla_item": "Piece of Heart",
        "flag_byte": 0xc906,
        "room": 0x0406,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "makuPathHP",
    },
    "Yoll Graveyard Heart Piece": {
        "region_id": "yoll graveyard heartpiece",
        "vanilla_item": "Piece of Heart",
        "flag_byte": 0xc78b,
        "room": 0x008b,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "yollGraveyardHP",
    },
    "Deku Forest Heart Piece": {
        "region_id": "deku forest heartpiece",
        "vanilla_item": "Piece of Heart",
        "flag_byte": 0xcab1,
        "room": 0x05b1,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "dekuForestHP",
    },
    "Restoration Wall Heart Piece": {
        "region_id": "restoration wall heartpiece",
        "vanilla_item": "Piece of Heart",
        "flag_byte": 0xc8af,
        "room": 0x03af,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "restorationWallHP",
    },
    "Symmetry City Heart Piece": {
        "region_id": "symmetry city heartpiece",
        "vanilla_item": "Piece of Heart",
        "flag_byte": 0xc711,
        "room": 0x0011,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "symmetryCityHP",
    },
    "Ridge West Heart Piece": {
        "region_id": "ridge west heartpiece",
        "vanilla_item": "Piece of Heart",
        "flag_byte": 0xcac1,
        "room": 0x05c1,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "ridgeWestHP",
    },
    "Ridge Upper Heart Piece": {
        "region_id": "ridge upper heartpiece",
        "vanilla_item": "Piece of Heart",
        "flag_byte": 0xc70d,
        "room": 0x000d,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "ridgeUpperHP",
    },
    ##########################################
    "Maku Path: Key Chest": {
        "region_id": "d0 key chest",
        "vanilla_item": "Small Key (Maku Path)",
        "dungeon" : 0,
        "flag_byte": 0xc908,
        "room": 0x0408,
        "map_tile": 0x148,
        "collect": COLLECT_CHEST,
    },
    "Maku Path: Basement": {
        "region_id": "d0 basement",
        "vanilla_item": "Rupees (30)",
        "dungeon" : 0,
        "flag_byte": 0xc905,
        "room": 0x0605,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "d0Basement",
    },
    ##########################################
    "Spirit's Grave: One-Button Chest": {
    	"region_id": "d1 one-button chest",
    	"vanilla_item": "Gasha Seed",
    	"dungeon" : 1,
        "flag_byte": 0xc915,
        "room": 0x0415,
        "collect": COLLECT_CHEST,
    },
    "Spirit's Grave: Two-Buttons Chest": {
    	"region_id": "d1 two-button chest",
    	"vanilla_item": "Small Key (Spirit's Grave)",
    	"dungeon" : 1,
        "flag_byte": 0xc916,
        "room": 0x0416,
        "collect": COLLECT_CHEST,
    },
    "Spirit's Grave: Wide Room": {
    	"region_id": "d1 wide room",
    	"vanilla_item": "Small Key (Spirit's Grave)",
    	"dungeon" : 1,
        "flag_byte": 0xc91a,
        "room": 0x041a,
        "collect": COLLECT_CHEST,
    },
    "Spirit's Grave: Crystal Room": {
    	"region_id": "d1 crystal room",
    	"vanilla_item": "Power Ring L-1",
    	"dungeon" : 1,
        "flag_byte": 0xc91c,
        "room": 0x041c,
        "collect": COLLECT_CHEST,
    },
    "Spirit's Grave: Crossroad": {
    	"region_id": "d1 crossroad",
    	"vanilla_item": "Compass (Spirit's Grave)",
    	"dungeon" : 1,
        "flag_byte": 0xc91d,
        "room": 0x041d,
        "collect": COLLECT_CHEST,
    },
    "Spirit's Grave: West Terrace": {
    	"region_id": "d1 west terrace",
    	"vanilla_item": "Dungeon Map (Spirit's Grave)",
    	"dungeon" : 1,
        "flag_byte": 0xc91f,
        "room": 0x041f,
        "collect": COLLECT_CHEST,
    },
    "Spirit's Grave: Pot Chest": {
    	"region_id": "d1 pot chest",
    	"vanilla_item": "Boss Key (Spirit's Grave)",
    	"dungeon" : 1,
        "flag_byte": 0xc923,
        "room": 0x0423,
        "collect": COLLECT_CHEST,
    },
    "Spirit's Grave: East Terrace": {
    	"region_id": "d1 east terrace",
    	"vanilla_item": "Discovery Ring",
    	"dungeon" : 1,
        "flag_byte": 0xc925,
        "room": 0x0425,
        "collect": COLLECT_CHEST,
    },
    "Spirit's Grave: Ghini Drop": {
    	"region_id": "d1 ghini drop",
    	"vanilla_item": "Small Key (Spirit's Grave)",
    	"dungeon" : 1,
        "flag_byte": 0xc91e,
        "room": 0x041e,
        "collect": COLLECT_DROP,
        "symbolic_name": "d1GhiniDrop",
    },
    "Spirit's Grave: Basement": {
    	"region_id": "d1 basement",
    	"vanilla_item": "Progressive Bracelet",
    	"dungeon" : 1,
        "flag_byte": 0xc910,
        "room": 0x0610,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "d1Basement",
    },
    "Spirit's Grave: Boss": {
    	"region_id": "d1 boss",
    	"vanilla_item": "Heart Container",
    	"dungeon" : 1,
        "flag_byte": 0xc913,
        "room": 0x0413,
        "collect": COLLECT_POOF,
        "symbolic_name": "d1Boss",
    },
    ##########################################
    "Wing Dungeon (1F): Color Room": {
    	"region_id": "d2 color room",
    	"vanilla_item": "Boss Key (Wing Dungeon)",
    	"dungeon" : 2,
        "flag_byte": 0xc93e,
        "room": 0x043e,
        "collect": COLLECT_CHEST,
    },
    "Wing Dungeon (1F): Bombed Terrace": {
    	"region_id": "d2 bombed terrace",
    	"vanilla_item": "Dungeon Map (Wing Dungeon)",
    	"dungeon" : 2,
        "flag_byte": 0xc940,
        "room": 0x0440,
        "collect": COLLECT_CHEST,
    },
    "Wing Dungeon (1F): Moblin Platform": {
    	"region_id": "d2 moblin platform",
    	"vanilla_item": "Gasha Seed",
    	"dungeon" : 2,
        "flag_byte": 0xc941,
        "room": 0x0441,
        "collect": COLLECT_CHEST,
    },
    "Wing Dungeon (1F): Rope Room": {
    	"region_id": "d2 rope room",
    	"vanilla_item": "Compass (Wing Dungeon)",
    	"dungeon" : 2,
        "flag_byte": 0xc945,
        "room": 0x0445,
        "collect": COLLECT_CHEST,
    },
    "Wing Dungeon (1F): Ladder Chest": {
    	"region_id": "d2 ladder chest",
    	"vanilla_item": "Small Key (Wing Dungeon)",
    	"dungeon" : 2,
        "flag_byte": 0xc948,
        "room": 0x0448,
        "collect": COLLECT_CHEST,
    },
    "Wing Dungeon (1F): Moblin Drop": {
    	"region_id": "d2 moblin drop",
    	"vanilla_item": "Small Key (Wing Dungeon)",
    	"dungeon" : 2,
        "flag_byte": 0xc939,
        "room": 0x0439,
        "collect": COLLECT_DROP,
        "symbolic_name": "d2MoblinDrop",
    },
    "Wing Dungeon (1F): Statue Puzzle": {
    	"region_id": "d2 statue puzzle",
    	"vanilla_item": "Small Key (Wing Dungeon)",
    	"dungeon" : 2,
        "flag_byte": 0xc942,
        "room": 0x0442,
        "collect": COLLECT_DROP,
        "symbolic_name": "d2StatuePuzzle",
    },
    "Wing Dungeon (B1F): Thwomp Shelf": {
    	"region_id": "d2 thwomp shelf",
    	"vanilla_item": "Rupees (30)",
    	"dungeon" : 2,
        "flag_byte": 0xc927,
        "room": 0x0627,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "d2ThwompShelf",
    },
    "Wing Dungeon (B1F): Thwomp Tunnel": {
    	"region_id": "d2 thwomp tunnel",
    	"vanilla_item": "Feather",
    	"dungeon" : 2,
        "flag_byte": 0xc928,
        "room": 0x0628,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "d2ThwompTunnel",
    },
    "Wing Dungeon (B1F): Basement Chest": {
    	"region_id": "d2 basement chest",
    	"vanilla_item": "Small Key (Wing Dungeon)",
    	"dungeon" : 2,
        "flag_byte": 0xc930,
        "room": 0x0430,
        "collect": COLLECT_CHEST,
    },
    "Wing Dungeon (B1F): Basement Drop": {
    	"region_id": "d2 basement drop",
    	"vanilla_item": "Small Key (Wing Dungeon)",
    	"dungeon" : 2,
        "flag_byte": 0xc92e,
        "room": 0x042e,
        "collect": COLLECT_DROP,
        "symbolic_name": "d2BasementDrop",
    },
    "Wing Dungeon (1F): Boss": {
    	"region_id": "d2 boss",
    	"vanilla_item": "Heart Container",
    	"dungeon" : 2,
        "flag_byte": 0xc92b,
        "room": 0x062b,
        "collect": COLLECT_POOF,
        "symbolic_name": "d2Boss",
    },
    ##########################################
    "Moonlit Grotto (1F): Bridge Chest": {
    	"region_id": "d3 bridge chest",
    	"vanilla_item": "Rupees (20)",
    	"dungeon" : 3,
        "flag_byte": 0xc94e,
        "room": 0x044e,
        "collect": COLLECT_CHEST,
    },
    "Moonlit Grotto (1F): Mimic Room": {
    	"region_id": "d3 mimic room",
    	"vanilla_item": "Seed Shooter",
    	"dungeon" : 3,
        "flag_byte": 0xc958,
        "room": 0x0458,
        "collect": COLLECT_CHEST,
    },
    "Moonlit Grotto (1F): Bush Beetle Room": {
    	"region_id": "d3 bush beetle room",
    	"vanilla_item": "Rupees (30)",
    	"dungeon" : 3,
        "flag_byte": 0xc95c,
        "room": 0x045c,
        "collect": COLLECT_CHEST,
    },
    "Moonlit Grotto (1F): Crossroad": {
    	"region_id": "d3 crossroad",
    	"vanilla_item": "Gasha Seed",
    	"dungeon" : 3,
        "flag_byte": 0xc960,
        "room": 0x0460,
        "collect": COLLECT_CHEST,
    },
    "Moonlit Grotto (1F): Pols Voice Chest": {
    	"region_id": "d3 pols voice chest",
    	"vanilla_item": "Dungeon Map (Moonlit Grotto)",
    	"dungeon" : 3,
        "flag_byte": 0xc965,
        "room": 0x0465,
        "collect": COLLECT_CHEST,
    },
    "Moonlit Grotto (1F): Armos Drop": {
    	"region_id": "d3 armos drop",
    	"vanilla_item": "Small Key (Moonlit Grotto)",
    	"dungeon" : 3,
        "flag_byte": 0xc95e,
        "room": 0x045e,
        "collect": COLLECT_DROP,
        "symbolic_name": "d3ArmosDrop",
    },
    "Moonlit Grotto (1F): Statue Drop": {
    	"region_id": "d3 statue drop",
    	"vanilla_item": "Small Key (Moonlit Grotto)",
    	"dungeon" : 3,
        "flag_byte": 0xc961,
        "room": 0x0461,
        "collect": COLLECT_DROP,
        "symbolic_name": "d3StatueDrop",
    },
    "Moonlit Grotto (1F): Six Blocs Drop": {
    	"region_id": "d3 six-blocs drop",
    	"vanilla_item": "Small Key (Moonlit Grotto)",
    	"dungeon" : 3,
        "flag_byte": 0xc964,
        "room": 0x0464,
        "collect": COLLECT_DROP,
        "symbolic_name": "d3SixBlocDrop",
    },
    "Moonlit Grotto (B1F): Moldorm Drop": {
    	"region_id": "d3 moldorm drop",
    	"vanilla_item": "Small Key (Moonlit Grotto)",
    	"dungeon" : 3,
        "flag_byte": 0xc94b,
        "room": 0x044b,
        "collect": COLLECT_DROP,
        "symbolic_name": "d3MoldormDrop",
    },
    "Moonlit Grotto (B1F): East": {
    	"region_id": "d3 B1F east",
    	"vanilla_item": "Boss Key (Moonlit Grotto)",
    	"dungeon" : 3,
        "flag_byte": 0xc950,
        "room": 0x0450,
        "collect": COLLECT_CHEST,
    },
    "Moonlit Grotto (B1F): Torch Chest": {
    	"region_id": "d3 torch chest",
    	"vanilla_item": "Gasha Seed",
    	"dungeon" : 3,
        "flag_byte": 0xc955,
        "room": 0x0455,
        "collect": COLLECT_CHEST,
    },
    "Moonlit Grotto (B1F): Conveyor Belt Room": {
    	"region_id": "d3 conveyor belt room",
    	"vanilla_item": "Compass (Moonlit Grotto)",
    	"dungeon" : 3,
        "flag_byte": 0xc956,
        "room": 0x0456,
        "collect": COLLECT_CHEST,
    },
    "Moonlit Grotto (B1F): Boss": {
    	"region_id": "d3 boss",
    	"vanilla_item": "Heart Container",
    	"dungeon" : 3,
        "flag_byte": 0xc94a,
        "room": 0x044a,
        "collect": COLLECT_POOF,
        "symbolic_name": "d3Boss",
    },
    ##########################################
    'Skull Dungeon (1F): Second Crystal Switch': {
    	"region_id": "d4 second crystal switch",
    	"vanilla_item": "Small Key (Skull Dungeon)",
    	"dungeon" : 4,
        "flag_byte": 0xc974,
        "room": 0x0474,
        "collect": COLLECT_CHEST,
    },
    'Skull Dungeon (1F): Lava Pot Chest': {
    	"region_id": "d4 lava pot chest",
    	"vanilla_item": "Boss Key (Skull Dungeon)",
    	"dungeon" : 4,
        "flag_byte": 0xc97a,
        "room": 0x047a,
        "collect": COLLECT_CHEST,
    },
    'Skull Dungeon (1F): Small Floor Puzzle': {
    	"region_id": "d4 small floor puzzle",
    	"vanilla_item": "Progressive Hook",
    	"dungeon" : 4,
        "flag_byte": 0xc987,
        "room": 0x0487,
        "collect": COLLECT_CHEST,
    },
    'Skull Dungeon (1F): First Chest': {
    	"region_id": "d4 first chest",
    	"vanilla_item": "Compass (Skull Dungeon)",
    	"dungeon" : 4,
        "flag_byte": 0xc98b,
        "room": 0x048b,
        "collect": COLLECT_CHEST,
    },
    'Skull Dungeon (1F): Minecart Chest': {
    	"region_id": "d4 minecart chest",
    	"vanilla_item": "Dungeon Map (Skull Dungeon)",
    	"dungeon" : 4,
        "flag_byte": 0xc98f,
        "room": 0x048f,
        "collect": COLLECT_CHEST,
    },
    'Skull Dungeon (1F): Cube Chest': {
    	"region_id": "d4 cube chest",
    	"vanilla_item": "Small Key (Skull Dungeon)",
    	"dungeon" : 4,
        "flag_byte": 0xc990,
        "room": 0x0490,
        "collect": COLLECT_CHEST,
    },
    'Skull Dungeon (1F): First Crystal Switch': {
    	"region_id": "d4 first crystal switch",
    	"vanilla_item": "Small Key (Skull Dungeon)",
    	"dungeon" : 4,
        "flag_byte": 0xc992,
        "room": 0x0492,
        "collect": COLLECT_CHEST,
    },
    'Skull Dungeon (1F): Color Tile Drop': {
    	"region_id": "d4 color tile drop",
    	"vanilla_item": "Small Key (Skull Dungeon)",
    	"dungeon" : 4,
        "flag_byte": 0xc97b,
        "room": 0x047b,
        "collect": COLLECT_DROP,
        "symbolic_name": "d4ColorDrop",
    },
    'Skull Dungeon (B1F): Large Floor Puzzle': {
    	"region_id": "d4 large floor puzzle",
    	"vanilla_item": "Small Key (Skull Dungeon)",
    	"dungeon" : 4,
        "flag_byte": 0xc96f,
        "room": 0x046f,
        "collect": COLLECT_CHEST,
    },
    'Skull Dungeon (B1F): Boss': {
    	"region_id": "d4 boss",
    	"vanilla_item": "Heart Container",
    	"dungeon" : 4,
        "flag_byte": 0xc96b,
        "room": 0x046b,
        "collect": COLLECT_POOF,
        "symbolic_name": "d4Boss",
    },
    ##########################################
    "Crown Dungeon (1F): Diamond Chest": {
    	"region_id": "d5 diamond chest",
    	"vanilla_item": "Compass (Crown Dungeon)",
    	"dungeon" : 5,
        "flag_byte": 0xc9ad,
        "room": 0x04ad,
        "collect": COLLECT_CHEST,
    },
    "Crown Dungeon (1F): Eyes Chest": {
    	"region_id": "d5 eyes chest",
    	"vanilla_item": "Small Key (Crown Dungeon)",
    	"dungeon" : 5,
        "flag_byte": 0xc9ba,
        "room": 0x04ba,
        "collect": COLLECT_CHEST,
    },
    "Crown Dungeon (1F): Three-Statue Puzzle": {
    	"region_id": "d5 three-statue puzzle",
    	"vanilla_item": "Small Key (Crown Dungeon)",
    	"dungeon" : 5,
        "flag_byte": 0xc9bc,
        "room": 0x04bc,
        "collect": COLLECT_CHEST,
    },
    "Crown Dungeon (1F): Blue Peg Chest": {
    	"region_id": "d5 blue peg chest",
    	"vanilla_item": "Dungeon Map (Crown Dungeon)",
    	"dungeon" : 5,
        "flag_byte": 0xc9be,
        "room": 0x04be,
        "collect": COLLECT_CHEST,
    },
    "Crown Dungeon (B1F): Like-Like Chest": {
    	"region_id": "d5 like-like chest",
    	"vanilla_item": "Small Key (Crown Dungeon)",
    	"dungeon" : 5,
        "flag_byte": 0xc99f,
        "room": 0x049f,
        "collect": COLLECT_CHEST,
    },
    "Crown Dungeon (B1F): Red Peg Chest": {
    	"region_id": "d5 red peg chest",
    	"vanilla_item": "Rupees (50)",
    	"dungeon" : 5,
        "flag_byte": 0xc999,
        "room": 0x0499,
        "collect": COLLECT_CHEST,
    },
    "Crown Dungeon (B1F): Owl Puzzle": {
    	"region_id": "d5 owl puzzle",
    	"vanilla_item": "Boss Key (Crown Dungeon)",
    	"dungeon" : 5,
        "flag_byte": 0xc99b,
        "room": 0x049b,
        "collect": COLLECT_CHEST,
    },
    "Crown Dungeon (B1F): Two-Statue Puzzle": {
    	"region_id": "d5 two-statue puzzle",
    	"vanilla_item": "Small Key (Crown Dungeon)",
    	"dungeon" : 5,
        "flag_byte": 0xc99e,
        "room": 0x049e,
        "collect": COLLECT_CHEST,
    },
    "Crown Dungeon (B1F): Dark Room": {
    	"region_id": "d5 dark room",
    	"vanilla_item": "Small Key (Crown Dungeon)",
    	"dungeon" : 5,
        "flag_byte": 0xc9a3,
        "room": 0x04a3,
        "collect": COLLECT_CHEST,
    },
    "Crown Dungeon (B1F): Six-Statue Puzzle": {
    	"region_id": "d5 six-statue puzzle",
    	"vanilla_item": "Cane of Somaria",
    	"dungeon" : 5,
        "flag_byte": 0xc9a5,
        "room": 0x04a5,
        "collect": COLLECT_CHEST,
    },
    "Crown Dungeon (1F): Boss": {
    	"region_id": "d5 boss",
    	"vanilla_item": "Heart Container",
    	"dungeon" : 5,
        "flag_byte": 0xc9bf,
        "room": 0x04bf,
        "collect": COLLECT_POOF,
        "symbolic_name": "d5Boss",
    },
    ##########################################
    "Mermaid's Cave (Present): Vire Chest": {
    	"region_id": "d6 present vire chest",
    	"vanilla_item": "Progressive Flippers",
    	"dungeon" : 6,
        "flag_byte": 0xca13,
        "room": 0x0513,
        "collect": COLLECT_CHEST,
    },
    "Mermaid's Cave (Present): Spinner Chest": {
    	"region_id": "d6 present spinner chest",
    	"vanilla_item": "Small Key (Mermaid's Cave Present)",
    	"dungeon" : 6,
        "flag_byte": 0xca14,
        "room": 0x0514,
        "collect": COLLECT_CHEST,
    },
    "Mermaid's Cave (Present): Rope Chest": {
    	"region_id": "d6 present rope chest",
    	"vanilla_item": "Small Key (Mermaid's Cave Present)",
    	"dungeon" : 6,
        "flag_byte": 0xca1b,
        "room": 0x051b,
        "collect": COLLECT_CHEST,
    },
    "Mermaid's Cave (Present): RNG Chest": {
    	"region_id": "d6 present rng chest",
    	"vanilla_item": "Boss Key (Mermaid's Cave)",
    	"dungeon" : 6,
        "flag_byte": 0xca1c,
        "room": 0x051c,
        "collect": COLLECT_CHEST,
    },
    "Mermaid's Cave (Present): Diamond Chest": {
    	"region_id": "d6 present diamond chest",
    	"vanilla_item": "Dungeon Map (Mermaid's Cave Present)",
    	"dungeon" : 6,
        "flag_byte": 0xca1d,
        "room": 0x051d,
        "collect": COLLECT_CHEST,
    },
    "Mermaid's Cave (Present): Beamos Chest": {
    	"region_id": "d6 present beamos chest",
    	"vanilla_item": "Rupees (10)",
    	"dungeon" : 6,
        "flag_byte": 0xca1f,
        "room": 0x051f,
        "collect": COLLECT_CHEST,
    },
    "Mermaid's Cave (Present): Cube Chest": {
    	"region_id": "d6 present cube chest",
    	"vanilla_item": "Small Key (Mermaid's Cave Present)",
    	"dungeon" : 6,
        "flag_byte": 0xca21,
        "room": 0x0521,
        "collect": COLLECT_CHEST,
    },
    "Mermaid's Cave (Present): Channel Chest": {
    	"region_id": "d6 present channel chest",
    	"vanilla_item": "Compass (Mermaid's Cave Present)",
    	"dungeon" : 6,
        "flag_byte": 0xca25,
        "room": 0x0525,
        "collect": COLLECT_CHEST,
    },
    # ======
    "Mermaid's Cave (Past) (1F): Stalfos Chest": {
    	"region_id": "d6 past stalfos chest",
    	"vanilla_item": "Small Key (Mermaid's Cave Past)",
    	"dungeon" : 9,
        "flag_byte": 0xca3c,
        "room": 0x053c,
        "collect": COLLECT_CHEST,
    },
    "Mermaid's Cave (Past) (1F): Color Room": {
    	"region_id": "d6 past color room",
    	"vanilla_item": "Compass (Mermaid's Cave Past)",
    	"dungeon" : 9,
        "flag_byte": 0xca3f,
        "room": 0x053f,
        "collect": COLLECT_CHEST,
    },
    "Mermaid's Cave (Past) (1F): Pool Chest": {
    	"region_id": "d6 past pool chest",
    	"vanilla_item": "Dungeon Map (Mermaid's Cave Past)",
    	"dungeon" : 9,
        "flag_byte": 0xca41,
        "room": 0x0541,
        "collect": COLLECT_CHEST,
    },
    "Mermaid's Cave (Past) (1F): Wizzrobe": {
    	"region_id": "d6 past wizzrobe",
    	"vanilla_item": "Gasha Seed",
    	"dungeon" : 9,
        "flag_byte": 0xca45,
        "room": 0x0545,
        "collect": COLLECT_CHEST,
    },
    "Mermaid's Cave (Past) (B1F): Diamond Chest": {
    	"region_id": "d6 past diamond chest",
    	"vanilla_item": "Small Key (Mermaid's Cave Past)",
    	"dungeon" : 9,
        "flag_byte": 0xca2c,
        "room": 0x052c,
        "collect": COLLECT_CHEST,
    },
    "Mermaid's Cave (Past) (B1F): Spear Chest": {
    	"region_id": "d6 past spear chest",
    	"vanilla_item": "Rupees (30)",
    	"dungeon" : 9,
        "flag_byte": 0xca2e,
        "room": 0x052e,
        "collect": COLLECT_CHEST,
    },
    "Mermaid's Cave (Past) (B1F): Rope Chest": {
    	"region_id": "d6 past rope chest",
    	"vanilla_item": "Small Key (Mermaid's Cave Past)",
    	"dungeon" : 9,
        "flag_byte": 0xca31,
        "room": 0x0531,
        "collect": COLLECT_CHEST,
    },
    "Mermaid's Cave (Past) (1F): Boss": {
    	"region_id": "d6 boss",
    	"vanilla_item": "Heart Container",
    	"dungeon" : 9,
        "flag_byte": 0xca36,
        "room": 0x0536,
        "collect": COLLECT_POOF,
        "symbolic_name": "d6Boss",
    },
    ##########################################
    "Jabu-Jabu's Belly (1F): Island Chest": {
    	"region_id": "d7 island chest",
    	"vanilla_item": "Like-Like Ring",
    	"dungeon" : 7,
        "flag_byte": 0xca4c,
        "room": 0x054c,
        "collect": COLLECT_CHEST,
    },
    "Jabu-Jabu's Belly (1F): Stairway Chest": {
    	"region_id": "d7 stairway chest",
    	"vanilla_item": "Gasha Seed",
    	"dungeon" : 7,
        "flag_byte": 0xca4d,
        "room": 0x054d,
        "collect": COLLECT_CHEST,
    },
    "Jabu-Jabu's Belly (1F): Miniboss Chest": {
    	"region_id": "d7 miniboss chest",
    	"vanilla_item": "Progressive Hook",
    	"dungeon" : 7,
        "flag_byte": 0xca4e,
        "room": 0x054e,
        "collect": COLLECT_CHEST,
    },
    "Jabu-Jabu's Belly (1F): Cane/Diamond Puzzle": {
    	"region_id": "d7 cane/diamond puzzle",
    	"vanilla_item": "Small Key (Jabu-Jabu's Belly)",
    	"dungeon" : 7,
        "flag_byte": 0xca53,
        "room": 0x0553,
        "collect": COLLECT_CHEST,
        "symbolic_name": "d7CaneDiamondPuzzle",
    },
    "Jabu-Jabu's Belly (1F): Boxed Chest": {
    	"region_id": "d7 boxed chest",
    	"vanilla_item": "Small Key (Jabu-Jabu's Belly)",
    	"dungeon" : 7,
        "flag_byte": 0xca50,
        "room": 0x0550,
        "collect": COLLECT_CHEST,
    },
    "Jabu-Jabu's Belly (1F): Flower Room": {
    	"region_id": "d7 flower room",
    	"vanilla_item": "Small Key (Jabu-Jabu's Belly)",
    	"dungeon" : 7,
        "flag_byte": 0xca4b,
        "room": 0x054b,
        "collect": COLLECT_DROP,
        "symbolic_name": "d7FlowerRoom",
    },
    "Jabu-Jabu's Belly (1F): Diamond Puzzle": {
    	"region_id": "d7 diamond puzzle",
    	"vanilla_item": "Small Key (Jabu-Jabu's Belly)",
    	"dungeon" : 7,
        "flag_byte": 0xca55,
        "room": 0x0555,
        "collect": COLLECT_DROP,
        "symbolic_name": "d7DiamondPuzzle",
    },
    "Jabu-Jabu's Belly (1F): Crab Chest": {
    	"region_id": "d7 crab chest",
    	"vanilla_item": "Compass (Jabu-Jabu's Belly)",
    	"dungeon" : 7,
        "flag_byte": 0xca54,
        "room": 0x0554,
        "collect": COLLECT_CHEST,
    },
    "Jabu-Jabu's Belly (2F): Left Wing": {
    	"region_id": "d7 left wing",
    	"vanilla_item": "Small Key (Jabu-Jabu's Belly)",
    	"dungeon" : 7,
        "flag_byte": 0xca5f,
        "room": 0x055f,
        "collect": COLLECT_CHEST,
    },
    "Jabu-Jabu's Belly (2F): Right Wing": {
    	"region_id": "d7 right wing",
    	"vanilla_item": "Small Key (Jabu-Jabu's Belly)",
    	"dungeon" : 7,
        "flag_byte": 0xca64,
        "room": 0x0564,
        "collect": COLLECT_CHEST,
    },
    "Jabu-Jabu's Belly (2F): Spike Chest": {
    	"region_id": "d7 spike chest",
    	"vanilla_item": "Dungeon Map (Jabu-Jabu's Belly)",
    	"dungeon" : 7,
        "flag_byte": 0xca65,
        "room": 0x0565,
        "collect": COLLECT_CHEST,
    },
    "Jabu-Jabu's Belly (3F): Hallway Chest": {
    	"region_id": "d7 hallway chest",
    	"vanilla_item": "Gasha Seed",
    	"dungeon" : 7,
        "flag_byte": 0xca6a,
        "room": 0x056a,
        "collect": COLLECT_CHEST,
    },
    "Jabu-Jabu's Belly (3F): Post-Hallway Chest": {
    	"region_id": "d7 post-hallway chest",
    	"vanilla_item": "Boss Key (Jabu-Jabu's Belly)",
    	"dungeon" : 7,
        "flag_byte": 0xca6c,
        "room": 0x056c,
        "collect": COLLECT_CHEST,
    },
    "Jabu-Jabu's Belly (3F): Terrace": {
    	"region_id": "d7 terrace",
    	"vanilla_item": "Small Key (Jabu-Jabu's Belly)",
    	"dungeon" : 7,
        "flag_byte": 0xca72,
        "room": 0x0572,
        "collect": COLLECT_CHEST,
    },
    "Jabu-Jabu's Belly (2F): Boss": {
    	"region_id": "d7 boss",
    	"vanilla_item": "Heart Container",
    	"dungeon" : 7,
        "flag_byte": 0xca62,
        "room": 0x0562,
        "collect": COLLECT_POOF,
        "symbolic_name": "d7Boss",
    },
    ##########################################
    'Ancient Tomb (1F): Single Chest': {
    	"region_id": "d8 1f single chest",
    	"vanilla_item": "Small Key (Ancient Tomb)",
    	"dungeon" : 8,
        "flag_byte": 0xcaa7,
        "room": 0x05a7,
        "collect": COLLECT_CHEST,
    },
    'Ancient Tomb (B2F): Maze Chest': {
    	"region_id": "d8 maze chest",
    	"vanilla_item": "Small Key (Ancient Tomb)",
    	"dungeon" : 8,
        "flag_byte": 0xca7b,
        "room": 0x057b,
        "collect": COLLECT_CHEST,
    },
    'Ancient Tomb (B2F): NW Slate Chest': {
    	"region_id": "d8 nw slate chest",
    	"vanilla_item": "Slate",
    	"dungeon" : 8,
        "flag_byte": 0xca7c,
        "room": 0x057c,
        "collect": COLLECT_CHEST,
    },
    'Ancient Tomb (B2F): NE Slate Chest': {
    	"region_id": "d8 ne slate chest",
    	"vanilla_item": "Slate",
    	"dungeon" : 8,
        "flag_byte": 0xca7e,
        "room": 0x057e,
        "collect": COLLECT_CHEST,
    },
    'Ancient Tomb (B2F): Ghini Chest': {
    	"region_id": "d8 ghini chest",
    	"vanilla_item": "Dungeon Map (Ancient Tomb)",
    	"dungeon" : 8,
        "flag_byte": 0xca85,
        "room": 0x0585,
        "collect": COLLECT_CHEST,
    },
    'Ancient Tomb (B2F): SE Slate Chest': {
    	"region_id": "d8 se slate chest",
    	"vanilla_item": "Slate",
    	"dungeon" : 8,
        "flag_byte": 0xca92,
        "room": 0x0592,
        "collect": COLLECT_CHEST,
    },
    'Ancient Tomb (B2F): SW Slate Chest': {
    	"region_id": "d8 sw slate chest",
    	"vanilla_item": "Slate",
    	"dungeon" : 8,
        "flag_byte": 0xca94,
        "room": 0x0594,
        "collect": COLLECT_CHEST,
    },
    'Ancient Tomb (B1F): NW Chest': {
    	"region_id": "d8 nw chest",
    	"vanilla_item": "Small Key (Ancient Tomb)",
    	"dungeon" : 8,
        "flag_byte": 0xca97,
        "room": 0x0597,
        "collect": COLLECT_CHEST,
    },
    'Ancient Tomb (B1F): Sarcophagus Chest': {
    	"region_id": "d8 sarcophagus chest",
    	"vanilla_item": "Gasha Seed",
    	"dungeon" : 8,
        "flag_byte": 0xca9f,
        "room": 0x059f,
        "collect": COLLECT_CHEST,
    },
    'Ancient Tomb (B1F): Blade Trap': {
    	"region_id": "d8 blade trap",
    	"vanilla_item": "Small Key (Ancient Tomb)",
    	"dungeon" : 8,
        "flag_byte": 0xcaa3,
        "room": 0x05a3,
        "collect": COLLECT_CHEST,
    },
    'Ancient Tomb (B1F): Blue Peg Chest': {
    	"region_id": "d8 blue peg chest",
    	"vanilla_item": "Compass (Ancient Tomb)",
    	"dungeon" : 8,
        "flag_byte": 0xcaa4,
        "room": 0x05a4,
        "collect": COLLECT_CHEST,
    },
    'Ancient Tomb (B1F): Floor Puzzle': {
    	"region_id": "d8 floor puzzle",
    	"vanilla_item": "Progressive Bracelet",
    	"dungeon" : 8,
        "flag_byte": 0xcaa6,
        "room": 0x05a6,
        "collect": COLLECT_CHEST,
    },
    'Ancient Tomb (B2F): Tile Room': {
    	"region_id": "d8 tile room",
    	"vanilla_item": "Gasha Seed",
    	"dungeon" : 8,
        "flag_byte": 0xca91,
        "room": 0x0591,
        "collect": COLLECT_CHEST,
    },
    'Ancient Tomb (B1F): Stalfos': {
    	"region_id": "d8 stalfos",
    	"vanilla_item": "Small Key (Ancient Tomb)",
    	"dungeon" : 8,
        "flag_byte": 0xca98,
        "room": 0x0598,
        "collect": COLLECT_POOF,
        "symbolic_name": "d8Stalfos",
    },
    'Ancient Tomb (B3F): Single Chest': {
    	"region_id": "d8 b3f single chest",
    	"vanilla_item": "Boss Key (Ancient Tomb)",
    	"dungeon" : 8,
        "flag_byte": 0xca79,
        "room": 0x0579,
        "collect": COLLECT_CHEST,
    },
    'Ancient Tomb (B3F): Boss': {
    	"region_id": "d8 boss",
    	"vanilla_item": "Heart Container",
    	"dungeon" : 8,
        "flag_byte": 0xca78,
        "room": 0x0578,
        "collect": COLLECT_POOF,
        "symbolic_name": "d8Boss",
    },
    ##########################################
    "Spirit's Grave: Essence": {
        "region_id": "d1 boss",
        "flag_byte": 0xc911,
        "vanilla_item": "Eternal Spirit",
        "randomized": False,
        "collect": COLLECT_TOUCH,
    },
    "Wing Dungeon: Essence": {
        "region_id": "d2 boss",
        "flag_byte": 0xc938,
        "vanilla_item": "Ancient Wood",
        "randomized": False,
        "collect": COLLECT_TOUCH,
    },
    "Moonlit Grotto: Essence": {
        "region_id": "d3 boss",
        "flag_byte": 0xc949,
        "vanilla_item": "Echoing Howl",
        "randomized": False,
        "collect": COLLECT_TOUCH,
    },
    "Skull Dungeon: Essence": {
        "region_id": "d4 boss",
        "flag_byte": 0xc969,
        "vanilla_item": "Burning Flame",
        "randomized": False,
        "collect": COLLECT_TOUCH,
    },
    "Crown Dungeon: Essence": {
        "region_id": "d5 boss",
        "flag_byte": 0xc9b8,
        "vanilla_item": "Sacred Soil",
        "randomized": False,
        "collect": COLLECT_TOUCH,
    },
    "Mermaid's Cave: Essence": {
        "region_id": "d6 boss",
        "flag_byte": 0xca37,
        "vanilla_item": "Lonely Peak",
        "randomized": False,
        "collect": COLLECT_TOUCH,
    },
    "Jabu-Jabu's Belly: Essence": {
        "region_id": "d7 boss",
        "flag_byte": 0xca61,
        "vanilla_item": "Rolling Sea",
        "randomized": False,
        "collect": COLLECT_TOUCH,
    },
    "Ancient Tomb: Essence": {
        "region_id": "d8 boss",
        "flag_byte": 0xca77,
        "vanilla_item": "Falling Star",
        "randomized": False,
        "collect": COLLECT_TOUCH,
    },

    ##########################################
    
    "Lynna City: Seed Tree": {
        "region_id": "south lynna tree",
        "local": True,
        "flag_byte": [0xc778, 0xc878],
        "room": [0x0078, 0x0178],
        "collect": COLLECT_TOUCH,
        "symbolic_name": "lynnaTree",
    },
    "Ambi's Palace: Seed Tree": {
        "region_id": "ambi's palace tree",
        "local": True,
        "flag_byte": 0xc825,
        "room": 0x0125,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "palaceTree",
    },
    "Deku Forest: Seed Tree": {
        "region_id": "deku forest tree",
        "local": True,
        "flag_byte": 0xc880,
        "room": 0x0180,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "forestTree",
    },
    "Crescent Island: Seed Tree": {
        "region_id": "crescent island tree",
        "local": True,
        "flag_byte": 0xc7ac,
        "room": 0x00ac,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "crescentTree",
    },
    "Symmetry city: Seed Tree": {
        "region_id": "symmetry city tree",
        "local": True,
        "flag_byte": 0xc713,
        "room": 0x0013,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "symmetryTree",
    },
    "Rolling Ridge West: Seed Tree": {
        "region_id": "ridge west tree",
        "local": True,
        "flag_byte": 0xc808,
        "room": 0x0108,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "ridgeWestTree",
    },
    "Rolling Ridge East: Seed Tree": {
        "region_id": "ridge east tree",
        "local": True,
        "flag_byte": 0xc82d,
        "room": 0x012d,
        "collect": COLLECT_TOUCH,
        "symbolic_name": "ridgeEastTree",
    },
    "Zora Village: Seed Tree": {
        "region_id": "zora village tree",
        "local": True,
        "flag_byte": [0xc7c1, 0xc8c1],
        "room": [0x00c1, 0x01c1],
        "collect": COLLECT_TOUCH,
        "symbolic_name": "zoraTree",
    },
    ##########################################
}