# This file is auto generated. More info: https://github.com/Daivuk/apdoom

from typing import Dict, TypedDict, List, Set 


class LocationDict(TypedDict, total=False): 
    name: str 
    episode: int 
    map: int 
    index: int # Thing index as it is stored in the wad file. 
    doom_type: int # In case index end up unreliable, we can use doom type. Maps have often only one of each important things. 
    region: str 


location_table: Dict[int, LocationDict] = {
    351000: {'name': 'Hangar (E1M1) - Mega Armor',
             'episode': 1,
             'map': 1,
             'index': 13,
             'doom_type': 2019,
             'region': "Hangar (E1M1) Main"},
    351001: {'name': 'Hangar (E1M1) - Armor',
             'episode': 1,
             'map': 1,
             'index': 68,
             'doom_type': 2018,
             'region': "Hangar (E1M1) Main"},
    351002: {'name': 'Hangar (E1M1) - Shotgun',
             'episode': 1,
             'map': 1,
             'index': 98,
             'doom_type': 2001,
             'region': "Hangar (E1M1) Main"},
    351003: {'name': 'Nuclear Plant (E1M2) - Chainsaw',
             'episode': 1,
             'map': 2,
             'index': 4,
             'doom_type': 2005,
             'region': "Nuclear Plant (E1M2) Red"},
    351004: {'name': 'Nuclear Plant (E1M2) - Shotgun',
             'episode': 1,
             'map': 2,
             'index': 5,
             'doom_type': 2001,
             'region': "Nuclear Plant (E1M2) Main"},
    351005: {'name': 'Nuclear Plant (E1M2) - Armor',
             'episode': 1,
             'map': 2,
             'index': 20,
             'doom_type': 2018,
             'region': "Nuclear Plant (E1M2) Main"},
    351006: {'name': 'Nuclear Plant (E1M2) - Supercharge',
             'episode': 1,
             'map': 2,
             'index': 22,
             'doom_type': 2013,
             'region': "Nuclear Plant (E1M2) Main"},
    351007: {'name': 'Nuclear Plant (E1M2) - Chaingun',
             'episode': 1,
             'map': 2,
             'index': 25,
             'doom_type': 2002,
             'region': "Nuclear Plant (E1M2) Main"},
    351008: {'name': 'Nuclear Plant (E1M2) - Red keycard',
             'episode': 1,
             'map': 2,
             'index': 41,
             'doom_type': 13,
             'region': "Nuclear Plant (E1M2) Main"},
    351009: {'name': 'Nuclear Plant (E1M2) - Armor 2',
             'episode': 1,
             'map': 2,
             'index': 43,
             'doom_type': 2018,
             'region': "Nuclear Plant (E1M2) Main"},
    351010: {'name': 'Nuclear Plant (E1M2) - Mega Armor',
             'episode': 1,
             'map': 2,
             'index': 53,
             'doom_type': 2019,
             'region': "Nuclear Plant (E1M2) Red"},
    351011: {'name': 'Nuclear Plant (E1M2) - Armor 3',
             'episode': 1,
             'map': 2,
             'index': 119,
             'doom_type': 2018,
             'region': "Nuclear Plant (E1M2) Red"},
    351012: {'name': 'Nuclear Plant (E1M2) - Backpack',
             'episode': 1,
             'map': 2,
             'index': 139,
             'doom_type': 8,
             'region': "Nuclear Plant (E1M2) Main"},
    351013: {'name': 'Nuclear Plant (E1M2) - Backpack 2',
             'episode': 1,
             'map': 2,
             'index': 200,
             'doom_type': 8,
             'region': "Nuclear Plant (E1M2) Red"},
    351014: {'name': 'Toxin Refinery (E1M3) - Armor',
             'episode': 1,
             'map': 3,
             'index': 8,
             'doom_type': 2018,
             'region': "Toxin Refinery (E1M3) Main"},
    351015: {'name': 'Toxin Refinery (E1M3) - Supercharge',
             'episode': 1,
             'map': 3,
             'index': 9,
             'doom_type': 2013,
             'region': "Toxin Refinery (E1M3) Main"},
    351016: {'name': 'Toxin Refinery (E1M3) - Yellow keycard',
             'episode': 1,
             'map': 3,
             'index': 18,
             'doom_type': 6,
             'region': "Toxin Refinery (E1M3) Main"},
    351017: {'name': 'Toxin Refinery (E1M3) - Blue keycard',
             'episode': 1,
             'map': 3,
             'index': 19,
             'doom_type': 5,
             'region': "Toxin Refinery (E1M3) Main"},
    351018: {'name': 'Toxin Refinery (E1M3) - Shotgun',
             'episode': 1,
             'map': 3,
             'index': 64,
             'doom_type': 2001,
             'region': "Toxin Refinery (E1M3) Start"},
    351019: {'name': 'Toxin Refinery (E1M3) - Shotgun 2',
             'episode': 1,
             'map': 3,
             'index': 77,
             'doom_type': 2001,
             'region': "Toxin Refinery (E1M3) Main"},
    351020: {'name': 'Toxin Refinery (E1M3) - Armor 2',
             'episode': 1,
             'map': 3,
             'index': 85,
             'doom_type': 2018,
             'region': "Toxin Refinery (E1M3) Main"},
    351021: {'name': 'Toxin Refinery (E1M3) - Rocket launcher',
             'episode': 1,
             'map': 3,
             'index': 107,
             'doom_type': 2003,
             'region': "Toxin Refinery (E1M3) Main"},
    351022: {'name': 'Toxin Refinery (E1M3) - Chaingun',
             'episode': 1,
             'map': 3,
             'index': 109,
             'doom_type': 2002,
             'region': "Toxin Refinery (E1M3) Main"},
    351023: {'name': 'Toxin Refinery (E1M3) - Backpack',
             'episode': 1,
             'map': 3,
             'index': 112,
             'doom_type': 8,
             'region': "Toxin Refinery (E1M3) Main"},
    351024: {'name': 'Toxin Refinery (E1M3) - Supercharge 2',
             'episode': 1,
             'map': 3,
             'index': 259,
             'doom_type': 2013,
             'region': "Toxin Refinery (E1M3) Yellow"},
    351025: {'name': 'Toxin Refinery (E1M3) - Partial invisibility',
             'episode': 1,
             'map': 3,
             'index': 260,
             'doom_type': 2024,
             'region': "Toxin Refinery (E1M3) Yellow"},
    351026: {'name': 'Toxin Refinery (E1M3) - Chainsaw',
             'episode': 1,
             'map': 3,
             'index': 261,
             'doom_type': 2005,
             'region': "Toxin Refinery (E1M3) Blue"},
    351027: {'name': 'Toxin Refinery (E1M3) - Mega Armor',
             'episode': 1,
             'map': 3,
             'index': 265,
             'doom_type': 2019,
             'region': "Toxin Refinery (E1M3) Yellow"},
    351028: {'name': 'Toxin Refinery (E1M3) - Armor 3',
             'episode': 1,
             'map': 3,
             'index': 323,
             'doom_type': 2018,
             'region': "Toxin Refinery (E1M3) Blue"},
    351029: {'name': 'Command Control (E1M4) - Chaingun',
             'episode': 1,
             'map': 4,
             'index': 11,
             'doom_type': 2002,
             'region': "Command Control (E1M4) Main"},
    351030: {'name': 'Command Control (E1M4) - Armor',
             'episode': 1,
             'map': 4,
             'index': 39,
             'doom_type': 2018,
             'region': "Command Control (E1M4) Blue"},
    351031: {'name': 'Command Control (E1M4) - Yellow keycard',
             'episode': 1,
             'map': 4,
             'index': 61,
             'doom_type': 6,
             'region': "Command Control (E1M4) Blue"},
    351032: {'name': 'Command Control (E1M4) - Blue keycard',
             'episode': 1,
             'map': 4,
             'index': 62,
             'doom_type': 5,
             'region': "Command Control (E1M4) Main"},
    351033: {'name': 'Command Control (E1M4) - Supercharge',
             'episode': 1,
             'map': 4,
             'index': 63,
             'doom_type': 2013,
             'region': "Command Control (E1M4) Main"},
    351034: {'name': 'Command Control (E1M4) - Rocket launcher',
             'episode': 1,
             'map': 4,
             'index': 64,
             'doom_type': 2003,
             'region': "Command Control (E1M4) Main"},
    351035: {'name': 'Command Control (E1M4) - Mega Armor',
             'episode': 1,
             'map': 4,
             'index': 100,
             'doom_type': 2019,
             'region': "Command Control (E1M4) Main"},
    351036: {'name': 'Command Control (E1M4) - Backpack',
             'episode': 1,
             'map': 4,
             'index': 107,
             'doom_type': 8,
             'region': "Command Control (E1M4) Start"},
    351037: {'name': 'Command Control (E1M4) - Shotgun',
             'episode': 1,
             'map': 4,
             'index': 129,
             'doom_type': 2001,
             'region': "Command Control (E1M4) Main"},
    351038: {'name': 'Phobos Lab (E1M5) - Blue keycard',
             'episode': 1,
             'map': 5,
             'index': 4,
             'doom_type': 5,
             'region': "Phobos Lab (E1M5) Green"},
    351039: {'name': 'Phobos Lab (E1M5) - Yellow keycard',
             'episode': 1,
             'map': 5,
             'index': 10,
             'doom_type': 6,
             'region': "Phobos Lab (E1M5) Main"},
    351040: {'name': 'Phobos Lab (E1M5) - Mega Armor',
             'episode': 1,
             'map': 5,
             'index': 11,
             'doom_type': 2019,
             'region': "Phobos Lab (E1M5) Main"},
    351041: {'name': 'Phobos Lab (E1M5) - Rocket launcher',
             'episode': 1,
             'map': 5,
             'index': 60,
             'doom_type': 2003,
             'region': "Phobos Lab (E1M5) Main"},
    351042: {'name': 'Phobos Lab (E1M5) - Shotgun',
             'episode': 1,
             'map': 5,
             'index': 75,
             'doom_type': 2001,
             'region': "Phobos Lab (E1M5) Main"},
    351043: {'name': 'Phobos Lab (E1M5) - Shotgun 2',
             'episode': 1,
             'map': 5,
             'index': 83,
             'doom_type': 2001,
             'region': "Phobos Lab (E1M5) Main"},
    351044: {'name': 'Phobos Lab (E1M5) - Chainsaw',
             'episode': 1,
             'map': 5,
             'index': 167,
             'doom_type': 2005,
             'region': "Phobos Lab (E1M5) Yellow"},
    351045: {'name': 'Phobos Lab (E1M5) - Supercharge',
             'episode': 1,
             'map': 5,
             'index': 169,
             'doom_type': 2013,
             'region': "Phobos Lab (E1M5) Yellow"},
    351046: {'name': 'Phobos Lab (E1M5) - Chaingun',
             'episode': 1,
             'map': 5,
             'index': 173,
             'doom_type': 2002,
             'region': "Phobos Lab (E1M5) Green"},
    351047: {'name': 'Phobos Lab (E1M5) - Backpack',
             'episode': 1,
             'map': 5,
             'index': 174,
             'doom_type': 8,
             'region': "Phobos Lab (E1M5) Green"},
    351048: {'name': 'Phobos Lab (E1M5) - Computer area map',
             'episode': 1,
             'map': 5,
             'index': 176,
             'doom_type': 2026,
             'region': "Phobos Lab (E1M5) Green"},
    351049: {'name': 'Phobos Lab (E1M5) - Mega Armor 2',
             'episode': 1,
             'map': 5,
             'index': 206,
             'doom_type': 2019,
             'region': "Phobos Lab (E1M5) Yellow"},
    351050: {'name': 'Phobos Lab (E1M5) - Shotgun 3',
             'episode': 1,
             'map': 5,
             'index': 208,
             'doom_type': 2001,
             'region': "Phobos Lab (E1M5) Main"},
    351051: {'name': 'Phobos Lab (E1M5) - Armor',
             'episode': 1,
             'map': 5,
             'index': 279,
             'doom_type': 2018,
             'region': "Phobos Lab (E1M5) Main"},
    351052: {'name': 'Phobos Lab (E1M5) - Armor 2',
             'episode': 1,
             'map': 5,
             'index': 280,
             'doom_type': 2018,
             'region': "Phobos Lab (E1M5) Green"},
    351053: {'name': 'Phobos Lab (E1M5) - Partial invisibility',
             'episode': 1,
             'map': 5,
             'index': 282,
             'doom_type': 2024,
             'region': "Phobos Lab (E1M5) Yellow"},
    351054: {'name': 'Central Processing (E1M6) - Supercharge',
             'episode': 1,
             'map': 6,
             'index': 4,
             'doom_type': 2013,
             'region': "Central Processing (E1M6) Red"},
    351055: {'name': 'Central Processing (E1M6) - Blue keycard',
             'episode': 1,
             'map': 6,
             'index': 5,
             'doom_type': 5,
             'region': "Central Processing (E1M6) Red"},
    351056: {'name': 'Central Processing (E1M6) - Red keycard',
             'episode': 1,
             'map': 6,
             'index': 9,
             'doom_type': 13,
             'region': "Central Processing (E1M6) Main"},
    351057: {'name': 'Central Processing (E1M6) - Yellow keycard',
             'episode': 1,
             'map': 6,
             'index': 10,
             'doom_type': 6,
             'region': "Central Processing (E1M6) Blue"},
    351058: {'name': 'Central Processing (E1M6) - Partial invisibility',
             'episode': 1,
             'map': 6,
             'index': 22,
             'doom_type': 2024,
             'region': "Central Processing (E1M6) Main"},
    351059: {'name': 'Central Processing (E1M6) - Chaingun',
             'episode': 1,
             'map': 6,
             'index': 23,
             'doom_type': 2002,
             'region': "Central Processing (E1M6) Main"},
    351060: {'name': 'Central Processing (E1M6) - Backpack',
             'episode': 1,
             'map': 6,
             'index': 24,
             'doom_type': 8,
             'region': "Central Processing (E1M6) Main"},
    351061: {'name': 'Central Processing (E1M6) - Rocket launcher',
             'episode': 1,
             'map': 6,
             'index': 63,
             'doom_type': 2003,
             'region': "Central Processing (E1M6) Main"},
    351062: {'name': 'Central Processing (E1M6) - Shotgun',
             'episode': 1,
             'map': 6,
             'index': 64,
             'doom_type': 2001,
             'region': "Central Processing (E1M6) Main"},
    351063: {'name': 'Central Processing (E1M6) - Mega Armor',
             'episode': 1,
             'map': 6,
             'index': 81,
             'doom_type': 2019,
             'region': "Central Processing (E1M6) Red"},
    351064: {'name': 'Central Processing (E1M6) - Armor',
             'episode': 1,
             'map': 6,
             'index': 82,
             'doom_type': 2018,
             'region': "Central Processing (E1M6) Main"},
    351065: {'name': 'Central Processing (E1M6) - Backpack 2',
             'episode': 1,
             'map': 6,
             'index': 123,
             'doom_type': 8,
             'region': "Central Processing (E1M6) Blue"},
    351066: {'name': 'Central Processing (E1M6) - Computer area map',
             'episode': 1,
             'map': 6,
             'index': 124,
             'doom_type': 2026,
             'region': "Central Processing (E1M6) Blue"},
    351067: {'name': 'Central Processing (E1M6) - Partial invisibility 2',
             'episode': 1,
             'map': 6,
             'index': 131,
             'doom_type': 2024,
             'region': "Central Processing (E1M6) Red"},
    351068: {'name': 'Central Processing (E1M6) - Armor 2',
             'episode': 1,
             'map': 6,
             'index': 214,
             'doom_type': 2018,
             'region': "Central Processing (E1M6) Blue"},
    351069: {'name': 'Central Processing (E1M6) - Armor 3',
             'episode': 1,
             'map': 6,
             'index': 291,
             'doom_type': 2018,
             'region': "Central Processing (E1M6) Yellow"},
    351070: {'name': 'Central Processing (E1M6) - Armor 4',
             'episode': 1,
             'map': 6,
             'index': 381,
             'doom_type': 2018,
             'region': "Central Processing (E1M6) Main"},
    351071: {'name': 'Central Processing (E1M6) - Supercharge 2',
             'episode': 1,
             'map': 6,
             'index': 392,
             'doom_type': 2013,
             'region': "Central Processing (E1M6) Nukage"},
    351072: {'name': 'Central Processing (E1M6) - Backpack 3',
             'episode': 1,
             'map': 6,
             'index': 395,
             'doom_type': 8,
             'region': "Central Processing (E1M6) Nukage"},
    351073: {'name': 'Computer Station (E1M7) - Chaingun',
             'episode': 1,
             'map': 7,
             'index': 18,
             'doom_type': 2002,
             'region': "Computer Station (E1M7) Yellow"},
    351074: {'name': 'Computer Station (E1M7) - Computer area map',
             'episode': 1,
             'map': 7,
             'index': 20,
             'doom_type': 2026,
             'region': "Computer Station (E1M7) Yellow"},
    351075: {'name': 'Computer Station (E1M7) - Supercharge',
             'episode': 1,
             'map': 7,
             'index': 21,
             'doom_type': 2013,
             'region': "Computer Station (E1M7) Yellow"},
    351076: {'name': 'Computer Station (E1M7) - Yellow keycard',
             'episode': 1,
             'map': 7,
             'index': 25,
             'doom_type': 6,
             'region': "Computer Station (E1M7) Main"},
    351077: {'name': 'Computer Station (E1M7) - Blue keycard',
             'episode': 1,
             'map': 7,
             'index': 26,
             'doom_type': 5,
             'region': "Computer Station (E1M7) Red"},
    351078: {'name': 'Computer Station (E1M7) - Red keycard',
             'episode': 1,
             'map': 7,
             'index': 27,
             'doom_type': 13,
             'region': "Computer Station (E1M7) Yellow"},
    351079: {'name': 'Computer Station (E1M7) - Chainsaw',
             'episode': 1,
             'map': 7,
             'index': 53,
             'doom_type': 2005,
             'region': "Computer Station (E1M7) Yellow"},
    351080: {'name': 'Computer Station (E1M7) - Shotgun',
             'episode': 1,
             'map': 7,
             'index': 87,
             'doom_type': 2001,
             'region': "Computer Station (E1M7) Blue"},
    351081: {'name': 'Computer Station (E1M7) - Shotgun 2',
             'episode': 1,
             'map': 7,
             'index': 122,
             'doom_type': 2001,
             'region': "Computer Station (E1M7) Start"},
    351082: {'name': 'Computer Station (E1M7) - Rocket launcher',
             'episode': 1,
             'map': 7,
             'index': 309,
             'doom_type': 2003,
             'region': "Computer Station (E1M7) Yellow"},
    351083: {'name': 'Computer Station (E1M7) - Armor',
             'episode': 1,
             'map': 7,
             'index': 310,
             'doom_type': 2018,
             'region': "Computer Station (E1M7) Main"},
    351084: {'name': 'Computer Station (E1M7) - Armor 2',
             'episode': 1,
             'map': 7,
             'index': 311,
             'doom_type': 2018,
             'region': "Computer Station (E1M7) Yellow"},
    351085: {'name': 'Computer Station (E1M7) - Mega Armor',
             'episode': 1,
             'map': 7,
             'index': 312,
             'doom_type': 2019,
             'region': "Computer Station (E1M7) Yellow"},
    351086: {'name': 'Computer Station (E1M7) - Backpack',
             'episode': 1,
             'map': 7,
             'index': 314,
             'doom_type': 8,
             'region': "Computer Station (E1M7) Yellow"},
    351087: {'name': 'Computer Station (E1M7) - Partial invisibility',
             'episode': 1,
             'map': 7,
             'index': 337,
             'doom_type': 2024,
             'region': "Computer Station (E1M7) Courtyard"},
    351088: {'name': 'Phobos Anomaly (E1M8) - Supercharge',
             'episode': 1,
             'map': 8,
             'index': 15,
             'doom_type': 2013,
             'region': "Phobos Anomaly (E1M8) Main"},
    351089: {'name': 'Phobos Anomaly (E1M8) - Shotgun',
             'episode': 1,
             'map': 8,
             'index': 49,
             'doom_type': 2001,
             'region': "Phobos Anomaly (E1M8) Main"},
    351090: {'name': 'Phobos Anomaly (E1M8) - Shotgun 2',
             'episode': 1,
             'map': 8,
             'index': 52,
             'doom_type': 2001,
             'region': "Phobos Anomaly (E1M8) Main"},
    351091: {'name': 'Phobos Anomaly (E1M8) - Armor',
             'episode': 1,
             'map': 8,
             'index': 53,
             'doom_type': 2018,
             'region': "Phobos Anomaly (E1M8) Main"},
    351092: {'name': 'Phobos Anomaly (E1M8) - Chaingun',
             'episode': 1,
             'map': 8,
             'index': 65,
             'doom_type': 2002,
             'region': "Phobos Anomaly (E1M8) Main"},
    351093: {'name': 'Phobos Anomaly (E1M8) - Partial invisibility',
             'episode': 1,
             'map': 8,
             'index': 70,
             'doom_type': 2024,
             'region': "Phobos Anomaly (E1M8) Main"},
    351094: {'name': 'Phobos Anomaly (E1M8) - Computer area map',
             'episode': 1,
             'map': 8,
             'index': 94,
             'doom_type': 2026,
             'region': "Phobos Anomaly (E1M8) Main"},
    351095: {'name': 'Military Base (E1M9) - Yellow keycard',
             'episode': 1,
             'map': 9,
             'index': 13,
             'doom_type': 6,
             'region': "Military Base (E1M9) Main"},
    351096: {'name': 'Military Base (E1M9) - Red keycard',
             'episode': 1,
             'map': 9,
             'index': 20,
             'doom_type': 13,
             'region': "Military Base (E1M9) Yellow"},
    351097: {'name': 'Military Base (E1M9) - Chaingun',
             'episode': 1,
             'map': 9,
             'index': 87,
             'doom_type': 2002,
             'region': "Military Base (E1M9) Main"},
    351098: {'name': 'Military Base (E1M9) - Armor',
             'episode': 1,
             'map': 9,
             'index': 139,
             'doom_type': 2018,
             'region': "Military Base (E1M9) Main"},
    351099: {'name': 'Military Base (E1M9) - Rocket launcher',
             'episode': 1,
             'map': 9,
             'index': 172,
             'doom_type': 2003,
             'region': "Military Base (E1M9) Main"},
    351100: {'name': 'Military Base (E1M9) - Blue keycard',
             'episode': 1,
             'map': 9,
             'index': 188,
             'doom_type': 5,
             'region': "Military Base (E1M9) Red"},
    351101: {'name': 'Military Base (E1M9) - Backpack',
             'episode': 1,
             'map': 9,
             'index': 222,
             'doom_type': 8,
             'region': "Military Base (E1M9) Blue"},
    351102: {'name': 'Military Base (E1M9) - Shotgun',
             'episode': 1,
             'map': 9,
             'index': 223,
             'doom_type': 2001,
             'region': "Military Base (E1M9) Blue"},
    351103: {'name': 'Military Base (E1M9) - Chainsaw',
             'episode': 1,
             'map': 9,
             'index': 225,
             'doom_type': 2005,
             'region': "Military Base (E1M9) Blue"},
    351104: {'name': 'Deimos Anomaly (E2M1) - Plasma gun',
             'episode': 2,
             'map': 1,
             'index': 44,
             'doom_type': 2004,
             'region': "Deimos Anomaly (E2M1) Main"},
    351105: {'name': 'Deimos Anomaly (E2M1) - Blue keycard',
             'episode': 2,
             'map': 1,
             'index': 51,
             'doom_type': 5,
             'region': "Deimos Anomaly (E2M1) Main"},
    351106: {'name': 'Deimos Anomaly (E2M1) - Shotgun',
             'episode': 2,
             'map': 1,
             'index': 54,
             'doom_type': 2001,
             'region': "Deimos Anomaly (E2M1) Main"},
    351107: {'name': 'Deimos Anomaly (E2M1) - Armor',
             'episode': 2,
             'map': 1,
             'index': 57,
             'doom_type': 2018,
             'region': "Deimos Anomaly (E2M1) Main"},
    351108: {'name': 'Deimos Anomaly (E2M1) - Red keycard',
             'episode': 2,
             'map': 1,
             'index': 83,
             'doom_type': 13,
             'region': "Deimos Anomaly (E2M1) Main"},
    351109: {'name': 'Deimos Anomaly (E2M1) - Computer area map',
             'episode': 2,
             'map': 1,
             'index': 84,
             'doom_type': 2026,
             'region': "Deimos Anomaly (E2M1) Red"},
    351110: {'name': 'Deimos Anomaly (E2M1) - Mega Armor',
             'episode': 2,
             'map': 1,
             'index': 86,
             'doom_type': 2019,
             'region': "Deimos Anomaly (E2M1) Red"},
    351111: {'name': 'Deimos Anomaly (E2M1) - Shotgun 2',
             'episode': 2,
             'map': 1,
             'index': 99,
             'doom_type': 2001,
             'region': "Deimos Anomaly (E2M1) Main"},
    351112: {'name': 'Containment Area (E2M2) - Chaingun',
             'episode': 2,
             'map': 2,
             'index': 8,
             'doom_type': 2002,
             'region': "Containment Area (E2M2) Yellow"},
    351113: {'name': 'Containment Area (E2M2) - Armor',
             'episode': 2,
             'map': 2,
             'index': 9,
             'doom_type': 2018,
             'region': "Containment Area (E2M2) Main"},
    351114: {'name': 'Containment Area (E2M2) - Armor 2',
             'episode': 2,
             'map': 2,
             'index': 20,
             'doom_type': 2018,
             'region': "Containment Area (E2M2) Main"},
    351115: {'name': 'Containment Area (E2M2) - Backpack',
             'episode': 2,
             'map': 2,
             'index': 66,
             'doom_type': 8,
             'region': "Containment Area (E2M2) Main"},
    351116: {'name': 'Containment Area (E2M2) - Supercharge',
             'episode': 2,
             'map': 2,
             'index': 80,
             'doom_type': 2013,
             'region': "Containment Area (E2M2) Main"},
    351117: {'name': 'Containment Area (E2M2) - Chainsaw',
             'episode': 2,
             'map': 2,
             'index': 81,
             'doom_type': 2005,
             'region': "Containment Area (E2M2) Main"},
    351118: {'name': 'Containment Area (E2M2) - Armor 3',
             'episode': 2,
             'map': 2,
             'index': 100,
             'doom_type': 2018,
             'region': "Containment Area (E2M2) Main"},
    351119: {'name': 'Containment Area (E2M2) - Computer area map',
             'episode': 2,
             'map': 2,
             'index': 109,
             'doom_type': 2026,
             'region': "Containment Area (E2M2) Main"},
    351120: {'name': 'Containment Area (E2M2) - Mega Armor',
             'episode': 2,
             'map': 2,
             'index': 125,
             'doom_type': 2019,
             'region': "Containment Area (E2M2) Main"},
    351121: {'name': 'Containment Area (E2M2) - Plasma gun',
             'episode': 2,
             'map': 2,
             'index': 127,
             'doom_type': 2004,
             'region': "Containment Area (E2M2) Main"},
    351122: {'name': 'Containment Area (E2M2) - Rocket launcher',
             'episode': 2,
             'map': 2,
             'index': 138,
             'doom_type': 2003,
             'region': "Containment Area (E2M2) Yellow"},
    351123: {'name': 'Containment Area (E2M2) - Blue keycard',
             'episode': 2,
             'map': 2,
             'index': 143,
             'doom_type': 5,
             'region': "Containment Area (E2M2) Main"},
    351124: {'name': 'Containment Area (E2M2) - Yellow keycard',
             'episode': 2,
             'map': 2,
             'index': 144,
             'doom_type': 6,
             'region': "Containment Area (E2M2) Main"},
    351125: {'name': 'Containment Area (E2M2) - Red keycard',
             'episode': 2,
             'map': 2,
             'index': 153,
             'doom_type': 13,
             'region': "Containment Area (E2M2) Blue"},
    351126: {'name': 'Containment Area (E2M2) - Shotgun',
             'episode': 2,
             'map': 2,
             'index': 160,
             'doom_type': 2001,
             'region': "Containment Area (E2M2) Main"},
    351127: {'name': 'Containment Area (E2M2) - Shotgun 2',
             'episode': 2,
             'map': 2,
             'index': 161,
             'doom_type': 2001,
             'region': "Containment Area (E2M2) Main"},
    351128: {'name': 'Containment Area (E2M2) - Armor 4',
             'episode': 2,
             'map': 2,
             'index': 165,
             'doom_type': 2018,
             'region': "Containment Area (E2M2) Main"},
    351129: {'name': 'Containment Area (E2M2) - Berserk',
             'episode': 2,
             'map': 2,
             'index': 250,
             'doom_type': 2023,
             'region': "Containment Area (E2M2) Main"},
    351130: {'name': 'Containment Area (E2M2) - Backpack 2',
             'episode': 2,
             'map': 2,
             'index': 291,
             'doom_type': 8,
             'region': "Containment Area (E2M2) Yellow"},
    351131: {'name': 'Refinery (E2M3) - Plasma gun',
             'episode': 2,
             'map': 3,
             'index': 12,
             'doom_type': 2004,
             'region': "Refinery (E2M3) Main"},
    351132: {'name': 'Refinery (E2M3) - Backpack',
             'episode': 2,
             'map': 3,
             'index': 37,
             'doom_type': 8,
             'region': "Refinery (E2M3) Main"},
    351133: {'name': 'Refinery (E2M3) - Mega Armor',
             'episode': 2,
             'map': 3,
             'index': 40,
             'doom_type': 2019,
             'region': "Refinery (E2M3) Main"},
    351134: {'name': 'Refinery (E2M3) - Armor',
             'episode': 2,
             'map': 3,
             'index': 57,
             'doom_type': 2018,
             'region': "Refinery (E2M3) Main"},
    351135: {'name': 'Refinery (E2M3) - Partial invisibility',
             'episode': 2,
             'map': 3,
             'index': 67,
             'doom_type': 2024,
             'region': "Refinery (E2M3) Blue"},
    351136: {'name': 'Refinery (E2M3) - Supercharge',
             'episode': 2,
             'map': 3,
             'index': 87,
             'doom_type': 2013,
             'region': "Refinery (E2M3) Blue"},
    351137: {'name': 'Refinery (E2M3) - Blue keycard',
             'episode': 2,
             'map': 3,
             'index': 90,
             'doom_type': 5,
             'region': "Refinery (E2M3) Main"},
    351138: {'name': 'Refinery (E2M3) - Partial invisibility 2',
             'episode': 2,
             'map': 3,
             'index': 110,
             'doom_type': 2024,
             'region': "Refinery (E2M3) Main"},
    351139: {'name': 'Refinery (E2M3) - Shotgun',
             'episode': 2,
             'map': 3,
             'index': 113,
             'doom_type': 2001,
             'region': "Refinery (E2M3) Main"},
    351140: {'name': 'Refinery (E2M3) - Berserk',
             'episode': 2,
             'map': 3,
             'index': 221,
             'doom_type': 2023,
             'region': "Refinery (E2M3) Main"},
    351141: {'name': 'Refinery (E2M3) - Chaingun',
             'episode': 2,
             'map': 3,
             'index': 223,
             'doom_type': 2002,
             'region': "Refinery (E2M3) Main"},
    351142: {'name': 'Deimos Lab (E2M4) - Armor',
             'episode': 2,
             'map': 4,
             'index': 7,
             'doom_type': 2018,
             'region': "Deimos Lab (E2M4) Main"},
    351143: {'name': 'Deimos Lab (E2M4) - Partial invisibility',
             'episode': 2,
             'map': 4,
             'index': 8,
             'doom_type': 2024,
             'region': "Deimos Lab (E2M4) Main"},
    351144: {'name': 'Deimos Lab (E2M4) - Computer area map',
             'episode': 2,
             'map': 4,
             'index': 39,
             'doom_type': 2026,
             'region': "Deimos Lab (E2M4) Main"},
    351145: {'name': 'Deimos Lab (E2M4) - Armor 2',
             'episode': 2,
             'map': 4,
             'index': 40,
             'doom_type': 2018,
             'region': "Deimos Lab (E2M4) Main"},
    351146: {'name': 'Deimos Lab (E2M4) - Blue keycard',
             'episode': 2,
             'map': 4,
             'index': 74,
             'doom_type': 5,
             'region': "Deimos Lab (E2M4) Main"},
    351147: {'name': 'Deimos Lab (E2M4) - Yellow keycard',
             'episode': 2,
             'map': 4,
             'index': 86,
             'doom_type': 6,
             'region': "Deimos Lab (E2M4) Blue"},
    351148: {'name': 'Deimos Lab (E2M4) - Supercharge',
             'episode': 2,
             'map': 4,
             'index': 107,
             'doom_type': 2013,
             'region': "Deimos Lab (E2M4) Yellow"},
    351149: {'name': 'Deimos Lab (E2M4) - Shotgun',
             'episode': 2,
             'map': 4,
             'index': 109,
             'doom_type': 2001,
             'region': "Deimos Lab (E2M4) Start"},
    351150: {'name': 'Deimos Lab (E2M4) - Mega Armor',
             'episode': 2,
             'map': 4,
             'index': 129,
             'doom_type': 2019,
             'region': "Deimos Lab (E2M4) Yellow"},
    351151: {'name': 'Deimos Lab (E2M4) - Plasma gun',
             'episode': 2,
             'map': 4,
             'index': 130,
             'doom_type': 2004,
             'region': "Deimos Lab (E2M4) Yellow"},
    351152: {'name': 'Deimos Lab (E2M4) - Backpack',
             'episode': 2,
             'map': 4,
             'index': 159,
             'doom_type': 8,
             'region': "Deimos Lab (E2M4) Main"},
    351153: {'name': 'Deimos Lab (E2M4) - Berserk',
             'episode': 2,
             'map': 4,
             'index': 174,
             'doom_type': 2023,
             'region': "Deimos Lab (E2M4) Main"},
    351154: {'name': 'Deimos Lab (E2M4) - Partial invisibility 2',
             'episode': 2,
             'map': 4,
             'index': 175,
             'doom_type': 2024,
             'region': "Deimos Lab (E2M4) Main"},
    351155: {'name': 'Deimos Lab (E2M4) - Armor 3',
             'episode': 2,
             'map': 4,
             'index': 186,
             'doom_type': 2018,
             'region': "Deimos Lab (E2M4) Main"},
    351156: {'name': 'Deimos Lab (E2M4) - Chaingun',
             'episode': 2,
             'map': 4,
             'index': 189,
             'doom_type': 2002,
             'region': "Deimos Lab (E2M4) Main"},
    351157: {'name': 'Deimos Lab (E2M4) - Supercharge 2',
             'episode': 2,
             'map': 4,
             'index': 244,
             'doom_type': 2013,
             'region': "Deimos Lab (E2M4) Main"},
    351158: {'name': 'Command Center (E2M5) - Backpack',
             'episode': 2,
             'map': 5,
             'index': 3,
             'doom_type': 8,
             'region': "Command Center (E2M5) Main"},
    351159: {'name': 'Command Center (E2M5) - Mega Armor',
             'episode': 2,
             'map': 5,
             'index': 53,
             'doom_type': 2019,
             'region': "Command Center (E2M5) Main"},
    351160: {'name': 'Command Center (E2M5) - Berserk',
             'episode': 2,
             'map': 5,
             'index': 57,
             'doom_type': 2023,
             'region': "Command Center (E2M5) Main"},
    351161: {'name': 'Command Center (E2M5) - Chaingun',
             'episode': 2,
             'map': 5,
             'index': 69,
             'doom_type': 2002,
             'region': "Command Center (E2M5) Main"},
    351162: {'name': 'Command Center (E2M5) - Chainsaw',
             'episode': 2,
             'map': 5,
             'index': 79,
             'doom_type': 2005,
             'region': "Command Center (E2M5) Main"},
    351163: {'name': 'Command Center (E2M5) - Plasma gun',
             'episode': 2,
             'map': 5,
             'index': 109,
             'doom_type': 2004,
             'region': "Command Center (E2M5) Main"},
    351164: {'name': 'Command Center (E2M5) - Computer area map',
             'episode': 2,
             'map': 5,
             'index': 176,
             'doom_type': 2026,
             'region': "Command Center (E2M5) Main"},
    351165: {'name': 'Command Center (E2M5) - Armor',
             'episode': 2,
             'map': 5,
             'index': 197,
             'doom_type': 2018,
             'region': "Command Center (E2M5) Main"},
    351166: {'name': 'Command Center (E2M5) - Armor 2',
             'episode': 2,
             'map': 5,
             'index': 233,
             'doom_type': 2018,
             'region': "Command Center (E2M5) Main"},
    351167: {'name': 'Command Center (E2M5) - Partial invisibility',
             'episode': 2,
             'map': 5,
             'index': 256,
             'doom_type': 2024,
             'region': "Command Center (E2M5) Main"},
    351168: {'name': 'Halls of the Damned (E2M6) - Berserk',
             'episode': 2,
             'map': 6,
             'index': 10,
             'doom_type': 2023,
             'region': "Halls of the Damned (E2M6) Main"},
    351169: {'name': 'Halls of the Damned (E2M6) - Blue skull key',
             'episode': 2,
             'map': 6,
             'index': 13,
             'doom_type': 40,
             'region': "Halls of the Damned (E2M6) Main"},
    351170: {'name': 'Halls of the Damned (E2M6) - Backpack',
             'episode': 2,
             'map': 6,
             'index': 26,
             'doom_type': 8,
             'region': "Halls of the Damned (E2M6) Main"},
    351171: {'name': 'Halls of the Damned (E2M6) - Mega Armor',
             'episode': 2,
             'map': 6,
             'index': 39,
             'doom_type': 2019,
             'region': "Halls of the Damned (E2M6) Main"},
    351172: {'name': 'Halls of the Damned (E2M6) - Computer area map',
             'episode': 2,
             'map': 6,
             'index': 48,
             'doom_type': 2026,
             'region': "Halls of the Damned (E2M6) Yellow"},
    351173: {'name': 'Halls of the Damned (E2M6) - Armor',
             'episode': 2,
             'map': 6,
             'index': 49,
             'doom_type': 2018,
             'region': "Halls of the Damned (E2M6) Main"},
    351174: {'name': 'Halls of the Damned (E2M6) - Partial invisibility',
             'episode': 2,
             'map': 6,
             'index': 57,
             'doom_type': 2024,
             'region': "Halls of the Damned (E2M6) Main"},
    351175: {'name': 'Halls of the Damned (E2M6) - Yellow skull key',
             'episode': 2,
             'map': 6,
             'index': 125,
             'doom_type': 39,
             'region': "Halls of the Damned (E2M6) One way Yellow"},
    351176: {'name': 'Halls of the Damned (E2M6) - Supercharge',
             'episode': 2,
             'map': 6,
             'index': 142,
             'doom_type': 2013,
             'region': "Halls of the Damned (E2M6) Yellow"},
    351177: {'name': 'Halls of the Damned (E2M6) - Chaingun',
             'episode': 2,
             'map': 6,
             'index': 143,
             'doom_type': 2002,
             'region': "Halls of the Damned (E2M6) Main"},
    351178: {'name': 'Halls of the Damned (E2M6) - Plasma gun',
             'episode': 2,
             'map': 6,
             'index': 173,
             'doom_type': 2004,
             'region': "Halls of the Damned (E2M6) Main"},
    351179: {'name': 'Halls of the Damned (E2M6) - Partial invisibility 2',
             'episode': 2,
             'map': 6,
             'index': 217,
             'doom_type': 2024,
             'region': "Halls of the Damned (E2M6) One way Yellow"},
    351180: {'name': 'Halls of the Damned (E2M6) - Red skull key',
             'episode': 2,
             'map': 6,
             'index': 220,
             'doom_type': 38,
             'region': "Halls of the Damned (E2M6) Main"},
    351181: {'name': 'Halls of the Damned (E2M6) - Shotgun',
             'episode': 2,
             'map': 6,
             'index': 230,
             'doom_type': 2001,
             'region': "Halls of the Damned (E2M6) Main"},
    351182: {'name': 'Halls of the Damned (E2M6) - Rocket launcher',
             'episode': 2,
             'map': 6,
             'index': 232,
             'doom_type': 2003,
             'region': "Halls of the Damned (E2M6) Main"},
    351183: {'name': 'Halls of the Damned (E2M6) - Chainsaw',
             'episode': 2,
             'map': 6,
             'index': 286,
             'doom_type': 2005,
             'region': "Halls of the Damned (E2M6) Main"},
    351184: {'name': 'Halls of the Damned (E2M6) - Partial invisibility 3',
             'episode': 2,
             'map': 6,
             'index': 320,
             'doom_type': 2024,
             'region': "Halls of the Damned (E2M6) Main"},
    351185: {'name': 'Spawning Vats (E2M7) - Rocket launcher',
             'episode': 2,
             'map': 7,
             'index': 29,
             'doom_type': 2003,
             'region': "Spawning Vats (E2M7) Main"},
    351186: {'name': 'Spawning Vats (E2M7) - Backpack',
             'episode': 2,
             'map': 7,
             'index': 49,
             'doom_type': 8,
             'region': "Spawning Vats (E2M7) Blue"},
    351187: {'name': 'Spawning Vats (E2M7) - Partial invisibility',
             'episode': 2,
             'map': 7,
             'index': 79,
             'doom_type': 2024,
             'region': "Spawning Vats (E2M7) Main"},
    351188: {'name': 'Spawning Vats (E2M7) - Mega Armor',
             'episode': 2,
             'map': 7,
             'index': 94,
             'doom_type': 2019,
             'region': "Spawning Vats (E2M7) Main"},
    351189: {'name': 'Spawning Vats (E2M7) - Chaingun',
             'episode': 2,
             'map': 7,
             'index': 128,
             'doom_type': 2002,
             'region': "Spawning Vats (E2M7) Blue"},
    351190: {'name': 'Spawning Vats (E2M7) - Armor',
             'episode': 2,
             'map': 7,
             'index': 131,
             'doom_type': 2018,
             'region': "Spawning Vats (E2M7) Main"},
    351191: {'name': 'Spawning Vats (E2M7) - Red keycard',
             'episode': 2,
             'map': 7,
             'index': 140,
             'doom_type': 13,
             'region': "Spawning Vats (E2M7) Yellow"},
    351192: {'name': 'Spawning Vats (E2M7) - Yellow keycard',
             'episode': 2,
             'map': 7,
             'index': 141,
             'doom_type': 6,
             'region': "Spawning Vats (E2M7) Blue"},
    351193: {'name': 'Spawning Vats (E2M7) - Blue keycard',
             'episode': 2,
             'map': 7,
             'index': 142,
             'doom_type': 5,
             'region': "Spawning Vats (E2M7) Main"},
    351194: {'name': 'Spawning Vats (E2M7) - Invulnerability',
             'episode': 2,
             'map': 7,
             'index': 146,
             'doom_type': 2022,
             'region': "Spawning Vats (E2M7) Main"},
    351195: {'name': 'Spawning Vats (E2M7) - Berserk',
             'episode': 2,
             'map': 7,
             'index': 160,
             'doom_type': 2023,
             'region': "Spawning Vats (E2M7) Main"},
    351196: {'name': 'Spawning Vats (E2M7) - Chainsaw',
             'episode': 2,
             'map': 7,
             'index': 174,
             'doom_type': 2005,
             'region': "Spawning Vats (E2M7) Main"},
    351197: {'name': 'Spawning Vats (E2M7) - Supercharge',
             'episode': 2,
             'map': 7,
             'index': 199,
             'doom_type': 2013,
             'region': "Spawning Vats (E2M7) Entrance Secret"},
    351198: {'name': 'Spawning Vats (E2M7) - Invulnerability 2',
             'episode': 2,
             'map': 7,
             'index': 200,
             'doom_type': 2022,
             'region': "Spawning Vats (E2M7) Main"},
    351199: {'name': 'Spawning Vats (E2M7) - Computer area map',
             'episode': 2,
             'map': 7,
             'index': 201,
             'doom_type': 2026,
             'region': "Spawning Vats (E2M7) Main"},
    351200: {'name': 'Spawning Vats (E2M7) - Plasma gun',
             'episode': 2,
             'map': 7,
             'index': 203,
             'doom_type': 2004,
             'region': "Spawning Vats (E2M7) Main"},
    351201: {'name': 'Tower of Babel (E2M8) - Rocket launcher',
             'episode': 2,
             'map': 8,
             'index': 16,
             'doom_type': 2003,
             'region': "Tower of Babel (E2M8) Main"},
    351202: {'name': 'Tower of Babel (E2M8) - Supercharge',
             'episode': 2,
             'map': 8,
             'index': 17,
             'doom_type': 2013,
             'region': "Tower of Babel (E2M8) Main"},
    351203: {'name': 'Tower of Babel (E2M8) - Supercharge 2',
             'episode': 2,
             'map': 8,
             'index': 18,
             'doom_type': 2013,
             'region': "Tower of Babel (E2M8) Main"},
    351204: {'name': 'Tower of Babel (E2M8) - Mega Armor',
             'episode': 2,
             'map': 8,
             'index': 36,
             'doom_type': 2019,
             'region': "Tower of Babel (E2M8) Start"},
    351205: {'name': 'Fortress of Mystery (E2M9) - Supercharge',
             'episode': 2,
             'map': 9,
             'index': 18,
             'doom_type': 2013,
             'region': "Fortress of Mystery (E2M9) Main"},
    351206: {'name': 'Fortress of Mystery (E2M9) - Blue skull key',
             'episode': 2,
             'map': 9,
             'index': 27,
             'doom_type': 40,
             'region': "Fortress of Mystery (E2M9) Main"},
    351207: {'name': 'Fortress of Mystery (E2M9) - Red skull key',
             'episode': 2,
             'map': 9,
             'index': 28,
             'doom_type': 38,
             'region': "Fortress of Mystery (E2M9) Blue"},
    351208: {'name': 'Fortress of Mystery (E2M9) - Yellow skull key',
             'episode': 2,
             'map': 9,
             'index': 29,
             'doom_type': 39,
             'region': "Fortress of Mystery (E2M9) Red"},
    351209: {'name': 'Fortress of Mystery (E2M9) - Backpack',
             'episode': 2,
             'map': 9,
             'index': 30,
             'doom_type': 8,
             'region': "Fortress of Mystery (E2M9) Main"},
    351210: {'name': 'Fortress of Mystery (E2M9) - Chaingun',
             'episode': 2,
             'map': 9,
             'index': 31,
             'doom_type': 2002,
             'region': "Fortress of Mystery (E2M9) Main"},
    351211: {'name': 'Fortress of Mystery (E2M9) - Plasma gun',
             'episode': 2,
             'map': 9,
             'index': 32,
             'doom_type': 2004,
             'region': "Fortress of Mystery (E2M9) Main"},
    351212: {'name': 'Fortress of Mystery (E2M9) - Rocket launcher',
             'episode': 2,
             'map': 9,
             'index': 33,
             'doom_type': 2003,
             'region': "Fortress of Mystery (E2M9) Main"},
    351213: {'name': 'Fortress of Mystery (E2M9) - Shotgun',
             'episode': 2,
             'map': 9,
             'index': 34,
             'doom_type': 2001,
             'region': "Fortress of Mystery (E2M9) Main"},
    351214: {'name': 'Fortress of Mystery (E2M9) - Chainsaw',
             'episode': 2,
             'map': 9,
             'index': 35,
             'doom_type': 2005,
             'region': "Fortress of Mystery (E2M9) Main"},
    351215: {'name': 'Fortress of Mystery (E2M9) - Computer area map',
             'episode': 2,
             'map': 9,
             'index': 36,
             'doom_type': 2026,
             'region': "Fortress of Mystery (E2M9) Main"},
    351216: {'name': 'Fortress of Mystery (E2M9) - Mega Armor',
             'episode': 2,
             'map': 9,
             'index': 44,
             'doom_type': 2019,
             'region': "Fortress of Mystery (E2M9) Main"},
    351217: {'name': 'Hell Keep (E3M1) - Shotgun',
             'episode': 3,
             'map': 1,
             'index': 20,
             'doom_type': 2001,
             'region': "Hell Keep (E3M1) Main"},
    351218: {'name': 'Hell Keep (E3M1) - Rocket launcher',
             'episode': 3,
             'map': 1,
             'index': 46,
             'doom_type': 2003,
             'region': "Hell Keep (E3M1) Narrow"},
    351219: {'name': 'Slough of Despair (E3M2) - Chaingun',
             'episode': 3,
             'map': 2,
             'index': 32,
             'doom_type': 2002,
             'region': "Slough of Despair (E3M2) Main"},
    351220: {'name': 'Slough of Despair (E3M2) - Berserk',
             'episode': 3,
             'map': 2,
             'index': 37,
             'doom_type': 2023,
             'region': "Slough of Despair (E3M2) Main"},
    351221: {'name': 'Slough of Despair (E3M2) - Mega Armor',
             'episode': 3,
             'map': 2,
             'index': 76,
             'doom_type': 2019,
             'region': "Slough of Despair (E3M2) Main"},
    351222: {'name': 'Slough of Despair (E3M2) - Armor',
             'episode': 3,
             'map': 2,
             'index': 77,
             'doom_type': 2018,
             'region': "Slough of Despair (E3M2) Main"},
    351223: {'name': 'Slough of Despair (E3M2) - Rocket launcher',
             'episode': 3,
             'map': 2,
             'index': 80,
             'doom_type': 2003,
             'region': "Slough of Despair (E3M2) Main"},
    351224: {'name': 'Slough of Despair (E3M2) - Plasma gun',
             'episode': 3,
             'map': 2,
             'index': 88,
             'doom_type': 2004,
             'region': "Slough of Despair (E3M2) Main"},
    351225: {'name': 'Slough of Despair (E3M2) - Computer area map',
             'episode': 3,
             'map': 2,
             'index': 154,
             'doom_type': 2026,
             'region': "Slough of Despair (E3M2) Main"},
    351226: {'name': 'Slough of Despair (E3M2) - Blue skull key',
             'episode': 3,
             'map': 2,
             'index': 181,
             'doom_type': 40,
             'region': "Slough of Despair (E3M2) Main"},
    351227: {'name': 'Slough of Despair (E3M2) - Supercharge',
             'episode': 3,
             'map': 2,
             'index': 182,
             'doom_type': 2013,
             'region': "Slough of Despair (E3M2) Main"},
    351228: {'name': 'Pandemonium (E3M3) - Berserk',
             'episode': 3,
             'map': 3,
             'index': 11,
             'doom_type': 2023,
             'region': "Pandemonium (E3M3) Main"},
    351229: {'name': 'Pandemonium (E3M3) - Chaingun',
             'episode': 3,
             'map': 3,
             'index': 14,
             'doom_type': 2002,
             'region': "Pandemonium (E3M3) Main"},
    351230: {'name': 'Pandemonium (E3M3) - BFG9000',
             'episode': 3,
             'map': 3,
             'index': 22,
             'doom_type': 2006,
             'region': "Pandemonium (E3M3) Main"},
    351231: {'name': 'Pandemonium (E3M3) - Supercharge',
             'episode': 3,
             'map': 3,
             'index': 23,
             'doom_type': 2013,
             'region': "Pandemonium (E3M3) Main"},
    351232: {'name': 'Pandemonium (E3M3) - Invulnerability',
             'episode': 3,
             'map': 3,
             'index': 26,
             'doom_type': 2022,
             'region': "Pandemonium (E3M3) Main"},
    351233: {'name': 'Pandemonium (E3M3) - Blue skull key',
             'episode': 3,
             'map': 3,
             'index': 49,
             'doom_type': 40,
             'region': "Pandemonium (E3M3) Main"},
    351234: {'name': 'Pandemonium (E3M3) - Mega Armor',
             'episode': 3,
             'map': 3,
             'index': 66,
             'doom_type': 2019,
             'region': "Pandemonium (E3M3) Main"},
    351235: {'name': 'Pandemonium (E3M3) - Shotgun',
             'episode': 3,
             'map': 3,
             'index': 73,
             'doom_type': 2001,
             'region': "Pandemonium (E3M3) Main"},
    351236: {'name': 'Pandemonium (E3M3) - Armor',
             'episode': 3,
             'map': 3,
             'index': 85,
             'doom_type': 2018,
             'region': "Pandemonium (E3M3) Main"},
    351237: {'name': 'Pandemonium (E3M3) - Backpack',
             'episode': 3,
             'map': 3,
             'index': 88,
             'doom_type': 8,
             'region': "Pandemonium (E3M3) Main"},
    351238: {'name': 'Pandemonium (E3M3) - Computer area map',
             'episode': 3,
             'map': 3,
             'index': 92,
             'doom_type': 2026,
             'region': "Pandemonium (E3M3) Main"},
    351239: {'name': 'Pandemonium (E3M3) - Mega Armor 2',
             'episode': 3,
             'map': 3,
             'index': 113,
             'doom_type': 2019,
             'region': "Pandemonium (E3M3) Main"},
    351240: {'name': 'Pandemonium (E3M3) - Shotgun 2',
             'episode': 3,
             'map': 3,
             'index': 118,
             'doom_type': 2001,
             'region': "Pandemonium (E3M3) Main"},
    351241: {'name': 'Pandemonium (E3M3) - Rocket launcher',
             'episode': 3,
             'map': 3,
             'index': 183,
             'doom_type': 2003,
             'region': "Pandemonium (E3M3) Main"},
    351242: {'name': 'House of Pain (E3M4) - Shotgun',
             'episode': 3,
             'map': 4,
             'index': 5,
             'doom_type': 2001,
             'region': "House of Pain (E3M4) Main"},
    351243: {'name': 'House of Pain (E3M4) - Berserk',
             'episode': 3,
             'map': 4,
             'index': 15,
             'doom_type': 2023,
             'region': "House of Pain (E3M4) Main"},
    351244: {'name': 'House of Pain (E3M4) - Mega Armor',
             'episode': 3,
             'map': 4,
             'index': 17,
             'doom_type': 2019,
             'region': "House of Pain (E3M4) Main"},
    351245: {'name': 'House of Pain (E3M4) - Chaingun',
             'episode': 3,
             'map': 4,
             'index': 46,
             'doom_type': 2002,
             'region': "House of Pain (E3M4) Main"},
    351246: {'name': 'House of Pain (E3M4) - Invulnerability',
             'episode': 3,
             'map': 4,
             'index': 51,
             'doom_type': 2022,
             'region': "House of Pain (E3M4) Main"},
    351247: {'name': 'House of Pain (E3M4) - Blue skull key',
             'episode': 3,
             'map': 4,
             'index': 87,
             'doom_type': 40,
             'region': "House of Pain (E3M4) Main"},
    351248: {'name': 'House of Pain (E3M4) - Armor',
             'episode': 3,
             'map': 4,
             'index': 100,
             'doom_type': 2018,
             'region': "House of Pain (E3M4) Main"},
    351249: {'name': 'House of Pain (E3M4) - Yellow skull key',
             'episode': 3,
             'map': 4,
             'index': 114,
             'doom_type': 39,
             'region': "House of Pain (E3M4) Blue"},
    351250: {'name': 'House of Pain (E3M4) - Invulnerability 2',
             'episode': 3,
             'map': 4,
             'index': 121,
             'doom_type': 2022,
             'region': "House of Pain (E3M4) Blue"},
    351251: {'name': 'House of Pain (E3M4) - Red skull key',
             'episode': 3,
             'map': 4,
             'index': 134,
             'doom_type': 38,
             'region': "House of Pain (E3M4) Yellow"},
    351252: {'name': 'House of Pain (E3M4) - Backpack',
             'episode': 3,
             'map': 4,
             'index': 160,
             'doom_type': 8,
             'region': "House of Pain (E3M4) Red"},
    351253: {'name': 'House of Pain (E3M4) - Mega Armor 2',
             'episode': 3,
             'map': 4,
             'index': 170,
             'doom_type': 2019,
             'region': "House of Pain (E3M4) Red"},
    351254: {'name': 'House of Pain (E3M4) - Partial invisibility',
             'episode': 3,
             'map': 4,
             'index': 182,
             'doom_type': 2024,
             'region': "House of Pain (E3M4) Blue"},
    351255: {'name': 'House of Pain (E3M4) - BFG9000',
             'episode': 3,
             'map': 4,
             'index': 206,
             'doom_type': 2006,
             'region': "House of Pain (E3M4) Blue"},
    351256: {'name': 'House of Pain (E3M4) - Supercharge',
             'episode': 3,
             'map': 4,
             'index': 220,
             'doom_type': 2013,
             'region': "House of Pain (E3M4) Blue"},
    351257: {'name': 'House of Pain (E3M4) - Armor 2',
             'episode': 3,
             'map': 4,
             'index': 242,
             'doom_type': 2018,
             'region': "House of Pain (E3M4) Main"},
    351258: {'name': 'House of Pain (E3M4) - Rocket launcher',
             'episode': 3,
             'map': 4,
             'index': 243,
             'doom_type': 2003,
             'region': "House of Pain (E3M4) Main"},
    351259: {'name': 'House of Pain (E3M4) - Armor 3',
             'episode': 3,
             'map': 4,
             'index': 318,
             'doom_type': 2018,
             'region': "House of Pain (E3M4) Blue"},
    351260: {'name': 'Unholy Cathedral (E3M5) - Blue skull key',
             'episode': 3,
             'map': 5,
             'index': 54,
             'doom_type': 40,
             'region': "Unholy Cathedral (E3M5) Main"},
    351261: {'name': 'Unholy Cathedral (E3M5) - Chaingun',
             'episode': 3,
             'map': 5,
             'index': 55,
             'doom_type': 2002,
             'region': "Unholy Cathedral (E3M5) Main"},
    351262: {'name': 'Unholy Cathedral (E3M5) - Plasma gun',
             'episode': 3,
             'map': 5,
             'index': 86,
             'doom_type': 2004,
             'region': "Unholy Cathedral (E3M5) Main"},
    351263: {'name': 'Unholy Cathedral (E3M5) - Supercharge',
             'episode': 3,
             'map': 5,
             'index': 87,
             'doom_type': 2013,
             'region': "Unholy Cathedral (E3M5) Main"},
    351264: {'name': 'Unholy Cathedral (E3M5) - Yellow skull key',
             'episode': 3,
             'map': 5,
             'index': 89,
             'doom_type': 39,
             'region': "Unholy Cathedral (E3M5) Main"},
    351265: {'name': 'Unholy Cathedral (E3M5) - Invulnerability',
             'episode': 3,
             'map': 5,
             'index': 90,
             'doom_type': 2022,
             'region': "Unholy Cathedral (E3M5) Main"},
    351266: {'name': 'Unholy Cathedral (E3M5) - Berserk',
             'episode': 3,
             'map': 5,
             'index': 126,
             'doom_type': 2023,
             'region': "Unholy Cathedral (E3M5) Main"},
    351267: {'name': 'Unholy Cathedral (E3M5) - Partial invisibility',
             'episode': 3,
             'map': 5,
             'index': 129,
             'doom_type': 2024,
             'region': "Unholy Cathedral (E3M5) Main"},
    351268: {'name': 'Unholy Cathedral (E3M5) - Chainsaw',
             'episode': 3,
             'map': 5,
             'index': 133,
             'doom_type': 2005,
             'region': "Unholy Cathedral (E3M5) Yellow"},
    351269: {'name': 'Unholy Cathedral (E3M5) - BFG9000',
             'episode': 3,
             'map': 5,
             'index': 180,
             'doom_type': 2006,
             'region': "Unholy Cathedral (E3M5) Blue"},
    351270: {'name': 'Unholy Cathedral (E3M5) - Shotgun',
             'episode': 3,
             'map': 5,
             'index': 187,
             'doom_type': 2001,
             'region': "Unholy Cathedral (E3M5) Start"},
    351271: {'name': 'Unholy Cathedral (E3M5) - Shotgun 2',
             'episode': 3,
             'map': 5,
             'index': 190,
             'doom_type': 2001,
             'region': "Unholy Cathedral (E3M5) Main"},
    351272: {'name': 'Unholy Cathedral (E3M5) - Rocket launcher',
             'episode': 3,
             'map': 5,
             'index': 218,
             'doom_type': 2003,
             'region': "Unholy Cathedral (E3M5) Main"},
    351273: {'name': 'Unholy Cathedral (E3M5) - Supercharge 2',
             'episode': 3,
             'map': 5,
             'index': 285,
             'doom_type': 2013,
             'region': "Unholy Cathedral (E3M5) Yellow"},
    351274: {'name': 'Mt. Erebus (E3M6) - Mega Armor',
             'episode': 3,
             'map': 6,
             'index': 38,
             'doom_type': 2019,
             'region': "Mt. Erebus (E3M6) Main"},
    351275: {'name': 'Mt. Erebus (E3M6) - Armor',
             'episode': 3,
             'map': 6,
             'index': 53,
             'doom_type': 2018,
             'region': "Mt. Erebus (E3M6) Main"},
    351276: {'name': 'Mt. Erebus (E3M6) - Backpack',
             'episode': 3,
             'map': 6,
             'index': 90,
             'doom_type': 8,
             'region': "Mt. Erebus (E3M6) Main"},
    351277: {'name': 'Mt. Erebus (E3M6) - Invulnerability',
             'episode': 3,
             'map': 6,
             'index': 100,
             'doom_type': 2022,
             'region': "Mt. Erebus (E3M6) Main"},
    351278: {'name': 'Mt. Erebus (E3M6) - Chaingun',
             'episode': 3,
             'map': 6,
             'index': 103,
             'doom_type': 2002,
             'region': "Mt. Erebus (E3M6) Main"},
    351279: {'name': 'Mt. Erebus (E3M6) - Shotgun',
             'episode': 3,
             'map': 6,
             'index': 104,
             'doom_type': 2001,
             'region': "Mt. Erebus (E3M6) Main"},
    351280: {'name': 'Mt. Erebus (E3M6) - Rocket launcher',
             'episode': 3,
             'map': 6,
             'index': 105,
             'doom_type': 2003,
             'region': "Mt. Erebus (E3M6) Main"},
    351281: {'name': 'Mt. Erebus (E3M6) - Plasma gun',
             'episode': 3,
             'map': 6,
             'index': 168,
             'doom_type': 2004,
             'region': "Mt. Erebus (E3M6) Main"},
    351282: {'name': 'Mt. Erebus (E3M6) - Armor 2',
             'episode': 3,
             'map': 6,
             'index': 180,
             'doom_type': 2018,
             'region': "Mt. Erebus (E3M6) Main"},
    351283: {'name': 'Mt. Erebus (E3M6) - Berserk',
             'episode': 3,
             'map': 6,
             'index': 206,
             'doom_type': 2023,
             'region': "Mt. Erebus (E3M6) Main"},
    351284: {'name': 'Mt. Erebus (E3M6) - Invulnerability 2',
             'episode': 3,
             'map': 6,
             'index': 207,
             'doom_type': 2022,
             'region': "Mt. Erebus (E3M6) Main"},
    351285: {'name': 'Mt. Erebus (E3M6) - Supercharge',
             'episode': 3,
             'map': 6,
             'index': 249,
             'doom_type': 2013,
             'region': "Mt. Erebus (E3M6) Main"},
    351286: {'name': 'Mt. Erebus (E3M6) - Blue skull key',
             'episode': 3,
             'map': 6,
             'index': 250,
             'doom_type': 40,
             'region': "Mt. Erebus (E3M6) Main"},
    351287: {'name': 'Mt. Erebus (E3M6) - Blue skull key 2',
             'episode': 3,
             'map': 6,
             'index': 251,
             'doom_type': 40,
             'region': "Mt. Erebus (E3M6) Main"},
    351288: {'name': 'Mt. Erebus (E3M6) - Computer area map',
             'episode': 3,
             'map': 6,
             'index': 267,
             'doom_type': 2026,
             'region': "Mt. Erebus (E3M6) Main"},
    351289: {'name': 'Mt. Erebus (E3M6) - Chainsaw',
             'episode': 3,
             'map': 6,
             'index': 273,
             'doom_type': 2005,
             'region': "Mt. Erebus (E3M6) Main"},
    351290: {'name': 'Mt. Erebus (E3M6) - Supercharge 2',
             'episode': 3,
             'map': 6,
             'index': 326,
             'doom_type': 2013,
             'region': "Mt. Erebus (E3M6) Main"},
    351291: {'name': 'Limbo (E3M7) - Blue skull key',
             'episode': 3,
             'map': 7,
             'index': 22,
             'doom_type': 40,
             'region': "Limbo (E3M7) Main"},
    351292: {'name': 'Limbo (E3M7) - Supercharge',
             'episode': 3,
             'map': 7,
             'index': 49,
             'doom_type': 2013,
             'region': "Limbo (E3M7) Main"},
    351293: {'name': 'Limbo (E3M7) - Rocket launcher',
             'episode': 3,
             'map': 7,
             'index': 51,
             'doom_type': 2003,
             'region': "Limbo (E3M7) Main"},
    351294: {'name': 'Limbo (E3M7) - Red skull key',
             'episode': 3,
             'map': 7,
             'index': 57,
             'doom_type': 38,
             'region': "Limbo (E3M7) Blue"},
    351295: {'name': 'Limbo (E3M7) - Backpack',
             'episode': 3,
             'map': 7,
             'index': 60,
             'doom_type': 8,
             'region': "Limbo (E3M7) Main"},
    351296: {'name': 'Limbo (E3M7) - Plasma gun',
             'episode': 3,
             'map': 7,
             'index': 65,
             'doom_type': 2004,
             'region': "Limbo (E3M7) Green"},
    351297: {'name': 'Limbo (E3M7) - Armor',
             'episode': 3,
             'map': 7,
             'index': 67,
             'doom_type': 2018,
             'region': "Limbo (E3M7) Green"},
    351298: {'name': 'Limbo (E3M7) - Yellow skull key',
             'episode': 3,
             'map': 7,
             'index': 69,
             'doom_type': 39,
             'region': "Limbo (E3M7) Red"},
    351299: {'name': 'Limbo (E3M7) - Armor 2',
             'episode': 3,
             'map': 7,
             'index': 83,
             'doom_type': 2018,
             'region': "Limbo (E3M7) Main"},
    351300: {'name': 'Limbo (E3M7) - Mega Armor',
             'episode': 3,
             'map': 7,
             'index': 112,
             'doom_type': 2019,
             'region': "Limbo (E3M7) Main"},
    351301: {'name': 'Limbo (E3M7) - BFG9000',
             'episode': 3,
             'map': 7,
             'index': 128,
             'doom_type': 2006,
             'region': "Limbo (E3M7) Blue"},
    351302: {'name': 'Dis (E3M8) - Rocket launcher',
             'episode': 3,
             'map': 8,
             'index': 7,
             'doom_type': 2003,
             'region': "Dis (E3M8) Main"},
    351303: {'name': 'Dis (E3M8) - Plasma gun',
             'episode': 3,
             'map': 8,
             'index': 8,
             'doom_type': 2004,
             'region': "Dis (E3M8) Main"},
    351304: {'name': 'Dis (E3M8) - Mega Armor',
             'episode': 3,
             'map': 8,
             'index': 34,
             'doom_type': 2019,
             'region': "Dis (E3M8) Main"},
    351305: {'name': 'Warrens (E3M9) - Shotgun',
             'episode': 3,
             'map': 9,
             'index': 20,
             'doom_type': 2001,
             'region': "Warrens (E3M9) Main"},
    351306: {'name': 'Warrens (E3M9) - Rocket launcher',
             'episode': 3,
             'map': 9,
             'index': 46,
             'doom_type': 2003,
             'region': "Warrens (E3M9) Blue"},
    351307: {'name': 'Warrens (E3M9) - Rocket launcher 2',
             'episode': 3,
             'map': 9,
             'index': 99,
             'doom_type': 2003,
             'region': "Warrens (E3M9) Blue"},
    351308: {'name': 'Warrens (E3M9) - Supercharge',
             'episode': 3,
             'map': 9,
             'index': 101,
             'doom_type': 2013,
             'region': "Warrens (E3M9) Blue"},
    351309: {'name': 'Warrens (E3M9) - Blue skull key',
             'episode': 3,
             'map': 9,
             'index': 108,
             'doom_type': 40,
             'region': "Warrens (E3M9) Blue"},
    351310: {'name': 'Warrens (E3M9) - Berserk',
             'episode': 3,
             'map': 9,
             'index': 114,
             'doom_type': 2023,
             'region': "Warrens (E3M9) Blue"},
    351311: {'name': 'Warrens (E3M9) - Invulnerability',
             'episode': 3,
             'map': 9,
             'index': 120,
             'doom_type': 2022,
             'region': "Warrens (E3M9) Blue"},
    351312: {'name': 'Warrens (E3M9) - Partial invisibility',
             'episode': 3,
             'map': 9,
             'index': 121,
             'doom_type': 2024,
             'region': "Warrens (E3M9) Blue"},
    351313: {'name': 'Warrens (E3M9) - Chaingun',
             'episode': 3,
             'map': 9,
             'index': 122,
             'doom_type': 2002,
             'region': "Warrens (E3M9) Blue"},
    351314: {'name': 'Warrens (E3M9) - Plasma gun',
             'episode': 3,
             'map': 9,
             'index': 135,
             'doom_type': 2004,
             'region': "Warrens (E3M9) Blue trigger"},
    351315: {'name': 'Warrens (E3M9) - Invulnerability 2',
             'episode': 3,
             'map': 9,
             'index': 138,
             'doom_type': 2022,
             'region': "Warrens (E3M9) Blue trigger"},
    351316: {'name': 'Warrens (E3M9) - Armor',
             'episode': 3,
             'map': 9,
             'index': 139,
             'doom_type': 2018,
             'region': "Warrens (E3M9) Blue trigger"},
    351317: {'name': 'Warrens (E3M9) - Chainsaw',
             'episode': 3,
             'map': 9,
             'index': 140,
             'doom_type': 2005,
             'region': "Warrens (E3M9) Blue trigger"},
    351318: {'name': 'Warrens (E3M9) - BFG9000',
             'episode': 3,
             'map': 9,
             'index': 141,
             'doom_type': 2006,
             'region': "Warrens (E3M9) Blue trigger"},
    351319: {'name': 'Warrens (E3M9) - Red skull key',
             'episode': 3,
             'map': 9,
             'index': 143,
             'doom_type': 38,
             'region': "Warrens (E3M9) Blue trigger"},
    351320: {'name': 'Warrens (E3M9) - Supercharge 2',
             'episode': 3,
             'map': 9,
             'index': 188,
             'doom_type': 2013,
             'region': "Warrens (E3M9) Blue trigger"},
    351321: {'name': 'Central Processing (E1M6) - Exit',
             'episode': 1,
             'map': 6,
             'index': -1,
             'doom_type': -1,
             'region': "Central Processing (E1M6) Yellow"},
    351322: {'name': 'Command Center (E2M5) - Exit',
             'episode': 2,
             'map': 5,
             'index': -1,
             'doom_type': -1,
             'region': "Command Center (E2M5) Main"},
    351323: {'name': 'Command Control (E1M4) - Exit',
             'episode': 1,
             'map': 4,
             'index': -1,
             'doom_type': -1,
             'region': "Command Control (E1M4) Yellow"},
    351324: {'name': 'Computer Station (E1M7) - Exit',
             'episode': 1,
             'map': 7,
             'index': -1,
             'doom_type': -1,
             'region': "Computer Station (E1M7) Blue"},
    351325: {'name': 'Containment Area (E2M2) - Exit',
             'episode': 2,
             'map': 2,
             'index': -1,
             'doom_type': -1,
             'region': "Containment Area (E2M2) Red Exit"},
    351326: {'name': 'Deimos Anomaly (E2M1) - Exit',
             'episode': 2,
             'map': 1,
             'index': -1,
             'doom_type': -1,
             'region': "Deimos Anomaly (E2M1) Blue"},
    351327: {'name': 'Deimos Lab (E2M4) - Exit',
             'episode': 2,
             'map': 4,
             'index': -1,
             'doom_type': -1,
             'region': "Deimos Lab (E2M4) Yellow"},
    351328: {'name': 'Dis (E3M8) - Exit',
             'episode': 3,
             'map': 8,
             'index': -1,
             'doom_type': -1,
             'region': "Dis (E3M8) Main"},
    351329: {'name': 'Fortress of Mystery (E2M9) - Exit',
             'episode': 2,
             'map': 9,
             'index': -1,
             'doom_type': -1,
             'region': "Fortress of Mystery (E2M9) Yellow"},
    351330: {'name': 'Halls of the Damned (E2M6) - Exit',
             'episode': 2,
             'map': 6,
             'index': -1,
             'doom_type': -1,
             'region': "Halls of the Damned (E2M6) Blue Yellow Red"},
    351331: {'name': 'Hangar (E1M1) - Exit',
             'episode': 1,
             'map': 1,
             'index': -1,
             'doom_type': -1,
             'region': "Hangar (E1M1) Main"},
    351332: {'name': 'Hell Keep (E3M1) - Exit',
             'episode': 3,
             'map': 1,
             'index': -1,
             'doom_type': -1,
             'region': "Hell Keep (E3M1) Narrow"},
    351333: {'name': 'House of Pain (E3M4) - Exit',
             'episode': 3,
             'map': 4,
             'index': -1,
             'doom_type': -1,
             'region': "House of Pain (E3M4) Red"},
    351334: {'name': 'Limbo (E3M7) - Exit',
             'episode': 3,
             'map': 7,
             'index': -1,
             'doom_type': -1,
             'region': "Limbo (E3M7) Yellow"},
    351335: {'name': 'Military Base (E1M9) - Exit',
             'episode': 1,
             'map': 9,
             'index': -1,
             'doom_type': -1,
             'region': "Military Base (E1M9) Blue"},
    351336: {'name': 'Mt. Erebus (E3M6) - Exit',
             'episode': 3,
             'map': 6,
             'index': -1,
             'doom_type': -1,
             'region': "Mt. Erebus (E3M6) Blue"},
    351337: {'name': 'Nuclear Plant (E1M2) - Exit',
             'episode': 1,
             'map': 2,
             'index': -1,
             'doom_type': -1,
             'region': "Nuclear Plant (E1M2) Red"},
    351338: {'name': 'Pandemonium (E3M3) - Exit',
             'episode': 3,
             'map': 3,
             'index': -1,
             'doom_type': -1,
             'region': "Pandemonium (E3M3) Blue"},
    351339: {'name': 'Phobos Anomaly (E1M8) - Exit',
             'episode': 1,
             'map': 8,
             'index': -1,
             'doom_type': -1,
             'region': "Phobos Anomaly (E1M8) Main"},
    351340: {'name': 'Phobos Lab (E1M5) - Exit',
             'episode': 1,
             'map': 5,
             'index': -1,
             'doom_type': -1,
             'region': "Phobos Lab (E1M5) Blue"},
    351341: {'name': 'Refinery (E2M3) - Exit',
             'episode': 2,
             'map': 3,
             'index': -1,
             'doom_type': -1,
             'region': "Refinery (E2M3) Blue"},
    351342: {'name': 'Slough of Despair (E3M2) - Exit',
             'episode': 3,
             'map': 2,
             'index': -1,
             'doom_type': -1,
             'region': "Slough of Despair (E3M2) Blue"},
    351343: {'name': 'Spawning Vats (E2M7) - Exit',
             'episode': 2,
             'map': 7,
             'index': -1,
             'doom_type': -1,
             'region': "Spawning Vats (E2M7) Red"},
    351344: {'name': 'Tower of Babel (E2M8) - Exit',
             'episode': 2,
             'map': 8,
             'index': -1,
             'doom_type': -1,
             'region': "Tower of Babel (E2M8) Main"},
    351345: {'name': 'Toxin Refinery (E1M3) - Exit',
             'episode': 1,
             'map': 3,
             'index': -1,
             'doom_type': -1,
             'region': "Toxin Refinery (E1M3) Blue"},
    351346: {'name': 'Unholy Cathedral (E3M5) - Exit',
             'episode': 3,
             'map': 5,
             'index': -1,
             'doom_type': -1,
             'region': "Unholy Cathedral (E3M5) Blue"},
    351347: {'name': 'Warrens (E3M9) - Exit',
             'episode': 3,
             'map': 9,
             'index': -1,
             'doom_type': -1,
             'region': "Warrens (E3M9) Red"},
    351348: {'name': 'Hell Beneath (E4M1) - Red skull key',
             'episode': 4,
             'map': 1,
             'index': 6,
             'doom_type': 38,
             'region': "Hell Beneath (E4M1) Main"},
    351349: {'name': 'Hell Beneath (E4M1) - Rocket launcher',
             'episode': 4,
             'map': 1,
             'index': 23,
             'doom_type': 2003,
             'region': "Hell Beneath (E4M1) Main"},
    351350: {'name': 'Hell Beneath (E4M1) - Blue skull key',
             'episode': 4,
             'map': 1,
             'index': 33,
             'doom_type': 40,
             'region': "Hell Beneath (E4M1) Red"},
    351351: {'name': 'Hell Beneath (E4M1) - Shotgun',
             'episode': 4,
             'map': 1,
             'index': 47,
             'doom_type': 2001,
             'region': "Hell Beneath (E4M1) Main"},
    351352: {'name': 'Hell Beneath (E4M1) - Armor',
             'episode': 4,
             'map': 1,
             'index': 90,
             'doom_type': 2018,
             'region': "Hell Beneath (E4M1) Main"},
    351353: {'name': 'Hell Beneath (E4M1) - Chaingun',
             'episode': 4,
             'map': 1,
             'index': 97,
             'doom_type': 2002,
             'region': "Hell Beneath (E4M1) Main"},
    351354: {'name': 'Hell Beneath (E4M1) - Exit',
             'episode': 4,
             'map': 1,
             'index': -1,
             'doom_type': -1,
             'region': "Hell Beneath (E4M1) Blue"},
    351355: {'name': 'Perfect Hatred (E4M2) - Plasma gun',
             'episode': 4,
             'map': 2,
             'index': 5,
             'doom_type': 2004,
             'region': "Perfect Hatred (E4M2) Main"},
    351356: {'name': 'Perfect Hatred (E4M2) - Shotgun',
             'episode': 4,
             'map': 2,
             'index': 10,
             'doom_type': 2001,
             'region': "Perfect Hatred (E4M2) Main"},
    351357: {'name': 'Perfect Hatred (E4M2) - Berserk',
             'episode': 4,
             'map': 2,
             'index': 14,
             'doom_type': 2023,
             'region': "Perfect Hatred (E4M2) Main"},
    351358: {'name': 'Perfect Hatred (E4M2) - Supercharge',
             'episode': 4,
             'map': 2,
             'index': 17,
             'doom_type': 2013,
             'region': "Perfect Hatred (E4M2) Main"},
    351359: {'name': 'Perfect Hatred (E4M2) - Mega Armor',
             'episode': 4,
             'map': 2,
             'index': 20,
             'doom_type': 2019,
             'region': "Perfect Hatred (E4M2) Main"},
    351360: {'name': 'Perfect Hatred (E4M2) - Yellow skull key',
             'episode': 4,
             'map': 2,
             'index': 29,
             'doom_type': 39,
             'region': "Perfect Hatred (E4M2) Main"},
    351361: {'name': 'Perfect Hatred (E4M2) - Armor',
             'episode': 4,
             'map': 2,
             'index': 46,
             'doom_type': 2018,
             'region': "Perfect Hatred (E4M2) Main"},
    351362: {'name': 'Perfect Hatred (E4M2) - Rocket launcher',
             'episode': 4,
             'map': 2,
             'index': 93,
             'doom_type': 2003,
             'region': "Perfect Hatred (E4M2) Yellow"},
    351363: {'name': 'Perfect Hatred (E4M2) - Chainsaw',
             'episode': 4,
             'map': 2,
             'index': 126,
             'doom_type': 2005,
             'region': "Perfect Hatred (E4M2) Cave"},
    351364: {'name': 'Perfect Hatred (E4M2) - Armor 2',
             'episode': 4,
             'map': 2,
             'index': 151,
             'doom_type': 2018,
             'region': "Perfect Hatred (E4M2) Cave"},
    351365: {'name': 'Perfect Hatred (E4M2) - Blue skull key',
             'episode': 4,
             'map': 2,
             'index': 167,
             'doom_type': 40,
             'region': "Perfect Hatred (E4M2) Cave"},
    351366: {'name': 'Perfect Hatred (E4M2) - BFG9000',
             'episode': 4,
             'map': 2,
             'index': 217,
             'doom_type': 2006,
             'region': "Perfect Hatred (E4M2) Upper"},
    351367: {'name': 'Perfect Hatred (E4M2) - Exit',
             'episode': 4,
             'map': 2,
             'index': -1,
             'doom_type': -1,
             'region': "Perfect Hatred (E4M2) Upper"},
    351368: {'name': 'Sever the Wicked (E4M3) - Invulnerability',
             'episode': 4,
             'map': 3,
             'index': 9,
             'doom_type': 2022,
             'region': "Sever the Wicked (E4M3) Main"},
    351369: {'name': 'Sever the Wicked (E4M3) - Berserk',
             'episode': 4,
             'map': 3,
             'index': 21,
             'doom_type': 2023,
             'region': "Sever the Wicked (E4M3) Main"},
    351370: {'name': 'Sever the Wicked (E4M3) - Partial invisibility',
             'episode': 4,
             'map': 3,
             'index': 22,
             'doom_type': 2024,
             'region': "Sever the Wicked (E4M3) Main"},
    351371: {'name': 'Sever the Wicked (E4M3) - Backpack',
             'episode': 4,
             'map': 3,
             'index': 23,
             'doom_type': 8,
             'region': "Sever the Wicked (E4M3) Main"},
    351372: {'name': 'Sever the Wicked (E4M3) - Plasma gun',
             'episode': 4,
             'map': 3,
             'index': 25,
             'doom_type': 2004,
             'region': "Sever the Wicked (E4M3) Blue"},
    351373: {'name': 'Sever the Wicked (E4M3) - Red skull key',
             'episode': 4,
             'map': 3,
             'index': 27,
             'doom_type': 38,
             'region': "Sever the Wicked (E4M3) Main"},
    351374: {'name': 'Sever the Wicked (E4M3) - Blue skull key',
             'episode': 4,
             'map': 3,
             'index': 28,
             'doom_type': 40,
             'region': "Sever the Wicked (E4M3) Main"},
    351375: {'name': 'Sever the Wicked (E4M3) - Backpack 2',
             'episode': 4,
             'map': 3,
             'index': 29,
             'doom_type': 8,
             'region': "Sever the Wicked (E4M3) Main"},
    351376: {'name': 'Sever the Wicked (E4M3) - Chainsaw',
             'episode': 4,
             'map': 3,
             'index': 38,
             'doom_type': 2005,
             'region': "Sever the Wicked (E4M3) Main"},
    351377: {'name': 'Sever the Wicked (E4M3) - Mega Armor',
             'episode': 4,
             'map': 3,
             'index': 39,
             'doom_type': 2019,
             'region': "Sever the Wicked (E4M3) Main"},
    351378: {'name': 'Sever the Wicked (E4M3) - Supercharge',
             'episode': 4,
             'map': 3,
             'index': 94,
             'doom_type': 2013,
             'region': "Sever the Wicked (E4M3) Main"},
    351379: {'name': 'Sever the Wicked (E4M3) - Plasma gun 2',
             'episode': 4,
             'map': 3,
             'index': 157,
             'doom_type': 2004,
             'region': "Sever the Wicked (E4M3) Main"},
    351380: {'name': 'Sever the Wicked (E4M3) - Chaingun',
             'episode': 4,
             'map': 3,
             'index': 178,
             'doom_type': 2002,
             'region': "Sever the Wicked (E4M3) Main"},
    351381: {'name': 'Sever the Wicked (E4M3) - Shotgun',
             'episode': 4,
             'map': 3,
             'index': 254,
             'doom_type': 2001,
             'region': "Sever the Wicked (E4M3) Main"},
    351382: {'name': 'Sever the Wicked (E4M3) - Rocket launcher',
             'episode': 4,
             'map': 3,
             'index': 299,
             'doom_type': 2003,
             'region': "Sever the Wicked (E4M3) Main"},
    351383: {'name': 'Sever the Wicked (E4M3) - Partial invisibility 2',
             'episode': 4,
             'map': 3,
             'index': 304,
             'doom_type': 2024,
             'region': "Sever the Wicked (E4M3) Main"},
    351384: {'name': 'Sever the Wicked (E4M3) - Exit',
             'episode': 4,
             'map': 3,
             'index': -1,
             'doom_type': -1,
             'region': "Sever the Wicked (E4M3) Blue"},
    351385: {'name': 'Unruly Evil (E4M4) - Rocket launcher',
             'episode': 4,
             'map': 4,
             'index': 9,
             'doom_type': 2003,
             'region': "Unruly Evil (E4M4) Main"},
    351386: {'name': 'Unruly Evil (E4M4) - Berserk',
             'episode': 4,
             'map': 4,
             'index': 15,
             'doom_type': 2023,
             'region': "Unruly Evil (E4M4) Main"},
    351387: {'name': 'Unruly Evil (E4M4) - Red skull key',
             'episode': 4,
             'map': 4,
             'index': 16,
             'doom_type': 38,
             'region': "Unruly Evil (E4M4) Main"},
    351388: {'name': 'Unruly Evil (E4M4) - Chaingun',
             'episode': 4,
             'map': 4,
             'index': 56,
             'doom_type': 2002,
             'region': "Unruly Evil (E4M4) Main"},
    351389: {'name': 'Unruly Evil (E4M4) - Shotgun',
             'episode': 4,
             'map': 4,
             'index': 61,
             'doom_type': 2001,
             'region': "Unruly Evil (E4M4) Main"},
    351390: {'name': 'Unruly Evil (E4M4) - Partial invisibility',
             'episode': 4,
             'map': 4,
             'index': 68,
             'doom_type': 2024,
             'region': "Unruly Evil (E4M4) Main"},
    351391: {'name': 'Unruly Evil (E4M4) - Invulnerability',
             'episode': 4,
             'map': 4,
             'index': 115,
             'doom_type': 2022,
             'region': "Unruly Evil (E4M4) Main"},
    351392: {'name': 'Unruly Evil (E4M4) - Supercharge',
             'episode': 4,
             'map': 4,
             'index': 116,
             'doom_type': 2013,
             'region': "Unruly Evil (E4M4) Main"},
    351393: {'name': 'Unruly Evil (E4M4) - Exit',
             'episode': 4,
             'map': 4,
             'index': -1,
             'doom_type': -1,
             'region': "Unruly Evil (E4M4) Red"},
    351394: {'name': 'They Will Repent (E4M5) - Yellow skull key',
             'episode': 4,
             'map': 5,
             'index': 17,
             'doom_type': 39,
             'region': "They Will Repent (E4M5) Red"},
    351395: {'name': 'They Will Repent (E4M5) - Red skull key',
             'episode': 4,
             'map': 5,
             'index': 20,
             'doom_type': 38,
             'region': "They Will Repent (E4M5) Main"},
    351396: {'name': 'They Will Repent (E4M5) - Blue skull key',
             'episode': 4,
             'map': 5,
             'index': 21,
             'doom_type': 40,
             'region': "They Will Repent (E4M5) Red"},
    351397: {'name': 'They Will Repent (E4M5) - BFG9000',
             'episode': 4,
             'map': 5,
             'index': 31,
             'doom_type': 2006,
             'region': "They Will Repent (E4M5) Red"},
    351398: {'name': 'They Will Repent (E4M5) - Chaingun',
             'episode': 4,
             'map': 5,
             'index': 137,
             'doom_type': 2002,
             'region': "They Will Repent (E4M5) Main"},
    351399: {'name': 'They Will Repent (E4M5) - Rocket launcher',
             'episode': 4,
             'map': 5,
             'index': 140,
             'doom_type': 2003,
             'region': "They Will Repent (E4M5) Main"},
    351400: {'name': 'They Will Repent (E4M5) - Armor',
             'episode': 4,
             'map': 5,
             'index': 155,
             'doom_type': 2018,
             'region': "They Will Repent (E4M5) Main"},
    351401: {'name': 'They Will Repent (E4M5) - Plasma gun',
             'episode': 4,
             'map': 5,
             'index': 177,
             'doom_type': 2004,
             'region': "They Will Repent (E4M5) Red"},
    351402: {'name': 'They Will Repent (E4M5) - Supercharge',
             'episode': 4,
             'map': 5,
             'index': 193,
             'doom_type': 2013,
             'region': "They Will Repent (E4M5) Red"},
    351403: {'name': 'They Will Repent (E4M5) - Invulnerability',
             'episode': 4,
             'map': 5,
             'index': 199,
             'doom_type': 2022,
             'region': "They Will Repent (E4M5) Red"},
    351404: {'name': 'They Will Repent (E4M5) - Berserk',
             'episode': 4,
             'map': 5,
             'index': 256,
             'doom_type': 2023,
             'region': "They Will Repent (E4M5) Red"},
    351405: {'name': 'They Will Repent (E4M5) - Exit',
             'episode': 4,
             'map': 5,
             'index': -1,
             'doom_type': -1,
             'region': "They Will Repent (E4M5) Red"},
    351406: {'name': 'Against Thee Wickedly (E4M6) - Plasma gun',
             'episode': 4,
             'map': 6,
             'index': 30,
             'doom_type': 2004,
             'region': "Against Thee Wickedly (E4M6) Main"},
    351407: {'name': 'Against Thee Wickedly (E4M6) - Blue skull key',
             'episode': 4,
             'map': 6,
             'index': 39,
             'doom_type': 40,
             'region': "Against Thee Wickedly (E4M6) Main"},
    351408: {'name': 'Against Thee Wickedly (E4M6) - Yellow skull key',
             'episode': 4,
             'map': 6,
             'index': 47,
             'doom_type': 39,
             'region': "Against Thee Wickedly (E4M6) Blue"},
    351409: {'name': 'Against Thee Wickedly (E4M6) - Supercharge',
             'episode': 4,
             'map': 6,
             'index': 48,
             'doom_type': 2013,
             'region': "Against Thee Wickedly (E4M6) Main"},
    351410: {'name': 'Against Thee Wickedly (E4M6) - Rocket launcher',
             'episode': 4,
             'map': 6,
             'index': 49,
             'doom_type': 2003,
             'region': "Against Thee Wickedly (E4M6) Main"},
    351411: {'name': 'Against Thee Wickedly (E4M6) - Chaingun',
             'episode': 4,
             'map': 6,
             'index': 54,
             'doom_type': 2002,
             'region': "Against Thee Wickedly (E4M6) Main"},
    351412: {'name': 'Against Thee Wickedly (E4M6) - Partial invisibility',
             'episode': 4,
             'map': 6,
             'index': 56,
             'doom_type': 2024,
             'region': "Against Thee Wickedly (E4M6) Main"},
    351413: {'name': 'Against Thee Wickedly (E4M6) - Red skull key',
             'episode': 4,
             'map': 6,
             'index': 77,
             'doom_type': 38,
             'region': "Against Thee Wickedly (E4M6) Magenta"},
    351414: {'name': 'Against Thee Wickedly (E4M6) - Invulnerability',
             'episode': 4,
             'map': 6,
             'index': 78,
             'doom_type': 2022,
             'region': "Against Thee Wickedly (E4M6) Pink"},
    351415: {'name': 'Against Thee Wickedly (E4M6) - Invulnerability 2',
             'episode': 4,
             'map': 6,
             'index': 89,
             'doom_type': 2022,
             'region': "Against Thee Wickedly (E4M6) Magenta"},
    351416: {'name': 'Against Thee Wickedly (E4M6) - BFG9000',
             'episode': 4,
             'map': 6,
             'index': 99,
             'doom_type': 2006,
             'region': "Against Thee Wickedly (E4M6) Red"},
    351417: {'name': 'Against Thee Wickedly (E4M6) - Backpack',
             'episode': 4,
             'map': 6,
             'index': 102,
             'doom_type': 8,
             'region': "Against Thee Wickedly (E4M6) Pink"},
    351418: {'name': 'Against Thee Wickedly (E4M6) - Berserk',
             'episode': 4,
             'map': 6,
             'index': 256,
             'doom_type': 2023,
             'region': "Against Thee Wickedly (E4M6) Red"},
    351419: {'name': 'Against Thee Wickedly (E4M6) - Shotgun',
             'episode': 4,
             'map': 6,
             'index': 278,
             'doom_type': 2001,
             'region': "Against Thee Wickedly (E4M6) Main"},
    351420: {'name': 'Against Thee Wickedly (E4M6) - Armor',
             'episode': 4,
             'map': 6,
             'index': 292,
             'doom_type': 2018,
             'region': "Against Thee Wickedly (E4M6) Main"},
    351421: {'name': 'Against Thee Wickedly (E4M6) - Mega Armor',
             'episode': 4,
             'map': 6,
             'index': 293,
             'doom_type': 2019,
             'region': "Against Thee Wickedly (E4M6) Main"},
    351422: {'name': 'Against Thee Wickedly (E4M6) - Exit',
             'episode': 4,
             'map': 6,
             'index': -1,
             'doom_type': -1,
             'region': "Against Thee Wickedly (E4M6) Magenta"},
    351423: {'name': 'And Hell Followed (E4M7) - Shotgun',
             'episode': 4,
             'map': 7,
             'index': 1,
             'doom_type': 2001,
             'region': "And Hell Followed (E4M7) Main"},
    351424: {'name': 'And Hell Followed (E4M7) - Chaingun',
             'episode': 4,
             'map': 7,
             'index': 33,
             'doom_type': 2002,
             'region': "And Hell Followed (E4M7) Main"},
    351425: {'name': 'And Hell Followed (E4M7) - Rocket launcher',
             'episode': 4,
             'map': 7,
             'index': 58,
             'doom_type': 2003,
             'region': "And Hell Followed (E4M7) Main"},
    351426: {'name': 'And Hell Followed (E4M7) - Plasma gun',
             'episode': 4,
             'map': 7,
             'index': 61,
             'doom_type': 2004,
             'region': "And Hell Followed (E4M7) Red"},
    351427: {'name': 'And Hell Followed (E4M7) - Backpack',
             'episode': 4,
             'map': 7,
             'index': 76,
             'doom_type': 8,
             'region': "And Hell Followed (E4M7) Main"},
    351428: {'name': 'And Hell Followed (E4M7) - Supercharge',
             'episode': 4,
             'map': 7,
             'index': 77,
             'doom_type': 2013,
             'region': "And Hell Followed (E4M7) Main"},
    351429: {'name': 'And Hell Followed (E4M7) - Blue skull key',
             'episode': 4,
             'map': 7,
             'index': 87,
             'doom_type': 40,
             'region': "And Hell Followed (E4M7) Main"},
    351430: {'name': 'And Hell Followed (E4M7) - Partial invisibility',
             'episode': 4,
             'map': 7,
             'index': 122,
             'doom_type': 2024,
             'region': "And Hell Followed (E4M7) Main"},
    351431: {'name': 'And Hell Followed (E4M7) - Mega Armor',
             'episode': 4,
             'map': 7,
             'index': 156,
             'doom_type': 2019,
             'region': "And Hell Followed (E4M7) Main"},
    351432: {'name': 'And Hell Followed (E4M7) - Armor',
             'episode': 4,
             'map': 7,
             'index': 172,
             'doom_type': 2018,
             'region': "And Hell Followed (E4M7) Main"},
    351433: {'name': 'And Hell Followed (E4M7) - Computer area map',
             'episode': 4,
             'map': 7,
             'index': 173,
             'doom_type': 2026,
             'region': "And Hell Followed (E4M7) Main"},
    351434: {'name': 'And Hell Followed (E4M7) - Berserk',
             'episode': 4,
             'map': 7,
             'index': 174,
             'doom_type': 2023,
             'region': "And Hell Followed (E4M7) Main"},
    351435: {'name': 'And Hell Followed (E4M7) - Yellow skull key',
             'episode': 4,
             'map': 7,
             'index': 182,
             'doom_type': 39,
             'region': "And Hell Followed (E4M7) Blue"},
    351436: {'name': 'And Hell Followed (E4M7) - Red skull key',
             'episode': 4,
             'map': 7,
             'index': 186,
             'doom_type': 38,
             'region': "And Hell Followed (E4M7) Main"},
    351437: {'name': 'And Hell Followed (E4M7) - Chainsaw',
             'episode': 4,
             'map': 7,
             'index': 190,
             'doom_type': 2005,
             'region': "And Hell Followed (E4M7) Main"},
    351438: {'name': 'And Hell Followed (E4M7) - BFG9000',
             'episode': 4,
             'map': 7,
             'index': 196,
             'doom_type': 2006,
             'region': "And Hell Followed (E4M7) Yellow"},
    351439: {'name': 'And Hell Followed (E4M7) - Mega Armor 2',
             'episode': 4,
             'map': 7,
             'index': 217,
             'doom_type': 2019,
             'region': "And Hell Followed (E4M7) Yellow"},
    351440: {'name': 'And Hell Followed (E4M7) - Invulnerability',
             'episode': 4,
             'map': 7,
             'index': 235,
             'doom_type': 2022,
             'region': "And Hell Followed (E4M7) Yellow"},
    351441: {'name': 'And Hell Followed (E4M7) - Invulnerability 2',
             'episode': 4,
             'map': 7,
             'index': 236,
             'doom_type': 2022,
             'region': "And Hell Followed (E4M7) Yellow"},
    351442: {'name': 'And Hell Followed (E4M7) - Supercharge 2',
             'episode': 4,
             'map': 7,
             'index': 237,
             'doom_type': 2013,
             'region': "And Hell Followed (E4M7) Yellow"},
    351443: {'name': 'And Hell Followed (E4M7) - Rocket launcher 2',
             'episode': 4,
             'map': 7,
             'index': 243,
             'doom_type': 2003,
             'region': "And Hell Followed (E4M7) Yellow"},
    351444: {'name': 'And Hell Followed (E4M7) - Rocket launcher 3',
             'episode': 4,
             'map': 7,
             'index': 248,
             'doom_type': 2003,
             'region': "And Hell Followed (E4M7) Red"},
    351445: {'name': 'And Hell Followed (E4M7) - Exit',
             'episode': 4,
             'map': 7,
             'index': -1,
             'doom_type': -1,
             'region': "And Hell Followed (E4M7) Red"},
    351446: {'name': 'Unto the Cruel (E4M8) - Shotgun',
             'episode': 4,
             'map': 8,
             'index': 80,
             'doom_type': 2001,
             'region': "Unto the Cruel (E4M8) Main"},
    351447: {'name': 'Unto the Cruel (E4M8) - Supercharge',
             'episode': 4,
             'map': 8,
             'index': 81,
             'doom_type': 2013,
             'region': "Unto the Cruel (E4M8) Main"},
    351448: {'name': 'Unto the Cruel (E4M8) - Rocket launcher',
             'episode': 4,
             'map': 8,
             'index': 85,
             'doom_type': 2003,
             'region': "Unto the Cruel (E4M8) Main"},
    351449: {'name': 'Unto the Cruel (E4M8) - Mega Armor',
             'episode': 4,
             'map': 8,
             'index': 100,
             'doom_type': 2019,
             'region': "Unto the Cruel (E4M8) Orange"},
    351450: {'name': 'Unto the Cruel (E4M8) - Supercharge 2',
             'episode': 4,
             'map': 8,
             'index': 101,
             'doom_type': 2013,
             'region': "Unto the Cruel (E4M8) Orange"},
    351451: {'name': 'Unto the Cruel (E4M8) - Mega Armor 2',
             'episode': 4,
             'map': 8,
             'index': 102,
             'doom_type': 2019,
             'region': "Unto the Cruel (E4M8) Main"},
    351452: {'name': 'Unto the Cruel (E4M8) - Yellow skull key',
             'episode': 4,
             'map': 8,
             'index': 146,
             'doom_type': 39,
             'region': "Unto the Cruel (E4M8) Main"},
    351453: {'name': 'Unto the Cruel (E4M8) - Berserk',
             'episode': 4,
             'map': 8,
             'index': 148,
             'doom_type': 2023,
             'region': "Unto the Cruel (E4M8) Main"},
    351454: {'name': 'Unto the Cruel (E4M8) - BFG9000',
             'episode': 4,
             'map': 8,
             'index': 180,
             'doom_type': 2006,
             'region': "Unto the Cruel (E4M8) Orange"},
    351455: {'name': 'Unto the Cruel (E4M8) - Rocket launcher 2',
             'episode': 4,
             'map': 8,
             'index': 186,
             'doom_type': 2003,
             'region': "Unto the Cruel (E4M8) Orange"},
    351456: {'name': 'Unto the Cruel (E4M8) - Plasma gun',
             'episode': 4,
             'map': 8,
             'index': 187,
             'doom_type': 2004,
             'region': "Unto the Cruel (E4M8) Orange"},
    351457: {'name': 'Unto the Cruel (E4M8) - Red skull key',
             'episode': 4,
             'map': 8,
             'index': 192,
             'doom_type': 38,
             'region': "Unto the Cruel (E4M8) Main"},
    351458: {'name': 'Unto the Cruel (E4M8) - Chaingun',
             'episode': 4,
             'map': 8,
             'index': 292,
             'doom_type': 2002,
             'region': "Unto the Cruel (E4M8) Main"},
    351459: {'name': 'Unto the Cruel (E4M8) - Supercharge 3',
             'episode': 4,
             'map': 8,
             'index': 304,
             'doom_type': 2013,
             'region': "Unto the Cruel (E4M8) Main"},
    351460: {'name': 'Unto the Cruel (E4M8) - Partial invisibility',
             'episode': 4,
             'map': 8,
             'index': 310,
             'doom_type': 2024,
             'region': "Unto the Cruel (E4M8) Main"},
    351461: {'name': 'Unto the Cruel (E4M8) - Backpack',
             'episode': 4,
             'map': 8,
             'index': 311,
             'doom_type': 8,
             'region': "Unto the Cruel (E4M8) Main"},
    351462: {'name': 'Unto the Cruel (E4M8) - Plasma gun 2',
             'episode': 4,
             'map': 8,
             'index': 312,
             'doom_type': 2004,
             'region': "Unto the Cruel (E4M8) Main"},
    351463: {'name': 'Unto the Cruel (E4M8) - Exit',
             'episode': 4,
             'map': 8,
             'index': -1,
             'doom_type': -1,
             'region': "Unto the Cruel (E4M8) Orange"},
    351464: {'name': 'Fear (E4M9) - Yellow skull key',
             'episode': 4,
             'map': 9,
             'index': 6,
             'doom_type': 39,
             'region': "Fear (E4M9) Main"},
    351465: {'name': 'Fear (E4M9) - Shotgun',
             'episode': 4,
             'map': 9,
             'index': 37,
             'doom_type': 2001,
             'region': "Fear (E4M9) Main"},
    351466: {'name': 'Fear (E4M9) - Mega Armor',
             'episode': 4,
             'map': 9,
             'index': 40,
             'doom_type': 2019,
             'region': "Fear (E4M9) Main"},
    351467: {'name': 'Fear (E4M9) - Rocket launcher',
             'episode': 4,
             'map': 9,
             'index': 119,
             'doom_type': 2003,
             'region': "Fear (E4M9) Main"},
    351468: {'name': 'Fear (E4M9) - Rocket launcher 2',
             'episode': 4,
             'map': 9,
             'index': 149,
             'doom_type': 2003,
             'region': "Fear (E4M9) Main"},
    351469: {'name': 'Fear (E4M9) - Backpack',
             'episode': 4,
             'map': 9,
             'index': 151,
             'doom_type': 8,
             'region': "Fear (E4M9) Yellow"},
    351470: {'name': 'Fear (E4M9) - Plasma gun',
             'episode': 4,
             'map': 9,
             'index': 220,
             'doom_type': 2004,
             'region': "Fear (E4M9) Main"},
    351471: {'name': 'Fear (E4M9) - Chaingun',
             'episode': 4,
             'map': 9,
             'index': 235,
             'doom_type': 2002,
             'region': "Fear (E4M9) Main"},
    351472: {'name': 'Fear (E4M9) - Berserk',
             'episode': 4,
             'map': 9,
             'index': 246,
             'doom_type': 2023,
             'region': "Fear (E4M9) Main"},
    351473: {'name': 'Fear (E4M9) - Exit',
             'episode': 4,
             'map': 9,
             'index': -1,
             'doom_type': -1,
             'region': "Fear (E4M9) Yellow"},
}


location_name_groups: Dict[str, Set[str]] = {
    'Against Thee Wickedly (E4M6)': {
        'Against Thee Wickedly (E4M6) - Armor',
        'Against Thee Wickedly (E4M6) - BFG9000',
        'Against Thee Wickedly (E4M6) - Backpack',
        'Against Thee Wickedly (E4M6) - Berserk',
        'Against Thee Wickedly (E4M6) - Blue skull key',
        'Against Thee Wickedly (E4M6) - Chaingun',
        'Against Thee Wickedly (E4M6) - Exit',
        'Against Thee Wickedly (E4M6) - Invulnerability',
        'Against Thee Wickedly (E4M6) - Invulnerability 2',
        'Against Thee Wickedly (E4M6) - Mega Armor',
        'Against Thee Wickedly (E4M6) - Partial invisibility',
        'Against Thee Wickedly (E4M6) - Plasma gun',
        'Against Thee Wickedly (E4M6) - Red skull key',
        'Against Thee Wickedly (E4M6) - Rocket launcher',
        'Against Thee Wickedly (E4M6) - Shotgun',
        'Against Thee Wickedly (E4M6) - Supercharge',
        'Against Thee Wickedly (E4M6) - Yellow skull key',
    },
    'And Hell Followed (E4M7)': {
        'And Hell Followed (E4M7) - Armor',
        'And Hell Followed (E4M7) - BFG9000',
        'And Hell Followed (E4M7) - Backpack',
        'And Hell Followed (E4M7) - Berserk',
        'And Hell Followed (E4M7) - Blue skull key',
        'And Hell Followed (E4M7) - Chaingun',
        'And Hell Followed (E4M7) - Chainsaw',
        'And Hell Followed (E4M7) - Computer area map',
        'And Hell Followed (E4M7) - Exit',
        'And Hell Followed (E4M7) - Invulnerability',
        'And Hell Followed (E4M7) - Invulnerability 2',
        'And Hell Followed (E4M7) - Mega Armor',
        'And Hell Followed (E4M7) - Mega Armor 2',
        'And Hell Followed (E4M7) - Partial invisibility',
        'And Hell Followed (E4M7) - Plasma gun',
        'And Hell Followed (E4M7) - Red skull key',
        'And Hell Followed (E4M7) - Rocket launcher',
        'And Hell Followed (E4M7) - Rocket launcher 2',
        'And Hell Followed (E4M7) - Rocket launcher 3',
        'And Hell Followed (E4M7) - Shotgun',
        'And Hell Followed (E4M7) - Supercharge',
        'And Hell Followed (E4M7) - Supercharge 2',
        'And Hell Followed (E4M7) - Yellow skull key',
    },
    'Central Processing (E1M6)': {
        'Central Processing (E1M6) - Armor',
        'Central Processing (E1M6) - Armor 2',
        'Central Processing (E1M6) - Armor 3',
        'Central Processing (E1M6) - Armor 4',
        'Central Processing (E1M6) - Backpack',
        'Central Processing (E1M6) - Backpack 2',
        'Central Processing (E1M6) - Backpack 3',
        'Central Processing (E1M6) - Blue keycard',
        'Central Processing (E1M6) - Chaingun',
        'Central Processing (E1M6) - Computer area map',
        'Central Processing (E1M6) - Exit',
        'Central Processing (E1M6) - Mega Armor',
        'Central Processing (E1M6) - Partial invisibility',
        'Central Processing (E1M6) - Partial invisibility 2',
        'Central Processing (E1M6) - Red keycard',
        'Central Processing (E1M6) - Rocket launcher',
        'Central Processing (E1M6) - Shotgun',
        'Central Processing (E1M6) - Supercharge',
        'Central Processing (E1M6) - Supercharge 2',
        'Central Processing (E1M6) - Yellow keycard',
    },
    'Command Center (E2M5)': {
        'Command Center (E2M5) - Armor',
        'Command Center (E2M5) - Armor 2',
        'Command Center (E2M5) - Backpack',
        'Command Center (E2M5) - Berserk',
        'Command Center (E2M5) - Chaingun',
        'Command Center (E2M5) - Chainsaw',
        'Command Center (E2M5) - Computer area map',
        'Command Center (E2M5) - Exit',
        'Command Center (E2M5) - Mega Armor',
        'Command Center (E2M5) - Partial invisibility',
        'Command Center (E2M5) - Plasma gun',
    },
    'Command Control (E1M4)': {
        'Command Control (E1M4) - Armor',
        'Command Control (E1M4) - Backpack',
        'Command Control (E1M4) - Blue keycard',
        'Command Control (E1M4) - Chaingun',
        'Command Control (E1M4) - Exit',
        'Command Control (E1M4) - Mega Armor',
        'Command Control (E1M4) - Rocket launcher',
        'Command Control (E1M4) - Shotgun',
        'Command Control (E1M4) - Supercharge',
        'Command Control (E1M4) - Yellow keycard',
    },
    'Computer Station (E1M7)': {
        'Computer Station (E1M7) - Armor',
        'Computer Station (E1M7) - Armor 2',
        'Computer Station (E1M7) - Backpack',
        'Computer Station (E1M7) - Blue keycard',
        'Computer Station (E1M7) - Chaingun',
        'Computer Station (E1M7) - Chainsaw',
        'Computer Station (E1M7) - Computer area map',
        'Computer Station (E1M7) - Exit',
        'Computer Station (E1M7) - Mega Armor',
        'Computer Station (E1M7) - Partial invisibility',
        'Computer Station (E1M7) - Red keycard',
        'Computer Station (E1M7) - Rocket launcher',
        'Computer Station (E1M7) - Shotgun',
        'Computer Station (E1M7) - Shotgun 2',
        'Computer Station (E1M7) - Supercharge',
        'Computer Station (E1M7) - Yellow keycard',
    },
    'Containment Area (E2M2)': {
        'Containment Area (E2M2) - Armor',
        'Containment Area (E2M2) - Armor 2',
        'Containment Area (E2M2) - Armor 3',
        'Containment Area (E2M2) - Armor 4',
        'Containment Area (E2M2) - Backpack',
        'Containment Area (E2M2) - Backpack 2',
        'Containment Area (E2M2) - Berserk',
        'Containment Area (E2M2) - Blue keycard',
        'Containment Area (E2M2) - Chaingun',
        'Containment Area (E2M2) - Chainsaw',
        'Containment Area (E2M2) - Computer area map',
        'Containment Area (E2M2) - Exit',
        'Containment Area (E2M2) - Mega Armor',
        'Containment Area (E2M2) - Plasma gun',
        'Containment Area (E2M2) - Red keycard',
        'Containment Area (E2M2) - Rocket launcher',
        'Containment Area (E2M2) - Shotgun',
        'Containment Area (E2M2) - Shotgun 2',
        'Containment Area (E2M2) - Supercharge',
        'Containment Area (E2M2) - Yellow keycard',
    },
    'Deimos Anomaly (E2M1)': {
        'Deimos Anomaly (E2M1) - Armor',
        'Deimos Anomaly (E2M1) - Blue keycard',
        'Deimos Anomaly (E2M1) - Computer area map',
        'Deimos Anomaly (E2M1) - Exit',
        'Deimos Anomaly (E2M1) - Mega Armor',
        'Deimos Anomaly (E2M1) - Plasma gun',
        'Deimos Anomaly (E2M1) - Red keycard',
        'Deimos Anomaly (E2M1) - Shotgun',
        'Deimos Anomaly (E2M1) - Shotgun 2',
    },
    'Deimos Lab (E2M4)': {
        'Deimos Lab (E2M4) - Armor',
        'Deimos Lab (E2M4) - Armor 2',
        'Deimos Lab (E2M4) - Armor 3',
        'Deimos Lab (E2M4) - Backpack',
        'Deimos Lab (E2M4) - Berserk',
        'Deimos Lab (E2M4) - Blue keycard',
        'Deimos Lab (E2M4) - Chaingun',
        'Deimos Lab (E2M4) - Computer area map',
        'Deimos Lab (E2M4) - Exit',
        'Deimos Lab (E2M4) - Mega Armor',
        'Deimos Lab (E2M4) - Partial invisibility',
        'Deimos Lab (E2M4) - Partial invisibility 2',
        'Deimos Lab (E2M4) - Plasma gun',
        'Deimos Lab (E2M4) - Shotgun',
        'Deimos Lab (E2M4) - Supercharge',
        'Deimos Lab (E2M4) - Supercharge 2',
        'Deimos Lab (E2M4) - Yellow keycard',
    },
    'Dis (E3M8)': {
        'Dis (E3M8) - Exit',
        'Dis (E3M8) - Mega Armor',
        'Dis (E3M8) - Plasma gun',
        'Dis (E3M8) - Rocket launcher',
    },
    'Fear (E4M9)': {
        'Fear (E4M9) - Backpack',
        'Fear (E4M9) - Berserk',
        'Fear (E4M9) - Chaingun',
        'Fear (E4M9) - Exit',
        'Fear (E4M9) - Mega Armor',
        'Fear (E4M9) - Plasma gun',
        'Fear (E4M9) - Rocket launcher',
        'Fear (E4M9) - Rocket launcher 2',
        'Fear (E4M9) - Shotgun',
        'Fear (E4M9) - Yellow skull key',
    },
    'Fortress of Mystery (E2M9)': {
        'Fortress of Mystery (E2M9) - Backpack',
        'Fortress of Mystery (E2M9) - Blue skull key',
        'Fortress of Mystery (E2M9) - Chaingun',
        'Fortress of Mystery (E2M9) - Chainsaw',
        'Fortress of Mystery (E2M9) - Computer area map',
        'Fortress of Mystery (E2M9) - Exit',
        'Fortress of Mystery (E2M9) - Mega Armor',
        'Fortress of Mystery (E2M9) - Plasma gun',
        'Fortress of Mystery (E2M9) - Red skull key',
        'Fortress of Mystery (E2M9) - Rocket launcher',
        'Fortress of Mystery (E2M9) - Shotgun',
        'Fortress of Mystery (E2M9) - Supercharge',
        'Fortress of Mystery (E2M9) - Yellow skull key',
    },
    'Halls of the Damned (E2M6)': {
        'Halls of the Damned (E2M6) - Armor',
        'Halls of the Damned (E2M6) - Backpack',
        'Halls of the Damned (E2M6) - Berserk',
        'Halls of the Damned (E2M6) - Blue skull key',
        'Halls of the Damned (E2M6) - Chaingun',
        'Halls of the Damned (E2M6) - Chainsaw',
        'Halls of the Damned (E2M6) - Computer area map',
        'Halls of the Damned (E2M6) - Exit',
        'Halls of the Damned (E2M6) - Mega Armor',
        'Halls of the Damned (E2M6) - Partial invisibility',
        'Halls of the Damned (E2M6) - Partial invisibility 2',
        'Halls of the Damned (E2M6) - Partial invisibility 3',
        'Halls of the Damned (E2M6) - Plasma gun',
        'Halls of the Damned (E2M6) - Red skull key',
        'Halls of the Damned (E2M6) - Rocket launcher',
        'Halls of the Damned (E2M6) - Shotgun',
        'Halls of the Damned (E2M6) - Supercharge',
        'Halls of the Damned (E2M6) - Yellow skull key',
    },
    'Hangar (E1M1)': {
        'Hangar (E1M1) - Armor',
        'Hangar (E1M1) - Exit',
        'Hangar (E1M1) - Mega Armor',
        'Hangar (E1M1) - Shotgun',
    },
    'Hell Beneath (E4M1)': {
        'Hell Beneath (E4M1) - Armor',
        'Hell Beneath (E4M1) - Blue skull key',
        'Hell Beneath (E4M1) - Chaingun',
        'Hell Beneath (E4M1) - Exit',
        'Hell Beneath (E4M1) - Red skull key',
        'Hell Beneath (E4M1) - Rocket launcher',
        'Hell Beneath (E4M1) - Shotgun',
    },
    'Hell Keep (E3M1)': {
        'Hell Keep (E3M1) - Exit',
        'Hell Keep (E3M1) - Rocket launcher',
        'Hell Keep (E3M1) - Shotgun',
    },
    'House of Pain (E3M4)': {
        'House of Pain (E3M4) - Armor',
        'House of Pain (E3M4) - Armor 2',
        'House of Pain (E3M4) - Armor 3',
        'House of Pain (E3M4) - BFG9000',
        'House of Pain (E3M4) - Backpack',
        'House of Pain (E3M4) - Berserk',
        'House of Pain (E3M4) - Blue skull key',
        'House of Pain (E3M4) - Chaingun',
        'House of Pain (E3M4) - Exit',
        'House of Pain (E3M4) - Invulnerability',
        'House of Pain (E3M4) - Invulnerability 2',
        'House of Pain (E3M4) - Mega Armor',
        'House of Pain (E3M4) - Mega Armor 2',
        'House of Pain (E3M4) - Partial invisibility',
        'House of Pain (E3M4) - Red skull key',
        'House of Pain (E3M4) - Rocket launcher',
        'House of Pain (E3M4) - Shotgun',
        'House of Pain (E3M4) - Supercharge',
        'House of Pain (E3M4) - Yellow skull key',
    },
    'Limbo (E3M7)': {
        'Limbo (E3M7) - Armor',
        'Limbo (E3M7) - Armor 2',
        'Limbo (E3M7) - BFG9000',
        'Limbo (E3M7) - Backpack',
        'Limbo (E3M7) - Blue skull key',
        'Limbo (E3M7) - Exit',
        'Limbo (E3M7) - Mega Armor',
        'Limbo (E3M7) - Plasma gun',
        'Limbo (E3M7) - Red skull key',
        'Limbo (E3M7) - Rocket launcher',
        'Limbo (E3M7) - Supercharge',
        'Limbo (E3M7) - Yellow skull key',
    },
    'Military Base (E1M9)': {
        'Military Base (E1M9) - Armor',
        'Military Base (E1M9) - Backpack',
        'Military Base (E1M9) - Blue keycard',
        'Military Base (E1M9) - Chaingun',
        'Military Base (E1M9) - Chainsaw',
        'Military Base (E1M9) - Exit',
        'Military Base (E1M9) - Red keycard',
        'Military Base (E1M9) - Rocket launcher',
        'Military Base (E1M9) - Shotgun',
        'Military Base (E1M9) - Yellow keycard',
    },
    'Mt. Erebus (E3M6)': {
        'Mt. Erebus (E3M6) - Armor',
        'Mt. Erebus (E3M6) - Armor 2',
        'Mt. Erebus (E3M6) - Backpack',
        'Mt. Erebus (E3M6) - Berserk',
        'Mt. Erebus (E3M6) - Blue skull key',
        'Mt. Erebus (E3M6) - Blue skull key 2',
        'Mt. Erebus (E3M6) - Chaingun',
        'Mt. Erebus (E3M6) - Chainsaw',
        'Mt. Erebus (E3M6) - Computer area map',
        'Mt. Erebus (E3M6) - Exit',
        'Mt. Erebus (E3M6) - Invulnerability',
        'Mt. Erebus (E3M6) - Invulnerability 2',
        'Mt. Erebus (E3M6) - Mega Armor',
        'Mt. Erebus (E3M6) - Plasma gun',
        'Mt. Erebus (E3M6) - Rocket launcher',
        'Mt. Erebus (E3M6) - Shotgun',
        'Mt. Erebus (E3M6) - Supercharge',
        'Mt. Erebus (E3M6) - Supercharge 2',
    },
    'Nuclear Plant (E1M2)': {
        'Nuclear Plant (E1M2) - Armor',
        'Nuclear Plant (E1M2) - Armor 2',
        'Nuclear Plant (E1M2) - Armor 3',
        'Nuclear Plant (E1M2) - Backpack',
        'Nuclear Plant (E1M2) - Backpack 2',
        'Nuclear Plant (E1M2) - Chaingun',
        'Nuclear Plant (E1M2) - Chainsaw',
        'Nuclear Plant (E1M2) - Exit',
        'Nuclear Plant (E1M2) - Mega Armor',
        'Nuclear Plant (E1M2) - Red keycard',
        'Nuclear Plant (E1M2) - Shotgun',
        'Nuclear Plant (E1M2) - Supercharge',
    },
    'Pandemonium (E3M3)': {
        'Pandemonium (E3M3) - Armor',
        'Pandemonium (E3M3) - BFG9000',
        'Pandemonium (E3M3) - Backpack',
        'Pandemonium (E3M3) - Berserk',
        'Pandemonium (E3M3) - Blue skull key',
        'Pandemonium (E3M3) - Chaingun',
        'Pandemonium (E3M3) - Computer area map',
        'Pandemonium (E3M3) - Exit',
        'Pandemonium (E3M3) - Invulnerability',
        'Pandemonium (E3M3) - Mega Armor',
        'Pandemonium (E3M3) - Mega Armor 2',
        'Pandemonium (E3M3) - Rocket launcher',
        'Pandemonium (E3M3) - Shotgun',
        'Pandemonium (E3M3) - Shotgun 2',
        'Pandemonium (E3M3) - Supercharge',
    },
    'Perfect Hatred (E4M2)': {
        'Perfect Hatred (E4M2) - Armor',
        'Perfect Hatred (E4M2) - Armor 2',
        'Perfect Hatred (E4M2) - BFG9000',
        'Perfect Hatred (E4M2) - Berserk',
        'Perfect Hatred (E4M2) - Blue skull key',
        'Perfect Hatred (E4M2) - Chainsaw',
        'Perfect Hatred (E4M2) - Exit',
        'Perfect Hatred (E4M2) - Mega Armor',
        'Perfect Hatred (E4M2) - Plasma gun',
        'Perfect Hatred (E4M2) - Rocket launcher',
        'Perfect Hatred (E4M2) - Shotgun',
        'Perfect Hatred (E4M2) - Supercharge',
        'Perfect Hatred (E4M2) - Yellow skull key',
    },
    'Phobos Anomaly (E1M8)': {
        'Phobos Anomaly (E1M8) - Armor',
        'Phobos Anomaly (E1M8) - Chaingun',
        'Phobos Anomaly (E1M8) - Computer area map',
        'Phobos Anomaly (E1M8) - Exit',
        'Phobos Anomaly (E1M8) - Partial invisibility',
        'Phobos Anomaly (E1M8) - Shotgun',
        'Phobos Anomaly (E1M8) - Shotgun 2',
        'Phobos Anomaly (E1M8) - Supercharge',
    },
    'Phobos Lab (E1M5)': {
        'Phobos Lab (E1M5) - Armor',
        'Phobos Lab (E1M5) - Armor 2',
        'Phobos Lab (E1M5) - Backpack',
        'Phobos Lab (E1M5) - Blue keycard',
        'Phobos Lab (E1M5) - Chaingun',
        'Phobos Lab (E1M5) - Chainsaw',
        'Phobos Lab (E1M5) - Computer area map',
        'Phobos Lab (E1M5) - Exit',
        'Phobos Lab (E1M5) - Mega Armor',
        'Phobos Lab (E1M5) - Mega Armor 2',
        'Phobos Lab (E1M5) - Partial invisibility',
        'Phobos Lab (E1M5) - Rocket launcher',
        'Phobos Lab (E1M5) - Shotgun',
        'Phobos Lab (E1M5) - Shotgun 2',
        'Phobos Lab (E1M5) - Shotgun 3',
        'Phobos Lab (E1M5) - Supercharge',
        'Phobos Lab (E1M5) - Yellow keycard',
    },
    'Refinery (E2M3)': {
        'Refinery (E2M3) - Armor',
        'Refinery (E2M3) - Backpack',
        'Refinery (E2M3) - Berserk',
        'Refinery (E2M3) - Blue keycard',
        'Refinery (E2M3) - Chaingun',
        'Refinery (E2M3) - Exit',
        'Refinery (E2M3) - Mega Armor',
        'Refinery (E2M3) - Partial invisibility',
        'Refinery (E2M3) - Partial invisibility 2',
        'Refinery (E2M3) - Plasma gun',
        'Refinery (E2M3) - Shotgun',
        'Refinery (E2M3) - Supercharge',
    },
    'Sever the Wicked (E4M3)': {
        'Sever the Wicked (E4M3) - Backpack',
        'Sever the Wicked (E4M3) - Backpack 2',
        'Sever the Wicked (E4M3) - Berserk',
        'Sever the Wicked (E4M3) - Blue skull key',
        'Sever the Wicked (E4M3) - Chaingun',
        'Sever the Wicked (E4M3) - Chainsaw',
        'Sever the Wicked (E4M3) - Exit',
        'Sever the Wicked (E4M3) - Invulnerability',
        'Sever the Wicked (E4M3) - Mega Armor',
        'Sever the Wicked (E4M3) - Partial invisibility',
        'Sever the Wicked (E4M3) - Partial invisibility 2',
        'Sever the Wicked (E4M3) - Plasma gun',
        'Sever the Wicked (E4M3) - Plasma gun 2',
        'Sever the Wicked (E4M3) - Red skull key',
        'Sever the Wicked (E4M3) - Rocket launcher',
        'Sever the Wicked (E4M3) - Shotgun',
        'Sever the Wicked (E4M3) - Supercharge',
    },
    'Slough of Despair (E3M2)': {
        'Slough of Despair (E3M2) - Armor',
        'Slough of Despair (E3M2) - Berserk',
        'Slough of Despair (E3M2) - Blue skull key',
        'Slough of Despair (E3M2) - Chaingun',
        'Slough of Despair (E3M2) - Computer area map',
        'Slough of Despair (E3M2) - Exit',
        'Slough of Despair (E3M2) - Mega Armor',
        'Slough of Despair (E3M2) - Plasma gun',
        'Slough of Despair (E3M2) - Rocket launcher',
        'Slough of Despair (E3M2) - Supercharge',
    },
    'Spawning Vats (E2M7)': {
        'Spawning Vats (E2M7) - Armor',
        'Spawning Vats (E2M7) - Backpack',
        'Spawning Vats (E2M7) - Berserk',
        'Spawning Vats (E2M7) - Blue keycard',
        'Spawning Vats (E2M7) - Chaingun',
        'Spawning Vats (E2M7) - Chainsaw',
        'Spawning Vats (E2M7) - Computer area map',
        'Spawning Vats (E2M7) - Exit',
        'Spawning Vats (E2M7) - Invulnerability',
        'Spawning Vats (E2M7) - Invulnerability 2',
        'Spawning Vats (E2M7) - Mega Armor',
        'Spawning Vats (E2M7) - Partial invisibility',
        'Spawning Vats (E2M7) - Plasma gun',
        'Spawning Vats (E2M7) - Red keycard',
        'Spawning Vats (E2M7) - Rocket launcher',
        'Spawning Vats (E2M7) - Supercharge',
        'Spawning Vats (E2M7) - Yellow keycard',
    },
    'They Will Repent (E4M5)': {
        'They Will Repent (E4M5) - Armor',
        'They Will Repent (E4M5) - BFG9000',
        'They Will Repent (E4M5) - Berserk',
        'They Will Repent (E4M5) - Blue skull key',
        'They Will Repent (E4M5) - Chaingun',
        'They Will Repent (E4M5) - Exit',
        'They Will Repent (E4M5) - Invulnerability',
        'They Will Repent (E4M5) - Plasma gun',
        'They Will Repent (E4M5) - Red skull key',
        'They Will Repent (E4M5) - Rocket launcher',
        'They Will Repent (E4M5) - Supercharge',
        'They Will Repent (E4M5) - Yellow skull key',
    },
    'Tower of Babel (E2M8)': {
        'Tower of Babel (E2M8) - Exit',
        'Tower of Babel (E2M8) - Mega Armor',
        'Tower of Babel (E2M8) - Rocket launcher',
        'Tower of Babel (E2M8) - Supercharge',
        'Tower of Babel (E2M8) - Supercharge 2',
    },
    'Toxin Refinery (E1M3)': {
        'Toxin Refinery (E1M3) - Armor',
        'Toxin Refinery (E1M3) - Armor 2',
        'Toxin Refinery (E1M3) - Armor 3',
        'Toxin Refinery (E1M3) - Backpack',
        'Toxin Refinery (E1M3) - Blue keycard',
        'Toxin Refinery (E1M3) - Chaingun',
        'Toxin Refinery (E1M3) - Chainsaw',
        'Toxin Refinery (E1M3) - Exit',
        'Toxin Refinery (E1M3) - Mega Armor',
        'Toxin Refinery (E1M3) - Partial invisibility',
        'Toxin Refinery (E1M3) - Rocket launcher',
        'Toxin Refinery (E1M3) - Shotgun',
        'Toxin Refinery (E1M3) - Shotgun 2',
        'Toxin Refinery (E1M3) - Supercharge',
        'Toxin Refinery (E1M3) - Supercharge 2',
        'Toxin Refinery (E1M3) - Yellow keycard',
    },
    'Unholy Cathedral (E3M5)': {
        'Unholy Cathedral (E3M5) - BFG9000',
        'Unholy Cathedral (E3M5) - Berserk',
        'Unholy Cathedral (E3M5) - Blue skull key',
        'Unholy Cathedral (E3M5) - Chaingun',
        'Unholy Cathedral (E3M5) - Chainsaw',
        'Unholy Cathedral (E3M5) - Exit',
        'Unholy Cathedral (E3M5) - Invulnerability',
        'Unholy Cathedral (E3M5) - Partial invisibility',
        'Unholy Cathedral (E3M5) - Plasma gun',
        'Unholy Cathedral (E3M5) - Rocket launcher',
        'Unholy Cathedral (E3M5) - Shotgun',
        'Unholy Cathedral (E3M5) - Shotgun 2',
        'Unholy Cathedral (E3M5) - Supercharge',
        'Unholy Cathedral (E3M5) - Supercharge 2',
        'Unholy Cathedral (E3M5) - Yellow skull key',
    },
    'Unruly Evil (E4M4)': {
        'Unruly Evil (E4M4) - Berserk',
        'Unruly Evil (E4M4) - Chaingun',
        'Unruly Evil (E4M4) - Exit',
        'Unruly Evil (E4M4) - Invulnerability',
        'Unruly Evil (E4M4) - Partial invisibility',
        'Unruly Evil (E4M4) - Red skull key',
        'Unruly Evil (E4M4) - Rocket launcher',
        'Unruly Evil (E4M4) - Shotgun',
        'Unruly Evil (E4M4) - Supercharge',
    },
    'Unto the Cruel (E4M8)': {
        'Unto the Cruel (E4M8) - BFG9000',
        'Unto the Cruel (E4M8) - Backpack',
        'Unto the Cruel (E4M8) - Berserk',
        'Unto the Cruel (E4M8) - Chaingun',
        'Unto the Cruel (E4M8) - Exit',
        'Unto the Cruel (E4M8) - Mega Armor',
        'Unto the Cruel (E4M8) - Mega Armor 2',
        'Unto the Cruel (E4M8) - Partial invisibility',
        'Unto the Cruel (E4M8) - Plasma gun',
        'Unto the Cruel (E4M8) - Plasma gun 2',
        'Unto the Cruel (E4M8) - Red skull key',
        'Unto the Cruel (E4M8) - Rocket launcher',
        'Unto the Cruel (E4M8) - Rocket launcher 2',
        'Unto the Cruel (E4M8) - Shotgun',
        'Unto the Cruel (E4M8) - Supercharge',
        'Unto the Cruel (E4M8) - Supercharge 2',
        'Unto the Cruel (E4M8) - Supercharge 3',
        'Unto the Cruel (E4M8) - Yellow skull key',
    },
    'Warrens (E3M9)': {
        'Warrens (E3M9) - Armor',
        'Warrens (E3M9) - BFG9000',
        'Warrens (E3M9) - Berserk',
        'Warrens (E3M9) - Blue skull key',
        'Warrens (E3M9) - Chaingun',
        'Warrens (E3M9) - Chainsaw',
        'Warrens (E3M9) - Exit',
        'Warrens (E3M9) - Invulnerability',
        'Warrens (E3M9) - Invulnerability 2',
        'Warrens (E3M9) - Partial invisibility',
        'Warrens (E3M9) - Plasma gun',
        'Warrens (E3M9) - Red skull key',
        'Warrens (E3M9) - Rocket launcher',
        'Warrens (E3M9) - Rocket launcher 2',
        'Warrens (E3M9) - Shotgun',
        'Warrens (E3M9) - Supercharge',
        'Warrens (E3M9) - Supercharge 2',
    },
}


death_logic_locations = [
    "Command Control (E1M4) - Supercharge",
    "Command Control (E1M4) - Mega Armor",
    "Containment Area (E2M2) - Supercharge",
    "Containment Area (E2M2) - Plasma gun",
    "Pandemonium (E3M3) - Mega Armor",
    "House of Pain (E3M4) - Chaingun",
    "House of Pain (E3M4) - Invulnerability",
    "Unholy Cathedral (E3M5) - BFG9000",
    "Mt. Erebus (E3M6) - Chainsaw",
]
