from BaseClasses import Region

from ..base_classes import Q1Level


class r2m1(Q1Level):
    name = "Tempus Fugit"
    mapfile = "r2m1"
    keys = ["Silver", "Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Plasma (1)",
            "classname": "item_plasma",
            "uuid": 12261706238949580209,
            "mp": 1,
        },
        {
            "id": 2,
            "name": "Flag (2)",
            "classname": "item_flag_team1",
            "uuid": 12539013748577200982,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 15306891880547966743,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Lava (4)",
            "classname": "item_lava_spikes",
            "uuid": 18329411488629966369,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Shells (5)",
            "classname": "item_shells",
            "uuid": 16564652853488486303,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Nailgun (6)",
            "classname": "weapon_nailgun",
            "uuid": 15497106869570311388,
            "mp": 1,
        },
        {
            "id": 7,
            "name": "Spikes (7)",
            "classname": "item_spikes",
            "uuid": 9055522004269407849,
            "mp": 1,
        },
        {
            "id": 8,
            "name": "Lava (8)",
            "classname": "item_lava_spikes",
            "uuid": 683836207379132503,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Cells (9)",
            "classname": "item_cells",
            "uuid": 16785258983286940256,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Sphere (10)",
            "classname": "item_sphere",
            "uuid": 15268795494086149544,
            "mp": 1,
        },
        {
            "id": 11,
            "name": "Secret (11)",
            "classname": "trigger_secret",
            "uuid": 11847529033441575002,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Large Medkit (12)",
            "classname": "item_health",
            "uuid": 14849578484863248371,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Small Medkit (13)",
            "classname": "item_health",
            "uuid": 4688818600649553232,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Lava (14)",
            "classname": "item_lava_spikes",
            "uuid": 15078553525795125324,
            "mp": 1,
        },
        {
            "id": 15,
            "name": "Multi (15)",
            "classname": "item_multi_rockets",
            "uuid": 3683417217298568666,
            "mp": 1,
        },
        {
            "id": 16,
            "name": "Large Medkit (16)",
            "classname": "item_health",
            "uuid": 15223003845497277773,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Small Medkit (17)",
            "classname": "item_health",
            "uuid": 17945059659627972209,
            "mp": 1,
        },
        {
            "id": 18,
            "name": "Small Medkit (18)",
            "classname": "item_health",
            "uuid": 11759801043540630553,
            "mp": 1,
        },
        {
            "id": 19,
            "name": "Spikes (19)",
            "classname": "item_spikes",
            "uuid": 6911988881172201962,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Rockets (20)",
            "classname": "item_rockets",
            "uuid": 15808534789497025971,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Shells (21)",
            "classname": "item_shells",
            "uuid": 2881377969714304452,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Lava (22)",
            "classname": "item_lava_spikes",
            "uuid": 16816296019014068571,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Large Medkit (23)",
            "classname": "item_health",
            "uuid": 11925654897558173220,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Large Medkit (24)",
            "classname": "item_health",
            "uuid": 16923773290434580536,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Small Medkit (25)",
            "classname": "item_health",
            "uuid": 8553422385438373521,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Large Medkit (26)",
            "classname": "item_health",
            "uuid": 7469274164400816676,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Supershotgun (27)",
            "classname": "weapon_supershotgun",
            "uuid": 16573991226117772067,
            "mp": 1,
        },
        {
            "id": 28,
            "name": "Shells (28)",
            "classname": "item_shells",
            "uuid": 3968727855119671087,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Large Medkit (29)",
            "classname": "item_health",
            "uuid": 5930078196686427236,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Quad Damage (30)",
            "classname": "item_artifact_super_damage",
            "uuid": 4306162679576880496,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Lava (31)",
            "classname": "item_lava_spikes",
            "uuid": 17357744811808628259,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Grenadelauncher (32)",
            "classname": "weapon_grenadelauncher",
            "uuid": 10227050670638888302,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Yellow Armor (33)",
            "classname": "item_armor2",
            "uuid": 3653357858371636029,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Megahealth (34)",
            "classname": "item_health",
            "uuid": 783280163974592116,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Rockets (35)",
            "classname": "item_rockets",
            "uuid": 1282894707148218554,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Small Medkit (36)",
            "classname": "item_health",
            "uuid": 1332583166602612967,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Small Medkit (37)",
            "classname": "item_health",
            "uuid": 238574603410198708,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Small Medkit (38)",
            "classname": "item_health",
            "uuid": 8408653518435824776,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Small Medkit (39)",
            "classname": "item_health",
            "uuid": 15028791506124879732,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Small Medkit (40)",
            "classname": "item_health",
            "uuid": 5328390459190537000,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Large Medkit (41)",
            "classname": "item_health",
            "uuid": 12443352346531076962,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Lava (42)",
            "classname": "item_lava_spikes",
            "uuid": 7320272458778839919,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Small Medkit (43)",
            "classname": "item_health",
            "uuid": 3364818077086550,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Spikes (44)",
            "classname": "item_spikes",
            "uuid": 224042748947487623,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Small Medkit (45)",
            "classname": "item_health",
            "uuid": 17174926917208940006,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Green Armor (46)",
            "classname": "item_armor1",
            "uuid": 17148310598099310107,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Lava (47)",
            "classname": "item_lava_spikes",
            "uuid": 15729932414242991232,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Multi (48)",
            "classname": "item_multi_rockets",
            "uuid": 14953090376266569847,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Red Armor (49)",
            "classname": "item_armorInv",
            "uuid": 11607841086704191450,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Multi (50)",
            "classname": "item_multi_rockets",
            "uuid": 10007157477660036431,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Large Medkit (51)",
            "classname": "item_health",
            "uuid": 10484145575440981771,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Lava (52)",
            "classname": "item_lava_spikes",
            "uuid": 2850905229216175757,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Small Medkit (53)",
            "classname": "item_health",
            "uuid": 13662666542844218460,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Lava (54)",
            "classname": "item_lava_spikes",
            "uuid": 5690244793143321754,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Small Medkit (55)",
            "classname": "item_health",
            "uuid": 1892716368547651158,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Large Medkit (56)",
            "classname": "item_health",
            "uuid": 3172846634283899400,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Small Medkit (57)",
            "classname": "item_health",
            "uuid": 9205811740845632929,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Large Medkit (58)",
            "classname": "item_health",
            "uuid": 17591685269630832907,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Secret (59)",
            "classname": "trigger_secret",
            "uuid": 9535084351833170710,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Gold Key (60)",
            "classname": "item_key2",
            "uuid": 9342408026277915583,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Silver Key (61)",
            "classname": "item_key1",
            "uuid": 4501770818346745385,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Secret (62)",
            "classname": "trigger_secret",
            "uuid": 4024093628101303257,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Large Medkit (63)",
            "classname": "item_health",
            "uuid": 10012369884910523304,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Shells (64)",
            "classname": "item_shells",
            "uuid": 1288774838104251615,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Shells (65)",
            "classname": "item_shells",
            "uuid": 12018423116675690379,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Grenadelauncher (66)",
            "classname": "weapon_grenadelauncher",
            "uuid": 12313695963800915480,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Small Medkit (67)",
            "classname": "item_health",
            "uuid": 226740605323897651,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Large Medkit (68)",
            "classname": "item_health",
            "uuid": 12850658403496793995,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Spikes (69)",
            "classname": "item_spikes",
            "uuid": 2744850826253790584,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Spikes (70)",
            "classname": "item_spikes",
            "uuid": 8937649314277935091,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Large Medkit (71)",
            "classname": "item_health",
            "uuid": 244026907336593589,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Large Medkit (72)",
            "classname": "item_health",
            "uuid": 17560315584446607280,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Lava (73)",
            "classname": "item_lava_spikes",
            "uuid": 4579432345192039739,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Lava (74)",
            "classname": "item_lava_spikes",
            "uuid": 1325593332305411885,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Small Medkit (75)",
            "classname": "item_health",
            "uuid": 7195693868043763713,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Lava (76)",
            "classname": "item_lava_spikes",
            "uuid": 14644599102207461337,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Spikes (77)",
            "classname": "item_spikes",
            "uuid": 11605017890212898734,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Plasma (78)",
            "classname": "item_plasma",
            "uuid": 10436863214289331221,
            "mp": 1,
        },
        {
            "id": 79,
            "name": "Small Medkit (79)",
            "classname": "item_health",
            "uuid": 1902573759961194421,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Large Medkit (80)",
            "classname": "item_health",
            "uuid": 1928347785376897064,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Small Medkit (81)",
            "classname": "item_health",
            "uuid": 16307829511713873758,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Small Medkit (82)",
            "classname": "item_health",
            "uuid": 10804151222478438384,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Supershotgun (83)",
            "classname": "weapon_supershotgun",
            "uuid": 8784942736957876510,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Large Medkit (84)",
            "classname": "item_health",
            "uuid": 478962420374091761,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Small Medkit (85)",
            "classname": "item_health",
            "uuid": 14355361300494846101,
            "mp": 0,
        },
        {
            "id": 86,
            "name": "Large Medkit (86)",
            "classname": "item_health",
            "uuid": 16593202650198095931,
            "mp": 0,
        },
        {
            "id": 87,
            "name": "Spikes (87)",
            "classname": "item_spikes",
            "uuid": 12299674781706211855,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Small Medkit (88)",
            "classname": "item_health",
            "uuid": 15127560775419882047,
            "mp": 0,
        },
        {
            "id": 89,
            "name": "Small Medkit (89)",
            "classname": "item_health",
            "uuid": 14584183265339511093,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "Shells (90)",
            "classname": "item_shells",
            "uuid": 3040373136021064850,
            "mp": 0,
        },
        {
            "id": 91,
            "name": "Supernailgun (91)",
            "classname": "weapon_supernailgun",
            "uuid": 4516844970222399797,
            "mp": 0,
        },
        {
            "id": 92,
            "name": "Rockets (92)",
            "classname": "item_rockets",
            "uuid": 12767284657883345479,
            "mp": 0,
        },
        {
            "id": 93,
            "name": "Multi (93)",
            "classname": "item_multi_rockets",
            "uuid": 4936990738708424611,
            "mp": 1,
        },
        {
            "id": 94,
            "name": "Multi (94)",
            "classname": "item_multi_rockets",
            "uuid": 1932653666283522011,
            "mp": 0,
        },
        {
            "id": 95,
            "name": "Plasma (95)",
            "classname": "item_plasma",
            "uuid": 6632616054744376187,
            "mp": 1,
        },
        {
            "id": 96,
            "name": "Cells (96)",
            "classname": "item_cells",
            "uuid": 6520202414571823503,
            "mp": 0,
        },
        {
            "id": 97,
            "name": "Large Medkit (97)",
            "classname": "item_health",
            "uuid": 18130383362287714679,
            "mp": 0,
        },
        {
            "id": 98,
            "name": "Large Medkit (98)",
            "classname": "item_health",
            "uuid": 4922348154811211578,
            "mp": 0,
        },
        {
            "id": 99,
            "name": "Large Medkit (99)",
            "classname": "item_health",
            "uuid": 10567132779814771412,
            "mp": 0,
        },
        {
            "id": 100,
            "name": "Shells (100)",
            "classname": "item_shells",
            "uuid": 15969847968142475886,
            "mp": 0,
        },
        {
            "id": 101,
            "name": "Spikes (101)",
            "classname": "item_spikes",
            "uuid": 3639541235754200045,
            "mp": 0,
        },
        {
            "id": 102,
            "name": "Rockets (102)",
            "classname": "item_rockets",
            "uuid": 10825436535494408536,
            "mp": 0,
        },
        {
            "id": 103,
            "name": "Large Medkit (103)",
            "classname": "item_health",
            "uuid": 11461076916739237894,
            "mp": 0,
        },
        {
            "id": 104,
            "name": "Spikes (104)",
            "classname": "item_spikes",
            "uuid": 12949398489529301186,
            "mp": 0,
        },
        {
            "id": 105,
            "name": "Shells (105)",
            "classname": "item_shells",
            "uuid": 9748473601704763944,
            "mp": 0,
        },
        {
            "id": 106,
            "name": "Large Medkit (106)",
            "classname": "item_health",
            "uuid": 6685762489564871241,
            "mp": 0,
        },
        {
            "id": 107,
            "name": "Large Medkit (107)",
            "classname": "item_health",
            "uuid": 5964946287484123877,
            "mp": 0,
        },
        {
            "id": 108,
            "name": "Lava (108)",
            "classname": "item_lava_spikes",
            "uuid": 12089004952216464572,
            "mp": 0,
        },
        {
            "id": 109,
            "name": "Shells (109)",
            "classname": "item_shells",
            "uuid": 3319525156381447248,
            "mp": 0,
        },
        {
            "id": 110,
            "name": "Multi (110)",
            "classname": "item_multi_rockets",
            "uuid": 7268819139799716379,
            "mp": 0,
        },
        {
            "id": 111,
            "name": "Spikes (111)",
            "classname": "item_spikes",
            "uuid": 12936809087400498354,
            "mp": 0,
        },
        {
            "id": 112,
            "name": "Large Medkit (112)",
            "classname": "item_health",
            "uuid": 14812476583129915803,
            "mp": 0,
        },
        {
            "id": 113,
            "name": "Small Medkit (113)",
            "classname": "item_health",
            "uuid": 17530342049313548854,
            "mp": 0,
        },
        {
            "id": 114,
            "name": "Shells (114)",
            "classname": "item_shells",
            "uuid": 9046705379002366018,
            "mp": 0,
        },
        {
            "id": 115,
            "name": "Spikes (115)",
            "classname": "item_spikes",
            "uuid": 429905151614219460,
            "mp": 0,
        },
        {
            "id": 116,
            "name": "Multi (116)",
            "classname": "item_multi_rockets",
            "uuid": 14333280189093707818,
            "mp": 0,
        },
        {
            "id": 117,
            "name": "Lava (117)",
            "classname": "item_lava_spikes",
            "uuid": 10126066033731744668,
            "mp": 1,
        },
        {
            "id": 118,
            "name": "Multi (118)",
            "classname": "item_multi_rockets",
            "uuid": 6532805612306206362,
            "mp": 0,
        },
        {
            "id": 119,
            "name": "Large Medkit (119)",
            "classname": "item_health",
            "uuid": 8515400453497182935,
            "mp": 0,
        },
        {
            "id": 120,
            "name": "Large Medkit (120)",
            "classname": "item_health",
            "uuid": 15225713767787541781,
            "mp": 0,
        },
        {
            "id": 121,
            "name": "Large Medkit (121)",
            "classname": "item_health",
            "uuid": 16495118275034593471,
            "mp": 0,
        },
        {
            "id": 122,
            "name": "Spikes (122)",
            "classname": "item_spikes",
            "uuid": 18092774003496599573,
            "mp": 0,
        },
        {
            "id": 123,
            "name": "Spikes (123)",
            "classname": "item_spikes",
            "uuid": 4401752149708028014,
            "mp": 0,
        },
        {
            "id": 124,
            "name": "Powerup (124)",
            "classname": "item_powerup_belt",
            "uuid": 14647755961197000437,
            "mp": 1,
        },
        {
            "id": 125,
            "name": "Supershotgun (125)",
            "classname": "weapon_supershotgun",
            "uuid": 8053091428393171730,
            "mp": 1,
        },
        {
            "id": 126,
            "name": "Large Medkit (126)",
            "classname": "item_health",
            "uuid": 6061309516137587076,
            "mp": 0,
        },
        {
            "id": 127,
            "name": "Shells (127)",
            "classname": "item_shells",
            "uuid": 12312401298409425455,
            "mp": 1,
        },
        {
            "id": 128,
            "name": "Shells (128)",
            "classname": "item_shells",
            "uuid": 3334508153348310252,
            "mp": 0,
        },
        {
            "id": 129,
            "name": "Large Medkit (129)",
            "classname": "item_health",
            "uuid": 11445752653046847953,
            "mp": 0,
        },
        {
            "id": 130,
            "name": "Large Medkit (130)",
            "classname": "item_health",
            "uuid": 3145778889913490001,
            "mp": 1,
        },
        {
            "id": 131,
            "name": "Large Medkit (131)",
            "classname": "item_health",
            "uuid": 13178135963261910939,
            "mp": 0,
        },
        {
            "id": 132,
            "name": "Small Medkit (132)",
            "classname": "item_health",
            "uuid": 10893246840575335901,
            "mp": 0,
        },
        {
            "id": 133,
            "name": "Large Medkit (133)",
            "classname": "item_health",
            "uuid": 4248780167100753551,
            "mp": 0,
        },
        {
            "id": 134,
            "name": "Large Medkit (134)",
            "classname": "item_health",
            "uuid": 12956629017512393661,
            "mp": 0,
        },
        {
            "id": 135,
            "name": "Shells (135)",
            "classname": "item_shells",
            "uuid": 17948321947868298896,
            "mp": 0,
        },
        {
            "id": 136,
            "name": "Cells (136)",
            "classname": "item_cells",
            "uuid": 9479610070981925228,
            "mp": 0,
        },
        {
            "id": 137,
            "name": "Shells (137)",
            "classname": "item_shells",
            "uuid": 16666718243848655210,
            "mp": 0,
        },
        {
            "id": 138,
            "name": "Shells (138)",
            "classname": "item_shells",
            "uuid": 11671044030864386679,
            "mp": 0,
        },
        {
            "id": 139,
            "name": "Large Medkit (139)",
            "classname": "item_health",
            "uuid": 15051620527416808162,
            "mp": 0,
        },
        {
            "id": 140,
            "name": "Large Medkit (140)",
            "classname": "item_health",
            "uuid": 17406631077955370737,
            "mp": 0,
        },
        {
            "id": 141,
            "name": "Shells (141)",
            "classname": "item_shells",
            "uuid": 9487843886801393481,
            "mp": 0,
        },
        {
            "id": 142,
            "name": "Spikes (142)",
            "classname": "item_spikes",
            "uuid": 10000601483833155384,
            "mp": 0,
        },
        {
            "id": 143,
            "name": "Lava (143)",
            "classname": "item_lava_spikes",
            "uuid": 14743285100966873278,
            "mp": 0,
        },
        {
            "id": 144,
            "name": "Powerup (144)",
            "classname": "item_powerup_shield",
            "uuid": 9538365891414588888,
            "mp": 0,
        },
        {
            "id": 145,
            "name": "Large Medkit (145)",
            "classname": "item_health",
            "uuid": 10732526374683385856,
            "mp": 0,
        },
        {
            "id": 146,
            "name": "Rockets (146)",
            "classname": "item_rockets",
            "uuid": 5922016808093920546,
            "mp": 0,
        },
        # {
        #    "id": 147,
        #    "name": "Lava (147)",
        #    "classname": "item_lava_spikes",
        #    "uuid": 2569532793036697858,
        #    "mp": 0,
        # },
        {
            "id": 148,
            "name": "Lava (148)",
            "classname": "item_lava_spikes",
            "uuid": 2569532793036697858,
            "mp": 0,
        },
        {
            "id": 149,
            "name": "Supernailgun (149)",
            "classname": "weapon_supernailgun",
            "uuid": 2567965879454508326,
            "mp": 1,
        },
        {
            "id": 150,
            "name": "Spikes (150)",
            "classname": "item_spikes",
            "uuid": 17267170677281824928,
            "mp": 0,
        },
        {
            "id": 151,
            "name": "Powerup (151)",
            "classname": "item_powerup_belt",
            "uuid": 2320091047133834683,
            "mp": 1,
        },
        {
            "id": 152,
            "name": "Nailgun (152)",
            "classname": "weapon_nailgun",
            "uuid": 14581842832890422840,
            "mp": 0,
        },
        # {
        #    "id": 153,
        #    "name": "Spikes (153)",
        #    "classname": "item_spikes",
        #    "uuid": 11848955876634023871,
        #    "mp": 0,
        # },
        {
            "id": 154,
            "name": "Shells (154)",
            "classname": "item_shells",
            "uuid": 4898303093890598711,
            "mp": 0,
        },
        {
            "id": 155,
            "name": "Spikes (155)",
            "classname": "item_spikes",
            "uuid": 11848955876634023871,
            "mp": 0,
        },
        {
            "id": 156,
            "name": "Lava (156)",
            "classname": "item_lava_spikes",
            "uuid": 2917090061310634310,
            "mp": 0,
        },
        {
            "id": 157,
            "name": "Small Medkit (157)",
            "classname": "item_health",
            "uuid": 14507877345297477564,
            "mp": 1,
        },
        {
            "id": 158,
            "name": "Large Medkit (158)",
            "classname": "item_health",
            "uuid": 3031458526448793550,
            "mp": 1,
        },
        {
            "id": 159,
            "name": "Large Medkit (159)",
            "classname": "item_health",
            "uuid": 10954680296430967268,
            "mp": 0,
        },
        {
            "id": 160,
            "name": "Shells (160)",
            "classname": "item_shells",
            "uuid": 13267385353292273739,
            "mp": 0,
        },
        {
            "id": 161,
            "name": "Shells (161)",
            "classname": "item_shells",
            "uuid": 16061237156223305299,
            "mp": 0,
        },
        {
            "id": 162,
            "name": "Lightning (162)",
            "classname": "weapon_lightning",
            "uuid": 7927236382281851686,
            "mp": 1,
        },
        {
            "id": 163,
            "name": "Cells (163)",
            "classname": "item_cells",
            "uuid": 15954861958367210135,
            "mp": 1,
        },
        {
            "id": 164,
            "name": "Cells (164)",
            "classname": "item_cells",
            "uuid": 3210662484542007344,
            "mp": 1,
        },
        {
            "id": 165,
            "name": "Plasma (165)",
            "classname": "item_plasma",
            "uuid": 2824198480465834419,
            "mp": 1,
        },
        {
            "id": 166,
            "name": "Plasma (166)",
            "classname": "item_plasma",
            "uuid": 15643622256812469015,
            "mp": 1,
        },
        {
            "id": 167,
            "name": "Rockets (167)",
            "classname": "item_rockets",
            "uuid": 12844455331419949142,
            "mp": 0,
        },
        {
            "id": 168,
            "name": "Red Armor (168)",
            "classname": "item_armorInv",
            "uuid": 1059193337246251595,
            "mp": 1,
        },
        {
            "id": 169,
            "name": "Nailgun (169)",
            "classname": "weapon_nailgun",
            "uuid": 3135480742961558741,
            "mp": 1,
        },
        {
            "id": 170,
            "name": "Rocketlauncher (170)",
            "classname": "weapon_rocketlauncher",
            "uuid": 8498346932718306310,
            "mp": 0,
        },
        {
            "id": 171,
            "name": "Powerup (171)",
            "classname": "item_powerup_shield",
            "uuid": 1695065964529729937,
            "mp": 1,
        },
        {
            "id": 172,
            "name": "Lava (172)",
            "classname": "item_lava_spikes",
            "uuid": 5578927929094071898,
            "mp": 0,
        },
        {
            "id": 173,
            "name": "Biosuit (173)",
            "classname": "item_artifact_envirosuit",
            "uuid": 1785943069083709421,
            "mp": 1,
        },
        {
            "id": 174,
            "name": "Invulnerability (174)",
            "classname": "item_artifact_invulnerability",
            "uuid": 7156191698303595545,
            "mp": 1,
        },
        {
            "id": 175,
            "name": "Megahealth (175)",
            "classname": "item_health",
            "uuid": 16472417387035370278,
            "mp": 0,
        },
        {
            "id": 176,
            "name": "Quad Damage (176)",
            "classname": "item_artifact_super_damage",
            "uuid": 11401508259982295177,
            "mp": 1,
        },
        {
            "id": 177,
            "name": "Sphere (177)",
            "classname": "item_sphere",
            "uuid": 5952304050544301230,
            "mp": 0,
        },
        {
            "id": 178,
            "name": "Random (178)",
            "classname": "item_random_powerup",
            "uuid": 16992832452797620466,
            "mp": 1,
        },
        {
            "id": 179,
            "name": "Small Medkit (179)",
            "classname": "item_health",
            "uuid": 350990281768842871,
            "mp": 0,
        },
        {
            "id": 180,
            "name": "Cells (180)",
            "classname": "item_cells",
            "uuid": 13476220741207841001,
            "mp": 0,
        },
        {
            "id": 181,
            "name": "Flag (181)",
            "classname": "item_flag",
            "uuid": 16473119310180695410,
            "mp": 0,
        },
        {
            "id": 182,
            "name": "Flag (182)",
            "classname": "item_flag_team2",
            "uuid": 40247751793944286,
            "mp": 0,
        },
        {
            "id": 183,
            "name": "All Kills (183)",
            "classname": "all_kills",
            "uuid": 2500014104857509025,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Shells (154)",
                "Small Medkit (157)",
                "Plasma (166)",
                "Powerup (151)",
                "Large Medkit (158)",
                "Spikes (155)",
                "Cells (163)",
                "Cells (164)",
                "Shells (160)",
                "Plasma (165)",
                "Nailgun (152)",
                "Lightning (162)",
                "Shells (161)",
                "Large Medkit (159)",
                "Lava (156)",
                "Quad Damage (176)",
                "Shells (90)",
                "Rockets (167)",
                "Small Medkit (88)",
                "Small Medkit (89)",
                "Spikes (101)",
                "Large Medkit (86)",
                "Spikes (87)",
                "Powerup (171)",
                "Shells (100)",
                "Lava (172)",
            ],
        )
        self.restrict("Shells (90)", r.can_dive | r.difficulty("hard"))
        self.restrict("Rockets (167)", r.can_dive)
        self.restrict("Small Medkit (88)", r.can_dive)
        self.restrict("Small Medkit (89)", r.can_dive)
        self.restrict("Spikes (101)", r.can_dive)
        self.restrict("Large Medkit (86)", r.can_jump | r.can_rj_hard | r.can_gj_extr)
        self.restrict("Spikes (87)", r.can_jump | r.can_rj_hard | r.can_gj_extr)
        self.restrict("Powerup (171)", r.can_jump | r.can_rj_hard | r.can_gj_extr)
        self.restrict("Shells (100)", r.can_jump | r.can_rj_hard | r.can_gj_extr)
        self.restrict("Lava (172)", r.can_jump | r.can_rj_hard | r.can_gj_extr)

        dive_area = self.region(
            "Dive Area",
            [
                "Small Medkit (81)",
                "Small Medkit (82)",
                "Small Medkit (85)",
                "Supershotgun (83)",
                "Large Medkit (63)",
                "Shells (65)",
                "Shells (138)",
                "Small Medkit (45)",
                "Spikes (44)",
                "Spikes (111)",
                "Small Medkit (113)",
                "Large Medkit (112)",
                "Green Armor (46)",
                "Red Armor (168)",
                "Shells (114)",
                "Spikes (115)",
                "Small Medkit (39)",
                "Spikes (123)",
                "Nailgun (169)",
                "Small Medkit (36)",
                "Lava (42)",
                "Large Medkit (119)",
                "Spikes (122)",
                "Large Medkit (121)",
                "Small Medkit (37)",
                "Small Medkit (38)",
                "Lava (143)",
                "Rockets (35)",
                "Lava (117)",
                "Large Medkit (120)",
                "Large Medkit (139)",
                "Shells (64)",
                "Shells (109)",
                "Large Medkit (107)",
                "Large Medkit (106)",
                "Shells (105)",
                "Flag (2)",
                "Small Medkit (43)",
                "Spikes (104)",
                "Multi (110)",
                "Large Medkit (41)",
                "Small Medkit (40)",
                "Shells (141)",
                "Large Medkit (145)",
                "Spikes (142)",
                "Large Medkit (140)",
                "Sphere (10)",
                "Silver Key (61)",
                "Rockets (146)",
                "Powerup (144)",
                "Grenadelauncher (66)",
                "Rockets (102)",
                "Large Medkit (103)",
            ],
        )
        self.connect(ret, dive_area, r.can_dive & r.can_button)
        self.restrict("Grenadelauncher (66)", r.can_door)
        self.restrict("Rockets (102)", r.can_door)
        self.restrict("Large Medkit (103)", r.can_door)

        past_silver_door_area = self.region(
            "Past Silver Door",
            [
                "Yellow Armor (33)",
                "Large Medkit (51)",
                "Sphere (177)",
                "Rocketlauncher (170)",
                "Plasma (78)",
                "Small Medkit (79)",
                "Large Medkit (80)",
            ],
        )
        self.connect(dive_area, past_silver_door_area, self.silver_key)

        silver_upper_area = self.region(
            "Silver Upper",
            [
                "Plasma (1)",
                "Large Medkit (68)",
                "Small Medkit (67)",
                "Spikes (70)",
                "Spikes (69)",
                "Shells (5)",
                "Large Medkit (72)",
                "Large Medkit (71)",
                "Flag (181)",
                "Lava (74)",
                "Lava (73)",
                "Small Medkit (132)",
                "Large Medkit (133)",
                "Large Medkit (126)",
                "Large Medkit (131)",
                "Quad Damage (30)",
                "Cells (136)",
                "Large Medkit (84)",
                "Large Medkit (134)",
                "Lava (148)",
                "Shells (135)",
                "Large Medkit (129)",
                "Shells (128)",
                "Small Medkit (75)",
                "Biosuit (173)",
                "Large Medkit (58)",
                "Small Medkit (57)",
                "Secret (62)",
                "Megahealth (34)",
                "Invulnerability (174)",
                "Supernailgun (149)",
                "Small Medkit (55)",
                "Large Medkit (56)",
                "Small Medkit (53)",
                "Random (178)",
                "Small Medkit (179)",
                "Cells (180)",
                "Gold Key (60)",
                "Shells (28)",
                "Spikes (150)",
                "Large Medkit (29)",
                "Supernailgun (91)",
                "Lava (31)",
                "Spikes (77)",
                "Secret (59)",
                "Multi (48)",
                "Red Armor (49)",
            ],
        )
        self.connect(
            past_silver_door_area,
            silver_upper_area,
            r.can_jump | ((r.can_rj_hard | r.can_gj_extr) & r.heal(200)),
        )
        self.restrict("Secret (62)", r.can_shootswitch)
        self.restrict("Megahealth (34)", r.can_shootswitch)
        self.restrict("Invulnerability (174)", r.can_shootswitch)
        self.restrict("Supernailgun (91)", r.jump)
        self.restrict("Lava (31)", r.jump)
        self.restrict("Spikes (77)", r.jump)
        self.restrict("Secret (59)", r.jump & r.can_shootswitch)
        self.restrict("Multi (48)", r.jump & r.can_shootswitch)
        self.restrict("Red Armor (49)", r.jump & r.can_shootswitch)

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Rockets (92)",
                "Large Medkit (97)",
                "Plasma (95)",
                "Large Medkit (99)",
                "Large Medkit (98)",
                "Multi (94)",
                "Grenadelauncher (32)",
                "Shells (137)",
                "Multi (93)",
                "Spikes (7)",
                "Lava (14)",
                "Flag (182)",
                "Large Medkit (12)",
                "Small Medkit (13)",
                "Small Medkit (17)",
                "Large Medkit (16)",
                "Small Medkit (18)",
                "Spikes (19)",
                "Rockets (20)",
                "Large Medkit (26)",
                "Large Medkit (23)",
                "Lava (22)",
                "Shells (21)",
                "Large Medkit (24)",
                "Small Medkit (25)",
                "Supershotgun (27)",
                "Secret (11)",
                "Cells (9)",
                "Nailgun (6)",
                "Megahealth (175)",
                "Cells (96)",
                "Exit",
                "All Kills (183)",
            ],
        )
        self.connect(silver_upper_area, past_gold_door_area, self.gold_key)
        self.restrict("Secret (11)", r.jump)
        self.restrict("Cells (9)", r.jump)
        self.restrict("Nailgun (6)", r.jump)
        self.restrict("Megahealth (175)", r.jump)
        self.restrict("Cells (96)", r.jump)
        # TODO: Is difficult combat overkill?
        self.restrict("Exit", r.jump & r.difficult_combat)
        self.restrict("All Kills (183)", r.difficult_combat)

        return ret
