from BaseClasses import Region

from ..base_classes import Q1Level


class r1m3(Q1Level):
    name = "Judgement Call"
    mapfile = "r1m3"
    keys = ["Silver", "Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Gold Key (1)",
            "classname": "item_key2",
            "uuid": 6275787800331438053,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Silver Key (2)",
            "classname": "item_key1",
            "uuid": 1400776142312332061,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 1229007886210633469,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Small Medkit (4)",
            "classname": "item_health",
            "uuid": 20259790561539612,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Shells (5)",
            "classname": "item_shells",
            "uuid": 8758274251561358622,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Multi (6)",
            "classname": "item_multi_rockets",
            "uuid": 3047313099273172241,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Lava (7)",
            "classname": "item_lava_spikes",
            "uuid": 17866306936770883530,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Large Medkit (8)",
            "classname": "item_health",
            "uuid": 9324902659486249769,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Large Medkit (9)",
            "classname": "item_health",
            "uuid": 1849054358213350480,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Rocketlauncher (10)",
            "classname": "weapon_rocketlauncher",
            "uuid": 5962274066838046397,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Large Medkit (11)",
            "classname": "item_health",
            "uuid": 1207762018425438581,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Multi (12)",
            "classname": "item_multi_rockets",
            "uuid": 2323372189457325907,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Supernailgun (13)",
            "classname": "weapon_supernailgun",
            "uuid": 3394504672662388134,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Small Medkit (14)",
            "classname": "item_health",
            "uuid": 13695943240317029369,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Grenadelauncher (15)",
            "classname": "weapon_grenadelauncher",
            "uuid": 2327088211710632323,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Spikes (16)",
            "classname": "item_spikes",
            "uuid": 14178887645308626635,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Rockets (17)",
            "classname": "item_rockets",
            "uuid": 1636066007197914755,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Small Medkit (18)",
            "classname": "item_health",
            "uuid": 10161032593402847999,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Small Medkit (19)",
            "classname": "item_health",
            "uuid": 16312624016306319959,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Yellow Armor (20)",
            "classname": "item_armor2",
            "uuid": 12308145152523175265,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Lava (21)",
            "classname": "item_lava_spikes",
            "uuid": 8270960860110841361,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Multi (22)",
            "classname": "item_multi_rockets",
            "uuid": 13286336507411351156,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Rockets (23)",
            "classname": "item_rockets",
            "uuid": 8521461120667997680,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Large Medkit (24)",
            "classname": "item_health",
            "uuid": 1362207770205143071,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Large Medkit (25)",
            "classname": "item_health",
            "uuid": 15889132061728791086,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Large Medkit (26)",
            "classname": "item_health",
            "uuid": 3632679073133440167,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Large Medkit (27)",
            "classname": "item_health",
            "uuid": 1985027446456115467,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Large Medkit (28)",
            "classname": "item_health",
            "uuid": 17646220263454481466,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Large Medkit (29)",
            "classname": "item_health",
            "uuid": 18294350198248941641,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Lava (30)",
            "classname": "item_lava_spikes",
            "uuid": 17827448045153497967,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Lava (31)",
            "classname": "item_lava_spikes",
            "uuid": 15517768054911633620,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Rockets (32)",
            "classname": "item_rockets",
            "uuid": 7571638591856733530,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Spikes (33)",
            "classname": "item_spikes",
            "uuid": 5854110617584146627,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Biosuit (34)",
            "classname": "item_artifact_envirosuit",
            "uuid": 5006068122921107928,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Lava (35)",
            "classname": "item_lava_spikes",
            "uuid": 6889727977814239705,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Supershotgun (36)",
            "classname": "weapon_supershotgun",
            "uuid": 644194260229219993,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Shells (37)",
            "classname": "item_shells",
            "uuid": 2581540519475340981,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Nailgun (38)",
            "classname": "weapon_nailgun",
            "uuid": 8213438753690095973,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Large Medkit (39)",
            "classname": "item_health",
            "uuid": 4700547441880003711,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Large Medkit (40)",
            "classname": "item_health",
            "uuid": 3002552146661248132,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Spikes (41)",
            "classname": "item_spikes",
            "uuid": 6526413465974126200,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Rockets (42)",
            "classname": "item_rockets",
            "uuid": 15576630071072756492,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Large Medkit (43)",
            "classname": "item_health",
            "uuid": 10517545548512688405,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Large Medkit (44)",
            "classname": "item_health",
            "uuid": 13914296104837867698,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Spikes (45)",
            "classname": "item_spikes",
            "uuid": 602045681684698543,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Large Medkit (46)",
            "classname": "item_health",
            "uuid": 1381738689728427175,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Lava (47)",
            "classname": "item_lava_spikes",
            "uuid": 14436186915538226662,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Megahealth (48)",
            "classname": "item_health",
            "uuid": 512057457632176144,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Quad Damage (49)",
            "classname": "item_artifact_super_damage",
            "uuid": 798236789553290214,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Large Medkit (50)",
            "classname": "item_health",
            "uuid": 13297521544629300432,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Large Medkit (51)",
            "classname": "item_health",
            "uuid": 14849930246904776687,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Shells (52)",
            "classname": "item_shells",
            "uuid": 9206501972660416773,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Shells (53)",
            "classname": "item_shells",
            "uuid": 3471812629788069973,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Rockets (54)",
            "classname": "item_rockets",
            "uuid": 13088453639553018508,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Green Armor (55)",
            "classname": "item_armor1",
            "uuid": 13406713098660818192,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Secret (56)",
            "classname": "trigger_secret",
            "uuid": 15989070346594320072,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Secret (57)",
            "classname": "trigger_secret",
            "uuid": 8859259317683104314,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Small Medkit (58)",
            "classname": "item_health",
            "uuid": 12037242198791381437,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Small Medkit (59)",
            "classname": "item_health",
            "uuid": 15876084273694423736,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Lava (60)",
            "classname": "item_lava_spikes",
            "uuid": 16909785469356005376,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Large Medkit (61)",
            "classname": "item_health",
            "uuid": 11626200962356870130,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Large Medkit (62)",
            "classname": "item_health",
            "uuid": 10030717486902631383,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Multi (63)",
            "classname": "item_multi_rockets",
            "uuid": 16323741022390716119,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Shells (64)",
            "classname": "item_shells",
            "uuid": 10994342524668706768,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Small Medkit (65)",
            "classname": "item_health",
            "uuid": 17504540928454973170,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Small Medkit (66)",
            "classname": "item_health",
            "uuid": 18176221634586386444,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Large Medkit (67)",
            "classname": "item_health",
            "uuid": 15746199703148130898,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Lava (68)",
            "classname": "item_lava_spikes",
            "uuid": 10453875153747882868,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Lightning (69)",
            "classname": "weapon_lightning",
            "uuid": 15704619283155467562,
            "mp": 1,
        },
        {
            "id": 70,
            "name": "Cells (70)",
            "classname": "item_cells",
            "uuid": 14102580920160651888,
            "mp": 1,
        },
        {
            "id": 71,
            "name": "Cells (71)",
            "classname": "item_cells",
            "uuid": 2449361457043870556,
            "mp": 1,
        },
        {
            "id": 72,
            "name": "Invisibility (72)",
            "classname": "item_artifact_invisibility",
            "uuid": 7045865479364447117,
            "mp": 1,
        },
        {
            "id": 73,
            "name": "Secret (73)",
            "classname": "trigger_secret",
            "uuid": 18057475229593104142,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Secret (74)",
            "classname": "trigger_secret",
            "uuid": 6395586362938919555,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Small Medkit (75)",
            "classname": "item_health",
            "uuid": 2623611972011218739,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Small Medkit (76)",
            "classname": "item_health",
            "uuid": 8645674365035279748,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Supernailgun (77)",
            "classname": "weapon_supernailgun",
            "uuid": 17037718443759598781,
            "mp": 1,
        },
        {
            "id": 78,
            "name": "Cells (78)",
            "classname": "item_cells",
            "uuid": 4292902566457447880,
            "mp": 1,
        },
        {
            "id": 79,
            "name": "Powerup (79)",
            "classname": "item_powerup_shield",
            "uuid": 14835063711239023068,
            "mp": 1,
        },
        {
            "id": 80,
            "name": "Lightning (80)",
            "classname": "weapon_lightning",
            "uuid": 125000329250629355,
            "mp": 1,
        },
        {
            "id": 81,
            "name": "Cells (81)",
            "classname": "item_cells",
            "uuid": 15046103029838696474,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Grenadelauncher (82)",
            "classname": "weapon_grenadelauncher",
            "uuid": 16563993742352866113,
            "mp": 1,
        },
        {
            "id": 83,
            "name": "Rockets (83)",
            "classname": "item_rockets",
            "uuid": 1148571681555082448,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Yellow Armor (84)",
            "classname": "item_armor2",
            "uuid": 9078439578074716192,
            "mp": 1,
        },
        {
            "id": 85,
            "name": "Cells (85)",
            "classname": "item_cells",
            "uuid": 17286056578608606892,
            "mp": 1,
        },
        {
            "id": 86,
            "name": "Lava (86)",
            "classname": "item_lava_spikes",
            "uuid": 5079533004210663622,
            "mp": 1,
        },
        {
            "id": 87,
            "name": "Cells (87)",
            "classname": "item_cells",
            "uuid": 15143157612560054017,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Shells (88)",
            "classname": "item_shells",
            "uuid": 2095885699706219239,
            "mp": 1,
        },
        {
            "id": 89,
            "name": "Shells (89)",
            "classname": "item_shells",
            "uuid": 498125212375861514,
            "mp": 1,
        },
        {
            "id": 90,
            "name": "Supershotgun (90)",
            "classname": "weapon_supershotgun",
            "uuid": 183899988976326444,
            "mp": 1,
        },
        {
            "id": 91,
            "name": "Invulnerability (91)",
            "classname": "item_artifact_invulnerability",
            "uuid": 13382511480889300802,
            "mp": 1,
        },
        {
            "id": 92,
            "name": "Small Medkit (92)",
            "classname": "item_health",
            "uuid": 9270004861340843943,
            "mp": 0,
        },
        {
            "id": 93,
            "name": "Nailgun (93)",
            "classname": "weapon_nailgun",
            "uuid": 17048404279940135102,
            "mp": 1,
        },
        {
            "id": 94,
            "name": "Lava (94)",
            "classname": "item_lava_spikes",
            "uuid": 11099691843531782104,
            "mp": 1,
        },
        {
            "id": 95,
            "name": "Multi (95)",
            "classname": "item_multi_rockets",
            "uuid": 2398170284268812516,
            "mp": 1,
        },
        {
            "id": 96,
            "name": "Multi (96)",
            "classname": "item_multi_rockets",
            "uuid": 12801531737049407773,
            "mp": 1,
        },
        {
            "id": 97,
            "name": "Large Medkit (97)",
            "classname": "item_health",
            "uuid": 8993848371663283108,
            "mp": 0,
        },
        {
            "id": 98,
            "name": "Red Armor (98)",
            "classname": "item_armorInv",
            "uuid": 1702229279032992755,
            "mp": 0,
        },
        {
            "id": 99,
            "name": "Secret (99)",
            "classname": "trigger_secret",
            "uuid": 12823278435659273721,
            "mp": 0,
        },
        {
            "id": 100,
            "name": "Secret (100)",
            "classname": "trigger_secret",
            "uuid": 3380511140977631366,
            "mp": 0,
        },
        {
            "id": 101,
            "name": "Powerup (101)",
            "classname": "item_powerup_belt",
            "uuid": 12146600102934480689,
            "mp": 1,
        },
        {
            "id": 102,
            "name": "Sphere (102)",
            "classname": "item_sphere",
            "uuid": 6357875650827272489,
            "mp": 1,
        },
        {
            "id": 103,
            "name": "Sphere (103)",
            "classname": "item_sphere",
            "uuid": 4105038694820756512,
            "mp": 1,
        },
        {
            "id": 104,
            "name": "Plasma (104)",
            "classname": "item_plasma",
            "uuid": 18160671979545951351,
            "mp": 1,
        },
        {
            "id": 105,
            "name": "Plasma (105)",
            "classname": "item_plasma",
            "uuid": 17412942314316087250,
            "mp": 1,
        },
        {
            "id": 106,
            "name": "Plasma (106)",
            "classname": "item_plasma",
            "uuid": 10072852724044316106,
            "mp": 1,
        },
        {
            "id": 107,
            "name": "Plasma (107)",
            "classname": "item_plasma",
            "uuid": 13901897274751780236,
            "mp": 1,
        },
        {
            "id": 108,
            "name": "Plasma (108)",
            "classname": "item_plasma",
            "uuid": 15104494899350571760,
            "mp": 1,
        },
        {
            "id": 109,
            "name": "Plasma (109)",
            "classname": "item_plasma",
            "uuid": 8558521342260111153,
            "mp": 1,
        },
        {
            "id": 110,
            "name": "Flag (110)",
            "classname": "item_flag_team1",
            "uuid": 13767293856303759860,
            "mp": 0,
        },
        {
            "id": 111,
            "name": "Flag (111)",
            "classname": "item_flag_team2",
            "uuid": 11929463933255126251,
            "mp": 0,
        },
        {
            "id": 112,
            "name": "Flag (112)",
            "classname": "item_flag",
            "uuid": 12449646058998730385,
            "mp": 0,
        },
        {
            "id": 113,
            "name": "All Kills (113)",
            "classname": "all_kills",
            "uuid": 13024394826389779676,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Shells (5)",
                "Cells (71)",
                "Cells (70)",
                "Lightning (69)",
                "Small Medkit (4)",
                "Small Medkit (14)",
                "Flag (110)",
                "Multi (6)",
                "Quad Damage (49)",
                "Secret (73)",
                "Lava (7)",
                "Large Medkit (8)",
                "Large Medkit (9)",
                "Large Medkit (27)",
            ],
        )

        past_door_area = self.region(
            "Past Door Area",
            [
                "Lava (31)",
                "Lava (30)",
                "Large Medkit (50)",
                "Large Medkit (28)",
                "Large Medkit (29)",
                "Rockets (32)",
                "Spikes (33)",
                "Supershotgun (36)",
                "Shells (53)",
                "Plasma (104)",
                "Large Medkit (51)",
                "Small Medkit (19)",
                "Small Medkit (18)",
                "Grenadelauncher (15)",
                "Shells (52)",
                "Flag (111)",
                "Large Medkit (97)",
                "Powerup (101)",
                "Plasma (105)",
                "Small Medkit (58)",
                "Small Medkit (59)",
                "Lava (60)",
                "Secret (100)",
                "Biosuit (34)",
                "Lava (35)",
                "Secret (99)",
                "Shells (37)",
                "Rockets (54)",
                "Secret (57)",
                "Green Armor (55)",
            ],
        )
        self.connect(ret, past_door_area, r.can_door)
        self.restrict("Lava (60)", r.jump | r.difficulty("hard"))
        self.restrict("Secret (100)", r.can_shootswitch)
        self.restrict("Biosuit (34)", r.can_shootswitch)
        self.restrict("Lava (35)", r.can_shootswitch)
        self.restrict("Secret (99)", r.can_shootswitch)
        self.restrict("Shells (37)", r.can_shootswitch)
        self.restrict("Rockets (54)", r.can_shootswitch)
        self.restrict("Secret (57)", r.can_shootswitch)
        self.restrict("Green Armor (55)", r.can_shootswitch)

        past_button_area = self.region(
            "Past Button Area",
            [
                "Yellow Armor (20)",
                "Invulnerability (91)",
                "Lava (21)",
                "Large Medkit (25)",
                "Sphere (103)",
                "Large Medkit (26)",
                "Multi (22)",
                "Large Medkit (24)",
                "Rockets (23)",
            ],
        )
        self.connect(past_door_area, past_button_area, r.can_button)

        dive_area = self.region(
            "Dive Area",
            [
                "Lava (94)",
                "Secret (56)",
                "Megahealth (48)",
                "Large Medkit (46)",
                "Spikes (45)",
                "Nailgun (93)",
                "Silver Key (2)",
                "Invisibility (72)",
                "Large Medkit (11)",
                "Multi (96)",
                "Multi (12)",
                "Rocketlauncher (10)",
            ],
        )
        self.connect(past_button_area, dive_area, r.can_dive)
        self.restrict("Secret (56)", r.can_shootswitch)
        self.restrict("Megahealth (48)", r.can_shootswitch)

        past_silver_door_area = self.region(
            "Past Silver Door",
            [
                "Plasma (109)",
                "Nailgun (38)",
                "Spikes (41)",
                "Large Medkit (39)",
                "Large Medkit (40)",
                "Rockets (42)",
                "Multi (95)",
                "Supershotgun (90)",
                "Small Medkit (66)",
                "Shells (89)",
                "Small Medkit (65)",
                "Plasma (107)",
                "Small Medkit (92)",
                "Cells (85)",
                "Cells (87)",
                "Sphere (102)",
                "Shells (88)",
            ],
        )
        self.connect(ret, past_silver_door_area, self.silver_key)
        self.connect(
            past_door_area, past_silver_door_area, r.jump & r.difficulty("hard")
        )

        past_silver_door_top_area = self.region(
            "Past Silver Door Top",
            [
                "Cells (78)",
                "Supernailgun (13)",
                "Spikes (16)",
                "Gold Key (1)",
                "Supernailgun (77)",
                "Rockets (17)",
                "Large Medkit (44)",
                "Large Medkit (43)",
            ],
        )
        self.connect(past_silver_door_area, past_silver_door_top_area)
        self.connect(ret, past_silver_door_top_area, r.bigjump_hard)
        self.connect(past_silver_door_top_area, past_silver_door_area, r.can_door)

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Large Medkit (61)",
                "Large Medkit (62)",
                "Grenadelauncher (82)",
                "Flag (112)",
                "Shells (64)",
                "Lava (86)",
                "Small Medkit (76)",
                "Small Medkit (75)",
                "Cells (81)",
                "Lightning (80)",
                "Secret (74)",
                "Multi (63)",
                "Red Armor (98)",
                "Rockets (83)",
            ],
        )
        self.connect(past_silver_door_area, past_gold_door_area, self.gold_key)
        self.restrict("Secret (74)", r.jump)
        self.restrict("Multi (63)", r.jump)
        self.restrict("Red Armor (98)", r.jump)
        self.restrict("Rockets (83)", r.jump)

        past_lava_area = self.region(
            "Past Lava",
            [
                "Powerup (79)",
                "Yellow Armor (84)",
                "Plasma (108)",
                "Exit",
                "All Kills (113)",
            ],
        )
        self.connect(
            past_gold_door_area,
            past_lava_area,
            r.bigjump_hard | (r.can_button & r.jump),
        )
        self.restrict("All Kills (113)", r.can_shootswitch & r.difficult_combat)

        lava_jump_area = self.region(
            "Lava Jump",
            [
                "Large Medkit (67)",
                "Lava (68)",
            ],
        )
        self.connect(
            past_gold_door_area,
            lava_jump_area,
            (r.can_dive & r.invuln(1)) | (r.can_button & r.jump),
        )

        return ret
