from BaseClasses import Region

from ..base_classes import Q1Level


class mge2m2(Q1Level):
    name = "Fading Embers"
    mapfile = "mge2m2"
    keys = ["Silver", "Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Rocketlauncher (1)",
            "classname": "weapon_rocketlauncher",
            "uuid": 9927530113725414883,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Green Armor (2)",
            "classname": "item_armor1",
            "uuid": 10922937630174821206,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Green Armor (3)",
            "classname": "item_armor1",
            "uuid": 1477995814806626271,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Green Armor (4)",
            "classname": "item_armor1",
            "uuid": 204376522608184386,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Yellow Armor (5)",
            "classname": "item_armor2",
            "uuid": 14661965965193657398,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Rockets (6)",
            "classname": "item_rockets",
            "uuid": 13845128995167287225,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Rockets (7)",
            "classname": "item_rockets",
            "uuid": 4957352709790964765,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Spikes (8)",
            "classname": "item_spikes",
            "uuid": 16632378774755610226,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Supershotgun (9)",
            "classname": "weapon_supershotgun",
            "uuid": 13107094332810308467,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Nailgun (10)",
            "classname": "weapon_nailgun",
            "uuid": 7923328562519459883,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Yellow Armor (11)",
            "classname": "item_armor2",
            "uuid": 8102853157716040994,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Small Medkit (12)",
            "classname": "item_health",
            "uuid": 12773715460642862420,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Shells (13)",
            "classname": "item_shells",
            "uuid": 7430773457403497982,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Shells (14)",
            "classname": "item_shells",
            "uuid": 14646508869266197343,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Large Medkit (15)",
            "classname": "item_health",
            "uuid": 11814706043637806528,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Rockets (16)",
            "classname": "item_rockets",
            "uuid": 5016600912027400287,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Spikes (17)",
            "classname": "item_spikes",
            "uuid": 10295881491852280462,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Large Medkit (18)",
            "classname": "item_health",
            "uuid": 1930908963691253592,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Spikes (19)",
            "classname": "item_spikes",
            "uuid": 1876378399314548049,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Secret (20)",
            "classname": "trigger_secret",
            "uuid": 17851480309273662447,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Rockets (21)",
            "classname": "item_rockets",
            "uuid": 4599476362000606900,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Shells (22)",
            "classname": "item_shells",
            "uuid": 18002011694788084102,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Spikes (23)",
            "classname": "item_spikes",
            "uuid": 10782656777805998721,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Shells (24)",
            "classname": "item_shells",
            "uuid": 17948898862312095795,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Large Medkit (25)",
            "classname": "item_health",
            "uuid": 13869688812866516047,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Spikes (26)",
            "classname": "item_spikes",
            "uuid": 17072453900628528685,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Spikes (27)",
            "classname": "item_spikes",
            "uuid": 4499682770438359111,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Red Armor (28)",
            "classname": "item_armorInv",
            "uuid": 12457168016633371624,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Large Medkit (29)",
            "classname": "item_health",
            "uuid": 16271014333800708504,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Spikes (30)",
            "classname": "item_spikes",
            "uuid": 9767319890401155673,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Shells (31)",
            "classname": "item_shells",
            "uuid": 3314727500849686633,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Large Medkit (32)",
            "classname": "item_health",
            "uuid": 17015820256172714572,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Spikes (33)",
            "classname": "item_spikes",
            "uuid": 13067563876572468095,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Spikes (34)",
            "classname": "item_spikes",
            "uuid": 15062069302654641499,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Spikes (35)",
            "classname": "item_spikes",
            "uuid": 10991111665228797336,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Large Medkit (36)",
            "classname": "item_health",
            "uuid": 8134246499274018605,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Shells (37)",
            "classname": "item_shells",
            "uuid": 8893749748616982593,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Silver Key (38)",
            "classname": "item_key1",
            "uuid": 13569859799694710720,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Sigil (39)",
            "classname": "item_sigil",
            "uuid": 15010253696491172001,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 8380428955811362434,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Secret (41)",
            "classname": "trigger_secret",
            "uuid": 10072457938704387428,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Secret (42)",
            "classname": "trigger_secret",
            "uuid": 16400198079362412702,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Secret (43)",
            "classname": "trigger_secret",
            "uuid": 3756479758367947036,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Supernailgun (44)",
            "classname": "weapon_supernailgun",
            "uuid": 7143834841796874760,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Red Armor (45)",
            "classname": "item_armorInv",
            "uuid": 6466004461913866205,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Red Armor (46)",
            "classname": "item_armorInv",
            "uuid": 12135010377404122891,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Green Armor (47)",
            "classname": "item_armor1",
            "uuid": 13528106097132798489,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Large Medkit (48)",
            "classname": "item_health",
            "uuid": 6159513195488182635,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Large Medkit (49)",
            "classname": "item_health",
            "uuid": 14281129246202961307,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Spikes (50)",
            "classname": "item_spikes",
            "uuid": 365365841705836990,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Spikes (51)",
            "classname": "item_spikes",
            "uuid": 17835359769453549784,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Spikes (52)",
            "classname": "item_spikes",
            "uuid": 10687411755432606216,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Spikes (53)",
            "classname": "item_spikes",
            "uuid": 14140767296298840162,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Shells (54)",
            "classname": "item_shells",
            "uuid": 5447868601090219072,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Large Medkit (55)",
            "classname": "item_health",
            "uuid": 11087053333365874547,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Large Medkit (56)",
            "classname": "item_health",
            "uuid": 11495412768200280893,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Large Medkit (57)",
            "classname": "item_health",
            "uuid": 7717775038555305005,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Large Medkit (58)",
            "classname": "item_health",
            "uuid": 8466113011506137670,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Large Medkit (59)",
            "classname": "item_health",
            "uuid": 12265695835384105361,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Spikes (60)",
            "classname": "item_spikes",
            "uuid": 6682229899382077728,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Cells (61)",
            "classname": "item_cells",
            "uuid": 11563750772736909466,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Megahealth (62)",
            "classname": "item_health",
            "uuid": 10860111916999317513,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Yellow Armor (63)",
            "classname": "item_armor2",
            "uuid": 562815699595762331,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Cells (64)",
            "classname": "item_cells",
            "uuid": 3420164791055929759,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Large Medkit (65)",
            "classname": "item_health",
            "uuid": 17004112894504755937,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Shells (66)",
            "classname": "item_shells",
            "uuid": 673087859476673582,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Spikes (67)",
            "classname": "item_spikes",
            "uuid": 14527679368403621467,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Large Medkit (68)",
            "classname": "item_health",
            "uuid": 16729846799842003708,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Large Medkit (69)",
            "classname": "item_health",
            "uuid": 5532327230718241346,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Rockets (70)",
            "classname": "item_rockets",
            "uuid": 1719319537284186124,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Shells (71)",
            "classname": "item_shells",
            "uuid": 9109539230005847113,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Spikes (72)",
            "classname": "item_spikes",
            "uuid": 9087936965976786310,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Large Medkit (73)",
            "classname": "item_health",
            "uuid": 12462211812079310183,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Large Medkit (74)",
            "classname": "item_health",
            "uuid": 7277387641423806812,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Shells (75)",
            "classname": "item_shells",
            "uuid": 11544888591024127584,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Cells (76)",
            "classname": "item_cells",
            "uuid": 11638541836701555197,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Spikes (77)",
            "classname": "item_spikes",
            "uuid": 7583178123215485325,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Spikes (78)",
            "classname": "item_spikes",
            "uuid": 2196073309817094974,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Quad Damage (79)",
            "classname": "item_artifact_super_damage",
            "uuid": 16470094215893486855,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Spikes (80)",
            "classname": "item_spikes",
            "uuid": 14387822863379578935,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Large Medkit (81)",
            "classname": "item_health",
            "uuid": 13462585016199296361,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Spikes (82)",
            "classname": "item_spikes",
            "uuid": 3641437727121176458,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Cells (83)",
            "classname": "item_cells",
            "uuid": 13601837799028630080,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Large Medkit (84)",
            "classname": "item_health",
            "uuid": 14194260941691423224,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Large Medkit (85)",
            "classname": "item_health",
            "uuid": 14370563747750148760,
            "mp": 0,
        },
        {
            "id": 86,
            "name": "Spikes (86)",
            "classname": "item_spikes",
            "uuid": 15777835573078283133,
            "mp": 0,
        },
        {
            "id": 87,
            "name": "Spikes (87)",
            "classname": "item_spikes",
            "uuid": 15962201708555204098,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Shells (88)",
            "classname": "item_shells",
            "uuid": 9606312658193147109,
            "mp": 0,
        },
        {
            "id": 89,
            "name": "Spikes (89)",
            "classname": "item_spikes",
            "uuid": 17401531495702609737,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "Large Medkit (90)",
            "classname": "item_health",
            "uuid": 9717554326214153097,
            "mp": 0,
        },
        {
            "id": 91,
            "name": "Spikes (91)",
            "classname": "item_spikes",
            "uuid": 9121733048291002049,
            "mp": 0,
        },
        {
            "id": 92,
            "name": "Shells (92)",
            "classname": "item_shells",
            "uuid": 3745403953968658495,
            "mp": 0,
        },
        {
            "id": 93,
            "name": "Large Medkit (93)",
            "classname": "item_health",
            "uuid": 14415964889248019476,
            "mp": 0,
        },
        {
            "id": 94,
            "name": "Large Medkit (94)",
            "classname": "item_health",
            "uuid": 2584388459439955061,
            "mp": 0,
        },
        {
            "id": 95,
            "name": "Megahealth (95)",
            "classname": "item_health",
            "uuid": 10004995612894532089,
            "mp": 0,
        },
        {
            "id": 96,
            "name": "Shells (96)",
            "classname": "item_shells",
            "uuid": 11406184520121388473,
            "mp": 0,
        },
        {
            "id": 97,
            "name": "Cells (97)",
            "classname": "item_cells",
            "uuid": 9858366540878510545,
            "mp": 0,
        },
        {
            "id": 98,
            "name": "Large Medkit (98)",
            "classname": "item_health",
            "uuid": 17510088284615913160,
            "mp": 0,
        },
        {
            "id": 99,
            "name": "Spikes (99)",
            "classname": "item_spikes",
            "uuid": 15448175591448043339,
            "mp": 0,
        },
        {
            "id": 100,
            "name": "Secret (100)",
            "classname": "trigger_secret",
            "uuid": 812068046316219188,
            "mp": 0,
        },
        {
            "id": 101,
            "name": "Shells (101)",
            "classname": "item_shells",
            "uuid": 2493376201376106601,
            "mp": 0,
        },
        {
            "id": 102,
            "name": "Spikes (102)",
            "classname": "item_spikes",
            "uuid": 18078645207112233077,
            "mp": 0,
        },
        {
            "id": 103,
            "name": "Lightning (103)",
            "classname": "weapon_lightning",
            "uuid": 13817619510322772867,
            "mp": 0,
        },
        {
            "id": 104,
            "name": "Supernailgun (104)",
            "classname": "weapon_supernailgun",
            "uuid": 9840247025582038665,
            "mp": 0,
        },
        {
            "id": 105,
            "name": "Secret (105)",
            "classname": "trigger_secret",
            "uuid": 225153779159109225,
            "mp": 0,
        },
        {
            "id": 106,
            "name": "Large Medkit (106)",
            "classname": "item_health",
            "uuid": 1216007881087302036,
            "mp": 0,
        },
        {
            "id": 107,
            "name": "Nailgun (107)",
            "classname": "weapon_nailgun",
            "uuid": 4480232833568617175,
            "mp": 0,
        },
        {
            "id": 108,
            "name": "Quad Damage (108)",
            "classname": "item_artifact_super_damage",
            "uuid": 5131255476441544243,
            "mp": 0,
        },
        {
            "id": 109,
            "name": "Secret (109)",
            "classname": "trigger_secret",
            "uuid": 15687801104465625288,
            "mp": 0,
        },
        {
            "id": 110,
            "name": "Shells (110)",
            "classname": "item_shells",
            "uuid": 13078081731569563695,
            "mp": 0,
        },
        {
            "id": 111,
            "name": "Spikes (111)",
            "classname": "item_spikes",
            "uuid": 4223733016172739607,
            "mp": 0,
        },
        {
            "id": 112,
            "name": "Large Medkit (112)",
            "classname": "item_health",
            "uuid": 9732497741377395717,
            "mp": 0,
        },
        {
            "id": 113,
            "name": "Spikes (113)",
            "classname": "item_spikes",
            "uuid": 5884809811094694924,
            "mp": 0,
        },
        {
            "id": 114,
            "name": "Spikes (114)",
            "classname": "item_spikes",
            "uuid": 4700172765978457986,
            "mp": 0,
        },
        {
            "id": 115,
            "name": "Spikes (115)",
            "classname": "item_spikes",
            "uuid": 9023623227802169068,
            "mp": 0,
        },
        {
            "id": 116,
            "name": "Large Medkit (116)",
            "classname": "item_health",
            "uuid": 10210352911175968735,
            "mp": 0,
        },
        {
            "id": 117,
            "name": "Large Medkit (117)",
            "classname": "item_health",
            "uuid": 1784895658281987163,
            "mp": 0,
        },
        {
            "id": 118,
            "name": "Grenadelauncher (118)",
            "classname": "weapon_grenadelauncher",
            "uuid": 18283522142292826866,
            "mp": 0,
        },
        {
            "id": 119,
            "name": "Large Medkit (119)",
            "classname": "item_health",
            "uuid": 9455169935459930153,
            "mp": 0,
        },
        {
            "id": 120,
            "name": "Shells (120)",
            "classname": "item_shells",
            "uuid": 7355764459242792191,
            "mp": 0,
        },
        {
            "id": 121,
            "name": "Shells (121)",
            "classname": "item_shells",
            "uuid": 8106275657135980163,
            "mp": 0,
        },
        {
            "id": 122,
            "name": "Large Medkit (122)",
            "classname": "item_health",
            "uuid": 232105924003961432,
            "mp": 0,
        },
        {
            "id": 123,
            "name": "Spikes (123)",
            "classname": "item_spikes",
            "uuid": 18084594839886904257,
            "mp": 0,
        },
        {
            "id": 124,
            "name": "Spikes (124)",
            "classname": "item_spikes",
            "uuid": 15592559146039250655,
            "mp": 0,
        },
        {
            "id": 125,
            "name": "Spikes (125)",
            "classname": "item_spikes",
            "uuid": 15173571882245669057,
            "mp": 0,
        },
        {
            "id": 126,
            "name": "Large Medkit (126)",
            "classname": "item_health",
            "uuid": 16473892898138837859,
            "mp": 0,
        },
        {
            "id": 127,
            "name": "Large Medkit (127)",
            "classname": "item_health",
            "uuid": 9771356104582416975,
            "mp": 0,
        },
        {
            "id": 128,
            "name": "Shells (128)",
            "classname": "item_shells",
            "uuid": 2817969890866035062,
            "mp": 0,
        },
        {
            "id": 129,
            "name": "Spikes (129)",
            "classname": "item_spikes",
            "uuid": 13299673985574690747,
            "mp": 0,
        },
        {
            "id": 130,
            "name": "Spikes (130)",
            "classname": "item_spikes",
            "uuid": 13294656114935750318,
            "mp": 0,
        },
        {
            "id": 131,
            "name": "Shells (131)",
            "classname": "item_shells",
            "uuid": 4726811702620887269,
            "mp": 0,
        },
        {
            "id": 132,
            "name": "Large Medkit (132)",
            "classname": "item_health",
            "uuid": 6605551252678649313,
            "mp": 0,
        },
        {
            "id": 133,
            "name": "Gold Key (133)",
            "classname": "item_key2",
            "uuid": 207332040712127831,
            "mp": 0,
        },
        {
            "id": 134,
            "name": "Lightning (134)",
            "classname": "weapon_lightning",
            "uuid": 3785317757563226105,
            "mp": 0,
        },
        {
            "id": 135,
            "name": "Secret (135)",
            "classname": "trigger_secret",
            "uuid": 12565443790307466392,
            "mp": 0,
        },
        {
            "id": 136,
            "name": "Cells (136)",
            "classname": "item_cells",
            "uuid": 13767054326380912563,
            "mp": 0,
        },
        {
            "id": 137,
            "name": "Cells (137)",
            "classname": "item_cells",
            "uuid": 7650015167255316010,
            "mp": 0,
        },
        {
            "id": 138,
            "name": "Spikes (138)",
            "classname": "item_spikes",
            "uuid": 993060962673881470,
            "mp": 0,
        },
        {
            "id": 139,
            "name": "Large Medkit (139)",
            "classname": "item_health",
            "uuid": 15447531828262644764,
            "mp": 0,
        },
        {
            "id": 140,
            "name": "Shells (140)",
            "classname": "item_shells",
            "uuid": 14140483322259764583,
            "mp": 0,
        },
        {
            "id": 141,
            "name": "Large Medkit (141)",
            "classname": "item_health",
            "uuid": 17431601340990348755,
            "mp": 0,
        },
        {
            "id": 142,
            "name": "Large Medkit (142)",
            "classname": "item_health",
            "uuid": 14320182465472286289,
            "mp": 0,
        },
        {
            "id": 143,
            "name": "Large Medkit (143)",
            "classname": "item_health",
            "uuid": 11417718933152313609,
            "mp": 0,
        },
        {
            "id": 144,
            "name": "Large Medkit (144)",
            "classname": "item_health",
            "uuid": 17922458070337072061,
            "mp": 0,
        },
        {
            "id": 145,
            "name": "Spikes (145)",
            "classname": "item_spikes",
            "uuid": 6934383620237751628,
            "mp": 0,
        },
        {
            "id": 146,
            "name": "Large Medkit (146)",
            "classname": "item_health",
            "uuid": 1232487923243940835,
            "mp": 0,
        },
        {
            "id": 147,
            "name": "Spikes (147)",
            "classname": "item_spikes",
            "uuid": 4994470255132847312,
            "mp": 0,
        },
        {
            "id": 148,
            "name": "Spikes (148)",
            "classname": "item_spikes",
            "uuid": 11547582301039535277,
            "mp": 0,
        },
        {
            "id": 149,
            "name": "Large Medkit (149)",
            "classname": "item_health",
            "uuid": 12893812313815155958,
            "mp": 0,
        },
        {
            "id": 150,
            "name": "Spikes (150)",
            "classname": "item_spikes",
            "uuid": 15109267558640783636,
            "mp": 0,
        },
        {
            "id": 151,
            "name": "Lightning (151)",
            "classname": "weapon_lightning",
            "uuid": 2375500281908584225,
            "mp": 0,
        },
        {
            "id": 152,
            "name": "Shells (152)",
            "classname": "item_shells",
            "uuid": 6100661521013894250,
            "mp": 0,
        },
        {
            "id": 153,
            "name": "Large Medkit (153)",
            "classname": "item_health",
            "uuid": 4673131487207988745,
            "mp": 0,
        },
        {
            "id": 154,
            "name": "Large Medkit (154)",
            "classname": "item_health",
            "uuid": 6671995369452938788,
            "mp": 0,
        },
        {
            "id": 155,
            "name": "Spikes (155)",
            "classname": "item_spikes",
            "uuid": 13696556390669314814,
            "mp": 0,
        },
        {
            "id": 156,
            "name": "Large Medkit (156)",
            "classname": "item_health",
            "uuid": 17310281618366566883,
            "mp": 0,
        },
        {
            "id": 157,
            "name": "Spikes (157)",
            "classname": "item_spikes",
            "uuid": 1107305839851703775,
            "mp": 0,
        },
        {
            "id": 158,
            "name": "All Kills (158)",
            "classname": "all_kills",
            "uuid": 7757337384863770120,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Nailgun (10)",
                "Large Medkit (15)",
                "Spikes (17)",
                "Shells (14)",
                "Supershotgun (9)",
                "Small Medkit (12)",
                "Spikes (19)",
                "Shells (13)",
                "Rockets (16)",
                "Yellow Armor (11)",
            ],
        )
        self.restrict("Yellow Armor (11)", r.difficulty("hard") | r.jump)

        jump_area = self.region(
            "Jump Area",
            [
                "Large Medkit (18)",
                "Supernailgun (104)",
                "Large Medkit (106)",
                "Green Armor (2)",
                "Spikes (23)",
                "Spikes (26)",
                "Shells (22)",
                "Secret (109)",
                "Quad Damage (108)",
                "Nailgun (107)",
                "Secret (20)",
                "Red Armor (28)",
                "Large Medkit (29)",
                "Large Medkit (32)",
                "Spikes (27)",
                "Spikes (30)",
                "Shells (24)",
                "Shells (31)",
                "Spikes (33)",
                "Large Medkit (25)",
                "Spikes (34)",
                "Spikes (35)",
                "Rockets (21)",
                "Large Medkit (119)",
                "Shells (120)",
                "Large Medkit (122)",
                "Spikes (124)",
                "Spikes (123)",
                "Shells (121)",
            ],
        )
        self.connect(ret, jump_area, r.jump)

        past_button_area = self.region(
            "Past Button Door Area",
            [
                "Large Medkit (126)",
                "Large Medkit (127)",
                "Shells (128)",
                "Spikes (125)",
                "Green Armor (3)",
                "Spikes (129)",
                "Spikes (130)",
                "Shells (131)",
                "Grenadelauncher (118)",
                "Large Medkit (132)",
                "Shells (110)",
                "Spikes (113)",
                "Spikes (111)",
                "Large Medkit (112)",
                "Secret (105)",
                "Lightning (103)",
                "Large Medkit (117)",
                "Spikes (53)",
                "Large Medkit (49)",
                "Shells (54)",
                "Secret (43)",
                "Red Armor (45)",
                "Silver Key (38)",
                "Large Medkit (59)",
                "Spikes (50)",
                "Large Medkit (48)",
                "Large Medkit (56)",
                "Secret (135)",
                "Cells (136)",
                "Cells (137)",
                "Lightning (134)",
                "Spikes (115)",
                "Spikes (114)",
                "Large Medkit (116)",
                "Shells (37)",
                "Spikes (60)",
            ],
        )
        self.connect(jump_area, past_button_area, r.can_button & r.can_door)
        self.restrict("Secret (43)", r.can_shootswitch)
        self.restrict("Red Armor (45)", r.can_shootswitch)

        past_silver_door_area = self.region(
            "Past Silver Door",
            [
                "Large Medkit (36)",
                "Spikes (67)",
                "Large Medkit (65)",
                "Spikes (72)",
                "Shells (66)",
                "Large Medkit (55)",
                "Large Medkit (57)",
                "Green Armor (4)",
                "Large Medkit (68)",
                "Shells (71)",
                "Rockets (6)",
                "Large Medkit (58)",
                "Spikes (51)",
                "Spikes (52)",
                "Supernailgun (44)",
                "Large Medkit (69)",
                "Rocketlauncher (1)",
                "Rockets (70)",
                "Large Medkit (73)",
                "Large Medkit (141)",
                "Spikes (145)",
                "Large Medkit (146)",
                "Large Medkit (143)",
                "Large Medkit (149)",
                "Spikes (147)",
                "Spikes (148)",
                "Large Medkit (139)",
                "Shells (140)",
                "Large Medkit (142)",
                "Yellow Armor (5)",
                "Gold Key (133)",
                "Spikes (157)",
                "Spikes (155)",
                "Large Medkit (156)",
                "Shells (152)",
                "Large Medkit (153)",
                "Large Medkit (154)",
                "Lightning (151)",
            ],
        )
        self.connect(jump_area, past_silver_door_area, self.silver_key)

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Large Medkit (93)",
                "Shells (92)",
                "Spikes (82)",
                "Spikes (77)",
                "Large Medkit (90)",
                "Secret (41)",
                "Red Armor (46)",
            ],
        )
        self.connect(
            past_silver_door_area, past_gold_door_area, self.gold_key | r.bigjump_hard
        )

        self.connect(past_button_area, past_silver_door_area, r.bigjump_hard)
        self.connect(past_button_area, past_gold_door_area, r.bigjump_hard)

        past_gold_upper_area = self.region(
            "Past Gold Upper",
            [
                "Shells (75)",
                "Spikes (89)",
                "Large Medkit (94)",
                "Green Armor (47)",
                "Secret (42)",
                "Yellow Armor (63)",
                "Megahealth (62)",
                "Spikes (86)",
                "Spikes (78)",
                "Cells (83)",
                "Cells (76)",
                "Large Medkit (81)",
                "Secret (100)",
                "Cells (61)",
                "Cells (64)",
                "Large Medkit (85)",
            ],
        )
        self.connect(
            past_gold_door_area, past_gold_upper_area, r.can_button | r.bigjump_hard
        )
        self.restrict("Secret (42)", r.can_shootswitch | r.bigjump_hard)
        self.restrict("Megahealth (62)", r.can_shootswitch | r.bigjump_hard)
        self.restrict("Yellow Armor (63)", r.can_shootswitch | r.bigjump_hard)

        rune_area = self.region(
            "Rune Area",
            [
                "Sigil (39)",
                "Spikes (138)",
                "Spikes (150)",
                "Rockets (7)",
                "Large Medkit (144)",
                "Spikes (8)",
                "Large Medkit (74)",
                "Shells (96)",
                "Spikes (91)",
                "Megahealth (95)",
                "Cells (97)",
                "Spikes (87)",
                "Large Medkit (84)",
                "Spikes (99)",
                "Spikes (80)",
                "Spikes (102)",
                "Quad Damage (79)",
                "Shells (88)",
                "Shells (101)",
                "Large Medkit (98)",
                "Exit",
                "All Kills (158)",
            ],
        )
        self.connect(past_gold_upper_area, rune_area, r.can_button)
        self.restrict("All Kills (158)", r.difficult_combat)

        return ret
