from BaseClasses import Region

from ..base_classes import Q1Level


class hip3m4(Q1Level):
    name = "The Gauntlet"
    mapfile = "hip3m4"
    keys = ["Silver"]
    location_defs = [
        {
            "id": 1,
            "name": "Secret (1)",
            "classname": "trigger_secret",
            "uuid": 9387744509633072473,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Secret (2)",
            "classname": "trigger_secret",
            "uuid": 5057914639427431498,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Secret (3)",
            "classname": "trigger_secret",
            "uuid": 10324156029381095534,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Rocketlauncher (4)",
            "classname": "weapon_rocketlauncher",
            "uuid": 17040241769618601122,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Supernailgun (5)",
            "classname": "weapon_supernailgun",
            "uuid": 11799575941736853639,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Cells (6)",
            "classname": "item_cells",
            "uuid": 3988885287787065434,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Cells (7)",
            "classname": "item_cells",
            "uuid": 8329616855077517206,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Shells (8)",
            "classname": "item_shells",
            "uuid": 2746155995246334071,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Rockets (9)",
            "classname": "item_rockets",
            "uuid": 17011357436114269478,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Rockets (10)",
            "classname": "item_rockets",
            "uuid": 3852832621022009182,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Spikes (11)",
            "classname": "item_spikes",
            "uuid": 8681793078609215880,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Small Medkit (12)",
            "classname": "item_health",
            "uuid": 5159646508436354168,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Small Medkit (13)",
            "classname": "item_health",
            "uuid": 2825594273257677286,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Small Medkit (14)",
            "classname": "item_health",
            "uuid": 8297834417021311053,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Small Medkit (15)",
            "classname": "item_health",
            "uuid": 1034325708940533800,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Small Medkit (16)",
            "classname": "item_health",
            "uuid": 18004576471962902396,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Small Medkit (17)",
            "classname": "item_health",
            "uuid": 18432759206901858730,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Small Medkit (18)",
            "classname": "item_health",
            "uuid": 13714633680651729009,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Small Medkit (19)",
            "classname": "item_health",
            "uuid": 8534332049002007373,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Large Medkit (20)",
            "classname": "item_health",
            "uuid": 14027908121110731140,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Large Medkit (21)",
            "classname": "item_health",
            "uuid": 3963806838225846450,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Shells (22)",
            "classname": "item_shells",
            "uuid": 9615690800469409606,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Rockets (23)",
            "classname": "item_rockets",
            "uuid": 1698558360689476563,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Spikes (24)",
            "classname": "item_spikes",
            "uuid": 15740027024341712704,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Cells (25)",
            "classname": "item_cells",
            "uuid": 5524767723353682132,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Secret (26)",
            "classname": "trigger_secret",
            "uuid": 18197749311742685803,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Spikes (27)",
            "classname": "item_spikes",
            "uuid": 2787270847221611835,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Spikes (28)",
            "classname": "item_spikes",
            "uuid": 1813770643794862706,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Large Medkit (29)",
            "classname": "item_health",
            "uuid": 17568203099513216499,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Large Medkit (30)",
            "classname": "item_health",
            "uuid": 7485039048140264842,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Megahealth (31)",
            "classname": "item_health",
            "uuid": 12568918299854856738,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Shells (32)",
            "classname": "item_shells",
            "uuid": 5535812574990489555,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Small Medkit (33)",
            "classname": "item_health",
            "uuid": 7919078889421110982,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Shells (34)",
            "classname": "item_shells",
            "uuid": 10979943369216533320,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Small Medkit (35)",
            "classname": "item_health",
            "uuid": 11549632532392536631,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Red Armor (36)",
            "classname": "item_armorInv",
            "uuid": 1396724472869202823,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Secret (37)",
            "classname": "trigger_secret",
            "uuid": 6700590116786658697,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Large Medkit (38)",
            "classname": "item_health",
            "uuid": 3186733578450037201,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Large Medkit (39)",
            "classname": "item_health",
            "uuid": 1725532728056638227,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Shells (40)",
            "classname": "item_shells",
            "uuid": 18380031798815479585,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Spikes (41)",
            "classname": "item_spikes",
            "uuid": 3617390066642772780,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Shells (42)",
            "classname": "item_shells",
            "uuid": 6105352343440883888,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Rockets (43)",
            "classname": "item_rockets",
            "uuid": 12431616147150912987,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Large Medkit (44)",
            "classname": "item_health",
            "uuid": 2148782694152044433,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Large Medkit (45)",
            "classname": "item_health",
            "uuid": 6385835743741278179,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Rockets (46)",
            "classname": "item_rockets",
            "uuid": 14763319881347364253,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Rockets (47)",
            "classname": "item_rockets",
            "uuid": 5586042341911625550,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Spikes (48)",
            "classname": "item_spikes",
            "uuid": 859034263952895883,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Spikes (49)",
            "classname": "item_spikes",
            "uuid": 13930529402749922694,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Large Medkit (50)",
            "classname": "item_health",
            "uuid": 15173990922634789577,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Large Medkit (51)",
            "classname": "item_health",
            "uuid": 13141057200184566712,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Shells (52)",
            "classname": "item_shells",
            "uuid": 368037931261083617,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Shells (53)",
            "classname": "item_shells",
            "uuid": 7156715682850578658,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Quad Damage (54)",
            "classname": "item_artifact_super_damage",
            "uuid": 7426587054529819908,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Invulnerability (55)",
            "classname": "item_artifact_invulnerability",
            "uuid": 12447552409066275849,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Small Medkit (56)",
            "classname": "item_health",
            "uuid": 4680511414204995757,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Small Medkit (57)",
            "classname": "item_health",
            "uuid": 5909774451825626588,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Yellow Armor (58)",
            "classname": "item_armor2",
            "uuid": 4249559190500438492,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Rockets (59)",
            "classname": "item_rockets",
            "uuid": 16324929468545090974,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Small Medkit (60)",
            "classname": "item_health",
            "uuid": 6380330953897093340,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Small Medkit (61)",
            "classname": "item_health",
            "uuid": 10751095766203555101,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Shells (62)",
            "classname": "item_shells",
            "uuid": 12631301156641080951,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Spikes (63)",
            "classname": "item_spikes",
            "uuid": 5056142470830488425,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Rockets (64)",
            "classname": "item_rockets",
            "uuid": 5713141586010448158,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Cells (65)",
            "classname": "item_cells",
            "uuid": 14004339404308212505,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Large Medkit (66)",
            "classname": "item_health",
            "uuid": 13351235064799834506,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Large Medkit (67)",
            "classname": "item_health",
            "uuid": 5317443771327488385,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Large Medkit (68)",
            "classname": "item_health",
            "uuid": 1141505987064556317,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Large Medkit (69)",
            "classname": "item_health",
            "uuid": 9771446887338645859,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Secret (70)",
            "classname": "trigger_secret",
            "uuid": 5688581757760507435,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Yellow Armor (71)",
            "classname": "item_armor2",
            "uuid": 281188124121207394,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Large Medkit (72)",
            "classname": "item_health",
            "uuid": 18306817587771178135,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Large Medkit (73)",
            "classname": "item_health",
            "uuid": 13763701876370665282,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Large Medkit (74)",
            "classname": "item_health",
            "uuid": 11722817580925451222,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Large Medkit (75)",
            "classname": "item_health",
            "uuid": 13869714626930676850,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Shells (76)",
            "classname": "item_shells",
            "uuid": 3248187965830717161,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Shells (77)",
            "classname": "item_shells",
            "uuid": 9453657503971257182,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Rockets (78)",
            "classname": "item_rockets",
            "uuid": 8035184970403791651,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Rockets (79)",
            "classname": "item_rockets",
            "uuid": 7236996642691990996,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Spikes (80)",
            "classname": "item_spikes",
            "uuid": 2819351558638958747,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Cells (81)",
            "classname": "item_cells",
            "uuid": 14359671047806859491,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Cells (82)",
            "classname": "item_cells",
            "uuid": 18290875966571823669,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Shells (83)",
            "classname": "item_shells",
            "uuid": 2379643465861085816,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Large Medkit (84)",
            "classname": "item_health",
            "uuid": 12202843819190301547,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Large Medkit (85)",
            "classname": "item_health",
            "uuid": 6174692470832857023,
            "mp": 0,
        },
        {
            "id": 86,
            "name": "Supershotgun (86)",
            "classname": "weapon_supershotgun",
            "uuid": 8752932814856697492,
            "mp": 1,
        },
        {
            "id": 87,
            "name": "Nailgun (87)",
            "classname": "weapon_nailgun",
            "uuid": 9235962555032529914,
            "mp": 1,
        },
        {
            "id": 88,
            "name": "Empathy (88)",
            "classname": "item_artifact_empathy_shields",
            "uuid": 9738310868916474302,
            "mp": 1,
        },
        {
            "id": 89,
            "name": "Grenadelauncher (89)",
            "classname": "weapon_grenadelauncher",
            "uuid": 1718613006971947669,
            "mp": 1,
        },
        {
            "id": 90,
            "name": "Rocketlauncher (90)",
            "classname": "weapon_rocketlauncher",
            "uuid": 3529009889854591394,
            "mp": 1,
        },
        {
            "id": 91,
            "name": "Mjolnir (91)",
            "classname": "weapon_mjolnir",
            "uuid": 11213707386545718408,
            "mp": 1,
        },
        {
            "id": 92,
            "name": "Laser (92)",
            "classname": "weapon_laser_gun",
            "uuid": 13583235136243959860,
            "mp": 1,
        },
        {
            "id": 93,
            "name": "Megahealth (93)",
            "classname": "item_health",
            "uuid": 11748861452009701066,
            "mp": 0,
        },
        {
            "id": 94,
            "name": "Spikes (94)",
            "classname": "item_spikes",
            "uuid": 12895582328427574602,
            "mp": 0,
        },
        {
            "id": 95,
            "name": "Spikes (95)",
            "classname": "item_spikes",
            "uuid": 17763625789609997207,
            "mp": 0,
        },
        {
            "id": 96,
            "name": "Supershotgun (96)",
            "classname": "weapon_supershotgun",
            "uuid": 8915948439017138304,
            "mp": 0,
        },
        {
            "id": 97,
            "name": "Spikes (97)",
            "classname": "item_spikes",
            "uuid": 16612309983627123520,
            "mp": 0,
        },
        {
            "id": 98,
            "name": "Shells (98)",
            "classname": "item_shells",
            "uuid": 8108857614790677112,
            "mp": 0,
        },
        {
            "id": 99,
            "name": "Lightning (99)",
            "classname": "weapon_lightning",
            "uuid": 16337270561675731497,
            "mp": 0,
        },
        {
            "id": 100,
            "name": "Silver Key (100)",
            "classname": "item_key1",
            "uuid": 7496349403964391488,
            "mp": 0,
        },
        {
            "id": 101,
            "name": "Invisibility (101)",
            "classname": "item_artifact_invisibility",
            "uuid": 7815516353483310706,
            "mp": 0,
        },
        {
            "id": 102,
            "name": "Proximity (102)",
            "classname": "weapon_proximity_gun",
            "uuid": 10488363928385877153,
            "mp": 1,
        },
        {
            "id": 103,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 13019172088417136261,
            "mp": 0,
        },
        {
            "id": 104,
            "name": "All Kills (104)",
            "classname": "all_kills",
            "uuid": 4236181338959832682,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Rockets (10)",
                "Supernailgun (5)",
                "Rockets (9)",
                "Spikes (97)",
                "Rocketlauncher (4)",
                "Shells (98)",
                "Small Medkit (14)",
                "Small Medkit (15)",
                "Small Medkit (13)",
                "Small Medkit (12)",
                "Cells (7)",
                "Lightning (99)",
                "Cells (6)",
                "Shells (8)",
                "Supershotgun (96)",
                "Spikes (11)",
                "Secret (37)",
                "Red Armor (36)",
            ],
        )

        self.restrict("Secret (37)", r.can_shootswitch & r.can_button)
        self.restrict("Red Armor (36)", r.can_shootswitch & r.can_button)

        past_door_area = self.region(
            "Past Door Area",
            [
                "Small Medkit (16)",
                "Small Medkit (17)",
                "Small Medkit (18)",
                "Small Medkit (19)",
                "Supershotgun (86)",
            ],
        )
        self.connect(ret, past_door_area, r.can_door)

        shootswitch_area = self.region(
            "Shootswitch Area",
            [
                "Nailgun (87)",
                "Large Medkit (21)",
                "Large Medkit (20)",
                "Cells (25)",
                "Spikes (24)",
                "Rockets (23)",
                "Shells (22)",
            ],
        )
        self.connect(past_door_area, shootswitch_area, r.can_shootswitch)

        past_elevator_area = self.region(
            "Past Elevator Area",
            [
                "Spikes (27)",
                "Spikes (28)",
                "Large Medkit (29)",
                "Large Medkit (30)",
                "Empathy (88)",
                "Shells (32)",
                "Small Medkit (35)",
                "Small Medkit (33)",
                "Shells (34)",
                "Secret (26)",
                "Megahealth (31)",
                "Shells (42)",
                "Rockets (43)",
                "Shells (40)",
                "Spikes (41)",
                "Large Medkit (38)",
                "Large Medkit (39)",
                "Grenadelauncher (89)",
            ],
        )
        self.connect(
            shootswitch_area,
            past_elevator_area,
            r.can_button | (r.bigjump_hard & r.quad_dmg(1) & r.invuln(1)),
        )

        self.restrict("Secret (26)", r.can_shootswitch)
        self.restrict("Megahealth (31)", r.can_shootswitch)

        past_button_area = self.region(
            "Past Button Area",
            [
                "Silver Key (100)",
                "Proximity (102)",
                "Invisibility (101)",
            ],
        )
        self.connect(past_elevator_area, past_button_area, r.can_button)

        past_silver_door_area = self.region(
            "Past Silver Door",
            [
                "Spikes (49)",
                "Spikes (48)",
                "Rockets (47)",
                "Rockets (46)",
                "Large Medkit (44)",
                "Large Medkit (45)",
                "Large Medkit (51)",
                "Large Medkit (50)",
                "Shells (53)",
                "Shells (52)",
                "Rocketlauncher (90)",
                "Secret (3)",
                "Quad Damage (54)",
                "Small Medkit (57)",
                "Small Medkit (56)",
                "Small Medkit (61)",
                "Small Medkit (60)",
                "Large Medkit (66)",
                "Large Medkit (67)",
                "Large Medkit (68)",
                "Large Medkit (69)",
                "Spikes (63)",
                "Rockets (64)",
                "Shells (62)",
                "Cells (65)",
            ],
        )
        self.connect(past_button_area, past_silver_door_area, self.silver_key)

        self.restrict("Secret (3)", r.can_shootswitch)
        self.restrict("Quad Damage (54)", r.can_shootswitch | r.bigjump_hard)

        dive_area = self.region(
            "Dive Area",
            [
                "Secret (1)",
                "Yellow Armor (58)",
                "Rockets (59)",
                "Large Medkit (73)",
                "Large Medkit (72)",
                "Mjolnir (91)",
                "Yellow Armor (71)",
                "Shells (77)",
                "Shells (76)",
                "Large Medkit (74)",
                "Large Medkit (75)",
                "Rockets (78)",
                "Rockets (79)",
                "Spikes (80)",
                "Large Medkit (84)",
                "Laser (92)",
                "Shells (83)",
                "Cells (82)",
                "Cells (81)",
                "Large Medkit (85)",
                "Exit",
                "Secret (70)",
                "Spikes (95)",
                "Megahealth (93)",
                "Spikes (94)",
                "Secret (2)",
                "Invulnerability (55)",
                "All Kills (104)",
            ],
        )
        self.connect(past_silver_door_area, dive_area, r.can_dive)

        self.restrict("Secret (2)", r.jump & r.can_button)
        self.restrict("Invulnerability (55)", r.jump & r.can_button)

        self.restrict("All Kills (104)", r.difficult_combat)

        return ret
