from BaseClasses import Region

from ..base_classes import Q1Level


class hip3m3(Q1Level):
    name = "Limbo"
    mapfile = "hip3m3"
    keys = ["Silver", "Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Wetsuit (1)",
            "classname": "item_artifact_wetsuit",
            "uuid": 8314995097005977963,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 5881207877853220534,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Small Medkit (3)",
            "classname": "item_health",
            "uuid": 13239524844637863053,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Gold Key (4)",
            "classname": "item_key2",
            "uuid": 15629958972477063103,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Silver Key (5)",
            "classname": "item_key1",
            "uuid": 3092111049982283919,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Supershotgun (6)",
            "classname": "weapon_supershotgun",
            "uuid": 5305364070854580930,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Shells (7)",
            "classname": "item_shells",
            "uuid": 11499599557725020446,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Shells (8)",
            "classname": "item_shells",
            "uuid": 1667719399370381761,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Shells (9)",
            "classname": "item_shells",
            "uuid": 14624157701187610516,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Large Medkit (10)",
            "classname": "item_health",
            "uuid": 1037307142084952351,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Shells (11)",
            "classname": "item_shells",
            "uuid": 12705235411135648075,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Large Medkit (12)",
            "classname": "item_health",
            "uuid": 14151987797356559113,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Large Medkit (13)",
            "classname": "item_health",
            "uuid": 17328748088015371515,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Shells (14)",
            "classname": "item_shells",
            "uuid": 11780893207302084524,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Large Medkit (15)",
            "classname": "item_health",
            "uuid": 2674954683687980681,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Large Medkit (16)",
            "classname": "item_health",
            "uuid": 2178443939228433529,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Shells (17)",
            "classname": "item_shells",
            "uuid": 723642618976260297,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Grenadelauncher (18)",
            "classname": "weapon_grenadelauncher",
            "uuid": 10283472298738014607,
            "mp": 1,
        },
        {
            "id": 19,
            "name": "Small Medkit (19)",
            "classname": "item_health",
            "uuid": 15124744144236202409,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Quad Damage (20)",
            "classname": "item_artifact_super_damage",
            "uuid": 2863898088063684186,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Supernailgun (21)",
            "classname": "weapon_supernailgun",
            "uuid": 5408593036035185299,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Small Medkit (22)",
            "classname": "item_health",
            "uuid": 9256018045629885788,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Spikes (23)",
            "classname": "item_spikes",
            "uuid": 4422739539196646779,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Shells (24)",
            "classname": "item_shells",
            "uuid": 2182414285232420291,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Spikes (25)",
            "classname": "item_spikes",
            "uuid": 13309455556859195690,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Small Medkit (26)",
            "classname": "item_health",
            "uuid": 2019650790022814039,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Small Medkit (27)",
            "classname": "item_health",
            "uuid": 5139577665110660475,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Shells (28)",
            "classname": "item_shells",
            "uuid": 7140391609914230521,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Spikes (29)",
            "classname": "item_spikes",
            "uuid": 16588007656181629424,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Large Medkit (30)",
            "classname": "item_health",
            "uuid": 13857619325680519304,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Large Medkit (31)",
            "classname": "item_health",
            "uuid": 7063079174635075374,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Shells (32)",
            "classname": "item_shells",
            "uuid": 17857752771356642318,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Small Medkit (33)",
            "classname": "item_health",
            "uuid": 14601132959459496350,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Small Medkit (34)",
            "classname": "item_health",
            "uuid": 13246311332178717038,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Shells (35)",
            "classname": "item_shells",
            "uuid": 12966261070293236067,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Shells (36)",
            "classname": "item_shells",
            "uuid": 15046850121981752905,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Spikes (37)",
            "classname": "item_spikes",
            "uuid": 1761352753733455180,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Spikes (38)",
            "classname": "item_spikes",
            "uuid": 7233579236520395703,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Small Medkit (39)",
            "classname": "item_health",
            "uuid": 13298648287176868637,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Small Medkit (40)",
            "classname": "item_health",
            "uuid": 2527097745330873826,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Green Armor (41)",
            "classname": "item_armor1",
            "uuid": 7336999305005789830,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Large Medkit (42)",
            "classname": "item_health",
            "uuid": 10282708354974843827,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Large Medkit (43)",
            "classname": "item_health",
            "uuid": 6485038837124688713,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Shells (44)",
            "classname": "item_shells",
            "uuid": 12527262494460138206,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Spikes (45)",
            "classname": "item_spikes",
            "uuid": 17583668861266379706,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Shells (46)",
            "classname": "item_shells",
            "uuid": 935644488558969412,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Spikes (47)",
            "classname": "item_spikes",
            "uuid": 15414625983838815922,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Spikes (48)",
            "classname": "item_spikes",
            "uuid": 2533459689148696236,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Shells (49)",
            "classname": "item_shells",
            "uuid": 15178681187724291321,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Large Medkit (50)",
            "classname": "item_health",
            "uuid": 3730630227444829527,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Large Medkit (51)",
            "classname": "item_health",
            "uuid": 614065945069876575,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Shells (52)",
            "classname": "item_shells",
            "uuid": 518677314387914329,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Shells (53)",
            "classname": "item_shells",
            "uuid": 807596656313785671,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Small Medkit (54)",
            "classname": "item_health",
            "uuid": 1507877741808963111,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Small Medkit (55)",
            "classname": "item_health",
            "uuid": 10928818649682604468,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Cells (56)",
            "classname": "item_cells",
            "uuid": 10942663239163210871,
            "mp": 1,
        },
        {
            "id": 57,
            "name": "Cells (57)",
            "classname": "item_cells",
            "uuid": 3745503445853411724,
            "mp": 1,
        },
        {
            "id": 58,
            "name": "Nailgun (58)",
            "classname": "weapon_nailgun",
            "uuid": 10808368241664075500,
            "mp": 1,
        },
        {
            "id": 59,
            "name": "Invisibility (59)",
            "classname": "item_artifact_invisibility",
            "uuid": 16479788330969685439,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Red Armor (60)",
            "classname": "item_armorInv",
            "uuid": 16080178833510678049,
            "mp": 1,
        },
        {
            "id": 61,
            "name": "Invulnerability (61)",
            "classname": "item_artifact_invulnerability",
            "uuid": 9318729636395859721,
            "mp": 1,
        },
        {
            "id": 62,
            "name": "Rocketlauncher (62)",
            "classname": "weapon_rocketlauncher",
            "uuid": 17856123862201814232,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Rockets (63)",
            "classname": "item_rockets",
            "uuid": 7522230179202002925,
            "mp": 1,
        },
        {
            "id": 64,
            "name": "Rockets (64)",
            "classname": "item_rockets",
            "uuid": 13436954390089891208,
            "mp": 1,
        },
        {
            "id": 65,
            "name": "Supershotgun (65)",
            "classname": "weapon_supershotgun",
            "uuid": 17914871224563565758,
            "mp": 1,
        },
        {
            "id": 66,
            "name": "Yellow Armor (66)",
            "classname": "item_armor2",
            "uuid": 15939882859893921120,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Secret (67)",
            "classname": "trigger_secret",
            "uuid": 4314544962261754990,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Megahealth (68)",
            "classname": "item_health",
            "uuid": 14664875378147155468,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Secret (69)",
            "classname": "trigger_secret",
            "uuid": 16025497231700682594,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Shells (70)",
            "classname": "item_shells",
            "uuid": 9990243235873357981,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Shells (71)",
            "classname": "item_shells",
            "uuid": 13547158771769212139,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Spikes (72)",
            "classname": "item_spikes",
            "uuid": 15221546897948789957,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Shells (73)",
            "classname": "item_shells",
            "uuid": 3179495585455375072,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Shells (74)",
            "classname": "item_shells",
            "uuid": 8308364090206754228,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Spikes (75)",
            "classname": "item_spikes",
            "uuid": 7166380273850293146,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Shells (76)",
            "classname": "item_shells",
            "uuid": 17663985209892390562,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Rockets (77)",
            "classname": "item_rockets",
            "uuid": 9310214651784327903,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Shells (78)",
            "classname": "item_shells",
            "uuid": 3471114633205277071,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Spikes (79)",
            "classname": "item_spikes",
            "uuid": 7040707764275376748,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Cells (80)",
            "classname": "item_cells",
            "uuid": 3905803583416414398,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Mjolnir (81)",
            "classname": "weapon_mjolnir",
            "uuid": 11133729764505376285,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Secret (82)",
            "classname": "trigger_secret",
            "uuid": 17314523403866308198,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Large Medkit (83)",
            "classname": "item_health",
            "uuid": 6416754213674805673,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Large Medkit (84)",
            "classname": "item_health",
            "uuid": 17015738609230329551,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Laser (85)",
            "classname": "weapon_laser_gun",
            "uuid": 12731979485445012595,
            "mp": 1,
        },
        {
            "id": 86,
            "name": "Secret (86)",
            "classname": "trigger_secret",
            "uuid": 10641256883636095568,
            "mp": 0,
        },
        {
            "id": 87,
            "name": "Secret Exit",
            "classname": "trigger_changelevel",
            "uuid": 12787080439773799364,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Proximity (88)",
            "classname": "weapon_proximity_gun",
            "uuid": 4549160823494289426,
            "mp": 1,
        },
        {
            "id": 89,
            "name": "Large Medkit (89)",
            "classname": "item_health",
            "uuid": 9002812272934220578,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "All Kills (90)",
            "classname": "all_kills",
            "uuid": 7707846608834451491,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Small Medkit (3)",
                "Supershotgun (6)",
                "Shells (7)",
                "Large Medkit (89)",
                "Large Medkit (13)",
                "Large Medkit (10)",
                "Shells (9)",
                "Spikes (75)",
                "Shells (11)",
                "Large Medkit (12)",
                "Red Armor (60)",
                "Shells (76)",
                "Shells (14)",
                "Shells (24)",
                "Spikes (25)",
                "Supernailgun (21)",
                "Small Medkit (22)",
                "Small Medkit (19)",
                "Quad Damage (20)",
                "Spikes (23)",
                "Shells (74)",
                "Shells (71)",
                "Shells (70)",
                "Grenadelauncher (18)",
                "Shells (17)",
                "Large Medkit (15)",
                "Large Medkit (16)",
                "Shells (8)",
                "Large Medkit (30)",
                "Small Medkit (27)",
                "Large Medkit (31)",
                "Small Medkit (26)",
                "Spikes (29)",
                "Shells (28)",
                "Supershotgun (65)",
                "Large Medkit (84)",
                "Large Medkit (83)",
                "Shells (32)",
                "Small Medkit (34)",
                "Small Medkit (33)",
                "Shells (35)",
                "Shells (36)",
                "Green Armor (41)",
                "Rockets (63)",
                "Rocketlauncher (62)",
                "Rockets (64)",
                "Spikes (38)",
                "Spikes (37)",
                "Small Medkit (40)",
                "Small Medkit (39)",
                "Silver Key (5)",
                "Wetsuit (1)",
                "Shells (73)",
                "Spikes (72)",
                "Nailgun (58)",
                "Shells (46)",
                "Spikes (47)",
                "Spikes (48)",
                "Shells (49)",
                "Invulnerability (61)",
                "Secret (69)",
                "Megahealth (68)",
                "Invisibility (59)",
            ],
        )

        self.restrict(
            "Invulnerability (61)", r.jump | (self.silver_key & r.can_shootswitch)
        )
        self.restrict("Secret (69)", r.can_dive & r.can_shootswitch)
        self.restrict("Megahealth (68)", r.can_dive & r.can_shootswitch)
        self.restrict("Invisibility (59)", r.can_dive)

        shootswitch_area = self.region(
            "Shootswitch Area",
            [
                "Secret (82)",
                "Mjolnir (81)",
                "Spikes (79)",
                "Cells (80)",
                "Shells (78)",
                "Rockets (77)",
            ],
        )
        self.connect(ret, shootswitch_area, r.can_shootswitch)

        past_silver_door_area = self.region(
            "Past Silver Door",
            [
                "Secret (67)",
                "Yellow Armor (66)",
                "Gold Key (4)",
                "Shells (44)",
                "Large Medkit (42)",
                "Spikes (45)",
                "Large Medkit (43)",
                "Proximity (88)",
                "Secret (86)",
                "Secret Exit",
            ],
        )
        self.connect(ret, past_silver_door_area, self.silver_key)

        self.restrict("Secret (67)", r.can_shootswitch)
        self.restrict("Yellow Armor (66)", r.can_shootswitch)
        self.restrict("Proximity (88)", r.can_shootswitch)
        self.restrict("Secret (86)", r.can_shootswitch)
        self.restrict("Secret Exit", r.can_shootswitch)

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Large Medkit (51)",
                "Shells (52)",
                "Cells (57)",
                "Small Medkit (55)",
                "Small Medkit (54)",
                "Laser (85)",
                "Cells (56)",
                "Shells (53)",
                "Large Medkit (50)",
                "Exit",
                "All Kills (90)",
            ],
        )
        self.connect(ret, past_gold_door_area, self.gold_key)

        self.restrict("All Kills (90)", r.difficult_combat & r.can_dive)

        return ret
