from BaseClasses import Region

from ..base_classes import Q1Level


class e4m5(Q1Level):
    name = "Hell's Atrium"
    mapfile = "e4m5"
    keys = ["Silver", "Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Rockets (1)",
            "classname": "item_rockets",
            "uuid": 8161939133390255812,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Spikes (2)",
            "classname": "item_spikes",
            "uuid": 13491628476023577963,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Small Medkit (3)",
            "classname": "item_health",
            "uuid": 1808278149228265356,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Spikes (4)",
            "classname": "item_spikes",
            "uuid": 5025501643354958147,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Shells (5)",
            "classname": "item_shells",
            "uuid": 17435463348604772435,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Rockets (6)",
            "classname": "item_rockets",
            "uuid": 6666107298267734006,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Large Medkit (7)",
            "classname": "item_health",
            "uuid": 17879618415139387863,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Spikes (8)",
            "classname": "item_spikes",
            "uuid": 14621968111809995981,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Large Medkit (9)",
            "classname": "item_health",
            "uuid": 1045278727024662748,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Shells (10)",
            "classname": "item_shells",
            "uuid": 3347761364730712526,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Spikes (11)",
            "classname": "item_spikes",
            "uuid": 17076069934135495554,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Rockets (12)",
            "classname": "item_rockets",
            "uuid": 4434058788605067993,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Small Medkit (13)",
            "classname": "item_health",
            "uuid": 16386471302325347803,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Spikes (14)",
            "classname": "item_spikes",
            "uuid": 12132704640572498701,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Rockets (15)",
            "classname": "item_rockets",
            "uuid": 12739141830604164259,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Spikes (16)",
            "classname": "item_spikes",
            "uuid": 14657096448642656851,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Small Medkit (17)",
            "classname": "item_health",
            "uuid": 3570129696941228310,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Megahealth (18)",
            "classname": "item_health",
            "uuid": 14518266131207408495,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Green Armor (19)",
            "classname": "item_armor1",
            "uuid": 4840092942749344856,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Large Medkit (20)",
            "classname": "item_health",
            "uuid": 16771445086912835354,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Large Medkit (21)",
            "classname": "item_health",
            "uuid": 4412686906695960086,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Green Armor (22)",
            "classname": "item_armor1",
            "uuid": 17993595876361981389,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Silver Key (23)",
            "classname": "item_key1",
            "uuid": 4354385593275119282,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Large Medkit (24)",
            "classname": "item_health",
            "uuid": 7417916626501590930,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Large Medkit (25)",
            "classname": "item_health",
            "uuid": 15095008745099467929,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Spikes (26)",
            "classname": "item_spikes",
            "uuid": 8234279409630584985,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Large Medkit (27)",
            "classname": "item_health",
            "uuid": 6511149891415216160,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Large Medkit (28)",
            "classname": "item_health",
            "uuid": 15496233879939019128,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Spikes (29)",
            "classname": "item_spikes",
            "uuid": 13807023517284608557,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Large Medkit (30)",
            "classname": "item_health",
            "uuid": 10544244194265626863,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Large Medkit (31)",
            "classname": "item_health",
            "uuid": 2367132946184317439,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Large Medkit (32)",
            "classname": "item_health",
            "uuid": 1193676354910215332,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Quad Damage (33)",
            "classname": "item_artifact_super_damage",
            "uuid": 15317698532512469547,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Quad Damage (34)",
            "classname": "item_artifact_super_damage",
            "uuid": 5675174658815543384,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Large Medkit (35)",
            "classname": "item_health",
            "uuid": 6652528998272421368,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Invisibility (36)",
            "classname": "item_artifact_invisibility",
            "uuid": 12680959200273809882,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Spikes (37)",
            "classname": "item_spikes",
            "uuid": 15424103511997135019,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Supernailgun (38)",
            "classname": "weapon_supernailgun",
            "uuid": 12063374823822071126,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Lightning (39)",
            "classname": "weapon_lightning",
            "uuid": 2641494598879451503,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Spikes (40)",
            "classname": "item_spikes",
            "uuid": 2643873854999078443,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Invulnerability (41)",
            "classname": "item_artifact_invulnerability",
            "uuid": 10894999635273919750,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Yellow Armor (42)",
            "classname": "item_armor2",
            "uuid": 12684950786831928868,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Large Medkit (43)",
            "classname": "item_health",
            "uuid": 8443321937084249994,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Quad Damage (44)",
            "classname": "item_artifact_super_damage",
            "uuid": 2398821789589215451,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Cells (45)",
            "classname": "item_cells",
            "uuid": 11028104359781291270,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Secret (46)",
            "classname": "trigger_secret",
            "uuid": 13781500203553492055,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Small Medkit (47)",
            "classname": "item_health",
            "uuid": 17389596169310817171,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Rockets (48)",
            "classname": "item_rockets",
            "uuid": 540605585100148460,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Cells (49)",
            "classname": "item_cells",
            "uuid": 12969185242613437907,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Small Medkit (50)",
            "classname": "item_health",
            "uuid": 1197084994350467091,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Secret (51)",
            "classname": "trigger_secret",
            "uuid": 15880849975342188398,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Cells (52)",
            "classname": "item_cells",
            "uuid": 15095831035493410477,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Cells (53)",
            "classname": "item_cells",
            "uuid": 16251432688134678841,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Secret (54)",
            "classname": "trigger_secret",
            "uuid": 8733607022515286341,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Cells (55)",
            "classname": "item_cells",
            "uuid": 11779188703036772724,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Rocketlauncher (56)",
            "classname": "weapon_rocketlauncher",
            "uuid": 7099957347590222707,
            "mp": 1,
        },
        {
            "id": 57,
            "name": "Supershotgun (57)",
            "classname": "weapon_supershotgun",
            "uuid": 10022740845376845005,
            "mp": 1,
        },
        {
            "id": 58,
            "name": "Lightning (58)",
            "classname": "weapon_lightning",
            "uuid": 8241092999985509963,
            "mp": 1,
        },
        {
            "id": 59,
            "name": "Invulnerability (59)",
            "classname": "item_artifact_invulnerability",
            "uuid": 1234798495592024084,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Rockets (60)",
            "classname": "item_rockets",
            "uuid": 14996797245146133666,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Gold Key (61)",
            "classname": "item_key2",
            "uuid": 6277335796364297716,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Spikes (62)",
            "classname": "item_spikes",
            "uuid": 10751703866383378601,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Nailgun (63)",
            "classname": "weapon_nailgun",
            "uuid": 9695577886701586107,
            "mp": 1,
        },
        {
            "id": 64,
            "name": "Grenadelauncher (64)",
            "classname": "weapon_grenadelauncher",
            "uuid": 9970763610074328972,
            "mp": 1,
        },
        {
            "id": 65,
            "name": "Nailgun (65)",
            "classname": "weapon_nailgun",
            "uuid": 14470730654642654203,
            "mp": 1,
        },
        {
            "id": 66,
            "name": "Supernailgun (66)",
            "classname": "weapon_supernailgun",
            "uuid": 603375821052250938,
            "mp": 1,
        },
        {
            "id": 67,
            "name": "Grenadelauncher (67)",
            "classname": "weapon_grenadelauncher",
            "uuid": 1735165329437978398,
            "mp": 1,
        },
        {
            "id": 68,
            "name": "Red Armor (68)",
            "classname": "item_armorInv",
            "uuid": 18256493905993341618,
            "mp": 1,
        },
        {
            "id": 69,
            "name": "Supershotgun (69)",
            "classname": "weapon_supershotgun",
            "uuid": 8389264707121695884,
            "mp": 1,
        },
        {
            "id": 70,
            "name": "Rocketlauncher (70)",
            "classname": "weapon_rocketlauncher",
            "uuid": 2743234692566050457,
            "mp": 1,
        },
        {
            "id": 71,
            "name": "Cells (71)",
            "classname": "item_cells",
            "uuid": 2787811339459765897,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Secret Exit",
            "classname": "trigger_changelevel",
            "uuid": 17817342093876435718,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 7441735596130205534,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Large Medkit (74)",
            "classname": "item_health",
            "uuid": 14625429268055828967,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Secret (75)",
            "classname": "trigger_secret",
            "uuid": 17444963352301679029,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Quad Damage (76)",
            "classname": "item_artifact_super_damage",
            "uuid": 13725180225560008633,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Cells (77)",
            "classname": "item_cells",
            "uuid": 11886087936658553140,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Megahealth (78)",
            "classname": "item_health",
            "uuid": 4617480567818381766,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Large Medkit (79)",
            "classname": "item_health",
            "uuid": 8122445128422078206,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Spikes (80)",
            "classname": "item_spikes",
            "uuid": 1856302162034986461,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Grenadelauncher (81)",
            "classname": "weapon_grenadelauncher",
            "uuid": 9200380220499145421,
            "mp": 1,
        },
        {
            "id": 82,
            "name": "Supershotgun (82)",
            "classname": "weapon_supershotgun",
            "uuid": 11066652410147767262,
            "mp": 1,
        },
        {
            "id": 83,
            "name": "Supernailgun (83)",
            "classname": "weapon_supernailgun",
            "uuid": 9768772311037119953,
            "mp": 1,
        },
        {
            "id": 84,
            "name": "Nailgun (84)",
            "classname": "weapon_nailgun",
            "uuid": 367800907972515758,
            "mp": 1,
        },
        {
            "id": 85,
            "name": "Grenadelauncher (85)",
            "classname": "weapon_grenadelauncher",
            "uuid": 16605953708255262245,
            "mp": 1,
        },
        {
            "id": 86,
            "name": "Supershotgun (86)",
            "classname": "weapon_supershotgun",
            "uuid": 13746873391902316072,
            "mp": 1,
        },
        {
            "id": 87,
            "name": "Nailgun (87)",
            "classname": "weapon_nailgun",
            "uuid": 5786364044721852797,
            "mp": 1,
        },
        {
            "id": 88,
            "name": "Invulnerability (88)",
            "classname": "item_artifact_invulnerability",
            "uuid": 8319591710663307983,
            "mp": 1,
        },
        {
            "id": 89,
            "name": "Cells (89)",
            "classname": "item_cells",
            "uuid": 7279876840043409372,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "Cells (90)",
            "classname": "item_cells",
            "uuid": 9422453083925469063,
            "mp": 0,
        },
        {
            "id": 91,
            "name": "Spikes (91)",
            "classname": "item_spikes",
            "uuid": 2815013287589174769,
            "mp": 0,
        },
        {
            "id": 92,
            "name": "Spikes (92)",
            "classname": "item_spikes",
            "uuid": 1282465050452528092,
            "mp": 0,
        },
        {
            "id": 93,
            "name": "Quad Damage (93)",
            "classname": "item_artifact_super_damage",
            "uuid": 3073537734543208956,
            "mp": 0,
        },
        {
            "id": 94,
            "name": "Cells (94)",
            "classname": "item_cells",
            "uuid": 18179768052753993830,
            "mp": 0,
        },
        {
            "id": 95,
            "name": "Cells (95)",
            "classname": "item_cells",
            "uuid": 2199303620522173429,
            "mp": 0,
        },
        {
            "id": 96,
            "name": "Cells (96)",
            "classname": "item_cells",
            "uuid": 2003441290654167220,
            "mp": 0,
        },
        {
            "id": 97,
            "name": "Spikes (97)",
            "classname": "item_spikes",
            "uuid": 7610877192278232212,
            "mp": 0,
        },
        {
            "id": 98,
            "name": "Shells (98)",
            "classname": "item_shells",
            "uuid": 8879842786867728404,
            "mp": 0,
        },
        {
            "id": 99,
            "name": "Rockets (99)",
            "classname": "item_rockets",
            "uuid": 14492444267053972437,
            "mp": 0,
        },
        {
            "id": 100,
            "name": "Shells (100)",
            "classname": "item_shells",
            "uuid": 6449568166769872510,
            "mp": 0,
        },
        {
            "id": 101,
            "name": "Spikes (101)",
            "classname": "item_spikes",
            "uuid": 9644946812250985492,
            "mp": 0,
        },
        {
            "id": 102,
            "name": "Rockets (102)",
            "classname": "item_rockets",
            "uuid": 11861176160442467213,
            "mp": 0,
        },
        {
            "id": 103,
            "name": "Spikes (103)",
            "classname": "item_spikes",
            "uuid": 5040856394841756205,
            "mp": 0,
        },
        {
            "id": 104,
            "name": "Small Medkit (104)",
            "classname": "item_health",
            "uuid": 11801489522306283137,
            "mp": 0,
        },
        {
            "id": 105,
            "name": "Rockets (105)",
            "classname": "item_rockets",
            "uuid": 17808934013882856890,
            "mp": 0,
        },
        {
            "id": 106,
            "name": "Rockets (106)",
            "classname": "item_rockets",
            "uuid": 4156512554818751218,
            "mp": 0,
        },
        {
            "id": 107,
            "name": "Rockets (107)",
            "classname": "item_rockets",
            "uuid": 17975489749015790271,
            "mp": 0,
        },
        {
            "id": 108,
            "name": "Rockets (108)",
            "classname": "item_rockets",
            "uuid": 10928914243180112764,
            "mp": 0,
        },
        {
            "id": 109,
            "name": "Cells (109)",
            "classname": "item_cells",
            "uuid": 8663859905817736923,
            "mp": 0,
        },
        {
            "id": 110,
            "name": "Cells (110)",
            "classname": "item_cells",
            "uuid": 579400338949597409,
            "mp": 0,
        },
        {
            "id": 111,
            "name": "Invisibility (111)",
            "classname": "item_artifact_invisibility",
            "uuid": 9863282034063722507,
            "mp": 0,
        },
        {
            "id": 112,
            "name": "All Kills (112)",
            "classname": "all_kills",
            "uuid": 3601103039809412638,
            "mp": 0,
        },
    ]

    must_bio = True

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Megahealth (78)",
                "Grenadelauncher (67)",
                "Supershotgun (82)",
                "Spikes (2)",
                "Large Medkit (35)",
                "Invisibility (111)",
                "Large Medkit (30)",
                "Quad Damage (34)",
                "Green Armor (22)",
                "Supershotgun (69)",
                "Supernailgun (83)",
                "Spikes (37)",
                "Rockets (1)",
                "Spikes (62)",
                "Nailgun (65)",
                "Rockets (102)",
                "Large Medkit (25)",
                "Large Medkit (24)",
                "Large Medkit (32)",
                "Large Medkit (31)",
                "Spikes (101)",
                "Grenadelauncher (81)",
                "Red Armor (68)",
                "Gold Key (61)",
                "Rockets (6)",
                "Rockets (105)",
                "Spikes (16)",
                "Spikes (91)",
            ],
        )
        self.restrict("Spikes (91)", r.can_door)

        final_area = self.region(
            "Final Area",
            [
                "Exit",
                "Secret Exit",
            ],
        )
        self.connect(
            ret,
            final_area,
            (r.can_jump & r.difficulty("hard"))
            | r.can_rj_hard
            | r.can_gj_extr
            | (self.silver_key & r.can_jump),
        )

        self.restrict("Exit", r.can_door)
        self.restrict("Secret Exit", self.silver_key)

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Shells (5)",
                "Small Medkit (17)",
                "Nailgun (84)",
                "Supernailgun (38)",
                "Spikes (14)",
                "Nailgun (63)",
                "Rockets (15)",
                "Large Medkit (79)",
                "Spikes (80)",
                "Spikes (92)",
                "Invisibility (36)",
            ],
        )
        self.connect(ret, past_gold_door_area, self.gold_key)
        self.restrict("Spikes (92)", r.can_shootswitch)
        self.restrict("Invisibility (36)", r.can_shootswitch)

        gold_door_upper_area = self.region(
            "Gold Door Upper",
            [
                "Secret (51)",
                "Quad Damage (33)",
                "Cells (90)",
                "Rocketlauncher (70)",
                "Large Medkit (20)",
                "Small Medkit (3)",
                "Large Medkit (21)",
                "Spikes (4)",
                "Megahealth (18)",
            ],
        )
        self.connect(
            past_gold_door_area,
            gold_door_upper_area,
            (r.jump & r.can_shootswitch) | r.bigjump_hard,
        )

        past_gold_button_area = self.region(
            "Past Gold Button",
            [
                "Cells (89)",
                "Invulnerability (59)",
                "Grenadelauncher (64)",
                "Spikes (103)",
                "Small Medkit (104)",
                "Quad Damage (93)",
                "Grenadelauncher (85)",
                "Rockets (12)",
                "Small Medkit (13)",
                "Cells (94)",
                "Supershotgun (86)",
                "Large Medkit (7)",
                "Spikes (26)",
                "Supershotgun (57)",
                "Spikes (8)",
                "Large Medkit (9)",
                "Supernailgun (66)",
                "Lightning (39)",
                "Large Medkit (28)",
                "Green Armor (19)",
                "Spikes (97)",
                "Rockets (60)",
                "Nailgun (87)",
                "Spikes (11)",
                "Large Medkit (27)",
                "Spikes (29)",
                "Cells (95)",
                "Shells (10)",
                "Cells (110)",
                "Shells (98)",
                "Spikes (40)",
                "Rockets (106)",
                "Quad Damage (44)",
                "Cells (96)",
                "Rockets (107)",
                "Rockets (108)",
                "Invulnerability (88)",
                "Quad Damage (76)",
                "Cells (77)",
                "Rockets (99)",
                "Cells (49)",
                "Shells (100)",
                "Small Medkit (50)",
                "Rocketlauncher (56)",
                "Silver Key (23)",
                "Cells (109)",
                "Small Medkit (47)",
                "Large Medkit (43)",
                "Rockets (48)",
                "All Kills (112)",
            ],
        )
        self.connect(past_gold_door_area, past_gold_button_area, r.can_button)

        self.restrict("All Kills (112)", r.difficult_combat)

        self.restrict("Invulnerability (88)", r.can_dive)
        self.restrict("Quad Damage (76)", r.can_dive)
        self.restrict("Cells (77)", r.can_dive)

        self.restrict("Spikes (103)", r.jump)
        self.restrict("Small Medkit (104)", r.jump)

        past_gold_button_upper_area = self.region(
            "Past Gold Button Upper",
            [
                "Cells (52)",
                "Secret (75)",
                "Cells (53)",
                "Large Medkit (74)",
                "Secret (54)",
                "Cells (71)",
                "Cells (55)",
                "Secret (46)",
                "Cells (45)",
                "Lightning (58)",
                "Yellow Armor (42)",
                "Invulnerability (41)",
            ],
        )

        self.connect(
            past_gold_button_area,
            past_gold_button_upper_area,
            (r.jump & r.can_shootswitch) | r.bigjump_hard,
        )
        self.restrict("Secret (54)", r.can_gj_extr | r.can_rj_hard | r.can_jump)
        self.restrict("Cells (71)", r.can_gj_extr | r.can_rj_hard | r.can_jump)
        self.restrict("Cells (55)", r.can_gj_extr | r.can_rj_hard | r.can_jump)
        self.restrict(
            "Secret (46)", r.can_dive & (r.difficulty("extreme") | r.biosuit(1))
        )
        self.restrict(
            "Cells (45)", r.can_dive & (r.difficulty("extreme") | r.biosuit(1))
        )
        self.restrict(
            "Lightning (58)", r.can_dive & (r.difficulty("extreme") | r.biosuit(1))
        )
        self.restrict(
            "Yellow Armor (42)", r.can_dive & (r.difficulty("extreme") | r.biosuit(1))
        )
        self.restrict(
            "Invulnerability (41)",
            r.can_dive & (r.difficulty("extreme") | r.biosuit(1)),
        )

        return ret
